/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.IdentityHashMap;
import java.util.Map;

public final class DataMap<K> {
    private final Map<DataKey<? extends K, ?>, Object> map = new IdentityHashMap();

    private DataMap() {
    }

    public <T> T set(DataKey<? extends K, ? super T> key, T data) {
        return (T)this.map.put(key, data);
    }

    public <T> T get(DataKey<? extends K, ? super T> key) {
        return (T)this.map.get(key);
    }

    public boolean isSet(DataKey<? extends K, ?> key) {
        return this.map.containsKey(key);
    }

    public static <K> DataMap<K> newDataMap() {
        return new DataMap<K>();
    }

    public static <T> SimpleDataKey<T> simpleDataKey(String name) {
        return new SimpleDataKey(name);
    }

    public static class SimpleDataKey<T>
    implements DataKey<SimpleDataKey<T>, T> {
        private final String name;

        SimpleDataKey(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface DataKey<K extends DataKey<K, T>, T> {
    }
}

