/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.JadtFactory;
import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.NewObject;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.TypeRefs;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.CollectionExpressionUtils;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.ObjectEmitMethods;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class NewSetInitExpression
extends Expression {
    private final Location loc;
    private final List<TypeRef> types;
    private final Expression init;
    private TypeInfo type;

    public NewSetInitExpression(AstNode definingNode, Expr.NewExpr expr, NewObject.NewSetInit x) {
        super(definingNode);
        this.loc = expr.loc;
        this.types = x.types;
        this.init = x.expr.map(value -> AstNodes.get().create((AstNode)this, (Expr)value)).orElse(NOOP);
    }

    static boolean isValidInit(SymbolResolver symbols, TypeInfo initType, TypeInfo elementType) {
        return TypeInfoEquivalence.isEquivalent(initType, GenericTypeInfoFactory.createList(symbols, elementType)) || TypeInfoEquivalence.isEquivalent(initType, GenericTypeInfoFactory.createSet(symbols, elementType));
    }

    public TypeRef getTypeRef() {
        return TypeRefs.newClassTypeRef(JadtFactory.SET, this.types);
    }

    public TypeInfo getTypeInfo() {
        return this.type;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.init.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.init.validate(symbols, scope);
        Errors errors = scope.getErrors();
        if (errors.isInvalid(this.init)) {
            errors.markInvalid(this);
            return;
        }
        if (this.types.size() != 1) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.parameterized.type.count", "Set", 1, this.types.size()));
            return;
        }
        TypeRef elementTypeRef = this.types.get(0);
        if (elementTypeRef == null) {
            errors.markInvalid(this);
            return;
        }
        TypeInfo elementType = symbols.lookupTypeInfo(this.getDefiningType(), elementTypeRef);
        if (!CollectionExpressionUtils.validateCollection(this.getDefiningType(), ImmutableList.of(elementType), scope, this)) {
            return;
        }
        if (this.init != Expression.NOOP && !NewSetInitExpression.isValidInit(symbols, this.init.getType(), elementType)) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.set.initializer", this.init.getType(), elementType));
            return;
        }
        this.type = GenericTypeInfoFactory.createSet(symbols, elementType);
        this.setType(this.type);
    }

    @Override
    public void emit(Emitter emitter) {
        AsmMethod constructor;
        String bytecodeName = TypeEraser.eraseBytecodeName(this.type);
        emitter.emitType(this.loc, 187, bytecodeName);
        emitter.emit(this.loc, 89);
        this.init.emit(emitter);
        if (this.init == Expression.NOOP) {
            emitter.push(this.loc, 0);
            emitter.box(TypeInfos.INTEGER);
            constructor = ObjectEmitMethods.constructor(bytecodeName, TypeInfos.INTEGER);
        } else {
            constructor = ObjectEmitMethods.constructor(bytecodeName, TypeInfos.OBJECT);
        }
        emitter.emit(this.loc, constructor);
        if (this.isTopLevel()) {
            emitter.emit(this.loc, 87);
        }
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public Expression getInit() {
        return this.init;
    }
}

