/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.TopLevel;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.StackScope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.PrintVisitor;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;

public abstract class Expression
implements AstNode {
    public static final Expression NOOP = new Expression(){

        @Override
        public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        }

        @Override
        public String toString() {
            return "Noop Expression";
        }

        @Override
        public TypeInfo getDefiningType() {
            throw new UnexpectedCodePathException();
        }

        @Override
        public void validate(SymbolResolver symbols, ValidationScope scope) {
        }

        @Override
        public void emit(Emitter emitter) {
        }
    };
    public static final Expression INVALID = new Expression(){

        @Override
        public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        }

        @Override
        public String toString() {
            return "Invalid Expression";
        }

        @Override
        public void validate(SymbolResolver symbols, ValidationScope scope) {
            scope.getErrors().markInvalid(this);
        }

        @Override
        public void emit(Emitter emitter) {
        }

        @Override
        public TypeInfo getDefiningType() {
            throw new UnexpectedCodePathException();
        }
    };
    private final AstNode definingNode;
    private final TypeInfo definingType;
    private TypeInfo type;
    private TopLevel topLevel;

    private Expression() {
        this((AstNode)null);
    }

    Expression(AstNode definingNode) {
        this.definingNode = definingNode;
        this.definingType = definingNode == null ? null : definingNode.getDefiningType();
        this.type = UnresolvedTypeInfoFactory.get();
        this.topLevel = TopLevel.NO;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public final void setType(TypeInfo type) {
        this.type = type;
    }

    public final boolean isTopLevel() {
        return this.topLevel == TopLevel.YES;
    }

    public void setTopLevel() {
        this.topLevel = TopLevel.YES;
    }

    public String toString() {
        return StackScope.evaluate(this, PrintVisitor.get());
    }

    public AstNode getDefiningNode() {
        return this.definingNode;
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }
}

