/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions.soql;

import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.impl.completions.CompletionItemBuilder;
import apex.jorje.lsp.impl.completions.soql.SoqlCompletionUtils;
import apex.jorje.lsp.impl.index.ApexIndex;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class SoqlSnippetCompletionStrategy
implements CompletionStrategy {
    private static final String SOQL_SNIPPET_LABEL = "SELECT {field} FROM {SObject}";
    private final Provider<ApexIndex> apexIndexProvider;

    @Inject
    public SoqlSnippetCompletionStrategy(Provider<ApexIndex> apexIndexProvider) {
        this.apexIndexProvider = apexIndexProvider;
    }

    @Override
    public List<CompletionItem> provideCompletions(TextDocumentPositionParams params) {
        return ImmutableList.of(SoqlSnippetCompletionStrategy.getSoqlSnippet(this.apexIndexProvider));
    }

    public static CompletionItem getSoqlSnippet(Provider<ApexIndex> apexIndexProvider) {
        CompletionItemBuilder builder = new CompletionItemBuilder(SOQL_SNIPPET_LABEL);
        String stringBuilder = "SELECT $0 FROM ${1|" + String.join((CharSequence)",", SoqlCompletionUtils.getSObjectTypeNames(apexIndexProvider)) + "|}";
        builder.kind(CompletionItemKind.Snippet).insertText(stringBuilder).insertTextFormat(InsertTextFormat.Snippet);
        return builder.build();
    }
}

