/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.semantic.ast.modifier.rule.IsTypeDeprecated;
import apex.jorje.semantic.ast.modifier.rule.RemoteActionContextRule;
import apex.jorje.semantic.ast.modifier.rule.WebServiceContextRule;
import apex.jorje.semantic.ast.visitor.reference.ExternalDependency;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.CompilationInput;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.compiler.Compiler;
import apex.jorje.semantic.compiler.CompilerContext;
import apex.jorje.semantic.compiler.CompilerService;
import apex.jorje.semantic.compiler.CompilerStage;
import apex.jorje.semantic.compiler.CompilerStageProcessor;
import apex.jorje.semantic.compiler.ErrorPropagator;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.ValidationSettings;
import apex.jorje.semantic.compiler.parser.ParserEngine;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.exception.CompilationException;
import com.google.common.base.Equivalence;
import com.google.common.collect.MoreLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ApexCompiler
implements Compiler,
CompilerService {
    private final CompilationInput input;
    private final ParserEngine originalParser;
    private final ParserEngine additionalParser;
    private final CompilerContext compilerContext;
    private final CompilerStageProcessor processor;
    private final Map<Equivalence.Wrapper<TypeInfo>, GenericTypeInfo> canonicalGenerics;
    private final Map<Equivalence.Wrapper<TypeInfo>, GenericTypeInfo> canonicalGenericsForQueryResultList;
    private final TypeInfoVisitor<Boolean> webServiceVisitor;
    private final TypeInfoVisitor<Boolean> remoteActionParameterVisitor;
    private final TypeInfoVisitor<Boolean> remoteActionReturnVisitor;
    private final Map<Namespace, TypeInfoVisitor<Boolean>> isDeprecatedVisitor;
    private final ParserEngine.HiddenTokenBehavior hiddenTokenBehavior;
    private final ValidationSettings validationSettings;
    private List<CodeUnit> allUnits;

    private ApexCompiler(Builder builder) {
        this.input = builder.input;
        this.originalParser = builder.parser;
        this.additionalParser = builder.additionalParser;
        this.hiddenTokenBehavior = builder.hiddenTokenBehavior;
        this.validationSettings = builder.validationSettings;
        this.canonicalGenerics = new HashMap<Equivalence.Wrapper<TypeInfo>, GenericTypeInfo>();
        this.canonicalGenericsForQueryResultList = new HashMap<Equivalence.Wrapper<TypeInfo>, GenericTypeInfo>();
        this.webServiceVisitor = WebServiceContextRule.createVisitor();
        this.remoteActionParameterVisitor = RemoteActionContextRule.createParameterVisitor(this.input.getAccessEvaluator());
        this.remoteActionReturnVisitor = RemoteActionContextRule.createReturnVisitor(this.input.getAccessEvaluator());
        this.compilerContext = new CompilerContext(this);
        this.processor = new CompilerStageProcessor(this.compilerContext);
        this.isDeprecatedVisitor = new HashMap<Namespace, TypeInfoVisitor<Boolean>>();
    }

    public static Builder builder() {
        return new Builder();
    }

    public CompilationInput getInput() {
        return this.input;
    }

    public CompilerContext getCompilerContext() {
        return this.compilerContext;
    }

    @Override
    public List<CodeUnit> compile() {
        return this.compile(CompilerStage.EMIT);
    }

    public List<CodeUnit> compile(CompilerStage stage) {
        assert (this.allUnits == null);
        this.allUnits = new ArrayList<CodeUnit>(this.input.getSourceFiles().size());
        for (SourceFile sourceFile : this.input.getSourceFiles()) {
            this.allUnits.add(new CodeUnit(this.originalParser, sourceFile));
        }
        this.processor.addUnits(this.allUnits);
        this.processor.processToStage(stage);
        this.compilerContext.getEmitter().assertEmpty();
        return this.allUnits;
    }

    @Override
    public TypeInfo attachCodeUnit(SymbolResolver symbolResolver, CodeUnit codeUnit) {
        this.allUnits.add(codeUnit);
        symbolResolver.add(codeUnit.getType());
        for (CompilationOutput innerOutput : codeUnit.getOutput().getInnerOutputs().values()) {
            symbolResolver.add(innerOutput.getType());
        }
        return codeUnit.getType();
    }

    @Override
    public TypeInfo attachSource(SymbolResolver symbolResolver, SourceFile sourceFile, String fullNameLower) {
        CodeUnit newCodeUnit = new CodeUnit(this.additionalParser, sourceFile);
        this.allUnits.add(newCodeUnit);
        this.processor.addUnit(newCodeUnit);
        CompilerStage currentStage = this.processor.getCurrentStage();
        this.processor.processToStage(currentStage);
        if (currentStage == CompilerStage.EMIT && this.processor.allUnitsEmitted()) {
            ErrorPropagator.get().propagateErrors(this.allUnits);
        }
        return fullNameLower.lastIndexOf(36) == -1 ? newCodeUnit.getType() : symbolResolver.get(fullNameLower);
    }

    @Override
    public Map<Equivalence.Wrapper<TypeInfo>, GenericTypeInfo> getCanonicalGenerics() {
        return this.canonicalGenerics;
    }

    @Override
    public Map<Equivalence.Wrapper<TypeInfo>, GenericTypeInfo> getCanonicalGenericsForQueryResultList() {
        return this.canonicalGenericsForQueryResultList;
    }

    @Override
    public TypeInfoVisitor<Boolean> getWebServiceVisitor() {
        return this.webServiceVisitor;
    }

    @Override
    public TypeInfoVisitor<Boolean> getRemoteActionParameterVisitor() {
        return this.remoteActionParameterVisitor;
    }

    @Override
    public TypeInfoVisitor<Boolean> getRemoteActionReturnVisitor() {
        return this.remoteActionReturnVisitor;
    }

    @Override
    public TypeInfoVisitor<Boolean> getIsDeprecatedVisitor(TypeInfo type) {
        return this.isDeprecatedVisitor.computeIfAbsent(type.getNamespace(), IsTypeDeprecated::new);
    }

    @Override
    @SfdcCalled
    public CodeUnit getCodeUnit(TypeInfo typeInfo) {
        TypeInfo topLevelType = TypeInfoUtil.getTopLevel(typeInfo);
        for (CodeUnit unit : this.allUnits) {
            if (unit.getType() != topLevelType) continue;
            return unit;
        }
        return null;
    }

    @SfdcCalled
    public List<CodeUnit> getCodeUnits() {
        return this.allUnits;
    }

    public List<CompilationOutput> compileThrowErrors() {
        List<CodeUnit> units = this.compile();
        this.throwErrorsIfAny();
        return units.stream().map(CodeUnit::getOutput).collect(MoreLists.toImmutableList(units.size()));
    }

    public List<CompilationException> getErrors() {
        int size = this.allUnits.stream().mapToInt(unit -> unit.getErrors().get().size()).reduce((x, y) -> x + y).orElse(0);
        return this.allUnits.stream().map(unit -> unit.getErrors().get()).flatMap(Collection::stream).collect(MoreLists.toImmutableList(size));
    }

    @SfdcCalled
    public void throwErrorsIfAny() {
        List<CompilationException> errors = this.getErrors();
        if (!errors.isEmpty()) {
            throw errors.get(0);
        }
    }

    public Map<String, List<ExternalDependency>> getReferences() {
        return this.allUnits.stream().filter(unit -> !unit.getReferences().isEmpty()).collect(Collectors.toMap(unit -> unit.getType().getApexName(), CodeUnit::getReferences));
    }

    ParserEngine.HiddenTokenBehavior getHiddenTokenBehavior() {
        return this.hiddenTokenBehavior;
    }

    ValidationSettings getValidationSettings() {
        return this.validationSettings;
    }

    public static class Builder {
        private final ParserEngine additionalParser;
        private CompilationInput input;
        private ParserEngine parser;
        private ParserEngine.HiddenTokenBehavior hiddenTokenBehavior;
        private ValidationSettings validationSettings;

        private Builder() {
            this.parser = this.additionalParser = ParserEngine.get(ParserEngine.Type.NAMED);
            this.hiddenTokenBehavior = ParserEngine.HiddenTokenBehavior.IGNORE;
            this.validationSettings = ValidationSettings.getServerCompileSettings();
        }

        public ApexCompiler build() {
            assert (this.input != null) : "Cannot build compiler without inputs";
            return new ApexCompiler(this);
        }

        public Builder setInput(CompilationInput input) {
            this.input = input;
            return this;
        }

        public Builder setParserType(ParserEngine.Type parserType) {
            this.parser = ParserEngine.get(parserType);
            return this;
        }

        public Builder setHiddenTokenBehavior(ParserEngine.HiddenTokenBehavior hiddenTokenBehavior) {
            this.hiddenTokenBehavior = hiddenTokenBehavior;
            return this;
        }

        public Builder setValidationSettings(ValidationSettings validationSettings) {
            this.validationSettings = validationSettings;
            return this;
        }
    }
}

