/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.cpd.CPDCommandLineInterface;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CPDNullListener;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.MatchAlgorithm;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.ast.TokenMgrError;
import net.sourceforge.pmd.util.FileFinder;
import net.sourceforge.pmd.util.database.DBMSMetadata;
import net.sourceforge.pmd.util.database.DBURI;
import net.sourceforge.pmd.util.database.SourceObject;
import org.apache.commons.io.FilenameUtils;

public class CPD {
    private static final Logger LOGGER = Logger.getLogger(CPD.class.getName());
    private CPDConfiguration configuration;
    private Map<String, SourceCode> source = new TreeMap<String, SourceCode>();
    private CPDListener listener = new CPDNullListener();
    private Tokens tokens = new Tokens();
    private MatchAlgorithm matchAlgorithm;
    private Set<String> current = new HashSet<String>();

    public CPD(CPDConfiguration theConfiguration) {
        this.configuration = theConfiguration;
        TokenEntry.clearImages();
    }

    public void setCpdListener(CPDListener cpdListener) {
        this.listener = cpdListener;
    }

    public void go() {
        this.matchAlgorithm = new MatchAlgorithm(this.source, this.tokens, this.configuration.getMinimumTileSize(), this.listener);
        this.matchAlgorithm.findMatches();
    }

    public Iterator<Match> getMatches() {
        return this.matchAlgorithm.matches();
    }

    public void addAllInDirectory(File dir) throws IOException {
        this.addDirectory(dir, false);
    }

    public void addRecursively(File dir) throws IOException {
        this.addDirectory(dir, true);
    }

    public void add(List<File> files) throws IOException {
        for (File f : files) {
            this.add(f);
        }
    }

    private void addDirectory(File dir, boolean recurse) throws IOException {
        if (!dir.exists()) {
            throw new FileNotFoundException("Couldn't find directory " + dir);
        }
        FileFinder finder = new FileFinder();
        this.add(finder.findFilesFrom(dir, this.configuration.filenameFilter(), recurse));
    }

    public void add(File file) throws IOException {
        if (this.configuration.isSkipDuplicates()) {
            String signature = file.getName() + '_' + file.length();
            if (this.current.contains(signature)) {
                System.err.println("Skipping " + file.getAbsolutePath() + " since it appears to be a duplicate file and --skip-duplicate-files is set");
                return;
            }
            this.current.add(signature);
        }
        if (!FilenameUtils.equalsNormalizedOnSystem((String)file.getAbsoluteFile().getCanonicalPath(), (String)file.getAbsolutePath())) {
            System.err.println("Skipping " + file + " since it appears to be a symlink");
            return;
        }
        if (!file.exists()) {
            System.err.println("Skipping " + file + " since it doesn't exist (broken symlink?)");
            return;
        }
        SourceCode sourceCode = this.configuration.sourceCodeFor(file);
        this.add(sourceCode);
    }

    public void add(DBURI dburi) throws IOException {
        try {
            DBMSMetadata dbmsmetadata = new DBMSMetadata(dburi);
            List<SourceObject> sourceObjectList = dbmsmetadata.getSourceObjectList();
            LOGGER.log(Level.FINER, "Located {0} database source objects", sourceObjectList.size());
            for (SourceObject sourceObject : sourceObjectList) {
                String falseFilePath = sourceObject.getPseudoFileName();
                LOGGER.log(Level.FINEST, "Adding database source object {0}", falseFilePath);
                SourceCode sourceCode = this.configuration.sourceCodeFor(dbmsmetadata.getSourceCode(sourceObject), falseFilePath);
                this.add(sourceCode);
            }
        }
        catch (Exception sqlException) {
            LOGGER.log(Level.SEVERE, "Problem with Input URI", sqlException);
            throw new RuntimeException("Problem with DBURI: " + dburi, sqlException);
        }
    }

    @Experimental
    public void add(SourceCode sourceCode) throws IOException {
        if (this.configuration.isSkipLexicalErrors()) {
            this.addAndSkipLexicalErrors(sourceCode);
        } else {
            this.addAndThrowLexicalError(sourceCode);
        }
    }

    private void addAndThrowLexicalError(SourceCode sourceCode) throws IOException {
        this.configuration.tokenizer().tokenize(sourceCode, this.tokens);
        this.listener.addedFile(1, new File(sourceCode.getFileName()));
        this.source.put(sourceCode.getFileName(), sourceCode);
    }

    private void addAndSkipLexicalErrors(SourceCode sourceCode) throws IOException {
        TokenEntry.State savedTokenEntry = new TokenEntry.State(this.tokens.getTokens());
        try {
            this.addAndThrowLexicalError(sourceCode);
        }
        catch (TokenMgrError e) {
            System.err.println("Skipping " + sourceCode.getFileName() + ". Reason: " + e.getMessage());
            this.tokens.getTokens().clear();
            this.tokens.getTokens().addAll(savedTokenEntry.restore());
        }
    }

    public List<String> getSourcePaths() {
        return new ArrayList<String>(this.source.keySet());
    }

    public List<SourceCode> getSources() {
        return new ArrayList<SourceCode>(this.source.values());
    }

    public static void main(String[] args) {
        CPDCommandLineInterface.main(args);
    }
}

