/*
 * Copyright (C) 2019 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

/*
 * Caution!
 * This file generated by the script "utils/lexbor/encoding/multi-byte.py"!
 * Do not change this file!
 */

#include "lexbor/encoding/base.h"

#include "lexbor/core/shs.h"


LXB_API const lxb_encoding_multi_index_t lxb_encoding_multi_index_jis0208[11104] = 
{
    {{'\xe3', '\x80', '\x80'}, 3, 0x3000}, /* (IDEOGRAPHIC SPACE) */
    {{'\xe3', '\x80', '\x81'}, 3, 0x3001}, /* (IDEOGRAPHIC COMMA) */
    {{'\xe3', '\x80', '\x82'}, 3, 0x3002}, /* (IDEOGRAPHIC FULL STOP) */
    {{'\xef', '\xbc', '\x8c'}, 3, 0xFF0C}, /* (FULLWIDTH COMMA) */
    {{'\xef', '\xbc', '\x8e'}, 3, 0xFF0E}, /* (FULLWIDTH FULL STOP) */
    {{'\xe3', '\x83', '\xbb'}, 3, 0x30FB}, /* (KATAKANA MIDDLE DOT) */
    {{'\xef', '\xbc', '\x9a'}, 3, 0xFF1A}, /* (FULLWIDTH COLON) */
    {{'\xef', '\xbc', '\x9b'}, 3, 0xFF1B}, /* (FULLWIDTH SEMICOLON) */
    {{'\xef', '\xbc', '\x9f'}, 3, 0xFF1F}, /* (FULLWIDTH QUESTION MARK) */
    {{'\xef', '\xbc', '\x81'}, 3, 0xFF01}, /* (FULLWIDTH EXCLAMATION MARK) */
    {{'\xe3', '\x82', '\x9b'}, 3, 0x309B}, /* (KATAKANA-HIRAGANA VOICED SOUND MARK) */
    {{'\xe3', '\x82', '\x9c'}, 3, 0x309C}, /* (KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK) */
    {{'\xc2', '\xb4'}, 2, 0x00B4}, /* (ACUTE ACCENT) */
    {{'\xef', '\xbd', '\x80'}, 3, 0xFF40}, /* (FULLWIDTH GRAVE ACCENT) */
    {{'\xc2', '\xa8'}, 2, 0x00A8}, /* (DIAERESIS) */
    {{'\xef', '\xbc', '\xbe'}, 3, 0xFF3E}, /* (FULLWIDTH CIRCUMFLEX ACCENT) */
    {{'\xef', '\xbf', '\xa3'}, 3, 0xFFE3}, /* (FULLWIDTH MACRON) */
    {{'\xef', '\xbc', '\xbf'}, 3, 0xFF3F}, /* (FULLWIDTH LOW LINE) */
    {{'\xe3', '\x83', '\xbd'}, 3, 0x30FD}, /* (KATAKANA ITERATION MARK) */
    {{'\xe3', '\x83', '\xbe'}, 3, 0x30FE}, /* (KATAKANA VOICED ITERATION MARK) */
    {{'\xe3', '\x82', '\x9d'}, 3, 0x309D}, /* (HIRAGANA ITERATION MARK) */
    {{'\xe3', '\x82', '\x9e'}, 3, 0x309E}, /* (HIRAGANA VOICED ITERATION MARK) */
    {{'\xe3', '\x80', '\x83'}, 3, 0x3003}, /* (DITTO MARK) */
    {{'\xe4', '\xbb', '\x9d'}, 3, 0x4EDD}, /* (<CJK Ideograph>) */
    {{'\xe3', '\x80', '\x85'}, 3, 0x3005}, /* (IDEOGRAPHIC ITERATION MARK) */
    {{'\xe3', '\x80', '\x86'}, 3, 0x3006}, /* (IDEOGRAPHIC CLOSING MARK) */
    {{'\xe3', '\x80', '\x87'}, 3, 0x3007}, /* (IDEOGRAPHIC NUMBER ZERO) */
    {{'\xe3', '\x83', '\xbc'}, 3, 0x30FC}, /* (KATAKANA-HIRAGANA PROLONGED SOUND MARK) */
    {{'\xe2', '\x80', '\x95'}, 3, 0x2015}, /* (HORIZONTAL BAR) */
    {{'\xe2', '\x80', '\x90'}, 3, 0x2010}, /* (HYPHEN) */
    {{'\xef', '\xbc', '\x8f'}, 3, 0xFF0F}, /* (FULLWIDTH SOLIDUS) */
    {{'\xef', '\xbc', '\xbc'}, 3, 0xFF3C}, /* (FULLWIDTH REVERSE SOLIDUS) */
    {{'\xef', '\xbd', '\x9e'}, 3, 0xFF5E}, /* (FULLWIDTH TILDE) */
    {{'\xe2', '\x88', '\xa5'}, 3, 0x2225}, /* (PARALLEL TO) */
    {{'\xef', '\xbd', '\x9c'}, 3, 0xFF5C}, /* (FULLWIDTH VERTICAL LINE) */
    {{'\xe2', '\x80', '\xa6'}, 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {{'\xe2', '\x80', '\xa5'}, 3, 0x2025}, /* (TWO DOT LEADER) */
    {{'\xe2', '\x80', '\x98'}, 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x99'}, 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9c'}, 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9d'}, 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {{'\xef', '\xbc', '\x88'}, 3, 0xFF08}, /* (FULLWIDTH LEFT PARENTHESIS) */
    {{'\xef', '\xbc', '\x89'}, 3, 0xFF09}, /* (FULLWIDTH RIGHT PARENTHESIS) */
    {{'\xe3', '\x80', '\x94'}, 3, 0x3014}, /* (LEFT TORTOISE SHELL BRACKET) */
    {{'\xe3', '\x80', '\x95'}, 3, 0x3015}, /* (RIGHT TORTOISE SHELL BRACKET) */
    {{'\xef', '\xbc', '\xbb'}, 3, 0xFF3B}, /* (FULLWIDTH LEFT SQUARE BRACKET) */
    {{'\xef', '\xbc', '\xbd'}, 3, 0xFF3D}, /* (FULLWIDTH RIGHT SQUARE BRACKET) */
    {{'\xef', '\xbd', '\x9b'}, 3, 0xFF5B}, /* (FULLWIDTH LEFT CURLY BRACKET) */
    {{'\xef', '\xbd', '\x9d'}, 3, 0xFF5D}, /* (FULLWIDTH RIGHT CURLY BRACKET) */
    {{'\xe3', '\x80', '\x88'}, 3, 0x3008}, /* (LEFT ANGLE BRACKET) */
    {{'\xe3', '\x80', '\x89'}, 3, 0x3009}, /* (RIGHT ANGLE BRACKET) */
    {{'\xe3', '\x80', '\x8a'}, 3, 0x300A}, /* (LEFT DOUBLE ANGLE BRACKET) */
    {{'\xe3', '\x80', '\x8b'}, 3, 0x300B}, /* (RIGHT DOUBLE ANGLE BRACKET) */
    {{'\xe3', '\x80', '\x8c'}, 3, 0x300C}, /* (LEFT CORNER BRACKET) */
    {{'\xe3', '\x80', '\x8d'}, 3, 0x300D}, /* (RIGHT CORNER BRACKET) */
    {{'\xe3', '\x80', '\x8e'}, 3, 0x300E}, /* (LEFT WHITE CORNER BRACKET) */
    {{'\xe3', '\x80', '\x8f'}, 3, 0x300F}, /* (RIGHT WHITE CORNER BRACKET) */
    {{'\xe3', '\x80', '\x90'}, 3, 0x3010}, /* (LEFT BLACK LENTICULAR BRACKET) */
    {{'\xe3', '\x80', '\x91'}, 3, 0x3011}, /* (RIGHT BLACK LENTICULAR BRACKET) */
    {{'\xef', '\xbc', '\x8b'}, 3, 0xFF0B}, /* (FULLWIDTH PLUS SIGN) */
    {{'\xef', '\xbc', '\x8d'}, 3, 0xFF0D}, /* (FULLWIDTH HYPHEN-MINUS) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xc3', '\x97'}, 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xef', '\xbc', '\x9d'}, 3, 0xFF1D}, /* (FULLWIDTH EQUALS SIGN) */
    {{'\xe2', '\x89', '\xa0'}, 3, 0x2260}, /* (NOT EQUAL TO) */
    {{'\xef', '\xbc', '\x9c'}, 3, 0xFF1C}, /* (FULLWIDTH LESS-THAN SIGN) */
    {{'\xef', '\xbc', '\x9e'}, 3, 0xFF1E}, /* (FULLWIDTH GREATER-THAN SIGN) */
    {{'\xe2', '\x89', '\xa6'}, 3, 0x2266}, /* (LESS-THAN OVER EQUAL TO) */
    {{'\xe2', '\x89', '\xa7'}, 3, 0x2267}, /* (GREATER-THAN OVER EQUAL TO) */
    {{'\xe2', '\x88', '\x9e'}, 3, 0x221E}, /* (INFINITY) */
    {{'\xe2', '\x88', '\xb4'}, 3, 0x2234}, /* (THEREFORE) */
    {{'\xe2', '\x99', '\x82'}, 3, 0x2642}, /* (MALE SIGN) */
    {{'\xe2', '\x99', '\x80'}, 3, 0x2640}, /* (FEMALE SIGN) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xe2', '\x80', '\xb2'}, 3, 0x2032}, /* (PRIME) */
    {{'\xe2', '\x80', '\xb3'}, 3, 0x2033}, /* (DOUBLE PRIME) */
    {{'\xe2', '\x84', '\x83'}, 3, 0x2103}, /* (DEGREE CELSIUS) */
    {{'\xef', '\xbf', '\xa5'}, 3, 0xFFE5}, /* (FULLWIDTH YEN SIGN) */
    {{'\xef', '\xbc', '\x84'}, 3, 0xFF04}, /* (FULLWIDTH DOLLAR SIGN) */
    {{'\xef', '\xbf', '\xa0'}, 3, 0xFFE0}, /* (FULLWIDTH CENT SIGN) */
    {{'\xef', '\xbf', '\xa1'}, 3, 0xFFE1}, /* (FULLWIDTH POUND SIGN) */
    {{'\xef', '\xbc', '\x85'}, 3, 0xFF05}, /* (FULLWIDTH PERCENT SIGN) */
    {{'\xef', '\xbc', '\x83'}, 3, 0xFF03}, /* (FULLWIDTH NUMBER SIGN) */
    {{'\xef', '\xbc', '\x86'}, 3, 0xFF06}, /* (FULLWIDTH AMPERSAND) */
    {{'\xef', '\xbc', '\x8a'}, 3, 0xFF0A}, /* (FULLWIDTH ASTERISK) */
    {{'\xef', '\xbc', '\xa0'}, 3, 0xFF20}, /* (FULLWIDTH COMMERCIAL AT) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xe2', '\x98', '\x86'}, 3, 0x2606}, /* (WHITE STAR) */
    {{'\xe2', '\x98', '\x85'}, 3, 0x2605}, /* (BLACK STAR) */
    {{'\xe2', '\x97', '\x8b'}, 3, 0x25CB}, /* (WHITE CIRCLE) */
    {{'\xe2', '\x97', '\x8f'}, 3, 0x25CF}, /* (BLACK CIRCLE) */
    {{'\xe2', '\x97', '\x8e'}, 3, 0x25CE}, /* (BULLSEYE) */
    {{'\xe2', '\x97', '\x87'}, 3, 0x25C7}, /* (WHITE DIAMOND) */
    {{'\xe2', '\x97', '\x86'}, 3, 0x25C6}, /* (BLACK DIAMOND) */
    {{'\xe2', '\x96', '\xa1'}, 3, 0x25A1}, /* (WHITE SQUARE) */
    {{'\xe2', '\x96', '\xa0'}, 3, 0x25A0}, /* (BLACK SQUARE) */
    {{'\xe2', '\x96', '\xb3'}, 3, 0x25B3}, /* (WHITE UP-POINTING TRIANGLE) */
    {{'\xe2', '\x96', '\xb2'}, 3, 0x25B2}, /* (BLACK UP-POINTING TRIANGLE) */
    {{'\xe2', '\x96', '\xbd'}, 3, 0x25BD}, /* (WHITE DOWN-POINTING TRIANGLE) */
    {{'\xe2', '\x96', '\xbc'}, 3, 0x25BC}, /* (BLACK DOWN-POINTING TRIANGLE) */
    {{'\xe2', '\x80', '\xbb'}, 3, 0x203B}, /* (REFERENCE MARK) */
    {{'\xe3', '\x80', '\x92'}, 3, 0x3012}, /* (POSTAL MARK) */
    {{'\xe2', '\x86', '\x92'}, 3, 0x2192}, /* (RIGHTWARDS ARROW) */
    {{'\xe2', '\x86', '\x90'}, 3, 0x2190}, /* (LEFTWARDS ARROW) */
    {{'\xe2', '\x86', '\x91'}, 3, 0x2191}, /* (UPWARDS ARROW) */
    {{'\xe2', '\x86', '\x93'}, 3, 0x2193}, /* (DOWNWARDS ARROW) */
    {{'\xe3', '\x80', '\x93'}, 3, 0x3013}, /* (GETA MARK) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe2', '\x88', '\x88'}, 3, 0x2208}, /* (ELEMENT OF) */
    {{'\xe2', '\x88', '\x8b'}, 3, 0x220B}, /* (CONTAINS AS MEMBER) */
    {{'\xe2', '\x8a', '\x86'}, 3, 0x2286}, /* (SUBSET OF OR EQUAL TO) */
    {{'\xe2', '\x8a', '\x87'}, 3, 0x2287}, /* (SUPERSET OF OR EQUAL TO) */
    {{'\xe2', '\x8a', '\x82'}, 3, 0x2282}, /* (SUBSET OF) */
    {{'\xe2', '\x8a', '\x83'}, 3, 0x2283}, /* (SUPERSET OF) */
    {{'\xe2', '\x88', '\xaa'}, 3, 0x222A}, /* (UNION) */
    {{'\xe2', '\x88', '\xa9'}, 3, 0x2229}, /* (INTERSECTION) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe2', '\x88', '\xa7'}, 3, 0x2227}, /* (LOGICAL AND) */
    {{'\xe2', '\x88', '\xa8'}, 3, 0x2228}, /* (LOGICAL OR) */
    {{'\xef', '\xbf', '\xa2'}, 3, 0xFFE2}, /* (FULLWIDTH NOT SIGN) */
    {{'\xe2', '\x87', '\x92'}, 3, 0x21D2}, /* (RIGHTWARDS DOUBLE ARROW) */
    {{'\xe2', '\x87', '\x94'}, 3, 0x21D4}, /* (LEFT RIGHT DOUBLE ARROW) */
    {{'\xe2', '\x88', '\x80'}, 3, 0x2200}, /* (FOR ALL) */
    {{'\xe2', '\x88', '\x83'}, 3, 0x2203}, /* (THERE EXISTS) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe2', '\x88', '\xa0'}, 3, 0x2220}, /* (ANGLE) */
    {{'\xe2', '\x8a', '\xa5'}, 3, 0x22A5}, /* (UP TACK) */
    {{'\xe2', '\x8c', '\x92'}, 3, 0x2312}, /* (ARC) */
    {{'\xe2', '\x88', '\x82'}, 3, 0x2202}, /* (PARTIAL DIFFERENTIAL) */
    {{'\xe2', '\x88', '\x87'}, 3, 0x2207}, /* (NABLA) */
    {{'\xe2', '\x89', '\xa1'}, 3, 0x2261}, /* (IDENTICAL TO) */
    {{'\xe2', '\x89', '\x92'}, 3, 0x2252}, /* (APPROXIMATELY EQUAL TO OR THE IMAGE OF) */
    {{'\xe2', '\x89', '\xaa'}, 3, 0x226A}, /* (MUCH LESS-THAN) */
    {{'\xe2', '\x89', '\xab'}, 3, 0x226B}, /* (MUCH GREATER-THAN) */
    {{'\xe2', '\x88', '\x9a'}, 3, 0x221A}, /* (SQUARE ROOT) */
    {{'\xe2', '\x88', '\xbd'}, 3, 0x223D}, /* (REVERSED TILDE) */
    {{'\xe2', '\x88', '\x9d'}, 3, 0x221D}, /* (PROPORTIONAL TO) */
    {{'\xe2', '\x88', '\xb5'}, 3, 0x2235}, /* (BECAUSE) */
    {{'\xe2', '\x88', '\xab'}, 3, 0x222B}, /* (INTEGRAL) */
    {{'\xe2', '\x88', '\xac'}, 3, 0x222C}, /* (DOUBLE INTEGRAL) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe2', '\x84', '\xab'}, 3, 0x212B}, /* (ANGSTROM SIGN) */
    {{'\xe2', '\x80', '\xb0'}, 3, 0x2030}, /* (PER MILLE SIGN) */
    {{'\xe2', '\x99', '\xaf'}, 3, 0x266F}, /* (MUSIC SHARP SIGN) */
    {{'\xe2', '\x99', '\xad'}, 3, 0x266D}, /* (MUSIC FLAT SIGN) */
    {{'\xe2', '\x99', '\xaa'}, 3, 0x266A}, /* (EIGHTH NOTE) */
    {{'\xe2', '\x80', '\xa0'}, 3, 0x2020}, /* (DAGGER) */
    {{'\xe2', '\x80', '\xa1'}, 3, 0x2021}, /* (DOUBLE DAGGER) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe2', '\x97', '\xaf'}, 3, 0x25EF}, /* (LARGE CIRCLE) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xef', '\xbc', '\x90'}, 3, 0xFF10}, /* (FULLWIDTH DIGIT ZERO) */
    {{'\xef', '\xbc', '\x91'}, 3, 0xFF11}, /* (FULLWIDTH DIGIT ONE) */
    {{'\xef', '\xbc', '\x92'}, 3, 0xFF12}, /* (FULLWIDTH DIGIT TWO) */
    {{'\xef', '\xbc', '\x93'}, 3, 0xFF13}, /* (FULLWIDTH DIGIT THREE) */
    {{'\xef', '\xbc', '\x94'}, 3, 0xFF14}, /* (FULLWIDTH DIGIT FOUR) */
    {{'\xef', '\xbc', '\x95'}, 3, 0xFF15}, /* (FULLWIDTH DIGIT FIVE) */
    {{'\xef', '\xbc', '\x96'}, 3, 0xFF16}, /* (FULLWIDTH DIGIT SIX) */
    {{'\xef', '\xbc', '\x97'}, 3, 0xFF17}, /* (FULLWIDTH DIGIT SEVEN) */
    {{'\xef', '\xbc', '\x98'}, 3, 0xFF18}, /* (FULLWIDTH DIGIT EIGHT) */
    {{'\xef', '\xbc', '\x99'}, 3, 0xFF19}, /* (FULLWIDTH DIGIT NINE) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xef', '\xbc', '\xa1'}, 3, 0xFF21}, /* (FULLWIDTH LATIN CAPITAL LETTER A) */
    {{'\xef', '\xbc', '\xa2'}, 3, 0xFF22}, /* (FULLWIDTH LATIN CAPITAL LETTER B) */
    {{'\xef', '\xbc', '\xa3'}, 3, 0xFF23}, /* (FULLWIDTH LATIN CAPITAL LETTER C) */
    {{'\xef', '\xbc', '\xa4'}, 3, 0xFF24}, /* (FULLWIDTH LATIN CAPITAL LETTER D) */
    {{'\xef', '\xbc', '\xa5'}, 3, 0xFF25}, /* (FULLWIDTH LATIN CAPITAL LETTER E) */
    {{'\xef', '\xbc', '\xa6'}, 3, 0xFF26}, /* (FULLWIDTH LATIN CAPITAL LETTER F) */
    {{'\xef', '\xbc', '\xa7'}, 3, 0xFF27}, /* (FULLWIDTH LATIN CAPITAL LETTER G) */
    {{'\xef', '\xbc', '\xa8'}, 3, 0xFF28}, /* (FULLWIDTH LATIN CAPITAL LETTER H) */
    {{'\xef', '\xbc', '\xa9'}, 3, 0xFF29}, /* (FULLWIDTH LATIN CAPITAL LETTER I) */
    {{'\xef', '\xbc', '\xaa'}, 3, 0xFF2A}, /* (FULLWIDTH LATIN CAPITAL LETTER J) */
    {{'\xef', '\xbc', '\xab'}, 3, 0xFF2B}, /* (FULLWIDTH LATIN CAPITAL LETTER K) */
    {{'\xef', '\xbc', '\xac'}, 3, 0xFF2C}, /* (FULLWIDTH LATIN CAPITAL LETTER L) */
    {{'\xef', '\xbc', '\xad'}, 3, 0xFF2D}, /* (FULLWIDTH LATIN CAPITAL LETTER M) */
    {{'\xef', '\xbc', '\xae'}, 3, 0xFF2E}, /* (FULLWIDTH LATIN CAPITAL LETTER N) */
    {{'\xef', '\xbc', '\xaf'}, 3, 0xFF2F}, /* (FULLWIDTH LATIN CAPITAL LETTER O) */
    {{'\xef', '\xbc', '\xb0'}, 3, 0xFF30}, /* (FULLWIDTH LATIN CAPITAL LETTER P) */
    {{'\xef', '\xbc', '\xb1'}, 3, 0xFF31}, /* (FULLWIDTH LATIN CAPITAL LETTER Q) */
    {{'\xef', '\xbc', '\xb2'}, 3, 0xFF32}, /* (FULLWIDTH LATIN CAPITAL LETTER R) */
    {{'\xef', '\xbc', '\xb3'}, 3, 0xFF33}, /* (FULLWIDTH LATIN CAPITAL LETTER S) */
    {{'\xef', '\xbc', '\xb4'}, 3, 0xFF34}, /* (FULLWIDTH LATIN CAPITAL LETTER T) */
    {{'\xef', '\xbc', '\xb5'}, 3, 0xFF35}, /* (FULLWIDTH LATIN CAPITAL LETTER U) */
    {{'\xef', '\xbc', '\xb6'}, 3, 0xFF36}, /* (FULLWIDTH LATIN CAPITAL LETTER V) */
    {{'\xef', '\xbc', '\xb7'}, 3, 0xFF37}, /* (FULLWIDTH LATIN CAPITAL LETTER W) */
    {{'\xef', '\xbc', '\xb8'}, 3, 0xFF38}, /* (FULLWIDTH LATIN CAPITAL LETTER X) */
    {{'\xef', '\xbc', '\xb9'}, 3, 0xFF39}, /* (FULLWIDTH LATIN CAPITAL LETTER Y) */
    {{'\xef', '\xbc', '\xba'}, 3, 0xFF3A}, /* (FULLWIDTH LATIN CAPITAL LETTER Z) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xef', '\xbd', '\x81'}, 3, 0xFF41}, /* (FULLWIDTH LATIN SMALL LETTER A) */
    {{'\xef', '\xbd', '\x82'}, 3, 0xFF42}, /* (FULLWIDTH LATIN SMALL LETTER B) */
    {{'\xef', '\xbd', '\x83'}, 3, 0xFF43}, /* (FULLWIDTH LATIN SMALL LETTER C) */
    {{'\xef', '\xbd', '\x84'}, 3, 0xFF44}, /* (FULLWIDTH LATIN SMALL LETTER D) */
    {{'\xef', '\xbd', '\x85'}, 3, 0xFF45}, /* (FULLWIDTH LATIN SMALL LETTER E) */
    {{'\xef', '\xbd', '\x86'}, 3, 0xFF46}, /* (FULLWIDTH LATIN SMALL LETTER F) */
    {{'\xef', '\xbd', '\x87'}, 3, 0xFF47}, /* (FULLWIDTH LATIN SMALL LETTER G) */
    {{'\xef', '\xbd', '\x88'}, 3, 0xFF48}, /* (FULLWIDTH LATIN SMALL LETTER H) */
    {{'\xef', '\xbd', '\x89'}, 3, 0xFF49}, /* (FULLWIDTH LATIN SMALL LETTER I) */
    {{'\xef', '\xbd', '\x8a'}, 3, 0xFF4A}, /* (FULLWIDTH LATIN SMALL LETTER J) */
    {{'\xef', '\xbd', '\x8b'}, 3, 0xFF4B}, /* (FULLWIDTH LATIN SMALL LETTER K) */
    {{'\xef', '\xbd', '\x8c'}, 3, 0xFF4C}, /* (FULLWIDTH LATIN SMALL LETTER L) */
    {{'\xef', '\xbd', '\x8d'}, 3, 0xFF4D}, /* (FULLWIDTH LATIN SMALL LETTER M) */
    {{'\xef', '\xbd', '\x8e'}, 3, 0xFF4E}, /* (FULLWIDTH LATIN SMALL LETTER N) */
    {{'\xef', '\xbd', '\x8f'}, 3, 0xFF4F}, /* (FULLWIDTH LATIN SMALL LETTER O) */
    {{'\xef', '\xbd', '\x90'}, 3, 0xFF50}, /* (FULLWIDTH LATIN SMALL LETTER P) */
    {{'\xef', '\xbd', '\x91'}, 3, 0xFF51}, /* (FULLWIDTH LATIN SMALL LETTER Q) */
    {{'\xef', '\xbd', '\x92'}, 3, 0xFF52}, /* (FULLWIDTH LATIN SMALL LETTER R) */
    {{'\xef', '\xbd', '\x93'}, 3, 0xFF53}, /* (FULLWIDTH LATIN SMALL LETTER S) */
    {{'\xef', '\xbd', '\x94'}, 3, 0xFF54}, /* (FULLWIDTH LATIN SMALL LETTER T) */
    {{'\xef', '\xbd', '\x95'}, 3, 0xFF55}, /* (FULLWIDTH LATIN SMALL LETTER U) */
    {{'\xef', '\xbd', '\x96'}, 3, 0xFF56}, /* (FULLWIDTH LATIN SMALL LETTER V) */
    {{'\xef', '\xbd', '\x97'}, 3, 0xFF57}, /* (FULLWIDTH LATIN SMALL LETTER W) */
    {{'\xef', '\xbd', '\x98'}, 3, 0xFF58}, /* (FULLWIDTH LATIN SMALL LETTER X) */
    {{'\xef', '\xbd', '\x99'}, 3, 0xFF59}, /* (FULLWIDTH LATIN SMALL LETTER Y) */
    {{'\xef', '\xbd', '\x9a'}, 3, 0xFF5A}, /* (FULLWIDTH LATIN SMALL LETTER Z) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe3', '\x81', '\x81'}, 3, 0x3041}, /* (HIRAGANA LETTER SMALL A) */
    {{'\xe3', '\x81', '\x82'}, 3, 0x3042}, /* (HIRAGANA LETTER A) */
    {{'\xe3', '\x81', '\x83'}, 3, 0x3043}, /* (HIRAGANA LETTER SMALL I) */
    {{'\xe3', '\x81', '\x84'}, 3, 0x3044}, /* (HIRAGANA LETTER I) */
    {{'\xe3', '\x81', '\x85'}, 3, 0x3045}, /* (HIRAGANA LETTER SMALL U) */
    {{'\xe3', '\x81', '\x86'}, 3, 0x3046}, /* (HIRAGANA LETTER U) */
    {{'\xe3', '\x81', '\x87'}, 3, 0x3047}, /* (HIRAGANA LETTER SMALL E) */
    {{'\xe3', '\x81', '\x88'}, 3, 0x3048}, /* (HIRAGANA LETTER E) */
    {{'\xe3', '\x81', '\x89'}, 3, 0x3049}, /* (HIRAGANA LETTER SMALL O) */
    {{'\xe3', '\x81', '\x8a'}, 3, 0x304A}, /* (HIRAGANA LETTER O) */
    {{'\xe3', '\x81', '\x8b'}, 3, 0x304B}, /* (HIRAGANA LETTER KA) */
    {{'\xe3', '\x81', '\x8c'}, 3, 0x304C}, /* (HIRAGANA LETTER GA) */
    {{'\xe3', '\x81', '\x8d'}, 3, 0x304D}, /* (HIRAGANA LETTER KI) */
    {{'\xe3', '\x81', '\x8e'}, 3, 0x304E}, /* (HIRAGANA LETTER GI) */
    {{'\xe3', '\x81', '\x8f'}, 3, 0x304F}, /* (HIRAGANA LETTER KU) */
    {{'\xe3', '\x81', '\x90'}, 3, 0x3050}, /* (HIRAGANA LETTER GU) */
    {{'\xe3', '\x81', '\x91'}, 3, 0x3051}, /* (HIRAGANA LETTER KE) */
    {{'\xe3', '\x81', '\x92'}, 3, 0x3052}, /* (HIRAGANA LETTER GE) */
    {{'\xe3', '\x81', '\x93'}, 3, 0x3053}, /* (HIRAGANA LETTER KO) */
    {{'\xe3', '\x81', '\x94'}, 3, 0x3054}, /* (HIRAGANA LETTER GO) */
    {{'\xe3', '\x81', '\x95'}, 3, 0x3055}, /* (HIRAGANA LETTER SA) */
    {{'\xe3', '\x81', '\x96'}, 3, 0x3056}, /* (HIRAGANA LETTER ZA) */
    {{'\xe3', '\x81', '\x97'}, 3, 0x3057}, /* (HIRAGANA LETTER SI) */
    {{'\xe3', '\x81', '\x98'}, 3, 0x3058}, /* (HIRAGANA LETTER ZI) */
    {{'\xe3', '\x81', '\x99'}, 3, 0x3059}, /* (HIRAGANA LETTER SU) */
    {{'\xe3', '\x81', '\x9a'}, 3, 0x305A}, /* (HIRAGANA LETTER ZU) */
    {{'\xe3', '\x81', '\x9b'}, 3, 0x305B}, /* (HIRAGANA LETTER SE) */
    {{'\xe3', '\x81', '\x9c'}, 3, 0x305C}, /* (HIRAGANA LETTER ZE) */
    {{'\xe3', '\x81', '\x9d'}, 3, 0x305D}, /* (HIRAGANA LETTER SO) */
    {{'\xe3', '\x81', '\x9e'}, 3, 0x305E}, /* (HIRAGANA LETTER ZO) */
    {{'\xe3', '\x81', '\x9f'}, 3, 0x305F}, /* (HIRAGANA LETTER TA) */
    {{'\xe3', '\x81', '\xa0'}, 3, 0x3060}, /* (HIRAGANA LETTER DA) */
    {{'\xe3', '\x81', '\xa1'}, 3, 0x3061}, /* (HIRAGANA LETTER TI) */
    {{'\xe3', '\x81', '\xa2'}, 3, 0x3062}, /* (HIRAGANA LETTER DI) */
    {{'\xe3', '\x81', '\xa3'}, 3, 0x3063}, /* (HIRAGANA LETTER SMALL TU) */
    {{'\xe3', '\x81', '\xa4'}, 3, 0x3064}, /* (HIRAGANA LETTER TU) */
    {{'\xe3', '\x81', '\xa5'}, 3, 0x3065}, /* (HIRAGANA LETTER DU) */
    {{'\xe3', '\x81', '\xa6'}, 3, 0x3066}, /* (HIRAGANA LETTER TE) */
    {{'\xe3', '\x81', '\xa7'}, 3, 0x3067}, /* (HIRAGANA LETTER DE) */
    {{'\xe3', '\x81', '\xa8'}, 3, 0x3068}, /* (HIRAGANA LETTER TO) */
    {{'\xe3', '\x81', '\xa9'}, 3, 0x3069}, /* (HIRAGANA LETTER DO) */
    {{'\xe3', '\x81', '\xaa'}, 3, 0x306A}, /* (HIRAGANA LETTER NA) */
    {{'\xe3', '\x81', '\xab'}, 3, 0x306B}, /* (HIRAGANA LETTER NI) */
    {{'\xe3', '\x81', '\xac'}, 3, 0x306C}, /* (HIRAGANA LETTER NU) */
    {{'\xe3', '\x81', '\xad'}, 3, 0x306D}, /* (HIRAGANA LETTER NE) */
    {{'\xe3', '\x81', '\xae'}, 3, 0x306E}, /* (HIRAGANA LETTER NO) */
    {{'\xe3', '\x81', '\xaf'}, 3, 0x306F}, /* (HIRAGANA LETTER HA) */
    {{'\xe3', '\x81', '\xb0'}, 3, 0x3070}, /* (HIRAGANA LETTER BA) */
    {{'\xe3', '\x81', '\xb1'}, 3, 0x3071}, /* (HIRAGANA LETTER PA) */
    {{'\xe3', '\x81', '\xb2'}, 3, 0x3072}, /* (HIRAGANA LETTER HI) */
    {{'\xe3', '\x81', '\xb3'}, 3, 0x3073}, /* (HIRAGANA LETTER BI) */
    {{'\xe3', '\x81', '\xb4'}, 3, 0x3074}, /* (HIRAGANA LETTER PI) */
    {{'\xe3', '\x81', '\xb5'}, 3, 0x3075}, /* (HIRAGANA LETTER HU) */
    {{'\xe3', '\x81', '\xb6'}, 3, 0x3076}, /* (HIRAGANA LETTER BU) */
    {{'\xe3', '\x81', '\xb7'}, 3, 0x3077}, /* (HIRAGANA LETTER PU) */
    {{'\xe3', '\x81', '\xb8'}, 3, 0x3078}, /* (HIRAGANA LETTER HE) */
    {{'\xe3', '\x81', '\xb9'}, 3, 0x3079}, /* (HIRAGANA LETTER BE) */
    {{'\xe3', '\x81', '\xba'}, 3, 0x307A}, /* (HIRAGANA LETTER PE) */
    {{'\xe3', '\x81', '\xbb'}, 3, 0x307B}, /* (HIRAGANA LETTER HO) */
    {{'\xe3', '\x81', '\xbc'}, 3, 0x307C}, /* (HIRAGANA LETTER BO) */
    {{'\xe3', '\x81', '\xbd'}, 3, 0x307D}, /* (HIRAGANA LETTER PO) */
    {{'\xe3', '\x81', '\xbe'}, 3, 0x307E}, /* (HIRAGANA LETTER MA) */
    {{'\xe3', '\x81', '\xbf'}, 3, 0x307F}, /* (HIRAGANA LETTER MI) */
    {{'\xe3', '\x82', '\x80'}, 3, 0x3080}, /* (HIRAGANA LETTER MU) */
    {{'\xe3', '\x82', '\x81'}, 3, 0x3081}, /* (HIRAGANA LETTER ME) */
    {{'\xe3', '\x82', '\x82'}, 3, 0x3082}, /* (HIRAGANA LETTER MO) */
    {{'\xe3', '\x82', '\x83'}, 3, 0x3083}, /* (HIRAGANA LETTER SMALL YA) */
    {{'\xe3', '\x82', '\x84'}, 3, 0x3084}, /* (HIRAGANA LETTER YA) */
    {{'\xe3', '\x82', '\x85'}, 3, 0x3085}, /* (HIRAGANA LETTER SMALL YU) */
    {{'\xe3', '\x82', '\x86'}, 3, 0x3086}, /* (HIRAGANA LETTER YU) */
    {{'\xe3', '\x82', '\x87'}, 3, 0x3087}, /* (HIRAGANA LETTER SMALL YO) */
    {{'\xe3', '\x82', '\x88'}, 3, 0x3088}, /* (HIRAGANA LETTER YO) */
    {{'\xe3', '\x82', '\x89'}, 3, 0x3089}, /* (HIRAGANA LETTER RA) */
    {{'\xe3', '\x82', '\x8a'}, 3, 0x308A}, /* (HIRAGANA LETTER RI) */
    {{'\xe3', '\x82', '\x8b'}, 3, 0x308B}, /* (HIRAGANA LETTER RU) */
    {{'\xe3', '\x82', '\x8c'}, 3, 0x308C}, /* (HIRAGANA LETTER RE) */
    {{'\xe3', '\x82', '\x8d'}, 3, 0x308D}, /* (HIRAGANA LETTER RO) */
    {{'\xe3', '\x82', '\x8e'}, 3, 0x308E}, /* (HIRAGANA LETTER SMALL WA) */
    {{'\xe3', '\x82', '\x8f'}, 3, 0x308F}, /* (HIRAGANA LETTER WA) */
    {{'\xe3', '\x82', '\x90'}, 3, 0x3090}, /* (HIRAGANA LETTER WI) */
    {{'\xe3', '\x82', '\x91'}, 3, 0x3091}, /* (HIRAGANA LETTER WE) */
    {{'\xe3', '\x82', '\x92'}, 3, 0x3092}, /* (HIRAGANA LETTER WO) */
    {{'\xe3', '\x82', '\x93'}, 3, 0x3093}, /* (HIRAGANA LETTER N) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe3', '\x82', '\xa1'}, 3, 0x30A1}, /* (KATAKANA LETTER SMALL A) */
    {{'\xe3', '\x82', '\xa2'}, 3, 0x30A2}, /* (KATAKANA LETTER A) */
    {{'\xe3', '\x82', '\xa3'}, 3, 0x30A3}, /* (KATAKANA LETTER SMALL I) */
    {{'\xe3', '\x82', '\xa4'}, 3, 0x30A4}, /* (KATAKANA LETTER I) */
    {{'\xe3', '\x82', '\xa5'}, 3, 0x30A5}, /* (KATAKANA LETTER SMALL U) */
    {{'\xe3', '\x82', '\xa6'}, 3, 0x30A6}, /* (KATAKANA LETTER U) */
    {{'\xe3', '\x82', '\xa7'}, 3, 0x30A7}, /* (KATAKANA LETTER SMALL E) */
    {{'\xe3', '\x82', '\xa8'}, 3, 0x30A8}, /* (KATAKANA LETTER E) */
    {{'\xe3', '\x82', '\xa9'}, 3, 0x30A9}, /* (KATAKANA LETTER SMALL O) */
    {{'\xe3', '\x82', '\xaa'}, 3, 0x30AA}, /* (KATAKANA LETTER O) */
    {{'\xe3', '\x82', '\xab'}, 3, 0x30AB}, /* (KATAKANA LETTER KA) */
    {{'\xe3', '\x82', '\xac'}, 3, 0x30AC}, /* (KATAKANA LETTER GA) */
    {{'\xe3', '\x82', '\xad'}, 3, 0x30AD}, /* (KATAKANA LETTER KI) */
    {{'\xe3', '\x82', '\xae'}, 3, 0x30AE}, /* (KATAKANA LETTER GI) */
    {{'\xe3', '\x82', '\xaf'}, 3, 0x30AF}, /* (KATAKANA LETTER KU) */
    {{'\xe3', '\x82', '\xb0'}, 3, 0x30B0}, /* (KATAKANA LETTER GU) */
    {{'\xe3', '\x82', '\xb1'}, 3, 0x30B1}, /* (KATAKANA LETTER KE) */
    {{'\xe3', '\x82', '\xb2'}, 3, 0x30B2}, /* (KATAKANA LETTER GE) */
    {{'\xe3', '\x82', '\xb3'}, 3, 0x30B3}, /* (KATAKANA LETTER KO) */
    {{'\xe3', '\x82', '\xb4'}, 3, 0x30B4}, /* (KATAKANA LETTER GO) */
    {{'\xe3', '\x82', '\xb5'}, 3, 0x30B5}, /* (KATAKANA LETTER SA) */
    {{'\xe3', '\x82', '\xb6'}, 3, 0x30B6}, /* (KATAKANA LETTER ZA) */
    {{'\xe3', '\x82', '\xb7'}, 3, 0x30B7}, /* (KATAKANA LETTER SI) */
    {{'\xe3', '\x82', '\xb8'}, 3, 0x30B8}, /* (KATAKANA LETTER ZI) */
    {{'\xe3', '\x82', '\xb9'}, 3, 0x30B9}, /* (KATAKANA LETTER SU) */
    {{'\xe3', '\x82', '\xba'}, 3, 0x30BA}, /* (KATAKANA LETTER ZU) */
    {{'\xe3', '\x82', '\xbb'}, 3, 0x30BB}, /* (KATAKANA LETTER SE) */
    {{'\xe3', '\x82', '\xbc'}, 3, 0x30BC}, /* (KATAKANA LETTER ZE) */
    {{'\xe3', '\x82', '\xbd'}, 3, 0x30BD}, /* (KATAKANA LETTER SO) */
    {{'\xe3', '\x82', '\xbe'}, 3, 0x30BE}, /* (KATAKANA LETTER ZO) */
    {{'\xe3', '\x82', '\xbf'}, 3, 0x30BF}, /* (KATAKANA LETTER TA) */
    {{'\xe3', '\x83', '\x80'}, 3, 0x30C0}, /* (KATAKANA LETTER DA) */
    {{'\xe3', '\x83', '\x81'}, 3, 0x30C1}, /* (KATAKANA LETTER TI) */
    {{'\xe3', '\x83', '\x82'}, 3, 0x30C2}, /* (KATAKANA LETTER DI) */
    {{'\xe3', '\x83', '\x83'}, 3, 0x30C3}, /* (KATAKANA LETTER SMALL TU) */
    {{'\xe3', '\x83', '\x84'}, 3, 0x30C4}, /* (KATAKANA LETTER TU) */
    {{'\xe3', '\x83', '\x85'}, 3, 0x30C5}, /* (KATAKANA LETTER DU) */
    {{'\xe3', '\x83', '\x86'}, 3, 0x30C6}, /* (KATAKANA LETTER TE) */
    {{'\xe3', '\x83', '\x87'}, 3, 0x30C7}, /* (KATAKANA LETTER DE) */
    {{'\xe3', '\x83', '\x88'}, 3, 0x30C8}, /* (KATAKANA LETTER TO) */
    {{'\xe3', '\x83', '\x89'}, 3, 0x30C9}, /* (KATAKANA LETTER DO) */
    {{'\xe3', '\x83', '\x8a'}, 3, 0x30CA}, /* (KATAKANA LETTER NA) */
    {{'\xe3', '\x83', '\x8b'}, 3, 0x30CB}, /* (KATAKANA LETTER NI) */
    {{'\xe3', '\x83', '\x8c'}, 3, 0x30CC}, /* (KATAKANA LETTER NU) */
    {{'\xe3', '\x83', '\x8d'}, 3, 0x30CD}, /* (KATAKANA LETTER NE) */
    {{'\xe3', '\x83', '\x8e'}, 3, 0x30CE}, /* (KATAKANA LETTER NO) */
    {{'\xe3', '\x83', '\x8f'}, 3, 0x30CF}, /* (KATAKANA LETTER HA) */
    {{'\xe3', '\x83', '\x90'}, 3, 0x30D0}, /* (KATAKANA LETTER BA) */
    {{'\xe3', '\x83', '\x91'}, 3, 0x30D1}, /* (KATAKANA LETTER PA) */
    {{'\xe3', '\x83', '\x92'}, 3, 0x30D2}, /* (KATAKANA LETTER HI) */
    {{'\xe3', '\x83', '\x93'}, 3, 0x30D3}, /* (KATAKANA LETTER BI) */
    {{'\xe3', '\x83', '\x94'}, 3, 0x30D4}, /* (KATAKANA LETTER PI) */
    {{'\xe3', '\x83', '\x95'}, 3, 0x30D5}, /* (KATAKANA LETTER HU) */
    {{'\xe3', '\x83', '\x96'}, 3, 0x30D6}, /* (KATAKANA LETTER BU) */
    {{'\xe3', '\x83', '\x97'}, 3, 0x30D7}, /* (KATAKANA LETTER PU) */
    {{'\xe3', '\x83', '\x98'}, 3, 0x30D8}, /* (KATAKANA LETTER HE) */
    {{'\xe3', '\x83', '\x99'}, 3, 0x30D9}, /* (KATAKANA LETTER BE) */
    {{'\xe3', '\x83', '\x9a'}, 3, 0x30DA}, /* (KATAKANA LETTER PE) */
    {{'\xe3', '\x83', '\x9b'}, 3, 0x30DB}, /* (KATAKANA LETTER HO) */
    {{'\xe3', '\x83', '\x9c'}, 3, 0x30DC}, /* (KATAKANA LETTER BO) */
    {{'\xe3', '\x83', '\x9d'}, 3, 0x30DD}, /* (KATAKANA LETTER PO) */
    {{'\xe3', '\x83', '\x9e'}, 3, 0x30DE}, /* (KATAKANA LETTER MA) */
    {{'\xe3', '\x83', '\x9f'}, 3, 0x30DF}, /* (KATAKANA LETTER MI) */
    {{'\xe3', '\x83', '\xa0'}, 3, 0x30E0}, /* (KATAKANA LETTER MU) */
    {{'\xe3', '\x83', '\xa1'}, 3, 0x30E1}, /* (KATAKANA LETTER ME) */
    {{'\xe3', '\x83', '\xa2'}, 3, 0x30E2}, /* (KATAKANA LETTER MO) */
    {{'\xe3', '\x83', '\xa3'}, 3, 0x30E3}, /* (KATAKANA LETTER SMALL YA) */
    {{'\xe3', '\x83', '\xa4'}, 3, 0x30E4}, /* (KATAKANA LETTER YA) */
    {{'\xe3', '\x83', '\xa5'}, 3, 0x30E5}, /* (KATAKANA LETTER SMALL YU) */
    {{'\xe3', '\x83', '\xa6'}, 3, 0x30E6}, /* (KATAKANA LETTER YU) */
    {{'\xe3', '\x83', '\xa7'}, 3, 0x30E7}, /* (KATAKANA LETTER SMALL YO) */
    {{'\xe3', '\x83', '\xa8'}, 3, 0x30E8}, /* (KATAKANA LETTER YO) */
    {{'\xe3', '\x83', '\xa9'}, 3, 0x30E9}, /* (KATAKANA LETTER RA) */
    {{'\xe3', '\x83', '\xaa'}, 3, 0x30EA}, /* (KATAKANA LETTER RI) */
    {{'\xe3', '\x83', '\xab'}, 3, 0x30EB}, /* (KATAKANA LETTER RU) */
    {{'\xe3', '\x83', '\xac'}, 3, 0x30EC}, /* (KATAKANA LETTER RE) */
    {{'\xe3', '\x83', '\xad'}, 3, 0x30ED}, /* (KATAKANA LETTER RO) */
    {{'\xe3', '\x83', '\xae'}, 3, 0x30EE}, /* (KATAKANA LETTER SMALL WA) */
    {{'\xe3', '\x83', '\xaf'}, 3, 0x30EF}, /* (KATAKANA LETTER WA) */
    {{'\xe3', '\x83', '\xb0'}, 3, 0x30F0}, /* (KATAKANA LETTER WI) */
    {{'\xe3', '\x83', '\xb1'}, 3, 0x30F1}, /* (KATAKANA LETTER WE) */
    {{'\xe3', '\x83', '\xb2'}, 3, 0x30F2}, /* (KATAKANA LETTER WO) */
    {{'\xe3', '\x83', '\xb3'}, 3, 0x30F3}, /* (KATAKANA LETTER N) */
    {{'\xe3', '\x83', '\xb4'}, 3, 0x30F4}, /* (KATAKANA LETTER VU) */
    {{'\xe3', '\x83', '\xb5'}, 3, 0x30F5}, /* (KATAKANA LETTER SMALL KA) */
    {{'\xe3', '\x83', '\xb6'}, 3, 0x30F6}, /* (KATAKANA LETTER SMALL KE) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xce', '\x91'}, 2, 0x0391}, /* (GREEK CAPITAL LETTER ALPHA) */
    {{'\xce', '\x92'}, 2, 0x0392}, /* (GREEK CAPITAL LETTER BETA) */
    {{'\xce', '\x93'}, 2, 0x0393}, /* (GREEK CAPITAL LETTER GAMMA) */
    {{'\xce', '\x94'}, 2, 0x0394}, /* (GREEK CAPITAL LETTER DELTA) */
    {{'\xce', '\x95'}, 2, 0x0395}, /* (GREEK CAPITAL LETTER EPSILON) */
    {{'\xce', '\x96'}, 2, 0x0396}, /* (GREEK CAPITAL LETTER ZETA) */
    {{'\xce', '\x97'}, 2, 0x0397}, /* (GREEK CAPITAL LETTER ETA) */
    {{'\xce', '\x98'}, 2, 0x0398}, /* (GREEK CAPITAL LETTER THETA) */
    {{'\xce', '\x99'}, 2, 0x0399}, /* (GREEK CAPITAL LETTER IOTA) */
    {{'\xce', '\x9a'}, 2, 0x039A}, /* (GREEK CAPITAL LETTER KAPPA) */
    {{'\xce', '\x9b'}, 2, 0x039B}, /* (GREEK CAPITAL LETTER LAMDA) */
    {{'\xce', '\x9c'}, 2, 0x039C}, /* (GREEK CAPITAL LETTER MU) */
    {{'\xce', '\x9d'}, 2, 0x039D}, /* (GREEK CAPITAL LETTER NU) */
    {{'\xce', '\x9e'}, 2, 0x039E}, /* (GREEK CAPITAL LETTER XI) */
    {{'\xce', '\x9f'}, 2, 0x039F}, /* (GREEK CAPITAL LETTER OMICRON) */
    {{'\xce', '\xa0'}, 2, 0x03A0}, /* (GREEK CAPITAL LETTER PI) */
    {{'\xce', '\xa1'}, 2, 0x03A1}, /* (GREEK CAPITAL LETTER RHO) */
    {{'\xce', '\xa3'}, 2, 0x03A3}, /* (GREEK CAPITAL LETTER SIGMA) */
    {{'\xce', '\xa4'}, 2, 0x03A4}, /* (GREEK CAPITAL LETTER TAU) */
    {{'\xce', '\xa5'}, 2, 0x03A5}, /* (GREEK CAPITAL LETTER UPSILON) */
    {{'\xce', '\xa6'}, 2, 0x03A6}, /* (GREEK CAPITAL LETTER PHI) */
    {{'\xce', '\xa7'}, 2, 0x03A7}, /* (GREEK CAPITAL LETTER CHI) */
    {{'\xce', '\xa8'}, 2, 0x03A8}, /* (GREEK CAPITAL LETTER PSI) */
    {{'\xce', '\xa9'}, 2, 0x03A9}, /* (GREEK CAPITAL LETTER OMEGA) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xce', '\xb1'}, 2, 0x03B1}, /* (GREEK SMALL LETTER ALPHA) */
    {{'\xce', '\xb2'}, 2, 0x03B2}, /* (GREEK SMALL LETTER BETA) */
    {{'\xce', '\xb3'}, 2, 0x03B3}, /* (GREEK SMALL LETTER GAMMA) */
    {{'\xce', '\xb4'}, 2, 0x03B4}, /* (GREEK SMALL LETTER DELTA) */
    {{'\xce', '\xb5'}, 2, 0x03B5}, /* (GREEK SMALL LETTER EPSILON) */
    {{'\xce', '\xb6'}, 2, 0x03B6}, /* (GREEK SMALL LETTER ZETA) */
    {{'\xce', '\xb7'}, 2, 0x03B7}, /* (GREEK SMALL LETTER ETA) */
    {{'\xce', '\xb8'}, 2, 0x03B8}, /* (GREEK SMALL LETTER THETA) */
    {{'\xce', '\xb9'}, 2, 0x03B9}, /* (GREEK SMALL LETTER IOTA) */
    {{'\xce', '\xba'}, 2, 0x03BA}, /* (GREEK SMALL LETTER KAPPA) */
    {{'\xce', '\xbb'}, 2, 0x03BB}, /* (GREEK SMALL LETTER LAMDA) */
    {{'\xce', '\xbc'}, 2, 0x03BC}, /* (GREEK SMALL LETTER MU) */
    {{'\xce', '\xbd'}, 2, 0x03BD}, /* (GREEK SMALL LETTER NU) */
    {{'\xce', '\xbe'}, 2, 0x03BE}, /* (GREEK SMALL LETTER XI) */
    {{'\xce', '\xbf'}, 2, 0x03BF}, /* (GREEK SMALL LETTER OMICRON) */
    {{'\xcf', '\x80'}, 2, 0x03C0}, /* (GREEK SMALL LETTER PI) */
    {{'\xcf', '\x81'}, 2, 0x03C1}, /* (GREEK SMALL LETTER RHO) */
    {{'\xcf', '\x83'}, 2, 0x03C3}, /* (GREEK SMALL LETTER SIGMA) */
    {{'\xcf', '\x84'}, 2, 0x03C4}, /* (GREEK SMALL LETTER TAU) */
    {{'\xcf', '\x85'}, 2, 0x03C5}, /* (GREEK SMALL LETTER UPSILON) */
    {{'\xcf', '\x86'}, 2, 0x03C6}, /* (GREEK SMALL LETTER PHI) */
    {{'\xcf', '\x87'}, 2, 0x03C7}, /* (GREEK SMALL LETTER CHI) */
    {{'\xcf', '\x88'}, 2, 0x03C8}, /* (GREEK SMALL LETTER PSI) */
    {{'\xcf', '\x89'}, 2, 0x03C9}, /* (GREEK SMALL LETTER OMEGA) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xd0', '\x90'}, 2, 0x0410}, /* (CYRILLIC CAPITAL LETTER A) */
    {{'\xd0', '\x91'}, 2, 0x0411}, /* (CYRILLIC CAPITAL LETTER BE) */
    {{'\xd0', '\x92'}, 2, 0x0412}, /* (CYRILLIC CAPITAL LETTER VE) */
    {{'\xd0', '\x93'}, 2, 0x0413}, /* (CYRILLIC CAPITAL LETTER GHE) */
    {{'\xd0', '\x94'}, 2, 0x0414}, /* (CYRILLIC CAPITAL LETTER DE) */
    {{'\xd0', '\x95'}, 2, 0x0415}, /* (CYRILLIC CAPITAL LETTER IE) */
    {{'\xd0', '\x81'}, 2, 0x0401}, /* (CYRILLIC CAPITAL LETTER IO) */
    {{'\xd0', '\x96'}, 2, 0x0416}, /* (CYRILLIC CAPITAL LETTER ZHE) */
    {{'\xd0', '\x97'}, 2, 0x0417}, /* (CYRILLIC CAPITAL LETTER ZE) */
    {{'\xd0', '\x98'}, 2, 0x0418}, /* (CYRILLIC CAPITAL LETTER I) */
    {{'\xd0', '\x99'}, 2, 0x0419}, /* (CYRILLIC CAPITAL LETTER SHORT I) */
    {{'\xd0', '\x9a'}, 2, 0x041A}, /* (CYRILLIC CAPITAL LETTER KA) */
    {{'\xd0', '\x9b'}, 2, 0x041B}, /* (CYRILLIC CAPITAL LETTER EL) */
    {{'\xd0', '\x9c'}, 2, 0x041C}, /* (CYRILLIC CAPITAL LETTER EM) */
    {{'\xd0', '\x9d'}, 2, 0x041D}, /* (CYRILLIC CAPITAL LETTER EN) */
    {{'\xd0', '\x9e'}, 2, 0x041E}, /* (CYRILLIC CAPITAL LETTER O) */
    {{'\xd0', '\x9f'}, 2, 0x041F}, /* (CYRILLIC CAPITAL LETTER PE) */
    {{'\xd0', '\xa0'}, 2, 0x0420}, /* (CYRILLIC CAPITAL LETTER ER) */
    {{'\xd0', '\xa1'}, 2, 0x0421}, /* (CYRILLIC CAPITAL LETTER ES) */
    {{'\xd0', '\xa2'}, 2, 0x0422}, /* (CYRILLIC CAPITAL LETTER TE) */
    {{'\xd0', '\xa3'}, 2, 0x0423}, /* (CYRILLIC CAPITAL LETTER U) */
    {{'\xd0', '\xa4'}, 2, 0x0424}, /* (CYRILLIC CAPITAL LETTER EF) */
    {{'\xd0', '\xa5'}, 2, 0x0425}, /* (CYRILLIC CAPITAL LETTER HA) */
    {{'\xd0', '\xa6'}, 2, 0x0426}, /* (CYRILLIC CAPITAL LETTER TSE) */
    {{'\xd0', '\xa7'}, 2, 0x0427}, /* (CYRILLIC CAPITAL LETTER CHE) */
    {{'\xd0', '\xa8'}, 2, 0x0428}, /* (CYRILLIC CAPITAL LETTER SHA) */
    {{'\xd0', '\xa9'}, 2, 0x0429}, /* (CYRILLIC CAPITAL LETTER SHCHA) */
    {{'\xd0', '\xaa'}, 2, 0x042A}, /* (CYRILLIC CAPITAL LETTER HARD SIGN) */
    {{'\xd0', '\xab'}, 2, 0x042B}, /* (CYRILLIC CAPITAL LETTER YERU) */
    {{'\xd0', '\xac'}, 2, 0x042C}, /* (CYRILLIC CAPITAL LETTER SOFT SIGN) */
    {{'\xd0', '\xad'}, 2, 0x042D}, /* (CYRILLIC CAPITAL LETTER E) */
    {{'\xd0', '\xae'}, 2, 0x042E}, /* (CYRILLIC CAPITAL LETTER YU) */
    {{'\xd0', '\xaf'}, 2, 0x042F}, /* (CYRILLIC CAPITAL LETTER YA) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xd0', '\xb0'}, 2, 0x0430}, /* (CYRILLIC SMALL LETTER A) */
    {{'\xd0', '\xb1'}, 2, 0x0431}, /* (CYRILLIC SMALL LETTER BE) */
    {{'\xd0', '\xb2'}, 2, 0x0432}, /* (CYRILLIC SMALL LETTER VE) */
    {{'\xd0', '\xb3'}, 2, 0x0433}, /* (CYRILLIC SMALL LETTER GHE) */
    {{'\xd0', '\xb4'}, 2, 0x0434}, /* (CYRILLIC SMALL LETTER DE) */
    {{'\xd0', '\xb5'}, 2, 0x0435}, /* (CYRILLIC SMALL LETTER IE) */
    {{'\xd1', '\x91'}, 2, 0x0451}, /* (CYRILLIC SMALL LETTER IO) */
    {{'\xd0', '\xb6'}, 2, 0x0436}, /* (CYRILLIC SMALL LETTER ZHE) */
    {{'\xd0', '\xb7'}, 2, 0x0437}, /* (CYRILLIC SMALL LETTER ZE) */
    {{'\xd0', '\xb8'}, 2, 0x0438}, /* (CYRILLIC SMALL LETTER I) */
    {{'\xd0', '\xb9'}, 2, 0x0439}, /* (CYRILLIC SMALL LETTER SHORT I) */
    {{'\xd0', '\xba'}, 2, 0x043A}, /* (CYRILLIC SMALL LETTER KA) */
    {{'\xd0', '\xbb'}, 2, 0x043B}, /* (CYRILLIC SMALL LETTER EL) */
    {{'\xd0', '\xbc'}, 2, 0x043C}, /* (CYRILLIC SMALL LETTER EM) */
    {{'\xd0', '\xbd'}, 2, 0x043D}, /* (CYRILLIC SMALL LETTER EN) */
    {{'\xd0', '\xbe'}, 2, 0x043E}, /* (CYRILLIC SMALL LETTER O) */
    {{'\xd0', '\xbf'}, 2, 0x043F}, /* (CYRILLIC SMALL LETTER PE) */
    {{'\xd1', '\x80'}, 2, 0x0440}, /* (CYRILLIC SMALL LETTER ER) */
    {{'\xd1', '\x81'}, 2, 0x0441}, /* (CYRILLIC SMALL LETTER ES) */
    {{'\xd1', '\x82'}, 2, 0x0442}, /* (CYRILLIC SMALL LETTER TE) */
    {{'\xd1', '\x83'}, 2, 0x0443}, /* (CYRILLIC SMALL LETTER U) */
    {{'\xd1', '\x84'}, 2, 0x0444}, /* (CYRILLIC SMALL LETTER EF) */
    {{'\xd1', '\x85'}, 2, 0x0445}, /* (CYRILLIC SMALL LETTER HA) */
    {{'\xd1', '\x86'}, 2, 0x0446}, /* (CYRILLIC SMALL LETTER TSE) */
    {{'\xd1', '\x87'}, 2, 0x0447}, /* (CYRILLIC SMALL LETTER CHE) */
    {{'\xd1', '\x88'}, 2, 0x0448}, /* (CYRILLIC SMALL LETTER SHA) */
    {{'\xd1', '\x89'}, 2, 0x0449}, /* (CYRILLIC SMALL LETTER SHCHA) */
    {{'\xd1', '\x8a'}, 2, 0x044A}, /* (CYRILLIC SMALL LETTER HARD SIGN) */
    {{'\xd1', '\x8b'}, 2, 0x044B}, /* (CYRILLIC SMALL LETTER YERU) */
    {{'\xd1', '\x8c'}, 2, 0x044C}, /* (CYRILLIC SMALL LETTER SOFT SIGN) */
    {{'\xd1', '\x8d'}, 2, 0x044D}, /* (CYRILLIC SMALL LETTER E) */
    {{'\xd1', '\x8e'}, 2, 0x044E}, /* (CYRILLIC SMALL LETTER YU) */
    {{'\xd1', '\x8f'}, 2, 0x044F}, /* (CYRILLIC SMALL LETTER YA) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe2', '\x94', '\x80'}, 3, 0x2500}, /* (BOX DRAWINGS LIGHT HORIZONTAL) */
    {{'\xe2', '\x94', '\x82'}, 3, 0x2502}, /* (BOX DRAWINGS LIGHT VERTICAL) */
    {{'\xe2', '\x94', '\x8c'}, 3, 0x250C}, /* (BOX DRAWINGS LIGHT DOWN AND RIGHT) */
    {{'\xe2', '\x94', '\x90'}, 3, 0x2510}, /* (BOX DRAWINGS LIGHT DOWN AND LEFT) */
    {{'\xe2', '\x94', '\x98'}, 3, 0x2518}, /* (BOX DRAWINGS LIGHT UP AND LEFT) */
    {{'\xe2', '\x94', '\x94'}, 3, 0x2514}, /* (BOX DRAWINGS LIGHT UP AND RIGHT) */
    {{'\xe2', '\x94', '\x9c'}, 3, 0x251C}, /* (BOX DRAWINGS LIGHT VERTICAL AND RIGHT) */
    {{'\xe2', '\x94', '\xac'}, 3, 0x252C}, /* (BOX DRAWINGS LIGHT DOWN AND HORIZONTAL) */
    {{'\xe2', '\x94', '\xa4'}, 3, 0x2524}, /* (BOX DRAWINGS LIGHT VERTICAL AND LEFT) */
    {{'\xe2', '\x94', '\xb4'}, 3, 0x2534}, /* (BOX DRAWINGS LIGHT UP AND HORIZONTAL) */
    {{'\xe2', '\x94', '\xbc'}, 3, 0x253C}, /* (BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL) */
    {{'\xe2', '\x94', '\x81'}, 3, 0x2501}, /* (BOX DRAWINGS HEAVY HORIZONTAL) */
    {{'\xe2', '\x94', '\x83'}, 3, 0x2503}, /* (BOX DRAWINGS HEAVY VERTICAL) */
    {{'\xe2', '\x94', '\x8f'}, 3, 0x250F}, /* (BOX DRAWINGS HEAVY DOWN AND RIGHT) */
    {{'\xe2', '\x94', '\x93'}, 3, 0x2513}, /* (BOX DRAWINGS HEAVY DOWN AND LEFT) */
    {{'\xe2', '\x94', '\x9b'}, 3, 0x251B}, /* (BOX DRAWINGS HEAVY UP AND LEFT) */
    {{'\xe2', '\x94', '\x97'}, 3, 0x2517}, /* (BOX DRAWINGS HEAVY UP AND RIGHT) */
    {{'\xe2', '\x94', '\xa3'}, 3, 0x2523}, /* (BOX DRAWINGS HEAVY VERTICAL AND RIGHT) */
    {{'\xe2', '\x94', '\xb3'}, 3, 0x2533}, /* (BOX DRAWINGS HEAVY DOWN AND HORIZONTAL) */
    {{'\xe2', '\x94', '\xab'}, 3, 0x252B}, /* (BOX DRAWINGS HEAVY VERTICAL AND LEFT) */
    {{'\xe2', '\x94', '\xbb'}, 3, 0x253B}, /* (BOX DRAWINGS HEAVY UP AND HORIZONTAL) */
    {{'\xe2', '\x95', '\x8b'}, 3, 0x254B}, /* (BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL) */
    {{'\xe2', '\x94', '\xa0'}, 3, 0x2520}, /* (BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT) */
    {{'\xe2', '\x94', '\xaf'}, 3, 0x252F}, /* (BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY) */
    {{'\xe2', '\x94', '\xa8'}, 3, 0x2528}, /* (BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT) */
    {{'\xe2', '\x94', '\xb7'}, 3, 0x2537}, /* (BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY) */
    {{'\xe2', '\x94', '\xbf'}, 3, 0x253F}, /* (BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY) */
    {{'\xe2', '\x94', '\x9d'}, 3, 0x251D}, /* (BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY) */
    {{'\xe2', '\x94', '\xb0'}, 3, 0x2530}, /* (BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT) */
    {{'\xe2', '\x94', '\xa5'}, 3, 0x2525}, /* (BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY) */
    {{'\xe2', '\x94', '\xb8'}, 3, 0x2538}, /* (BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT) */
    {{'\xe2', '\x95', '\x82'}, 3, 0x2542}, /* (BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe2', '\x91', '\xa0'}, 3, 0x2460}, /* (CIRCLED DIGIT ONE) */
    {{'\xe2', '\x91', '\xa1'}, 3, 0x2461}, /* (CIRCLED DIGIT TWO) */
    {{'\xe2', '\x91', '\xa2'}, 3, 0x2462}, /* (CIRCLED DIGIT THREE) */
    {{'\xe2', '\x91', '\xa3'}, 3, 0x2463}, /* (CIRCLED DIGIT FOUR) */
    {{'\xe2', '\x91', '\xa4'}, 3, 0x2464}, /* (CIRCLED DIGIT FIVE) */
    {{'\xe2', '\x91', '\xa5'}, 3, 0x2465}, /* (CIRCLED DIGIT SIX) */
    {{'\xe2', '\x91', '\xa6'}, 3, 0x2466}, /* (CIRCLED DIGIT SEVEN) */
    {{'\xe2', '\x91', '\xa7'}, 3, 0x2467}, /* (CIRCLED DIGIT EIGHT) */
    {{'\xe2', '\x91', '\xa8'}, 3, 0x2468}, /* (CIRCLED DIGIT NINE) */
    {{'\xe2', '\x91', '\xa9'}, 3, 0x2469}, /* (CIRCLED NUMBER TEN) */
    {{'\xe2', '\x91', '\xaa'}, 3, 0x246A}, /* (CIRCLED NUMBER ELEVEN) */
    {{'\xe2', '\x91', '\xab'}, 3, 0x246B}, /* (CIRCLED NUMBER TWELVE) */
    {{'\xe2', '\x91', '\xac'}, 3, 0x246C}, /* (CIRCLED NUMBER THIRTEEN) */
    {{'\xe2', '\x91', '\xad'}, 3, 0x246D}, /* (CIRCLED NUMBER FOURTEEN) */
    {{'\xe2', '\x91', '\xae'}, 3, 0x246E}, /* (CIRCLED NUMBER FIFTEEN) */
    {{'\xe2', '\x91', '\xaf'}, 3, 0x246F}, /* (CIRCLED NUMBER SIXTEEN) */
    {{'\xe2', '\x91', '\xb0'}, 3, 0x2470}, /* (CIRCLED NUMBER SEVENTEEN) */
    {{'\xe2', '\x91', '\xb1'}, 3, 0x2471}, /* (CIRCLED NUMBER EIGHTEEN) */
    {{'\xe2', '\x91', '\xb2'}, 3, 0x2472}, /* (CIRCLED NUMBER NINETEEN) */
    {{'\xe2', '\x91', '\xb3'}, 3, 0x2473}, /* (CIRCLED NUMBER TWENTY) */
    {{'\xe2', '\x85', '\xa0'}, 3, 0x2160}, /* (ROMAN NUMERAL ONE) */
    {{'\xe2', '\x85', '\xa1'}, 3, 0x2161}, /* (ROMAN NUMERAL TWO) */
    {{'\xe2', '\x85', '\xa2'}, 3, 0x2162}, /* (ROMAN NUMERAL THREE) */
    {{'\xe2', '\x85', '\xa3'}, 3, 0x2163}, /* (ROMAN NUMERAL FOUR) */
    {{'\xe2', '\x85', '\xa4'}, 3, 0x2164}, /* (ROMAN NUMERAL FIVE) */
    {{'\xe2', '\x85', '\xa5'}, 3, 0x2165}, /* (ROMAN NUMERAL SIX) */
    {{'\xe2', '\x85', '\xa6'}, 3, 0x2166}, /* (ROMAN NUMERAL SEVEN) */
    {{'\xe2', '\x85', '\xa7'}, 3, 0x2167}, /* (ROMAN NUMERAL EIGHT) */
    {{'\xe2', '\x85', '\xa8'}, 3, 0x2168}, /* (ROMAN NUMERAL NINE) */
    {{'\xe2', '\x85', '\xa9'}, 3, 0x2169}, /* (ROMAN NUMERAL TEN) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe3', '\x8d', '\x89'}, 3, 0x3349}, /* (SQUARE MIRI) */
    {{'\xe3', '\x8c', '\x94'}, 3, 0x3314}, /* (SQUARE KIRO) */
    {{'\xe3', '\x8c', '\xa2'}, 3, 0x3322}, /* (SQUARE SENTI) */
    {{'\xe3', '\x8d', '\x8d'}, 3, 0x334D}, /* (SQUARE MEETORU) */
    {{'\xe3', '\x8c', '\x98'}, 3, 0x3318}, /* (SQUARE GURAMU) */
    {{'\xe3', '\x8c', '\xa7'}, 3, 0x3327}, /* (SQUARE TON) */
    {{'\xe3', '\x8c', '\x83'}, 3, 0x3303}, /* (SQUARE AARU) */
    {{'\xe3', '\x8c', '\xb6'}, 3, 0x3336}, /* (SQUARE HEKUTAARU) */
    {{'\xe3', '\x8d', '\x91'}, 3, 0x3351}, /* (SQUARE RITTORU) */
    {{'\xe3', '\x8d', '\x97'}, 3, 0x3357}, /* (SQUARE WATTO) */
    {{'\xe3', '\x8c', '\x8d'}, 3, 0x330D}, /* (SQUARE KARORII) */
    {{'\xe3', '\x8c', '\xa6'}, 3, 0x3326}, /* (SQUARE DORU) */
    {{'\xe3', '\x8c', '\xa3'}, 3, 0x3323}, /* (SQUARE SENTO) */
    {{'\xe3', '\x8c', '\xab'}, 3, 0x332B}, /* (SQUARE PAASENTO) */
    {{'\xe3', '\x8d', '\x8a'}, 3, 0x334A}, /* (SQUARE MIRIBAARU) */
    {{'\xe3', '\x8c', '\xbb'}, 3, 0x333B}, /* (SQUARE PEEZI) */
    {{'\xe3', '\x8e', '\x9c'}, 3, 0x339C}, /* (SQUARE MM) */
    {{'\xe3', '\x8e', '\x9d'}, 3, 0x339D}, /* (SQUARE CM) */
    {{'\xe3', '\x8e', '\x9e'}, 3, 0x339E}, /* (SQUARE KM) */
    {{'\xe3', '\x8e', '\x8e'}, 3, 0x338E}, /* (SQUARE MG) */
    {{'\xe3', '\x8e', '\x8f'}, 3, 0x338F}, /* (SQUARE KG) */
    {{'\xe3', '\x8f', '\x84'}, 3, 0x33C4}, /* (SQUARE CC) */
    {{'\xe3', '\x8e', '\xa1'}, 3, 0x33A1}, /* (SQUARE M SQUARED) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe3', '\x8d', '\xbb'}, 3, 0x337B}, /* (SQUARE ERA NAME HEISEI) */
    {{'\xe3', '\x80', '\x9d'}, 3, 0x301D}, /* (REVERSED DOUBLE PRIME QUOTATION MARK) */
    {{'\xe3', '\x80', '\x9f'}, 3, 0x301F}, /* (LOW DOUBLE PRIME QUOTATION MARK) */
    {{'\xe2', '\x84', '\x96'}, 3, 0x2116}, /* (NUMERO SIGN) */
    {{'\xe3', '\x8f', '\x8d'}, 3, 0x33CD}, /* (SQUARE KK) */
    {{'\xe2', '\x84', '\xa1'}, 3, 0x2121}, /* (TELEPHONE SIGN) */
    {{'\xe3', '\x8a', '\xa4'}, 3, 0x32A4}, /* (CIRCLED IDEOGRAPH HIGH) */
    {{'\xe3', '\x8a', '\xa5'}, 3, 0x32A5}, /* (CIRCLED IDEOGRAPH CENTRE) */
    {{'\xe3', '\x8a', '\xa6'}, 3, 0x32A6}, /* (CIRCLED IDEOGRAPH LOW) */
    {{'\xe3', '\x8a', '\xa7'}, 3, 0x32A7}, /* (CIRCLED IDEOGRAPH LEFT) */
    {{'\xe3', '\x8a', '\xa8'}, 3, 0x32A8}, /* (CIRCLED IDEOGRAPH RIGHT) */
    {{'\xe3', '\x88', '\xb1'}, 3, 0x3231}, /* (PARENTHESIZED IDEOGRAPH STOCK) */
    {{'\xe3', '\x88', '\xb2'}, 3, 0x3232}, /* (PARENTHESIZED IDEOGRAPH HAVE) */
    {{'\xe3', '\x88', '\xb9'}, 3, 0x3239}, /* (PARENTHESIZED IDEOGRAPH REPRESENT) */
    {{'\xe3', '\x8d', '\xbe'}, 3, 0x337E}, /* (SQUARE ERA NAME MEIZI) */
    {{'\xe3', '\x8d', '\xbd'}, 3, 0x337D}, /* (SQUARE ERA NAME TAISYOU) */
    {{'\xe3', '\x8d', '\xbc'}, 3, 0x337C}, /* (SQUARE ERA NAME SYOUWA) */
    {{'\xe2', '\x89', '\x92'}, 3, 0x2252}, /* (APPROXIMATELY EQUAL TO OR THE IMAGE OF) */
    {{'\xe2', '\x89', '\xa1'}, 3, 0x2261}, /* (IDENTICAL TO) */
    {{'\xe2', '\x88', '\xab'}, 3, 0x222B}, /* (INTEGRAL) */
    {{'\xe2', '\x88', '\xae'}, 3, 0x222E}, /* (CONTOUR INTEGRAL) */
    {{'\xe2', '\x88', '\x91'}, 3, 0x2211}, /* (N-ARY SUMMATION) */
    {{'\xe2', '\x88', '\x9a'}, 3, 0x221A}, /* (SQUARE ROOT) */
    {{'\xe2', '\x8a', '\xa5'}, 3, 0x22A5}, /* (UP TACK) */
    {{'\xe2', '\x88', '\xa0'}, 3, 0x2220}, /* (ANGLE) */
    {{'\xe2', '\x88', '\x9f'}, 3, 0x221F}, /* (RIGHT ANGLE) */
    {{'\xe2', '\x8a', '\xbf'}, 3, 0x22BF}, /* (RIGHT TRIANGLE) */
    {{'\xe2', '\x88', '\xb5'}, 3, 0x2235}, /* (BECAUSE) */
    {{'\xe2', '\x88', '\xa9'}, 3, 0x2229}, /* (INTERSECTION) */
    {{'\xe2', '\x88', '\xaa'}, 3, 0x222A}, /* (UNION) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe4', '\xba', '\x9c'}, 3, 0x4E9C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x94', '\x96'}, 3, 0x5516}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa8', '\x83'}, 3, 0x5A03}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x98', '\xbf'}, 3, 0x963F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\x80'}, 3, 0x54C0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\x9b'}, 3, 0x611B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\xa8'}, 3, 0x6328}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\xb6'}, 3, 0x59F6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\xa2'}, 3, 0x9022}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\xb5'}, 3, 0x8475}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\x9c'}, 3, 0x831C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\x90'}, 3, 0x7A50}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\xaa'}, 3, 0x60AA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\xa1'}, 3, 0x63E1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xa5'}, 3, 0x6E25}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\xad'}, 3, 0x65ED}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\xa6'}, 3, 0x8466}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\xa6'}, 3, 0x82A6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\xb5'}, 3, 0x9BF5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\x93'}, 3, 0x6893}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\xa7'}, 3, 0x5727}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\xa1'}, 3, 0x65A1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\xb1'}, 3, 0x6271}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x9b'}, 3, 0x5B9B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\x90'}, 3, 0x59D0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x99', '\xbb'}, 3, 0x867B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\xb4'}, 3, 0x98F4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\xa2'}, 3, 0x7D62}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xbe'}, 3, 0x7DBE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\x8e'}, 3, 0x9B8E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x96'}, 3, 0x6216}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\x9f'}, 3, 0x7C9F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\xb7'}, 3, 0x88B7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x89'}, 3, 0x5B89}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\xb5'}, 3, 0x5EB5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\x89'}, 3, 0x6309}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\x97'}, 3, 0x6697}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x88'}, 3, 0x6848}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x97', '\x87'}, 3, 0x95C7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\x8d'}, 3, 0x978D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\x8f'}, 3, 0x674F}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\xa5'}, 3, 0x4EE5}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\x8a'}, 3, 0x4F0A}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x8d'}, 3, 0x4F4D}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x9d'}, 3, 0x4F9D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x89'}, 3, 0x5049}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\xb2'}, 3, 0x56F2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\xb7'}, 3, 0x5937}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\x94'}, 3, 0x59D4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa8', '\x81'}, 3, 0x5A01}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x89'}, 3, 0x5C09}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\x9f'}, 3, 0x60DF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\x8f'}, 3, 0x610F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xb0'}, 3, 0x6170}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x93'}, 3, 0x6613}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\x85'}, 3, 0x6905}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\xba'}, 3, 0x70BA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\x8f'}, 3, 0x754F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xb0'}, 3, 0x7570}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\xbb'}, 3, 0x79FB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xad'}, 3, 0x7DAD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\xaf'}, 3, 0x7DEF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\x83'}, 3, 0x80C3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\x8e'}, 3, 0x840E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\xa3'}, 3, 0x8863}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\x82'}, 3, 0x8B02}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x95'}, 3, 0x9055}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xba'}, 3, 0x907A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\xbb'}, 3, 0x533B}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x95'}, 3, 0x4E95}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\xa5'}, 3, 0x4EA5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\x9f'}, 3, 0x57DF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\xb2'}, 3, 0x80B2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x83', '\x81'}, 3, 0x90C1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa3', '\xaf'}, 3, 0x78EF}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x80'}, 3, 0x4E00}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\xb1'}, 3, 0x58F1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\xa2'}, 3, 0x6EA2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\xb8'}, 3, 0x9038}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\xb2'}, 3, 0x7A32}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\xa8'}, 3, 0x8328}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\x8b'}, 3, 0x828B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\xaf'}, 3, 0x9C2F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x81'}, 3, 0x5141}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xb0'}, 3, 0x5370}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\xbd'}, 3, 0x54BD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\xa1'}, 3, 0x54E1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\xa0'}, 3, 0x56E0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\xbb'}, 3, 0x59FB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x95'}, 3, 0x5F15}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\xb2'}, 3, 0x98F2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xab'}, 3, 0x6DEB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\xa4'}, 3, 0x80E4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x94', '\xad'}, 3, 0x852D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\xa2'}, 3, 0x9662}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\xb0'}, 3, 0x9670}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xa0'}, 3, 0x96A0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9f', '\xbb'}, 3, 0x97FB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x8b'}, 3, 0x540B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xb3'}, 3, 0x53F3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x87'}, 3, 0x5B87}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x83', '\x8f'}, 3, 0x70CF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\xbd'}, 3, 0x7FBD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\x82'}, 3, 0x8FC2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\xa8'}, 3, 0x96E8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xaf'}, 3, 0x536F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\x9c'}, 3, 0x9D5C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\xba'}, 3, 0x7ABA}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x91'}, 3, 0x4E11}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\x93'}, 3, 0x7893}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\xbc'}, 3, 0x81FC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xa6'}, 3, 0x6E26}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x98', '\x98'}, 3, 0x5618}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x94', '\x84'}, 3, 0x5504}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\x9d'}, 3, 0x6B1D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x94', '\x9a'}, 3, 0x851A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\xbb'}, 3, 0x9C3B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\xa5'}, 3, 0x59E5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\xa9'}, 3, 0x53A9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\xa6'}, 3, 0x6D66}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\x9c'}, 3, 0x74DC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\x8f'}, 3, 0x958F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x99', '\x82'}, 3, 0x5642}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x91'}, 3, 0x4E91}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x8b'}, 3, 0x904B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\xb2'}, 3, 0x96F2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\x8f'}, 3, 0x834F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\x8c'}, 3, 0x990C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xa1'}, 3, 0x53E1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\xb6'}, 3, 0x55B6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xac', '\xb0'}, 3, 0x5B30}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xb1'}, 3, 0x5F71}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xa0'}, 3, 0x6620}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xb3'}, 3, 0x66F3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\x84'}, 3, 0x6804}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb0', '\xb8'}, 3, 0x6C38}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\xb3'}, 3, 0x6CF3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\xa9'}, 3, 0x6D29}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\x9b'}, 3, 0x745B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\x88'}, 3, 0x76C8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\x8e'}, 3, 0x7A4E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\xb4'}, 3, 0x9834}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\xb1'}, 3, 0x82F1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\x9b'}, 3, 0x885B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\xa0'}, 3, 0x8A60}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xad'}, 3, 0x92ED}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\xb2'}, 3, 0x6DB2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\xab'}, 3, 0x75AB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\x8a'}, 3, 0x76CA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\x85'}, 3, 0x99C5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\xa6'}, 3, 0x60A6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\x81'}, 3, 0x8B01}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb6', '\x8a'}, 3, 0x8D8A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\xb2'}, 3, 0x95B2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\x8e'}, 3, 0x698E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\xad'}, 3, 0x53AD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x86'}, 3, 0x5186}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\x92'}, 3, 0x5712}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\xb0'}, 3, 0x5830}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x84'}, 3, 0x5944}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\xb4'}, 3, 0x5BB4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xb6'}, 3, 0x5EF6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\xa8'}, 3, 0x6028}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\xa9'}, 3, 0x63A9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\xb4'}, 3, 0x63F4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\xbf'}, 3, 0x6CBF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\x94'}, 3, 0x6F14}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\x8e'}, 3, 0x708E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x84', '\x94'}, 3, 0x7114}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\x99'}, 3, 0x7159}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\x95'}, 3, 0x71D5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\xbf'}, 3, 0x733F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\x81'}, 3, 0x7E01}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\xb6'}, 3, 0x8276}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\x91'}, 3, 0x82D1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\x97'}, 3, 0x8597}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xa0'}, 3, 0x9060}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x9b'}, 3, 0x925B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\x9b'}, 3, 0x9D1B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\xa9'}, 3, 0x5869}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\xbc'}, 3, 0x65BC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\x9a'}, 3, 0x6C5A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xa5'}, 3, 0x7525}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xb9'}, 3, 0x51F9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\xae'}, 3, 0x592E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\xa5'}, 3, 0x5965}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x80'}, 3, 0x5F80}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\x9c'}, 3, 0x5FDC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\xbc'}, 3, 0x62BC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\xba'}, 3, 0x65FA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\xaa'}, 3, 0x6A2A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\xa7'}, 3, 0x6B27}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\xb4'}, 3, 0x6BB4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8e', '\x8b'}, 3, 0x738B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\x81'}, 3, 0x7FC1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\x96'}, 3, 0x8956}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\xac'}, 3, 0x9D2C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\x8e'}, 3, 0x9D0E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\x84'}, 3, 0x9EC4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xa1'}, 3, 0x5CA1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\x96'}, 3, 0x6C96}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\xbb'}, 3, 0x837B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\x84'}, 3, 0x5104}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\x8b'}, 3, 0x5C4B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\xb6'}, 3, 0x61B6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\x86'}, 3, 0x81C6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\xb6'}, 3, 0x6876}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\xa1'}, 3, 0x7261}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\x99'}, 3, 0x4E59}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\xba'}, 3, 0x4FFA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xb8'}, 3, 0x5378}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\xa9'}, 3, 0x6069}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xa9'}, 3, 0x6E29}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\x8f'}, 3, 0x7A4F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9f', '\xb3'}, 3, 0x97F3}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x8b'}, 3, 0x4E0B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x96'}, 3, 0x5316}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\xae'}, 3, 0x4EEE}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x95'}, 3, 0x4F55}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\xbd'}, 3, 0x4F3D}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\xa1'}, 3, 0x4FA1}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\xb3'}, 3, 0x4F73}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xa0'}, 3, 0x52A0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xaf'}, 3, 0x53EF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x98', '\x89'}, 3, 0x5609}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\x8f'}, 3, 0x590F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xab', '\x81'}, 3, 0x5AC1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\xb6'}, 3, 0x5BB6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xa1'}, 3, 0x5BE1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\x91'}, 3, 0x79D1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\x87'}, 3, 0x6687}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\x9c'}, 3, 0x679C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\xb6'}, 3, 0x67B6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\x8c'}, 3, 0x6B4C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\xb3'}, 3, 0x6CB3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x81', '\xab'}, 3, 0x706B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\x82'}, 3, 0x73C2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\x8d'}, 3, 0x798D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\xbe'}, 3, 0x79BE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\xbc'}, 3, 0x7A3C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x87'}, 3, 0x7B87}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\xb1'}, 3, 0x82B1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\x9b'}, 3, 0x82DB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\x84'}, 3, 0x8304}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\xb7'}, 3, 0x8377}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\xaf'}, 3, 0x83EF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\x93'}, 3, 0x83D3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\xa6'}, 3, 0x8766}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xb2'}, 3, 0x8AB2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x98', '\xa9'}, 3, 0x5629}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xa8'}, 3, 0x8CA8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\xa6'}, 3, 0x8FE6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x8e'}, 3, 0x904E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\x9e'}, 3, 0x971E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9a', '\x8a'}, 3, 0x868A}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x84'}, 3, 0x4FC4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\xa8'}, 3, 0x5CE8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x91'}, 3, 0x6211}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\x99'}, 3, 0x7259}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xbb'}, 3, 0x753B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\xa5'}, 3, 0x81E5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\xbd'}, 3, 0x82BD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\xbe'}, 3, 0x86FE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x80'}, 3, 0x8CC0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x85'}, 3, 0x96C5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\x93'}, 3, 0x9913}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\x95'}, 3, 0x99D5}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x8b'}, 3, 0x4ECB}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\x9a'}, 3, 0x4F1A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa7', '\xa3'}, 3, 0x89E3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\x9e'}, 3, 0x56DE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\x8a'}, 3, 0x584A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\x8a'}, 3, 0x58CA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xbb'}, 3, 0x5EFB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\xab'}, 3, 0x5FEB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\xaa'}, 3, 0x602A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x94'}, 3, 0x6094}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\xa2'}, 3, 0x6062}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\x90'}, 3, 0x61D0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x92'}, 3, 0x6212}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x90'}, 3, 0x62D0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\xb9'}, 3, 0x6539}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\x81'}, 3, 0x9B41}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\xa6'}, 3, 0x6666}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\xb0'}, 3, 0x68B0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\xb7'}, 3, 0x6D77}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x81', '\xb0'}, 3, 0x7070}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\x8c'}, 3, 0x754C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x86'}, 3, 0x7686}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\xb5'}, 3, 0x7D75}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\xa5'}, 3, 0x82A5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9f', '\xb9'}, 3, 0x87F9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\x8b'}, 3, 0x958B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\x8e'}, 3, 0x968E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\x9d'}, 3, 0x8C9D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xb1'}, 3, 0x51F1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xbe'}, 3, 0x52BE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\x96'}, 3, 0x5916}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\xb3'}, 3, 0x54B3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\xb3'}, 3, 0x5BB3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\x96'}, 3, 0x5D16}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xa8'}, 3, 0x6168}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\x82'}, 3, 0x6982}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\xaf'}, 3, 0x6DAF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\x8d'}, 3, 0x788D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\x8b'}, 3, 0x84CB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\x97'}, 3, 0x8857}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\xb2'}, 3, 0x8A72}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8e', '\xa7'}, 3, 0x93A7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaa', '\xb8'}, 3, 0x9AB8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\xac'}, 3, 0x6D6C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa6', '\xa8'}, 3, 0x99A8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\x99'}, 3, 0x86D9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9e', '\xa3'}, 3, 0x57A3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\xbf'}, 3, 0x67FF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\x8e'}, 3, 0x86CE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\x8e'}, 3, 0x920E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\x83'}, 3, 0x5283}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9a', '\x87'}, 3, 0x5687}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x84'}, 3, 0x5404}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\x93'}, 3, 0x5ED3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\xa1'}, 3, 0x62E1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\xb9'}, 3, 0x64B9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\xbc'}, 3, 0x683C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\xb8'}, 3, 0x6838}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\xbb'}, 3, 0x6BBB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8d', '\xb2'}, 3, 0x7372}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\xba'}, 3, 0x78BA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\xab'}, 3, 0x7A6B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\x9a'}, 3, 0x899A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa7', '\x92'}, 3, 0x89D2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb5', '\xab'}, 3, 0x8D6B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\x83'}, 3, 0x8F03}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x83', '\xad'}, 3, 0x90ED}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\xa3'}, 3, 0x95A3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\x94'}, 3, 0x9694}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\xa9'}, 3, 0x9769}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\xa6'}, 3, 0x5B66}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xb3'}, 3, 0x5CB3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xbd'}, 3, 0x697D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\x8d'}, 3, 0x984D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\x8e'}, 3, 0x984E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\x9b'}, 3, 0x639B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\xa0'}, 3, 0x7B20}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\xab'}, 3, 0x6A2B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\xbf'}, 3, 0x6A7F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\xb6'}, 3, 0x68B6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\x8d'}, 3, 0x9C0D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\x9f'}, 3, 0x6F5F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\xb2'}, 3, 0x5272}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\x9d'}, 3, 0x559D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\xb0'}, 3, 0x6070}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\xac'}, 3, 0x62EC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\xbb'}, 3, 0x6D3B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\x87'}, 3, 0x6E07}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\x91'}, 3, 0x6ED1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\x9b'}, 3, 0x845B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\x90'}, 3, 0x8910}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbd', '\x84'}, 3, 0x8F44}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x94'}, 3, 0x4E14}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\xb9'}, 3, 0x9C39}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xb6'}, 3, 0x53F6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\x9b'}, 3, 0x691B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\xba'}, 3, 0x6A3A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\x84'}, 3, 0x9784}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\xaa'}, 3, 0x682A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x9c'}, 3, 0x515C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x83'}, 3, 0x7AC3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\xb2'}, 3, 0x84B2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x9c'}, 3, 0x91DC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8e', '\x8c'}, 3, 0x938C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x99', '\x9b'}, 3, 0x565B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\xa8'}, 3, 0x9D28}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\xa2'}, 3, 0x6822}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\x85'}, 3, 0x8305}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\xb1'}, 3, 0x8431}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\xa5'}, 3, 0x7CA5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\x88'}, 3, 0x5208}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\x85'}, 3, 0x82C5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\xa6'}, 3, 0x74E6}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\xbe'}, 3, 0x4E7E}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x83'}, 3, 0x4F83}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xa0'}, 3, 0x51A0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x92'}, 3, 0x5BD2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\x8a'}, 3, 0x520A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x98'}, 3, 0x52D8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\xa7'}, 3, 0x52E7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xbb'}, 3, 0x5DFB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\x9a'}, 3, 0x559A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\xaa'}, 3, 0x582A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\xa6'}, 3, 0x59E6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x8c'}, 3, 0x5B8C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x98'}, 3, 0x5B98}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x9b'}, 3, 0x5BDB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xb2'}, 3, 0x5E72}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xb9'}, 3, 0x5E79}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\xa3'}, 3, 0x60A3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\x9f'}, 3, 0x611F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xa3'}, 3, 0x6163}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\xbe'}, 3, 0x61BE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\x9b'}, 3, 0x63DB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\xa2'}, 3, 0x6562}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\x91'}, 3, 0x67D1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x93'}, 3, 0x6853}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\xba'}, 3, 0x68FA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\xbe'}, 3, 0x6B3E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\x93'}, 3, 0x6B53}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\x97'}, 3, 0x6C57}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\xa2'}, 3, 0x6F22}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\x97'}, 3, 0x6F97}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\x85'}, 3, 0x6F45}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x92', '\xb0'}, 3, 0x74B0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\x98'}, 3, 0x7518}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\xa3'}, 3, 0x76E3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\x8b'}, 3, 0x770B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xbf'}, 3, 0x7AFF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\xa1'}, 3, 0x7BA1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\xa1'}, 3, 0x7C21}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\xa9'}, 3, 0x7DE9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbc', '\xb6'}, 3, 0x7F36}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\xb0'}, 3, 0x7FF0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\x9d'}, 3, 0x809D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\xa6'}, 3, 0x8266}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\x9e'}, 3, 0x839E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\xb3'}, 3, 0x89B3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\x8c'}, 3, 0x8ACC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xab'}, 3, 0x8CAB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\x84'}, 3, 0x9084}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\x91'}, 3, 0x9451}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\x93'}, 3, 0x9593}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\x91'}, 3, 0x9591}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\xa2'}, 3, 0x95A2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\xa5'}, 3, 0x9665}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9f', '\x93'}, 3, 0x97D3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\xa8'}, 3, 0x9928}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x98'}, 3, 0x8218}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\xb8'}, 3, 0x4E38}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\xab'}, 3, 0x542B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xb8'}, 3, 0x5CB8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\x8c'}, 3, 0x5DCC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8e', '\xa9'}, 3, 0x73A9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\x8c'}, 3, 0x764C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\xbc'}, 3, 0x773C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xa9'}, 3, 0x5CA9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\xab'}, 3, 0x7FEB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb4', '\x8b'}, 3, 0x8D0B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x81'}, 3, 0x96C1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\x91'}, 3, 0x9811}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\x94'}, 3, 0x9854}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\x98'}, 3, 0x9858}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\x81'}, 3, 0x4F01}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\x8e'}, 3, 0x4F0E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xb1'}, 3, 0x5371}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\x9c'}, 3, 0x559C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x99', '\xa8'}, 3, 0x5668}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\xba'}, 3, 0x57FA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x87'}, 3, 0x5947}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xac', '\x89'}, 3, 0x5B09}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x84'}, 3, 0x5BC4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\x90'}, 3, 0x5C90}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\x8c'}, 3, 0x5E0C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xbe'}, 3, 0x5E7E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\x8c'}, 3, 0x5FCC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\xae'}, 3, 0x63EE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\xba'}, 3, 0x673A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\x97'}, 3, 0x65D7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\xa2'}, 3, 0x65E2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x9f'}, 3, 0x671F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x8b'}, 3, 0x68CB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x84'}, 3, 0x68C4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\x9f'}, 3, 0x6A5F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\xb0'}, 3, 0x5E30}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\x85'}, 3, 0x6BC5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb0', '\x97'}, 3, 0x6C17}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\xbd'}, 3, 0x6C7D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xbf'}, 3, 0x757F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\x88'}, 3, 0x7948}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\xa3'}, 3, 0x5B63}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\x80'}, 3, 0x7A00}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x80'}, 3, 0x7D00}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\xbd'}, 3, 0x5FBD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\x8f'}, 3, 0x898F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x98'}, 3, 0x8A18}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xb4'}, 3, 0x8CB4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb5', '\xb7'}, 3, 0x8D77}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\x8c'}, 3, 0x8ECC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\x9d'}, 3, 0x8F1D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\xa2'}, 3, 0x98E2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa8', '\x8e'}, 3, 0x9A0E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\xbc'}, 3, 0x9B3C}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x80'}, 3, 0x4E80}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\xbd'}, 3, 0x507D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\x80'}, 3, 0x5100}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\x93'}, 3, 0x5993}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x9c'}, 3, 0x5B9C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\xaf'}, 3, 0x622F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x80'}, 3, 0x6280}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\xac'}, 3, 0x64EC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\xba'}, 3, 0x6B3A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\xa0'}, 3, 0x72A0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\x91'}, 3, 0x7591}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\x87'}, 3, 0x7947}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\xa9'}, 3, 0x7FA9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9f', '\xbb'}, 3, 0x87FB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xbc'}, 3, 0x8ABC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\xb0'}, 3, 0x8B70}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\xac'}, 3, 0x63AC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\x8a'}, 3, 0x83CA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\xa0'}, 3, 0x97A0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x89'}, 3, 0x5409}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x83'}, 3, 0x5403}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\xab'}, 3, 0x55AB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x94'}, 3, 0x6854}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\x98'}, 3, 0x6A58}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\xb0'}, 3, 0x8A70}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa0', '\xa7'}, 3, 0x7827}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xb5'}, 3, 0x6775}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\x8d'}, 3, 0x9ECD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xb4'}, 3, 0x5374}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\xa2'}, 3, 0x5BA2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\x9a'}, 3, 0x811A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x99', '\x90'}, 3, 0x8650}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x86'}, 3, 0x9006}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x98'}, 3, 0x4E18}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\x85'}, 3, 0x4E45}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x87'}, 3, 0x4EC7}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\x91'}, 3, 0x4F11}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x8a'}, 3, 0x53CA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\xb8'}, 3, 0x5438}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\xae'}, 3, 0x5BAE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x93'}, 3, 0x5F13}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\xa5'}, 3, 0x6025}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\x91'}, 3, 0x6551}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\xbd'}, 3, 0x673D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\x82'}, 3, 0x6C42}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\xb2'}, 3, 0x6C72}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\xa3'}, 3, 0x6CE3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x81', '\xb8'}, 3, 0x7078}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\x83'}, 3, 0x7403}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\xb6'}, 3, 0x7A76}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\xae'}, 3, 0x7AAE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\x88'}, 3, 0x7B08}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x9a'}, 3, 0x7D1A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\xbe'}, 3, 0x7CFE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\xa6'}, 3, 0x7D66}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\xa7'}, 3, 0x65E7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\x9b'}, 3, 0x725B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\xbb'}, 3, 0x53BB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\x85'}, 3, 0x5C45}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xa8'}, 3, 0x5DE8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x92'}, 3, 0x62D2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\xa0'}, 3, 0x62E0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\x99'}, 3, 0x6319}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xa0'}, 3, 0x6E20}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x99', '\x9a'}, 3, 0x865A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\xb1'}, 3, 0x8A31}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\x9d'}, 3, 0x8DDD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xb8'}, 3, 0x92F8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\x81'}, 3, 0x6F01}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\xa6'}, 3, 0x79A6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\x9a'}, 3, 0x9B5A}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\xa8'}, 3, 0x4EA8}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\xab'}, 3, 0x4EAB}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\xac'}, 3, 0x4EAC}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x9b'}, 3, 0x4F9B}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\xa0'}, 3, 0x4FA0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\x91'}, 3, 0x50D1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x87'}, 3, 0x5147}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xb6'}, 3, 0x7AF6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xb1'}, 3, 0x5171}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xb6'}, 3, 0x51F6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x94'}, 3, 0x5354}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\xa1'}, 3, 0x5321}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xbf'}, 3, 0x537F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xab'}, 3, 0x53EB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\xac'}, 3, 0x55AC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\x83'}, 3, 0x5883}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\xa1'}, 3, 0x5CE1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\xb7'}, 3, 0x5F37}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\x8a'}, 3, 0x5F4A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\xaf'}, 3, 0x602F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\x90'}, 3, 0x6050}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\xad'}, 3, 0x606D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\x9f'}, 3, 0x631F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\x99'}, 3, 0x6559}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\x8b'}, 3, 0x6A4B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\x81'}, 3, 0x6CC1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\x82'}, 3, 0x72C2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\xad'}, 3, 0x72ED}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9f', '\xaf'}, 3, 0x77EF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\xb8'}, 3, 0x80F8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\x85'}, 3, 0x8105}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x88'}, 3, 0x8208}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\x8e'}, 3, 0x854E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x83', '\xb7'}, 3, 0x90F7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\xa1'}, 3, 0x93E1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9f', '\xbf'}, 3, 0x97FF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa5', '\x97'}, 3, 0x9957}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\x9a'}, 3, 0x9A5A}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\xb0'}, 3, 0x4EF0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\x9d'}, 3, 0x51DD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\xad'}, 3, 0x5C2D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\x81'}, 3, 0x6681}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xad'}, 3, 0x696D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\x80'}, 3, 0x5C40}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xb2'}, 3, 0x66F2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xb5'}, 3, 0x6975}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8e', '\x89'}, 3, 0x7389}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x90'}, 3, 0x6850}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\x81'}, 3, 0x7C81}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\x85'}, 3, 0x50C5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\xa4'}, 3, 0x52E4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\x87'}, 3, 0x5747}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xbe'}, 3, 0x5DFE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xa6'}, 3, 0x9326}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\xa4'}, 3, 0x65A4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\xa3'}, 3, 0x6B23}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\xbd'}, 3, 0x6B3D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xb4'}, 3, 0x7434}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\x81'}, 3, 0x7981}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\xbd'}, 3, 0x79BD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\x8b'}, 3, 0x7B4B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\x8a'}, 3, 0x7DCA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\xb9'}, 3, 0x82B9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\x8c'}, 3, 0x83CC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\xbf'}, 3, 0x887F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\x9f'}, 3, 0x895F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\xb9'}, 3, 0x8B39}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\x91'}, 3, 0x8FD1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x91'}, 3, 0x91D1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x9f'}, 3, 0x541F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\x80'}, 3, 0x9280}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\x9d'}, 3, 0x4E5D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\xb6'}, 3, 0x5036}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xa5'}, 3, 0x53E5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\xba'}, 3, 0x533A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\x97'}, 3, 0x72D7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8e', '\x96'}, 3, 0x7396}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9f', '\xa9'}, 3, 0x77E9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\xa6'}, 3, 0x82E6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\xaf'}, 3, 0x8EAF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\x86'}, 3, 0x99C6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\x88'}, 3, 0x99C8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\x92'}, 3, 0x99D2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xb7'}, 3, 0x5177}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\x9a'}, 3, 0x611A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x99', '\x9e'}, 3, 0x865E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\xb0'}, 3, 0x55B0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\xba'}, 3, 0x7A7A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\xb6'}, 3, 0x5076}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x93'}, 3, 0x5BD3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x87'}, 3, 0x9047}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\x85'}, 3, 0x9685}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\xb2'}, 3, 0x4E32}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\x9b'}, 3, 0x6ADB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\xa7'}, 3, 0x91E7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\x91'}, 3, 0x5C51}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\x88'}, 3, 0x5C48}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\x98'}, 3, 0x6398}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\x9f'}, 3, 0x7A9F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\x93'}, 3, 0x6C93}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\xb4'}, 3, 0x9774}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbd', '\xa1'}, 3, 0x8F61}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\xaa'}, 3, 0x7AAA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x86', '\x8a'}, 3, 0x718A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\x88'}, 3, 0x9688}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\x82'}, 3, 0x7C82}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\x97'}, 3, 0x6817}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\xb0'}, 3, 0x7E70}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x91'}, 3, 0x6851}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\xac'}, 3, 0x936C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\xb2'}, 3, 0x52F2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x9b'}, 3, 0x541B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\xab'}, 3, 0x85AB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x93'}, 3, 0x8A13}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\xa4'}, 3, 0x7FA4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\x8d'}, 3, 0x8ECD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x83', '\xa1'}, 3, 0x90E1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xa6'}, 3, 0x5366}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\x88'}, 3, 0x8888}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\x81'}, 3, 0x7941}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x82'}, 3, 0x4FC2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\xbe'}, 3, 0x50BE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\x91'}, 3, 0x5211}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x84'}, 3, 0x5144}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x95', '\x93'}, 3, 0x5553}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\xad'}, 3, 0x572D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\xaa'}, 3, 0x73EA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9e', '\x8b'}, 3, 0x578B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x91'}, 3, 0x5951}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xa2'}, 3, 0x5F62}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x84'}, 3, 0x5F84}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\xb5'}, 3, 0x6075}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xb6'}, 3, 0x6176}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xa7'}, 3, 0x6167}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\xa9'}, 3, 0x61A9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\xb2'}, 3, 0x63B2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x90', '\xba'}, 3, 0x643A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\xac'}, 3, 0x656C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\xaf'}, 3, 0x666F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x82'}, 3, 0x6842}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\x93'}, 3, 0x6E13}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xa6'}, 3, 0x7566}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\xbd'}, 3, 0x7A3D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\xbb'}, 3, 0x7CFB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\x8c'}, 3, 0x7D4C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\x99'}, 3, 0x7D99}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\x8b'}, 3, 0x7E4B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\xab'}, 3, 0x7F6B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\x8e'}, 3, 0x830E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\x8a'}, 3, 0x834A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\x8d'}, 3, 0x86CD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x88'}, 3, 0x8A08}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\xa3'}, 3, 0x8A63}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\xa6'}, 3, 0x8B66}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\xbd'}, 3, 0x8EFD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\x9a'}, 3, 0x981A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb6', '\x8f'}, 3, 0x9D8F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\xb8'}, 3, 0x82B8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\x8e'}, 3, 0x8FCE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\xa8'}, 3, 0x9BE8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\x87'}, 3, 0x5287}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x9f'}, 3, 0x621F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\x83'}, 3, 0x6483}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\x80'}, 3, 0x6FC0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\x99'}, 3, 0x9699}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x81'}, 3, 0x6841}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\x91'}, 3, 0x5091}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\xa0'}, 3, 0x6B20}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\xba'}, 3, 0x6C7A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\x94'}, 3, 0x6F54}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\xb4'}, 3, 0x7A74}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\x90'}, 3, 0x7D50}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\x80'}, 3, 0x8840}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\xa3'}, 3, 0x8A23}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x88'}, 3, 0x6708}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\xb6'}, 3, 0x4EF6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\xb9'}, 3, 0x5039}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\xa6'}, 3, 0x5026}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\xa5'}, 3, 0x5065}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xbc'}, 3, 0x517C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\xb8'}, 3, 0x5238}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\xa3'}, 3, 0x5263}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\xa7'}, 3, 0x55A7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\x8f'}, 3, 0x570F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\x85'}, 3, 0x5805}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xab', '\x8c'}, 3, 0x5ACC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xba'}, 3, 0x5EFA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\xb2'}, 3, 0x61B2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\xb8'}, 3, 0x61F8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\xb3'}, 3, 0x62F3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\xb2'}, 3, 0x6372}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\x9c'}, 3, 0x691C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\xa9'}, 3, 0x6A29}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\xbd'}, 3, 0x727D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\xac'}, 3, 0x72AC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\xae'}, 3, 0x732E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa0', '\x94'}, 3, 0x7814}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa1', '\xaf'}, 3, 0x786F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\xb9'}, 3, 0x7D79}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\x8c'}, 3, 0x770C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\xa9'}, 3, 0x80A9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\x8b'}, 3, 0x898B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\x99'}, 3, 0x8B19}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\xa2'}, 3, 0x8CE2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\x92'}, 3, 0x8ED2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xa3'}, 3, 0x9063}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\xb5'}, 3, 0x9375}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\xba'}, 3, 0x967A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\x95'}, 3, 0x9855}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa8', '\x93'}, 3, 0x9A13}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb9', '\xb8'}, 3, 0x9E78}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x83'}, 3, 0x5143}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\x9f'}, 3, 0x539F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\xb3'}, 3, 0x53B3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xbb'}, 3, 0x5E7B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\xa6'}, 3, 0x5F26}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\x9b'}, 3, 0x6E1B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\x90'}, 3, 0x6E90}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8e', '\x84'}, 3, 0x7384}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\xbe'}, 3, 0x73FE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\x83'}, 3, 0x7D43}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\xb7'}, 3, 0x8237}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x80'}, 3, 0x8A00}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\xba'}, 3, 0x8AFA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\x90'}, 3, 0x9650}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\x8e'}, 3, 0x4E4E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\x8b'}, 3, 0x500B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xa4'}, 3, 0x53E4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\xbc'}, 3, 0x547C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\xba'}, 3, 0x56FA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\x91'}, 3, 0x59D1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\xa4'}, 3, 0x5B64}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xb1'}, 3, 0x5DF1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\xab'}, 3, 0x5EAB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\xa7'}, 3, 0x5F27}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\xb8'}, 3, 0x6238}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\x85'}, 3, 0x6545}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\xaf'}, 3, 0x67AF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\x96'}, 3, 0x6E56}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\x90'}, 3, 0x72D0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\x8a'}, 3, 0x7CCA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\xb4'}, 3, 0x88B4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\xa1'}, 3, 0x80A1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\xa1'}, 3, 0x80E1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\xb0'}, 3, 0x83F0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x99', '\x8e'}, 3, 0x864E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\x87'}, 3, 0x8A87}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\xa8'}, 3, 0x8DE8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\xb7'}, 3, 0x9237}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x87'}, 3, 0x96C7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\xa7'}, 3, 0x9867}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbc', '\x93'}, 3, 0x9F13}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x94'}, 3, 0x4E94}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x92'}, 3, 0x4E92}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\x8d'}, 3, 0x4F0D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x88'}, 3, 0x5348}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\x89'}, 3, 0x5449}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\xbe'}, 3, 0x543E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa8', '\xaf'}, 3, 0x5A2F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x8c'}, 3, 0x5F8C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\xa1'}, 3, 0x5FA1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x9f'}, 3, 0x609F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\xa7'}, 3, 0x68A7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaa', '\x8e'}, 3, 0x6A8E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\x9a'}, 3, 0x745A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\x81'}, 3, 0x7881}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\x9e'}, 3, 0x8A9E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xa4'}, 3, 0x8AA4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\xb7'}, 3, 0x8B77}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\x90'}, 3, 0x9190}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\x9e'}, 3, 0x4E5E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\x89'}, 3, 0x9BC9}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\xa4'}, 3, 0x4EA4}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\xbc'}, 3, 0x4F7C}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\xaf'}, 3, 0x4FAF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\x99'}, 3, 0x5019}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\x96'}, 3, 0x5016}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x89'}, 3, 0x5149}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xac'}, 3, 0x516C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\x9f'}, 3, 0x529F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xb9'}, 3, 0x52B9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\xbe'}, 3, 0x52FE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\x9a'}, 3, 0x539A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xa3'}, 3, 0x53E3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x91'}, 3, 0x5411}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x8e'}, 3, 0x540E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\x89'}, 3, 0x5589}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\x91'}, 3, 0x5751}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9e', '\xa2'}, 3, 0x57A2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\xbd'}, 3, 0x597D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\x94'}, 3, 0x5B54}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\x9d'}, 3, 0x5B5D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x8f'}, 3, 0x5B8F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xa5'}, 3, 0x5DE5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xa7'}, 3, 0x5DE7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xb7'}, 3, 0x5DF7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xb8'}, 3, 0x5E78}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\x83'}, 3, 0x5E83}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\x9a'}, 3, 0x5E9A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\xb7'}, 3, 0x5EB7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x98'}, 3, 0x5F18}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\x92'}, 3, 0x6052}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\x8c'}, 3, 0x614C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x97'}, 3, 0x6297}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x98'}, 3, 0x62D8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\xa7'}, 3, 0x63A7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\xbb'}, 3, 0x653B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x82'}, 3, 0x6602}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\x83'}, 3, 0x6643}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xb4'}, 3, 0x66F4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xad'}, 3, 0x676D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\xa1'}, 3, 0x6821}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\x97'}, 3, 0x6897}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\x8b'}, 3, 0x69CB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\x9f'}, 3, 0x6C5F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\xaa'}, 3, 0x6D2A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\xa9'}, 3, 0x6D69}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xaf'}, 3, 0x6E2F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\x9d'}, 3, 0x6E9D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xb2'}, 3, 0x7532}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x87'}, 3, 0x7687}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa1', '\xac'}, 3, 0x786C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\xbf'}, 3, 0x7A3F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\xa0'}, 3, 0x7CE0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x85'}, 3, 0x7D05}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x98'}, 3, 0x7D18}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\x9e'}, 3, 0x7D5E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xb1'}, 3, 0x7DB1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\x95'}, 3, 0x8015}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\x83'}, 3, 0x8003}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\xaf'}, 3, 0x80AF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\xb1'}, 3, 0x80B1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\x94'}, 3, 0x8154}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\x8f'}, 3, 0x818F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\xaa'}, 3, 0x822A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\x92'}, 3, 0x8352}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\x8c'}, 3, 0x884C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\xa1'}, 3, 0x8861}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\x9b'}, 3, 0x8B1B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xa2'}, 3, 0x8CA2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\xbc'}, 3, 0x8CFC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x83', '\x8a'}, 3, 0x90CA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\xb5'}, 3, 0x9175}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\xb1'}, 3, 0x9271}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa0', '\xbf'}, 3, 0x783F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xbc'}, 3, 0x92FC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\xa4'}, 3, 0x95A4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\x8d'}, 3, 0x964D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\x85'}, 3, 0x9805}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa6', '\x99'}, 3, 0x9999}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\x98'}, 3, 0x9AD8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\xbb'}, 3, 0x9D3B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\x9b'}, 3, 0x525B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xab'}, 3, 0x52AB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xb7'}, 3, 0x53F7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x88'}, 3, 0x5408}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\x95'}, 3, 0x58D5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\xb7'}, 3, 0x62F7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\xa0'}, 3, 0x6FE0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\xaa'}, 3, 0x8C6A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbd', '\x9f'}, 3, 0x8F5F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\xb9'}, 3, 0x9EB9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x8b'}, 3, 0x514B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\xbb'}, 3, 0x523B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\x8a'}, 3, 0x544A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\xbd'}, 3, 0x56FD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\x80'}, 3, 0x7A40}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\xb7'}, 3, 0x9177}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\xa0'}, 3, 0x9D60}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\x92'}, 3, 0x9ED2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8d', '\x84'}, 3, 0x7344}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\x89'}, 3, 0x6F09}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\xb0'}, 3, 0x8170}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\x91'}, 3, 0x7511}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\xbd'}, 3, 0x5FFD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\x9a'}, 3, 0x60DA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaa', '\xa8'}, 3, 0x9AA8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\x9b'}, 3, 0x72DB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\xbc'}, 3, 0x8FBC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\xa4'}, 3, 0x6B64}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\x83'}, 3, 0x9803}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x8a'}, 3, 0x4ECA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\xb0'}, 3, 0x56F0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\xa4'}, 3, 0x5764}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\xbe'}, 3, 0x58BE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa9', '\x9a'}, 3, 0x5A5A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\xa8'}, 3, 0x6068}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\x87'}, 3, 0x61C7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x8f'}, 3, 0x660F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x86'}, 3, 0x6606}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\xb9'}, 3, 0x6839}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\xb1'}, 3, 0x68B1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xb7'}, 3, 0x6DF7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\x95'}, 3, 0x75D5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\xba'}, 3, 0x7D3A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\xae'}, 3, 0x826E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\x82'}, 3, 0x9B42}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x9b'}, 3, 0x4E9B}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x90'}, 3, 0x4F50}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x89'}, 3, 0x53C9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x94', '\x86'}, 3, 0x5506}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb5', '\xaf'}, 3, 0x5D6F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xa6'}, 3, 0x5DE6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xae'}, 3, 0x5DEE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\xbb'}, 3, 0x67FB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\x99'}, 3, 0x6C99}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\xb3'}, 3, 0x7473}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa0', '\x82'}, 3, 0x7802}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\x90'}, 3, 0x8A50}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8e', '\x96'}, 3, 0x9396}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\x9f'}, 3, 0x88DF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\x90'}, 3, 0x5750}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\xa7'}, 3, 0x5EA7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\xab'}, 3, 0x632B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\xb5'}, 3, 0x50B5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\xac'}, 3, 0x50AC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x8d'}, 3, 0x518D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x80'}, 3, 0x6700}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\x89'}, 3, 0x54C9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\x9e'}, 3, 0x585E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\xbb'}, 3, 0x59BB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\xb0'}, 3, 0x5BB0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xa9'}, 3, 0x5F69}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\x8d'}, 3, 0x624D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\xa1'}, 3, 0x63A1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\xbd'}, 3, 0x683D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\xb3'}, 3, 0x6B73}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\x88'}, 3, 0x6E08}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x81', '\xbd'}, 3, 0x707D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x87'}, 3, 0x91C7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\x80'}, 3, 0x7280}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa0', '\x95'}, 3, 0x7815}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa0', '\xa6'}, 3, 0x7826}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\xad'}, 3, 0x796D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\x8e'}, 3, 0x658E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\xb0'}, 3, 0x7D30}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\x9c'}, 3, 0x83DC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\x81'}, 3, 0x88C1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\x89'}, 3, 0x8F09}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\x9b'}, 3, 0x969B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\xa4'}, 3, 0x5264}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\xa8'}, 3, 0x5728}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\x90'}, 3, 0x6750}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\xaa'}, 3, 0x7F6A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xa1'}, 3, 0x8CA1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xb4'}, 3, 0x51B4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\x82'}, 3, 0x5742}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x98', '\xaa'}, 3, 0x962A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\xba'}, 3, 0x583A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\x8a'}, 3, 0x698A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\xb4'}, 3, 0x80B4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\xb2'}, 3, 0x54B2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\x8e'}, 3, 0x5D0E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\xbc'}, 3, 0x57FC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\x95'}, 3, 0x7895}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb7', '\xba'}, 3, 0x9DFA}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x9c'}, 3, 0x4F5C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\x8a'}, 3, 0x524A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\x8b'}, 3, 0x548B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x90', '\xbe'}, 3, 0x643E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xa8'}, 3, 0x6628}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x94'}, 3, 0x6714}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\xb5'}, 3, 0x67F5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\x84'}, 3, 0x7A84}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\x96'}, 3, 0x7B56}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\xa2'}, 3, 0x7D22}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xaf'}, 3, 0x932F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x9c'}, 3, 0x685C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\xad'}, 3, 0x9BAD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\xb9'}, 3, 0x7B39}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x99'}, 3, 0x5319}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x8a'}, 3, 0x518A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\xb7'}, 3, 0x5237}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x9f'}, 3, 0x5BDF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\xb6'}, 3, 0x62F6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\xae'}, 3, 0x64AE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\xa6'}, 3, 0x64E6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\xad'}, 3, 0x672D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\xba'}, 3, 0x6BBA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\xa9'}, 3, 0x85A9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x91'}, 3, 0x96D1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x90'}, 3, 0x7690}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\x96'}, 3, 0x9BD6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\x8c'}, 3, 0x634C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\x86'}, 3, 0x9306}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\xab'}, 3, 0x9BAB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\xbf'}, 3, 0x76BF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\x92'}, 3, 0x6652}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x89'}, 3, 0x4E09}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\x98'}, 3, 0x5098}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x82'}, 3, 0x53C2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\xb1'}, 3, 0x5C71}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\xa8'}, 3, 0x60E8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\x92'}, 3, 0x6492}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\xa3'}, 3, 0x6563}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x9f'}, 3, 0x685F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\xa6'}, 3, 0x71E6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\x8a'}, 3, 0x73CA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xa3'}, 3, 0x7523}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x97'}, 3, 0x7B97}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xba', '\x82'}, 3, 0x7E82}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9a', '\x95'}, 3, 0x8695}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xae', '\x83'}, 3, 0x8B83}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x9b'}, 3, 0x8CDB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\xb8'}, 3, 0x9178}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\x90'}, 3, 0x9910}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\xac'}, 3, 0x65AC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\xab'}, 3, 0x66AB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\x8b'}, 3, 0x6B8B}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x95'}, 3, 0x4ED5}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x94'}, 3, 0x4ED4}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\xba'}, 3, 0x4F3A}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\xbf'}, 3, 0x4F7F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\xba'}, 3, 0x523A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xb8'}, 3, 0x53F8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xb2'}, 3, 0x53F2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x97', '\xa3'}, 3, 0x55E3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\x9b'}, 3, 0x56DB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\xab'}, 3, 0x58EB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\x8b'}, 3, 0x59CB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\x89'}, 3, 0x59C9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\xbf'}, 3, 0x59FF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\x90'}, 3, 0x5B50}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\x8d'}, 3, 0x5C4D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\x82'}, 3, 0x5E02}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\xab'}, 3, 0x5E2B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\x97'}, 3, 0x5FD7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\x9d'}, 3, 0x601D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\x87'}, 3, 0x6307}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\xaf'}, 3, 0x652F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\x9c'}, 3, 0x5B5C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\xaf'}, 3, 0x65AF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\xbd'}, 3, 0x65BD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\xa8'}, 3, 0x65E8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\x9d'}, 3, 0x679D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\xa2'}, 3, 0x6B62}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\xbb'}, 3, 0x6B7B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb0', '\x8f'}, 3, 0x6C0F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8d', '\x85'}, 3, 0x7345}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\x89'}, 3, 0x7949}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\x81'}, 3, 0x79C1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\xb8'}, 3, 0x7CF8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x99'}, 3, 0x7D19}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\xab'}, 3, 0x7D2B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\xa2'}, 3, 0x80A2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\x82'}, 3, 0x8102}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\xb3'}, 3, 0x81F3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\x96'}, 3, 0x8996}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\x9e'}, 3, 0x8A5E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\xa9'}, 3, 0x8A69}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\xa6'}, 3, 0x8A66}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\x8c'}, 3, 0x8A8C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\xae'}, 3, 0x8AEE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x87'}, 3, 0x8CC7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x9c'}, 3, 0x8CDC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x8c'}, 3, 0x96CC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\xbc'}, 3, 0x98FC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\xaf'}, 3, 0x6B6F}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x8b'}, 3, 0x4E8B}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\xbc'}, 3, 0x4F3C}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x8d'}, 3, 0x4F8D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x90'}, 3, 0x5150}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\x97'}, 3, 0x5B57}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xba'}, 3, 0x5BFA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\x88'}, 3, 0x6148}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\x81'}, 3, 0x6301}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\x82'}, 3, 0x6642}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\xa1'}, 3, 0x6B21}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\x8b'}, 3, 0x6ECB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\xbb'}, 3, 0x6CBB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\xbe'}, 3, 0x723E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x92', '\xbd'}, 3, 0x74BD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\x94'}, 3, 0x75D4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa3', '\x81'}, 3, 0x78C1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa4', '\xba'}, 3, 0x793A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\x8c'}, 3, 0x800C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\xb3'}, 3, 0x8033}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\xaa'}, 3, 0x81EA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\x94'}, 3, 0x8494}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\x9e'}, 3, 0x8F9E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\x90'}, 3, 0x6C50}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb9', '\xbf'}, 3, 0x9E7F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x8f'}, 3, 0x5F0F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\x98'}, 3, 0x8B58}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\xab'}, 3, 0x9D2B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xba'}, 3, 0x7AFA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\xb8'}, 3, 0x8EF8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x8d'}, 3, 0x5B8D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\xab'}, 3, 0x96EB}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x83'}, 3, 0x4E03}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xb1'}, 3, 0x53F1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\xb7'}, 3, 0x57F7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\xb1'}, 3, 0x5931}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xab', '\x89'}, 3, 0x5AC9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\xa4'}, 3, 0x5BA4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x89'}, 3, 0x6089}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\xbf'}, 3, 0x6E7F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\x86'}, 3, 0x6F06}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\xbe'}, 3, 0x75BE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\xaa'}, 3, 0x8CEA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x9f'}, 3, 0x5B9F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x94', '\x80'}, 3, 0x8500}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\xa0'}, 3, 0x7BE0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\xb2'}, 3, 0x5072}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\xb4'}, 3, 0x67F4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\x9d'}, 3, 0x829D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\xa1'}, 3, 0x5C61}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\x8a'}, 3, 0x854A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\x9e'}, 3, 0x7E1E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x8e'}, 3, 0x820E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x99'}, 3, 0x5199}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x84'}, 3, 0x5C04}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\xa8'}, 3, 0x6368}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb5', '\xa6'}, 3, 0x8D66}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\x9c'}, 3, 0x659C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\xae'}, 3, 0x716E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa4', '\xbe'}, 3, 0x793E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x97'}, 3, 0x7D17}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\x85'}, 3, 0x8005}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\x9d'}, 3, 0x8B1D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\x8a'}, 3, 0x8ECA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xae'}, 3, 0x906E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\x87'}, 3, 0x86C7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\xaa'}, 3, 0x90AA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\x9f'}, 3, 0x501F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\xba'}, 3, 0x52FA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\xba'}, 3, 0x5C3A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\x93'}, 3, 0x6753}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x81', '\xbc'}, 3, 0x707C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\xb5'}, 3, 0x7235}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\x8c'}, 3, 0x914C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x88'}, 3, 0x91C8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xab'}, 3, 0x932B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\xa5'}, 3, 0x82E5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x82'}, 3, 0x5BC2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\xb1'}, 3, 0x5F31}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\xb9'}, 3, 0x60F9}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\xbb'}, 3, 0x4E3B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x96'}, 3, 0x53D6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x88'}, 3, 0x5B88}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\x8b'}, 3, 0x624B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\xb1'}, 3, 0x6731}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\x8a'}, 3, 0x6B8A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\xa9'}, 3, 0x72E9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\xa0'}, 3, 0x73E0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\xae'}, 3, 0x7A2E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\xab'}, 3, 0x816B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb6', '\xa3'}, 3, 0x8DA3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\x92'}, 3, 0x9152}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa6', '\x96'}, 3, 0x9996}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\x92'}, 3, 0x5112}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x97'}, 3, 0x53D7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\xaa'}, 3, 0x546A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xbf'}, 3, 0x5BFF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\x88'}, 3, 0x6388}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\xb9'}, 3, 0x6A39}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xac'}, 3, 0x7DAC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\x80'}, 3, 0x9700}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\x9a'}, 3, 0x56DA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x8e'}, 3, 0x53CE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\xa8'}, 3, 0x5468}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x97'}, 3, 0x5B97}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\xb1'}, 3, 0x5C31}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\x9e'}, 3, 0x5DDE}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\xae'}, 3, 0x4FEE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\x81'}, 3, 0x6101}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\xbe'}, 3, 0x62FE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\xb2'}, 3, 0x6D32}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\x80'}, 3, 0x79C0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\x8b'}, 3, 0x79CB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\x82'}, 3, 0x7D42}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\x8d'}, 3, 0x7E4D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\x92'}, 3, 0x7FD2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\xad'}, 3, 0x81ED}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x9f'}, 3, 0x821F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\x90'}, 3, 0x8490}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\x86'}, 3, 0x8846}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\xb2'}, 3, 0x8972}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xae', '\x90'}, 3, 0x8B90}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\xb4'}, 3, 0x8E74}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\xaf'}, 3, 0x8F2F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\xb1'}, 3, 0x9031}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\x8b'}, 3, 0x914B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\xac'}, 3, 0x916C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x86'}, 3, 0x96C6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\x9c'}, 3, 0x919C}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x80'}, 3, 0x4EC0}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x8f'}, 3, 0x4F4F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x85'}, 3, 0x5145}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x81'}, 3, 0x5341}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x93'}, 3, 0x5F93}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x8e'}, 3, 0x620E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\x94'}, 3, 0x67D4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\x81'}, 3, 0x6C41}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\x8b'}, 3, 0x6E0B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8d', '\xa3'}, 3, 0x7363}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\xa6'}, 3, 0x7E26}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x8d'}, 3, 0x91CD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\x83'}, 3, 0x9283}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x94'}, 3, 0x53D4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\x99'}, 3, 0x5919}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\xbf'}, 3, 0x5BBF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\x91'}, 3, 0x6DD1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\x9d'}, 3, 0x795D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\xae'}, 3, 0x7E2E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\x9b'}, 3, 0x7C9B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\xbe'}, 3, 0x587E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x86', '\x9f'}, 3, 0x719F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xba'}, 3, 0x51FA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\x93'}, 3, 0x8853}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\xb0'}, 3, 0x8FF0}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x8a'}, 3, 0x4FCA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\xbb'}, 3, 0x5CFB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xa5'}, 3, 0x6625}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9e', '\xac'}, 3, 0x77AC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xa3'}, 3, 0x7AE3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x9c'}, 3, 0x821C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\xbf'}, 3, 0x99FF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\x86'}, 3, 0x51C6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\xaa'}, 3, 0x5FAA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\xac'}, 3, 0x65EC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xaf'}, 3, 0x696F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\x89'}, 3, 0x6B89}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xb3'}, 3, 0x6DF3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\x96'}, 3, 0x6E96}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\xa4'}, 3, 0x6F64}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\xbe'}, 3, 0x76FE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x94'}, 3, 0x7D14}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xa1'}, 3, 0x5DE1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xb5'}, 3, 0x9075}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\x87'}, 3, 0x9187}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\x86'}, 3, 0x9806}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xa6'}, 3, 0x51E6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\x9d'}, 3, 0x521D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\x80'}, 3, 0x6240}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\x91'}, 3, 0x6691}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\x99'}, 3, 0x66D9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\x9a'}, 3, 0x6E1A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\xb6'}, 3, 0x5EB6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\x92'}, 3, 0x7DD2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\xb2'}, 3, 0x7F72}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xb8'}, 3, 0x66F8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\xaf'}, 3, 0x85AF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\xb7'}, 3, 0x85F7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\xb8'}, 3, 0x8AF8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xa9'}, 3, 0x52A9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x99'}, 3, 0x53D9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\xb3'}, 3, 0x5973}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\x8f'}, 3, 0x5E8F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x90'}, 3, 0x5F90}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\x95'}, 3, 0x6055}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xa4'}, 3, 0x92E4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\xa4'}, 3, 0x9664}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\xb7'}, 3, 0x50B7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\x9f'}, 3, 0x511F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x9d'}, 3, 0x52DD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\xa0'}, 3, 0x5320}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x87'}, 3, 0x5347}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xac'}, 3, 0x53EC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\xa8'}, 3, 0x54E8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x95', '\x86'}, 3, 0x5546}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x94', '\xb1'}, 3, 0x5531}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x98', '\x97'}, 3, 0x5617}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\xa8'}, 3, 0x5968}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\xbe'}, 3, 0x59BE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa8', '\xbc'}, 3, 0x5A3C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\xb5'}, 3, 0x5BB5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x86'}, 3, 0x5C06}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x8f'}, 3, 0x5C0F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x91'}, 3, 0x5C11}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x9a'}, 3, 0x5C1A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\x84'}, 3, 0x5E84}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\x8a'}, 3, 0x5E8A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xa0'}, 3, 0x5EE0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xb0'}, 3, 0x5F70}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\xbf'}, 3, 0x627F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x84'}, 3, 0x6284}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x9b'}, 3, 0x62DB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\x8c'}, 3, 0x638C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\xb7'}, 3, 0x6377}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x87'}, 3, 0x6607}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x8c'}, 3, 0x660C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xad'}, 3, 0x662D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\xb6'}, 3, 0x6676}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xbe'}, 3, 0x677E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\xa2'}, 3, 0x68A2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\x9f'}, 3, 0x6A1F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\xb5'}, 3, 0x6A35}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\xbc'}, 3, 0x6CBC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\x88'}, 3, 0x6D88}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\x89'}, 3, 0x6E09}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\x98'}, 3, 0x6E58}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x84', '\xbc'}, 3, 0x713C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x84', '\xa6'}, 3, 0x7126}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\xa7'}, 3, 0x7167}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\x87'}, 3, 0x75C7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\x81'}, 3, 0x7701}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa1', '\x9d'}, 3, 0x785D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa4', '\x81'}, 3, 0x7901}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\xa5'}, 3, 0x7965}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\xb0'}, 3, 0x79F0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xa0'}, 3, 0x7AE0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\x91'}, 3, 0x7B11}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\xa7'}, 3, 0x7CA7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\xb9'}, 3, 0x7D39}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\x96'}, 3, 0x8096}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\x96'}, 3, 0x83D6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\x8b'}, 3, 0x848B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\x89'}, 3, 0x8549}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\x9d'}, 3, 0x885D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\xb3'}, 3, 0x88F3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x9f'}, 3, 0x8A1F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\xbc'}, 3, 0x8A3C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\x94'}, 3, 0x8A54}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\xb3'}, 3, 0x8A73}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\xa1'}, 3, 0x8C61}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x9e'}, 3, 0x8CDE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\xa4'}, 3, 0x91A4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\xa6'}, 3, 0x9266}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\xbe'}, 3, 0x937E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x90', '\x98'}, 3, 0x9418}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\x9c'}, 3, 0x969C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\x98'}, 3, 0x9798}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x8a'}, 3, 0x4E0A}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x88'}, 3, 0x4E08}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x9e'}, 3, 0x4E1E}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\x97'}, 3, 0x4E57}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x97'}, 3, 0x5197}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\xb0'}, 3, 0x5270}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\x8e'}, 3, 0x57CE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\xb4'}, 3, 0x5834}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\x8c'}, 3, 0x58CC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xac', '\xa2'}, 3, 0x5B22}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\xb8'}, 3, 0x5E38}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\x85'}, 3, 0x60C5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\xbe'}, 3, 0x64FE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xa1'}, 3, 0x6761}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\x96'}, 3, 0x6756}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\x84'}, 3, 0x6D44}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\xb6'}, 3, 0x72B6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xb3'}, 3, 0x7573}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\xa3'}, 3, 0x7A63}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\xb8'}, 3, 0x84B8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\xb2'}, 3, 0x8B72}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\xb8'}, 3, 0x91B8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xa0'}, 3, 0x9320}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x98', '\xb1'}, 3, 0x5631}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\xb4'}, 3, 0x57F4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\xbe'}, 3, 0x98FE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\xad'}, 3, 0x62ED}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\x8d'}, 3, 0x690D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\x96'}, 3, 0x6B96}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\xad'}, 3, 0x71ED}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\x94'}, 3, 0x7E54}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\xb7'}, 3, 0x8077}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\xb2'}, 3, 0x8272}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa7', '\xa6'}, 3, 0x89E6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\x9f'}, 3, 0x98DF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\x95'}, 3, 0x8755}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\xb1'}, 3, 0x8FB1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\xbb'}, 3, 0x5C3B}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\xb8'}, 3, 0x4F38}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\xa1'}, 3, 0x4FE1}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\xb5'}, 3, 0x4FB5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x94', '\x87'}, 3, 0x5507}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa8', '\xa0'}, 3, 0x5A20}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x9d'}, 3, 0x5BDD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xa9'}, 3, 0x5BE9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\x83'}, 3, 0x5FC3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\x8e'}, 3, 0x614E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\xaf'}, 3, 0x632F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\xb0'}, 3, 0x65B0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\x8b'}, 3, 0x664B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\xae'}, 3, 0x68EE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\x9b'}, 3, 0x699B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\xb8'}, 3, 0x6D78}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xb1'}, 3, 0x6DF1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xb3'}, 3, 0x7533}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\xb9'}, 3, 0x75B9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\x9f'}, 3, 0x771F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\x9e'}, 3, 0x795E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\xa6'}, 3, 0x79E6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\xb3'}, 3, 0x7D33}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\xa3'}, 3, 0x81E3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\xaf'}, 3, 0x82AF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\xaa'}, 3, 0x85AA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\xaa'}, 3, 0x89AA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\xba'}, 3, 0x8A3A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\xab'}, 3, 0x8EAB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\x9b'}, 3, 0x8F9B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\xb2'}, 3, 0x9032}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x9d'}, 3, 0x91DD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\x87'}, 3, 0x9707}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\xba'}, 3, 0x4EBA}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x81'}, 3, 0x4EC1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\x83'}, 3, 0x5203}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\xb5'}, 3, 0x5875}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\xac'}, 3, 0x58EC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x8b'}, 3, 0x5C0B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\x9a'}, 3, 0x751A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\xbd'}, 3, 0x5C3D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\x8e'}, 3, 0x814E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x8a'}, 3, 0x8A0A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\x85'}, 3, 0x8FC5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\xa3'}, 3, 0x9663}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\xad'}, 3, 0x976D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\xa5'}, 3, 0x7B25}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\x8f'}, 3, 0x8ACF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\x88'}, 3, 0x9808}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\xa2'}, 3, 0x9162}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\xb3'}, 3, 0x56F3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\xa8'}, 3, 0x53A8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x97'}, 3, 0x9017}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\xb9'}, 3, 0x5439}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9e', '\x82'}, 3, 0x5782}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\xa5'}, 3, 0x5E25}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\xa8'}, 3, 0x63A8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb0', '\xb4'}, 3, 0x6C34}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\x8a'}, 3, 0x708A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9d', '\xa1'}, 3, 0x7761}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\x8b'}, 3, 0x7C8B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\xa0'}, 3, 0x7FE0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\xb0'}, 3, 0x8870}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x82'}, 3, 0x9042}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\x94'}, 3, 0x9154}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\x90'}, 3, 0x9310}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\x98'}, 3, 0x9318}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\x8f'}, 3, 0x968F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\x9e'}, 3, 0x745E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\x84'}, 3, 0x9AC4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\x87'}, 3, 0x5D07}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb5', '\xa9'}, 3, 0x5D69}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\xb0'}, 3, 0x6570}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\xa2'}, 3, 0x67A2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb6', '\xa8'}, 3, 0x8DA8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x9b'}, 3, 0x96DB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\xae'}, 3, 0x636E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\x89'}, 3, 0x6749}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\x99'}, 3, 0x6919}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\x85'}, 3, 0x83C5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\x97'}, 3, 0x9817}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x80'}, 3, 0x96C0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\xbe'}, 3, 0x88FE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\x84'}, 3, 0x6F84}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x91', '\xba'}, 3, 0x647A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xb8'}, 3, 0x5BF8}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x96'}, 3, 0x4E16}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\xac'}, 3, 0x702C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\x9d'}, 3, 0x755D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xaf'}, 3, 0x662F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\x84'}, 3, 0x51C4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\xb6'}, 3, 0x5236}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\xa2'}, 3, 0x52E2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\x93'}, 3, 0x59D3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x81'}, 3, 0x5F81}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\xa7'}, 3, 0x6027}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x90'}, 3, 0x6210}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\xbf'}, 3, 0x653F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\xb4'}, 3, 0x6574}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x9f'}, 3, 0x661F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\xb4'}, 3, 0x6674}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\xb2'}, 3, 0x68F2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\x96'}, 3, 0x6816}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\xa3'}, 3, 0x6B63}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\x85'}, 3, 0x6E05}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\xb2'}, 3, 0x7272}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\x9f'}, 3, 0x751F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\x9b'}, 3, 0x76DB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\xbe'}, 3, 0x7CBE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\x96'}, 3, 0x8056}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\xb0'}, 3, 0x58F0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\xbd'}, 3, 0x88FD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\xbf'}, 3, 0x897F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xa0'}, 3, 0x8AA0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\x93'}, 3, 0x8A93}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\x8b'}, 3, 0x8ACB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x9d'}, 3, 0x901D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\x92'}, 3, 0x9192}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x92'}, 3, 0x9752}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x99'}, 3, 0x9759}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\x89'}, 3, 0x6589}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\x8e'}, 3, 0x7A0E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\x86'}, 3, 0x8106}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xbb'}, 3, 0x96BB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\xad'}, 3, 0x5E2D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\x9c'}, 3, 0x60DC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x9a'}, 3, 0x621A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\xa5'}, 3, 0x65A5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x94'}, 3, 0x6614}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\x90'}, 3, 0x6790}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9f', '\xb3'}, 3, 0x77F3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\x8d'}, 3, 0x7A4D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\x8d'}, 3, 0x7C4D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\xbe'}, 3, 0x7E3E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\x8a'}, 3, 0x810A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xac'}, 3, 0x8CAC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb5', '\xa4'}, 3, 0x8D64}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\xa1'}, 3, 0x8DE1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\x9f'}, 3, 0x8E5F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\xa9'}, 3, 0x78A9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\x87'}, 3, 0x5207}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x99'}, 3, 0x62D9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\xa5'}, 3, 0x63A5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x91', '\x82'}, 3, 0x6442}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x98'}, 3, 0x6298}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\xad'}, 3, 0x8A2D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\x83'}, 3, 0x7A83}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\x80'}, 3, 0x7BC0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xac'}, 3, 0x8AAC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\xaa'}, 3, 0x96EA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\xb6'}, 3, 0x7D76}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x8c'}, 3, 0x820C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\x89'}, 3, 0x8749}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x99'}, 3, 0x4ED9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x88'}, 3, 0x5148}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x83'}, 3, 0x5343}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xa0'}, 3, 0x5360}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\xa3'}, 3, 0x5BA3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x82'}, 3, 0x5C02}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x96'}, 3, 0x5C16}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\x9d'}, 3, 0x5DDD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\xa6'}, 3, 0x6226}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\x87'}, 3, 0x6247}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\xb0'}, 3, 0x64B0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\x93'}, 3, 0x6813}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\xb4'}, 3, 0x6834}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\x89'}, 3, 0x6CC9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\x85'}, 3, 0x6D45}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\x97'}, 3, 0x6D17}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\x93'}, 3, 0x67D3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\x9c'}, 3, 0x6F5C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\x8e'}, 3, 0x714E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\xbd'}, 3, 0x717D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\x8b'}, 3, 0x65CB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\xbf'}, 3, 0x7A7F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\xad'}, 3, 0x7BAD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\x9a'}, 3, 0x7DDA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\x8a'}, 3, 0x7E4A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\xa8'}, 3, 0x7FA8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\xba'}, 3, 0x817A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x9b'}, 3, 0x821B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\xb9'}, 3, 0x8239}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\xa6'}, 3, 0x85A6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\xae'}, 3, 0x8A6E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x8e'}, 3, 0x8CCE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\xb5'}, 3, 0x8DF5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xb8'}, 3, 0x9078}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xb7'}, 3, 0x9077}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\xad'}, 3, 0x92AD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\x91'}, 3, 0x9291}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\x83'}, 3, 0x9583}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\xae'}, 3, 0x9BAE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\x8d'}, 3, 0x524D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\x84'}, 3, 0x5584}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\xb8'}, 3, 0x6F38}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x84', '\xb6'}, 3, 0x7136}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xa8'}, 3, 0x5168}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\x85'}, 3, 0x7985}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\x95'}, 3, 0x7E55}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\xb3'}, 3, 0x81B3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\x8e'}, 3, 0x7CCE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x99', '\x8c'}, 3, 0x564C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\x91'}, 3, 0x5851}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xa8'}, 3, 0x5CA8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\xaa'}, 3, 0x63AA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xbe'}, 3, 0x66FE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xbd'}, 3, 0x66FD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\x9a'}, 3, 0x695A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\x99'}, 3, 0x72D9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\x8f'}, 3, 0x758F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\x8e'}, 3, 0x758E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa4', '\x8e'}, 3, 0x790E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\x96'}, 3, 0x7956}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\x9f'}, 3, 0x79DF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\x97'}, 3, 0x7C97}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\xa0'}, 3, 0x7D20}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\x84'}, 3, 0x7D44}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x98', '\x87'}, 3, 0x8607}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\xb4'}, 3, 0x8A34}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x98', '\xbb'}, 3, 0x963B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xa1'}, 3, 0x9061}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbc', '\xa0'}, 3, 0x9F20}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\xa7'}, 3, 0x50E7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\xb5'}, 3, 0x5275}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x8c'}, 3, 0x53CC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xa2'}, 3, 0x53E2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\x89'}, 3, 0x5009}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\xaa'}, 3, 0x55AA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\xae'}, 3, 0x58EE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x8f'}, 3, 0x594F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\xbd'}, 3, 0x723D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x8b'}, 3, 0x5B8B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\xa4'}, 3, 0x5C64}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x9d'}, 3, 0x531D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\xa3'}, 3, 0x60E3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\xb3'}, 3, 0x60F3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\x9c'}, 3, 0x635C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\x83'}, 3, 0x6383}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\xbf'}, 3, 0x633F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\xbb'}, 3, 0x63BB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\x8d'}, 3, 0x64CD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\xa9'}, 3, 0x65E9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xb9'}, 3, 0x66F9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xa3'}, 3, 0x5DE3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\x8d'}, 3, 0x69CD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\xbd'}, 3, 0x69FD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\x95'}, 3, 0x6F15}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\xa5'}, 3, 0x71E5}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x89'}, 3, 0x4E89}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\xa9'}, 3, 0x75E9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\xb8'}, 3, 0x76F8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\x93'}, 3, 0x7A93}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\x9f'}, 3, 0x7CDF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\x8f'}, 3, 0x7DCF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\x9c'}, 3, 0x7D9C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\xa1'}, 3, 0x8061}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\x89'}, 3, 0x8349}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\x98'}, 3, 0x8358}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\xac'}, 3, 0x846C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\xbc'}, 3, 0x84BC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\xbb'}, 3, 0x85FB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\x85'}, 3, 0x88C5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb5', '\xb0'}, 3, 0x8D70}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x81'}, 3, 0x9001}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xad'}, 3, 0x906D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8e', '\x97'}, 3, 0x9397}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\x9c'}, 3, 0x971C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa8', '\x92'}, 3, 0x9A12}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\x8f'}, 3, 0x50CF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\x97'}, 3, 0x5897}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\x8e'}, 3, 0x618E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\x93'}, 3, 0x81D3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x94', '\xb5'}, 3, 0x8535}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb4', '\x88'}, 3, 0x8D08}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\xa0'}, 3, 0x9020}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x83'}, 3, 0x4FC3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\xb4'}, 3, 0x5074}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\x87'}, 3, 0x5247}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xb3'}, 3, 0x5373}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\xaf'}, 3, 0x606F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\x89'}, 3, 0x6349}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\x9f'}, 3, 0x675F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xac'}, 3, 0x6E2C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb6', '\xb3'}, 3, 0x8DB3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x9f'}, 3, 0x901F}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x97'}, 3, 0x4FD7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\x9e'}, 3, 0x5C5E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x8a'}, 3, 0x8CCA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\x8f'}, 3, 0x65CF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\x9a'}, 3, 0x7D9A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x92'}, 3, 0x5352}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\x96'}, 3, 0x8896}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xb6'}, 3, 0x5176}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\x83'}, 3, 0x63C3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\x98'}, 3, 0x5B58}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\xab'}, 3, 0x5B6B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x8a'}, 3, 0x5C0A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x90', '\x8d'}, 3, 0x640D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\x91'}, 3, 0x6751}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x9c'}, 3, 0x905C}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x96'}, 3, 0x4ED6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\x9a'}, 3, 0x591A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\xaa'}, 3, 0x592A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\xb0'}, 3, 0x6C70}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\x91'}, 3, 0x8A51}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x94', '\xbe'}, 3, 0x553E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\x95'}, 3, 0x5815}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\xa5'}, 3, 0x59A5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\xb0'}, 3, 0x60F0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\x93'}, 3, 0x6253}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\x81'}, 3, 0x67C1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\xb5'}, 3, 0x8235}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\x95'}, 3, 0x6955}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\x80'}, 3, 0x9640}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\x84'}, 3, 0x99C4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa8', '\xa8'}, 3, 0x9A28}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x93'}, 3, 0x4F53}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\x86'}, 3, 0x5806}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xbe'}, 3, 0x5BFE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\x90'}, 3, 0x8010}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xb1'}, 3, 0x5CB1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\xaf'}, 3, 0x5E2F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x85'}, 3, 0x5F85}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\xa0'}, 3, 0x6020}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\x8b'}, 3, 0x614B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\xb4'}, 3, 0x6234}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xbf'}, 3, 0x66FF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\xb0'}, 3, 0x6CF0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\x9e'}, 3, 0x6EDE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\x8e'}, 3, 0x80CE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\xbf'}, 3, 0x817F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\x94'}, 3, 0x82D4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\x8b'}, 3, 0x888B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xb8'}, 3, 0x8CB8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x80'}, 3, 0x9000}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\xae'}, 3, 0x902E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\x8a'}, 3, 0x968A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\x9b'}, 3, 0x9EDB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\x9b'}, 3, 0x9BDB}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\xa3'}, 3, 0x4EE3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xb0'}, 3, 0x53F0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\xa7'}, 3, 0x5927}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\xac'}, 3, 0x7B2C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\x8d'}, 3, 0x918D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\x8c'}, 3, 0x984C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb7', '\xb9'}, 3, 0x9DF9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\x9d'}, 3, 0x6EDD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\xa7'}, 3, 0x7027}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x93'}, 3, 0x5353}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x95', '\x84'}, 3, 0x5544}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x85'}, 3, 0x5B85}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\x98'}, 3, 0x6258}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x9e'}, 3, 0x629E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x93'}, 3, 0x62D3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\xa2'}, 3, 0x6CA2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\xaf'}, 3, 0x6FEF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xa2'}, 3, 0x7422}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x97'}, 3, 0x8A17}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x90', '\xb8'}, 3, 0x9438}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\x81'}, 3, 0x6FC1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\xbe'}, 3, 0x8AFE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\xb8'}, 3, 0x8338}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xa7'}, 3, 0x51E7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\xb8'}, 3, 0x86F8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xaa'}, 3, 0x53EA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xa9'}, 3, 0x53E9}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x86'}, 3, 0x4F46}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x94'}, 3, 0x9054}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\xb0'}, 3, 0x8FB0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\xaa'}, 3, 0x596A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\xb1'}, 3, 0x8131}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xbd'}, 3, 0x5DFD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xaa'}, 3, 0x7AEA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\xbf'}, 3, 0x8FBF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x9a'}, 3, 0x68DA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb0', '\xb7'}, 3, 0x8C37}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\xb8'}, 3, 0x72F8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb1', '\x88'}, 3, 0x9C48}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\xbd'}, 3, 0x6A3D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xb0'}, 3, 0x8AB0}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\xb9'}, 3, 0x4E39}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x98'}, 3, 0x5358}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x98', '\x86'}, 3, 0x5606}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\xa6'}, 3, 0x5766}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x85'}, 3, 0x62C5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\xa2'}, 3, 0x63A2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\xa6'}, 3, 0x65E6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\x8e'}, 3, 0x6B4E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xa1'}, 3, 0x6DE1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\x9b'}, 3, 0x6E5B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\xad'}, 3, 0x70AD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9f', '\xad'}, 3, 0x77ED}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xaf'}, 3, 0x7AEF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\xaa'}, 3, 0x7BAA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xbb'}, 3, 0x7DBB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\xbd'}, 3, 0x803D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\x86'}, 3, 0x80C6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\x8b'}, 3, 0x86CB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\x95'}, 3, 0x8A95}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\x9b'}, 3, 0x935B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\xa3'}, 3, 0x56E3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\x87'}, 3, 0x58C7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\xbe'}, 3, 0x5F3E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\xad'}, 3, 0x65AD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\x96'}, 3, 0x6696}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaa', '\x80'}, 3, 0x6A80}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\xb5'}, 3, 0x6BB5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xb7'}, 3, 0x7537}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\x87'}, 3, 0x8AC7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\xa4'}, 3, 0x5024}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9f', '\xa5'}, 3, 0x77E5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\xb0'}, 3, 0x5730}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x9b'}, 3, 0x5F1B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\xa5'}, 3, 0x6065}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\xba'}, 3, 0x667A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\xa0'}, 3, 0x6C60}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\xb4'}, 3, 0x75F4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\x9a'}, 3, 0x7A1A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\xae'}, 3, 0x7F6E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\xb4'}, 3, 0x81F4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\x98'}, 3, 0x8718}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x85'}, 3, 0x9045}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa6', '\xb3'}, 3, 0x99B3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\x89'}, 3, 0x7BC9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\x9c'}, 3, 0x755C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xb9'}, 3, 0x7AF9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\x91'}, 3, 0x7B51}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\x84'}, 3, 0x84C4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x90'}, 3, 0x9010}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\xa9'}, 3, 0x79E9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\x92'}, 3, 0x7A92}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\xb6'}, 3, 0x8336}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xab', '\xa1'}, 3, 0x5AE1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9d', '\x80'}, 3, 0x7740}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\xad'}, 3, 0x4E2D}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\xb2'}, 3, 0x4EF2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x99'}, 3, 0x5B99}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\xa0'}, 3, 0x5FE0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\xbd'}, 3, 0x62BD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xbc'}, 3, 0x663C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\xb1'}, 3, 0x67F1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\xa8'}, 3, 0x6CE8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x99', '\xab'}, 3, 0x866B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\xb7'}, 3, 0x8877}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\xbb'}, 3, 0x8A3B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\x8e'}, 3, 0x914E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xb3'}, 3, 0x92F3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\x90'}, 3, 0x99D0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\x97'}, 3, 0x6A17}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\xa6'}, 3, 0x7026}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\xaa'}, 3, 0x732A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\xa7'}, 3, 0x82E7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\x97'}, 3, 0x8457}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xaf'}, 3, 0x8CAF}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x81'}, 3, 0x4E01}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x86'}, 3, 0x5146}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\x8b'}, 3, 0x51CB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\x8b'}, 3, 0x558B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xb5'}, 3, 0x5BF5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\x96'}, 3, 0x5E16}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\xb3'}, 3, 0x5E33}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\x81'}, 3, 0x5E81}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x94'}, 3, 0x5F14}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\xb5'}, 3, 0x5F35}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xab'}, 3, 0x5F6B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\xb4'}, 3, 0x5FB4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\xb2'}, 3, 0x61F2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\x91'}, 3, 0x6311}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\xa2'}, 3, 0x66A2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x9d'}, 3, 0x671D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\xae'}, 3, 0x6F6E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\x92'}, 3, 0x7252}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xba'}, 3, 0x753A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\xba'}, 3, 0x773A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\xb4'}, 3, 0x8074}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\xb9'}, 3, 0x8139}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\xb8'}, 3, 0x8178}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\xb6'}, 3, 0x8776}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xbf'}, 3, 0x8ABF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\x9c'}, 3, 0x8ADC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb6', '\x85'}, 3, 0x8D85}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\xb3'}, 3, 0x8DF3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\x9a'}, 3, 0x929A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x95', '\xb7'}, 3, 0x9577}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\x82'}, 3, 0x9802}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb3', '\xa5'}, 3, 0x9CE5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x85'}, 3, 0x52C5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\x97'}, 3, 0x6357}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\xb4'}, 3, 0x76F4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x95'}, 3, 0x6715}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\x88'}, 3, 0x6C88}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\x8d'}, 3, 0x73CD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x83'}, 3, 0x8CC3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8e', '\xae'}, 3, 0x93AE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\xb3'}, 3, 0x9673}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\xa5'}, 3, 0x6D25}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\x9c'}, 3, 0x589C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\x8e'}, 3, 0x690E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\x8c'}, 3, 0x69CC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\xbd'}, 3, 0x8FFD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8e', '\x9a'}, 3, 0x939A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\x9b'}, 3, 0x75DB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x9a'}, 3, 0x901A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\x9a'}, 3, 0x585A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\x82'}, 3, 0x6802}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\xb4'}, 3, 0x63B4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\xbb'}, 3, 0x69FB}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x83'}, 3, 0x4F43}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\xac'}, 3, 0x6F2C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\x98'}, 3, 0x67D8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\xbb'}, 3, 0x8FBB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x94', '\xa6'}, 3, 0x8526}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xb4'}, 3, 0x7DB4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\x94'}, 3, 0x9354}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\xbf'}, 3, 0x693F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\xb0'}, 3, 0x6F70}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\xaa'}, 3, 0x576A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\xb7'}, 3, 0x58F7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xac', '\xac'}, 3, 0x5B2C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\xac'}, 3, 0x7D2C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\xaa'}, 3, 0x722A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x8a'}, 3, 0x540A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\xa3'}, 3, 0x91E3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb6', '\xb4'}, 3, 0x9DB4}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\xad'}, 3, 0x4EAD}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x8e'}, 3, 0x4F4E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x9c'}, 3, 0x505C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\xb5'}, 3, 0x5075}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\x83'}, 3, 0x5243}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\x9e'}, 3, 0x8C9E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\x88'}, 3, 0x5448}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\xa4'}, 3, 0x5824}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x9a'}, 3, 0x5B9A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\x9d'}, 3, 0x5E1D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\x95'}, 3, 0x5E95}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\xad'}, 3, 0x5EAD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xb7'}, 3, 0x5EF7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x9f'}, 3, 0x5F1F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x8c'}, 3, 0x608C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\xb5'}, 3, 0x62B5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\xba'}, 3, 0x633A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\x90'}, 3, 0x63D0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\xaf'}, 3, 0x68AF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\x80'}, 3, 0x6C40}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\x87'}, 3, 0x7887}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\x8e'}, 3, 0x798E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\x8b'}, 3, 0x7A0B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\xa0'}, 3, 0x7DE0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\x87'}, 3, 0x8247}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x82'}, 3, 0x8A02}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\xa6'}, 3, 0x8AE6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\x84'}, 3, 0x8E44}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x93'}, 3, 0x9013}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\xb8'}, 3, 0x90B8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x84', '\xad'}, 3, 0x912D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x98'}, 3, 0x91D8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbc', '\x8e'}, 3, 0x9F0E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\xa5'}, 3, 0x6CE5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x91', '\x98'}, 3, 0x6458}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\xa2'}, 3, 0x64E2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\xb5'}, 3, 0x6575}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\xb4'}, 3, 0x6EF4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x84'}, 3, 0x7684}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\x9b'}, 3, 0x7B1B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xa9'}, 3, 0x9069}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\x91'}, 3, 0x93D1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\xba'}, 3, 0x6EBA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\xb2'}, 3, 0x54F2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\xb9'}, 3, 0x5FB9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\xa4'}, 3, 0x64A4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbd', '\x8d'}, 3, 0x8F4D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\xad'}, 3, 0x8FED}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x84'}, 3, 0x9244}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xb8'}, 3, 0x5178}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\xab'}, 3, 0x586B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\xa9'}, 3, 0x5929}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\x95'}, 3, 0x5C55}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\x97'}, 3, 0x5E97}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xbb'}, 3, 0x6DFB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xba', '\x8f'}, 3, 0x7E8F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\x9c'}, 3, 0x751C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xbc'}, 3, 0x8CBC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\xa2'}, 3, 0x8EE2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\x9b'}, 3, 0x985B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\xb9'}, 3, 0x70B9}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\x9d'}, 3, 0x4F1D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\xbf'}, 3, 0x6BBF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\xb1'}, 3, 0x6FB1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xb0'}, 3, 0x7530}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\xbb'}, 3, 0x96FB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x8e'}, 3, 0x514E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x90'}, 3, 0x5410}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\xb5'}, 3, 0x5835}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\x97'}, 3, 0x5857}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\xac'}, 3, 0x59AC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\xa0'}, 3, 0x5C60}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x92'}, 3, 0x5F92}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\x97'}, 3, 0x6597}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\x9c'}, 3, 0x675C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xa1'}, 3, 0x6E21}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\xbb'}, 3, 0x767B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\x9f'}, 3, 0x83DF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\xad'}, 3, 0x8CED}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x94'}, 3, 0x9014}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x83', '\xbd'}, 3, 0x90FD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\x8d'}, 3, 0x934D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa0', '\xa5'}, 3, 0x7825}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa0', '\xba'}, 3, 0x783A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xaa'}, 3, 0x52AA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\xa6'}, 3, 0x5EA6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\x9f'}, 3, 0x571F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\xb4'}, 3, 0x5974}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\x92'}, 3, 0x6012}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\x92'}, 3, 0x5012}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x9a'}, 3, 0x515A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xac'}, 3, 0x51AC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\x8d'}, 3, 0x51CD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\x80'}, 3, 0x5200}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x94', '\x90'}, 3, 0x5510}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\x94'}, 3, 0x5854}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\x98'}, 3, 0x5858}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x97'}, 3, 0x5957}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x95'}, 3, 0x5B95}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\xb6'}, 3, 0x5CF6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\x8b'}, 3, 0x5D8B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\xbc'}, 3, 0x60BC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x95'}, 3, 0x6295}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x90', '\xad'}, 3, 0x642D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xb1'}, 3, 0x6771}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x83'}, 3, 0x6843}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\xbc'}, 3, 0x68BC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x9f'}, 3, 0x68DF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\x97'}, 3, 0x76D7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\x98'}, 3, 0x6DD8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\xaf'}, 3, 0x6E6F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\x9b'}, 3, 0x6D9B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x81', '\xaf'}, 3, 0x706F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\x88'}, 3, 0x71C8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\x93'}, 3, 0x5F53}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\x98'}, 3, 0x75D8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\xb7'}, 3, 0x7977}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\x89'}, 3, 0x7B49}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\x94'}, 3, 0x7B54}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\x92'}, 3, 0x7B52}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\x96'}, 3, 0x7CD6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\xb1'}, 3, 0x7D71}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\xb0'}, 3, 0x5230}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\xa3'}, 3, 0x8463}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\xa9'}, 3, 0x8569}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\xa4'}, 3, 0x85E4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x8e'}, 3, 0x8A0E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\x84'}, 3, 0x8B04}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\x86'}, 3, 0x8C46}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb8', '\x8f'}, 3, 0x8E0F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x83'}, 3, 0x9003}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x8f'}, 3, 0x900F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x90', '\x99'}, 3, 0x9419}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\xb6'}, 3, 0x9676}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\xad'}, 3, 0x982D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa8', '\xb0'}, 3, 0x9A30}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x97', '\x98'}, 3, 0x95D8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\x8d'}, 3, 0x50CD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x95'}, 3, 0x52D5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x8c'}, 3, 0x540C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\x82'}, 3, 0x5802}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x8e'}, 3, 0x5C0E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\xa7'}, 3, 0x61A7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\x9e'}, 3, 0x649E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\x9e'}, 3, 0x6D1E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9e', '\xb3'}, 3, 0x77B3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xa5'}, 3, 0x7AE5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\xb4'}, 3, 0x80F4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\x84'}, 3, 0x8404}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x93'}, 3, 0x9053}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\x85'}, 3, 0x9285}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\xa0'}, 3, 0x5CE0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\x87'}, 3, 0x9D07}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\xbf'}, 3, 0x533F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x97'}, 3, 0x5F97}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\xb3'}, 3, 0x5FB3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\x9c'}, 3, 0x6D9C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\xb9'}, 3, 0x7279}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9d', '\xa3'}, 3, 0x7763}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\xbf'}, 3, 0x79BF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\xa4'}, 3, 0x7BE4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\x92'}, 3, 0x6BD2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\xac'}, 3, 0x72EC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xad'}, 3, 0x8AAD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\x83'}, 3, 0x6803}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\xa1'}, 3, 0x6A61}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xb8'}, 3, 0x51F8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\x81'}, 3, 0x7A81}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\xb4'}, 3, 0x6934}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\x8a'}, 3, 0x5C4A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb3', '\xb6'}, 3, 0x9CF6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\xab'}, 3, 0x82EB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x85'}, 3, 0x5BC5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\x89'}, 3, 0x9149}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\x9e'}, 3, 0x701E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x99', '\xb8'}, 3, 0x5678}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\xaf'}, 3, 0x5C6F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\x87'}, 3, 0x60C7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\xa6'}, 3, 0x6566}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\x8c'}, 3, 0x6C8C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\x9a'}, 3, 0x8C5A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x81'}, 3, 0x9041}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\x93'}, 3, 0x9813}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\x91'}, 3, 0x5451}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\x87'}, 3, 0x66C7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\x8d'}, 3, 0x920D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x88'}, 3, 0x5948}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\xa3'}, 3, 0x90A3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x85'}, 3, 0x5185}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\x8d'}, 3, 0x4E4D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xaa'}, 3, 0x51EA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\x99'}, 3, 0x8599}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\x8e'}, 3, 0x8B0E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x81', '\x98'}, 3, 0x7058}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\xba'}, 3, 0x637A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\x8b'}, 3, 0x934B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xa2'}, 3, 0x6962}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa6', '\xb4'}, 3, 0x99B4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\x84'}, 3, 0x7E04}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xb7'}, 3, 0x7577}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x97'}, 3, 0x5357}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xa0'}, 3, 0x6960}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\x9f'}, 3, 0x8EDF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\xa3'}, 3, 0x96E3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\x9d'}, 3, 0x6C5D}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x8c'}, 3, 0x4E8C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\xbc'}, 3, 0x5C3C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x90'}, 3, 0x5F10}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\xa9'}, 3, 0x8FE9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x82'}, 3, 0x5302}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x91'}, 3, 0x8CD1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\x89'}, 3, 0x8089}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x99', '\xb9'}, 3, 0x8679}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xbf'}, 3, 0x5EFF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\xa5'}, 3, 0x65E5}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\xb3'}, 3, 0x4E73}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xa5'}, 3, 0x5165}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\x82'}, 3, 0x5982}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\xbf'}, 3, 0x5C3F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9f', '\xae'}, 3, 0x97EE}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\xbb'}, 3, 0x4EFB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\x8a'}, 3, 0x598A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\x8d'}, 3, 0x5FCD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\x8d'}, 3, 0x8A8D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\xa1'}, 3, 0x6FE1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\xb0'}, 3, 0x79B0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\xa2'}, 3, 0x7962}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xa7'}, 3, 0x5BE7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\xb1'}, 3, 0x8471}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\xab'}, 3, 0x732B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x86', '\xb1'}, 3, 0x71B1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xb4'}, 3, 0x5E74}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\xb5'}, 3, 0x5FF5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\xbb'}, 3, 0x637B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\x9a'}, 3, 0x649A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\x83'}, 3, 0x71C3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\x98'}, 3, 0x7C98}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\x83'}, 3, 0x4E43}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xbc'}, 3, 0x5EFC}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\x8b'}, 3, 0x4E4B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\x9c'}, 3, 0x57DC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9a', '\xa2'}, 3, 0x56A2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\xa9'}, 3, 0x60A9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\x83'}, 3, 0x6FC3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x8d'}, 3, 0x7D0D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\xbd'}, 3, 0x80FD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\xb3'}, 3, 0x8133}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\xbf'}, 3, 0x81BF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\xb2'}, 3, 0x8FB2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\x97'}, 3, 0x8997}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9a', '\xa4'}, 3, 0x86A4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xb4'}, 3, 0x5DF4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x8a'}, 3, 0x628A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\xad'}, 3, 0x64AD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\x87'}, 3, 0x8987}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xb7'}, 3, 0x6777}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\xa2'}, 3, 0x6CE2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\xbe'}, 3, 0x6D3E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xb6'}, 3, 0x7436}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa0', '\xb4'}, 3, 0x7834}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa9', '\x86'}, 3, 0x5A46}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\xb5'}, 3, 0x7F75}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\xad'}, 3, 0x82AD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa6', '\xac'}, 3, 0x99AC}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\xb3'}, 3, 0x4FF3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\x83'}, 3, 0x5EC3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x9d'}, 3, 0x62DD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\x92'}, 3, 0x6392}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\x97'}, 3, 0x6557}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xaf'}, 3, 0x676F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\x83'}, 3, 0x76C3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\x8c'}, 3, 0x724C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\x8c'}, 3, 0x80CC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\xba'}, 3, 0x80BA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\xa9'}, 3, 0x8F29}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\x8d'}, 3, 0x914D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\x8d'}, 3, 0x500D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\xb9'}, 3, 0x57F9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaa', '\x92'}, 3, 0x5A92}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\x85'}, 3, 0x6885}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xb3'}, 3, 0x6973}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\xa4'}, 3, 0x7164}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\xbd'}, 3, 0x72FD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xb7'}, 3, 0x8CB7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\xb2'}, 3, 0x58F2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\xa0'}, 3, 0x8CE0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\xaa'}, 3, 0x966A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x99'}, 3, 0x9019}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\xbf'}, 3, 0x877F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\xa4'}, 3, 0x79E4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9f', '\xa7'}, 3, 0x77E7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\xa9'}, 3, 0x8429}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\xaf'}, 3, 0x4F2F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\xa5'}, 3, 0x5265}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x9a'}, 3, 0x535A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x8d'}, 3, 0x62CD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\x8f'}, 3, 0x67CF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\x8a'}, 3, 0x6CCA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\xbd'}, 3, 0x767D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x94'}, 3, 0x7B94}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\x95'}, 3, 0x7C95}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\xb6'}, 3, 0x8236}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\x84'}, 3, 0x8584}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\xab'}, 3, 0x8FEB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\x9d'}, 3, 0x66DD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\xa0'}, 3, 0x6F20}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\x86'}, 3, 0x7206}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\x9b'}, 3, 0x7E1B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\xab'}, 3, 0x83AB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\x81'}, 3, 0x99C1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\xa6'}, 3, 0x9EA6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xbd'}, 3, 0x51FD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\xb1'}, 3, 0x7BB1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa1', '\xb2'}, 3, 0x7872}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\xb8'}, 3, 0x7BB8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\x87'}, 3, 0x8087}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\x88'}, 3, 0x7B48}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\xa8'}, 3, 0x6AE8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xa1'}, 3, 0x5E61}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\x8c'}, 3, 0x808C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\x91'}, 3, 0x7551}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xa0'}, 3, 0x7560}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xab'}, 3, 0x516B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\xa2'}, 3, 0x9262}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\x8c'}, 3, 0x6E8C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\xba'}, 3, 0x767A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\x97'}, 3, 0x9197}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\xaa'}, 3, 0x9AEA}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\x90'}, 3, 0x4F10}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\xb0'}, 3, 0x7F70}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x9c'}, 3, 0x629C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\x8f'}, 3, 0x7B4F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\xa5'}, 3, 0x95A5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb3', '\xa9'}, 3, 0x9CE9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x99', '\xba'}, 3, 0x567A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\x99'}, 3, 0x5859}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\xa4'}, 3, 0x86E4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xbc'}, 3, 0x96BC}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\xb4'}, 3, 0x4F34}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\xa4'}, 3, 0x5224}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x8a'}, 3, 0x534A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x8d'}, 3, 0x53CD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x9b'}, 3, 0x53DB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\x86'}, 3, 0x5E06}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x90', '\xac'}, 3, 0x642C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\x91'}, 3, 0x6591}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xbf'}, 3, 0x677F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb0', '\xbe'}, 3, 0x6C3E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\x8e'}, 3, 0x6C4E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\x88'}, 3, 0x7248}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\xaf'}, 3, 0x72AF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\xad'}, 3, 0x73ED}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\x94'}, 3, 0x7554}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\x81'}, 3, 0x7E41}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\xac'}, 3, 0x822C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\xa9'}, 3, 0x85E9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xa9'}, 3, 0x8CA9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\x84'}, 3, 0x7BC4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x86'}, 3, 0x91C6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\xa9'}, 3, 0x7169}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\x92'}, 3, 0x9812}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\xaf'}, 3, 0x98EF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\xbd'}, 3, 0x633D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\xa9'}, 3, 0x6669}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xaa'}, 3, 0x756A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\xa4'}, 3, 0x76E4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa3', '\x90'}, 3, 0x78D0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\x83'}, 3, 0x8543}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\xae'}, 3, 0x86EE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\xaa'}, 3, 0x532A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x91'}, 3, 0x5351}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\xa6'}, 3, 0x5426}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\x83'}, 3, 0x5983}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\x87'}, 3, 0x5E87}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xbc'}, 3, 0x5F7C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\xb2'}, 3, 0x60B2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\x89'}, 3, 0x6249}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\xb9'}, 3, 0x6279}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\xab'}, 3, 0x62AB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\x90'}, 3, 0x6590}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\x94'}, 3, 0x6BD4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\x8c'}, 3, 0x6CCC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\xb2'}, 3, 0x75B2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\xae'}, 3, 0x76AE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\x91'}, 3, 0x7891}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\x98'}, 3, 0x79D8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\x8b'}, 3, 0x7DCB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\xb7'}, 3, 0x7F77}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\xa5'}, 3, 0x80A5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\xab'}, 3, 0x88AB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xb9'}, 3, 0x8AB9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xbb'}, 3, 0x8CBB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xbf'}, 3, 0x907F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x9e'}, 3, 0x975E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\x9b'}, 3, 0x98DB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\x8b'}, 3, 0x6A0B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\xb8'}, 3, 0x7C38}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\x99'}, 3, 0x5099}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\xbe'}, 3, 0x5C3E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\xae'}, 3, 0x5FAE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\x87'}, 3, 0x6787}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\x98'}, 3, 0x6BD8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xb5'}, 3, 0x7435}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\x89'}, 3, 0x7709}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\x8e'}, 3, 0x7F8E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbc', '\xbb'}, 3, 0x9F3B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\x8a'}, 3, 0x67CA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\x97'}, 3, 0x7A17}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\xb9'}, 3, 0x5339}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\x8b'}, 3, 0x758B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\xad'}, 3, 0x9AED}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xa6'}, 3, 0x5F66}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\x9d'}, 3, 0x819D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\xb1'}, 3, 0x83F1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\x98'}, 3, 0x8098}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\xbc'}, 3, 0x5F3C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\x85'}, 3, 0x5FC5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xa2'}, 3, 0x7562}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\x86'}, 3, 0x7B46}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\xbc'}, 3, 0x903C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\xa7'}, 3, 0x6867}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\xab'}, 3, 0x59EB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaa', '\x9b'}, 3, 0x5A9B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x90'}, 3, 0x7D10}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\xbe'}, 3, 0x767E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\xac'}, 3, 0x8B2C}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\xb5'}, 3, 0x4FF5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xaa'}, 3, 0x5F6A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\x99'}, 3, 0x6A19}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb0', '\xb7'}, 3, 0x6C37}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\x82'}, 3, 0x6F02}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\xa2'}, 3, 0x74E2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\xa8'}, 3, 0x7968}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\xa8'}, 3, 0x8868}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\x95'}, 3, 0x8A55}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\xb9'}, 3, 0x8C79}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\x9f'}, 3, 0x5EDF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\x8f'}, 3, 0x63CF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\x85'}, 3, 0x75C5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\x92'}, 3, 0x79D2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\x97'}, 3, 0x82D7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xa8'}, 3, 0x9328}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xb2'}, 3, 0x92F2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\x9c'}, 3, 0x849C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\xad'}, 3, 0x86ED}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\xad'}, 3, 0x9C2D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\x81'}, 3, 0x54C1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xac'}, 3, 0x5F6C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\x8c'}, 3, 0x658C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\x9c'}, 3, 0x6D5C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\x95'}, 3, 0x7015}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xa7'}, 3, 0x8CA7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x93'}, 3, 0x8CD3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\xbb'}, 3, 0x983B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\x8f'}, 3, 0x654F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\xb6'}, 3, 0x74F6}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x8d'}, 3, 0x4E0D}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x98'}, 3, 0x4ED8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\xa0'}, 3, 0x57E0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\xab'}, 3, 0x592B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa9', '\xa6'}, 3, 0x5A66}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x8c'}, 3, 0x5BCC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xa8'}, 3, 0x51A8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\x83'}, 3, 0x5E03}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\x9c'}, 3, 0x5E9C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\x96'}, 3, 0x6016}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\xb6'}, 3, 0x6276}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\xb7'}, 3, 0x6577}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\xa7'}, 3, 0x65A7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\xae'}, 3, 0x666E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\xae'}, 3, 0x6D6E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\xb6'}, 3, 0x7236}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\xa6'}, 3, 0x7B26}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\x90'}, 3, 0x8150}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\x9a'}, 3, 0x819A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\x99'}, 3, 0x8299}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\x9c'}, 3, 0x8B5C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xa0'}, 3, 0x8CA0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\xa6'}, 3, 0x8CE6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb5', '\xb4'}, 3, 0x8D74}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x98', '\x9c'}, 3, 0x961C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\x84'}, 3, 0x9644}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\xae'}, 3, 0x4FAE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\xab'}, 3, 0x64AB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\xa6'}, 3, 0x6B66}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x9e'}, 3, 0x821E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\xa1'}, 3, 0x8461}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\xaa'}, 3, 0x856A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x83', '\xa8'}, 3, 0x90E8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x81'}, 3, 0x5C01}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\x93'}, 3, 0x6953}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa2', '\xa8'}, 3, 0x98A8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\xba'}, 3, 0x847A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\x97'}, 3, 0x8557}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\x8f'}, 3, 0x4F0F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\xaf'}, 3, 0x526F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\xa9'}, 3, 0x5FA9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\x85'}, 3, 0x5E45}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x8d'}, 3, 0x670D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\x8f'}, 3, 0x798F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\xb9'}, 3, 0x8179}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\x87'}, 3, 0x8907}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\x86'}, 3, 0x8986}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xb5'}, 3, 0x6DF5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x97'}, 3, 0x5F17}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\x95'}, 3, 0x6255}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\xb8'}, 3, 0x6CB8}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x8f'}, 3, 0x4ECF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\xa9'}, 3, 0x7269}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\x92'}, 3, 0x9B92}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\x86'}, 3, 0x5206}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\xbb'}, 3, 0x543B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x99', '\xb4'}, 3, 0x5674}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\xb3'}, 3, 0x58B3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\xa4'}, 3, 0x61A4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\xae'}, 3, 0x626E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x84', '\x9a'}, 3, 0x711A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\xae'}, 3, 0x596E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\x89'}, 3, 0x7C89}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\x9e'}, 3, 0x7CDE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x9b'}, 3, 0x7D1B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\xb0'}, 3, 0x96F0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\x87'}, 3, 0x6587}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\x9e'}, 3, 0x805E}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x99'}, 3, 0x4E19}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\xb5'}, 3, 0x4F75}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xb5'}, 3, 0x5175}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\x80'}, 3, 0x5840}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xa3'}, 3, 0x5E63}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xb3'}, 3, 0x5E73}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x8a'}, 3, 0x5F0A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\x84'}, 3, 0x67C4}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\xa6'}, 3, 0x4E26}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x94', '\xbd'}, 3, 0x853D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\x89'}, 3, 0x9589}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\x9b'}, 3, 0x965B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\xb3'}, 3, 0x7C73}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\x81'}, 3, 0x9801}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\xbb'}, 3, 0x50FB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\x81'}, 3, 0x58C1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\x96'}, 3, 0x7656}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\xa7'}, 3, 0x78A7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\xa5'}, 3, 0x5225}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9e', '\xa5'}, 3, 0x77A5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x94', '\x91'}, 3, 0x8511}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x86'}, 3, 0x7B86}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x8f'}, 3, 0x504F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\x89'}, 3, 0x5909}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\x87'}, 3, 0x7247}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\x87'}, 3, 0x7BC7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\xa8'}, 3, 0x7DE8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\xba'}, 3, 0x8FBA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\x94'}, 3, 0x8FD4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x8d'}, 3, 0x904D}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\xbf'}, 3, 0x4FBF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x89'}, 3, 0x52C9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa8', '\xa9'}, 3, 0x5A29}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x81'}, 3, 0x5F01}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\xad'}, 3, 0x97AD}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x9d'}, 3, 0x4FDD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x97'}, 3, 0x8217}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xaa'}, 3, 0x92EA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\x83'}, 3, 0x5703}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\x95'}, 3, 0x6355}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\xa9'}, 3, 0x6B69}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xab'}, 3, 0x752B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\x9c'}, 3, 0x88DC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\x94'}, 3, 0x8F14}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\x82'}, 3, 0x7A42}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x9f'}, 3, 0x52DF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\x93'}, 3, 0x5893}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\x95'}, 3, 0x6155}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x8a'}, 3, 0x620A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\xae'}, 3, 0x66AE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\x8d'}, 3, 0x6BCD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\xbf'}, 3, 0x7C3F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\xa9'}, 3, 0x83E9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\xa3'}, 3, 0x5023}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\xb8'}, 3, 0x4FF8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x85'}, 3, 0x5305}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\x86'}, 3, 0x5446}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\xb1'}, 3, 0x5831}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x89'}, 3, 0x5949}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x9d'}, 3, 0x5B9D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\xb0'}, 3, 0x5CF0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\xaf'}, 3, 0x5CEF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\xa9'}, 3, 0x5D29}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\x96'}, 3, 0x5E96}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\xb1'}, 3, 0x62B1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\xa7'}, 3, 0x6367}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\xbe'}, 3, 0x653E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\xb9'}, 3, 0x65B9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x8b'}, 3, 0x670B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\x95'}, 3, 0x6CD5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\xa1'}, 3, 0x6CE1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x83', '\xb9'}, 3, 0x70F9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa0', '\xb2'}, 3, 0x7832}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\xab'}, 3, 0x7E2B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\x9e'}, 3, 0x80DE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\xb3'}, 3, 0x82B3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\x8c'}, 3, 0x840C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\xac'}, 3, 0x84EC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\x82'}, 3, 0x8702}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\x92'}, 3, 0x8912}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\xaa'}, 3, 0x8A2A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\x8a'}, 3, 0x8C4A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\xa6'}, 3, 0x90A6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\x92'}, 3, 0x92D2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\xbd'}, 3, 0x98FD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb3', '\xb3'}, 3, 0x9CF3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\xac'}, 3, 0x9D6C}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\x8f'}, 3, 0x4E4F}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\xa1'}, 3, 0x4EA1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\x8d'}, 3, 0x508D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\x96'}, 3, 0x5256}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\x8a'}, 3, 0x574A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\xa8'}, 3, 0x59A8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\xbd'}, 3, 0x5E3D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\x98'}, 3, 0x5FD8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\x99'}, 3, 0x5FD9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\xbf'}, 3, 0x623F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\xb4'}, 3, 0x66B4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x9b'}, 3, 0x671B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\x90'}, 3, 0x67D0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x92'}, 3, 0x68D2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x92'}, 3, 0x5192}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\xa1'}, 3, 0x7D21}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\xaa'}, 3, 0x80AA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\xa8'}, 3, 0x81A8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\x80'}, 3, 0x8B00}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\x8c'}, 3, 0x8C8C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xbf'}, 3, 0x8CBF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\xbe'}, 3, 0x927E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x98', '\xb2'}, 3, 0x9632}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\xa0'}, 3, 0x5420}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\xac'}, 3, 0x982C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x97'}, 3, 0x5317}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\x95'}, 3, 0x50D5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x9c'}, 3, 0x535C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\xa8'}, 3, 0x58A8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\xb2'}, 3, 0x64B2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\xb4'}, 3, 0x6734}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\xa7'}, 3, 0x7267}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9d', '\xa6'}, 3, 0x7766}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\x86'}, 3, 0x7A46}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\xa6'}, 3, 0x91E6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x83'}, 3, 0x52C3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\xa1'}, 3, 0x6CA1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\x86'}, 3, 0x6B86}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\x80'}, 3, 0x5800}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\x8c'}, 3, 0x5E4C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x94'}, 3, 0x5954}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\xac'}, 3, 0x672C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\xbb'}, 3, 0x7FFB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xa1'}, 3, 0x51E1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\x86'}, 3, 0x76C6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x91', '\xa9'}, 3, 0x6469}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa3', '\xa8'}, 3, 0x78E8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\x94'}, 3, 0x9B54}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\xbb'}, 3, 0x9EBB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\x8b'}, 3, 0x57CB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\xb9'}, 3, 0x59B9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xa7'}, 3, 0x6627}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\x9a'}, 3, 0x679A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\x8e'}, 3, 0x6BCE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\xa9'}, 3, 0x54E9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\x99'}, 3, 0x69D9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\x95'}, 3, 0x5E55}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\x9c'}, 3, 0x819C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\x95'}, 3, 0x6795}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\xaa'}, 3, 0x9BAA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\xbe'}, 3, 0x67FE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb1', '\x92'}, 3, 0x9C52}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x9d'}, 3, 0x685D}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\xa6'}, 3, 0x4EA6}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\xa3'}, 3, 0x4FE3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x88'}, 3, 0x53C8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\xb9'}, 3, 0x62B9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\xab'}, 3, 0x672B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\xab'}, 3, 0x6CAB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\x84'}, 3, 0x8FC4}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\xad'}, 3, 0x4FAD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\xad'}, 3, 0x7E6D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\xbf'}, 3, 0x9EBF}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x87'}, 3, 0x4E07}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xa2'}, 3, 0x6162}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\x80'}, 3, 0x6E80}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\xab'}, 3, 0x6F2B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x94', '\x93'}, 3, 0x8513}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\xb3'}, 3, 0x5473}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\xaa'}, 3, 0x672A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\x85'}, 3, 0x9B45}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xb3'}, 3, 0x5DF3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x95'}, 3, 0x7B95}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xac'}, 3, 0x5CAC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x86'}, 3, 0x5BC6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\x9c'}, 3, 0x871C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\x8a'}, 3, 0x6E4A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\x91'}, 3, 0x84D1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\x94'}, 3, 0x7A14}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\x88'}, 3, 0x8108}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\x99'}, 3, 0x5999}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\x8d'}, 3, 0x7C8D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb0', '\x91'}, 3, 0x6C11}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\xa0'}, 3, 0x7720}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x99'}, 3, 0x52D9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\xa2'}, 3, 0x5922}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x84', '\xa1'}, 3, 0x7121}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\x9f'}, 3, 0x725F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9f', '\x9b'}, 3, 0x77DB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\xa7'}, 3, 0x9727}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\xa1'}, 3, 0x9D61}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\x8b'}, 3, 0x690B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa9', '\xbf'}, 3, 0x5A7F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa8', '\x98'}, 3, 0x5A18}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xa5'}, 3, 0x51A5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x8d'}, 3, 0x540D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\xbd'}, 3, 0x547D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x8e'}, 3, 0x660E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\x9f'}, 3, 0x76DF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\xb7'}, 3, 0x8FF7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\x98'}, 3, 0x9298}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb3', '\xb4'}, 3, 0x9CF4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\xaa'}, 3, 0x59EA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\x9d'}, 3, 0x725D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\x85'}, 3, 0x6EC5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x8d'}, 3, 0x514D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x89'}, 3, 0x68C9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xbf'}, 3, 0x7DBF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\xac'}, 3, 0x7DEC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\xa2'}, 3, 0x9762}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\xba'}, 3, 0x9EBA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x91', '\xb8'}, 3, 0x6478}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\xa1'}, 3, 0x6A21}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\x82'}, 3, 0x8302}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\x84'}, 3, 0x5984}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\x9f'}, 3, 0x5B5F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\x9b'}, 3, 0x6BDB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\x9b'}, 3, 0x731B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\xb2'}, 3, 0x76F2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xb2'}, 3, 0x7DB2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\x97'}, 3, 0x8017}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\x99'}, 3, 0x8499}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\xb2'}, 3, 0x5132}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\xa8'}, 3, 0x6728}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\x99'}, 3, 0x9ED9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\xae'}, 3, 0x76EE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xa2'}, 3, 0x6762}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\xbf'}, 3, 0x52FF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\x85'}, 3, 0x9905}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\xa4'}, 3, 0x5C24}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\xbb'}, 3, 0x623B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\xbe'}, 3, 0x7C7E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xb0'}, 3, 0x8CB0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x95', '\x8f'}, 3, 0x554F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\xb6'}, 3, 0x60B6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x8b'}, 3, 0x7D0B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\x80'}, 3, 0x9580}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x81'}, 3, 0x5301}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\x9f'}, 3, 0x4E5F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xb6'}, 3, 0x51B6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\x9c'}, 3, 0x591C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\xba'}, 3, 0x723A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\xb6'}, 3, 0x8036}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x8e'}, 3, 0x91CE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\xa5'}, 3, 0x5F25}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9f', '\xa2'}, 3, 0x77E2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\x84'}, 3, 0x5384}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xb9'}, 3, 0x5F79}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x84'}, 3, 0x7D04}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\xac'}, 3, 0x85AC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\xb3'}, 3, 0x8A33}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\x8d'}, 3, 0x8E8D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x96'}, 3, 0x9756}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\xb3'}, 3, 0x67F3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\xae'}, 3, 0x85AE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\x93'}, 3, 0x9453}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\x89'}, 3, 0x6109}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\x88'}, 3, 0x6108}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\xb9'}, 3, 0x6CB9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\x92'}, 3, 0x7652}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\xad'}, 3, 0x8AED}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\xb8'}, 3, 0x8F38}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x94', '\xaf'}, 3, 0x552F}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x91'}, 3, 0x4F51}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\xaa'}, 3, 0x512A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x87'}, 3, 0x52C7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x8b'}, 3, 0x53CB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\xa5'}, 3, 0x5BA5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xbd'}, 3, 0x5E7D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\xa0'}, 3, 0x60A0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\x82'}, 3, 0x6182}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\x96'}, 3, 0x63D6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x89'}, 3, 0x6709}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\x9a'}, 3, 0x67DA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\xa7'}, 3, 0x6E67}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\x8c'}, 3, 0x6D8C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\xb6'}, 3, 0x7336}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\xb7'}, 3, 0x7337}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xb1'}, 3, 0x7531}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\x90'}, 3, 0x7950}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\x95'}, 3, 0x88D5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\x98'}, 3, 0x8A98}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x8a'}, 3, 0x904A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\x91'}, 3, 0x9091}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x83', '\xb5'}, 3, 0x90F5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x84'}, 3, 0x96C4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9e', '\x8d'}, 3, 0x878D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\x95'}, 3, 0x5915}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x88'}, 3, 0x4E88}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x99'}, 3, 0x4F59}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x8e'}, 3, 0x4E0E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\x89'}, 3, 0x8A89}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\xbf'}, 3, 0x8F3F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\x90'}, 3, 0x9810}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\xad'}, 3, 0x50AD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xbc'}, 3, 0x5E7C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\x96'}, 3, 0x5996}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\xb9'}, 3, 0x5BB9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\xb8'}, 3, 0x5EB8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\x9a'}, 3, 0x63DA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\xba'}, 3, 0x63FA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\x81'}, 3, 0x64C1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\x9c'}, 3, 0x66DC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\x8a'}, 3, 0x694A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\x98'}, 3, 0x69D8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\x8b'}, 3, 0x6D0B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\xb6'}, 3, 0x6EB6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x86', '\x94'}, 3, 0x7194}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xa8'}, 3, 0x7528}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\xaf'}, 3, 0x7AAF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\x8a'}, 3, 0x7F8A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\x80'}, 3, 0x8000}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\x89'}, 3, 0x8449}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\x89'}, 3, 0x84C9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\x81'}, 3, 0x8981}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\xa1'}, 3, 0x8B21}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb8', '\x8a'}, 3, 0x8E0A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xa5'}, 3, 0x9065}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\xbd'}, 3, 0x967D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\x8a'}, 3, 0x990A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xbe'}, 3, 0x617E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x91'}, 3, 0x6291}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\xb2'}, 3, 0x6B32}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\x83'}, 3, 0x6C83}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\xb4'}, 3, 0x6D74}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\x8c'}, 3, 0x7FCC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\xbc'}, 3, 0x7FFC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\x80'}, 3, 0x6DC0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\x85'}, 3, 0x7F85}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9e', '\xba'}, 3, 0x87BA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\xb8'}, 3, 0x88F8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xa5'}, 3, 0x6765}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\xb1'}, 3, 0x83B1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\xbc'}, 3, 0x983C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\xb7'}, 3, 0x96F7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\x9b'}, 3, 0x6D1B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\xa1'}, 3, 0x7D61}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\xbd'}, 3, 0x843D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\xaa'}, 3, 0x916A}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\xb1'}, 3, 0x4E71}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xb5'}, 3, 0x5375}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb5', '\x90'}, 3, 0x5D50}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\x84'}, 3, 0x6B04}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\xab'}, 3, 0x6FEB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\x8d'}, 3, 0x85CD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x98', '\xad'}, 3, 0x862D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\xa7'}, 3, 0x89A7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\xa9'}, 3, 0x5229}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x8f'}, 3, 0x540F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\xa5'}, 3, 0x5C65}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\x8e'}, 3, 0x674E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\xa8'}, 3, 0x68A8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\x86'}, 3, 0x7406}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x92', '\x83'}, 3, 0x7483}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\xa2'}, 3, 0x75E2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\x8f'}, 3, 0x88CF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\xa1'}, 3, 0x88E1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x8c'}, 3, 0x91CC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\xa2'}, 3, 0x96E2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\xb8'}, 3, 0x9678}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x8b'}, 3, 0x5F8B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8e', '\x87'}, 3, 0x7387}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x8b'}, 3, 0x7ACB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\x8e'}, 3, 0x844E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\xa0'}, 3, 0x63A0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xa5'}, 3, 0x7565}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\x89'}, 3, 0x5289}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\x81'}, 3, 0x6D41}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\x9c'}, 3, 0x6E9C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\x89'}, 3, 0x7409}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\x99'}, 3, 0x7559}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa1', '\xab'}, 3, 0x786B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\x92'}, 3, 0x7C92}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\x86'}, 3, 0x9686}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x9c'}, 3, 0x7ADC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbe', '\x8d'}, 3, 0x9F8D}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\xb6'}, 3, 0x4FB6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xae'}, 3, 0x616E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\x85'}, 3, 0x65C5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x99', '\x9c'}, 3, 0x865C}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x86'}, 3, 0x4E86}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\xae'}, 3, 0x4EAE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\x9a'}, 3, 0x50DA}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\xa1'}, 3, 0x4E21}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\x8c'}, 3, 0x51CC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xae'}, 3, 0x5BEE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\x99'}, 3, 0x6599}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\x81'}, 3, 0x6881}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\xbc'}, 3, 0x6DBC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\x9f'}, 3, 0x731F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\x82'}, 3, 0x7642}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9e', '\xad'}, 3, 0x77AD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\x9c'}, 3, 0x7A1C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\xa7'}, 3, 0x7CE7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\xaf'}, 3, 0x826F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\x92'}, 3, 0x8AD2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xbc'}, 3, 0x907C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x8f'}, 3, 0x91CF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\xb5'}, 3, 0x9675}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\x98'}, 3, 0x9818}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\x9b'}, 3, 0x529B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\x91'}, 3, 0x7DD1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\xab'}, 3, 0x502B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\x98'}, 3, 0x5398}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\x97'}, 3, 0x6797}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\x8b'}, 3, 0x6DCB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\x90'}, 3, 0x71D0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xb3'}, 3, 0x7433}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\xa8'}, 3, 0x81E8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\xaa'}, 3, 0x8F2A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xa3'}, 3, 0x96A3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb1', '\x97'}, 3, 0x9C57}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\x9f'}, 3, 0x9E9F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\xa0'}, 3, 0x7460}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\x81'}, 3, 0x5841}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\x99'}, 3, 0x6D99}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\xaf'}, 3, 0x7D2F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\x9e'}, 3, 0x985E}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\xa4'}, 3, 0x4EE4}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\xb6'}, 3, 0x4F36}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x8b'}, 3, 0x4F8B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xb7'}, 3, 0x51B7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xb1'}, 3, 0x52B1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\xba'}, 3, 0x5DBA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\x9c'}, 3, 0x601C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8e', '\xb2'}, 3, 0x73B2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa4', '\xbc'}, 3, 0x793C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\x93'}, 3, 0x82D3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\xb4'}, 3, 0x9234}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xb7'}, 3, 0x96B7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\xb6'}, 3, 0x96F6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\x8a'}, 3, 0x970A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\x97'}, 3, 0x9E97}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\xa2'}, 3, 0x9F62}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\xa6'}, 3, 0x66A6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\xb4'}, 3, 0x6B74}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\x97'}, 3, 0x5217}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xa3'}, 3, 0x52A3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x83', '\x88'}, 3, 0x70C8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\x82'}, 3, 0x88C2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\x89'}, 3, 0x5EC9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\x8b'}, 3, 0x604B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\x90'}, 3, 0x6190}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\xa3'}, 3, 0x6F23}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\x89'}, 3, 0x7149}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\xbe'}, 3, 0x7C3E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\xb4'}, 3, 0x7DF4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\xaf'}, 3, 0x806F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\xae'}, 3, 0x84EE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\xa3'}, 3, 0x9023}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xac'}, 3, 0x932C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\x82'}, 3, 0x5442}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\xaf'}, 3, 0x9B6F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\x93'}, 3, 0x6AD3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\x89'}, 3, 0x7089}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x82'}, 3, 0x8CC2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\xaf'}, 3, 0x8DEF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\xb2'}, 3, 0x9732}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xb4'}, 3, 0x52B4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa9', '\x81'}, 3, 0x5A41}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\x8a'}, 3, 0x5ECA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x84'}, 3, 0x5F04}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x97'}, 3, 0x6717}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xbc'}, 3, 0x697C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\x94'}, 3, 0x6994}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\xaa'}, 3, 0x6D6A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\x8f'}, 3, 0x6F0F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\xa2'}, 3, 0x7262}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\xbc'}, 3, 0x72FC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\xad'}, 3, 0x7BED}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\x81'}, 3, 0x8001}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\xbe'}, 3, 0x807E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\x8b'}, 3, 0x874B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x83', '\x8e'}, 3, 0x90CE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xad'}, 3, 0x516D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\x93'}, 3, 0x9E93}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\x84'}, 3, 0x7984}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\x8b'}, 3, 0x808B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xb2'}, 3, 0x9332}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\x96'}, 3, 0x8AD6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\xad'}, 3, 0x502D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\x8c'}, 3, 0x548C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\xb1'}, 3, 0x8A71}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\xaa'}, 3, 0x6B6A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x84'}, 3, 0x8CC4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\x87'}, 3, 0x8107}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\x91'}, 3, 0x60D1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\xa0'}, 3, 0x67A0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb7', '\xb2'}, 3, 0x9DF2}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x99'}, 3, 0x4E99}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x98'}, 3, 0x4E98}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\x90'}, 3, 0x9C10}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\xab'}, 3, 0x8A6B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\x81'}, 3, 0x85C1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\xa8'}, 3, 0x8568}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\x80'}, 3, 0x6900}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\xbe'}, 3, 0x6E7E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\x97'}, 3, 0x7897}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\x95'}, 3, 0x8155}, /* (<CJK Ideograph>) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe5', '\xbc', '\x8c'}, 3, 0x5F0C}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x90'}, 3, 0x4E10}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x95'}, 3, 0x4E15}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\xaa'}, 3, 0x4E2A}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\xb1'}, 3, 0x4E31}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\xb6'}, 3, 0x4E36}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\xbc'}, 3, 0x4E3C}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\xbf'}, 3, 0x4E3F}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\x82'}, 3, 0x4E42}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\x96'}, 3, 0x4E56}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\x98'}, 3, 0x4E58}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x82'}, 3, 0x4E82}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x85'}, 3, 0x4E85}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\xab'}, 3, 0x8C6B}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x8a'}, 3, 0x4E8A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x92'}, 3, 0x8212}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x8d'}, 3, 0x5F0D}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x8e'}, 3, 0x4E8E}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x9e'}, 3, 0x4E9E}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\x9f'}, 3, 0x4E9F}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\xa0'}, 3, 0x4EA0}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\xa2'}, 3, 0x4EA2}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\xb0'}, 3, 0x4EB0}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\xb3'}, 3, 0x4EB3}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xba', '\xb6'}, 3, 0x4EB6}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x8e'}, 3, 0x4ECE}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x8d'}, 3, 0x4ECD}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x84'}, 3, 0x4EC4}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x86'}, 3, 0x4EC6}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x82'}, 3, 0x4EC2}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x97'}, 3, 0x4ED7}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x9e'}, 3, 0x4EDE}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\xad'}, 3, 0x4EED}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\x9f'}, 3, 0x4EDF}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\xb7'}, 3, 0x4EF7}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\x89'}, 3, 0x4F09}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x9a'}, 3, 0x4F5A}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\xb0'}, 3, 0x4F30}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x9b'}, 3, 0x4F5B}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x9d'}, 3, 0x4F5D}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x97'}, 3, 0x4F57}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x87'}, 3, 0x4F47}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\xb6'}, 3, 0x4F76}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x88'}, 3, 0x4F88}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x8f'}, 3, 0x4F8F}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x98'}, 3, 0x4F98}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\xbb'}, 3, 0x4F7B}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\xa9'}, 3, 0x4F69}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\xb0'}, 3, 0x4F70}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x91'}, 3, 0x4F91}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\xaf'}, 3, 0x4F6F}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x86'}, 3, 0x4F86}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x96'}, 3, 0x4F96}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\x98'}, 3, 0x5118}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x94'}, 3, 0x4FD4}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x9f'}, 3, 0x4FDF}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x8e'}, 3, 0x4FCE}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x98'}, 3, 0x4FD8}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x9b'}, 3, 0x4FDB}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x91'}, 3, 0x4FD1}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x9a'}, 3, 0x4FDA}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x90'}, 3, 0x4FD0}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\xa4'}, 3, 0x4FE4}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\xa5'}, 3, 0x4FE5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\x9a'}, 3, 0x501A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\xa8'}, 3, 0x5028}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\x94'}, 3, 0x5014}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\xaa'}, 3, 0x502A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\xa5'}, 3, 0x5025}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\x85'}, 3, 0x5005}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\x9c'}, 3, 0x4F1C}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\xb6'}, 3, 0x4FF6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\xa1'}, 3, 0x5021}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\xa9'}, 3, 0x5029}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\xac'}, 3, 0x502C}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\xbe'}, 3, 0x4FFE}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\xaf'}, 3, 0x4FEF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\x91'}, 3, 0x5011}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\x86'}, 3, 0x5006}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x83'}, 3, 0x5043}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x87'}, 3, 0x5047}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x83'}, 3, 0x6703}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x95'}, 3, 0x5055}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x90'}, 3, 0x5050}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x88'}, 3, 0x5048}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x9a'}, 3, 0x505A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x96'}, 3, 0x5056}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\xac'}, 3, 0x506C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\xb8'}, 3, 0x5078}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\x80'}, 3, 0x5080}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\x9a'}, 3, 0x509A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\x85'}, 3, 0x5085}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\xb4'}, 3, 0x50B4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\xb2'}, 3, 0x50B2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\x89'}, 3, 0x50C9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\x8a'}, 3, 0x50CA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\xb3'}, 3, 0x50B3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\x82'}, 3, 0x50C2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\x96'}, 3, 0x50D6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\x9e'}, 3, 0x50DE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\xa5'}, 3, 0x50E5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\xad'}, 3, 0x50ED}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\xa3'}, 3, 0x50E3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\xae'}, 3, 0x50EE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\xb9'}, 3, 0x50F9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\xb5'}, 3, 0x50F5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\x89'}, 3, 0x5109}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\x81'}, 3, 0x5101}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\x82'}, 3, 0x5102}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\x96'}, 3, 0x5116}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\x95'}, 3, 0x5115}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\x94'}, 3, 0x5114}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\x9a'}, 3, 0x511A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\xa1'}, 3, 0x5121}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\xba'}, 3, 0x513A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\xb7'}, 3, 0x5137}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\xbc'}, 3, 0x513C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\xbb'}, 3, 0x513B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x84', '\xbf'}, 3, 0x513F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x80'}, 3, 0x5140}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x92'}, 3, 0x5152}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x8c'}, 3, 0x514C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x94'}, 3, 0x5154}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xa2'}, 3, 0x5162}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xb8'}, 3, 0x7AF8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xa9'}, 3, 0x5169}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xaa'}, 3, 0x516A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xae'}, 3, 0x516E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x80'}, 3, 0x5180}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x82'}, 3, 0x5182}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\x98'}, 3, 0x56D8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x8c'}, 3, 0x518C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x89'}, 3, 0x5189}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x8f'}, 3, 0x518F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x91'}, 3, 0x5191}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x93'}, 3, 0x5193}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x95'}, 3, 0x5195}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x96'}, 3, 0x5196}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xa4'}, 3, 0x51A4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xa6'}, 3, 0x51A6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xa2'}, 3, 0x51A2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xa9'}, 3, 0x51A9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xaa'}, 3, 0x51AA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xab'}, 3, 0x51AB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xb3'}, 3, 0x51B3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xb1'}, 3, 0x51B1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xb2'}, 3, 0x51B2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xb0'}, 3, 0x51B0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xb5'}, 3, 0x51B5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xbd'}, 3, 0x51BD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\x85'}, 3, 0x51C5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\x89'}, 3, 0x51C9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\x9b'}, 3, 0x51DB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xa0'}, 3, 0x51E0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x99', '\x95'}, 3, 0x8655}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xa9'}, 3, 0x51E9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xad'}, 3, 0x51ED}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xb0'}, 3, 0x51F0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xb5'}, 3, 0x51F5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xbe'}, 3, 0x51FE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\x84'}, 3, 0x5204}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\x8b'}, 3, 0x520B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\x94'}, 3, 0x5214}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\x8e'}, 3, 0x520E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\xa7'}, 3, 0x5227}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\xaa'}, 3, 0x522A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\xae'}, 3, 0x522E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\xb3'}, 3, 0x5233}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\xb9'}, 3, 0x5239}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\x8f'}, 3, 0x524F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\x84'}, 3, 0x5244}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\x8b'}, 3, 0x524B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\x8c'}, 3, 0x524C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\x9e'}, 3, 0x525E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\x94'}, 3, 0x5254}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\xaa'}, 3, 0x526A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\xb4'}, 3, 0x5274}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\xa9'}, 3, 0x5269}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\xb3'}, 3, 0x5273}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\xbf'}, 3, 0x527F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\xbd'}, 3, 0x527D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\x8d'}, 3, 0x528D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\x94'}, 3, 0x5294}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\x92'}, 3, 0x5292}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x89', '\xb1'}, 3, 0x5271}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\x88'}, 3, 0x5288}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\x91'}, 3, 0x5291}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\xa8'}, 3, 0x8FA8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\xa7'}, 3, 0x8FA7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xac'}, 3, 0x52AC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xad'}, 3, 0x52AD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xbc'}, 3, 0x52BC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xb5'}, 3, 0x52B5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x81'}, 3, 0x52C1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x8d'}, 3, 0x52CD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x97'}, 3, 0x52D7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x9e'}, 3, 0x52DE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\xa3'}, 3, 0x52E3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\xa6'}, 3, 0x52E6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\xad'}, 3, 0x98ED}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\xa0'}, 3, 0x52E0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\xb3'}, 3, 0x52F3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\xb5'}, 3, 0x52F5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\xb8'}, 3, 0x52F8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\xb9'}, 3, 0x52F9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x86'}, 3, 0x5306}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x88'}, 3, 0x5308}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xb8'}, 3, 0x7538}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x8d'}, 3, 0x530D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x90'}, 3, 0x5310}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x8f'}, 3, 0x530F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x95'}, 3, 0x5315}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x9a'}, 3, 0x531A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\xa3'}, 3, 0x5323}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\xaf'}, 3, 0x532F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\xb1'}, 3, 0x5331}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\xb3'}, 3, 0x5333}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\xb8'}, 3, 0x5338}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x80'}, 3, 0x5340}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x86'}, 3, 0x5346}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x85'}, 3, 0x5345}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\x97'}, 3, 0x4E17}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x89'}, 3, 0x5349}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x8d'}, 3, 0x534D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\x96'}, 3, 0x51D6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\x9e'}, 3, 0x535E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xa9'}, 3, 0x5369}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xae'}, 3, 0x536E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\x98'}, 3, 0x5918}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xbb'}, 3, 0x537B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xb7'}, 3, 0x5377}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\x82'}, 3, 0x5382}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\x96'}, 3, 0x5396}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\xa0'}, 3, 0x53A0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\xa6'}, 3, 0x53A6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\xa5'}, 3, 0x53A5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\xae'}, 3, 0x53AE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\xb0'}, 3, 0x53B0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\xb6'}, 3, 0x53B6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x83'}, 3, 0x53C3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\x92'}, 3, 0x7C12}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x99'}, 3, 0x96D9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x9f'}, 3, 0x53DF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xbc'}, 3, 0x66FC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\xae'}, 3, 0x71EE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xae'}, 3, 0x53EE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xa8'}, 3, 0x53E8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xad'}, 3, 0x53ED}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\xba'}, 3, 0x53FA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x81'}, 3, 0x5401}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\xbd'}, 3, 0x543D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\x80'}, 3, 0x5440}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\xac'}, 3, 0x542C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\xad'}, 3, 0x542D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\xbc'}, 3, 0x543C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\xae'}, 3, 0x542E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\xb6'}, 3, 0x5436}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\xa9'}, 3, 0x5429}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x90', '\x9d'}, 3, 0x541D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\x8e'}, 3, 0x544E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\x8f'}, 3, 0x548F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\xb5'}, 3, 0x5475}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\x8e'}, 3, 0x548E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\x9f'}, 3, 0x545F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\xb1'}, 3, 0x5471}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\xb7'}, 3, 0x5477}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\xb0'}, 3, 0x5470}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\x92'}, 3, 0x5492}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\xbb'}, 3, 0x547B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\x80'}, 3, 0x5480}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x91', '\xb6'}, 3, 0x5476}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\x84'}, 3, 0x5484}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\x90'}, 3, 0x5490}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\x86'}, 3, 0x5486}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\x87'}, 3, 0x54C7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\xa2'}, 3, 0x54A2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\xb8'}, 3, 0x54B8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\xa5'}, 3, 0x54A5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\xac'}, 3, 0x54AC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\x84'}, 3, 0x54C4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\x88'}, 3, 0x54C8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\xa8'}, 3, 0x54A8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\xab'}, 3, 0x54AB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\x82'}, 3, 0x54C2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\xa4'}, 3, 0x54A4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\xbe'}, 3, 0x54BE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\xbc'}, 3, 0x54BC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\x98'}, 3, 0x54D8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\xa5'}, 3, 0x54E5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\xa6'}, 3, 0x54E6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x94', '\x8f'}, 3, 0x550F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x94', '\x94'}, 3, 0x5514}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\xbd'}, 3, 0x54FD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\xae'}, 3, 0x54EE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\xad'}, 3, 0x54ED}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\xba'}, 3, 0x54FA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\xa2'}, 3, 0x54E2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x94', '\xb9'}, 3, 0x5539}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x95', '\x80'}, 3, 0x5540}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x95', '\xa3'}, 3, 0x5563}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x95', '\x8c'}, 3, 0x554C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x94', '\xae'}, 3, 0x552E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x95', '\x9c'}, 3, 0x555C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x95', '\x85'}, 3, 0x5545}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x95', '\x96'}, 3, 0x5556}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x95', '\x97'}, 3, 0x5557}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x94', '\xb8'}, 3, 0x5538}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x94', '\xb3'}, 3, 0x5533}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x95', '\x9d'}, 3, 0x555D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\x99'}, 3, 0x5599}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\x80'}, 3, 0x5580}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\xaf'}, 3, 0x54AF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\x8a'}, 3, 0x558A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\x9f'}, 3, 0x559F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x95', '\xbb'}, 3, 0x557B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x95', '\xbe'}, 3, 0x557E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\x98'}, 3, 0x5598}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\x9e'}, 3, 0x559E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\xae'}, 3, 0x55AE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x95', '\xbc'}, 3, 0x557C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\x83'}, 3, 0x5583}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\xa9'}, 3, 0x55A9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\x87'}, 3, 0x5587}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\xa8'}, 3, 0x55A8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x97', '\x9a'}, 3, 0x55DA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x97', '\x85'}, 3, 0x55C5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x97', '\x9f'}, 3, 0x55DF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x97', '\x84'}, 3, 0x55C4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x97', '\x9c'}, 3, 0x55DC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x97', '\xa4'}, 3, 0x55E4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x97', '\x94'}, 3, 0x55D4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x98', '\x94'}, 3, 0x5614}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x97', '\xb7'}, 3, 0x55F7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x98', '\x96'}, 3, 0x5616}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x97', '\xbe'}, 3, 0x55FE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x97', '\xbd'}, 3, 0x55FD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x98', '\x9b'}, 3, 0x561B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x97', '\xb9'}, 3, 0x55F9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x99', '\x8e'}, 3, 0x564E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x99', '\x90'}, 3, 0x5650}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\x9f'}, 3, 0x71DF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x98', '\xb4'}, 3, 0x5634}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x98', '\xb6'}, 3, 0x5636}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x98', '\xb2'}, 3, 0x5632}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x98', '\xb8'}, 3, 0x5638}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x99', '\xab'}, 3, 0x566B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x99', '\xa4'}, 3, 0x5664}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x98', '\xaf'}, 3, 0x562F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x99', '\xac'}, 3, 0x566C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x99', '\xaa'}, 3, 0x566A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9a', '\x86'}, 3, 0x5686}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9a', '\x80'}, 3, 0x5680}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9a', '\x8a'}, 3, 0x568A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9a', '\xa0'}, 3, 0x56A0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9a', '\x94'}, 3, 0x5694}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9a', '\x8f'}, 3, 0x568F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9a', '\xa5'}, 3, 0x56A5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9a', '\xae'}, 3, 0x56AE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9a', '\xb6'}, 3, 0x56B6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9a', '\xb4'}, 3, 0x56B4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\x82'}, 3, 0x56C2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9a', '\xbc'}, 3, 0x56BC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\x81'}, 3, 0x56C1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\x83'}, 3, 0x56C3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\x80'}, 3, 0x56C0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\x88'}, 3, 0x56C8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\x8e'}, 3, 0x56CE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\x91'}, 3, 0x56D1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\x93'}, 3, 0x56D3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\x97'}, 3, 0x56D7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\xae'}, 3, 0x56EE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\xb9'}, 3, 0x56F9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\x80'}, 3, 0x5700}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9b', '\xbf'}, 3, 0x56FF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\x84'}, 3, 0x5704}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\x89'}, 3, 0x5709}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\x88'}, 3, 0x5708}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\x8b'}, 3, 0x570B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\x8d'}, 3, 0x570D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\x93'}, 3, 0x5713}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\x98'}, 3, 0x5718}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\x96'}, 3, 0x5716}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x97', '\x87'}, 3, 0x55C7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\x9c'}, 3, 0x571C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\xa6'}, 3, 0x5726}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\xb7'}, 3, 0x5737}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\xb8'}, 3, 0x5738}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\x8e'}, 3, 0x574E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9c', '\xbb'}, 3, 0x573B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\x80'}, 3, 0x5740}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\x8f'}, 3, 0x574F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\xa9'}, 3, 0x5769}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\x80'}, 3, 0x57C0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9e', '\x88'}, 3, 0x5788}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\xa1'}, 3, 0x5761}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\xbf'}, 3, 0x577F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9e', '\x89'}, 3, 0x5789}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9e', '\x93'}, 3, 0x5793}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9e', '\xa0'}, 3, 0x57A0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9e', '\xb3'}, 3, 0x57B3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9e', '\xa4'}, 3, 0x57A4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9e', '\xaa'}, 3, 0x57AA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9e', '\xb0'}, 3, 0x57B0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\x83'}, 3, 0x57C3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\x86'}, 3, 0x57C6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\x94'}, 3, 0x57D4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\x92'}, 3, 0x57D2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\x93'}, 3, 0x57D3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\x8a'}, 3, 0x580A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\x96'}, 3, 0x57D6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\xa3'}, 3, 0x57E3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\x8b'}, 3, 0x580B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\x99'}, 3, 0x5819}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\x9d'}, 3, 0x581D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\xb2'}, 3, 0x5872}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\xa1'}, 3, 0x5821}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\xa2'}, 3, 0x5862}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\x8b'}, 3, 0x584B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\xb0'}, 3, 0x5870}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\x80'}, 3, 0x6BC0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\x92'}, 3, 0x5852}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\xbd'}, 3, 0x583D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa1', '\xb9'}, 3, 0x5879}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\x85'}, 3, 0x5885}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\xb9'}, 3, 0x58B9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\x9f'}, 3, 0x589F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\xab'}, 3, 0x58AB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\xba'}, 3, 0x58BA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\x9e'}, 3, 0x58DE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\xbb'}, 3, 0x58BB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\xb8'}, 3, 0x58B8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\xae'}, 3, 0x58AE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\x85'}, 3, 0x58C5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\x93'}, 3, 0x58D3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\x91'}, 3, 0x58D1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\x97'}, 3, 0x58D7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\x99'}, 3, 0x58D9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\x98'}, 3, 0x58D8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\xa5'}, 3, 0x58E5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\x9c'}, 3, 0x58DC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\xa4'}, 3, 0x58E4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\x9f'}, 3, 0x58DF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\xaf'}, 3, 0x58EF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\xba'}, 3, 0x58FA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\xb9'}, 3, 0x58F9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\xbb'}, 3, 0x58FB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\xbc'}, 3, 0x58FC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa3', '\xbd'}, 3, 0x58FD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\x82'}, 3, 0x5902}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\x8a'}, 3, 0x590A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\x90'}, 3, 0x5910}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\x9b'}, 3, 0x591B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\xa6'}, 3, 0x68A6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\xa5'}, 3, 0x5925}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\xac'}, 3, 0x592C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\xad'}, 3, 0x592D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\xb2'}, 3, 0x5932}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\xb8'}, 3, 0x5938}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\xbe'}, 3, 0x593E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x92'}, 3, 0x7AD2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x95'}, 3, 0x5955}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x90'}, 3, 0x5950}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x8e'}, 3, 0x594E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x9a'}, 3, 0x595A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x98'}, 3, 0x5958}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\xa2'}, 3, 0x5962}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\xa0'}, 3, 0x5960}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\xa7'}, 3, 0x5967}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\xac'}, 3, 0x596C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\xa9'}, 3, 0x5969}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\xb8'}, 3, 0x5978}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\x81'}, 3, 0x5981}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\x9d'}, 3, 0x599D}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x9e'}, 3, 0x4F5E}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\xab'}, 3, 0x4FAB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\xa3'}, 3, 0x59A3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\xb2'}, 3, 0x59B2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\x86'}, 3, 0x59C6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\xa8'}, 3, 0x59E8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\x9c'}, 3, 0x59DC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\x8d'}, 3, 0x598D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\x99'}, 3, 0x59D9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa7', '\x9a'}, 3, 0x59DA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa8', '\xa5'}, 3, 0x5A25}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa8', '\x9f'}, 3, 0x5A1F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa8', '\x91'}, 3, 0x5A11}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa8', '\x9c'}, 3, 0x5A1C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa8', '\x89'}, 3, 0x5A09}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa8', '\x9a'}, 3, 0x5A1A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa9', '\x80'}, 3, 0x5A40}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa9', '\xac'}, 3, 0x5A6C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa9', '\x89'}, 3, 0x5A49}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa8', '\xb5'}, 3, 0x5A35}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa8', '\xb6'}, 3, 0x5A36}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa9', '\xa2'}, 3, 0x5A62}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa9', '\xaa'}, 3, 0x5A6A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaa', '\x9a'}, 3, 0x5A9A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaa', '\xbc'}, 3, 0x5ABC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaa', '\xbe'}, 3, 0x5ABE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xab', '\x8b'}, 3, 0x5ACB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xab', '\x82'}, 3, 0x5AC2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaa', '\xbd'}, 3, 0x5ABD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xab', '\xa3'}, 3, 0x5AE3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xab', '\x97'}, 3, 0x5AD7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xab', '\xa6'}, 3, 0x5AE6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xab', '\xa9'}, 3, 0x5AE9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xab', '\x96'}, 3, 0x5AD6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xab', '\xba'}, 3, 0x5AFA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xab', '\xbb'}, 3, 0x5AFB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xac', '\x8c'}, 3, 0x5B0C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xac', '\x8b'}, 3, 0x5B0B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xac', '\x96'}, 3, 0x5B16}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xac', '\xb2'}, 3, 0x5B32}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xab', '\x90'}, 3, 0x5AD0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xac', '\xaa'}, 3, 0x5B2A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xac', '\xb6'}, 3, 0x5B36}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xac', '\xbe'}, 3, 0x5B3E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\x83'}, 3, 0x5B43}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\x85'}, 3, 0x5B45}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\x80'}, 3, 0x5B40}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\x91'}, 3, 0x5B51}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\x95'}, 3, 0x5B55}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\x9a'}, 3, 0x5B5A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\x9b'}, 3, 0x5B5B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\xa5'}, 3, 0x5B65}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\xa9'}, 3, 0x5B69}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\xb0'}, 3, 0x5B70}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\xb3'}, 3, 0x5B73}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\xb5'}, 3, 0x5B75}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\xb8'}, 3, 0x5B78}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\x88'}, 3, 0x6588}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\xba'}, 3, 0x5B7A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x80'}, 3, 0x5B80}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\x83'}, 3, 0x5B83}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\xa6'}, 3, 0x5BA6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xae', '\xb8'}, 3, 0x5BB8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x83'}, 3, 0x5BC3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x87'}, 3, 0x5BC7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x89'}, 3, 0x5BC9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x94'}, 3, 0x5BD4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x90'}, 3, 0x5BD0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xa4'}, 3, 0x5BE4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xa6'}, 3, 0x5BE6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xa2'}, 3, 0x5BE2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x9e'}, 3, 0x5BDE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xa5'}, 3, 0x5BE5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xab'}, 3, 0x5BEB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xb0'}, 3, 0x5BF0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xb6'}, 3, 0x5BF6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xb3'}, 3, 0x5BF3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x85'}, 3, 0x5C05}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x87'}, 3, 0x5C07}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x88'}, 3, 0x5C08}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x8d'}, 3, 0x5C0D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x93'}, 3, 0x5C13}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\xa0'}, 3, 0x5C20}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\xa2'}, 3, 0x5C22}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\xa8'}, 3, 0x5C28}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\xb8'}, 3, 0x5C38}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\xb9'}, 3, 0x5C39}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\x81'}, 3, 0x5C41}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\x86'}, 3, 0x5C46}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\x8e'}, 3, 0x5C4E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\x93'}, 3, 0x5C53}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\x90'}, 3, 0x5C50}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\x8f'}, 3, 0x5C4F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\xb1'}, 3, 0x5B71}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\xac'}, 3, 0x5C6C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\xae'}, 3, 0x5C6E}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\xa2'}, 3, 0x4E62}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\xb6'}, 3, 0x5C76}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb1', '\xb9'}, 3, 0x5C79}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\x8c'}, 3, 0x5C8C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\x91'}, 3, 0x5C91}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\x94'}, 3, 0x5C94}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\x9b'}, 3, 0x599B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xab'}, 3, 0x5CAB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xbb'}, 3, 0x5CBB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xb6'}, 3, 0x5CB6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xbc'}, 3, 0x5CBC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xb7'}, 3, 0x5CB7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\x85'}, 3, 0x5CC5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xbe'}, 3, 0x5CBE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\x87'}, 3, 0x5CC7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\x99'}, 3, 0x5CD9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\xa9'}, 3, 0x5CE9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\xbd'}, 3, 0x5CFD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\xba'}, 3, 0x5CFA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\xad'}, 3, 0x5CED}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\x8c'}, 3, 0x5D8C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\xaa'}, 3, 0x5CEA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\x8b'}, 3, 0x5D0B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\x95'}, 3, 0x5D15}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\x97'}, 3, 0x5D17}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb5', '\x9c'}, 3, 0x5D5C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\x9f'}, 3, 0x5D1F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\x9b'}, 3, 0x5D1B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\x91'}, 3, 0x5D11}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\x94'}, 3, 0x5D14}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\xa2'}, 3, 0x5D22}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\x9a'}, 3, 0x5D1A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\x99'}, 3, 0x5D19}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\x98'}, 3, 0x5D18}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb5', '\x8c'}, 3, 0x5D4C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb5', '\x92'}, 3, 0x5D52}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb5', '\x8e'}, 3, 0x5D4E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb5', '\x8b'}, 3, 0x5D4B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb5', '\xac'}, 3, 0x5D6C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb5', '\xb3'}, 3, 0x5D73}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb5', '\xb6'}, 3, 0x5D76}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\x87'}, 3, 0x5D87}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\x84'}, 3, 0x5D84}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\x82'}, 3, 0x5D82}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\xa2'}, 3, 0x5DA2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\x9d'}, 3, 0x5D9D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\xac'}, 3, 0x5DAC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\xae'}, 3, 0x5DAE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\xbd'}, 3, 0x5DBD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\x90'}, 3, 0x5D90}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\xb7'}, 3, 0x5DB7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\xbc'}, 3, 0x5DBC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\x89'}, 3, 0x5DC9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\x8d'}, 3, 0x5DCD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\x93'}, 3, 0x5DD3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\x92'}, 3, 0x5DD2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\x96'}, 3, 0x5DD6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\x9b'}, 3, 0x5DDB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xab'}, 3, 0x5DEB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xb2'}, 3, 0x5DF2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\xb5'}, 3, 0x5DF5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\x8b'}, 3, 0x5E0B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\x9a'}, 3, 0x5E1A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\x99'}, 3, 0x5E19}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\x91'}, 3, 0x5E11}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\x9b'}, 3, 0x5E1B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\xb6'}, 3, 0x5E36}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb8', '\xb7'}, 3, 0x5E37}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\x84'}, 3, 0x5E44}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\x83'}, 3, 0x5E43}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\x80'}, 3, 0x5E40}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\x8e'}, 3, 0x5E4E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\x97'}, 3, 0x5E57}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\x94'}, 3, 0x5E54}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\x9f'}, 3, 0x5E5F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xa2'}, 3, 0x5E62}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xa4'}, 3, 0x5E64}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\x87'}, 3, 0x5E47}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xb5'}, 3, 0x5E75}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xb6'}, 3, 0x5E76}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xba'}, 3, 0x5E7A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\xbc'}, 3, 0x9EBC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb9', '\xbf'}, 3, 0x5E7F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xba', '\xa0'}, 3, 0x5EA0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\x81'}, 3, 0x5EC1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\x82'}, 3, 0x5EC2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\x88'}, 3, 0x5EC8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\x90'}, 3, 0x5ED0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\x8f'}, 3, 0x5ECF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\x96'}, 3, 0x5ED6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xa3'}, 3, 0x5EE3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\x9d'}, 3, 0x5EDD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\x9a'}, 3, 0x5EDA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\x9b'}, 3, 0x5EDB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xa2'}, 3, 0x5EE2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xa1'}, 3, 0x5EE1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xa8'}, 3, 0x5EE8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xa9'}, 3, 0x5EE9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xac'}, 3, 0x5EEC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xb1'}, 3, 0x5EF1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xb3'}, 3, 0x5EF3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xb0'}, 3, 0x5EF0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xb4'}, 3, 0x5EF4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xb8'}, 3, 0x5EF8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbb', '\xbe'}, 3, 0x5EFE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x83'}, 3, 0x5F03}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x89'}, 3, 0x5F09}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\x9d'}, 3, 0x5F5D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\x9c'}, 3, 0x5F5C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x8b'}, 3, 0x5F0B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x91'}, 3, 0x5F11}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\x96'}, 3, 0x5F16}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\xa9'}, 3, 0x5F29}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\xad'}, 3, 0x5F2D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\xb8'}, 3, 0x5F38}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\x81'}, 3, 0x5F41}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\x88'}, 3, 0x5F48}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\x8c'}, 3, 0x5F4C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\x8e'}, 3, 0x5F4E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\xaf'}, 3, 0x5F2F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\x91'}, 3, 0x5F51}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\x96'}, 3, 0x5F56}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\x97'}, 3, 0x5F57}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\x99'}, 3, 0x5F59}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xa1'}, 3, 0x5F61}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xad'}, 3, 0x5F6D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xb3'}, 3, 0x5F73}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xb7'}, 3, 0x5F77}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x83'}, 3, 0x5F83}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x82'}, 3, 0x5F82}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xbf'}, 3, 0x5F7F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x8a'}, 3, 0x5F8A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x88'}, 3, 0x5F88}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x91'}, 3, 0x5F91}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x87'}, 3, 0x5F87}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x9e'}, 3, 0x5F9E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x99'}, 3, 0x5F99}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\x98'}, 3, 0x5F98}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\xa0'}, 3, 0x5FA0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\xa8'}, 3, 0x5FA8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\xad'}, 3, 0x5FAD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\xbc'}, 3, 0x5FBC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\x96'}, 3, 0x5FD6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\xbb'}, 3, 0x5FFB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\xa4'}, 3, 0x5FE4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\xb8'}, 3, 0x5FF8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\xb1'}, 3, 0x5FF1}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\x9d'}, 3, 0x5FDD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\xb3'}, 3, 0x60B3}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\xbf'}, 3, 0x5FFF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\xa1'}, 3, 0x6021}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\xa0'}, 3, 0x6060}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\x99'}, 3, 0x6019}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\x90'}, 3, 0x6010}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\xa9'}, 3, 0x6029}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\x8e'}, 3, 0x600E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\xb1'}, 3, 0x6031}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\x9b'}, 3, 0x601B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\x95'}, 3, 0x6015}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\xab'}, 3, 0x602B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\xa6'}, 3, 0x6026}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\x8f'}, 3, 0x600F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x80', '\xba'}, 3, 0x603A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\x9a'}, 3, 0x605A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\x81'}, 3, 0x6041}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\xaa'}, 3, 0x606A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\xb7'}, 3, 0x6077}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\x9f'}, 3, 0x605F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\x8a'}, 3, 0x604A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\x86'}, 3, 0x6046}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\x8d'}, 3, 0x604D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\xa3'}, 3, 0x6063}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\x83'}, 3, 0x6043}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\xa4'}, 3, 0x6064}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\x82'}, 3, 0x6042}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\xac'}, 3, 0x606C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\xab'}, 3, 0x606B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\x99'}, 3, 0x6059}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x81'}, 3, 0x6081}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x8d'}, 3, 0x608D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\xa7'}, 3, 0x60E7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x83'}, 3, 0x6083}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x9a'}, 3, 0x609A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x84'}, 3, 0x6084}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x9b'}, 3, 0x609B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x96'}, 3, 0x6096}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x97'}, 3, 0x6097}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x92'}, 3, 0x6092}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\xa7'}, 3, 0x60A7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x8b'}, 3, 0x608B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\xa1'}, 3, 0x60E1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\xb8'}, 3, 0x60B8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\xa0'}, 3, 0x60E0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\x93'}, 3, 0x60D3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\xb4'}, 3, 0x60B4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\xb0'}, 3, 0x5FF0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\xbd'}, 3, 0x60BD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\x86'}, 3, 0x60C6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\xb5'}, 3, 0x60B5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\x98'}, 3, 0x60D8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\x8d'}, 3, 0x614D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\x95'}, 3, 0x6115}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\x86'}, 3, 0x6106}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\xb6'}, 3, 0x60F6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\xb7'}, 3, 0x60F7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\x80'}, 3, 0x6100}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\xb4'}, 3, 0x60F4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\xba'}, 3, 0x60FA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\x83'}, 3, 0x6103}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\xa1'}, 3, 0x6121}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\xbb'}, 3, 0x60FB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\xb1'}, 3, 0x60F1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\x8d'}, 3, 0x610D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\x8e'}, 3, 0x610E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\x87'}, 3, 0x6147}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\xbe'}, 3, 0x613E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\xa8'}, 3, 0x6128}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\xa7'}, 3, 0x6127}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\x8a'}, 3, 0x614A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\xbf'}, 3, 0x613F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\xbc'}, 3, 0x613C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\xac'}, 3, 0x612C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\xb4'}, 3, 0x6134}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\xbd'}, 3, 0x613D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\x82'}, 3, 0x6142}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\x84'}, 3, 0x6144}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xb3'}, 3, 0x6173}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xb7'}, 3, 0x6177}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\x98'}, 3, 0x6158}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\x99'}, 3, 0x6159}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\x9a'}, 3, 0x615A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xab'}, 3, 0x616B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xb4'}, 3, 0x6174}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xaf'}, 3, 0x616F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xa5'}, 3, 0x6165}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xb1'}, 3, 0x6171}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\x9f'}, 3, 0x615F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\x9d'}, 3, 0x615D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\x93'}, 3, 0x6153}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x85', '\xb5'}, 3, 0x6175}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\x99'}, 3, 0x6199}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\x96'}, 3, 0x6196}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\x87'}, 3, 0x6187}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\xac'}, 3, 0x61AC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\x94'}, 3, 0x6194}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\x9a'}, 3, 0x619A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\x8a'}, 3, 0x618A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\x91'}, 3, 0x6191}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\xab'}, 3, 0x61AB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\xae'}, 3, 0x61AE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\x8c'}, 3, 0x61CC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\x8a'}, 3, 0x61CA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\x89'}, 3, 0x61C9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\xb7'}, 3, 0x61F7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\x88'}, 3, 0x61C8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\x83'}, 3, 0x61C3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\x86'}, 3, 0x61C6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\xba'}, 3, 0x61BA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\x8b'}, 3, 0x61CB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\xb9'}, 3, 0x7F79}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\x8d'}, 3, 0x61CD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\xa6'}, 3, 0x61E6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\xa3'}, 3, 0x61E3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\xb6'}, 3, 0x61F6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\xba'}, 3, 0x61FA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\xb4'}, 3, 0x61F4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\xbf'}, 3, 0x61FF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\xbd'}, 3, 0x61FD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\xbc'}, 3, 0x61FC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x87', '\xbe'}, 3, 0x61FE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x80'}, 3, 0x6200}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x88'}, 3, 0x6208}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x89'}, 3, 0x6209}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x8d'}, 3, 0x620D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x8c'}, 3, 0x620C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x94'}, 3, 0x6214}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x9b'}, 3, 0x621B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x9e'}, 3, 0x621E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\xa1'}, 3, 0x6221}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\xaa'}, 3, 0x622A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\xae'}, 3, 0x622E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\xb0'}, 3, 0x6230}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\xb2'}, 3, 0x6232}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\xb3'}, 3, 0x6233}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\x81'}, 3, 0x6241}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\x8e'}, 3, 0x624E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\x9e'}, 3, 0x625E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\xa3'}, 3, 0x6263}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\x9b'}, 3, 0x625B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\xa0'}, 3, 0x6260}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\xa8'}, 3, 0x6268}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\xbc'}, 3, 0x627C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x82'}, 3, 0x6282}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x89'}, 3, 0x6289}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\xbe'}, 3, 0x627E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x92'}, 3, 0x6292}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x93'}, 3, 0x6293}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x96'}, 3, 0x6296}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x94'}, 3, 0x62D4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x83'}, 3, 0x6283}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x94'}, 3, 0x6294}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x97'}, 3, 0x62D7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x91'}, 3, 0x62D1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\xbb'}, 3, 0x62BB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x8f'}, 3, 0x62CF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\xbf'}, 3, 0x62FF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x86'}, 3, 0x62C6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\x94'}, 3, 0x64D4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x88'}, 3, 0x62C8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x9c'}, 3, 0x62DC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x8c'}, 3, 0x62CC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x8a'}, 3, 0x62CA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x82'}, 3, 0x62C2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x87'}, 3, 0x62C7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\x9b'}, 3, 0x629B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\x89'}, 3, 0x62C9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\x8c'}, 3, 0x630C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\xae'}, 3, 0x62EE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\xb1'}, 3, 0x62F1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\xa7'}, 3, 0x6327}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\x82'}, 3, 0x6302}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\x88'}, 3, 0x6308}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\xaf'}, 3, 0x62EF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8b', '\xb5'}, 3, 0x62F5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\x90'}, 3, 0x6350}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8c', '\xbe'}, 3, 0x633E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\x8d'}, 3, 0x634D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x90', '\x9c'}, 3, 0x641C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\x8f'}, 3, 0x634F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\x96'}, 3, 0x6396}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\x8e'}, 3, 0x638E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\x80'}, 3, 0x6380}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\xab'}, 3, 0x63AB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\xb6'}, 3, 0x6376}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\xa3'}, 3, 0x63A3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\x8f'}, 3, 0x638F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\x89'}, 3, 0x6389}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\x9f'}, 3, 0x639F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\xb5'}, 3, 0x63B5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\xab'}, 3, 0x636B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8d', '\xa9'}, 3, 0x6369}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8e', '\xbe'}, 3, 0x63BE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\xa9'}, 3, 0x63E9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\x80'}, 3, 0x63C0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\x86'}, 3, 0x63C6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\xa3'}, 3, 0x63E3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\x89'}, 3, 0x63C9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\x92'}, 3, 0x63D2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\xb6'}, 3, 0x63F6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\x84'}, 3, 0x63C4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x90', '\x96'}, 3, 0x6416}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x90', '\xb4'}, 3, 0x6434}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x90', '\x86'}, 3, 0x6406}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x90', '\x93'}, 3, 0x6413}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x90', '\xa6'}, 3, 0x6426}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x90', '\xb6'}, 3, 0x6436}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\x9d'}, 3, 0x651D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x90', '\x97'}, 3, 0x6417}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x90', '\xa8'}, 3, 0x6428}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x90', '\x8f'}, 3, 0x640F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x91', '\xa7'}, 3, 0x6467}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x91', '\xaf'}, 3, 0x646F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x91', '\xb6'}, 3, 0x6476}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x91', '\x8e'}, 3, 0x644E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\xaa'}, 3, 0x652A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\x95'}, 3, 0x6495}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\x93'}, 3, 0x6493}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\xa5'}, 3, 0x64A5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\xa9'}, 3, 0x64A9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\x88'}, 3, 0x6488}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\xbc'}, 3, 0x64BC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\x9a'}, 3, 0x64DA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\x92'}, 3, 0x64D2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\x85'}, 3, 0x64C5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\x87'}, 3, 0x64C7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\xbb'}, 3, 0x64BB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\x98'}, 3, 0x64D8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\x82'}, 3, 0x64C2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\xb1'}, 3, 0x64F1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\xa7'}, 3, 0x64E7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x89'}, 3, 0x8209}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\xa0'}, 3, 0x64E0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\xa1'}, 3, 0x64E1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\xac'}, 3, 0x62AC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\xa3'}, 3, 0x64E3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\xaf'}, 3, 0x64EF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\xac'}, 3, 0x652C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\xb6'}, 3, 0x64F6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\xb4'}, 3, 0x64F4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\xb2'}, 3, 0x64F2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\xba'}, 3, 0x64FA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\x80'}, 3, 0x6500}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\xbd'}, 3, 0x64FD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\x98'}, 3, 0x6518}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\x9c'}, 3, 0x651C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\x85'}, 3, 0x6505}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\xa4'}, 3, 0x6524}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\xa3'}, 3, 0x6523}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\xab'}, 3, 0x652B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\xb4'}, 3, 0x6534}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\xb5'}, 3, 0x6535}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\xb7'}, 3, 0x6537}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\xb6'}, 3, 0x6536}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x94', '\xb8'}, 3, 0x6538}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\x8b'}, 3, 0x754B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\x88'}, 3, 0x6548}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\x96'}, 3, 0x6556}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\x95'}, 3, 0x6555}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\x8d'}, 3, 0x654D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\x98'}, 3, 0x6558}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\x9e'}, 3, 0x655E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\x9d'}, 3, 0x655D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\xb2'}, 3, 0x6572}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\xb8'}, 3, 0x6578}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\x82'}, 3, 0x6582}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\x83'}, 3, 0x6583}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xae', '\x8a'}, 3, 0x8B8A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\x9b'}, 3, 0x659B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\x9f'}, 3, 0x659F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\xab'}, 3, 0x65AB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x96', '\xb7'}, 3, 0x65B7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\x83'}, 3, 0x65C3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\x86'}, 3, 0x65C6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\x81'}, 3, 0x65C1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\x84'}, 3, 0x65C4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\x8c'}, 3, 0x65CC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\x92'}, 3, 0x65D2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\x9b'}, 3, 0x65DB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\x99'}, 3, 0x65D9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\xa0'}, 3, 0x65E0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\xa1'}, 3, 0x65E1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\xb1'}, 3, 0x65F1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xb2'}, 3, 0x6772}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x8a'}, 3, 0x660A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x83'}, 3, 0x6603}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x97', '\xbb'}, 3, 0x65FB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xb3'}, 3, 0x6773}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xb5'}, 3, 0x6635}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xb6'}, 3, 0x6636}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xb4'}, 3, 0x6634}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x9c'}, 3, 0x661C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\x8f'}, 3, 0x664F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\x84'}, 3, 0x6644}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\x89'}, 3, 0x6649}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\x81'}, 3, 0x6641}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\x9e'}, 3, 0x665E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\x9d'}, 3, 0x665D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\xa4'}, 3, 0x6664}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\xa7'}, 3, 0x6667}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\xa8'}, 3, 0x6668}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\x9f'}, 3, 0x665F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\xa2'}, 3, 0x6662}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\xb0'}, 3, 0x6670}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\x83'}, 3, 0x6683}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\x88'}, 3, 0x6688}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\x8e'}, 3, 0x668E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\x89'}, 3, 0x6689}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\x84'}, 3, 0x6684}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\x98'}, 3, 0x6698}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\x9d'}, 3, 0x669D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\x81'}, 3, 0x66C1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\xb9'}, 3, 0x66B9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\x89'}, 3, 0x66C9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\xbe'}, 3, 0x66BE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\xbc'}, 3, 0x66BC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\x84'}, 3, 0x66C4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\xb8'}, 3, 0x66B8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\x96'}, 3, 0x66D6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\x9a'}, 3, 0x66DA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xa0'}, 3, 0x66E0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xbf'}, 3, 0x663F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xa6'}, 3, 0x66E6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xa9'}, 3, 0x66E9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xb0'}, 3, 0x66F0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xb5'}, 3, 0x66F5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xb7'}, 3, 0x66F7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x8f'}, 3, 0x670F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x96'}, 3, 0x6716}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x9e'}, 3, 0x671E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\xa6'}, 3, 0x6726}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\xa7'}, 3, 0x6727}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\xb8'}, 3, 0x9738}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\xae'}, 3, 0x672E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\xbf'}, 3, 0x673F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\xb6'}, 3, 0x6736}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\x81'}, 3, 0x6741}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\xb8'}, 3, 0x6738}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\xb7'}, 3, 0x6737}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\x86'}, 3, 0x6746}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\x9e'}, 3, 0x675E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xa0'}, 3, 0x6760}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\x99'}, 3, 0x6759}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xa3'}, 3, 0x6763}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xa4'}, 3, 0x6764}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\x89'}, 3, 0x6789}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xb0'}, 3, 0x6770}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\xa9'}, 3, 0x67A9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xbc'}, 3, 0x677C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9d', '\xaa'}, 3, 0x676A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\x8c'}, 3, 0x678C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\x8b'}, 3, 0x678B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\xa6'}, 3, 0x67A6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\xa1'}, 3, 0x67A1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\x85'}, 3, 0x6785}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\xb7'}, 3, 0x67B7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\xaf'}, 3, 0x67EF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\xb4'}, 3, 0x67B4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\xac'}, 3, 0x67EC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\xb3'}, 3, 0x67B3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\xa9'}, 3, 0x67E9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\xb8'}, 3, 0x67B8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\xa4'}, 3, 0x67E4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\x9e'}, 3, 0x67DE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\x9d'}, 3, 0x67DD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\xa2'}, 3, 0x67E2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\xae'}, 3, 0x67EE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\xb9'}, 3, 0x67B9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\x8e'}, 3, 0x67CE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\x86'}, 3, 0x67C6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\xa7'}, 3, 0x67E7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaa', '\x9c'}, 3, 0x6A9C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\x9e'}, 3, 0x681E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x86'}, 3, 0x6846}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\xa9'}, 3, 0x6829}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x80'}, 3, 0x6840}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x8d'}, 3, 0x684D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\xb2'}, 3, 0x6832}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x8e'}, 3, 0x684E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\xb3'}, 3, 0x68B3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\xab'}, 3, 0x682B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x99'}, 3, 0x6859}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\xa3'}, 3, 0x6863}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\xb7'}, 3, 0x6877}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\xbf'}, 3, 0x687F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\x9f'}, 3, 0x689F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\x8f'}, 3, 0x688F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\xad'}, 3, 0x68AD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\x94'}, 3, 0x6894}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\x9d'}, 3, 0x689D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\x9b'}, 3, 0x689B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\x83'}, 3, 0x6883}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaa', '\xae'}, 3, 0x6AAE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\xb9'}, 3, 0x68B9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\xb4'}, 3, 0x6874}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\xb5'}, 3, 0x68B5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\xa0'}, 3, 0x68A0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\xba'}, 3, 0x68BA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\x8f'}, 3, 0x690F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa2', '\x8d'}, 3, 0x688D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\xbe'}, 3, 0x687E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\x81'}, 3, 0x6901}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x8a'}, 3, 0x68CA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\x88'}, 3, 0x6908}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x98'}, 3, 0x68D8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\xa2'}, 3, 0x6922}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\xa6'}, 3, 0x6926}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\xa1'}, 3, 0x68E1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\x8c'}, 3, 0x690C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x8d'}, 3, 0x68CD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x94'}, 3, 0x68D4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\xa7'}, 3, 0x68E7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x95'}, 3, 0x68D5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\xb6'}, 3, 0x6936}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\x92'}, 3, 0x6912}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\x84'}, 3, 0x6904}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x97'}, 3, 0x68D7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\xa3'}, 3, 0x68E3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\xa5'}, 3, 0x6925}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\xb9'}, 3, 0x68F9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\xa0'}, 3, 0x68E0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\xaf'}, 3, 0x68EF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\xa8'}, 3, 0x6928}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\xaa'}, 3, 0x692A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\x9a'}, 3, 0x691A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\xa3'}, 3, 0x6923}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\xa1'}, 3, 0x6921}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x86'}, 3, 0x68C6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xb9'}, 3, 0x6979}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xb7'}, 3, 0x6977}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\x9c'}, 3, 0x695C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xb8'}, 3, 0x6978}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xab'}, 3, 0x696B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\x94'}, 3, 0x6954}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xbe'}, 3, 0x697E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xae'}, 3, 0x696E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\xb9'}, 3, 0x6939}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xb4'}, 3, 0x6974}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\xbd'}, 3, 0x693D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\x99'}, 3, 0x6959}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa4', '\xb0'}, 3, 0x6930}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xa1'}, 3, 0x6961}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\x9e'}, 3, 0x695E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\x9d'}, 3, 0x695D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\x81'}, 3, 0x6981}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa5', '\xaa'}, 3, 0x696A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\xb2'}, 3, 0x69B2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\xae'}, 3, 0x69AE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\x90'}, 3, 0x69D0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\xbf'}, 3, 0x69BF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\x81'}, 3, 0x69C1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\x93'}, 3, 0x69D3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\xbe'}, 3, 0x69BE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\x8e'}, 3, 0x69CE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xa8'}, 3, 0x5BE8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\x8a'}, 3, 0x69CA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\x9d'}, 3, 0x69DD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\xbb'}, 3, 0x69BB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\x83'}, 3, 0x69C3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\xa7'}, 3, 0x69A7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\xae'}, 3, 0x6A2E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\x91'}, 3, 0x6991}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\xa0'}, 3, 0x69A0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\x9c'}, 3, 0x699C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\x95'}, 3, 0x6995}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\xb4'}, 3, 0x69B4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\x9e'}, 3, 0x69DE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\xa8'}, 3, 0x69E8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\x82'}, 3, 0x6A02}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\x9b'}, 3, 0x6A1B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\xbf'}, 3, 0x69FF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\x8a'}, 3, 0x6B0A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\xb9'}, 3, 0x69F9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\xb2'}, 3, 0x69F2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\xa7'}, 3, 0x69E7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\x85'}, 3, 0x6A05}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa6', '\xb1'}, 3, 0x69B1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\x9e'}, 3, 0x6A1E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\xad'}, 3, 0x69ED}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\x94'}, 3, 0x6A14}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\xab'}, 3, 0x69EB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\x8a'}, 3, 0x6A0A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\x92'}, 3, 0x6A12}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\x81'}, 3, 0x6AC1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\xa3'}, 3, 0x6A23}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\x93'}, 3, 0x6A13}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\x84'}, 3, 0x6A44}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\x8c'}, 3, 0x6A0C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\xb2'}, 3, 0x6A72}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\xb6'}, 3, 0x6A36}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\xb8'}, 3, 0x6A78}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\x87'}, 3, 0x6A47}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\xa2'}, 3, 0x6A62}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\x99'}, 3, 0x6A59}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\xa6'}, 3, 0x6A66}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\x88'}, 3, 0x6A48}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\xb8'}, 3, 0x6A38}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\xa2'}, 3, 0x6A22}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaa', '\x90'}, 3, 0x6A90}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaa', '\x8d'}, 3, 0x6A8D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaa', '\xa0'}, 3, 0x6AA0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaa', '\x84'}, 3, 0x6A84}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaa', '\xa2'}, 3, 0x6AA2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaa', '\xa3'}, 3, 0x6AA3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaa', '\x97'}, 3, 0x6A97}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x98', '\x97'}, 3, 0x8617}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaa', '\xbb'}, 3, 0x6ABB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\x83'}, 3, 0x6AC3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\x82'}, 3, 0x6AC2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaa', '\xb8'}, 3, 0x6AB8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaa', '\xb3'}, 3, 0x6AB3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaa', '\xac'}, 3, 0x6AAC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\x9e'}, 3, 0x6ADE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\x91'}, 3, 0x6AD1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\x9f'}, 3, 0x6ADF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaa', '\xaa'}, 3, 0x6AAA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\x9a'}, 3, 0x6ADA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\xaa'}, 3, 0x6AEA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\xbb'}, 3, 0x6AFB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\x85'}, 3, 0x6B05}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x98', '\x96'}, 3, 0x8616}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\xba'}, 3, 0x6AFA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\x92'}, 3, 0x6B12}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\x96'}, 3, 0x6B16}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\xb1'}, 3, 0x9B31}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\x9f'}, 3, 0x6B1F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\xb8'}, 3, 0x6B38}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\xb7'}, 3, 0x6B37}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\x9c'}, 3, 0x76DC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xac', '\xb9'}, 3, 0x6B39}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\xae'}, 3, 0x98EE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\x87'}, 3, 0x6B47}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\x83'}, 3, 0x6B43}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\x89'}, 3, 0x6B49}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\x90'}, 3, 0x6B50}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\x99'}, 3, 0x6B59}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\x94'}, 3, 0x6B54}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\x9b'}, 3, 0x6B5B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\x9f'}, 3, 0x6B5F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\xa1'}, 3, 0x6B61}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\xb8'}, 3, 0x6B78}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\xb9'}, 3, 0x6B79}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xad', '\xbf'}, 3, 0x6B7F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\x80'}, 3, 0x6B80}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\x84'}, 3, 0x6B84}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\x83'}, 3, 0x6B83}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\x8d'}, 3, 0x6B8D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\x98'}, 3, 0x6B98}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\x95'}, 3, 0x6B95}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\x9e'}, 3, 0x6B9E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\xa4'}, 3, 0x6BA4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\xaa'}, 3, 0x6BAA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\xab'}, 3, 0x6BAB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\xaf'}, 3, 0x6BAF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\xb2'}, 3, 0x6BB2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\xb1'}, 3, 0x6BB1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\xb3'}, 3, 0x6BB3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\xb7'}, 3, 0x6BB7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xae', '\xbc'}, 3, 0x6BBC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\x86'}, 3, 0x6BC6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\x8b'}, 3, 0x6BCB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\x93'}, 3, 0x6BD3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\x9f'}, 3, 0x6BDF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\xac'}, 3, 0x6BEC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\xab'}, 3, 0x6BEB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\xb3'}, 3, 0x6BF3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\xaf'}, 3, 0x6BEF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\xbe'}, 3, 0x9EBE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb0', '\x88'}, 3, 0x6C08}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb0', '\x93'}, 3, 0x6C13}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb0', '\x94'}, 3, 0x6C14}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb0', '\x9b'}, 3, 0x6C1B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb0', '\xa4'}, 3, 0x6C24}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb0', '\xa3'}, 3, 0x6C23}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\x9e'}, 3, 0x6C5E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\x95'}, 3, 0x6C55}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\xa2'}, 3, 0x6C62}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\xaa'}, 3, 0x6C6A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\x82'}, 3, 0x6C82}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\x8d'}, 3, 0x6C8D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\x9a'}, 3, 0x6C9A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\x81'}, 3, 0x6C81}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\x9b'}, 3, 0x6C9B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\xbe'}, 3, 0x6C7E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\xa8'}, 3, 0x6C68}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\xb3'}, 3, 0x6C73}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\x92'}, 3, 0x6C92}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\x90'}, 3, 0x6C90}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\x84'}, 3, 0x6CC4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\xb1'}, 3, 0x6CF1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\x93'}, 3, 0x6CD3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\xbd'}, 3, 0x6CBD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\x97'}, 3, 0x6CD7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\x85'}, 3, 0x6CC5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\x9d'}, 3, 0x6CDD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\xae'}, 3, 0x6CAE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\xb1'}, 3, 0x6CB1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\xbe'}, 3, 0x6CBE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\xba'}, 3, 0x6CBA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\x9b'}, 3, 0x6CDB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\xaf'}, 3, 0x6CEF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\x99'}, 3, 0x6CD9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\xaa'}, 3, 0x6CEA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\x9f'}, 3, 0x6D1F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\x8d'}, 3, 0x884D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\xb6'}, 3, 0x6D36}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\xab'}, 3, 0x6D2B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\xbd'}, 3, 0x6D3D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\xb8'}, 3, 0x6D38}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\x99'}, 3, 0x6D19}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\xb5'}, 3, 0x6D35}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\xb3'}, 3, 0x6D33}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\x92'}, 3, 0x6D12}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\x8c'}, 3, 0x6D0C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\xa3'}, 3, 0x6D63}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\x93'}, 3, 0x6D93}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\xa4'}, 3, 0x6D64}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\x9a'}, 3, 0x6D5A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\xb9'}, 3, 0x6D79}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\x99'}, 3, 0x6D59}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\x8e'}, 3, 0x6D8E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\x95'}, 3, 0x6D95}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\xa4'}, 3, 0x6FE4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\x85'}, 3, 0x6D85}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xb9'}, 3, 0x6DF9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\x95'}, 3, 0x6E15}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\x8a'}, 3, 0x6E0A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\xb5'}, 3, 0x6DB5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\x87'}, 3, 0x6DC7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xa6'}, 3, 0x6DE6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\xb8'}, 3, 0x6DB8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\x86'}, 3, 0x6DC6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xac'}, 3, 0x6DEC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\x9e'}, 3, 0x6DDE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\x8c'}, 3, 0x6DCC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xa8'}, 3, 0x6DE8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\x92'}, 3, 0x6DD2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\x85'}, 3, 0x6DC5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xba'}, 3, 0x6DFA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\x99'}, 3, 0x6DD9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xa4'}, 3, 0x6DE4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\x95'}, 3, 0x6DD5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xaa'}, 3, 0x6DEA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xae'}, 3, 0x6DEE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xad'}, 3, 0x6E2D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\xae'}, 3, 0x6E6E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xae'}, 3, 0x6E2E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\x99'}, 3, 0x6E19}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\xb2'}, 3, 0x6E72}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\x9f'}, 3, 0x6E5F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xbe'}, 3, 0x6E3E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xa3'}, 3, 0x6E23}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\xab'}, 3, 0x6E6B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xab'}, 3, 0x6E2B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\xb6'}, 3, 0x6E76}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\x8d'}, 3, 0x6E4D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\x9f'}, 3, 0x6E1F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\x83'}, 3, 0x6E43}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xba'}, 3, 0x6E3A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\x8e'}, 3, 0x6E4E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xa4'}, 3, 0x6E24}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\xbf'}, 3, 0x6EFF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\x9d'}, 3, 0x6E1D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xb8'}, 3, 0x6E38}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\x82'}, 3, 0x6E82}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\xaa'}, 3, 0x6EAA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\x98'}, 3, 0x6E98}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\x89'}, 3, 0x6EC9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\xb7'}, 3, 0x6EB7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\x93'}, 3, 0x6ED3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\xbd'}, 3, 0x6EBD}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\xaf'}, 3, 0x6EAF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\x84'}, 3, 0x6EC4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\xb2'}, 3, 0x6EB2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\x94'}, 3, 0x6ED4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\x95'}, 3, 0x6ED5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\x8f'}, 3, 0x6E8F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\xa5'}, 3, 0x6EA5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\x82'}, 3, 0x6EC2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\x9f'}, 3, 0x6E9F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\x81'}, 3, 0x6F41}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\x91'}, 3, 0x6F11}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x81', '\x8c'}, 3, 0x704C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\xac'}, 3, 0x6EEC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\xb8'}, 3, 0x6EF8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\xbe'}, 3, 0x6EFE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\xbf'}, 3, 0x6F3F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\xb2'}, 3, 0x6EF2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\xb1'}, 3, 0x6F31}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\xaf'}, 3, 0x6EEF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\xb2'}, 3, 0x6F32}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\x8c'}, 3, 0x6ECC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\xbe'}, 3, 0x6F3E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbc', '\x93'}, 3, 0x6F13}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbb', '\xb7'}, 3, 0x6EF7}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\x86'}, 3, 0x6F86}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\xba'}, 3, 0x6F7A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\xb8'}, 3, 0x6F78}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\x81'}, 3, 0x6F81}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\x80'}, 3, 0x6F80}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\xaf'}, 3, 0x6F6F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\x9b'}, 3, 0x6F5B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\xb3'}, 3, 0x6FF3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\xad'}, 3, 0x6F6D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\x82'}, 3, 0x6F82}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\xbc'}, 3, 0x6F7C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\x98'}, 3, 0x6F58}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\x8e'}, 3, 0x6F8E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\x91'}, 3, 0x6F91}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\x82'}, 3, 0x6FC2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\xa6'}, 3, 0x6F66}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\xb3'}, 3, 0x6FB3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\xa3'}, 3, 0x6FA3}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\xa1'}, 3, 0x6FA1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\xa4'}, 3, 0x6FA4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\xb9'}, 3, 0x6FB9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\x86'}, 3, 0x6FC6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\xaa'}, 3, 0x6FAA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\x9f'}, 3, 0x6FDF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\x95'}, 3, 0x6FD5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\xac'}, 3, 0x6FEC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\x94'}, 3, 0x6FD4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\x98'}, 3, 0x6FD8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\xb1'}, 3, 0x6FF1}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\xae'}, 3, 0x6FEE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\x9b'}, 3, 0x6FDB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\x89'}, 3, 0x7009}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\x8b'}, 3, 0x700B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\xba'}, 3, 0x6FFA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\x91'}, 3, 0x7011}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\x81'}, 3, 0x7001}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\x8f'}, 3, 0x700F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\xbe'}, 3, 0x6FFE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\x9b'}, 3, 0x701B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\x9a'}, 3, 0x701A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbd', '\xb4'}, 3, 0x6F74}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\x9d'}, 3, 0x701D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\x98'}, 3, 0x7018}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\x9f'}, 3, 0x701F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\xb0'}, 3, 0x7030}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\xbe'}, 3, 0x703E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\xb2'}, 3, 0x7032}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x81', '\x91'}, 3, 0x7051}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x81', '\xa3'}, 3, 0x7063}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\x99'}, 3, 0x7099}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\x92'}, 3, 0x7092}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\xaf'}, 3, 0x70AF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x83', '\xb1'}, 3, 0x70F1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\xac'}, 3, 0x70AC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\xb8'}, 3, 0x70B8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\xb3'}, 3, 0x70B3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\xae'}, 3, 0x70AE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x83', '\x9f'}, 3, 0x70DF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x83', '\x8b'}, 3, 0x70CB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x83', '\x9d'}, 3, 0x70DD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x83', '\x99'}, 3, 0x70D9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x84', '\x89'}, 3, 0x7109}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x83', '\xbd'}, 3, 0x70FD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x84', '\x9c'}, 3, 0x711C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x84', '\x99'}, 3, 0x7119}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\xa5'}, 3, 0x7165}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\x95'}, 3, 0x7155}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x86', '\x88'}, 3, 0x7188}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\xa6'}, 3, 0x7166}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\xa2'}, 3, 0x7162}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\x8c'}, 3, 0x714C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\x96'}, 3, 0x7156}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\xac'}, 3, 0x716C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x86', '\x8f'}, 3, 0x718F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\xbb'}, 3, 0x71FB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x86', '\x84'}, 3, 0x7184}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x86', '\x95'}, 3, 0x7195}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x86', '\xa8'}, 3, 0x71A8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x86', '\xac'}, 3, 0x71AC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\x97'}, 3, 0x71D7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x86', '\xb9'}, 3, 0x71B9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x86', '\xbe'}, 3, 0x71BE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\x92'}, 3, 0x71D2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\x89'}, 3, 0x71C9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\x94'}, 3, 0x71D4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\x8e'}, 3, 0x71CE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\xa0'}, 3, 0x71E0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\xac'}, 3, 0x71EC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\xa7'}, 3, 0x71E7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\xb5'}, 3, 0x71F5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\xbc'}, 3, 0x71FC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\xb9'}, 3, 0x71F9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\xbf'}, 3, 0x71FF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\x8d'}, 3, 0x720D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\x90'}, 3, 0x7210}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\x9b'}, 3, 0x721B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\xa8'}, 3, 0x7228}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\xad'}, 3, 0x722D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\xac'}, 3, 0x722C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\xb0'}, 3, 0x7230}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\xb2'}, 3, 0x7232}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\xbb'}, 3, 0x723B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\xbc'}, 3, 0x723C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x88', '\xbf'}, 3, 0x723F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\x80'}, 3, 0x7240}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\x86'}, 3, 0x7246}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\x8b'}, 3, 0x724B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\x98'}, 3, 0x7258}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\xb4'}, 3, 0x7274}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x89', '\xbe'}, 3, 0x727E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\x82'}, 3, 0x7282}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\x81'}, 3, 0x7281}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\x87'}, 3, 0x7287}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\x92'}, 3, 0x7292}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\x96'}, 3, 0x7296}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\xa2'}, 3, 0x72A2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\xa7'}, 3, 0x72A7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\xb9'}, 3, 0x72B9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\xb2'}, 3, 0x72B2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\x83'}, 3, 0x72C3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\x86'}, 3, 0x72C6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\x84'}, 3, 0x72C4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\x8e'}, 3, 0x72CE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\x92'}, 3, 0x72D2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\xa2'}, 3, 0x72E2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\xa0'}, 3, 0x72E0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\xa1'}, 3, 0x72E1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\xb9'}, 3, 0x72F9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8b', '\xb7'}, 3, 0x72F7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\x8f'}, 3, 0x500F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\x97'}, 3, 0x7317}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\x8a'}, 3, 0x730A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\x9c'}, 3, 0x731C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\x96'}, 3, 0x7316}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\x9d'}, 3, 0x731D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\xb4'}, 3, 0x7334}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\xaf'}, 3, 0x732F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\xa9'}, 3, 0x7329}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\xa5'}, 3, 0x7325}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\xbe'}, 3, 0x733E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8d', '\x8e'}, 3, 0x734E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8d', '\x8f'}, 3, 0x734F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\x98'}, 3, 0x9ED8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8d', '\x97'}, 3, 0x7357}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8d', '\xaa'}, 3, 0x736A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8d', '\xa8'}, 3, 0x7368}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8d', '\xb0'}, 3, 0x7370}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8d', '\xb8'}, 3, 0x7378}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8d', '\xb5'}, 3, 0x7375}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8d', '\xbb'}, 3, 0x737B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8d', '\xba'}, 3, 0x737A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\x88'}, 3, 0x73C8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8e', '\xb3'}, 3, 0x73B3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\x8e'}, 3, 0x73CE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8e', '\xbb'}, 3, 0x73BB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\x80'}, 3, 0x73C0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\xa5'}, 3, 0x73E5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\xae'}, 3, 0x73EE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\x9e'}, 3, 0x73DE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x92', '\xa2'}, 3, 0x74A2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\x85'}, 3, 0x7405}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\xaf'}, 3, 0x746F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xa5'}, 3, 0x7425}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\xb8'}, 3, 0x73F8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xb2'}, 3, 0x7432}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xba'}, 3, 0x743A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\x95'}, 3, 0x7455}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xbf'}, 3, 0x743F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\x9f'}, 3, 0x745F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\x99'}, 3, 0x7459}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\x81'}, 3, 0x7441}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\x9c'}, 3, 0x745C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\xa9'}, 3, 0x7469}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\xb0'}, 3, 0x7470}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\xa3'}, 3, 0x7463}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\xaa'}, 3, 0x746A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\xb6'}, 3, 0x7476}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\xbe'}, 3, 0x747E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x92', '\x8b'}, 3, 0x748B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x92', '\x9e'}, 3, 0x749E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x92', '\xa7'}, 3, 0x74A7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\x8a'}, 3, 0x74CA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\x8f'}, 3, 0x74CF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\x94'}, 3, 0x74D4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\xb1'}, 3, 0x73F1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\xa0'}, 3, 0x74E0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\xa3'}, 3, 0x74E3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\xa7'}, 3, 0x74E7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\xa9'}, 3, 0x74E9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\xae'}, 3, 0x74EE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\xb2'}, 3, 0x74F2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\xb0'}, 3, 0x74F0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\xb1'}, 3, 0x74F1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\xb8'}, 3, 0x74F8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x93', '\xb7'}, 3, 0x74F7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\x84'}, 3, 0x7504}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\x83'}, 3, 0x7503}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\x85'}, 3, 0x7505}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\x8c'}, 3, 0x750C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\x8e'}, 3, 0x750E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\x8d'}, 3, 0x750D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\x95'}, 3, 0x7515}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\x93'}, 3, 0x7513}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\x9e'}, 3, 0x751E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xa6'}, 3, 0x7526}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xac'}, 3, 0x752C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xbc'}, 3, 0x753C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\x84'}, 3, 0x7544}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\x8d'}, 3, 0x754D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\x8a'}, 3, 0x754A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\x89'}, 3, 0x7549}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\x9b'}, 3, 0x755B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\x86'}, 3, 0x7546}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\x9a'}, 3, 0x755A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xa9'}, 3, 0x7569}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xa4'}, 3, 0x7564}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xa7'}, 3, 0x7567}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xab'}, 3, 0x756B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xad'}, 3, 0x756D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xb8'}, 3, 0x7578}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xb6'}, 3, 0x7576}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\x86'}, 3, 0x7586}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\x87'}, 3, 0x7587}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xb4'}, 3, 0x7574}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\x8a'}, 3, 0x758A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\x89'}, 3, 0x7589}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\x82'}, 3, 0x7582}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\x94'}, 3, 0x7594}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\x9a'}, 3, 0x759A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\x9d'}, 3, 0x759D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\xa5'}, 3, 0x75A5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\xa3'}, 3, 0x75A3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\x82'}, 3, 0x75C2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\xb3'}, 3, 0x75B3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\x83'}, 3, 0x75C3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\xb5'}, 3, 0x75B5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\xbd'}, 3, 0x75BD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\xb8'}, 3, 0x75B8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\xbc'}, 3, 0x75BC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x96', '\xb1'}, 3, 0x75B1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\x8d'}, 3, 0x75CD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\x8a'}, 3, 0x75CA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\x92'}, 3, 0x75D2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\x99'}, 3, 0x75D9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\xa3'}, 3, 0x75E3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\x9e'}, 3, 0x75DE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\xbe'}, 3, 0x75FE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\xbf'}, 3, 0x75FF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\xbc'}, 3, 0x75FC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x98', '\x81'}, 3, 0x7601}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\xb0'}, 3, 0x75F0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\xba'}, 3, 0x75FA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\xb2'}, 3, 0x75F2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x97', '\xb3'}, 3, 0x75F3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x98', '\x8b'}, 3, 0x760B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x98', '\x8d'}, 3, 0x760D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x98', '\x89'}, 3, 0x7609}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x98', '\x9f'}, 3, 0x761F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x98', '\xa7'}, 3, 0x7627}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x98', '\xa0'}, 3, 0x7620}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x98', '\xa1'}, 3, 0x7621}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x98', '\xa2'}, 3, 0x7622}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x98', '\xa4'}, 3, 0x7624}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x98', '\xb4'}, 3, 0x7634}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x98', '\xb0'}, 3, 0x7630}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x98', '\xbb'}, 3, 0x763B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\x87'}, 3, 0x7647}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\x88'}, 3, 0x7648}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\x86'}, 3, 0x7646}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\x9c'}, 3, 0x765C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\x98'}, 3, 0x7658}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\xa1'}, 3, 0x7661}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\xa2'}, 3, 0x7662}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\xa8'}, 3, 0x7668}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\xa9'}, 3, 0x7669}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\xaa'}, 3, 0x766A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\xa7'}, 3, 0x7667}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\xac'}, 3, 0x766C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\xb0'}, 3, 0x7670}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\xb2'}, 3, 0x7672}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\xb6'}, 3, 0x7676}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\xb8'}, 3, 0x7678}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x99', '\xbc'}, 3, 0x767C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x80'}, 3, 0x7680}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x83'}, 3, 0x7683}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x88'}, 3, 0x7688}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x8b'}, 3, 0x768B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x8e'}, 3, 0x768E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x96'}, 3, 0x7696}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x93'}, 3, 0x7693}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x99'}, 3, 0x7699}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x9a'}, 3, 0x769A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\xb0'}, 3, 0x76B0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\xb4'}, 3, 0x76B4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\xb8'}, 3, 0x76B8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\xb9'}, 3, 0x76B9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\xba'}, 3, 0x76BA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\x82'}, 3, 0x76C2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\x8d'}, 3, 0x76CD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\x96'}, 3, 0x76D6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\x92'}, 3, 0x76D2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\x9e'}, 3, 0x76DE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\xa1'}, 3, 0x76E1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\xa5'}, 3, 0x76E5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\xa7'}, 3, 0x76E7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\xaa'}, 3, 0x76EA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x98', '\xaf'}, 3, 0x862F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9b', '\xbb'}, 3, 0x76FB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\x88'}, 3, 0x7708}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\x87'}, 3, 0x7707}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\x84'}, 3, 0x7704}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\xa9'}, 3, 0x7729}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\xa4'}, 3, 0x7724}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\x9e'}, 3, 0x771E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\xa5'}, 3, 0x7725}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\xa6'}, 3, 0x7726}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\x9b'}, 3, 0x771B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\xb7'}, 3, 0x7737}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9c', '\xb8'}, 3, 0x7738}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9d', '\x87'}, 3, 0x7747}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9d', '\x9a'}, 3, 0x775A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9d', '\xa8'}, 3, 0x7768}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9d', '\xab'}, 3, 0x776B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9d', '\x9b'}, 3, 0x775B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9d', '\xa5'}, 3, 0x7765}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9d', '\xbf'}, 3, 0x777F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9d', '\xbe'}, 3, 0x777E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9d', '\xb9'}, 3, 0x7779}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9e', '\x8e'}, 3, 0x778E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9e', '\x8b'}, 3, 0x778B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9e', '\x91'}, 3, 0x7791}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9e', '\xa0'}, 3, 0x77A0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9e', '\x9e'}, 3, 0x779E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9e', '\xb0'}, 3, 0x77B0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9e', '\xb6'}, 3, 0x77B6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9e', '\xb9'}, 3, 0x77B9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9e', '\xbf'}, 3, 0x77BF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9e', '\xbc'}, 3, 0x77BC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9e', '\xbd'}, 3, 0x77BD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9e', '\xbb'}, 3, 0x77BB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9f', '\x87'}, 3, 0x77C7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9f', '\x8d'}, 3, 0x77CD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9f', '\x97'}, 3, 0x77D7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9f', '\x9a'}, 3, 0x77DA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9f', '\x9c'}, 3, 0x77DC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9f', '\xa3'}, 3, 0x77E3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9f', '\xae'}, 3, 0x77EE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9f', '\xbc'}, 3, 0x77FC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa0', '\x8c'}, 3, 0x780C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa0', '\x92'}, 3, 0x7812}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa4', '\xa6'}, 3, 0x7926}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa0', '\xa0'}, 3, 0x7820}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa4', '\xaa'}, 3, 0x792A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa1', '\x85'}, 3, 0x7845}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\x8e'}, 3, 0x788E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa1', '\xb4'}, 3, 0x7874}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\x86'}, 3, 0x7886}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa1', '\xbc'}, 3, 0x787C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\x9a'}, 3, 0x789A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\x8c'}, 3, 0x788C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\xa3'}, 3, 0x78A3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\xb5'}, 3, 0x78B5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\xaa'}, 3, 0x78AA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\xaf'}, 3, 0x78AF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa3', '\x91'}, 3, 0x78D1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa3', '\x86'}, 3, 0x78C6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa3', '\x8b'}, 3, 0x78CB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa3', '\x94'}, 3, 0x78D4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\xbe'}, 3, 0x78BE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa2', '\xbc'}, 3, 0x78BC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa3', '\x85'}, 3, 0x78C5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa3', '\x8a'}, 3, 0x78CA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa3', '\xac'}, 3, 0x78EC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa3', '\xa7'}, 3, 0x78E7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa3', '\x9a'}, 3, 0x78DA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa3', '\xbd'}, 3, 0x78FD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa3', '\xb4'}, 3, 0x78F4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa4', '\x87'}, 3, 0x7907}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa4', '\x92'}, 3, 0x7912}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa4', '\x91'}, 3, 0x7911}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa4', '\x99'}, 3, 0x7919}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa4', '\xac'}, 3, 0x792C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa4', '\xab'}, 3, 0x792B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\x80'}, 3, 0x7940}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\xa0'}, 3, 0x7960}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\x97'}, 3, 0x7957}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\x9f'}, 3, 0x795F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\x9a'}, 3, 0x795A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\x95'}, 3, 0x7955}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\x93'}, 3, 0x7953}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\xba'}, 3, 0x797A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa5', '\xbf'}, 3, 0x797F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\x8a'}, 3, 0x798A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\x9d'}, 3, 0x799D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\xa7'}, 3, 0x79A7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\x8b'}, 3, 0x9F4B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\xaa'}, 3, 0x79AA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\xae'}, 3, 0x79AE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\xb3'}, 3, 0x79B3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\xb9'}, 3, 0x79B9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\xba'}, 3, 0x79BA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\x89'}, 3, 0x79C9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\x95'}, 3, 0x79D5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\xa7'}, 3, 0x79E7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\xac'}, 3, 0x79EC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\xa1'}, 3, 0x79E1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa7', '\xa3'}, 3, 0x79E3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\x88'}, 3, 0x7A08}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\x8d'}, 3, 0x7A0D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\x98'}, 3, 0x7A18}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\x99'}, 3, 0x7A19}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\xa0'}, 3, 0x7A20}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\x9f'}, 3, 0x7A1F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa6', '\x80'}, 3, 0x7980}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\xb1'}, 3, 0x7A31}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\xbb'}, 3, 0x7A3B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\xbe'}, 3, 0x7A3E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa8', '\xb7'}, 3, 0x7A37}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\x83'}, 3, 0x7A43}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\x97'}, 3, 0x7A57}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\x89'}, 3, 0x7A49}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\xa1'}, 3, 0x7A61}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\xa2'}, 3, 0x7A62}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\xa9'}, 3, 0x7A69}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbe', '\x9d'}, 3, 0x9F9D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\xb0'}, 3, 0x7A70}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\xb9'}, 3, 0x7A79}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa9', '\xbd'}, 3, 0x7A7D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\x88'}, 3, 0x7A88}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\x97'}, 3, 0x7A97}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\x95'}, 3, 0x7A95}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\x98'}, 3, 0x7A98}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\x96'}, 3, 0x7A96}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\xa9'}, 3, 0x7AA9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x88'}, 3, 0x7AC8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\xb0'}, 3, 0x7AB0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\xb6'}, 3, 0x7AB6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x85'}, 3, 0x7AC5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x84'}, 3, 0x7AC4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaa', '\xbf'}, 3, 0x7ABF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\x83'}, 3, 0x9083}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x87'}, 3, 0x7AC7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x8a'}, 3, 0x7ACA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x8d'}, 3, 0x7ACD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x8f'}, 3, 0x7ACF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x95'}, 3, 0x7AD5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x93'}, 3, 0x7AD3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x99'}, 3, 0x7AD9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x9a'}, 3, 0x7ADA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x9d'}, 3, 0x7ADD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xa1'}, 3, 0x7AE1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xa2'}, 3, 0x7AE2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xa6'}, 3, 0x7AE6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xad'}, 3, 0x7AED}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xb0'}, 3, 0x7AF0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\x82'}, 3, 0x7B02}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\x8f'}, 3, 0x7B0F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\x8a'}, 3, 0x7B0A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\x86'}, 3, 0x7B06}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\xb3'}, 3, 0x7B33}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\x98'}, 3, 0x7B18}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\x99'}, 3, 0x7B19}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\x9e'}, 3, 0x7B1E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\xb5'}, 3, 0x7B35}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\xa8'}, 3, 0x7B28}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\xb6'}, 3, 0x7B36}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\x90'}, 3, 0x7B50}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\xba'}, 3, 0x7B7A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\x84'}, 3, 0x7B04}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\x8d'}, 3, 0x7B4D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xac', '\x8b'}, 3, 0x7B0B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\x8c'}, 3, 0x7B4C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\x85'}, 3, 0x7B45}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\xb5'}, 3, 0x7B75}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\xa5'}, 3, 0x7B65}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\xb4'}, 3, 0x7B74}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\xa7'}, 3, 0x7B67}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\xb0'}, 3, 0x7B70}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\xb1'}, 3, 0x7B71}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\xac'}, 3, 0x7B6C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\xae'}, 3, 0x7B6E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x9d'}, 3, 0x7B9D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x98'}, 3, 0x7B98}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x9f'}, 3, 0x7B9F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x8d'}, 3, 0x7B8D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x9c'}, 3, 0x7B9C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x9a'}, 3, 0x7B9A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x8b'}, 3, 0x7B8B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x92'}, 3, 0x7B92}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x8f'}, 3, 0x7B8F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xad', '\x9d'}, 3, 0x7B5D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x99'}, 3, 0x7B99}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\x8b'}, 3, 0x7BCB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\x81'}, 3, 0x7BC1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\x8c'}, 3, 0x7BCC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\x8f'}, 3, 0x7BCF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\xb4'}, 3, 0x7BB4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\x86'}, 3, 0x7BC6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\x9d'}, 3, 0x7BDD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\xa9'}, 3, 0x7BE9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\x91'}, 3, 0x7C11}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\x94'}, 3, 0x7C14}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\xa6'}, 3, 0x7BE6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\xa5'}, 3, 0x7BE5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\xa0'}, 3, 0x7C60}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\x80'}, 3, 0x7C00}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\x87'}, 3, 0x7C07}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\x93'}, 3, 0x7C13}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\xb3'}, 3, 0x7BF3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\xb7'}, 3, 0x7BF7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\x97'}, 3, 0x7C17}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\x8d'}, 3, 0x7C0D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xaf', '\xb6'}, 3, 0x7BF6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\xa3'}, 3, 0x7C23}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\xa7'}, 3, 0x7C27}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\xaa'}, 3, 0x7C2A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\x9f'}, 3, 0x7C1F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\xb7'}, 3, 0x7C37}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\xab'}, 3, 0x7C2B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb0', '\xbd'}, 3, 0x7C3D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\x8c'}, 3, 0x7C4C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\x83'}, 3, 0x7C43}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\x94'}, 3, 0x7C54}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\x8f'}, 3, 0x7C4F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\x80'}, 3, 0x7C40}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\x90'}, 3, 0x7C50}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\x98'}, 3, 0x7C58}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\x9f'}, 3, 0x7C5F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\xa4'}, 3, 0x7C64}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\x96'}, 3, 0x7C56}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\xa5'}, 3, 0x7C65}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\xac'}, 3, 0x7C6C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb1', '\xb5'}, 3, 0x7C75}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\x83'}, 3, 0x7C83}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\x90'}, 3, 0x7C90}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\xa4'}, 3, 0x7CA4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\xad'}, 3, 0x7CAD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\xa2'}, 3, 0x7CA2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\xab'}, 3, 0x7CAB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\xa1'}, 3, 0x7CA1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\xa8'}, 3, 0x7CA8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\xb3'}, 3, 0x7CB3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\xb2'}, 3, 0x7CB2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\xb1'}, 3, 0x7CB1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\xae'}, 3, 0x7CAE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\xb9'}, 3, 0x7CB9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb2', '\xbd'}, 3, 0x7CBD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\x80'}, 3, 0x7CC0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\x85'}, 3, 0x7CC5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\x82'}, 3, 0x7CC2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\x98'}, 3, 0x7CD8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\x92'}, 3, 0x7CD2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\x9c'}, 3, 0x7CDC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\xa2'}, 3, 0x7CE2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\xbb'}, 3, 0x9B3B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\xaf'}, 3, 0x7CEF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\xb2'}, 3, 0x7CF2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\xb4'}, 3, 0x7CF4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\xb6'}, 3, 0x7CF6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb3', '\xba'}, 3, 0x7CFA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x86'}, 3, 0x7D06}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x82'}, 3, 0x7D02}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x9c'}, 3, 0x7D1C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x95'}, 3, 0x7D15}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\x8a'}, 3, 0x7D0A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\x85'}, 3, 0x7D45}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\x8b'}, 3, 0x7D4B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\xae'}, 3, 0x7D2E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\xb2'}, 3, 0x7D32}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\xbf'}, 3, 0x7D3F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb4', '\xb5'}, 3, 0x7D35}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\x86'}, 3, 0x7D46}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\xb3'}, 3, 0x7D73}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\x96'}, 3, 0x7D56}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\x8e'}, 3, 0x7D4E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\xb2'}, 3, 0x7D72}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\xa8'}, 3, 0x7D68}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\xae'}, 3, 0x7D6E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\x8f'}, 3, 0x7D4F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\xa3'}, 3, 0x7D63}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\x93'}, 3, 0x7D93}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\x89'}, 3, 0x7D89}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\x9b'}, 3, 0x7D5B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\x8f'}, 3, 0x7D8F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\xbd'}, 3, 0x7D7D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\x9b'}, 3, 0x7D9B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xba'}, 3, 0x7DBA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xae'}, 3, 0x7DAE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xa3'}, 3, 0x7DA3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xb5'}, 3, 0x7DB5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\x87'}, 3, 0x7DC7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xbd'}, 3, 0x7DBD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xab'}, 3, 0x7DAB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\xbd'}, 3, 0x7E3D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xa2'}, 3, 0x7DA2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xaf'}, 3, 0x7DAF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\x9c'}, 3, 0x7DDC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xb8'}, 3, 0x7DB8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\x9f'}, 3, 0x7D9F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xb0'}, 3, 0x7DB0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\x98'}, 3, 0x7DD8}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\x9d'}, 3, 0x7DDD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\xa4'}, 3, 0x7DE4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\x9e'}, 3, 0x7DDE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\xbb'}, 3, 0x7DFB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\xb2'}, 3, 0x7DF2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\xa1'}, 3, 0x7DE1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\x85'}, 3, 0x7E05}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\x8a'}, 3, 0x7E0A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\xa3'}, 3, 0x7E23}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\xa1'}, 3, 0x7E21}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\x92'}, 3, 0x7E12}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\xb1'}, 3, 0x7E31}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\x9f'}, 3, 0x7E1F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\x89'}, 3, 0x7E09}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\x8b'}, 3, 0x7E0B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\xa2'}, 3, 0x7E22}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\x86'}, 3, 0x7E46}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\xa6'}, 3, 0x7E66}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\xbb'}, 3, 0x7E3B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\xb5'}, 3, 0x7E35}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\xb9'}, 3, 0x7E39}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\x83'}, 3, 0x7E43}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\xb7'}, 3, 0x7E37}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\xb2'}, 3, 0x7E32}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb8', '\xba'}, 3, 0x7E3A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\xa7'}, 3, 0x7E67}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\x9d'}, 3, 0x7E5D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\x96'}, 3, 0x7E56}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\x9e'}, 3, 0x7E5E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\x99'}, 3, 0x7E59}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\x9a'}, 3, 0x7E5A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\xb9'}, 3, 0x7E79}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\xaa'}, 3, 0x7E6A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\xa9'}, 3, 0x7E69}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\xbc'}, 3, 0x7E7C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\xbb'}, 3, 0x7E7B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xba', '\x83'}, 3, 0x7E83}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\x95'}, 3, 0x7DD5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\xbd'}, 3, 0x7E7D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\xae'}, 3, 0x8FAE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\xbf'}, 3, 0x7E7F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xba', '\x88'}, 3, 0x7E88}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xba', '\x89'}, 3, 0x7E89}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xba', '\x8c'}, 3, 0x7E8C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xba', '\x92'}, 3, 0x7E92}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xba', '\x90'}, 3, 0x7E90}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xba', '\x93'}, 3, 0x7E93}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xba', '\x94'}, 3, 0x7E94}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xba', '\x96'}, 3, 0x7E96}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xba', '\x8e'}, 3, 0x7E8E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xba', '\x9b'}, 3, 0x7E9B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xba', '\x9c'}, 3, 0x7E9C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbc', '\xb8'}, 3, 0x7F38}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbc', '\xba'}, 3, 0x7F3A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\x85'}, 3, 0x7F45}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\x8c'}, 3, 0x7F4C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\x8d'}, 3, 0x7F4D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\x8e'}, 3, 0x7F4E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\x90'}, 3, 0x7F50}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\x91'}, 3, 0x7F51}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\x95'}, 3, 0x7F55}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\x94'}, 3, 0x7F54}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\x98'}, 3, 0x7F58}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\x9f'}, 3, 0x7F5F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\xa0'}, 3, 0x7F60}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\xa8'}, 3, 0x7F68}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\xa9'}, 3, 0x7F69}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\xa7'}, 3, 0x7F67}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\xb8'}, 3, 0x7F78}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\x82'}, 3, 0x7F82}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\x86'}, 3, 0x7F86}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\x83'}, 3, 0x7F83}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\x88'}, 3, 0x7F88}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\x87'}, 3, 0x7F87}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\x8c'}, 3, 0x7F8C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\x94'}, 3, 0x7F94}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\x9e'}, 3, 0x7F9E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\x9d'}, 3, 0x7F9D}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\x9a'}, 3, 0x7F9A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\xa3'}, 3, 0x7FA3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\xaf'}, 3, 0x7FAF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\xb2'}, 3, 0x7FB2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\xb9'}, 3, 0x7FB9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\xae'}, 3, 0x7FAE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\xb6'}, 3, 0x7FB6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\xb8'}, 3, 0x7FB8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\xb1'}, 3, 0x8B71}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\x85'}, 3, 0x7FC5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\x86'}, 3, 0x7FC6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\x8a'}, 3, 0x7FCA}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\x95'}, 3, 0x7FD5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\x94'}, 3, 0x7FD4}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\xa1'}, 3, 0x7FE1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\xa6'}, 3, 0x7FE6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\xa9'}, 3, 0x7FE9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\xb3'}, 3, 0x7FF3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbf', '\xb9'}, 3, 0x7FF9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\x9c'}, 3, 0x98DC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\x86'}, 3, 0x8006}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\x84'}, 3, 0x8004}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\x8b'}, 3, 0x800B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\x92'}, 3, 0x8012}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\x98'}, 3, 0x8018}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\x99'}, 3, 0x8019}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\x9c'}, 3, 0x801C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\xa1'}, 3, 0x8021}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\xa8'}, 3, 0x8028}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\xbf'}, 3, 0x803F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x80', '\xbb'}, 3, 0x803B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\x8a'}, 3, 0x804A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\x86'}, 3, 0x8046}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\x92'}, 3, 0x8052}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\x98'}, 3, 0x8058}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\x9a'}, 3, 0x805A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\x9f'}, 3, 0x805F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\xa2'}, 3, 0x8062}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\xa8'}, 3, 0x8068}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\xb3'}, 3, 0x8073}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\xb2'}, 3, 0x8072}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\xb0'}, 3, 0x8070}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\xb6'}, 3, 0x8076}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\xb9'}, 3, 0x8079}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\xbd'}, 3, 0x807D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x81', '\xbf'}, 3, 0x807F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\x84'}, 3, 0x8084}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\x86'}, 3, 0x8086}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\x85'}, 3, 0x8085}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\x9b'}, 3, 0x809B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\x93'}, 3, 0x8093}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\x9a'}, 3, 0x809A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\xad'}, 3, 0x80AD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x90'}, 3, 0x5190}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x82', '\xac'}, 3, 0x80AC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\x9b'}, 3, 0x80DB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\xa5'}, 3, 0x80E5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\x99'}, 3, 0x80D9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\x9d'}, 3, 0x80DD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\x84'}, 3, 0x80C4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\x9a'}, 3, 0x80DA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\x96'}, 3, 0x80D6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\x89'}, 3, 0x8109}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\xaf'}, 3, 0x80EF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\xb1'}, 3, 0x80F1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\x9b'}, 3, 0x811B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\xa9'}, 3, 0x8129}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\xa3'}, 3, 0x8123}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\xaf'}, 3, 0x812F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\x8b'}, 3, 0x814B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\x8b'}, 3, 0x968B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\x86'}, 3, 0x8146}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x84', '\xbe'}, 3, 0x813E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\x93'}, 3, 0x8153}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\x91'}, 3, 0x8151}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x83', '\xbc'}, 3, 0x80FC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\xb1'}, 3, 0x8171}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\xae'}, 3, 0x816E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\xa5'}, 3, 0x8165}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\xa6'}, 3, 0x8166}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\xb4'}, 3, 0x8174}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\x83'}, 3, 0x8183}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\x88'}, 3, 0x8188}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\x8a'}, 3, 0x818A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\x80'}, 3, 0x8180}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\x82'}, 3, 0x8182}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\xa0'}, 3, 0x81A0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\x95'}, 3, 0x8195}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\xa4'}, 3, 0x81A4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\xa3'}, 3, 0x81A3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x85', '\x9f'}, 3, 0x815F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\x93'}, 3, 0x8193}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\xa9'}, 3, 0x81A9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\xb0'}, 3, 0x81B0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\xb5'}, 3, 0x81B5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\xbe'}, 3, 0x81BE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\xb8'}, 3, 0x81B8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\xbd'}, 3, 0x81BD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\x80'}, 3, 0x81C0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\x82'}, 3, 0x81C2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x86', '\xba'}, 3, 0x81BA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\x89'}, 3, 0x81C9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\x8d'}, 3, 0x81CD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\x91'}, 3, 0x81D1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\x99'}, 3, 0x81D9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\x98'}, 3, 0x81D8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\x88'}, 3, 0x81C8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\x9a'}, 3, 0x81DA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\x9f'}, 3, 0x81DF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\xa0'}, 3, 0x81E0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\xa7'}, 3, 0x81E7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\xba'}, 3, 0x81FA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\xbb'}, 3, 0x81FB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x87', '\xbe'}, 3, 0x81FE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x81'}, 3, 0x8201}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x82'}, 3, 0x8202}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x85'}, 3, 0x8205}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x87'}, 3, 0x8207}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x8a'}, 3, 0x820A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x8d'}, 3, 0x820D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x90'}, 3, 0x8210}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\x96'}, 3, 0x8216}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\xa9'}, 3, 0x8229}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\xab'}, 3, 0x822B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\xb8'}, 3, 0x8238}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\xb3'}, 3, 0x8233}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\x80'}, 3, 0x8240}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\x99'}, 3, 0x8259}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\x98'}, 3, 0x8258}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\x9d'}, 3, 0x825D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\x9a'}, 3, 0x825A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\x9f'}, 3, 0x825F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\xa4'}, 3, 0x8264}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\xa2'}, 3, 0x8262}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\xa8'}, 3, 0x8268}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\xaa'}, 3, 0x826A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\xab'}, 3, 0x826B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x88', '\xae'}, 3, 0x822E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\xb1'}, 3, 0x8271}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\xb7'}, 3, 0x8277}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\xb8'}, 3, 0x8278}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x89', '\xbe'}, 3, 0x827E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\x8d'}, 3, 0x828D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\x92'}, 3, 0x8292}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\xab'}, 3, 0x82AB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\x9f'}, 3, 0x829F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\xbb'}, 3, 0x82BB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8a', '\xac'}, 3, 0x82AC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\xa1'}, 3, 0x82E1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\xa3'}, 3, 0x82E3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\x9f'}, 3, 0x82DF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\x92'}, 3, 0x82D2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\xb4'}, 3, 0x82F4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\xb3'}, 3, 0x82F3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\xba'}, 3, 0x82FA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\x93'}, 3, 0x8393}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\x83'}, 3, 0x8303}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\xbb'}, 3, 0x82FB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\xb9'}, 3, 0x82F9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\x9e'}, 3, 0x82DE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\x86'}, 3, 0x8306}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\x9c'}, 3, 0x82DC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\x89'}, 3, 0x8309}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8b', '\x99'}, 3, 0x82D9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\xb5'}, 3, 0x8335}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\xb4'}, 3, 0x8334}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\x96'}, 3, 0x8316}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\xb2'}, 3, 0x8332}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\xb1'}, 3, 0x8331}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\x80'}, 3, 0x8340}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\xb9'}, 3, 0x8339}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\x90'}, 3, 0x8350}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\x85'}, 3, 0x8345}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\xaf'}, 3, 0x832F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\xab'}, 3, 0x832B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\x97'}, 3, 0x8317}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\x98'}, 3, 0x8318}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\x85'}, 3, 0x8385}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\x9a'}, 3, 0x839A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\xaa'}, 3, 0x83AA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\x9f'}, 3, 0x839F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\xa2'}, 3, 0x83A2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\x96'}, 3, 0x8396}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8c', '\xa3'}, 3, 0x8323}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\x8e'}, 3, 0x838E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\x87'}, 3, 0x8387}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\x8a'}, 3, 0x838A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\xbc'}, 3, 0x837C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\xb5'}, 3, 0x83B5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\xb3'}, 3, 0x8373}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\xb5'}, 3, 0x8375}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\xa0'}, 3, 0x83A0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\x89'}, 3, 0x8389}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\xa8'}, 3, 0x83A8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\xb4'}, 3, 0x83F4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\x93'}, 3, 0x8413}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\xab'}, 3, 0x83EB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\x8e'}, 3, 0x83CE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\xbd'}, 3, 0x83FD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\x83'}, 3, 0x8403}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\x98'}, 3, 0x83D8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\x8b'}, 3, 0x840B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\x81'}, 3, 0x83C1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\xb7'}, 3, 0x83F7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\x87'}, 3, 0x8407}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\xa0'}, 3, 0x83E0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\xb2'}, 3, 0x83F2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\x8d'}, 3, 0x840D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\xa2'}, 3, 0x8422}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\xa0'}, 3, 0x8420}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8e', '\xbd'}, 3, 0x83BD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\xb8'}, 3, 0x8438}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x94', '\x86'}, 3, 0x8506}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\xbb'}, 3, 0x83FB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\xad'}, 3, 0x846D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\xaa'}, 3, 0x842A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\xbc'}, 3, 0x843C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\x9a'}, 3, 0x855A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\x84'}, 3, 0x8484}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\xb7'}, 3, 0x8477}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\xab'}, 3, 0x846B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\xad'}, 3, 0x84AD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\xae'}, 3, 0x846E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\x82'}, 3, 0x8482}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\xa9'}, 3, 0x8469}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\x86'}, 3, 0x8446}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\xac'}, 3, 0x842C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\xaf'}, 3, 0x846F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\xb9'}, 3, 0x8479}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x90', '\xb5'}, 3, 0x8435}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\x8a'}, 3, 0x84CA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\xa2'}, 3, 0x8462}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\xb9'}, 3, 0x84B9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\xbf'}, 3, 0x84BF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\x9f'}, 3, 0x849F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\x99'}, 3, 0x84D9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\x8d'}, 3, 0x84CD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\xbb'}, 3, 0x84BB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\x9a'}, 3, 0x84DA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\x90'}, 3, 0x84D0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\x81'}, 3, 0x84C1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\x86'}, 3, 0x84C6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\x96'}, 3, 0x84D6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\xa1'}, 3, 0x84A1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x94', '\xa1'}, 3, 0x8521}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\xbf'}, 3, 0x84FF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\xb4'}, 3, 0x84F4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x94', '\x97'}, 3, 0x8517}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x94', '\x98'}, 3, 0x8518}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x94', '\xac'}, 3, 0x852C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x94', '\x9f'}, 3, 0x851F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x94', '\x95'}, 3, 0x8515}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x94', '\x94'}, 3, 0x8514}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\xbc'}, 3, 0x84FC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\x80'}, 3, 0x8540}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\xa3'}, 3, 0x8563}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\x98'}, 3, 0x8558}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\x88'}, 3, 0x8548}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\x81'}, 3, 0x8541}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x98', '\x82'}, 3, 0x8602}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\x8b'}, 3, 0x854B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\x95'}, 3, 0x8555}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\x80'}, 3, 0x8580}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\xa4'}, 3, 0x85A4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\x88'}, 3, 0x8588}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\x91'}, 3, 0x8591}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\x8a'}, 3, 0x858A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\xa8'}, 3, 0x85A8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\xad'}, 3, 0x856D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\x94'}, 3, 0x8594}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\x9b'}, 3, 0x859B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\xaa'}, 3, 0x85EA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\x87'}, 3, 0x8587}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\x9c'}, 3, 0x859C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\xb7'}, 3, 0x8577}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\xbe'}, 3, 0x857E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\x90'}, 3, 0x8590}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\x89'}, 3, 0x85C9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\xba'}, 3, 0x85BA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\x8f'}, 3, 0x85CF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x96', '\xb9'}, 3, 0x85B9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\x90'}, 3, 0x85D0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\x95'}, 3, 0x85D5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\x9d'}, 3, 0x85DD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\xa5'}, 3, 0x85E5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\x9c'}, 3, 0x85DC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\xb9'}, 3, 0x85F9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x98', '\x8a'}, 3, 0x860A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x98', '\x93'}, 3, 0x8613}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x98', '\x8b'}, 3, 0x860B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\xbe'}, 3, 0x85FE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x97', '\xba'}, 3, 0x85FA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x98', '\x86'}, 3, 0x8606}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x98', '\xa2'}, 3, 0x8622}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x98', '\x9a'}, 3, 0x861A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x98', '\xb0'}, 3, 0x8630}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x98', '\xbf'}, 3, 0x863F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x99', '\x8d'}, 3, 0x864D}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb9', '\x95'}, 3, 0x4E55}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x99', '\x94'}, 3, 0x8654}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x99', '\x9f'}, 3, 0x865F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x99', '\xa7'}, 3, 0x8667}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x99', '\xb1'}, 3, 0x8671}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9a', '\x93'}, 3, 0x8693}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9a', '\xa3'}, 3, 0x86A3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9a', '\xa9'}, 3, 0x86A9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9a', '\xaa'}, 3, 0x86AA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9a', '\x8b'}, 3, 0x868B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9a', '\x8c'}, 3, 0x868C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9a', '\xb6'}, 3, 0x86B6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9a', '\xaf'}, 3, 0x86AF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\x84'}, 3, 0x86C4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\x86'}, 3, 0x86C6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9a', '\xb0'}, 3, 0x86B0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\x89'}, 3, 0x86C9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa0', '\xa3'}, 3, 0x8823}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9a', '\xab'}, 3, 0x86AB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\x94'}, 3, 0x86D4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\x9e'}, 3, 0x86DE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\xa9'}, 3, 0x86E9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\xac'}, 3, 0x86EC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\x9f'}, 3, 0x86DF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\x9b'}, 3, 0x86DB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\xaf'}, 3, 0x86EF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\x92'}, 3, 0x8712}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\x86'}, 3, 0x8706}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\x88'}, 3, 0x8708}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\x80'}, 3, 0x8700}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\x83'}, 3, 0x8703}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\xbb'}, 3, 0x86FB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\x91'}, 3, 0x8711}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\x89'}, 3, 0x8709}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\x8d'}, 3, 0x870D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9b', '\xb9'}, 3, 0x86F9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\x8a'}, 3, 0x870A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\xb4'}, 3, 0x8734}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\xbf'}, 3, 0x873F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\xb7'}, 3, 0x8737}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\xbb'}, 3, 0x873B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\xa5'}, 3, 0x8725}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\xa9'}, 3, 0x8729}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9c', '\x9a'}, 3, 0x871A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\xa0'}, 3, 0x8760}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\x9f'}, 3, 0x875F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\xb8'}, 3, 0x8778}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\x8c'}, 3, 0x874C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\x8e'}, 3, 0x874E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\xb4'}, 3, 0x8774}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\x97'}, 3, 0x8757}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\xa8'}, 3, 0x8768}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\xae'}, 3, 0x876E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\x99'}, 3, 0x8759}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\x93'}, 3, 0x8753}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\xa3'}, 3, 0x8763}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9d', '\xaa'}, 3, 0x876A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa0', '\x85'}, 3, 0x8805}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9e', '\xa2'}, 3, 0x87A2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9e', '\x9f'}, 3, 0x879F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9e', '\x82'}, 3, 0x8782}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9e', '\xaf'}, 3, 0x87AF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9f', '\x8b'}, 3, 0x87CB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9e', '\xbd'}, 3, 0x87BD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9f', '\x80'}, 3, 0x87C0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9f', '\x90'}, 3, 0x87D0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x96'}, 3, 0x96D6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9e', '\xab'}, 3, 0x87AB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9f', '\x84'}, 3, 0x87C4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9e', '\xb3'}, 3, 0x87B3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9f', '\x87'}, 3, 0x87C7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9f', '\x86'}, 3, 0x87C6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9e', '\xbb'}, 3, 0x87BB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9f', '\xaf'}, 3, 0x87EF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9f', '\xb2'}, 3, 0x87F2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9f', '\xa0'}, 3, 0x87E0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa0', '\x8f'}, 3, 0x880F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa0', '\x8d'}, 3, 0x880D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9f', '\xbe'}, 3, 0x87FE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9f', '\xb6'}, 3, 0x87F6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9f', '\xb7'}, 3, 0x87F7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa0', '\x8e'}, 3, 0x880E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x9f', '\x92'}, 3, 0x87D2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa0', '\x91'}, 3, 0x8811}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa0', '\x96'}, 3, 0x8816}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa0', '\x95'}, 3, 0x8815}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa0', '\xa2'}, 3, 0x8822}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa0', '\xa1'}, 3, 0x8821}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa0', '\xb1'}, 3, 0x8831}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa0', '\xb6'}, 3, 0x8836}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa0', '\xb9'}, 3, 0x8839}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa0', '\xa7'}, 3, 0x8827}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa0', '\xbb'}, 3, 0x883B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\x84'}, 3, 0x8844}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\x82'}, 3, 0x8842}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\x92'}, 3, 0x8852}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\x99'}, 3, 0x8859}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\x9e'}, 3, 0x885E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\xa2'}, 3, 0x8862}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\xab'}, 3, 0x886B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\x81'}, 3, 0x8881}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\xbe'}, 3, 0x887E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\x9e'}, 3, 0x889E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\xb5'}, 3, 0x8875}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\xbd'}, 3, 0x887D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\xb5'}, 3, 0x88B5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa1', '\xb2'}, 3, 0x8872}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\x82'}, 3, 0x8882}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\x97'}, 3, 0x8897}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\x92'}, 3, 0x8892}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\xae'}, 3, 0x88AE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\x99'}, 3, 0x8899}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\xa2'}, 3, 0x88A2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\x8d'}, 3, 0x888D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\xa4'}, 3, 0x88A4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\xb0'}, 3, 0x88B0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\xbf'}, 3, 0x88BF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa2', '\xb1'}, 3, 0x88B1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\x83'}, 3, 0x88C3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\x84'}, 3, 0x88C4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\x94'}, 3, 0x88D4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\x98'}, 3, 0x88D8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\x99'}, 3, 0x88D9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\x9d'}, 3, 0x88DD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\xb9'}, 3, 0x88F9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\x82'}, 3, 0x8902}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\xbc'}, 3, 0x88FC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\xb4'}, 3, 0x88F4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\xa8'}, 3, 0x88E8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\xb2'}, 3, 0x88F2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\x84'}, 3, 0x8904}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\x8c'}, 3, 0x890C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\x8a'}, 3, 0x890A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\x93'}, 3, 0x8913}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\x83'}, 3, 0x8943}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\x9e'}, 3, 0x891E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\xa5'}, 3, 0x8925}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\xaa'}, 3, 0x892A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\xab'}, 3, 0x892B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\x81'}, 3, 0x8941}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\x84'}, 3, 0x8944}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\xbb'}, 3, 0x893B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\xb6'}, 3, 0x8936}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\xb8'}, 3, 0x8938}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\x8c'}, 3, 0x894C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\x9d'}, 3, 0x891D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\xa0'}, 3, 0x8960}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\x9e'}, 3, 0x895E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\xa6'}, 3, 0x8966}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\xa4'}, 3, 0x8964}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\xad'}, 3, 0x896D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\xaa'}, 3, 0x896A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\xaf'}, 3, 0x896F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\xb4'}, 3, 0x8974}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\xb7'}, 3, 0x8977}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\xbe'}, 3, 0x897E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\x83'}, 3, 0x8983}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\x88'}, 3, 0x8988}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\x8a'}, 3, 0x898A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\x93'}, 3, 0x8993}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\x98'}, 3, 0x8998}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\xa1'}, 3, 0x89A1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\xa9'}, 3, 0x89A9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\xa6'}, 3, 0x89A6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\xac'}, 3, 0x89AC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\xaf'}, 3, 0x89AF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\xb2'}, 3, 0x89B2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\xba'}, 3, 0x89BA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\xbd'}, 3, 0x89BD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa6', '\xbf'}, 3, 0x89BF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa7', '\x80'}, 3, 0x89C0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa7', '\x9a'}, 3, 0x89DA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa7', '\x9c'}, 3, 0x89DC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa7', '\x9d'}, 3, 0x89DD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa7', '\xa7'}, 3, 0x89E7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa7', '\xb4'}, 3, 0x89F4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa7', '\xb8'}, 3, 0x89F8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x83'}, 3, 0x8A03}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x96'}, 3, 0x8A16}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x90'}, 3, 0x8A10}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x8c'}, 3, 0x8A0C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x9b'}, 3, 0x8A1B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x9d'}, 3, 0x8A1D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\xa5'}, 3, 0x8A25}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\xb6'}, 3, 0x8A36}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\x81'}, 3, 0x8A41}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\x9b'}, 3, 0x8A5B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\x92'}, 3, 0x8A52}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\x86'}, 3, 0x8A46}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\x88'}, 3, 0x8A48}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\xbc'}, 3, 0x8A7C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\xad'}, 3, 0x8A6D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\xac'}, 3, 0x8A6C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\xa2'}, 3, 0x8A62}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\x85'}, 3, 0x8A85}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\x82'}, 3, 0x8A82}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\x84'}, 3, 0x8A84}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xa8'}, 3, 0x8AA8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xa1'}, 3, 0x8AA1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\x91'}, 3, 0x8A91}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xa5'}, 3, 0x8AA5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xa6'}, 3, 0x8AA6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\x9a'}, 3, 0x8A9A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xa3'}, 3, 0x8AA3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\x84'}, 3, 0x8AC4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\x8d'}, 3, 0x8ACD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\x82'}, 3, 0x8AC2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\x9a'}, 3, 0x8ADA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\xab'}, 3, 0x8AEB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\xb3'}, 3, 0x8AF3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\xa7'}, 3, 0x8AE7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\xa4'}, 3, 0x8AE4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\xb1'}, 3, 0x8AF1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\x94'}, 3, 0x8B14}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\xa0'}, 3, 0x8AE0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\xa2'}, 3, 0x8AE2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\xb7'}, 3, 0x8AF7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\x9e'}, 3, 0x8ADE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\x9b'}, 3, 0x8ADB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\x8c'}, 3, 0x8B0C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\x87'}, 3, 0x8B07}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\x9a'}, 3, 0x8B1A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\xa1'}, 3, 0x8AE1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\x96'}, 3, 0x8B16}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\x90'}, 3, 0x8B10}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\x97'}, 3, 0x8B17}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\xa0'}, 3, 0x8B20}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\xb3'}, 3, 0x8B33}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\xab'}, 3, 0x97AB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\xa6'}, 3, 0x8B26}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\xab'}, 3, 0x8B2B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\xbe'}, 3, 0x8B3E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xac', '\xa8'}, 3, 0x8B28}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\x81'}, 3, 0x8B41}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\x8c'}, 3, 0x8B4C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\x8f'}, 3, 0x8B4F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\x8e'}, 3, 0x8B4E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\x89'}, 3, 0x8B49}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\x96'}, 3, 0x8B56}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\x9b'}, 3, 0x8B5B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\x9a'}, 3, 0x8B5A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\xab'}, 3, 0x8B6B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\x9f'}, 3, 0x8B5F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\xac'}, 3, 0x8B6C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\xaf'}, 3, 0x8B6F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\xb4'}, 3, 0x8B74}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\xbd'}, 3, 0x8B7D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xae', '\x80'}, 3, 0x8B80}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xae', '\x8c'}, 3, 0x8B8C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xae', '\x8e'}, 3, 0x8B8E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xae', '\x92'}, 3, 0x8B92}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xae', '\x93'}, 3, 0x8B93}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xae', '\x96'}, 3, 0x8B96}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xae', '\x99'}, 3, 0x8B99}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xae', '\x9a'}, 3, 0x8B9A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb0', '\xba'}, 3, 0x8C3A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\x81'}, 3, 0x8C41}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb0', '\xbf'}, 3, 0x8C3F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\x88'}, 3, 0x8C48}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\x8c'}, 3, 0x8C4C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\x8e'}, 3, 0x8C4E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\x90'}, 3, 0x8C50}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\x95'}, 3, 0x8C55}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\xa2'}, 3, 0x8C62}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\xac'}, 3, 0x8C6C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\xb8'}, 3, 0x8C78}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\xba'}, 3, 0x8C7A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\x82'}, 3, 0x8C82}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\x89'}, 3, 0x8C89}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\x85'}, 3, 0x8C85}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\x8a'}, 3, 0x8C8A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\x8d'}, 3, 0x8C8D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\x8e'}, 3, 0x8C8E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\x94'}, 3, 0x8C94}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb1', '\xbc'}, 3, 0x8C7C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\x98'}, 3, 0x8C98}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x9d'}, 3, 0x621D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xad'}, 3, 0x8CAD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xaa'}, 3, 0x8CAA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xbd'}, 3, 0x8CBD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xb2'}, 3, 0x8CB2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xb3'}, 3, 0x8CB3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xae'}, 3, 0x8CAE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb2', '\xb6'}, 3, 0x8CB6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x88'}, 3, 0x8CC8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x81'}, 3, 0x8CC1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\xa4'}, 3, 0x8CE4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\xa3'}, 3, 0x8CE3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x9a'}, 3, 0x8CDA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\xbd'}, 3, 0x8CFD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\xba'}, 3, 0x8CFA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\xbb'}, 3, 0x8CFB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb4', '\x84'}, 3, 0x8D04}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb4', '\x85'}, 3, 0x8D05}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb4', '\x8a'}, 3, 0x8D0A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb4', '\x87'}, 3, 0x8D07}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb4', '\x8f'}, 3, 0x8D0F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb4', '\x8d'}, 3, 0x8D0D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb4', '\x90'}, 3, 0x8D10}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\x8e'}, 3, 0x9F4E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb4', '\x93'}, 3, 0x8D13}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\x8d'}, 3, 0x8CCD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb4', '\x94'}, 3, 0x8D14}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb4', '\x96'}, 3, 0x8D16}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb5', '\xa7'}, 3, 0x8D67}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb5', '\xad'}, 3, 0x8D6D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb5', '\xb1'}, 3, 0x8D71}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb5', '\xb3'}, 3, 0x8D73}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb6', '\x81'}, 3, 0x8D81}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb6', '\x99'}, 3, 0x8D99}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\x82'}, 3, 0x8DC2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb6', '\xbe'}, 3, 0x8DBE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb6', '\xba'}, 3, 0x8DBA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\x8f'}, 3, 0x8DCF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\x9a'}, 3, 0x8DDA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\x96'}, 3, 0x8DD6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\x8c'}, 3, 0x8DCC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\x9b'}, 3, 0x8DDB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\x8b'}, 3, 0x8DCB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\xaa'}, 3, 0x8DEA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\xab'}, 3, 0x8DEB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\x9f'}, 3, 0x8DDF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\xa3'}, 3, 0x8DE3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\xbc'}, 3, 0x8DFC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb8', '\x88'}, 3, 0x8E08}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb8', '\x89'}, 3, 0x8E09}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb7', '\xbf'}, 3, 0x8DFF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb8', '\x9d'}, 3, 0x8E1D}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb8', '\x9e'}, 3, 0x8E1E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb8', '\x90'}, 3, 0x8E10}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb8', '\x9f'}, 3, 0x8E1F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\x82'}, 3, 0x8E42}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb8', '\xb5'}, 3, 0x8E35}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb8', '\xb0'}, 3, 0x8E30}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb8', '\xb4'}, 3, 0x8E34}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\x8a'}, 3, 0x8E4A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\x87'}, 3, 0x8E47}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\x89'}, 3, 0x8E49}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\x8c'}, 3, 0x8E4C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\x90'}, 3, 0x8E50}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\x88'}, 3, 0x8E48}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\x99'}, 3, 0x8E59}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\xa4'}, 3, 0x8E64}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\xa0'}, 3, 0x8E60}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb8', '\xaa'}, 3, 0x8E2A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\xa3'}, 3, 0x8E63}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\x95'}, 3, 0x8E55}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\xb6'}, 3, 0x8E76}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\xb2'}, 3, 0x8E72}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb9', '\xbc'}, 3, 0x8E7C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\x81'}, 3, 0x8E81}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\x87'}, 3, 0x8E87}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\x85'}, 3, 0x8E85}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\x84'}, 3, 0x8E84}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\x8b'}, 3, 0x8E8B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\x8a'}, 3, 0x8E8A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\x93'}, 3, 0x8E93}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\x91'}, 3, 0x8E91}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\x94'}, 3, 0x8E94}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\x99'}, 3, 0x8E99}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\xaa'}, 3, 0x8EAA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\xa1'}, 3, 0x8EA1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\xac'}, 3, 0x8EAC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\xb0'}, 3, 0x8EB0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\x86'}, 3, 0x8EC6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\xb1'}, 3, 0x8EB1}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xba', '\xbe'}, 3, 0x8EBE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\x85'}, 3, 0x8EC5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\x88'}, 3, 0x8EC8}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\x8b'}, 3, 0x8ECB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\x9b'}, 3, 0x8EDB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\xa3'}, 3, 0x8EE3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\xbc'}, 3, 0x8EFC}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\xbb'}, 3, 0x8EFB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\xab'}, 3, 0x8EEB}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbb', '\xbe'}, 3, 0x8EFE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\x8a'}, 3, 0x8F0A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\x85'}, 3, 0x8F05}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\x95'}, 3, 0x8F15}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\x92'}, 3, 0x8F12}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\x99'}, 3, 0x8F19}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\x93'}, 3, 0x8F13}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\x9c'}, 3, 0x8F1C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\x9f'}, 3, 0x8F1F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\x9b'}, 3, 0x8F1B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\x8c'}, 3, 0x8F0C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\xa6'}, 3, 0x8F26}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\xb3'}, 3, 0x8F33}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\xbb'}, 3, 0x8F3B}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\xb9'}, 3, 0x8F39}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbd', '\x85'}, 3, 0x8F45}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbd', '\x82'}, 3, 0x8F42}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbc', '\xbe'}, 3, 0x8F3E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbd', '\x8c'}, 3, 0x8F4C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbd', '\x89'}, 3, 0x8F49}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbd', '\x86'}, 3, 0x8F46}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbd', '\x8e'}, 3, 0x8F4E}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbd', '\x97'}, 3, 0x8F57}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbd', '\x9c'}, 3, 0x8F5C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbd', '\xa2'}, 3, 0x8F62}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbd', '\xa3'}, 3, 0x8F63}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbd', '\xa4'}, 3, 0x8F64}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\x9c'}, 3, 0x8F9C}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\x9f'}, 3, 0x8F9F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\xa3'}, 3, 0x8FA3}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\xad'}, 3, 0x8FAD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\xaf'}, 3, 0x8FAF}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbe', '\xb7'}, 3, 0x8FB7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\x9a'}, 3, 0x8FDA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\xa5'}, 3, 0x8FE5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\xa2'}, 3, 0x8FE2}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\xaa'}, 3, 0x8FEA}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\xaf'}, 3, 0x8FEF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\x87'}, 3, 0x9087}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\xb4'}, 3, 0x8FF4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x85'}, 3, 0x9005}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\xb9'}, 3, 0x8FF9}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\xba'}, 3, 0x8FFA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x91'}, 3, 0x9011}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x95'}, 3, 0x9015}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\xa1'}, 3, 0x9021}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x8d'}, 3, 0x900D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x9e'}, 3, 0x901E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x96'}, 3, 0x9016}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x8b'}, 3, 0x900B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\xa7'}, 3, 0x9027}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\xb6'}, 3, 0x9036}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\xb5'}, 3, 0x9035}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\xb9'}, 3, 0x9039}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xbf', '\xb8'}, 3, 0x8FF8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x8f'}, 3, 0x904F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x90'}, 3, 0x9050}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x91'}, 3, 0x9051}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x92'}, 3, 0x9052}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\x8e'}, 3, 0x900E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x89'}, 3, 0x9049}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x80', '\xbe'}, 3, 0x903E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x96'}, 3, 0x9056}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x98'}, 3, 0x9058}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x9e'}, 3, 0x905E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xa8'}, 3, 0x9068}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xaf'}, 3, 0x906F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xb6'}, 3, 0x9076}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xa8'}, 3, 0x96A8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xb2'}, 3, 0x9072}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\x82'}, 3, 0x9082}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\xbd'}, 3, 0x907D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\x81'}, 3, 0x9081}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\x80'}, 3, 0x9080}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\x8a'}, 3, 0x908A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\x89'}, 3, 0x9089}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\x8f'}, 3, 0x908F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\xa8'}, 3, 0x90A8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\xaf'}, 3, 0x90AF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\xb1'}, 3, 0x90B1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x82', '\xb5'}, 3, 0x90B5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x83', '\xa2'}, 3, 0x90E2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x83', '\xa4'}, 3, 0x90E4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x89', '\x88'}, 3, 0x6248}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x83', '\x9b'}, 3, 0x90DB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x84', '\x82'}, 3, 0x9102}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x84', '\x92'}, 3, 0x9112}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x84', '\x99'}, 3, 0x9119}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x84', '\xb2'}, 3, 0x9132}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x84', '\xb0'}, 3, 0x9130}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\x8a'}, 3, 0x914A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\x96'}, 3, 0x9156}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\x98'}, 3, 0x9158}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\xa3'}, 3, 0x9163}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\xa5'}, 3, 0x9165}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\xa9'}, 3, 0x9169}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\xb3'}, 3, 0x9173}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x85', '\xb2'}, 3, 0x9172}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\x8b'}, 3, 0x918B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\x89'}, 3, 0x9189}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\x82'}, 3, 0x9182}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\xa2'}, 3, 0x91A2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\xab'}, 3, 0x91AB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\xaf'}, 3, 0x91AF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\xaa'}, 3, 0x91AA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\xb5'}, 3, 0x91B5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\xb4'}, 3, 0x91B4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x86', '\xba'}, 3, 0x91BA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x80'}, 3, 0x91C0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x81'}, 3, 0x91C1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x89'}, 3, 0x91C9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x8b'}, 3, 0x91CB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x90'}, 3, 0x91D0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x96'}, 3, 0x91D6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x9f'}, 3, 0x91DF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\xa1'}, 3, 0x91E1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x9b'}, 3, 0x91DB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\xbc'}, 3, 0x91FC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\xb5'}, 3, 0x91F5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\xb6'}, 3, 0x91F6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\x9e'}, 3, 0x921E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\xbf'}, 3, 0x91FF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\x94'}, 3, 0x9214}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\xac'}, 3, 0x922C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\x95'}, 3, 0x9215}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\x91'}, 3, 0x9211}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x9e'}, 3, 0x925E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x97'}, 3, 0x9257}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x85'}, 3, 0x9245}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x89'}, 3, 0x9249}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\xa4'}, 3, 0x9264}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x88'}, 3, 0x9248}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\x95'}, 3, 0x9295}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\xbf'}, 3, 0x923F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x8b'}, 3, 0x924B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x90'}, 3, 0x9250}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\x9c'}, 3, 0x929C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\x96'}, 3, 0x9296}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\x93'}, 3, 0x9293}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\x9b'}, 3, 0x929B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x9a'}, 3, 0x925A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\x8f'}, 3, 0x92CF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\xb9'}, 3, 0x92B9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\xb7'}, 3, 0x92B7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xa9'}, 3, 0x92E9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\x8f'}, 3, 0x930F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xba'}, 3, 0x92FA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\x84'}, 3, 0x9344}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xae'}, 3, 0x932E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\x99'}, 3, 0x9319}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xa2'}, 3, 0x9322}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\x9a'}, 3, 0x931A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xa3'}, 3, 0x9323}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xba'}, 3, 0x933A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xb5'}, 3, 0x9335}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xbb'}, 3, 0x933B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\x9c'}, 3, 0x935C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\xa0'}, 3, 0x9360}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\xbc'}, 3, 0x937C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\xae'}, 3, 0x936E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\x96'}, 3, 0x9356}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8e', '\xb0'}, 3, 0x93B0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8e', '\xac'}, 3, 0x93AC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8e', '\xad'}, 3, 0x93AD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8e', '\x94'}, 3, 0x9394}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8e', '\xb9'}, 3, 0x93B9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\x96'}, 3, 0x93D6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\x97'}, 3, 0x93D7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\xa8'}, 3, 0x93E8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\xa5'}, 3, 0x93E5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\x98'}, 3, 0x93D8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\x83'}, 3, 0x93C3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\x9d'}, 3, 0x93DD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\x90'}, 3, 0x93D0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\x88'}, 3, 0x93C8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\xa4'}, 3, 0x93E4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x90', '\x9a'}, 3, 0x941A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x90', '\x94'}, 3, 0x9414}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x90', '\x93'}, 3, 0x9413}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x90', '\x83'}, 3, 0x9403}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x90', '\x87'}, 3, 0x9407}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x90', '\x90'}, 3, 0x9410}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x90', '\xb6'}, 3, 0x9436}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x90', '\xab'}, 3, 0x942B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x90', '\xb5'}, 3, 0x9435}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x90', '\xa1'}, 3, 0x9421}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x90', '\xba'}, 3, 0x943A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\x81'}, 3, 0x9441}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\x92'}, 3, 0x9452}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\x84'}, 3, 0x9444}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\x9b'}, 3, 0x945B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\xa0'}, 3, 0x9460}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\xa2'}, 3, 0x9462}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\x9e'}, 3, 0x945E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\xaa'}, 3, 0x946A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\xa9'}, 3, 0x9229}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\xb0'}, 3, 0x9470}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\xb5'}, 3, 0x9475}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\xb7'}, 3, 0x9477}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\xbd'}, 3, 0x947D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\x9a'}, 3, 0x945A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\xbc'}, 3, 0x947C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\xbe'}, 3, 0x947E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x92', '\x81'}, 3, 0x9481}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\xbf'}, 3, 0x947F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\x82'}, 3, 0x9582}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\x87'}, 3, 0x9587}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\x8a'}, 3, 0x958A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\x94'}, 3, 0x9594}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\x96'}, 3, 0x9596}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\x98'}, 3, 0x9598}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\x99'}, 3, 0x9599}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\xa0'}, 3, 0x95A0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\xa8'}, 3, 0x95A8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\xa7'}, 3, 0x95A7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\xad'}, 3, 0x95AD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\xbc'}, 3, 0x95BC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\xbb'}, 3, 0x95BB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\xb9'}, 3, 0x95B9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\xbe'}, 3, 0x95BE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x97', '\x8a'}, 3, 0x95CA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\xb6'}, 3, 0x6FF6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x97', '\x83'}, 3, 0x95C3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x97', '\x8d'}, 3, 0x95CD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x97', '\x8c'}, 3, 0x95CC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x97', '\x95'}, 3, 0x95D5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x97', '\x94'}, 3, 0x95D4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x97', '\x96'}, 3, 0x95D6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x97', '\x9c'}, 3, 0x95DC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x97', '\xa1'}, 3, 0x95E1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x97', '\xa5'}, 3, 0x95E5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x97', '\xa2'}, 3, 0x95E2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x98', '\xa1'}, 3, 0x9621}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x98', '\xa8'}, 3, 0x9628}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x98', '\xae'}, 3, 0x962E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x98', '\xaf'}, 3, 0x962F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\x82'}, 3, 0x9642}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\x8c'}, 3, 0x964C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\x8f'}, 3, 0x964F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\x8b'}, 3, 0x964B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\xb7'}, 3, 0x9677}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\x9c'}, 3, 0x965C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\x9e'}, 3, 0x965E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\x9d'}, 3, 0x965D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\x9f'}, 3, 0x965F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\xa6'}, 3, 0x9666}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\xb2'}, 3, 0x9672}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x99', '\xac'}, 3, 0x966C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\x8d'}, 3, 0x968D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\x98'}, 3, 0x9698}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\x95'}, 3, 0x9695}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\x97'}, 3, 0x9697}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xaa'}, 3, 0x96AA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xa7'}, 3, 0x96A7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xb1'}, 3, 0x96B1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xb2'}, 3, 0x96B2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xb0'}, 3, 0x96B0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xb4'}, 3, 0x96B4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xb6'}, 3, 0x96B6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xb8'}, 3, 0x96B8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xb9'}, 3, 0x96B9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x8e'}, 3, 0x96CE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x8b'}, 3, 0x96CB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x89'}, 3, 0x96C9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x8d'}, 3, 0x96CD}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa5', '\x8d'}, 3, 0x894D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x9c'}, 3, 0x96DC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\x8d'}, 3, 0x970D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\x95'}, 3, 0x96D5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9b', '\xb9'}, 3, 0x96F9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\x84'}, 3, 0x9704}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\x86'}, 3, 0x9706}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\x88'}, 3, 0x9708}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\x93'}, 3, 0x9713}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\x8e'}, 3, 0x970E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\x91'}, 3, 0x9711}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\x8f'}, 3, 0x970F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\x96'}, 3, 0x9716}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\x99'}, 3, 0x9719}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\xa4'}, 3, 0x9724}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\xaa'}, 3, 0x972A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\xb0'}, 3, 0x9730}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\xb9'}, 3, 0x9739}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\xbd'}, 3, 0x973D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\xbe'}, 3, 0x973E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x84'}, 3, 0x9744}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x86'}, 3, 0x9746}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x88'}, 3, 0x9748}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x82'}, 3, 0x9742}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x89'}, 3, 0x9749}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x9c'}, 3, 0x975C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\xa0'}, 3, 0x9760}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\xa4'}, 3, 0x9764}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\xa6'}, 3, 0x9766}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\xa8'}, 3, 0x9768}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x92'}, 3, 0x52D2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\xab'}, 3, 0x976B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\xb1'}, 3, 0x9771}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\xb9'}, 3, 0x9779}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\x85'}, 3, 0x9785}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\xbc'}, 3, 0x977C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\x81'}, 3, 0x9781}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\xba'}, 3, 0x977A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\x86'}, 3, 0x9786}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\x8b'}, 3, 0x978B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\x8f'}, 3, 0x978F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\x90'}, 3, 0x9790}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\x9c'}, 3, 0x979C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\xa8'}, 3, 0x97A8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\xa6'}, 3, 0x97A6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\xa3'}, 3, 0x97A3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\xb3'}, 3, 0x97B3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9e', '\xb4'}, 3, 0x97B4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9f', '\x83'}, 3, 0x97C3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9f', '\x86'}, 3, 0x97C6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9f', '\x88'}, 3, 0x97C8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9f', '\x8b'}, 3, 0x97CB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9f', '\x9c'}, 3, 0x97DC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9f', '\xad'}, 3, 0x97ED}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\x8f'}, 3, 0x9F4F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9f', '\xb2'}, 3, 0x97F2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x9f'}, 3, 0x7ADF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9f', '\xb6'}, 3, 0x97F6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9f', '\xb5'}, 3, 0x97F5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\x8f'}, 3, 0x980F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\x8c'}, 3, 0x980C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\xb8'}, 3, 0x9838}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\xa4'}, 3, 0x9824}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\xa1'}, 3, 0x9821}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\xb7'}, 3, 0x9837}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa0', '\xbd'}, 3, 0x983D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\x86'}, 3, 0x9846}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\x8f'}, 3, 0x984F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\x8b'}, 3, 0x984B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\xab'}, 3, 0x986B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\xaf'}, 3, 0x986F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\xb0'}, 3, 0x9870}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\xb1'}, 3, 0x9871}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\xb4'}, 3, 0x9874}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\xb3'}, 3, 0x9873}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa2', '\xaa'}, 3, 0x98AA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa2', '\xaf'}, 3, 0x98AF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa2', '\xb1'}, 3, 0x98B1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa2', '\xb6'}, 3, 0x98B6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\x84'}, 3, 0x98C4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\x83'}, 3, 0x98C3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\x86'}, 3, 0x98C6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\xa9'}, 3, 0x98E9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa3', '\xab'}, 3, 0x98EB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\x83'}, 3, 0x9903}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\x89'}, 3, 0x9909}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\x92'}, 3, 0x9912}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\x94'}, 3, 0x9914}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\x98'}, 3, 0x9918}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\xa1'}, 3, 0x9921}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\x9d'}, 3, 0x991D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\x9e'}, 3, 0x991E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\xa4'}, 3, 0x9924}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\xa0'}, 3, 0x9920}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\xac'}, 3, 0x992C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\xae'}, 3, 0x992E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\xbd'}, 3, 0x993D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa4', '\xbe'}, 3, 0x993E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa5', '\x82'}, 3, 0x9942}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa5', '\x89'}, 3, 0x9949}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa5', '\x85'}, 3, 0x9945}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa5', '\x90'}, 3, 0x9950}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa5', '\x8b'}, 3, 0x994B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa5', '\x91'}, 3, 0x9951}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa5', '\x92'}, 3, 0x9952}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa5', '\x8c'}, 3, 0x994C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa5', '\x95'}, 3, 0x9955}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa6', '\x97'}, 3, 0x9997}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa6', '\x98'}, 3, 0x9998}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa6', '\xa5'}, 3, 0x99A5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa6', '\xad'}, 3, 0x99AD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa6', '\xae'}, 3, 0x99AE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa6', '\xbc'}, 3, 0x99BC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\x9f'}, 3, 0x99DF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\x9b'}, 3, 0x99DB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\x9d'}, 3, 0x99DD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\x98'}, 3, 0x99D8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\x91'}, 3, 0x99D1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\xad'}, 3, 0x99ED}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\xae'}, 3, 0x99EE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\xb1'}, 3, 0x99F1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\xb2'}, 3, 0x99F2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\xbb'}, 3, 0x99FB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\xb8'}, 3, 0x99F8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa8', '\x81'}, 3, 0x9A01}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa8', '\x8f'}, 3, 0x9A0F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa8', '\x85'}, 3, 0x9A05}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa7', '\xa2'}, 3, 0x99E2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa8', '\x99'}, 3, 0x9A19}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa8', '\xab'}, 3, 0x9A2B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa8', '\xb7'}, 3, 0x9A37}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\x85'}, 3, 0x9A45}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\x82'}, 3, 0x9A42}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\x80'}, 3, 0x9A40}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\x83'}, 3, 0x9A43}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa8', '\xbe'}, 3, 0x9A3E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\x95'}, 3, 0x9A55}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\x8d'}, 3, 0x9A4D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\x9b'}, 3, 0x9A5B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\x97'}, 3, 0x9A57}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\x9f'}, 3, 0x9A5F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\xa2'}, 3, 0x9A62}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\xa5'}, 3, 0x9A65}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\xa4'}, 3, 0x9A64}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\xa9'}, 3, 0x9A69}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\xab'}, 3, 0x9A6B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\xaa'}, 3, 0x9A6A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaa', '\xad'}, 3, 0x9AAD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaa', '\xb0'}, 3, 0x9AB0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaa', '\xbc'}, 3, 0x9ABC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\x80'}, 3, 0x9AC0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\x8f'}, 3, 0x9ACF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\x91'}, 3, 0x9AD1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\x93'}, 3, 0x9AD3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\x94'}, 3, 0x9AD4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\x9e'}, 3, 0x9ADE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\x9f'}, 3, 0x9ADF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\xa2'}, 3, 0x9AE2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\xa3'}, 3, 0x9AE3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\xa6'}, 3, 0x9AE6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\xaf'}, 3, 0x9AEF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\xab'}, 3, 0x9AEB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\xae'}, 3, 0x9AEE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\xb4'}, 3, 0x9AF4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\xb1'}, 3, 0x9AF1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\xb7'}, 3, 0x9AF7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\xbb'}, 3, 0x9AFB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\x86'}, 3, 0x9B06}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\x98'}, 3, 0x9B18}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\x9a'}, 3, 0x9B1A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\x9f'}, 3, 0x9B1F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\xa2'}, 3, 0x9B22}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\xa3'}, 3, 0x9B23}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\xa5'}, 3, 0x9B25}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\xa7'}, 3, 0x9B27}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\xa8'}, 3, 0x9B28}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\xa9'}, 3, 0x9B29}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\xaa'}, 3, 0x9B2A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\xae'}, 3, 0x9B2E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\xaf'}, 3, 0x9B2F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xac', '\xb2'}, 3, 0x9B32}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\x84'}, 3, 0x9B44}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\x83'}, 3, 0x9B43}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\x8f'}, 3, 0x9B4F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\x8d'}, 3, 0x9B4D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\x8e'}, 3, 0x9B4E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\x91'}, 3, 0x9B51}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\x98'}, 3, 0x9B58}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\xb4'}, 3, 0x9B74}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\x93'}, 3, 0x9B93}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\x83'}, 3, 0x9B83}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\x91'}, 3, 0x9B91}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\x96'}, 3, 0x9B96}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\x97'}, 3, 0x9B97}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\x9f'}, 3, 0x9B9F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\xa0'}, 3, 0x9BA0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\xa8'}, 3, 0x9BA8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\xb4'}, 3, 0x9BB4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\x80'}, 3, 0x9BC0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\x8a'}, 3, 0x9BCA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\xb9'}, 3, 0x9BB9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\x86'}, 3, 0x9BC6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\x8f'}, 3, 0x9BCF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\x91'}, 3, 0x9BD1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\x92'}, 3, 0x9BD2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\xa3'}, 3, 0x9BE3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\xa2'}, 3, 0x9BE2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\xa4'}, 3, 0x9BE4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\x94'}, 3, 0x9BD4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\xa1'}, 3, 0x9BE1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\xba'}, 3, 0x9C3A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\xb2'}, 3, 0x9BF2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\xb1'}, 3, 0x9BF1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xaf', '\xb0'}, 3, 0x9BF0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\x95'}, 3, 0x9C15}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\x94'}, 3, 0x9C14}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\x89'}, 3, 0x9C09}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\x93'}, 3, 0x9C13}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\x8c'}, 3, 0x9C0C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\x86'}, 3, 0x9C06}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\x88'}, 3, 0x9C08}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\x92'}, 3, 0x9C12}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\x8a'}, 3, 0x9C0A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\x84'}, 3, 0x9C04}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\xae'}, 3, 0x9C2E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\x9b'}, 3, 0x9C1B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\xa5'}, 3, 0x9C25}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\xa4'}, 3, 0x9C24}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\xa1'}, 3, 0x9C21}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\xb0'}, 3, 0x9C30}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb1', '\x87'}, 3, 0x9C47}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\xb2'}, 3, 0x9C32}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb1', '\x86'}, 3, 0x9C46}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\xbe'}, 3, 0x9C3E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb1', '\x9a'}, 3, 0x9C5A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb1', '\xa0'}, 3, 0x9C60}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb1', '\xa7'}, 3, 0x9C67}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb1', '\xb6'}, 3, 0x9C76}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb1', '\xb8'}, 3, 0x9C78}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb3', '\xa7'}, 3, 0x9CE7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb3', '\xac'}, 3, 0x9CEC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb3', '\xb0'}, 3, 0x9CF0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\x89'}, 3, 0x9D09}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\x88'}, 3, 0x9D08}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb3', '\xab'}, 3, 0x9CEB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\x83'}, 3, 0x9D03}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\x86'}, 3, 0x9D06}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\xaa'}, 3, 0x9D2A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\xa6'}, 3, 0x9D26}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb6', '\xaf'}, 3, 0x9DAF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\xa3'}, 3, 0x9D23}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\x9f'}, 3, 0x9D1F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\x84'}, 3, 0x9D44}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\x95'}, 3, 0x9D15}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\x92'}, 3, 0x9D12}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\x81'}, 3, 0x9D41}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\xbf'}, 3, 0x9D3F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb4', '\xbe'}, 3, 0x9D3E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\x86'}, 3, 0x9D46}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\x88'}, 3, 0x9D48}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\x9d'}, 3, 0x9D5D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\x9e'}, 3, 0x9D5E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\xa4'}, 3, 0x9D64}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\x91'}, 3, 0x9D51}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\x90'}, 3, 0x9D50}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\x99'}, 3, 0x9D59}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\xb2'}, 3, 0x9D72}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb6', '\x89'}, 3, 0x9D89}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb6', '\x87'}, 3, 0x9D87}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb6', '\xab'}, 3, 0x9DAB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\xaf'}, 3, 0x9D6F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\xba'}, 3, 0x9D7A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb6', '\x9a'}, 3, 0x9D9A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb6', '\xa4'}, 3, 0x9DA4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb6', '\xa9'}, 3, 0x9DA9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb6', '\xb2'}, 3, 0x9DB2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb7', '\x84'}, 3, 0x9DC4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb7', '\x81'}, 3, 0x9DC1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb6', '\xbb'}, 3, 0x9DBB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb6', '\xb8'}, 3, 0x9DB8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb6', '\xba'}, 3, 0x9DBA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb7', '\x86'}, 3, 0x9DC6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb7', '\x8f'}, 3, 0x9DCF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb7', '\x82'}, 3, 0x9DC2}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb7', '\x99'}, 3, 0x9DD9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb7', '\x93'}, 3, 0x9DD3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb7', '\xb8'}, 3, 0x9DF8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb7', '\xa6'}, 3, 0x9DE6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb7', '\xad'}, 3, 0x9DED}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb7', '\xaf'}, 3, 0x9DEF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb7', '\xbd'}, 3, 0x9DFD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb8', '\x9a'}, 3, 0x9E1A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb8', '\x9b'}, 3, 0x9E1B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb8', '\x9e'}, 3, 0x9E1E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb9', '\xb5'}, 3, 0x9E75}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb9', '\xb9'}, 3, 0x9E79}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb9', '\xbd'}, 3, 0x9E7D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\x81'}, 3, 0x9E81}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\x88'}, 3, 0x9E88}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\x8b'}, 3, 0x9E8B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\x8c'}, 3, 0x9E8C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\x92'}, 3, 0x9E92}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\x95'}, 3, 0x9E95}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\x91'}, 3, 0x9E91}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\x9d'}, 3, 0x9E9D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\xa5'}, 3, 0x9EA5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\xa9'}, 3, 0x9EA9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\xb8'}, 3, 0x9EB8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\xaa'}, 3, 0x9EAA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xba', '\xad'}, 3, 0x9EAD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\xa1'}, 3, 0x9761}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\x8c'}, 3, 0x9ECC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\x8e'}, 3, 0x9ECE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\x8f'}, 3, 0x9ECF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\x90'}, 3, 0x9ED0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\x94'}, 3, 0x9ED4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\x9c'}, 3, 0x9EDC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\x9e'}, 3, 0x9EDE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\x9d'}, 3, 0x9EDD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\xa0'}, 3, 0x9EE0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\xa5'}, 3, 0x9EE5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\xa8'}, 3, 0x9EE8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\xaf'}, 3, 0x9EEF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\xb4'}, 3, 0x9EF4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\xb6'}, 3, 0x9EF6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\xb7'}, 3, 0x9EF7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\xb9'}, 3, 0x9EF9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\xbb'}, 3, 0x9EFB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\xbc'}, 3, 0x9EFC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\xbd'}, 3, 0x9EFD}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbc', '\x87'}, 3, 0x9F07}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbc', '\x88'}, 3, 0x9F08}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\xb7'}, 3, 0x76B7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbc', '\x95'}, 3, 0x9F15}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbc', '\xa1'}, 3, 0x9F21}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbc', '\xac'}, 3, 0x9F2C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbc', '\xbe'}, 3, 0x9F3E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\x8a'}, 3, 0x9F4A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\x92'}, 3, 0x9F52}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\x94'}, 3, 0x9F54}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\xa3'}, 3, 0x9F63}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\x9f'}, 3, 0x9F5F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\xa0'}, 3, 0x9F60}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\xa1'}, 3, 0x9F61}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\xa6'}, 3, 0x9F66}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\xa7'}, 3, 0x9F67}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\xac'}, 3, 0x9F6C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\xaa'}, 3, 0x9F6A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\xb7'}, 3, 0x9F77}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\xb2'}, 3, 0x9F72}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbd', '\xb6'}, 3, 0x9F76}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbe', '\x95'}, 3, 0x9F95}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbe', '\x9c'}, 3, 0x9F9C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbe', '\xa0'}, 3, 0x9FA0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa0', '\xaf'}, 3, 0x582F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\x87'}, 3, 0x69C7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x81', '\x99'}, 3, 0x9059}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\xa4'}, 3, 0x7464}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\x9c'}, 3, 0x51DC}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x86', '\x99'}, 3, 0x7199}, /* (<CJK Ideograph>) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe7', '\xba', '\x8a'}, 3, 0x7E8A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\x9c'}, 3, 0x891C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\x88'}, 3, 0x9348}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\x88'}, 3, 0x9288}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\x9c'}, 3, 0x84DC}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x89'}, 3, 0x4FC9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\xbb'}, 3, 0x70BB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xb1'}, 3, 0x6631}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x88'}, 3, 0x68C8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xb9'}, 3, 0x92F9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xbb'}, 3, 0x66FB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\x85'}, 3, 0x5F45}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\xa8'}, 3, 0x4E28}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\xa1'}, 3, 0x4EE1}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\xbc'}, 3, 0x4EFC}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\x80'}, 3, 0x4F00}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\x83'}, 3, 0x4F03}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\xb9'}, 3, 0x4F39}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x96'}, 3, 0x4F56}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x92'}, 3, 0x4F92}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x8a'}, 3, 0x4F8A}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x9a'}, 3, 0x4F9A}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x94'}, 3, 0x4F94}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x8d'}, 3, 0x4FCD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x80'}, 3, 0x5040}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\xa2'}, 3, 0x5022}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\xbf'}, 3, 0x4FFF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\x9e'}, 3, 0x501E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x86'}, 3, 0x5046}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\xb0'}, 3, 0x5070}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x82'}, 3, 0x5042}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\x94'}, 3, 0x5094}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\xb4'}, 3, 0x50F4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\x98'}, 3, 0x50D8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x8a'}, 3, 0x514A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xa4'}, 3, 0x5164}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x9d'}, 3, 0x519D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xbe'}, 3, 0x51BE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xac'}, 3, 0x51EC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\x95'}, 3, 0x5215}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\x9c'}, 3, 0x529C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xa6'}, 3, 0x52A6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x80'}, 3, 0x52C0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x9b'}, 3, 0x52DB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x80'}, 3, 0x5300}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x87'}, 3, 0x5307}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\xa4'}, 3, 0x5324}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xb2'}, 3, 0x5372}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\x93'}, 3, 0x5393}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\xb2'}, 3, 0x53B2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x9d'}, 3, 0x53DD}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x8e'}, 3, 0xFA0E}, /* (CJK COMPATIBILITY IDEOGRAPH-FA0E) */
    {{'\xe5', '\x92', '\x9c'}, 3, 0x549C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\x8a'}, 3, 0x548A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\xa9'}, 3, 0x54A9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\xbf'}, 3, 0x54FF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\x86'}, 3, 0x5586}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\x99'}, 3, 0x5759}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\xa5'}, 3, 0x5765}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9e', '\xac'}, 3, 0x57AC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\x88'}, 3, 0x57C8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\x87'}, 3, 0x57C7}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x8f'}, 3, 0xFA0F}, /* (CJK COMPATIBILITY IDEOGRAPH-FA0F) */
    {{'\xef', '\xa8', '\x90'}, 3, 0xFA10}, /* (CJK COMPATIBILITY IDEOGRAPH-FA10) */
    {{'\xe5', '\xa2', '\x9e'}, 3, 0x589E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\xb2'}, 3, 0x58B2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\x8b'}, 3, 0x590B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x93'}, 3, 0x5953}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x9b'}, 3, 0x595B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x9d'}, 3, 0x595D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\xa3'}, 3, 0x5963}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\xa4'}, 3, 0x59A4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\xba'}, 3, 0x59BA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\x96'}, 3, 0x5B56}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x80'}, 3, 0x5BC0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xaf'}, 3, 0x752F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x98'}, 3, 0x5BD8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xac'}, 3, 0x5BEC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x9e'}, 3, 0x5C1E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xa6'}, 3, 0x5CA6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xba'}, 3, 0x5CBA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\xb5'}, 3, 0x5CF5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\xa7'}, 3, 0x5D27}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb5', '\x93'}, 3, 0x5D53}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x91'}, 3, 0xFA11}, /* (CJK COMPATIBILITY IDEOGRAPH-FA11) */
    {{'\xe5', '\xb5', '\x82'}, 3, 0x5D42}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb5', '\xad'}, 3, 0x5D6D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\xb8'}, 3, 0x5DB8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\xb9'}, 3, 0x5DB9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\x90'}, 3, 0x5DD0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\xa1'}, 3, 0x5F21}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\xb4'}, 3, 0x5F34}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xa7'}, 3, 0x5F67}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\xb7'}, 3, 0x5FB7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\x9e'}, 3, 0x5FDE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\x9d'}, 3, 0x605D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x85'}, 3, 0x6085}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x8a'}, 3, 0x608A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\x9e'}, 3, 0x60DE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\x95'}, 3, 0x60D5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\xa0'}, 3, 0x6120}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\xb2'}, 3, 0x60F2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\x91'}, 3, 0x6111}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\xb7'}, 3, 0x6137}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\xb0'}, 3, 0x6130}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\x98'}, 3, 0x6198}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x93'}, 3, 0x6213}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\xa6'}, 3, 0x62A6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\xb5'}, 3, 0x63F5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x91', '\xa0'}, 3, 0x6460}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\x9d'}, 3, 0x649D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\x8e'}, 3, 0x64CE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\x8e'}, 3, 0x654E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x80'}, 3, 0x6600}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x95'}, 3, 0x6615}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xbb'}, 3, 0x663B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x89'}, 3, 0x6609}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xae'}, 3, 0x662E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x9e'}, 3, 0x661E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xa4'}, 3, 0x6624}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\xa5'}, 3, 0x6665}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\x97'}, 3, 0x6657}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\x99'}, 3, 0x6659}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x92'}, 3, 0xFA12}, /* (CJK COMPATIBILITY IDEOGRAPH-FA12) */
    {{'\xe6', '\x99', '\xb3'}, 3, 0x6673}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\x99'}, 3, 0x6699}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\xa0'}, 3, 0x66A0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\xb2'}, 3, 0x66B2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\xbf'}, 3, 0x66BF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xba'}, 3, 0x66FA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x8e'}, 3, 0x670E}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa4', '\xa9'}, 3, 0xF929}, /* (CJK COMPATIBILITY IDEOGRAPH-F929) */
    {{'\xe6', '\x9d', '\xa6'}, 3, 0x6766}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\xbb'}, 3, 0x67BB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x92'}, 3, 0x6852}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\x80'}, 3, 0x67C0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\x81'}, 3, 0x6801}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x84'}, 3, 0x6844}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x8f'}, 3, 0x68CF}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x93'}, 3, 0xFA13}, /* (CJK COMPATIBILITY IDEOGRAPH-FA13) */
    {{'\xe6', '\xa5', '\xa8'}, 3, 0x6968}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x94'}, 3, 0xFA14}, /* (CJK COMPATIBILITY IDEOGRAPH-FA14) */
    {{'\xe6', '\xa6', '\x98'}, 3, 0x6998}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\xa2'}, 3, 0x69E2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\xb0'}, 3, 0x6A30}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\xab'}, 3, 0x6A6B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\x86'}, 3, 0x6A46}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\xb3'}, 3, 0x6A73}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\xbe'}, 3, 0x6A7E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\xa2'}, 3, 0x6AE2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\xa4'}, 3, 0x6AE4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\x96'}, 3, 0x6BD6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb0', '\xbf'}, 3, 0x6C3F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\x9c'}, 3, 0x6C5C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\x86'}, 3, 0x6C86}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\xaf'}, 3, 0x6C6F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\x9a'}, 3, 0x6CDA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\x84'}, 3, 0x6D04}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\x87'}, 3, 0x6D87}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\xaf'}, 3, 0x6D6F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\x96'}, 3, 0x6D96}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\xac'}, 3, 0x6DAC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\x8f'}, 3, 0x6DCF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xb8'}, 3, 0x6DF8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xb2'}, 3, 0x6DF2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xbc'}, 3, 0x6DFC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xb9'}, 3, 0x6E39}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\x9c'}, 3, 0x6E5C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xa7'}, 3, 0x6E27}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xbc'}, 3, 0x6E3C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\xbf'}, 3, 0x6EBF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\x88'}, 3, 0x6F88}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\xb5'}, 3, 0x6FB5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\xb5'}, 3, 0x6FF5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\x85'}, 3, 0x7005}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\x87'}, 3, 0x7007}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\xa8'}, 3, 0x7028}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\x85'}, 3, 0x7085}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\xab'}, 3, 0x70AB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x84', '\x8f'}, 3, 0x710F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x84', '\x84'}, 3, 0x7104}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\x9c'}, 3, 0x715C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\x86'}, 3, 0x7146}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\x87'}, 3, 0x7147}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x95'}, 3, 0xFA15}, /* (CJK COMPATIBILITY IDEOGRAPH-FA15) */
    {{'\xe7', '\x87', '\x81'}, 3, 0x71C1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\xbe'}, 3, 0x71FE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\xb1'}, 3, 0x72B1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\xbe'}, 3, 0x72BE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\xa4'}, 3, 0x7324}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x96'}, 3, 0xFA16}, /* (CJK COMPATIBILITY IDEOGRAPH-FA16) */
    {{'\xe7', '\x8d', '\xb7'}, 3, 0x7377}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8e', '\xbd'}, 3, 0x73BD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\x89'}, 3, 0x73C9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\x96'}, 3, 0x73D6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\xa3'}, 3, 0x73E3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\x92'}, 3, 0x73D2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\x87'}, 3, 0x7407}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\xb5'}, 3, 0x73F5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xa6'}, 3, 0x7426}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xaa'}, 3, 0x742A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xa9'}, 3, 0x7429}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xae'}, 3, 0x742E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\xa2'}, 3, 0x7462}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x92', '\x89'}, 3, 0x7489}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x92', '\x9f'}, 3, 0x749F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\x81'}, 3, 0x7501}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xaf'}, 3, 0x756F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x82'}, 3, 0x7682}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x9c'}, 3, 0x769C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x9e'}, 3, 0x769E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x9b'}, 3, 0x769B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\xa6'}, 3, 0x76A6}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x97'}, 3, 0xFA17}, /* (CJK COMPATIBILITY IDEOGRAPH-FA17) */
    {{'\xe7', '\x9d', '\x86'}, 3, 0x7746}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xaf'}, 3, 0x52AF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa0', '\xa1'}, 3, 0x7821}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa1', '\x8e'}, 3, 0x784E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa1', '\xa4'}, 3, 0x7864}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa1', '\xba'}, 3, 0x787A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa4', '\xb0'}, 3, 0x7930}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x98'}, 3, 0xFA18}, /* (CJK COMPATIBILITY IDEOGRAPH-FA18) */
    {{'\xef', '\xa8', '\x99'}, 3, 0xFA19}, /* (CJK COMPATIBILITY IDEOGRAPH-FA19) */
    {{'\xef', '\xa8', '\x9a'}, 3, 0xFA1A}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1A) */
    {{'\xe7', '\xa6', '\x94'}, 3, 0x7994}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x9b'}, 3, 0xFA1B}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1B) */
    {{'\xe7', '\xa6', '\x9b'}, 3, 0x799B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x91'}, 3, 0x7AD1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xa7'}, 3, 0x7AE7}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x9c'}, 3, 0xFA1C}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1C) */
    {{'\xe7', '\xab', '\xab'}, 3, 0x7AEB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x9e'}, 3, 0x7B9E}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x9d'}, 3, 0xFA1D}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1D) */
    {{'\xe7', '\xb5', '\x88'}, 3, 0x7D48}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\x9c'}, 3, 0x7D5C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xb7'}, 3, 0x7DB7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xa0'}, 3, 0x7DA0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\x96'}, 3, 0x7DD6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\x92'}, 3, 0x7E52}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\x87'}, 3, 0x7F47}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\xa1'}, 3, 0x7FA1}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x9e'}, 3, 0xFA1E}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1E) */
    {{'\xe8', '\x8c', '\x81'}, 3, 0x8301}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\xa2'}, 3, 0x8362}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\xbf'}, 3, 0x837F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\x87'}, 3, 0x83C7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\xb6'}, 3, 0x83F6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\x88'}, 3, 0x8448}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\xb4'}, 3, 0x84B4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\x93'}, 3, 0x8553}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\x99'}, 3, 0x8559}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\xab'}, 3, 0x856B}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x9f'}, 3, 0xFA1F}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1F) */
    {{'\xe8', '\x96', '\xb0'}, 3, 0x85B0}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xa0'}, 3, 0xFA20}, /* (CJK COMPATIBILITY IDEOGRAPH-FA20) */
    {{'\xef', '\xa8', '\xa1'}, 3, 0xFA21}, /* (CJK COMPATIBILITY IDEOGRAPH-FA21) */
    {{'\xe8', '\xa0', '\x87'}, 3, 0x8807}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\xb5'}, 3, 0x88F5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x92'}, 3, 0x8A12}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\xb7'}, 3, 0x8A37}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\xb9'}, 3, 0x8A79}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xa7'}, 3, 0x8AA7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xbe'}, 3, 0x8ABE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\x9f'}, 3, 0x8ADF}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xa2'}, 3, 0xFA22}, /* (CJK COMPATIBILITY IDEOGRAPH-FA22) */
    {{'\xe8', '\xab', '\xb6'}, 3, 0x8AF6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\x93'}, 3, 0x8B53}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\xbf'}, 3, 0x8B7F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\xb0'}, 3, 0x8CF0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\xb4'}, 3, 0x8CF4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb4', '\x92'}, 3, 0x8D12}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb5', '\xb6'}, 3, 0x8D76}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xa3'}, 3, 0xFA23}, /* (CJK COMPATIBILITY IDEOGRAPH-FA23) */
    {{'\xe8', '\xbb', '\x8f'}, 3, 0x8ECF}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xa4'}, 3, 0xFA24}, /* (CJK COMPATIBILITY IDEOGRAPH-FA24) */
    {{'\xef', '\xa8', '\xa5'}, 3, 0xFA25}, /* (CJK COMPATIBILITY IDEOGRAPH-FA25) */
    {{'\xe9', '\x81', '\xa7'}, 3, 0x9067}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x83', '\x9e'}, 3, 0x90DE}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xa6'}, 3, 0xFA26}, /* (CJK COMPATIBILITY IDEOGRAPH-FA26) */
    {{'\xe9', '\x84', '\x95'}, 3, 0x9115}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x84', '\xa7'}, 3, 0x9127}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x9a'}, 3, 0x91DA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x97'}, 3, 0x91D7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x9e'}, 3, 0x91DE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\xad'}, 3, 0x91ED}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\xae'}, 3, 0x91EE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\xa4'}, 3, 0x91E4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\xa5'}, 3, 0x91E5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\x86'}, 3, 0x9206}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\x90'}, 3, 0x9210}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\x8a'}, 3, 0x920A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\xba'}, 3, 0x923A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x80'}, 3, 0x9240}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\xbc'}, 3, 0x923C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x8e'}, 3, 0x924E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x99'}, 3, 0x9259}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x91'}, 3, 0x9251}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\xb9'}, 3, 0x9239}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\xa7'}, 3, 0x9267}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\xa7'}, 3, 0x92A7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\xb7'}, 3, 0x9277}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\xb8'}, 3, 0x9278}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xa7'}, 3, 0x92E7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\x97'}, 3, 0x92D7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\x99'}, 3, 0x92D9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\x90'}, 3, 0x92D0}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xa7'}, 3, 0xFA27}, /* (CJK COMPATIBILITY IDEOGRAPH-FA27) */
    {{'\xe9', '\x8b', '\x95'}, 3, 0x92D5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xa0'}, 3, 0x92E0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\x93'}, 3, 0x92D3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xa5'}, 3, 0x9325}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xa1'}, 3, 0x9321}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xbb'}, 3, 0x92FB}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xa8'}, 3, 0xFA28}, /* (CJK COMPATIBILITY IDEOGRAPH-FA28) */
    {{'\xe9', '\x8c', '\x9e'}, 3, 0x931E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xbf'}, 3, 0x92FF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\x9d'}, 3, 0x931D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\x82'}, 3, 0x9302}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\xb0'}, 3, 0x9370}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\x97'}, 3, 0x9357}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8e', '\xa4'}, 3, 0x93A4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\x86'}, 3, 0x93C6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\x9e'}, 3, 0x93DE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\xb8'}, 3, 0x93F8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x90', '\xb1'}, 3, 0x9431}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\x85'}, 3, 0x9445}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\x88'}, 3, 0x9448}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\x92'}, 3, 0x9592}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa7', '\x9c'}, 3, 0xF9DC}, /* (CJK COMPATIBILITY IDEOGRAPH-F9DC) */
    {{'\xef', '\xa8', '\xa9'}, 3, 0xFA29}, /* (CJK COMPATIBILITY IDEOGRAPH-FA29) */
    {{'\xe9', '\x9a', '\x9d'}, 3, 0x969D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xaf'}, 3, 0x96AF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\xb3'}, 3, 0x9733}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\xbb'}, 3, 0x973B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x83'}, 3, 0x9743}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x8d'}, 3, 0x974D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x8f'}, 3, 0x974F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x91'}, 3, 0x9751}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x95'}, 3, 0x9755}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\x97'}, 3, 0x9857}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\xa5'}, 3, 0x9865}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xaa'}, 3, 0xFA2A}, /* (CJK COMPATIBILITY IDEOGRAPH-FA2A) */
    {{'\xef', '\xa8', '\xab'}, 3, 0xFA2B}, /* (CJK COMPATIBILITY IDEOGRAPH-FA2B) */
    {{'\xe9', '\xa4', '\xa7'}, 3, 0x9927}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xac'}, 3, 0xFA2C}, /* (CJK COMPATIBILITY IDEOGRAPH-FA2C) */
    {{'\xe9', '\xa6', '\x9e'}, 3, 0x999E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\x8e'}, 3, 0x9A4E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\x99'}, 3, 0x9AD9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\x9c'}, 3, 0x9ADC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\xb5'}, 3, 0x9B75}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\xb2'}, 3, 0x9B72}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\x8f'}, 3, 0x9B8F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\xb1'}, 3, 0x9BB1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\xbb'}, 3, 0x9BBB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\x80'}, 3, 0x9C00}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\xb0'}, 3, 0x9D70}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\xab'}, 3, 0x9D6B}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xad'}, 3, 0xFA2D}, /* (CJK COMPATIBILITY IDEOGRAPH-FA2D) */
    {{'\xe9', '\xb8', '\x99'}, 3, 0x9E19}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\x91'}, 3, 0x9ED1}, /* (<CJK Ideograph>) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe2', '\x85', '\xb0'}, 3, 0x2170}, /* (SMALL ROMAN NUMERAL ONE) */
    {{'\xe2', '\x85', '\xb1'}, 3, 0x2171}, /* (SMALL ROMAN NUMERAL TWO) */
    {{'\xe2', '\x85', '\xb2'}, 3, 0x2172}, /* (SMALL ROMAN NUMERAL THREE) */
    {{'\xe2', '\x85', '\xb3'}, 3, 0x2173}, /* (SMALL ROMAN NUMERAL FOUR) */
    {{'\xe2', '\x85', '\xb4'}, 3, 0x2174}, /* (SMALL ROMAN NUMERAL FIVE) */
    {{'\xe2', '\x85', '\xb5'}, 3, 0x2175}, /* (SMALL ROMAN NUMERAL SIX) */
    {{'\xe2', '\x85', '\xb6'}, 3, 0x2176}, /* (SMALL ROMAN NUMERAL SEVEN) */
    {{'\xe2', '\x85', '\xb7'}, 3, 0x2177}, /* (SMALL ROMAN NUMERAL EIGHT) */
    {{'\xe2', '\x85', '\xb8'}, 3, 0x2178}, /* (SMALL ROMAN NUMERAL NINE) */
    {{'\xe2', '\x85', '\xb9'}, 3, 0x2179}, /* (SMALL ROMAN NUMERAL TEN) */
    {{'\xef', '\xbf', '\xa2'}, 3, 0xFFE2}, /* (FULLWIDTH NOT SIGN) */
    {{'\xef', '\xbf', '\xa4'}, 3, 0xFFE4}, /* (FULLWIDTH BROKEN BAR) */
    {{'\xef', '\xbc', '\x87'}, 3, 0xFF07}, /* (FULLWIDTH APOSTROPHE) */
    {{'\xef', '\xbc', '\x82'}, 3, 0xFF02}, /* (FULLWIDTH QUOTATION MARK) */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{0}, 0, LXB_ENCODING_ERROR_CODEPOINT}, /* Not defined */
    {{'\xe2', '\x85', '\xb0'}, 3, 0x2170}, /* (SMALL ROMAN NUMERAL ONE) */
    {{'\xe2', '\x85', '\xb1'}, 3, 0x2171}, /* (SMALL ROMAN NUMERAL TWO) */
    {{'\xe2', '\x85', '\xb2'}, 3, 0x2172}, /* (SMALL ROMAN NUMERAL THREE) */
    {{'\xe2', '\x85', '\xb3'}, 3, 0x2173}, /* (SMALL ROMAN NUMERAL FOUR) */
    {{'\xe2', '\x85', '\xb4'}, 3, 0x2174}, /* (SMALL ROMAN NUMERAL FIVE) */
    {{'\xe2', '\x85', '\xb5'}, 3, 0x2175}, /* (SMALL ROMAN NUMERAL SIX) */
    {{'\xe2', '\x85', '\xb6'}, 3, 0x2176}, /* (SMALL ROMAN NUMERAL SEVEN) */
    {{'\xe2', '\x85', '\xb7'}, 3, 0x2177}, /* (SMALL ROMAN NUMERAL EIGHT) */
    {{'\xe2', '\x85', '\xb8'}, 3, 0x2178}, /* (SMALL ROMAN NUMERAL NINE) */
    {{'\xe2', '\x85', '\xb9'}, 3, 0x2179}, /* (SMALL ROMAN NUMERAL TEN) */
    {{'\xe2', '\x85', '\xa0'}, 3, 0x2160}, /* (ROMAN NUMERAL ONE) */
    {{'\xe2', '\x85', '\xa1'}, 3, 0x2161}, /* (ROMAN NUMERAL TWO) */
    {{'\xe2', '\x85', '\xa2'}, 3, 0x2162}, /* (ROMAN NUMERAL THREE) */
    {{'\xe2', '\x85', '\xa3'}, 3, 0x2163}, /* (ROMAN NUMERAL FOUR) */
    {{'\xe2', '\x85', '\xa4'}, 3, 0x2164}, /* (ROMAN NUMERAL FIVE) */
    {{'\xe2', '\x85', '\xa5'}, 3, 0x2165}, /* (ROMAN NUMERAL SIX) */
    {{'\xe2', '\x85', '\xa6'}, 3, 0x2166}, /* (ROMAN NUMERAL SEVEN) */
    {{'\xe2', '\x85', '\xa7'}, 3, 0x2167}, /* (ROMAN NUMERAL EIGHT) */
    {{'\xe2', '\x85', '\xa8'}, 3, 0x2168}, /* (ROMAN NUMERAL NINE) */
    {{'\xe2', '\x85', '\xa9'}, 3, 0x2169}, /* (ROMAN NUMERAL TEN) */
    {{'\xef', '\xbf', '\xa2'}, 3, 0xFFE2}, /* (FULLWIDTH NOT SIGN) */
    {{'\xef', '\xbf', '\xa4'}, 3, 0xFFE4}, /* (FULLWIDTH BROKEN BAR) */
    {{'\xef', '\xbc', '\x87'}, 3, 0xFF07}, /* (FULLWIDTH APOSTROPHE) */
    {{'\xef', '\xbc', '\x82'}, 3, 0xFF02}, /* (FULLWIDTH QUOTATION MARK) */
    {{'\xe3', '\x88', '\xb1'}, 3, 0x3231}, /* (PARENTHESIZED IDEOGRAPH STOCK) */
    {{'\xe2', '\x84', '\x96'}, 3, 0x2116}, /* (NUMERO SIGN) */
    {{'\xe2', '\x84', '\xa1'}, 3, 0x2121}, /* (TELEPHONE SIGN) */
    {{'\xe2', '\x88', '\xb5'}, 3, 0x2235}, /* (BECAUSE) */
    {{'\xe7', '\xba', '\x8a'}, 3, 0x7E8A}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa4', '\x9c'}, 3, 0x891C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\x88'}, 3, 0x9348}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\x88'}, 3, 0x9288}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x93', '\x9c'}, 3, 0x84DC}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x89'}, 3, 0x4FC9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\xbb'}, 3, 0x70BB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xb1'}, 3, 0x6631}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x88'}, 3, 0x68C8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xb9'}, 3, 0x92F9}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xbb'}, 3, 0x66FB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\x85'}, 3, 0x5F45}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xb8', '\xa8'}, 3, 0x4E28}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\xa1'}, 3, 0x4EE1}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbb', '\xbc'}, 3, 0x4EFC}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\x80'}, 3, 0x4F00}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\x83'}, 3, 0x4F03}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbc', '\xb9'}, 3, 0x4F39}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbd', '\x96'}, 3, 0x4F56}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x92'}, 3, 0x4F92}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x8a'}, 3, 0x4F8A}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x9a'}, 3, 0x4F9A}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbe', '\x94'}, 3, 0x4F94}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\x8d'}, 3, 0x4FCD}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x80'}, 3, 0x5040}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\xa2'}, 3, 0x5022}, /* (<CJK Ideograph>) */
    {{'\xe4', '\xbf', '\xbf'}, 3, 0x4FFF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x80', '\x9e'}, 3, 0x501E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x86'}, 3, 0x5046}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\xb0'}, 3, 0x5070}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x81', '\x82'}, 3, 0x5042}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x82', '\x94'}, 3, 0x5094}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\xb4'}, 3, 0x50F4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x83', '\x98'}, 3, 0x50D8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\x8a'}, 3, 0x514A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x85', '\xa4'}, 3, 0x5164}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\x9d'}, 3, 0x519D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x86', '\xbe'}, 3, 0x51BE}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x87', '\xac'}, 3, 0x51EC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x88', '\x95'}, 3, 0x5215}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\x9c'}, 3, 0x529C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xa6'}, 3, 0x52A6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x80'}, 3, 0x52C0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8b', '\x9b'}, 3, 0x52DB}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x80'}, 3, 0x5300}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\x87'}, 3, 0x5307}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8c', '\xa4'}, 3, 0x5324}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8d', '\xb2'}, 3, 0x5372}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\x93'}, 3, 0x5393}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8e', '\xb2'}, 3, 0x53B2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8f', '\x9d'}, 3, 0x53DD}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x8e'}, 3, 0xFA0E}, /* (CJK COMPATIBILITY IDEOGRAPH-FA0E) */
    {{'\xe5', '\x92', '\x9c'}, 3, 0x549C}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\x8a'}, 3, 0x548A}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x92', '\xa9'}, 3, 0x54A9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x93', '\xbf'}, 3, 0x54FF}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x96', '\x86'}, 3, 0x5586}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\x99'}, 3, 0x5759}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9d', '\xa5'}, 3, 0x5765}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9e', '\xac'}, 3, 0x57AC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\x88'}, 3, 0x57C8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x9f', '\x87'}, 3, 0x57C7}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x8f'}, 3, 0xFA0F}, /* (CJK COMPATIBILITY IDEOGRAPH-FA0F) */
    {{'\xef', '\xa8', '\x90'}, 3, 0xFA10}, /* (CJK COMPATIBILITY IDEOGRAPH-FA10) */
    {{'\xe5', '\xa2', '\x9e'}, 3, 0x589E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa2', '\xb2'}, 3, 0x58B2}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa4', '\x8b'}, 3, 0x590B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x93'}, 3, 0x5953}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x9b'}, 3, 0x595B}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\x9d'}, 3, 0x595D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa5', '\xa3'}, 3, 0x5963}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\xa4'}, 3, 0x59A4}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xa6', '\xba'}, 3, 0x59BA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xad', '\x96'}, 3, 0x5B56}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x80'}, 3, 0x5BC0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\xaf'}, 3, 0x752F}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\x98'}, 3, 0x5BD8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xaf', '\xac'}, 3, 0x5BEC}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb0', '\x9e'}, 3, 0x5C1E}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xa6'}, 3, 0x5CA6}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb2', '\xba'}, 3, 0x5CBA}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb3', '\xb5'}, 3, 0x5CF5}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb4', '\xa7'}, 3, 0x5D27}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb5', '\x93'}, 3, 0x5D53}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x91'}, 3, 0xFA11}, /* (CJK COMPATIBILITY IDEOGRAPH-FA11) */
    {{'\xe5', '\xb5', '\x82'}, 3, 0x5D42}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb5', '\xad'}, 3, 0x5D6D}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\xb8'}, 3, 0x5DB8}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb6', '\xb9'}, 3, 0x5DB9}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xb7', '\x90'}, 3, 0x5DD0}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\xa1'}, 3, 0x5F21}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbc', '\xb4'}, 3, 0x5F34}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbd', '\xa7'}, 3, 0x5F67}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbe', '\xb7'}, 3, 0x5FB7}, /* (<CJK Ideograph>) */
    {{'\xe5', '\xbf', '\x9e'}, 3, 0x5FDE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x81', '\x9d'}, 3, 0x605D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x85'}, 3, 0x6085}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x82', '\x8a'}, 3, 0x608A}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\x9e'}, 3, 0x60DE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\x95'}, 3, 0x60D5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\xa0'}, 3, 0x6120}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x83', '\xb2'}, 3, 0x60F2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\x91'}, 3, 0x6111}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\xb7'}, 3, 0x6137}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x84', '\xb0'}, 3, 0x6130}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x86', '\x98'}, 3, 0x6198}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x88', '\x93'}, 3, 0x6213}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8a', '\xa6'}, 3, 0x62A6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x8f', '\xb5'}, 3, 0x63F5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x91', '\xa0'}, 3, 0x6460}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x92', '\x9d'}, 3, 0x649D}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x93', '\x8e'}, 3, 0x64CE}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x95', '\x8e'}, 3, 0x654E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x80'}, 3, 0x6600}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x95'}, 3, 0x6615}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xbb'}, 3, 0x663B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x89'}, 3, 0x6609}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xae'}, 3, 0x662E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\x9e'}, 3, 0x661E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x98', '\xa4'}, 3, 0x6624}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\xa5'}, 3, 0x6665}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\x97'}, 3, 0x6657}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x99', '\x99'}, 3, 0x6659}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x92'}, 3, 0xFA12}, /* (CJK COMPATIBILITY IDEOGRAPH-FA12) */
    {{'\xe6', '\x99', '\xb3'}, 3, 0x6673}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\x99'}, 3, 0x6699}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\xa0'}, 3, 0x66A0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\xb2'}, 3, 0x66B2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9a', '\xbf'}, 3, 0x66BF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9b', '\xba'}, 3, 0x66FA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9c', '\x8e'}, 3, 0x670E}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa4', '\xa9'}, 3, 0xF929}, /* (CJK COMPATIBILITY IDEOGRAPH-F929) */
    {{'\xe6', '\x9d', '\xa6'}, 3, 0x6766}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9e', '\xbb'}, 3, 0x67BB}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x92'}, 3, 0x6852}, /* (<CJK Ideograph>) */
    {{'\xe6', '\x9f', '\x80'}, 3, 0x67C0}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa0', '\x81'}, 3, 0x6801}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa1', '\x84'}, 3, 0x6844}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa3', '\x8f'}, 3, 0x68CF}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x93'}, 3, 0xFA13}, /* (CJK COMPATIBILITY IDEOGRAPH-FA13) */
    {{'\xe6', '\xa5', '\xa8'}, 3, 0x6968}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x94'}, 3, 0xFA14}, /* (CJK COMPATIBILITY IDEOGRAPH-FA14) */
    {{'\xe6', '\xa6', '\x98'}, 3, 0x6998}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa7', '\xa2'}, 3, 0x69E2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa8', '\xb0'}, 3, 0x6A30}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\xab'}, 3, 0x6A6B}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\x86'}, 3, 0x6A46}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\xb3'}, 3, 0x6A73}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xa9', '\xbe'}, 3, 0x6A7E}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\xa2'}, 3, 0x6AE2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xab', '\xa4'}, 3, 0x6AE4}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xaf', '\x96'}, 3, 0x6BD6}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb0', '\xbf'}, 3, 0x6C3F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\x9c'}, 3, 0x6C5C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb2', '\x86'}, 3, 0x6C86}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb1', '\xaf'}, 3, 0x6C6F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb3', '\x9a'}, 3, 0x6CDA}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb4', '\x84'}, 3, 0x6D04}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\x87'}, 3, 0x6D87}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb5', '\xaf'}, 3, 0x6D6F}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\x96'}, 3, 0x6D96}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb6', '\xac'}, 3, 0x6DAC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\x8f'}, 3, 0x6DCF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xb8'}, 3, 0x6DF8}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xb2'}, 3, 0x6DF2}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb7', '\xbc'}, 3, 0x6DFC}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xb9'}, 3, 0x6E39}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb9', '\x9c'}, 3, 0x6E5C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xa7'}, 3, 0x6E27}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xb8', '\xbc'}, 3, 0x6E3C}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xba', '\xbf'}, 3, 0x6EBF}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\x88'}, 3, 0x6F88}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbe', '\xb5'}, 3, 0x6FB5}, /* (<CJK Ideograph>) */
    {{'\xe6', '\xbf', '\xb5'}, 3, 0x6FF5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\x85'}, 3, 0x7005}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\x87'}, 3, 0x7007}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x80', '\xa8'}, 3, 0x7028}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\x85'}, 3, 0x7085}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x82', '\xab'}, 3, 0x70AB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x84', '\x8f'}, 3, 0x710F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x84', '\x84'}, 3, 0x7104}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\x9c'}, 3, 0x715C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\x86'}, 3, 0x7146}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x85', '\x87'}, 3, 0x7147}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x95'}, 3, 0xFA15}, /* (CJK COMPATIBILITY IDEOGRAPH-FA15) */
    {{'\xe7', '\x87', '\x81'}, 3, 0x71C1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x87', '\xbe'}, 3, 0x71FE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\xb1'}, 3, 0x72B1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8a', '\xbe'}, 3, 0x72BE}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8c', '\xa4'}, 3, 0x7324}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x96'}, 3, 0xFA16}, /* (CJK COMPATIBILITY IDEOGRAPH-FA16) */
    {{'\xe7', '\x8d', '\xb7'}, 3, 0x7377}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8e', '\xbd'}, 3, 0x73BD}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\x89'}, 3, 0x73C9}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\x96'}, 3, 0x73D6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\xa3'}, 3, 0x73E3}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\x92'}, 3, 0x73D2}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\x87'}, 3, 0x7407}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x8f', '\xb5'}, 3, 0x73F5}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xa6'}, 3, 0x7426}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xaa'}, 3, 0x742A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xa9'}, 3, 0x7429}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x90', '\xae'}, 3, 0x742E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x91', '\xa2'}, 3, 0x7462}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x92', '\x89'}, 3, 0x7489}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x92', '\x9f'}, 3, 0x749F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x94', '\x81'}, 3, 0x7501}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x95', '\xaf'}, 3, 0x756F}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x82'}, 3, 0x7682}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x9c'}, 3, 0x769C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x9e'}, 3, 0x769E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\x9b'}, 3, 0x769B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\x9a', '\xa6'}, 3, 0x76A6}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x97'}, 3, 0xFA17}, /* (CJK COMPATIBILITY IDEOGRAPH-FA17) */
    {{'\xe7', '\x9d', '\x86'}, 3, 0x7746}, /* (<CJK Ideograph>) */
    {{'\xe5', '\x8a', '\xaf'}, 3, 0x52AF}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa0', '\xa1'}, 3, 0x7821}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa1', '\x8e'}, 3, 0x784E}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa1', '\xa4'}, 3, 0x7864}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa1', '\xba'}, 3, 0x787A}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xa4', '\xb0'}, 3, 0x7930}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x98'}, 3, 0xFA18}, /* (CJK COMPATIBILITY IDEOGRAPH-FA18) */
    {{'\xef', '\xa8', '\x99'}, 3, 0xFA19}, /* (CJK COMPATIBILITY IDEOGRAPH-FA19) */
    {{'\xef', '\xa8', '\x9a'}, 3, 0xFA1A}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1A) */
    {{'\xe7', '\xa6', '\x94'}, 3, 0x7994}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x9b'}, 3, 0xFA1B}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1B) */
    {{'\xe7', '\xa6', '\x9b'}, 3, 0x799B}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\x91'}, 3, 0x7AD1}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xab', '\xa7'}, 3, 0x7AE7}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x9c'}, 3, 0xFA1C}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1C) */
    {{'\xe7', '\xab', '\xab'}, 3, 0x7AEB}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xae', '\x9e'}, 3, 0x7B9E}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x9d'}, 3, 0xFA1D}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1D) */
    {{'\xe7', '\xb5', '\x88'}, 3, 0x7D48}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb5', '\x9c'}, 3, 0x7D5C}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xb7'}, 3, 0x7DB7}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb6', '\xa0'}, 3, 0x7DA0}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb7', '\x96'}, 3, 0x7DD6}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xb9', '\x92'}, 3, 0x7E52}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbd', '\x87'}, 3, 0x7F47}, /* (<CJK Ideograph>) */
    {{'\xe7', '\xbe', '\xa1'}, 3, 0x7FA1}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x9e'}, 3, 0xFA1E}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1E) */
    {{'\xe8', '\x8c', '\x81'}, 3, 0x8301}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\xa2'}, 3, 0x8362}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8d', '\xbf'}, 3, 0x837F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\x87'}, 3, 0x83C7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x8f', '\xb6'}, 3, 0x83F6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x91', '\x88'}, 3, 0x8448}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x92', '\xb4'}, 3, 0x84B4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\x93'}, 3, 0x8553}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\x99'}, 3, 0x8559}, /* (<CJK Ideograph>) */
    {{'\xe8', '\x95', '\xab'}, 3, 0x856B}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\x9f'}, 3, 0xFA1F}, /* (CJK COMPATIBILITY IDEOGRAPH-FA1F) */
    {{'\xe8', '\x96', '\xb0'}, 3, 0x85B0}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xa0'}, 3, 0xFA20}, /* (CJK COMPATIBILITY IDEOGRAPH-FA20) */
    {{'\xef', '\xa8', '\xa1'}, 3, 0xFA21}, /* (CJK COMPATIBILITY IDEOGRAPH-FA21) */
    {{'\xe8', '\xa0', '\x87'}, 3, 0x8807}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa3', '\xb5'}, 3, 0x88F5}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\x92'}, 3, 0x8A12}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa8', '\xb7'}, 3, 0x8A37}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xa9', '\xb9'}, 3, 0x8A79}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xa7'}, 3, 0x8AA7}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xaa', '\xbe'}, 3, 0x8ABE}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xab', '\x9f'}, 3, 0x8ADF}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xa2'}, 3, 0xFA22}, /* (CJK COMPATIBILITY IDEOGRAPH-FA22) */
    {{'\xe8', '\xab', '\xb6'}, 3, 0x8AF6}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\x93'}, 3, 0x8B53}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xad', '\xbf'}, 3, 0x8B7F}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\xb0'}, 3, 0x8CF0}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb3', '\xb4'}, 3, 0x8CF4}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb4', '\x92'}, 3, 0x8D12}, /* (<CJK Ideograph>) */
    {{'\xe8', '\xb5', '\xb6'}, 3, 0x8D76}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xa3'}, 3, 0xFA23}, /* (CJK COMPATIBILITY IDEOGRAPH-FA23) */
    {{'\xe8', '\xbb', '\x8f'}, 3, 0x8ECF}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xa4'}, 3, 0xFA24}, /* (CJK COMPATIBILITY IDEOGRAPH-FA24) */
    {{'\xef', '\xa8', '\xa5'}, 3, 0xFA25}, /* (CJK COMPATIBILITY IDEOGRAPH-FA25) */
    {{'\xe9', '\x81', '\xa7'}, 3, 0x9067}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x83', '\x9e'}, 3, 0x90DE}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xa6'}, 3, 0xFA26}, /* (CJK COMPATIBILITY IDEOGRAPH-FA26) */
    {{'\xe9', '\x84', '\x95'}, 3, 0x9115}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x84', '\xa7'}, 3, 0x9127}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x9a'}, 3, 0x91DA}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x97'}, 3, 0x91D7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\x9e'}, 3, 0x91DE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\xad'}, 3, 0x91ED}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\xae'}, 3, 0x91EE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\xa4'}, 3, 0x91E4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x87', '\xa5'}, 3, 0x91E5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\x86'}, 3, 0x9206}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\x90'}, 3, 0x9210}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\x8a'}, 3, 0x920A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\xba'}, 3, 0x923A}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x80'}, 3, 0x9240}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\xbc'}, 3, 0x923C}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x8e'}, 3, 0x924E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x99'}, 3, 0x9259}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\x91'}, 3, 0x9251}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x88', '\xb9'}, 3, 0x9239}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\xa7'}, 3, 0x9267}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8a', '\xa7'}, 3, 0x92A7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\xb7'}, 3, 0x9277}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x89', '\xb8'}, 3, 0x9278}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xa7'}, 3, 0x92E7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\x97'}, 3, 0x92D7}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\x99'}, 3, 0x92D9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\x90'}, 3, 0x92D0}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xa7'}, 3, 0xFA27}, /* (CJK COMPATIBILITY IDEOGRAPH-FA27) */
    {{'\xe9', '\x8b', '\x95'}, 3, 0x92D5}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xa0'}, 3, 0x92E0}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\x93'}, 3, 0x92D3}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xa5'}, 3, 0x9325}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\xa1'}, 3, 0x9321}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xbb'}, 3, 0x92FB}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xa8'}, 3, 0xFA28}, /* (CJK COMPATIBILITY IDEOGRAPH-FA28) */
    {{'\xe9', '\x8c', '\x9e'}, 3, 0x931E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8b', '\xbf'}, 3, 0x92FF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\x9d'}, 3, 0x931D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8c', '\x82'}, 3, 0x9302}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\xb0'}, 3, 0x9370}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8d', '\x97'}, 3, 0x9357}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8e', '\xa4'}, 3, 0x93A4}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\x86'}, 3, 0x93C6}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\x9e'}, 3, 0x93DE}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x8f', '\xb8'}, 3, 0x93F8}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x90', '\xb1'}, 3, 0x9431}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\x85'}, 3, 0x9445}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x91', '\x88'}, 3, 0x9448}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x96', '\x92'}, 3, 0x9592}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa7', '\x9c'}, 3, 0xF9DC}, /* (CJK COMPATIBILITY IDEOGRAPH-F9DC) */
    {{'\xef', '\xa8', '\xa9'}, 3, 0xFA29}, /* (CJK COMPATIBILITY IDEOGRAPH-FA29) */
    {{'\xe9', '\x9a', '\x9d'}, 3, 0x969D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9a', '\xaf'}, 3, 0x96AF}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\xb3'}, 3, 0x9733}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9c', '\xbb'}, 3, 0x973B}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x83'}, 3, 0x9743}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x8d'}, 3, 0x974D}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x8f'}, 3, 0x974F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x91'}, 3, 0x9751}, /* (<CJK Ideograph>) */
    {{'\xe9', '\x9d', '\x95'}, 3, 0x9755}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\x97'}, 3, 0x9857}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa1', '\xa5'}, 3, 0x9865}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xaa'}, 3, 0xFA2A}, /* (CJK COMPATIBILITY IDEOGRAPH-FA2A) */
    {{'\xef', '\xa8', '\xab'}, 3, 0xFA2B}, /* (CJK COMPATIBILITY IDEOGRAPH-FA2B) */
    {{'\xe9', '\xa4', '\xa7'}, 3, 0x9927}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xac'}, 3, 0xFA2C}, /* (CJK COMPATIBILITY IDEOGRAPH-FA2C) */
    {{'\xe9', '\xa6', '\x9e'}, 3, 0x999E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xa9', '\x8e'}, 3, 0x9A4E}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\x99'}, 3, 0x9AD9}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xab', '\x9c'}, 3, 0x9ADC}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\xb5'}, 3, 0x9B75}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xad', '\xb2'}, 3, 0x9B72}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\x8f'}, 3, 0x9B8F}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\xb1'}, 3, 0x9BB1}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xae', '\xbb'}, 3, 0x9BBB}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb0', '\x80'}, 3, 0x9C00}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\xb0'}, 3, 0x9D70}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xb5', '\xab'}, 3, 0x9D6B}, /* (<CJK Ideograph>) */
    {{'\xef', '\xa8', '\xad'}, 3, 0xFA2D}, /* (CJK COMPATIBILITY IDEOGRAPH-FA2D) */
    {{'\xe9', '\xb8', '\x99'}, 3, 0x9E19}, /* (<CJK Ideograph>) */
    {{'\xe9', '\xbb', '\x91'}, 3, 0x9ED1}, /* (<CJK Ideograph>) */
};

/* Table size: 9253; Max deep: 4 */
LXB_API const lexbor_shs_hash_t lxb_encoding_multi_hash_jis0208[11349] = 
{
    {0, 0, 0},{27759, 8427, 11144},
    {27760, 3134, 0},
    {0, 0, 0},
    {27762, 1945, 0},
    {27763, 5721, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27770, 2139, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27773, 1884, 0},
    {37027, 3542, 9933},
    {0, 0, 0},
    {0, 0, 0},
    {37030, 3961, 9932},
    {27778, 5714, 0},
    {27779, 4199, 10506},
    {0, 0, 0},
    {37034, 2594, 0},
    {27782, 8426, 11143},
    {0, 0, 0},
    {27784, 3321, 0},
    {0, 0, 0},
    {37039, 7261, 0},
    {0, 0, 0},
    {27788, 3534, 10507},
    {27789, 5715, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27792, 5723, 10508},
    {0, 0, 0},
    {27794, 5722, 0},
    {27795, 2070, 9489},
    {0, 0, 0},
    {0, 0, 0},
    {27798, 1610, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27801, 2376, 0},
    {27802, 5716, 0},
    {27803, 5718, 0},
    {37057, 1483, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27809, 4002, 0},
    {27810, 3185, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37066, 2312, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37070, 4349, 0},
    {9312, 1128, 0},
    {9313, 1129, 9603},
    {9314, 1130, 0},
    {9315, 1131, 0},
    {9316, 1132, 9935},
    {9317, 1133, 0},
    {9318, 1134, 0},
    {9319, 1135, 9936},
    {9320, 1136, 0},
    {9321, 1137, 9285},
    {9322, 1138, 0},
    {9323, 1139, 0},
    {9324, 1140, 10511},
    {9325, 1141, 0},
    {9326, 1142, 9572},
    {9327, 1143, 9632},
    {9328, 1144, 9937},
    {9329, 1145, 9371},
    {9330, 1146, 9324},
    {9331, 1147, 9934},
    {27838, 5733, 0},
    {27839, 1575, 10510},
    {0, 0, 0},
    {27841, 1996, 0},
    {0, 0, 0},
    {37096, 3843, 0},
    {27844, 5724, 0},
    {27845, 5729, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37101, 1743, 0},
    {27849, 2997, 0},
    {27850, 3652, 0},
    {0, 0, 0},
    {27852, 3736, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37109, 4160, 0},
    {0, 0, 0},
    {37111, 2004, 0},
    {27859, 5726, 0},
    {0, 0, 0},
    {27861, 3948, 0},
    {0, 0, 0},
    {27863, 5728, 0},
    {37117, 3435, 0},
    {27865, 5737, 0},
    {27866, 8428, 11145},
    {27867, 5735, 0},
    {0, 0, 0},
    {27869, 5730, 10512},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27873, 3949, 0},
    {27874, 3611, 0},
    {27875, 1946, 0},
    {0, 0, 0},
    {27877, 3388, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27880, 3272, 0},
    {0, 0, 0},
    {27882, 5738, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37138, 7269, 0},
    {0, 0, 0},
    {27887, 5736, 0},
    {27888, 3158, 10906},
    {27889, 5725, 0},
    {0, 0, 0},
    {27891, 1546, 0},
    {37145, 7270, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37159, 8552, 11269},
    {0, 0, 0},
    {27908, 8429, 11146},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37165, 3385, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27915, 4181, 10513},
    {27916, 5749, 0},
    {37170, 7271, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27922, 5748, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {167, 87, 0},
    {168, 14, 9439},
    {0, 0, 0},
    {27929, 5745, 0},
    {0, 0, 0},
    {27931, 4211, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27934, 3499, 0},
    {176, 74, 9938},
    {177, 61, 0},
    {0, 0, 0},
    {0, 0, 0},
    {180, 12, 0},
    {37193, 3528, 0},
    {182, 182, 9480},
    {37195, 2653, 0},
    {37196, 2601, 0},
    {37197, 3630, 0},
    {27945, 1547, 9471},
    {27946, 2286, 0},
    {27947, 5742, 0},
    {0, 0, 0},
    {37202, 2619, 0},
    {0, 0, 0},
    {37204, 2895, 0},
    {0, 0, 0},
    {37206, 7274, 0},
    {27954, 2638, 0},
    {27955, 5747, 10515},
    {0, 0, 0},
    {27957, 5746, 0},
    {27958, 5741, 0},
    {0, 0, 0},
    {27960, 5744, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27963, 1763, 0},
    {0, 0, 0},
    {37218, 2880, 9940},
    {27966, 3612, 10516},
    {0, 0, 0},
    {37221, 7277, 0},
    {27969, 4243, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27972, 2809, 10517},
    {27973, 2998, 9647},
    {215, 62, 0},
    {37228, 2654, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9472, 658, 0},
    {9473, 669, 0},
    {9474, 659, 0},
    {9475, 670, 10518},
    {37235, 7279, 0},
    {0, 0, 0},
    {37237, 2313, 0},
    {0, 0, 0},
    {37239, 2338, 0},
    {37240, 2475, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9484, 660, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9487, 671, 9944},
    {9488, 661, 9942},
    {0, 0, 0},
    {27996, 3804, 0},
    {9491, 672, 10521},
    {9492, 663, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9495, 674, 0},
    {9496, 662, 9396},
    {28003, 5750, 0},
    {28004, 5752, 10520},
    {9499, 673, 0},
    {247, 63, 9259},
    {9501, 685, 0},
    {37261, 3174, 0},
    {28009, 2287, 0},
    {9504, 680, 9674},
    {37264, 2240, 0},
    {28012, 1720, 0},
    {9507, 675, 9429},
    {9508, 666, 9565},
    {9509, 687, 10853},
    {0, 0, 0},
    {0, 0, 0},
    {9512, 682, 9533},
    {0, 0, 0},
    {28020, 4200, 0},
    {9515, 677, 0},
    {9516, 665, 0},
    {28023, 1695, 9391},
    {28024, 2846, 0},
    {9519, 681, 9943},
    {9520, 686, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9523, 676, 10522},
    {9524, 667, 0},
    {37284, 2788, 0},
    {0, 0, 0},
    {9527, 683, 0},
    {9528, 688, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9531, 678, 9946},
    {9532, 668, 10523},
    {28039, 8430, 11147},
    {28040, 2760, 0},
    {9535, 684, 0},
    {37295, 7286, 0},
    {0, 0, 0},
    {9538, 689, 9635},
    {0, 0, 0},
    {28046, 5756, 0},
    {37300, 7289, 0},
    {37301, 7288, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37304, 2815, 9941},
    {0, 0, 0},
    {9547, 679, 9945},
    {28054, 8432, 11149},
    {0, 0, 0},
    {0, 0, 0},
    {28057, 4291, 0},
    {0, 0, 0},
    {28059, 3466, 10526},
    {28060, 3511, 10527},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37318, 3713, 0},
    {37319, 2400, 0},
    {37320, 2602, 0},
    {37321, 7293, 0},
    {0, 0, 0},
    {37323, 7294, 0},
    {37324, 4233, 0},
    {37325, 2668, 0},
    {37326, 4119, 0},
    {37327, 4273, 0},
    {37328, 7295, 0},
    {37329, 2039, 10854},
    {0, 0, 0},
    {0, 0, 0},
    {28079, 1713, 0},
    {0, 0, 0},
    {37334, 7296, 0},
    {28082, 1556, 10908},
    {37336, 3386, 0},
    {0, 0, 0},
    {28085, 5763, 10907},
    {37339, 7299, 0},
    {37340, 1779, 0},
    {37341, 2862, 9948},
    {37342, 8555, 11272},
    {37343, 7297, 0},
    {0, 0, 0},
    {28092, 4264, 10528},
    {0, 0, 0},
    {37347, 3353, 0},
    {37348, 8558, 11275},
    {28096, 4203, 10909},
    {37350, 4000, 0},
    {37351, 2065, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28101, 5773, 0},
    {28102, 5767, 0},
    {28103, 5764, 0},
    {37357, 8556, 11273},
    {37358, 8557, 11274},
    {0, 0, 0},
    {28107, 4281, 0},
    {28108, 5770, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28111, 8434, 11151},
    {37365, 7301, 0},
    {28113, 2673, 10529},
    {28114, 5772, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28117, 5777, 0},
    {0, 0, 0},
    {37372, 7300, 0},
    {28120, 3464, 0},
    {28121, 5775, 0},
    {37375, 7304, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28126, 5769, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28129, 3219, 10910},
    {0, 0, 0},
    {0, 0, 0},
    {28132, 5776, 0},
    {37386, 8562, 11279},
    {28134, 5765, 0},
    {0, 0, 0},
    {37389, 3540, 9949},
    {37390, 1726, 0},
    {9632, 96, 9950},
    {9633, 95, 9275},
    {28140, 5768, 10532},
    {0, 0, 0},
    {28142, 5779, 0},
    {37396, 7305, 0},
    {37397, 7307, 0},
    {28145, 2847, 0},
    {28146, 8436, 11153},
    {28147, 2694, 0},
    {0, 0, 0},
    {28149, 3858, 0},
    {0, 0, 0},
    {28151, 2363, 0},
    {28152, 8435, 11152},
    {28153, 5760, 10530},
    {28154, 5774, 0},
    {28155, 3409, 0},
    {9650, 98, 10855},
    {9651, 97, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37417, 7378, 0},
    {28165, 2935, 0},
    {9660, 100, 0},
    {9661, 99, 9297},
    {28168, 2398, 0},
    {28169, 2761, 0},
    {28170, 5762, 0},
    {28171, 2665, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37428, 4304, 0},
    {9670, 94, 0},
    {9671, 93, 0},
    {37431, 2219, 0},
    {28179, 2111, 0},
    {37433, 8569, 11286},
    {9675, 90, 9947},
    {0, 0, 0},
    {37436, 8565, 11282},
    {9678, 92, 0},
    {9679, 91, 9951},
    {28186, 2708, 10538},
    {28187, 2187, 10913},
    {0, 0, 0},
    {28189, 5798, 0},
    {0, 0, 0},
    {37444, 3403, 9954},
    {28192, 1963, 10534},
    {28193, 3430, 0},
    {0, 0, 0},
    {28195, 5787, 10536},
    {28196, 5796, 10535},
    {28197, 1424, 0},
    {28198, 1521, 10539},
    {28199, 8440, 11157},
    {0, 0, 0},
    {28201, 1622, 10914},
    {0, 0, 0},
    {28203, 5789, 10540},
    {28204, 3113, 10915},
    {28205, 5780, 0},
    {28206, 5782, 0},
    {28207, 2288, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37463, 7310, 0},
    {0, 0, 0},
    {37465, 8567, 11284},
    {37466, 7323, 0},
    {37467, 1587, 0},
    {0, 0, 0},
    {28216, 5799, 0},
    {9711, 187, 10533},
    {28218, 5794, 0},
    {0, 0, 0},
    {28220, 8441, 11158},
    {37474, 3678, 0},
    {28222, 5786, 0},
    {37476, 7313, 0},
    {0, 0, 0},
    {37478, 2789, 0},
    {37479, 8570, 11287},
    {28227, 5793, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28234, 4052, 0},
    {0, 0, 0},
    {37489, 2314, 0},
    {28237, 5791, 0},
    {28238, 5795, 0},
    {9733, 89, 0},
    {9734, 88, 0},
    {0, 0, 0},
    {37495, 8572, 11289},
    {37496, 8573, 11290},
    {0, 0, 0},
    {0, 0, 0},
    {28246, 2209, 0},
    {0, 0, 0},
    {28248, 2762, 0},
    {37502, 3987, 0},
    {0, 0, 0},
    {37504, 2041, 9461},
    {28252, 8439, 11156},
    {0, 0, 0},
    {37507, 2669, 0},
    {28255, 5785, 0},
    {37509, 3505, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37512, 8275, 10992},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28263, 4150, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28267, 5788, 0},
    {37521, 3020, 0},
    {65281, 9, 0},
    {28270, 5781, 10543},
    {65283, 83, 9499},
    {65284, 79, 10537},
    {65285, 82, 10542},
    {65286, 84, 9952},
    {37528, 4076, 10959},
    {65288, 41, 0},
    {65289, 42, 9478},
    {65290, 85, 9953},
    {65291, 59, 10541},
    {65292, 3, 0},
    {65293, 60, 0},
    {65294, 4, 0},
    {65295, 30, 0},
    {65296, 203, 0},
    {65297, 204, 0},
    {65298, 205, 9678},
    {65299, 206, 9378},
    {65300, 207, 9604},
    {65301, 208, 0},
    {65302, 209, 9955},
    {65303, 210, 0},
    {65304, 211, 0},
    {65305, 212, 0},
    {65306, 6, 0},
    {65307, 7, 0},
    {65308, 66, 9441},
    {65309, 64, 0},
    {65310, 67, 9254},
    {65311, 8, 0},
    {9794, 72, 9255},
    {65313, 220, 0},
    {65314, 221, 0},
    {65315, 222, 9965},
    {65316, 223, 9330},
    {65317, 224, 0},
    {65318, 225, 10547},
    {65319, 226, 0},
    {65320, 227, 10546},
    {65321, 228, 0},
    {65322, 229, 9394},
    {65323, 230, 0},
    {65324, 231, 9957},
    {65325, 232, 0},
    {65326, 233, 0},
    {65327, 234, 0},
    {65328, 235, 9654},
    {65329, 236, 9340},
    {65330, 237, 0},
    {65331, 238, 9968},
    {65332, 239, 0},
    {65333, 240, 0},
    {65334, 241, 9273},
    {65335, 242, 0},
    {65336, 243, 0},
    {65337, 244, 9966},
    {65338, 245, 0},
    {65339, 45, 0},
    {65340, 31, 0},
    {65341, 46, 0},
    {65342, 15, 9956},
    {65343, 17, 10920},
    {65344, 13, 0},
    {65345, 252, 9586},
    {65346, 253, 10923},
    {65347, 254, 9962},
    {65348, 255, 10921},
    {65349, 256, 0},
    {65350, 257, 9964},
    {65351, 258, 0},
    {9834, 179, 9256},
    {65353, 260, 0},
    {65354, 261, 9642},
    {9837, 178, 9257},
    {65356, 263, 0},
    {9839, 177, 9258},
    {65358, 265, 9491},
    {65359, 266, 10922},
    {65360, 267, 0},
    {65361, 268, 9961},
    {65362, 269, 0},
    {65363, 270, 9399},
    {65364, 271, 0},
    {65365, 272, 0},
    {65366, 273, 9967},
    {65367, 274, 0},
    {65368, 275, 9963},
    {65369, 276, 9581},
    {65370, 277, 0},
    {65371, 47, 0},
    {65372, 34, 9280},
    {65373, 48, 9958},
    {65374, 32, 0},
    {28363, 2539, 0},
    {28364, 5827, 0},
    {37618, 3797, 0},
    {37619, 3277, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28369, 1765, 0},
    {0, 0, 0},
    {37624, 1967, 9960},
    {28372, 5810, 10802},
    {28373, 5811, 10549},
    {37627, 8584, 11301},
    {37628, 2316, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37631, 8587, 11304},
    {0, 0, 0},
    {0, 0, 0},
    {28381, 3177, 10926},
    {28382, 3159, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37638, 2455, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37647, 7328, 0},
    {37648, 2896, 0},
    {28396, 5819, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28399, 5825, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28402, 5823, 0},
    {37656, 2897, 0},
    {28404, 3392, 10551},
    {37658, 7334, 0},
    {0, 0, 0},
    {28407, 5830, 0},
    {28408, 5820, 10925},
    {37662, 8586, 11303},
    {0, 0, 0},
    {37664, 2816, 0},
    {37665, 8583, 11300},
    {37666, 7333, 0},
    {28414, 5821, 10552},
    {28415, 5797, 0},
    {37669, 8582, 11299},
    {28417, 1968, 9319},
    {28418, 3785, 0},
    {37672, 3796, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28422, 2568, 9383},
    {37676, 4326, 0},
    {0, 0, 0},
    {28425, 2342, 10550},
    {37679, 2437, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37682, 4354, 0},
    {0, 0, 0},
    {28431, 4342, 0},
    {37685, 7337, 0},
    {28433, 5817, 0},
    {0, 0, 0},
    {28435, 5829, 0},
    {28436, 1576, 0},
    {28437, 3077, 10553},
    {37691, 7338, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37700, 7330, 0},
    {28448, 3660, 0},
    {0, 0, 0},
    {28450, 1818, 0},
    {28451, 4319, 10798},
    {0, 0, 0},
    {0, 0, 0},
    {37707, 3550, 0},
    {0, 0, 0},
    {37709, 3436, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28459, 4042, 0},
    {28460, 3339, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37716, 3344, 0},
    {0, 0, 0},
    {28465, 5824, 10554},
    {28466, 5826, 10927},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37723, 3230, 0},
    {37724, 7339, 0},
    {28472, 3025, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37728, 7340, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28478, 5828, 0},
    {28479, 5822, 0},
    {0, 0, 0},
    {28481, 5816, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28485, 1820, 0},
    {0, 0, 0},
    {37740, 2080, 0},
    {0, 0, 0},
    {37742, 7342, 0},
    {0, 0, 0},
    {37744, 8590, 11307},
    {65504, 80, 0},
    {65505, 81, 0},
    {65506, 137, 10957},
    {65507, 16, 0},
    {37749, 2177, 10958},
    {65509, 78, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28500, 2140, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37756, 7341, 0},
    {28504, 5842, 0},
    {37758, 2790, 0},
    {0, 0, 0},
    {28507, 5837, 0},
    {28508, 3001, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28511, 1758, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28516, 2696, 0},
    {0, 0, 0},
    {28518, 5846, 0},
    {37772, 1780, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28525, 5839, 0},
    {28526, 3301, 0},
    {28527, 5836, 10555},
    {28528, 3346, 0},
    {37782, 2380, 0},
    {37783, 3096, 0},
    {0, 0, 0},
    {28532, 5871, 0},
    {37786, 3331, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28536, 5833, 0},
    {0, 0, 0},
    {28538, 5832, 0},
    {0, 0, 0},
    {28540, 5841, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37796, 8592, 11309},
    {28544, 5835, 0},
    {28545, 5834, 0},
    {37799, 1718, 9970},
    {0, 0, 0},
    {28548, 2914, 0},
    {0, 0, 0},
    {28550, 5831, 0},
    {37804, 7345, 0},
    {37805, 7346, 10858},
    {37806, 3324, 0},
    {0, 0, 0},
    {37808, 7344, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28558, 5843, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28561, 5844, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37817, 7348, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28567, 1819, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37827, 7354, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28577, 5849, 10928},
    {0, 0, 0},
    {28579, 5848, 10560},
    {28580, 5850, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28586, 5853, 0},
    {37840, 7356, 0},
    {37841, 3396, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28593, 3418, 10556},
    {37847, 7350, 0},
    {28595, 5847, 10559},
    {0, 0, 0},
    {28597, 8444, 11161},
    {0, 0, 0},
    {0, 0, 0},
    {37853, 7355, 0},
    {28601, 5851, 10929},
    {0, 0, 0},
    {0, 0, 0},
    {37857, 2005, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37860, 7358, 0},
    {28608, 2134, 10558},
    {28609, 3190, 0},
    {28610, 5845, 0},
    {28611, 3598, 10557},
    {0, 0, 0},
    {0, 0, 0},
    {28614, 5852, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37880, 8595, 11312},
    {28628, 5857, 0},
    {28629, 5855, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28632, 5858, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28635, 5861, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37891, 7362, 0},
    {28639, 5854, 0},
    {28640, 2329, 0},
    {28641, 3579, 0},
    {37895, 7363, 0},
    {0, 0, 0},
    {28644, 5758, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28651, 4219, 10563},
    {28652, 5856, 0},
    {0, 0, 0},
    {28654, 5860, 10562},
    {28655, 3186, 10561},
    {0, 0, 0},
    {28657, 5859, 0},
    {0, 0, 0},
    {37912, 2791, 9969},
    {37913, 3487, 0},
    {37914, 7359, 10859},
    {28662, 7404, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28666, 5864, 0},
    {0, 0, 0},
    {37921, 7368, 0},
    {0, 0, 0},
    {28670, 5868, 0},
    {0, 0, 0},
    {913, 470, 0},
    {914, 471, 9973},
    {915, 472, 0},
    {916, 473, 0},
    {917, 474, 0},
    {918, 475, 10860},
    {919, 476, 10565},
    {920, 477, 10861},
    {921, 478, 0},
    {922, 479, 9971},
    {923, 480, 0},
    {924, 481, 9972},
    {925, 482, 10930},
    {926, 483, 0},
    {927, 484, 0},
    {928, 485, 9974},
    {929, 486, 10566},
    {28689, 5865, 10564},
    {931, 487, 0},
    {932, 488, 9456},
    {933, 489, 0},
    {934, 490, 9560},
    {935, 491, 0},
    {936, 492, 0},
    {937, 493, 9975},
    {0, 0, 0},
    {28698, 5870, 0},
    {28699, 5869, 0},
    {37953, 7370, 0},
    {28701, 5872, 0},
    {28702, 3529, 0},
    {28703, 5874, 10569},
    {945, 502, 10931},
    {946, 503, 0},
    {947, 504, 0},
    {948, 505, 10932},
    {949, 506, 0},
    {950, 507, 0},
    {951, 508, 9473},
    {952, 509, 9455},
    {953, 510, 10862},
    {954, 511, 0},
    {955, 512, 0},
    {956, 513, 0},
    {957, 514, 9303},
    {958, 515, 10568},
    {959, 516, 9630},
    {960, 517, 0},
    {961, 518, 9976},
    {0, 0, 0},
    {963, 519, 9977},
    {964, 520, 0},
    {965, 521, 0},
    {966, 522, 10572},
    {967, 523, 10570},
    {968, 524, 0},
    {969, 525, 0},
    {37982, 7376, 0},
    {0, 0, 0},
    {37984, 7374, 0},
    {0, 0, 0},
    {37986, 7375, 0},
    {28734, 5876, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {37994, 7377, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38000, 7379, 0},
    {28748, 5818, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38005, 7380, 0},
    {28753, 5878, 0},
    {38007, 7381, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38012, 7384, 0},
    {28760, 3548, 10571},
    {38014, 7385, 0},
    {38015, 7387, 0},
    {0, 0, 0},
    {38017, 7386, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28771, 5879, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28779, 1645, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28783, 3467, 0},
    {1025, 570, 9289},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28792, 1947, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28796, 2599, 0},
    {28797, 2399, 0},
    {0, 0, 0},
    {1040, 564, 0},
    {1041, 565, 0},
    {1042, 566, 0},
    {1043, 567, 0},
    {1044, 568, 0},
    {1045, 569, 0},
    {1046, 571, 10863},
    {1047, 572, 0},
    {1048, 573, 0},
    {1049, 574, 0},
    {1050, 575, 9673},
    {1051, 576, 9421},
    {1052, 577, 0},
    {1053, 578, 0},
    {1054, 579, 0},
    {1055, 580, 9282},
    {1056, 581, 0},
    {1057, 582, 0},
    {1058, 583, 0},
    {1059, 584, 9979},
    {1060, 585, 0},
    {1061, 586, 0},
    {1062, 587, 0},
    {1063, 588, 0},
    {1064, 589, 0},
    {1065, 590, 0},
    {1066, 591, 9978},
    {1067, 592, 0},
    {1068, 593, 0},
    {1069, 594, 0},
    {1070, 595, 0},
    {1071, 596, 0},
    {1072, 612, 0},
    {1073, 613, 0},
    {1074, 614, 0},
    {1075, 615, 0},
    {1076, 616, 0},
    {1077, 617, 0},
    {1078, 619, 0},
    {1079, 620, 0},
    {1080, 621, 0},
    {1081, 622, 0},
    {1082, 623, 0},
    {1083, 624, 0},
    {1084, 625, 10864},
    {1085, 626, 9981},
    {1086, 627, 9462},
    {1087, 628, 9984},
    {1088, 629, 9980},
    {1089, 630, 0},
    {1090, 631, 0},
    {1091, 632, 0},
    {1092, 633, 9983},
    {1093, 634, 0},
    {1094, 635, 0},
    {1095, 636, 0},
    {1096, 637, 0},
    {1097, 638, 9982},
    {1098, 639, 9494},
    {1099, 640, 9271},
    {1100, 641, 10800},
    {1101, 642, 0},
    {1102, 643, 0},
    {1103, 644, 0},
    {0, 0, 0},
    {1105, 618, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28872, 4314, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28875, 5889, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28879, 1511, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28889, 5891, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28893, 5890, 0},
    {0, 0, 0},
    {28895, 5888, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28913, 5883, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28921, 3950, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28925, 5893, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28932, 8452, 11169},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28937, 5892, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28943, 8451, 11168},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28948, 1578, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28953, 5895, 0},
    {28954, 3871, 0},
    {0, 0, 0},
    {28956, 5894, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28961, 4062, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28966, 2764, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28982, 3026, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28988, 2763, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {28998, 8454, 11171},
    {28999, 8455, 11172},
    {0, 0, 0},
    {29001, 4320, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29004, 5901, 0},
    {0, 0, 0},
    {29006, 3002, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38263, 3314, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29013, 5897, 0},
    {29014, 5902, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29017, 1579, 0},
    {0, 0, 0},
    {38272, 4112, 0},
    {29020, 8453, 11170},
    {38274, 7388, 0},
    {38275, 3021, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29026, 5900, 10573},
    {0, 0, 0},
    {29028, 3636, 9577},
    {29029, 5896, 10574},
    {38283, 1702, 9985},
    {29031, 2765, 0},
    {0, 0, 0},
    {29033, 3714, 0},
    {38287, 1531, 0},
    {0, 0, 0},
    {38289, 1840, 9986},
    {38290, 8599, 11316},
    {38291, 1839, 9381},
    {38292, 7391, 0},
    {0, 0, 0},
    {38294, 7392, 0},
    {0, 0, 0},
    {38296, 7393, 0},
    {38297, 7394, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38304, 7395, 0},
    {0, 0, 0},
    {38306, 1841, 9440},
    {38307, 1744, 0},
    {38308, 2317, 0},
    {38309, 3687, 0},
    {0, 0, 0},
    {38311, 7397, 0},
    {38312, 7396, 0},
    {29060, 5906, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29064, 5898, 10575},
    {0, 0, 0},
    {29066, 2074, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38322, 1563, 0},
    {0, 0, 0},
    {29071, 5904, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29076, 4183, 10576},
    {29077, 5907, 0},
    {38331, 7400, 0},
    {38332, 7399, 0},
    {0, 0, 0},
    {38334, 7402, 10797},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38339, 7405, 0},
    {29087, 2678, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38343, 1448, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38346, 7403, 0},
    {0, 0, 0},
    {38348, 7407, 0},
    {29096, 5908, 10577},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29100, 5909, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38356, 7409, 0},
    {38357, 7408, 0},
    {29105, 3585, 10578},
    {0, 0, 0},
    {38360, 3491, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38364, 7411, 0},
    {0, 0, 0},
    {29113, 5911, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38369, 7412, 0},
    {38370, 7414, 0},
    {29118, 5912, 0},
    {0, 0, 0},
    {38373, 7413, 0},
    {29121, 8457, 11174},
    {0, 0, 0},
    {29123, 3590, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29128, 3468, 0},
    {29129, 5914, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29134, 5916, 0},
    {0, 0, 0},
    {29136, 4282, 0},
    {0, 0, 0},
    {29138, 5913, 0},
    {0, 0, 0},
    {29140, 5915, 0},
    {29141, 1580, 0},
    {0, 0, 0},
    {29143, 5910, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29151, 4758, 0},
    {29152, 5917, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29157, 3078, 0},
    {29158, 2467, 0},
    {29159, 5919, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29164, 5918, 0},
    {29165, 2823, 0},
    {29166, 4662, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29173, 5920, 0},
    {0, 0, 0},
    {38428, 3835, 0},
    {0, 0, 0},
    {29177, 5922, 0},
    {0, 0, 0},
    {29179, 5905, 0},
    {29180, 5921, 10579},
    {0, 0, 0},
    {29182, 8458, 11175},
    {29183, 5923, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38440, 7416, 0},
    {0, 0, 0},
    {38442, 2418, 0},
    {29190, 3661, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38446, 7417, 0},
    {38447, 7418, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38450, 3988, 9987},
    {0, 0, 0},
    {0, 0, 0},
    {29200, 5925, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38459, 3050, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38463, 1413, 0},
    {38464, 3144, 9988},
    {0, 0, 0},
    {38466, 7419, 0},
    {0, 0, 0},
    {38468, 3836, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {19968, 1485, 0},
    {19969, 3285, 10581},
    {38476, 7420, 0},
    {38477, 2318, 9376},
    {0, 0, 0},
    {29226, 3351, 10580},
    {38480, 2195, 0},
    {19975, 4039, 9991},
    {19976, 2795, 9990},
    {19977, 2459, 0},
    {19978, 2794, 0},
    {19979, 1625, 9992},
    {0, 0, 0},
    {19981, 3811, 9993},
    {19982, 4166, 0},
    {0, 0, 0},
    {29237, 2600, 9680},
    {19985, 1518, 9566},
    {38492, 7424, 0},
    {38493, 7426, 0},
    {19988, 1769, 10583},
    {29242, 4117, 9681},
    {19990, 2917, 9994},
    {19991, 4639, 9995},
    {38498, 1504, 9311},
    {29246, 2541, 9419},
    {38500, 2723, 9996},
    {38501, 1842, 9997},
    {38502, 7428, 0},
    {0, 0, 0},
    {19998, 2796, 0},
    {0, 0, 0},
    {38506, 3641, 0},
    {20001, 4259, 9998},
    {29255, 3903, 10585},
    {29256, 3704, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38512, 1505, 9576},
    {29260, 3626, 0},
    {38514, 7429, 10804},
    {38515, 3325, 0},
    {20010, 4421, 0},
    {38517, 4274, 0},
    {38518, 3488, 0},
    {20013, 3265, 9476},
    {38520, 4235, 0},
    {0, 0, 0},
    {38522, 2178, 0},
    {20017, 4422, 0},
    {20018, 2063, 0},
    {38525, 4194, 10000},
    {29273, 1668, 0},
    {0, 0, 0},
    {29275, 1956, 9682},
    {0, 0, 0},
    {20024, 1846, 9618},
    {20025, 3211, 0},
    {29279, 4063, 0},
    {38533, 2062, 9384},
    {29281, 1617, 9656},
    {29282, 4343, 0},
    {38536, 2075, 0},
    {20031, 4425, 0},
    {38538, 3167, 0},
    {38539, 6580, 0},
    {29287, 3997, 9684},
    {20035, 3592, 10586},
    {38542, 1703, 9573},
    {20037, 1934, 9422},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38548, 1745, 0},
    {20043, 3594, 10588},
    {0, 0, 0},
    {29298, 2936, 9511},
    {20046, 2196, 10587},
    {38553, 2135, 9589},
    {0, 0, 0},
    {38555, 2410, 0},
    {38556, 2792, 0},
    {38557, 8602, 11319},
    {29305, 3512, 0},
    {20053, 6808, 0},
    {38560, 1506, 9685},
    {20055, 2797, 0},
    {29309, 2164, 9686},
    {20057, 1618, 9661},
    {0, 0, 0},
    {29312, 2401, 0},
    {29313, 5942, 0},
    {20061, 2042, 10003},
    {20062, 2241, 10503},
    {20063, 4114, 0},
    {38570, 7435, 0},
    {0, 0, 0},
    {20066, 4987, 10004},
    {0, 0, 0},
    {0, 0, 0},
    {38575, 8603, 11320},
    {38576, 7439, 0},
    {38577, 7437, 0},
    {38578, 7438, 0},
    {0, 0, 0},
    {38580, 7440, 0},
    {0, 0, 0},
    {38582, 7441, 0},
    {38583, 4305, 10005},
    {38584, 7442, 0},
    {38585, 7443, 0},
    {0, 0, 0},
    {38587, 2954, 9648},
    {38588, 3692, 0},
    {20083, 3570, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38592, 2912, 0},
    {38593, 1856, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38596, 4161, 0},
    {38597, 1674, 9308},
    {38598, 2655, 0},
    {38599, 2220, 10007},
    {20094, 1790, 0},
    {38601, 7446, 0},
    {20096, 1900, 0},
    {38603, 7445, 0},
    {38604, 2526, 9687},
    {38605, 7447, 0},
    {38606, 7444, 0},
    {20101, 4430, 0},
    {20102, 4256, 0},
    {29356, 2165, 9362},
    {20104, 4164, 0},
    {20105, 3079, 0},
    {29359, 3705, 9688},
    {20107, 2529, 10592},
    {20108, 3560, 10381},
    {29362, 5949, 0},
    {20110, 4435, 0},
    {38617, 4659, 0},
    {0, 0, 0},
    {20113, 1533, 9412},
    {20114, 2224, 10591},
    {0, 0, 0},
    {20116, 2223, 10009},
    {20117, 1479, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38626, 4234, 9677},
    {38627, 3558, 9676},
    {0, 0, 0},
    {20123, 2368, 0},
    {20124, 1410, 0},
    {29378, 1997, 0},
    {38632, 1514, 9689},
    {20127, 4437, 10012},
    {38634, 2980, 9690},
    {38635, 2559, 9590},
    {20130, 4439, 0},
    {0, 0, 0},
    {20132, 2243, 0},
    {20133, 1480, 0},
    {38640, 3876, 9600},
    {0, 0, 0},
    {38642, 1535, 9313},
    {29390, 5953, 0},
    {0, 0, 0},
    {20139, 1972, 9333},
    {20140, 1973, 9666},
    {20141, 3355, 9646},
    {20142, 4257, 0},
    {38649, 7452, 0},
    {20144, 4440, 0},
    {38651, 3420, 0},
    {29399, 2046, 0},
    {20147, 4441, 0},
    {29401, 3039, 0},
    {0, 0, 0},
    {29403, 2348, 9388},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20154, 2864, 10593},
    {29408, 5956, 0},
    {29409, 5957, 10594},
    {38663, 2863, 10014},
    {38664, 7455, 0},
    {0, 0, 0},
    {20160, 2657, 9667},
    {20161, 2865, 0},
    {20162, 4447, 0},
    {38669, 7450, 0},
    {29417, 2614, 9692},
    {38671, 7459, 0},
    {20166, 4446, 0},
    {20167, 1935, 9508},
    {29421, 1998, 0},
    {38675, 7456, 0},
    {20170, 2352, 0},
    {20171, 1677, 0},
    {38678, 7460, 0},
    {20173, 4444, 0},
    {20174, 4443, 0},
    {20175, 3862, 10597},
    {0, 0, 0},
    {0, 0, 0},
    {38684, 3097, 10016},
    {29432, 3207, 0},
    {38686, 1663, 9368},
    {20181, 2480, 0},
    {20182, 3131, 0},
    {29436, 4344, 9693},
    {29437, 3637, 9562},
    {20185, 2984, 0},
    {38692, 7462, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20189, 23, 9612},
    {20190, 4449, 0},
    {20191, 4451, 0},
    {38698, 7463, 0},
    {20193, 8285, 11002},
    {0, 0, 0},
    {20195, 3170, 0},
    {20196, 4294, 0},
    {20197, 1451, 10019},
    {38704, 7464, 0},
    {0, 0, 0},
    {38706, 4333, 0},
    {38707, 8604, 11321},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20205, 4450, 0},
    {20206, 1627, 9884},
    {38713, 7465, 0},
    {20208, 2009, 0},
    {29462, 5964, 10935},
    {20210, 3266, 10018},
    {38717, 7466, 0},
    {38718, 7467, 0},
    {0, 0, 0},
    {20214, 2146, 9621},
    {20215, 4452, 10020},
    {29469, 5965, 10599},
    {38723, 8606, 11323},
    {29471, 4265, 10598},
    {20219, 3575, 0},
    {38726, 7469, 10805},
    {0, 0, 0},
    {38728, 7470, 0},
    {38729, 7472, 10868},
    {29477, 5969, 10806},
    {20225, 1860, 0},
    {0, 0, 0},
    {20227, 8288, 10936},
    {29481, 5968, 0},
    {29482, 3281, 10937},
    {29483, 3584, 0},
    {38737, 8609, 11326},
    {38738, 2949, 0},
    {29486, 2166, 9694},
    {20234, 1452, 10022},
    {38741, 8610, 11327},
    {38742, 4128, 0},
    {20237, 2225, 0},
    {20238, 1861, 0},
    {38745, 2950, 9569},
    {20240, 3683, 0},
    {20241, 1936, 9636},
    {29495, 4153, 10600},
    {0, 0, 0},
    {38750, 3748, 0},
    {0, 0, 0},
    {38752, 7474, 0},
    {38753, 7758, 0},
    {38754, 4085, 0},
    {29502, 5970, 0},
    {29503, 1581, 9288},
    {0, 0, 0},
    {20252, 4488, 10602},
    {20253, 3416, 0},
    {38760, 7477, 0},
    {38761, 1746, 9348},
    {29509, 2509, 0},
    {38763, 7479, 0},
    {0, 0, 0},
    {38765, 2876, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38769, 7480, 0},
    {0, 0, 0},
    {29518, 5971, 0},
    {38772, 2071, 10023},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20271, 3647, 10603},
    {20272, 4455, 10605},
    {0, 0, 0},
    {29527, 5974, 10604},
    {0, 0, 0},
    {20276, 3693, 0},
    {0, 0, 0},
    {20278, 4295, 0},
    {38785, 7484, 0},
    {20280, 2832, 0},
    {20281, 8289, 11006},
    {38788, 1774, 9369},
    {38789, 7482, 0},
    {20284, 2530, 10606},
    {20285, 1629, 0},
    {29539, 2666, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38795, 7487, 0},
    {0, 0, 0},
    {38797, 1449, 9481},
    {0, 0, 0},
    {29546, 5975, 10607},
    {20294, 3197, 10608},
    {20295, 4459, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29552, 5977, 0},
    {0, 0, 0},
    {20301, 1453, 9294},
    {38808, 2793, 9485},
    {20303, 2658, 0},
    {20304, 2369, 10026},
    {20305, 4139, 0},
    {38812, 7490, 10870},
    {20307, 3147, 10025},
    {0, 0, 0},
    {20309, 1628, 10028},
    {38816, 1918, 10027},
    {20311, 4458, 0},
    {0, 0, 0},
    {20313, 4165, 10611},
    {20314, 4454, 0},
    {20315, 4456, 0},
    {20316, 2427, 10610},
    {20317, 4457, 0},
    {20318, 4891, 10609},
    {29572, 2189, 0},
    {0, 0, 0},
    {38827, 7036, 0},
    {29575, 4237, 0},
    {38829, 3913, 0},
    {29577, 2017, 0},
    {0, 0, 0},
    {29579, 1603, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20329, 4465, 10612},
    {38836, 7495, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20335, 4468, 0},
    {20336, 4466, 0},
    {29590, 2047, 0},
    {0, 0, 0},
    {20339, 1631, 0},
    {0, 0, 0},
    {20341, 3880, 0},
    {20342, 4460, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38851, 7496, 0},
    {0, 0, 0},
    {20347, 4464, 0},
    {20348, 2244, 10613},
    {0, 0, 0},
    {38856, 7498, 0},
    {20351, 2483, 0},
    {0, 0, 0},
    {38859, 7499, 0},
    {0, 0, 0},
    {20355, 1791, 0},
    {29609, 1850, 0},
    {0, 0, 0},
    {20358, 4469, 0},
    {0, 0, 0},
    {20360, 4461, 0},
    {38867, 1843, 0},
    {20362, 8292, 11009},
    {20363, 4296, 0},
    {0, 0, 0},
    {20365, 2531, 9664},
    {29619, 5983, 0},
    {20367, 4462, 0},
    {0, 0, 0},
    {20369, 4467, 0},
    {38876, 7500, 10808},
    {0, 0, 0},
    {20372, 8294, 11011},
    {0, 0, 0},
    {20374, 4470, 10030},
    {0, 0, 0},
    {20376, 4463, 10871},
    {0, 0, 0},
    {20378, 8293, 11010},
    {20379, 1974, 10031},
    {0, 0, 0},
    {20381, 1454, 9286},
    {0, 0, 0},
    {0, 0, 0},
    {20384, 1975, 0},
    {20385, 1630, 0},
    {0, 0, 0},
    {29640, 5982, 10614},
    {38894, 3574, 10872},
    {29642, 2468, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29645, 3322, 10615},
    {38899, 1624, 10029},
    {0, 0, 0},
    {20395, 4892, 10616},
    {38902, 7505, 0},
    {20397, 4036, 10875},
    {20398, 3837, 0},
    {20399, 2245, 0},
    {0, 0, 0},
    {38907, 1507, 10873},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38911, 2006, 9414},
    {20406, 4252, 0},
    {38913, 3892, 0},
    {38914, 3315, 0},
    {38915, 2351, 10033},
    {0, 0, 0},
    {38917, 2319, 9385},
    {38918, 2702, 0},
    {0, 0, 0},
    {38920, 2879, 10874},
    {20415, 3909, 0},
    {29669, 5987, 0},
    {0, 0, 0},
    {20418, 2091, 10618},
    {20419, 3106, 0},
    {20420, 1665, 0},
    {29674, 2097, 10617},
    {38928, 4169, 0},
    {38929, 1857, 0},
    {29677, 3706, 9538},
    {38931, 3537, 10032},
    {20426, 2682, 0},
    {0, 0, 0},
    {29681, 6015, 0},
    {38935, 2911, 10809},
    {38936, 4275, 9695},
    {0, 0, 0},
    {38938, 2126, 9696},
    {20433, 4477, 0},
    {0, 0, 0},
    {29688, 5994, 0},
    {20436, 4472, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20439, 3116, 10621},
    {20440, 4475, 0},
    {29694, 2190, 0},
    {20442, 4478, 10620},
    {20443, 4476, 0},
    {0, 0, 0},
    {20445, 3914, 0},
    {29699, 1948, 0},
    {20447, 4473, 0},
    {29701, 5991, 0},
    {20449, 2833, 9651},
    {38956, 3990, 10876},
    {38957, 3489, 9601},
    {29705, 4245, 9697},
    {20453, 4481, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38964, 1551, 0},
    {0, 0, 0},
    {0, 0, 0},
    {38967, 7512, 0},
    {20462, 2635, 10619},
    {20463, 4494, 0},
    {0, 0, 0},
    {38971, 3808, 0},
    {38972, 4209, 0},
    {20467, 3619, 10622},
    {0, 0, 0},
    {20469, 3781, 0},
    {20470, 4489, 0},
    {0, 0, 0},
    {20472, 3933, 0},
    {0, 0, 0},
    {20474, 1619, 0},
    {0, 0, 0},
    {38982, 7514, 0},
    {29730, 3187, 0},
    {20478, 4493, 0},
    {20479, 8298, 11015},
    {29733, 5993, 0},
    {38987, 7516, 10878},
    {38988, 3175, 0},
    {38989, 1750, 0},
    {38990, 1751, 10880},
    {20485, 4487, 10623},
    {20486, 4496, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20489, 3057, 10881},
    {38996, 1858, 0},
    {38997, 2179, 9331},
    {0, 0, 0},
    {20493, 3631, 10035},
    {39000, 1859, 9660},
    {29748, 2028, 10017},
    {29749, 3757, 0},
    {39003, 3414, 9522},
    {20498, 3444, 0},
    {0, 0, 0},
    {39006, 4293, 9698},
    {29754, 5996, 0},
    {20502, 2247, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20505, 2246, 0},
    {20506, 4482, 10036},
    {39013, 8612, 11329},
    {29761, 6001, 0},
    {39015, 2221, 0},
    {20510, 8299, 11016},
    {20511, 2595, 0},
    {0, 0, 0},
    {20513, 4490, 10624},
    {20514, 8297, 11014},
    {20515, 3932, 0},
    {20516, 3240, 0},
    {20517, 4486, 10625},
    {20518, 2148, 10626},
    {39025, 7520, 0},
    {20520, 4483, 0},
    {20521, 4491, 10628},
    {20522, 4485, 10627},
    {20523, 4278, 0},
    {20524, 4492, 0},
    {20525, 4356, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29781, 5997, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29785, 6000, 0},
    {29786, 2235, 0},
    {29787, 1548, 9320},
    {29788, 6002, 0},
    {0, 0, 0},
    {20537, 2147, 9423},
    {29791, 5999, 0},
    {29792, 4289, 0},
    {0, 0, 0},
    {29794, 8475, 11192},
    {29795, 6005, 0},
    {29796, 7805, 0},
    {20544, 8296, 11013},
    {0, 0, 0},
    {20546, 8302, 11019},
    {20547, 4497, 0},
    {29801, 6003, 0},
    {29802, 6006, 0},
    {20550, 8300, 11017},
    {20551, 4498, 0},
    {20552, 4502, 0},
    {20553, 1455, 0},
    {29807, 5992, 0},
    {29808, 6004, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29811, 2377, 0},
    {20559, 3901, 0},
    {20560, 4501, 0},
    {29814, 6007, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20565, 4500, 0},
    {20566, 4504, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29822, 6008, 0},
    {20570, 4503, 0},
    {0, 0, 0},
    {20572, 3357, 0},
    {0, 0, 0},
    {39080, 3846, 9652},
    {0, 0, 0},
    {39082, 7523, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29833, 8476, 11193},
    {20581, 2149, 10629},
    {29835, 6009, 0},
    {39089, 7525, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20588, 4505, 10630},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20592, 8301, 11018},
    {0, 0, 0},
    {20594, 2574, 0},
    {0, 0, 0},
    {20596, 3107, 0},
    {20597, 3358, 0},
    {20598, 2059, 0},
    {0, 0, 0},
    {20600, 4506, 0},
    {29854, 6010, 10631},
    {39108, 7527, 10882},
    {0, 0, 0},
    {39110, 7529, 0},
    {20605, 1901, 10034},
    {0, 0, 0},
    {0, 0, 0},
    {20608, 4507, 0},
    {0, 0, 0},
    {29863, 6011, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20613, 4509, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29872, 1821, 0},
    {0, 0, 0},
    {20621, 3968, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20625, 2137, 9545},
    {39132, 6529, 0},
    {0, 0, 0},
    {20628, 8303, 11020},
    {39135, 2828, 0},
    {0, 0, 0},
    {0, 0, 0},
    {39138, 1897, 9363},
    {20633, 3752, 0},
    {20634, 4508, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {39145, 7530, 0},
    {0, 0, 0},
    {39147, 7531, 0},
    {0, 0, 0},
    {39149, 4617, 0},
    {39150, 5666, 0},
    {39151, 3716, 10037},
    {0, 0, 0},
    {0, 0, 0},
    {39154, 1500, 0},
    {0, 0, 0},
    {39156, 1436, 10038},
    {0, 0, 0},
    {20652, 2386, 0},
    {20653, 4170, 0},
    {0, 0, 0},
    {29908, 6014, 0},
    {0, 0, 0},
    {0, 0, 0},
    {39164, 2527, 9701},
    {39165, 3963, 9703},
    {39166, 2819, 9700},
    {20661, 2385, 0},
    {0, 0, 0},
    {29916, 1530, 9400},
    {0, 0, 0},
    {39171, 7532, 0},
    {0, 0, 0},
    {39173, 4104, 10039},
    {0, 0, 0},
    {29922, 3786, 0},
    {20670, 2092, 10040},
    {39177, 7533, 0},
    {39178, 4195, 0},
    {29926, 1789, 0},
    {39180, 1537, 9704},
    {0, 0, 0},
    {29929, 6019, 0},
    {20677, 2020, 0},
    {39184, 2476, 0},
    {0, 0, 0},
    {39186, 7534, 0},
    {39187, 1675, 9702},
    {20682, 4513, 10632},
    {29936, 6022, 0},
    {29937, 6023, 0},
    {20685, 3492, 10043},
    {39192, 7536, 0},
    {20687, 3099, 0},
    {0, 0, 0},
    {20689, 1976, 9561},
    {29943, 6025, 0},
    {29944, 6024, 10633},
    {39198, 7539, 0},
    {20693, 3992, 0},
    {20694, 4516, 10635},
    {39201, 7537, 0},
    {20696, 8305, 11022},
    {0, 0, 0},
    {20698, 4258, 10634},
    {0, 0, 0},
    {29953, 8478, 11195},
    {39207, 8615, 11332},
    {39208, 1844, 9705},
    {29956, 6026, 0},
    {29957, 6028, 0},
    {0, 0, 0},
    {39212, 7542, 0},
    {20707, 4520, 0},
    {39214, 7543, 0},
    {20709, 4518, 0},
    {0, 0, 0},
    {20711, 3053, 10045},
    {29965, 6031, 0},
    {29966, 6030, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29969, 2344, 0},
    {20717, 4519, 0},
    {20718, 4521, 10046},
    {0, 0, 0},
    {29973, 6032, 0},
    {0, 0, 0},
    {0, 0, 0},
    {29976, 1822, 10636},
    {39230, 7545, 10810},
    {29978, 2870, 9706},
    {0, 0, 0},
    {29980, 3411, 0},
    {39234, 7546, 0},
    {20729, 4522, 10047},
    {29983, 2937, 0},
    {20731, 3893, 10637},
    {0, 0, 0},
    {0, 0, 0},
    {29987, 2469, 0},
    {39241, 7547, 0},
    {29989, 1592, 9306},
    {20737, 4525, 10048},
    {20738, 4526, 10641},
    {29992, 4184, 0},
    {20740, 1612, 0},
    {0, 0, 0},
    {29995, 3920, 10638},
    {29996, 6036, 10640},
    {39250, 7552, 0},
    {20745, 4524, 0},
    {29999, 8347, 11064},
    {30000, 3419, 10642},
    {30001, 4154, 0},
    {39255, 2007, 9341},
    {30003, 2848, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20754, 2621, 9467},
    {30008, 4625, 0},
    {20756, 4529, 0},
    {30010, 3303, 9708},
    {30011, 1669, 9707},
    {30012, 6037, 0},
    {20760, 4471, 0},
    {0, 0, 0},
    {20762, 4530, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20767, 2725, 10049},
    {0, 0, 0},
    {20769, 4531, 10050},
    {0, 0, 0},
    {0, 0, 0},
    {30025, 6041, 0},
    {30026, 6040, 0},
    {30027, 5391, 0},
    {30028, 1697, 0},
    {30029, 6039, 0},
    {0, 0, 0},
    {30031, 1467, 9633},
    {0, 0, 0},
    {30033, 3675, 0},
    {0, 0, 0},
    {0, 0, 0},
    {30036, 3707, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20786, 4098, 0},
    {0, 0, 0},
    {30041, 4246, 0},
    {30042, 6044, 0},
    {30043, 6042, 0},
    {30044, 3255, 9709},
    {30045, 2919, 0},
    {0, 0, 0},
    {20794, 4532, 0},
    {30048, 3676, 9710},
    {20796, 4534, 0},
    {30050, 3772, 0},
    {0, 0, 0},
    {20799, 4536, 10052},
    {30053, 4241, 9711},
    {20801, 1493, 9325},
    {30055, 6047, 0},
    {20803, 2182, 0},
    {20804, 2094, 10051},
    {20805, 2659, 9539},
    {20806, 3286, 10053},
    {20807, 1977, 0},
    {20808, 2985, 10054},
    {20809, 2248, 0},
    {20810, 8306, 10883},
    {30064, 1468, 9345},
    {39318, 2620, 9713},
    {20813, 4081, 10643},
    {30067, 2811, 9495},
    {39321, 2320, 10056},
    {20816, 2532, 0},
    {30070, 6051, 0},
    {30071, 3554, 9712},
    {30072, 6050, 0},
    {20820, 4540, 10940},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {30079, 1885, 9497},
    {39333, 7557, 0},
    {20828, 1776, 0},
    {30082, 6057, 0},
    {39336, 1721, 0},
    {0, 0, 0},
    {0, 0, 0},
    {30086, 6052, 0},
    {39340, 3618, 9714},
    {39341, 7558, 0},
    {30089, 6056, 10645},
    {20837, 3571, 10057},
    {30091, 3764, 0},
    {0, 0, 0},
    {20840, 3027, 0},
    {30094, 3041, 9469},
    {30095, 3040, 9512},
    {20843, 3677, 0},
    {30097, 1910, 9336},
    {20845, 4350, 0},
    {20846, 4545, 0},
    {30100, 6058, 0},
    {0, 0, 0},
    {20849, 1979, 0},
    {39356, 7560, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20853, 3881, 10058},
    {20854, 3123, 0},
    {20855, 2054, 9530},
    {20856, 3404, 10059},
    {0, 0, 0},
    {39364, 3145, 0},
    {39365, 1559, 0},
    {39366, 2051, 9327},
    {0, 0, 0},
    {39368, 2052, 10061},
    {0, 0, 0},
    {20864, 4546, 10060},
    {0, 0, 0},
    {20866, 4547, 0},
    {0, 0, 0},
    {0, 0, 0},
    {20869, 3543, 0},
    {30123, 1557, 9281},
    {39377, 7565, 0},
    {39378, 2053, 0},
    {20873, 4550, 0},
    {20874, 2442, 0},
    {39381, 1676, 0},
    {20876, 4549, 10064},
    {20877, 2387, 9542},
    {30131, 6064, 10649},
    {20879, 4551, 0},
    {30133, 6066, 10263},
    {20881, 4552, 10647},
    {20882, 3980, 0},
    {20883, 4553, 10062},
    {30137, 2849, 0},
    {20885, 4554, 10646},
    {20886, 4555, 0},
    {20887, 2798, 10063},
    {30141, 6067, 10655},
    {30142, 2569, 9380},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {30146, 6063, 10812},
    {30147, 6065, 0},
    {0, 0, 0},
    {20896, 1792, 9557},
    {0, 0, 0},
    {30151, 2766, 9717},
    {39405, 7566, 0},
    {20900, 4556, 10650},
    {20901, 4070, 10066},
    {20902, 4557, 0},
    {39409, 7568, 0},
    {20904, 3817, 10065},
    {20905, 4559, 0},
    {20906, 4560, 0},
    {20907, 4561, 0},
    {20908, 3446, 0},
    {30162, 6073, 0},
    {39416, 7571, 0},
    {30164, 2543, 0},
    {30165, 2364, 9719},
    {20913, 4563, 10652},
    {20914, 4564, 0},
    {30168, 3470, 9718},
    {20916, 2416, 10067},
    {39423, 2688, 9720},
    {30171, 3332, 9624},
    {20919, 4297, 10653},
    {0, 0, 0},
    {30174, 6076, 0},
    {0, 0, 0},
    {39429, 7574, 0},
    {0, 0, 0},
    {30178, 4230, 9721},
    {30179, 6075, 10813},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {39438, 1898, 9427},
    {20933, 4568, 10654},
    {20934, 2689, 0},
    {0, 0, 0},
    {39442, 3098, 0},
    {39443, 2180, 9722},
    {0, 0, 0},
    {20939, 3287, 10068},
    {20940, 4260, 0},
    {20941, 3447, 10069},
    {30195, 6084, 0},
    {30196, 3247, 10656},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {30202, 6082, 0},
    {20950, 4642, 0},
    {30204, 6079, 0},
    {0, 0, 0},
    {30206, 6077, 0},
    {30207, 6078, 0},
    {20955, 4570, 0},
    {30209, 6080, 10796},
    {20957, 2010, 0},
    {39464, 3146, 0},
    {0, 0, 0},
    {20960, 4571, 0},
    {20961, 4009, 10657},
    {0, 0, 0},
    {0, 0, 0},
    {30217, 6087, 0},
    {0, 0, 0},
    {20966, 2703, 9503},
    {20967, 3193, 0},
    {30221, 6086, 0},
    {20969, 4573, 0},
    {20970, 3545, 0},
    {0, 0, 0},
    {20972, 8310, 11027},
    {20973, 4574, 10658},
    {0, 0, 0},
    {0, 0, 0},
    {20976, 4575, 0},
    {20977, 1705, 0},
    {0, 0, 0},
    {0, 0, 0},
    {39486, 7583, 0},
    {20981, 4576, 0},
    {20982, 1980, 10661},
    {0, 0, 0},
    {20984, 3521, 10660},
    {20985, 1593, 10662},
    {20986, 2679, 10071},
    {30240, 6090, 10659},
    {30241, 6091, 0},
    {20989, 3666, 10072},
    {20990, 4577, 0},
    {30244, 6093, 0},
    {20992, 3448, 0},
    {0, 0, 0},
    {30247, 6089, 0},
    {20995, 2866, 10664},
    {20996, 4578, 10941},
    {0, 0, 0},
    {20998, 3865, 0},
    {20999, 2971, 0},
    {21000, 1787, 0},
    {0, 0, 0},
    {21002, 1794, 0},
    {21003, 4579, 10073},
    {0, 0, 0},
    {39511, 7587, 0},
    {21006, 4581, 0},
    {30260, 6094, 0},
    {39514, 2008, 0},
    {21009, 2093, 10665},
    {0, 0, 0},
    {0, 0, 0},
    {21012, 4580, 0},
    {39519, 7588, 10814},
    {30267, 6096, 0},
    {21015, 4312, 0},
    {39522, 7589, 0},
    {0, 0, 0},
    {39524, 7591, 0},
    {39525, 7590, 0},
    {0, 0, 0},
    {21021, 2704, 9657},
    {0, 0, 0},
    {39529, 7592, 0},
    {39530, 7594, 0},
    {30278, 6099, 10666},
    {30279, 6097, 0},
    {30280, 6098, 0},
    {21028, 3694, 0},
    {21029, 3897, 0},
    {0, 0, 0},
    {30284, 1851, 9723},
    {0, 0, 0},
    {21033, 4223, 0},
    {21034, 4583, 0},
    {0, 0, 0},
    {0, 0, 0},
    {30290, 4135, 0},
    {21038, 4584, 0},
    {0, 0, 0},
    {21040, 3477, 0},
    {30294, 3895, 0},
    {0, 0, 0},
    {21043, 4585, 10075},
    {0, 0, 0},
    {0, 0, 0},
    {21046, 2922, 0},
    {21047, 2443, 10074},
    {21048, 2151, 0},
    {21049, 4586, 0},
    {21050, 2484, 0},
    {21051, 2334, 0},
    {30305, 6102, 0},
    {30306, 6103, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {30311, 6107, 0},
    {21059, 3359, 10076},
    {21060, 4588, 10077},
    {30314, 6106, 0},
    {0, 0, 0},
    {21063, 3108, 10078},
    {0, 0, 0},
    {0, 0, 0},
    {21066, 2428, 0},
    {21067, 4589, 10079},
    {21068, 4590, 0},
    {21069, 3023, 10080},
    {0, 0, 0},
    {21071, 4587, 0},
    {0, 0, 0},
    {30326, 6111, 0},
    {0, 0, 0},
    {30328, 6112, 0},
    {21076, 4592, 0},
    {30330, 3680, 0},
    {30331, 3431, 9591},
    {30332, 6113, 0},
    {30333, 3653, 0},
    {30334, 3779, 0},
    {0, 0, 0},
    {21083, 2323, 10081},
    {0, 0, 0},
    {30338, 8480, 11197},
    {39592, 2347, 9724},
    {30340, 3393, 0},
    {0, 0, 0},
    {30342, 1698, 0},
    {30343, 2291, 0},
    {21091, 2152, 10083},
    {21092, 2411, 0},
    {21093, 3648, 0},
    {30347, 6117, 10668},
    {0, 0, 0},
    {0, 0, 0},
    {21097, 4595, 10084},
    {21098, 4593, 0},
    {30352, 2452, 0},
    {0, 0, 0},
    {0, 0, 0},
    {39608, 1719, 10086},
    {21103, 3850, 0},
    {21104, 2799, 0},
    {21105, 4602, 10085},
    {21106, 1759, 10669},
    {21107, 4596, 0},
    {21108, 4594, 10087},
    {21109, 3054, 10088},
    {39616, 7598, 10884},
    {30364, 8481, 11198},
    {0, 0, 0},
    {30366, 8482, 11199},
    {39620, 2900, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21117, 4598, 0},
    {0, 0, 0},
    {21119, 4597, 0},
    {0, 0, 0},
    {30374, 8484, 11201},
    {0, 0, 0},
    {21123, 1727, 0},
    {0, 0, 0},
    {39631, 7599, 0},
    {0, 0, 0},
    {21127, 2131, 10670},
    {21128, 4603, 0},
    {30382, 3738, 9653},
    {39636, 7602, 0},
    {30384, 6123, 0},
    {0, 0, 0},
    {21133, 4599, 0},
    {39640, 2321, 0},
    {30388, 6124, 10942},
    {0, 0, 0},
    {21137, 4604, 0},
    {21138, 4601, 10781},
    {30392, 6125, 0},
    {21140, 4600, 10089},
    {30394, 6127, 10673},
    {0, 0, 0},
    {0, 0, 0},
    {39650, 7605, 0},
    {39651, 7606, 0},
    {30399, 2457, 0},
    {21147, 4276, 0},
    {39654, 7607, 10815},
    {30402, 6128, 0},
    {30403, 3625, 0},
    {21151, 2250, 0},
    {21152, 1632, 9534},
    {30406, 4010, 10675},
    {0, 0, 0},
    {30408, 1549, 9549},
    {39662, 7610, 0},
    {30410, 1558, 10674},
    {21158, 8313, 11030},
    {39665, 7612, 0},
    {30413, 6129, 0},
    {21161, 2716, 0},
    {21162, 3439, 10676},
    {21163, 2324, 0},
    {21164, 4607, 0},
    {21165, 4608, 10091},
    {0, 0, 0},
    {21167, 8487, 11204},
    {0, 0, 0},
    {21169, 4298, 10090},
    {30423, 3463, 0},
    {0, 0, 0},
    {21172, 4334, 0},
    {21173, 4610, 0},
    {30427, 2938, 0},
    {30428, 5664, 0},
    {0, 0, 0},
    {21177, 2251, 10092},
    {30431, 4074, 0},
    {0, 0, 0},
    {21180, 4609, 10093},
    {0, 0, 0},
    {21182, 1706, 9301},
    {30436, 3720, 0},
    {30437, 6134, 10816},
    {21185, 4611, 0},
    {30439, 6135, 0},
    {21187, 4001, 0},
    {0, 0, 0},
    {21189, 3317, 10094},
    {0, 0, 0},
    {21191, 4141, 0},
    {0, 0, 0},
    {21193, 3910, 9622},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {30450, 4094, 9725},
    {39704, 7616, 0},
    {30452, 3319, 0},
    {39706, 7617, 0},
    {0, 0, 0},
    {21202, 7478, 0},
    {30456, 3081, 0},
    {0, 0, 0},
    {21205, 3493, 10680},
    {30459, 6138, 0},
    {21207, 4613, 0},
    {21208, 1795, 10681},
    {30462, 2697, 9611},
    {0, 0, 0},
    {39717, 7621, 10817},
    {30465, 2767, 0},
    {21213, 2726, 10683},
    {21214, 4614, 10684},
    {21215, 3924, 10098},
    {21216, 4618, 10686},
    {0, 0, 0},
    {21218, 2923, 10097},
    {21219, 4615, 10096},
    {21220, 2021, 9548},
    {39727, 7627, 0},
    {30475, 1824, 9726},
    {21223, 1796, 9329},
    {39730, 7628, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {39739, 6385, 0},
    {39740, 1899, 9323},
    {21235, 4619, 0},
    {0, 0, 0},
    {21237, 4620, 0},
    {30491, 6147, 0},
    {39745, 1692, 0},
    {39746, 2367, 9727},
    {21241, 4622, 10100},
    {21242, 2596, 9417},
    {39749, 4046, 9610},
    {0, 0, 0},
    {0, 0, 0},
    {21246, 2252, 0},
    {21247, 4103, 10099},
    {30501, 6145, 10818},
    {21249, 4113, 10101},
    {21250, 3564, 0},
    {39757, 7632, 0},
    {30505, 6142, 10691},
    {21253, 3934, 10690},
    {21254, 4623, 0},
    {39761, 7634, 10819},
    {21256, 4624, 0},
    {0, 0, 0},
    {39764, 4013, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21261, 4626, 0},
    {39768, 7635, 0},
    {21263, 4628, 0},
    {39770, 1970, 9728},
    {0, 0, 0},
    {30519, 6148, 0},
    {30520, 6149, 0},
    {0, 0, 0},
    {30522, 3304, 9729},
    {21270, 1626, 0},
    {30524, 1852, 9593},
    {0, 0, 0},
    {21273, 2441, 0},
    {21274, 4630, 0},
    {30528, 3264, 0},
    {0, 0, 0},
    {21277, 3064, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21280, 2727, 0},
    {21281, 1982, 10886},
    {30535, 6150, 0},
    {21283, 4631, 0},
    {21284, 8318, 11035},
    {39791, 4328, 0},
    {0, 0, 0},
    {0, 0, 0},
    {39794, 8622, 11339},
    {0, 0, 0},
    {21290, 3724, 10692},
    {39797, 8621, 11338},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21295, 4632, 0},
    {0, 0, 0},
    {21297, 4633, 0},
    {0, 0, 0},
    {21299, 4634, 0},
    {0, 0, 0},
    {30554, 6151, 0},
    {30555, 6154, 0},
    {0, 0, 0},
    {21304, 4635, 0},
    {21305, 3763, 10694},
    {21306, 2045, 0},
    {21307, 1478, 0},
    {30561, 2890, 0},
    {0, 0, 0},
    {30563, 3513, 0},
    {21311, 3508, 0},
    {21312, 4636, 10104},
    {21313, 2660, 9594},
    {0, 0, 0},
    {21315, 2986, 10102},
    {39822, 1439, 0},
    {21317, 4638, 10944},
    {21318, 4637, 10103},
    {21319, 2728, 10695},
    {21320, 2226, 9574},
    {21321, 4640, 10693},
    {21322, 3695, 0},
    {0, 0, 0},
    {39830, 7640, 0},
    {21325, 4641, 10696},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21329, 3725, 0},
    {21330, 3121, 0},
    {21331, 3179, 0},
    {21332, 1981, 10106},
    {39839, 7642, 0},
    {39840, 7643, 0},
    {21335, 3555, 0},
    {21336, 3212, 0},
    {30590, 6157, 0},
    {21338, 3649, 10105},
    {0, 0, 0},
    {21340, 3993, 0},
    {0, 0, 0},
    {21342, 4643, 10697},
    {0, 0, 0},
    {21344, 2987, 9598},
    {39851, 2456, 0},
    {0, 0, 0},
    {39853, 2439, 0},
    {39854, 3022, 0},
    {0, 0, 0},
    {21350, 2088, 10108},
    {39857, 8624, 11341},
    {0, 0, 0},
    {21353, 4644, 10107},
    {39860, 7645, 0},
    {0, 0, 0},
    {30609, 6161, 0},
    {0, 0, 0},
    {21358, 4645, 0},
    {21359, 1515, 10699},
    {21360, 1494, 0},
    {21361, 1862, 10945},
    {21362, 8319, 11036},
    {21363, 3109, 0},
    {21364, 1928, 0},
    {21365, 4216, 0},
    {39872, 7646, 0},
    {21367, 4648, 0},
    {21368, 1620, 0},
    {30622, 6163, 0},
    {0, 0, 0},
    {21371, 4647, 10109},
    {39878, 7649, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21375, 1983, 9335},
    {30629, 3898, 10698},
    {0, 0, 0},
    {21378, 4649, 0},
    {0, 0, 0},
    {21380, 4122, 0},
    {39887, 7650, 0},
    {0, 0, 0},
    {30636, 2685, 10700},
    {30637, 4267, 10701},
    {0, 0, 0},
    {39892, 7656, 0},
    {30640, 6164, 0},
    {39894, 2453, 0},
    {0, 0, 0},
    {30643, 3500, 0},
    {0, 0, 0},
    {0, 0, 0},
    {39899, 3169, 10110},
    {0, 0, 0},
    {21395, 8320, 11037},
    {30649, 6166, 0},
    {0, 0, 0},
    {21398, 4650, 10113},
    {30652, 6168, 10704},
    {21400, 4279, 10112},
    {39907, 7653, 0},
    {21402, 2253, 10111},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {39912, 2130, 0},
    {21407, 2183, 0},
    {21408, 4651, 0},
    {0, 0, 0},
    {30663, 6171, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21413, 4653, 0},
    {21414, 4652, 10707},
    {39921, 7660, 0},
    {21416, 2882, 10114},
    {21417, 1528, 0},
    {0, 0, 0},
    {39925, 1428, 0},
    {0, 0, 0},
    {21421, 1565, 0},
    {21422, 4654, 0},
    {0, 0, 0},
    {21424, 4655, 0},
    {0, 0, 0},
    {30679, 6173, 10820},
    {21427, 2184, 0},
    {0, 0, 0},
    {30682, 6174, 0},
    {30683, 4064, 9730},
    {30684, 6175, 0},
    {0, 0, 0},
    {0, 0, 0},
    {39940, 7671, 0},
    {21435, 1957, 0},
    {39942, 7667, 0},
    {30690, 4121, 0},
    {30691, 6176, 10712},
    {39945, 7664, 0},
    {30693, 3241, 10714},
    {0, 0, 0},
    {21442, 2461, 9526},
    {39949, 1757, 9731},
    {30697, 2048, 0},
    {0, 0, 0},
    {39952, 4367, 0},
    {0, 0, 0},
    {30701, 3222, 9602},
    {21449, 2370, 10115},
    {21450, 1937, 9316},
    {21451, 4142, 10708},
    {21452, 3055, 0},
    {21453, 3696, 0},
    {21454, 2630, 9431},
    {0, 0, 0},
    {0, 0, 0},
    {39963, 7673, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21460, 2670, 0},
    {0, 0, 0},
    {21462, 2609, 0},
    {21463, 2622, 10116},
    {0, 0, 0},
    {21465, 2717, 0},
    {39972, 7675, 0},
    {21467, 3697, 10716},
    {0, 0, 0},
    {30722, 2378, 10821},
    {0, 0, 0},
    {21471, 4660, 0},
    {0, 0, 0},
    {21473, 1538, 0},
    {21474, 3056, 0},
    {21475, 2254, 9558},
    {21476, 2198, 10715},
    {39983, 1492, 9321},
    {39984, 7677, 0},
    {30732, 6179, 0},
    {21480, 4664, 10718},
    {21481, 3196, 0},
    {21482, 3195, 0},
    {21483, 1984, 0},
    {21484, 2729, 0},
    {21485, 4665, 10117},
    {21486, 4663, 0},
    {21487, 1633, 9298},
    {30741, 2402, 9453},
    {39995, 1526, 9377},
    {21490, 2486, 0},
    {21491, 1509, 0},
    {39998, 7681, 0},
    {0, 0, 0},
    {21494, 1771, 0},
    {21495, 2325, 0},
    {21496, 2485, 0},
    {0, 0, 0},
    {21498, 4666, 0},
    {30752, 6182, 0},
    {40006, 7680, 10887},
    {40007, 7678, 0},
    {40008, 3208, 0},
    {0, 0, 0},
    {30757, 3437, 0},
    {30758, 2403, 9733},
    {30759, 1925, 0},
    {21507, 1920, 0},
    {21508, 1729, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21512, 2326, 9599},
    {21513, 1919, 0},
    {21514, 3352, 0},
    {21515, 1508, 0},
    {21516, 3494, 0},
    {30770, 3951, 9614},
    {21518, 2256, 0},
    {30772, 3614, 9650},
    {21520, 3422, 10719},
    {21521, 2255, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {30778, 3438, 0},
    {40032, 7683, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {30783, 2315, 0},
    {21531, 2082, 0},
    {0, 0, 0},
    {21533, 4676, 10720},
    {0, 0, 0},
    {21535, 2040, 0},
    {21536, 3989, 10120},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {12288, 0, 0},
    {12289, 1, 9541},
    {12290, 2, 0},
    {12291, 22, 0},
    {21545, 4675, 10888},
    {12293, 24, 0},
    {12294, 25, 9304},
    {12295, 26, 9734},
    {12296, 49, 9735},
    {12297, 50, 9736},
    {12298, 51, 0},
    {12299, 52, 0},
    {12300, 53, 0},
    {12301, 54, 0},
    {12302, 55, 0},
    {12303, 56, 0},
    {12304, 57, 0},
    {12305, 58, 9737},
    {12306, 102, 0},
    {12307, 107, 9312},
    {12308, 43, 9420},
    {12309, 44, 0},
    {21563, 3866, 0},
    {21564, 4672, 0},
    {21565, 4668, 0},
    {21566, 2228, 0},
    {30820, 8490, 11207},
    {21568, 4669, 0},
    {0, 0, 0},
    {12317, 1191, 9671},
    {0, 0, 0},
    {12319, 1192, 0},
    {0, 0, 0},
    {21574, 3935, 9655},
    {30828, 2292, 0},
    {21576, 3361, 0},
    {21577, 2227, 0},
    {30831, 2168, 9346},
    {0, 0, 0},
    {0, 0, 0},
    {30834, 3668, 0},
    {21582, 4677, 0},
    {30836, 6186, 0},
    {0, 0, 0},
    {21585, 3538, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {30842, 8491, 11208},
    {0, 0, 0},
    {30844, 6188, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {30849, 2236, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21599, 4681, 0},
    {0, 0, 0},
    {30854, 6187, 0},
    {30855, 3375, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {12353, 282, 0},
    {12354, 283, 10123},
    {12355, 284, 9291},
    {12356, 285, 10121},
    {12357, 286, 9387},
    {12358, 287, 0},
    {12359, 288, 9543},
    {12360, 289, 0},
    {12361, 290, 9277},
    {12362, 291, 0},
    {12363, 292, 9357},
    {12364, 293, 9741},
    {12365, 294, 9679},
    {12366, 295, 9605},
    {12367, 296, 0},
    {12368, 297, 9739},
    {12369, 298, 9747},
    {12370, 299, 9742},
    {12371, 300, 0},
    {12372, 301, 0},
    {12373, 302, 0},
    {12374, 303, 9745},
    {12375, 304, 9332},
    {12376, 305, 9615},
    {12377, 306, 10124},
    {12378, 307, 0},
    {12379, 308, 9746},
    {12380, 309, 0},
    {12381, 310, 9579},
    {12382, 311, 0},
    {12383, 312, 9433},
    {12384, 313, 10126},
    {12385, 314, 9750},
    {12386, 315, 0},
    {12387, 316, 0},
    {12388, 317, 0},
    {12389, 318, 10127},
    {12390, 319, 9359},
    {12391, 320, 9675},
    {12392, 321, 0},
    {12393, 322, 9740},
    {12394, 323, 9738},
    {12395, 324, 9749},
    {12396, 325, 0},
    {12397, 326, 9744},
    {12398, 327, 0},
    {12399, 328, 0},
    {12400, 329, 9295},
    {12401, 330, 0},
    {12402, 331, 10133},
    {12403, 332, 0},
    {12404, 333, 10132},
    {12405, 334, 0},
    {12406, 335, 9479},
    {12407, 336, 9373},
    {12408, 337, 10723},
    {12409, 338, 0},
    {12410, 339, 9535},
    {12411, 340, 10134},
    {12412, 341, 10129},
    {12413, 342, 9752},
    {12414, 343, 0},
    {12415, 344, 9761},
    {12416, 345, 9754},
    {12417, 346, 10130},
    {12418, 347, 0},
    {12419, 348, 9758},
    {12420, 349, 9587},
    {12421, 350, 9617},
    {12422, 351, 9540},
    {12423, 352, 9509},
    {12424, 353, 0},
    {12425, 354, 0},
    {12426, 355, 9778},
    {12427, 356, 0},
    {12428, 357, 0},
    {12429, 358, 9355},
    {12430, 359, 9290},
    {12431, 360, 0},
    {12432, 361, 10138},
    {12433, 362, 0},
    {12434, 363, 0},
    {12435, 364, 9753},
    {40195, 7693, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21692, 4704, 10728},
    {21693, 1495, 9506},
    {21694, 4703, 10726},
    {40201, 7690, 0},
    {12443, 10, 9270},
    {12444, 11, 9559},
    {12445, 20, 9760},
    {12446, 21, 9596},
    {40206, 1607, 9756},
    {0, 0, 0},
    {12449, 376, 0},
    {12450, 377, 9751},
    {12451, 378, 9757},
    {12452, 379, 9351},
    {12453, 380, 9272},
    {12454, 381, 10735},
    {12455, 382, 0},
    {12456, 383, 0},
    {12457, 384, 0},
    {12458, 385, 10140},
    {12459, 386, 0},
    {12460, 387, 9283},
    {12461, 388, 0},
    {12462, 389, 0},
    {12463, 390, 0},
    {12464, 391, 10733},
    {12465, 392, 0},
    {12466, 393, 0},
    {12467, 394, 9762},
    {12468, 395, 10732},
    {12469, 396, 0},
    {12470, 397, 0},
    {12471, 398, 9408},
    {12472, 399, 0},
    {12473, 400, 9299},
    {12474, 401, 0},
    {12475, 402, 10729},
    {12476, 403, 9274},
    {12477, 404, 9284},
    {12478, 405, 0},
    {12479, 406, 0},
    {12480, 407, 9763},
    {12481, 408, 9764},
    {12482, 409, 0},
    {12483, 410, 9401},
    {12484, 411, 9442},
    {12485, 412, 0},
    {12486, 413, 0},
    {12487, 414, 10143},
    {12488, 415, 9769},
    {12489, 416, 9768},
    {12490, 417, 0},
    {12491, 418, 0},
    {12492, 419, 9343},
    {12493, 420, 9492},
    {12494, 421, 0},
    {12495, 422, 10144},
    {12496, 423, 10738},
    {12497, 424, 0},
    {12498, 425, 10737},
    {12499, 426, 0},
    {12500, 427, 0},
    {12501, 428, 9770},
    {12502, 429, 0},
    {12503, 430, 10740},
    {12504, 431, 9767},
    {12505, 432, 10741},
    {12506, 433, 10825},
    {12507, 434, 0},
    {12508, 435, 10118},
    {12509, 436, 0},
    {12510, 437, 0},
    {12511, 438, 9278},
    {12512, 439, 10119},
    {12513, 440, 9349},
    {12514, 441, 9415},
    {12515, 442, 0},
    {12516, 443, 0},
    {12517, 444, 0},
    {12518, 445, 10889},
    {12519, 446, 0},
    {12520, 447, 0},
    {12521, 448, 0},
    {12522, 449, 9765},
    {12523, 450, 9498},
    {12524, 451, 0},
    {12525, 452, 9276},
    {12526, 453, 10742},
    {12527, 454, 9766},
    {12528, 455, 9374},
    {12529, 456, 9269},
    {12530, 457, 9613},
    {12531, 458, 0},
    {12532, 459, 9382},
    {12533, 460, 10744},
    {12534, 461, 10147},
    {31041, 2090, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {12539, 5, 0},
    {12540, 27, 10947},
    {12541, 18, 9309},
    {12542, 19, 9305},
    {31049, 2510, 0},
    {40303, 7718, 0},
    {40304, 8627, 11344},
    {0, 0, 0},
    {40306, 7714, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31056, 4155, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21806, 4719, 10148},
    {21807, 4138, 0},
    {31061, 6219, 10749},
    {21809, 2732, 9443},
    {31063, 6216, 0},
    {21811, 4725, 0},
    {0, 0, 0},
    {31066, 6218, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31069, 2674, 9776},
    {31070, 2851, 9772},
    {31071, 6217, 0},
    {31072, 6215, 0},
    {0, 0, 0},
    {31074, 3581, 10748},
    {21822, 3136, 0},
    {40329, 7715, 0},
    {31077, 2770, 9773},
    {0, 0, 0},
    {0, 0, 0},
    {31080, 3787, 0},
    {21828, 3180, 0},
    {40335, 2127, 9775},
    {21830, 2731, 0},
    {0, 0, 0},
    {31085, 2404, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21836, 4718, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21839, 4109, 0},
    {40346, 7720, 0},
    {0, 0, 0},
    {31095, 3471, 0},
    {21843, 2095, 0},
    {0, 0, 0},
    {31098, 6221, 0},
    {21846, 4722, 0},
    {21847, 4723, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31103, 6222, 10750},
    {31104, 6244, 0},
    {31105, 2029, 9774},
    {21853, 4726, 0},
    {0, 0, 0},
    {31108, 4352, 10751},
    {31109, 3028, 0},
    {40363, 7717, 0},
    {0, 0, 0},
    {21859, 4717, 0},
    {0, 0, 0},
    {31114, 6223, 10731},
    {0, 0, 0},
    {0, 0, 0},
    {31117, 1647, 10752},
    {31118, 3376, 0},
    {40372, 3354, 9570},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {40376, 7727, 0},
    {31124, 8496, 11213},
    {40378, 7728, 0},
    {40379, 7726, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31131, 8498, 11215},
    {40385, 7725, 0},
    {31133, 6224, 10755},
    {0, 0, 0},
    {40388, 7724, 0},
    {21883, 4732, 0},
    {21884, 4737, 10753},
    {0, 0, 0},
    {21886, 4733, 0},
    {0, 0, 0},
    {21888, 4728, 0},
    {31142, 1969, 0},
    {31143, 6225, 0},
    {21891, 4738, 0},
    {21892, 3024, 0},
    {31146, 6227, 10754},
    {21894, 8328, 11045},
    {21895, 4740, 0},
    {0, 0, 0},
    {21897, 2257, 10150},
    {21898, 4730, 0},
    {21899, 3288, 9517},
    {0, 0, 0},
    {0, 0, 0},
    {31155, 6229, 0},
    {40409, 7732, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31161, 6230, 0},
    {31162, 6231, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31165, 2030, 9779},
    {31166, 1648, 9777},
    {21914, 1798, 9507},
    {31168, 2639, 0},
    {21916, 1863, 9370},
    {21917, 1760, 0},
    {21918, 4735, 0},
    {21919, 4731, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {40429, 7736, 0},
    {31177, 6232, 0},
    {40431, 7737, 0},
    {31179, 2640, 0},
    {21927, 2153, 0},
    {40434, 4364, 9780},
    {21929, 4739, 0},
    {21930, 3058, 0},
    {21931, 1921, 0},
    {31185, 1639, 9314},
    {31186, 3794, 0},
    {21934, 4736, 10757},
    {40441, 3176, 0},
    {21936, 2057, 9358},
    {0, 0, 0},
    {0, 0, 0},
    {31192, 3740, 10759},
    {0, 0, 0},
    {0, 0, 0},
    {21942, 1539, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31199, 3044, 0},
    {0, 0, 0},
    {31201, 6236, 0},
    {0, 0, 0},
    {31203, 6237, 0},
    {31204, 3644, 0},
    {0, 0, 0},
    {31206, 2852, 0},
    {31207, 6234, 0},
    {0, 0, 0},
    {31209, 3260, 9781},
    {21957, 4743, 0},
    {0, 0, 0},
    {21959, 4800, 10152},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31216, 2771, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {40473, 8630, 11347},
    {40474, 7739, 0},
    {40475, 7740, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21972, 4748, 10760},
    {0, 0, 0},
    {31227, 1469, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21978, 4742, 0},
    {31232, 1888, 0},
    {21980, 4746, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21983, 4744, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {21987, 2487, 10153},
    {21988, 4747, 0},
    {0, 0, 0},
    {31243, 3377, 0},
    {0, 0, 0},
    {31245, 6239, 0},
    {31246, 2952, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31252, 4054, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31255, 3762, 0},
    {31256, 6240, 0},
    {31257, 6241, 0},
    {31258, 3248, 0},
    {0, 0, 0},
    {31260, 4268, 9782},
    {0, 0, 0},
    {22009, 4755, 0},
    {31263, 6243, 0},
    {31264, 6242, 0},
    {0, 0, 0},
    {22013, 4753, 0},
    {22014, 4752, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22022, 3213, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22025, 1634, 9386},
    {0, 0, 0},
    {0, 0, 0},
    {31281, 6245, 0},
    {31282, 1489, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31287, 6248, 0},
    {0, 0, 0},
    {22036, 4749, 0},
    {0, 0, 0},
    {22038, 4751, 10154},
    {31292, 1649, 9402},
    {22040, 1522, 9326},
    {31294, 6247, 0},
    {31295, 2293, 0},
    {31296, 2337, 9783},
    {0, 0, 0},
    {31298, 3923, 0},
    {31299, 6249, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31302, 3999, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31305, 6251, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31309, 2962, 0},
    {31310, 1550, 9287},
    {31311, 1623, 0},
    {31312, 1421, 10761},
    {0, 0, 0},
    {0, 0, 0},
    {40568, 2181, 0},
    {22063, 4765, 10762},
    {0, 0, 0},
    {22065, 2817, 0},
    {22066, 4761, 10155},
    {40573, 7744, 0},
    {22068, 4759, 0},
    {40575, 2552, 0},
    {22070, 4760, 0},
    {40577, 7745, 0},
    {22072, 4762, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31329, 6252, 0},
    {31330, 6253, 0},
    {31331, 2812, 10763},
    {0, 0, 0},
    {0, 0, 0},
    {40587, 7747, 0},
    {22082, 1532, 10764},
    {0, 0, 0},
    {31337, 6254, 0},
    {0, 0, 0},
    {31339, 1738, 0},
    {40593, 7751, 0},
    {40594, 7749, 0},
    {40595, 4351, 0},
    {0, 0, 0},
    {31344, 6256, 10765},
    {22092, 3032, 0},
    {40599, 4308, 0},
    {22094, 4756, 0},
    {31348, 2141, 0},
    {22096, 4757, 0},
    {31350, 1949, 0},
    {0, 0, 0},
    {40605, 7752, 0},
    {31353, 6257, 0},
    {31354, 2058, 9663},
    {12849, 1201, 10985},
    {12850, 1202, 0},
    {31357, 6258, 0},
    {0, 0, 0},
    {31359, 3005, 0},
    {22107, 1781, 10766},
    {31361, 3522, 9531},
    {0, 0, 0},
    {12857, 1203, 9435},
    {31364, 2434, 10767},
    {40618, 7756, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31368, 6259, 10769},
    {22116, 4764, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22120, 1864, 0},
    {0, 0, 0},
    {22122, 4767, 0},
    {22123, 4763, 0},
    {22124, 4766, 0},
    {31378, 3261, 0},
    {31379, 3082, 10768},
    {40633, 2332, 0},
    {40634, 4086, 10157},
    {40635, 4014, 10158},
    {40636, 5068, 10156},
    {31384, 6262, 0},
    {22132, 3867, 9929},
    {40639, 4038, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22136, 3530, 0},
    {0, 0, 0},
    {40644, 1608, 9322},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22144, 4769, 0},
    {0, 0, 0},
    {40652, 7759, 0},
    {40653, 1927, 0},
    {31401, 6264, 10770},
    {31402, 2073, 10771},
    {22150, 4768, 10772},
    {22151, 1728, 10949},
    {40658, 2340, 0},
    {31406, 1950, 0},
    {31407, 4185, 9784},
    {31408, 6266, 0},
    {0, 0, 0},
    {0, 0, 0},
    {40664, 5973, 0},
    {40665, 4100, 9785},
    {0, 0, 0},
    {40667, 3168, 10159},
    {40668, 7764, 0},
    {40669, 7766, 0},
    {22164, 4772, 10774},
    {31418, 1517, 0},
    {40672, 7767, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31423, 6270, 0},
    {40677, 7768, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31427, 1777, 10775},
    {31428, 6269, 0},
    {22176, 4771, 10160},
    {0, 0, 0},
    {22178, 3596, 10162},
    {31432, 6265, 0},
    {0, 0, 0},
    {22181, 4774, 10163},
    {31435, 4238, 0},
    {0, 0, 0},
    {31437, 6274, 0},
    {0, 0, 0},
    {31439, 6275, 10777},
    {0, 0, 0},
    {40694, 7772, 10890},
    {31442, 4877, 10778},
    {22190, 4775, 10164},
    {40697, 7774, 0},
    {31445, 6276, 0},
    {40699, 7775, 0},
    {40700, 7776, 0},
    {40701, 7777, 0},
    {22196, 4777, 10165},
    {31450, 6279, 0},
    {22198, 4776, 0},
    {31452, 4250, 0},
    {31453, 6280, 0},
    {0, 0, 0},
    {31455, 7504, 0},
    {31456, 2772, 0},
    {22204, 4779, 10166},
    {31458, 6282, 10779},
    {31459, 2686, 10780},
    {0, 0, 0},
    {31461, 3501, 9786},
    {22209, 4780, 10167},
    {22210, 4778, 10891},
    {22211, 4781, 0},
    {40718, 3387, 0},
    {31466, 3203, 0},
    {31467, 8502, 11219},
    {0, 0, 0},
    {22216, 4783, 10168},
    {12964, 1196, 9334},
    {12965, 1197, 9463},
    {12966, 1198, 10169},
    {12967, 1199, 0},
    {12968, 1200, 0},
    {22222, 4784, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31478, 1978, 9787},
    {0, 0, 0},
    {31480, 4542, 9788},
    {31481, 3256, 0},
    {31482, 2556, 0},
    {40736, 3052, 0},
    {22231, 4787, 10783},
    {22232, 4548, 0},
    {0, 0, 0},
    {31487, 1825, 9389},
    {22235, 2488, 0},
    {0, 0, 0},
    {31490, 6286, 0},
    {22238, 1680, 0},
    {31492, 6299, 0},
    {22240, 1497, 0},
    {31494, 6289, 0},
    {40748, 7783, 0},
    {31496, 1951, 9465},
    {0, 0, 0},
    {31498, 6288, 0},
    {31499, 6301, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31503, 6287, 0},
    {0, 0, 0},
    {31505, 2773, 0},
    {0, 0, 0},
    {22254, 4788, 0},
    {0, 0, 0},
    {22256, 2353, 0},
    {40763, 3760, 0},
    {22258, 1456, 0},
    {22259, 2881, 10170},
    {31513, 6292, 10784},
    {0, 0, 0},
    {31515, 3394, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22265, 4789, 10171},
    {22266, 2200, 0},
    {31520, 1753, 0},
    {0, 0, 0},
    {22269, 2336, 0},
    {0, 0, 0},
    {22271, 4791, 0},
    {31525, 2877, 9789},
    {31526, 3827, 10149},
    {0, 0, 0},
    {22275, 3917, 10172},
    {22276, 4792, 10453},
    {40783, 7502, 0},
    {0, 0, 0},
    {31532, 3173, 0},
    {22280, 4794, 10786},
    {22281, 4793, 0},
    {40788, 7787, 0},
    {22283, 4795, 0},
    {0, 0, 0},
    {22285, 4796, 0},
    {31539, 6290, 0},
    {22287, 2154, 0},
    {31541, 6294, 0},
    {31542, 6296, 0},
    {22290, 1567, 0},
    {22291, 4797, 0},
    {31545, 2440, 0},
    {40799, 7789, 0},
    {22294, 4799, 10787},
    {40801, 7791, 0},
    {40802, 4309, 9790},
    {40803, 7788, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22300, 4801, 10788},
    {40807, 7793, 0},
    {0, 0, 0},
    {22303, 3441, 0},
    {31557, 6303, 10789},
    {31558, 3773, 0},
    {40812, 7794, 0},
    {31560, 3671, 0},
    {31561, 3472, 0},
    {0, 0, 0},
    {31563, 2031, 9791},
    {22311, 1430, 10174},
    {13059, 1165, 9353},
    {0, 0, 0},
    {31567, 3686, 0},
    {31568, 6297, 0},
    {31569, 3257, 10792},
    {22317, 2096, 9500},
    {0, 0, 0},
    {31572, 3473, 0},
    {22320, 3242, 0},
    {31574, 2435, 0},
    {13069, 1169, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22327, 4803, 0},
    {22328, 4804, 10184},
    {13076, 1160, 0},
    {0, 0, 0},
    {22331, 4806, 0},
    {0, 0, 0},
    {13080, 1163, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22336, 4807, 10176},
    {0, 0, 0},
    {22338, 2417, 10178},
    {40845, 4251, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {13090, 1161, 9318},
    {13091, 1171, 0},
    {31598, 6311, 0},
    {22346, 3970, 0},
    {13094, 1170, 10179},
    {13095, 1164, 10180},
    {0, 0, 0},
    {22350, 4805, 0},
    {22351, 4808, 10177},
    {13099, 1172, 9350},
    {22353, 2258, 0},
    {40860, 7800, 0},
    {40861, 6255, 0},
    {0, 0, 0},
    {31610, 6298, 0},
    {40864, 7801, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22361, 8329, 11046},
    {0, 0, 0},
    {13110, 1166, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {13115, 1174, 0},
    {31622, 3900, 9793},
    {31623, 1650, 0},
    {0, 0, 0},
    {22372, 2354, 0},
    {22373, 8330, 11047},
    {22374, 3214, 10182},
    {0, 0, 0},
    {31629, 6315, 0},
    {22377, 4809, 0},
    {22378, 3347, 10183},
    {0, 0, 0},
    {0, 0, 0},
    {31634, 6319, 0},
    {13129, 1159, 0},
    {13130, 1173, 9527},
    {31637, 4048, 0},
    {0, 0, 0},
    {13133, 1162, 9366},
    {31640, 6313, 0},
    {31641, 6322, 0},
    {31642, 6317, 0},
    {13137, 1167, 0},
    {31644, 6316, 0},
    {31645, 6312, 0},
    {31646, 8503, 11220},
    {31647, 6314, 0},
    {0, 0, 0},
    {13143, 1168, 9302},
    {0, 0, 0},
    {0, 0, 0},
    {22399, 4813, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22402, 2885, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31658, 3224, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31661, 3006, 9792},
    {22409, 4814, 0},
    {0, 0, 0},
    {22411, 2098, 0},
    {31665, 3667, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31668, 6327, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31672, 3669, 9794},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31680, 2978, 0},
    {31681, 6324, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31684, 3712, 0},
    {13179, 1190, 9795},
    {13180, 1206, 10186},
    {13181, 1205, 9337},
    {13182, 1204, 9293},
    {31689, 3254, 9797},
    {0, 0, 0},
    {31691, 6323, 0},
    {31692, 6325, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22442, 4819, 10185},
    {0, 0, 0},
    {22444, 8331, 11048},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22448, 4820, 0},
    {0, 0, 0},
    {0, 0, 0},
    {13198, 1178, 9796},
    {13199, 1179, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31709, 6329, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31712, 2573, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31716, 3515, 0},
    {22464, 4810, 10188},
    {13212, 1175, 10187},
    {13213, 1176, 0},
    {13214, 1177, 9798},
    {31721, 6330, 0},
    {0, 0, 0},
    {13217, 1181, 9799},
    {22471, 8333, 11050},
    {31725, 4345, 10826},
    {0, 0, 0},
    {0, 0, 0},
    {22475, 4015, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22478, 2800, 10189},
    {0, 0, 0},
    {0, 0, 0},
    {31734, 6343, 0},
    {22482, 4824, 10190},
    {22483, 4825, 0},
    {22484, 4823, 0},
    {0, 0, 0},
    {22486, 4827, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31744, 6336, 0},
    {22492, 3595, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22495, 1481, 0},
    {22496, 3813, 0},
    {0, 0, 0},
    {31751, 6337, 0},
    {22499, 4828, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31757, 6342, 0},
    {13252, 1180, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31761, 6331, 0},
    {31762, 4658, 0},
    {31763, 6338, 0},
    {31764, 6332, 0},
    {0, 0, 0},
    {0, 0, 0},
    {13261, 1194, 10191},
    {0, 0, 0},
    {22516, 2818, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22519, 2562, 0},
    {0, 0, 0},
    {22521, 3632, 0},
    {22522, 1865, 10194},
    {0, 0, 0},
    {31777, 1827, 9356},
    {0, 0, 0},
    {31779, 6344, 0},
    {0, 0, 0},
    {22528, 4004, 0},
    {0, 0, 0},
    {22530, 3495, 10192},
    {0, 0, 0},
    {0, 0, 0},
    {22533, 2155, 10193},
    {22534, 3148, 10195},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22538, 4826, 0},
    {22539, 4829, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31799, 6348, 0},
    {31800, 3751, 0},
    {0, 0, 0},
    {22549, 3137, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31805, 6350, 0},
    {31806, 4321, 9800},
    {31807, 3930, 0},
    {31808, 6355, 0},
    {0, 0, 0},
    {22557, 4831, 0},
    {31811, 6352, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22561, 4833, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22564, 3362, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31820, 6351, 0},
    {31821, 2963, 0},
    {0, 0, 0},
    {22570, 1799, 10196},
    {31824, 6356, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31828, 6353, 10794},
    {22576, 1568, 0},
    {22577, 3936, 10198},
    {0, 0, 0},
    {31832, 6357, 0},
    {22580, 2801, 0},
    {22581, 3423, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22586, 2419, 10197},
    {31840, 6335, 0},
    {0, 0, 0},
    {22589, 4839, 0},
    {0, 0, 0},
    {31844, 6359, 0},
    {22592, 3882, 10199},
    {22593, 4290, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31852, 6362, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22602, 1681, 0},
    {22603, 4835, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31859, 3891, 0},
    {0, 0, 0},
    {31861, 6363, 0},
    {22609, 3033, 0},
    {22610, 4838, 0},
    {0, 0, 0},
    {22612, 3450, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22615, 3424, 0},
    {22616, 3451, 0},
    {22617, 3690, 9623},
    {22618, 3334, 0},
    {0, 0, 0},
    {31873, 2019, 0},
    {31874, 2076, 0},
    {22622, 2390, 10200},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22626, 4834, 0},
    {0, 0, 0},
    {31881, 3873, 0},
    {0, 0, 0},
    {31883, 2891, 0},
    {0, 0, 0},
    {31885, 4057, 0},
    {22633, 1589, 0},
    {0, 0, 0},
    {22635, 3405, 10201},
    {0, 0, 0},
    {31890, 4248, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31893, 3655, 9802},
    {0, 0, 0},
    {31895, 3045, 9801},
    {31896, 3591, 0},
    {0, 0, 0},
    {22645, 2867, 0},
    {31899, 2676, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22649, 4840, 0},
    {31903, 1441, 0},
    {0, 0, 0},
    {31905, 6370, 0},
    {31906, 6368, 0},
    {22654, 2677, 0},
    {31908, 6366, 0},
    {31909, 1786, 0},
    {0, 0, 0},
    {31911, 2774, 0},
    {22659, 1986, 10202},
    {0, 0, 0},
    {22661, 4841, 0},
    {31915, 6369, 0},
    {0, 0, 0},
    {31917, 6367, 0},
    {31918, 6375, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31921, 6374, 0},
    {31922, 6373, 0},
    {31923, 6372, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22675, 3925, 0},
    {31929, 6376, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22679, 3100, 0},
    {31933, 6377, 0},
    {31934, 2939, 0},
    {0, 0, 0},
    {31936, 6378, 0},
    {22684, 3327, 0},
    {31938, 6380, 0},
    {22686, 8336, 11053},
    {22687, 4843, 0},
    {31941, 6379, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31946, 2211, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22696, 3994, 0},
    {31950, 3031, 0},
    {0, 0, 0},
    {22699, 4844, 0},
    {0, 0, 0},
    {31954, 6382, 0},
    {22702, 4849, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31958, 3475, 0},
    {22706, 8337, 11054},
    {22707, 3868, 10203},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {31964, 6383, 0},
    {22712, 4848, 0},
    {31966, 3874, 9803},
    {31967, 3083, 9804},
    {31968, 2294, 9805},
    {0, 0, 0},
    {31970, 6384, 0},
    {22718, 2355, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22721, 3894, 0},
    {31975, 4269, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22725, 4850, 0},
    {0, 0, 0},
    {22727, 3232, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22730, 1682, 10204},
    {0, 0, 0},
    {22732, 2802, 0},
    {31986, 6387, 0},
    {0, 0, 0},
    {31988, 6388, 0},
    {0, 0, 0},
    {22737, 4852, 10205},
    {0, 0, 0},
    {31992, 2512, 9806},
    {0, 0, 0},
    {22741, 2327, 10206},
    {31995, 2114, 0},
    {22743, 4853, 0},
    {22744, 4855, 0},
    {31998, 1953, 9807},
    {0, 0, 0},
    {32000, 1889, 0},
    {22748, 4857, 0},
    {32002, 6392, 0},
    {22750, 4846, 0},
    {32004, 4124, 9808},
    {32005, 2295, 0},
    {32006, 6391, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22756, 4858, 0},
    {22757, 4856, 10209},
    {32011, 4111, 0},
    {0, 0, 0},
    {32013, 3599, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22763, 2489, 9553},
    {22764, 2868, 0},
    {0, 0, 0},
    {22766, 3059, 0},
    {32020, 2698, 9809},
    {22768, 2941, 10208},
    {22769, 1486, 0},
    {32023, 2588, 9525},
    {32024, 2296, 0},
    {32025, 2513, 0},
    {32026, 1952, 0},
    {32027, 3875, 0},
    {22775, 3348, 10207},
    {0, 0, 0},
    {22777, 4862, 0},
    {22778, 4861, 0},
    {32032, 3046, 9810},
    {32033, 3981, 9811},
    {32034, 2436, 9812},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22786, 4866, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32043, 2514, 0},
    {32044, 3350, 0},
    {0, 0, 0},
    {22793, 3902, 10210},
    {32047, 4292, 9813},
    {32048, 2406, 10828},
    {0, 0, 0},
    {32050, 6399, 0},
    {32051, 2853, 0},
    {22799, 1635, 0},
    {22800, 4868, 10212},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32057, 2775, 0},
    {32058, 2365, 9639},
    {22806, 1707, 0},
    {0, 0, 0},
    {22808, 4646, 0},
    {22809, 2671, 0},
    {22810, 3132, 10211},
    {22811, 4869, 0},
    {22812, 4116, 0},
    {32066, 2641, 0},
    {32067, 2191, 0},
    {32068, 3047, 0},
    {32069, 6396, 0},
    {32070, 6402, 0},
    {22818, 4061, 0},
    {32072, 8505, 11222},
    {0, 0, 0},
    {22821, 4871, 0},
    {32075, 6397, 0},
    {32076, 2115, 9454},
    {0, 0, 0},
    {22825, 3406, 10215},
    {22826, 3133, 10217},
    {32080, 2142, 9563},
    {22828, 4872, 0},
    {22829, 4873, 0},
    {22830, 1594, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22833, 2563, 10214},
    {22834, 4874, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32091, 6413, 0},
    {22839, 1457, 10892},
    {22840, 4875, 0},
    {32094, 2297, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32097, 4212, 0},
    {32098, 1437, 0},
    {22846, 4876, 10218},
    {0, 0, 0},
    {0, 0, 0},
    {32102, 1954, 0},
    {0, 0, 0},
    {32104, 6407, 0},
    {22852, 1569, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22855, 1866, 0},
    {22856, 3541, 0},
    {22857, 3937, 10216},
    {0, 0, 0},
    {0, 0, 0},
    {32113, 3476, 0},
    {32114, 6406, 0},
    {22862, 4880, 10213},
    {22863, 3060, 0},
    {32117, 1699, 9814},
    {22865, 2099, 9437},
    {0, 0, 0},
    {22867, 8339, 11056},
    {32121, 2169, 9595},
    {22869, 4878, 0},
    {0, 0, 0},
    {22871, 3452, 0},
    {22872, 4882, 10221},
    {0, 0, 0},
    {22874, 4881, 0},
    {22875, 8340, 11057},
    {0, 0, 0},
    {22877, 8341, 11058},
    {0, 0, 0},
    {0, 0, 0},
    {22880, 4884, 0},
    {0, 0, 0},
    {22882, 4883, 0},
    {22883, 8342, 11059},
    {32137, 6412, 0},
    {22885, 1595, 0},
    {0, 0, 0},
    {22887, 4885, 0},
    {22888, 2734, 0},
    {22889, 4887, 0},
    {22890, 3200, 10220},
    {0, 0, 0},
    {22892, 4886, 0},
    {0, 0, 0},
    {22894, 3872, 10219},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22899, 2718, 0},
    {32153, 2116, 9496},
    {32154, 3120, 0},
    {32155, 6416, 0},
    {32156, 3085, 0},
    {22904, 4888, 0},
    {0, 0, 0},
    {32159, 6429, 0},
    {32160, 8508, 11225},
    {0, 0, 0},
    {22909, 2260, 10223},
    {32163, 6419, 0},
    {0, 0, 0},
    {0, 0, 0},
    {22913, 4889, 0},
    {22914, 3572, 0},
    {22915, 3727, 0},
    {22916, 4090, 0},
    {0, 0, 0},
    {32171, 6423, 0},
    {32172, 2627, 0},
    {32173, 1470, 0},
    {32174, 6418, 0},
    {22922, 3576, 10224},
    {32176, 6430, 0},
    {32177, 2298, 0},
    {32178, 4095, 9816},
    {0, 0, 0},
    {32180, 3343, 0},
    {32181, 6420, 0},
    {0, 0, 0},
    {32183, 8507, 11224},
    {22931, 1903, 10225},
    {0, 0, 0},
    {32186, 6417, 0},
    {32187, 3225, 9640},
    {0, 0, 0},
    {32189, 6422, 0},
    {32190, 1438, 9609},
    {32191, 4083, 0},
    {22939, 4993, 0},
    {0, 0, 0},
    {22941, 4890, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32199, 6421, 0},
    {22947, 4893, 0},
    {22948, 8343, 11060},
    {32202, 2032, 9450},
    {32203, 3741, 0},
    {0, 0, 0},
    {22952, 3971, 0},
    {0, 0, 0},
    {32207, 3084, 0},
    {0, 0, 0},
    {22956, 3425, 9659},
    {32210, 2710, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32213, 6469, 0},
    {32214, 8509, 11226},
    {22962, 4894, 0},
    {32216, 6431, 0},
    {0, 0, 0},
    {32218, 3007, 0},
    {0, 0, 0},
    {32220, 6427, 0},
    {32221, 6432, 0},
    {22969, 4016, 10226},
    {22970, 8344, 11061},
    {22971, 2391, 9487},
    {32225, 6437, 0},
    {0, 0, 0},
    {22974, 2735, 0},
    {32228, 6433, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32232, 3905, 0},
    {32233, 1828, 0},
    {0, 0, 0},
    {22982, 4895, 0},
    {32236, 4084, 0},
    {0, 0, 0},
    {22985, 2491, 0},
    {32239, 1471, 0},
    {22987, 2490, 0},
    {0, 0, 0},
    {32242, 6436, 0},
    {0, 0, 0},
    {32244, 4322, 0},
    {22992, 1434, 0},
    {22993, 2201, 0},
    {0, 0, 0},
    {22995, 2924, 0},
    {22996, 1458, 0},
    {0, 0, 0},
    {32251, 6435, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23001, 4899, 0},
    {23002, 4900, 0},
    {0, 0, 0},
    {32257, 1582, 9815},
    {0, 0, 0},
    {0, 0, 0},
    {32260, 3553, 0},
    {32261, 6438, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32265, 6445, 0},
    {23013, 1527, 10227},
    {23014, 1800, 10228},
    {0, 0, 0},
    {23016, 4896, 0},
    {0, 0, 0},
    {23018, 4078, 0},
    {23019, 3776, 0},
    {0, 0, 0},
    {32274, 6442, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23030, 1417, 9529},
    {0, 0, 0},
    {0, 0, 0},
    {32286, 2579, 0},
    {32287, 6444, 0},
    {23035, 1498, 0},
    {32289, 6441, 0},
    {32290, 6447, 0},
    {32291, 6440, 0},
    {23039, 2492, 0},
    {0, 0, 0},
    {23041, 1459, 9392},
    {0, 0, 0},
    {23043, 1412, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32299, 3952, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32302, 2675, 9819},
    {0, 0, 0},
    {0, 0, 0},
    {32305, 6443, 0},
    {32306, 6455, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32309, 6451, 0},
    {23057, 4903, 0},
    {32311, 6454, 0},
    {0, 0, 0},
    {32313, 6452, 0},
    {32314, 6456, 0},
    {32315, 6450, 0},
    {0, 0, 0},
    {23064, 4069, 10222},
    {32318, 2964, 0},
    {23066, 4906, 0},
    {0, 0, 0},
    {32321, 3708, 9818},
    {0, 0, 0},
    {32323, 6453, 0},
    {23071, 4902, 0},
    {23072, 2836, 0},
    {32326, 6448, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32330, 3008, 9817},
    {32331, 2117, 0},
    {0, 0, 0},
    {32333, 2642, 0},
    {23081, 3911, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32338, 8510, 11227},
    {0, 0, 0},
    {23087, 2229, 9413},
    {32341, 3029, 0},
    {32342, 6459, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32345, 6461, 0},
    {23093, 4910, 10230},
    {23094, 4911, 0},
    {0, 0, 0},
    {32349, 6458, 0},
    {32350, 6460, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23100, 2736, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23104, 4907, 0},
    {23105, 4335, 10229},
    {32359, 6457, 0},
    {0, 0, 0},
    {32361, 6465, 0},
    {32362, 6464, 0},
    {23110, 3615, 0},
    {0, 0, 0},
    {32365, 4037, 0},
    {23113, 4909, 0},
    {0, 0, 0},
    {32368, 2078, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32377, 6463, 0},
    {0, 0, 0},
    {32379, 6467, 0},
    {32380, 6466, 0},
    {32381, 6470, 0},
    {0, 0, 0},
    {23130, 2356, 10232},
    {0, 0, 0},
    {0, 0, 0},
    {32386, 2471, 0},
    {32387, 6468, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23138, 4912, 0},
    {32392, 6473, 0},
    {32393, 6474, 0},
    {32394, 8272, 10989},
    {23142, 3815, 0},
    {32396, 6475, 0},
    {0, 0, 0},
    {32398, 6481, 0},
    {32399, 3410, 9820},
    {32400, 6477, 0},
    {23148, 4908, 0},
    {32402, 6476, 0},
    {32403, 6478, 0},
    {32404, 6479, 0},
    {0, 0, 0},
    {32406, 6480, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32411, 6482, 0},
    {32412, 6483, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23167, 4068, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23186, 3633, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23194, 4914, 0},
    {23195, 3777, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23228, 4915, 0},
    {23229, 4919, 0},
    {23230, 4916, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23233, 1636, 0},
    {23234, 4918, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23241, 2564, 0},
    {0, 0, 0},
    {23243, 4917, 0},
    {23244, 2156, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23248, 4931, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23254, 4924, 0},
    {23255, 4921, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23265, 3263, 0},
    {0, 0, 0},
    {23267, 4920, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23270, 4922, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23273, 4923, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23290, 4925, 0},
    {23291, 4926, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23305, 1867, 0},
    {0, 0, 0},
    {23307, 4928, 0},
    {23308, 4927, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32566, 1829, 0},
    {0, 0, 0},
    {32568, 6484, 0},
    {0, 0, 0},
    {32570, 6485, 0},
    {23318, 4929, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32581, 6486, 0},
    {0, 0, 0},
    {23330, 2803, 10893},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32588, 6487, 0},
    {32589, 6488, 0},
    {32590, 6489, 0},
    {23338, 4932, 0},
    {32592, 6490, 0},
    {23340, 3349, 10233},
    {0, 0, 0},
    {0, 0, 0},
    {32596, 6493, 0},
    {23344, 1540, 10234},
    {0, 0, 0},
    {23346, 4930, 0},
    {32600, 6494, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23350, 4933, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32607, 6495, 0},
    {32608, 6496, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23358, 4934, 0},
    {0, 0, 0},
    {23360, 4937, 0},
    {0, 0, 0},
    {32615, 6499, 0},
    {23363, 4935, 10235},
    {32617, 6498, 0},
    {32618, 2414, 9821},
    {32619, 2118, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32622, 3249, 0},
    {0, 0, 0},
    {32624, 3684, 0},
    {0, 0, 0},
    {32626, 2711, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23376, 2493, 9523},
    {23377, 4938, 0},
    {32631, 3742, 0},
    {32632, 6500, 0},
    {23380, 2261, 9858},
    {23381, 4939, 0},
    {23382, 8345, 11062},
    {23383, 2533, 0},
    {23384, 3125, 0},
    {0, 0, 0},
    {23386, 4940, 0},
    {23387, 4941, 0},
    {23388, 2501, 0},
    {23389, 2262, 10236},
    {32643, 6503, 0},
    {23391, 4091, 0},
    {32645, 4204, 0},
    {32646, 6502, 0},
    {32647, 6505, 0},
    {23395, 1887, 10237},
    {23396, 2202, 0},
    {32650, 4186, 9822},
    {23398, 1747, 0},
    {32652, 6506, 0},
    {0, 0, 0},
    {32654, 3759, 9823},
    {0, 0, 0},
    {23403, 3126, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32660, 6507, 0},
    {23408, 4944, 0},
    {23409, 4984, 0},
    {0, 0, 0},
    {23411, 4945, 0},
    {0, 0, 0},
    {23413, 4946, 10239},
    {0, 0, 0},
    {0, 0, 0},
    {23416, 4947, 10238},
    {32670, 6508, 0},
    {23418, 4949, 0},
    {0, 0, 0},
    {32673, 8512, 11229},
    {0, 0, 0},
    {32675, 6511, 0},
    {32676, 2085, 0},
    {23424, 4950, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32680, 3009, 9824},
    {32681, 1912, 0},
    {23429, 3181, 0},
    {0, 0, 0},
    {23431, 1510, 0},
    {23432, 2610, 0},
    {23433, 1443, 10241},
    {32687, 6512, 0},
    {23435, 3062, 0},
    {23436, 1801, 0},
    {23437, 2558, 10240},
    {0, 0, 0},
    {23439, 2263, 0},
    {0, 0, 0},
    {32694, 6516, 0},
    {0, 0, 0},
    {32696, 6517, 0},
    {32697, 6514, 0},
    {23445, 3453, 0},
    {0, 0, 0},
    {23447, 2632, 0},
    {32701, 1512, 9300},
    {23449, 3267, 0},
    {23450, 3363, 0},
    {23451, 1433, 0},
    {32705, 1604, 9307},
    {23453, 3938, 0},
    {0, 0, 0},
    {23455, 2571, 0},
    {32709, 6519, 0},
    {32710, 6520, 0},
    {23458, 1929, 0},
    {23459, 2988, 0},
    {23460, 2565, 0},
    {23461, 4143, 10242},
    {23462, 4952, 0},
    {32716, 4201, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32722, 2643, 0},
    {23470, 1939, 0},
    {32724, 6523, 0},
    {23472, 2392, 10243},
    {0, 0, 0},
    {0, 0, 0},
    {23475, 1709, 0},
    {23476, 1570, 0},
    {23477, 2737, 0},
    {23478, 1637, 0},
    {0, 0, 0},
    {23480, 4953, 0},
    {23481, 4173, 0},
    {0, 0, 0},
    {32736, 2892, 0},
    {32737, 6524, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23487, 2672, 0},
    {23488, 8346, 11063},
    {32742, 6525, 0},
    {23490, 2605, 0},
    {23491, 4954, 0},
    {23492, 1868, 10244},
    {23493, 3527, 0},
    {32747, 1854, 9607},
    {23495, 4955, 0},
    {0, 0, 0},
    {23497, 4956, 0},
    {0, 0, 0},
    {32752, 1830, 0},
    {23500, 3816, 0},
    {0, 0, 0},
    {32755, 6527, 0},
    {0, 0, 0},
    {23504, 4958, 0},
    {0, 0, 0},
    {23506, 1793, 0},
    {23507, 2060, 0},
    {23508, 4957, 10245},
    {0, 0, 0},
    {32763, 4008, 0},
    {32764, 4202, 0},
    {23512, 8348, 11065},
    {0, 0, 0},
    {0, 0, 0},
    {23515, 1803, 9643},
    {32769, 4346, 0},
    {23517, 2837, 0},
    {32771, 2300, 9825},
    {23519, 2444, 10247},
    {32773, 2589, 0},
    {23521, 1638, 10246},
    {23522, 4961, 0},
    {0, 0, 0},
    {23524, 4959, 0},
    {23525, 4963, 0},
    {23526, 4960, 10248},
    {32780, 2546, 9518},
    {23528, 5590, 0},
    {23529, 2838, 0},
    {0, 0, 0},
    {32784, 3150, 9826},
    {23532, 8349, 11066},
    {32786, 6533, 0},
    {23534, 4261, 0},
    {0, 0, 0},
    {32789, 2299, 9827},
    {0, 0, 0},
    {32791, 4096, 0},
    {23539, 4967, 10249},
    {32793, 6535, 0},
    {23541, 3289, 0},
    {23542, 4966, 0},
    {32796, 6536, 0},
    {23544, 2916, 0},
    {0, 0, 0},
    {23546, 2534, 0},
    {0, 0, 0},
    {32801, 6537, 0},
    {0, 0, 0},
    {23550, 3149, 0},
    {23551, 2624, 0},
    {0, 0, 0},
    {23553, 3844, 0},
    {23554, 2989, 0},
    {32808, 6538, 0},
    {23556, 2582, 0},
    {23557, 4968, 0},
    {23558, 2738, 0},
    {23559, 4969, 0},
    {23560, 4970, 0},
    {23561, 1460, 0},
    {23562, 3127, 0},
    {23563, 2869, 0},
    {0, 0, 0},
    {23565, 4971, 0},
    {32819, 2547, 9504},
    {23567, 2739, 0},
    {0, 0, 0},
    {23569, 2740, 9625},
    {0, 0, 0},
    {23571, 4972, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23574, 2990, 10251},
    {0, 0, 0},
    {32829, 3226, 0},
    {0, 0, 0},
    {23578, 2741, 10250},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23582, 8350, 11067},
    {0, 0, 0},
    {23584, 4973, 0},
    {32838, 6542, 0},
    {23586, 4974, 0},
    {0, 0, 0},
    {23588, 4105, 0},
    {32842, 6541, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23592, 4975, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23597, 2011, 10252},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23601, 2633, 9428},
    {0, 0, 0},
    {32856, 6544, 0},
    {0, 0, 0},
    {32858, 6545, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23608, 4976, 0},
    {32862, 3878, 9828},
    {23610, 2597, 10253},
    {23611, 2831, 0},
    {32865, 3086, 9514},
    {23613, 2871, 10254},
    {23614, 3753, 0},
    {23615, 3573, 0},
    {23616, 2014, 0},
    {23617, 4978, 0},
    {0, 0, 0},
    {32872, 6548, 0},
    {0, 0, 0},
    {23621, 1958, 0},
    {23622, 4979, 0},
    {0, 0, 0},
    {23624, 2067, 0},
    {0, 0, 0},
    {23626, 3524, 9670},
    {23627, 1613, 10257},
    {0, 0, 0},
    {23629, 2494, 10256},
    {23630, 4980, 10255},
    {32884, 3305, 9829},
    {23632, 4982, 0},
    {23633, 2066, 10258},
    {32887, 2825, 0},
    {23635, 4981, 0},
    {32889, 6553, 0},
    {23637, 3407, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32893, 6554, 0},
    {32894, 4347, 0},
    {32895, 6555, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23646, 3117, 0},
    {32900, 6556, 0},
    {23648, 3426, 10260},
    {23649, 2577, 10259},
    {32903, 3670, 0},
    {0, 0, 0},
    {23652, 3063, 9515},
    {23653, 4225, 0},
    {32907, 4353, 0},
    {32908, 3674, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23660, 4985, 0},
    {0, 0, 0},
    {23662, 4986, 10262},
    {23663, 3531, 0},
    {0, 0, 0},
    {23665, 2462, 9409},
    {0, 0, 0},
    {32920, 3769, 0},
    {0, 0, 0},
    {32922, 6561, 0},
    {23670, 4988, 10261},
    {0, 0, 0},
    {32925, 1831, 0},
    {23673, 4989, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32929, 2213, 0},
    {32930, 2515, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32933, 3743, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32937, 2171, 0},
    {32938, 3982, 0},
    {0, 0, 0},
    {32940, 6564, 0},
    {32941, 6562, 0},
    {0, 0, 0},
    {32943, 2301, 0},
    {0, 0, 0},
    {32945, 2302, 9830},
    {32946, 1482, 0},
    {0, 0, 0},
    {32948, 2421, 0},
    {23696, 1869, 0},
    {23697, 4991, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23700, 4992, 0},
    {32954, 3628, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {32963, 1472, 0},
    {32964, 6569, 0},
    {0, 0, 0},
    {23713, 1609, 9464},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23718, 8351, 11068},
    {32972, 3627, 0},
    {23720, 3034, 0},
    {23721, 1853, 9451},
    {0, 0, 0},
    {23723, 4994, 0},
    {23724, 4049, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23729, 3151, 10266},
    {0, 0, 0},
    {23731, 1748, 0},
    {32985, 6567, 0},
    {32986, 6570, 0},
    {23734, 4996, 10264},
    {23735, 4998, 0},
    {23736, 1848, 10265},
    {32990, 3953, 0},
    {23738, 8352, 11069},
    {23739, 4995, 0},
    {32993, 2214, 9831},
    {0, 0, 0},
    {23742, 5000, 0},
    {32996, 1502, 0},
    {32997, 6566, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23749, 4999, 0},
    {0, 0, 0},
    {23751, 5001, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33007, 6573, 0},
    {0, 0, 0},
    {33009, 6574, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33012, 3502, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33016, 2000, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33020, 6585, 0},
    {33021, 3600, 0},
    {23769, 5002, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33026, 2516, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33029, 2001, 9505},
    {23777, 1987, 9430},
    {33031, 4361, 0},
    {33032, 4055, 0},
    {33033, 6572, 0},
    {33034, 2965, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23784, 1666, 0},
    {23785, 5003, 0},
    {23786, 5008, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23789, 5006, 0},
    {0, 0, 0},
    {23791, 3940, 0},
    {23792, 3939, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33050, 1930, 10829},
    {23798, 3454, 10267},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23802, 5005, 0},
    {23803, 2683, 0},
    {0, 0, 0},
    {23805, 5004, 0},
    {33059, 6577, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33065, 6576, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23815, 2901, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33071, 6578, 0},
    {23819, 5009, 0},
    {33073, 3201, 0},
    {0, 0, 0},
    {23822, 2423, 9519},
    {0, 0, 0},
    {0, 0, 0},
    {23825, 5015, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33081, 3306, 9832},
    {23829, 5010, 0},
    {23830, 1710, 0},
    {23831, 5011, 0},
    {23832, 5020, 0},
    {23833, 5019, 10268},
    {23834, 5018, 0},
    {23835, 5014, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23839, 5013, 0},
    {0, 0, 0},
    {33094, 6581, 0},
    {23842, 5017, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33099, 6579, 0},
    {23847, 8354, 11071},
    {0, 0, 0},
    {33102, 2872, 9583},
    {0, 0, 0},
    {33104, 3828, 0},
    {33105, 6584, 0},
    {0, 0, 0},
    {33107, 6583, 0},
    {33108, 2303, 0},
    {33109, 4374, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33119, 6600, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33125, 6588, 0},
    {33126, 6589, 0},
    {23874, 8357, 11074},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33131, 2617, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33134, 6587, 0},
    {0, 0, 0},
    {33136, 2343, 9833},
    {23884, 5021, 10269},
    {0, 0, 0},
    {23886, 5023, 0},
    {33140, 6590, 0},
    {23888, 4217, 0},
    {0, 0, 0},
    {23890, 5022, 0},
    {33144, 3307, 10830},
    {33145, 3855, 0},
    {33146, 3010, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33151, 3161, 0},
    {33152, 6594, 0},
    {23900, 5012, 0},
    {33154, 6595, 0},
    {33155, 6591, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33160, 6592, 0},
    {0, 0, 0},
    {33162, 6593, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23913, 2902, 0},
    {33167, 2304, 0},
    {0, 0, 0},
    {23916, 5025, 0},
    {23917, 8358, 11075},
    {33171, 6601, 0},
    {23919, 2372, 0},
    {33173, 6597, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23923, 5026, 0},
    {0, 0, 0},
    {33178, 3829, 0},
    {23926, 5027, 0},
    {33180, 4023, 0},
    {33181, 3767, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33184, 6596, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33187, 6599, 0},
    {33188, 6598, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23938, 5030, 0},
    {33192, 3983, 0},
    {23940, 5029, 10270},
    {0, 0, 0},
    {0, 0, 0},
    {23943, 5028, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23947, 3455, 10271},
    {23948, 5007, 0},
    {0, 0, 0},
    {33203, 3030, 0},
    {0, 0, 0},
    {23952, 5036, 10272},
    {0, 0, 0},
    {0, 0, 0},
    {33208, 6606, 0},
    {0, 0, 0},
    {33210, 6610, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33213, 6607, 0},
    {33214, 6605, 0},
    {33215, 3602, 0},
    {33216, 6608, 0},
    {0, 0, 0},
    {23965, 5032, 10273},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33222, 1615, 0},
    {23970, 5031, 0},
    {33224, 6616, 0},
    {33225, 6611, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33229, 6612, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {23980, 5033, 10274},
    {0, 0, 0},
    {33235, 3102, 9834},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33240, 6615, 0},
    {33241, 6614, 0},
    {33242, 6617, 0},
    {0, 0, 0},
    {23991, 5037, 0},
    {23992, 8359, 11076},
    {23993, 8360, 11077},
    {23994, 4299, 10275},
    {33248, 6619, 0},
    {23996, 5038, 0},
    {23997, 5035, 0},
    {33251, 2854, 0},
    {0, 0, 0},
    {33253, 1670, 0},
    {0, 0, 0},
    {33255, 6620, 0},
    {33256, 4284, 0},
    {0, 0, 0},
    {33258, 2548, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33261, 2644, 0},
    {24009, 5039, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24012, 1849, 0},
    {24013, 5040, 0},
    {33267, 2517, 0},
    {33268, 3250, 0},
    {24016, 8361, 11078},
    {0, 0, 0},
    {24018, 5042, 0},
    {24019, 5041, 0},
    {0, 0, 0},
    {33274, 6621, 0},
    {24022, 5043, 10276},
    {33276, 1520, 0},
    {0, 0, 0},
    {33278, 6623, 0},
    {0, 0, 0},
    {24027, 5044, 0},
    {33281, 6624, 0},
    {24029, 2991, 10277},
    {24030, 2634, 0},
    {0, 0, 0},
    {33285, 6626, 0},
    {24033, 2699, 0},
    {33287, 6627, 0},
    {33288, 2002, 9446},
    {33289, 5367, 0},
    {24037, 2264, 10278},
    {24038, 2373, 0},
    {24039, 2265, 9438},
    {24040, 1959, 10279},
    {33294, 2580, 0},
    {0, 0, 0},
    {24043, 5045, 10280},
    {0, 0, 0},
    {33298, 4433, 0},
    {24046, 2374, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24049, 2203, 10281},
    {33303, 3915, 9835},
    {33304, 1845, 9606},
    {24052, 3606, 0},
    {24053, 5047, 0},
    {33307, 3011, 0},
    {24055, 2266, 9393},
    {0, 0, 0},
    {33310, 3840, 0},
    {33311, 2645, 0},
    {24059, 1797, 0},
    {0, 0, 0},
    {24061, 3202, 0},
    {24062, 2023, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24066, 2495, 0},
    {24067, 3818, 0},
    {33321, 6632, 0},
    {33322, 2305, 0},
    {24070, 3698, 10282},
    {33324, 3709, 0},
    {0, 0, 0},
    {33326, 6647, 0},
    {0, 0, 0},
    {24075, 5048, 0},
    {24076, 1870, 0},
    {0, 0, 0},
    {33331, 6635, 0},
    {0, 0, 0},
    {33333, 3142, 0},
    {33334, 3656, 9836},
    {33335, 2192, 0},
    {33336, 6634, 0},
    {33337, 3012, 0},
    {0, 0, 0},
    {24086, 3290, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24089, 5050, 0},
    {24090, 5049, 0},
    {24091, 5052, 10283},
    {0, 0, 0},
    {24093, 3364, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33351, 3379, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24101, 2886, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24107, 2496, 0},
    {0, 0, 0},
    {24109, 2955, 0},
    {0, 0, 0},
    {24111, 3152, 0},
    {24112, 1881, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24115, 3291, 10284},
    {33369, 6637, 0},
    {33370, 6640, 0},
    {24118, 5053, 0},
    {24119, 5054, 0},
    {24120, 2804, 10285},
    {0, 0, 0},
    {33375, 6641, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24125, 3972, 10286},
    {0, 0, 0},
    {33380, 6642, 0},
    {24128, 5057, 0},
    {33382, 1832, 0},
    {0, 0, 0},
    {24131, 5056, 10287},
    {24132, 5055, 0},
    {24133, 3852, 10288},
    {33387, 6646, 0},
    {24135, 5064, 0},
    {0, 0, 0},
    {33390, 2366, 0},
    {33391, 4270, 0},
    {0, 0, 0},
    {24140, 4005, 10289},
    {33394, 2826, 0},
    {24142, 5058, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33398, 1583, 0},
    {33399, 6649, 0},
    {33400, 6650, 0},
    {24148, 5060, 0},
    {24149, 4022, 0},
    {0, 0, 0},
    {24151, 5059, 0},
    {0, 0, 0},
    {33406, 6651, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24159, 5061, 0},
    {0, 0, 0},
    {24161, 3673, 0},
    {24162, 5062, 0},
    {24163, 3883, 0},
    {24164, 5063, 0},
    {0, 0, 0},
    {33419, 1491, 0},
    {0, 0, 0},
    {33421, 6652, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33426, 6653, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24178, 1804, 0},
    {24179, 3884, 0},
    {24180, 3586, 9567},
    {24181, 5065, 0},
    {24182, 5066, 0},
    {0, 0, 0},
    {24184, 2267, 9379},
    {24185, 1805, 0},
    {24186, 5067, 10290},
    {24187, 2185, 0},
    {24188, 4171, 0},
    {24189, 4144, 0},
    {24190, 1871, 0},
    {24191, 5069, 0},
    {33445, 1700, 0},
    {33446, 1427, 9474},
    {0, 0, 0},
    {24195, 2268, 0},
    {24196, 2742, 0},
    {0, 0, 0},
    {33451, 6654, 0},
    {24199, 3728, 10292},
    {33453, 3617, 0},
    {0, 0, 0},
    {24202, 2743, 9418},
    {0, 0, 0},
    {33457, 1651, 0},
    {0, 0, 0},
    {33459, 3954, 0},
    {24207, 2719, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33464, 2128, 0},
    {33465, 2033, 0},
    {24213, 3365, 0},
    {24214, 3942, 10291},
    {24215, 3408, 0},
    {33469, 1671, 0},
    {0, 0, 0},
    {24218, 2269, 0},
    {0, 0, 0},
    {24220, 3819, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33477, 1788, 9837},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24230, 3440, 0},
    {24231, 2383, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24235, 2204, 0},
    {33489, 1584, 0},
    {24237, 3366, 10293},
    {33491, 4303, 0},
    {33492, 3162, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33495, 3795, 0},
    {0, 0, 0},
    {33497, 6673, 0},
    {24245, 1444, 0},
    {33499, 1652, 9397},
    {24247, 2270, 10297},
    {24248, 4174, 0},
    {33502, 6669, 0},
    {33503, 6660, 0},
    {0, 0, 0},
    {33505, 6658, 0},
    {0, 0, 0},
    {33507, 6659, 0},
    {0, 0, 0},
    {33509, 2604, 0},
    {33510, 2049, 9838},
    {33511, 3282, 9839},
    {24259, 3620, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33515, 3526, 0},
    {0, 0, 0},
    {24264, 5073, 0},
    {24265, 4316, 0},
    {24266, 4336, 0},
    {0, 0, 0},
    {33521, 1552, 0},
    {0, 0, 0},
    {33523, 6663, 0},
    {24271, 5075, 10294},
    {24272, 5074, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24275, 1730, 0},
    {33529, 6668, 0},
    {33530, 6664, 0},
    {24278, 5076, 10295},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24282, 5079, 0},
    {24283, 5080, 0},
    {33537, 8514, 11231},
    {33538, 4089, 9840},
    {33539, 6666, 0},
    {33540, 1653, 9556},
    {33541, 1784, 9403},
    {24289, 5082, 10296},
    {24290, 5081, 0},
    {24291, 5077, 0},
    {33545, 6672, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24296, 5083, 0},
    {33550, 2119, 9841},
    {0, 0, 0},
    {0, 0, 0},
    {24300, 5085, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24304, 5088, 0},
    {24305, 5086, 10300},
    {33559, 6685, 0},
    {24307, 5087, 10306},
    {24308, 5089, 0},
    {0, 0, 0},
    {24310, 1571, 0},
    {33564, 1420, 9486},
    {24312, 5090, 0},
    {0, 0, 0},
    {24314, 2157, 0},
    {24315, 1683, 0},
    {24316, 3593, 0},
    {0, 0, 0},
    {24318, 5091, 10309},
    {24319, 3568, 0},
    {0, 0, 0},
    {24321, 3912, 0},
    {0, 0, 0},
    {33576, 1490, 9842},
    {24324, 4337, 0},
    {0, 0, 0},
    {33579, 6684, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24329, 5093, 0},
    {24330, 3885, 10305},
    {24331, 5096, 0},
    {24332, 4418, 10302},
    {24333, 4434, 10301},
    {0, 0, 0},
    {24335, 2553, 10299},
    {24336, 3562, 10298},
    {33590, 3262, 9843},
    {0, 0, 0},
    {24339, 1940, 9458},
    {24340, 3293, 10304},
    {24341, 1499, 0},
    {24342, 5098, 0},
    {24343, 3859, 0},
    {24344, 2271, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24347, 3243, 10303},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24351, 3368, 0},
    {33605, 6682, 0},
    {24353, 8362, 11079},
    {0, 0, 0},
    {0, 0, 0},
    {33609, 3087, 0},
    {33610, 2120, 9626},
    {24358, 2186, 0},
    {24359, 2205, 0},
    {0, 0, 0},
    {24361, 5099, 0},
    {33615, 1536, 0},
    {33616, 6681, 0},
    {0, 0, 0},
    {33618, 2306, 9844},
    {0, 0, 0},
    {24367, 5106, 0},
    {0, 0, 0},
    {24369, 2606, 0},
    {0, 0, 0},
    {33624, 3088, 0},
    {24372, 8363, 11080},
    {24373, 3294, 0},
    {0, 0, 0},
    {24375, 1988, 0},
    {24376, 5101, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24380, 3770, 0},
    {33634, 8515, 11232},
    {24382, 3233, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24385, 5102, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24389, 8283, 11000},
    {0, 0, 0},
    {0, 0, 0},
    {24392, 5103, 0},
    {0, 0, 0},
    {24394, 1989, 0},
    {0, 0, 0},
    {24396, 5104, 0},
    {0, 0, 0},
    {24398, 5105, 10314},
    {0, 0, 0},
    {33653, 6700, 0},
    {24401, 5107, 0},
    {33655, 1654, 0},
    {24403, 3469, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33659, 1611, 9845},
    {24407, 5109, 10312},
    {0, 0, 0},
    {24409, 5110, 0},
    {33663, 8516, 11233},
    {0, 0, 0},
    {24412, 5095, 0},
    {24413, 5094, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33669, 6687, 0},
    {24417, 5111, 0},
    {24418, 2100, 10311},
    {0, 0, 0},
    {33673, 6702, 0},
    {33674, 6696, 0},
    {24422, 3766, 0},
    {24423, 8364, 11081},
    {0, 0, 0},
    {24425, 2393, 10310},
    {24426, 3782, 0},
    {24427, 3295, 0},
    {24428, 3802, 0},
    {24429, 5112, 0},
    {33683, 6665, 0},
    {0, 0, 0},
    {24432, 2745, 0},
    {24433, 1541, 10308},
    {0, 0, 0},
    {24435, 5113, 0},
    {0, 0, 0},
    {33690, 6688, 0},
    {0, 0, 0},
    {24439, 5114, 0},
    {0, 0, 0},
    {33694, 1833, 9627},
    {33695, 6690, 0},
    {33696, 6701, 0},
    {24444, 3729, 0},
    {33698, 6691, 0},
    {0, 0, 0},
    {24447, 5117, 0},
    {24448, 1596, 0},
    {24449, 2925, 0},
    {24450, 5116, 0},
    {24451, 5115, 10315},
    {24452, 2101, 0},
    {24453, 3153, 10307},
    {33707, 3663, 0},
    {24455, 5121, 0},
    {24456, 5119, 0},
    {0, 0, 0},
    {24458, 5118, 0},
    {24459, 4236, 0},
    {24460, 2230, 9645},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24464, 2720, 10313},
    {24465, 5120, 0},
    {24466, 3427, 0},
    {24467, 2661, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24471, 3509, 0},
    {24472, 5124, 10322},
    {24473, 5123, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33729, 6712, 0},
    {0, 0, 0},
    {24478, 5122, 0},
    {0, 0, 0},
    {33733, 2910, 9846},
    {24481, 2231, 0},
    {33735, 8517, 11234},
    {0, 0, 0},
    {0, 0, 0},
    {33738, 1917, 0},
    {0, 0, 0},
    {33740, 2034, 0},
    {24488, 5126, 0},
    {24489, 3851, 10316},
    {24490, 2690, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24493, 5127, 0},
    {33747, 1656, 9546},
    {0, 0, 0},
    {0, 0, 0},
    {33750, 2777, 0},
    {0, 0, 0},
    {24499, 3510, 10318},
    {24500, 3296, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33756, 2407, 10832},
    {0, 0, 0},
    {24505, 3399, 0},
    {33759, 3432, 0},
    {33760, 6715, 0},
    {24508, 5128, 0},
    {24509, 1890, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24515, 2839, 0},
    {33769, 3931, 0},
    {24517, 3771, 0},
    {33771, 6706, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33775, 1655, 0},
    {33776, 2215, 0},
    {24524, 1872, 9550},
    {24525, 3577, 10319},
    {0, 0, 0},
    {33780, 6704, 0},
    {0, 0, 0},
    {33782, 8518, 11235},
    {33783, 6713, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24534, 5129, 10324},
    {24535, 2497, 0},
    {24536, 3973, 10317},
    {24537, 3974, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24540, 1597, 0},
    {24541, 5134, 0},
    {33795, 6709, 10833},
    {33796, 3503, 0},
    {24544, 3268, 0},
    {0, 0, 0},
    {33799, 6714, 0},
    {0, 0, 0},
    {24548, 5131, 0},
    {0, 0, 0},
    {33803, 6711, 0},
    {33804, 3955, 0},
    {33805, 6717, 0},
    {33806, 1473, 0},
    {0, 0, 0},
    {24555, 1684, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33811, 6705, 0},
    {0, 0, 0},
    {24560, 5182, 0},
    {24561, 5133, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24565, 3587, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24568, 5132, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24571, 5130, 10321},
    {0, 0, 0},
    {24573, 2345, 10320},
    {0, 0, 0},
    {24575, 5136, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33833, 3646, 0},
    {33834, 6725, 0},
    {0, 0, 0},
    {33836, 6736, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33841, 1785, 0},
    {0, 0, 0},
    {24590, 5142, 0},
    {24591, 5148, 0},
    {24592, 5140, 10330},
    {0, 0, 0},
    {24594, 3443, 0},
    {33848, 6721, 0},
    {0, 0, 0},
    {24597, 5145, 0},
    {24598, 3820, 0},
    {33852, 6726, 0},
    {33853, 4213, 0},
    {24601, 5139, 0},
    {0, 0, 0},
    {24603, 5144, 0},
    {24604, 4300, 0},
    {24605, 2498, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24608, 3154, 0},
    {24609, 5137, 10328},
    {0, 0, 0},
    {33864, 8519, 11236},
    {33865, 4188, 0},
    {24613, 1941, 0},
    {24614, 5147, 0},
    {24615, 2926, 0},
    {24616, 1572, 0},
    {33870, 4239, 9847},
    {24618, 1685, 0},
    {24619, 5146, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24623, 1990, 0},
    {0, 0, 0},
    {24625, 5143, 0},
    {33879, 3283, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33883, 1766, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24634, 5149, 0},
    {0, 0, 0},
    {33889, 3841, 0},
    {33890, 6741, 0},
    {33891, 3478, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33894, 1426, 9848},
    {24642, 5161, 0},
    {24643, 5159, 0},
    {33897, 6734, 0},
    {0, 0, 0},
    {24646, 5156, 10327},
    {33900, 3089, 0},
    {33901, 6724, 0},
    {33902, 6732, 0},
    {24650, 5155, 10329},
    {24651, 4317, 0},
    {33905, 3583, 0},
    {24653, 5157, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33909, 1419, 9315},
    {0, 0, 0},
    {24658, 2272, 10326},
    {0, 0, 0},
    {33913, 6738, 0},
    {24661, 2721, 9568},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24665, 5164, 0},
    {24666, 5150, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33922, 6733, 10834},
    {0, 0, 0},
    {24671, 5154, 10325},
    {24672, 5138, 0},
    {0, 0, 0},
    {24674, 1687, 0},
    {24675, 5158, 0},
    {24676, 5160, 0},
    {24677, 3244, 0},
    {33931, 2778, 0},
    {0, 0, 0},
    {24680, 2357, 0},
    {24681, 1621, 0},
    {24682, 5152, 0},
    {33936, 2646, 9850},
    {24684, 5162, 0},
    {24685, 1992, 0},
    {0, 0, 0},
    {33940, 2549, 9448},
    {24688, 1761, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {33945, 4097, 0},
    {24693, 2102, 0},
    {0, 0, 0},
    {33948, 3798, 9849},
    {0, 0, 0},
    {0, 0, 0},
    {33951, 6744, 0},
    {0, 0, 0},
    {33953, 6753, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24705, 5165, 0},
    {0, 0, 0},
    {24707, 5168, 0},
    {24708, 5170, 0},
    {24709, 8368, 11085},
    {0, 0, 0},
    {0, 0, 0},
    {33965, 6731, 0},
    {24713, 2566, 0},
    {24714, 8369, 11086},
    {24715, 5176, 0},
    {24716, 3369, 0},
    {33970, 1778, 9851},
    {0, 0, 0},
    {33972, 8520, 11237},
    {0, 0, 0},
    {0, 0, 0},
    {24722, 5174, 0},
    {33976, 2813, 0},
    {24724, 1686, 10331},
    {0, 0, 0},
    {24726, 5172, 10334},
    {33980, 3090, 9852},
    {0, 0, 0},
    {0, 0, 0},
    {24730, 5169, 10332},
    {24731, 5171, 0},
    {33985, 6750, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24735, 2232, 9470},
    {24736, 4145, 0},
    {33990, 6751, 0},
    {0, 0, 0},
    {24739, 1806, 0},
    {33993, 4189, 0},
    {33994, 6740, 0},
    {24742, 1560, 9292},
    {24743, 5175, 0},
    {33997, 6746, 0},
    {24745, 3597, 0},
    {24746, 1422, 0},
    {34000, 6749, 0},
    {34001, 4053, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34006, 6752, 0},
    {24754, 3730, 0},
    {24755, 5135, 0},
    {24756, 5181, 10333},
    {24757, 5185, 10335},
    {24758, 4110, 0},
    {34012, 8276, 10993},
    {24760, 5178, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24764, 3456, 0},
    {24765, 5183, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24773, 2805, 0},
    {24774, 5184, 0},
    {24775, 3532, 9584},
    {0, 0, 0},
    {34030, 4324, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34036, 6756, 0},
    {0, 0, 0},
    {24785, 4362, 0},
    {0, 0, 0},
    {24787, 5180, 0},
    {0, 0, 0},
    {24789, 8371, 11088},
    {0, 0, 0},
    {34044, 6763, 0},
    {24792, 5186, 0},
    {0, 0, 0},
    {24794, 2346, 10336},
    {34048, 2572, 0},
    {24796, 2956, 0},
    {0, 0, 0},
    {24798, 8370, 11087},
    {24799, 1461, 0},
    {24800, 5179, 0},
    {24801, 5177, 10323},
    {0, 0, 0},
    {24803, 3065, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24807, 5167, 0},
    {24808, 2463, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34065, 3899, 0},
    {0, 0, 0},
    {34067, 4043, 0},
    {34068, 6762, 0},
    {24816, 3139, 10339},
    {24817, 5198, 0},
    {34071, 6757, 10835},
    {24819, 3066, 10337},
    {24820, 5193, 0},
    {34074, 1525, 0},
    {24822, 5190, 0},
    {24823, 5191, 0},
    {0, 0, 0},
    {24825, 2607, 0},
    {24826, 5194, 10338},
    {24827, 5197, 0},
    {34081, 6754, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24832, 5192, 0},
    {24833, 2636, 9483},
    {0, 0, 0},
    {24835, 5195, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24838, 5189, 0},
    {34092, 6759, 0},
    {34093, 1503, 9631},
    {24841, 4132, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24845, 5199, 0},
    {24846, 5200, 0},
    {24847, 1462, 0},
    {34101, 3103, 0},
    {24849, 8374, 11091},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24853, 5188, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34109, 3888, 0},
    {0, 0, 0},
    {24858, 2055, 0},
    {24859, 1415, 10340},
    {34113, 6768, 0},
    {0, 0, 0},
    {34115, 3722, 0},
    {24863, 1807, 0},
    {24864, 8372, 11089},
    {24865, 5196, 0},
    {0, 0, 0},
    {34120, 6767, 0},
    {34121, 2779, 0},
    {34122, 2578, 0},
    {34123, 6770, 0},
    {24871, 5204, 0},
    {24872, 5203, 0},
    {34126, 2003, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24876, 5208, 0},
    {0, 0, 0},
    {34131, 8521, 11238},
    {0, 0, 0},
    {34133, 6771, 10836},
    {0, 0, 0},
    {34135, 3848, 0},
    {34136, 6766, 0},
    {24884, 5209, 10895},
    {34138, 6727, 0},
    {0, 0, 0},
    {24887, 8375, 11092},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24892, 5207, 0},
    {24893, 5210, 0},
    {24894, 5202, 10341},
    {24895, 5206, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24898, 5211, 0},
    {34152, 4370, 0},
    {34153, 3479, 9853},
    {34154, 3842, 0},
    {34155, 8523, 11240},
    {24903, 5201, 0},
    {24904, 2535, 10344},
    {0, 0, 0},
    {24906, 5205, 0},
    {24907, 3155, 0},
    {24908, 2273, 0},
    {24909, 5187, 0},
    {24910, 2840, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34167, 6784, 0},
    {24915, 5225, 0},
    {0, 0, 0},
    {24917, 3926, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24920, 5215, 0},
    {24921, 5216, 10349},
    {24922, 5217, 0},
    {34176, 6772, 0},
    {0, 0, 0},
    {24925, 5224, 0},
    {0, 0, 0},
    {34180, 3657, 9855},
    {0, 0, 0},
    {0, 0, 0},
    {24930, 4040, 10347},
    {24931, 1808, 10342},
    {0, 0, 0},
    {24933, 5221, 10343},
    {0, 0, 0},
    {24935, 2104, 0},
    {24936, 1711, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24939, 5218, 10350},
    {34193, 6775, 0},
    {0, 0, 0},
    {24942, 4253, 0},
    {24943, 5220, 10345},
    {24944, 1463, 0},
    {24945, 5222, 0},
    {34199, 1585, 0},
    {24947, 5213, 0},
    {34201, 3546, 9854},
    {24949, 5226, 0},
    {24950, 2103, 10346},
    {24951, 5214, 10348},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24958, 4196, 0},
    {34212, 6773, 0},
    {0, 0, 0},
    {34214, 3013, 0},
    {24962, 4146, 0},
    {34216, 6777, 0},
    {34217, 2450, 0},
    {34218, 2856, 0},
    {34219, 2083, 0},
    {34220, 4125, 9856},
    {0, 0, 0},
    {34222, 4130, 0},
    {34223, 2713, 9857},
    {34224, 8525, 11242},
    {0, 0, 0},
    {0, 0, 0},
    {24974, 3101, 0},
    {0, 0, 0},
    {24976, 4318, 0},
    {24977, 5234, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24980, 5231, 10352},
    {34234, 6788, 0},
    {24982, 5228, 0},
    {0, 0, 0},
    {24984, 8377, 11094},
    {24985, 5227, 0},
    {24986, 5232, 0},
    {0, 0, 0},
    {34241, 4369, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {24996, 3869, 10351},
    {0, 0, 0},
    {0, 0, 0},
    {24999, 3497, 0},
    {34253, 4220, 0},
    {25001, 2105, 0},
    {34255, 6789, 0},
    {25003, 5235, 10353},
    {25004, 5230, 0},
    {0, 0, 0},
    {25006, 5236, 0},
    {0, 0, 0},
    {34261, 6792, 0},
    {0, 0, 0},
    {25010, 2158, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25014, 1614, 0},
    {34268, 6795, 0},
    {34269, 6793, 0},
    {0, 0, 0},
    {25018, 5244, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25022, 1809, 0},
    {34276, 3480, 0},
    {34277, 6794, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25027, 5242, 0},
    {34281, 3710, 0},
    {34282, 6781, 0},
    {25030, 5243, 0},
    {25031, 2358, 0},
    {25032, 5241, 0},
    {25033, 5239, 0},
    {25034, 5238, 0},
    {25035, 5245, 0},
    {25036, 5237, 0},
    {25037, 5247, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25040, 1688, 0},
    {0, 0, 0},
    {34295, 2714, 0},
    {0, 0, 0},
    {34297, 6796, 0},
    {34298, 6801, 0},
    {34299, 3091, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34302, 6800, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34306, 6769, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34310, 6802, 0},
    {34311, 3048, 0},
    {25059, 5249, 0},
    {0, 0, 0},
    {34314, 6797, 0},
    {25062, 5248, 10354},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34323, 6798, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34326, 5656, 0},
    {25074, 3297, 9913},
    {0, 0, 0},
    {25076, 5252, 0},
    {34330, 6804, 0},
    {25078, 5250, 0},
    {25079, 5240, 0},
    {25080, 2159, 0},
    {0, 0, 0},
    {25082, 5251, 0},
    {0, 0, 0},
    {25084, 5255, 0},
    {25085, 5254, 10355},
    {25086, 5256, 0},
    {25087, 5253, 0},
    {25088, 5257, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34349, 4221, 9859},
    {25097, 5259, 0},
    {25098, 3927, 10095},
    {34352, 6805, 0},
    {25100, 5261, 0},
    {25101, 5260, 0},
    {25102, 2662, 0},
    {0, 0, 0},
    {25104, 2927, 0},
    {25105, 1667, 0},
    {25106, 1689, 0},
    {25107, 8378, 11095},
    {25108, 5262, 0},
    {0, 0, 0},
    {25110, 1440, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25114, 2957, 10356},
    {25115, 5263, 0},
    {0, 0, 0},
    {25117, 7084, 0},
    {25118, 5264, 0},
    {25119, 2132, 0},
    {0, 0, 0},
    {25121, 5265, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25126, 2992, 0},
    {0, 0, 0},
    {34381, 6807, 0},
    {34382, 2216, 0},
    {25130, 5266, 0},
    {34384, 1931, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25134, 5267, 0},
    {25135, 1905, 10357},
    {34389, 4572, 9860},
    {0, 0, 0},
    {25138, 5269, 0},
    {25139, 5270, 0},
    {25140, 3156, 0},
    {34394, 1964, 0},
    {0, 0, 0},
    {34396, 4255, 0},
    {25144, 2206, 0},
    {34398, 2056, 0},
    {34399, 6810, 0},
    {25147, 4106, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25151, 3975, 0},
    {25152, 2705, 0},
    {25153, 5271, 0},
    {34407, 6811, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34411, 3273, 0},
    {25159, 2993, 0},
    {25160, 7266, 0},
    {25161, 3731, 0},
    {0, 0, 0},
    {25163, 2611, 0},
    {34417, 6812, 0},
    {25165, 2394, 0},
    {25166, 5272, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25171, 3140, 0},
    {34425, 3567, 0},
    {25173, 3860, 0},
    {34427, 1435, 0},
    {0, 0, 0},
    {25176, 3182, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25179, 5275, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25182, 5273, 0},
    {0, 0, 0},
    {25184, 5276, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25187, 5274, 0},
    {0, 0, 0},
    {34442, 1664, 0},
    {34443, 6817, 0},
    {34444, 6818, 0},
    {25192, 5277, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25198, 3870, 10358},
    {0, 0, 0},
    {34453, 2472, 0},
    {25201, 1432, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25206, 3821, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25209, 3732, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25212, 5278, 0},
    {0, 0, 0},
    {25214, 5281, 10359},
    {25215, 2746, 9520},
    {25216, 1906, 0},
    {0, 0, 0},
    {25218, 5279, 0},
    {25219, 5286, 0},
    {25220, 2747, 10360},
    {34474, 6816, 0},
    {34475, 6826, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25225, 5280, 0},
    {25226, 3607, 10362},
    {34480, 6823, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25233, 4197, 10361},
    {25234, 5282, 0},
    {25235, 5283, 0},
    {25236, 5287, 0},
    {25237, 3457, 0},
    {25238, 5284, 0},
    {25239, 2274, 0},
    {25240, 2975, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25243, 5301, 0},
    {25244, 3685, 0},
    {0, 0, 0},
    {25246, 3183, 0},
    {34500, 6821, 0},
    {0, 0, 0},
    {34502, 6822, 0},
    {34503, 2593, 0},
    {0, 0, 0},
    {34505, 6824, 0},
    {0, 0, 0},
    {34507, 3228, 10837},
    {0, 0, 0},
    {34509, 2121, 0},
    {34510, 1725, 0},
    {0, 0, 0},
    {25259, 3733, 0},
    {25260, 5370, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34516, 6827, 0},
    {0, 0, 0},
    {25265, 3943, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34521, 1722, 0},
    {25269, 3370, 0},
    {34523, 6832, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25273, 4032, 10363},
    {34527, 6831, 0},
    {25275, 5290, 0},
    {25276, 1598, 0},
    {25277, 3269, 0},
    {0, 0, 0},
    {34532, 3691, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25282, 5299, 0},
    {0, 0, 0},
    {34537, 6829, 0},
    {25285, 3215, 0},
    {25286, 5293, 0},
    {25287, 5300, 10364},
    {34541, 3799, 9861},
    {34542, 3723, 9862},
    {25290, 5298, 10365},
    {0, 0, 0},
    {25292, 5297, 0},
    {25293, 3650, 0},
    {0, 0, 0},
    {25295, 5291, 0},
    {25296, 1690, 0},
    {25297, 5289, 0},
    {25298, 1960, 0},
    {25299, 3184, 9459},
    {25300, 5285, 10370},
    {0, 0, 0},
    {34555, 6839, 0},
    {25303, 5288, 0},
    {25304, 2275, 0},
    {34558, 1672, 9434},
    {0, 0, 0},
    {25307, 2748, 10368},
    {25308, 5296, 0},
    {25309, 3621, 9585},
    {34563, 6838, 0},
    {0, 0, 0},
    {25312, 1961, 0},
    {25313, 1731, 10367},
    {0, 0, 0},
    {34568, 6836, 0},
    {34569, 6841, 0},
    {34570, 6844, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34573, 6842, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25324, 1762, 10369},
    {25325, 2820, 10366},
    {25326, 5304, 0},
    {25327, 5309, 0},
    {0, 0, 0},
    {25329, 5305, 0},
    {0, 0, 0},
    {25331, 2160, 9468},
    {0, 0, 0},
    {25333, 5310, 10371},
    {25334, 2445, 0},
    {25335, 2328, 9608},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25342, 2637, 0},
    {25343, 5292, 0},
    {34597, 6849, 0},
    {25345, 2536, 0},
    {25346, 5307, 0},
    {0, 0, 0},
    {34601, 6850, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25351, 2499, 0},
    {25352, 5308, 0},
    {25353, 1445, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25356, 5303, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34612, 6845, 0},
    {0, 0, 0},
    {25361, 3298, 0},
    {34615, 6847, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34619, 6848, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25369, 1962, 0},
    {34623, 6846, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25375, 1993, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34633, 2983, 0},
    {0, 0, 0},
    {34635, 4348, 0},
    {25383, 5306, 10373},
    {25384, 1416, 0},
    {34638, 6856, 0},
    {0, 0, 0},
    {25387, 2384, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34643, 6862, 0},
    {25391, 2841, 0},
    {34645, 2829, 0},
    {0, 0, 0},
    {34647, 6858, 0},
    {0, 0, 0},
    {34649, 6861, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25402, 3371, 10372},
    {34656, 6852, 0},
    {0, 0, 0},
    {25405, 3717, 0},
    {25406, 5312, 10376},
    {25407, 3069, 0},
    {0, 0, 0},
    {34662, 1657, 0},
    {0, 0, 0},
    {34664, 6859, 0},
    {0, 0, 0},
    {34666, 6864, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25417, 3111, 10375},
    {0, 0, 0},
    {0, 0, 0},
    {25420, 2454, 0},
    {25421, 5313, 0},
    {0, 0, 0},
    {25423, 5315, 10374},
    {25424, 5311, 0},
    {34678, 3308, 0},
    {0, 0, 0},
    {34680, 6854, 0},
    {0, 0, 0},
    {25429, 3918, 0},
    {0, 0, 0},
    {25431, 3318, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34687, 3643, 0},
    {0, 0, 0},
    {25436, 3067, 0},
    {34690, 6868, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25447, 3944, 0},
    {25448, 2583, 9638},
    {25449, 5327, 0},
    {0, 0, 0},
    {25451, 5326, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25454, 2907, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25458, 2161, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25462, 5320, 0},
    {25463, 2750, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25466, 3549, 10377},
    {25467, 3588, 0},
    {0, 0, 0},
    {34722, 6866, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25472, 5318, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25475, 3068, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34731, 6875, 0},
    {0, 0, 0},
    {25480, 2625, 0},
    {25481, 5323, 0},
    {34735, 6869, 0},
    {0, 0, 0},
    {25484, 2749, 0},
    {0, 0, 0},
    {25486, 5317, 10383},
    {25487, 5322, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25490, 3622, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34746, 4205, 0},
    {25494, 5316, 10386},
    {0, 0, 0},
    {25496, 2068, 10378},
    {0, 0, 0},
    {0, 0, 0},
    {25499, 1752, 10379},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25503, 5324, 10382},
    {25504, 4240, 0},
    {25505, 2395, 10385},
    {25506, 3216, 10384},
    {25507, 5321, 0},
    {0, 0, 0},
    {25509, 2973, 0},
    {34763, 6870, 0},
    {25511, 2276, 0},
    {25512, 2887, 0},
    {25513, 1573, 0},
    {25514, 3035, 0},
    {25515, 5319, 10380},
    {25516, 1916, 0},
    {34770, 6890, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25522, 2106, 0},
    {0, 0, 0},
    {25524, 3336, 0},
    {25525, 5325, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25531, 3070, 10387},
    {0, 0, 0},
    {0, 0, 0},
    {25534, 5328, 0},
    {0, 0, 0},
    {25536, 5330, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25539, 3124, 0},
    {25540, 5336, 0},
    {0, 0, 0},
    {25542, 5331, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25545, 5333, 0},
    {34799, 6881, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34802, 6882, 0},
    {0, 0, 0},
    {25551, 3792, 0},
    {25552, 3372, 0},
    {34806, 6887, 0},
    {25554, 5334, 10388},
    {0, 0, 0},
    {34809, 1701, 0},
    {0, 0, 0},
    {34811, 1913, 9634},
    {0, 0, 0},
    {0, 0, 0},
    {34814, 6886, 0},
    {25562, 4175, 0},
    {25563, 1810, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34821, 6865, 0},
    {25569, 1423, 0},
    {34823, 8528, 11245},
    {25571, 5332, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34829, 6885, 0},
    {25577, 5329, 10389},
    {34831, 6884, 0},
    {0, 0, 0},
    {34833, 6891, 0},
    {0, 0, 0},
    {25582, 1873, 0},
    {0, 0, 0},
    {34837, 6893, 0},
    {34838, 6892, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25588, 1574, 0},
    {25589, 8380, 11097},
    {25590, 5335, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25594, 4176, 0},
    {0, 0, 0},
    {34849, 6895, 0},
    {34850, 6894, 0},
    {34851, 6825, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34855, 6899, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25606, 5339, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34865, 6896, 0},
    {25613, 3128, 0},
    {0, 0, 0},
    {25615, 5346, 0},
    {0, 0, 0},
    {34870, 6897, 0},
    {0, 0, 0},
    {25619, 5340, 0},
    {34873, 6898, 0},
    {0, 0, 0},
    {25622, 5337, 10390},
    {25623, 5344, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34880, 2143, 0},
    {25628, 5314, 0},
    {34882, 6902, 0},
    {0, 0, 0},
    {34884, 6901, 0},
    {0, 0, 0},
    {34886, 2647, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25638, 5341, 0},
    {34892, 2307, 0},
    {25640, 5345, 9939},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25644, 3699, 0},
    {25645, 3458, 10391},
    {34899, 2680, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34903, 1716, 0},
    {0, 0, 0},
    {25652, 5338, 10392},
    {0, 0, 0},
    {34907, 1553, 9863},
    {0, 0, 0},
    {34909, 2780, 0},
    {34910, 6905, 0},
    {25658, 2107, 0},
    {0, 0, 0},
    {34913, 2308, 0},
    {34914, 6906, 0},
    {34915, 1474, 9360},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25666, 2974, 0},
    {34920, 3788, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34923, 6907, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34928, 2893, 0},
    {0, 0, 0},
    {34930, 6914, 0},
    {25678, 5350, 0},
    {0, 0, 0},
    {34933, 6911, 0},
    {0, 0, 0},
    {34935, 3274, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25688, 3389, 10393},
    {34942, 6909, 0},
    {34943, 2035, 0},
    {0, 0, 0},
    {34945, 6908, 0},
    {34946, 6915, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25696, 8381, 11098},
    {0, 0, 0},
    {0, 0, 0},
    {34952, 2089, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34955, 3163, 0},
    {25703, 5347, 0},
    {34957, 6921, 0},
    {25705, 4011, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34962, 6917, 0},
    {0, 0, 0},
    {25711, 5348, 0},
    {0, 0, 0},
    {34966, 3122, 0},
    {34967, 6916, 0},
    {0, 0, 0},
    {34969, 6919, 0},
    {0, 0, 0},
    {25718, 5349, 0},
    {0, 0, 0},
    {25720, 4087, 0},
    {34974, 6910, 0},
    {25722, 2915, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34978, 6920, 0},
    {0, 0, 0},
    {34980, 6922, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25731, 2133, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34987, 3744, 0},
    {0, 0, 0},
    {25736, 5356, 0},
    {34990, 6918, 0},
    {0, 0, 0},
    {34992, 6923, 0},
    {34993, 6925, 0},
    {0, 0, 0},
    {0, 0, 0},
    {34996, 2212, 0},
    {34997, 6913, 0},
    {0, 0, 0},
    {34999, 1442, 9364},
    {25747, 5353, 0},
    {0, 0, 0},
    {25749, 5352, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25754, 3589, 10394},
    {0, 0, 0},
    {35009, 2408, 0},
    {35010, 4315, 10838},
    {25758, 3498, 10395},
    {35012, 6927, 0},
    {35013, 3092, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25764, 3400, 0},
    {25765, 5354, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25769, 5355, 0},
    {35023, 4231, 0},
    {25771, 3838, 0},
    {0, 0, 0},
    {25773, 3608, 0},
    {25774, 2446, 0},
    {35028, 6928, 0},
    {25776, 2994, 9637},
    {0, 0, 0},
    {25778, 3995, 0},
    {35032, 6929, 0},
    {35033, 6930, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35036, 3921, 0},
    {35037, 6931, 0},
    {25785, 1732, 0},
    {35039, 2381, 0},
    {25787, 5362, 0},
    {35041, 4232, 9864},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25793, 4177, 0},
    {25794, 5364, 0},
    {35048, 6936, 0},
    {0, 0, 0},
    {25797, 5360, 0},
    {0, 0, 0},
    {25799, 5361, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25805, 3071, 10397},
    {35059, 2781, 10839},
    {35060, 6935, 0},
    {35061, 8529, 11246},
    {0, 0, 0},
    {25810, 5359, 0},
    {35064, 4206, 0},
    {25812, 5294, 10396},
    {0, 0, 0},
    {0, 0, 0},
    {35068, 6934, 0},
    {35069, 2942, 9865},
    {35070, 2913, 0},
    {25818, 5358, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35074, 6933, 0},
    {0, 0, 0},
    {35076, 6938, 0},
    {25824, 5368, 0},
    {25825, 5369, 0},
    {25826, 3390, 9571},
    {25827, 5371, 0},
    {0, 0, 0},
    {35082, 6940, 0},
    {25830, 2447, 0},
    {25831, 5366, 10398},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35088, 1767, 0},
    {25836, 1907, 0},
    {35090, 3958, 0},
    {35091, 6941, 0},
    {25839, 5372, 0},
    {0, 0, 0},
    {25841, 5365, 0},
    {25842, 5376, 0},
    {0, 0, 0},
    {25844, 5375, 0},
    {0, 0, 0},
    {25846, 5374, 0},
    {35100, 8273, 10990},
    {35101, 6953, 0},
    {35102, 6943, 0},
    {25850, 5377, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25853, 5379, 0},
    {25854, 2806, 0},
    {0, 0, 0},
    {25856, 5378, 10399},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25861, 5382, 10400},
    {35115, 6946, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35126, 6950, 0},
    {0, 0, 0},
    {35128, 6951, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35131, 6949, 0},
    {0, 0, 0},
    {25880, 5380, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25884, 5381, 10401},
    {25885, 5343, 0},
    {35139, 6942, 0},
    {35140, 6948, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25891, 5384, 0},
    {25892, 5383, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35148, 6952, 0},
    {35149, 7448, 0},
    {0, 0, 0},
    {25898, 5351, 0},
    {25899, 5385, 0},
    {25900, 5373, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25903, 2500, 0},
    {0, 0, 0},
    {35158, 1605, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25908, 5386, 0},
    {25909, 5387, 0},
    {25910, 5389, 0},
    {25911, 5388, 0},
    {25912, 5390, 0},
    {25913, 1691, 10403},
    {35167, 2036, 0},
    {25915, 2277, 10402},
    {0, 0, 0},
    {0, 0, 0},
    {25918, 3945, 0},
    {25919, 2928, 10404},
    {0, 0, 0},
    {35174, 6956, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25925, 2207, 10406},
    {0, 0, 0},
    {0, 0, 0},
    {25928, 5392, 10405},
    {0, 0, 0},
    {35183, 6960, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35186, 2648, 9866},
    {25934, 8384, 11101},
    {25935, 3809, 10407},
    {0, 0, 0},
    {25937, 1942, 0},
    {35191, 6962, 0},
    {0, 0, 0},
    {0, 0, 0},
    {25941, 5394, 0},
    {25942, 5393, 0},
    {25943, 3623, 0},
    {25944, 5396, 0},
    {25945, 1994, 10408},
    {35199, 2943, 0},
    {0, 0, 0},
    {35201, 4190, 0},
    {25949, 5398, 0},
    {25950, 5397, 10409},
    {0, 0, 0},
    {0, 0, 0},
    {35206, 3857, 0},
    {25954, 1811, 9521},
    {25955, 2465, 10410},
    {0, 0, 0},
    {35210, 6966, 0},
    {35211, 2172, 9510},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35215, 1891, 0},
    {0, 0, 0},
    {25964, 2108, 0},
    {0, 0, 0},
    {35219, 6967, 0},
    {0, 0, 0},
    {25968, 2903, 0},
    {35222, 2518, 0},
    {35223, 3604, 9867},
    {35224, 6968, 0},
    {25972, 2929, 0},
    {35226, 1739, 9490},
    {0, 0, 0},
    {25975, 3822, 0},
    {25976, 5400, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35233, 6969, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35238, 6971, 0},
    {35239, 4222, 9868},
    {25987, 5402, 0},
    {35241, 6970, 0},
    {35242, 2857, 0},
    {0, 0, 0},
    {25991, 3877, 10411},
    {25992, 4948, 0},
    {25993, 2951, 0},
    {35247, 6973, 0},
    {0, 0, 0},
    {25996, 3803, 0},
    {35250, 6974, 0},
    {35251, 1834, 9352},
    {0, 0, 0},
    {26000, 3734, 0},
    {26001, 3700, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35258, 6975, 0},
    {0, 0, 0},
    {26007, 3428, 0},
    {35261, 6976, 0},
    {26009, 4262, 0},
    {35263, 6977, 0},
    {26011, 5404, 10412},
    {26012, 2585, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26015, 5405, 0},
    {0, 0, 0},
    {26017, 1431, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26020, 2025, 0},
    {26021, 2958, 0},
    {0, 0, 0},
    {26023, 3823, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26027, 5406, 0},
    {26028, 2477, 0},
    {35282, 1740, 9466},
    {0, 0, 0},
    {26031, 2502, 0},
    {26032, 2842, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35290, 6979, 0},
    {0, 0, 0},
    {26039, 5407, 10413},
    {35293, 6981, 0},
    {26041, 3946, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26044, 1590, 0},
    {26045, 2503, 0},
    {35299, 1679, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35302, 2827, 9870},
    {35303, 6982, 0},
    {26051, 5408, 0},
    {26052, 5411, 0},
    {26053, 4254, 0},
    {26054, 5409, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26059, 3004, 0},
    {26060, 5412, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26063, 3119, 10414},
    {0, 0, 0},
    {0, 0, 0},
    {26066, 5413, 0},
    {35320, 6984, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26071, 1875, 0},
    {0, 0, 0},
    {26073, 5415, 0},
    {0, 0, 0},
    {35328, 2193, 9871},
    {0, 0, 0},
    {35330, 3380, 0},
    {35331, 6985, 0},
    {0, 0, 0},
    {26080, 5416, 0},
    {26081, 5417, 0},
    {26082, 1876, 0},
    {35336, 2122, 0},
    {0, 0, 0},
    {35338, 2873, 9516},
    {26086, 3217, 0},
    {26087, 1955, 10416},
    {26088, 2504, 0},
    {26089, 3072, 9501},
    {0, 0, 0},
    {35344, 6987, 0},
    {26092, 2691, 0},
    {26093, 1425, 10896},
    {35347, 2084, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26097, 5418, 10415},
    {35351, 3188, 0},
    {35352, 1892, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35355, 6989, 0},
    {0, 0, 0},
    {35357, 6990, 0},
    {0, 0, 0},
    {26106, 1599, 9410},
    {26107, 5422, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35363, 2144, 0},
    {0, 0, 0},
    {35365, 6991, 10840},
    {0, 0, 0},
    {26114, 2278, 0},
    {26115, 5421, 0},
    {0, 0, 0},
    {35370, 3959, 0},
    {26118, 2360, 0},
    {26119, 2751, 0},
    {35373, 2976, 0},
    {26121, 8388, 11105},
    {26122, 5420, 0},
    {0, 0, 0},
    {35377, 1965, 9404},
    {0, 0, 0},
    {26126, 4073, 9628},
    {26127, 2359, 9444},
    {0, 0, 0},
    {35382, 6992, 0},
    {35383, 8531, 11248},
    {26131, 1464, 0},
    {26132, 2959, 0},
    {35386, 2858, 10841},
    {35387, 3275, 0},
    {35388, 2783, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26140, 5427, 10417},
    {0, 0, 0},
    {26142, 8390, 11107},
    {26143, 2930, 0},
    {26144, 1542, 0},
    {35398, 6996, 0},
    {0, 0, 0},
    {35400, 6997, 0},
    {26148, 8391, 11108},
    {26149, 2684, 0},
    {0, 0, 0},
    {26151, 4017, 0},
    {26152, 2431, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35408, 2379, 0},
    {35409, 3135, 0},
    {26157, 2753, 10419},
    {26158, 8389, 11106},
    {35412, 2784, 9426},
    {35413, 3789, 0},
    {26161, 8279, 10996},
    {0, 0, 0},
    {0, 0, 0},
    {26164, 5426, 0},
    {26165, 5424, 0},
    {26166, 5425, 10418},
    {0, 0, 0},
    {0, 0, 0},
    {35422, 2519, 0},
    {0, 0, 0},
    {35424, 1554, 10842},
    {26172, 3270, 0},
    {35426, 7001, 0},
    {35427, 2123, 0},
    {26175, 5457, 0},
    {0, 0, 0},
    {35430, 2521, 9874},
    {26178, 2537, 0},
    {26179, 2279, 0},
    {35433, 2520, 9872},
    {0, 0, 0},
    {35435, 4368, 0},
    {35436, 7000, 0},
    {35437, 6999, 0},
    {35438, 3014, 9873},
    {0, 0, 0},
    {35440, 1924, 9416},
    {35441, 4358, 0},
    {35442, 1717, 0},
    {35443, 2785, 0},
    {26191, 5428, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26194, 2458, 0},
    {0, 0, 0},
    {35449, 8532, 11249},
    {0, 0, 0},
    {0, 0, 0},
    {35452, 6998, 10843},
    {0, 0, 0},
    {26201, 8394, 11111},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26205, 5433, 10420},
    {26206, 5432, 0},
    {26207, 5437, 10421},
    {35461, 7002, 0},
    {0, 0, 0},
    {35463, 2217, 9878},
    {0, 0, 0},
    {35465, 4167, 9875},
    {26213, 8392, 11109},
    {26214, 1693, 0},
    {35468, 2522, 9876},
    {35469, 3578, 9877},
    {26217, 3718, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35473, 7007, 0},
    {0, 0, 0},
    {35475, 2945, 9564},
    {26223, 2109, 0},
    {35477, 3229, 9879},
    {0, 0, 0},
    {0, 0, 0},
    {35480, 4157, 10845},
    {26228, 2931, 0},
    {35482, 7010, 0},
    {26230, 2754, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35486, 2237, 0},
    {26234, 3245, 0},
    {35488, 2944, 0},
    {35489, 7006, 0},
    {0, 0, 0},
    {35491, 7011, 0},
    {35492, 2238, 0},
    {35493, 7008, 0},
    {26241, 2012, 10423},
    {35495, 8533, 11250},
    {26243, 5440, 10422},
    {26244, 5444, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26247, 1640, 9436},
    {35501, 3518, 9880},
    {26249, 5443, 0},
    {0, 0, 0},
    {35504, 3210, 0},
    {0, 0, 0},
    {35506, 1658, 0},
    {26254, 5442, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26257, 2706, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35513, 3745, 0},
    {0, 0, 0},
    {26262, 3235, 0},
    {26263, 1446, 9310},
    {26264, 5445, 0},
    {26265, 8397, 10897},
    {35519, 3309, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26269, 5446, 10424},
    {0, 0, 0},
    {35524, 7012, 0},
    {26272, 8398, 11115},
    {0, 0, 0},
    {35527, 3239, 9475},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35531, 2946, 9668},
    {35532, 1835, 0},
    {35533, 7013, 0},
    {0, 0, 0},
    {35535, 2878, 0},
    {26283, 2478, 0},
    {0, 0, 0},
    {35538, 4271, 0},
    {26286, 3928, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35542, 4355, 0},
    {26290, 8399, 11116},
    {0, 0, 0},
    {26292, 3976, 0},
    {35546, 7015, 0},
    {35547, 7026, 0},
    {35548, 3310, 0},
    {26296, 5453, 0},
    {26297, 5448, 10425},
    {35551, 8535, 11252},
    {35552, 7022, 0},
    {26300, 5451, 10427},
    {35554, 7023, 0},
    {26302, 5450, 0},
    {35556, 7019, 10846},
    {0, 0, 0},
    {35558, 3381, 9881},
    {35559, 7018, 0},
    {0, 0, 0},
    {26308, 5452, 0},
    {0, 0, 0},
    {35563, 7016, 0},
    {26311, 3539, 0},
    {35565, 4136, 0},
    {35566, 2523, 9882},
    {0, 0, 0},
    {0, 0, 0},
    {35569, 7020, 0},
    {0, 0, 0},
    {35571, 7017, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35574, 8537, 11254},
    {35575, 7024, 0},
    {35576, 2715, 0},
    {0, 0, 0},
    {35578, 2194, 0},
    {26326, 5454, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26329, 2707, 9457},
    {26330, 5455, 0},
    {35584, 3984, 0},
    {35585, 1561, 9641},
    {35586, 1475, 9528},
    {0, 0, 0},
    {35588, 3482, 0},
    {26336, 5456, 0},
    {0, 0, 0},
    {35591, 7028, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26342, 5458, 0},
    {35596, 7027, 0},
    {0, 0, 0},
    {35598, 3547, 9883},
    {0, 0, 0},
    {35600, 7032, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35604, 7021, 0},
    {26352, 5460, 0},
    {35606, 7031, 0},
    {26354, 2015, 10428},
    {26355, 1543, 0},
    {35609, 2173, 9338},
    {26357, 5461, 10426},
    {35611, 2309, 0},
    {26359, 5462, 0},
    {35613, 2590, 9398},
    {26361, 3073, 0},
    {26362, 8401, 11118},
    {35616, 7034, 10803},
    {35617, 4191, 9732},
    {26365, 3037, 0},
    {26366, 3036, 0},
    {26367, 3157, 0},
    {26368, 2388, 0},
    {35622, 7037, 0},
    {0, 0, 0},
    {26371, 4499, 10429},
    {0, 0, 0},
    {0, 0, 0},
    {35627, 7038, 0},
    {35628, 3780, 0},
    {26376, 2145, 0},
    {26377, 4148, 0},
    {0, 0, 0},
    {26379, 3947, 0},
    {0, 0, 0},
    {26381, 3853, 0},
    {35635, 7035, 10847},
    {26383, 5463, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35641, 2037, 9361},
    {26389, 3320, 0},
    {26390, 5464, 0},
    {26391, 4338, 0},
    {0, 0, 0},
    {35646, 7039, 0},
    {0, 0, 0},
    {26395, 3977, 0},
    {35649, 7041, 0},
    {26397, 3300, 0},
    {26398, 5465, 0},
    {26399, 1877, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35657, 7045, 0},
    {0, 0, 0},
    {26406, 5466, 0},
    {26407, 5467, 10430},
    {26408, 4099, 0},
    {35662, 7044, 0},
    {26410, 4045, 10431},
    {26411, 4033, 0},
    {26412, 4007, 0},
    {26413, 2448, 0},
    {26414, 5469, 10899},
    {0, 0, 0},
    {0, 0, 0},
    {26417, 2612, 10432},
    {0, 0, 0},
    {35672, 2554, 0},
    {26420, 3996, 0},
    {35674, 7048, 0},
    {26422, 5471, 10433},
    {35676, 3831, 9886},
    {26424, 5473, 0},
    {0, 0, 0},
    {26426, 1874, 10435},
    {0, 0, 0},
    {0, 0, 0},
    {26429, 1943, 0},
    {0, 0, 0},
    {26431, 5470, 0},
    {0, 0, 0},
    {35686, 2124, 9885},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26438, 5475, 10434},
    {35692, 7051, 0},
    {0, 0, 0},
    {26441, 2908, 0},
    {35695, 7052, 0},
    {35696, 1915, 0},
    {35697, 6518, 0},
    {35698, 2814, 0},
    {26446, 4226, 0},
    {26447, 1450, 10436},
    {26448, 2413, 0},
    {26449, 3129, 0},
    {35703, 2239, 0},
    {26451, 2598, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26454, 2808, 0},
    {0, 0, 0},
    {35709, 7054, 0},
    {26457, 5478, 0},
    {35711, 8539, 11256},
    {35712, 7055, 0},
    {26460, 3429, 0},
    {0, 0, 0},
    {35715, 2473, 9887},
    {26463, 3112, 0},
    {26464, 5477, 0},
    {26465, 2807, 0},
    {26466, 4102, 0},
    {26467, 5479, 0},
    {26468, 5480, 0},
    {26469, 4207, 9869},
    {26470, 8404, 11121},
    {35724, 7056, 0},
    {0, 0, 0},
    {35726, 7057, 0},
    {26474, 5485, 0},
    {35728, 2649, 0},
    {0, 0, 0},
    {26477, 2281, 10437},
    {35731, 7059, 0},
    {26479, 3624, 0},
    {26480, 5482, 0},
    {26481, 3459, 10438},
    {26482, 5419, 0},
    {26483, 5423, 0},
    {35737, 7061, 0},
    {26485, 1926, 10439},
    {0, 0, 0},
    {26487, 3610, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26492, 5484, 0},
    {0, 0, 0},
    {26494, 2755, 0},
    {26495, 3701, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26501, 5490, 0},
    {0, 0, 0},
    {26503, 3755, 0},
    {0, 0, 0},
    {26505, 5481, 0},
    {0, 0, 0},
    {26507, 5487, 0},
    {26508, 5486, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26512, 2960, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26517, 4024, 0},
    {0, 0, 0},
    {26519, 4280, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26522, 4018, 0},
    {0, 0, 0},
    {26524, 1641, 0},
    {26525, 2505, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26528, 4363, 0},
    {26529, 5489, 0},
    {26530, 2904, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26534, 5488, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26537, 5483, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26543, 2208, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26547, 5495, 0},
    {26548, 5493, 0},
    {0, 0, 0},
    {26550, 1642, 0},
    {26551, 5491, 0},
    {26552, 5497, 0},
    {26553, 5503, 0},
    {0, 0, 0},
    {26555, 8405, 11122},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26560, 8407, 11124},
    {26561, 3141, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26564, 3886, 0},
    {0, 0, 0},
    {26566, 5505, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26570, 3761, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26574, 5504, 0},
    {26575, 3651, 0},
    {26576, 3978, 0},
    {26577, 1812, 0},
    {0, 0, 0},
    {26579, 3000, 0},
    {26580, 2663, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26584, 3340, 0},
    {0, 0, 0},
    {26586, 4149, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26589, 5500, 0},
    {26590, 5499, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26594, 5501, 0},
    {0, 0, 0},
    {26596, 5498, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26599, 5506, 0},
    {0, 0, 0},
    {26601, 5496, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26604, 5494, 0},
    {0, 0, 0},
    {26606, 5502, 0},
    {26607, 5492, 0},
    {0, 0, 0},
    {26609, 3271, 0},
    {0, 0, 0},
    {26611, 4129, 0},
    {26612, 2575, 0},
    {26613, 2433, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26619, 2375, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26622, 4026, 0},
    {26623, 1724, 0},
    {0, 0, 0},
    {26625, 8408, 11125},
    {26626, 3335, 0},
    {26627, 3519, 0},
    {26628, 1544, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35895, 3206, 0},
    {26643, 2995, 0},
    {0, 0, 0},
    {35898, 7063, 0},
    {26646, 2933, 0},
    {26647, 2077, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35903, 7065, 0},
    {0, 0, 0},
    {35905, 7064, 0},
    {0, 0, 0},
    {26654, 5508, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26657, 2282, 9502},
    {26658, 1783, 0},
    {35912, 7066, 0},
    {0, 0, 0},
    {35914, 3960, 0},
    {0, 0, 0},
    {35916, 7067, 0},
    {0, 0, 0},
    {26665, 5510, 10440},
    {26666, 1775, 0},
    {26667, 5516, 10441},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35925, 7070, 0},
    {0, 0, 0},
    {26674, 5513, 0},
    {0, 0, 0},
    {26676, 2996, 0},
    {35930, 3535, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26680, 1734, 0},
    {26681, 2361, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26684, 1733, 9411},
    {26685, 2396, 10442},
    {0, 0, 0},
    {0, 0, 0},
    {26688, 5511, 0},
    {26689, 2136, 0},
    {26690, 2110, 0},
    {26691, 3460, 0},
    {26692, 8409, 11126},
    {35946, 2330, 0},
    {35947, 4431, 9889},
    {35948, 7072, 0},
    {26696, 1447, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26701, 5512, 0},
    {26702, 5514, 0},
    {0, 0, 0},
    {26704, 2018, 0},
    {26705, 2079, 0},
    {26706, 8406, 11123},
    {26707, 1813, 10443},
    {26708, 1922, 9555},
    {35962, 7074, 0},
    {0, 0, 0},
    {35964, 7082, 0},
    {0, 0, 0},
    {26713, 5517, 0},
    {8208, 29, 0},
    {0, 0, 0},
    {26716, 2438, 0},
    {26717, 4028, 10444},
    {0, 0, 0},
    {8213, 28, 9365},
    {35973, 7077, 0},
    {0, 0, 0},
    {8216, 37, 0},
    {8217, 38, 9890},
    {35977, 7076, 0},
    {35978, 7078, 0},
    {8220, 39, 0},
    {8221, 40, 9552},
    {35981, 7079, 0},
    {35982, 7080, 0},
    {8224, 180, 0},
    {8225, 181, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8229, 36, 10445},
    {8230, 35, 0},
    {0, 0, 0},
    {0, 0, 0},
    {35992, 7083, 0},
    {26740, 5530, 0},
    {0, 0, 0},
    {26742, 1616, 0},
    {26743, 5519, 0},
    {35997, 1704, 0},
    {35998, 3360, 0},
    {8240, 176, 0},
    {36000, 3832, 0},
    {8242, 75, 9354},
    {8243, 76, 9342},
    {26750, 5536, 0},
    {26751, 5520, 0},
    {0, 0, 0},
    {26753, 4263, 0},
    {36007, 3806, 0},
    {36008, 1660, 9895},
    {36009, 3711, 0},
    {8251, 101, 9524},
    {36011, 1836, 0},
    {36012, 2966, 0},
    {36013, 7085, 0},
    {36014, 7090, 0},
    {36015, 3284, 0},
    {36016, 4108, 0},
    {0, 0, 0},
    {26765, 5535, 10447},
    {36019, 7089, 0},
    {36020, 1893, 9892},
    {0, 0, 0},
    {36022, 7091, 0},
    {36023, 3638, 0},
    {26771, 1429, 9452},
    {26772, 5524, 0},
    {63785, 8403, 11120},
    {36027, 3746, 0},
    {26775, 2283, 9493},
    {36029, 7087, 0},
    {0, 0, 0},
    {36031, 3986, 0},
    {36032, 1673, 9894},
    {36033, 7093, 0},
    {36034, 4331, 9893},
    {36035, 3323, 0},
    {36036, 4360, 9891},
    {26784, 5532, 0},
    {0, 0, 0},
    {36039, 2524, 9405},
    {36040, 7092, 0},
    {0, 0, 0},
    {36042, 3118, 0},
    {26790, 4870, 0},
    {26791, 2233, 0},
    {26792, 4227, 10455},
    {36046, 3015, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36049, 3565, 0},
    {26797, 5523, 0},
    {36051, 3807, 0},
    {26799, 3373, 0},
    {26800, 1694, 0},
    {26801, 2362, 0},
    {0, 0, 0},
    {26803, 5515, 0},
    {0, 0, 0},
    {26805, 5531, 10448},
    {26806, 1756, 9367},
    {36060, 2525, 0},
    {0, 0, 0},
    {36062, 2787, 9896},
    {26810, 5533, 0},
    {36064, 3640, 0},
    {26812, 3461, 0},
    {36066, 2174, 0},
    {36067, 7095, 0},
    {36068, 7094, 0},
    {0, 0, 0},
    {36070, 3833, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26820, 1879, 0},
    {36074, 2570, 0},
    {26822, 5563, 0},
    {0, 0, 0},
    {36077, 3433, 10801},
    {26825, 4082, 0},
    {26826, 5538, 0},
    {26827, 1878, 10900},
    {0, 0, 0},
    {26829, 5545, 0},
    {0, 0, 0},
    {26831, 8410, 10901},
    {0, 0, 0},
    {0, 0, 0},
    {26834, 3979, 0},
    {0, 0, 0},
    {26836, 5546, 0},
    {26837, 5548, 10450},
    {36091, 7099, 0},
    {36092, 2311, 9897},
    {26840, 5540, 10449},
    {0, 0, 0},
    {26842, 3205, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26847, 3462, 10451},
    {26848, 5556, 10452},
    {26849, 5543, 0},
    {36103, 7103, 0},
    {36104, 3104, 9898},
    {0, 0, 0},
    {36106, 7102, 0},
    {36107, 1855, 0},
    {26855, 5547, 0},
    {36109, 7105, 0},
    {0, 0, 0},
    {36111, 7104, 0},
    {36112, 7106, 0},
    {0, 0, 0},
    {36114, 8542, 11259},
    {26862, 2844, 10454},
    {26863, 5557, 10456},
    {0, 0, 0},
    {36118, 7111, 0},
    {26866, 2932, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26873, 5555, 0},
    {26874, 1814, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26880, 4371, 0},
    {26881, 5537, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26884, 5551, 0},
    {26885, 1465, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26888, 5539, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26891, 4067, 0},
    {26892, 5544, 0},
    {26893, 2821, 0},
    {26894, 3328, 0},
    {26895, 5534, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26898, 5550, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26905, 2909, 0},
    {26906, 5560, 0},
    {26907, 1772, 0},
    {26908, 2162, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26913, 5562, 0},
    {26914, 5541, 0},
    {26915, 5561, 0},
    {0, 0, 0},
    {26917, 5554, 0},
    {26918, 5542, 0},
    {0, 0, 0},
    {26920, 5558, 0},
    {0, 0, 0},
    {26922, 5559, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26928, 5576, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26932, 3523, 0},
    {0, 0, 0},
    {26934, 5549, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26937, 5572, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26941, 5574, 0},
    {0, 0, 0},
    {36196, 2967, 9484},
    {0, 0, 0},
    {36198, 2584, 0},
    {36199, 7112, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36203, 1741, 0},
    {0, 0, 0},
    {36205, 7113, 10933},
    {0, 0, 0},
    {26954, 4179, 0},
    {36208, 3093, 0},
    {36209, 7114, 0},
    {8451, 77, 0},
    {36211, 7115, 0},
    {36212, 3834, 0},
    {0, 0, 0},
    {36214, 8543, 11260},
    {36215, 1894, 0},
    {26963, 3845, 0},
    {26964, 5569, 0},
    {26965, 3143, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26969, 5575, 0},
    {26970, 3038, 0},
    {0, 0, 0},
    {26972, 5566, 10457},
    {26973, 5579, 0},
    {26974, 5578, 0},
    {0, 0, 0},
    {8470, 1193, 9477},
    {26977, 5577, 0},
    {26978, 3551, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36234, 1562, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26984, 8412, 11129},
    {0, 0, 0},
    {26986, 5581, 0},
    {8481, 1195, 9899},
    {0, 0, 0},
    {26989, 2013, 0},
    {26990, 5571, 0},
    {26991, 2692, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {26995, 3635, 0},
    {26996, 5573, 10458},
    {8491, 175, 9317},
    {0, 0, 0},
    {26999, 5565, 0},
    {27000, 5567, 0},
    {27001, 5564, 0},
    {64014, 8323, 11040},
    {64015, 8334, 11051},
    {27004, 4339, 10827},
    {27005, 1749, 10831},
    {36259, 2618, 9900},
    {64019, 8411, 11128},
    {64020, 8413, 11130},
    {27009, 5580, 10865},
    {27010, 1712, 10869},
    {36264, 2905, 10885},
    {64024, 8493, 11210},
    {64025, 8494, 11211},
    {64026, 8495, 11212},
    {64027, 8497, 11214},
    {64028, 8501, 11218},
    {64029, 8504, 11221},
    {27018, 2420, 10894},
    {64031, 8524, 11241},
    {64032, 8526, 11243},
    {64033, 8527, 11244},
    {27022, 1564, 9449},
    {64035, 8544, 11261},
    {64036, 8546, 11263},
    {27025, 5597, 10903},
    {64038, 8550, 11267},
    {64039, 8578, 11295},
    {27028, 4340, 10924},
    {27029, 5600, 10459},
    {64042, 8613, 11330},
    {64043, 8614, 11331},
    {27032, 8414, 10939},
    {36286, 7119, 10948},
    {0, 0, 0},
    {27035, 2845, 0},
    {27036, 5599, 0},
    {36290, 7118, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27040, 5598, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36299, 7126, 0},
    {27047, 5595, 10462},
    {0, 0, 0},
    {0, 0, 0},
    {8544, 1148, 10460},
    {8545, 1149, 10972},
    {8546, 1150, 10973},
    {8547, 1151, 10974},
    {8548, 1152, 9902},
    {8549, 1153, 10976},
    {8550, 1154, 10977},
    {8551, 1155, 9909},
    {8552, 1156, 9901},
    {8553, 1157, 10980},
    {27060, 5601, 0},
    {36314, 7122, 0},
    {36315, 7125, 0},
    {0, 0, 0},
    {36317, 1966, 0},
    {0, 0, 0},
    {36319, 7129, 10950},
    {27067, 5593, 10951},
    {36321, 2968, 10952},
    {8563, 8637, 10964},
    {27070, 5588, 10463},
    {27071, 5585, 10954},
    {8566, 8640, 10967},
    {27073, 5586, 10955},
    {8568, 8642, 10969},
    {36328, 2218, 9907},
    {0, 0, 0},
    {36330, 7127, 0},
    {36331, 7128, 0},
    {27079, 7803, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36335, 4332, 9905},
    {27083, 2284, 0},
    {27084, 3329, 0},
    {27085, 3075, 0},
    {36339, 3312, 9904},
    {0, 0, 0},
    {36341, 3016, 9903},
    {0, 0, 0},
    {0, 0, 0},
    {27091, 5587, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36348, 7131, 0},
    {27096, 4180, 0},
    {27097, 4021, 0},
    {8592, 104, 10464},
    {8593, 105, 0},
    {8594, 103, 0},
    {8595, 106, 9906},
    {27102, 5602, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27106, 8415, 11132},
    {36360, 7132, 0},
    {36361, 7133, 0},
    {36362, 4192, 0},
    {0, 0, 0},
    {27111, 5610, 0},
    {27112, 5603, 0},
    {0, 0, 0},
    {36367, 3484, 0},
    {27115, 5616, 10466},
    {0, 0, 0},
    {27117, 5614, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27122, 5609, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36381, 7135, 0},
    {27129, 5608, 10465},
    {36383, 7138, 0},
    {27131, 3337, 0},
    {0, 0, 0},
    {27133, 3076, 0},
    {0, 0, 0},
    {27135, 5606, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27138, 5604, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27141, 5611, 10471},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27146, 5617, 0},
    {27147, 3750, 10467},
    {27148, 5623, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36404, 7142, 0},
    {36405, 7140, 0},
    {0, 0, 0},
    {27154, 5618, 0},
    {27155, 5621, 0},
    {27156, 5615, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27159, 3279, 0},
    {0, 0, 0},
    {27161, 3783, 0},
    {0, 0, 0},
    {27163, 5605, 0},
    {8658, 138, 0},
    {36418, 7139, 0},
    {8660, 139, 9910},
    {27167, 2757, 9488},
    {0, 0, 0},
    {27169, 4088, 0},
    {27170, 5633, 10468},
    {27171, 5620, 10470},
    {36425, 7145, 0},
    {36426, 7143, 0},
    {0, 0, 0},
    {36428, 7146, 0},
    {0, 0, 0},
    {27177, 2163, 0},
    {27178, 1600, 0},
    {27179, 1754, 10469},
    {0, 0, 0},
    {0, 0, 0},
    {27182, 5596, 0},
    {0, 0, 0},
    {36437, 7154, 10848},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36441, 7149, 0},
    {27189, 2758, 0},
    {27190, 5625, 0},
    {0, 0, 0},
    {27192, 5632, 0},
    {27193, 2626, 0},
    {27194, 1773, 9432},
    {36448, 7151, 0},
    {0, 0, 0},
    {27197, 3209, 0},
    {36451, 7153, 0},
    {36452, 7150, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27204, 5622, 0},
    {0, 0, 0},
    {27206, 8418, 11135},
    {27207, 5627, 0},
    {27208, 5631, 0},
    {0, 0, 0},
    {8704, 140, 0},
    {27211, 1995, 0},
    {8706, 156, 0},
    {8707, 141, 10473},
    {0, 0, 0},
    {36468, 2650, 0},
    {0, 0, 0},
    {8711, 157, 10472},
    {8712, 119, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8715, 120, 0},
    {0, 0, 0},
    {36476, 7157, 0},
    {27224, 1923, 0},
    {27225, 5629, 0},
    {0, 0, 0},
    {8721, 1211, 0},
    {36481, 7158, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27231, 1880, 10475},
    {36485, 7160, 0},
    {27233, 3520, 0},
    {27234, 5628, 10474},
    {0, 0, 0},
    {8730, 162, 9263},
    {36490, 7163, 0},
    {27238, 5630, 10476},
    {8733, 164, 0},
    {8734, 70, 9629},
    {8735, 1215, 0},
    {8736, 153, 9265},
    {27243, 8417, 11134},
    {36497, 7165, 0},
    {0, 0, 0},
    {36499, 7164, 0},
    {8741, 33, 10477},
    {0, 0, 0},
    {8743, 135, 0},
    {8744, 136, 9911},
    {8745, 126, 9267},
    {8746, 125, 9268},
    {8747, 166, 9262},
    {8748, 167, 0},
    {0, 0, 0},
    {8750, 1210, 9912},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36513, 7169, 0},
    {0, 0, 0},
    {8756, 71, 10850},
    {8757, 165, 9266},
    {27264, 3236, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27268, 5637, 0},
    {36522, 7168, 0},
    {36523, 2859, 0},
    {8765, 163, 10479},
    {0, 0, 0},
    {0, 0, 0},
    {36527, 2050, 0},
    {36528, 7171, 0},
    {36529, 7173, 0},
    {27277, 5635, 0},
    {27278, 2234, 0},
    {0, 0, 0},
    {27280, 5634, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27287, 5640, 0},
    {0, 0, 0},
    {36542, 7174, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8786, 159, 9260},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27296, 5636, 10480},
    {36550, 7172, 0},
    {27298, 5638, 0},
    {27299, 5639, 10481},
    {0, 0, 0},
    {36554, 2591, 0},
    {36555, 7177, 0},
    {36556, 1895, 0},
    {36557, 2086, 0},
    {0, 0, 0},
    {8800, 65, 9916},
    {8801, 158, 9261},
    {27308, 5647, 0},
    {36562, 2175, 0},
    {27310, 5528, 0},
    {0, 0, 0},
    {8806, 68, 0},
    {8807, 69, 0},
    {0, 0, 0},
    {27315, 5646, 0},
    {8810, 160, 0},
    {8811, 161, 0},
    {36571, 7178, 0},
    {0, 0, 0},
    {27320, 5645, 0},
    {0, 0, 0},
    {36575, 3557, 0},
    {27323, 5642, 0},
    {0, 0, 0},
    {36578, 3413, 0},
    {36579, 7179, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27329, 5619, 0},
    {27330, 5644, 0},
    {27331, 5643, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36587, 7182, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8834, 123, 0},
    {8835, 124, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8838, 121, 0},
    {8839, 122, 9915},
    {0, 0, 0},
    {36600, 2557, 9672},
    {0, 0, 0},
    {0, 0, 0},
    {36603, 7181, 0},
    {36604, 7180, 0},
    {36605, 2125, 0},
    {36606, 7183, 0},
    {27354, 5652, 0},
    {27355, 2064, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36611, 1742, 9914},
    {27359, 5650, 0},
    {36613, 7185, 0},
    {0, 0, 0},
    {27362, 8421, 11138},
    {0, 0, 0},
    {36617, 2409, 10851},
    {36618, 7184, 0},
    {0, 0, 0},
    {36620, 7193, 0},
    {27368, 3672, 0},
    {0, 0, 0},
    {27370, 5653, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36626, 7187, 0},
    {36627, 7189, 0},
    {8869, 154, 9264},
    {36629, 7186, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36633, 7188, 0},
    {0, 0, 0},
    {36635, 7192, 0},
    {36636, 7190, 0},
    {36637, 1896, 0},
    {0, 0, 0},
    {27386, 5657, 10482},
    {27387, 5654, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36646, 7194, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36649, 3629, 9649},
    {36650, 4285, 9917},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8895, 1216, 0},
    {36655, 2651, 9908},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36659, 7195, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27410, 5658, 0},
    {36664, 4137, 0},
    {36665, 7197, 0},
    {0, 0, 0},
    {27414, 5659, 10483},
    {0, 0, 0},
    {0, 0, 0},
    {36670, 7200, 0},
    {36671, 4168, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27421, 1524, 10485},
    {0, 0, 0},
    {36676, 1768, 9919},
    {27424, 2138, 10484},
    {27425, 2538, 10487},
    {0, 0, 0},
    {27427, 2026, 0},
    {36681, 7202, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27431, 1601, 10486},
    {36685, 3401, 0},
    {36686, 7204, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27442, 4198, 10488},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27447, 5663, 10489},
    {27448, 5662, 0},
    {27449, 5665, 0},
    {27450, 1908, 9344},
    {0, 0, 0},
    {36705, 2072, 0},
    {27453, 2027, 10490},
    {27454, 1815, 10491},
    {36708, 7209, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27459, 5668, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27463, 5667, 0},
    {0, 0, 0},
    {27465, 5669, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27468, 1643, 0},
    {0, 0, 0},
    {27470, 3218, 0},
    {0, 0, 0},
    {27472, 5670, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27475, 1816, 0},
    {27476, 5672, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27481, 5671, 0},
    {0, 0, 0},
    {27483, 5673, 0},
    {8978, 155, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27487, 5674, 0},
    {0, 0, 0},
    {27489, 5675, 0},
    {27490, 2506, 0},
    {27491, 2934, 0},
    {27492, 2350, 0},
    {0, 0, 0},
    {27494, 3839, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27497, 3919, 0},
    {27498, 4359, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27503, 2528, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27507, 2397, 0},
    {27508, 4311, 0},
    {0, 0, 0},
    {36763, 2860, 0},
    {36764, 7210, 0},
    {27512, 5676, 0},
    {36766, 2550, 9920},
    {36767, 7211, 0},
    {27515, 2507, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36771, 7212, 0},
    {27519, 5678, 0},
    {27520, 5679, 0},
    {0, 0, 0},
    {36775, 4606, 0},
    {36776, 4605, 9921},
    {27524, 5680, 0},
    {0, 0, 0},
    {27526, 4003, 0},
    {0, 0, 0},
    {36781, 7213, 0},
    {27529, 2693, 10231},
    {27530, 2613, 10492},
    {27531, 2479, 9460},
    {36785, 2830, 0},
    {36786, 3603, 9922},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36791, 7215, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36794, 3906, 9923},
    {27542, 2822, 9482},
    {36796, 2349, 0},
    {27544, 5683, 0},
    {0, 0, 0},
    {36799, 3204, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36802, 1513, 0},
    {27550, 5685, 0},
    {36804, 4035, 0},
    {36805, 2874, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27556, 5686, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36814, 2129, 0},
    {27562, 5687, 0},
    {27563, 5688, 0},
    {36817, 2038, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36820, 3907, 9924},
    {0, 0, 0},
    {27569, 5691, 0},
    {27570, 5690, 0},
    {27571, 5692, 0},
    {27572, 1602, 0},
    {27573, 3237, 10493},
    {0, 0, 0},
    {27575, 5693, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27578, 2449, 0},
    {27579, 1735, 0},
    {27580, 5694, 0},
    {36834, 7218, 0},
    {0, 0, 0},
    {27583, 3417, 0},
    {27584, 4837, 10494},
    {36838, 1661, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36841, 3563, 0},
    {27589, 1882, 10495},
    {36843, 3658, 9925},
    {0, 0, 0},
    {36845, 3402, 0},
    {0, 0, 0},
    {36847, 7220, 0},
    {36848, 2681, 9926},
    {0, 0, 0},
    {27597, 3929, 0},
    {27598, 4019, 0},
    {36852, 7222, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27602, 3516, 9616},
    {27603, 5697, 10501},
    {27604, 3735, 10497},
    {36858, 7225, 0},
    {27606, 8423, 11140},
    {0, 0, 0},
    {36861, 3330, 9547},
    {0, 0, 0},
    {0, 0, 0},
    {36864, 3165, 9620},
    {36865, 3094, 0},
    {0, 0, 0},
    {36867, 3485, 0},
    {27615, 5698, 0},
    {36869, 7223, 0},
    {36870, 1932, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36875, 7232, 0},
    {0, 0, 0},
    {36877, 7229, 0},
    {36878, 7242, 0},
    {36879, 3486, 0},
    {36880, 3259, 9927},
    {27628, 5699, 10498},
    {0, 0, 0},
    {36883, 3383, 0},
    {36884, 3434, 9928},
    {36885, 7227, 0},
    {36886, 7231, 0},
    {36887, 2883, 0},
    {27635, 5701, 0},
    {36889, 3642, 0},
    {36890, 3333, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36893, 2947, 0},
    {36894, 7230, 0},
    {36895, 3115, 0},
    {36896, 3105, 0},
    {36897, 7228, 0},
    {36898, 1418, 0},
    {36899, 4325, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36903, 7233, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27656, 5704, 0},
    {36910, 3166, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36913, 2652, 0},
    {36914, 2861, 0},
    {0, 0, 0},
    {27663, 2508, 0},
    {36917, 7235, 0},
    {27665, 4058, 10499},
    {0, 0, 0},
    {36920, 1488, 9930},
    {27668, 5706, 10500},
    {0, 0, 0},
    {0, 0, 0},
    {27671, 1883, 9551},
    {0, 0, 0},
    {36926, 7244, 0},
    {0, 0, 0},
    {27675, 5707, 0},
    {36929, 3536, 0},
    {36930, 2894, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36933, 3252, 0},
    {0, 0, 0},
    {36935, 2061, 0},
    {27683, 5709, 0},
    {27684, 5708, 10502},
    {36938, 4158, 0},
    {36939, 1534, 0},
    {0, 0, 0},
    {36941, 3908, 0},
    {36942, 1662, 0},
    {36943, 7238, 0},
    {36944, 7239, 0},
    {36945, 7240, 0},
    {36946, 7241, 0},
    {36947, 3504, 0},
    {36948, 3198, 0},
    {36949, 1476, 0},
    {36950, 7245, 0},
    {0, 0, 0},
    {36952, 7246, 0},
    {27700, 2888, 10795},
    {0, 0, 0},
    {0, 0, 0},
    {36956, 3130, 9554},
    {27704, 1545, 0},
    {36958, 7247, 0},
    {0, 0, 0},
    {36960, 1586, 0},
    {36961, 3051, 0},
    {0, 0, 0},
    {36963, 2176, 9537},
    {27711, 8424, 11141},
    {27712, 3374, 9644},
    {27713, 2664, 0},
    {27714, 1944, 10904},
    {36968, 7248, 0},
    {36969, 3395, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36973, 3095, 0},
    {36974, 2592, 0},
    {36975, 7249, 0},
    {0, 0, 0},
    {0, 0, 0},
    {36978, 7252, 0},
    {27726, 3703, 0},
    {0, 0, 0},
    {27728, 2551, 9395},
    {36982, 7250, 0},
    {36983, 3018, 0},
    {36984, 3017, 0},
    {0, 0, 0},
    {36986, 1477, 9931},
    {0, 0, 0},
    {27735, 1817, 9658},
    {36989, 7254, 0},
    {0, 0, 0},
    {27738, 1591, 9544},
    {36992, 7256, 0},
    {36993, 7255, 10852},
    {27741, 3559, 10504},
    {27742, 5710, 10161},
    {36996, 1837, 9339},
    {27744, 3246, 0},
    {0, 0, 0},
    {27746, 5712, 10496},
    {0, 0, 0},
    {37001, 7258, 0},
    {37002, 7257, 0},
    {0, 0, 0},
    {0, 0, 0},
    {27752, 5720, 0},
    {0, 0, 0},
    {27754, 5713, 10505},
    {0, 0, 0},
    {37009, 4159, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9792, 73, 0},
    {65312, 86, 9532},
    {65352, 259, 10919},
    {65355, 262, 9959},
    {65357, 264, 0},
    {9500, 664, 9279},
    {8786, 1207, 9888},
    {8801, 1208, 0},
    {8747, 1209, 0},
    {8730, 1212, 0},
    {8869, 1213, 9582},
    {8736, 1214, 0},
    {8757, 1217, 9296},
    {8745, 1218, 10849},
    {8746, 1219, 10478},
    {21782, 1411, 9347},
    {21696, 1414, 0},
    {28858, 1466, 0},
    {30959, 1484, 0},
    {28322, 1487, 0},
    {21729, 1496, 9375},
    {28139, 1501, 10911},
    {40284, 1516, 0},
    {30867, 1519, 0},
    {21764, 1523, 0},
    {28006, 1529, 10519},
    {37613, 1555, 0},
    {20870, 1566, 9472},
    {28814, 1577, 0},
    {40219, 1588, 0},
    {40236, 1606, 9771},
    {27827, 1644, 0},
    {29634, 1646, 0},
    {22057, 1659, 0},
    {20250, 1678, 10601},
    {28784, 1696, 0},
    {21683, 1708, 0},
    {30861, 1714, 9390},
    {33995, 1715, 0},
    {22435, 1723, 0},
    {29554, 1736, 0},
    {30906, 1737, 0},
    {27263, 1755, 10988},
    {28167, 1764, 10531},
    {39993, 1770, 9328},
    {40232, 1782, 0},
    {23448, 1802, 0},
    {30435, 1823, 0},
    {31649, 1826, 0},
    {37969, 1838, 9425},
    {21547, 1847, 0},
    {31048, 1886, 0},
    {20736, 1902, 0},
    {23452, 1904, 0},
    {29344, 1909, 0},
    {31047, 1911, 9588},
    {35516, 1914, 0},
    {19992, 1933, 9445},
    {21560, 1938, 9407},
    {20136, 1971, 0},
    {21932, 1985, 0},
    {24656, 1991, 0},
    {30703, 1999, 10709},
    {26997, 2016, 0},
    {22343, 2022, 10181},
    {37670, 2024, 0},
    {20534, 2043, 0},
    {21477, 2044, 0},
    {31391, 2069, 9536},
    {21234, 2081, 0},
    {37089, 2087, 9406},
    {30054, 2112, 0},
    {31293, 2113, 0},
    {20860, 2150, 0},
    {30740, 2167, 0},
    {30476, 2170, 9918},
    {28304, 2188, 0},
    {20491, 2197, 0},
    {21628, 2199, 0},
    {29392, 2210, 0},
    {40723, 2222, 0},
    {39881, 2242, 0},
    {20844, 2249, 0},
    {22434, 2259, 9580},
    {26356, 2280, 0},
    {27743, 2285, 0},
    {28317, 2289, 0},
    {30002, 2290, 0},
    {36002, 2310, 0},
    {40251, 2322, 0},
    {36703, 2331, 0},
    {20811, 2333, 0},
    {21578, 2335, 0},
    {40288, 2339, 0},
    {29508, 2341, 0},
    {21766, 2371, 10146},
    {22352, 2382, 10175},
    {21705, 2389, 0},
    {25998, 2405, 0},
    {22312, 2412, 10173},
    {36001, 2415, 0},
    {21682, 2422, 0},
    {22524, 2424, 0},
    {30869, 2425, 9743},
    {40442, 2426, 10151},
    {21643, 2429, 0},
    {25662, 2430, 0},
    {26388, 2432, 0},
    {38609, 2451, 0},
    {20632, 2460, 9372},
    {25746, 2464, 0},
    {26719, 2466, 0},
    {31639, 2470, 0},
    {36059, 2474, 0},
    {20180, 2481, 10015},
    {20282, 2482, 0},
    {31169, 2511, 10758},
    {27835, 2540, 0},
    {29885, 2542, 0},
    {30913, 2544, 10822},
    {31034, 2545, 0},
    {40235, 2555, 0},
    {19971, 2560, 9989},
    {21489, 2561, 0},
    {28287, 2567, 0},
    {33437, 2576, 0},
    {20889, 2581, 0},
    {29038, 2586, 0},
    {31038, 2587, 0},
    {37675, 2603, 0},
    {20027, 2608, 0},
    {29664, 2615, 0},
    {31278, 2616, 0},
    {21610, 2623, 0},
    {38656, 2628, 9691},
    {22234, 2629, 0},
    {21608, 2631, 0},
    {37276, 2656, 0},
    {32294, 2667, 0},
    {33308, 2687, 0},
    {28310, 2695, 0},
    {36981, 2700, 0},
    {37255, 2701, 0},
    {24246, 2709, 0},
    {26360, 2712, 0},
    {37604, 2722, 10857},
    {20663, 2724, 0},
    {21736, 2730, 0},
    {22039, 2733, 0},
    {24288, 2744, 0},
    {26124, 2752, 0},
    {26786, 2756, 0},
    {27836, 2759, 0},
    {30813, 2768, 0},
    {30977, 2769, 10730},
    {32918, 2776, 0},
    {35359, 2782, 0},
    {35937, 2786, 0},
    {29366, 2810, 9424},
    {32340, 2824, 0},
    {20405, 2834, 0},
    {21767, 2835, 10145},
    {26187, 2843, 0},
    {30495, 2850, 10688},
    {33455, 2855, 0},
    {38499, 2875, 9575},
    {21561, 2884, 0},
    {28810, 2889, 0},
    {38543, 2898, 0},
    {29790, 2899, 0},
    {38619, 2906, 0},
    {28716, 2918, 0},
    {26159, 2920, 0},
    {20932, 2921, 9447},
    {32854, 2940, 0},
    {37266, 2948, 0},
    {33030, 2953, 0},
    {30707, 2961, 0},
    {36447, 2969, 0},
    {30889, 2970, 9748},
    {25305, 2972, 0},
    {31363, 2977, 0},
    {35500, 2979, 0},
    {32118, 2981, 0},
    {33292, 2982, 0},
    {27927, 2999, 0},
    {29053, 3003, 0},
    {37549, 3019, 0},
    {30990, 3042, 9597},
    {31062, 3043, 0},
    {35380, 3049, 0},
    {29245, 3061, 0},
    {24035, 3074, 0},
    {30185, 3080, 0},
    {24687, 3110, 0},
    {36275, 3114, 10898},
    {22949, 3138, 0},
    {32974, 3160, 0},
    {36024, 3164, 0},
    {21488, 3171, 10705},
    {22823, 3172, 0},
    {28711, 3178, 0},
    {37944, 3189, 0},
    {35582, 3191, 0},
    {33592, 3192, 0},
    {34552, 3194, 0},
    {36784, 3199, 0},
    {28251, 3220, 0},
    {28845, 3221, 0},
    {31471, 3223, 0},
    {32966, 3227, 0},
    {22243, 3231, 0},
    {26029, 3234, 0},
    {30007, 3238, 0},
    {34584, 3251, 0},
    {39347, 3253, 9715},
    {33988, 3258, 0},
    {37198, 3276, 0},
    {39376, 3278, 0},
    {28710, 3280, 0},
    {24193, 3292, 0},
    {26274, 3299, 0},
    {29266, 3302, 10582},
    {36229, 3311, 9513},
    {37530, 3313, 0},
    {40165, 3316, 0},
    {27941, 3326, 10514},
    {20291, 3338, 10024},
    {36795, 3341, 0},
    {34086, 3342, 0},
    {26943, 3345, 0},
    {20302, 3356, 0},
    {24311, 3367, 0},
    {32224, 3378, 0},
    {36420, 3382, 0},
    {37048, 3384, 0},
    {25973, 3391, 0},
    {28346, 3397, 0},
    {21746, 3398, 0},
    {36028, 3412, 0},
    {28857, 3415, 0},
    {20814, 3421, 10644},
    {22900, 3442, 0},
    {20826, 3445, 0},
    {21776, 3449, 0},
    {28271, 3465, 0},
    {31570, 3474, 10790},
    {35342, 3481, 0},
    {35910, 3483, 0},
    {39472, 3490, 10070},
    {23566, 3496, 0},
    {23776, 3506, 0},
    {40199, 3507, 0},
    {31167, 3514, 0},
    {29420, 3517, 10596},
    {40182, 3525, 9755},
    {25958, 3533, 0},
    {20045, 3544, 10589},
    {39348, 3552, 9716},
    {26976, 3556, 10986},
    {23612, 3561, 0},
    {32905, 3566, 0},
    {26085, 3569, 0},
    {31152, 3580, 0},
    {23527, 3582, 0},
    {33075, 3601, 0},
    {34468, 3605, 0},
    {35207, 3609, 0},
    {29750, 3613, 9699},
    {32629, 3616, 0},
    {26757, 3634, 10446},
    {22770, 3639, 0},
    {30695, 3645, 10711},
    {31636, 3654, 0},
    {26333, 3659, 0},
    {32283, 3662, 0},
    {39361, 3664, 0},
    {40614, 3665, 0},
    {28300, 3679, 0},
    {37271, 3681, 0},
    {39658, 3682, 0},
    {40169, 3688, 0},
    {22138, 3689, 0},
    {27710, 3702, 0},
    {38930, 3715, 0},
    {30058, 3719, 0},
    {30928, 3721, 9759},
    {21542, 3726, 0},
    {30130, 3737, 0},
    {30865, 3739, 0},
    {36991, 3747, 0},
    {39131, 3749, 0},
    {24494, 3754, 0},
    {27608, 3756, 0},
    {30473, 3758, 10687},
    {39661, 3765, 9669},
    {33777, 3768, 0},
    {36924, 3774, 0},
    {26727, 3775, 9592},
    {32016, 3778, 0},
    {27703, 3784, 0},
    {35961, 3790, 0},
    {24287, 3791, 0},
    {30149, 3793, 0},
    {39981, 3800, 0},
    {21697, 3801, 0},
    {28693, 3805, 10567},
    {29942, 3810, 0},
    {20184, 3812, 0},
    {22827, 3814, 0},
    {26222, 3824, 0},
    {28014, 3825, 0},
    {29238, 3826, 9578},
    {33433, 3830, 0},
    {33914, 3847, 0},
    {20239, 3849, 10021},
    {31119, 3854, 0},
    {35079, 3856, 0},
    {27832, 3861, 0},
    {29289, 3863, 0},
    {39826, 3864, 0},
    {19993, 3879, 0},
    {20006, 3887, 9999},
    {38281, 3889, 0},
    {38491, 3890, 0},
    {30887, 3896, 0},
    {31687, 3904, 0},
    {37610, 3916, 9619},
    {36628, 3922, 0},
    {23849, 3941, 0},
    {34028, 3956, 0},
    {34562, 3957, 0},
    {37586, 3962, 0},
    {40179, 3964, 10824},
    {40300, 3965, 0},
    {20047, 3966, 10001},
    {20129, 3967, 10011},
    {21078, 3969, 0},
    {35980, 3985, 0},
    {21271, 3991, 0},
    {30566, 3998, 0},
    {22868, 4006, 0},
    {30952, 4012, 0},
    {21737, 4020, 0},
    {39850, 4025, 0},
    {40018, 4027, 0},
    {20134, 4029, 0},
    {20451, 4030, 0},
    {21448, 4031, 10713},
    {27819, 4034, 0},
    {28288, 4041, 0},
    {21619, 4044, 0},
    {24051, 4047, 0},
    {23494, 4050, 0},
    {34588, 4051, 0},
    {22937, 4056, 0},
    {30496, 4059, 0},
    {21209, 4060, 10682},
    {38695, 4065, 0},
    {40289, 4066, 9665},
    {21517, 4071, 9662},
    {21629, 4072, 0},
    {36855, 4075, 0},
    {40180, 4077, 0},
    {29277, 4079, 0},
    {28357, 4080, 0},
    {27611, 4092, 0},
    {29467, 4093, 0},
    {30446, 4101, 0},
    {31870, 4107, 0},
    {20918, 4115, 0},
    {32822, 4118, 0},
    {24357, 4120, 0},
    {24441, 4123, 0},
    {35379, 4126, 0},
    {36493, 4127, 0},
    {37971, 4131, 0},
    {24840, 4133, 0},
    {27833, 4134, 10905},
    {20778, 4140, 0},
    {25558, 4147, 0},
    {28044, 4151, 0},
    {29494, 4152, 0},
    {35029, 4156, 0},
    {34701, 4162, 0},
    {22805, 4163, 0},
    {22934, 4172, 0},
    {26332, 4178, 0},
    {28342, 4182, 0},
    {32768, 4187, 0},
    {36965, 4193, 0},
    {33713, 4208, 0},
    {38647, 4210, 10013},
    {37226, 4214, 0},
    {20081, 4215, 10006},
    {27396, 4218, 0},
    {21519, 4224, 0},
    {29702, 4228, 0},
    {29827, 4229, 0},
    {21129, 4242, 10671},
    {28316, 4244, 0},
    {30827, 4247, 0},
    {38534, 4249, 9683},
    {30274, 4266, 0},
    {36988, 4272, 0},
    {32209, 4277, 0},
    {29747, 4283, 0},
    {38563, 4286, 10002},
    {40023, 4287, 0},
    {40607, 4288, 0},
    {29618, 4301, 0},
    {31036, 4302, 0},
    {38646, 4306, 0},
    {38666, 4307, 0},
    {26278, 4310, 0},
    {21155, 4313, 0},
    {32879, 4323, 0},
    {21570, 4327, 0},
    {27347, 4329, 0},
    {28809, 4330, 0},
    {28010, 4341, 0},
    {21644, 4357, 0},
    {20121, 4365, 10867},
    {20120, 4366, 0},
    {28286, 4372, 0},
    {30871, 4373, 0},
    {19984, 4419, 0},
    {19989, 4420, 10584},
    {20022, 4423, 0},
    {20028, 4424, 0},
    {20034, 4426, 0},
    {20054, 4427, 0},
    {20056, 4428, 0},
    {20098, 4429, 10008},
    {20106, 4432, 0},
    {20126, 4436, 10010},
    {20128, 4438, 0},
    {20150, 4442, 0},
    {20164, 4445, 10595},
    {20183, 4448, 0},
    {20233, 4453, 0},
    {20430, 4474, 0},
    {20432, 4479, 10877},
    {20452, 4480, 0},
    {20500, 4484, 0},
    {20497, 4495, 0},
    {20660, 4510, 0},
    {20658, 4511, 0},
    {20681, 4512, 10042},
    {20659, 4514, 0},
    {20674, 4515, 10041},
    {20702, 4517, 10044},
    {20725, 4523, 0},
    {20758, 4527, 0},
    {20757, 4528, 0},
    {20791, 4533, 0},
    {20795, 4535, 0},
    {20800, 4537, 0},
    {20818, 4538, 0},
    {20812, 4539, 0},
    {20834, 4541, 10055},
    {20841, 4543, 0},
    {20842, 4544, 0},
    {20898, 4558, 0},
    {20915, 4562, 0},
    {20912, 4565, 0},
    {20917, 4566, 0},
    {20925, 4567, 0},
    {20937, 4569, 0},
    {21031, 4582, 0},
    {21086, 4591, 10082},
    {21197, 4612, 0},
    {21222, 4616, 0},
    {21240, 4621, 0},
    {21264, 4627, 0},
    {21269, 4629, 0},
    {21430, 4656, 10946},
    {21443, 4657, 0},
    {26364, 4661, 0},
    {21505, 4667, 0},
    {21548, 4670, 10721},
    {21549, 4671, 0},
    {21550, 4673, 10722},
    {21558, 4674, 0},
    {21647, 4678, 0},
    {21621, 4679, 10122},
    {21646, 4680, 0},
    {21617, 4682, 0},
    {21623, 4683, 0},
    {21616, 4684, 0},
    {21650, 4685, 0},
    {21627, 4686, 0},
    {21632, 4687, 0},
    {21622, 4688, 0},
    {21636, 4689, 0},
    {21648, 4690, 10125},
    {21638, 4691, 0},
    {21703, 4692, 10136},
    {21666, 4693, 10724},
    {21688, 4694, 0},
    {21669, 4695, 10135},
    {21676, 4696, 10128},
    {21700, 4697, 0},
    {21704, 4698, 10736},
    {21672, 4699, 0},
    {21675, 4700, 0},
    {21698, 4701, 10137},
    {21668, 4702, 0},
    {21720, 4705, 10139},
    {21733, 4706, 0},
    {21734, 4707, 0},
    {21775, 4708, 10747},
    {21780, 4709, 10743},
    {21757, 4710, 0},
    {21742, 4711, 0},
    {21741, 4712, 10142},
    {21754, 4713, 10734},
    {21730, 4714, 10141},
    {21817, 4715, 0},
    {21824, 4716, 0},
    {21852, 4720, 0},
    {21829, 4721, 0},
    {21816, 4724, 0},
    {21913, 4727, 0},
    {21679, 4729, 10131},
    {21912, 4734, 0},
    {21928, 4741, 0},
    {21956, 4745, 0},
    {22007, 4750, 0},
    {22043, 4754, 0},
    {22154, 4770, 10773},
    {22159, 4773, 0},
    {22208, 4782, 0},
    {22225, 4785, 0},
    {22227, 4786, 0},
    {22272, 4790, 10785},
    {22296, 4798, 0},
    {22310, 4802, 0},
    {22408, 4811, 0},
    {22369, 4812, 0},
    {22419, 4815, 0},
    {22432, 4816, 0},
    {22451, 4817, 0},
    {22436, 4818, 0},
    {22467, 4821, 0},
    {22470, 4822, 0},
    {22553, 4830, 0},
    {22642, 4832, 0},
    {22640, 4836, 0},
    {22713, 4842, 0},
    {22714, 4845, 0},
    {22715, 4847, 0},
    {22739, 4851, 0},
    {22745, 4854, 0},
    {22751, 4859, 0},
    {22767, 4860, 0},
    {22779, 4863, 0},
    {22780, 4864, 0},
    {22781, 4865, 0},
    {22794, 4867, 0},
    {22864, 4879, 0},
    {23004, 4897, 0},
    {22925, 4898, 0},
    {23077, 4901, 0},
    {23068, 4904, 0},
    {23049, 4905, 0},
    {23146, 4913, 0},
    {23365, 4936, 0},
    {23397, 4942, 0},
    {23401, 4943, 0},
    {23427, 4951, 0},
    {23518, 4962, 0},
    {23531, 4964, 0},
    {23536, 4965, 0},
    {23609, 4977, 0},
    {23631, 4983, 0},
    {23692, 4990, 0},
    {23740, 4997, 0},
    {23828, 5016, 0},
    {23883, 5024, 0},
    {23982, 5034, 0},
    {24050, 5046, 0},
    {24081, 5051, 0},
    {24224, 5070, 0},
    {24257, 5071, 0},
    {24258, 5072, 0},
    {24285, 5078, 0},
    {24297, 5084, 0},
    {24323, 5092, 0},
    {24337, 5097, 0},
    {24365, 5100, 0},
    {24406, 5108, 0},
    {24480, 5125, 0},
    {24617, 5141, 0},
    {24641, 5151, 0},
    {24695, 5153, 0},
    {24683, 5163, 0},
    {24717, 5166, 0},
    {24727, 5173, 0},
    {24900, 5212, 0},
    {24948, 5219, 0},
    {24927, 5223, 0},
    {24967, 5229, 0},
    {24970, 5233, 0},
    {32633, 5246, 0},
    {25096, 5258, 0},
    {25136, 5268, 0},
    {25288, 5295, 0},
    {25289, 5302, 0},
    {25654, 5342, 0},
    {25788, 5357, 0},
    {25816, 5363, 0},
    {25933, 5395, 0},
    {25970, 5399, 0},
    {25986, 5401, 0},
    {35722, 5403, 0},
    {26049, 5410, 0},
    {26075, 5414, 0},
    {26180, 5429, 0},
    {26185, 5430, 0},
    {26177, 5431, 0},
    {26212, 5434, 0},
    {26215, 5435, 0},
    {26216, 5436, 0},
    {26210, 5438, 0},
    {26224, 5439, 0},
    {26248, 5441, 0},
    {26305, 5447, 0},
    {26313, 5449, 0},
    {26345, 5459, 0},
    {38712, 5468, 0},
    {26433, 5472, 0},
    {26423, 5474, 0},
    {26462, 5476, 0},
    {27292, 5507, 0},
    {26694, 5509, 0},
    {26723, 5518, 0},
    {26783, 5521, 0},
    {26767, 5522, 0},
    {26781, 5525, 0},
    {26779, 5526, 0},
    {26755, 5527, 0},
    {26809, 5529, 0},
    {26839, 5552, 0},
    {26851, 5553, 0},
    {26987, 5568, 10987},
    {27006, 5570, 10844},
    {27058, 5582, 10979},
    {27054, 5583, 10975},
    {27088, 5584, 0},
    {27086, 5589, 0},
    {27082, 5591, 0},
    {27101, 5592, 0},
    {27075, 5594, 10956},
    {27402, 5607, 0},
    {27057, 5612, 10461},
    {27166, 5613, 0},
    {27250, 5624, 0},
    {27256, 5626, 0},
    {34327, 5641, 0},
    {27358, 5648, 0},
    {27345, 5649, 0},
    {27306, 5651, 10902},
    {27397, 5655, 0},
    {39729, 5660, 0},
    {27423, 5661, 0},
    {27513, 5677, 0},
    {27523, 5681, 0},
    {27533, 5682, 0},
    {27541, 5684, 0},
    {27567, 5689, 0},
    {27590, 5695, 0},
    {27595, 5696, 0},
    {27627, 5700, 0},
    {27631, 5702, 0},
    {40638, 5703, 0},
    {27667, 5705, 0},
    {27733, 5711, 0},
    {27777, 5717, 0},
    {27774, 5719, 0},
    {27837, 5727, 10509},
    {27822, 5731, 0},
    {27825, 5732, 0},
    {27834, 5734, 0},
    {27935, 5739, 0},
    {34893, 5740, 0},
    {27965, 5743, 0},
    {28051, 5751, 0},
    {27994, 5753, 0},
    {28025, 5754, 0},
    {27993, 5755, 0},
    {28053, 5757, 10525},
    {28037, 5759, 10524},
    {28181, 5761, 10912},
    {28088, 5766, 0},
    {28136, 5771, 0},
    {28138, 5778, 0},
    {28185, 5783, 0},
    {28274, 5784, 0},
    {28278, 5790, 10544},
    {28191, 5792, 0},
    {28290, 5800, 10916},
    {28330, 5801, 10545},
    {28312, 5802, 0},
    {28361, 5803, 0},
    {28343, 5804, 0},
    {28371, 5805, 0},
    {28349, 5806, 0},
    {28335, 5807, 0},
    {28356, 5808, 10548},
    {28338, 5809, 10918},
    {28303, 5812, 0},
    {28325, 5813, 0},
    {28354, 5814, 10917},
    {28319, 5815, 0},
    {28659, 5838, 0},
    {28546, 5840, 0},
    {28681, 5862, 0},
    {28683, 5863, 0},
    {28673, 5866, 0},
    {28687, 5867, 0},
    {28696, 5873, 0},
    {28720, 5875, 0},
    {28722, 5877, 0},
    {28825, 5880, 0},
    {28818, 5881, 0},
    {28847, 5882, 0},
    {28844, 5884, 0},
    {28856, 5885, 0},
    {28851, 5886, 0},
    {28846, 5887, 0},
    {29030, 5899, 0},
    {29036, 5903, 0},
    {29197, 5924, 0},
    {29211, 5926, 0},
    {29224, 5927, 0},
    {29229, 5928, 0},
    {29228, 5929, 0},
    {29232, 5930, 0},
    {29234, 5931, 0},
    {29243, 5932, 0},
    {29244, 5933, 0},
    {29247, 5934, 0},
    {29248, 5935, 0},
    {29254, 5936, 0},
    {29259, 5937, 0},
    {29272, 5938, 0},
    {29300, 5939, 0},
    {29310, 5940, 0},
    {29314, 5941, 10590},
    {29319, 5943, 0},
    {29330, 5944, 0},
    {29334, 5945, 0},
    {29346, 5946, 0},
    {29351, 5947, 0},
    {29369, 5948, 0},
    {29379, 5950, 0},
    {29382, 5951, 0},
    {29380, 5952, 0},
    {29394, 5954, 0},
    {29410, 5955, 0},
    {29433, 5958, 0},
    {29431, 5959, 0},
    {20495, 5960, 0},
    {29463, 5961, 0},
    {29450, 5962, 0},
    {29468, 5963, 0},
    {29492, 5966, 0},
    {29487, 5967, 0},
    {29519, 5972, 0},
    {29544, 5976, 0},
    {29560, 5978, 0},
    {29557, 5979, 0},
    {29563, 5980, 10807},
    {29562, 5981, 0},
    {29646, 5984, 0},
    {29627, 5985, 0},
    {29632, 5986, 0},
    {29678, 5988, 10799},
    {29662, 5989, 0},
    {29858, 5990, 0},
    {29746, 5995, 10938},
    {29759, 5998, 0},
    {29898, 6012, 0},
    {29903, 6013, 0},
    {29920, 6016, 0},
    {29923, 6017, 0},
    {29927, 6018, 0},
    {29934, 6020, 0},
    {29938, 6021, 0},
    {29955, 6027, 0},
    {29964, 6029, 0},
    {29971, 6033, 0},
    {29982, 6034, 0},
    {29990, 6035, 10639},
    {30020, 6038, 0},
    {30022, 6043, 0},
    {30057, 6045, 0},
    {30052, 6046, 0},
    {30059, 6048, 0},
    {30061, 6049, 0},
    {30087, 6053, 0},
    {30068, 6054, 0},
    {30090, 6055, 0},
    {30106, 6059, 0},
    {30109, 6060, 0},
    {30117, 6061, 0},
    {30115, 6062, 0},
    {30136, 6068, 10648},
    {30140, 6069, 0},
    {30129, 6070, 0},
    {30157, 6071, 10651},
    {30154, 6072, 0},
    {30169, 6074, 0},
    {30192, 6081, 0},
    {30194, 6083, 0},
    {30219, 6085, 0},
    {30239, 6088, 0},
    {30242, 6092, 0},
    {30256, 6095, 10663},
    {30300, 6100, 0},
    {30296, 6101, 0},
    {30312, 6104, 0},
    {30313, 6105, 0},
    {30316, 6108, 0},
    {30320, 6109, 0},
    {30322, 6110, 0},
    {30336, 6114, 0},
    {30339, 6115, 0},
    {30344, 6116, 10667},
    {30350, 6118, 0},
    {30358, 6119, 0},
    {30355, 6120, 0},
    {30361, 6121, 0},
    {30362, 6122, 0},
    {30393, 6126, 10672},
    {30422, 6130, 10678},
    {30418, 6131, 10677},
    {30430, 6132, 0},
    {30433, 6133, 10679},
    {30442, 6136, 0},
    {34351, 6137, 0},
    {30472, 6139, 0},
    {30471, 6140, 0},
    {30468, 6141, 10685},
    {30500, 6143, 0},
    {30494, 6144, 10689},
    {30502, 6146, 0},
    {30568, 6152, 0},
    {30571, 6153, 0},
    {30565, 6155, 0},
    {30591, 6156, 0},
    {30585, 6158, 0},
    {30606, 6159, 0},
    {30603, 6160, 0},
    {30624, 6162, 0},
    {30646, 6165, 0},
    {30655, 6167, 10703},
    {30653, 6169, 10702},
    {30651, 6170, 0},
    {30669, 6172, 10706},
    {30702, 6177, 10710},
    {30716, 6178, 10717},
    {30738, 6180, 0},
    {31014, 6181, 0},
    {31018, 6183, 0},
    {30789, 6184, 0},
    {30862, 6185, 0},
    {30874, 6189, 0},
    {30860, 6190, 0},
    {30883, 6191, 0},
    {30901, 6192, 0},
    {30890, 6193, 0},
    {30895, 6194, 10823},
    {30929, 6195, 0},
    {30918, 6196, 10727},
    {30923, 6197, 10725},
    {30932, 6198, 0},
    {30910, 6199, 0},
    {30908, 6200, 0},
    {30917, 6201, 0},
    {30922, 6202, 0},
    {30956, 6203, 0},
    {30951, 6204, 0},
    {30938, 6205, 0},
    {30973, 6206, 0},
    {30964, 6207, 0},
    {30983, 6208, 0},
    {30994, 6209, 0},
    {30993, 6210, 0},
    {31001, 6211, 10739},
    {31020, 6212, 10745},
    {31019, 6213, 10746},
    {31040, 6214, 0},
    {31059, 6220, 0},
    {40779, 6226, 0},
    {31150, 6228, 10756},
    {31189, 6233, 0},
    {31212, 6235, 0},
    {31240, 6238, 0},
    {31291, 6246, 0},
    {31319, 6250, 0},
    {31383, 6260, 0},
    {31381, 6261, 0},
    {31382, 6263, 0},
    {31414, 6267, 0},
    {31429, 6268, 0},
    {36995, 6271, 0},
    {31431, 6272, 0},
    {31434, 6273, 10776},
    {31443, 6277, 0},
    {31449, 6278, 0},
    {31457, 6281, 0},
    {31462, 6283, 0},
    {31469, 6284, 0},
    {31472, 6285, 10782},
    {31512, 6291, 0},
    {31518, 6293, 0},
    {31528, 6295, 0},
    {31565, 6300, 10791},
    {31564, 6302, 0},
    {31605, 6304, 0},
    {31589, 6305, 0},
    {31604, 6306, 0},
    {31591, 6307, 0},
    {31600, 6308, 10793},
    {31601, 6309, 0},
    {31596, 6310, 0},
    {31627, 6318, 0},
    {31631, 6320, 0},
    {31581, 6321, 0},
    {31695, 6326, 0},
    {31686, 6328, 0},
    {31718, 6333, 0},
    {31717, 6334, 0},
    {31731, 6339, 0},
    {31735, 6340, 0},
    {31767, 6341, 0},
    {31783, 6345, 0},
    {31786, 6346, 0},
    {31775, 6347, 0},
    {31787, 6349, 0},
    {31823, 6354, 0},
    {31839, 6358, 0},
    {31830, 6360, 0},
    {31845, 6361, 0},
    {31875, 6364, 0},
    {31888, 6365, 0},
    {31912, 6371, 0},
    {31960, 6381, 0},
    {31983, 6386, 0},
    {31990, 6389, 0},
    {31994, 6390, 0},
    {32028, 6393, 0},
    {32021, 6394, 0},
    {32010, 6395, 0},
    {32046, 6398, 0},
    {32063, 6400, 0},
    {32053, 6401, 0},
    {32115, 6403, 0},
    {32086, 6404, 0},
    {32078, 6405, 0},
    {32110, 6408, 0},
    {32079, 6409, 0},
    {32099, 6410, 0},
    {32147, 6411, 0},
    {32143, 6414, 0},
    {32125, 6415, 0},
    {32317, 6424, 0},
    {32162, 6425, 0},
    {32175, 6426, 0},
    {32184, 6428, 0},
    {32222, 6434, 0},
    {32266, 6439, 0},
    {32267, 6446, 0},
    {32358, 6449, 0},
    {32346, 6462, 0},
    {36782, 6471, 0},
    {32383, 6472, 0},
    {32593, 6491, 0},
    {32597, 6492, 0},
    {32616, 6497, 0},
    {32642, 6501, 0},
    {32648, 6504, 0},
    {32669, 6509, 0},
    {32666, 6510, 0},
    {32690, 6513, 0},
    {32686, 6515, 0},
    {32714, 6521, 0},
    {32725, 6522, 0},
    {32745, 6526, 0},
    {32761, 6528, 0},
    {32774, 6530, 0},
    {32772, 6531, 0},
    {32779, 6532, 0},
    {32792, 6534, 0},
    {32831, 6539, 0},
    {32827, 6540, 0},
    {32850, 6543, 0},
    {32863, 6546, 0},
    {32866, 6547, 0},
    {32883, 6549, 0},
    {32882, 6550, 0},
    {32880, 6551, 0},
    {32886, 6552, 0},
    {32902, 6557, 0},
    {32901, 6558, 0},
    {32923, 6559, 0},
    {32915, 6560, 0},
    {20880, 6563, 0},
    {32987, 6565, 0},
    {32989, 6568, 0},
    {32982, 6571, 0},
    {33051, 6575, 0},
    {33086, 6582, 0},
    {33137, 6586, 0},
    {33193, 6602, 0},
    {33200, 6603, 0},
    {33205, 6604, 0},
    {33218, 6609, 0},
    {33233, 6613, 0},
    {33247, 6618, 0},
    {33275, 6622, 0},
    {33282, 6625, 0},
    {33290, 6628, 0},
    {33293, 6629, 0},
    {33296, 6630, 0},
    {33302, 6631, 0},
    {33323, 6633, 0},
    {33344, 6636, 0},
    {33368, 6638, 0},
    {33373, 6639, 0},
    {33378, 6643, 0},
    {33384, 6644, 0},
    {33386, 6645, 0},
    {33393, 6648, 0},
    {33439, 6655, 0},
    {33467, 6656, 0},
    {33452, 6657, 0},
    {33490, 6661, 0},
    {33524, 6662, 0},
    {33531, 6667, 0},
    {33542, 6670, 0},
    {33500, 6671, 0},
    {33589, 6674, 0},
    {33588, 6675, 0},
    {33558, 6676, 0},
    {33586, 6677, 0},
    {33585, 6678, 0},
    {33600, 6679, 0},
    {33593, 6680, 0},
    {33583, 6683, 0},
    {33560, 6686, 0},
    {33706, 6689, 0},
    {33686, 6692, 0},
    {33571, 6693, 0},
    {33678, 6694, 0},
    {33671, 6695, 0},
    {33660, 6697, 0},
    {33717, 6698, 0},
    {33651, 6699, 0},
    {33704, 6703, 0},
    {33742, 6707, 0},
    {33789, 6708, 0},
    {33752, 6710, 0},
    {33778, 6716, 0},
    {33826, 6718, 0},
    {33824, 6719, 0},
    {33725, 6720, 0},
    {34054, 6722, 0},
    {33787, 6723, 0},
    {33924, 6728, 0},
    {33911, 6729, 0},
    {33899, 6730, 0},
    {33862, 6735, 0},
    {33903, 6737, 0},
    {33845, 6739, 0},
    {33977, 6742, 0},
    {33983, 6743, 0},
    {34009, 6745, 0},
    {33979, 6747, 0},
    {34010, 6748, 0},
    {34047, 6755, 0},
    {34072, 6758, 0},
    {34079, 6760, 0},
    {34069, 6761, 0},
    {34112, 6764, 0},
    {34147, 6765, 0},
    {34184, 6774, 0},
    {34186, 6776, 0},
    {34157, 6778, 0},
    {34196, 6779, 0},
    {34203, 6780, 0},
    {34183, 6782, 0},
    {34204, 6783, 0},
    {34174, 6785, 0},
    {34192, 6786, 0},
    {34249, 6787, 0},
    {34233, 6790, 0},
    {34256, 6791, 0},
    {34315, 6799, 0},
    {34338, 6803, 0},
    {34367, 6806, 0},
    {34388, 6809, 0},
    {34451, 6813, 0},
    {34467, 6814, 0},
    {34473, 6815, 0},
    {34486, 6819, 0},
    {34479, 6820, 0},
    {34526, 6828, 0},
    {34540, 6830, 0},
    {34543, 6833, 0},
    {34578, 6834, 0},
    {34566, 6835, 0},
    {34560, 6837, 0},
    {34577, 6840, 0},
    {34553, 6843, 0},
    {34586, 6851, 0},
    {34655, 6853, 0},
    {34636, 6855, 0},
    {34676, 6857, 0},
    {34670, 6860, 0},
    {34659, 6863, 0},
    {34719, 6867, 0},
    {34749, 6871, 0},
    {34752, 6872, 0},
    {34768, 6873, 0},
    {38614, 6874, 10866},
    {34756, 6876, 0},
    {34739, 6877, 0},
    {34759, 6878, 0},
    {34758, 6879, 0},
    {34747, 6880, 0},
    {34784, 6883, 0},
    {34807, 6888, 0},
    {34830, 6889, 0},
    {34875, 6900, 0},
    {34898, 6903, 0},
    {34905, 6904, 0},
    {34941, 6912, 0},
    {35007, 6924, 0},
    {35011, 6926, 0},
    {35065, 6932, 0},
    {35058, 6937, 0},
    {35084, 6939, 0},
    {35109, 6944, 0},
    {35114, 6945, 0},
    {35137, 6947, 0},
    {35168, 6954, 0},
    {35166, 6955, 0},
    {35172, 6957, 0},
    {35181, 6958, 0},
    {35178, 6959, 0},
    {35188, 6961, 0},
    {35198, 6963, 0},
    {35203, 6964, 0},
    {35208, 6965, 0},
    {35244, 6972, 0},
    {35264, 6978, 0},
    {35292, 6980, 0},
    {35316, 6983, 0},
    {35350, 6986, 0},
    {35340, 6988, 0},
    {35393, 6993, 0},
    {35419, 6994, 0},
    {35410, 6995, 0},
    {35458, 7003, 0},
    {35460, 7004, 0},
    {35496, 7005, 0},
    {35494, 7009, 0},
    {35522, 7014, 0},
    {35550, 7025, 0},
    {35610, 7029, 0},
    {35553, 7030, 0},
    {35607, 7033, 0},
    {35624, 7040, 0},
    {35660, 7042, 0},
    {35663, 7043, 0},
    {35670, 7046, 0},
    {35675, 7047, 0},
    {35691, 7049, 0},
    {35679, 7050, 0},
    {35700, 7053, 0},
    {35730, 7058, 0},
    {35734, 7060, 0},
    {35738, 7062, 0},
    {35918, 7068, 0},
    {35920, 7069, 0},
    {35938, 7071, 0},
    {35960, 7073, 0},
    {35970, 7075, 0},
    {35988, 7081, 0},
    {36010, 7086, 0},
    {36018, 7088, 0},
    {36058, 7096, 0},
    {36093, 7097, 0},
    {36090, 7098, 0},
    {36100, 7100, 0},
    {36101, 7101, 0},
    {40782, 7107, 0},
    {36115, 7108, 0},
    {36045, 7109, 0},
    {36116, 7110, 0},
    {36225, 7116, 0},
    {36249, 7117, 0},
    {36282, 7120, 10934},
    {36303, 7121, 10971},
    {36310, 7123, 10978},
    {36300, 7124, 0},
    {36323, 7130, 10953},
    {36351, 7134, 0},
    {36382, 7136, 0},
    {36368, 7137, 0},
    {36400, 7141, 0},
    {36423, 7144, 0},
    {36432, 7147, 0},
    {36424, 7148, 0},
    {36394, 7152, 0},
    {36470, 7155, 0},
    {36466, 7156, 0},
    {36487, 7159, 0},
    {36484, 7161, 0},
    {36491, 7162, 0},
    {36500, 7166, 0},
    {36505, 7167, 0},
    {36524, 7170, 0},
    {36549, 7175, 0},
    {36552, 7176, 0},
    {36639, 7191, 0},
    {36667, 7196, 0},
    {36677, 7198, 0},
    {36674, 7199, 0},
    {36684, 7201, 0},
    {36678, 7203, 0},
    {36695, 7205, 0},
    {36700, 7206, 0},
    {36706, 7207, 0},
    {36707, 7208, 0},
    {36783, 7214, 0},
    {36826, 7216, 0},
    {36837, 7217, 0},
    {36842, 7219, 0},
    {36999, 7221, 0},
    {36857, 7224, 0},
    {36881, 7226, 0},
    {36918, 7234, 0},
    {36921, 7236, 0},
    {36856, 7237, 0},
    {36937, 7243, 0},
    {38568, 7251, 0},
    {36994, 7253, 0},
    {37007, 7259, 0},
    {37032, 7260, 0},
    {37041, 7262, 0},
    {37045, 7263, 0},
    {37090, 7264, 0},
    {37092, 7265, 0},
    {37083, 7267, 0},
    {37122, 7268, 0},
    {37168, 7272, 0},
    {37194, 7273, 0},
    {37208, 7275, 0},
    {37219, 7276, 0},
    {37225, 7278, 0},
    {37234, 7280, 0},
    {37259, 7281, 0},
    {37257, 7282, 0},
    {37250, 7283, 0},
    {37282, 7284, 0},
    {37291, 7285, 0},
    {37290, 7287, 0},
    {37306, 7290, 0},
    {37312, 7291, 0},
    {37313, 7292, 0},
    {37345, 7298, 0},
    {37366, 7302, 0},
    {37406, 7303, 0},
    {37420, 7306, 0},
    {37393, 7308, 0},
    {37470, 7309, 10856},
    {37445, 7311, 0},
    {37449, 7312, 0},
    {37448, 7314, 0},
    {37525, 7315, 0},
    {37439, 7316, 0},
    {37451, 7317, 0},
    {37456, 7318, 0},
    {37532, 7319, 0},
    {37526, 7320, 0},
    {37523, 7321, 10960},
    {37531, 7322, 0},
    {37583, 7324, 0},
    {37561, 7325, 0},
    {37559, 7326, 0},
    {37609, 7327, 0},
    {37626, 7329, 0},
    {37678, 7331, 0},
    {37657, 7332, 0},
    {37667, 7335, 0},
    {37690, 7336, 0},
    {37718, 7343, 0},
    {37780, 7347, 0},
    {37846, 7349, 0},
    {37864, 7351, 0},
    {37861, 7352, 0},
    {37848, 7353, 0},
    {37832, 7357, 0},
    {37908, 7360, 0},
    {37907, 7361, 0},
    {37904, 7364, 0},
    {37942, 7365, 0},
    {37931, 7366, 0},
    {37941, 7367, 0},
    {37946, 7369, 0},
    {37970, 7371, 0},
    {37956, 7372, 0},
    {37979, 7373, 0},
    {38013, 7382, 0},
    {37978, 7383, 0},
    {38279, 7389, 0},
    {38282, 7390, 0},
    {38317, 7398, 0},
    {38329, 7401, 0},
    {38349, 7406, 0},
    {38358, 7410, 0},
    {38433, 7415, 0},
    {38479, 7421, 0},
    {38475, 7422, 0},
    {38519, 7423, 0},
    {38494, 7425, 0},
    {38495, 7427, 0},
    {38508, 7430, 0},
    {38541, 7431, 0},
    {38552, 7432, 0},
    {38549, 7433, 0},
    {38551, 7434, 0},
    {38567, 7436, 0},
    {38620, 7449, 0},
    {38613, 7451, 0},
    {38660, 7453, 0},
    {38662, 7454, 0},
    {38670, 7457, 0},
    {38673, 7458, 0},
    {38681, 7461, 0},
    {38724, 7468, 0},
    {38722, 7471, 0},
    {38748, 7473, 0},
    {38756, 7475, 0},
    {38758, 7476, 0},
    {38777, 7481, 0},
    {38780, 7483, 0},
    {38778, 7485, 0},
    {38790, 7486, 0},
    {38799, 7488, 0},
    {38800, 7489, 0},
    {38824, 7491, 0},
    {38822, 7492, 0},
    {38819, 7493, 0},
    {38835, 7494, 0},
    {38854, 7497, 0},
    {38893, 7501, 0},
    {38898, 7503, 0},
    {38901, 7506, 0},
    {38927, 7507, 0},
    {38924, 7508, 0},
    {38968, 7509, 0},
    {38948, 7510, 0},
    {38945, 7511, 0},
    {38973, 7513, 0},
    {38991, 7515, 10879},
    {39019, 7517, 0},
    {39023, 7518, 0},
    {39024, 7519, 0},
    {39028, 7521, 0},
    {39027, 7522, 0},
    {39087, 7524, 0},
    {39094, 7526, 0},
    {39107, 7528, 0},
    {39188, 7535, 0},
    {39197, 7538, 0},
    {39204, 7540, 0},
    {39200, 7541, 0},
    {39229, 7544, 0},
    {39237, 7548, 0},
    {39248, 7549, 0},
    {39243, 7550, 0},
    {39249, 7551, 0},
    {39244, 7553, 0},
    {39253, 7554, 0},
    {39319, 7555, 0},
    {39320, 7556, 0},
    {39342, 7559, 10811},
    {39391, 7561, 0},
    {39387, 7562, 0},
    {39389, 7563, 0},
    {39384, 7564, 0},
    {39406, 7567, 0},
    {39410, 7569, 0},
    {39419, 7570, 0},
    {39425, 7572, 0},
    {39439, 7573, 0},
    {39394, 7575, 0},
    {39449, 7576, 0},
    {39467, 7577, 0},
    {39479, 7578, 0},
    {39493, 7579, 0},
    {39490, 7580, 0},
    {39488, 7581, 0},
    {39491, 7582, 0},
    {39509, 7584, 0},
    {39501, 7585, 0},
    {39515, 7586, 0},
    {39531, 7593, 0},
    {39597, 7595, 0},
    {39600, 7596, 0},
    {39612, 7597, 0},
    {39633, 7600, 0},
    {39635, 7601, 0},
    {39646, 7603, 0},
    {39647, 7604, 0},
    {39663, 7608, 0},
    {39659, 7609, 0},
    {39668, 7611, 0},
    {39671, 7613, 0},
    {39675, 7614, 0},
    {39686, 7615, 0},
    {39711, 7618, 0},
    {39714, 7619, 0},
    {39715, 7620, 0},
    {39719, 7622, 0},
    {39720, 7623, 0},
    {39721, 7624, 0},
    {39722, 7625, 0},
    {39726, 7626, 0},
    {39748, 7629, 0},
    {39747, 7630, 0},
    {39759, 7631, 0},
    {39758, 7633, 0},
    {39796, 7636, 0},
    {39827, 7637, 0},
    {39811, 7638, 0},
    {39825, 7639, 0},
    {39831, 7641, 0},
    {39848, 7644, 0},
    {39882, 7647, 0},
    {39865, 7648, 0},
    {39889, 7651, 0},
    {39890, 7652, 0},
    {39906, 7654, 0},
    {39908, 7655, 0},
    {39905, 7657, 0},
    {39994, 7658, 0},
    {39922, 7659, 0},
    {39920, 7661, 0},
    {39957, 7662, 0},
    {39956, 7663, 0},
    {39955, 7665, 0},
    {39948, 7666, 0},
    {39944, 7668, 0},
    {39954, 7669, 0},
    {39946, 7670, 0},
    {39982, 7672, 0},
    {39973, 7674, 0},
    {39969, 7676, 0},
    {39986, 7679, 0},
    {40026, 7682, 0},
    {40039, 7684, 0},
    {40054, 7685, 0},
    {40056, 7686, 0},
    {40167, 7687, 0},
    {40172, 7688, 0},
    {40176, 7689, 0},
    {40200, 7691, 0},
    {40171, 7692, 0},
    {40198, 7694, 0},
    {40234, 7695, 0},
    {40230, 7696, 0},
    {40367, 7697, 0},
    {40227, 7698, 0},
    {40223, 7699, 0},
    {40260, 7700, 0},
    {40213, 7701, 0},
    {40210, 7702, 0},
    {40257, 7703, 0},
    {40255, 7704, 0},
    {40254, 7705, 0},
    {40262, 7706, 0},
    {40264, 7707, 0},
    {40285, 7708, 0},
    {40286, 7709, 0},
    {40292, 7710, 0},
    {40273, 7711, 0},
    {40272, 7712, 0},
    {40281, 7713, 0},
    {40327, 7716, 0},
    {40314, 7719, 0},
    {40356, 7721, 0},
    {40361, 7722, 0},
    {40370, 7723, 0},
    {40390, 7729, 0},
    {40399, 7730, 0},
    {40386, 7731, 0},
    {40403, 7733, 0},
    {40440, 7734, 0},
    {40422, 7735, 0},
    {40445, 7738, 0},
    {40478, 7741, 0},
    {40565, 7742, 0},
    {40569, 7743, 0},
    {40584, 7746, 0},
    {40588, 7748, 0},
    {40597, 7750, 0},
    {40613, 7753, 0},
    {40617, 7754, 0},
    {40632, 7755, 0},
    {40621, 7757, 0},
    {40654, 7760, 0},
    {40655, 7761, 0},
    {40656, 7762, 0},
    {40660, 7763, 0},
    {40670, 7765, 0},
    {40680, 7769, 0},
    {40687, 7770, 0},
    {40692, 7771, 0},
    {40695, 7773, 0},
    {40711, 7778, 0},
    {40712, 7779, 0},
    {30391, 7780, 10943},
    {40725, 7781, 0},
    {40737, 7782, 0},
    {40766, 7784, 0},
    {40778, 7785, 0},
    {40786, 7786, 0},
    {40800, 7790, 0},
    {40806, 7792, 0},
    {40810, 7795, 0},
    {40823, 7796, 0},
    {40818, 7797, 0},
    {40822, 7798, 0},
    {40853, 7799, 0},
    {22575, 7802, 0},
    {36953, 7804, 0},
    {20956, 7806, 0},
    {29081, 7807, 0},
    {37704, 8274, 10991},
    {20425, 8277, 10994},
    {28859, 8278, 10995},
    {26824, 8280, 10997},
    {37625, 8281, 10998},
    {26363, 8282, 10999},
    {20008, 8284, 11001},
    {20220, 8286, 11003},
    {20224, 8287, 11004},
    {20310, 8290, 11007},
    {20370, 8291, 11008},
    {20429, 8295, 11012},
    {20724, 8304, 11021},
    {20836, 8307, 11024},
    {20893, 8308, 11025},
    {20926, 8309, 11026},
    {21013, 8311, 11028},
    {21148, 8312, 11029},
    {21184, 8314, 11031},
    {21211, 8315, 11032},
    {21248, 8316, 11033},
    {21255, 8317, 11034},
    {21426, 8321, 11038},
    {21469, 8322, 11039},
    {21660, 8324, 11041},
    {21642, 8325, 11042},
    {21673, 8326, 11043},
    {21759, 8327, 11044},
    {22472, 8332, 11049},
    {64016, 8335, 11052},
    {22795, 8338, 11055},
    {23797, 8353, 11070},
    {23891, 8355, 11072},
    {64017, 8356, 11073},
    {24503, 8365, 11082},
    {24542, 8366, 11083},
    {24669, 8367, 11084},
    {24818, 8373, 11090},
    {24880, 8376, 11093},
    {25254, 8379, 11096},
    {25757, 8382, 11099},
    {25806, 8383, 11100},
    {26112, 8385, 11102},
    {26133, 8386, 11103},
    {26171, 8387, 11104},
    {26199, 8393, 11110},
    {64018, 8395, 11112},
    {26227, 8396, 11113},
    {26303, 8400, 11117},
    {26382, 8402, 11119},
    {27184, 8416, 11133},
    {27251, 8419, 11136},
    {27262, 8420, 11137},
    {27364, 8422, 11139},
    {27740, 8425, 11142},
    {28015, 8431, 11148},
    {28076, 8433, 11150},
    {28156, 8437, 11154},
    {28217, 8438, 11155},
    {28351, 8442, 11159},
    {28552, 8443, 11160},
    {28661, 8445, 11162},
    {28677, 8446, 11163},
    {28679, 8447, 11164},
    {28712, 8448, 11165},
    {28805, 8449, 11166},
    {28843, 8450, 11167},
    {64021, 8456, 11173},
    {29361, 8459, 11176},
    {29374, 8460, 11177},
    {29476, 8461, 11178},
    {64022, 8462, 11179},
    {29559, 8463, 11180},
    {29629, 8464, 11181},
    {29641, 8465, 11182},
    {29654, 8466, 11183},
    {29667, 8467, 11184},
    {29650, 8468, 11185},
    {29703, 8469, 11186},
    {29685, 8470, 11187},
    {29734, 8471, 11188},
    {29738, 8472, 11189},
    {29737, 8473, 11190},
    {29742, 8474, 11191},
    {29855, 8477, 11194},
    {30063, 8479, 11023},
    {30363, 8483, 11200},
    {64023, 8485, 11202},
    {30534, 8486, 11203},
    {30753, 8488, 11205},
    {30798, 8489, 11206},
    {31024, 8492, 11209},
    {31441, 8499, 11216},
    {31463, 8500, 11217},
    {32092, 8506, 11223},
    {32583, 8511, 11228},
    {64030, 8513, 11230},
    {34137, 8522, 11239},
    {35346, 8530, 11247},
    {35518, 8534, 11114},
    {64034, 8536, 11253},
    {35667, 8538, 11255},
    {36080, 8540, 11257},
    {36084, 8541, 11127},
    {36559, 8545, 11262},
    {64037, 8547, 11264},
    {36967, 8548, 11265},
    {37086, 8549, 11266},
    {37141, 8551, 11268},
    {37338, 8553, 11270},
    {37335, 8554, 11271},
    {37349, 8559, 11276},
    {37382, 8560, 11277},
    {37392, 8561, 11278},
    {37434, 8563, 11280},
    {37440, 8564, 11281},
    {37454, 8566, 11283},
    {37457, 8568, 11285},
    {37543, 8571, 11288},
    {37607, 8574, 11291},
    {37591, 8575, 11292},
    {37593, 8576, 11293},
    {37584, 8577, 11294},
    {37589, 8579, 11296},
    {37600, 8580, 11297},
    {37587, 8581, 11298},
    {64040, 8585, 11302},
    {37661, 8588, 11305},
    {37634, 8589, 11306},
    {37719, 8591, 11308},
    {37830, 8593, 11310},
    {37854, 8594, 11311},
    {37937, 8596, 11313},
    {37957, 8597, 11314},
    {37960, 8598, 11315},
    {63964, 8600, 11317},
    {64041, 8601, 11318},
    {38715, 8605, 11322},
    {38733, 8607, 11005},
    {38735, 8608, 11325},
    {38999, 8611, 11328},
    {64044, 8616, 11131},
    {39326, 8617, 11334},
    {39502, 8618, 11335},
    {39641, 8619, 11336},
    {39644, 8620, 11337},
    {39823, 8623, 11340},
    {39867, 8625, 11342},
    {39936, 8626, 11343},
    {40299, 8628, 11345},
    {64045, 8629, 11346},
    {40657, 8631, 11348},
    {8560, 8634, 10961},
    {8561, 8635, 10962},
    {8562, 8636, 10963},
    {8564, 8638, 10965},
    {8565, 8639, 10966},
    {8567, 8641, 10968},
    {8569, 8643, 10970},
    {65506, 8644, 10981},
    {65508, 8645, 10982},
    {65287, 8646, 10983},
    {65282, 8647, 10984},
    {8560, 10716, 0},
    {8561, 10717, 0},
    {8562, 10718, 0},
    {8563, 10719, 0},
    {8564, 10720, 0},
    {8565, 10721, 0},
    {8566, 10722, 0},
    {8567, 10723, 0},
    {8568, 10724, 0},
    {8569, 10725, 0},
    {8544, 10726, 0},
    {8545, 10727, 0},
    {8546, 10728, 0},
    {8547, 10729, 0},
    {8548, 10730, 0},
    {8549, 10731, 0},
    {8550, 10732, 0},
    {8551, 10733, 0},
    {8552, 10734, 0},
    {8553, 10735, 0},
    {65506, 10736, 0},
    {65508, 10737, 0},
    {65287, 10738, 0},
    {65282, 10739, 0},
    {12849, 10740, 0},
    {8470, 10741, 0},
    {8481, 10742, 0},
    {8757, 10743, 0},
    {32394, 10744, 0},
    {35100, 10745, 0},
    {37704, 10746, 0},
    {37512, 10747, 0},
    {34012, 10748, 0},
    {20425, 10749, 0},
    {28859, 10750, 0},
    {26161, 10751, 0},
    {26824, 10752, 0},
    {37625, 10753, 0},
    {26363, 10754, 0},
    {24389, 10755, 0},
    {20008, 10756, 0},
    {20193, 10757, 0},
    {20220, 10758, 0},
    {20224, 10759, 0},
    {20227, 10760, 11324},
    {20281, 10761, 0},
    {20310, 10762, 0},
    {20370, 10763, 0},
    {20362, 10764, 0},
    {20378, 10765, 0},
    {20372, 10766, 0},
    {20429, 10767, 0},
    {20544, 10768, 0},
    {20514, 10769, 0},
    {20479, 10770, 0},
    {20510, 10771, 0},
    {20550, 10772, 0},
    {20592, 10773, 0},
    {20546, 10774, 0},
    {20628, 10775, 0},
    {20724, 10776, 0},
    {20696, 10777, 0},
    {20810, 10778, 11196},
    {20836, 10779, 0},
    {20893, 10780, 0},
    {20926, 10781, 0},
    {20972, 10782, 0},
    {21013, 10783, 0},
    {21148, 10784, 0},
    {21158, 10785, 0},
    {21184, 10786, 0},
    {21211, 10787, 0},
    {21248, 10788, 0},
    {21255, 10789, 0},
    {21284, 10790, 0},
    {21362, 10791, 0},
    {21395, 10792, 0},
    {21426, 10793, 0},
    {21469, 10794, 0},
    {64014, 10795, 0},
    {21660, 10796, 0},
    {21642, 10797, 0},
    {21673, 10798, 0},
    {21759, 10799, 0},
    {21894, 10800, 0},
    {22361, 10801, 0},
    {22373, 10802, 0},
    {22444, 10803, 0},
    {22472, 10804, 0},
    {22471, 10805, 0},
    {64015, 10806, 0},
    {64016, 10807, 0},
    {22686, 10808, 0},
    {22706, 10809, 0},
    {22795, 10810, 0},
    {22867, 10811, 0},
    {22875, 10812, 0},
    {22877, 10813, 0},
    {22883, 10814, 0},
    {22948, 10815, 0},
    {22970, 10816, 0},
    {23382, 10817, 0},
    {23488, 10818, 0},
    {29999, 10819, 0},
    {23512, 10820, 0},
    {23532, 10821, 0},
    {23582, 10822, 0},
    {23718, 10823, 0},
    {23738, 10824, 0},
    {23797, 10825, 0},
    {23847, 10826, 0},
    {23891, 10827, 0},
    {64017, 10828, 0},
    {23874, 10829, 0},
    {23917, 10830, 0},
    {23992, 10831, 0},
    {23993, 10832, 0},
    {24016, 10833, 0},
    {24353, 10834, 0},
    {24372, 10835, 0},
    {24423, 10836, 0},
    {24503, 10837, 0},
    {24542, 10838, 0},
    {24669, 10839, 0},
    {24709, 10840, 0},
    {24714, 10841, 0},
    {24798, 10842, 0},
    {24789, 10843, 0},
    {24864, 10844, 0},
    {24818, 10845, 0},
    {24849, 10846, 0},
    {24887, 10847, 0},
    {24880, 10848, 0},
    {24984, 10849, 0},
    {25107, 10850, 0},
    {25254, 10851, 0},
    {25589, 10852, 0},
    {25696, 10853, 0},
    {25757, 10854, 0},
    {25806, 10855, 0},
    {25934, 10856, 0},
    {26112, 10857, 0},
    {26133, 10858, 0},
    {26171, 10859, 0},
    {26121, 10860, 0},
    {26158, 10861, 0},
    {26142, 10862, 0},
    {26148, 10863, 0},
    {26213, 10864, 0},
    {26199, 10865, 0},
    {26201, 10866, 0},
    {64018, 10867, 0},
    {26227, 10868, 0},
    {26265, 10869, 11251},
    {26272, 10870, 0},
    {26290, 10871, 0},
    {26303, 10872, 0},
    {26362, 10873, 0},
    {26382, 10874, 0},
    {63785, 10875, 0},
    {26470, 10876, 0},
    {26555, 10877, 0},
    {26706, 10878, 0},
    {26560, 10879, 0},
    {26625, 10880, 0},
    {26692, 10881, 0},
    {26831, 10882, 11258},
    {64019, 10883, 0},
    {26984, 10884, 0},
    {64020, 10885, 0},
    {27032, 10886, 11333},
    {27106, 10887, 0},
    {27184, 10888, 0},
    {27243, 10889, 0},
    {27206, 10890, 0},
    {27251, 10891, 0},
    {27262, 10892, 0},
    {27362, 10893, 0},
    {27364, 10894, 0},
    {27606, 10895, 0},
    {27711, 10896, 0},
    {27740, 10897, 0},
    {27782, 10898, 0},
    {27759, 10899, 0},
    {27866, 10900, 0},
    {27908, 10901, 0},
    {28039, 10902, 0},
    {28015, 10903, 0},
    {28054, 10904, 0},
    {28076, 10905, 0},
    {28111, 10906, 0},
    {28152, 10907, 0},
    {28146, 10908, 0},
    {28156, 10909, 0},
    {28217, 10910, 0},
    {28252, 10911, 0},
    {28199, 10912, 0},
    {28220, 10913, 0},
    {28351, 10914, 0},
    {28552, 10915, 0},
    {28597, 10916, 0},
    {28661, 10917, 0},
    {28677, 10918, 0},
    {28679, 10919, 0},
    {28712, 10920, 0},
    {28805, 10921, 0},
    {28843, 10922, 0},
    {28943, 10923, 0},
    {28932, 10924, 0},
    {29020, 10925, 0},
    {28998, 10926, 0},
    {28999, 10927, 0},
    {64021, 10928, 0},
    {29121, 10929, 0},
    {29182, 10930, 0},
    {29361, 10931, 0},
    {29374, 10932, 0},
    {29476, 10933, 0},
    {64022, 10934, 0},
    {29559, 10935, 0},
    {29629, 10936, 0},
    {29641, 10937, 0},
    {29654, 10938, 0},
    {29667, 10939, 0},
    {29650, 10940, 0},
    {29703, 10941, 0},
    {29685, 10942, 0},
    {29734, 10943, 0},
    {29738, 10944, 0},
    {29737, 10945, 0},
    {29742, 10946, 0},
    {29794, 10947, 0},
    {29833, 10948, 0},
    {29855, 10949, 0},
    {29953, 10950, 0},
    {30063, 10951, 0},
    {30338, 10952, 0},
    {30364, 10953, 0},
    {30366, 10954, 0},
    {30363, 10955, 0},
    {30374, 10956, 0},
    {64023, 10957, 0},
    {30534, 10958, 0},
    {21167, 10959, 0},
    {30753, 10960, 0},
    {30798, 10961, 0},
    {30820, 10962, 0},
    {30842, 10963, 0},
    {31024, 10964, 0},
    {64024, 10965, 0},
    {64025, 10966, 0},
    {64026, 10967, 0},
    {31124, 10968, 0},
    {64027, 10969, 0},
    {31131, 10970, 0},
    {31441, 10971, 0},
    {31463, 10972, 0},
    {64028, 10973, 0},
    {31467, 10974, 0},
    {31646, 10975, 0},
    {64029, 10976, 0},
    {32072, 10977, 0},
    {32092, 10978, 0},
    {32183, 10979, 0},
    {32160, 10980, 0},
    {32214, 10981, 0},
    {32338, 10982, 0},
    {32583, 10983, 0},
    {32673, 10984, 0},
    {64030, 10985, 0},
    {33537, 10986, 0},
    {33634, 10987, 0},
    {33663, 10988, 0},
    {33735, 10989, 0},
    {33782, 10990, 0},
    {33864, 10991, 0},
    {33972, 10992, 0},
    {34131, 10993, 0},
    {34137, 10994, 0},
    {34155, 10995, 0},
    {64031, 10996, 0},
    {34224, 10997, 0},
    {64032, 10998, 0},
    {64033, 10999, 0},
    {34823, 11000, 0},
    {35061, 11001, 0},
    {35346, 11002, 0},
    {35383, 11003, 0},
    {35449, 11004, 0},
    {35495, 11005, 0},
    {35518, 11006, 0},
    {35551, 11007, 0},
    {64034, 11008, 0},
    {35574, 11009, 0},
    {35667, 11010, 0},
    {35711, 11011, 0},
    {36080, 11012, 0},
    {36084, 11013, 0},
    {36114, 11014, 0},
    {36214, 11015, 0},
    {64035, 11016, 0},
    {36559, 11017, 0},
    {64036, 11018, 0},
    {64037, 11019, 0},
    {36967, 11020, 0},
    {37086, 11021, 0},
    {64038, 11022, 0},
    {37141, 11023, 0},
    {37159, 11024, 0},
    {37338, 11025, 0},
    {37335, 11026, 0},
    {37342, 11027, 0},
    {37357, 11028, 0},
    {37358, 11029, 0},
    {37348, 11030, 0},
    {37349, 11031, 0},
    {37382, 11032, 0},
    {37392, 11033, 0},
    {37386, 11034, 0},
    {37434, 11035, 0},
    {37440, 11036, 0},
    {37436, 11037, 0},
    {37454, 11038, 0},
    {37465, 11039, 0},
    {37457, 11040, 0},
    {37433, 11041, 0},
    {37479, 11042, 0},
    {37543, 11043, 0},
    {37495, 11044, 0},
    {37496, 11045, 0},
    {37607, 11046, 0},
    {37591, 11047, 0},
    {37593, 11048, 0},
    {37584, 11049, 0},
    {64039, 11050, 0},
    {37589, 11051, 0},
    {37600, 11052, 0},
    {37587, 11053, 0},
    {37669, 11054, 0},
    {37665, 11055, 0},
    {37627, 11056, 0},
    {64040, 11057, 0},
    {37662, 11058, 0},
    {37631, 11059, 0},
    {37661, 11060, 0},
    {37634, 11061, 0},
    {37744, 11062, 0},
    {37719, 11063, 0},
    {37796, 11064, 0},
    {37830, 11065, 0},
    {37854, 11066, 0},
    {37880, 11067, 0},
    {37937, 11068, 0},
    {37957, 11069, 0},
    {37960, 11070, 0},
    {38290, 11071, 0},
    {63964, 11072, 0},
    {64041, 11073, 0},
    {38557, 11074, 0},
    {38575, 11075, 0},
    {38707, 11076, 0},
    {38715, 11077, 0},
    {38723, 11078, 0},
    {38733, 11079, 0},
    {38735, 11080, 0},
    {38737, 11081, 0},
    {38741, 11082, 0},
    {38999, 11083, 0},
    {39013, 11084, 0},
    {64042, 11085, 0},
    {64043, 11086, 0},
    {39207, 11087, 0},
    {64044, 11088, 0},
    {39326, 11089, 0},
    {39502, 11090, 0},
    {39641, 11091, 0},
    {39644, 11092, 0},
    {39797, 11093, 0},
    {39794, 11094, 0},
    {39823, 11095, 0},
    {39857, 11096, 0},
    {39867, 11097, 0},
    {39936, 11098, 0},
    {40304, 11099, 0},
    {40299, 11100, 0},
    {64045, 11101, 0},
    {40473, 11102, 0},
    {40657, 11103, 0}
};
