#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.12';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFInfo2',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag9050',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 90 => 0x69 },
	'about' => { 406 => 'about' },
	'aboutcvterm' => { 397 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 397 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 397 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 397 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 397 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'abspeakaudiofilepath' => { 412 => 'absPeakAudioFilePath' },
	'accelerationtracking' => { 71 => 0x518 },
	'accelerometer' => { 319 => 0x3 },
	'accelerometerx' => { 261 => 0x8d },
	'accelerometery' => { 261 => 0x8e },
	'accelerometerz' => { 261 => 0x8c },
	'accessoryserialnumber' => { 261 => 0x54 },
	'accessorytype' => { 261 => 0x53 },
	'acedemicfield' => { 402 => 'acedemicField' },
	'actionadvised' => { 106 => 0x2a },
	'activearea' => { 98 => 0xc68d },
	'actived-lighting' => { 185 => 0x22, 219 => 0x24 },
	'actived-lightingmode' => { 219 => 0x25 },
	'adaptervoltage' => { 112 => 0x407 },
	'addaspectratioinfo' => { 71 => 0x80e },
	'additionalmodelinformation' => { 397 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 71 => 0x80f, 72 => 0x11, 73 => 0x13, 76 => 0x14 },
	'address' => { 133 => 'Address' },
	'adjustmentmode' => { 325 => 0x15 },
	'adobe' => { 99 => 'Adobe' },
	'adultcontentwarning' => { 400 => 'AdultContentWarning', 405 => 'adultContentWarning' },
	'advancedfilter' => { 103 => 0x1201 },
	'advancedraw' => { 221 => 0x76a43203 },
	'advancedscenetype' => { 261 => 0x3d },
	'advisory' => { 410 => 'Advisory' },
	'ae_iso' => { 268 => 0x2, 269 => 0x4, 270 => 0x12 },
	'aeaperture' => { 268 => 0x1, 269 => 0x3, 270 => 0x11 },
	'aeaperturesteps' => { 268 => 0x8, 269 => 0xb },
	'aebautocancel' => { 71 => 0x104 },
	'aebbracketvalue' => { 65 => 0x11 },
	'aebsequence' => { 71 => 0x105 },
	'aebsequenceautocancel' => { 69 => 0x9, 70 => 0x9, 72 => 0x8, 73 => 0x9, 76 => 0x9, 77 => 0x7 },
	'aebshotcount' => { 71 => 0x106 },
	'aebxv' => { 268 => 0x4, 269 => 0x6 },
	'aeerror' => { 269 => 0x8 },
	'aeexposuretime' => { 268 => 0x0, 269 => 0x2, 270 => 0x10 },
	'aelbutton' => { 153 => 0x45 },
	'aelexposureindicator' => { 153 => 0x51 },
	'aelock' => { 153 => 0x5b, 230 => '4.2', 236 => '4.2', 241 => 0x201, 294 => 0x48, 333 => 0x40, 334 => 0x40, 335 => [0x86,0x286] },
	'aelockbutton' => { 228 => '16.1', 230 => '4.1', 231 => '15.1', 232 => '16.1', 233 => '16.1', 234 => '30.1', 235 => '16.1', 236 => '4.1', 238 => '17.1', 239 => '17.1' },
	'aelockbuttonplusdials' => { 228 => '16.2', 234 => '32.1', 238 => '44.1' },
	'aelockformb-d80' => { 239 => '3.1' },
	'aemaxaperture' => { 268 => 0x9, 269 => 0x10, 270 => 0x1c },
	'aemaxaperture2' => { 268 => 0xa, 269 => 0x11, 270 => 0x1d },
	'aemeteringmode' => { 268 => 0xc },
	'aemeteringmode2' => { 268 => '13.1' },
	'aemeteringsegments' => { 156 => 0x628, 294 => 0x209 },
	'aemicroadjustment' => { 71 => 0x110 },
	'aeminaperture' => { 268 => 0xb, 269 => 0x12, 270 => 0x1e },
	'aeminexposuretime' => { 268 => 0x5, 269 => 0x13, 270 => 0x1f },
	'aeprogrammode' => { 268 => 0x6 },
	'aeprojectlink' => { 386 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 386 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 386 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 386 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 386 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 386 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 30 => 0x21 },
	'aewhitebalance' => { 268 => 0xd },
	'aexv' => { 268 => 0x3, 269 => 0x5 },
	'af-cpriorityselection' => { 228 => '1.1', 229 => '1.1', 232 => '0.1', 233 => '0.1', 234 => '1.1', 235 => '0.1', 238 => '1.1' },
	'af-onformb-d10' => { 228 => '3.3', 234 => '3.2' },
	'af-onformb-d11' => { 235 => '2.2' },
	'af-onformb-d12' => { 238 => '50.1' },
	'af-spriorityselection' => { 228 => '1.2', 229 => '1.2', 234 => '1.2', 235 => '0.2', 238 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 228 => '2.1', 229 => '2.1', 234 => '2.1', 238 => '2.1' },
	'afadjustment' => { 294 => 0x72 },
	'afandmeteringbuttons' => { 71 => 0x701 },
	'afaperture' => { 181 => 0x5, 182 => 0x5 },
	'afareaheight' => { 161 => 0x1a },
	'afareaillumination' => { 153 => 0x4b, 236 => '15.3' },
	'afareamode' => { 149 => 0x33, 153 => 0xe, 160 => 0x0, 161 => 0x5, 261 => 0xf, 316 => 0x1205, 326 => [0xa,0x3a], 333 => 0x11, 334 => 0x10, 335 => 0x24, 345 => 0xb043, 363 => 0x17 },
	'afareamodesetting' => { 230 => '11.1', 231 => '0.1', 236 => '16.1', 239 => '2.1', 345 => 0x201c },
	'afareas' => { 241 => 0x304 },
	'afareaselectmethod' => { 71 => 0x51b },
	'afareawidth' => { 161 => 0x18 },
	'afareaxposition' => { 161 => 0x14, 316 => 0x1203 },
	'afareaxposition1' => { 316 => 0x1201 },
	'afareayposition' => { 161 => 0x16, 316 => 0x1204 },
	'afareayposition1' => { 316 => 0x1202 },
	'afassist' => { 69 => 0x5, 77 => 0x5, 153 => 0x48, 228 => '2.5', 230 => '0.2', 231 => '0.2', 232 => '1.1', 233 => '1.1', 234 => '2.4', 235 => '1.4', 236 => '0.2', 238 => '2.4', 239 => '2.3' },
	'afassistbeam' => { 71 => 0x50e, 72 => 0x4, 73 => 0x5, 74 => 0x4, 75 => 0x4, 76 => 0x5 },
	'afassistlamp' => { 261 => 0x31 },
	'afbuttonpressed' => { 335 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 271 => 0x6 },
	'afduringliveview' => { 71 => 0x511 },
	'affinea' => { 380 => 'AffineA' },
	'affineb' => { 380 => 'AffineB' },
	'affinec' => { 380 => 'AffineC' },
	'affined' => { 380 => 'AffineD' },
	'affinetune' => { 162 => 0x0, 241 => 0x306 },
	'affinetuneadj' => { 162 => 0x2, 194 => 0x2d1, 195 => 0x2dc, 241 => 0x307 },
	'affinetuneindex' => { 162 => 0x1 },
	'affinex' => { 380 => 'AffineX' },
	'affiney' => { 380 => 'AffineY' },
	'afilluminator' => { 333 => 0x29, 345 => 0xb044 },
	'afimageheight' => { 161 => 0x12 },
	'afimagewidth' => { 161 => 0x10 },
	'afintegrationtime' => { 271 => 0x7 },
	'afmicroadj' => { 326 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 330 => 0x131 },
	'afmicroadjregisteredlenses' => { 330 => '305.1' },
	'afmicroadjustment' => { 71 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 330 => 0x130 },
	'afmode' => { 94 => 0x3009, 149 => 0x16, 325 => 0x5 },
	'afmoderestrictions' => { 229 => '50.3', 238 => '48.3' },
	'afonaelockbuttonswitch' => { 71 => 0x702 },
	'afonbutton' => { 228 => '3.1', 229 => '47.1' },
	'afpoint' => { 30 => 0x13, 93 => 0x18, 149 => 0x15, 160 => 0x1, 244 => 0x308, 325 => 0x1f, 326 => 0x7, 330 => 0x19, 331 => 0x18, 332 => [0x18,0x20] },
	'afpointactivationarea' => { 70 => 0x11, 76 => 0x11 },
	'afpointareaexpansion' => { 71 => 0x508 },
	'afpointatshutterrelease' => { 326 => 0x9 },
	'afpointautoselection' => { 71 => 0x50b },
	'afpointbrightness' => { 71 => 0x50d, 228 => '2.4', 229 => '46.5', 238 => '2.3' },
	'afpointdisplayduringfocus' => { 71 => 0x50c },
	'afpointillumination' => { 70 => 0xa, 228 => '2.3', 229 => '46.2', 234 => '2.3', 235 => '1.3', 238 => '47.2', 239 => '2.4' },
	'afpointinfocus' => { 326 => 0x8 },
	'afpointmode' => { 275 => 0x3 },
	'afpointposition' => { 94 => 0x2021, 261 => 0x4d },
	'afpointregistration' => { 69 => 0x7 },
	'afpoints' => { 152 => 0x10 },
	'afpointselected' => { 153 => 0xd, 241 => 0x305, 294 => 0xe, 330 => 0x15, 331 => 0x14, 332 => [0x14,0x1c], 345 => 0x201e },
	'afpointselected2' => { 275 => 0x4 },
	'afpointselection' => { 70 => 0xb, 228 => '1.3', 229 => '1.3', 234 => '1.3', 238 => '1.3' },
	'afpointselectionmethod' => { 71 => 0x50f, 72 => 0xc, 73 => 0xd, 76 => 0xd },
	'afpointset' => { 103 => 0x1022 },
	'afpointsetting' => { 333 => 0x12, 334 => 0x11 },
	'afpointsinfocus' => { 65 => 0xe, 160 => 0x2, 271 => 0xb, 294 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 70 => 0xd },
	'afpointsselected' => { 370 => 0x4 },
	'afpointsunknown1' => { 271 => 0x0 },
	'afpointsunknown2' => { 271 => 0x2 },
	'afpointsused' => { 161 => 0x8, 327 => 0x0 },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 271 => 0x4 },
	'afresponse' => { 185 => 0xad },
	'afresult' => { 246 => 0x1038 },
	'afsearch' => { 241 => 0x303 },
	'afsensoractive' => { 149 => 0x1 },
	'afstatus' => { 316 => 0x1200 },
	'afstatusactivesensor' => { 149 => 0x2, 326 => 0x4, 330 => 0x1e, 331 => 0x1b, 332 => [0x1b,0x21] },
	'afstatusbottom' => { 149 => 0x8, 330 => 0x2a, 331 => 0x21, 332 => 0x21 },
	'afstatusbottom-left' => { 149 => 0x12, 331 => 0x2b, 332 => 0x2b },
	'afstatusbottom-right' => { 149 => 0x6, 331 => 0x1f, 332 => 0x1f },
	'afstatusbottomassist-left' => { 330 => 0x28 },
	'afstatusbottomassist-right' => { 330 => 0x2c },
	'afstatusbottomhorizontal' => { 328 => 0x10, 329 => 0x1c },
	'afstatusbottomvertical' => { 328 => 0x16, 329 => 0x26 },
	'afstatuscenter-10' => { 330 => 0x34 },
	'afstatuscenter-11' => { 330 => 0x36 },
	'afstatuscenter-12' => { 330 => 0x38 },
	'afstatuscenter-14' => { 330 => 0x3c },
	'afstatuscenter-7' => { 330 => 0x2e },
	'afstatuscenter-9' => { 330 => 0x32 },
	'afstatuscenter-horizontal' => { 330 => 0x30 },
	'afstatuscenter-vertical' => { 330 => 0x3a },
	'afstatuscenterf2-8' => { 330 => 0x4c },
	'afstatuscenterhorizontal' => { 149 => 0x2f, 328 => 0xc, 329 => 0x18, 331 => 0x2f, 332 => 0x2f },
	'afstatuscentervertical' => { 149 => 0xc, 328 => 0x14, 329 => 0x22, 331 => 0x25, 332 => 0x25 },
	'afstatusfarleft' => { 328 => 0x6, 330 => 0x26 },
	'afstatusfarlefthorizontal' => { 329 => 0x4 },
	'afstatusfarleftvertical' => { 329 => 0x12 },
	'afstatusfarright' => { 328 => 0x18, 330 => 0x44 },
	'afstatusfarrighthorizontal' => { 329 => 0x2c },
	'afstatusfarrightvertical' => { 329 => 0x34 },
	'afstatusleft' => { 149 => 0x2d, 328 => 0x2, 330 => 0x22, 331 => 0x2d, 332 => 0x2d },
	'afstatuslefthorizontal' => { 329 => 0x6 },
	'afstatusleftvertical' => { 329 => 0xe },
	'afstatuslower-left' => { 328 => 0x4, 330 => 0x24 },
	'afstatuslower-lefthorizontal' => { 329 => 0xa },
	'afstatuslower-leftvertical' => { 329 => 0x10 },
	'afstatuslower-middle' => { 328 => 0x22, 329 => 0x24 },
	'afstatuslower-right' => { 328 => 0x1e, 330 => 0x4a },
	'afstatuslower-righthorizontal' => { 329 => 0x32 },
	'afstatuslower-rightvertical' => { 329 => 0x3a },
	'afstatuslowerfarleft' => { 329 => 0x8 },
	'afstatuslowerfarright' => { 329 => 0x30 },
	'afstatusmiddlehorizontal' => { 149 => 0xa, 331 => 0x23, 332 => 0x23 },
	'afstatusnearleft' => { 328 => 0xe, 329 => 0x1a },
	'afstatusnearright' => { 328 => 0xa, 329 => 0x16 },
	'afstatusright' => { 149 => 0x31, 328 => 0x1c, 330 => 0x48, 331 => 0x31, 332 => 0x31 },
	'afstatusrighthorizontal' => { 329 => 0x2e },
	'afstatusrightvertical' => { 329 => 0x38 },
	'afstatustop' => { 149 => 0xe, 330 => 0x40, 331 => 0x27, 332 => 0x27 },
	'afstatustop-left' => { 149 => 0x10, 331 => 0x29, 332 => 0x29 },
	'afstatustop-right' => { 149 => 0x4, 331 => 0x1d, 332 => 0x1d },
	'afstatustopassist-left' => { 330 => 0x3e },
	'afstatustopassist-right' => { 330 => 0x42 },
	'afstatustophorizontal' => { 328 => 0x8, 329 => 0x14 },
	'afstatustopvertical' => { 328 => 0x12, 329 => 0x1e },
	'afstatusupper-left' => { 328 => 0x0, 330 => 0x20 },
	'afstatusupper-lefthorizontal' => { 329 => 0x2 },
	'afstatusupper-leftvertical' => { 329 => 0xc },
	'afstatusupper-middle' => { 328 => 0x20, 329 => 0x20 },
	'afstatusupper-right' => { 328 => 0x1a, 330 => 0x46 },
	'afstatusupper-righthorizontal' => { 329 => 0x2a },
	'afstatusupper-rightvertical' => { 329 => 0x36 },
	'afstatusupperfarleft' => { 329 => 0x0 },
	'afstatusupperfarright' => { 329 => 0x28 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 326 => 0x2 },
	'afwithshutter' => { 333 => 0x2a },
	'aggregateissuenumber' => { 402 => 'aggregateIssueNumber' },
	'aggregationtype' => { 402 => 'aggregationType' },
	'agreement' => { 405 => 'agreement' },
	'aiservocontinuousshooting' => { 70 => 0x15 },
	'aiservofirstimagepriority' => { 71 => 0x519 },
	'aiservoimagepriority' => { 71 => 0x503 },
	'aiservosecondimagepriority' => { 71 => 0x51a },
	'aiservotrackingmethod' => { 71 => 0x504 },
	'aiservotrackingsensitivity' => { 70 => 0x14, 71 => 0x502 },
	'album' => { 412 => 'album' },
	'alreadyapplied' => { 387 => 'AlreadyApplied' },
	'alternatetitle' => { 402 => 'alternateTitle' },
	'alternatetitlea-lang' => { 402 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 402 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 402 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 163 => 0x6 },
	'alttapename' => { 412 => 'altTapeName' },
	'alttimecode' => { 412 => 'altTimecode' },
	'alttimecodetimeformat' => { 412 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 412 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 412 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 312 => 0x14, 363 => 0x4 },
	'ambienttemperaturefahrenheit' => { 312 => 0x13 },
	'analogbalance' => { 98 => 0xc627 },
	'angleadj' => { 90 => 0x8b },
	'angleinforoll' => { 382 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 382 => 'AngleInfoYaw' },
	'anti-blur' => { 345 => 0xb04b },
	'antialiasstrength' => { 98 => 0xc632 },
	'aperturelock' => { 229 => '38.2', 238 => '38.2' },
	'aperturerange' => { 71 => 0x10d },
	'apertureringuse' => { 275 => '1.4' },
	'aperturesetting' => { 153 => 0x7, 333 => 0x30, 334 => 0x29, 335 => 0x1 },
	'aperturevalue' => { 80 => 0x2, 98 => 0x9202, 246 => 0x1002, 391 => 'ApertureValue' },
	'applekeywords' => { 250 => 'AAPL:Keywords' },
	'applicationnotes' => { 98 => 0x2bc, 265 => 0x2bc },
	'applicationrecordversion' => { 106 => 0x0 },
	'applyshootingmeteringmode' => { 71 => 0x10e },
	'approved' => { 393 => 'Approved' },
	'approvedby' => { 393 => 'ApprovedBy' },
	'approximatefnumber' => { 257 => 0x313, 263 => 0x3406 },
	'approximatefocusdistance' => { 383 => 'ApproximateFocusDistance' },
	'armidentifier' => { 107 => 0x78 },
	'armversion' => { 107 => 0x7a },
	'artfilter' => { 241 => 0x529 },
	'artfiltereffect' => { 241 => 0x52f },
	'artist' => { 98 => 0x13b, 253 => 'Artist', 294 => 0x22e, 408 => 'Artist', 412 => 'artist' },
	'artmode' => { 94 => 0x301b },
	'artmodeparameters' => { 94 => 0x310b },
	'artworkcircadatecreated' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontributiondescription' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 397 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworkscontentdescription' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworksource' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 397 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 245 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 245 => 0x1112, 294 => 0x80, 333 => 0x55, 334 => 0x55, 335 => 0xa },
	'asshoticcprofile' => { 98 => 0xc68f },
	'asshotneutral' => { 98 => 0xc628 },
	'asshotpreprofilematrix' => { 98 => 0xc690 },
	'asshotprofilename' => { 98 => 0xc6f6 },
	'asshotwhitexy' => { 98 => 0xc629 },
	'assignbktbutton' => { 228 => '4.2', 229 => '16.1', 238 => '16.1' },
	'assignfuncbutton' => { 71 => 0x70b },
	'assignmovierecordbutton' => { 229 => '43.2', 238 => '45.1' },
	'assignremotefnbutton' => { 229 => '54.1', 238 => '51.1' },
	'assistbuttonfunction' => { 69 => 0xd },
	'attributionname' => { 384 => 'attributionName' },
	'attributionurl' => { 384 => 'attributionURL' },
	'audio' => { 261 => 0x20 },
	'audiobitrate' => { 56 => 0x6c },
	'audiochannels' => { 56 => 0x70 },
	'audiochanneltype' => { 412 => 'audioChannelType' },
	'audiocompression' => { 127 => 'Compression' },
	'audiocompressor' => { 412 => 'audioCompressor' },
	'audioduration' => { 106 => 0x99 },
	'audiomoddate' => { 412 => 'audioModDate' },
	'audiooutcue' => { 106 => 0x9a },
	'audiosamplerate' => { 56 => 0x6e, 412 => 'audioSampleRate' },
	'audiosampletype' => { 412 => 'audioSampleType' },
	'audiosamplingrate' => { 106 => 0x97 },
	'audiosamplingresolution' => { 106 => 0x98 },
	'audiotype' => { 106 => 0x96 },
	'author' => { 129 => 'Author', 250 => 'Author', 253 => 'Author', 307 => 'Author', 381 => 'author', 398 => 'Author', 410 => 'Author' },
	'authorsposition' => { 399 => 'AuthorsPosition' },
	'autoaperture' => { 285 => '0.1' },
	'autobracket' => { 325 => 0x19 },
	'autobracketing' => { 103 => 0x1100, 294 => 0x18, 316 => 0x1007 },
	'autobracketingmode' => { 237 => '12.3' },
	'autobracketingset' => { 237 => '12.1' },
	'autobracketmodem' => { 228 => '21.2', 229 => '13.3', 234 => '26.2', 238 => '13.3' },
	'autobracketorder' => { 153 => 0x43, 228 => '21.3', 229 => '13.2', 234 => '26.3', 235 => '12.2', 236 => '2.2', 237 => '12.2', 238 => '13.2', 239 => '13.2' },
	'autobracketset' => { 228 => '21.1', 229 => '13.1', 231 => '11.1', 232 => '12.1', 233 => '12.1', 234 => '26.1', 235 => '12.1', 236 => '2.1', 238 => '13.1', 239 => '13.1' },
	'autobrightness' => { 387 => 'AutoBrightness' },
	'autocontrast' => { 387 => 'AutoContrast' },
	'autodistortioncontrol' => { 171 => 0x4 },
	'autodynamicrange' => { 103 => 0x140b },
	'autoexposure' => { 387 => 'AutoExposure' },
	'autoexposurebracketing' => { 65 => 0x10 },
	'autofocus' => { 244 => 0x209 },
	'autofp' => { 236 => '7.3', 239 => '31.4' },
	'autoiso' => { 65 => 0x1, 94 => 0x3008, 230 => '1.1', 236 => '1.1' },
	'autoisomax' => { 230 => '1.2', 236 => '1.2' },
	'autoisominshutterspeed' => { 230 => '1.3', 236 => '1.3' },
	'autolateralca' => { 387 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 52 => 0x2, 71 => 0x204, 90 => 0x6f },
	'autolightingoptimizeron' => { 90 => 0x6e },
	'autoportraitframed' => { 345 => 0x2016 },
	'autoredeye' => { 221 => 0xfe28a44f },
	'autorotate' => { 65 => 0x1b },
	'autoshadows' => { 387 => 'AutoShadows' },
	'autowhiteversion' => { 387 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 185 => 0x82 },
	'avaperturesetting' => { 275 => 0x13 },
	'averageblacklevel' => { 37 => 0xe7, 39 => 0xfb, 40 => 0x114 },
	'averagelv' => { 156 => 0x38 },
	'avsettingwithoutlens' => { 71 => 0x707 },
	'azimuth' => { 137 => 'Azimuth' },
	'babyage' => { 261 => [0x8010,0x33] },
	'babyname' => { 261 => 0x66 },
	'backgroundalpha' => { 407 => 'bgalpha' },
	'baseexposurecompensation' => { 275 => 0x15 },
	'baseiso' => { 65 => 0x2, 84 => 0x101c, 112 => 0x903, 263 => 0x312a, 368 => 0x6 },
	'baselineexposure' => { 98 => 0xc62a },
	'baselineexposureoffset' => { 98 => 0xc7a5 },
	'baselinenoise' => { 98 => 0xc62b },
	'baselinesharpness' => { 98 => 0xc62c },
	'baseurl' => { 410 => 'BaseURL' },
	'batterylevel' => { 333 => 0x51, 337 => 0xc, 338 => 0x4, 339 => 0x4, 369 => 0x7 },
	'batterylevelgrip1' => { 369 => 0x6 },
	'batterylevelgrip2' => { 369 => 0x8 },
	'batteryorder' => { 228 => '12.5', 234 => '13.2', 235 => '2.1', 238 => '3.1' },
	'batterystate' => { 153 => 0x60, 333 => 0x50, 339 => 0x14 },
	'batterytemperature' => { 337 => 0x1, 339 => 0x2, 369 => 0x5 },
	'batteryunknown' => { 337 => 0x2, 339 => 0x0 },
	'batteryvoltage' => { 112 => 0x408, 312 => 0x2a, 337 => 0x8 },
	'batteryvoltage1' => { 339 => 0x6 },
	'batteryvoltage2' => { 339 => 0x8 },
	'bayergreensplit' => { 98 => 0xc62d },
	'bayerpattern' => { 111 => 0xf902, 157 => 0x17 },
	'beatspliceparams' => { 412 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 412 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 412 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 412 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 412 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 412 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 228 => '13.1', 229 => '5.4', 230 => '0.1', 231 => '2.1', 232 => '3.1', 233 => '3.1', 234 => '10.1', 236 => '0.1', 238 => '5.5', 239 => '4.1' },
	'beeppitch' => { 235 => '3.1' },
	'beepvolume' => { 235 => '4.5' },
	'bestqualityscale' => { 98 => 0xc65c },
	'bestshotmode' => { 94 => 0x3007 },
	'bitdepth' => { 134 => 'BitDepth', 157 => 0x11, 191 => 0x41 },
	'bitspercomponent' => { 108 => 0x87 },
	'bitspersample' => { 98 => 0x102, 408 => 'BitsPerSample' },
	'blacklevel' => { 98 => 0xc61a, 185 => 0x3d, 246 => [0x401,0x1012] },
	'blacklevel1' => { 265 => 0x8 },
	'blacklevel2' => { 245 => 0x600, 249 => 0x600, 265 => 0x9 },
	'blacklevel3' => { 265 => 0xa },
	'blacklevelblue' => { 265 => 0x1e },
	'blackleveldeltah' => { 98 => 0xc61b },
	'blackleveldeltav' => { 98 => 0xc61c },
	'blacklevelgreen' => { 265 => 0x1d },
	'blacklevelred' => { 265 => 0x1c },
	'blacklevelrepeatdim' => { 98 => 0xc619 },
	'blackpoint' => { 294 => 0x200 },
	'blacks2012' => { 387 => 'Blacks2012' },
	'bleachbypasstoning' => { 294 => 0x7f },
	'blogtitle' => { 402 => 'blogTitle' },
	'blogurl' => { 402 => 'blogURL' },
	'bluebalance' => { 169 => 0x271, 246 => 0x1018, 265 => 0x12, 294 => 0x1b },
	'bluecurvelimits' => { 89 => 0x1fe },
	'bluecurvepoints' => { 89 => 0x1d4 },
	'bluehue' => { 387 => 'BlueHue' },
	'bluesaturation' => { 387 => 'BlueSaturation' },
	'blurcontrol' => { 294 => 0x82 },
	'blurwarning' => { 103 => 0x1300 },
	'bodybatteryadload' => { 273 => 0x3 },
	'bodybatteryadnoload' => { 273 => 0x2 },
	'bodybatterystate' => { 273 => '1.1' },
	'bodybatteryvoltage1' => { 273 => 0x2 },
	'bodybatteryvoltage2' => { 273 => 0x4 },
	'bodybatteryvoltage3' => { 273 => 0x6 },
	'bodybatteryvoltage4' => { 273 => 0x8 },
	'bodyfirmware' => { 317 => 0x0 },
	'bodyfirmwareversion' => { 242 => 0x104, 243 => 0x100, 246 => 0x104 },
	'bodyserialnumber' => { 317 => 0x10 },
	'bookedition' => { 402 => 'bookEdition' },
	'bracketmode' => { 47 => 0x3 },
	'bracketsequence' => { 94 => 0x301d },
	'bracketsettings' => { 261 => 0x45 },
	'bracketshotnumber' => { 47 => 0x5, 275 => 0x9, 344 => 0x2b },
	'bracketshotnumber2' => { 344 => 0x2d },
	'bracketstep' => { 150 => 0xe },
	'bracketvalue' => { 47 => 0x4 },
	'brightness' => { 98 => 0xfe53, 128 => 'Brightness', 150 => 0x2c, 187 => 0x34, 312 => 0x25, 333 => 0x22, 345 => 0x2007, 387 => 'Brightness' },
	'brightnessadj' => { 89 => 0x114, 214 => 0x0, 224 => 0x2d, 372 => 0x8018 },
	'brightnessvalue' => { 98 => 0x9203, 156 => [0x691,0x49c3], 246 => 0x1003, 349 => 0x1e, 352 => 0x1140, 353 => 0x1140, 354 => 0x111c, 355 => 0x1198, 356 => 0x1174, 357 => 0x102c, 358 => 0x224, 391 => 'BrightnessValue' },
	'bulbduration' => { 65 => 0x18 },
	'burstmode' => { 114 => 0xa, 261 => 0x2a },
	'burstmode2' => { 114 => 0x18 },
	'burstshot' => { 325 => 0x34 },
	'burstspeed' => { 261 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 71 => 0x70a },
	'bwfilter' => { 150 => 0x2a, 158 => 0x39 },
	'bwmode' => { 246 => 0x203 },
	'by-line' => { 106 => 0x50 },
	'by-linetitle' => { 106 => 0x55 },
	'bytecount' => { 402 => 'byteCount' },
	'calibration' => { 325 => [0x24,0x30] },
	'calibrationilluminant1' => { 98 => 0xc65a },
	'calibrationilluminant2' => { 98 => 0xc65b },
	'cameraangle' => { 412 => 'cameraAngle' },
	'cameracalibration1' => { 98 => 0xc623 },
	'cameracalibration2' => { 98 => 0xc624 },
	'cameracalibrationsig' => { 98 => 0xc6f3 },
	'cameracolorcalibration01' => { 32 => 0x0, 38 => 0xba },
	'cameracolorcalibration02' => { 32 => 0x4, 38 => 0xbf },
	'cameracolorcalibration03' => { 32 => 0x8, 38 => 0xc4 },
	'cameracolorcalibration04' => { 32 => 0xc, 38 => 0xc9 },
	'cameracolorcalibration05' => { 32 => 0x10, 38 => 0xce },
	'cameracolorcalibration06' => { 32 => 0x14, 38 => 0xd3 },
	'cameracolorcalibration07' => { 32 => 0x18, 38 => 0xd8 },
	'cameracolorcalibration08' => { 32 => 0x1c, 38 => 0xdd },
	'cameracolorcalibration09' => { 32 => 0x20, 38 => 0xe2 },
	'cameracolorcalibration10' => { 32 => 0x24, 38 => 0xe7 },
	'cameracolorcalibration11' => { 32 => 0x28, 38 => 0xec },
	'cameracolorcalibration12' => { 32 => 0x2c, 38 => 0xf1 },
	'cameracolorcalibration13' => { 32 => 0x30, 38 => 0xf6 },
	'cameracolorcalibration14' => { 32 => 0x34, 38 => 0xfb },
	'cameracolorcalibration15' => { 32 => 0x38, 38 => 0x100 },
	'cameraid' => { 246 => 0x209, 324 => 0x209 },
	'cameraiso' => { 30 => 0x10 },
	'cameralabel' => { 98 => 0xc7a1, 412 => 'cameraLabel' },
	'cameramodel' => { 412 => 'cameraModel' },
	'cameramove' => { 412 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 26 => 0x35, 261 => 0x8f, 297 => 0x1, 339 => [0x16,0x18], 360 => 0x28, 361 => 0x24, 362 => 0x29 },
	'cameraowner' => { 115 => 0xc353 },
	'cameraparameters' => { 246 => 0x2050 },
	'cameraprofile' => { 387 => 'CameraProfile' },
	'cameraprofiledigest' => { 387 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 98 => 0xc62f, 148 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 241 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x19, 27 => [0x87,0x91], 28 => [0x99,0x9f,0xa4,0xa8,0x105], 29 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 65 => 0xc, 112 => 0x406, 245 => 0x1306, 257 => 0x320, 263 => 0x3402, 294 => 0x47, 322 => 0x43, 364 => 0x5 },
	'cameratemperature2' => { 298 => 0xc },
	'cameratemperature3' => { 298 => 0xe },
	'cameratemperature4' => { 298 => 0x14 },
	'cameratemperature5' => { 298 => 0x16 },
	'cameratemperaturerangemax' => { 100 => 0x5 },
	'cameratemperaturerangemin' => { 100 => 0x6 },
	'cameratype' => { 65 => 0x1a, 246 => 0x207 },
	'cameratype2' => { 242 => 0x100 },
	'canonexposuremode' => { 30 => 0x14 },
	'canonfiledescription' => { 84 => 0x805 },
	'canonfilelength' => { 53 => 0xe },
	'canonfirmwareversion' => { 53 => 0x7, 84 => 0x80b },
	'canonflashinfo' => { 84 => 0x1028 },
	'canonflashmode' => { 30 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 30 => 0xa },
	'canonimagetype' => { 53 => 0x6, 84 => 0x815 },
	'canonmodelid' => { 53 => 0x10, 84 => 0x1834 },
	'canonvrd' => { 99 => 'CanonVRD' },
	'caption' => { 381 => 'caption' },
	'caption-abstract' => { 106 => 0x78 },
	'captionsauthornames' => { 390 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 390 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 399 => 'CaptionWriter' },
	'captureframerate' => { 94 => 0x4001 },
	'capturesoftware' => { 376 => 'CaptureSoftware' },
	'cardshutterlock' => { 153 => 0x49 },
	'casioimagesize' => { 94 => 0x9 },
	'catalogsets' => { 106 => 0xff, 375 => 'CatalogSets', 379 => 'CatalogSets' },
	'categories' => { 53 => 0x23, 381 => 'categories' },
	'category' => { 106 => 0xf, 240 => 0x30, 399 => 'Category' },
	'cbcrgain' => { 322 => 0xa036 },
	'cbcrgaindefault' => { 322 => 0xa035 },
	'cbcrmatrix' => { 322 => 0xa034 },
	'cbcrmatrixdefault' => { 322 => 0xa033 },
	'ccdboardversion' => { 257 => 0x331 },
	'ccdscanmode' => { 246 => 0x1039 },
	'ccdsensitivity' => { 211 => 0x6 },
	'ccdversion' => { 257 => 0x330 },
	'cellglobalid' => { 385 => 'cgi' },
	'celllength' => { 98 => 0x109 },
	'cellr' => { 385 => 'r' },
	'celltowerid' => { 385 => 'cellid' },
	'cellwidth' => { 98 => 0x108 },
	'centerafarea' => { 236 => '15.1' },
	'centerfocuspoint' => { 239 => '2.2' },
	'centerweightedareasize' => { 228 => '7.1', 229 => '8.1', 234 => '5.1', 235 => '7.1', 236 => '6.3', 238 => '8.1', 239 => '8.1' },
	'certificate' => { 416 => 'Certificate' },
	'cfapattern' => { 98 => 0xa302, 391 => 'CFAPattern' },
	'cfapattern2' => { 98 => 0x828e },
	'cfapatterncolumns' => { 391 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 391 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 391 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 98 => 0x828d },
	'channel' => { 402 => 'channel' },
	'channela-lang' => { 402 => [\'channel','channelA-lang'] },
	'channelchannel' => { 402 => [\'channel','channelChannel'] },
	'channels' => { 127 => 'Channels' },
	'channelsubchannel1' => { 402 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 402 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 402 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 402 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 89 => 0x26a },
	'checkmark2' => { 90 => 0x8e },
	'childfontfiles' => { 417 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 228 => '10.3', 229 => '11.2' },
	'chromablurradius' => { 98 => 0xc631 },
	'chromaticaberration' => { 90 => 0x66, 322 => 0xa051 },
	'chromaticaberrationb' => { 387 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 90 => 0x6b },
	'chromaticaberrationcorr' => { 67 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 284 => 0x1 },
	'chromaticaberrationon' => { 90 => 0x62 },
	'chromaticaberrationr' => { 387 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 90 => 0x6a },
	'chromaticaberrationsetting' => { 68 => 0x6 },
	'chrominancenoisereduction' => { 90 => 0x5e, 325 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 90 => 0x60 },
	'circgradbasedcorractive' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 387 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 387 => 'CircularGradientBasedCorrections' },
	'city' => { 106 => 0x5a, 133 => 'City', 261 => 0x6d, 399 => 'City' },
	'city2' => { 261 => 0x80 },
	'clarity' => { 387 => 'Clarity' },
	'clarity2012' => { 387 => 'Clarity2012' },
	'classifystate' => { 106 => 0xe1 },
	'clearretouch' => { 261 => 0x7c },
	'clearretouchvalue' => { 261 => 0xa3 },
	'client' => { 412 => 'client' },
	'clientname' => { 393 => 'ClientName' },
	'clmodeshootingspeed' => { 228 => '10.2', 229 => '11.3', 234 => '11.2', 235 => '10.2', 238 => '11.2', 239 => '11.1' },
	'cmcontrast' => { 249 => 0x2022 },
	'cmexposurecompensation' => { 249 => 0x2000 },
	'cmhue' => { 249 => 0x2021 },
	'cmsaturation' => { 249 => 0x2020 },
	'cmsharpness' => { 249 => 0x2023 },
	'cmwhitebalance' => { 249 => 0x2001 },
	'cmwhitebalancecomp' => { 249 => 0x2002 },
	'cmwhitebalancegraypoint' => { 249 => 0x2010 },
	'codec' => { 141 => 'Codec' },
	'codedcharacterset' => { 107 => 0x5a },
	'collectionname' => { 142 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 142 => 'Collections' },
	'collectionuri' => { 142 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 401 => 'color' },
	'coloraberrationcontrol' => { 221 => 0xc89224b },
	'coloradjustment' => { 325 => 0x14 },
	'coloradjustmentmode' => { 324 => 0x210 },
	'coloranta' => { 417 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 417 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 417 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 417 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 417 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 417 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 417 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 417 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 417 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 417 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 417 => 'Colorants' },
	'colorantswatchname' => { 417 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 417 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 417 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 417 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 128 => 'ColorBalance' },
	'colorbalanceadj' => { 221 => 0x76a43202 },
	'colorbalanceblue' => { 150 => 0x1e },
	'colorbalancegreen' => { 150 => 0x1d },
	'colorbalancered' => { 150 => 0x1c },
	'colorbalanceversion' => { 170 => 0x0 },
	'colorblur' => { 90 => 0x65 },
	'colorbooster' => { 221 => 0x5f0e7d23 },
	'colorboostlevel' => { 215 => 0x1 },
	'colorboosttype' => { 215 => 0x0 },
	'colorclass' => { 302 => 0xde, 303 => 'ColorClass' },
	'colorcompensationfilter' => { 153 => [0x3a,0x5f], 155 => 0x111, 345 => 0xb022 },
	'colorcompensationfiltercustom' => { 333 => 0xd, 334 => 0xc },
	'colorcompensationfilterset' => { 333 => 0x8, 334 => 0x7, 335 => 0x18, 349 => 0xf },
	'colorcontrol' => { 246 => 0x102b },
	'colorcorrection' => { 372 => 0x8015 },
	'colordataversion' => { 36 => 0x0, 37 => 0x0, 39 => 0x0, 40 => 0x0 },
	'coloreffect' => { 261 => 0x28 },
	'colorfilter' => { 93 => 0x17, 94 => 0x3017, 150 => 0x29, 158 => [0x38,0x4d,0x4f], 300 => 0x17 },
	'colorgain' => { 191 => 0x51 },
	'colorhue' => { 185 => 0x8d },
	'colorimetricreference' => { 98 => 0xc6bf },
	'colorlabel' => { 390 => 'ColorLabel' },
	'colormatrix' => { 245 => 0x200, 246 => 0x1011, 322 => 0xa030 },
	'colormatrix1' => { 98 => 0xc621 },
	'colormatrix2' => { 98 => 0xc622, 249 => 0x200 },
	'colormatrixa' => { 294 => 0x203 },
	'colormatrixadobergb' => { 322 => 0xa032 },
	'colormatrixb' => { 294 => 0x204 },
	'colormatrixnumber' => { 246 => 0x1019 },
	'colormatrixsrgb' => { 322 => 0xa031 },
	'colormode' => { 94 => 0x3015, 103 => 0x1210, 114 => 0x66, 150 => 0x28, 153 => 0x16, 155 => 0x101, 156 => 0x36, 158 => 0x7, 185 => 0x3, 211 => 0x4, 261 => 0x32, 325 => 0x2c, 345 => 0xb029, 399 => 'ColorMode' },
	'colormoirereduction' => { 222 => 0x15 },
	'colormoirereductionmode' => { 222 => 0x5 },
	'colornoisereduction' => { 372 => 0x8029, 387 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 387 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 222 => 0x18 },
	'colornoisereductionsharpness' => { 222 => 0x1c },
	'colornoisereductionsmoothness' => { 387 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 102 => 0x2 },
	'colorprofile' => { 150 => 0x33 },
	'colorrepresentation' => { 108 => 0x3c },
	'colorsequence' => { 108 => 0x41 },
	'colorspace' => { 41 => 0x3, 53 => 0xb4, 84 => 0x10b4, 98 => 0xa001, 134 => 'ColorSpace', 151 => 0x2f, 152 => 0x25, 153 => 0x17, 185 => 0x1e, 241 => 0x507, 294 => 0x37, 322 => 0xa011, 325 => 0xb, 333 => 0x1b, 334 => 0x83, 335 => 0xe, 349 => 0x6, 391 => 'ColorSpace' },
	'colortempasshot' => { 33 => 0x4, 34 => 0x1d, 35 => 0x26, 36 => 0x43, 39 => 0x43, 40 => 0x43 },
	'colortempauto' => { 33 => 0x9, 34 => 0x22, 35 => 0x1c, 36 => 0x48, 39 => 0x48, 40 => 0x48 },
	'colortempcloudy' => { 33 => 0x22, 34 => 0x31, 35 => 0x35, 36 => 0x5c, 39 => 0x75, 40 => 0x8e, 294 => 0x55 },
	'colortempcustom' => { 36 => 0x84 },
	'colortempcustom1' => { 34 => 0x45 },
	'colortempcustom2' => { 34 => 0x4a },
	'colortempdaylight' => { 33 => 0x18, 34 => 0x27, 35 => 0x2b, 36 => 0x52, 39 => 0x6b, 40 => 0x84, 294 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x7b, 53 => 0xae, 63 => 0x9, 84 => 0x10ae, 103 => 0x1005, 112 => 0x846, 128 => 'ColorTemperature', 151 => [0x6e,0x49], 152 => 0x3f, 153 => [0x39,0x5e], 155 => 0x10b, 158 => [0x3c,0x4c,0x4e], 257 => 0x321, 294 => 0x50, 316 => 0x1308, 345 => 0xb021, 387 => 'Temperature' },
	'colortemperatureadj' => { 372 => 0x8013 },
	'colortemperaturebg' => { 246 => 0x1013 },
	'colortemperaturecustom' => { 333 => 0xc, 334 => 0xb },
	'colortemperaturerg' => { 246 => 0x1014 },
	'colortemperatureset' => { 333 => 0x7, 334 => 0x6 },
	'colortemperaturesetting' => { 153 => 0x25, 335 => 0x17, 349 => 0xe },
	'colortempflash' => { 33 => 0x36, 34 => 0x40, 35 => 0x49, 36 => 0x70, 39 => 0x89, 40 => 0xa2, 294 => 0x5a },
	'colortempflashdata' => { 36 => 0x24a },
	'colortempfluorescent' => { 33 => 0x2c, 34 => 0x3b, 35 => 0x3f, 36 => 0x66, 39 => 0x7f, 40 => 0x98 },
	'colortempfluorescentd' => { 294 => 0x57 },
	'colortempfluorescentn' => { 294 => 0x58 },
	'colortempfluorescentw' => { 294 => 0x59 },
	'colortempkelvin' => { 33 => 0x31, 35 => 0x44, 36 => 0x6b, 39 => 0x84, 40 => 0x9d, 261 => 0x44, 316 => 0x1307 },
	'colortempmeasured' => { 33 => 0xe, 36 => 0x4d, 39 => 0x4d, 40 => 0x4d },
	'colortemppc1' => { 35 => 0x94, 36 => 0x75 },
	'colortemppc2' => { 35 => 0x99, 36 => 0x7a },
	'colortemppc3' => { 35 => 0x9e, 36 => 0x7f },
	'colortempshade' => { 33 => 0x1d, 34 => 0x2c, 35 => 0x30, 36 => 0x57, 39 => 0x70, 40 => 0x89, 294 => 0x54 },
	'colortemptungsten' => { 33 => 0x27, 34 => 0x36, 35 => 0x3a, 36 => 0x61, 39 => 0x7a, 40 => 0x93, 294 => 0x56 },
	'colortempunknown' => { 33 => 0x13, 35 => 0x21, 39 => 0x52, 40 => 0x52 },
	'colortempunknown10' => { 33 => 0x63, 35 => 0x76, 39 => 0xa2, 40 => 0x7f },
	'colortempunknown11' => { 33 => 0x68, 35 => 0x7b, 39 => 0xa7, 40 => 0xa7 },
	'colortempunknown12' => { 33 => 0x6d, 35 => 0x80, 39 => 0xac, 40 => 0xac },
	'colortempunknown13' => { 33 => 0x72, 35 => 0x85, 39 => 0xb1, 40 => 0xb1 },
	'colortempunknown14' => { 35 => 0x8a, 39 => 0xb6, 40 => 0xb6 },
	'colortempunknown15' => { 35 => 0x8f, 39 => 0xbb, 40 => 0xbb },
	'colortempunknown16' => { 35 => 0xa3, 40 => 0xc0 },
	'colortempunknown17' => { 40 => 0xc5 },
	'colortempunknown18' => { 40 => 0xca },
	'colortempunknown19' => { 40 => 0xcf },
	'colortempunknown2' => { 33 => 0x3b, 35 => 0x4e, 39 => 0x57, 40 => 0x57 },
	'colortempunknown20' => { 40 => 0xd4 },
	'colortempunknown3' => { 33 => 0x40, 35 => 0x53, 39 => 0x5c, 40 => 0x5c },
	'colortempunknown4' => { 33 => 0x45, 35 => 0x58, 39 => 0x61, 40 => 0x61 },
	'colortempunknown5' => { 33 => 0x4a, 35 => 0x5d, 39 => 0x66, 40 => 0x66 },
	'colortempunknown6' => { 33 => 0x4f, 35 => 0x62, 39 => 0x8e, 40 => 0x6b },
	'colortempunknown7' => { 33 => 0x54, 35 => 0x67, 39 => 0x93, 40 => 0x70 },
	'colortempunknown8' => { 33 => 0x59, 35 => 0x6c, 39 => 0x98, 40 => 0x75 },
	'colortempunknown9' => { 33 => 0x5e, 35 => 0x71, 39 => 0x9d, 40 => 0x7a },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 30 => 0x2a, 41 => 0x2 },
	'colortoneadj' => { 89 => 0x11e },
	'colortoneauto' => { 60 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 59 => 0x6c, 60 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 59 => 0x3c, 60 => 0x3c },
	'colortonemonochrome' => { 59 => 0x84, 60 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 59 => 0x54, 60 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 59 => 0x24, 60 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 59 => 0xc, 60 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 59 => 0x9c, 60 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 59 => 0xb4, 60 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 59 => 0xcc, 60 => 0xe4 },
	'commanddials' => { 236 => '5.1' },
	'commanddialsaperturesetting' => { 228 => '17.3', 229 => '18.3', 234 => '33.3', 235 => '17.3', 238 => '18.3' },
	'commanddialschangemainsub' => { 228 => '17.2', 229 => '18.1', 234 => '33.2', 235 => '17.2', 238 => '18.1' },
	'commanddialsmenuandplayback' => { 228 => '17.4', 229 => '18.2', 234 => '33.4', 235 => '17.4', 238 => '18.2' },
	'commanddialsreverserotation' => { 228 => '17.1', 229 => '6.4', 231 => '16.2', 232 => '17.2', 234 => '33.1', 235 => '17.1', 238 => '6.2', 239 => '18.1' },
	'commanderchannel' => { 236 => '10.2', 237 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 236 => '13.1', 237 => '31.1' },
	'commandergroupa_ttlcomp' => { 239 => '32.1' },
	'commandergroupamanualoutput' => { 236 => '13.2', 237 => '28.2' },
	'commandergroupamode' => { 236 => '11.2', 237 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 236 => '14.1', 237 => '32.1' },
	'commandergroupb_ttlcomp' => { 239 => '33.1' },
	'commandergroupbmanualoutput' => { 236 => '14.2', 237 => '29.2' },
	'commandergroupbmode' => { 236 => '11.3', 237 => '29.1' },
	'commanderinternalflash' => { 236 => '11.1', 237 => '27.1' },
	'commanderinternalmanualoutput' => { 236 => '12.2', 237 => '27.2' },
	'commanderinternalttlchannel' => { 234 => '18.2' },
	'commanderinternalttlcomp' => { 236 => '12.1', 237 => '30.2', 239 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 234 => '20.1', 235 => '26.1' },
	'commanderinternalttlcompgroupa' => { 234 => '21.1', 235 => '27.1' },
	'commanderinternalttlcompgroupb' => { 234 => '22.1', 235 => '28.1' },
	'comment' => { 0 => 0x2, 99 => 'Comment', 129 => 'Comment', 253 => 'Comment' },
	'compass' => { 319 => 0x4 },
	'complianceprofile' => { 402 => 'complianceProfile' },
	'componentsconfiguration' => { 98 => 0x9101, 134 => 'Components', 391 => 'ComponentsConfiguration' },
	'componentversion' => { 84 => 0x80c },
	'composer' => { 412 => 'composer' },
	'compositionadjust' => { 293 => '0.1' },
	'compositionadjustrotation' => { 293 => 0x7 },
	'compositionadjustx' => { 293 => 0x5 },
	'compositionadjusty' => { 293 => 0x6 },
	'compressedbitsperpixel' => { 98 => 0x9102, 391 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 155 => 0x40, 246 => 0x40 },
	'compression' => { 98 => 0x103, 408 => 'Compression' },
	'compressionfactor' => { 241 => 0x50d },
	'compressionratio' => { 134 => 'Compression', 246 => 0x1034 },
	'confidencelevel' => { 382 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 89 => 0x266, 302 => 0xd6 },
	'constrainedcropwidth' => { 89 => 0x262, 302 => 0xd5 },
	'contact' => { 106 => 0x76 },
	'contactinfo' => { 401 => 'contactInfo' },
	'contentlocationcode' => { 106 => 0x1a },
	'contentlocationname' => { 106 => 0x1b },
	'contenttype' => { 402 => 'contentType' },
	'continuousbracketing' => { 153 => 0x20 },
	'continuousdrive' => { 30 => 0x5 },
	'continuousshootingspeed' => { 71 => 0x610 },
	'continuousshotlimit' => { 71 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 30 => 0xd, 93 => 0xc, 94 => [0x3012,0x20], 98 => [0xa408,0xfe54], 103 => [0x1004,0x1006], 128 => 'Contrast', 150 => 0x20, 151 => 0x31, 152 => 0x27, 153 => 0x19, 158 => 0x2, 187 => 0x33, 246 => 0x1029, 261 => 0x39, 263 => 0x300a, 294 => 0x20, 300 => 0xc, 312 => 0x24, 316 => 0x1012, 325 => 0xd, 333 => 0x1d, 334 => 0x1a, 345 => 0x2004, 387 => 'Contrast', 391 => 'Contrast' },
	'contrast2012' => { 387 => 'Contrast2012' },
	'contrastadj' => { 89 => 0x115, 224 => 0x2c, 372 => 0x8017 },
	'contrastauto' => { 60 => 0x90 },
	'contrastcurve' => { 185 => 0x8c },
	'contrastdetectaf' => { 161 => 0x4 },
	'contrastdetectafarea' => { 294 => 0x231 },
	'contrastdetectafinfocus' => { 161 => 0x1c },
	'contrastfaithful' => { 18 => 0xec, 59 => 0x60, 60 => 0x60 },
	'contrasthighlight' => { 294 => 0x6d },
	'contrasthighlightshadowadj' => { 294 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 59 => 0x30, 60 => 0x30 },
	'contrastmode' => { 261 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 59 => 0x78, 60 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 59 => 0x48, 60 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 59 => 0x18, 60 => 0x18 },
	'contrastsetting' => { 241 => 0x505, 249 => 0x1012, 335 => 0x10, 349 => 0x8 },
	'contrastshadow' => { 294 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 59 => 0x0, 60 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 59 => 0x90, 60 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 59 => 0xa8, 60 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 59 => 0xc0, 60 => 0xd8 },
	'contributedmedia' => { 412 => 'contributedMedia' },
	'contributedmediaduration' => { 412 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 412 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 412 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 412 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 412 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 412 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 412 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 412 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 412 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 412 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 388 => 'contributor' },
	'contributors' => { 129 => 'Contributors' },
	'controldialset' => { 153 => 0x46 },
	'controlledvocabularyterm' => { 397 => 'CVterm' },
	'controllerboardversion' => { 257 => 0x332 },
	'controlmode' => { 65 => 0x12 },
	'conversionlens' => { 242 => 0x403, 261 => 0x35 },
	'converter' => { 98 => 0xfe4d, 211 => 0xb, 387 => 'Converter' },
	'converttograyscale' => { 387 => 'ConvertToGrayscale' },
	'cookingequipment' => { 404 => 'cookingEquipment' },
	'cookingmethod' => { 404 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 98 => 0x8298, 129 => 'Copyright', 253 => 'Copyright', 294 => 0x22f, 307 => 'Copyright', 398 => 'Copyright', 405 => 'copyright', 408 => 'Copyright', 412 => 'copyright' },
	'copyrightflag' => { 305 => 0x40a },
	'copyrightnotice' => { 106 => 0x74 },
	'copyrightowner' => { 400 => 'CopyrightOwner' },
	'copyrightownerid' => { 400 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 400 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 400 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 400 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 400 => 'CopyrightStatus' },
	'copyrightyear' => { 402 => 'copyrightYear' },
	'coringfilter' => { 245 => 0x310, 246 => 0x102d, 249 => 0x310 },
	'coringvalues' => { 245 => 0x311, 249 => 0x311 },
	'corporateentity' => { 402 => 'corporateEntity' },
	'country' => { 133 => 'Country', 261 => 0x69, 399 => 'Country' },
	'country-primarylocationcode' => { 106 => 0x64 },
	'country-primarylocationname' => { 106 => 0x65 },
	'countrycode' => { 184 => 0x5, 303 => 'CountryCode', 396 => 'CountryCode' },
	'course' => { 404 => 'course' },
	'coverage' => { 388 => 'coverage' },
	'coverdate' => { 402 => 'coverDate' },
	'coverdisplaydate' => { 402 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 294 => 0x28 },
	'crc32' => { 389 => 'crc32' },
	'createdate' => { 98 => 0x9004, 129 => 'CreateDate', 250 => 'CreationDate', 253 => 'create-date', 307 => 'CreationDate', 309 => 0x1, 410 => 'CreateDate' },
	'creationdate' => { 398 => 'CreationDate', 402 => 'creationDate' },
	'creationtime' => { 253 => 'Creation Time' },
	'creativestyle' => { 333 => 0x1a, 334 => 0x18, 344 => 0x41, 345 => 0xb020, 368 => 0x4a },
	'creativestylesetting' => { 335 => 0xf, 349 => 0x7 },
	'creativestylewaschanged' => { 372 => 0x8001 },
	'creator' => { 250 => 'Creator', 307 => 'Creator', 388 => 'creator', 398 => 'Creator' },
	'creatoraddress' => { 396 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorcity' => { 396 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 396 => 'CreatorContactInfo' },
	'creatorcountry' => { 396 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatorpostalcode' => { 396 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 396 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 410 => 'CreatorTool' },
	'creatorworkemail' => { 396 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 396 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 396 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 106 => 0x6e, 399 => 'Credit' },
	'creditline' => { 405 => 'creditLine' },
	'creditlinereq' => { 415 => 'CreditLineReq' },
	'creditlinerequired' => { 400 => 'CreditLineRequired' },
	'cropactive' => { 89 => 0x244 },
	'cropangle' => { 387 => 'CropAngle' },
	'cropaspectratio' => { 89 => 0x260 },
	'cropbottom' => { 102 => 0x9, 216 => 0x36, 302 => 0xdc, 387 => 'CropBottom' },
	'cropbottommargin' => { 43 => 0x3 },
	'cropcircleactive' => { 90 => 0xd6 },
	'cropcircleradius' => { 90 => 0xd9 },
	'cropcirclex' => { 90 => 0xd7 },
	'cropcircley' => { 90 => 0xd8 },
	'cropconstraintowarp' => { 387 => 'CropConstrainToWarp' },
	'croph' => { 380 => 'CropH' },
	'cropheight' => { 89 => 0x24c, 245 => 0x615, 249 => 0x615, 387 => 'CropHeight' },
	'crophispeed' => { 185 => 0x1b },
	'cropleft' => { 89 => 0x246, 102 => 0x6, 216 => 0x1e, 245 => 0x612, 249 => 0x612, 302 => 0xd9, 387 => 'CropLeft' },
	'cropleftmargin' => { 43 => 0x0 },
	'cropmode35mm' => { 316 => 0x1018 },
	'cropoutputheight' => { 216 => 0xce },
	'cropoutputheightinches' => { 216 => 0x96 },
	'cropoutputpixels' => { 216 => 0xd6 },
	'cropoutputresolution' => { 216 => 0xb6 },
	'cropoutputscale' => { 216 => 0xbe },
	'cropoutputwidth' => { 216 => 0xc6 },
	'cropoutputwidthinches' => { 216 => 0x8e },
	'croppedareaimageheightpixels' => { 376 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 376 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 376 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 376 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 316 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 316 => 0x1603 },
	'cropright' => { 102 => 0x8, 216 => 0x2e, 302 => 0xdb, 387 => 'CropRight' },
	'croprightmargin' => { 43 => 0x1 },
	'croprotation' => { 102 => 0xb },
	'cropscaledresolution' => { 216 => 0x9e },
	'cropsourceresolution' => { 216 => 0xae },
	'croptop' => { 89 => 0x248, 102 => 0x7, 216 => 0x26, 245 => 0x613, 249 => 0x613, 302 => 0xda, 387 => 'CropTop' },
	'croptopmargin' => { 43 => 0x2 },
	'cropunit' => { 387 => 'CropUnit' },
	'cropunits' => { 387 => 'CropUnits' },
	'cropw' => { 380 => 'CropW' },
	'cropwidth' => { 89 => 0x24a, 245 => 0x614, 249 => 0x614, 387 => 'CropWidth' },
	'cropx' => { 380 => 'CropX' },
	'cropy' => { 380 => 'CropY' },
	'crossprocess' => { 294 => 0x7b },
	'crossprocessparams' => { 294 => 0x235 },
	'cuisine' => { 404 => 'cuisine' },
	'currenticcprofile' => { 98 => 0xc691 },
	'currentpreprofilematrix' => { 98 => 0xc692 },
	'currentversion' => { 372 => 0xd000 },
	'curve0x' => { 380 => 'Curve0x' },
	'curve0y' => { 380 => 'Curve0y' },
	'curve1x' => { 380 => 'Curve1x' },
	'curve1y' => { 380 => 'Curve1y' },
	'curve2x' => { 380 => 'Curve2x' },
	'curve2y' => { 380 => 'Curve2y' },
	'curve3x' => { 380 => 'Curve3x' },
	'curve3y' => { 380 => 'Curve3y' },
	'curve4x' => { 380 => 'Curve4x' },
	'curve4y' => { 380 => 'Curve4y' },
	'curves' => { 221 => 0x76a43201 },
	'custom1' => { 400 => 'Custom1' },
	'custom10' => { 400 => 'Custom10' },
	'custom2' => { 400 => 'Custom2' },
	'custom3' => { 400 => 'Custom3' },
	'custom4' => { 400 => 'Custom4' },
	'custom5' => { 400 => 'Custom5' },
	'custom6' => { 400 => 'Custom6' },
	'custom7' => { 400 => 'Custom7' },
	'custom8' => { 400 => 'Custom8' },
	'custom9' => { 400 => 'Custom9' },
	'customcontrast' => { 90 => 0x4e },
	'customcontrols' => { 71 => 0x70c },
	'customdefaultunsharpfineness' => { 90 => 0xbe },
	'customdefaultunsharpstrength' => { 90 => 0xbc },
	'customdefaultunsharpthreshold' => { 90 => 0xc0 },
	'customlinear' => { 90 => 0x4f },
	'customoutputhighlightpoint' => { 90 => 0x53 },
	'customoutputshadowpoint' => { 90 => 0x54 },
	'custompicturestylefilename' => { 53 => 0x4010 },
	'customrawhighlight' => { 90 => 0x7c },
	'customrawhighlightpoint' => { 90 => 0x51 },
	'customrawshadow' => { 90 => 0x85 },
	'customrawshadowpoint' => { 90 => 0x52 },
	'customrendered' => { 98 => 0xa401, 391 => 'CustomRendered' },
	'customsaturation' => { 241 => 0x503 },
	'customsettingsalldefault' => { 228 => '0.2', 234 => '0.2' },
	'customsettingsbank' => { 228 => '0.1', 229 => '0.1', 234 => '0.1', 238 => '0.2' },
	'customsharpness' => { 90 => 0x50 },
	'customunsharpmaskfineness' => { 90 => 0xb8 },
	'customunsharpmaskstrength' => { 90 => 0xb6 },
	'customunsharpmaskthreshold' => { 90 => 0xba },
	'customwb_rblevels' => { 349 => 0x1a },
	'customwb_rgblevels' => { 334 => 0x8, 335 => 0x19 },
	'customwbbluelevel' => { 153 => 0x36 },
	'customwberror' => { 153 => 0x37 },
	'customwbgreenlevel' => { 153 => 0x35 },
	'customwbredlevel' => { 153 => 0x34 },
	'customwbsetting' => { 153 => 0x26 },
	'd-lightinghq' => { 221 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 217 => 0x2 },
	'd-lightinghqhighlight' => { 217 => 0x1 },
	'd-lightinghqselected' => { 221 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 217 => 0x0 },
	'd-lightinghs' => { 221 => 0xce5554aa },
	'd-lightinghsadjustment' => { 218 => 0x0 },
	'd-lightinghscolorboost' => { 218 => 0x1 },
	'd-rangeoptimizerhighlight' => { 372 => 0x8024 },
	'd-rangeoptimizermode' => { 372 => 0x8022 },
	'd-rangeoptimizershadow' => { 372 => 0x802d },
	'd-rangeoptimizervalue' => { 372 => 0x8023 },
	'd810meteringmode' => { 209 => [0x16be,0x175e] },
	'datacompressionmethod' => { 108 => 0x6e },
	'dataimprint' => { 150 => 0x34 },
	'datascaling' => { 294 => 0x3d },
	'date' => { 294 => 0x6, 388 => 'date' },
	'dateacquired' => { 148 => 'DateAcquired' },
	'datecreated' => { 106 => 0x37, 399 => 'DateCreated' },
	'datedisplayformat' => { 213 => 0x3 },
	'dateidentified' => { 97 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 231 => '4.2' },
	'daterecieved' => { 402 => 'dateRecieved' },
	'datesent' => { 107 => 0x46 },
	'datestampmode' => { 53 => 0x1c },
	'datetime' => { 381 => 'datetime', 408 => 'DateTime' },
	'datetimedigitized' => { 391 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 87 => 0x0, 98 => 0x9003, 126 => 0x14, 129 => 'OriginalDate', 312 => 0xb, 391 => 'DateTimeOriginal' },
	'datetimestamp' => { 114 => 0x64 },
	'datetimeutc' => { 241 => 0x908 },
	'daylightsavings' => { 66 => 0x3, 213 => 0x2 },
	'dccontinent' => { 97 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 97 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 97 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 97 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 97 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 97 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 97 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 97 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 97 => 'Event' },
	'dcfootprintspatialfit' => { 97 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 97 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 97 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 97 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 97 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 97 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 97 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 97 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 97 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 97 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 97 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 97 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 97 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 97 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 97 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 97 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 97 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 97 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 97 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 97 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 97 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 97 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 97 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 97 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 97 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 97 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 97 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 97 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 97 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 97 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 97 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 97 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 97 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 97 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 97 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 97 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 97 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 137 => 'Declination' },
	'decposition' => { 150 => 0x32 },
	'defaultblackrender' => { 98 => 0xc7a6 },
	'defaultcroporigin' => { 98 => 0xc61f },
	'defaultcropsize' => { 98 => 0xc620 },
	'defaulteraseoption' => { 71 => 0x813 },
	'defaultscale' => { 98 => 0xc61e },
	'defaultusercrop' => { 98 => 0xc7b5 },
	'defringe' => { 387 => 'Defringe' },
	'defringegreenamount' => { 387 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 387 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 387 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 387 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 387 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 387 => 'DefringePurpleHueLo' },
	'deletedimagecount' => { 185 => 0xa6, 192 => 0x6e },
	'deprecatedon' => { 384 => 'deprecatedOn' },
	'derivedfrom' => { 413 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 413 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 413 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 413 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 413 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 413 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 413 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 413 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 413 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 413 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 413 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 413 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 413 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 413 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 413 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 413 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 413 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 413 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 253 => 'Description', 388 => 'description', 410 => 'Description' },
	'destination' => { 107 => 0x5 },
	'destinationcity' => { 294 => 0x24, 299 => 0x3 },
	'destinationcitycode' => { 300 => 0x1001 },
	'destinationdst' => { 294 => 0x26, 299 => '0.3' },
	'developmentdynamicrange' => { 103 => 0x1403 },
	'device' => { 402 => 'device' },
	'devicesettingdescription' => { 391 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 391 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 391 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 391 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 322 => 0x2 },
	'dialdirectiontvav' => { 71 => 0x706 },
	'dietaryneeds' => { 404 => 'dietaryNeeds' },
	'digitalcreationdate' => { 106 => 0x3e },
	'digitalcreationtime' => { 106 => 0x3f },
	'digitaldeehighlightadj' => { 191 => 0x202 },
	'digitaldeeshadowadj' => { 191 => 0x200 },
	'digitaldeethreshold' => { 191 => 0x201 },
	'digitalfilter' => { 325 => 0x59 },
	'digitalfilter01' => { 281 => 0x5 },
	'digitalfilter02' => { 281 => 0x16 },
	'digitalfilter03' => { 281 => 0x27 },
	'digitalfilter04' => { 281 => 0x38 },
	'digitalfilter05' => { 281 => 0x49 },
	'digitalfilter06' => { 281 => 0x5a },
	'digitalfilter07' => { 281 => 0x6b },
	'digitalfilter08' => { 281 => 0x7c },
	'digitalfilter09' => { 281 => 0x8d },
	'digitalfilter10' => { 281 => 0x9e },
	'digitalfilter11' => { 281 => 0xaf },
	'digitalfilter12' => { 281 => 0xc0 },
	'digitalfilter13' => { 281 => 0xd1 },
	'digitalfilter14' => { 281 => 0xe2 },
	'digitalfilter15' => { 281 => 0xf3 },
	'digitalfilter16' => { 281 => 0x104 },
	'digitalfilter17' => { 281 => 0x115 },
	'digitalfilter18' => { 281 => 0x126 },
	'digitalfilter19' => { 281 => 0x137 },
	'digitalfilter20' => { 281 => 0x148 },
	'digitalgain' => { 63 => 0xb },
	'digitalgem' => { 177 => 0x0 },
	'digitalice' => { 191 => 0x100 },
	'digitalimageguid' => { 397 => 'DigImageGUID' },
	'digitalroc' => { 189 => 0x0 },
	'digitalsourcefiletype' => { 397 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 397 => 'DigitalSourceType' },
	'digitalzoom' => { 30 => 0xc, 93 => 0xa, 114 => 0x68, 128 => 'DigitalZoom', 150 => 0xc, 185 => 0x86, 211 => 0xa, 246 => 0x204, 294 => 0x1e, 300 => 0xa, 324 => 0x204, 360 => 0x12, 361 => 0x12 },
	'digitalzoomon' => { 324 => 0x21b },
	'digitalzoomratio' => { 98 => 0xa404, 354 => 0x200, 356 => 0x21c, 391 => 'DigitalZoomRatio' },
	'director' => { 412 => 'director' },
	'directorphotography' => { 412 => 'directorPhotography' },
	'directory' => { 99 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 26 => 0x1f7 },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 173 => 0x3 },
	'disclaimer' => { 253 => 'Disclaimer' },
	'discnumber' => { 412 => 'discNumber' },
	'dishtype' => { 404 => 'dishType' },
	'displayallafpoints' => { 71 => 0x514 },
	'displayaperture' => { 30 => 0x23 },
	'displayedunitsx' => { 306 => 0x2 },
	'displayedunitsy' => { 306 => 0x6 },
	'displayname' => { 401 => 'displayName' },
	'distance1' => { 114 => 0x28 },
	'distance2' => { 114 => 0x2c },
	'distance3' => { 114 => 0x30 },
	'distance4' => { 114 => 0x34 },
	'distortion' => { 322 => 0xa050 },
	'distortioncontrol' => { 192 => 0x10 },
	'distortioncorrection' => { 90 => 0x67, 241 => 0x50b, 264 => '7.1', 284 => 0x0, 367 => 0x601, 368 => 0x5b },
	'distortioncorrection2' => { 245 => 0x1011 },
	'distortioncorrectionon' => { 90 => 0x63 },
	'distortioncorrectionsetting' => { 345 => 0x2013 },
	'distortionn' => { 264 => 0xc },
	'distortionparam02' => { 264 => 0x2 },
	'distortionparam04' => { 264 => 0x4 },
	'distortionparam08' => { 264 => 0x8 },
	'distortionparam09' => { 264 => 0x9 },
	'distortionparam11' => { 264 => 0xb },
	'distortionscale' => { 264 => 0x5 },
	'distributor' => { 402 => 'distributor' },
	'distributorproductid' => { 401 => 'distributorProductID' },
	'dloon' => { 90 => 0xdc },
	'dlosetting' => { 90 => 0xdd },
	'dlosettingapplied' => { 90 => 0xe4 },
	'dloshootingdistance' => { 90 => 0xde },
	'dloversion' => { 90 => 0xe5 },
	'dmcomment' => { 412 => 'comment' },
	'dngadobedata' => { 98 => 0xc634 },
	'dngbackwardversion' => { 98 => 0xc613 },
	'dnglensinfo' => { 98 => 0xc630 },
	'dngprivatedata' => { 98 => 0xc634 },
	'dngversion' => { 98 => 0xc612 },
	'document' => { 253 => 'Document' },
	'documentancestorid' => { 399 => [\'DocumentAncestors','DocumentAncestorsAncestorID'] },
	'documentancestors' => { 399 => 'DocumentAncestors' },
	'documenthistory' => { 106 => 0xe7 },
	'documentid' => { 413 => 'DocumentID' },
	'documentname' => { 98 => 0x10d },
	'documentnotes' => { 106 => 0xe6 },
	'doi' => { 402 => 'doi' },
	'dotrange' => { 98 => 0x150 },
	'dpp' => { 381 => 'dpp' },
	'drivemode' => { 94 => 0x3103, 150 => 0x6, 153 => 0x1e, 156 => 0xe, 241 => 0x600, 294 => 0x34, 316 => 0x1002, 325 => 0x3, 333 => 0x4, 334 => 0x7e, 335 => 0x34 },
	'drivemode2' => { 153 => 0xa, 275 => 0x7, 344 => 0xe, 349 => 0x1 },
	'drivemodesetting' => { 335 => 0x4 },
	'dspfirmwareversion' => { 294 => 0x27 },
	'duration' => { 56 => 0x6a, 127 => 'Duration', 141 => 'Duration', 404 => 'duration', 412 => 'duration' },
	'durationscale' => { 412 => [\'duration','durationScale'] },
	'durationvalue' => { 412 => [\'duration','durationValue'] },
	'dustremovaldata' => { 53 => 0x97 },
	'dynamicafarea' => { 228 => '1.4', 234 => '1.4' },
	'dynamicareaafdisplay' => { 229 => '46.1', 238 => '47.1' },
	'dynamicrange' => { 103 => 0x1400 },
	'dynamicrangeexpansion' => { 294 => 0x69, 316 => 0x100e },
	'dynamicrangemax' => { 89 => 0x7c },
	'dynamicrangemin' => { 89 => 0x7a },
	'dynamicrangeoptimizer' => { 153 => 0x15, 345 => [0xb025,0xb04f], 352 => 0x1144, 353 => [0x1144,0x324], 354 => [0x1120,0x300], 355 => [0x119c,0x37c], 356 => [0x1178,0x328], 357 => [0x1030,0x50], 358 => [0x228,0x50] },
	'dynamicrangeoptimizerbracket' => { 344 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 333 => 0x19, 334 => 0x17, 335 => 0xd, 344 => 0x79, 349 => 0x5 },
	'dynamicrangeoptimizermode' => { 156 => 0x15, 333 => 0x18, 334 => 0x16, 344 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 153 => 0x27, 335 => 0xc, 349 => 0x4 },
	'dynamicrangesetting' => { 103 => 0x1402 },
	'e-dialinprogram' => { 275 => '1.3' },
	'e-mountversioncamera' => { 335 => 0x3f3, 371 => 0xb },
	'e-mountversionlens' => { 335 => 0x3f0, 371 => 0xd },
	'earliestageorloweststage' => { 97 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 97 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 97 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 97 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 97 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 239 => '6.1' },
	'easyexposurecompensation' => { 228 => '6.4', 229 => '6.5', 234 => '4.4', 235 => '5.2', 238 => '6.3' },
	'easymode' => { 30 => 0xb },
	'edgenoisereduction' => { 222 => 0x4, 372 => 0x8028 },
	'edition' => { 402 => 'edition' },
	'editorialupdate' => { 106 => 0x8 },
	'editstatus' => { 106 => 0x7, 303 => 'EditStatus' },
	'editversionname' => { 221 => 0x3d136244 },
	'effectivelv' => { 294 => 0x2d },
	'effectivemaxaperture' => { 181 => 0x12, 182 => 0x13 },
	'eissn' => { 402 => 'eIssn' },
	'electronicfront-curtainshutter' => { 238 => '5.3' },
	'elevation' => { 137 => 'Elevation' },
	'email' => { 129 => 'EMail' },
	'embargodate' => { 405 => 'embargoDate' },
	'embdencrightsexpr' => { 397 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 397 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 397 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 397 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 399 => 'EmbeddedXMPDigest' },
	'emissivity' => { 100 => 0x3 },
	'encryptionkey' => { 322 => 0xa020 },
	'endingpage' => { 402 => 'endingPage' },
	'enduser' => { 400 => 'EndUser' },
	'enduserid' => { 400 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 400 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 412 => 'engineer' },
	'enhancedarktones' => { 214 => 0x8 },
	'enhancement' => { 93 => 0x16, 94 => 0x3016 },
	'enhancer' => { 245 => 0x300 },
	'enhancervalues' => { 245 => 0x301 },
	'envelopenumber' => { 107 => 0x28 },
	'envelopepriority' => { 107 => 0x3c },
	'enveloperecordversion' => { 107 => 0x0 },
	'epsonimageheight' => { 246 => 0x20c },
	'epsonimagewidth' => { 246 => 0x20b },
	'epsonsoftware' => { 246 => 0x20d },
	'equipmentinstitution' => { 374 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 374 => 'EquipmentManufacturer' },
	'equipmentversion' => { 242 => 0x0 },
	'ettlii' => { 71 => 0x304, 72 => 0xd, 73 => 0xe, 74 => 0x7, 75 => 0x7, 76 => 0xe },
	'event' => { 375 => 'Event', 379 => 'Event', 397 => 'Event', 402 => 'event' },
	'eventalias' => { 401 => 'eventAlias' },
	'eventday' => { 97 => [\'Event','EventDay'] },
	'eventearliestdate' => { 97 => [\'Event','EventEarliestDate'] },
	'eventend' => { 401 => 'eventEnd' },
	'eventenddayofyear' => { 97 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 97 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 97 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 97 => [\'Event','EventHabitat'] },
	'eventid' => { 97 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 97 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 97 => [\'Event','EventMonth'] },
	'eventnumber' => { 312 => 0x9 },
	'eventremarks' => { 97 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 97 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 97 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 401 => 'eventStart' },
	'eventstartdayofyear' => { 97 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 401 => 'eventSubtype' },
	'eventtime' => { 97 => [\'Event','EventEventTime'] },
	'eventtype' => { 401 => 'eventType' },
	'eventverbatimeventdate' => { 97 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 97 => [\'Event','EventYear'] },
	'evsteps' => { 275 => '1.2', 277 => 0x0 },
	'evstepsize' => { 231 => '5.1', 232 => '6.1', 233 => '6.1', 236 => '0.7' },
	'exclusivityenddate' => { 405 => 'exclusivityEndDate' },
	'excursiontolerance' => { 108 => 0x82 },
	'exif' => { 99 => 'EXIF' },
	'exifbyteorder' => { 99 => 'ExifByteOrder' },
	'exifcamerainfo' => { 106 => 0xe8 },
	'exifimageheight' => { 98 => 0xa003, 391 => 'PixelYDimension' },
	'exifimagewidth' => { 98 => 0xa002, 391 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 99 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 98 => 0x9000, 391 => 'ExifVersion' },
	'exitpupilposition' => { 181 => 0x4, 182 => 0x4 },
	'expirationdate' => { 106 => 0x25, 405 => 'expirationDate' },
	'expirationtime' => { 106 => 0x26 },
	'exposure' => { 98 => 0xfe51, 387 => 'Exposure' },
	'exposure2012' => { 387 => 'Exposure2012' },
	'exposureadj' => { 219 => 0x0 },
	'exposureadj2' => { 219 => 0x12 },
	'exposureadjust' => { 325 => 0xc },
	'exposurebracketingindicatorlast' => { 153 => 0x52 },
	'exposurebracketshotnumber' => { 156 => 0x2d, 344 => 0x2f },
	'exposurebracketstepsize' => { 275 => 0x8 },
	'exposurebracketvalue' => { 185 => 0x19 },
	'exposurecompensation' => { 65 => 0x6, 80 => 0x0, 98 => 0x9204, 114 => 0x24, 128 => 'ExposureComp', 150 => 0xd, 151 => 0x53, 152 => 0x1e, 156 => 0x49c0, 246 => 0x1006, 294 => 0x16, 322 => 0xa013, 325 => [0xc,0x35,0x4d], 352 => 0x114c, 353 => 0x114c, 354 => 0x1128, 356 => 0x1180, 357 => 0x1038, 358 => 0x230, 391 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 349 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 153 => 0x47, 156 => 0x2a },
	'exposurecompensationset' => { 333 => 0x3, 334 => 0x3, 335 => 0x3, 349 => 0x1e },
	'exposurecompensationsetting' => { 153 => 0x1 },
	'exposurecompstepsize' => { 228 => '6.3', 229 => '7.3', 234 => '4.3', 238 => '7.3' },
	'exposurecontrolstep' => { 235 => '6.1' },
	'exposurecontrolstepsize' => { 228 => '6.2', 229 => '7.1', 234 => '4.2', 238 => '7.1', 239 => '7.1' },
	'exposurecount' => { 103 => 0x1032 },
	'exposuredelaymode' => { 228 => '10.1', 229 => '11.1', 231 => '9.1', 232 => '10.1', 233 => '10.1', 234 => '10.4', 235 => '10.1', 236 => '6.4', 238 => '11.1', 239 => '11.2' },
	'exposuredifference' => { 185 => 0xe },
	'exposureindex' => { 98 => 0xa215, 391 => 'ExposureIndex' },
	'exposureindicator' => { 153 => 0x50 },
	'exposurelevelincrements' => { 69 => 0x6, 70 => 0x6, 71 => 0x101, 72 => 0x5, 73 => 0x6, 74 => 0x5, 75 => 0x5, 76 => 0x6, 77 => 0x4, 333 => 0x58, 334 => 0x58 },
	'exposurelockused' => { 376 => 'ExposureLockUsed' },
	'exposuremode' => { 98 => 0xa402, 128 => 'ExposureMode', 150 => 0x1, 151 => 0xa, 152 => 0x0, 153 => 0x0, 156 => 0x34, 241 => 0x200, 259 => 0x40d, 325 => 0x8, 345 => 0xb041, 391 => 'ExposureMode' },
	'exposuremodeinmanual' => { 71 => 0x10b },
	'exposureprogram' => { 98 => 0x8822, 316 => 0x1001, 326 => 0x17e, 333 => 0x3c, 334 => 0x3c, 335 => 0x5, 339 => 0x14, 344 => 0x3f, 349 => 0x2, 352 => 0x1175, 353 => 0x1179, 354 => 0x1155, 355 => 0x11d1, 356 => 0x11ad, 357 => 0x1065, 358 => 0x25d, 368 => 0x48, 391 => 'ExposureProgram' },
	'exposureshift' => { 241 => 0x203 },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x6, 28 => 0x7, 65 => 0x16, 98 => 0x829a, 111 => 0xfd05, 114 => 0x20, 116 => 0xfa24, 118 => 0xf104, 121 => 0x12, 123 => 0x38, 126 => 0x10, 128 => 'ExposureTime', 150 => 0x9, 151 => 0x35, 152 => 0x48, 153 => 0x8, 156 => 0x49b8, 294 => 0x12, 322 => 0xa018, 325 => [0x32,0x4a], 333 => 0x0, 334 => 0x0, 349 => [0x21,0x23,0x27], 368 => 0x10, 391 => 'ExposureTime' },
	'exposuretime2' => { 325 => [0x33,0x4b] },
	'exposuretuning' => { 185 => 0x1c },
	'exposurevalue' => { 112 => 0x3 },
	'exposurewarning' => { 103 => 0x1302 },
	'exrauto' => { 103 => 0x1033 },
	'exrmode' => { 103 => 0x1034 },
	'extendedwbdetect' => { 241 => 0x902 },
	'extender' => { 242 => 0x301 },
	'extenderfirmwareversion' => { 242 => 0x304 },
	'extendermagnification' => { 130 => 'Magnification' },
	'extendermake' => { 130 => 'Make' },
	'extendermodel' => { 130 => 'Model', 242 => 0x303 },
	'extenderserialnumber' => { 130 => 'SerialNumber', 242 => 0x302 },
	'externalflash' => { 244 => 0x1201 },
	'externalflashae1' => { 246 => 0x101f },
	'externalflashae1_0' => { 246 => 0x101b },
	'externalflashae2' => { 246 => 0x1020 },
	'externalflashae2_0' => { 246 => 0x101c },
	'externalflashbounce' => { 244 => 0x1204, 246 => 0x1026, 282 => 0x1a },
	'externalflashcompensation' => { 176 => 0x1b },
	'externalflashexposurecomp' => { 185 => 0x17, 282 => 0x19 },
	'externalflashfirmware' => { 174 => 0x6, 175 => 0x6, 176 => 0x6 },
	'externalflashflags' => { 174 => 0x8, 175 => 0x8, 176 => 0x8 },
	'externalflashguidenumber' => { 244 => 0x1203, 282 => '24.1' },
	'externalflashgvalue' => { 246 => 0x1025 },
	'externalflashmode' => { 246 => 0x1028, 282 => 0x2 },
	'externalflashzoom' => { 244 => 0x1205, 246 => 0x1027 },
	'externalsensorbrightnessvalue' => { 257 => 0x311, 263 => 0x3408 },
	'extrainfoversion' => { 337 => 0x1a },
	'eyestartaf' => { 153 => 0x40 },
	'face10position' => { 91 => 0x3f4, 92 => 0x1ec, 172 => 0x28, 279 => 0x12 },
	'face10size' => { 280 => 0x12 },
	'face11position' => { 172 => 0x2c, 279 => 0x14 },
	'face11size' => { 280 => 0x14 },
	'face12position' => { 172 => 0x30, 279 => 0x16 },
	'face12size' => { 280 => 0x16 },
	'face13position' => { 279 => 0x18 },
	'face13size' => { 280 => 0x18 },
	'face14position' => { 279 => 0x1a },
	'face14size' => { 280 => 0x1a },
	'face15position' => { 279 => 0x1c },
	'face15size' => { 280 => 0x1c },
	'face16position' => { 279 => 0x1e },
	'face16size' => { 280 => 0x1e },
	'face17position' => { 279 => 0x20 },
	'face17size' => { 280 => 0x20 },
	'face18position' => { 279 => 0x22 },
	'face18size' => { 280 => 0x22 },
	'face19position' => { 279 => 0x24 },
	'face19size' => { 280 => 0x24 },
	'face1position' => { 44 => 0x8, 91 => 0xd, 92 => 0x18, 172 => 0x4, 255 => 0x1, 279 => 0x0, 313 => 0xbc, 340 => 0x1, 341 => 0x0, 342 => 0x0, 343 => 0x5b },
	'face1size' => { 280 => 0x0 },
	'face20position' => { 279 => 0x26 },
	'face20size' => { 280 => 0x26 },
	'face21position' => { 279 => 0x28 },
	'face21size' => { 280 => 0x28 },
	'face22position' => { 279 => 0x2a },
	'face22size' => { 280 => 0x2a },
	'face23position' => { 279 => 0x2c },
	'face23size' => { 280 => 0x2c },
	'face24position' => { 279 => 0x2e },
	'face24size' => { 280 => 0x2e },
	'face25position' => { 279 => 0x30 },
	'face25size' => { 280 => 0x30 },
	'face26position' => { 279 => 0x32 },
	'face26size' => { 280 => 0x32 },
	'face27position' => { 279 => 0x34 },
	'face27size' => { 280 => 0x34 },
	'face28position' => { 279 => 0x36 },
	'face28size' => { 280 => 0x36 },
	'face29position' => { 279 => 0x38 },
	'face29size' => { 280 => 0x38 },
	'face2position' => { 44 => 0xa, 91 => 0x7c, 92 => 0x4c, 172 => 0x8, 255 => 0x5, 279 => 0x2, 313 => 0xc8, 340 => 0x6, 341 => 0x20, 342 => 0x25, 343 => 0x65 },
	'face2size' => { 280 => 0x2 },
	'face30position' => { 279 => 0x3a },
	'face30size' => { 280 => 0x3a },
	'face31position' => { 279 => 0x3c },
	'face31size' => { 280 => 0x3c },
	'face32position' => { 279 => 0x3e },
	'face32size' => { 280 => 0x3e },
	'face3position' => { 44 => 0xc, 91 => 0xeb, 92 => 0x80, 172 => 0xc, 255 => 0x9, 279 => 0x4, 313 => 0xd4, 340 => 0xb, 341 => 0x40, 342 => 0x4a, 343 => 0x6f },
	'face3size' => { 280 => 0x4 },
	'face4position' => { 44 => 0xe, 91 => 0x15a, 92 => 0xb4, 172 => 0x10, 255 => 0xd, 279 => 0x6, 313 => 0xe0, 340 => 0x10, 341 => 0x60, 342 => 0x6f, 343 => 0x79 },
	'face4size' => { 280 => 0x6 },
	'face5position' => { 44 => 0x10, 91 => 0x1c9, 92 => 0xe8, 172 => 0x14, 255 => 0x11, 279 => 0x8, 313 => 0xec, 340 => 0x15, 341 => 0x80, 342 => 0x94 },
	'face5size' => { 280 => 0x8 },
	'face6position' => { 44 => 0x12, 91 => 0x238, 92 => 0x11c, 172 => 0x18, 279 => 0xa, 313 => 0xf8, 340 => 0x1a, 341 => 0xa0, 342 => 0xb9 },
	'face6size' => { 280 => 0xa },
	'face7position' => { 44 => 0x14, 91 => 0x2a7, 92 => 0x150, 172 => 0x1c, 279 => 0xc, 313 => 0x104, 340 => 0x1f, 341 => 0xc0, 342 => 0xde },
	'face7size' => { 280 => 0xc },
	'face8position' => { 44 => 0x16, 91 => 0x316, 92 => 0x184, 172 => 0x20, 279 => 0xe, 313 => 0x110, 340 => 0x24, 341 => 0xe0, 342 => 0x103 },
	'face8size' => { 280 => 0xe },
	'face9position' => { 44 => 0x18, 91 => 0x385, 92 => 0x1b8, 172 => 0x24, 279 => 0x10 },
	'face9size' => { 280 => 0x10 },
	'facedetect' => { 294 => 0x76, 322 => 0x100 },
	'facedetectarea' => { 245 => 0x1201 },
	'facedetectframecrop' => { 245 => 0x1207 },
	'facedetectframesize' => { 44 => 0x3, 91 => 0x1, 92 => 0x4, 172 => 0x1, 245 => 0x1203, 294 => 0x77, 313 => 0xb6 },
	'facedetection' => { 335 => 0x30, 349 => 0x19 },
	'faceid' => { 382 => 'FaceID' },
	'faceinfounknown' => { 94 => 0x2089 },
	'facename' => { 322 => 0x123 },
	'faceorientation' => { 92 => 0x8 },
	'faceposition' => { 278 => 0x2, 323 => 0x4 },
	'facepositions' => { 103 => 0x4103 },
	'facerecognition' => { 322 => 0x120 },
	'facesdetected' => { 44 => 0x2, 45 => 0x2, 46 => 0x3, 91 => 0x0, 92 => 0x2, 94 => 0x211c, 103 => 0x4100, 172 => 0x3, 245 => 0x1200, 261 => 0x3f, 278 => 0x0, 313 => 0xb5, 323 => 0x0, 340 => 0x0, 343 => 0x3, 351 => 0x30 },
	'facesrecognized' => { 256 => 0x0 },
	'facewidth' => { 45 => 0x1 },
	'faithfuloutputhighlightpoint' => { 90 => 0x38 },
	'faithfuloutputshadowpoint' => { 90 => 0x39 },
	'faithfulrawcolortone' => { 90 => 0x31 },
	'faithfulrawcontrast' => { 90 => 0x33 },
	'faithfulrawhighlight' => { 90 => 0x79 },
	'faithfulrawhighlightpoint' => { 90 => 0x36 },
	'faithfulrawlinear' => { 90 => 0x34 },
	'faithfulrawsaturation' => { 90 => 0x32 },
	'faithfulrawshadow' => { 90 => 0x82 },
	'faithfulrawshadowpoint' => { 90 => 0x37 },
	'faithfulrawsharpness' => { 90 => 0x35 },
	'faithfulunsharpmaskfineness' => { 90 => 0xac },
	'faithfulunsharpmaskstrength' => { 90 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 90 => 0xae },
	'femicroadjustment' => { 71 => 0x111 },
	'ffid' => { 389 => 'ffid' },
	'field' => { 401 => 'field' },
	'fieldcount' => { 246 => 0x103f },
	'filecreatedate' => { 99 => 'FileCreateDate' },
	'filedatarate' => { 412 => 'fileDataRate' },
	'fileformat' => { 82 => 0x0, 107 => 0x14, 325 => [0x22,0x26], 345 => 0xb000 },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 26 => 0x1eb, 262 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 99 => 'FileModifyDate' },
	'filename' => { 99 => 'FileName' },
	'filenameasdelivered' => { 400 => 'FileNameAsDelivered' },
	'filenumber' => { 47 => 0x1, 53 => 0x8, 84 => 0x1817, 95 => 'FileNumber', 173 => 0x4 },
	'filenumbermemory' => { 150 => 0x1a },
	'filenumbersequence' => { 228 => '12.2', 231 => '3.1', 232 => '4.1', 233 => '4.1', 234 => '11.1', 235 => '4.3', 239 => '5.2' },
	'filesource' => { 98 => 0xa300, 103 => 0x8000, 391 => 'FileSource' },
	'fileversion' => { 107 => 0x16 },
	'fillflashautoreduction' => { 69 => 0xe, 70 => 0xe, 77 => 0xa },
	'filllight' => { 387 => 'FillLight' },
	'fillorder' => { 98 => 0x10a },
	'filmmode' => { 103 => 0x1401, 259 => 0x412, 261 => 0x42 },
	'filmtype' => { 191 => 0x2 },
	'filtereffect' => { 47 => 0xe, 187 => 0x37 },
	'filtereffectauto' => { 60 => 0xa0 },
	'filtereffectfaithful' => { 59 => 0x70, 60 => 0x70 },
	'filtereffectlandscape' => { 59 => 0x40, 60 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 59 => 0x88, 60 => 0x88 },
	'filtereffectneutral' => { 59 => 0x58, 60 => 0x58 },
	'filtereffectportrait' => { 59 => 0x28, 60 => 0x28 },
	'filtereffectstandard' => { 59 => 0x10, 60 => 0x10 },
	'filtereffectuserdef1' => { 59 => 0xa0, 60 => 0xb8 },
	'filtereffectuserdef2' => { 59 => 0xb8, 60 => 0xd0 },
	'filtereffectuserdef3' => { 59 => 0xd0, 60 => 0xe8 },
	'finderdisplayduringexposure' => { 70 => 0x1 },
	'finesharpness' => { 294 => 0x70 },
	'finetuneoptcenterweighted' => { 228 => '7.2', 229 => '9.1', 238 => '9.1', 239 => '9.1' },
	'finetuneopthighlightweighted' => { 238 => '46.1' },
	'finetuneoptmatrixmetering' => { 228 => '8.1', 229 => '8.2', 234 => '6.1', 238 => '8.2', 239 => '8.2' },
	'finetuneoptspotmetering' => { 228 => '8.2', 229 => '9.2', 234 => '6.2', 238 => '9.2', 239 => '9.2' },
	'firmware' => { 246 => 0x405, 325 => [0x17,0x3b,0x57], 383 => 'Firmware' },
	'firmwaredate' => { 93 => 0x15, 94 => 0x2001, 312 => 0x4 },
	'firmwareid' => { 157 => 0x0 },
	'firmwarename' => { 322 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 53 => 0x1e, 314 => 0x0 },
	'firmwarerevision2' => { 314 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 112 => 0xce5, 126 => 0x57, 128 => 'FirmwareVersion', 261 => 0x2, 263 => 0x3109, 294 => 0x230, 316 => 0x2 },
	'firstphotodate' => { 376 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 400 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 106 => 0x16 },
	'flash' => { 95 => 'Flash', 98 => 0x9209, 151 => 0x1f, 152 => 0x15, 391 => 'Flash' },
	'flashaction' => { 333 => 0x3e, 334 => 0x3e, 345 => 0x2017, 349 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 333 => 0x4c, 334 => 0x4c, 349 => 0x77 },
	'flashactionexternal' => { 349 => [0x78,0x7c] },
	'flashactivity' => { 30 => 0x1c },
	'flashbatterylevel' => { 36 => 0x249 },
	'flashbias' => { 261 => 0x24 },
	'flashbits' => { 30 => 0x1d },
	'flashbuttonfunction' => { 71 => 0x70e },
	'flashchargelevel' => { 246 => 0x1010 },
	'flashcolorfilter' => { 176 => 0x10 },
	'flashcommandermode' => { 174 => '9.1', 175 => '9.1', 176 => '9.1' },
	'flashcompensation' => { 174 => 0xa, 175 => 0xa, 176 => 0xa, 383 => 'FlashCompensation' },
	'flashcontrol' => { 333 => 0x23, 334 => 0x1f, 335 => 0x21 },
	'flashcontrolbuilt-in' => { 234 => '16.1', 235 => '23.1', 237 => '23.1', 238 => '24.1' },
	'flashcontrolmode' => { 174 => '9.2', 175 => '9.2', 176 => '9.2', 241 => 0x404 },
	'flashcurtain' => { 261 => 0x48 },
	'flashdefault' => { 153 => 0x42 },
	'flashdevice' => { 246 => 0x1005 },
	'flashdistance' => { 94 => 0x2034 },
	'flashenergy' => { 98 => 0xa20b, 391 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 185 => 0x18 },
	'flashexposurecomp' => { 65 => 0xf, 103 => 0x1011, 131 => 'ExposureComp', 150 => 0x23, 155 => 0x104, 156 => 0x49c1, 185 => 0x12, 241 => 0x401, 246 => 0x1023, 294 => 0x4d, 316 => 0x100b, 325 => [0x3a,0x56], 345 => 0x104 },
	'flashexposurecomp2' => { 208 => 0x4d2 },
	'flashexposurecomp3' => { 176 => 0x1d },
	'flashexposurecomp4' => { 176 => 0x27 },
	'flashexposurecomparea' => { 229 => '38.4', 238 => '38.4' },
	'flashexposurecompset' => { 153 => 0x10, 268 => 0xe, 333 => 0x14, 334 => 0x12, 335 => 0x23, 349 => 0x1f },
	'flashexposurecompset2' => { 349 => [0x26,0x2c] },
	'flashexposureindicator' => { 153 => 0x54 },
	'flashexposureindicatorlast' => { 153 => 0x56 },
	'flashexposureindicatornext' => { 153 => 0x55 },
	'flashexposurelock' => { 47 => 0x19 },
	'flashfired' => { 114 => 0x5d, 131 => 'Fired', 150 => 0x14, 207 => '590.3', 261 => 0x8007, 391 => [\'Flash','FlashFired'] },
	'flashfiring' => { 71 => 0x306, 72 => 0x6, 73 => 0x7, 76 => 0x7 },
	'flashfirmwareversion' => { 242 => 0x1002 },
	'flashfocallength' => { 174 => 0xb, 175 => 0xc, 176 => 0xc },
	'flashfunction' => { 156 => 0x31, 391 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 174 => 0xe, 175 => 0xf, 176 => 0xf },
	'flashgroupacompensation' => { 174 => 0x11, 175 => 0x12, 176 => 0x13 },
	'flashgroupacontrolmode' => { 174 => 0xf, 175 => '16.1', 176 => '17.1' },
	'flashgroupaoutput' => { 174 => 0x11, 175 => 0x12, 176 => 0x13 },
	'flashgroupbcompensation' => { 174 => 0x12, 175 => 0x13, 176 => 0x14 },
	'flashgroupbcontrolmode' => { 174 => 0x10, 175 => '17.1', 176 => '18.1' },
	'flashgroupboutput' => { 174 => 0x12, 175 => 0x13, 176 => 0x14 },
	'flashgroupccompensation' => { 175 => 0x14, 176 => 0x15 },
	'flashgroupccontrolmode' => { 175 => '17.2', 176 => '18.2' },
	'flashgroupcoutput' => { 175 => 0x14, 176 => 0x15 },
	'flashguidenumber' => { 65 => 0xd, 81 => 0x0, 131 => 'GuideNumber' },
	'flashintensity' => { 93 => [0x19,0x5], 241 => 0x405 },
	'flashlevel' => { 230 => 0x9, 345 => 0xb048 },
	'flashmake' => { 131 => 'Make' },
	'flashmanufacturer' => { 148 => 'FlashManufacturer' },
	'flashmetering' => { 150 => 0x3f, 153 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 26 => 0x15 },
	'flashmeteringsegments' => { 294 => 0x20a },
	'flashmode' => { 93 => 0x4, 114 => 0x5c, 131 => 'Mode', 150 => 0x2, 151 => 0x20, 152 => 0x16, 153 => 0xf, 185 => 0x87, 241 => 0x400, 246 => 0x1004, 294 => 0xc, 300 => 0x4, 315 => 0x20, 316 => 0x100a, 324 => 0x225, 333 => 0x13, 334 => 0x7f, 335 => 0x20, 349 => 0x10, 352 => 0x1138, 353 => 0x1138, 354 => 0x1114, 355 => 0x1190, 356 => 0x116c, 357 => 0x1024, 358 => 0x21c, 391 => [\'Flash','FlashMode'] },
	'flashmodel' => { 131 => 'Model', 148 => 'FlashModel', 242 => 0x1001 },
	'flashoptions' => { 275 => 0x2 },
	'flashoptions2' => { 275 => 0x10 },
	'flashoutput' => { 36 => 0x248, 65 => 0x21, 174 => 0xa, 175 => 0xa, 176 => 0xa },
	'flashpixversion' => { 98 => 0xa000, 391 => 'FlashpixVersion' },
	'flashredeyemode' => { 391 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 241 => 0x403 },
	'flashreturn' => { 391 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 131 => 'SerialNumber', 242 => 0x1003 },
	'flashsetting' => { 185 => 0x8 },
	'flashshutterspeed' => { 228 => '20.2', 229 => '23.2', 234 => '15.2', 235 => '22.2', 236 => '7.2', 237 => '22.2', 238 => '23.2', 239 => '23.1' },
	'flashsource' => { 174 => 0x4, 175 => 0x4, 176 => 0x4 },
	'flashstatus' => { 282 => 0x0, 349 => [0x82,0x86], 359 => 0x31 },
	'flashstatusbuilt-in' => { 335 => [0x87,0x287] },
	'flashstatusexternal' => { 335 => [0x88,0x288] },
	'flashsyncspeed' => { 228 => '20.1', 229 => '23.1', 234 => '15.1', 235 => '22.1', 237 => '22.1', 238 => '23.1' },
	'flashsyncspeedav' => { 69 => 0x3, 71 => 0x10f, 72 => 0x2, 73 => 0x3, 74 => 0x2, 75 => 0x2, 76 => 0x3, 77 => 0x6 },
	'flashthreshold' => { 81 => 0x1 },
	'flashtype' => { 131 => 'Type', 153 => 0x59, 185 => 0x9, 242 => 0x1000 },
	'flashwarning' => { 235 => '30.1', 236 => '7.1', 239 => '31.1', 261 => 0x62 },
	'flexiblespotposition' => { 345 => 0x201d },
	'flickerreduce' => { 324 => 0x218 },
	'fliphorizontal' => { 221 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x5, 28 => 0x6, 65 => 0x15, 98 => 0x829d, 111 => 0xfd04, 114 => 0x1e, 116 => 0xfa23, 118 => 0xf103, 121 => 0x13, 123 => 0x3c, 126 => 0xc, 135 => 'FNumber', 150 => 0xa, 151 => 0x36, 152 => 0x47, 153 => 0x9, 156 => 0x49c7, 294 => 0x13, 322 => 0xa019, 325 => [0x31,0x49], 333 => 0x1, 334 => 0x1, 349 => [0x20,0x22,0x26], 391 => 'FNumber' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x1e, 49 => 0x1, 94 => 0x1d, 98 => 0x920a, 121 => 0x1d, 135 => 'FocalLength', 150 => 0x12, 181 => 0xa, 182 => 0xb, 285 => 0x9, 294 => 0x1d, 316 => 0x1500, 332 => 0xe, 356 => 0x1278, 357 => 0x1134, 358 => 0x32c, 391 => 'FocalLength' },
	'focallength2' => { 349 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 98 => 0xa405, 322 => 0xa01a, 391 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 332 => 0x10 },
	'focalplanediagonal' => { 242 => 0x103, 246 => 0x205 },
	'focalplaneresolutionunit' => { 98 => 0xa210, 391 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 98 => 0xa20e, 391 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 49 => 0x2 },
	'focalplanexunknown' => { 49 => 0x2 },
	'focalplaneyresolution' => { 98 => 0xa20f, 391 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 49 => 0x3 },
	'focalplaneyunknown' => { 49 => 0x3 },
	'focaltype' => { 9 => 0x2d, 49 => 0x0 },
	'focalunits' => { 30 => 0x19 },
	'focus' => { 211 => 0x8 },
	'focusarea' => { 150 => 0x31 },
	'focusareaselection' => { 236 => '15.2' },
	'focuscontinuous' => { 30 => 0x20 },
	'focusdisplayaiservoandmf' => { 71 => 0x515 },
	'focusdistance' => { 135 => 'FocusDistance', 150 => 0x13, 156 => 0x49bb, 181 => 0x9, 182 => 0xa, 244 => 0x305 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0x56, 47 => 0x15, 65 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0x54, 47 => 0x14, 65 => 0x13 },
	'focusholdbutton' => { 153 => 0x44 },
	'focusinfoversion' => { 244 => 0x0 },
	'focusingscreen' => { 70 => 0x0, 71 => 0x80b, 76 => 0x0 },
	'focuslocked' => { 149 => 0x14 },
	'focusmode' => { 30 => 0x7, 93 => 0x3, 94 => [0x3003,0xd], 103 => 0x1021, 114 => 0x38, 128 => 'FocusMode', 150 => 0x30, 152 => 0xe, 153 => 0xc, 185 => 0x7, 241 => 0x301, 246 => 0x100b, 261 => 0x7, 294 => 0xd, 300 => 0x3, 316 => 0x1006, 326 => [0xb,0x5], 332 => [0x15,0x1d], 333 => 0x4d, 334 => 0x4d, 345 => [0xb042,0xb04e,0x201b], 349 => 0x13, 363 => 0x16 },
	'focusmode2' => { 275 => '3.1', 349 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 230 => '10.1', 330 => 0x14, 331 => 0x15, 333 => 0x10, 334 => 0xf, 335 => 0x6 },
	'focusmodeswitch' => { 153 => 0x58, 333 => 0x2e },
	'focuspixel' => { 103 => 0x1023 },
	'focuspointwrap' => { 228 => '2.2', 229 => '2.2', 234 => '2.2', 235 => '1.2', 238 => '2.2', 239 => '2.5' },
	'focusposition' => { 181 => 0x8, 182 => 0x8, 294 => 0x10, 344 => 0x9bb },
	'focusposition2' => { 349 => [0x29,0x2b,0x2f], 363 => 0x2d, 366 => 0x20 },
	'focusprocess' => { 241 => 0x302 },
	'focusrange' => { 30 => 0x12, 246 => 0x100a },
	'focusrangeindex' => { 285 => '3.1' },
	'focussetting' => { 325 => 0x6 },
	'focusstatus' => { 332 => 0x19, 333 => 0x53, 334 => 0x53 },
	'focusstepcount' => { 244 => 0x301, 246 => 0x100e },
	'focusstepinfinity' => { 244 => 0x303, 246 => 0x103b },
	'focusstepnear' => { 244 => 0x304, 246 => 0x103c },
	'focustrackinglockon' => { 228 => ['1.5','4.1'], 229 => '1.4', 234 => '3.1', 235 => '0.4', 238 => '1.4' },
	'focuswarning' => { 103 => 0x1301 },
	'foldername' => { 150 => 0x27 },
	'foldernumber' => { 333 => 0x9a, 335 => [0x402,0x114,0x316] },
	'fontcomposite' => { 417 => [\'Fonts','FontsComposite'] },
	'fontface' => { 417 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 417 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 417 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 417 => [\'Fonts','FontsFontName'] },
	'fonts' => { 417 => 'Fonts' },
	'fonttype' => { 417 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 417 => [\'Fonts','FontsVersionString'] },
	'for' => { 307 => 'For' },
	'format' => { 388 => 'format', 410 => 'Format' },
	'forwardlock' => { 407 => 'forwardlock' },
	'forwardmatrix1' => { 98 => 0xc714 },
	'forwardmatrix2' => { 98 => 0xc715 },
	'framecount' => { 56 => [0x2,0x4] },
	'frameheight' => { 103 => 0x3822 },
	'framenum' => { 302 => 0xd7 },
	'framenumber' => { 103 => 0x8003, 156 => 0x3c, 294 => 0x29 },
	'framerate' => { 56 => [0x1,0x6], 98 => 0xc764, 103 => 0x3820 },
	'framewidth' => { 103 => 0x3821 },
	'framing' => { 401 => 'framing' },
	'freebytes' => { 84 => 0x1 },
	'freememorycardimages' => { 151 => [0x37,0x54], 152 => [0x2d,0x4a], 153 => 0x32 },
	'fujiflashmode' => { 103 => 0x1010 },
	'fullimagesize' => { 345 => 0xb02b },
	'fullpanoheightpixels' => { 376 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 376 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 316 => 0x100d },
	'fullsizeimage' => { 134 => 'data' },
	'fullsizeimagename' => { 134 => '1Name' },
	'fullsizeimagetype' => { 134 => '0Type' },
	'funcbutton' => { 228 => ['14.1','15.1'], 229 => '14.1', 234 => '28.1', 235 => '13.1', 238 => '14.1', 239 => '14.1' },
	'funcbuttonplusdials' => { 228 => ['14.2','15.2'], 229 => '14.2', 234 => '31.1', 238 => '42.1' },
	'functionbutton' => { 233 => '13.1', 236 => '5.2' },
	'gainbase' => { 245 => 0x610 },
	'gaincontrol' => { 98 => 0xa407, 391 => 'GainControl' },
	'gamma' => { 98 => 0xa500, 392 => 'Gamma' },
	'gammacompensatedvalue' => { 108 => 0x91 },
	'geimagesize' => { 103 => 0x1304 },
	'gemake' => { 104 => 0x300 },
	'gemodel' => { 104 => 0x207 },
	'genre' => { 402 => 'genre', 412 => 'genre' },
	'geography' => { 403 => 'geography' },
	'geologicalcontext' => { 97 => 'GeologicalContext' },
	'geologicalcontextbed' => { 97 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 97 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 97 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 97 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 97 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 99 => 'Geosync' },
	'geotag' => { 99 => 'Geotag' },
	'geotiffasciiparams' => { 98 => 0x87b1 },
	'geotiffdirectory' => { 98 => 0x87af },
	'geotiffdoubleparams' => { 98 => 0x87b0 },
	'geotime' => { 99 => 'Geotime' },
	'globalaltitude' => { 305 => 0x419 },
	'globalangle' => { 305 => 0x40d },
	'good' => { 412 => 'good' },
	'googleplusuploadcode' => { 98 => 0x9009 },
	'gpsaltitude' => { 105 => 0x6, 132 => 'Altitude', 391 => 'GPSAltitude' },
	'gpsaltituderef' => { 105 => 0x5, 391 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 105 => 0x1c, 391 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 105 => 0x1d },
	'gpsdatetime' => { 132 => 'DateTime', 391 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 105 => 0x18, 132 => 'Bearing', 391 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 105 => 0x17, 391 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 105 => 0x1a, 132 => 'Distance', 391 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 105 => 0x19, 391 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 105 => 0x14, 391 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 105 => 0x13 },
	'gpsdestlongitude' => { 105 => 0x16, 391 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 105 => 0x15 },
	'gpsdifferential' => { 105 => 0x1e, 132 => 'Differential', 391 => 'GPSDifferential' },
	'gpsdop' => { 105 => 0xb, 391 => 'GPSDOP' },
	'gpshpositioningerror' => { 105 => 0x1f, 391 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 105 => 0x11, 391 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 105 => 0x10, 391 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 105 => 0x2, 132 => 'Latitude', 391 => 'GPSLatitude' },
	'gpslatituderef' => { 105 => 0x1 },
	'gpslongitude' => { 105 => 0x4, 132 => 'Longitude', 391 => 'GPSLongitude' },
	'gpslongituderef' => { 105 => 0x3 },
	'gpsmapdatum' => { 105 => 0x12, 132 => 'Datum', 391 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 105 => 0xa, 132 => 'MeasureMode', 391 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 105 => 0x1b, 391 => 'GPSProcessingMethod' },
	'gpssatellites' => { 105 => 0x8, 132 => 'Satellites', 391 => 'GPSSatellites' },
	'gpsspeed' => { 105 => 0xd, 132 => 'Speed', 391 => 'GPSSpeed' },
	'gpsspeedref' => { 105 => 0xc, 391 => 'GPSSpeedRef' },
	'gpsstatus' => { 105 => 0x9, 391 => 'GPSStatus' },
	'gpstimestamp' => { 105 => 0x7 },
	'gpstrack' => { 105 => 0xf, 132 => 'Heading', 391 => 'GPSTrack' },
	'gpstrackref' => { 105 => 0xe, 391 => 'GPSTrackRef' },
	'gpsversionid' => { 105 => 0x0, 391 => 'GPSVersionID' },
	'gradation' => { 241 => 0x50f },
	'gradientbasedcorractive' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 387 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 387 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 387 => 'GrainAmount' },
	'grainfrequency' => { 387 => 'GrainFrequency' },
	'grainsize' => { 387 => 'GrainSize' },
	'graymixeraqua' => { 387 => 'GrayMixerAqua' },
	'graymixerblue' => { 387 => 'GrayMixerBlue' },
	'graymixergreen' => { 387 => 'GrayMixerGreen' },
	'graymixermagenta' => { 387 => 'GrayMixerMagenta' },
	'graymixerorange' => { 387 => 'GrayMixerOrange' },
	'graymixerpurple' => { 387 => 'GrayMixerPurple' },
	'graymixerred' => { 387 => 'GrayMixerRed' },
	'graymixeryellow' => { 387 => 'GrayMixerYellow' },
	'graypoint' => { 372 => 0x8021 },
	'grayresponseunit' => { 98 => 0x122 },
	'greencurvelimits' => { 89 => 0x1c4 },
	'greencurvepoints' => { 89 => 0x19a },
	'greenhue' => { 387 => 'GreenHue' },
	'greensaturation' => { 387 => 'GreenSaturation' },
	'griddisplay' => { 228 => '13.3', 229 => '4.3', 231 => '2.2', 234 => '10.5', 235 => '3.4', 236 => '6.1', 238 => '4.4', 239 => '4.2' },
	'gripbatteryadload' => { 273 => 0x5 },
	'gripbatteryadnoload' => { 273 => 0x4 },
	'gripbatterystate' => { 273 => '1.2' },
	'groupareaafillumination' => { 229 => '46.4', 238 => '47.4' },
	'halftonehints' => { 98 => 0x141 },
	'hardlink' => { 99 => 'HardLink' },
	'hasalternative' => { 402 => 'hasAlternative' },
	'hascorrection' => { 402 => 'hasCorrection' },
	'hascorrectiona-lang' => { 402 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 402 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 402 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 387 => 'HasCrop' },
	'hasextendedxmp' => { 414 => 'HasExtendedXMP' },
	'hassettings' => { 387 => 'HasSettings' },
	'hastranslation' => { 402 => 'hasTranslation' },
	'hdr' => { 50 => 0x1, 178 => 0x4, 261 => 0x9e, 294 => 0x85, 345 => 0x200a },
	'hdreffect' => { 50 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 178 => 0x0 },
	'hdrlevel' => { 178 => 0x5, 335 => 0x2e, 349 => 0x17 },
	'hdrlevel2' => { 178 => 0x7 },
	'hdrsetting' => { 335 => 0x2d, 349 => 0x16, 352 => 0x1148, 353 => 0x1148, 354 => 0x1124, 355 => 0x11a0, 356 => 0x117c, 357 => 0x1034, 358 => 0x22c },
	'hdrsmoothing' => { 178 => 0x6 },
	'headline' => { 106 => 0x69, 399 => 'Headline' },
	'hierarchicalkeywords' => { 143 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 143 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 143 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 143 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 143 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 143 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 378 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 97 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 265 => 0x1a },
	'highisomultipliergreen' => { 265 => 0x19 },
	'highisomultiplierred' => { 265 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 26 => 0xc9, 52 => 0x5, 71 => 0x202, 103 => 0x100e, 185 => 0xb1, 294 => 0x71, 333 => 0x2c, 334 => 0x26, 335 => 0x26, 345 => 0x2009, 349 => 0x12, 368 => 0x42 },
	'highisonoisereduction2' => { 345 => 0xb050 },
	'highlight' => { 325 => 0xf },
	'highlightcolordistortreduct' => { 372 => 0x8026 },
	'highlightprotection' => { 220 => 0x6 },
	'highlightrecovery' => { 387 => 'HighlightRecovery' },
	'highlights' => { 380 => 'Highlights' },
	'highlights2012' => { 387 => 'Highlights2012' },
	'highlighttone' => { 103 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 26 => 0x7, 52 => 0x3, 71 => 0x203 },
	'highlowkeyadj' => { 294 => 0x6c },
	'highspeedsync' => { 153 => 0x5, 333 => 0x2, 334 => 0x2 },
	'histogramxml' => { 221 => 0x83a1a25 },
	'history' => { 399 => 'History', 413 => 'History' },
	'historyaction' => { 413 => [\'History','HistoryAction'] },
	'historychanged' => { 413 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 413 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 413 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 413 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 413 => [\'History','HistoryWhen'] },
	'hometowncity' => { 94 => 0x3006, 294 => 0x23, 299 => 0x2 },
	'hometowncitycode' => { 300 => 0x1000 },
	'hometowndst' => { 294 => 0x25, 299 => '0.2' },
	'hostcomputer' => { 98 => 0x13c },
	'hue' => { 158 => 0x3b, 294 => 0x67 },
	'hueadj' => { 224 => 0x2f, 372 => 0x8019 },
	'hueadjust' => { 316 => 0x1016 },
	'hueadjustment' => { 151 => 0x4a, 152 => 0x40, 185 => 0x92, 187 => 0x36 },
	'hueadjustmentaqua' => { 387 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 387 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 387 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 387 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 387 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 387 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 387 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 387 => 'HueAdjustmentYellow' },
	'huesetting' => { 249 => 0x1011 },
	'icc_profile' => { 99 => 'ICC_Profile' },
	'iccprofilename' => { 399 => 'ICCProfile' },
	'idccreativestyle' => { 372 => 0x8000 },
	'idcpreviewlength' => { 372 => 0x202 },
	'idcpreviewstart' => { 372 => 0x201 },
	'identification' => { 97 => 'Identification' },
	'identificationid' => { 97 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 97 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 97 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 97 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 97 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 97 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 388 => 'identifier', 410 => 'Identifier' },
	'illumination' => { 236 => '0.5' },
	'imageadjustment' => { 185 => 0x80, 211 => 0x5 },
	'imagealterationconstraints' => { 400 => 'ImageAlterationConstraints' },
	'imagearea' => { 196 => 0x10, 199 => 0x10 },
	'imageareaoffset' => { 294 => 0x38 },
	'imageauthentication' => { 185 => 0x20 },
	'imageboundary' => { 185 => 0x16 },
	'imagecount' => { 185 => 0xa5, 347 => 0x11b, 359 => 0x32 },
	'imagecount2' => { 359 => 0x4c },
	'imagecount3' => { 359 => [0x1a0,0x1aa,0x1bd] },
	'imagecreator' => { 400 => 'ImageCreator' },
	'imagecreatorid' => { 400 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 400 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 400 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 185 => 0xa2 },
	'imagedescription' => { 98 => 0x10e, 408 => 'ImageDescription' },
	'imageduplicationconstraints' => { 400 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 221 => 0xfe443a45 },
	'imageeditcount' => { 294 => 0x41 },
	'imageediting' => { 294 => 0x32 },
	'imageeffects' => { 316 => 0x1010 },
	'imagefileconstraints' => { 400 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 400 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 400 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 103 => 0x1436 },
	'imageheight' => { 98 => 0x101, 157 => 0xc, 408 => 'ImageLength' },
	'imagehistory' => { 98 => 0x9213 },
	'imageidnumber' => { 257 => 0x340 },
	'imagenumber' => { 98 => 0x9211, 128 => 'ImageNumber', 151 => 0xae, 152 => 0x5e, 333 => 0x9b, 335 => [0x400,'276.1',0x314], 383 => 'ImageNumber' },
	'imagenumber2' => { 152 => 0x62 },
	'imageoptimization' => { 185 => 0xa9 },
	'imageorientation' => { 106 => 0x83 },
	'imageprocessing' => { 185 => 0x1a },
	'imageprocessingversion' => { 245 => 0x0 },
	'imagequality' => { 128 => 'ImageQuality', 198 => '723.2', 199 => '732.2', 207 => '708.1', 261 => 0x1 },
	'imagequality2' => { 241 => 0x603 },
	'imageref' => { 395 => 'ImageRef' },
	'imagereview' => { 230 => '0.4', 236 => '0.4' },
	'imagereviewmonitorofftime' => { 229 => '21.1', 238 => '21.1' },
	'imagereviewtime' => { 228 => '25.1', 230 => '2.1', 231 => '19.1', 232 => '20.1', 233 => '20.1', 234 => '9.2', 235 => '20.1', 239 => '21.2' },
	'imagesize' => { 134 => 'ImageSize' },
	'imagesizerestriction' => { 405 => 'imageSizeRestriction' },
	'imagesourcedata' => { 98 => 0x935c },
	'imagestabilization' => { 30 => 0x22, 94 => 0x3020, 103 => 0x1422, 128 => 'ImageStabilization', 151 => 0xbd, 152 => 0x71, 153 => 0x57, 154 => 0x0, 155 => [0x18,0x107,0x113], 156 => 0x49c2, 185 => 0xac, 241 => 0x604, 244 => 0x1600, 261 => 0x1a, 338 => 0x12, 339 => 0x11, 345 => 0xb026 },
	'imagestabilization2' => { 337 => 0xa },
	'imagestabilizationsetting' => { 156 => 0x14, 333 => 0x3d, 334 => 0x3d, 344 => 0x14 },
	'imagestyle' => { 333 => 0x2d, 334 => 0x27 },
	'imagesupplier' => { 400 => 'ImageSupplier' },
	'imagesupplierid' => { 400 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 400 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 400 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 100 => 0x1 },
	'imagetemperaturemin' => { 100 => 0x2 },
	'imagetone' => { 294 => 0x4f },
	'imagetype' => { 106 => 0x82, 400 => 'ImageType' },
	'imageuniqueid' => { 53 => 0x28, 98 => 0xa420, 391 => 'ImageUniqueID' },
	'imagewidth' => { 98 => 0x100, 157 => 0xe, 408 => 'ImageWidth' },
	'incrementaltemperature' => { 387 => 'IncrementalTemperature' },
	'incrementaltint' => { 387 => 'IncrementalTint' },
	'industry' => { 402 => 'industry', 403 => 'industry' },
	'infobuttonwhenshooting' => { 71 => 0x409 },
	'infraredilluminator' => { 312 => 0x28 },
	'ingredientexclusion' => { 404 => 'ingredientExclusion' },
	'ingredients' => { 413 => 'Ingredients' },
	'ingredientsalternatepaths' => { 413 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 413 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 413 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 413 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 413 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 413 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 413 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 413 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 413 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 413 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 413 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 413 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 413 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 413 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 413 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 413 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 413 => [\'Ingredients','IngredientsVersionID'] },
	'initialhorizontalfovdegrees' => { 376 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 376 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 376 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 376 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 228 => '4.4' },
	'initialzoomsetting' => { 228 => '9.3', 234 => '27.3' },
	'inkset' => { 98 => 0x14c },
	'inputprofile' => { 112 => 0x1389 },
	'instanceid' => { 413 => 'InstanceID' },
	'instantplaybacksetup' => { 153 => 0x3e },
	'instantplaybacktime' => { 153 => 0x3d },
	'instructions' => { 399 => 'Instructions' },
	'instrument' => { 412 => 'instrument' },
	'intellectualgenre' => { 396 => 'IntellectualGenre' },
	'intelligentauto' => { 345 => 0xb052 },
	'intelligentcontrast' => { 42 => 0x4 },
	'intelligentd-range' => { 261 => 0x79 },
	'intelligentexposure' => { 261 => 0x5d },
	'intelligentresolution' => { 261 => 0x70 },
	'interchangecolorspace' => { 108 => 0x40 },
	'internalflash' => { 150 => 0x2b, 228 => '23.1', 230 => '8.1', 231 => '22.1', 233 => '23.1', 236 => '8.1', 239 => '24.1', 244 => 0x1208 },
	'internalflashae1' => { 246 => 0x1021 },
	'internalflashae1_0' => { 246 => 0x101d },
	'internalflashae2' => { 246 => 0x1022 },
	'internalflashae2_0' => { 246 => 0x101e },
	'internalflashmode' => { 282 => 0x1 },
	'internalflashstrength' => { 282 => 0x3 },
	'internalflashtable' => { 246 => 0x1024 },
	'internallensserialnumber' => { 322 => 0xa005 },
	'internalndfilter' => { 261 => 0x9d },
	'internalserialnumber' => { 53 => 0x96, 64 => 0x9, 103 => 0x10, 156 => 0x49dc, 240 => 0x18, 242 => 0x102, 261 => 0x25, 274 => 0x4, 316 => 0x5, 359 => [0x7c,0xf0] },
	'interopindex' => { 98 => 0x1, 392 => 'InteroperabilityIndex' },
	'interopversion' => { 98 => 0x2 },
	'intervallength' => { 150 => 0x10 },
	'intervalmode' => { 150 => 0x26 },
	'intervalnumber' => { 150 => 0x11 },
	'introtime' => { 412 => 'introTime' },
	'introtimescale' => { 412 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 412 => [\'introTime','introTimeValue'] },
	'iptc' => { 99 => 'IPTC' },
	'iptc-naa' => { 98 => 0x83bb, 265 => 0x83bb },
	'iptcbitspersample' => { 108 => 0x56 },
	'iptcdigest' => { 305 => 0x425 },
	'iptcimageheight' => { 108 => 0x1e },
	'iptcimagerotation' => { 108 => 0x66 },
	'iptcimagewidth' => { 108 => 0x14 },
	'iptclastedited' => { 397 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 108 => 0xa },
	'iptcpixelheight' => { 108 => 0x32 },
	'iptcpixelwidth' => { 108 => 0x28 },
	'isalternativeof' => { 402 => 'isAlternativeOf' },
	'isbn' => { 402 => 'isbn' },
	'iscorrectionof' => { 402 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 90 => 0x3 },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x0, 28 => 0x1, 93 => 0x14, 94 => [0x3014,0x14], 98 => 0x8827, 111 => 0xfd06, 112 => 0x1784, 114 => 0x60, 116 => [0xfa2e,0xfa46], 117 => [0x27,0x28], 118 => 0xf105, 121 => 0x14, 123 => 0x4e, 126 => 0x34, 128 => 'ISO', 150 => 0x8, 156 => 0x49ba, 179 => 0x0, 185 => 0x2, 265 => 0x17, 294 => [0x8b,0x14], 300 => 0x14, 322 => 0xa014, 344 => 0x6f, 349 => [0x1f,0x21,0x25], 391 => 'ISOSpeedRatings' },
	'iso2' => { 179 => 0x6, 193 => 0x265, 194 => 0x25c, 195 => 0x265, 196 => 0x221, 197 => 0x25d, 198 => 0x256, 199 => 0x25d, 202 => 0x2b5, 205 => 0x265, 210 => 0x2b5 },
	'isoauto' => { 275 => '14.4' },
	'isoautoparameters' => { 294 => 0x7a },
	'isodisplay' => { 231 => '2.3', 232 => '3.3', 233 => '3.3', 235 => '3.3', 238 => '4.3', 239 => '4.3' },
	'isoexpansion' => { 71 => 0x103, 72 => 0x7, 73 => 0x8, 76 => 0x8, 179 => 0x4 },
	'isoexpansion2' => { 179 => 0xa },
	'isofloor' => { 275 => 0x6 },
	'isoselection' => { 185 => 0xf },
	'isosensitivitystep' => { 235 => '6.2' },
	'isosetting' => { 114 => 0x5e, 128 => 'ISOSetting', 150 => 0x24, 151 => 0x26, 152 => 0x1c, 153 => 0x13, 158 => 0x6, 185 => 0x13, 275 => '17.3', 315 => 0x27, 333 => 0x16, 334 => 0x14, 335 => 0x2, 344 => 0x6d },
	'isospeed' => { 98 => 0x8833, 392 => 'ISOSpeed' },
	'isospeedexpansion' => { 70 => 0x3 },
	'isospeedincrements' => { 71 => 0x102 },
	'isospeedlatitudeyyy' => { 98 => 0x8834, 392 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 98 => 0x8835, 392 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 71 => 0x103 },
	'isostepsize' => { 228 => '6.1', 229 => '7.2', 234 => '4.1', 238 => '7.2' },
	'isovalue' => { 246 => 0x1001 },
	'issn' => { 402 => 'issn' },
	'issueidentifier' => { 402 => 'issueIdentifier' },
	'issuename' => { 402 => 'issueName' },
	'issueteaser' => { 402 => 'issueTeaser' },
	'issuetype' => { 402 => 'issueType' },
	'istranslationof' => { 402 => 'isTranslationOf' },
	'jobid' => { 106 => 0xb8 },
	'jobname' => { 393 => 'JobName' },
	'jobref' => { 411 => 'JobRef' },
	'jobrefid' => { 411 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 411 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 411 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 393 => 'JobStatus' },
	'jpegquality' => { 9 => 0x66, 263 => 0x3034, 345 => 0xb047 },
	'jpegsize' => { 263 => 0x303a },
	'jpgfromraw' => { 84 => 0x2007, 95 => 'JpgFromRaw', 265 => 0x2e },
	'jpgfromrawlength' => { 98 => [0x117,0x202] },
	'jpgfromrawstart' => { 98 => [0x111,0x201] },
	'jpgrecordedpixels' => { 275 => '14.1' },
	'jurisdiction' => { 384 => 'jurisdiction' },
	'kelvinwb_01' => { 283 => 0x5 },
	'kelvinwb_02' => { 283 => 0x9 },
	'kelvinwb_03' => { 283 => 0xd },
	'kelvinwb_04' => { 283 => 0x11 },
	'kelvinwb_05' => { 283 => 0x15 },
	'kelvinwb_06' => { 283 => 0x19 },
	'kelvinwb_07' => { 283 => 0x1d },
	'kelvinwb_08' => { 283 => 0x21 },
	'kelvinwb_09' => { 283 => 0x25 },
	'kelvinwb_10' => { 283 => 0x29 },
	'kelvinwb_11' => { 283 => 0x2d },
	'kelvinwb_12' => { 283 => 0x31 },
	'kelvinwb_13' => { 283 => 0x35 },
	'kelvinwb_14' => { 283 => 0x39 },
	'kelvinwb_15' => { 283 => 0x3d },
	'kelvinwb_16' => { 283 => 0x41 },
	'kelvinwb_daylight' => { 283 => 0x1 },
	'key' => { 412 => 'key' },
	'keyword' => { 402 => 'keyword' },
	'keywordinfo' => { 143 => 'Keywords' },
	'keywords' => { 106 => 0x19, 129 => 'Keywords', 250 => 'Keywords', 307 => 'Keywords', 381 => 'keywords', 398 => 'Keywords', 410 => 'Keywords' },
	'killdate' => { 402 => 'killDate' },
	'killdatea-platform' => { 402 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 402 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 111 => 0xf908, 114 => 0xe, 116 => [0xfa1e,0xfa52], 122 => 0x70 },
	'kodakimagewidth' => { 111 => 0xf907, 114 => 0xc, 116 => [0xfa1d,0xfa51], 122 => 0x6c },
	'kodakinfotype' => { 111 => 0xfa00 },
	'kodaklook' => { 112 => 0xe4c },
	'kodaklookprofile' => { 112 => 0x138a },
	'kodakmaker' => { 122 => 0x8 },
	'kodakmodel' => { 114 => 0x0, 122 => 0x28 },
	'label' => { 253 => 'Label', 410 => 'Label' },
	'labelname1' => { 395 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 395 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 395 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 395 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 395 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 395 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 261 => 0x6f },
	'landscapeoutputhighlightpoint' => { 90 => 0x26 },
	'landscapeoutputshadowpoint' => { 90 => 0x27 },
	'landscaperawcolortone' => { 90 => 0x1f },
	'landscaperawcontrast' => { 90 => 0x21 },
	'landscaperawhighlight' => { 90 => 0x77 },
	'landscaperawhighlightpoint' => { 90 => 0x24 },
	'landscaperawlinear' => { 90 => 0x22 },
	'landscaperawsaturation' => { 90 => 0x20 },
	'landscaperawshadow' => { 90 => 0x80 },
	'landscaperawshadowpoint' => { 90 => 0x25 },
	'landscaperawsharpness' => { 90 => 0x23 },
	'landscapeunsharpmaskfineness' => { 90 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 90 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 90 => 0xa2 },
	'language' => { 388 => 'language' },
	'languageidentifier' => { 106 => 0x87 },
	'largestvalidinteriorrectheight' => { 376 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 376 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 376 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 376 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 150 => 0x1b },
	'lastkeywordiptc' => { 148 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 148 => 'LastKeywordXMP' },
	'lastphotodate' => { 376 => 'LastPhotoDate' },
	'lasturl' => { 413 => 'LastURL' },
	'lateralchromaticaberration' => { 345 => 0x2012 },
	'latestageorhigheststage' => { 97 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 97 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 97 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 97 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 97 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 285 => 0x2 },
	'lc10' => { 285 => 0xb },
	'lc11' => { 285 => 0xc },
	'lc12' => { 285 => 0xd },
	'lc14' => { 285 => 0xf },
	'lc15' => { 285 => 0x10 },
	'lc3' => { 285 => 0x4 },
	'lc4' => { 285 => 0x5 },
	'lc5' => { 285 => 0x6 },
	'lc6' => { 285 => 0x7 },
	'lc7' => { 285 => 0x8 },
	'lcddisplayatpoweron' => { 71 => 0x811, 75 => 0xa },
	'lcddisplayreturntoshoot' => { 76 => 0x12 },
	'lcdillumination' => { 228 => '17.5', 229 => '5.2', 234 => '10.3', 235 => '4.2', 238 => '5.2', 239 => '5.4' },
	'lcdilluminationduringbulb' => { 71 => 0x408 },
	'lcdpanels' => { 70 => 0x8 },
	'lcheditor' => { 221 => 0x8ae85e },
	'legacyiptcdigest' => { 399 => 'LegacyIPTCDigest' },
	'legalcode' => { 384 => 'legalcode' },
	'lens' => { 98 => 0xfdea, 185 => 0x84, 383 => 'Lens' },
	'lensafstopbutton' => { 69 => 0x11, 70 => 0x13, 71 => 0x506, 72 => 0x10, 73 => 0x12, 76 => 0x13, 77 => 0x9 },
	'lensaperturerange' => { 325 => [0x30,0x48] },
	'lensdistortionparams' => { 246 => 0x206 },
	'lensdrivenoaf' => { 71 => 0x505 },
	'lensfirmware' => { 317 => 0x20, 322 => 0xa004 },
	'lensfirmwareversion' => { 242 => 0x204, 261 => 0x60 },
	'lensfocalrange' => { 325 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 229 => '55.1', 238 => '52.1' },
	'lensformat' => { 356 => 0x1891, 358 => 0x18bd, 359 => 0x106, 367 => 0x603, 368 => 0x5d },
	'lensfstops' => { 180 => 0x7, 181 => 0xc, 182 => 0xd, 185 => 0x8b, 285 => '0.3' },
	'lensid' => { 383 => 'LensID' },
	'lensidnumber' => { 180 => 0x6, 181 => 0xb, 182 => 0xc },
	'lensinfo' => { 98 => 0xa432, 291 => 0x2a, 383 => 'LensInfo', 392 => 'LensSpecification' },
	'lenskind' => { 285 => 0x1 },
	'lensmake' => { 98 => 0xa433, 135 => 'Make', 392 => 'LensMake' },
	'lensmanualdistortionamount' => { 387 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 148 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 325 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 53 => 0x95, 98 => 0xa434, 135 => 'Model', 148 => 'LensModel', 183 => 0x18a, 242 => 0x203, 259 => 0x303, 291 => 0xc, 392 => 'LensModel' },
	'lensmount' => { 335 => 0x99, 356 => 0x1892, 358 => 0x18be, 359 => 0x105, 367 => 0x604, 368 => 0x5e, 371 => 0x8 },
	'lensparameters' => { 353 => 0x1a23, 356 => 0x1870, 358 => 0x189c, 367 => 0x6ca, 368 => 0x64 },
	'lensprofilechromaticaberrationscale' => { 387 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 387 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 387 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 387 => 'LensProfileEnable' },
	'lensprofilefilename' => { 387 => 'LensProfileFilename' },
	'lensprofilename' => { 387 => 'LensProfileName' },
	'lensprofilesetup' => { 387 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 387 => 'LensProfileVignettingScale' },
	'lensproperties' => { 242 => 0x20b },
	'lensserialnumber' => { 51 => 0x0, 98 => 0xa435, 135 => 'SerialNumber', 242 => 0x202, 261 => 0x52, 317 => 0x30, 383 => 'LensSerialNumber', 392 => 'LensSerialNumber' },
	'lensshutterlock' => { 153 => 0x4a },
	'lensspec' => { 330 => 0x0, 331 => 0x0, 332 => 0x0, 345 => 0xb02a },
	'lensspecfeatures' => { 359 => [0x115,0x116] },
	'lenstemperature' => { 246 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x112, 30 => 0x16, 155 => 0x10c, 156 => 0x49bd, 185 => 0x83, 242 => 0x201, 254 => 0x16, 257 => 0x310, 260 => 0x303, 261 => 0x51, 263 => 0x3405, 286 => 0x0, 287 => 0x0, 288 => 0x1, 289 => 0x1, 290 => 0x1, 292 => 0x0, 322 => 0xa003, 325 => 0x27, 345 => 0xb027, 356 => 0x1896, 358 => 0x18c2, 359 => 0x109, 367 => 0x608, 368 => 0x62 },
	'lenstype2' => { 335 => 0x3f7, 356 => 0x1893, 358 => 0x18bf, 359 => 0x107, 367 => 0x605, 368 => 0x60, 371 => 0x9 },
	'lenszoomposition' => { 365 => 0x19, 366 => 0x1e, 368 => 0x342 },
	'levelindicator' => { 268 => 0x15 },
	'levelorientation' => { 293 => 0x0 },
	'license' => { 384 => 'license' },
	'licensee' => { 400 => 'Licensee' },
	'licenseeid' => { 400 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 400 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 400 => 'LicenseeImageNotes' },
	'licenseename' => { 400 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 400 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 400 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 400 => 'LicenseeTransactionID' },
	'licenseid' => { 400 => 'LicenseID' },
	'licensestartdate' => { 400 => 'LicenseStartDate' },
	'licensetransactiondate' => { 400 => 'LicenseTransactionDate' },
	'licensetype' => { 389 => 'licensetype' },
	'licensor' => { 400 => 'Licensor' },
	'licensorcity' => { 400 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 400 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 400 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 400 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 400 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 400 => 'LicensorImageID' },
	'licensorname' => { 400 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 400 => 'LicensorNotes' },
	'licensorpostalcode' => { 400 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 400 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 400 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 400 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 400 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 400 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 400 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 400 => 'LicensorTransactionID' },
	'licensorurl' => { 400 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 246 => 0x1009 },
	'lightingmode' => { 94 => 0x302a },
	'lightreading' => { 294 => 0x15 },
	'lightsource' => { 98 => 0x9208, 185 => 0x90, 249 => 0x1000, 391 => 'LightSource' },
	'lightsourcespecial' => { 324 => 0x21d },
	'lightswitch' => { 238 => '0.1', 239 => '0.1' },
	'lightvaluecenter' => { 246 => 0x103d },
	'lightvalueperiphery' => { 246 => 0x103e },
	'limitafareamodeselection' => { 229 => '51.1', 238 => '49.1' },
	'linearitylimitblue' => { 265 => 0x10 },
	'linearitylimitgreen' => { 265 => 0xf },
	'linearitylimitred' => { 265 => 0xe },
	'linearityuppermargin' => { 37 => [0x2ba,0x2d1,0x2d5], 39 => 0x1e5, 40 => [0x1fe,0x2de] },
	'linearizationtable' => { 98 => 0xc618 },
	'linearresponselimit' => { 98 => 0xc62e },
	'link' => { 402 => 'link' },
	'linkaetoafpoint' => { 275 => '14.2' },
	'linkedencodedrightsexpr' => { 397 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 397 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 397 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 397 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 97 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 231 => '32.1', 239 => '34.1' },
	'liveviewafareamode' => { 235 => '34.1' },
	'liveviewafmethod' => { 349 => 0x20 },
	'liveviewafmode' => { 235 => '34.2' },
	'liveviewafsetting' => { 335 => 0x36 },
	'liveviewbuttonoptions' => { 229 => '50.2', 238 => '48.2' },
	'liveviewexposuresimulation' => { 71 => 0x810 },
	'liveviewfocusmode' => { 335 => [0x8b,0x28b] },
	'liveviewmetering' => { 335 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 229 => '21.2', 232 => '20.2', 233 => '20.2', 235 => '20.2', 238 => '21.2' },
	'liveviewshooting' => { 47 => 0x13 },
	'localcaption' => { 106 => 0x79 },
	'localizedcameramodel' => { 98 => 0xc615 },
	'locallocationname' => { 322 => 0x30 },
	'location' => { 184 => 0x9, 261 => 0x67, 379 => 'Location', 396 => 'Location', 401 => 'location', 402 => 'location' },
	'locationareacode' => { 385 => 'lac' },
	'locationcreated' => { 397 => 'LocationCreated' },
	'locationcreatedcity' => { 397 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 397 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 397 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedlocationid' => { 397 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedprovincestate' => { 397 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 397 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 397 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 184 => 0x0 },
	'locationname' => { 322 => 0x31 },
	'locationshown' => { 397 => 'LocationShown' },
	'locationshowncity' => { 397 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 397 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 397 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownlocationid' => { 397 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownprovincestate' => { 397 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 397 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 397 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 71 => 0x709 },
	'logcomment' => { 412 => 'logComment' },
	'longexposurenoisereduction' => { 52 => 0x4, 71 => 0x201, 72 => 0x1, 73 => 0x2, 74 => 0x1, 75 => 0x1, 76 => 0x2, 77 => 0x1, 261 => 0x49, 333 => 0x2b, 334 => 0x25, 335 => 0x25, 345 => 0x2008, 349 => 0x11, 368 => 0x44 },
	'longexposurenoisereduction2' => { 47 => 0x8 },
	'loop' => { 412 => 'loop' },
	'lowestbiostratigraphiczone' => { 97 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 387 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 387 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 387 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 387 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 387 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 387 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 387 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 387 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 89 => 0x150 },
	'luminancecurvepoints' => { 89 => 0x126 },
	'luminancenoisereduction' => { 90 => 0x5f, 325 => 0x1b },
	'luminancenoisereductioncontrast' => { 387 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 387 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 90 => 0x6d },
	'luminancesmoothing' => { 387 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 71 => 0x40b },
	'lyrics' => { 412 => 'lyrics' },
	'm16cversion' => { 257 => 0x333 },
	'macatom' => { 386 => 'macAtom' },
	'macatomapplicationcode' => { 386 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 386 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 386 => [\'macAtom','macAtomPosixProjectPath'] },
	'macro' => { 103 => 0x1020, 104 => 0x202, 246 => 0x202, 315 => 0x21, 324 => 0x202, 345 => 0xb040 },
	'macroled' => { 244 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 47 => 0x10 },
	'macromode' => { 30 => 0x1, 150 => 0xb, 241 => 0x300, 261 => 0x1c, 316 => 0x1009 },
	'magicfilter' => { 241 => 0x52c },
	'magnifiedview' => { 73 => 0x11, 75 => 0x9 },
	'maindialexposurecomp' => { 236 => '0.6' },
	'mainingredient' => { 404 => 'mainIngredient' },
	'make' => { 85 => 0x0, 98 => 0x10f, 128 => 'Make', 253 => 'Make', 265 => 0x10f, 401 => 'make', 408 => 'Make' },
	'makernote' => { 391 => 'MakerNote' },
	'makernoteapple' => { 96 => 'MakN', 98 => 0x927c },
	'makernotecanon' => { 96 => 'MakN', 98 => 0x927c },
	'makernotecasio' => { 96 => 'MakN', 98 => 0x927c },
	'makernotecasio2' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteflir' => { 96 => 'MakN', 98 => 0x927c },
	'makernotefujifilm' => { 96 => 'MakN', 98 => 0x927c },
	'makernotege' => { 96 => 'MakN', 98 => 0x927c },
	'makernotege2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotehasselblad' => { 96 => 'MakN', 98 => 0x927c },
	'makernotehp' => { 96 => 'MakN', 98 => 0x927c },
	'makernotehp2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotehp4' => { 96 => 'MakN', 98 => 0x927c },
	'makernotehp6' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteisl' => { 96 => 'MakN', 98 => 0x927c },
	'makernotejvc' => { 96 => 'MakN', 98 => 0x927c },
	'makernotejvctext' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak10' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak11' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak1a' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak1b' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak3' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak4' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak5' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak6a' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak6b' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak7' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak8a' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak8b' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak8c' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak9' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodakunknown' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekyocera' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteleica' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteleica2' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteleica3' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteleica4' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteleica5' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteleica6' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteminolta' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteminolta2' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteminolta3' => { 96 => 'MakN', 98 => 0x927c },
	'makernotenikon' => { 96 => 'MakN', 98 => 0x927c },
	'makernotenikon2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotenikon3' => { 96 => 'MakN', 98 => 0x927c },
	'makernotenintendo' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteoffset' => { 324 => 0xff },
	'makernoteolympus' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteolympus2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotepanasonic' => { 96 => 'MakN', 98 => 0x927c },
	'makernotepanasonic2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotepentax' => { 96 => 'MakN', 98 => 0x927c },
	'makernotepentax2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotepentax3' => { 96 => 'MakN', 98 => 0x927c },
	'makernotepentax4' => { 96 => 'MakN', 98 => 0x927c },
	'makernotepentax5' => { 96 => 'MakN', 98 => 0x927c },
	'makernotepentax6' => { 96 => 'MakN', 98 => 0x927c },
	'makernotephaseone' => { 96 => 'MakN', 98 => 0x927c },
	'makernotereconyx' => { 96 => 'MakN', 98 => 0x927c },
	'makernotericoh' => { 96 => 'MakN', 98 => 0x927c },
	'makernotericoh2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotericohtext' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesafety' => { 98 => 0xc635 },
	'makernotesamsung1a' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesamsung1b' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesamsung2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesanyo' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesanyoc4' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesanyopatch' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesigma' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesony' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesony2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesony3' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesony4' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesony5' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesonyericsson' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesonysrf' => { 96 => 'MakN', 98 => 0x927c },
	'makernotetype' => { 316 => 0x1 },
	'makernoteunknown' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteunknownbinary' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteunknowntext' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteversion' => { 155 => 0x0, 185 => 0x1, 246 => 0x0, 261 => 0x8000, 320 => 0x0, 322 => 0x1, 325 => [0x1d,0x1f], 336 => 0x2000 },
	'managedfrom' => { 413 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 413 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 413 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 413 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 413 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 413 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 413 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 413 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 413 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 413 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 413 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 413 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 413 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 413 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 413 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 413 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 413 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 413 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 413 => 'Manager' },
	'managervariant' => { 413 => 'ManagerVariant' },
	'manageto' => { 413 => 'ManageTo' },
	'manageui' => { 413 => 'ManageUI' },
	'manifest' => { 413 => 'Manifest' },
	'manifestlinkform' => { 413 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 413 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 413 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 413 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 413 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 413 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 413 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 413 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 413 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 413 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 413 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 413 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 413 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 413 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 413 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 413 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 413 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 413 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 413 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 413 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 413 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 413 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 241 => 0x900, 261 => 0x86 },
	'manometerreading' => { 241 => 0x901 },
	'manualafpointselectpattern' => { 71 => 0x513 },
	'manualflash' => { 244 => 0x1209 },
	'manualflashoutput' => { 30 => 0x29, 230 => '8.2', 231 => '22.2', 232 => '23.1', 233 => '23.2', 234 => '16.2', 235 => '23.2', 236 => '8.2', 237 => '23.2', 239 => '24.2', 316 => 0x100c },
	'manualflashstrength' => { 241 => 0x406 },
	'manualfocusdistance' => { 185 => 0x85, 246 => 0x100c, 324 => 0x223 },
	'manualtv' => { 70 => 0x5, 71 => 0x705 },
	'manufacturedate' => { 274 => 0x1 },
	'manufacturedate1' => { 318 => 0x4 },
	'manufacturedate2' => { 318 => 0x5 },
	'manufacturer' => { 401 => 'manufacturer' },
	'marked' => { 398 => 'Marked', 416 => 'Marked' },
	'markers' => { 412 => 'markers' },
	'markerscomment' => { 412 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 412 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 412 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 412 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 412 => [\'markers','markersCuePointType'] },
	'markersduration' => { 412 => [\'markers','markersDuration'] },
	'markerslocation' => { 412 => [\'markers','markersLocation'] },
	'markersname' => { 412 => [\'markers','markersName'] },
	'markersprobability' => { 412 => [\'markers','markersProbability'] },
	'markersspeaker' => { 412 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 412 => [\'markers','markersStartTime'] },
	'markerstarget' => { 412 => [\'markers','markersTarget'] },
	'markerstype' => { 412 => [\'markers','markersType'] },
	'maskedareas' => { 98 => 0xc68e },
	'masterdocumentid' => { 106 => 0xb9 },
	'mastergain' => { 191 => 0x50 },
	'matrixmetering' => { 229 => '50.1', 238 => '48.1' },
	'maxaperture' => { 30 => 0x1a, 118 => 0x6103, 135 => 'MaxAperture', 150 => 0x17, 156 => 0x49c5, 242 => 0x20a, 285 => '14.1', 359 => 0x0 },
	'maxapertureatmaxfocal' => { 103 => 0x1407, 135 => 'MaxApertureAtMaxFocal', 180 => 0xb, 181 => 0x10, 182 => 0x11, 242 => 0x206 },
	'maxapertureatminfocal' => { 103 => 0x1406, 180 => 0xa, 181 => 0xf, 182 => 0x10, 242 => 0x205 },
	'maxaperturevalue' => { 98 => 0x9205, 391 => 'MaxApertureValue' },
	'maxavailheight' => { 397 => 'MaxAvailHeight' },
	'maxavailwidth' => { 397 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 228 => 0xb, 229 => 0xc, 234 => 0xc, 235 => 0xb, 238 => '12.1' },
	'maxfaces' => { 245 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x116, 30 => 0x17, 103 => 0x1405, 135 => 'MaxFocalLength', 180 => 0x9, 181 => 0xe, 182 => 0xf, 242 => 0x208, 356 => 0x127c, 357 => 0x1138, 358 => 0x330 },
	'maximumdensityrange' => { 108 => 0x8c },
	'maxpagesize' => { 417 => 'MaxPageSize' },
	'maxpagesizeh' => { 417 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 417 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 417 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 98 => 0x119 },
	'maxstorage' => { 407 => 'maxstorage' },
	'mb-d10batteries' => { 228 => '12.6' },
	'mb-d10batterytype' => { 234 => '13.3' },
	'mb-d11batterytype' => { 235 => '2.3' },
	'mb-d12batterytype' => { 238 => '3.2' },
	'mb-d80batteries' => { 236 => '6.5' },
	'mb-d80batterytype' => { 239 => '3.2' },
	'mcuversion' => { 180 => 0xc, 181 => 0x11, 182 => 0x12 },
	'md5digest' => { 136 => 'zmd5' },
	'meal' => { 404 => 'meal' },
	'measuredev' => { 26 => 0x9, 65 => 0x3, 84 => 0x1814, 128 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 26 => 0x8, 65 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 156 => 0x690, 257 => 0x312, 263 => 0x3407 },
	'measuredrggb' => { 54 => 0x1 },
	'measuredrggbdata' => { 36 => 0x287 },
	'measurementaccuracy' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 97 => 'MeasurementOrFact' },
	'measurementremarks' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 400 => 'MediaConstraints' },
	'mediacreatedate' => { 308 => 0x1 },
	'mediamodifydate' => { 308 => 0x2 },
	'mediasummarycode' => { 400 => 'MediaSummaryCode' },
	'memoaudioquality' => { 71 => 0x812 },
	'memorycardconfiguration' => { 339 => 0x16 },
	'menubuttondisplayposition' => { 69 => 0xb, 72 => 0xa, 73 => 0xb, 76 => 0xb },
	'menubuttonreturn' => { 77 => 0xb },
	'menumonitorofftime' => { 228 => '26.1', 229 => '22.1', 234 => '8.2', 235 => '21.1', 238 => '22.1', 239 => '22.1' },
	'metadatadate' => { 410 => 'MetadataDate' },
	'metadatamoddate' => { 412 => 'metadataModDate' },
	'metaversion' => { 351 => 0x34 },
	'meterinfo1row1' => { 346 => 0x0 },
	'meterinfo1row2' => { 346 => 0x6c },
	'meterinfo1row3' => { 346 => 0xd8 },
	'meterinfo1row4' => { 346 => 0x144 },
	'meterinfo1row5' => { 346 => 0x1b0 },
	'meterinfo1row6' => { 346 => 0x21c },
	'meterinfo1row7' => { 346 => 0x288 },
	'meterinfo2row1' => { 346 => 0x2f4 },
	'meterinfo2row2' => { 346 => 0x378 },
	'meterinfo2row3' => { 346 => 0x3fc },
	'meterinfo2row4' => { 346 => 0x480 },
	'meterinfo2row5' => { 346 => 0x504 },
	'meterinfo2row6' => { 346 => 0x588 },
	'meterinfo2row7' => { 346 => 0x60c },
	'meterinfo2row8' => { 346 => 0x690 },
	'meterinfo2row9' => { 346 => 0x714 },
	'metering' => { 230 => '6.1' },
	'meteringmode' => { 30 => 0x11, 98 => 0x9207, 114 => 0x1c, 150 => 0x7, 151 => 0x25, 153 => 0x12, 241 => 0x202, 294 => 0x17, 325 => 0x9, 333 => 0x15, 334 => 0x13, 335 => 0x7, 349 => 0x3, 352 => 0x1174, 353 => 0x1178, 354 => 0x1154, 355 => 0x11d0, 356 => 0x11ac, 357 => 0x1064, 358 => 0x25c, 391 => 'MeteringMode' },
	'meteringmode2' => { 275 => '2.1' },
	'meteringmode3' => { 275 => '16.1' },
	'meteringoffscaleindicator' => { 153 => 0x53 },
	'meteringtime' => { 228 => '22.2', 230 => '3.2', 231 => '17.1', 232 => '18.1', 234 => '7.3', 235 => '18.1', 236 => '3.2', 239 => '19.1' },
	'mieversion' => { 136 => '0Vers' },
	'minaperture' => { 30 => 0x1b, 135 => 'MinAperture', 285 => '0.2', 359 => 0x1 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x114, 30 => 0x18, 103 => 0x1404, 135 => 'MinFocalLength', 180 => 0x8, 181 => 0xd, 182 => 0xe, 242 => 0x207, 356 => 0x127a, 357 => 0x1136, 358 => 0x32e },
	'minfocusdistance' => { 285 => 0x3 },
	'minoltadate' => { 150 => 0x15 },
	'minoltaimagesize' => { 150 => 0x4, 151 => 0xc, 152 => 0x2, 155 => 0x103 },
	'minoltamodelid' => { 150 => 0x25 },
	'minoltaquality' => { 150 => 0x5, 151 => 0xd, 152 => 0x3, 155 => [0x102,0x103] },
	'minoltatime' => { 150 => 0x16 },
	'minormodelagedisclosure' => { 400 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 98 => 0x118 },
	'mirrorlockup' => { 69 => 0xc, 70 => 0xc, 71 => 0x60f, 72 => 0xb, 73 => 0xc, 74 => 0x6, 75 => 0x6, 76 => 0xc, 77 => 0x3 },
	'mobilecountrycode' => { 385 => 'mcc' },
	'mobilenetworkcode' => { 385 => 'mnc' },
	'moddate' => { 253 => 'modify-date', 398 => 'ModDate' },
	'modedialposition' => { 339 => 0x14 },
	'model' => { 85 => 0x6, 98 => 0x110, 128 => 'Model', 253 => 'Model', 265 => 0x110, 401 => 'model', 408 => 'Model' },
	'modelage' => { 397 => 'ModelAge' },
	'modelid' => { 240 => 0x0 },
	'modelingflash' => { 228 => '21.4', 229 => '31.1', 234 => '26.4', 235 => '30.2', 236 => '7.4', 237 => '30.1', 238 => '31.1', 239 => '31.3' },
	'modelreleaseid' => { 400 => 'ModelReleaseID' },
	'modelreleasestatus' => { 400 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 360 => 0x52, 361 => 0x46 },
	'modelyear' => { 401 => 'modelYear' },
	'modificationdate' => { 402 => 'modificationDate' },
	'modifiedcolortemp' => { 55 => 0x9 },
	'modifieddigitalgain' => { 55 => 0xb },
	'modifiedparamflag' => { 48 => 0x1 },
	'modifiedpicturestyle' => { 55 => 0xa },
	'modifiedsaturation' => { 241 => 0x504 },
	'modifiedsensorbluelevel' => { 55 => 0x5 },
	'modifiedsensorredlevel' => { 55 => 0x4 },
	'modifiedsharpness' => { 55 => 0x2 },
	'modifiedsharpnessfreq' => { 55 => 0x3 },
	'modifiedtonecurve' => { 55 => 0x1 },
	'modifiedwhitebalance' => { 55 => 0x8 },
	'modifiedwhitebalanceblue' => { 55 => 0x7 },
	'modifiedwhitebalancered' => { 55 => 0x6 },
	'modifydate' => { 98 => 0x132, 129 => 'ModifyDate', 250 => 'ModDate', 251 => 'tIME', 307 => 'ModDate', 309 => 0x2, 410 => 'ModifyDate' },
	'moirefilter' => { 98 => 0xfe58, 387 => 'MoireFilter' },
	'monitordisplayoff' => { 153 => 0x4c },
	'monitorofftime' => { 228 => '18.2', 230 => '3.1', 236 => '3.1' },
	'monochromecontrast' => { 90 => 0x3c },
	'monochromefiltereffect' => { 90 => 0x3a, 294 => 0x73 },
	'monochromelinear' => { 90 => 0x3d },
	'monochromeoutputhighlightpoint' => { 90 => 0x41 },
	'monochromeoutputshadowpoint' => { 90 => 0x42 },
	'monochromerawhighlight' => { 90 => 0x7a },
	'monochromerawhighlightpoint' => { 90 => 0x3f },
	'monochromerawshadow' => { 90 => 0x83 },
	'monochromerawshadowpoint' => { 90 => 0x40 },
	'monochromesharpness' => { 90 => 0x3e },
	'monochrometoning' => { 294 => 0x74 },
	'monochrometoningeffect' => { 90 => 0x3b },
	'monochromeunsharpmaskfineness' => { 90 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 90 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 90 => 0xb4 },
	'monthdaycreated' => { 114 => 0x12, 123 => 0xe },
	'moonphase' => { 312 => 0x12 },
	'morepermissions' => { 384 => 'morePermissions' },
	'motionsensitivity' => { 312 => 0x29 },
	'movieaelockbuttonassignment' => { 238 => '40.1' },
	'moviefunctionbutton' => { 229 => '41.1', 238 => '41.1' },
	'moviefunctionbuttonplusdials' => { 229 => '52.1' },
	'moviepreviewbutton' => { 229 => '41.2', 238 => '41.2' },
	'moviepreviewbuttonplusdials' => { 229 => '52.2' },
	'movieshutterbutton' => { 229 => '38.3', 238 => '38.3' },
	'moviesubselectorassignment' => { 229 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 229 => '53.1' },
	'multiburstimageheight' => { 345 => 0x1002 },
	'multiburstimagewidth' => { 345 => 0x1001 },
	'multiburstmode' => { 345 => 0x1000 },
	'multicontrollerwhilemetering' => { 71 => 0x517 },
	'multiexposure' => { 57 => 0x1 },
	'multiexposureautogain' => { 186 => 0x3 },
	'multiexposurecontrol' => { 57 => 0x2 },
	'multiexposuremode' => { 186 => 0x1 },
	'multiexposureshots' => { 57 => 0x3, 186 => 0x2 },
	'multiframenoisereduction' => { 335 => 0x35, 345 => 0x200b, 349 => 0x15 },
	'multifunctionlock' => { 71 => 0x70f },
	'multipleexposuremode' => { 245 => 0x101c },
	'multipleexposureset' => { 275 => '10.1' },
	'multisample' => { 191 => 0x40 },
	'multiselector' => { 228 => '9.4', 229 => '10.3', 234 => '27.4', 238 => '10.3' },
	'multiselectorliveview' => { 228 => '4.3', 238 => '37.1' },
	'multiselectorliveviewmode' => { 201 => 0x18c2 },
	'multiselectorplaybackmode' => { 228 => ['13.5','9.2'], 229 => '10.2', 234 => '27.2', 238 => '10.2' },
	'multiselectorshootmode' => { 228 => '9.1', 229 => '10.1', 234 => '27.1', 238 => '10.1' },
	'mycolormode' => { 58 => 0x2 },
	'nationalcatalognumber' => { 402 => 'nationalCatalogNumber' },
	'nativedigest' => { 391 => 'NativeDigest', 408 => 'NativeDigest' },
	'ncdfileinfo' => { 112 => 0x414 },
	'ndfilter' => { 65 => 0x1c, 241 => 0x204, 316 => 0x1019 },
	'nefbitdepth' => { 185 => 0xe22 },
	'nefcompression' => { 185 => 0x93 },
	'neflinearizationtable' => { 185 => 0x96 },
	'neutraldensityfilter' => { 294 => 0x88 },
	'neutraloutputhighlightpoint' => { 90 => 0x2f },
	'neutraloutputshadowpoint' => { 90 => 0x30 },
	'neutralrawcolortone' => { 90 => 0x28 },
	'neutralrawcontrast' => { 90 => 0x2a },
	'neutralrawhighlight' => { 90 => 0x78 },
	'neutralrawhighlightpoint' => { 90 => 0x2d },
	'neutralrawlinear' => { 90 => 0x2b },
	'neutralrawsaturation' => { 90 => 0x29 },
	'neutralrawshadow' => { 90 => 0x81 },
	'neutralrawshadowpoint' => { 90 => 0x2e },
	'neutralrawsharpness' => { 90 => 0x2c },
	'neutralunsharpmaskfineness' => { 90 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 90 => 0xa8 },
	'neutraunsharpmaskstrength' => { 90 => 0xa4 },
	'newrawimagedigest' => { 98 => 0xc7a7 },
	'newsphotoversion' => { 108 => 0x0 },
	'nickname' => { 410 => 'Nickname' },
	'nikoncapturedata' => { 185 => 0xe01 },
	'nikoncaptureeditversions' => { 185 => 0xe13 },
	'nikoncaptureoutput' => { 185 => 0xe1e },
	'nikoncaptureversion' => { 185 => 0xe09 },
	'nikoniccprofile' => { 185 => 0xe1d },
	'nikonimagesize' => { 198 => '723.1', 199 => '732.1', 207 => 0x2c4 },
	'noisefilter' => { 241 => 0x527 },
	'noiseprofile' => { 98 => 0xc761 },
	'noisereduction' => { 103 => 0x100b, 151 => 0xb0, 152 => 0x60, 153 => 0x3f, 185 => 0x95, 221 => 0x753dcbc0, 222 => 0x17, 241 => 0x50a, 246 => 0x103a, 261 => 0x2d, 294 => 0x49, 316 => 0x100f, 318 => 0x2a },
	'noisereduction2' => { 245 => 0x1010 },
	'noisereductionapplied' => { 98 => 0xc6f7 },
	'noisereductionintensity' => { 222 => 0x9 },
	'noisereductionmethod' => { 222 => 0x11 },
	'noisereductionmode' => { 372 => 0x801e },
	'noisereductionsharpness' => { 222 => 0xd },
	'noisereductionvalue' => { 372 => 0x8027 },
	'nomemorycard' => { 228 => '22.1', 229 => '4.2', 230 => '0.3', 231 => '2.4', 232 => '3.2', 233 => '3.2', 234 => '33.7', 235 => '3.2', 236 => '0.3', 238 => '4.2', 239 => '4.5' },
	'nominalmaxaperture' => { 285 => 0xa },
	'nominalminaperture' => { 285 => '10.1' },
	'normalwhitelevel' => { 37 => [0x2b8,0x2cf,0x2d3], 39 => 0x1e3, 40 => [0x1fc,0x2dc] },
	'notes' => { 373 => 'Notes', 381 => 'notes' },
	'npages' => { 417 => 'NPages' },
	'nrwdata' => { 185 => 0x14 },
	'nullrecord' => { 84 => 0x0 },
	'number' => { 402 => 'number' },
	'numberofbeats' => { 412 => 'numberOfBeats' },
	'numberoffocuspoints' => { 233 => '0.2', 235 => '0.3' },
	'numfacepositions' => { 255 => 0x0 },
	'numindexentries' => { 108 => 0x54 },
	'numwbentries' => { 266 => 0x0, 267 => 0x0 },
	'object' => { 402 => 'object' },
	'objectattributereference' => { 106 => 0x4 },
	'objectcycle' => { 106 => 0x4b },
	'objectdescription' => { 401 => 'objectDescription' },
	'objectdistance' => { 93 => 0x6, 94 => 0x2022 },
	'objectname' => { 106 => 0x5 },
	'objectpreviewdata' => { 106 => 0xca },
	'objectpreviewfileformat' => { 106 => 0xc8 },
	'objectpreviewfileversion' => { 106 => 0xc9 },
	'objectsubtype' => { 401 => 'objectSubtype' },
	'objecttype' => { 401 => 'objectType' },
	'objecttypereference' => { 106 => 0x3 },
	'occurrence' => { 97 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 97 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 97 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 97 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 97 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 97 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 97 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 97 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 97 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 97 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 97 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 97 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 97 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 97 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 97 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 97 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 97 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 97 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 97 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 97 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 97 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 97 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 97 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 97 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 391 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 391 => [\'OECF','OECFNames'] },
	'oecfrows' => { 391 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 391 => [\'OECF','OECFValues'] },
	'offsaledate' => { 402 => 'offSaleDate' },
	'offsaledatea-platform' => { 402 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 402 => [\'offSaleDate','offSaleDateDate'] },
	'offsetschema' => { 98 => 0xea1d },
	'okbutton' => { 235 => '15.1', 239 => '16.1' },
	'oldsubfiletype' => { 98 => 0xff },
	'olympusimageheight' => { 246 => 0x102f },
	'olympusimagewidth' => { 246 => 0x102e },
	'onetouchwb' => { 246 => 0x302 },
	'onsaledate' => { 402 => 'onSaleDate' },
	'onsaledatea-platform' => { 402 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 402 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 402 => 'onSaleDay' },
	'onsaledaya-platform' => { 402 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 402 => [\'onSaleDay','onSaleDayDay'] },
	'opticalzoom' => { 116 => 0xfa3d, 118 => [0x6006,0xf006], 119 => 0x1000, 120 => 0xf, 123 => 0x1e, 135 => 'OpticalZoom' },
	'opticalzoomcode' => { 65 => 0xa },
	'opticalzoommode' => { 261 => 0x34 },
	'opticalzoomon' => { 324 => 0x219 },
	'optionenddate' => { 405 => 'optionEndDate' },
	'opto-electricconvfactor' => { 391 => 'OECF' },
	'ordernumber' => { 103 => 0x8002 },
	'organisationinimagecode' => { 397 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 397 => 'OrganisationInImageName' },
	'organization' => { 402 => 'organization' },
	'orientation' => { 98 => 0x112, 265 => 0x112, 401 => 'orientation', 408 => 'Orientation' },
	'orientation2' => { 349 => [0x28,0x2e] },
	'orientationlinkedafpoint' => { 71 => 0x516 },
	'originalbestqualitysize' => { 98 => 0xc792 },
	'originaldecisiondata' => { 95 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 53 => 0x83 },
	'originaldefaultcropsize' => { 98 => 0xc793 },
	'originaldefaultfinalsize' => { 98 => 0xc791 },
	'originaldirectory' => { 259 => 0x408 },
	'originaldocumentid' => { 413 => 'OriginalDocumentID' },
	'originalfilename' => { 84 => 0x816, 112 => 0x3e9, 124 => 0x20, 259 => 0x407, 377 => 'OriginalFilename' },
	'originalimageheight' => { 67 => 0xc, 102 => 0x1 },
	'originalimagewidth' => { 67 => 0xb, 102 => 0x0 },
	'originalrawfiledata' => { 98 => 0xc68c },
	'originalrawfiledigest' => { 98 => 0xc71d },
	'originalrawfilename' => { 98 => 0xc68b },
	'originaltransmissionreference' => { 106 => 0x67 },
	'originatingprogram' => { 106 => 0x41 },
	'originplatform' => { 402 => 'originPlatform' },
	'os' => { 389 => 'os' },
	'otherconditions' => { 400 => 'OtherConditions' },
	'otherconstraints' => { 400 => 'OtherConstraints' },
	'otherimage' => { 95 => 'OtherImage' },
	'otherimageinfo' => { 400 => 'OtherImageInfo' },
	'otherimagelength' => { 98 => 0x202 },
	'otherimagestart' => { 98 => 0x201 },
	'otherlicensedocuments' => { 400 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 400 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 400 => 'OtherLicenseRequirements' },
	'outcue' => { 412 => 'outCue' },
	'outcuescale' => { 412 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 412 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 164 => 0x3 },
	'outputimagewidth' => { 164 => 0x2 },
	'outputprofile' => { 112 => 0x138b },
	'outputresolution' => { 164 => 0x4 },
	'owner' => { 416 => 'Owner' },
	'ownerid' => { 106 => 0xbc },
	'ownername' => { 14 => 0x10f, 53 => 0x9, 84 => 0x810, 98 => [0xa430,0xfde8], 128 => 'OwnerName', 383 => 'OwnerName', 392 => 'CameraOwnerName' },
	'padding' => { 98 => 0xea1c },
	'pagecount' => { 402 => 'pageCount' },
	'pageimage' => { 410 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 410 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 410 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 410 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 410 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 410 => 'PageInfo' },
	'pagename' => { 98 => 0x11d },
	'pagenumber' => { 98 => 0x129 },
	'pageprogressiondirection' => { 402 => 'pageProgressionDirection' },
	'pagerange' => { 402 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 387 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 387 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 261 => 0x26 },
	'panasonicimageheight' => { 261 => 0x4c },
	'panasonicimagewidth' => { 261 => 0x4b },
	'panasonicrawversion' => { 265 => 0x1 },
	'panasonictitle' => { 98 => 0xc6d2 },
	'panasonictitle2' => { 98 => 0xc6d3 },
	'panoramacropbottom' => { 350 => 0x7 },
	'panoramacropleft' => { 350 => 0x4 },
	'panoramacropright' => { 350 => 0x6 },
	'panoramacroptop' => { 350 => 0x5 },
	'panoramadirection' => { 61 => 0x5, 350 => 0x3 },
	'panoramaframeheight' => { 350 => 0x9 },
	'panoramaframenumber' => { 61 => 0x2 },
	'panoramaframewidth' => { 350 => 0x8 },
	'panoramafullheight' => { 350 => 0x2 },
	'panoramafullwidth' => { 350 => 0x1 },
	'panoramamode' => { 114 => 0x3c, 241 => 0x601 },
	'panoramasize3d' => { 335 => 0x38 },
	'panoramasourceheight' => { 350 => 0xb },
	'panoramasourcewidth' => { 350 => 0xa },
	'panoramicstitchcameramotion' => { 146 => 'PanoramicStitchCameraMotion', 147 => 0x1 },
	'panoramicstitchmaptype' => { 146 => 'PanoramicStitchMapType', 147 => 0x2 },
	'panoramicstitchphi0' => { 146 => 'PanoramicStitchPhi0', 147 => 0x5 },
	'panoramicstitchphi1' => { 146 => 'PanoramicStitchPhi1', 147 => 0x6 },
	'panoramicstitchtheta0' => { 146 => 'PanoramicStitchTheta0', 147 => 0x3 },
	'panoramicstitchtheta1' => { 146 => 'PanoramicStitchTheta1', 147 => 0x4 },
	'panoramicstitchversion' => { 147 => 0x0 },
	'pantry' => { 413 => 'Pantry' },
	'parallax' => { 103 => 0xb211, 240 => 0x28 },
	'parametricdarks' => { 387 => 'ParametricDarks' },
	'parametrichighlights' => { 387 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 387 => 'ParametricHighlightSplit' },
	'parametriclights' => { 387 => 'ParametricLights' },
	'parametricmidtonesplit' => { 387 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 387 => 'ParametricShadows' },
	'parametricshadowsplit' => { 387 => 'ParametricShadowSplit' },
	'parentmeid' => { 377 => 'ParentMEID' },
	'parentreference1' => { 395 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 395 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 395 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 395 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 395 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 395 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 412 => 'partOfCompilation' },
	'patientbirthdate' => { 374 => 'PatientDOB' },
	'patientid' => { 374 => 'PatientID' },
	'patientname' => { 374 => 'PatientName' },
	'patientsex' => { 374 => 'PatientSex' },
	'pdfversion' => { 398 => 'PDFVersion' },
	'pentaximagesize' => { 294 => 0x9 },
	'pentaxmodelid' => { 274 => 0x0, 294 => 0x5 },
	'pentaxmodeltype' => { 294 => 0x1 },
	'pentaxversion' => { 294 => 0x0 },
	'people' => { 375 => 'People', 379 => 'People' },
	'perchannelblacklevel' => { 36 => 0xc4, 37 => [0x2b4,0x2cb,0x2cf], 38 => 0x108, 39 => 0x1df, 40 => [0x1f8,0x2d8] },
	'peripheralillumcentralradius' => { 372 => 0x8030 },
	'peripheralillumcentralvalue' => { 372 => 0x8031 },
	'peripheralillumination' => { 90 => 0x68 },
	'peripheralilluminationcorr' => { 52 => 0x1 },
	'peripheralilluminationon' => { 90 => 0x64 },
	'peripheralillumperiphvalue' => { 372 => 0x8032 },
	'peripherallighting' => { 67 => 0x2 },
	'peripherallightingsetting' => { 68 => 0x5 },
	'peripherallightingvalue' => { 67 => 0x6 },
	'permissions' => { 405 => 'permissions' },
	'permits' => { 384 => 'permits' },
	'person' => { 402 => 'person' },
	'personality' => { 377 => 'Personality' },
	'personinimage' => { 397 => 'PersonInImage' },
	'personinimagecharacteristic' => { 397 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 397 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 397 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 397 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 397 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 397 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 397 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 397 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 397 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 387 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 387 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 387 => 'PerspectiveRotate' },
	'perspectivescale' => { 387 => 'PerspectiveScale' },
	'perspectiveupright' => { 387 => 'PerspectiveUpright' },
	'perspectivevertical' => { 387 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 79 => 0x1 },
	'pf10retainprogramshift' => { 79 => 0xb },
	'pf13drivepriority' => { 79 => 0xe },
	'pf14disablefocussearch' => { 79 => 0xf },
	'pf15disableafassistbeam' => { 79 => 0x10 },
	'pf16autofocuspointshoot' => { 79 => 0x11 },
	'pf17disableafpointsel' => { 79 => 0x12 },
	'pf18enableautoafpointsel' => { 79 => 0x13 },
	'pf19continuousshootspeed' => { 79 => 0x14 },
	'pf19shootingspeedhigh' => { 78 => 0xa },
	'pf19shootingspeedlow' => { 78 => 0x9 },
	'pf1disableshootingmodes' => { 79 => 0x2 },
	'pf1value' => { 78 => 0x1 },
	'pf20limitcontinousshots' => { 79 => 0x15 },
	'pf20maxcontinousshots' => { 78 => 0xb },
	'pf21enablequietoperation' => { 79 => 0x16 },
	'pf23felocktime' => { 78 => 0xd },
	'pf23postreleasetime' => { 78 => 0xe },
	'pf23settimerlengths' => { 79 => 0x18 },
	'pf23shutterbuttontime' => { 78 => 0xc },
	'pf24lightlcdduringbulb' => { 79 => 0x19 },
	'pf25aemode' => { 78 => 0xf },
	'pf25afmode' => { 78 => 0x12 },
	'pf25afpointsel' => { 78 => 0x13 },
	'pf25colormatrix' => { 78 => 0x17 },
	'pf25defaultclearsettings' => { 79 => 0x1a },
	'pf25drivemode' => { 78 => 0x11 },
	'pf25imagesize' => { 78 => 0x14 },
	'pf25meteringmode' => { 78 => 0x10 },
	'pf25parameters' => { 78 => 0x16 },
	'pf25wbmode' => { 78 => 0x15 },
	'pf26shortenreleaselag' => { 79 => 0x1b },
	'pf27reversedialrotation' => { 79 => 0x1c },
	'pf27value' => { 78 => 0x18 },
	'pf28noquickdialexpcomp' => { 79 => 0x1d },
	'pf29quickdialswitchoff' => { 79 => 0x1e },
	'pf2disablemeteringmodes' => { 79 => 0x3 },
	'pf2value' => { 78 => 0x2 },
	'pf30enlargementmode' => { 79 => 0x1f },
	'pf31originaldecisiondata' => { 79 => 0x20 },
	'pf3manualexposuremetering' => { 79 => 0x4 },
	'pf3value' => { 78 => 0x3 },
	'pf4exposuretimelimits' => { 79 => 0x5 },
	'pf4exposuretimemax' => { 78 => 0x5 },
	'pf4exposuretimemin' => { 78 => 0x4 },
	'pf5aperturelimits' => { 79 => 0x6 },
	'pf5aperturemax' => { 78 => 0x7 },
	'pf5aperturemin' => { 78 => 0x6 },
	'pf6presetshootingmodes' => { 79 => 0x7 },
	'pf7bracketcontinuousshoot' => { 79 => 0x8 },
	'pf8bracketshots' => { 78 => 0x8 },
	'pf8setbracketshots' => { 79 => 0x9 },
	'pf9changebracketsequence' => { 79 => 0xa },
	'phasedetectaf' => { 161 => 0x6 },
	'phonenumber' => { 129 => 'Phone' },
	'photoeffect' => { 30 => 0x28 },
	'photoeffecthistoryxml' => { 221 => 0xe9651831 },
	'photoeffects' => { 221 => 0xab5eca5e },
	'photoeffectsblue' => { 223 => 0x8 },
	'photoeffectsgreen' => { 223 => 0x6 },
	'photoeffectsred' => { 223 => 0x4 },
	'photoeffectstype' => { 223 => 0x0 },
	'photographicsensitivity' => { 392 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 228 => '17.6', 234 => '33.6' },
	'photometricinterpretation' => { 98 => 0x106, 408 => 'PhotometricInterpretation' },
	'photoshopbgrthumbnail' => { 305 => 0x409 },
	'photoshopquality' => { 304 => 0x0 },
	'photoshopthumbnail' => { 305 => 0x40c },
	'photostyle' => { 261 => 0x89 },
	'picklabel' => { 390 => 'PickLabel' },
	'pictinfo' => { 324 => 0x208 },
	'picturecontrol' => { 221 => 0xe2173c47 },
	'picturecontrolactive' => { 224 => 0x0 },
	'picturecontroladjust' => { 187 => 0x30 },
	'picturecontrolbase' => { 187 => 0x18 },
	'picturecontroldata' => { 185 => [0xbd,0x23] },
	'picturecontrolmode' => { 224 => 0x13 },
	'picturecontrolname' => { 187 => 0x4 },
	'picturecontrolquickadjust' => { 187 => 0x31 },
	'pictureeffect' => { 345 => 0x200e },
	'pictureeffect2' => { 352 => 0x1163, 353 => 0x1167, 354 => 0x1143, 355 => 0x11bf, 356 => 0x119b, 357 => 0x1053, 358 => 0x24b, 368 => 0x46 },
	'picturefinish' => { 151 => 0x71 },
	'picturemode' => { 103 => 0x1031, 241 => 0x520, 294 => [0xb,0x33], 325 => 0x3d },
	'picturemode2' => { 275 => 0x0 },
	'picturemodebwfilter' => { 241 => 0x525 },
	'picturemodecontrast' => { 241 => 0x523 },
	'picturemodeeffect' => { 241 => 0x52d },
	'picturemodehue' => { 241 => 0x522 },
	'picturemodesaturation' => { 241 => 0x521 },
	'picturemodesharpness' => { 241 => 0x524 },
	'picturemodetone' => { 241 => 0x526 },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 63 => 0xa, 90 => 0x2 },
	'picturewizard' => { 322 => 0x21 },
	'picturewizardcolor' => { 321 => 0x1 },
	'picturewizardcontrast' => { 321 => 0x4 },
	'picturewizardmode' => { 321 => 0x0 },
	'picturewizardsaturation' => { 321 => 0x2 },
	'picturewizardsharpness' => { 321 => 0x3 },
	'pitch' => { 229 => '4.1', 238 => '4.1' },
	'pitchangle' => { 201 => 0x350f, 241 => 0x904, 261 => 0x91, 293 => 0x2 },
	'pixelsperunitx' => { 252 => 0x0 },
	'pixelsperunity' => { 252 => 0x4 },
	'pixelunits' => { 252 => 0x8 },
	'planarconfiguration' => { 98 => 0x11c, 408 => 'PlanarConfiguration' },
	'platenames' => { 417 => 'PlateNames' },
	'platform' => { 402 => 'platform' },
	'playbackmenustime' => { 231 => '20.1', 232 => '21.1', 233 => '21.1' },
	'playbackmonitorofftime' => { 228 => '25.2', 229 => '36.1', 234 => '8.1', 235 => '35.1', 238 => '36.1', 239 => '21.1' },
	'playbackzoom' => { 229 => '37.1' },
	'playdisplay' => { 153 => 0x4e },
	'plusversion' => { 400 => 'Version' },
	'pmversion' => { 303 => 'PMVersion' },
	'pngwarning' => { 253 => 'Warning' },
	'poilevel' => { 184 => 0x8 },
	'portraitoutputhighlightpoint' => { 90 => 0x1d },
	'portraitoutputshadowpoint' => { 90 => 0x1e },
	'portraitrawcolortone' => { 90 => 0x16 },
	'portraitrawcontrast' => { 90 => 0x18 },
	'portraitrawhighlight' => { 90 => 0x76 },
	'portraitrawhighlightpoint' => { 90 => 0x1b },
	'portraitrawlinear' => { 90 => 0x19 },
	'portraitrawsaturation' => { 90 => 0x17 },
	'portraitrawshadow' => { 90 => 0x7f },
	'portraitrawshadowpoint' => { 90 => 0x1c },
	'portraitrawsharpness' => { 90 => 0x1a },
	'portraitrefiner' => { 94 => 0x302b },
	'portraitunsharpmaskfineness' => { 90 => 0x9a },
	'portraitunsharpmaskstrength' => { 90 => 0x98 },
	'portraitunsharpmaskthreshold' => { 90 => 0x9c },
	'poseheadingdegrees' => { 376 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 376 => 'PosePitchDegrees' },
	'poserolldegrees' => { 376 => 'PoseRollDegrees' },
	'positiondescriptor' => { 401 => 'positionDescriptor' },
	'postalcode' => { 133 => 'PostalCode' },
	'postcropvignetteamount' => { 387 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 387 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 387 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 387 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 387 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 387 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 343 => 0xb },
	'potentialface2position' => { 343 => 0x15 },
	'potentialface3position' => { 343 => 0x1f },
	'potentialface4position' => { 343 => 0x29 },
	'potentialface5position' => { 343 => 0x33 },
	'potentialface6position' => { 343 => 0x3d },
	'potentialface7position' => { 343 => 0x47 },
	'potentialface8position' => { 343 => 0x51 },
	'powersource' => { 273 => '0.1' },
	'poweruptime' => { 185 => 0xb6 },
	'precaptureframes' => { 246 => 0x300 },
	'predictor' => { 98 => 0x13d },
	'preflashreturnstrength' => { 199 => 0x28a },
	'prefs' => { 106 => 0xdd, 303 => 'Prefs' },
	'preservedfilename' => { 413 => 'PreservedFileName' },
	'presetwhitebalance' => { 153 => 0x24, 372 => 0x8002 },
	'presetwhitebalanceadj' => { 372 => 0x8014 },
	'previewapplicationname' => { 98 => 0xc716 },
	'previewapplicationversion' => { 98 => 0xc717 },
	'previewbutton' => { 228 => ['14.1','15.1'], 229 => '15.1', 234 => '29.1', 235 => '14.1', 238 => '15.1' },
	'previewbuttonplusdials' => { 228 => ['14.2','15.2'], 229 => '15.2', 234 => '31.2', 238 => '43.1' },
	'previewcolorspace' => { 98 => 0xc71a },
	'previewcropbottom' => { 302 => 0xef },
	'previewcropleft' => { 302 => 0xec },
	'previewcropright' => { 302 => 0xee },
	'previewcroptop' => { 302 => 0xed },
	'previewdate' => { 310 => 0x0 },
	'previewdatetime' => { 98 => 0xc71b },
	'previewimage' => { 94 => 0x2000, 95 => 'PreviewImage', 99 => 'PreviewImage', 101 => 0x4, 138 => 'data', 155 => 0x81, 246 => 0x280, 260 => 0x300, 345 => 0x2001 },
	'previewimageborders' => { 294 => 0x3e },
	'previewimageheight' => { 62 => 0x4, 116 => 0xfa58 },
	'previewimagelength' => { 62 => 0x2, 94 => 0x3, 98 => [0x117,0x202], 155 => 0x89, 188 => 0x202, 241 => 0x102, 246 => 0x1037, 294 => 0x3, 315 => 0x1e, 320 => 0x3, 325 => [0x1b,0x1d], 336 => 0x202 },
	'previewimagename' => { 138 => '1Name' },
	'previewimagesize' => { 94 => 0x2, 121 => 0x2, 138 => 'ImageSize', 294 => 0x2, 325 => [0x1c,0x1e], 345 => 0xb02c },
	'previewimagestart' => { 62 => 0x5, 94 => 0x4, 98 => [0x111,0x201], 155 => 0x88, 188 => 0x201, 241 => 0x101, 246 => 0x1036, 294 => 0x4, 315 => 0x1c, 320 => 0x2, 325 => [0x1a,0x1c], 336 => 0x201 },
	'previewimagetype' => { 138 => '0Type' },
	'previewimagevalid' => { 241 => 0x100, 246 => 0x1035 },
	'previewimagewidth' => { 62 => 0x3, 116 => 0xfa57 },
	'previewquality' => { 62 => 0x1 },
	'previewsettingsdigest' => { 98 => 0xc719 },
	'previewsettingsname' => { 98 => 0xc718 },
	'primaryafpoint' => { 161 => 0x7 },
	'primarychromaticities' => { 98 => 0x13f, 408 => 'PrimaryChromaticities' },
	'printim' => { 98 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 153 => 0x1d, 333 => 0x28 },
	'privatertkinfo' => { 378 => 'privateRTKInfo' },
	'processingsoftware' => { 98 => 0xb },
	'processversion' => { 387 => 'ProcessVersion' },
	'producer' => { 250 => 'Producer', 398 => 'Producer' },
	'productcode' => { 402 => 'productCode' },
	'productid' => { 107 => 0x32, 401 => 'productID' },
	'productidtype' => { 401 => 'productIDType' },
	'productinimage' => { 397 => 'ProductInImage' },
	'productinimagedescription' => { 397 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 397 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 397 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 274 => 0x2 },
	'productorserviceconstraints' => { 400 => 'ProductOrServiceConstraints' },
	'profession' => { 402 => 'profession' },
	'profilecalibrationsig' => { 98 => 0xc6f4 },
	'profilecopyright' => { 98 => 0xc6fe },
	'profileembedpolicy' => { 98 => 0xc6fd },
	'profilehuesatmapdata1' => { 98 => 0xc6fa },
	'profilehuesatmapdata2' => { 98 => 0xc6fb },
	'profilehuesatmapdims' => { 98 => 0xc6f9 },
	'profilehuesatmapencoding' => { 98 => 0xc7a3 },
	'profilelooktabledata' => { 98 => 0xc726 },
	'profilelooktabledims' => { 98 => 0xc725 },
	'profilelooktableencoding' => { 98 => 0xc7a4 },
	'profilename' => { 98 => 0xc6f8 },
	'profiletonecurve' => { 98 => 0xc6fc },
	'programiso' => { 261 => 0x3c },
	'programline' => { 275 => '1.1' },
	'programmode' => { 158 => 0x5 },
	'programshift' => { 185 => 0xd },
	'programversion' => { 106 => 0x46 },
	'prohibits' => { 384 => 'prohibits' },
	'projectiontype' => { 376 => 'ProjectionType' },
	'projectname' => { 412 => 'projectName' },
	'projectref' => { 412 => 'projectRef' },
	'projectrefpath' => { 412 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 412 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 400 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 400 => 'PropertyReleaseStatus' },
	'province-state' => { 106 => 0x5f },
	'publicationdate' => { 402 => 'publicationDate' },
	'publicationdatea-platform' => { 402 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 402 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 402 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 402 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 402 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationname' => { 402 => 'publicationName' },
	'publisher' => { 388 => 'publisher' },
	'publishingfrequency' => { 402 => 'publishingFrequency' },
	'pulldown' => { 412 => 'pullDown' },
	'quality' => { 0 => 0x1, 30 => 0x3, 93 => 0x2, 94 => 0x3002, 103 => 0x1000, 114 => 0x9, 185 => 0x4, 211 => 0x3, 246 => 0x201, 257 => 0x300, 294 => 0x8, 300 => 0x2, 325 => 0x16, 333 => 0x56, 334 => 0x56, 335 => 0xb, 345 => 0x102 },
	'quality2' => { 352 => 0x1170, 353 => 0x1174, 354 => 0x1150, 356 => 0x11a8, 357 => 0x1060, 358 => 0x258, 360 => 0x29, 361 => 0x25, 362 => 0x2a },
	'qualitymode' => { 94 => 0x8 },
	'quantizationmethod' => { 108 => 0x78 },
	'quickadjust' => { 224 => 0x2a },
	'quickcontroldialinmeter' => { 71 => 0x703 },
	'quickfix' => { 221 => 0x416391c6 },
	'quickshot' => { 324 => 0x213 },
	'rangefinder' => { 231 => '4.1', 232 => '5.1', 233 => '5.1' },
	'rasterizedcaption' => { 106 => 0x7d },
	'rating' => { 98 => 0x4746, 103 => 0x1431, 302 => 0xdf, 345 => 0x2002, 381 => 'rating', 389 => 'rating', 402 => 'rating', 410 => 'Rating' },
	'ratingpercent' => { 98 => 0x4749, 148 => 'Rating' },
	'rawandjpgrecording' => { 69 => 0x8, 155 => 0x109, 275 => 0xd },
	'rawbrightnessadj' => { 89 => 0x38 },
	'rawcoloradj' => { 89 => 0x2e },
	'rawcompressionmode' => { 322 => 0x45 },
	'rawcropbottom' => { 302 => 0xd4 },
	'rawcropleft' => { 302 => 0xd1 },
	'rawcropright' => { 302 => 0xd3 },
	'rawcroptop' => { 302 => 0xd2 },
	'rawcustomsaturation' => { 89 => 0x30 },
	'rawcustomtone' => { 89 => 0x34 },
	'rawdata' => { 322 => 0xa048 },
	'rawdatauniqueid' => { 98 => 0xc65d },
	'rawdepth' => { 157 => 0x10 },
	'rawdevartfilter' => { 248 => 0x121 },
	'rawdevautogradation' => { 248 => 0x119 },
	'rawdevcolorspace' => { 247 => 0x108, 248 => 0x109 },
	'rawdevcontrastvalue' => { 247 => 0x106, 248 => 0x105 },
	'rawdeveditstatus' => { 247 => 0x10b },
	'rawdevelopmentprocess' => { 294 => 0x62 },
	'rawdevengine' => { 247 => 0x109, 248 => 0x10b },
	'rawdevexposurebiasvalue' => { 247 => 0x100, 248 => 0x100 },
	'rawdevgradation' => { 248 => 0x112 },
	'rawdevgraypoint' => { 247 => 0x103, 248 => 0x104 },
	'rawdevmemorycoloremphasis' => { 247 => 0x105, 248 => 0x108 },
	'rawdevnoisereduction' => { 247 => 0x10a, 248 => 0x10a },
	'rawdevpicturemode' => { 248 => 0x10c },
	'rawdevpm_bwfilter' => { 248 => 0x110 },
	'rawdevpmcontrast' => { 248 => 0x10e },
	'rawdevpmnoisefilter' => { 248 => 0x120 },
	'rawdevpmpicturetone' => { 248 => 0x111 },
	'rawdevpmsaturation' => { 248 => 0x10d },
	'rawdevpmsharpness' => { 248 => 0x10f },
	'rawdevsaturation3' => { 248 => 0x113 },
	'rawdevsaturationemphasis' => { 247 => 0x104, 248 => 0x107 },
	'rawdevsettings' => { 247 => 0x10c },
	'rawdevsharpnessvalue' => { 247 => 0x107, 248 => 0x106 },
	'rawdevversion' => { 247 => 0x0, 248 => 0x0 },
	'rawdevwbfineadjustment' => { 247 => 0x102, 248 => 0x103 },
	'rawdevwhitebalance' => { 248 => 0x101 },
	'rawdevwhitebalancevalue' => { 247 => 0x101, 248 => 0x102 },
	'rawfile' => { 98 => 0xfe4c },
	'rawfilename' => { 387 => 'RawFileName' },
	'rawimagecenter' => { 185 => 0x99 },
	'rawimagedigest' => { 98 => 0xc71c },
	'rawimagesize' => { 294 => 0x39 },
	'rawinfoversion' => { 249 => 0x0 },
	'rawjpgheight' => { 86 => 0x4 },
	'rawjpgquality' => { 47 => 0x6, 86 => 0x1 },
	'rawjpgsize' => { 47 => 0x7, 86 => 0x2 },
	'rawjpgwidth' => { 86 => 0x3 },
	'rawmeasuredrggb' => { 35 => 0x26a, 37 => 0x280, 39 => 0x194, 40 => [0x1ad,0x26b] },
	'rawrppused' => { 381 => 'rawrppused' },
	'rawtopreviewgain' => { 98 => 0xc7a8 },
	'reardisplay' => { 228 => '12.3', 229 => '6.2' },
	'recipeendingpage' => { 404 => 'recipeEndingPage' },
	'recipepagerange' => { 404 => 'recipePageRange' },
	'recipesource' => { 404 => 'recipeSource' },
	'recipestartingpage' => { 404 => 'recipeStartingPage' },
	'recipetitle' => { 404 => 'recipeTitle' },
	'recognizedface1age' => { 256 => 0x20 },
	'recognizedface1name' => { 256 => 0x4 },
	'recognizedface1position' => { 256 => 0x18 },
	'recognizedface2age' => { 256 => 0x50 },
	'recognizedface2name' => { 256 => 0x34 },
	'recognizedface2position' => { 256 => 0x48 },
	'recognizedface3age' => { 256 => 0x80 },
	'recognizedface3name' => { 256 => 0x64 },
	'recognizedface3position' => { 256 => 0x78 },
	'recognizedfaceflags' => { 261 => 0x63 },
	'recommendedexposureindex' => { 98 => 0x8832, 392 => 'RecommendedExposureIndex' },
	'record' => { 97 => 'Record' },
	'recordbasisofrecord' => { 97 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 97 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 97 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 97 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 97 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 97 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 153 => 0x4d },
	'recorddynamicproperties' => { 97 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 84 => 0x1804 },
	'recordinformationwithheld' => { 97 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 316 => 0x1000 },
	'recordingmode' => { 93 => 0x1, 300 => 0x1 },
	'recordinstitutioncode' => { 97 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 97 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 30 => 0x9, 94 => 0x3000 },
	'recordownerinstitutioncode' => { 97 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 324 => 0x217 },
	'redbalance' => { 169 => 0x270, 246 => 0x1017, 265 => 0x11, 294 => 0x1c },
	'redcurvelimits' => { 89 => 0x18a },
	'redcurvepoints' => { 89 => 0x160 },
	'redeyecorrection' => { 225 => 0x0 },
	'redeyeinfo' => { 387 => 'RedEyeInfo' },
	'redeyereduction' => { 153 => 0x41, 333 => 0x6a, 335 => 0x28 },
	'redhue' => { 387 => 'RedHue' },
	'redsaturation' => { 387 => 'RedSaturation' },
	'reductionmatrix1' => { 98 => 0xc625 },
	'reductionmatrix2' => { 98 => 0xc626 },
	'reelname' => { 98 => 0xc789 },
	'reference1' => { 395 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 395 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 395 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 395 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 395 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 395 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 98 => 0x214, 408 => 'ReferenceBlackWhite' },
	'referencedate' => { 106 => 0x2f },
	'referencenumber' => { 106 => 0x32 },
	'references' => { 129 => 'References' },
	'referenceservice' => { 106 => 0x2d },
	'regionappliedtodimensions' => { 144 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 144 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 144 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 144 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 144 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 144 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 144 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 144 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 144 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 144 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 144 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 144 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 400 => 'RegionConstraints' },
	'regiondescription' => { 144 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 144 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 144 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 144 => 'Regions' },
	'regioninfodateregionsvalid' => { 145 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 145 => 'RegionInfo' },
	'regioninforegions' => { 145 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 144 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 144 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 145 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 145 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 145 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 145 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 145 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionseealso' => { 144 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 144 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 397 => 'RegistryId' },
	'registryitemid' => { 397 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 397 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 127 => 'data' },
	'relatedaudiofilename' => { 127 => '1Name' },
	'relatedaudiofiletype' => { 127 => '0Type' },
	'relatedimagefileformat' => { 98 => 0x1000 },
	'relatedimageheight' => { 98 => 0x1002 },
	'relatedimagewidth' => { 98 => 0x1001 },
	'relatedresourceid' => { 97 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 98 => 0xa004, 391 => 'RelatedSoundFile' },
	'relatedvideofile' => { 141 => 'data' },
	'relatedvideofilename' => { 141 => '1Name' },
	'relatedvideofiletype' => { 141 => '0Type' },
	'relation' => { 388 => 'relation' },
	'relationshipaccordingto' => { 97 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 97 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 97 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 97 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 412 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 412 => 'relativeTimestamp' },
	'relativetimestampscale' => { 412 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 412 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 228 => '17.8', 229 => '18.5', 234 => '33.8', 235 => '17.6', 238 => '18.5' },
	'releasedate' => { 106 => 0x1e, 412 => 'releaseDate' },
	'releasemode' => { 94 => 0x3001, 345 => 0xb049 },
	'releasemode2' => { 352 => 0x112c, 353 => [0x112c,0x8], 354 => [0x1108,0x8], 355 => [0x1184,0x8], 356 => [0x1160,0x8], 357 => [0x4,0x1018], 358 => [0x4,0x210], 359 => 0x3f, 360 => 0x10, 361 => 0x10, 362 => 0x9, 368 => 0x34 },
	'releasemode3' => { 352 => 0x1128, 353 => 0x1128, 354 => 0x1104, 355 => 0x1180, 356 => 0x115c, 357 => 0x1014, 358 => 0x20c },
	'releasesetting' => { 84 => 0x1016 },
	'releasetime' => { 106 => 0x23 },
	'remoteonduration' => { 230 => '3.4', 231 => '17.2', 232 => '18.2', 233 => '18.2', 235 => '18.2', 236 => '4.3', 239 => '19.2' },
	'renditionclass' => { 413 => 'RenditionClass' },
	'renditionof' => { 413 => 'RenditionOf' },
	'renditionofalternatepaths' => { 413 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 413 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 413 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 413 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 413 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 413 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 413 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 413 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 413 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 413 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 413 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 413 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 413 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 413 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 413 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 413 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 413 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 413 => 'RenditionParams' },
	'repeatingflashcount' => { 174 => 0xd, 175 => 0xe, 176 => 0xe, 234 => '17.2', 235 => '24.2', 236 => '9.2', 237 => '24.2', 239 => '25.2' },
	'repeatingflashcountbuilt-in' => { 208 => 0x4db },
	'repeatingflashcountexternal' => { 208 => 0x4c3 },
	'repeatingflashoutput' => { 234 => '17.1', 235 => '24.1', 236 => '9.1', 237 => '24.1', 239 => '25.1' },
	'repeatingflashoutputexternal' => { 208 => 0x4c0 },
	'repeatingflashrate' => { 174 => 0xc, 175 => 0xd, 176 => 0xd, 234 => '18.1', 235 => '25.1', 236 => '10.1', 237 => '25.1', 239 => '26.1' },
	'repeatingflashratebuilt-in' => { 208 => 0x4da },
	'repeatingflashrateexternal' => { 208 => 0x4c2 },
	'requires' => { 384 => 'requires' },
	'resampleparams' => { 412 => 'resampleParams' },
	'resampleparamsquality' => { 412 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 324 => 0x21e },
	'resolution' => { 134 => 'Resolution' },
	'resolutionmode' => { 325 => 0x4 },
	'resolutionunit' => { 98 => 0x128, 109 => 0x2, 408 => 'ResolutionUnit' },
	'resourceid' => { 97 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 97 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 97 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 71 => 0x612 },
	'restrictions' => { 405 => 'restrictions' },
	'retouchareafeather' => { 387 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 387 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 387 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 387 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 387 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 387 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 387 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 387 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 387 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 387 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 387 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 387 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 387 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 387 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 387 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 387 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 387 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 387 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 387 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 387 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 387 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 387 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 387 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 387 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 387 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 387 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 387 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 387 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 387 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 387 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 387 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 387 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 387 => 'RetouchAreas' },
	'retouchareaseed' => { 387 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 387 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 387 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 387 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 185 => 0x9e },
	'retouchinfo' => { 387 => 'RetouchInfo' },
	'retouchnefprocessing' => { 190 => 0x5 },
	'reuse' => { 400 => 'Reuse' },
	'reuseallowed' => { 415 => 'ReuseAllowed' },
	'reuseprohibited' => { 405 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 233 => '5.2' },
	'reverseindicators' => { 228 => '12.1', 229 => '6.1', 231 => '4.3', 232 => '5.2', 233 => '5.4', 234 => '33.5', 235 => '5.1', 238 => '6.1', 239 => '6.2' },
	'reverseshutterspeedaperture' => { 233 => '5.3' },
	'revision' => { 389 => 'revision' },
	'rgbcurvelimits' => { 89 => 0x238 },
	'rgbcurvepoints' => { 89 => 0x20e },
	'richtextcomment' => { 394 => 'RichTextComment' },
	'ricohdate' => { 315 => 0x6 },
	'ricohimageheight' => { 315 => 0x2 },
	'ricohimagewidth' => { 315 => 0x0 },
	'rightascension' => { 137 => 'RightAscension' },
	'rights' => { 388 => 'rights' },
	'rightsagent' => { 405 => 'rightsAgent' },
	'rightsowner' => { 405 => 'rightsOwner' },
	'rollangle' => { 201 => 0x350b, 241 => 0x903, 261 => 0x90, 293 => 0x1 },
	'romoperationmode' => { 84 => 0x80d },
	'rotation' => { 27 => 0x17, 28 => 0x18, 83 => 0x3, 89 => 0x26e, 102 => 0x4, 137 => 'Rotation', 151 => [0x65,0x50], 152 => 0x46, 153 => 0x5a, 156 => 0x10, 207 => '590.1', 221 => 0x76a43207, 261 => 0x30, 275 => '17.2', 302 => 0xd8, 333 => 0x3f, 334 => 0x3f, 344 => 0x10 },
	'routedto' => { 393 => 'RoutedTo' },
	'routing' => { 307 => 'Routing' },
	'routingnotes' => { 393 => 'RoutingNotes' },
	'rowsperstrip' => { 98 => 0x116 },
	'rpp' => { 381 => 'rpp' },
	'safetyshift' => { 71 => 0x108 },
	'safetyshiftinavortv' => { 69 => 0x10, 70 => 0x10, 72 => 0xf, 73 => 0x10, 76 => 0x10 },
	'samplebits' => { 127 => 'SampleBits' },
	'samplepagerange' => { 402 => 'samplePageRange' },
	'samplerate' => { 127 => 'SampleRate' },
	'samplesperpixel' => { 98 => 0x115, 408 => 'SamplesPerPixel' },
	'samplestructure' => { 108 => 0x5a },
	'samsungmodelid' => { 322 => 0x3 },
	'sanyoquality' => { 324 => 0x201 },
	'sanyothumbnail' => { 324 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 30 => 0xe, 41 => 0x1, 93 => 0xd, 94 => [0x3013,0x1f], 98 => [0xa409,0xfe55], 103 => 0x1003, 128 => 'Saturation', 150 => 0x1f, 151 => 0x32, 152 => 0x28, 153 => 0x1a, 158 => 0x1, 185 => [0x94,0xaa], 187 => 0x35, 261 => 0x40, 263 => 0x300d, 294 => 0x1f, 300 => 0xd, 312 => 0x27, 315 => 0x28, 316 => 0x1013, 325 => 0x10, 333 => 0x1e, 334 => 0x1b, 345 => 0x2005, 387 => 'Saturation', 391 => 'Saturation' },
	'saturationadj' => { 89 => 0x116, 220 => 0x1, 224 => 0x2e, 372 => 0x8016 },
	'saturationadjustmentaqua' => { 387 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 387 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 387 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 387 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 387 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 387 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 387 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 387 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 60 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 59 => 0x68, 60 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 59 => 0x38, 60 => 0x38 },
	'saturationmonochrome' => { 59 => 0x80, 60 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 59 => 0x50, 60 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 59 => 0x20, 60 => 0x20 },
	'saturationsetting' => { 249 => 0x1010, 335 => 0x11, 349 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 59 => 0x8, 60 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 59 => 0x98, 60 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 59 => 0xb0, 60 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 59 => 0xc8, 60 => 0xe0 },
	'saveid' => { 413 => 'SaveID' },
	'scaletype' => { 412 => 'scaleType' },
	'scanimageenhancer' => { 191 => 0x60 },
	'scanningdirection' => { 108 => 0x64 },
	'scene' => { 396 => 'Scene', 412 => 'scene' },
	'scenearea' => { 244 => 0x211, 246 => 0x1031 },
	'sceneassist' => { 185 => 0x9c },
	'scenecapturetype' => { 98 => 0xa406, 391 => 'SceneCaptureType' },
	'scenedetect' => { 244 => 0x210, 246 => 0x1030 },
	'scenedetectdata' => { 244 => 0x212, 246 => 0x1033 },
	'scenemode' => { 116 => 0xfa02, 155 => 0x100, 185 => 0x8f, 241 => 0x509, 246 => 0x403, 261 => 0x8001, 269 => 0xf, 345 => 0xb023 },
	'scenemodeused' => { 118 => [0x6002,0xf002] },
	'sceneselect' => { 324 => 0x21f },
	'scenetype' => { 98 => 0xa301, 391 => 'SceneType' },
	'screentips' => { 228 => '12.7', 229 => '5.3', 234 => '13.1', 235 => '4.4', 238 => '5.4', 239 => '5.1' },
	'season' => { 401 => 'season' },
	'section' => { 402 => 'section' },
	'securityclassification' => { 98 => 0x9212 },
	'selectableafpoint' => { 71 => 0x509 },
	'selectafareaselectmode' => { 71 => 0x512 },
	'selftimer' => { 30 => 0x2, 261 => 0x2e, 324 => 0x214 },
	'selftimer2' => { 65 => 0x1d },
	'selftimerinterval' => { 235 => '19.2' },
	'selftimermode' => { 98 => 0x882b },
	'selftimershotcount' => { 229 => '20.2', 231 => '18.2', 232 => '19.2', 233 => '19.2', 235 => '19.3', 238 => '20.3', 239 => '20.2' },
	'selftimershotinterval' => { 229 => '20.3', 238 => '20.2' },
	'selftimertime' => { 84 => 0x1806, 153 => 0x1f, 228 => '18.1', 229 => '20.1', 230 => '3.3', 231 => '18.1', 232 => '19.1', 233 => '19.1', 234 => '7.2', 235 => '19.1', 236 => '3.3', 238 => '20.1', 239 => '20.1' },
	'sellingagency' => { 402 => 'sellingAgency' },
	'seminfo' => { 98 => 0x8546 },
	'sensingmethod' => { 98 => 0xa217, 391 => 'SensingMethod' },
	'sensitivityadjust' => { 294 => 0x40 },
	'sensitivitysteps' => { 275 => ['14.3','17.4'], 277 => 0x1 },
	'sensitivitytype' => { 98 => 0x8830, 392 => 'SensitivityType' },
	'sensorareas' => { 322 => 0xa010 },
	'sensorbitdepth' => { 263 => 0x312d },
	'sensorbluelevel' => { 63 => 0x5 },
	'sensorcalibration' => { 245 => 0x805 },
	'sensorcleaning' => { 77 => 0xd },
	'sensorfullheight' => { 111 => 0xf904 },
	'sensorfullwidth' => { 111 => 0xf903 },
	'sensorheight' => { 111 => 0xf901, 116 => 0xfa21, 157 => 0x8, 263 => 0x312c, 316 => 0x1602 },
	'sensorpixelsize' => { 185 => 0x9a },
	'sensorredlevel' => { 63 => 0x4 },
	'sensorserialnumber' => { 112 => 0x9ce },
	'sensorsize' => { 128 => 'SensorSize', 294 => 0x35 },
	'sensortemperature' => { 244 => 0x1500, 246 => 0x1007, 325 => [0x39,0x55] },
	'sensorwidth' => { 111 => 0xf900, 116 => 0xfa20, 157 => 0xa, 263 => 0x312b, 316 => 0x1601 },
	'sequence' => { 312 => 0x7 },
	'sequencefilenumber' => { 353 => 0x4, 354 => 0x4, 355 => 0x4, 356 => 0x4, 360 => 0xc, 361 => 0xc, 362 => 0x1a },
	'sequenceimagenumber' => { 353 => 0x0, 354 => 0x0, 355 => 0x0, 356 => 0x0, 360 => 0x8, 361 => 0x8, 362 => 0x12, 368 => 0x24 },
	'sequencelength' => { 360 => 0x22, 361 => 0x1e, 362 => [0x16,0x1e] },
	'sequencename' => { 401 => 'sequenceName' },
	'sequencenumber' => { 65 => 0x9, 94 => 0x301c, 103 => 0x1101, 114 => 0x1d, 208 => 0x51c, 261 => 0x2b, 335 => [0x10c,0x30c], 345 => 0xb04a, 401 => 'sequenceNumber' },
	'sequenceshotinterval' => { 324 => 0x224 },
	'sequencetotalnumber' => { 401 => 'sequenceTotalNumber' },
	'sequentialshot' => { 324 => 0x20e },
	'serialnumber' => { 53 => 0xc, 84 => 0x180b, 98 => [0xa431,0xfde9], 111 => 0xfa04, 113 => 0xfa00, 115 => 0xc354, 116 => 0xfa19, 125 => 0x0, 128 => 'SerialNumber', 185 => [0xa0,0x1d], 242 => 0x101, 246 => [0x404,0x101a], 257 => 0x303, 263 => 0x3103, 294 => 0x229, 312 => 0x15, 316 => 0x5, 325 => 0x2, 383 => 'SerialNumber', 392 => 'BodySerialNumber' },
	'serialnumberformat' => { 53 => 0x15, 84 => 0x183b },
	'seriesdatetime' => { 374 => 'SeriesDateTime' },
	'seriesdescription' => { 374 => 'SeriesDescription' },
	'seriesmodality' => { 374 => 'SeriesModality' },
	'seriesnumber' => { 374 => 'SeriesNumber', 402 => 'seriesNumber' },
	'seriestitle' => { 402 => 'seriesTitle' },
	'serviceidentifier' => { 107 => 0x1e },
	'servingsize' => { 404 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 74 => 0x0, 75 => 0x0 },
	'setbuttonwhenshooting' => { 69 => 0x1, 71 => 0x704, 77 => 0xc },
	'setfunctionwhenshooting' => { 72 => 0x0, 73 => 0x1, 76 => 0x1 },
	'setting' => { 401 => 'setting' },
	'shadingcompensation' => { 241 => 0x50c, 261 => 0x8a },
	'shadingcompensation2' => { 245 => 0x1012 },
	'shadow' => { 325 => 0xe },
	'shadowcorrection' => { 294 => 0x79 },
	'shadowprotection' => { 220 => 0x0 },
	'shadows' => { 98 => 0xfe52, 380 => 'Shadows', 387 => 'Shadows' },
	'shadows2012' => { 387 => 'Shadows2012' },
	'shadowscale' => { 98 => 0xc633 },
	'shadowtint' => { 387 => 'ShadowTint' },
	'shadowtone' => { 103 => 0x1040 },
	'shakereduction' => { 295 => 0x1, 296 => 0x1 },
	'sharpendetail' => { 387 => 'SharpenDetail' },
	'sharpenedgemasking' => { 387 => 'SharpenEdgeMasking' },
	'sharpening' => { 263 => 0x300b },
	'sharpeningadj' => { 224 => 0x2b },
	'sharpenradius' => { 387 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 30 => 0xf, 63 => 0x2, 93 => 0xb, 94 => [0x3011,0x21], 98 => [0xa40a,0xfe56], 103 => 0x1001, 114 => 0x6b, 123 => 0x37, 128 => 'Sharpness', 150 => 0x21, 151 => 0x30, 152 => 0x26, 153 => 0x18, 158 => 0x3, 185 => 0x6, 187 => 0x32, 246 => 0x100f, 261 => 0x41, 294 => 0x21, 300 => 0xb, 312 => 0x26, 315 => 0x22, 316 => [0x1003,0x1014], 325 => 0x11, 333 => 0x1c, 334 => 0x19, 345 => 0x2006, 368 => 0x52, 387 => 'Sharpness', 391 => 'Sharpness' },
	'sharpnessadj' => { 89 => 0x25a, 372 => 0x801a },
	'sharpnessauto' => { 60 => 0x94 },
	'sharpnessfactor' => { 246 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 59 => 0x64, 60 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 63 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 59 => 0x34, 60 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 59 => 0x7c, 60 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 59 => 0x4c, 60 => 0x4c },
	'sharpnessovershoot' => { 372 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 59 => 0x1c, 60 => 0x1c },
	'sharpnesssetting' => { 241 => 0x506, 249 => 0x1013, 335 => 0x12, 349 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 59 => 0x4, 60 => 0x4 },
	'sharpnessthreshold' => { 372 => 0x801d },
	'sharpnessundershoot' => { 372 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 59 => 0x94, 60 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 59 => 0xac, 60 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 59 => 0xc4, 60 => 0xdc },
	'shootid' => { 401 => 'shootID' },
	'shootinginfodisplay' => { 228 => '13.2', 229 => '5.1', 234 => '10.2', 235 => '4.1', 238 => '5.1', 239 => '5.3' },
	'shootinginfomonitorofftime' => { 228 => '26.2', 229 => '22.2', 234 => '9.1', 235 => '21.2', 238 => '22.2', 239 => '22.2' },
	'shootingmode' => { 128 => 'ShootingMode', 185 => 0x89, 261 => 0x1f },
	'shootingmodesetting' => { 230 => '5.1' },
	'shortdescription' => { 389 => 'shortdescription' },
	'shortdocumentid' => { 106 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 71 => 0x80d },
	'shotdate' => { 412 => 'shotDate' },
	'shotday' => { 412 => 'shotDay' },
	'shotlocation' => { 412 => 'shotLocation' },
	'shotname' => { 412 => 'shotName' },
	'shotnumber' => { 412 => 'shotNumber' },
	'shotnumbersincepowerup' => { 348 => 0x44e, 360 => 0x1a, 361 => 0x16, 362 => 0xa },
	'shotnumbersincepowerup2' => { 335 => 0x200 },
	'shotsize' => { 412 => 'shotSize' },
	'shutter-aelock' => { 69 => 0x4, 71 => 0x701, 72 => 0x3, 73 => 0x4, 74 => 0x3, 75 => 0x3, 76 => 0x4, 77 => 0x2 },
	'shutteraelbutton' => { 70 => 0x4 },
	'shutterbuttonafonbutton' => { 71 => 0x701 },
	'shuttercount' => { 10 => 0x176, 47 => 0x1, 185 => 0xa7, 192 => [0x6a,0x157,0x24d], 193 => 0x286, 194 => 0x279, 195 => 0x284, 196 => 0x242, 197 => 0x280, 198 => 0x276, 199 => [0x27d,0x27f], 200 => 0x246, 202 => 0x2d6, 203 => 0x321, 204 => 0xbd8, 205 => 0x287, 206 => 0x320, 207 => 0x24a, 208 => 0x5fb, 210 => 0x2d5, 294 => 0x5d, 344 => 0x846, 347 => [0x125,0x14a] },
	'shuttercurtainsync' => { 69 => 0xf, 70 => 0xf, 71 => 0x305, 72 => 0xe, 73 => 0xf, 74 => 0x8, 75 => 0x8, 76 => 0xf, 77 => 0x8 },
	'shuttermode' => { 114 => 0x1b },
	'shutterreleasebuttonae-l' => { 228 => '17.7', 229 => '18.4', 231 => '16.1', 232 => '17.1', 233 => '17.1', 234 => '7.1', 235 => '17.5', 238 => '18.4', 239 => '18.2' },
	'shutterreleasemethod' => { 84 => 0x1010 },
	'shutterreleasenocfcard' => { 69 => 0x2, 70 => 0x2, 77 => 0xf },
	'shutterreleasetiming' => { 84 => 0x1011 },
	'shutterreleasewithoutlens' => { 71 => 0x711 },
	'shutterspeedlock' => { 229 => '38.1', 238 => '38.1' },
	'shutterspeedrange' => { 71 => 0x10c },
	'shutterspeedsetting' => { 153 => 0x6, 333 => 0x2f, 334 => 0x28, 335 => 0x0 },
	'shutterspeedvalue' => { 80 => 0x1, 98 => 0x9201, 246 => 0x1000, 391 => 'ShutterSpeedValue' },
	'shuttertype' => { 103 => 0x1050, 261 => 0x9f },
	'sidecarforextension' => { 399 => 'SidecarForExtension' },
	'similarityindex' => { 106 => 0xe4 },
	'singleframebracketing' => { 153 => 0x21 },
	'skilllevel' => { 404 => 'skillLevel' },
	'slaveflashmeteringsegments' => { 294 => 0x20b },
	'slideshowname' => { 401 => 'slideshowName' },
	'slideshownumber' => { 401 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 401 => 'slideshowTotalNumber' },
	'slowshutter' => { 65 => 0x8 },
	'slowsync' => { 103 => 0x1030 },
	'smartrange' => { 322 => 0xa012 },
	'smileshutter' => { 335 => 0x31 },
	'smileshuttermode' => { 335 => 0x27 },
	'smoothness' => { 98 => 0xfe57, 387 => 'Smoothness' },
	'softskineffect' => { 345 => 0x200f },
	'software' => { 98 => 0x131, 129 => 'Software', 253 => 'Software', 325 => 0x18, 408 => 'Software' },
	'softwareversion' => { 324 => 0x207 },
	'sonydatetime' => { 351 => 0x6, 353 => 0x1b6, 354 => 0x210, 355 => 0x1fe, 356 => 0x22c },
	'sonydatetime2' => { 359 => 0x51 },
	'sonyexposuretime' => { 359 => 0x3a },
	'sonyexposuretime2' => { 368 => 0xe },
	'sonyfnumber' => { 359 => 0x3c, 368 => 0x14 },
	'sonyimageheight' => { 351 => 0x1a, 360 => 0x44, 361 => 0x3f, 362 => 0x47 },
	'sonyimagesize' => { 153 => 0x3b, 333 => 0x54, 334 => 0x54, 335 => 0x9 },
	'sonyimagewidth' => { 351 => 0x1c },
	'sonyiso' => { 353 => 0x1218, 354 => 0x11f4, 355 => 0x1270, 356 => [0x1254,0x1258,0x1280], 357 => 0x113c, 358 => 0x344, 368 => 0x4 },
	'sonymaxaperturevalue' => { 368 => 0x16 },
	'sonymodelid' => { 345 => 0xb001 },
	'sonyquality' => { 153 => 0x3c },
	'source' => { 106 => 0x73, 253 => 'Source', 388 => 'source', 389 => 'source', 399 => 'Source' },
	'sourcedirectoryindex' => { 281 => 0x0 },
	'sourcefileindex' => { 281 => 0x2 },
	'sourcephotoscount' => { 376 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 391 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 391 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 391 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 391 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 391 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 412 => 'speakerPlacement' },
	'specialeffectlevel' => { 94 => 0x3030 },
	'specialeffectmode' => { 94 => 0x2076 },
	'specialeffectsetting' => { 94 => 0x3031 },
	'specialinstructions' => { 106 => 0x28 },
	'specialmode' => { 246 => 0x200, 324 => 0x200 },
	'specialoccasion' => { 404 => 'specialOccasion' },
	'spectralsensitivity' => { 98 => 0x8824, 391 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 37 => [0x2b9,0x2d0,0x2d4], 39 => 0x1e4, 40 => [0x1fd,0x2dd] },
	'splittoningbalance' => { 387 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 387 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 387 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 387 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 387 => 'SplitToningShadowSaturation' },
	'sport' => { 402 => 'sport' },
	'spotfocuspointx' => { 150 => 0x2d },
	'spotfocuspointy' => { 150 => 0x2e },
	'spotmeteringmode' => { 30 => 0x27 },
	'spotmeterlinktoafpoint' => { 71 => 0x107 },
	'sractive' => { 275 => '17.1' },
	'srawquality' => { 30 => 0x2e },
	'srfocallength' => { 295 => 0x3 },
	'srhalfpresstime' => { 295 => 0x2 },
	'srresult' => { 295 => 0x0, 296 => 0x0 },
	'standardoutputhighlightpoint' => { 90 => 0x14 },
	'standardoutputsensitivity' => { 98 => 0x8831, 392 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 90 => 0x15 },
	'standardrawcolortone' => { 90 => 0xd },
	'standardrawcontrast' => { 90 => 0xf },
	'standardrawhighlight' => { 90 => 0x75 },
	'standardrawhighlightpoint' => { 90 => 0x12 },
	'standardrawlinear' => { 90 => 0x10 },
	'standardrawsaturation' => { 90 => 0xe },
	'standardrawshadow' => { 90 => 0x7e },
	'standardrawshadowpoint' => { 90 => 0x13 },
	'standardrawsharpness' => { 90 => 0x11 },
	'standardunsharpmaskfineness' => { 90 => 0x94 },
	'standardunsharpmaskstrength' => { 90 => 0x92 },
	'standardunsharpmaskthreshold' => { 90 => 0x96 },
	'standbytimer' => { 229 => '19.1', 233 => '18.1', 238 => '19.1' },
	'startingpage' => { 402 => 'startingPage' },
	'startmovieshooting' => { 71 => 0x70d },
	'starttimecode' => { 412 => 'startTimecode' },
	'starttimecodetimeformat' => { 412 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 412 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 412 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 412 => 'startTimeSampleSize' },
	'starttimescale' => { 412 => 'startTimeScale' },
	'state' => { 133 => 'State', 261 => 0x6b, 399 => 'State' },
	'status' => { 375 => 'Status', 379 => 'Status' },
	'stitchingsoftware' => { 376 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 352 => 0x113e, 353 => 0x113e, 354 => 0x111a, 355 => 0x1196, 356 => 0x1172, 357 => 0x102a, 358 => 0x222, 368 => 0xa },
	'storagemethod' => { 157 => 0x12 },
	'storebyorientation' => { 229 => '46.3', 238 => '47.3' },
	'straightenangle' => { 221 => 0x2fc08431 },
	'stretchmode' => { 412 => 'stretchMode' },
	'studydatetime' => { 374 => 'StudyDateTime' },
	'studydescription' => { 374 => 'StudyDescription' },
	'studyid' => { 374 => 'StudyID' },
	'studyphysician' => { 374 => 'StudyPhysician' },
	'sub-location' => { 106 => 0x5c },
	'subfiledata' => { 136 => 'data' },
	'subfiledirectory' => { 136 => '1Directory' },
	'subfilemimetype' => { 136 => '2MIME' },
	'subfilename' => { 136 => '1Name' },
	'subfileresource' => { 136 => 'rsrc' },
	'subfiletype' => { 98 => 0xfe, 136 => '0Type' },
	'subject' => { 250 => 'Subject', 307 => 'Subject', 388 => 'subject', 398 => 'Subject', 413 => 'subject' },
	'subjectarea' => { 98 => 0x9214, 391 => 'SubjectArea' },
	'subjectcode' => { 396 => 'SubjectCode' },
	'subjectdistance' => { 98 => 0x9206, 114 => 0x3e, 391 => 'SubjectDistance' },
	'subjectdistancerange' => { 98 => 0xa40c, 391 => 'SubjectDistanceRange' },
	'subjectlocation' => { 98 => 0xa214, 391 => 'SubjectLocation' },
	'subjectprogram' => { 150 => 0x22 },
	'subjectreference' => { 106 => 0xc },
	'sublabels4' => { 395 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 395 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 395 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 395 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 395 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subsectime' => { 98 => 0x9290 },
	'subsectimedigitized' => { 98 => 0x9292 },
	'subsectimeoriginal' => { 98 => 0x9291 },
	'subsection1' => { 402 => 'subsection1' },
	'subsection2' => { 402 => 'subsection2' },
	'subsection3' => { 402 => 'subsection3' },
	'subsection4' => { 402 => 'subsection4' },
	'subselector' => { 229 => '49.1' },
	'subselectorassignment' => { 229 => '48.1' },
	'subselectorplusdials' => { 229 => '49.2' },
	'subtitle' => { 402 => 'subtitle' },
	'subversionfilename' => { 395 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 395 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 395 => 'SubVersions' },
	'superimposeddisplay' => { 69 => 0xa, 71 => 0x510, 72 => 0x9, 73 => 0xa, 76 => 0xa, 77 => 0xe },
	'supermacro' => { 53 => 0x1a },
	'supplementalcategories' => { 106 => 0x14, 399 => 'SupplementalCategories' },
	'supplementaltype' => { 108 => 0x37 },
	'supplementdisplayid' => { 402 => 'supplementDisplayID' },
	'supplementstartingpage' => { 402 => 'supplementStartingPage' },
	'supplementtitle' => { 402 => 'supplementTitle' },
	'svisosetting' => { 275 => 0x14 },
	'sweeppanoramadirection' => { 261 => 0x93, 335 => 0x33 },
	'sweeppanoramafieldofview' => { 261 => 0x94 },
	'sweeppanoramasize' => { 335 => 0x32 },
	'switchtoregisteredafpoint' => { 70 => 0x12, 71 => 0x50a },
	'tagged' => { 302 => 0xdd, 303 => 'Tagged', 381 => 'tagged' },
	'tagslist' => { 390 => 'TagsList' },
	'tagstructure' => { 395 => 'TagStructure' },
	'takenumber' => { 412 => 'takeNumber' },
	'tapename' => { 412 => 'tapeName' },
	'targetaperture' => { 65 => 0x4 },
	'targetcompressionratio' => { 82 => 0x1 },
	'targetdistancesetting' => { 84 => 0x1807 },
	'targetexposuretime' => { 65 => 0x5 },
	'targetimagetype' => { 84 => 0x100a },
	'taxon' => { 97 => 'Taxon' },
	'taxonacceptednameusage' => { 97 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 97 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 97 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 97 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 97 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 97 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 97 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 97 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 97 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 97 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 97 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 97 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 97 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 97 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 97 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 97 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 97 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 97 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 97 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 97 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 97 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 97 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 97 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 97 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 97 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 97 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 97 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 97 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 97 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 97 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 97 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 97 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 97 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 402 => 'teaser' },
	'teleconverter' => { 155 => 0x105, 345 => 0x105 },
	'tempo' => { 412 => 'tempo' },
	'termsandconditionstext' => { 400 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 400 => 'TermsAndConditionsURL' },
	'testname' => { 99 => 'TestName' },
	'textencoding' => { 184 => 0x4 },
	'textlayername' => { 399 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 399 => 'TextLayers' },
	'textlayertext' => { 399 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 261 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 98 => 0x107 },
	'thumbnailfilename' => { 84 => 0x817 },
	'thumbnailformat' => { 410 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 116 => 0xfa55, 410 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 84 => 0x2008, 95 => 'ThumbnailImage', 101 => 0x3, 139 => 'data', 246 => 0x100, 410 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 139 => '1Name' },
	'thumbnailimagesize' => { 139 => 'ImageSize' },
	'thumbnailimagetype' => { 139 => '0Type' },
	'thumbnailimagevalidarea' => { 53 => 0x13 },
	'thumbnaillength' => { 98 => 0x202 },
	'thumbnailoffset' => { 98 => 0x201 },
	'thumbnails' => { 410 => 'Thumbnails' },
	'thumbnailwidth' => { 116 => 0xfa54, 410 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 402 => 'ticker' },
	'tiffmeteringimage' => { 156 => 0x104c, 344 => 0x1110 },
	'tilelength' => { 98 => 0x143 },
	'tilewidth' => { 98 => 0x142 },
	'time' => { 112 => 0x401, 294 => 0x7 },
	'timecodes' => { 98 => 0xc763 },
	'timecreated' => { 106 => 0x3c, 114 => 0x14, 123 => 0x10, 303 => 'TimeCreated' },
	'timeperiod' => { 402 => 'timePeriod' },
	'timerfunctionbutton' => { 230 => '5.2', 231 => '12.1', 232 => '13.1' },
	'timerlength' => { 71 => 0x80c },
	'timerrecording' => { 261 => 0x96 },
	'timescaleparams' => { 412 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 412 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 412 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 412 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 107 => 0x50 },
	'timesignature' => { 412 => 'timeSignature' },
	'timesincepoweron' => { 261 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 240 => 0x8, 253 => 'TimeStamp', 382 => 'Timestamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 66 => 0x1, 213 => 0x0 },
	'timezonecity' => { 66 => 0x2 },
	'timezonecode' => { 87 => 0x1 },
	'timezoneinfo' => { 87 => 0x2 },
	'timezoneoffset' => { 98 => 0x882a },
	'tint' => { 387 => 'Tint' },
	'title' => { 129 => 'Title', 250 => 'Title', 253 => 'Title', 261 => 0x65, 307 => 'Title', 388 => 'title', 398 => 'Title', 410 => 'Title' },
	'tonecomp' => { 185 => 0x81 },
	'tonecurve' => { 63 => 0x1, 294 => 0x402, 387 => 'ToneCurve' },
	'tonecurveactive' => { 89 => 0x110 },
	'tonecurveadobergb' => { 322 => 0xa043 },
	'tonecurveadobergbdefault' => { 322 => 0xa041 },
	'tonecurveblue' => { 387 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 372 => 0x9003 },
	'tonecurvebluey' => { 372 => 0x9007 },
	'tonecurvebrightnessx' => { 372 => 0x9000 },
	'tonecurvebrightnessy' => { 372 => 0x9004 },
	'tonecurvefilename' => { 112 => 0x1391 },
	'tonecurvegreen' => { 387 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 372 => 0x9002 },
	'tonecurvegreeny' => { 372 => 0x9006 },
	'tonecurveinterpolation' => { 89 => 0x159 },
	'tonecurvemode' => { 89 => 0x113 },
	'tonecurvename' => { 387 => 'ToneCurveName' },
	'tonecurvename2012' => { 387 => 'ToneCurveName2012' },
	'tonecurveproperty' => { 89 => 0x3c },
	'tonecurvepv2012' => { 387 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 387 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 387 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 387 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 387 => 'ToneCurveRed' },
	'tonecurveredx' => { 372 => 0x9001 },
	'tonecurveredy' => { 372 => 0x9005 },
	'tonecurves' => { 294 => 0x403 },
	'tonecurvesrgb' => { 322 => 0xa042 },
	'tonecurvesrgbdefault' => { 322 => 0xa040 },
	'tonelevel' => { 241 => 0x52e },
	'toningeffect' => { 47 => 0xf, 185 => 0xb3, 187 => 0x38, 316 => 0x1015 },
	'toningeffectauto' => { 60 => 0xa4 },
	'toningeffectfaithful' => { 59 => 0x74, 60 => 0x74 },
	'toningeffectlandscape' => { 59 => 0x44, 60 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 59 => 0x8c, 60 => 0x8c },
	'toningeffectneutral' => { 59 => 0x5c, 60 => 0x5c },
	'toningeffectportrait' => { 59 => 0x2c, 60 => 0x2c },
	'toningeffectstandard' => { 59 => 0x14, 60 => 0x14 },
	'toningeffectuserdef1' => { 59 => 0xa4, 60 => 0xbc },
	'toningeffectuserdef2' => { 59 => 0xbc, 60 => 0xd4 },
	'toningeffectuserdef3' => { 59 => 0xd4, 60 => 0xec },
	'toningsaturation' => { 187 => 0x39 },
	'totalzoom' => { 114 => 0x62 },
	'touchae' => { 261 => 0xab },
	'trackcreatedate' => { 311 => 0x1 },
	'trackmodifydate' => { 311 => 0x2 },
	'tracknumber' => { 412 => 'trackNumber' },
	'tracks' => { 412 => 'Tracks' },
	'tracksframerate' => { 412 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 412 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 412 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 412 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 412 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 412 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 412 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 412 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 412 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 412 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 412 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 412 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 412 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 412 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 412 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 412 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 412 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 136 => 'zmie' },
	'transferfunction' => { 98 => 0x12d, 408 => 'TransferFunction' },
	'transform' => { 261 => [0x8012,0x59] },
	'transmissionreference' => { 399 => 'TransmissionReference' },
	'trapped' => { 250 => 'Trapped', 398 => 'Trapped' },
	'trashbuttonfunction' => { 71 => 0x710 },
	'travelday' => { 261 => 0x36 },
	'triggermode' => { 312 => 0x6 },
	'tstop' => { 98 => 0xc772 },
	'ttl_da_adown' => { 282 => 0x5 },
	'ttl_da_aup' => { 282 => 0x4 },
	'ttl_da_bdown' => { 282 => 0x7 },
	'ttl_da_bup' => { 282 => 0x6 },
	'tungstenawb' => { 272 => 0x1 },
	'tvexposuretimesetting' => { 275 => 0x12 },
	'type' => { 388 => 'type', 407 => 'type' },
	'typestatus' => { 97 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 98 => 0xc614 },
	'uniquedocumentid' => { 106 => 0xbb },
	'uniqueobjectname' => { 107 => 0x64 },
	'unknownblock' => { 294 => 0x405 },
	'unknownblock1' => { 245 => 0x635 },
	'unknownblock2' => { 245 => 0x636 },
	'unknownblock3' => { 245 => 0x1103 },
	'unknownblock4' => { 245 => 0x1104 },
	'unknowncontrast' => { 90 => 0x45 },
	'unknownev' => { 112 => 0x1 },
	'unknownlinear' => { 90 => 0x46 },
	'unknownnumber' => { 84 => 0x180b },
	'unknownoutputhighlightpoint' => { 90 => 0x4a },
	'unknownoutputshadowpoint' => { 90 => 0x4b },
	'unknownrawhighlight' => { 90 => 0x7b },
	'unknownrawhighlightpoint' => { 90 => 0x48 },
	'unknownrawshadow' => { 90 => 0x84 },
	'unknownrawshadowpoint' => { 90 => 0x49 },
	'unknownsharpness' => { 90 => 0x47 },
	'unknowntemperature' => { 100 => 0x4 },
	'unsharp1color' => { 226 => 0x13 },
	'unsharp1halowidth' => { 226 => 0x19 },
	'unsharp1intensity' => { 226 => 0x17 },
	'unsharp1threshold' => { 226 => 0x1b },
	'unsharp2color' => { 226 => 0x2e },
	'unsharp2halowidth' => { 226 => 0x34 },
	'unsharp2intensity' => { 226 => 0x32 },
	'unsharp2threshold' => { 226 => 0x36 },
	'unsharp3color' => { 226 => 0x49 },
	'unsharp3halowidth' => { 226 => 0x4f },
	'unsharp3intensity' => { 226 => 0x4d },
	'unsharp3threshold' => { 226 => 0x51 },
	'unsharp4color' => { 226 => 0x64 },
	'unsharp4halowidth' => { 226 => 0x6a },
	'unsharp4intensity' => { 226 => 0x68 },
	'unsharp4threshold' => { 226 => 0x6c },
	'unsharpcount' => { 226 => 0x0 },
	'unsharpmask' => { 90 => 0x90, 221 => 0x76a43200 },
	'uprightcentermode' => { 387 => 'UprightCenterMode' },
	'uprightcenternormx' => { 387 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 387 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 387 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 387 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 387 => 'UprightFocalMode' },
	'uprightpreview' => { 387 => 'UprightPreview' },
	'uprighttransform_0' => { 387 => 'UprightTransform_0' },
	'uprighttransform_1' => { 387 => 'UprightTransform_1' },
	'uprighttransform_2' => { 387 => 'UprightTransform_2' },
	'uprighttransform_3' => { 387 => 'UprightTransform_3' },
	'uprighttransform_4' => { 387 => 'UprightTransform_4' },
	'uprighttransformcount' => { 387 => 'UprightTransformCount' },
	'uprightversion' => { 387 => 'UprightVersion' },
	'urgency' => { 106 => 0xa, 399 => 'Urgency' },
	'url' => { 129 => 'URL', 253 => 'URL', 305 => 0x40b, 402 => 'url' },
	'urla-platform' => { 402 => [\'url','urlA-platform'] },
	'urlurl' => { 402 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 71 => 0x10a },
	'usableshootingmodes' => { 71 => 0x109 },
	'usage' => { 403 => 'usage' },
	'usageterms' => { 416 => 'UsageTerms' },
	'useguidelines' => { 384 => 'useGuidelines' },
	'usepanoramaviewer' => { 376 => 'UsePanoramaViewer' },
	'usercomment' => { 84 => 0x805, 98 => 0x9286, 391 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 59 => 0xd8, 60 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 59 => 0xda, 60 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 59 => 0xdc, 60 => 0xf4 },
	'userfields' => { 379 => 'UserFields' },
	'userlabel' => { 312 => 0x2b },
	'userprofile' => { 257 => 0x302, 263 => 0x3038 },
	'usmlenselectronicmf' => { 70 => 0x7, 71 => 0x501 },
	'uspsnumber' => { 402 => 'uspsNumber' },
	'utmeasting' => { 140 => 'Easting' },
	'utmmapdatum' => { 140 => 'Datum' },
	'utmnorthing' => { 140 => 'Northing' },
	'utmzone' => { 140 => 'Zone' },
	'uv-irfiltercorrection' => { 257 => 0x325 },
	'validbits' => { 245 => 0x611, 246 => 0x102c },
	'validpixeldepth' => { 249 => 0x611 },
	'variousmodes' => { 114 => 0x26 },
	'variousmodes2' => { 114 => 0x3a },
	'variprogram' => { 185 => 0xab },
	'version' => { 103 => 0x0, 307 => 'Version', 387 => 'Version' },
	'versioncreatedate' => { 372 => 0xd100 },
	'versionid' => { 413 => 'VersionID' },
	'versionidentifier' => { 402 => 'versionIdentifier' },
	'versionmodifydate' => { 372 => 0xd101 },
	'versions' => { 413 => 'Versions' },
	'versionscomments' => { 413 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 413 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 413 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 413 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 413 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 413 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 413 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 413 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 413 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 413 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 413 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 228 => '3.2', 229 => '47.2' },
	'verticalfuncbutton' => { 229 => '42.2' },
	'verticalfuncbuttonplusdials' => { 229 => '43.1' },
	'verticalmultiselector' => { 229 => '42.1' },
	'vfdisplayillumination' => { 71 => 0x510 },
	'vibrance' => { 380 => 'Vibrance', 387 => 'Vibrance' },
	'vibrationreduction' => { 192 => [0x75,0x82,0x1ae], 200 => '586.1', 207 => '590.2', 212 => 0x4 },
	'videoalphamode' => { 412 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 412 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 412 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 412 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 412 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 412 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 412 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 412 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 412 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 412 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 412 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 412 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 412 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 412 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 412 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 412 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 412 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 56 => 0x74 },
	'videocolorspace' => { 412 => 'videoColorSpace' },
	'videocompressor' => { 412 => 'videoCompressor' },
	'videofieldorder' => { 412 => 'videoFieldOrder' },
	'videoframerate' => { 412 => 'videoFrameRate' },
	'videoframesize' => { 412 => 'videoFrameSize' },
	'videoframesizeh' => { 412 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 412 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 412 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 412 => 'videoModDate' },
	'videopixelaspectratio' => { 412 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 412 => 'videoPixelDepth' },
	'videoquality' => { 94 => 0x4003 },
	'viewfinderdisplay' => { 228 => '12.4', 229 => '6.3' },
	'viewfinderwarning' => { 228 => '13.4', 235 => '3.5', 236 => '6.2', 239 => '4.4' },
	'viewfinderwarnings' => { 71 => 0x40a },
	'viewinfoduringexposure' => { 71 => 0x407 },
	'viewingmode' => { 335 => 0x2f, 349 => 0x18 },
	'viewingmode2' => { 335 => [0x85,0x285] },
	'viewpoint' => { 401 => 'viewpoint' },
	'vignetteamount' => { 387 => 'VignetteAmount' },
	'vignettecontrol' => { 185 => 0x2a, 221 => 0x76a43205 },
	'vignettecontrolintensity' => { 221 => 0xac6bd5c0 },
	'vignettemidpoint' => { 387 => 'VignetteMidpoint' },
	'vignetting' => { 316 => 0x1011, 322 => 0xa052 },
	'vignettingcorrection' => { 284 => 0x2, 322 => 0xa053, 345 => 0x2011 },
	'vignettingsetting' => { 322 => 0xa054 },
	'visualtechnique' => { 401 => 'visualTechnique' },
	'voicememo' => { 324 => 0x216 },
	'volume' => { 402 => 'volume' },
	'vr_0x66' => { 192 => 0x66 },
	'vrdoffset' => { 53 => 0xd0 },
	'vrmode' => { 212 => 0x6 },
	'wb_bluelevel3500k' => { 156 => 0x19a },
	'wb_bluelevel6500k' => { 156 => 0x18a },
	'wb_bluelevelcustom' => { 156 => 0x18e },
	'wb_bluelevelscloudy' => { 156 => 0x106 },
	'wb_bluelevelsdaylight' => { 156 => 0xea },
	'wb_bluelevelsflash' => { 156 => 0x122 },
	'wb_bluelevelsfluorescent' => { 156 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 156 => 0x254 },
	'wb_bluelevelsshade' => { 156 => 0x176 },
	'wb_bluelevelstungsten' => { 156 => 0xce },
	'wb_gbrglevels' => { 156 => 0xae, 159 => 0x4 },
	'wb_glevel' => { 245 => 0x11f },
	'wb_glevel3000k' => { 245 => 0x113 },
	'wb_glevel3300k' => { 245 => 0x114 },
	'wb_glevel3600k' => { 245 => 0x115 },
	'wb_glevel3900k' => { 245 => 0x116 },
	'wb_glevel4000k' => { 245 => 0x117 },
	'wb_glevel4300k' => { 245 => 0x118 },
	'wb_glevel4500k' => { 245 => 0x119 },
	'wb_glevel4800k' => { 245 => 0x11a },
	'wb_glevel5300k' => { 245 => 0x11b },
	'wb_glevel6000k' => { 245 => 0x11c },
	'wb_glevel6600k' => { 245 => 0x11d },
	'wb_glevel7500k' => { 245 => 0x11e },
	'wb_grbglevels' => { 168 => 0x0 },
	'wb_rbgglevels' => { 165 => 0x0 },
	'wb_rblevels' => { 185 => 0xc, 245 => 0x100 },
	'wb_rblevels1' => { 266 => 0x2 },
	'wb_rblevels2' => { 266 => 0x5 },
	'wb_rblevels3' => { 266 => 0x8 },
	'wb_rblevels3000k' => { 245 => 0x102 },
	'wb_rblevels3300k' => { 245 => 0x103 },
	'wb_rblevels3500k' => { 156 => 0x430 },
	'wb_rblevels3600k' => { 245 => 0x104 },
	'wb_rblevels3900k' => { 245 => 0x105 },
	'wb_rblevels4' => { 266 => 0xb },
	'wb_rblevels4000k' => { 245 => 0x106 },
	'wb_rblevels4300k' => { 245 => 0x107 },
	'wb_rblevels4500k' => { 245 => 0x108 },
	'wb_rblevels4800k' => { 245 => 0x109 },
	'wb_rblevels5' => { 266 => 0xe },
	'wb_rblevels5300k' => { 245 => 0x10a },
	'wb_rblevels6' => { 266 => 0x11 },
	'wb_rblevels6000k' => { 245 => 0x10b },
	'wb_rblevels6500k' => { 156 => 0x420 },
	'wb_rblevels6600k' => { 245 => 0x10c },
	'wb_rblevels7' => { 266 => 0x14 },
	'wb_rblevels7500k' => { 245 => 0x10d },
	'wb_rblevelsauto' => { 249 => 0x110 },
	'wb_rblevelscloudy' => { 156 => 0x3f0, 158 => 0x10, 249 => 0x121 },
	'wb_rblevelscoolwhitef' => { 156 => 0x308, 158 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 249 => 0x132 },
	'wb_rblevelscustom' => { 156 => 0x424 },
	'wb_rblevelscwb1' => { 245 => 0x10e },
	'wb_rblevelscwb2' => { 245 => 0x10f },
	'wb_rblevelscwb3' => { 245 => 0x110 },
	'wb_rblevelscwb4' => { 245 => 0x111 },
	'wb_rblevelsdaylight' => { 156 => [0x3ec,0x528], 158 => 0xc },
	'wb_rblevelsdaylightf' => { 158 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 249 => 0x130 },
	'wb_rblevelsdaywhitef' => { 158 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 249 => 0x131 },
	'wb_rblevelseveningsunlight' => { 249 => 0x124 },
	'wb_rblevelsfineweather' => { 249 => 0x122 },
	'wb_rblevelsflash' => { 156 => [0x3f4,0x304], 158 => 0x18 },
	'wb_rblevelsshade' => { 156 => 0x418, 158 => 0x20, 249 => 0x120 },
	'wb_rblevelstungsten' => { 156 => 0x3e8, 158 => 0x8, 249 => 0x123 },
	'wb_rblevelsunknown' => { 158 => 0x1c },
	'wb_rblevelsused' => { 249 => 0x100 },
	'wb_rblevelswhitef' => { 158 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 249 => 0x133 },
	'wb_redlevel3500k' => { 156 => 0x198 },
	'wb_redlevel6500k' => { 156 => 0x188 },
	'wb_redlevelcustom' => { 156 => 0x18c },
	'wb_redlevelscloudy' => { 156 => 0xf8 },
	'wb_redlevelsdaylight' => { 156 => 0xdc },
	'wb_redlevelsflash' => { 156 => 0x114 },
	'wb_redlevelsfluorescent' => { 156 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 156 => 0x1be },
	'wb_redlevelsshade' => { 156 => 0x168 },
	'wb_redlevelstungsten' => { 156 => 0xc0 },
	'wb_rgbglevels' => { 167 => 0x0 },
	'wb_rgblevels' => { 156 => [0x546,0x96], 258 => 0xd, 259 => 0x413, 263 => 0x3036, 352 => 0x117c, 353 => 0x1180, 354 => 0x115c, 355 => 0x11d8, 356 => 0x11b4, 357 => 0x106c, 358 => 0x264 },
	'wb_rgblevels1' => { 267 => 0x2 },
	'wb_rgblevels2' => { 267 => 0x6 },
	'wb_rgblevels3' => { 267 => 0xa },
	'wb_rgblevels4' => { 267 => 0xe },
	'wb_rgblevels5' => { 267 => 0x12 },
	'wb_rgblevels6' => { 267 => 0x16 },
	'wb_rgblevels7' => { 267 => 0x1a },
	'wb_rggbblacklevels' => { 31 => 0x25 },
	'wb_rggblevels' => { 159 => 0x4, 166 => 0x0 },
	'wb_rggblevelsasshot' => { 33 => 0x0, 34 => 0x19, 35 => 0x22, 36 => 0x3f, 39 => 0x3f, 40 => 0x3f },
	'wb_rggblevelsauto' => { 31 => 0x1, 33 => 0x5, 34 => 0x1e, 35 => 0x18, 36 => 0x44, 39 => 0x44, 40 => 0x44, 322 => 0xa022 },
	'wb_rggblevelsblack' => { 322 => 0xa028 },
	'wb_rggblevelscloudy' => { 31 => 0xd, 33 => 0x1e, 34 => 0x2d, 35 => 0x31, 36 => 0x58, 39 => 0x71, 40 => 0x8a, 294 => 0x20f, 301 => 0x14 },
	'wb_rggblevelscustom' => { 31 => 0x1d, 36 => 0x80 },
	'wb_rggblevelscustom1' => { 34 => 0x41 },
	'wb_rggblevelscustom2' => { 34 => 0x46 },
	'wb_rggblevelsdaylight' => { 31 => 0x5, 33 => 0x14, 34 => 0x23, 35 => 0x27, 36 => 0x4e, 39 => 0x67, 40 => 0x80, 294 => 0x20d, 301 => 0x2 },
	'wb_rggblevelsflash' => { 31 => 0x19, 33 => 0x32, 34 => 0x3c, 35 => 0x45, 36 => 0x6c, 39 => 0x85, 40 => 0x9e, 294 => 0x214, 301 => 0x41 },
	'wb_rggblevelsfluorescent' => { 31 => 0x15, 33 => 0x28, 34 => 0x37, 35 => 0x3b, 36 => 0x62, 39 => 0x7b, 40 => 0x94 },
	'wb_rggblevelsfluorescentd' => { 294 => 0x211, 301 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 301 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 294 => 0x212, 301 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 294 => 0x213, 301 => 0x38 },
	'wb_rggblevelsilluminator1' => { 322 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 322 => 0xa024 },
	'wb_rggblevelskelvin' => { 31 => 0x21, 33 => 0x2d, 35 => 0x40, 36 => 0x67, 39 => 0x80, 40 => 0x99 },
	'wb_rggblevelsmeasured' => { 33 => 0xa, 36 => 0x49, 39 => 0x49, 40 => 0x49 },
	'wb_rggblevelspc1' => { 35 => 0x90, 36 => 0x71 },
	'wb_rggblevelspc2' => { 35 => 0x95, 36 => 0x76 },
	'wb_rggblevelspc3' => { 35 => 0x9a, 36 => 0x7b },
	'wb_rggblevelsshade' => { 31 => 0x9, 33 => 0x19, 34 => 0x28, 35 => 0x2c, 36 => 0x53, 39 => 0x6c, 40 => 0x85, 294 => 0x20e, 301 => 0xb },
	'wb_rggblevelstungsten' => { 31 => 0x11, 33 => 0x23, 34 => 0x32, 35 => 0x36, 36 => 0x5d, 39 => 0x76, 40 => 0x8f, 294 => 0x210, 301 => 0x1d },
	'wb_rggblevelsuncorrected' => { 322 => 0xa021 },
	'wb_rggblevelsunknown' => { 33 => 0xf, 35 => 0x1d, 39 => 0x4e, 40 => 0x4e, 301 => 0x53 },
	'wb_rggblevelsunknown10' => { 33 => 0x5f, 35 => 0x72, 39 => 0x9e, 40 => 0x7b },
	'wb_rggblevelsunknown11' => { 33 => 0x64, 35 => 0x77, 39 => 0xa3, 40 => 0xa3 },
	'wb_rggblevelsunknown12' => { 33 => 0x69, 35 => 0x7c, 39 => 0xa8, 40 => 0xa8 },
	'wb_rggblevelsunknown13' => { 33 => 0x6e, 35 => 0x81, 39 => 0xad, 40 => 0xad },
	'wb_rggblevelsunknown14' => { 35 => 0x86, 39 => 0xb2, 40 => 0xb2 },
	'wb_rggblevelsunknown15' => { 35 => 0x8b, 39 => 0xb7, 40 => 0xb7 },
	'wb_rggblevelsunknown16' => { 35 => 0x9f, 40 => 0xbc },
	'wb_rggblevelsunknown17' => { 40 => 0xc1 },
	'wb_rggblevelsunknown18' => { 40 => 0xc6 },
	'wb_rggblevelsunknown19' => { 40 => 0xcb },
	'wb_rggblevelsunknown2' => { 33 => 0x37, 35 => 0x4a, 39 => 0x53, 40 => 0x53 },
	'wb_rggblevelsunknown20' => { 40 => 0xd0 },
	'wb_rggblevelsunknown3' => { 33 => 0x3c, 35 => 0x4f, 39 => 0x58, 40 => 0x58 },
	'wb_rggblevelsunknown4' => { 33 => 0x41, 35 => 0x54, 39 => 0x5d, 40 => 0x5d },
	'wb_rggblevelsunknown5' => { 33 => 0x46, 35 => 0x59, 39 => 0x62, 40 => 0x62 },
	'wb_rggblevelsunknown6' => { 33 => 0x4b, 35 => 0x5e, 39 => 0x8a, 40 => 0x67 },
	'wb_rggblevelsunknown7' => { 33 => 0x50, 35 => 0x63, 39 => 0x8f, 40 => 0x6c },
	'wb_rggblevelsunknown8' => { 33 => 0x55, 35 => 0x68, 39 => 0x94, 40 => 0x71 },
	'wb_rggblevelsunknown9' => { 33 => 0x5a, 35 => 0x6d, 39 => 0x99, 40 => 0x76 },
	'wb_rggblevelsuserselected' => { 301 => 0x5c },
	'wbadjbluebalance' => { 227 => 0x8 },
	'wbadjcolortemp' => { 89 => 0x1a },
	'wbadjlighting' => { 227 => 0x14 },
	'wbadjmode' => { 227 => 0x10 },
	'wbadjredbalance' => { 227 => 0x0 },
	'wbadjrggblevels' => { 89 => 0x6 },
	'wbadjtemperature' => { 227 => 0x18 },
	'wbadjtint' => { 227 => 0x25 },
	'wbbluelevel' => { 257 => 0x324, 261 => 0x8006, 265 => 0x26 },
	'wbbracketmode' => { 47 => 0x9 },
	'wbbracketshotnumber' => { 156 => 0x2b, 316 => 0x101a },
	'wbbracketvalueab' => { 47 => 0xc },
	'wbbracketvaluegm' => { 47 => 0xd },
	'wbfinetuneactive' => { 89 => 0x24 },
	'wbfinetunesaturation' => { 89 => 0x28 },
	'wbfinetunetone' => { 89 => 0x2c },
	'wbgreenlevel' => { 257 => 0x323, 261 => 0x8005, 265 => 0x25 },
	'wbmediaimagesizesetting' => { 71 => 0x708 },
	'wbmode' => { 158 => 0x4, 246 => 0x1015 },
	'wbredlevel' => { 257 => 0x322, 261 => 0x8004, 265 => 0x24 },
	'wbscale' => { 159 => 0x0 },
	'wbshiftab' => { 63 => 0xc, 261 => 0x46, 276 => 0x10 },
	'wbshiftab_gm' => { 345 => 0x2014 },
	'wbshiftgm' => { 63 => 0xd, 261 => 0x47, 276 => 0x11 },
	'wbtype1' => { 266 => 0x1, 267 => 0x1 },
	'wbtype2' => { 266 => 0x4, 267 => 0x5 },
	'wbtype3' => { 266 => 0x7, 267 => 0x9 },
	'wbtype4' => { 266 => 0xa, 267 => 0xd },
	'wbtype5' => { 266 => 0xd, 267 => 0x11 },
	'wbtype6' => { 266 => 0x10, 267 => 0x15 },
	'wbtype7' => { 266 => 0x13, 267 => 0x19 },
	'webstatement' => { 416 => 'WebStatement' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x77, 63 => 0x8, 65 => 0x7, 93 => 0x7, 94 => [0x19,0x2012], 98 => [0xa403,0xfe4e], 103 => 0x1002, 112 => 0x3fc, 113 => 0xfa0d, 114 => 0x40, 150 => 0x3, 151 => 0xe, 152 => 0x4, 153 => 0xb, 155 => 0x115, 185 => 0x5, 211 => 0x7, 257 => 0x304, 261 => 0x3, 263 => 0x3033, 294 => 0x19, 300 => 0x7, 315 => 0x26, 316 => 0x1003, 325 => [0x3c,0x7,0x58], 333 => 0xf, 334 => 0xe, 345 => [0x115,0xb054], 387 => 'WhiteBalance', 391 => 'WhiteBalance' },
	'whitebalance2' => { 241 => 0x500 },
	'whitebalanceadj' => { 89 => 0x18, 221 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 272 => 0x0 },
	'whitebalancebias' => { 94 => 0x2011, 246 => 0x304, 261 => 0x23 },
	'whitebalanceblue' => { 63 => 0x7 },
	'whitebalancebracket' => { 241 => 0x502, 246 => 0x303 },
	'whitebalancebracketing' => { 153 => 0x22, 156 => 0x2c, 344 => 0x2c },
	'whitebalancecomp' => { 249 => 0x1001 },
	'whitebalancefinetune' => { 103 => 0x100a, 153 => 0x38, 155 => 0x112, 185 => 0xb, 316 => 0x1004, 333 => 0x6, 334 => 0x5, 345 => 0x112 },
	'whitebalancemode' => { 294 => 0x1a },
	'whitebalancered' => { 63 => 0x6 },
	'whitebalanceset' => { 275 => 0xa },
	'whitebalancesetting' => { 153 => 0x23, 333 => 0x5, 334 => 0x4, 335 => 0x16, 349 => 0xd },
	'whitebalancetemperature' => { 241 => 0x501 },
	'whiteboard' => { 246 => 0x301 },
	'whitelevel' => { 98 => 0xc61d, 294 => 0x7e },
	'whitepoint' => { 98 => 0x13e, 294 => 0x201, 408 => 'WhitePoint' },
	'whites2012' => { 387 => 'Whites2012' },
	'wideadapter' => { 316 => 0x1017 },
	'widefocuszone' => { 150 => 0x2f },
	'widerange' => { 324 => 0x20f },
	'windowsatom' => { 386 => 'windowsAtom' },
	'windowsatomextension' => { 386 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 386 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 386 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 402 => 'wordCount' },
	'workcolorspace' => { 89 => 0x270 },
	'worktodo' => { 393 => 'WorkToDo' },
	'worldtimelocation' => { 261 => 0x3a, 294 => 0x22, 299 => '0.1' },
	'writer-editor' => { 106 => 0x7a },
	'x3filllight' => { 325 => 0x12 },
	'xml' => { 110 => 'xml ' },
	'xmp' => { 88 => 0xffff00f6, 99 => 'XMP' },
	'xmptoolkit' => { 409 => 'xmptk' },
	'xpauthor' => { 98 => 0x9c9d },
	'xpcomment' => { 98 => 0x9c9c },
	'xpkeywords' => { 98 => 0x9c9e },
	'xposition' => { 98 => 0x11e },
	'xpsubject' => { 98 => 0x9c9f },
	'xptitle' => { 98 => 0x9c9b },
	'xresolution' => { 98 => 0x11a, 109 => 0x3, 306 => 0x0, 408 => 'XResolution' },
	'xyresolution' => { 102 => 0x3 },
	'yawangle' => { 201 => 0x3513 },
	'ycbcrcoefficients' => { 98 => 0x211, 408 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 98 => 0x213, 408 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 98 => 0x212, 408 => 'YCbCrSubSampling' },
	'yearcreated' => { 114 => 0x10, 123 => 0xc },
	'yield' => { 404 => 'yield' },
	'yposition' => { 98 => 0x11f },
	'yresolution' => { 98 => 0x11b, 109 => 0x5, 306 => 0x4, 408 => 'YResolution' },
	'zonematching' => { 155 => 0x10a, 158 => [0x3a,0x4a], 345 => 0xb024 },
	'zonematchingmode' => { 153 => 0x14 },
	'zonematchingon' => { 152 => 0x75 },
	'zonematchingvalue' => { 333 => 0x1f },
	'zoomedpreviewlength' => { 246 => 0xf05 },
	'zoomedpreviewsize' => { 246 => 0xf06 },
	'zoomedpreviewstart' => { 246 => 0xf04 },
	'zoomsourcewidth' => { 30 => 0x24 },
	'zoomstepcount' => { 244 => 0x300, 246 => 0x100d },
	'zoomtargetwidth' => { 30 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointsinfocus1d' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'anim' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiotype' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachedfile' => 1,
	'attachedfiledata' => 1,
	'attachedfiledescription' => 1,
	'attachedfilemimetype' => 1,
	'attachedfilename' => 1,
	'attachedfilereferral' => 1,
	'attachedfileuid' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batteryinfo' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldata' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'block' => 1,
	'blockaddid' => 1,
	'blockadditional' => 1,
	'blockadditionalid' => 1,
	'blockadditions' => 1,
	'blockduration' => 1,
	'blockgroup' => 1,
	'blocklocation' => 1,
	'blockmore' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blockvirtual' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelpositions' => 1,
	'chapter' => 1,
	'chapteratom' => 1,
	'chaptercount' => 1,
	'chaptercountry' => 1,
	'chapterdisplay' => 1,
	'chapterflagenabled' => 1,
	'chapterflaghidden' => 1,
	'chapterlanguage' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'chapterphysicalequivalent' => 1,
	'chapterprocess' => 1,
	'chapterprocesscodecid' => 1,
	'chapterprocesscommand' => 1,
	'chapterprocessdata' => 1,
	'chapterprocessprivate' => 1,
	'chapterprocesstime' => 1,
	'chapters' => 1,
	'chaptersegmenteditionuid' => 1,
	'chaptersegmentuid' => 1,
	'chapterstring' => 1,
	'chaptertimeend' => 1,
	'chaptertimestart' => 1,
	'chaptertrack' => 1,
	'chaptertracknumber' => 1,
	'chaptertranslate' => 1,
	'chaptertranslatecodec' => 1,
	'chaptertranslateeditionuid' => 1,
	'chaptertranslateid' => 1,
	'chapteruid' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cluster' => 1,
	'clusterduration' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecdecodeall' => 1,
	'codecdownloadurl' => 1,
	'codecflavorid' => 1,
	'codecid' => 1,
	'codecinfourl' => 1,
	'codeclist' => 1,
	'codecname' => 1,
	'codecprivate' => 1,
	'codecsettings' => 1,
	'codecstate' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcompression' => 1,
	'contentcompressionalgorithm' => 1,
	'contentcompressionsettings' => 1,
	'contentcreatedate' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencoding' => 1,
	'contentencodingorder' => 1,
	'contentencodings' => 1,
	'contentencodingscope' => 1,
	'contentencodingtype' => 1,
	'contentencryption' => 1,
	'contentencryptionalgorithm' => 1,
	'contentencryptionkeyid' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentsignature' => 1,
	'contentsignaturealgorithm' => 1,
	'contentsignaturehashalgorithm' => 1,
	'contentsignaturekeyid' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc-32' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorappid' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cueblocknumber' => 1,
	'cueclusterposition' => 1,
	'cuecodecstate' => 1,
	'cuepoint' => 1,
	'cuerefcluster' => 1,
	'cuerefcodecstate' => 1,
	'cuereference' => 1,
	'cuerefnumber' => 1,
	'cuereftime' => 1,
	'cues' => 1,
	'cuesheet' => 1,
	'cuetime' => 1,
	'cuetrack' => 1,
	'cuetrackpositions' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custompicturestyledata' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultduration' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayheight' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunit' => 1,
	'displayunits' => 1,
	'displaywidth' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'doctypereadversion' => 1,
	'doctypeversion' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'ebmlheader' => 1,
	'ebmlmaxidlength' => 1,
	'ebmlmaxsizelength' => 1,
	'ebmlreadversion' => 1,
	'ebmlversion' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editionentry' => 1,
	'editionflagdefault' => 1,
	'editionflaghidden' => 1,
	'editionflagordered' => 1,
	'editionuid' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryptedblock' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firmwareversions' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formattedname' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geolocation' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lacenumber' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layercomps' => 1,
	'layergroupsenabledid' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxblockadditionid' => 1,
	'maxcache' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'minaperturevalue' => 1,
	'mincache' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'muxingapp' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nextfilename' => 1,
	'nexttrackid' => 1,
	'nextuid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputaudiosamplerate' => 1,
	'outputdataobjectlist' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'prevfilename' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'prevsize' => 1,
	'prevuid' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawformat' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referenceblock' => 1,
	'referencepriority' => 1,
	'referencetemperature' => 1,
	'referencevirtual' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seek' => 1,
	'seekable' => 1,
	'seekhead' => 1,
	'seekid' => 1,
	'seekpoint' => 1,
	'seekposition' => 1,
	'seektable' => 1,
	'segmentfamily' => 1,
	'segmentfilename' => 1,
	'segmentheader' => 1,
	'segmentuid' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorleftmargin' => 1,
	'sensorrightborder' => 1,
	'sensortemperature2' => 1,
	'sensortopborder' => 1,
	'sensortopmargin' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signaturealgo' => 1,
	'signatureelementlist' => 1,
	'signatureelements' => 1,
	'signaturehash' => 1,
	'signaturepublickey' => 1,
	'signatureslot' => 1,
	'signatureusagerights' => 1,
	'signedelement' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'silenttracknumber' => 1,
	'silenttracks' => 1,
	'simpleblock' => 1,
	'simpleindex' => 1,
	'simpletag' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'splitcolumn' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereo3dmode' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'system' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag900b' => 1,
	'tag9050' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tagattachmentuid' => 1,
	'tagbinary' => 1,
	'tagchapteruid' => 1,
	'tagdefault' => 1,
	'tageditionuid' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'taglanguage' => 1,
	'tagname' => 1,
	'tags' => 1,
	'tagstring' => 1,
	'tagtrackuid' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetprinter' => 1,
	'targets' => 1,
	'targettype' => 1,
	'targettypevalue' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephone' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodescale' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timeslice' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackattachmentuid' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackdefault' => 1,
	'trackduration' => 1,
	'trackentry' => 1,
	'trackerdata' => 1,
	'trackforced' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklacing' => 1,
	'tracklanguage' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackname' => 1,
	'trackoffset' => 1,
	'trackoverlay' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktimecodescale' => 1,
	'tracktranslate' => 1,
	'tracktranslatecodec' => 1,
	'tracktranslateeditionuid' => 1,
	'tracktranslatetrackid' => 1,
	'tracktype' => 1,
	'trackuid' => 1,
	'trackused' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowndate' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknowntemperature3' => 1,
	'unknowntemperature4' => 1,
	'unknowntemperature5' => 1,
	'unknowntemperature6' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vcardversion' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'void' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumenormalization' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writers' => 1,
	'writingapp' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        my $fieldInfo = $$strTable{$field};
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2015, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
