#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.19';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::AutoCaptureInfo',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MenuSettingsZ9v4',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::hdrgm',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::panorama',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 109 => 0x69 },
	'about' => { 519 => 'about' },
	'aboutcvterm' => { 510 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 510 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 510 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 510 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 510 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 116 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 525 => 'absPeakAudioFilePath' },
	'academicfield' => { 515 => 'academicField' },
	'acceleration' => { 119 => 0x9404, 503 => 'Acceleration' },
	'accelerationtracking' => { 84 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 407 => 0x3 },
	'accelerometerdata' => { 397 => 'vrot' },
	'accelerometerx' => { 337 => 0x8d },
	'accelerometery' => { 337 => 0x8e },
	'accelerometerz' => { 337 => 0x8c },
	'accessoryserialnumber' => { 337 => 0x54 },
	'accessorytype' => { 337 => 0x53 },
	'actionadvised' => { 131 => 0x2a },
	'activearea' => { 119 => 0xc68d },
	'actived-lighting' => { 234 => 0x22, 287 => 0x24 },
	'actived-lightingmode' => { 287 => 0x25 },
	'adaptervoltage' => { 138 => 0x407 },
	'addaspectratioinfo' => { 84 => 0x80e },
	'addiptcinformation' => { 84 => 0x815 },
	'additionalmodelinformation' => { 510 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 84 => 0x80f, 85 => 0x11, 86 => 0x13, 89 => 0x14 },
	'address' => { 161 => 'Address' },
	'adjustmentmode' => { 414 => 0x15 },
	'adlbracketingstep' => { 198 => 0x17 },
	'adlbracketingtype' => { 198 => 0x18 },
	'adobe' => { 120 => 'Adobe' },
	'adultcontentwarning' => { 324 => 'AdultContentWarning', 518 => 'adultContentWarning' },
	'advancedfilter' => { 127 => 0x1201 },
	'advancedraw' => { 289 => 0x76a43203 },
	'advancedscenetype' => { 337 => 0x3d },
	'advisory' => { 523 => 'Advisory' },
	'ae_iso' => { 345 => 0x2, 346 => 0x4, 347 => 0x12 },
	'aeaperture' => { 345 => 0x1, 346 => 0x3, 347 => 0x11 },
	'aeaperturesteps' => { 345 => 0x8, 346 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 84 => 0x104 },
	'aebbracketvalue' => { 77 => 0x11 },
	'aebracketingsteps' => { 198 => 0xf, 199 => 0xf, 270 => 0x174c },
	'aebsequence' => { 84 => 0x105 },
	'aebsequenceautocancel' => { 82 => 0x9, 83 => 0x9, 85 => 0x8, 86 => 0x9, 89 => 0x9, 90 => 0x7 },
	'aebshotcount' => { 84 => 0x106 },
	'aebxv' => { 345 => 0x4, 346 => 0x6 },
	'aeerror' => { 346 => 0x8 },
	'aeexposuretime' => { 345 => 0x0, 346 => 0x2, 347 => 0x10 },
	'aelbutton' => { 184 => 0x45 },
	'aelexposureindicator' => { 184 => 0x51 },
	'aelock' => { 184 => 0x5b, 298 => '4.2', 307 => '4.2', 314 => 0x201, 372 => 0x48, 424 => 0x40, 425 => 0x40, 426 => [0x86,0x286] },
	'aelockbutton' => { 296 => '16.1', 298 => '4.1', 301 => '15.1', 302 => '16.1', 303 => '16.1', 305 => '30.1', 306 => '16.1', 307 => '4.1', 309 => '17.1', 311 => '17.1' },
	'aelockbuttonplusdials' => { 296 => '16.2', 305 => '32.1', 309 => '44.1' },
	'aelockformb-d80' => { 311 => '3.1' },
	'aelockmetermodeafterfocus' => { 84 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 345 => 0x9, 346 => 0x10, 347 => 0x1c },
	'aemaxaperture2' => { 345 => 0xa, 346 => 0x11, 347 => 0x1d },
	'aemeteringmode' => { 345 => 0xc },
	'aemeteringmode2' => { 345 => '13.1' },
	'aemeteringsegments' => { 187 => 0x628, 372 => 0x209 },
	'aemicroadjustment' => { 84 => 0x110 },
	'aeminaperture' => { 345 => 0xb, 346 => 0x12, 347 => 0x1e },
	'aeminexposuretime' => { 345 => 0x5, 346 => 0x13, 347 => 0x1f },
	'aeprogrammode' => { 345 => 0x6 },
	'aeprojectlink' => { 497 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 497 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 497 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 497 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 497 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 497 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 34 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 345 => 0xd },
	'aexv' => { 345 => 0x3, 346 => 0x5 },
	'af-assistilluminator' => { 312 => 0x19 },
	'af-cfocusdisplay' => { 312 => 0x234 },
	'af-cpriority' => { 128 => '0.2' },
	'af-cpriorityselection' => { 296 => '1.1', 297 => '1.1', 299 => '1.1', 300 => '1.1', 302 => '0.1', 303 => '0.1', 304 => '0.1', 305 => '1.1', 306 => '0.1', 309 => '1.1', 310 => '1.1', 312 => 0x3 },
	'af-csetting' => { 124 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 124 => '0.2' },
	'af-ctrackingsensitivity' => { 124 => '0.1' },
	'af-czoneareaswitching' => { 124 => '0.3' },
	'af-onbutton' => { 299 => '70.1', 300 => '70.1', 310 => '70.1' },
	'af-onformb-d10' => { 296 => '3.3', 305 => '3.2' },
	'af-onformb-d11' => { 306 => '2.2' },
	'af-onformb-d12' => { 309 => '50.1' },
	'af-onoutoffocusrelease' => { 312 => 0x10 },
	'af-spriority' => { 128 => '0.1' },
	'af-spriorityselection' => { 296 => '1.2', 297 => '1.2', 299 => '1.2', 300 => '1.2', 304 => '0.2', 305 => '1.2', 306 => '0.2', 309 => '1.2', 310 => '1.2', 312 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 296 => '2.1', 297 => '2.1', 299 => '78.3', 300 => '78.3', 305 => '2.1', 309 => '2.1', 310 => '78.3', 312 => 0xf },
	'afadjustment' => { 372 => 0x72, 381 => 0x267 },
	'afandmeteringbuttons' => { 84 => 0x701 },
	'afaperture' => { 227 => 0x5, 228 => 0x5, 232 => 0x5 },
	'afareaheight' => { 193 => [0x1a,0x34,0x50], 194 => 0x48 },
	'afareaillumination' => { 184 => 0x4b, 307 => '15.3' },
	'afareainitialheight' => { 245 => 0xbeb },
	'afareainitialwidth' => { 245 => 0xbea },
	'afareainitialxposition' => { 245 => 0xbe8 },
	'afareainitialyposition' => { 245 => 0xbe9 },
	'afareamode' => { 126 => '0.3', 180 => 0x33, 184 => 0xe, 192 => 0x0, 193 => 0x5, 194 => 0x5, 239 => 0x210, 240 => 0x224, 241 => 0x224, 337 => 0xf, 404 => 0x1205, 417 => [0xa,0x3a], 424 => 0x11, 425 => 0x10, 426 => 0x24, 437 => 0xb043, 462 => 0x17 },
	'afareamodesetting' => { 298 => '11.1', 301 => '0.1', 307 => '16.1', 311 => '2.1', 437 => 0x201c },
	'afareapointsize' => { 126 => '0.4' },
	'afareas' => { 314 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 84 => 0x51b },
	'afareawidth' => { 193 => [0x18,0x32,0x4e], 194 => 0x46 },
	'afareaxposition' => { 193 => [0x14,0x2e,0x4a], 194 => 0x42, 404 => 0x1203 },
	'afareaxposition1' => { 404 => 0x1201 },
	'afareayposition' => { 193 => [0x16,0x30,0x4c], 194 => 0x44, 404 => 0x1204 },
	'afareayposition1' => { 404 => 0x1202 },
	'afareazonesize' => { 126 => '0.5' },
	'afassist' => { 82 => 0x5, 90 => 0x5, 184 => 0x48, 296 => '2.5', 298 => '0.2', 301 => '0.2', 302 => '1.1', 303 => '1.1', 304 => '1.3', 305 => '2.4', 306 => '1.3', 307 => '0.2', 309 => '2.4', 311 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 84 => 0x50e, 85 => 0x4, 86 => 0x5, 87 => 0x4, 88 => 0x4, 89 => 0x5 },
	'afassistlamp' => { 337 => 0x31 },
	'afbuttonpressed' => { 426 => [0x83,0x283] },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 348 => 0x6 },
	'afduringliveview' => { 84 => 0x511 },
	'affinea' => { 490 => 'AffineA' },
	'affineb' => { 490 => 'AffineB' },
	'affinec' => { 490 => 'AffineC' },
	'affined' => { 490 => 'AffineD' },
	'affinetune' => { 195 => 0x0, 239 => 0x5b0, 240 => 0x5e0, 241 => 0x5e0, 314 => 0x306 },
	'affinetuneadj' => { 195 => 0x2, 263 => 0x2d1, 264 => 0x2dc, 314 => 0x307 },
	'affinetuneadjtele' => { 195 => 0x3 },
	'affinetuneindex' => { 195 => 0x1 },
	'affinex' => { 490 => 'AffineX' },
	'affiney' => { 490 => 'AffineY' },
	'afhold' => { 348 => 0x1fd },
	'afilluminator' => { 424 => 0x29, 437 => 0xb044 },
	'afimageheight' => { 193 => [0x12,0x2c,0x48], 194 => 0x40 },
	'afimagewidth' => { 193 => [0x10,0x2a,0x46], 194 => 0x3e },
	'afintegrationtime' => { 348 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 417 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 421 => 0x131 },
	'afmicroadjregisteredlenses' => { 421 => '305.1' },
	'afmicroadjustment' => { 84 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 421 => 0x130 },
	'afmode' => { 113 => 0x3009, 127 => 0x1022, 180 => 0x16, 414 => 0x5 },
	'afmoderestrictions' => { 297 => '50.3', 299 => '48.3', 300 => '48.3', 309 => '48.3', 310 => '48.3' },
	'afonaelockbuttonswitch' => { 84 => 0x702 },
	'afonbutton' => { 296 => '3.1', 297 => '47.1', 312 => 0x83 },
	'afpoint' => { 34 => 0x13, 112 => 0x18, 180 => 0x15, 192 => 0x1, 317 => 0x308, 414 => 0x1f, 417 => [0x37,0x7], 421 => 0x19, 422 => 0x18, 423 => [0x18,0x20] },
	'afpointactivationarea' => { 83 => 0x11, 89 => 0x11 },
	'afpointareaexpansion' => { 84 => 0x508 },
	'afpointatshutterrelease' => { 417 => [0x39,0x9] },
	'afpointautoselection' => { 84 => 0x50b },
	'afpointbrightness' => { 84 => 0x50d, 296 => '2.4', 297 => '46.5', 299 => '2.2', 300 => '2.2', 309 => '2.3', 310 => '2.2' },
	'afpointdetails' => { 317 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 84 => 0x50c },
	'afpointillumination' => { 83 => 0xa, 296 => '2.3', 297 => '46.2', 299 => '47.2', 300 => '47.2', 304 => '1.2', 305 => '2.3', 306 => '1.2', 309 => '47.2', 310 => '47.2', 311 => '2.4' },
	'afpointinfocus' => { 417 => [0x38,0x8] },
	'afpointmode' => { 353 => 0x3 },
	'afpointposition' => { 113 => 0x2021, 337 => 0x4d },
	'afpointregistration' => { 82 => 0x7 },
	'afpoints' => { 183 => 0x10 },
	'afpointsel' => { 312 => 0xb },
	'afpointselected' => { 184 => 0xd, 314 => 0x305, 372 => 0xe, 421 => 0x15, 422 => 0x14, 423 => [0x14,0x1c], 437 => 0x201e },
	'afpointselected2' => { 353 => 0x4 },
	'afpointselection' => { 83 => 0xb, 296 => '1.3', 297 => '1.3', 305 => '1.3', 309 => '1.3', 310 => '1.3' },
	'afpointselectionmethod' => { 84 => 0x50f, 85 => 0xc, 86 => 0xd, 89 => 0xd },
	'afpointsetting' => { 424 => 0x12, 425 => 0x11 },
	'afpointsinfocus' => { 77 => 0xe, 192 => 0x2, 193 => 0x30, 348 => 0xb, 349 => 0x4, 372 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 83 => 0xd },
	'afpointsselected' => { 193 => 0x1c, 349 => '4.1', 470 => 0x4 },
	'afpointsspecial' => { 349 => '4.2' },
	'afpointsunknown1' => { 348 => 0x0 },
	'afpointsunknown2' => { 348 => 0x2 },
	'afpointsused' => { 193 => [0xa,0x8], 417 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 348 => 0x4 },
	'afresponse' => { 234 => 0xad },
	'afresult' => { 319 => 0x1038 },
	'afsearch' => { 314 => 0x303 },
	'afsensoractive' => { 180 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 404 => 0x1200 },
	'afstatus_00_b4' => { 420 => 0x0 },
	'afstatus_01_c4' => { 420 => 0x2 },
	'afstatus_02_d4' => { 420 => 0x4 },
	'afstatus_03_e4' => { 420 => 0x6 },
	'afstatus_04_f4' => { 420 => 0x8 },
	'afstatus_05_g4' => { 420 => 0xa },
	'afstatus_06_h4' => { 420 => 0xc },
	'afstatus_07_b3' => { 420 => 0xe },
	'afstatus_08_c3' => { 420 => 0x10 },
	'afstatus_09_d3' => { 420 => 0x12 },
	'afstatus_10_e3' => { 420 => 0x14 },
	'afstatus_11_f3' => { 420 => 0x16 },
	'afstatus_12_g3' => { 420 => 0x18 },
	'afstatus_13_h3' => { 420 => 0x1a },
	'afstatus_14_b2' => { 420 => 0x1c },
	'afstatus_15_c2' => { 420 => 0x1e },
	'afstatus_16_d2' => { 420 => 0x20 },
	'afstatus_17_e2' => { 420 => 0x22 },
	'afstatus_18_f2' => { 420 => 0x24 },
	'afstatus_19_g2' => { 420 => 0x26 },
	'afstatus_20_h2' => { 420 => 0x28 },
	'afstatus_21_c1' => { 420 => 0x2a },
	'afstatus_22_d1' => { 420 => 0x2c },
	'afstatus_23_e1' => { 420 => 0x2e },
	'afstatus_24_f1' => { 420 => 0x30 },
	'afstatus_25_g1' => { 420 => 0x32 },
	'afstatus_26_a7_vertical' => { 420 => 0x34 },
	'afstatus_27_a6_vertical' => { 420 => 0x36 },
	'afstatus_28_a5_vertical' => { 420 => 0x38 },
	'afstatus_29_c7_vertical' => { 420 => 0x3a },
	'afstatus_30_c6_vertical' => { 420 => 0x3c },
	'afstatus_31_c5_vertical' => { 420 => 0x3e },
	'afstatus_32_e7_vertical' => { 420 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 420 => 0x42 },
	'afstatus_34_e5_vertical' => { 420 => 0x44 },
	'afstatus_35_g7_vertical' => { 420 => 0x46 },
	'afstatus_36_g6_vertical' => { 420 => 0x48 },
	'afstatus_37_g5_vertical' => { 420 => 0x4a },
	'afstatus_38_i7_vertical' => { 420 => 0x4c },
	'afstatus_39_i6_vertical' => { 420 => 0x4e },
	'afstatus_40_i5_vertical' => { 420 => 0x50 },
	'afstatus_41_a7' => { 420 => 0x52 },
	'afstatus_42_b7' => { 420 => 0x54 },
	'afstatus_43_c7' => { 420 => 0x56 },
	'afstatus_44_d7' => { 420 => 0x58 },
	'afstatus_45_e7' => { 420 => 0x5a },
	'afstatus_46_f7' => { 420 => 0x5c },
	'afstatus_47_g7' => { 420 => 0x5e },
	'afstatus_48_h7' => { 420 => 0x60 },
	'afstatus_49_i7' => { 420 => 0x62 },
	'afstatus_50_a6' => { 420 => 0x64 },
	'afstatus_51_b6' => { 420 => 0x66 },
	'afstatus_52_c6' => { 420 => 0x68 },
	'afstatus_53_d6' => { 420 => 0x6a },
	'afstatus_54_e6_center' => { 420 => 0x6c },
	'afstatus_55_f6' => { 420 => 0x6e },
	'afstatus_56_g6' => { 420 => 0x70 },
	'afstatus_57_h6' => { 420 => 0x72 },
	'afstatus_58_i6' => { 420 => 0x74 },
	'afstatus_59_a5' => { 420 => 0x76 },
	'afstatus_60_b5' => { 420 => 0x78 },
	'afstatus_61_c5' => { 420 => 0x7a },
	'afstatus_62_d5' => { 420 => 0x7c },
	'afstatus_63_e5' => { 420 => 0x7e },
	'afstatus_64_f5' => { 420 => 0x80 },
	'afstatus_65_g5' => { 420 => 0x82 },
	'afstatus_66_h5' => { 420 => 0x84 },
	'afstatus_67_i5' => { 420 => 0x86 },
	'afstatus_68_c11' => { 420 => 0x88 },
	'afstatus_69_d11' => { 420 => 0x8a },
	'afstatus_70_e11' => { 420 => 0x8c },
	'afstatus_71_f11' => { 420 => 0x8e },
	'afstatus_72_g11' => { 420 => 0x90 },
	'afstatus_73_b10' => { 420 => 0x92 },
	'afstatus_74_c10' => { 420 => 0x94 },
	'afstatus_75_d10' => { 420 => 0x96 },
	'afstatus_76_e10' => { 420 => 0x98 },
	'afstatus_77_f10' => { 420 => 0x9a },
	'afstatus_78_g10' => { 420 => 0x9c },
	'afstatus_79_h10' => { 420 => 0x9e },
	'afstatus_80_b9' => { 420 => 0xa0 },
	'afstatus_81_c9' => { 420 => 0xa2 },
	'afstatus_82_d9' => { 420 => 0xa4 },
	'afstatus_83_e9' => { 420 => 0xa6 },
	'afstatus_84_f9' => { 420 => 0xa8 },
	'afstatus_85_g9' => { 420 => 0xaa },
	'afstatus_86_h9' => { 420 => 0xac },
	'afstatus_87_b8' => { 420 => 0xae },
	'afstatus_88_c8' => { 420 => 0xb0 },
	'afstatus_89_d8' => { 420 => 0xb2 },
	'afstatus_90_e8' => { 420 => 0xb4 },
	'afstatus_91_f8' => { 420 => 0xb6 },
	'afstatus_92_g8' => { 420 => 0xb8 },
	'afstatus_93_h8' => { 420 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 420 => 0xbc },
	'afstatusactivesensor' => { 180 => 0x2, 417 => [0x4,0x3b], 421 => 0x1e, 422 => 0x1b, 423 => [0x1b,0x21] },
	'afstatusbottom' => { 180 => 0x8, 421 => 0x2a, 422 => 0x21, 423 => 0x21 },
	'afstatusbottom-left' => { 180 => 0x12, 422 => 0x2b, 423 => 0x2b },
	'afstatusbottom-right' => { 180 => 0x6, 422 => 0x1f, 423 => 0x1f },
	'afstatusbottomassist-left' => { 421 => 0x28 },
	'afstatusbottomassist-right' => { 421 => 0x2c },
	'afstatusbottomhorizontal' => { 418 => 0x10, 419 => 0x1c },
	'afstatusbottomvertical' => { 418 => 0x16, 419 => 0x26 },
	'afstatuscenter-10' => { 421 => 0x34 },
	'afstatuscenter-11' => { 421 => 0x36 },
	'afstatuscenter-12' => { 421 => 0x38 },
	'afstatuscenter-14' => { 421 => 0x3c },
	'afstatuscenter-7' => { 421 => 0x2e },
	'afstatuscenter-9' => { 421 => 0x32 },
	'afstatuscenter-horizontal' => { 421 => 0x30 },
	'afstatuscenter-vertical' => { 421 => 0x3a },
	'afstatuscenterf2-8' => { 421 => 0x4c },
	'afstatuscenterhorizontal' => { 180 => 0x2f, 418 => 0xc, 419 => 0x18, 422 => 0x2f, 423 => 0x2f },
	'afstatuscentervertical' => { 180 => 0xc, 418 => 0x14, 419 => 0x22, 422 => 0x25, 423 => 0x25 },
	'afstatusfarleft' => { 418 => 0x6, 421 => 0x26 },
	'afstatusfarlefthorizontal' => { 419 => 0x4 },
	'afstatusfarleftvertical' => { 419 => 0x12 },
	'afstatusfarright' => { 418 => 0x18, 421 => 0x44 },
	'afstatusfarrighthorizontal' => { 419 => 0x2c },
	'afstatusfarrightvertical' => { 419 => 0x34 },
	'afstatusleft' => { 180 => 0x2d, 418 => 0x2, 421 => 0x22, 422 => 0x2d, 423 => 0x2d },
	'afstatuslefthorizontal' => { 419 => 0x6 },
	'afstatusleftvertical' => { 419 => 0xe },
	'afstatuslower-left' => { 418 => 0x4, 421 => 0x24 },
	'afstatuslower-lefthorizontal' => { 419 => 0xa },
	'afstatuslower-leftvertical' => { 419 => 0x10 },
	'afstatuslower-middle' => { 418 => 0x22, 419 => 0x24 },
	'afstatuslower-right' => { 418 => 0x1e, 421 => 0x4a },
	'afstatuslower-righthorizontal' => { 419 => 0x32 },
	'afstatuslower-rightvertical' => { 419 => 0x3a },
	'afstatuslowerfarleft' => { 419 => 0x8 },
	'afstatuslowerfarright' => { 419 => 0x30 },
	'afstatusmiddlehorizontal' => { 180 => 0xa, 422 => 0x23, 423 => 0x23 },
	'afstatusnearleft' => { 418 => 0xe, 419 => 0x1a },
	'afstatusnearright' => { 418 => 0xa, 419 => 0x16 },
	'afstatusright' => { 180 => 0x31, 418 => 0x1c, 421 => 0x48, 422 => 0x31, 423 => 0x31 },
	'afstatusrighthorizontal' => { 419 => 0x2e },
	'afstatusrightvertical' => { 419 => 0x38 },
	'afstatustop' => { 180 => 0xe, 421 => 0x40, 422 => 0x27, 423 => 0x27 },
	'afstatustop-left' => { 180 => 0x10, 422 => 0x29, 423 => 0x29 },
	'afstatustop-right' => { 180 => 0x4, 422 => 0x1d, 423 => 0x1d },
	'afstatustopassist-left' => { 421 => 0x3e },
	'afstatustopassist-right' => { 421 => 0x42 },
	'afstatustophorizontal' => { 418 => 0x8, 419 => 0x14 },
	'afstatustopvertical' => { 418 => 0x12, 419 => 0x1e },
	'afstatusupper-left' => { 418 => 0x0, 421 => 0x20 },
	'afstatusupper-lefthorizontal' => { 419 => 0x2 },
	'afstatusupper-leftvertical' => { 419 => 0xc },
	'afstatusupper-middle' => { 418 => 0x20, 419 => 0x20 },
	'afstatusupper-right' => { 418 => 0x1a, 421 => 0x46 },
	'afstatusupper-righthorizontal' => { 419 => 0x2a },
	'afstatusupper-rightvertical' => { 419 => 0x36 },
	'afstatusupperfarleft' => { 419 => 0x0 },
	'afstatusupperfarright' => { 419 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 437 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 417 => 0x2 },
	'afwithshutter' => { 424 => 0x2a },
	'aggregateissuenumber' => { 515 => 'aggregateIssueNumber' },
	'aggregationtype' => { 515 => 'aggregationType' },
	'agreement' => { 518 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 138 => 0xe4e },
	'airplanemode' => { 239 => 0x624, 240 => 0x654, 241 => 0x6bc },
	'aiservocontinuousshooting' => { 83 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 84 => 0x519 },
	'aiservoimagepriority' => { 84 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 84 => 0x51a },
	'aiservotrackingmethod' => { 84 => 0x504 },
	'aiservotrackingsensitivity' => { 83 => 0x14, 84 => 0x502 },
	'aisubjecttrackingmode' => { 314 => 0x309 },
	'album' => { 389 => ['albm',"\xa9alb"], 391 => 'album', 397 => ['albm',"\xa9alb"], 525 => 'album' },
	'albumartist' => { 179 => 'WM/AlbumArtist', 389 => 'aART', 397 => 'albr' },
	'albumcoverurl' => { 179 => 'WM/AlbumCoverURL' },
	'albumtitle' => { 179 => 'WM/AlbumTitle' },
	'albumtitleid' => { 389 => 'atID' },
	'alreadyapplied' => { 496 => 'AlreadyApplied', 498 => 'AlreadyApplied' },
	'alternatetitle' => { 515 => 'alternateTitle' },
	'alternatetitlea-lang' => { 515 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 515 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 515 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 197 => 0x6 },
	'alttapename' => { 525 => 'altTapeName' },
	'alttextaccessibility' => { 509 => 'AltTextAccessibility' },
	'alttimecode' => { 525 => 'altTimecode' },
	'alttimecodetimeformat' => { 525 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 525 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 525 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 400 => 0x5c },
	'ambientlight' => { 400 => 0x5e },
	'ambienttemperature' => { 119 => 0x9400, 398 => 0x14, 399 => 0x46, 400 => 0x50, 462 => 0x4, 503 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 398 => 0x13, 399 => 0x44, 400 => 0x4e },
	'analogbalance' => { 119 => 0xc627 },
	'analogcaptureiso' => { 138 => 0x89e },
	'analogisotable' => { 138 => 0x89d },
	'androidversion' => { 391 => 'com.android.version' },
	'angleadj' => { 103 => 0x10003, 109 => 0x8b },
	'angleinforoll' => { 492 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 492 => 'AngleInfoYaw' },
	'anti-blur' => { 437 => 0xb04b },
	'antialiasstrength' => { 119 => 0xc632 },
	'aperturelock' => { 297 => '38.2', 299 => '38.2', 300 => '38.2', 309 => '38.2', 310 => '38.2', 312 => 0xb8 },
	'aperturemode' => { 397 => 'apmd' },
	'aperturerange' => { 84 => 0x10d },
	'apertureringuse' => { 353 => '1.4' },
	'aperturesetting' => { 184 => 0x7, 424 => 0x30, 425 => 0x29, 426 => 0x1 },
	'aperturevalue' => { 93 => 0x2, 119 => 0x9202, 319 => 0x1002, 381 => 0x401, 502 => 'ApertureValue' },
	'appinfo' => { 475 => 'AppInfo' },
	'appinfoapplication' => { 475 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 475 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 475 => [\'AppInfo','AppInfoVersion'] },
	'applekeywords' => { 323 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 391 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 389 => 'apID' },
	'applestoreaccounttype' => { 389 => 'akID' },
	'applestorecatalogid' => { 389 => 'cnID' },
	'applestorecountry' => { 389 => 'sfID' },
	'applicationkeystring' => { 138 => 0x400 },
	'applicationnotes' => { 119 => 0x2bc, 342 => 0x2bc },
	'applicationrecordversion' => { 131 => 0x0 },
	'applyshootingmeteringmode' => { 84 => 0x10e },
	'approved' => { 504 => 'Approved' },
	'approvedby' => { 504 => 'ApprovedBy' },
	'approximatefnumber' => { 332 => 0x313, 339 => 0x3406 },
	'approximatefocusdistance' => { 493 => 'ApproximateFocusDistance' },
	'appversion' => { 508 => 'AppVersion' },
	'aps-csizecapture' => { 456 => 0x114, 457 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 103 => 0x20914 },
	'armidentifier' => { 132 => 0x78 },
	'armversion' => { 132 => 0x7a },
	'arranger' => { 389 => "\xa9arg", 397 => "\xa9arg" },
	'arrangerkeywords' => { 397 => "\xa9ark" },
	'artdirector' => { 389 => "\xa9ard" },
	'artfilter' => { 314 => 0x529 },
	'artfiltereffect' => { 314 => 0x52f },
	'artist' => { 119 => 0x13b, 327 => 'Artist', 342 => 0x13b, 372 => 0x22e, 389 => "\xa9ART", 391 => 'artist', 397 => "\xa9ART", 521 => 'Artist', 525 => 'artist' },
	'artmode' => { 113 => 0x301b },
	'artmodeparameters' => { 113 => 0x310b },
	'artwork' => { 391 => 'artwork' },
	'artworkcircadatecreated' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 510 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 510 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 318 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 318 => 0x1112, 372 => 0x80, 424 => 0x55, 425 => 0x55, 426 => 0xa, 450 => [0x192c,0x1a88], 451 => 0x192c, 452 => 0x1958, 453 => 0x192c, 454 => 0x188c },
	'assetid' => { 486 => 'AssetID' },
	'asshoticcprofile' => { 119 => 0xc68f },
	'asshotneutral' => { 119 => 0xc628 },
	'asshotpreprofilematrix' => { 119 => 0xc690 },
	'asshotprofilename' => { 119 => 0xc6f6 },
	'asshotwhitexy' => { 119 => 0xc629 },
	'assignbktbutton' => { 296 => '4.2', 297 => '16.1', 299 => '16.1', 300 => '16.1', 309 => '16.1', 310 => '16.1' },
	'assignfuncbutton' => { 84 => 0x70b },
	'assignmb-d17af-onbutton' => { 300 => '79.1' },
	'assignmb-d17funcbutton' => { 300 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 300 => '68.1' },
	'assignmb-d18af-onbutton' => { 310 => '79.1' },
	'assignmb-d18funcbutton' => { 310 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 310 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 299 => '75.1', 300 => '75.1', 310 => '75.1' },
	'assignmoviefunc2button' => { 299 => '82.1', 300 => '82.1', 310 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 299 => '75.2', 300 => '75.2', 310 => '75.2' },
	'assignmovierecordbutton' => { 297 => '43.2', 309 => '45.1', 312 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 299 => '45.1', 300 => '45.1', 310 => '45.1' },
	'assignmoviesubselector' => { 299 => '74.1', 300 => '74.1', 310 => '74.1' },
	'assignmoviesubselectorplusdials' => { 299 => '76.1', 300 => '76.1', 310 => '76.1' },
	'assignremotefnbutton' => { 297 => '54.1', 309 => '51.1' },
	'assistbuttonfunction' => { 82 => 0xd },
	'atcaptureusercrop' => { 138 => 0x943 },
	'attributionname' => { 494 => 'attributionName' },
	'attributionurl' => { 494 => 'attributionURL' },
	'audio' => { 337 => 0x20 },
	'audiobitrate' => { 67 => 0x6c, 510 => 'audioBitRate' },
	'audiobitratemode' => { 510 => 'audioBitRateMode' },
	'audiobitspersample' => { 510 => 'audioBitsPerSample' },
	'audiobutton' => { 312 => 0x17b },
	'audiobuttonplaybackmode' => { 312 => 0x1b9 },
	'audiochannelcount' => { 510 => 'audioChannelCount' },
	'audiochannels' => { 67 => 0x70 },
	'audiochanneltype' => { 525 => 'audioChannelType' },
	'audiocompression' => { 84 => 0x816, 155 => 'Compression' },
	'audiocompressor' => { 525 => 'audioCompressor' },
	'audiodata' => { 478 => 'Data' },
	'audioduration' => { 131 => 0x99 },
	'audiogain' => { 391 => 'player.movie.audio.gain' },
	'audiomimetype' => { 478 => 'Mime' },
	'audiomoddate' => { 525 => 'audioModDate' },
	'audiooutcue' => { 131 => 0x9a },
	'audiosamplerate' => { 67 => 0x6e, 525 => 'audioSampleRate' },
	'audiosampletype' => { 525 => 'audioSampleType' },
	'audiosamplingrate' => { 131 => 0x97 },
	'audiosamplingresolution' => { 131 => 0x98 },
	'audiotype' => { 131 => 0x96 },
	'author' => { 157 => 'Author', 323 => 'Author', 327 => 'Author', 388 => 'Author', 389 => ['auth',"\xa9aut"], 391 => 'author', 397 => 'auth', 491 => 'author', 512 => 'Author', 523 => 'Author' },
	'authorsposition' => { 513 => 'AuthorsPosition' },
	'authorurl' => { 179 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 84 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 363 => '0.1' },
	'autobracket' => { 414 => 0x19 },
	'autobracketing' => { 127 => 0x1100, 372 => 0x18, 404 => 0x1007 },
	'autobracketingmode' => { 308 => '12.3' },
	'autobracketingset' => { 308 => '12.1' },
	'autobracketmodem' => { 296 => '21.2', 297 => '13.3', 299 => '13.2', 300 => '13.2', 305 => '26.2', 309 => '13.3', 310 => '13.2', 312 => 0x5f },
	'autobracketorder' => { 184 => 0x43, 296 => '21.3', 297 => '13.2', 299 => '13.1', 300 => '13.1', 305 => '26.3', 306 => '12.2', 307 => '2.2', 308 => '12.2', 309 => '13.2', 310 => '13.1', 311 => '13.2', 312 => 0x61 },
	'autobracketset' => { 296 => '21.1', 297 => '13.1', 301 => '11.1', 302 => '12.1', 303 => '12.1', 305 => '26.1', 306 => '12.1', 307 => '2.1', 309 => '13.1', 311 => '13.1' },
	'autobrightness' => { 496 => 'AutoBrightness', 498 => 'AutoBrightness' },
	'autocapturecriteria' => { 196 => 0x1 },
	'autocapturecriteriamotiondirection' => { 196 => 0x5f },
	'autocapturecriteriamotionsize' => { 196 => 0x64 },
	'autocapturecriteriamotionspeed' => { 196 => 0x63 },
	'autocapturecriteriasubjectsize' => { 196 => 0x69 },
	'autocapturecriteriasubjecttype' => { 196 => 0x6a },
	'autocapturedistancefar' => { 196 => 0x4a },
	'autocapturedistancenear' => { 196 => 0x4e },
	'autocapturepreset' => { 241 => 0x746 },
	'autocapturerecordingtime' => { 196 => 0x37 },
	'autocapturewaittime' => { 196 => 0x38 },
	'autocontrast' => { 496 => 'AutoContrast', 498 => 'AutoContrast' },
	'autodistortioncontrol' => { 209 => 0x4, 238 => 0x143 },
	'autodynamicrange' => { 127 => 0x140b },
	'autoexposure' => { 496 => 'AutoExposure', 498 => 'AutoExposure' },
	'autoexposurebracketing' => { 77 => 0x10 },
	'autoflashisosensitivity' => { 299 => '38.5', 300 => '38.5', 310 => '38.5', 312 => 0x5b },
	'autofocus' => { 317 => 0x209 },
	'autofocusmoderestrictions' => { 312 => 0x107 },
	'autofp' => { 307 => '7.3', 311 => '31.4' },
	'autoiso' => { 77 => 0x1, 113 => 0x3008, 239 => 0x142, 240 => 0x156, 241 => 0x156, 298 => '1.1', 307 => '1.1' },
	'autoisomax' => { 298 => '1.2', 307 => '1.2' },
	'autoisominshutterspeed' => { 298 => '1.3', 307 => '1.3' },
	'autolateralca' => { 496 => 'AutoLateralCA', 498 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 62 => 0x2, 84 => 0x204, 103 => 0x20500, 109 => 0x6f },
	'autolightingoptimizeron' => { 103 => '0x20500.0', 109 => 0x6e },
	'autoportraitframed' => { 437 => 0x2016 },
	'autoredeye' => { 289 => 0xfe28a44f },
	'autorotate' => { 77 => 0x1b },
	'autoshadows' => { 496 => 'AutoShadows', 498 => 'AutoShadows' },
	'autotone' => { 496 => 'AutoTone', 498 => 'AutoTone' },
	'autotonedigest' => { 496 => 'AutoToneDigest', 498 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 496 => 'AutoToneDigestNoSat', 498 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 496 => 'AutoWhiteVersion', 498 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 234 => 0x82 },
	'avaperturesetting' => { 353 => 0x13 },
	'averageblacklevel' => { 45 => 0xe7, 47 => 0xfb, 48 => 0x114, 49 => 0x146 },
	'averagelv' => { 187 => 0x38 },
	'avsettingwithoutlens' => { 84 => 0x707 },
	'azimuth' => { 165 => 'Azimuth' },
	'babyage' => { 337 => [0x8010,0x33] },
	'babyname' => { 337 => 0x66 },
	'backgroundalpha' => { 520 => 'bgalpha' },
	'balance' => { 391 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 353 => 0x15 },
	'baseiso' => { 77 => 0x2, 97 => 0x101c, 138 => 0x903, 339 => 0x312a, 468 => 0x6 },
	'baseisodaylight' => { 138 => 0x910 },
	'baseisoflash' => { 138 => 0x913 },
	'baseisofluorescent' => { 138 => 0x912 },
	'baseisotungsten' => { 138 => 0x911 },
	'baselineexposure' => { 119 => 0xc62a },
	'baselineexposureoffset' => { 119 => 0xc7a5 },
	'baselinenoise' => { 119 => 0xc62b },
	'baselinesharpness' => { 119 => 0xc62c },
	'baserenditionishdr' => { 507 => 'BaseRenditionIsHDR' },
	'baseurl' => { 523 => 'BaseURL' },
	'bass' => { 391 => 'player.movie.audio.bass' },
	'batterylevel' => { 337 => 0x38, 424 => 0x51, 428 => 0xc, 429 => 0x4, 430 => 0x4, 469 => 0x7 },
	'batterylevelgrip1' => { 469 => 0x6 },
	'batterylevelgrip2' => { 469 => 0x8 },
	'batteryorder' => { 296 => '12.5', 305 => '13.2', 306 => '2.1', 309 => '3.1' },
	'batterystate' => { 184 => 0x60, 424 => 0x50, 430 => 0x14 },
	'batterytemperature' => { 428 => 0x1, 430 => 0x2, 469 => 0x5 },
	'batterytype' => { 64 => 0x38, 400 => 0x66 },
	'batteryunknown' => { 428 => 0x2, 430 => 0x0 },
	'batteryvoltage' => { 138 => 0x408, 398 => 0x2a, 399 => 0x49, 400 => 0x62, 428 => 0x8 },
	'batteryvoltage1' => { 430 => 0x6 },
	'batteryvoltage2' => { 430 => 0x8 },
	'batteryvoltageavg' => { 400 => 0x64 },
	'bayergreensplit' => { 119 => 0xc62d },
	'bayerpattern' => { 137 => 0xf902, 188 => 0x17 },
	'beatsperminute' => { 389 => 'tmpo' },
	'beatspliceparams' => { 525 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 525 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 525 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 525 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 525 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 525 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 296 => '13.1', 297 => '5.4', 298 => '0.1', 301 => '2.1', 302 => '3.1', 303 => '3.1', 305 => '10.1', 307 => '0.1', 309 => '5.5', 311 => '4.1' },
	'beeppitch' => { 306 => '3.1' },
	'beepvolume' => { 306 => '4.5' },
	'bestqualityscale' => { 119 => 0xc65c },
	'bestshotmode' => { 113 => 0x3007 },
	'bitdepth' => { 162 => 'BitDepth', 188 => 0x11, 256 => 0x41 },
	'bitspercomponent' => { 133 => 0x87 },
	'bitspersample' => { 119 => 0x102, 342 => 0xa, 521 => 'BitsPerSample' },
	'blackacquirerows' => { 138 => 0x18ba },
	'blacklevel' => { 119 => [0x7310,0xc61a], 207 => 0x20, 234 => 0x3d, 319 => [0x401,0x1012], 381 => 0x21d, 444 => [0x7300,0x7310] },
	'blacklevel2' => { 318 => 0x600, 322 => 0x600 },
	'blacklevelblue' => { 342 => 0x1e },
	'blacklevelbottom' => { 138 => 0x3f0 },
	'blackleveldata' => { 381 => 0x223 },
	'blackleveldeltah' => { 119 => 0xc61b },
	'blackleveldeltav' => { 119 => 0xc61c },
	'blacklevelgreen' => { 342 => 0x1d },
	'blacklevelred' => { 342 => 0x1c },
	'blacklevelrepeatdim' => { 119 => 0xc619 },
	'blacklevelrough' => { 138 => 0x40e },
	'blacklevelroughafter' => { 138 => 0x416 },
	'blacklevels' => { 35 => 0x1d },
	'blackleveltop' => { 138 => 0x3ef },
	'blackpoint' => { 372 => 0x200 },
	'blacks2012' => { 496 => 'Blacks2012', 498 => 'Blacks2012' },
	'blacksadj' => { 472 => 0x9018 },
	'bleachbypasstoning' => { 372 => 0x7f },
	'blockshotafresponse' => { 299 => '1.5', 300 => '1.5', 310 => '1.5', 312 => 0x7 },
	'blogtitle' => { 515 => 'blogTitle' },
	'blogurl' => { 515 => 'blogURL' },
	'bluebalance' => { 319 => 0x1018, 342 => 0x12, 372 => 0x1b },
	'bluecurvelimits' => { 108 => 0x1fe },
	'bluecurvepoints' => { 107 => 0x79, 108 => 0x1d4 },
	'bluehsl' => { 103 => 0x20915 },
	'bluehue' => { 496 => 'BlueHue', 498 => 'BlueHue' },
	'bluesaturation' => { 496 => 'BlueSaturation', 498 => 'BlueSaturation' },
	'bluratinfinity' => { 482 => 'BlurAtInfinity' },
	'blurcontrol' => { 372 => 0x82 },
	'blurwarning' => { 127 => 0x1300 },
	'bodybatteryadload' => { 351 => 0x3 },
	'bodybatteryadnoload' => { 351 => 0x2 },
	'bodybatterystate' => { 351 => '1.1' },
	'bodybatteryvoltage1' => { 351 => 0x2 },
	'bodybatteryvoltage2' => { 351 => 0x4 },
	'bodybatteryvoltage3' => { 351 => 0x6 },
	'bodybatteryvoltage4' => { 351 => 0x8 },
	'bodyfirmware' => { 405 => 0x0 },
	'bodyfirmwareversion' => { 315 => 0x104, 316 => 0x100, 319 => 0x104 },
	'bodyserialnumber' => { 405 => 0x10 },
	'bookedition' => { 515 => 'bookEdition' },
	'bootloaderversion' => { 399 => 0x26 },
	'bracketbutton' => { 241 => 0x80c },
	'bracketbuttonplaybackmode' => { 241 => 0x816 },
	'bracketincrement' => { 239 => 0x21a, 240 => 0x22e, 241 => 0x22e },
	'bracketmode' => { 57 => 0x3 },
	'bracketprogram' => { 239 => 0x218, 240 => 0x22c, 241 => 0x22c },
	'bracketsequence' => { 113 => 0x301d },
	'bracketset' => { 239 => 0x216, 240 => 0x22a, 241 => 0x22a },
	'bracketsettings' => { 337 => 0x45 },
	'bracketshotnumber' => { 57 => 0x5, 353 => 0x9, 435 => 0x2b },
	'bracketshotnumber2' => { 435 => 0x2d },
	'bracketstep' => { 181 => 0xe },
	'bracketvalue' => { 57 => 0x4 },
	'brightness' => { 119 => 0xfe53, 156 => 'Brightness', 176 => 'Brightness', 181 => 0x2c, 248 => 0x34, 249 => 0x39, 250 => 0x41, 391 => 'player.movie.visual.brightness', 398 => 0x25, 400 => 0x54, 424 => 0x22, 437 => 0x2007, 496 => 'Brightness', 498 => 'Brightness' },
	'brightnessadj' => { 108 => 0x114, 282 => 0x0, 292 => 0x2d, 472 => 0x8018 },
	'brightnessvalue' => { 119 => 0x9203, 187 => [0x691,0x49c3], 319 => 0x1003, 442 => 0x1e, 446 => 0x1140, 447 => 0x1140, 448 => 0x111c, 449 => 0x1198, 450 => 0x1174, 451 => 0x102c, 452 => 0x224, 453 => 0x224, 454 => 0x219, 502 => 'BrightnessValue' },
	'buildnumber' => { 191 => 0x5500 },
	'bulbduration' => { 77 => 0x18 },
	'burstcount' => { 138 => 0x40d },
	'burstgroupid' => { 236 => 0x4 },
	'burstid' => { 479 => 'BurstID' },
	'burstmode' => { 140 => 0xa, 337 => 0x2a },
	'burstmode2' => { 140 => 0x18 },
	'burstprimary' => { 479 => 'BurstPrimary' },
	'burstshot' => { 414 => 0x34 },
	'burstspeed' => { 337 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 84 => 0x70a },
	'bwadjustment' => { 127 => 0x1049 },
	'bwfilter' => { 181 => 0x2a, 189 => 0x39 },
	'bwmagentagreen' => { 127 => 0x104b },
	'bwmode' => { 319 => 0x203 },
	'by-line' => { 131 => 0x50 },
	'by-linetitle' => { 131 => 0x55 },
	'bytecount' => { 515 => 'byteCount' },
	'c14configuration' => { 138 => 0x1964 },
	'cacheversion' => { 119 => 0xc7aa },
	'calibratedfocallength' => { 116 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 116 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 116 => 'CalibratedOpticalCenterY' },
	'calibration' => { 414 => [0x24,0x30] },
	'calibrationhistory' => { 138 => 0x9c9 },
	'calibrationilluminant1' => { 119 => 0xc65a },
	'calibrationilluminant2' => { 119 => 0xc65b },
	'calibrationilluminant3' => { 119 => 0xcd31 },
	'calibrationversion' => { 138 => 0x9c6 },
	'callforimage' => { 486 => 'CallForImage' },
	'camera' => { 475 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 397 => 'angl', 525 => 'cameraAngle' },
	'cameraappinfo' => { 475 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 475 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 475 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 475 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 480 => 'CameraBurstID' },
	'cameracalibration' => { 414 => 0x11f },
	'cameracalibration1' => { 119 => 0xc623 },
	'cameracalibration2' => { 119 => 0xc624 },
	'cameracalibration3' => { 119 => 0xcd32 },
	'cameracalibrationsig' => { 119 => 0xc6f3 },
	'cameracolorcalibration01' => { 36 => 0x0, 37 => 0x0 },
	'cameracolorcalibration02' => { 36 => 0x4, 37 => 0x5 },
	'cameracolorcalibration03' => { 36 => 0x8, 37 => 0xa },
	'cameracolorcalibration04' => { 36 => 0xc, 37 => 0xf },
	'cameracolorcalibration05' => { 36 => 0x10, 37 => 0x14 },
	'cameracolorcalibration06' => { 36 => 0x14, 37 => 0x19 },
	'cameracolorcalibration07' => { 36 => 0x18, 37 => 0x1e },
	'cameracolorcalibration08' => { 36 => 0x1c, 37 => 0x23 },
	'cameracolorcalibration09' => { 36 => 0x20, 37 => 0x28 },
	'cameracolorcalibration10' => { 36 => 0x24, 37 => 0x2d },
	'cameracolorcalibration11' => { 36 => 0x28, 37 => 0x32 },
	'cameracolorcalibration12' => { 36 => 0x2c, 37 => 0x37 },
	'cameracolorcalibration13' => { 36 => 0x30, 37 => 0x3c },
	'cameracolorcalibration14' => { 36 => 0x34, 37 => 0x41 },
	'cameracolorcalibration15' => { 36 => 0x38, 37 => 0x46 },
	'cameradepthmap' => { 475 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 475 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 475 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 475 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 475 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 475 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 475 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 475 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 475 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 475 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 475 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 475 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 391 => 'direction.facing' },
	'camerae-mountversion' => { 471 => 0xb },
	'cameraelevationangle' => { 119 => 0x9405, 503 => 'CameraElevationAngle' },
	'camerafilename' => { 486 => 'CameraFilename' },
	'camerafirmware' => { 119 => 0xa439 },
	'cameraid' => { 319 => 0x209, 397 => 'cmid', 413 => 0x209 },
	'cameraidentifier' => { 391 => 'camera.identifier' },
	'cameraimage' => { 475 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 475 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 475 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 475 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 475 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 475 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 475 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 475 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 475 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 475 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 475 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 475 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 475 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 475 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 34 => 0x10 },
	'cameralabel' => { 119 => 0xc7a1, 525 => 'cameraLabel' },
	'cameralightestimate' => { 475 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 475 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 475 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 475 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 475 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 486 => 'CameraMakeModel' },
	'cameramodel' => { 381 => 0x410, 525 => 'cameraModel' },
	'cameramodelid' => { 176 => 'CameraModelID' },
	'cameramodelrestriction' => { 496 => 'CameraModelRestriction', 498 => 'CameraModelRestriction' },
	'cameramotion' => { 391 => 'direction.motion' },
	'cameramove' => { 525 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 337 => 0x8f, 376 => 0x1, 381 => 0x100, 430 => [0x16,0x18], 459 => 0x28, 460 => 0x24, 461 => 0x29 },
	'cameraowner' => { 141 => 0xc353 },
	'cameraparameters' => { 319 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 115 => 0x9, 397 => "\xa9gpt" },
	'camerapointcloud' => { 475 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 475 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 475 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 475 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 475 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 475 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 475 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 475 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 475 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 475 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 475 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 475 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 475 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 496 => 'CameraProfile', 498 => 'CameraProfile' },
	'cameraprofiledigest' => { 496 => 'CameraProfileDigest', 498 => 'CameraProfileDigest' },
	'cameraprofiles' => { 513 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 513 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 513 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 513 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 513 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 513 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 513 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 513 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 513 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 513 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 513 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 513 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 513 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 513 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 513 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 513 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 513 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 513 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 513 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 513 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 513 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 513 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 513 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 109 => 0xe1 },
	'camerarawcontrast' => { 109 => 0xe3 },
	'camerarawhighlightpoint' => { 109 => 0xe6 },
	'camerarawlinear' => { 109 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 109 => 0xe8 },
	'camerarawoutputshadowpoint' => { 109 => 0xe9 },
	'camerarawsaturation' => { 109 => 0xe2 },
	'camerarawshadowpoint' => { 109 => 0xe7 },
	'camerarawsharpness' => { 109 => 0xe5 },
	'cameraroll' => { 115 => 0xb, 397 => "\xa9grl" },
	'cameras' => { 475 => 'Cameras' },
	'cameraserialnumber' => { 119 => 0xc62f, 178 => 'CameraSerialNumber', 486 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 314 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 30 => [0x87,0x91], 31 => [0x99,0x9f,0xa4,0xa8,0x105], 33 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 77 => 0xc, 138 => 0x406, 318 => 0x1306, 332 => 0x320, 339 => 0x3402, 372 => 0x47, 411 => 0x43, 463 => 0x5 },
	'cameratemperature4' => { 377 => 0x14 },
	'cameratemperature5' => { 377 => 0x16 },
	'cameratemperaturerangemax' => { 121 => 0x5 },
	'cameratemperaturerangemin' => { 121 => 0x6 },
	'cameratrait' => { 475 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 77 => 0x1a, 319 => 0x207 },
	'cameratype2' => { 315 => 0x100 },
	'cameravendorinfo' => { 475 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 475 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 475 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 475 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 115 => 0xa, 397 => "\xa9gyw" },
	'camreverse' => { 116 => 'CamReverse' },
	'canondr4' => { 120 => 'CanonDR4' },
	'canonexposuremode' => { 34 => 0x14 },
	'canonfiledescription' => { 97 => 0x805 },
	'canonfilelength' => { 64 => 0xe },
	'canonfirmwareversion' => { 64 => 0x7, 97 => 0x80b },
	'canonflashinfo' => { 97 => 0x1028 },
	'canonflashmode' => { 34 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 34 => 0xa },
	'canonimagetype' => { 64 => 0x6, 97 => 0x815 },
	'canonlogversion' => { 63 => 0xb },
	'canonmodelid' => { 64 => 0x10, 97 => 0x1834 },
	'canonvrd' => { 120 => 'CanonVRD' },
	'caption' => { 491 => 'caption' },
	'caption-abstract' => { 131 => 0x78 },
	'captionsauthornames' => { 501 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 501 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 513 => 'CaptionWriter' },
	'captureframerate' => { 113 => 0x4001 },
	'captureheightnormal' => { 138 => 0x1839 },
	'capturelook' => { 138 => 0xc48 },
	'capturemode' => { 391 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 484 => 'CaptureSoftware' },
	'capturewidthnormal' => { 138 => 0x1838 },
	'capturewidthtest' => { 138 => 0x1842 },
	'cardshutterlock' => { 184 => 0x49 },
	'casioimagesize' => { 113 => 0x9 },
	'catalogsets' => { 131 => 0xff, 477 => 'CatalogSets', 489 => 'CatalogSets' },
	'categories' => { 64 => 0x23, 491 => 'categories' },
	'category' => { 131 => 0xf, 179 => 'WM/Category', 313 => 0x30, 389 => 'catg', 513 => 'Category' },
	'cbcrgain' => { 411 => 0xa036 },
	'cbcrgaindefault' => { 411 => 0xa035 },
	'cbcrmatrix' => { 411 => 0xa034 },
	'cbcrmatrixdefault' => { 411 => 0xa033 },
	'ccdboardversion' => { 332 => 0x331 },
	'ccdscanmode' => { 319 => 0x1039 },
	'ccdsensitivity' => { 279 => 0x6 },
	'ccdversion' => { 332 => 0x330 },
	'ccvavgluminancenits' => { 506 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 506 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 506 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 506 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 506 => 'ccv_white_xy' },
	'cellglobalid' => { 495 => 'cgi' },
	'celllength' => { 119 => 0x109 },
	'cellr' => { 495 => 'r' },
	'celltowerid' => { 495 => 'cellid' },
	'cellwidth' => { 119 => 0x108 },
	'centerafarea' => { 307 => '15.1' },
	'centerfocuspoint' => { 311 => '2.2' },
	'centerpixel' => { 138 => 0x40c },
	'centerweightedareasize' => { 296 => '7.1', 297 => '8.1', 299 => '8.1', 300 => '8.1', 304 => '7.1', 305 => '5.1', 306 => '7.1', 307 => '6.3', 309 => '8.1', 310 => '8.1', 311 => '8.1', 312 => 0x1f },
	'certificate' => { 529 => 'Certificate' },
	'cfainterpolationalgorithm' => { 138 => 0xe60 },
	'cfainterpolationmetric' => { 138 => 0xe61 },
	'cfaoffsetcols' => { 138 => 0xc71 },
	'cfaoffsetrows' => { 138 => 0xc6f },
	'cfapattern' => { 119 => 0xa302, 342 => 0x9, 502 => 'CFAPattern' },
	'cfapattern2' => { 119 => 0x828e },
	'cfapatterncolumns' => { 502 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 502 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 502 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 119 => 0x828d },
	'cfazipperfixthreshold' => { 138 => 0xe62 },
	'channel' => { 515 => 'channel' },
	'channela-lang' => { 515 => [\'channel','channelA-lang'] },
	'channelchannel' => { 515 => [\'channel','channelChannel'] },
	'channels' => { 155 => 'Channels' },
	'channelsubchannel1' => { 515 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 515 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 515 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 515 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 397 => 'chpl' },
	'checkmark' => { 103 => 0x10101, 108 => 0x26a },
	'checkmark2' => { 109 => 0x8e },
	'childfontfiles' => { 530 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 296 => '10.3', 297 => '11.2', 312 => 0x10b },
	'chromablurradius' => { 119 => 0xc631 },
	'chromanoisecolorspace' => { 138 => 0xe6d },
	'chromanoiseedgemapthresh' => { 138 => 0xe6c },
	'chromanoisehighfthresh' => { 138 => 0xe6a },
	'chromanoiselowfthresh' => { 138 => 0xe6b },
	'chromaticaberration' => { 103 => 0x20703, 109 => 0x66, 411 => 0xa051 },
	'chromaticaberrationb' => { 496 => 'ChromaticAberrationB', 498 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 103 => 0x20708, 109 => 0x6b },
	'chromaticaberrationcorr' => { 79 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 119 => 0x7034, 362 => 0x1, 472 => 0x900d },
	'chromaticaberrationcorrparams' => { 119 => 0x7035, 467 => 0x66a, 468 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 103 => '0x20703.0', 109 => 0x62 },
	'chromaticaberrationr' => { 496 => 'ChromaticAberrationR', 498 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 103 => 0x20707, 109 => 0x6a },
	'chromaticaberrationsetting' => { 80 => 0x6 },
	'chrominancenoisereduction' => { 103 => 0x20601, 109 => 0x5e, 414 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 109 => 0x60 },
	'circadatecreated' => { 510 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 498 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 496 => 'CircularGradientBasedCorrections', 498 => 'CircularGradientBasedCorrections' },
	'city' => { 131 => 0x5a, 161 => 'City', 337 => 0x6d, 513 => 'City' },
	'city2' => { 337 => 0x80 },
	'clarity' => { 127 => 0x100f, 249 => 0x35, 250 => 0x3d, 437 => 0x2036, 496 => 'Clarity', 498 => 'Clarity' },
	'clarity2012' => { 496 => 'Clarity2012', 498 => 'Clarity2012' },
	'claritycontrol' => { 372 => 0x96 },
	'classification' => { 397 => 'clsf' },
	'classifystate' => { 131 => 0xe1 },
	'clearretouch' => { 337 => 0x7c },
	'clearretouchvalue' => { 337 => 0xa3 },
	'client' => { 525 => 'client' },
	'clientname' => { 504 => 'ClientName' },
	'clipboardaspectratio' => { 496 => 'ClipboardAspectRatio', 498 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 496 => 'ClipboardOrientation', 498 => 'ClipboardOrientation' },
	'clipfilename' => { 397 => 'clfn' },
	'clipid' => { 397 => 'clid' },
	'clmodeshootingspeed' => { 296 => '10.2', 297 => '11.3', 299 => '11.2', 300 => '11.2', 305 => '11.2', 306 => '10.2', 309 => '11.2', 310 => '11.2', 311 => '11.1', 312 => 0x3b },
	'cluster' => { 496 => 'Cluster', 498 => 'Cluster' },
	'cmcontrast' => { 322 => 0x2022 },
	'cmddialsreverserotation' => { 312 => 0xba },
	'cmexposurecompensation' => { 322 => 0x2000 },
	'cmhue' => { 322 => 0x2021 },
	'cmsaturation' => { 322 => 0x2020 },
	'cmsharpness' => { 322 => 0x2023 },
	'cmwhitebalance' => { 322 => 0x2001 },
	'cmwhitebalancecomp' => { 322 => 0x2002 },
	'cmwhitebalancegraypoint' => { 322 => 0x2010 },
	'codec' => { 169 => 'Codec' },
	'codedcharacterset' => { 132 => 0x5a },
	'codeversion' => { 397 => 'cver' },
	'collection' => { 327 => 'Collection' },
	'collectionname' => { 170 => [\'Collections','CollectionsCollectionName'], 397 => 'coll' },
	'collections' => { 170 => 'Collections', 491 => 'collections' },
	'collectionuri' => { 170 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 391 => 'player.movie.visual.color', 514 => 'color' },
	'coloraberrationcontrol' => { 289 => 0xc89224b },
	'coloradjustment' => { 414 => 0x14 },
	'coloradjustmentmode' => { 413 => 0x210 },
	'coloranta' => { 530 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 530 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 530 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 530 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 530 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 530 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 530 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 530 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 530 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 530 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 530 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 530 => 'Colorants' },
	'colorantswatchname' => { 530 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 530 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 530 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 530 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 156 => 'ColorBalance' },
	'colorbalanceadj' => { 289 => 0x76a43202 },
	'colorbalanceblue' => { 181 => 0x1e },
	'colorbalancegreen' => { 181 => 0x1d },
	'colorbalancered' => { 181 => 0x1c },
	'colorbalanceversion' => { 206 => 0x4, 207 => 0x4, 208 => 0x0 },
	'colorblur' => { 109 => 0x65 },
	'colorbluron' => { 103 => 0x20704 },
	'colorbooster' => { 289 => 0x5f0e7d23 },
	'colorboostlevel' => { 283 => 0x1 },
	'colorboosttype' => { 283 => 0x0 },
	'colorchromeeffect' => { 127 => 0x1048 },
	'colorchromefxblue' => { 127 => 0x104e },
	'colorclass' => { 383 => 0xde, 384 => 'ColorClass' },
	'colorcompensationfilter' => { 184 => [0x3a,0x5f], 186 => 0x111, 437 => 0xb022 },
	'colorcompensationfiltercustom' => { 424 => 0xd, 425 => 0xc },
	'colorcompensationfilterset' => { 424 => 0x8, 425 => 0x7, 426 => 0x18, 442 => 0xf },
	'colorcontrol' => { 319 => 0x102b },
	'colorcorrection' => { 472 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 314 => 0x532 },
	'colordataversion' => { 41 => 0x0, 42 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0 },
	'coloreffect' => { 337 => 0x28 },
	'colorfilter' => { 112 => 0x17, 113 => 0x3017, 181 => 0x29, 189 => [0x38,0x4d,0x4f], 379 => 0x17 },
	'colorgain' => { 256 => 0x51 },
	'colorgradeblending' => { 496 => 'ColorGradeBlending', 498 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 496 => 'ColorGradeGlobalHue', 498 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 496 => 'ColorGradeGlobalLum', 498 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 496 => 'ColorGradeGlobalSat', 498 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 496 => 'ColorGradeHighlightLum', 498 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 496 => 'ColorGradeMidtoneHue', 498 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 496 => 'ColorGradeMidtoneLum', 498 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 496 => 'ColorGradeMidtoneSat', 498 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 496 => 'ColorGradeShadowLum', 498 => 'ColorGradeShadowLum' },
	'colorhue' => { 103 => 0x20900, 234 => 0x8d },
	'colorimetricreference' => { 119 => 0xc6bf },
	'colorlabel' => { 501 => 'ColorLabel' },
	'colormatrix' => { 63 => 0xa, 318 => 0x200, 319 => 0x1011, 411 => 0xa030 },
	'colormatrix1' => { 119 => 0xc621, 381 => 0x106 },
	'colormatrix2' => { 119 => 0xc622, 322 => 0x200, 381 => 0x226 },
	'colormatrix3' => { 119 => 0xcd33 },
	'colormatrixa' => { 372 => 0x203 },
	'colormatrixa2' => { 372 => 0x21c },
	'colormatrixadobergb' => { 411 => 0xa032 },
	'colormatrixb' => { 372 => 0x204 },
	'colormatrixb2' => { 372 => 0x21d },
	'colormatrixnumber' => { 319 => 0x1019 },
	'colormatrixsrgb' => { 411 => 0xa031 },
	'colormode' => { 113 => 0x3015, 127 => 0x1210, 140 => 0x66, 181 => 0x28, 184 => 0x16, 186 => 0x101, 187 => 0x36, 189 => 0x7, 234 => 0x3, 279 => 0x4, 337 => 0x32, 414 => 0x2c, 437 => 0xb029, 513 => 'ColorMode' },
	'colormoirereduction' => { 103 => 0x20670, 290 => 0x15 },
	'colormoirereductionmode' => { 290 => 0x5 },
	'colormoirereductionon' => { 103 => '0x20670.0' },
	'colornoisereduction' => { 472 => 0x8029, 496 => 'ColorNoiseReduction', 498 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 496 => 'ColorNoiseReductionDetail', 498 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 290 => 0x18 },
	'colornoisereductionsharpness' => { 290 => 0x1c },
	'colornoisereductionsmoothness' => { 496 => 'ColorNoiseReductionSmoothness', 498 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 123 => 0x2 },
	'colorprofile' => { 181 => 0x33 },
	'colorprofilesettings' => { 314 => 0x539 },
	'colorrepresentation' => { 133 => 0x3c },
	'colorsaturationadj' => { 103 => 0x20305 },
	'colorsequence' => { 133 => 0x41 },
	'colorspace' => { 51 => 0x3, 64 => 0xb4, 97 => 0x10b4, 119 => 0xa001, 135 => 0x3, 162 => 'ColorSpace', 182 => 0x2f, 183 => 0x25, 184 => 0x17, 234 => 0x1e, 314 => 0x507, 372 => 0x37, 411 => 0xa011, 414 => 0xb, 424 => 0x1b, 425 => 0x83, 426 => 0xe, 442 => 0x6, 502 => 'ColorSpace' },
	'colorspace2' => { 63 => 0x9 },
	'colorspecapproximation' => { 135 => 0x2 },
	'colorspecdata' => { 135 => 0x3 },
	'colorspecmethod' => { 135 => 0x0 },
	'colorspecprecedence' => { 135 => 0x1 },
	'colortempasshot' => { 38 => 0x4, 39 => 0x7, 40 => 0x1d, 41 => 0x59, 42 => 0x6d, 43 => 0x26, 44 => 0x43, 47 => 0x43, 48 => 0x43, 49 => 0x43, 50 => 0x4b },
	'colortempauto' => { 38 => 0x9, 39 => 0xf, 40 => 0x22, 41 => 0x5e, 42 => 0x72, 43 => 0x1c, 44 => 0x48, 47 => 0x48, 48 => 0x48, 49 => 0x48, 50 => 0x50 },
	'colortempcloudy' => { 38 => 0x22, 39 => 0x37, 40 => 0x31, 41 => 0xa4, 42 => 0xdb, 43 => 0x35, 44 => 0x5c, 47 => 0x75, 48 => 0x8e, 49 => 0x93, 50 => 0x96, 372 => 0x55 },
	'colortempcustom' => { 44 => 0x84 },
	'colortempcustom1' => { 40 => 0x45 },
	'colortempcustom2' => { 40 => 0x4a },
	'colortempdaylight' => { 38 => 0x18, 39 => 0x27, 40 => 0x27, 41 => 0x9a, 42 => 0xd1, 43 => 0x2b, 44 => 0x52, 47 => 0x6b, 48 => 0x84, 49 => 0x89, 50 => 0x8c, 372 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 64 => 0xae, 74 => 0x9, 97 => 0x10ae, 127 => 0x1005, 138 => 0x846, 156 => 'ColorTemperature', 182 => [0x6e,0x49], 183 => 0x3f, 184 => [0x39,0x5e], 186 => 0x10b, 189 => [0x3c,0x4c,0x4e], 332 => 0x321, 372 => 0x50, 404 => 0x1308, 437 => 0xb021, 496 => 'Temperature', 498 => 'Temperature' },
	'colortemperatureadj' => { 472 => 0x8013 },
	'colortemperatureauto' => { 234 => 0x4f },
	'colortemperaturebg' => { 319 => 0x1013 },
	'colortemperaturecustom' => { 424 => 0xc, 425 => 0xb },
	'colortemperaturerg' => { 319 => 0x1014 },
	'colortemperatureset' => { 424 => 0x7, 425 => 0x6 },
	'colortemperaturesetting' => { 184 => 0x25, 426 => 0x17, 442 => 0xe },
	'colortempflash' => { 38 => 0x36, 39 => 0x57, 40 => 0x40, 41 => 0xb8, 42 => 0xef, 43 => 0x49, 44 => 0x70, 47 => 0x89, 48 => 0xa2, 49 => 0xa7, 50 => 0xaa, 372 => 0x5a },
	'colortempflashdata' => { 44 => 0x24a },
	'colortempfluorescent' => { 38 => 0x2c, 39 => 0x47, 40 => 0x3b, 41 => 0xae, 42 => 0xe5, 43 => 0x3f, 44 => 0x66, 47 => 0x7f, 48 => 0x98, 49 => 0x9d, 50 => 0xa0 },
	'colortempfluorescentd' => { 372 => 0x57 },
	'colortempfluorescentn' => { 372 => 0x58 },
	'colortempfluorescentw' => { 372 => 0x59 },
	'colortempkelvin' => { 38 => 0x31, 39 => 0x4f, 41 => 0xb3, 42 => 0xea, 43 => 0x44, 44 => 0x6b, 47 => 0x84, 48 => 0x9d, 49 => 0xa2, 50 => 0xa5, 337 => 0x44, 404 => 0x1307 },
	'colortempmeasured' => { 38 => 0xe, 39 => 0x17, 41 => 0x63, 42 => 0x77, 44 => 0x4d, 47 => 0x4d, 48 => 0x4d, 49 => 0x4d, 50 => 0x55 },
	'colortemppc1' => { 43 => 0x94, 44 => 0x75 },
	'colortemppc2' => { 43 => 0x99, 44 => 0x7a },
	'colortemppc3' => { 43 => 0x9e, 44 => 0x7f },
	'colortempshade' => { 38 => 0x1d, 39 => 0x2f, 40 => 0x2c, 41 => 0x9f, 42 => 0xd6, 43 => 0x30, 44 => 0x57, 47 => 0x70, 48 => 0x89, 49 => 0x8e, 50 => 0x91, 372 => 0x54 },
	'colortemptungsten' => { 38 => 0x27, 39 => 0x3f, 40 => 0x36, 41 => 0xa9, 42 => 0xe0, 43 => 0x3a, 44 => 0x61, 47 => 0x7a, 48 => 0x93, 49 => 0x98, 50 => 0x9b, 372 => 0x56 },
	'colortempunknown' => { 38 => 0x13, 39 => 0x1f, 41 => 0x68, 42 => 0x7c, 43 => 0x21, 47 => 0x52, 48 => 0x52, 49 => 0x52, 50 => 0x5a },
	'colortempunknown10' => { 38 => 0x63, 39 => 0x9f, 41 => 0x95, 42 => 0xa9, 43 => 0x76, 47 => 0xa2, 48 => 0x7f, 49 => 0x7f, 50 => 0x87 },
	'colortempunknown11' => { 38 => 0x68, 39 => 0xa7, 41 => 0xbd, 42 => [0xae,0xb3], 43 => 0x7b, 47 => 0xa7, 48 => 0xa7, 49 => 0x84, 50 => 0xaf },
	'colortempunknown12' => { 38 => 0x6d, 39 => 0xaf, 41 => 0xc2, 42 => 0xb8, 43 => 0x80, 47 => 0xac, 48 => 0xac, 49 => 0xac, 50 => 0xb4 },
	'colortempunknown13' => { 38 => 0x72, 39 => 0xb7, 41 => 0xc7, 42 => 0xbd, 43 => 0x85, 47 => 0xb1, 48 => 0xb1, 49 => 0xb1, 50 => 0xb9 },
	'colortempunknown14' => { 41 => 0xcc, 42 => 0xc2, 43 => 0x8a, 47 => 0xb6, 48 => 0xb6, 49 => 0xb6, 50 => 0xbe },
	'colortempunknown15' => { 41 => 0xd1, 42 => 0xc7, 43 => 0x8f, 47 => 0xbb, 48 => 0xbb, 49 => 0xbb, 50 => 0xc3 },
	'colortempunknown16' => { 41 => 0xd6, 42 => 0xcc, 43 => 0xa3, 48 => 0xc0, 49 => 0xc0, 50 => 0xc8 },
	'colortempunknown17' => { 41 => 0xdb, 42 => 0xf4, 48 => 0xc5, 49 => 0xc5, 50 => 0xcd },
	'colortempunknown18' => { 41 => 0xe0, 42 => 0xf9, 48 => 0xca, 49 => 0xca, 50 => 0xd2 },
	'colortempunknown19' => { 41 => 0xe5, 42 => 0xfe, 48 => 0xcf, 49 => 0xcf, 50 => 0xd7 },
	'colortempunknown2' => { 38 => 0x3b, 39 => 0x5f, 41 => 0x6d, 42 => 0x81, 43 => 0x4e, 47 => 0x57, 48 => 0x57, 49 => 0x57, 50 => 0x5f },
	'colortempunknown20' => { 41 => 0xea, 42 => 0x103, 48 => 0xd4, 49 => 0xd4, 50 => 0xdc },
	'colortempunknown21' => { 41 => 0xef, 42 => 0x108, 49 => 0xd9, 50 => 0xe1 },
	'colortempunknown22' => { 41 => 0xf4, 42 => 0x10d, 49 => 0xde, 50 => 0xe6 },
	'colortempunknown23' => { 41 => 0xf9, 42 => 0x112, 49 => 0xe3, 50 => 0xeb },
	'colortempunknown24' => { 41 => 0xfe, 42 => 0x117, 49 => 0xe8, 50 => 0xf0 },
	'colortempunknown25' => { 41 => 0x103, 42 => 0x11c, 49 => 0xed, 50 => 0xf5 },
	'colortempunknown26' => { 41 => 0x108, 42 => 0x121, 49 => 0xf2, 50 => 0xfa },
	'colortempunknown27' => { 41 => 0x10d, 42 => 0x126, 49 => 0xf7, 50 => 0xff },
	'colortempunknown28' => { 41 => 0x112, 49 => 0xfc, 50 => 0x104 },
	'colortempunknown29' => { 41 => 0x117, 49 => 0x101, 50 => 0x109 },
	'colortempunknown3' => { 38 => 0x40, 39 => 0x67, 41 => 0x72, 42 => 0x86, 43 => 0x53, 47 => 0x5c, 48 => 0x5c, 49 => 0x5c, 50 => 0x64 },
	'colortempunknown30' => { 49 => 0x106 },
	'colortempunknown4' => { 38 => 0x45, 39 => 0x6f, 41 => 0x77, 42 => 0x8b, 43 => 0x58, 47 => 0x61, 48 => 0x61, 49 => 0x61, 50 => 0x69 },
	'colortempunknown5' => { 38 => 0x4a, 39 => 0x77, 41 => 0x7c, 42 => 0x90, 43 => 0x5d, 47 => 0x66, 48 => 0x66, 49 => 0x66, 50 => 0x6e },
	'colortempunknown6' => { 38 => 0x4f, 39 => 0x7f, 41 => 0x81, 42 => 0x95, 43 => 0x62, 47 => 0x8e, 48 => 0x6b, 49 => 0x6b, 50 => 0x73 },
	'colortempunknown7' => { 38 => 0x54, 39 => 0x87, 41 => 0x86, 42 => 0x9a, 43 => 0x67, 47 => 0x93, 48 => 0x70, 49 => 0x70, 50 => 0x78 },
	'colortempunknown8' => { 38 => 0x59, 39 => 0x8f, 41 => 0x8b, 42 => 0x9f, 43 => 0x6c, 47 => 0x98, 48 => 0x75, 49 => 0x75, 50 => 0x7d },
	'colortempunknown9' => { 38 => 0x5e, 39 => 0x97, 41 => 0x90, 42 => 0xa4, 43 => 0x71, 47 => 0x9d, 48 => 0x7a, 49 => 0x7a, 50 => 0x82 },
	'colortint' => { 336 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 34 => 0x2a, 51 => 0x2, 63 => 0x8 },
	'colortoneadj' => { 103 => 0x20304, 108 => 0x11e },
	'colortoneauto' => { 71 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 70 => 0x6c, 71 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 70 => 0x3c, 71 => 0x3c },
	'colortonemonochrome' => { 70 => 0x84, 71 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 70 => 0x54, 71 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 70 => 0x24, 71 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 70 => 0xc, 71 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 70 => 0x9c, 71 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 70 => 0xb4, 71 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 70 => 0xcc, 71 => 0xe4 },
	'comlenblksize' => { 138 => 0xfde8 },
	'commanddialplaybackmode' => { 312 => 0x1cb },
	'commanddials' => { 307 => '5.1' },
	'commanddialsaperturesetting' => { 296 => '17.3', 297 => '18.3', 299 => '18.3', 300 => '18.3', 305 => '33.3', 306 => '17.3', 309 => '18.3', 310 => '18.3' },
	'commanddialschangemainsub' => { 296 => '17.2', 297 => '18.1', 299 => '18.1', 300 => '18.1', 305 => '33.2', 306 => '17.2', 309 => '18.1', 310 => '18.1' },
	'commanddialsmenuandplayback' => { 296 => '17.4', 297 => '18.2', 299 => '18.2', 300 => '18.2', 305 => '33.4', 306 => '17.4', 309 => '18.2', 310 => '18.2' },
	'commanddialsreverserotation' => { 296 => '17.1', 297 => '6.4', 299 => '6.2', 300 => '6.2', 301 => '16.2', 302 => '17.2', 305 => '33.1', 306 => '17.1', 309 => '6.2', 310 => '6.2', 311 => '18.1' },
	'commanderchannel' => { 307 => '10.2', 308 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 307 => '13.1', 308 => '31.1' },
	'commandergroupa_ttlcomp' => { 311 => '32.1' },
	'commandergroupamanualoutput' => { 307 => '13.2', 308 => '28.2' },
	'commandergroupamode' => { 307 => '11.2', 308 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 307 => '14.1', 308 => '32.1' },
	'commandergroupb_ttlcomp' => { 311 => '33.1' },
	'commandergroupbmanualoutput' => { 307 => '14.2', 308 => '29.2' },
	'commandergroupbmode' => { 307 => '11.3', 308 => '29.1' },
	'commanderinternalflash' => { 307 => '11.1', 308 => '27.1' },
	'commanderinternalmanualoutput' => { 307 => '12.2', 308 => '27.2' },
	'commanderinternalttlchannel' => { 305 => '18.2' },
	'commanderinternalttlcomp' => { 307 => '12.1', 308 => '30.2', 311 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 305 => '20.1', 306 => '26.1' },
	'commanderinternalttlcompgroupa' => { 305 => '21.1', 306 => '27.1' },
	'commanderinternalttlcompgroupb' => { 305 => '22.1', 306 => '28.1' },
	'comment' => { 0 => 0x2, 120 => 'Comment', 157 => 'Comment', 327 => 'Comment', 389 => "\xa9cmt", 391 => 'comment', 397 => "\xa9cmt" },
	'compass' => { 407 => 0x4 },
	'compatibleversion' => { 496 => 'CompatibleVersion', 498 => 'CompatibleVersion' },
	'compilation' => { 389 => 'cpil' },
	'compimageimagespersequence' => { 503 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 503 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 503 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 503 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 503 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 503 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 503 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 503 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 503 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 503 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 515 => 'complianceProfile' },
	'componentsconfiguration' => { 119 => 0x9101, 162 => 'Components', 502 => 'ComponentsConfiguration' },
	'componentversion' => { 97 => 0x80c },
	'composer' => { 179 => 'WM/Composer', 389 => ["\xa9com","\xa9wrt"], 397 => ["\xa9com","\xa9wrt"], 525 => 'composer' },
	'composerkeywords' => { 397 => "\xa9cok" },
	'compositeimage' => { 119 => 0xa460, 503 => 'CompositeImage' },
	'compositeimagecount' => { 119 => 0xa461, 503 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 119 => 0xa462, 503 => 'CompositeImageExposureTimes' },
	'composition' => { 486 => 'Composition' },
	'compositionadjust' => { 371 => '0.1' },
	'compositionadjustrotation' => { 371 => 0x7 },
	'compositionadjustx' => { 371 => 0x5 },
	'compositionadjusty' => { 371 => 0x6 },
	'compressedbitsperpixel' => { 119 => 0x9102, 502 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 186 => 0x40, 319 => 0x40 },
	'compression' => { 119 => 0x103, 342 => 0xb, 521 => 'Compression' },
	'compressionfactor' => { 314 => 0x50d },
	'compressionformat' => { 63 => 0x4 },
	'compressionratio' => { 162 => 'Compression', 319 => 0x1034 },
	'compressorversion' => { 397 => 'CNCV' },
	'condadobvfactor' => { 138 => 0xf3e },
	'condadodaybvthresh' => { 138 => 0xf3c },
	'condadodayoffsets' => { 138 => 0xf42 },
	'condadofluoffsets' => { 138 => 0xf44 },
	'condadofluthresh' => { 138 => 0xf41 },
	'condadoillfactor' => { 138 => 0xf3f },
	'condadoneurange' => { 138 => 0xf3d },
	'condadotunoffsets' => { 138 => 0xf43 },
	'condadotunthresh' => { 138 => 0xf40 },
	'conductor' => { 179 => 'WM/Conductor', 389 => "\xa9con" },
	'confidence' => { 481 => 'Confidence' },
	'confidencelevel' => { 492 => 'ConfidenceLevel' },
	'confidencemime' => { 481 => 'ConfidenceMime' },
	'constrainedcropheight' => { 108 => 0x266, 383 => 0xd6 },
	'constrainedcropwidth' => { 108 => 0x262, 383 => 0xd5 },
	'contact' => { 131 => 0x76 },
	'contactinfo' => { 496 => 'ContactInfo', 498 => 'ContactInfo', 514 => 'contactInfo' },
	'container' => { 475 => 'Container' },
	'containerdirectory' => { 475 => [\'Container','ContainerDirectory'] },
	'containerdirectoryitem' => { 475 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 475 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 475 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 475 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 475 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 510 => 'ContainerFormat' },
	'containerformatidentifier' => { 510 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 510 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 389 => "\xa9day", 397 => ['@day',"\xa9day"] },
	'contentdistributor' => { 179 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 397 => 'cdis' },
	'contentid' => { 397 => 'ccid' },
	'contentlocationcode' => { 131 => 0x1a },
	'contentlocationname' => { 131 => 0x1b },
	'contenttype' => { 515 => 'contentType' },
	'continuousbracketing' => { 184 => 0x20 },
	'continuousdrive' => { 34 => 0x5 },
	'continuousmodedisplay' => { 312 => 0x51 },
	'continuousmodeliveview' => { 310 => '77.2' },
	'continuousshootingspeed' => { 84 => 0x610 },
	'continuousshotlimit' => { 84 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 34 => 0xd, 112 => 0xc, 113 => [0x3012,0x20], 119 => [0xa408,0xfe54], 127 => [0x1004,0x1006], 156 => 'Contrast', 176 => 'Contrast', 181 => 0x20, 182 => 0x31, 183 => 0x27, 184 => 0x19, 189 => 0x2, 248 => 0x33, 249 => 0x37, 250 => 0x3f, 319 => 0x1029, 337 => 0x39, 339 => 0x300a, 372 => 0x20, 379 => 0xc, 391 => 'player.movie.visual.contrast', 398 => 0x24, 400 => 0x52, 404 => 0x1012, 414 => 0xd, 424 => 0x1d, 425 => 0x1a, 437 => 0x2004, 496 => 'Contrast', 498 => 'Contrast', 502 => 'Contrast' },
	'contrast2012' => { 496 => 'Contrast2012', 498 => 'Contrast2012' },
	'contrastadj' => { 103 => 0x20303, 108 => 0x115, 292 => 0x2c, 472 => 0x8017 },
	'contrastauto' => { 71 => 0x90 },
	'contrastcurve' => { 234 => 0x8c },
	'contrastdetectaf' => { 193 => 0x4 },
	'contrastdetectafarea' => { 372 => 0x231 },
	'contrastdetectafinfocus' => { 193 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 70 => 0x60, 71 => 0x60 },
	'contrasthighlight' => { 372 => 0x6d },
	'contrasthighlightshadowadj' => { 372 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 70 => 0x30, 71 => 0x30 },
	'contrastmode' => { 337 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 70 => 0x78, 71 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 70 => 0x48, 71 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 70 => 0x18, 71 => 0x18 },
	'contrastsetting' => { 314 => 0x505, 322 => 0x1012, 426 => 0x10, 442 => 0x8 },
	'contrastshadow' => { 372 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 70 => 0x0, 71 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 70 => 0x90, 71 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 70 => 0xa8, 71 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 70 => 0xc0, 71 => 0xd8 },
	'contributedmedia' => { 525 => 'contributedMedia' },
	'contributedmediaduration' => { 525 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 525 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 525 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 525 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 525 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 525 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 525 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 525 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 525 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 525 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 499 => 'contributor', 510 => 'Contributor' },
	'contributoridentifier' => { 510 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 510 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 510 => [\'Contributor','ContributorRole'] },
	'contributors' => { 157 => 'Contributors' },
	'controldialset' => { 184 => 0x46 },
	'controlledvocabularyterm' => { 510 => 'CVterm' },
	'controllerboardversion' => { 332 => 0x332 },
	'controlmode' => { 77 => 0x12 },
	'controlringresponse' => { 312 => 0x1d5 },
	'controlringrotation' => { 84 => 0x712 },
	'conversionlens' => { 315 => 0x403, 337 => 0x35 },
	'converter' => { 119 => 0xfe4d, 279 => 0xb, 496 => 'Converter', 498 => 'Converter' },
	'converttograyscale' => { 496 => 'ConvertToGrayscale', 498 => 'ConvertToGrayscale' },
	'cookingequipment' => { 517 => 'cookingEquipment' },
	'cookingmethod' => { 517 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 119 => 0x8298, 157 => 'Copyright', 327 => 'Copyright', 342 => 0x8298, 372 => 0x22f, 388 => 'Copyright', 389 => ['cprt',"\xa9cpy"], 391 => 'copyright', 397 => ['cprt',"\xa9cpy"], 496 => 'Copyright', 498 => 'Copyright', 512 => 'Copyright', 518 => 'copyright', 521 => 'Copyright', 525 => 'copyright' },
	'copyrightflag' => { 386 => 0x40a },
	'copyrightnotice' => { 131 => 0x74 },
	'copyrightowner' => { 324 => 'CopyrightOwner' },
	'copyrightownerid' => { 324 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 324 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 324 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 324 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 324 => 'CopyrightStatus' },
	'copyrightyear' => { 510 => 'CopyrightYear', 515 => 'copyrightYear' },
	'coringfilter' => { 318 => 0x310, 319 => 0x102d, 322 => 0x310 },
	'coringvalues' => { 318 => 0x311, 322 => 0x311 },
	'corporateentity' => { 515 => 'corporateEntity' },
	'correlatedcolortemp' => { 336 => 0x35b },
	'country' => { 161 => 'Country', 337 => 0x69, 513 => 'Country' },
	'country-primarylocationcode' => { 131 => 0x64 },
	'country-primarylocationname' => { 131 => 0x65 },
	'countrycode' => { 233 => 0x5, 384 => 'CountryCode', 509 => 'CountryCode' },
	'course' => { 517 => 'course' },
	'coverage' => { 499 => 'coverage' },
	'coverart' => { 389 => 'covr' },
	'coverdate' => { 515 => 'coverDate' },
	'coverdisplaydate' => { 515 => 'coverDisplayDate' },
	'coveruri' => { 397 => 'cvru' },
	'cpufirmwareversion' => { 372 => 0x28 },
	'crc32' => { 500 => 'crc32' },
	'createdate' => { 119 => 0x9004, 157 => 'CreateDate', 323 => 'CreationDate', 327 => 'create-date', 388 => 'CreationDate', 394 => 0x1, 523 => 'CreateDate' },
	'creationdate' => { 391 => 'creationdate', 512 => 'CreationDate', 515 => 'creationDate' },
	'creationtime' => { 327 => 'Creation Time' },
	'creativestyle' => { 424 => 0x1a, 425 => 0x18, 435 => 0x41, 437 => 0xb020, 468 => 0x4a },
	'creativestylesetting' => { 426 => 0xf, 442 => 0x7 },
	'creativestylewaschanged' => { 472 => 0x8001 },
	'creator' => { 323 => 'Creator', 388 => 'Creator', 499 => 'creator', 510 => 'Creator', 512 => 'Creator' },
	'creatoraddress' => { 509 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 178 => 'CreatorAppId' },
	'creatorcity' => { 509 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 509 => 'CreatorContactInfo' },
	'creatorcountry' => { 509 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 510 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 510 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 178 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 509 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 509 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 510 => [\'Creator','CreatorRole'] },
	'creatortool' => { 523 => 'CreatorTool' },
	'creatorworkemail' => { 509 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 509 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 509 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 131 => 0x6e, 513 => 'Credit' },
	'creditline' => { 518 => 'creditLine' },
	'creditlinereq' => { 528 => 'CreditLineReq' },
	'creditlinerequired' => { 324 => 'CreditLineRequired' },
	'cropactive' => { 101 => 0x0, 108 => 0x244 },
	'cropangle' => { 496 => 'CropAngle', 498 => 'CropAngle' },
	'croparea' => { 234 => 0x45, 472 => 0x9011 },
	'cropaspectratio' => { 103 => 0x30101, 108 => 0x260 },
	'cropaspectratiocustom' => { 103 => 0x30102 },
	'cropbottom' => { 123 => 0x9, 284 => 0x36, 342 => 0x31, 383 => 0xdc, 496 => 'CropBottom', 498 => 'CropBottom' },
	'cropbottommargin' => { 53 => 0x3 },
	'cropcircleactive' => { 109 => 0xd6 },
	'cropcircleradius' => { 109 => 0xd9 },
	'cropcirclex' => { 109 => 0xd7 },
	'cropcircley' => { 109 => 0xd8 },
	'cropconstraintowarp' => { 496 => 'CropConstrainToWarp', 498 => 'CropConstrainToWarp' },
	'croph' => { 490 => 'CropH' },
	'cropheight' => { 101 => 0x6, 108 => 0x24c, 318 => 0x615, 322 => 0x615, 496 => 'CropHeight', 498 => 'CropHeight' },
	'crophispeed' => { 234 => 0x1b },
	'cropleft' => { 108 => 0x246, 123 => 0x6, 284 => 0x1e, 318 => 0x612, 322 => 0x612, 342 => 0x30, 383 => 0xd9, 496 => 'CropLeft', 498 => 'CropLeft' },
	'cropleftmargin' => { 53 => 0x0 },
	'cropmode' => { 127 => 0x104d, 404 => 0x1018 },
	'croporiginalheight' => { 101 => 0xb },
	'croporiginalwidth' => { 101 => 0xa },
	'cropoutputheight' => { 284 => 0xce },
	'cropoutputheightinches' => { 284 => 0x96 },
	'cropoutputpixels' => { 284 => 0xd6 },
	'cropoutputresolution' => { 284 => 0xb6 },
	'cropoutputscale' => { 284 => 0xbe },
	'cropoutputwidth' => { 284 => 0xc6 },
	'cropoutputwidthinches' => { 284 => 0x8e },
	'croppedareaimageheightpixels' => { 484 => 'CroppedAreaImageHeightPixels', 485 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 484 => 'CroppedAreaImageWidthPixels', 485 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 484 => 'CroppedAreaLeftPixels', 485 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 484 => 'CroppedAreaTopPixels', 485 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 404 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 404 => 0x1603 },
	'cropping' => { 472 => 0x9010 },
	'cropright' => { 123 => 0x8, 284 => 0x2e, 342 => 0x32, 383 => 0xdb, 496 => 'CropRight', 498 => 'CropRight' },
	'croprightmargin' => { 53 => 0x1 },
	'croprotatedoriginalheight' => { 101 => 0x2 },
	'croprotatedoriginalwidth' => { 101 => 0x1 },
	'croprotation' => { 101 => 0x8, 123 => 0xb },
	'cropscaledresolution' => { 284 => 0x9e },
	'cropsourceresolution' => { 284 => 0xae },
	'croptop' => { 108 => 0x248, 123 => 0x7, 284 => 0x26, 318 => 0x613, 322 => 0x613, 342 => 0x2f, 383 => 0xda, 496 => 'CropTop', 498 => 'CropTop' },
	'croptopmargin' => { 53 => 0x2 },
	'cropunit' => { 496 => 'CropUnit', 498 => 'CropUnit' },
	'cropunits' => { 496 => 'CropUnits', 498 => 'CropUnits' },
	'cropw' => { 490 => 'CropW' },
	'cropwidth' => { 101 => 0x5, 108 => 0x24a, 318 => 0x614, 322 => 0x614, 496 => 'CropWidth', 498 => 'CropWidth' },
	'cropx' => { 101 => 0x3, 490 => 'CropX' },
	'cropy' => { 101 => 0x4, 490 => 'CropY' },
	'crossprocess' => { 372 => 0x7b },
	'crossprocessparams' => { 372 => 0x235 },
	'cuisine' => { 517 => 'cuisine' },
	'currenticcprofile' => { 119 => 0xc691 },
	'currentpreprofilematrix' => { 119 => 0xc692 },
	'currentversion' => { 472 => 0xd000 },
	'curve0x' => { 490 => 'Curve0x' },
	'curve0y' => { 490 => 'Curve0y' },
	'curve1x' => { 490 => 'Curve1x' },
	'curve1y' => { 490 => 'Curve1y' },
	'curve2x' => { 490 => 'Curve2x' },
	'curve2y' => { 490 => 'Curve2y' },
	'curve3x' => { 490 => 'Curve3x' },
	'curve3y' => { 490 => 'Curve3y' },
	'curve4x' => { 490 => 'Curve4x' },
	'curve4y' => { 490 => 'Curve4y' },
	'curves' => { 289 => 0x76a43201 },
	'custom1' => { 324 => 'Custom1' },
	'custom10' => { 324 => 'Custom10' },
	'custom2' => { 324 => 'Custom2' },
	'custom3' => { 324 => 'Custom3' },
	'custom4' => { 324 => 'Custom4' },
	'custom5' => { 324 => 'Custom5' },
	'custom6' => { 324 => 'Custom6' },
	'custom7' => { 324 => 'Custom7' },
	'custom8' => { 324 => 'Custom8' },
	'custom9' => { 324 => 'Custom9' },
	'customcolortone' => { 109 => 0x4c },
	'customcontrast' => { 109 => 0x4e },
	'customcontrols' => { 84 => 0x70c },
	'customdefaultunsharpfineness' => { 109 => 0xbe },
	'customdefaultunsharpstrength' => { 109 => 0xbc },
	'customdefaultunsharpthreshold' => { 109 => 0xc0 },
	'customilluminant' => { 138 => 0x405 },
	'customizedials' => { 84 => 0x715 },
	'customlinear' => { 109 => 0x4f },
	'customoutputhighlightpoint' => { 109 => 0x53 },
	'customoutputshadowpoint' => { 109 => 0x54 },
	'custompicturestyle' => { 103 => 0x10021 },
	'custompicturestyledata' => { 103 => 0xf0500 },
	'custompicturestylefilename' => { 64 => 0x4010 },
	'customrawhighlight' => { 109 => 0x7c },
	'customrawhighlightpoint' => { 109 => 0x51 },
	'customrawshadow' => { 109 => 0x85 },
	'customrawshadowpoint' => { 109 => 0x52 },
	'customrendered' => { 119 => 0xa401, 191 => 0x6420, 502 => 'CustomRendered' },
	'customsaturation' => { 109 => 0x4d, 314 => 0x503 },
	'customsettingsalldefault' => { 296 => '0.2', 305 => '0.2' },
	'customsettingsbank' => { 296 => '0.1', 297 => '0.1', 299 => '0.1', 300 => '0.1', 305 => '0.1', 309 => '0.2', 310 => '0.2', 312 => 0x1 },
	'customsharpness' => { 109 => 0x50 },
	'customunsharpmaskfineness' => { 109 => 0xb8 },
	'customunsharpmaskstrength' => { 109 => 0xb6 },
	'customunsharpmaskthreshold' => { 109 => 0xba },
	'customwb_rblevels' => { 442 => 0x1a },
	'customwb_rgblevels' => { 425 => 0x8, 426 => 0x19 },
	'customwbbluelevel' => { 184 => 0x36 },
	'customwberror' => { 184 => 0x37 },
	'customwbgreenlevel' => { 184 => 0x35 },
	'customwbredlevel' => { 184 => 0x34 },
	'customwbsetting' => { 184 => 0x26 },
	'cx' => { 397 => '_cx_' },
	'cy' => { 397 => '_cy_' },
	'd-lightinghq' => { 289 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 285 => 0x2 },
	'd-lightinghqhighlight' => { 285 => 0x1 },
	'd-lightinghqselected' => { 289 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 285 => 0x0 },
	'd-lightinghs' => { 289 => 0xce5554aa },
	'd-lightinghsadjustment' => { 286 => 0x0 },
	'd-lightinghscolorboost' => { 286 => 0x1 },
	'd-rangeoptimizerhighlight' => { 472 => 0x8024 },
	'd-rangeoptimizermode' => { 472 => 0x8022 },
	'd-rangeoptimizershadow' => { 472 => 0x802d },
	'd-rangeoptimizervalue' => { 472 => 0x8023 },
	'darkblacksegrows' => { 138 => 0x18d8 },
	'darkfocusenvironment' => { 337 => 0x8003 },
	'darkframecountfactor' => { 138 => 0xc85 },
	'darkframelongexposure' => { 138 => 0xc84 },
	'darkframeshortexposure' => { 138 => 0xc83 },
	'darkpedestal' => { 138 => 0xc7f },
	'datacompressionmethod' => { 133 => 0x6e },
	'dataimprint' => { 181 => 0x34 },
	'dataonscreen' => { 510 => 'DataOnScreen' },
	'dataonscreenregion' => { 510 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 510 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 510 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 510 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 510 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 510 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 510 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 510 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 372 => 0x3d },
	'date' => { 372 => 0x6, 499 => 'date' },
	'dateacquired' => { 178 => 'DateAcquired', 179 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 131 => 0x37, 513 => 'DateCreated' },
	'datedisplayformat' => { 281 => 0x3 },
	'dateidentified' => { 118 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 301 => '4.2' },
	'daterecieved' => { 515 => 'dateRecieved' },
	'datesent' => { 132 => 0x46 },
	'datestampmode' => { 64 => 0x1c, 234 => 0x9d },
	'datetime' => { 491 => 'datetime', 521 => 'DateTime' },
	'datetimedigitized' => { 502 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 100 => 0x0, 119 => 0x9003, 154 => 0x14, 157 => 'OriginalDate', 392 => 'IDIT', 397 => 'date', 398 => 0xb, 399 => 0x3b, 400 => 0x3e, 502 => 'DateTimeOriginal' },
	'datetimestamp' => { 140 => 0x64 },
	'datetimeutc' => { 314 => 0x908 },
	'daylightsavings' => { 78 => 0x3, 281 => 0x2 },
	'dayofweek' => { 399 => 0x42, 400 => 0x4a },
	'dccontinent' => { 118 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 118 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 118 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 118 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 118 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 118 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 118 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 118 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 118 => 'Event' },
	'dcfootprintspatialfit' => { 118 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 118 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 118 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 118 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 118 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 118 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 118 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 118 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 118 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 118 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 118 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 118 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 118 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 118 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 118 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 118 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 118 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 118 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 165 => 'Declination' },
	'decposition' => { 181 => 0x32 },
	'defaultautogray' => { 496 => 'DefaultAutoGray', 498 => 'DefaultAutoGray' },
	'defaultautotone' => { 496 => 'DefaultAutoTone', 498 => 'DefaultAutoTone' },
	'defaultblackrender' => { 119 => 0xc7a6 },
	'defaultcroporigin' => { 119 => 0xc61f },
	'defaultcropsize' => { 119 => 0xc620 },
	'defaulteraseoption' => { 84 => 0x813 },
	'defaultscale' => { 119 => 0xc61e },
	'defaultsspecifictoiso' => { 496 => 'DefaultsSpecificToISO', 498 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 496 => 'DefaultsSpecificToSerial', 498 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 119 => 0xc7b5 },
	'defectisocode' => { 138 => 0x90f },
	'defringe' => { 496 => 'Defringe', 498 => 'Defringe' },
	'defringegreenamount' => { 496 => 'DefringeGreenAmount', 498 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 496 => 'DefringeGreenHueHi', 498 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 496 => 'DefringeGreenHueLo', 498 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 496 => 'DefringePurpleAmount', 498 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 496 => 'DefringePurpleHueHi', 498 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 496 => 'DefringePurpleHueLo', 498 => 'DefringePurpleHueLo' },
	'dehaze' => { 496 => 'Dehaze', 498 => 'Dehaze' },
	'deletedimagecount' => { 234 => 0xa6, 261 => 0x6e },
	'deprecatedon' => { 494 => 'deprecatedOn' },
	'depthfar' => { 119 => 0xc7eb },
	'depthformat' => { 119 => 0xc7e9 },
	'depthimage' => { 481 => 'Data' },
	'depthmeasuretype' => { 119 => 0xc7ed },
	'depthnear' => { 119 => 0xc7ea },
	'depthunits' => { 119 => 0xc7ec },
	'derivedfrom' => { 526 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 526 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 526 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 526 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 526 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 526 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 526 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 526 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 526 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 526 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 526 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 526 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 526 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 526 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 526 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 526 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 526 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 526 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 526 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 526 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 526 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 526 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 526 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 526 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 327 => 'Description', 389 => ['desc','dscp',"\xa9des"], 391 => 'description', 397 => 'dscp', 496 => 'Description', 498 => 'Description', 499 => 'description', 523 => 'Description' },
	'destination' => { 132 => 0x5 },
	'destinationcity' => { 372 => 0x24, 378 => 0x3 },
	'destinationcitycode' => { 379 => 0x1001 },
	'destinationdst' => { 372 => 0x26, 378 => '0.3' },
	'developmentdynamicrange' => { 127 => 0x1403 },
	'deviantmatrixcustom' => { 138 => 0x7de },
	'deviantmatrixdaylight' => { 138 => 0x7da },
	'deviantmatrixflash' => { 138 => 0x7dd },
	'deviantmatrixfluorescent' => { 138 => 0x7dc },
	'deviantmatrixtungsten' => { 138 => 0x7db },
	'deviantwhitecustom' => { 138 => 0x842 },
	'deviantwhitedaylight' => { 138 => 0x83e },
	'deviantwhiteflash' => { 138 => 0x841 },
	'deviantwhitefluorescent' => { 138 => 0x840 },
	'deviantwhitetungsten' => { 138 => 0x83f },
	'device' => { 515 => 'device' },
	'devicesettingdescription' => { 502 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 502 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 502 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 502 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 411 => 0x2 },
	'dewarpdata' => { 116 => 'DewarpData' },
	'dewarpflag' => { 116 => 'DewarpFlag' },
	'dialdirectiontvav' => { 84 => 0x706 },
	'dietaryneeds' => { 517 => 'dietaryNeeds' },
	'diffractioncompensation' => { 223 => 0x20e, 238 => 0x142, 239 => 0x1a2, 240 => 0x1b6, 241 => 0x1b6 },
	'diffractioncorrection' => { 337 => 0xbc, 362 => 0x3 },
	'diffractioncorrectionon' => { 103 => 0x2070b },
	'digitalcreationdate' => { 131 => 0x3e },
	'digitalcreationtime' => { 131 => 0x3f },
	'digitaldeehighlightadj' => { 256 => 0x202 },
	'digitaldeeshadowadj' => { 256 => 0x200 },
	'digitaldeethreshold' => { 256 => 0x201 },
	'digitalfilter' => { 414 => 0x59 },
	'digitalfilter01' => { 359 => 0x5 },
	'digitalfilter02' => { 359 => 0x16 },
	'digitalfilter03' => { 359 => 0x27 },
	'digitalfilter04' => { 359 => 0x38 },
	'digitalfilter05' => { 359 => 0x49 },
	'digitalfilter06' => { 359 => 0x5a },
	'digitalfilter07' => { 359 => 0x6b },
	'digitalfilter08' => { 359 => 0x7c },
	'digitalfilter09' => { 359 => 0x8d },
	'digitalfilter10' => { 359 => 0x9e },
	'digitalfilter11' => { 359 => 0xaf },
	'digitalfilter12' => { 359 => 0xc0 },
	'digitalfilter13' => { 359 => 0xd1 },
	'digitalfilter14' => { 359 => 0xe2 },
	'digitalfilter15' => { 359 => 0xf3 },
	'digitalfilter16' => { 359 => 0x104 },
	'digitalfilter17' => { 359 => 0x115 },
	'digitalfilter18' => { 359 => 0x126 },
	'digitalfilter19' => { 359 => 0x137 },
	'digitalfilter20' => { 359 => 0x148 },
	'digitalgain' => { 74 => 0xb },
	'digitalgem' => { 218 => 0x0 },
	'digitalice' => { 256 => 0x100 },
	'digitalimageguid' => { 510 => 'DigImageGUID' },
	'digitallensoptimizer' => { 62 => 0xa },
	'digitallensoptimizersetting' => { 80 => 0x9 },
	'digitalroc' => { 253 => 0x0 },
	'digitalsourcefiletype' => { 510 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 510 => 'DigitalSourceType' },
	'digitalzoom' => { 34 => 0xc, 112 => 0xa, 127 => 0x1044, 140 => 0x68, 151 => 0x22, 152 => 0x1e, 156 => 'DigitalZoom', 181 => 0xc, 234 => 0x86, 279 => 0xa, 319 => 0x204, 372 => 0x1e, 379 => 0xa, 413 => 0x204, 459 => 0x12, 460 => 0x12 },
	'digitalzoomon' => { 413 => 0x21b },
	'digitalzoomratio' => { 119 => 0xa404, 448 => 0x200, 450 => 0x21c, 502 => 'DigitalZoomRatio' },
	'director' => { 179 => 'WM/Director', 389 => "\xa9dir", 391 => 'director', 397 => "\xa9dir", 525 => 'director' },
	'directorphotography' => { 525 => 'directorPhotography' },
	'directory' => { 120 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 211 => 0x3, 400 => 0x12 },
	'disableautocreation' => { 479 => 'DisableAutoCreation' },
	'disclaimer' => { 327 => 'Disclaimer' },
	'discnumber' => { 525 => 'discNumber' },
	'dishtype' => { 517 => 'dishType' },
	'disknumber' => { 389 => 'disk' },
	'dispbutton' => { 241 => 0x7d4 },
	'displayallafpoints' => { 84 => 0x514 },
	'displayaperture' => { 34 => 0x23 },
	'displayedunitsx' => { 387 => 0x2 },
	'displayedunitsy' => { 387 => 0x6 },
	'displayname' => { 391 => 'displayname', 514 => 'displayName' },
	'distance1' => { 140 => 0x28 },
	'distance2' => { 140 => 0x2c },
	'distance3' => { 140 => 0x30 },
	'distance4' => { 140 => 0x34 },
	'distortion' => { 411 => 0xa050 },
	'distortioncompensation' => { 472 => 0x8040 },
	'distortioncontrol' => { 261 => 0x10 },
	'distortioncorrection' => { 79 => 0x3, 103 => 0x20705, 109 => 0x67, 119 => 0x7036, 314 => 0x50b, 341 => '7.1', 362 => 0x0, 467 => 0x601, 468 => 0x5b },
	'distortioncorrection2' => { 318 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 493 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 103 => '0x20705.0', 109 => 0x63 },
	'distortioncorrectionsetting' => { 80 => 0x7, 437 => 0x2013 },
	'distortioncorrectionvalue' => { 79 => 0x9 },
	'distortioncorrparams' => { 119 => 0x7037, 447 => 0x1a23, 450 => 0x1870, 452 => 0x189c, 453 => 0x18cc, 454 => 0x17d0, 467 => 0x6ca, 468 => 0x64 },
	'distortioncorrparamsnumber' => { 450 => 0x1899, 452 => 0x18c5, 453 => 0x18f5, 454 => 0x17f9 },
	'distortioncorrparamspresent' => { 450 => 0x1898, 452 => 0x18c4, 453 => 0x18f4, 454 => 0x17f8, 456 => 0x10b, 457 => 0x10b, 467 => 0x600, 468 => 0x5a },
	'distortioneffect' => { 103 => 0x20709 },
	'distortionn' => { 341 => 0xc },
	'distortionparam02' => { 341 => 0x2 },
	'distortionparam04' => { 341 => 0x4 },
	'distortionparam08' => { 341 => 0x8 },
	'distortionparam09' => { 341 => 0x9 },
	'distortionparam11' => { 341 => 0xb },
	'distortionscale' => { 341 => 0x5 },
	'distributor' => { 515 => 'distributor' },
	'distributorproductid' => { 514 => 'distributorProductID' },
	'dloon' => { 103 => '0x20706.0', 109 => 0xdc },
	'dlosetting' => { 103 => 0x20706, 109 => 0xdd },
	'dlosettingapplied' => { 102 => 0x4 },
	'dloshootingdistance' => { 109 => 0xde },
	'dloversion' => { 102 => 0x5 },
	'dmcomment' => { 525 => 'comment' },
	'dmdithermatrix' => { 138 => 0xc7a },
	'dmdithermatrixheight' => { 138 => 0xc7c },
	'dmdithermatrixwidth' => { 138 => 0xc7b },
	'dngadobedata' => { 119 => 0xc634 },
	'dngbackwardversion' => { 119 => 0xc613 },
	'dngignoresidecars' => { 496 => 'DNGIgnoreSidecars', 498 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 119 => 0xc630 },
	'dngprivatedata' => { 119 => 0xc634 },
	'dngversion' => { 119 => 0xc612 },
	'document' => { 327 => 'Document' },
	'documentancestors' => { 513 => 'DocumentAncestors' },
	'documenthistory' => { 131 => 0xe7 },
	'documentid' => { 526 => 'DocumentID' },
	'documentname' => { 119 => 0x10d },
	'documentnotes' => { 131 => 0xe6 },
	'doi' => { 515 => 'doi' },
	'dopesheet' => { 510 => 'Dopesheet' },
	'dopesheetlink' => { 510 => 'DopesheetLink' },
	'dopesheetlinklink' => { 510 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 510 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 138 => 0xc82 },
	'dpp' => { 491 => 'dpp' },
	'dr4cameramodel' => { 104 => 0x3 },
	'drangepriority' => { 127 => 0x1443 },
	'drangepriorityauto' => { 127 => 0x1444 },
	'drangepriorityfixed' => { 127 => 0x1445 },
	'drivemode' => { 113 => 0x3103, 125 => '0.1', 181 => 0x6, 184 => 0x1e, 187 => 0xe, 191 => 0x64d0, 314 => 0x600, 372 => 0x34, 404 => 0x1002, 414 => 0x3, 424 => 0x4, 425 => 0x7e, 426 => 0x34 },
	'drivemode2' => { 184 => 0xa, 353 => 0x7, 435 => 0xe, 442 => 0x1 },
	'drivemodesetting' => { 426 => 0x4 },
	'drivespeed' => { 125 => '0.2' },
	'dspfirmwareversion' => { 372 => 0x27 },
	'duration' => { 67 => 0x6a, 155 => 'Duration', 169 => 'Duration', 517 => 'duration', 525 => 'duration' },
	'durationscale' => { 525 => [\'duration','durationScale'] },
	'durationvalue' => { 525 => [\'duration','durationValue'] },
	'dustremovaldata' => { 64 => 0x97 },
	'dxcropalert' => { 239 => 0x23c, 240 => 0x250, 241 => 0x250 },
	'dynamicafarea' => { 296 => '1.4', 305 => '1.4' },
	'dynamicafareasize' => { 239 => 0x240, 240 => 0x254, 241 => 0x254 },
	'dynamicareaafassist' => { 312 => 0x18 },
	'dynamicareaafdisplay' => { 297 => '46.1', 299 => '47.1', 300 => '47.1', 309 => '47.1', 310 => '47.1' },
	'dynamicrange' => { 127 => 0x1400 },
	'dynamicrangeboost' => { 337 => 0xee },
	'dynamicrangeexpansion' => { 372 => 0x69, 404 => 0x100e },
	'dynamicrangemax' => { 108 => 0x7c },
	'dynamicrangemin' => { 108 => 0x7a },
	'dynamicrangeoptimizer' => { 184 => 0x15, 437 => [0xb025,0xb04f], 446 => 0x1144, 447 => [0x1144,0x324], 448 => [0x1120,0x300], 449 => [0x119c,0x37c], 450 => [0x1178,0x328], 451 => [0x1030,0x50], 452 => [0x228,0x50], 453 => [0x228,0x50], 454 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 435 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 424 => 0x19, 425 => 0x17, 426 => 0xd, 435 => 0x79, 442 => 0x5 },
	'dynamicrangeoptimizermode' => { 187 => 0x15, 424 => 0x18, 425 => 0x16, 435 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 184 => 0x27, 426 => 0xc, 442 => 0x4 },
	'dynamicrangesetting' => { 127 => 0x1402 },
	'e-dialinprogram' => { 353 => '1.3' },
	'earliestageorloweststage' => { 118 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 475 => 'EarthPos' },
	'earthposaltitude' => { 475 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 475 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 475 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 475 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 475 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 475 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 475 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 475 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 311 => '6.1' },
	'easyexposurecompensation' => { 296 => '6.4', 297 => '6.5', 299 => '6.3', 300 => '6.3', 304 => '5.1', 305 => '4.4', 306 => '5.2', 309 => '6.3', 310 => '6.3', 312 => 0x1d },
	'easymode' => { 34 => 0xb },
	'edgemapslope' => { 138 => 0x930 },
	'edgemapx1' => { 138 => 0x931 },
	'edgemapx2' => { 138 => 0x932 },
	'edgemapx3' => { 138 => 0x934 },
	'edgemapx4' => { 138 => 0x935 },
	'edgenoisereduction' => { 290 => 0x4, 472 => 0x8028 },
	'edit1' => { 397 => "\xa9ed1" },
	'edit2' => { 397 => "\xa9ed2" },
	'edit3' => { 397 => "\xa9ed3" },
	'edit4' => { 397 => "\xa9ed4" },
	'edit5' => { 397 => "\xa9ed5" },
	'edit6' => { 397 => "\xa9ed6" },
	'edit7' => { 397 => "\xa9ed7" },
	'edit8' => { 397 => "\xa9ed8" },
	'edit9' => { 397 => "\xa9ed9" },
	'edition' => { 515 => 'edition' },
	'editorialupdate' => { 131 => 0x8 },
	'editstatus' => { 131 => 0x7, 384 => 'EditStatus', 491 => 'EditStatus' },
	'editversionname' => { 289 => 0x3d136244 },
	'effectivelv' => { 372 => 0x2d },
	'effectivemaxaperture' => { 227 => 0x12, 228 => 0x13, 232 => 0x14 },
	'eissn' => { 515 => 'eIssn' },
	'electricalblackcolumns' => { 138 => 0x1810 },
	'electronicfront-curtainshutter' => { 299 => '5.2', 300 => '5.2', 309 => '5.3', 310 => '5.2' },
	'electronicfrontcurtainshutter' => { 437 => 0x201a },
	'elevation' => { 165 => 'Elevation' },
	'email' => { 157 => 'EMail' },
	'embargodate' => { 518 => 'embargoDate' },
	'embdencrightsexpr' => { 510 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 510 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 510 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 510 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 513 => 'EmbeddedXMPDigest' },
	'emissivity' => { 121 => 0x3 },
	'emptyslotrelease' => { 239 => 0x625, 240 => 0x655, 241 => 0x6bd },
	'enablechromanoisereduction' => { 138 => 0xe6e },
	'enablesharpening' => { 138 => 0x92e },
	'encodedby' => { 179 => 'WM/EncodedBy', 389 => "\xa9enc" },
	'encodedwith' => { 391 => 'Encoded_With' },
	'encoder' => { 389 => "\xa9too", 397 => "\xa9too" },
	'encoderid' => { 397 => "\xa9enc" },
	'encodingtime' => { 179 => 'WM/EncodingTime' },
	'encryptionkey' => { 411 => 0xa020 },
	'endingpage' => { 515 => 'endingPage' },
	'enduser' => { 324 => 'EndUser' },
	'enduserid' => { 324 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 324 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 239 => 0x648, 240 => 0x678, 241 => 0x6e0 },
	'engineer' => { 525 => 'engineer' },
	'enhancedarktones' => { 282 => 0x8 },
	'enhancedenoisealreadyapplied' => { 493 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 493 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 493 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 493 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 493 => 'EnhanceDetailsVersion' },
	'enhancement' => { 112 => 0x16, 113 => 0x3016 },
	'enhanceparams' => { 119 => 0xc7ee },
	'enhancer' => { 318 => 0x300 },
	'enhancervalues' => { 318 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 493 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 493 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 493 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 132 => 0x28 },
	'envelopepriority' => { 132 => 0x3c },
	'enveloperecordversion' => { 132 => 0x0 },
	'episode' => { 510 => 'Episode' },
	'episodeglobaluniqueid' => { 389 => 'egid' },
	'episodeidentifier' => { 510 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 510 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 510 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 319 => 0x20c },
	'epsonimagewidth' => { 319 => 0x20b },
	'epsonsoftware' => { 319 => 0x20d },
	'equipmentinstitution' => { 474 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 474 => 'EquipmentManufacturer' },
	'equipmentversion' => { 315 => 0x0 },
	'ettlii' => { 84 => 0x304, 85 => 0xd, 86 => 0xe, 87 => 0x7, 88 => 0x7, 89 => 0xe },
	'event' => { 477 => 'Event', 489 => 'Event', 510 => 'Event', 515 => 'event' },
	'eventalias' => { 514 => 'eventAlias' },
	'eventdate' => { 118 => [\'Event','EventEventDate'] },
	'eventday' => { 118 => [\'Event','EventDay'] },
	'eventearliestdate' => { 118 => [\'Event','EventEarliestDate'] },
	'eventend' => { 514 => 'eventEnd' },
	'eventenddayofyear' => { 118 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 118 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 118 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 118 => [\'Event','EventHabitat'] },
	'eventid' => { 118 => [\'Event','EventEventID'], 510 => 'EventId' },
	'eventlatestdate' => { 118 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 118 => [\'Event','EventMonth'] },
	'eventnumber' => { 398 => 0x9, 399 => 0x37, 400 => 0x3a },
	'eventparenteventid' => { 118 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 118 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 118 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 118 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 118 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 118 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 514 => 'eventStart' },
	'eventstartdayofyear' => { 118 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 514 => 'eventSubtype' },
	'eventtime' => { 118 => [\'Event','EventEventTime'] },
	'eventtype' => { 514 => 'eventType' },
	'eventverbatimeventdate' => { 118 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 118 => [\'Event','EventYear'] },
	'evfgrid' => { 312 => 0x165 },
	'evfimageframe' => { 312 => 0x164 },
	'evfreleaseindicator' => { 312 => 0x24f },
	'evfwarmdisplaybrightness' => { 312 => 0x24d },
	'evfwarmdisplaymode' => { 312 => 0x24b },
	'evsteps' => { 353 => '1.2', 355 => 0x0 },
	'evstepsize' => { 301 => '5.1', 302 => '6.1', 303 => '6.1', 307 => '0.7' },
	'exclusivecoverage' => { 486 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 518 => 'exclusivityEndDate' },
	'excursiontolerance' => { 133 => 0x82 },
	'executiveproducer' => { 389 => "\xa9xpd" },
	'exif' => { 120 => 'EXIF' },
	'exifbyteorder' => { 120 => 'ExifByteOrder' },
	'exifcamerainfo' => { 131 => 0xe8 },
	'exifimageheight' => { 119 => 0xa003, 502 => 'PixelYDimension' },
	'exifimagewidth' => { 119 => 0xa002, 502 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 120 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 119 => 0x9000, 502 => 'ExifVersion' },
	'exitpupilposition' => { 227 => 0x4, 228 => 0x4, 232 => 0x4 },
	'expirationdate' => { 131 => 0x25, 518 => 'expirationDate' },
	'expirationtime' => { 131 => 0x26 },
	'exposure' => { 119 => 0xfe51, 496 => 'Exposure', 498 => 'Exposure' },
	'exposure2012' => { 496 => 'Exposure2012', 498 => 'Exposure2012' },
	'exposureadj' => { 287 => 0x0 },
	'exposureadj2' => { 287 => 0x12 },
	'exposureadjust' => { 414 => 0xc },
	'exposurebracketingindicatorlast' => { 184 => 0x52 },
	'exposurebracketshotnumber' => { 187 => 0x2d, 435 => 0x2f },
	'exposurebracketstepsize' => { 353 => 0x8 },
	'exposurebracketvalue' => { 234 => 0x19 },
	'exposurecompautocancel' => { 84 => 0x113 },
	'exposurecompensation' => { 77 => 0x6, 93 => 0x0, 119 => 0x9204, 140 => 0x24, 156 => 'ExposureComp', 176 => 'ExposureCompensation', 181 => 0xd, 182 => 0x53, 183 => 0x1e, 187 => 0x49c0, 319 => 0x1006, 372 => 0x16, 381 => 0x402, 411 => 0xa013, 414 => [0xc,0x35,0x4d], 446 => 0x114c, 447 => 0x114c, 448 => 0x1128, 450 => 0x1180, 451 => 0x1038, 452 => 0x230, 453 => 0x230, 454 => 0x223, 502 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 442 => [0x24,0x26,0x2a] },
	'exposurecompensationbutton' => { 241 => 0x794 },
	'exposurecompensationmode' => { 184 => 0x47, 187 => 0x2a },
	'exposurecompensationset' => { 424 => 0x3, 425 => 0x3, 426 => 0x3, 442 => 0x1e },
	'exposurecompensationsetting' => { 184 => 0x1 },
	'exposurecompstepsize' => { 296 => '6.3', 297 => '7.3', 299 => '7.3', 300 => '7.3', 305 => '4.3', 309 => '7.3', 310 => '7.3' },
	'exposurecontrolstep' => { 304 => '6.1', 306 => '6.1' },
	'exposurecontrolstepsize' => { 296 => '6.2', 297 => '7.1', 299 => '7.1', 300 => '7.1', 305 => '4.2', 309 => '7.1', 310 => '7.1', 311 => '7.1', 312 => 0x1b },
	'exposurecount' => { 127 => 0x1032 },
	'exposuredelay' => { 241 => 0x800 },
	'exposuredelaymode' => { 296 => '10.1', 297 => '11.1', 299 => '11.1', 300 => '11.1', 301 => '9.1', 302 => '10.1', 303 => '10.1', 305 => '10.4', 306 => '10.1', 307 => '6.4', 309 => '11.1', 310 => '11.1', 311 => '11.2' },
	'exposuredifference' => { 234 => 0xe },
	'exposuregaincustom' => { 138 => 0x89c },
	'exposuregaindaylight' => { 138 => 0x898 },
	'exposuregainflash' => { 138 => 0x89b },
	'exposuregainfluorescent' => { 138 => 0x89a },
	'exposuregaintungsten' => { 138 => 0x899 },
	'exposureindex' => { 119 => 0xa215, 502 => 'ExposureIndex' },
	'exposureindicator' => { 184 => 0x50 },
	'exposurelevelincrements' => { 82 => 0x6, 83 => 0x6, 84 => 0x101, 85 => 0x5, 86 => 0x6, 87 => 0x5, 88 => 0x5, 89 => 0x6, 90 => 0x4, 424 => 0x58, 425 => 0x58 },
	'exposurelockused' => { 484 => 'ExposureLockUsed' },
	'exposuremode' => { 119 => 0xa402, 156 => 'ExposureMode', 181 => 0x1, 182 => 0xa, 183 => 0x0, 184 => 0x0, 187 => 0x34, 314 => 0x200, 334 => 0x40d, 414 => 0x8, 437 => 0xb041, 502 => 'ExposureMode' },
	'exposuremodeinmanual' => { 84 => 0x10b },
	'exposureprogram' => { 119 => 0x8822, 404 => 0x1001, 417 => [0x17e,0x43], 424 => 0x3c, 425 => 0x3c, 426 => 0x5, 430 => 0x14, 435 => 0x3f, 442 => 0x2, 446 => 0x1175, 447 => 0x1179, 448 => 0x1155, 449 => 0x11d1, 450 => 0x11ad, 451 => 0x1065, 452 => 0x25d, 453 => 0x25d, 454 => 0x24c, 464 => 0xb, 465 => 0xc, 466 => 0xb, 468 => 0x48, 502 => 'ExposureProgram' },
	'exposureshift' => { 314 => 0x203 },
	'exposurestandardadjustment' => { 437 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 30 => 0x6, 31 => 0x7, 77 => 0x16, 119 => 0x829a, 137 => 0xfd05, 140 => 0x20, 142 => 0xfa24, 144 => 0xf104, 147 => 0x12, 149 => 0x38, 151 => 0x14, 152 => 0x10, 154 => 0x10, 156 => 'ExposureTime', 181 => 0x9, 182 => 0x35, 183 => 0x48, 184 => 0x8, 187 => 0x49b8, 372 => 0x12, 411 => 0xa018, 414 => [0x32,0x4a], 424 => 0x0, 425 => 0x0, 442 => [0x21,0x23,0x27], 468 => 0x10, 502 => 'ExposureTime' },
	'exposuretime2' => { 414 => [0x33,0x4b] },
	'exposuretuning' => { 234 => 0x1c },
	'exposurevalue' => { 138 => 0x3 },
	'exposurewarning' => { 127 => 0x1302 },
	'exrauto' => { 127 => 0x1033 },
	'exrmode' => { 127 => 0x1034 },
	'extdescraccessibility' => { 509 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 239 => 0x114, 240 => 0x124, 241 => 0x124 },
	'extendedshutterspeeds' => { 312 => 0x102 },
	'extendedwbdetect' => { 314 => 0x902 },
	'extender' => { 315 => 0x301 },
	'extenderfirmwareversion' => { 315 => 0x304 },
	'extendermagnification' => { 158 => 'Magnification' },
	'extendermake' => { 158 => 'Make' },
	'extendermodel' => { 158 => 'Model', 315 => 0x303 },
	'extenderserialnumber' => { 158 => 'SerialNumber', 315 => 0x302 },
	'extenderstatus' => { 370 => 0x3 },
	'externalflash' => { 317 => 0x1201 },
	'externalflashae1' => { 319 => 0x101f },
	'externalflashae1_0' => { 319 => 0x101b },
	'externalflashae2' => { 319 => 0x1020 },
	'externalflashae2_0' => { 319 => 0x101c },
	'externalflashbounce' => { 317 => 0x1204, 319 => 0x1026, 360 => 0x1a },
	'externalflashcompensation' => { 214 => 0x1b },
	'externalflashexposurecomp' => { 234 => 0x17, 360 => 0x19 },
	'externalflashfirmware' => { 212 => 0x6, 213 => 0x6, 214 => 0x6, 215 => 0x6, 216 => 0x6, 217 => 0x6 },
	'externalflashflags' => { 212 => 0x8, 213 => 0x8, 214 => 0x8, 215 => 0x8, 217 => 0x8 },
	'externalflashguidenumber' => { 317 => 0x1203, 360 => '24.1' },
	'externalflashgvalue' => { 319 => 0x1025 },
	'externalflashmode' => { 319 => 0x1028, 360 => 0x2 },
	'externalflashreadystate' => { 216 => '9.1' },
	'externalflashstatus' => { 216 => '8.2' },
	'externalflashzoom' => { 317 => 0x1205, 319 => 0x1027 },
	'externalflashzoomoverride' => { 216 => '8.1' },
	'externalmetadatalink' => { 510 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 332 => 0x311, 335 => 0x311, 336 => 0x311, 339 => 0x3408 },
	'extrainfoversion' => { 428 => 0x1a },
	'eyestartaf' => { 184 => 0x40 },
	'fac100per' => { 138 => 0xe94 },
	'fac170per' => { 138 => 0xe93 },
	'fac18per' => { 138 => 0xe92 },
	'face10position' => { 110 => 0x3f4, 111 => 0x1ec, 210 => 0x28, 357 => 0x12 },
	'face10size' => { 358 => 0x12 },
	'face11position' => { 210 => 0x2c, 357 => 0x14 },
	'face11size' => { 358 => 0x14 },
	'face12position' => { 210 => 0x30, 357 => 0x16 },
	'face12size' => { 358 => 0x16 },
	'face13position' => { 357 => 0x18 },
	'face13size' => { 358 => 0x18 },
	'face14position' => { 357 => 0x1a },
	'face14size' => { 358 => 0x1a },
	'face15position' => { 357 => 0x1c },
	'face15size' => { 358 => 0x1c },
	'face16position' => { 357 => 0x1e },
	'face16size' => { 358 => 0x1e },
	'face17position' => { 357 => 0x20 },
	'face17size' => { 358 => 0x20 },
	'face18position' => { 357 => 0x22 },
	'face18size' => { 358 => 0x22 },
	'face19position' => { 357 => 0x24 },
	'face19size' => { 358 => 0x24 },
	'face1position' => { 54 => 0x8, 110 => 0xd, 111 => 0x18, 210 => 0x4, 329 => 0x1, 357 => 0x0, 401 => 0xbc, 431 => 0x1, 432 => 0x0, 433 => 0x0, 434 => 0x5b },
	'face1size' => { 358 => 0x0 },
	'face20position' => { 357 => 0x26 },
	'face20size' => { 358 => 0x26 },
	'face21position' => { 357 => 0x28 },
	'face21size' => { 358 => 0x28 },
	'face22position' => { 357 => 0x2a },
	'face22size' => { 358 => 0x2a },
	'face23position' => { 357 => 0x2c },
	'face23size' => { 358 => 0x2c },
	'face24position' => { 357 => 0x2e },
	'face24size' => { 358 => 0x2e },
	'face25position' => { 357 => 0x30 },
	'face25size' => { 358 => 0x30 },
	'face26position' => { 357 => 0x32 },
	'face26size' => { 358 => 0x32 },
	'face27position' => { 357 => 0x34 },
	'face27size' => { 358 => 0x34 },
	'face28position' => { 357 => 0x36 },
	'face28size' => { 358 => 0x36 },
	'face29position' => { 357 => 0x38 },
	'face29size' => { 358 => 0x38 },
	'face2position' => { 54 => 0xa, 110 => 0x7c, 111 => 0x4c, 210 => 0x8, 329 => 0x5, 357 => 0x2, 401 => 0xc8, 431 => 0x6, 432 => 0x20, 433 => 0x25, 434 => 0x65 },
	'face2size' => { 358 => 0x2 },
	'face30position' => { 357 => 0x3a },
	'face30size' => { 358 => 0x3a },
	'face31position' => { 357 => 0x3c },
	'face31size' => { 358 => 0x3c },
	'face32position' => { 357 => 0x3e },
	'face32size' => { 358 => 0x3e },
	'face3position' => { 54 => 0xc, 110 => 0xeb, 111 => 0x80, 210 => 0xc, 329 => 0x9, 357 => 0x4, 401 => 0xd4, 431 => 0xb, 432 => 0x40, 433 => 0x4a, 434 => 0x6f },
	'face3size' => { 358 => 0x4 },
	'face4position' => { 54 => 0xe, 110 => 0x15a, 111 => 0xb4, 210 => 0x10, 329 => 0xd, 357 => 0x6, 401 => 0xe0, 431 => 0x10, 432 => 0x60, 433 => 0x6f, 434 => 0x79 },
	'face4size' => { 358 => 0x6 },
	'face5position' => { 54 => 0x10, 110 => 0x1c9, 111 => 0xe8, 210 => 0x14, 329 => 0x11, 357 => 0x8, 401 => 0xec, 431 => 0x15, 432 => 0x80, 433 => 0x94 },
	'face5size' => { 358 => 0x8 },
	'face6position' => { 54 => 0x12, 110 => 0x238, 111 => 0x11c, 210 => 0x18, 357 => 0xa, 401 => 0xf8, 431 => 0x1a, 432 => 0xa0, 433 => 0xb9 },
	'face6size' => { 358 => 0xa },
	'face7position' => { 54 => 0x14, 110 => 0x2a7, 111 => 0x150, 210 => 0x1c, 357 => 0xc, 401 => 0x104, 431 => 0x1f, 432 => 0xc0, 433 => 0xde },
	'face7size' => { 358 => 0xc },
	'face8position' => { 54 => 0x16, 110 => 0x316, 111 => 0x184, 210 => 0x20, 357 => 0xe, 401 => 0x110, 431 => 0x24, 432 => 0xe0, 433 => 0x103 },
	'face8size' => { 358 => 0xe },
	'face9position' => { 54 => 0x18, 110 => 0x385, 111 => 0x1b8, 210 => 0x24, 357 => 0x10 },
	'face9size' => { 358 => 0x10 },
	'facebalanceorigi' => { 490 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 490 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 490 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 490 => 'FaceBalanceWarmth' },
	'facedetect' => { 372 => 0x76, 411 => 0x100 },
	'facedetectarea' => { 318 => 0x1201 },
	'facedetectframecrop' => { 318 => 0x1207 },
	'facedetectframesize' => { 54 => 0x3, 110 => 0x1, 111 => 0x4, 210 => 0x1, 318 => 0x1203, 372 => 0x77, 401 => 0xb6 },
	'facedetection' => { 426 => 0x30, 442 => 0x19 },
	'faceelementpositions' => { 127 => 0x4203 },
	'faceelementselected' => { 127 => 0x4005 },
	'faceelementtypes' => { 127 => 0x4201 },
	'faceid' => { 492 => 'FaceID' },
	'faceinfounknown' => { 113 => 0x2089 },
	'facename' => { 411 => 0x123 },
	'faceorientation' => { 111 => 0x8 },
	'faceposition' => { 356 => 0x2, 412 => 0x4 },
	'facepositions' => { 127 => 0x4103 },
	'facerecognition' => { 411 => 0x120 },
	'facesdetected' => { 54 => 0x2, 55 => 0x2, 56 => 0x3, 110 => 0x0, 111 => 0x2, 113 => 0x211c, 127 => 0x4100, 210 => 0x3, 318 => 0x1200, 337 => 0x3f, 356 => 0x0, 401 => 0xb5, 412 => 0x0, 431 => 0x0, 434 => 0x3, 445 => 0x30 },
	'facesrecognized' => { 330 => 0x0 },
	'facewidth' => { 55 => 0x1 },
	'fade' => { 437 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 109 => 0x38 },
	'faithfuloutputshadowpoint' => { 109 => 0x39 },
	'faithfulrawcolortone' => { 109 => 0x31 },
	'faithfulrawcontrast' => { 109 => 0x33 },
	'faithfulrawhighlight' => { 109 => 0x79 },
	'faithfulrawhighlightpoint' => { 109 => 0x36 },
	'faithfulrawlinear' => { 109 => 0x34 },
	'faithfulrawsaturation' => { 109 => 0x32 },
	'faithfulrawshadow' => { 109 => 0x82 },
	'faithfulrawshadowpoint' => { 109 => 0x37 },
	'faithfulrawsharpness' => { 109 => 0x35 },
	'faithfulunsharpmaskfineness' => { 109 => 0xac },
	'faithfulunsharpmaskstrength' => { 109 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 109 => 0xae },
	'far' => { 481 => 'Far' },
	'fastresetlinetime' => { 138 => 0x1860 },
	'feedidentifier' => { 510 => 'FeedIdentifier' },
	'femicroadjustment' => { 84 => 0x111 },
	'ffid' => { 500 => 'ffid' },
	'field' => { 514 => 'field' },
	'fieldcount' => { 319 => 0x103f },
	'fieldofview' => { 397 => "FOV\x00" },
	'fifoenonepixeldelay' => { 138 => 0x1901 },
	'filecreatedate' => { 120 => 'FileCreateDate' },
	'filedatarate' => { 525 => 'fileDataRate' },
	'fileformat' => { 95 => 0x0, 132 => 0x14, 414 => [0x22,0x26], 437 => 0xb000 },
	'filegroupid' => { 120 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 338 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 120 => 'FileModifyDate' },
	'filename' => { 120 => 'FileName' },
	'filenameasdelivered' => { 324 => 'FileNameAsDelivered' },
	'filenumber' => { 57 => 0x1, 64 => 0x8, 97 => 0x1817, 114 => 'Canon-FileNumber', 211 => 0x4, 400 => 0x10 },
	'filenumbermemory' => { 181 => 0x1a },
	'filenumbersequence' => { 296 => '12.2', 301 => '3.1', 302 => '4.1', 303 => '4.1', 305 => '11.1', 306 => '4.3', 311 => '5.2', 312 => 0x48 },
	'filepermissions' => { 120 => 'FilePermissions' },
	'filesource' => { 119 => 0xa300, 127 => 0x8000, 502 => 'FileSource' },
	'fileuserid' => { 120 => 'FileUserID' },
	'fileversion' => { 132 => 0x16 },
	'fillflashautoreduction' => { 82 => 0xe, 83 => 0xe, 90 => 0xa },
	'filllight' => { 496 => 'FillLight', 498 => 'FillLight' },
	'fillorder' => { 119 => 0x10a },
	'filmgraineffect' => { 314 => 0x538 },
	'filmmode' => { 127 => 0x1401, 334 => 0x412, 337 => 0x42 },
	'filmtype' => { 256 => 0x2 },
	'filtereffect' => { 57 => 0xe, 248 => 0x37, 249 => 0x3f, 250 => 0x47, 337 => 0xa1 },
	'filtereffectauto' => { 71 => 0xa0 },
	'filtereffectfaithful' => { 70 => 0x70, 71 => 0x70 },
	'filtereffectlandscape' => { 70 => 0x40, 71 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 70 => 0x88, 71 => 0x88 },
	'filtereffectneutral' => { 70 => 0x58, 71 => 0x58 },
	'filtereffectportrait' => { 70 => 0x28, 71 => 0x28 },
	'filtereffectstandard' => { 70 => 0x10, 71 => 0x10 },
	'filtereffectuserdef1' => { 70 => 0xa0, 71 => 0xb8 },
	'filtereffectuserdef2' => { 70 => 0xb8, 71 => 0xd0 },
	'filtereffectuserdef3' => { 70 => 0xd0, 71 => 0xe8 },
	'finderdisplayduringexposure' => { 83 => 0x1 },
	'finesharpness' => { 372 => 0x70 },
	'finetuneoptcenterweighted' => { 296 => '7.2', 297 => '9.1', 299 => '9.1', 300 => '9.1', 304 => '8.1', 309 => '9.1', 310 => '9.1', 311 => '9.1', 312 => 0x23 },
	'finetuneopthighlightweighted' => { 299 => '46.1', 300 => '46.1', 309 => '46.1', 310 => '46.1', 312 => 0x27 },
	'finetuneoptmatrixmetering' => { 296 => '8.1', 297 => '8.2', 299 => '8.2', 300 => '8.2', 304 => '7.2', 305 => '6.1', 309 => '8.2', 310 => '8.2', 311 => '8.2', 312 => 0x21 },
	'finetuneoptspotmetering' => { 296 => '8.2', 297 => '9.2', 299 => '9.2', 300 => '9.2', 304 => '8.2', 305 => '6.2', 309 => '9.2', 310 => '9.2', 311 => '9.2', 312 => 0x25 },
	'finishexposure' => { 138 => 0xdbd },
	'finishfiletype' => { 138 => 0xdb8 },
	'finishlook' => { 138 => 0xdbc },
	'finishnoise' => { 138 => 0xdba },
	'finishresolution' => { 138 => 0xdb9 },
	'finishsharpening' => { 138 => 0xdbb },
	'firmware' => { 319 => 0x405, 414 => [0x8c,0x17,0x3b], 493 => 'Firmware' },
	'firmware2' => { 414 => 0x57 },
	'firmwaredate' => { 112 => 0x15, 113 => 0x2001, 398 => 0x4, 400 => 0x30 },
	'firmwareid' => { 188 => 0x0 },
	'firmwarename' => { 411 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 64 => 0x1e, 402 => 0x0 },
	'firmwarerevision2' => { 402 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 138 => [0x415,0xce5], 154 => 0x57, 156 => 'FirmwareVersion', 335 => 0x320, 337 => 0x2, 339 => 0x3109, 372 => 0x230, 397 => ['CNFV','FIRM'], 399 => 0x18, 400 => 0x2a, 404 => 0x2 },
	'firmwareversions' => { 381 => 0x301 },
	'firstphotodate' => { 484 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 324 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 131 => 0x16, 491 => 'FixtureIdentifier' },
	'flash' => { 114 => 'XMP-Flash', 119 => 0x9209, 152 => 0x22, 182 => 0x1f, 183 => 0x15, 400 => 0x5a, 502 => 'Flash' },
	'flashaction' => { 424 => 0x3e, 425 => 0x3e, 437 => 0x2017, 442 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 424 => 0x4c, 425 => 0x4c, 442 => 0x77 },
	'flashactionexternal' => { 442 => [0x78,0x7c] },
	'flashactivity' => { 34 => 0x1c },
	'flashbatterylevel' => { 44 => 0x249 },
	'flashbias' => { 337 => 0x24 },
	'flashbits' => { 34 => 0x1d },
	'flashburstpriority' => { 312 => 0x111 },
	'flashbuttonfunction' => { 84 => 0x70e },
	'flashchargelevel' => { 319 => 0x1010 },
	'flashcolorfilter' => { 214 => 0x10, 215 => 0x10, 217 => 0x10 },
	'flashcommandermode' => { 212 => '9.1', 213 => '9.1', 214 => '9.1', 215 => '9.1', 217 => '9.1' },
	'flashcompensation' => { 138 => 0x3f3, 212 => 0xa, 213 => 0xa, 214 => 0xa, 215 => 0x27, 216 => 0xa, 217 => 0xa, 493 => 'FlashCompensation' },
	'flashcontrol' => { 424 => 0x23, 425 => 0x1f, 426 => 0x21 },
	'flashcontrolbuilt-in' => { 305 => '16.1', 306 => '23.1', 308 => '23.1', 309 => '24.1' },
	'flashcontrolmode' => { 212 => '9.2', 213 => '9.2', 214 => '9.2', 215 => '9.2', 217 => '9.2', 223 => 0x214, 238 => 0x148, 239 => 0x1a8, 240 => 0x1bc, 241 => 0x1bc, 314 => 0x404 },
	'flashcurtain' => { 337 => 0x48 },
	'flashdefault' => { 184 => 0x42 },
	'flashdevice' => { 319 => 0x1005 },
	'flashdistance' => { 113 => 0x2034 },
	'flashenergy' => { 119 => 0xa20b, 502 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 234 => 0x18 },
	'flashexposurecomp' => { 77 => 0xf, 127 => 0x1011, 159 => 'ExposureComp', 181 => 0x23, 186 => 0x104, 187 => 0x49c1, 234 => 0x12, 314 => 0x401, 319 => 0x1023, 372 => 0x4d, 404 => 0x100b, 414 => [0x3a,0x56], 437 => 0x104 },
	'flashexposurecomp2' => { 277 => 0x4d2 },
	'flashexposurecomp3' => { 214 => 0x1d },
	'flashexposurecomp4' => { 214 => 0x27 },
	'flashexposurecomparea' => { 297 => '38.4', 299 => '38.4', 300 => '38.4', 309 => '38.4', 310 => '38.4', 312 => 0x59 },
	'flashexposurecompset' => { 184 => 0x10, 345 => 0xe, 424 => 0x14, 425 => 0x12, 426 => 0x23, 442 => 0x1f },
	'flashexposurecompset2' => { 442 => [0x26,0x2c] },
	'flashexposureindicator' => { 184 => 0x54 },
	'flashexposureindicatorlast' => { 184 => 0x56 },
	'flashexposureindicatornext' => { 184 => 0x55 },
	'flashexposurelock' => { 57 => 0x19 },
	'flashfired' => { 140 => 0x5d, 159 => 'Fired', 181 => 0x14, 276 => '590.3', 502 => [\'Flash','FlashFired'] },
	'flashfiring' => { 84 => 0x306, 85 => 0x6, 86 => 0x7, 89 => 0x7 },
	'flashfirmwareversion' => { 315 => 0x1002 },
	'flashfocallength' => { 212 => 0xb, 213 => 0xc, 214 => 0xc, 215 => 0xc, 216 => 0xc, 217 => 0x26 },
	'flashfunction' => { 187 => 0x31, 502 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 212 => 0xe, 213 => 0xf, 214 => 0xf, 215 => 0xf, 216 => 0xf, 217 => 0xf, 223 => 0x21a, 238 => 0x14e, 239 => 0x1ae, 240 => 0x1c2, 241 => 0x1c2 },
	'flashgroupacompensation' => { 212 => 0x11, 213 => 0x12, 214 => 0x13, 215 => 0x28, 216 => 0x28, 217 => 0x28 },
	'flashgroupacontrolmode' => { 212 => 0xf, 213 => '16.1', 214 => '17.1', 215 => '17.1', 216 => '17.1', 217 => '17.1' },
	'flashgroupaoutput' => { 212 => 0x11, 213 => 0x12, 214 => 0x13, 215 => 0x28, 216 => 0x28, 217 => 0x28 },
	'flashgroupbcompensation' => { 212 => 0x12, 213 => 0x13, 214 => 0x14, 215 => 0x29, 216 => 0x29, 217 => 0x29 },
	'flashgroupbcontrolmode' => { 212 => 0x10, 213 => '17.1', 214 => '18.1', 215 => '18.1', 216 => '18.1', 217 => '18.1' },
	'flashgroupboutput' => { 212 => 0x12, 213 => 0x13, 214 => 0x14, 215 => 0x29, 216 => 0x29, 217 => 0x29 },
	'flashgroupccompensation' => { 213 => 0x14, 214 => 0x15, 215 => 0x2a, 216 => 0x2a, 217 => 0x2a },
	'flashgroupccontrolmode' => { 213 => '17.2', 214 => '18.2', 215 => '18.2', 216 => '18.2', 217 => '18.2' },
	'flashgroupcoutput' => { 213 => 0x14, 214 => 0x15, 215 => 0x2a, 216 => 0x2a, 217 => 0x2a },
	'flashguidenumber' => { 77 => 0xd, 94 => 0x0, 159 => 'GuideNumber' },
	'flashilluminationpattern' => { 217 => 0x25 },
	'flashintensity' => { 112 => [0x19,0x5], 314 => 0x405 },
	'flashlevel' => { 298 => 0x9, 437 => 0xb048 },
	'flashmake' => { 159 => 'Make' },
	'flashmanufacturer' => { 178 => 'FlashManufacturer' },
	'flashmastercompensation' => { 223 => 0x22e, 238 => 0x162, 239 => 0x1aa, 240 => 0x1be, 241 => 0x1be },
	'flashmastercontrolmode' => { 223 => 0x22c, 238 => 0x160 },
	'flashmasteroutput' => { 223 => 0x232, 238 => 0x166 },
	'flashmetering' => { 181 => 0x3f, 184 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 372 => 0x20a },
	'flashmode' => { 112 => 0x4, 138 => 0x3f2, 140 => 0x5c, 151 => 0x27, 159 => 'Mode', 181 => 0x2, 182 => 0x20, 183 => 0x16, 184 => 0xf, 234 => 0x87, 314 => 0x400, 319 => 0x1004, 372 => 0xc, 379 => 0x4, 403 => 0x20, 404 => 0x100a, 413 => 0x225, 424 => 0x13, 425 => 0x7f, 426 => 0x20, 442 => 0x10, 446 => 0x1138, 447 => 0x1138, 448 => 0x1114, 449 => 0x1190, 450 => 0x116c, 451 => 0x1024, 452 => 0x21c, 453 => 0x21c, 454 => 0x211, 502 => [\'Flash','FlashMode'] },
	'flashmodebutton' => { 241 => 0x80e },
	'flashmodebuttonplaybackmode' => { 241 => 0x818 },
	'flashmodel' => { 159 => 'Model', 178 => 'FlashModel', 315 => 0x1001 },
	'flashoptions' => { 353 => 0x2 },
	'flashoptions2' => { 353 => 0x10 },
	'flashoutput' => { 44 => 0x248, 77 => 0x21, 212 => 0xa, 213 => 0xa, 214 => 0xa, 215 => 0x27, 217 => 0x21, 223 => 0x21e, 238 => 0x152, 239 => 0x1b2, 240 => 0x1c6, 241 => 0x1c6 },
	'flashpixversion' => { 119 => 0xa000, 502 => 'FlashpixVersion' },
	'flashredeyemode' => { 502 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 223 => 0x228, 238 => 0x15c, 239 => 0x1bc, 314 => 0x403 },
	'flashreturn' => { 502 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 159 => 'SerialNumber', 315 => 0x1003 },
	'flashsetting' => { 234 => 0x8 },
	'flashshutterspeed' => { 296 => '20.2', 297 => '23.2', 299 => '23.2', 300 => '23.2', 305 => '15.2', 306 => '22.2', 307 => '7.2', 308 => '22.2', 309 => '23.2', 310 => '23.2', 311 => '23.1', 312 => 0x57 },
	'flashsource' => { 212 => 0x4, 213 => 0x4, 214 => 0x4, 215 => 0x4, 216 => 0x4, 217 => 0x4 },
	'flashstatus' => { 360 => 0x0, 442 => [0x82,0x86], 456 => 0x31, 457 => 0x39, 458 => 0x39 },
	'flashstatusbuilt-in' => { 426 => [0x87,0x287] },
	'flashstatusexternal' => { 426 => [0x88,0x288] },
	'flashsyncspeed' => { 296 => '20.1', 297 => '23.1', 299 => '23.1', 300 => '23.1', 305 => '15.1', 306 => '22.1', 308 => '22.1', 309 => '23.1', 310 => '23.1', 312 => 0x53 },
	'flashsyncspeedav' => { 82 => 0x3, 84 => 0x10f, 85 => 0x2, 86 => 0x3, 87 => 0x2, 88 => 0x2, 89 => 0x3, 90 => 0x6 },
	'flashthreshold' => { 94 => 0x1 },
	'flashtype' => { 159 => 'Type', 184 => 0x59, 234 => 0x9, 315 => 0x1000 },
	'flashwarning' => { 306 => '30.1', 307 => '7.1', 311 => '31.1', 337 => 0x62 },
	'flashwirelessoption' => { 223 => 0x234, 238 => 0x15a, 239 => 0x1c8 },
	'flexiblespotposition' => { 437 => 0x201d },
	'flickadvancedirection' => { 312 => 0x25f },
	'flickerreduce' => { 413 => 0x218 },
	'flickerreduction' => { 127 => 0x1446, 260 => 0x7 },
	'flickerreductionindicator' => { 255 => 0x532 },
	'flickerreductionshooting' => { 239 => 0x1a4, 240 => 0x1b8, 241 => 0x1b8 },
	'flightpitchdegree' => { 116 => 'FlightPitchDegree' },
	'flightrolldegree' => { 116 => 'FlightRollDegree' },
	'flightxspeed' => { 116 => 'FlightXSpeed' },
	'flightyawdegree' => { 116 => 'FlightYawDegree' },
	'flightyspeed' => { 116 => 'FlightYSpeed' },
	'flightzspeed' => { 116 => 'FlightZSpeed' },
	'fliphorizontal' => { 289 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 30 => 0x5, 31 => 0x6, 77 => 0x15, 119 => 0x829d, 137 => 0xfd04, 140 => 0x1e, 142 => 0xfa23, 144 => 0xf103, 147 => 0x13, 149 => 0x3c, 151 => 0x1c, 152 => 0x18, 154 => 0xc, 163 => 'FNumber', 181 => 0xa, 182 => 0x36, 183 => 0x47, 184 => 0x9, 187 => 0x49c7, 232 => 0x38, 336 => 0x35a, 372 => 0x13, 411 => 0xa019, 414 => [0x31,0x49], 424 => 0x1, 425 => 0x1, 442 => [0x20,0x22,0x26], 502 => 'FNumber' },
	'focaldistance' => { 482 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 59 => 0x1, 113 => 0x1d, 119 => 0x920a, 147 => 0x1d, 163 => 'FocalLength', 181 => 0x12, 227 => 0xa, 228 => 0xb, 232 => [0xc,0x3c], 331 => 0x1, 372 => 0x1d, 381 => 0x403, 404 => 0x1500, 423 => 0xe, 450 => 0x1278, 451 => 0x1134, 452 => 0x32c, 453 => 0x32c, 454 => 0x30a, 502 => 'FocalLength' },
	'focallength2' => { 442 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 119 => 0xa405, 411 => 0xa01a, 502 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 423 => 0x10 },
	'focalplaneafpointarea' => { 455 => 0x2 },
	'focalplaneafpointlocation1' => { 455 => 0x6 },
	'focalplaneafpointlocation10' => { 455 => 0x2a },
	'focalplaneafpointlocation11' => { 455 => 0x2e },
	'focalplaneafpointlocation12' => { 455 => 0x32 },
	'focalplaneafpointlocation13' => { 455 => 0x36 },
	'focalplaneafpointlocation14' => { 455 => 0x3a },
	'focalplaneafpointlocation15' => { 455 => 0x3e },
	'focalplaneafpointlocation2' => { 455 => 0xa },
	'focalplaneafpointlocation3' => { 455 => 0xe },
	'focalplaneafpointlocation4' => { 455 => 0x12 },
	'focalplaneafpointlocation5' => { 455 => 0x16 },
	'focalplaneafpointlocation6' => { 455 => 0x1a },
	'focalplaneafpointlocation7' => { 455 => 0x1e },
	'focalplaneafpointlocation8' => { 455 => 0x22 },
	'focalplaneafpointlocation9' => { 455 => 0x26 },
	'focalplaneafpointsused' => { 455 => 0x1 },
	'focalplanediagonal' => { 315 => 0x103, 319 => 0x205 },
	'focalplaneresolutionunit' => { 119 => 0xa210, 502 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 119 => 0xa20e, 502 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 59 => 0x2 },
	'focalplanexunknown' => { 59 => 0x2 },
	'focalplaneyresolution' => { 119 => 0xa20f, 502 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 59 => 0x3 },
	'focalplaneyunknown' => { 59 => 0x3 },
	'focalpointx' => { 482 => 'FocalPointX' },
	'focalpointy' => { 482 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 59 => 0x0 },
	'focalunits' => { 34 => 0x19 },
	'focus' => { 279 => 0x8 },
	'focusarea' => { 181 => 0x31 },
	'focusareaselection' => { 307 => '15.2' },
	'focusbracket' => { 337 => 0xbd },
	'focusbracketstepsize' => { 314 => 0x308 },
	'focuscontinuous' => { 34 => 0x20 },
	'focusdisplayaiservoandmf' => { 84 => 0x515 },
	'focusdistance' => { 163 => 'FocusDistance', 181 => 0x13, 187 => 0x49bb, 227 => 0x9, 228 => 0xa, 232 => [0xb,0x4e], 317 => 0x305, 331 => 0x0, 335 => 0x304, 336 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 57 => 0x15, 77 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 232 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 57 => 0x14, 77 => 0x13 },
	'focusholdbutton' => { 184 => 0x44 },
	'focusinfoversion' => { 317 => 0x0 },
	'focusingscreen' => { 83 => 0x0, 84 => 0x80b, 89 => 0x0 },
	'focuslocation' => { 437 => 0x2027 },
	'focuslocked' => { 180 => 0x14 },
	'focusmode' => { 34 => 0x7, 112 => 0x3, 113 => [0x3003,0xd], 127 => 0x1021, 138 => 0x3f5, 140 => 0x38, 156 => 'FocusMode', 181 => 0x30, 183 => 0xe, 184 => 0xc, 234 => 0x7, 314 => 0x301, 319 => 0x100b, 337 => 0x7, 372 => 0xd, 379 => 0x3, 404 => 0x1006, 417 => [0xb,0x5], 423 => [0x15,0x1d], 424 => 0x4d, 425 => 0x4d, 437 => [0xb042,0xb04e,0x201b], 442 => 0x13, 462 => 0x16 },
	'focusmode2' => { 126 => '0.1', 353 => '3.1', 442 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 298 => '10.1', 421 => 0x14, 422 => 0x15, 424 => 0x10, 425 => 0xf, 426 => 0x6 },
	'focusmodeswitch' => { 184 => 0x58, 424 => 0x2e },
	'focuspeakingdisplay' => { 312 => 0x235 },
	'focuspeakinghighlightcolor' => { 312 => 0x4b },
	'focuspeakinglevel' => { 312 => 0x49 },
	'focuspixel' => { 127 => 0x1023 },
	'focuspointlock' => { 312 => 0x1d3 },
	'focuspointpersistence' => { 312 => 0x105 },
	'focuspointwrap' => { 296 => '2.2', 297 => '2.2', 299 => '2.1', 300 => '2.1', 304 => '1.1', 305 => '2.2', 306 => '1.1', 309 => '2.2', 310 => '2.1', 311 => '2.5', 312 => 0x16 },
	'focusposition' => { 1 => 0x2f, 227 => 0x8, 228 => 0x8, 372 => 0x10, 435 => 0x9bb },
	'focusposition2' => { 442 => [0x29,0x2b,0x2f], 462 => 0x2d, 465 => 0x20 },
	'focuspositionhorizontal' => { 193 => 0x2f, 194 => 0x43 },
	'focuspositionvertical' => { 193 => 0x31, 194 => 0x45 },
	'focusprocess' => { 314 => 0x302 },
	'focusrange' => { 34 => 0x12, 319 => 0x100a },
	'focusrangeindex' => { 363 => '3.1' },
	'focusresult' => { 194 => 0x4a },
	'focusringrotation' => { 84 => 0x713 },
	'focussetting' => { 414 => 0x6 },
	'focusshiftautoreset' => { 240 => 0x6da, 241 => 0x748 },
	'focusshiftexposurelock' => { 223 => 0x1b4, 238 => 0xe8, 239 => 0xf4, 240 => 0x104, 241 => 0x104 },
	'focusshiftinterval' => { 223 => 0x1b0, 238 => 0xe4, 239 => 0xf0, 240 => 0x100, 241 => 0x100 },
	'focusshiftnumbershots' => { 223 => 0x1a8, 238 => 0xdc, 239 => 0xe8, 240 => 0xf8, 241 => 0xf8 },
	'focusshiftshooting' => { 258 => 0x20 },
	'focusshiftstepwidth' => { 223 => 0x1ac, 238 => 0xe0, 239 => 0xec, 240 => 0xfc, 241 => 0xfc },
	'focusstatus' => { 423 => 0x19, 424 => 0x53, 425 => 0x53 },
	'focusstepcount' => { 317 => 0x301, 319 => 0x100e },
	'focusstepinfinity' => { 317 => 0x303, 319 => 0x103b },
	'focusstepnear' => { 317 => 0x304, 319 => 0x103c },
	'focustrackinglockon' => { 296 => ['1.5','4.1'], 297 => '1.4', 304 => '0.4', 305 => '3.1', 306 => '0.4', 309 => '1.4' },
	'focuswarning' => { 127 => 0x1301 },
	'foldername' => { 181 => 0x27 },
	'foldernumber' => { 424 => 0x9a, 426 => [0x402,0x114,0x316] },
	'fontcomposite' => { 530 => [\'Fonts','FontsComposite'] },
	'fontface' => { 530 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 530 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 530 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 530 => [\'Fonts','FontsFontName'] },
	'fonts' => { 530 => 'Fonts' },
	'fonttype' => { 530 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 530 => [\'Fonts','FontsVersionString'] },
	'for' => { 388 => 'For' },
	'forcewrite' => { 120 => 'ForceWrite' },
	'format' => { 397 => "\xa9fmt", 481 => 'Format', 499 => 'format', 523 => 'Format' },
	'forwardlock' => { 520 => 'forwardlock' },
	'forwardmatrix1' => { 119 => 0xc714 },
	'forwardmatrix2' => { 119 => 0xc715 },
	'forwardmatrix3' => { 119 => 0xcd34 },
	'fossilspecimen' => { 118 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 118 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 67 => [0x2,0x4] },
	'frameheight' => { 127 => 0x3822 },
	'framenum' => { 383 => 0xd7 },
	'framenumber' => { 127 => 0x8003, 187 => 0x3c, 372 => 0x29 },
	'framerate' => { 67 => [0x1,0x6], 119 => 0xc764, 127 => 0x3820 },
	'framereadouttime' => { 391 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 127 => 0x3821 },
	'framing' => { 514 => 'framing' },
	'freebytes' => { 97 => 0x1 },
	'freememorycardimages' => { 182 => [0x37,0x54], 183 => [0x2d,0x4a], 184 => 0x32 },
	'frontfacingcamera' => { 1 => 0x45 },
	'fujiflashmode' => { 127 => 0x1010 },
	'fujimodel' => { 127 => 0x1447 },
	'fujimodel2' => { 127 => 0x1448 },
	'fullhdhighspeedrec' => { 127 => 0x3824 },
	'fullimagesize' => { 437 => 0xb02b },
	'fullpanoheightpixels' => { 484 => 'FullPanoHeightPixels', 485 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 484 => 'FullPanoWidthPixels', 485 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 404 => 0x100d },
	'fullsizeimage' => { 162 => 'data' },
	'fullsizeimagename' => { 162 => '1Name' },
	'fullsizeimagetype' => { 162 => '0Type' },
	'func1button' => { 299 => '14.1', 300 => '14.1', 310 => '14.1', 312 => 0x63 },
	'func1buttonplaybackmode' => { 312 => 0x1a5 },
	'func1buttonplusdials' => { 299 => '42.1', 300 => '42.1', 310 => '42.1' },
	'func2button' => { 299 => '80.1', 300 => '80.1', 310 => '80.1', 312 => 0x73 },
	'func2buttonplaybackmode' => { 312 => 0x1a7 },
	'func2buttonplusdials' => { 299 => '81.1' },
	'func3button' => { 299 => '83.1', 312 => 0x119 },
	'func3buttonplaybackmode' => { 312 => 0x1a9 },
	'func4button' => { 312 => 0x175 },
	'func4buttonplaybackmode' => { 312 => 0x1af },
	'funcbutton' => { 296 => ['14.1','15.1'], 297 => '14.1', 305 => '28.1', 306 => '13.1', 309 => '14.1', 311 => '14.1' },
	'funcbuttonplusdials' => { 296 => ['14.2','15.2'], 297 => '14.2', 305 => '31.1', 309 => '42.1' },
	'functionbutton' => { 303 => '13.1', 307 => '5.2' },
	'gainbase' => { 318 => 0x610 },
	'gaincontrol' => { 119 => 0xa407, 502 => 'GainControl' },
	'gainmapmax' => { 507 => 'GainMapMax' },
	'gainmapmin' => { 507 => 'GainMapMin' },
	'gamma' => { 119 => 0xa500, 138 => 0x8fe, 325 => 'gAMA', 342 => 0x11c, 503 => 'Gamma', 507 => 'Gamma' },
	'gammablackpoint' => { 105 => 0xc },
	'gammacolortone' => { 105 => 0x3 },
	'gammacompensatedvalue' => { 133 => 0x91 },
	'gammacontrast' => { 105 => 0x2 },
	'gammacurveoutputrange' => { 105 => 0xf },
	'gammahighlight' => { 105 => 0xa },
	'gammalinear' => { 103 => 0x20200 },
	'gammamidpoint' => { 105 => 0xe },
	'gammasaturation' => { 105 => 0x4 },
	'gammashadow' => { 105 => 0x9 },
	'gammasharpnessstrength' => { 105 => 0x8 },
	'gammaunsharpmaskfineness' => { 105 => 0x6 },
	'gammaunsharpmaskstrength' => { 105 => 0x5 },
	'gammaunsharpmaskthreshold' => { 105 => 0x7 },
	'gammawhitepoint' => { 105 => 0xd },
	'garminsettings' => { 397 => 'pmcc' },
	'garminsoftware' => { 397 => 'uuid' },
	'gdalmetadata' => { 119 => 0xa480 },
	'gdalnodata' => { 119 => 0xa481 },
	'geimagesize' => { 127 => 0x1304 },
	'gemake' => { 129 => 0x300 },
	'gemodel' => { 129 => 0x207 },
	'genre' => { 389 => ['gnre',"\xa9gen"], 391 => 'genre', 397 => ['gnre',"\xa9gen"], 510 => 'Genre', 515 => 'genre', 525 => 'genre' },
	'genrecvid' => { 510 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 510 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 510 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 510 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 389 => 'geID' },
	'geography' => { 516 => 'geography' },
	'geologicalcontext' => { 118 => 'GeologicalContext' },
	'geologicalcontextbed' => { 118 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 118 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 118 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 118 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 118 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 120 => 'Geosync' },
	'geotag' => { 120 => 'Geotag' },
	'geotiffasciiparams' => { 119 => 0x87b1 },
	'geotiffdirectory' => { 119 => 0x87af },
	'geotiffdoubleparams' => { 119 => 0x87b0 },
	'geotime' => { 120 => 'Geotime' },
	'giftftppriority' => { 486 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 116 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 116 => 'GimbalReverse' },
	'gimbalrolldegree' => { 116 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 116 => 'GimbalYawDegree' },
	'globalaltitude' => { 386 => 0x419 },
	'globalangle' => { 386 => 0x40d },
	'good' => { 525 => 'good' },
	'googlehostheader' => { 389 => 'gshh' },
	'googlepingmessage' => { 389 => 'gspm' },
	'googlepingurl' => { 389 => 'gspu' },
	'googleplusuploadcode' => { 119 => 0x9009 },
	'googlesourcedata' => { 389 => 'gssd' },
	'googlestarttime' => { 389 => 'gsst' },
	'googletrackduration' => { 389 => 'gstd' },
	'goprotype' => { 397 => 'GoPr' },
	'gpsaltitude' => { 130 => 0x6, 160 => 'Altitude', 502 => 'GPSAltitude' },
	'gpsaltituderef' => { 130 => 0x5, 502 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 130 => 0x1c, 502 => 'GPSAreaInformation' },
	'gpscoordinates' => { 389 => "\xa9xyz", 391 => 'location.ISO6709', 397 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 130 => 0x1d },
	'gpsdatetime' => { 160 => 'DateTime', 502 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 130 => 0x18, 160 => 'Bearing', 502 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 130 => 0x17, 502 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 130 => 0x1a, 160 => 'Distance', 502 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 130 => 0x19, 502 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 130 => 0x14, 502 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 130 => 0x13 },
	'gpsdestlongitude' => { 130 => 0x16, 502 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 130 => 0x15 },
	'gpsdifferential' => { 130 => 0x1e, 160 => 'Differential', 502 => 'GPSDifferential' },
	'gpsdop' => { 130 => 0xb, 502 => 'GPSDOP' },
	'gpshpositioningerror' => { 130 => 0x1f, 502 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 130 => 0x11, 502 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 130 => 0x10, 502 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 114 => 'GPS-GPSLatitude', 116 => 'GpsLatitude', 130 => 0x2, 160 => 'Latitude', 502 => 'GPSLatitude' },
	'gpslatituderef' => { 130 => 0x1 },
	'gpslongitude' => { 114 => 'GPS-GPSLongitude', 116 => 'GpsLongitude', 130 => 0x4, 160 => 'Longitude', 502 => 'GPSLongitude' },
	'gpslongituderef' => { 130 => 0x3 },
	'gpslongtitude' => { 116 => 'GpsLongtitude' },
	'gpsmapdatum' => { 130 => 0x12, 160 => 'Datum', 502 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 130 => 0xa, 160 => 'MeasureMode', 502 => 'GPSMeasureMode' },
	'gpsposition' => { 114 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 130 => 0x1b, 502 => 'GPSProcessingMethod' },
	'gpssatellites' => { 130 => 0x8, 160 => 'Satellites', 502 => 'GPSSatellites' },
	'gpsspeed' => { 130 => 0xd, 160 => 'Speed', 502 => 'GPSSpeed' },
	'gpsspeedref' => { 130 => 0xc, 502 => 'GPSSpeedRef' },
	'gpsstatus' => { 130 => 0x9, 502 => 'GPSStatus' },
	'gpsstring' => { 138 => 0x402 },
	'gpstimestamp' => { 130 => 0x7 },
	'gpstrack' => { 130 => 0xf, 160 => 'Heading', 502 => 'GPSTrack' },
	'gpstrackref' => { 130 => 0xe, 502 => 'GPSTrackRef' },
	'gpsversionid' => { 130 => 0x0, 502 => 'GPSVersionID' },
	'gradation' => { 314 => 0x50f },
	'gradientbasedcorractive' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 496 => 'GradientBasedCorrections', 498 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 498 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 496 => 'GrainAmount', 498 => 'GrainAmount' },
	'graineffectroughness' => { 127 => 0x1047 },
	'graineffectsize' => { 127 => 0x104c },
	'grainfrequency' => { 496 => 'GrainFrequency', 498 => 'GrainFrequency' },
	'grainseed' => { 496 => 'GrainSeed', 498 => 'GrainSeed' },
	'grainsize' => { 496 => 'GrainSize', 498 => 'GrainSize' },
	'graymixeraqua' => { 496 => 'GrayMixerAqua', 498 => 'GrayMixerAqua' },
	'graymixerblue' => { 496 => 'GrayMixerBlue', 498 => 'GrayMixerBlue' },
	'graymixergreen' => { 496 => 'GrayMixerGreen', 498 => 'GrayMixerGreen' },
	'graymixermagenta' => { 496 => 'GrayMixerMagenta', 498 => 'GrayMixerMagenta' },
	'graymixerorange' => { 496 => 'GrayMixerOrange', 498 => 'GrayMixerOrange' },
	'graymixerpurple' => { 496 => 'GrayMixerPurple', 498 => 'GrayMixerPurple' },
	'graymixerred' => { 496 => 'GrayMixerRed', 498 => 'GrayMixerRed' },
	'graymixeryellow' => { 496 => 'GrayMixerYellow', 498 => 'GrayMixerYellow' },
	'graypoint' => { 472 => 0x8021 },
	'grayresponseunit' => { 119 => 0x122 },
	'greencurvelimits' => { 108 => 0x1c4 },
	'greencurvepoints' => { 107 => 0x53, 108 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 103 => 0x20913 },
	'greenhue' => { 496 => 'GreenHue', 498 => 'GreenHue' },
	'greensaturation' => { 496 => 'GreenSaturation', 498 => 'GreenSaturation' },
	'griddisplay' => { 296 => '13.3', 297 => '4.3', 299 => '4.2', 300 => '4.2', 301 => '2.2', 305 => '10.5', 306 => '3.4', 307 => '6.1', 309 => '4.4', 310 => '4.2', 311 => '4.2' },
	'gripbatteryadload' => { 351 => 0x5 },
	'gripbatteryadnoload' => { 351 => 0x4 },
	'gripbatterystate' => { 351 => '1.2' },
	'group' => { 496 => 'Group', 498 => 'Group' },
	'groupareaafillumination' => { 297 => '46.4', 300 => '47.4', 309 => '47.4' },
	'grouping' => { 389 => ['grup',"\xa9grp"], 397 => "\xa9grp" },
	'guid' => { 389 => 'GUID' },
	'h2resetblackpixels' => { 138 => 0x18a6 },
	'h3resetblackcolumns' => { 138 => 0x18ce },
	'h3resetblackpixels' => { 138 => 0x18b0 },
	'halftonehints' => { 119 => 0x141 },
	'hardlink' => { 120 => 'HardLink' },
	'hasalternative' => { 515 => 'hasAlternative' },
	'hascorrection' => { 515 => 'hasCorrection' },
	'hascorrectiona-lang' => { 515 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 515 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 515 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 496 => 'HasCrop', 498 => 'HasCrop' },
	'hasextendedxmp' => { 527 => 'HasExtendedXMP' },
	'hassettings' => { 496 => 'HasSettings', 498 => 'HasSettings' },
	'hastranslation' => { 515 => 'hasTranslation' },
	'hasvisibleoverprint' => { 530 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 530 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 238 => 0x35a },
	'hdmioutputresolution' => { 239 => 0x610, 240 => 0x640, 241 => 0x6a8 },
	'hdmiviewassist' => { 312 => 0x20f },
	'hdr' => { 60 => 0x1, 219 => 0x4, 220 => 0x4, 337 => 0x9e, 372 => 0x85, 437 => 0x200a },
	'hdrcapacitymax' => { 507 => 'HDRCapacityMax' },
	'hdrcapacitymin' => { 507 => 'HDRCapacityMin' },
	'hdreditmode' => { 496 => 'HDREditMode', 498 => 'HDREditMode' },
	'hdreffect' => { 60 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 219 => 0x5, 220 => 0x5, 426 => 0x2e, 442 => 0x17 },
	'hdrlevel2' => { 219 => 0x7 },
	'hdrpmakernote' => { 479 => 'hdrp_makernote' },
	'hdrsetting' => { 426 => 0x2d, 442 => 0x16, 446 => 0x1148, 447 => 0x1148, 448 => 0x1124, 449 => 0x11a0, 450 => 0x117c, 451 => 0x1034, 452 => 0x22c, 453 => 0x22c, 454 => 0x21f },
	'hdrshot' => { 337 => 0x76 },
	'hdrsmoothing' => { 219 => 0x6 },
	'hdvideo' => { 389 => 'hdvd' },
	'headline' => { 131 => 0x69, 510 => 'Headline', 513 => 'Headline' },
	'hierarchicalkeywords' => { 171 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 171 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 171 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 171 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 171 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 488 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 118 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 240 => 0x48, 241 => 0x48 },
	'highfrequencyflickerreductionshooting' => { 240 => 0x27c, 241 => 0x27c },
	'highisomultiplierblue' => { 342 => 0x1a },
	'highisomultipliergreen' => { 342 => 0x19 },
	'highisomultiplierred' => { 342 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 62 => 0x5, 84 => 0x202, 234 => 0xb1, 372 => 0x71, 424 => 0x2c, 425 => 0x26, 426 => 0x26, 437 => 0x2009, 442 => 0x12, 468 => 0x42 },
	'highisonoisereduction2' => { 437 => 0xb050 },
	'highlight' => { 414 => 0xf },
	'highlight2012' => { 496 => 'Highlight2012', 498 => 'Highlight2012' },
	'highlightadj' => { 103 => 0x2030c },
	'highlightcolordistortreduct' => { 472 => 0x8026 },
	'highlightlinearitylimit' => { 411 => 0xa025 },
	'highlightprotection' => { 288 => 0x6 },
	'highlightrecovery' => { 496 => 'HighlightRecovery', 498 => 'HighlightRecovery' },
	'highlights' => { 437 => 0x2033, 490 => 'Highlights' },
	'highlights2012' => { 496 => 'Highlights2012', 498 => 'Highlights2012' },
	'highlightsadj' => { 472 => 0x9019 },
	'highlightshadow' => { 337 => 0xad },
	'highlighttone' => { 127 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 62 => 0x3, 84 => 0x203 },
	'highlightwarning' => { 337 => 0x8002 },
	'highlowkeyadj' => { 372 => 0x6c },
	'highspeedsync' => { 184 => 0x5, 312 => 0x55, 424 => 0x2, 425 => 0x2 },
	'hintversion' => { 397 => 'hinv' },
	'histogramxml' => { 289 => 0x83a1a25 },
	'history' => { 513 => 'History', 526 => 'History' },
	'historyaction' => { 526 => [\'History','HistoryAction'] },
	'historychanged' => { 526 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 526 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 526 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 526 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 526 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 138 => 0xc88 },
	'holefilldeltathreshold' => { 138 => 0xc7e },
	'hometowncity' => { 113 => 0x3006, 372 => 0x23, 378 => 0x2 },
	'hometowncitycode' => { 379 => 0x1000 },
	'hometowndst' => { 372 => 0x25, 378 => '0.2' },
	'hostcomputer' => { 119 => 0x13c },
	'hostsoftwarerendering' => { 138 => 0xce7 },
	'hue' => { 189 => 0x3b, 249 => 0x3d, 250 => 0x45, 372 => 0x67 },
	'hueadj' => { 292 => 0x2f, 472 => 0x8019 },
	'hueadjust' => { 404 => 0x1016 },
	'hueadjustment' => { 182 => 0x4a, 183 => 0x40, 234 => 0x92, 248 => 0x36 },
	'hueadjustmentaqua' => { 496 => 'HueAdjustmentAqua', 498 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 496 => 'HueAdjustmentBlue', 498 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 496 => 'HueAdjustmentGreen', 498 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 496 => 'HueAdjustmentMagenta', 498 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 496 => 'HueAdjustmentOrange', 498 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 496 => 'HueAdjustmentPurple', 498 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 496 => 'HueAdjustmentRed', 498 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 496 => 'HueAdjustmentYellow', 498 => 'HueAdjustmentYellow' },
	'huesetting' => { 322 => 0x1011 },
	'humanobservation' => { 118 => 'HumanObservation' },
	'humanobservationday' => { 118 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 118 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 118 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 118 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 118 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 118 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 118 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 118 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 118 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 118 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 118 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 118 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 118 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 118 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 118 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 118 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 118 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 118 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 118 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 118 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 119 => 0x9401, 503 => 'Humidity' },
	'icc_profile' => { 120 => 'ICC_Profile' },
	'iccprofilename' => { 513 => 'ICCProfile' },
	'iconuri' => { 397 => 'icnu' },
	'idccreativestyle' => { 472 => 0x8000 },
	'idcpreviewlength' => { 472 => 0x202 },
	'idcpreviewstart' => { 472 => 0x201 },
	'identification' => { 118 => 'Identification' },
	'identificationid' => { 118 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 118 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 118 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 118 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 118 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 118 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 118 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 499 => 'identifier', 523 => 'Identifier' },
	'ifcameramodel' => { 138 => 0x9c8 },
	'illuminantdata1' => { 119 => 0xcd35 },
	'illuminantdata2' => { 119 => 0xcd36 },
	'illuminantdata3' => { 119 => 0xcd37 },
	'illumination' => { 307 => '0.5', 399 => 0x48 },
	'imageabsolutex' => { 138 => 0x3fe },
	'imageabsolutey' => { 138 => 0x3ff },
	'imageadjustment' => { 234 => 0x80, 279 => 0x5 },
	'imagealterationconstraints' => { 324 => 'ImageAlterationConstraints' },
	'imagearea' => { 265 => 0x10, 268 => 0x10 },
	'imageareaoffset' => { 372 => 0x38 },
	'imageauthentication' => { 234 => 0x20 },
	'imageboundary' => { 234 => 0x16 },
	'imagecapturereqestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 127 => 0x1438, 234 => 0xa5, 440 => 0x11b },
	'imagecreator' => { 324 => 'ImageCreator' },
	'imagecreatorid' => { 324 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 324 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 324 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 138 => 0x41f },
	'imagecropy' => { 138 => 0x420 },
	'imagedata' => { 483 => 'Data' },
	'imagedatasize' => { 234 => 0xa2 },
	'imagedescription' => { 119 => 0x10e, 521 => 'ImageDescription' },
	'imageduplicationconstraints' => { 324 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 289 => 0xfe443a45 },
	'imageeditcount' => { 372 => 0x41 },
	'imageediting' => { 372 => 0x32 },
	'imageeditingsoftware' => { 119 => 0xa43b },
	'imageeditor' => { 119 => 0xa438 },
	'imageeffects' => { 404 => 0x1010 },
	'imagefileconstraints' => { 324 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 324 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 324 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 127 => 0x1436 },
	'imageheight' => { 119 => 0x101, 188 => 0xc, 381 => 0x10d, 481 => 'ImageHeight', 521 => 'ImageLength' },
	'imagehistory' => { 119 => 0x9213, 501 => 'ImageHistory' },
	'imageidnumber' => { 332 => 0x340 },
	'imagemimetype' => { 483 => 'Mime' },
	'imagenumber' => { 119 => 0x9211, 156 => 'ImageNumber', 182 => 0xae, 183 => 0x5e, 381 => 0x113, 424 => 0x9b, 426 => [0x400,'276.1',0x314], 493 => 'ImageNumber' },
	'imagenumber2' => { 183 => 0x62 },
	'imageoptimization' => { 234 => 0xa9 },
	'imageorientation' => { 131 => 0x83 },
	'imageprocessing' => { 234 => 0x1a },
	'imageprocessingfiledatecreated' => { 138 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 138 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 318 => 0x0 },
	'imagequality' => { 156 => 'ImageQuality', 267 => '723.2', 268 => '732.2', 276 => '708.1', 337 => 0x1 },
	'imagequality2' => { 314 => 0x603 },
	'imagerank' => { 486 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 138 => 0x600 },
	'imagerboardversion' => { 138 => 0x439 },
	'imagercols' => { 138 => 0x17d4 },
	'imageref' => { 508 => 'ImageRef' },
	'imageregion' => { 510 => 'ImageRegion' },
	'imageregionboundary' => { 510 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 510 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 510 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 510 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 510 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 510 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 510 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 510 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 510 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 510 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 510 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 510 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 510 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 510 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 510 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 510 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 510 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 510 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 510 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 138 => 0x944 },
	'imageresolutionjpg' => { 138 => 0x945 },
	'imagereview' => { 298 => '0.4', 307 => '0.4' },
	'imagereviewmonitorofftime' => { 297 => '21.1', 299 => '21.1', 300 => '21.1', 304 => '20.1', 309 => '21.1', 310 => '21.1', 312 => 0x39 },
	'imagereviewtime' => { 296 => '25.1', 298 => '2.1', 301 => '19.1', 302 => '20.1', 303 => '20.1', 305 => '9.2', 306 => '20.1', 311 => '21.2' },
	'imagerfiledatecreated' => { 138 => 0x9c5 },
	'imagerfileproductionlevel' => { 138 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 138 => 0x9c7 },
	'imagerotated' => { 151 => 0x2a },
	'imagerpowerondelaymsec' => { 138 => 0x5fd },
	'imagerrows' => { 138 => 0x17de },
	'imagesegmentlines' => { 138 => 0x184d },
	'imagesegmentstartline' => { 138 => 0x184c },
	'imagesize' => { 162 => 'ImageSize' },
	'imagesizeraw' => { 234 => 0x3e },
	'imagesizerestriction' => { 518 => 'imageSizeRestriction' },
	'imagesourcedata' => { 119 => 0x935c },
	'imagespace' => { 138 => 0x909 },
	'imagestabilization' => { 34 => 0x22, 113 => 0x3020, 127 => 0x1422, 156 => 'ImageStabilization', 182 => 0xbd, 183 => 0x71, 184 => 0x57, 185 => 0x0, 186 => [0x18,0x107,0x113], 187 => 0x49c2, 234 => 0xac, 314 => 0x604, 317 => 0x1600, 337 => 0x1a, 429 => 0x12, 430 => 0x11, 437 => 0xb026 },
	'imagestabilization2' => { 428 => 0xa },
	'imagestabilizationsetting' => { 187 => 0x14, 424 => 0x3d, 425 => 0x3d, 435 => 0x14 },
	'imagestyle' => { 424 => 0x2d, 425 => 0x27 },
	'imagesupplier' => { 324 => 'ImageSupplier' },
	'imagesupplierid' => { 324 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 324 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 324 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 121 => 0x1 },
	'imagetemperaturemin' => { 121 => 0x2 },
	'imagetone' => { 372 => 0x4f },
	'imagetype' => { 131 => 0x82, 324 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 64 => 0x28, 119 => 0xa420, 501 => 'ImageUniqueID', 502 => 'ImageUniqueID' },
	'imagewidth' => { 119 => 0x100, 188 => 0xe, 381 => 0x10c, 481 => 'ImageWidth', 521 => 'ImageWidth' },
	'inclinationangle' => { 472 => 0x900f },
	'inclinationcorrection' => { 472 => 0x900e },
	'incrementaltemperature' => { 496 => 'IncrementalTemperature', 498 => 'IncrementalTemperature' },
	'incrementaltint' => { 496 => 'IncrementalTint', 498 => 'IncrementalTint' },
	'industry' => { 515 => 'industry', 516 => 'industry' },
	'infobuttonwhenshooting' => { 84 => 0x409 },
	'information' => { 391 => 'information', 397 => "\xa9inf" },
	'infourl' => { 397 => 'infu' },
	'infraredilluminator' => { 398 => 0x28 },
	'ingredientexclusion' => { 517 => 'ingredientExclusion' },
	'ingredients' => { 526 => 'Ingredients' },
	'ingredientsalternatepaths' => { 526 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 526 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 526 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 526 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 526 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 526 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 526 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 526 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 526 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 526 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 526 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 526 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 526 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 526 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 526 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 526 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 526 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 526 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 526 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 526 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 526 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 526 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 526 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 84 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 484 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 484 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 179 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 484 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 484 => 'InitialViewHeadingDegrees', 485 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 484 => 'InitialViewPitchDegrees', 485 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 484 => 'InitialViewRollDegrees', 485 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 296 => '4.4' },
	'initialzoomsetting' => { 296 => '9.3', 305 => '27.3' },
	'inkset' => { 119 => 0x14c },
	'inputprofile' => { 138 => 0x1389 },
	'instanceid' => { 526 => 'InstanceID' },
	'instantplaybacksetup' => { 184 => 0x3e },
	'instantplaybacktime' => { 184 => 0x3d },
	'instructions' => { 513 => 'Instructions' },
	'instrument' => { 525 => 'instrument' },
	'integrationtime' => { 138 => 0x423 },
	'intellectualgenre' => { 509 => 'IntellectualGenre' },
	'intelligentauto' => { 437 => 0xb052, 464 => 0xd, 465 => 0xe, 466 => 0xd },
	'intelligentcontrast' => { 52 => 0x4 },
	'intelligentd-range' => { 337 => 0x79 },
	'intelligentexposure' => { 337 => 0x5d },
	'intelligentresolution' => { 337 => 0x70 },
	'interchangecolorspace' => { 133 => 0x40 },
	'intergraphmatrix' => { 119 => 0x8480 },
	'internalflash' => { 181 => 0x2b, 296 => '23.1', 298 => '8.1', 301 => '22.1', 303 => '23.1', 307 => '8.1', 311 => '24.1', 317 => 0x1208 },
	'internalflashae1' => { 319 => 0x1021 },
	'internalflashae1_0' => { 319 => 0x101d },
	'internalflashae2' => { 319 => 0x1022 },
	'internalflashae2_0' => { 319 => 0x101e },
	'internalflashmode' => { 360 => 0x1 },
	'internalflashstrength' => { 360 => 0x3 },
	'internalflashtable' => { 319 => 0x1024 },
	'internallensserialnumber' => { 411 => 0xa005 },
	'internalndfilter' => { 337 => 0x9d },
	'internalserialnumber' => { 64 => 0x96, 76 => 0x9, 127 => 0x10, 187 => 0x49dc, 313 => 0x18, 315 => 0x102, 334 => 0x500, 337 => 0x25, 352 => 0x4, 404 => 0x5, 456 => [0x7c,0xf0], 457 => 0x88, 458 => [0x88,0x8a] },
	'interopindex' => { 119 => 0x1, 503 => 'InteroperabilityIndex' },
	'interopversion' => { 119 => 0x2 },
	'interval' => { 255 => 0x20 },
	'intervaldurationhours' => { 238 => 0xa0 },
	'intervaldurationminutes' => { 238 => 0xa4 },
	'intervaldurationseconds' => { 238 => 0xa8 },
	'intervalexposuresmoothing' => { 223 => 0x184, 238 => 0xb8 },
	'intervalframe' => { 255 => 0x24 },
	'intervallength' => { 181 => 0x10 },
	'intervalmode' => { 181 => 0x26 },
	'intervalnumber' => { 181 => 0x11 },
	'intervalpriority' => { 223 => 0x186, 238 => 0xba },
	'intervals' => { 223 => 0x17c, 238 => 0xb0, 239 => 0xbc, 240 => 0xcc, 241 => 0xcc },
	'intervalshooting' => { 224 => 0x24, 257 => 0x24, 258 => 0x28, 372 => 0x92 },
	'introtime' => { 525 => 'introTime' },
	'introtimescale' => { 525 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 525 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 138 => 0xdae },
	'ipfcameramodel' => { 138 => 0xe4d },
	'iptc' => { 120 => 'IPTC' },
	'iptc-naa' => { 119 => 0x83bb, 342 => 0x83bb },
	'iptcbitspersample' => { 133 => 0x56 },
	'iptcdigest' => { 386 => 0x425 },
	'iptcimageheight' => { 133 => 0x1e },
	'iptcimagerotation' => { 133 => 0x66 },
	'iptcimagewidth' => { 133 => 0x14 },
	'iptclastedited' => { 510 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 133 => 0xa },
	'iptcpixelheight' => { 133 => 0x32 },
	'iptcpixelwidth' => { 133 => 0x28 },
	'isalternativeof' => { 515 => 'isAlternativeOf' },
	'isbn' => { 515 => 'isbn' },
	'iscorrectionof' => { 515 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 109 => 0x3 },
	'ismergedhdr' => { 493 => 'IsMergedHDR' },
	'ismergedpanorama' => { 493 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 30 => 0x0, 31 => 0x1, 112 => 0x14, 113 => [0x3014,0x14], 119 => 0x8827, 137 => 0xfd06, 138 => 0x1784, 140 => 0x60, 142 => [0xfa2e,0xfa46], 143 => [0x27,0x28], 144 => 0xf105, 147 => 0x14, 149 => 0x4e, 151 => 0x1e, 152 => 0x1a, 154 => 0x34, 156 => 'ISO', 181 => 0x8, 187 => 0x49ba, 222 => 0x0, 234 => 0x2, 337 => 0xd1, 342 => 0x17, 372 => [0x8b,0x14], 379 => 0x14, 381 => 0x105, 411 => 0xa014, 414 => 0x86, 435 => 0x6f, 442 => [0x1f,0x21,0x25], 502 => 'ISOSpeedRatings' },
	'iso2' => { 222 => 0x6, 262 => 0x265, 263 => 0x25c, 264 => 0x265, 265 => 0x221, 266 => 0x25d, 267 => 0x256, 268 => 0x25d, 271 => 0x2b5, 274 => 0x265, 278 => 0x2b5 },
	'isoauto' => { 353 => '14.4' },
	'isoautoflashlimit' => { 239 => 0x146, 240 => 0x15a, 241 => 0x15a },
	'isoautohilimit' => { 221 => 0x5, 239 => 0x144, 240 => 0x158, 241 => 0x158, 260 => 0x5, 270 => 0x18eb },
	'isoautomax' => { 436 => 0x4 },
	'isoautomin' => { 436 => 0x2 },
	'isoautoparameters' => { 372 => 0x7a },
	'isoautoshuttertime' => { 221 => 0x4, 239 => 0x14e, 240 => 0x162, 241 => 0x162, 260 => 0x4, 270 => 0x18ea },
	'isobutton' => { 241 => 0x796 },
	'isocalibrationgain' => { 138 => 0x89f },
	'isodisplay' => { 299 => '4.1', 300 => '4.1', 301 => '2.3', 302 => '3.3', 303 => '3.3', 306 => '3.3', 309 => '4.3', 310 => '4.1', 311 => '4.3' },
	'isoexpansion' => { 84 => 0x103, 85 => 0x7, 86 => 0x8, 89 => 0x8, 222 => 0x4 },
	'isoexpansion2' => { 222 => 0xa },
	'isofloor' => { 353 => 0x6 },
	'isoselected' => { 336 => 0x359 },
	'isoselection' => { 234 => 0xf },
	'isosensitivitystep' => { 304 => '6.2', 306 => '6.2' },
	'isosetting' => { 140 => 0x5e, 152 => 0x14, 156 => 'ISOSetting', 181 => 0x24, 182 => 0x26, 183 => 0x1c, 184 => 0x13, 189 => 0x6, 234 => 0x13, 353 => '17.3', 403 => 0x27, 424 => 0x16, 425 => 0x14, 426 => 0x2, 435 => 0x6d, 436 => 0x0 },
	'isospeed' => { 119 => 0x8833, 503 => 'ISOSpeed' },
	'isospeedexpansion' => { 83 => 0x3 },
	'isospeedincrements' => { 84 => 0x102 },
	'isospeedlatitudeyyy' => { 119 => 0x8834, 503 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 119 => 0x8835, 503 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 84 => 0x103 },
	'isostepsize' => { 296 => '6.1', 297 => '7.2', 299 => '7.2', 300 => '7.2', 305 => '4.1', 309 => '7.2', 310 => '7.2', 312 => 0x15d },
	'isovalue' => { 319 => 0x1001 },
	'isrccode' => { 397 => "\xa9isr" },
	'issn' => { 515 => 'issn' },
	'issueidentifier' => { 515 => 'issueIdentifier' },
	'issuename' => { 515 => 'issueName' },
	'issueteaser' => { 515 => 'issueTeaser' },
	'issuetype' => { 515 => 'issueType' },
	'istranslationof' => { 515 => 'isTranslationOf' },
	'itemsubtype' => { 178 => 'ItemSubType' },
	'itunesu' => { 389 => 'itnu' },
	'jobid' => { 131 => 0xb8 },
	'jobname' => { 504 => 'JobName' },
	'jobref' => { 524 => 'JobRef' },
	'jobrefid' => { 524 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 524 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 524 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 504 => 'JobStatus' },
	'jpeg-heifswitch' => { 437 => 0x2039 },
	'jpeghandling' => { 496 => 'JPEGHandling', 498 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 337 => 0x43, 339 => 0x3034, 437 => 0xb047 },
	'jpegsize' => { 339 => 0x303a },
	'jpgcompression' => { 225 => 0x24 },
	'jpgfromraw' => { 97 => 0x2007, 114 => 'Exif-JpgFromRaw', 342 => 0x2e },
	'jpgfromrawlength' => { 119 => [0x117,0x202] },
	'jpgfromrawstart' => { 119 => [0x111,0x201] },
	'jpgrecordedpixels' => { 353 => '14.1' },
	'jurisdiction' => { 494 => 'jurisdiction' },
	'keepexposure' => { 312 => 0x237 },
	'kelvinwb_01' => { 361 => 0x5 },
	'kelvinwb_02' => { 361 => 0x9 },
	'kelvinwb_03' => { 361 => 0xd },
	'kelvinwb_04' => { 361 => 0x11 },
	'kelvinwb_05' => { 361 => 0x15 },
	'kelvinwb_06' => { 361 => 0x19 },
	'kelvinwb_07' => { 361 => 0x1d },
	'kelvinwb_08' => { 361 => 0x21 },
	'kelvinwb_09' => { 361 => 0x25 },
	'kelvinwb_10' => { 361 => 0x29 },
	'kelvinwb_11' => { 361 => 0x2d },
	'kelvinwb_12' => { 361 => 0x31 },
	'kelvinwb_13' => { 361 => 0x35 },
	'kelvinwb_14' => { 361 => 0x39 },
	'kelvinwb_15' => { 361 => 0x3d },
	'kelvinwb_16' => { 361 => 0x41 },
	'kelvinwb_daylight' => { 361 => 0x1 },
	'kerneldenominators' => { 138 => 0x933 },
	'key' => { 525 => 'key' },
	'keystonecompensation' => { 318 => 0x1900 },
	'keystonedirection' => { 318 => 0x1901 },
	'keystonevalue' => { 318 => 0x1906 },
	'keyword' => { 389 => 'keyw', 515 => 'keyword' },
	'keywordinfo' => { 171 => 'Keywords' },
	'keywords' => { 131 => 0x19, 157 => 'Keywords', 323 => 'Keywords', 388 => 'Keywords', 391 => 'keywords', 491 => 'keywords', 512 => 'Keywords', 523 => 'Keywords' },
	'killdate' => { 515 => 'killDate' },
	'killdatea-platform' => { 515 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 515 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 137 => 0xf908, 140 => 0xe, 142 => [0xfa1e,0xfa52], 148 => 0x70 },
	'kodakimagewidth' => { 137 => 0xf907, 140 => 0xc, 142 => [0xfa1d,0xfa51], 148 => 0x6c },
	'kodakinfotype' => { 137 => 0xfa00 },
	'kodaklook' => { 138 => 0xe4c },
	'kodaklookprofile' => { 138 => 0x138a },
	'kodakmaker' => { 148 => 0x8 },
	'kodakmodel' => { 140 => 0x0, 148 => 0x28 },
	'kodaktag' => { 138 => 0x3ea },
	'kodakversion' => { 138 => 0x0 },
	'label' => { 327 => 'Label', 523 => 'Label' },
	'labelname1' => { 508 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 508 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 508 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 508 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 508 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 508 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 337 => 0x6f },
	'landscapeoutputhighlightpoint' => { 109 => 0x26 },
	'landscapeoutputshadowpoint' => { 109 => 0x27 },
	'landscaperawcolortone' => { 109 => 0x1f },
	'landscaperawcontrast' => { 109 => 0x21 },
	'landscaperawhighlight' => { 109 => 0x77 },
	'landscaperawhighlightpoint' => { 109 => 0x24 },
	'landscaperawlinear' => { 109 => 0x22 },
	'landscaperawsaturation' => { 109 => 0x20 },
	'landscaperawshadow' => { 109 => 0x80 },
	'landscaperawshadowpoint' => { 109 => 0x25 },
	'landscaperawsharpness' => { 109 => 0x23 },
	'landscapeunsharpmaskfineness' => { 109 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 109 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 109 => 0xa2 },
	'language' => { 239 => 0x592, 240 => 0x5c2, 241 => 0x5c2, 499 => 'language' },
	'languageidentifier' => { 131 => 0x87 },
	'largestvalidinteriorrectheight' => { 484 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 484 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 484 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 484 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 181 => 0x1b },
	'lastkeywordiptc' => { 178 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 178 => 'LastKeywordXMP' },
	'lastphotodate' => { 484 => 'LastPhotoDate' },
	'lasturl' => { 526 => 'LastURL' },
	'lateralchromaticaberration' => { 437 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 493 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 118 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 118 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 118 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 118 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 118 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 116 => 'Latitude' },
	'lc1' => { 363 => 0x2 },
	'lc10' => { 363 => 0xb },
	'lc11' => { 363 => 0xc },
	'lc12' => { 363 => 0xd },
	'lc14' => { 363 => 0xf },
	'lc15' => { 363 => 0x10 },
	'lc3' => { 363 => 0x4 },
	'lc4' => { 363 => 0x5 },
	'lc5' => { 363 => 0x6 },
	'lc6' => { 363 => 0x7 },
	'lc7' => { 363 => 0x8 },
	'lc8' => { 363 => 0x9 },
	'lcddisplayatpoweron' => { 84 => 0x811, 88 => 0xa },
	'lcddisplayreturntoshoot' => { 89 => 0x12 },
	'lcdillumination' => { 296 => '17.5', 297 => '5.2', 299 => '5.1', 300 => '5.1', 305 => '10.3', 306 => '4.2', 309 => '5.2', 310 => '5.1', 311 => '5.4', 312 => 0x101 },
	'lcdilluminationduringbulb' => { 84 => 0x408 },
	'lcdmatrix' => { 138 => 0xe74 },
	'lcdmatrixchickfix' => { 138 => 0xe75 },
	'lcdmatrixmarvin' => { 138 => 0xe76 },
	'lcdpanels' => { 83 => 0x8 },
	'lcheditor' => { 289 => 0x8ae85e },
	'legacyiptcdigest' => { 513 => 'LegacyIPTCDigest' },
	'legalcode' => { 494 => 'legalcode' },
	'lens' => { 119 => 0xfdea, 234 => 0x84, 493 => 'Lens' },
	'lensafstopbutton' => { 82 => 0x11, 83 => 0x13, 84 => 0x506, 85 => 0x10, 86 => 0x12, 89 => 0x13, 90 => 0x9 },
	'lensaperturerange' => { 414 => [0x30,0x48] },
	'lenscontrolring' => { 312 => 0xad },
	'lenscorrectionsettings' => { 501 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 493 => 'LensDistortInfo' },
	'lensdistortionparams' => { 319 => 0x206 },
	'lensdriveend' => { 232 => 0x56 },
	'lensdrivenoaf' => { 84 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 426 => 0x3f0, 471 => 0xd },
	'lensfirmware' => { 405 => 0x20, 411 => 0xa004 },
	'lensfirmwareversion' => { 315 => 0x204, 337 => 0x60, 426 => 0x3f3, 471 => 0x14 },
	'lensfocallength' => { 103 => 0xf0512, 363 => 0x9 },
	'lensfocalrange' => { 414 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 297 => '55.1', 299 => '52.1', 300 => '52.1', 309 => '52.1', 310 => '52.1' },
	'lensformat' => { 450 => 0x1891, 452 => 0x18bd, 453 => 0x18ed, 454 => 0x17f1, 456 => 0x106, 457 => 0x106, 467 => 0x603, 468 => 0x5d },
	'lensfstops' => { 226 => 0x7, 227 => 0xc, 228 => 0xd, 232 => 0xe, 234 => 0x8b, 363 => '0.3' },
	'lensfunc1button' => { 312 => 0x9f },
	'lensfunc1buttonplaybackmode' => { 241 => 0x810 },
	'lensfunc2button' => { 312 => 0xa7 },
	'lensfunc2buttonplaybackmode' => { 241 => 0x812 },
	'lensid' => { 232 => 0x30, 493 => 'LensID' },
	'lensidnumber' => { 226 => 0x6, 227 => 0xb, 228 => 0xc, 232 => 0xd },
	'lensinfo' => { 119 => 0xa432, 369 => 0x2a, 493 => 'LensInfo', 503 => 'LensSpecification' },
	'lenskind' => { 363 => 0x1 },
	'lensmake' => { 119 => 0xa433, 163 => 'Make', 503 => 'LensMake' },
	'lensmanualdistortionamount' => { 496 => 'LensManualDistortionAmount', 498 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 178 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 414 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 64 => 0x95, 119 => 0xa434, 163 => 'Model', 178 => 'LensModel', 229 => 0x18a, 230 => 0x18b, 231 => 0x2ac, 315 => 0x203, 369 => 0xc, 381 => 0x412, 503 => 'LensModel' },
	'lensmodulationoptimizer' => { 127 => 0x1045 },
	'lensmount' => { 426 => 0x99, 450 => 0x1892, 452 => 0x18be, 453 => 0x18ee, 454 => 0x17f2, 456 => 0x105, 457 => 0x105, 467 => 0x604, 468 => 0x5e },
	'lensmount2' => { 471 => 0x8 },
	'lensmounttype' => { 232 => 0x35 },
	'lenspositionabsolute' => { 232 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 496 => 'LensProfileChromaticAberrationScale', 498 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 496 => 'LensProfileDigest', 498 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 496 => 'LensProfileDistortionScale', 498 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 496 => 'LensProfileEnable', 498 => 'LensProfileEnable' },
	'lensprofilefilename' => { 496 => 'LensProfileFilename', 498 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 496 => 'LensProfileIsEmbedded', 498 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 496 => 'LensProfileMatchKeyCameraModelName', 498 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 496 => 'LensProfileMatchKeyExifMake', 498 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 496 => 'LensProfileMatchKeyExifModel', 498 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 496 => 'LensProfileMatchKeyIsRaw', 498 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 496 => 'LensProfileMatchKeyLensID', 498 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 496 => 'LensProfileMatchKeyLensInfo', 498 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 496 => 'LensProfileMatchKeyLensName', 498 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 496 => 'LensProfileMatchKeySensorFormatFactor', 498 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 496 => 'LensProfileName', 498 => 'LensProfileName' },
	'lensprofilesetup' => { 496 => 'LensProfileSetup', 498 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 496 => 'LensProfileVignettingScale', 498 => 'LensProfileVignettingScale' },
	'lensproperties' => { 315 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 32 => 0x16b, 61 => 0x0, 119 => 0xa435, 163 => 'SerialNumber', 315 => 0x202, 335 => 0x321, 337 => 0x52, 397 => 'LENS', 405 => 0x30, 493 => 'LensSerialNumber', 503 => 'LensSerialNumber' },
	'lensshutterlock' => { 184 => 0x4a },
	'lensspec' => { 421 => 0x0, 422 => 0x0, 423 => 0x0, 437 => 0xb02a },
	'lensspecfeatures' => { 456 => [0x115,0x116], 457 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 319 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 34 => 0x16, 186 => 0x10c, 187 => 0x49bd, 234 => 0x83, 315 => 0x201, 328 => 0x16, 332 => 0x310, 334 => 0x303, 335 => 0x303, 337 => 0x51, 339 => 0x3405, 364 => 0x0, 365 => 0x0, 366 => 0x1, 367 => 0x1, 368 => 0x1, 370 => 0x0, 411 => 0xa003, 414 => 0x27, 437 => 0xb027, 450 => 0x1896, 452 => 0x18c2, 453 => 0x18f2, 454 => 0x17f6, 456 => 0x109, 457 => 0x109, 467 => 0x608, 468 => 0x62 },
	'lenstype2' => { 426 => 0x3f7, 450 => 0x1893, 452 => 0x18bf, 453 => 0x18ef, 454 => 0x17f3, 456 => 0x107, 457 => 0x107, 467 => 0x605, 468 => 0x60 },
	'lenstype3' => { 471 => 0x9 },
	'lenstypemake' => { 337 => 0xc4 },
	'lenstypemodel' => { 337 => [0xc5,0xe4] },
	'lenszoomposition' => { 464 => 0x19, 465 => 0x1e, 468 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 345 => 0x15 },
	'levelmeter' => { 397 => ['Lvlm','lvlm'] },
	'levelorientation' => { 371 => 0x0 },
	'license' => { 494 => 'license' },
	'licensee' => { 324 => 'Licensee' },
	'licenseeid' => { 324 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 324 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 324 => 'LicenseeImageNotes' },
	'licenseename' => { 324 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 324 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 324 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 324 => 'LicenseeTransactionID' },
	'licenseid' => { 324 => 'LicenseID' },
	'licensestartdate' => { 324 => 'LicenseStartDate' },
	'licensetransactiondate' => { 324 => 'LicenseTransactionDate' },
	'licensetype' => { 500 => 'licensetype' },
	'licensor' => { 324 => 'Licensor' },
	'licensorcity' => { 324 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 324 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 324 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 324 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 324 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 324 => 'LicensorImageID' },
	'licensorname' => { 324 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 324 => 'LicensorNotes' },
	'licensorpostalcode' => { 324 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 324 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 324 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 324 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 324 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 324 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 324 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 324 => 'LicensorTransactionID' },
	'licensorurl' => { 324 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 319 => 0x1009 },
	'lightingmode' => { 113 => 0x302a },
	'lightreading' => { 372 => 0x15 },
	'lightsource' => { 119 => 0x9208, 234 => 0x90, 322 => 0x1000, 502 => 'LightSource' },
	'lightsourcespecial' => { 413 => 0x21d },
	'lightswitch' => { 309 => '0.1', 311 => '0.1' },
	'lightvaluecenter' => { 319 => 0x103d },
	'lightvalueperiphery' => { 319 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 312 => 0x153 },
	'limitaf-areamodeseldynamic_l' => { 312 => 0x151 },
	'limitaf-areamodeseldynamic_m' => { 312 => 0x150 },
	'limitaf-areamodeseldynamic_s' => { 312 => 0x14f },
	'limitaf-areamodeselpinpoint' => { 312 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 312 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 312 => 0x13 },
	'limitafareamodeselauto' => { 312 => 0x15 },
	'limitafareamodeselection' => { 297 => '51.1', 299 => '49.1', 300 => '49.1', 309 => '49.1', 310 => '49.1' },
	'limitreleasemodeselc120' => { 312 => '269.4' },
	'limitreleasemodeselc30' => { 312 => '269.3' },
	'limitreleasemodeselch' => { 312 => '269.2' },
	'limitreleasemodeselcl' => { 312 => '269.1' },
	'limitreleasemodeselself' => { 312 => '269.5' },
	'limitselectableimagearea16to9' => { 312 => 0x47 },
	'limitselectableimagearea1to1' => { 312 => 0x46 },
	'limitselectableimageareadx' => { 312 => 0x45 },
	'linearitylimitblue' => { 342 => 0x10 },
	'linearitylimitgreen' => { 342 => 0xf },
	'linearitylimitred' => { 342 => 0xe },
	'linearityuppermargin' => { 41 => 0x32c, 42 => 0x282, 45 => [0x2ba,0x2d1,0x2d5], 47 => 0x1e5, 48 => [0x1fe,0x2de], 49 => [0x232,0x310], 50 => 0x31e },
	'linearizationtable' => { 119 => 0xc618 },
	'linearresponselimit' => { 119 => 0xc62e },
	'link' => { 515 => 'link' },
	'linkaetoafpoint' => { 353 => '14.2' },
	'linkedencodedrightsexpr' => { 510 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 510 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 510 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 510 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 138 => 0x904 },
	'lithostratigraphicterms' => { 118 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 391 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 391 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 391 => 'live-photo.vitality-scoring-version' },
	'liveviewaf' => { 301 => '32.1', 311 => '34.1' },
	'liveviewafareamode' => { 306 => '34.1' },
	'liveviewafmethod' => { 442 => 0x20 },
	'liveviewafmode' => { 306 => '34.2' },
	'liveviewafsetting' => { 426 => 0x36 },
	'liveviewbuttonoptions' => { 297 => '50.2', 299 => '48.2', 300 => '48.2', 309 => '48.2', 310 => '48.2' },
	'liveviewexposuresimulation' => { 84 => 0x810 },
	'liveviewfocusmode' => { 426 => [0x8b,0x28b] },
	'liveviewmetering' => { 426 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 297 => '21.2', 299 => '21.2', 300 => '21.2', 302 => '20.2', 303 => '20.2', 304 => '20.2', 306 => '20.2', 309 => '21.2', 310 => '21.2' },
	'liveviewshooting' => { 57 => 0x13 },
	'livingspecimen' => { 118 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 118 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 131 => 0x79 },
	'localizedcameramodel' => { 119 => 0xc615 },
	'locallocationname' => { 411 => 0x30 },
	'location' => { 233 => 0x9, 337 => 0x67, 489 => 'Location', 509 => 'Location', 514 => 'location', 515 => 'location' },
	'locationaccuracyhorizontal' => { 391 => 'location.accuracy.horizontal' },
	'locationareacode' => { 495 => 'lac' },
	'locationbody' => { 391 => 'location.body' },
	'locationcreated' => { 510 => 'LocationCreated' },
	'locationcreatedcity' => { 510 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 510 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 510 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 510 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 510 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 510 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 510 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 510 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 510 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 510 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 510 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 510 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 391 => 'location.date' },
	'locationinformation' => { 397 => 'loci' },
	'locationinfoversion' => { 233 => 0x0 },
	'locationname' => { 391 => 'location.name', 411 => 0x31 },
	'locationnote' => { 391 => 'location.note' },
	'locationrole' => { 391 => 'location.role' },
	'locationshown' => { 510 => 'LocationShown' },
	'locationshowncity' => { 510 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 510 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 510 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 510 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 510 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 510 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 510 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 510 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 510 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 510 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 510 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 510 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 84 => 0x709 },
	'logcomment' => { 525 => 'logComment' },
	'logscale' => { 138 => 0x902 },
	'longdescription' => { 389 => 'ldes' },
	'longexposurenoisereduction' => { 62 => 0x4, 84 => 0x201, 85 => 0x1, 86 => 0x2, 87 => 0x1, 88 => 0x1, 89 => 0x2, 90 => 0x1, 337 => 0x49, 424 => 0x2b, 425 => 0x25, 426 => 0x25, 437 => 0x2008, 442 => 0x11, 468 => 0x44 },
	'longexposurenoisereduction2' => { 57 => 0x8 },
	'longexposurenrused' => { 337 => 0xbe },
	'longitude' => { 116 => 'Longitude' },
	'look' => { 496 => 'Look', 498 => 'Look' },
	'lookamount' => { 496 => [\'Look','LookAmount'], 498 => [\'Look','LookAmount'] },
	'lookcluster' => { 496 => [\'Look','LookCluster'], 498 => [\'Look','LookCluster'] },
	'lookcopyright' => { 496 => [\'Look','LookCopyright'], 498 => [\'Look','LookCopyright'] },
	'lookgroup' => { 496 => [\'Look','LookGroup'], 498 => [\'Look','LookGroup'] },
	'lookname' => { 496 => 'LookName', 498 => 'LookName' },
	'lookparameters' => { 496 => [\'Look','LookParameters'], 498 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 496 => [\'Look','LookParametersCameraProfile'], 498 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 496 => [\'Look','LookParametersClarity2012'], 498 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 496 => [\'Look','LookParametersConvertToGrayscale'], 498 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparameterslooktable' => { 496 => [\'Look','LookParametersLookTable'], 498 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 496 => [\'Look','LookParametersProcessVersion'], 498 => [\'Look','LookParametersProcessVersion'] },
	'lookparameterstonecurvepv2012' => { 496 => [\'Look','LookParametersToneCurvePV2012'], 498 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 496 => [\'Look','LookParametersToneCurvePV2012Blue'], 498 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 496 => [\'Look','LookParametersToneCurvePV2012Green'], 498 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 496 => [\'Look','LookParametersToneCurvePV2012Red'], 498 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 496 => [\'Look','LookParametersVersion'], 498 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 496 => [\'Look','LookSupportsAmount'], 498 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 496 => [\'Look','LookSupportsMonochrome'], 498 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 496 => [\'Look','LookSupportsOutputReferred'], 498 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 496 => [\'Look','LookUUID'], 498 => [\'Look','LookUUID'] },
	'loop' => { 525 => 'loop' },
	'loopstyle' => { 397 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 118 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 496 => 'LuminanceAdjustmentAqua', 498 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 496 => 'LuminanceAdjustmentBlue', 498 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 496 => 'LuminanceAdjustmentGreen', 498 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 496 => 'LuminanceAdjustmentMagenta', 498 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 496 => 'LuminanceAdjustmentOrange', 498 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 496 => 'LuminanceAdjustmentPurple', 498 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 496 => 'LuminanceAdjustmentRed', 498 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 496 => 'LuminanceAdjustmentYellow', 498 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 108 => 0x150 },
	'luminancecurvepoints' => { 108 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 103 => 0x20600, 109 => 0x5f, 414 => 0x1b },
	'luminancenoisereductioncontrast' => { 496 => 'LuminanceNoiseReductionContrast', 498 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 496 => 'LuminanceNoiseReductionDetail', 498 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 109 => 0x6d },
	'luminancesmoothing' => { 496 => 'LuminanceSmoothing', 498 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 84 => [0x40b,0x40c] },
	'lyrics' => { 389 => "\xa9lyr", 397 => "\xa9lyr", 525 => 'lyrics' },
	'lyricsuri' => { 397 => 'lrcu' },
	'm16cversion' => { 332 => 0x333 },
	'macatom' => { 497 => 'macAtom' },
	'macatomapplicationcode' => { 497 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 497 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 497 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 118 => 'MachineObservation' },
	'machineobservationday' => { 118 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 118 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 118 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 118 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 118 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 118 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 118 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 118 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 118 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 118 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 118 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 118 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 118 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 118 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 118 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 118 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 118 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 118 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 118 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 118 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 127 => 0x1020, 129 => 0x202, 151 => 0x2b, 319 => 0x202, 403 => 0x21, 413 => 0x202, 437 => 0xb040 },
	'macroled' => { 317 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 57 => 0x10 },
	'macromode' => { 34 => 0x1, 181 => 0xb, 314 => 0x300, 337 => 0x1c, 404 => 0x1009 },
	'magentahsl' => { 103 => 0x20917 },
	'magicfilter' => { 314 => 0x52c },
	'magnifiedview' => { 86 => 0x11, 88 => 0x9 },
	'mainboardversion' => { 138 => 0x438 },
	'maindialexposurecomp' => { 307 => '0.6' },
	'mainingredient' => { 517 => 'mainIngredient' },
	'majorversion' => { 487 => 'MajorVersion' },
	'make' => { 98 => 0x0, 115 => 0x1, 119 => 0x10f, 156 => 'Make', 327 => 'Make', 342 => 0x10f, 391 => 'make', 397 => ['@mak',"\xa9mak"], 514 => 'make', 521 => 'Make' },
	'makernote' => { 502 => 'MakerNote' },
	'makernoteapple' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecanon' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecasio' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecasio2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotedji' => { 117 => 'MakN', 119 => 0x927c },
	'makernotedjiinfo' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteflir' => { 117 => 'MakN', 119 => 0x927c },
	'makernotefujifilm' => { 117 => 'MakN', 119 => 0x927c },
	'makernotege' => { 117 => 'MakN', 119 => 0x927c },
	'makernotege2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehasselblad' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp6' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteisl' => { 117 => 'MakN', 119 => 0x927c },
	'makernotejvc' => { 117 => 'MakN', 119 => 0x927c },
	'makernotejvctext' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak10' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak11' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak12' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak1a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak1b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak6a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak6b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak7' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8c' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak9' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodakunknown' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekyocera' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica10' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica3' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica4' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica5' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica6' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica7' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica8' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica9' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotemotorola' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenintendo' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteoffset' => { 413 => 0xff },
	'makernoteolympus' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteolympus2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteolympus3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax6' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentaxunknown' => { 397 => 'PXMN' },
	'makernotephaseone' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericoh' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericoh2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericohpentax' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericohtext' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesafety' => { 119 => 0xc635 },
	'makernotesamsung1a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesamsung1b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesamsung2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyo' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyoc4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyopatch' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesigma' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesonyericsson' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesonysrf' => { 117 => 'MakN', 119 => 0x927c },
	'makernotetype' => { 404 => 0x1 },
	'makernoteunknown' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteunknownbinary' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteunknowntext' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 186 => 0x0, 234 => 0x1, 319 => 0x0, 337 => 0x8000, 408 => 0x0, 411 => 0x1, 414 => [0x1d,0x1f], 427 => 0x2000 },
	'makerurl' => { 397 => "\xa9mal" },
	'managedfrom' => { 526 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 526 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 526 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 526 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 526 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 526 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 526 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 526 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 526 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 526 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 526 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 526 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 526 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 526 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 526 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 526 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 526 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 526 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 526 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 526 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 526 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 526 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 526 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 526 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 526 => 'Manager' },
	'managervariant' => { 526 => 'ManagerVariant' },
	'manageto' => { 526 => 'ManageTo' },
	'manageui' => { 526 => 'ManageUI' },
	'manifest' => { 526 => 'Manifest' },
	'manifestlinkform' => { 526 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 526 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 526 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 526 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 526 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 526 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 526 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 526 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 526 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 526 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 526 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 526 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 526 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 526 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 526 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 526 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 526 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 526 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 526 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 526 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 526 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 526 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 526 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 526 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 526 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 526 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 526 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 526 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 314 => 0x900, 337 => 0x86 },
	'manometerreading' => { 314 => 0x901 },
	'manualafpointselectpattern' => { 84 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 317 => 0x1209 },
	'manualflashoutput' => { 34 => 0x29, 298 => '8.2', 301 => '22.2', 302 => '23.1', 303 => '23.2', 305 => '16.2', 306 => '23.2', 307 => '8.2', 308 => '23.2', 311 => '24.2', 404 => 0x100c },
	'manualflashstrength' => { 314 => 0x406 },
	'manualfocusdistance' => { 234 => 0x85, 319 => 0x100c, 413 => 0x223 },
	'manualfocuspointillumination' => { 312 => 0x17 },
	'manualfocusringinafmode' => { 312 => 0x1a },
	'manualtv' => { 83 => 0x5, 84 => 0x705 },
	'manufacturedate' => { 191 => 0x6705, 352 => 0x1 },
	'manufacturedate1' => { 406 => 0x4 },
	'manufacturedate2' => { 406 => 0x5 },
	'manufacturer' => { 481 => 'Manufacturer', 514 => 'manufacturer' },
	'mariahchromablursize' => { 138 => 0xf0d },
	'mariahmaphithreshold' => { 138 => 0xf0c },
	'mariahmaplothreshold' => { 138 => 0xf0b },
	'mariahsigmathreshold' => { 138 => 0xf0e },
	'mariahtexturethreshold' => { 138 => 0xf0a },
	'marked' => { 512 => 'Marked', 529 => 'Marked' },
	'markers' => { 525 => 'markers' },
	'markerscomment' => { 525 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 525 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 525 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 525 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 525 => [\'markers','markersCuePointType'] },
	'markersduration' => { 525 => [\'markers','markersDuration'] },
	'markerslocation' => { 525 => [\'markers','markersLocation'] },
	'markersname' => { 525 => [\'markers','markersName'] },
	'markersprobability' => { 525 => [\'markers','markersProbability'] },
	'markersspeaker' => { 525 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 525 => [\'markers','markersStartTime'] },
	'markerstarget' => { 525 => [\'markers','markersTarget'] },
	'markerstype' => { 525 => [\'markers','markersType'] },
	'maskedareas' => { 119 => 0xc68e },
	'maskgroupbasedcorractive' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 496 => 'MaskGroupBasedCorrections', 498 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 498 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 131 => 0xb9 },
	'mastergain' => { 256 => 0x50 },
	'materialsample' => { 118 => 'MaterialSample' },
	'materialsampleid' => { 118 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 297 => '50.1', 299 => '48.1', 300 => '48.1', 309 => '48.1', 310 => '48.1', 312 => 0x233 },
	'matrixselectk' => { 138 => 0x91b },
	'matrixselectthreshold' => { 138 => 0x91a },
	'matrixselectthreshold1' => { 138 => 0x91e },
	'matrixselectthreshold2' => { 138 => 0x91f },
	'matrixstructure' => { 396 => 0xa },
	'maxaperture' => { 34 => 0x1a, 138 => 0x3f9, 144 => 0x6103, 163 => 'MaxAperture', 181 => 0x17, 187 => 0x49c5, 232 => 0x36, 315 => 0x20a, 363 => '14.1' },
	'maxapertureatmaxfocal' => { 127 => 0x1407, 163 => 'MaxApertureAtMaxFocal', 226 => 0xb, 227 => 0x10, 228 => 0x11, 232 => 0x12, 315 => 0x206 },
	'maxapertureatminfocal' => { 127 => 0x1406, 226 => 0xa, 227 => 0xf, 228 => 0x10, 232 => 0x11, 315 => 0x205 },
	'maxaperturevalue' => { 119 => 0x9205, 381 => 0x414, 502 => 'MaxApertureValue' },
	'maxavailheight' => { 510 => 'MaxAvailHeight' },
	'maxavailwidth' => { 510 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 296 => 0xb, 297 => 0xc, 299 => '12.1', 300 => '12.1', 305 => 0xc, 306 => 0xb, 309 => '12.1', 310 => '12.1', 312 => 0x3d },
	'maxfaces' => { 318 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 34 => 0x17, 127 => 0x1405, 163 => 'MaxFocalLength', 226 => 0x9, 227 => 0xe, 228 => 0xf, 232 => 0x10, 315 => 0x208, 450 => 0x127c, 451 => 0x1138, 452 => 0x330, 453 => 0x330, 454 => 0x30e },
	'maximumdensityrange' => { 133 => 0x8c },
	'maxpagesize' => { 530 => 'MaxPageSize' },
	'maxpagesizeh' => { 530 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 530 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 530 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 138 => 0xc7d },
	'maxsamplevalue' => { 119 => 0x119 },
	'maxstorage' => { 520 => 'maxstorage' },
	'mb-d10batteries' => { 296 => '12.6' },
	'mb-d10batterytype' => { 305 => '13.3' },
	'mb-d11batterytype' => { 306 => '2.3' },
	'mb-d12batterytype' => { 309 => '3.2' },
	'mb-d80batteries' => { 307 => '6.5' },
	'mb-d80batterytype' => { 311 => '3.2' },
	'mcuversion' => { 226 => 0xc, 227 => 0x11, 228 => 0x12, 232 => 0x13 },
	'md5digest' => { 164 => 'zmd5' },
	'mditemfindercomment' => { 173 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 173 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 173 => 'MDItemFSLabel' },
	'mditemusertags' => { 173 => 'MDItemUserTags' },
	'meal' => { 517 => 'meal' },
	'measuredev' => { 28 => 0x9, 77 => 0x3, 97 => 0x1814, 156 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 77 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 187 => 0x690, 332 => 0x312, 335 => 0x312, 336 => 0x312, 339 => 0x3407 },
	'measuredrggb' => { 65 => 0x1 },
	'measuredrggbdata' => { 44 => 0x287 },
	'measurementaccuracy' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 118 => 'MeasurementOrFact' },
	'measurementremarks' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 481 => 'MeasureType' },
	'mechanicalshuttercount' => { 234 => 0x37 },
	'mediaclassprimaryid' => { 179 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 179 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 324 => 'MediaConstraints' },
	'mediacreatedate' => { 393 => 0x1 },
	'mediaeventiddate' => { 486 => 'MediaEventIdDate' },
	'mediagroupuuid' => { 1 => 0x11 },
	'mediamodifydate' => { 393 => 0x2 },
	'mediasummarycode' => { 324 => 'MediaSummaryCode' },
	'mediatype' => { 389 => 'stik' },
	'memoaudioquality' => { 84 => 0x812 },
	'memorycardconfiguration' => { 430 => 0x16 },
	'memorycardnumber' => { 211 => 0x2 },
	'menubuttondisplayposition' => { 82 => 0xb, 85 => 0xa, 86 => 0xb, 89 => 0xb },
	'menubuttonreturn' => { 90 => 0xb },
	'menumonitorofftime' => { 296 => '26.1', 297 => '22.1', 299 => '22.1', 300 => '22.1', 304 => '21.1', 305 => '8.2', 306 => '21.1', 309 => '22.1', 310 => '22.1', 311 => '22.1', 312 => 0x35 },
	'metadataauthority' => { 510 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 510 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 510 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 523 => 'MetadataDate' },
	'metadataeditingsoftware' => { 119 => 0xa43c },
	'metadatalastedited' => { 510 => 'metadataLastEdited' },
	'metadatalasteditor' => { 510 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 510 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 510 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 525 => 'metadataModDate' },
	'metaversion' => { 445 => 0x34 },
	'meterinfo1row1' => { 438 => 0x0, 439 => 0x0 },
	'meterinfo1row2' => { 438 => 0x6c, 439 => 0x5a },
	'meterinfo1row3' => { 438 => 0xd8, 439 => 0xb4 },
	'meterinfo1row4' => { 438 => 0x144, 439 => 0x10e },
	'meterinfo1row5' => { 438 => 0x1b0, 439 => 0x168 },
	'meterinfo1row6' => { 438 => 0x21c, 439 => 0x1c2 },
	'meterinfo1row7' => { 438 => 0x288, 439 => 0x21c },
	'meterinfo2row1' => { 438 => 0x2f4, 439 => 0x276 },
	'meterinfo2row2' => { 438 => 0x378, 439 => 0x2e4 },
	'meterinfo2row3' => { 438 => 0x3fc, 439 => 0x352 },
	'meterinfo2row4' => { 438 => 0x480, 439 => 0x3c0 },
	'meterinfo2row5' => { 438 => 0x504, 439 => 0x42e },
	'meterinfo2row6' => { 438 => 0x588, 439 => 0x49c },
	'meterinfo2row7' => { 438 => 0x60c, 439 => 0x50a },
	'meterinfo2row8' => { 438 => 0x690, 439 => 0x578 },
	'meterinfo2row9' => { 438 => 0x714, 439 => 0x5e6 },
	'metering' => { 298 => '6.1' },
	'meteringmode' => { 34 => 0x11, 119 => 0x9207, 140 => 0x1c, 181 => 0x7, 182 => 0x25, 184 => 0x12, 314 => 0x202, 372 => 0x17, 414 => 0x9, 424 => 0x15, 425 => 0x13, 426 => 0x7, 442 => 0x3, 446 => 0x1174, 447 => 0x1178, 448 => 0x1154, 449 => 0x11d0, 450 => 0x11ac, 451 => 0x1064, 452 => 0x25c, 453 => 0x25c, 454 => 0x24b, 502 => 'MeteringMode' },
	'meteringmode2' => { 353 => '2.1', 437 => 0x202c },
	'meteringmode3' => { 353 => '16.1' },
	'meteringoffscaleindicator' => { 184 => 0x53 },
	'meteringtime' => { 296 => '22.2', 298 => '3.2', 301 => '17.1', 302 => '18.1', 305 => '7.3', 306 => '18.1', 307 => '3.2', 311 => '19.1' },
	'micro1version' => { 399 => 0x1f },
	'micro2version' => { 399 => 0x2d },
	'microphoneattenuator' => { 239 => 0x2d2, 240 => 0x2fa, 241 => 0x2fa },
	'microphonefrequencyresponse' => { 239 => 0x2d4, 240 => 0x2fc, 241 => 0x2fc },
	'microphonejackpower' => { 239 => 0x2fa, 240 => 0x322, 241 => 0x322 },
	'microphonesensitivity' => { 239 => 0x2d0, 240 => 0x2f8, 241 => 0x2f8 },
	'microvideo' => { 479 => 'MicroVideo' },
	'microvideooffset' => { 479 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 479 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 479 => 'MicroVideoVersion' },
	'midrangesharpness' => { 250 => 0x3b },
	'mieversion' => { 164 => '0Vers' },
	'mime' => { 481 => 'Mime' },
	'minaperture' => { 34 => 0x1b, 138 => 0x3f8, 163 => 'MinAperture', 363 => '0.2' },
	'minaperturevalue' => { 381 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 34 => 0x18, 127 => 0x1404, 163 => 'MinFocalLength', 226 => 0x8, 227 => 0xd, 228 => 0xe, 232 => 0xf, 315 => 0x207, 450 => 0x127a, 451 => 0x1136, 452 => 0x32e, 453 => 0x32e, 454 => 0x30c },
	'minfocusdistance' => { 363 => 0x3 },
	'minimumiso' => { 337 => 0xe8 },
	'minintegrationrows' => { 138 => 0x1874 },
	'minoltadate' => { 181 => 0x15 },
	'minoltaimagesize' => { 181 => 0x4, 182 => 0xc, 183 => 0x2, 186 => 0x103 },
	'minoltamodelid' => { 181 => 0x25 },
	'minoltaquality' => { 181 => 0x5, 182 => 0xd, 183 => 0x3, 186 => [0x102,0x103] },
	'minoltatime' => { 181 => 0x16 },
	'minormodelagedisclosure' => { 324 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 487 => 'MinorVersion' },
	'minsamplevalue' => { 119 => 0x118 },
	'mirrorlockup' => { 82 => 0xc, 83 => 0xc, 84 => 0x60f, 85 => 0xb, 86 => 0xc, 87 => 0x6, 88 => 0x6, 89 => 0xc, 90 => 0x3 },
	'mobilecountrycode' => { 495 => 'mcc' },
	'mobilenetworkcode' => { 495 => 'mnc' },
	'moddate' => { 327 => 'modify-date', 512 => 'ModDate' },
	'modedialposition' => { 430 => 0x14 },
	'model' => { 98 => 0x6, 119 => 0x110, 156 => 'Model', 327 => 'Model', 342 => 0x110, 372 => 0x23f, 391 => 'model', 397 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 414 => 0x84, 481 => 'Model', 514 => 'model', 521 => 'Model' },
	'modelage' => { 510 => 'ModelAge' },
	'modelid' => { 313 => 0x0 },
	'modelingflash' => { 296 => '21.4', 297 => '31.1', 299 => '31.1', 300 => '31.1', 305 => '26.4', 306 => '30.2', 307 => '7.4', 308 => '30.1', 309 => '31.1', 310 => '31.1', 311 => '31.3', 312 => 0x5d },
	'modelreleaseid' => { 324 => 'ModelReleaseID' },
	'modelreleasestatus' => { 324 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 459 => 0x52, 460 => 0x46, 461 => 0x53 },
	'modeltiepoint' => { 119 => 0x8482 },
	'modeltransform' => { 119 => 0x85d8 },
	'modelyear' => { 514 => 'modelYear' },
	'modificationdate' => { 515 => 'modificationDate' },
	'modifiedcolortemp' => { 66 => 0x9 },
	'modifieddigitalgain' => { 66 => 0xb },
	'modifiedparamflag' => { 58 => 0x1 },
	'modifiedpicturestyle' => { 66 => 0xa },
	'modifiedsaturation' => { 314 => 0x504 },
	'modifiedsensorbluelevel' => { 66 => 0x5 },
	'modifiedsensorredlevel' => { 66 => 0x4 },
	'modifiedsharpness' => { 66 => 0x2 },
	'modifiedsharpnessfreq' => { 66 => 0x3 },
	'modifiedtonecurve' => { 66 => 0x1 },
	'modifiedwhitebalance' => { 66 => 0x8 },
	'modifiedwhitebalanceblue' => { 66 => 0x7 },
	'modifiedwhitebalancered' => { 66 => 0x6 },
	'modifydate' => { 119 => 0x132, 157 => 'ModifyDate', 323 => 'ModDate', 325 => 'tIME', 388 => 'ModDate', 394 => 0x2, 523 => 'ModifyDate' },
	'moirefilter' => { 119 => 0xfe58, 496 => 'MoireFilter', 498 => 'MoireFilter' },
	'monitorbrightness' => { 239 => 0x59a, 240 => 0x5ca, 241 => 0x5ca },
	'monitordisplayoff' => { 184 => 0x4c },
	'monitormatrix' => { 138 => 0x8fc },
	'monitorofftime' => { 296 => '18.2', 298 => '3.1', 307 => '3.1' },
	'monochromecolor' => { 314 => 0x53b },
	'monochromecontrast' => { 109 => 0x3c },
	'monochromefiltereffect' => { 103 => 0x20307, 109 => 0x3a, 337 => 0xac, 372 => 0x73 },
	'monochromegraineffect' => { 337 => 0xd2 },
	'monochromelinear' => { 109 => 0x3d },
	'monochromeoutputhighlightpoint' => { 109 => 0x41 },
	'monochromeoutputshadowpoint' => { 109 => 0x42 },
	'monochromeprofilesettings' => { 314 => 0x537 },
	'monochromerawhighlight' => { 109 => 0x7a },
	'monochromerawhighlightpoint' => { 109 => 0x3f },
	'monochromerawshadow' => { 109 => 0x83 },
	'monochromerawshadowpoint' => { 109 => 0x40 },
	'monochromesharpness' => { 109 => 0x3e },
	'monochrometoning' => { 372 => 0x74 },
	'monochrometoningeffect' => { 103 => 0x20306, 109 => 0x3b },
	'monochromeunsharpmaskfineness' => { 109 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 109 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 109 => 0xb4 },
	'monochromevignetting' => { 314 => 0x53a },
	'monthdaycreated' => { 140 => 0x12, 149 => 0xe },
	'mood' => { 179 => 'WM/Mood' },
	'moonphase' => { 398 => 0x12, 399 => 0x43, 400 => 0x4c },
	'morepermissions' => { 494 => 'morePermissions' },
	'motionphotovideo' => { 392 => 'mpvd' },
	'motionsensitivity' => { 398 => 0x29, 400 => 0x60 },
	'movementcount' => { 389 => "\xa9mvc" },
	'movementname' => { 389 => "\xa9mvn" },
	'movementnumber' => { 389 => "\xa9mvi" },
	'movieactived-lighting' => { 238 => 0x238, 239 => 0x2b8, 240 => 0x2e0, 241 => 0x2e0 },
	'movieaelockbuttonassignment' => { 309 => '40.1' },
	'movieaf-onbutton' => { 312 => 0xcb },
	'movieafareamode' => { 239 => 0x2c6, 240 => 0x2ee, 241 => 0x2ee, 312 => 0x203 },
	'movieafspeed' => { 312 => 0xdd },
	'movieafspeedapply' => { 312 => 0xdf },
	'movieaftrackingsensitivity' => { 312 => 0xe1 },
	'movieaperturelock' => { 312 => 0x259 },
	'movieautodistortioncontrol' => { 238 => 0x242 },
	'moviediffractioncompensation' => { 238 => 0x241 },
	'moviedxcropalert' => { 239 => 0x2fb, 240 => 0x323, 241 => 0x323 },
	'movieelectronicvr' => { 239 => 0x2cc, 240 => 0x2f4, 241 => 0x2f4 },
	'movieevfgrid' => { 312 => 0x21d },
	'movieflickerreduction' => { 239 => 0x2c0, 240 => 0x2e8, 241 => 0x2e8 },
	'moviefocusmode' => { 238 => 0x248, 239 => 0x2c4, 240 => 0x2ec, 241 => 0x2ec },
	'moviefocuspointlock' => { 312 => 0x226 },
	'movieframerate' => { 238 => 0x1f8, 239 => 0x2f4, 240 => 0x31c, 241 => 0x31c },
	'movieframesize' => { 238 => 0x1f6, 239 => 0x2f2, 240 => 0x31a, 241 => 0x31a },
	'moviefunc1button' => { 299 => '41.1', 300 => '41.1', 310 => '41.1', 312 => 0xc3 },
	'moviefunc2button' => { 312 => 0xc7 },
	'moviefunc3button' => { 312 => 0x127 },
	'moviefunctionbutton' => { 297 => '41.1', 309 => '41.1' },
	'moviefunctionbuttonplusdials' => { 297 => '52.1' },
	'moviehighisonoisereduction' => { 238 => 0x23c, 239 => 0x2ba, 240 => 0x2e2, 241 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 312 => 0x215 },
	'moviehighreszoom' => { 240 => 0x32c, 241 => 0x32c },
	'movieimagearea' => { 239 => 0x25c, 240 => 0x286, 241 => 0x286 },
	'movieisoautocontrolmanualmode' => { 239 => 0x26a, 240 => 0x294, 241 => 0x294 },
	'movieisoautohilimit' => { 239 => 0x268, 240 => 0x292, 241 => 0x292 },
	'movieisoautomanualmode' => { 238 => 0x204, 239 => 0x26c, 240 => 0x296, 241 => 0x296 },
	'movielenscontrolring' => { 312 => 0xd7 },
	'moviemeteringmode' => { 239 => 0x2c2, 240 => 0x2ea, 241 => 0x2ea },
	'moviemidtonedisplayrange' => { 312 => 0x219 },
	'moviemidtonedisplayvalue' => { 312 => 0x217 },
	'moviemultiselector' => { 312 => 0xd9 },
	'moviepreviewbutton' => { 297 => '41.2', 299 => '41.2', 300 => '41.2', 309 => '41.2', 310 => '41.2' },
	'moviepreviewbuttonplusdials' => { 297 => '52.2' },
	'movierecordbuttonplaybackmode' => { 312 => 0x1b5 },
	'movieshutterbutton' => { 297 => '38.3', 299 => '38.3', 300 => '38.3', 309 => '38.3', 310 => '38.3' },
	'movieshutterspeedlock' => { 312 => 0x225 },
	'movieslowmotion' => { 238 => 0x1fa },
	'moviesoundrecording' => { 239 => 0x2ce, 240 => 0x2f6, 241 => 0x2f6 },
	'moviesubjectdetection' => { 239 => 0x2fc, 240 => 0x324, 241 => 0x324 },
	'moviesubselectorassignment' => { 297 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 297 => '53.1' },
	'movietonemap' => { 239 => 0x2ec, 240 => 0x314, 241 => 0x314 },
	'movietype' => { 223 => 0x2ca, 238 => 0x1fe, 239 => 0x266, 240 => 0x290, 241 => 0x290 },
	'movievibrationreduction' => { 238 => 0x24e },
	'movievibrationreductionsameasphoto' => { 238 => 0x24f },
	'movievignettecontrol' => { 238 => 0x23e, 239 => 0x1a0, 240 => 0x1b4, 241 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 238 => 0x240 },
	'movievrmode' => { 239 => 0x2c8, 240 => 0x2f0, 241 => 0x2f0 },
	'moviezebrapattern' => { 312 => 0x213 },
	'multiburstimageheight' => { 437 => 0x1002 },
	'multiburstimagewidth' => { 437 => 0x1001 },
	'multiburstmode' => { 437 => 0x1000 },
	'multicontrollerwhilemetering' => { 84 => 0x517 },
	'multiexposure' => { 68 => 0x1, 337 => 0xb4 },
	'multiexposureautogain' => { 243 => 0x3 },
	'multiexposurecontrol' => { 68 => 0x2 },
	'multiexposuremode' => { 243 => 0x1, 244 => 0x1 },
	'multiexposureoverlaymode' => { 244 => 0x3 },
	'multiexposureshots' => { 68 => 0x3, 239 => 0x8e, 240 => 0x9c, 241 => 0x9c, 243 => 0x2, 244 => 0x2 },
	'multiframenoisereduction' => { 426 => 0x35, 437 => 0x200b, 442 => 0x15 },
	'multiframenreffect' => { 437 => 0x2023 },
	'multifunctionlock' => { 84 => 0x70f },
	'multipleexposuremode' => { 239 => 0x8c, 240 => 0x9a, 241 => 0x9a, 318 => 0x101c },
	'multipleexposureset' => { 353 => '10.1' },
	'multisample' => { 256 => 0x40 },
	'multiselector' => { 296 => '9.4', 297 => '10.3', 299 => '10.3', 300 => '10.3', 305 => '27.4', 309 => '10.3', 310 => '10.3' },
	'multiselectorliveview' => { 296 => '4.3', 299 => '37.1', 300 => '37.1', 309 => '37.1', 310 => '37.1' },
	'multiselectorliveviewmode' => { 270 => 0x18c2 },
	'multiselectorplaybackmode' => { 296 => ['13.5','9.2'], 297 => '10.2', 300 => '10.2', 305 => '27.2', 309 => '10.2', 310 => '10.2', 312 => 0xb3 },
	'multiselectorshootmode' => { 296 => '9.1', 297 => '10.1', 299 => '10.1', 300 => '10.1', 305 => '27.1', 309 => '10.1', 310 => '10.1', 312 => 0xaf },
	'multishot' => { 342 => 0x121 },
	'mute' => { 391 => 'player.movie.audio.mute' },
	'mycolormode' => { 69 => 0x2 },
	'name' => { 397 => 'name', 496 => 'Name', 498 => 'Name' },
	'narrator' => { 389 => "\xa9nrt" },
	'nationalcatalognumber' => { 515 => 'nationalCatalogNumber' },
	'nativedigest' => { 502 => 'NativeDigest', 521 => 'NativeDigest' },
	'ndfilter' => { 77 => 0x1c, 314 => 0x204, 404 => 0x1019 },
	'near' => { 481 => 'Near' },
	'nefbitdepth' => { 234 => 0xe22 },
	'nefcompression' => { 234 => 0x93, 235 => 0xa },
	'neflinearizationtable' => { 234 => 0x96 },
	'negativecachelargepreviewsize' => { 496 => 'NegativeCacheLargePreviewSize', 498 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 496 => 'NegativeCacheMaximumSize', 498 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 496 => 'NegativeCachePath', 498 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 493 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 372 => 0x88 },
	'neutraloutputhighlightpoint' => { 109 => 0x2f },
	'neutraloutputshadowpoint' => { 109 => 0x30 },
	'neutralrawcolortone' => { 109 => 0x28 },
	'neutralrawcontrast' => { 109 => 0x2a },
	'neutralrawhighlight' => { 109 => 0x78 },
	'neutralrawhighlightpoint' => { 109 => 0x2d },
	'neutralrawlinear' => { 109 => 0x2b },
	'neutralrawsaturation' => { 109 => 0x29 },
	'neutralrawshadow' => { 109 => 0x81 },
	'neutralrawshadowpoint' => { 109 => 0x2e },
	'neutralrawsharpness' => { 109 => 0x2c },
	'neutralunsharpmaskfineness' => { 109 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 109 => 0xa8 },
	'neutraunsharpmaskstrength' => { 109 => 0xa4 },
	'newlensdata' => { 232 => 0x2f },
	'newrawimagedigest' => { 119 => 0xc7a7 },
	'newsphotoversion' => { 133 => 0x0 },
	'nickname' => { 523 => 'Nickname' },
	'nikoncapturedata' => { 234 => 0xe01 },
	'nikoncaptureeditversions' => { 234 => 0xe13 },
	'nikoncaptureoffsets' => { 234 => 0xe0e },
	'nikoncaptureoutput' => { 234 => 0xe1e },
	'nikoncaptureversion' => { 234 => 0xe09 },
	'nikoniccprofile' => { 234 => 0xe1d },
	'nikonimagesize' => { 267 => '723.1', 268 => '732.1', 276 => 0x2c4 },
	'nikonmeteringmode' => { 199 => 0x17, 238 => 0x146, 247 => 0x214 },
	'nikonsettings' => { 234 => 0x4e },
	'noisefilter' => { 314 => 0x527 },
	'noiseprofile' => { 119 => 0xc761 },
	'noisereduction' => { 127 => [0x100b,0x100e], 182 => 0xb0, 183 => 0x60, 184 => 0x3f, 234 => 0x95, 289 => 0x753dcbc0, 290 => 0x17, 314 => 0x50a, 319 => 0x103a, 337 => 0x2d, 372 => 0x49, 404 => 0x100f, 406 => 0x2a },
	'noisereduction2' => { 318 => 0x1010 },
	'noisereductionapplied' => { 119 => 0xc6f7 },
	'noisereductionintensity' => { 290 => 0x9 },
	'noisereductionmethod' => { 290 => 0x11 },
	'noisereductionmode' => { 472 => 0x801e },
	'noisereductionparametersatcapture' => { 138 => 0xe73 },
	'noisereductionparameterscamera' => { 138 => 0xe72 },
	'noisereductionparametershost3mp' => { 138 => 0xe71 },
	'noisereductionparametershost6mp' => { 138 => 0xe70 },
	'noisereductionparametershostrgb' => { 138 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 138 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 138 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 138 => 0xe63 },
	'noisereductionparams' => { 342 => 0x1b },
	'noisereductionsharpness' => { 290 => 0xd },
	'noisereductionstrength' => { 337 => 0xd6 },
	'noisereductionvalue' => { 472 => 0x8027 },
	'nomemorycard' => { 296 => '22.1', 297 => '4.2', 298 => '0.3', 301 => '2.4', 302 => '3.2', 303 => '3.2', 305 => '33.7', 306 => '3.2', 307 => '0.3', 309 => '4.2', 311 => '4.5' },
	'nominalmaxaperture' => { 363 => 0xa },
	'nominalminaperture' => { 363 => '10.1' },
	'noncpulens10focallength' => { 241 => 0x620 },
	'noncpulens10maxaperture' => { 241 => 0x670 },
	'noncpulens11focallength' => { 241 => 0x624 },
	'noncpulens11maxaperture' => { 241 => 0x674 },
	'noncpulens12maxaperture' => { 241 => 0x678 },
	'noncpulens13focallength' => { 241 => 0x62c },
	'noncpulens13maxaperture' => { 241 => 0x67c },
	'noncpulens14focallength' => { 241 => 0x630 },
	'noncpulens14maxaperture' => { 241 => 0x680 },
	'noncpulens15focallength' => { 241 => 0x634 },
	'noncpulens15maxaperture' => { 241 => 0x684 },
	'noncpulens16focallength' => { 241 => 0x638 },
	'noncpulens16maxaperture' => { 241 => 0x688 },
	'noncpulens17focallength' => { 241 => 0x63c },
	'noncpulens17maxaperture' => { 241 => 0x68c },
	'noncpulens18focallength' => { 241 => 0x640 },
	'noncpulens18maxaperture' => { 241 => 0x690 },
	'noncpulens19focallength' => { 241 => 0x644 },
	'noncpulens19maxaperture' => { 241 => 0x694 },
	'noncpulens1focallength' => { 241 => 0x5fc },
	'noncpulens1maxaperture' => { 241 => 0x64c },
	'noncpulens20focallength' => { 241 => 0x648 },
	'noncpulens20maxaperture' => { 241 => 0x698 },
	'noncpulens21focallength' => { 241 => 0x628 },
	'noncpulens2focallength' => { 241 => 0x600 },
	'noncpulens2maxaperture' => { 241 => 0x650 },
	'noncpulens3focallength' => { 241 => 0x604 },
	'noncpulens3maxaperture' => { 241 => 0x654 },
	'noncpulens4focallength' => { 241 => 0x608 },
	'noncpulens4maxaperture' => { 241 => 0x658 },
	'noncpulens5focallength' => { 241 => 0x60c },
	'noncpulens5maxaperture' => { 241 => 0x65c },
	'noncpulens6focallength' => { 241 => 0x610 },
	'noncpulens6maxaperture' => { 241 => 0x660 },
	'noncpulens7focallength' => { 241 => 0x614 },
	'noncpulens7maxaperture' => { 241 => 0x664 },
	'noncpulens8focallength' => { 241 => 0x618 },
	'noncpulens8maxaperture' => { 241 => 0x668 },
	'noncpulens9focallength' => { 241 => 0x61c },
	'noncpulens9maxaperture' => { 241 => 0x66c },
	'normallinetime' => { 138 => 0x186a },
	'normalwhitelevel' => { 41 => 0x32a, 42 => 0x280, 45 => [0x2b8,0x2cf,0x2d3], 46 => 0x569, 47 => 0x1e3, 48 => [0x1fc,0x2dc], 49 => [0x230,0x30e], 50 => 0x31c },
	'notes' => { 473 => 'Notes', 491 => 'notes' },
	'npages' => { 530 => 'NPages' },
	'nullrecord' => { 97 => 0x0 },
	'numafpoints' => { 349 => 0x2 },
	'number' => { 515 => 'number' },
	'numberofbeats' => { 525 => 'numberOfBeats' },
	'numberoffocuspoints' => { 299 => '1.3', 300 => '1.3', 303 => '0.2', 304 => '0.3', 306 => '0.3' },
	'numfaceelements' => { 127 => 0x4200 },
	'numfacepositions' => { 329 => 0x0 },
	'numindexentries' => { 133 => 0x54 },
	'numwbentries' => { 343 => 0x0, 344 => 0x0 },
	'object' => { 515 => 'object' },
	'objectattributereference' => { 131 => 0x4 },
	'objectcycle' => { 131 => 0x4b, 491 => 'ObjectCycle' },
	'objectdescription' => { 514 => 'objectDescription' },
	'objectdistance' => { 112 => 0x6, 113 => 0x2022 },
	'objectname' => { 131 => 0x5 },
	'objectpreviewdata' => { 131 => 0xca },
	'objectpreviewfileformat' => { 131 => 0xc8 },
	'objectpreviewfileversion' => { 131 => 0xc9 },
	'objectsubtype' => { 514 => 'objectSubtype' },
	'objecttype' => { 514 => 'objectType' },
	'objecttypereference' => { 131 => 0x3 },
	'occurrence' => { 118 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 118 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 118 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 118 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 118 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 118 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 118 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 118 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 118 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 118 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 118 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 118 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 118 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 118 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 118 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 118 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 118 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 118 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 118 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 118 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 118 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 118 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 118 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 118 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 118 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 118 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 118 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 118 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 118 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 118 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 502 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 502 => [\'OECF','OECFNames'] },
	'oecfrows' => { 502 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 502 => [\'OECF','OECFValues'] },
	'offsaledate' => { 515 => 'offSaleDate' },
	'offsaledatea-platform' => { 515 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 515 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 138 => 0x190a },
	'offsethdr' => { 507 => 'OffsetHDR' },
	'offsetschema' => { 119 => 0xea1d },
	'offsetsdr' => { 507 => 'OffsetSDR' },
	'offsettime' => { 119 => 0x9010 },
	'offsettimedigitized' => { 119 => 0x9012 },
	'offsettimeoriginal' => { 119 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 306 => '15.1', 311 => '16.1' },
	'oldsubfiletype' => { 119 => 0xff },
	'olympusimageheight' => { 319 => 0x102f },
	'olympusimagewidth' => { 319 => 0x102e },
	'omenatcapturestrength' => { 138 => 0xa60 },
	'omenautostrength' => { 138 => 0xa5f },
	'omenearlystrength' => { 138 => 0xa5e },
	'omenfocallengthlimit' => { 138 => 0xa62 },
	'omeninitialipfstrength' => { 138 => 0xa5d },
	'omensurfaceindex' => { 138 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 319 => 0x302 },
	'onsaledate' => { 515 => 'onSaleDate' },
	'onsaledatea-platform' => { 515 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 515 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 515 => 'onSaleDay' },
	'onsaledaya-platform' => { 515 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 515 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 119 => 0xc740 },
	'opcodelist2' => { 119 => 0xc741 },
	'opcodelist3' => { 119 => 0xc74e },
	'opticalzoom' => { 142 => 0xfa3d, 144 => [0x6006,0xf006], 145 => 0x1000, 146 => 0xf, 149 => 0x1e, 151 => 0x20, 152 => 0x1c, 163 => 'OpticalZoom' },
	'opticalzoomcode' => { 77 => 0xa },
	'opticalzoommode' => { 337 => 0x34 },
	'opticalzoomon' => { 413 => 0x219 },
	'optionenddate' => { 518 => 'optionEndDate' },
	'opto-electricconvfactor' => { 502 => 'OECF' },
	'orangehsl' => { 103 => 0x20911 },
	'ordernumber' => { 127 => 0x8002 },
	'organisationinimagecode' => { 510 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 510 => 'OrganisationInImageName' },
	'organism' => { 118 => 'Organism' },
	'organismassociatedoccurrences' => { 118 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 118 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 118 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 118 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 118 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 118 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 118 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 515 => 'organization' },
	'orientation' => { 119 => 0x112, 342 => 0x112, 514 => 'orientation', 521 => 'Orientation' },
	'orientation2' => { 442 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 84 => 0x516 },
	'originalalbumtitle' => { 179 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 179 => 'WM/OriginalArtist', 389 => "\xa9ope" },
	'originalbestqualitysize' => { 119 => 0xc792 },
	'originalcreatedatetime' => { 486 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 114 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 64 => 0x83 },
	'originaldefaultcropsize' => { 119 => 0xc793 },
	'originaldefaultfinalsize' => { 119 => 0xc791 },
	'originaldirectory' => { 334 => 0x408 },
	'originaldocumentid' => { 526 => 'OriginalDocumentID' },
	'originalfilename' => { 97 => 0x816, 138 => 0x3e9, 150 => 0x20, 334 => 0x407, 486 => 'OriginalFilename' },
	'originalimagehash' => { 476 => 'OriginalImageHash' },
	'originalimagehashtype' => { 476 => 'OriginalImageHashType' },
	'originalimageheight' => { 79 => 0xc, 123 => 0x1 },
	'originalimagemd5' => { 476 => 'OriginalImageMD5' },
	'originalimagesize' => { 162 => 'OriginalImageSize' },
	'originalimagewidth' => { 79 => 0xb, 123 => 0x0 },
	'originallyricist' => { 179 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 119 => 0xc68c },
	'originalrawfiledigest' => { 119 => 0xc71d },
	'originalrawfilename' => { 119 => 0xc68b },
	'originaltransmissionreference' => { 131 => 0x67 },
	'originatingprogram' => { 131 => 0x41, 491 => 'OriginatingProgram' },
	'originplatform' => { 515 => 'originPlatform' },
	'os' => { 500 => 'os' },
	'otherconditions' => { 324 => 'OtherConditions' },
	'otherconstraints' => { 324 => 'OtherConstraints' },
	'otherimage' => { 114 => 'Exif-OtherImage' },
	'otherimageinfo' => { 324 => 'OtherImageInfo' },
	'otherimagelength' => { 119 => 0x202 },
	'otherimagestart' => { 119 => 0x201 },
	'otherlicensedocuments' => { 324 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 324 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 324 => 'OtherLicenseRequirements' },
	'outcue' => { 525 => 'outCue' },
	'outcuescale' => { 525 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 525 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 200 => 0x3 },
	'outputimagewidth' => { 200 => 0x2 },
	'outputlut' => { 337 => 0xa7 },
	'outputprofile' => { 138 => 0x138b },
	'outputresolution' => { 200 => 0x4 },
	'overclockcols' => { 138 => 0x189c },
	'overclockrows' => { 138 => 0x18c4 },
	'overridelookvignette' => { 496 => 'OverrideLookVignette', 498 => 'OverrideLookVignette' },
	'owner' => { 529 => 'Owner' },
	'ownerid' => { 131 => 0xbc },
	'ownername' => { 15 => 0x10f, 64 => 0x9, 97 => 0x810, 119 => [0xa430,0xfde8], 156 => 'OwnerName', 493 => 'OwnerName', 503 => 'CameraOwnerName' },
	'padding' => { 119 => 0xea1c },
	'pagecount' => { 515 => 'pageCount' },
	'pageimage' => { 523 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 523 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 523 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 523 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 523 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 523 => 'PageInfo' },
	'pagename' => { 119 => 0x11d },
	'pagenumber' => { 119 => 0x129 },
	'pageprogressiondirection' => { 515 => 'pageProgressionDirection' },
	'pagerange' => { 515 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 496 => 'PaintBasedCorrections', 498 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 498 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 340 => 0x0 },
	'panasonicexifversion' => { 337 => 0x26 },
	'panasonicimageheight' => { 337 => 0x4c },
	'panasonicimagewidth' => { 337 => 0x4b },
	'panasonicrawversion' => { 342 => 0x1 },
	'panasonictitle' => { 119 => 0xc6d2 },
	'panasonictitle2' => { 119 => 0xc6d3 },
	'panoramaangle' => { 127 => 0x1153 },
	'panoramacropbottom' => { 443 => 0x7 },
	'panoramacropleft' => { 443 => 0x4 },
	'panoramacropright' => { 443 => 0x6 },
	'panoramacroptop' => { 443 => 0x5 },
	'panoramadirection' => { 72 => 0x5, 127 => 0x1154, 443 => 0x3 },
	'panoramaframeheight' => { 443 => 0x9 },
	'panoramaframenumber' => { 72 => 0x2 },
	'panoramaframewidth' => { 443 => 0x8 },
	'panoramafullheight' => { 443 => 0x2 },
	'panoramafullwidth' => { 443 => 0x1 },
	'panoramamode' => { 140 => 0x3c, 314 => 0x601 },
	'panoramasize3d' => { 426 => 0x38 },
	'panoramasourceheight' => { 443 => 0xb },
	'panoramasourcewidth' => { 443 => 0xa },
	'panoramicstitchcameramotion' => { 176 => 'PanoramicStitchCameraMotion', 177 => 0x1 },
	'panoramicstitchmaptype' => { 176 => 'PanoramicStitchMapType', 177 => 0x2 },
	'panoramicstitchphi0' => { 176 => 'PanoramicStitchPhi0', 177 => 0x5 },
	'panoramicstitchphi1' => { 176 => 'PanoramicStitchPhi1', 177 => 0x6 },
	'panoramicstitchtheta0' => { 176 => 'PanoramicStitchTheta0', 177 => 0x3 },
	'panoramicstitchtheta1' => { 176 => 'PanoramicStitchTheta1', 177 => 0x4 },
	'panoramicstitchversion' => { 177 => 0x0 },
	'pantry' => { 526 => 'Pantry' },
	'pantryinstanceid' => { 526 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 127 => 0xb211, 313 => 0x28 },
	'parametricdarks' => { 496 => 'ParametricDarks', 498 => 'ParametricDarks' },
	'parametrichighlights' => { 496 => 'ParametricHighlights', 498 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 496 => 'ParametricHighlightSplit', 498 => 'ParametricHighlightSplit' },
	'parametriclights' => { 496 => 'ParametricLights', 498 => 'ParametricLights' },
	'parametricmidtonesplit' => { 496 => 'ParametricMidtoneSplit', 498 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 496 => 'ParametricShadows', 498 => 'ParametricShadows' },
	'parametricshadowsplit' => { 496 => 'ParametricShadowSplit', 498 => 'ParametricShadowSplit' },
	'parentalrating' => { 179 => 'WM/ParentalRating' },
	'parentid' => { 510 => 'parentId' },
	'parentmediaeventid' => { 486 => 'ParentMediaEventID' },
	'parentmeid' => { 486 => 'ParentMEID' },
	'parentproductid' => { 389 => '@ppi' },
	'parentreference1' => { 508 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 508 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 508 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 508 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 508 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 508 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 389 => '@PST' },
	'parenttitle' => { 389 => '@pti' },
	'partialactivecols1' => { 138 => 0x17e8 },
	'partialactivecols2' => { 138 => 0x17f2 },
	'partialactiverows1' => { 138 => 0x17fc },
	'partialactiverows2' => { 138 => 0x1806 },
	'partofcompilation' => { 525 => 'partOfCompilation' },
	'patientbirthdate' => { 474 => 'PatientDOB' },
	'patientid' => { 474 => 'PatientID' },
	'patientname' => { 474 => 'PatientName' },
	'patientsex' => { 474 => 'PatientSex' },
	'patternareaheight' => { 138 => 0x963 },
	'patternareawidth' => { 138 => 0x962 },
	'patterncorrectionfactorscale' => { 138 => 0x969 },
	'patterncropcols1' => { 138 => 0x96c },
	'patterncropcols2' => { 138 => 0x96d },
	'patterncroprows1' => { 138 => 0x96a },
	'patterncroprows2' => { 138 => 0x96b },
	'patternimagerheight' => { 138 => 0x961 },
	'patternimagerwidth' => { 138 => 0x960 },
	'patternx' => { 138 => 0x966 },
	'patterny' => { 138 => 0x967 },
	'pdfversion' => { 512 => 'PDFVersion' },
	'pentaximagesize' => { 372 => 0x9 },
	'pentaxmodelid' => { 352 => 0x0, 372 => 0x5 },
	'pentaxmodeltype' => { 372 => 0x1 },
	'pentaxversion' => { 372 => 0x0 },
	'people' => { 477 => 'People', 489 => 'People' },
	'perchannelblacklevel' => { 41 => 0x157, 42 => 0x16b, 44 => 0xc4, 45 => [0x2b4,0x2cb,0x2cf], 46 => [0x108,0x14d], 47 => 0x1df, 48 => [0x1f8,0x2d8], 49 => [0x22c,0x30a], 50 => 0x149 },
	'performer' => { 389 => 'perf', 397 => 'perf' },
	'performerkeywords' => { 397 => "\xa9prk" },
	'performers' => { 397 => "\xa9prf" },
	'performerurl' => { 397 => "\xa9prl" },
	'period' => { 179 => 'WM/Period' },
	'peripheralillumcentralradius' => { 472 => 0x8030 },
	'peripheralillumcentralvalue' => { 472 => 0x8031 },
	'peripheralillumination' => { 103 => 0x20702, 109 => 0x68 },
	'peripheralilluminationcorr' => { 62 => 0x1, 362 => 0x2 },
	'peripheralilluminationon' => { 103 => '0x20702.0', 109 => 0x64 },
	'peripheralillumperiphvalue' => { 472 => 0x8032 },
	'peripherallighting' => { 79 => 0x2, 127 => 0x3804 },
	'peripherallightingsetting' => { 80 => 0x5 },
	'peripherallightingvalue' => { 79 => 0x6 },
	'permissions' => { 518 => 'permissions' },
	'permits' => { 494 => 'permits' },
	'person' => { 515 => 'person' },
	'personality' => { 486 => 'Personality' },
	'personheard' => { 510 => 'PersonHeard' },
	'personheardidentifier' => { 510 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 510 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 510 => 'PersonInImage' },
	'personinimagecharacteristic' => { 510 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 510 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 510 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 510 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 510 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 510 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 510 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 510 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 510 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 496 => 'PerspectiveAspect', 498 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 496 => 'PerspectiveHorizontal', 498 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 496 => 'PerspectiveRotate', 498 => 'PerspectiveRotate' },
	'perspectivescale' => { 496 => 'PerspectiveScale', 498 => 'PerspectiveScale' },
	'perspectiveupright' => { 496 => 'PerspectiveUpright', 498 => 'PerspectiveUpright' },
	'perspectivevertical' => { 496 => 'PerspectiveVertical', 498 => 'PerspectiveVertical' },
	'perspectivex' => { 496 => 'PerspectiveX', 498 => 'PerspectiveX' },
	'perspectivey' => { 496 => 'PerspectiveY', 498 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 92 => 0x1 },
	'pf10retainprogramshift' => { 92 => 0xb },
	'pf13drivepriority' => { 92 => 0xe },
	'pf14disablefocussearch' => { 92 => 0xf },
	'pf15disableafassistbeam' => { 92 => 0x10 },
	'pf16autofocuspointshoot' => { 92 => 0x11 },
	'pf17disableafpointsel' => { 92 => 0x12 },
	'pf18enableautoafpointsel' => { 92 => 0x13 },
	'pf19continuousshootspeed' => { 92 => 0x14 },
	'pf19shootingspeedhigh' => { 91 => 0xa },
	'pf19shootingspeedlow' => { 91 => 0x9 },
	'pf1disableshootingmodes' => { 92 => 0x2 },
	'pf1value' => { 91 => 0x1 },
	'pf20limitcontinousshots' => { 92 => 0x15 },
	'pf20maxcontinousshots' => { 91 => 0xb },
	'pf21enablequietoperation' => { 92 => 0x16 },
	'pf23felocktime' => { 91 => 0xd },
	'pf23postreleasetime' => { 91 => 0xe },
	'pf23settimerlengths' => { 92 => 0x18 },
	'pf23shutterbuttontime' => { 91 => 0xc },
	'pf24lightlcdduringbulb' => { 92 => 0x19 },
	'pf25aemode' => { 91 => 0xf },
	'pf25afmode' => { 91 => 0x12 },
	'pf25afpointsel' => { 91 => 0x13 },
	'pf25colormatrix' => { 91 => 0x17 },
	'pf25defaultclearsettings' => { 92 => 0x1a },
	'pf25drivemode' => { 91 => 0x11 },
	'pf25imagesize' => { 91 => 0x14 },
	'pf25meteringmode' => { 91 => 0x10 },
	'pf25parameters' => { 91 => 0x16 },
	'pf25wbmode' => { 91 => 0x15 },
	'pf26shortenreleaselag' => { 92 => 0x1b },
	'pf27reversedialrotation' => { 92 => 0x1c },
	'pf27value' => { 91 => 0x18 },
	'pf28noquickdialexpcomp' => { 92 => 0x1d },
	'pf29quickdialswitchoff' => { 92 => 0x1e },
	'pf2disablemeteringmodes' => { 92 => 0x3 },
	'pf2value' => { 91 => 0x2 },
	'pf30enlargementmode' => { 92 => 0x1f },
	'pf31originaldecisiondata' => { 92 => 0x20 },
	'pf3manualexposuremetering' => { 92 => 0x4 },
	'pf3value' => { 91 => 0x3 },
	'pf4exposuretimelimits' => { 92 => 0x5 },
	'pf4exposuretimemax' => { 91 => 0x5 },
	'pf4exposuretimemin' => { 91 => 0x4 },
	'pf5aperturelimits' => { 92 => 0x6 },
	'pf5aperturemax' => { 91 => 0x7 },
	'pf5aperturemin' => { 91 => 0x6 },
	'pf6presetshootingmodes' => { 92 => 0x7 },
	'pf7bracketcontinuousshoot' => { 92 => 0x8 },
	'pf8bracketshots' => { 91 => 0x8 },
	'pf8setbracketshots' => { 92 => 0x9 },
	'pf9changebracketsequence' => { 92 => 0xa },
	'phasedetectaf' => { 193 => 0x6 },
	'phonenumber' => { 157 => 'Phone' },
	'photoeffect' => { 34 => 0x28 },
	'photoeffecthistoryxml' => { 289 => 0xe9651831 },
	'photoeffects' => { 289 => 0xab5eca5e },
	'photoeffectsblue' => { 291 => 0x8 },
	'photoeffectsgreen' => { 291 => 0x6 },
	'photoeffectsred' => { 291 => 0x4 },
	'photoeffectstype' => { 291 => 0x0 },
	'photographer' => { 119 => 0xa437 },
	'photographicsensitivity' => { 503 => 'PhotographicSensitivity' },
	'photoidentifier' => { 1 => 0x2b },
	'photoinfoplayback' => { 296 => '17.6', 305 => '33.6' },
	'photometricinterpretation' => { 119 => 0x106, 521 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 239 => 0x112, 240 => 0x122, 241 => 0x122, 242 => 0x24, 260 => 0x0 },
	'photoshootingmenubankimagearea' => { 237 => 0x6dd, 239 => 0x134, 240 => 0x148, 241 => 0x148, 260 => '7.1' },
	'photoshopbgrthumbnail' => { 386 => 0x409 },
	'photoshopquality' => { 385 => 0x0 },
	'photoshopthumbnail' => { 386 => 0x40c },
	'photostyle' => { 337 => 0x89 },
	'picasawebgphotoid' => { 501 => 'picasawebGPhotoId' },
	'picklabel' => { 501 => 'PickLabel' },
	'pictinfo' => { 413 => 0x208 },
	'picturecontrol' => { 289 => 0xe2173c47 },
	'picturecontrolactive' => { 292 => 0x0 },
	'picturecontroladjust' => { 248 => 0x30, 249 => 0x30, 250 => 0x36 },
	'picturecontrolbase' => { 248 => 0x18, 249 => 0x18, 250 => 0x1c },
	'picturecontroldata' => { 234 => [0xbd,0x23] },
	'picturecontrolmode' => { 292 => 0x13 },
	'picturecontrolname' => { 248 => 0x4, 249 => 0x4, 250 => 0x8 },
	'picturecontrolquickadjust' => { 248 => 0x31, 249 => 0x31, 250 => 0x37 },
	'pictureeffect' => { 437 => 0x200e },
	'pictureeffect2' => { 446 => 0x1163, 447 => 0x1167, 448 => 0x1143, 449 => 0x11bf, 450 => 0x119b, 451 => 0x1053, 452 => 0x24b, 453 => 0x24b, 454 => 0x23c, 468 => 0x46 },
	'picturefinish' => { 182 => 0x71 },
	'picturemode' => { 127 => 0x1031, 314 => 0x520, 372 => [0xb,0x33], 414 => 0x3d },
	'picturemode2' => { 353 => 0x0 },
	'picturemodebwfilter' => { 314 => 0x525 },
	'picturemodecontrast' => { 314 => 0x523 },
	'picturemodeeffect' => { 314 => 0x52d },
	'picturemodehue' => { 314 => 0x522 },
	'picturemodesaturation' => { 314 => 0x521 },
	'picturemodesharpness' => { 314 => 0x524 },
	'picturemodetone' => { 314 => 0x526 },
	'pictureprofile' => { 446 => [0x115e,0x115f], 447 => [0x1162,0x1163], 448 => [0x113e,0x113f], 449 => [0x11ba,0x11bb], 450 => [0x1196,0x1197], 451 => [0x104e,0x104f], 452 => [0x246,0x247], 453 => [0x246,0x247], 454 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 74 => 0xa, 103 => 0x20301, 109 => 0x2 },
	'picturestylepc' => { 64 => 0x4009 },
	'picturestyleuserdef' => { 64 => 0x4008 },
	'picturewizard' => { 411 => 0x21 },
	'picturewizardcolor' => { 410 => 0x1 },
	'picturewizardcontrast' => { 410 => 0x4 },
	'picturewizardmode' => { 410 => 0x0 },
	'picturewizardsaturation' => { 410 => 0x2 },
	'picturewizardsharpness' => { 410 => 0x3 },
	'pipelineversion' => { 176 => 'PipelineVersion' },
	'pitch' => { 115 => 0x6, 297 => '4.1', 309 => '4.1', 397 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 246 => 0x4, 314 => 0x904, 337 => 0x91, 371 => 0x2, 409 => 0x1 },
	'pitchshift' => { 391 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 390 => 'pasp' },
	'pixelclockfrequency' => { 138 => 0x40b },
	'pixelcorrectionoffset' => { 138 => 0x972 },
	'pixelcorrectionscale' => { 138 => 0x971 },
	'pixelscale' => { 119 => 0x830e },
	'pixelshiftinfo' => { 437 => 0x202f },
	'pixelshiftoffset' => { 127 => 0x1106 },
	'pixelshiftresolution' => { 373 => 0x0 },
	'pixelshiftshots' => { 127 => 0x1105 },
	'pixelsperunitx' => { 326 => 0x0 },
	'pixelsperunity' => { 326 => 0x4 },
	'pixelunits' => { 326 => 0x8 },
	'planarconfiguration' => { 119 => 0x11c, 521 => 'PlanarConfiguration' },
	'plane' => { 475 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 475 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 475 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 475 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 475 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 475 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 475 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 475 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 475 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 475 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 475 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 475 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 475 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 475 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 475 => 'Planes' },
	'planningref' => { 510 => 'PlanningRef' },
	'planningrefidentifier' => { 510 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 510 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 510 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 530 => 'PlateNames' },
	'platform' => { 515 => 'platform' },
	'playallframes' => { 397 => 'AllF' },
	'playbackbutton' => { 241 => 0x808 },
	'playbackbuttonplaybackmode' => { 241 => 0x814 },
	'playbackflickdown' => { 312 => 0x159 },
	'playbackflickup' => { 312 => 0x155 },
	'playbackmenustime' => { 301 => '20.1', 302 => '21.1', 303 => '21.1' },
	'playbackmonitorofftime' => { 296 => '25.2', 297 => '36.1', 299 => '36.1', 300 => '36.1', 304 => '35.1', 305 => '8.1', 306 => '35.1', 309 => '36.1', 310 => '36.1', 311 => '21.1', 312 => 0x33 },
	'playbackzoom' => { 297 => '37.1' },
	'playdisplay' => { 184 => 0x4e },
	'playerversion' => { 391 => 'player.version' },
	'playgap' => { 389 => 'pgap' },
	'playlistid' => { 389 => 'plID' },
	'playmode' => { 397 => 'SDLN' },
	'playselection' => { 397 => 'SelO' },
	'plusversion' => { 324 => 'Version' },
	'pmversion' => { 384 => 'PMVersion' },
	'pngwarning' => { 327 => 'Warning' },
	'podcast' => { 389 => 'pcst' },
	'podcasturl' => { 389 => 'purl' },
	'poilevel' => { 233 => 0x8 },
	'portraitimpressionbalance' => { 251 => 0xa0 },
	'portraitnote' => { 479 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 109 => 0x1d },
	'portraitoutputshadowpoint' => { 109 => 0x1e },
	'portraitrawcolortone' => { 109 => 0x16 },
	'portraitrawcontrast' => { 109 => 0x18 },
	'portraitrawhighlight' => { 109 => 0x76 },
	'portraitrawhighlightpoint' => { 109 => 0x1b },
	'portraitrawlinear' => { 109 => 0x19 },
	'portraitrawsaturation' => { 109 => 0x17 },
	'portraitrawshadow' => { 109 => 0x7f },
	'portraitrawshadowpoint' => { 109 => 0x1c },
	'portraitrawsharpness' => { 109 => 0x1a },
	'portraitrefiner' => { 113 => 0x302b },
	'portraitrequest' => { 479 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 109 => 0x9a },
	'portraitunsharpmaskstrength' => { 109 => 0x98 },
	'portraitunsharpmaskthreshold' => { 109 => 0x9c },
	'portraitversion' => { 479 => 'PortraitVersion' },
	'pose' => { 475 => 'Pose' },
	'poseheadingdegrees' => { 484 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 484 => 'PosePitchDegrees' },
	'posepositionx' => { 475 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 475 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 475 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 484 => 'PoseRollDegrees' },
	'poserotationw' => { 475 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 475 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 475 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 475 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 475 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 514 => 'positionDescriptor' },
	'postalcode' => { 161 => 'PostalCode' },
	'postcropvignetteamount' => { 496 => 'PostCropVignetteAmount', 498 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 496 => 'PostCropVignetteFeather', 498 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 496 => 'PostCropVignetteHighlightContrast', 498 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 496 => 'PostCropVignetteMidpoint', 498 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 496 => 'PostCropVignetteRoundness', 498 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 496 => 'PostCropVignetteStyle', 498 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 337 => 0xbf },
	'postreleaseburstlength' => { 240 => 0x714, 241 => 0x784 },
	'potentialface1position' => { 434 => 0xb },
	'potentialface2position' => { 434 => 0x15 },
	'potentialface3position' => { 434 => 0x1f },
	'potentialface4position' => { 434 => 0x29 },
	'potentialface5position' => { 434 => 0x33 },
	'potentialface6position' => { 434 => 0x3d },
	'potentialface7position' => { 434 => 0x47 },
	'potentialface8position' => { 434 => 0x51 },
	'powersource' => { 351 => '0.1' },
	'poweruptime' => { 234 => 0xb6 },
	'preaf' => { 126 => '0.2' },
	'precaptureframes' => { 319 => 0x300 },
	'predictor' => { 119 => 0x13d },
	'preflashreturnstrength' => { 268 => 0x28a },
	'prefs' => { 131 => 0xdd, 384 => 'Prefs' },
	'prereadfastresetcount' => { 138 => 0x187e },
	'prereleaseburstlength' => { 240 => 0x712, 241 => 0x782 },
	'preservedfilename' => { 526 => 'PreservedFileName' },
	'preservedspecimen' => { 118 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 118 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 496 => 'PresetType', 498 => 'PresetType' },
	'presetwhitebalance' => { 184 => 0x24, 472 => 0x8002 },
	'presetwhitebalanceadj' => { 472 => 0x8014 },
	'pressure' => { 119 => 0x9402, 503 => 'Pressure' },
	'previewapplicationname' => { 119 => 0xc716 },
	'previewapplicationversion' => { 119 => 0xc717 },
	'previewbutton' => { 296 => ['14.1','15.1'], 297 => '15.1', 299 => '15.1', 300 => '15.1', 305 => '29.1', 306 => '14.1', 309 => '15.1', 310 => '15.1' },
	'previewbuttonplusdials' => { 296 => ['14.2','15.2'], 297 => '15.2', 299 => '43.1', 300 => '43.1', 305 => '31.2', 309 => '43.1', 310 => '43.1' },
	'previewcolorspace' => { 119 => 0xc71a },
	'previewcropbottom' => { 383 => 0xef },
	'previewcropleft' => { 383 => 0xec },
	'previewcropright' => { 383 => 0xee },
	'previewcroptop' => { 383 => 0xed },
	'previewdate' => { 395 => 0x0 },
	'previewdatetime' => { 119 => 0xc71b },
	'previewimage' => { 113 => 0x2000, 114 => 'Exif-PreviewImage', 120 => 'PreviewImage', 122 => 0x4, 166 => 'data', 186 => 0x81, 319 => 0x280, 335 => 0x300, 397 => 'mcvr', 437 => 0x2001 },
	'previewimageborders' => { 372 => 0x3e },
	'previewimageheight' => { 73 => 0x4, 142 => 0xfa58 },
	'previewimagelength' => { 73 => 0x2, 113 => 0x3, 119 => [0x117,0x202], 186 => 0x89, 252 => 0x202, 314 => 0x102, 319 => 0x1037, 372 => 0x3, 403 => 0x1e, 408 => 0x3, 414 => [0x1b,0x1d], 427 => 0x202 },
	'previewimagename' => { 166 => '1Name' },
	'previewimagesize' => { 113 => 0x2, 147 => 0x2, 166 => 'ImageSize', 372 => 0x2, 414 => [0x1c,0x1e], 437 => 0xb02c, 472 => 0x9012 },
	'previewimagestart' => { 73 => 0x5, 113 => 0x4, 119 => [0x111,0x201], 186 => 0x88, 252 => 0x201, 314 => 0x101, 319 => 0x1036, 372 => 0x4, 403 => 0x1c, 408 => 0x2, 414 => [0x1a,0x1c], 427 => 0x201 },
	'previewimagetype' => { 166 => '0Type' },
	'previewimagevalid' => { 314 => 0x100, 319 => 0x1035 },
	'previewimagewidth' => { 73 => 0x3, 142 => 0xfa57 },
	'previewquality' => { 73 => 0x1 },
	'previewsettingsdigest' => { 119 => 0xc719 },
	'previewsettingsname' => { 119 => 0xc718 },
	'primaryafpoint' => { 193 => [0x38,0x44,0x7,0x8] },
	'primarychromaticities' => { 119 => 0x13f, 521 => 'PrimaryChromaticities' },
	'primaryftp' => { 486 => 'PrimaryFTP' },
	'primaryslot' => { 242 => 0x25, 260 => 0x2 },
	'printim' => { 119 => 0xc4a5 },
	'prioritysetinawb' => { 437 => 0x202b },
	'prioritysetupshutterrelease' => { 184 => 0x1d, 424 => 0x28 },
	'privatertkinfo' => { 488 => 'privateRTKInfo' },
	'processbordercolsleft' => { 138 => 0xc61 },
	'processbordercolsright' => { 138 => 0xc62 },
	'processborderrowsbottom' => { 138 => 0xc64 },
	'processborderrowstop' => { 138 => 0xc63 },
	'processingsoftware' => { 119 => 0xb },
	'processversion' => { 496 => 'ProcessVersion', 498 => 'ProcessVersion' },
	'producer' => { 179 => 'WM/Producer', 323 => 'Producer', 389 => "\xa9prd", 391 => 'producer', 397 => "\xa9prd", 512 => 'Producer' },
	'producerkeywords' => { 397 => "\xa9pdk" },
	'productcode' => { 515 => 'productCode' },
	'productid' => { 132 => 0x32, 389 => 'prID', 514 => 'productID' },
	'productidtype' => { 514 => 'productIDType' },
	'productinimage' => { 510 => 'ProductInImage' },
	'productinimagedescription' => { 510 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 510 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 510 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 510 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 352 => 0x2 },
	'productorserviceconstraints' => { 324 => 'ProductOrServiceConstraints' },
	'productversion' => { 389 => 'VERS' },
	'profession' => { 515 => 'profession' },
	'profile' => { 475 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 119 => 0xc6f4 },
	'profilecameraindices' => { 475 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 119 => 0xc6fe },
	'profileembedpolicy' => { 119 => 0xc6fd },
	'profilegaintablemap' => { 119 => 0xcd2d },
	'profilehuesatmapdata1' => { 119 => 0xc6fa },
	'profilehuesatmapdata2' => { 119 => 0xc6fb },
	'profilehuesatmapdata3' => { 119 => 0xcd39 },
	'profilehuesatmapdims' => { 119 => 0xc6f9 },
	'profilehuesatmapencoding' => { 119 => 0xc7a3 },
	'profilelooktabledata' => { 119 => 0xc726 },
	'profilelooktabledims' => { 119 => 0xc725 },
	'profilelooktableencoding' => { 119 => 0xc7a4 },
	'profilename' => { 119 => 0xc6f8, 325 => 'iCCP-name' },
	'profiles' => { 475 => 'Profiles' },
	'profiletonecurve' => { 119 => 0xc6fc },
	'profiletype' => { 475 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 337 => 0x3c },
	'programline' => { 353 => '1.1' },
	'programmode' => { 189 => 0x5 },
	'programshift' => { 234 => 0xd },
	'programversion' => { 131 => 0x46 },
	'prohibits' => { 494 => 'prohibits' },
	'projectiontype' => { 484 => 'ProjectionType', 485 => 'ProjectionType' },
	'projectname' => { 525 => 'projectName' },
	'projectref' => { 525 => 'projectRef' },
	'projectrefpath' => { 525 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 525 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 179 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 324 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 324 => 'PropertyReleaseStatus' },
	'provider' => { 179 => 'WM/Provider' },
	'province-state' => { 131 => 0x5f },
	'publicationdate' => { 515 => 'publicationDate' },
	'publicationdatea-platform' => { 515 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 515 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 515 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 515 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 515 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 510 => 'PublicationEvent' },
	'publicationeventdate' => { 510 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 510 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 510 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 515 => 'publicationName' },
	'publisher' => { 179 => 'WM/Publisher', 389 => "\xa9pub", 391 => 'publisher', 499 => 'publisher' },
	'publishingfrequency' => { 515 => 'publishingFrequency' },
	'pulldown' => { 525 => 'pullDown' },
	'purchasedate' => { 389 => 'purd' },
	'purplehsl' => { 103 => 0x20916 },
	'pxshiftperiphedgenr' => { 472 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 472 => 0x9014 },
	'quality' => { 0 => 0x1, 34 => 0x3, 112 => 0x2, 113 => 0x3002, 127 => 0x1000, 140 => 0x9, 234 => 0x4, 279 => 0x3, 319 => 0x201, 332 => 0x300, 372 => 0x8, 379 => 0x2, 414 => 0x16, 424 => 0x56, 425 => 0x56, 426 => 0xb, 437 => [0x102,0x202e] },
	'quality2' => { 446 => 0x1170, 447 => 0x1174, 448 => 0x1150, 450 => 0x11a8, 451 => 0x1060, 452 => 0x258, 453 => 0x258, 454 => 0x247, 459 => 0x29, 460 => 0x25, 461 => 0x2a },
	'qualitybutton' => { 312 => 0x17d },
	'qualitybuttonplaybackmode' => { 312 => 0x1bf },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 113 => 0x8 },
	'quantizationmethod' => { 133 => 0x78 },
	'quickadjust' => { 292 => 0x2a },
	'quickcontroldialinmeter' => { 84 => 0x703 },
	'quickfix' => { 289 => 0x416391c6 },
	'quickshot' => { 413 => 0x213 },
	'quiettime' => { 138 => 0x188a },
	'rads' => { 397 => 'rads' },
	'rangefinder' => { 301 => '4.1', 302 => '5.1', 303 => '5.1' },
	'rangemask' => { 496 => 'RangeMaskMapInfo', 498 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 496 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 498 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 496 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 498 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 496 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 498 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 496 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 498 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 496 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 498 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 496 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 498 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 131 => 0x7d },
	'rating' => { 119 => 0x4746, 127 => 0x1431, 383 => 0xdf, 389 => 'rtng', 397 => 'rtng', 437 => 0x2002, 491 => 'rating', 500 => 'rating', 510 => 'Rating', 515 => 'rating', 523 => 'Rating' },
	'ratingpercent' => { 119 => 0x4749, 178 => 'Rating', 389 => 'rate', 523 => 'RatingPercent' },
	'ratingregion' => { 510 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 510 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 510 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 510 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 510 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 510 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 510 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 510 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 510 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 510 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 510 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 510 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 510 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 510 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 510 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 510 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 510 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 510 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 82 => 0x8, 186 => 0x109, 353 => 0xd },
	'rawbrightnessadj' => { 103 => 0x20001, 108 => 0x38 },
	'rawburstimagecount' => { 75 => 0x2 },
	'rawburstimagenum' => { 75 => 0x1 },
	'rawcoloradj' => { 108 => 0x2e },
	'rawcropbottom' => { 383 => 0xd4 },
	'rawcropleft' => { 383 => 0xd1 },
	'rawcropright' => { 383 => 0xd3 },
	'rawcroptop' => { 383 => 0xd2 },
	'rawcustomsaturation' => { 108 => 0x30 },
	'rawcustomtone' => { 108 => 0x34 },
	'rawdata' => { 411 => 0xa048 },
	'rawdatabyteorder' => { 411 => 0x40 },
	'rawdatacfapattern' => { 411 => 0x50 },
	'rawdatauniqueid' => { 119 => 0xc65d },
	'rawdepth' => { 188 => 0x10 },
	'rawdevartfilter' => { 321 => 0x121 },
	'rawdevautogradation' => { 321 => 0x119 },
	'rawdevcolorspace' => { 320 => 0x108, 321 => 0x109 },
	'rawdevcontrastvalue' => { 320 => 0x106, 321 => 0x105 },
	'rawdeveditstatus' => { 320 => 0x10b },
	'rawdevelopingsoftware' => { 119 => 0xa43a },
	'rawdevelopmentprocess' => { 372 => 0x62 },
	'rawdevengine' => { 320 => 0x109, 321 => 0x10b },
	'rawdevexposurebiasvalue' => { 320 => 0x100, 321 => 0x100 },
	'rawdevgradation' => { 321 => 0x112 },
	'rawdevgraypoint' => { 320 => 0x103, 321 => 0x104 },
	'rawdevmemorycoloremphasis' => { 320 => 0x105, 321 => 0x108 },
	'rawdevnoisereduction' => { 320 => 0x10a, 321 => 0x10a },
	'rawdevpicturemode' => { 321 => 0x10c },
	'rawdevpm_bwfilter' => { 321 => 0x110 },
	'rawdevpmcontrast' => { 321 => 0x10e },
	'rawdevpmnoisefilter' => { 321 => 0x120 },
	'rawdevpmpicturetone' => { 321 => 0x111 },
	'rawdevpmsaturation' => { 321 => 0x10d },
	'rawdevpmsharpness' => { 321 => 0x10f },
	'rawdevsaturation3' => { 321 => 0x113 },
	'rawdevsaturationemphasis' => { 320 => 0x104, 321 => 0x107 },
	'rawdevsettings' => { 320 => 0x10c },
	'rawdevsharpnessvalue' => { 320 => 0x107, 321 => 0x106 },
	'rawdevversion' => { 320 => 0x0, 321 => 0x0 },
	'rawdevwbfineadjustment' => { 320 => 0x102, 321 => 0x103 },
	'rawdevwhitebalance' => { 321 => 0x101 },
	'rawdevwhitebalancevalue' => { 320 => 0x101, 321 => 0x102 },
	'rawfile' => { 119 => 0xfe4c },
	'rawfilename' => { 496 => 'RawFileName', 498 => 'RawFileName' },
	'rawfiletype' => { 437 => 0x2029 },
	'rawformat' => { 342 => 0x2d, 381 => 0x10e },
	'rawimagecenter' => { 234 => 0x99 },
	'rawimagedigest' => { 119 => 0xc71c },
	'rawimagesize' => { 372 => 0x39 },
	'rawinfoversion' => { 322 => 0x0 },
	'rawjpgheight' => { 99 => 0x4 },
	'rawjpgquality' => { 57 => 0x6, 99 => 0x1 },
	'rawjpgsize' => { 57 => 0x7, 99 => 0x2 },
	'rawjpgwidth' => { 99 => 0x3 },
	'rawmeasuredrggb' => { 43 => 0x26a, 45 => 0x280, 47 => 0x194, 48 => [0x1ad,0x26b] },
	'rawrppused' => { 491 => 'rawrppused' },
	'rawtopreviewgain' => { 119 => 0xc7a8 },
	'readouttypeactual' => { 138 => 0x1903 },
	'readouttyperequested' => { 138 => 0x1902 },
	'reardisplay' => { 296 => '12.3', 297 => '6.2' },
	'recdevice' => { 510 => 'RecDevice' },
	'recdeviceattlensdescription' => { 510 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 510 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 510 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 510 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 510 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 517 => 'recipeEndingPage' },
	'recipepagerange' => { 517 => 'recipePageRange' },
	'recipesource' => { 517 => 'recipeSource' },
	'recipestartingpage' => { 517 => 'recipeStartingPage' },
	'recipetitle' => { 517 => 'recipeTitle' },
	'recognizedface1age' => { 330 => 0x20 },
	'recognizedface1name' => { 330 => 0x4 },
	'recognizedface1position' => { 330 => 0x18 },
	'recognizedface2age' => { 330 => 0x50 },
	'recognizedface2name' => { 330 => 0x34 },
	'recognizedface2position' => { 330 => 0x48 },
	'recognizedface3age' => { 330 => 0x80 },
	'recognizedface3name' => { 330 => 0x64 },
	'recognizedface3position' => { 330 => 0x78 },
	'recognizedfaceflags' => { 337 => 0x63 },
	'recommendedexposureindex' => { 119 => 0x8832, 503 => 'RecommendedExposureIndex' },
	'record' => { 118 => 'Record' },
	'recordbasisofrecord' => { 118 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 118 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 118 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 118 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 118 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 118 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 184 => 0x4d },
	'recorddynamicproperties' => { 118 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 97 => 0x1804 },
	'recordinformationwithheld' => { 118 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 397 => "\xa9phg" },
	'recordingformat' => { 404 => 0x1000 },
	'recordingmode' => { 112 => 0x1, 379 => 0x1 },
	'recordinstitutioncode' => { 118 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 118 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 397 => "\xa9lab" },
	'recordlabelurl' => { 397 => "\xa9lal" },
	'recordlocationdata' => { 239 => 0x660, 240 => 0x690, 241 => 0x6f8 },
	'recordmode' => { 34 => 0x9, 113 => 0x3000 },
	'recordownerinstitutioncode' => { 118 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 413 => 0x217 },
	'redbalance' => { 319 => 0x1017, 342 => 0x11, 372 => 0x1c },
	'redcurvelimits' => { 108 => 0x18a },
	'redcurvepoints' => { 107 => 0x2d, 108 => 0x160 },
	'redeyecorrection' => { 293 => 0x0 },
	'redeyeinfo' => { 496 => 'RedEyeInfo', 498 => 'RedEyeInfo' },
	'redeyereduction' => { 184 => 0x41, 424 => 0x6a, 426 => 0x28 },
	'redeyeremoval' => { 337 => 0xb9 },
	'redhsl' => { 103 => 0x20910 },
	'redhue' => { 496 => 'RedHue', 498 => 'RedHue' },
	'redsaturation' => { 496 => 'RedSaturation', 498 => 'RedSaturation' },
	'reductionmatrix1' => { 119 => 0xc625 },
	'reductionmatrix2' => { 119 => 0xc626 },
	'reductionmatrix3' => { 119 => 0xcd3a },
	'reelname' => { 119 => 0xc789, 397 => 'reel' },
	'reference1' => { 508 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 508 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 508 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 508 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 508 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 508 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 119 => 0x214, 521 => 'ReferenceBlackWhite' },
	'referencedate' => { 131 => 0x2f },
	'referencenumber' => { 131 => 0x32 },
	'references' => { 157 => 'References' },
	'referenceservice' => { 131 => 0x2d },
	'regionappliedtodimensions' => { 172 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 172 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 172 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 172 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 172 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 172 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 172 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 172 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 172 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 172 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 172 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 172 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 324 => 'RegionConstraints' },
	'regiondescription' => { 172 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 172 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 172 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 172 => 'Regions' },
	'regioninfodateregionsvalid' => { 175 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 175 => 'RegionInfo' },
	'regioninforegions' => { 175 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 172 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 172 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 175 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 172 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 172 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 172 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 510 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 510 => 'RegistryId' },
	'registryitemid' => { 510 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 510 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 155 => 'data' },
	'relatedaudiofilename' => { 155 => '1Name' },
	'relatedaudiofiletype' => { 155 => '0Type' },
	'relatedimagefileformat' => { 119 => 0x1000 },
	'relatedimageheight' => { 119 => 0x1002 },
	'relatedimagewidth' => { 119 => 0x1001 },
	'relatedresourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 119 => 0xa004, 502 => 'RelatedSoundFile' },
	'relatedvideofile' => { 169 => 'data' },
	'relatedvideofilename' => { 169 => '1Name' },
	'relatedvideofiletype' => { 169 => '0Type' },
	'relation' => { 499 => 'relation' },
	'relationshipaccordingto' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 116 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 525 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 525 => 'relativeTimestamp' },
	'relativetimestampscale' => { 525 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 525 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 296 => '17.8', 297 => '18.5', 299 => '18.4', 300 => '18.4', 305 => '33.8', 306 => '17.6', 309 => '18.5', 310 => '18.4' },
	'releasedate' => { 131 => 0x1e, 389 => 'rldt', 491 => 'ReleaseDate', 525 => 'releaseDate' },
	'releasemode' => { 113 => 0x3001, 238 => 0x5c, 270 => 0x184d, 437 => 0xb049 },
	'releasemode2' => { 446 => 0x112c, 447 => [0x112c,0x8], 448 => [0x1108,0x8], 449 => [0x1184,0x8], 450 => [0x1160,0x8], 451 => [0x4,0x1018], 452 => [0x4,0x210], 453 => [0x4,0x210], 454 => [0x4,0x208], 456 => [0x67,0x3f], 457 => [0x6b,0x6d,0x73,0x4b], 458 => [0x6b,0x4b], 459 => 0x10, 460 => 0x10, 461 => 0x9, 468 => 0x34 },
	'releasemode3' => { 446 => 0x1128, 447 => 0x1128, 448 => 0x1104, 449 => 0x1180, 450 => 0x115c, 451 => 0x1014, 452 => 0x20c, 453 => 0x20c, 454 => 0x204 },
	'releaseready' => { 510 => 'ReleaseReady' },
	'releasesetting' => { 97 => 0x1016 },
	'releasetime' => { 131 => 0x23, 491 => 'ReleaseTime' },
	'remoteonduration' => { 298 => '3.4', 301 => '17.2', 302 => '18.2', 303 => '18.2', 304 => '18.2', 306 => '18.2', 307 => '4.3', 311 => '19.2' },
	'renditionclass' => { 526 => 'RenditionClass' },
	'renditionof' => { 526 => 'RenditionOf' },
	'renditionofalternatepaths' => { 526 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 526 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 526 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 526 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 526 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 526 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 526 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 526 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 526 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 526 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 526 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 526 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 526 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 526 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 526 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 526 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 526 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 526 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 526 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 526 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 526 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 526 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 526 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 526 => 'RenditionParams' },
	'repeatingflashcount' => { 212 => 0xd, 213 => 0xe, 214 => 0xe, 215 => 0xe, 216 => 0xe, 217 => 0xe, 305 => '17.2', 306 => '24.2', 307 => '9.2', 308 => '24.2', 311 => '25.2' },
	'repeatingflashcountbuilt-in' => { 277 => 0x4db },
	'repeatingflashcountexternal' => { 277 => 0x4c3 },
	'repeatingflashoutput' => { 305 => '17.1', 306 => '24.1', 307 => '9.1', 308 => '24.1', 311 => '25.1' },
	'repeatingflashoutputexternal' => { 277 => 0x4c0 },
	'repeatingflashrate' => { 212 => 0xc, 213 => 0xd, 214 => 0xd, 215 => 0xd, 216 => 0xd, 217 => 0xd, 305 => '18.1', 306 => '25.1', 307 => '10.1', 308 => '25.1', 311 => '26.1' },
	'repeatingflashratebuilt-in' => { 277 => 0x4da },
	'repeatingflashrateexternal' => { 277 => 0x4c2 },
	'requirements' => { 397 => "\xa9req" },
	'requires' => { 494 => 'requires' },
	'resampleparams' => { 525 => 'resampleParams' },
	'resampleparamsquality' => { 525 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 138 => 0xe50 },
	'resamplingkerneldenominators067' => { 138 => 0xe4f },
	'resamplingkerneldenominators100' => { 138 => 0xe51 },
	'resaved' => { 413 => 0x21e },
	'resetblacksegrows' => { 138 => 0x181a },
	'resolution' => { 162 => 'Resolution' },
	'resolutionmode' => { 414 => [0x87,0x4] },
	'resolutionunit' => { 119 => 0x128, 134 => 0x2, 521 => 'ResolutionUnit' },
	'resourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 118 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 118 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 84 => 0x612 },
	'restrictions' => { 518 => 'restrictions' },
	'retouchareafeather' => { 496 => [\'RetouchAreas','RetouchAreasFeather'], 498 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 496 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 498 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 496 => [\'RetouchAreas','RetouchAreasMasksAngle'], 498 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 496 => [\'RetouchAreas','RetouchAreasMasksBottom'], 498 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 496 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 498 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 496 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 498 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 496 => [\'RetouchAreas','RetouchAreasMasksDabs'], 498 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 496 => [\'RetouchAreas','RetouchAreasMasksFeather'], 498 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 496 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 498 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 496 => [\'RetouchAreas','RetouchAreasMasksFlow'], 498 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 496 => [\'RetouchAreas','RetouchAreasMasksFullX'], 498 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 496 => [\'RetouchAreas','RetouchAreasMasksFullY'], 498 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 496 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 498 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 496 => [\'RetouchAreas','RetouchAreasMasksLeft'], 498 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 496 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 498 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 496 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 498 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 496 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 498 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 496 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 498 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 496 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 498 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasks'], 498 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 496 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 498 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 496 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 498 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 496 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 498 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 496 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 498 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 496 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 498 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 496 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 498 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 496 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 498 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 496 => [\'RetouchAreas','RetouchAreasMasksRadius'], 498 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 498 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 496 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 498 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 496 => [\'RetouchAreas','RetouchAreasMasksRight'], 498 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 496 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 498 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 496 => [\'RetouchAreas','RetouchAreasMasks'], 498 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 496 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 498 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 496 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 498 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 496 => [\'RetouchAreas','RetouchAreasMasksTop'], 498 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 496 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 498 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 496 => [\'RetouchAreas','RetouchAreasMasksVersion'], 498 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 496 => [\'RetouchAreas','RetouchAreasMasksWhat'], 498 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 496 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 498 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 496 => [\'RetouchAreas','RetouchAreasMasksX'], 498 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 496 => [\'RetouchAreas','RetouchAreasMasksY'], 498 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 496 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 498 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 496 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 498 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 496 => [\'RetouchAreas','RetouchAreasMethod'], 498 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 496 => [\'RetouchAreas','RetouchAreasOffsetY'], 498 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 496 => [\'RetouchAreas','RetouchAreasOpacity'], 498 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 496 => 'RetouchAreas', 498 => 'RetouchAreas' },
	'retouchareaseed' => { 496 => [\'RetouchAreas','RetouchAreasSeed'], 498 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 496 => [\'RetouchAreas','RetouchAreasSourceState'], 498 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 496 => [\'RetouchAreas','RetouchAreasSourceX'], 498 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 496 => [\'RetouchAreas','RetouchAreasSpotType'], 498 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 234 => 0x9e },
	'retouchinfo' => { 496 => 'RetouchInfo', 498 => 'RetouchInfo' },
	'retouchnefprocessing' => { 254 => 0x5 },
	'retractlensonpoweroff' => { 84 => 0x814 },
	'reuse' => { 324 => 'Reuse' },
	'reuseallowed' => { 528 => 'ReuseAllowed' },
	'reuseprohibited' => { 518 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 303 => '5.2' },
	'reversefocusring' => { 312 => 0x163 },
	'reverseindicators' => { 296 => '12.1', 297 => '6.1', 299 => '6.1', 300 => '6.1', 301 => '4.3', 302 => '5.2', 303 => '5.4', 305 => '33.5', 306 => '5.1', 309 => '6.1', 310 => '6.1', 311 => '6.2', 312 => 0xc1 },
	'reverseshutterspeedaperture' => { 303 => '5.3' },
	'revision' => { 500 => 'revision' },
	'rflensmffocusringsensitivity' => { 84 => 0x714 },
	'rflenstype' => { 57 => 0x3d },
	'rgbcurvelimits' => { 108 => 0x238 },
	'rgbcurvepoints' => { 107 => 0x7, 108 => 0x20e },
	'rgbtables' => { 119 => 0xcd3b },
	'richtextcomment' => { 505 => 'RichTextComment' },
	'ricohdate' => { 403 => 0x6 },
	'ricohimageheight' => { 403 => 0x2 },
	'ricohimagewidth' => { 403 => 0x0 },
	'rightalbedo' => { 487 => 'RightAlbedo' },
	'rightascension' => { 165 => 'RightAscension' },
	'rights' => { 499 => 'rights' },
	'rightsagent' => { 518 => 'rightsAgent' },
	'rightsowner' => { 518 => 'rightsOwner' },
	'roll' => { 115 => 0x8, 397 => ['roll',"\xa9frl"] },
	'rollangle' => { 127 => 0x144d, 246 => 0x0, 314 => 0x903, 337 => 0x90, 371 => 0x1, 409 => 0x2 },
	'romoperationmode' => { 97 => 0x80d },
	'rotation' => { 30 => 0x17, 31 => 0x18, 96 => 0x3, 103 => 0x10002, 108 => 0x26e, 114 => 'QuickTime-Rotation', 123 => 0x4, 165 => 'Rotation', 182 => [0x65,0x50], 183 => 0x46, 184 => 0x5a, 187 => 0x10, 255 => 0x1a, 270 => 0x3693, 276 => '590.1', 289 => 0x76a43207, 337 => 0x30, 353 => '17.2', 383 => 0xd8, 390 => 'irot', 424 => 0x3f, 425 => 0x3f, 435 => 0x10 },
	'routedto' => { 504 => 'RoutedTo' },
	'routing' => { 388 => 'Routing' },
	'routingdestinations' => { 486 => 'RoutingDestinations' },
	'routingexclusions' => { 486 => 'RoutingExclusions' },
	'routingnotes' => { 504 => 'RoutingNotes' },
	'rowsperstrip' => { 119 => 0x116 },
	'rpp' => { 491 => 'rpp' },
	'rtkflag' => { 116 => 'RtkFlag' },
	'rtkstdhgt' => { 116 => 'RtkStdHgt' },
	'rtkstdlat' => { 116 => 'RtkStdLat' },
	'rtkstdlon' => { 116 => 'RtkStdLon' },
	'safetyshift' => { 84 => 0x108 },
	'safetyshiftinavortv' => { 82 => 0x10, 83 => 0x10, 85 => 0xf, 86 => 0x10, 89 => 0x10 },
	'sameexposurefornewaperture' => { 84 => 0x112 },
	'samplebits' => { 155 => 'SampleBits' },
	'samplepagerange' => { 515 => 'samplePageRange' },
	'samplerate' => { 155 => 'SampleRate' },
	'samplesperpixel' => { 119 => 0x115, 342 => 0x8, 521 => 'SamplesPerPixel' },
	'samplestructure' => { 133 => 0x5a },
	'samsungmodelid' => { 411 => 0x3 },
	'sanyoquality' => { 413 => 0x201 },
	'sanyothumbnail' => { 413 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 34 => 0xe, 51 => 0x1, 63 => 0x7, 112 => 0xd, 113 => [0x3013,0x1f], 119 => [0xa409,0xfe55], 127 => 0x1003, 156 => 'Saturation', 181 => 0x1f, 182 => 0x32, 183 => 0x28, 184 => 0x1a, 189 => 0x1, 234 => 0xaa, 248 => 0x35, 249 => 0x3b, 250 => 0x43, 337 => 0x40, 339 => 0x300d, 372 => 0x1f, 379 => 0xd, 398 => 0x27, 400 => 0x58, 403 => 0x28, 404 => 0x1013, 414 => 0x10, 424 => 0x1e, 425 => 0x1b, 437 => 0x2005, 496 => 'Saturation', 498 => 'Saturation', 502 => 'Saturation' },
	'saturationadj' => { 103 => 0x20901, 108 => 0x116, 234 => 0x94, 288 => 0x1, 292 => 0x2e, 472 => 0x8016 },
	'saturationadjustmentaqua' => { 496 => 'SaturationAdjustmentAqua', 498 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 496 => 'SaturationAdjustmentBlue', 498 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 496 => 'SaturationAdjustmentGreen', 498 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 496 => 'SaturationAdjustmentMagenta', 498 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 496 => 'SaturationAdjustmentOrange', 498 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 496 => 'SaturationAdjustmentPurple', 498 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 496 => 'SaturationAdjustmentRed', 498 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 496 => 'SaturationAdjustmentYellow', 498 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 71 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 70 => 0x68, 71 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 70 => 0x38, 71 => 0x38 },
	'saturationmonochrome' => { 70 => 0x80, 71 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 70 => 0x50, 71 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 70 => 0x20, 71 => 0x20 },
	'saturationsetting' => { 322 => 0x1010, 426 => 0x11, 442 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 70 => 0x8, 71 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 70 => 0x98, 71 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 70 => 0xb0, 71 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 70 => 0xc8, 71 => 0xe0 },
	'saveid' => { 526 => 'SaveID' },
	'sbaanalysiscomplete' => { 138 => 0xc35 },
	'sbablack' => { 138 => 0xc25 },
	'sbagmoffset' => { 138 => 0xc4a },
	'sbagray' => { 138 => 0xc26 },
	'sbagreenmagentabal' => { 138 => 0xc33 },
	'sbahighgray' => { 138 => 0xc46 },
	'sbailloffset' => { 138 => 0xc49 },
	'sbailluminantbal' => { 138 => 0xc34 },
	'sbalowgray' => { 138 => 0xc47 },
	'sbaneutralbal' => { 138 => 0xc32 },
	'sbawhite' => { 138 => 0xc27 },
	'scaletype' => { 525 => 'scaleType' },
	'scanimageenhancer' => { 256 => 0x60 },
	'scanningdirection' => { 133 => 0x64 },
	'scene' => { 397 => 'scen', 509 => 'Scene', 525 => 'scene' },
	'scenearea' => { 317 => 0x211, 319 => 0x1031 },
	'sceneassist' => { 234 => 0x9c },
	'scenecapturetype' => { 119 => 0xa406, 502 => 'SceneCaptureType' },
	'scenedetect' => { 317 => 0x210, 319 => 0x1030 },
	'scenedetectdata' => { 317 => 0x212, 319 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 142 => 0xfa02, 186 => 0x100, 234 => 0x8f, 314 => 0x509, 319 => 0x403, 337 => 0x8001, 346 => 0xf, 437 => 0xb023 },
	'scenemodeused' => { 144 => [0x6002,0xf002] },
	'scenerecognition' => { 127 => 0x1425 },
	'scenereferred' => { 506 => 'scene_referred' },
	'sceneselect' => { 413 => 0x21f },
	'scenetype' => { 119 => 0xa301, 502 => 'SceneType' },
	'screentips' => { 296 => '12.7', 297 => '5.3', 305 => '13.1', 306 => '4.4', 309 => '5.4', 311 => '5.1' },
	'scriptversion' => { 138 => 0x1770 },
	'sdrblend' => { 496 => 'SDRBlend', 498 => 'SDRBlend' },
	'sdrbrightness' => { 496 => 'SDRBrightness', 498 => 'SDRBrightness' },
	'sdrcontrast' => { 496 => 'SDRContrast', 498 => 'SDRContrast' },
	'sdrhighlights' => { 496 => 'SDRHighlights', 498 => 'SDRHighlights' },
	'sdrshadows' => { 496 => 'SDRShadows', 498 => 'SDRShadows' },
	'sdrwhites' => { 496 => 'SDRWhites', 498 => 'SDRWhites' },
	'season' => { 510 => 'Season', 514 => 'season' },
	'seasonidentifier' => { 510 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 510 => [\'Season','SeasonName'] },
	'seasonnumber' => { 510 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 486 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 239 => 0x22c, 240 => 0x240, 241 => 0x240, 259 => 0x13c, 270 => 0x1d0 },
	'section' => { 515 => 'section' },
	'securityclassification' => { 119 => 0x9212 },
	'selectableafpoint' => { 84 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 84 => 0x512 },
	'selfdata' => { 116 => 'SelfData' },
	'selftimer' => { 34 => 0x2, 337 => 0x2e, 413 => 0x214, 446 => 0x1134, 447 => 0x1134, 448 => 0x1110, 449 => 0x118c, 450 => 0x1168, 451 => 0x1020, 452 => 0x218, 453 => 0x218, 454 => 0x210 },
	'selftimer2' => { 77 => 0x1d },
	'selftimerinterval' => { 306 => '19.2' },
	'selftimermode' => { 119 => 0x882b },
	'selftimershotcount' => { 297 => '20.2', 299 => '20.3', 300 => '20.3', 301 => '18.2', 302 => '19.2', 303 => '19.2', 304 => '19.3', 306 => '19.3', 309 => '20.3', 310 => '20.3', 311 => '20.2', 312 => 0x2d },
	'selftimershotinterval' => { 297 => '20.3', 299 => '20.2', 300 => '20.2', 304 => '19.2', 309 => '20.2', 310 => '20.2', 312 => 0x31 },
	'selftimertime' => { 97 => 0x1806, 184 => 0x1f, 296 => '18.1', 297 => '20.1', 298 => '3.3', 299 => '20.1', 300 => '20.1', 301 => '18.1', 302 => '19.1', 303 => '19.1', 304 => '19.1', 305 => '7.2', 306 => '19.1', 307 => '3.3', 309 => '20.1', 310 => '20.1', 311 => '20.1', 312 => 0x2b },
	'sellingagency' => { 515 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 119 => 0x8546 },
	'sensingmethod' => { 119 => 0xa217, 502 => 'SensingMethod' },
	'sensitivityadjust' => { 372 => 0x40 },
	'sensitivitysteps' => { 353 => ['14.3','17.4'], 355 => 0x1 },
	'sensitivitytype' => { 119 => 0x8830, 503 => 'SensitivityType' },
	'sensor' => { 191 => 0x665e },
	'sensorarea' => { 319 => 0x400 },
	'sensorareas' => { 411 => 0xa010 },
	'sensorbitdepth' => { 339 => 0x312d },
	'sensorbluelevel' => { 74 => 0x5 },
	'sensorcalibration' => { 318 => 0x805 },
	'sensorcleaning' => { 90 => 0xd },
	'sensorfullheight' => { 137 => 0xf904 },
	'sensorfullwidth' => { 137 => 0xf903 },
	'sensorheight' => { 137 => 0xf901, 142 => 0xfa21, 188 => 0x8, 339 => 0x312c, 381 => 0x109, 404 => 0x1602 },
	'sensorimageheight' => { 138 => 0x3ee },
	'sensorimagewidth' => { 138 => 0x3ed },
	'sensorleftborder' => { 138 => 0x3eb },
	'sensorleftmargin' => { 381 => 0x10a },
	'sensorpixelsize' => { 234 => 0x9a },
	'sensorredlevel' => { 74 => 0x4 },
	'sensorserialnumber' => { 138 => 0x9ce },
	'sensorshield' => { 239 => 0x66d, 240 => 0x69d, 241 => 0x705 },
	'sensorsize' => { 156 => 'SensorSize', 372 => 0x35 },
	'sensortemperature' => { 317 => 0x1500, 319 => 0x1007, 377 => 0xc, 381 => 0x210, 414 => [0x39,0x55] },
	'sensortemperature2' => { 377 => 0xe, 381 => 0x211 },
	'sensortopborder' => { 138 => 0x3ec },
	'sensortopmargin' => { 381 => 0x10b },
	'sensortype' => { 337 => 0xca },
	'sensorwidth' => { 137 => 0xf900, 142 => 0xfa20, 188 => 0xa, 339 => 0x312b, 381 => 0x108, 404 => 0x1601 },
	'sequence' => { 398 => 0x7, 399 => 0x35, 400 => 0x36 },
	'sequencefilenumber' => { 447 => 0x4, 448 => 0x4, 449 => 0x4, 450 => 0x4, 459 => 0xc, 460 => 0xc, 461 => 0x1a },
	'sequenceimagenumber' => { 447 => 0x0, 448 => 0x0, 449 => 0x0, 450 => 0x0, 459 => 0x8, 460 => 0x8, 461 => 0x12, 468 => 0x24 },
	'sequencelength' => { 459 => 0x22, 460 => 0x1e, 461 => [0x16,0x1e] },
	'sequencename' => { 514 => 'sequenceName' },
	'sequencenumber' => { 77 => 0x9, 113 => 0x301c, 127 => 0x1101, 140 => 0x1d, 277 => 0x51c, 337 => 0x2b, 426 => [0x10c,0x30c], 437 => 0xb04a, 514 => 'sequenceNumber' },
	'sequenceshotinterval' => { 413 => 0x224 },
	'sequencetotalnumber' => { 514 => 'sequenceTotalNumber' },
	'sequentialshot' => { 413 => 0x20e },
	'serialnumber' => { 64 => 0xc, 97 => 0x180b, 119 => [0xa431,0xfde9], 137 => 0xfa04, 139 => 0xfa00, 141 => 0xc354, 142 => 0xfa19, 153 => 0x0, 156 => 'SerialNumber', 191 => 0x5501, 234 => [0xa0,0x1d], 315 => 0x101, 319 => [0x404,0x101a], 332 => 0x303, 334 => 0x305, 339 => 0x3103, 372 => 0x229, 381 => 0x102, 382 => 0x407, 397 => ['SNum','slno'], 398 => 0x15, 399 => 0x4b, 400 => 0x7e, 404 => 0x5, 411 => 0xa002, 414 => 0x2, 437 => 0x2031, 493 => 'SerialNumber', 503 => 'BodySerialNumber' },
	'serialnumberformat' => { 64 => 0x15, 97 => 0x183b },
	'serialnumberhash' => { 397 => 'CAME' },
	'series' => { 510 => 'Series' },
	'seriesdatetime' => { 474 => 'SeriesDateTime' },
	'seriesdescription' => { 474 => 'SeriesDescription' },
	'seriesidentifier' => { 510 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 474 => 'SeriesModality' },
	'seriesname' => { 510 => [\'Series','SeriesName'] },
	'seriesnumber' => { 474 => 'SeriesNumber', 515 => 'seriesNumber' },
	'seriestitle' => { 515 => 'seriesTitle' },
	'serviceidentifier' => { 132 => 0x1e },
	'servingsize' => { 517 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 87 => 0x0, 88 => 0x0 },
	'setbuttonwhenshooting' => { 82 => 0x1, 84 => 0x704, 90 => 0xc },
	'setclockfromlocationdata' => { 239 => 0x61d, 240 => 0x64d, 241 => 0x6b5 },
	'setfunctionwhenshooting' => { 85 => 0x0, 86 => 0x1, 89 => 0x1 },
	'setting' => { 514 => 'setting' },
	'shadingcompensation' => { 314 => 0x50c, 337 => 0x8a },
	'shadingcompensation2' => { 318 => 0x1012 },
	'shadow' => { 414 => 0xe },
	'shadowadj' => { 103 => 0x2030b },
	'shadowcorrection' => { 372 => 0x79 },
	'shadowprotection' => { 288 => 0x0 },
	'shadows' => { 119 => 0xfe52, 437 => 0x2032, 490 => 'Shadows', 496 => 'Shadows', 498 => 'Shadows' },
	'shadows2012' => { 496 => 'Shadows2012', 498 => 'Shadows2012' },
	'shadowsadj' => { 472 => 0x901a },
	'shadowscale' => { 119 => 0xc633 },
	'shadowtint' => { 496 => 'ShadowTint', 498 => 'ShadowTint' },
	'shadowtone' => { 127 => 0x1040 },
	'shakereduction' => { 374 => 0x1, 375 => 0x1 },
	'shareduserrating' => { 179 => 'WM/SharedUserRating' },
	'sharpendetail' => { 496 => 'SharpenDetail', 498 => 'SharpenDetail' },
	'sharpenedgemasking' => { 496 => 'SharpenEdgeMasking', 498 => 'SharpenEdgeMasking' },
	'sharpening' => { 339 => 0x300b },
	'sharpeningadj' => { 292 => 0x2b },
	'sharpeningkernel' => { 138 => 0x92f },
	'sharpenradius' => { 496 => 'SharpenRadius', 498 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 34 => 0xf, 63 => 0x6, 74 => 0x2, 112 => 0xb, 113 => [0x3011,0x21], 119 => [0xa40a,0xfe56], 127 => 0x1001, 140 => 0x6b, 149 => 0x37, 156 => 'Sharpness', 181 => 0x21, 182 => 0x30, 183 => 0x26, 184 => 0x18, 189 => 0x3, 234 => 0x6, 248 => 0x32, 249 => 0x33, 250 => 0x39, 319 => 0x100f, 337 => 0x41, 372 => 0x21, 379 => 0xb, 398 => 0x26, 400 => 0x56, 403 => 0x22, 404 => [0x1003,0x1014], 414 => 0x11, 424 => 0x1c, 425 => 0x19, 437 => 0x2006, 468 => 0x52, 496 => 'Sharpness', 498 => 'Sharpness', 502 => 'Sharpness' },
	'sharpnessadj' => { 103 => 0x20310, 108 => 0x25a, 472 => 0x801a },
	'sharpnessadjon' => { 103 => '0x20310.0' },
	'sharpnessauto' => { 71 => 0x94 },
	'sharpnessfactor' => { 319 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 70 => 0x64, 71 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 74 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 70 => 0x34, 71 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 70 => 0x7c, 71 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 70 => 0x4c, 71 => 0x4c },
	'sharpnessovershoot' => { 472 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 70 => 0x1c, 71 => 0x1c },
	'sharpnessrange' => { 437 => 0x2035 },
	'sharpnesssetting' => { 314 => 0x506, 322 => 0x1013, 426 => 0x12, 442 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 70 => 0x4, 71 => 0x4 },
	'sharpnessstrength' => { 103 => 0x20311 },
	'sharpnessthreshold' => { 472 => 0x801d },
	'sharpnessundershoot' => { 472 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 70 => 0x94, 71 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 70 => 0xac, 71 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 70 => 0xc4, 71 => 0xdc },
	'shiftcols' => { 138 => 0xc70 },
	'shootid' => { 514 => 'shootID' },
	'shootingdistance' => { 103 => 0x20701 },
	'shootinginfodisplay' => { 296 => '13.2', 297 => '5.1', 305 => '10.2', 306 => '4.1', 309 => '5.1', 311 => '5.3' },
	'shootinginfomonitorofftime' => { 296 => '26.2', 297 => '22.2', 299 => '22.2', 300 => '22.2', 304 => '21.2', 305 => '9.1', 306 => '21.2', 309 => '22.2', 310 => '22.2', 311 => '22.2', 312 => 0x37 },
	'shootingmode' => { 156 => 'ShootingMode', 234 => 0x89, 337 => 0x1f },
	'shootingmodesetting' => { 298 => '5.1' },
	'shortdescription' => { 500 => 'shortdescription' },
	'shortdocumentid' => { 131 => 0xba },
	'shortname' => { 496 => 'ShortName', 498 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 84 => 0x80d },
	'shorttitle' => { 389 => '@sti' },
	'shotdate' => { 525 => 'shotDate' },
	'shotday' => { 525 => 'shotDay' },
	'shotlocation' => { 525 => 'shotLocation' },
	'shotlogdata' => { 479 => 'shot_log_data' },
	'shotname' => { 397 => 'shot', 525 => 'shotName' },
	'shotnumber' => { 525 => 'shotNumber' },
	'shotnumbersincepowerup' => { 441 => 0x44e, 459 => 0x1a, 460 => 0x16, 461 => 0xa },
	'shotnumbersincepowerup2' => { 426 => 0x200 },
	'shotsize' => { 525 => 'shotSize' },
	'shotsperinterval' => { 223 => 0x180, 238 => 0xb4, 239 => 0xc0, 240 => 0xd0, 241 => 0xd0 },
	'showmovement' => { 389 => 'shwm' },
	'shownevent' => { 510 => 'EventExt' },
	'showneventidentifier' => { 510 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 510 => [\'EventExt','EventExtName'] },
	'shutter' => { 456 => 0x20, 457 => 0x26, 458 => 0x26 },
	'shutter-aelock' => { 82 => 0x4, 84 => 0x701, 85 => 0x3, 86 => 0x4, 87 => 0x3, 88 => 0x3, 89 => 0x4, 90 => 0x2 },
	'shutteraelbutton' => { 83 => 0x4 },
	'shutterbuttonafonbutton' => { 84 => 0x701 },
	'shuttercount' => { 11 => 0x176, 57 => 0x1, 234 => 0xa7, 261 => [0x6a,0x157,0x24d], 262 => 0x286, 263 => 0x279, 264 => 0x284, 265 => 0x242, 266 => 0x280, 267 => 0x276, 268 => [0x27d,0x27f], 269 => 0x246, 271 => 0x2d6, 272 => 0x321, 273 => 0xbd8, 274 => 0x287, 275 => 0x320, 276 => 0x24a, 277 => 0x5fb, 278 => 0x2d5, 372 => 0x5d, 435 => 0x846, 440 => [0x125,0x14a], 456 => 0x32, 457 => 0x3a, 458 => 0x3a },
	'shuttercount2' => { 456 => 0x4c, 457 => [0x50,0x52,0x58], 458 => 0x50 },
	'shuttercount3' => { 456 => [0x1a0,0x1aa,0x1bd], 457 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 82 => 0xf, 83 => 0xf, 84 => 0x305, 85 => 0xe, 86 => 0xf, 87 => 0x8, 88 => 0x8, 89 => 0xf, 90 => 0x8 },
	'shuttermode' => { 57 => 0x17, 140 => 0x1b, 234 => 0x34 },
	'shutterreleasebuttonae-l' => { 296 => '17.7', 297 => '18.4', 299 => '78.4', 300 => '78.4', 301 => '16.1', 302 => '17.1', 303 => '17.1', 304 => '17.1', 305 => '7.1', 306 => '17.5', 309 => '18.4', 310 => '78.4', 311 => '18.2', 312 => 0x29 },
	'shutterreleasemethod' => { 97 => 0x1010 },
	'shutterreleasenocfcard' => { 82 => 0x2, 83 => 0x2, 90 => 0xf },
	'shutterreleasetiming' => { 97 => 0x1011 },
	'shutterreleasewithoutlens' => { 84 => 0x711 },
	'shutterspeedlock' => { 297 => '38.1', 299 => '38.1', 300 => '38.1', 309 => '38.1', 310 => '38.1', 312 => 0xb7 },
	'shutterspeedrange' => { 84 => 0x10c },
	'shutterspeedsetting' => { 184 => 0x6, 424 => 0x2f, 425 => 0x28, 426 => 0x0 },
	'shutterspeedvalue' => { 93 => 0x1, 119 => 0x9201, 319 => 0x1000, 381 => 0x400, 502 => 'ShutterSpeedValue' },
	'shuttertype' => { 127 => 0x1050, 337 => 0x9f, 372 => 0x87, 461 => [0x133,0x139,0x13f] },
	'sidecarforextension' => { 513 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 138 => 0xe0d },
	'sigmascalingfactorcamera' => { 138 => 0xe0c },
	'sigmascalingfactorlowres' => { 138 => 0xe0b },
	'sigmasizetable' => { 138 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 234 => 0xbf },
	'similarityindex' => { 131 => 0xe4 },
	'singleframebracketing' => { 184 => 0x21 },
	'skilllevel' => { 517 => 'skillLevel' },
	'skintonecorrection' => { 372 => 0x95 },
	'skiplinetime' => { 138 => 0x184e },
	'slaveflashmeteringsegments' => { 372 => 0x20b },
	'slideshowname' => { 514 => 'slideshowName' },
	'slideshownumber' => { 514 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 514 => 'slideshowTotalNumber' },
	'slot2jpgsize' => { 241 => 0x24a },
	'slowshutter' => { 77 => 0x8 },
	'slowsync' => { 127 => 0x1030 },
	'smartalbumcolor' => { 411 => 0x20 },
	'smartrange' => { 411 => 0xa012 },
	'smileshutter' => { 426 => 0x31 },
	'smileshuttermode' => { 426 => 0x27 },
	'smoothness' => { 119 => 0xfe57, 496 => 'Smoothness', 498 => 'Smoothness' },
	'snapshot' => { 510 => 'SnapshotLink' },
	'snapshotformat' => { 510 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 510 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 510 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 510 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 510 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 491 => 'Snapshots' },
	'snapshotusedvideoframe' => { 510 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 510 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 510 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 510 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 510 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 437 => 0x200f },
	'software' => { 119 => 0x131, 157 => 'Software', 327 => 'Software', 381 => 0x203, 391 => 'software', 414 => 0x18, 481 => 'Software', 521 => 'Software' },
	'softwareversion' => { 397 => ['@swr',"\xa9swr"], 413 => 0x207 },
	'soloist' => { 389 => "\xa9sol" },
	'songwriter' => { 397 => "\xa9swf" },
	'songwriterkeywords' => { 397 => "\xa9swk" },
	'sonycropsize' => { 119 => 0x74c8 },
	'sonycroptopleft' => { 119 => 0x74c7 },
	'sonydatetime' => { 445 => 0x6, 447 => 0x1b6, 448 => 0x210, 449 => 0x1fe, 450 => 0x22c },
	'sonydatetime2' => { 456 => 0x51 },
	'sonyexposuretime' => { 456 => 0x3a, 457 => 0x46, 458 => [0x66,0x46] },
	'sonyexposuretime2' => { 468 => 0xe },
	'sonyfnumber' => { 456 => 0x3c, 457 => 0x48, 458 => [0x68,0x48], 468 => 0x14 },
	'sonyimageheight' => { 445 => 0x1a, 459 => 0x44, 460 => 0x3f, 461 => 0x47 },
	'sonyimageheightmax' => { 468 => 0x40 },
	'sonyimagesize' => { 184 => 0x3b, 424 => 0x54, 425 => 0x54, 426 => 0x9 },
	'sonyimagewidth' => { 445 => 0x1c },
	'sonyimagewidthmax' => { 468 => 0x3e },
	'sonyiso' => { 447 => 0x1218, 448 => 0x11f4, 449 => 0x1270, 450 => [0x1254,0x1258,0x1280], 451 => 0x113c, 452 => 0x344, 453 => 0x346, 454 => 0x320, 468 => 0x4 },
	'sonymaxaperture' => { 456 => 0x0, 457 => 0x0 },
	'sonymaxaperturevalue' => { 468 => 0x16 },
	'sonyminaperture' => { 456 => 0x1, 457 => 0x1 },
	'sonymodelid' => { 437 => 0xb001 },
	'sonyquality' => { 184 => 0x3c },
	'sonyrawimagesize' => { 119 => 0x7038 },
	'sonytimeminsec' => { 457 => 0x61 },
	'sortalbum' => { 389 => 'soal' },
	'sortalbumartist' => { 389 => 'soaa' },
	'sortartist' => { 389 => 'soar' },
	'sortcomposer' => { 389 => 'soco' },
	'sortname' => { 389 => 'sonm', 496 => 'SortName', 498 => 'SortName' },
	'sortshow' => { 389 => 'sosn' },
	'soundengineer' => { 389 => "\xa9sne" },
	'source' => { 131 => 0x73, 327 => 'Source', 499 => 'source', 500 => 'source', 513 => 'Source' },
	'sourcecount' => { 485 => 'SourceCount' },
	'sourcecredits' => { 397 => "\xa9src" },
	'sourcedirectoryindex' => { 359 => 0x0 },
	'sourcefileindex' => { 359 => 0x2 },
	'sourcephotoscount' => { 484 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 138 => 0x1390 },
	'spatialfrequencyresponse' => { 502 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 502 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 502 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 502 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 502 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 525 => 'speakerPlacement' },
	'specialeffectlevel' => { 113 => 0x3030 },
	'specialeffectmode' => { 113 => 0x2076 },
	'specialeffectsetting' => { 113 => 0x3031 },
	'specialinstructions' => { 131 => 0x28 },
	'specialmode' => { 319 => 0x200, 413 => 0x200 },
	'specialoccasion' => { 517 => 'specialOccasion' },
	'specialtypeid' => { 479 => 'SpecialTypeID' },
	'spectralsensitivity' => { 119 => 0x8824, 502 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 41 => 0x32b, 42 => 0x281, 45 => [0x2b9,0x2d0,0x2d4], 46 => 0x56a, 47 => 0x1e4, 48 => [0x1fd,0x2dd], 49 => [0x231,0x30f], 50 => 0x31d },
	'speedx' => { 115 => 0x3, 397 => "\xa9xsp" },
	'speedy' => { 115 => 0x4, 397 => "\xa9ysp" },
	'speedz' => { 115 => 0x5, 397 => "\xa9zsp" },
	'spherical' => { 485 => 'Spherical' },
	'sphericalvideoxml' => { 120 => 'SphericalVideoXML' },
	'splitcolumn' => { 381 => 0x222 },
	'splittoningbalance' => { 496 => 'SplitToningBalance', 498 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 496 => 'SplitToningHighlightHue', 498 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 496 => 'SplitToningHighlightSaturation', 498 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 496 => 'SplitToningShadowHue', 498 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 496 => 'SplitToningShadowSaturation', 498 => 'SplitToningShadowSaturation' },
	'sport' => { 515 => 'sport' },
	'spotfocuspointx' => { 181 => 0x2d },
	'spotfocuspointy' => { 181 => 0x2e },
	'spotmeteringmode' => { 34 => 0x27 },
	'spotmeterlinktoafpoint' => { 84 => 0x107 },
	'sractive' => { 353 => '17.1' },
	'srawquality' => { 34 => 0x2e },
	'srfocallength' => { 374 => 0x3 },
	'srgbrendering' => { 325 => 'sRGB' },
	'srhalfpresstime' => { 374 => 0x2 },
	'srresult' => { 374 => 0x0, 375 => 0x0 },
	'stackedimage' => { 314 => 0x804 },
	'standardmatrixcustom' => { 138 => 0x7d4 },
	'standardmatrixdaylight' => { 138 => 0x7d0 },
	'standardmatrixflash' => { 138 => 0x7d3 },
	'standardmatrixfluorescent' => { 138 => 0x7d2 },
	'standardmatrixtungsten' => { 138 => 0x7d1 },
	'standardoutputhighlightpoint' => { 109 => 0x14 },
	'standardoutputsensitivity' => { 119 => 0x8831, 503 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 109 => 0x15 },
	'standardrawcolortone' => { 109 => 0xd },
	'standardrawcontrast' => { 109 => 0xf },
	'standardrawhighlight' => { 109 => 0x75 },
	'standardrawhighlightpoint' => { 109 => 0x12 },
	'standardrawlinear' => { 109 => 0x10 },
	'standardrawsaturation' => { 109 => 0xe },
	'standardrawshadow' => { 109 => 0x7e },
	'standardrawshadowpoint' => { 109 => 0x13 },
	'standardrawsharpness' => { 109 => 0x11 },
	'standardunsharpmaskfineness' => { 109 => 0x94 },
	'standardunsharpmaskstrength' => { 109 => 0x92 },
	'standardunsharpmaskthreshold' => { 109 => 0x96 },
	'standardwhitecustom' => { 138 => 0x838 },
	'standardwhitedaylight' => { 138 => 0x834 },
	'standardwhiteflash' => { 138 => 0x837 },
	'standardwhitefluorescent' => { 138 => 0x836 },
	'standardwhitetungsten' => { 138 => 0x835 },
	'standbytimer' => { 297 => '19.1', 299 => '19.1', 300 => '19.1', 303 => '18.1', 304 => '18.1', 309 => '19.1', 310 => '19.1' },
	'starlightview' => { 312 => 0x249 },
	'startingpage' => { 515 => 'startingPage' },
	'startmovieshooting' => { 84 => 0x70d },
	'starttimecode' => { 397 => "\xa9TIM", 525 => 'startTimecode' },
	'starttimecodetimeformat' => { 525 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 525 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 525 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 397 => "\xa9TSZ", 525 => 'startTimeSampleSize' },
	'starttimescale' => { 397 => "\xa9TSC", 525 => 'startTimeScale' },
	'state' => { 161 => 'State', 337 => 0x6b, 513 => 'State' },
	'status' => { 477 => 'Status', 489 => 'Status' },
	'stereomode' => { 485 => 'StereoMode' },
	'stitched' => { 485 => 'Stitched' },
	'stitchingsoftware' => { 484 => 'StitchingSoftware', 485 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 446 => 0x113e, 447 => 0x113e, 448 => 0x111a, 449 => 0x1196, 450 => 0x1172, 451 => 0x102a, 452 => 0x222, 453 => 0x222, 454 => 0x217, 468 => 0xa },
	'storagemethod' => { 188 => 0x12 },
	'storebyorientation' => { 297 => '46.3', 299 => '47.3', 300 => '47.3', 309 => '47.3', 310 => '47.3', 312 => 0xd },
	'storedescription' => { 389 => 'sdes' },
	'storylineidentifier' => { 510 => 'StorylineIdentifier' },
	'straightenangle' => { 289 => 0x2fc08431 },
	'streamready' => { 510 => 'StreamReady' },
	'streamtype' => { 176 => 'StreamType' },
	'stretchmode' => { 525 => 'stretchMode' },
	'studydatetime' => { 474 => 'StudyDateTime' },
	'studydescription' => { 474 => 'StudyDescription' },
	'studyid' => { 474 => 'StudyID' },
	'studyphysician' => { 474 => 'StudyPhysician' },
	'styleperiod' => { 510 => 'StylePeriod' },
	'sub-location' => { 131 => 0x5c },
	'subcommanddialplaybackmode' => { 312 => 0x1cf },
	'subfiledata' => { 164 => 'data' },
	'subfiledirectory' => { 164 => '1Directory' },
	'subfilemimetype' => { 164 => '2MIME' },
	'subfilename' => { 164 => '1Name' },
	'subfileresource' => { 164 => 'rsrc' },
	'subfiletype' => { 119 => 0xfe, 164 => '0Type' },
	'subject' => { 323 => 'Subject', 388 => 'Subject', 499 => 'subject', 512 => 'Subject', 526 => 'subject' },
	'subjectarea' => { 119 => 0x9214, 502 => 'SubjectArea' },
	'subjectcode' => { 509 => 'SubjectCode' },
	'subjectdetection' => { 239 => 0x23e, 240 => 0x252, 241 => 0x252 },
	'subjectdistance' => { 119 => 0x9206, 140 => 0x3e, 502 => 'SubjectDistance' },
	'subjectdistancerange' => { 119 => 0xa40c, 502 => 'SubjectDistanceRange' },
	'subjectlocation' => { 119 => 0xa214, 502 => 'SubjectLocation' },
	'subjectmotion' => { 299 => '78.2', 300 => '78.2', 310 => '78.2', 312 => 0x103 },
	'subjectprogram' => { 181 => 0x22 },
	'subjectreference' => { 131 => 0xc },
	'sublabels1' => { 508 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 508 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 508 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 508 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 508 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 114 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 114 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 114 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 119 => 0x9290 },
	'subsectimedigitized' => { 119 => 0x9292 },
	'subsectimeoriginal' => { 119 => 0x9291 },
	'subsection1' => { 515 => 'subsection1' },
	'subsection2' => { 515 => 'subsection2' },
	'subsection3' => { 515 => 'subsection3' },
	'subsection4' => { 515 => 'subsection4' },
	'subselector' => { 297 => '49.1', 299 => '71.1', 300 => '71.1', 310 => '71.1', 312 => 0x8f },
	'subselectorassignment' => { 297 => '48.1' },
	'subselectorcenter' => { 299 => '72.1', 300 => '72.1', 310 => '72.1' },
	'subselectorplusdials' => { 297 => '49.2', 299 => '73.1', 300 => '73.1', 310 => '73.1' },
	'subtitle' => { 179 => 'WM/SubTitle', 389 => "\xa9st3", 397 => "\xa9snm", 515 => 'subtitle' },
	'subtitlekeywords' => { 397 => "\xa9snk" },
	'subversionfilename' => { 508 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 508 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 508 => 'SubVersions' },
	'superimposeddisplay' => { 82 => 0xa, 84 => 0x510, 85 => 0x9, 86 => 0xa, 89 => 0xa, 90 => 0xe },
	'supermacro' => { 64 => 0x1a },
	'supplementalcategories' => { 131 => 0x14, 513 => 'SupplementalCategories' },
	'supplementaltype' => { 133 => 0x37 },
	'supplementdisplayid' => { 515 => 'supplementDisplayID' },
	'supplementstartingpage' => { 515 => 'supplementStartingPage' },
	'supplementtitle' => { 515 => 'supplementTitle' },
	'supplychainsource' => { 510 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 510 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 510 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 496 => 'SupportsAmount', 498 => 'SupportsAmount' },
	'supportscolor' => { 496 => 'SupportsColor', 498 => 'SupportsColor' },
	'supportshighdynamicrange' => { 496 => 'SupportsHighDynamicRange', 498 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 496 => 'SupportsMonochrome', 498 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 496 => 'SupportsNormalDynamicRange', 498 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 496 => 'SupportsOutputReferred', 498 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 496 => 'SupportsSceneReferred', 498 => 'SupportsSceneReferred' },
	'svisosetting' => { 353 => 0x14 },
	'swatchcoloranta' => { 530 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 530 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 530 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 530 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 530 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 530 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 530 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 530 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 530 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 530 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 530 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 530 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 530 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 530 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 530 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 530 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 530 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 530 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 530 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 337 => 0x93, 426 => 0x33 },
	'sweeppanoramafieldofview' => { 337 => 0x94 },
	'sweeppanoramasize' => { 426 => 0x32 },
	'switchtoregisteredafpoint' => { 83 => 0x12, 84 => 0x50a },
	'symlink' => { 120 => 'SymLink' },
	'syncreleasemode' => { 299 => '77.1', 300 => '77.1', 310 => '77.1', 312 => 0x41 },
	'system' => { 381 => 0x204 },
	'tagged' => { 383 => 0xdd, 384 => 'Tagged', 491 => 'tagged' },
	'tagslist' => { 501 => 'TagsList' },
	'tagstructure' => { 508 => 'TagStructure' },
	'takenumber' => { 525 => 'takeNumber' },
	'tapename' => { 525 => 'tapeName' },
	'targetaperture' => { 77 => 0x4 },
	'targetcompressionratio' => { 95 => 0x1 },
	'targetdistancesetting' => { 97 => 0x1807 },
	'targetexposuretime' => { 77 => 0x5 },
	'targetimagetype' => { 97 => 0x100a },
	'targetprinter' => { 119 => 0x151 },
	'taxon' => { 118 => 'Taxon' },
	'taxonacceptednameusage' => { 118 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 118 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 118 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 118 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 118 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 118 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 118 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 118 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 118 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 118 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 118 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 118 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 118 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 118 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 118 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 118 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 118 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 118 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 118 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 118 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 118 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 118 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 118 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 118 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 118 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 118 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 118 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 118 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 118 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 118 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 118 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 118 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 118 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 118 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 138 => 0x196f },
	'tda1edgepolarity' => { 138 => 0x1971 },
	'tda1gain' => { 138 => 0x1970 },
	'tda1offset' => { 138 => 0x196e },
	'tda2bandwidth' => { 138 => 0x1979 },
	'tda2edgepolarity' => { 138 => 0x197b },
	'tda2gain' => { 138 => 0x197a },
	'tda2offset' => { 138 => 0x1978 },
	'tda3bandwidth' => { 138 => 0x1983 },
	'tda3edgepolarity' => { 138 => 0x1985 },
	'tda3gain' => { 138 => 0x1984 },
	'tda3offset' => { 138 => 0x1982 },
	'tda4bandwidth' => { 138 => 0x198d },
	'tda4edgepolarity' => { 138 => 0x198f },
	'tda4gain' => { 138 => 0x198e },
	'tda4offset' => { 138 => 0x198c },
	'teaser' => { 515 => 'teaser' },
	'teleconverter' => { 186 => 0x105, 437 => 0x105 },
	'tempampgainx100' => { 138 => 0x1914 },
	'tempo' => { 525 => 'tempo' },
	'temporalcoverage' => { 510 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 510 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 510 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 324 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 324 => 'TermsAndConditionsURL' },
	'testname' => { 120 => 'TestName' },
	'textencoding' => { 233 => 0x4 },
	'textlayername' => { 513 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 513 => 'TextLayers' },
	'textlayertext' => { 513 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 337 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 496 => 'Texture', 498 => 'Texture' },
	'three-dtrackingfacedetection' => { 299 => '1.4', 300 => '1.4', 310 => '1.4' },
	'three-dtrackingwatcharea' => { 299 => '78.1', 300 => '78.1', 310 => '78.1' },
	'thresholding' => { 119 => 0x107 },
	'thumbnailfilename' => { 97 => 0x817 },
	'thumbnailformat' => { 523 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 142 => 0xfa55, 523 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 97 => 0x2008, 114 => 'Exif-ThumbnailImage', 122 => 0x3, 167 => 'data', 319 => 0x100, 397 => 'thmb', 523 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 167 => '1Name' },
	'thumbnailimagesize' => { 167 => 'ImageSize' },
	'thumbnailimagetype' => { 167 => '0Type' },
	'thumbnailimagevalidarea' => { 64 => 0x13 },
	'thumbnaillength' => { 119 => 0x202 },
	'thumbnailoffset' => { 119 => 0x201 },
	'thumbnailpng' => { 397 => 'thmb' },
	'thumbnails' => { 523 => 'Thumbnails' },
	'thumbnailwidth' => { 142 => 0xfa54, 523 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 515 => 'ticker' },
	'tiffhandling' => { 496 => 'TIFFHandling', 498 => 'TIFFHandling' },
	'tiffmeteringimage' => { 187 => 0x104c, 435 => 0x1110 },
	'tilelength' => { 119 => 0x143 },
	'tilewidth' => { 119 => 0x142 },
	'time' => { 138 => 0x401, 372 => 0x7 },
	'timecodes' => { 119 => 0xc763 },
	'timecreated' => { 131 => 0x3c, 140 => 0x14, 149 => 0x10, 384 => 'TimeCreated' },
	'timelapseshotnumber' => { 340 => 0x10 },
	'timeperiod' => { 515 => 'timePeriod' },
	'timerfunctionbutton' => { 298 => '5.2', 301 => '12.1', 302 => '13.1' },
	'timerlength' => { 84 => 0x80c },
	'timerrecording' => { 337 => 0x96 },
	'timescaleparams' => { 525 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 525 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 525 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 525 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 132 => 0x50 },
	'timeshot' => { 486 => 'TimeShot' },
	'timesignature' => { 525 => 'timeSignature' },
	'timesincepoweron' => { 337 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 313 => 0x8, 327 => 'TimeStamp', 337 => 0xaf, 485 => 'Timestamp', 492 => 'Timestamp', 508 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 78 => 0x1, 239 => 0x594, 240 => 0x5c4, 241 => 0x5c4, 281 => 0x0, 407 => 0xa },
	'timezonecity' => { 78 => 0x2 },
	'timezonecode' => { 100 => 0x1 },
	'timezoneinfo' => { 100 => 0x2 },
	'timezoneoffset' => { 119 => 0x882a },
	'tint' => { 391 => 'player.movie.visual.tint', 496 => 'Tint', 498 => 'Tint' },
	'title' => { 119 => 0xa436, 157 => 'Title', 323 => 'Title', 327 => 'Title', 337 => 0x65, 388 => 'Title', 389 => ['titl',"\xa9nam"], 391 => 'title', 397 => ['titl',"\xa9nam"], 499 => 'title', 512 => 'Title', 523 => 'Title' },
	'togglestyleamount' => { 496 => 'ToggleStyleAmount', 498 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 496 => 'ToggleStyleDigest', 498 => 'ToggleStyleDigest' },
	'tonecomp' => { 234 => 0x81 },
	'tonecurve' => { 74 => 0x1, 372 => 0x402, 496 => 'ToneCurve', 498 => 'ToneCurve' },
	'tonecurveactive' => { 108 => 0x110 },
	'tonecurveadobergb' => { 411 => 0xa043 },
	'tonecurveadobergbdefault' => { 411 => 0xa041 },
	'tonecurveblue' => { 496 => 'ToneCurveBlue', 498 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 472 => 0x9003 },
	'tonecurvebluey' => { 472 => 0x9007 },
	'tonecurvebrightness' => { 103 => 0x20410 },
	'tonecurvebrightnessx' => { 472 => 0x9000 },
	'tonecurvebrightnessy' => { 472 => 0x9004 },
	'tonecurvecolorspace' => { 107 => 0x0 },
	'tonecurvecontrast' => { 103 => 0x20411 },
	'tonecurvegreen' => { 496 => 'ToneCurveGreen', 498 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 472 => 0x9002 },
	'tonecurvegreeny' => { 472 => 0x9006 },
	'tonecurveinputrange' => { 107 => 0x3 },
	'tonecurveinterpolation' => { 108 => 0x159 },
	'tonecurvemode' => { 108 => 0x113 },
	'tonecurvename' => { 496 => 'ToneCurveName', 498 => 'ToneCurveName' },
	'tonecurvename2012' => { 496 => 'ToneCurveName2012', 498 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 103 => '0x20400.1' },
	'tonecurveoutputrange' => { 107 => 0x5 },
	'tonecurveprofilename' => { 138 => 0x1391 },
	'tonecurveproperty' => { 108 => 0x3c },
	'tonecurvepv2012' => { 496 => 'ToneCurvePV2012', 498 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 496 => 'ToneCurvePV2012Blue', 498 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 496 => 'ToneCurvePV2012Green', 498 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 496 => 'ToneCurvePV2012Red', 498 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 496 => 'ToneCurveRed', 498 => 'ToneCurveRed' },
	'tonecurveredx' => { 472 => 0x9001 },
	'tonecurveredy' => { 472 => 0x9005 },
	'tonecurves' => { 372 => 0x403 },
	'tonecurveshape' => { 107 => 0x1 },
	'tonecurvesrgb' => { 411 => 0xa042 },
	'tonecurvesrgbdefault' => { 411 => 0xa040 },
	'tonecurvex' => { 107 => 0xa },
	'tonecurvey' => { 107 => 0xb },
	'tonelevel' => { 314 => 0x52e },
	'tonemapstrength' => { 496 => 'ToneMapStrength', 498 => 'ToneMapStrength' },
	'toningeffect' => { 57 => 0xf, 234 => 0xb3, 248 => 0x38, 249 => 0x40, 250 => 0x48, 404 => 0x1015 },
	'toningeffectauto' => { 71 => 0xa4 },
	'toningeffectfaithful' => { 70 => 0x74, 71 => 0x74 },
	'toningeffectlandscape' => { 70 => 0x44, 71 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 70 => 0x8c, 71 => 0x8c },
	'toningeffectneutral' => { 70 => 0x5c, 71 => 0x5c },
	'toningeffectportrait' => { 70 => 0x2c, 71 => 0x2c },
	'toningeffectstandard' => { 70 => 0x14, 71 => 0x14 },
	'toningeffectuserdef1' => { 70 => 0xa4, 71 => 0xbc },
	'toningeffectuserdef2' => { 70 => 0xbc, 71 => 0xd4 },
	'toningeffectuserdef3' => { 70 => 0xd4, 71 => 0xec },
	'toningsaturation' => { 248 => 0x39, 249 => 0x41, 250 => 0x49 },
	'totalzoom' => { 140 => 0x62 },
	'touchae' => { 337 => 0xab },
	'track' => { 389 => "\xa9trk", 397 => "\xa9trk" },
	'trackcreatedate' => { 396 => 0x1 },
	'trackmodifydate' => { 396 => 0x2 },
	'tracknumber' => { 389 => 'trkn', 525 => 'trackNumber' },
	'tracks' => { 525 => 'Tracks' },
	'tracksframerate' => { 525 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 525 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 525 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 525 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 525 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 525 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 525 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 525 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 525 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 525 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 525 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 525 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 525 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 525 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 525 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 525 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 525 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 397 => 'kgtt' },
	'trailer' => { 120 => 'Trailer' },
	'trailersignature' => { 164 => 'zmie' },
	'transcript' => { 510 => 'Transcript' },
	'transcriptlink' => { 510 => 'TranscriptLink' },
	'transcriptlinklink' => { 510 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 510 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 119 => 0x12d, 521 => 'TransferFunction' },
	'transfertimenormal' => { 138 => 0x1888 },
	'transfertimetest' => { 138 => 0x1889 },
	'transform' => { 337 => [0x8012,0x59] },
	'transformation' => { 511 => 'Transformation' },
	'transmissionreference' => { 513 => 'TransmissionReference' },
	'trapped' => { 323 => 'Trapped', 512 => 'Trapped' },
	'trashbuttonfunction' => { 84 => 0x710 },
	'travelday' => { 337 => 0x36 },
	'treble' => { 391 => 'player.movie.audio.treble' },
	'triggermode' => { 398 => 0x6, 399 => 0x34, 400 => 0x34 },
	'tstop' => { 119 => 0xc772 },
	'ttl_da_adown' => { 360 => 0x5 },
	'ttl_da_aup' => { 360 => 0x4 },
	'ttl_da_bdown' => { 360 => 0x7 },
	'ttl_da_bup' => { 360 => 0x6 },
	'tungstenawb' => { 350 => 0x1 },
	'tvepisode' => { 389 => 'tves' },
	'tvepisodeid' => { 389 => 'tven' },
	'tvexposuretimesetting' => { 353 => 0x12 },
	'tvnetworkname' => { 389 => 'tvnn' },
	'tvseason' => { 389 => 'tvsn' },
	'tvshow' => { 389 => 'tvsh' },
	'type' => { 480 => 'Type', 499 => 'type', 520 => 'type' },
	'typestatus' => { 118 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 119 => 0xc614 },
	'uniquedocumentid' => { 131 => 0xbb },
	'uniquematrixauto' => { 138 => 0x7e9 },
	'uniquematrixcustom' => { 138 => 0x7e8 },
	'uniquematrixdaylight' => { 138 => 0x7e4 },
	'uniquematrixflash' => { 138 => 0x7e7 },
	'uniquematrixfluorescent' => { 138 => 0x7e6 },
	'uniquematrixtungsten' => { 138 => 0x7e5 },
	'uniqueobjectname' => { 132 => 0x64 },
	'units' => { 481 => 'Units' },
	'unknown_aacr' => { 389 => 'AACR' },
	'unknown_cdek' => { 389 => 'CDEK' },
	'unknown_cdet' => { 389 => 'CDET' },
	'unknownblock' => { 372 => 0x405 },
	'unknownblock1' => { 318 => 0x635 },
	'unknownblock2' => { 318 => 0x636 },
	'unknownblock3' => { 318 => 0x1103 },
	'unknownblock4' => { 318 => 0x1104 },
	'unknowncontrast' => { 109 => 0x45 },
	'unknowndate' => { 381 => 0x212 },
	'unknownev' => { 138 => 0x1 },
	'unknownlinear' => { 109 => 0x46 },
	'unknownnumber' => { 97 => 0x180b },
	'unknownoutputhighlightpoint' => { 109 => 0x4a },
	'unknownoutputshadowpoint' => { 109 => 0x4b },
	'unknownrawhighlight' => { 109 => 0x7b },
	'unknownrawhighlightpoint' => { 109 => 0x48 },
	'unknownrawshadow' => { 109 => 0x84 },
	'unknownrawshadowpoint' => { 109 => 0x49 },
	'unknownsharpness' => { 109 => 0x47 },
	'unknowntags' => { 397 => 'TAGS' },
	'unknowntemperature' => { 121 => 0x4 },
	'unknownthumbnail' => { 397 => 'thmb' },
	'unsharp1color' => { 294 => 0x13 },
	'unsharp1halowidth' => { 294 => 0x19 },
	'unsharp1intensity' => { 294 => 0x17 },
	'unsharp1threshold' => { 294 => 0x1b },
	'unsharp2color' => { 294 => 0x2e },
	'unsharp2halowidth' => { 294 => 0x34 },
	'unsharp2intensity' => { 294 => 0x32 },
	'unsharp2threshold' => { 294 => 0x36 },
	'unsharp3color' => { 294 => 0x49 },
	'unsharp3halowidth' => { 294 => 0x4f },
	'unsharp3intensity' => { 294 => 0x4d },
	'unsharp3threshold' => { 294 => 0x51 },
	'unsharp4color' => { 294 => 0x64 },
	'unsharp4halowidth' => { 294 => 0x6a },
	'unsharp4intensity' => { 294 => 0x68 },
	'unsharp4threshold' => { 294 => 0x6c },
	'unsharpcount' => { 294 => 0x0 },
	'unsharpmask' => { 109 => 0x90, 289 => 0x76a43200 },
	'unsharpmaskfineness' => { 103 => 0x20309 },
	'unsharpmaskstrength' => { 103 => 0x20308 },
	'unsharpmaskthreshold' => { 103 => 0x2030a },
	'uprightcentermode' => { 496 => 'UprightCenterMode', 498 => 'UprightCenterMode' },
	'uprightcenternormx' => { 496 => 'UprightCenterNormX', 498 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 496 => 'UprightCenterNormY', 498 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 496 => 'UprightDependentDigest', 498 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 496 => 'UprightFocalLength35mm', 498 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 496 => 'UprightFocalMode', 498 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 496 => 'UprightFourSegments_0', 498 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 496 => 'UprightFourSegments_1', 498 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 496 => 'UprightFourSegments_2', 498 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 496 => 'UprightFourSegments_3', 498 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 496 => 'UprightFourSegmentsCount', 498 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 496 => 'UprightGuidedDependentDigest', 498 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 496 => 'UprightPreview', 498 => 'UprightPreview' },
	'uprighttransform_0' => { 496 => 'UprightTransform_0', 498 => 'UprightTransform_0' },
	'uprighttransform_1' => { 496 => 'UprightTransform_1', 498 => 'UprightTransform_1' },
	'uprighttransform_2' => { 496 => 'UprightTransform_2', 498 => 'UprightTransform_2' },
	'uprighttransform_3' => { 496 => 'UprightTransform_3', 498 => 'UprightTransform_3' },
	'uprighttransform_4' => { 496 => 'UprightTransform_4', 498 => 'UprightTransform_4' },
	'uprighttransform_5' => { 496 => 'UprightTransform_5', 498 => 'UprightTransform_5' },
	'uprighttransformcount' => { 496 => 'UprightTransformCount', 498 => 'UprightTransformCount' },
	'uprightversion' => { 496 => 'UprightVersion', 498 => 'UprightVersion' },
	'urgency' => { 131 => 0xa, 513 => 'Urgency' },
	'url' => { 157 => 'URL', 327 => 'URL', 386 => 0x40b, 515 => 'url' },
	'url_list' => { 386 => 0x41e },
	'urla-platform' => { 515 => [\'url','urlA-platform'] },
	'urlurl' => { 515 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 84 => 0x10a },
	'usableshootingmodes' => { 84 => 0x109 },
	'usage' => { 516 => 'usage' },
	'usageterms' => { 529 => 'UsageTerms' },
	'usbpowerdelivery' => { 239 => 0x664, 240 => 0x694, 241 => 0x6fc },
	'usedialwithouthold' => { 312 => 0xbf },
	'useguidelines' => { 494 => 'useGuidelines' },
	'usepanoramaviewer' => { 484 => 'UsePanoramaViewer' },
	'usercollection' => { 391 => 'collection.user' },
	'usercomment' => { 97 => 0x805, 119 => 0x9286, 502 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 70 => 0xd8, 71 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 70 => 0xda, 71 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 70 => 0xdc, 71 => 0xf4 },
	'userfields' => { 489 => 'UserFields' },
	'userlabel' => { 398 => 0x2b, 399 => 0x5a, 400 => 0x68 },
	'userprofile' => { 332 => 0x302, 336 => 0x34c, 339 => 0x3038 },
	'userrating' => { 391 => 'rating.user', 397 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 83 => 0x7, 84 => 0x501 },
	'uspsnumber' => { 515 => 'uspsNumber' },
	'utmeasting' => { 168 => 'Easting' },
	'utmmapdatum' => { 168 => 'Datum' },
	'utmnorthing' => { 168 => 'Northing' },
	'utmzone' => { 168 => 'Zone' },
	'uuid' => { 496 => 'UUID', 498 => 'UUID' },
	'uv-irfiltercorrection' => { 332 => 0x325 },
	'validbits' => { 318 => 0x611, 319 => 0x102c },
	'validpixeldepth' => { 322 => 0x611 },
	'variablelowpassfilter' => { 437 => 0x2028 },
	'variousmodes' => { 140 => 0x26 },
	'variousmodes2' => { 140 => 0x3a },
	'variprogram' => { 234 => 0xab },
	'varraydacnominalvalues' => { 138 => 0x191e },
	'vendor' => { 397 => 'vndr' },
	'vendorinfo' => { 475 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 475 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 475 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 475 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 118 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 127 => 0x0, 388 => 'Version', 391 => 'version', 496 => 'Version', 498 => 'Version', 507 => 'Version' },
	'versioncreatedate' => { 472 => 0xd100 },
	'versionid' => { 526 => 'VersionID' },
	'versionidentifier' => { 515 => 'versionIdentifier' },
	'versionmodifydate' => { 472 => 0xd101 },
	'versions' => { 526 => 'Versions' },
	'versionscomments' => { 526 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 526 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 526 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 526 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 526 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 526 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 526 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 526 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 526 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 526 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 526 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 296 => '3.2', 297 => '47.2', 299 => '79.1', 312 => 0x11d },
	'verticalclockoverlaps' => { 138 => 0x412 },
	'verticalfuncbutton' => { 297 => '42.2', 299 => '67.1', 312 => 0x115 },
	'verticalfuncbuttonplaybackmode' => { 312 => 0x1b7 },
	'verticalfuncbuttonplusdials' => { 297 => '43.1' },
	'verticalfuncplusdials' => { 299 => '68.1' },
	'verticalisobutton' => { 241 => 0x792 },
	'verticalmovieafonbutton' => { 312 => 0x1f9 },
	'verticalmoviefuncbutton' => { 312 => 0x1e1 },
	'verticalmultiselector' => { 297 => '42.1', 299 => '66.1', 300 => '66.1', 310 => '66.1', 312 => 0x18f },
	'verticalmultiselectorplaybackmode' => { 312 => 0x125 },
	'vfdisplayillumination' => { 2 => 0x11, 84 => [0x510,0x51d] },
	'vibrance' => { 490 => 'Vibrance', 496 => 'Vibrance', 498 => 'Vibrance' },
	'vibrationreduction' => { 261 => [0x75,0x82,0x1ae], 269 => '586.1', 276 => '590.2', 280 => 0x4 },
	'videoalphamode' => { 525 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 525 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 525 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 525 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 525 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 525 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 525 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 525 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 525 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 525 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 525 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 525 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 525 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 525 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 525 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 525 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 525 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 525 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 510 => 'videoBitRate' },
	'videobitratemode' => { 510 => 'videoBitRateMode' },
	'videoburstmode' => { 337 => 0xbb },
	'videoburstresolution' => { 337 => 0xb3 },
	'videocodec' => { 67 => 0x74 },
	'videocolorspace' => { 525 => 'videoColorSpace' },
	'videocompression' => { 127 => 0x3806 },
	'videocompressor' => { 525 => 'videoCompressor' },
	'videodisplayaspectratio' => { 510 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 510 => 'videoEncodingProfile' },
	'videofieldorder' => { 525 => 'videoFieldOrder' },
	'videoframerate' => { 337 => 0x27, 525 => 'videoFrameRate' },
	'videoframesize' => { 525 => 'videoFrameSize' },
	'videoframesizeh' => { 525 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 525 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 525 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 525 => 'videoModDate' },
	'videopixelaspectratio' => { 525 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 525 => 'videoPixelDepth' },
	'videopreburst' => { 337 => 0xc1 },
	'videoquality' => { 113 => 0x4003 },
	'videorecordingmode' => { 127 => 0x3803 },
	'videoshottype' => { 510 => 'VideoShotType' },
	'videoshottypeidentifier' => { 510 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 510 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 510 => 'videoStreamsCount' },
	'viewfinder' => { 381 => 0x455 },
	'viewfinderdisplay' => { 296 => '12.4', 297 => '6.3' },
	'viewfinderwarning' => { 296 => '13.4', 306 => '3.5', 307 => '6.2', 311 => '4.4' },
	'viewfinderwarnings' => { 84 => 0x40a },
	'viewinfoduringexposure' => { 84 => 0x407 },
	'viewingmode' => { 426 => 0x2f, 442 => 0x18 },
	'viewingmode2' => { 426 => [0x85,0x285] },
	'viewmodeshoweffectsofsettings' => { 241 => 0x7d2 },
	'viewpoint' => { 514 => 'viewpoint' },
	'vignetteamount' => { 496 => 'VignetteAmount', 498 => 'VignetteAmount' },
	'vignettecontrol' => { 234 => 0x2a, 289 => 0x76a43205 },
	'vignettecontrolintensity' => { 289 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 493 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 496 => 'VignetteMidpoint', 498 => 'VignetteMidpoint' },
	'vignetting' => { 404 => 0x1011, 411 => 0xa052 },
	'vignettingcorrection' => { 119 => 0x7031, 411 => 0xa053, 437 => 0x2011 },
	'vignettingcorrparams' => { 119 => 0x7032, 467 => 0x64a, 468 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 411 => 0xa054 },
	'virtualfocallength' => { 511 => 'VirtualFocalLength' },
	'virtualhorizonstyle' => { 312 => 0x167 },
	'virtualimagexcenter' => { 511 => 'VirtualImageXCenter' },
	'virtualimageycenter' => { 511 => 'VirtualImageYCenter' },
	'visualcolor' => { 510 => 'VisualColour' },
	'visualtechnique' => { 514 => 'visualTechnique' },
	'voicememo' => { 413 => 0x216 },
	'volume' => { 515 => 'volume' },
	'vr_0x66' => { 261 => 0x66 },
	'vrdoffset' => { 64 => 0xd0 },
	'vrmode' => { 239 => 0x212, 240 => 0x226, 241 => 0x226, 280 => 0x6 },
	'vrtype' => { 280 => 0x8 },
	'waterdepth' => { 119 => 0x9403, 503 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 187 => 0x19a },
	'wb_bluelevel6500k' => { 187 => 0x18a },
	'wb_bluelevelcustom' => { 187 => 0x18e },
	'wb_bluelevelscloudy' => { 187 => 0x106 },
	'wb_bluelevelsdaylight' => { 187 => 0xea },
	'wb_bluelevelsflash' => { 187 => 0x122 },
	'wb_bluelevelsfluorescent' => { 187 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 187 => 0x254 },
	'wb_bluelevelsshade' => { 187 => 0x176 },
	'wb_bluelevelstungsten' => { 187 => 0xce },
	'wb_gbrglevels' => { 187 => 0xae, 190 => 0x4 },
	'wb_glevel' => { 318 => 0x11f },
	'wb_glevel3000k' => { 318 => 0x113 },
	'wb_glevel3300k' => { 318 => 0x114 },
	'wb_glevel3600k' => { 318 => 0x115 },
	'wb_glevel3900k' => { 318 => 0x116 },
	'wb_glevel4000k' => { 318 => 0x117 },
	'wb_glevel4300k' => { 318 => 0x118 },
	'wb_glevel4500k' => { 318 => 0x119 },
	'wb_glevel4800k' => { 318 => 0x11a },
	'wb_glevel5300k' => { 318 => 0x11b },
	'wb_glevel6000k' => { 318 => 0x11c },
	'wb_glevel6600k' => { 318 => 0x11d },
	'wb_glevel7500k' => { 318 => 0x11e },
	'wb_grbglevels' => { 204 => 0x0, 444 => 0x7303 },
	'wb_grbglevelsauto' => { 81 => 0x2, 444 => 0x7302 },
	'wb_grbglevelscloudy' => { 81 => 0x12 },
	'wb_grbglevelscustom1' => { 81 => 0x42 },
	'wb_grbglevelscustom2' => { 81 => 0x4a },
	'wb_grbglevelsdaylight' => { 81 => 0xa },
	'wb_grbglevelsflash' => { 81 => 0x32 },
	'wb_grbglevelsfluorescent' => { 81 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 81 => 0x2a },
	'wb_grbglevelstungsten' => { 81 => 0x1a },
	'wb_grbglevelsunderwater' => { 81 => 0x3a },
	'wb_rbgglevels' => { 201 => 0x0 },
	'wb_rblevels' => { 205 => 0x270, 234 => 0xc, 318 => 0x100 },
	'wb_rblevels1' => { 343 => 0x2 },
	'wb_rblevels2' => { 343 => 0x5 },
	'wb_rblevels3' => { 343 => 0x8 },
	'wb_rblevels3000k' => { 318 => 0x102 },
	'wb_rblevels3300k' => { 318 => 0x103 },
	'wb_rblevels3500k' => { 187 => 0x430 },
	'wb_rblevels3600k' => { 318 => 0x104 },
	'wb_rblevels3900k' => { 318 => 0x105 },
	'wb_rblevels4' => { 343 => 0xb },
	'wb_rblevels4000k' => { 318 => 0x106 },
	'wb_rblevels4300k' => { 318 => 0x107 },
	'wb_rblevels4500k' => { 318 => 0x108 },
	'wb_rblevels4800k' => { 318 => 0x109 },
	'wb_rblevels5' => { 343 => 0xe },
	'wb_rblevels5300k' => { 318 => 0x10a },
	'wb_rblevels6' => { 343 => 0x11 },
	'wb_rblevels6000k' => { 318 => 0x10b },
	'wb_rblevels6500k' => { 187 => 0x420 },
	'wb_rblevels6600k' => { 318 => 0x10c },
	'wb_rblevels7' => { 343 => 0x14 },
	'wb_rblevels7500k' => { 318 => 0x10d },
	'wb_rblevelsauto' => { 205 => 0x272, 322 => 0x110 },
	'wb_rblevelscloudy' => { 187 => 0x3f0, 189 => 0x10, 205 => 0x296, 322 => 0x121 },
	'wb_rblevelscoolwhitef' => { 187 => 0x308, 189 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 322 => 0x132 },
	'wb_rblevelscustom' => { 187 => 0x424, 189 => 0x1c },
	'wb_rblevelscwb1' => { 318 => 0x10e },
	'wb_rblevelscwb2' => { 318 => 0x10f },
	'wb_rblevelscwb3' => { 318 => 0x110 },
	'wb_rblevelscwb4' => { 318 => 0x111 },
	'wb_rblevelsdaylight' => { 187 => [0x3ec,0x528], 189 => 0xc, 205 => 0x274 },
	'wb_rblevelsdaylightf' => { 189 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 322 => 0x130 },
	'wb_rblevelsdaywhitef' => { 189 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 322 => 0x131 },
	'wb_rblevelseveningsunlight' => { 322 => 0x124 },
	'wb_rblevelsfineweather' => { 322 => 0x122 },
	'wb_rblevelsflash' => { 187 => [0x3f4,0x304], 189 => 0x18, 205 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 205 => 0x290 },
	'wb_rblevelsincandescent' => { 205 => 0x282 },
	'wb_rblevelsshade' => { 187 => 0x418, 189 => 0x20, 205 => 0x2b2, 322 => 0x120 },
	'wb_rblevelstungsten' => { 187 => 0x3e8, 189 => 0x8, 322 => 0x123 },
	'wb_rblevelsused' => { 322 => 0x100 },
	'wb_rblevelswhitef' => { 189 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 322 => 0x133 },
	'wb_redlevel3500k' => { 187 => 0x198 },
	'wb_redlevel6500k' => { 187 => 0x188 },
	'wb_redlevelcustom' => { 187 => 0x18c },
	'wb_redlevelscloudy' => { 187 => 0xf8 },
	'wb_redlevelsdaylight' => { 187 => 0xdc },
	'wb_redlevelsflash' => { 187 => 0x114 },
	'wb_redlevelsfluorescent' => { 187 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 187 => 0x1be },
	'wb_redlevelsshade' => { 187 => 0x168 },
	'wb_redlevelstungsten' => { 187 => 0xc0 },
	'wb_rgbglevels' => { 203 => 0x0 },
	'wb_rgblevels' => { 187 => [0x546,0x96], 333 => 0xd, 334 => 0x413, 339 => 0x3036, 381 => 0x107, 446 => 0x117c, 447 => 0x1180, 448 => 0x115c, 449 => 0x11d8, 450 => 0x11b4, 451 => 0x106c, 452 => 0x264, 453 => 0x264, 454 => 0x252 },
	'wb_rgblevels1' => { 344 => 0x2 },
	'wb_rgblevels2' => { 344 => 0x6 },
	'wb_rgblevels2500k' => { 444 => 0x782d },
	'wb_rgblevels3' => { 344 => 0xa },
	'wb_rgblevels3200k' => { 444 => 0x782c },
	'wb_rgblevels4' => { 344 => 0xe },
	'wb_rgblevels4500k' => { 444 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 344 => 0x12 },
	'wb_rgblevels6' => { 344 => 0x16 },
	'wb_rgblevels6000k' => { 444 => 0x782b },
	'wb_rgblevels7' => { 344 => 0x1a },
	'wb_rgblevels8500k' => { 444 => 0x782a },
	'wb_rgblevelsauto' => { 415 => 0x0 },
	'wb_rgblevelscloudy' => { 444 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 415 => 0x15 },
	'wb_rgblevelscustom2' => { 415 => 0x18 },
	'wb_rgblevelscustom3' => { 415 => 0x1b },
	'wb_rgblevelsdaylight' => { 415 => 0x3, 444 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 415 => 0x12, 444 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 415 => 0xf, 444 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 444 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 444 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 444 => 0x7828 },
	'wb_rgblevelsincandescent' => { 415 => 0xc },
	'wb_rgblevelsovercast' => { 415 => 0x9 },
	'wb_rgblevelsshade' => { 415 => 0x6, 444 => 0x7825 },
	'wb_rgblevelstungsten' => { 444 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 416 => 0x0 },
	'wb_rgblevelsunknown1' => { 416 => 0x3 },
	'wb_rgblevelsunknown2' => { 416 => 0x6 },
	'wb_rgblevelsunknown3' => { 416 => 0x9 },
	'wb_rgblevelsunknown4' => { 416 => 0xc },
	'wb_rgblevelsunknown5' => { 416 => 0xf },
	'wb_rgblevelsunknown6' => { 416 => 0x12 },
	'wb_rgblevelsunknown7' => { 416 => 0x15 },
	'wb_rgblevelsunknown8' => { 416 => 0x18 },
	'wb_rgblevelsunknown9' => { 416 => 0x1b },
	'wb_rgbmuldaylight' => { 138 => 0x852 },
	'wb_rgbmulflash' => { 138 => 0x855 },
	'wb_rgbmulfluorescent' => { 138 => 0x854 },
	'wb_rgbmultungsten' => { 138 => 0x853 },
	'wb_rggbblacklevels' => { 35 => 0x25 },
	'wb_rggblevels' => { 119 => 0x7313, 190 => 0x4, 202 => 0x0, 206 => 0x13e8, 207 => 0x38, 444 => 0x7313 },
	'wb_rggblevelsasshot' => { 38 => 0x0, 39 => 0x0, 40 => 0x19, 41 => 0x55, 42 => 0x69, 43 => 0x22, 44 => 0x3f, 47 => 0x3f, 48 => 0x3f, 49 => 0x3f, 50 => 0x47 },
	'wb_rggblevelsauto' => { 35 => 0x1, 38 => 0x5, 39 => 0x8, 40 => 0x1e, 41 => 0x5a, 42 => 0x6e, 43 => 0x18, 44 => 0x44, 47 => 0x44, 48 => 0x44, 49 => 0x44, 50 => 0x4c, 206 => 0x1478, 207 => 0x114, 411 => 0xa022, 444 => 0x7312 },
	'wb_rggblevelsblack' => { 411 => 0xa028 },
	'wb_rggblevelscloudy' => { 35 => 0xd, 38 => 0x1e, 39 => 0x30, 40 => 0x2d, 41 => 0xa0, 42 => 0xd7, 43 => 0x31, 44 => 0x58, 47 => 0x71, 48 => 0x8a, 49 => 0x8f, 50 => 0x92, 206 => 0x1408, 207 => 0x60, 372 => 0x20f, 380 => 0x14 },
	'wb_rggblevelscustom' => { 35 => 0x1d, 44 => 0x80, 206 => 0x1468, 207 => 0x100 },
	'wb_rggblevelscustom1' => { 40 => 0x41 },
	'wb_rggblevelscustom2' => { 40 => 0x46 },
	'wb_rggblevelsdaylight' => { 35 => 0x5, 38 => 0x14, 39 => 0x20, 40 => 0x23, 41 => 0x96, 42 => 0xcd, 43 => 0x27, 44 => 0x4e, 47 => 0x67, 48 => 0x80, 49 => 0x85, 50 => 0x88, 206 => 0x13f8, 207 => 0x4c, 372 => 0x20d, 380 => 0x2 },
	'wb_rggblevelsflash' => { 35 => 0x19, 38 => 0x32, 39 => 0x50, 40 => 0x3c, 41 => 0xb4, 42 => 0xeb, 43 => 0x45, 44 => 0x6c, 47 => 0x85, 48 => 0x9e, 49 => 0xa3, 50 => 0xa6, 206 => 0x1448, 372 => 0x214, 380 => 0x41 },
	'wb_rggblevelsfluorescent' => { 35 => 0x15, 38 => 0x28, 39 => 0x40, 40 => 0x37, 41 => 0xaa, 42 => 0xe1, 43 => 0x3b, 44 => 0x62, 47 => 0x7b, 48 => 0x94, 49 => 0x99, 50 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 207 => 0xc4, 372 => 0x211, 380 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 380 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 207 => 0xb0, 372 => 0x212, 380 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 206 => 0x1438, 207 => 0x9c, 372 => 0x213, 380 => 0x38 },
	'wb_rggblevelshtmercury' => { 207 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 411 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 411 => 0xa024 },
	'wb_rggblevelskelvin' => { 35 => 0x21, 38 => 0x2d, 39 => 0x48, 41 => 0xaf, 42 => 0xe6, 43 => 0x40, 44 => 0x67, 47 => 0x80, 48 => 0x99, 49 => 0x9e, 50 => 0xa1 },
	'wb_rggblevelsmeasured' => { 38 => 0xa, 39 => 0x10, 41 => 0x5f, 42 => 0x73, 44 => 0x49, 47 => 0x49, 48 => 0x49, 49 => 0x49, 50 => 0x51 },
	'wb_rggblevelspc1' => { 43 => 0x90, 44 => 0x71 },
	'wb_rggblevelspc2' => { 43 => 0x95, 44 => 0x76 },
	'wb_rggblevelspc3' => { 43 => 0x9a, 44 => 0x7b },
	'wb_rggblevelsshade' => { 35 => 0x9, 38 => 0x19, 39 => 0x28, 40 => 0x28, 41 => 0x9b, 42 => 0xd2, 43 => 0x2c, 44 => 0x53, 47 => 0x6c, 48 => 0x85, 49 => 0x8a, 50 => 0x8d, 207 => 0x74, 372 => 0x20e, 380 => 0xb },
	'wb_rggblevelstungsten' => { 35 => 0x11, 38 => 0x23, 39 => 0x38, 40 => 0x32, 41 => 0xa5, 42 => 0xdc, 43 => 0x36, 44 => 0x5d, 47 => 0x76, 48 => 0x8f, 49 => 0x94, 50 => 0x97, 206 => 0x1428, 207 => 0x88, 372 => 0x210, 380 => 0x1d },
	'wb_rggblevelsuncorrected' => { 411 => 0xa021 },
	'wb_rggblevelsunknown' => { 38 => 0xf, 39 => 0x18, 41 => 0x64, 42 => 0x78, 43 => 0x1d, 47 => 0x4e, 48 => 0x4e, 49 => 0x4e, 50 => 0x56, 380 => 0x53 },
	'wb_rggblevelsunknown10' => { 38 => 0x5f, 39 => 0x98, 41 => 0x91, 42 => 0xa5, 43 => 0x72, 47 => 0x9e, 48 => 0x7b, 49 => 0x7b, 50 => 0x83 },
	'wb_rggblevelsunknown11' => { 38 => 0x64, 39 => 0xa0, 41 => 0xb9, 42 => [0xaa,0xaf], 43 => 0x77, 47 => 0xa3, 48 => 0xa3, 49 => 0x80, 50 => 0xab },
	'wb_rggblevelsunknown12' => { 38 => 0x69, 39 => 0xa8, 41 => 0xbe, 42 => 0xb4, 43 => 0x7c, 47 => 0xa8, 48 => 0xa8, 49 => 0xa8, 50 => 0xb0 },
	'wb_rggblevelsunknown13' => { 38 => 0x6e, 39 => 0xb0, 41 => 0xc3, 42 => 0xb9, 43 => 0x81, 47 => 0xad, 48 => 0xad, 49 => 0xad, 50 => 0xb5 },
	'wb_rggblevelsunknown14' => { 41 => 0xc8, 42 => 0xbe, 43 => 0x86, 47 => 0xb2, 48 => 0xb2, 49 => 0xb2, 50 => 0xba },
	'wb_rggblevelsunknown15' => { 41 => 0xcd, 42 => 0xc3, 43 => 0x8b, 47 => 0xb7, 48 => 0xb7, 49 => 0xb7, 50 => 0xbf },
	'wb_rggblevelsunknown16' => { 41 => 0xd2, 42 => 0xc8, 43 => 0x9f, 48 => 0xbc, 49 => 0xbc, 50 => 0xc4 },
	'wb_rggblevelsunknown17' => { 41 => 0xd7, 42 => 0xf0, 48 => 0xc1, 49 => 0xc1, 50 => 0xc9 },
	'wb_rggblevelsunknown18' => { 41 => 0xdc, 42 => 0xf5, 48 => 0xc6, 49 => 0xc6, 50 => 0xce },
	'wb_rggblevelsunknown19' => { 41 => 0xe1, 42 => 0xfa, 48 => 0xcb, 49 => 0xcb, 50 => 0xd3 },
	'wb_rggblevelsunknown2' => { 38 => 0x37, 39 => 0x58, 41 => 0x69, 42 => 0x7d, 43 => 0x4a, 47 => 0x53, 48 => 0x53, 49 => 0x53, 50 => 0x5b },
	'wb_rggblevelsunknown20' => { 41 => 0xe6, 42 => 0xff, 48 => 0xd0, 49 => 0xd0, 50 => 0xd8 },
	'wb_rggblevelsunknown21' => { 41 => 0xeb, 42 => 0x104, 49 => 0xd5, 50 => 0xdd },
	'wb_rggblevelsunknown22' => { 41 => 0xf0, 42 => 0x109, 49 => 0xda, 50 => 0xe2 },
	'wb_rggblevelsunknown23' => { 41 => 0xf5, 42 => 0x10e, 49 => 0xdf, 50 => 0xe7 },
	'wb_rggblevelsunknown24' => { 41 => 0xfa, 42 => 0x113, 49 => 0xe4, 50 => 0xec },
	'wb_rggblevelsunknown25' => { 41 => 0xff, 42 => 0x118, 49 => 0xe9, 50 => 0xf1 },
	'wb_rggblevelsunknown26' => { 41 => 0x104, 42 => 0x11d, 49 => 0xee, 50 => 0xf6 },
	'wb_rggblevelsunknown27' => { 41 => 0x109, 42 => 0x122, 49 => 0xf3, 50 => 0xfb },
	'wb_rggblevelsunknown28' => { 41 => 0x10e, 49 => 0xf8, 50 => 0x100 },
	'wb_rggblevelsunknown29' => { 41 => 0x113, 49 => 0xfd, 50 => 0x105 },
	'wb_rggblevelsunknown3' => { 38 => 0x3c, 39 => 0x60, 41 => 0x6e, 42 => 0x82, 43 => 0x4f, 47 => 0x58, 48 => 0x58, 49 => 0x58, 50 => 0x60 },
	'wb_rggblevelsunknown30' => { 49 => 0x102 },
	'wb_rggblevelsunknown4' => { 38 => 0x41, 39 => 0x68, 41 => 0x73, 42 => 0x87, 43 => 0x54, 47 => 0x5d, 48 => 0x5d, 49 => 0x5d, 50 => 0x65 },
	'wb_rggblevelsunknown5' => { 38 => 0x46, 39 => 0x70, 41 => 0x78, 42 => 0x8c, 43 => 0x59, 47 => 0x62, 48 => 0x62, 49 => 0x62, 50 => 0x6a },
	'wb_rggblevelsunknown6' => { 38 => 0x4b, 39 => 0x78, 41 => 0x7d, 42 => 0x91, 43 => 0x5e, 47 => 0x8a, 48 => 0x67, 49 => 0x67, 50 => 0x6f },
	'wb_rggblevelsunknown7' => { 38 => 0x50, 39 => 0x80, 41 => 0x82, 42 => 0x96, 43 => 0x63, 47 => 0x8f, 48 => 0x6c, 49 => 0x6c, 50 => 0x74 },
	'wb_rggblevelsunknown8' => { 38 => 0x55, 39 => 0x88, 41 => 0x87, 42 => 0x9b, 43 => 0x68, 47 => 0x94, 48 => 0x71, 49 => 0x71, 50 => 0x79 },
	'wb_rggblevelsunknown9' => { 38 => 0x5a, 39 => 0x90, 41 => 0x8c, 42 => 0xa0, 43 => 0x6d, 47 => 0x99, 48 => 0x76, 49 => 0x76, 50 => 0x7e },
	'wb_rggblevelsuserselected' => { 380 => 0x5c },
	'wbadjblueamber' => { 103 => 0x20106 },
	'wbadjbluebalance' => { 295 => 0x8 },
	'wbadjcolortemp' => { 103 => 0x20102, 108 => 0x1a },
	'wbadjlighting' => { 295 => 0x14 },
	'wbadjmagentagreen' => { 103 => 0x20105 },
	'wbadjmode' => { 295 => 0x10 },
	'wbadjredbalance' => { 295 => 0x0 },
	'wbadjrggblevels' => { 103 => 0x20125, 108 => 0x6 },
	'wbadjtemperature' => { 295 => 0x18 },
	'wbadjtint' => { 295 => 0x25 },
	'wbbluelevel' => { 332 => 0x324, 337 => 0x8006, 342 => 0x26 },
	'wbbracketingsteps' => { 198 => 0x10, 199 => 0x10, 270 => 0x174d },
	'wbbracketmode' => { 57 => 0x9 },
	'wbbracketshotnumber' => { 187 => 0x2b, 404 => 0x101a },
	'wbbracketvalueab' => { 57 => 0xc },
	'wbbracketvaluegm' => { 57 => 0xd },
	'wbbutton' => { 241 => 0x80a },
	'wbfinetuneactive' => { 108 => 0x24 },
	'wbfinetunesaturation' => { 108 => 0x28 },
	'wbfinetunetone' => { 108 => 0x2c },
	'wbgreenlevel' => { 332 => 0x323, 337 => 0x8005, 342 => 0x25 },
	'wbmediaimagesizesetting' => { 84 => 0x708 },
	'wbmode' => { 189 => 0x4, 319 => 0x1015 },
	'wbredlevel' => { 332 => 0x322, 337 => 0x8004, 342 => 0x24 },
	'wbscale' => { 190 => 0x0 },
	'wbshiftab' => { 74 => 0xc, 337 => 0x46, 354 => 0x10 },
	'wbshiftab_gm' => { 437 => 0x2014 },
	'wbshiftab_gm_precise' => { 437 => 0x2026 },
	'wbshiftcreativecontrol' => { 337 => 0x92 },
	'wbshiftgm' => { 74 => 0xd, 337 => 0x47, 354 => 0x11 },
	'wbshiftintelligentauto' => { 337 => 0x8b },
	'wbtype1' => { 343 => 0x1, 344 => 0x1 },
	'wbtype2' => { 343 => 0x4, 344 => 0x5 },
	'wbtype3' => { 343 => 0x7, 344 => 0x9 },
	'wbtype4' => { 343 => 0xa, 344 => 0xd },
	'wbtype5' => { 343 => 0xd, 344 => 0x11 },
	'wbtype6' => { 343 => 0x10, 344 => 0x15 },
	'wbtype7' => { 343 => 0x13, 344 => 0x19 },
	'webstatement' => { 529 => 'WebStatement' },
	'weightedflatsubject' => { 488 => 'weightedFlatSubject' },
	'what' => { 496 => 'What', 498 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 74 => 0x8, 77 => 0x7, 112 => 0x7, 113 => [0x19,0x2012], 119 => [0xa403,0xfe4e], 127 => 0x1002, 138 => 0x3fc, 139 => 0xfa0d, 140 => 0x40, 151 => 0x1a, 181 => 0x3, 182 => 0xe, 183 => 0x4, 184 => 0xb, 186 => 0x115, 234 => 0x5, 279 => 0x7, 332 => 0x304, 337 => 0x3, 339 => 0x3033, 372 => 0x19, 379 => 0x7, 403 => 0x26, 404 => 0x1003, 414 => [0x88,0x3c,0x7,0x58], 424 => 0xf, 425 => 0xe, 437 => [0x115,0xb054], 496 => 'WhiteBalance', 498 => 'WhiteBalance', 502 => 'WhiteBalance' },
	'whitebalance0' => { 176 => 'WhiteBalance0' },
	'whitebalance1' => { 176 => 'WhiteBalance1' },
	'whitebalance2' => { 176 => 'WhiteBalance2', 314 => 0x500 },
	'whitebalanceadj' => { 103 => 0x20101, 108 => 0x18, 289 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 350 => 0x0 },
	'whitebalancebias' => { 113 => 0x2011, 319 => 0x304, 337 => 0x23 },
	'whitebalanceblue' => { 74 => 0x7 },
	'whitebalancebracket' => { 314 => 0x502, 319 => 0x303 },
	'whitebalancebracketing' => { 184 => 0x22, 187 => 0x2c, 435 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 312 => 0x1c5 },
	'whitebalancecomp' => { 322 => 0x1001 },
	'whitebalancedetected' => { 138 => 0x3fb },
	'whitebalancefinetune' => { 127 => 0x100a, 184 => 0x38, 186 => 0x112, 234 => [0xb,0x3f], 404 => 0x1004, 424 => 0x6, 425 => 0x5, 437 => 0x112 },
	'whitebalancemode' => { 138 => 0x3fa, 372 => 0x1a },
	'whitebalancered' => { 74 => 0x6 },
	'whitebalanceset' => { 353 => 0xa },
	'whitebalancesetting' => { 184 => 0x23, 424 => 0x5, 425 => 0x4, 426 => 0x16, 442 => 0xd },
	'whitebalancesetup' => { 411 => 0x41 },
	'whitebalancetemperature' => { 314 => 0x501 },
	'whiteboard' => { 319 => 0x301 },
	'whitelevel' => { 119 => 0xc61d, 372 => 0x7e, 444 => 0x787f },
	'whitepoint' => { 119 => 0x13e, 336 => 0x35d, 372 => 0x201, 521 => 'WhitePoint' },
	'whites2012' => { 496 => 'Whites2012', 498 => 'Whites2012' },
	'whitesadj' => { 472 => 0x9017 },
	'wideadapter' => { 404 => 0x1017 },
	'widefocuszone' => { 181 => 0x2f },
	'widerange' => { 413 => 0x20f },
	'windmode' => { 138 => 0x3f4 },
	'windnoisereduction' => { 239 => 0x2d6, 240 => 0x2fe, 241 => 0x2fe },
	'windowlocation' => { 397 => 'WLOC' },
	'windowsatom' => { 497 => 'windowsAtom' },
	'windowsatomextension' => { 497 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 497 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 497 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 515 => 'wordCount' },
	'work' => { 389 => "\xa9wrk" },
	'workcolorspace' => { 103 => 0x10200, 108 => 0x270 },
	'workflowtag' => { 510 => 'WorkflowTag' },
	'workflowtagcvid' => { 510 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 510 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 510 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 510 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 504 => 'WorkToDo' },
	'worldtimelocation' => { 337 => 0x3a, 372 => 0x22, 378 => '0.1' },
	'writer' => { 179 => 'WM/Writer' },
	'writer-editor' => { 131 => 0x7a },
	'x3filllight' => { 414 => 0x12 },
	'xattrquarantine' => { 174 => 'com.apple.quarantine' },
	'xilinxversion' => { 138 => 0x414 },
	'xml' => { 136 => 'xml ' },
	'xmp' => { 106 => 0xffff00f6, 120 => 'XMP' },
	'xmptoolkit' => { 522 => 'xmptk' },
	'xpauthor' => { 119 => 0x9c9d },
	'xpcomment' => { 119 => 0x9c9c },
	'xpkeywords' => { 119 => 0x9c9e },
	'xposition' => { 119 => 0x11e },
	'xpsubject' => { 119 => 0x9c9f },
	'xptitle' => { 119 => 0x9c9b },
	'xresolution' => { 119 => 0x11a, 134 => 0x3, 387 => 0x0, 521 => 'XResolution' },
	'xyresolution' => { 123 => 0x3 },
	'yaw' => { 115 => 0x7, 397 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 246 => 0x8, 409 => 0x0 },
	'ycbcrcoefficients' => { 119 => 0x211, 521 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 119 => 0x213, 521 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 119 => 0x212, 521 => 'YCbCrSubSampling' },
	'year' => { 389 => 'yrrc', 391 => 'year', 397 => 'yrrc' },
	'yearcreated' => { 140 => 0x10, 149 => 0xc },
	'yellowhsl' => { 103 => 0x20912 },
	'yield' => { 517 => 'yield' },
	'yposition' => { 119 => 0x11f },
	'yresolution' => { 119 => 0x11b, 134 => 0x5, 387 => 0x4, 521 => 'YResolution' },
	'zebrapatterntonerange' => { 312 => 0x211 },
	'zoneidentifier' => { 120 => 'ZoneIdentifier' },
	'zonematching' => { 186 => 0x10a, 189 => [0x3a,0x4a], 437 => 0xb024 },
	'zonematchingmode' => { 184 => 0x14 },
	'zonematchingon' => { 183 => 0x75 },
	'zonematchingvalue' => { 424 => 0x1f },
	'zoomedpreviewlength' => { 319 => 0xf05 },
	'zoomedpreviewsize' => { 319 => 0xf06 },
	'zoomedpreviewstart' => { 319 => 0xf04 },
	'zoomsourcewidth' => { 34 => 0x24 },
	'zoomstepcount' => { 317 => 0x300, 319 => 0x100d },
	'zoomtargetwidth' => { 34 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'ambisonicchannelmap' => 1,
	'ambisonicchannelordering' => 1,
	'ambisonicchannels' => 1,
	'ambisonicnormalization' => 1,
	'ambisonicorder' => 1,
	'ambisonictype' => 1,
	'amendlocalset' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autocaptureoffset' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'brotliexif' => 1,
	'brotlijumb' => 1,
	'brotlixmp' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentlightlevel' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz9' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gainmapimage' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guano' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrgm' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatahash' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxcontentlightlevel' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumshutterangle' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxpicaveragelightlevel' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialjxlcodestream' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcc-flp' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialaudio' => 1,
	'spatialaudioversion' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailref' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'thumbnailurl' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2023, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
