#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.19';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 109 => 0x69 },
	'about' => { 515 => 'about' },
	'aboutcvterm' => { 507 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 507 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 507 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 507 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 507 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 116 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 521 => 'absPeakAudioFilePath' },
	'academicfield' => { 511 => 'academicField' },
	'acceleration' => { 119 => 0x9404, 501 => 'Acceleration' },
	'accelerationtracking' => { 84 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 405 => 0x3 },
	'accelerometerdata' => { 395 => 'vrot' },
	'accelerometerx' => { 335 => 0x8d },
	'accelerometery' => { 335 => 0x8e },
	'accelerometerz' => { 335 => 0x8c },
	'accessoryserialnumber' => { 335 => 0x54 },
	'accessorytype' => { 335 => 0x53 },
	'actionadvised' => { 131 => 0x2a },
	'activearea' => { 119 => 0xc68d },
	'actived-lighting' => { 233 => 0x22, 285 => 0x24 },
	'actived-lightingmode' => { 285 => 0x25 },
	'adaptervoltage' => { 138 => 0x407 },
	'addaspectratioinfo' => { 84 => 0x80e },
	'addiptcinformation' => { 84 => 0x815 },
	'additionalmodelinformation' => { 507 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 84 => 0x80f, 85 => 0x11, 86 => 0x13, 89 => 0x14 },
	'address' => { 161 => 'Address' },
	'adjustmentmode' => { 412 => 0x15 },
	'adlbracketingstep' => { 197 => 0x17 },
	'adlbracketingtype' => { 197 => 0x18 },
	'adobe' => { 120 => 'Adobe' },
	'adultcontentwarning' => { 322 => 'AdultContentWarning', 514 => 'adultContentWarning' },
	'advancedfilter' => { 127 => 0x1201 },
	'advancedraw' => { 287 => 0x76a43203 },
	'advancedscenetype' => { 335 => 0x3d },
	'advisory' => { 519 => 'Advisory' },
	'ae_iso' => { 343 => 0x2, 344 => 0x4, 345 => 0x12 },
	'aeaperture' => { 343 => 0x1, 344 => 0x3, 345 => 0x11 },
	'aeaperturesteps' => { 343 => 0x8, 344 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 84 => 0x104 },
	'aebbracketvalue' => { 77 => 0x11 },
	'aebracketingsteps' => { 197 => 0xf, 198 => 0xf, 268 => 0x174c },
	'aebsequence' => { 84 => 0x105 },
	'aebsequenceautocancel' => { 82 => 0x9, 83 => 0x9, 85 => 0x8, 86 => 0x9, 89 => 0x9, 90 => 0x7 },
	'aebshotcount' => { 84 => 0x106 },
	'aebxv' => { 343 => 0x4, 344 => 0x6 },
	'aeerror' => { 344 => 0x8 },
	'aeexposuretime' => { 343 => 0x0, 344 => 0x2, 345 => 0x10 },
	'aelbutton' => { 184 => 0x45 },
	'aelexposureindicator' => { 184 => 0x51 },
	'aelock' => { 184 => 0x5b, 296 => '4.2', 305 => '4.2', 312 => 0x201, 370 => 0x48, 422 => 0x40, 423 => 0x40, 424 => [0x86,0x286] },
	'aelockbutton' => { 294 => '16.1', 296 => '4.1', 299 => '15.1', 300 => '16.1', 301 => '16.1', 303 => '30.1', 304 => '16.1', 305 => '4.1', 307 => '17.1', 309 => '17.1' },
	'aelockbuttonplusdials' => { 294 => '16.2', 303 => '32.1', 307 => '44.1' },
	'aelockformb-d80' => { 309 => '3.1' },
	'aelockmetermodeafterfocus' => { 84 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 343 => 0x9, 344 => 0x10, 345 => 0x1c },
	'aemaxaperture2' => { 343 => 0xa, 344 => 0x11, 345 => 0x1d },
	'aemeteringmode' => { 343 => 0xc },
	'aemeteringmode2' => { 343 => '13.1' },
	'aemeteringsegments' => { 187 => 0x628, 370 => 0x209 },
	'aemicroadjustment' => { 84 => 0x110 },
	'aeminaperture' => { 343 => 0xb, 344 => 0x12, 345 => 0x1e },
	'aeminexposuretime' => { 343 => 0x5, 344 => 0x13, 345 => 0x1f },
	'aeprogrammode' => { 343 => 0x6 },
	'aeprojectlink' => { 495 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 495 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 495 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 495 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 495 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 495 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 34 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 343 => 0xd },
	'aexv' => { 343 => 0x3, 344 => 0x5 },
	'af-assistilluminator' => { 310 => 0x19 },
	'af-cfocusdisplay' => { 310 => 0x234 },
	'af-cpriority' => { 128 => '0.2' },
	'af-cpriorityselection' => { 294 => '1.1', 295 => '1.1', 297 => '1.1', 298 => '1.1', 300 => '0.1', 301 => '0.1', 302 => '0.1', 303 => '1.1', 304 => '0.1', 307 => '1.1', 308 => '1.1', 310 => 0x3 },
	'af-csetting' => { 124 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 124 => '0.2' },
	'af-ctrackingsensitivity' => { 124 => '0.1' },
	'af-czoneareaswitching' => { 124 => '0.3' },
	'af-onbutton' => { 297 => '70.1', 298 => '70.1', 308 => '70.1' },
	'af-onformb-d10' => { 294 => '3.3', 303 => '3.2' },
	'af-onformb-d11' => { 304 => '2.2' },
	'af-onformb-d12' => { 307 => '50.1' },
	'af-onoutoffocusrelease' => { 310 => 0x10 },
	'af-spriority' => { 128 => '0.1' },
	'af-spriorityselection' => { 294 => '1.2', 295 => '1.2', 297 => '1.2', 298 => '1.2', 302 => '0.2', 303 => '1.2', 304 => '0.2', 307 => '1.2', 308 => '1.2', 310 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 294 => '2.1', 295 => '2.1', 297 => '78.3', 298 => '78.3', 303 => '2.1', 307 => '2.1', 308 => '78.3', 310 => 0xf },
	'afadjustment' => { 370 => 0x72, 379 => 0x267 },
	'afandmeteringbuttons' => { 84 => 0x701 },
	'afaperture' => { 226 => 0x5, 227 => 0x5, 231 => 0x5 },
	'afareaheight' => { 193 => [0x1a,0x34,0x50], 194 => 0x48 },
	'afareaillumination' => { 184 => 0x4b, 305 => '15.3' },
	'afareainitialheight' => { 243 => 0xbeb },
	'afareainitialwidth' => { 243 => 0xbea },
	'afareainitialxposition' => { 243 => 0xbe8 },
	'afareainitialyposition' => { 243 => 0xbe9 },
	'afareamode' => { 126 => '0.3', 180 => 0x33, 184 => 0xe, 192 => 0x0, 193 => 0x5, 194 => 0x5, 238 => 0x210, 239 => 0x224, 335 => 0xf, 402 => 0x1205, 415 => [0xa,0x3a], 422 => 0x11, 423 => 0x10, 424 => 0x24, 435 => 0xb043, 460 => 0x17 },
	'afareamodesetting' => { 296 => '11.1', 299 => '0.1', 305 => '16.1', 309 => '2.1', 435 => 0x201c },
	'afareapointsize' => { 126 => '0.4' },
	'afareas' => { 312 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 84 => 0x51b },
	'afareawidth' => { 193 => [0x18,0x32,0x4e], 194 => 0x46 },
	'afareaxposition' => { 193 => [0x14,0x2e,0x4a], 194 => 0x42, 402 => 0x1203 },
	'afareaxposition1' => { 402 => 0x1201 },
	'afareayposition' => { 193 => [0x16,0x30,0x4c], 194 => 0x44, 402 => 0x1204 },
	'afareayposition1' => { 402 => 0x1202 },
	'afareazonesize' => { 126 => '0.5' },
	'afassist' => { 82 => 0x5, 90 => 0x5, 184 => 0x48, 294 => '2.5', 296 => '0.2', 299 => '0.2', 300 => '1.1', 301 => '1.1', 302 => '1.3', 303 => '2.4', 304 => '1.3', 305 => '0.2', 307 => '2.4', 309 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 84 => 0x50e, 85 => 0x4, 86 => 0x5, 87 => 0x4, 88 => 0x4, 89 => 0x5 },
	'afassistlamp' => { 335 => 0x31 },
	'afbuttonpressed' => { 424 => [0x83,0x283] },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 346 => 0x6 },
	'afduringliveview' => { 84 => 0x511 },
	'affinea' => { 488 => 'AffineA' },
	'affineb' => { 488 => 'AffineB' },
	'affinec' => { 488 => 'AffineC' },
	'affined' => { 488 => 'AffineD' },
	'affinetune' => { 195 => 0x0, 238 => 0x5b0, 239 => 0x5e0, 312 => 0x306 },
	'affinetuneadj' => { 195 => 0x2, 261 => 0x2d1, 262 => 0x2dc, 312 => 0x307 },
	'affinetuneadjtele' => { 195 => 0x3 },
	'affinetuneindex' => { 195 => 0x1 },
	'affinex' => { 488 => 'AffineX' },
	'affiney' => { 488 => 'AffineY' },
	'afhold' => { 346 => 0x1fd },
	'afilluminator' => { 422 => 0x29, 435 => 0xb044 },
	'afimageheight' => { 193 => [0x12,0x2c,0x48], 194 => 0x40 },
	'afimagewidth' => { 193 => [0x10,0x2a,0x46], 194 => 0x3e },
	'afintegrationtime' => { 346 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 415 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 419 => 0x131 },
	'afmicroadjregisteredlenses' => { 419 => '305.1' },
	'afmicroadjustment' => { 84 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 419 => 0x130 },
	'afmode' => { 113 => 0x3009, 127 => 0x1022, 180 => 0x16, 412 => 0x5 },
	'afmoderestrictions' => { 295 => '50.3', 297 => '48.3', 298 => '48.3', 307 => '48.3', 308 => '48.3' },
	'afonaelockbuttonswitch' => { 84 => 0x702 },
	'afonbutton' => { 294 => '3.1', 295 => '47.1', 310 => 0x83 },
	'afpoint' => { 34 => 0x13, 112 => 0x18, 180 => 0x15, 192 => 0x1, 315 => 0x308, 412 => 0x1f, 415 => [0x37,0x7], 419 => 0x19, 420 => 0x18, 421 => [0x18,0x20] },
	'afpointactivationarea' => { 83 => 0x11, 89 => 0x11 },
	'afpointareaexpansion' => { 84 => 0x508 },
	'afpointatshutterrelease' => { 415 => [0x39,0x9] },
	'afpointautoselection' => { 84 => 0x50b },
	'afpointbrightness' => { 84 => 0x50d, 294 => '2.4', 295 => '46.5', 297 => '2.2', 298 => '2.2', 307 => '2.3', 308 => '2.2' },
	'afpointdetails' => { 315 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 84 => 0x50c },
	'afpointillumination' => { 83 => 0xa, 294 => '2.3', 295 => '46.2', 297 => '47.2', 298 => '47.2', 302 => '1.2', 303 => '2.3', 304 => '1.2', 307 => '47.2', 308 => '47.2', 309 => '2.4' },
	'afpointinfocus' => { 415 => [0x38,0x8] },
	'afpointmode' => { 351 => 0x3 },
	'afpointposition' => { 113 => 0x2021, 335 => 0x4d },
	'afpointregistration' => { 82 => 0x7 },
	'afpoints' => { 183 => 0x10 },
	'afpointsel' => { 310 => 0xb },
	'afpointselected' => { 184 => 0xd, 312 => 0x305, 370 => 0xe, 419 => 0x15, 420 => 0x14, 421 => [0x14,0x1c], 435 => 0x201e },
	'afpointselected2' => { 351 => 0x4 },
	'afpointselection' => { 83 => 0xb, 294 => '1.3', 295 => '1.3', 303 => '1.3', 307 => '1.3', 308 => '1.3' },
	'afpointselectionmethod' => { 84 => 0x50f, 85 => 0xc, 86 => 0xd, 89 => 0xd },
	'afpointsetting' => { 422 => 0x12, 423 => 0x11 },
	'afpointsinfocus' => { 77 => 0xe, 192 => 0x2, 193 => 0x30, 346 => 0xb, 347 => 0x4, 370 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 83 => 0xd },
	'afpointsselected' => { 193 => 0x1c, 347 => '4.1', 468 => 0x4 },
	'afpointsspecial' => { 347 => '4.2' },
	'afpointsunknown1' => { 346 => 0x0 },
	'afpointsunknown2' => { 346 => 0x2 },
	'afpointsused' => { 193 => [0xa,0x8], 415 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 346 => 0x4 },
	'afresponse' => { 233 => 0xad },
	'afresult' => { 317 => 0x1038 },
	'afsearch' => { 312 => 0x303 },
	'afsensoractive' => { 180 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 402 => 0x1200 },
	'afstatus_00_b4' => { 418 => 0x0 },
	'afstatus_01_c4' => { 418 => 0x2 },
	'afstatus_02_d4' => { 418 => 0x4 },
	'afstatus_03_e4' => { 418 => 0x6 },
	'afstatus_04_f4' => { 418 => 0x8 },
	'afstatus_05_g4' => { 418 => 0xa },
	'afstatus_06_h4' => { 418 => 0xc },
	'afstatus_07_b3' => { 418 => 0xe },
	'afstatus_08_c3' => { 418 => 0x10 },
	'afstatus_09_d3' => { 418 => 0x12 },
	'afstatus_10_e3' => { 418 => 0x14 },
	'afstatus_11_f3' => { 418 => 0x16 },
	'afstatus_12_g3' => { 418 => 0x18 },
	'afstatus_13_h3' => { 418 => 0x1a },
	'afstatus_14_b2' => { 418 => 0x1c },
	'afstatus_15_c2' => { 418 => 0x1e },
	'afstatus_16_d2' => { 418 => 0x20 },
	'afstatus_17_e2' => { 418 => 0x22 },
	'afstatus_18_f2' => { 418 => 0x24 },
	'afstatus_19_g2' => { 418 => 0x26 },
	'afstatus_20_h2' => { 418 => 0x28 },
	'afstatus_21_c1' => { 418 => 0x2a },
	'afstatus_22_d1' => { 418 => 0x2c },
	'afstatus_23_e1' => { 418 => 0x2e },
	'afstatus_24_f1' => { 418 => 0x30 },
	'afstatus_25_g1' => { 418 => 0x32 },
	'afstatus_26_a7_vertical' => { 418 => 0x34 },
	'afstatus_27_a6_vertical' => { 418 => 0x36 },
	'afstatus_28_a5_vertical' => { 418 => 0x38 },
	'afstatus_29_c7_vertical' => { 418 => 0x3a },
	'afstatus_30_c6_vertical' => { 418 => 0x3c },
	'afstatus_31_c5_vertical' => { 418 => 0x3e },
	'afstatus_32_e7_vertical' => { 418 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 418 => 0x42 },
	'afstatus_34_e5_vertical' => { 418 => 0x44 },
	'afstatus_35_g7_vertical' => { 418 => 0x46 },
	'afstatus_36_g6_vertical' => { 418 => 0x48 },
	'afstatus_37_g5_vertical' => { 418 => 0x4a },
	'afstatus_38_i7_vertical' => { 418 => 0x4c },
	'afstatus_39_i6_vertical' => { 418 => 0x4e },
	'afstatus_40_i5_vertical' => { 418 => 0x50 },
	'afstatus_41_a7' => { 418 => 0x52 },
	'afstatus_42_b7' => { 418 => 0x54 },
	'afstatus_43_c7' => { 418 => 0x56 },
	'afstatus_44_d7' => { 418 => 0x58 },
	'afstatus_45_e7' => { 418 => 0x5a },
	'afstatus_46_f7' => { 418 => 0x5c },
	'afstatus_47_g7' => { 418 => 0x5e },
	'afstatus_48_h7' => { 418 => 0x60 },
	'afstatus_49_i7' => { 418 => 0x62 },
	'afstatus_50_a6' => { 418 => 0x64 },
	'afstatus_51_b6' => { 418 => 0x66 },
	'afstatus_52_c6' => { 418 => 0x68 },
	'afstatus_53_d6' => { 418 => 0x6a },
	'afstatus_54_e6_center' => { 418 => 0x6c },
	'afstatus_55_f6' => { 418 => 0x6e },
	'afstatus_56_g6' => { 418 => 0x70 },
	'afstatus_57_h6' => { 418 => 0x72 },
	'afstatus_58_i6' => { 418 => 0x74 },
	'afstatus_59_a5' => { 418 => 0x76 },
	'afstatus_60_b5' => { 418 => 0x78 },
	'afstatus_61_c5' => { 418 => 0x7a },
	'afstatus_62_d5' => { 418 => 0x7c },
	'afstatus_63_e5' => { 418 => 0x7e },
	'afstatus_64_f5' => { 418 => 0x80 },
	'afstatus_65_g5' => { 418 => 0x82 },
	'afstatus_66_h5' => { 418 => 0x84 },
	'afstatus_67_i5' => { 418 => 0x86 },
	'afstatus_68_c11' => { 418 => 0x88 },
	'afstatus_69_d11' => { 418 => 0x8a },
	'afstatus_70_e11' => { 418 => 0x8c },
	'afstatus_71_f11' => { 418 => 0x8e },
	'afstatus_72_g11' => { 418 => 0x90 },
	'afstatus_73_b10' => { 418 => 0x92 },
	'afstatus_74_c10' => { 418 => 0x94 },
	'afstatus_75_d10' => { 418 => 0x96 },
	'afstatus_76_e10' => { 418 => 0x98 },
	'afstatus_77_f10' => { 418 => 0x9a },
	'afstatus_78_g10' => { 418 => 0x9c },
	'afstatus_79_h10' => { 418 => 0x9e },
	'afstatus_80_b9' => { 418 => 0xa0 },
	'afstatus_81_c9' => { 418 => 0xa2 },
	'afstatus_82_d9' => { 418 => 0xa4 },
	'afstatus_83_e9' => { 418 => 0xa6 },
	'afstatus_84_f9' => { 418 => 0xa8 },
	'afstatus_85_g9' => { 418 => 0xaa },
	'afstatus_86_h9' => { 418 => 0xac },
	'afstatus_87_b8' => { 418 => 0xae },
	'afstatus_88_c8' => { 418 => 0xb0 },
	'afstatus_89_d8' => { 418 => 0xb2 },
	'afstatus_90_e8' => { 418 => 0xb4 },
	'afstatus_91_f8' => { 418 => 0xb6 },
	'afstatus_92_g8' => { 418 => 0xb8 },
	'afstatus_93_h8' => { 418 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 418 => 0xbc },
	'afstatusactivesensor' => { 180 => 0x2, 415 => [0x4,0x3b], 419 => 0x1e, 420 => 0x1b, 421 => [0x1b,0x21] },
	'afstatusbottom' => { 180 => 0x8, 419 => 0x2a, 420 => 0x21, 421 => 0x21 },
	'afstatusbottom-left' => { 180 => 0x12, 420 => 0x2b, 421 => 0x2b },
	'afstatusbottom-right' => { 180 => 0x6, 420 => 0x1f, 421 => 0x1f },
	'afstatusbottomassist-left' => { 419 => 0x28 },
	'afstatusbottomassist-right' => { 419 => 0x2c },
	'afstatusbottomhorizontal' => { 416 => 0x10, 417 => 0x1c },
	'afstatusbottomvertical' => { 416 => 0x16, 417 => 0x26 },
	'afstatuscenter-10' => { 419 => 0x34 },
	'afstatuscenter-11' => { 419 => 0x36 },
	'afstatuscenter-12' => { 419 => 0x38 },
	'afstatuscenter-14' => { 419 => 0x3c },
	'afstatuscenter-7' => { 419 => 0x2e },
	'afstatuscenter-9' => { 419 => 0x32 },
	'afstatuscenter-horizontal' => { 419 => 0x30 },
	'afstatuscenter-vertical' => { 419 => 0x3a },
	'afstatuscenterf2-8' => { 419 => 0x4c },
	'afstatuscenterhorizontal' => { 180 => 0x2f, 416 => 0xc, 417 => 0x18, 420 => 0x2f, 421 => 0x2f },
	'afstatuscentervertical' => { 180 => 0xc, 416 => 0x14, 417 => 0x22, 420 => 0x25, 421 => 0x25 },
	'afstatusfarleft' => { 416 => 0x6, 419 => 0x26 },
	'afstatusfarlefthorizontal' => { 417 => 0x4 },
	'afstatusfarleftvertical' => { 417 => 0x12 },
	'afstatusfarright' => { 416 => 0x18, 419 => 0x44 },
	'afstatusfarrighthorizontal' => { 417 => 0x2c },
	'afstatusfarrightvertical' => { 417 => 0x34 },
	'afstatusleft' => { 180 => 0x2d, 416 => 0x2, 419 => 0x22, 420 => 0x2d, 421 => 0x2d },
	'afstatuslefthorizontal' => { 417 => 0x6 },
	'afstatusleftvertical' => { 417 => 0xe },
	'afstatuslower-left' => { 416 => 0x4, 419 => 0x24 },
	'afstatuslower-lefthorizontal' => { 417 => 0xa },
	'afstatuslower-leftvertical' => { 417 => 0x10 },
	'afstatuslower-middle' => { 416 => 0x22, 417 => 0x24 },
	'afstatuslower-right' => { 416 => 0x1e, 419 => 0x4a },
	'afstatuslower-righthorizontal' => { 417 => 0x32 },
	'afstatuslower-rightvertical' => { 417 => 0x3a },
	'afstatuslowerfarleft' => { 417 => 0x8 },
	'afstatuslowerfarright' => { 417 => 0x30 },
	'afstatusmiddlehorizontal' => { 180 => 0xa, 420 => 0x23, 421 => 0x23 },
	'afstatusnearleft' => { 416 => 0xe, 417 => 0x1a },
	'afstatusnearright' => { 416 => 0xa, 417 => 0x16 },
	'afstatusright' => { 180 => 0x31, 416 => 0x1c, 419 => 0x48, 420 => 0x31, 421 => 0x31 },
	'afstatusrighthorizontal' => { 417 => 0x2e },
	'afstatusrightvertical' => { 417 => 0x38 },
	'afstatustop' => { 180 => 0xe, 419 => 0x40, 420 => 0x27, 421 => 0x27 },
	'afstatustop-left' => { 180 => 0x10, 420 => 0x29, 421 => 0x29 },
	'afstatustop-right' => { 180 => 0x4, 420 => 0x1d, 421 => 0x1d },
	'afstatustopassist-left' => { 419 => 0x3e },
	'afstatustopassist-right' => { 419 => 0x42 },
	'afstatustophorizontal' => { 416 => 0x8, 417 => 0x14 },
	'afstatustopvertical' => { 416 => 0x12, 417 => 0x1e },
	'afstatusupper-left' => { 416 => 0x0, 419 => 0x20 },
	'afstatusupper-lefthorizontal' => { 417 => 0x2 },
	'afstatusupper-leftvertical' => { 417 => 0xc },
	'afstatusupper-middle' => { 416 => 0x20, 417 => 0x20 },
	'afstatusupper-right' => { 416 => 0x1a, 419 => 0x46 },
	'afstatusupper-righthorizontal' => { 417 => 0x2a },
	'afstatusupper-rightvertical' => { 417 => 0x36 },
	'afstatusupperfarleft' => { 417 => 0x0 },
	'afstatusupperfarright' => { 417 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 435 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 415 => 0x2 },
	'afwithshutter' => { 422 => 0x2a },
	'aggregateissuenumber' => { 511 => 'aggregateIssueNumber' },
	'aggregationtype' => { 511 => 'aggregationType' },
	'agreement' => { 514 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 138 => 0xe4e },
	'airplanemode' => { 238 => 0x624, 239 => 0x654 },
	'aiservocontinuousshooting' => { 83 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 84 => 0x519 },
	'aiservoimagepriority' => { 84 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 84 => 0x51a },
	'aiservotrackingmethod' => { 84 => 0x504 },
	'aiservotrackingsensitivity' => { 83 => 0x14, 84 => 0x502 },
	'aisubjecttrackingmode' => { 312 => 0x309 },
	'album' => { 387 => ['albm',"\xa9alb"], 389 => 'album', 395 => ['albm',"\xa9alb"], 521 => 'album' },
	'albumartist' => { 179 => 'WM/AlbumArtist', 387 => 'aART', 395 => 'albr' },
	'albumcoverurl' => { 179 => 'WM/AlbumCoverURL' },
	'albumtitle' => { 179 => 'WM/AlbumTitle' },
	'albumtitleid' => { 387 => 'atID' },
	'alreadyapplied' => { 494 => 'AlreadyApplied', 496 => 'AlreadyApplied' },
	'alternatetitle' => { 511 => 'alternateTitle' },
	'alternatetitlea-lang' => { 511 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 511 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 511 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 196 => 0x6 },
	'alttapename' => { 521 => 'altTapeName' },
	'alttextaccessibility' => { 506 => 'AltTextAccessibility' },
	'alttimecode' => { 521 => 'altTimecode' },
	'alttimecodetimeformat' => { 521 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 521 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 521 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 398 => 0x5c },
	'ambientlight' => { 398 => 0x5e },
	'ambienttemperature' => { 119 => 0x9400, 396 => 0x14, 397 => 0x46, 398 => 0x50, 460 => 0x4, 501 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 396 => 0x13, 397 => 0x44, 398 => 0x4e },
	'analogbalance' => { 119 => 0xc627 },
	'analogcaptureiso' => { 138 => 0x89e },
	'analogisotable' => { 138 => 0x89d },
	'androidversion' => { 389 => 'com.android.version' },
	'angleadj' => { 103 => 0x10003, 109 => 0x8b },
	'angleinforoll' => { 490 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 490 => 'AngleInfoYaw' },
	'anti-blur' => { 435 => 0xb04b },
	'antialiasstrength' => { 119 => 0xc632 },
	'aperturelock' => { 295 => '38.2', 297 => '38.2', 298 => '38.2', 307 => '38.2', 308 => '38.2', 310 => 0xb8 },
	'aperturemode' => { 395 => 'apmd' },
	'aperturerange' => { 84 => 0x10d },
	'apertureringuse' => { 351 => '1.4' },
	'aperturesetting' => { 184 => 0x7, 422 => 0x30, 423 => 0x29, 424 => 0x1 },
	'aperturevalue' => { 93 => 0x2, 119 => 0x9202, 317 => 0x1002, 379 => 0x401, 500 => 'ApertureValue' },
	'appinfo' => { 473 => 'AppInfo' },
	'appinfoapplication' => { 473 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 473 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 473 => [\'AppInfo','AppInfoVersion'] },
	'applekeywords' => { 321 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 389 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 387 => 'apID' },
	'applestoreaccounttype' => { 387 => 'akID' },
	'applestorecatalogid' => { 387 => 'cnID' },
	'applestorecountry' => { 387 => 'sfID' },
	'applicationkeystring' => { 138 => 0x400 },
	'applicationnotes' => { 119 => 0x2bc, 340 => 0x2bc },
	'applicationrecordversion' => { 131 => 0x0 },
	'applyshootingmeteringmode' => { 84 => 0x10e },
	'approved' => { 502 => 'Approved' },
	'approvedby' => { 502 => 'ApprovedBy' },
	'approximatefnumber' => { 330 => 0x313, 337 => 0x3406 },
	'approximatefocusdistance' => { 491 => 'ApproximateFocusDistance' },
	'appversion' => { 505 => 'AppVersion' },
	'aps-csizecapture' => { 454 => 0x114, 455 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 103 => 0x20914 },
	'armidentifier' => { 132 => 0x78 },
	'armversion' => { 132 => 0x7a },
	'arranger' => { 387 => "\xa9arg", 395 => "\xa9arg" },
	'arrangerkeywords' => { 395 => "\xa9ark" },
	'artdirector' => { 387 => "\xa9ard" },
	'artfilter' => { 312 => 0x529 },
	'artfiltereffect' => { 312 => 0x52f },
	'artist' => { 119 => 0x13b, 325 => 'Artist', 340 => 0x13b, 370 => 0x22e, 387 => "\xa9ART", 389 => 'artist', 395 => "\xa9ART", 517 => 'Artist', 521 => 'artist' },
	'artmode' => { 113 => 0x301b },
	'artmodeparameters' => { 113 => 0x310b },
	'artwork' => { 389 => 'artwork' },
	'artworkcircadatecreated' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 507 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 507 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 316 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 316 => 0x1112, 370 => 0x80, 422 => 0x55, 423 => 0x55, 424 => 0xa },
	'assetid' => { 484 => 'AssetID' },
	'asshoticcprofile' => { 119 => 0xc68f },
	'asshotneutral' => { 119 => 0xc628 },
	'asshotpreprofilematrix' => { 119 => 0xc690 },
	'asshotprofilename' => { 119 => 0xc6f6 },
	'asshotwhitexy' => { 119 => 0xc629 },
	'assignbktbutton' => { 294 => '4.2', 295 => '16.1', 297 => '16.1', 298 => '16.1', 307 => '16.1', 308 => '16.1' },
	'assignfuncbutton' => { 84 => 0x70b },
	'assignmb-d17af-onbutton' => { 298 => '79.1' },
	'assignmb-d17funcbutton' => { 298 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 298 => '68.1' },
	'assignmb-d18af-onbutton' => { 308 => '79.1' },
	'assignmb-d18funcbutton' => { 308 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 308 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 297 => '75.1', 298 => '75.1', 308 => '75.1' },
	'assignmoviefunc2button' => { 297 => '82.1', 298 => '82.1', 308 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 297 => '75.2', 298 => '75.2', 308 => '75.2' },
	'assignmovierecordbutton' => { 295 => '43.2', 307 => '45.1', 310 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 297 => '45.1', 298 => '45.1', 308 => '45.1' },
	'assignmoviesubselector' => { 297 => '74.1', 298 => '74.1', 308 => '74.1' },
	'assignmoviesubselectorplusdials' => { 297 => '76.1', 298 => '76.1', 308 => '76.1' },
	'assignremotefnbutton' => { 295 => '54.1', 307 => '51.1' },
	'assistbuttonfunction' => { 82 => 0xd },
	'atcaptureusercrop' => { 138 => 0x943 },
	'attributionname' => { 492 => 'attributionName' },
	'attributionurl' => { 492 => 'attributionURL' },
	'audio' => { 335 => 0x20 },
	'audiobitrate' => { 67 => 0x6c, 507 => 'audioBitRate' },
	'audiobitratemode' => { 507 => 'audioBitRateMode' },
	'audiobitspersample' => { 507 => 'audioBitsPerSample' },
	'audiobutton' => { 310 => 0x17b },
	'audiobuttonplaybackmode' => { 310 => 0x1b9 },
	'audiochannelcount' => { 507 => 'audioChannelCount' },
	'audiochannels' => { 67 => 0x70 },
	'audiochanneltype' => { 521 => 'audioChannelType' },
	'audiocompression' => { 84 => 0x816, 155 => 'Compression' },
	'audiocompressor' => { 521 => 'audioCompressor' },
	'audiodata' => { 476 => 'Data' },
	'audioduration' => { 131 => 0x99 },
	'audiogain' => { 389 => 'player.movie.audio.gain' },
	'audiomimetype' => { 476 => 'Mime' },
	'audiomoddate' => { 521 => 'audioModDate' },
	'audiooutcue' => { 131 => 0x9a },
	'audiosamplerate' => { 67 => 0x6e, 521 => 'audioSampleRate' },
	'audiosampletype' => { 521 => 'audioSampleType' },
	'audiosamplingrate' => { 131 => 0x97 },
	'audiosamplingresolution' => { 131 => 0x98 },
	'audiotype' => { 131 => 0x96 },
	'author' => { 157 => 'Author', 321 => 'Author', 325 => 'Author', 386 => 'Author', 387 => ['auth',"\xa9aut"], 389 => 'author', 395 => 'auth', 489 => 'author', 508 => 'Author', 519 => 'Author' },
	'authorsposition' => { 509 => 'AuthorsPosition' },
	'authorurl' => { 179 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 84 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 361 => '0.1' },
	'autobracket' => { 412 => 0x19 },
	'autobracketing' => { 127 => 0x1100, 370 => 0x18, 402 => 0x1007 },
	'autobracketingmode' => { 306 => '12.3' },
	'autobracketingset' => { 306 => '12.1' },
	'autobracketmodem' => { 294 => '21.2', 295 => '13.3', 297 => '13.2', 298 => '13.2', 303 => '26.2', 307 => '13.3', 308 => '13.2', 310 => 0x5f },
	'autobracketorder' => { 184 => 0x43, 294 => '21.3', 295 => '13.2', 297 => '13.1', 298 => '13.1', 303 => '26.3', 304 => '12.2', 305 => '2.2', 306 => '12.2', 307 => '13.2', 308 => '13.1', 309 => '13.2', 310 => 0x61 },
	'autobracketset' => { 294 => '21.1', 295 => '13.1', 299 => '11.1', 300 => '12.1', 301 => '12.1', 303 => '26.1', 304 => '12.1', 305 => '2.1', 307 => '13.1', 309 => '13.1' },
	'autobrightness' => { 494 => 'AutoBrightness', 496 => 'AutoBrightness' },
	'autocontrast' => { 494 => 'AutoContrast', 496 => 'AutoContrast' },
	'autodistortioncontrol' => { 208 => 0x4, 237 => 0x143 },
	'autodynamicrange' => { 127 => 0x140b },
	'autoexposure' => { 494 => 'AutoExposure', 496 => 'AutoExposure' },
	'autoexposurebracketing' => { 77 => 0x10 },
	'autoflashisosensitivity' => { 297 => '38.5', 298 => '38.5', 308 => '38.5', 310 => 0x5b },
	'autofocus' => { 315 => 0x209 },
	'autofocusmoderestrictions' => { 310 => 0x107 },
	'autofp' => { 305 => '7.3', 309 => '31.4' },
	'autoiso' => { 77 => 0x1, 113 => 0x3008, 238 => 0x142, 239 => 0x156, 296 => '1.1', 305 => '1.1' },
	'autoisomax' => { 296 => '1.2', 305 => '1.2' },
	'autoisominshutterspeed' => { 296 => '1.3', 305 => '1.3' },
	'autolateralca' => { 494 => 'AutoLateralCA', 496 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 62 => 0x2, 84 => 0x204, 103 => 0x20500, 109 => 0x6f },
	'autolightingoptimizeron' => { 103 => '0x20500.0', 109 => 0x6e },
	'autoportraitframed' => { 435 => 0x2016 },
	'autoredeye' => { 287 => 0xfe28a44f },
	'autorotate' => { 77 => 0x1b },
	'autoshadows' => { 494 => 'AutoShadows', 496 => 'AutoShadows' },
	'autotone' => { 494 => 'AutoTone', 496 => 'AutoTone' },
	'autotonedigest' => { 494 => 'AutoToneDigest', 496 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 494 => 'AutoToneDigestNoSat', 496 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 494 => 'AutoWhiteVersion', 496 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 233 => 0x82 },
	'avaperturesetting' => { 351 => 0x13 },
	'averageblacklevel' => { 45 => 0xe7, 47 => 0xfb, 48 => 0x114, 49 => 0x146 },
	'averagelv' => { 187 => 0x38 },
	'avsettingwithoutlens' => { 84 => 0x707 },
	'azimuth' => { 165 => 'Azimuth' },
	'babyage' => { 335 => [0x8010,0x33] },
	'babyname' => { 335 => 0x66 },
	'backgroundalpha' => { 516 => 'bgalpha' },
	'balance' => { 389 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 351 => 0x15 },
	'baseiso' => { 77 => 0x2, 97 => 0x101c, 138 => 0x903, 337 => 0x312a, 466 => 0x6 },
	'baseisodaylight' => { 138 => 0x910 },
	'baseisoflash' => { 138 => 0x913 },
	'baseisofluorescent' => { 138 => 0x912 },
	'baseisotungsten' => { 138 => 0x911 },
	'baselineexposure' => { 119 => 0xc62a },
	'baselineexposureoffset' => { 119 => 0xc7a5 },
	'baselinenoise' => { 119 => 0xc62b },
	'baselinesharpness' => { 119 => 0xc62c },
	'baseurl' => { 519 => 'BaseURL' },
	'bass' => { 389 => 'player.movie.audio.bass' },
	'batterylevel' => { 335 => 0x38, 422 => 0x51, 426 => 0xc, 427 => 0x4, 428 => 0x4, 467 => 0x7 },
	'batterylevelgrip1' => { 467 => 0x6 },
	'batterylevelgrip2' => { 467 => 0x8 },
	'batteryorder' => { 294 => '12.5', 303 => '13.2', 304 => '2.1', 307 => '3.1' },
	'batterystate' => { 184 => 0x60, 422 => 0x50, 428 => 0x14 },
	'batterytemperature' => { 426 => 0x1, 428 => 0x2, 467 => 0x5 },
	'batterytype' => { 64 => 0x38, 398 => 0x66 },
	'batteryunknown' => { 426 => 0x2, 428 => 0x0 },
	'batteryvoltage' => { 138 => 0x408, 396 => 0x2a, 397 => 0x49, 398 => 0x62, 426 => 0x8 },
	'batteryvoltage1' => { 428 => 0x6 },
	'batteryvoltage2' => { 428 => 0x8 },
	'batteryvoltageavg' => { 398 => 0x64 },
	'bayergreensplit' => { 119 => 0xc62d },
	'bayerpattern' => { 137 => 0xf902, 188 => 0x17 },
	'beatsperminute' => { 387 => 'tmpo' },
	'beatspliceparams' => { 521 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 521 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 521 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 521 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 521 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 521 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 294 => '13.1', 295 => '5.4', 296 => '0.1', 299 => '2.1', 300 => '3.1', 301 => '3.1', 303 => '10.1', 305 => '0.1', 307 => '5.5', 309 => '4.1' },
	'beeppitch' => { 304 => '3.1' },
	'beepvolume' => { 304 => '4.5' },
	'bestqualityscale' => { 119 => 0xc65c },
	'bestshotmode' => { 113 => 0x3007 },
	'bitdepth' => { 162 => 'BitDepth', 188 => 0x11, 254 => 0x41 },
	'bitspercomponent' => { 133 => 0x87 },
	'bitspersample' => { 119 => 0x102, 340 => 0xa, 517 => 'BitsPerSample' },
	'blackacquirerows' => { 138 => 0x18ba },
	'blacklevel' => { 119 => [0x7310,0xc61a], 206 => 0x20, 233 => 0x3d, 317 => [0x401,0x1012], 379 => 0x21d, 442 => [0x7300,0x7310] },
	'blacklevel2' => { 316 => 0x600, 320 => 0x600 },
	'blacklevelblue' => { 340 => 0x1e },
	'blacklevelbottom' => { 138 => 0x3f0 },
	'blackleveldata' => { 379 => 0x223 },
	'blackleveldeltah' => { 119 => 0xc61b },
	'blackleveldeltav' => { 119 => 0xc61c },
	'blacklevelgreen' => { 340 => 0x1d },
	'blacklevelred' => { 340 => 0x1c },
	'blacklevelrepeatdim' => { 119 => 0xc619 },
	'blacklevelrough' => { 138 => 0x40e },
	'blacklevelroughafter' => { 138 => 0x416 },
	'blacklevels' => { 35 => 0x1d },
	'blackleveltop' => { 138 => 0x3ef },
	'blackpoint' => { 370 => 0x200 },
	'blacks2012' => { 494 => 'Blacks2012', 496 => 'Blacks2012' },
	'blacksadj' => { 470 => 0x9018 },
	'bleachbypasstoning' => { 370 => 0x7f },
	'blockshotafresponse' => { 297 => '1.5', 298 => '1.5', 308 => '1.5', 310 => 0x7 },
	'blogtitle' => { 511 => 'blogTitle' },
	'blogurl' => { 511 => 'blogURL' },
	'bluebalance' => { 317 => 0x1018, 340 => 0x12, 370 => 0x1b },
	'bluecurvelimits' => { 108 => 0x1fe },
	'bluecurvepoints' => { 107 => 0x79, 108 => 0x1d4 },
	'bluehsl' => { 103 => 0x20915 },
	'bluehue' => { 494 => 'BlueHue', 496 => 'BlueHue' },
	'bluesaturation' => { 494 => 'BlueSaturation', 496 => 'BlueSaturation' },
	'bluratinfinity' => { 480 => 'BlurAtInfinity' },
	'blurcontrol' => { 370 => 0x82 },
	'blurwarning' => { 127 => 0x1300 },
	'bodybatteryadload' => { 349 => 0x3 },
	'bodybatteryadnoload' => { 349 => 0x2 },
	'bodybatterystate' => { 349 => '1.1' },
	'bodybatteryvoltage1' => { 349 => 0x2 },
	'bodybatteryvoltage2' => { 349 => 0x4 },
	'bodybatteryvoltage3' => { 349 => 0x6 },
	'bodybatteryvoltage4' => { 349 => 0x8 },
	'bodyfirmware' => { 403 => 0x0 },
	'bodyfirmwareversion' => { 313 => 0x104, 314 => 0x100, 317 => 0x104 },
	'bodyserialnumber' => { 403 => 0x10 },
	'bookedition' => { 511 => 'bookEdition' },
	'bootloaderversion' => { 397 => 0x26 },
	'bracketincrement' => { 238 => 0x21a, 239 => 0x22e },
	'bracketmode' => { 57 => 0x3 },
	'bracketprogram' => { 238 => 0x218, 239 => 0x22c },
	'bracketsequence' => { 113 => 0x301d },
	'bracketset' => { 238 => 0x216, 239 => 0x22a },
	'bracketsettings' => { 335 => 0x45 },
	'bracketshotnumber' => { 57 => 0x5, 351 => 0x9, 433 => 0x2b },
	'bracketshotnumber2' => { 433 => 0x2d },
	'bracketstep' => { 181 => 0xe },
	'bracketvalue' => { 57 => 0x4 },
	'brightness' => { 119 => 0xfe53, 156 => 'Brightness', 176 => 'Brightness', 181 => 0x2c, 246 => 0x34, 247 => 0x39, 248 => 0x41, 389 => 'player.movie.visual.brightness', 396 => 0x25, 398 => 0x54, 422 => 0x22, 435 => 0x2007, 494 => 'Brightness', 496 => 'Brightness' },
	'brightnessadj' => { 108 => 0x114, 280 => 0x0, 290 => 0x2d, 470 => 0x8018 },
	'brightnessvalue' => { 119 => 0x9203, 187 => [0x691,0x49c3], 317 => 0x1003, 440 => 0x1e, 444 => 0x1140, 445 => 0x1140, 446 => 0x111c, 447 => 0x1198, 448 => 0x1174, 449 => 0x102c, 450 => 0x224, 451 => 0x224, 452 => 0x219, 500 => 'BrightnessValue' },
	'buildnumber' => { 191 => 0x5500 },
	'bulbduration' => { 77 => 0x18 },
	'burstcount' => { 138 => 0x40d },
	'burstgroupid' => { 235 => 0x4 },
	'burstid' => { 477 => 'BurstID' },
	'burstmode' => { 140 => 0xa, 335 => 0x2a },
	'burstmode2' => { 140 => 0x18 },
	'burstprimary' => { 477 => 'BurstPrimary' },
	'burstshot' => { 412 => 0x34 },
	'burstspeed' => { 335 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 84 => 0x70a },
	'bwadjustment' => { 127 => 0x1049 },
	'bwfilter' => { 181 => 0x2a, 189 => 0x39 },
	'bwmagentagreen' => { 127 => 0x104b },
	'bwmode' => { 317 => 0x203 },
	'by-line' => { 131 => 0x50 },
	'by-linetitle' => { 131 => 0x55 },
	'bytecount' => { 511 => 'byteCount' },
	'c14configuration' => { 138 => 0x1964 },
	'cacheversion' => { 119 => 0xc7aa },
	'calibratedfocallength' => { 116 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 116 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 116 => 'CalibratedOpticalCenterY' },
	'calibration' => { 412 => [0x24,0x30] },
	'calibrationhistory' => { 138 => 0x9c9 },
	'calibrationilluminant1' => { 119 => 0xc65a },
	'calibrationilluminant2' => { 119 => 0xc65b },
	'calibrationilluminant3' => { 119 => 0xcd31 },
	'calibrationversion' => { 138 => 0x9c6 },
	'callforimage' => { 484 => 'CallForImage' },
	'camera' => { 473 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 395 => 'angl', 521 => 'cameraAngle' },
	'cameraappinfo' => { 473 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 473 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 473 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 473 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 478 => 'CameraBurstID' },
	'cameracalibration' => { 412 => 0x11f },
	'cameracalibration1' => { 119 => 0xc623 },
	'cameracalibration2' => { 119 => 0xc624 },
	'cameracalibration3' => { 119 => 0xcd32 },
	'cameracalibrationsig' => { 119 => 0xc6f3 },
	'cameracolorcalibration01' => { 36 => 0x0, 37 => 0x0 },
	'cameracolorcalibration02' => { 36 => 0x4, 37 => 0x5 },
	'cameracolorcalibration03' => { 36 => 0x8, 37 => 0xa },
	'cameracolorcalibration04' => { 36 => 0xc, 37 => 0xf },
	'cameracolorcalibration05' => { 36 => 0x10, 37 => 0x14 },
	'cameracolorcalibration06' => { 36 => 0x14, 37 => 0x19 },
	'cameracolorcalibration07' => { 36 => 0x18, 37 => 0x1e },
	'cameracolorcalibration08' => { 36 => 0x1c, 37 => 0x23 },
	'cameracolorcalibration09' => { 36 => 0x20, 37 => 0x28 },
	'cameracolorcalibration10' => { 36 => 0x24, 37 => 0x2d },
	'cameracolorcalibration11' => { 36 => 0x28, 37 => 0x32 },
	'cameracolorcalibration12' => { 36 => 0x2c, 37 => 0x37 },
	'cameracolorcalibration13' => { 36 => 0x30, 37 => 0x3c },
	'cameracolorcalibration14' => { 36 => 0x34, 37 => 0x41 },
	'cameracolorcalibration15' => { 36 => 0x38, 37 => 0x46 },
	'cameradepthmap' => { 473 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 473 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 473 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 473 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 473 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 473 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 473 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 473 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 473 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 473 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 473 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 473 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 389 => 'direction.facing' },
	'camerae-mountversion' => { 469 => 0xb },
	'cameraelevationangle' => { 119 => 0x9405, 501 => 'CameraElevationAngle' },
	'camerafilename' => { 484 => 'CameraFilename' },
	'cameraid' => { 317 => 0x209, 395 => 'cmid', 411 => 0x209 },
	'cameraidentifier' => { 389 => 'camera.identifier' },
	'cameraimage' => { 473 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 473 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 473 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 473 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 473 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 473 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 473 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 473 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 473 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 473 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 473 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 473 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 473 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 473 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 34 => 0x10 },
	'cameralabel' => { 119 => 0xc7a1, 521 => 'cameraLabel' },
	'cameralightestimate' => { 473 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 473 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 473 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 473 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 473 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 484 => 'CameraMakeModel' },
	'cameramodel' => { 379 => 0x410, 521 => 'cameraModel' },
	'cameramodelid' => { 176 => 'CameraModelID' },
	'cameramodelrestriction' => { 494 => 'CameraModelRestriction', 496 => 'CameraModelRestriction' },
	'cameramotion' => { 389 => 'direction.motion' },
	'cameramove' => { 521 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 335 => 0x8f, 374 => 0x1, 379 => 0x100, 428 => [0x16,0x18], 457 => 0x28, 458 => 0x24, 459 => 0x29 },
	'cameraowner' => { 141 => 0xc353 },
	'cameraparameters' => { 317 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 115 => 0x9, 395 => "\xa9gpt" },
	'camerapointcloud' => { 473 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 473 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 473 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 473 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 473 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 473 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 473 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 473 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 473 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 473 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 473 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 473 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 473 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 494 => 'CameraProfile', 496 => 'CameraProfile' },
	'cameraprofiledigest' => { 494 => 'CameraProfileDigest', 496 => 'CameraProfileDigest' },
	'cameraprofiles' => { 509 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 509 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 509 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 509 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 509 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 509 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 509 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 509 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 509 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 509 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 509 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 509 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 509 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 509 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 509 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 509 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 509 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 509 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 509 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 509 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 509 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 509 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 509 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 109 => 0xe1 },
	'camerarawcontrast' => { 109 => 0xe3 },
	'camerarawhighlightpoint' => { 109 => 0xe6 },
	'camerarawlinear' => { 109 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 109 => 0xe8 },
	'camerarawoutputshadowpoint' => { 109 => 0xe9 },
	'camerarawsaturation' => { 109 => 0xe2 },
	'camerarawshadowpoint' => { 109 => 0xe7 },
	'camerarawsharpness' => { 109 => 0xe5 },
	'cameraroll' => { 115 => 0xb, 395 => "\xa9grl" },
	'cameras' => { 473 => 'Cameras' },
	'cameraserialnumber' => { 119 => 0xc62f, 178 => 'CameraSerialNumber', 484 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 312 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 30 => [0x87,0x91], 31 => [0x99,0x9f,0xa4,0xa8,0x105], 33 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 77 => 0xc, 138 => 0x406, 316 => 0x1306, 330 => 0x320, 337 => 0x3402, 370 => 0x47, 409 => 0x43, 461 => 0x5 },
	'cameratemperature4' => { 375 => 0x14 },
	'cameratemperature5' => { 375 => 0x16 },
	'cameratemperaturerangemax' => { 121 => 0x5 },
	'cameratemperaturerangemin' => { 121 => 0x6 },
	'cameratrait' => { 473 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 77 => 0x1a, 317 => 0x207 },
	'cameratype2' => { 313 => 0x100 },
	'cameravendorinfo' => { 473 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 473 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 473 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 473 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 115 => 0xa, 395 => "\xa9gyw" },
	'camreverse' => { 116 => 'CamReverse' },
	'canondr4' => { 120 => 'CanonDR4' },
	'canonexposuremode' => { 34 => 0x14 },
	'canonfiledescription' => { 97 => 0x805 },
	'canonfilelength' => { 64 => 0xe },
	'canonfirmwareversion' => { 64 => 0x7, 97 => 0x80b },
	'canonflashinfo' => { 97 => 0x1028 },
	'canonflashmode' => { 34 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 34 => 0xa },
	'canonimagetype' => { 64 => 0x6, 97 => 0x815 },
	'canonlogversion' => { 63 => 0xb },
	'canonmodelid' => { 64 => 0x10, 97 => 0x1834 },
	'canonvrd' => { 120 => 'CanonVRD' },
	'caption' => { 489 => 'caption' },
	'caption-abstract' => { 131 => 0x78 },
	'captionsauthornames' => { 499 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 499 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 509 => 'CaptionWriter' },
	'captureframerate' => { 113 => 0x4001 },
	'captureheightnormal' => { 138 => 0x1839 },
	'capturelook' => { 138 => 0xc48 },
	'capturemode' => { 389 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 482 => 'CaptureSoftware' },
	'capturewidthnormal' => { 138 => 0x1838 },
	'capturewidthtest' => { 138 => 0x1842 },
	'cardshutterlock' => { 184 => 0x49 },
	'casioimagesize' => { 113 => 0x9 },
	'catalogsets' => { 131 => 0xff, 475 => 'CatalogSets', 487 => 'CatalogSets' },
	'categories' => { 64 => 0x23, 489 => 'categories' },
	'category' => { 131 => 0xf, 179 => 'WM/Category', 311 => 0x30, 387 => 'catg', 509 => 'Category' },
	'cbcrgain' => { 409 => 0xa036 },
	'cbcrgaindefault' => { 409 => 0xa035 },
	'cbcrmatrix' => { 409 => 0xa034 },
	'cbcrmatrixdefault' => { 409 => 0xa033 },
	'ccdboardversion' => { 330 => 0x331 },
	'ccdscanmode' => { 317 => 0x1039 },
	'ccdsensitivity' => { 277 => 0x6 },
	'ccdversion' => { 330 => 0x330 },
	'ccvavgluminancenits' => { 504 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 504 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 504 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 504 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 504 => 'ccv_white_xy' },
	'cellglobalid' => { 493 => 'cgi' },
	'celllength' => { 119 => 0x109 },
	'cellr' => { 493 => 'r' },
	'celltowerid' => { 493 => 'cellid' },
	'cellwidth' => { 119 => 0x108 },
	'centerafarea' => { 305 => '15.1' },
	'centerfocuspoint' => { 309 => '2.2' },
	'centerpixel' => { 138 => 0x40c },
	'centerweightedareasize' => { 294 => '7.1', 295 => '8.1', 297 => '8.1', 298 => '8.1', 302 => '7.1', 303 => '5.1', 304 => '7.1', 305 => '6.3', 307 => '8.1', 308 => '8.1', 309 => '8.1', 310 => 0x1f },
	'certificate' => { 525 => 'Certificate' },
	'cfainterpolationalgorithm' => { 138 => 0xe60 },
	'cfainterpolationmetric' => { 138 => 0xe61 },
	'cfaoffsetcols' => { 138 => 0xc71 },
	'cfaoffsetrows' => { 138 => 0xc6f },
	'cfapattern' => { 119 => 0xa302, 340 => 0x9, 500 => 'CFAPattern' },
	'cfapattern2' => { 119 => 0x828e },
	'cfapatterncolumns' => { 500 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 500 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 500 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 119 => 0x828d },
	'cfazipperfixthreshold' => { 138 => 0xe62 },
	'channel' => { 511 => 'channel' },
	'channela-lang' => { 511 => [\'channel','channelA-lang'] },
	'channelchannel' => { 511 => [\'channel','channelChannel'] },
	'channels' => { 155 => 'Channels' },
	'channelsubchannel1' => { 511 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 511 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 511 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 511 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 395 => 'chpl' },
	'checkmark' => { 103 => 0x10101, 108 => 0x26a },
	'checkmark2' => { 109 => 0x8e },
	'childfontfiles' => { 526 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 294 => '10.3', 295 => '11.2', 310 => 0x10b },
	'chromablurradius' => { 119 => 0xc631 },
	'chromanoisecolorspace' => { 138 => 0xe6d },
	'chromanoiseedgemapthresh' => { 138 => 0xe6c },
	'chromanoisehighfthresh' => { 138 => 0xe6a },
	'chromanoiselowfthresh' => { 138 => 0xe6b },
	'chromaticaberration' => { 103 => 0x20703, 109 => 0x66, 409 => 0xa051 },
	'chromaticaberrationb' => { 494 => 'ChromaticAberrationB', 496 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 103 => 0x20708, 109 => 0x6b },
	'chromaticaberrationcorr' => { 79 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 119 => 0x7034, 360 => 0x1, 470 => 0x900d },
	'chromaticaberrationcorrparams' => { 119 => 0x7035, 465 => 0x66a, 466 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 103 => '0x20703.0', 109 => 0x62 },
	'chromaticaberrationr' => { 494 => 'ChromaticAberrationR', 496 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 103 => 0x20707, 109 => 0x6a },
	'chromaticaberrationsetting' => { 80 => 0x6 },
	'chrominancenoisereduction' => { 103 => 0x20601, 109 => 0x5e, 412 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 109 => 0x60 },
	'circadatecreated' => { 507 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 494 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 496 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 494 => 'CircularGradientBasedCorrections', 496 => 'CircularGradientBasedCorrections' },
	'city' => { 131 => 0x5a, 161 => 'City', 335 => 0x6d, 509 => 'City' },
	'city2' => { 335 => 0x80 },
	'clarity' => { 127 => 0x100f, 247 => 0x35, 248 => 0x3d, 435 => 0x2036, 494 => 'Clarity', 496 => 'Clarity' },
	'clarity2012' => { 494 => 'Clarity2012', 496 => 'Clarity2012' },
	'claritycontrol' => { 370 => 0x96 },
	'classification' => { 395 => 'clsf' },
	'classifystate' => { 131 => 0xe1 },
	'clearretouch' => { 335 => 0x7c },
	'clearretouchvalue' => { 335 => 0xa3 },
	'client' => { 521 => 'client' },
	'clientname' => { 502 => 'ClientName' },
	'clipboardaspectratio' => { 494 => 'ClipboardAspectRatio', 496 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 494 => 'ClipboardOrientation', 496 => 'ClipboardOrientation' },
	'clipfilename' => { 395 => 'clfn' },
	'clipid' => { 395 => 'clid' },
	'clmodeshootingspeed' => { 294 => '10.2', 295 => '11.3', 297 => '11.2', 298 => '11.2', 303 => '11.2', 304 => '10.2', 307 => '11.2', 308 => '11.2', 309 => '11.1', 310 => 0x3b },
	'cluster' => { 494 => 'Cluster', 496 => 'Cluster' },
	'cmcontrast' => { 320 => 0x2022 },
	'cmddialsreverserotation' => { 310 => 0xba },
	'cmexposurecompensation' => { 320 => 0x2000 },
	'cmhue' => { 320 => 0x2021 },
	'cmsaturation' => { 320 => 0x2020 },
	'cmsharpness' => { 320 => 0x2023 },
	'cmwhitebalance' => { 320 => 0x2001 },
	'cmwhitebalancecomp' => { 320 => 0x2002 },
	'cmwhitebalancegraypoint' => { 320 => 0x2010 },
	'codec' => { 169 => 'Codec' },
	'codedcharacterset' => { 132 => 0x5a },
	'codeversion' => { 395 => 'cver' },
	'collection' => { 325 => 'Collection' },
	'collectionname' => { 170 => [\'Collections','CollectionsCollectionName'], 395 => 'coll' },
	'collections' => { 170 => 'Collections', 489 => 'collections' },
	'collectionuri' => { 170 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 389 => 'player.movie.visual.color', 510 => 'color' },
	'coloraberrationcontrol' => { 287 => 0xc89224b },
	'coloradjustment' => { 412 => 0x14 },
	'coloradjustmentmode' => { 411 => 0x210 },
	'coloranta' => { 526 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 526 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 526 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 526 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 526 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 526 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 526 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 526 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 526 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 526 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 526 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 526 => 'Colorants' },
	'colorantswatchname' => { 526 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 526 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 526 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 526 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 156 => 'ColorBalance' },
	'colorbalanceadj' => { 287 => 0x76a43202 },
	'colorbalanceblue' => { 181 => 0x1e },
	'colorbalancegreen' => { 181 => 0x1d },
	'colorbalancered' => { 181 => 0x1c },
	'colorbalanceversion' => { 205 => 0x4, 206 => 0x4, 207 => 0x0 },
	'colorblur' => { 109 => 0x65 },
	'colorbluron' => { 103 => 0x20704 },
	'colorbooster' => { 287 => 0x5f0e7d23 },
	'colorboostlevel' => { 281 => 0x1 },
	'colorboosttype' => { 281 => 0x0 },
	'colorchromeeffect' => { 127 => 0x1048 },
	'colorchromefxblue' => { 127 => 0x104e },
	'colorclass' => { 381 => 0xde, 382 => 'ColorClass' },
	'colorcompensationfilter' => { 184 => [0x3a,0x5f], 186 => 0x111, 435 => 0xb022 },
	'colorcompensationfiltercustom' => { 422 => 0xd, 423 => 0xc },
	'colorcompensationfilterset' => { 422 => 0x8, 423 => 0x7, 424 => 0x18, 440 => 0xf },
	'colorcontrol' => { 317 => 0x102b },
	'colorcorrection' => { 470 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 312 => 0x532 },
	'colordataversion' => { 41 => 0x0, 42 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0 },
	'coloreffect' => { 335 => 0x28 },
	'colorfilter' => { 112 => 0x17, 113 => 0x3017, 181 => 0x29, 189 => [0x38,0x4d,0x4f], 377 => 0x17 },
	'colorgain' => { 254 => 0x51 },
	'colorgradeblending' => { 494 => 'ColorGradeBlending', 496 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 494 => 'ColorGradeGlobalHue', 496 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 494 => 'ColorGradeGlobalLum', 496 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 494 => 'ColorGradeGlobalSat', 496 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 494 => 'ColorGradeHighlightLum', 496 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 494 => 'ColorGradeMidtoneHue', 496 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 494 => 'ColorGradeMidtoneLum', 496 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 494 => 'ColorGradeMidtoneSat', 496 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 494 => 'ColorGradeShadowLum', 496 => 'ColorGradeShadowLum' },
	'colorhue' => { 103 => 0x20900, 233 => 0x8d },
	'colorimetricreference' => { 119 => 0xc6bf },
	'colorlabel' => { 499 => 'ColorLabel' },
	'colormatrix' => { 63 => 0xa, 316 => 0x200, 317 => 0x1011, 409 => 0xa030 },
	'colormatrix1' => { 119 => 0xc621, 379 => 0x106 },
	'colormatrix2' => { 119 => 0xc622, 320 => 0x200, 379 => 0x226 },
	'colormatrix3' => { 119 => 0xcd33 },
	'colormatrixa' => { 370 => 0x203 },
	'colormatrixa2' => { 370 => 0x21c },
	'colormatrixadobergb' => { 409 => 0xa032 },
	'colormatrixb' => { 370 => 0x204 },
	'colormatrixb2' => { 370 => 0x21d },
	'colormatrixnumber' => { 317 => 0x1019 },
	'colormatrixsrgb' => { 409 => 0xa031 },
	'colormode' => { 113 => 0x3015, 127 => 0x1210, 140 => 0x66, 181 => 0x28, 184 => 0x16, 186 => 0x101, 187 => 0x36, 189 => 0x7, 233 => 0x3, 277 => 0x4, 335 => 0x32, 412 => 0x2c, 435 => 0xb029, 509 => 'ColorMode' },
	'colormoirereduction' => { 103 => 0x20670, 288 => 0x15 },
	'colormoirereductionmode' => { 288 => 0x5 },
	'colormoirereductionon' => { 103 => '0x20670.0' },
	'colornoisereduction' => { 470 => 0x8029, 494 => 'ColorNoiseReduction', 496 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 494 => 'ColorNoiseReductionDetail', 496 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 288 => 0x18 },
	'colornoisereductionsharpness' => { 288 => 0x1c },
	'colornoisereductionsmoothness' => { 494 => 'ColorNoiseReductionSmoothness', 496 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 123 => 0x2 },
	'colorprofile' => { 181 => 0x33 },
	'colorprofilesettings' => { 312 => 0x539 },
	'colorrepresentation' => { 133 => 0x3c },
	'colorsaturationadj' => { 103 => 0x20305 },
	'colorsequence' => { 133 => 0x41 },
	'colorspace' => { 51 => 0x3, 64 => 0xb4, 97 => 0x10b4, 119 => 0xa001, 135 => 0x3, 162 => 'ColorSpace', 182 => 0x2f, 183 => 0x25, 184 => 0x17, 233 => 0x1e, 312 => 0x507, 370 => 0x37, 409 => 0xa011, 412 => 0xb, 422 => 0x1b, 423 => 0x83, 424 => 0xe, 440 => 0x6, 500 => 'ColorSpace' },
	'colorspace2' => { 63 => 0x9 },
	'colorspecapproximation' => { 135 => 0x2 },
	'colorspecdata' => { 135 => 0x3 },
	'colorspecmethod' => { 135 => 0x0 },
	'colorspecprecedence' => { 135 => 0x1 },
	'colortempasshot' => { 38 => 0x4, 39 => 0x7, 40 => 0x1d, 41 => 0x59, 42 => 0x6d, 43 => 0x26, 44 => 0x43, 47 => 0x43, 48 => 0x43, 49 => 0x43, 50 => 0x4b },
	'colortempauto' => { 38 => 0x9, 39 => 0xf, 40 => 0x22, 41 => 0x5e, 42 => 0x72, 43 => 0x1c, 44 => 0x48, 47 => 0x48, 48 => 0x48, 49 => 0x48, 50 => 0x50 },
	'colortempcloudy' => { 38 => 0x22, 39 => 0x37, 40 => 0x31, 41 => 0xa4, 42 => 0xdb, 43 => 0x35, 44 => 0x5c, 47 => 0x75, 48 => 0x8e, 49 => 0x93, 50 => 0x96, 370 => 0x55 },
	'colortempcustom' => { 44 => 0x84 },
	'colortempcustom1' => { 40 => 0x45 },
	'colortempcustom2' => { 40 => 0x4a },
	'colortempdaylight' => { 38 => 0x18, 39 => 0x27, 40 => 0x27, 41 => 0x9a, 42 => 0xd1, 43 => 0x2b, 44 => 0x52, 47 => 0x6b, 48 => 0x84, 49 => 0x89, 50 => 0x8c, 370 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 64 => 0xae, 74 => 0x9, 97 => 0x10ae, 127 => 0x1005, 138 => 0x846, 156 => 'ColorTemperature', 182 => [0x6e,0x49], 183 => 0x3f, 184 => [0x39,0x5e], 186 => 0x10b, 189 => [0x3c,0x4c,0x4e], 330 => 0x321, 370 => 0x50, 402 => 0x1308, 435 => 0xb021, 494 => 'Temperature', 496 => 'Temperature' },
	'colortemperatureadj' => { 470 => 0x8013 },
	'colortemperatureauto' => { 233 => 0x4f },
	'colortemperaturebg' => { 317 => 0x1013 },
	'colortemperaturecustom' => { 422 => 0xc, 423 => 0xb },
	'colortemperaturerg' => { 317 => 0x1014 },
	'colortemperatureset' => { 422 => 0x7, 423 => 0x6 },
	'colortemperaturesetting' => { 184 => 0x25, 424 => 0x17, 440 => 0xe },
	'colortempflash' => { 38 => 0x36, 39 => 0x57, 40 => 0x40, 41 => 0xb8, 42 => 0xef, 43 => 0x49, 44 => 0x70, 47 => 0x89, 48 => 0xa2, 49 => 0xa7, 50 => 0xaa, 370 => 0x5a },
	'colortempflashdata' => { 44 => 0x24a },
	'colortempfluorescent' => { 38 => 0x2c, 39 => 0x47, 40 => 0x3b, 41 => 0xae, 42 => 0xe5, 43 => 0x3f, 44 => 0x66, 47 => 0x7f, 48 => 0x98, 49 => 0x9d, 50 => 0xa0 },
	'colortempfluorescentd' => { 370 => 0x57 },
	'colortempfluorescentn' => { 370 => 0x58 },
	'colortempfluorescentw' => { 370 => 0x59 },
	'colortempkelvin' => { 38 => 0x31, 39 => 0x4f, 41 => 0xb3, 42 => 0xea, 43 => 0x44, 44 => 0x6b, 47 => 0x84, 48 => 0x9d, 49 => 0xa2, 50 => 0xa5, 335 => 0x44, 402 => 0x1307 },
	'colortempmeasured' => { 38 => 0xe, 39 => 0x17, 41 => 0x63, 42 => 0x77, 44 => 0x4d, 47 => 0x4d, 48 => 0x4d, 49 => 0x4d, 50 => 0x55 },
	'colortemppc1' => { 43 => 0x94, 44 => 0x75 },
	'colortemppc2' => { 43 => 0x99, 44 => 0x7a },
	'colortemppc3' => { 43 => 0x9e, 44 => 0x7f },
	'colortempshade' => { 38 => 0x1d, 39 => 0x2f, 40 => 0x2c, 41 => 0x9f, 42 => 0xd6, 43 => 0x30, 44 => 0x57, 47 => 0x70, 48 => 0x89, 49 => 0x8e, 50 => 0x91, 370 => 0x54 },
	'colortemptungsten' => { 38 => 0x27, 39 => 0x3f, 40 => 0x36, 41 => 0xa9, 42 => 0xe0, 43 => 0x3a, 44 => 0x61, 47 => 0x7a, 48 => 0x93, 49 => 0x98, 50 => 0x9b, 370 => 0x56 },
	'colortempunknown' => { 38 => 0x13, 39 => 0x1f, 41 => 0x68, 42 => 0x7c, 43 => 0x21, 47 => 0x52, 48 => 0x52, 49 => 0x52, 50 => 0x5a },
	'colortempunknown10' => { 38 => 0x63, 39 => 0x9f, 41 => 0x95, 42 => 0xa9, 43 => 0x76, 47 => 0xa2, 48 => 0x7f, 49 => 0x7f, 50 => 0x87 },
	'colortempunknown11' => { 38 => 0x68, 39 => 0xa7, 41 => 0xbd, 42 => [0xae,0xb3], 43 => 0x7b, 47 => 0xa7, 48 => 0xa7, 49 => 0x84, 50 => 0xaf },
	'colortempunknown12' => { 38 => 0x6d, 39 => 0xaf, 41 => 0xc2, 42 => 0xb8, 43 => 0x80, 47 => 0xac, 48 => 0xac, 49 => 0xac, 50 => 0xb4 },
	'colortempunknown13' => { 38 => 0x72, 39 => 0xb7, 41 => 0xc7, 42 => 0xbd, 43 => 0x85, 47 => 0xb1, 48 => 0xb1, 49 => 0xb1, 50 => 0xb9 },
	'colortempunknown14' => { 41 => 0xcc, 42 => 0xc2, 43 => 0x8a, 47 => 0xb6, 48 => 0xb6, 49 => 0xb6, 50 => 0xbe },
	'colortempunknown15' => { 41 => 0xd1, 42 => 0xc7, 43 => 0x8f, 47 => 0xbb, 48 => 0xbb, 49 => 0xbb, 50 => 0xc3 },
	'colortempunknown16' => { 41 => 0xd6, 42 => 0xcc, 43 => 0xa3, 48 => 0xc0, 49 => 0xc0, 50 => 0xc8 },
	'colortempunknown17' => { 41 => 0xdb, 42 => 0xf4, 48 => 0xc5, 49 => 0xc5, 50 => 0xcd },
	'colortempunknown18' => { 41 => 0xe0, 42 => 0xf9, 48 => 0xca, 49 => 0xca, 50 => 0xd2 },
	'colortempunknown19' => { 41 => 0xe5, 42 => 0xfe, 48 => 0xcf, 49 => 0xcf, 50 => 0xd7 },
	'colortempunknown2' => { 38 => 0x3b, 39 => 0x5f, 41 => 0x6d, 42 => 0x81, 43 => 0x4e, 47 => 0x57, 48 => 0x57, 49 => 0x57, 50 => 0x5f },
	'colortempunknown20' => { 41 => 0xea, 42 => 0x103, 48 => 0xd4, 49 => 0xd4, 50 => 0xdc },
	'colortempunknown21' => { 41 => 0xef, 42 => 0x108, 49 => 0xd9, 50 => 0xe1 },
	'colortempunknown22' => { 41 => 0xf4, 42 => 0x10d, 49 => 0xde, 50 => 0xe6 },
	'colortempunknown23' => { 41 => 0xf9, 42 => 0x112, 49 => 0xe3, 50 => 0xeb },
	'colortempunknown24' => { 41 => 0xfe, 42 => 0x117, 49 => 0xe8, 50 => 0xf0 },
	'colortempunknown25' => { 41 => 0x103, 42 => 0x11c, 49 => 0xed, 50 => 0xf5 },
	'colortempunknown26' => { 41 => 0x108, 42 => 0x121, 49 => 0xf2, 50 => 0xfa },
	'colortempunknown27' => { 41 => 0x10d, 42 => 0x126, 49 => 0xf7, 50 => 0xff },
	'colortempunknown28' => { 41 => 0x112, 49 => 0xfc, 50 => 0x104 },
	'colortempunknown29' => { 41 => 0x117, 49 => 0x101, 50 => 0x109 },
	'colortempunknown3' => { 38 => 0x40, 39 => 0x67, 41 => 0x72, 42 => 0x86, 43 => 0x53, 47 => 0x5c, 48 => 0x5c, 49 => 0x5c, 50 => 0x64 },
	'colortempunknown30' => { 49 => 0x106 },
	'colortempunknown4' => { 38 => 0x45, 39 => 0x6f, 41 => 0x77, 42 => 0x8b, 43 => 0x58, 47 => 0x61, 48 => 0x61, 49 => 0x61, 50 => 0x69 },
	'colortempunknown5' => { 38 => 0x4a, 39 => 0x77, 41 => 0x7c, 42 => 0x90, 43 => 0x5d, 47 => 0x66, 48 => 0x66, 49 => 0x66, 50 => 0x6e },
	'colortempunknown6' => { 38 => 0x4f, 39 => 0x7f, 41 => 0x81, 42 => 0x95, 43 => 0x62, 47 => 0x8e, 48 => 0x6b, 49 => 0x6b, 50 => 0x73 },
	'colortempunknown7' => { 38 => 0x54, 39 => 0x87, 41 => 0x86, 42 => 0x9a, 43 => 0x67, 47 => 0x93, 48 => 0x70, 49 => 0x70, 50 => 0x78 },
	'colortempunknown8' => { 38 => 0x59, 39 => 0x8f, 41 => 0x8b, 42 => 0x9f, 43 => 0x6c, 47 => 0x98, 48 => 0x75, 49 => 0x75, 50 => 0x7d },
	'colortempunknown9' => { 38 => 0x5e, 39 => 0x97, 41 => 0x90, 42 => 0xa4, 43 => 0x71, 47 => 0x9d, 48 => 0x7a, 49 => 0x7a, 50 => 0x82 },
	'colortint' => { 334 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 34 => 0x2a, 51 => 0x2, 63 => 0x8 },
	'colortoneadj' => { 103 => 0x20304, 108 => 0x11e },
	'colortoneauto' => { 71 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 70 => 0x6c, 71 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 70 => 0x3c, 71 => 0x3c },
	'colortonemonochrome' => { 70 => 0x84, 71 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 70 => 0x54, 71 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 70 => 0x24, 71 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 70 => 0xc, 71 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 70 => 0x9c, 71 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 70 => 0xb4, 71 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 70 => 0xcc, 71 => 0xe4 },
	'comlenblksize' => { 138 => 0xfde8 },
	'commanddialplaybackmode' => { 310 => 0x1cb },
	'commanddials' => { 305 => '5.1' },
	'commanddialsaperturesetting' => { 294 => '17.3', 295 => '18.3', 297 => '18.3', 298 => '18.3', 303 => '33.3', 304 => '17.3', 307 => '18.3', 308 => '18.3' },
	'commanddialschangemainsub' => { 294 => '17.2', 295 => '18.1', 297 => '18.1', 298 => '18.1', 303 => '33.2', 304 => '17.2', 307 => '18.1', 308 => '18.1' },
	'commanddialsmenuandplayback' => { 294 => '17.4', 295 => '18.2', 297 => '18.2', 298 => '18.2', 303 => '33.4', 304 => '17.4', 307 => '18.2', 308 => '18.2' },
	'commanddialsreverserotation' => { 294 => '17.1', 295 => '6.4', 297 => '6.2', 298 => '6.2', 299 => '16.2', 300 => '17.2', 303 => '33.1', 304 => '17.1', 307 => '6.2', 308 => '6.2', 309 => '18.1' },
	'commanderchannel' => { 305 => '10.2', 306 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 305 => '13.1', 306 => '31.1' },
	'commandergroupa_ttlcomp' => { 309 => '32.1' },
	'commandergroupamanualoutput' => { 305 => '13.2', 306 => '28.2' },
	'commandergroupamode' => { 305 => '11.2', 306 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 305 => '14.1', 306 => '32.1' },
	'commandergroupb_ttlcomp' => { 309 => '33.1' },
	'commandergroupbmanualoutput' => { 305 => '14.2', 306 => '29.2' },
	'commandergroupbmode' => { 305 => '11.3', 306 => '29.1' },
	'commanderinternalflash' => { 305 => '11.1', 306 => '27.1' },
	'commanderinternalmanualoutput' => { 305 => '12.2', 306 => '27.2' },
	'commanderinternalttlchannel' => { 303 => '18.2' },
	'commanderinternalttlcomp' => { 305 => '12.1', 306 => '30.2', 309 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 303 => '20.1', 304 => '26.1' },
	'commanderinternalttlcompgroupa' => { 303 => '21.1', 304 => '27.1' },
	'commanderinternalttlcompgroupb' => { 303 => '22.1', 304 => '28.1' },
	'comment' => { 0 => 0x2, 120 => 'Comment', 157 => 'Comment', 325 => 'Comment', 387 => "\xa9cmt", 389 => 'comment', 395 => "\xa9cmt" },
	'compass' => { 405 => 0x4 },
	'compatibleversion' => { 494 => 'CompatibleVersion', 496 => 'CompatibleVersion' },
	'compilation' => { 387 => 'cpil' },
	'compimageimagespersequence' => { 501 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 501 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 501 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 501 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 501 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 501 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 501 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 501 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 501 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 501 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 511 => 'complianceProfile' },
	'componentsconfiguration' => { 119 => 0x9101, 162 => 'Components', 500 => 'ComponentsConfiguration' },
	'componentversion' => { 97 => 0x80c },
	'composer' => { 179 => 'WM/Composer', 387 => ["\xa9com","\xa9wrt"], 395 => ["\xa9com","\xa9wrt"], 521 => 'composer' },
	'composerkeywords' => { 395 => "\xa9cok" },
	'compositeimage' => { 119 => 0xa460, 501 => 'CompositeImage' },
	'compositeimagecount' => { 119 => 0xa461, 501 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 119 => 0xa462, 501 => 'CompositeImageExposureTimes' },
	'composition' => { 484 => 'Composition' },
	'compositionadjust' => { 369 => '0.1' },
	'compositionadjustrotation' => { 369 => 0x7 },
	'compositionadjustx' => { 369 => 0x5 },
	'compositionadjusty' => { 369 => 0x6 },
	'compressedbitsperpixel' => { 119 => 0x9102, 500 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 186 => 0x40, 317 => 0x40 },
	'compression' => { 119 => 0x103, 340 => 0xb, 517 => 'Compression' },
	'compressionfactor' => { 312 => 0x50d },
	'compressionformat' => { 63 => 0x4 },
	'compressionratio' => { 162 => 'Compression', 317 => 0x1034 },
	'compressorversion' => { 395 => 'CNCV' },
	'condadobvfactor' => { 138 => 0xf3e },
	'condadodaybvthresh' => { 138 => 0xf3c },
	'condadodayoffsets' => { 138 => 0xf42 },
	'condadofluoffsets' => { 138 => 0xf44 },
	'condadofluthresh' => { 138 => 0xf41 },
	'condadoillfactor' => { 138 => 0xf3f },
	'condadoneurange' => { 138 => 0xf3d },
	'condadotunoffsets' => { 138 => 0xf43 },
	'condadotunthresh' => { 138 => 0xf40 },
	'conductor' => { 179 => 'WM/Conductor', 387 => "\xa9con" },
	'confidence' => { 479 => 'Confidence' },
	'confidencelevel' => { 490 => 'ConfidenceLevel' },
	'confidencemime' => { 479 => 'ConfidenceMime' },
	'constrainedcropheight' => { 108 => 0x266, 381 => 0xd6 },
	'constrainedcropwidth' => { 108 => 0x262, 381 => 0xd5 },
	'contact' => { 131 => 0x76 },
	'contactinfo' => { 494 => 'ContactInfo', 496 => 'ContactInfo', 510 => 'contactInfo' },
	'container' => { 473 => 'Container' },
	'containerdirectory' => { 473 => [\'Container','ContainerDirectory'] },
	'containerdirectoryitem' => { 473 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 473 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 473 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 473 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 473 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 507 => 'ContainerFormat' },
	'containerformatidentifier' => { 507 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 507 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 387 => "\xa9day", 395 => ['@day',"\xa9day"] },
	'contentdistributor' => { 179 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 395 => 'cdis' },
	'contentid' => { 395 => 'ccid' },
	'contentlocationcode' => { 131 => 0x1a },
	'contentlocationname' => { 131 => 0x1b },
	'contenttype' => { 511 => 'contentType' },
	'continuousbracketing' => { 184 => 0x20 },
	'continuousdrive' => { 34 => 0x5 },
	'continuousmodedisplay' => { 310 => 0x51 },
	'continuousmodeliveview' => { 308 => '77.2' },
	'continuousshootingspeed' => { 84 => 0x610 },
	'continuousshotlimit' => { 84 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 34 => 0xd, 112 => 0xc, 113 => [0x3012,0x20], 119 => [0xa408,0xfe54], 127 => [0x1004,0x1006], 156 => 'Contrast', 176 => 'Contrast', 181 => 0x20, 182 => 0x31, 183 => 0x27, 184 => 0x19, 189 => 0x2, 246 => 0x33, 247 => 0x37, 248 => 0x3f, 317 => 0x1029, 335 => 0x39, 337 => 0x300a, 370 => 0x20, 377 => 0xc, 389 => 'player.movie.visual.contrast', 396 => 0x24, 398 => 0x52, 402 => 0x1012, 412 => 0xd, 422 => 0x1d, 423 => 0x1a, 435 => 0x2004, 494 => 'Contrast', 496 => 'Contrast', 500 => 'Contrast' },
	'contrast2012' => { 494 => 'Contrast2012', 496 => 'Contrast2012' },
	'contrastadj' => { 103 => 0x20303, 108 => 0x115, 290 => 0x2c, 470 => 0x8017 },
	'contrastauto' => { 71 => 0x90 },
	'contrastcurve' => { 233 => 0x8c },
	'contrastdetectaf' => { 193 => 0x4 },
	'contrastdetectafarea' => { 370 => 0x231 },
	'contrastdetectafinfocus' => { 193 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 70 => 0x60, 71 => 0x60 },
	'contrasthighlight' => { 370 => 0x6d },
	'contrasthighlightshadowadj' => { 370 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 70 => 0x30, 71 => 0x30 },
	'contrastmode' => { 335 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 70 => 0x78, 71 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 70 => 0x48, 71 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 70 => 0x18, 71 => 0x18 },
	'contrastsetting' => { 312 => 0x505, 320 => 0x1012, 424 => 0x10, 440 => 0x8 },
	'contrastshadow' => { 370 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 70 => 0x0, 71 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 70 => 0x90, 71 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 70 => 0xa8, 71 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 70 => 0xc0, 71 => 0xd8 },
	'contributedmedia' => { 521 => 'contributedMedia' },
	'contributedmediaduration' => { 521 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 521 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 521 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 521 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 521 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 521 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 521 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 521 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 521 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 521 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 497 => 'contributor', 507 => 'Contributor' },
	'contributoridentifier' => { 507 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 507 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 507 => [\'Contributor','ContributorRole'] },
	'contributors' => { 157 => 'Contributors' },
	'controldialset' => { 184 => 0x46 },
	'controlledvocabularyterm' => { 507 => 'CVterm' },
	'controllerboardversion' => { 330 => 0x332 },
	'controlmode' => { 77 => 0x12 },
	'controlringresponse' => { 310 => 0x1d5 },
	'controlringrotation' => { 84 => 0x712 },
	'conversionlens' => { 313 => 0x403, 335 => 0x35 },
	'converter' => { 119 => 0xfe4d, 277 => 0xb, 494 => 'Converter', 496 => 'Converter' },
	'converttograyscale' => { 494 => 'ConvertToGrayscale', 496 => 'ConvertToGrayscale' },
	'cookingequipment' => { 513 => 'cookingEquipment' },
	'cookingmethod' => { 513 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 119 => 0x8298, 157 => 'Copyright', 325 => 'Copyright', 340 => 0x8298, 370 => 0x22f, 386 => 'Copyright', 387 => ['cprt',"\xa9cpy"], 389 => 'copyright', 395 => ['cprt',"\xa9cpy"], 494 => 'Copyright', 496 => 'Copyright', 508 => 'Copyright', 514 => 'copyright', 517 => 'Copyright', 521 => 'copyright' },
	'copyrightflag' => { 384 => 0x40a },
	'copyrightnotice' => { 131 => 0x74 },
	'copyrightowner' => { 322 => 'CopyrightOwner' },
	'copyrightownerid' => { 322 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 322 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 322 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 322 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 322 => 'CopyrightStatus' },
	'copyrightyear' => { 507 => 'CopyrightYear', 511 => 'copyrightYear' },
	'coringfilter' => { 316 => 0x310, 317 => 0x102d, 320 => 0x310 },
	'coringvalues' => { 316 => 0x311, 320 => 0x311 },
	'corporateentity' => { 511 => 'corporateEntity' },
	'correlatedcolortemp' => { 334 => 0x35b },
	'country' => { 161 => 'Country', 335 => 0x69, 509 => 'Country' },
	'country-primarylocationcode' => { 131 => 0x64 },
	'country-primarylocationname' => { 131 => 0x65 },
	'countrycode' => { 232 => 0x5, 382 => 'CountryCode', 506 => 'CountryCode' },
	'course' => { 513 => 'course' },
	'coverage' => { 497 => 'coverage' },
	'coverart' => { 387 => 'covr' },
	'coverdate' => { 511 => 'coverDate' },
	'coverdisplaydate' => { 511 => 'coverDisplayDate' },
	'coveruri' => { 395 => 'cvru' },
	'cpufirmwareversion' => { 370 => 0x28 },
	'crc32' => { 498 => 'crc32' },
	'createdate' => { 119 => 0x9004, 157 => 'CreateDate', 321 => 'CreationDate', 325 => 'create-date', 386 => 'CreationDate', 392 => 0x1, 519 => 'CreateDate' },
	'creationdate' => { 389 => 'creationdate', 508 => 'CreationDate', 511 => 'creationDate' },
	'creationtime' => { 325 => 'Creation Time' },
	'creativestyle' => { 422 => 0x1a, 423 => 0x18, 433 => 0x41, 435 => 0xb020, 466 => 0x4a },
	'creativestylesetting' => { 424 => 0xf, 440 => 0x7 },
	'creativestylewaschanged' => { 470 => 0x8001 },
	'creator' => { 321 => 'Creator', 386 => 'Creator', 497 => 'creator', 507 => 'Creator', 508 => 'Creator' },
	'creatoraddress' => { 506 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 178 => 'CreatorAppId' },
	'creatorcity' => { 506 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 506 => 'CreatorContactInfo' },
	'creatorcountry' => { 506 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 507 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 507 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 178 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 506 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 506 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 507 => [\'Creator','CreatorRole'] },
	'creatortool' => { 519 => 'CreatorTool' },
	'creatorworkemail' => { 506 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 506 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 506 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 131 => 0x6e, 509 => 'Credit' },
	'creditline' => { 514 => 'creditLine' },
	'creditlinereq' => { 524 => 'CreditLineReq' },
	'creditlinerequired' => { 322 => 'CreditLineRequired' },
	'cropactive' => { 101 => 0x0, 108 => 0x244 },
	'cropangle' => { 494 => 'CropAngle', 496 => 'CropAngle' },
	'croparea' => { 233 => 0x45, 470 => 0x9011 },
	'cropaspectratio' => { 103 => 0x30101, 108 => 0x260 },
	'cropaspectratiocustom' => { 103 => 0x30102 },
	'cropbottom' => { 123 => 0x9, 282 => 0x36, 340 => 0x31, 381 => 0xdc, 494 => 'CropBottom', 496 => 'CropBottom' },
	'cropbottommargin' => { 53 => 0x3 },
	'cropcircleactive' => { 109 => 0xd6 },
	'cropcircleradius' => { 109 => 0xd9 },
	'cropcirclex' => { 109 => 0xd7 },
	'cropcircley' => { 109 => 0xd8 },
	'cropconstraintowarp' => { 494 => 'CropConstrainToWarp', 496 => 'CropConstrainToWarp' },
	'croph' => { 488 => 'CropH' },
	'cropheight' => { 101 => 0x6, 108 => 0x24c, 316 => 0x615, 320 => 0x615, 494 => 'CropHeight', 496 => 'CropHeight' },
	'crophispeed' => { 233 => 0x1b },
	'cropleft' => { 108 => 0x246, 123 => 0x6, 282 => 0x1e, 316 => 0x612, 320 => 0x612, 340 => 0x30, 381 => 0xd9, 494 => 'CropLeft', 496 => 'CropLeft' },
	'cropleftmargin' => { 53 => 0x0 },
	'cropmode' => { 127 => 0x104d, 402 => 0x1018 },
	'croporiginalheight' => { 101 => 0xb },
	'croporiginalwidth' => { 101 => 0xa },
	'cropoutputheight' => { 282 => 0xce },
	'cropoutputheightinches' => { 282 => 0x96 },
	'cropoutputpixels' => { 282 => 0xd6 },
	'cropoutputresolution' => { 282 => 0xb6 },
	'cropoutputscale' => { 282 => 0xbe },
	'cropoutputwidth' => { 282 => 0xc6 },
	'cropoutputwidthinches' => { 282 => 0x8e },
	'croppedareaimageheightpixels' => { 482 => 'CroppedAreaImageHeightPixels', 483 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 482 => 'CroppedAreaImageWidthPixels', 483 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 482 => 'CroppedAreaLeftPixels', 483 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 482 => 'CroppedAreaTopPixels', 483 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 402 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 402 => 0x1603 },
	'cropping' => { 470 => 0x9010 },
	'cropright' => { 123 => 0x8, 282 => 0x2e, 340 => 0x32, 381 => 0xdb, 494 => 'CropRight', 496 => 'CropRight' },
	'croprightmargin' => { 53 => 0x1 },
	'croprotatedoriginalheight' => { 101 => 0x2 },
	'croprotatedoriginalwidth' => { 101 => 0x1 },
	'croprotation' => { 101 => 0x8, 123 => 0xb },
	'cropscaledresolution' => { 282 => 0x9e },
	'cropsourceresolution' => { 282 => 0xae },
	'croptop' => { 108 => 0x248, 123 => 0x7, 282 => 0x26, 316 => 0x613, 320 => 0x613, 340 => 0x2f, 381 => 0xda, 494 => 'CropTop', 496 => 'CropTop' },
	'croptopmargin' => { 53 => 0x2 },
	'cropunit' => { 494 => 'CropUnit', 496 => 'CropUnit' },
	'cropunits' => { 494 => 'CropUnits', 496 => 'CropUnits' },
	'cropw' => { 488 => 'CropW' },
	'cropwidth' => { 101 => 0x5, 108 => 0x24a, 316 => 0x614, 320 => 0x614, 494 => 'CropWidth', 496 => 'CropWidth' },
	'cropx' => { 101 => 0x3, 488 => 'CropX' },
	'cropy' => { 101 => 0x4, 488 => 'CropY' },
	'crossprocess' => { 370 => 0x7b },
	'crossprocessparams' => { 370 => 0x235 },
	'cuisine' => { 513 => 'cuisine' },
	'currenticcprofile' => { 119 => 0xc691 },
	'currentpreprofilematrix' => { 119 => 0xc692 },
	'currentversion' => { 470 => 0xd000 },
	'curve0x' => { 488 => 'Curve0x' },
	'curve0y' => { 488 => 'Curve0y' },
	'curve1x' => { 488 => 'Curve1x' },
	'curve1y' => { 488 => 'Curve1y' },
	'curve2x' => { 488 => 'Curve2x' },
	'curve2y' => { 488 => 'Curve2y' },
	'curve3x' => { 488 => 'Curve3x' },
	'curve3y' => { 488 => 'Curve3y' },
	'curve4x' => { 488 => 'Curve4x' },
	'curve4y' => { 488 => 'Curve4y' },
	'curves' => { 287 => 0x76a43201 },
	'custom1' => { 322 => 'Custom1' },
	'custom10' => { 322 => 'Custom10' },
	'custom2' => { 322 => 'Custom2' },
	'custom3' => { 322 => 'Custom3' },
	'custom4' => { 322 => 'Custom4' },
	'custom5' => { 322 => 'Custom5' },
	'custom6' => { 322 => 'Custom6' },
	'custom7' => { 322 => 'Custom7' },
	'custom8' => { 322 => 'Custom8' },
	'custom9' => { 322 => 'Custom9' },
	'customcolortone' => { 109 => 0x4c },
	'customcontrast' => { 109 => 0x4e },
	'customcontrols' => { 84 => 0x70c },
	'customdefaultunsharpfineness' => { 109 => 0xbe },
	'customdefaultunsharpstrength' => { 109 => 0xbc },
	'customdefaultunsharpthreshold' => { 109 => 0xc0 },
	'customilluminant' => { 138 => 0x405 },
	'customizedials' => { 84 => 0x715 },
	'customlinear' => { 109 => 0x4f },
	'customoutputhighlightpoint' => { 109 => 0x53 },
	'customoutputshadowpoint' => { 109 => 0x54 },
	'custompicturestyle' => { 103 => 0x10021 },
	'custompicturestyledata' => { 103 => 0xf0500 },
	'custompicturestylefilename' => { 64 => 0x4010 },
	'customrawhighlight' => { 109 => 0x7c },
	'customrawhighlightpoint' => { 109 => 0x51 },
	'customrawshadow' => { 109 => 0x85 },
	'customrawshadowpoint' => { 109 => 0x52 },
	'customrendered' => { 119 => 0xa401, 191 => 0x6420, 500 => 'CustomRendered' },
	'customsaturation' => { 109 => 0x4d, 312 => 0x503 },
	'customsettingsalldefault' => { 294 => '0.2', 303 => '0.2' },
	'customsettingsbank' => { 294 => '0.1', 295 => '0.1', 297 => '0.1', 298 => '0.1', 303 => '0.1', 307 => '0.2', 308 => '0.2', 310 => 0x1 },
	'customsharpness' => { 109 => 0x50 },
	'customunsharpmaskfineness' => { 109 => 0xb8 },
	'customunsharpmaskstrength' => { 109 => 0xb6 },
	'customunsharpmaskthreshold' => { 109 => 0xba },
	'customwb_rblevels' => { 440 => 0x1a },
	'customwb_rgblevels' => { 423 => 0x8, 424 => 0x19 },
	'customwbbluelevel' => { 184 => 0x36 },
	'customwberror' => { 184 => 0x37 },
	'customwbgreenlevel' => { 184 => 0x35 },
	'customwbredlevel' => { 184 => 0x34 },
	'customwbsetting' => { 184 => 0x26 },
	'cx' => { 395 => '_cx_' },
	'cy' => { 395 => '_cy_' },
	'd-lightinghq' => { 287 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 283 => 0x2 },
	'd-lightinghqhighlight' => { 283 => 0x1 },
	'd-lightinghqselected' => { 287 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 283 => 0x0 },
	'd-lightinghs' => { 287 => 0xce5554aa },
	'd-lightinghsadjustment' => { 284 => 0x0 },
	'd-lightinghscolorboost' => { 284 => 0x1 },
	'd-rangeoptimizerhighlight' => { 470 => 0x8024 },
	'd-rangeoptimizermode' => { 470 => 0x8022 },
	'd-rangeoptimizershadow' => { 470 => 0x802d },
	'd-rangeoptimizervalue' => { 470 => 0x8023 },
	'darkblacksegrows' => { 138 => 0x18d8 },
	'darkfocusenvironment' => { 335 => 0x8003 },
	'darkframecountfactor' => { 138 => 0xc85 },
	'darkframelongexposure' => { 138 => 0xc84 },
	'darkframeshortexposure' => { 138 => 0xc83 },
	'darkpedestal' => { 138 => 0xc7f },
	'datacompressionmethod' => { 133 => 0x6e },
	'dataimprint' => { 181 => 0x34 },
	'dataonscreen' => { 507 => 'DataOnScreen' },
	'dataonscreenregion' => { 507 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 507 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 507 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 507 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 507 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 507 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 507 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 507 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 370 => 0x3d },
	'date' => { 370 => 0x6, 497 => 'date' },
	'dateacquired' => { 178 => 'DateAcquired', 179 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 131 => 0x37, 509 => 'DateCreated' },
	'datedisplayformat' => { 279 => 0x3 },
	'dateidentified' => { 118 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 299 => '4.2' },
	'daterecieved' => { 511 => 'dateRecieved' },
	'datesent' => { 132 => 0x46 },
	'datestampmode' => { 64 => 0x1c, 233 => 0x9d },
	'datetime' => { 489 => 'datetime', 517 => 'DateTime' },
	'datetimedigitized' => { 500 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 100 => 0x0, 119 => 0x9003, 154 => 0x14, 157 => 'OriginalDate', 390 => 'IDIT', 395 => 'date', 396 => 0xb, 397 => 0x3b, 398 => 0x3e, 500 => 'DateTimeOriginal' },
	'datetimestamp' => { 140 => 0x64 },
	'datetimeutc' => { 312 => 0x908 },
	'daylightsavings' => { 78 => 0x3, 279 => 0x2 },
	'dayofweek' => { 397 => 0x42, 398 => 0x4a },
	'dccontinent' => { 118 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 118 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 118 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 118 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 118 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 118 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 118 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 118 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 118 => 'Event' },
	'dcfootprintspatialfit' => { 118 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 118 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 118 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 118 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 118 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 118 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 118 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 118 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 118 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 118 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 118 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 118 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 118 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 118 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 118 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 118 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 118 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 118 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 165 => 'Declination' },
	'decposition' => { 181 => 0x32 },
	'defaultautogray' => { 494 => 'DefaultAutoGray', 496 => 'DefaultAutoGray' },
	'defaultautotone' => { 494 => 'DefaultAutoTone', 496 => 'DefaultAutoTone' },
	'defaultblackrender' => { 119 => 0xc7a6 },
	'defaultcroporigin' => { 119 => 0xc61f },
	'defaultcropsize' => { 119 => 0xc620 },
	'defaulteraseoption' => { 84 => 0x813 },
	'defaultscale' => { 119 => 0xc61e },
	'defaultsspecifictoiso' => { 494 => 'DefaultsSpecificToISO', 496 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 494 => 'DefaultsSpecificToSerial', 496 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 119 => 0xc7b5 },
	'defectisocode' => { 138 => 0x90f },
	'defringe' => { 494 => 'Defringe', 496 => 'Defringe' },
	'defringegreenamount' => { 494 => 'DefringeGreenAmount', 496 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 494 => 'DefringeGreenHueHi', 496 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 494 => 'DefringeGreenHueLo', 496 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 494 => 'DefringePurpleAmount', 496 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 494 => 'DefringePurpleHueHi', 496 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 494 => 'DefringePurpleHueLo', 496 => 'DefringePurpleHueLo' },
	'dehaze' => { 494 => 'Dehaze', 496 => 'Dehaze' },
	'deletedimagecount' => { 233 => 0xa6, 259 => 0x6e },
	'deprecatedon' => { 492 => 'deprecatedOn' },
	'depthfar' => { 119 => 0xc7eb },
	'depthformat' => { 119 => 0xc7e9 },
	'depthimage' => { 479 => 'Data' },
	'depthmeasuretype' => { 119 => 0xc7ed },
	'depthnear' => { 119 => 0xc7ea },
	'depthunits' => { 119 => 0xc7ec },
	'derivedfrom' => { 522 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 522 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 522 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 522 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 522 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 522 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 522 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 522 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 522 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 522 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 522 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 522 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 522 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 522 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 522 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 522 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 522 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 522 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 522 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 522 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 522 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 522 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 522 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 522 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 325 => 'Description', 387 => ['desc','dscp',"\xa9des"], 389 => 'description', 395 => 'dscp', 494 => 'Description', 496 => 'Description', 497 => 'description', 519 => 'Description' },
	'destination' => { 132 => 0x5 },
	'destinationcity' => { 370 => 0x24, 376 => 0x3 },
	'destinationcitycode' => { 377 => 0x1001 },
	'destinationdst' => { 370 => 0x26, 376 => '0.3' },
	'developmentdynamicrange' => { 127 => 0x1403 },
	'deviantmatrixcustom' => { 138 => 0x7de },
	'deviantmatrixdaylight' => { 138 => 0x7da },
	'deviantmatrixflash' => { 138 => 0x7dd },
	'deviantmatrixfluorescent' => { 138 => 0x7dc },
	'deviantmatrixtungsten' => { 138 => 0x7db },
	'deviantwhitecustom' => { 138 => 0x842 },
	'deviantwhitedaylight' => { 138 => 0x83e },
	'deviantwhiteflash' => { 138 => 0x841 },
	'deviantwhitefluorescent' => { 138 => 0x840 },
	'deviantwhitetungsten' => { 138 => 0x83f },
	'device' => { 511 => 'device' },
	'devicesettingdescription' => { 500 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 500 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 500 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 500 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 409 => 0x2 },
	'dewarpdata' => { 116 => 'DewarpData' },
	'dewarpflag' => { 116 => 'DewarpFlag' },
	'dialdirectiontvav' => { 84 => 0x706 },
	'dietaryneeds' => { 513 => 'dietaryNeeds' },
	'diffractioncompensation' => { 222 => 0x20e, 237 => 0x142, 238 => 0x1a2, 239 => 0x1b6 },
	'diffractioncorrection' => { 335 => 0xbc, 360 => 0x3 },
	'diffractioncorrectionon' => { 103 => 0x2070b },
	'digitalcreationdate' => { 131 => 0x3e },
	'digitalcreationtime' => { 131 => 0x3f },
	'digitaldeehighlightadj' => { 254 => 0x202 },
	'digitaldeeshadowadj' => { 254 => 0x200 },
	'digitaldeethreshold' => { 254 => 0x201 },
	'digitalfilter' => { 412 => 0x59 },
	'digitalfilter01' => { 357 => 0x5 },
	'digitalfilter02' => { 357 => 0x16 },
	'digitalfilter03' => { 357 => 0x27 },
	'digitalfilter04' => { 357 => 0x38 },
	'digitalfilter05' => { 357 => 0x49 },
	'digitalfilter06' => { 357 => 0x5a },
	'digitalfilter07' => { 357 => 0x6b },
	'digitalfilter08' => { 357 => 0x7c },
	'digitalfilter09' => { 357 => 0x8d },
	'digitalfilter10' => { 357 => 0x9e },
	'digitalfilter11' => { 357 => 0xaf },
	'digitalfilter12' => { 357 => 0xc0 },
	'digitalfilter13' => { 357 => 0xd1 },
	'digitalfilter14' => { 357 => 0xe2 },
	'digitalfilter15' => { 357 => 0xf3 },
	'digitalfilter16' => { 357 => 0x104 },
	'digitalfilter17' => { 357 => 0x115 },
	'digitalfilter18' => { 357 => 0x126 },
	'digitalfilter19' => { 357 => 0x137 },
	'digitalfilter20' => { 357 => 0x148 },
	'digitalgain' => { 74 => 0xb },
	'digitalgem' => { 217 => 0x0 },
	'digitalice' => { 254 => 0x100 },
	'digitalimageguid' => { 507 => 'DigImageGUID' },
	'digitallensoptimizer' => { 62 => 0xa },
	'digitallensoptimizersetting' => { 80 => 0x9 },
	'digitalroc' => { 251 => 0x0 },
	'digitalsourcefiletype' => { 507 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 507 => 'DigitalSourceType' },
	'digitalzoom' => { 34 => 0xc, 112 => 0xa, 127 => 0x1044, 140 => 0x68, 151 => 0x22, 152 => 0x1e, 156 => 'DigitalZoom', 181 => 0xc, 233 => 0x86, 277 => 0xa, 317 => 0x204, 370 => 0x1e, 377 => 0xa, 411 => 0x204, 457 => 0x12, 458 => 0x12 },
	'digitalzoomon' => { 411 => 0x21b },
	'digitalzoomratio' => { 119 => 0xa404, 446 => 0x200, 448 => 0x21c, 500 => 'DigitalZoomRatio' },
	'director' => { 179 => 'WM/Director', 387 => "\xa9dir", 389 => 'director', 395 => "\xa9dir", 521 => 'director' },
	'directorphotography' => { 521 => 'directorPhotography' },
	'directory' => { 120 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 210 => 0x3, 398 => 0x12 },
	'disableautocreation' => { 477 => 'DisableAutoCreation' },
	'disclaimer' => { 325 => 'Disclaimer' },
	'discnumber' => { 521 => 'discNumber' },
	'dishtype' => { 513 => 'dishType' },
	'disknumber' => { 387 => 'disk' },
	'displayallafpoints' => { 84 => 0x514 },
	'displayaperture' => { 34 => 0x23 },
	'displayedunitsx' => { 385 => 0x2 },
	'displayedunitsy' => { 385 => 0x6 },
	'displayname' => { 389 => 'displayname', 510 => 'displayName' },
	'distance1' => { 140 => 0x28 },
	'distance2' => { 140 => 0x2c },
	'distance3' => { 140 => 0x30 },
	'distance4' => { 140 => 0x34 },
	'distortion' => { 409 => 0xa050 },
	'distortioncompensation' => { 470 => 0x8040 },
	'distortioncontrol' => { 259 => 0x10 },
	'distortioncorrection' => { 79 => 0x3, 103 => 0x20705, 109 => 0x67, 119 => 0x7036, 312 => 0x50b, 339 => '7.1', 360 => 0x0, 465 => 0x601, 466 => 0x5b },
	'distortioncorrection2' => { 316 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 491 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 103 => '0x20705.0', 109 => 0x63 },
	'distortioncorrectionsetting' => { 80 => 0x7, 435 => 0x2013 },
	'distortioncorrectionvalue' => { 79 => 0x9 },
	'distortioncorrparams' => { 119 => 0x7037, 445 => 0x1a23, 448 => 0x1870, 450 => 0x189c, 451 => 0x18cc, 452 => 0x17d0, 465 => 0x6ca, 466 => 0x64 },
	'distortioncorrparamsnumber' => { 448 => 0x1899, 450 => 0x18c5, 451 => 0x18f5, 452 => 0x17f9 },
	'distortioncorrparamspresent' => { 448 => 0x1898, 450 => 0x18c4, 451 => 0x18f4, 452 => 0x17f8, 454 => 0x10b, 455 => 0x10b, 465 => 0x600, 466 => 0x5a },
	'distortioneffect' => { 103 => 0x20709 },
	'distortionn' => { 339 => 0xc },
	'distortionparam02' => { 339 => 0x2 },
	'distortionparam04' => { 339 => 0x4 },
	'distortionparam08' => { 339 => 0x8 },
	'distortionparam09' => { 339 => 0x9 },
	'distortionparam11' => { 339 => 0xb },
	'distortionscale' => { 339 => 0x5 },
	'distributor' => { 511 => 'distributor' },
	'distributorproductid' => { 510 => 'distributorProductID' },
	'dloon' => { 103 => '0x20706.0', 109 => 0xdc },
	'dlosetting' => { 103 => 0x20706, 109 => 0xdd },
	'dlosettingapplied' => { 102 => 0x4 },
	'dloshootingdistance' => { 109 => 0xde },
	'dloversion' => { 102 => 0x5 },
	'dmcomment' => { 521 => 'comment' },
	'dmdithermatrix' => { 138 => 0xc7a },
	'dmdithermatrixheight' => { 138 => 0xc7c },
	'dmdithermatrixwidth' => { 138 => 0xc7b },
	'dngadobedata' => { 119 => 0xc634 },
	'dngbackwardversion' => { 119 => 0xc613 },
	'dngignoresidecars' => { 494 => 'DNGIgnoreSidecars', 496 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 119 => 0xc630 },
	'dngprivatedata' => { 119 => 0xc634 },
	'dngversion' => { 119 => 0xc612 },
	'document' => { 325 => 'Document' },
	'documentancestors' => { 509 => 'DocumentAncestors' },
	'documenthistory' => { 131 => 0xe7 },
	'documentid' => { 522 => 'DocumentID' },
	'documentname' => { 119 => 0x10d },
	'documentnotes' => { 131 => 0xe6 },
	'doi' => { 511 => 'doi' },
	'dopesheet' => { 507 => 'Dopesheet' },
	'dopesheetlink' => { 507 => 'DopesheetLink' },
	'dopesheetlinklink' => { 507 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 507 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 138 => 0xc82 },
	'dpp' => { 489 => 'dpp' },
	'dr4cameramodel' => { 104 => 0x3 },
	'drangepriority' => { 127 => 0x1443 },
	'drangepriorityauto' => { 127 => 0x1444 },
	'drangepriorityfixed' => { 127 => 0x1445 },
	'drivemode' => { 113 => 0x3103, 125 => '0.1', 181 => 0x6, 184 => 0x1e, 187 => 0xe, 191 => 0x64d0, 312 => 0x600, 370 => 0x34, 402 => 0x1002, 412 => 0x3, 422 => 0x4, 423 => 0x7e, 424 => 0x34 },
	'drivemode2' => { 184 => 0xa, 351 => 0x7, 433 => 0xe, 440 => 0x1 },
	'drivemodesetting' => { 424 => 0x4 },
	'drivespeed' => { 125 => '0.2' },
	'dspfirmwareversion' => { 370 => 0x27 },
	'duration' => { 67 => 0x6a, 155 => 'Duration', 169 => 'Duration', 513 => 'duration', 521 => 'duration' },
	'durationscale' => { 521 => [\'duration','durationScale'] },
	'durationvalue' => { 521 => [\'duration','durationValue'] },
	'dustremovaldata' => { 64 => 0x97 },
	'dxcropalert' => { 238 => 0x23c, 239 => 0x250 },
	'dynamicafarea' => { 294 => '1.4', 303 => '1.4' },
	'dynamicafareasize' => { 238 => 0x240, 239 => 0x254 },
	'dynamicareaafassist' => { 310 => 0x18 },
	'dynamicareaafdisplay' => { 295 => '46.1', 297 => '47.1', 298 => '47.1', 307 => '47.1', 308 => '47.1' },
	'dynamicrange' => { 127 => 0x1400 },
	'dynamicrangeboost' => { 335 => 0xee },
	'dynamicrangeexpansion' => { 370 => 0x69, 402 => 0x100e },
	'dynamicrangemax' => { 108 => 0x7c },
	'dynamicrangemin' => { 108 => 0x7a },
	'dynamicrangeoptimizer' => { 184 => 0x15, 435 => [0xb025,0xb04f], 444 => 0x1144, 445 => [0x1144,0x324], 446 => [0x1120,0x300], 447 => [0x119c,0x37c], 448 => [0x1178,0x328], 449 => [0x1030,0x50], 450 => [0x228,0x50], 451 => [0x228,0x50], 452 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 433 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 422 => 0x19, 423 => 0x17, 424 => 0xd, 433 => 0x79, 440 => 0x5 },
	'dynamicrangeoptimizermode' => { 187 => 0x15, 422 => 0x18, 423 => 0x16, 433 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 184 => 0x27, 424 => 0xc, 440 => 0x4 },
	'dynamicrangesetting' => { 127 => 0x1402 },
	'e-dialinprogram' => { 351 => '1.3' },
	'earliestageorloweststage' => { 118 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 473 => 'EarthPos' },
	'earthposaltitude' => { 473 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 473 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 473 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 473 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 473 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 473 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 473 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 473 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 309 => '6.1' },
	'easyexposurecompensation' => { 294 => '6.4', 295 => '6.5', 297 => '6.3', 298 => '6.3', 302 => '5.1', 303 => '4.4', 304 => '5.2', 307 => '6.3', 308 => '6.3', 310 => 0x1d },
	'easymode' => { 34 => 0xb },
	'edgemapslope' => { 138 => 0x930 },
	'edgemapx1' => { 138 => 0x931 },
	'edgemapx2' => { 138 => 0x932 },
	'edgemapx3' => { 138 => 0x934 },
	'edgemapx4' => { 138 => 0x935 },
	'edgenoisereduction' => { 288 => 0x4, 470 => 0x8028 },
	'edit1' => { 395 => "\xa9ed1" },
	'edit2' => { 395 => "\xa9ed2" },
	'edit3' => { 395 => "\xa9ed3" },
	'edit4' => { 395 => "\xa9ed4" },
	'edit5' => { 395 => "\xa9ed5" },
	'edit6' => { 395 => "\xa9ed6" },
	'edit7' => { 395 => "\xa9ed7" },
	'edit8' => { 395 => "\xa9ed8" },
	'edit9' => { 395 => "\xa9ed9" },
	'edition' => { 511 => 'edition' },
	'editorialupdate' => { 131 => 0x8 },
	'editstatus' => { 131 => 0x7, 382 => 'EditStatus', 489 => 'EditStatus' },
	'editversionname' => { 287 => 0x3d136244 },
	'effectivelv' => { 370 => 0x2d },
	'effectivemaxaperture' => { 226 => 0x12, 227 => 0x13, 231 => 0x14 },
	'eissn' => { 511 => 'eIssn' },
	'electricalblackcolumns' => { 138 => 0x1810 },
	'electronicfront-curtainshutter' => { 297 => '5.2', 298 => '5.2', 307 => '5.3', 308 => '5.2' },
	'electronicfrontcurtainshutter' => { 435 => 0x201a },
	'elevation' => { 165 => 'Elevation' },
	'email' => { 157 => 'EMail' },
	'embargodate' => { 514 => 'embargoDate' },
	'embdencrightsexpr' => { 507 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 507 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 507 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 507 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 509 => 'EmbeddedXMPDigest' },
	'emissivity' => { 121 => 0x3 },
	'emptyslotrelease' => { 238 => 0x625, 239 => 0x655 },
	'enablechromanoisereduction' => { 138 => 0xe6e },
	'enablesharpening' => { 138 => 0x92e },
	'encodedby' => { 179 => 'WM/EncodedBy', 387 => "\xa9enc" },
	'encodedwith' => { 389 => 'Encoded_With' },
	'encoder' => { 387 => "\xa9too", 395 => "\xa9too" },
	'encoderid' => { 395 => "\xa9enc" },
	'encodingtime' => { 179 => 'WM/EncodingTime' },
	'encryptionkey' => { 409 => 0xa020 },
	'endingpage' => { 511 => 'endingPage' },
	'enduser' => { 322 => 'EndUser' },
	'enduserid' => { 322 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 322 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 238 => 0x648, 239 => 0x678 },
	'engineer' => { 521 => 'engineer' },
	'enhancedarktones' => { 280 => 0x8 },
	'enhancedenoisealreadyapplied' => { 491 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 491 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 491 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 491 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 491 => 'EnhanceDetailsVersion' },
	'enhancement' => { 112 => 0x16, 113 => 0x3016 },
	'enhanceparams' => { 119 => 0xc7ee },
	'enhancer' => { 316 => 0x300 },
	'enhancervalues' => { 316 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 491 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 491 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 491 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 132 => 0x28 },
	'envelopepriority' => { 132 => 0x3c },
	'enveloperecordversion' => { 132 => 0x0 },
	'episode' => { 507 => 'Episode' },
	'episodeglobaluniqueid' => { 387 => 'egid' },
	'episodeidentifier' => { 507 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 507 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 507 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 317 => 0x20c },
	'epsonimagewidth' => { 317 => 0x20b },
	'epsonsoftware' => { 317 => 0x20d },
	'equipmentinstitution' => { 472 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 472 => 'EquipmentManufacturer' },
	'equipmentversion' => { 313 => 0x0 },
	'ettlii' => { 84 => 0x304, 85 => 0xd, 86 => 0xe, 87 => 0x7, 88 => 0x7, 89 => 0xe },
	'event' => { 475 => 'Event', 487 => 'Event', 507 => 'Event', 511 => 'event' },
	'eventalias' => { 510 => 'eventAlias' },
	'eventdate' => { 118 => [\'Event','EventEventDate'] },
	'eventday' => { 118 => [\'Event','EventDay'] },
	'eventearliestdate' => { 118 => [\'Event','EventEarliestDate'] },
	'eventend' => { 510 => 'eventEnd' },
	'eventenddayofyear' => { 118 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 118 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 118 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 118 => [\'Event','EventHabitat'] },
	'eventid' => { 118 => [\'Event','EventEventID'], 507 => 'EventId' },
	'eventlatestdate' => { 118 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 118 => [\'Event','EventMonth'] },
	'eventnumber' => { 396 => 0x9, 397 => 0x37, 398 => 0x3a },
	'eventparenteventid' => { 118 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 118 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 118 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 118 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 118 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 118 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 510 => 'eventStart' },
	'eventstartdayofyear' => { 118 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 510 => 'eventSubtype' },
	'eventtime' => { 118 => [\'Event','EventEventTime'] },
	'eventtype' => { 510 => 'eventType' },
	'eventverbatimeventdate' => { 118 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 118 => [\'Event','EventYear'] },
	'evfgrid' => { 310 => 0x165 },
	'evfimageframe' => { 310 => 0x164 },
	'evfreleaseindicator' => { 310 => 0x24f },
	'evfwarmdisplaybrightness' => { 310 => 0x24d },
	'evfwarmdisplaymode' => { 310 => 0x24b },
	'evsteps' => { 351 => '1.2', 353 => 0x0 },
	'evstepsize' => { 299 => '5.1', 300 => '6.1', 301 => '6.1', 305 => '0.7' },
	'exclusivecoverage' => { 484 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 514 => 'exclusivityEndDate' },
	'excursiontolerance' => { 133 => 0x82 },
	'executiveproducer' => { 387 => "\xa9xpd" },
	'exif' => { 120 => 'EXIF' },
	'exifbyteorder' => { 120 => 'ExifByteOrder' },
	'exifcamerainfo' => { 131 => 0xe8 },
	'exifimageheight' => { 119 => 0xa003, 500 => 'PixelYDimension' },
	'exifimagewidth' => { 119 => 0xa002, 500 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 120 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 119 => 0x9000, 500 => 'ExifVersion' },
	'exitpupilposition' => { 226 => 0x4, 227 => 0x4, 231 => 0x4 },
	'expirationdate' => { 131 => 0x25, 514 => 'expirationDate' },
	'expirationtime' => { 131 => 0x26 },
	'exposure' => { 119 => 0xfe51, 494 => 'Exposure', 496 => 'Exposure' },
	'exposure2012' => { 494 => 'Exposure2012', 496 => 'Exposure2012' },
	'exposureadj' => { 285 => 0x0 },
	'exposureadj2' => { 285 => 0x12 },
	'exposureadjust' => { 412 => 0xc },
	'exposurebracketingindicatorlast' => { 184 => 0x52 },
	'exposurebracketshotnumber' => { 187 => 0x2d, 433 => 0x2f },
	'exposurebracketstepsize' => { 351 => 0x8 },
	'exposurebracketvalue' => { 233 => 0x19 },
	'exposurecompautocancel' => { 84 => 0x113 },
	'exposurecompensation' => { 77 => 0x6, 93 => 0x0, 119 => 0x9204, 140 => 0x24, 156 => 'ExposureComp', 176 => 'ExposureCompensation', 181 => 0xd, 182 => 0x53, 183 => 0x1e, 187 => 0x49c0, 317 => 0x1006, 370 => 0x16, 379 => 0x402, 409 => 0xa013, 412 => [0xc,0x35,0x4d], 444 => 0x114c, 445 => 0x114c, 446 => 0x1128, 448 => 0x1180, 449 => 0x1038, 450 => 0x230, 451 => 0x230, 452 => 0x223, 500 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 440 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 184 => 0x47, 187 => 0x2a },
	'exposurecompensationset' => { 422 => 0x3, 423 => 0x3, 424 => 0x3, 440 => 0x1e },
	'exposurecompensationsetting' => { 184 => 0x1 },
	'exposurecompstepsize' => { 294 => '6.3', 295 => '7.3', 297 => '7.3', 298 => '7.3', 303 => '4.3', 307 => '7.3', 308 => '7.3' },
	'exposurecontrolstep' => { 302 => '6.1', 304 => '6.1' },
	'exposurecontrolstepsize' => { 294 => '6.2', 295 => '7.1', 297 => '7.1', 298 => '7.1', 303 => '4.2', 307 => '7.1', 308 => '7.1', 309 => '7.1', 310 => 0x1b },
	'exposurecount' => { 127 => 0x1032 },
	'exposuredelaymode' => { 294 => '10.1', 295 => '11.1', 297 => '11.1', 298 => '11.1', 299 => '9.1', 300 => '10.1', 301 => '10.1', 303 => '10.4', 304 => '10.1', 305 => '6.4', 307 => '11.1', 308 => '11.1', 309 => '11.2' },
	'exposuredifference' => { 233 => 0xe },
	'exposuregaincustom' => { 138 => 0x89c },
	'exposuregaindaylight' => { 138 => 0x898 },
	'exposuregainflash' => { 138 => 0x89b },
	'exposuregainfluorescent' => { 138 => 0x89a },
	'exposuregaintungsten' => { 138 => 0x899 },
	'exposureindex' => { 119 => 0xa215, 500 => 'ExposureIndex' },
	'exposureindicator' => { 184 => 0x50 },
	'exposurelevelincrements' => { 82 => 0x6, 83 => 0x6, 84 => 0x101, 85 => 0x5, 86 => 0x6, 87 => 0x5, 88 => 0x5, 89 => 0x6, 90 => 0x4, 422 => 0x58, 423 => 0x58 },
	'exposurelockused' => { 482 => 'ExposureLockUsed' },
	'exposuremode' => { 119 => 0xa402, 156 => 'ExposureMode', 181 => 0x1, 182 => 0xa, 183 => 0x0, 184 => 0x0, 187 => 0x34, 312 => 0x200, 332 => 0x40d, 412 => 0x8, 435 => 0xb041, 500 => 'ExposureMode' },
	'exposuremodeinmanual' => { 84 => 0x10b },
	'exposureprogram' => { 119 => 0x8822, 402 => 0x1001, 415 => [0x17e,0x43], 422 => 0x3c, 423 => 0x3c, 424 => 0x5, 428 => 0x14, 433 => 0x3f, 440 => 0x2, 444 => 0x1175, 445 => 0x1179, 446 => 0x1155, 447 => 0x11d1, 448 => 0x11ad, 449 => 0x1065, 450 => 0x25d, 451 => 0x25d, 452 => 0x24c, 462 => 0xb, 463 => 0xc, 464 => 0xb, 466 => 0x48, 500 => 'ExposureProgram' },
	'exposureshift' => { 312 => 0x203 },
	'exposurestandardadjustment' => { 435 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 30 => 0x6, 31 => 0x7, 77 => 0x16, 119 => 0x829a, 137 => 0xfd05, 140 => 0x20, 142 => 0xfa24, 144 => 0xf104, 147 => 0x12, 149 => 0x38, 151 => 0x14, 152 => 0x10, 154 => 0x10, 156 => 'ExposureTime', 181 => 0x9, 182 => 0x35, 183 => 0x48, 184 => 0x8, 187 => 0x49b8, 370 => 0x12, 409 => 0xa018, 412 => [0x32,0x4a], 422 => 0x0, 423 => 0x0, 440 => [0x21,0x23,0x27], 466 => 0x10, 500 => 'ExposureTime' },
	'exposuretime2' => { 412 => [0x33,0x4b] },
	'exposuretuning' => { 233 => 0x1c },
	'exposurevalue' => { 138 => 0x3 },
	'exposurewarning' => { 127 => 0x1302 },
	'exrauto' => { 127 => 0x1033 },
	'exrmode' => { 127 => 0x1034 },
	'extdescraccessibility' => { 506 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 238 => 0x114, 239 => 0x124 },
	'extendedshutterspeeds' => { 310 => 0x102 },
	'extendedwbdetect' => { 312 => 0x902 },
	'extender' => { 313 => 0x301 },
	'extenderfirmwareversion' => { 313 => 0x304 },
	'extendermagnification' => { 158 => 'Magnification' },
	'extendermake' => { 158 => 'Make' },
	'extendermodel' => { 158 => 'Model', 313 => 0x303 },
	'extenderserialnumber' => { 158 => 'SerialNumber', 313 => 0x302 },
	'extenderstatus' => { 368 => 0x3 },
	'externalflash' => { 315 => 0x1201 },
	'externalflashae1' => { 317 => 0x101f },
	'externalflashae1_0' => { 317 => 0x101b },
	'externalflashae2' => { 317 => 0x1020 },
	'externalflashae2_0' => { 317 => 0x101c },
	'externalflashbounce' => { 315 => 0x1204, 317 => 0x1026, 358 => 0x1a },
	'externalflashcompensation' => { 213 => 0x1b },
	'externalflashexposurecomp' => { 233 => 0x17, 358 => 0x19 },
	'externalflashfirmware' => { 211 => 0x6, 212 => 0x6, 213 => 0x6, 214 => 0x6, 215 => 0x6, 216 => 0x6 },
	'externalflashflags' => { 211 => 0x8, 212 => 0x8, 213 => 0x8, 214 => 0x8, 216 => 0x8 },
	'externalflashguidenumber' => { 315 => 0x1203, 358 => '24.1' },
	'externalflashgvalue' => { 317 => 0x1025 },
	'externalflashmode' => { 317 => 0x1028, 358 => 0x2 },
	'externalflashreadystate' => { 215 => '9.1' },
	'externalflashstatus' => { 215 => '8.2' },
	'externalflashzoom' => { 315 => 0x1205, 317 => 0x1027 },
	'externalflashzoomoverride' => { 215 => '8.1' },
	'externalmetadatalink' => { 507 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 330 => 0x311, 333 => 0x311, 334 => 0x311, 337 => 0x3408 },
	'extrainfoversion' => { 426 => 0x1a },
	'eyestartaf' => { 184 => 0x40 },
	'fac100per' => { 138 => 0xe94 },
	'fac170per' => { 138 => 0xe93 },
	'fac18per' => { 138 => 0xe92 },
	'face10position' => { 110 => 0x3f4, 111 => 0x1ec, 209 => 0x28, 355 => 0x12 },
	'face10size' => { 356 => 0x12 },
	'face11position' => { 209 => 0x2c, 355 => 0x14 },
	'face11size' => { 356 => 0x14 },
	'face12position' => { 209 => 0x30, 355 => 0x16 },
	'face12size' => { 356 => 0x16 },
	'face13position' => { 355 => 0x18 },
	'face13size' => { 356 => 0x18 },
	'face14position' => { 355 => 0x1a },
	'face14size' => { 356 => 0x1a },
	'face15position' => { 355 => 0x1c },
	'face15size' => { 356 => 0x1c },
	'face16position' => { 355 => 0x1e },
	'face16size' => { 356 => 0x1e },
	'face17position' => { 355 => 0x20 },
	'face17size' => { 356 => 0x20 },
	'face18position' => { 355 => 0x22 },
	'face18size' => { 356 => 0x22 },
	'face19position' => { 355 => 0x24 },
	'face19size' => { 356 => 0x24 },
	'face1position' => { 54 => 0x8, 110 => 0xd, 111 => 0x18, 209 => 0x4, 327 => 0x1, 355 => 0x0, 399 => 0xbc, 429 => 0x1, 430 => 0x0, 431 => 0x0, 432 => 0x5b },
	'face1size' => { 356 => 0x0 },
	'face20position' => { 355 => 0x26 },
	'face20size' => { 356 => 0x26 },
	'face21position' => { 355 => 0x28 },
	'face21size' => { 356 => 0x28 },
	'face22position' => { 355 => 0x2a },
	'face22size' => { 356 => 0x2a },
	'face23position' => { 355 => 0x2c },
	'face23size' => { 356 => 0x2c },
	'face24position' => { 355 => 0x2e },
	'face24size' => { 356 => 0x2e },
	'face25position' => { 355 => 0x30 },
	'face25size' => { 356 => 0x30 },
	'face26position' => { 355 => 0x32 },
	'face26size' => { 356 => 0x32 },
	'face27position' => { 355 => 0x34 },
	'face27size' => { 356 => 0x34 },
	'face28position' => { 355 => 0x36 },
	'face28size' => { 356 => 0x36 },
	'face29position' => { 355 => 0x38 },
	'face29size' => { 356 => 0x38 },
	'face2position' => { 54 => 0xa, 110 => 0x7c, 111 => 0x4c, 209 => 0x8, 327 => 0x5, 355 => 0x2, 399 => 0xc8, 429 => 0x6, 430 => 0x20, 431 => 0x25, 432 => 0x65 },
	'face2size' => { 356 => 0x2 },
	'face30position' => { 355 => 0x3a },
	'face30size' => { 356 => 0x3a },
	'face31position' => { 355 => 0x3c },
	'face31size' => { 356 => 0x3c },
	'face32position' => { 355 => 0x3e },
	'face32size' => { 356 => 0x3e },
	'face3position' => { 54 => 0xc, 110 => 0xeb, 111 => 0x80, 209 => 0xc, 327 => 0x9, 355 => 0x4, 399 => 0xd4, 429 => 0xb, 430 => 0x40, 431 => 0x4a, 432 => 0x6f },
	'face3size' => { 356 => 0x4 },
	'face4position' => { 54 => 0xe, 110 => 0x15a, 111 => 0xb4, 209 => 0x10, 327 => 0xd, 355 => 0x6, 399 => 0xe0, 429 => 0x10, 430 => 0x60, 431 => 0x6f, 432 => 0x79 },
	'face4size' => { 356 => 0x6 },
	'face5position' => { 54 => 0x10, 110 => 0x1c9, 111 => 0xe8, 209 => 0x14, 327 => 0x11, 355 => 0x8, 399 => 0xec, 429 => 0x15, 430 => 0x80, 431 => 0x94 },
	'face5size' => { 356 => 0x8 },
	'face6position' => { 54 => 0x12, 110 => 0x238, 111 => 0x11c, 209 => 0x18, 355 => 0xa, 399 => 0xf8, 429 => 0x1a, 430 => 0xa0, 431 => 0xb9 },
	'face6size' => { 356 => 0xa },
	'face7position' => { 54 => 0x14, 110 => 0x2a7, 111 => 0x150, 209 => 0x1c, 355 => 0xc, 399 => 0x104, 429 => 0x1f, 430 => 0xc0, 431 => 0xde },
	'face7size' => { 356 => 0xc },
	'face8position' => { 54 => 0x16, 110 => 0x316, 111 => 0x184, 209 => 0x20, 355 => 0xe, 399 => 0x110, 429 => 0x24, 430 => 0xe0, 431 => 0x103 },
	'face8size' => { 356 => 0xe },
	'face9position' => { 54 => 0x18, 110 => 0x385, 111 => 0x1b8, 209 => 0x24, 355 => 0x10 },
	'face9size' => { 356 => 0x10 },
	'facebalanceorigi' => { 488 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 488 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 488 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 488 => 'FaceBalanceWarmth' },
	'facedetect' => { 370 => 0x76, 409 => 0x100 },
	'facedetectarea' => { 316 => 0x1201 },
	'facedetectframecrop' => { 316 => 0x1207 },
	'facedetectframesize' => { 54 => 0x3, 110 => 0x1, 111 => 0x4, 209 => 0x1, 316 => 0x1203, 370 => 0x77, 399 => 0xb6 },
	'facedetection' => { 424 => 0x30, 440 => 0x19 },
	'faceelementpositions' => { 127 => 0x4203 },
	'faceelementselected' => { 127 => 0x4005 },
	'faceelementtypes' => { 127 => 0x4201 },
	'faceid' => { 490 => 'FaceID' },
	'faceinfounknown' => { 113 => 0x2089 },
	'facename' => { 409 => 0x123 },
	'faceorientation' => { 111 => 0x8 },
	'faceposition' => { 354 => 0x2, 410 => 0x4 },
	'facepositions' => { 127 => 0x4103 },
	'facerecognition' => { 409 => 0x120 },
	'facesdetected' => { 54 => 0x2, 55 => 0x2, 56 => 0x3, 110 => 0x0, 111 => 0x2, 113 => 0x211c, 127 => 0x4100, 209 => 0x3, 316 => 0x1200, 335 => 0x3f, 354 => 0x0, 399 => 0xb5, 410 => 0x0, 429 => 0x0, 432 => 0x3, 443 => 0x30 },
	'facesrecognized' => { 328 => 0x0 },
	'facewidth' => { 55 => 0x1 },
	'fade' => { 435 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 109 => 0x38 },
	'faithfuloutputshadowpoint' => { 109 => 0x39 },
	'faithfulrawcolortone' => { 109 => 0x31 },
	'faithfulrawcontrast' => { 109 => 0x33 },
	'faithfulrawhighlight' => { 109 => 0x79 },
	'faithfulrawhighlightpoint' => { 109 => 0x36 },
	'faithfulrawlinear' => { 109 => 0x34 },
	'faithfulrawsaturation' => { 109 => 0x32 },
	'faithfulrawshadow' => { 109 => 0x82 },
	'faithfulrawshadowpoint' => { 109 => 0x37 },
	'faithfulrawsharpness' => { 109 => 0x35 },
	'faithfulunsharpmaskfineness' => { 109 => 0xac },
	'faithfulunsharpmaskstrength' => { 109 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 109 => 0xae },
	'far' => { 479 => 'Far' },
	'fastresetlinetime' => { 138 => 0x1860 },
	'feedidentifier' => { 507 => 'FeedIdentifier' },
	'femicroadjustment' => { 84 => 0x111 },
	'ffid' => { 498 => 'ffid' },
	'field' => { 510 => 'field' },
	'fieldcount' => { 317 => 0x103f },
	'fieldofview' => { 395 => "FOV\x00" },
	'fifoenonepixeldelay' => { 138 => 0x1901 },
	'filecreatedate' => { 120 => 'FileCreateDate' },
	'filedatarate' => { 521 => 'fileDataRate' },
	'fileformat' => { 95 => 0x0, 132 => 0x14, 412 => [0x22,0x26], 435 => 0xb000 },
	'filegroupid' => { 120 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 336 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 120 => 'FileModifyDate' },
	'filename' => { 120 => 'FileName' },
	'filenameasdelivered' => { 322 => 'FileNameAsDelivered' },
	'filenumber' => { 57 => 0x1, 64 => 0x8, 97 => 0x1817, 114 => 'Canon-FileNumber', 210 => 0x4, 398 => 0x10 },
	'filenumbermemory' => { 181 => 0x1a },
	'filenumbersequence' => { 294 => '12.2', 299 => '3.1', 300 => '4.1', 301 => '4.1', 303 => '11.1', 304 => '4.3', 309 => '5.2', 310 => 0x48 },
	'filepermissions' => { 120 => 'FilePermissions' },
	'filesource' => { 119 => 0xa300, 127 => 0x8000, 500 => 'FileSource' },
	'fileuserid' => { 120 => 'FileUserID' },
	'fileversion' => { 132 => 0x16 },
	'fillflashautoreduction' => { 82 => 0xe, 83 => 0xe, 90 => 0xa },
	'filllight' => { 494 => 'FillLight', 496 => 'FillLight' },
	'fillorder' => { 119 => 0x10a },
	'filmgraineffect' => { 312 => 0x538 },
	'filmmode' => { 127 => 0x1401, 332 => 0x412, 335 => 0x42 },
	'filmtype' => { 254 => 0x2 },
	'filtereffect' => { 57 => 0xe, 246 => 0x37, 247 => 0x3f, 248 => 0x47, 335 => 0xa1 },
	'filtereffectauto' => { 71 => 0xa0 },
	'filtereffectfaithful' => { 70 => 0x70, 71 => 0x70 },
	'filtereffectlandscape' => { 70 => 0x40, 71 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 70 => 0x88, 71 => 0x88 },
	'filtereffectneutral' => { 70 => 0x58, 71 => 0x58 },
	'filtereffectportrait' => { 70 => 0x28, 71 => 0x28 },
	'filtereffectstandard' => { 70 => 0x10, 71 => 0x10 },
	'filtereffectuserdef1' => { 70 => 0xa0, 71 => 0xb8 },
	'filtereffectuserdef2' => { 70 => 0xb8, 71 => 0xd0 },
	'filtereffectuserdef3' => { 70 => 0xd0, 71 => 0xe8 },
	'finderdisplayduringexposure' => { 83 => 0x1 },
	'finesharpness' => { 370 => 0x70 },
	'finetuneoptcenterweighted' => { 294 => '7.2', 295 => '9.1', 297 => '9.1', 298 => '9.1', 302 => '8.1', 307 => '9.1', 308 => '9.1', 309 => '9.1', 310 => 0x23 },
	'finetuneopthighlightweighted' => { 297 => '46.1', 298 => '46.1', 307 => '46.1', 308 => '46.1', 310 => 0x27 },
	'finetuneoptmatrixmetering' => { 294 => '8.1', 295 => '8.2', 297 => '8.2', 298 => '8.2', 302 => '7.2', 303 => '6.1', 307 => '8.2', 308 => '8.2', 309 => '8.2', 310 => 0x21 },
	'finetuneoptspotmetering' => { 294 => '8.2', 295 => '9.2', 297 => '9.2', 298 => '9.2', 302 => '8.2', 303 => '6.2', 307 => '9.2', 308 => '9.2', 309 => '9.2', 310 => 0x25 },
	'finishexposure' => { 138 => 0xdbd },
	'finishfiletype' => { 138 => 0xdb8 },
	'finishlook' => { 138 => 0xdbc },
	'finishnoise' => { 138 => 0xdba },
	'finishresolution' => { 138 => 0xdb9 },
	'finishsharpening' => { 138 => 0xdbb },
	'firmware' => { 317 => 0x405, 412 => [0x8c,0x17,0x3b], 491 => 'Firmware' },
	'firmware2' => { 412 => 0x57 },
	'firmwaredate' => { 112 => 0x15, 113 => 0x2001, 396 => 0x4, 398 => 0x30 },
	'firmwareid' => { 188 => 0x0 },
	'firmwarename' => { 409 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 64 => 0x1e, 400 => 0x0 },
	'firmwarerevision2' => { 400 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 138 => [0x415,0xce5], 154 => 0x57, 156 => 'FirmwareVersion', 333 => 0x320, 335 => 0x2, 337 => 0x3109, 370 => 0x230, 395 => ['CNFV','FIRM'], 397 => 0x18, 398 => 0x2a, 402 => 0x2 },
	'firmwareversions' => { 379 => 0x301 },
	'firstphotodate' => { 482 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 322 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 131 => 0x16, 489 => 'FixtureIdentifier' },
	'flash' => { 114 => 'XMP-Flash', 119 => 0x9209, 152 => 0x22, 182 => 0x1f, 183 => 0x15, 398 => 0x5a, 500 => 'Flash' },
	'flashaction' => { 422 => 0x3e, 423 => 0x3e, 435 => 0x2017, 440 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 422 => 0x4c, 423 => 0x4c, 440 => 0x77 },
	'flashactionexternal' => { 440 => [0x78,0x7c] },
	'flashactivity' => { 34 => 0x1c },
	'flashbatterylevel' => { 44 => 0x249 },
	'flashbias' => { 335 => 0x24 },
	'flashbits' => { 34 => 0x1d },
	'flashburstpriority' => { 310 => 0x111 },
	'flashbuttonfunction' => { 84 => 0x70e },
	'flashchargelevel' => { 317 => 0x1010 },
	'flashcolorfilter' => { 213 => 0x10, 214 => 0x10, 216 => 0x10 },
	'flashcommandermode' => { 211 => '9.1', 212 => '9.1', 213 => '9.1', 214 => '9.1', 216 => '9.1' },
	'flashcompensation' => { 138 => 0x3f3, 211 => 0xa, 212 => 0xa, 213 => 0xa, 214 => 0x27, 215 => 0xa, 216 => 0xa, 491 => 'FlashCompensation' },
	'flashcontrol' => { 422 => 0x23, 423 => 0x1f, 424 => 0x21 },
	'flashcontrolbuilt-in' => { 303 => '16.1', 304 => '23.1', 306 => '23.1', 307 => '24.1' },
	'flashcontrolmode' => { 211 => '9.2', 212 => '9.2', 213 => '9.2', 214 => '9.2', 216 => '9.2', 222 => 0x214, 237 => 0x148, 238 => 0x1a8, 239 => 0x1bc, 312 => 0x404 },
	'flashcurtain' => { 335 => 0x48 },
	'flashdefault' => { 184 => 0x42 },
	'flashdevice' => { 317 => 0x1005 },
	'flashdistance' => { 113 => 0x2034 },
	'flashenergy' => { 119 => 0xa20b, 500 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 233 => 0x18 },
	'flashexposurecomp' => { 77 => 0xf, 127 => 0x1011, 159 => 'ExposureComp', 181 => 0x23, 186 => 0x104, 187 => 0x49c1, 233 => 0x12, 312 => 0x401, 317 => 0x1023, 370 => 0x4d, 402 => 0x100b, 412 => [0x3a,0x56], 435 => 0x104 },
	'flashexposurecomp2' => { 275 => 0x4d2 },
	'flashexposurecomp3' => { 213 => 0x1d },
	'flashexposurecomp4' => { 213 => 0x27 },
	'flashexposurecomparea' => { 295 => '38.4', 297 => '38.4', 298 => '38.4', 307 => '38.4', 308 => '38.4', 310 => 0x59 },
	'flashexposurecompset' => { 184 => 0x10, 343 => 0xe, 422 => 0x14, 423 => 0x12, 424 => 0x23, 440 => 0x1f },
	'flashexposurecompset2' => { 440 => [0x26,0x2c] },
	'flashexposureindicator' => { 184 => 0x54 },
	'flashexposureindicatorlast' => { 184 => 0x56 },
	'flashexposureindicatornext' => { 184 => 0x55 },
	'flashexposurelock' => { 57 => 0x19 },
	'flashfired' => { 140 => 0x5d, 159 => 'Fired', 181 => 0x14, 274 => '590.3', 500 => [\'Flash','FlashFired'] },
	'flashfiring' => { 84 => 0x306, 85 => 0x6, 86 => 0x7, 89 => 0x7 },
	'flashfirmwareversion' => { 313 => 0x1002 },
	'flashfocallength' => { 211 => 0xb, 212 => 0xc, 213 => 0xc, 214 => 0xc, 215 => 0xc, 216 => 0x26 },
	'flashfunction' => { 187 => 0x31, 500 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 211 => 0xe, 212 => 0xf, 213 => 0xf, 214 => 0xf, 215 => 0xf, 216 => 0xf, 222 => 0x21a, 237 => 0x14e, 238 => 0x1ae, 239 => 0x1c2 },
	'flashgroupacompensation' => { 211 => 0x11, 212 => 0x12, 213 => 0x13, 214 => 0x28, 215 => 0x28, 216 => 0x28 },
	'flashgroupacontrolmode' => { 211 => 0xf, 212 => '16.1', 213 => '17.1', 214 => '17.1', 215 => '17.1', 216 => '17.1' },
	'flashgroupaoutput' => { 211 => 0x11, 212 => 0x12, 213 => 0x13, 214 => 0x28, 215 => 0x28, 216 => 0x28 },
	'flashgroupbcompensation' => { 211 => 0x12, 212 => 0x13, 213 => 0x14, 214 => 0x29, 215 => 0x29, 216 => 0x29 },
	'flashgroupbcontrolmode' => { 211 => 0x10, 212 => '17.1', 213 => '18.1', 214 => '18.1', 215 => '18.1', 216 => '18.1' },
	'flashgroupboutput' => { 211 => 0x12, 212 => 0x13, 213 => 0x14, 214 => 0x29, 215 => 0x29, 216 => 0x29 },
	'flashgroupccompensation' => { 212 => 0x14, 213 => 0x15, 214 => 0x2a, 215 => 0x2a, 216 => 0x2a },
	'flashgroupccontrolmode' => { 212 => '17.2', 213 => '18.2', 214 => '18.2', 215 => '18.2', 216 => '18.2' },
	'flashgroupcoutput' => { 212 => 0x14, 213 => 0x15, 214 => 0x2a, 215 => 0x2a, 216 => 0x2a },
	'flashguidenumber' => { 77 => 0xd, 94 => 0x0, 159 => 'GuideNumber' },
	'flashilluminationpattern' => { 216 => 0x25 },
	'flashintensity' => { 112 => [0x19,0x5], 312 => 0x405 },
	'flashlevel' => { 296 => 0x9, 435 => 0xb048 },
	'flashmake' => { 159 => 'Make' },
	'flashmanufacturer' => { 178 => 'FlashManufacturer' },
	'flashmastercompensation' => { 222 => 0x22e, 237 => 0x162, 238 => 0x1aa, 239 => 0x1be },
	'flashmastercontrolmode' => { 222 => 0x22c, 237 => 0x160 },
	'flashmasteroutput' => { 222 => 0x232, 237 => 0x166 },
	'flashmetering' => { 181 => 0x3f, 184 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 370 => 0x20a },
	'flashmode' => { 112 => 0x4, 138 => 0x3f2, 140 => 0x5c, 151 => 0x27, 159 => 'Mode', 181 => 0x2, 182 => 0x20, 183 => 0x16, 184 => 0xf, 233 => 0x87, 312 => 0x400, 317 => 0x1004, 370 => 0xc, 377 => 0x4, 401 => 0x20, 402 => 0x100a, 411 => 0x225, 422 => 0x13, 423 => 0x7f, 424 => 0x20, 440 => 0x10, 444 => 0x1138, 445 => 0x1138, 446 => 0x1114, 447 => 0x1190, 448 => 0x116c, 449 => 0x1024, 450 => 0x21c, 451 => 0x21c, 452 => 0x211, 500 => [\'Flash','FlashMode'] },
	'flashmodel' => { 159 => 'Model', 178 => 'FlashModel', 313 => 0x1001 },
	'flashoptions' => { 351 => 0x2 },
	'flashoptions2' => { 351 => 0x10 },
	'flashoutput' => { 44 => 0x248, 77 => 0x21, 211 => 0xa, 212 => 0xa, 213 => 0xa, 214 => 0x27, 216 => 0x21, 222 => 0x21e, 237 => 0x152, 238 => 0x1b2, 239 => 0x1c6 },
	'flashpixversion' => { 119 => 0xa000, 500 => 'FlashpixVersion' },
	'flashredeyemode' => { 500 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 222 => 0x228, 237 => 0x15c, 238 => 0x1bc, 312 => 0x403 },
	'flashreturn' => { 500 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 159 => 'SerialNumber', 313 => 0x1003 },
	'flashsetting' => { 233 => 0x8 },
	'flashshutterspeed' => { 294 => '20.2', 295 => '23.2', 297 => '23.2', 298 => '23.2', 303 => '15.2', 304 => '22.2', 305 => '7.2', 306 => '22.2', 307 => '23.2', 308 => '23.2', 309 => '23.1', 310 => 0x57 },
	'flashsource' => { 211 => 0x4, 212 => 0x4, 213 => 0x4, 214 => 0x4, 215 => 0x4, 216 => 0x4 },
	'flashstatus' => { 358 => 0x0, 440 => [0x82,0x86], 454 => 0x31, 455 => 0x39, 456 => 0x39 },
	'flashstatusbuilt-in' => { 424 => [0x87,0x287] },
	'flashstatusexternal' => { 424 => [0x88,0x288] },
	'flashsyncspeed' => { 294 => '20.1', 295 => '23.1', 297 => '23.1', 298 => '23.1', 303 => '15.1', 304 => '22.1', 306 => '22.1', 307 => '23.1', 308 => '23.1', 310 => 0x53 },
	'flashsyncspeedav' => { 82 => 0x3, 84 => 0x10f, 85 => 0x2, 86 => 0x3, 87 => 0x2, 88 => 0x2, 89 => 0x3, 90 => 0x6 },
	'flashthreshold' => { 94 => 0x1 },
	'flashtype' => { 159 => 'Type', 184 => 0x59, 233 => 0x9, 313 => 0x1000 },
	'flashwarning' => { 304 => '30.1', 305 => '7.1', 309 => '31.1', 335 => 0x62 },
	'flashwirelessoption' => { 222 => 0x234, 237 => 0x15a, 238 => 0x1c8 },
	'flexiblespotposition' => { 435 => 0x201d },
	'flickadvancedirection' => { 310 => 0x25f },
	'flickerreduce' => { 411 => 0x218 },
	'flickerreduction' => { 127 => 0x1446, 258 => 0x7 },
	'flickerreductionindicator' => { 253 => 0x532 },
	'flickerreductionshooting' => { 238 => 0x1a4, 239 => 0x1b8 },
	'flightpitchdegree' => { 116 => 'FlightPitchDegree' },
	'flightrolldegree' => { 116 => 'FlightRollDegree' },
	'flightxspeed' => { 116 => 'FlightXSpeed' },
	'flightyawdegree' => { 116 => 'FlightYawDegree' },
	'flightyspeed' => { 116 => 'FlightYSpeed' },
	'flightzspeed' => { 116 => 'FlightZSpeed' },
	'fliphorizontal' => { 287 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 30 => 0x5, 31 => 0x6, 77 => 0x15, 119 => 0x829d, 137 => 0xfd04, 140 => 0x1e, 142 => 0xfa23, 144 => 0xf103, 147 => 0x13, 149 => 0x3c, 151 => 0x1c, 152 => 0x18, 154 => 0xc, 163 => 'FNumber', 181 => 0xa, 182 => 0x36, 183 => 0x47, 184 => 0x9, 187 => 0x49c7, 231 => 0x38, 334 => 0x35a, 370 => 0x13, 409 => 0xa019, 412 => [0x31,0x49], 422 => 0x1, 423 => 0x1, 440 => [0x20,0x22,0x26], 500 => 'FNumber' },
	'focaldistance' => { 480 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 59 => 0x1, 113 => 0x1d, 119 => 0x920a, 147 => 0x1d, 163 => 'FocalLength', 181 => 0x12, 226 => 0xa, 227 => 0xb, 231 => [0xc,0x3c], 329 => 0x1, 370 => 0x1d, 379 => 0x403, 402 => 0x1500, 421 => 0xe, 448 => 0x1278, 449 => 0x1134, 450 => 0x32c, 451 => 0x32c, 452 => 0x30a, 500 => 'FocalLength' },
	'focallength2' => { 440 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 119 => 0xa405, 409 => 0xa01a, 500 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 421 => 0x10 },
	'focalplaneafpointarea' => { 453 => 0x2 },
	'focalplaneafpointlocation1' => { 453 => 0x6 },
	'focalplaneafpointlocation10' => { 453 => 0x2a },
	'focalplaneafpointlocation11' => { 453 => 0x2e },
	'focalplaneafpointlocation12' => { 453 => 0x32 },
	'focalplaneafpointlocation13' => { 453 => 0x36 },
	'focalplaneafpointlocation14' => { 453 => 0x3a },
	'focalplaneafpointlocation15' => { 453 => 0x3e },
	'focalplaneafpointlocation2' => { 453 => 0xa },
	'focalplaneafpointlocation3' => { 453 => 0xe },
	'focalplaneafpointlocation4' => { 453 => 0x12 },
	'focalplaneafpointlocation5' => { 453 => 0x16 },
	'focalplaneafpointlocation6' => { 453 => 0x1a },
	'focalplaneafpointlocation7' => { 453 => 0x1e },
	'focalplaneafpointlocation8' => { 453 => 0x22 },
	'focalplaneafpointlocation9' => { 453 => 0x26 },
	'focalplaneafpointsused' => { 453 => 0x1 },
	'focalplanediagonal' => { 313 => 0x103, 317 => 0x205 },
	'focalplaneresolutionunit' => { 119 => 0xa210, 500 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 119 => 0xa20e, 500 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 59 => 0x2 },
	'focalplanexunknown' => { 59 => 0x2 },
	'focalplaneyresolution' => { 119 => 0xa20f, 500 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 59 => 0x3 },
	'focalplaneyunknown' => { 59 => 0x3 },
	'focalpointx' => { 480 => 'FocalPointX' },
	'focalpointy' => { 480 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 59 => 0x0 },
	'focalunits' => { 34 => 0x19 },
	'focus' => { 277 => 0x8 },
	'focusarea' => { 181 => 0x31 },
	'focusareaselection' => { 305 => '15.2' },
	'focusbracket' => { 335 => 0xbd },
	'focusbracketstepsize' => { 312 => 0x308 },
	'focuscontinuous' => { 34 => 0x20 },
	'focusdisplayaiservoandmf' => { 84 => 0x515 },
	'focusdistance' => { 163 => 'FocusDistance', 181 => 0x13, 187 => 0x49bb, 226 => 0x9, 227 => 0xa, 231 => [0xb,0x4e], 315 => 0x305, 329 => 0x0, 333 => 0x304, 334 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 57 => 0x15, 77 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 231 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 57 => 0x14, 77 => 0x13 },
	'focusholdbutton' => { 184 => 0x44 },
	'focusinfoversion' => { 315 => 0x0 },
	'focusingscreen' => { 83 => 0x0, 84 => 0x80b, 89 => 0x0 },
	'focuslocation' => { 435 => 0x2027 },
	'focuslocked' => { 180 => 0x14 },
	'focusmode' => { 34 => 0x7, 112 => 0x3, 113 => [0x3003,0xd], 127 => 0x1021, 138 => 0x3f5, 140 => 0x38, 156 => 'FocusMode', 181 => 0x30, 183 => 0xe, 184 => 0xc, 233 => 0x7, 312 => 0x301, 317 => 0x100b, 335 => 0x7, 370 => 0xd, 377 => 0x3, 402 => 0x1006, 415 => [0xb,0x5], 421 => [0x15,0x1d], 422 => 0x4d, 423 => 0x4d, 435 => [0xb042,0xb04e,0x201b], 440 => 0x13, 460 => 0x16 },
	'focusmode2' => { 126 => '0.1', 351 => '3.1', 440 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 296 => '10.1', 419 => 0x14, 420 => 0x15, 422 => 0x10, 423 => 0xf, 424 => 0x6 },
	'focusmodeswitch' => { 184 => 0x58, 422 => 0x2e },
	'focuspeakingdisplay' => { 310 => 0x235 },
	'focuspeakinghighlightcolor' => { 310 => 0x4b },
	'focuspeakinglevel' => { 310 => 0x49 },
	'focuspixel' => { 127 => 0x1023 },
	'focuspointlock' => { 310 => 0x1d3 },
	'focuspointpersistence' => { 310 => 0x105 },
	'focuspointwrap' => { 294 => '2.2', 295 => '2.2', 297 => '2.1', 298 => '2.1', 302 => '1.1', 303 => '2.2', 304 => '1.1', 307 => '2.2', 308 => '2.1', 309 => '2.5', 310 => 0x16 },
	'focusposition' => { 1 => 0x2f, 226 => 0x8, 227 => 0x8, 370 => 0x10, 433 => 0x9bb },
	'focusposition2' => { 440 => [0x29,0x2b,0x2f], 460 => 0x2d, 463 => 0x20 },
	'focuspositionhorizontal' => { 193 => 0x2f, 194 => 0x43 },
	'focuspositionvertical' => { 193 => 0x31, 194 => 0x45 },
	'focusprocess' => { 312 => 0x302 },
	'focusrange' => { 34 => 0x12, 317 => 0x100a },
	'focusrangeindex' => { 361 => '3.1' },
	'focusresult' => { 194 => 0x4a },
	'focusringrotation' => { 84 => 0x713 },
	'focussetting' => { 412 => 0x6 },
	'focusshiftautoreset' => { 239 => 0x6da },
	'focusshiftexposurelock' => { 222 => 0x1b4, 237 => 0xe8, 238 => 0xf4, 239 => 0x104 },
	'focusshiftinterval' => { 222 => 0x1b0, 237 => 0xe4, 238 => 0xf0, 239 => 0x100 },
	'focusshiftnumbershots' => { 222 => 0x1a8, 237 => 0xdc, 238 => 0xe8, 239 => 0xf8 },
	'focusshiftshooting' => { 256 => 0x20 },
	'focusshiftstepwidth' => { 222 => 0x1ac, 237 => 0xe0, 238 => 0xec, 239 => 0xfc },
	'focusstatus' => { 421 => 0x19, 422 => 0x53, 423 => 0x53 },
	'focusstepcount' => { 315 => 0x301, 317 => 0x100e },
	'focusstepinfinity' => { 315 => 0x303, 317 => 0x103b },
	'focusstepnear' => { 315 => 0x304, 317 => 0x103c },
	'focustrackinglockon' => { 294 => ['1.5','4.1'], 295 => '1.4', 302 => '0.4', 303 => '3.1', 304 => '0.4', 307 => '1.4' },
	'focuswarning' => { 127 => 0x1301 },
	'foldername' => { 181 => 0x27 },
	'foldernumber' => { 422 => 0x9a, 424 => [0x402,0x114,0x316] },
	'fontcomposite' => { 526 => [\'Fonts','FontsComposite'] },
	'fontface' => { 526 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 526 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 526 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 526 => [\'Fonts','FontsFontName'] },
	'fonts' => { 526 => 'Fonts' },
	'fonttype' => { 526 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 526 => [\'Fonts','FontsVersionString'] },
	'for' => { 386 => 'For' },
	'forcewrite' => { 120 => 'ForceWrite' },
	'format' => { 395 => "\xa9fmt", 479 => 'Format', 497 => 'format', 519 => 'Format' },
	'forwardlock' => { 516 => 'forwardlock' },
	'forwardmatrix1' => { 119 => 0xc714 },
	'forwardmatrix2' => { 119 => 0xc715 },
	'forwardmatrix3' => { 119 => 0xcd34 },
	'fossilspecimen' => { 118 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 118 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 67 => [0x2,0x4] },
	'frameheight' => { 127 => 0x3822 },
	'framenum' => { 381 => 0xd7 },
	'framenumber' => { 127 => 0x8003, 187 => 0x3c, 370 => 0x29 },
	'framerate' => { 67 => [0x1,0x6], 119 => 0xc764, 127 => 0x3820 },
	'framereadouttime' => { 389 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 127 => 0x3821 },
	'framing' => { 510 => 'framing' },
	'freebytes' => { 97 => 0x1 },
	'freememorycardimages' => { 182 => [0x37,0x54], 183 => [0x2d,0x4a], 184 => 0x32 },
	'frontfacingcamera' => { 1 => 0x45 },
	'fujiflashmode' => { 127 => 0x1010 },
	'fujimodel' => { 127 => 0x1447 },
	'fujimodel2' => { 127 => 0x1448 },
	'fullhdhighspeedrec' => { 127 => 0x3824 },
	'fullimagesize' => { 435 => 0xb02b },
	'fullpanoheightpixels' => { 482 => 'FullPanoHeightPixels', 483 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 482 => 'FullPanoWidthPixels', 483 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 402 => 0x100d },
	'fullsizeimage' => { 162 => 'data' },
	'fullsizeimagename' => { 162 => '1Name' },
	'fullsizeimagetype' => { 162 => '0Type' },
	'func1button' => { 297 => '14.1', 298 => '14.1', 308 => '14.1', 310 => 0x63 },
	'func1buttonplaybackmode' => { 310 => 0x1a5 },
	'func1buttonplusdials' => { 297 => '42.1', 298 => '42.1', 308 => '42.1' },
	'func2button' => { 297 => '80.1', 298 => '80.1', 308 => '80.1', 310 => 0x73 },
	'func2buttonplaybackmode' => { 310 => 0x1a7 },
	'func2buttonplusdials' => { 297 => '81.1' },
	'func3button' => { 297 => '83.1', 310 => 0x119 },
	'func3buttonplaybackmode' => { 310 => 0x1a9 },
	'func4button' => { 310 => 0x175 },
	'func4buttonplaybackmode' => { 310 => 0x1af },
	'funcbutton' => { 294 => ['14.1','15.1'], 295 => '14.1', 303 => '28.1', 304 => '13.1', 307 => '14.1', 309 => '14.1' },
	'funcbuttonplusdials' => { 294 => ['14.2','15.2'], 295 => '14.2', 303 => '31.1', 307 => '42.1' },
	'functionbutton' => { 301 => '13.1', 305 => '5.2' },
	'gainbase' => { 316 => 0x610 },
	'gaincontrol' => { 119 => 0xa407, 500 => 'GainControl' },
	'gamma' => { 119 => 0xa500, 138 => 0x8fe, 323 => 'gAMA', 340 => 0x11c, 501 => 'Gamma' },
	'gammablackpoint' => { 105 => 0xc },
	'gammacolortone' => { 105 => 0x3 },
	'gammacompensatedvalue' => { 133 => 0x91 },
	'gammacontrast' => { 105 => 0x2 },
	'gammacurveoutputrange' => { 105 => 0xf },
	'gammahighlight' => { 105 => 0xa },
	'gammalinear' => { 103 => 0x20200 },
	'gammamidpoint' => { 105 => 0xe },
	'gammasaturation' => { 105 => 0x4 },
	'gammashadow' => { 105 => 0x9 },
	'gammasharpnessstrength' => { 105 => 0x8 },
	'gammaunsharpmaskfineness' => { 105 => 0x6 },
	'gammaunsharpmaskstrength' => { 105 => 0x5 },
	'gammaunsharpmaskthreshold' => { 105 => 0x7 },
	'gammawhitepoint' => { 105 => 0xd },
	'garminsettings' => { 395 => 'pmcc' },
	'garminsoftware' => { 395 => 'uuid' },
	'gdalmetadata' => { 119 => 0xa480 },
	'gdalnodata' => { 119 => 0xa481 },
	'geimagesize' => { 127 => 0x1304 },
	'gemake' => { 129 => 0x300 },
	'gemodel' => { 129 => 0x207 },
	'genre' => { 387 => ['gnre',"\xa9gen"], 389 => 'genre', 395 => ['gnre',"\xa9gen"], 507 => 'Genre', 511 => 'genre', 521 => 'genre' },
	'genrecvid' => { 507 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 507 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 507 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 507 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 387 => 'geID' },
	'geography' => { 512 => 'geography' },
	'geologicalcontext' => { 118 => 'GeologicalContext' },
	'geologicalcontextbed' => { 118 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 118 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 118 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 118 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 118 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 120 => 'Geosync' },
	'geotag' => { 120 => 'Geotag' },
	'geotiffasciiparams' => { 119 => 0x87b1 },
	'geotiffdirectory' => { 119 => 0x87af },
	'geotiffdoubleparams' => { 119 => 0x87b0 },
	'geotime' => { 120 => 'Geotime' },
	'giftftppriority' => { 484 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 116 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 116 => 'GimbalReverse' },
	'gimbalrolldegree' => { 116 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 116 => 'GimbalYawDegree' },
	'globalaltitude' => { 384 => 0x419 },
	'globalangle' => { 384 => 0x40d },
	'good' => { 521 => 'good' },
	'googlehostheader' => { 387 => 'gshh' },
	'googlepingmessage' => { 387 => 'gspm' },
	'googlepingurl' => { 387 => 'gspu' },
	'googleplusuploadcode' => { 119 => 0x9009 },
	'googlesourcedata' => { 387 => 'gssd' },
	'googlestarttime' => { 387 => 'gsst' },
	'googletrackduration' => { 387 => 'gstd' },
	'goprotype' => { 395 => 'GoPr' },
	'gpsaltitude' => { 130 => 0x6, 160 => 'Altitude', 500 => 'GPSAltitude' },
	'gpsaltituderef' => { 130 => 0x5, 500 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 130 => 0x1c, 500 => 'GPSAreaInformation' },
	'gpscoordinates' => { 387 => "\xa9xyz", 389 => 'location.ISO6709', 395 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 130 => 0x1d },
	'gpsdatetime' => { 160 => 'DateTime', 500 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 130 => 0x18, 160 => 'Bearing', 500 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 130 => 0x17, 500 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 130 => 0x1a, 160 => 'Distance', 500 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 130 => 0x19, 500 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 130 => 0x14, 500 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 130 => 0x13 },
	'gpsdestlongitude' => { 130 => 0x16, 500 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 130 => 0x15 },
	'gpsdifferential' => { 130 => 0x1e, 160 => 'Differential', 500 => 'GPSDifferential' },
	'gpsdop' => { 130 => 0xb, 500 => 'GPSDOP' },
	'gpshpositioningerror' => { 130 => 0x1f, 500 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 130 => 0x11, 500 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 130 => 0x10, 500 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 114 => 'GPS-GPSLatitude', 116 => 'GpsLatitude', 130 => 0x2, 160 => 'Latitude', 500 => 'GPSLatitude' },
	'gpslatituderef' => { 130 => 0x1 },
	'gpslongitude' => { 114 => 'GPS-GPSLongitude', 116 => 'GpsLongitude', 130 => 0x4, 160 => 'Longitude', 500 => 'GPSLongitude' },
	'gpslongituderef' => { 130 => 0x3 },
	'gpslongtitude' => { 116 => 'GpsLongtitude' },
	'gpsmapdatum' => { 130 => 0x12, 160 => 'Datum', 500 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 130 => 0xa, 160 => 'MeasureMode', 500 => 'GPSMeasureMode' },
	'gpsposition' => { 114 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 130 => 0x1b, 500 => 'GPSProcessingMethod' },
	'gpssatellites' => { 130 => 0x8, 160 => 'Satellites', 500 => 'GPSSatellites' },
	'gpsspeed' => { 130 => 0xd, 160 => 'Speed', 500 => 'GPSSpeed' },
	'gpsspeedref' => { 130 => 0xc, 500 => 'GPSSpeedRef' },
	'gpsstatus' => { 130 => 0x9, 500 => 'GPSStatus' },
	'gpsstring' => { 138 => 0x402 },
	'gpstimestamp' => { 130 => 0x7 },
	'gpstrack' => { 130 => 0xf, 160 => 'Heading', 500 => 'GPSTrack' },
	'gpstrackref' => { 130 => 0xe, 500 => 'GPSTrackRef' },
	'gpsversionid' => { 130 => 0x0, 500 => 'GPSVersionID' },
	'gradation' => { 312 => 0x50f },
	'gradientbasedcorractive' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 494 => 'GradientBasedCorrections', 496 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 494 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 496 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 494 => 'GrainAmount', 496 => 'GrainAmount' },
	'graineffectroughness' => { 127 => 0x1047 },
	'graineffectsize' => { 127 => 0x104c },
	'grainfrequency' => { 494 => 'GrainFrequency', 496 => 'GrainFrequency' },
	'grainseed' => { 494 => 'GrainSeed', 496 => 'GrainSeed' },
	'grainsize' => { 494 => 'GrainSize', 496 => 'GrainSize' },
	'graymixeraqua' => { 494 => 'GrayMixerAqua', 496 => 'GrayMixerAqua' },
	'graymixerblue' => { 494 => 'GrayMixerBlue', 496 => 'GrayMixerBlue' },
	'graymixergreen' => { 494 => 'GrayMixerGreen', 496 => 'GrayMixerGreen' },
	'graymixermagenta' => { 494 => 'GrayMixerMagenta', 496 => 'GrayMixerMagenta' },
	'graymixerorange' => { 494 => 'GrayMixerOrange', 496 => 'GrayMixerOrange' },
	'graymixerpurple' => { 494 => 'GrayMixerPurple', 496 => 'GrayMixerPurple' },
	'graymixerred' => { 494 => 'GrayMixerRed', 496 => 'GrayMixerRed' },
	'graymixeryellow' => { 494 => 'GrayMixerYellow', 496 => 'GrayMixerYellow' },
	'graypoint' => { 470 => 0x8021 },
	'grayresponseunit' => { 119 => 0x122 },
	'greencurvelimits' => { 108 => 0x1c4 },
	'greencurvepoints' => { 107 => 0x53, 108 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 103 => 0x20913 },
	'greenhue' => { 494 => 'GreenHue', 496 => 'GreenHue' },
	'greensaturation' => { 494 => 'GreenSaturation', 496 => 'GreenSaturation' },
	'griddisplay' => { 294 => '13.3', 295 => '4.3', 297 => '4.2', 298 => '4.2', 299 => '2.2', 303 => '10.5', 304 => '3.4', 305 => '6.1', 307 => '4.4', 308 => '4.2', 309 => '4.2' },
	'gripbatteryadload' => { 349 => 0x5 },
	'gripbatteryadnoload' => { 349 => 0x4 },
	'gripbatterystate' => { 349 => '1.2' },
	'group' => { 494 => 'Group', 496 => 'Group' },
	'groupareaafillumination' => { 295 => '46.4', 298 => '47.4', 307 => '47.4' },
	'grouping' => { 387 => ['grup',"\xa9grp"], 395 => "\xa9grp" },
	'guid' => { 387 => 'GUID' },
	'h2resetblackpixels' => { 138 => 0x18a6 },
	'h3resetblackcolumns' => { 138 => 0x18ce },
	'h3resetblackpixels' => { 138 => 0x18b0 },
	'halftonehints' => { 119 => 0x141 },
	'hardlink' => { 120 => 'HardLink' },
	'hasalternative' => { 511 => 'hasAlternative' },
	'hascorrection' => { 511 => 'hasCorrection' },
	'hascorrectiona-lang' => { 511 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 511 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 511 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 494 => 'HasCrop', 496 => 'HasCrop' },
	'hasextendedxmp' => { 523 => 'HasExtendedXMP' },
	'hassettings' => { 494 => 'HasSettings', 496 => 'HasSettings' },
	'hastranslation' => { 511 => 'hasTranslation' },
	'hasvisibleoverprint' => { 526 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 526 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 237 => 0x35a },
	'hdmioutputresolution' => { 238 => 0x610, 239 => 0x640 },
	'hdmiviewassist' => { 310 => 0x20f },
	'hdr' => { 60 => 0x1, 218 => 0x4, 219 => 0x4, 335 => 0x9e, 370 => 0x85, 435 => 0x200a },
	'hdreditmode' => { 494 => 'HDREditMode', 496 => 'HDREditMode' },
	'hdreffect' => { 60 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 218 => 0x5, 219 => 0x5, 424 => 0x2e, 440 => 0x17 },
	'hdrlevel2' => { 218 => 0x7 },
	'hdrpmakernote' => { 477 => 'hdrp_makernote' },
	'hdrsetting' => { 424 => 0x2d, 440 => 0x16, 444 => 0x1148, 445 => 0x1148, 446 => 0x1124, 447 => 0x11a0, 448 => 0x117c, 449 => 0x1034, 450 => 0x22c, 451 => 0x22c, 452 => 0x21f },
	'hdrshot' => { 335 => 0x76 },
	'hdrsmoothing' => { 218 => 0x6 },
	'hdvideo' => { 387 => 'hdvd' },
	'headline' => { 131 => 0x69, 507 => 'Headline', 509 => 'Headline' },
	'hierarchicalkeywords' => { 171 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 171 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 171 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 171 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 171 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 486 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 118 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 239 => 0x48 },
	'highfrequencyflickerreductionshooting' => { 239 => 0x27c },
	'highisomultiplierblue' => { 340 => 0x1a },
	'highisomultipliergreen' => { 340 => 0x19 },
	'highisomultiplierred' => { 340 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 62 => 0x5, 84 => 0x202, 233 => 0xb1, 370 => 0x71, 422 => 0x2c, 423 => 0x26, 424 => 0x26, 435 => 0x2009, 440 => 0x12, 466 => 0x42 },
	'highisonoisereduction2' => { 435 => 0xb050 },
	'highlight' => { 412 => 0xf },
	'highlight2012' => { 494 => 'Highlight2012', 496 => 'Highlight2012' },
	'highlightadj' => { 103 => 0x2030c },
	'highlightcolordistortreduct' => { 470 => 0x8026 },
	'highlightlinearitylimit' => { 409 => 0xa025 },
	'highlightprotection' => { 286 => 0x6 },
	'highlightrecovery' => { 494 => 'HighlightRecovery', 496 => 'HighlightRecovery' },
	'highlights' => { 435 => 0x2033, 488 => 'Highlights' },
	'highlights2012' => { 494 => 'Highlights2012', 496 => 'Highlights2012' },
	'highlightsadj' => { 470 => 0x9019 },
	'highlightshadow' => { 335 => 0xad },
	'highlighttone' => { 127 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 62 => 0x3, 84 => 0x203 },
	'highlightwarning' => { 335 => 0x8002 },
	'highlowkeyadj' => { 370 => 0x6c },
	'highspeedsync' => { 184 => 0x5, 310 => 0x55, 422 => 0x2, 423 => 0x2 },
	'hintversion' => { 395 => 'hinv' },
	'histogramxml' => { 287 => 0x83a1a25 },
	'history' => { 509 => 'History', 522 => 'History' },
	'historyaction' => { 522 => [\'History','HistoryAction'] },
	'historychanged' => { 522 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 522 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 522 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 522 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 522 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 138 => 0xc88 },
	'holefilldeltathreshold' => { 138 => 0xc7e },
	'hometowncity' => { 113 => 0x3006, 370 => 0x23, 376 => 0x2 },
	'hometowncitycode' => { 377 => 0x1000 },
	'hometowndst' => { 370 => 0x25, 376 => '0.2' },
	'hostcomputer' => { 119 => 0x13c },
	'hostsoftwarerendering' => { 138 => 0xce7 },
	'hue' => { 189 => 0x3b, 247 => 0x3d, 248 => 0x45, 370 => 0x67 },
	'hueadj' => { 290 => 0x2f, 470 => 0x8019 },
	'hueadjust' => { 402 => 0x1016 },
	'hueadjustment' => { 182 => 0x4a, 183 => 0x40, 233 => 0x92, 246 => 0x36 },
	'hueadjustmentaqua' => { 494 => 'HueAdjustmentAqua', 496 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 494 => 'HueAdjustmentBlue', 496 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 494 => 'HueAdjustmentGreen', 496 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 494 => 'HueAdjustmentMagenta', 496 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 494 => 'HueAdjustmentOrange', 496 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 494 => 'HueAdjustmentPurple', 496 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 494 => 'HueAdjustmentRed', 496 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 494 => 'HueAdjustmentYellow', 496 => 'HueAdjustmentYellow' },
	'huesetting' => { 320 => 0x1011 },
	'humanobservation' => { 118 => 'HumanObservation' },
	'humanobservationday' => { 118 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 118 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 118 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 118 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 118 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 118 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 118 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 118 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 118 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 118 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 118 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 118 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 118 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 118 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 118 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 118 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 118 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 118 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 118 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 118 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 119 => 0x9401, 501 => 'Humidity' },
	'icc_profile' => { 120 => 'ICC_Profile' },
	'iccprofilename' => { 509 => 'ICCProfile' },
	'iconuri' => { 395 => 'icnu' },
	'idccreativestyle' => { 470 => 0x8000 },
	'idcpreviewlength' => { 470 => 0x202 },
	'idcpreviewstart' => { 470 => 0x201 },
	'identification' => { 118 => 'Identification' },
	'identificationid' => { 118 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 118 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 118 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 118 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 118 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 118 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 118 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 497 => 'identifier', 519 => 'Identifier' },
	'ifcameramodel' => { 138 => 0x9c8 },
	'illuminantdata1' => { 119 => 0xcd35 },
	'illuminantdata2' => { 119 => 0xcd36 },
	'illuminantdata3' => { 119 => 0xcd37 },
	'illumination' => { 305 => '0.5', 397 => 0x48 },
	'imageabsolutex' => { 138 => 0x3fe },
	'imageabsolutey' => { 138 => 0x3ff },
	'imageadjustment' => { 233 => 0x80, 277 => 0x5 },
	'imagealterationconstraints' => { 322 => 'ImageAlterationConstraints' },
	'imagearea' => { 263 => 0x10, 266 => 0x10 },
	'imageareaoffset' => { 370 => 0x38 },
	'imageauthentication' => { 233 => 0x20 },
	'imageboundary' => { 233 => 0x16 },
	'imagecapturereqestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 127 => 0x1438, 233 => 0xa5, 438 => 0x11b },
	'imagecreator' => { 322 => 'ImageCreator' },
	'imagecreatorid' => { 322 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 322 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 322 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 138 => 0x41f },
	'imagecropy' => { 138 => 0x420 },
	'imagedata' => { 481 => 'Data' },
	'imagedatasize' => { 233 => 0xa2 },
	'imagedescription' => { 119 => 0x10e, 517 => 'ImageDescription' },
	'imageduplicationconstraints' => { 322 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 287 => 0xfe443a45 },
	'imageeditcount' => { 370 => 0x41 },
	'imageediting' => { 370 => 0x32 },
	'imageeffects' => { 402 => 0x1010 },
	'imagefileconstraints' => { 322 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 322 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 322 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 127 => 0x1436 },
	'imageheight' => { 119 => 0x101, 188 => 0xc, 379 => 0x10d, 479 => 'ImageHeight', 517 => 'ImageLength' },
	'imagehistory' => { 119 => 0x9213, 499 => 'ImageHistory' },
	'imageidnumber' => { 330 => 0x340 },
	'imagemimetype' => { 481 => 'Mime' },
	'imagenumber' => { 119 => 0x9211, 156 => 'ImageNumber', 182 => 0xae, 183 => 0x5e, 379 => 0x113, 422 => 0x9b, 424 => [0x400,'276.1',0x314], 491 => 'ImageNumber' },
	'imagenumber2' => { 183 => 0x62 },
	'imageoptimization' => { 233 => 0xa9 },
	'imageorientation' => { 131 => 0x83 },
	'imageprocessing' => { 233 => 0x1a },
	'imageprocessingfiledatecreated' => { 138 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 138 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 316 => 0x0 },
	'imagequality' => { 156 => 'ImageQuality', 265 => '723.2', 266 => '732.2', 274 => '708.1', 335 => 0x1 },
	'imagequality2' => { 312 => 0x603 },
	'imagerank' => { 484 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 138 => 0x600 },
	'imagerboardversion' => { 138 => 0x439 },
	'imagercols' => { 138 => 0x17d4 },
	'imageref' => { 505 => 'ImageRef' },
	'imageregion' => { 507 => 'ImageRegion' },
	'imageregionboundary' => { 507 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 507 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 507 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 507 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 507 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 507 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 507 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 507 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 507 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 507 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 507 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 507 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 507 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 507 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 507 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 507 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 507 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 507 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 507 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 138 => 0x944 },
	'imageresolutionjpg' => { 138 => 0x945 },
	'imagereview' => { 296 => '0.4', 305 => '0.4' },
	'imagereviewmonitorofftime' => { 295 => '21.1', 297 => '21.1', 298 => '21.1', 302 => '20.1', 307 => '21.1', 308 => '21.1', 310 => 0x39 },
	'imagereviewtime' => { 294 => '25.1', 296 => '2.1', 299 => '19.1', 300 => '20.1', 301 => '20.1', 303 => '9.2', 304 => '20.1', 309 => '21.2' },
	'imagerfiledatecreated' => { 138 => 0x9c5 },
	'imagerfileproductionlevel' => { 138 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 138 => 0x9c7 },
	'imagerotated' => { 151 => 0x2a },
	'imagerpowerondelaymsec' => { 138 => 0x5fd },
	'imagerrows' => { 138 => 0x17de },
	'imagesegmentlines' => { 138 => 0x184d },
	'imagesegmentstartline' => { 138 => 0x184c },
	'imagesize' => { 162 => 'ImageSize' },
	'imagesizeraw' => { 233 => 0x3e },
	'imagesizerestriction' => { 514 => 'imageSizeRestriction' },
	'imagesourcedata' => { 119 => 0x935c },
	'imagespace' => { 138 => 0x909 },
	'imagestabilization' => { 34 => 0x22, 113 => 0x3020, 127 => 0x1422, 156 => 'ImageStabilization', 182 => 0xbd, 183 => 0x71, 184 => 0x57, 185 => 0x0, 186 => [0x18,0x107,0x113], 187 => 0x49c2, 233 => 0xac, 312 => 0x604, 315 => 0x1600, 335 => 0x1a, 427 => 0x12, 428 => 0x11, 435 => 0xb026 },
	'imagestabilization2' => { 426 => 0xa },
	'imagestabilizationsetting' => { 187 => 0x14, 422 => 0x3d, 423 => 0x3d, 433 => 0x14 },
	'imagestyle' => { 422 => 0x2d, 423 => 0x27 },
	'imagesupplier' => { 322 => 'ImageSupplier' },
	'imagesupplierid' => { 322 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 322 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 322 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 121 => 0x1 },
	'imagetemperaturemin' => { 121 => 0x2 },
	'imagetone' => { 370 => 0x4f },
	'imagetype' => { 131 => 0x82, 322 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 64 => 0x28, 119 => 0xa420, 499 => 'ImageUniqueID', 500 => 'ImageUniqueID' },
	'imagewidth' => { 119 => 0x100, 188 => 0xe, 379 => 0x10c, 479 => 'ImageWidth', 517 => 'ImageWidth' },
	'inclinationangle' => { 470 => 0x900f },
	'inclinationcorrection' => { 470 => 0x900e },
	'incrementaltemperature' => { 494 => 'IncrementalTemperature', 496 => 'IncrementalTemperature' },
	'incrementaltint' => { 494 => 'IncrementalTint', 496 => 'IncrementalTint' },
	'industry' => { 511 => 'industry', 512 => 'industry' },
	'infobuttonwhenshooting' => { 84 => 0x409 },
	'information' => { 389 => 'information', 395 => "\xa9inf" },
	'infourl' => { 395 => 'infu' },
	'infraredilluminator' => { 396 => 0x28 },
	'ingredientexclusion' => { 513 => 'ingredientExclusion' },
	'ingredients' => { 522 => 'Ingredients' },
	'ingredientsalternatepaths' => { 522 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 522 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 522 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 522 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 522 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 522 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 522 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 522 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 522 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 522 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 522 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 522 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 522 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 522 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 522 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 522 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 522 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 522 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 522 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 522 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 522 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 522 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 522 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 84 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 482 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 482 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 179 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 482 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 482 => 'InitialViewHeadingDegrees', 483 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 482 => 'InitialViewPitchDegrees', 483 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 482 => 'InitialViewRollDegrees', 483 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 294 => '4.4' },
	'initialzoomsetting' => { 294 => '9.3', 303 => '27.3' },
	'inkset' => { 119 => 0x14c },
	'inputprofile' => { 138 => 0x1389 },
	'instanceid' => { 522 => 'InstanceID' },
	'instantplaybacksetup' => { 184 => 0x3e },
	'instantplaybacktime' => { 184 => 0x3d },
	'instructions' => { 509 => 'Instructions' },
	'instrument' => { 521 => 'instrument' },
	'integrationtime' => { 138 => 0x423 },
	'intellectualgenre' => { 506 => 'IntellectualGenre' },
	'intelligentauto' => { 435 => 0xb052, 462 => 0xd, 463 => 0xe, 464 => 0xd },
	'intelligentcontrast' => { 52 => 0x4 },
	'intelligentd-range' => { 335 => 0x79 },
	'intelligentexposure' => { 335 => 0x5d },
	'intelligentresolution' => { 335 => 0x70 },
	'interchangecolorspace' => { 133 => 0x40 },
	'intergraphmatrix' => { 119 => 0x8480 },
	'internalflash' => { 181 => 0x2b, 294 => '23.1', 296 => '8.1', 299 => '22.1', 301 => '23.1', 305 => '8.1', 309 => '24.1', 315 => 0x1208 },
	'internalflashae1' => { 317 => 0x1021 },
	'internalflashae1_0' => { 317 => 0x101d },
	'internalflashae2' => { 317 => 0x1022 },
	'internalflashae2_0' => { 317 => 0x101e },
	'internalflashmode' => { 358 => 0x1 },
	'internalflashstrength' => { 358 => 0x3 },
	'internalflashtable' => { 317 => 0x1024 },
	'internallensserialnumber' => { 409 => 0xa005 },
	'internalndfilter' => { 335 => 0x9d },
	'internalserialnumber' => { 64 => 0x96, 76 => 0x9, 127 => 0x10, 187 => 0x49dc, 311 => 0x18, 313 => 0x102, 332 => 0x500, 335 => 0x25, 350 => 0x4, 402 => 0x5, 454 => [0x7c,0xf0], 455 => 0x88, 456 => [0x88,0x8a] },
	'interopindex' => { 119 => 0x1, 501 => 'InteroperabilityIndex' },
	'interopversion' => { 119 => 0x2 },
	'interval' => { 253 => 0x20 },
	'intervaldurationhours' => { 237 => 0xa0 },
	'intervaldurationminutes' => { 237 => 0xa4 },
	'intervaldurationseconds' => { 237 => 0xa8 },
	'intervalexposuresmoothing' => { 222 => 0x184, 237 => 0xb8 },
	'intervalframe' => { 253 => 0x24 },
	'intervallength' => { 181 => 0x10 },
	'intervalmode' => { 181 => 0x26 },
	'intervalnumber' => { 181 => 0x11 },
	'intervalpriority' => { 222 => 0x186, 237 => 0xba },
	'intervals' => { 222 => 0x17c, 237 => 0xb0, 238 => 0xbc, 239 => 0xcc },
	'intervalshooting' => { 223 => 0x24, 255 => 0x24, 256 => 0x28, 370 => 0x92 },
	'introtime' => { 521 => 'introTime' },
	'introtimescale' => { 521 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 521 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 138 => 0xdae },
	'ipfcameramodel' => { 138 => 0xe4d },
	'iptc' => { 120 => 'IPTC' },
	'iptc-naa' => { 119 => 0x83bb, 340 => 0x83bb },
	'iptcbitspersample' => { 133 => 0x56 },
	'iptcdigest' => { 384 => 0x425 },
	'iptcimageheight' => { 133 => 0x1e },
	'iptcimagerotation' => { 133 => 0x66 },
	'iptcimagewidth' => { 133 => 0x14 },
	'iptclastedited' => { 507 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 133 => 0xa },
	'iptcpixelheight' => { 133 => 0x32 },
	'iptcpixelwidth' => { 133 => 0x28 },
	'isalternativeof' => { 511 => 'isAlternativeOf' },
	'isbn' => { 511 => 'isbn' },
	'iscorrectionof' => { 511 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 109 => 0x3 },
	'ismergedhdr' => { 491 => 'IsMergedHDR' },
	'ismergedpanorama' => { 491 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 30 => 0x0, 31 => 0x1, 112 => 0x14, 113 => [0x3014,0x14], 119 => 0x8827, 137 => 0xfd06, 138 => 0x1784, 140 => 0x60, 142 => [0xfa2e,0xfa46], 143 => [0x27,0x28], 144 => 0xf105, 147 => 0x14, 149 => 0x4e, 151 => 0x1e, 152 => 0x1a, 154 => 0x34, 156 => 'ISO', 181 => 0x8, 187 => 0x49ba, 221 => 0x0, 233 => 0x2, 335 => 0xd1, 340 => 0x17, 370 => [0x8b,0x14], 377 => 0x14, 379 => 0x105, 409 => 0xa014, 412 => 0x86, 433 => 0x6f, 440 => [0x1f,0x21,0x25], 500 => 'ISOSpeedRatings' },
	'iso2' => { 221 => 0x6, 260 => 0x265, 261 => 0x25c, 262 => 0x265, 263 => 0x221, 264 => 0x25d, 265 => 0x256, 266 => 0x25d, 269 => 0x2b5, 272 => 0x265, 276 => 0x2b5 },
	'isoauto' => { 351 => '14.4' },
	'isoautoflashlimit' => { 238 => 0x146, 239 => 0x15a },
	'isoautohilimit' => { 220 => 0x5, 238 => 0x144, 239 => 0x158, 258 => 0x5, 268 => 0x18eb },
	'isoautomax' => { 434 => 0x4 },
	'isoautomin' => { 434 => 0x2 },
	'isoautoparameters' => { 370 => 0x7a },
	'isoautoshuttertime' => { 220 => 0x4, 238 => 0x14e, 239 => 0x162, 258 => 0x4, 268 => 0x18ea },
	'isocalibrationgain' => { 138 => 0x89f },
	'isodisplay' => { 297 => '4.1', 298 => '4.1', 299 => '2.3', 300 => '3.3', 301 => '3.3', 304 => '3.3', 307 => '4.3', 308 => '4.1', 309 => '4.3' },
	'isoexpansion' => { 84 => 0x103, 85 => 0x7, 86 => 0x8, 89 => 0x8, 221 => 0x4 },
	'isoexpansion2' => { 221 => 0xa },
	'isofloor' => { 351 => 0x6 },
	'isoselected' => { 334 => 0x359 },
	'isoselection' => { 233 => 0xf },
	'isosensitivitystep' => { 302 => '6.2', 304 => '6.2' },
	'isosetting' => { 140 => 0x5e, 152 => 0x14, 156 => 'ISOSetting', 181 => 0x24, 182 => 0x26, 183 => 0x1c, 184 => 0x13, 189 => 0x6, 233 => 0x13, 351 => '17.3', 401 => 0x27, 422 => 0x16, 423 => 0x14, 424 => 0x2, 433 => 0x6d, 434 => 0x0 },
	'isospeed' => { 119 => 0x8833, 501 => 'ISOSpeed' },
	'isospeedexpansion' => { 83 => 0x3 },
	'isospeedincrements' => { 84 => 0x102 },
	'isospeedlatitudeyyy' => { 119 => 0x8834, 501 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 119 => 0x8835, 501 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 84 => 0x103 },
	'isostepsize' => { 294 => '6.1', 295 => '7.2', 297 => '7.2', 298 => '7.2', 303 => '4.1', 307 => '7.2', 308 => '7.2', 310 => 0x15d },
	'isovalue' => { 317 => 0x1001 },
	'isrccode' => { 395 => "\xa9isr" },
	'issn' => { 511 => 'issn' },
	'issueidentifier' => { 511 => 'issueIdentifier' },
	'issuename' => { 511 => 'issueName' },
	'issueteaser' => { 511 => 'issueTeaser' },
	'issuetype' => { 511 => 'issueType' },
	'istranslationof' => { 511 => 'isTranslationOf' },
	'itemsubtype' => { 178 => 'ItemSubType' },
	'itunesu' => { 387 => 'itnu' },
	'jobid' => { 131 => 0xb8 },
	'jobname' => { 502 => 'JobName' },
	'jobref' => { 520 => 'JobRef' },
	'jobrefid' => { 520 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 520 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 520 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 502 => 'JobStatus' },
	'jpeg-heifswitch' => { 435 => 0x2039 },
	'jpeghandling' => { 494 => 'JPEGHandling', 496 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 335 => 0x43, 337 => 0x3034, 435 => 0xb047 },
	'jpegsize' => { 337 => 0x303a },
	'jpgcompression' => { 224 => 0x24 },
	'jpgfromraw' => { 97 => 0x2007, 114 => 'Exif-JpgFromRaw', 340 => 0x2e },
	'jpgfromrawlength' => { 119 => [0x117,0x202] },
	'jpgfromrawstart' => { 119 => [0x111,0x201] },
	'jpgrecordedpixels' => { 351 => '14.1' },
	'jurisdiction' => { 492 => 'jurisdiction' },
	'keepexposure' => { 310 => 0x237 },
	'kelvinwb_01' => { 359 => 0x5 },
	'kelvinwb_02' => { 359 => 0x9 },
	'kelvinwb_03' => { 359 => 0xd },
	'kelvinwb_04' => { 359 => 0x11 },
	'kelvinwb_05' => { 359 => 0x15 },
	'kelvinwb_06' => { 359 => 0x19 },
	'kelvinwb_07' => { 359 => 0x1d },
	'kelvinwb_08' => { 359 => 0x21 },
	'kelvinwb_09' => { 359 => 0x25 },
	'kelvinwb_10' => { 359 => 0x29 },
	'kelvinwb_11' => { 359 => 0x2d },
	'kelvinwb_12' => { 359 => 0x31 },
	'kelvinwb_13' => { 359 => 0x35 },
	'kelvinwb_14' => { 359 => 0x39 },
	'kelvinwb_15' => { 359 => 0x3d },
	'kelvinwb_16' => { 359 => 0x41 },
	'kelvinwb_daylight' => { 359 => 0x1 },
	'kerneldenominators' => { 138 => 0x933 },
	'key' => { 521 => 'key' },
	'keystonecompensation' => { 316 => 0x1900 },
	'keystonedirection' => { 316 => 0x1901 },
	'keystonevalue' => { 316 => 0x1906 },
	'keyword' => { 387 => 'keyw', 511 => 'keyword' },
	'keywordinfo' => { 171 => 'Keywords' },
	'keywords' => { 131 => 0x19, 157 => 'Keywords', 321 => 'Keywords', 386 => 'Keywords', 389 => 'keywords', 489 => 'keywords', 508 => 'Keywords', 519 => 'Keywords' },
	'killdate' => { 511 => 'killDate' },
	'killdatea-platform' => { 511 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 511 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 137 => 0xf908, 140 => 0xe, 142 => [0xfa1e,0xfa52], 148 => 0x70 },
	'kodakimagewidth' => { 137 => 0xf907, 140 => 0xc, 142 => [0xfa1d,0xfa51], 148 => 0x6c },
	'kodakinfotype' => { 137 => 0xfa00 },
	'kodaklook' => { 138 => 0xe4c },
	'kodaklookprofile' => { 138 => 0x138a },
	'kodakmaker' => { 148 => 0x8 },
	'kodakmodel' => { 140 => 0x0, 148 => 0x28 },
	'kodaktag' => { 138 => 0x3ea },
	'kodakversion' => { 138 => 0x0 },
	'label' => { 325 => 'Label', 519 => 'Label' },
	'labelname1' => { 505 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 505 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 505 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 505 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 505 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 505 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 335 => 0x6f },
	'landscapeoutputhighlightpoint' => { 109 => 0x26 },
	'landscapeoutputshadowpoint' => { 109 => 0x27 },
	'landscaperawcolortone' => { 109 => 0x1f },
	'landscaperawcontrast' => { 109 => 0x21 },
	'landscaperawhighlight' => { 109 => 0x77 },
	'landscaperawhighlightpoint' => { 109 => 0x24 },
	'landscaperawlinear' => { 109 => 0x22 },
	'landscaperawsaturation' => { 109 => 0x20 },
	'landscaperawshadow' => { 109 => 0x80 },
	'landscaperawshadowpoint' => { 109 => 0x25 },
	'landscaperawsharpness' => { 109 => 0x23 },
	'landscapeunsharpmaskfineness' => { 109 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 109 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 109 => 0xa2 },
	'language' => { 238 => 0x592, 239 => 0x5c2, 497 => 'language' },
	'languageidentifier' => { 131 => 0x87 },
	'largestvalidinteriorrectheight' => { 482 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 482 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 482 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 482 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 181 => 0x1b },
	'lastkeywordiptc' => { 178 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 178 => 'LastKeywordXMP' },
	'lastphotodate' => { 482 => 'LastPhotoDate' },
	'lasturl' => { 522 => 'LastURL' },
	'lateralchromaticaberration' => { 435 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 491 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 118 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 118 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 118 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 118 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 118 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 116 => 'Latitude' },
	'lc1' => { 361 => 0x2 },
	'lc10' => { 361 => 0xb },
	'lc11' => { 361 => 0xc },
	'lc12' => { 361 => 0xd },
	'lc14' => { 361 => 0xf },
	'lc15' => { 361 => 0x10 },
	'lc3' => { 361 => 0x4 },
	'lc4' => { 361 => 0x5 },
	'lc5' => { 361 => 0x6 },
	'lc6' => { 361 => 0x7 },
	'lc7' => { 361 => 0x8 },
	'lc8' => { 361 => 0x9 },
	'lcddisplayatpoweron' => { 84 => 0x811, 88 => 0xa },
	'lcddisplayreturntoshoot' => { 89 => 0x12 },
	'lcdillumination' => { 294 => '17.5', 295 => '5.2', 297 => '5.1', 298 => '5.1', 303 => '10.3', 304 => '4.2', 307 => '5.2', 308 => '5.1', 309 => '5.4', 310 => 0x101 },
	'lcdilluminationduringbulb' => { 84 => 0x408 },
	'lcdmatrix' => { 138 => 0xe74 },
	'lcdmatrixchickfix' => { 138 => 0xe75 },
	'lcdmatrixmarvin' => { 138 => 0xe76 },
	'lcdpanels' => { 83 => 0x8 },
	'lcheditor' => { 287 => 0x8ae85e },
	'legacyiptcdigest' => { 509 => 'LegacyIPTCDigest' },
	'legalcode' => { 492 => 'legalcode' },
	'lens' => { 119 => 0xfdea, 233 => 0x84, 491 => 'Lens' },
	'lensafstopbutton' => { 82 => 0x11, 83 => 0x13, 84 => 0x506, 85 => 0x10, 86 => 0x12, 89 => 0x13, 90 => 0x9 },
	'lensaperturerange' => { 412 => [0x30,0x48] },
	'lenscontrolring' => { 310 => 0xad },
	'lenscorrectionsettings' => { 499 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 491 => 'LensDistortInfo' },
	'lensdistortionparams' => { 317 => 0x206 },
	'lensdriveend' => { 231 => 0x56 },
	'lensdrivenoaf' => { 84 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 424 => 0x3f0, 469 => 0xd },
	'lensfirmware' => { 403 => 0x20, 409 => 0xa004 },
	'lensfirmwareversion' => { 313 => 0x204, 335 => 0x60, 424 => 0x3f3, 469 => 0x14 },
	'lensfocallength' => { 103 => 0xf0512, 361 => 0x9 },
	'lensfocalrange' => { 412 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 295 => '55.1', 297 => '52.1', 298 => '52.1', 307 => '52.1', 308 => '52.1' },
	'lensformat' => { 448 => 0x1891, 450 => 0x18bd, 451 => 0x18ed, 452 => 0x17f1, 454 => 0x106, 455 => 0x106, 465 => 0x603, 466 => 0x5d },
	'lensfstops' => { 225 => 0x7, 226 => 0xc, 227 => 0xd, 231 => 0xe, 233 => 0x8b, 361 => '0.3' },
	'lensfunc1button' => { 310 => 0x9f },
	'lensfunc2button' => { 310 => 0xa7 },
	'lensid' => { 231 => 0x30, 491 => 'LensID' },
	'lensidnumber' => { 225 => 0x6, 226 => 0xb, 227 => 0xc, 231 => 0xd },
	'lensinfo' => { 119 => 0xa432, 367 => 0x2a, 491 => 'LensInfo', 501 => 'LensSpecification' },
	'lenskind' => { 361 => 0x1 },
	'lensmake' => { 119 => 0xa433, 163 => 'Make', 501 => 'LensMake' },
	'lensmanualdistortionamount' => { 494 => 'LensManualDistortionAmount', 496 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 178 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 412 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 64 => 0x95, 119 => 0xa434, 163 => 'Model', 178 => 'LensModel', 228 => 0x18a, 229 => 0x18b, 230 => 0x2ac, 313 => 0x203, 367 => 0xc, 379 => 0x412, 501 => 'LensModel' },
	'lensmodulationoptimizer' => { 127 => 0x1045 },
	'lensmount' => { 424 => 0x99, 448 => 0x1892, 450 => 0x18be, 451 => 0x18ee, 452 => 0x17f2, 454 => 0x105, 455 => 0x105, 465 => 0x604, 466 => 0x5e },
	'lensmount2' => { 469 => 0x8 },
	'lensmounttype' => { 231 => 0x35 },
	'lenspositionabsolute' => { 231 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 494 => 'LensProfileChromaticAberrationScale', 496 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 494 => 'LensProfileDigest', 496 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 494 => 'LensProfileDistortionScale', 496 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 494 => 'LensProfileEnable', 496 => 'LensProfileEnable' },
	'lensprofilefilename' => { 494 => 'LensProfileFilename', 496 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 494 => 'LensProfileIsEmbedded', 496 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 494 => 'LensProfileMatchKeyCameraModelName', 496 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 494 => 'LensProfileMatchKeyExifMake', 496 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 494 => 'LensProfileMatchKeyExifModel', 496 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 494 => 'LensProfileMatchKeyIsRaw', 496 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 494 => 'LensProfileMatchKeyLensID', 496 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 494 => 'LensProfileMatchKeyLensInfo', 496 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 494 => 'LensProfileMatchKeyLensName', 496 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 494 => 'LensProfileMatchKeySensorFormatFactor', 496 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 494 => 'LensProfileName', 496 => 'LensProfileName' },
	'lensprofilesetup' => { 494 => 'LensProfileSetup', 496 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 494 => 'LensProfileVignettingScale', 496 => 'LensProfileVignettingScale' },
	'lensproperties' => { 313 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 32 => 0x16b, 61 => 0x0, 119 => 0xa435, 163 => 'SerialNumber', 313 => 0x202, 333 => 0x321, 335 => 0x52, 395 => 'LENS', 403 => 0x30, 491 => 'LensSerialNumber', 501 => 'LensSerialNumber' },
	'lensshutterlock' => { 184 => 0x4a },
	'lensspec' => { 419 => 0x0, 420 => 0x0, 421 => 0x0, 435 => 0xb02a },
	'lensspecfeatures' => { 454 => [0x115,0x116], 455 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 317 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 34 => 0x16, 186 => 0x10c, 187 => 0x49bd, 233 => 0x83, 313 => 0x201, 326 => 0x16, 330 => 0x310, 332 => 0x303, 333 => 0x303, 335 => 0x51, 337 => 0x3405, 362 => 0x0, 363 => 0x0, 364 => 0x1, 365 => 0x1, 366 => 0x1, 368 => 0x0, 409 => 0xa003, 412 => 0x27, 435 => 0xb027, 448 => 0x1896, 450 => 0x18c2, 451 => 0x18f2, 452 => 0x17f6, 454 => 0x109, 455 => 0x109, 465 => 0x608, 466 => 0x62 },
	'lenstype2' => { 424 => 0x3f7, 448 => 0x1893, 450 => 0x18bf, 451 => 0x18ef, 452 => 0x17f3, 454 => 0x107, 455 => 0x107, 465 => 0x605, 466 => 0x60 },
	'lenstype3' => { 469 => 0x9 },
	'lenstypemake' => { 335 => 0xc4 },
	'lenstypemodel' => { 335 => [0xc5,0xe4] },
	'lenszoomposition' => { 462 => 0x19, 463 => 0x1e, 466 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 343 => 0x15 },
	'levelmeter' => { 395 => ['Lvlm','lvlm'] },
	'levelorientation' => { 369 => 0x0 },
	'license' => { 492 => 'license' },
	'licensee' => { 322 => 'Licensee' },
	'licenseeid' => { 322 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 322 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 322 => 'LicenseeImageNotes' },
	'licenseename' => { 322 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 322 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 322 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 322 => 'LicenseeTransactionID' },
	'licenseid' => { 322 => 'LicenseID' },
	'licensestartdate' => { 322 => 'LicenseStartDate' },
	'licensetransactiondate' => { 322 => 'LicenseTransactionDate' },
	'licensetype' => { 498 => 'licensetype' },
	'licensor' => { 322 => 'Licensor' },
	'licensorcity' => { 322 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 322 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 322 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 322 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 322 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 322 => 'LicensorImageID' },
	'licensorname' => { 322 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 322 => 'LicensorNotes' },
	'licensorpostalcode' => { 322 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 322 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 322 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 322 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 322 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 322 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 322 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 322 => 'LicensorTransactionID' },
	'licensorurl' => { 322 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 317 => 0x1009 },
	'lightingmode' => { 113 => 0x302a },
	'lightreading' => { 370 => 0x15 },
	'lightsource' => { 119 => 0x9208, 233 => 0x90, 320 => 0x1000, 500 => 'LightSource' },
	'lightsourcespecial' => { 411 => 0x21d },
	'lightswitch' => { 307 => '0.1', 309 => '0.1' },
	'lightvaluecenter' => { 317 => 0x103d },
	'lightvalueperiphery' => { 317 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 310 => 0x153 },
	'limitaf-areamodeseldynamic_l' => { 310 => 0x151 },
	'limitaf-areamodeseldynamic_m' => { 310 => 0x150 },
	'limitaf-areamodeseldynamic_s' => { 310 => 0x14f },
	'limitaf-areamodeselpinpoint' => { 310 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 310 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 310 => 0x13 },
	'limitafareamodeselauto' => { 310 => 0x15 },
	'limitafareamodeselection' => { 295 => '51.1', 297 => '49.1', 298 => '49.1', 307 => '49.1', 308 => '49.1' },
	'limitreleasemodeselc120' => { 310 => '269.4' },
	'limitreleasemodeselc30' => { 310 => '269.3' },
	'limitreleasemodeselch' => { 310 => '269.2' },
	'limitreleasemodeselcl' => { 310 => '269.1' },
	'limitreleasemodeselself' => { 310 => '269.5' },
	'limitselectableimagearea16to9' => { 310 => 0x47 },
	'limitselectableimagearea1to1' => { 310 => 0x46 },
	'limitselectableimageareadx' => { 310 => 0x45 },
	'linearitylimitblue' => { 340 => 0x10 },
	'linearitylimitgreen' => { 340 => 0xf },
	'linearitylimitred' => { 340 => 0xe },
	'linearityuppermargin' => { 41 => 0x32c, 42 => 0x282, 45 => [0x2ba,0x2d1,0x2d5], 47 => 0x1e5, 48 => [0x1fe,0x2de], 49 => [0x232,0x310], 50 => 0x31e },
	'linearizationtable' => { 119 => 0xc618 },
	'linearresponselimit' => { 119 => 0xc62e },
	'link' => { 511 => 'link' },
	'linkaetoafpoint' => { 351 => '14.2' },
	'linkedencodedrightsexpr' => { 507 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 507 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 507 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 507 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 138 => 0x904 },
	'lithostratigraphicterms' => { 118 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 389 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 389 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 389 => 'live-photo.vitality-scoring-version' },
	'liveviewaf' => { 299 => '32.1', 309 => '34.1' },
	'liveviewafareamode' => { 304 => '34.1' },
	'liveviewafmethod' => { 440 => 0x20 },
	'liveviewafmode' => { 304 => '34.2' },
	'liveviewafsetting' => { 424 => 0x36 },
	'liveviewbuttonoptions' => { 295 => '50.2', 297 => '48.2', 298 => '48.2', 307 => '48.2', 308 => '48.2' },
	'liveviewexposuresimulation' => { 84 => 0x810 },
	'liveviewfocusmode' => { 424 => [0x8b,0x28b] },
	'liveviewmetering' => { 424 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 295 => '21.2', 297 => '21.2', 298 => '21.2', 300 => '20.2', 301 => '20.2', 302 => '20.2', 304 => '20.2', 307 => '21.2', 308 => '21.2' },
	'liveviewshooting' => { 57 => 0x13 },
	'livingspecimen' => { 118 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 118 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 131 => 0x79 },
	'localizedcameramodel' => { 119 => 0xc615 },
	'locallocationname' => { 409 => 0x30 },
	'location' => { 232 => 0x9, 335 => 0x67, 487 => 'Location', 506 => 'Location', 510 => 'location', 511 => 'location' },
	'locationaccuracyhorizontal' => { 389 => 'location.accuracy.horizontal' },
	'locationareacode' => { 493 => 'lac' },
	'locationbody' => { 389 => 'location.body' },
	'locationcreated' => { 507 => 'LocationCreated' },
	'locationcreatedcity' => { 507 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 507 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 507 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 507 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 507 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 507 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 507 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 507 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 507 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 507 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 507 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 507 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 389 => 'location.date' },
	'locationinformation' => { 395 => 'loci' },
	'locationinfoversion' => { 232 => 0x0 },
	'locationname' => { 389 => 'location.name', 409 => 0x31 },
	'locationnote' => { 389 => 'location.note' },
	'locationrole' => { 389 => 'location.role' },
	'locationshown' => { 507 => 'LocationShown' },
	'locationshowncity' => { 507 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 507 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 507 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 507 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 507 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 507 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 507 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 507 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 507 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 507 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 507 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 507 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 84 => 0x709 },
	'logcomment' => { 521 => 'logComment' },
	'logscale' => { 138 => 0x902 },
	'longdescription' => { 387 => 'ldes' },
	'longexposurenoisereduction' => { 62 => 0x4, 84 => 0x201, 85 => 0x1, 86 => 0x2, 87 => 0x1, 88 => 0x1, 89 => 0x2, 90 => 0x1, 335 => 0x49, 422 => 0x2b, 423 => 0x25, 424 => 0x25, 435 => 0x2008, 440 => 0x11, 466 => 0x44 },
	'longexposurenoisereduction2' => { 57 => 0x8 },
	'longexposurenrused' => { 335 => 0xbe },
	'longitude' => { 116 => 'Longitude' },
	'look' => { 494 => 'Look', 496 => 'Look' },
	'lookamount' => { 494 => [\'Look','LookAmount'], 496 => [\'Look','LookAmount'] },
	'lookcluster' => { 494 => [\'Look','LookCluster'], 496 => [\'Look','LookCluster'] },
	'lookcopyright' => { 494 => [\'Look','LookCopyright'], 496 => [\'Look','LookCopyright'] },
	'lookgroup' => { 494 => [\'Look','LookGroup'], 496 => [\'Look','LookGroup'] },
	'lookname' => { 494 => 'LookName', 496 => 'LookName' },
	'lookparameters' => { 494 => [\'Look','LookParameters'], 496 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 494 => [\'Look','LookParametersCameraProfile'], 496 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 494 => [\'Look','LookParametersClarity2012'], 496 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 494 => [\'Look','LookParametersConvertToGrayscale'], 496 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparameterslooktable' => { 494 => [\'Look','LookParametersLookTable'], 496 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 494 => [\'Look','LookParametersProcessVersion'], 496 => [\'Look','LookParametersProcessVersion'] },
	'lookparameterstonecurvepv2012' => { 494 => [\'Look','LookParametersToneCurvePV2012'], 496 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 494 => [\'Look','LookParametersToneCurvePV2012Blue'], 496 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 494 => [\'Look','LookParametersToneCurvePV2012Green'], 496 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 494 => [\'Look','LookParametersToneCurvePV2012Red'], 496 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 494 => [\'Look','LookParametersVersion'], 496 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 494 => [\'Look','LookSupportsAmount'], 496 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 494 => [\'Look','LookSupportsMonochrome'], 496 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 494 => [\'Look','LookSupportsOutputReferred'], 496 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 494 => [\'Look','LookUUID'], 496 => [\'Look','LookUUID'] },
	'loop' => { 521 => 'loop' },
	'loopstyle' => { 395 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 118 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 494 => 'LuminanceAdjustmentAqua', 496 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 494 => 'LuminanceAdjustmentBlue', 496 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 494 => 'LuminanceAdjustmentGreen', 496 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 494 => 'LuminanceAdjustmentMagenta', 496 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 494 => 'LuminanceAdjustmentOrange', 496 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 494 => 'LuminanceAdjustmentPurple', 496 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 494 => 'LuminanceAdjustmentRed', 496 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 494 => 'LuminanceAdjustmentYellow', 496 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 108 => 0x150 },
	'luminancecurvepoints' => { 108 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 103 => 0x20600, 109 => 0x5f, 412 => 0x1b },
	'luminancenoisereductioncontrast' => { 494 => 'LuminanceNoiseReductionContrast', 496 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 494 => 'LuminanceNoiseReductionDetail', 496 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 109 => 0x6d },
	'luminancesmoothing' => { 494 => 'LuminanceSmoothing', 496 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 84 => [0x40b,0x40c] },
	'lyrics' => { 387 => "\xa9lyr", 395 => "\xa9lyr", 521 => 'lyrics' },
	'lyricsuri' => { 395 => 'lrcu' },
	'm16cversion' => { 330 => 0x333 },
	'macatom' => { 495 => 'macAtom' },
	'macatomapplicationcode' => { 495 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 495 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 495 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 118 => 'MachineObservation' },
	'machineobservationday' => { 118 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 118 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 118 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 118 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 118 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 118 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 118 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 118 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 118 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 118 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 118 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 118 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 118 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 118 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 118 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 118 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 118 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 118 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 118 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 118 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 127 => 0x1020, 129 => 0x202, 151 => 0x2b, 317 => 0x202, 401 => 0x21, 411 => 0x202, 435 => 0xb040 },
	'macroled' => { 315 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 57 => 0x10 },
	'macromode' => { 34 => 0x1, 181 => 0xb, 312 => 0x300, 335 => 0x1c, 402 => 0x1009 },
	'magentahsl' => { 103 => 0x20917 },
	'magicfilter' => { 312 => 0x52c },
	'magnifiedview' => { 86 => 0x11, 88 => 0x9 },
	'mainboardversion' => { 138 => 0x438 },
	'maindialexposurecomp' => { 305 => '0.6' },
	'mainingredient' => { 513 => 'mainIngredient' },
	'majorversion' => { 485 => 'MajorVersion' },
	'make' => { 98 => 0x0, 115 => 0x1, 119 => 0x10f, 156 => 'Make', 325 => 'Make', 340 => 0x10f, 389 => 'make', 395 => ['@mak',"\xa9mak"], 510 => 'make', 517 => 'Make' },
	'makernote' => { 500 => 'MakerNote' },
	'makernoteapple' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecanon' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecasio' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecasio2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotedji' => { 117 => 'MakN', 119 => 0x927c },
	'makernotedjiinfo' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteflir' => { 117 => 'MakN', 119 => 0x927c },
	'makernotefujifilm' => { 117 => 'MakN', 119 => 0x927c },
	'makernotege' => { 117 => 'MakN', 119 => 0x927c },
	'makernotege2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehasselblad' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp6' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteisl' => { 117 => 'MakN', 119 => 0x927c },
	'makernotejvc' => { 117 => 'MakN', 119 => 0x927c },
	'makernotejvctext' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak10' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak11' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak12' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak1a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak1b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak6a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak6b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak7' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8c' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak9' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodakunknown' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekyocera' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica10' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica3' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica4' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica5' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica6' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica7' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica8' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica9' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotemotorola' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenintendo' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteoffset' => { 411 => 0xff },
	'makernoteolympus' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteolympus2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteolympus3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax6' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentaxunknown' => { 395 => 'PXMN' },
	'makernotephaseone' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericoh' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericoh2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericohpentax' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericohtext' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesafety' => { 119 => 0xc635 },
	'makernotesamsung1a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesamsung1b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesamsung2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyo' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyoc4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyopatch' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesigma' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesonyericsson' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesonysrf' => { 117 => 'MakN', 119 => 0x927c },
	'makernotetype' => { 402 => 0x1 },
	'makernoteunknown' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteunknownbinary' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteunknowntext' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 186 => 0x0, 233 => 0x1, 317 => 0x0, 335 => 0x8000, 406 => 0x0, 409 => 0x1, 412 => [0x1d,0x1f], 425 => 0x2000 },
	'makerurl' => { 395 => "\xa9mal" },
	'managedfrom' => { 522 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 522 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 522 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 522 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 522 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 522 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 522 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 522 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 522 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 522 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 522 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 522 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 522 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 522 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 522 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 522 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 522 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 522 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 522 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 522 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 522 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 522 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 522 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 522 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 522 => 'Manager' },
	'managervariant' => { 522 => 'ManagerVariant' },
	'manageto' => { 522 => 'ManageTo' },
	'manageui' => { 522 => 'ManageUI' },
	'manifest' => { 522 => 'Manifest' },
	'manifestlinkform' => { 522 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 522 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 522 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 522 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 522 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 522 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 522 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 522 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 522 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 522 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 522 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 522 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 522 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 522 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 522 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 522 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 522 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 522 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 522 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 522 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 522 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 522 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 522 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 522 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 522 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 522 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 522 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 522 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 312 => 0x900, 335 => 0x86 },
	'manometerreading' => { 312 => 0x901 },
	'manualafpointselectpattern' => { 84 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 315 => 0x1209 },
	'manualflashoutput' => { 34 => 0x29, 296 => '8.2', 299 => '22.2', 300 => '23.1', 301 => '23.2', 303 => '16.2', 304 => '23.2', 305 => '8.2', 306 => '23.2', 309 => '24.2', 402 => 0x100c },
	'manualflashstrength' => { 312 => 0x406 },
	'manualfocusdistance' => { 233 => 0x85, 317 => 0x100c, 411 => 0x223 },
	'manualfocuspointillumination' => { 310 => 0x17 },
	'manualfocusringinafmode' => { 310 => 0x1a },
	'manualtv' => { 83 => 0x5, 84 => 0x705 },
	'manufacturedate' => { 191 => 0x6705, 350 => 0x1 },
	'manufacturedate1' => { 404 => 0x4 },
	'manufacturedate2' => { 404 => 0x5 },
	'manufacturer' => { 479 => 'Manufacturer', 510 => 'manufacturer' },
	'mariahchromablursize' => { 138 => 0xf0d },
	'mariahmaphithreshold' => { 138 => 0xf0c },
	'mariahmaplothreshold' => { 138 => 0xf0b },
	'mariahsigmathreshold' => { 138 => 0xf0e },
	'mariahtexturethreshold' => { 138 => 0xf0a },
	'marked' => { 508 => 'Marked', 525 => 'Marked' },
	'markers' => { 521 => 'markers' },
	'markerscomment' => { 521 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 521 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 521 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 521 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 521 => [\'markers','markersCuePointType'] },
	'markersduration' => { 521 => [\'markers','markersDuration'] },
	'markerslocation' => { 521 => [\'markers','markersLocation'] },
	'markersname' => { 521 => [\'markers','markersName'] },
	'markersprobability' => { 521 => [\'markers','markersProbability'] },
	'markersspeaker' => { 521 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 521 => [\'markers','markersStartTime'] },
	'markerstarget' => { 521 => [\'markers','markersTarget'] },
	'markerstype' => { 521 => [\'markers','markersType'] },
	'maskedareas' => { 119 => 0xc68e },
	'maskgroupbasedcorractive' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 494 => 'MaskGroupBasedCorrections', 496 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 494 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 496 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 131 => 0xb9 },
	'mastergain' => { 254 => 0x50 },
	'materialsample' => { 118 => 'MaterialSample' },
	'materialsampleid' => { 118 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 295 => '50.1', 297 => '48.1', 298 => '48.1', 307 => '48.1', 308 => '48.1', 310 => 0x233 },
	'matrixselectk' => { 138 => 0x91b },
	'matrixselectthreshold' => { 138 => 0x91a },
	'matrixselectthreshold1' => { 138 => 0x91e },
	'matrixselectthreshold2' => { 138 => 0x91f },
	'matrixstructure' => { 394 => 0xa },
	'maxaperture' => { 34 => 0x1a, 138 => 0x3f9, 144 => 0x6103, 163 => 'MaxAperture', 181 => 0x17, 187 => 0x49c5, 231 => 0x36, 313 => 0x20a, 361 => '14.1' },
	'maxapertureatmaxfocal' => { 127 => 0x1407, 163 => 'MaxApertureAtMaxFocal', 225 => 0xb, 226 => 0x10, 227 => 0x11, 231 => 0x12, 313 => 0x206 },
	'maxapertureatminfocal' => { 127 => 0x1406, 225 => 0xa, 226 => 0xf, 227 => 0x10, 231 => 0x11, 313 => 0x205 },
	'maxaperturevalue' => { 119 => 0x9205, 379 => 0x414, 500 => 'MaxApertureValue' },
	'maxavailheight' => { 507 => 'MaxAvailHeight' },
	'maxavailwidth' => { 507 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 294 => 0xb, 295 => 0xc, 297 => '12.1', 298 => '12.1', 303 => 0xc, 304 => 0xb, 307 => '12.1', 308 => '12.1', 310 => 0x3d },
	'maxfaces' => { 316 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 34 => 0x17, 127 => 0x1405, 163 => 'MaxFocalLength', 225 => 0x9, 226 => 0xe, 227 => 0xf, 231 => 0x10, 313 => 0x208, 448 => 0x127c, 449 => 0x1138, 450 => 0x330, 451 => 0x330, 452 => 0x30e },
	'maximumdensityrange' => { 133 => 0x8c },
	'maxpagesize' => { 526 => 'MaxPageSize' },
	'maxpagesizeh' => { 526 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 526 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 526 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 138 => 0xc7d },
	'maxsamplevalue' => { 119 => 0x119 },
	'maxstorage' => { 516 => 'maxstorage' },
	'mb-d10batteries' => { 294 => '12.6' },
	'mb-d10batterytype' => { 303 => '13.3' },
	'mb-d11batterytype' => { 304 => '2.3' },
	'mb-d12batterytype' => { 307 => '3.2' },
	'mb-d80batteries' => { 305 => '6.5' },
	'mb-d80batterytype' => { 309 => '3.2' },
	'mcuversion' => { 225 => 0xc, 226 => 0x11, 227 => 0x12, 231 => 0x13 },
	'md5digest' => { 164 => 'zmd5' },
	'mditemfindercomment' => { 173 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 173 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 173 => 'MDItemFSLabel' },
	'mditemusertags' => { 173 => 'MDItemUserTags' },
	'meal' => { 513 => 'meal' },
	'measuredev' => { 28 => 0x9, 77 => 0x3, 97 => 0x1814, 156 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 77 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 187 => 0x690, 330 => 0x312, 333 => 0x312, 334 => 0x312, 337 => 0x3407 },
	'measuredrggb' => { 65 => 0x1 },
	'measuredrggbdata' => { 44 => 0x287 },
	'measurementaccuracy' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 118 => 'MeasurementOrFact' },
	'measurementremarks' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 479 => 'MeasureType' },
	'mechanicalshuttercount' => { 233 => 0x37 },
	'mediaclassprimaryid' => { 179 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 179 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 322 => 'MediaConstraints' },
	'mediacreatedate' => { 391 => 0x1 },
	'mediaeventiddate' => { 484 => 'MediaEventIdDate' },
	'mediagroupuuid' => { 1 => 0x11 },
	'mediamodifydate' => { 391 => 0x2 },
	'mediasummarycode' => { 322 => 'MediaSummaryCode' },
	'mediatype' => { 387 => 'stik' },
	'memoaudioquality' => { 84 => 0x812 },
	'memorycardconfiguration' => { 428 => 0x16 },
	'memorycardnumber' => { 210 => 0x2 },
	'menubuttondisplayposition' => { 82 => 0xb, 85 => 0xa, 86 => 0xb, 89 => 0xb },
	'menubuttonreturn' => { 90 => 0xb },
	'menumonitorofftime' => { 294 => '26.1', 295 => '22.1', 297 => '22.1', 298 => '22.1', 302 => '21.1', 303 => '8.2', 304 => '21.1', 307 => '22.1', 308 => '22.1', 309 => '22.1', 310 => 0x35 },
	'metadataauthority' => { 507 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 507 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 507 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 519 => 'MetadataDate' },
	'metadatalastedited' => { 507 => 'metadataLastEdited' },
	'metadatalasteditor' => { 507 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 507 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 507 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 521 => 'metadataModDate' },
	'metaversion' => { 443 => 0x34 },
	'meterinfo1row1' => { 436 => 0x0, 437 => 0x0 },
	'meterinfo1row2' => { 436 => 0x6c, 437 => 0x5a },
	'meterinfo1row3' => { 436 => 0xd8, 437 => 0xb4 },
	'meterinfo1row4' => { 436 => 0x144, 437 => 0x10e },
	'meterinfo1row5' => { 436 => 0x1b0, 437 => 0x168 },
	'meterinfo1row6' => { 436 => 0x21c, 437 => 0x1c2 },
	'meterinfo1row7' => { 436 => 0x288, 437 => 0x21c },
	'meterinfo2row1' => { 436 => 0x2f4, 437 => 0x276 },
	'meterinfo2row2' => { 436 => 0x378, 437 => 0x2e4 },
	'meterinfo2row3' => { 436 => 0x3fc, 437 => 0x352 },
	'meterinfo2row4' => { 436 => 0x480, 437 => 0x3c0 },
	'meterinfo2row5' => { 436 => 0x504, 437 => 0x42e },
	'meterinfo2row6' => { 436 => 0x588, 437 => 0x49c },
	'meterinfo2row7' => { 436 => 0x60c, 437 => 0x50a },
	'meterinfo2row8' => { 436 => 0x690, 437 => 0x578 },
	'meterinfo2row9' => { 436 => 0x714, 437 => 0x5e6 },
	'metering' => { 296 => '6.1' },
	'meteringmode' => { 34 => 0x11, 119 => 0x9207, 140 => 0x1c, 181 => 0x7, 182 => 0x25, 184 => 0x12, 312 => 0x202, 370 => 0x17, 412 => 0x9, 422 => 0x15, 423 => 0x13, 424 => 0x7, 440 => 0x3, 444 => 0x1174, 445 => 0x1178, 446 => 0x1154, 447 => 0x11d0, 448 => 0x11ac, 449 => 0x1064, 450 => 0x25c, 451 => 0x25c, 452 => 0x24b, 500 => 'MeteringMode' },
	'meteringmode2' => { 351 => '2.1', 435 => 0x202c },
	'meteringmode3' => { 351 => '16.1' },
	'meteringoffscaleindicator' => { 184 => 0x53 },
	'meteringtime' => { 294 => '22.2', 296 => '3.2', 299 => '17.1', 300 => '18.1', 303 => '7.3', 304 => '18.1', 305 => '3.2', 309 => '19.1' },
	'micro1version' => { 397 => 0x1f },
	'micro2version' => { 397 => 0x2d },
	'microphoneattenuator' => { 238 => 0x2d2, 239 => 0x2fa },
	'microphonefrequencyresponse' => { 238 => 0x2d4, 239 => 0x2fc },
	'microphonejackpower' => { 238 => 0x2fa, 239 => 0x322 },
	'microphonesensitivity' => { 238 => 0x2d0, 239 => 0x2f8 },
	'microvideo' => { 477 => 'MicroVideo' },
	'microvideooffset' => { 477 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 477 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 477 => 'MicroVideoVersion' },
	'midrangesharpness' => { 248 => 0x3b },
	'mieversion' => { 164 => '0Vers' },
	'mime' => { 479 => 'Mime' },
	'minaperture' => { 34 => 0x1b, 138 => 0x3f8, 163 => 'MinAperture', 361 => '0.2' },
	'minaperturevalue' => { 379 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 34 => 0x18, 127 => 0x1404, 163 => 'MinFocalLength', 225 => 0x8, 226 => 0xd, 227 => 0xe, 231 => 0xf, 313 => 0x207, 448 => 0x127a, 449 => 0x1136, 450 => 0x32e, 451 => 0x32e, 452 => 0x30c },
	'minfocusdistance' => { 361 => 0x3 },
	'minimumiso' => { 335 => 0xe8 },
	'minintegrationrows' => { 138 => 0x1874 },
	'minoltadate' => { 181 => 0x15 },
	'minoltaimagesize' => { 181 => 0x4, 182 => 0xc, 183 => 0x2, 186 => 0x103 },
	'minoltamodelid' => { 181 => 0x25 },
	'minoltaquality' => { 181 => 0x5, 182 => 0xd, 183 => 0x3, 186 => [0x102,0x103] },
	'minoltatime' => { 181 => 0x16 },
	'minormodelagedisclosure' => { 322 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 485 => 'MinorVersion' },
	'minsamplevalue' => { 119 => 0x118 },
	'mirrorlockup' => { 82 => 0xc, 83 => 0xc, 84 => 0x60f, 85 => 0xb, 86 => 0xc, 87 => 0x6, 88 => 0x6, 89 => 0xc, 90 => 0x3 },
	'mobilecountrycode' => { 493 => 'mcc' },
	'mobilenetworkcode' => { 493 => 'mnc' },
	'moddate' => { 325 => 'modify-date', 508 => 'ModDate' },
	'modedialposition' => { 428 => 0x14 },
	'model' => { 98 => 0x6, 119 => 0x110, 156 => 'Model', 325 => 'Model', 340 => 0x110, 370 => 0x23f, 389 => 'model', 395 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 412 => 0x84, 479 => 'Model', 510 => 'model', 517 => 'Model' },
	'modelage' => { 507 => 'ModelAge' },
	'modelid' => { 311 => 0x0 },
	'modelingflash' => { 294 => '21.4', 295 => '31.1', 297 => '31.1', 298 => '31.1', 303 => '26.4', 304 => '30.2', 305 => '7.4', 306 => '30.1', 307 => '31.1', 308 => '31.1', 309 => '31.3', 310 => 0x5d },
	'modelreleaseid' => { 322 => 'ModelReleaseID' },
	'modelreleasestatus' => { 322 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 457 => 0x52, 458 => 0x46, 459 => 0x53 },
	'modeltiepoint' => { 119 => 0x8482 },
	'modeltransform' => { 119 => 0x85d8 },
	'modelyear' => { 510 => 'modelYear' },
	'modificationdate' => { 511 => 'modificationDate' },
	'modifiedcolortemp' => { 66 => 0x9 },
	'modifieddigitalgain' => { 66 => 0xb },
	'modifiedparamflag' => { 58 => 0x1 },
	'modifiedpicturestyle' => { 66 => 0xa },
	'modifiedsaturation' => { 312 => 0x504 },
	'modifiedsensorbluelevel' => { 66 => 0x5 },
	'modifiedsensorredlevel' => { 66 => 0x4 },
	'modifiedsharpness' => { 66 => 0x2 },
	'modifiedsharpnessfreq' => { 66 => 0x3 },
	'modifiedtonecurve' => { 66 => 0x1 },
	'modifiedwhitebalance' => { 66 => 0x8 },
	'modifiedwhitebalanceblue' => { 66 => 0x7 },
	'modifiedwhitebalancered' => { 66 => 0x6 },
	'modifydate' => { 119 => 0x132, 157 => 'ModifyDate', 321 => 'ModDate', 323 => 'tIME', 386 => 'ModDate', 392 => 0x2, 519 => 'ModifyDate' },
	'moirefilter' => { 119 => 0xfe58, 494 => 'MoireFilter', 496 => 'MoireFilter' },
	'monitorbrightness' => { 238 => 0x59a, 239 => 0x5ca },
	'monitordisplayoff' => { 184 => 0x4c },
	'monitormatrix' => { 138 => 0x8fc },
	'monitorofftime' => { 294 => '18.2', 296 => '3.1', 305 => '3.1' },
	'monochromecolor' => { 312 => 0x53b },
	'monochromecontrast' => { 109 => 0x3c },
	'monochromefiltereffect' => { 103 => 0x20307, 109 => 0x3a, 335 => 0xac, 370 => 0x73 },
	'monochromegraineffect' => { 335 => 0xd2 },
	'monochromelinear' => { 109 => 0x3d },
	'monochromeoutputhighlightpoint' => { 109 => 0x41 },
	'monochromeoutputshadowpoint' => { 109 => 0x42 },
	'monochromeprofilesettings' => { 312 => 0x537 },
	'monochromerawhighlight' => { 109 => 0x7a },
	'monochromerawhighlightpoint' => { 109 => 0x3f },
	'monochromerawshadow' => { 109 => 0x83 },
	'monochromerawshadowpoint' => { 109 => 0x40 },
	'monochromesharpness' => { 109 => 0x3e },
	'monochrometoning' => { 370 => 0x74 },
	'monochrometoningeffect' => { 103 => 0x20306, 109 => 0x3b },
	'monochromeunsharpmaskfineness' => { 109 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 109 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 109 => 0xb4 },
	'monochromevignetting' => { 312 => 0x53a },
	'monthdaycreated' => { 140 => 0x12, 149 => 0xe },
	'mood' => { 179 => 'WM/Mood' },
	'moonphase' => { 396 => 0x12, 397 => 0x43, 398 => 0x4c },
	'morepermissions' => { 492 => 'morePermissions' },
	'motionphotovideo' => { 390 => 'mpvd' },
	'motionsensitivity' => { 396 => 0x29, 398 => 0x60 },
	'movementcount' => { 387 => "\xa9mvc" },
	'movementname' => { 387 => "\xa9mvn" },
	'movementnumber' => { 387 => "\xa9mvi" },
	'movieactived-lighting' => { 237 => 0x238, 238 => 0x2b8, 239 => 0x2e0 },
	'movieaelockbuttonassignment' => { 307 => '40.1' },
	'movieaf-onbutton' => { 310 => 0xcb },
	'movieafareamode' => { 238 => 0x2c6, 239 => 0x2ee, 310 => 0x203 },
	'movieafspeed' => { 310 => 0xdd },
	'movieafspeedapply' => { 310 => 0xdf },
	'movieaftrackingsensitivity' => { 310 => 0xe1 },
	'movieaperturelock' => { 310 => 0x259 },
	'movieautodistortioncontrol' => { 237 => 0x242 },
	'moviediffractioncompensation' => { 237 => 0x241 },
	'moviedxcropalert' => { 238 => 0x2fb, 239 => 0x323 },
	'movieelectronicvr' => { 238 => 0x2cc, 239 => 0x2f4 },
	'movieevfgrid' => { 310 => 0x21d },
	'movieflickerreduction' => { 238 => 0x2c0, 239 => 0x2e8 },
	'moviefocusmode' => { 237 => 0x248, 238 => 0x2c4, 239 => 0x2ec },
	'moviefocuspointlock' => { 310 => 0x226 },
	'movieframerate' => { 237 => 0x1f8, 238 => 0x2f4, 239 => 0x31c },
	'movieframesize' => { 237 => 0x1f6, 238 => 0x2f2, 239 => 0x31a },
	'moviefunc1button' => { 297 => '41.1', 298 => '41.1', 308 => '41.1', 310 => 0xc3 },
	'moviefunc2button' => { 310 => 0xc7 },
	'moviefunc3button' => { 310 => 0x127 },
	'moviefunctionbutton' => { 295 => '41.1', 307 => '41.1' },
	'moviefunctionbuttonplusdials' => { 295 => '52.1' },
	'moviehighisonoisereduction' => { 237 => 0x23c, 238 => 0x2ba, 239 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 310 => 0x215 },
	'moviehighreszoom' => { 239 => 0x32c },
	'movieimagearea' => { 238 => 0x25c, 239 => 0x286 },
	'movieisoautocontrolmanualmode' => { 238 => 0x26a, 239 => 0x294 },
	'movieisoautohilimit' => { 238 => 0x268, 239 => 0x292 },
	'movieisoautomanualmode' => { 237 => 0x204, 238 => 0x26c, 239 => 0x296 },
	'movielenscontrolring' => { 310 => 0xd7 },
	'moviemeteringmode' => { 238 => 0x2c2, 239 => 0x2ea },
	'moviemidtonedisplayrange' => { 310 => 0x219 },
	'moviemidtonedisplayvalue' => { 310 => 0x217 },
	'moviemultiselector' => { 310 => 0xd9 },
	'moviepreviewbutton' => { 295 => '41.2', 297 => '41.2', 298 => '41.2', 307 => '41.2', 308 => '41.2' },
	'moviepreviewbuttonplusdials' => { 295 => '52.2' },
	'movierecordbuttonplaybackmode' => { 310 => 0x1b5 },
	'movieshutterbutton' => { 295 => '38.3', 297 => '38.3', 298 => '38.3', 307 => '38.3', 308 => '38.3' },
	'movieshutterspeedlock' => { 310 => 0x225 },
	'movieslowmotion' => { 237 => 0x1fa },
	'moviesoundrecording' => { 238 => 0x2ce, 239 => 0x2f6 },
	'moviesubjectdetection' => { 238 => 0x2fc, 239 => 0x324 },
	'moviesubselectorassignment' => { 295 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 295 => '53.1' },
	'movietonemap' => { 238 => 0x2ec, 239 => 0x314 },
	'movietype' => { 222 => 0x2ca, 237 => 0x1fe, 238 => 0x266, 239 => 0x290 },
	'movievibrationreduction' => { 237 => 0x24e },
	'movievibrationreductionsameasphoto' => { 237 => 0x24f },
	'movievignettecontrol' => { 237 => 0x23e, 238 => 0x1a0, 239 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 237 => 0x240 },
	'movievrmode' => { 238 => 0x2c8, 239 => 0x2f0 },
	'moviezebrapattern' => { 310 => 0x213 },
	'multiburstimageheight' => { 435 => 0x1002 },
	'multiburstimagewidth' => { 435 => 0x1001 },
	'multiburstmode' => { 435 => 0x1000 },
	'multicontrollerwhilemetering' => { 84 => 0x517 },
	'multiexposure' => { 68 => 0x1, 335 => 0xb4 },
	'multiexposureautogain' => { 241 => 0x3 },
	'multiexposurecontrol' => { 68 => 0x2 },
	'multiexposuremode' => { 241 => 0x1, 242 => 0x1 },
	'multiexposureoverlaymode' => { 242 => 0x3 },
	'multiexposureshots' => { 68 => 0x3, 238 => 0x8e, 239 => 0x9c, 241 => 0x2, 242 => 0x2 },
	'multiframenoisereduction' => { 424 => 0x35, 435 => 0x200b, 440 => 0x15 },
	'multiframenreffect' => { 435 => 0x2023 },
	'multifunctionlock' => { 84 => 0x70f },
	'multipleexposuremode' => { 238 => 0x8c, 239 => 0x9a, 316 => 0x101c },
	'multipleexposureset' => { 351 => '10.1' },
	'multisample' => { 254 => 0x40 },
	'multiselector' => { 294 => '9.4', 295 => '10.3', 297 => '10.3', 298 => '10.3', 303 => '27.4', 307 => '10.3', 308 => '10.3' },
	'multiselectorliveview' => { 294 => '4.3', 297 => '37.1', 298 => '37.1', 307 => '37.1', 308 => '37.1' },
	'multiselectorliveviewmode' => { 268 => 0x18c2 },
	'multiselectorplaybackmode' => { 294 => ['13.5','9.2'], 295 => '10.2', 298 => '10.2', 303 => '27.2', 307 => '10.2', 308 => '10.2', 310 => 0xb3 },
	'multiselectorshootmode' => { 294 => '9.1', 295 => '10.1', 297 => '10.1', 298 => '10.1', 303 => '27.1', 307 => '10.1', 308 => '10.1', 310 => 0xaf },
	'multishot' => { 340 => 0x121 },
	'mute' => { 389 => 'player.movie.audio.mute' },
	'mycolormode' => { 69 => 0x2 },
	'name' => { 395 => 'name', 494 => 'Name', 496 => 'Name' },
	'narrator' => { 387 => "\xa9nrt" },
	'nationalcatalognumber' => { 511 => 'nationalCatalogNumber' },
	'nativedigest' => { 500 => 'NativeDigest', 517 => 'NativeDigest' },
	'ndfilter' => { 77 => 0x1c, 312 => 0x204, 402 => 0x1019 },
	'near' => { 479 => 'Near' },
	'nefbitdepth' => { 233 => 0xe22 },
	'nefcompression' => { 233 => 0x93, 234 => 0xa },
	'neflinearizationtable' => { 233 => 0x96 },
	'negativecachelargepreviewsize' => { 494 => 'NegativeCacheLargePreviewSize', 496 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 494 => 'NegativeCacheMaximumSize', 496 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 494 => 'NegativeCachePath', 496 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 491 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 370 => 0x88 },
	'neutraloutputhighlightpoint' => { 109 => 0x2f },
	'neutraloutputshadowpoint' => { 109 => 0x30 },
	'neutralrawcolortone' => { 109 => 0x28 },
	'neutralrawcontrast' => { 109 => 0x2a },
	'neutralrawhighlight' => { 109 => 0x78 },
	'neutralrawhighlightpoint' => { 109 => 0x2d },
	'neutralrawlinear' => { 109 => 0x2b },
	'neutralrawsaturation' => { 109 => 0x29 },
	'neutralrawshadow' => { 109 => 0x81 },
	'neutralrawshadowpoint' => { 109 => 0x2e },
	'neutralrawsharpness' => { 109 => 0x2c },
	'neutralunsharpmaskfineness' => { 109 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 109 => 0xa8 },
	'neutraunsharpmaskstrength' => { 109 => 0xa4 },
	'newlensdata' => { 231 => 0x2f },
	'newrawimagedigest' => { 119 => 0xc7a7 },
	'newsphotoversion' => { 133 => 0x0 },
	'nickname' => { 519 => 'Nickname' },
	'nikoncapturedata' => { 233 => 0xe01 },
	'nikoncaptureeditversions' => { 233 => 0xe13 },
	'nikoncaptureoffsets' => { 233 => 0xe0e },
	'nikoncaptureoutput' => { 233 => 0xe1e },
	'nikoncaptureversion' => { 233 => 0xe09 },
	'nikoniccprofile' => { 233 => 0xe1d },
	'nikonimagesize' => { 265 => '723.1', 266 => '732.1', 274 => 0x2c4 },
	'nikonmeteringmode' => { 198 => 0x17, 237 => 0x146, 245 => 0x214 },
	'nikonsettings' => { 233 => 0x4e },
	'noisefilter' => { 312 => 0x527 },
	'noiseprofile' => { 119 => 0xc761 },
	'noisereduction' => { 127 => [0x100b,0x100e], 182 => 0xb0, 183 => 0x60, 184 => 0x3f, 233 => 0x95, 287 => 0x753dcbc0, 288 => 0x17, 312 => 0x50a, 317 => 0x103a, 335 => 0x2d, 370 => 0x49, 402 => 0x100f, 404 => 0x2a },
	'noisereduction2' => { 316 => 0x1010 },
	'noisereductionapplied' => { 119 => 0xc6f7 },
	'noisereductionintensity' => { 288 => 0x9 },
	'noisereductionmethod' => { 288 => 0x11 },
	'noisereductionmode' => { 470 => 0x801e },
	'noisereductionparametersatcapture' => { 138 => 0xe73 },
	'noisereductionparameterscamera' => { 138 => 0xe72 },
	'noisereductionparametershost3mp' => { 138 => 0xe71 },
	'noisereductionparametershost6mp' => { 138 => 0xe70 },
	'noisereductionparametershostrgb' => { 138 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 138 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 138 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 138 => 0xe63 },
	'noisereductionparams' => { 340 => 0x1b },
	'noisereductionsharpness' => { 288 => 0xd },
	'noisereductionstrength' => { 335 => 0xd6 },
	'noisereductionvalue' => { 470 => 0x8027 },
	'nomemorycard' => { 294 => '22.1', 295 => '4.2', 296 => '0.3', 299 => '2.4', 300 => '3.2', 301 => '3.2', 303 => '33.7', 304 => '3.2', 305 => '0.3', 307 => '4.2', 309 => '4.5' },
	'nominalmaxaperture' => { 361 => 0xa },
	'nominalminaperture' => { 361 => '10.1' },
	'normallinetime' => { 138 => 0x186a },
	'normalwhitelevel' => { 41 => 0x32a, 42 => 0x280, 45 => [0x2b8,0x2cf,0x2d3], 46 => 0x569, 47 => 0x1e3, 48 => [0x1fc,0x2dc], 49 => [0x230,0x30e], 50 => 0x31c },
	'notes' => { 471 => 'Notes', 489 => 'notes' },
	'npages' => { 526 => 'NPages' },
	'nullrecord' => { 97 => 0x0 },
	'numafpoints' => { 347 => 0x2 },
	'number' => { 511 => 'number' },
	'numberofbeats' => { 521 => 'numberOfBeats' },
	'numberoffocuspoints' => { 297 => '1.3', 298 => '1.3', 301 => '0.2', 302 => '0.3', 304 => '0.3' },
	'numfaceelements' => { 127 => 0x4200 },
	'numfacepositions' => { 327 => 0x0 },
	'numindexentries' => { 133 => 0x54 },
	'numwbentries' => { 341 => 0x0, 342 => 0x0 },
	'object' => { 511 => 'object' },
	'objectattributereference' => { 131 => 0x4 },
	'objectcycle' => { 131 => 0x4b, 489 => 'ObjectCycle' },
	'objectdescription' => { 510 => 'objectDescription' },
	'objectdistance' => { 112 => 0x6, 113 => 0x2022 },
	'objectname' => { 131 => 0x5 },
	'objectpreviewdata' => { 131 => 0xca },
	'objectpreviewfileformat' => { 131 => 0xc8 },
	'objectpreviewfileversion' => { 131 => 0xc9 },
	'objectsubtype' => { 510 => 'objectSubtype' },
	'objecttype' => { 510 => 'objectType' },
	'objecttypereference' => { 131 => 0x3 },
	'occurrence' => { 118 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 118 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 118 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 118 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 118 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 118 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 118 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 118 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 118 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 118 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 118 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 118 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 118 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 118 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 118 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 118 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 118 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 118 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 118 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 118 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 118 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 118 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 118 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 118 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 118 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 118 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 118 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 118 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 118 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 118 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 500 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 500 => [\'OECF','OECFNames'] },
	'oecfrows' => { 500 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 500 => [\'OECF','OECFValues'] },
	'offsaledate' => { 511 => 'offSaleDate' },
	'offsaledatea-platform' => { 511 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 511 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 138 => 0x190a },
	'offsetschema' => { 119 => 0xea1d },
	'offsettime' => { 119 => 0x9010 },
	'offsettimedigitized' => { 119 => 0x9012 },
	'offsettimeoriginal' => { 119 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 304 => '15.1', 309 => '16.1' },
	'oldsubfiletype' => { 119 => 0xff },
	'olympusimageheight' => { 317 => 0x102f },
	'olympusimagewidth' => { 317 => 0x102e },
	'omenatcapturestrength' => { 138 => 0xa60 },
	'omenautostrength' => { 138 => 0xa5f },
	'omenearlystrength' => { 138 => 0xa5e },
	'omenfocallengthlimit' => { 138 => 0xa62 },
	'omeninitialipfstrength' => { 138 => 0xa5d },
	'omensurfaceindex' => { 138 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 317 => 0x302 },
	'onsaledate' => { 511 => 'onSaleDate' },
	'onsaledatea-platform' => { 511 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 511 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 511 => 'onSaleDay' },
	'onsaledaya-platform' => { 511 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 511 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 119 => 0xc740 },
	'opcodelist2' => { 119 => 0xc741 },
	'opcodelist3' => { 119 => 0xc74e },
	'opticalzoom' => { 142 => 0xfa3d, 144 => [0x6006,0xf006], 145 => 0x1000, 146 => 0xf, 149 => 0x1e, 151 => 0x20, 152 => 0x1c, 163 => 'OpticalZoom' },
	'opticalzoomcode' => { 77 => 0xa },
	'opticalzoommode' => { 335 => 0x34 },
	'opticalzoomon' => { 411 => 0x219 },
	'optionenddate' => { 514 => 'optionEndDate' },
	'opto-electricconvfactor' => { 500 => 'OECF' },
	'orangehsl' => { 103 => 0x20911 },
	'ordernumber' => { 127 => 0x8002 },
	'organisationinimagecode' => { 507 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 507 => 'OrganisationInImageName' },
	'organism' => { 118 => 'Organism' },
	'organismassociatedoccurrences' => { 118 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 118 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 118 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 118 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 118 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 118 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 118 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 511 => 'organization' },
	'orientation' => { 119 => 0x112, 340 => 0x112, 510 => 'orientation', 517 => 'Orientation' },
	'orientation2' => { 440 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 84 => 0x516 },
	'originalalbumtitle' => { 179 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 179 => 'WM/OriginalArtist', 387 => "\xa9ope" },
	'originalbestqualitysize' => { 119 => 0xc792 },
	'originalcreatedatetime' => { 484 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 114 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 64 => 0x83 },
	'originaldefaultcropsize' => { 119 => 0xc793 },
	'originaldefaultfinalsize' => { 119 => 0xc791 },
	'originaldirectory' => { 332 => 0x408 },
	'originaldocumentid' => { 522 => 'OriginalDocumentID' },
	'originalfilename' => { 97 => 0x816, 138 => 0x3e9, 150 => 0x20, 332 => 0x407, 484 => 'OriginalFilename' },
	'originalimageheight' => { 79 => 0xc, 123 => 0x1 },
	'originalimagemd5' => { 474 => 'OriginalImageMD5' },
	'originalimagesize' => { 162 => 'OriginalImageSize' },
	'originalimagewidth' => { 79 => 0xb, 123 => 0x0 },
	'originallyricist' => { 179 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 119 => 0xc68c },
	'originalrawfiledigest' => { 119 => 0xc71d },
	'originalrawfilename' => { 119 => 0xc68b },
	'originaltransmissionreference' => { 131 => 0x67 },
	'originatingprogram' => { 131 => 0x41, 489 => 'OriginatingProgram' },
	'originplatform' => { 511 => 'originPlatform' },
	'os' => { 498 => 'os' },
	'otherconditions' => { 322 => 'OtherConditions' },
	'otherconstraints' => { 322 => 'OtherConstraints' },
	'otherimage' => { 114 => 'Exif-OtherImage' },
	'otherimageinfo' => { 322 => 'OtherImageInfo' },
	'otherimagelength' => { 119 => 0x202 },
	'otherimagestart' => { 119 => 0x201 },
	'otherlicensedocuments' => { 322 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 322 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 322 => 'OtherLicenseRequirements' },
	'outcue' => { 521 => 'outCue' },
	'outcuescale' => { 521 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 521 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 199 => 0x3 },
	'outputimagewidth' => { 199 => 0x2 },
	'outputlut' => { 335 => 0xa7 },
	'outputprofile' => { 138 => 0x138b },
	'outputresolution' => { 199 => 0x4 },
	'overclockcols' => { 138 => 0x189c },
	'overclockrows' => { 138 => 0x18c4 },
	'overridelookvignette' => { 494 => 'OverrideLookVignette', 496 => 'OverrideLookVignette' },
	'owner' => { 525 => 'Owner' },
	'ownerid' => { 131 => 0xbc },
	'ownername' => { 15 => 0x10f, 64 => 0x9, 97 => 0x810, 119 => [0xa430,0xfde8], 156 => 'OwnerName', 491 => 'OwnerName', 501 => 'CameraOwnerName' },
	'padding' => { 119 => 0xea1c },
	'pagecount' => { 511 => 'pageCount' },
	'pageimage' => { 519 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 519 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 519 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 519 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 519 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 519 => 'PageInfo' },
	'pagename' => { 119 => 0x11d },
	'pagenumber' => { 119 => 0x129 },
	'pageprogressiondirection' => { 511 => 'pageProgressionDirection' },
	'pagerange' => { 511 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 494 => 'PaintBasedCorrections', 496 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 494 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 496 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 338 => 0x0 },
	'panasonicexifversion' => { 335 => 0x26 },
	'panasonicimageheight' => { 335 => 0x4c },
	'panasonicimagewidth' => { 335 => 0x4b },
	'panasonicrawversion' => { 340 => 0x1 },
	'panasonictitle' => { 119 => 0xc6d2 },
	'panasonictitle2' => { 119 => 0xc6d3 },
	'panoramaangle' => { 127 => 0x1153 },
	'panoramacropbottom' => { 441 => 0x7 },
	'panoramacropleft' => { 441 => 0x4 },
	'panoramacropright' => { 441 => 0x6 },
	'panoramacroptop' => { 441 => 0x5 },
	'panoramadirection' => { 72 => 0x5, 127 => 0x1154, 441 => 0x3 },
	'panoramaframeheight' => { 441 => 0x9 },
	'panoramaframenumber' => { 72 => 0x2 },
	'panoramaframewidth' => { 441 => 0x8 },
	'panoramafullheight' => { 441 => 0x2 },
	'panoramafullwidth' => { 441 => 0x1 },
	'panoramamode' => { 140 => 0x3c, 312 => 0x601 },
	'panoramasize3d' => { 424 => 0x38 },
	'panoramasourceheight' => { 441 => 0xb },
	'panoramasourcewidth' => { 441 => 0xa },
	'panoramicstitchcameramotion' => { 176 => 'PanoramicStitchCameraMotion', 177 => 0x1 },
	'panoramicstitchmaptype' => { 176 => 'PanoramicStitchMapType', 177 => 0x2 },
	'panoramicstitchphi0' => { 176 => 'PanoramicStitchPhi0', 177 => 0x5 },
	'panoramicstitchphi1' => { 176 => 'PanoramicStitchPhi1', 177 => 0x6 },
	'panoramicstitchtheta0' => { 176 => 'PanoramicStitchTheta0', 177 => 0x3 },
	'panoramicstitchtheta1' => { 176 => 'PanoramicStitchTheta1', 177 => 0x4 },
	'panoramicstitchversion' => { 177 => 0x0 },
	'pantry' => { 522 => 'Pantry' },
	'pantryinstanceid' => { 522 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 127 => 0xb211, 311 => 0x28 },
	'parametricdarks' => { 494 => 'ParametricDarks', 496 => 'ParametricDarks' },
	'parametrichighlights' => { 494 => 'ParametricHighlights', 496 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 494 => 'ParametricHighlightSplit', 496 => 'ParametricHighlightSplit' },
	'parametriclights' => { 494 => 'ParametricLights', 496 => 'ParametricLights' },
	'parametricmidtonesplit' => { 494 => 'ParametricMidtoneSplit', 496 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 494 => 'ParametricShadows', 496 => 'ParametricShadows' },
	'parametricshadowsplit' => { 494 => 'ParametricShadowSplit', 496 => 'ParametricShadowSplit' },
	'parentalrating' => { 179 => 'WM/ParentalRating' },
	'parentid' => { 507 => 'parentId' },
	'parentmediaeventid' => { 484 => 'ParentMediaEventID' },
	'parentmeid' => { 484 => 'ParentMEID' },
	'parentproductid' => { 387 => '@ppi' },
	'parentreference1' => { 505 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 505 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 505 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 505 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 505 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 505 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 387 => '@PST' },
	'parenttitle' => { 387 => '@pti' },
	'partialactivecols1' => { 138 => 0x17e8 },
	'partialactivecols2' => { 138 => 0x17f2 },
	'partialactiverows1' => { 138 => 0x17fc },
	'partialactiverows2' => { 138 => 0x1806 },
	'partofcompilation' => { 521 => 'partOfCompilation' },
	'patientbirthdate' => { 472 => 'PatientDOB' },
	'patientid' => { 472 => 'PatientID' },
	'patientname' => { 472 => 'PatientName' },
	'patientsex' => { 472 => 'PatientSex' },
	'patternareaheight' => { 138 => 0x963 },
	'patternareawidth' => { 138 => 0x962 },
	'patterncorrectionfactorscale' => { 138 => 0x969 },
	'patterncropcols1' => { 138 => 0x96c },
	'patterncropcols2' => { 138 => 0x96d },
	'patterncroprows1' => { 138 => 0x96a },
	'patterncroprows2' => { 138 => 0x96b },
	'patternimagerheight' => { 138 => 0x961 },
	'patternimagerwidth' => { 138 => 0x960 },
	'patternx' => { 138 => 0x966 },
	'patterny' => { 138 => 0x967 },
	'pdfversion' => { 508 => 'PDFVersion' },
	'pentaximagesize' => { 370 => 0x9 },
	'pentaxmodelid' => { 350 => 0x0, 370 => 0x5 },
	'pentaxmodeltype' => { 370 => 0x1 },
	'pentaxversion' => { 370 => 0x0 },
	'people' => { 475 => 'People', 487 => 'People' },
	'perchannelblacklevel' => { 41 => 0x157, 42 => 0x16b, 44 => 0xc4, 45 => [0x2b4,0x2cb,0x2cf], 46 => [0x108,0x14d], 47 => 0x1df, 48 => [0x1f8,0x2d8], 49 => [0x22c,0x30a], 50 => 0x149 },
	'performer' => { 387 => 'perf', 395 => 'perf' },
	'performerkeywords' => { 395 => "\xa9prk" },
	'performers' => { 395 => "\xa9prf" },
	'performerurl' => { 395 => "\xa9prl" },
	'period' => { 179 => 'WM/Period' },
	'peripheralillumcentralradius' => { 470 => 0x8030 },
	'peripheralillumcentralvalue' => { 470 => 0x8031 },
	'peripheralillumination' => { 103 => 0x20702, 109 => 0x68 },
	'peripheralilluminationcorr' => { 62 => 0x1, 360 => 0x2 },
	'peripheralilluminationon' => { 103 => '0x20702.0', 109 => 0x64 },
	'peripheralillumperiphvalue' => { 470 => 0x8032 },
	'peripherallighting' => { 79 => 0x2, 127 => 0x3804 },
	'peripherallightingsetting' => { 80 => 0x5 },
	'peripherallightingvalue' => { 79 => 0x6 },
	'permissions' => { 514 => 'permissions' },
	'permits' => { 492 => 'permits' },
	'person' => { 511 => 'person' },
	'personality' => { 484 => 'Personality' },
	'personheard' => { 507 => 'PersonHeard' },
	'personheardidentifier' => { 507 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 507 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 507 => 'PersonInImage' },
	'personinimagecharacteristic' => { 507 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 507 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 507 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 507 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 507 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 507 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 507 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 507 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 507 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 494 => 'PerspectiveAspect', 496 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 494 => 'PerspectiveHorizontal', 496 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 494 => 'PerspectiveRotate', 496 => 'PerspectiveRotate' },
	'perspectivescale' => { 494 => 'PerspectiveScale', 496 => 'PerspectiveScale' },
	'perspectiveupright' => { 494 => 'PerspectiveUpright', 496 => 'PerspectiveUpright' },
	'perspectivevertical' => { 494 => 'PerspectiveVertical', 496 => 'PerspectiveVertical' },
	'perspectivex' => { 494 => 'PerspectiveX', 496 => 'PerspectiveX' },
	'perspectivey' => { 494 => 'PerspectiveY', 496 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 92 => 0x1 },
	'pf10retainprogramshift' => { 92 => 0xb },
	'pf13drivepriority' => { 92 => 0xe },
	'pf14disablefocussearch' => { 92 => 0xf },
	'pf15disableafassistbeam' => { 92 => 0x10 },
	'pf16autofocuspointshoot' => { 92 => 0x11 },
	'pf17disableafpointsel' => { 92 => 0x12 },
	'pf18enableautoafpointsel' => { 92 => 0x13 },
	'pf19continuousshootspeed' => { 92 => 0x14 },
	'pf19shootingspeedhigh' => { 91 => 0xa },
	'pf19shootingspeedlow' => { 91 => 0x9 },
	'pf1disableshootingmodes' => { 92 => 0x2 },
	'pf1value' => { 91 => 0x1 },
	'pf20limitcontinousshots' => { 92 => 0x15 },
	'pf20maxcontinousshots' => { 91 => 0xb },
	'pf21enablequietoperation' => { 92 => 0x16 },
	'pf23felocktime' => { 91 => 0xd },
	'pf23postreleasetime' => { 91 => 0xe },
	'pf23settimerlengths' => { 92 => 0x18 },
	'pf23shutterbuttontime' => { 91 => 0xc },
	'pf24lightlcdduringbulb' => { 92 => 0x19 },
	'pf25aemode' => { 91 => 0xf },
	'pf25afmode' => { 91 => 0x12 },
	'pf25afpointsel' => { 91 => 0x13 },
	'pf25colormatrix' => { 91 => 0x17 },
	'pf25defaultclearsettings' => { 92 => 0x1a },
	'pf25drivemode' => { 91 => 0x11 },
	'pf25imagesize' => { 91 => 0x14 },
	'pf25meteringmode' => { 91 => 0x10 },
	'pf25parameters' => { 91 => 0x16 },
	'pf25wbmode' => { 91 => 0x15 },
	'pf26shortenreleaselag' => { 92 => 0x1b },
	'pf27reversedialrotation' => { 92 => 0x1c },
	'pf27value' => { 91 => 0x18 },
	'pf28noquickdialexpcomp' => { 92 => 0x1d },
	'pf29quickdialswitchoff' => { 92 => 0x1e },
	'pf2disablemeteringmodes' => { 92 => 0x3 },
	'pf2value' => { 91 => 0x2 },
	'pf30enlargementmode' => { 92 => 0x1f },
	'pf31originaldecisiondata' => { 92 => 0x20 },
	'pf3manualexposuremetering' => { 92 => 0x4 },
	'pf3value' => { 91 => 0x3 },
	'pf4exposuretimelimits' => { 92 => 0x5 },
	'pf4exposuretimemax' => { 91 => 0x5 },
	'pf4exposuretimemin' => { 91 => 0x4 },
	'pf5aperturelimits' => { 92 => 0x6 },
	'pf5aperturemax' => { 91 => 0x7 },
	'pf5aperturemin' => { 91 => 0x6 },
	'pf6presetshootingmodes' => { 92 => 0x7 },
	'pf7bracketcontinuousshoot' => { 92 => 0x8 },
	'pf8bracketshots' => { 91 => 0x8 },
	'pf8setbracketshots' => { 92 => 0x9 },
	'pf9changebracketsequence' => { 92 => 0xa },
	'phasedetectaf' => { 193 => 0x6 },
	'phonenumber' => { 157 => 'Phone' },
	'photoeffect' => { 34 => 0x28 },
	'photoeffecthistoryxml' => { 287 => 0xe9651831 },
	'photoeffects' => { 287 => 0xab5eca5e },
	'photoeffectsblue' => { 289 => 0x8 },
	'photoeffectsgreen' => { 289 => 0x6 },
	'photoeffectsred' => { 289 => 0x4 },
	'photoeffectstype' => { 289 => 0x0 },
	'photographicsensitivity' => { 501 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 294 => '17.6', 303 => '33.6' },
	'photometricinterpretation' => { 119 => 0x106, 517 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 238 => 0x112, 239 => 0x122, 240 => 0x24, 258 => 0x0 },
	'photoshootingmenubankimagearea' => { 236 => 0x6dd, 238 => 0x134, 239 => 0x148, 258 => '7.1' },
	'photoshopbgrthumbnail' => { 384 => 0x409 },
	'photoshopquality' => { 383 => 0x0 },
	'photoshopthumbnail' => { 384 => 0x40c },
	'photostyle' => { 335 => 0x89 },
	'picasawebgphotoid' => { 499 => 'picasawebGPhotoId' },
	'picklabel' => { 499 => 'PickLabel' },
	'pictinfo' => { 411 => 0x208 },
	'picturecontrol' => { 287 => 0xe2173c47 },
	'picturecontrolactive' => { 290 => 0x0 },
	'picturecontroladjust' => { 246 => 0x30, 247 => 0x30, 248 => 0x36 },
	'picturecontrolbase' => { 246 => 0x18, 247 => 0x18, 248 => 0x1c },
	'picturecontroldata' => { 233 => [0xbd,0x23] },
	'picturecontrolmode' => { 290 => 0x13 },
	'picturecontrolname' => { 246 => 0x4, 247 => 0x4, 248 => 0x8 },
	'picturecontrolquickadjust' => { 246 => 0x31, 247 => 0x31, 248 => 0x37 },
	'pictureeffect' => { 435 => 0x200e },
	'pictureeffect2' => { 444 => 0x1163, 445 => 0x1167, 446 => 0x1143, 447 => 0x11bf, 448 => 0x119b, 449 => 0x1053, 450 => 0x24b, 451 => 0x24b, 452 => 0x23c, 466 => 0x46 },
	'picturefinish' => { 182 => 0x71 },
	'picturemode' => { 127 => 0x1031, 312 => 0x520, 370 => [0xb,0x33], 412 => 0x3d },
	'picturemode2' => { 351 => 0x0 },
	'picturemodebwfilter' => { 312 => 0x525 },
	'picturemodecontrast' => { 312 => 0x523 },
	'picturemodeeffect' => { 312 => 0x52d },
	'picturemodehue' => { 312 => 0x522 },
	'picturemodesaturation' => { 312 => 0x521 },
	'picturemodesharpness' => { 312 => 0x524 },
	'picturemodetone' => { 312 => 0x526 },
	'pictureprofile' => { 444 => [0x115e,0x115f], 445 => [0x1162,0x1163], 446 => [0x113e,0x113f], 447 => [0x11ba,0x11bb], 448 => [0x1196,0x1197], 449 => [0x104e,0x104f], 450 => [0x246,0x247], 451 => [0x246,0x247], 452 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 74 => 0xa, 103 => 0x20301, 109 => 0x2 },
	'picturestylepc' => { 64 => 0x4009 },
	'picturestyleuserdef' => { 64 => 0x4008 },
	'picturewizard' => { 409 => 0x21 },
	'picturewizardcolor' => { 408 => 0x1 },
	'picturewizardcontrast' => { 408 => 0x4 },
	'picturewizardmode' => { 408 => 0x0 },
	'picturewizardsaturation' => { 408 => 0x2 },
	'picturewizardsharpness' => { 408 => 0x3 },
	'pipelineversion' => { 176 => 'PipelineVersion' },
	'pitch' => { 115 => 0x6, 295 => '4.1', 307 => '4.1', 395 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 244 => 0x4, 312 => 0x904, 335 => 0x91, 369 => 0x2, 407 => 0x1 },
	'pitchshift' => { 389 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 388 => 'pasp' },
	'pixelclockfrequency' => { 138 => 0x40b },
	'pixelcorrectionoffset' => { 138 => 0x972 },
	'pixelcorrectionscale' => { 138 => 0x971 },
	'pixelscale' => { 119 => 0x830e },
	'pixelshiftinfo' => { 435 => 0x202f },
	'pixelshiftoffset' => { 127 => 0x1106 },
	'pixelshiftresolution' => { 371 => 0x0 },
	'pixelshiftshots' => { 127 => 0x1105 },
	'pixelsperunitx' => { 324 => 0x0 },
	'pixelsperunity' => { 324 => 0x4 },
	'pixelunits' => { 324 => 0x8 },
	'planarconfiguration' => { 119 => 0x11c, 517 => 'PlanarConfiguration' },
	'plane' => { 473 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 473 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 473 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 473 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 473 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 473 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 473 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 473 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 473 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 473 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 473 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 473 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 473 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 473 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 473 => 'Planes' },
	'planningref' => { 507 => 'PlanningRef' },
	'planningrefidentifier' => { 507 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 507 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 507 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 526 => 'PlateNames' },
	'platform' => { 511 => 'platform' },
	'playallframes' => { 395 => 'AllF' },
	'playbackflickdown' => { 310 => 0x159 },
	'playbackflickup' => { 310 => 0x155 },
	'playbackmenustime' => { 299 => '20.1', 300 => '21.1', 301 => '21.1' },
	'playbackmonitorofftime' => { 294 => '25.2', 295 => '36.1', 297 => '36.1', 298 => '36.1', 302 => '35.1', 303 => '8.1', 304 => '35.1', 307 => '36.1', 308 => '36.1', 309 => '21.1', 310 => 0x33 },
	'playbackzoom' => { 295 => '37.1' },
	'playdisplay' => { 184 => 0x4e },
	'playerversion' => { 389 => 'player.version' },
	'playgap' => { 387 => 'pgap' },
	'playlistid' => { 387 => 'plID' },
	'playmode' => { 395 => 'SDLN' },
	'playselection' => { 395 => 'SelO' },
	'plusversion' => { 322 => 'Version' },
	'pmversion' => { 382 => 'PMVersion' },
	'pngwarning' => { 325 => 'Warning' },
	'podcast' => { 387 => 'pcst' },
	'podcasturl' => { 387 => 'purl' },
	'poilevel' => { 232 => 0x8 },
	'portraitimpressionbalance' => { 249 => 0xa0 },
	'portraitnote' => { 477 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 109 => 0x1d },
	'portraitoutputshadowpoint' => { 109 => 0x1e },
	'portraitrawcolortone' => { 109 => 0x16 },
	'portraitrawcontrast' => { 109 => 0x18 },
	'portraitrawhighlight' => { 109 => 0x76 },
	'portraitrawhighlightpoint' => { 109 => 0x1b },
	'portraitrawlinear' => { 109 => 0x19 },
	'portraitrawsaturation' => { 109 => 0x17 },
	'portraitrawshadow' => { 109 => 0x7f },
	'portraitrawshadowpoint' => { 109 => 0x1c },
	'portraitrawsharpness' => { 109 => 0x1a },
	'portraitrefiner' => { 113 => 0x302b },
	'portraitrequest' => { 477 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 109 => 0x9a },
	'portraitunsharpmaskstrength' => { 109 => 0x98 },
	'portraitunsharpmaskthreshold' => { 109 => 0x9c },
	'portraitversion' => { 477 => 'PortraitVersion' },
	'pose' => { 473 => 'Pose' },
	'poseheadingdegrees' => { 482 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 482 => 'PosePitchDegrees' },
	'posepositionx' => { 473 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 473 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 473 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 482 => 'PoseRollDegrees' },
	'poserotationw' => { 473 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 473 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 473 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 473 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 473 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 510 => 'positionDescriptor' },
	'postalcode' => { 161 => 'PostalCode' },
	'postcropvignetteamount' => { 494 => 'PostCropVignetteAmount', 496 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 494 => 'PostCropVignetteFeather', 496 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 494 => 'PostCropVignetteHighlightContrast', 496 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 494 => 'PostCropVignetteMidpoint', 496 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 494 => 'PostCropVignetteRoundness', 496 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 494 => 'PostCropVignetteStyle', 496 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 335 => 0xbf },
	'postreleaseburstlength' => { 239 => 0x714 },
	'potentialface1position' => { 432 => 0xb },
	'potentialface2position' => { 432 => 0x15 },
	'potentialface3position' => { 432 => 0x1f },
	'potentialface4position' => { 432 => 0x29 },
	'potentialface5position' => { 432 => 0x33 },
	'potentialface6position' => { 432 => 0x3d },
	'potentialface7position' => { 432 => 0x47 },
	'potentialface8position' => { 432 => 0x51 },
	'powersource' => { 349 => '0.1' },
	'poweruptime' => { 233 => 0xb6 },
	'preaf' => { 126 => '0.2' },
	'precaptureframes' => { 317 => 0x300 },
	'predictor' => { 119 => 0x13d },
	'preflashreturnstrength' => { 266 => 0x28a },
	'prefs' => { 131 => 0xdd, 382 => 'Prefs' },
	'prereadfastresetcount' => { 138 => 0x187e },
	'prereleaseburstlength' => { 239 => 0x712 },
	'preservedfilename' => { 522 => 'PreservedFileName' },
	'preservedspecimen' => { 118 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 118 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 494 => 'PresetType', 496 => 'PresetType' },
	'presetwhitebalance' => { 184 => 0x24, 470 => 0x8002 },
	'presetwhitebalanceadj' => { 470 => 0x8014 },
	'pressure' => { 119 => 0x9402, 501 => 'Pressure' },
	'previewapplicationname' => { 119 => 0xc716 },
	'previewapplicationversion' => { 119 => 0xc717 },
	'previewbutton' => { 294 => ['14.1','15.1'], 295 => '15.1', 297 => '15.1', 298 => '15.1', 303 => '29.1', 304 => '14.1', 307 => '15.1', 308 => '15.1' },
	'previewbuttonplusdials' => { 294 => ['14.2','15.2'], 295 => '15.2', 297 => '43.1', 298 => '43.1', 303 => '31.2', 307 => '43.1', 308 => '43.1' },
	'previewcolorspace' => { 119 => 0xc71a },
	'previewcropbottom' => { 381 => 0xef },
	'previewcropleft' => { 381 => 0xec },
	'previewcropright' => { 381 => 0xee },
	'previewcroptop' => { 381 => 0xed },
	'previewdate' => { 393 => 0x0 },
	'previewdatetime' => { 119 => 0xc71b },
	'previewimage' => { 113 => 0x2000, 114 => 'Exif-PreviewImage', 120 => 'PreviewImage', 122 => 0x4, 166 => 'data', 186 => 0x81, 317 => 0x280, 333 => 0x300, 395 => 'mcvr', 435 => 0x2001 },
	'previewimageborders' => { 370 => 0x3e },
	'previewimageheight' => { 73 => 0x4, 142 => 0xfa58 },
	'previewimagelength' => { 73 => 0x2, 113 => 0x3, 119 => [0x117,0x202], 186 => 0x89, 250 => 0x202, 312 => 0x102, 317 => 0x1037, 370 => 0x3, 401 => 0x1e, 406 => 0x3, 412 => [0x1b,0x1d], 425 => 0x202 },
	'previewimagename' => { 166 => '1Name' },
	'previewimagesize' => { 113 => 0x2, 147 => 0x2, 166 => 'ImageSize', 370 => 0x2, 412 => [0x1c,0x1e], 435 => 0xb02c, 470 => 0x9012 },
	'previewimagestart' => { 73 => 0x5, 113 => 0x4, 119 => [0x111,0x201], 186 => 0x88, 250 => 0x201, 312 => 0x101, 317 => 0x1036, 370 => 0x4, 401 => 0x1c, 406 => 0x2, 412 => [0x1a,0x1c], 425 => 0x201 },
	'previewimagetype' => { 166 => '0Type' },
	'previewimagevalid' => { 312 => 0x100, 317 => 0x1035 },
	'previewimagewidth' => { 73 => 0x3, 142 => 0xfa57 },
	'previewquality' => { 73 => 0x1 },
	'previewsettingsdigest' => { 119 => 0xc719 },
	'previewsettingsname' => { 119 => 0xc718 },
	'primaryafpoint' => { 193 => [0x38,0x44,0x7,0x8] },
	'primarychromaticities' => { 119 => 0x13f, 517 => 'PrimaryChromaticities' },
	'primaryftp' => { 484 => 'PrimaryFTP' },
	'primaryslot' => { 240 => 0x25, 258 => 0x2 },
	'printim' => { 119 => 0xc4a5 },
	'prioritysetinawb' => { 435 => 0x202b },
	'prioritysetupshutterrelease' => { 184 => 0x1d, 422 => 0x28 },
	'privatertkinfo' => { 486 => 'privateRTKInfo' },
	'processbordercolsleft' => { 138 => 0xc61 },
	'processbordercolsright' => { 138 => 0xc62 },
	'processborderrowsbottom' => { 138 => 0xc64 },
	'processborderrowstop' => { 138 => 0xc63 },
	'processingsoftware' => { 119 => 0xb },
	'processversion' => { 494 => 'ProcessVersion', 496 => 'ProcessVersion' },
	'producer' => { 179 => 'WM/Producer', 321 => 'Producer', 387 => "\xa9prd", 389 => 'producer', 395 => "\xa9prd", 508 => 'Producer' },
	'producerkeywords' => { 395 => "\xa9pdk" },
	'productcode' => { 511 => 'productCode' },
	'productid' => { 132 => 0x32, 387 => 'prID', 510 => 'productID' },
	'productidtype' => { 510 => 'productIDType' },
	'productinimage' => { 507 => 'ProductInImage' },
	'productinimagedescription' => { 507 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 507 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 507 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 507 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 350 => 0x2 },
	'productorserviceconstraints' => { 322 => 'ProductOrServiceConstraints' },
	'productversion' => { 387 => 'VERS' },
	'profession' => { 511 => 'profession' },
	'profile' => { 473 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 119 => 0xc6f4 },
	'profilecameraindices' => { 473 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 119 => 0xc6fe },
	'profileembedpolicy' => { 119 => 0xc6fd },
	'profilegaintablemap' => { 119 => 0xcd2d },
	'profilehuesatmapdata1' => { 119 => 0xc6fa },
	'profilehuesatmapdata2' => { 119 => 0xc6fb },
	'profilehuesatmapdata3' => { 119 => 0xcd39 },
	'profilehuesatmapdims' => { 119 => 0xc6f9 },
	'profilehuesatmapencoding' => { 119 => 0xc7a3 },
	'profilelooktabledata' => { 119 => 0xc726 },
	'profilelooktabledims' => { 119 => 0xc725 },
	'profilelooktableencoding' => { 119 => 0xc7a4 },
	'profilename' => { 119 => 0xc6f8, 323 => 'iCCP-name' },
	'profiles' => { 473 => 'Profiles' },
	'profiletonecurve' => { 119 => 0xc6fc },
	'profiletype' => { 473 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 335 => 0x3c },
	'programline' => { 351 => '1.1' },
	'programmode' => { 189 => 0x5 },
	'programshift' => { 233 => 0xd },
	'programversion' => { 131 => 0x46 },
	'prohibits' => { 492 => 'prohibits' },
	'projectiontype' => { 482 => 'ProjectionType', 483 => 'ProjectionType' },
	'projectname' => { 521 => 'projectName' },
	'projectref' => { 521 => 'projectRef' },
	'projectrefpath' => { 521 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 521 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 179 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 322 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 322 => 'PropertyReleaseStatus' },
	'provider' => { 179 => 'WM/Provider' },
	'province-state' => { 131 => 0x5f },
	'publicationdate' => { 511 => 'publicationDate' },
	'publicationdatea-platform' => { 511 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 511 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 511 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 511 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 511 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 507 => 'PublicationEvent' },
	'publicationeventdate' => { 507 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 507 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 507 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 511 => 'publicationName' },
	'publisher' => { 179 => 'WM/Publisher', 387 => "\xa9pub", 389 => 'publisher', 497 => 'publisher' },
	'publishingfrequency' => { 511 => 'publishingFrequency' },
	'pulldown' => { 521 => 'pullDown' },
	'purchasedate' => { 387 => 'purd' },
	'purplehsl' => { 103 => 0x20916 },
	'pxshiftperiphedgenr' => { 470 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 470 => 0x9014 },
	'quality' => { 0 => 0x1, 34 => 0x3, 112 => 0x2, 113 => 0x3002, 127 => 0x1000, 140 => 0x9, 233 => 0x4, 277 => 0x3, 317 => 0x201, 330 => 0x300, 370 => 0x8, 377 => 0x2, 412 => 0x16, 422 => 0x56, 423 => 0x56, 424 => 0xb, 435 => [0x102,0x202e] },
	'quality2' => { 444 => 0x1170, 445 => 0x1174, 446 => 0x1150, 448 => 0x11a8, 449 => 0x1060, 450 => 0x258, 451 => 0x258, 452 => 0x247, 457 => 0x29, 458 => 0x25, 459 => 0x2a },
	'qualitybutton' => { 310 => 0x17d },
	'qualitybuttonplaybackmode' => { 310 => 0x1bf },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 113 => 0x8 },
	'quantizationmethod' => { 133 => 0x78 },
	'quickadjust' => { 290 => 0x2a },
	'quickcontroldialinmeter' => { 84 => 0x703 },
	'quickfix' => { 287 => 0x416391c6 },
	'quickshot' => { 411 => 0x213 },
	'quiettime' => { 138 => 0x188a },
	'rads' => { 395 => 'rads' },
	'rangefinder' => { 299 => '4.1', 300 => '5.1', 301 => '5.1' },
	'rangemask' => { 494 => 'RangeMaskMapInfo', 496 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 494 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 496 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 494 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 496 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 494 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 496 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 494 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 496 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 494 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 496 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 494 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 496 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 131 => 0x7d },
	'rating' => { 119 => 0x4746, 127 => 0x1431, 381 => 0xdf, 387 => 'rtng', 395 => 'rtng', 435 => 0x2002, 489 => 'rating', 498 => 'rating', 507 => 'Rating', 511 => 'rating', 519 => 'Rating' },
	'ratingpercent' => { 119 => 0x4749, 178 => 'Rating', 387 => 'rate', 519 => 'RatingPercent' },
	'ratingregion' => { 507 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 507 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 507 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 507 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 507 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 507 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 507 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 507 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 507 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 507 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 507 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 507 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 507 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 507 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 507 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 507 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 507 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 507 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 82 => 0x8, 186 => 0x109, 351 => 0xd },
	'rawbrightnessadj' => { 103 => 0x20001, 108 => 0x38 },
	'rawburstimagecount' => { 75 => 0x2 },
	'rawburstimagenum' => { 75 => 0x1 },
	'rawcoloradj' => { 108 => 0x2e },
	'rawcropbottom' => { 381 => 0xd4 },
	'rawcropleft' => { 381 => 0xd1 },
	'rawcropright' => { 381 => 0xd3 },
	'rawcroptop' => { 381 => 0xd2 },
	'rawcustomsaturation' => { 108 => 0x30 },
	'rawcustomtone' => { 108 => 0x34 },
	'rawdata' => { 409 => 0xa048 },
	'rawdatabyteorder' => { 409 => 0x40 },
	'rawdatacfapattern' => { 409 => 0x50 },
	'rawdatauniqueid' => { 119 => 0xc65d },
	'rawdepth' => { 188 => 0x10 },
	'rawdevartfilter' => { 319 => 0x121 },
	'rawdevautogradation' => { 319 => 0x119 },
	'rawdevcolorspace' => { 318 => 0x108, 319 => 0x109 },
	'rawdevcontrastvalue' => { 318 => 0x106, 319 => 0x105 },
	'rawdeveditstatus' => { 318 => 0x10b },
	'rawdevelopmentprocess' => { 370 => 0x62 },
	'rawdevengine' => { 318 => 0x109, 319 => 0x10b },
	'rawdevexposurebiasvalue' => { 318 => 0x100, 319 => 0x100 },
	'rawdevgradation' => { 319 => 0x112 },
	'rawdevgraypoint' => { 318 => 0x103, 319 => 0x104 },
	'rawdevmemorycoloremphasis' => { 318 => 0x105, 319 => 0x108 },
	'rawdevnoisereduction' => { 318 => 0x10a, 319 => 0x10a },
	'rawdevpicturemode' => { 319 => 0x10c },
	'rawdevpm_bwfilter' => { 319 => 0x110 },
	'rawdevpmcontrast' => { 319 => 0x10e },
	'rawdevpmnoisefilter' => { 319 => 0x120 },
	'rawdevpmpicturetone' => { 319 => 0x111 },
	'rawdevpmsaturation' => { 319 => 0x10d },
	'rawdevpmsharpness' => { 319 => 0x10f },
	'rawdevsaturation3' => { 319 => 0x113 },
	'rawdevsaturationemphasis' => { 318 => 0x104, 319 => 0x107 },
	'rawdevsettings' => { 318 => 0x10c },
	'rawdevsharpnessvalue' => { 318 => 0x107, 319 => 0x106 },
	'rawdevversion' => { 318 => 0x0, 319 => 0x0 },
	'rawdevwbfineadjustment' => { 318 => 0x102, 319 => 0x103 },
	'rawdevwhitebalance' => { 319 => 0x101 },
	'rawdevwhitebalancevalue' => { 318 => 0x101, 319 => 0x102 },
	'rawfile' => { 119 => 0xfe4c },
	'rawfilename' => { 494 => 'RawFileName', 496 => 'RawFileName' },
	'rawfiletype' => { 435 => 0x2029 },
	'rawformat' => { 340 => 0x2d, 379 => 0x10e },
	'rawimagecenter' => { 233 => 0x99 },
	'rawimagedigest' => { 119 => 0xc71c },
	'rawimagesize' => { 370 => 0x39 },
	'rawinfoversion' => { 320 => 0x0 },
	'rawjpgheight' => { 99 => 0x4 },
	'rawjpgquality' => { 57 => 0x6, 99 => 0x1 },
	'rawjpgsize' => { 57 => 0x7, 99 => 0x2 },
	'rawjpgwidth' => { 99 => 0x3 },
	'rawmeasuredrggb' => { 43 => 0x26a, 45 => 0x280, 47 => 0x194, 48 => [0x1ad,0x26b] },
	'rawrppused' => { 489 => 'rawrppused' },
	'rawtopreviewgain' => { 119 => 0xc7a8 },
	'readouttypeactual' => { 138 => 0x1903 },
	'readouttyperequested' => { 138 => 0x1902 },
	'reardisplay' => { 294 => '12.3', 295 => '6.2' },
	'recdevice' => { 507 => 'RecDevice' },
	'recdeviceattlensdescription' => { 507 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 507 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 507 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 507 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 507 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 513 => 'recipeEndingPage' },
	'recipepagerange' => { 513 => 'recipePageRange' },
	'recipesource' => { 513 => 'recipeSource' },
	'recipestartingpage' => { 513 => 'recipeStartingPage' },
	'recipetitle' => { 513 => 'recipeTitle' },
	'recognizedface1age' => { 328 => 0x20 },
	'recognizedface1name' => { 328 => 0x4 },
	'recognizedface1position' => { 328 => 0x18 },
	'recognizedface2age' => { 328 => 0x50 },
	'recognizedface2name' => { 328 => 0x34 },
	'recognizedface2position' => { 328 => 0x48 },
	'recognizedface3age' => { 328 => 0x80 },
	'recognizedface3name' => { 328 => 0x64 },
	'recognizedface3position' => { 328 => 0x78 },
	'recognizedfaceflags' => { 335 => 0x63 },
	'recommendedexposureindex' => { 119 => 0x8832, 501 => 'RecommendedExposureIndex' },
	'record' => { 118 => 'Record' },
	'recordbasisofrecord' => { 118 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 118 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 118 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 118 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 118 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 118 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 184 => 0x4d },
	'recorddynamicproperties' => { 118 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 97 => 0x1804 },
	'recordinformationwithheld' => { 118 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 395 => "\xa9phg" },
	'recordingformat' => { 402 => 0x1000 },
	'recordingmode' => { 112 => 0x1, 377 => 0x1 },
	'recordinstitutioncode' => { 118 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 118 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 395 => "\xa9lab" },
	'recordlabelurl' => { 395 => "\xa9lal" },
	'recordlocationdata' => { 238 => 0x660, 239 => 0x690 },
	'recordmode' => { 34 => 0x9, 113 => 0x3000 },
	'recordownerinstitutioncode' => { 118 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 411 => 0x217 },
	'redbalance' => { 317 => 0x1017, 340 => 0x11, 370 => 0x1c },
	'redcurvelimits' => { 108 => 0x18a },
	'redcurvepoints' => { 107 => 0x2d, 108 => 0x160 },
	'redeyecorrection' => { 291 => 0x0 },
	'redeyeinfo' => { 494 => 'RedEyeInfo', 496 => 'RedEyeInfo' },
	'redeyereduction' => { 184 => 0x41, 422 => 0x6a, 424 => 0x28 },
	'redeyeremoval' => { 335 => 0xb9 },
	'redhsl' => { 103 => 0x20910 },
	'redhue' => { 494 => 'RedHue', 496 => 'RedHue' },
	'redsaturation' => { 494 => 'RedSaturation', 496 => 'RedSaturation' },
	'reductionmatrix1' => { 119 => 0xc625 },
	'reductionmatrix2' => { 119 => 0xc626 },
	'reductionmatrix3' => { 119 => 0xcd3a },
	'reelname' => { 119 => 0xc789, 395 => 'reel' },
	'reference1' => { 505 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 505 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 505 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 505 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 505 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 505 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 119 => 0x214, 517 => 'ReferenceBlackWhite' },
	'referencedate' => { 131 => 0x2f },
	'referencenumber' => { 131 => 0x32 },
	'references' => { 157 => 'References' },
	'referenceservice' => { 131 => 0x2d },
	'regionappliedtodimensions' => { 172 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 172 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 172 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 172 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 172 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 172 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 172 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 172 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 172 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 172 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 172 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 172 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 322 => 'RegionConstraints' },
	'regiondescription' => { 172 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 172 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 172 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 172 => 'Regions' },
	'regioninfodateregionsvalid' => { 175 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 175 => 'RegionInfo' },
	'regioninforegions' => { 175 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 172 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 172 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 175 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 172 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 172 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 172 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 507 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 507 => 'RegistryId' },
	'registryitemid' => { 507 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 507 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 155 => 'data' },
	'relatedaudiofilename' => { 155 => '1Name' },
	'relatedaudiofiletype' => { 155 => '0Type' },
	'relatedimagefileformat' => { 119 => 0x1000 },
	'relatedimageheight' => { 119 => 0x1002 },
	'relatedimagewidth' => { 119 => 0x1001 },
	'relatedresourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 119 => 0xa004, 500 => 'RelatedSoundFile' },
	'relatedvideofile' => { 169 => 'data' },
	'relatedvideofilename' => { 169 => '1Name' },
	'relatedvideofiletype' => { 169 => '0Type' },
	'relation' => { 497 => 'relation' },
	'relationshipaccordingto' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 116 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 521 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 521 => 'relativeTimestamp' },
	'relativetimestampscale' => { 521 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 521 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 294 => '17.8', 295 => '18.5', 297 => '18.4', 298 => '18.4', 303 => '33.8', 304 => '17.6', 307 => '18.5', 308 => '18.4' },
	'releasedate' => { 131 => 0x1e, 387 => 'rldt', 489 => 'ReleaseDate', 521 => 'releaseDate' },
	'releasemode' => { 113 => 0x3001, 237 => 0x5c, 268 => 0x184d, 435 => 0xb049 },
	'releasemode2' => { 444 => 0x112c, 445 => [0x112c,0x8], 446 => [0x1108,0x8], 447 => [0x1184,0x8], 448 => [0x1160,0x8], 449 => [0x4,0x1018], 450 => [0x4,0x210], 451 => [0x4,0x210], 452 => [0x4,0x208], 454 => [0x67,0x3f], 455 => [0x6b,0x6d,0x73,0x4b], 456 => [0x6b,0x4b], 457 => 0x10, 458 => 0x10, 459 => 0x9, 466 => 0x34 },
	'releasemode3' => { 444 => 0x1128, 445 => 0x1128, 446 => 0x1104, 447 => 0x1180, 448 => 0x115c, 449 => 0x1014, 450 => 0x20c, 451 => 0x20c, 452 => 0x204 },
	'releaseready' => { 507 => 'ReleaseReady' },
	'releasesetting' => { 97 => 0x1016 },
	'releasetime' => { 131 => 0x23, 489 => 'ReleaseTime' },
	'remoteonduration' => { 296 => '3.4', 299 => '17.2', 300 => '18.2', 301 => '18.2', 302 => '18.2', 304 => '18.2', 305 => '4.3', 309 => '19.2' },
	'renditionclass' => { 522 => 'RenditionClass' },
	'renditionof' => { 522 => 'RenditionOf' },
	'renditionofalternatepaths' => { 522 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 522 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 522 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 522 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 522 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 522 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 522 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 522 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 522 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 522 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 522 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 522 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 522 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 522 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 522 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 522 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 522 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 522 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 522 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 522 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 522 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 522 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 522 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 522 => 'RenditionParams' },
	'repeatingflashcount' => { 211 => 0xd, 212 => 0xe, 213 => 0xe, 214 => 0xe, 215 => 0xe, 216 => 0xe, 303 => '17.2', 304 => '24.2', 305 => '9.2', 306 => '24.2', 309 => '25.2' },
	'repeatingflashcountbuilt-in' => { 275 => 0x4db },
	'repeatingflashcountexternal' => { 275 => 0x4c3 },
	'repeatingflashoutput' => { 303 => '17.1', 304 => '24.1', 305 => '9.1', 306 => '24.1', 309 => '25.1' },
	'repeatingflashoutputexternal' => { 275 => 0x4c0 },
	'repeatingflashrate' => { 211 => 0xc, 212 => 0xd, 213 => 0xd, 214 => 0xd, 215 => 0xd, 216 => 0xd, 303 => '18.1', 304 => '25.1', 305 => '10.1', 306 => '25.1', 309 => '26.1' },
	'repeatingflashratebuilt-in' => { 275 => 0x4da },
	'repeatingflashrateexternal' => { 275 => 0x4c2 },
	'requirements' => { 395 => "\xa9req" },
	'requires' => { 492 => 'requires' },
	'resampleparams' => { 521 => 'resampleParams' },
	'resampleparamsquality' => { 521 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 138 => 0xe50 },
	'resamplingkerneldenominators067' => { 138 => 0xe4f },
	'resamplingkerneldenominators100' => { 138 => 0xe51 },
	'resaved' => { 411 => 0x21e },
	'resetblacksegrows' => { 138 => 0x181a },
	'resolution' => { 162 => 'Resolution' },
	'resolutionmode' => { 412 => [0x87,0x4] },
	'resolutionunit' => { 119 => 0x128, 134 => 0x2, 517 => 'ResolutionUnit' },
	'resourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 118 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 118 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 84 => 0x612 },
	'restrictions' => { 514 => 'restrictions' },
	'retouchareafeather' => { 494 => [\'RetouchAreas','RetouchAreasFeather'], 496 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 494 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 496 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 494 => [\'RetouchAreas','RetouchAreasMasksAngle'], 496 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 494 => [\'RetouchAreas','RetouchAreasMasksBottom'], 496 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 494 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 496 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 494 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 496 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 494 => [\'RetouchAreas','RetouchAreasMasksDabs'], 496 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 494 => [\'RetouchAreas','RetouchAreasMasksFeather'], 496 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 494 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 496 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 494 => [\'RetouchAreas','RetouchAreasMasksFlow'], 496 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 494 => [\'RetouchAreas','RetouchAreasMasksFullX'], 496 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 494 => [\'RetouchAreas','RetouchAreasMasksFullY'], 496 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 494 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 496 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 494 => [\'RetouchAreas','RetouchAreasMasksLeft'], 496 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 494 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 496 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 494 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 496 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 494 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 496 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 494 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 496 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 494 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 496 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasks'], 496 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 494 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 496 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 494 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 496 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 494 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 496 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 494 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 496 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 494 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 496 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 494 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 496 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 494 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 496 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 494 => [\'RetouchAreas','RetouchAreasMasksRadius'], 496 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 494 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 496 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 494 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 496 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 494 => [\'RetouchAreas','RetouchAreasMasksRight'], 496 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 494 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 496 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 494 => [\'RetouchAreas','RetouchAreasMasks'], 496 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 494 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 496 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 494 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 496 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 494 => [\'RetouchAreas','RetouchAreasMasksTop'], 496 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 494 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 496 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 494 => [\'RetouchAreas','RetouchAreasMasksVersion'], 496 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 494 => [\'RetouchAreas','RetouchAreasMasksWhat'], 496 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 494 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 496 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 494 => [\'RetouchAreas','RetouchAreasMasksX'], 496 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 494 => [\'RetouchAreas','RetouchAreasMasksY'], 496 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 494 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 496 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 494 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 496 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 494 => [\'RetouchAreas','RetouchAreasMethod'], 496 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 494 => [\'RetouchAreas','RetouchAreasOffsetY'], 496 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 494 => [\'RetouchAreas','RetouchAreasOpacity'], 496 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 494 => 'RetouchAreas', 496 => 'RetouchAreas' },
	'retouchareaseed' => { 494 => [\'RetouchAreas','RetouchAreasSeed'], 496 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 494 => [\'RetouchAreas','RetouchAreasSourceState'], 496 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 494 => [\'RetouchAreas','RetouchAreasSourceX'], 496 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 494 => [\'RetouchAreas','RetouchAreasSpotType'], 496 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 233 => 0x9e },
	'retouchinfo' => { 494 => 'RetouchInfo', 496 => 'RetouchInfo' },
	'retouchnefprocessing' => { 252 => 0x5 },
	'retractlensonpoweroff' => { 84 => 0x814 },
	'reuse' => { 322 => 'Reuse' },
	'reuseallowed' => { 524 => 'ReuseAllowed' },
	'reuseprohibited' => { 514 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 301 => '5.2' },
	'reversefocusring' => { 310 => 0x163 },
	'reverseindicators' => { 294 => '12.1', 295 => '6.1', 297 => '6.1', 298 => '6.1', 299 => '4.3', 300 => '5.2', 301 => '5.4', 303 => '33.5', 304 => '5.1', 307 => '6.1', 308 => '6.1', 309 => '6.2', 310 => 0xc1 },
	'reverseshutterspeedaperture' => { 301 => '5.3' },
	'revision' => { 498 => 'revision' },
	'rflensmffocusringsensitivity' => { 84 => 0x714 },
	'rflenstype' => { 57 => 0x3d },
	'rgbcurvelimits' => { 108 => 0x238 },
	'rgbcurvepoints' => { 107 => 0x7, 108 => 0x20e },
	'rgbtables' => { 119 => 0xcd3b },
	'richtextcomment' => { 503 => 'RichTextComment' },
	'ricohdate' => { 401 => 0x6 },
	'ricohimageheight' => { 401 => 0x2 },
	'ricohimagewidth' => { 401 => 0x0 },
	'rightalbedo' => { 485 => 'RightAlbedo' },
	'rightascension' => { 165 => 'RightAscension' },
	'rights' => { 497 => 'rights' },
	'rightsagent' => { 514 => 'rightsAgent' },
	'rightsowner' => { 514 => 'rightsOwner' },
	'roll' => { 115 => 0x8, 395 => ['roll',"\xa9frl"] },
	'rollangle' => { 127 => 0x144d, 244 => 0x0, 312 => 0x903, 335 => 0x90, 369 => 0x1, 407 => 0x2 },
	'romoperationmode' => { 97 => 0x80d },
	'rotation' => { 30 => 0x17, 31 => 0x18, 96 => 0x3, 103 => 0x10002, 108 => 0x26e, 114 => 'QuickTime-Rotation', 123 => 0x4, 165 => 'Rotation', 182 => [0x65,0x50], 183 => 0x46, 184 => 0x5a, 187 => 0x10, 253 => 0x1a, 268 => 0x3693, 274 => '590.1', 287 => 0x76a43207, 335 => 0x30, 351 => '17.2', 381 => 0xd8, 388 => 'irot', 422 => 0x3f, 423 => 0x3f, 433 => 0x10 },
	'routedto' => { 502 => 'RoutedTo' },
	'routing' => { 386 => 'Routing' },
	'routingdestinations' => { 484 => 'RoutingDestinations' },
	'routingexclusions' => { 484 => 'RoutingExclusions' },
	'routingnotes' => { 502 => 'RoutingNotes' },
	'rowsperstrip' => { 119 => 0x116 },
	'rpp' => { 489 => 'rpp' },
	'rtkflag' => { 116 => 'RtkFlag' },
	'rtkstdhgt' => { 116 => 'RtkStdHgt' },
	'rtkstdlat' => { 116 => 'RtkStdLat' },
	'rtkstdlon' => { 116 => 'RtkStdLon' },
	'safetyshift' => { 84 => 0x108 },
	'safetyshiftinavortv' => { 82 => 0x10, 83 => 0x10, 85 => 0xf, 86 => 0x10, 89 => 0x10 },
	'sameexposurefornewaperture' => { 84 => 0x112 },
	'samplebits' => { 155 => 'SampleBits' },
	'samplepagerange' => { 511 => 'samplePageRange' },
	'samplerate' => { 155 => 'SampleRate' },
	'samplesperpixel' => { 119 => 0x115, 340 => 0x8, 517 => 'SamplesPerPixel' },
	'samplestructure' => { 133 => 0x5a },
	'samsungmodelid' => { 409 => 0x3 },
	'sanyoquality' => { 411 => 0x201 },
	'sanyothumbnail' => { 411 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 34 => 0xe, 51 => 0x1, 63 => 0x7, 112 => 0xd, 113 => [0x3013,0x1f], 119 => [0xa409,0xfe55], 127 => 0x1003, 156 => 'Saturation', 181 => 0x1f, 182 => 0x32, 183 => 0x28, 184 => 0x1a, 189 => 0x1, 233 => 0xaa, 246 => 0x35, 247 => 0x3b, 248 => 0x43, 335 => 0x40, 337 => 0x300d, 370 => 0x1f, 377 => 0xd, 396 => 0x27, 398 => 0x58, 401 => 0x28, 402 => 0x1013, 412 => 0x10, 422 => 0x1e, 423 => 0x1b, 435 => 0x2005, 494 => 'Saturation', 496 => 'Saturation', 500 => 'Saturation' },
	'saturationadj' => { 103 => 0x20901, 108 => 0x116, 233 => 0x94, 286 => 0x1, 290 => 0x2e, 470 => 0x8016 },
	'saturationadjustmentaqua' => { 494 => 'SaturationAdjustmentAqua', 496 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 494 => 'SaturationAdjustmentBlue', 496 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 494 => 'SaturationAdjustmentGreen', 496 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 494 => 'SaturationAdjustmentMagenta', 496 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 494 => 'SaturationAdjustmentOrange', 496 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 494 => 'SaturationAdjustmentPurple', 496 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 494 => 'SaturationAdjustmentRed', 496 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 494 => 'SaturationAdjustmentYellow', 496 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 71 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 70 => 0x68, 71 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 70 => 0x38, 71 => 0x38 },
	'saturationmonochrome' => { 70 => 0x80, 71 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 70 => 0x50, 71 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 70 => 0x20, 71 => 0x20 },
	'saturationsetting' => { 320 => 0x1010, 424 => 0x11, 440 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 70 => 0x8, 71 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 70 => 0x98, 71 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 70 => 0xb0, 71 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 70 => 0xc8, 71 => 0xe0 },
	'saveid' => { 522 => 'SaveID' },
	'sbaanalysiscomplete' => { 138 => 0xc35 },
	'sbablack' => { 138 => 0xc25 },
	'sbagmoffset' => { 138 => 0xc4a },
	'sbagray' => { 138 => 0xc26 },
	'sbagreenmagentabal' => { 138 => 0xc33 },
	'sbahighgray' => { 138 => 0xc46 },
	'sbailloffset' => { 138 => 0xc49 },
	'sbailluminantbal' => { 138 => 0xc34 },
	'sbalowgray' => { 138 => 0xc47 },
	'sbaneutralbal' => { 138 => 0xc32 },
	'sbawhite' => { 138 => 0xc27 },
	'scaletype' => { 521 => 'scaleType' },
	'scanimageenhancer' => { 254 => 0x60 },
	'scanningdirection' => { 133 => 0x64 },
	'scene' => { 395 => 'scen', 506 => 'Scene', 521 => 'scene' },
	'scenearea' => { 315 => 0x211, 317 => 0x1031 },
	'sceneassist' => { 233 => 0x9c },
	'scenecapturetype' => { 119 => 0xa406, 500 => 'SceneCaptureType' },
	'scenedetect' => { 315 => 0x210, 317 => 0x1030 },
	'scenedetectdata' => { 315 => 0x212, 317 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 142 => 0xfa02, 186 => 0x100, 233 => 0x8f, 312 => 0x509, 317 => 0x403, 335 => 0x8001, 344 => 0xf, 435 => 0xb023 },
	'scenemodeused' => { 144 => [0x6002,0xf002] },
	'scenerecognition' => { 127 => 0x1425 },
	'scenereferred' => { 504 => 'scene_referred' },
	'sceneselect' => { 411 => 0x21f },
	'scenetype' => { 119 => 0xa301, 500 => 'SceneType' },
	'screentips' => { 294 => '12.7', 295 => '5.3', 303 => '13.1', 304 => '4.4', 307 => '5.4', 309 => '5.1' },
	'scriptversion' => { 138 => 0x1770 },
	'sdrblend' => { 494 => 'SDRBlend', 496 => 'SDRBlend' },
	'sdrbrightness' => { 494 => 'SDRBrightness', 496 => 'SDRBrightness' },
	'sdrcontrast' => { 494 => 'SDRContrast', 496 => 'SDRContrast' },
	'sdrhighlights' => { 494 => 'SDRHighlights', 496 => 'SDRHighlights' },
	'sdrshadows' => { 494 => 'SDRShadows', 496 => 'SDRShadows' },
	'sdrwhites' => { 494 => 'SDRWhites', 496 => 'SDRWhites' },
	'season' => { 507 => 'Season', 510 => 'season' },
	'seasonidentifier' => { 507 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 507 => [\'Season','SeasonName'] },
	'seasonnumber' => { 507 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 484 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 238 => 0x22c, 239 => 0x240, 257 => 0x13c, 268 => 0x1d0 },
	'section' => { 511 => 'section' },
	'securityclassification' => { 119 => 0x9212 },
	'selectableafpoint' => { 84 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 84 => 0x512 },
	'selfdata' => { 116 => 'SelfData' },
	'selftimer' => { 34 => 0x2, 335 => 0x2e, 411 => 0x214, 444 => 0x1134, 445 => 0x1134, 446 => 0x1110, 447 => 0x118c, 448 => 0x1168, 449 => 0x1020, 450 => 0x218, 451 => 0x218, 452 => 0x210 },
	'selftimer2' => { 77 => 0x1d },
	'selftimerinterval' => { 304 => '19.2' },
	'selftimermode' => { 119 => 0x882b },
	'selftimershotcount' => { 295 => '20.2', 297 => '20.3', 298 => '20.3', 299 => '18.2', 300 => '19.2', 301 => '19.2', 302 => '19.3', 304 => '19.3', 307 => '20.3', 308 => '20.3', 309 => '20.2', 310 => 0x2d },
	'selftimershotinterval' => { 295 => '20.3', 297 => '20.2', 298 => '20.2', 302 => '19.2', 307 => '20.2', 308 => '20.2', 310 => 0x31 },
	'selftimertime' => { 97 => 0x1806, 184 => 0x1f, 294 => '18.1', 295 => '20.1', 296 => '3.3', 297 => '20.1', 298 => '20.1', 299 => '18.1', 300 => '19.1', 301 => '19.1', 302 => '19.1', 303 => '7.2', 304 => '19.1', 305 => '3.3', 307 => '20.1', 308 => '20.1', 309 => '20.1', 310 => 0x2b },
	'sellingagency' => { 511 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 119 => 0x8546 },
	'sensingmethod' => { 119 => 0xa217, 500 => 'SensingMethod' },
	'sensitivityadjust' => { 370 => 0x40 },
	'sensitivitysteps' => { 351 => ['14.3','17.4'], 353 => 0x1 },
	'sensitivitytype' => { 119 => 0x8830, 501 => 'SensitivityType' },
	'sensor' => { 191 => 0x665e },
	'sensorarea' => { 317 => 0x400 },
	'sensorareas' => { 409 => 0xa010 },
	'sensorbitdepth' => { 337 => 0x312d },
	'sensorbluelevel' => { 74 => 0x5 },
	'sensorcalibration' => { 316 => 0x805 },
	'sensorcleaning' => { 90 => 0xd },
	'sensorfullheight' => { 137 => 0xf904 },
	'sensorfullwidth' => { 137 => 0xf903 },
	'sensorheight' => { 137 => 0xf901, 142 => 0xfa21, 188 => 0x8, 337 => 0x312c, 379 => 0x109, 402 => 0x1602 },
	'sensorimageheight' => { 138 => 0x3ee },
	'sensorimagewidth' => { 138 => 0x3ed },
	'sensorleftborder' => { 138 => 0x3eb },
	'sensorleftmargin' => { 379 => 0x10a },
	'sensorpixelsize' => { 233 => 0x9a },
	'sensorredlevel' => { 74 => 0x4 },
	'sensorserialnumber' => { 138 => 0x9ce },
	'sensorshield' => { 238 => 0x66d, 239 => 0x69d },
	'sensorsize' => { 156 => 'SensorSize', 370 => 0x35 },
	'sensortemperature' => { 315 => 0x1500, 317 => 0x1007, 375 => 0xc, 379 => 0x210, 412 => [0x39,0x55] },
	'sensortemperature2' => { 375 => 0xe, 379 => 0x211 },
	'sensortopborder' => { 138 => 0x3ec },
	'sensortopmargin' => { 379 => 0x10b },
	'sensortype' => { 335 => 0xca },
	'sensorwidth' => { 137 => 0xf900, 142 => 0xfa20, 188 => 0xa, 337 => 0x312b, 379 => 0x108, 402 => 0x1601 },
	'sequence' => { 396 => 0x7, 397 => 0x35, 398 => 0x36 },
	'sequencefilenumber' => { 445 => 0x4, 446 => 0x4, 447 => 0x4, 448 => 0x4, 457 => 0xc, 458 => 0xc, 459 => 0x1a },
	'sequenceimagenumber' => { 445 => 0x0, 446 => 0x0, 447 => 0x0, 448 => 0x0, 457 => 0x8, 458 => 0x8, 459 => 0x12, 466 => 0x24 },
	'sequencelength' => { 457 => 0x22, 458 => 0x1e, 459 => [0x16,0x1e] },
	'sequencename' => { 510 => 'sequenceName' },
	'sequencenumber' => { 77 => 0x9, 113 => 0x301c, 127 => 0x1101, 140 => 0x1d, 275 => 0x51c, 335 => 0x2b, 424 => [0x10c,0x30c], 435 => 0xb04a, 510 => 'sequenceNumber' },
	'sequenceshotinterval' => { 411 => 0x224 },
	'sequencetotalnumber' => { 510 => 'sequenceTotalNumber' },
	'sequentialshot' => { 411 => 0x20e },
	'serialnumber' => { 64 => 0xc, 97 => 0x180b, 119 => [0xa431,0xfde9], 137 => 0xfa04, 139 => 0xfa00, 141 => 0xc354, 142 => 0xfa19, 153 => 0x0, 156 => 'SerialNumber', 191 => 0x5501, 233 => [0xa0,0x1d], 313 => 0x101, 317 => [0x404,0x101a], 330 => 0x303, 332 => 0x305, 337 => 0x3103, 370 => 0x229, 379 => 0x102, 380 => 0x407, 395 => ['SNum','slno'], 396 => 0x15, 397 => 0x4b, 398 => 0x7e, 402 => 0x5, 409 => 0xa002, 412 => 0x2, 435 => 0x2031, 491 => 'SerialNumber', 501 => 'BodySerialNumber' },
	'serialnumberformat' => { 64 => 0x15, 97 => 0x183b },
	'serialnumberhash' => { 395 => 'CAME' },
	'series' => { 507 => 'Series' },
	'seriesdatetime' => { 472 => 'SeriesDateTime' },
	'seriesdescription' => { 472 => 'SeriesDescription' },
	'seriesidentifier' => { 507 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 472 => 'SeriesModality' },
	'seriesname' => { 507 => [\'Series','SeriesName'] },
	'seriesnumber' => { 472 => 'SeriesNumber', 511 => 'seriesNumber' },
	'seriestitle' => { 511 => 'seriesTitle' },
	'serviceidentifier' => { 132 => 0x1e },
	'servingsize' => { 513 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 87 => 0x0, 88 => 0x0 },
	'setbuttonwhenshooting' => { 82 => 0x1, 84 => 0x704, 90 => 0xc },
	'setclockfromlocationdata' => { 238 => 0x61d, 239 => 0x64d },
	'setfunctionwhenshooting' => { 85 => 0x0, 86 => 0x1, 89 => 0x1 },
	'setting' => { 510 => 'setting' },
	'shadingcompensation' => { 312 => 0x50c, 335 => 0x8a },
	'shadingcompensation2' => { 316 => 0x1012 },
	'shadow' => { 412 => 0xe },
	'shadowadj' => { 103 => 0x2030b },
	'shadowcorrection' => { 370 => 0x79 },
	'shadowprotection' => { 286 => 0x0 },
	'shadows' => { 119 => 0xfe52, 435 => 0x2032, 488 => 'Shadows', 494 => 'Shadows', 496 => 'Shadows' },
	'shadows2012' => { 494 => 'Shadows2012', 496 => 'Shadows2012' },
	'shadowsadj' => { 470 => 0x901a },
	'shadowscale' => { 119 => 0xc633 },
	'shadowtint' => { 494 => 'ShadowTint', 496 => 'ShadowTint' },
	'shadowtone' => { 127 => 0x1040 },
	'shakereduction' => { 372 => 0x1, 373 => 0x1 },
	'shareduserrating' => { 179 => 'WM/SharedUserRating' },
	'sharpendetail' => { 494 => 'SharpenDetail', 496 => 'SharpenDetail' },
	'sharpenedgemasking' => { 494 => 'SharpenEdgeMasking', 496 => 'SharpenEdgeMasking' },
	'sharpening' => { 337 => 0x300b },
	'sharpeningadj' => { 290 => 0x2b },
	'sharpeningkernel' => { 138 => 0x92f },
	'sharpenradius' => { 494 => 'SharpenRadius', 496 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 34 => 0xf, 63 => 0x6, 74 => 0x2, 112 => 0xb, 113 => [0x3011,0x21], 119 => [0xa40a,0xfe56], 127 => 0x1001, 140 => 0x6b, 149 => 0x37, 156 => 'Sharpness', 181 => 0x21, 182 => 0x30, 183 => 0x26, 184 => 0x18, 189 => 0x3, 233 => 0x6, 246 => 0x32, 247 => 0x33, 248 => 0x39, 317 => 0x100f, 335 => 0x41, 370 => 0x21, 377 => 0xb, 396 => 0x26, 398 => 0x56, 401 => 0x22, 402 => [0x1003,0x1014], 412 => 0x11, 422 => 0x1c, 423 => 0x19, 435 => 0x2006, 466 => 0x52, 494 => 'Sharpness', 496 => 'Sharpness', 500 => 'Sharpness' },
	'sharpnessadj' => { 103 => 0x20310, 108 => 0x25a, 470 => 0x801a },
	'sharpnessadjon' => { 103 => '0x20310.0' },
	'sharpnessauto' => { 71 => 0x94 },
	'sharpnessfactor' => { 317 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 70 => 0x64, 71 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 74 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 70 => 0x34, 71 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 70 => 0x7c, 71 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 70 => 0x4c, 71 => 0x4c },
	'sharpnessovershoot' => { 470 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 70 => 0x1c, 71 => 0x1c },
	'sharpnessrange' => { 435 => 0x2035 },
	'sharpnesssetting' => { 312 => 0x506, 320 => 0x1013, 424 => 0x12, 440 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 70 => 0x4, 71 => 0x4 },
	'sharpnessstrength' => { 103 => 0x20311 },
	'sharpnessthreshold' => { 470 => 0x801d },
	'sharpnessundershoot' => { 470 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 70 => 0x94, 71 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 70 => 0xac, 71 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 70 => 0xc4, 71 => 0xdc },
	'shiftcols' => { 138 => 0xc70 },
	'shootid' => { 510 => 'shootID' },
	'shootingdistance' => { 103 => 0x20701 },
	'shootinginfodisplay' => { 294 => '13.2', 295 => '5.1', 303 => '10.2', 304 => '4.1', 307 => '5.1', 309 => '5.3' },
	'shootinginfomonitorofftime' => { 294 => '26.2', 295 => '22.2', 297 => '22.2', 298 => '22.2', 302 => '21.2', 303 => '9.1', 304 => '21.2', 307 => '22.2', 308 => '22.2', 309 => '22.2', 310 => 0x37 },
	'shootingmode' => { 156 => 'ShootingMode', 233 => 0x89, 335 => 0x1f },
	'shootingmodesetting' => { 296 => '5.1' },
	'shortdescription' => { 498 => 'shortdescription' },
	'shortdocumentid' => { 131 => 0xba },
	'shortname' => { 494 => 'ShortName', 496 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 84 => 0x80d },
	'shorttitle' => { 387 => '@sti' },
	'shotdate' => { 521 => 'shotDate' },
	'shotday' => { 521 => 'shotDay' },
	'shotlocation' => { 521 => 'shotLocation' },
	'shotlogdata' => { 477 => 'shot_log_data' },
	'shotname' => { 395 => 'shot', 521 => 'shotName' },
	'shotnumber' => { 521 => 'shotNumber' },
	'shotnumbersincepowerup' => { 439 => 0x44e, 457 => 0x1a, 458 => 0x16, 459 => 0xa },
	'shotnumbersincepowerup2' => { 424 => 0x200 },
	'shotsize' => { 521 => 'shotSize' },
	'shotsperinterval' => { 222 => 0x180, 237 => 0xb4, 238 => 0xc0, 239 => 0xd0 },
	'showmovement' => { 387 => 'shwm' },
	'shownevent' => { 507 => 'EventExt' },
	'showneventidentifier' => { 507 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 507 => [\'EventExt','EventExtName'] },
	'shutter' => { 454 => 0x20, 455 => 0x26, 456 => 0x26 },
	'shutter-aelock' => { 82 => 0x4, 84 => 0x701, 85 => 0x3, 86 => 0x4, 87 => 0x3, 88 => 0x3, 89 => 0x4, 90 => 0x2 },
	'shutteraelbutton' => { 83 => 0x4 },
	'shutterbuttonafonbutton' => { 84 => 0x701 },
	'shuttercount' => { 11 => 0x176, 57 => 0x1, 233 => 0xa7, 259 => [0x6a,0x157,0x24d], 260 => 0x286, 261 => 0x279, 262 => 0x284, 263 => 0x242, 264 => 0x280, 265 => 0x276, 266 => [0x27d,0x27f], 267 => 0x246, 269 => 0x2d6, 270 => 0x321, 271 => 0xbd8, 272 => 0x287, 273 => 0x320, 274 => 0x24a, 275 => 0x5fb, 276 => 0x2d5, 370 => 0x5d, 433 => 0x846, 438 => [0x125,0x14a], 454 => 0x32, 455 => 0x3a, 456 => 0x3a },
	'shuttercount2' => { 454 => 0x4c, 455 => [0x50,0x52,0x58], 456 => 0x50 },
	'shuttercount3' => { 454 => [0x1a0,0x1aa,0x1bd], 455 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 82 => 0xf, 83 => 0xf, 84 => 0x305, 85 => 0xe, 86 => 0xf, 87 => 0x8, 88 => 0x8, 89 => 0xf, 90 => 0x8 },
	'shuttermode' => { 57 => 0x17, 140 => 0x1b, 233 => 0x34 },
	'shutterreleasebuttonae-l' => { 294 => '17.7', 295 => '18.4', 297 => '78.4', 298 => '78.4', 299 => '16.1', 300 => '17.1', 301 => '17.1', 302 => '17.1', 303 => '7.1', 304 => '17.5', 307 => '18.4', 308 => '78.4', 309 => '18.2', 310 => 0x29 },
	'shutterreleasemethod' => { 97 => 0x1010 },
	'shutterreleasenocfcard' => { 82 => 0x2, 83 => 0x2, 90 => 0xf },
	'shutterreleasetiming' => { 97 => 0x1011 },
	'shutterreleasewithoutlens' => { 84 => 0x711 },
	'shutterspeedlock' => { 295 => '38.1', 297 => '38.1', 298 => '38.1', 307 => '38.1', 308 => '38.1', 310 => 0xb7 },
	'shutterspeedrange' => { 84 => 0x10c },
	'shutterspeedsetting' => { 184 => 0x6, 422 => 0x2f, 423 => 0x28, 424 => 0x0 },
	'shutterspeedvalue' => { 93 => 0x1, 119 => 0x9201, 317 => 0x1000, 379 => 0x400, 500 => 'ShutterSpeedValue' },
	'shuttertype' => { 127 => 0x1050, 335 => 0x9f, 370 => 0x87 },
	'sidecarforextension' => { 509 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 138 => 0xe0d },
	'sigmascalingfactorcamera' => { 138 => 0xe0c },
	'sigmascalingfactorlowres' => { 138 => 0xe0b },
	'sigmasizetable' => { 138 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 233 => 0xbf },
	'similarityindex' => { 131 => 0xe4 },
	'singleframebracketing' => { 184 => 0x21 },
	'skilllevel' => { 513 => 'skillLevel' },
	'skintonecorrection' => { 370 => 0x95 },
	'skiplinetime' => { 138 => 0x184e },
	'slaveflashmeteringsegments' => { 370 => 0x20b },
	'slideshowname' => { 510 => 'slideshowName' },
	'slideshownumber' => { 510 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 510 => 'slideshowTotalNumber' },
	'slowshutter' => { 77 => 0x8 },
	'slowsync' => { 127 => 0x1030 },
	'smartalbumcolor' => { 409 => 0x20 },
	'smartrange' => { 409 => 0xa012 },
	'smileshutter' => { 424 => 0x31 },
	'smileshuttermode' => { 424 => 0x27 },
	'smoothness' => { 119 => 0xfe57, 494 => 'Smoothness', 496 => 'Smoothness' },
	'snapshot' => { 507 => 'SnapshotLink' },
	'snapshotformat' => { 507 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 507 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 507 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 507 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 507 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 489 => 'Snapshots' },
	'snapshotusedvideoframe' => { 507 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 507 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 507 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 507 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 507 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 435 => 0x200f },
	'software' => { 119 => 0x131, 157 => 'Software', 325 => 'Software', 379 => 0x203, 389 => 'software', 412 => 0x18, 479 => 'Software', 517 => 'Software' },
	'softwareversion' => { 395 => ['@swr',"\xa9swr"], 411 => 0x207 },
	'soloist' => { 387 => "\xa9sol" },
	'songwriter' => { 395 => "\xa9swf" },
	'songwriterkeywords' => { 395 => "\xa9swk" },
	'sonycropsize' => { 119 => 0x74c8 },
	'sonycroptopleft' => { 119 => 0x74c7 },
	'sonydatetime' => { 443 => 0x6, 445 => 0x1b6, 446 => 0x210, 447 => 0x1fe, 448 => 0x22c },
	'sonydatetime2' => { 454 => 0x51 },
	'sonyexposuretime' => { 454 => 0x3a, 455 => 0x46, 456 => [0x66,0x46] },
	'sonyexposuretime2' => { 466 => 0xe },
	'sonyfnumber' => { 454 => 0x3c, 455 => 0x48, 456 => [0x68,0x48], 466 => 0x14 },
	'sonyimageheight' => { 443 => 0x1a, 457 => 0x44, 458 => 0x3f, 459 => 0x47 },
	'sonyimageheightmax' => { 466 => 0x40 },
	'sonyimagesize' => { 184 => 0x3b, 422 => 0x54, 423 => 0x54, 424 => 0x9 },
	'sonyimagewidth' => { 443 => 0x1c },
	'sonyimagewidthmax' => { 466 => 0x3e },
	'sonyiso' => { 445 => 0x1218, 446 => 0x11f4, 447 => 0x1270, 448 => [0x1254,0x1258,0x1280], 449 => 0x113c, 450 => 0x344, 451 => 0x346, 452 => 0x320, 466 => 0x4 },
	'sonymaxaperture' => { 454 => 0x0, 455 => 0x0 },
	'sonymaxaperturevalue' => { 466 => 0x16 },
	'sonyminaperture' => { 454 => 0x1, 455 => 0x1 },
	'sonymodelid' => { 435 => 0xb001 },
	'sonyquality' => { 184 => 0x3c },
	'sonyrawimagesize' => { 119 => 0x7038 },
	'sonytimeminsec' => { 455 => 0x61 },
	'sortalbum' => { 387 => 'soal' },
	'sortalbumartist' => { 387 => 'soaa' },
	'sortartist' => { 387 => 'soar' },
	'sortcomposer' => { 387 => 'soco' },
	'sortname' => { 387 => 'sonm', 494 => 'SortName', 496 => 'SortName' },
	'sortshow' => { 387 => 'sosn' },
	'soundengineer' => { 387 => "\xa9sne" },
	'source' => { 131 => 0x73, 325 => 'Source', 497 => 'source', 498 => 'source', 509 => 'Source' },
	'sourcecount' => { 483 => 'SourceCount' },
	'sourcecredits' => { 395 => "\xa9src" },
	'sourcedirectoryindex' => { 357 => 0x0 },
	'sourcefileindex' => { 357 => 0x2 },
	'sourcephotoscount' => { 482 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 138 => 0x1390 },
	'spatialfrequencyresponse' => { 500 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 500 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 500 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 500 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 500 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 521 => 'speakerPlacement' },
	'specialeffectlevel' => { 113 => 0x3030 },
	'specialeffectmode' => { 113 => 0x2076 },
	'specialeffectsetting' => { 113 => 0x3031 },
	'specialinstructions' => { 131 => 0x28 },
	'specialmode' => { 317 => 0x200, 411 => 0x200 },
	'specialoccasion' => { 513 => 'specialOccasion' },
	'specialtypeid' => { 477 => 'SpecialTypeID' },
	'spectralsensitivity' => { 119 => 0x8824, 500 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 41 => 0x32b, 42 => 0x281, 45 => [0x2b9,0x2d0,0x2d4], 46 => 0x56a, 47 => 0x1e4, 48 => [0x1fd,0x2dd], 49 => [0x231,0x30f], 50 => 0x31d },
	'speedx' => { 115 => 0x3, 395 => "\xa9xsp" },
	'speedy' => { 115 => 0x4, 395 => "\xa9ysp" },
	'speedz' => { 115 => 0x5, 395 => "\xa9zsp" },
	'spherical' => { 483 => 'Spherical' },
	'sphericalvideoxml' => { 120 => 'SphericalVideoXML' },
	'splitcolumn' => { 379 => 0x222 },
	'splittoningbalance' => { 494 => 'SplitToningBalance', 496 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 494 => 'SplitToningHighlightHue', 496 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 494 => 'SplitToningHighlightSaturation', 496 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 494 => 'SplitToningShadowHue', 496 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 494 => 'SplitToningShadowSaturation', 496 => 'SplitToningShadowSaturation' },
	'sport' => { 511 => 'sport' },
	'spotfocuspointx' => { 181 => 0x2d },
	'spotfocuspointy' => { 181 => 0x2e },
	'spotmeteringmode' => { 34 => 0x27 },
	'spotmeterlinktoafpoint' => { 84 => 0x107 },
	'sractive' => { 351 => '17.1' },
	'srawquality' => { 34 => 0x2e },
	'srfocallength' => { 372 => 0x3 },
	'srgbrendering' => { 323 => 'sRGB' },
	'srhalfpresstime' => { 372 => 0x2 },
	'srresult' => { 372 => 0x0, 373 => 0x0 },
	'stackedimage' => { 312 => 0x804 },
	'standardmatrixcustom' => { 138 => 0x7d4 },
	'standardmatrixdaylight' => { 138 => 0x7d0 },
	'standardmatrixflash' => { 138 => 0x7d3 },
	'standardmatrixfluorescent' => { 138 => 0x7d2 },
	'standardmatrixtungsten' => { 138 => 0x7d1 },
	'standardoutputhighlightpoint' => { 109 => 0x14 },
	'standardoutputsensitivity' => { 119 => 0x8831, 501 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 109 => 0x15 },
	'standardrawcolortone' => { 109 => 0xd },
	'standardrawcontrast' => { 109 => 0xf },
	'standardrawhighlight' => { 109 => 0x75 },
	'standardrawhighlightpoint' => { 109 => 0x12 },
	'standardrawlinear' => { 109 => 0x10 },
	'standardrawsaturation' => { 109 => 0xe },
	'standardrawshadow' => { 109 => 0x7e },
	'standardrawshadowpoint' => { 109 => 0x13 },
	'standardrawsharpness' => { 109 => 0x11 },
	'standardunsharpmaskfineness' => { 109 => 0x94 },
	'standardunsharpmaskstrength' => { 109 => 0x92 },
	'standardunsharpmaskthreshold' => { 109 => 0x96 },
	'standardwhitecustom' => { 138 => 0x838 },
	'standardwhitedaylight' => { 138 => 0x834 },
	'standardwhiteflash' => { 138 => 0x837 },
	'standardwhitefluorescent' => { 138 => 0x836 },
	'standardwhitetungsten' => { 138 => 0x835 },
	'standbytimer' => { 295 => '19.1', 297 => '19.1', 298 => '19.1', 301 => '18.1', 302 => '18.1', 307 => '19.1', 308 => '19.1' },
	'starlightview' => { 310 => 0x249 },
	'startingpage' => { 511 => 'startingPage' },
	'startmovieshooting' => { 84 => 0x70d },
	'starttimecode' => { 395 => "\xa9TIM", 521 => 'startTimecode' },
	'starttimecodetimeformat' => { 521 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 521 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 521 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 395 => "\xa9TSZ", 521 => 'startTimeSampleSize' },
	'starttimescale' => { 395 => "\xa9TSC", 521 => 'startTimeScale' },
	'state' => { 161 => 'State', 335 => 0x6b, 509 => 'State' },
	'status' => { 475 => 'Status', 487 => 'Status' },
	'stereomode' => { 483 => 'StereoMode' },
	'stitched' => { 483 => 'Stitched' },
	'stitchingsoftware' => { 482 => 'StitchingSoftware', 483 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 444 => 0x113e, 445 => 0x113e, 446 => 0x111a, 447 => 0x1196, 448 => 0x1172, 449 => 0x102a, 450 => 0x222, 451 => 0x222, 452 => 0x217, 466 => 0xa },
	'storagemethod' => { 188 => 0x12 },
	'storebyorientation' => { 295 => '46.3', 297 => '47.3', 298 => '47.3', 307 => '47.3', 308 => '47.3', 310 => 0xd },
	'storedescription' => { 387 => 'sdes' },
	'storylineidentifier' => { 507 => 'StorylineIdentifier' },
	'straightenangle' => { 287 => 0x2fc08431 },
	'streamready' => { 507 => 'StreamReady' },
	'streamtype' => { 176 => 'StreamType' },
	'stretchmode' => { 521 => 'stretchMode' },
	'studydatetime' => { 472 => 'StudyDateTime' },
	'studydescription' => { 472 => 'StudyDescription' },
	'studyid' => { 472 => 'StudyID' },
	'studyphysician' => { 472 => 'StudyPhysician' },
	'styleperiod' => { 507 => 'StylePeriod' },
	'sub-location' => { 131 => 0x5c },
	'subcommanddialplaybackmode' => { 310 => 0x1cf },
	'subfiledata' => { 164 => 'data' },
	'subfiledirectory' => { 164 => '1Directory' },
	'subfilemimetype' => { 164 => '2MIME' },
	'subfilename' => { 164 => '1Name' },
	'subfileresource' => { 164 => 'rsrc' },
	'subfiletype' => { 119 => 0xfe, 164 => '0Type' },
	'subject' => { 321 => 'Subject', 386 => 'Subject', 497 => 'subject', 508 => 'Subject', 522 => 'subject' },
	'subjectarea' => { 119 => 0x9214, 500 => 'SubjectArea' },
	'subjectcode' => { 506 => 'SubjectCode' },
	'subjectdetection' => { 238 => 0x23e, 239 => 0x252 },
	'subjectdistance' => { 119 => 0x9206, 140 => 0x3e, 500 => 'SubjectDistance' },
	'subjectdistancerange' => { 119 => 0xa40c, 500 => 'SubjectDistanceRange' },
	'subjectlocation' => { 119 => 0xa214, 500 => 'SubjectLocation' },
	'subjectmotion' => { 297 => '78.2', 298 => '78.2', 308 => '78.2', 310 => 0x103 },
	'subjectprogram' => { 181 => 0x22 },
	'subjectreference' => { 131 => 0xc },
	'sublabels1' => { 505 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 505 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 505 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 505 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 505 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 114 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 114 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 114 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 119 => 0x9290 },
	'subsectimedigitized' => { 119 => 0x9292 },
	'subsectimeoriginal' => { 119 => 0x9291 },
	'subsection1' => { 511 => 'subsection1' },
	'subsection2' => { 511 => 'subsection2' },
	'subsection3' => { 511 => 'subsection3' },
	'subsection4' => { 511 => 'subsection4' },
	'subselector' => { 295 => '49.1', 297 => '71.1', 298 => '71.1', 308 => '71.1', 310 => 0x8f },
	'subselectorassignment' => { 295 => '48.1' },
	'subselectorcenter' => { 297 => '72.1', 298 => '72.1', 308 => '72.1' },
	'subselectorplusdials' => { 295 => '49.2', 297 => '73.1', 298 => '73.1', 308 => '73.1' },
	'subtitle' => { 179 => 'WM/SubTitle', 387 => "\xa9st3", 395 => "\xa9snm", 511 => 'subtitle' },
	'subtitlekeywords' => { 395 => "\xa9snk" },
	'subversionfilename' => { 505 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 505 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 505 => 'SubVersions' },
	'superimposeddisplay' => { 82 => 0xa, 84 => 0x510, 85 => 0x9, 86 => 0xa, 89 => 0xa, 90 => 0xe },
	'supermacro' => { 64 => 0x1a },
	'supplementalcategories' => { 131 => 0x14, 509 => 'SupplementalCategories' },
	'supplementaltype' => { 133 => 0x37 },
	'supplementdisplayid' => { 511 => 'supplementDisplayID' },
	'supplementstartingpage' => { 511 => 'supplementStartingPage' },
	'supplementtitle' => { 511 => 'supplementTitle' },
	'supplychainsource' => { 507 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 507 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 507 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 494 => 'SupportsAmount', 496 => 'SupportsAmount' },
	'supportscolor' => { 494 => 'SupportsColor', 496 => 'SupportsColor' },
	'supportshighdynamicrange' => { 494 => 'SupportsHighDynamicRange', 496 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 494 => 'SupportsMonochrome', 496 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 494 => 'SupportsNormalDynamicRange', 496 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 494 => 'SupportsOutputReferred', 496 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 494 => 'SupportsSceneReferred', 496 => 'SupportsSceneReferred' },
	'svisosetting' => { 351 => 0x14 },
	'swatchcoloranta' => { 526 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 526 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 526 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 526 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 526 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 526 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 526 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 526 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 526 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 526 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 526 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 526 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 526 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 526 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 526 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 526 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 526 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 526 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 526 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 335 => 0x93, 424 => 0x33 },
	'sweeppanoramafieldofview' => { 335 => 0x94 },
	'sweeppanoramasize' => { 424 => 0x32 },
	'switchtoregisteredafpoint' => { 83 => 0x12, 84 => 0x50a },
	'symlink' => { 120 => 'SymLink' },
	'syncreleasemode' => { 297 => '77.1', 298 => '77.1', 308 => '77.1', 310 => 0x41 },
	'system' => { 379 => 0x204 },
	'tagged' => { 381 => 0xdd, 382 => 'Tagged', 489 => 'tagged' },
	'tagslist' => { 499 => 'TagsList' },
	'tagstructure' => { 505 => 'TagStructure' },
	'takenumber' => { 521 => 'takeNumber' },
	'tapename' => { 521 => 'tapeName' },
	'targetaperture' => { 77 => 0x4 },
	'targetcompressionratio' => { 95 => 0x1 },
	'targetdistancesetting' => { 97 => 0x1807 },
	'targetexposuretime' => { 77 => 0x5 },
	'targetimagetype' => { 97 => 0x100a },
	'targetprinter' => { 119 => 0x151 },
	'taxon' => { 118 => 'Taxon' },
	'taxonacceptednameusage' => { 118 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 118 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 118 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 118 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 118 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 118 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 118 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 118 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 118 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 118 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 118 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 118 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 118 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 118 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 118 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 118 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 118 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 118 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 118 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 118 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 118 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 118 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 118 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 118 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 118 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 118 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 118 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 118 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 118 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 118 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 118 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 118 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 118 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 118 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 138 => 0x196f },
	'tda1edgepolarity' => { 138 => 0x1971 },
	'tda1gain' => { 138 => 0x1970 },
	'tda1offset' => { 138 => 0x196e },
	'tda2bandwidth' => { 138 => 0x1979 },
	'tda2edgepolarity' => { 138 => 0x197b },
	'tda2gain' => { 138 => 0x197a },
	'tda2offset' => { 138 => 0x1978 },
	'tda3bandwidth' => { 138 => 0x1983 },
	'tda3edgepolarity' => { 138 => 0x1985 },
	'tda3gain' => { 138 => 0x1984 },
	'tda3offset' => { 138 => 0x1982 },
	'tda4bandwidth' => { 138 => 0x198d },
	'tda4edgepolarity' => { 138 => 0x198f },
	'tda4gain' => { 138 => 0x198e },
	'tda4offset' => { 138 => 0x198c },
	'teaser' => { 511 => 'teaser' },
	'teleconverter' => { 186 => 0x105, 435 => 0x105 },
	'tempampgainx100' => { 138 => 0x1914 },
	'tempo' => { 521 => 'tempo' },
	'temporalcoverage' => { 507 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 507 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 507 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 322 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 322 => 'TermsAndConditionsURL' },
	'testname' => { 120 => 'TestName' },
	'textencoding' => { 232 => 0x4 },
	'textlayername' => { 509 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 509 => 'TextLayers' },
	'textlayertext' => { 509 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 335 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 494 => 'Texture', 496 => 'Texture' },
	'three-dtrackingfacedetection' => { 297 => '1.4', 298 => '1.4', 308 => '1.4' },
	'three-dtrackingwatcharea' => { 297 => '78.1', 298 => '78.1', 308 => '78.1' },
	'thresholding' => { 119 => 0x107 },
	'thumbnailfilename' => { 97 => 0x817 },
	'thumbnailformat' => { 519 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 142 => 0xfa55, 519 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 97 => 0x2008, 114 => 'Exif-ThumbnailImage', 122 => 0x3, 167 => 'data', 317 => 0x100, 395 => 'thmb', 519 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 167 => '1Name' },
	'thumbnailimagesize' => { 167 => 'ImageSize' },
	'thumbnailimagetype' => { 167 => '0Type' },
	'thumbnailimagevalidarea' => { 64 => 0x13 },
	'thumbnaillength' => { 119 => 0x202 },
	'thumbnailoffset' => { 119 => 0x201 },
	'thumbnailpng' => { 395 => 'thmb' },
	'thumbnails' => { 519 => 'Thumbnails' },
	'thumbnailwidth' => { 142 => 0xfa54, 519 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 511 => 'ticker' },
	'tiffhandling' => { 494 => 'TIFFHandling', 496 => 'TIFFHandling' },
	'tiffmeteringimage' => { 187 => 0x104c, 433 => 0x1110 },
	'tilelength' => { 119 => 0x143 },
	'tilewidth' => { 119 => 0x142 },
	'time' => { 138 => 0x401, 370 => 0x7 },
	'timecodes' => { 119 => 0xc763 },
	'timecreated' => { 131 => 0x3c, 140 => 0x14, 149 => 0x10, 382 => 'TimeCreated' },
	'timelapseshotnumber' => { 338 => 0x10 },
	'timeperiod' => { 511 => 'timePeriod' },
	'timerfunctionbutton' => { 296 => '5.2', 299 => '12.1', 300 => '13.1' },
	'timerlength' => { 84 => 0x80c },
	'timerrecording' => { 335 => 0x96 },
	'timescaleparams' => { 521 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 521 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 521 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 521 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 132 => 0x50 },
	'timeshot' => { 484 => 'TimeShot' },
	'timesignature' => { 521 => 'timeSignature' },
	'timesincepoweron' => { 335 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 311 => 0x8, 325 => 'TimeStamp', 335 => 0xaf, 483 => 'Timestamp', 490 => 'Timestamp', 505 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 78 => 0x1, 238 => 0x594, 239 => 0x5c4, 279 => 0x0, 405 => 0xa },
	'timezonecity' => { 78 => 0x2 },
	'timezonecode' => { 100 => 0x1 },
	'timezoneinfo' => { 100 => 0x2 },
	'timezoneoffset' => { 119 => 0x882a },
	'tint' => { 389 => 'player.movie.visual.tint', 494 => 'Tint', 496 => 'Tint' },
	'title' => { 157 => 'Title', 321 => 'Title', 325 => 'Title', 335 => 0x65, 386 => 'Title', 387 => ['titl',"\xa9nam"], 389 => 'title', 395 => ['titl',"\xa9nam"], 497 => 'title', 508 => 'Title', 519 => 'Title' },
	'togglestyleamount' => { 494 => 'ToggleStyleAmount', 496 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 494 => 'ToggleStyleDigest', 496 => 'ToggleStyleDigest' },
	'tonecomp' => { 233 => 0x81 },
	'tonecurve' => { 74 => 0x1, 370 => 0x402, 494 => 'ToneCurve', 496 => 'ToneCurve' },
	'tonecurveactive' => { 108 => 0x110 },
	'tonecurveadobergb' => { 409 => 0xa043 },
	'tonecurveadobergbdefault' => { 409 => 0xa041 },
	'tonecurveblue' => { 494 => 'ToneCurveBlue', 496 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 470 => 0x9003 },
	'tonecurvebluey' => { 470 => 0x9007 },
	'tonecurvebrightness' => { 103 => 0x20410 },
	'tonecurvebrightnessx' => { 470 => 0x9000 },
	'tonecurvebrightnessy' => { 470 => 0x9004 },
	'tonecurvecolorspace' => { 107 => 0x0 },
	'tonecurvecontrast' => { 103 => 0x20411 },
	'tonecurvegreen' => { 494 => 'ToneCurveGreen', 496 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 470 => 0x9002 },
	'tonecurvegreeny' => { 470 => 0x9006 },
	'tonecurveinputrange' => { 107 => 0x3 },
	'tonecurveinterpolation' => { 108 => 0x159 },
	'tonecurvemode' => { 108 => 0x113 },
	'tonecurvename' => { 494 => 'ToneCurveName', 496 => 'ToneCurveName' },
	'tonecurvename2012' => { 494 => 'ToneCurveName2012', 496 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 103 => '0x20400.1' },
	'tonecurveoutputrange' => { 107 => 0x5 },
	'tonecurveprofilename' => { 138 => 0x1391 },
	'tonecurveproperty' => { 108 => 0x3c },
	'tonecurvepv2012' => { 494 => 'ToneCurvePV2012', 496 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 494 => 'ToneCurvePV2012Blue', 496 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 494 => 'ToneCurvePV2012Green', 496 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 494 => 'ToneCurvePV2012Red', 496 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 494 => 'ToneCurveRed', 496 => 'ToneCurveRed' },
	'tonecurveredx' => { 470 => 0x9001 },
	'tonecurveredy' => { 470 => 0x9005 },
	'tonecurves' => { 370 => 0x403 },
	'tonecurveshape' => { 107 => 0x1 },
	'tonecurvesrgb' => { 409 => 0xa042 },
	'tonecurvesrgbdefault' => { 409 => 0xa040 },
	'tonecurvex' => { 107 => 0xa },
	'tonecurvey' => { 107 => 0xb },
	'tonelevel' => { 312 => 0x52e },
	'tonemapstrength' => { 494 => 'ToneMapStrength', 496 => 'ToneMapStrength' },
	'toningeffect' => { 57 => 0xf, 233 => 0xb3, 246 => 0x38, 247 => 0x40, 248 => 0x48, 402 => 0x1015 },
	'toningeffectauto' => { 71 => 0xa4 },
	'toningeffectfaithful' => { 70 => 0x74, 71 => 0x74 },
	'toningeffectlandscape' => { 70 => 0x44, 71 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 70 => 0x8c, 71 => 0x8c },
	'toningeffectneutral' => { 70 => 0x5c, 71 => 0x5c },
	'toningeffectportrait' => { 70 => 0x2c, 71 => 0x2c },
	'toningeffectstandard' => { 70 => 0x14, 71 => 0x14 },
	'toningeffectuserdef1' => { 70 => 0xa4, 71 => 0xbc },
	'toningeffectuserdef2' => { 70 => 0xbc, 71 => 0xd4 },
	'toningeffectuserdef3' => { 70 => 0xd4, 71 => 0xec },
	'toningsaturation' => { 246 => 0x39, 247 => 0x41, 248 => 0x49 },
	'totalzoom' => { 140 => 0x62 },
	'touchae' => { 335 => 0xab },
	'track' => { 387 => "\xa9trk", 395 => "\xa9trk" },
	'trackcreatedate' => { 394 => 0x1 },
	'trackmodifydate' => { 394 => 0x2 },
	'tracknumber' => { 387 => 'trkn', 521 => 'trackNumber' },
	'tracks' => { 521 => 'Tracks' },
	'tracksframerate' => { 521 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 521 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 521 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 521 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 521 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 521 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 521 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 521 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 521 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 521 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 521 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 521 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 521 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 521 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 521 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 521 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 521 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 395 => 'kgtt' },
	'trailer' => { 120 => 'Trailer' },
	'trailersignature' => { 164 => 'zmie' },
	'transcript' => { 507 => 'Transcript' },
	'transcriptlink' => { 507 => 'TranscriptLink' },
	'transcriptlinklink' => { 507 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 507 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 119 => 0x12d, 517 => 'TransferFunction' },
	'transfertimenormal' => { 138 => 0x1888 },
	'transfertimetest' => { 138 => 0x1889 },
	'transform' => { 335 => [0x8012,0x59] },
	'transmissionreference' => { 509 => 'TransmissionReference' },
	'trapped' => { 321 => 'Trapped', 508 => 'Trapped' },
	'trashbuttonfunction' => { 84 => 0x710 },
	'travelday' => { 335 => 0x36 },
	'treble' => { 389 => 'player.movie.audio.treble' },
	'triggermode' => { 396 => 0x6, 397 => 0x34, 398 => 0x34 },
	'tstop' => { 119 => 0xc772 },
	'ttl_da_adown' => { 358 => 0x5 },
	'ttl_da_aup' => { 358 => 0x4 },
	'ttl_da_bdown' => { 358 => 0x7 },
	'ttl_da_bup' => { 358 => 0x6 },
	'tungstenawb' => { 348 => 0x1 },
	'tvepisode' => { 387 => 'tves' },
	'tvepisodeid' => { 387 => 'tven' },
	'tvexposuretimesetting' => { 351 => 0x12 },
	'tvnetworkname' => { 387 => 'tvnn' },
	'tvseason' => { 387 => 'tvsn' },
	'tvshow' => { 387 => 'tvsh' },
	'type' => { 478 => 'Type', 497 => 'type', 516 => 'type' },
	'typestatus' => { 118 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 119 => 0xc614 },
	'uniquedocumentid' => { 131 => 0xbb },
	'uniquematrixauto' => { 138 => 0x7e9 },
	'uniquematrixcustom' => { 138 => 0x7e8 },
	'uniquematrixdaylight' => { 138 => 0x7e4 },
	'uniquematrixflash' => { 138 => 0x7e7 },
	'uniquematrixfluorescent' => { 138 => 0x7e6 },
	'uniquematrixtungsten' => { 138 => 0x7e5 },
	'uniqueobjectname' => { 132 => 0x64 },
	'units' => { 479 => 'Units' },
	'unknown_aacr' => { 387 => 'AACR' },
	'unknown_cdek' => { 387 => 'CDEK' },
	'unknown_cdet' => { 387 => 'CDET' },
	'unknownblock' => { 370 => 0x405 },
	'unknownblock1' => { 316 => 0x635 },
	'unknownblock2' => { 316 => 0x636 },
	'unknownblock3' => { 316 => 0x1103 },
	'unknownblock4' => { 316 => 0x1104 },
	'unknowncontrast' => { 109 => 0x45 },
	'unknowndate' => { 379 => 0x212 },
	'unknownev' => { 138 => 0x1 },
	'unknownlinear' => { 109 => 0x46 },
	'unknownnumber' => { 97 => 0x180b },
	'unknownoutputhighlightpoint' => { 109 => 0x4a },
	'unknownoutputshadowpoint' => { 109 => 0x4b },
	'unknownrawhighlight' => { 109 => 0x7b },
	'unknownrawhighlightpoint' => { 109 => 0x48 },
	'unknownrawshadow' => { 109 => 0x84 },
	'unknownrawshadowpoint' => { 109 => 0x49 },
	'unknownsharpness' => { 109 => 0x47 },
	'unknowntags' => { 395 => 'TAGS' },
	'unknowntemperature' => { 121 => 0x4 },
	'unknownthumbnail' => { 395 => 'thmb' },
	'unsharp1color' => { 292 => 0x13 },
	'unsharp1halowidth' => { 292 => 0x19 },
	'unsharp1intensity' => { 292 => 0x17 },
	'unsharp1threshold' => { 292 => 0x1b },
	'unsharp2color' => { 292 => 0x2e },
	'unsharp2halowidth' => { 292 => 0x34 },
	'unsharp2intensity' => { 292 => 0x32 },
	'unsharp2threshold' => { 292 => 0x36 },
	'unsharp3color' => { 292 => 0x49 },
	'unsharp3halowidth' => { 292 => 0x4f },
	'unsharp3intensity' => { 292 => 0x4d },
	'unsharp3threshold' => { 292 => 0x51 },
	'unsharp4color' => { 292 => 0x64 },
	'unsharp4halowidth' => { 292 => 0x6a },
	'unsharp4intensity' => { 292 => 0x68 },
	'unsharp4threshold' => { 292 => 0x6c },
	'unsharpcount' => { 292 => 0x0 },
	'unsharpmask' => { 109 => 0x90, 287 => 0x76a43200 },
	'unsharpmaskfineness' => { 103 => 0x20309 },
	'unsharpmaskstrength' => { 103 => 0x20308 },
	'unsharpmaskthreshold' => { 103 => 0x2030a },
	'uprightcentermode' => { 494 => 'UprightCenterMode', 496 => 'UprightCenterMode' },
	'uprightcenternormx' => { 494 => 'UprightCenterNormX', 496 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 494 => 'UprightCenterNormY', 496 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 494 => 'UprightDependentDigest', 496 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 494 => 'UprightFocalLength35mm', 496 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 494 => 'UprightFocalMode', 496 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 494 => 'UprightFourSegments_0', 496 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 494 => 'UprightFourSegments_1', 496 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 494 => 'UprightFourSegments_2', 496 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 494 => 'UprightFourSegments_3', 496 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 494 => 'UprightFourSegmentsCount', 496 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 494 => 'UprightGuidedDependentDigest', 496 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 494 => 'UprightPreview', 496 => 'UprightPreview' },
	'uprighttransform_0' => { 494 => 'UprightTransform_0', 496 => 'UprightTransform_0' },
	'uprighttransform_1' => { 494 => 'UprightTransform_1', 496 => 'UprightTransform_1' },
	'uprighttransform_2' => { 494 => 'UprightTransform_2', 496 => 'UprightTransform_2' },
	'uprighttransform_3' => { 494 => 'UprightTransform_3', 496 => 'UprightTransform_3' },
	'uprighttransform_4' => { 494 => 'UprightTransform_4', 496 => 'UprightTransform_4' },
	'uprighttransform_5' => { 494 => 'UprightTransform_5', 496 => 'UprightTransform_5' },
	'uprighttransformcount' => { 494 => 'UprightTransformCount', 496 => 'UprightTransformCount' },
	'uprightversion' => { 494 => 'UprightVersion', 496 => 'UprightVersion' },
	'urgency' => { 131 => 0xa, 509 => 'Urgency' },
	'url' => { 157 => 'URL', 325 => 'URL', 384 => 0x40b, 511 => 'url' },
	'url_list' => { 384 => 0x41e },
	'urla-platform' => { 511 => [\'url','urlA-platform'] },
	'urlurl' => { 511 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 84 => 0x10a },
	'usableshootingmodes' => { 84 => 0x109 },
	'usage' => { 512 => 'usage' },
	'usageterms' => { 525 => 'UsageTerms' },
	'usbpowerdelivery' => { 238 => 0x664, 239 => 0x694 },
	'usedialwithouthold' => { 310 => 0xbf },
	'useguidelines' => { 492 => 'useGuidelines' },
	'usepanoramaviewer' => { 482 => 'UsePanoramaViewer' },
	'usercollection' => { 389 => 'collection.user' },
	'usercomment' => { 97 => 0x805, 119 => 0x9286, 500 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 70 => 0xd8, 71 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 70 => 0xda, 71 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 70 => 0xdc, 71 => 0xf4 },
	'userfields' => { 487 => 'UserFields' },
	'userlabel' => { 396 => 0x2b, 397 => 0x5a, 398 => 0x68 },
	'userprofile' => { 330 => 0x302, 334 => 0x34c, 337 => 0x3038 },
	'userrating' => { 389 => 'rating.user', 395 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 83 => 0x7, 84 => 0x501 },
	'uspsnumber' => { 511 => 'uspsNumber' },
	'utmeasting' => { 168 => 'Easting' },
	'utmmapdatum' => { 168 => 'Datum' },
	'utmnorthing' => { 168 => 'Northing' },
	'utmzone' => { 168 => 'Zone' },
	'uuid' => { 494 => 'UUID', 496 => 'UUID' },
	'uv-irfiltercorrection' => { 330 => 0x325 },
	'validbits' => { 316 => 0x611, 317 => 0x102c },
	'validpixeldepth' => { 320 => 0x611 },
	'variablelowpassfilter' => { 435 => 0x2028 },
	'variousmodes' => { 140 => 0x26 },
	'variousmodes2' => { 140 => 0x3a },
	'variprogram' => { 233 => 0xab },
	'varraydacnominalvalues' => { 138 => 0x191e },
	'vendor' => { 395 => 'vndr' },
	'vendorinfo' => { 473 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 473 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 473 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 473 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 118 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 127 => 0x0, 386 => 'Version', 389 => 'version', 494 => 'Version', 496 => 'Version' },
	'versioncreatedate' => { 470 => 0xd100 },
	'versionid' => { 522 => 'VersionID' },
	'versionidentifier' => { 511 => 'versionIdentifier' },
	'versionmodifydate' => { 470 => 0xd101 },
	'versions' => { 522 => 'Versions' },
	'versionscomments' => { 522 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 522 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 522 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 522 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 522 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 522 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 522 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 522 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 522 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 522 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 522 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 294 => '3.2', 295 => '47.2', 297 => '79.1', 310 => 0x11d },
	'verticalclockoverlaps' => { 138 => 0x412 },
	'verticalfuncbutton' => { 295 => '42.2', 297 => '67.1', 310 => 0x115 },
	'verticalfuncbuttonplaybackmode' => { 310 => 0x1b7 },
	'verticalfuncbuttonplusdials' => { 295 => '43.1' },
	'verticalfuncplusdials' => { 297 => '68.1' },
	'verticalmovieafonbutton' => { 310 => 0x1f9 },
	'verticalmoviefuncbutton' => { 310 => 0x1e1 },
	'verticalmultiselector' => { 295 => '42.1', 297 => '66.1', 298 => '66.1', 308 => '66.1', 310 => 0x18f },
	'verticalmultiselectorplaybackmode' => { 310 => 0x125 },
	'vfdisplayillumination' => { 2 => 0x11, 84 => [0x510,0x51d] },
	'vibrance' => { 488 => 'Vibrance', 494 => 'Vibrance', 496 => 'Vibrance' },
	'vibrationreduction' => { 259 => [0x75,0x82,0x1ae], 267 => '586.1', 274 => '590.2', 278 => 0x4 },
	'videoalphamode' => { 521 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 521 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 521 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 521 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 521 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 521 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 521 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 521 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 521 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 521 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 521 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 521 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 521 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 521 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 521 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 521 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 521 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 521 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 507 => 'videoBitRate' },
	'videobitratemode' => { 507 => 'videoBitRateMode' },
	'videoburstmode' => { 335 => 0xbb },
	'videoburstresolution' => { 335 => 0xb3 },
	'videocodec' => { 67 => 0x74 },
	'videocolorspace' => { 521 => 'videoColorSpace' },
	'videocompression' => { 127 => 0x3806 },
	'videocompressor' => { 521 => 'videoCompressor' },
	'videodisplayaspectratio' => { 507 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 507 => 'videoEncodingProfile' },
	'videofieldorder' => { 521 => 'videoFieldOrder' },
	'videoframerate' => { 335 => 0x27, 521 => 'videoFrameRate' },
	'videoframesize' => { 521 => 'videoFrameSize' },
	'videoframesizeh' => { 521 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 521 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 521 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 521 => 'videoModDate' },
	'videopixelaspectratio' => { 521 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 521 => 'videoPixelDepth' },
	'videopreburst' => { 335 => 0xc1 },
	'videoquality' => { 113 => 0x4003 },
	'videorecordingmode' => { 127 => 0x3803 },
	'videoshottype' => { 507 => 'VideoShotType' },
	'videoshottypeidentifier' => { 507 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 507 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 507 => 'videoStreamsCount' },
	'viewfinder' => { 379 => 0x455 },
	'viewfinderdisplay' => { 294 => '12.4', 295 => '6.3' },
	'viewfinderwarning' => { 294 => '13.4', 304 => '3.5', 305 => '6.2', 309 => '4.4' },
	'viewfinderwarnings' => { 84 => 0x40a },
	'viewinfoduringexposure' => { 84 => 0x407 },
	'viewingmode' => { 424 => 0x2f, 440 => 0x18 },
	'viewingmode2' => { 424 => [0x85,0x285] },
	'viewpoint' => { 510 => 'viewpoint' },
	'vignetteamount' => { 494 => 'VignetteAmount', 496 => 'VignetteAmount' },
	'vignettecontrol' => { 233 => 0x2a, 287 => 0x76a43205 },
	'vignettecontrolintensity' => { 287 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 491 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 494 => 'VignetteMidpoint', 496 => 'VignetteMidpoint' },
	'vignetting' => { 402 => 0x1011, 409 => 0xa052 },
	'vignettingcorrection' => { 119 => 0x7031, 409 => 0xa053, 435 => 0x2011 },
	'vignettingcorrparams' => { 119 => 0x7032, 465 => 0x64a, 466 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 409 => 0xa054 },
	'virtualhorizonstyle' => { 310 => 0x167 },
	'visualcolor' => { 507 => 'VisualColour' },
	'visualtechnique' => { 510 => 'visualTechnique' },
	'voicememo' => { 411 => 0x216 },
	'volume' => { 511 => 'volume' },
	'vr_0x66' => { 259 => 0x66 },
	'vrdoffset' => { 64 => 0xd0 },
	'vrmode' => { 238 => 0x212, 239 => 0x226, 278 => 0x6 },
	'vrtype' => { 278 => 0x8 },
	'waterdepth' => { 119 => 0x9403, 501 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 187 => 0x19a },
	'wb_bluelevel6500k' => { 187 => 0x18a },
	'wb_bluelevelcustom' => { 187 => 0x18e },
	'wb_bluelevelscloudy' => { 187 => 0x106 },
	'wb_bluelevelsdaylight' => { 187 => 0xea },
	'wb_bluelevelsflash' => { 187 => 0x122 },
	'wb_bluelevelsfluorescent' => { 187 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 187 => 0x254 },
	'wb_bluelevelsshade' => { 187 => 0x176 },
	'wb_bluelevelstungsten' => { 187 => 0xce },
	'wb_gbrglevels' => { 187 => 0xae, 190 => 0x4 },
	'wb_glevel' => { 316 => 0x11f },
	'wb_glevel3000k' => { 316 => 0x113 },
	'wb_glevel3300k' => { 316 => 0x114 },
	'wb_glevel3600k' => { 316 => 0x115 },
	'wb_glevel3900k' => { 316 => 0x116 },
	'wb_glevel4000k' => { 316 => 0x117 },
	'wb_glevel4300k' => { 316 => 0x118 },
	'wb_glevel4500k' => { 316 => 0x119 },
	'wb_glevel4800k' => { 316 => 0x11a },
	'wb_glevel5300k' => { 316 => 0x11b },
	'wb_glevel6000k' => { 316 => 0x11c },
	'wb_glevel6600k' => { 316 => 0x11d },
	'wb_glevel7500k' => { 316 => 0x11e },
	'wb_grbglevels' => { 203 => 0x0, 442 => 0x7303 },
	'wb_grbglevelsauto' => { 81 => 0x2, 442 => 0x7302 },
	'wb_grbglevelscloudy' => { 81 => 0x12 },
	'wb_grbglevelscustom1' => { 81 => 0x42 },
	'wb_grbglevelscustom2' => { 81 => 0x4a },
	'wb_grbglevelsdaylight' => { 81 => 0xa },
	'wb_grbglevelsflash' => { 81 => 0x32 },
	'wb_grbglevelsfluorescent' => { 81 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 81 => 0x2a },
	'wb_grbglevelstungsten' => { 81 => 0x1a },
	'wb_grbglevelsunderwater' => { 81 => 0x3a },
	'wb_rbgglevels' => { 200 => 0x0 },
	'wb_rblevels' => { 204 => 0x270, 233 => 0xc, 316 => 0x100 },
	'wb_rblevels1' => { 341 => 0x2 },
	'wb_rblevels2' => { 341 => 0x5 },
	'wb_rblevels3' => { 341 => 0x8 },
	'wb_rblevels3000k' => { 316 => 0x102 },
	'wb_rblevels3300k' => { 316 => 0x103 },
	'wb_rblevels3500k' => { 187 => 0x430 },
	'wb_rblevels3600k' => { 316 => 0x104 },
	'wb_rblevels3900k' => { 316 => 0x105 },
	'wb_rblevels4' => { 341 => 0xb },
	'wb_rblevels4000k' => { 316 => 0x106 },
	'wb_rblevels4300k' => { 316 => 0x107 },
	'wb_rblevels4500k' => { 316 => 0x108 },
	'wb_rblevels4800k' => { 316 => 0x109 },
	'wb_rblevels5' => { 341 => 0xe },
	'wb_rblevels5300k' => { 316 => 0x10a },
	'wb_rblevels6' => { 341 => 0x11 },
	'wb_rblevels6000k' => { 316 => 0x10b },
	'wb_rblevels6500k' => { 187 => 0x420 },
	'wb_rblevels6600k' => { 316 => 0x10c },
	'wb_rblevels7' => { 341 => 0x14 },
	'wb_rblevels7500k' => { 316 => 0x10d },
	'wb_rblevelsauto' => { 204 => 0x272, 320 => 0x110 },
	'wb_rblevelscloudy' => { 187 => 0x3f0, 189 => 0x10, 204 => 0x296, 320 => 0x121 },
	'wb_rblevelscoolwhitef' => { 187 => 0x308, 189 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 320 => 0x132 },
	'wb_rblevelscustom' => { 187 => 0x424, 189 => 0x1c },
	'wb_rblevelscwb1' => { 316 => 0x10e },
	'wb_rblevelscwb2' => { 316 => 0x10f },
	'wb_rblevelscwb3' => { 316 => 0x110 },
	'wb_rblevelscwb4' => { 316 => 0x111 },
	'wb_rblevelsdaylight' => { 187 => [0x3ec,0x528], 189 => 0xc, 204 => 0x274 },
	'wb_rblevelsdaylightf' => { 189 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 320 => 0x130 },
	'wb_rblevelsdaywhitef' => { 189 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 320 => 0x131 },
	'wb_rblevelseveningsunlight' => { 320 => 0x124 },
	'wb_rblevelsfineweather' => { 320 => 0x122 },
	'wb_rblevelsflash' => { 187 => [0x3f4,0x304], 189 => 0x18, 204 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 204 => 0x290 },
	'wb_rblevelsincandescent' => { 204 => 0x282 },
	'wb_rblevelsshade' => { 187 => 0x418, 189 => 0x20, 204 => 0x2b2, 320 => 0x120 },
	'wb_rblevelstungsten' => { 187 => 0x3e8, 189 => 0x8, 320 => 0x123 },
	'wb_rblevelsused' => { 320 => 0x100 },
	'wb_rblevelswhitef' => { 189 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 320 => 0x133 },
	'wb_redlevel3500k' => { 187 => 0x198 },
	'wb_redlevel6500k' => { 187 => 0x188 },
	'wb_redlevelcustom' => { 187 => 0x18c },
	'wb_redlevelscloudy' => { 187 => 0xf8 },
	'wb_redlevelsdaylight' => { 187 => 0xdc },
	'wb_redlevelsflash' => { 187 => 0x114 },
	'wb_redlevelsfluorescent' => { 187 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 187 => 0x1be },
	'wb_redlevelsshade' => { 187 => 0x168 },
	'wb_redlevelstungsten' => { 187 => 0xc0 },
	'wb_rgbglevels' => { 202 => 0x0 },
	'wb_rgblevels' => { 187 => [0x546,0x96], 331 => 0xd, 332 => 0x413, 337 => 0x3036, 379 => 0x107, 444 => 0x117c, 445 => 0x1180, 446 => 0x115c, 447 => 0x11d8, 448 => 0x11b4, 449 => 0x106c, 450 => 0x264, 451 => 0x264, 452 => 0x252 },
	'wb_rgblevels1' => { 342 => 0x2 },
	'wb_rgblevels2' => { 342 => 0x6 },
	'wb_rgblevels2500k' => { 442 => 0x782d },
	'wb_rgblevels3' => { 342 => 0xa },
	'wb_rgblevels3200k' => { 442 => 0x782c },
	'wb_rgblevels4' => { 342 => 0xe },
	'wb_rgblevels4500k' => { 442 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 342 => 0x12 },
	'wb_rgblevels6' => { 342 => 0x16 },
	'wb_rgblevels6000k' => { 442 => 0x782b },
	'wb_rgblevels7' => { 342 => 0x1a },
	'wb_rgblevels8500k' => { 442 => 0x782a },
	'wb_rgblevelsauto' => { 413 => 0x0 },
	'wb_rgblevelscloudy' => { 442 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 413 => 0x15 },
	'wb_rgblevelscustom2' => { 413 => 0x18 },
	'wb_rgblevelscustom3' => { 413 => 0x1b },
	'wb_rgblevelsdaylight' => { 413 => 0x3, 442 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 413 => 0x12, 442 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 413 => 0xf, 442 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 442 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 442 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 442 => 0x7828 },
	'wb_rgblevelsincandescent' => { 413 => 0xc },
	'wb_rgblevelsovercast' => { 413 => 0x9 },
	'wb_rgblevelsshade' => { 413 => 0x6, 442 => 0x7825 },
	'wb_rgblevelstungsten' => { 442 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 414 => 0x0 },
	'wb_rgblevelsunknown1' => { 414 => 0x3 },
	'wb_rgblevelsunknown2' => { 414 => 0x6 },
	'wb_rgblevelsunknown3' => { 414 => 0x9 },
	'wb_rgblevelsunknown4' => { 414 => 0xc },
	'wb_rgblevelsunknown5' => { 414 => 0xf },
	'wb_rgblevelsunknown6' => { 414 => 0x12 },
	'wb_rgblevelsunknown7' => { 414 => 0x15 },
	'wb_rgblevelsunknown8' => { 414 => 0x18 },
	'wb_rgblevelsunknown9' => { 414 => 0x1b },
	'wb_rgbmuldaylight' => { 138 => 0x852 },
	'wb_rgbmulflash' => { 138 => 0x855 },
	'wb_rgbmulfluorescent' => { 138 => 0x854 },
	'wb_rgbmultungsten' => { 138 => 0x853 },
	'wb_rggbblacklevels' => { 35 => 0x25 },
	'wb_rggblevels' => { 119 => 0x7313, 190 => 0x4, 201 => 0x0, 205 => 0x13e8, 206 => 0x38, 442 => 0x7313 },
	'wb_rggblevelsasshot' => { 38 => 0x0, 39 => 0x0, 40 => 0x19, 41 => 0x55, 42 => 0x69, 43 => 0x22, 44 => 0x3f, 47 => 0x3f, 48 => 0x3f, 49 => 0x3f, 50 => 0x47 },
	'wb_rggblevelsauto' => { 35 => 0x1, 38 => 0x5, 39 => 0x8, 40 => 0x1e, 41 => 0x5a, 42 => 0x6e, 43 => 0x18, 44 => 0x44, 47 => 0x44, 48 => 0x44, 49 => 0x44, 50 => 0x4c, 205 => 0x1478, 206 => 0x114, 409 => 0xa022, 442 => 0x7312 },
	'wb_rggblevelsblack' => { 409 => 0xa028 },
	'wb_rggblevelscloudy' => { 35 => 0xd, 38 => 0x1e, 39 => 0x30, 40 => 0x2d, 41 => 0xa0, 42 => 0xd7, 43 => 0x31, 44 => 0x58, 47 => 0x71, 48 => 0x8a, 49 => 0x8f, 50 => 0x92, 205 => 0x1408, 206 => 0x60, 370 => 0x20f, 378 => 0x14 },
	'wb_rggblevelscustom' => { 35 => 0x1d, 44 => 0x80, 205 => 0x1468, 206 => 0x100 },
	'wb_rggblevelscustom1' => { 40 => 0x41 },
	'wb_rggblevelscustom2' => { 40 => 0x46 },
	'wb_rggblevelsdaylight' => { 35 => 0x5, 38 => 0x14, 39 => 0x20, 40 => 0x23, 41 => 0x96, 42 => 0xcd, 43 => 0x27, 44 => 0x4e, 47 => 0x67, 48 => 0x80, 49 => 0x85, 50 => 0x88, 205 => 0x13f8, 206 => 0x4c, 370 => 0x20d, 378 => 0x2 },
	'wb_rggblevelsflash' => { 35 => 0x19, 38 => 0x32, 39 => 0x50, 40 => 0x3c, 41 => 0xb4, 42 => 0xeb, 43 => 0x45, 44 => 0x6c, 47 => 0x85, 48 => 0x9e, 49 => 0xa3, 50 => 0xa6, 205 => 0x1448, 370 => 0x214, 378 => 0x41 },
	'wb_rggblevelsfluorescent' => { 35 => 0x15, 38 => 0x28, 39 => 0x40, 40 => 0x37, 41 => 0xaa, 42 => 0xe1, 43 => 0x3b, 44 => 0x62, 47 => 0x7b, 48 => 0x94, 49 => 0x99, 50 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 206 => 0xc4, 370 => 0x211, 378 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 378 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 206 => 0xb0, 370 => 0x212, 378 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 205 => 0x1438, 206 => 0x9c, 370 => 0x213, 378 => 0x38 },
	'wb_rggblevelshtmercury' => { 206 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 409 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 409 => 0xa024 },
	'wb_rggblevelskelvin' => { 35 => 0x21, 38 => 0x2d, 39 => 0x48, 41 => 0xaf, 42 => 0xe6, 43 => 0x40, 44 => 0x67, 47 => 0x80, 48 => 0x99, 49 => 0x9e, 50 => 0xa1 },
	'wb_rggblevelsmeasured' => { 38 => 0xa, 39 => 0x10, 41 => 0x5f, 42 => 0x73, 44 => 0x49, 47 => 0x49, 48 => 0x49, 49 => 0x49, 50 => 0x51 },
	'wb_rggblevelspc1' => { 43 => 0x90, 44 => 0x71 },
	'wb_rggblevelspc2' => { 43 => 0x95, 44 => 0x76 },
	'wb_rggblevelspc3' => { 43 => 0x9a, 44 => 0x7b },
	'wb_rggblevelsshade' => { 35 => 0x9, 38 => 0x19, 39 => 0x28, 40 => 0x28, 41 => 0x9b, 42 => 0xd2, 43 => 0x2c, 44 => 0x53, 47 => 0x6c, 48 => 0x85, 49 => 0x8a, 50 => 0x8d, 206 => 0x74, 370 => 0x20e, 378 => 0xb },
	'wb_rggblevelstungsten' => { 35 => 0x11, 38 => 0x23, 39 => 0x38, 40 => 0x32, 41 => 0xa5, 42 => 0xdc, 43 => 0x36, 44 => 0x5d, 47 => 0x76, 48 => 0x8f, 49 => 0x94, 50 => 0x97, 205 => 0x1428, 206 => 0x88, 370 => 0x210, 378 => 0x1d },
	'wb_rggblevelsuncorrected' => { 409 => 0xa021 },
	'wb_rggblevelsunknown' => { 38 => 0xf, 39 => 0x18, 41 => 0x64, 42 => 0x78, 43 => 0x1d, 47 => 0x4e, 48 => 0x4e, 49 => 0x4e, 50 => 0x56, 378 => 0x53 },
	'wb_rggblevelsunknown10' => { 38 => 0x5f, 39 => 0x98, 41 => 0x91, 42 => 0xa5, 43 => 0x72, 47 => 0x9e, 48 => 0x7b, 49 => 0x7b, 50 => 0x83 },
	'wb_rggblevelsunknown11' => { 38 => 0x64, 39 => 0xa0, 41 => 0xb9, 42 => [0xaa,0xaf], 43 => 0x77, 47 => 0xa3, 48 => 0xa3, 49 => 0x80, 50 => 0xab },
	'wb_rggblevelsunknown12' => { 38 => 0x69, 39 => 0xa8, 41 => 0xbe, 42 => 0xb4, 43 => 0x7c, 47 => 0xa8, 48 => 0xa8, 49 => 0xa8, 50 => 0xb0 },
	'wb_rggblevelsunknown13' => { 38 => 0x6e, 39 => 0xb0, 41 => 0xc3, 42 => 0xb9, 43 => 0x81, 47 => 0xad, 48 => 0xad, 49 => 0xad, 50 => 0xb5 },
	'wb_rggblevelsunknown14' => { 41 => 0xc8, 42 => 0xbe, 43 => 0x86, 47 => 0xb2, 48 => 0xb2, 49 => 0xb2, 50 => 0xba },
	'wb_rggblevelsunknown15' => { 41 => 0xcd, 42 => 0xc3, 43 => 0x8b, 47 => 0xb7, 48 => 0xb7, 49 => 0xb7, 50 => 0xbf },
	'wb_rggblevelsunknown16' => { 41 => 0xd2, 42 => 0xc8, 43 => 0x9f, 48 => 0xbc, 49 => 0xbc, 50 => 0xc4 },
	'wb_rggblevelsunknown17' => { 41 => 0xd7, 42 => 0xf0, 48 => 0xc1, 49 => 0xc1, 50 => 0xc9 },
	'wb_rggblevelsunknown18' => { 41 => 0xdc, 42 => 0xf5, 48 => 0xc6, 49 => 0xc6, 50 => 0xce },
	'wb_rggblevelsunknown19' => { 41 => 0xe1, 42 => 0xfa, 48 => 0xcb, 49 => 0xcb, 50 => 0xd3 },
	'wb_rggblevelsunknown2' => { 38 => 0x37, 39 => 0x58, 41 => 0x69, 42 => 0x7d, 43 => 0x4a, 47 => 0x53, 48 => 0x53, 49 => 0x53, 50 => 0x5b },
	'wb_rggblevelsunknown20' => { 41 => 0xe6, 42 => 0xff, 48 => 0xd0, 49 => 0xd0, 50 => 0xd8 },
	'wb_rggblevelsunknown21' => { 41 => 0xeb, 42 => 0x104, 49 => 0xd5, 50 => 0xdd },
	'wb_rggblevelsunknown22' => { 41 => 0xf0, 42 => 0x109, 49 => 0xda, 50 => 0xe2 },
	'wb_rggblevelsunknown23' => { 41 => 0xf5, 42 => 0x10e, 49 => 0xdf, 50 => 0xe7 },
	'wb_rggblevelsunknown24' => { 41 => 0xfa, 42 => 0x113, 49 => 0xe4, 50 => 0xec },
	'wb_rggblevelsunknown25' => { 41 => 0xff, 42 => 0x118, 49 => 0xe9, 50 => 0xf1 },
	'wb_rggblevelsunknown26' => { 41 => 0x104, 42 => 0x11d, 49 => 0xee, 50 => 0xf6 },
	'wb_rggblevelsunknown27' => { 41 => 0x109, 42 => 0x122, 49 => 0xf3, 50 => 0xfb },
	'wb_rggblevelsunknown28' => { 41 => 0x10e, 49 => 0xf8, 50 => 0x100 },
	'wb_rggblevelsunknown29' => { 41 => 0x113, 49 => 0xfd, 50 => 0x105 },
	'wb_rggblevelsunknown3' => { 38 => 0x3c, 39 => 0x60, 41 => 0x6e, 42 => 0x82, 43 => 0x4f, 47 => 0x58, 48 => 0x58, 49 => 0x58, 50 => 0x60 },
	'wb_rggblevelsunknown30' => { 49 => 0x102 },
	'wb_rggblevelsunknown4' => { 38 => 0x41, 39 => 0x68, 41 => 0x73, 42 => 0x87, 43 => 0x54, 47 => 0x5d, 48 => 0x5d, 49 => 0x5d, 50 => 0x65 },
	'wb_rggblevelsunknown5' => { 38 => 0x46, 39 => 0x70, 41 => 0x78, 42 => 0x8c, 43 => 0x59, 47 => 0x62, 48 => 0x62, 49 => 0x62, 50 => 0x6a },
	'wb_rggblevelsunknown6' => { 38 => 0x4b, 39 => 0x78, 41 => 0x7d, 42 => 0x91, 43 => 0x5e, 47 => 0x8a, 48 => 0x67, 49 => 0x67, 50 => 0x6f },
	'wb_rggblevelsunknown7' => { 38 => 0x50, 39 => 0x80, 41 => 0x82, 42 => 0x96, 43 => 0x63, 47 => 0x8f, 48 => 0x6c, 49 => 0x6c, 50 => 0x74 },
	'wb_rggblevelsunknown8' => { 38 => 0x55, 39 => 0x88, 41 => 0x87, 42 => 0x9b, 43 => 0x68, 47 => 0x94, 48 => 0x71, 49 => 0x71, 50 => 0x79 },
	'wb_rggblevelsunknown9' => { 38 => 0x5a, 39 => 0x90, 41 => 0x8c, 42 => 0xa0, 43 => 0x6d, 47 => 0x99, 48 => 0x76, 49 => 0x76, 50 => 0x7e },
	'wb_rggblevelsuserselected' => { 378 => 0x5c },
	'wbadjblueamber' => { 103 => 0x20106 },
	'wbadjbluebalance' => { 293 => 0x8 },
	'wbadjcolortemp' => { 103 => 0x20102, 108 => 0x1a },
	'wbadjlighting' => { 293 => 0x14 },
	'wbadjmagentagreen' => { 103 => 0x20105 },
	'wbadjmode' => { 293 => 0x10 },
	'wbadjredbalance' => { 293 => 0x0 },
	'wbadjrggblevels' => { 103 => 0x20125, 108 => 0x6 },
	'wbadjtemperature' => { 293 => 0x18 },
	'wbadjtint' => { 293 => 0x25 },
	'wbbluelevel' => { 330 => 0x324, 335 => 0x8006, 340 => 0x26 },
	'wbbracketingsteps' => { 197 => 0x10, 198 => 0x10, 268 => 0x174d },
	'wbbracketmode' => { 57 => 0x9 },
	'wbbracketshotnumber' => { 187 => 0x2b, 402 => 0x101a },
	'wbbracketvalueab' => { 57 => 0xc },
	'wbbracketvaluegm' => { 57 => 0xd },
	'wbfinetuneactive' => { 108 => 0x24 },
	'wbfinetunesaturation' => { 108 => 0x28 },
	'wbfinetunetone' => { 108 => 0x2c },
	'wbgreenlevel' => { 330 => 0x323, 335 => 0x8005, 340 => 0x25 },
	'wbmediaimagesizesetting' => { 84 => 0x708 },
	'wbmode' => { 189 => 0x4, 317 => 0x1015 },
	'wbredlevel' => { 330 => 0x322, 335 => 0x8004, 340 => 0x24 },
	'wbscale' => { 190 => 0x0 },
	'wbshiftab' => { 74 => 0xc, 335 => 0x46, 352 => 0x10 },
	'wbshiftab_gm' => { 435 => 0x2014 },
	'wbshiftab_gm_precise' => { 435 => 0x2026 },
	'wbshiftcreativecontrol' => { 335 => 0x92 },
	'wbshiftgm' => { 74 => 0xd, 335 => 0x47, 352 => 0x11 },
	'wbshiftintelligentauto' => { 335 => 0x8b },
	'wbtype1' => { 341 => 0x1, 342 => 0x1 },
	'wbtype2' => { 341 => 0x4, 342 => 0x5 },
	'wbtype3' => { 341 => 0x7, 342 => 0x9 },
	'wbtype4' => { 341 => 0xa, 342 => 0xd },
	'wbtype5' => { 341 => 0xd, 342 => 0x11 },
	'wbtype6' => { 341 => 0x10, 342 => 0x15 },
	'wbtype7' => { 341 => 0x13, 342 => 0x19 },
	'webstatement' => { 525 => 'WebStatement' },
	'weightedflatsubject' => { 486 => 'weightedFlatSubject' },
	'what' => { 494 => 'What', 496 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 74 => 0x8, 77 => 0x7, 112 => 0x7, 113 => [0x19,0x2012], 119 => [0xa403,0xfe4e], 127 => 0x1002, 138 => 0x3fc, 139 => 0xfa0d, 140 => 0x40, 151 => 0x1a, 181 => 0x3, 182 => 0xe, 183 => 0x4, 184 => 0xb, 186 => 0x115, 233 => 0x5, 277 => 0x7, 330 => 0x304, 335 => 0x3, 337 => 0x3033, 370 => 0x19, 377 => 0x7, 401 => 0x26, 402 => 0x1003, 412 => [0x88,0x3c,0x7,0x58], 422 => 0xf, 423 => 0xe, 435 => [0x115,0xb054], 494 => 'WhiteBalance', 496 => 'WhiteBalance', 500 => 'WhiteBalance' },
	'whitebalance0' => { 176 => 'WhiteBalance0' },
	'whitebalance1' => { 176 => 'WhiteBalance1' },
	'whitebalance2' => { 176 => 'WhiteBalance2', 312 => 0x500 },
	'whitebalanceadj' => { 103 => 0x20101, 108 => 0x18, 287 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 348 => 0x0 },
	'whitebalancebias' => { 113 => 0x2011, 317 => 0x304, 335 => 0x23 },
	'whitebalanceblue' => { 74 => 0x7 },
	'whitebalancebracket' => { 312 => 0x502, 317 => 0x303 },
	'whitebalancebracketing' => { 184 => 0x22, 187 => 0x2c, 433 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 310 => 0x1c5 },
	'whitebalancecomp' => { 320 => 0x1001 },
	'whitebalancedetected' => { 138 => 0x3fb },
	'whitebalancefinetune' => { 127 => 0x100a, 184 => 0x38, 186 => 0x112, 233 => [0xb,0x3f], 402 => 0x1004, 422 => 0x6, 423 => 0x5, 435 => 0x112 },
	'whitebalancemode' => { 138 => 0x3fa, 370 => 0x1a },
	'whitebalancered' => { 74 => 0x6 },
	'whitebalanceset' => { 351 => 0xa },
	'whitebalancesetting' => { 184 => 0x23, 422 => 0x5, 423 => 0x4, 424 => 0x16, 440 => 0xd },
	'whitebalancesetup' => { 409 => 0x41 },
	'whitebalancetemperature' => { 312 => 0x501 },
	'whiteboard' => { 317 => 0x301 },
	'whitelevel' => { 119 => 0xc61d, 370 => 0x7e, 442 => 0x787f },
	'whitepoint' => { 119 => 0x13e, 334 => 0x35d, 370 => 0x201, 517 => 'WhitePoint' },
	'whites2012' => { 494 => 'Whites2012', 496 => 'Whites2012' },
	'whitesadj' => { 470 => 0x9017 },
	'wideadapter' => { 402 => 0x1017 },
	'widefocuszone' => { 181 => 0x2f },
	'widerange' => { 411 => 0x20f },
	'windmode' => { 138 => 0x3f4 },
	'windnoisereduction' => { 238 => 0x2d6, 239 => 0x2fe },
	'windowlocation' => { 395 => 'WLOC' },
	'windowsatom' => { 495 => 'windowsAtom' },
	'windowsatomextension' => { 495 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 495 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 495 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 511 => 'wordCount' },
	'work' => { 387 => "\xa9wrk" },
	'workcolorspace' => { 103 => 0x10200, 108 => 0x270 },
	'workflowtag' => { 507 => 'WorkflowTag' },
	'workflowtagcvid' => { 507 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 507 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 507 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 507 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 502 => 'WorkToDo' },
	'worldtimelocation' => { 335 => 0x3a, 370 => 0x22, 376 => '0.1' },
	'writer' => { 179 => 'WM/Writer' },
	'writer-editor' => { 131 => 0x7a },
	'x3filllight' => { 412 => 0x12 },
	'xattrquarantine' => { 174 => 'com.apple.quarantine' },
	'xilinxversion' => { 138 => 0x414 },
	'xml' => { 136 => 'xml ' },
	'xmp' => { 106 => 0xffff00f6, 120 => 'XMP' },
	'xmptoolkit' => { 518 => 'xmptk' },
	'xpauthor' => { 119 => 0x9c9d },
	'xpcomment' => { 119 => 0x9c9c },
	'xpkeywords' => { 119 => 0x9c9e },
	'xposition' => { 119 => 0x11e },
	'xpsubject' => { 119 => 0x9c9f },
	'xptitle' => { 119 => 0x9c9b },
	'xresolution' => { 119 => 0x11a, 134 => 0x3, 385 => 0x0, 517 => 'XResolution' },
	'xyresolution' => { 123 => 0x3 },
	'yaw' => { 115 => 0x7, 395 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 244 => 0x8, 407 => 0x0 },
	'ycbcrcoefficients' => { 119 => 0x211, 517 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 119 => 0x213, 517 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 119 => 0x212, 517 => 'YCbCrSubSampling' },
	'year' => { 387 => 'yrrc', 389 => 'year', 395 => 'yrrc' },
	'yearcreated' => { 140 => 0x10, 149 => 0xc },
	'yellowhsl' => { 103 => 0x20912 },
	'yield' => { 513 => 'yield' },
	'yposition' => { 119 => 0x11f },
	'yresolution' => { 119 => 0x11b, 134 => 0x5, 385 => 0x4, 517 => 'YResolution' },
	'zebrapatterntonerange' => { 310 => 0x211 },
	'zoneidentifier' => { 120 => 'ZoneIdentifier' },
	'zonematching' => { 186 => 0x10a, 189 => [0x3a,0x4a], 435 => 0xb024 },
	'zonematchingmode' => { 184 => 0x14 },
	'zonematchingon' => { 183 => 0x75 },
	'zonematchingvalue' => { 422 => 0x1f },
	'zoomedpreviewlength' => { 317 => 0xf05 },
	'zoomedpreviewsize' => { 317 => 0xf06 },
	'zoomedpreviewstart' => { 317 => 0xf04 },
	'zoomsourcewidth' => { 34 => 0x24 },
	'zoomstepcount' => { 315 => 0x300, 317 => 0x100d },
	'zoomtargetwidth' => { 34 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'amendlocalset' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz9' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatamd5' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumshutterangle' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rarversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcc-flp' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailref' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'thumbnailurl' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2023, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
