#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.18';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD850',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 105 => 0x69 },
	'about' => { 480 => 'about' },
	'aboutcvterm' => { 472 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 472 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 472 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 472 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 472 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 112 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 486 => 'absPeakAudioFilePath' },
	'academicfield' => { 476 => 'academicField' },
	'acceleration' => { 115 => 0x9404, 467 => 'Acceleration' },
	'accelerationtracking' => { 80 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 375 => 0x3 },
	'accelerometerx' => { 305 => 0x8d },
	'accelerometery' => { 305 => 0x8e },
	'accelerometerz' => { 305 => 0x8c },
	'accessoryserialnumber' => { 305 => 0x54 },
	'accessorytype' => { 305 => 0x53 },
	'actionadvised' => { 127 => 0x2a },
	'activearea' => { 115 => 0xc68d },
	'actived-lighting' => { 218 => 0x22, 256 => 0x24 },
	'actived-lightingmode' => { 256 => 0x25 },
	'adaptervoltage' => { 133 => 0x407 },
	'addaspectratioinfo' => { 80 => 0x80e },
	'addiptcinformation' => { 80 => 0x815 },
	'additionalmodelinformation' => { 472 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 80 => 0x80f, 81 => 0x11, 82 => 0x13, 85 => 0x14 },
	'address' => { 156 => 'Address' },
	'adjustmentmode' => { 382 => 0x15 },
	'adlbracketingstep' => { 237 => 0x883 },
	'adlbracketingtype' => { 237 => 0x884 },
	'adobe' => { 116 => 'Adobe' },
	'adultcontentwarning' => { 292 => 'AdultContentWarning', 479 => 'adultContentWarning' },
	'advancedfilter' => { 123 => 0x1201 },
	'advancedraw' => { 258 => 0x76a43203 },
	'advancedscenetype' => { 305 => 0x3d },
	'advisory' => { 484 => 'Advisory' },
	'ae_iso' => { 313 => 0x2, 314 => 0x4, 315 => 0x12 },
	'aeaperture' => { 313 => 0x1, 314 => 0x3, 315 => 0x11 },
	'aeaperturesteps' => { 313 => 0x8, 314 => 0xb },
	'aebautocancel' => { 80 => 0x104 },
	'aebbracketvalue' => { 74 => 0x11 },
	'aebracketingsteps' => { 236 => 0x174c, 237 => 0x87b, 245 => 0x1756 },
	'aebsequence' => { 80 => 0x105 },
	'aebsequenceautocancel' => { 78 => 0x9, 79 => 0x9, 81 => 0x8, 82 => 0x9, 85 => 0x9, 86 => 0x7 },
	'aebshotcount' => { 80 => 0x106 },
	'aebxv' => { 313 => 0x4, 314 => 0x6 },
	'aeerror' => { 314 => 0x8 },
	'aeexposuretime' => { 313 => 0x0, 314 => 0x2, 315 => 0x10 },
	'aelbutton' => { 178 => 0x45 },
	'aelexposureindicator' => { 178 => 0x51 },
	'aelock' => { 178 => 0x5b, 267 => '4.2', 276 => '4.2', 282 => 0x201, 340 => 0x48, 392 => 0x40, 393 => 0x40, 394 => [0x86,0x286] },
	'aelockbutton' => { 265 => '16.1', 267 => '4.1', 270 => '15.1', 271 => '16.1', 272 => '16.1', 274 => '30.1', 275 => '16.1', 276 => '4.1', 278 => '17.1', 280 => '17.1' },
	'aelockbuttonplusdials' => { 265 => '16.2', 274 => '32.1', 278 => '44.1' },
	'aelockformb-d80' => { 280 => '3.1' },
	'aelockmetermodeafterfocus' => { 80 => 0x114 },
	'aemaxaperture' => { 313 => 0x9, 314 => 0x10, 315 => 0x1c },
	'aemaxaperture2' => { 313 => 0xa, 314 => 0x11, 315 => 0x1d },
	'aemeteringmode' => { 313 => 0xc },
	'aemeteringmode2' => { 313 => '13.1' },
	'aemeteringsegments' => { 181 => 0x628, 340 => 0x209 },
	'aemicroadjustment' => { 80 => 0x110 },
	'aeminaperture' => { 313 => 0xb, 314 => 0x12, 315 => 0x1e },
	'aeminexposuretime' => { 313 => 0x5, 314 => 0x13, 315 => 0x1f },
	'aeprogrammode' => { 313 => 0x6 },
	'aeprojectlink' => { 461 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 461 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 461 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 461 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 461 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 461 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 34 => 0x21 },
	'aewhitebalance' => { 313 => 0xd },
	'aexv' => { 313 => 0x3, 314 => 0x5 },
	'af-cpriority' => { 124 => '0.2' },
	'af-cpriorityselection' => { 265 => '1.1', 266 => '1.1', 268 => '1.1', 269 => '1.1', 271 => '0.1', 272 => '0.1', 273 => '0.1', 274 => '1.1', 275 => '0.1', 278 => '1.1', 279 => '1.1' },
	'af-csetting' => { 120 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 120 => '0.2' },
	'af-ctrackingsensitivity' => { 120 => '0.1' },
	'af-czoneareaswitching' => { 120 => '0.3' },
	'af-onbutton' => { 268 => '70.1', 269 => '70.1', 279 => '70.1' },
	'af-onformb-d10' => { 265 => '3.3', 274 => '3.2' },
	'af-onformb-d11' => { 275 => '2.2' },
	'af-onformb-d12' => { 278 => '50.1' },
	'af-spriority' => { 124 => '0.1' },
	'af-spriorityselection' => { 265 => '1.2', 266 => '1.2', 268 => '1.2', 269 => '1.2', 273 => '0.2', 274 => '1.2', 275 => '0.2', 278 => '1.2', 279 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 265 => '2.1', 266 => '2.1', 268 => '78.3', 269 => '78.3', 274 => '2.1', 278 => '2.1', 279 => '78.3' },
	'afadjustment' => { 340 => 0x72, 349 => 0x267 },
	'afandmeteringbuttons' => { 80 => 0x701 },
	'afaperture' => { 211 => 0x5, 212 => 0x5, 216 => 0x5 },
	'afareaheight' => { 187 => [0x1a,0x34,0x50] },
	'afareaillumination' => { 178 => 0x4b, 276 => '15.3' },
	'afareamode' => { 122 => '0.2', 174 => 0x33, 178 => 0xe, 186 => 0x0, 187 => 0x5, 305 => 0xf, 372 => 0x1205, 385 => [0xa,0x3a], 392 => 0x11, 393 => 0x10, 394 => 0x24, 405 => 0xb043, 428 => 0x17 },
	'afareamodesetting' => { 267 => '11.1', 270 => '0.1', 276 => '16.1', 280 => '2.1', 405 => 0x201c },
	'afareapointsize' => { 122 => '0.3' },
	'afareas' => { 282 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 80 => 0x51b },
	'afareawidth' => { 187 => [0x18,0x32,0x4e] },
	'afareaxposition' => { 187 => [0x14,0x2e,0x4a], 372 => 0x1203 },
	'afareaxposition1' => { 372 => 0x1201 },
	'afareayposition' => { 187 => [0x16,0x30,0x4c], 372 => 0x1204 },
	'afareayposition1' => { 372 => 0x1202 },
	'afareazonesize' => { 122 => '0.4' },
	'afassist' => { 78 => 0x5, 86 => 0x5, 178 => 0x48, 265 => '2.5', 267 => '0.2', 270 => '0.2', 271 => '1.1', 272 => '1.1', 273 => '1.3', 274 => '2.4', 275 => '1.3', 276 => '0.2', 278 => '2.4', 280 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 80 => 0x50e, 81 => 0x4, 82 => 0x5, 83 => 0x4, 84 => 0x4, 85 => 0x5 },
	'afassistlamp' => { 305 => 0x31 },
	'afbuttonpressed' => { 394 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 316 => 0x6 },
	'afduringliveview' => { 80 => 0x511 },
	'affinea' => { 454 => 'AffineA' },
	'affineb' => { 454 => 'AffineB' },
	'affinec' => { 454 => 'AffineC' },
	'affined' => { 454 => 'AffineD' },
	'affinetune' => { 188 => 0x0, 282 => 0x306 },
	'affinetuneadj' => { 188 => 0x2, 229 => 0x2d1, 230 => 0x2dc, 282 => 0x307 },
	'affinetuneindex' => { 188 => 0x1 },
	'affinex' => { 454 => 'AffineX' },
	'affiney' => { 454 => 'AffineY' },
	'afhold' => { 316 => 0x1fd },
	'afilluminator' => { 392 => 0x29, 405 => 0xb044 },
	'afimageheight' => { 187 => [0x12,0x2c,0x48] },
	'afimagewidth' => { 187 => [0x10,0x2a,0x46] },
	'afintegrationtime' => { 316 => 0x7 },
	'afmicroadj' => { 385 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 389 => 0x131 },
	'afmicroadjregisteredlenses' => { 389 => '305.1' },
	'afmicroadjustment' => { 80 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 389 => 0x130 },
	'afmode' => { 109 => 0x3009, 123 => 0x1022, 174 => 0x16, 382 => 0x5 },
	'afmoderestrictions' => { 266 => '50.3', 268 => '48.3', 269 => '48.3', 278 => '48.3', 279 => '48.3' },
	'afonaelockbuttonswitch' => { 80 => 0x702 },
	'afonbutton' => { 265 => '3.1', 266 => '47.1' },
	'afpoint' => { 34 => 0x13, 108 => 0x18, 174 => 0x15, 186 => 0x1, 285 => 0x308, 382 => 0x1f, 385 => [0x37,0x7], 389 => 0x19, 390 => 0x18, 391 => [0x18,0x20] },
	'afpointactivationarea' => { 79 => 0x11, 85 => 0x11 },
	'afpointareaexpansion' => { 80 => 0x508 },
	'afpointatshutterrelease' => { 385 => [0x39,0x9] },
	'afpointautoselection' => { 80 => 0x50b },
	'afpointbrightness' => { 80 => 0x50d, 265 => '2.4', 266 => '46.5', 268 => '2.2', 269 => '2.2', 278 => '2.3', 279 => '2.2' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 80 => 0x50c },
	'afpointillumination' => { 79 => 0xa, 265 => '2.3', 266 => '46.2', 268 => '47.2', 269 => '47.2', 273 => '1.2', 274 => '2.3', 275 => '1.2', 278 => '47.2', 279 => '47.2', 280 => '2.4' },
	'afpointinfocus' => { 385 => [0x38,0x8] },
	'afpointmode' => { 321 => 0x3 },
	'afpointposition' => { 109 => 0x2021, 305 => 0x4d },
	'afpointregistration' => { 78 => 0x7 },
	'afpoints' => { 177 => 0x10 },
	'afpointselected' => { 178 => 0xd, 282 => 0x305, 340 => 0xe, 389 => 0x15, 390 => 0x14, 391 => [0x14,0x1c], 405 => 0x201e },
	'afpointselected2' => { 321 => 0x4 },
	'afpointselection' => { 79 => 0xb, 265 => '1.3', 266 => '1.3', 274 => '1.3', 278 => '1.3', 279 => '1.3' },
	'afpointselectionmethod' => { 80 => 0x50f, 81 => 0xc, 82 => 0xd, 85 => 0xd },
	'afpointsetting' => { 392 => 0x12, 393 => 0x11 },
	'afpointsinfocus' => { 74 => 0xe, 186 => 0x2, 316 => 0xb, 317 => 0x4, 340 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 79 => 0xd },
	'afpointsselected' => { 317 => '4.1', 436 => 0x4 },
	'afpointsspecial' => { 317 => '4.2' },
	'afpointsunknown1' => { 316 => 0x0 },
	'afpointsunknown2' => { 316 => 0x2 },
	'afpointsused' => { 187 => 0x8, 385 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 316 => 0x4 },
	'afresponse' => { 218 => 0xad },
	'afresult' => { 287 => 0x1038 },
	'afsearch' => { 282 => 0x303 },
	'afsensoractive' => { 174 => 0x1 },
	'afstatus' => { 372 => 0x1200 },
	'afstatus_00_b4' => { 388 => 0x0 },
	'afstatus_01_c4' => { 388 => 0x2 },
	'afstatus_02_d4' => { 388 => 0x4 },
	'afstatus_03_e4' => { 388 => 0x6 },
	'afstatus_04_f4' => { 388 => 0x8 },
	'afstatus_05_g4' => { 388 => 0xa },
	'afstatus_06_h4' => { 388 => 0xc },
	'afstatus_07_b3' => { 388 => 0xe },
	'afstatus_08_c3' => { 388 => 0x10 },
	'afstatus_09_d3' => { 388 => 0x12 },
	'afstatus_10_e3' => { 388 => 0x14 },
	'afstatus_11_f3' => { 388 => 0x16 },
	'afstatus_12_g3' => { 388 => 0x18 },
	'afstatus_13_h3' => { 388 => 0x1a },
	'afstatus_14_b2' => { 388 => 0x1c },
	'afstatus_15_c2' => { 388 => 0x1e },
	'afstatus_16_d2' => { 388 => 0x20 },
	'afstatus_17_e2' => { 388 => 0x22 },
	'afstatus_18_f2' => { 388 => 0x24 },
	'afstatus_19_g2' => { 388 => 0x26 },
	'afstatus_20_h2' => { 388 => 0x28 },
	'afstatus_21_c1' => { 388 => 0x2a },
	'afstatus_22_d1' => { 388 => 0x2c },
	'afstatus_23_e1' => { 388 => 0x2e },
	'afstatus_24_f1' => { 388 => 0x30 },
	'afstatus_25_g1' => { 388 => 0x32 },
	'afstatus_26_a7_vertical' => { 388 => 0x34 },
	'afstatus_27_a6_vertical' => { 388 => 0x36 },
	'afstatus_28_a5_vertical' => { 388 => 0x38 },
	'afstatus_29_c7_vertical' => { 388 => 0x3a },
	'afstatus_30_c6_vertical' => { 388 => 0x3c },
	'afstatus_31_c5_vertical' => { 388 => 0x3e },
	'afstatus_32_e7_vertical' => { 388 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 388 => 0x42 },
	'afstatus_34_e5_vertical' => { 388 => 0x44 },
	'afstatus_35_g7_vertical' => { 388 => 0x46 },
	'afstatus_36_g6_vertical' => { 388 => 0x48 },
	'afstatus_37_g5_vertical' => { 388 => 0x4a },
	'afstatus_38_i7_vertical' => { 388 => 0x4c },
	'afstatus_39_i6_vertical' => { 388 => 0x4e },
	'afstatus_40_i5_vertical' => { 388 => 0x50 },
	'afstatus_41_a7' => { 388 => 0x52 },
	'afstatus_42_b7' => { 388 => 0x54 },
	'afstatus_43_c7' => { 388 => 0x56 },
	'afstatus_44_d7' => { 388 => 0x58 },
	'afstatus_45_e7' => { 388 => 0x5a },
	'afstatus_46_f7' => { 388 => 0x5c },
	'afstatus_47_g7' => { 388 => 0x5e },
	'afstatus_48_h7' => { 388 => 0x60 },
	'afstatus_49_i7' => { 388 => 0x62 },
	'afstatus_50_a6' => { 388 => 0x64 },
	'afstatus_51_b6' => { 388 => 0x66 },
	'afstatus_52_c6' => { 388 => 0x68 },
	'afstatus_53_d6' => { 388 => 0x6a },
	'afstatus_54_e6_center' => { 388 => 0x6c },
	'afstatus_55_f6' => { 388 => 0x6e },
	'afstatus_56_g6' => { 388 => 0x70 },
	'afstatus_57_h6' => { 388 => 0x72 },
	'afstatus_58_i6' => { 388 => 0x74 },
	'afstatus_59_a5' => { 388 => 0x76 },
	'afstatus_60_b5' => { 388 => 0x78 },
	'afstatus_61_c5' => { 388 => 0x7a },
	'afstatus_62_d5' => { 388 => 0x7c },
	'afstatus_63_e5' => { 388 => 0x7e },
	'afstatus_64_f5' => { 388 => 0x80 },
	'afstatus_65_g5' => { 388 => 0x82 },
	'afstatus_66_h5' => { 388 => 0x84 },
	'afstatus_67_i5' => { 388 => 0x86 },
	'afstatus_68_c11' => { 388 => 0x88 },
	'afstatus_69_d11' => { 388 => 0x8a },
	'afstatus_70_e11' => { 388 => 0x8c },
	'afstatus_71_f11' => { 388 => 0x8e },
	'afstatus_72_g11' => { 388 => 0x90 },
	'afstatus_73_b10' => { 388 => 0x92 },
	'afstatus_74_c10' => { 388 => 0x94 },
	'afstatus_75_d10' => { 388 => 0x96 },
	'afstatus_76_e10' => { 388 => 0x98 },
	'afstatus_77_f10' => { 388 => 0x9a },
	'afstatus_78_g10' => { 388 => 0x9c },
	'afstatus_79_h10' => { 388 => 0x9e },
	'afstatus_80_b9' => { 388 => 0xa0 },
	'afstatus_81_c9' => { 388 => 0xa2 },
	'afstatus_82_d9' => { 388 => 0xa4 },
	'afstatus_83_e9' => { 388 => 0xa6 },
	'afstatus_84_f9' => { 388 => 0xa8 },
	'afstatus_85_g9' => { 388 => 0xaa },
	'afstatus_86_h9' => { 388 => 0xac },
	'afstatus_87_b8' => { 388 => 0xae },
	'afstatus_88_c8' => { 388 => 0xb0 },
	'afstatus_89_d8' => { 388 => 0xb2 },
	'afstatus_90_e8' => { 388 => 0xb4 },
	'afstatus_91_f8' => { 388 => 0xb6 },
	'afstatus_92_g8' => { 388 => 0xb8 },
	'afstatus_93_h8' => { 388 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 388 => 0xbc },
	'afstatusactivesensor' => { 174 => 0x2, 385 => [0x4,0x3b], 389 => 0x1e, 390 => 0x1b, 391 => [0x1b,0x21] },
	'afstatusbottom' => { 174 => 0x8, 389 => 0x2a, 390 => 0x21, 391 => 0x21 },
	'afstatusbottom-left' => { 174 => 0x12, 390 => 0x2b, 391 => 0x2b },
	'afstatusbottom-right' => { 174 => 0x6, 390 => 0x1f, 391 => 0x1f },
	'afstatusbottomassist-left' => { 389 => 0x28 },
	'afstatusbottomassist-right' => { 389 => 0x2c },
	'afstatusbottomhorizontal' => { 386 => 0x10, 387 => 0x1c },
	'afstatusbottomvertical' => { 386 => 0x16, 387 => 0x26 },
	'afstatuscenter-10' => { 389 => 0x34 },
	'afstatuscenter-11' => { 389 => 0x36 },
	'afstatuscenter-12' => { 389 => 0x38 },
	'afstatuscenter-14' => { 389 => 0x3c },
	'afstatuscenter-7' => { 389 => 0x2e },
	'afstatuscenter-9' => { 389 => 0x32 },
	'afstatuscenter-horizontal' => { 389 => 0x30 },
	'afstatuscenter-vertical' => { 389 => 0x3a },
	'afstatuscenterf2-8' => { 389 => 0x4c },
	'afstatuscenterhorizontal' => { 174 => 0x2f, 386 => 0xc, 387 => 0x18, 390 => 0x2f, 391 => 0x2f },
	'afstatuscentervertical' => { 174 => 0xc, 386 => 0x14, 387 => 0x22, 390 => 0x25, 391 => 0x25 },
	'afstatusfarleft' => { 386 => 0x6, 389 => 0x26 },
	'afstatusfarlefthorizontal' => { 387 => 0x4 },
	'afstatusfarleftvertical' => { 387 => 0x12 },
	'afstatusfarright' => { 386 => 0x18, 389 => 0x44 },
	'afstatusfarrighthorizontal' => { 387 => 0x2c },
	'afstatusfarrightvertical' => { 387 => 0x34 },
	'afstatusleft' => { 174 => 0x2d, 386 => 0x2, 389 => 0x22, 390 => 0x2d, 391 => 0x2d },
	'afstatuslefthorizontal' => { 387 => 0x6 },
	'afstatusleftvertical' => { 387 => 0xe },
	'afstatuslower-left' => { 386 => 0x4, 389 => 0x24 },
	'afstatuslower-lefthorizontal' => { 387 => 0xa },
	'afstatuslower-leftvertical' => { 387 => 0x10 },
	'afstatuslower-middle' => { 386 => 0x22, 387 => 0x24 },
	'afstatuslower-right' => { 386 => 0x1e, 389 => 0x4a },
	'afstatuslower-righthorizontal' => { 387 => 0x32 },
	'afstatuslower-rightvertical' => { 387 => 0x3a },
	'afstatuslowerfarleft' => { 387 => 0x8 },
	'afstatuslowerfarright' => { 387 => 0x30 },
	'afstatusmiddlehorizontal' => { 174 => 0xa, 390 => 0x23, 391 => 0x23 },
	'afstatusnearleft' => { 386 => 0xe, 387 => 0x1a },
	'afstatusnearright' => { 386 => 0xa, 387 => 0x16 },
	'afstatusright' => { 174 => 0x31, 386 => 0x1c, 389 => 0x48, 390 => 0x31, 391 => 0x31 },
	'afstatusrighthorizontal' => { 387 => 0x2e },
	'afstatusrightvertical' => { 387 => 0x38 },
	'afstatustop' => { 174 => 0xe, 389 => 0x40, 390 => 0x27, 391 => 0x27 },
	'afstatustop-left' => { 174 => 0x10, 390 => 0x29, 391 => 0x29 },
	'afstatustop-right' => { 174 => 0x4, 390 => 0x1d, 391 => 0x1d },
	'afstatustopassist-left' => { 389 => 0x3e },
	'afstatustopassist-right' => { 389 => 0x42 },
	'afstatustophorizontal' => { 386 => 0x8, 387 => 0x14 },
	'afstatustopvertical' => { 386 => 0x12, 387 => 0x1e },
	'afstatusupper-left' => { 386 => 0x0, 389 => 0x20 },
	'afstatusupper-lefthorizontal' => { 387 => 0x2 },
	'afstatusupper-leftvertical' => { 387 => 0xc },
	'afstatusupper-middle' => { 386 => 0x20, 387 => 0x20 },
	'afstatusupper-right' => { 386 => 0x1a, 389 => 0x46 },
	'afstatusupper-righthorizontal' => { 387 => 0x2a },
	'afstatusupper-rightvertical' => { 387 => 0x36 },
	'afstatusupperfarleft' => { 387 => 0x0 },
	'afstatusupperfarright' => { 387 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 405 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 385 => 0x2 },
	'afwithshutter' => { 392 => 0x2a },
	'aggregateissuenumber' => { 476 => 'aggregateIssueNumber' },
	'aggregationtype' => { 476 => 'aggregationType' },
	'agreement' => { 479 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 133 => 0xe4e },
	'aiservocontinuousshooting' => { 79 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 80 => 0x519 },
	'aiservoimagepriority' => { 80 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 80 => 0x51a },
	'aiservotrackingmethod' => { 80 => 0x504 },
	'aiservotrackingsensitivity' => { 79 => 0x14, 80 => 0x502 },
	'album' => { 357 => ['albm',"\xa9alb"], 359 => 'album', 365 => ['albm',"\xa9alb"], 486 => 'album' },
	'albumartist' => { 357 => 'aART', 365 => 'albr' },
	'albumtitleid' => { 357 => 'atID' },
	'alreadyapplied' => { 460 => 'AlreadyApplied', 462 => 'AlreadyApplied' },
	'alternatetitle' => { 476 => 'alternateTitle' },
	'alternatetitlea-lang' => { 476 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 476 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 476 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 189 => 0x6 },
	'alttapename' => { 486 => 'altTapeName' },
	'alttimecode' => { 486 => 'altTimecode' },
	'alttimecodetimeformat' => { 486 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 486 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 486 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 368 => 0x5c },
	'ambientlight' => { 368 => 0x5e },
	'ambienttemperature' => { 115 => 0x9400, 366 => 0x14, 367 => 0x46, 368 => 0x50, 428 => 0x4, 467 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 366 => 0x13, 367 => 0x44, 368 => 0x4e },
	'analogbalance' => { 115 => 0xc627 },
	'analogcaptureiso' => { 133 => 0x89e },
	'analogisotable' => { 133 => 0x89d },
	'androidversion' => { 359 => 'com.android.version' },
	'angleadj' => { 99 => 0x10003, 105 => 0x8b },
	'angleinforoll' => { 456 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 456 => 'AngleInfoYaw' },
	'anti-blur' => { 405 => 0xb04b },
	'antialiasstrength' => { 115 => 0xc632 },
	'aperturelock' => { 266 => '38.2', 268 => '38.2', 269 => '38.2', 278 => '38.2', 279 => '38.2' },
	'aperturemode' => { 365 => 'apmd' },
	'aperturerange' => { 80 => 0x10d },
	'apertureringuse' => { 321 => '1.4' },
	'aperturesetting' => { 178 => 0x7, 392 => 0x30, 393 => 0x29, 394 => 0x1 },
	'aperturevalue' => { 89 => 0x2, 115 => 0x9202, 287 => 0x1002, 349 => 0x401, 466 => 'ApertureValue' },
	'applekeywords' => { 291 => 'AAPL:Keywords' },
	'applestoreaccount' => { 357 => 'apID' },
	'applestoreaccounttype' => { 357 => 'akID' },
	'applestorecatalogid' => { 357 => 'cnID' },
	'applestorecountry' => { 357 => 'sfID' },
	'applicationkeystring' => { 133 => 0x400 },
	'applicationnotes' => { 115 => 0x2bc, 310 => 0x2bc },
	'applicationrecordversion' => { 127 => 0x0 },
	'applyshootingmeteringmode' => { 80 => 0x10e },
	'approved' => { 468 => 'Approved' },
	'approvedby' => { 468 => 'ApprovedBy' },
	'approximatefnumber' => { 300 => 0x313, 307 => 0x3406 },
	'approximatefocusdistance' => { 457 => 'ApproximateFocusDistance' },
	'appversion' => { 470 => 'AppVersion' },
	'aps-csizecapture' => { 423 => 0x114, 424 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 99 => 0x20914 },
	'armidentifier' => { 128 => 0x78 },
	'armversion' => { 128 => 0x7a },
	'arranger' => { 365 => "\xa9arg" },
	'arrangerkeywords' => { 365 => "\xa9ark" },
	'artfilter' => { 282 => 0x529 },
	'artfiltereffect' => { 282 => 0x52f },
	'artist' => { 115 => 0x13b, 295 => 'Artist', 340 => 0x22e, 357 => "\xa9ART", 359 => 'artist', 365 => "\xa9ART", 482 => 'Artist', 486 => 'artist' },
	'artmode' => { 109 => 0x301b },
	'artmodeparameters' => { 109 => 0x310b },
	'artwork' => { 359 => 'artwork' },
	'artworkcircadatecreated' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 472 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 472 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 286 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 286 => 0x1112, 340 => 0x80, 392 => 0x55, 393 => 0x55, 394 => 0xa },
	'assetid' => { 450 => 'AssetID' },
	'asshoticcprofile' => { 115 => 0xc68f },
	'asshotneutral' => { 115 => 0xc628 },
	'asshotpreprofilematrix' => { 115 => 0xc690 },
	'asshotprofilename' => { 115 => 0xc6f6 },
	'asshotwhitexy' => { 115 => 0xc629 },
	'assignbktbutton' => { 265 => '4.2', 266 => '16.1', 268 => '16.1', 269 => '16.1', 278 => '16.1', 279 => '16.1' },
	'assignfuncbutton' => { 80 => 0x70b },
	'assignmb-d17af-onbutton' => { 269 => '79.1' },
	'assignmb-d17funcbutton' => { 269 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 269 => '68.1' },
	'assignmb-d18af-onbutton' => { 279 => '79.1' },
	'assignmb-d18funcbutton' => { 279 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 279 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 268 => '75.1', 269 => '75.1', 279 => '75.1' },
	'assignmoviefunc2button' => { 268 => '82.1', 269 => '82.1', 279 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 268 => '75.2', 269 => '75.2', 279 => '75.2' },
	'assignmovierecordbutton' => { 266 => '43.2', 278 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 268 => '45.1', 269 => '45.1', 279 => '45.1' },
	'assignmoviesubselector' => { 268 => '74.1', 269 => '74.1', 279 => '74.1' },
	'assignmoviesubselectorplusdials' => { 268 => '76.1', 269 => '76.1', 279 => '76.1' },
	'assignremotefnbutton' => { 266 => '54.1', 278 => '51.1' },
	'assistbuttonfunction' => { 78 => 0xd },
	'atcaptureusercrop' => { 133 => 0x943 },
	'attributionname' => { 458 => 'attributionName' },
	'attributionurl' => { 458 => 'attributionURL' },
	'audio' => { 305 => 0x20 },
	'audiobitrate' => { 64 => 0x6c, 472 => 'audioBitRate' },
	'audiobitratemode' => { 472 => 'audioBitRateMode' },
	'audiobitspersample' => { 472 => 'audioBitsPerSample' },
	'audiochannelcount' => { 472 => 'audioChannelCount' },
	'audiochannels' => { 64 => 0x70 },
	'audiochanneltype' => { 486 => 'audioChannelType' },
	'audiocompression' => { 80 => 0x816, 150 => 'Compression' },
	'audiocompressor' => { 486 => 'audioCompressor' },
	'audiodata' => { 442 => 'Data' },
	'audioduration' => { 127 => 0x99 },
	'audiogain' => { 359 => 'player.movie.audio.gain' },
	'audiomimetype' => { 442 => 'Mime' },
	'audiomoddate' => { 486 => 'audioModDate' },
	'audiooutcue' => { 127 => 0x9a },
	'audiosamplerate' => { 64 => 0x6e, 486 => 'audioSampleRate' },
	'audiosampletype' => { 486 => 'audioSampleType' },
	'audiosamplingrate' => { 127 => 0x97 },
	'audiosamplingresolution' => { 127 => 0x98 },
	'audiotype' => { 127 => 0x96 },
	'author' => { 152 => 'Author', 291 => 'Author', 295 => 'Author', 356 => 'Author', 357 => ['auth',"\xa9aut"], 359 => 'author', 365 => 'auth', 455 => 'author', 473 => 'Author', 484 => 'Author' },
	'authorsposition' => { 474 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 80 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 331 => '0.1' },
	'autobracket' => { 382 => 0x19 },
	'autobracketing' => { 123 => 0x1100, 340 => 0x18, 372 => 0x1007 },
	'autobracketingmode' => { 277 => '12.3' },
	'autobracketingset' => { 277 => '12.1' },
	'autobracketmodem' => { 265 => '21.2', 266 => '13.3', 268 => '13.2', 269 => '13.2', 274 => '26.2', 278 => '13.3', 279 => '13.2' },
	'autobracketorder' => { 178 => 0x43, 265 => '21.3', 266 => '13.2', 268 => '13.1', 269 => '13.1', 274 => '26.3', 275 => '12.2', 276 => '2.2', 277 => '12.2', 278 => '13.2', 279 => '13.1', 280 => '13.2' },
	'autobracketset' => { 265 => '21.1', 266 => '13.1', 270 => '11.1', 271 => '12.1', 272 => '12.1', 274 => '26.1', 275 => '12.1', 276 => '2.1', 278 => '13.1', 280 => '13.1' },
	'autobrightness' => { 460 => 'AutoBrightness', 462 => 'AutoBrightness' },
	'autocontrast' => { 460 => 'AutoContrast', 462 => 'AutoContrast' },
	'autodistortioncontrol' => { 199 => 0x4 },
	'autodynamicrange' => { 123 => 0x140b },
	'autoexposure' => { 460 => 'AutoExposure', 462 => 'AutoExposure' },
	'autoexposurebracketing' => { 74 => 0x10 },
	'autoflashisosensitivity' => { 268 => '38.5', 269 => '38.5', 279 => '38.5' },
	'autofocus' => { 285 => 0x209 },
	'autofp' => { 276 => '7.3', 280 => '31.4' },
	'autoiso' => { 74 => 0x1, 109 => 0x3008, 267 => '1.1', 276 => '1.1' },
	'autoisomax' => { 267 => '1.2', 276 => '1.2' },
	'autoisominshutterspeed' => { 267 => '1.3', 276 => '1.3' },
	'autolateralca' => { 460 => 'AutoLateralCA', 462 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 60 => 0x2, 80 => 0x204, 99 => 0x20500, 105 => 0x6f },
	'autolightingoptimizeron' => { 99 => '0x20500.0', 105 => 0x6e },
	'autoportraitframed' => { 405 => 0x2016 },
	'autoredeye' => { 258 => 0xfe28a44f },
	'autorotate' => { 74 => 0x1b },
	'autoshadows' => { 460 => 'AutoShadows', 462 => 'AutoShadows' },
	'autotone' => { 460 => 'AutoTone', 462 => 'AutoTone' },
	'autowhiteversion' => { 460 => 'AutoWhiteVersion', 462 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 218 => 0x82 },
	'avaperturesetting' => { 321 => 0x13 },
	'averageblacklevel' => { 43 => 0xe7, 45 => 0xfb, 46 => 0x114, 47 => 0x146 },
	'averagelv' => { 181 => 0x38 },
	'avsettingwithoutlens' => { 80 => 0x707 },
	'azimuth' => { 160 => 'Azimuth' },
	'babyage' => { 305 => [0x8010,0x33] },
	'babyname' => { 305 => 0x66 },
	'backgroundalpha' => { 481 => 'bgalpha' },
	'balance' => { 359 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 321 => 0x15 },
	'baseiso' => { 74 => 0x2, 93 => 0x101c, 133 => 0x903, 307 => 0x312a, 434 => 0x6 },
	'baseisodaylight' => { 133 => 0x910 },
	'baseisoflash' => { 133 => 0x913 },
	'baseisofluorescent' => { 133 => 0x912 },
	'baseisotungsten' => { 133 => 0x911 },
	'baselineexposure' => { 115 => 0xc62a },
	'baselineexposureoffset' => { 115 => 0xc7a5 },
	'baselinenoise' => { 115 => 0xc62b },
	'baselinesharpness' => { 115 => 0xc62c },
	'baseurl' => { 484 => 'BaseURL' },
	'bass' => { 359 => 'player.movie.audio.bass' },
	'batterylevel' => { 392 => 0x51, 396 => 0xc, 397 => 0x4, 398 => 0x4, 435 => 0x7 },
	'batterylevelgrip1' => { 435 => 0x6 },
	'batterylevelgrip2' => { 435 => 0x8 },
	'batteryorder' => { 265 => '12.5', 274 => '13.2', 275 => '2.1', 278 => '3.1' },
	'batterystate' => { 178 => 0x60, 392 => 0x50, 398 => 0x14 },
	'batterytemperature' => { 396 => 0x1, 398 => 0x2, 435 => 0x5 },
	'batterytype' => { 61 => 0x38, 368 => 0x66 },
	'batteryunknown' => { 396 => 0x2, 398 => 0x0 },
	'batteryvoltage' => { 133 => 0x408, 366 => 0x2a, 367 => 0x49, 368 => 0x62, 396 => 0x8 },
	'batteryvoltage1' => { 398 => 0x6 },
	'batteryvoltage2' => { 398 => 0x8 },
	'batteryvoltageavg' => { 368 => 0x64 },
	'bayergreensplit' => { 115 => 0xc62d },
	'bayerpattern' => { 132 => 0xf902, 182 => 0x17 },
	'beatsperminute' => { 357 => 'tmpo' },
	'beatspliceparams' => { 486 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 486 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 486 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 486 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 486 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 486 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 265 => '13.1', 266 => '5.4', 267 => '0.1', 270 => '2.1', 271 => '3.1', 272 => '3.1', 274 => '10.1', 276 => '0.1', 278 => '5.5', 280 => '4.1' },
	'beeppitch' => { 275 => '3.1' },
	'beepvolume' => { 275 => '4.5' },
	'bestqualityscale' => { 115 => 0xc65c },
	'bestshotmode' => { 109 => 0x3007 },
	'bitdepth' => { 157 => 'BitDepth', 182 => 0x11, 226 => 0x41 },
	'bitspercomponent' => { 129 => 0x87 },
	'bitspersample' => { 115 => 0x102, 310 => 0xa, 482 => 'BitsPerSample' },
	'blackacquirerows' => { 133 => 0x18ba },
	'blacklevel' => { 115 => 0xc61a, 197 => 0x20, 218 => 0x3d, 287 => [0x401,0x1012], 349 => 0x21d },
	'blacklevel2' => { 286 => 0x600, 290 => 0x600 },
	'blacklevelblue' => { 310 => 0x1e },
	'blacklevelbottom' => { 133 => 0x3f0 },
	'blackleveldata' => { 349 => 0x223 },
	'blackleveldeltah' => { 115 => 0xc61b },
	'blackleveldeltav' => { 115 => 0xc61c },
	'blacklevelgreen' => { 310 => 0x1d },
	'blacklevelred' => { 310 => 0x1c },
	'blacklevelrepeatdim' => { 115 => 0xc619 },
	'blacklevelrough' => { 133 => 0x40e },
	'blacklevelroughafter' => { 133 => 0x416 },
	'blacklevels' => { 35 => 0x1d },
	'blackleveltop' => { 133 => 0x3ef },
	'blackpoint' => { 340 => 0x200 },
	'blacks2012' => { 460 => 'Blacks2012', 462 => 'Blacks2012' },
	'blacksadj' => { 438 => 0x9018 },
	'bleachbypasstoning' => { 340 => 0x7f },
	'blockshotafresponse' => { 268 => '1.5', 269 => '1.5', 279 => '1.5' },
	'blogtitle' => { 476 => 'blogTitle' },
	'blogurl' => { 476 => 'blogURL' },
	'bluebalance' => { 287 => 0x1018, 310 => 0x12, 340 => 0x1b },
	'bluecurvelimits' => { 104 => 0x1fe },
	'bluecurvepoints' => { 103 => 0x79, 104 => 0x1d4 },
	'bluehsl' => { 99 => 0x20915 },
	'bluehue' => { 460 => 'BlueHue', 462 => 'BlueHue' },
	'bluesaturation' => { 460 => 'BlueSaturation', 462 => 'BlueSaturation' },
	'bluratinfinity' => { 446 => 'BlurAtInfinity' },
	'blurcontrol' => { 340 => 0x82 },
	'blurwarning' => { 123 => 0x1300 },
	'bodybatteryadload' => { 319 => 0x3 },
	'bodybatteryadnoload' => { 319 => 0x2 },
	'bodybatterystate' => { 319 => '1.1' },
	'bodybatteryvoltage1' => { 319 => 0x2 },
	'bodybatteryvoltage2' => { 319 => 0x4 },
	'bodybatteryvoltage3' => { 319 => 0x6 },
	'bodybatteryvoltage4' => { 319 => 0x8 },
	'bodyfirmware' => { 373 => 0x0 },
	'bodyfirmwareversion' => { 283 => 0x104, 284 => 0x100, 287 => 0x104 },
	'bodyserialnumber' => { 373 => 0x10 },
	'bookedition' => { 476 => 'bookEdition' },
	'bootloaderversion' => { 367 => 0x26 },
	'bracketmode' => { 55 => 0x3 },
	'bracketsequence' => { 109 => 0x301d },
	'bracketsettings' => { 305 => 0x45 },
	'bracketshotnumber' => { 55 => 0x5, 321 => 0x9, 403 => 0x2b },
	'bracketshotnumber2' => { 403 => 0x2d },
	'bracketstep' => { 175 => 0xe },
	'bracketvalue' => { 55 => 0x4 },
	'brightness' => { 115 => 0xfe53, 151 => 'Brightness', 171 => 'Brightness', 175 => 0x2c, 220 => 0x34, 221 => 0x39, 222 => 0x41, 359 => 'player.movie.visual.brightness', 366 => 0x25, 368 => 0x54, 392 => 0x22, 405 => 0x2007, 460 => 'Brightness', 462 => 'Brightness' },
	'brightnessadj' => { 104 => 0x114, 251 => 0x0, 261 => 0x2d, 438 => 0x8018 },
	'brightnessvalue' => { 115 => 0x9203, 181 => [0x691,0x49c3], 287 => 0x1003, 410 => 0x1e, 413 => 0x1140, 414 => 0x1140, 415 => 0x111c, 416 => 0x1198, 417 => 0x1174, 418 => 0x102c, 419 => 0x224, 420 => 0x224, 421 => 0x219, 466 => 'BrightnessValue' },
	'buildnumber' => { 185 => 0x5500 },
	'bulbduration' => { 74 => 0x18 },
	'burstcount' => { 133 => 0x40d },
	'burstid' => { 443 => 'BurstID' },
	'burstmode' => { 135 => 0xa, 305 => 0x2a },
	'burstmode2' => { 135 => 0x18 },
	'burstprimary' => { 443 => 'BurstPrimary' },
	'burstshot' => { 382 => 0x34 },
	'burstspeed' => { 305 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 80 => 0x70a },
	'bwadjustment' => { 123 => 0x1049 },
	'bwfilter' => { 175 => 0x2a, 183 => 0x39 },
	'bwmode' => { 287 => 0x203 },
	'by-line' => { 127 => 0x50 },
	'by-linetitle' => { 127 => 0x55 },
	'bytecount' => { 476 => 'byteCount' },
	'c14configuration' => { 133 => 0x1964 },
	'cacheversion' => { 115 => 0xc7aa },
	'calibratedfocallength' => { 112 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 112 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 112 => 'CalibratedOpticalCenterY' },
	'calibration' => { 382 => [0x24,0x30] },
	'calibrationhistory' => { 133 => 0x9c9 },
	'calibrationilluminant1' => { 115 => 0xc65a },
	'calibrationilluminant2' => { 115 => 0xc65b },
	'calibrationversion' => { 133 => 0x9c6 },
	'callforimage' => { 450 => 'CallForImage' },
	'cameraangle' => { 365 => 'angl', 486 => 'cameraAngle' },
	'cameraburstid' => { 444 => 'CameraBurstID' },
	'cameracalibration' => { 382 => 0x11f },
	'cameracalibration1' => { 115 => 0xc623 },
	'cameracalibration2' => { 115 => 0xc624 },
	'cameracalibrationsig' => { 115 => 0xc6f3 },
	'cameracolorcalibration01' => { 36 => 0x0, 37 => 0x0 },
	'cameracolorcalibration02' => { 36 => 0x4, 37 => 0x5 },
	'cameracolorcalibration03' => { 36 => 0x8, 37 => 0xa },
	'cameracolorcalibration04' => { 36 => 0xc, 37 => 0xf },
	'cameracolorcalibration05' => { 36 => 0x10, 37 => 0x14 },
	'cameracolorcalibration06' => { 36 => 0x14, 37 => 0x19 },
	'cameracolorcalibration07' => { 36 => 0x18, 37 => 0x1e },
	'cameracolorcalibration08' => { 36 => 0x1c, 37 => 0x23 },
	'cameracolorcalibration09' => { 36 => 0x20, 37 => 0x28 },
	'cameracolorcalibration10' => { 36 => 0x24, 37 => 0x2d },
	'cameracolorcalibration11' => { 36 => 0x28, 37 => 0x32 },
	'cameracolorcalibration12' => { 36 => 0x2c, 37 => 0x37 },
	'cameracolorcalibration13' => { 36 => 0x30, 37 => 0x3c },
	'cameracolorcalibration14' => { 36 => 0x34, 37 => 0x41 },
	'cameracolorcalibration15' => { 36 => 0x38, 37 => 0x46 },
	'cameradirection' => { 359 => 'direction.facing' },
	'camerae-mountversion' => { 437 => 0xb },
	'cameraelevationangle' => { 115 => 0x9405, 467 => 'CameraElevationAngle' },
	'camerafilename' => { 450 => 'CameraFilename' },
	'cameraid' => { 287 => 0x209, 365 => 'cmid', 381 => 0x209 },
	'cameraidentifier' => { 359 => 'camera.identifier' },
	'cameraiso' => { 34 => 0x10 },
	'cameralabel' => { 115 => 0xc7a1, 486 => 'cameraLabel' },
	'cameramakemodel' => { 450 => 'CameraMakeModel' },
	'cameramodel' => { 349 => 0x410, 486 => 'cameraModel' },
	'cameramodelid' => { 171 => 'CameraModelID' },
	'cameramotion' => { 359 => 'direction.motion' },
	'cameramove' => { 486 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => 0x36, 24 => 0x7d, 25 => 0x83, 26 => 0x84, 28 => 0x35, 29 => 0x96, 305 => 0x8f, 344 => 0x1, 349 => 0x100, 398 => [0x16,0x18], 425 => 0x28, 426 => 0x24, 427 => 0x29 },
	'cameraowner' => { 136 => 0xc353 },
	'cameraparameters' => { 287 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 111 => 0x9, 365 => "\xa9gpt" },
	'cameraprofile' => { 460 => 'CameraProfile', 462 => 'CameraProfile' },
	'cameraprofiledigest' => { 460 => 'CameraProfileDigest', 462 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 105 => 0xe1 },
	'camerarawcontrast' => { 105 => 0xe3 },
	'camerarawhighlightpoint' => { 105 => 0xe6 },
	'camerarawlinear' => { 105 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 105 => 0xe8 },
	'camerarawoutputshadowpoint' => { 105 => 0xe9 },
	'camerarawsaturation' => { 105 => 0xe2 },
	'camerarawshadowpoint' => { 105 => 0xe7 },
	'camerarawsharpness' => { 105 => 0xe5 },
	'cameraroll' => { 111 => 0xb, 365 => "\xa9grl" },
	'cameraserialnumber' => { 115 => 0xc62f, 173 => 'CameraSerialNumber', 450 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 282 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 30 => [0x87,0x91], 31 => [0x99,0x9f,0xa4,0xa8,0x105], 33 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 74 => 0xc, 133 => 0x406, 286 => 0x1306, 300 => 0x320, 307 => 0x3402, 340 => 0x47, 379 => 0x43, 429 => 0x5 },
	'cameratemperature4' => { 345 => 0x14 },
	'cameratemperature5' => { 345 => 0x16 },
	'cameratemperaturerangemax' => { 117 => 0x5 },
	'cameratemperaturerangemin' => { 117 => 0x6 },
	'cameratype' => { 74 => 0x1a, 287 => 0x207 },
	'cameratype2' => { 283 => 0x100 },
	'camerayaw' => { 111 => 0xa, 365 => "\xa9gyw" },
	'camreverse' => { 112 => 'CamReverse' },
	'canondr4' => { 116 => 'CanonDR4' },
	'canonexposuremode' => { 34 => 0x14 },
	'canonfiledescription' => { 93 => 0x805 },
	'canonfilelength' => { 61 => 0xe },
	'canonfirmwareversion' => { 61 => 0x7, 93 => 0x80b },
	'canonflashinfo' => { 93 => 0x1028 },
	'canonflashmode' => { 34 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 34 => 0xa },
	'canonimagetype' => { 61 => 0x6, 93 => 0x815 },
	'canonmodelid' => { 61 => 0x10, 93 => 0x1834 },
	'canonvrd' => { 116 => 'CanonVRD' },
	'caption' => { 455 => 'caption' },
	'caption-abstract' => { 127 => 0x78 },
	'captionsauthornames' => { 465 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 465 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 474 => 'CaptionWriter' },
	'captureframerate' => { 109 => 0x4001 },
	'captureheightnormal' => { 133 => 0x1839 },
	'capturelook' => { 133 => 0xc48 },
	'capturemode' => { 359 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 448 => 'CaptureSoftware' },
	'capturewidthnormal' => { 133 => 0x1838 },
	'capturewidthtest' => { 133 => 0x1842 },
	'cardshutterlock' => { 178 => 0x49 },
	'casioimagesize' => { 109 => 0x9 },
	'catalogsets' => { 127 => 0xff, 441 => 'CatalogSets', 453 => 'CatalogSets' },
	'categories' => { 61 => 0x23, 455 => 'categories' },
	'category' => { 127 => 0xf, 281 => 0x30, 357 => 'catg', 474 => 'Category' },
	'cbcrgain' => { 379 => 0xa036 },
	'cbcrgaindefault' => { 379 => 0xa035 },
	'cbcrmatrix' => { 379 => 0xa034 },
	'cbcrmatrixdefault' => { 379 => 0xa033 },
	'ccdboardversion' => { 300 => 0x331 },
	'ccdscanmode' => { 287 => 0x1039 },
	'ccdsensitivity' => { 248 => 0x6 },
	'ccdversion' => { 300 => 0x330 },
	'cellglobalid' => { 459 => 'cgi' },
	'celllength' => { 115 => 0x109 },
	'cellr' => { 459 => 'r' },
	'celltowerid' => { 459 => 'cellid' },
	'cellwidth' => { 115 => 0x108 },
	'centerafarea' => { 276 => '15.1' },
	'centerfocuspoint' => { 280 => '2.2' },
	'centerpixel' => { 133 => 0x40c },
	'centerweightedareasize' => { 265 => '7.1', 266 => '8.1', 268 => '8.1', 269 => '8.1', 273 => '7.1', 274 => '5.1', 275 => '7.1', 276 => '6.3', 278 => '8.1', 279 => '8.1', 280 => '8.1' },
	'certificate' => { 490 => 'Certificate' },
	'cfainterpolationalgorithm' => { 133 => 0xe60 },
	'cfainterpolationmetric' => { 133 => 0xe61 },
	'cfaoffsetcols' => { 133 => 0xc71 },
	'cfaoffsetrows' => { 133 => 0xc6f },
	'cfapattern' => { 115 => 0xa302, 310 => 0x9, 466 => 'CFAPattern' },
	'cfapattern2' => { 115 => 0x828e },
	'cfapatterncolumns' => { 466 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 466 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 466 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 115 => 0x828d },
	'cfazipperfixthreshold' => { 133 => 0xe62 },
	'channel' => { 476 => 'channel' },
	'channela-lang' => { 476 => [\'channel','channelA-lang'] },
	'channelchannel' => { 476 => [\'channel','channelChannel'] },
	'channels' => { 150 => 'Channels' },
	'channelsubchannel1' => { 476 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 476 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 476 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 476 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 365 => 'chpl' },
	'checkmark' => { 99 => 0x10101, 104 => 0x26a },
	'checkmark2' => { 105 => 0x8e },
	'childfontfiles' => { 491 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 265 => '10.3', 266 => '11.2' },
	'chromablurradius' => { 115 => 0xc631 },
	'chromanoisecolorspace' => { 133 => 0xe6d },
	'chromanoiseedgemapthresh' => { 133 => 0xe6c },
	'chromanoisehighfthresh' => { 133 => 0xe6a },
	'chromanoiselowfthresh' => { 133 => 0xe6b },
	'chromaticaberration' => { 99 => 0x20703, 105 => 0x66, 379 => 0xa051 },
	'chromaticaberrationb' => { 460 => 'ChromaticAberrationB', 462 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 99 => 0x20708, 105 => 0x6b },
	'chromaticaberrationcorr' => { 76 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 115 => 0x7034, 330 => 0x1, 438 => 0x900d },
	'chromaticaberrationcorrparams' => { 115 => 0x7035, 433 => 0x66a, 434 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 99 => '0x20703.0', 105 => 0x62 },
	'chromaticaberrationr' => { 460 => 'ChromaticAberrationR', 462 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 99 => 0x20707, 105 => 0x6a },
	'chromaticaberrationsetting' => { 77 => 0x6 },
	'chrominancenoisereduction' => { 99 => 0x20601, 105 => 0x5e, 382 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 105 => 0x60 },
	'circadatecreated' => { 472 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 460 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 460 => 'CircularGradientBasedCorrections', 462 => 'CircularGradientBasedCorrections' },
	'city' => { 127 => 0x5a, 156 => 'City', 305 => 0x6d, 474 => 'City' },
	'city2' => { 305 => 0x80 },
	'clarity' => { 221 => 0x35, 222 => 0x3d, 460 => 'Clarity', 462 => 'Clarity' },
	'clarity2012' => { 460 => 'Clarity2012', 462 => 'Clarity2012' },
	'claritycontrol' => { 340 => 0x96 },
	'classifystate' => { 127 => 0xe1 },
	'clearretouch' => { 305 => 0x7c },
	'clearretouchvalue' => { 305 => 0xa3 },
	'client' => { 486 => 'client' },
	'clientname' => { 468 => 'ClientName' },
	'clipfilename' => { 365 => 'clfn' },
	'clipid' => { 365 => 'clid' },
	'clmodeshootingspeed' => { 265 => '10.2', 266 => '11.3', 268 => '11.2', 269 => '11.2', 274 => '11.2', 275 => '10.2', 278 => '11.2', 279 => '11.2', 280 => '11.1' },
	'cmcontrast' => { 290 => 0x2022 },
	'cmexposurecompensation' => { 290 => 0x2000 },
	'cmhue' => { 290 => 0x2021 },
	'cmsaturation' => { 290 => 0x2020 },
	'cmsharpness' => { 290 => 0x2023 },
	'cmwhitebalance' => { 290 => 0x2001 },
	'cmwhitebalancecomp' => { 290 => 0x2002 },
	'cmwhitebalancegraypoint' => { 290 => 0x2010 },
	'codec' => { 164 => 'Codec' },
	'codedcharacterset' => { 128 => 0x5a },
	'codeversion' => { 365 => 'cver' },
	'collection' => { 295 => 'Collection' },
	'collectionname' => { 165 => [\'Collections','CollectionsCollectionName'], 365 => 'coll' },
	'collections' => { 165 => 'Collections', 455 => 'collections' },
	'collectionuri' => { 165 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 359 => 'player.movie.visual.color', 475 => 'color' },
	'coloraberrationcontrol' => { 258 => 0xc89224b },
	'coloradjustment' => { 382 => 0x14 },
	'coloradjustmentmode' => { 381 => 0x210 },
	'coloranta' => { 491 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 491 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 491 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 491 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 491 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 491 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 491 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 491 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 491 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 491 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 491 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 491 => 'Colorants' },
	'colorantswatchname' => { 491 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 491 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 491 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 491 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 151 => 'ColorBalance' },
	'colorbalanceadj' => { 258 => 0x76a43202 },
	'colorbalanceblue' => { 175 => 0x1e },
	'colorbalancegreen' => { 175 => 0x1d },
	'colorbalancered' => { 175 => 0x1c },
	'colorbalanceversion' => { 196 => 0x4, 197 => 0x4, 198 => 0x0 },
	'colorblur' => { 105 => 0x65 },
	'colorbluron' => { 99 => 0x20704 },
	'colorbooster' => { 258 => 0x5f0e7d23 },
	'colorboostlevel' => { 252 => 0x1 },
	'colorboosttype' => { 252 => 0x0 },
	'colorchromeeffect' => { 123 => 0x1048 },
	'colorclass' => { 351 => 0xde, 352 => 'ColorClass' },
	'colorcompensationfilter' => { 178 => [0x3a,0x5f], 180 => 0x111, 405 => 0xb022 },
	'colorcompensationfiltercustom' => { 392 => 0xd, 393 => 0xc },
	'colorcompensationfilterset' => { 392 => 0x8, 393 => 0x7, 394 => 0x18, 410 => 0xf },
	'colorcontrol' => { 287 => 0x102b },
	'colorcorrection' => { 438 => 0x8015 },
	'colorcreatoreffect' => { 282 => 0x532 },
	'colordataversion' => { 42 => 0x0, 43 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0 },
	'coloreffect' => { 305 => 0x28 },
	'colorfilter' => { 108 => 0x17, 109 => 0x3017, 175 => 0x29, 183 => [0x38,0x4d,0x4f], 347 => 0x17 },
	'colorgain' => { 226 => 0x51 },
	'colorhue' => { 99 => 0x20900, 218 => 0x8d },
	'colorimetricreference' => { 115 => 0xc6bf },
	'colorlabel' => { 465 => 'ColorLabel' },
	'colormatrix' => { 286 => 0x200, 287 => 0x1011, 379 => 0xa030 },
	'colormatrix1' => { 115 => 0xc621, 349 => 0x106 },
	'colormatrix2' => { 115 => 0xc622, 290 => 0x200, 349 => 0x226 },
	'colormatrixa' => { 340 => 0x203 },
	'colormatrixadobergb' => { 379 => 0xa032 },
	'colormatrixb' => { 340 => 0x204 },
	'colormatrixnumber' => { 287 => 0x1019 },
	'colormatrixsrgb' => { 379 => 0xa031 },
	'colormode' => { 109 => 0x3015, 123 => 0x1210, 135 => 0x66, 175 => 0x28, 178 => 0x16, 180 => 0x101, 181 => 0x36, 183 => 0x7, 218 => 0x3, 248 => 0x4, 305 => 0x32, 382 => 0x2c, 405 => 0xb029, 474 => 'ColorMode' },
	'colormoirereduction' => { 99 => 0x20670, 259 => 0x15 },
	'colormoirereductionmode' => { 259 => 0x5 },
	'colormoirereductionon' => { 99 => '0x20670.0' },
	'colornoisereduction' => { 438 => 0x8029, 460 => 'ColorNoiseReduction', 462 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 460 => 'ColorNoiseReductionDetail', 462 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 259 => 0x18 },
	'colornoisereductionsharpness' => { 259 => 0x1c },
	'colornoisereductionsmoothness' => { 460 => 'ColorNoiseReductionSmoothness', 462 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 119 => 0x2 },
	'colorprofile' => { 175 => 0x33 },
	'colorprofilesettings' => { 282 => 0x539 },
	'colorrepresentation' => { 129 => 0x3c },
	'colorsaturationadj' => { 99 => 0x20305 },
	'colorsequence' => { 129 => 0x41 },
	'colorspace' => { 49 => 0x3, 61 => 0xb4, 93 => 0x10b4, 115 => 0xa001, 157 => 'ColorSpace', 176 => 0x2f, 177 => 0x25, 178 => 0x17, 218 => 0x1e, 282 => 0x507, 340 => 0x37, 379 => 0xa011, 382 => 0xb, 392 => 0x1b, 393 => 0x83, 394 => 0xe, 410 => 0x6, 466 => 'ColorSpace' },
	'colortempasshot' => { 38 => 0x4, 39 => 0x7, 40 => 0x1d, 41 => 0x26, 42 => 0x43, 45 => 0x43, 46 => 0x43, 47 => 0x43, 48 => 0x4b },
	'colortempauto' => { 38 => 0x9, 39 => 0xf, 40 => 0x22, 41 => 0x1c, 42 => 0x48, 45 => 0x48, 46 => 0x48, 47 => 0x48, 48 => 0x50 },
	'colortempcloudy' => { 38 => 0x22, 39 => 0x37, 40 => 0x31, 41 => 0x35, 42 => 0x5c, 45 => 0x75, 46 => 0x8e, 47 => 0x93, 48 => 0x96, 340 => 0x55 },
	'colortempcustom' => { 42 => 0x84 },
	'colortempcustom1' => { 40 => 0x45 },
	'colortempcustom2' => { 40 => 0x4a },
	'colortempdaylight' => { 38 => 0x18, 39 => 0x27, 40 => 0x27, 41 => 0x2b, 42 => 0x52, 45 => 0x6b, 46 => 0x84, 47 => 0x89, 48 => 0x8c, 340 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 61 => 0xae, 71 => 0x9, 93 => 0x10ae, 123 => 0x1005, 133 => 0x846, 151 => 'ColorTemperature', 176 => [0x6e,0x49], 177 => 0x3f, 178 => [0x39,0x5e], 180 => 0x10b, 183 => [0x3c,0x4c,0x4e], 300 => 0x321, 340 => 0x50, 372 => 0x1308, 405 => 0xb021, 460 => 'Temperature', 462 => 'Temperature' },
	'colortemperatureadj' => { 438 => 0x8013 },
	'colortemperatureauto' => { 218 => 0x4f },
	'colortemperaturebg' => { 287 => 0x1013 },
	'colortemperaturecustom' => { 392 => 0xc, 393 => 0xb },
	'colortemperaturerg' => { 287 => 0x1014 },
	'colortemperatureset' => { 392 => 0x7, 393 => 0x6 },
	'colortemperaturesetting' => { 178 => 0x25, 394 => 0x17, 410 => 0xe },
	'colortempflash' => { 38 => 0x36, 39 => 0x57, 40 => 0x40, 41 => 0x49, 42 => 0x70, 45 => 0x89, 46 => 0xa2, 47 => 0xa7, 48 => 0xaa, 340 => 0x5a },
	'colortempflashdata' => { 42 => 0x24a },
	'colortempfluorescent' => { 38 => 0x2c, 39 => 0x47, 40 => 0x3b, 41 => 0x3f, 42 => 0x66, 45 => 0x7f, 46 => 0x98, 47 => 0x9d, 48 => 0xa0 },
	'colortempfluorescentd' => { 340 => 0x57 },
	'colortempfluorescentn' => { 340 => 0x58 },
	'colortempfluorescentw' => { 340 => 0x59 },
	'colortempkelvin' => { 38 => 0x31, 39 => 0x4f, 41 => 0x44, 42 => 0x6b, 45 => 0x84, 46 => 0x9d, 47 => 0xa2, 48 => 0xa5, 305 => 0x44, 372 => 0x1307 },
	'colortempmeasured' => { 38 => 0xe, 39 => 0x17, 42 => 0x4d, 45 => 0x4d, 46 => 0x4d, 47 => 0x4d, 48 => 0x55 },
	'colortemppc1' => { 41 => 0x94, 42 => 0x75 },
	'colortemppc2' => { 41 => 0x99, 42 => 0x7a },
	'colortemppc3' => { 41 => 0x9e, 42 => 0x7f },
	'colortempshade' => { 38 => 0x1d, 39 => 0x2f, 40 => 0x2c, 41 => 0x30, 42 => 0x57, 45 => 0x70, 46 => 0x89, 47 => 0x8e, 48 => 0x91, 340 => 0x54 },
	'colortemptungsten' => { 38 => 0x27, 39 => 0x3f, 40 => 0x36, 41 => 0x3a, 42 => 0x61, 45 => 0x7a, 46 => 0x93, 47 => 0x98, 48 => 0x9b, 340 => 0x56 },
	'colortempunknown' => { 38 => 0x13, 39 => 0x1f, 41 => 0x21, 45 => 0x52, 46 => 0x52, 47 => 0x52, 48 => 0x5a },
	'colortempunknown10' => { 38 => 0x63, 39 => 0x9f, 41 => 0x76, 45 => 0xa2, 46 => 0x7f, 47 => 0x7f, 48 => 0x87 },
	'colortempunknown11' => { 38 => 0x68, 39 => 0xa7, 41 => 0x7b, 45 => 0xa7, 46 => 0xa7, 47 => 0x84, 48 => 0xaf },
	'colortempunknown12' => { 38 => 0x6d, 39 => 0xaf, 41 => 0x80, 45 => 0xac, 46 => 0xac, 47 => 0xac, 48 => 0xb4 },
	'colortempunknown13' => { 38 => 0x72, 39 => 0xb7, 41 => 0x85, 45 => 0xb1, 46 => 0xb1, 47 => 0xb1, 48 => 0xb9 },
	'colortempunknown14' => { 41 => 0x8a, 45 => 0xb6, 46 => 0xb6, 47 => 0xb6, 48 => 0xbe },
	'colortempunknown15' => { 41 => 0x8f, 45 => 0xbb, 46 => 0xbb, 47 => 0xbb, 48 => 0xc3 },
	'colortempunknown16' => { 41 => 0xa3, 46 => 0xc0, 47 => 0xc0, 48 => 0xc8 },
	'colortempunknown17' => { 46 => 0xc5, 47 => 0xc5, 48 => 0xcd },
	'colortempunknown18' => { 46 => 0xca, 47 => 0xca, 48 => 0xd2 },
	'colortempunknown19' => { 46 => 0xcf, 47 => 0xcf, 48 => 0xd7 },
	'colortempunknown2' => { 38 => 0x3b, 39 => 0x5f, 41 => 0x4e, 45 => 0x57, 46 => 0x57, 47 => 0x57, 48 => 0x5f },
	'colortempunknown20' => { 46 => 0xd4, 47 => 0xd4, 48 => 0xdc },
	'colortempunknown21' => { 47 => 0xd9, 48 => 0xe1 },
	'colortempunknown22' => { 47 => 0xde, 48 => 0xe6 },
	'colortempunknown23' => { 47 => 0xe3, 48 => 0xeb },
	'colortempunknown24' => { 47 => 0xe8, 48 => 0xf0 },
	'colortempunknown25' => { 47 => 0xed, 48 => 0xf5 },
	'colortempunknown26' => { 47 => 0xf2, 48 => 0xfa },
	'colortempunknown27' => { 47 => 0xf7, 48 => 0xff },
	'colortempunknown28' => { 47 => 0xfc, 48 => 0x104 },
	'colortempunknown29' => { 47 => 0x101, 48 => 0x109 },
	'colortempunknown3' => { 38 => 0x40, 39 => 0x67, 41 => 0x53, 45 => 0x5c, 46 => 0x5c, 47 => 0x5c, 48 => 0x64 },
	'colortempunknown30' => { 47 => 0x106 },
	'colortempunknown4' => { 38 => 0x45, 39 => 0x6f, 41 => 0x58, 45 => 0x61, 46 => 0x61, 47 => 0x61, 48 => 0x69 },
	'colortempunknown5' => { 38 => 0x4a, 39 => 0x77, 41 => 0x5d, 45 => 0x66, 46 => 0x66, 47 => 0x66, 48 => 0x6e },
	'colortempunknown6' => { 38 => 0x4f, 39 => 0x7f, 41 => 0x62, 45 => 0x8e, 46 => 0x6b, 47 => 0x6b, 48 => 0x73 },
	'colortempunknown7' => { 38 => 0x54, 39 => 0x87, 41 => 0x67, 45 => 0x93, 46 => 0x70, 47 => 0x70, 48 => 0x78 },
	'colortempunknown8' => { 38 => 0x59, 39 => 0x8f, 41 => 0x6c, 45 => 0x98, 46 => 0x75, 47 => 0x75, 48 => 0x7d },
	'colortempunknown9' => { 38 => 0x5e, 39 => 0x97, 41 => 0x71, 45 => 0x9d, 46 => 0x7a, 47 => 0x7a, 48 => 0x82 },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 34 => 0x2a, 49 => 0x2 },
	'colortoneadj' => { 99 => 0x20304, 104 => 0x11e },
	'colortoneauto' => { 68 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 67 => 0x6c, 68 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 67 => 0x3c, 68 => 0x3c },
	'colortonemonochrome' => { 67 => 0x84, 68 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 67 => 0x54, 68 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 67 => 0x24, 68 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 67 => 0xc, 68 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 67 => 0x9c, 68 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 67 => 0xb4, 68 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 67 => 0xcc, 68 => 0xe4 },
	'comlenblksize' => { 133 => 0xfde8 },
	'commanddials' => { 276 => '5.1' },
	'commanddialsaperturesetting' => { 265 => '17.3', 266 => '18.3', 268 => '18.3', 269 => '18.3', 274 => '33.3', 275 => '17.3', 278 => '18.3', 279 => '18.3' },
	'commanddialschangemainsub' => { 265 => '17.2', 266 => '18.1', 268 => '18.1', 269 => '18.1', 274 => '33.2', 275 => '17.2', 278 => '18.1', 279 => '18.1' },
	'commanddialsmenuandplayback' => { 265 => '17.4', 266 => '18.2', 268 => '18.2', 269 => '18.2', 274 => '33.4', 275 => '17.4', 278 => '18.2', 279 => '18.2' },
	'commanddialsreverserotation' => { 265 => '17.1', 266 => '6.4', 268 => '6.2', 269 => '6.2', 270 => '16.2', 271 => '17.2', 274 => '33.1', 275 => '17.1', 278 => '6.2', 279 => '6.2', 280 => '18.1' },
	'commanderchannel' => { 276 => '10.2', 277 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 276 => '13.1', 277 => '31.1' },
	'commandergroupa_ttlcomp' => { 280 => '32.1' },
	'commandergroupamanualoutput' => { 276 => '13.2', 277 => '28.2' },
	'commandergroupamode' => { 276 => '11.2', 277 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 276 => '14.1', 277 => '32.1' },
	'commandergroupb_ttlcomp' => { 280 => '33.1' },
	'commandergroupbmanualoutput' => { 276 => '14.2', 277 => '29.2' },
	'commandergroupbmode' => { 276 => '11.3', 277 => '29.1' },
	'commanderinternalflash' => { 276 => '11.1', 277 => '27.1' },
	'commanderinternalmanualoutput' => { 276 => '12.2', 277 => '27.2' },
	'commanderinternalttlchannel' => { 274 => '18.2' },
	'commanderinternalttlcomp' => { 276 => '12.1', 277 => '30.2', 280 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 274 => '20.1', 275 => '26.1' },
	'commanderinternalttlcompgroupa' => { 274 => '21.1', 275 => '27.1' },
	'commanderinternalttlcompgroupb' => { 274 => '22.1', 275 => '28.1' },
	'comment' => { 0 => 0x2, 116 => 'Comment', 152 => 'Comment', 295 => 'Comment', 357 => "\xa9cmt", 359 => 'comment', 365 => "\xa9cmt" },
	'compass' => { 375 => 0x4 },
	'compilation' => { 357 => 'cpil' },
	'complianceprofile' => { 476 => 'complianceProfile' },
	'componentsconfiguration' => { 115 => 0x9101, 157 => 'Components', 466 => 'ComponentsConfiguration' },
	'componentversion' => { 93 => 0x80c },
	'composer' => { 357 => ["\xa9com","\xa9wrt"], 365 => ["\xa9com","\xa9wrt"], 486 => 'composer' },
	'composerkeywords' => { 365 => "\xa9cok" },
	'compositeimage' => { 115 => 0xa460 },
	'compositeimagecount' => { 115 => 0xa461 },
	'compositeimageexposuretimes' => { 115 => 0xa462 },
	'composition' => { 450 => 'Composition' },
	'compositionadjust' => { 339 => '0.1' },
	'compositionadjustrotation' => { 339 => 0x7 },
	'compositionadjustx' => { 339 => 0x5 },
	'compositionadjusty' => { 339 => 0x6 },
	'compressedbitsperpixel' => { 115 => 0x9102, 466 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 180 => 0x40, 287 => 0x40 },
	'compression' => { 115 => 0x103, 310 => 0xb, 482 => 'Compression' },
	'compressionfactor' => { 282 => 0x50d },
	'compressionratio' => { 157 => 'Compression', 287 => 0x1034 },
	'compressorversion' => { 365 => 'CNCV' },
	'condadobvfactor' => { 133 => 0xf3e },
	'condadodaybvthresh' => { 133 => 0xf3c },
	'condadodayoffsets' => { 133 => 0xf42 },
	'condadofluoffsets' => { 133 => 0xf44 },
	'condadofluthresh' => { 133 => 0xf41 },
	'condadoillfactor' => { 133 => 0xf3f },
	'condadoneurange' => { 133 => 0xf3d },
	'condadotunoffsets' => { 133 => 0xf43 },
	'condadotunthresh' => { 133 => 0xf40 },
	'confidence' => { 445 => 'Confidence' },
	'confidencelevel' => { 456 => 'ConfidenceLevel' },
	'confidencemime' => { 445 => 'ConfidenceMime' },
	'constrainedcropheight' => { 104 => 0x266, 351 => 0xd6 },
	'constrainedcropwidth' => { 104 => 0x262, 351 => 0xd5 },
	'contact' => { 127 => 0x76 },
	'contactinfo' => { 475 => 'contactInfo' },
	'containerformat' => { 472 => 'ContainerFormat' },
	'containerformatidentifier' => { 472 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 472 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 357 => "\xa9day", 365 => "\xa9day" },
	'contentdistributorid' => { 365 => 'cdis' },
	'contentid' => { 365 => 'ccid' },
	'contentidentifier' => { 1 => 0x11 },
	'contentlocationcode' => { 127 => 0x1a },
	'contentlocationname' => { 127 => 0x1b },
	'contenttype' => { 476 => 'contentType' },
	'continuousbracketing' => { 178 => 0x20 },
	'continuousdrive' => { 34 => 0x5 },
	'continuousmodeliveview' => { 279 => '77.2' },
	'continuousshootingspeed' => { 80 => 0x610 },
	'continuousshotlimit' => { 80 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 34 => 0xd, 108 => 0xc, 109 => [0x3012,0x20], 115 => [0xa408,0xfe54], 123 => [0x1004,0x1006], 151 => 'Contrast', 171 => 'Contrast', 175 => 0x20, 176 => 0x31, 177 => 0x27, 178 => 0x19, 183 => 0x2, 220 => 0x33, 221 => 0x37, 222 => 0x3f, 287 => 0x1029, 305 => 0x39, 307 => 0x300a, 340 => 0x20, 347 => 0xc, 359 => 'player.movie.visual.contrast', 366 => 0x24, 368 => 0x52, 372 => 0x1012, 382 => 0xd, 392 => 0x1d, 393 => 0x1a, 405 => 0x2004, 460 => 'Contrast', 462 => 'Contrast', 466 => 'Contrast' },
	'contrast2012' => { 460 => 'Contrast2012', 462 => 'Contrast2012' },
	'contrastadj' => { 99 => 0x20303, 104 => 0x115, 261 => 0x2c, 438 => 0x8017 },
	'contrastauto' => { 68 => 0x90 },
	'contrastcurve' => { 218 => 0x8c },
	'contrastdetectaf' => { 187 => 0x4 },
	'contrastdetectafarea' => { 340 => 0x231 },
	'contrastdetectafinfocus' => { 187 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 67 => 0x60, 68 => 0x60 },
	'contrasthighlight' => { 340 => 0x6d },
	'contrasthighlightshadowadj' => { 340 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 67 => 0x30, 68 => 0x30 },
	'contrastmode' => { 305 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 67 => 0x78, 68 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 67 => 0x48, 68 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 67 => 0x18, 68 => 0x18 },
	'contrastsetting' => { 282 => 0x505, 290 => 0x1012, 394 => 0x10, 410 => 0x8 },
	'contrastshadow' => { 340 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 67 => 0x0, 68 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 67 => 0x90, 68 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 67 => 0xa8, 68 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 67 => 0xc0, 68 => 0xd8 },
	'contributedmedia' => { 486 => 'contributedMedia' },
	'contributedmediaduration' => { 486 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 486 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 486 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 486 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 486 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 486 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 486 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 486 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 486 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 486 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 463 => 'contributor', 472 => 'Contributor' },
	'contributoridentifier' => { 472 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 472 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 472 => [\'Contributor','ContributorRole'] },
	'contributors' => { 152 => 'Contributors' },
	'controldialset' => { 178 => 0x46 },
	'controlledvocabularyterm' => { 472 => 'CVterm' },
	'controllerboardversion' => { 300 => 0x332 },
	'controlmode' => { 74 => 0x12 },
	'controlringrotation' => { 80 => 0x712 },
	'conversionlens' => { 283 => 0x403, 305 => 0x35 },
	'converter' => { 115 => 0xfe4d, 248 => 0xb, 460 => 'Converter', 462 => 'Converter' },
	'converttograyscale' => { 460 => 'ConvertToGrayscale', 462 => 'ConvertToGrayscale' },
	'cookingequipment' => { 478 => 'cookingEquipment' },
	'cookingmethod' => { 478 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 115 => 0x8298, 152 => 'Copyright', 295 => 'Copyright', 340 => 0x22f, 356 => 'Copyright', 357 => ['cprt',"\xa9cpy"], 359 => 'copyright', 365 => ['cprt',"\xa9cpy"], 473 => 'Copyright', 479 => 'copyright', 482 => 'Copyright', 486 => 'copyright' },
	'copyrightflag' => { 354 => 0x40a },
	'copyrightnotice' => { 127 => 0x74 },
	'copyrightowner' => { 292 => 'CopyrightOwner' },
	'copyrightownerid' => { 292 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 292 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 292 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 292 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 292 => 'CopyrightStatus' },
	'copyrightyear' => { 472 => 'CopyrightYear', 476 => 'copyrightYear' },
	'coringfilter' => { 286 => 0x310, 287 => 0x102d, 290 => 0x310 },
	'coringvalues' => { 286 => 0x311, 290 => 0x311 },
	'corporateentity' => { 476 => 'corporateEntity' },
	'country' => { 156 => 'Country', 305 => 0x69, 474 => 'Country' },
	'country-primarylocationcode' => { 127 => 0x64 },
	'country-primarylocationname' => { 127 => 0x65 },
	'countrycode' => { 217 => 0x5, 352 => 'CountryCode', 471 => 'CountryCode' },
	'course' => { 478 => 'course' },
	'coverage' => { 463 => 'coverage' },
	'coverart' => { 357 => 'covr' },
	'coverdate' => { 476 => 'coverDate' },
	'coverdisplaydate' => { 476 => 'coverDisplayDate' },
	'coveruri' => { 365 => 'cvru' },
	'cpufirmwareversion' => { 340 => 0x28 },
	'crc32' => { 464 => 'crc32' },
	'createdate' => { 115 => 0x9004, 152 => 'CreateDate', 291 => 'CreationDate', 295 => 'create-date', 356 => 'CreationDate', 362 => 0x1, 484 => 'CreateDate' },
	'creationdate' => { 359 => 'creationdate', 473 => 'CreationDate', 476 => 'creationDate' },
	'creationtime' => { 295 => 'Creation Time' },
	'creativestyle' => { 392 => 0x1a, 393 => 0x18, 403 => 0x41, 405 => 0xb020, 434 => 0x4a },
	'creativestylesetting' => { 394 => 0xf, 410 => 0x7 },
	'creativestylewaschanged' => { 438 => 0x8001 },
	'creator' => { 291 => 'Creator', 356 => 'Creator', 463 => 'creator', 472 => 'Creator', 473 => 'Creator' },
	'creatoraddress' => { 471 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 173 => 'CreatorAppId' },
	'creatorcity' => { 471 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 471 => 'CreatorContactInfo' },
	'creatorcountry' => { 471 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 472 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 472 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 173 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 471 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 471 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 472 => [\'Creator','CreatorRole'] },
	'creatortool' => { 484 => 'CreatorTool' },
	'creatorworkemail' => { 471 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 471 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 471 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 127 => 0x6e, 474 => 'Credit' },
	'creditline' => { 479 => 'creditLine' },
	'creditlinereq' => { 489 => 'CreditLineReq' },
	'creditlinerequired' => { 292 => 'CreditLineRequired' },
	'cropactive' => { 97 => 0x0, 104 => 0x244 },
	'cropangle' => { 460 => 'CropAngle', 462 => 'CropAngle' },
	'croparea' => { 218 => 0x45, 438 => 0x9011 },
	'cropaspectratio' => { 99 => 0x30101, 104 => 0x260 },
	'cropaspectratiocustom' => { 99 => 0x30102 },
	'cropbottom' => { 119 => 0x9, 253 => 0x36, 310 => 0x31, 351 => 0xdc, 460 => 'CropBottom', 462 => 'CropBottom' },
	'cropbottommargin' => { 51 => 0x3 },
	'cropcircleactive' => { 105 => 0xd6 },
	'cropcircleradius' => { 105 => 0xd9 },
	'cropcirclex' => { 105 => 0xd7 },
	'cropcircley' => { 105 => 0xd8 },
	'cropconstraintowarp' => { 460 => 'CropConstrainToWarp', 462 => 'CropConstrainToWarp' },
	'croph' => { 454 => 'CropH' },
	'cropheight' => { 97 => 0x6, 104 => 0x24c, 286 => 0x615, 290 => 0x615, 460 => 'CropHeight', 462 => 'CropHeight' },
	'crophispeed' => { 218 => 0x1b },
	'cropleft' => { 104 => 0x246, 119 => 0x6, 253 => 0x1e, 286 => 0x612, 290 => 0x612, 310 => 0x30, 351 => 0xd9, 460 => 'CropLeft', 462 => 'CropLeft' },
	'cropleftmargin' => { 51 => 0x0 },
	'cropmode' => { 123 => 0x104d, 372 => 0x1018 },
	'croporiginalheight' => { 97 => 0xb },
	'croporiginalwidth' => { 97 => 0xa },
	'cropoutputheight' => { 253 => 0xce },
	'cropoutputheightinches' => { 253 => 0x96 },
	'cropoutputpixels' => { 253 => 0xd6 },
	'cropoutputresolution' => { 253 => 0xb6 },
	'cropoutputscale' => { 253 => 0xbe },
	'cropoutputwidth' => { 253 => 0xc6 },
	'cropoutputwidthinches' => { 253 => 0x8e },
	'croppedareaimageheightpixels' => { 448 => 'CroppedAreaImageHeightPixels', 449 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 448 => 'CroppedAreaImageWidthPixels', 449 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 448 => 'CroppedAreaLeftPixels', 449 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 448 => 'CroppedAreaTopPixels', 449 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 372 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 372 => 0x1603 },
	'cropping' => { 438 => 0x9010 },
	'cropright' => { 119 => 0x8, 253 => 0x2e, 310 => 0x32, 351 => 0xdb, 460 => 'CropRight', 462 => 'CropRight' },
	'croprightmargin' => { 51 => 0x1 },
	'croprotatedoriginalheight' => { 97 => 0x2 },
	'croprotatedoriginalwidth' => { 97 => 0x1 },
	'croprotation' => { 97 => 0x8, 119 => 0xb },
	'cropscaledresolution' => { 253 => 0x9e },
	'cropsourceresolution' => { 253 => 0xae },
	'croptop' => { 104 => 0x248, 119 => 0x7, 253 => 0x26, 286 => 0x613, 290 => 0x613, 310 => 0x2f, 351 => 0xda, 460 => 'CropTop', 462 => 'CropTop' },
	'croptopmargin' => { 51 => 0x2 },
	'cropunit' => { 460 => 'CropUnit', 462 => 'CropUnit' },
	'cropunits' => { 460 => 'CropUnits', 462 => 'CropUnits' },
	'cropw' => { 454 => 'CropW' },
	'cropwidth' => { 97 => 0x5, 104 => 0x24a, 286 => 0x614, 290 => 0x614, 460 => 'CropWidth', 462 => 'CropWidth' },
	'cropx' => { 97 => 0x3, 454 => 'CropX' },
	'cropy' => { 97 => 0x4, 454 => 'CropY' },
	'crossprocess' => { 340 => 0x7b },
	'crossprocessparams' => { 340 => 0x235 },
	'cuisine' => { 478 => 'cuisine' },
	'currenticcprofile' => { 115 => 0xc691 },
	'currentpreprofilematrix' => { 115 => 0xc692 },
	'currentversion' => { 438 => 0xd000 },
	'curve0x' => { 454 => 'Curve0x' },
	'curve0y' => { 454 => 'Curve0y' },
	'curve1x' => { 454 => 'Curve1x' },
	'curve1y' => { 454 => 'Curve1y' },
	'curve2x' => { 454 => 'Curve2x' },
	'curve2y' => { 454 => 'Curve2y' },
	'curve3x' => { 454 => 'Curve3x' },
	'curve3y' => { 454 => 'Curve3y' },
	'curve4x' => { 454 => 'Curve4x' },
	'curve4y' => { 454 => 'Curve4y' },
	'curves' => { 258 => 0x76a43201 },
	'custom1' => { 292 => 'Custom1' },
	'custom10' => { 292 => 'Custom10' },
	'custom2' => { 292 => 'Custom2' },
	'custom3' => { 292 => 'Custom3' },
	'custom4' => { 292 => 'Custom4' },
	'custom5' => { 292 => 'Custom5' },
	'custom6' => { 292 => 'Custom6' },
	'custom7' => { 292 => 'Custom7' },
	'custom8' => { 292 => 'Custom8' },
	'custom9' => { 292 => 'Custom9' },
	'customcolortone' => { 105 => 0x4c },
	'customcontrast' => { 105 => 0x4e },
	'customcontrols' => { 80 => 0x70c },
	'customdefaultunsharpfineness' => { 105 => 0xbe },
	'customdefaultunsharpstrength' => { 105 => 0xbc },
	'customdefaultunsharpthreshold' => { 105 => 0xc0 },
	'customilluminant' => { 133 => 0x405 },
	'customizedials' => { 80 => 0x715 },
	'customlinear' => { 105 => 0x4f },
	'customoutputhighlightpoint' => { 105 => 0x53 },
	'customoutputshadowpoint' => { 105 => 0x54 },
	'custompicturestyle' => { 99 => 0x10021 },
	'custompicturestyledata' => { 99 => 0xf0500 },
	'custompicturestylefilename' => { 61 => 0x4010 },
	'customrawhighlight' => { 105 => 0x7c },
	'customrawhighlightpoint' => { 105 => 0x51 },
	'customrawshadow' => { 105 => 0x85 },
	'customrawshadowpoint' => { 105 => 0x52 },
	'customrendered' => { 115 => 0xa401, 466 => 'CustomRendered' },
	'customsaturation' => { 105 => 0x4d, 282 => 0x503 },
	'customsettingsalldefault' => { 265 => '0.2', 274 => '0.2' },
	'customsettingsbank' => { 265 => '0.1', 266 => '0.1', 268 => '0.1', 269 => '0.1', 274 => '0.1', 278 => '0.2', 279 => '0.2' },
	'customsharpness' => { 105 => 0x50 },
	'customunsharpmaskfineness' => { 105 => 0xb8 },
	'customunsharpmaskstrength' => { 105 => 0xb6 },
	'customunsharpmaskthreshold' => { 105 => 0xba },
	'customwb_rblevels' => { 410 => 0x1a },
	'customwb_rgblevels' => { 393 => 0x8, 394 => 0x19 },
	'customwbbluelevel' => { 178 => 0x36 },
	'customwberror' => { 178 => 0x37 },
	'customwbgreenlevel' => { 178 => 0x35 },
	'customwbredlevel' => { 178 => 0x34 },
	'customwbsetting' => { 178 => 0x26 },
	'cx' => { 365 => '_cx_' },
	'cy' => { 365 => '_cy_' },
	'd-lightinghq' => { 258 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 254 => 0x2 },
	'd-lightinghqhighlight' => { 254 => 0x1 },
	'd-lightinghqselected' => { 258 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 254 => 0x0 },
	'd-lightinghs' => { 258 => 0xce5554aa },
	'd-lightinghsadjustment' => { 255 => 0x0 },
	'd-lightinghscolorboost' => { 255 => 0x1 },
	'd-rangeoptimizerhighlight' => { 438 => 0x8024 },
	'd-rangeoptimizermode' => { 438 => 0x8022 },
	'd-rangeoptimizershadow' => { 438 => 0x802d },
	'd-rangeoptimizervalue' => { 438 => 0x8023 },
	'darkblacksegrows' => { 133 => 0x18d8 },
	'darkfocusenvironment' => { 305 => 0x8003 },
	'darkframecountfactor' => { 133 => 0xc85 },
	'darkframelongexposure' => { 133 => 0xc84 },
	'darkframeshortexposure' => { 133 => 0xc83 },
	'darkpedestal' => { 133 => 0xc7f },
	'datacompressionmethod' => { 129 => 0x6e },
	'dataimprint' => { 175 => 0x34 },
	'dataonscreen' => { 472 => 'DataOnScreen' },
	'dataonscreenregion' => { 472 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 472 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 472 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 472 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 472 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 472 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 472 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 472 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 340 => 0x3d },
	'date' => { 340 => 0x6, 463 => 'date' },
	'dateacquired' => { 173 => 'DateAcquired' },
	'datecreated' => { 127 => 0x37, 474 => 'DateCreated' },
	'datedisplayformat' => { 250 => 0x3 },
	'dateidentified' => { 114 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 270 => '4.2' },
	'daterecieved' => { 476 => 'dateRecieved' },
	'datesent' => { 128 => 0x46 },
	'datestampmode' => { 61 => 0x1c, 218 => 0x9d },
	'datetime' => { 455 => 'datetime', 482 => 'DateTime' },
	'datetimedigitized' => { 466 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 96 => 0x0, 115 => 0x9003, 149 => 0x14, 152 => 'OriginalDate', 360 => 'IDIT', 365 => 'date', 366 => 0xb, 367 => 0x3b, 368 => 0x3e, 466 => 'DateTimeOriginal' },
	'datetimestamp' => { 135 => 0x64 },
	'datetimeutc' => { 282 => 0x908 },
	'daylightsavings' => { 75 => 0x3, 250 => 0x2 },
	'dayofweek' => { 367 => 0x42, 368 => 0x4a },
	'dccontinent' => { 114 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 114 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 114 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 114 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 114 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 114 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 114 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 114 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 114 => 'Event' },
	'dcfootprintspatialfit' => { 114 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 114 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 114 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 114 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 114 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 114 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 114 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 114 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 114 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 114 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 114 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 114 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 114 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 114 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 114 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 114 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 114 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 114 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 114 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 114 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 114 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 114 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 114 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 114 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 114 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 114 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 114 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 114 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 114 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 114 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 114 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 114 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 114 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 114 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 114 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 114 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 114 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 160 => 'Declination' },
	'decposition' => { 175 => 0x32 },
	'defaultautogray' => { 460 => 'DefaultAutoGray', 462 => 'DefaultAutoGray' },
	'defaultautotone' => { 460 => 'DefaultAutoTone', 462 => 'DefaultAutoTone' },
	'defaultblackrender' => { 115 => 0xc7a6 },
	'defaultcroporigin' => { 115 => 0xc61f },
	'defaultcropsize' => { 115 => 0xc620 },
	'defaulteraseoption' => { 80 => 0x813 },
	'defaultscale' => { 115 => 0xc61e },
	'defaultsspecifictoiso' => { 460 => 'DefaultsSpecificToISO', 462 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 460 => 'DefaultsSpecificToSerial', 462 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 115 => 0xc7b5 },
	'defectisocode' => { 133 => 0x90f },
	'defringe' => { 460 => 'Defringe', 462 => 'Defringe' },
	'defringegreenamount' => { 460 => 'DefringeGreenAmount', 462 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 460 => 'DefringeGreenHueHi', 462 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 460 => 'DefringeGreenHueLo', 462 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 460 => 'DefringePurpleAmount', 462 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 460 => 'DefringePurpleHueHi', 462 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 460 => 'DefringePurpleHueLo', 462 => 'DefringePurpleHueLo' },
	'dehaze' => { 460 => 'Dehaze', 462 => 'Dehaze' },
	'deletedimagecount' => { 218 => 0xa6, 227 => 0x6e },
	'deprecatedon' => { 458 => 'deprecatedOn' },
	'depthimage' => { 445 => 'Data' },
	'derivedfrom' => { 487 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 487 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 487 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 487 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 487 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 487 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 487 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 487 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 487 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 487 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 487 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 487 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 487 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 487 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 487 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 487 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 487 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 487 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 487 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 487 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 487 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 487 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 487 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 487 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 295 => 'Description', 357 => ['desc','dscp',"\xa9des"], 359 => 'description', 365 => 'dscp', 463 => 'description', 484 => 'Description' },
	'destination' => { 128 => 0x5 },
	'destinationcity' => { 340 => 0x24, 346 => 0x3 },
	'destinationcitycode' => { 347 => 0x1001 },
	'destinationdst' => { 340 => 0x26, 346 => '0.3' },
	'developmentdynamicrange' => { 123 => 0x1403 },
	'deviantmatrixcustom' => { 133 => 0x7de },
	'deviantmatrixdaylight' => { 133 => 0x7da },
	'deviantmatrixflash' => { 133 => 0x7dd },
	'deviantmatrixfluorescent' => { 133 => 0x7dc },
	'deviantmatrixtungsten' => { 133 => 0x7db },
	'deviantwhitecustom' => { 133 => 0x842 },
	'deviantwhitedaylight' => { 133 => 0x83e },
	'deviantwhiteflash' => { 133 => 0x841 },
	'deviantwhitefluorescent' => { 133 => 0x840 },
	'deviantwhitetungsten' => { 133 => 0x83f },
	'device' => { 476 => 'device' },
	'devicesettingdescription' => { 466 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 466 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 466 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 466 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 379 => 0x2 },
	'dewarpdata' => { 112 => 'DewarpData' },
	'dewarpflag' => { 112 => 'DewarpFlag' },
	'dialdirectiontvav' => { 80 => 0x706 },
	'dietaryneeds' => { 478 => 'dietaryNeeds' },
	'diffractioncorrection' => { 305 => 0xbc, 330 => 0x3 },
	'diffractioncorrectionon' => { 99 => 0x2070b },
	'digitalcreationdate' => { 127 => 0x3e },
	'digitalcreationtime' => { 127 => 0x3f },
	'digitaldeehighlightadj' => { 226 => 0x202 },
	'digitaldeeshadowadj' => { 226 => 0x200 },
	'digitaldeethreshold' => { 226 => 0x201 },
	'digitalfilter' => { 382 => 0x59 },
	'digitalfilter01' => { 327 => 0x5 },
	'digitalfilter02' => { 327 => 0x16 },
	'digitalfilter03' => { 327 => 0x27 },
	'digitalfilter04' => { 327 => 0x38 },
	'digitalfilter05' => { 327 => 0x49 },
	'digitalfilter06' => { 327 => 0x5a },
	'digitalfilter07' => { 327 => 0x6b },
	'digitalfilter08' => { 327 => 0x7c },
	'digitalfilter09' => { 327 => 0x8d },
	'digitalfilter10' => { 327 => 0x9e },
	'digitalfilter11' => { 327 => 0xaf },
	'digitalfilter12' => { 327 => 0xc0 },
	'digitalfilter13' => { 327 => 0xd1 },
	'digitalfilter14' => { 327 => 0xe2 },
	'digitalfilter15' => { 327 => 0xf3 },
	'digitalfilter16' => { 327 => 0x104 },
	'digitalfilter17' => { 327 => 0x115 },
	'digitalfilter18' => { 327 => 0x126 },
	'digitalfilter19' => { 327 => 0x137 },
	'digitalfilter20' => { 327 => 0x148 },
	'digitalgain' => { 71 => 0xb },
	'digitalgem' => { 207 => 0x0 },
	'digitalice' => { 226 => 0x100 },
	'digitalimageguid' => { 472 => 'DigImageGUID' },
	'digitalroc' => { 224 => 0x0 },
	'digitalsourcefiletype' => { 472 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 472 => 'DigitalSourceType' },
	'digitalzoom' => { 34 => 0xc, 108 => 0xa, 123 => 0x1044, 135 => 0x68, 146 => 0x22, 147 => 0x1e, 151 => 'DigitalZoom', 175 => 0xc, 218 => 0x86, 248 => 0xa, 287 => 0x204, 340 => 0x1e, 347 => 0xa, 381 => 0x204, 425 => 0x12, 426 => 0x12 },
	'digitalzoomon' => { 381 => 0x21b },
	'digitalzoomratio' => { 115 => 0xa404, 415 => 0x200, 417 => 0x21c, 466 => 'DigitalZoomRatio' },
	'director' => { 359 => 'director', 365 => "\xa9dir", 486 => 'director' },
	'directorphotography' => { 486 => 'directorPhotography' },
	'directory' => { 116 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 201 => 0x3, 368 => 0x12 },
	'disableautocreation' => { 443 => 'DisableAutoCreation' },
	'disclaimer' => { 295 => 'Disclaimer' },
	'discnumber' => { 486 => 'discNumber' },
	'dishtype' => { 478 => 'dishType' },
	'disknumber' => { 357 => 'disk' },
	'displayallafpoints' => { 80 => 0x514 },
	'displayaperture' => { 34 => 0x23 },
	'displayedunitsx' => { 355 => 0x2 },
	'displayedunitsy' => { 355 => 0x6 },
	'displayname' => { 359 => 'displayname', 475 => 'displayName' },
	'distance1' => { 135 => 0x28 },
	'distance2' => { 135 => 0x2c },
	'distance3' => { 135 => 0x30 },
	'distance4' => { 135 => 0x34 },
	'distortion' => { 379 => 0xa050 },
	'distortioncompensation' => { 438 => 0x8040 },
	'distortioncontrol' => { 227 => 0x10 },
	'distortioncorrection' => { 76 => 0x3, 99 => 0x20705, 105 => 0x67, 115 => 0x7036, 282 => 0x50b, 309 => '7.1', 330 => 0x0, 433 => 0x601, 434 => 0x5b },
	'distortioncorrection2' => { 286 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 457 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 99 => '0x20705.0', 105 => 0x63 },
	'distortioncorrectionsetting' => { 77 => 0x7, 405 => 0x2013 },
	'distortioncorrectionvalue' => { 76 => 0x9 },
	'distortioncorrparams' => { 115 => 0x7037, 414 => 0x1a23, 417 => 0x1870, 419 => 0x189c, 420 => 0x18cc, 421 => 0x17d0, 433 => 0x6ca, 434 => 0x64 },
	'distortioncorrparamsnumber' => { 417 => 0x1899, 419 => 0x18c5, 420 => 0x18f5, 421 => 0x17f9 },
	'distortioncorrparamspresent' => { 417 => 0x1898, 419 => 0x18c4, 420 => 0x18f4, 421 => 0x17f8, 423 => 0x10b, 424 => 0x10b, 433 => 0x600, 434 => 0x5a },
	'distortioneffect' => { 99 => 0x20709 },
	'distortionn' => { 309 => 0xc },
	'distortionparam02' => { 309 => 0x2 },
	'distortionparam04' => { 309 => 0x4 },
	'distortionparam08' => { 309 => 0x8 },
	'distortionparam09' => { 309 => 0x9 },
	'distortionparam11' => { 309 => 0xb },
	'distortionscale' => { 309 => 0x5 },
	'distributor' => { 476 => 'distributor' },
	'distributorproductid' => { 475 => 'distributorProductID' },
	'dloon' => { 99 => '0x20706.0', 105 => 0xdc },
	'dlosetting' => { 99 => 0x20706, 105 => 0xdd },
	'dlosettingapplied' => { 98 => 0x4 },
	'dloshootingdistance' => { 105 => 0xde },
	'dloversion' => { 98 => 0x5 },
	'dmcomment' => { 486 => 'comment' },
	'dmdithermatrix' => { 133 => 0xc7a },
	'dmdithermatrixheight' => { 133 => 0xc7c },
	'dmdithermatrixwidth' => { 133 => 0xc7b },
	'dngadobedata' => { 115 => 0xc634 },
	'dngbackwardversion' => { 115 => 0xc613 },
	'dngignoresidecars' => { 460 => 'DNGIgnoreSidecars', 462 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 115 => 0xc630 },
	'dngprivatedata' => { 115 => 0xc634 },
	'dngversion' => { 115 => 0xc612 },
	'document' => { 295 => 'Document' },
	'documentancestors' => { 474 => 'DocumentAncestors' },
	'documenthistory' => { 127 => 0xe7 },
	'documentid' => { 487 => 'DocumentID' },
	'documentname' => { 115 => 0x10d },
	'documentnotes' => { 127 => 0xe6 },
	'doi' => { 476 => 'doi' },
	'dopesheet' => { 472 => 'Dopesheet' },
	'dopesheetlink' => { 472 => 'DopesheetLink' },
	'dopesheetlinklink' => { 472 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 472 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 133 => 0xc82 },
	'dpp' => { 455 => 'dpp' },
	'dr4cameramodel' => { 100 => 0x3 },
	'drangepriority' => { 123 => 0x1443 },
	'drangepriorityauto' => { 123 => 0x1444 },
	'drangepriorityfixed' => { 123 => 0x1445 },
	'drivemode' => { 109 => 0x3103, 121 => '0.1', 175 => 0x6, 178 => 0x1e, 181 => 0xe, 282 => 0x600, 340 => 0x34, 372 => 0x1002, 382 => 0x3, 392 => 0x4, 393 => 0x7e, 394 => 0x34 },
	'drivemode2' => { 178 => 0xa, 321 => 0x7, 403 => 0xe, 410 => 0x1 },
	'drivemodesetting' => { 394 => 0x4 },
	'drivespeed' => { 121 => '0.2' },
	'dspfirmwareversion' => { 340 => 0x27 },
	'duration' => { 64 => 0x6a, 150 => 'Duration', 164 => 'Duration', 478 => 'duration', 486 => 'duration' },
	'durationscale' => { 486 => [\'duration','durationScale'] },
	'durationvalue' => { 486 => [\'duration','durationValue'] },
	'dustremovaldata' => { 61 => 0x97 },
	'dynamicafarea' => { 265 => '1.4', 274 => '1.4' },
	'dynamicareaafdisplay' => { 266 => '46.1', 268 => '47.1', 269 => '47.1', 278 => '47.1', 279 => '47.1' },
	'dynamicrange' => { 123 => 0x1400 },
	'dynamicrangeexpansion' => { 340 => 0x69, 372 => 0x100e },
	'dynamicrangemax' => { 104 => 0x7c },
	'dynamicrangemin' => { 104 => 0x7a },
	'dynamicrangeoptimizer' => { 178 => 0x15, 405 => [0xb025,0xb04f], 413 => 0x1144, 414 => [0x1144,0x324], 415 => [0x1120,0x300], 416 => [0x119c,0x37c], 417 => [0x1178,0x328], 418 => [0x1030,0x50], 419 => [0x228,0x50], 420 => [0x228,0x50], 421 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 403 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 392 => 0x19, 393 => 0x17, 394 => 0xd, 403 => 0x79, 410 => 0x5 },
	'dynamicrangeoptimizermode' => { 181 => 0x15, 392 => 0x18, 393 => 0x16, 403 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 178 => 0x27, 394 => 0xc, 410 => 0x4 },
	'dynamicrangesetting' => { 123 => 0x1402 },
	'e-dialinprogram' => { 321 => '1.3' },
	'earliestageorloweststage' => { 114 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 114 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 114 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 114 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 114 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 280 => '6.1' },
	'easyexposurecompensation' => { 265 => '6.4', 266 => '6.5', 268 => '6.3', 269 => '6.3', 273 => '5.1', 274 => '4.4', 275 => '5.2', 278 => '6.3', 279 => '6.3' },
	'easymode' => { 34 => 0xb },
	'edgemapslope' => { 133 => 0x930 },
	'edgemapx1' => { 133 => 0x931 },
	'edgemapx2' => { 133 => 0x932 },
	'edgemapx3' => { 133 => 0x934 },
	'edgemapx4' => { 133 => 0x935 },
	'edgenoisereduction' => { 259 => 0x4, 438 => 0x8028 },
	'edit1' => { 365 => "\xa9ed1" },
	'edit2' => { 365 => "\xa9ed2" },
	'edit3' => { 365 => "\xa9ed3" },
	'edit4' => { 365 => "\xa9ed4" },
	'edit5' => { 365 => "\xa9ed5" },
	'edit6' => { 365 => "\xa9ed6" },
	'edit7' => { 365 => "\xa9ed7" },
	'edit8' => { 365 => "\xa9ed8" },
	'edit9' => { 365 => "\xa9ed9" },
	'edition' => { 476 => 'edition' },
	'editorialupdate' => { 127 => 0x8 },
	'editstatus' => { 127 => 0x7, 352 => 'EditStatus', 455 => 'EditStatus' },
	'editversionname' => { 258 => 0x3d136244 },
	'effectivelv' => { 340 => 0x2d },
	'effectivemaxaperture' => { 211 => 0x12, 212 => 0x13, 216 => 0x14 },
	'eissn' => { 476 => 'eIssn' },
	'electricalblackcolumns' => { 133 => 0x1810 },
	'electronicfront-curtainshutter' => { 268 => '5.2', 269 => '5.2', 278 => '5.3', 279 => '5.2' },
	'electronicfrontcurtainshutter' => { 405 => 0x201a },
	'elevation' => { 160 => 'Elevation' },
	'email' => { 152 => 'EMail' },
	'embargodate' => { 479 => 'embargoDate' },
	'embdencrightsexpr' => { 472 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 472 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 472 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 472 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 474 => 'EmbeddedXMPDigest' },
	'emissivity' => { 117 => 0x3 },
	'enablechromanoisereduction' => { 133 => 0xe6e },
	'enablesharpening' => { 133 => 0x92e },
	'encodedby' => { 357 => "\xa9enc" },
	'encodedwith' => { 359 => 'Encoded_With' },
	'encoder' => { 357 => "\xa9too", 365 => "\xa9too" },
	'encoderid' => { 365 => "\xa9enc" },
	'encryptionkey' => { 379 => 0xa020 },
	'endingpage' => { 476 => 'endingPage' },
	'enduser' => { 292 => 'EndUser' },
	'enduserid' => { 292 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 292 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 486 => 'engineer' },
	'enhancedarktones' => { 251 => 0x8 },
	'enhancement' => { 108 => 0x16, 109 => 0x3016 },
	'enhancer' => { 286 => 0x300 },
	'enhancervalues' => { 286 => 0x301 },
	'envelopenumber' => { 128 => 0x28 },
	'envelopepriority' => { 128 => 0x3c },
	'enveloperecordversion' => { 128 => 0x0 },
	'episode' => { 472 => 'Episode' },
	'episodeglobaluniqueid' => { 357 => 'egid' },
	'episodeidentifier' => { 472 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 472 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 472 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 287 => 0x20c },
	'epsonimagewidth' => { 287 => 0x20b },
	'epsonsoftware' => { 287 => 0x20d },
	'equipmentinstitution' => { 440 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 440 => 'EquipmentManufacturer' },
	'equipmentversion' => { 283 => 0x0 },
	'ettlii' => { 80 => 0x304, 81 => 0xd, 82 => 0xe, 83 => 0x7, 84 => 0x7, 85 => 0xe },
	'event' => { 441 => 'Event', 453 => 'Event', 472 => 'Event', 476 => 'event' },
	'eventalias' => { 475 => 'eventAlias' },
	'eventdate' => { 114 => [\'Event','EventEventDate'] },
	'eventday' => { 114 => [\'Event','EventDay'] },
	'eventearliestdate' => { 114 => [\'Event','EventEarliestDate'] },
	'eventend' => { 475 => 'eventEnd' },
	'eventenddayofyear' => { 114 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 114 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 114 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 114 => [\'Event','EventHabitat'] },
	'eventid' => { 114 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 114 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 114 => [\'Event','EventMonth'] },
	'eventnumber' => { 366 => 0x9, 367 => 0x37, 368 => 0x3a },
	'eventparenteventid' => { 114 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 114 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 114 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 114 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 114 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 114 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 475 => 'eventStart' },
	'eventstartdayofyear' => { 114 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 475 => 'eventSubtype' },
	'eventtime' => { 114 => [\'Event','EventEventTime'] },
	'eventtype' => { 475 => 'eventType' },
	'eventverbatimeventdate' => { 114 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 114 => [\'Event','EventYear'] },
	'evsteps' => { 321 => '1.2', 323 => 0x0 },
	'evstepsize' => { 270 => '5.1', 271 => '6.1', 272 => '6.1', 276 => '0.7' },
	'exclusivecoverage' => { 450 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 479 => 'exclusivityEndDate' },
	'excursiontolerance' => { 129 => 0x82 },
	'exif' => { 116 => 'EXIF' },
	'exifbyteorder' => { 116 => 'ExifByteOrder' },
	'exifcamerainfo' => { 127 => 0xe8 },
	'exifimageheight' => { 115 => 0xa003, 466 => 'PixelYDimension' },
	'exifimagewidth' => { 115 => 0xa002, 466 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 116 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 115 => 0x9000, 466 => 'ExifVersion' },
	'exitpupilposition' => { 211 => 0x4, 212 => 0x4, 216 => 0x4 },
	'expirationdate' => { 127 => 0x25, 479 => 'expirationDate' },
	'expirationtime' => { 127 => 0x26 },
	'exposure' => { 115 => 0xfe51, 460 => 'Exposure', 462 => 'Exposure' },
	'exposure2012' => { 460 => 'Exposure2012', 462 => 'Exposure2012' },
	'exposureadj' => { 256 => 0x0 },
	'exposureadj2' => { 256 => 0x12 },
	'exposureadjust' => { 382 => 0xc },
	'exposurebracketingindicatorlast' => { 178 => 0x52 },
	'exposurebracketshotnumber' => { 181 => 0x2d, 403 => 0x2f },
	'exposurebracketstepsize' => { 321 => 0x8 },
	'exposurebracketvalue' => { 218 => 0x19 },
	'exposurecompautocancel' => { 80 => 0x113 },
	'exposurecompensation' => { 74 => 0x6, 89 => 0x0, 115 => 0x9204, 135 => 0x24, 151 => 'ExposureComp', 171 => 'ExposureCompensation', 175 => 0xd, 176 => 0x53, 177 => 0x1e, 181 => 0x49c0, 287 => 0x1006, 340 => 0x16, 349 => 0x402, 379 => 0xa013, 382 => [0xc,0x35,0x4d], 413 => 0x114c, 414 => 0x114c, 415 => 0x1128, 417 => 0x1180, 418 => 0x1038, 419 => 0x230, 420 => 0x230, 421 => 0x223, 466 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 410 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 178 => 0x47, 181 => 0x2a },
	'exposurecompensationset' => { 392 => 0x3, 393 => 0x3, 394 => 0x3, 410 => 0x1e },
	'exposurecompensationsetting' => { 178 => 0x1 },
	'exposurecompstepsize' => { 265 => '6.3', 266 => '7.3', 268 => '7.3', 269 => '7.3', 274 => '4.3', 278 => '7.3', 279 => '7.3' },
	'exposurecontrolstep' => { 273 => '6.1', 275 => '6.1' },
	'exposurecontrolstepsize' => { 265 => '6.2', 266 => '7.1', 268 => '7.1', 269 => '7.1', 274 => '4.2', 278 => '7.1', 279 => '7.1', 280 => '7.1' },
	'exposurecount' => { 123 => 0x1032 },
	'exposuredelaymode' => { 265 => '10.1', 266 => '11.1', 268 => '11.1', 269 => '11.1', 270 => '9.1', 271 => '10.1', 272 => '10.1', 274 => '10.4', 275 => '10.1', 276 => '6.4', 278 => '11.1', 279 => '11.1', 280 => '11.2' },
	'exposuredifference' => { 218 => 0xe },
	'exposuregaincustom' => { 133 => 0x89c },
	'exposuregaindaylight' => { 133 => 0x898 },
	'exposuregainflash' => { 133 => 0x89b },
	'exposuregainfluorescent' => { 133 => 0x89a },
	'exposuregaintungsten' => { 133 => 0x899 },
	'exposureindex' => { 115 => 0xa215, 466 => 'ExposureIndex' },
	'exposureindicator' => { 178 => 0x50 },
	'exposurelevelincrements' => { 78 => 0x6, 79 => 0x6, 80 => 0x101, 81 => 0x5, 82 => 0x6, 83 => 0x5, 84 => 0x5, 85 => 0x6, 86 => 0x4, 392 => 0x58, 393 => 0x58 },
	'exposurelockused' => { 448 => 'ExposureLockUsed' },
	'exposuremode' => { 115 => 0xa402, 151 => 'ExposureMode', 175 => 0x1, 176 => 0xa, 177 => 0x0, 178 => 0x0, 181 => 0x34, 282 => 0x200, 302 => 0x40d, 382 => 0x8, 405 => 0xb041, 466 => 'ExposureMode' },
	'exposuremodeinmanual' => { 80 => 0x10b },
	'exposureprogram' => { 115 => 0x8822, 372 => 0x1001, 385 => [0x17e,0x43], 392 => 0x3c, 393 => 0x3c, 394 => 0x5, 398 => 0x14, 403 => 0x3f, 410 => 0x2, 413 => 0x1175, 414 => 0x1179, 415 => 0x1155, 416 => 0x11d1, 417 => 0x11ad, 418 => 0x1065, 419 => 0x25d, 420 => 0x25d, 421 => 0x24c, 430 => 0xb, 431 => 0xc, 432 => 0xb, 434 => 0x48, 466 => 'ExposureProgram' },
	'exposureshift' => { 282 => 0x203 },
	'exposurestandardadjustment' => { 405 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 30 => 0x6, 31 => 0x7, 74 => 0x16, 115 => 0x829a, 132 => 0xfd05, 135 => 0x20, 137 => 0xfa24, 139 => 0xf104, 142 => 0x12, 144 => 0x38, 146 => 0x14, 147 => 0x10, 149 => 0x10, 151 => 'ExposureTime', 175 => 0x9, 176 => 0x35, 177 => 0x48, 178 => 0x8, 181 => 0x49b8, 340 => 0x12, 379 => 0xa018, 382 => [0x32,0x4a], 392 => 0x0, 393 => 0x0, 410 => [0x21,0x23,0x27], 434 => 0x10, 466 => 'ExposureTime' },
	'exposuretime2' => { 382 => [0x33,0x4b] },
	'exposuretuning' => { 218 => 0x1c },
	'exposurevalue' => { 133 => 0x3 },
	'exposurewarning' => { 123 => 0x1302 },
	'exrauto' => { 123 => 0x1033 },
	'exrmode' => { 123 => 0x1034 },
	'extendedwbdetect' => { 282 => 0x902 },
	'extender' => { 283 => 0x301 },
	'extenderfirmwareversion' => { 283 => 0x304 },
	'extendermagnification' => { 153 => 'Magnification' },
	'extendermake' => { 153 => 'Make' },
	'extendermodel' => { 153 => 'Model', 283 => 0x303 },
	'extenderserialnumber' => { 153 => 'SerialNumber', 283 => 0x302 },
	'extenderstatus' => { 338 => 0x3 },
	'externalflash' => { 285 => 0x1201 },
	'externalflashae1' => { 287 => 0x101f },
	'externalflashae1_0' => { 287 => 0x101b },
	'externalflashae2' => { 287 => 0x1020 },
	'externalflashae2_0' => { 287 => 0x101c },
	'externalflashbounce' => { 285 => 0x1204, 287 => 0x1026, 328 => 0x1a },
	'externalflashcompensation' => { 204 => 0x1b },
	'externalflashexposurecomp' => { 218 => 0x17, 328 => 0x19 },
	'externalflashfirmware' => { 202 => 0x6, 203 => 0x6, 204 => 0x6, 205 => 0x6, 206 => 0x6 },
	'externalflashflags' => { 202 => 0x8, 203 => 0x8, 204 => 0x8, 205 => 0x8 },
	'externalflashguidenumber' => { 285 => 0x1203, 328 => '24.1' },
	'externalflashgvalue' => { 287 => 0x1025 },
	'externalflashmode' => { 287 => 0x1028, 328 => 0x2 },
	'externalflashreadystate' => { 206 => '9.1' },
	'externalflashstatus' => { 206 => '8.2' },
	'externalflashzoom' => { 285 => 0x1205, 287 => 0x1027 },
	'externalflashzoomoverride' => { 206 => '8.1' },
	'externalmetadatalink' => { 472 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 300 => 0x311, 303 => 0x311, 304 => 0x311, 307 => 0x3408 },
	'extrainfoversion' => { 396 => 0x1a },
	'eyestartaf' => { 178 => 0x40 },
	'fac100per' => { 133 => 0xe94 },
	'fac170per' => { 133 => 0xe93 },
	'fac18per' => { 133 => 0xe92 },
	'face10position' => { 106 => 0x3f4, 107 => 0x1ec, 200 => 0x28, 325 => 0x12 },
	'face10size' => { 326 => 0x12 },
	'face11position' => { 200 => 0x2c, 325 => 0x14 },
	'face11size' => { 326 => 0x14 },
	'face12position' => { 200 => 0x30, 325 => 0x16 },
	'face12size' => { 326 => 0x16 },
	'face13position' => { 325 => 0x18 },
	'face13size' => { 326 => 0x18 },
	'face14position' => { 325 => 0x1a },
	'face14size' => { 326 => 0x1a },
	'face15position' => { 325 => 0x1c },
	'face15size' => { 326 => 0x1c },
	'face16position' => { 325 => 0x1e },
	'face16size' => { 326 => 0x1e },
	'face17position' => { 325 => 0x20 },
	'face17size' => { 326 => 0x20 },
	'face18position' => { 325 => 0x22 },
	'face18size' => { 326 => 0x22 },
	'face19position' => { 325 => 0x24 },
	'face19size' => { 326 => 0x24 },
	'face1position' => { 52 => 0x8, 106 => 0xd, 107 => 0x18, 200 => 0x4, 297 => 0x1, 325 => 0x0, 369 => 0xbc, 399 => 0x1, 400 => 0x0, 401 => 0x0, 402 => 0x5b },
	'face1size' => { 326 => 0x0 },
	'face20position' => { 325 => 0x26 },
	'face20size' => { 326 => 0x26 },
	'face21position' => { 325 => 0x28 },
	'face21size' => { 326 => 0x28 },
	'face22position' => { 325 => 0x2a },
	'face22size' => { 326 => 0x2a },
	'face23position' => { 325 => 0x2c },
	'face23size' => { 326 => 0x2c },
	'face24position' => { 325 => 0x2e },
	'face24size' => { 326 => 0x2e },
	'face25position' => { 325 => 0x30 },
	'face25size' => { 326 => 0x30 },
	'face26position' => { 325 => 0x32 },
	'face26size' => { 326 => 0x32 },
	'face27position' => { 325 => 0x34 },
	'face27size' => { 326 => 0x34 },
	'face28position' => { 325 => 0x36 },
	'face28size' => { 326 => 0x36 },
	'face29position' => { 325 => 0x38 },
	'face29size' => { 326 => 0x38 },
	'face2position' => { 52 => 0xa, 106 => 0x7c, 107 => 0x4c, 200 => 0x8, 297 => 0x5, 325 => 0x2, 369 => 0xc8, 399 => 0x6, 400 => 0x20, 401 => 0x25, 402 => 0x65 },
	'face2size' => { 326 => 0x2 },
	'face30position' => { 325 => 0x3a },
	'face30size' => { 326 => 0x3a },
	'face31position' => { 325 => 0x3c },
	'face31size' => { 326 => 0x3c },
	'face32position' => { 325 => 0x3e },
	'face32size' => { 326 => 0x3e },
	'face3position' => { 52 => 0xc, 106 => 0xeb, 107 => 0x80, 200 => 0xc, 297 => 0x9, 325 => 0x4, 369 => 0xd4, 399 => 0xb, 400 => 0x40, 401 => 0x4a, 402 => 0x6f },
	'face3size' => { 326 => 0x4 },
	'face4position' => { 52 => 0xe, 106 => 0x15a, 107 => 0xb4, 200 => 0x10, 297 => 0xd, 325 => 0x6, 369 => 0xe0, 399 => 0x10, 400 => 0x60, 401 => 0x6f, 402 => 0x79 },
	'face4size' => { 326 => 0x6 },
	'face5position' => { 52 => 0x10, 106 => 0x1c9, 107 => 0xe8, 200 => 0x14, 297 => 0x11, 325 => 0x8, 369 => 0xec, 399 => 0x15, 400 => 0x80, 401 => 0x94 },
	'face5size' => { 326 => 0x8 },
	'face6position' => { 52 => 0x12, 106 => 0x238, 107 => 0x11c, 200 => 0x18, 325 => 0xa, 369 => 0xf8, 399 => 0x1a, 400 => 0xa0, 401 => 0xb9 },
	'face6size' => { 326 => 0xa },
	'face7position' => { 52 => 0x14, 106 => 0x2a7, 107 => 0x150, 200 => 0x1c, 325 => 0xc, 369 => 0x104, 399 => 0x1f, 400 => 0xc0, 401 => 0xde },
	'face7size' => { 326 => 0xc },
	'face8position' => { 52 => 0x16, 106 => 0x316, 107 => 0x184, 200 => 0x20, 325 => 0xe, 369 => 0x110, 399 => 0x24, 400 => 0xe0, 401 => 0x103 },
	'face8size' => { 326 => 0xe },
	'face9position' => { 52 => 0x18, 106 => 0x385, 107 => 0x1b8, 200 => 0x24, 325 => 0x10 },
	'face9size' => { 326 => 0x10 },
	'facebalanceorigi' => { 454 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 454 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 454 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 454 => 'FaceBalanceWarmth' },
	'facedetect' => { 340 => 0x76, 379 => 0x100 },
	'facedetectarea' => { 286 => 0x1201 },
	'facedetectframecrop' => { 286 => 0x1207 },
	'facedetectframesize' => { 52 => 0x3, 106 => 0x1, 107 => 0x4, 200 => 0x1, 286 => 0x1203, 340 => 0x77, 369 => 0xb6 },
	'facedetection' => { 394 => 0x30, 410 => 0x19 },
	'faceelementpositions' => { 123 => 0x4203 },
	'faceelementselected' => { 123 => 0x4005 },
	'faceelementtypes' => { 123 => 0x4201 },
	'faceid' => { 456 => 'FaceID' },
	'faceinfounknown' => { 109 => 0x2089 },
	'facename' => { 379 => 0x123 },
	'faceorientation' => { 107 => 0x8 },
	'faceposition' => { 324 => 0x2, 380 => 0x4 },
	'facepositions' => { 123 => 0x4103 },
	'facerecognition' => { 379 => 0x120 },
	'facesdetected' => { 52 => 0x2, 53 => 0x2, 54 => 0x3, 106 => 0x0, 107 => 0x2, 109 => 0x211c, 123 => 0x4100, 200 => 0x3, 286 => 0x1200, 305 => 0x3f, 324 => 0x0, 369 => 0xb5, 380 => 0x0, 399 => 0x0, 402 => 0x3, 412 => 0x30 },
	'facesrecognized' => { 298 => 0x0 },
	'facewidth' => { 53 => 0x1 },
	'faithfuloutputhighlightpoint' => { 105 => 0x38 },
	'faithfuloutputshadowpoint' => { 105 => 0x39 },
	'faithfulrawcolortone' => { 105 => 0x31 },
	'faithfulrawcontrast' => { 105 => 0x33 },
	'faithfulrawhighlight' => { 105 => 0x79 },
	'faithfulrawhighlightpoint' => { 105 => 0x36 },
	'faithfulrawlinear' => { 105 => 0x34 },
	'faithfulrawsaturation' => { 105 => 0x32 },
	'faithfulrawshadow' => { 105 => 0x82 },
	'faithfulrawshadowpoint' => { 105 => 0x37 },
	'faithfulrawsharpness' => { 105 => 0x35 },
	'faithfulunsharpmaskfineness' => { 105 => 0xac },
	'faithfulunsharpmaskstrength' => { 105 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 105 => 0xae },
	'far' => { 445 => 'Far' },
	'fastresetlinetime' => { 133 => 0x1860 },
	'feedidentifier' => { 472 => 'FeedIdentifier' },
	'femicroadjustment' => { 80 => 0x111 },
	'ffid' => { 464 => 'ffid' },
	'field' => { 475 => 'field' },
	'fieldcount' => { 287 => 0x103f },
	'fieldofview' => { 365 => "FOV\x00" },
	'fifoenonepixeldelay' => { 133 => 0x1901 },
	'filecreatedate' => { 116 => 'FileCreateDate' },
	'filedatarate' => { 486 => 'fileDataRate' },
	'fileformat' => { 91 => 0x0, 128 => 0x14, 382 => [0x22,0x26], 405 => 0xb000 },
	'filegroupid' => { 116 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 306 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 116 => 'FileModifyDate' },
	'filename' => { 116 => 'FileName' },
	'filenameasdelivered' => { 292 => 'FileNameAsDelivered' },
	'filenumber' => { 55 => 0x1, 61 => 0x8, 93 => 0x1817, 110 => 'Canon::FileNumber', 201 => 0x4, 368 => 0x10 },
	'filenumbermemory' => { 175 => 0x1a },
	'filenumbersequence' => { 265 => '12.2', 270 => '3.1', 271 => '4.1', 272 => '4.1', 274 => '11.1', 275 => '4.3', 280 => '5.2' },
	'filepermissions' => { 116 => 'FilePermissions' },
	'filesource' => { 115 => 0xa300, 123 => 0x8000, 466 => 'FileSource' },
	'fileuserid' => { 116 => 'FileUserID' },
	'fileversion' => { 128 => 0x16 },
	'fillflashautoreduction' => { 78 => 0xe, 79 => 0xe, 86 => 0xa },
	'filllight' => { 460 => 'FillLight', 462 => 'FillLight' },
	'fillorder' => { 115 => 0x10a },
	'filmgraineffect' => { 282 => 0x538 },
	'filmmode' => { 123 => 0x1401, 302 => 0x412, 305 => 0x42 },
	'filmtype' => { 226 => 0x2 },
	'filtereffect' => { 55 => 0xe, 220 => 0x37, 221 => 0x3f, 222 => 0x47 },
	'filtereffectauto' => { 68 => 0xa0 },
	'filtereffectfaithful' => { 67 => 0x70, 68 => 0x70 },
	'filtereffectlandscape' => { 67 => 0x40, 68 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 67 => 0x88, 68 => 0x88 },
	'filtereffectneutral' => { 67 => 0x58, 68 => 0x58 },
	'filtereffectportrait' => { 67 => 0x28, 68 => 0x28 },
	'filtereffectstandard' => { 67 => 0x10, 68 => 0x10 },
	'filtereffectuserdef1' => { 67 => 0xa0, 68 => 0xb8 },
	'filtereffectuserdef2' => { 67 => 0xb8, 68 => 0xd0 },
	'filtereffectuserdef3' => { 67 => 0xd0, 68 => 0xe8 },
	'finderdisplayduringexposure' => { 79 => 0x1 },
	'finesharpness' => { 340 => 0x70 },
	'finetuneoptcenterweighted' => { 265 => '7.2', 266 => '9.1', 268 => '9.1', 269 => '9.1', 273 => '8.1', 278 => '9.1', 279 => '9.1', 280 => '9.1' },
	'finetuneopthighlightweighted' => { 268 => '46.1', 269 => '46.1', 278 => '46.1', 279 => '46.1' },
	'finetuneoptmatrixmetering' => { 265 => '8.1', 266 => '8.2', 268 => '8.2', 269 => '8.2', 273 => '7.2', 274 => '6.1', 278 => '8.2', 279 => '8.2', 280 => '8.2' },
	'finetuneoptspotmetering' => { 265 => '8.2', 266 => '9.2', 268 => '9.2', 269 => '9.2', 273 => '8.2', 274 => '6.2', 278 => '9.2', 279 => '9.2', 280 => '9.2' },
	'finishexposure' => { 133 => 0xdbd },
	'finishfiletype' => { 133 => 0xdb8 },
	'finishlook' => { 133 => 0xdbc },
	'finishnoise' => { 133 => 0xdba },
	'finishresolution' => { 133 => 0xdb9 },
	'finishsharpening' => { 133 => 0xdbb },
	'firmware' => { 287 => 0x405, 382 => [0x8c,0x17,0x3b], 457 => 'Firmware' },
	'firmware2' => { 382 => 0x57 },
	'firmwaredate' => { 108 => 0x15, 109 => 0x2001, 366 => 0x4, 368 => 0x30 },
	'firmwareid' => { 182 => 0x0 },
	'firmwarename' => { 379 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 61 => 0x1e, 370 => 0x0 },
	'firmwarerevision2' => { 370 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 133 => [0x415,0xce5], 149 => 0x57, 151 => 'FirmwareVersion', 303 => 0x320, 305 => 0x2, 307 => 0x3109, 340 => 0x230, 365 => ['CNFV','FIRM'], 367 => 0x18, 368 => 0x2a, 372 => 0x2 },
	'firmwareversions' => { 349 => 0x301 },
	'firstphotodate' => { 448 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 292 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 127 => 0x16, 455 => 'FixtureIdentifier' },
	'flash' => { 110 => 'XMP::Flash', 115 => 0x9209, 147 => 0x22, 176 => 0x1f, 177 => 0x15, 368 => 0x5a, 466 => 'Flash' },
	'flashaction' => { 392 => 0x3e, 393 => 0x3e, 405 => 0x2017, 410 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 392 => 0x4c, 393 => 0x4c, 410 => 0x77 },
	'flashactionexternal' => { 410 => [0x78,0x7c] },
	'flashactivity' => { 34 => 0x1c },
	'flashbatterylevel' => { 42 => 0x249 },
	'flashbias' => { 305 => 0x24 },
	'flashbits' => { 34 => 0x1d },
	'flashbuttonfunction' => { 80 => 0x70e },
	'flashchargelevel' => { 287 => 0x1010 },
	'flashcolorfilter' => { 204 => 0x10, 205 => 0x10 },
	'flashcommandermode' => { 202 => '9.1', 203 => '9.1', 204 => '9.1', 205 => '9.1' },
	'flashcompensation' => { 133 => 0x3f3, 202 => 0xa, 203 => 0xa, 204 => 0xa, 205 => 0x27, 206 => 0xa, 457 => 'FlashCompensation' },
	'flashcontrol' => { 392 => 0x23, 393 => 0x1f, 394 => 0x21 },
	'flashcontrolbuilt-in' => { 274 => '16.1', 275 => '23.1', 277 => '23.1', 278 => '24.1' },
	'flashcontrolmode' => { 202 => '9.2', 203 => '9.2', 204 => '9.2', 205 => '9.2', 282 => 0x404 },
	'flashcurtain' => { 305 => 0x48 },
	'flashdefault' => { 178 => 0x42 },
	'flashdevice' => { 287 => 0x1005 },
	'flashdistance' => { 109 => 0x2034 },
	'flashenergy' => { 115 => 0xa20b, 466 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 218 => 0x18 },
	'flashexposurecomp' => { 74 => 0xf, 123 => 0x1011, 154 => 'ExposureComp', 175 => 0x23, 180 => 0x104, 181 => 0x49c1, 218 => 0x12, 282 => 0x401, 287 => 0x1023, 340 => 0x4d, 372 => 0x100b, 382 => [0x3a,0x56], 405 => 0x104 },
	'flashexposurecomp2' => { 244 => 0x4d2 },
	'flashexposurecomp3' => { 204 => 0x1d },
	'flashexposurecomp4' => { 204 => 0x27 },
	'flashexposurecomparea' => { 266 => '38.4', 268 => '38.4', 269 => '38.4', 278 => '38.4', 279 => '38.4' },
	'flashexposurecompset' => { 178 => 0x10, 313 => 0xe, 392 => 0x14, 393 => 0x12, 394 => 0x23, 410 => 0x1f },
	'flashexposurecompset2' => { 410 => [0x26,0x2c] },
	'flashexposureindicator' => { 178 => 0x54 },
	'flashexposureindicatorlast' => { 178 => 0x56 },
	'flashexposureindicatornext' => { 178 => 0x55 },
	'flashexposurelock' => { 55 => 0x19 },
	'flashfired' => { 135 => 0x5d, 154 => 'Fired', 175 => 0x14, 243 => '590.3', 466 => [\'Flash','FlashFired'] },
	'flashfiring' => { 80 => 0x306, 81 => 0x6, 82 => 0x7, 85 => 0x7 },
	'flashfirmwareversion' => { 283 => 0x1002 },
	'flashfocallength' => { 202 => 0xb, 203 => 0xc, 204 => 0xc, 205 => 0xc, 206 => 0xc },
	'flashfunction' => { 181 => 0x31, 466 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 202 => 0xe, 203 => 0xf, 204 => 0xf, 205 => 0xf, 206 => 0xf },
	'flashgroupacompensation' => { 202 => 0x11, 203 => 0x12, 204 => 0x13, 205 => 0x28, 206 => 0x28 },
	'flashgroupacontrolmode' => { 202 => 0xf, 203 => '16.1', 204 => '17.1', 205 => '17.1', 206 => '17.1' },
	'flashgroupaoutput' => { 202 => 0x11, 203 => 0x12, 204 => 0x13, 205 => 0x28, 206 => 0x28 },
	'flashgroupbcompensation' => { 202 => 0x12, 203 => 0x13, 204 => 0x14, 205 => 0x29, 206 => 0x29 },
	'flashgroupbcontrolmode' => { 202 => 0x10, 203 => '17.1', 204 => '18.1', 205 => '18.1', 206 => '18.1' },
	'flashgroupboutput' => { 202 => 0x12, 203 => 0x13, 204 => 0x14, 205 => 0x29, 206 => 0x29 },
	'flashgroupccompensation' => { 203 => 0x14, 204 => 0x15, 205 => 0x2a, 206 => 0x2a },
	'flashgroupccontrolmode' => { 203 => '17.2', 204 => '18.2', 205 => '18.2', 206 => '18.2' },
	'flashgroupcoutput' => { 203 => 0x14, 204 => 0x15, 205 => 0x2a, 206 => 0x2a },
	'flashguidenumber' => { 74 => 0xd, 90 => 0x0, 154 => 'GuideNumber' },
	'flashintensity' => { 108 => [0x19,0x5], 282 => 0x405 },
	'flashlevel' => { 267 => 0x9, 405 => 0xb048 },
	'flashmake' => { 154 => 'Make' },
	'flashmanufacturer' => { 173 => 'FlashManufacturer' },
	'flashmetering' => { 175 => 0x3f, 178 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 340 => 0x20a },
	'flashmode' => { 108 => 0x4, 133 => 0x3f2, 135 => 0x5c, 146 => 0x27, 154 => 'Mode', 175 => 0x2, 176 => 0x20, 177 => 0x16, 178 => 0xf, 218 => 0x87, 282 => 0x400, 287 => 0x1004, 340 => 0xc, 347 => 0x4, 371 => 0x20, 372 => 0x100a, 381 => 0x225, 392 => 0x13, 393 => 0x7f, 394 => 0x20, 410 => 0x10, 413 => 0x1138, 414 => 0x1138, 415 => 0x1114, 416 => 0x1190, 417 => 0x116c, 418 => 0x1024, 419 => 0x21c, 420 => 0x21c, 421 => 0x211, 466 => [\'Flash','FlashMode'] },
	'flashmodel' => { 154 => 'Model', 173 => 'FlashModel', 283 => 0x1001 },
	'flashoptions' => { 321 => 0x2 },
	'flashoptions2' => { 321 => 0x10 },
	'flashoutput' => { 42 => 0x248, 74 => 0x21, 202 => 0xa, 203 => 0xa, 204 => 0xa, 205 => 0x27 },
	'flashpixversion' => { 115 => 0xa000, 466 => 'FlashpixVersion' },
	'flashredeyemode' => { 466 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 282 => 0x403 },
	'flashreturn' => { 466 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 154 => 'SerialNumber', 283 => 0x1003 },
	'flashsetting' => { 218 => 0x8 },
	'flashshutterspeed' => { 265 => '20.2', 266 => '23.2', 268 => '23.2', 269 => '23.2', 274 => '15.2', 275 => '22.2', 276 => '7.2', 277 => '22.2', 278 => '23.2', 279 => '23.2', 280 => '23.1' },
	'flashsource' => { 202 => 0x4, 203 => 0x4, 204 => 0x4, 205 => 0x4, 206 => 0x4 },
	'flashstatus' => { 328 => 0x0, 410 => [0x82,0x86], 423 => 0x31, 424 => 0x39 },
	'flashstatusbuilt-in' => { 394 => [0x87,0x287] },
	'flashstatusexternal' => { 394 => [0x88,0x288] },
	'flashsyncspeed' => { 265 => '20.1', 266 => '23.1', 268 => '23.1', 269 => '23.1', 274 => '15.1', 275 => '22.1', 277 => '22.1', 278 => '23.1', 279 => '23.1' },
	'flashsyncspeedav' => { 78 => 0x3, 80 => 0x10f, 81 => 0x2, 82 => 0x3, 83 => 0x2, 84 => 0x2, 85 => 0x3, 86 => 0x6 },
	'flashthreshold' => { 90 => 0x1 },
	'flashtype' => { 154 => 'Type', 178 => 0x59, 218 => 0x9, 283 => 0x1000 },
	'flashwarning' => { 275 => '30.1', 276 => '7.1', 280 => '31.1', 305 => 0x62 },
	'flexiblespotposition' => { 405 => 0x201d },
	'flickerreduce' => { 381 => 0x218 },
	'flickerreduction' => { 123 => 0x1446, 237 => 0xe84 },
	'flickerreductionindicator' => { 237 => 0x5e2 },
	'flightpitchdegree' => { 112 => 'FlightPitchDegree' },
	'flightrolldegree' => { 112 => 'FlightRollDegree' },
	'flightxspeed' => { 112 => 'FlightXSpeed' },
	'flightyawdegree' => { 112 => 'FlightYawDegree' },
	'flightyspeed' => { 112 => 'FlightYSpeed' },
	'flightzspeed' => { 112 => 'FlightZSpeed' },
	'fliphorizontal' => { 258 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 30 => 0x5, 31 => 0x6, 74 => 0x15, 115 => 0x829d, 132 => 0xfd04, 135 => 0x1e, 137 => 0xfa23, 139 => 0xf103, 142 => 0x13, 144 => 0x3c, 146 => 0x1c, 147 => 0x18, 149 => 0xc, 158 => 'FNumber', 175 => 0xa, 176 => 0x36, 177 => 0x47, 178 => 0x9, 181 => 0x49c7, 216 => 0x38, 340 => 0x13, 379 => 0xa019, 382 => [0x31,0x49], 392 => 0x1, 393 => 0x1, 410 => [0x20,0x22,0x26], 466 => 'FNumber' },
	'focaldistance' => { 446 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 57 => 0x1, 109 => 0x1d, 115 => 0x920a, 142 => 0x1d, 158 => 'FocalLength', 175 => 0x12, 211 => 0xa, 212 => 0xb, 216 => [0xc,0x3c], 299 => 0x1, 340 => 0x1d, 349 => 0x403, 372 => 0x1500, 391 => 0xe, 417 => 0x1278, 418 => 0x1134, 419 => 0x32c, 420 => 0x32c, 421 => 0x30a, 466 => 'FocalLength' },
	'focallength2' => { 410 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 115 => 0xa405, 379 => 0xa01a, 466 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 391 => 0x10 },
	'focalplaneafpointarea' => { 422 => 0x2 },
	'focalplaneafpointlocation1' => { 422 => 0x6 },
	'focalplaneafpointlocation10' => { 422 => 0x2a },
	'focalplaneafpointlocation11' => { 422 => 0x2e },
	'focalplaneafpointlocation12' => { 422 => 0x32 },
	'focalplaneafpointlocation13' => { 422 => 0x36 },
	'focalplaneafpointlocation14' => { 422 => 0x3a },
	'focalplaneafpointlocation15' => { 422 => 0x3e },
	'focalplaneafpointlocation2' => { 422 => 0xa },
	'focalplaneafpointlocation3' => { 422 => 0xe },
	'focalplaneafpointlocation4' => { 422 => 0x12 },
	'focalplaneafpointlocation5' => { 422 => 0x16 },
	'focalplaneafpointlocation6' => { 422 => 0x1a },
	'focalplaneafpointlocation7' => { 422 => 0x1e },
	'focalplaneafpointlocation8' => { 422 => 0x22 },
	'focalplaneafpointlocation9' => { 422 => 0x26 },
	'focalplaneafpointsused' => { 422 => 0x1 },
	'focalplanediagonal' => { 283 => 0x103, 287 => 0x205 },
	'focalplaneresolutionunit' => { 115 => 0xa210, 466 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 115 => 0xa20e, 466 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 57 => 0x2 },
	'focalplanexunknown' => { 57 => 0x2 },
	'focalplaneyresolution' => { 115 => 0xa20f, 466 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 57 => 0x3 },
	'focalplaneyunknown' => { 57 => 0x3 },
	'focalpointx' => { 446 => 'FocalPointX' },
	'focalpointy' => { 446 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 57 => 0x0 },
	'focalunits' => { 34 => 0x19 },
	'focus' => { 248 => 0x8 },
	'focusarea' => { 175 => 0x31 },
	'focusareaselection' => { 276 => '15.2' },
	'focuscontinuous' => { 34 => 0x20 },
	'focusdisplayaiservoandmf' => { 80 => 0x515 },
	'focusdistance' => { 158 => 'FocusDistance', 175 => 0x13, 181 => 0x49bb, 211 => 0x9, 212 => 0xa, 216 => [0xb,0x4f], 285 => 0x305, 299 => 0x0, 303 => 0x304, 304 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 55 => 0x15, 74 => 0x14 },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 55 => 0x14, 74 => 0x13 },
	'focusholdbutton' => { 178 => 0x44 },
	'focusinfoversion' => { 285 => 0x0 },
	'focusingscreen' => { 79 => 0x0, 80 => 0x80b, 85 => 0x0 },
	'focuslocation' => { 405 => 0x2027 },
	'focuslocked' => { 174 => 0x14 },
	'focusmode' => { 34 => 0x7, 108 => 0x3, 109 => [0x3003,0xd], 123 => 0x1021, 133 => 0x3f5, 135 => 0x38, 151 => 'FocusMode', 175 => 0x30, 177 => 0xe, 178 => 0xc, 218 => 0x7, 282 => 0x301, 287 => 0x100b, 305 => 0x7, 340 => 0xd, 347 => 0x3, 372 => 0x1006, 385 => [0xb,0x5], 391 => [0x15,0x1d], 392 => 0x4d, 393 => 0x4d, 405 => [0xb042,0xb04e,0x201b], 410 => 0x13, 428 => 0x16 },
	'focusmode2' => { 122 => '0.1', 321 => '3.1', 410 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 267 => '10.1', 389 => 0x14, 390 => 0x15, 392 => 0x10, 393 => 0xf, 394 => 0x6 },
	'focusmodeswitch' => { 178 => 0x58, 392 => 0x2e },
	'focuspixel' => { 123 => 0x1023 },
	'focuspointwrap' => { 265 => '2.2', 266 => '2.2', 268 => '2.1', 269 => '2.1', 273 => '1.1', 274 => '2.2', 275 => '1.1', 278 => '2.2', 279 => '2.1', 280 => '2.5' },
	'focusposition' => { 211 => 0x8, 212 => 0x8, 216 => 0x9, 340 => 0x10, 403 => 0x9bb },
	'focusposition2' => { 410 => [0x29,0x2b,0x2f], 428 => 0x2d, 431 => 0x20 },
	'focusprocess' => { 282 => 0x302 },
	'focusrange' => { 34 => 0x12, 287 => 0x100a },
	'focusrangeindex' => { 331 => '3.1' },
	'focusringrotation' => { 80 => 0x713 },
	'focussetting' => { 382 => 0x6 },
	'focusstatus' => { 391 => 0x19, 392 => 0x53, 393 => 0x53 },
	'focusstepcount' => { 285 => 0x301, 287 => 0x100e },
	'focusstepinfinity' => { 285 => 0x303, 287 => 0x103b },
	'focusstepnear' => { 285 => 0x304, 287 => 0x103c },
	'focustrackinglockon' => { 265 => ['1.5','4.1'], 266 => '1.4', 273 => '0.4', 274 => '3.1', 275 => '0.4', 278 => '1.4' },
	'focuswarning' => { 123 => 0x1301 },
	'foldername' => { 175 => 0x27 },
	'foldernumber' => { 392 => 0x9a, 394 => [0x402,0x114,0x316] },
	'fontcomposite' => { 491 => [\'Fonts','FontsComposite'] },
	'fontface' => { 491 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 491 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 491 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 491 => [\'Fonts','FontsFontName'] },
	'fonts' => { 491 => 'Fonts' },
	'fonttype' => { 491 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 491 => [\'Fonts','FontsVersionString'] },
	'for' => { 356 => 'For' },
	'forcewrite' => { 116 => 'ForceWrite' },
	'format' => { 365 => "\xa9fmt", 445 => 'Format', 463 => 'format', 484 => 'Format' },
	'forwardlock' => { 481 => 'forwardlock' },
	'forwardmatrix1' => { 115 => 0xc714 },
	'forwardmatrix2' => { 115 => 0xc715 },
	'fossilspecimen' => { 114 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 114 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 64 => [0x2,0x4] },
	'frameheight' => { 123 => 0x3822 },
	'framenum' => { 351 => 0xd7 },
	'framenumber' => { 123 => 0x8003, 181 => 0x3c, 340 => 0x29 },
	'framerate' => { 64 => [0x1,0x6], 115 => 0xc764, 123 => 0x3820 },
	'framereadouttime' => { 359 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 123 => 0x3821 },
	'framing' => { 475 => 'framing' },
	'freebytes' => { 93 => 0x1 },
	'freememorycardimages' => { 176 => [0x37,0x54], 177 => [0x2d,0x4a], 178 => 0x32 },
	'fujiflashmode' => { 123 => 0x1010 },
	'fullhdhighspeedrec' => { 123 => 0x3824 },
	'fullimagesize' => { 405 => 0xb02b },
	'fullpanoheightpixels' => { 448 => 'FullPanoHeightPixels', 449 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 448 => 'FullPanoWidthPixels', 449 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 372 => 0x100d },
	'fullsizeimage' => { 157 => 'data' },
	'fullsizeimagename' => { 157 => '1Name' },
	'fullsizeimagetype' => { 157 => '0Type' },
	'func1button' => { 268 => '14.1', 269 => '14.1', 279 => '14.1' },
	'func1buttonplusdials' => { 268 => '42.1', 269 => '42.1', 279 => '42.1' },
	'func2button' => { 268 => '80.1', 269 => '80.1', 279 => '80.1' },
	'func2buttonplusdials' => { 268 => '81.1' },
	'func3button' => { 268 => '83.1' },
	'funcbutton' => { 265 => ['14.1','15.1'], 266 => '14.1', 274 => '28.1', 275 => '13.1', 278 => '14.1', 280 => '14.1' },
	'funcbuttonplusdials' => { 265 => ['14.2','15.2'], 266 => '14.2', 274 => '31.1', 278 => '42.1' },
	'functionbutton' => { 272 => '13.1', 276 => '5.2' },
	'gainbase' => { 286 => 0x610 },
	'gaincontrol' => { 115 => 0xa407, 466 => 'GainControl' },
	'gamma' => { 115 => 0xa500, 133 => 0x8fe, 310 => 0x11c, 467 => 'Gamma' },
	'gammablackpoint' => { 101 => 0xc },
	'gammacolortone' => { 101 => 0x3 },
	'gammacompensatedvalue' => { 129 => 0x91 },
	'gammacontrast' => { 101 => 0x2 },
	'gammacurveoutputrange' => { 101 => 0xf },
	'gammahighlight' => { 101 => 0xa },
	'gammalinear' => { 99 => 0x20200 },
	'gammamidpoint' => { 101 => 0xe },
	'gammasaturation' => { 101 => 0x4 },
	'gammashadow' => { 101 => 0x9 },
	'gammasharpnessstrength' => { 101 => 0x8 },
	'gammaunsharpmaskfineness' => { 101 => 0x6 },
	'gammaunsharpmaskstrength' => { 101 => 0x5 },
	'gammaunsharpmaskthreshold' => { 101 => 0x7 },
	'gammawhitepoint' => { 101 => 0xd },
	'gdalmetadata' => { 115 => 0xa480 },
	'gdalnodata' => { 115 => 0xa481 },
	'geimagesize' => { 123 => 0x1304 },
	'gemake' => { 125 => 0x300 },
	'gemodel' => { 125 => 0x207 },
	'genre' => { 357 => ['gnre',"\xa9gen"], 359 => 'genre', 365 => ['gnre',"\xa9gen"], 472 => 'Genre', 476 => 'genre', 486 => 'genre' },
	'genrecvid' => { 472 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 472 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 472 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 472 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 357 => 'geID' },
	'geography' => { 477 => 'geography' },
	'geologicalcontext' => { 114 => 'GeologicalContext' },
	'geologicalcontextbed' => { 114 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 114 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 114 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 114 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 114 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 116 => 'Geosync' },
	'geotag' => { 116 => 'Geotag' },
	'geotiffasciiparams' => { 115 => 0x87b1 },
	'geotiffdirectory' => { 115 => 0x87af },
	'geotiffdoubleparams' => { 115 => 0x87b0 },
	'geotime' => { 116 => 'Geotime' },
	'giftftppriority' => { 450 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 112 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 112 => 'GimbalReverse' },
	'gimbalrolldegree' => { 112 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 112 => 'GimbalYawDegree' },
	'globalaltitude' => { 354 => 0x419 },
	'globalangle' => { 354 => 0x40d },
	'good' => { 486 => 'good' },
	'googlehostheader' => { 357 => 'gshh' },
	'googlepingmessage' => { 357 => 'gspm' },
	'googlepingurl' => { 357 => 'gspu' },
	'googleplusuploadcode' => { 115 => 0x9009 },
	'googlesourcedata' => { 357 => 'gssd' },
	'googlestarttime' => { 357 => 'gsst' },
	'googletrackduration' => { 357 => 'gstd' },
	'goprotype' => { 365 => 'GoPr' },
	'gpsaltitude' => { 126 => 0x6, 155 => 'Altitude', 466 => 'GPSAltitude' },
	'gpsaltituderef' => { 126 => 0x5, 466 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 126 => 0x1c, 466 => 'GPSAreaInformation' },
	'gpscoordinates' => { 359 => 'location.ISO6709', 365 => "\xa9xyz" },
	'gpsdatestamp' => { 126 => 0x1d },
	'gpsdatetime' => { 155 => 'DateTime', 466 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 126 => 0x18, 155 => 'Bearing', 466 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 126 => 0x17, 466 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 126 => 0x1a, 155 => 'Distance', 466 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 126 => 0x19, 466 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 126 => 0x14, 466 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 126 => 0x13 },
	'gpsdestlongitude' => { 126 => 0x16, 466 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 126 => 0x15 },
	'gpsdifferential' => { 126 => 0x1e, 155 => 'Differential', 466 => 'GPSDifferential' },
	'gpsdop' => { 126 => 0xb, 466 => 'GPSDOP' },
	'gpshpositioningerror' => { 126 => 0x1f, 466 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 126 => 0x11, 466 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 126 => 0x10, 466 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 112 => 'GpsLatitude', 126 => 0x2, 155 => 'Latitude', 466 => 'GPSLatitude' },
	'gpslatituderef' => { 126 => 0x1 },
	'gpslongitude' => { 112 => 'GpsLongitude', 126 => 0x4, 155 => 'Longitude', 466 => 'GPSLongitude' },
	'gpslongituderef' => { 126 => 0x3 },
	'gpslongtitude' => { 112 => 'GpsLongtitude' },
	'gpsmapdatum' => { 126 => 0x12, 155 => 'Datum', 466 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 126 => 0xa, 155 => 'MeasureMode', 466 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 126 => 0x1b, 466 => 'GPSProcessingMethod' },
	'gpssatellites' => { 126 => 0x8, 155 => 'Satellites', 466 => 'GPSSatellites' },
	'gpsspeed' => { 126 => 0xd, 155 => 'Speed', 466 => 'GPSSpeed' },
	'gpsspeedref' => { 126 => 0xc, 466 => 'GPSSpeedRef' },
	'gpsstatus' => { 126 => 0x9, 466 => 'GPSStatus' },
	'gpsstring' => { 133 => 0x402 },
	'gpstimestamp' => { 126 => 0x7 },
	'gpstrack' => { 126 => 0xf, 155 => 'Heading', 466 => 'GPSTrack' },
	'gpstrackref' => { 126 => 0xe, 466 => 'GPSTrackRef' },
	'gpsversionid' => { 126 => 0x0, 466 => 'GPSVersionID' },
	'gradation' => { 282 => 0x50f },
	'gradientbasedcorractive' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 460 => 'GradientBasedCorrections', 462 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 460 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 460 => 'GrainAmount', 462 => 'GrainAmount' },
	'graineffect' => { 123 => 0x1047 },
	'grainfrequency' => { 460 => 'GrainFrequency', 462 => 'GrainFrequency' },
	'grainsize' => { 460 => 'GrainSize', 462 => 'GrainSize' },
	'graymixeraqua' => { 460 => 'GrayMixerAqua', 462 => 'GrayMixerAqua' },
	'graymixerblue' => { 460 => 'GrayMixerBlue', 462 => 'GrayMixerBlue' },
	'graymixergreen' => { 460 => 'GrayMixerGreen', 462 => 'GrayMixerGreen' },
	'graymixermagenta' => { 460 => 'GrayMixerMagenta', 462 => 'GrayMixerMagenta' },
	'graymixerorange' => { 460 => 'GrayMixerOrange', 462 => 'GrayMixerOrange' },
	'graymixerpurple' => { 460 => 'GrayMixerPurple', 462 => 'GrayMixerPurple' },
	'graymixerred' => { 460 => 'GrayMixerRed', 462 => 'GrayMixerRed' },
	'graymixeryellow' => { 460 => 'GrayMixerYellow', 462 => 'GrayMixerYellow' },
	'graypoint' => { 438 => 0x8021 },
	'grayresponseunit' => { 115 => 0x122 },
	'greencurvelimits' => { 104 => 0x1c4 },
	'greencurvepoints' => { 103 => 0x53, 104 => 0x19a },
	'greenhsl' => { 99 => 0x20913 },
	'greenhue' => { 460 => 'GreenHue', 462 => 'GreenHue' },
	'greensaturation' => { 460 => 'GreenSaturation', 462 => 'GreenSaturation' },
	'griddisplay' => { 265 => '13.3', 266 => '4.3', 268 => '4.2', 269 => '4.2', 270 => '2.2', 274 => '10.5', 275 => '3.4', 276 => '6.1', 278 => '4.4', 279 => '4.2', 280 => '4.2' },
	'gripbatteryadload' => { 319 => 0x5 },
	'gripbatteryadnoload' => { 319 => 0x4 },
	'gripbatterystate' => { 319 => '1.2' },
	'groupareaafillumination' => { 266 => '46.4', 269 => '47.4', 278 => '47.4' },
	'grouping' => { 357 => ['grup',"\xa9grp"], 365 => "\xa9grp" },
	'guid' => { 357 => 'GUID' },
	'h2resetblackpixels' => { 133 => 0x18a6 },
	'h3resetblackcolumns' => { 133 => 0x18ce },
	'h3resetblackpixels' => { 133 => 0x18b0 },
	'halftonehints' => { 115 => 0x141 },
	'hardlink' => { 116 => 'HardLink' },
	'hasalternative' => { 476 => 'hasAlternative' },
	'hascorrection' => { 476 => 'hasCorrection' },
	'hascorrectiona-lang' => { 476 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 476 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 476 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 460 => 'HasCrop', 462 => 'HasCrop' },
	'hasextendedxmp' => { 488 => 'HasExtendedXMP' },
	'hassettings' => { 460 => 'HasSettings', 462 => 'HasSettings' },
	'hastranslation' => { 476 => 'hasTranslation' },
	'hasvisibleoverprint' => { 491 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 491 => 'HasVisibleTransparency' },
	'hdr' => { 58 => 0x1, 208 => 0x4, 305 => 0x9e, 340 => 0x85, 405 => 0x200a },
	'hdreffect' => { 58 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 208 => 0x0 },
	'hdrlevel' => { 208 => 0x5, 394 => 0x2e, 410 => 0x17 },
	'hdrlevel2' => { 208 => 0x7 },
	'hdrpmakernote' => { 443 => 'hdrp_makernote' },
	'hdrsetting' => { 394 => 0x2d, 410 => 0x16, 413 => 0x1148, 414 => 0x1148, 415 => 0x1124, 416 => 0x11a0, 417 => 0x117c, 418 => 0x1034, 419 => 0x22c, 420 => 0x22c, 421 => 0x21f },
	'hdrshot' => { 305 => 0x76 },
	'hdrsmoothing' => { 208 => 0x6 },
	'hdvideo' => { 357 => 'hdvd' },
	'headline' => { 127 => 0x69, 472 => 'Headline', 474 => 'Headline' },
	'hierarchicalkeywords' => { 166 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 166 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 166 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 166 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 166 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 166 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 166 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 166 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 166 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 166 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 166 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 166 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 166 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 166 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 166 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 166 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 166 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 166 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 452 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 114 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 310 => 0x1a },
	'highisomultipliergreen' => { 310 => 0x19 },
	'highisomultiplierred' => { 310 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 60 => 0x5, 80 => 0x202, 218 => 0xb1, 340 => 0x71, 392 => 0x2c, 393 => 0x26, 394 => 0x26, 405 => 0x2009, 410 => 0x12, 434 => 0x42 },
	'highisonoisereduction2' => { 405 => 0xb050 },
	'highlight' => { 382 => 0xf },
	'highlight2012' => { 460 => 'Highlight2012', 462 => 'Highlight2012' },
	'highlightadj' => { 99 => 0x2030c },
	'highlightcolordistortreduct' => { 438 => 0x8026 },
	'highlightlinearitylimit' => { 379 => 0xa025 },
	'highlightprotection' => { 257 => 0x6 },
	'highlightrecovery' => { 460 => 'HighlightRecovery', 462 => 'HighlightRecovery' },
	'highlights' => { 454 => 'Highlights' },
	'highlights2012' => { 460 => 'Highlights2012', 462 => 'Highlights2012' },
	'highlightsadj' => { 438 => 0x9019 },
	'highlightshadow' => { 305 => 0xad },
	'highlighttone' => { 123 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 60 => 0x3, 80 => 0x203 },
	'highlightwarning' => { 305 => 0x8002 },
	'highlowkeyadj' => { 340 => 0x6c },
	'highspeedsync' => { 178 => 0x5, 392 => 0x2, 393 => 0x2 },
	'hintversion' => { 365 => 'hinv' },
	'histogramxml' => { 258 => 0x83a1a25 },
	'history' => { 474 => 'History', 487 => 'History' },
	'historyaction' => { 487 => [\'History','HistoryAction'] },
	'historychanged' => { 487 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 487 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 487 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 487 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 487 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 133 => 0xc88 },
	'holefilldeltathreshold' => { 133 => 0xc7e },
	'hometowncity' => { 109 => 0x3006, 340 => 0x23, 346 => 0x2 },
	'hometowncitycode' => { 347 => 0x1000 },
	'hometowndst' => { 340 => 0x25, 346 => '0.2' },
	'hostcomputer' => { 115 => 0x13c },
	'hostsoftwarerendering' => { 133 => 0xce7 },
	'hue' => { 183 => 0x3b, 221 => 0x3d, 222 => 0x45, 340 => 0x67 },
	'hueadj' => { 261 => 0x2f, 438 => 0x8019 },
	'hueadjust' => { 372 => 0x1016 },
	'hueadjustment' => { 176 => 0x4a, 177 => 0x40, 218 => 0x92, 220 => 0x36 },
	'hueadjustmentaqua' => { 460 => 'HueAdjustmentAqua', 462 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 460 => 'HueAdjustmentBlue', 462 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 460 => 'HueAdjustmentGreen', 462 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 460 => 'HueAdjustmentMagenta', 462 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 460 => 'HueAdjustmentOrange', 462 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 460 => 'HueAdjustmentPurple', 462 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 460 => 'HueAdjustmentRed', 462 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 460 => 'HueAdjustmentYellow', 462 => 'HueAdjustmentYellow' },
	'huesetting' => { 290 => 0x1011 },
	'humanobservation' => { 114 => 'HumanObservation' },
	'humanobservationday' => { 114 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 114 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 114 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 114 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 114 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 114 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 114 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 114 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 114 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 114 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 114 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 114 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 114 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 114 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 114 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 114 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 114 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 114 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 114 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 114 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 115 => 0x9401, 467 => 'Humidity' },
	'icc_profile' => { 116 => 'ICC_Profile' },
	'iccprofilename' => { 474 => 'ICCProfile' },
	'iconuri' => { 365 => 'icnu' },
	'idccreativestyle' => { 438 => 0x8000 },
	'idcpreviewlength' => { 438 => 0x202 },
	'idcpreviewstart' => { 438 => 0x201 },
	'identification' => { 114 => 'Identification' },
	'identificationid' => { 114 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 114 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 114 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 114 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 114 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 114 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 463 => 'identifier', 484 => 'Identifier' },
	'ifcameramodel' => { 133 => 0x9c8 },
	'illumination' => { 276 => '0.5', 367 => 0x48 },
	'imageabsolutex' => { 133 => 0x3fe },
	'imageabsolutey' => { 133 => 0x3ff },
	'imageadjustment' => { 218 => 0x80, 248 => 0x5 },
	'imagealterationconstraints' => { 292 => 'ImageAlterationConstraints' },
	'imagearea' => { 231 => 0x10, 234 => 0x10 },
	'imageareaoffset' => { 340 => 0x38 },
	'imageauthentication' => { 218 => 0x20 },
	'imageboundary' => { 218 => 0x16 },
	'imagecount' => { 123 => 0x1438, 218 => 0xa5, 408 => 0x11b },
	'imagecreator' => { 292 => 'ImageCreator' },
	'imagecreatorid' => { 292 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 292 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 292 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 133 => 0x41f },
	'imagecropy' => { 133 => 0x420 },
	'imagedata' => { 447 => 'Data' },
	'imagedatasize' => { 218 => 0xa2 },
	'imagedescription' => { 115 => 0x10e, 482 => 'ImageDescription' },
	'imageduplicationconstraints' => { 292 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 258 => 0xfe443a45 },
	'imageeditcount' => { 340 => 0x41 },
	'imageediting' => { 340 => 0x32 },
	'imageeffects' => { 372 => 0x1010 },
	'imagefileconstraints' => { 292 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 292 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 292 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 123 => 0x1436 },
	'imageheight' => { 115 => 0x101, 182 => 0xc, 349 => 0x10d, 445 => 'ImageHeight', 482 => 'ImageLength' },
	'imagehistory' => { 115 => 0x9213, 465 => 'ImageHistory' },
	'imageidnumber' => { 300 => 0x340 },
	'imagemimetype' => { 447 => 'Mime' },
	'imagenumber' => { 115 => 0x9211, 151 => 'ImageNumber', 176 => 0xae, 177 => 0x5e, 349 => 0x113, 392 => 0x9b, 394 => [0x400,'276.1',0x314], 457 => 'ImageNumber' },
	'imagenumber2' => { 177 => 0x62 },
	'imageoptimization' => { 218 => 0xa9 },
	'imageorientation' => { 127 => 0x83 },
	'imageprocessing' => { 218 => 0x1a },
	'imageprocessingfiledatecreated' => { 133 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 133 => 0xc80 },
	'imageprocessingversion' => { 286 => 0x0 },
	'imagequality' => { 151 => 'ImageQuality', 233 => '723.2', 234 => '732.2', 243 => '708.1', 305 => 0x1 },
	'imagequality2' => { 282 => 0x603 },
	'imagerank' => { 450 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 133 => 0x600 },
	'imagerboardversion' => { 133 => 0x439 },
	'imagercols' => { 133 => 0x17d4 },
	'imageref' => { 470 => 'ImageRef' },
	'imageregion' => { 472 => 'ImageRegion' },
	'imageregionboundary' => { 472 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 472 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 472 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 472 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 472 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 472 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 472 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 472 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 472 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 472 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 472 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 472 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 472 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 472 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 472 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 472 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 472 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 472 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 472 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 133 => 0x944 },
	'imageresolutionjpg' => { 133 => 0x945 },
	'imagereview' => { 267 => '0.4', 276 => '0.4' },
	'imagereviewmonitorofftime' => { 266 => '21.1', 268 => '21.1', 269 => '21.1', 273 => '20.1', 278 => '21.1', 279 => '21.1' },
	'imagereviewtime' => { 265 => '25.1', 267 => '2.1', 270 => '19.1', 271 => '20.1', 272 => '20.1', 274 => '9.2', 275 => '20.1', 280 => '21.2' },
	'imagerfiledatecreated' => { 133 => 0x9c5 },
	'imagerfileproductionlevel' => { 133 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 133 => 0x9c7 },
	'imagerotated' => { 146 => 0x2a },
	'imagerpowerondelaymsec' => { 133 => 0x5fd },
	'imagerrows' => { 133 => 0x17de },
	'imagesegmentlines' => { 133 => 0x184d },
	'imagesegmentstartline' => { 133 => 0x184c },
	'imagesize' => { 157 => 'ImageSize' },
	'imagesizerestriction' => { 479 => 'imageSizeRestriction' },
	'imagesourcedata' => { 115 => 0x935c },
	'imagespace' => { 133 => 0x909 },
	'imagestabilization' => { 34 => 0x22, 109 => 0x3020, 123 => 0x1422, 151 => 'ImageStabilization', 176 => 0xbd, 177 => 0x71, 178 => 0x57, 179 => 0x0, 180 => [0x18,0x107,0x113], 181 => 0x49c2, 218 => 0xac, 282 => 0x604, 285 => 0x1600, 305 => 0x1a, 397 => 0x12, 398 => 0x11, 405 => 0xb026 },
	'imagestabilization2' => { 396 => 0xa },
	'imagestabilizationsetting' => { 181 => 0x14, 392 => 0x3d, 393 => 0x3d, 403 => 0x14 },
	'imagestyle' => { 392 => 0x2d, 393 => 0x27 },
	'imagesupplier' => { 292 => 'ImageSupplier' },
	'imagesupplierid' => { 292 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 292 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 292 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 117 => 0x1 },
	'imagetemperaturemin' => { 117 => 0x2 },
	'imagetone' => { 340 => 0x4f },
	'imagetype' => { 127 => 0x82, 292 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 61 => 0x28, 115 => 0xa420, 465 => 'ImageUniqueID', 466 => 'ImageUniqueID' },
	'imagewidth' => { 115 => 0x100, 182 => 0xe, 349 => 0x10c, 445 => 'ImageWidth', 482 => 'ImageWidth' },
	'inclinationangle' => { 438 => 0x900f },
	'inclinationcorrection' => { 438 => 0x900e },
	'incrementaltemperature' => { 460 => 'IncrementalTemperature', 462 => 'IncrementalTemperature' },
	'incrementaltint' => { 460 => 'IncrementalTint', 462 => 'IncrementalTint' },
	'industry' => { 476 => 'industry', 477 => 'industry' },
	'infobuttonwhenshooting' => { 80 => 0x409 },
	'information' => { 359 => 'information', 365 => "\xa9inf" },
	'infourl' => { 365 => 'infu' },
	'infraredilluminator' => { 366 => 0x28 },
	'ingredientexclusion' => { 478 => 'ingredientExclusion' },
	'ingredients' => { 487 => 'Ingredients' },
	'ingredientsalternatepaths' => { 487 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 487 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 487 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 487 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 487 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 487 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 487 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 487 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 487 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 487 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 487 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 487 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 487 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 487 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 487 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 487 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 487 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 487 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 487 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 487 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 487 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 487 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 487 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 80 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 448 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 448 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 448 => 'InitialViewHeadingDegrees', 449 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 448 => 'InitialViewPitchDegrees', 449 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 448 => 'InitialViewRollDegrees', 449 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 265 => '4.4' },
	'initialzoomsetting' => { 265 => '9.3', 274 => '27.3' },
	'inkset' => { 115 => 0x14c },
	'inputprofile' => { 133 => 0x1389 },
	'instanceid' => { 487 => 'InstanceID' },
	'instantplaybacksetup' => { 178 => 0x3e },
	'instantplaybacktime' => { 178 => 0x3d },
	'instructions' => { 474 => 'Instructions' },
	'instrument' => { 486 => 'instrument' },
	'integrationtime' => { 133 => 0x423 },
	'intellectualgenre' => { 471 => 'IntellectualGenre' },
	'intelligentauto' => { 405 => 0xb052, 430 => 0xd, 431 => 0xe, 432 => 0xd },
	'intelligentcontrast' => { 50 => 0x4 },
	'intelligentd-range' => { 305 => 0x79 },
	'intelligentexposure' => { 305 => 0x5d },
	'intelligentresolution' => { 305 => 0x70 },
	'interchangecolorspace' => { 129 => 0x40 },
	'intergraphmatrix' => { 115 => 0x8480 },
	'internalflash' => { 175 => 0x2b, 265 => '23.1', 267 => '8.1', 270 => '22.1', 272 => '23.1', 276 => '8.1', 280 => '24.1', 285 => 0x1208 },
	'internalflashae1' => { 287 => 0x1021 },
	'internalflashae1_0' => { 287 => 0x101d },
	'internalflashae2' => { 287 => 0x1022 },
	'internalflashae2_0' => { 287 => 0x101e },
	'internalflashmode' => { 328 => 0x1 },
	'internalflashstrength' => { 328 => 0x3 },
	'internalflashtable' => { 287 => 0x1024 },
	'internallensserialnumber' => { 379 => 0xa005 },
	'internalndfilter' => { 305 => 0x9d },
	'internalserialnumber' => { 61 => 0x96, 73 => 0x9, 123 => 0x10, 181 => 0x49dc, 281 => 0x18, 283 => 0x102, 302 => 0x500, 305 => 0x25, 320 => 0x4, 372 => 0x5, 423 => [0x7c,0xf0], 424 => 0x88 },
	'interopindex' => { 115 => 0x1, 467 => 'InteroperabilityIndex' },
	'interopversion' => { 115 => 0x2 },
	'intervallength' => { 175 => 0x10 },
	'intervalmode' => { 175 => 0x26 },
	'intervalnumber' => { 175 => 0x11 },
	'intervalshooting' => { 340 => 0x92 },
	'introtime' => { 486 => 'introTime' },
	'introtimescale' => { 486 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 486 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 133 => 0xdae },
	'ipfcameramodel' => { 133 => 0xe4d },
	'iptc' => { 116 => 'IPTC' },
	'iptc-naa' => { 115 => 0x83bb, 310 => 0x83bb },
	'iptcbitspersample' => { 129 => 0x56 },
	'iptcdigest' => { 354 => 0x425 },
	'iptcimageheight' => { 129 => 0x1e },
	'iptcimagerotation' => { 129 => 0x66 },
	'iptcimagewidth' => { 129 => 0x14 },
	'iptclastedited' => { 472 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 129 => 0xa },
	'iptcpixelheight' => { 129 => 0x32 },
	'iptcpixelwidth' => { 129 => 0x28 },
	'isalternativeof' => { 476 => 'isAlternativeOf' },
	'isbn' => { 476 => 'isbn' },
	'iscorrectionof' => { 476 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 105 => 0x3 },
	'ismergedhdr' => { 457 => 'IsMergedHDR' },
	'ismergedpanorama' => { 457 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 30 => 0x0, 31 => 0x1, 108 => 0x14, 109 => [0x3014,0x14], 115 => 0x8827, 132 => 0xfd06, 133 => 0x1784, 135 => 0x60, 137 => [0xfa2e,0xfa46], 138 => [0x27,0x28], 139 => 0xf105, 142 => 0x14, 144 => 0x4e, 146 => 0x1e, 147 => 0x1a, 149 => 0x34, 151 => 'ISO', 175 => 0x8, 181 => 0x49ba, 209 => 0x0, 218 => 0x2, 305 => 0xd1, 310 => 0x17, 340 => [0x8b,0x14], 347 => 0x14, 349 => 0x105, 379 => 0xa014, 382 => 0x86, 403 => 0x6f, 410 => [0x1f,0x21,0x25], 466 => 'ISOSpeedRatings' },
	'iso2' => { 209 => 0x6, 228 => 0x265, 229 => 0x25c, 230 => 0x265, 231 => 0x221, 232 => 0x25d, 233 => 0x256, 234 => 0x25d, 238 => 0x2b5, 241 => 0x265, 247 => 0x2b5 },
	'isoauto' => { 321 => '14.4' },
	'isoautohilimit' => { 236 => 0x18eb, 237 => 0xe82, 245 => 0x185d },
	'isoautomax' => { 404 => 0x4 },
	'isoautomin' => { 404 => 0x2 },
	'isoautoparameters' => { 340 => 0x7a },
	'isoautoshuttertime' => { 236 => 0x18ea, 237 => 0xe81, 245 => 0x185c },
	'isocalibrationgain' => { 133 => 0x89f },
	'isodisplay' => { 268 => '4.1', 269 => '4.1', 270 => '2.3', 271 => '3.3', 272 => '3.3', 275 => '3.3', 278 => '4.3', 279 => '4.1', 280 => '4.3' },
	'isoexpansion' => { 80 => 0x103, 81 => 0x7, 82 => 0x8, 85 => 0x8, 209 => 0x4 },
	'isoexpansion2' => { 209 => 0xa },
	'isofloor' => { 321 => 0x6 },
	'isoselection' => { 218 => 0xf },
	'isosensitivitystep' => { 273 => '6.2', 275 => '6.2' },
	'isosetting' => { 135 => 0x5e, 147 => 0x14, 151 => 'ISOSetting', 175 => 0x24, 176 => 0x26, 177 => 0x1c, 178 => 0x13, 183 => 0x6, 218 => 0x13, 321 => '17.3', 371 => 0x27, 392 => 0x16, 393 => 0x14, 394 => 0x2, 403 => 0x6d, 404 => 0x0 },
	'isospeed' => { 115 => 0x8833, 467 => 'ISOSpeed' },
	'isospeedexpansion' => { 79 => 0x3 },
	'isospeedincrements' => { 80 => 0x102 },
	'isospeedlatitudeyyy' => { 115 => 0x8834, 467 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 115 => 0x8835, 467 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 80 => 0x103 },
	'isostepsize' => { 265 => '6.1', 266 => '7.2', 268 => '7.2', 269 => '7.2', 274 => '4.1', 278 => '7.2', 279 => '7.2' },
	'isovalue' => { 287 => 0x1001 },
	'isrccode' => { 365 => "\xa9isr" },
	'issn' => { 476 => 'issn' },
	'issueidentifier' => { 476 => 'issueIdentifier' },
	'issuename' => { 476 => 'issueName' },
	'issueteaser' => { 476 => 'issueTeaser' },
	'issuetype' => { 476 => 'issueType' },
	'istranslationof' => { 476 => 'isTranslationOf' },
	'itemsubtype' => { 173 => 'ItemSubType' },
	'itunesu' => { 357 => 'itnu' },
	'jobid' => { 127 => 0xb8 },
	'jobname' => { 468 => 'JobName' },
	'jobref' => { 485 => 'JobRef' },
	'jobrefid' => { 485 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 485 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 485 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 468 => 'JobStatus' },
	'jpeghandling' => { 460 => 'JPEGHandling', 462 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 305 => 0x43, 307 => 0x3034, 405 => 0xb047 },
	'jpegsize' => { 307 => 0x303a },
	'jpgcompression' => { 237 => 0x7d4 },
	'jpgfromraw' => { 93 => 0x2007, 110 => 'Exif::JpgFromRaw', 310 => 0x2e },
	'jpgfromrawlength' => { 115 => [0x117,0x202] },
	'jpgfromrawstart' => { 115 => [0x111,0x201] },
	'jpgrecordedpixels' => { 321 => '14.1' },
	'jurisdiction' => { 458 => 'jurisdiction' },
	'kelvinwb_01' => { 329 => 0x5 },
	'kelvinwb_02' => { 329 => 0x9 },
	'kelvinwb_03' => { 329 => 0xd },
	'kelvinwb_04' => { 329 => 0x11 },
	'kelvinwb_05' => { 329 => 0x15 },
	'kelvinwb_06' => { 329 => 0x19 },
	'kelvinwb_07' => { 329 => 0x1d },
	'kelvinwb_08' => { 329 => 0x21 },
	'kelvinwb_09' => { 329 => 0x25 },
	'kelvinwb_10' => { 329 => 0x29 },
	'kelvinwb_11' => { 329 => 0x2d },
	'kelvinwb_12' => { 329 => 0x31 },
	'kelvinwb_13' => { 329 => 0x35 },
	'kelvinwb_14' => { 329 => 0x39 },
	'kelvinwb_15' => { 329 => 0x3d },
	'kelvinwb_16' => { 329 => 0x41 },
	'kelvinwb_daylight' => { 329 => 0x1 },
	'kerneldenominators' => { 133 => 0x933 },
	'key' => { 486 => 'key' },
	'keystonecompensation' => { 286 => 0x1900 },
	'keystonedirection' => { 286 => 0x1901 },
	'keystonevalue' => { 286 => 0x1906 },
	'keyword' => { 357 => 'keyw', 476 => 'keyword' },
	'keywordinfo' => { 166 => 'Keywords' },
	'keywords' => { 127 => 0x19, 152 => 'Keywords', 291 => 'Keywords', 356 => 'Keywords', 359 => 'keywords', 455 => 'keywords', 473 => 'Keywords', 484 => 'Keywords' },
	'killdate' => { 476 => 'killDate' },
	'killdatea-platform' => { 476 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 476 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 132 => 0xf908, 135 => 0xe, 137 => [0xfa1e,0xfa52], 143 => 0x70 },
	'kodakimagewidth' => { 132 => 0xf907, 135 => 0xc, 137 => [0xfa1d,0xfa51], 143 => 0x6c },
	'kodakinfotype' => { 132 => 0xfa00 },
	'kodaklook' => { 133 => 0xe4c },
	'kodaklookprofile' => { 133 => 0x138a },
	'kodakmaker' => { 143 => 0x8 },
	'kodakmodel' => { 135 => 0x0, 143 => 0x28 },
	'kodaktag' => { 133 => 0x3ea },
	'kodakversion' => { 133 => 0x0 },
	'label' => { 295 => 'Label', 484 => 'Label' },
	'labelname1' => { 470 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 470 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 470 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 470 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 470 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 470 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 305 => 0x6f },
	'landscapeoutputhighlightpoint' => { 105 => 0x26 },
	'landscapeoutputshadowpoint' => { 105 => 0x27 },
	'landscaperawcolortone' => { 105 => 0x1f },
	'landscaperawcontrast' => { 105 => 0x21 },
	'landscaperawhighlight' => { 105 => 0x77 },
	'landscaperawhighlightpoint' => { 105 => 0x24 },
	'landscaperawlinear' => { 105 => 0x22 },
	'landscaperawsaturation' => { 105 => 0x20 },
	'landscaperawshadow' => { 105 => 0x80 },
	'landscaperawshadowpoint' => { 105 => 0x25 },
	'landscaperawsharpness' => { 105 => 0x23 },
	'landscapeunsharpmaskfineness' => { 105 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 105 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 105 => 0xa2 },
	'language' => { 463 => 'language' },
	'languageidentifier' => { 127 => 0x87 },
	'largestvalidinteriorrectheight' => { 448 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 448 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 448 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 448 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 175 => 0x1b },
	'lastkeywordiptc' => { 173 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 173 => 'LastKeywordXMP' },
	'lastphotodate' => { 448 => 'LastPhotoDate' },
	'lasturl' => { 487 => 'LastURL' },
	'lateralchromaticaberration' => { 405 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 457 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 114 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 114 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 114 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 114 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 114 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 112 => 'Latitude' },
	'lc1' => { 331 => 0x2 },
	'lc10' => { 331 => 0xb },
	'lc11' => { 331 => 0xc },
	'lc12' => { 331 => 0xd },
	'lc14' => { 331 => 0xf },
	'lc15' => { 331 => 0x10 },
	'lc3' => { 331 => 0x4 },
	'lc4' => { 331 => 0x5 },
	'lc5' => { 331 => 0x6 },
	'lc6' => { 331 => 0x7 },
	'lc7' => { 331 => 0x8 },
	'lc8' => { 331 => 0x9 },
	'lcddisplayatpoweron' => { 80 => 0x811, 84 => 0xa },
	'lcddisplayreturntoshoot' => { 85 => 0x12 },
	'lcdillumination' => { 265 => '17.5', 266 => '5.2', 268 => '5.1', 269 => '5.1', 274 => '10.3', 275 => '4.2', 278 => '5.2', 279 => '5.1', 280 => '5.4' },
	'lcdilluminationduringbulb' => { 80 => 0x408 },
	'lcdmatrix' => { 133 => 0xe74 },
	'lcdmatrixchickfix' => { 133 => 0xe75 },
	'lcdmatrixmarvin' => { 133 => 0xe76 },
	'lcdpanels' => { 79 => 0x8 },
	'lcheditor' => { 258 => 0x8ae85e },
	'legacyiptcdigest' => { 474 => 'LegacyIPTCDigest' },
	'legalcode' => { 458 => 'legalcode' },
	'lens' => { 115 => 0xfdea, 218 => 0x84, 457 => 'Lens' },
	'lensafstopbutton' => { 78 => 0x11, 79 => 0x13, 80 => 0x506, 81 => 0x10, 82 => 0x12, 85 => 0x13, 86 => 0x9 },
	'lensaperturerange' => { 382 => [0x30,0x48] },
	'lenscorrectionsettings' => { 465 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 457 => 'LensDistortInfo' },
	'lensdistortionparams' => { 287 => 0x206 },
	'lensdrivenoaf' => { 80 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 394 => 0x3f0, 437 => 0xd },
	'lensfirmware' => { 373 => 0x20, 379 => 0xa004 },
	'lensfirmwareversion' => { 283 => 0x204, 305 => 0x60, 394 => 0x3f3, 437 => 0x14 },
	'lensfocallength' => { 99 => 0xf0512, 331 => 0x9 },
	'lensfocalrange' => { 382 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 266 => '55.1', 268 => '52.1', 269 => '52.1', 278 => '52.1', 279 => '52.1' },
	'lensformat' => { 417 => 0x1891, 419 => 0x18bd, 420 => 0x18ed, 421 => 0x17f1, 423 => 0x106, 424 => 0x106, 433 => 0x603, 434 => 0x5d },
	'lensfstops' => { 210 => 0x7, 211 => 0xc, 212 => 0xd, 216 => 0xe, 218 => 0x8b, 331 => '0.3' },
	'lensid' => { 216 => 0x30, 457 => 'LensID' },
	'lensidnumber' => { 210 => 0x6, 211 => 0xb, 212 => 0xc, 216 => 0xd },
	'lensinfo' => { 115 => 0xa432, 337 => 0x2a, 457 => 'LensInfo', 467 => 'LensSpecification' },
	'lenskind' => { 331 => 0x1 },
	'lensmake' => { 115 => 0xa433, 158 => 'Make', 467 => 'LensMake' },
	'lensmanualdistortionamount' => { 460 => 'LensManualDistortionAmount', 462 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 173 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 382 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 61 => 0x95, 115 => 0xa434, 158 => 'Model', 173 => 'LensModel', 213 => 0x18a, 214 => 0x18b, 215 => 0x2ac, 283 => 0x203, 337 => 0xc, 349 => 0x412, 467 => 'LensModel' },
	'lensmodulationoptimizer' => { 123 => 0x1045 },
	'lensmount' => { 394 => 0x99, 417 => 0x1892, 419 => 0x18be, 420 => 0x18ee, 421 => 0x17f2, 423 => 0x105, 424 => 0x105, 433 => 0x604, 434 => 0x5e },
	'lensmount2' => { 437 => 0x8 },
	'lensprofilechromaticaberrationscale' => { 460 => 'LensProfileChromaticAberrationScale', 462 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 460 => 'LensProfileDigest', 462 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 460 => 'LensProfileDistortionScale', 462 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 460 => 'LensProfileEnable', 462 => 'LensProfileEnable' },
	'lensprofilefilename' => { 460 => 'LensProfileFilename', 462 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 460 => 'LensProfileMatchKeyCameraModelName', 462 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 460 => 'LensProfileMatchKeyExifMake', 462 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 460 => 'LensProfileMatchKeyExifModel', 462 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 460 => 'LensProfileMatchKeyIsRaw', 462 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 460 => 'LensProfileMatchKeyLensID', 462 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 460 => 'LensProfileMatchKeyLensInfo', 462 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 460 => 'LensProfileMatchKeyLensName', 462 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 460 => 'LensProfileMatchKeySensorFormatFactor', 462 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 460 => 'LensProfileName', 462 => 'LensProfileName' },
	'lensprofilesetup' => { 460 => 'LensProfileSetup', 462 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 460 => 'LensProfileVignettingScale', 462 => 'LensProfileVignettingScale' },
	'lensproperties' => { 283 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 32 => 0x16b, 59 => 0x0, 115 => 0xa435, 158 => 'SerialNumber', 283 => 0x202, 303 => 0x321, 305 => 0x52, 365 => 'LENS', 373 => 0x30, 457 => 'LensSerialNumber', 467 => 'LensSerialNumber' },
	'lensshutterlock' => { 178 => 0x4a },
	'lensspec' => { 389 => 0x0, 390 => 0x0, 391 => 0x0, 405 => 0xb02a },
	'lensspecfeatures' => { 423 => [0x115,0x116], 424 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 287 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 34 => 0x16, 180 => 0x10c, 181 => 0x49bd, 218 => 0x83, 283 => 0x201, 296 => 0x16, 300 => 0x310, 302 => 0x303, 303 => 0x303, 305 => 0x51, 307 => 0x3405, 332 => 0x0, 333 => 0x0, 334 => 0x1, 335 => 0x1, 336 => 0x1, 338 => 0x0, 379 => 0xa003, 382 => 0x27, 405 => 0xb027, 417 => 0x1896, 419 => 0x18c2, 420 => 0x18f2, 421 => 0x17f6, 423 => 0x109, 424 => 0x109, 433 => 0x608, 434 => 0x62 },
	'lenstype2' => { 394 => 0x3f7, 417 => 0x1893, 419 => 0x18bf, 420 => 0x18ef, 421 => 0x17f3, 423 => 0x107, 424 => 0x107, 433 => 0x605, 434 => 0x60 },
	'lenstype3' => { 437 => 0x9 },
	'lenszoomposition' => { 430 => 0x19, 431 => 0x1e, 434 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 313 => 0x15 },
	'levelmeter' => { 365 => ['Lvlm','lvlm'] },
	'levelorientation' => { 339 => 0x0 },
	'license' => { 458 => 'license' },
	'licensee' => { 292 => 'Licensee' },
	'licenseeid' => { 292 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 292 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 292 => 'LicenseeImageNotes' },
	'licenseename' => { 292 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 292 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 292 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 292 => 'LicenseeTransactionID' },
	'licenseid' => { 292 => 'LicenseID' },
	'licensestartdate' => { 292 => 'LicenseStartDate' },
	'licensetransactiondate' => { 292 => 'LicenseTransactionDate' },
	'licensetype' => { 464 => 'licensetype' },
	'licensor' => { 292 => 'Licensor' },
	'licensorcity' => { 292 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 292 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 292 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 292 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 292 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 292 => 'LicensorImageID' },
	'licensorname' => { 292 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 292 => 'LicensorNotes' },
	'licensorpostalcode' => { 292 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 292 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 292 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 292 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 292 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 292 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 292 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 292 => 'LicensorTransactionID' },
	'licensorurl' => { 292 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 287 => 0x1009 },
	'lightingmode' => { 109 => 0x302a },
	'lightreading' => { 340 => 0x15 },
	'lightsource' => { 115 => 0x9208, 218 => 0x90, 290 => 0x1000, 466 => 'LightSource' },
	'lightsourcespecial' => { 381 => 0x21d },
	'lightswitch' => { 278 => '0.1', 280 => '0.1' },
	'lightvaluecenter' => { 287 => 0x103d },
	'lightvalueperiphery' => { 287 => 0x103e },
	'limitafareamodeselection' => { 266 => '51.1', 268 => '49.1', 269 => '49.1', 278 => '49.1', 279 => '49.1' },
	'linearitylimitblue' => { 310 => 0x10 },
	'linearitylimitgreen' => { 310 => 0xf },
	'linearitylimitred' => { 310 => 0xe },
	'linearityuppermargin' => { 43 => [0x2ba,0x2d1,0x2d5], 45 => 0x1e5, 46 => [0x1fe,0x2de], 47 => [0x232,0x310], 48 => 0x31e },
	'linearizationtable' => { 115 => 0xc618 },
	'linearresponselimit' => { 115 => 0xc62e },
	'link' => { 476 => 'link' },
	'linkaetoafpoint' => { 321 => '14.2' },
	'linkedencodedrightsexpr' => { 472 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 472 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 472 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 472 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 133 => 0x904 },
	'lithostratigraphicterms' => { 114 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 270 => '32.1', 280 => '34.1' },
	'liveviewafareamode' => { 275 => '34.1' },
	'liveviewafmethod' => { 410 => 0x20 },
	'liveviewafmode' => { 275 => '34.2' },
	'liveviewafsetting' => { 394 => 0x36 },
	'liveviewbuttonoptions' => { 266 => '50.2', 268 => '48.2', 269 => '48.2', 278 => '48.2', 279 => '48.2' },
	'liveviewexposuresimulation' => { 80 => 0x810 },
	'liveviewfocusmode' => { 394 => [0x8b,0x28b] },
	'liveviewmetering' => { 394 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 266 => '21.2', 268 => '21.2', 269 => '21.2', 271 => '20.2', 272 => '20.2', 273 => '20.2', 275 => '20.2', 278 => '21.2', 279 => '21.2' },
	'liveviewshooting' => { 55 => 0x13 },
	'livingspecimen' => { 114 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 114 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 127 => 0x79 },
	'localizedcameramodel' => { 115 => 0xc615 },
	'locallocationname' => { 379 => 0x30 },
	'location' => { 217 => 0x9, 305 => 0x67, 453 => 'Location', 471 => 'Location', 475 => 'location', 476 => 'location' },
	'locationareacode' => { 459 => 'lac' },
	'locationbody' => { 359 => 'location.body' },
	'locationcreated' => { 472 => 'LocationCreated' },
	'locationcreatedcity' => { 472 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 472 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 472 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 472 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 472 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 472 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 472 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 472 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 472 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 472 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 472 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 472 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 359 => 'location.date' },
	'locationinfoversion' => { 217 => 0x0 },
	'locationname' => { 359 => 'location.name', 379 => 0x31 },
	'locationnote' => { 359 => 'location.note' },
	'locationrole' => { 359 => 'location.role' },
	'locationshown' => { 472 => 'LocationShown' },
	'locationshowncity' => { 472 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 472 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 472 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 472 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 472 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 472 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 472 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 472 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 472 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 472 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 472 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 472 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 80 => 0x709 },
	'logcomment' => { 486 => 'logComment' },
	'logscale' => { 133 => 0x902 },
	'longdescription' => { 357 => 'ldes' },
	'longexposurenoisereduction' => { 60 => 0x4, 80 => 0x201, 81 => 0x1, 82 => 0x2, 83 => 0x1, 84 => 0x1, 85 => 0x2, 86 => 0x1, 305 => 0x49, 392 => 0x2b, 393 => 0x25, 394 => 0x25, 405 => 0x2008, 410 => 0x11, 434 => 0x44 },
	'longexposurenoisereduction2' => { 55 => 0x8 },
	'longitude' => { 112 => 'Longitude' },
	'loop' => { 486 => 'loop' },
	'loopstyle' => { 365 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 114 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 460 => 'LuminanceAdjustmentAqua', 462 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 460 => 'LuminanceAdjustmentBlue', 462 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 460 => 'LuminanceAdjustmentGreen', 462 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 460 => 'LuminanceAdjustmentMagenta', 462 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 460 => 'LuminanceAdjustmentOrange', 462 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 460 => 'LuminanceAdjustmentPurple', 462 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 460 => 'LuminanceAdjustmentRed', 462 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 460 => 'LuminanceAdjustmentYellow', 462 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 104 => 0x150 },
	'luminancecurvepoints' => { 104 => 0x126 },
	'luminancenoisereduction' => { 99 => 0x20600, 105 => 0x5f, 382 => 0x1b },
	'luminancenoisereductioncontrast' => { 460 => 'LuminanceNoiseReductionContrast', 462 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 460 => 'LuminanceNoiseReductionDetail', 462 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 105 => 0x6d },
	'luminancesmoothing' => { 460 => 'LuminanceSmoothing', 462 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 80 => [0x40b,0x40c] },
	'lyrics' => { 357 => "\xa9lyr", 365 => "\xa9lyr", 486 => 'lyrics' },
	'lyricsuri' => { 365 => 'lrcu' },
	'm16cversion' => { 300 => 0x333 },
	'macatom' => { 461 => 'macAtom' },
	'macatomapplicationcode' => { 461 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 461 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 461 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 114 => 'MachineObservation' },
	'machineobservationday' => { 114 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 114 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 114 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 114 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 114 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 114 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 114 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 114 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 114 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 114 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 114 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 114 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 114 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 114 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 114 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 114 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 114 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 114 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 114 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 114 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 123 => 0x1020, 125 => 0x202, 146 => 0x2b, 287 => 0x202, 371 => 0x21, 381 => 0x202, 405 => 0xb040 },
	'macroled' => { 285 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 55 => 0x10 },
	'macromode' => { 34 => 0x1, 175 => 0xb, 282 => 0x300, 305 => 0x1c, 372 => 0x1009 },
	'magentahsl' => { 99 => 0x20917 },
	'magicfilter' => { 282 => 0x52c },
	'magnifiedview' => { 82 => 0x11, 84 => 0x9 },
	'mainboardversion' => { 133 => 0x438 },
	'maindialexposurecomp' => { 276 => '0.6' },
	'mainingredient' => { 478 => 'mainIngredient' },
	'majorversion' => { 451 => 'MajorVersion' },
	'make' => { 94 => 0x0, 111 => 0x1, 115 => 0x10f, 151 => 'Make', 295 => 'Make', 310 => 0x10f, 359 => 'make', 365 => "\xa9mak", 475 => 'make', 482 => 'Make' },
	'makernote' => { 466 => 'MakerNote' },
	'makernoteapple' => { 113 => 'MakN', 115 => 0x927c },
	'makernotecanon' => { 113 => 'MakN', 115 => 0x927c },
	'makernotecasio' => { 113 => 'MakN', 115 => 0x927c },
	'makernotecasio2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotedji' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteflir' => { 113 => 'MakN', 115 => 0x927c },
	'makernotefujifilm' => { 113 => 'MakN', 115 => 0x927c },
	'makernotege' => { 113 => 'MakN', 115 => 0x927c },
	'makernotege2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotehasselblad' => { 113 => 'MakN', 115 => 0x927c },
	'makernotehp' => { 113 => 'MakN', 115 => 0x927c },
	'makernotehp2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotehp4' => { 113 => 'MakN', 115 => 0x927c },
	'makernotehp6' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteisl' => { 113 => 'MakN', 115 => 0x927c },
	'makernotejvc' => { 113 => 'MakN', 115 => 0x927c },
	'makernotejvctext' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak10' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak11' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak12' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak1a' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak1b' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak3' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak4' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak5' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak6a' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak6b' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak7' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak8a' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak8b' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak8c' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak9' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodakunknown' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekyocera' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica10' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica2' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica3' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica4' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica5' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica6' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica7' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica8' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica9' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteminolta' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteminolta2' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteminolta3' => { 113 => 'MakN', 115 => 0x927c },
	'makernotemotorola' => { 113 => 'MakN', 115 => 0x927c },
	'makernotenikon' => { 113 => 'MakN', 115 => 0x927c },
	'makernotenikon2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotenikon3' => { 113 => 'MakN', 115 => 0x927c },
	'makernotenintendo' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteoffset' => { 381 => 0xff },
	'makernoteolympus' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteolympus2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepanasonic' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepanasonic2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepanasonic3' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepentax' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepentax2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepentax3' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepentax4' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepentax5' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepentax6' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepentaxunknown' => { 365 => 'PXMN' },
	'makernotephaseone' => { 113 => 'MakN', 115 => 0x927c },
	'makernotereconyx' => { 113 => 'MakN', 115 => 0x927c },
	'makernotereconyx2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotereconyx3' => { 113 => 'MakN', 115 => 0x927c },
	'makernotericoh' => { 113 => 'MakN', 115 => 0x927c },
	'makernotericoh2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotericohpentax' => { 113 => 'MakN', 115 => 0x927c },
	'makernotericohtext' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesafety' => { 115 => 0xc635 },
	'makernotesamsung1a' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesamsung1b' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesamsung2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesanyo' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesanyoc4' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesanyopatch' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesigma' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesony' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesony2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesony3' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesony4' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesony5' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesonyericsson' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesonysrf' => { 113 => 'MakN', 115 => 0x927c },
	'makernotetype' => { 372 => 0x1 },
	'makernoteunknown' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteunknownbinary' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteunknowntext' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteversion' => { 180 => 0x0, 218 => 0x1, 287 => 0x0, 305 => 0x8000, 376 => 0x0, 379 => 0x1, 382 => [0x1d,0x1f], 395 => 0x2000 },
	'makerurl' => { 365 => "\xa9mal" },
	'managedfrom' => { 487 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 487 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 487 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 487 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 487 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 487 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 487 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 487 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 487 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 487 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 487 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 487 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 487 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 487 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 487 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 487 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 487 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 487 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 487 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 487 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 487 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 487 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 487 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 487 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 487 => 'Manager' },
	'managervariant' => { 487 => 'ManagerVariant' },
	'manageto' => { 487 => 'ManageTo' },
	'manageui' => { 487 => 'ManageUI' },
	'manifest' => { 487 => 'Manifest' },
	'manifestlinkform' => { 487 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 487 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 487 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 487 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 487 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 487 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 487 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 487 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 487 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 487 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 487 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 487 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 487 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 487 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 487 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 487 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 487 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 487 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 487 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 487 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 487 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 487 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 487 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 487 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 487 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 487 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 487 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 487 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 282 => 0x900, 305 => 0x86 },
	'manometerreading' => { 282 => 0x901 },
	'manualafpointselectpattern' => { 80 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 285 => 0x1209 },
	'manualflashoutput' => { 34 => 0x29, 267 => '8.2', 270 => '22.2', 271 => '23.1', 272 => '23.2', 274 => '16.2', 275 => '23.2', 276 => '8.2', 277 => '23.2', 280 => '24.2', 372 => 0x100c },
	'manualflashstrength' => { 282 => 0x406 },
	'manualfocusdistance' => { 218 => 0x85, 287 => 0x100c, 381 => 0x223 },
	'manualtv' => { 79 => 0x5, 80 => 0x705 },
	'manufacturedate' => { 185 => 0x6705, 320 => 0x1 },
	'manufacturedate1' => { 374 => 0x4 },
	'manufacturedate2' => { 374 => 0x5 },
	'manufacturer' => { 445 => 'Manufacturer', 475 => 'manufacturer' },
	'mariahchromablursize' => { 133 => 0xf0d },
	'mariahmaphithreshold' => { 133 => 0xf0c },
	'mariahmaplothreshold' => { 133 => 0xf0b },
	'mariahsigmathreshold' => { 133 => 0xf0e },
	'mariahtexturethreshold' => { 133 => 0xf0a },
	'marked' => { 473 => 'Marked', 490 => 'Marked' },
	'markers' => { 486 => 'markers' },
	'markerscomment' => { 486 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 486 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 486 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 486 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 486 => [\'markers','markersCuePointType'] },
	'markersduration' => { 486 => [\'markers','markersDuration'] },
	'markerslocation' => { 486 => [\'markers','markersLocation'] },
	'markersname' => { 486 => [\'markers','markersName'] },
	'markersprobability' => { 486 => [\'markers','markersProbability'] },
	'markersspeaker' => { 486 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 486 => [\'markers','markersStartTime'] },
	'markerstarget' => { 486 => [\'markers','markersTarget'] },
	'markerstype' => { 486 => [\'markers','markersType'] },
	'maskedareas' => { 115 => 0xc68e },
	'masterdocumentid' => { 127 => 0xb9 },
	'mastergain' => { 226 => 0x50 },
	'materialsample' => { 114 => 'MaterialSample' },
	'materialsampleid' => { 114 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 266 => '50.1', 268 => '48.1', 269 => '48.1', 278 => '48.1', 279 => '48.1' },
	'matrixselectk' => { 133 => 0x91b },
	'matrixselectthreshold' => { 133 => 0x91a },
	'matrixselectthreshold1' => { 133 => 0x91e },
	'matrixselectthreshold2' => { 133 => 0x91f },
	'matrixstructure' => { 364 => 0xa },
	'maxaperture' => { 34 => 0x1a, 133 => 0x3f9, 139 => 0x6103, 158 => 'MaxAperture', 175 => 0x17, 181 => 0x49c5, 216 => 0x36, 283 => 0x20a, 331 => '14.1' },
	'maxapertureatmaxfocal' => { 123 => 0x1407, 158 => 'MaxApertureAtMaxFocal', 210 => 0xb, 211 => 0x10, 212 => 0x11, 216 => 0x12, 283 => 0x206 },
	'maxapertureatminfocal' => { 123 => 0x1406, 210 => 0xa, 211 => 0xf, 212 => 0x10, 216 => 0x11, 283 => 0x205 },
	'maxaperturevalue' => { 115 => 0x9205, 349 => 0x414, 466 => 'MaxApertureValue' },
	'maxavailheight' => { 472 => 'MaxAvailHeight' },
	'maxavailwidth' => { 472 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 265 => 0xb, 266 => 0xc, 268 => '12.1', 269 => '12.1', 274 => 0xc, 275 => 0xb, 278 => '12.1', 279 => '12.1' },
	'maxfaces' => { 286 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 34 => 0x17, 123 => 0x1405, 158 => 'MaxFocalLength', 210 => 0x9, 211 => 0xe, 212 => 0xf, 216 => 0x10, 283 => 0x208, 417 => 0x127c, 418 => 0x1138, 419 => 0x330, 420 => 0x330, 421 => 0x30e },
	'maximumdensityrange' => { 129 => 0x8c },
	'maxpagesize' => { 491 => 'MaxPageSize' },
	'maxpagesizeh' => { 491 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 491 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 491 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 133 => 0xc7d },
	'maxsamplevalue' => { 115 => 0x119 },
	'maxstorage' => { 481 => 'maxstorage' },
	'mb-d10batteries' => { 265 => '12.6' },
	'mb-d10batterytype' => { 274 => '13.3' },
	'mb-d11batterytype' => { 275 => '2.3' },
	'mb-d12batterytype' => { 278 => '3.2' },
	'mb-d80batteries' => { 276 => '6.5' },
	'mb-d80batterytype' => { 280 => '3.2' },
	'mcuversion' => { 210 => 0xc, 211 => 0x11, 212 => 0x12, 216 => 0x13 },
	'md5digest' => { 159 => 'zmd5' },
	'mditemfindercomment' => { 168 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 168 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 168 => 'MDItemFSLabel' },
	'mditemusertags' => { 168 => 'MDItemUserTags' },
	'meal' => { 478 => 'meal' },
	'measuredev' => { 28 => 0x9, 74 => 0x3, 93 => 0x1814, 151 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 74 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 181 => 0x690, 300 => 0x312, 303 => 0x312, 304 => 0x312, 307 => 0x3407 },
	'measuredrggb' => { 62 => 0x1 },
	'measuredrggbdata' => { 42 => 0x287 },
	'measurementaccuracy' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 114 => 'MeasurementOrFact' },
	'measurementremarks' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 445 => 'MeasureType' },
	'mechanicalshuttercount' => { 218 => 0x37 },
	'mediaconstraints' => { 292 => 'MediaConstraints' },
	'mediacreatedate' => { 361 => 0x1 },
	'mediaeventiddate' => { 450 => 'MediaEventIdDate' },
	'mediamodifydate' => { 361 => 0x2 },
	'mediasummarycode' => { 292 => 'MediaSummaryCode' },
	'mediatype' => { 357 => 'stik' },
	'memoaudioquality' => { 80 => 0x812 },
	'memorycardconfiguration' => { 398 => 0x16 },
	'memorycardnumber' => { 201 => 0x2 },
	'menubuttondisplayposition' => { 78 => 0xb, 81 => 0xa, 82 => 0xb, 85 => 0xb },
	'menubuttonreturn' => { 86 => 0xb },
	'menumonitorofftime' => { 265 => '26.1', 266 => '22.1', 268 => '22.1', 269 => '22.1', 273 => '21.1', 274 => '8.2', 275 => '21.1', 278 => '22.1', 279 => '22.1', 280 => '22.1' },
	'metadatadate' => { 484 => 'MetadataDate' },
	'metadatamoddate' => { 486 => 'metadataModDate' },
	'metaversion' => { 412 => 0x34 },
	'meterinfo1row1' => { 406 => 0x0, 407 => 0x0 },
	'meterinfo1row2' => { 406 => 0x6c, 407 => 0x5a },
	'meterinfo1row3' => { 406 => 0xd8, 407 => 0xb4 },
	'meterinfo1row4' => { 406 => 0x144, 407 => 0x10e },
	'meterinfo1row5' => { 406 => 0x1b0, 407 => 0x168 },
	'meterinfo1row6' => { 406 => 0x21c, 407 => 0x1c2 },
	'meterinfo1row7' => { 406 => 0x288, 407 => 0x21c },
	'meterinfo2row1' => { 406 => 0x2f4, 407 => 0x276 },
	'meterinfo2row2' => { 406 => 0x378, 407 => 0x2e4 },
	'meterinfo2row3' => { 406 => 0x3fc, 407 => 0x352 },
	'meterinfo2row4' => { 406 => 0x480, 407 => 0x3c0 },
	'meterinfo2row5' => { 406 => 0x504, 407 => 0x42e },
	'meterinfo2row6' => { 406 => 0x588, 407 => 0x49c },
	'meterinfo2row7' => { 406 => 0x60c, 407 => 0x50a },
	'meterinfo2row8' => { 406 => 0x690, 407 => 0x578 },
	'meterinfo2row9' => { 406 => 0x714, 407 => 0x5e6 },
	'metering' => { 267 => '6.1' },
	'meteringmode' => { 34 => 0x11, 115 => 0x9207, 135 => 0x1c, 175 => 0x7, 176 => 0x25, 178 => 0x12, 282 => 0x202, 340 => 0x17, 382 => 0x9, 392 => 0x15, 393 => 0x13, 394 => 0x7, 410 => 0x3, 413 => 0x1174, 414 => 0x1178, 415 => 0x1154, 416 => 0x11d0, 417 => 0x11ac, 418 => 0x1064, 419 => 0x25c, 420 => 0x25c, 421 => 0x24b, 466 => 'MeteringMode' },
	'meteringmode2' => { 321 => '2.1', 405 => 0x202c },
	'meteringmode3' => { 321 => '16.1' },
	'meteringoffscaleindicator' => { 178 => 0x53 },
	'meteringtime' => { 265 => '22.2', 267 => '3.2', 270 => '17.1', 271 => '18.1', 274 => '7.3', 275 => '18.1', 276 => '3.2', 280 => '19.1' },
	'micro1version' => { 367 => 0x1f },
	'micro2version' => { 367 => 0x2d },
	'midrangesharpness' => { 222 => 0x3b },
	'mieversion' => { 159 => '0Vers' },
	'mime' => { 445 => 'Mime' },
	'minaperture' => { 34 => 0x1b, 133 => 0x3f8, 158 => 'MinAperture', 331 => '0.2' },
	'minaperturevalue' => { 349 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 34 => 0x18, 123 => 0x1404, 158 => 'MinFocalLength', 210 => 0x8, 211 => 0xd, 212 => 0xe, 216 => 0xf, 283 => 0x207, 417 => 0x127a, 418 => 0x1136, 419 => 0x32e, 420 => 0x32e, 421 => 0x30c },
	'minfocusdistance' => { 331 => 0x3 },
	'minintegrationrows' => { 133 => 0x1874 },
	'minoltadate' => { 175 => 0x15 },
	'minoltaimagesize' => { 175 => 0x4, 176 => 0xc, 177 => 0x2, 180 => 0x103 },
	'minoltamodelid' => { 175 => 0x25 },
	'minoltaquality' => { 175 => 0x5, 176 => 0xd, 177 => 0x3, 180 => [0x102,0x103] },
	'minoltatime' => { 175 => 0x16 },
	'minormodelagedisclosure' => { 292 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 451 => 'MinorVersion' },
	'minsamplevalue' => { 115 => 0x118 },
	'mirrorlockup' => { 78 => 0xc, 79 => 0xc, 80 => 0x60f, 81 => 0xb, 82 => 0xc, 83 => 0x6, 84 => 0x6, 85 => 0xc, 86 => 0x3 },
	'mobilecountrycode' => { 459 => 'mcc' },
	'mobilenetworkcode' => { 459 => 'mnc' },
	'moddate' => { 295 => 'modify-date', 473 => 'ModDate' },
	'modedialposition' => { 398 => 0x14 },
	'model' => { 94 => 0x6, 115 => 0x110, 151 => 'Model', 295 => 'Model', 310 => 0x110, 340 => 0x23f, 359 => 'model', 365 => ['CNMN','cmnm',"\xa9mdl","\xa9mod"], 382 => 0x84, 445 => 'Model', 475 => 'model', 482 => 'Model' },
	'modelage' => { 472 => 'ModelAge' },
	'modelid' => { 281 => 0x0 },
	'modelingflash' => { 265 => '21.4', 266 => '31.1', 268 => '31.1', 269 => '31.1', 274 => '26.4', 275 => '30.2', 276 => '7.4', 277 => '30.1', 278 => '31.1', 279 => '31.1', 280 => '31.3' },
	'modelreleaseid' => { 292 => 'ModelReleaseID' },
	'modelreleasestatus' => { 292 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 425 => 0x52, 426 => 0x46, 427 => 0x53 },
	'modeltiepoint' => { 115 => 0x8482 },
	'modeltransform' => { 115 => 0x85d8 },
	'modelyear' => { 475 => 'modelYear' },
	'modificationdate' => { 476 => 'modificationDate' },
	'modifiedcolortemp' => { 63 => 0x9 },
	'modifieddigitalgain' => { 63 => 0xb },
	'modifiedparamflag' => { 56 => 0x1 },
	'modifiedpicturestyle' => { 63 => 0xa },
	'modifiedsaturation' => { 282 => 0x504 },
	'modifiedsensorbluelevel' => { 63 => 0x5 },
	'modifiedsensorredlevel' => { 63 => 0x4 },
	'modifiedsharpness' => { 63 => 0x2 },
	'modifiedsharpnessfreq' => { 63 => 0x3 },
	'modifiedtonecurve' => { 63 => 0x1 },
	'modifiedwhitebalance' => { 63 => 0x8 },
	'modifiedwhitebalanceblue' => { 63 => 0x7 },
	'modifiedwhitebalancered' => { 63 => 0x6 },
	'modifydate' => { 115 => 0x132, 152 => 'ModifyDate', 291 => 'ModDate', 293 => 'tIME', 356 => 'ModDate', 362 => 0x2, 484 => 'ModifyDate' },
	'moirefilter' => { 115 => 0xfe58, 460 => 'MoireFilter', 462 => 'MoireFilter' },
	'monitordisplayoff' => { 178 => 0x4c },
	'monitormatrix' => { 133 => 0x8fc },
	'monitorofftime' => { 265 => '18.2', 267 => '3.1', 276 => '3.1' },
	'monochromecolor' => { 282 => 0x53b },
	'monochromecontrast' => { 105 => 0x3c },
	'monochromefiltereffect' => { 99 => 0x20307, 105 => 0x3a, 340 => 0x73 },
	'monochromelinear' => { 105 => 0x3d },
	'monochromeoutputhighlightpoint' => { 105 => 0x41 },
	'monochromeoutputshadowpoint' => { 105 => 0x42 },
	'monochromeprofilesettings' => { 282 => 0x537 },
	'monochromerawhighlight' => { 105 => 0x7a },
	'monochromerawhighlightpoint' => { 105 => 0x3f },
	'monochromerawshadow' => { 105 => 0x83 },
	'monochromerawshadowpoint' => { 105 => 0x40 },
	'monochromesharpness' => { 105 => 0x3e },
	'monochrometoning' => { 340 => 0x74 },
	'monochrometoningeffect' => { 99 => 0x20306, 105 => 0x3b },
	'monochromeunsharpmaskfineness' => { 105 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 105 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 105 => 0xb4 },
	'monochromevignetting' => { 282 => 0x53a },
	'monthdaycreated' => { 135 => 0x12, 144 => 0xe },
	'moonphase' => { 366 => 0x12, 367 => 0x43, 368 => 0x4c },
	'morepermissions' => { 458 => 'morePermissions' },
	'motionsensitivity' => { 366 => 0x29, 368 => 0x60 },
	'movieaelockbuttonassignment' => { 278 => '40.1' },
	'moviefunc1button' => { 268 => '41.1', 269 => '41.1', 279 => '41.1' },
	'moviefunctionbutton' => { 266 => '41.1', 278 => '41.1' },
	'moviefunctionbuttonplusdials' => { 266 => '52.1' },
	'moviepreviewbutton' => { 266 => '41.2', 268 => '41.2', 269 => '41.2', 278 => '41.2', 279 => '41.2' },
	'moviepreviewbuttonplusdials' => { 266 => '52.2' },
	'movieshutterbutton' => { 266 => '38.3', 268 => '38.3', 269 => '38.3', 278 => '38.3', 279 => '38.3' },
	'moviesubselectorassignment' => { 266 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 266 => '53.1' },
	'multiburstimageheight' => { 405 => 0x1002 },
	'multiburstimagewidth' => { 405 => 0x1001 },
	'multiburstmode' => { 405 => 0x1000 },
	'multicontrollerwhilemetering' => { 80 => 0x517 },
	'multiexposure' => { 65 => 0x1, 305 => 0xb4 },
	'multiexposureautogain' => { 219 => 0x3 },
	'multiexposurecontrol' => { 65 => 0x2 },
	'multiexposuremode' => { 219 => 0x1 },
	'multiexposureshots' => { 65 => 0x3, 219 => 0x2 },
	'multiframenoisereduction' => { 394 => 0x35, 405 => 0x200b, 410 => 0x15 },
	'multiframenreffect' => { 405 => 0x2023 },
	'multifunctionlock' => { 80 => 0x70f },
	'multipleexposuremode' => { 286 => 0x101c },
	'multipleexposureset' => { 321 => '10.1' },
	'multisample' => { 226 => 0x40 },
	'multiselector' => { 265 => '9.4', 266 => '10.3', 268 => '10.3', 269 => '10.3', 274 => '27.4', 278 => '10.3', 279 => '10.3' },
	'multiselectorliveview' => { 265 => '4.3', 268 => '37.1', 269 => '37.1', 278 => '37.1', 279 => '37.1' },
	'multiselectorliveviewmode' => { 236 => 0x18c2 },
	'multiselectorplaybackmode' => { 265 => ['13.5','9.2'], 266 => '10.2', 269 => '10.2', 274 => '27.2', 278 => '10.2', 279 => '10.2' },
	'multiselectorshootmode' => { 265 => '9.1', 266 => '10.1', 268 => '10.1', 269 => '10.1', 274 => '27.1', 278 => '10.1', 279 => '10.1' },
	'multishot' => { 310 => 0x121 },
	'mute' => { 359 => 'player.movie.audio.mute' },
	'mycolormode' => { 66 => 0x2 },
	'name' => { 365 => 'name' },
	'narrator' => { 357 => "\xa9nrt" },
	'nationalcatalognumber' => { 476 => 'nationalCatalogNumber' },
	'nativedigest' => { 466 => 'NativeDigest', 482 => 'NativeDigest' },
	'ndfilter' => { 74 => 0x1c, 282 => 0x204, 372 => 0x1019 },
	'near' => { 445 => 'Near' },
	'nefbitdepth' => { 218 => 0xe22 },
	'nefcompression' => { 218 => 0x93 },
	'neflinearizationtable' => { 218 => 0x96 },
	'negativecachelargepreviewsize' => { 460 => 'NegativeCacheLargePreviewSize', 462 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 460 => 'NegativeCacheMaximumSize', 462 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 460 => 'NegativeCachePath', 462 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 340 => 0x88 },
	'neutraloutputhighlightpoint' => { 105 => 0x2f },
	'neutraloutputshadowpoint' => { 105 => 0x30 },
	'neutralrawcolortone' => { 105 => 0x28 },
	'neutralrawcontrast' => { 105 => 0x2a },
	'neutralrawhighlight' => { 105 => 0x78 },
	'neutralrawhighlightpoint' => { 105 => 0x2d },
	'neutralrawlinear' => { 105 => 0x2b },
	'neutralrawsaturation' => { 105 => 0x29 },
	'neutralrawshadow' => { 105 => 0x81 },
	'neutralrawshadowpoint' => { 105 => 0x2e },
	'neutralrawsharpness' => { 105 => 0x2c },
	'neutralunsharpmaskfineness' => { 105 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 105 => 0xa8 },
	'neutraunsharpmaskstrength' => { 105 => 0xa4 },
	'newrawimagedigest' => { 115 => 0xc7a7 },
	'newsphotoversion' => { 129 => 0x0 },
	'nickname' => { 484 => 'Nickname' },
	'nikoncapturedata' => { 218 => 0xe01 },
	'nikoncaptureeditversions' => { 218 => 0xe13 },
	'nikoncaptureoffsets' => { 218 => 0xe0e },
	'nikoncaptureoutput' => { 218 => 0xe1e },
	'nikoncaptureversion' => { 218 => 0xe09 },
	'nikoniccprofile' => { 218 => 0xe1d },
	'nikonimagesize' => { 233 => '723.1', 234 => '732.1', 243 => 0x2c4 },
	'nikonmeteringmode' => { 237 => 0x2ea4, 245 => 0x175e },
	'noisefilter' => { 282 => 0x527 },
	'noiseprofile' => { 115 => 0xc761 },
	'noisereduction' => { 123 => [0x100b,0x100e], 176 => 0xb0, 177 => 0x60, 178 => 0x3f, 218 => 0x95, 258 => 0x753dcbc0, 259 => 0x17, 282 => 0x50a, 287 => 0x103a, 305 => 0x2d, 340 => 0x49, 372 => 0x100f, 374 => 0x2a },
	'noisereduction2' => { 286 => 0x1010 },
	'noisereductionapplied' => { 115 => 0xc6f7 },
	'noisereductionintensity' => { 259 => 0x9 },
	'noisereductionmethod' => { 259 => 0x11 },
	'noisereductionmode' => { 438 => 0x801e },
	'noisereductionparametersatcapture' => { 133 => 0xe73 },
	'noisereductionparameterscamera' => { 133 => 0xe72 },
	'noisereductionparametershost3mp' => { 133 => 0xe71 },
	'noisereductionparametershost6mp' => { 133 => 0xe70 },
	'noisereductionparametershostrgb' => { 133 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 133 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 133 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 133 => 0xe63 },
	'noisereductionparams' => { 310 => 0x1b },
	'noisereductionsharpness' => { 259 => 0xd },
	'noisereductionstrength' => { 305 => 0xd6 },
	'noisereductionvalue' => { 438 => 0x8027 },
	'nomemorycard' => { 265 => '22.1', 266 => '4.2', 267 => '0.3', 270 => '2.4', 271 => '3.2', 272 => '3.2', 274 => '33.7', 275 => '3.2', 276 => '0.3', 278 => '4.2', 280 => '4.5' },
	'nominalmaxaperture' => { 331 => 0xa },
	'nominalminaperture' => { 331 => '10.1' },
	'normallinetime' => { 133 => 0x186a },
	'normalwhitelevel' => { 43 => [0x2b8,0x2cf,0x2d3], 44 => 0x569, 45 => 0x1e3, 46 => [0x1fc,0x2dc], 47 => [0x230,0x30e], 48 => 0x31c },
	'notes' => { 439 => 'Notes', 455 => 'notes' },
	'npages' => { 491 => 'NPages' },
	'nullrecord' => { 93 => 0x0 },
	'numafpoints' => { 317 => 0x2 },
	'number' => { 476 => 'number' },
	'numberofbeats' => { 486 => 'numberOfBeats' },
	'numberoffocuspoints' => { 268 => '1.3', 269 => '1.3', 272 => '0.2', 273 => '0.3', 275 => '0.3' },
	'numfaceelements' => { 123 => 0x4200 },
	'numfacepositions' => { 297 => 0x0 },
	'numindexentries' => { 129 => 0x54 },
	'numwbentries' => { 311 => 0x0, 312 => 0x0 },
	'object' => { 476 => 'object' },
	'objectattributereference' => { 127 => 0x4 },
	'objectcycle' => { 127 => 0x4b, 455 => 'ObjectCycle' },
	'objectdescription' => { 475 => 'objectDescription' },
	'objectdistance' => { 108 => 0x6, 109 => 0x2022 },
	'objectname' => { 127 => 0x5 },
	'objectpreviewdata' => { 127 => 0xca },
	'objectpreviewfileformat' => { 127 => 0xc8 },
	'objectpreviewfileversion' => { 127 => 0xc9 },
	'objectsubtype' => { 475 => 'objectSubtype' },
	'objecttype' => { 475 => 'objectType' },
	'objecttypereference' => { 127 => 0x3 },
	'occurrence' => { 114 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 114 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 114 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 114 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 114 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 114 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 114 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 114 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 114 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 114 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 114 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 114 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 114 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 114 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 114 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 114 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 114 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 114 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 114 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 114 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 114 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 114 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 114 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 114 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 114 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 114 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 466 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 466 => [\'OECF','OECFNames'] },
	'oecfrows' => { 466 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 466 => [\'OECF','OECFValues'] },
	'offsaledate' => { 476 => 'offSaleDate' },
	'offsaledatea-platform' => { 476 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 476 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 133 => 0x190a },
	'offsetschema' => { 115 => 0xea1d },
	'offsettime' => { 115 => 0x9010 },
	'offsettimedigitized' => { 115 => 0x9012 },
	'offsettimeoriginal' => { 115 => 0x9011 },
	'okbutton' => { 275 => '15.1', 280 => '16.1' },
	'oldsubfiletype' => { 115 => 0xff },
	'olympusimageheight' => { 287 => 0x102f },
	'olympusimagewidth' => { 287 => 0x102e },
	'omenatcapturestrength' => { 133 => 0xa60 },
	'omenautostrength' => { 133 => 0xa5f },
	'omenearlystrength' => { 133 => 0xa5e },
	'omenfocallengthlimit' => { 133 => 0xa62 },
	'omeninitialipfstrength' => { 133 => 0xa5d },
	'omensurfaceindex' => { 133 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 287 => 0x302 },
	'onsaledate' => { 476 => 'onSaleDate' },
	'onsaledatea-platform' => { 476 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 476 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 476 => 'onSaleDay' },
	'onsaledaya-platform' => { 476 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 476 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 115 => 0xc740 },
	'opcodelist2' => { 115 => 0xc741 },
	'opcodelist3' => { 115 => 0xc74e },
	'opticalzoom' => { 137 => 0xfa3d, 139 => [0x6006,0xf006], 140 => 0x1000, 141 => 0xf, 144 => 0x1e, 146 => 0x20, 147 => 0x1c, 158 => 'OpticalZoom' },
	'opticalzoomcode' => { 74 => 0xa },
	'opticalzoommode' => { 305 => 0x34 },
	'opticalzoomon' => { 381 => 0x219 },
	'optionenddate' => { 479 => 'optionEndDate' },
	'opto-electricconvfactor' => { 466 => 'OECF' },
	'orangehsl' => { 99 => 0x20911 },
	'ordernumber' => { 123 => 0x8002 },
	'organisationinimagecode' => { 472 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 472 => 'OrganisationInImageName' },
	'organism' => { 114 => 'Organism' },
	'organismassociatedoccurrences' => { 114 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 114 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 114 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 114 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 114 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 114 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 114 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 476 => 'organization' },
	'orientation' => { 115 => 0x112, 310 => 0x112, 475 => 'orientation', 482 => 'Orientation' },
	'orientation2' => { 410 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 80 => 0x516 },
	'originalbestqualitysize' => { 115 => 0xc792 },
	'originalcreatedatetime' => { 450 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 110 => 'Canon::OriginalDecisionData' },
	'originaldecisiondataoffset' => { 61 => 0x83 },
	'originaldefaultcropsize' => { 115 => 0xc793 },
	'originaldefaultfinalsize' => { 115 => 0xc791 },
	'originaldirectory' => { 302 => 0x408 },
	'originaldocumentid' => { 487 => 'OriginalDocumentID' },
	'originalfilename' => { 93 => 0x816, 133 => 0x3e9, 145 => 0x20, 302 => 0x407, 450 => 'OriginalFilename' },
	'originalimageheight' => { 76 => 0xc, 119 => 0x1 },
	'originalimagewidth' => { 76 => 0xb, 119 => 0x0 },
	'originalrawfiledata' => { 115 => 0xc68c },
	'originalrawfiledigest' => { 115 => 0xc71d },
	'originalrawfilename' => { 115 => 0xc68b },
	'originaltransmissionreference' => { 127 => 0x67 },
	'originatingprogram' => { 127 => 0x41, 455 => 'OriginatingProgram' },
	'originplatform' => { 476 => 'originPlatform' },
	'os' => { 464 => 'os' },
	'otherconditions' => { 292 => 'OtherConditions' },
	'otherconstraints' => { 292 => 'OtherConstraints' },
	'otherimage' => { 110 => 'Exif::OtherImage' },
	'otherimageinfo' => { 292 => 'OtherImageInfo' },
	'otherimagelength' => { 115 => 0x202 },
	'otherimagestart' => { 115 => 0x201 },
	'otherlicensedocuments' => { 292 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 292 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 292 => 'OtherLicenseRequirements' },
	'outcue' => { 486 => 'outCue' },
	'outcuescale' => { 486 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 486 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 190 => 0x3 },
	'outputimagewidth' => { 190 => 0x2 },
	'outputlut' => { 305 => 0xa7 },
	'outputprofile' => { 133 => 0x138b },
	'outputresolution' => { 190 => 0x4 },
	'overclockcols' => { 133 => 0x189c },
	'overclockrows' => { 133 => 0x18c4 },
	'owner' => { 490 => 'Owner' },
	'ownerid' => { 127 => 0xbc },
	'ownername' => { 15 => 0x10f, 61 => 0x9, 93 => 0x810, 115 => [0xa430,0xfde8], 151 => 'OwnerName', 457 => 'OwnerName', 467 => 'CameraOwnerName' },
	'padding' => { 115 => 0xea1c },
	'pagecount' => { 476 => 'pageCount' },
	'pageimage' => { 484 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 484 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 484 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 484 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 484 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 484 => 'PageInfo' },
	'pagename' => { 115 => 0x11d },
	'pagenumber' => { 115 => 0x129 },
	'pageprogressiondirection' => { 476 => 'pageProgressionDirection' },
	'pagerange' => { 476 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 460 => 'PaintBasedCorrections', 462 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 460 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicdatetime' => { 308 => 0x0 },
	'panasonicexifversion' => { 305 => 0x26 },
	'panasonicimageheight' => { 305 => 0x4c },
	'panasonicimagewidth' => { 305 => 0x4b },
	'panasonicrawversion' => { 310 => 0x1 },
	'panasonictitle' => { 115 => 0xc6d2 },
	'panasonictitle2' => { 115 => 0xc6d3 },
	'panoramaangle' => { 123 => 0x1153 },
	'panoramacropbottom' => { 411 => 0x7 },
	'panoramacropleft' => { 411 => 0x4 },
	'panoramacropright' => { 411 => 0x6 },
	'panoramacroptop' => { 411 => 0x5 },
	'panoramadirection' => { 69 => 0x5, 123 => 0x1154, 411 => 0x3 },
	'panoramaframeheight' => { 411 => 0x9 },
	'panoramaframenumber' => { 69 => 0x2 },
	'panoramaframewidth' => { 411 => 0x8 },
	'panoramafullheight' => { 411 => 0x2 },
	'panoramafullwidth' => { 411 => 0x1 },
	'panoramamode' => { 135 => 0x3c, 282 => 0x601 },
	'panoramasize3d' => { 394 => 0x38 },
	'panoramasourceheight' => { 411 => 0xb },
	'panoramasourcewidth' => { 411 => 0xa },
	'panoramicstitchcameramotion' => { 171 => 'PanoramicStitchCameraMotion', 172 => 0x1 },
	'panoramicstitchmaptype' => { 171 => 'PanoramicStitchMapType', 172 => 0x2 },
	'panoramicstitchphi0' => { 171 => 'PanoramicStitchPhi0', 172 => 0x5 },
	'panoramicstitchphi1' => { 171 => 'PanoramicStitchPhi1', 172 => 0x6 },
	'panoramicstitchtheta0' => { 171 => 'PanoramicStitchTheta0', 172 => 0x3 },
	'panoramicstitchtheta1' => { 171 => 'PanoramicStitchTheta1', 172 => 0x4 },
	'panoramicstitchversion' => { 172 => 0x0 },
	'pantry' => { 487 => 'Pantry' },
	'pantryinstanceid' => { 487 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 123 => 0xb211, 281 => 0x28 },
	'parametricdarks' => { 460 => 'ParametricDarks', 462 => 'ParametricDarks' },
	'parametrichighlights' => { 460 => 'ParametricHighlights', 462 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 460 => 'ParametricHighlightSplit', 462 => 'ParametricHighlightSplit' },
	'parametriclights' => { 460 => 'ParametricLights', 462 => 'ParametricLights' },
	'parametricmidtonesplit' => { 460 => 'ParametricMidtoneSplit', 462 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 460 => 'ParametricShadows', 462 => 'ParametricShadows' },
	'parametricshadowsplit' => { 460 => 'ParametricShadowSplit', 462 => 'ParametricShadowSplit' },
	'parentmediaeventid' => { 450 => 'ParentMediaEventID' },
	'parentmeid' => { 450 => 'ParentMEID' },
	'parentproductid' => { 357 => '@ppi' },
	'parentreference1' => { 470 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 470 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 470 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 470 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 470 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 470 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 357 => '@PST' },
	'parenttitle' => { 357 => '@pti' },
	'partialactivecols1' => { 133 => 0x17e8 },
	'partialactivecols2' => { 133 => 0x17f2 },
	'partialactiverows1' => { 133 => 0x17fc },
	'partialactiverows2' => { 133 => 0x1806 },
	'partofcompilation' => { 486 => 'partOfCompilation' },
	'patientbirthdate' => { 440 => 'PatientDOB' },
	'patientid' => { 440 => 'PatientID' },
	'patientname' => { 440 => 'PatientName' },
	'patientsex' => { 440 => 'PatientSex' },
	'patternareaheight' => { 133 => 0x963 },
	'patternareawidth' => { 133 => 0x962 },
	'patterncorrectionfactorscale' => { 133 => 0x969 },
	'patterncropcols1' => { 133 => 0x96c },
	'patterncropcols2' => { 133 => 0x96d },
	'patterncroprows1' => { 133 => 0x96a },
	'patterncroprows2' => { 133 => 0x96b },
	'patternimagerheight' => { 133 => 0x961 },
	'patternimagerwidth' => { 133 => 0x960 },
	'patternx' => { 133 => 0x966 },
	'patterny' => { 133 => 0x967 },
	'pdfversion' => { 473 => 'PDFVersion' },
	'pentaximagesize' => { 340 => 0x9 },
	'pentaxmodelid' => { 320 => 0x0, 340 => 0x5 },
	'pentaxmodeltype' => { 340 => 0x1 },
	'pentaxversion' => { 340 => 0x0 },
	'people' => { 441 => 'People', 453 => 'People' },
	'perchannelblacklevel' => { 42 => 0xc4, 43 => [0x2b4,0x2cb,0x2cf], 44 => [0x108,0x14d], 45 => 0x1df, 46 => [0x1f8,0x2d8], 47 => [0x22c,0x30a], 48 => 0x149 },
	'performer' => { 357 => 'perf', 365 => 'perf' },
	'performerkeywords' => { 365 => "\xa9prk" },
	'performers' => { 365 => "\xa9prf" },
	'performerurl' => { 365 => "\xa9prl" },
	'peripheralillumcentralradius' => { 438 => 0x8030 },
	'peripheralillumcentralvalue' => { 438 => 0x8031 },
	'peripheralillumination' => { 99 => 0x20702, 105 => 0x68 },
	'peripheralilluminationcorr' => { 60 => 0x1, 330 => 0x2 },
	'peripheralilluminationon' => { 99 => '0x20702.0', 105 => 0x64 },
	'peripheralillumperiphvalue' => { 438 => 0x8032 },
	'peripherallighting' => { 76 => 0x2, 123 => 0x3804 },
	'peripherallightingsetting' => { 77 => 0x5 },
	'peripherallightingvalue' => { 76 => 0x6 },
	'permissions' => { 479 => 'permissions' },
	'permits' => { 458 => 'permits' },
	'person' => { 476 => 'person' },
	'personality' => { 450 => 'Personality' },
	'personheard' => { 472 => 'PersonHeard' },
	'personheardidentifier' => { 472 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 472 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 472 => 'PersonInImage' },
	'personinimagecharacteristic' => { 472 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 472 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 472 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 472 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 472 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 472 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 472 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 472 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 472 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 460 => 'PerspectiveAspect', 462 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 460 => 'PerspectiveHorizontal', 462 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 460 => 'PerspectiveRotate', 462 => 'PerspectiveRotate' },
	'perspectivescale' => { 460 => 'PerspectiveScale', 462 => 'PerspectiveScale' },
	'perspectiveupright' => { 460 => 'PerspectiveUpright', 462 => 'PerspectiveUpright' },
	'perspectivevertical' => { 460 => 'PerspectiveVertical', 462 => 'PerspectiveVertical' },
	'perspectivex' => { 460 => 'PerspectiveX', 462 => 'PerspectiveX' },
	'perspectivey' => { 460 => 'PerspectiveY', 462 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 88 => 0x1 },
	'pf10retainprogramshift' => { 88 => 0xb },
	'pf13drivepriority' => { 88 => 0xe },
	'pf14disablefocussearch' => { 88 => 0xf },
	'pf15disableafassistbeam' => { 88 => 0x10 },
	'pf16autofocuspointshoot' => { 88 => 0x11 },
	'pf17disableafpointsel' => { 88 => 0x12 },
	'pf18enableautoafpointsel' => { 88 => 0x13 },
	'pf19continuousshootspeed' => { 88 => 0x14 },
	'pf19shootingspeedhigh' => { 87 => 0xa },
	'pf19shootingspeedlow' => { 87 => 0x9 },
	'pf1disableshootingmodes' => { 88 => 0x2 },
	'pf1value' => { 87 => 0x1 },
	'pf20limitcontinousshots' => { 88 => 0x15 },
	'pf20maxcontinousshots' => { 87 => 0xb },
	'pf21enablequietoperation' => { 88 => 0x16 },
	'pf23felocktime' => { 87 => 0xd },
	'pf23postreleasetime' => { 87 => 0xe },
	'pf23settimerlengths' => { 88 => 0x18 },
	'pf23shutterbuttontime' => { 87 => 0xc },
	'pf24lightlcdduringbulb' => { 88 => 0x19 },
	'pf25aemode' => { 87 => 0xf },
	'pf25afmode' => { 87 => 0x12 },
	'pf25afpointsel' => { 87 => 0x13 },
	'pf25colormatrix' => { 87 => 0x17 },
	'pf25defaultclearsettings' => { 88 => 0x1a },
	'pf25drivemode' => { 87 => 0x11 },
	'pf25imagesize' => { 87 => 0x14 },
	'pf25meteringmode' => { 87 => 0x10 },
	'pf25parameters' => { 87 => 0x16 },
	'pf25wbmode' => { 87 => 0x15 },
	'pf26shortenreleaselag' => { 88 => 0x1b },
	'pf27reversedialrotation' => { 88 => 0x1c },
	'pf27value' => { 87 => 0x18 },
	'pf28noquickdialexpcomp' => { 88 => 0x1d },
	'pf29quickdialswitchoff' => { 88 => 0x1e },
	'pf2disablemeteringmodes' => { 88 => 0x3 },
	'pf2value' => { 87 => 0x2 },
	'pf30enlargementmode' => { 88 => 0x1f },
	'pf31originaldecisiondata' => { 88 => 0x20 },
	'pf3manualexposuremetering' => { 88 => 0x4 },
	'pf3value' => { 87 => 0x3 },
	'pf4exposuretimelimits' => { 88 => 0x5 },
	'pf4exposuretimemax' => { 87 => 0x5 },
	'pf4exposuretimemin' => { 87 => 0x4 },
	'pf5aperturelimits' => { 88 => 0x6 },
	'pf5aperturemax' => { 87 => 0x7 },
	'pf5aperturemin' => { 87 => 0x6 },
	'pf6presetshootingmodes' => { 88 => 0x7 },
	'pf7bracketcontinuousshoot' => { 88 => 0x8 },
	'pf8bracketshots' => { 87 => 0x8 },
	'pf8setbracketshots' => { 88 => 0x9 },
	'pf9changebracketsequence' => { 88 => 0xa },
	'phasedetectaf' => { 187 => 0x6 },
	'phonenumber' => { 152 => 'Phone' },
	'photoeffect' => { 34 => 0x28 },
	'photoeffecthistoryxml' => { 258 => 0xe9651831 },
	'photoeffects' => { 258 => 0xab5eca5e },
	'photoeffectsblue' => { 260 => 0x8 },
	'photoeffectsgreen' => { 260 => 0x6 },
	'photoeffectsred' => { 260 => 0x4 },
	'photoeffectstype' => { 260 => 0x0 },
	'photographicsensitivity' => { 467 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 265 => '17.6', 274 => '33.6' },
	'photometricinterpretation' => { 115 => 0x106, 482 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 237 => 0xe7d, 246 => 0xfbd },
	'photoshootingmenubankimagearea' => { 237 => '3716.1', 246 => 0x791 },
	'photoshopbgrthumbnail' => { 354 => 0x409 },
	'photoshopquality' => { 353 => 0x0 },
	'photoshopthumbnail' => { 354 => 0x40c },
	'photostyle' => { 305 => 0x89 },
	'picklabel' => { 465 => 'PickLabel' },
	'pictinfo' => { 381 => 0x208 },
	'picturecontrol' => { 258 => 0xe2173c47 },
	'picturecontrolactive' => { 261 => 0x0 },
	'picturecontroladjust' => { 220 => 0x30, 221 => 0x30, 222 => 0x36 },
	'picturecontrolbase' => { 220 => 0x18, 221 => 0x18, 222 => 0x1c },
	'picturecontroldata' => { 218 => [0xbd,0x23] },
	'picturecontrolmode' => { 261 => 0x13 },
	'picturecontrolname' => { 220 => 0x4, 221 => 0x4, 222 => 0x8 },
	'picturecontrolquickadjust' => { 220 => 0x31, 221 => 0x31, 222 => 0x37 },
	'pictureeffect' => { 405 => 0x200e },
	'pictureeffect2' => { 413 => 0x1163, 414 => 0x1167, 415 => 0x1143, 416 => 0x11bf, 417 => 0x119b, 418 => 0x1053, 419 => 0x24b, 420 => 0x24b, 421 => 0x23c, 434 => 0x46 },
	'picturefinish' => { 176 => 0x71 },
	'picturemode' => { 123 => 0x1031, 282 => 0x520, 340 => [0xb,0x33], 382 => 0x3d },
	'picturemode2' => { 321 => 0x0 },
	'picturemodebwfilter' => { 282 => 0x525 },
	'picturemodecontrast' => { 282 => 0x523 },
	'picturemodeeffect' => { 282 => 0x52d },
	'picturemodehue' => { 282 => 0x522 },
	'picturemodesaturation' => { 282 => 0x521 },
	'picturemodesharpness' => { 282 => 0x524 },
	'picturemodetone' => { 282 => 0x526 },
	'pictureprofile' => { 413 => [0x115e,0x115f], 414 => [0x1162,0x1163], 415 => [0x113e,0x113f], 416 => [0x11ba,0x11bb], 417 => [0x1196,0x1197], 418 => [0x104e,0x104f], 419 => [0x246,0x247], 420 => [0x246,0x247], 421 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 71 => 0xa, 99 => 0x20301, 105 => 0x2 },
	'picturestylepc' => { 61 => 0x4009 },
	'picturestyleuserdef' => { 61 => 0x4008 },
	'picturewizard' => { 379 => 0x21 },
	'picturewizardcolor' => { 378 => 0x1 },
	'picturewizardcontrast' => { 378 => 0x4 },
	'picturewizardmode' => { 378 => 0x0 },
	'picturewizardsaturation' => { 378 => 0x2 },
	'picturewizardsharpness' => { 378 => 0x3 },
	'pipelineversion' => { 171 => 'PipelineVersion' },
	'pitch' => { 111 => 0x6, 266 => '4.1', 278 => '4.1', 365 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 236 => 0x350f, 237 => 0x2c28, 245 => 0x36f8, 282 => 0x904, 305 => 0x91, 339 => 0x2, 377 => 0x1 },
	'pitchshift' => { 359 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 358 => 'pasp' },
	'pixelclockfrequency' => { 133 => 0x40b },
	'pixelcorrectionoffset' => { 133 => 0x972 },
	'pixelcorrectionscale' => { 133 => 0x971 },
	'pixelscale' => { 115 => 0x830e },
	'pixelshiftinfo' => { 405 => 0x202f },
	'pixelshiftresolution' => { 341 => 0x0 },
	'pixelsperunitx' => { 294 => 0x0 },
	'pixelsperunity' => { 294 => 0x4 },
	'pixelunits' => { 294 => 0x8 },
	'planarconfiguration' => { 115 => 0x11c, 482 => 'PlanarConfiguration' },
	'planningref' => { 472 => 'PlanningRef' },
	'planningrefidentifier' => { 472 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 472 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 472 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 491 => 'PlateNames' },
	'platform' => { 476 => 'platform' },
	'playallframes' => { 365 => 'AllF' },
	'playbackmenustime' => { 270 => '20.1', 271 => '21.1', 272 => '21.1' },
	'playbackmonitorofftime' => { 265 => '25.2', 266 => '36.1', 268 => '36.1', 269 => '36.1', 273 => '35.1', 274 => '8.1', 275 => '35.1', 278 => '36.1', 279 => '36.1', 280 => '21.1' },
	'playbackzoom' => { 266 => '37.1' },
	'playdisplay' => { 178 => 0x4e },
	'playerversion' => { 359 => 'player.version' },
	'playgap' => { 357 => 'pgap' },
	'playlistid' => { 357 => 'plID' },
	'playmode' => { 365 => 'SDLN' },
	'playselection' => { 365 => 'SelO' },
	'plusversion' => { 292 => 'Version' },
	'pmversion' => { 352 => 'PMVersion' },
	'pngwarning' => { 295 => 'Warning' },
	'podcast' => { 357 => 'pcst' },
	'podcasturl' => { 357 => 'purl' },
	'poilevel' => { 217 => 0x8 },
	'portraitnote' => { 443 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 105 => 0x1d },
	'portraitoutputshadowpoint' => { 105 => 0x1e },
	'portraitrawcolortone' => { 105 => 0x16 },
	'portraitrawcontrast' => { 105 => 0x18 },
	'portraitrawhighlight' => { 105 => 0x76 },
	'portraitrawhighlightpoint' => { 105 => 0x1b },
	'portraitrawlinear' => { 105 => 0x19 },
	'portraitrawsaturation' => { 105 => 0x17 },
	'portraitrawshadow' => { 105 => 0x7f },
	'portraitrawshadowpoint' => { 105 => 0x1c },
	'portraitrawsharpness' => { 105 => 0x1a },
	'portraitrefiner' => { 109 => 0x302b },
	'portraitrequest' => { 443 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 105 => 0x9a },
	'portraitunsharpmaskstrength' => { 105 => 0x98 },
	'portraitunsharpmaskthreshold' => { 105 => 0x9c },
	'portraitversion' => { 443 => 'PortraitVersion' },
	'poseheadingdegrees' => { 448 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 448 => 'PosePitchDegrees' },
	'poserolldegrees' => { 448 => 'PoseRollDegrees' },
	'positiondescriptor' => { 475 => 'positionDescriptor' },
	'postalcode' => { 156 => 'PostalCode' },
	'postcropvignetteamount' => { 460 => 'PostCropVignetteAmount', 462 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 460 => 'PostCropVignetteFeather', 462 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 460 => 'PostCropVignetteHighlightContrast', 462 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 460 => 'PostCropVignetteMidpoint', 462 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 460 => 'PostCropVignetteRoundness', 462 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 460 => 'PostCropVignetteStyle', 462 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 402 => 0xb },
	'potentialface2position' => { 402 => 0x15 },
	'potentialface3position' => { 402 => 0x1f },
	'potentialface4position' => { 402 => 0x29 },
	'potentialface5position' => { 402 => 0x33 },
	'potentialface6position' => { 402 => 0x3d },
	'potentialface7position' => { 402 => 0x47 },
	'potentialface8position' => { 402 => 0x51 },
	'powersource' => { 319 => '0.1' },
	'poweruptime' => { 218 => 0xb6 },
	'precaptureframes' => { 287 => 0x300 },
	'predictor' => { 115 => 0x13d },
	'preflashreturnstrength' => { 234 => 0x28a },
	'prefs' => { 127 => 0xdd, 352 => 'Prefs' },
	'prereadfastresetcount' => { 133 => 0x187e },
	'preservedfilename' => { 487 => 'PreservedFileName' },
	'preservedspecimen' => { 114 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 114 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presetwhitebalance' => { 178 => 0x24, 438 => 0x8002 },
	'presetwhitebalanceadj' => { 438 => 0x8014 },
	'pressure' => { 115 => 0x9402, 467 => 'Pressure' },
	'previewapplicationname' => { 115 => 0xc716 },
	'previewapplicationversion' => { 115 => 0xc717 },
	'previewbutton' => { 265 => ['14.1','15.1'], 266 => '15.1', 268 => '15.1', 269 => '15.1', 274 => '29.1', 275 => '14.1', 278 => '15.1', 279 => '15.1' },
	'previewbuttonplusdials' => { 265 => ['14.2','15.2'], 266 => '15.2', 268 => '43.1', 269 => '43.1', 274 => '31.2', 278 => '43.1', 279 => '43.1' },
	'previewcolorspace' => { 115 => 0xc71a },
	'previewcropbottom' => { 351 => 0xef },
	'previewcropleft' => { 351 => 0xec },
	'previewcropright' => { 351 => 0xee },
	'previewcroptop' => { 351 => 0xed },
	'previewdate' => { 363 => 0x0 },
	'previewdatetime' => { 115 => 0xc71b },
	'previewimage' => { 109 => 0x2000, 110 => 'Exif::PreviewImage', 116 => 'PreviewImage', 118 => 0x4, 161 => 'data', 180 => 0x81, 287 => 0x280, 303 => 0x300, 405 => 0x2001 },
	'previewimageborders' => { 340 => 0x3e },
	'previewimageheight' => { 70 => 0x4, 137 => 0xfa58 },
	'previewimagelength' => { 70 => 0x2, 109 => 0x3, 115 => [0x117,0x202], 180 => 0x89, 223 => 0x202, 282 => 0x102, 287 => 0x1037, 340 => 0x3, 371 => 0x1e, 376 => 0x3, 382 => [0x1b,0x1d], 395 => 0x202 },
	'previewimagename' => { 161 => '1Name' },
	'previewimagesize' => { 109 => 0x2, 142 => 0x2, 161 => 'ImageSize', 340 => 0x2, 382 => [0x1c,0x1e], 405 => 0xb02c, 438 => 0x9012 },
	'previewimagestart' => { 70 => 0x5, 109 => 0x4, 115 => [0x111,0x201], 180 => 0x88, 223 => 0x201, 282 => 0x101, 287 => 0x1036, 340 => 0x4, 371 => 0x1c, 376 => 0x2, 382 => [0x1a,0x1c], 395 => 0x201 },
	'previewimagetype' => { 161 => '0Type' },
	'previewimagevalid' => { 282 => 0x100, 287 => 0x1035 },
	'previewimagewidth' => { 70 => 0x3, 137 => 0xfa57 },
	'previewquality' => { 70 => 0x1 },
	'previewsettingsdigest' => { 115 => 0xc719 },
	'previewsettingsname' => { 115 => 0xc718 },
	'primaryafpoint' => { 187 => [0x44,0x7] },
	'primarychromaticities' => { 115 => 0x13f, 482 => 'PrimaryChromaticities' },
	'primaryftp' => { 450 => 'PrimaryFTP' },
	'primaryslot' => { 237 => 0xe7f, 246 => 0xfbf },
	'printim' => { 115 => 0xc4a5 },
	'prioritysetinawb' => { 405 => 0x202b },
	'prioritysetupshutterrelease' => { 178 => 0x1d, 392 => 0x28 },
	'privatertkinfo' => { 452 => 'privateRTKInfo' },
	'processbordercolsleft' => { 133 => 0xc61 },
	'processbordercolsright' => { 133 => 0xc62 },
	'processborderrowsbottom' => { 133 => 0xc64 },
	'processborderrowstop' => { 133 => 0xc63 },
	'processingsoftware' => { 115 => 0xb },
	'processversion' => { 460 => 'ProcessVersion', 462 => 'ProcessVersion' },
	'producer' => { 291 => 'Producer', 359 => 'producer', 365 => "\xa9prd", 473 => 'Producer' },
	'producerkeywords' => { 365 => "\xa9pdk" },
	'productcode' => { 476 => 'productCode' },
	'productid' => { 128 => 0x32, 357 => 'prID', 475 => 'productID' },
	'productidtype' => { 475 => 'productIDType' },
	'productinimage' => { 472 => 'ProductInImage' },
	'productinimagedescription' => { 472 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 472 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 472 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 320 => 0x2 },
	'productorserviceconstraints' => { 292 => 'ProductOrServiceConstraints' },
	'productversion' => { 357 => 'VERS' },
	'profession' => { 476 => 'profession' },
	'profilecalibrationsig' => { 115 => 0xc6f4 },
	'profilecopyright' => { 115 => 0xc6fe },
	'profileembedpolicy' => { 115 => 0xc6fd },
	'profilehuesatmapdata1' => { 115 => 0xc6fa },
	'profilehuesatmapdata2' => { 115 => 0xc6fb },
	'profilehuesatmapdims' => { 115 => 0xc6f9 },
	'profilehuesatmapencoding' => { 115 => 0xc7a3 },
	'profilelooktabledata' => { 115 => 0xc726 },
	'profilelooktabledims' => { 115 => 0xc725 },
	'profilelooktableencoding' => { 115 => 0xc7a4 },
	'profilename' => { 115 => 0xc6f8 },
	'profiletonecurve' => { 115 => 0xc6fc },
	'programiso' => { 305 => 0x3c },
	'programline' => { 321 => '1.1' },
	'programmode' => { 183 => 0x5 },
	'programshift' => { 218 => 0xd },
	'programversion' => { 127 => 0x46 },
	'prohibits' => { 458 => 'prohibits' },
	'projectiontype' => { 448 => 'ProjectionType', 449 => 'ProjectionType' },
	'projectname' => { 486 => 'projectName' },
	'projectref' => { 486 => 'projectRef' },
	'projectrefpath' => { 486 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 486 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 292 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 292 => 'PropertyReleaseStatus' },
	'province-state' => { 127 => 0x5f },
	'publicationdate' => { 476 => 'publicationDate' },
	'publicationdatea-platform' => { 476 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 476 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 476 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 476 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 476 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 472 => 'PublicationEvent' },
	'publicationeventdate' => { 472 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 472 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 472 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 476 => 'publicationName' },
	'publisher' => { 357 => "\xa9pub", 359 => 'publisher', 463 => 'publisher' },
	'publishingfrequency' => { 476 => 'publishingFrequency' },
	'pulldown' => { 486 => 'pullDown' },
	'purchasedate' => { 357 => 'purd' },
	'purplehsl' => { 99 => 0x20916 },
	'pxshiftperiphedgenr' => { 438 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 438 => 0x9014 },
	'quality' => { 0 => 0x1, 34 => 0x3, 108 => 0x2, 109 => 0x3002, 123 => 0x1000, 135 => 0x9, 218 => 0x4, 248 => 0x3, 287 => 0x201, 300 => 0x300, 340 => 0x8, 347 => 0x2, 382 => 0x16, 392 => 0x56, 393 => 0x56, 394 => 0xb, 405 => [0x102,0x202e] },
	'quality2' => { 413 => 0x1170, 414 => 0x1174, 415 => 0x1150, 417 => 0x11a8, 418 => 0x1060, 419 => 0x258, 420 => 0x258, 421 => 0x247, 425 => 0x29, 426 => 0x25, 427 => 0x2a },
	'qualitymode' => { 109 => 0x8 },
	'quantizationmethod' => { 129 => 0x78 },
	'quickadjust' => { 261 => 0x2a },
	'quickcontroldialinmeter' => { 80 => 0x703 },
	'quickfix' => { 258 => 0x416391c6 },
	'quickshot' => { 381 => 0x213 },
	'quiettime' => { 133 => 0x188a },
	'rads' => { 365 => 'rads' },
	'rangefinder' => { 270 => '4.1', 271 => '5.1', 272 => '5.1' },
	'rasterizedcaption' => { 127 => 0x7d },
	'rating' => { 115 => 0x4746, 123 => 0x1431, 351 => 0xdf, 357 => 'rtng', 405 => 0x2002, 455 => 'rating', 464 => 'rating', 472 => 'Rating', 476 => 'rating', 484 => 'Rating' },
	'ratingpercent' => { 115 => 0x4749, 173 => 'Rating', 357 => 'rate' },
	'ratingregion' => { 472 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 472 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 472 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 472 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 472 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 472 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 472 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 472 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 472 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 472 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 472 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 472 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 472 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 472 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 472 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 472 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 472 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 472 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 78 => 0x8, 180 => 0x109, 321 => 0xd },
	'rawbrightnessadj' => { 99 => 0x20001, 104 => 0x38 },
	'rawburstimagecount' => { 72 => 0x2 },
	'rawburstimagenum' => { 72 => 0x1 },
	'rawcoloradj' => { 104 => 0x2e },
	'rawcropbottom' => { 351 => 0xd4 },
	'rawcropleft' => { 351 => 0xd1 },
	'rawcropright' => { 351 => 0xd3 },
	'rawcroptop' => { 351 => 0xd2 },
	'rawcustomsaturation' => { 104 => 0x30 },
	'rawcustomtone' => { 104 => 0x34 },
	'rawdata' => { 379 => 0xa048 },
	'rawdatabyteorder' => { 379 => 0x40 },
	'rawdatacfapattern' => { 379 => 0x50 },
	'rawdatauniqueid' => { 115 => 0xc65d },
	'rawdepth' => { 182 => 0x10 },
	'rawdevartfilter' => { 289 => 0x121 },
	'rawdevautogradation' => { 289 => 0x119 },
	'rawdevcolorspace' => { 288 => 0x108, 289 => 0x109 },
	'rawdevcontrastvalue' => { 288 => 0x106, 289 => 0x105 },
	'rawdeveditstatus' => { 288 => 0x10b },
	'rawdevelopmentprocess' => { 340 => 0x62 },
	'rawdevengine' => { 288 => 0x109, 289 => 0x10b },
	'rawdevexposurebiasvalue' => { 288 => 0x100, 289 => 0x100 },
	'rawdevgradation' => { 289 => 0x112 },
	'rawdevgraypoint' => { 288 => 0x103, 289 => 0x104 },
	'rawdevmemorycoloremphasis' => { 288 => 0x105, 289 => 0x108 },
	'rawdevnoisereduction' => { 288 => 0x10a, 289 => 0x10a },
	'rawdevpicturemode' => { 289 => 0x10c },
	'rawdevpm_bwfilter' => { 289 => 0x110 },
	'rawdevpmcontrast' => { 289 => 0x10e },
	'rawdevpmnoisefilter' => { 289 => 0x120 },
	'rawdevpmpicturetone' => { 289 => 0x111 },
	'rawdevpmsaturation' => { 289 => 0x10d },
	'rawdevpmsharpness' => { 289 => 0x10f },
	'rawdevsaturation3' => { 289 => 0x113 },
	'rawdevsaturationemphasis' => { 288 => 0x104, 289 => 0x107 },
	'rawdevsettings' => { 288 => 0x10c },
	'rawdevsharpnessvalue' => { 288 => 0x107, 289 => 0x106 },
	'rawdevversion' => { 288 => 0x0, 289 => 0x0 },
	'rawdevwbfineadjustment' => { 288 => 0x102, 289 => 0x103 },
	'rawdevwhitebalance' => { 289 => 0x101 },
	'rawdevwhitebalancevalue' => { 288 => 0x101, 289 => 0x102 },
	'rawfile' => { 115 => 0xfe4c },
	'rawfilename' => { 460 => 'RawFileName', 462 => 'RawFileName' },
	'rawfiletype' => { 405 => 0x2029 },
	'rawformat' => { 310 => 0x2d, 349 => 0x10e },
	'rawimagecenter' => { 218 => 0x99 },
	'rawimagedigest' => { 115 => 0xc71c },
	'rawimagesize' => { 340 => 0x39 },
	'rawinfoversion' => { 290 => 0x0 },
	'rawjpgheight' => { 95 => 0x4 },
	'rawjpgquality' => { 55 => 0x6, 95 => 0x1 },
	'rawjpgsize' => { 55 => 0x7, 95 => 0x2 },
	'rawjpgwidth' => { 95 => 0x3 },
	'rawmeasuredrggb' => { 41 => 0x26a, 43 => 0x280, 45 => 0x194, 46 => [0x1ad,0x26b] },
	'rawrppused' => { 455 => 'rawrppused' },
	'rawtopreviewgain' => { 115 => 0xc7a8 },
	'readouttypeactual' => { 133 => 0x1903 },
	'readouttyperequested' => { 133 => 0x1902 },
	'reardisplay' => { 265 => '12.3', 266 => '6.2' },
	'recdevice' => { 472 => 'RecDevice' },
	'recdeviceattlensdescription' => { 472 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 472 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 472 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 472 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 472 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 478 => 'recipeEndingPage' },
	'recipepagerange' => { 478 => 'recipePageRange' },
	'recipesource' => { 478 => 'recipeSource' },
	'recipestartingpage' => { 478 => 'recipeStartingPage' },
	'recipetitle' => { 478 => 'recipeTitle' },
	'recognizedface1age' => { 298 => 0x20 },
	'recognizedface1name' => { 298 => 0x4 },
	'recognizedface1position' => { 298 => 0x18 },
	'recognizedface2age' => { 298 => 0x50 },
	'recognizedface2name' => { 298 => 0x34 },
	'recognizedface2position' => { 298 => 0x48 },
	'recognizedface3age' => { 298 => 0x80 },
	'recognizedface3name' => { 298 => 0x64 },
	'recognizedface3position' => { 298 => 0x78 },
	'recognizedfaceflags' => { 305 => 0x63 },
	'recommendedexposureindex' => { 115 => 0x8832, 467 => 'RecommendedExposureIndex' },
	'record' => { 114 => 'Record' },
	'recordbasisofrecord' => { 114 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 114 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 114 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 114 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 114 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 114 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 178 => 0x4d },
	'recorddynamicproperties' => { 114 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 93 => 0x1804 },
	'recordinformationwithheld' => { 114 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 365 => "\xa9phg" },
	'recordingformat' => { 372 => 0x1000 },
	'recordingmode' => { 108 => 0x1, 347 => 0x1 },
	'recordinstitutioncode' => { 114 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 114 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 365 => "\xa9lab" },
	'recordlabelurl' => { 365 => "\xa9lal" },
	'recordmode' => { 34 => 0x9, 109 => 0x3000 },
	'recordownerinstitutioncode' => { 114 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 381 => 0x217 },
	'redbalance' => { 287 => 0x1017, 310 => 0x11, 340 => 0x1c },
	'redcurvelimits' => { 104 => 0x18a },
	'redcurvepoints' => { 103 => 0x2d, 104 => 0x160 },
	'redeyecorrection' => { 262 => 0x0 },
	'redeyeinfo' => { 460 => 'RedEyeInfo', 462 => 'RedEyeInfo' },
	'redeyereduction' => { 178 => 0x41, 392 => 0x6a, 394 => 0x28 },
	'redeyeremoval' => { 305 => 0xb9 },
	'redhsl' => { 99 => 0x20910 },
	'redhue' => { 460 => 'RedHue', 462 => 'RedHue' },
	'redsaturation' => { 460 => 'RedSaturation', 462 => 'RedSaturation' },
	'reductionmatrix1' => { 115 => 0xc625 },
	'reductionmatrix2' => { 115 => 0xc626 },
	'reelname' => { 115 => 0xc789, 365 => 'reel' },
	'reference1' => { 470 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 470 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 470 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 470 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 470 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 470 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 115 => 0x214, 482 => 'ReferenceBlackWhite' },
	'referencedate' => { 127 => 0x2f },
	'referencenumber' => { 127 => 0x32 },
	'references' => { 152 => 'References' },
	'referenceservice' => { 127 => 0x2d },
	'regionappliedtodimensions' => { 167 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 167 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 167 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 167 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 167 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 167 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 167 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 167 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 167 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 167 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 167 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 167 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 292 => 'RegionConstraints' },
	'regiondescription' => { 167 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 167 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 167 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 167 => 'Regions' },
	'regioninfodateregionsvalid' => { 170 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 170 => 'RegionInfo' },
	'regioninforegions' => { 170 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 167 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 167 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 170 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 170 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 170 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 170 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 170 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 167 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 167 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 167 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 472 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 472 => 'RegistryId' },
	'registryitemid' => { 472 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 472 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 150 => 'data' },
	'relatedaudiofilename' => { 150 => '1Name' },
	'relatedaudiofiletype' => { 150 => '0Type' },
	'relatedimagefileformat' => { 115 => 0x1000 },
	'relatedimageheight' => { 115 => 0x1002 },
	'relatedimagewidth' => { 115 => 0x1001 },
	'relatedresourceid' => { 114 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 115 => 0xa004, 466 => 'RelatedSoundFile' },
	'relatedvideofile' => { 164 => 'data' },
	'relatedvideofilename' => { 164 => '1Name' },
	'relatedvideofiletype' => { 164 => '0Type' },
	'relation' => { 463 => 'relation' },
	'relationshipaccordingto' => { 114 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 114 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 114 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 114 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 112 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 486 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 486 => 'relativeTimestamp' },
	'relativetimestampscale' => { 486 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 486 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 265 => '17.8', 266 => '18.5', 268 => '18.4', 269 => '18.4', 274 => '33.8', 275 => '17.6', 278 => '18.5', 279 => '18.4' },
	'releasedate' => { 127 => 0x1e, 357 => 'rldt', 455 => 'ReleaseDate', 486 => 'releaseDate' },
	'releasemode' => { 109 => 0x3001, 236 => 0x184d, 405 => 0xb049 },
	'releasemode2' => { 413 => 0x112c, 414 => [0x112c,0x8], 415 => [0x1108,0x8], 416 => [0x1184,0x8], 417 => [0x1160,0x8], 418 => [0x4,0x1018], 419 => [0x4,0x210], 420 => [0x4,0x210], 421 => [0x4,0x208], 423 => [0x67,0x3f], 424 => [0x6b,0x6d,0x73,0x4b], 425 => 0x10, 426 => 0x10, 427 => 0x9, 434 => 0x34 },
	'releasemode3' => { 413 => 0x1128, 414 => 0x1128, 415 => 0x1104, 416 => 0x1180, 417 => 0x115c, 418 => 0x1014, 419 => 0x20c, 420 => 0x20c, 421 => 0x204 },
	'releaseready' => { 472 => 'ReleaseReady' },
	'releasesetting' => { 93 => 0x1016 },
	'releasetime' => { 127 => 0x23, 455 => 'ReleaseTime' },
	'remoteonduration' => { 267 => '3.4', 270 => '17.2', 271 => '18.2', 272 => '18.2', 273 => '18.2', 275 => '18.2', 276 => '4.3', 280 => '19.2' },
	'renditionclass' => { 487 => 'RenditionClass' },
	'renditionof' => { 487 => 'RenditionOf' },
	'renditionofalternatepaths' => { 487 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 487 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 487 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 487 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 487 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 487 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 487 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 487 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 487 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 487 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 487 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 487 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 487 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 487 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 487 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 487 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 487 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 487 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 487 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 487 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 487 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 487 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 487 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 487 => 'RenditionParams' },
	'repeatingflashcount' => { 202 => 0xd, 203 => 0xe, 204 => 0xe, 205 => 0xe, 206 => 0xe, 274 => '17.2', 275 => '24.2', 276 => '9.2', 277 => '24.2', 280 => '25.2' },
	'repeatingflashcountbuilt-in' => { 244 => 0x4db },
	'repeatingflashcountexternal' => { 244 => 0x4c3 },
	'repeatingflashoutput' => { 274 => '17.1', 275 => '24.1', 276 => '9.1', 277 => '24.1', 280 => '25.1' },
	'repeatingflashoutputexternal' => { 244 => 0x4c0 },
	'repeatingflashrate' => { 202 => 0xc, 203 => 0xd, 204 => 0xd, 205 => 0xd, 206 => 0xd, 274 => '18.1', 275 => '25.1', 276 => '10.1', 277 => '25.1', 280 => '26.1' },
	'repeatingflashratebuilt-in' => { 244 => 0x4da },
	'repeatingflashrateexternal' => { 244 => 0x4c2 },
	'requirements' => { 365 => "\xa9req" },
	'requires' => { 458 => 'requires' },
	'resampleparams' => { 486 => 'resampleParams' },
	'resampleparamsquality' => { 486 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 133 => 0xe50 },
	'resamplingkerneldenominators067' => { 133 => 0xe4f },
	'resamplingkerneldenominators100' => { 133 => 0xe51 },
	'resaved' => { 381 => 0x21e },
	'resetblacksegrows' => { 133 => 0x181a },
	'resolution' => { 157 => 'Resolution' },
	'resolutionmode' => { 382 => [0x87,0x4] },
	'resolutionunit' => { 115 => 0x128, 130 => 0x2, 482 => 'ResolutionUnit' },
	'resourceid' => { 114 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 114 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 114 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 80 => 0x612 },
	'restrictions' => { 479 => 'restrictions' },
	'retouchareafeather' => { 460 => [\'RetouchAreas','RetouchAreasFeather'], 462 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 460 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 462 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 460 => [\'RetouchAreas','RetouchAreasMasksAngle'], 462 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 460 => [\'RetouchAreas','RetouchAreasMasksBottom'], 462 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 460 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 462 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 460 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 462 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 460 => [\'RetouchAreas','RetouchAreasMasksDabs'], 462 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 460 => [\'RetouchAreas','RetouchAreasMasksFeather'], 462 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 460 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 462 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 460 => [\'RetouchAreas','RetouchAreasMasksFlow'], 462 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 460 => [\'RetouchAreas','RetouchAreasMasksFullX'], 462 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 460 => [\'RetouchAreas','RetouchAreasMasksFullY'], 462 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 460 => [\'RetouchAreas','RetouchAreasMasksLeft'], 462 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 460 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 462 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 460 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 462 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 460 => [\'RetouchAreas','RetouchAreasMasksRadius'], 462 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 460 => [\'RetouchAreas','RetouchAreasMasksRight'], 462 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 460 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 462 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 460 => [\'RetouchAreas','RetouchAreasMasks'], 462 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 460 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 462 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 460 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 462 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 460 => [\'RetouchAreas','RetouchAreasMasksTop'], 462 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 460 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 462 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 460 => [\'RetouchAreas','RetouchAreasMasksVersion'], 462 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 460 => [\'RetouchAreas','RetouchAreasMasksWhat'], 462 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 460 => [\'RetouchAreas','RetouchAreasMasksX'], 462 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 460 => [\'RetouchAreas','RetouchAreasMasksY'], 462 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 460 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 462 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 460 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 462 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 460 => [\'RetouchAreas','RetouchAreasMethod'], 462 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 460 => [\'RetouchAreas','RetouchAreasOffsetY'], 462 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 460 => [\'RetouchAreas','RetouchAreasOpacity'], 462 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 460 => 'RetouchAreas', 462 => 'RetouchAreas' },
	'retouchareaseed' => { 460 => [\'RetouchAreas','RetouchAreasSeed'], 462 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 460 => [\'RetouchAreas','RetouchAreasSourceState'], 462 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 460 => [\'RetouchAreas','RetouchAreasSourceX'], 462 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 460 => [\'RetouchAreas','RetouchAreasSpotType'], 462 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 218 => 0x9e },
	'retouchinfo' => { 460 => 'RetouchInfo', 462 => 'RetouchInfo' },
	'retouchnefprocessing' => { 225 => 0x5 },
	'retractlensonpoweroff' => { 80 => 0x814 },
	'reuse' => { 292 => 'Reuse' },
	'reuseallowed' => { 489 => 'ReuseAllowed' },
	'reuseprohibited' => { 479 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 272 => '5.2' },
	'reverseindicators' => { 265 => '12.1', 266 => '6.1', 268 => '6.1', 269 => '6.1', 270 => '4.3', 271 => '5.2', 272 => '5.4', 274 => '33.5', 275 => '5.1', 278 => '6.1', 279 => '6.1', 280 => '6.2' },
	'reverseshutterspeedaperture' => { 272 => '5.3' },
	'revision' => { 464 => 'revision' },
	'rflensmffocusringsensitivity' => { 80 => 0x714 },
	'rgbcurvelimits' => { 104 => 0x238 },
	'rgbcurvepoints' => { 103 => 0x7, 104 => 0x20e },
	'richtextcomment' => { 469 => 'RichTextComment' },
	'ricohdate' => { 371 => 0x6 },
	'ricohimageheight' => { 371 => 0x2 },
	'ricohimagewidth' => { 371 => 0x0 },
	'rightalbedo' => { 451 => 'RightAlbedo' },
	'rightascension' => { 160 => 'RightAscension' },
	'rights' => { 463 => 'rights' },
	'rightsagent' => { 479 => 'rightsAgent' },
	'rightsowner' => { 479 => 'rightsOwner' },
	'roll' => { 111 => 0x8, 365 => ['roll',"\xa9frl"] },
	'rollangle' => { 236 => 0x350b, 237 => 0x2c24, 245 => 0x36f4, 282 => 0x903, 305 => 0x90, 339 => 0x1, 377 => 0x2 },
	'romoperationmode' => { 93 => 0x80d },
	'rotation' => { 30 => 0x17, 31 => 0x18, 92 => 0x3, 99 => 0x10002, 104 => 0x26e, 110 => 'QuickTime::Rotation', 119 => 0x4, 160 => 'Rotation', 176 => [0x65,0x50], 177 => 0x46, 178 => 0x5a, 181 => 0x10, 236 => 0x3693, 237 => 0xca, 243 => '590.1', 258 => 0x76a43207, 305 => 0x30, 321 => '17.2', 351 => 0xd8, 358 => 'irot', 392 => 0x3f, 393 => 0x3f, 403 => 0x10 },
	'routedto' => { 468 => 'RoutedTo' },
	'routing' => { 356 => 'Routing' },
	'routingdestinations' => { 450 => 'RoutingDestinations' },
	'routingexclusions' => { 450 => 'RoutingExclusions' },
	'routingnotes' => { 468 => 'RoutingNotes' },
	'rowsperstrip' => { 115 => 0x116 },
	'rpp' => { 455 => 'rpp' },
	'rtkflag' => { 112 => 'RtkFlag' },
	'rtkstdhgt' => { 112 => 'RtkStdHgt' },
	'rtkstdlat' => { 112 => 'RtkStdLat' },
	'rtkstdlon' => { 112 => 'RtkStdLon' },
	'safetyshift' => { 80 => 0x108 },
	'safetyshiftinavortv' => { 78 => 0x10, 79 => 0x10, 81 => 0xf, 82 => 0x10, 85 => 0x10 },
	'sameexposurefornewaperture' => { 80 => 0x112 },
	'samplebits' => { 150 => 'SampleBits' },
	'samplepagerange' => { 476 => 'samplePageRange' },
	'samplerate' => { 150 => 'SampleRate' },
	'samplesperpixel' => { 115 => 0x115, 310 => 0x8, 482 => 'SamplesPerPixel' },
	'samplestructure' => { 129 => 0x5a },
	'samsungmodelid' => { 379 => 0x3 },
	'sanyoquality' => { 381 => 0x201 },
	'sanyothumbnail' => { 381 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 34 => 0xe, 49 => 0x1, 108 => 0xd, 109 => [0x3013,0x1f], 115 => [0xa409,0xfe55], 123 => 0x1003, 151 => 'Saturation', 175 => 0x1f, 176 => 0x32, 177 => 0x28, 178 => 0x1a, 183 => 0x1, 218 => 0xaa, 220 => 0x35, 221 => 0x3b, 222 => 0x43, 305 => 0x40, 307 => 0x300d, 340 => 0x1f, 347 => 0xd, 366 => 0x27, 368 => 0x58, 371 => 0x28, 372 => 0x1013, 382 => 0x10, 392 => 0x1e, 393 => 0x1b, 405 => 0x2005, 460 => 'Saturation', 462 => 'Saturation', 466 => 'Saturation' },
	'saturationadj' => { 99 => 0x20901, 104 => 0x116, 218 => 0x94, 257 => 0x1, 261 => 0x2e, 438 => 0x8016 },
	'saturationadjustmentaqua' => { 460 => 'SaturationAdjustmentAqua', 462 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 460 => 'SaturationAdjustmentBlue', 462 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 460 => 'SaturationAdjustmentGreen', 462 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 460 => 'SaturationAdjustmentMagenta', 462 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 460 => 'SaturationAdjustmentOrange', 462 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 460 => 'SaturationAdjustmentPurple', 462 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 460 => 'SaturationAdjustmentRed', 462 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 460 => 'SaturationAdjustmentYellow', 462 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 68 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 67 => 0x68, 68 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 67 => 0x38, 68 => 0x38 },
	'saturationmonochrome' => { 67 => 0x80, 68 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 67 => 0x50, 68 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 67 => 0x20, 68 => 0x20 },
	'saturationsetting' => { 290 => 0x1010, 394 => 0x11, 410 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 67 => 0x8, 68 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 67 => 0x98, 68 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 67 => 0xb0, 68 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 67 => 0xc8, 68 => 0xe0 },
	'saveid' => { 487 => 'SaveID' },
	'sbaanalysiscomplete' => { 133 => 0xc35 },
	'sbablack' => { 133 => 0xc25 },
	'sbagmoffset' => { 133 => 0xc4a },
	'sbagray' => { 133 => 0xc26 },
	'sbagreenmagentabal' => { 133 => 0xc33 },
	'sbahighgray' => { 133 => 0xc46 },
	'sbailloffset' => { 133 => 0xc49 },
	'sbailluminantbal' => { 133 => 0xc34 },
	'sbalowgray' => { 133 => 0xc47 },
	'sbaneutralbal' => { 133 => 0xc32 },
	'sbawhite' => { 133 => 0xc27 },
	'scaletype' => { 486 => 'scaleType' },
	'scanimageenhancer' => { 226 => 0x60 },
	'scanningdirection' => { 129 => 0x64 },
	'scene' => { 365 => 'scen', 471 => 'Scene', 486 => 'scene' },
	'scenearea' => { 285 => 0x211, 287 => 0x1031 },
	'sceneassist' => { 218 => 0x9c },
	'scenecapturetype' => { 115 => 0xa406, 466 => 'SceneCaptureType' },
	'scenedetect' => { 285 => 0x210, 287 => 0x1030 },
	'scenedetectdata' => { 285 => 0x212, 287 => 0x1033 },
	'scenemode' => { 137 => 0xfa02, 180 => 0x100, 218 => 0x8f, 282 => 0x509, 287 => 0x403, 305 => 0x8001, 314 => 0xf, 405 => 0xb023 },
	'scenemodeused' => { 139 => [0x6002,0xf002] },
	'scenerecognition' => { 123 => 0x1425 },
	'sceneselect' => { 381 => 0x21f },
	'scenetype' => { 115 => 0xa301, 466 => 'SceneType' },
	'screentips' => { 265 => '12.7', 266 => '5.3', 274 => '13.1', 275 => '4.4', 278 => '5.4', 280 => '5.1' },
	'scriptversion' => { 133 => 0x1770 },
	'season' => { 472 => 'Season', 475 => 'season' },
	'seasonidentifier' => { 472 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 472 => [\'Season','SeasonName'] },
	'seasonnumber' => { 472 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 450 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 236 => 0x1d0, 245 => 0x1d0 },
	'section' => { 476 => 'section' },
	'securityclassification' => { 115 => 0x9212 },
	'selectableafpoint' => { 80 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 80 => 0x512 },
	'selfdata' => { 112 => 'SelfData' },
	'selftimer' => { 34 => 0x2, 305 => 0x2e, 381 => 0x214, 413 => 0x1134, 414 => 0x1134, 415 => 0x1110, 416 => 0x118c, 417 => 0x1168, 418 => 0x1020, 419 => 0x218, 420 => 0x218, 421 => 0x210 },
	'selftimer2' => { 74 => 0x1d },
	'selftimerinterval' => { 275 => '19.2' },
	'selftimermode' => { 115 => 0x882b },
	'selftimershotcount' => { 266 => '20.2', 268 => '20.3', 269 => '20.3', 270 => '18.2', 271 => '19.2', 272 => '19.2', 273 => '19.3', 275 => '19.3', 278 => '20.3', 279 => '20.3', 280 => '20.2' },
	'selftimershotinterval' => { 266 => '20.3', 268 => '20.2', 269 => '20.2', 273 => '19.2', 278 => '20.2', 279 => '20.2' },
	'selftimertime' => { 93 => 0x1806, 178 => 0x1f, 265 => '18.1', 266 => '20.1', 267 => '3.3', 268 => '20.1', 269 => '20.1', 270 => '18.1', 271 => '19.1', 272 => '19.1', 273 => '19.1', 274 => '7.2', 275 => '19.1', 276 => '3.3', 278 => '20.1', 279 => '20.1', 280 => '20.1' },
	'sellingagency' => { 476 => 'sellingAgency' },
	'seminfo' => { 115 => 0x8546 },
	'sensingmethod' => { 115 => 0xa217, 466 => 'SensingMethod' },
	'sensitivityadjust' => { 340 => 0x40 },
	'sensitivitysteps' => { 321 => ['14.3','17.4'], 323 => 0x1 },
	'sensitivitytype' => { 115 => 0x8830, 467 => 'SensitivityType' },
	'sensor' => { 185 => 0x665e },
	'sensorarea' => { 287 => 0x400 },
	'sensorareas' => { 379 => 0xa010 },
	'sensorbitdepth' => { 307 => 0x312d },
	'sensorbluelevel' => { 71 => 0x5 },
	'sensorcalibration' => { 286 => 0x805 },
	'sensorcleaning' => { 86 => 0xd },
	'sensorfullheight' => { 132 => 0xf904 },
	'sensorfullwidth' => { 132 => 0xf903 },
	'sensorheight' => { 132 => 0xf901, 137 => 0xfa21, 182 => 0x8, 307 => 0x312c, 349 => 0x109, 372 => 0x1602 },
	'sensorimageheight' => { 133 => 0x3ee },
	'sensorimagewidth' => { 133 => 0x3ed },
	'sensorleftborder' => { 133 => 0x3eb },
	'sensorleftmargin' => { 349 => 0x10a },
	'sensorpixelsize' => { 218 => 0x9a },
	'sensorredlevel' => { 71 => 0x4 },
	'sensorserialnumber' => { 133 => 0x9ce },
	'sensorsize' => { 151 => 'SensorSize', 340 => 0x35 },
	'sensortemperature' => { 285 => 0x1500, 287 => 0x1007, 345 => 0xc, 349 => 0x210, 382 => [0x39,0x55] },
	'sensortemperature2' => { 345 => 0xe, 349 => 0x211 },
	'sensortopborder' => { 133 => 0x3ec },
	'sensortopmargin' => { 349 => 0x10b },
	'sensorwidth' => { 132 => 0xf900, 137 => 0xfa20, 182 => 0xa, 307 => 0x312b, 349 => 0x108, 372 => 0x1601 },
	'sequence' => { 366 => 0x7, 367 => 0x35, 368 => 0x36 },
	'sequencefilenumber' => { 414 => 0x4, 415 => 0x4, 416 => 0x4, 417 => 0x4, 425 => 0xc, 426 => 0xc, 427 => 0x1a },
	'sequenceimagenumber' => { 414 => 0x0, 415 => 0x0, 416 => 0x0, 417 => 0x0, 425 => 0x8, 426 => 0x8, 427 => 0x12, 434 => 0x24 },
	'sequencelength' => { 425 => 0x22, 426 => 0x1e, 427 => [0x16,0x1e] },
	'sequencename' => { 475 => 'sequenceName' },
	'sequencenumber' => { 74 => 0x9, 109 => 0x301c, 123 => 0x1101, 135 => 0x1d, 244 => 0x51c, 305 => 0x2b, 394 => [0x10c,0x30c], 405 => 0xb04a, 475 => 'sequenceNumber' },
	'sequenceshotinterval' => { 381 => 0x224 },
	'sequencetotalnumber' => { 475 => 'sequenceTotalNumber' },
	'sequentialshot' => { 381 => 0x20e },
	'serialnumber' => { 61 => 0xc, 93 => 0x180b, 115 => [0xa431,0xfde9], 132 => 0xfa04, 134 => 0xfa00, 136 => 0xc354, 137 => 0xfa19, 148 => 0x0, 151 => 'SerialNumber', 185 => 0x5501, 218 => [0xa0,0x1d], 283 => 0x101, 287 => [0x404,0x101a], 300 => 0x303, 302 => 0x305, 307 => 0x3103, 340 => 0x229, 349 => 0x102, 350 => 0x407, 365 => ['SNum','slno'], 366 => 0x15, 367 => 0x4b, 368 => 0x7e, 372 => 0x5, 379 => 0xa002, 382 => 0x2, 405 => 0x2031, 457 => 'SerialNumber', 467 => 'BodySerialNumber' },
	'serialnumberformat' => { 61 => 0x15, 93 => 0x183b },
	'serialnumberhash' => { 365 => 'CAME' },
	'series' => { 472 => 'Series' },
	'seriesdatetime' => { 440 => 'SeriesDateTime' },
	'seriesdescription' => { 440 => 'SeriesDescription' },
	'seriesidentifier' => { 472 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 440 => 'SeriesModality' },
	'seriesname' => { 472 => [\'Series','SeriesName'] },
	'seriesnumber' => { 440 => 'SeriesNumber', 476 => 'seriesNumber' },
	'seriestitle' => { 476 => 'seriesTitle' },
	'serviceidentifier' => { 128 => 0x1e },
	'servingsize' => { 478 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 83 => 0x0, 84 => 0x0 },
	'setbuttonwhenshooting' => { 78 => 0x1, 80 => 0x704, 86 => 0xc },
	'setfunctionwhenshooting' => { 81 => 0x0, 82 => 0x1, 85 => 0x1 },
	'setting' => { 475 => 'setting' },
	'shadingcompensation' => { 282 => 0x50c, 305 => 0x8a },
	'shadingcompensation2' => { 286 => 0x1012 },
	'shadow' => { 382 => 0xe },
	'shadowadj' => { 99 => 0x2030b },
	'shadowcorrection' => { 340 => 0x79 },
	'shadowprotection' => { 257 => 0x0 },
	'shadows' => { 115 => 0xfe52, 454 => 'Shadows', 460 => 'Shadows', 462 => 'Shadows' },
	'shadows2012' => { 460 => 'Shadows2012', 462 => 'Shadows2012' },
	'shadowsadj' => { 438 => 0x901a },
	'shadowscale' => { 115 => 0xc633 },
	'shadowtint' => { 460 => 'ShadowTint', 462 => 'ShadowTint' },
	'shadowtone' => { 123 => 0x1040 },
	'shakereduction' => { 342 => 0x1, 343 => 0x1 },
	'sharpendetail' => { 460 => 'SharpenDetail', 462 => 'SharpenDetail' },
	'sharpenedgemasking' => { 460 => 'SharpenEdgeMasking', 462 => 'SharpenEdgeMasking' },
	'sharpening' => { 307 => 0x300b },
	'sharpeningadj' => { 261 => 0x2b },
	'sharpeningkernel' => { 133 => 0x92f },
	'sharpenradius' => { 460 => 'SharpenRadius', 462 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 34 => 0xf, 71 => 0x2, 108 => 0xb, 109 => [0x3011,0x21], 115 => [0xa40a,0xfe56], 123 => 0x1001, 135 => 0x6b, 144 => 0x37, 151 => 'Sharpness', 175 => 0x21, 176 => 0x30, 177 => 0x26, 178 => 0x18, 183 => 0x3, 218 => 0x6, 220 => 0x32, 221 => 0x33, 222 => 0x39, 287 => 0x100f, 305 => 0x41, 340 => 0x21, 347 => 0xb, 366 => 0x26, 368 => 0x56, 371 => 0x22, 372 => [0x1003,0x1014], 382 => 0x11, 392 => 0x1c, 393 => 0x19, 405 => 0x2006, 434 => 0x52, 460 => 'Sharpness', 462 => 'Sharpness', 466 => 'Sharpness' },
	'sharpnessadj' => { 99 => 0x20310, 104 => 0x25a, 438 => 0x801a },
	'sharpnessadjon' => { 99 => '0x20310.0' },
	'sharpnessauto' => { 68 => 0x94 },
	'sharpnessfactor' => { 287 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 67 => 0x64, 68 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 71 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 67 => 0x34, 68 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 67 => 0x7c, 68 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 67 => 0x4c, 68 => 0x4c },
	'sharpnessovershoot' => { 438 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 67 => 0x1c, 68 => 0x1c },
	'sharpnesssetting' => { 282 => 0x506, 290 => 0x1013, 394 => 0x12, 410 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 67 => 0x4, 68 => 0x4 },
	'sharpnessstrength' => { 99 => 0x20311 },
	'sharpnessthreshold' => { 438 => 0x801d },
	'sharpnessundershoot' => { 438 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 67 => 0x94, 68 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 67 => 0xac, 68 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 67 => 0xc4, 68 => 0xdc },
	'shiftcols' => { 133 => 0xc70 },
	'shootid' => { 475 => 'shootID' },
	'shootingdistance' => { 99 => 0x20701 },
	'shootinginfodisplay' => { 265 => '13.2', 266 => '5.1', 274 => '10.2', 275 => '4.1', 278 => '5.1', 280 => '5.3' },
	'shootinginfomonitorofftime' => { 265 => '26.2', 266 => '22.2', 268 => '22.2', 269 => '22.2', 273 => '21.2', 274 => '9.1', 275 => '21.2', 278 => '22.2', 279 => '22.2', 280 => '22.2' },
	'shootingmode' => { 151 => 'ShootingMode', 218 => 0x89, 305 => 0x1f },
	'shootingmodesetting' => { 267 => '5.1' },
	'shortdescription' => { 464 => 'shortdescription' },
	'shortdocumentid' => { 127 => 0xba },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 80 => 0x80d },
	'shorttitle' => { 357 => '@sti' },
	'shotdate' => { 486 => 'shotDate' },
	'shotday' => { 486 => 'shotDay' },
	'shotlocation' => { 486 => 'shotLocation' },
	'shotname' => { 365 => 'shot', 486 => 'shotName' },
	'shotnumber' => { 486 => 'shotNumber' },
	'shotnumbersincepowerup' => { 409 => 0x44e, 425 => 0x1a, 426 => 0x16, 427 => 0xa },
	'shotnumbersincepowerup2' => { 394 => 0x200 },
	'shotsize' => { 486 => 'shotSize' },
	'shownevent' => { 472 => 'EventExt' },
	'showneventidentifier' => { 472 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 472 => [\'EventExt','EventExtName'] },
	'shutter' => { 423 => 0x20, 424 => 0x26 },
	'shutter-aelock' => { 78 => 0x4, 80 => 0x701, 81 => 0x3, 82 => 0x4, 83 => 0x3, 84 => 0x3, 85 => 0x4, 86 => 0x2 },
	'shutteraelbutton' => { 79 => 0x4 },
	'shutterbuttonafonbutton' => { 80 => 0x701 },
	'shuttercount' => { 11 => 0x176, 55 => 0x1, 218 => 0xa7, 227 => [0x6a,0x157,0x24d], 228 => 0x286, 229 => 0x279, 230 => 0x284, 231 => 0x242, 232 => 0x280, 233 => 0x276, 234 => [0x27d,0x27f], 235 => 0x246, 238 => 0x2d6, 239 => 0x321, 240 => 0xbd8, 241 => 0x287, 242 => 0x320, 243 => 0x24a, 244 => 0x5fb, 247 => 0x2d5, 340 => 0x5d, 403 => 0x846, 408 => [0x125,0x14a], 423 => 0x32, 424 => 0x3a },
	'shuttercount2' => { 423 => 0x4c, 424 => [0x50,0x52,0x58] },
	'shuttercount3' => { 423 => [0x1a0,0x1aa,0x1bd], 424 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 78 => 0xf, 79 => 0xf, 80 => 0x305, 81 => 0xe, 82 => 0xf, 83 => 0x8, 84 => 0x8, 85 => 0xf, 86 => 0x8 },
	'shuttermode' => { 135 => 0x1b, 218 => 0x34 },
	'shutterreleasebuttonae-l' => { 265 => '17.7', 266 => '18.4', 268 => '78.4', 269 => '78.4', 270 => '16.1', 271 => '17.1', 272 => '17.1', 273 => '17.1', 274 => '7.1', 275 => '17.5', 278 => '18.4', 279 => '78.4', 280 => '18.2' },
	'shutterreleasemethod' => { 93 => 0x1010 },
	'shutterreleasenocfcard' => { 78 => 0x2, 79 => 0x2, 86 => 0xf },
	'shutterreleasetiming' => { 93 => 0x1011 },
	'shutterreleasewithoutlens' => { 80 => 0x711 },
	'shutterspeedlock' => { 266 => '38.1', 268 => '38.1', 269 => '38.1', 278 => '38.1', 279 => '38.1' },
	'shutterspeedrange' => { 80 => 0x10c },
	'shutterspeedsetting' => { 178 => 0x6, 392 => 0x2f, 393 => 0x28, 394 => 0x0 },
	'shutterspeedvalue' => { 89 => 0x1, 115 => 0x9201, 287 => 0x1000, 349 => 0x400, 466 => 'ShutterSpeedValue' },
	'shuttertype' => { 123 => 0x1050, 305 => 0x9f },
	'sidecarforextension' => { 474 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 133 => 0xe0d },
	'sigmascalingfactorcamera' => { 133 => 0xe0c },
	'sigmascalingfactorlowres' => { 133 => 0xe0b },
	'sigmasizetable' => { 133 => 0xe0f },
	'similarityindex' => { 127 => 0xe4 },
	'singleframebracketing' => { 178 => 0x21 },
	'skilllevel' => { 478 => 'skillLevel' },
	'skintonecorrection' => { 340 => 0x95 },
	'skiplinetime' => { 133 => 0x184e },
	'slaveflashmeteringsegments' => { 340 => 0x20b },
	'slideshowname' => { 475 => 'slideshowName' },
	'slideshownumber' => { 475 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 475 => 'slideshowTotalNumber' },
	'slowshutter' => { 74 => 0x8 },
	'slowsync' => { 123 => 0x1030 },
	'smartalbumcolor' => { 379 => 0x20 },
	'smartrange' => { 379 => 0xa012 },
	'smileshutter' => { 394 => 0x31 },
	'smileshuttermode' => { 394 => 0x27 },
	'smoothness' => { 115 => 0xfe57, 460 => 'Smoothness', 462 => 'Smoothness' },
	'snapshot' => { 472 => 'SnapshotLink' },
	'snapshotformat' => { 472 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 472 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 472 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 472 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 472 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 455 => 'Snapshots' },
	'snapshotusedvideoframe' => { 472 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 472 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 472 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 472 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 472 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 405 => 0x200f },
	'software' => { 115 => 0x131, 152 => 'Software', 295 => 'Software', 349 => 0x203, 359 => 'software', 382 => 0x18, 445 => 'Software', 482 => 'Software' },
	'softwareversion' => { 365 => "\xa9swr", 381 => 0x207 },
	'songwriter' => { 365 => "\xa9swf" },
	'songwriterkeywords' => { 365 => "\xa9swk" },
	'sonycropsize' => { 115 => 0x74c8 },
	'sonycroptopleft' => { 115 => 0x74c7 },
	'sonydatetime' => { 412 => 0x6, 414 => 0x1b6, 415 => 0x210, 416 => 0x1fe, 417 => 0x22c },
	'sonydatetime2' => { 423 => 0x51 },
	'sonyexposuretime' => { 423 => 0x3a, 424 => 0x46 },
	'sonyexposuretime2' => { 434 => 0xe },
	'sonyfnumber' => { 423 => 0x3c, 424 => 0x48, 434 => 0x14 },
	'sonyimageheight' => { 412 => 0x1a, 425 => 0x44, 426 => 0x3f, 427 => 0x47 },
	'sonyimageheightmax' => { 434 => 0x40 },
	'sonyimagesize' => { 178 => 0x3b, 392 => 0x54, 393 => 0x54, 394 => 0x9 },
	'sonyimagewidth' => { 412 => 0x1c },
	'sonyimagewidthmax' => { 434 => 0x3e },
	'sonyiso' => { 414 => 0x1218, 415 => 0x11f4, 416 => 0x1270, 417 => [0x1254,0x1258,0x1280], 418 => 0x113c, 419 => 0x344, 420 => 0x346, 421 => 0x320, 434 => 0x4 },
	'sonymaxaperture' => { 423 => 0x0, 424 => 0x0 },
	'sonymaxaperturevalue' => { 434 => 0x16 },
	'sonyminaperture' => { 423 => 0x1, 424 => 0x1 },
	'sonymodelid' => { 405 => 0xb001 },
	'sonyquality' => { 178 => 0x3c },
	'sonytimeminsec' => { 424 => 0x61 },
	'sortalbum' => { 357 => 'soal' },
	'sortalbumartist' => { 357 => 'soaa' },
	'sortartist' => { 357 => 'soar' },
	'sortcomposer' => { 357 => 'soco' },
	'sortname' => { 357 => 'sonm' },
	'sortshow' => { 357 => 'sosn' },
	'source' => { 127 => 0x73, 295 => 'Source', 463 => 'source', 464 => 'source', 474 => 'Source' },
	'sourcecount' => { 449 => 'SourceCount' },
	'sourcecredits' => { 365 => "\xa9src" },
	'sourcedirectoryindex' => { 327 => 0x0 },
	'sourcefileindex' => { 327 => 0x2 },
	'sourcephotoscount' => { 448 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 133 => 0x1390 },
	'spatialfrequencyresponse' => { 466 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 466 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 466 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 466 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 466 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 486 => 'speakerPlacement' },
	'specialeffectlevel' => { 109 => 0x3030 },
	'specialeffectmode' => { 109 => 0x2076 },
	'specialeffectsetting' => { 109 => 0x3031 },
	'specialinstructions' => { 127 => 0x28 },
	'specialmode' => { 287 => 0x200, 381 => 0x200 },
	'specialoccasion' => { 478 => 'specialOccasion' },
	'specialtypeid' => { 443 => 'SpecialTypeID' },
	'spectralsensitivity' => { 115 => 0x8824, 466 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 43 => [0x2b9,0x2d0,0x2d4], 44 => 0x56a, 45 => 0x1e4, 46 => [0x1fd,0x2dd], 47 => [0x231,0x30f], 48 => 0x31d },
	'speedx' => { 111 => 0x3, 365 => "\xa9xsp" },
	'speedy' => { 111 => 0x4, 365 => "\xa9ysp" },
	'speedz' => { 111 => 0x5, 365 => "\xa9zsp" },
	'spherical' => { 449 => 'Spherical' },
	'splitcolumn' => { 349 => 0x222 },
	'splittoningbalance' => { 460 => 'SplitToningBalance', 462 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 460 => 'SplitToningHighlightHue', 462 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 460 => 'SplitToningHighlightSaturation', 462 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 460 => 'SplitToningShadowHue', 462 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 460 => 'SplitToningShadowSaturation', 462 => 'SplitToningShadowSaturation' },
	'sport' => { 476 => 'sport' },
	'spotfocuspointx' => { 175 => 0x2d },
	'spotfocuspointy' => { 175 => 0x2e },
	'spotmeteringmode' => { 34 => 0x27 },
	'spotmeterlinktoafpoint' => { 80 => 0x107 },
	'sractive' => { 321 => '17.1' },
	'srawquality' => { 34 => 0x2e },
	'srfocallength' => { 342 => 0x3 },
	'srhalfpresstime' => { 342 => 0x2 },
	'srresult' => { 342 => 0x0, 343 => 0x0 },
	'stackedimage' => { 282 => 0x804 },
	'standardmatrixcustom' => { 133 => 0x7d4 },
	'standardmatrixdaylight' => { 133 => 0x7d0 },
	'standardmatrixflash' => { 133 => 0x7d3 },
	'standardmatrixfluorescent' => { 133 => 0x7d2 },
	'standardmatrixtungsten' => { 133 => 0x7d1 },
	'standardoutputhighlightpoint' => { 105 => 0x14 },
	'standardoutputsensitivity' => { 115 => 0x8831, 467 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 105 => 0x15 },
	'standardrawcolortone' => { 105 => 0xd },
	'standardrawcontrast' => { 105 => 0xf },
	'standardrawhighlight' => { 105 => 0x75 },
	'standardrawhighlightpoint' => { 105 => 0x12 },
	'standardrawlinear' => { 105 => 0x10 },
	'standardrawsaturation' => { 105 => 0xe },
	'standardrawshadow' => { 105 => 0x7e },
	'standardrawshadowpoint' => { 105 => 0x13 },
	'standardrawsharpness' => { 105 => 0x11 },
	'standardunsharpmaskfineness' => { 105 => 0x94 },
	'standardunsharpmaskstrength' => { 105 => 0x92 },
	'standardunsharpmaskthreshold' => { 105 => 0x96 },
	'standardwhitecustom' => { 133 => 0x838 },
	'standardwhitedaylight' => { 133 => 0x834 },
	'standardwhiteflash' => { 133 => 0x837 },
	'standardwhitefluorescent' => { 133 => 0x836 },
	'standardwhitetungsten' => { 133 => 0x835 },
	'standbytimer' => { 266 => '19.1', 268 => '19.1', 269 => '19.1', 272 => '18.1', 273 => '18.1', 278 => '19.1', 279 => '19.1' },
	'startingpage' => { 476 => 'startingPage' },
	'startmovieshooting' => { 80 => 0x70d },
	'starttimecode' => { 365 => "\xa9TIM", 486 => 'startTimecode' },
	'starttimecodetimeformat' => { 486 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 486 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 486 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 365 => "\xa9TSZ", 486 => 'startTimeSampleSize' },
	'starttimescale' => { 365 => "\xa9TSC", 486 => 'startTimeScale' },
	'state' => { 156 => 'State', 305 => 0x6b, 474 => 'State' },
	'status' => { 441 => 'Status', 453 => 'Status' },
	'stereomode' => { 449 => 'StereoMode' },
	'stitched' => { 449 => 'Stitched' },
	'stitchingsoftware' => { 448 => 'StitchingSoftware', 449 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 413 => 0x113e, 414 => 0x113e, 415 => 0x111a, 416 => 0x1196, 417 => 0x1172, 418 => 0x102a, 419 => 0x222, 420 => 0x222, 421 => 0x217, 434 => 0xa },
	'storagemethod' => { 182 => 0x12 },
	'storebyorientation' => { 266 => '46.3', 268 => '47.3', 269 => '47.3', 278 => '47.3', 279 => '47.3' },
	'storylineidentifier' => { 472 => 'StorylineIdentifier' },
	'straightenangle' => { 258 => 0x2fc08431 },
	'streamready' => { 472 => 'StreamReady' },
	'streamtype' => { 171 => 'StreamType' },
	'stretchmode' => { 486 => 'stretchMode' },
	'studydatetime' => { 440 => 'StudyDateTime' },
	'studydescription' => { 440 => 'StudyDescription' },
	'studyid' => { 440 => 'StudyID' },
	'studyphysician' => { 440 => 'StudyPhysician' },
	'styleperiod' => { 472 => 'StylePeriod' },
	'sub-location' => { 127 => 0x5c },
	'subfiledata' => { 159 => 'data' },
	'subfiledirectory' => { 159 => '1Directory' },
	'subfilemimetype' => { 159 => '2MIME' },
	'subfilename' => { 159 => '1Name' },
	'subfileresource' => { 159 => 'rsrc' },
	'subfiletype' => { 115 => 0xfe, 159 => '0Type' },
	'subject' => { 291 => 'Subject', 356 => 'Subject', 463 => 'subject', 473 => 'Subject', 487 => 'subject' },
	'subjectarea' => { 115 => 0x9214, 466 => 'SubjectArea' },
	'subjectcode' => { 471 => 'SubjectCode' },
	'subjectdistance' => { 115 => 0x9206, 135 => 0x3e, 466 => 'SubjectDistance' },
	'subjectdistancerange' => { 115 => 0xa40c, 466 => 'SubjectDistanceRange' },
	'subjectlocation' => { 115 => 0xa214, 466 => 'SubjectLocation' },
	'subjectmotion' => { 268 => '78.2', 269 => '78.2', 279 => '78.2' },
	'subjectprogram' => { 175 => 0x22 },
	'subjectreference' => { 127 => 0xc },
	'sublabels1' => { 470 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 470 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 470 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 470 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 470 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 110 => 'Exif::SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 110 => 'Exif::SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 110 => 'Exif::SubSecModifyDate' },
	'subsectime' => { 115 => 0x9290 },
	'subsectimedigitized' => { 115 => 0x9292 },
	'subsectimeoriginal' => { 115 => 0x9291 },
	'subsection1' => { 476 => 'subsection1' },
	'subsection2' => { 476 => 'subsection2' },
	'subsection3' => { 476 => 'subsection3' },
	'subsection4' => { 476 => 'subsection4' },
	'subselector' => { 266 => '49.1', 268 => '71.1', 269 => '71.1', 279 => '71.1' },
	'subselectorassignment' => { 266 => '48.1' },
	'subselectorcenter' => { 268 => '72.1', 269 => '72.1', 279 => '72.1' },
	'subselectorplusdials' => { 266 => '49.2', 268 => '73.1', 269 => '73.1', 279 => '73.1' },
	'subtitle' => { 365 => "\xa9snm", 476 => 'subtitle' },
	'subtitlekeywords' => { 365 => "\xa9snk" },
	'subversionfilename' => { 470 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 470 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 470 => 'SubVersions' },
	'superimposeddisplay' => { 78 => 0xa, 80 => 0x510, 81 => 0x9, 82 => 0xa, 85 => 0xa, 86 => 0xe },
	'supermacro' => { 61 => 0x1a },
	'supplementalcategories' => { 127 => 0x14, 474 => 'SupplementalCategories' },
	'supplementaltype' => { 129 => 0x37 },
	'supplementdisplayid' => { 476 => 'supplementDisplayID' },
	'supplementstartingpage' => { 476 => 'supplementStartingPage' },
	'supplementtitle' => { 476 => 'supplementTitle' },
	'supplychainsource' => { 472 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 472 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 472 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'svisosetting' => { 321 => 0x14 },
	'swatchcoloranta' => { 491 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 491 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 491 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 491 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 491 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 491 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 491 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 491 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 491 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 491 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 491 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 491 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 491 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 491 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 491 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 491 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 491 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 491 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 491 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 305 => 0x93, 394 => 0x33 },
	'sweeppanoramafieldofview' => { 305 => 0x94 },
	'sweeppanoramasize' => { 394 => 0x32 },
	'switchtoregisteredafpoint' => { 79 => 0x12, 80 => 0x50a },
	'symlink' => { 116 => 'SymLink' },
	'syncreleasemode' => { 268 => '77.1', 269 => '77.1', 279 => '77.1' },
	'system' => { 349 => 0x204 },
	'tagged' => { 351 => 0xdd, 352 => 'Tagged', 455 => 'tagged' },
	'tagslist' => { 465 => 'TagsList' },
	'tagstructure' => { 470 => 'TagStructure' },
	'takenumber' => { 486 => 'takeNumber' },
	'tapename' => { 486 => 'tapeName' },
	'targetaperture' => { 74 => 0x4 },
	'targetcompressionratio' => { 91 => 0x1 },
	'targetdistancesetting' => { 93 => 0x1807 },
	'targetexposuretime' => { 74 => 0x5 },
	'targetimagetype' => { 93 => 0x100a },
	'targetprinter' => { 115 => 0x151 },
	'taxon' => { 114 => 'Taxon' },
	'taxonacceptednameusage' => { 114 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 114 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 114 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 114 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 114 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 114 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 114 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 114 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 114 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 114 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 114 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 114 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 114 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 114 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 114 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 114 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 114 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 114 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 114 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 114 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 114 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 114 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 114 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 114 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 114 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 114 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 114 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 114 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 114 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 114 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 114 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 114 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 114 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 133 => 0x196f },
	'tda1edgepolarity' => { 133 => 0x1971 },
	'tda1gain' => { 133 => 0x1970 },
	'tda1offset' => { 133 => 0x196e },
	'tda2bandwidth' => { 133 => 0x1979 },
	'tda2edgepolarity' => { 133 => 0x197b },
	'tda2gain' => { 133 => 0x197a },
	'tda2offset' => { 133 => 0x1978 },
	'tda3bandwidth' => { 133 => 0x1983 },
	'tda3edgepolarity' => { 133 => 0x1985 },
	'tda3gain' => { 133 => 0x1984 },
	'tda3offset' => { 133 => 0x1982 },
	'tda4bandwidth' => { 133 => 0x198d },
	'tda4edgepolarity' => { 133 => 0x198f },
	'tda4gain' => { 133 => 0x198e },
	'tda4offset' => { 133 => 0x198c },
	'teaser' => { 476 => 'teaser' },
	'teleconverter' => { 180 => 0x105, 405 => 0x105 },
	'tempampgainx100' => { 133 => 0x1914 },
	'tempo' => { 486 => 'tempo' },
	'temporalcoverage' => { 472 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 472 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 472 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 292 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 292 => 'TermsAndConditionsURL' },
	'testname' => { 116 => 'TestName' },
	'textencoding' => { 217 => 0x4 },
	'textlayername' => { 474 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 474 => 'TextLayers' },
	'textlayertext' => { 474 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 305 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 460 => 'Texture', 462 => 'Texture' },
	'three-dtrackingfacedetection' => { 268 => '1.4', 269 => '1.4', 279 => '1.4' },
	'three-dtrackingwatcharea' => { 268 => '78.1', 269 => '78.1', 279 => '78.1' },
	'thresholding' => { 115 => 0x107 },
	'thumbnailfilename' => { 93 => 0x817 },
	'thumbnailformat' => { 484 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 137 => 0xfa55, 484 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 93 => 0x2008, 110 => 'Exif::ThumbnailImage', 118 => 0x3, 162 => 'data', 287 => 0x100, 365 => 'thmb', 484 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 162 => '1Name' },
	'thumbnailimagesize' => { 162 => 'ImageSize' },
	'thumbnailimagetype' => { 162 => '0Type' },
	'thumbnailimagevalidarea' => { 61 => 0x13 },
	'thumbnaillength' => { 115 => 0x202 },
	'thumbnailoffset' => { 115 => 0x201 },
	'thumbnailpng' => { 365 => 'thmb' },
	'thumbnails' => { 484 => 'Thumbnails' },
	'thumbnailwidth' => { 137 => 0xfa54, 484 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 476 => 'ticker' },
	'tiffhandling' => { 460 => 'TIFFHandling', 462 => 'TIFFHandling' },
	'tiffmeteringimage' => { 181 => 0x104c, 403 => 0x1110 },
	'tilelength' => { 115 => 0x143 },
	'tilewidth' => { 115 => 0x142 },
	'time' => { 133 => 0x401, 340 => 0x7 },
	'timecodes' => { 115 => 0xc763 },
	'timecreated' => { 127 => 0x3c, 135 => 0x14, 144 => 0x10, 352 => 'TimeCreated' },
	'timelapseshotnumber' => { 308 => 0x10 },
	'timeperiod' => { 476 => 'timePeriod' },
	'timerfunctionbutton' => { 267 => '5.2', 270 => '12.1', 271 => '13.1' },
	'timerlength' => { 80 => 0x80c },
	'timerrecording' => { 305 => 0x96 },
	'timescaleparams' => { 486 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 486 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 486 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 486 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 128 => 0x50 },
	'timeshot' => { 450 => 'TimeShot' },
	'timesignature' => { 486 => 'timeSignature' },
	'timesincepoweron' => { 305 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 281 => 0x8, 295 => 'TimeStamp', 305 => 0xaf, 449 => 'Timestamp', 456 => 'Timestamp', 470 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 75 => 0x1, 250 => 0x0, 375 => 0xa },
	'timezonecity' => { 75 => 0x2 },
	'timezonecode' => { 96 => 0x1 },
	'timezoneinfo' => { 96 => 0x2 },
	'timezoneoffset' => { 115 => 0x882a },
	'tint' => { 359 => 'player.movie.visual.tint', 460 => 'Tint', 462 => 'Tint' },
	'title' => { 152 => 'Title', 291 => 'Title', 295 => 'Title', 305 => 0x65, 356 => 'Title', 357 => ['titl',"\xa9nam"], 359 => 'title', 365 => ['titl',"\xa9nam"], 463 => 'title', 473 => 'Title', 484 => 'Title' },
	'tonecomp' => { 218 => 0x81 },
	'tonecurve' => { 71 => 0x1, 340 => 0x402, 460 => 'ToneCurve', 462 => 'ToneCurve' },
	'tonecurveactive' => { 104 => 0x110 },
	'tonecurveadobergb' => { 379 => 0xa043 },
	'tonecurveadobergbdefault' => { 379 => 0xa041 },
	'tonecurveblue' => { 460 => 'ToneCurveBlue', 462 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 438 => 0x9003 },
	'tonecurvebluey' => { 438 => 0x9007 },
	'tonecurvebrightness' => { 99 => 0x20410 },
	'tonecurvebrightnessx' => { 438 => 0x9000 },
	'tonecurvebrightnessy' => { 438 => 0x9004 },
	'tonecurvecolorspace' => { 103 => 0x0 },
	'tonecurvecontrast' => { 99 => 0x20411 },
	'tonecurvegreen' => { 460 => 'ToneCurveGreen', 462 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 438 => 0x9002 },
	'tonecurvegreeny' => { 438 => 0x9006 },
	'tonecurveinputrange' => { 103 => 0x3 },
	'tonecurveinterpolation' => { 104 => 0x159 },
	'tonecurvemode' => { 104 => 0x113 },
	'tonecurvename' => { 460 => 'ToneCurveName', 462 => 'ToneCurveName' },
	'tonecurvename2012' => { 460 => 'ToneCurveName2012', 462 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 99 => '0x20400.1' },
	'tonecurveoutputrange' => { 103 => 0x5 },
	'tonecurveprofilename' => { 133 => 0x1391 },
	'tonecurveproperty' => { 104 => 0x3c },
	'tonecurvepv2012' => { 460 => 'ToneCurvePV2012', 462 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 460 => 'ToneCurvePV2012Blue', 462 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 460 => 'ToneCurvePV2012Green', 462 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 460 => 'ToneCurvePV2012Red', 462 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 460 => 'ToneCurveRed', 462 => 'ToneCurveRed' },
	'tonecurveredx' => { 438 => 0x9001 },
	'tonecurveredy' => { 438 => 0x9005 },
	'tonecurves' => { 340 => 0x403 },
	'tonecurveshape' => { 103 => 0x1 },
	'tonecurvesrgb' => { 379 => 0xa042 },
	'tonecurvesrgbdefault' => { 379 => 0xa040 },
	'tonecurvex' => { 103 => 0xa },
	'tonecurvey' => { 103 => 0xb },
	'tonelevel' => { 282 => 0x52e },
	'tonemapstrength' => { 460 => 'ToneMapStrength', 462 => 'ToneMapStrength' },
	'toningeffect' => { 55 => 0xf, 218 => 0xb3, 220 => 0x38, 221 => 0x40, 222 => 0x48, 372 => 0x1015 },
	'toningeffectauto' => { 68 => 0xa4 },
	'toningeffectfaithful' => { 67 => 0x74, 68 => 0x74 },
	'toningeffectlandscape' => { 67 => 0x44, 68 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 67 => 0x8c, 68 => 0x8c },
	'toningeffectneutral' => { 67 => 0x5c, 68 => 0x5c },
	'toningeffectportrait' => { 67 => 0x2c, 68 => 0x2c },
	'toningeffectstandard' => { 67 => 0x14, 68 => 0x14 },
	'toningeffectuserdef1' => { 67 => 0xa4, 68 => 0xbc },
	'toningeffectuserdef2' => { 67 => 0xbc, 68 => 0xd4 },
	'toningeffectuserdef3' => { 67 => 0xd4, 68 => 0xec },
	'toningsaturation' => { 220 => 0x39, 221 => 0x41, 222 => 0x49 },
	'totalzoom' => { 135 => 0x62 },
	'touchae' => { 305 => 0xab },
	'track' => { 357 => "\xa9trk", 365 => "\xa9trk" },
	'trackcreatedate' => { 364 => 0x1 },
	'trackmodifydate' => { 364 => 0x2 },
	'tracknumber' => { 357 => 'trkn', 486 => 'trackNumber' },
	'tracks' => { 486 => 'Tracks' },
	'tracksframerate' => { 486 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 486 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 486 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 486 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 486 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 486 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 486 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 486 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 486 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 486 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 486 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 486 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 486 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 486 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 486 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 486 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 486 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 365 => 'kgtt' },
	'trailersignature' => { 159 => 'zmie' },
	'transcript' => { 472 => 'Transcript' },
	'transcriptlink' => { 472 => 'TranscriptLink' },
	'transcriptlinklink' => { 472 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 472 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 115 => 0x12d, 482 => 'TransferFunction' },
	'transfertimenormal' => { 133 => 0x1888 },
	'transfertimetest' => { 133 => 0x1889 },
	'transform' => { 305 => [0x8012,0x59] },
	'transmissionreference' => { 474 => 'TransmissionReference' },
	'trapped' => { 291 => 'Trapped', 473 => 'Trapped' },
	'trashbuttonfunction' => { 80 => 0x710 },
	'travelday' => { 305 => 0x36 },
	'trebel' => { 359 => 'player.movie.audio.treble' },
	'triggermode' => { 366 => 0x6, 367 => 0x34, 368 => 0x34 },
	'tstop' => { 115 => 0xc772 },
	'ttl_da_adown' => { 328 => 0x5 },
	'ttl_da_aup' => { 328 => 0x4 },
	'ttl_da_bdown' => { 328 => 0x7 },
	'ttl_da_bup' => { 328 => 0x6 },
	'tungstenawb' => { 318 => 0x1 },
	'tvepisode' => { 357 => 'tves' },
	'tvepisodeid' => { 357 => 'tven' },
	'tvexposuretimesetting' => { 321 => 0x12 },
	'tvnetworkname' => { 357 => 'tvnn' },
	'tvseason' => { 357 => 'tvsn' },
	'tvshow' => { 357 => 'tvsh' },
	'type' => { 463 => 'type', 481 => 'type' },
	'typestatus' => { 114 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 115 => 0xc614 },
	'uniquedocumentid' => { 127 => 0xbb },
	'uniquematrixauto' => { 133 => 0x7e9 },
	'uniquematrixcustom' => { 133 => 0x7e8 },
	'uniquematrixdaylight' => { 133 => 0x7e4 },
	'uniquematrixflash' => { 133 => 0x7e7 },
	'uniquematrixfluorescent' => { 133 => 0x7e6 },
	'uniquematrixtungsten' => { 133 => 0x7e5 },
	'uniqueobjectname' => { 128 => 0x64 },
	'units' => { 445 => 'Units' },
	'unknown_aacr' => { 357 => 'AACR' },
	'unknown_cdek' => { 357 => 'CDEK' },
	'unknown_cdet' => { 357 => 'CDET' },
	'unknownblock' => { 340 => 0x405 },
	'unknownblock1' => { 286 => 0x635 },
	'unknownblock2' => { 286 => 0x636 },
	'unknownblock3' => { 286 => 0x1103 },
	'unknownblock4' => { 286 => 0x1104 },
	'unknowncontrast' => { 105 => 0x45 },
	'unknowndate' => { 349 => 0x212 },
	'unknownev' => { 133 => 0x1 },
	'unknownlinear' => { 105 => 0x46 },
	'unknownnumber' => { 93 => 0x180b },
	'unknownoutputhighlightpoint' => { 105 => 0x4a },
	'unknownoutputshadowpoint' => { 105 => 0x4b },
	'unknownrawhighlight' => { 105 => 0x7b },
	'unknownrawhighlightpoint' => { 105 => 0x48 },
	'unknownrawshadow' => { 105 => 0x84 },
	'unknownrawshadowpoint' => { 105 => 0x49 },
	'unknownsharpness' => { 105 => 0x47 },
	'unknowntags' => { 365 => 'TAGS' },
	'unknowntemperature' => { 117 => 0x4 },
	'unknownthumbnail' => { 365 => 'thmb' },
	'unsharp1color' => { 263 => 0x13 },
	'unsharp1halowidth' => { 263 => 0x19 },
	'unsharp1intensity' => { 263 => 0x17 },
	'unsharp1threshold' => { 263 => 0x1b },
	'unsharp2color' => { 263 => 0x2e },
	'unsharp2halowidth' => { 263 => 0x34 },
	'unsharp2intensity' => { 263 => 0x32 },
	'unsharp2threshold' => { 263 => 0x36 },
	'unsharp3color' => { 263 => 0x49 },
	'unsharp3halowidth' => { 263 => 0x4f },
	'unsharp3intensity' => { 263 => 0x4d },
	'unsharp3threshold' => { 263 => 0x51 },
	'unsharp4color' => { 263 => 0x64 },
	'unsharp4halowidth' => { 263 => 0x6a },
	'unsharp4intensity' => { 263 => 0x68 },
	'unsharp4threshold' => { 263 => 0x6c },
	'unsharpcount' => { 263 => 0x0 },
	'unsharpmask' => { 105 => 0x90, 258 => 0x76a43200 },
	'unsharpmaskfineness' => { 99 => 0x20309 },
	'unsharpmaskstrength' => { 99 => 0x20308 },
	'unsharpmaskthreshold' => { 99 => 0x2030a },
	'uprightcentermode' => { 460 => 'UprightCenterMode', 462 => 'UprightCenterMode' },
	'uprightcenternormx' => { 460 => 'UprightCenterNormX', 462 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 460 => 'UprightCenterNormY', 462 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 460 => 'UprightDependentDigest', 462 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 460 => 'UprightFocalLength35mm', 462 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 460 => 'UprightFocalMode', 462 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 460 => 'UprightFourSegmentsCount', 462 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 460 => 'UprightPreview', 462 => 'UprightPreview' },
	'uprighttransform_0' => { 460 => 'UprightTransform_0', 462 => 'UprightTransform_0' },
	'uprighttransform_1' => { 460 => 'UprightTransform_1', 462 => 'UprightTransform_1' },
	'uprighttransform_2' => { 460 => 'UprightTransform_2', 462 => 'UprightTransform_2' },
	'uprighttransform_3' => { 460 => 'UprightTransform_3', 462 => 'UprightTransform_3' },
	'uprighttransform_4' => { 460 => 'UprightTransform_4', 462 => 'UprightTransform_4' },
	'uprighttransform_5' => { 460 => 'UprightTransform_5', 462 => 'UprightTransform_5' },
	'uprighttransformcount' => { 460 => 'UprightTransformCount', 462 => 'UprightTransformCount' },
	'uprightversion' => { 460 => 'UprightVersion', 462 => 'UprightVersion' },
	'urgency' => { 127 => 0xa, 474 => 'Urgency' },
	'url' => { 152 => 'URL', 295 => 'URL', 354 => 0x40b, 476 => 'url' },
	'url_list' => { 354 => 0x41e },
	'urla-platform' => { 476 => [\'url','urlA-platform'] },
	'urlurl' => { 476 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 80 => 0x10a },
	'usableshootingmodes' => { 80 => 0x109 },
	'usage' => { 477 => 'usage' },
	'usageterms' => { 490 => 'UsageTerms' },
	'useguidelines' => { 458 => 'useGuidelines' },
	'usepanoramaviewer' => { 448 => 'UsePanoramaViewer' },
	'usercollection' => { 359 => 'collection.user' },
	'usercomment' => { 93 => 0x805, 115 => 0x9286, 466 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 67 => 0xd8, 68 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 67 => 0xda, 68 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 67 => 0xdc, 68 => 0xf4 },
	'userfields' => { 453 => 'UserFields' },
	'userlabel' => { 366 => 0x2b, 367 => 0x5a, 368 => 0x68 },
	'userprofile' => { 300 => 0x302, 307 => 0x3038 },
	'userrating' => { 359 => 'rating.user' },
	'usmlenselectronicmf' => { 2 => 0x7, 79 => 0x7, 80 => 0x501 },
	'uspsnumber' => { 476 => 'uspsNumber' },
	'utmeasting' => { 163 => 'Easting' },
	'utmmapdatum' => { 163 => 'Datum' },
	'utmnorthing' => { 163 => 'Northing' },
	'utmzone' => { 163 => 'Zone' },
	'uv-irfiltercorrection' => { 300 => 0x325 },
	'validbits' => { 286 => 0x611, 287 => 0x102c },
	'validpixeldepth' => { 290 => 0x611 },
	'variablelowpassfilter' => { 405 => 0x2028 },
	'variousmodes' => { 135 => 0x26 },
	'variousmodes2' => { 135 => 0x3a },
	'variprogram' => { 218 => 0xab },
	'varraydacnominalvalues' => { 133 => 0x191e },
	'vendor' => { 365 => 'vndr' },
	'version' => { 123 => 0x0, 356 => 'Version', 359 => 'version', 460 => 'Version', 462 => 'Version' },
	'versioncreatedate' => { 438 => 0xd100 },
	'versionid' => { 487 => 'VersionID' },
	'versionidentifier' => { 476 => 'versionIdentifier' },
	'versionmodifydate' => { 438 => 0xd101 },
	'versions' => { 487 => 'Versions' },
	'versionscomments' => { 487 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 487 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 487 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 487 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 487 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 487 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 487 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 487 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 487 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 487 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 487 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 265 => '3.2', 266 => '47.2', 268 => '79.1' },
	'verticalclockoverlaps' => { 133 => 0x412 },
	'verticalfuncbutton' => { 266 => '42.2', 268 => '67.1' },
	'verticalfuncbuttonplusdials' => { 266 => '43.1' },
	'verticalfuncplusdials' => { 268 => '68.1' },
	'verticalmultiselector' => { 266 => '42.1', 268 => '66.1', 269 => '66.1', 279 => '66.1' },
	'vfdisplayillumination' => { 2 => 0x11, 80 => [0x510,0x51d] },
	'vibrance' => { 454 => 'Vibrance', 460 => 'Vibrance', 462 => 'Vibrance' },
	'vibrationreduction' => { 227 => [0x75,0x82,0x1ae], 235 => '586.1', 243 => '590.2', 249 => 0x4 },
	'videoalphamode' => { 486 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 486 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 486 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 486 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 486 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 486 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 486 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 486 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 486 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 486 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 486 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 486 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 486 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 486 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 486 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 486 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 486 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 486 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 472 => 'videoBitRate' },
	'videobitratemode' => { 472 => 'videoBitRateMode' },
	'videoburstmode' => { 305 => 0xbb },
	'videocodec' => { 64 => 0x74 },
	'videocolorspace' => { 486 => 'videoColorSpace' },
	'videocompression' => { 123 => 0x3806 },
	'videocompressor' => { 486 => 'videoCompressor' },
	'videodisplayaspectratio' => { 472 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 472 => 'videoEncodingProfile' },
	'videofieldorder' => { 486 => 'videoFieldOrder' },
	'videoframerate' => { 486 => 'videoFrameRate' },
	'videoframesize' => { 486 => 'videoFrameSize' },
	'videoframesizeh' => { 486 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 486 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 486 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 486 => 'videoModDate' },
	'videopixelaspectratio' => { 486 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 486 => 'videoPixelDepth' },
	'videoquality' => { 109 => 0x4003 },
	'videorecordingmode' => { 123 => 0x3803 },
	'videoshottype' => { 472 => 'VideoShotType' },
	'videoshottypeidentifier' => { 472 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 472 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 472 => 'videoStreamsCount' },
	'viewfinder' => { 349 => 0x455 },
	'viewfinderdisplay' => { 265 => '12.4', 266 => '6.3' },
	'viewfinderwarning' => { 265 => '13.4', 275 => '3.5', 276 => '6.2', 280 => '4.4' },
	'viewfinderwarnings' => { 80 => 0x40a },
	'viewinfoduringexposure' => { 80 => 0x407 },
	'viewingmode' => { 394 => 0x2f, 410 => 0x18 },
	'viewingmode2' => { 394 => [0x85,0x285] },
	'viewpoint' => { 475 => 'viewpoint' },
	'vignetteamount' => { 460 => 'VignetteAmount', 462 => 'VignetteAmount' },
	'vignettecontrol' => { 218 => 0x2a, 258 => 0x76a43205 },
	'vignettecontrolintensity' => { 258 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 457 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 460 => 'VignetteMidpoint', 462 => 'VignetteMidpoint' },
	'vignetting' => { 372 => 0x1011, 379 => 0xa052 },
	'vignettingcorrection' => { 115 => 0x7031, 379 => 0xa053, 405 => 0x2011 },
	'vignettingcorrparams' => { 115 => 0x7032, 433 => 0x64a, 434 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 379 => 0xa054 },
	'visualcolor' => { 472 => 'VisualColour' },
	'visualtechnique' => { 475 => 'visualTechnique' },
	'voicememo' => { 381 => 0x216 },
	'volume' => { 476 => 'volume' },
	'vr_0x66' => { 227 => 0x66 },
	'vrdoffset' => { 61 => 0xd0 },
	'vrmode' => { 249 => 0x6 },
	'waterdepth' => { 115 => 0x9403, 467 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 181 => 0x19a },
	'wb_bluelevel6500k' => { 181 => 0x18a },
	'wb_bluelevelcustom' => { 181 => 0x18e },
	'wb_bluelevelscloudy' => { 181 => 0x106 },
	'wb_bluelevelsdaylight' => { 181 => 0xea },
	'wb_bluelevelsflash' => { 181 => 0x122 },
	'wb_bluelevelsfluorescent' => { 181 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 181 => 0x254 },
	'wb_bluelevelsshade' => { 181 => 0x176 },
	'wb_bluelevelstungsten' => { 181 => 0xce },
	'wb_gbrglevels' => { 181 => 0xae, 184 => 0x4 },
	'wb_glevel' => { 286 => 0x11f },
	'wb_glevel3000k' => { 286 => 0x113 },
	'wb_glevel3300k' => { 286 => 0x114 },
	'wb_glevel3600k' => { 286 => 0x115 },
	'wb_glevel3900k' => { 286 => 0x116 },
	'wb_glevel4000k' => { 286 => 0x117 },
	'wb_glevel4300k' => { 286 => 0x118 },
	'wb_glevel4500k' => { 286 => 0x119 },
	'wb_glevel4800k' => { 286 => 0x11a },
	'wb_glevel5300k' => { 286 => 0x11b },
	'wb_glevel6000k' => { 286 => 0x11c },
	'wb_glevel6600k' => { 286 => 0x11d },
	'wb_glevel7500k' => { 286 => 0x11e },
	'wb_grbglevels' => { 194 => 0x0 },
	'wb_rbgglevels' => { 191 => 0x0 },
	'wb_rblevels' => { 195 => 0x270, 218 => 0xc, 286 => 0x100 },
	'wb_rblevels1' => { 311 => 0x2 },
	'wb_rblevels2' => { 311 => 0x5 },
	'wb_rblevels3' => { 311 => 0x8 },
	'wb_rblevels3000k' => { 286 => 0x102 },
	'wb_rblevels3300k' => { 286 => 0x103 },
	'wb_rblevels3500k' => { 181 => 0x430 },
	'wb_rblevels3600k' => { 286 => 0x104 },
	'wb_rblevels3900k' => { 286 => 0x105 },
	'wb_rblevels4' => { 311 => 0xb },
	'wb_rblevels4000k' => { 286 => 0x106 },
	'wb_rblevels4300k' => { 286 => 0x107 },
	'wb_rblevels4500k' => { 286 => 0x108 },
	'wb_rblevels4800k' => { 286 => 0x109 },
	'wb_rblevels5' => { 311 => 0xe },
	'wb_rblevels5300k' => { 286 => 0x10a },
	'wb_rblevels6' => { 311 => 0x11 },
	'wb_rblevels6000k' => { 286 => 0x10b },
	'wb_rblevels6500k' => { 181 => 0x420 },
	'wb_rblevels6600k' => { 286 => 0x10c },
	'wb_rblevels7' => { 311 => 0x14 },
	'wb_rblevels7500k' => { 286 => 0x10d },
	'wb_rblevelsauto' => { 195 => 0x272, 290 => 0x110 },
	'wb_rblevelscloudy' => { 181 => 0x3f0, 183 => 0x10, 195 => 0x296, 290 => 0x121 },
	'wb_rblevelscoolwhitef' => { 181 => 0x308, 183 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 290 => 0x132 },
	'wb_rblevelscustom' => { 181 => 0x424 },
	'wb_rblevelscwb1' => { 286 => 0x10e },
	'wb_rblevelscwb2' => { 286 => 0x10f },
	'wb_rblevelscwb3' => { 286 => 0x110 },
	'wb_rblevelscwb4' => { 286 => 0x111 },
	'wb_rblevelsdaylight' => { 181 => [0x3ec,0x528], 183 => 0xc, 195 => 0x274 },
	'wb_rblevelsdaylightf' => { 183 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 290 => 0x130 },
	'wb_rblevelsdaywhitef' => { 183 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 290 => 0x131 },
	'wb_rblevelseveningsunlight' => { 290 => 0x124 },
	'wb_rblevelsfineweather' => { 290 => 0x122 },
	'wb_rblevelsflash' => { 181 => [0x3f4,0x304], 183 => 0x18, 195 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 195 => 0x290 },
	'wb_rblevelsincandescent' => { 195 => 0x282 },
	'wb_rblevelsshade' => { 181 => 0x418, 183 => 0x20, 195 => 0x2b2, 290 => 0x120 },
	'wb_rblevelstungsten' => { 181 => 0x3e8, 183 => 0x8, 290 => 0x123 },
	'wb_rblevelsunknown' => { 183 => 0x1c },
	'wb_rblevelsused' => { 290 => 0x100 },
	'wb_rblevelswhitef' => { 183 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 290 => 0x133 },
	'wb_redlevel3500k' => { 181 => 0x198 },
	'wb_redlevel6500k' => { 181 => 0x188 },
	'wb_redlevelcustom' => { 181 => 0x18c },
	'wb_redlevelscloudy' => { 181 => 0xf8 },
	'wb_redlevelsdaylight' => { 181 => 0xdc },
	'wb_redlevelsflash' => { 181 => 0x114 },
	'wb_redlevelsfluorescent' => { 181 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 181 => 0x1be },
	'wb_redlevelsshade' => { 181 => 0x168 },
	'wb_redlevelstungsten' => { 181 => 0xc0 },
	'wb_rgbglevels' => { 193 => 0x0 },
	'wb_rgblevels' => { 181 => [0x546,0x96], 301 => 0xd, 302 => 0x413, 307 => 0x3036, 349 => 0x107, 413 => 0x117c, 414 => 0x1180, 415 => 0x115c, 416 => 0x11d8, 417 => 0x11b4, 418 => 0x106c, 419 => 0x264, 420 => 0x264, 421 => 0x252 },
	'wb_rgblevels1' => { 312 => 0x2 },
	'wb_rgblevels2' => { 312 => 0x6 },
	'wb_rgblevels3' => { 312 => 0xa },
	'wb_rgblevels4' => { 312 => 0xe },
	'wb_rgblevels5' => { 312 => 0x12 },
	'wb_rgblevels6' => { 312 => 0x16 },
	'wb_rgblevels7' => { 312 => 0x1a },
	'wb_rgblevelsauto' => { 383 => 0x0 },
	'wb_rgblevelscustom1' => { 383 => 0x15 },
	'wb_rgblevelscustom2' => { 383 => 0x18 },
	'wb_rgblevelscustom3' => { 383 => 0x1b },
	'wb_rgblevelsdaylight' => { 383 => 0x3 },
	'wb_rgblevelsflash' => { 383 => 0x12 },
	'wb_rgblevelsfluorescent' => { 383 => 0xf },
	'wb_rgblevelsincandescent' => { 383 => 0xc },
	'wb_rgblevelsovercast' => { 383 => 0x9 },
	'wb_rgblevelsshade' => { 383 => 0x6 },
	'wb_rgblevelsunknown0' => { 384 => 0x0 },
	'wb_rgblevelsunknown1' => { 384 => 0x3 },
	'wb_rgblevelsunknown2' => { 384 => 0x6 },
	'wb_rgblevelsunknown3' => { 384 => 0x9 },
	'wb_rgblevelsunknown4' => { 384 => 0xc },
	'wb_rgblevelsunknown5' => { 384 => 0xf },
	'wb_rgblevelsunknown6' => { 384 => 0x12 },
	'wb_rgblevelsunknown7' => { 384 => 0x15 },
	'wb_rgblevelsunknown8' => { 384 => 0x18 },
	'wb_rgblevelsunknown9' => { 384 => 0x1b },
	'wb_rgbmuldaylight' => { 133 => 0x852 },
	'wb_rgbmulflash' => { 133 => 0x855 },
	'wb_rgbmulfluorescent' => { 133 => 0x854 },
	'wb_rgbmultungsten' => { 133 => 0x853 },
	'wb_rggbblacklevels' => { 35 => 0x25 },
	'wb_rggblevels' => { 184 => 0x4, 192 => 0x0, 196 => 0x13e8, 197 => 0x38 },
	'wb_rggblevelsasshot' => { 38 => 0x0, 39 => 0x0, 40 => 0x19, 41 => 0x22, 42 => 0x3f, 45 => 0x3f, 46 => 0x3f, 47 => 0x3f, 48 => 0x47 },
	'wb_rggblevelsauto' => { 35 => 0x1, 38 => 0x5, 39 => 0x8, 40 => 0x1e, 41 => 0x18, 42 => 0x44, 45 => 0x44, 46 => 0x44, 47 => 0x44, 48 => 0x4c, 196 => 0x1478, 197 => 0x114, 379 => 0xa022 },
	'wb_rggblevelsblack' => { 379 => 0xa028 },
	'wb_rggblevelscloudy' => { 35 => 0xd, 38 => 0x1e, 39 => 0x30, 40 => 0x2d, 41 => 0x31, 42 => 0x58, 45 => 0x71, 46 => 0x8a, 47 => 0x8f, 48 => 0x92, 196 => 0x1408, 197 => 0x60, 340 => 0x20f, 348 => 0x14 },
	'wb_rggblevelscustom' => { 35 => 0x1d, 42 => 0x80, 196 => 0x1468, 197 => 0x100 },
	'wb_rggblevelscustom1' => { 40 => 0x41 },
	'wb_rggblevelscustom2' => { 40 => 0x46 },
	'wb_rggblevelsdaylight' => { 35 => 0x5, 38 => 0x14, 39 => 0x20, 40 => 0x23, 41 => 0x27, 42 => 0x4e, 45 => 0x67, 46 => 0x80, 47 => 0x85, 48 => 0x88, 196 => 0x13f8, 197 => 0x4c, 340 => 0x20d, 348 => 0x2 },
	'wb_rggblevelsflash' => { 35 => 0x19, 38 => 0x32, 39 => 0x50, 40 => 0x3c, 41 => 0x45, 42 => 0x6c, 45 => 0x85, 46 => 0x9e, 47 => 0xa3, 48 => 0xa6, 196 => 0x1448, 340 => 0x214, 348 => 0x41 },
	'wb_rggblevelsfluorescent' => { 35 => 0x15, 38 => 0x28, 39 => 0x40, 40 => 0x37, 41 => 0x3b, 42 => 0x62, 45 => 0x7b, 46 => 0x94, 47 => 0x99, 48 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 197 => 0xc4, 340 => 0x211, 348 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 348 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 197 => 0xb0, 340 => 0x212, 348 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 196 => 0x1438, 197 => 0x9c, 340 => 0x213, 348 => 0x38 },
	'wb_rggblevelshtmercury' => { 197 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 379 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 379 => 0xa024 },
	'wb_rggblevelskelvin' => { 35 => 0x21, 38 => 0x2d, 39 => 0x48, 41 => 0x40, 42 => 0x67, 45 => 0x80, 46 => 0x99, 47 => 0x9e, 48 => 0xa1 },
	'wb_rggblevelsmeasured' => { 38 => 0xa, 39 => 0x10, 42 => 0x49, 45 => 0x49, 46 => 0x49, 47 => 0x49, 48 => 0x51 },
	'wb_rggblevelspc1' => { 41 => 0x90, 42 => 0x71 },
	'wb_rggblevelspc2' => { 41 => 0x95, 42 => 0x76 },
	'wb_rggblevelspc3' => { 41 => 0x9a, 42 => 0x7b },
	'wb_rggblevelsshade' => { 35 => 0x9, 38 => 0x19, 39 => 0x28, 40 => 0x28, 41 => 0x2c, 42 => 0x53, 45 => 0x6c, 46 => 0x85, 47 => 0x8a, 48 => 0x8d, 197 => 0x74, 340 => 0x20e, 348 => 0xb },
	'wb_rggblevelstungsten' => { 35 => 0x11, 38 => 0x23, 39 => 0x38, 40 => 0x32, 41 => 0x36, 42 => 0x5d, 45 => 0x76, 46 => 0x8f, 47 => 0x94, 48 => 0x97, 196 => 0x1428, 197 => 0x88, 340 => 0x210, 348 => 0x1d },
	'wb_rggblevelsuncorrected' => { 379 => 0xa021 },
	'wb_rggblevelsunknown' => { 38 => 0xf, 39 => 0x18, 41 => 0x1d, 45 => 0x4e, 46 => 0x4e, 47 => 0x4e, 48 => 0x56, 348 => 0x53 },
	'wb_rggblevelsunknown10' => { 38 => 0x5f, 39 => 0x98, 41 => 0x72, 45 => 0x9e, 46 => 0x7b, 47 => 0x7b, 48 => 0x83 },
	'wb_rggblevelsunknown11' => { 38 => 0x64, 39 => 0xa0, 41 => 0x77, 45 => 0xa3, 46 => 0xa3, 47 => 0x80, 48 => 0xab },
	'wb_rggblevelsunknown12' => { 38 => 0x69, 39 => 0xa8, 41 => 0x7c, 45 => 0xa8, 46 => 0xa8, 47 => 0xa8, 48 => 0xb0 },
	'wb_rggblevelsunknown13' => { 38 => 0x6e, 39 => 0xb0, 41 => 0x81, 45 => 0xad, 46 => 0xad, 47 => 0xad, 48 => 0xb5 },
	'wb_rggblevelsunknown14' => { 41 => 0x86, 45 => 0xb2, 46 => 0xb2, 47 => 0xb2, 48 => 0xba },
	'wb_rggblevelsunknown15' => { 41 => 0x8b, 45 => 0xb7, 46 => 0xb7, 47 => 0xb7, 48 => 0xbf },
	'wb_rggblevelsunknown16' => { 41 => 0x9f, 46 => 0xbc, 47 => 0xbc, 48 => 0xc4 },
	'wb_rggblevelsunknown17' => { 46 => 0xc1, 47 => 0xc1, 48 => 0xc9 },
	'wb_rggblevelsunknown18' => { 46 => 0xc6, 47 => 0xc6, 48 => 0xce },
	'wb_rggblevelsunknown19' => { 46 => 0xcb, 47 => 0xcb, 48 => 0xd3 },
	'wb_rggblevelsunknown2' => { 38 => 0x37, 39 => 0x58, 41 => 0x4a, 45 => 0x53, 46 => 0x53, 47 => 0x53, 48 => 0x5b },
	'wb_rggblevelsunknown20' => { 46 => 0xd0, 47 => 0xd0, 48 => 0xd8 },
	'wb_rggblevelsunknown21' => { 47 => 0xd5, 48 => 0xdd },
	'wb_rggblevelsunknown22' => { 47 => 0xda, 48 => 0xe2 },
	'wb_rggblevelsunknown23' => { 47 => 0xdf, 48 => 0xe7 },
	'wb_rggblevelsunknown24' => { 47 => 0xe4, 48 => 0xec },
	'wb_rggblevelsunknown25' => { 47 => 0xe9, 48 => 0xf1 },
	'wb_rggblevelsunknown26' => { 47 => 0xee, 48 => 0xf6 },
	'wb_rggblevelsunknown27' => { 47 => 0xf3, 48 => 0xfb },
	'wb_rggblevelsunknown28' => { 47 => 0xf8, 48 => 0x100 },
	'wb_rggblevelsunknown29' => { 47 => 0xfd, 48 => 0x105 },
	'wb_rggblevelsunknown3' => { 38 => 0x3c, 39 => 0x60, 41 => 0x4f, 45 => 0x58, 46 => 0x58, 47 => 0x58, 48 => 0x60 },
	'wb_rggblevelsunknown30' => { 47 => 0x102 },
	'wb_rggblevelsunknown4' => { 38 => 0x41, 39 => 0x68, 41 => 0x54, 45 => 0x5d, 46 => 0x5d, 47 => 0x5d, 48 => 0x65 },
	'wb_rggblevelsunknown5' => { 38 => 0x46, 39 => 0x70, 41 => 0x59, 45 => 0x62, 46 => 0x62, 47 => 0x62, 48 => 0x6a },
	'wb_rggblevelsunknown6' => { 38 => 0x4b, 39 => 0x78, 41 => 0x5e, 45 => 0x8a, 46 => 0x67, 47 => 0x67, 48 => 0x6f },
	'wb_rggblevelsunknown7' => { 38 => 0x50, 39 => 0x80, 41 => 0x63, 45 => 0x8f, 46 => 0x6c, 47 => 0x6c, 48 => 0x74 },
	'wb_rggblevelsunknown8' => { 38 => 0x55, 39 => 0x88, 41 => 0x68, 45 => 0x94, 46 => 0x71, 47 => 0x71, 48 => 0x79 },
	'wb_rggblevelsunknown9' => { 38 => 0x5a, 39 => 0x90, 41 => 0x6d, 45 => 0x99, 46 => 0x76, 47 => 0x76, 48 => 0x7e },
	'wb_rggblevelsuserselected' => { 348 => 0x5c },
	'wbadjblueamber' => { 99 => 0x20106 },
	'wbadjbluebalance' => { 264 => 0x8 },
	'wbadjcolortemp' => { 99 => 0x20102, 104 => 0x1a },
	'wbadjlighting' => { 264 => 0x14 },
	'wbadjmagentagreen' => { 99 => 0x20105 },
	'wbadjmode' => { 264 => 0x10 },
	'wbadjredbalance' => { 264 => 0x0 },
	'wbadjrggblevels' => { 99 => 0x20125, 104 => 0x6 },
	'wbadjtemperature' => { 264 => 0x18 },
	'wbadjtint' => { 264 => 0x25 },
	'wbbluelevel' => { 300 => 0x324, 305 => 0x8006, 310 => 0x26 },
	'wbbracketingsteps' => { 236 => 0x174d, 237 => 0x87c, 245 => 0x1757 },
	'wbbracketmode' => { 55 => 0x9 },
	'wbbracketshotnumber' => { 181 => 0x2b, 372 => 0x101a },
	'wbbracketvalueab' => { 55 => 0xc },
	'wbbracketvaluegm' => { 55 => 0xd },
	'wbfinetuneactive' => { 104 => 0x24 },
	'wbfinetunesaturation' => { 104 => 0x28 },
	'wbfinetunetone' => { 104 => 0x2c },
	'wbgreenlevel' => { 300 => 0x323, 305 => 0x8005, 310 => 0x25 },
	'wbmediaimagesizesetting' => { 80 => 0x708 },
	'wbmode' => { 183 => 0x4, 287 => 0x1015 },
	'wbredlevel' => { 300 => 0x322, 305 => 0x8004, 310 => 0x24 },
	'wbscale' => { 184 => 0x0 },
	'wbshiftab' => { 71 => 0xc, 305 => 0x46, 322 => 0x10 },
	'wbshiftab_gm' => { 405 => 0x2014 },
	'wbshiftab_gm_precise' => { 405 => 0x2026 },
	'wbshiftcreativecontrol' => { 305 => 0x92 },
	'wbshiftgm' => { 71 => 0xd, 305 => 0x47, 322 => 0x11 },
	'wbshiftintelligentauto' => { 305 => 0x8b },
	'wbtype1' => { 311 => 0x1, 312 => 0x1 },
	'wbtype2' => { 311 => 0x4, 312 => 0x5 },
	'wbtype3' => { 311 => 0x7, 312 => 0x9 },
	'wbtype4' => { 311 => 0xa, 312 => 0xd },
	'wbtype5' => { 311 => 0xd, 312 => 0x11 },
	'wbtype6' => { 311 => 0x10, 312 => 0x15 },
	'wbtype7' => { 311 => 0x13, 312 => 0x19 },
	'webstatement' => { 490 => 'WebStatement' },
	'what' => { 460 => 'What', 462 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 71 => 0x8, 74 => 0x7, 108 => 0x7, 109 => [0x19,0x2012], 115 => [0xa403,0xfe4e], 123 => 0x1002, 133 => 0x3fc, 134 => 0xfa0d, 135 => 0x40, 146 => 0x1a, 175 => 0x3, 176 => 0xe, 177 => 0x4, 178 => 0xb, 180 => 0x115, 218 => 0x5, 248 => 0x7, 300 => 0x304, 305 => 0x3, 307 => 0x3033, 340 => 0x19, 347 => 0x7, 371 => 0x26, 372 => 0x1003, 382 => [0x88,0x3c,0x7,0x58], 392 => 0xf, 393 => 0xe, 405 => [0x115,0xb054], 460 => 'WhiteBalance', 462 => 'WhiteBalance', 466 => 'WhiteBalance' },
	'whitebalance0' => { 171 => 'WhiteBalance0' },
	'whitebalance1' => { 171 => 'WhiteBalance1' },
	'whitebalance2' => { 171 => 'WhiteBalance2', 282 => 0x500 },
	'whitebalanceadj' => { 99 => 0x20101, 104 => 0x18, 258 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 318 => 0x0 },
	'whitebalancebias' => { 109 => 0x2011, 287 => 0x304, 305 => 0x23 },
	'whitebalanceblue' => { 71 => 0x7 },
	'whitebalancebracket' => { 282 => 0x502, 287 => 0x303 },
	'whitebalancebracketing' => { 178 => 0x22, 181 => 0x2c, 403 => 0x2c },
	'whitebalancecomp' => { 290 => 0x1001 },
	'whitebalancedetected' => { 133 => 0x3fb },
	'whitebalancefinetune' => { 123 => 0x100a, 178 => 0x38, 180 => 0x112, 218 => 0xb, 372 => 0x1004, 392 => 0x6, 393 => 0x5, 405 => 0x112 },
	'whitebalancemode' => { 133 => 0x3fa, 340 => 0x1a },
	'whitebalancered' => { 71 => 0x6 },
	'whitebalanceset' => { 321 => 0xa },
	'whitebalancesetting' => { 178 => 0x23, 392 => 0x5, 393 => 0x4, 394 => 0x16, 410 => 0xd },
	'whitebalancesetup' => { 379 => 0x41 },
	'whitebalancetemperature' => { 282 => 0x501 },
	'whiteboard' => { 287 => 0x301 },
	'whitelevel' => { 115 => 0xc61d, 340 => 0x7e },
	'whitepoint' => { 115 => 0x13e, 340 => 0x201, 482 => 'WhitePoint' },
	'whites2012' => { 460 => 'Whites2012', 462 => 'Whites2012' },
	'whitesadj' => { 438 => 0x9017 },
	'wideadapter' => { 372 => 0x1017 },
	'widefocuszone' => { 175 => 0x2f },
	'widerange' => { 381 => 0x20f },
	'windmode' => { 133 => 0x3f4 },
	'windowlocation' => { 365 => 'WLOC' },
	'windowsatom' => { 461 => 'windowsAtom' },
	'windowsatomextension' => { 461 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 461 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 461 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 476 => 'wordCount' },
	'workcolorspace' => { 99 => 0x10200, 104 => 0x270 },
	'workflowtag' => { 472 => 'WorkflowTag' },
	'workflowtagcvid' => { 472 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 472 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 472 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 472 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 468 => 'WorkToDo' },
	'worldtimelocation' => { 305 => 0x3a, 340 => 0x22, 346 => '0.1' },
	'writer-editor' => { 127 => 0x7a },
	'x3filllight' => { 382 => 0x12 },
	'xattrquarantine' => { 169 => 'com.apple.quarantine' },
	'xilinxversion' => { 133 => 0x414 },
	'xml' => { 131 => 'xml ' },
	'xmp' => { 102 => 0xffff00f6, 116 => 'XMP' },
	'xmptoolkit' => { 483 => 'xmptk' },
	'xpauthor' => { 115 => 0x9c9d },
	'xpcomment' => { 115 => 0x9c9c },
	'xpkeywords' => { 115 => 0x9c9e },
	'xposition' => { 115 => 0x11e },
	'xpsubject' => { 115 => 0x9c9f },
	'xptitle' => { 115 => 0x9c9b },
	'xresolution' => { 115 => 0x11a, 130 => 0x3, 355 => 0x0, 482 => 'XResolution' },
	'xyresolution' => { 119 => 0x3 },
	'yaw' => { 111 => 0x7, 365 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 236 => 0x3513, 237 => 0x2c2c, 245 => 0x36fc, 377 => 0x0 },
	'ycbcrcoefficients' => { 115 => 0x211, 482 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 115 => 0x213, 482 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 115 => 0x212, 482 => 'YCbCrSubSampling' },
	'year' => { 357 => 'yrrc', 359 => 'year' },
	'yearcreated' => { 135 => 0x10, 144 => 0xc },
	'yellowhsl' => { 99 => 0x20912 },
	'yield' => { 478 => 'yield' },
	'yposition' => { 115 => 0x11f },
	'yresolution' => { 115 => 0x11b, 130 => 0x5, 355 => 0x4, 482 => 'YResolution' },
	'zonematching' => { 180 => 0x10a, 183 => [0x3a,0x4a], 405 => 0xb024 },
	'zonematchingmode' => { 178 => 0x14 },
	'zonematchingon' => { 177 => 0x75 },
	'zonematchingvalue' => { 392 => 0x1f },
	'zoomedpreviewlength' => { 287 => 0xf05 },
	'zoomedpreviewsize' => { 287 => 0xf06 },
	'zoomedpreviewstart' => { 287 => 0xf04 },
	'zoomsourcewidth' => { 34 => 0x24 },
	'zoomstepcount' => { 285 => 0x300, 287 => 0x100d },
	'zoomtargetwidth' => { 34 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'acceldata' => 1,
	'accelerometerdata' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airspeed' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'angleaxis' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimagetype' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'breakchar' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaformat' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd850' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotextra' => 1,
	'dualshotversion' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd' => 1,
	'gps' => 1,
	'gpsaltituderaw' => 1,
	'gpsdatalist' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpspos' => 1,
	'gpsposition' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'gyroscope' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddenslides' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kinds' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelid' => 1,
	'labeltext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'lenstypemake' => 1,
	'lenstypemodel' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magneticfield' => 1,
	'magnetometer' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metaformat' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metdata' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midisong' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'moviefragment' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playcounter' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraittonescaletable' => 1,
	'pose' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesize' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	's2n' => 1,
	'sampleblacksequence' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorrightborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelstungsten' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2019, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
