#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.14';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 100 => 0x69 },
	'about' => { 430 => 'about' },
	'aboutcvterm' => { 422 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 422 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 422 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 422 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 422 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'abspeakaudiofilepath' => { 436 => 'absPeakAudioFilePath' },
	'acceleration' => { 109 => 0x9404 },
	'accelerationtracking' => { 75 => 0x518 },
	'accelerometer' => { 342 => 0x3 },
	'accelerometerx' => { 280 => 0x8d },
	'accelerometery' => { 280 => 0x8e },
	'accelerometerz' => { 280 => 0x8c },
	'accessoryserialnumber' => { 280 => 0x54 },
	'accessorytype' => { 280 => 0x53 },
	'acedemicfield' => { 426 => 'acedemicField' },
	'actionadvised' => { 117 => 0x2a },
	'activearea' => { 109 => 0xc68d },
	'actived-lighting' => { 198 => 0x22, 234 => 0x24 },
	'actived-lightingmode' => { 234 => 0x25 },
	'adaptervoltage' => { 123 => 0x407 },
	'addaspectratioinfo' => { 75 => 0x80e },
	'additionalmodelinformation' => { 422 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 75 => 0x80f, 76 => 0x11, 77 => 0x13, 80 => 0x14 },
	'address' => { 144 => 'Address' },
	'adjustmentmode' => { 348 => 0x15 },
	'adlbracketingstep' => { 216 => 0x883 },
	'adlbracketingtype' => { 216 => 0x884 },
	'adobe' => { 110 => 'Adobe' },
	'adultcontentwarning' => { 269 => 'AdultContentWarning', 429 => 'adultContentWarning' },
	'advancedfilter' => { 114 => 0x1201 },
	'advancedraw' => { 236 => 0x76a43203 },
	'advancedscenetype' => { 280 => 0x3d },
	'advisory' => { 434 => 'Advisory' },
	'ae_iso' => { 287 => 0x2, 288 => 0x4, 289 => 0x12 },
	'aeaperture' => { 287 => 0x1, 288 => 0x3, 289 => 0x11 },
	'aeaperturesteps' => { 287 => 0x8, 288 => 0xb },
	'aebautocancel' => { 75 => 0x104 },
	'aebbracketvalue' => { 69 => 0x11 },
	'aebracketingsteps' => { 215 => 0x174c, 216 => 0x87b, 224 => 0x1756 },
	'aebsequence' => { 75 => 0x105 },
	'aebsequenceautocancel' => { 73 => 0x9, 74 => 0x9, 76 => 0x8, 77 => 0x9, 80 => 0x9, 81 => 0x7 },
	'aebshotcount' => { 75 => 0x106 },
	'aebxv' => { 287 => 0x4, 288 => 0x6 },
	'aeerror' => { 288 => 0x8 },
	'aeexposuretime' => { 287 => 0x0, 288 => 0x2, 289 => 0x10 },
	'aelbutton' => { 164 => 0x45 },
	'aelexposureindicator' => { 164 => 0x51 },
	'aelock' => { 164 => 0x5b, 245 => '4.2', 254 => '4.2', 259 => 0x201, 314 => 0x48, 356 => 0x40, 357 => 0x40, 358 => [0x86,0x286] },
	'aelockbutton' => { 243 => '16.1', 245 => '4.1', 248 => '15.1', 249 => '16.1', 250 => '16.1', 252 => '30.1', 253 => '16.1', 254 => '4.1', 256 => '17.1', 257 => '17.1' },
	'aelockbuttonplusdials' => { 243 => '16.2', 252 => '32.1', 256 => '44.1' },
	'aelockformb-d80' => { 257 => '3.1' },
	'aemaxaperture' => { 287 => 0x9, 288 => 0x10, 289 => 0x1c },
	'aemaxaperture2' => { 287 => 0xa, 288 => 0x11, 289 => 0x1d },
	'aemeteringmode' => { 287 => 0xc },
	'aemeteringmode2' => { 287 => '13.1' },
	'aemeteringsegments' => { 167 => 0x628, 314 => 0x209 },
	'aemicroadjustment' => { 75 => 0x110 },
	'aeminaperture' => { 287 => 0xb, 288 => 0x12, 289 => 0x1e },
	'aeminexposuretime' => { 287 => 0x5, 288 => 0x13, 289 => 0x1f },
	'aeprogrammode' => { 287 => 0x6 },
	'aeprojectlink' => { 411 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 411 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 411 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 411 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 411 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 411 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 33 => 0x21 },
	'aewhitebalance' => { 287 => 0xd },
	'aexv' => { 287 => 0x3, 288 => 0x5 },
	'af-cpriorityselection' => { 243 => '1.1', 244 => '1.1', 246 => '1.1', 247 => '1.1', 249 => '0.1', 250 => '0.1', 251 => '0.1', 252 => '1.1', 253 => '0.1', 256 => '1.1' },
	'af-onbutton' => { 246 => '70.1', 247 => '70.1' },
	'af-onformb-d10' => { 243 => '3.3', 252 => '3.2' },
	'af-onformb-d11' => { 253 => '2.2' },
	'af-onformb-d12' => { 256 => '50.1' },
	'af-spriorityselection' => { 243 => '1.2', 244 => '1.2', 246 => '1.4', 247 => '1.4', 251 => '0.2', 252 => '1.2', 253 => '0.2', 256 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 243 => '2.1', 244 => '2.1', 246 => '78.3', 247 => '78.3', 252 => '2.1', 256 => '2.1' },
	'afadjustment' => { 314 => 0x72 },
	'afandmeteringbuttons' => { 75 => 0x701 },
	'afaperture' => { 194 => 0x5, 195 => 0x5 },
	'afareaheight' => { 173 => 0x1a },
	'afareaillumination' => { 164 => 0x4b, 254 => '15.3' },
	'afareamode' => { 160 => 0x33, 164 => 0xe, 172 => 0x0, 173 => 0x5, 280 => 0xf, 339 => 0x1205, 349 => [0xa,0x3a], 356 => 0x11, 357 => 0x10, 358 => 0x24, 368 => 0xb043, 388 => 0x17 },
	'afareamodesetting' => { 245 => '11.1', 248 => '0.1', 254 => '16.1', 257 => '2.1', 368 => 0x201c },
	'afareas' => { 259 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 75 => 0x51b },
	'afareawidth' => { 173 => 0x18 },
	'afareaxposition' => { 173 => 0x14, 339 => 0x1203 },
	'afareaxposition1' => { 339 => 0x1201 },
	'afareayposition' => { 173 => 0x16, 339 => 0x1204 },
	'afareayposition1' => { 339 => 0x1202 },
	'afassist' => { 73 => 0x5, 81 => 0x5, 164 => 0x48, 243 => '2.5', 245 => '0.2', 248 => '0.2', 249 => '1.1', 250 => '1.1', 251 => '1.3', 252 => '2.4', 253 => '1.3', 254 => '0.2', 256 => '2.4', 257 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 75 => 0x50e, 76 => 0x4, 77 => 0x5, 78 => 0x4, 79 => 0x4, 80 => 0x5 },
	'afassistlamp' => { 280 => 0x31 },
	'afbuttonpressed' => { 358 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 290 => 0x6 },
	'afduringliveview' => { 75 => 0x511 },
	'affinea' => { 405 => 'AffineA' },
	'affineb' => { 405 => 'AffineB' },
	'affinec' => { 405 => 'AffineC' },
	'affined' => { 405 => 'AffineD' },
	'affinetune' => { 174 => 0x0, 259 => 0x306 },
	'affinetuneadj' => { 174 => 0x2, 208 => 0x2d1, 209 => 0x2dc, 259 => 0x307 },
	'affinetuneindex' => { 174 => 0x1 },
	'affinex' => { 405 => 'AffineX' },
	'affiney' => { 405 => 'AffineY' },
	'afhold' => { 290 => 0x1fd },
	'afilluminator' => { 356 => 0x29, 368 => 0xb044 },
	'afimageheight' => { 173 => 0x12 },
	'afimagewidth' => { 173 => 0x10 },
	'afintegrationtime' => { 290 => 0x7 },
	'afmicroadj' => { 349 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 353 => 0x131 },
	'afmicroadjregisteredlenses' => { 353 => '305.1' },
	'afmicroadjustment' => { 75 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 353 => 0x130 },
	'afmode' => { 104 => 0x3009, 114 => 0x1022, 160 => 0x16, 348 => 0x5 },
	'afmoderestrictions' => { 244 => '50.3', 246 => '48.3', 247 => '48.3', 256 => '48.3' },
	'afonaelockbuttonswitch' => { 75 => 0x702 },
	'afonbutton' => { 243 => '3.1', 244 => '47.1' },
	'afpoint' => { 33 => 0x13, 103 => 0x18, 160 => 0x15, 172 => 0x1, 262 => 0x308, 348 => 0x1f, 349 => [0x37,0x7], 353 => 0x19, 354 => 0x18, 355 => [0x18,0x20] },
	'afpointactivationarea' => { 74 => 0x11, 80 => 0x11 },
	'afpointareaexpansion' => { 75 => 0x508 },
	'afpointatshutterrelease' => { 349 => [0x39,0x9] },
	'afpointautoselection' => { 75 => 0x50b },
	'afpointbrightness' => { 75 => 0x50d, 243 => '2.4', 244 => '46.5', 246 => '2.2', 247 => '2.2', 256 => '2.3' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 75 => 0x50c },
	'afpointillumination' => { 74 => 0xa, 243 => '2.3', 244 => '46.2', 246 => '47.2', 247 => '47.2', 251 => '1.2', 252 => '2.3', 253 => '1.2', 256 => '47.2', 257 => '2.4' },
	'afpointinfocus' => { 349 => [0x38,0x8] },
	'afpointmode' => { 295 => 0x3 },
	'afpointposition' => { 104 => 0x2021, 280 => 0x4d },
	'afpointregistration' => { 73 => 0x7 },
	'afpoints' => { 163 => 0x10 },
	'afpointselected' => { 164 => 0xd, 259 => 0x305, 314 => 0xe, 353 => 0x15, 354 => 0x14, 355 => [0x14,0x1c], 368 => 0x201e },
	'afpointselected2' => { 295 => 0x4 },
	'afpointselection' => { 74 => 0xb, 243 => '1.3', 244 => '1.3', 252 => '1.3', 256 => '1.3' },
	'afpointselectionmethod' => { 75 => 0x50f, 76 => 0xc, 77 => 0xd, 80 => 0xd },
	'afpointsetting' => { 356 => 0x12, 357 => 0x11 },
	'afpointsinfocus' => { 69 => 0xe, 172 => 0x2, 290 => 0xb, 291 => 0x4, 314 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 74 => 0xd },
	'afpointsselected' => { 291 => '4.1', 395 => 0x4 },
	'afpointsspecial' => { 291 => '4.2' },
	'afpointsunknown1' => { 290 => 0x0 },
	'afpointsunknown2' => { 290 => 0x2 },
	'afpointsused' => { 173 => 0x8, 349 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 290 => 0x4 },
	'afresponse' => { 198 => 0xad },
	'afresult' => { 264 => 0x1038 },
	'afsearch' => { 259 => 0x303 },
	'afsensoractive' => { 160 => 0x1 },
	'afstatus' => { 339 => 0x1200 },
	'afstatus_00_b4' => { 352 => 0x0 },
	'afstatus_01_c4' => { 352 => 0x2 },
	'afstatus_02_d4' => { 352 => 0x4 },
	'afstatus_03_e4' => { 352 => 0x6 },
	'afstatus_04_f4' => { 352 => 0x8 },
	'afstatus_05_g4' => { 352 => 0xa },
	'afstatus_06_h4' => { 352 => 0xc },
	'afstatus_07_b3' => { 352 => 0xe },
	'afstatus_08_c3' => { 352 => 0x10 },
	'afstatus_09_d3' => { 352 => 0x12 },
	'afstatus_10_e3' => { 352 => 0x14 },
	'afstatus_11_f3' => { 352 => 0x16 },
	'afstatus_12_g3' => { 352 => 0x18 },
	'afstatus_13_h3' => { 352 => 0x1a },
	'afstatus_14_b2' => { 352 => 0x1c },
	'afstatus_15_c2' => { 352 => 0x1e },
	'afstatus_16_d2' => { 352 => 0x20 },
	'afstatus_17_e2' => { 352 => 0x22 },
	'afstatus_18_f2' => { 352 => 0x24 },
	'afstatus_19_g2' => { 352 => 0x26 },
	'afstatus_20_h2' => { 352 => 0x28 },
	'afstatus_21_c1' => { 352 => 0x2a },
	'afstatus_22_d1' => { 352 => 0x2c },
	'afstatus_23_e1' => { 352 => 0x2e },
	'afstatus_24_f1' => { 352 => 0x30 },
	'afstatus_25_g1' => { 352 => 0x32 },
	'afstatus_26_a7_vertical' => { 352 => 0x34 },
	'afstatus_27_a6_vertical' => { 352 => 0x36 },
	'afstatus_28_a5_vertical' => { 352 => 0x38 },
	'afstatus_29_c7_vertical' => { 352 => 0x3a },
	'afstatus_30_c6_vertical' => { 352 => 0x3c },
	'afstatus_31_c5_vertical' => { 352 => 0x3e },
	'afstatus_32_e7_vertical' => { 352 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 352 => 0x42 },
	'afstatus_34_e5_vertical' => { 352 => 0x44 },
	'afstatus_35_g7_vertical' => { 352 => 0x46 },
	'afstatus_36_g6_vertical' => { 352 => 0x48 },
	'afstatus_37_g5_vertical' => { 352 => 0x4a },
	'afstatus_38_i7_vertical' => { 352 => 0x4c },
	'afstatus_39_i6_vertical' => { 352 => 0x4e },
	'afstatus_40_i5_vertical' => { 352 => 0x50 },
	'afstatus_41_a7' => { 352 => 0x52 },
	'afstatus_42_b7' => { 352 => 0x54 },
	'afstatus_43_c7' => { 352 => 0x56 },
	'afstatus_44_d7' => { 352 => 0x58 },
	'afstatus_45_e7' => { 352 => 0x5a },
	'afstatus_46_f7' => { 352 => 0x5c },
	'afstatus_47_g7' => { 352 => 0x5e },
	'afstatus_48_h7' => { 352 => 0x60 },
	'afstatus_49_i7' => { 352 => 0x62 },
	'afstatus_50_a6' => { 352 => 0x64 },
	'afstatus_51_b6' => { 352 => 0x66 },
	'afstatus_52_c6' => { 352 => 0x68 },
	'afstatus_53_d6' => { 352 => 0x6a },
	'afstatus_54_e6_center' => { 352 => 0x6c },
	'afstatus_55_f6' => { 352 => 0x6e },
	'afstatus_56_g6' => { 352 => 0x70 },
	'afstatus_57_h6' => { 352 => 0x72 },
	'afstatus_58_i6' => { 352 => 0x74 },
	'afstatus_59_a5' => { 352 => 0x76 },
	'afstatus_60_b5' => { 352 => 0x78 },
	'afstatus_61_c5' => { 352 => 0x7a },
	'afstatus_62_d5' => { 352 => 0x7c },
	'afstatus_63_e5' => { 352 => 0x7e },
	'afstatus_64_f5' => { 352 => 0x80 },
	'afstatus_65_g5' => { 352 => 0x82 },
	'afstatus_66_h5' => { 352 => 0x84 },
	'afstatus_67_i5' => { 352 => 0x86 },
	'afstatus_68_c11' => { 352 => 0x88 },
	'afstatus_69_d11' => { 352 => 0x8a },
	'afstatus_70_e11' => { 352 => 0x8c },
	'afstatus_71_f11' => { 352 => 0x8e },
	'afstatus_72_g11' => { 352 => 0x90 },
	'afstatus_73_b10' => { 352 => 0x92 },
	'afstatus_74_c10' => { 352 => 0x94 },
	'afstatus_75_d10' => { 352 => 0x96 },
	'afstatus_76_e10' => { 352 => 0x98 },
	'afstatus_77_f10' => { 352 => 0x9a },
	'afstatus_78_g10' => { 352 => 0x9c },
	'afstatus_79_h10' => { 352 => 0x9e },
	'afstatus_80_b9' => { 352 => 0xa0 },
	'afstatus_81_c9' => { 352 => 0xa2 },
	'afstatus_82_d9' => { 352 => 0xa4 },
	'afstatus_83_e9' => { 352 => 0xa6 },
	'afstatus_84_f9' => { 352 => 0xa8 },
	'afstatus_85_g9' => { 352 => 0xaa },
	'afstatus_86_h9' => { 352 => 0xac },
	'afstatus_87_b8' => { 352 => 0xae },
	'afstatus_88_c8' => { 352 => 0xb0 },
	'afstatus_89_d8' => { 352 => 0xb2 },
	'afstatus_90_e8' => { 352 => 0xb4 },
	'afstatus_91_f8' => { 352 => 0xb6 },
	'afstatus_92_g8' => { 352 => 0xb8 },
	'afstatus_93_h8' => { 352 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 352 => 0xbc },
	'afstatusactivesensor' => { 160 => 0x2, 349 => [0x4,0x3b], 353 => 0x1e, 354 => 0x1b, 355 => [0x1b,0x21] },
	'afstatusbottom' => { 160 => 0x8, 353 => 0x2a, 354 => 0x21, 355 => 0x21 },
	'afstatusbottom-left' => { 160 => 0x12, 354 => 0x2b, 355 => 0x2b },
	'afstatusbottom-right' => { 160 => 0x6, 354 => 0x1f, 355 => 0x1f },
	'afstatusbottomassist-left' => { 353 => 0x28 },
	'afstatusbottomassist-right' => { 353 => 0x2c },
	'afstatusbottomhorizontal' => { 350 => 0x10, 351 => 0x1c },
	'afstatusbottomvertical' => { 350 => 0x16, 351 => 0x26 },
	'afstatuscenter-10' => { 353 => 0x34 },
	'afstatuscenter-11' => { 353 => 0x36 },
	'afstatuscenter-12' => { 353 => 0x38 },
	'afstatuscenter-14' => { 353 => 0x3c },
	'afstatuscenter-7' => { 353 => 0x2e },
	'afstatuscenter-9' => { 353 => 0x32 },
	'afstatuscenter-horizontal' => { 353 => 0x30 },
	'afstatuscenter-vertical' => { 353 => 0x3a },
	'afstatuscenterf2-8' => { 353 => 0x4c },
	'afstatuscenterhorizontal' => { 160 => 0x2f, 350 => 0xc, 351 => 0x18, 354 => 0x2f, 355 => 0x2f },
	'afstatuscentervertical' => { 160 => 0xc, 350 => 0x14, 351 => 0x22, 354 => 0x25, 355 => 0x25 },
	'afstatusfarleft' => { 350 => 0x6, 353 => 0x26 },
	'afstatusfarlefthorizontal' => { 351 => 0x4 },
	'afstatusfarleftvertical' => { 351 => 0x12 },
	'afstatusfarright' => { 350 => 0x18, 353 => 0x44 },
	'afstatusfarrighthorizontal' => { 351 => 0x2c },
	'afstatusfarrightvertical' => { 351 => 0x34 },
	'afstatusleft' => { 160 => 0x2d, 350 => 0x2, 353 => 0x22, 354 => 0x2d, 355 => 0x2d },
	'afstatuslefthorizontal' => { 351 => 0x6 },
	'afstatusleftvertical' => { 351 => 0xe },
	'afstatuslower-left' => { 350 => 0x4, 353 => 0x24 },
	'afstatuslower-lefthorizontal' => { 351 => 0xa },
	'afstatuslower-leftvertical' => { 351 => 0x10 },
	'afstatuslower-middle' => { 350 => 0x22, 351 => 0x24 },
	'afstatuslower-right' => { 350 => 0x1e, 353 => 0x4a },
	'afstatuslower-righthorizontal' => { 351 => 0x32 },
	'afstatuslower-rightvertical' => { 351 => 0x3a },
	'afstatuslowerfarleft' => { 351 => 0x8 },
	'afstatuslowerfarright' => { 351 => 0x30 },
	'afstatusmiddlehorizontal' => { 160 => 0xa, 354 => 0x23, 355 => 0x23 },
	'afstatusnearleft' => { 350 => 0xe, 351 => 0x1a },
	'afstatusnearright' => { 350 => 0xa, 351 => 0x16 },
	'afstatusright' => { 160 => 0x31, 350 => 0x1c, 353 => 0x48, 354 => 0x31, 355 => 0x31 },
	'afstatusrighthorizontal' => { 351 => 0x2e },
	'afstatusrightvertical' => { 351 => 0x38 },
	'afstatustop' => { 160 => 0xe, 353 => 0x40, 354 => 0x27, 355 => 0x27 },
	'afstatustop-left' => { 160 => 0x10, 354 => 0x29, 355 => 0x29 },
	'afstatustop-right' => { 160 => 0x4, 354 => 0x1d, 355 => 0x1d },
	'afstatustopassist-left' => { 353 => 0x3e },
	'afstatustopassist-right' => { 353 => 0x42 },
	'afstatustophorizontal' => { 350 => 0x8, 351 => 0x14 },
	'afstatustopvertical' => { 350 => 0x12, 351 => 0x1e },
	'afstatusupper-left' => { 350 => 0x0, 353 => 0x20 },
	'afstatusupper-lefthorizontal' => { 351 => 0x2 },
	'afstatusupper-leftvertical' => { 351 => 0xc },
	'afstatusupper-middle' => { 350 => 0x20, 351 => 0x20 },
	'afstatusupper-right' => { 350 => 0x1a, 353 => 0x46 },
	'afstatusupper-righthorizontal' => { 351 => 0x2a },
	'afstatusupper-rightvertical' => { 351 => 0x36 },
	'afstatusupperfarleft' => { 351 => 0x0 },
	'afstatusupperfarright' => { 351 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 349 => 0x2 },
	'afwithshutter' => { 356 => 0x2a },
	'afzoneselected' => { 368 => 0x201e },
	'aggregateissuenumber' => { 426 => 'aggregateIssueNumber' },
	'aggregationtype' => { 426 => 'aggregationType' },
	'agreement' => { 429 => 'agreement' },
	'aiservocontinuousshooting' => { 74 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 75 => 0x519 },
	'aiservoimagepriority' => { 75 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 75 => 0x51a },
	'aiservotrackingmethod' => { 75 => 0x504 },
	'aiservotrackingsensitivity' => { 74 => 0x14, 75 => 0x502 },
	'album' => { 436 => 'album' },
	'alreadyapplied' => { 412 => 'AlreadyApplied' },
	'alternatetitle' => { 426 => 'alternateTitle' },
	'alternatetitlea-lang' => { 426 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 426 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 426 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 175 => 0x6 },
	'alttapename' => { 436 => 'altTapeName' },
	'alttimecode' => { 436 => 'altTimecode' },
	'alttimecodetimeformat' => { 436 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 436 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 436 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 109 => 0x9400, 335 => 0x14, 388 => 0x4 },
	'ambienttemperaturefahrenheit' => { 335 => 0x13 },
	'analogbalance' => { 109 => 0xc627 },
	'angleadj' => { 94 => 0x10003, 100 => 0x8b },
	'angleinforoll' => { 407 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 407 => 'AngleInfoYaw' },
	'anti-blur' => { 368 => 0xb04b },
	'antialiasstrength' => { 109 => 0xc632 },
	'aperturelock' => { 244 => '38.2', 246 => '38.2', 247 => '38.2', 256 => '38.2' },
	'aperturerange' => { 75 => 0x10d },
	'apertureringuse' => { 295 => '1.4' },
	'aperturesetting' => { 164 => 0x7, 356 => 0x30, 357 => 0x29, 358 => 0x1 },
	'aperturevalue' => { 84 => 0x2, 109 => 0x9202, 264 => 0x1002, 323 => 0x401, 416 => 'ApertureValue' },
	'applekeywords' => { 268 => 'AAPL:Keywords' },
	'applicationnotes' => { 109 => 0x2bc, 284 => 0x2bc },
	'applicationrecordversion' => { 117 => 0x0 },
	'applyshootingmeteringmode' => { 75 => 0x10e },
	'approved' => { 418 => 'Approved' },
	'approvedby' => { 418 => 'ApprovedBy' },
	'approximatefnumber' => { 276 => 0x313, 282 => 0x3406 },
	'approximatefocusdistance' => { 408 => 'ApproximateFocusDistance' },
	'aquahsl' => { 94 => 0x20913 },
	'armidentifier' => { 118 => 0x78 },
	'armversion' => { 118 => 0x7a },
	'artfilter' => { 259 => 0x529 },
	'artfiltereffect' => { 259 => 0x52f },
	'artist' => { 109 => 0x13b, 272 => 'Artist', 314 => 0x22e, 432 => 'Artist', 436 => 'artist' },
	'artmode' => { 104 => 0x301b },
	'artmodeparameters' => { 104 => 0x310b },
	'artworkcircadatecreated' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontributiondescription' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 422 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworkscontentdescription' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworksource' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 422 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 263 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 263 => 0x1112, 314 => 0x80, 356 => 0x55, 357 => 0x55, 358 => 0xa },
	'asshoticcprofile' => { 109 => 0xc68f },
	'asshotneutral' => { 109 => 0xc628 },
	'asshotpreprofilematrix' => { 109 => 0xc690 },
	'asshotprofilename' => { 109 => 0xc6f6 },
	'asshotwhitexy' => { 109 => 0xc629 },
	'assignbktbutton' => { 243 => '4.2', 244 => '16.1', 246 => '16.1', 247 => '16.1', 256 => '16.1' },
	'assignfuncbutton' => { 75 => 0x70b },
	'assignmb-d17af-onbutton' => { 247 => '79.1' },
	'assignmb-d17funcbutton' => { 247 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 247 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 246 => '75.1', 247 => '75.1' },
	'assignmoviefunc2button' => { 246 => '82.1', 247 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 246 => '75.2', 247 => '75.2' },
	'assignmovierecordbutton' => { 244 => '43.2', 256 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 246 => '45.1', 247 => '45.1' },
	'assignmoviesubselector' => { 246 => '74.1', 247 => '74.1' },
	'assignmoviesubselectorplusdials' => { 246 => '76.1', 247 => '76.1' },
	'assignremotefnbutton' => { 244 => '54.1', 256 => '51.1' },
	'assistbuttonfunction' => { 73 => 0xd },
	'attributionname' => { 409 => 'attributionName' },
	'attributionurl' => { 409 => 'attributionURL' },
	'audio' => { 280 => 0x20 },
	'audiobitrate' => { 60 => 0x6c },
	'audiochannels' => { 60 => 0x70 },
	'audiochanneltype' => { 436 => 'audioChannelType' },
	'audiocompression' => { 138 => 'Compression' },
	'audiocompressor' => { 436 => 'audioCompressor' },
	'audioduration' => { 117 => 0x99 },
	'audiomoddate' => { 436 => 'audioModDate' },
	'audiooutcue' => { 117 => 0x9a },
	'audiosamplerate' => { 60 => 0x6e, 436 => 'audioSampleRate' },
	'audiosampletype' => { 436 => 'audioSampleType' },
	'audiosamplingrate' => { 117 => 0x97 },
	'audiosamplingresolution' => { 117 => 0x98 },
	'audiotype' => { 117 => 0x96 },
	'author' => { 140 => 'Author', 268 => 'Author', 272 => 'Author', 330 => 'Author', 406 => 'author', 423 => 'Author', 434 => 'Author' },
	'authorsposition' => { 424 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 75 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 305 => '0.1' },
	'autobracket' => { 348 => 0x19 },
	'autobracketing' => { 114 => 0x1100, 314 => 0x18, 339 => 0x1007 },
	'autobracketingmode' => { 255 => '12.3' },
	'autobracketingset' => { 255 => '12.1' },
	'autobracketmodem' => { 243 => '21.2', 244 => '13.3', 246 => '13.2', 247 => '13.2', 252 => '26.2', 256 => '13.3' },
	'autobracketorder' => { 164 => 0x43, 243 => '21.3', 244 => '13.2', 246 => '13.1', 247 => '13.1', 252 => '26.3', 253 => '12.2', 254 => '2.2', 255 => '12.2', 256 => '13.2', 257 => '13.2' },
	'autobracketset' => { 243 => '21.1', 244 => '13.1', 248 => '11.1', 249 => '12.1', 250 => '12.1', 252 => '26.1', 253 => '12.1', 254 => '2.1', 256 => '13.1', 257 => '13.1' },
	'autobrightness' => { 412 => 'AutoBrightness' },
	'autocontrast' => { 412 => 'AutoContrast' },
	'autodistortioncontrol' => { 183 => 0x4 },
	'autodynamicrange' => { 114 => 0x140b },
	'autoexposure' => { 412 => 'AutoExposure' },
	'autoexposurebracketing' => { 69 => 0x10 },
	'autoflashisosensitivity' => { 246 => '38.5', 247 => '38.5' },
	'autofocus' => { 262 => 0x209 },
	'autofp' => { 254 => '7.3', 257 => '31.4' },
	'autoiso' => { 69 => 0x1, 104 => 0x3008, 245 => '1.1', 254 => '1.1' },
	'autoisomax' => { 245 => '1.2', 254 => '1.2' },
	'autoisominshutterspeed' => { 245 => '1.3', 254 => '1.3' },
	'autolateralca' => { 412 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 56 => 0x2, 75 => 0x204, 94 => 0x20500, 100 => 0x6f },
	'autolightingoptimizeron' => { 94 => '0x20500.0', 100 => 0x6e },
	'autoportraitframed' => { 368 => 0x2016 },
	'autoredeye' => { 236 => 0xfe28a44f },
	'autorotate' => { 69 => 0x1b },
	'autoshadows' => { 412 => 'AutoShadows' },
	'autowhiteversion' => { 412 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 198 => 0x82 },
	'avaperturesetting' => { 295 => 0x13 },
	'averageblacklevel' => { 40 => 0xe7, 42 => 0xfb, 43 => 0x114, 44 => 0x146 },
	'averagelv' => { 167 => 0x38 },
	'avsettingwithoutlens' => { 75 => 0x707 },
	'azimuth' => { 148 => 'Azimuth' },
	'babyage' => { 280 => [0x8010,0x33] },
	'babyname' => { 280 => 0x66 },
	'backgroundalpha' => { 431 => 'bgalpha' },
	'baseexposurecompensation' => { 295 => 0x15 },
	'baseiso' => { 69 => 0x2, 88 => 0x101c, 123 => 0x903, 282 => 0x312a, 393 => 0x6 },
	'baselineexposure' => { 109 => 0xc62a },
	'baselineexposureoffset' => { 109 => 0xc7a5 },
	'baselinenoise' => { 109 => 0xc62b },
	'baselinesharpness' => { 109 => 0xc62c },
	'baseurl' => { 434 => 'BaseURL' },
	'batterylevel' => { 356 => 0x51, 360 => 0xc, 361 => 0x4, 362 => 0x4, 394 => 0x7 },
	'batterylevelgrip1' => { 394 => 0x6 },
	'batterylevelgrip2' => { 394 => 0x8 },
	'batteryorder' => { 243 => '12.5', 252 => '13.2', 253 => '2.1', 256 => '3.1' },
	'batterystate' => { 164 => 0x60, 356 => 0x50, 362 => 0x14 },
	'batterytemperature' => { 360 => 0x1, 362 => 0x2, 394 => 0x5 },
	'batteryunknown' => { 360 => 0x2, 362 => 0x0 },
	'batteryvoltage' => { 123 => 0x408, 335 => 0x2a, 360 => 0x8 },
	'batteryvoltage1' => { 362 => 0x6 },
	'batteryvoltage2' => { 362 => 0x8 },
	'bayergreensplit' => { 109 => 0xc62d },
	'bayerpattern' => { 122 => 0xf902, 168 => 0x17 },
	'beatspliceparams' => { 436 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 436 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 436 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 436 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 436 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 436 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 243 => '13.1', 244 => '5.4', 245 => '0.1', 248 => '2.1', 249 => '3.1', 250 => '3.1', 252 => '10.1', 254 => '0.1', 256 => '5.5', 257 => '4.1' },
	'beeppitch' => { 253 => '3.1' },
	'beepvolume' => { 253 => '4.5' },
	'bestqualityscale' => { 109 => 0xc65c },
	'bestshotmode' => { 104 => 0x3007 },
	'bitdepth' => { 145 => 'BitDepth', 168 => 0x11, 205 => 0x41 },
	'bitspercomponent' => { 119 => 0x87 },
	'bitspersample' => { 109 => 0x102, 432 => 'BitsPerSample' },
	'blacklevel' => { 109 => 0xc61a, 198 => 0x3d, 264 => [0x401,0x1012], 323 => 0x21d },
	'blacklevel1' => { 284 => 0x8 },
	'blacklevel2' => { 263 => 0x600, 267 => 0x600, 284 => 0x9 },
	'blacklevel3' => { 284 => 0xa },
	'blacklevelblue' => { 284 => 0x1e },
	'blackleveldata' => { 323 => 0x223 },
	'blackleveldeltah' => { 109 => 0xc61b },
	'blackleveldeltav' => { 109 => 0xc61c },
	'blacklevelgreen' => { 284 => 0x1d },
	'blacklevelred' => { 284 => 0x1c },
	'blacklevelrepeatdim' => { 109 => 0xc619 },
	'blackpoint' => { 314 => 0x200 },
	'blacks2012' => { 412 => 'Blacks2012' },
	'bleachbypasstoning' => { 314 => 0x7f },
	'blockshotafresponse' => { 246 => '1.5', 247 => '1.5' },
	'blogtitle' => { 426 => 'blogTitle' },
	'blogurl' => { 426 => 'blogURL' },
	'bluebalance' => { 181 => 0x271, 264 => 0x1018, 284 => 0x12, 314 => 0x1b },
	'bluecurvelimits' => { 99 => 0x1fe },
	'bluecurvepoints' => { 98 => 0x79, 99 => 0x1d4 },
	'bluehsl' => { 94 => [0x20914,0x20915] },
	'bluehue' => { 412 => 'BlueHue' },
	'bluesaturation' => { 412 => 'BlueSaturation' },
	'blurcontrol' => { 314 => 0x82 },
	'blurwarning' => { 114 => 0x1300 },
	'bodybatteryadload' => { 293 => 0x3 },
	'bodybatteryadnoload' => { 293 => 0x2 },
	'bodybatterystate' => { 293 => '1.1' },
	'bodybatteryvoltage1' => { 293 => 0x2 },
	'bodybatteryvoltage2' => { 293 => 0x4 },
	'bodybatteryvoltage3' => { 293 => 0x6 },
	'bodybatteryvoltage4' => { 293 => 0x8 },
	'bodyfirmware' => { 340 => 0x0 },
	'bodyfirmwareversion' => { 260 => 0x104, 261 => 0x100, 264 => 0x104 },
	'bodyserialnumber' => { 340 => 0x10 },
	'bookedition' => { 426 => 'bookEdition' },
	'bracketmode' => { 51 => 0x3 },
	'bracketsequence' => { 104 => 0x301d },
	'bracketsettings' => { 280 => 0x45 },
	'bracketshotnumber' => { 51 => 0x5, 295 => 0x9, 367 => 0x2b },
	'bracketshotnumber2' => { 367 => 0x2d },
	'bracketstep' => { 161 => 0xe },
	'bracketvalue' => { 51 => 0x4 },
	'brightness' => { 109 => 0xfe53, 139 => 'Brightness', 157 => 'Brightness', 161 => 0x2c, 200 => 0x34, 201 => 0x39, 335 => 0x25, 356 => 0x22, 368 => 0x2007, 412 => 'Brightness' },
	'brightnessadj' => { 99 => 0x114, 229 => 0x0, 239 => 0x2d, 397 => 0x8018 },
	'brightnessvalue' => { 109 => 0x9203, 167 => [0x691,0x49c3], 264 => 0x1003, 372 => 0x1e, 375 => 0x1140, 376 => 0x1140, 377 => 0x111c, 378 => 0x1198, 379 => 0x1174, 380 => 0x102c, 381 => 0x224, 382 => 0x224, 416 => 'BrightnessValue' },
	'bulbduration' => { 69 => 0x18 },
	'burstmode' => { 125 => 0xa, 280 => 0x2a },
	'burstmode2' => { 125 => 0x18 },
	'burstshot' => { 348 => 0x34 },
	'burstspeed' => { 280 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 75 => 0x70a },
	'bwfilter' => { 161 => 0x2a, 169 => 0x39 },
	'bwmode' => { 264 => 0x203 },
	'by-line' => { 117 => 0x50 },
	'by-linetitle' => { 117 => 0x55 },
	'bytecount' => { 426 => 'byteCount' },
	'calibration' => { 348 => [0x24,0x30] },
	'calibrationilluminant1' => { 109 => 0xc65a },
	'calibrationilluminant2' => { 109 => 0xc65b },
	'cameraangle' => { 436 => 'cameraAngle' },
	'cameracalibration1' => { 109 => 0xc623 },
	'cameracalibration2' => { 109 => 0xc624 },
	'cameracalibrationsig' => { 109 => 0xc6f3 },
	'cameracolorcalibration01' => { 35 => 0x0, 41 => 0xba },
	'cameracolorcalibration02' => { 35 => 0x4, 41 => 0xbf },
	'cameracolorcalibration03' => { 35 => 0x8, 41 => 0xc4 },
	'cameracolorcalibration04' => { 35 => 0xc, 41 => 0xc9 },
	'cameracolorcalibration05' => { 35 => 0x10, 41 => 0xce },
	'cameracolorcalibration06' => { 35 => 0x14, 41 => 0xd3 },
	'cameracolorcalibration07' => { 35 => 0x18, 41 => 0xd8 },
	'cameracolorcalibration08' => { 35 => 0x1c, 41 => 0xdd },
	'cameracolorcalibration09' => { 35 => 0x20, 41 => 0xe2 },
	'cameracolorcalibration10' => { 35 => 0x24, 41 => 0xe7 },
	'cameracolorcalibration11' => { 35 => 0x28, 41 => 0xec },
	'cameracolorcalibration12' => { 35 => 0x2c, 41 => 0xf1 },
	'cameracolorcalibration13' => { 35 => 0x30, 41 => 0xf6 },
	'cameracolorcalibration14' => { 35 => 0x34, 41 => 0xfb },
	'cameracolorcalibration15' => { 35 => 0x38, 41 => 0x100 },
	'camerae-mountversion' => { 396 => 0xb },
	'cameraelevationangle' => { 109 => 0x9405 },
	'cameraid' => { 264 => 0x209, 347 => 0x209 },
	'cameraiso' => { 33 => 0x10 },
	'cameralabel' => { 109 => 0xc7a1, 436 => 'cameraLabel' },
	'cameramodel' => { 323 => 0x410, 436 => 'cameraModel' },
	'cameramodelid' => { 157 => 'CameraModelID' },
	'cameramove' => { 436 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 27 => 0x35, 28 => 0x96, 280 => 0x8f, 318 => 0x1, 323 => 0x100, 362 => [0x16,0x18], 385 => 0x28, 386 => 0x24, 387 => 0x29 },
	'cameraowner' => { 126 => 0xc353 },
	'cameraparameters' => { 264 => 0x2050 },
	'camerapicturestyle' => { 27 => 0xaf },
	'camerapitch' => { 106 => 0x9 },
	'cameraprofile' => { 412 => 'CameraProfile' },
	'cameraprofiledigest' => { 412 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 100 => 0xe1 },
	'camerarawcontrast' => { 100 => 0xe3 },
	'camerarawhighlightpoint' => { 100 => 0xe6 },
	'camerarawlinear' => { 100 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 100 => 0xe8 },
	'camerarawoutputshadowpoint' => { 100 => 0xe9 },
	'camerarawsaturation' => { 100 => 0xe2 },
	'camerarawshadowpoint' => { 100 => 0xe7 },
	'camerarawsharpness' => { 100 => 0xe5 },
	'cameraroll' => { 106 => 0xb },
	'cameraserialnumber' => { 109 => 0xc62f, 159 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 259 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x19, 28 => 0x1b, 29 => [0x87,0x91], 30 => [0x99,0x9f,0xa4,0xa8,0x105], 32 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 69 => 0xc, 123 => 0x406, 263 => 0x1306, 276 => 0x320, 282 => 0x3402, 314 => 0x47, 345 => 0x43, 389 => 0x5 },
	'cameratemperature4' => { 319 => 0x14 },
	'cameratemperature5' => { 319 => 0x16 },
	'cameratemperaturerangemax' => { 111 => 0x5 },
	'cameratemperaturerangemin' => { 111 => 0x6 },
	'cameratype' => { 69 => 0x1a, 264 => 0x207 },
	'cameratype2' => { 260 => 0x100 },
	'camerayaw' => { 106 => 0xa },
	'canondr4' => { 110 => 'CanonDR4' },
	'canonexposuremode' => { 33 => 0x14 },
	'canonfiledescription' => { 88 => 0x805 },
	'canonfilelength' => { 57 => 0xe },
	'canonfirmwareversion' => { 57 => 0x7, 88 => 0x80b },
	'canonflashinfo' => { 88 => 0x1028 },
	'canonflashmode' => { 33 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 33 => 0xa },
	'canonimagetype' => { 57 => 0x6, 88 => 0x815 },
	'canonmodelid' => { 57 => 0x10, 88 => 0x1834 },
	'canonvrd' => { 110 => 'CanonVRD' },
	'caption' => { 406 => 'caption' },
	'caption-abstract' => { 117 => 0x78 },
	'captionsauthornames' => { 415 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 415 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 424 => 'CaptionWriter' },
	'captureframerate' => { 104 => 0x4001 },
	'capturesoftware' => { 401 => 'CaptureSoftware' },
	'cardshutterlock' => { 164 => 0x49 },
	'casioimagesize' => { 104 => 0x9 },
	'catalogsets' => { 117 => 0xff, 400 => 'CatalogSets', 404 => 'CatalogSets' },
	'categories' => { 57 => 0x23, 406 => 'categories' },
	'category' => { 117 => 0xf, 258 => 0x30, 424 => 'Category' },
	'cbcrgain' => { 345 => 0xa036 },
	'cbcrgaindefault' => { 345 => 0xa035 },
	'cbcrmatrix' => { 345 => 0xa034 },
	'cbcrmatrixdefault' => { 345 => 0xa033 },
	'ccdboardversion' => { 276 => 0x331 },
	'ccdscanmode' => { 264 => 0x1039 },
	'ccdsensitivity' => { 226 => 0x6 },
	'ccdversion' => { 276 => 0x330 },
	'cellglobalid' => { 410 => 'cgi' },
	'celllength' => { 109 => 0x109 },
	'cellr' => { 410 => 'r' },
	'celltowerid' => { 410 => 'cellid' },
	'cellwidth' => { 109 => 0x108 },
	'centerafarea' => { 254 => '15.1' },
	'centerfocuspoint' => { 257 => '2.2' },
	'centerweightedareasize' => { 243 => '7.1', 244 => '8.1', 246 => '8.1', 247 => '8.1', 251 => '7.1', 252 => '5.1', 253 => '7.1', 254 => '6.3', 256 => '8.1', 257 => '8.1' },
	'certificate' => { 440 => 'Certificate' },
	'cfapattern' => { 109 => 0xa302, 416 => 'CFAPattern' },
	'cfapattern2' => { 109 => 0x828e },
	'cfapatterncolumns' => { 416 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 416 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 416 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 109 => 0x828d },
	'channel' => { 426 => 'channel' },
	'channela-lang' => { 426 => [\'channel','channelA-lang'] },
	'channelchannel' => { 426 => [\'channel','channelChannel'] },
	'channels' => { 138 => 'Channels' },
	'channelsubchannel1' => { 426 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 426 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 426 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 426 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 94 => 0x10101, 99 => 0x26a },
	'checkmark2' => { 100 => 0x8e },
	'childfontfiles' => { 441 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 243 => '10.3', 244 => '11.2' },
	'chromablurradius' => { 109 => 0xc631 },
	'chromaticaberration' => { 94 => 0x20703, 100 => 0x66, 345 => 0xa051 },
	'chromaticaberrationb' => { 412 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 94 => 0x20708, 100 => 0x6b },
	'chromaticaberrationcorr' => { 71 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 304 => 0x1 },
	'chromaticaberrationcorrparams' => { 109 => 0x7035 },
	'chromaticaberrationon' => { 94 => '0x20703.0', 100 => 0x62 },
	'chromaticaberrationr' => { 412 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 94 => 0x20707, 100 => 0x6a },
	'chromaticaberrationsetting' => { 72 => 0x6 },
	'chrominancenoisereduction' => { 94 => 0x20601, 100 => 0x5e, 348 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 100 => 0x60 },
	'circgradbasedcorractive' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 412 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 412 => 'CircularGradientBasedCorrections' },
	'city' => { 117 => 0x5a, 144 => 'City', 280 => 0x6d, 424 => 'City' },
	'city2' => { 280 => 0x80 },
	'clarity' => { 201 => 0x35, 412 => 'Clarity' },
	'clarity2012' => { 412 => 'Clarity2012' },
	'classifystate' => { 117 => 0xe1 },
	'clearretouch' => { 280 => 0x7c },
	'clearretouchvalue' => { 280 => 0xa3 },
	'client' => { 436 => 'client' },
	'clientname' => { 418 => 'ClientName' },
	'clmodeshootingspeed' => { 243 => '10.2', 244 => '11.3', 246 => '11.2', 247 => '11.2', 252 => '11.2', 253 => '10.2', 256 => '11.2', 257 => '11.1' },
	'cmcontrast' => { 267 => 0x2022 },
	'cmexposurecompensation' => { 267 => 0x2000 },
	'cmhue' => { 267 => 0x2021 },
	'cmsaturation' => { 267 => 0x2020 },
	'cmsharpness' => { 267 => 0x2023 },
	'cmwhitebalance' => { 267 => 0x2001 },
	'cmwhitebalancecomp' => { 267 => 0x2002 },
	'cmwhitebalancegraypoint' => { 267 => 0x2010 },
	'codec' => { 152 => 'Codec' },
	'codedcharacterset' => { 118 => 0x5a },
	'collectionname' => { 153 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 153 => 'Collections', 406 => 'collections' },
	'collectionuri' => { 153 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 425 => 'color' },
	'coloraberrationcontrol' => { 236 => 0xc89224b },
	'coloradjustment' => { 348 => 0x14 },
	'coloradjustmentmode' => { 347 => 0x210 },
	'coloranta' => { 441 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 441 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 441 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 441 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 441 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 441 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 441 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 441 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 441 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 441 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 441 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 441 => 'Colorants' },
	'colorantswatchname' => { 441 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 441 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 441 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 441 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 139 => 'ColorBalance' },
	'colorbalanceadj' => { 236 => 0x76a43202 },
	'colorbalanceblue' => { 161 => 0x1e },
	'colorbalancegreen' => { 161 => 0x1d },
	'colorbalancered' => { 161 => 0x1c },
	'colorbalanceversion' => { 182 => 0x0 },
	'colorblur' => { 100 => 0x65 },
	'colorbluron' => { 94 => 0x20704 },
	'colorbooster' => { 236 => 0x5f0e7d23 },
	'colorboostlevel' => { 230 => 0x1 },
	'colorboosttype' => { 230 => 0x0 },
	'colorclass' => { 325 => 0xde, 326 => 'ColorClass' },
	'colorcompensationfilter' => { 164 => [0x3a,0x5f], 166 => 0x111, 368 => 0xb022 },
	'colorcompensationfiltercustom' => { 356 => 0xd, 357 => 0xc },
	'colorcompensationfilterset' => { 356 => 0x8, 357 => 0x7, 358 => 0x18, 372 => 0xf },
	'colorcontrol' => { 264 => 0x102b },
	'colorcorrection' => { 397 => 0x8015 },
	'colorcreatoreffect' => { 259 => 0x532 },
	'colordataversion' => { 39 => 0x0, 40 => 0x0, 42 => 0x0, 43 => 0x0, 44 => 0x0 },
	'coloreffect' => { 280 => 0x28 },
	'colorfilter' => { 103 => 0x17, 104 => 0x3017, 161 => 0x29, 169 => [0x38,0x4d,0x4f], 321 => 0x17 },
	'colorgain' => { 205 => 0x51 },
	'colorhue' => { 94 => 0x20900, 198 => 0x8d },
	'colorimetricreference' => { 109 => 0xc6bf },
	'colorlabel' => { 415 => 'ColorLabel' },
	'colormatrix' => { 263 => 0x200, 264 => 0x1011, 345 => 0xa030 },
	'colormatrix1' => { 109 => 0xc621, 323 => 0x106 },
	'colormatrix2' => { 109 => 0xc622, 267 => 0x200, 323 => 0x226 },
	'colormatrixa' => { 314 => 0x203 },
	'colormatrixadobergb' => { 345 => 0xa032 },
	'colormatrixb' => { 314 => 0x204 },
	'colormatrixnumber' => { 264 => 0x1019 },
	'colormatrixsrgb' => { 345 => 0xa031 },
	'colormode' => { 104 => 0x3015, 114 => 0x1210, 125 => 0x66, 161 => 0x28, 164 => 0x16, 166 => 0x101, 167 => 0x36, 169 => 0x7, 198 => 0x3, 226 => 0x4, 280 => 0x32, 348 => 0x2c, 368 => 0xb029, 424 => 'ColorMode' },
	'colormoirereduction' => { 237 => 0x15 },
	'colormoirereductionmode' => { 237 => 0x5 },
	'colornoisereduction' => { 397 => 0x8029, 412 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 412 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 237 => 0x18 },
	'colornoisereductionsharpness' => { 237 => 0x1c },
	'colornoisereductionsmoothness' => { 412 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 113 => 0x2 },
	'colorprofile' => { 161 => 0x33 },
	'colorprofilesettings' => { 259 => 0x539 },
	'colorrepresentation' => { 119 => 0x3c },
	'colorsaturationadj' => { 94 => 0x20305 },
	'colorsequence' => { 119 => 0x41 },
	'colorspace' => { 45 => 0x3, 57 => 0xb4, 88 => 0x10b4, 109 => 0xa001, 145 => 'ColorSpace', 162 => 0x2f, 163 => 0x25, 164 => 0x17, 198 => 0x1e, 259 => 0x507, 314 => 0x37, 345 => 0xa011, 348 => 0xb, 356 => 0x1b, 357 => 0x83, 358 => 0xe, 372 => 0x6, 416 => 'ColorSpace' },
	'colortempasshot' => { 36 => 0x4, 37 => 0x1d, 38 => 0x26, 39 => 0x43, 42 => 0x43, 43 => 0x43, 44 => 0x43 },
	'colortempauto' => { 36 => 0x9, 37 => 0x22, 38 => 0x1c, 39 => 0x48, 42 => 0x48, 43 => 0x48, 44 => 0x48 },
	'colortempcloudy' => { 36 => 0x22, 37 => 0x31, 38 => 0x35, 39 => 0x5c, 42 => 0x75, 43 => 0x8e, 44 => 0x93, 314 => 0x55 },
	'colortempcustom' => { 39 => 0x84 },
	'colortempcustom1' => { 37 => 0x45 },
	'colortempcustom2' => { 37 => 0x4a },
	'colortempdaylight' => { 36 => 0x18, 37 => 0x27, 38 => 0x2b, 39 => 0x52, 42 => 0x6b, 43 => 0x84, 44 => 0x89, 314 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x135, 27 => 0x7b, 28 => 0x13a, 57 => 0xae, 67 => 0x9, 88 => 0x10ae, 114 => 0x1005, 123 => 0x846, 139 => 'ColorTemperature', 162 => [0x6e,0x49], 163 => 0x3f, 164 => [0x39,0x5e], 166 => 0x10b, 169 => [0x3c,0x4c,0x4e], 276 => 0x321, 314 => 0x50, 339 => 0x1308, 368 => 0xb021, 412 => 'Temperature' },
	'colortemperatureadj' => { 397 => 0x8013 },
	'colortemperaturebg' => { 264 => 0x1013 },
	'colortemperaturecustom' => { 356 => 0xc, 357 => 0xb },
	'colortemperaturerg' => { 264 => 0x1014 },
	'colortemperatureset' => { 356 => 0x7, 357 => 0x6 },
	'colortemperaturesetting' => { 164 => 0x25, 358 => 0x17, 372 => 0xe },
	'colortempflash' => { 36 => 0x36, 37 => 0x40, 38 => 0x49, 39 => 0x70, 42 => 0x89, 43 => 0xa2, 44 => 0xa7, 314 => 0x5a },
	'colortempflashdata' => { 39 => 0x24a },
	'colortempfluorescent' => { 36 => 0x2c, 37 => 0x3b, 38 => 0x3f, 39 => 0x66, 42 => 0x7f, 43 => 0x98, 44 => 0x9d },
	'colortempfluorescentd' => { 314 => 0x57 },
	'colortempfluorescentn' => { 314 => 0x58 },
	'colortempfluorescentw' => { 314 => 0x59 },
	'colortempkelvin' => { 36 => 0x31, 38 => 0x44, 39 => 0x6b, 42 => 0x84, 43 => 0x9d, 44 => 0xa2, 280 => 0x44, 339 => 0x1307 },
	'colortempmeasured' => { 36 => 0xe, 39 => 0x4d, 42 => 0x4d, 43 => 0x4d, 44 => 0x4d },
	'colortemppc1' => { 38 => 0x94, 39 => 0x75 },
	'colortemppc2' => { 38 => 0x99, 39 => 0x7a },
	'colortemppc3' => { 38 => 0x9e, 39 => 0x7f },
	'colortempshade' => { 36 => 0x1d, 37 => 0x2c, 38 => 0x30, 39 => 0x57, 42 => 0x70, 43 => 0x89, 44 => 0x8e, 314 => 0x54 },
	'colortemptungsten' => { 36 => 0x27, 37 => 0x36, 38 => 0x3a, 39 => 0x61, 42 => 0x7a, 43 => 0x93, 44 => 0x98, 314 => 0x56 },
	'colortempunknown' => { 36 => 0x13, 38 => 0x21, 42 => 0x52, 43 => 0x52, 44 => 0x52 },
	'colortempunknown10' => { 36 => 0x63, 38 => 0x76, 42 => 0xa2, 43 => 0x7f, 44 => 0x7f },
	'colortempunknown11' => { 36 => 0x68, 38 => 0x7b, 42 => 0xa7, 43 => 0xa7, 44 => 0x84 },
	'colortempunknown12' => { 36 => 0x6d, 38 => 0x80, 42 => 0xac, 43 => 0xac, 44 => 0xac },
	'colortempunknown13' => { 36 => 0x72, 38 => 0x85, 42 => 0xb1, 43 => 0xb1, 44 => 0xb1 },
	'colortempunknown14' => { 38 => 0x8a, 42 => 0xb6, 43 => 0xb6, 44 => 0xb6 },
	'colortempunknown15' => { 38 => 0x8f, 42 => 0xbb, 43 => 0xbb, 44 => 0xbb },
	'colortempunknown16' => { 38 => 0xa3, 43 => 0xc0, 44 => 0xc0 },
	'colortempunknown17' => { 43 => 0xc5, 44 => 0xc5 },
	'colortempunknown18' => { 43 => 0xca, 44 => 0xca },
	'colortempunknown19' => { 43 => 0xcf, 44 => 0xcf },
	'colortempunknown2' => { 36 => 0x3b, 38 => 0x4e, 42 => 0x57, 43 => 0x57, 44 => 0x57 },
	'colortempunknown20' => { 43 => 0xd4, 44 => 0xd4 },
	'colortempunknown21' => { 44 => 0xd9 },
	'colortempunknown22' => { 44 => 0xde },
	'colortempunknown23' => { 44 => 0xe3 },
	'colortempunknown24' => { 44 => 0xe8 },
	'colortempunknown25' => { 44 => 0xed },
	'colortempunknown26' => { 44 => 0xf2 },
	'colortempunknown27' => { 44 => 0xf7 },
	'colortempunknown28' => { 44 => 0xfc },
	'colortempunknown29' => { 44 => 0x101 },
	'colortempunknown3' => { 36 => 0x40, 38 => 0x53, 42 => 0x5c, 43 => 0x5c, 44 => 0x5c },
	'colortempunknown30' => { 44 => 0x106 },
	'colortempunknown4' => { 36 => 0x45, 38 => 0x58, 42 => 0x61, 43 => 0x61, 44 => 0x61 },
	'colortempunknown5' => { 36 => 0x4a, 38 => 0x5d, 42 => 0x66, 43 => 0x66, 44 => 0x66 },
	'colortempunknown6' => { 36 => 0x4f, 38 => 0x62, 42 => 0x8e, 43 => 0x6b, 44 => 0x6b },
	'colortempunknown7' => { 36 => 0x54, 38 => 0x67, 42 => 0x93, 43 => 0x70, 44 => 0x70 },
	'colortempunknown8' => { 36 => 0x59, 38 => 0x6c, 42 => 0x98, 43 => 0x75, 44 => 0x75 },
	'colortempunknown9' => { 36 => 0x5e, 38 => 0x71, 42 => 0x9d, 43 => 0x7a, 44 => 0x7a },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 33 => 0x2a, 45 => 0x2 },
	'colortoneadj' => { 94 => 0x20304, 99 => 0x11e },
	'colortoneauto' => { 64 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 63 => 0x6c, 64 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 63 => 0x3c, 64 => 0x3c },
	'colortonemonochrome' => { 63 => 0x84, 64 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 63 => 0x54, 64 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 63 => 0x24, 64 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 63 => 0xc, 64 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 63 => 0x9c, 64 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 63 => 0xb4, 64 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 63 => 0xcc, 64 => 0xe4 },
	'commanddials' => { 254 => '5.1' },
	'commanddialsaperturesetting' => { 243 => '17.3', 244 => '18.3', 246 => '18.3', 247 => '18.3', 252 => '33.3', 253 => '17.3', 256 => '18.3' },
	'commanddialschangemainsub' => { 243 => '17.2', 244 => '18.1', 246 => '18.1', 247 => '18.1', 252 => '33.2', 253 => '17.2', 256 => '18.1' },
	'commanddialsmenuandplayback' => { 243 => '17.4', 244 => '18.2', 246 => '18.2', 247 => '18.2', 252 => '33.4', 253 => '17.4', 256 => '18.2' },
	'commanddialsreverserotation' => { 243 => '17.1', 244 => '6.4', 246 => '6.2', 247 => '6.2', 248 => '16.2', 249 => '17.2', 252 => '33.1', 253 => '17.1', 256 => '6.2', 257 => '18.1' },
	'commanderchannel' => { 254 => '10.2', 255 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 254 => '13.1', 255 => '31.1' },
	'commandergroupa_ttlcomp' => { 257 => '32.1' },
	'commandergroupamanualoutput' => { 254 => '13.2', 255 => '28.2' },
	'commandergroupamode' => { 254 => '11.2', 255 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 254 => '14.1', 255 => '32.1' },
	'commandergroupb_ttlcomp' => { 257 => '33.1' },
	'commandergroupbmanualoutput' => { 254 => '14.2', 255 => '29.2' },
	'commandergroupbmode' => { 254 => '11.3', 255 => '29.1' },
	'commanderinternalflash' => { 254 => '11.1', 255 => '27.1' },
	'commanderinternalmanualoutput' => { 254 => '12.2', 255 => '27.2' },
	'commanderinternalttlchannel' => { 252 => '18.2' },
	'commanderinternalttlcomp' => { 254 => '12.1', 255 => '30.2', 257 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 252 => '20.1', 253 => '26.1' },
	'commanderinternalttlcompgroupa' => { 252 => '21.1', 253 => '27.1' },
	'commanderinternalttlcompgroupb' => { 252 => '22.1', 253 => '28.1' },
	'comment' => { 0 => 0x2, 110 => 'Comment', 140 => 'Comment', 272 => 'Comment' },
	'compass' => { 342 => 0x4 },
	'complianceprofile' => { 426 => 'complianceProfile' },
	'componentsconfiguration' => { 109 => 0x9101, 145 => 'Components', 416 => 'ComponentsConfiguration' },
	'componentversion' => { 88 => 0x80c },
	'composer' => { 436 => 'composer' },
	'compositionadjust' => { 313 => '0.1' },
	'compositionadjustrotation' => { 313 => 0x7 },
	'compositionadjustx' => { 313 => 0x5 },
	'compositionadjusty' => { 313 => 0x6 },
	'compressedbitsperpixel' => { 109 => 0x9102, 416 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 166 => 0x40, 264 => 0x40 },
	'compression' => { 109 => 0x103, 432 => 'Compression' },
	'compressionfactor' => { 259 => 0x50d },
	'compressionratio' => { 145 => 'Compression', 264 => 0x1034 },
	'confidencelevel' => { 407 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 99 => 0x266, 325 => 0xd6 },
	'constrainedcropwidth' => { 99 => 0x262, 325 => 0xd5 },
	'contact' => { 117 => 0x76 },
	'contactinfo' => { 425 => 'contactInfo' },
	'contentlocationcode' => { 117 => 0x1a },
	'contentlocationname' => { 117 => 0x1b },
	'contenttype' => { 426 => 'contentType' },
	'continuousbracketing' => { 164 => 0x20 },
	'continuousdrive' => { 33 => 0x5 },
	'continuousshootingspeed' => { 75 => 0x610 },
	'continuousshotlimit' => { 75 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 33 => 0xd, 103 => 0xc, 104 => [0x3012,0x20], 109 => [0xa408,0xfe54], 114 => [0x1004,0x1006], 139 => 'Contrast', 157 => 'Contrast', 161 => 0x20, 162 => 0x31, 163 => 0x27, 164 => 0x19, 169 => 0x2, 200 => 0x33, 201 => 0x37, 264 => 0x1029, 280 => 0x39, 282 => 0x300a, 314 => 0x20, 321 => 0xc, 335 => 0x24, 339 => 0x1012, 348 => 0xd, 356 => 0x1d, 357 => 0x1a, 368 => 0x2004, 412 => 'Contrast', 416 => 'Contrast' },
	'contrast2012' => { 412 => 'Contrast2012' },
	'contrastadj' => { 94 => 0x20303, 99 => 0x115, 239 => 0x2c, 397 => 0x8017 },
	'contrastauto' => { 64 => 0x90 },
	'contrastcurve' => { 198 => 0x8c },
	'contrastdetectaf' => { 173 => 0x4 },
	'contrastdetectafarea' => { 314 => 0x231 },
	'contrastdetectafinfocus' => { 173 => 0x1c },
	'contrastfaithful' => { 18 => 0xec, 63 => 0x60, 64 => 0x60 },
	'contrasthighlight' => { 314 => 0x6d },
	'contrasthighlightshadowadj' => { 314 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 63 => 0x30, 64 => 0x30 },
	'contrastmode' => { 280 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 63 => 0x78, 64 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 63 => 0x48, 64 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 63 => 0x18, 64 => 0x18 },
	'contrastsetting' => { 259 => 0x505, 267 => 0x1012, 358 => 0x10, 372 => 0x8 },
	'contrastshadow' => { 314 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 63 => 0x0, 64 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 63 => 0x90, 64 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 63 => 0xa8, 64 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 63 => 0xc0, 64 => 0xd8 },
	'contributedmedia' => { 436 => 'contributedMedia' },
	'contributedmediaduration' => { 436 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 436 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 436 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 436 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 436 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 436 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 436 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 436 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 436 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 436 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 413 => 'contributor' },
	'contributors' => { 140 => 'Contributors' },
	'controldialset' => { 164 => 0x46 },
	'controlledvocabularyterm' => { 422 => 'CVterm' },
	'controllerboardversion' => { 276 => 0x332 },
	'controlmode' => { 69 => 0x12 },
	'conversionlens' => { 260 => 0x403, 280 => 0x35 },
	'converter' => { 109 => 0xfe4d, 226 => 0xb, 412 => 'Converter' },
	'converttograyscale' => { 412 => 'ConvertToGrayscale' },
	'cookingequipment' => { 428 => 'cookingEquipment' },
	'cookingmethod' => { 428 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 109 => 0x8298, 140 => 'Copyright', 272 => 'Copyright', 314 => 0x22f, 330 => 'Copyright', 423 => 'Copyright', 429 => 'copyright', 432 => 'Copyright', 436 => 'copyright' },
	'copyrightflag' => { 328 => 0x40a },
	'copyrightnotice' => { 117 => 0x74 },
	'copyrightowner' => { 269 => 'CopyrightOwner' },
	'copyrightownerid' => { 269 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 269 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 269 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 269 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 269 => 'CopyrightStatus' },
	'copyrightyear' => { 426 => 'copyrightYear' },
	'coringfilter' => { 263 => 0x310, 264 => 0x102d, 267 => 0x310 },
	'coringvalues' => { 263 => 0x311, 267 => 0x311 },
	'corporateentity' => { 426 => 'corporateEntity' },
	'country' => { 144 => 'Country', 280 => 0x69, 424 => 'Country' },
	'country-primarylocationcode' => { 117 => 0x64 },
	'country-primarylocationname' => { 117 => 0x65 },
	'countrycode' => { 197 => 0x5, 326 => 'CountryCode', 421 => 'CountryCode' },
	'course' => { 428 => 'course' },
	'coverage' => { 413 => 'coverage' },
	'coverdate' => { 426 => 'coverDate' },
	'coverdisplaydate' => { 426 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 314 => 0x28 },
	'crc32' => { 414 => 'crc32' },
	'createdate' => { 109 => 0x9004, 140 => 'CreateDate', 268 => 'CreationDate', 272 => 'create-date', 330 => 'CreationDate', 332 => 0x1, 434 => 'CreateDate' },
	'creationdate' => { 423 => 'CreationDate', 426 => 'creationDate' },
	'creationtime' => { 272 => 'Creation Time' },
	'creativestyle' => { 356 => 0x1a, 357 => 0x18, 367 => 0x41, 368 => 0xb020, 393 => 0x4a },
	'creativestylesetting' => { 358 => 0xf, 372 => 0x7 },
	'creativestylewaschanged' => { 397 => 0x8001 },
	'creator' => { 268 => 'Creator', 330 => 'Creator', 413 => 'creator', 423 => 'Creator' },
	'creatoraddress' => { 421 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 159 => 'CreatorAppId' },
	'creatorcity' => { 421 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 421 => 'CreatorContactInfo' },
	'creatorcountry' => { 421 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoropenwithuioptions' => { 159 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 421 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 421 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 434 => 'CreatorTool' },
	'creatorworkemail' => { 421 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 421 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 421 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 117 => 0x6e, 424 => 'Credit' },
	'creditline' => { 429 => 'creditLine' },
	'creditlinereq' => { 439 => 'CreditLineReq' },
	'creditlinerequired' => { 269 => 'CreditLineRequired' },
	'cropactive' => { 92 => 0x0, 99 => 0x244 },
	'cropangle' => { 412 => 'CropAngle' },
	'cropaspectratio' => { 94 => 0x30101, 99 => 0x260 },
	'cropaspectratiocustom' => { 94 => 0x30102 },
	'cropbottom' => { 113 => 0x9, 231 => 0x36, 284 => 0x31, 325 => 0xdc, 412 => 'CropBottom' },
	'cropbottommargin' => { 47 => 0x3 },
	'cropcircleactive' => { 100 => 0xd6 },
	'cropcircleradius' => { 100 => 0xd9 },
	'cropcirclex' => { 100 => 0xd7 },
	'cropcircley' => { 100 => 0xd8 },
	'cropconstraintowarp' => { 412 => 'CropConstrainToWarp' },
	'croph' => { 405 => 'CropH' },
	'cropheight' => { 92 => 0x6, 99 => 0x24c, 263 => 0x615, 267 => 0x615, 412 => 'CropHeight' },
	'crophispeed' => { 198 => 0x1b },
	'cropleft' => { 99 => 0x246, 113 => 0x6, 231 => 0x1e, 263 => 0x612, 267 => 0x612, 284 => 0x30, 325 => 0xd9, 412 => 'CropLeft' },
	'cropleftmargin' => { 47 => 0x0 },
	'cropmode35mm' => { 339 => 0x1018 },
	'croporiginalheight' => { 92 => 0xb },
	'croporiginalwidth' => { 92 => 0xa },
	'cropoutputheight' => { 231 => 0xce },
	'cropoutputheightinches' => { 231 => 0x96 },
	'cropoutputpixels' => { 231 => 0xd6 },
	'cropoutputresolution' => { 231 => 0xb6 },
	'cropoutputscale' => { 231 => 0xbe },
	'cropoutputwidth' => { 231 => 0xc6 },
	'cropoutputwidthinches' => { 231 => 0x8e },
	'croppedareaimageheightpixels' => { 401 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 401 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 401 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 401 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 339 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 339 => 0x1603 },
	'cropright' => { 113 => 0x8, 231 => 0x2e, 284 => 0x32, 325 => 0xdb, 412 => 'CropRight' },
	'croprightmargin' => { 47 => 0x1 },
	'croprotatedoriginalheight' => { 92 => 0x2 },
	'croprotatedoriginalwidth' => { 92 => 0x1 },
	'croprotation' => { 92 => 0x8, 113 => 0xb },
	'cropscaledresolution' => { 231 => 0x9e },
	'cropsourceresolution' => { 231 => 0xae },
	'croptop' => { 99 => 0x248, 113 => 0x7, 231 => 0x26, 263 => 0x613, 267 => 0x613, 284 => 0x2f, 325 => 0xda, 412 => 'CropTop' },
	'croptopmargin' => { 47 => 0x2 },
	'cropunit' => { 412 => 'CropUnit' },
	'cropunits' => { 412 => 'CropUnits' },
	'cropw' => { 405 => 'CropW' },
	'cropwidth' => { 92 => 0x5, 99 => 0x24a, 263 => 0x614, 267 => 0x614, 412 => 'CropWidth' },
	'cropx' => { 92 => 0x3, 405 => 'CropX' },
	'cropy' => { 92 => 0x4, 405 => 'CropY' },
	'crossprocess' => { 314 => 0x7b },
	'crossprocessparams' => { 314 => 0x235 },
	'cuisine' => { 428 => 'cuisine' },
	'currenticcprofile' => { 109 => 0xc691 },
	'currentpreprofilematrix' => { 109 => 0xc692 },
	'currentversion' => { 397 => 0xd000 },
	'curve0x' => { 405 => 'Curve0x' },
	'curve0y' => { 405 => 'Curve0y' },
	'curve1x' => { 405 => 'Curve1x' },
	'curve1y' => { 405 => 'Curve1y' },
	'curve2x' => { 405 => 'Curve2x' },
	'curve2y' => { 405 => 'Curve2y' },
	'curve3x' => { 405 => 'Curve3x' },
	'curve3y' => { 405 => 'Curve3y' },
	'curve4x' => { 405 => 'Curve4x' },
	'curve4y' => { 405 => 'Curve4y' },
	'curves' => { 236 => 0x76a43201 },
	'custom1' => { 269 => 'Custom1' },
	'custom10' => { 269 => 'Custom10' },
	'custom2' => { 269 => 'Custom2' },
	'custom3' => { 269 => 'Custom3' },
	'custom4' => { 269 => 'Custom4' },
	'custom5' => { 269 => 'Custom5' },
	'custom6' => { 269 => 'Custom6' },
	'custom7' => { 269 => 'Custom7' },
	'custom8' => { 269 => 'Custom8' },
	'custom9' => { 269 => 'Custom9' },
	'customcolortone' => { 100 => 0x4c },
	'customcontrast' => { 100 => 0x4e },
	'customcontrols' => { 75 => 0x70c },
	'customdefaultunsharpfineness' => { 100 => 0xbe },
	'customdefaultunsharpstrength' => { 100 => 0xbc },
	'customdefaultunsharpthreshold' => { 100 => 0xc0 },
	'customlinear' => { 100 => 0x4f },
	'customoutputhighlightpoint' => { 100 => 0x53 },
	'customoutputshadowpoint' => { 100 => 0x54 },
	'custompicturestyle' => { 94 => 0x10021 },
	'custompicturestyledata' => { 94 => 0xf0500 },
	'custompicturestylefilename' => { 57 => 0x4010 },
	'customrawhighlight' => { 100 => 0x7c },
	'customrawhighlightpoint' => { 100 => 0x51 },
	'customrawshadow' => { 100 => 0x85 },
	'customrawshadowpoint' => { 100 => 0x52 },
	'customrendered' => { 109 => 0xa401, 416 => 'CustomRendered' },
	'customsaturation' => { 100 => 0x4d, 259 => 0x503 },
	'customsettingsalldefault' => { 243 => '0.2', 252 => '0.2' },
	'customsettingsbank' => { 243 => '0.1', 244 => '0.1', 246 => '0.1', 247 => '0.1', 252 => '0.1', 256 => '0.2' },
	'customsharpness' => { 100 => 0x50 },
	'customunsharpmaskfineness' => { 100 => 0xb8 },
	'customunsharpmaskstrength' => { 100 => 0xb6 },
	'customunsharpmaskthreshold' => { 100 => 0xba },
	'customwb_rblevels' => { 372 => 0x1a },
	'customwb_rgblevels' => { 357 => 0x8, 358 => 0x19 },
	'customwbbluelevel' => { 164 => 0x36 },
	'customwberror' => { 164 => 0x37 },
	'customwbgreenlevel' => { 164 => 0x35 },
	'customwbredlevel' => { 164 => 0x34 },
	'customwbsetting' => { 164 => 0x26 },
	'd-lightinghq' => { 236 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 232 => 0x2 },
	'd-lightinghqhighlight' => { 232 => 0x1 },
	'd-lightinghqselected' => { 236 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 232 => 0x0 },
	'd-lightinghs' => { 236 => 0xce5554aa },
	'd-lightinghsadjustment' => { 233 => 0x0 },
	'd-lightinghscolorboost' => { 233 => 0x1 },
	'd-rangeoptimizerhighlight' => { 397 => 0x8024 },
	'd-rangeoptimizermode' => { 397 => 0x8022 },
	'd-rangeoptimizershadow' => { 397 => 0x802d },
	'd-rangeoptimizervalue' => { 397 => 0x8023 },
	'd810meteringmode' => { 224 => 0x175e },
	'datacompressionmethod' => { 119 => 0x6e },
	'dataimprint' => { 161 => 0x34 },
	'datascaling' => { 314 => 0x3d },
	'date' => { 314 => 0x6, 413 => 'date' },
	'dateacquired' => { 159 => 'DateAcquired' },
	'datecreated' => { 117 => 0x37, 424 => 'DateCreated' },
	'datedisplayformat' => { 228 => 0x3 },
	'dateidentified' => { 108 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 248 => '4.2' },
	'daterecieved' => { 426 => 'dateRecieved' },
	'datesent' => { 118 => 0x46 },
	'datestampmode' => { 57 => 0x1c },
	'datetime' => { 406 => 'datetime', 432 => 'DateTime' },
	'datetimedigitized' => { 416 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 91 => 0x0, 109 => 0x9003, 137 => 0x14, 140 => 'OriginalDate', 335 => 0xb, 416 => 'DateTimeOriginal' },
	'datetimestamp' => { 125 => 0x64 },
	'datetimeutc' => { 259 => 0x908 },
	'daylightsavings' => { 70 => 0x3, 228 => 0x2 },
	'dccontinent' => { 108 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 108 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 108 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 108 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 108 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 108 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 108 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 108 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 108 => 'Event' },
	'dcfootprintspatialfit' => { 108 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 108 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 108 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 108 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 108 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 108 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 108 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 108 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 108 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 108 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 108 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 108 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 108 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 108 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 108 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 108 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 108 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 108 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 108 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 108 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 148 => 'Declination' },
	'decposition' => { 161 => 0x32 },
	'defaultautogray' => { 412 => 'DefaultAutoGray' },
	'defaultautotone' => { 412 => 'DefaultAutoTone' },
	'defaultblackrender' => { 109 => 0xc7a6 },
	'defaultcroporigin' => { 109 => 0xc61f },
	'defaultcropsize' => { 109 => 0xc620 },
	'defaulteraseoption' => { 75 => 0x813 },
	'defaultscale' => { 109 => 0xc61e },
	'defaultsspecifictoiso' => { 412 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 412 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 109 => 0xc7b5 },
	'defringe' => { 412 => 'Defringe' },
	'defringegreenamount' => { 412 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 412 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 412 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 412 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 412 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 412 => 'DefringePurpleHueLo' },
	'dehaze' => { 412 => 'Dehaze' },
	'deletedimagecount' => { 198 => 0xa6, 206 => 0x6e },
	'deprecatedon' => { 409 => 'deprecatedOn' },
	'derivedfrom' => { 437 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 437 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 437 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 437 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 437 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 437 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 437 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 437 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 437 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 437 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 437 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 437 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 437 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 437 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 437 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 437 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 437 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 437 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 437 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 437 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 437 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 437 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 437 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 437 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 272 => 'Description', 413 => 'description', 434 => 'Description' },
	'destination' => { 118 => 0x5 },
	'destinationcity' => { 314 => 0x24, 320 => 0x3 },
	'destinationcitycode' => { 321 => 0x1001 },
	'destinationdst' => { 314 => 0x26, 320 => '0.3' },
	'developmentdynamicrange' => { 114 => 0x1403 },
	'device' => { 426 => 'device' },
	'devicesettingdescription' => { 416 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 416 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 416 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 416 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 345 => 0x2 },
	'dialdirectiontvav' => { 75 => 0x706 },
	'dietaryneeds' => { 428 => 'dietaryNeeds' },
	'diffractioncorrection' => { 304 => 0x3 },
	'digitalcreationdate' => { 117 => 0x3e },
	'digitalcreationtime' => { 117 => 0x3f },
	'digitaldeehighlightadj' => { 205 => 0x202 },
	'digitaldeeshadowadj' => { 205 => 0x200 },
	'digitaldeethreshold' => { 205 => 0x201 },
	'digitalfilter' => { 348 => 0x59 },
	'digitalfilter01' => { 301 => 0x5 },
	'digitalfilter02' => { 301 => 0x16 },
	'digitalfilter03' => { 301 => 0x27 },
	'digitalfilter04' => { 301 => 0x38 },
	'digitalfilter05' => { 301 => 0x49 },
	'digitalfilter06' => { 301 => 0x5a },
	'digitalfilter07' => { 301 => 0x6b },
	'digitalfilter08' => { 301 => 0x7c },
	'digitalfilter09' => { 301 => 0x8d },
	'digitalfilter10' => { 301 => 0x9e },
	'digitalfilter11' => { 301 => 0xaf },
	'digitalfilter12' => { 301 => 0xc0 },
	'digitalfilter13' => { 301 => 0xd1 },
	'digitalfilter14' => { 301 => 0xe2 },
	'digitalfilter15' => { 301 => 0xf3 },
	'digitalfilter16' => { 301 => 0x104 },
	'digitalfilter17' => { 301 => 0x115 },
	'digitalfilter18' => { 301 => 0x126 },
	'digitalfilter19' => { 301 => 0x137 },
	'digitalfilter20' => { 301 => 0x148 },
	'digitalgain' => { 67 => 0xb },
	'digitalgem' => { 190 => 0x0 },
	'digitalice' => { 205 => 0x100 },
	'digitalimageguid' => { 422 => 'DigImageGUID' },
	'digitalroc' => { 203 => 0x0 },
	'digitalsourcefiletype' => { 422 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 422 => 'DigitalSourceType' },
	'digitalzoom' => { 33 => 0xc, 103 => 0xa, 125 => 0x68, 139 => 'DigitalZoom', 161 => 0xc, 198 => 0x86, 226 => 0xa, 264 => 0x204, 314 => 0x1e, 321 => 0xa, 347 => 0x204, 385 => 0x12, 386 => 0x12 },
	'digitalzoomon' => { 347 => 0x21b },
	'digitalzoomratio' => { 109 => 0xa404, 377 => 0x200, 379 => 0x21c, 416 => 'DigitalZoomRatio' },
	'director' => { 436 => 'director' },
	'directorphotography' => { 436 => 'directorPhotography' },
	'directory' => { 110 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 27 => 0x1f7, 28 => 0x4ba },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 185 => 0x3 },
	'disclaimer' => { 272 => 'Disclaimer' },
	'discnumber' => { 436 => 'discNumber' },
	'dishtype' => { 428 => 'dishType' },
	'displayallafpoints' => { 75 => 0x514 },
	'displayaperture' => { 33 => 0x23 },
	'displayedunitsx' => { 329 => 0x2 },
	'displayedunitsy' => { 329 => 0x6 },
	'displayname' => { 425 => 'displayName' },
	'distance1' => { 125 => 0x28 },
	'distance2' => { 125 => 0x2c },
	'distance3' => { 125 => 0x30 },
	'distance4' => { 125 => 0x34 },
	'distortion' => { 345 => 0xa050 },
	'distortioncontrol' => { 206 => 0x10 },
	'distortioncorrection' => { 94 => 0x20705, 100 => 0x67, 259 => 0x50b, 283 => '7.1', 304 => 0x0, 392 => 0x601, 393 => 0x5b },
	'distortioncorrection2' => { 263 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 408 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 94 => '0x20705.0', 100 => 0x63 },
	'distortioncorrectionsetting' => { 368 => 0x2013 },
	'distortioncorrparams' => { 109 => 0x7037 },
	'distortioneffect' => { 94 => 0x20709 },
	'distortionn' => { 283 => 0xc },
	'distortionparam02' => { 283 => 0x2 },
	'distortionparam04' => { 283 => 0x4 },
	'distortionparam08' => { 283 => 0x8 },
	'distortionparam09' => { 283 => 0x9 },
	'distortionparam11' => { 283 => 0xb },
	'distortionscale' => { 283 => 0x5 },
	'distributor' => { 426 => 'distributor' },
	'distributorproductid' => { 425 => 'distributorProductID' },
	'dloon' => { 94 => '0x20706.0', 100 => 0xdc },
	'dlosetting' => { 94 => 0x20706, 100 => 0xdd },
	'dlosettingapplied' => { 93 => 0x4 },
	'dloshootingdistance' => { 100 => 0xde },
	'dloversion' => { 93 => 0x5 },
	'dmcomment' => { 436 => 'comment' },
	'dngadobedata' => { 109 => 0xc634 },
	'dngbackwardversion' => { 109 => 0xc613 },
	'dngignoresidecars' => { 412 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 109 => 0xc630 },
	'dngprivatedata' => { 109 => 0xc634 },
	'dngversion' => { 109 => 0xc612 },
	'document' => { 272 => 'Document' },
	'documentancestors' => { 424 => 'DocumentAncestors' },
	'documenthistory' => { 117 => 0xe7 },
	'documentid' => { 437 => 'DocumentID' },
	'documentname' => { 109 => 0x10d },
	'documentnotes' => { 117 => 0xe6 },
	'doi' => { 426 => 'doi' },
	'dpp' => { 406 => 'dpp' },
	'dr4cameramodel' => { 95 => 0x3 },
	'drivemode' => { 104 => 0x3103, 161 => 0x6, 164 => 0x1e, 167 => 0xe, 259 => 0x600, 314 => 0x34, 339 => 0x1002, 348 => 0x3, 356 => 0x4, 357 => 0x7e, 358 => 0x34 },
	'drivemode2' => { 164 => 0xa, 295 => 0x7, 367 => 0xe, 372 => 0x1 },
	'drivemodesetting' => { 358 => 0x4 },
	'dspfirmwareversion' => { 314 => 0x27 },
	'duration' => { 60 => 0x6a, 138 => 'Duration', 152 => 'Duration', 428 => 'duration', 436 => 'duration' },
	'durationscale' => { 436 => [\'duration','durationScale'] },
	'durationvalue' => { 436 => [\'duration','durationValue'] },
	'dustremovaldata' => { 57 => 0x97 },
	'dynamicafarea' => { 243 => '1.4', 252 => '1.4' },
	'dynamicareaafdisplay' => { 244 => '46.1', 246 => '47.1', 247 => '47.1', 256 => '47.1' },
	'dynamicrange' => { 114 => 0x1400 },
	'dynamicrangeexpansion' => { 314 => 0x69, 339 => 0x100e },
	'dynamicrangemax' => { 99 => 0x7c },
	'dynamicrangemin' => { 99 => 0x7a },
	'dynamicrangeoptimizer' => { 164 => 0x15, 368 => [0xb025,0xb04f], 375 => 0x1144, 376 => [0x1144,0x324], 377 => [0x1120,0x300], 378 => [0x119c,0x37c], 379 => [0x1178,0x328], 380 => [0x1030,0x50], 381 => [0x228,0x50], 382 => [0x228,0x50] },
	'dynamicrangeoptimizerbracket' => { 367 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 356 => 0x19, 357 => 0x17, 358 => 0xd, 367 => 0x79, 372 => 0x5 },
	'dynamicrangeoptimizermode' => { 167 => 0x15, 356 => 0x18, 357 => 0x16, 367 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 164 => 0x27, 358 => 0xc, 372 => 0x4 },
	'dynamicrangesetting' => { 114 => 0x1402 },
	'e-dialinprogram' => { 295 => '1.3' },
	'earliestageorloweststage' => { 108 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 108 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 108 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 108 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 108 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 257 => '6.1' },
	'easyexposurecompensation' => { 243 => '6.4', 244 => '6.5', 246 => '6.3', 247 => '6.3', 251 => '5.1', 252 => '4.4', 253 => '5.2', 256 => '6.3' },
	'easymode' => { 33 => 0xb },
	'edgenoisereduction' => { 237 => 0x4, 397 => 0x8028 },
	'edition' => { 426 => 'edition' },
	'editorialupdate' => { 117 => 0x8 },
	'editstatus' => { 117 => 0x7, 326 => 'EditStatus', 406 => 'EditStatus' },
	'editversionname' => { 236 => 0x3d136244 },
	'effectivelv' => { 314 => 0x2d },
	'effectivemaxaperture' => { 194 => 0x12, 195 => 0x13 },
	'eissn' => { 426 => 'eIssn' },
	'electronicfront-curtainshutter' => { 246 => '5.2', 247 => '5.2', 256 => '5.3' },
	'elevation' => { 148 => 'Elevation' },
	'email' => { 140 => 'EMail' },
	'embargodate' => { 429 => 'embargoDate' },
	'embdencrightsexpr' => { 422 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 422 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 422 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 422 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 424 => 'EmbeddedXMPDigest' },
	'emissivity' => { 111 => 0x3 },
	'encryptionkey' => { 345 => 0xa020 },
	'endingpage' => { 426 => 'endingPage' },
	'enduser' => { 269 => 'EndUser' },
	'enduserid' => { 269 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 269 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 436 => 'engineer' },
	'enhancedarktones' => { 229 => 0x8 },
	'enhancement' => { 103 => 0x16, 104 => 0x3016 },
	'enhancer' => { 263 => 0x300 },
	'enhancervalues' => { 263 => 0x301 },
	'envelopenumber' => { 118 => 0x28 },
	'envelopepriority' => { 118 => 0x3c },
	'enveloperecordversion' => { 118 => 0x0 },
	'epsonimageheight' => { 264 => 0x20c },
	'epsonimagewidth' => { 264 => 0x20b },
	'epsonsoftware' => { 264 => 0x20d },
	'equipmentinstitution' => { 399 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 399 => 'EquipmentManufacturer' },
	'equipmentversion' => { 260 => 0x0 },
	'ettlii' => { 75 => 0x304, 76 => 0xd, 77 => 0xe, 78 => 0x7, 79 => 0x7, 80 => 0xe },
	'event' => { 400 => 'Event', 404 => 'Event', 422 => 'Event', 426 => 'event' },
	'eventalias' => { 425 => 'eventAlias' },
	'eventday' => { 108 => [\'Event','EventDay'] },
	'eventearliestdate' => { 108 => [\'Event','EventEarliestDate'] },
	'eventend' => { 425 => 'eventEnd' },
	'eventenddayofyear' => { 108 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 108 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 108 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 108 => [\'Event','EventHabitat'] },
	'eventid' => { 108 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 108 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 108 => [\'Event','EventMonth'] },
	'eventnumber' => { 335 => 0x9 },
	'eventremarks' => { 108 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 108 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 108 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 425 => 'eventStart' },
	'eventstartdayofyear' => { 108 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 425 => 'eventSubtype' },
	'eventtime' => { 108 => [\'Event','EventEventTime'] },
	'eventtype' => { 425 => 'eventType' },
	'eventverbatimeventdate' => { 108 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 108 => [\'Event','EventYear'] },
	'evsteps' => { 295 => '1.2', 297 => 0x0 },
	'evstepsize' => { 248 => '5.1', 249 => '6.1', 250 => '6.1', 254 => '0.7' },
	'exclusivityenddate' => { 429 => 'exclusivityEndDate' },
	'excursiontolerance' => { 119 => 0x82 },
	'exif' => { 110 => 'EXIF' },
	'exifbyteorder' => { 110 => 'ExifByteOrder' },
	'exifcamerainfo' => { 117 => 0xe8 },
	'exifimageheight' => { 109 => 0xa003, 416 => 'PixelYDimension' },
	'exifimagewidth' => { 109 => 0xa002, 416 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 110 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 109 => 0x9000, 416 => 'ExifVersion' },
	'exitpupilposition' => { 194 => 0x4, 195 => 0x4 },
	'expirationdate' => { 117 => 0x25, 429 => 'expirationDate' },
	'expirationtime' => { 117 => 0x26 },
	'exposure' => { 109 => 0xfe51, 412 => 'Exposure' },
	'exposure2012' => { 412 => 'Exposure2012' },
	'exposureadj' => { 234 => 0x0 },
	'exposureadj2' => { 234 => 0x12 },
	'exposureadjust' => { 348 => 0xc },
	'exposurebracketingindicatorlast' => { 164 => 0x52 },
	'exposurebracketshotnumber' => { 167 => 0x2d, 367 => 0x2f },
	'exposurebracketstepsize' => { 295 => 0x8 },
	'exposurebracketvalue' => { 198 => 0x19 },
	'exposurecompensation' => { 69 => 0x6, 84 => 0x0, 109 => 0x9204, 125 => 0x24, 139 => 'ExposureComp', 157 => 'ExposureCompensation', 161 => 0xd, 162 => 0x53, 163 => 0x1e, 167 => 0x49c0, 264 => 0x1006, 314 => 0x16, 323 => 0x402, 345 => 0xa013, 348 => [0xc,0x35,0x4d], 375 => 0x114c, 376 => 0x114c, 377 => 0x1128, 379 => 0x1180, 380 => 0x1038, 381 => 0x230, 382 => 0x230, 416 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 372 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 164 => 0x47, 167 => 0x2a },
	'exposurecompensationset' => { 356 => 0x3, 357 => 0x3, 358 => 0x3, 372 => 0x1e },
	'exposurecompensationsetting' => { 164 => 0x1 },
	'exposurecompstepsize' => { 243 => '6.3', 244 => '7.3', 246 => '7.3', 247 => '7.3', 252 => '4.3', 256 => '7.3' },
	'exposurecontrolstep' => { 251 => '6.1', 253 => '6.1' },
	'exposurecontrolstepsize' => { 243 => '6.2', 244 => '7.1', 246 => '7.1', 247 => '7.1', 252 => '4.2', 256 => '7.1', 257 => '7.1' },
	'exposurecount' => { 114 => 0x1032 },
	'exposuredelaymode' => { 243 => '10.1', 244 => '11.1', 246 => '11.1', 247 => '11.1', 248 => '9.1', 249 => '10.1', 250 => '10.1', 252 => '10.4', 253 => '10.1', 254 => '6.4', 256 => '11.1', 257 => '11.2' },
	'exposuredifference' => { 198 => 0xe },
	'exposureindex' => { 109 => 0xa215, 416 => 'ExposureIndex' },
	'exposureindicator' => { 164 => 0x50 },
	'exposurelevelincrements' => { 73 => 0x6, 74 => 0x6, 75 => 0x101, 76 => 0x5, 77 => 0x6, 78 => 0x5, 79 => 0x5, 80 => 0x6, 81 => 0x4, 356 => 0x58, 357 => 0x58 },
	'exposurelockused' => { 401 => 'ExposureLockUsed' },
	'exposuremode' => { 109 => 0xa402, 139 => 'ExposureMode', 161 => 0x1, 162 => 0xa, 163 => 0x0, 164 => 0x0, 167 => 0x34, 259 => 0x200, 278 => 0x40d, 348 => 0x8, 368 => 0xb041, 416 => 'ExposureMode' },
	'exposuremodeinmanual' => { 75 => 0x10b },
	'exposureprogram' => { 109 => 0x8822, 339 => 0x1001, 349 => [0x17e,0x43], 356 => 0x3c, 357 => 0x3c, 358 => 0x5, 362 => 0x14, 367 => 0x3f, 372 => 0x2, 375 => 0x1175, 376 => 0x1179, 377 => 0x1155, 378 => 0x11d1, 379 => 0x11ad, 380 => 0x1065, 381 => 0x25d, 382 => 0x25d, 393 => 0x48, 416 => 'ExposureProgram' },
	'exposureshift' => { 259 => 0x203 },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x6, 30 => 0x7, 69 => 0x16, 109 => 0x829a, 122 => 0xfd05, 125 => 0x20, 127 => 0xfa24, 129 => 0xf104, 132 => 0x12, 134 => 0x38, 137 => 0x10, 139 => 'ExposureTime', 161 => 0x9, 162 => 0x35, 163 => 0x48, 164 => 0x8, 167 => 0x49b8, 314 => 0x12, 345 => 0xa018, 348 => [0x32,0x4a], 356 => 0x0, 357 => 0x0, 372 => [0x21,0x23,0x27], 393 => 0x10, 416 => 'ExposureTime' },
	'exposuretime2' => { 348 => [0x33,0x4b] },
	'exposuretuning' => { 198 => 0x1c },
	'exposurevalue' => { 123 => 0x3 },
	'exposurewarning' => { 114 => 0x1302 },
	'exrauto' => { 114 => 0x1033 },
	'exrmode' => { 114 => 0x1034 },
	'extendedwbdetect' => { 259 => 0x902 },
	'extender' => { 260 => 0x301 },
	'extenderfirmwareversion' => { 260 => 0x304 },
	'extendermagnification' => { 141 => 'Magnification' },
	'extendermake' => { 141 => 'Make' },
	'extendermodel' => { 141 => 'Model', 260 => 0x303 },
	'extenderserialnumber' => { 141 => 'SerialNumber', 260 => 0x302 },
	'extenderstatus' => { 312 => 0x3 },
	'externalflash' => { 262 => 0x1201 },
	'externalflashae1' => { 264 => 0x101f },
	'externalflashae1_0' => { 264 => 0x101b },
	'externalflashae2' => { 264 => 0x1020 },
	'externalflashae2_0' => { 264 => 0x101c },
	'externalflashbounce' => { 262 => 0x1204, 264 => 0x1026, 302 => 0x1a },
	'externalflashcompensation' => { 188 => 0x1b },
	'externalflashexposurecomp' => { 198 => 0x17, 302 => 0x19 },
	'externalflashfirmware' => { 186 => 0x6, 187 => 0x6, 188 => 0x6 },
	'externalflashflags' => { 186 => 0x8, 187 => 0x8, 188 => 0x8 },
	'externalflashguidenumber' => { 262 => 0x1203, 302 => '24.1' },
	'externalflashgvalue' => { 264 => 0x1025 },
	'externalflashmode' => { 264 => 0x1028, 302 => 0x2 },
	'externalflashstatus' => { 189 => 0x8 },
	'externalflashzoom' => { 262 => 0x1205, 264 => 0x1027 },
	'externalsensorbrightnessvalue' => { 276 => 0x311, 282 => 0x3408 },
	'extrainfoversion' => { 360 => 0x1a },
	'eyestartaf' => { 164 => 0x40 },
	'face10position' => { 101 => 0x3f4, 102 => 0x1ec, 184 => 0x28, 299 => 0x12 },
	'face10size' => { 300 => 0x12 },
	'face11position' => { 184 => 0x2c, 299 => 0x14 },
	'face11size' => { 300 => 0x14 },
	'face12position' => { 184 => 0x30, 299 => 0x16 },
	'face12size' => { 300 => 0x16 },
	'face13position' => { 299 => 0x18 },
	'face13size' => { 300 => 0x18 },
	'face14position' => { 299 => 0x1a },
	'face14size' => { 300 => 0x1a },
	'face15position' => { 299 => 0x1c },
	'face15size' => { 300 => 0x1c },
	'face16position' => { 299 => 0x1e },
	'face16size' => { 300 => 0x1e },
	'face17position' => { 299 => 0x20 },
	'face17size' => { 300 => 0x20 },
	'face18position' => { 299 => 0x22 },
	'face18size' => { 300 => 0x22 },
	'face19position' => { 299 => 0x24 },
	'face19size' => { 300 => 0x24 },
	'face1position' => { 48 => 0x8, 101 => 0xd, 102 => 0x18, 184 => 0x4, 274 => 0x1, 299 => 0x0, 336 => 0xbc, 363 => 0x1, 364 => 0x0, 365 => 0x0, 366 => 0x5b },
	'face1size' => { 300 => 0x0 },
	'face20position' => { 299 => 0x26 },
	'face20size' => { 300 => 0x26 },
	'face21position' => { 299 => 0x28 },
	'face21size' => { 300 => 0x28 },
	'face22position' => { 299 => 0x2a },
	'face22size' => { 300 => 0x2a },
	'face23position' => { 299 => 0x2c },
	'face23size' => { 300 => 0x2c },
	'face24position' => { 299 => 0x2e },
	'face24size' => { 300 => 0x2e },
	'face25position' => { 299 => 0x30 },
	'face25size' => { 300 => 0x30 },
	'face26position' => { 299 => 0x32 },
	'face26size' => { 300 => 0x32 },
	'face27position' => { 299 => 0x34 },
	'face27size' => { 300 => 0x34 },
	'face28position' => { 299 => 0x36 },
	'face28size' => { 300 => 0x36 },
	'face29position' => { 299 => 0x38 },
	'face29size' => { 300 => 0x38 },
	'face2position' => { 48 => 0xa, 101 => 0x7c, 102 => 0x4c, 184 => 0x8, 274 => 0x5, 299 => 0x2, 336 => 0xc8, 363 => 0x6, 364 => 0x20, 365 => 0x25, 366 => 0x65 },
	'face2size' => { 300 => 0x2 },
	'face30position' => { 299 => 0x3a },
	'face30size' => { 300 => 0x3a },
	'face31position' => { 299 => 0x3c },
	'face31size' => { 300 => 0x3c },
	'face32position' => { 299 => 0x3e },
	'face32size' => { 300 => 0x3e },
	'face3position' => { 48 => 0xc, 101 => 0xeb, 102 => 0x80, 184 => 0xc, 274 => 0x9, 299 => 0x4, 336 => 0xd4, 363 => 0xb, 364 => 0x40, 365 => 0x4a, 366 => 0x6f },
	'face3size' => { 300 => 0x4 },
	'face4position' => { 48 => 0xe, 101 => 0x15a, 102 => 0xb4, 184 => 0x10, 274 => 0xd, 299 => 0x6, 336 => 0xe0, 363 => 0x10, 364 => 0x60, 365 => 0x6f, 366 => 0x79 },
	'face4size' => { 300 => 0x6 },
	'face5position' => { 48 => 0x10, 101 => 0x1c9, 102 => 0xe8, 184 => 0x14, 274 => 0x11, 299 => 0x8, 336 => 0xec, 363 => 0x15, 364 => 0x80, 365 => 0x94 },
	'face5size' => { 300 => 0x8 },
	'face6position' => { 48 => 0x12, 101 => 0x238, 102 => 0x11c, 184 => 0x18, 299 => 0xa, 336 => 0xf8, 363 => 0x1a, 364 => 0xa0, 365 => 0xb9 },
	'face6size' => { 300 => 0xa },
	'face7position' => { 48 => 0x14, 101 => 0x2a7, 102 => 0x150, 184 => 0x1c, 299 => 0xc, 336 => 0x104, 363 => 0x1f, 364 => 0xc0, 365 => 0xde },
	'face7size' => { 300 => 0xc },
	'face8position' => { 48 => 0x16, 101 => 0x316, 102 => 0x184, 184 => 0x20, 299 => 0xe, 336 => 0x110, 363 => 0x24, 364 => 0xe0, 365 => 0x103 },
	'face8size' => { 300 => 0xe },
	'face9position' => { 48 => 0x18, 101 => 0x385, 102 => 0x1b8, 184 => 0x24, 299 => 0x10 },
	'face9size' => { 300 => 0x10 },
	'facedetect' => { 314 => 0x76, 345 => 0x100 },
	'facedetectarea' => { 263 => 0x1201 },
	'facedetectframecrop' => { 263 => 0x1207 },
	'facedetectframesize' => { 48 => 0x3, 101 => 0x1, 102 => 0x4, 184 => 0x1, 263 => 0x1203, 314 => 0x77, 336 => 0xb6 },
	'facedetection' => { 358 => 0x30, 372 => 0x19 },
	'faceid' => { 407 => 'FaceID' },
	'faceinfounknown' => { 104 => 0x2089 },
	'facename' => { 345 => 0x123 },
	'faceorientation' => { 102 => 0x8 },
	'faceposition' => { 298 => 0x2, 346 => 0x4 },
	'facepositions' => { 114 => 0x4103 },
	'facerecognition' => { 345 => 0x120 },
	'facesdetected' => { 48 => 0x2, 49 => 0x2, 50 => 0x3, 101 => 0x0, 102 => 0x2, 104 => 0x211c, 114 => 0x4100, 184 => 0x3, 263 => 0x1200, 280 => 0x3f, 298 => 0x0, 336 => 0xb5, 346 => 0x0, 363 => 0x0, 366 => 0x3, 374 => 0x30 },
	'facesrecognized' => { 275 => 0x0 },
	'facewidth' => { 49 => 0x1 },
	'faithfuloutputhighlightpoint' => { 100 => 0x38 },
	'faithfuloutputshadowpoint' => { 100 => 0x39 },
	'faithfulrawcolortone' => { 100 => 0x31 },
	'faithfulrawcontrast' => { 100 => 0x33 },
	'faithfulrawhighlight' => { 100 => 0x79 },
	'faithfulrawhighlightpoint' => { 100 => 0x36 },
	'faithfulrawlinear' => { 100 => 0x34 },
	'faithfulrawsaturation' => { 100 => 0x32 },
	'faithfulrawshadow' => { 100 => 0x82 },
	'faithfulrawshadowpoint' => { 100 => 0x37 },
	'faithfulrawsharpness' => { 100 => 0x35 },
	'faithfulunsharpmaskfineness' => { 100 => 0xac },
	'faithfulunsharpmaskstrength' => { 100 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 100 => 0xae },
	'femicroadjustment' => { 75 => 0x111 },
	'ffid' => { 414 => 'ffid' },
	'field' => { 425 => 'field' },
	'fieldcount' => { 264 => 0x103f },
	'filecreatedate' => { 110 => 'FileCreateDate' },
	'filedatarate' => { 436 => 'fileDataRate' },
	'fileformat' => { 86 => 0x0, 118 => 0x14, 348 => [0x22,0x26], 368 => 0xb000 },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 27 => 0x1eb, 28 => 0x4ae, 281 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 110 => 'FileModifyDate' },
	'filename' => { 110 => 'FileName' },
	'filenameasdelivered' => { 269 => 'FileNameAsDelivered' },
	'filenumber' => { 51 => 0x1, 57 => 0x8, 88 => 0x1817, 105 => 'FileNumber', 185 => 0x4 },
	'filenumbermemory' => { 161 => 0x1a },
	'filenumbersequence' => { 243 => '12.2', 248 => '3.1', 249 => '4.1', 250 => '4.1', 252 => '11.1', 253 => '4.3', 257 => '5.2' },
	'filepermissions' => { 110 => 'FilePermissions' },
	'filesource' => { 109 => 0xa300, 114 => 0x8000, 416 => 'FileSource' },
	'fileversion' => { 118 => 0x16 },
	'fillflashautoreduction' => { 73 => 0xe, 74 => 0xe, 81 => 0xa },
	'filllight' => { 412 => 'FillLight' },
	'fillorder' => { 109 => 0x10a },
	'filmgraineffect' => { 259 => 0x538 },
	'filmmode' => { 114 => 0x1401, 278 => 0x412, 280 => 0x42 },
	'filmtype' => { 205 => 0x2 },
	'filtereffect' => { 51 => 0xe, 200 => 0x37, 201 => 0x3f },
	'filtereffectauto' => { 64 => 0xa0 },
	'filtereffectfaithful' => { 63 => 0x70, 64 => 0x70 },
	'filtereffectlandscape' => { 63 => 0x40, 64 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 63 => 0x88, 64 => 0x88 },
	'filtereffectneutral' => { 63 => 0x58, 64 => 0x58 },
	'filtereffectportrait' => { 63 => 0x28, 64 => 0x28 },
	'filtereffectstandard' => { 63 => 0x10, 64 => 0x10 },
	'filtereffectuserdef1' => { 63 => 0xa0, 64 => 0xb8 },
	'filtereffectuserdef2' => { 63 => 0xb8, 64 => 0xd0 },
	'filtereffectuserdef3' => { 63 => 0xd0, 64 => 0xe8 },
	'finderdisplayduringexposure' => { 74 => 0x1 },
	'finesharpness' => { 314 => 0x70 },
	'finetuneoptcenterweighted' => { 243 => '7.2', 244 => '9.1', 246 => '9.1', 247 => '9.1', 251 => '8.1', 256 => '9.1', 257 => '9.1' },
	'finetuneopthighlightweighted' => { 246 => '46.1', 247 => '46.1', 256 => '46.1' },
	'finetuneoptmatrixmetering' => { 243 => '8.1', 244 => '8.2', 246 => '8.2', 247 => '8.2', 251 => '7.2', 252 => '6.1', 256 => '8.2', 257 => '8.2' },
	'finetuneoptspotmetering' => { 243 => '8.2', 244 => '9.2', 246 => '9.2', 247 => '9.2', 251 => '8.2', 252 => '6.2', 256 => '9.2', 257 => '9.2' },
	'firmware' => { 264 => 0x405, 348 => [0x17,0x3b,0x57], 408 => 'Firmware' },
	'firmwaredate' => { 103 => 0x15, 104 => 0x2001, 335 => 0x4 },
	'firmwareid' => { 168 => 0x0 },
	'firmwarename' => { 345 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 57 => 0x1e, 337 => 0x0 },
	'firmwarerevision2' => { 337 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 123 => 0xce5, 137 => 0x57, 139 => 'FirmwareVersion', 280 => 0x2, 282 => 0x3109, 314 => 0x230, 339 => 0x2 },
	'firmwareversions' => { 323 => 0x301 },
	'firstphotodate' => { 401 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 269 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 117 => 0x16, 406 => 'FixtureIdentifier' },
	'flash' => { 105 => 'Flash', 109 => 0x9209, 162 => 0x1f, 163 => 0x15, 416 => 'Flash' },
	'flashaction' => { 356 => 0x3e, 357 => 0x3e, 368 => 0x2017, 372 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 356 => 0x4c, 357 => 0x4c, 372 => 0x77 },
	'flashactionexternal' => { 372 => [0x78,0x7c] },
	'flashactivity' => { 33 => 0x1c },
	'flashbatterylevel' => { 39 => 0x249 },
	'flashbias' => { 280 => 0x24 },
	'flashbits' => { 33 => 0x1d },
	'flashbuttonfunction' => { 75 => 0x70e },
	'flashchargelevel' => { 264 => 0x1010 },
	'flashcolorfilter' => { 188 => 0x10 },
	'flashcommandermode' => { 186 => '9.1', 187 => '9.1', 188 => '9.1' },
	'flashcompensation' => { 186 => 0xa, 187 => 0xa, 188 => 0xa, 408 => 'FlashCompensation' },
	'flashcontrol' => { 356 => 0x23, 357 => 0x1f, 358 => 0x21 },
	'flashcontrolbuilt-in' => { 252 => '16.1', 253 => '23.1', 255 => '23.1', 256 => '24.1' },
	'flashcontrolmode' => { 186 => '9.2', 187 => '9.2', 188 => '9.2', 259 => 0x404 },
	'flashcurtain' => { 280 => 0x48 },
	'flashdefault' => { 164 => 0x42 },
	'flashdevice' => { 264 => 0x1005 },
	'flashdistance' => { 104 => 0x2034 },
	'flashenergy' => { 109 => 0xa20b, 416 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 198 => 0x18 },
	'flashexposurecomp' => { 69 => 0xf, 114 => 0x1011, 142 => 'ExposureComp', 161 => 0x23, 166 => 0x104, 167 => 0x49c1, 198 => 0x12, 259 => 0x401, 264 => 0x1023, 314 => 0x4d, 339 => 0x100b, 348 => [0x3a,0x56], 368 => 0x104 },
	'flashexposurecomp2' => { 223 => 0x4d2 },
	'flashexposurecomp3' => { 188 => 0x1d },
	'flashexposurecomp4' => { 188 => 0x27 },
	'flashexposurecomparea' => { 244 => '38.4', 246 => '38.4', 247 => '38.4', 256 => '38.4' },
	'flashexposurecompset' => { 164 => 0x10, 287 => 0xe, 356 => 0x14, 357 => 0x12, 358 => 0x23, 372 => 0x1f },
	'flashexposurecompset2' => { 372 => [0x26,0x2c] },
	'flashexposureindicator' => { 164 => 0x54 },
	'flashexposureindicatorlast' => { 164 => 0x56 },
	'flashexposureindicatornext' => { 164 => 0x55 },
	'flashexposurelock' => { 51 => 0x19 },
	'flashfired' => { 125 => 0x5d, 142 => 'Fired', 161 => 0x14, 222 => '590.3', 280 => 0x8007, 416 => [\'Flash','FlashFired'] },
	'flashfiring' => { 75 => 0x306, 76 => 0x6, 77 => 0x7, 80 => 0x7 },
	'flashfirmwareversion' => { 260 => 0x1002 },
	'flashfocallength' => { 186 => 0xb, 187 => 0xc, 188 => 0xc },
	'flashfunction' => { 167 => 0x31, 416 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 186 => 0xe, 187 => 0xf, 188 => 0xf },
	'flashgroupacompensation' => { 186 => 0x11, 187 => 0x12, 188 => 0x13 },
	'flashgroupacontrolmode' => { 186 => 0xf, 187 => '16.1', 188 => '17.1' },
	'flashgroupaoutput' => { 186 => 0x11, 187 => 0x12, 188 => 0x13 },
	'flashgroupbcompensation' => { 186 => 0x12, 187 => 0x13, 188 => 0x14 },
	'flashgroupbcontrolmode' => { 186 => 0x10, 187 => '17.1', 188 => '18.1' },
	'flashgroupboutput' => { 186 => 0x12, 187 => 0x13, 188 => 0x14 },
	'flashgroupccompensation' => { 187 => 0x14, 188 => 0x15 },
	'flashgroupccontrolmode' => { 187 => '17.2', 188 => '18.2' },
	'flashgroupcoutput' => { 187 => 0x14, 188 => 0x15 },
	'flashguidenumber' => { 69 => 0xd, 85 => 0x0, 142 => 'GuideNumber' },
	'flashintensity' => { 103 => [0x19,0x5], 259 => 0x405 },
	'flashlevel' => { 245 => 0x9, 368 => 0xb048 },
	'flashmake' => { 142 => 'Make' },
	'flashmanufacturer' => { 159 => 'FlashManufacturer' },
	'flashmetering' => { 161 => 0x3f, 164 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 27 => 0x15 },
	'flashmeteringsegments' => { 314 => 0x20a },
	'flashmode' => { 103 => 0x4, 125 => 0x5c, 142 => 'Mode', 161 => 0x2, 162 => 0x20, 163 => 0x16, 164 => 0xf, 198 => 0x87, 259 => 0x400, 264 => 0x1004, 314 => 0xc, 321 => 0x4, 338 => 0x20, 339 => 0x100a, 347 => 0x225, 356 => 0x13, 357 => 0x7f, 358 => 0x20, 372 => 0x10, 375 => 0x1138, 376 => 0x1138, 377 => 0x1114, 378 => 0x1190, 379 => 0x116c, 380 => 0x1024, 381 => 0x21c, 382 => 0x21c, 416 => [\'Flash','FlashMode'] },
	'flashmodel' => { 142 => 'Model', 159 => 'FlashModel', 260 => 0x1001 },
	'flashoptions' => { 295 => 0x2 },
	'flashoptions2' => { 295 => 0x10 },
	'flashoutput' => { 39 => 0x248, 69 => 0x21, 186 => 0xa, 187 => 0xa, 188 => 0xa },
	'flashpixversion' => { 109 => 0xa000, 416 => 'FlashpixVersion' },
	'flashredeyemode' => { 416 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 259 => 0x403 },
	'flashreturn' => { 416 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 142 => 'SerialNumber', 260 => 0x1003 },
	'flashsetting' => { 198 => 0x8 },
	'flashshutterspeed' => { 243 => '20.2', 244 => '23.2', 246 => '23.2', 247 => '23.2', 252 => '15.2', 253 => '22.2', 254 => '7.2', 255 => '22.2', 256 => '23.2', 257 => '23.1' },
	'flashsource' => { 186 => 0x4, 187 => 0x4, 188 => 0x4 },
	'flashstatus' => { 302 => 0x0, 372 => [0x82,0x86], 384 => [0x31,0x39] },
	'flashstatusbuilt-in' => { 358 => [0x87,0x287] },
	'flashstatusexternal' => { 358 => [0x88,0x288] },
	'flashsyncspeed' => { 243 => '20.1', 244 => '23.1', 246 => '23.1', 247 => '23.1', 252 => '15.1', 253 => '22.1', 255 => '22.1', 256 => '23.1' },
	'flashsyncspeedav' => { 73 => 0x3, 75 => 0x10f, 76 => 0x2, 77 => 0x3, 78 => 0x2, 79 => 0x2, 80 => 0x3, 81 => 0x6 },
	'flashthreshold' => { 85 => 0x1 },
	'flashtype' => { 142 => 'Type', 164 => 0x59, 198 => 0x9, 260 => 0x1000 },
	'flashwarning' => { 253 => '30.1', 254 => '7.1', 257 => '31.1', 280 => 0x62 },
	'flexiblespotposition' => { 368 => 0x201d },
	'flickerreduce' => { 347 => 0x218 },
	'flickerreduction' => { 216 => 0xe84 },
	'flickerreductionindicator' => { 216 => 0x5e2 },
	'fliphorizontal' => { 236 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x5, 30 => 0x6, 69 => 0x15, 109 => 0x829d, 122 => 0xfd04, 125 => 0x1e, 127 => 0xfa23, 129 => 0xf103, 132 => 0x13, 134 => 0x3c, 137 => 0xc, 146 => 'FNumber', 161 => 0xa, 162 => 0x36, 163 => 0x47, 164 => 0x9, 167 => 0x49c7, 314 => 0x13, 345 => 0xa019, 348 => [0x31,0x49], 356 => 0x1, 357 => 0x1, 372 => [0x20,0x22,0x26], 416 => 'FNumber' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x1e, 28 => 0x23, 53 => 0x1, 104 => 0x1d, 109 => 0x920a, 132 => 0x1d, 146 => 'FocalLength', 161 => 0x12, 194 => 0xa, 195 => 0xb, 314 => 0x1d, 323 => 0x403, 339 => 0x1500, 355 => 0xe, 379 => 0x1278, 380 => 0x1134, 381 => 0x32c, 382 => 0x32c, 416 => 'FocalLength' },
	'focallength2' => { 372 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 109 => 0xa405, 345 => 0xa01a, 416 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 355 => 0x10 },
	'focalplaneafpointarea' => { 383 => 0x2 },
	'focalplaneafpointlocation1' => { 383 => 0x6 },
	'focalplaneafpointlocation10' => { 383 => 0x2a },
	'focalplaneafpointlocation11' => { 383 => 0x2e },
	'focalplaneafpointlocation12' => { 383 => 0x32 },
	'focalplaneafpointlocation13' => { 383 => 0x36 },
	'focalplaneafpointlocation14' => { 383 => 0x3a },
	'focalplaneafpointlocation15' => { 383 => 0x3e },
	'focalplaneafpointlocation2' => { 383 => 0xa },
	'focalplaneafpointlocation3' => { 383 => 0xe },
	'focalplaneafpointlocation4' => { 383 => 0x12 },
	'focalplaneafpointlocation5' => { 383 => 0x16 },
	'focalplaneafpointlocation6' => { 383 => 0x1a },
	'focalplaneafpointlocation7' => { 383 => 0x1e },
	'focalplaneafpointlocation8' => { 383 => 0x22 },
	'focalplaneafpointlocation9' => { 383 => 0x26 },
	'focalplaneafpointsused' => { 383 => 0x1 },
	'focalplanediagonal' => { 260 => 0x103, 264 => 0x205 },
	'focalplaneresolutionunit' => { 109 => 0xa210, 416 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 109 => 0xa20e, 416 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 53 => 0x2 },
	'focalplanexunknown' => { 53 => 0x2 },
	'focalplaneyresolution' => { 109 => 0xa20f, 416 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 53 => 0x3 },
	'focalplaneyunknown' => { 53 => 0x3 },
	'focaltype' => { 9 => 0x2d, 53 => 0x0 },
	'focalunits' => { 33 => 0x19 },
	'focus' => { 226 => 0x8 },
	'focusarea' => { 161 => 0x31 },
	'focusareaselection' => { 254 => '15.2' },
	'focuscontinuous' => { 33 => 0x20 },
	'focusdisplayaiservoandmf' => { 75 => 0x515 },
	'focusdistance' => { 146 => 'FocusDistance', 161 => 0x13, 167 => 0x49bb, 194 => 0x9, 195 => 0xa, 262 => 0x305 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0xa7, 27 => 0x56, 28 => 0xa7, 51 => 0x15, 69 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0xa5, 27 => 0x54, 28 => 0xa5, 51 => 0x14, 69 => 0x13 },
	'focusholdbutton' => { 164 => 0x44 },
	'focusinfoversion' => { 262 => 0x0 },
	'focusingscreen' => { 74 => 0x0, 75 => 0x80b, 80 => 0x0 },
	'focuslocation' => { 368 => 0x2027 },
	'focuslocked' => { 160 => 0x14 },
	'focusmode' => { 33 => 0x7, 103 => 0x3, 104 => [0x3003,0xd], 114 => 0x1021, 125 => 0x38, 139 => 'FocusMode', 161 => 0x30, 163 => 0xe, 164 => 0xc, 198 => 0x7, 259 => 0x301, 264 => 0x100b, 280 => 0x7, 314 => 0xd, 321 => 0x3, 339 => 0x1006, 349 => [0xb,0x5], 355 => [0x15,0x1d], 356 => 0x4d, 357 => 0x4d, 368 => [0xb042,0xb04e,0x201b], 372 => 0x13, 388 => 0x16 },
	'focusmode2' => { 295 => '3.1', 372 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 245 => '10.1', 353 => 0x14, 354 => 0x15, 356 => 0x10, 357 => 0xf, 358 => 0x6 },
	'focusmodeswitch' => { 164 => 0x58, 356 => 0x2e },
	'focuspixel' => { 114 => 0x1023 },
	'focuspointwrap' => { 243 => '2.2', 244 => '2.2', 246 => '2.1', 247 => '2.1', 251 => '1.1', 252 => '2.2', 253 => '1.1', 256 => '2.2', 257 => '2.5' },
	'focusposition' => { 194 => 0x8, 195 => 0x8, 314 => 0x10, 367 => 0x9bb },
	'focusposition2' => { 372 => [0x29,0x2b,0x2f], 388 => 0x2d, 391 => 0x20 },
	'focusprocess' => { 259 => 0x302 },
	'focusrange' => { 33 => 0x12, 264 => 0x100a },
	'focusrangeindex' => { 305 => '3.1' },
	'focussetting' => { 348 => 0x6 },
	'focusstatus' => { 355 => 0x19, 356 => 0x53, 357 => 0x53 },
	'focusstepcount' => { 262 => 0x301, 264 => 0x100e },
	'focusstepinfinity' => { 262 => 0x303, 264 => 0x103b },
	'focusstepnear' => { 262 => 0x304, 264 => 0x103c },
	'focustrackinglockon' => { 243 => ['1.5','4.1'], 244 => '1.4', 251 => '0.4', 252 => '3.1', 253 => '0.4', 256 => '1.4' },
	'focuswarning' => { 114 => 0x1301 },
	'foldername' => { 161 => 0x27 },
	'foldernumber' => { 356 => 0x9a, 358 => [0x402,0x114,0x316] },
	'fontcomposite' => { 441 => [\'Fonts','FontsComposite'] },
	'fontface' => { 441 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 441 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 441 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 441 => [\'Fonts','FontsFontName'] },
	'fonts' => { 441 => 'Fonts' },
	'fonttype' => { 441 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 441 => [\'Fonts','FontsVersionString'] },
	'for' => { 330 => 'For' },
	'format' => { 413 => 'format', 434 => 'Format' },
	'forwardlock' => { 431 => 'forwardlock' },
	'forwardmatrix1' => { 109 => 0xc714 },
	'forwardmatrix2' => { 109 => 0xc715 },
	'framecount' => { 60 => [0x2,0x4] },
	'frameheight' => { 114 => 0x3822 },
	'framenum' => { 325 => 0xd7 },
	'framenumber' => { 114 => 0x8003, 167 => 0x3c, 314 => 0x29 },
	'framerate' => { 60 => [0x1,0x6], 109 => 0xc764, 114 => 0x3820 },
	'framewidth' => { 114 => 0x3821 },
	'framing' => { 425 => 'framing' },
	'freebytes' => { 88 => 0x1 },
	'freememorycardimages' => { 162 => [0x37,0x54], 163 => [0x2d,0x4a], 164 => 0x32 },
	'fujiflashmode' => { 114 => 0x1010 },
	'fullimagesize' => { 368 => 0xb02b },
	'fullpanoheightpixels' => { 401 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 401 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 339 => 0x100d },
	'fullsizeimage' => { 145 => 'data' },
	'fullsizeimagename' => { 145 => '1Name' },
	'fullsizeimagetype' => { 145 => '0Type' },
	'func1button' => { 246 => '14.1', 247 => '14.1' },
	'func1buttonplusdials' => { 246 => '42.1', 247 => '42.1' },
	'func2button' => { 246 => '80.1', 247 => '80.1' },
	'funcbutton' => { 243 => ['14.1','15.1'], 244 => '14.1', 252 => '28.1', 253 => '13.1', 256 => '14.1', 257 => '14.1' },
	'funcbuttonplusdials' => { 243 => ['14.2','15.2'], 244 => '14.2', 252 => '31.1', 256 => '42.1' },
	'functionbutton' => { 250 => '13.1', 254 => '5.2' },
	'gainbase' => { 263 => 0x610 },
	'gaincontrol' => { 109 => 0xa407, 416 => 'GainControl' },
	'gamma' => { 109 => 0xa500, 417 => 'Gamma' },
	'gammablackpoint' => { 96 => 0xc },
	'gammacolortone' => { 96 => 0x3 },
	'gammacompensatedvalue' => { 119 => 0x91 },
	'gammacontrast' => { 96 => 0x2 },
	'gammacurveoutputrange' => { 96 => 0xf },
	'gammahighlight' => { 96 => 0xa },
	'gammalinear' => { 94 => 0x20200 },
	'gammamidpoint' => { 96 => 0xe },
	'gammasaturation' => { 96 => 0x4 },
	'gammashadow' => { 96 => 0x9 },
	'gammasharpnessstrength' => { 96 => 0x8 },
	'gammaunsharpmaskfineness' => { 96 => 0x6 },
	'gammaunsharpmaskstrength' => { 96 => 0x5 },
	'gammaunsharpmaskthreshold' => { 96 => 0x7 },
	'gammawhitepoint' => { 96 => 0xd },
	'geimagesize' => { 114 => 0x1304 },
	'gemake' => { 115 => 0x300 },
	'gemodel' => { 115 => 0x207 },
	'genre' => { 426 => 'genre', 436 => 'genre' },
	'geography' => { 427 => 'geography' },
	'geologicalcontext' => { 108 => 'GeologicalContext' },
	'geologicalcontextbed' => { 108 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 108 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 108 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 108 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 108 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 110 => 'Geosync' },
	'geotag' => { 110 => 'Geotag' },
	'geotiffasciiparams' => { 109 => 0x87b1 },
	'geotiffdirectory' => { 109 => 0x87af },
	'geotiffdoubleparams' => { 109 => 0x87b0 },
	'geotime' => { 110 => 'Geotime' },
	'globalaltitude' => { 328 => 0x419 },
	'globalangle' => { 328 => 0x40d },
	'good' => { 436 => 'good' },
	'googleplusuploadcode' => { 109 => 0x9009 },
	'gpsaltitude' => { 116 => 0x6, 143 => 'Altitude', 416 => 'GPSAltitude' },
	'gpsaltituderef' => { 116 => 0x5, 416 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 116 => 0x1c, 416 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 116 => 0x1d },
	'gpsdatetime' => { 143 => 'DateTime', 416 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 116 => 0x18, 143 => 'Bearing', 416 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 116 => 0x17, 416 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 116 => 0x1a, 143 => 'Distance', 416 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 116 => 0x19, 416 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 116 => 0x14, 416 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 116 => 0x13 },
	'gpsdestlongitude' => { 116 => 0x16, 416 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 116 => 0x15 },
	'gpsdifferential' => { 116 => 0x1e, 143 => 'Differential', 416 => 'GPSDifferential' },
	'gpsdop' => { 116 => 0xb, 416 => 'GPSDOP' },
	'gpshpositioningerror' => { 116 => 0x1f, 416 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 116 => 0x11, 416 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 116 => 0x10, 416 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 116 => 0x2, 143 => 'Latitude', 416 => 'GPSLatitude' },
	'gpslatituderef' => { 116 => 0x1 },
	'gpslongitude' => { 116 => 0x4, 143 => 'Longitude', 416 => 'GPSLongitude' },
	'gpslongituderef' => { 116 => 0x3 },
	'gpsmapdatum' => { 116 => 0x12, 143 => 'Datum', 416 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 116 => 0xa, 143 => 'MeasureMode', 416 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 116 => 0x1b, 416 => 'GPSProcessingMethod' },
	'gpssatellites' => { 116 => 0x8, 143 => 'Satellites', 416 => 'GPSSatellites' },
	'gpsspeed' => { 116 => 0xd, 143 => 'Speed', 416 => 'GPSSpeed' },
	'gpsspeedref' => { 116 => 0xc, 416 => 'GPSSpeedRef' },
	'gpsstatus' => { 116 => 0x9, 416 => 'GPSStatus' },
	'gpstimestamp' => { 116 => 0x7 },
	'gpstrack' => { 116 => 0xf, 143 => 'Heading', 416 => 'GPSTrack' },
	'gpstrackref' => { 116 => 0xe, 416 => 'GPSTrackRef' },
	'gpsversionid' => { 116 => 0x0, 416 => 'GPSVersionID' },
	'gradation' => { 259 => 0x50f },
	'gradientbasedcorractive' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 412 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 412 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 412 => 'GrainAmount' },
	'grainfrequency' => { 412 => 'GrainFrequency' },
	'grainsize' => { 412 => 'GrainSize' },
	'graymixeraqua' => { 412 => 'GrayMixerAqua' },
	'graymixerblue' => { 412 => 'GrayMixerBlue' },
	'graymixergreen' => { 412 => 'GrayMixerGreen' },
	'graymixermagenta' => { 412 => 'GrayMixerMagenta' },
	'graymixerorange' => { 412 => 'GrayMixerOrange' },
	'graymixerpurple' => { 412 => 'GrayMixerPurple' },
	'graymixerred' => { 412 => 'GrayMixerRed' },
	'graymixeryellow' => { 412 => 'GrayMixerYellow' },
	'graypoint' => { 397 => 0x8021 },
	'grayresponseunit' => { 109 => 0x122 },
	'greencurvelimits' => { 99 => 0x1c4 },
	'greencurvepoints' => { 98 => 0x53, 99 => 0x19a },
	'greenhsl' => { 94 => 0x20912 },
	'greenhue' => { 412 => 'GreenHue' },
	'greensaturation' => { 412 => 'GreenSaturation' },
	'griddisplay' => { 243 => '13.3', 244 => '4.3', 246 => '4.2', 247 => '4.2', 248 => '2.2', 252 => '10.5', 253 => '3.4', 254 => '6.1', 256 => '4.4', 257 => '4.2' },
	'gripbatteryadload' => { 293 => 0x5 },
	'gripbatteryadnoload' => { 293 => 0x4 },
	'gripbatterystate' => { 293 => '1.2' },
	'groupareaafillumination' => { 244 => '46.4', 247 => '47.4', 256 => '47.4' },
	'halftonehints' => { 109 => 0x141 },
	'hardlink' => { 110 => 'HardLink' },
	'hasalternative' => { 426 => 'hasAlternative' },
	'hascorrection' => { 426 => 'hasCorrection' },
	'hascorrectiona-lang' => { 426 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 426 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 426 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 412 => 'HasCrop' },
	'hasextendedxmp' => { 438 => 'HasExtendedXMP' },
	'hassettings' => { 412 => 'HasSettings' },
	'hastranslation' => { 426 => 'hasTranslation' },
	'hasvisibleoverprint' => { 441 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 441 => 'HasVisibleTransparency' },
	'hdr' => { 54 => 0x1, 191 => 0x4, 280 => 0x9e, 314 => 0x85, 368 => 0x200a },
	'hdreffect' => { 54 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 191 => 0x0 },
	'hdrlevel' => { 191 => 0x5, 358 => 0x2e, 372 => 0x17 },
	'hdrlevel2' => { 191 => 0x7 },
	'hdrsetting' => { 358 => 0x2d, 372 => 0x16, 375 => 0x1148, 376 => 0x1148, 377 => 0x1124, 378 => 0x11a0, 379 => 0x117c, 380 => 0x1034, 381 => 0x22c, 382 => 0x22c },
	'hdrsmoothing' => { 191 => 0x6 },
	'headline' => { 117 => 0x69, 424 => 'Headline' },
	'hierarchicalkeywords' => { 154 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 154 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 154 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 154 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 154 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 154 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 154 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 403 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 108 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 284 => 0x1a },
	'highisomultipliergreen' => { 284 => 0x19 },
	'highisomultiplierred' => { 284 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 27 => 0xc9, 56 => 0x5, 75 => 0x202, 114 => 0x100e, 198 => 0xb1, 314 => 0x71, 356 => 0x2c, 357 => 0x26, 358 => 0x26, 368 => 0x2009, 372 => 0x12, 393 => 0x42 },
	'highisonoisereduction2' => { 368 => 0xb050 },
	'highlight' => { 348 => 0xf },
	'highlightadj' => { 94 => 0x2030c },
	'highlightcolordistortreduct' => { 397 => 0x8026 },
	'highlightlinearitylimit' => { 345 => 0xa025 },
	'highlightprotection' => { 235 => 0x6 },
	'highlightrecovery' => { 412 => 'HighlightRecovery' },
	'highlights' => { 405 => 'Highlights' },
	'highlights2012' => { 412 => 'Highlights2012' },
	'highlighttone' => { 114 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 27 => 0x7, 56 => 0x3, 75 => 0x203 },
	'highlowkeyadj' => { 314 => 0x6c },
	'highspeedsync' => { 164 => 0x5, 356 => 0x2, 357 => 0x2 },
	'histogramxml' => { 236 => 0x83a1a25 },
	'history' => { 424 => 'History', 437 => 'History' },
	'historyaction' => { 437 => [\'History','HistoryAction'] },
	'historychanged' => { 437 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 437 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 437 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 437 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 437 => [\'History','HistoryWhen'] },
	'hometowncity' => { 104 => 0x3006, 314 => 0x23, 320 => 0x2 },
	'hometowncitycode' => { 321 => 0x1000 },
	'hometowndst' => { 314 => 0x25, 320 => '0.2' },
	'hostcomputer' => { 109 => 0x13c },
	'hue' => { 169 => 0x3b, 201 => 0x3d, 314 => 0x67 },
	'hueadj' => { 239 => 0x2f, 397 => 0x8019 },
	'hueadjust' => { 339 => 0x1016 },
	'hueadjustment' => { 162 => 0x4a, 163 => 0x40, 198 => 0x92, 200 => 0x36 },
	'hueadjustmentaqua' => { 412 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 412 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 412 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 412 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 412 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 412 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 412 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 412 => 'HueAdjustmentYellow' },
	'huesetting' => { 267 => 0x1011 },
	'humidity' => { 109 => 0x9401 },
	'icc_profile' => { 110 => 'ICC_Profile' },
	'iccprofilename' => { 424 => 'ICCProfile' },
	'idccreativestyle' => { 397 => 0x8000 },
	'idcpreviewlength' => { 397 => 0x202 },
	'idcpreviewstart' => { 397 => 0x201 },
	'identification' => { 108 => 'Identification' },
	'identificationid' => { 108 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 108 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 108 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 108 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 108 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 108 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 413 => 'identifier', 434 => 'Identifier' },
	'illumination' => { 254 => '0.5' },
	'imageadjustment' => { 198 => 0x80, 226 => 0x5 },
	'imagealterationconstraints' => { 269 => 'ImageAlterationConstraints' },
	'imagearea' => { 210 => 0x10, 213 => 0x10 },
	'imageareaoffset' => { 314 => 0x38 },
	'imageauthentication' => { 198 => 0x20 },
	'imageboundary' => { 198 => 0x16 },
	'imagecount' => { 114 => 0x1438, 198 => 0xa5, 370 => 0x11b, 384 => [0x32,0x3a] },
	'imagecount2' => { 384 => [0x4c,0x58] },
	'imagecount3' => { 384 => [0x1a0,0x1aa,0x1bd,0x1cb] },
	'imagecreator' => { 269 => 'ImageCreator' },
	'imagecreatorid' => { 269 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 269 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 269 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 198 => 0xa2 },
	'imagedescription' => { 109 => 0x10e, 432 => 'ImageDescription' },
	'imageduplicationconstraints' => { 269 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 236 => 0xfe443a45 },
	'imageeditcount' => { 314 => 0x41 },
	'imageediting' => { 314 => 0x32 },
	'imageeffects' => { 339 => 0x1010 },
	'imagefileconstraints' => { 269 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 269 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 269 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 114 => 0x1436 },
	'imageheight' => { 109 => 0x101, 168 => 0xc, 323 => 0x10d, 432 => 'ImageLength' },
	'imagehistory' => { 109 => 0x9213, 415 => 'ImageHistory' },
	'imageidnumber' => { 276 => 0x340 },
	'imagenumber' => { 109 => 0x9211, 139 => 'ImageNumber', 162 => 0xae, 163 => 0x5e, 323 => 0x113, 356 => 0x9b, 358 => [0x400,'276.1',0x314], 408 => 'ImageNumber' },
	'imagenumber2' => { 163 => 0x62 },
	'imageoptimization' => { 198 => 0xa9 },
	'imageorientation' => { 117 => 0x83 },
	'imageprocessing' => { 198 => 0x1a },
	'imageprocessingversion' => { 263 => 0x0 },
	'imagequality' => { 139 => 'ImageQuality', 212 => '723.2', 213 => '732.2', 222 => '708.1', 280 => 0x1 },
	'imagequality2' => { 259 => 0x603 },
	'imageref' => { 420 => 'ImageRef' },
	'imagereview' => { 245 => '0.4', 254 => '0.4' },
	'imagereviewmonitorofftime' => { 244 => '21.1', 246 => '21.1', 247 => '21.1', 251 => '20.1', 256 => '21.1' },
	'imagereviewtime' => { 243 => '25.1', 245 => '2.1', 248 => '19.1', 249 => '20.1', 250 => '20.1', 252 => '9.2', 253 => '20.1', 257 => '21.2' },
	'imagesize' => { 145 => 'ImageSize' },
	'imagesizerestriction' => { 429 => 'imageSizeRestriction' },
	'imagesourcedata' => { 109 => 0x935c },
	'imagestabilization' => { 33 => 0x22, 104 => 0x3020, 114 => 0x1422, 139 => 'ImageStabilization', 162 => 0xbd, 163 => 0x71, 164 => 0x57, 165 => 0x0, 166 => [0x18,0x107,0x113], 167 => 0x49c2, 198 => 0xac, 259 => 0x604, 262 => 0x1600, 280 => 0x1a, 361 => 0x12, 362 => 0x11, 368 => 0xb026 },
	'imagestabilization2' => { 360 => 0xa },
	'imagestabilizationsetting' => { 167 => 0x14, 356 => 0x3d, 357 => 0x3d, 367 => 0x14 },
	'imagestyle' => { 356 => 0x2d, 357 => 0x27 },
	'imagesupplier' => { 269 => 'ImageSupplier' },
	'imagesupplierid' => { 269 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 269 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 269 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 111 => 0x1 },
	'imagetemperaturemin' => { 111 => 0x2 },
	'imagetone' => { 314 => 0x4f },
	'imagetype' => { 117 => 0x82, 269 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 57 => 0x28, 109 => 0xa420, 416 => 'ImageUniqueID' },
	'imagewidth' => { 109 => 0x100, 168 => 0xe, 323 => 0x10c, 432 => 'ImageWidth' },
	'incrementaltemperature' => { 412 => 'IncrementalTemperature' },
	'incrementaltint' => { 412 => 'IncrementalTint' },
	'industry' => { 426 => 'industry', 427 => 'industry' },
	'infobuttonwhenshooting' => { 75 => 0x409 },
	'infraredilluminator' => { 335 => 0x28 },
	'ingredientexclusion' => { 428 => 'ingredientExclusion' },
	'ingredients' => { 437 => 'Ingredients' },
	'ingredientsalternatepaths' => { 437 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 437 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 437 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 437 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 437 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 437 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 437 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 437 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 437 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 437 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 437 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 437 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 437 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 437 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 437 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 437 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 437 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 437 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 437 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 437 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 437 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 437 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 437 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 75 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 401 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 401 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 401 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 401 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 401 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 243 => '4.4' },
	'initialzoomsetting' => { 243 => '9.3', 252 => '27.3' },
	'inkset' => { 109 => 0x14c },
	'inputprofile' => { 123 => 0x1389 },
	'instanceid' => { 437 => 'InstanceID' },
	'instantplaybacksetup' => { 164 => 0x3e },
	'instantplaybacktime' => { 164 => 0x3d },
	'instructions' => { 424 => 'Instructions' },
	'instrument' => { 436 => 'instrument' },
	'intellectualgenre' => { 421 => 'IntellectualGenre' },
	'intelligentauto' => { 368 => 0xb052 },
	'intelligentcontrast' => { 46 => 0x4 },
	'intelligentd-range' => { 280 => 0x79 },
	'intelligentexposure' => { 280 => 0x5d },
	'intelligentresolution' => { 280 => 0x70 },
	'interchangecolorspace' => { 119 => 0x40 },
	'internalflash' => { 161 => 0x2b, 243 => '23.1', 245 => '8.1', 248 => '22.1', 250 => '23.1', 254 => '8.1', 257 => '24.1', 262 => 0x1208 },
	'internalflashae1' => { 264 => 0x1021 },
	'internalflashae1_0' => { 264 => 0x101d },
	'internalflashae2' => { 264 => 0x1022 },
	'internalflashae2_0' => { 264 => 0x101e },
	'internalflashmode' => { 302 => 0x1 },
	'internalflashstrength' => { 302 => 0x3 },
	'internalflashtable' => { 264 => 0x1024 },
	'internallensserialnumber' => { 345 => 0xa005 },
	'internalndfilter' => { 280 => 0x9d },
	'internalserialnumber' => { 57 => 0x96, 68 => 0x9, 114 => 0x10, 167 => 0x49dc, 258 => 0x18, 260 => 0x102, 280 => 0x25, 294 => 0x4, 339 => 0x5, 384 => [0x7c,0x88,0xf0] },
	'interopindex' => { 109 => 0x1, 417 => 'InteroperabilityIndex' },
	'interopversion' => { 109 => 0x2 },
	'intervallength' => { 161 => 0x10 },
	'intervalmode' => { 161 => 0x26 },
	'intervalnumber' => { 161 => 0x11 },
	'introtime' => { 436 => 'introTime' },
	'introtimescale' => { 436 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 436 => [\'introTime','introTimeValue'] },
	'iptc' => { 110 => 'IPTC' },
	'iptc-naa' => { 109 => 0x83bb, 284 => 0x83bb },
	'iptcbitspersample' => { 119 => 0x56 },
	'iptcdigest' => { 328 => 0x425 },
	'iptcimageheight' => { 119 => 0x1e },
	'iptcimagerotation' => { 119 => 0x66 },
	'iptcimagewidth' => { 119 => 0x14 },
	'iptclastedited' => { 422 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 119 => 0xa },
	'iptcpixelheight' => { 119 => 0x32 },
	'iptcpixelwidth' => { 119 => 0x28 },
	'isalternativeof' => { 426 => 'isAlternativeOf' },
	'isbn' => { 426 => 'isbn' },
	'iscorrectionof' => { 426 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 100 => 0x3 },
	'ismergedhdr' => { 408 => 'IsMergedHDR' },
	'ismergedpanorama' => { 408 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x0, 30 => 0x1, 103 => 0x14, 104 => [0x3014,0x14], 109 => 0x8827, 122 => 0xfd06, 123 => 0x1784, 125 => 0x60, 127 => [0xfa2e,0xfa46], 128 => [0x27,0x28], 129 => 0xf105, 132 => 0x14, 134 => 0x4e, 137 => 0x34, 139 => 'ISO', 161 => 0x8, 167 => 0x49ba, 192 => 0x0, 198 => 0x2, 284 => 0x17, 314 => [0x8b,0x14], 321 => 0x14, 323 => 0x105, 345 => 0xa014, 367 => 0x6f, 372 => [0x1f,0x21,0x25], 416 => 'ISOSpeedRatings' },
	'iso2' => { 192 => 0x6, 207 => 0x265, 208 => 0x25c, 209 => 0x265, 210 => 0x221, 211 => 0x25d, 212 => 0x256, 213 => 0x25d, 217 => 0x2b5, 220 => 0x265, 225 => 0x2b5 },
	'isoauto' => { 295 => '14.4' },
	'isoautohilimit' => { 215 => 0x18eb, 216 => 0xe82, 224 => 0x185d },
	'isoautoparameters' => { 314 => 0x7a },
	'isoautoshuttertime' => { 215 => 0x18ea, 216 => 0xe81, 224 => 0x185c },
	'isodisplay' => { 246 => '4.1', 247 => '4.1', 248 => '2.3', 249 => '3.3', 250 => '3.3', 253 => '3.3', 256 => '4.3', 257 => '4.3' },
	'isoexpansion' => { 75 => 0x103, 76 => 0x7, 77 => 0x8, 80 => 0x8, 192 => 0x4 },
	'isoexpansion2' => { 192 => 0xa },
	'isofloor' => { 295 => 0x6 },
	'isoselection' => { 198 => 0xf },
	'isosensitivitystep' => { 251 => '6.2', 253 => '6.2' },
	'isosetting' => { 125 => 0x5e, 139 => 'ISOSetting', 161 => 0x24, 162 => 0x26, 163 => 0x1c, 164 => 0x13, 169 => 0x6, 198 => 0x13, 295 => '17.3', 338 => 0x27, 356 => 0x16, 357 => 0x14, 358 => 0x2, 367 => 0x6d },
	'isospeed' => { 109 => 0x8833, 417 => 'ISOSpeed' },
	'isospeedexpansion' => { 74 => 0x3 },
	'isospeedincrements' => { 75 => 0x102 },
	'isospeedlatitudeyyy' => { 109 => 0x8834, 417 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 109 => 0x8835, 417 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 75 => 0x103 },
	'isostepsize' => { 243 => '6.1', 244 => '7.2', 246 => '7.2', 247 => '7.2', 252 => '4.1', 256 => '7.2' },
	'isovalue' => { 264 => 0x1001 },
	'issn' => { 426 => 'issn' },
	'issueidentifier' => { 426 => 'issueIdentifier' },
	'issuename' => { 426 => 'issueName' },
	'issueteaser' => { 426 => 'issueTeaser' },
	'issuetype' => { 426 => 'issueType' },
	'istranslationof' => { 426 => 'isTranslationOf' },
	'jobid' => { 117 => 0xb8 },
	'jobname' => { 418 => 'JobName' },
	'jobref' => { 435 => 'JobRef' },
	'jobrefid' => { 435 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 435 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 435 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 418 => 'JobStatus' },
	'jpeghandling' => { 412 => 'JPEGHandling' },
	'jpegquality' => { 9 => 0x66, 282 => 0x3034, 368 => 0xb047 },
	'jpegsize' => { 282 => 0x303a },
	'jpgcompression' => { 216 => 0x7d4 },
	'jpgfromraw' => { 88 => 0x2007, 105 => 'JpgFromRaw', 284 => 0x2e },
	'jpgfromrawlength' => { 109 => [0x117,0x202] },
	'jpgfromrawstart' => { 109 => [0x111,0x201] },
	'jpgrecordedpixels' => { 295 => '14.1' },
	'jurisdiction' => { 409 => 'jurisdiction' },
	'kelvinwb_01' => { 303 => 0x5 },
	'kelvinwb_02' => { 303 => 0x9 },
	'kelvinwb_03' => { 303 => 0xd },
	'kelvinwb_04' => { 303 => 0x11 },
	'kelvinwb_05' => { 303 => 0x15 },
	'kelvinwb_06' => { 303 => 0x19 },
	'kelvinwb_07' => { 303 => 0x1d },
	'kelvinwb_08' => { 303 => 0x21 },
	'kelvinwb_09' => { 303 => 0x25 },
	'kelvinwb_10' => { 303 => 0x29 },
	'kelvinwb_11' => { 303 => 0x2d },
	'kelvinwb_12' => { 303 => 0x31 },
	'kelvinwb_13' => { 303 => 0x35 },
	'kelvinwb_14' => { 303 => 0x39 },
	'kelvinwb_15' => { 303 => 0x3d },
	'kelvinwb_16' => { 303 => 0x41 },
	'kelvinwb_daylight' => { 303 => 0x1 },
	'key' => { 436 => 'key' },
	'keystonecompensation' => { 263 => 0x1900 },
	'keystonedirection' => { 263 => 0x1901 },
	'keystonevalue' => { 263 => 0x1906 },
	'keyword' => { 426 => 'keyword' },
	'keywordinfo' => { 154 => 'Keywords' },
	'keywords' => { 117 => 0x19, 140 => 'Keywords', 268 => 'Keywords', 330 => 'Keywords', 406 => 'keywords', 423 => 'Keywords', 434 => 'Keywords' },
	'killdate' => { 426 => 'killDate' },
	'killdatea-platform' => { 426 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 426 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 122 => 0xf908, 125 => 0xe, 127 => [0xfa1e,0xfa52], 133 => 0x70 },
	'kodakimagewidth' => { 122 => 0xf907, 125 => 0xc, 127 => [0xfa1d,0xfa51], 133 => 0x6c },
	'kodakinfotype' => { 122 => 0xfa00 },
	'kodaklook' => { 123 => 0xe4c },
	'kodaklookprofile' => { 123 => 0x138a },
	'kodakmaker' => { 133 => 0x8 },
	'kodakmodel' => { 125 => 0x0, 133 => 0x28 },
	'label' => { 272 => 'Label', 434 => 'Label' },
	'labelname1' => { 420 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 420 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 420 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 420 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 420 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 420 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 280 => 0x6f },
	'landscapeoutputhighlightpoint' => { 100 => 0x26 },
	'landscapeoutputshadowpoint' => { 100 => 0x27 },
	'landscaperawcolortone' => { 100 => 0x1f },
	'landscaperawcontrast' => { 100 => 0x21 },
	'landscaperawhighlight' => { 100 => 0x77 },
	'landscaperawhighlightpoint' => { 100 => 0x24 },
	'landscaperawlinear' => { 100 => 0x22 },
	'landscaperawsaturation' => { 100 => 0x20 },
	'landscaperawshadow' => { 100 => 0x80 },
	'landscaperawshadowpoint' => { 100 => 0x25 },
	'landscaperawsharpness' => { 100 => 0x23 },
	'landscapeunsharpmaskfineness' => { 100 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 100 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 100 => 0xa2 },
	'language' => { 413 => 'language' },
	'languageidentifier' => { 117 => 0x87 },
	'largestvalidinteriorrectheight' => { 401 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 401 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 401 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 401 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 161 => 0x1b },
	'lastkeywordiptc' => { 159 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 159 => 'LastKeywordXMP' },
	'lastphotodate' => { 401 => 'LastPhotoDate' },
	'lasturl' => { 437 => 'LastURL' },
	'lateralchromaticaberration' => { 368 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 408 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 108 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 108 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 108 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 108 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 108 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 305 => 0x2 },
	'lc10' => { 305 => 0xb },
	'lc11' => { 305 => 0xc },
	'lc12' => { 305 => 0xd },
	'lc14' => { 305 => 0xf },
	'lc15' => { 305 => 0x10 },
	'lc3' => { 305 => 0x4 },
	'lc4' => { 305 => 0x5 },
	'lc5' => { 305 => 0x6 },
	'lc6' => { 305 => 0x7 },
	'lc7' => { 305 => 0x8 },
	'lc8' => { 305 => 0x9 },
	'lcddisplayatpoweron' => { 75 => 0x811, 79 => 0xa },
	'lcddisplayreturntoshoot' => { 80 => 0x12 },
	'lcdillumination' => { 243 => '17.5', 244 => '5.2', 246 => '5.1', 247 => '5.1', 252 => '10.3', 253 => '4.2', 256 => '5.2', 257 => '5.4' },
	'lcdilluminationduringbulb' => { 75 => 0x408 },
	'lcdpanels' => { 74 => 0x8 },
	'lcheditor' => { 236 => 0x8ae85e },
	'legacyiptcdigest' => { 424 => 'LegacyIPTCDigest' },
	'legalcode' => { 409 => 'legalcode' },
	'lens' => { 109 => 0xfdea, 198 => 0x84, 408 => 'Lens' },
	'lensafstopbutton' => { 73 => 0x11, 74 => 0x13, 75 => 0x506, 76 => 0x10, 77 => 0x12, 80 => 0x13, 81 => 0x9 },
	'lensaperturerange' => { 348 => [0x30,0x48] },
	'lenscorrectionsettings' => { 415 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 408 => 'LensDistortInfo' },
	'lensdistortionparams' => { 264 => 0x206 },
	'lensdrivenoaf' => { 75 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 358 => 0x3f0, 396 => 0xd },
	'lensfirmware' => { 340 => 0x20, 345 => 0xa004 },
	'lensfirmwareversion' => { 260 => 0x204, 280 => 0x60, 358 => 0x3f4, 396 => 0x15 },
	'lensfocallength' => { 94 => 0xf0512, 305 => 0x9 },
	'lensfocalrange' => { 348 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 244 => '55.1', 246 => '52.1', 247 => '52.1', 256 => '52.1' },
	'lensformat' => { 379 => 0x1891, 381 => 0x18bd, 382 => 0x18ed, 384 => 0x106, 392 => 0x603, 393 => 0x5d },
	'lensfstops' => { 193 => 0x7, 194 => 0xc, 195 => 0xd, 198 => 0x8b, 305 => '0.3' },
	'lensid' => { 408 => 'LensID' },
	'lensidnumber' => { 193 => 0x6, 194 => 0xb, 195 => 0xc },
	'lensinfo' => { 109 => 0xa432, 311 => 0x2a, 408 => 'LensInfo', 417 => 'LensSpecification' },
	'lenskind' => { 305 => 0x1 },
	'lensmake' => { 109 => 0xa433, 146 => 'Make', 417 => 'LensMake' },
	'lensmanualdistortionamount' => { 412 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 159 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 348 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 57 => 0x95, 109 => 0xa434, 146 => 'Model', 159 => 'LensModel', 196 => 0x18a, 260 => 0x203, 278 => 0x303, 311 => 0xc, 323 => 0x412, 417 => 'LensModel' },
	'lensmount' => { 358 => 0x99, 379 => 0x1892, 381 => 0x18be, 382 => 0x18ee, 384 => 0x105, 392 => 0x604, 393 => 0x5e },
	'lensmount2' => { 396 => 0x8 },
	'lensparameters' => { 376 => 0x1a23, 379 => 0x1870, 381 => 0x189c, 382 => 0x18cc, 392 => 0x6ca, 393 => 0x64 },
	'lensprofilechromaticaberrationscale' => { 412 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 412 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 412 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 412 => 'LensProfileEnable' },
	'lensprofilefilename' => { 412 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 412 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 412 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 412 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 412 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 412 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 412 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 412 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 412 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 412 => 'LensProfileName' },
	'lensprofilesetup' => { 412 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 412 => 'LensProfileVignettingScale' },
	'lensproperties' => { 260 => 0x20b },
	'lensserialnumber' => { 20 => 0x164, 31 => 0x16b, 55 => 0x0, 109 => 0xa435, 146 => 'SerialNumber', 260 => 0x202, 280 => 0x52, 340 => 0x30, 408 => 'LensSerialNumber', 417 => 'LensSerialNumber' },
	'lensshutterlock' => { 164 => 0x4a },
	'lensspec' => { 353 => 0x0, 354 => 0x0, 355 => 0x0, 368 => 0xb02a },
	'lensspecfeatures' => { 384 => [0x115,0x116] },
	'lenstemperature' => { 264 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x184, 27 => 0x112, 28 => 0x189, 33 => 0x16, 166 => 0x10c, 167 => 0x49bd, 198 => 0x83, 260 => 0x201, 273 => 0x16, 276 => 0x310, 279 => 0x303, 280 => 0x51, 282 => 0x3405, 306 => 0x0, 307 => 0x0, 308 => 0x1, 309 => 0x1, 310 => 0x1, 312 => 0x0, 345 => 0xa003, 348 => 0x27, 368 => 0xb027, 379 => 0x1896, 381 => 0x18c2, 382 => 0x18f2, 384 => 0x109, 392 => 0x608, 393 => 0x62 },
	'lenstype2' => { 358 => 0x3f7, 379 => 0x1893, 381 => 0x18bf, 382 => 0x18ef, 384 => 0x107, 392 => 0x605, 393 => 0x60 },
	'lenstype3' => { 396 => 0x9 },
	'lenszoomposition' => { 390 => 0x19, 391 => 0x1e, 393 => [0x342,0x35a] },
	'levelindicator' => { 287 => 0x15 },
	'levelorientation' => { 313 => 0x0 },
	'license' => { 409 => 'license' },
	'licensee' => { 269 => 'Licensee' },
	'licenseeid' => { 269 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 269 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 269 => 'LicenseeImageNotes' },
	'licenseename' => { 269 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 269 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 269 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 269 => 'LicenseeTransactionID' },
	'licenseid' => { 269 => 'LicenseID' },
	'licensestartdate' => { 269 => 'LicenseStartDate' },
	'licensetransactiondate' => { 269 => 'LicenseTransactionDate' },
	'licensetype' => { 414 => 'licensetype' },
	'licensor' => { 269 => 'Licensor' },
	'licensorcity' => { 269 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 269 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 269 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 269 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 269 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 269 => 'LicensorImageID' },
	'licensorname' => { 269 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 269 => 'LicensorNotes' },
	'licensorpostalcode' => { 269 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 269 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 269 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 269 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 269 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 269 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 269 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 269 => 'LicensorTransactionID' },
	'licensorurl' => { 269 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 264 => 0x1009 },
	'lightfalloffparams' => { 109 => 0x7032 },
	'lightingmode' => { 104 => 0x302a },
	'lightreading' => { 314 => 0x15 },
	'lightsource' => { 109 => 0x9208, 198 => 0x90, 267 => 0x1000, 416 => 'LightSource' },
	'lightsourcespecial' => { 347 => 0x21d },
	'lightswitch' => { 256 => '0.1', 257 => '0.1' },
	'lightvaluecenter' => { 264 => 0x103d },
	'lightvalueperiphery' => { 264 => 0x103e },
	'limitafareamodeselection' => { 244 => '51.1', 246 => '49.1', 247 => '49.1', 256 => '49.1' },
	'linearitylimitblue' => { 284 => 0x10 },
	'linearitylimitgreen' => { 284 => 0xf },
	'linearitylimitred' => { 284 => 0xe },
	'linearityuppermargin' => { 40 => [0x2ba,0x2d1,0x2d5], 42 => 0x1e5, 43 => [0x1fe,0x2de], 44 => [0x232,0x310] },
	'linearizationtable' => { 109 => 0xc618 },
	'linearresponselimit' => { 109 => 0xc62e },
	'link' => { 426 => 'link' },
	'linkaetoafpoint' => { 295 => '14.2' },
	'linkedencodedrightsexpr' => { 422 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 422 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 422 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 422 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 108 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 248 => '32.1', 257 => '34.1' },
	'liveviewafareamode' => { 253 => '34.1' },
	'liveviewafmethod' => { 372 => 0x20 },
	'liveviewafmode' => { 253 => '34.2' },
	'liveviewafsetting' => { 358 => 0x36 },
	'liveviewbuttonoptions' => { 244 => '50.2', 246 => '48.2', 247 => '48.2', 256 => '48.2' },
	'liveviewexposuresimulation' => { 75 => 0x810 },
	'liveviewfocusmode' => { 358 => [0x8b,0x28b] },
	'liveviewmetering' => { 358 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 244 => '21.2', 246 => '21.2', 247 => '21.2', 249 => '20.2', 250 => '20.2', 251 => '20.2', 253 => '20.2', 256 => '21.2' },
	'liveviewshooting' => { 51 => 0x13 },
	'localcaption' => { 117 => 0x79 },
	'localizedcameramodel' => { 109 => 0xc615 },
	'locallocationname' => { 345 => 0x30 },
	'location' => { 197 => 0x9, 280 => 0x67, 404 => 'Location', 421 => 'Location', 425 => 'location', 426 => 'location' },
	'locationareacode' => { 410 => 'lac' },
	'locationcreated' => { 422 => 'LocationCreated' },
	'locationcreatedcity' => { 422 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 422 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 422 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedlocationid' => { 422 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedprovincestate' => { 422 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 422 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 422 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 197 => 0x0 },
	'locationname' => { 345 => 0x31 },
	'locationshown' => { 422 => 'LocationShown' },
	'locationshowncity' => { 422 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 422 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 422 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownlocationid' => { 422 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownprovincestate' => { 422 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 422 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 422 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 75 => 0x709 },
	'logcomment' => { 436 => 'logComment' },
	'longexposurenoisereduction' => { 56 => 0x4, 75 => 0x201, 76 => 0x1, 77 => 0x2, 78 => 0x1, 79 => 0x1, 80 => 0x2, 81 => 0x1, 280 => 0x49, 356 => 0x2b, 357 => 0x25, 358 => 0x25, 368 => 0x2008, 372 => 0x11, 393 => 0x44 },
	'longexposurenoisereduction2' => { 51 => 0x8 },
	'loop' => { 436 => 'loop' },
	'lowestbiostratigraphiczone' => { 108 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 412 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 412 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 412 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 412 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 412 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 412 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 412 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 412 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 99 => 0x150 },
	'luminancecurvepoints' => { 99 => 0x126 },
	'luminancenoisereduction' => { 94 => 0x20600, 100 => 0x5f, 348 => 0x1b },
	'luminancenoisereductioncontrast' => { 412 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 412 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 100 => 0x6d },
	'luminancesmoothing' => { 412 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 75 => [0x40b,0x40c] },
	'lyrics' => { 436 => 'lyrics' },
	'm16cversion' => { 276 => 0x333 },
	'macatom' => { 411 => 'macAtom' },
	'macatomapplicationcode' => { 411 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 411 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 411 => [\'macAtom','macAtomPosixProjectPath'] },
	'macro' => { 114 => 0x1020, 115 => 0x202, 264 => 0x202, 338 => 0x21, 347 => 0x202, 368 => 0xb040 },
	'macroled' => { 262 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 51 => 0x10 },
	'macromode' => { 33 => 0x1, 161 => 0xb, 259 => 0x300, 280 => 0x1c, 339 => 0x1009 },
	'magentahsl' => { 94 => 0x20917 },
	'magicfilter' => { 259 => 0x52c },
	'magnifiedview' => { 77 => 0x11, 79 => 0x9 },
	'maindialexposurecomp' => { 254 => '0.6' },
	'mainingredient' => { 428 => 'mainIngredient' },
	'make' => { 89 => 0x0, 106 => 0x1, 109 => 0x10f, 139 => 'Make', 272 => 'Make', 284 => 0x10f, 425 => 'make', 432 => 'Make' },
	'makernote' => { 416 => 'MakerNote' },
	'makernoteapple' => { 107 => 'MakN', 109 => 0x927c },
	'makernotecanon' => { 107 => 'MakN', 109 => 0x927c },
	'makernotecasio' => { 107 => 'MakN', 109 => 0x927c },
	'makernotecasio2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotedji' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteflir' => { 107 => 'MakN', 109 => 0x927c },
	'makernotefujifilm' => { 107 => 'MakN', 109 => 0x927c },
	'makernotege' => { 107 => 'MakN', 109 => 0x927c },
	'makernotege2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotehasselblad' => { 107 => 'MakN', 109 => 0x927c },
	'makernotehp' => { 107 => 'MakN', 109 => 0x927c },
	'makernotehp2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotehp4' => { 107 => 'MakN', 109 => 0x927c },
	'makernotehp6' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteisl' => { 107 => 'MakN', 109 => 0x927c },
	'makernotejvc' => { 107 => 'MakN', 109 => 0x927c },
	'makernotejvctext' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak10' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak11' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak1a' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak1b' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak3' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak4' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak5' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak6a' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak6b' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak7' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak8a' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak8b' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak8c' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodak9' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekodakunknown' => { 107 => 'MakN', 109 => 0x927c },
	'makernotekyocera' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica2' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica3' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica4' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica5' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica6' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica7' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica8' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteleica9' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteminolta' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteminolta2' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteminolta3' => { 107 => 'MakN', 109 => 0x927c },
	'makernotemotorola' => { 107 => 'MakN', 109 => 0x927c },
	'makernotenikon' => { 107 => 'MakN', 109 => 0x927c },
	'makernotenikon2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotenikon3' => { 107 => 'MakN', 109 => 0x927c },
	'makernotenintendo' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteoffset' => { 347 => 0xff },
	'makernoteolympus' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteolympus2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepanasonic' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepanasonic2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax3' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax4' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax5' => { 107 => 'MakN', 109 => 0x927c },
	'makernotepentax6' => { 107 => 'MakN', 109 => 0x927c },
	'makernotephaseone' => { 107 => 'MakN', 109 => 0x927c },
	'makernotereconyx' => { 107 => 'MakN', 109 => 0x927c },
	'makernotericoh' => { 107 => 'MakN', 109 => 0x927c },
	'makernotericoh2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotericohtext' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesafety' => { 109 => 0xc635 },
	'makernotesamsung1a' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesamsung1b' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesamsung2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesanyo' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesanyoc4' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesanyopatch' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesigma' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesony' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesony2' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesony3' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesony4' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesony5' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesonyericsson' => { 107 => 'MakN', 109 => 0x927c },
	'makernotesonysrf' => { 107 => 'MakN', 109 => 0x927c },
	'makernotetype' => { 339 => 0x1 },
	'makernoteunknown' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteunknownbinary' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteunknowntext' => { 107 => 'MakN', 109 => 0x927c },
	'makernoteversion' => { 166 => 0x0, 198 => 0x1, 264 => 0x0, 280 => 0x8000, 343 => 0x0, 345 => 0x1, 348 => [0x1d,0x1f], 359 => 0x2000 },
	'managedfrom' => { 437 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 437 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 437 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 437 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 437 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 437 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 437 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 437 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 437 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 437 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 437 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 437 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 437 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 437 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 437 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 437 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 437 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 437 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 437 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 437 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 437 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 437 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 437 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 437 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 437 => 'Manager' },
	'managervariant' => { 437 => 'ManagerVariant' },
	'manageto' => { 437 => 'ManageTo' },
	'manageui' => { 437 => 'ManageUI' },
	'manifest' => { 437 => 'Manifest' },
	'manifestlinkform' => { 437 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 437 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 437 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 437 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 437 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 437 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 437 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 437 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 437 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 437 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 437 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 437 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 437 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 437 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 437 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 437 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 437 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 437 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 437 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 437 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 437 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 437 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 437 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 437 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 437 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 437 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 437 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 437 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 259 => 0x900, 280 => 0x86 },
	'manometerreading' => { 259 => 0x901 },
	'manualafpointselectpattern' => { 75 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 262 => 0x1209 },
	'manualflashoutput' => { 33 => 0x29, 245 => '8.2', 248 => '22.2', 249 => '23.1', 250 => '23.2', 252 => '16.2', 253 => '23.2', 254 => '8.2', 255 => '23.2', 257 => '24.2', 339 => 0x100c },
	'manualflashstrength' => { 259 => 0x406 },
	'manualfocusdistance' => { 198 => 0x85, 264 => 0x100c, 347 => 0x223 },
	'manualtv' => { 74 => 0x5, 75 => 0x705 },
	'manufacturedate' => { 171 => 0x6705, 294 => 0x1 },
	'manufacturedate1' => { 341 => 0x4 },
	'manufacturedate2' => { 341 => 0x5 },
	'manufacturer' => { 425 => 'manufacturer' },
	'marked' => { 423 => 'Marked', 440 => 'Marked' },
	'markers' => { 436 => 'markers' },
	'markerscomment' => { 436 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 436 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 436 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 436 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 436 => [\'markers','markersCuePointType'] },
	'markersduration' => { 436 => [\'markers','markersDuration'] },
	'markerslocation' => { 436 => [\'markers','markersLocation'] },
	'markersname' => { 436 => [\'markers','markersName'] },
	'markersprobability' => { 436 => [\'markers','markersProbability'] },
	'markersspeaker' => { 436 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 436 => [\'markers','markersStartTime'] },
	'markerstarget' => { 436 => [\'markers','markersTarget'] },
	'markerstype' => { 436 => [\'markers','markersType'] },
	'maskedareas' => { 109 => 0xc68e },
	'masterdocumentid' => { 117 => 0xb9 },
	'mastergain' => { 205 => 0x50 },
	'matrixmetering' => { 244 => '50.1', 246 => '48.1', 247 => '48.1', 256 => '48.1' },
	'maxaperture' => { 33 => 0x1a, 129 => 0x6103, 146 => 'MaxAperture', 161 => 0x17, 167 => 0x49c5, 260 => 0x20a, 305 => '14.1', 384 => 0x0 },
	'maxapertureatmaxfocal' => { 114 => 0x1407, 146 => 'MaxApertureAtMaxFocal', 193 => 0xb, 194 => 0x10, 195 => 0x11, 260 => 0x206 },
	'maxapertureatminfocal' => { 114 => 0x1406, 193 => 0xa, 194 => 0xf, 195 => 0x10, 260 => 0x205 },
	'maxaperturevalue' => { 109 => 0x9205, 323 => 0x414, 416 => 'MaxApertureValue' },
	'maxavailheight' => { 422 => 'MaxAvailHeight' },
	'maxavailwidth' => { 422 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 243 => 0xb, 244 => 0xc, 246 => '12.1', 247 => '12.1', 252 => 0xc, 253 => 0xb, 256 => '12.1' },
	'maxfaces' => { 263 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x188, 27 => 0x116, 28 => 0x18d, 33 => 0x17, 114 => 0x1405, 146 => 'MaxFocalLength', 193 => 0x9, 194 => 0xe, 195 => 0xf, 260 => 0x208, 379 => 0x127c, 380 => 0x1138, 381 => 0x330, 382 => 0x330 },
	'maximumdensityrange' => { 119 => 0x8c },
	'maxpagesize' => { 441 => 'MaxPageSize' },
	'maxpagesizeh' => { 441 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 441 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 441 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 109 => 0x119 },
	'maxstorage' => { 431 => 'maxstorage' },
	'mb-d10batteries' => { 243 => '12.6' },
	'mb-d10batterytype' => { 252 => '13.3' },
	'mb-d11batterytype' => { 253 => '2.3' },
	'mb-d12batterytype' => { 256 => '3.2' },
	'mb-d80batteries' => { 254 => '6.5' },
	'mb-d80batterytype' => { 257 => '3.2' },
	'mcuversion' => { 193 => 0xc, 194 => 0x11, 195 => 0x12 },
	'md5digest' => { 147 => 'zmd5' },
	'meal' => { 428 => 'meal' },
	'measuredev' => { 27 => 0x9, 69 => 0x3, 88 => 0x1814, 139 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 27 => 0x8, 69 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 167 => 0x690, 276 => 0x312, 282 => 0x3407 },
	'measuredrggb' => { 58 => 0x1 },
	'measuredrggbdata' => { 39 => 0x287 },
	'measurementaccuracy' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 108 => 'MeasurementOrFact' },
	'measurementremarks' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 108 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 269 => 'MediaConstraints' },
	'mediacreatedate' => { 331 => 0x1 },
	'mediamodifydate' => { 331 => 0x2 },
	'mediasummarycode' => { 269 => 'MediaSummaryCode' },
	'memoaudioquality' => { 75 => 0x812 },
	'memorycardconfiguration' => { 362 => 0x16 },
	'memorycardnumber' => { 185 => 0x2 },
	'menubuttondisplayposition' => { 73 => 0xb, 76 => 0xa, 77 => 0xb, 80 => 0xb },
	'menubuttonreturn' => { 81 => 0xb },
	'menumonitorofftime' => { 243 => '26.1', 244 => '22.1', 246 => '22.1', 247 => '22.1', 251 => '21.1', 252 => '8.2', 253 => '21.1', 256 => '22.1', 257 => '22.1' },
	'metadatadate' => { 434 => 'MetadataDate' },
	'metadatamoddate' => { 436 => 'metadataModDate' },
	'metaversion' => { 374 => 0x34 },
	'meterinfo1row1' => { 369 => 0x0 },
	'meterinfo1row2' => { 369 => 0x6c },
	'meterinfo1row3' => { 369 => 0xd8 },
	'meterinfo1row4' => { 369 => 0x144 },
	'meterinfo1row5' => { 369 => 0x1b0 },
	'meterinfo1row6' => { 369 => 0x21c },
	'meterinfo1row7' => { 369 => 0x288 },
	'meterinfo2row1' => { 369 => 0x2f4 },
	'meterinfo2row2' => { 369 => 0x378 },
	'meterinfo2row3' => { 369 => 0x3fc },
	'meterinfo2row4' => { 369 => 0x480 },
	'meterinfo2row5' => { 369 => 0x504 },
	'meterinfo2row6' => { 369 => 0x588 },
	'meterinfo2row7' => { 369 => 0x60c },
	'meterinfo2row8' => { 369 => 0x690 },
	'meterinfo2row9' => { 369 => 0x714 },
	'metering' => { 245 => '6.1' },
	'meteringmode' => { 33 => 0x11, 109 => 0x9207, 125 => 0x1c, 161 => 0x7, 162 => 0x25, 164 => 0x12, 259 => 0x202, 314 => 0x17, 348 => 0x9, 356 => 0x15, 357 => 0x13, 358 => 0x7, 372 => 0x3, 375 => 0x1174, 376 => 0x1178, 377 => 0x1154, 378 => 0x11d0, 379 => 0x11ac, 380 => 0x1064, 381 => 0x25c, 382 => 0x25c, 416 => 'MeteringMode' },
	'meteringmode2' => { 295 => '2.1' },
	'meteringmode3' => { 295 => '16.1' },
	'meteringoffscaleindicator' => { 164 => 0x53 },
	'meteringtime' => { 243 => '22.2', 245 => '3.2', 248 => '17.1', 249 => '18.1', 252 => '7.3', 253 => '18.1', 254 => '3.2', 257 => '19.1' },
	'mieversion' => { 147 => '0Vers' },
	'minaperture' => { 33 => 0x1b, 146 => 'MinAperture', 305 => '0.2', 384 => 0x1 },
	'minaperturevalue' => { 323 => 0x415 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x186, 27 => 0x114, 28 => 0x18b, 33 => 0x18, 114 => 0x1404, 146 => 'MinFocalLength', 193 => 0x8, 194 => 0xd, 195 => 0xe, 260 => 0x207, 379 => 0x127a, 380 => 0x1136, 381 => 0x32e, 382 => 0x32e },
	'minfocusdistance' => { 305 => 0x3 },
	'minoltadate' => { 161 => 0x15 },
	'minoltaimagesize' => { 161 => 0x4, 162 => 0xc, 163 => 0x2, 166 => 0x103 },
	'minoltamodelid' => { 161 => 0x25 },
	'minoltaquality' => { 161 => 0x5, 162 => 0xd, 163 => 0x3, 166 => [0x102,0x103] },
	'minoltatime' => { 161 => 0x16 },
	'minormodelagedisclosure' => { 269 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 109 => 0x118 },
	'mirrorlockup' => { 73 => 0xc, 74 => 0xc, 75 => 0x60f, 76 => 0xb, 77 => 0xc, 78 => 0x6, 79 => 0x6, 80 => 0xc, 81 => 0x3 },
	'mobilecountrycode' => { 410 => 'mcc' },
	'mobilenetworkcode' => { 410 => 'mnc' },
	'moddate' => { 272 => 'modify-date', 423 => 'ModDate' },
	'modedialposition' => { 362 => 0x14 },
	'model' => { 89 => 0x6, 109 => 0x110, 139 => 'Model', 272 => 'Model', 284 => 0x110, 348 => 0x84, 425 => 'model', 432 => 'Model' },
	'modelage' => { 422 => 'ModelAge' },
	'modelid' => { 258 => 0x0 },
	'modelingflash' => { 243 => '21.4', 244 => '31.1', 246 => '31.1', 247 => '31.1', 252 => '26.4', 253 => '30.2', 254 => '7.4', 255 => '30.1', 256 => '31.1', 257 => '31.3' },
	'modelreleaseid' => { 269 => 'ModelReleaseID' },
	'modelreleasestatus' => { 269 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 385 => 0x52, 386 => 0x46, 387 => 0x53 },
	'modelyear' => { 425 => 'modelYear' },
	'modificationdate' => { 426 => 'modificationDate' },
	'modifiedcolortemp' => { 59 => 0x9 },
	'modifieddigitalgain' => { 59 => 0xb },
	'modifiedparamflag' => { 52 => 0x1 },
	'modifiedpicturestyle' => { 59 => 0xa },
	'modifiedsaturation' => { 259 => 0x504 },
	'modifiedsensorbluelevel' => { 59 => 0x5 },
	'modifiedsensorredlevel' => { 59 => 0x4 },
	'modifiedsharpness' => { 59 => 0x2 },
	'modifiedsharpnessfreq' => { 59 => 0x3 },
	'modifiedtonecurve' => { 59 => 0x1 },
	'modifiedwhitebalance' => { 59 => 0x8 },
	'modifiedwhitebalanceblue' => { 59 => 0x7 },
	'modifiedwhitebalancered' => { 59 => 0x6 },
	'modifydate' => { 109 => 0x132, 140 => 'ModifyDate', 268 => 'ModDate', 270 => 'tIME', 330 => 'ModDate', 332 => 0x2, 434 => 'ModifyDate' },
	'moirefilter' => { 109 => 0xfe58, 412 => 'MoireFilter' },
	'monitordisplayoff' => { 164 => 0x4c },
	'monitorofftime' => { 243 => '18.2', 245 => '3.1', 254 => '3.1' },
	'monochromecolor' => { 259 => 0x53b },
	'monochromecontrast' => { 100 => 0x3c },
	'monochromefiltereffect' => { 94 => 0x20307, 100 => 0x3a, 314 => 0x73 },
	'monochromelinear' => { 100 => 0x3d },
	'monochromeoutputhighlightpoint' => { 100 => 0x41 },
	'monochromeoutputshadowpoint' => { 100 => 0x42 },
	'monochromeprofilesettings' => { 259 => 0x537 },
	'monochromerawhighlight' => { 100 => 0x7a },
	'monochromerawhighlightpoint' => { 100 => 0x3f },
	'monochromerawshadow' => { 100 => 0x83 },
	'monochromerawshadowpoint' => { 100 => 0x40 },
	'monochromesharpness' => { 100 => 0x3e },
	'monochrometoning' => { 314 => 0x74 },
	'monochrometoningeffect' => { 94 => 0x20306, 100 => 0x3b },
	'monochromeunsharpmaskfineness' => { 100 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 100 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 100 => 0xb4 },
	'monochromevignetting' => { 259 => 0x53a },
	'monthdaycreated' => { 125 => 0x12, 134 => 0xe },
	'moonphase' => { 335 => 0x12 },
	'morepermissions' => { 409 => 'morePermissions' },
	'motionsensitivity' => { 335 => 0x29 },
	'movieaelockbuttonassignment' => { 256 => '40.1' },
	'moviefunc1button' => { 246 => '41.1', 247 => '41.1' },
	'moviefunctionbutton' => { 244 => '41.1', 256 => '41.1' },
	'moviefunctionbuttonplusdials' => { 244 => '52.1' },
	'moviepreviewbutton' => { 244 => '41.2', 246 => '41.2', 247 => '41.2', 256 => '41.2' },
	'moviepreviewbuttonplusdials' => { 244 => '52.2' },
	'movieshutterbutton' => { 244 => '38.3', 246 => '38.3', 247 => '38.3', 256 => '38.3' },
	'moviesubselectorassignment' => { 244 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 244 => '53.1' },
	'multiburstimageheight' => { 368 => 0x1002 },
	'multiburstimagewidth' => { 368 => 0x1001 },
	'multiburstmode' => { 368 => 0x1000 },
	'multicontrollerwhilemetering' => { 75 => 0x517 },
	'multiexposure' => { 61 => 0x1 },
	'multiexposureautogain' => { 199 => 0x3 },
	'multiexposurecontrol' => { 61 => 0x2 },
	'multiexposuremode' => { 199 => 0x1 },
	'multiexposureshots' => { 61 => 0x3, 199 => 0x2 },
	'multiframenoisereduction' => { 358 => 0x35, 368 => 0x200b, 372 => 0x15 },
	'multifunctionlock' => { 75 => 0x70f },
	'multipleexposuremode' => { 263 => 0x101c },
	'multipleexposureset' => { 295 => '10.1' },
	'multisample' => { 205 => 0x40 },
	'multiselector' => { 243 => '9.4', 244 => '10.3', 246 => '10.3', 247 => '10.3', 252 => '27.4', 256 => '10.3' },
	'multiselectorliveview' => { 243 => '4.3', 246 => '37.1', 247 => '37.1', 256 => '37.1' },
	'multiselectorliveviewmode' => { 215 => 0x18c2 },
	'multiselectorplaybackmode' => { 243 => ['13.5','9.2'], 244 => '10.2', 247 => '10.2', 252 => '27.2', 256 => '10.2' },
	'multiselectorshootmode' => { 243 => '9.1', 244 => '10.1', 246 => '10.1', 247 => '10.1', 252 => '27.1', 256 => '10.1' },
	'mycolormode' => { 62 => 0x2 },
	'nationalcatalognumber' => { 426 => 'nationalCatalogNumber' },
	'nativedigest' => { 416 => 'NativeDigest', 432 => 'NativeDigest' },
	'ncdfileinfo' => { 123 => 0x414 },
	'ndfilter' => { 69 => 0x1c, 259 => 0x204, 339 => 0x1019 },
	'nefbitdepth' => { 198 => 0xe22 },
	'nefcompression' => { 198 => 0x93 },
	'neflinearizationtable' => { 198 => 0x96 },
	'negativecachelargepreviewsize' => { 412 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 412 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 412 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 314 => 0x88 },
	'neutraloutputhighlightpoint' => { 100 => 0x2f },
	'neutraloutputshadowpoint' => { 100 => 0x30 },
	'neutralrawcolortone' => { 100 => 0x28 },
	'neutralrawcontrast' => { 100 => 0x2a },
	'neutralrawhighlight' => { 100 => 0x78 },
	'neutralrawhighlightpoint' => { 100 => 0x2d },
	'neutralrawlinear' => { 100 => 0x2b },
	'neutralrawsaturation' => { 100 => 0x29 },
	'neutralrawshadow' => { 100 => 0x81 },
	'neutralrawshadowpoint' => { 100 => 0x2e },
	'neutralrawsharpness' => { 100 => 0x2c },
	'neutralunsharpmaskfineness' => { 100 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 100 => 0xa8 },
	'neutraunsharpmaskstrength' => { 100 => 0xa4 },
	'newrawimagedigest' => { 109 => 0xc7a7 },
	'newsphotoversion' => { 119 => 0x0 },
	'nickname' => { 434 => 'Nickname' },
	'nikoncapturedata' => { 198 => 0xe01 },
	'nikoncaptureeditversions' => { 198 => 0xe13 },
	'nikoncaptureoutput' => { 198 => 0xe1e },
	'nikoncaptureversion' => { 198 => 0xe09 },
	'nikoniccprofile' => { 198 => 0xe1d },
	'nikonimagesize' => { 212 => '723.1', 213 => '732.1', 222 => 0x2c4 },
	'noisefilter' => { 259 => 0x527 },
	'noiseprofile' => { 109 => 0xc761 },
	'noisereduction' => { 114 => 0x100b, 162 => 0xb0, 163 => 0x60, 164 => 0x3f, 198 => 0x95, 236 => 0x753dcbc0, 237 => 0x17, 259 => 0x50a, 264 => 0x103a, 280 => 0x2d, 314 => 0x49, 339 => 0x100f, 341 => 0x2a },
	'noisereduction2' => { 263 => 0x1010 },
	'noisereductionapplied' => { 109 => 0xc6f7 },
	'noisereductionintensity' => { 237 => 0x9 },
	'noisereductionmethod' => { 237 => 0x11 },
	'noisereductionmode' => { 397 => 0x801e },
	'noisereductionsharpness' => { 237 => 0xd },
	'noisereductionvalue' => { 397 => 0x8027 },
	'nomemorycard' => { 243 => '22.1', 244 => '4.2', 245 => '0.3', 248 => '2.4', 249 => '3.2', 250 => '3.2', 252 => '33.7', 253 => '3.2', 254 => '0.3', 256 => '4.2', 257 => '4.5' },
	'nominalmaxaperture' => { 305 => 0xa },
	'nominalminaperture' => { 305 => '10.1' },
	'normalwhitelevel' => { 40 => [0x2b8,0x2cf,0x2d3], 42 => 0x1e3, 43 => [0x1fc,0x2dc], 44 => [0x230,0x30e] },
	'notes' => { 398 => 'Notes', 406 => 'notes' },
	'npages' => { 441 => 'NPages' },
	'nrwdata' => { 198 => 0x14 },
	'nullrecord' => { 88 => 0x0 },
	'numafpoints' => { 291 => 0x2 },
	'number' => { 426 => 'number' },
	'numberofbeats' => { 436 => 'numberOfBeats' },
	'numberoffocuspoints' => { 246 => '1.2', 247 => '1.2', 250 => '0.2', 251 => '0.3', 253 => '0.3' },
	'numfacepositions' => { 274 => 0x0 },
	'numindexentries' => { 119 => 0x54 },
	'numwbentries' => { 285 => 0x0, 286 => 0x0 },
	'object' => { 426 => 'object' },
	'objectattributereference' => { 117 => 0x4 },
	'objectcycle' => { 117 => 0x4b, 406 => 'ObjectCycle' },
	'objectdescription' => { 425 => 'objectDescription' },
	'objectdistance' => { 103 => 0x6, 104 => 0x2022 },
	'objectname' => { 117 => 0x5 },
	'objectpreviewdata' => { 117 => 0xca },
	'objectpreviewfileformat' => { 117 => 0xc8 },
	'objectpreviewfileversion' => { 117 => 0xc9 },
	'objectsubtype' => { 425 => 'objectSubtype' },
	'objecttype' => { 425 => 'objectType' },
	'objecttypereference' => { 117 => 0x3 },
	'occurrence' => { 108 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 108 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 108 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 108 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 108 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 108 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 108 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 108 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 108 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 108 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 108 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 108 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 108 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 108 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 108 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 108 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 108 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 108 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 108 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 108 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 108 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 108 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 108 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 108 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 416 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 416 => [\'OECF','OECFNames'] },
	'oecfrows' => { 416 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 416 => [\'OECF','OECFValues'] },
	'offsaledate' => { 426 => 'offSaleDate' },
	'offsaledatea-platform' => { 426 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 426 => [\'offSaleDate','offSaleDateDate'] },
	'offsetschema' => { 109 => 0xea1d },
	'offsettime' => { 109 => 0x9010 },
	'offsettimedigitized' => { 109 => 0x9012 },
	'offsettimeoriginal' => { 109 => 0x9011 },
	'okbutton' => { 253 => '15.1', 257 => '16.1' },
	'oldsubfiletype' => { 109 => 0xff },
	'olympusimageheight' => { 264 => 0x102f },
	'olympusimagewidth' => { 264 => 0x102e },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 264 => 0x302 },
	'onsaledate' => { 426 => 'onSaleDate' },
	'onsaledatea-platform' => { 426 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 426 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 426 => 'onSaleDay' },
	'onsaledaya-platform' => { 426 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 426 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 109 => 0xc740 },
	'opcodelist2' => { 109 => 0xc741 },
	'opcodelist3' => { 109 => 0xc74e },
	'opticalzoom' => { 127 => 0xfa3d, 129 => [0x6006,0xf006], 130 => 0x1000, 131 => 0xf, 134 => 0x1e, 146 => 'OpticalZoom' },
	'opticalzoomcode' => { 69 => 0xa },
	'opticalzoommode' => { 280 => 0x34 },
	'opticalzoomon' => { 347 => 0x219 },
	'optionenddate' => { 429 => 'optionEndDate' },
	'opto-electricconvfactor' => { 416 => 'OECF' },
	'orangehsl' => { 94 => 0x20911 },
	'ordernumber' => { 114 => 0x8002 },
	'organisationinimagecode' => { 422 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 422 => 'OrganisationInImageName' },
	'organization' => { 426 => 'organization' },
	'orientation' => { 109 => 0x112, 284 => 0x112, 425 => 'orientation', 432 => 'Orientation' },
	'orientation2' => { 372 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 75 => 0x516 },
	'originalbestqualitysize' => { 109 => 0xc792 },
	'originaldecisiondata' => { 105 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 57 => 0x83 },
	'originaldefaultcropsize' => { 109 => 0xc793 },
	'originaldefaultfinalsize' => { 109 => 0xc791 },
	'originaldirectory' => { 278 => 0x408 },
	'originaldocumentid' => { 437 => 'OriginalDocumentID' },
	'originalfilename' => { 88 => 0x816, 123 => 0x3e9, 135 => 0x20, 278 => 0x407, 402 => 'OriginalFilename' },
	'originalimageheight' => { 71 => 0xc, 113 => 0x1 },
	'originalimagewidth' => { 71 => 0xb, 113 => 0x0 },
	'originalrawfiledata' => { 109 => 0xc68c },
	'originalrawfiledigest' => { 109 => 0xc71d },
	'originalrawfilename' => { 109 => 0xc68b },
	'originaltransmissionreference' => { 117 => 0x67 },
	'originatingprogram' => { 117 => 0x41, 406 => 'OriginatingProgram' },
	'originplatform' => { 426 => 'originPlatform' },
	'os' => { 414 => 'os' },
	'otherconditions' => { 269 => 'OtherConditions' },
	'otherconstraints' => { 269 => 'OtherConstraints' },
	'otherimage' => { 105 => 'OtherImage' },
	'otherimageinfo' => { 269 => 'OtherImageInfo' },
	'otherimagelength' => { 109 => 0x202 },
	'otherimagestart' => { 109 => 0x201 },
	'otherlicensedocuments' => { 269 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 269 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 269 => 'OtherLicenseRequirements' },
	'outcue' => { 436 => 'outCue' },
	'outcuescale' => { 436 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 436 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 176 => 0x3 },
	'outputimagewidth' => { 176 => 0x2 },
	'outputprofile' => { 123 => 0x138b },
	'outputresolution' => { 176 => 0x4 },
	'owner' => { 440 => 'Owner' },
	'ownerid' => { 117 => 0xbc },
	'ownername' => { 14 => 0x10f, 57 => 0x9, 88 => 0x810, 109 => [0xa430,0xfde8], 139 => 'OwnerName', 408 => 'OwnerName', 417 => 'CameraOwnerName' },
	'padding' => { 109 => 0xea1c },
	'pagecount' => { 426 => 'pageCount' },
	'pageimage' => { 434 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 434 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 434 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 434 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 434 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 434 => 'PageInfo' },
	'pagename' => { 109 => 0x11d },
	'pagenumber' => { 109 => 0x129 },
	'pageprogressiondirection' => { 426 => 'pageProgressionDirection' },
	'pagerange' => { 426 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 412 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 412 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 280 => 0x26 },
	'panasonicimageheight' => { 280 => 0x4c },
	'panasonicimagewidth' => { 280 => 0x4b },
	'panasonicrawversion' => { 284 => 0x1 },
	'panasonictitle' => { 109 => 0xc6d2 },
	'panasonictitle2' => { 109 => 0xc6d3 },
	'panoramacropbottom' => { 373 => 0x7 },
	'panoramacropleft' => { 373 => 0x4 },
	'panoramacropright' => { 373 => 0x6 },
	'panoramacroptop' => { 373 => 0x5 },
	'panoramadirection' => { 65 => 0x5, 373 => 0x3 },
	'panoramaframeheight' => { 373 => 0x9 },
	'panoramaframenumber' => { 65 => 0x2 },
	'panoramaframewidth' => { 373 => 0x8 },
	'panoramafullheight' => { 373 => 0x2 },
	'panoramafullwidth' => { 373 => 0x1 },
	'panoramamode' => { 125 => 0x3c, 259 => 0x601 },
	'panoramasize3d' => { 358 => 0x38 },
	'panoramasourceheight' => { 373 => 0xb },
	'panoramasourcewidth' => { 373 => 0xa },
	'panoramicstitchcameramotion' => { 157 => 'PanoramicStitchCameraMotion', 158 => 0x1 },
	'panoramicstitchmaptype' => { 157 => 'PanoramicStitchMapType', 158 => 0x2 },
	'panoramicstitchphi0' => { 157 => 'PanoramicStitchPhi0', 158 => 0x5 },
	'panoramicstitchphi1' => { 157 => 'PanoramicStitchPhi1', 158 => 0x6 },
	'panoramicstitchtheta0' => { 157 => 'PanoramicStitchTheta0', 158 => 0x3 },
	'panoramicstitchtheta1' => { 157 => 'PanoramicStitchTheta1', 158 => 0x4 },
	'panoramicstitchversion' => { 158 => 0x0 },
	'pantry' => { 437 => 'Pantry' },
	'parallax' => { 114 => 0xb211, 258 => 0x28 },
	'parametricdarks' => { 412 => 'ParametricDarks' },
	'parametrichighlights' => { 412 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 412 => 'ParametricHighlightSplit' },
	'parametriclights' => { 412 => 'ParametricLights' },
	'parametricmidtonesplit' => { 412 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 412 => 'ParametricShadows' },
	'parametricshadowsplit' => { 412 => 'ParametricShadowSplit' },
	'parentmeid' => { 402 => 'ParentMEID' },
	'parentreference1' => { 420 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 420 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 420 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 420 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 420 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 420 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 436 => 'partOfCompilation' },
	'patientbirthdate' => { 399 => 'PatientDOB' },
	'patientid' => { 399 => 'PatientID' },
	'patientname' => { 399 => 'PatientName' },
	'patientsex' => { 399 => 'PatientSex' },
	'pdfversion' => { 423 => 'PDFVersion' },
	'pentaximagesize' => { 314 => 0x9 },
	'pentaxmodelid' => { 294 => 0x0, 314 => 0x5 },
	'pentaxmodeltype' => { 314 => 0x1 },
	'pentaxversion' => { 314 => 0x0 },
	'people' => { 400 => 'People', 404 => 'People' },
	'perchannelblacklevel' => { 39 => 0xc4, 40 => [0x2b4,0x2cb,0x2cf], 41 => 0x108, 42 => 0x1df, 43 => [0x1f8,0x2d8], 44 => [0x22c,0x30a] },
	'peripheralillumcentralradius' => { 397 => 0x8030 },
	'peripheralillumcentralvalue' => { 397 => 0x8031 },
	'peripheralillumination' => { 94 => 0x20702, 100 => 0x68 },
	'peripheralilluminationcorr' => { 56 => 0x1, 304 => 0x2 },
	'peripheralilluminationon' => { 94 => '0x20702.0', 100 => 0x64 },
	'peripheralillumperiphvalue' => { 397 => 0x8032 },
	'peripherallighting' => { 71 => 0x2 },
	'peripherallightingsetting' => { 72 => 0x5 },
	'peripherallightingvalue' => { 71 => 0x6 },
	'permissions' => { 429 => 'permissions' },
	'permits' => { 409 => 'permits' },
	'person' => { 426 => 'person' },
	'personality' => { 402 => 'Personality' },
	'personinimage' => { 422 => 'PersonInImage' },
	'personinimagecharacteristic' => { 422 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 422 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 422 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 422 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 422 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 422 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 422 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 422 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 422 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 412 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 412 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 412 => 'PerspectiveRotate' },
	'perspectivescale' => { 412 => 'PerspectiveScale' },
	'perspectiveupright' => { 412 => 'PerspectiveUpright' },
	'perspectivevertical' => { 412 => 'PerspectiveVertical' },
	'perspectivex' => { 412 => 'PerspectiveX' },
	'perspectivey' => { 412 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 83 => 0x1 },
	'pf10retainprogramshift' => { 83 => 0xb },
	'pf13drivepriority' => { 83 => 0xe },
	'pf14disablefocussearch' => { 83 => 0xf },
	'pf15disableafassistbeam' => { 83 => 0x10 },
	'pf16autofocuspointshoot' => { 83 => 0x11 },
	'pf17disableafpointsel' => { 83 => 0x12 },
	'pf18enableautoafpointsel' => { 83 => 0x13 },
	'pf19continuousshootspeed' => { 83 => 0x14 },
	'pf19shootingspeedhigh' => { 82 => 0xa },
	'pf19shootingspeedlow' => { 82 => 0x9 },
	'pf1disableshootingmodes' => { 83 => 0x2 },
	'pf1value' => { 82 => 0x1 },
	'pf20limitcontinousshots' => { 83 => 0x15 },
	'pf20maxcontinousshots' => { 82 => 0xb },
	'pf21enablequietoperation' => { 83 => 0x16 },
	'pf23felocktime' => { 82 => 0xd },
	'pf23postreleasetime' => { 82 => 0xe },
	'pf23settimerlengths' => { 83 => 0x18 },
	'pf23shutterbuttontime' => { 82 => 0xc },
	'pf24lightlcdduringbulb' => { 83 => 0x19 },
	'pf25aemode' => { 82 => 0xf },
	'pf25afmode' => { 82 => 0x12 },
	'pf25afpointsel' => { 82 => 0x13 },
	'pf25colormatrix' => { 82 => 0x17 },
	'pf25defaultclearsettings' => { 83 => 0x1a },
	'pf25drivemode' => { 82 => 0x11 },
	'pf25imagesize' => { 82 => 0x14 },
	'pf25meteringmode' => { 82 => 0x10 },
	'pf25parameters' => { 82 => 0x16 },
	'pf25wbmode' => { 82 => 0x15 },
	'pf26shortenreleaselag' => { 83 => 0x1b },
	'pf27reversedialrotation' => { 83 => 0x1c },
	'pf27value' => { 82 => 0x18 },
	'pf28noquickdialexpcomp' => { 83 => 0x1d },
	'pf29quickdialswitchoff' => { 83 => 0x1e },
	'pf2disablemeteringmodes' => { 83 => 0x3 },
	'pf2value' => { 82 => 0x2 },
	'pf30enlargementmode' => { 83 => 0x1f },
	'pf31originaldecisiondata' => { 83 => 0x20 },
	'pf3manualexposuremetering' => { 83 => 0x4 },
	'pf3value' => { 82 => 0x3 },
	'pf4exposuretimelimits' => { 83 => 0x5 },
	'pf4exposuretimemax' => { 82 => 0x5 },
	'pf4exposuretimemin' => { 82 => 0x4 },
	'pf5aperturelimits' => { 83 => 0x6 },
	'pf5aperturemax' => { 82 => 0x7 },
	'pf5aperturemin' => { 82 => 0x6 },
	'pf6presetshootingmodes' => { 83 => 0x7 },
	'pf7bracketcontinuousshoot' => { 83 => 0x8 },
	'pf8bracketshots' => { 82 => 0x8 },
	'pf8setbracketshots' => { 83 => 0x9 },
	'pf9changebracketsequence' => { 83 => 0xa },
	'phasedetectaf' => { 173 => 0x6 },
	'phonenumber' => { 140 => 'Phone' },
	'photoeffect' => { 33 => 0x28 },
	'photoeffecthistoryxml' => { 236 => 0xe9651831 },
	'photoeffects' => { 236 => 0xab5eca5e },
	'photoeffectsblue' => { 238 => 0x8 },
	'photoeffectsgreen' => { 238 => 0x6 },
	'photoeffectsred' => { 238 => 0x4 },
	'photoeffectstype' => { 238 => 0x0 },
	'photographicsensitivity' => { 417 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 243 => '17.6', 252 => '33.6' },
	'photometricinterpretation' => { 109 => 0x106, 432 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 216 => 0xe7d },
	'photoshootingmenubankimagearea' => { 216 => '3716.1' },
	'photoshopbgrthumbnail' => { 328 => 0x409 },
	'photoshopquality' => { 327 => 0x0 },
	'photoshopthumbnail' => { 328 => 0x40c },
	'photostyle' => { 280 => 0x89 },
	'picklabel' => { 415 => 'PickLabel' },
	'pictinfo' => { 347 => 0x208 },
	'picturecontrol' => { 236 => 0xe2173c47 },
	'picturecontrolactive' => { 239 => 0x0 },
	'picturecontroladjust' => { 200 => 0x30, 201 => 0x30 },
	'picturecontrolbase' => { 200 => 0x18, 201 => 0x18 },
	'picturecontroldata' => { 198 => [0xbd,0x23] },
	'picturecontrolmode' => { 239 => 0x13 },
	'picturecontrolname' => { 200 => 0x4, 201 => 0x4 },
	'picturecontrolquickadjust' => { 200 => 0x31, 201 => 0x31 },
	'pictureeffect' => { 368 => 0x200e },
	'pictureeffect2' => { 375 => 0x1163, 376 => 0x1167, 377 => 0x1143, 378 => 0x11bf, 379 => 0x119b, 380 => 0x1053, 381 => 0x24b, 382 => 0x24b, 393 => 0x46 },
	'picturefinish' => { 162 => 0x71 },
	'picturemode' => { 114 => 0x1031, 259 => 0x520, 314 => [0xb,0x33], 348 => 0x3d },
	'picturemode2' => { 295 => 0x0 },
	'picturemodebwfilter' => { 259 => 0x525 },
	'picturemodecontrast' => { 259 => 0x523 },
	'picturemodeeffect' => { 259 => 0x52d },
	'picturemodehue' => { 259 => 0x522 },
	'picturemodesaturation' => { 259 => 0x521 },
	'picturemodesharpness' => { 259 => 0x524 },
	'picturemodetone' => { 259 => 0x526 },
	'pictureprofile' => { 375 => [0x115e,0x115f], 376 => [0x1162,0x1163], 377 => [0x113e,0x113f], 378 => [0x11ba,0x11bb], 379 => [0x1196,0x1197], 380 => [0x104e,0x104f], 381 => [0x246,0x247], 382 => [0x246,0x247] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 26 => 0x169, 67 => 0xa, 94 => 0x20301, 100 => 0x2 },
	'picturewizard' => { 345 => 0x21 },
	'picturewizardcolor' => { 344 => 0x1 },
	'picturewizardcontrast' => { 344 => 0x4 },
	'picturewizardmode' => { 344 => 0x0 },
	'picturewizardsaturation' => { 344 => 0x2 },
	'picturewizardsharpness' => { 344 => 0x3 },
	'pipelineversion' => { 157 => 'PipelineVersion' },
	'pitch' => { 106 => 0x6, 244 => '4.1', 256 => '4.1' },
	'pitchangle' => { 215 => 0x350f, 224 => 0x36f8, 259 => 0x904, 280 => 0x91, 313 => 0x2 },
	'pixelshiftresolution' => { 315 => 0x0 },
	'pixelsperunitx' => { 271 => 0x0 },
	'pixelsperunity' => { 271 => 0x4 },
	'pixelunits' => { 271 => 0x8 },
	'planarconfiguration' => { 109 => 0x11c, 432 => 'PlanarConfiguration' },
	'platenames' => { 441 => 'PlateNames' },
	'platform' => { 426 => 'platform' },
	'playbackmenustime' => { 248 => '20.1', 249 => '21.1', 250 => '21.1' },
	'playbackmonitorofftime' => { 243 => '25.2', 244 => '36.1', 246 => '36.1', 247 => '36.1', 251 => '35.1', 252 => '8.1', 253 => '35.1', 256 => '36.1', 257 => '21.1' },
	'playbackzoom' => { 244 => '37.1' },
	'playdisplay' => { 164 => 0x4e },
	'plusversion' => { 269 => 'Version' },
	'pmversion' => { 326 => 'PMVersion' },
	'pngwarning' => { 272 => 'Warning' },
	'poilevel' => { 197 => 0x8 },
	'portraitoutputhighlightpoint' => { 100 => 0x1d },
	'portraitoutputshadowpoint' => { 100 => 0x1e },
	'portraitrawcolortone' => { 100 => 0x16 },
	'portraitrawcontrast' => { 100 => 0x18 },
	'portraitrawhighlight' => { 100 => 0x76 },
	'portraitrawhighlightpoint' => { 100 => 0x1b },
	'portraitrawlinear' => { 100 => 0x19 },
	'portraitrawsaturation' => { 100 => 0x17 },
	'portraitrawshadow' => { 100 => 0x7f },
	'portraitrawshadowpoint' => { 100 => 0x1c },
	'portraitrawsharpness' => { 100 => 0x1a },
	'portraitrefiner' => { 104 => 0x302b },
	'portraitunsharpmaskfineness' => { 100 => 0x9a },
	'portraitunsharpmaskstrength' => { 100 => 0x98 },
	'portraitunsharpmaskthreshold' => { 100 => 0x9c },
	'poseheadingdegrees' => { 401 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 401 => 'PosePitchDegrees' },
	'poserolldegrees' => { 401 => 'PoseRollDegrees' },
	'positiondescriptor' => { 425 => 'positionDescriptor' },
	'postalcode' => { 144 => 'PostalCode' },
	'postcropvignetteamount' => { 412 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 412 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 412 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 412 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 412 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 412 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 366 => 0xb },
	'potentialface2position' => { 366 => 0x15 },
	'potentialface3position' => { 366 => 0x1f },
	'potentialface4position' => { 366 => 0x29 },
	'potentialface5position' => { 366 => 0x33 },
	'potentialface6position' => { 366 => 0x3d },
	'potentialface7position' => { 366 => 0x47 },
	'potentialface8position' => { 366 => 0x51 },
	'powersource' => { 293 => '0.1' },
	'poweruptime' => { 198 => 0xb6 },
	'precaptureframes' => { 264 => 0x300 },
	'predictor' => { 109 => 0x13d },
	'preflashreturnstrength' => { 213 => 0x28a },
	'prefs' => { 117 => 0xdd, 326 => 'Prefs' },
	'preservedfilename' => { 437 => 'PreservedFileName' },
	'presetwhitebalance' => { 164 => 0x24, 397 => 0x8002 },
	'presetwhitebalanceadj' => { 397 => 0x8014 },
	'pressure' => { 109 => 0x9402 },
	'previewapplicationname' => { 109 => 0xc716 },
	'previewapplicationversion' => { 109 => 0xc717 },
	'previewbutton' => { 243 => ['14.1','15.1'], 244 => '15.1', 246 => '15.1', 247 => '15.1', 252 => '29.1', 253 => '14.1', 256 => '15.1' },
	'previewbuttonplusdials' => { 243 => ['14.2','15.2'], 244 => '15.2', 246 => '43.1', 247 => '43.1', 252 => '31.2', 256 => '43.1' },
	'previewcolorspace' => { 109 => 0xc71a },
	'previewcropbottom' => { 325 => 0xef },
	'previewcropleft' => { 325 => 0xec },
	'previewcropright' => { 325 => 0xee },
	'previewcroptop' => { 325 => 0xed },
	'previewdate' => { 333 => 0x0 },
	'previewdatetime' => { 109 => 0xc71b },
	'previewimage' => { 104 => 0x2000, 105 => 'PreviewImage', 110 => 'PreviewImage', 112 => 0x4, 149 => 'data', 166 => 0x81, 264 => 0x280, 279 => 0x300, 368 => 0x2001 },
	'previewimageborders' => { 314 => 0x3e },
	'previewimageheight' => { 66 => 0x4, 127 => 0xfa58 },
	'previewimagelength' => { 66 => 0x2, 104 => 0x3, 109 => [0x117,0x202], 166 => 0x89, 202 => 0x202, 259 => 0x102, 264 => 0x1037, 314 => 0x3, 338 => 0x1e, 343 => 0x3, 348 => [0x1b,0x1d], 359 => 0x202 },
	'previewimagename' => { 149 => '1Name' },
	'previewimagesize' => { 104 => 0x2, 132 => 0x2, 149 => 'ImageSize', 314 => 0x2, 348 => [0x1c,0x1e], 368 => 0xb02c },
	'previewimagestart' => { 66 => 0x5, 104 => 0x4, 109 => [0x111,0x201], 166 => 0x88, 202 => 0x201, 259 => 0x101, 264 => 0x1036, 314 => 0x4, 338 => 0x1c, 343 => 0x2, 348 => [0x1a,0x1c], 359 => 0x201 },
	'previewimagetype' => { 149 => '0Type' },
	'previewimagevalid' => { 259 => 0x100, 264 => 0x1035 },
	'previewimagewidth' => { 66 => 0x3, 127 => 0xfa57 },
	'previewquality' => { 66 => 0x1 },
	'previewsettingsdigest' => { 109 => 0xc719 },
	'previewsettingsname' => { 109 => 0xc718 },
	'primaryafpoint' => { 173 => 0x7 },
	'primarychromaticities' => { 109 => 0x13f, 432 => 'PrimaryChromaticities' },
	'primaryslot' => { 216 => 0xe7f },
	'printim' => { 109 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 164 => 0x1d, 356 => 0x28 },
	'privatertkinfo' => { 403 => 'privateRTKInfo' },
	'processingsoftware' => { 109 => 0xb },
	'processversion' => { 412 => 'ProcessVersion' },
	'producer' => { 268 => 'Producer', 423 => 'Producer' },
	'productcode' => { 426 => 'productCode' },
	'productid' => { 118 => 0x32, 425 => 'productID' },
	'productidtype' => { 425 => 'productIDType' },
	'productinimage' => { 422 => 'ProductInImage' },
	'productinimagedescription' => { 422 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 422 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 422 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 294 => 0x2 },
	'productorserviceconstraints' => { 269 => 'ProductOrServiceConstraints' },
	'profession' => { 426 => 'profession' },
	'profilecalibrationsig' => { 109 => 0xc6f4 },
	'profilecopyright' => { 109 => 0xc6fe },
	'profileembedpolicy' => { 109 => 0xc6fd },
	'profilehuesatmapdata1' => { 109 => 0xc6fa },
	'profilehuesatmapdata2' => { 109 => 0xc6fb },
	'profilehuesatmapdims' => { 109 => 0xc6f9 },
	'profilehuesatmapencoding' => { 109 => 0xc7a3 },
	'profilelooktabledata' => { 109 => 0xc726 },
	'profilelooktabledims' => { 109 => 0xc725 },
	'profilelooktableencoding' => { 109 => 0xc7a4 },
	'profilename' => { 109 => 0xc6f8 },
	'profiletonecurve' => { 109 => 0xc6fc },
	'programiso' => { 280 => 0x3c },
	'programline' => { 295 => '1.1' },
	'programmode' => { 169 => 0x5 },
	'programshift' => { 198 => 0xd },
	'programversion' => { 117 => 0x46 },
	'prohibits' => { 409 => 'prohibits' },
	'projectiontype' => { 401 => 'ProjectionType' },
	'projectname' => { 436 => 'projectName' },
	'projectref' => { 436 => 'projectRef' },
	'projectrefpath' => { 436 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 436 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 269 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 269 => 'PropertyReleaseStatus' },
	'province-state' => { 117 => 0x5f },
	'publicationdate' => { 426 => 'publicationDate' },
	'publicationdatea-platform' => { 426 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 426 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 426 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 426 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 426 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationname' => { 426 => 'publicationName' },
	'publisher' => { 413 => 'publisher' },
	'publishingfrequency' => { 426 => 'publishingFrequency' },
	'pulldown' => { 436 => 'pullDown' },
	'purplehsl' => { 94 => 0x20916 },
	'quality' => { 0 => 0x1, 33 => 0x3, 103 => 0x2, 104 => 0x3002, 114 => 0x1000, 125 => 0x9, 198 => 0x4, 226 => 0x3, 264 => 0x201, 276 => 0x300, 314 => 0x8, 321 => 0x2, 348 => 0x16, 356 => 0x56, 357 => 0x56, 358 => 0xb, 368 => 0x102 },
	'quality2' => { 375 => 0x1170, 376 => 0x1174, 377 => 0x1150, 379 => 0x11a8, 380 => 0x1060, 381 => 0x258, 382 => 0x258, 385 => 0x29, 386 => 0x25, 387 => 0x2a },
	'qualitymode' => { 104 => 0x8 },
	'quantizationmethod' => { 119 => 0x78 },
	'quickadjust' => { 239 => 0x2a },
	'quickcontroldialinmeter' => { 75 => 0x703 },
	'quickfix' => { 236 => 0x416391c6 },
	'quickshot' => { 347 => 0x213 },
	'rangefinder' => { 248 => '4.1', 249 => '5.1', 250 => '5.1' },
	'rasterizedcaption' => { 117 => 0x7d },
	'rating' => { 109 => 0x4746, 114 => 0x1431, 325 => 0xdf, 368 => 0x2002, 406 => 'rating', 414 => 'rating', 426 => 'rating', 434 => 'Rating' },
	'ratingpercent' => { 109 => 0x4749, 159 => 'Rating' },
	'rawandjpgrecording' => { 73 => 0x8, 166 => 0x109, 295 => 0xd },
	'rawbrightnessadj' => { 94 => 0x20001, 99 => 0x38 },
	'rawcoloradj' => { 99 => 0x2e },
	'rawcropbottom' => { 325 => 0xd4 },
	'rawcropleft' => { 325 => 0xd1 },
	'rawcropright' => { 325 => 0xd3 },
	'rawcroptop' => { 325 => 0xd2 },
	'rawcustomsaturation' => { 99 => 0x30 },
	'rawcustomtone' => { 99 => 0x34 },
	'rawdata' => { 345 => 0xa048 },
	'rawdatauniqueid' => { 109 => 0xc65d },
	'rawdepth' => { 168 => 0x10 },
	'rawdevartfilter' => { 266 => 0x121 },
	'rawdevautogradation' => { 266 => 0x119 },
	'rawdevcolorspace' => { 265 => 0x108, 266 => 0x109 },
	'rawdevcontrastvalue' => { 265 => 0x106, 266 => 0x105 },
	'rawdeveditstatus' => { 265 => 0x10b },
	'rawdevelopmentprocess' => { 314 => 0x62 },
	'rawdevengine' => { 265 => 0x109, 266 => 0x10b },
	'rawdevexposurebiasvalue' => { 265 => 0x100, 266 => 0x100 },
	'rawdevgradation' => { 266 => 0x112 },
	'rawdevgraypoint' => { 265 => 0x103, 266 => 0x104 },
	'rawdevmemorycoloremphasis' => { 265 => 0x105, 266 => 0x108 },
	'rawdevnoisereduction' => { 265 => 0x10a, 266 => 0x10a },
	'rawdevpicturemode' => { 266 => 0x10c },
	'rawdevpm_bwfilter' => { 266 => 0x110 },
	'rawdevpmcontrast' => { 266 => 0x10e },
	'rawdevpmnoisefilter' => { 266 => 0x120 },
	'rawdevpmpicturetone' => { 266 => 0x111 },
	'rawdevpmsaturation' => { 266 => 0x10d },
	'rawdevpmsharpness' => { 266 => 0x10f },
	'rawdevsaturation3' => { 266 => 0x113 },
	'rawdevsaturationemphasis' => { 265 => 0x104, 266 => 0x107 },
	'rawdevsettings' => { 265 => 0x10c },
	'rawdevsharpnessvalue' => { 265 => 0x107, 266 => 0x106 },
	'rawdevversion' => { 265 => 0x0, 266 => 0x0 },
	'rawdevwbfineadjustment' => { 265 => 0x102, 266 => 0x103 },
	'rawdevwhitebalance' => { 266 => 0x101 },
	'rawdevwhitebalancevalue' => { 265 => 0x101, 266 => 0x102 },
	'rawfile' => { 109 => 0xfe4c },
	'rawfilename' => { 412 => 'RawFileName' },
	'rawformat' => { 323 => 0x10e },
	'rawimagecenter' => { 198 => 0x99 },
	'rawimagedigest' => { 109 => 0xc71c },
	'rawimagesize' => { 314 => 0x39 },
	'rawinfoversion' => { 267 => 0x0 },
	'rawjpgheight' => { 90 => 0x4 },
	'rawjpgquality' => { 51 => 0x6, 90 => 0x1 },
	'rawjpgsize' => { 51 => 0x7, 90 => 0x2 },
	'rawjpgwidth' => { 90 => 0x3 },
	'rawmeasuredrggb' => { 38 => 0x26a, 40 => 0x280, 42 => 0x194, 43 => [0x1ad,0x26b] },
	'rawrppused' => { 406 => 'rawrppused' },
	'rawtopreviewgain' => { 109 => 0xc7a8 },
	'reardisplay' => { 243 => '12.3', 244 => '6.2' },
	'recipeendingpage' => { 428 => 'recipeEndingPage' },
	'recipepagerange' => { 428 => 'recipePageRange' },
	'recipesource' => { 428 => 'recipeSource' },
	'recipestartingpage' => { 428 => 'recipeStartingPage' },
	'recipetitle' => { 428 => 'recipeTitle' },
	'recognizedface1age' => { 275 => 0x20 },
	'recognizedface1name' => { 275 => 0x4 },
	'recognizedface1position' => { 275 => 0x18 },
	'recognizedface2age' => { 275 => 0x50 },
	'recognizedface2name' => { 275 => 0x34 },
	'recognizedface2position' => { 275 => 0x48 },
	'recognizedface3age' => { 275 => 0x80 },
	'recognizedface3name' => { 275 => 0x64 },
	'recognizedface3position' => { 275 => 0x78 },
	'recognizedfaceflags' => { 280 => 0x63 },
	'recommendedexposureindex' => { 109 => 0x8832, 417 => 'RecommendedExposureIndex' },
	'record' => { 108 => 'Record' },
	'recordbasisofrecord' => { 108 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 108 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 108 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 108 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 108 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 108 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 164 => 0x4d },
	'recorddynamicproperties' => { 108 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 88 => 0x1804 },
	'recordinformationwithheld' => { 108 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 339 => 0x1000 },
	'recordingmode' => { 103 => 0x1, 321 => 0x1 },
	'recordinstitutioncode' => { 108 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 108 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 33 => 0x9, 104 => 0x3000 },
	'recordownerinstitutioncode' => { 108 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 347 => 0x217 },
	'redbalance' => { 181 => 0x270, 264 => 0x1017, 284 => 0x11, 314 => 0x1c },
	'redcurvelimits' => { 99 => 0x18a },
	'redcurvepoints' => { 98 => 0x2d, 99 => 0x160 },
	'redeyecorrection' => { 240 => 0x0 },
	'redeyeinfo' => { 412 => 'RedEyeInfo' },
	'redeyereduction' => { 164 => 0x41, 356 => 0x6a, 358 => 0x28 },
	'redhsl' => { 94 => 0x20910 },
	'redhue' => { 412 => 'RedHue' },
	'redsaturation' => { 412 => 'RedSaturation' },
	'reductionmatrix1' => { 109 => 0xc625 },
	'reductionmatrix2' => { 109 => 0xc626 },
	'reelname' => { 109 => 0xc789 },
	'reference1' => { 420 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 420 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 420 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 420 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 420 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 420 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 109 => 0x214, 432 => 'ReferenceBlackWhite' },
	'referencedate' => { 117 => 0x2f },
	'referencenumber' => { 117 => 0x32 },
	'references' => { 140 => 'References' },
	'referenceservice' => { 117 => 0x2d },
	'regionappliedtodimensions' => { 155 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 155 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 155 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 155 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 155 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 155 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 155 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 155 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 155 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 155 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 155 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 155 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 269 => 'RegionConstraints' },
	'regiondescription' => { 155 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 155 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 155 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 155 => 'Regions' },
	'regioninfodateregionsvalid' => { 156 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 156 => 'RegionInfo' },
	'regioninforegions' => { 156 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 155 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 155 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 156 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 156 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 156 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 156 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 156 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 155 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 155 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 155 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 422 => 'RegistryId' },
	'registryitemid' => { 422 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 422 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 138 => 'data' },
	'relatedaudiofilename' => { 138 => '1Name' },
	'relatedaudiofiletype' => { 138 => '0Type' },
	'relatedimagefileformat' => { 109 => 0x1000 },
	'relatedimageheight' => { 109 => 0x1002 },
	'relatedimagewidth' => { 109 => 0x1001 },
	'relatedresourceid' => { 108 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 109 => 0xa004, 416 => 'RelatedSoundFile' },
	'relatedvideofile' => { 152 => 'data' },
	'relatedvideofilename' => { 152 => '1Name' },
	'relatedvideofiletype' => { 152 => '0Type' },
	'relation' => { 413 => 'relation' },
	'relationshipaccordingto' => { 108 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 108 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 108 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 108 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 436 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 436 => 'relativeTimestamp' },
	'relativetimestampscale' => { 436 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 436 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 243 => '17.8', 244 => '18.5', 246 => '18.4', 247 => '18.4', 252 => '33.8', 253 => '17.6', 256 => '18.5' },
	'releasedate' => { 117 => 0x1e, 406 => 'ReleaseDate', 436 => 'releaseDate' },
	'releasemode' => { 104 => 0x3001, 215 => 0x184d, 368 => 0xb049 },
	'releasemode2' => { 375 => 0x112c, 376 => [0x112c,0x8], 377 => [0x1108,0x8], 378 => [0x1184,0x8], 379 => [0x1160,0x8], 380 => [0x4,0x1018], 381 => [0x4,0x210], 382 => [0x4,0x210], 384 => [0x67,0x73,0x3f,0x4b], 385 => 0x10, 386 => 0x10, 387 => 0x9, 393 => 0x34 },
	'releasemode3' => { 375 => 0x1128, 376 => 0x1128, 377 => 0x1104, 378 => 0x1180, 379 => 0x115c, 380 => 0x1014, 381 => 0x20c, 382 => 0x20c },
	'releasesetting' => { 88 => 0x1016 },
	'releasetime' => { 117 => 0x23, 406 => 'ReleaseTime' },
	'remoteonduration' => { 245 => '3.4', 248 => '17.2', 249 => '18.2', 250 => '18.2', 251 => '18.2', 253 => '18.2', 254 => '4.3', 257 => '19.2' },
	'renditionclass' => { 437 => 'RenditionClass' },
	'renditionof' => { 437 => 'RenditionOf' },
	'renditionofalternatepaths' => { 437 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 437 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 437 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 437 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 437 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 437 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 437 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 437 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 437 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 437 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 437 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 437 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 437 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 437 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 437 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 437 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 437 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 437 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 437 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 437 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 437 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 437 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 437 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 437 => 'RenditionParams' },
	'repeatingflashcount' => { 186 => 0xd, 187 => 0xe, 188 => 0xe, 252 => '17.2', 253 => '24.2', 254 => '9.2', 255 => '24.2', 257 => '25.2' },
	'repeatingflashcountbuilt-in' => { 223 => 0x4db },
	'repeatingflashcountexternal' => { 223 => 0x4c3 },
	'repeatingflashoutput' => { 252 => '17.1', 253 => '24.1', 254 => '9.1', 255 => '24.1', 257 => '25.1' },
	'repeatingflashoutputexternal' => { 223 => 0x4c0 },
	'repeatingflashrate' => { 186 => 0xc, 187 => 0xd, 188 => 0xd, 252 => '18.1', 253 => '25.1', 254 => '10.1', 255 => '25.1', 257 => '26.1' },
	'repeatingflashratebuilt-in' => { 223 => 0x4da },
	'repeatingflashrateexternal' => { 223 => 0x4c2 },
	'requires' => { 409 => 'requires' },
	'resampleparams' => { 436 => 'resampleParams' },
	'resampleparamsquality' => { 436 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 347 => 0x21e },
	'resolution' => { 145 => 'Resolution' },
	'resolutionmode' => { 348 => 0x4 },
	'resolutionunit' => { 109 => 0x128, 120 => 0x2, 432 => 'ResolutionUnit' },
	'resourceid' => { 108 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 108 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 108 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 75 => 0x612 },
	'restrictions' => { 429 => 'restrictions' },
	'retouchareafeather' => { 412 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 412 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 412 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 412 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 412 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 412 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 412 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 412 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 412 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 412 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 412 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 412 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 412 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 412 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 412 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 412 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 412 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 412 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 412 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 412 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 412 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 412 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 412 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 412 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 412 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 412 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 412 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 412 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 412 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 412 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 412 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 412 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 412 => 'RetouchAreas' },
	'retouchareaseed' => { 412 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 412 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 412 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 412 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 198 => 0x9e },
	'retouchinfo' => { 412 => 'RetouchInfo' },
	'retouchnefprocessing' => { 204 => 0x5 },
	'retractlensonpoweroff' => { 75 => 0x814 },
	'reuse' => { 269 => 'Reuse' },
	'reuseallowed' => { 439 => 'ReuseAllowed' },
	'reuseprohibited' => { 429 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 250 => '5.2' },
	'reverseindicators' => { 243 => '12.1', 244 => '6.1', 246 => '6.1', 247 => '6.1', 248 => '4.3', 249 => '5.2', 250 => '5.4', 252 => '33.5', 253 => '5.1', 256 => '6.1', 257 => '6.2' },
	'reverseshutterspeedaperture' => { 250 => '5.3' },
	'revision' => { 414 => 'revision' },
	'rgbcurvelimits' => { 99 => 0x238 },
	'rgbcurvepoints' => { 98 => 0x7, 99 => 0x20e },
	'richtextcomment' => { 419 => 'RichTextComment' },
	'ricohdate' => { 338 => 0x6 },
	'ricohimageheight' => { 338 => 0x2 },
	'ricohimagewidth' => { 338 => 0x0 },
	'rightascension' => { 148 => 'RightAscension' },
	'rights' => { 413 => 'rights' },
	'rightsagent' => { 429 => 'rightsAgent' },
	'rightsowner' => { 429 => 'rightsOwner' },
	'roll' => { 106 => 0x8 },
	'rollangle' => { 215 => 0x350b, 224 => 0x36f4, 259 => 0x903, 280 => 0x90, 313 => 0x1 },
	'romoperationmode' => { 88 => 0x80d },
	'rotation' => { 29 => 0x17, 30 => 0x18, 87 => 0x3, 94 => 0x10002, 99 => 0x26e, 113 => 0x4, 148 => 'Rotation', 162 => [0x65,0x50], 163 => 0x46, 164 => 0x5a, 167 => 0x10, 215 => 0x3693, 216 => 0xca, 222 => '590.1', 224 => 0x38be, 236 => 0x76a43207, 280 => 0x30, 295 => '17.2', 325 => 0xd8, 356 => 0x3f, 357 => 0x3f, 367 => 0x10 },
	'routedto' => { 418 => 'RoutedTo' },
	'routing' => { 330 => 'Routing' },
	'routingnotes' => { 418 => 'RoutingNotes' },
	'rowsperstrip' => { 109 => 0x116 },
	'rpp' => { 406 => 'rpp' },
	'safetyshift' => { 75 => 0x108 },
	'safetyshiftinavortv' => { 73 => 0x10, 74 => 0x10, 76 => 0xf, 77 => 0x10, 80 => 0x10 },
	'sameexposurefornewaperture' => { 75 => 0x112 },
	'samplebits' => { 138 => 'SampleBits' },
	'samplepagerange' => { 426 => 'samplePageRange' },
	'samplerate' => { 138 => 'SampleRate' },
	'samplesperpixel' => { 109 => 0x115, 432 => 'SamplesPerPixel' },
	'samplestructure' => { 119 => 0x5a },
	'samsungmodelid' => { 345 => 0x3 },
	'sanyoquality' => { 347 => 0x201 },
	'sanyothumbnail' => { 347 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 33 => 0xe, 45 => 0x1, 103 => 0xd, 104 => [0x3013,0x1f], 109 => [0xa409,0xfe55], 114 => 0x1003, 139 => 'Saturation', 161 => 0x1f, 162 => 0x32, 163 => 0x28, 164 => 0x1a, 169 => 0x1, 198 => [0x94,0xaa], 200 => 0x35, 201 => 0x3b, 280 => 0x40, 282 => 0x300d, 314 => 0x1f, 321 => 0xd, 335 => 0x27, 338 => 0x28, 339 => 0x1013, 348 => 0x10, 356 => 0x1e, 357 => 0x1b, 368 => 0x2005, 412 => 'Saturation', 416 => 'Saturation' },
	'saturationadj' => { 94 => 0x20901, 99 => 0x116, 235 => 0x1, 239 => 0x2e, 397 => 0x8016 },
	'saturationadjustmentaqua' => { 412 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 412 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 412 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 412 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 412 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 412 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 412 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 412 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 64 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 63 => 0x68, 64 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 63 => 0x38, 64 => 0x38 },
	'saturationmonochrome' => { 63 => 0x80, 64 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 63 => 0x50, 64 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 63 => 0x20, 64 => 0x20 },
	'saturationsetting' => { 267 => 0x1010, 358 => 0x11, 372 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 63 => 0x8, 64 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 63 => 0x98, 64 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 63 => 0xb0, 64 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 63 => 0xc8, 64 => 0xe0 },
	'saveid' => { 437 => 'SaveID' },
	'scaletype' => { 436 => 'scaleType' },
	'scanimageenhancer' => { 205 => 0x60 },
	'scanningdirection' => { 119 => 0x64 },
	'scene' => { 421 => 'Scene', 436 => 'scene' },
	'scenearea' => { 262 => 0x211, 264 => 0x1031 },
	'sceneassist' => { 198 => 0x9c },
	'scenecapturetype' => { 109 => 0xa406, 416 => 'SceneCaptureType' },
	'scenedetect' => { 262 => 0x210, 264 => 0x1030 },
	'scenedetectdata' => { 262 => 0x212, 264 => 0x1033 },
	'scenemode' => { 127 => 0xfa02, 166 => 0x100, 198 => 0x8f, 259 => 0x509, 264 => 0x403, 280 => 0x8001, 288 => 0xf, 368 => 0xb023 },
	'scenemodeused' => { 129 => [0x6002,0xf002] },
	'sceneselect' => { 347 => 0x21f },
	'scenetype' => { 109 => 0xa301, 416 => 'SceneType' },
	'screentips' => { 243 => '12.7', 244 => '5.3', 252 => '13.1', 253 => '4.4', 256 => '5.4', 257 => '5.1' },
	'season' => { 425 => 'season' },
	'secondaryslotfunction' => { 215 => 0x1d0, 224 => 0x1d0 },
	'section' => { 426 => 'section' },
	'securityclassification' => { 109 => 0x9212 },
	'selectableafpoint' => { 75 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 75 => 0x512 },
	'selftimer' => { 33 => 0x2, 280 => 0x2e, 347 => 0x214, 375 => 0x1134, 376 => 0x1134, 377 => 0x1110, 378 => 0x118c, 379 => 0x1168, 380 => 0x1020, 381 => 0x218, 382 => 0x218 },
	'selftimer2' => { 69 => 0x1d },
	'selftimerinterval' => { 253 => '19.2' },
	'selftimermode' => { 109 => 0x882b },
	'selftimershotcount' => { 244 => '20.2', 246 => '20.3', 247 => '20.3', 248 => '18.2', 249 => '19.2', 250 => '19.2', 251 => '19.3', 253 => '19.3', 256 => '20.3', 257 => '20.2' },
	'selftimershotinterval' => { 244 => '20.3', 246 => '20.2', 247 => '20.2', 251 => '19.2', 256 => '20.2' },
	'selftimertime' => { 88 => 0x1806, 164 => 0x1f, 243 => '18.1', 244 => '20.1', 245 => '3.3', 246 => '20.1', 247 => '20.1', 248 => '18.1', 249 => '19.1', 250 => '19.1', 251 => '19.1', 252 => '7.2', 253 => '19.1', 254 => '3.3', 256 => '20.1', 257 => '20.1' },
	'sellingagency' => { 426 => 'sellingAgency' },
	'seminfo' => { 109 => 0x8546 },
	'sensingmethod' => { 109 => 0xa217, 416 => 'SensingMethod' },
	'sensitivityadjust' => { 314 => 0x40 },
	'sensitivitysteps' => { 295 => ['14.3','17.4'], 297 => 0x1 },
	'sensitivitytype' => { 109 => 0x8830, 417 => 'SensitivityType' },
	'sensor' => { 171 => 0x665e },
	'sensorareas' => { 345 => 0xa010 },
	'sensorbitdepth' => { 282 => 0x312d },
	'sensorbluelevel' => { 67 => 0x5 },
	'sensorcalibration' => { 263 => 0x805 },
	'sensorcleaning' => { 81 => 0xd },
	'sensorfullheight' => { 122 => 0xf904 },
	'sensorfullwidth' => { 122 => 0xf903 },
	'sensorheight' => { 122 => 0xf901, 127 => 0xfa21, 168 => 0x8, 282 => 0x312c, 323 => 0x109, 339 => 0x1602 },
	'sensorleftmargin' => { 323 => 0x10a },
	'sensorpixelsize' => { 198 => 0x9a },
	'sensorredlevel' => { 67 => 0x4 },
	'sensorserialnumber' => { 123 => 0x9ce },
	'sensorsize' => { 139 => 'SensorSize', 314 => 0x35 },
	'sensortemperature' => { 262 => 0x1500, 264 => 0x1007, 319 => 0xc, 323 => 0x210, 348 => [0x39,0x55] },
	'sensortemperature2' => { 319 => 0xe, 323 => 0x211 },
	'sensortopmargin' => { 323 => 0x10b },
	'sensorwidth' => { 122 => 0xf900, 127 => 0xfa20, 168 => 0xa, 282 => 0x312b, 323 => 0x108, 339 => 0x1601 },
	'sequence' => { 335 => 0x7 },
	'sequencefilenumber' => { 376 => 0x4, 377 => 0x4, 378 => 0x4, 379 => 0x4, 385 => 0xc, 386 => 0xc, 387 => 0x1a },
	'sequenceimagenumber' => { 376 => 0x0, 377 => 0x0, 378 => 0x0, 379 => 0x0, 385 => 0x8, 386 => 0x8, 387 => 0x12, 393 => 0x24 },
	'sequencelength' => { 385 => 0x22, 386 => 0x1e, 387 => [0x16,0x1e] },
	'sequencename' => { 425 => 'sequenceName' },
	'sequencenumber' => { 69 => 0x9, 104 => 0x301c, 114 => 0x1101, 125 => 0x1d, 223 => 0x51c, 280 => 0x2b, 358 => [0x10c,0x30c], 368 => 0xb04a, 425 => 'sequenceNumber' },
	'sequenceshotinterval' => { 347 => 0x224 },
	'sequencetotalnumber' => { 425 => 'sequenceTotalNumber' },
	'sequentialshot' => { 347 => 0x20e },
	'serialnumber' => { 57 => 0xc, 88 => 0x180b, 109 => [0xa431,0xfde9], 122 => 0xfa04, 124 => 0xfa00, 126 => 0xc354, 127 => 0xfa19, 136 => 0x0, 139 => 'SerialNumber', 198 => [0xa0,0x1d], 260 => 0x101, 264 => [0x404,0x101a], 276 => 0x303, 282 => 0x3103, 314 => 0x229, 323 => 0x102, 324 => 0x407, 335 => 0x15, 339 => 0x5, 348 => 0x2, 408 => 'SerialNumber', 417 => 'BodySerialNumber' },
	'serialnumberformat' => { 57 => 0x15, 88 => 0x183b },
	'seriesdatetime' => { 399 => 'SeriesDateTime' },
	'seriesdescription' => { 399 => 'SeriesDescription' },
	'seriesmodality' => { 399 => 'SeriesModality' },
	'seriesnumber' => { 399 => 'SeriesNumber', 426 => 'seriesNumber' },
	'seriestitle' => { 426 => 'seriesTitle' },
	'serviceidentifier' => { 118 => 0x1e },
	'servingsize' => { 428 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 78 => 0x0, 79 => 0x0 },
	'setbuttonwhenshooting' => { 73 => 0x1, 75 => 0x704, 81 => 0xc },
	'setfunctionwhenshooting' => { 76 => 0x0, 77 => 0x1, 80 => 0x1 },
	'setting' => { 425 => 'setting' },
	'shadingcompensation' => { 259 => 0x50c, 280 => 0x8a },
	'shadingcompensation2' => { 263 => 0x1012 },
	'shadow' => { 348 => 0xe },
	'shadowadj' => { 94 => 0x2030b },
	'shadowcorrection' => { 314 => 0x79 },
	'shadowprotection' => { 235 => 0x0 },
	'shadows' => { 109 => 0xfe52, 405 => 'Shadows', 412 => 'Shadows' },
	'shadows2012' => { 412 => 'Shadows2012' },
	'shadowscale' => { 109 => 0xc633 },
	'shadowtint' => { 412 => 'ShadowTint' },
	'shadowtone' => { 114 => 0x1040 },
	'shakereduction' => { 316 => 0x1, 317 => 0x1 },
	'sharpendetail' => { 412 => 'SharpenDetail' },
	'sharpenedgemasking' => { 412 => 'SharpenEdgeMasking' },
	'sharpening' => { 282 => 0x300b },
	'sharpeningadj' => { 239 => 0x2b },
	'sharpenradius' => { 412 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 33 => 0xf, 67 => 0x2, 103 => 0xb, 104 => [0x3011,0x21], 109 => [0xa40a,0xfe56], 114 => 0x1001, 125 => 0x6b, 134 => 0x37, 139 => 'Sharpness', 161 => 0x21, 162 => 0x30, 163 => 0x26, 164 => 0x18, 169 => 0x3, 198 => 0x6, 200 => 0x32, 201 => 0x33, 264 => 0x100f, 280 => 0x41, 314 => 0x21, 321 => 0xb, 335 => 0x26, 338 => 0x22, 339 => [0x1003,0x1014], 348 => 0x11, 356 => 0x1c, 357 => 0x19, 368 => 0x2006, 393 => 0x52, 412 => 'Sharpness', 416 => 'Sharpness' },
	'sharpnessadj' => { 94 => 0x20310, 99 => 0x25a, 397 => 0x801a },
	'sharpnessadjon' => { 94 => '0x20310.0' },
	'sharpnessauto' => { 64 => 0x94 },
	'sharpnessfactor' => { 264 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 63 => 0x64, 64 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 67 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 63 => 0x34, 64 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 63 => 0x7c, 64 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 63 => 0x4c, 64 => 0x4c },
	'sharpnessovershoot' => { 397 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 63 => 0x1c, 64 => 0x1c },
	'sharpnesssetting' => { 259 => 0x506, 267 => 0x1013, 358 => 0x12, 372 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 63 => 0x4, 64 => 0x4 },
	'sharpnessstrength' => { 94 => 0x20311 },
	'sharpnessthreshold' => { 397 => 0x801d },
	'sharpnessundershoot' => { 397 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 63 => 0x94, 64 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 63 => 0xac, 64 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 63 => 0xc4, 64 => 0xdc },
	'shootid' => { 425 => 'shootID' },
	'shootingdistance' => { 94 => 0x20701 },
	'shootinginfodisplay' => { 243 => '13.2', 244 => '5.1', 252 => '10.2', 253 => '4.1', 256 => '5.1', 257 => '5.3' },
	'shootinginfomonitorofftime' => { 243 => '26.2', 244 => '22.2', 246 => '22.2', 247 => '22.2', 251 => '21.2', 252 => '9.1', 253 => '21.2', 256 => '22.2', 257 => '22.2' },
	'shootingmode' => { 139 => 'ShootingMode', 198 => 0x89, 280 => 0x1f },
	'shootingmodesetting' => { 245 => '5.1' },
	'shortdescription' => { 414 => 'shortdescription' },
	'shortdocumentid' => { 117 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 75 => 0x80d },
	'shotdate' => { 436 => 'shotDate' },
	'shotday' => { 436 => 'shotDay' },
	'shotlocation' => { 436 => 'shotLocation' },
	'shotname' => { 436 => 'shotName' },
	'shotnumber' => { 436 => 'shotNumber' },
	'shotnumbersincepowerup' => { 371 => 0x44e, 385 => 0x1a, 386 => 0x16, 387 => 0xa },
	'shotnumbersincepowerup2' => { 358 => 0x200 },
	'shotsize' => { 436 => 'shotSize' },
	'shutter-aelock' => { 73 => 0x4, 75 => 0x701, 76 => 0x3, 77 => 0x4, 78 => 0x3, 79 => 0x3, 80 => 0x4, 81 => 0x2 },
	'shutteraelbutton' => { 74 => 0x4 },
	'shutterbuttonafonbutton' => { 75 => 0x701 },
	'shuttercount' => { 10 => 0x176, 51 => 0x1, 198 => 0xa7, 206 => [0x6a,0x157,0x24d], 207 => 0x286, 208 => 0x279, 209 => 0x284, 210 => 0x242, 211 => 0x280, 212 => 0x276, 213 => [0x27d,0x27f], 214 => 0x246, 217 => 0x2d6, 218 => 0x321, 219 => 0xbd8, 220 => 0x287, 221 => 0x320, 222 => 0x24a, 223 => 0x5fb, 225 => 0x2d5, 314 => 0x5d, 367 => 0x846, 370 => [0x125,0x14a] },
	'shuttercurtainsync' => { 73 => 0xf, 74 => 0xf, 75 => 0x305, 76 => 0xe, 77 => 0xf, 78 => 0x8, 79 => 0x8, 80 => 0xf, 81 => 0x8 },
	'shuttermode' => { 125 => 0x1b },
	'shutterreleasebuttonae-l' => { 243 => '17.7', 244 => '18.4', 246 => '78.4', 247 => '78.4', 248 => '16.1', 249 => '17.1', 250 => '17.1', 251 => '17.1', 252 => '7.1', 253 => '17.5', 256 => '18.4', 257 => '18.2' },
	'shutterreleasemethod' => { 88 => 0x1010 },
	'shutterreleasenocfcard' => { 73 => 0x2, 74 => 0x2, 81 => 0xf },
	'shutterreleasetiming' => { 88 => 0x1011 },
	'shutterreleasewithoutlens' => { 75 => 0x711 },
	'shutterspeedlock' => { 244 => '38.1', 246 => '38.1', 247 => '38.1', 256 => '38.1' },
	'shutterspeedrange' => { 75 => 0x10c },
	'shutterspeedsetting' => { 164 => 0x6, 356 => 0x2f, 357 => 0x28, 358 => 0x0 },
	'shutterspeedvalue' => { 84 => 0x1, 109 => 0x9201, 264 => 0x1000, 323 => 0x400, 416 => 'ShutterSpeedValue' },
	'shuttertype' => { 114 => 0x1050, 280 => 0x9f },
	'sidecarforextension' => { 424 => 'SidecarForExtension' },
	'similarityindex' => { 117 => 0xe4 },
	'singleframebracketing' => { 164 => 0x21 },
	'skilllevel' => { 428 => 'skillLevel' },
	'slaveflashmeteringsegments' => { 314 => 0x20b },
	'slideshowname' => { 425 => 'slideshowName' },
	'slideshownumber' => { 425 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 425 => 'slideshowTotalNumber' },
	'slowshutter' => { 69 => 0x8 },
	'slowsync' => { 114 => 0x1030 },
	'smartrange' => { 345 => 0xa012 },
	'smileshutter' => { 358 => 0x31 },
	'smileshuttermode' => { 358 => 0x27 },
	'smoothness' => { 109 => 0xfe57, 412 => 'Smoothness' },
	'snapshots' => { 406 => 'Snapshots' },
	'softskineffect' => { 368 => 0x200f },
	'software' => { 109 => 0x131, 140 => 'Software', 272 => 'Software', 323 => 0x203, 348 => 0x18, 432 => 'Software' },
	'softwareversion' => { 347 => 0x207 },
	'sonydatetime' => { 374 => 0x6, 376 => 0x1b6, 377 => 0x210, 378 => 0x1fe, 379 => 0x22c },
	'sonydatetime2' => { 384 => [0x51,0x5d] },
	'sonyexposuretime' => { 384 => 0x46 },
	'sonyexposuretime2' => { 393 => 0xe },
	'sonyfnumber' => { 384 => [0x3c,0x48], 393 => 0x14 },
	'sonyimageheight' => { 374 => 0x1a, 385 => 0x44, 386 => 0x3f, 387 => 0x47 },
	'sonyimagesize' => { 164 => 0x3b, 356 => 0x54, 357 => 0x54, 358 => 0x9 },
	'sonyimagewidth' => { 374 => 0x1c },
	'sonyiso' => { 376 => 0x1218, 377 => 0x11f4, 378 => 0x1270, 379 => [0x1254,0x1258,0x1280], 380 => 0x113c, 381 => 0x344, 382 => 0x346, 393 => 0x4 },
	'sonymaxaperturevalue' => { 393 => 0x16 },
	'sonymodelid' => { 368 => 0xb001 },
	'sonyquality' => { 164 => 0x3c },
	'source' => { 117 => 0x73, 272 => 'Source', 413 => 'source', 414 => 'source', 424 => 'Source' },
	'sourcedirectoryindex' => { 301 => 0x0 },
	'sourcefileindex' => { 301 => 0x2 },
	'sourcephotoscount' => { 401 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 416 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 416 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 416 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 416 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 416 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 436 => 'speakerPlacement' },
	'specialeffectlevel' => { 104 => 0x3030 },
	'specialeffectmode' => { 104 => 0x2076 },
	'specialeffectsetting' => { 104 => 0x3031 },
	'specialinstructions' => { 117 => 0x28 },
	'specialmode' => { 264 => 0x200, 347 => 0x200 },
	'specialoccasion' => { 428 => 'specialOccasion' },
	'spectralsensitivity' => { 109 => 0x8824, 416 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 40 => [0x2b9,0x2d0,0x2d4], 42 => 0x1e4, 43 => [0x1fd,0x2dd], 44 => [0x231,0x30f] },
	'speedx' => { 106 => 0x3 },
	'speedy' => { 106 => 0x4 },
	'speedz' => { 106 => 0x5 },
	'splitcolumn' => { 323 => 0x222 },
	'splittoningbalance' => { 412 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 412 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 412 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 412 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 412 => 'SplitToningShadowSaturation' },
	'sport' => { 426 => 'sport' },
	'spotfocuspointx' => { 161 => 0x2d },
	'spotfocuspointy' => { 161 => 0x2e },
	'spotmeteringmode' => { 33 => 0x27 },
	'spotmeterlinktoafpoint' => { 75 => 0x107 },
	'sractive' => { 295 => '17.1' },
	'srawquality' => { 33 => 0x2e },
	'srfocallength' => { 316 => 0x3 },
	'srhalfpresstime' => { 316 => 0x2 },
	'srresult' => { 316 => 0x0, 317 => 0x0 },
	'stackedimage' => { 259 => 0x804 },
	'standardoutputhighlightpoint' => { 100 => 0x14 },
	'standardoutputsensitivity' => { 109 => 0x8831, 417 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 100 => 0x15 },
	'standardrawcolortone' => { 100 => 0xd },
	'standardrawcontrast' => { 100 => 0xf },
	'standardrawhighlight' => { 100 => 0x75 },
	'standardrawhighlightpoint' => { 100 => 0x12 },
	'standardrawlinear' => { 100 => 0x10 },
	'standardrawsaturation' => { 100 => 0xe },
	'standardrawshadow' => { 100 => 0x7e },
	'standardrawshadowpoint' => { 100 => 0x13 },
	'standardrawsharpness' => { 100 => 0x11 },
	'standardunsharpmaskfineness' => { 100 => 0x94 },
	'standardunsharpmaskstrength' => { 100 => 0x92 },
	'standardunsharpmaskthreshold' => { 100 => 0x96 },
	'standbytimer' => { 244 => '19.1', 246 => '19.1', 247 => '19.1', 250 => '18.1', 251 => '18.1', 256 => '19.1' },
	'startingpage' => { 426 => 'startingPage' },
	'startmovieshooting' => { 75 => 0x70d },
	'starttimecode' => { 436 => 'startTimecode' },
	'starttimecodetimeformat' => { 436 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 436 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 436 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 436 => 'startTimeSampleSize' },
	'starttimescale' => { 436 => 'startTimeScale' },
	'state' => { 144 => 'State', 280 => 0x6b, 424 => 'State' },
	'status' => { 400 => 'Status', 404 => 'Status' },
	'stitchingsoftware' => { 401 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 375 => 0x113e, 376 => 0x113e, 377 => 0x111a, 378 => 0x1196, 379 => 0x1172, 380 => 0x102a, 381 => 0x222, 382 => 0x222, 393 => 0xa },
	'storagemethod' => { 168 => 0x12 },
	'storebyorientation' => { 244 => '46.3', 246 => '47.3', 247 => '47.3', 256 => '47.3' },
	'straightenangle' => { 236 => 0x2fc08431 },
	'streamtype' => { 157 => 'StreamType' },
	'stretchmode' => { 436 => 'stretchMode' },
	'studydatetime' => { 399 => 'StudyDateTime' },
	'studydescription' => { 399 => 'StudyDescription' },
	'studyid' => { 399 => 'StudyID' },
	'studyphysician' => { 399 => 'StudyPhysician' },
	'sub-location' => { 117 => 0x5c },
	'subfiledata' => { 147 => 'data' },
	'subfiledirectory' => { 147 => '1Directory' },
	'subfilemimetype' => { 147 => '2MIME' },
	'subfilename' => { 147 => '1Name' },
	'subfileresource' => { 147 => 'rsrc' },
	'subfiletype' => { 109 => 0xfe, 147 => '0Type' },
	'subject' => { 268 => 'Subject', 330 => 'Subject', 413 => 'subject', 423 => 'Subject', 437 => 'subject' },
	'subjectarea' => { 109 => 0x9214, 416 => 'SubjectArea' },
	'subjectcode' => { 421 => 'SubjectCode' },
	'subjectdistance' => { 109 => 0x9206, 125 => 0x3e, 416 => 'SubjectDistance' },
	'subjectdistancerange' => { 109 => 0xa40c, 416 => 'SubjectDistanceRange' },
	'subjectlocation' => { 109 => 0xa214, 416 => 'SubjectLocation' },
	'subjectmotion' => { 246 => '78.2', 247 => '78.2' },
	'subjectprogram' => { 161 => 0x22 },
	'subjectreference' => { 117 => 0xc },
	'sublabels4' => { 420 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 420 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 420 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 420 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 420 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 105 => 'SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 105 => 'SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 105 => 'SubSecModifyDate' },
	'subsectime' => { 109 => 0x9290 },
	'subsectimedigitized' => { 109 => 0x9292 },
	'subsectimeoriginal' => { 109 => 0x9291 },
	'subsection1' => { 426 => 'subsection1' },
	'subsection2' => { 426 => 'subsection2' },
	'subsection3' => { 426 => 'subsection3' },
	'subsection4' => { 426 => 'subsection4' },
	'subselector' => { 244 => '49.1', 246 => '71.1', 247 => '71.1' },
	'subselectorassignment' => { 244 => '48.1' },
	'subselectorcenter' => { 246 => '72.1', 247 => '72.1' },
	'subselectorplusdials' => { 244 => '49.2', 246 => '73.1', 247 => '73.1' },
	'subtitle' => { 426 => 'subtitle' },
	'subversionfilename' => { 420 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 420 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 420 => 'SubVersions' },
	'superimposeddisplay' => { 73 => 0xa, 75 => 0x510, 76 => 0x9, 77 => 0xa, 80 => 0xa, 81 => 0xe },
	'supermacro' => { 57 => 0x1a },
	'supplementalcategories' => { 117 => 0x14, 424 => 'SupplementalCategories' },
	'supplementaltype' => { 119 => 0x37 },
	'supplementdisplayid' => { 426 => 'supplementDisplayID' },
	'supplementstartingpage' => { 426 => 'supplementStartingPage' },
	'supplementtitle' => { 426 => 'supplementTitle' },
	'svisosetting' => { 295 => 0x14 },
	'swatchcoloranta' => { 441 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 441 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 441 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 441 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 441 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 441 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 441 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 441 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 441 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 441 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 441 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 441 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 441 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 441 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 441 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 441 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 441 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 441 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 441 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 280 => 0x93, 358 => 0x33 },
	'sweeppanoramafieldofview' => { 280 => 0x94 },
	'sweeppanoramasize' => { 358 => 0x32 },
	'switchtoregisteredafpoint' => { 74 => 0x12, 75 => 0x50a },
	'syncreleasemode' => { 246 => '77.1', 247 => '77.1' },
	'system' => { 323 => 0x204 },
	'tagged' => { 325 => 0xdd, 326 => 'Tagged', 406 => 'tagged' },
	'tagslist' => { 415 => 'TagsList' },
	'tagstructure' => { 420 => 'TagStructure' },
	'takenumber' => { 436 => 'takeNumber' },
	'tapename' => { 436 => 'tapeName' },
	'targetaperture' => { 69 => 0x4 },
	'targetcompressionratio' => { 86 => 0x1 },
	'targetdistancesetting' => { 88 => 0x1807 },
	'targetexposuretime' => { 69 => 0x5 },
	'targetimagetype' => { 88 => 0x100a },
	'targetprinter' => { 109 => 0x151 },
	'taxon' => { 108 => 'Taxon' },
	'taxonacceptednameusage' => { 108 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 108 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 108 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 108 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 108 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 108 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 108 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 108 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 108 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 108 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 108 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 108 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 108 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 108 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 108 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 108 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 108 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 108 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 108 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 108 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 108 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 108 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 108 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 108 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 108 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 108 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 108 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 108 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 108 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 108 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 108 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 108 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 108 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 426 => 'teaser' },
	'teleconverter' => { 166 => 0x105, 368 => 0x105 },
	'tempo' => { 436 => 'tempo' },
	'termsandconditionstext' => { 269 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 269 => 'TermsAndConditionsURL' },
	'testname' => { 110 => 'TestName' },
	'textencoding' => { 197 => 0x4 },
	'textlayername' => { 424 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 424 => 'TextLayers' },
	'textlayertext' => { 424 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 280 => [0x8008,0x8009,0x3b,0x3e] },
	'three-dtrackingfacedetection' => { 246 => '1.3', 247 => '1.3' },
	'three-dtrackingwatcharea' => { 246 => '78.1', 247 => '78.1' },
	'thresholding' => { 109 => 0x107 },
	'thumbnailfilename' => { 88 => 0x817 },
	'thumbnailformat' => { 434 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 127 => 0xfa55, 434 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 88 => 0x2008, 105 => 'ThumbnailImage', 112 => 0x3, 150 => 'data', 264 => 0x100, 434 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 150 => '1Name' },
	'thumbnailimagesize' => { 150 => 'ImageSize' },
	'thumbnailimagetype' => { 150 => '0Type' },
	'thumbnailimagevalidarea' => { 57 => 0x13 },
	'thumbnaillength' => { 109 => 0x202 },
	'thumbnailoffset' => { 109 => 0x201 },
	'thumbnails' => { 434 => 'Thumbnails' },
	'thumbnailwidth' => { 127 => 0xfa54, 434 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 426 => 'ticker' },
	'tiffhandling' => { 412 => 'TIFFHandling' },
	'tiffmeteringimage' => { 167 => 0x104c, 367 => 0x1110 },
	'tilelength' => { 109 => 0x143 },
	'tilewidth' => { 109 => 0x142 },
	'time' => { 123 => 0x401, 314 => 0x7 },
	'timecodes' => { 109 => 0xc763 },
	'timecreated' => { 117 => 0x3c, 125 => 0x14, 134 => 0x10, 326 => 'TimeCreated' },
	'timeperiod' => { 426 => 'timePeriod' },
	'timerfunctionbutton' => { 245 => '5.2', 248 => '12.1', 249 => '13.1' },
	'timerlength' => { 75 => 0x80c },
	'timerrecording' => { 280 => 0x96 },
	'timescaleparams' => { 436 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 436 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 436 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 436 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 118 => 0x50 },
	'timesignature' => { 436 => 'timeSignature' },
	'timesincepoweron' => { 280 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 258 => 0x8, 272 => 'TimeStamp', 407 => 'Timestamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 70 => 0x1, 228 => 0x0, 342 => 0xa },
	'timezonecity' => { 70 => 0x2 },
	'timezonecode' => { 91 => 0x1 },
	'timezoneinfo' => { 91 => 0x2 },
	'timezoneoffset' => { 109 => 0x882a },
	'tint' => { 412 => 'Tint' },
	'title' => { 140 => 'Title', 268 => 'Title', 272 => 'Title', 280 => 0x65, 330 => 'Title', 413 => 'title', 423 => 'Title', 434 => 'Title' },
	'tonecomp' => { 198 => 0x81 },
	'tonecurve' => { 67 => 0x1, 314 => 0x402, 412 => 'ToneCurve' },
	'tonecurveactive' => { 99 => 0x110 },
	'tonecurveadobergb' => { 345 => 0xa043 },
	'tonecurveadobergbdefault' => { 345 => 0xa041 },
	'tonecurveblue' => { 412 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 397 => 0x9003 },
	'tonecurvebluey' => { 397 => 0x9007 },
	'tonecurvebrightness' => { 94 => 0x20410 },
	'tonecurvebrightnessx' => { 397 => 0x9000 },
	'tonecurvebrightnessy' => { 397 => 0x9004 },
	'tonecurvecolorspace' => { 98 => 0x0 },
	'tonecurvecontrast' => { 94 => 0x20411 },
	'tonecurvefilename' => { 123 => 0x1391 },
	'tonecurvegreen' => { 412 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 397 => 0x9002 },
	'tonecurvegreeny' => { 397 => 0x9006 },
	'tonecurveinputrange' => { 98 => 0x3 },
	'tonecurveinterpolation' => { 99 => 0x159 },
	'tonecurvemode' => { 99 => 0x113 },
	'tonecurvename' => { 412 => 'ToneCurveName' },
	'tonecurvename2012' => { 412 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 94 => '0x20400.1' },
	'tonecurveoutputrange' => { 98 => 0x5 },
	'tonecurveproperty' => { 99 => 0x3c },
	'tonecurvepv2012' => { 412 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 412 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 412 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 412 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 412 => 'ToneCurveRed' },
	'tonecurveredx' => { 397 => 0x9001 },
	'tonecurveredy' => { 397 => 0x9005 },
	'tonecurves' => { 314 => 0x403 },
	'tonecurveshape' => { 98 => 0x1 },
	'tonecurvesrgb' => { 345 => 0xa042 },
	'tonecurvesrgbdefault' => { 345 => 0xa040 },
	'tonecurvex' => { 98 => 0xa },
	'tonecurvey' => { 98 => 0xb },
	'tonelevel' => { 259 => 0x52e },
	'tonemapstrength' => { 412 => 'ToneMapStrength' },
	'toningeffect' => { 51 => 0xf, 198 => 0xb3, 200 => 0x38, 201 => 0x40, 339 => 0x1015 },
	'toningeffectauto' => { 64 => 0xa4 },
	'toningeffectfaithful' => { 63 => 0x74, 64 => 0x74 },
	'toningeffectlandscape' => { 63 => 0x44, 64 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 63 => 0x8c, 64 => 0x8c },
	'toningeffectneutral' => { 63 => 0x5c, 64 => 0x5c },
	'toningeffectportrait' => { 63 => 0x2c, 64 => 0x2c },
	'toningeffectstandard' => { 63 => 0x14, 64 => 0x14 },
	'toningeffectuserdef1' => { 63 => 0xa4, 64 => 0xbc },
	'toningeffectuserdef2' => { 63 => 0xbc, 64 => 0xd4 },
	'toningeffectuserdef3' => { 63 => 0xd4, 64 => 0xec },
	'toningsaturation' => { 200 => 0x39, 201 => 0x41 },
	'totalzoom' => { 125 => 0x62 },
	'touchae' => { 280 => 0xab },
	'trackcreatedate' => { 334 => 0x1 },
	'trackmodifydate' => { 334 => 0x2 },
	'tracknumber' => { 436 => 'trackNumber' },
	'tracks' => { 436 => 'Tracks' },
	'tracksframerate' => { 436 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 436 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 436 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 436 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 436 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 436 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 436 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 436 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 436 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 436 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 436 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 436 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 436 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 436 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 436 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 436 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 436 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 147 => 'zmie' },
	'transferfunction' => { 109 => 0x12d, 432 => 'TransferFunction' },
	'transform' => { 280 => [0x8012,0x59] },
	'transmissionreference' => { 424 => 'TransmissionReference' },
	'trapped' => { 268 => 'Trapped', 423 => 'Trapped' },
	'trashbuttonfunction' => { 75 => 0x710 },
	'travelday' => { 280 => 0x36 },
	'triggermode' => { 335 => 0x6 },
	'tstop' => { 109 => 0xc772 },
	'ttl_da_adown' => { 302 => 0x5 },
	'ttl_da_aup' => { 302 => 0x4 },
	'ttl_da_bdown' => { 302 => 0x7 },
	'ttl_da_bup' => { 302 => 0x6 },
	'tungstenawb' => { 292 => 0x1 },
	'tvexposuretimesetting' => { 295 => 0x12 },
	'type' => { 413 => 'type', 431 => 'type' },
	'typestatus' => { 108 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 109 => 0xc614 },
	'uniquedocumentid' => { 117 => 0xbb },
	'uniqueobjectname' => { 118 => 0x64 },
	'unknownblock' => { 314 => 0x405 },
	'unknownblock1' => { 263 => 0x635 },
	'unknownblock2' => { 263 => 0x636 },
	'unknownblock3' => { 263 => 0x1103 },
	'unknownblock4' => { 263 => 0x1104 },
	'unknowncontrast' => { 100 => 0x45 },
	'unknowndate' => { 323 => 0x212 },
	'unknownev' => { 123 => 0x1 },
	'unknownlinear' => { 100 => 0x46 },
	'unknownnumber' => { 88 => 0x180b },
	'unknownoutputhighlightpoint' => { 100 => 0x4a },
	'unknownoutputshadowpoint' => { 100 => 0x4b },
	'unknownrawhighlight' => { 100 => 0x7b },
	'unknownrawhighlightpoint' => { 100 => 0x48 },
	'unknownrawshadow' => { 100 => 0x84 },
	'unknownrawshadowpoint' => { 100 => 0x49 },
	'unknownsharpness' => { 100 => 0x47 },
	'unknowntemperature' => { 111 => 0x4 },
	'unsharp1color' => { 241 => 0x13 },
	'unsharp1halowidth' => { 241 => 0x19 },
	'unsharp1intensity' => { 241 => 0x17 },
	'unsharp1threshold' => { 241 => 0x1b },
	'unsharp2color' => { 241 => 0x2e },
	'unsharp2halowidth' => { 241 => 0x34 },
	'unsharp2intensity' => { 241 => 0x32 },
	'unsharp2threshold' => { 241 => 0x36 },
	'unsharp3color' => { 241 => 0x49 },
	'unsharp3halowidth' => { 241 => 0x4f },
	'unsharp3intensity' => { 241 => 0x4d },
	'unsharp3threshold' => { 241 => 0x51 },
	'unsharp4color' => { 241 => 0x64 },
	'unsharp4halowidth' => { 241 => 0x6a },
	'unsharp4intensity' => { 241 => 0x68 },
	'unsharp4threshold' => { 241 => 0x6c },
	'unsharpcount' => { 241 => 0x0 },
	'unsharpmask' => { 100 => 0x90, 236 => 0x76a43200 },
	'unsharpmaskfineness' => { 94 => 0x20309 },
	'unsharpmaskstrength' => { 94 => 0x20308 },
	'unsharpmaskthreshold' => { 94 => 0x2030a },
	'uprightcentermode' => { 412 => 'UprightCenterMode' },
	'uprightcenternormx' => { 412 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 412 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 412 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 412 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 412 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 412 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 412 => 'UprightPreview' },
	'uprighttransform_0' => { 412 => 'UprightTransform_0' },
	'uprighttransform_1' => { 412 => 'UprightTransform_1' },
	'uprighttransform_2' => { 412 => 'UprightTransform_2' },
	'uprighttransform_3' => { 412 => 'UprightTransform_3' },
	'uprighttransform_4' => { 412 => 'UprightTransform_4' },
	'uprighttransform_5' => { 412 => 'UprightTransform_5' },
	'uprighttransformcount' => { 412 => 'UprightTransformCount' },
	'uprightversion' => { 412 => 'UprightVersion' },
	'urgency' => { 117 => 0xa, 424 => 'Urgency' },
	'url' => { 140 => 'URL', 272 => 'URL', 328 => 0x40b, 426 => 'url' },
	'url_list' => { 328 => 0x41e },
	'urla-platform' => { 426 => [\'url','urlA-platform'] },
	'urlurl' => { 426 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 75 => 0x10a },
	'usableshootingmodes' => { 75 => 0x109 },
	'usage' => { 427 => 'usage' },
	'usageterms' => { 440 => 'UsageTerms' },
	'useguidelines' => { 409 => 'useGuidelines' },
	'usepanoramaviewer' => { 401 => 'UsePanoramaViewer' },
	'usercomment' => { 88 => 0x805, 109 => 0x9286, 416 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 63 => 0xd8, 64 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 63 => 0xda, 64 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 63 => 0xdc, 64 => 0xf4 },
	'userfields' => { 404 => 'UserFields' },
	'userlabel' => { 335 => 0x2b },
	'userprofile' => { 276 => 0x302, 282 => 0x3038 },
	'usmlenselectronicmf' => { 2 => 0x7, 74 => 0x7, 75 => 0x501 },
	'uspsnumber' => { 426 => 'uspsNumber' },
	'utmeasting' => { 151 => 'Easting' },
	'utmmapdatum' => { 151 => 'Datum' },
	'utmnorthing' => { 151 => 'Northing' },
	'utmzone' => { 151 => 'Zone' },
	'uv-irfiltercorrection' => { 276 => 0x325 },
	'validbits' => { 263 => 0x611, 264 => 0x102c },
	'validpixeldepth' => { 267 => 0x611 },
	'variousmodes' => { 125 => 0x26 },
	'variousmodes2' => { 125 => 0x3a },
	'variprogram' => { 198 => 0xab },
	'version' => { 114 => 0x0, 330 => 'Version', 412 => 'Version' },
	'versioncreatedate' => { 397 => 0xd100 },
	'versionid' => { 437 => 'VersionID' },
	'versionidentifier' => { 426 => 'versionIdentifier' },
	'versionmodifydate' => { 397 => 0xd101 },
	'versions' => { 437 => 'Versions' },
	'versionscomments' => { 437 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 437 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 437 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 437 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 437 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 437 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 437 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 437 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 437 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 437 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 437 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 243 => '3.2', 244 => '47.2' },
	'verticalfuncbutton' => { 244 => '42.2' },
	'verticalfuncbuttonplusdials' => { 244 => '43.1' },
	'verticalmultiselector' => { 244 => '42.1', 247 => '66.1' },
	'vfdisplayillumination' => { 2 => 0x11, 75 => [0x510,0x51d] },
	'vibrance' => { 405 => 'Vibrance', 412 => 'Vibrance' },
	'vibrationreduction' => { 206 => [0x75,0x82,0x1ae], 214 => '586.1', 222 => '590.2', 227 => 0x4 },
	'videoalphamode' => { 436 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 436 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 436 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 436 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 436 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 436 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 436 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 436 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 436 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 436 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 436 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 436 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 436 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 436 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 436 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 436 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 436 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 436 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 60 => 0x74 },
	'videocolorspace' => { 436 => 'videoColorSpace' },
	'videocompressor' => { 436 => 'videoCompressor' },
	'videofieldorder' => { 436 => 'videoFieldOrder' },
	'videoframerate' => { 436 => 'videoFrameRate' },
	'videoframesize' => { 436 => 'videoFrameSize' },
	'videoframesizeh' => { 436 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 436 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 436 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 436 => 'videoModDate' },
	'videopixelaspectratio' => { 436 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 436 => 'videoPixelDepth' },
	'videoquality' => { 104 => 0x4003 },
	'viewfinderdisplay' => { 243 => '12.4', 244 => '6.3' },
	'viewfinderwarning' => { 243 => '13.4', 253 => '3.5', 254 => '6.2', 257 => '4.4' },
	'viewfinderwarnings' => { 75 => 0x40a },
	'viewinfoduringexposure' => { 75 => 0x407 },
	'viewingmode' => { 358 => 0x2f, 372 => 0x18 },
	'viewingmode2' => { 358 => [0x85,0x285] },
	'viewpoint' => { 425 => 'viewpoint' },
	'vignetteamount' => { 412 => 'VignetteAmount' },
	'vignettecontrol' => { 198 => 0x2a, 236 => 0x76a43205 },
	'vignettecontrolintensity' => { 236 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 408 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 412 => 'VignetteMidpoint' },
	'vignetting' => { 339 => 0x1011, 345 => 0xa052 },
	'vignettingcorrection' => { 345 => 0xa053, 368 => 0x2011 },
	'vignettingsetting' => { 345 => 0xa054 },
	'visualtechnique' => { 425 => 'visualTechnique' },
	'voicememo' => { 347 => 0x216 },
	'volume' => { 426 => 'volume' },
	'vr_0x66' => { 206 => 0x66 },
	'vrdoffset' => { 57 => 0xd0 },
	'vrmode' => { 227 => 0x6 },
	'waterdepth' => { 109 => 0x9403 },
	'wb_bluelevel3500k' => { 167 => 0x19a },
	'wb_bluelevel6500k' => { 167 => 0x18a },
	'wb_bluelevelcustom' => { 167 => 0x18e },
	'wb_bluelevelscloudy' => { 167 => 0x106 },
	'wb_bluelevelsdaylight' => { 167 => 0xea },
	'wb_bluelevelsflash' => { 167 => 0x122 },
	'wb_bluelevelsfluorescent' => { 167 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 167 => 0x254 },
	'wb_bluelevelsshade' => { 167 => 0x176 },
	'wb_bluelevelstungsten' => { 167 => 0xce },
	'wb_gbrglevels' => { 167 => 0xae, 170 => 0x4 },
	'wb_glevel' => { 263 => 0x11f },
	'wb_glevel3000k' => { 263 => 0x113 },
	'wb_glevel3300k' => { 263 => 0x114 },
	'wb_glevel3600k' => { 263 => 0x115 },
	'wb_glevel3900k' => { 263 => 0x116 },
	'wb_glevel4000k' => { 263 => 0x117 },
	'wb_glevel4300k' => { 263 => 0x118 },
	'wb_glevel4500k' => { 263 => 0x119 },
	'wb_glevel4800k' => { 263 => 0x11a },
	'wb_glevel5300k' => { 263 => 0x11b },
	'wb_glevel6000k' => { 263 => 0x11c },
	'wb_glevel6600k' => { 263 => 0x11d },
	'wb_glevel7500k' => { 263 => 0x11e },
	'wb_grbglevels' => { 180 => 0x0 },
	'wb_rbgglevels' => { 177 => 0x0 },
	'wb_rblevels' => { 198 => 0xc, 263 => 0x100 },
	'wb_rblevels1' => { 285 => 0x2 },
	'wb_rblevels2' => { 285 => 0x5 },
	'wb_rblevels3' => { 285 => 0x8 },
	'wb_rblevels3000k' => { 263 => 0x102 },
	'wb_rblevels3300k' => { 263 => 0x103 },
	'wb_rblevels3500k' => { 167 => 0x430 },
	'wb_rblevels3600k' => { 263 => 0x104 },
	'wb_rblevels3900k' => { 263 => 0x105 },
	'wb_rblevels4' => { 285 => 0xb },
	'wb_rblevels4000k' => { 263 => 0x106 },
	'wb_rblevels4300k' => { 263 => 0x107 },
	'wb_rblevels4500k' => { 263 => 0x108 },
	'wb_rblevels4800k' => { 263 => 0x109 },
	'wb_rblevels5' => { 285 => 0xe },
	'wb_rblevels5300k' => { 263 => 0x10a },
	'wb_rblevels6' => { 285 => 0x11 },
	'wb_rblevels6000k' => { 263 => 0x10b },
	'wb_rblevels6500k' => { 167 => 0x420 },
	'wb_rblevels6600k' => { 263 => 0x10c },
	'wb_rblevels7' => { 285 => 0x14 },
	'wb_rblevels7500k' => { 263 => 0x10d },
	'wb_rblevelsauto' => { 267 => 0x110 },
	'wb_rblevelscloudy' => { 167 => 0x3f0, 169 => 0x10, 267 => 0x121 },
	'wb_rblevelscoolwhitef' => { 167 => 0x308, 169 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 267 => 0x132 },
	'wb_rblevelscustom' => { 167 => 0x424 },
	'wb_rblevelscwb1' => { 263 => 0x10e },
	'wb_rblevelscwb2' => { 263 => 0x10f },
	'wb_rblevelscwb3' => { 263 => 0x110 },
	'wb_rblevelscwb4' => { 263 => 0x111 },
	'wb_rblevelsdaylight' => { 167 => [0x3ec,0x528], 169 => 0xc },
	'wb_rblevelsdaylightf' => { 169 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 267 => 0x130 },
	'wb_rblevelsdaywhitef' => { 169 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 267 => 0x131 },
	'wb_rblevelseveningsunlight' => { 267 => 0x124 },
	'wb_rblevelsfineweather' => { 267 => 0x122 },
	'wb_rblevelsflash' => { 167 => [0x3f4,0x304], 169 => 0x18 },
	'wb_rblevelsshade' => { 167 => 0x418, 169 => 0x20, 267 => 0x120 },
	'wb_rblevelstungsten' => { 167 => 0x3e8, 169 => 0x8, 267 => 0x123 },
	'wb_rblevelsunknown' => { 169 => 0x1c },
	'wb_rblevelsused' => { 267 => 0x100 },
	'wb_rblevelswhitef' => { 169 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 267 => 0x133 },
	'wb_redlevel3500k' => { 167 => 0x198 },
	'wb_redlevel6500k' => { 167 => 0x188 },
	'wb_redlevelcustom' => { 167 => 0x18c },
	'wb_redlevelscloudy' => { 167 => 0xf8 },
	'wb_redlevelsdaylight' => { 167 => 0xdc },
	'wb_redlevelsflash' => { 167 => 0x114 },
	'wb_redlevelsfluorescent' => { 167 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 167 => 0x1be },
	'wb_redlevelsshade' => { 167 => 0x168 },
	'wb_redlevelstungsten' => { 167 => 0xc0 },
	'wb_rgbglevels' => { 179 => 0x0 },
	'wb_rgblevels' => { 167 => [0x546,0x96], 277 => 0xd, 278 => 0x413, 282 => 0x3036, 323 => 0x107, 375 => 0x117c, 376 => 0x1180, 377 => 0x115c, 378 => 0x11d8, 379 => 0x11b4, 380 => 0x106c, 381 => 0x264, 382 => 0x264 },
	'wb_rgblevels1' => { 286 => 0x2 },
	'wb_rgblevels2' => { 286 => 0x6 },
	'wb_rgblevels3' => { 286 => 0xa },
	'wb_rgblevels4' => { 286 => 0xe },
	'wb_rgblevels5' => { 286 => 0x12 },
	'wb_rgblevels6' => { 286 => 0x16 },
	'wb_rgblevels7' => { 286 => 0x1a },
	'wb_rggbblacklevels' => { 34 => 0x25 },
	'wb_rggblevels' => { 170 => 0x4, 178 => 0x0 },
	'wb_rggblevelsasshot' => { 36 => 0x0, 37 => 0x19, 38 => 0x22, 39 => 0x3f, 42 => 0x3f, 43 => 0x3f, 44 => 0x3f },
	'wb_rggblevelsauto' => { 34 => 0x1, 36 => 0x5, 37 => 0x1e, 38 => 0x18, 39 => 0x44, 42 => 0x44, 43 => 0x44, 44 => 0x44, 345 => 0xa022 },
	'wb_rggblevelsblack' => { 345 => 0xa028 },
	'wb_rggblevelscloudy' => { 34 => 0xd, 36 => 0x1e, 37 => 0x2d, 38 => 0x31, 39 => 0x58, 42 => 0x71, 43 => 0x8a, 44 => 0x8f, 314 => 0x20f, 322 => 0x14 },
	'wb_rggblevelscustom' => { 34 => 0x1d, 39 => 0x80 },
	'wb_rggblevelscustom1' => { 37 => 0x41 },
	'wb_rggblevelscustom2' => { 37 => 0x46 },
	'wb_rggblevelsdaylight' => { 34 => 0x5, 36 => 0x14, 37 => 0x23, 38 => 0x27, 39 => 0x4e, 42 => 0x67, 43 => 0x80, 44 => 0x85, 314 => 0x20d, 322 => 0x2 },
	'wb_rggblevelsflash' => { 34 => 0x19, 36 => 0x32, 37 => 0x3c, 38 => 0x45, 39 => 0x6c, 42 => 0x85, 43 => 0x9e, 44 => 0xa3, 314 => 0x214, 322 => 0x41 },
	'wb_rggblevelsfluorescent' => { 34 => 0x15, 36 => 0x28, 37 => 0x37, 38 => 0x3b, 39 => 0x62, 42 => 0x7b, 43 => 0x94, 44 => 0x99 },
	'wb_rggblevelsfluorescentd' => { 314 => 0x211, 322 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 322 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 314 => 0x212, 322 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 314 => 0x213, 322 => 0x38 },
	'wb_rggblevelsilluminator1' => { 345 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 345 => 0xa024 },
	'wb_rggblevelskelvin' => { 34 => 0x21, 36 => 0x2d, 38 => 0x40, 39 => 0x67, 42 => 0x80, 43 => 0x99, 44 => 0x9e },
	'wb_rggblevelsmeasured' => { 36 => 0xa, 39 => 0x49, 42 => 0x49, 43 => 0x49, 44 => 0x49 },
	'wb_rggblevelspc1' => { 38 => 0x90, 39 => 0x71 },
	'wb_rggblevelspc2' => { 38 => 0x95, 39 => 0x76 },
	'wb_rggblevelspc3' => { 38 => 0x9a, 39 => 0x7b },
	'wb_rggblevelsshade' => { 34 => 0x9, 36 => 0x19, 37 => 0x28, 38 => 0x2c, 39 => 0x53, 42 => 0x6c, 43 => 0x85, 44 => 0x8a, 314 => 0x20e, 322 => 0xb },
	'wb_rggblevelstungsten' => { 34 => 0x11, 36 => 0x23, 37 => 0x32, 38 => 0x36, 39 => 0x5d, 42 => 0x76, 43 => 0x8f, 44 => 0x94, 314 => 0x210, 322 => 0x1d },
	'wb_rggblevelsuncorrected' => { 345 => 0xa021 },
	'wb_rggblevelsunknown' => { 36 => 0xf, 38 => 0x1d, 42 => 0x4e, 43 => 0x4e, 44 => 0x4e, 322 => 0x53 },
	'wb_rggblevelsunknown10' => { 36 => 0x5f, 38 => 0x72, 42 => 0x9e, 43 => 0x7b, 44 => 0x7b },
	'wb_rggblevelsunknown11' => { 36 => 0x64, 38 => 0x77, 42 => 0xa3, 43 => 0xa3, 44 => 0x80 },
	'wb_rggblevelsunknown12' => { 36 => 0x69, 38 => 0x7c, 42 => 0xa8, 43 => 0xa8, 44 => 0xa8 },
	'wb_rggblevelsunknown13' => { 36 => 0x6e, 38 => 0x81, 42 => 0xad, 43 => 0xad, 44 => 0xad },
	'wb_rggblevelsunknown14' => { 38 => 0x86, 42 => 0xb2, 43 => 0xb2, 44 => 0xb2 },
	'wb_rggblevelsunknown15' => { 38 => 0x8b, 42 => 0xb7, 43 => 0xb7, 44 => 0xb7 },
	'wb_rggblevelsunknown16' => { 38 => 0x9f, 43 => 0xbc, 44 => 0xbc },
	'wb_rggblevelsunknown17' => { 43 => 0xc1, 44 => 0xc1 },
	'wb_rggblevelsunknown18' => { 43 => 0xc6, 44 => 0xc6 },
	'wb_rggblevelsunknown19' => { 43 => 0xcb, 44 => 0xcb },
	'wb_rggblevelsunknown2' => { 36 => 0x37, 38 => 0x4a, 42 => 0x53, 43 => 0x53, 44 => 0x53 },
	'wb_rggblevelsunknown20' => { 43 => 0xd0, 44 => 0xd0 },
	'wb_rggblevelsunknown21' => { 44 => 0xd5 },
	'wb_rggblevelsunknown22' => { 44 => 0xda },
	'wb_rggblevelsunknown23' => { 44 => 0xdf },
	'wb_rggblevelsunknown24' => { 44 => 0xe4 },
	'wb_rggblevelsunknown25' => { 44 => 0xe9 },
	'wb_rggblevelsunknown26' => { 44 => 0xee },
	'wb_rggblevelsunknown27' => { 44 => 0xf3 },
	'wb_rggblevelsunknown28' => { 44 => 0xf8 },
	'wb_rggblevelsunknown29' => { 44 => 0xfd },
	'wb_rggblevelsunknown3' => { 36 => 0x3c, 38 => 0x4f, 42 => 0x58, 43 => 0x58, 44 => 0x58 },
	'wb_rggblevelsunknown30' => { 44 => 0x102 },
	'wb_rggblevelsunknown4' => { 36 => 0x41, 38 => 0x54, 42 => 0x5d, 43 => 0x5d, 44 => 0x5d },
	'wb_rggblevelsunknown5' => { 36 => 0x46, 38 => 0x59, 42 => 0x62, 43 => 0x62, 44 => 0x62 },
	'wb_rggblevelsunknown6' => { 36 => 0x4b, 38 => 0x5e, 42 => 0x8a, 43 => 0x67, 44 => 0x67 },
	'wb_rggblevelsunknown7' => { 36 => 0x50, 38 => 0x63, 42 => 0x8f, 43 => 0x6c, 44 => 0x6c },
	'wb_rggblevelsunknown8' => { 36 => 0x55, 38 => 0x68, 42 => 0x94, 43 => 0x71, 44 => 0x71 },
	'wb_rggblevelsunknown9' => { 36 => 0x5a, 38 => 0x6d, 42 => 0x99, 43 => 0x76, 44 => 0x76 },
	'wb_rggblevelsuserselected' => { 322 => 0x5c },
	'wbadjblueamber' => { 94 => 0x20106 },
	'wbadjbluebalance' => { 242 => 0x8 },
	'wbadjcolortemp' => { 94 => 0x20102, 99 => 0x1a },
	'wbadjlighting' => { 242 => 0x14 },
	'wbadjmagentagreen' => { 94 => 0x20105 },
	'wbadjmode' => { 242 => 0x10 },
	'wbadjredbalance' => { 242 => 0x0 },
	'wbadjrggblevels' => { 94 => 0x20125, 99 => 0x6 },
	'wbadjtemperature' => { 242 => 0x18 },
	'wbadjtint' => { 242 => 0x25 },
	'wbbluelevel' => { 276 => 0x324, 280 => 0x8006, 284 => 0x26 },
	'wbbracketingsteps' => { 215 => 0x174d, 216 => 0x87c, 224 => 0x1757 },
	'wbbracketmode' => { 51 => 0x9 },
	'wbbracketshotnumber' => { 167 => 0x2b, 339 => 0x101a },
	'wbbracketvalueab' => { 51 => 0xc },
	'wbbracketvaluegm' => { 51 => 0xd },
	'wbfinetuneactive' => { 99 => 0x24 },
	'wbfinetunesaturation' => { 99 => 0x28 },
	'wbfinetunetone' => { 99 => 0x2c },
	'wbgreenlevel' => { 276 => 0x323, 280 => 0x8005, 284 => 0x25 },
	'wbmediaimagesizesetting' => { 75 => 0x708 },
	'wbmode' => { 169 => 0x4, 264 => 0x1015 },
	'wbredlevel' => { 276 => 0x322, 280 => 0x8004, 284 => 0x24 },
	'wbscale' => { 170 => 0x0 },
	'wbshiftab' => { 67 => 0xc, 280 => 0x46, 296 => 0x10 },
	'wbshiftab_gm' => { 368 => 0x2014 },
	'wbshiftab_gm_precise' => { 368 => 0x2026 },
	'wbshiftgm' => { 67 => 0xd, 280 => 0x47, 296 => 0x11 },
	'wbtype1' => { 285 => 0x1, 286 => 0x1 },
	'wbtype2' => { 285 => 0x4, 286 => 0x5 },
	'wbtype3' => { 285 => 0x7, 286 => 0x9 },
	'wbtype4' => { 285 => 0xa, 286 => 0xd },
	'wbtype5' => { 285 => 0xd, 286 => 0x11 },
	'wbtype6' => { 285 => 0x10, 286 => 0x15 },
	'wbtype7' => { 285 => 0x13, 286 => 0x19 },
	'webstatement' => { 440 => 'WebStatement' },
	'what' => { 412 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x131, 27 => 0x77, 67 => 0x8, 69 => 0x7, 103 => 0x7, 104 => [0x19,0x2012], 109 => [0xa403,0xfe4e], 114 => 0x1002, 123 => 0x3fc, 124 => 0xfa0d, 125 => 0x40, 161 => 0x3, 162 => 0xe, 163 => 0x4, 164 => 0xb, 166 => 0x115, 198 => 0x5, 226 => 0x7, 276 => 0x304, 280 => 0x3, 282 => 0x3033, 314 => 0x19, 321 => 0x7, 338 => 0x26, 339 => 0x1003, 348 => [0x3c,0x7,0x58], 356 => 0xf, 357 => 0xe, 368 => [0x115,0xb054], 412 => 'WhiteBalance', 416 => 'WhiteBalance' },
	'whitebalance0' => { 157 => 'WhiteBalance0' },
	'whitebalance1' => { 157 => 'WhiteBalance1' },
	'whitebalance2' => { 157 => 'WhiteBalance2', 259 => 0x500 },
	'whitebalanceadj' => { 94 => 0x20101, 99 => 0x18, 236 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 292 => 0x0 },
	'whitebalancebias' => { 104 => 0x2011, 264 => 0x304, 280 => 0x23 },
	'whitebalanceblue' => { 67 => 0x7 },
	'whitebalancebracket' => { 259 => 0x502, 264 => 0x303 },
	'whitebalancebracketing' => { 164 => 0x22, 167 => 0x2c, 367 => 0x2c },
	'whitebalancecomp' => { 267 => 0x1001 },
	'whitebalancefinetune' => { 114 => 0x100a, 164 => 0x38, 166 => 0x112, 198 => 0xb, 339 => 0x1004, 356 => 0x6, 357 => 0x5, 368 => 0x112 },
	'whitebalancemode' => { 314 => 0x1a },
	'whitebalancered' => { 67 => 0x6 },
	'whitebalanceset' => { 295 => 0xa },
	'whitebalancesetting' => { 164 => 0x23, 356 => 0x5, 357 => 0x4, 358 => 0x16, 372 => 0xd },
	'whitebalancetemperature' => { 259 => 0x501 },
	'whiteboard' => { 264 => 0x301 },
	'whitelevel' => { 109 => 0xc61d, 314 => 0x7e },
	'whitepoint' => { 109 => 0x13e, 314 => 0x201, 432 => 'WhitePoint' },
	'whites2012' => { 412 => 'Whites2012' },
	'wideadapter' => { 339 => 0x1017 },
	'widefocuszone' => { 161 => 0x2f },
	'widerange' => { 347 => 0x20f },
	'windowsatom' => { 411 => 'windowsAtom' },
	'windowsatomextension' => { 411 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 411 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 411 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 426 => 'wordCount' },
	'workcolorspace' => { 94 => 0x10200, 99 => 0x270 },
	'worktodo' => { 418 => 'WorkToDo' },
	'worldtimelocation' => { 280 => 0x3a, 314 => 0x22, 320 => '0.1' },
	'writer-editor' => { 117 => 0x7a },
	'x3filllight' => { 348 => 0x12 },
	'xml' => { 121 => 'xml ' },
	'xmp' => { 97 => 0xffff00f6, 110 => 'XMP' },
	'xmptoolkit' => { 433 => 'xmptk' },
	'xpauthor' => { 109 => 0x9c9d },
	'xpcomment' => { 109 => 0x9c9c },
	'xpkeywords' => { 109 => 0x9c9e },
	'xposition' => { 109 => 0x11e },
	'xpsubject' => { 109 => 0x9c9f },
	'xptitle' => { 109 => 0x9c9b },
	'xresolution' => { 109 => 0x11a, 120 => 0x3, 329 => 0x0, 432 => 'XResolution' },
	'xyresolution' => { 113 => 0x3 },
	'yaw' => { 106 => 0x7 },
	'yawangle' => { 215 => 0x3513, 224 => 0x36fc },
	'ycbcrcoefficients' => { 109 => 0x211, 432 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 109 => 0x213, 432 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 109 => 0x212, 432 => 'YCbCrSubSampling' },
	'yearcreated' => { 125 => 0x10, 134 => 0xc },
	'yield' => { 428 => 'yield' },
	'yposition' => { 109 => 0x11f },
	'yresolution' => { 109 => 0x11b, 120 => 0x5, 329 => 0x4, 432 => 'YResolution' },
	'zonematching' => { 166 => 0x10a, 169 => [0x3a,0x4a], 368 => 0xb024 },
	'zonematchingmode' => { 164 => 0x14 },
	'zonematchingon' => { 163 => 0x75 },
	'zonematchingvalue' => { 356 => 0x1f },
	'zoomedpreviewlength' => { 264 => 0xf05 },
	'zoomedpreviewsize' => { 264 => 0xf06 },
	'zoomedpreviewstart' => { 264 => 0xf04 },
	'zoomsourcewidth' => { 33 => 0x24 },
	'zoomstepcount' => { 262 => 0x300, 264 => 0x100d },
	'zoomtargetwidth' => { 33 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'anim' => 1,
	'animationcontrol' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batteryinfo' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filegroupid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileuserid' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0107' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammainfo' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'int16u' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemtags' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestylepc' => 1,
	'picturestyleuserdef' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelshiftinfo' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'poseyawdegrees' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawfiletype' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'serialnumberhash' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecount' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spherical' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stereoscopic3d' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitched' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'variablelowpassfilter' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2016, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
