#!perl -w
#
# Test file mode strings from GNU /usr/local/bin/ls.

use strict;
use warnings;
use Test::More;
plan tests => 4096;

use File::Listing;

while (<DATA>) {
    chomp;

    # Expected output value.

    my $expected = $. - 1;

    # Information text.

    my $text = sprintf('"%s" -> "%05o"', $_, $expected);

    # Get output and keep only permission (no file type info).

    my $got = File::Listing::file_mode($_);
    $got &= 07777;

    cmp_ok($got, '==', $expected, $text);
}

__DATA__
----------
---------x
--------w-
--------wx
-------r--
-------r-x
-------rw-
-------rwx
------x---
------x--x
------x-w-
------x-wx
------xr--
------xr-x
------xrw-
------xrwx
-----w----
-----w---x
-----w--w-
-----w--wx
-----w-r--
-----w-r-x
-----w-rw-
-----w-rwx
-----wx---
-----wx--x
-----wx-w-
-----wx-wx
-----wxr--
-----wxr-x
-----wxrw-
-----wxrwx
----r-----
----r----x
----r---w-
----r---wx
----r--r--
----r--r-x
----r--rw-
----r--rwx
----r-x---
----r-x--x
----r-x-w-
----r-x-wx
----r-xr--
----r-xr-x
----r-xrw-
----r-xrwx
----rw----
----rw---x
----rw--w-
----rw--wx
----rw-r--
----rw-r-x
----rw-rw-
----rw-rwx
----rwx---
----rwx--x
----rwx-w-
----rwx-wx
----rwxr--
----rwxr-x
----rwxrw-
----rwxrwx
---x------
---x-----x
---x----w-
---x----wx
---x---r--
---x---r-x
---x---rw-
---x---rwx
---x--x---
---x--x--x
---x--x-w-
---x--x-wx
---x--xr--
---x--xr-x
---x--xrw-
---x--xrwx
---x-w----
---x-w---x
---x-w--w-
---x-w--wx
---x-w-r--
---x-w-r-x
---x-w-rw-
---x-w-rwx
---x-wx---
---x-wx--x
---x-wx-w-
---x-wx-wx
---x-wxr--
---x-wxr-x
---x-wxrw-
---x-wxrwx
---xr-----
---xr----x
---xr---w-
---xr---wx
---xr--r--
---xr--r-x
---xr--rw-
---xr--rwx
---xr-x---
---xr-x--x
---xr-x-w-
---xr-x-wx
---xr-xr--
---xr-xr-x
---xr-xrw-
---xr-xrwx
---xrw----
---xrw---x
---xrw--w-
---xrw--wx
---xrw-r--
---xrw-r-x
---xrw-rw-
---xrw-rwx
---xrwx---
---xrwx--x
---xrwx-w-
---xrwx-wx
---xrwxr--
---xrwxr-x
---xrwxrw-
---xrwxrwx
--w-------
--w------x
--w-----w-
--w-----wx
--w----r--
--w----r-x
--w----rw-
--w----rwx
--w---x---
--w---x--x
--w---x-w-
--w---x-wx
--w---xr--
--w---xr-x
--w---xrw-
--w---xrwx
--w--w----
--w--w---x
--w--w--w-
--w--w--wx
--w--w-r--
--w--w-r-x
--w--w-rw-
--w--w-rwx
--w--wx---
--w--wx--x
--w--wx-w-
--w--wx-wx
--w--wxr--
--w--wxr-x
--w--wxrw-
--w--wxrwx
--w-r-----
--w-r----x
--w-r---w-
--w-r---wx
--w-r--r--
--w-r--r-x
--w-r--rw-
--w-r--rwx
--w-r-x---
--w-r-x--x
--w-r-x-w-
--w-r-x-wx
--w-r-xr--
--w-r-xr-x
--w-r-xrw-
--w-r-xrwx
--w-rw----
--w-rw---x
--w-rw--w-
--w-rw--wx
--w-rw-r--
--w-rw-r-x
--w-rw-rw-
--w-rw-rwx
--w-rwx---
--w-rwx--x
--w-rwx-w-
--w-rwx-wx
--w-rwxr--
--w-rwxr-x
--w-rwxrw-
--w-rwxrwx
--wx------
--wx-----x
--wx----w-
--wx----wx
--wx---r--
--wx---r-x
--wx---rw-
--wx---rwx
--wx--x---
--wx--x--x
--wx--x-w-
--wx--x-wx
--wx--xr--
--wx--xr-x
--wx--xrw-
--wx--xrwx
--wx-w----
--wx-w---x
--wx-w--w-
--wx-w--wx
--wx-w-r--
--wx-w-r-x
--wx-w-rw-
--wx-w-rwx
--wx-wx---
--wx-wx--x
--wx-wx-w-
--wx-wx-wx
--wx-wxr--
--wx-wxr-x
--wx-wxrw-
--wx-wxrwx
--wxr-----
--wxr----x
--wxr---w-
--wxr---wx
--wxr--r--
--wxr--r-x
--wxr--rw-
--wxr--rwx
--wxr-x---
--wxr-x--x
--wxr-x-w-
--wxr-x-wx
--wxr-xr--
--wxr-xr-x
--wxr-xrw-
--wxr-xrwx
--wxrw----
--wxrw---x
--wxrw--w-
--wxrw--wx
--wxrw-r--
--wxrw-r-x
--wxrw-rw-
--wxrw-rwx
--wxrwx---
--wxrwx--x
--wxrwx-w-
--wxrwx-wx
--wxrwxr--
--wxrwxr-x
--wxrwxrw-
--wxrwxrwx
-r--------
-r-------x
-r------w-
-r------wx
-r-----r--
-r-----r-x
-r-----rw-
-r-----rwx
-r----x---
-r----x--x
-r----x-w-
-r----x-wx
-r----xr--
-r----xr-x
-r----xrw-
-r----xrwx
-r---w----
-r---w---x
-r---w--w-
-r---w--wx
-r---w-r--
-r---w-r-x
-r---w-rw-
-r---w-rwx
-r---wx---
-r---wx--x
-r---wx-w-
-r---wx-wx
-r---wxr--
-r---wxr-x
-r---wxrw-
-r---wxrwx
-r--r-----
-r--r----x
-r--r---w-
-r--r---wx
-r--r--r--
-r--r--r-x
-r--r--rw-
-r--r--rwx
-r--r-x---
-r--r-x--x
-r--r-x-w-
-r--r-x-wx
-r--r-xr--
-r--r-xr-x
-r--r-xrw-
-r--r-xrwx
-r--rw----
-r--rw---x
-r--rw--w-
-r--rw--wx
-r--rw-r--
-r--rw-r-x
-r--rw-rw-
-r--rw-rwx
-r--rwx---
-r--rwx--x
-r--rwx-w-
-r--rwx-wx
-r--rwxr--
-r--rwxr-x
-r--rwxrw-
-r--rwxrwx
-r-x------
-r-x-----x
-r-x----w-
-r-x----wx
-r-x---r--
-r-x---r-x
-r-x---rw-
-r-x---rwx
-r-x--x---
-r-x--x--x
-r-x--x-w-
-r-x--x-wx
-r-x--xr--
-r-x--xr-x
-r-x--xrw-
-r-x--xrwx
-r-x-w----
-r-x-w---x
-r-x-w--w-
-r-x-w--wx
-r-x-w-r--
-r-x-w-r-x
-r-x-w-rw-
-r-x-w-rwx
-r-x-wx---
-r-x-wx--x
-r-x-wx-w-
-r-x-wx-wx
-r-x-wxr--
-r-x-wxr-x
-r-x-wxrw-
-r-x-wxrwx
-r-xr-----
-r-xr----x
-r-xr---w-
-r-xr---wx
-r-xr--r--
-r-xr--r-x
-r-xr--rw-
-r-xr--rwx
-r-xr-x---
-r-xr-x--x
-r-xr-x-w-
-r-xr-x-wx
-r-xr-xr--
-r-xr-xr-x
-r-xr-xrw-
-r-xr-xrwx
-r-xrw----
-r-xrw---x
-r-xrw--w-
-r-xrw--wx
-r-xrw-r--
-r-xrw-r-x
-r-xrw-rw-
-r-xrw-rwx
-r-xrwx---
-r-xrwx--x
-r-xrwx-w-
-r-xrwx-wx
-r-xrwxr--
-r-xrwxr-x
-r-xrwxrw-
-r-xrwxrwx
-rw-------
-rw------x
-rw-----w-
-rw-----wx
-rw----r--
-rw----r-x
-rw----rw-
-rw----rwx
-rw---x---
-rw---x--x
-rw---x-w-
-rw---x-wx
-rw---xr--
-rw---xr-x
-rw---xrw-
-rw---xrwx
-rw--w----
-rw--w---x
-rw--w--w-
-rw--w--wx
-rw--w-r--
-rw--w-r-x
-rw--w-rw-
-rw--w-rwx
-rw--wx---
-rw--wx--x
-rw--wx-w-
-rw--wx-wx
-rw--wxr--
-rw--wxr-x
-rw--wxrw-
-rw--wxrwx
-rw-r-----
-rw-r----x
-rw-r---w-
-rw-r---wx
-rw-r--r--
-rw-r--r-x
-rw-r--rw-
-rw-r--rwx
-rw-r-x---
-rw-r-x--x
-rw-r-x-w-
-rw-r-x-wx
-rw-r-xr--
-rw-r-xr-x
-rw-r-xrw-
-rw-r-xrwx
-rw-rw----
-rw-rw---x
-rw-rw--w-
-rw-rw--wx
-rw-rw-r--
-rw-rw-r-x
-rw-rw-rw-
-rw-rw-rwx
-rw-rwx---
-rw-rwx--x
-rw-rwx-w-
-rw-rwx-wx
-rw-rwxr--
-rw-rwxr-x
-rw-rwxrw-
-rw-rwxrwx
-rwx------
-rwx-----x
-rwx----w-
-rwx----wx
-rwx---r--
-rwx---r-x
-rwx---rw-
-rwx---rwx
-rwx--x---
-rwx--x--x
-rwx--x-w-
-rwx--x-wx
-rwx--xr--
-rwx--xr-x
-rwx--xrw-
-rwx--xrwx
-rwx-w----
-rwx-w---x
-rwx-w--w-
-rwx-w--wx
-rwx-w-r--
-rwx-w-r-x
-rwx-w-rw-
-rwx-w-rwx
-rwx-wx---
-rwx-wx--x
-rwx-wx-w-
-rwx-wx-wx
-rwx-wxr--
-rwx-wxr-x
-rwx-wxrw-
-rwx-wxrwx
-rwxr-----
-rwxr----x
-rwxr---w-
-rwxr---wx
-rwxr--r--
-rwxr--r-x
-rwxr--rw-
-rwxr--rwx
-rwxr-x---
-rwxr-x--x
-rwxr-x-w-
-rwxr-x-wx
-rwxr-xr--
-rwxr-xr-x
-rwxr-xrw-
-rwxr-xrwx
-rwxrw----
-rwxrw---x
-rwxrw--w-
-rwxrw--wx
-rwxrw-r--
-rwxrw-r-x
-rwxrw-rw-
-rwxrw-rwx
-rwxrwx---
-rwxrwx--x
-rwxrwx-w-
-rwxrwx-wx
-rwxrwxr--
-rwxrwxr-x
-rwxrwxrw-
-rwxrwxrwx
---------T
---------t
--------wT
--------wt
-------r-T
-------r-t
-------rwT
-------rwt
------x--T
------x--t
------x-wT
------x-wt
------xr-T
------xr-t
------xrwT
------xrwt
-----w---T
-----w---t
-----w--wT
-----w--wt
-----w-r-T
-----w-r-t
-----w-rwT
-----w-rwt
-----wx--T
-----wx--t
-----wx-wT
-----wx-wt
-----wxr-T
-----wxr-t
-----wxrwT
-----wxrwt
----r----T
----r----t
----r---wT
----r---wt
----r--r-T
----r--r-t
----r--rwT
----r--rwt
----r-x--T
----r-x--t
----r-x-wT
----r-x-wt
----r-xr-T
----r-xr-t
----r-xrwT
----r-xrwt
----rw---T
----rw---t
----rw--wT
----rw--wt
----rw-r-T
----rw-r-t
----rw-rwT
----rw-rwt
----rwx--T
----rwx--t
----rwx-wT
----rwx-wt
----rwxr-T
----rwxr-t
----rwxrwT
----rwxrwt
---x-----T
---x-----t
---x----wT
---x----wt
---x---r-T
---x---r-t
---x---rwT
---x---rwt
---x--x--T
---x--x--t
---x--x-wT
---x--x-wt
---x--xr-T
---x--xr-t
---x--xrwT
---x--xrwt
---x-w---T
---x-w---t
---x-w--wT
---x-w--wt
---x-w-r-T
---x-w-r-t
---x-w-rwT
---x-w-rwt
---x-wx--T
---x-wx--t
---x-wx-wT
---x-wx-wt
---x-wxr-T
---x-wxr-t
---x-wxrwT
---x-wxrwt
---xr----T
---xr----t
---xr---wT
---xr---wt
---xr--r-T
---xr--r-t
---xr--rwT
---xr--rwt
---xr-x--T
---xr-x--t
---xr-x-wT
---xr-x-wt
---xr-xr-T
---xr-xr-t
---xr-xrwT
---xr-xrwt
---xrw---T
---xrw---t
---xrw--wT
---xrw--wt
---xrw-r-T
---xrw-r-t
---xrw-rwT
---xrw-rwt
---xrwx--T
---xrwx--t
---xrwx-wT
---xrwx-wt
---xrwxr-T
---xrwxr-t
---xrwxrwT
---xrwxrwt
--w------T
--w------t
--w-----wT
--w-----wt
--w----r-T
--w----r-t
--w----rwT
--w----rwt
--w---x--T
--w---x--t
--w---x-wT
--w---x-wt
--w---xr-T
--w---xr-t
--w---xrwT
--w---xrwt
--w--w---T
--w--w---t
--w--w--wT
--w--w--wt
--w--w-r-T
--w--w-r-t
--w--w-rwT
--w--w-rwt
--w--wx--T
--w--wx--t
--w--wx-wT
--w--wx-wt
--w--wxr-T
--w--wxr-t
--w--wxrwT
--w--wxrwt
--w-r----T
--w-r----t
--w-r---wT
--w-r---wt
--w-r--r-T
--w-r--r-t
--w-r--rwT
--w-r--rwt
--w-r-x--T
--w-r-x--t
--w-r-x-wT
--w-r-x-wt
--w-r-xr-T
--w-r-xr-t
--w-r-xrwT
--w-r-xrwt
--w-rw---T
--w-rw---t
--w-rw--wT
--w-rw--wt
--w-rw-r-T
--w-rw-r-t
--w-rw-rwT
--w-rw-rwt
--w-rwx--T
--w-rwx--t
--w-rwx-wT
--w-rwx-wt
--w-rwxr-T
--w-rwxr-t
--w-rwxrwT
--w-rwxrwt
--wx-----T
--wx-----t
--wx----wT
--wx----wt
--wx---r-T
--wx---r-t
--wx---rwT
--wx---rwt
--wx--x--T
--wx--x--t
--wx--x-wT
--wx--x-wt
--wx--xr-T
--wx--xr-t
--wx--xrwT
--wx--xrwt
--wx-w---T
--wx-w---t
--wx-w--wT
--wx-w--wt
--wx-w-r-T
--wx-w-r-t
--wx-w-rwT
--wx-w-rwt
--wx-wx--T
--wx-wx--t
--wx-wx-wT
--wx-wx-wt
--wx-wxr-T
--wx-wxr-t
--wx-wxrwT
--wx-wxrwt
--wxr----T
--wxr----t
--wxr---wT
--wxr---wt
--wxr--r-T
--wxr--r-t
--wxr--rwT
--wxr--rwt
--wxr-x--T
--wxr-x--t
--wxr-x-wT
--wxr-x-wt
--wxr-xr-T
--wxr-xr-t
--wxr-xrwT
--wxr-xrwt
--wxrw---T
--wxrw---t
--wxrw--wT
--wxrw--wt
--wxrw-r-T
--wxrw-r-t
--wxrw-rwT
--wxrw-rwt
--wxrwx--T
--wxrwx--t
--wxrwx-wT
--wxrwx-wt
--wxrwxr-T
--wxrwxr-t
--wxrwxrwT
--wxrwxrwt
-r-------T
-r-------t
-r------wT
-r------wt
-r-----r-T
-r-----r-t
-r-----rwT
-r-----rwt
-r----x--T
-r----x--t
-r----x-wT
-r----x-wt
-r----xr-T
-r----xr-t
-r----xrwT
-r----xrwt
-r---w---T
-r---w---t
-r---w--wT
-r---w--wt
-r---w-r-T
-r---w-r-t
-r---w-rwT
-r---w-rwt
-r---wx--T
-r---wx--t
-r---wx-wT
-r---wx-wt
-r---wxr-T
-r---wxr-t
-r---wxrwT
-r---wxrwt
-r--r----T
-r--r----t
-r--r---wT
-r--r---wt
-r--r--r-T
-r--r--r-t
-r--r--rwT
-r--r--rwt
-r--r-x--T
-r--r-x--t
-r--r-x-wT
-r--r-x-wt
-r--r-xr-T
-r--r-xr-t
-r--r-xrwT
-r--r-xrwt
-r--rw---T
-r--rw---t
-r--rw--wT
-r--rw--wt
-r--rw-r-T
-r--rw-r-t
-r--rw-rwT
-r--rw-rwt
-r--rwx--T
-r--rwx--t
-r--rwx-wT
-r--rwx-wt
-r--rwxr-T
-r--rwxr-t
-r--rwxrwT
-r--rwxrwt
-r-x-----T
-r-x-----t
-r-x----wT
-r-x----wt
-r-x---r-T
-r-x---r-t
-r-x---rwT
-r-x---rwt
-r-x--x--T
-r-x--x--t
-r-x--x-wT
-r-x--x-wt
-r-x--xr-T
-r-x--xr-t
-r-x--xrwT
-r-x--xrwt
-r-x-w---T
-r-x-w---t
-r-x-w--wT
-r-x-w--wt
-r-x-w-r-T
-r-x-w-r-t
-r-x-w-rwT
-r-x-w-rwt
-r-x-wx--T
-r-x-wx--t
-r-x-wx-wT
-r-x-wx-wt
-r-x-wxr-T
-r-x-wxr-t
-r-x-wxrwT
-r-x-wxrwt
-r-xr----T
-r-xr----t
-r-xr---wT
-r-xr---wt
-r-xr--r-T
-r-xr--r-t
-r-xr--rwT
-r-xr--rwt
-r-xr-x--T
-r-xr-x--t
-r-xr-x-wT
-r-xr-x-wt
-r-xr-xr-T
-r-xr-xr-t
-r-xr-xrwT
-r-xr-xrwt
-r-xrw---T
-r-xrw---t
-r-xrw--wT
-r-xrw--wt
-r-xrw-r-T
-r-xrw-r-t
-r-xrw-rwT
-r-xrw-rwt
-r-xrwx--T
-r-xrwx--t
-r-xrwx-wT
-r-xrwx-wt
-r-xrwxr-T
-r-xrwxr-t
-r-xrwxrwT
-r-xrwxrwt
-rw------T
-rw------t
-rw-----wT
-rw-----wt
-rw----r-T
-rw----r-t
-rw----rwT
-rw----rwt
-rw---x--T
-rw---x--t
-rw---x-wT
-rw---x-wt
-rw---xr-T
-rw---xr-t
-rw---xrwT
-rw---xrwt
-rw--w---T
-rw--w---t
-rw--w--wT
-rw--w--wt
-rw--w-r-T
-rw--w-r-t
-rw--w-rwT
-rw--w-rwt
-rw--wx--T
-rw--wx--t
-rw--wx-wT
-rw--wx-wt
-rw--wxr-T
-rw--wxr-t
-rw--wxrwT
-rw--wxrwt
-rw-r----T
-rw-r----t
-rw-r---wT
-rw-r---wt
-rw-r--r-T
-rw-r--r-t
-rw-r--rwT
-rw-r--rwt
-rw-r-x--T
-rw-r-x--t
-rw-r-x-wT
-rw-r-x-wt
-rw-r-xr-T
-rw-r-xr-t
-rw-r-xrwT
-rw-r-xrwt
-rw-rw---T
-rw-rw---t
-rw-rw--wT
-rw-rw--wt
-rw-rw-r-T
-rw-rw-r-t
-rw-rw-rwT
-rw-rw-rwt
-rw-rwx--T
-rw-rwx--t
-rw-rwx-wT
-rw-rwx-wt
-rw-rwxr-T
-rw-rwxr-t
-rw-rwxrwT
-rw-rwxrwt
-rwx-----T
-rwx-----t
-rwx----wT
-rwx----wt
-rwx---r-T
-rwx---r-t
-rwx---rwT
-rwx---rwt
-rwx--x--T
-rwx--x--t
-rwx--x-wT
-rwx--x-wt
-rwx--xr-T
-rwx--xr-t
-rwx--xrwT
-rwx--xrwt
-rwx-w---T
-rwx-w---t
-rwx-w--wT
-rwx-w--wt
-rwx-w-r-T
-rwx-w-r-t
-rwx-w-rwT
-rwx-w-rwt
-rwx-wx--T
-rwx-wx--t
-rwx-wx-wT
-rwx-wx-wt
-rwx-wxr-T
-rwx-wxr-t
-rwx-wxrwT
-rwx-wxrwt
-rwxr----T
-rwxr----t
-rwxr---wT
-rwxr---wt
-rwxr--r-T
-rwxr--r-t
-rwxr--rwT
-rwxr--rwt
-rwxr-x--T
-rwxr-x--t
-rwxr-x-wT
-rwxr-x-wt
-rwxr-xr-T
-rwxr-xr-t
-rwxr-xrwT
-rwxr-xrwt
-rwxrw---T
-rwxrw---t
-rwxrw--wT
-rwxrw--wt
-rwxrw-r-T
-rwxrw-r-t
-rwxrw-rwT
-rwxrw-rwt
-rwxrwx--T
-rwxrwx--t
-rwxrwx-wT
-rwxrwx-wt
-rwxrwxr-T
-rwxrwxr-t
-rwxrwxrwT
-rwxrwxrwt
------S---
------S--x
------S-w-
------S-wx
------Sr--
------Sr-x
------Srw-
------Srwx
------s---
------s--x
------s-w-
------s-wx
------sr--
------sr-x
------srw-
------srwx
-----wS---
-----wS--x
-----wS-w-
-----wS-wx
-----wSr--
-----wSr-x
-----wSrw-
-----wSrwx
-----ws---
-----ws--x
-----ws-w-
-----ws-wx
-----wsr--
-----wsr-x
-----wsrw-
-----wsrwx
----r-S---
----r-S--x
----r-S-w-
----r-S-wx
----r-Sr--
----r-Sr-x
----r-Srw-
----r-Srwx
----r-s---
----r-s--x
----r-s-w-
----r-s-wx
----r-sr--
----r-sr-x
----r-srw-
----r-srwx
----rwS---
----rwS--x
----rwS-w-
----rwS-wx
----rwSr--
----rwSr-x
----rwSrw-
----rwSrwx
----rws---
----rws--x
----rws-w-
----rws-wx
----rwsr--
----rwsr-x
----rwsrw-
----rwsrwx
---x--S---
---x--S--x
---x--S-w-
---x--S-wx
---x--Sr--
---x--Sr-x
---x--Srw-
---x--Srwx
---x--s---
---x--s--x
---x--s-w-
---x--s-wx
---x--sr--
---x--sr-x
---x--srw-
---x--srwx
---x-wS---
---x-wS--x
---x-wS-w-
---x-wS-wx
---x-wSr--
---x-wSr-x
---x-wSrw-
---x-wSrwx
---x-ws---
---x-ws--x
---x-ws-w-
---x-ws-wx
---x-wsr--
---x-wsr-x
---x-wsrw-
---x-wsrwx
---xr-S---
---xr-S--x
---xr-S-w-
---xr-S-wx
---xr-Sr--
---xr-Sr-x
---xr-Srw-
---xr-Srwx
---xr-s---
---xr-s--x
---xr-s-w-
---xr-s-wx
---xr-sr--
---xr-sr-x
---xr-srw-
---xr-srwx
---xrwS---
---xrwS--x
---xrwS-w-
---xrwS-wx
---xrwSr--
---xrwSr-x
---xrwSrw-
---xrwSrwx
---xrws---
---xrws--x
---xrws-w-
---xrws-wx
---xrwsr--
---xrwsr-x
---xrwsrw-
---xrwsrwx
--w---S---
--w---S--x
--w---S-w-
--w---S-wx
--w---Sr--
--w---Sr-x
--w---Srw-
--w---Srwx
--w---s---
--w---s--x
--w---s-w-
--w---s-wx
--w---sr--
--w---sr-x
--w---srw-
--w---srwx
--w--wS---
--w--wS--x
--w--wS-w-
--w--wS-wx
--w--wSr--
--w--wSr-x
--w--wSrw-
--w--wSrwx
--w--ws---
--w--ws--x
--w--ws-w-
--w--ws-wx
--w--wsr--
--w--wsr-x
--w--wsrw-
--w--wsrwx
--w-r-S---
--w-r-S--x
--w-r-S-w-
--w-r-S-wx
--w-r-Sr--
--w-r-Sr-x
--w-r-Srw-
--w-r-Srwx
--w-r-s---
--w-r-s--x
--w-r-s-w-
--w-r-s-wx
--w-r-sr--
--w-r-sr-x
--w-r-srw-
--w-r-srwx
--w-rwS---
--w-rwS--x
--w-rwS-w-
--w-rwS-wx
--w-rwSr--
--w-rwSr-x
--w-rwSrw-
--w-rwSrwx
--w-rws---
--w-rws--x
--w-rws-w-
--w-rws-wx
--w-rwsr--
--w-rwsr-x
--w-rwsrw-
--w-rwsrwx
--wx--S---
--wx--S--x
--wx--S-w-
--wx--S-wx
--wx--Sr--
--wx--Sr-x
--wx--Srw-
--wx--Srwx
--wx--s---
--wx--s--x
--wx--s-w-
--wx--s-wx
--wx--sr--
--wx--sr-x
--wx--srw-
--wx--srwx
--wx-wS---
--wx-wS--x
--wx-wS-w-
--wx-wS-wx
--wx-wSr--
--wx-wSr-x
--wx-wSrw-
--wx-wSrwx
--wx-ws---
--wx-ws--x
--wx-ws-w-
--wx-ws-wx
--wx-wsr--
--wx-wsr-x
--wx-wsrw-
--wx-wsrwx
--wxr-S---
--wxr-S--x
--wxr-S-w-
--wxr-S-wx
--wxr-Sr--
--wxr-Sr-x
--wxr-Srw-
--wxr-Srwx
--wxr-s---
--wxr-s--x
--wxr-s-w-
--wxr-s-wx
--wxr-sr--
--wxr-sr-x
--wxr-srw-
--wxr-srwx
--wxrwS---
--wxrwS--x
--wxrwS-w-
--wxrwS-wx
--wxrwSr--
--wxrwSr-x
--wxrwSrw-
--wxrwSrwx
--wxrws---
--wxrws--x
--wxrws-w-
--wxrws-wx
--wxrwsr--
--wxrwsr-x
--wxrwsrw-
--wxrwsrwx
-r----S---
-r----S--x
-r----S-w-
-r----S-wx
-r----Sr--
-r----Sr-x
-r----Srw-
-r----Srwx
-r----s---
-r----s--x
-r----s-w-
-r----s-wx
-r----sr--
-r----sr-x
-r----srw-
-r----srwx
-r---wS---
-r---wS--x
-r---wS-w-
-r---wS-wx
-r---wSr--
-r---wSr-x
-r---wSrw-
-r---wSrwx
-r---ws---
-r---ws--x
-r---ws-w-
-r---ws-wx
-r---wsr--
-r---wsr-x
-r---wsrw-
-r---wsrwx
-r--r-S---
-r--r-S--x
-r--r-S-w-
-r--r-S-wx
-r--r-Sr--
-r--r-Sr-x
-r--r-Srw-
-r--r-Srwx
-r--r-s---
-r--r-s--x
-r--r-s-w-
-r--r-s-wx
-r--r-sr--
-r--r-sr-x
-r--r-srw-
-r--r-srwx
-r--rwS---
-r--rwS--x
-r--rwS-w-
-r--rwS-wx
-r--rwSr--
-r--rwSr-x
-r--rwSrw-
-r--rwSrwx
-r--rws---
-r--rws--x
-r--rws-w-
-r--rws-wx
-r--rwsr--
-r--rwsr-x
-r--rwsrw-
-r--rwsrwx
-r-x--S---
-r-x--S--x
-r-x--S-w-
-r-x--S-wx
-r-x--Sr--
-r-x--Sr-x
-r-x--Srw-
-r-x--Srwx
-r-x--s---
-r-x--s--x
-r-x--s-w-
-r-x--s-wx
-r-x--sr--
-r-x--sr-x
-r-x--srw-
-r-x--srwx
-r-x-wS---
-r-x-wS--x
-r-x-wS-w-
-r-x-wS-wx
-r-x-wSr--
-r-x-wSr-x
-r-x-wSrw-
-r-x-wSrwx
-r-x-ws---
-r-x-ws--x
-r-x-ws-w-
-r-x-ws-wx
-r-x-wsr--
-r-x-wsr-x
-r-x-wsrw-
-r-x-wsrwx
-r-xr-S---
-r-xr-S--x
-r-xr-S-w-
-r-xr-S-wx
-r-xr-Sr--
-r-xr-Sr-x
-r-xr-Srw-
-r-xr-Srwx
-r-xr-s---
-r-xr-s--x
-r-xr-s-w-
-r-xr-s-wx
-r-xr-sr--
-r-xr-sr-x
-r-xr-srw-
-r-xr-srwx
-r-xrwS---
-r-xrwS--x
-r-xrwS-w-
-r-xrwS-wx
-r-xrwSr--
-r-xrwSr-x
-r-xrwSrw-
-r-xrwSrwx
-r-xrws---
-r-xrws--x
-r-xrws-w-
-r-xrws-wx
-r-xrwsr--
-r-xrwsr-x
-r-xrwsrw-
-r-xrwsrwx
-rw---S---
-rw---S--x
-rw---S-w-
-rw---S-wx
-rw---Sr--
-rw---Sr-x
-rw---Srw-
-rw---Srwx
-rw---s---
-rw---s--x
-rw---s-w-
-rw---s-wx
-rw---sr--
-rw---sr-x
-rw---srw-
-rw---srwx
-rw--wS---
-rw--wS--x
-rw--wS-w-
-rw--wS-wx
-rw--wSr--
-rw--wSr-x
-rw--wSrw-
-rw--wSrwx
-rw--ws---
-rw--ws--x
-rw--ws-w-
-rw--ws-wx
-rw--wsr--
-rw--wsr-x
-rw--wsrw-
-rw--wsrwx
-rw-r-S---
-rw-r-S--x
-rw-r-S-w-
-rw-r-S-wx
-rw-r-Sr--
-rw-r-Sr-x
-rw-r-Srw-
-rw-r-Srwx
-rw-r-s---
-rw-r-s--x
-rw-r-s-w-
-rw-r-s-wx
-rw-r-sr--
-rw-r-sr-x
-rw-r-srw-
-rw-r-srwx
-rw-rwS---
-rw-rwS--x
-rw-rwS-w-
-rw-rwS-wx
-rw-rwSr--
-rw-rwSr-x
-rw-rwSrw-
-rw-rwSrwx
-rw-rws---
-rw-rws--x
-rw-rws-w-
-rw-rws-wx
-rw-rwsr--
-rw-rwsr-x
-rw-rwsrw-
-rw-rwsrwx
-rwx--S---
-rwx--S--x
-rwx--S-w-
-rwx--S-wx
-rwx--Sr--
-rwx--Sr-x
-rwx--Srw-
-rwx--Srwx
-rwx--s---
-rwx--s--x
-rwx--s-w-
-rwx--s-wx
-rwx--sr--
-rwx--sr-x
-rwx--srw-
-rwx--srwx
-rwx-wS---
-rwx-wS--x
-rwx-wS-w-
-rwx-wS-wx
-rwx-wSr--
-rwx-wSr-x
-rwx-wSrw-
-rwx-wSrwx
-rwx-ws---
-rwx-ws--x
-rwx-ws-w-
-rwx-ws-wx
-rwx-wsr--
-rwx-wsr-x
-rwx-wsrw-
-rwx-wsrwx
-rwxr-S---
-rwxr-S--x
-rwxr-S-w-
-rwxr-S-wx
-rwxr-Sr--
-rwxr-Sr-x
-rwxr-Srw-
-rwxr-Srwx
-rwxr-s---
-rwxr-s--x
-rwxr-s-w-
-rwxr-s-wx
-rwxr-sr--
-rwxr-sr-x
-rwxr-srw-
-rwxr-srwx
-rwxrwS---
-rwxrwS--x
-rwxrwS-w-
-rwxrwS-wx
-rwxrwSr--
-rwxrwSr-x
-rwxrwSrw-
-rwxrwSrwx
-rwxrws---
-rwxrws--x
-rwxrws-w-
-rwxrws-wx
-rwxrwsr--
-rwxrwsr-x
-rwxrwsrw-
-rwxrwsrwx
------S--T
------S--t
------S-wT
------S-wt
------Sr-T
------Sr-t
------SrwT
------Srwt
------s--T
------s--t
------s-wT
------s-wt
------sr-T
------sr-t
------srwT
------srwt
-----wS--T
-----wS--t
-----wS-wT
-----wS-wt
-----wSr-T
-----wSr-t
-----wSrwT
-----wSrwt
-----ws--T
-----ws--t
-----ws-wT
-----ws-wt
-----wsr-T
-----wsr-t
-----wsrwT
-----wsrwt
----r-S--T
----r-S--t
----r-S-wT
----r-S-wt
----r-Sr-T
----r-Sr-t
----r-SrwT
----r-Srwt
----r-s--T
----r-s--t
----r-s-wT
----r-s-wt
----r-sr-T
----r-sr-t
----r-srwT
----r-srwt
----rwS--T
----rwS--t
----rwS-wT
----rwS-wt
----rwSr-T
----rwSr-t
----rwSrwT
----rwSrwt
----rws--T
----rws--t
----rws-wT
----rws-wt
----rwsr-T
----rwsr-t
----rwsrwT
----rwsrwt
---x--S--T
---x--S--t
---x--S-wT
---x--S-wt
---x--Sr-T
---x--Sr-t
---x--SrwT
---x--Srwt
---x--s--T
---x--s--t
---x--s-wT
---x--s-wt
---x--sr-T
---x--sr-t
---x--srwT
---x--srwt
---x-wS--T
---x-wS--t
---x-wS-wT
---x-wS-wt
---x-wSr-T
---x-wSr-t
---x-wSrwT
---x-wSrwt
---x-ws--T
---x-ws--t
---x-ws-wT
---x-ws-wt
---x-wsr-T
---x-wsr-t
---x-wsrwT
---x-wsrwt
---xr-S--T
---xr-S--t
---xr-S-wT
---xr-S-wt
---xr-Sr-T
---xr-Sr-t
---xr-SrwT
---xr-Srwt
---xr-s--T
---xr-s--t
---xr-s-wT
---xr-s-wt
---xr-sr-T
---xr-sr-t
---xr-srwT
---xr-srwt
---xrwS--T
---xrwS--t
---xrwS-wT
---xrwS-wt
---xrwSr-T
---xrwSr-t
---xrwSrwT
---xrwSrwt
---xrws--T
---xrws--t
---xrws-wT
---xrws-wt
---xrwsr-T
---xrwsr-t
---xrwsrwT
---xrwsrwt
--w---S--T
--w---S--t
--w---S-wT
--w---S-wt
--w---Sr-T
--w---Sr-t
--w---SrwT
--w---Srwt
--w---s--T
--w---s--t
--w---s-wT
--w---s-wt
--w---sr-T
--w---sr-t
--w---srwT
--w---srwt
--w--wS--T
--w--wS--t
--w--wS-wT
--w--wS-wt
--w--wSr-T
--w--wSr-t
--w--wSrwT
--w--wSrwt
--w--ws--T
--w--ws--t
--w--ws-wT
--w--ws-wt
--w--wsr-T
--w--wsr-t
--w--wsrwT
--w--wsrwt
--w-r-S--T
--w-r-S--t
--w-r-S-wT
--w-r-S-wt
--w-r-Sr-T
--w-r-Sr-t
--w-r-SrwT
--w-r-Srwt
--w-r-s--T
--w-r-s--t
--w-r-s-wT
--w-r-s-wt
--w-r-sr-T
--w-r-sr-t
--w-r-srwT
--w-r-srwt
--w-rwS--T
--w-rwS--t
--w-rwS-wT
--w-rwS-wt
--w-rwSr-T
--w-rwSr-t
--w-rwSrwT
--w-rwSrwt
--w-rws--T
--w-rws--t
--w-rws-wT
--w-rws-wt
--w-rwsr-T
--w-rwsr-t
--w-rwsrwT
--w-rwsrwt
--wx--S--T
--wx--S--t
--wx--S-wT
--wx--S-wt
--wx--Sr-T
--wx--Sr-t
--wx--SrwT
--wx--Srwt
--wx--s--T
--wx--s--t
--wx--s-wT
--wx--s-wt
--wx--sr-T
--wx--sr-t
--wx--srwT
--wx--srwt
--wx-wS--T
--wx-wS--t
--wx-wS-wT
--wx-wS-wt
--wx-wSr-T
--wx-wSr-t
--wx-wSrwT
--wx-wSrwt
--wx-ws--T
--wx-ws--t
--wx-ws-wT
--wx-ws-wt
--wx-wsr-T
--wx-wsr-t
--wx-wsrwT
--wx-wsrwt
--wxr-S--T
--wxr-S--t
--wxr-S-wT
--wxr-S-wt
--wxr-Sr-T
--wxr-Sr-t
--wxr-SrwT
--wxr-Srwt
--wxr-s--T
--wxr-s--t
--wxr-s-wT
--wxr-s-wt
--wxr-sr-T
--wxr-sr-t
--wxr-srwT
--wxr-srwt
--wxrwS--T
--wxrwS--t
--wxrwS-wT
--wxrwS-wt
--wxrwSr-T
--wxrwSr-t
--wxrwSrwT
--wxrwSrwt
--wxrws--T
--wxrws--t
--wxrws-wT
--wxrws-wt
--wxrwsr-T
--wxrwsr-t
--wxrwsrwT
--wxrwsrwt
-r----S--T
-r----S--t
-r----S-wT
-r----S-wt
-r----Sr-T
-r----Sr-t
-r----SrwT
-r----Srwt
-r----s--T
-r----s--t
-r----s-wT
-r----s-wt
-r----sr-T
-r----sr-t
-r----srwT
-r----srwt
-r---wS--T
-r---wS--t
-r---wS-wT
-r---wS-wt
-r---wSr-T
-r---wSr-t
-r---wSrwT
-r---wSrwt
-r---ws--T
-r---ws--t
-r---ws-wT
-r---ws-wt
-r---wsr-T
-r---wsr-t
-r---wsrwT
-r---wsrwt
-r--r-S--T
-r--r-S--t
-r--r-S-wT
-r--r-S-wt
-r--r-Sr-T
-r--r-Sr-t
-r--r-SrwT
-r--r-Srwt
-r--r-s--T
-r--r-s--t
-r--r-s-wT
-r--r-s-wt
-r--r-sr-T
-r--r-sr-t
-r--r-srwT
-r--r-srwt
-r--rwS--T
-r--rwS--t
-r--rwS-wT
-r--rwS-wt
-r--rwSr-T
-r--rwSr-t
-r--rwSrwT
-r--rwSrwt
-r--rws--T
-r--rws--t
-r--rws-wT
-r--rws-wt
-r--rwsr-T
-r--rwsr-t
-r--rwsrwT
-r--rwsrwt
-r-x--S--T
-r-x--S--t
-r-x--S-wT
-r-x--S-wt
-r-x--Sr-T
-r-x--Sr-t
-r-x--SrwT
-r-x--Srwt
-r-x--s--T
-r-x--s--t
-r-x--s-wT
-r-x--s-wt
-r-x--sr-T
-r-x--sr-t
-r-x--srwT
-r-x--srwt
-r-x-wS--T
-r-x-wS--t
-r-x-wS-wT
-r-x-wS-wt
-r-x-wSr-T
-r-x-wSr-t
-r-x-wSrwT
-r-x-wSrwt
-r-x-ws--T
-r-x-ws--t
-r-x-ws-wT
-r-x-ws-wt
-r-x-wsr-T
-r-x-wsr-t
-r-x-wsrwT
-r-x-wsrwt
-r-xr-S--T
-r-xr-S--t
-r-xr-S-wT
-r-xr-S-wt
-r-xr-Sr-T
-r-xr-Sr-t
-r-xr-SrwT
-r-xr-Srwt
-r-xr-s--T
-r-xr-s--t
-r-xr-s-wT
-r-xr-s-wt
-r-xr-sr-T
-r-xr-sr-t
-r-xr-srwT
-r-xr-srwt
-r-xrwS--T
-r-xrwS--t
-r-xrwS-wT
-r-xrwS-wt
-r-xrwSr-T
-r-xrwSr-t
-r-xrwSrwT
-r-xrwSrwt
-r-xrws--T
-r-xrws--t
-r-xrws-wT
-r-xrws-wt
-r-xrwsr-T
-r-xrwsr-t
-r-xrwsrwT
-r-xrwsrwt
-rw---S--T
-rw---S--t
-rw---S-wT
-rw---S-wt
-rw---Sr-T
-rw---Sr-t
-rw---SrwT
-rw---Srwt
-rw---s--T
-rw---s--t
-rw---s-wT
-rw---s-wt
-rw---sr-T
-rw---sr-t
-rw---srwT
-rw---srwt
-rw--wS--T
-rw--wS--t
-rw--wS-wT
-rw--wS-wt
-rw--wSr-T
-rw--wSr-t
-rw--wSrwT
-rw--wSrwt
-rw--ws--T
-rw--ws--t
-rw--ws-wT
-rw--ws-wt
-rw--wsr-T
-rw--wsr-t
-rw--wsrwT
-rw--wsrwt
-rw-r-S--T
-rw-r-S--t
-rw-r-S-wT
-rw-r-S-wt
-rw-r-Sr-T
-rw-r-Sr-t
-rw-r-SrwT
-rw-r-Srwt
-rw-r-s--T
-rw-r-s--t
-rw-r-s-wT
-rw-r-s-wt
-rw-r-sr-T
-rw-r-sr-t
-rw-r-srwT
-rw-r-srwt
-rw-rwS--T
-rw-rwS--t
-rw-rwS-wT
-rw-rwS-wt
-rw-rwSr-T
-rw-rwSr-t
-rw-rwSrwT
-rw-rwSrwt
-rw-rws--T
-rw-rws--t
-rw-rws-wT
-rw-rws-wt
-rw-rwsr-T
-rw-rwsr-t
-rw-rwsrwT
-rw-rwsrwt
-rwx--S--T
-rwx--S--t
-rwx--S-wT
-rwx--S-wt
-rwx--Sr-T
-rwx--Sr-t
-rwx--SrwT
-rwx--Srwt
-rwx--s--T
-rwx--s--t
-rwx--s-wT
-rwx--s-wt
-rwx--sr-T
-rwx--sr-t
-rwx--srwT
-rwx--srwt
-rwx-wS--T
-rwx-wS--t
-rwx-wS-wT
-rwx-wS-wt
-rwx-wSr-T
-rwx-wSr-t
-rwx-wSrwT
-rwx-wSrwt
-rwx-ws--T
-rwx-ws--t
-rwx-ws-wT
-rwx-ws-wt
-rwx-wsr-T
-rwx-wsr-t
-rwx-wsrwT
-rwx-wsrwt
-rwxr-S--T
-rwxr-S--t
-rwxr-S-wT
-rwxr-S-wt
-rwxr-Sr-T
-rwxr-Sr-t
-rwxr-SrwT
-rwxr-Srwt
-rwxr-s--T
-rwxr-s--t
-rwxr-s-wT
-rwxr-s-wt
-rwxr-sr-T
-rwxr-sr-t
-rwxr-srwT
-rwxr-srwt
-rwxrwS--T
-rwxrwS--t
-rwxrwS-wT
-rwxrwS-wt
-rwxrwSr-T
-rwxrwSr-t
-rwxrwSrwT
-rwxrwSrwt
-rwxrws--T
-rwxrws--t
-rwxrws-wT
-rwxrws-wt
-rwxrwsr-T
-rwxrwsr-t
-rwxrwsrwT
-rwxrwsrwt
---S------
---S-----x
---S----w-
---S----wx
---S---r--
---S---r-x
---S---rw-
---S---rwx
---S--x---
---S--x--x
---S--x-w-
---S--x-wx
---S--xr--
---S--xr-x
---S--xrw-
---S--xrwx
---S-w----
---S-w---x
---S-w--w-
---S-w--wx
---S-w-r--
---S-w-r-x
---S-w-rw-
---S-w-rwx
---S-wx---
---S-wx--x
---S-wx-w-
---S-wx-wx
---S-wxr--
---S-wxr-x
---S-wxrw-
---S-wxrwx
---Sr-----
---Sr----x
---Sr---w-
---Sr---wx
---Sr--r--
---Sr--r-x
---Sr--rw-
---Sr--rwx
---Sr-x---
---Sr-x--x
---Sr-x-w-
---Sr-x-wx
---Sr-xr--
---Sr-xr-x
---Sr-xrw-
---Sr-xrwx
---Srw----
---Srw---x
---Srw--w-
---Srw--wx
---Srw-r--
---Srw-r-x
---Srw-rw-
---Srw-rwx
---Srwx---
---Srwx--x
---Srwx-w-
---Srwx-wx
---Srwxr--
---Srwxr-x
---Srwxrw-
---Srwxrwx
---s------
---s-----x
---s----w-
---s----wx
---s---r--
---s---r-x
---s---rw-
---s---rwx
---s--x---
---s--x--x
---s--x-w-
---s--x-wx
---s--xr--
---s--xr-x
---s--xrw-
---s--xrwx
---s-w----
---s-w---x
---s-w--w-
---s-w--wx
---s-w-r--
---s-w-r-x
---s-w-rw-
---s-w-rwx
---s-wx---
---s-wx--x
---s-wx-w-
---s-wx-wx
---s-wxr--
---s-wxr-x
---s-wxrw-
---s-wxrwx
---sr-----
---sr----x
---sr---w-
---sr---wx
---sr--r--
---sr--r-x
---sr--rw-
---sr--rwx
---sr-x---
---sr-x--x
---sr-x-w-
---sr-x-wx
---sr-xr--
---sr-xr-x
---sr-xrw-
---sr-xrwx
---srw----
---srw---x
---srw--w-
---srw--wx
---srw-r--
---srw-r-x
---srw-rw-
---srw-rwx
---srwx---
---srwx--x
---srwx-w-
---srwx-wx
---srwxr--
---srwxr-x
---srwxrw-
---srwxrwx
--wS------
--wS-----x
--wS----w-
--wS----wx
--wS---r--
--wS---r-x
--wS---rw-
--wS---rwx
--wS--x---
--wS--x--x
--wS--x-w-
--wS--x-wx
--wS--xr--
--wS--xr-x
--wS--xrw-
--wS--xrwx
--wS-w----
--wS-w---x
--wS-w--w-
--wS-w--wx
--wS-w-r--
--wS-w-r-x
--wS-w-rw-
--wS-w-rwx
--wS-wx---
--wS-wx--x
--wS-wx-w-
--wS-wx-wx
--wS-wxr--
--wS-wxr-x
--wS-wxrw-
--wS-wxrwx
--wSr-----
--wSr----x
--wSr---w-
--wSr---wx
--wSr--r--
--wSr--r-x
--wSr--rw-
--wSr--rwx
--wSr-x---
--wSr-x--x
--wSr-x-w-
--wSr-x-wx
--wSr-xr--
--wSr-xr-x
--wSr-xrw-
--wSr-xrwx
--wSrw----
--wSrw---x
--wSrw--w-
--wSrw--wx
--wSrw-r--
--wSrw-r-x
--wSrw-rw-
--wSrw-rwx
--wSrwx---
--wSrwx--x
--wSrwx-w-
--wSrwx-wx
--wSrwxr--
--wSrwxr-x
--wSrwxrw-
--wSrwxrwx
--ws------
--ws-----x
--ws----w-
--ws----wx
--ws---r--
--ws---r-x
--ws---rw-
--ws---rwx
--ws--x---
--ws--x--x
--ws--x-w-
--ws--x-wx
--ws--xr--
--ws--xr-x
--ws--xrw-
--ws--xrwx
--ws-w----
--ws-w---x
--ws-w--w-
--ws-w--wx
--ws-w-r--
--ws-w-r-x
--ws-w-rw-
--ws-w-rwx
--ws-wx---
--ws-wx--x
--ws-wx-w-
--ws-wx-wx
--ws-wxr--
--ws-wxr-x
--ws-wxrw-
--ws-wxrwx
--wsr-----
--wsr----x
--wsr---w-
--wsr---wx
--wsr--r--
--wsr--r-x
--wsr--rw-
--wsr--rwx
--wsr-x---
--wsr-x--x
--wsr-x-w-
--wsr-x-wx
--wsr-xr--
--wsr-xr-x
--wsr-xrw-
--wsr-xrwx
--wsrw----
--wsrw---x
--wsrw--w-
--wsrw--wx
--wsrw-r--
--wsrw-r-x
--wsrw-rw-
--wsrw-rwx
--wsrwx---
--wsrwx--x
--wsrwx-w-
--wsrwx-wx
--wsrwxr--
--wsrwxr-x
--wsrwxrw-
--wsrwxrwx
-r-S------
-r-S-----x
-r-S----w-
-r-S----wx
-r-S---r--
-r-S---r-x
-r-S---rw-
-r-S---rwx
-r-S--x---
-r-S--x--x
-r-S--x-w-
-r-S--x-wx
-r-S--xr--
-r-S--xr-x
-r-S--xrw-
-r-S--xrwx
-r-S-w----
-r-S-w---x
-r-S-w--w-
-r-S-w--wx
-r-S-w-r--
-r-S-w-r-x
-r-S-w-rw-
-r-S-w-rwx
-r-S-wx---
-r-S-wx--x
-r-S-wx-w-
-r-S-wx-wx
-r-S-wxr--
-r-S-wxr-x
-r-S-wxrw-
-r-S-wxrwx
-r-Sr-----
-r-Sr----x
-r-Sr---w-
-r-Sr---wx
-r-Sr--r--
-r-Sr--r-x
-r-Sr--rw-
-r-Sr--rwx
-r-Sr-x---
-r-Sr-x--x
-r-Sr-x-w-
-r-Sr-x-wx
-r-Sr-xr--
-r-Sr-xr-x
-r-Sr-xrw-
-r-Sr-xrwx
-r-Srw----
-r-Srw---x
-r-Srw--w-
-r-Srw--wx
-r-Srw-r--
-r-Srw-r-x
-r-Srw-rw-
-r-Srw-rwx
-r-Srwx---
-r-Srwx--x
-r-Srwx-w-
-r-Srwx-wx
-r-Srwxr--
-r-Srwxr-x
-r-Srwxrw-
-r-Srwxrwx
-r-s------
-r-s-----x
-r-s----w-
-r-s----wx
-r-s---r--
-r-s---r-x
-r-s---rw-
-r-s---rwx
-r-s--x---
-r-s--x--x
-r-s--x-w-
-r-s--x-wx
-r-s--xr--
-r-s--xr-x
-r-s--xrw-
-r-s--xrwx
-r-s-w----
-r-s-w---x
-r-s-w--w-
-r-s-w--wx
-r-s-w-r--
-r-s-w-r-x
-r-s-w-rw-
-r-s-w-rwx
-r-s-wx---
-r-s-wx--x
-r-s-wx-w-
-r-s-wx-wx
-r-s-wxr--
-r-s-wxr-x
-r-s-wxrw-
-r-s-wxrwx
-r-sr-----
-r-sr----x
-r-sr---w-
-r-sr---wx
-r-sr--r--
-r-sr--r-x
-r-sr--rw-
-r-sr--rwx
-r-sr-x---
-r-sr-x--x
-r-sr-x-w-
-r-sr-x-wx
-r-sr-xr--
-r-sr-xr-x
-r-sr-xrw-
-r-sr-xrwx
-r-srw----
-r-srw---x
-r-srw--w-
-r-srw--wx
-r-srw-r--
-r-srw-r-x
-r-srw-rw-
-r-srw-rwx
-r-srwx---
-r-srwx--x
-r-srwx-w-
-r-srwx-wx
-r-srwxr--
-r-srwxr-x
-r-srwxrw-
-r-srwxrwx
-rwS------
-rwS-----x
-rwS----w-
-rwS----wx
-rwS---r--
-rwS---r-x
-rwS---rw-
-rwS---rwx
-rwS--x---
-rwS--x--x
-rwS--x-w-
-rwS--x-wx
-rwS--xr--
-rwS--xr-x
-rwS--xrw-
-rwS--xrwx
-rwS-w----
-rwS-w---x
-rwS-w--w-
-rwS-w--wx
-rwS-w-r--
-rwS-w-r-x
-rwS-w-rw-
-rwS-w-rwx
-rwS-wx---
-rwS-wx--x
-rwS-wx-w-
-rwS-wx-wx
-rwS-wxr--
-rwS-wxr-x
-rwS-wxrw-
-rwS-wxrwx
-rwSr-----
-rwSr----x
-rwSr---w-
-rwSr---wx
-rwSr--r--
-rwSr--r-x
-rwSr--rw-
-rwSr--rwx
-rwSr-x---
-rwSr-x--x
-rwSr-x-w-
-rwSr-x-wx
-rwSr-xr--
-rwSr-xr-x
-rwSr-xrw-
-rwSr-xrwx
-rwSrw----
-rwSrw---x
-rwSrw--w-
-rwSrw--wx
-rwSrw-r--
-rwSrw-r-x
-rwSrw-rw-
-rwSrw-rwx
-rwSrwx---
-rwSrwx--x
-rwSrwx-w-
-rwSrwx-wx
-rwSrwxr--
-rwSrwxr-x
-rwSrwxrw-
-rwSrwxrwx
-rws------
-rws-----x
-rws----w-
-rws----wx
-rws---r--
-rws---r-x
-rws---rw-
-rws---rwx
-rws--x---
-rws--x--x
-rws--x-w-
-rws--x-wx
-rws--xr--
-rws--xr-x
-rws--xrw-
-rws--xrwx
-rws-w----
-rws-w---x
-rws-w--w-
-rws-w--wx
-rws-w-r--
-rws-w-r-x
-rws-w-rw-
-rws-w-rwx
-rws-wx---
-rws-wx--x
-rws-wx-w-
-rws-wx-wx
-rws-wxr--
-rws-wxr-x
-rws-wxrw-
-rws-wxrwx
-rwsr-----
-rwsr----x
-rwsr---w-
-rwsr---wx
-rwsr--r--
-rwsr--r-x
-rwsr--rw-
-rwsr--rwx
-rwsr-x---
-rwsr-x--x
-rwsr-x-w-
-rwsr-x-wx
-rwsr-xr--
-rwsr-xr-x
-rwsr-xrw-
-rwsr-xrwx
-rwsrw----
-rwsrw---x
-rwsrw--w-
-rwsrw--wx
-rwsrw-r--
-rwsrw-r-x
-rwsrw-rw-
-rwsrw-rwx
-rwsrwx---
-rwsrwx--x
-rwsrwx-w-
-rwsrwx-wx
-rwsrwxr--
-rwsrwxr-x
-rwsrwxrw-
-rwsrwxrwx
---S-----T
---S-----t
---S----wT
---S----wt
---S---r-T
---S---r-t
---S---rwT
---S---rwt
---S--x--T
---S--x--t
---S--x-wT
---S--x-wt
---S--xr-T
---S--xr-t
---S--xrwT
---S--xrwt
---S-w---T
---S-w---t
---S-w--wT
---S-w--wt
---S-w-r-T
---S-w-r-t
---S-w-rwT
---S-w-rwt
---S-wx--T
---S-wx--t
---S-wx-wT
---S-wx-wt
---S-wxr-T
---S-wxr-t
---S-wxrwT
---S-wxrwt
---Sr----T
---Sr----t
---Sr---wT
---Sr---wt
---Sr--r-T
---Sr--r-t
---Sr--rwT
---Sr--rwt
---Sr-x--T
---Sr-x--t
---Sr-x-wT
---Sr-x-wt
---Sr-xr-T
---Sr-xr-t
---Sr-xrwT
---Sr-xrwt
---Srw---T
---Srw---t
---Srw--wT
---Srw--wt
---Srw-r-T
---Srw-r-t
---Srw-rwT
---Srw-rwt
---Srwx--T
---Srwx--t
---Srwx-wT
---Srwx-wt
---Srwxr-T
---Srwxr-t
---SrwxrwT
---Srwxrwt
---s-----T
---s-----t
---s----wT
---s----wt
---s---r-T
---s---r-t
---s---rwT
---s---rwt
---s--x--T
---s--x--t
---s--x-wT
---s--x-wt
---s--xr-T
---s--xr-t
---s--xrwT
---s--xrwt
---s-w---T
---s-w---t
---s-w--wT
---s-w--wt
---s-w-r-T
---s-w-r-t
---s-w-rwT
---s-w-rwt
---s-wx--T
---s-wx--t
---s-wx-wT
---s-wx-wt
---s-wxr-T
---s-wxr-t
---s-wxrwT
---s-wxrwt
---sr----T
---sr----t
---sr---wT
---sr---wt
---sr--r-T
---sr--r-t
---sr--rwT
---sr--rwt
---sr-x--T
---sr-x--t
---sr-x-wT
---sr-x-wt
---sr-xr-T
---sr-xr-t
---sr-xrwT
---sr-xrwt
---srw---T
---srw---t
---srw--wT
---srw--wt
---srw-r-T
---srw-r-t
---srw-rwT
---srw-rwt
---srwx--T
---srwx--t
---srwx-wT
---srwx-wt
---srwxr-T
---srwxr-t
---srwxrwT
---srwxrwt
--wS-----T
--wS-----t
--wS----wT
--wS----wt
--wS---r-T
--wS---r-t
--wS---rwT
--wS---rwt
--wS--x--T
--wS--x--t
--wS--x-wT
--wS--x-wt
--wS--xr-T
--wS--xr-t
--wS--xrwT
--wS--xrwt
--wS-w---T
--wS-w---t
--wS-w--wT
--wS-w--wt
--wS-w-r-T
--wS-w-r-t
--wS-w-rwT
--wS-w-rwt
--wS-wx--T
--wS-wx--t
--wS-wx-wT
--wS-wx-wt
--wS-wxr-T
--wS-wxr-t
--wS-wxrwT
--wS-wxrwt
--wSr----T
--wSr----t
--wSr---wT
--wSr---wt
--wSr--r-T
--wSr--r-t
--wSr--rwT
--wSr--rwt
--wSr-x--T
--wSr-x--t
--wSr-x-wT
--wSr-x-wt
--wSr-xr-T
--wSr-xr-t
--wSr-xrwT
--wSr-xrwt
--wSrw---T
--wSrw---t
--wSrw--wT
--wSrw--wt
--wSrw-r-T
--wSrw-r-t
--wSrw-rwT
--wSrw-rwt
--wSrwx--T
--wSrwx--t
--wSrwx-wT
--wSrwx-wt
--wSrwxr-T
--wSrwxr-t
--wSrwxrwT
--wSrwxrwt
--ws-----T
--ws-----t
--ws----wT
--ws----wt
--ws---r-T
--ws---r-t
--ws---rwT
--ws---rwt
--ws--x--T
--ws--x--t
--ws--x-wT
--ws--x-wt
--ws--xr-T
--ws--xr-t
--ws--xrwT
--ws--xrwt
--ws-w---T
--ws-w---t
--ws-w--wT
--ws-w--wt
--ws-w-r-T
--ws-w-r-t
--ws-w-rwT
--ws-w-rwt
--ws-wx--T
--ws-wx--t
--ws-wx-wT
--ws-wx-wt
--ws-wxr-T
--ws-wxr-t
--ws-wxrwT
--ws-wxrwt
--wsr----T
--wsr----t
--wsr---wT
--wsr---wt
--wsr--r-T
--wsr--r-t
--wsr--rwT
--wsr--rwt
--wsr-x--T
--wsr-x--t
--wsr-x-wT
--wsr-x-wt
--wsr-xr-T
--wsr-xr-t
--wsr-xrwT
--wsr-xrwt
--wsrw---T
--wsrw---t
--wsrw--wT
--wsrw--wt
--wsrw-r-T
--wsrw-r-t
--wsrw-rwT
--wsrw-rwt
--wsrwx--T
--wsrwx--t
--wsrwx-wT
--wsrwx-wt
--wsrwxr-T
--wsrwxr-t
--wsrwxrwT
--wsrwxrwt
-r-S-----T
-r-S-----t
-r-S----wT
-r-S----wt
-r-S---r-T
-r-S---r-t
-r-S---rwT
-r-S---rwt
-r-S--x--T
-r-S--x--t
-r-S--x-wT
-r-S--x-wt
-r-S--xr-T
-r-S--xr-t
-r-S--xrwT
-r-S--xrwt
-r-S-w---T
-r-S-w---t
-r-S-w--wT
-r-S-w--wt
-r-S-w-r-T
-r-S-w-r-t
-r-S-w-rwT
-r-S-w-rwt
-r-S-wx--T
-r-S-wx--t
-r-S-wx-wT
-r-S-wx-wt
-r-S-wxr-T
-r-S-wxr-t
-r-S-wxrwT
-r-S-wxrwt
-r-Sr----T
-r-Sr----t
-r-Sr---wT
-r-Sr---wt
-r-Sr--r-T
-r-Sr--r-t
-r-Sr--rwT
-r-Sr--rwt
-r-Sr-x--T
-r-Sr-x--t
-r-Sr-x-wT
-r-Sr-x-wt
-r-Sr-xr-T
-r-Sr-xr-t
-r-Sr-xrwT
-r-Sr-xrwt
-r-Srw---T
-r-Srw---t
-r-Srw--wT
-r-Srw--wt
-r-Srw-r-T
-r-Srw-r-t
-r-Srw-rwT
-r-Srw-rwt
-r-Srwx--T
-r-Srwx--t
-r-Srwx-wT
-r-Srwx-wt
-r-Srwxr-T
-r-Srwxr-t
-r-SrwxrwT
-r-Srwxrwt
-r-s-----T
-r-s-----t
-r-s----wT
-r-s----wt
-r-s---r-T
-r-s---r-t
-r-s---rwT
-r-s---rwt
-r-s--x--T
-r-s--x--t
-r-s--x-wT
-r-s--x-wt
-r-s--xr-T
-r-s--xr-t
-r-s--xrwT
-r-s--xrwt
-r-s-w---T
-r-s-w---t
-r-s-w--wT
-r-s-w--wt
-r-s-w-r-T
-r-s-w-r-t
-r-s-w-rwT
-r-s-w-rwt
-r-s-wx--T
-r-s-wx--t
-r-s-wx-wT
-r-s-wx-wt
-r-s-wxr-T
-r-s-wxr-t
-r-s-wxrwT
-r-s-wxrwt
-r-sr----T
-r-sr----t
-r-sr---wT
-r-sr---wt
-r-sr--r-T
-r-sr--r-t
-r-sr--rwT
-r-sr--rwt
-r-sr-x--T
-r-sr-x--t
-r-sr-x-wT
-r-sr-x-wt
-r-sr-xr-T
-r-sr-xr-t
-r-sr-xrwT
-r-sr-xrwt
-r-srw---T
-r-srw---t
-r-srw--wT
-r-srw--wt
-r-srw-r-T
-r-srw-r-t
-r-srw-rwT
-r-srw-rwt
-r-srwx--T
-r-srwx--t
-r-srwx-wT
-r-srwx-wt
-r-srwxr-T
-r-srwxr-t
-r-srwxrwT
-r-srwxrwt
-rwS-----T
-rwS-----t
-rwS----wT
-rwS----wt
-rwS---r-T
-rwS---r-t
-rwS---rwT
-rwS---rwt
-rwS--x--T
-rwS--x--t
-rwS--x-wT
-rwS--x-wt
-rwS--xr-T
-rwS--xr-t
-rwS--xrwT
-rwS--xrwt
-rwS-w---T
-rwS-w---t
-rwS-w--wT
-rwS-w--wt
-rwS-w-r-T
-rwS-w-r-t
-rwS-w-rwT
-rwS-w-rwt
-rwS-wx--T
-rwS-wx--t
-rwS-wx-wT
-rwS-wx-wt
-rwS-wxr-T
-rwS-wxr-t
-rwS-wxrwT
-rwS-wxrwt
-rwSr----T
-rwSr----t
-rwSr---wT
-rwSr---wt
-rwSr--r-T
-rwSr--r-t
-rwSr--rwT
-rwSr--rwt
-rwSr-x--T
-rwSr-x--t
-rwSr-x-wT
-rwSr-x-wt
-rwSr-xr-T
-rwSr-xr-t
-rwSr-xrwT
-rwSr-xrwt
-rwSrw---T
-rwSrw---t
-rwSrw--wT
-rwSrw--wt
-rwSrw-r-T
-rwSrw-r-t
-rwSrw-rwT
-rwSrw-rwt
-rwSrwx--T
-rwSrwx--t
-rwSrwx-wT
-rwSrwx-wt
-rwSrwxr-T
-rwSrwxr-t
-rwSrwxrwT
-rwSrwxrwt
-rws-----T
-rws-----t
-rws----wT
-rws----wt
-rws---r-T
-rws---r-t
-rws---rwT
-rws---rwt
-rws--x--T
-rws--x--t
-rws--x-wT
-rws--x-wt
-rws--xr-T
-rws--xr-t
-rws--xrwT
-rws--xrwt
-rws-w---T
-rws-w---t
-rws-w--wT
-rws-w--wt
-rws-w-r-T
-rws-w-r-t
-rws-w-rwT
-rws-w-rwt
-rws-wx--T
-rws-wx--t
-rws-wx-wT
-rws-wx-wt
-rws-wxr-T
-rws-wxr-t
-rws-wxrwT
-rws-wxrwt
-rwsr----T
-rwsr----t
-rwsr---wT
-rwsr---wt
-rwsr--r-T
-rwsr--r-t
-rwsr--rwT
-rwsr--rwt
-rwsr-x--T
-rwsr-x--t
-rwsr-x-wT
-rwsr-x-wt
-rwsr-xr-T
-rwsr-xr-t
-rwsr-xrwT
-rwsr-xrwt
-rwsrw---T
-rwsrw---t
-rwsrw--wT
-rwsrw--wt
-rwsrw-r-T
-rwsrw-r-t
-rwsrw-rwT
-rwsrw-rwt
-rwsrwx--T
-rwsrwx--t
-rwsrwx-wT
-rwsrwx-wt
-rwsrwxr-T
-rwsrwxr-t
-rwsrwxrwT
-rwsrwxrwt
---S--S---
---S--S--x
---S--S-w-
---S--S-wx
---S--Sr--
---S--Sr-x
---S--Srw-
---S--Srwx
---S--s---
---S--s--x
---S--s-w-
---S--s-wx
---S--sr--
---S--sr-x
---S--srw-
---S--srwx
---S-wS---
---S-wS--x
---S-wS-w-
---S-wS-wx
---S-wSr--
---S-wSr-x
---S-wSrw-
---S-wSrwx
---S-ws---
---S-ws--x
---S-ws-w-
---S-ws-wx
---S-wsr--
---S-wsr-x
---S-wsrw-
---S-wsrwx
---Sr-S---
---Sr-S--x
---Sr-S-w-
---Sr-S-wx
---Sr-Sr--
---Sr-Sr-x
---Sr-Srw-
---Sr-Srwx
---Sr-s---
---Sr-s--x
---Sr-s-w-
---Sr-s-wx
---Sr-sr--
---Sr-sr-x
---Sr-srw-
---Sr-srwx
---SrwS---
---SrwS--x
---SrwS-w-
---SrwS-wx
---SrwSr--
---SrwSr-x
---SrwSrw-
---SrwSrwx
---Srws---
---Srws--x
---Srws-w-
---Srws-wx
---Srwsr--
---Srwsr-x
---Srwsrw-
---Srwsrwx
---s--S---
---s--S--x
---s--S-w-
---s--S-wx
---s--Sr--
---s--Sr-x
---s--Srw-
---s--Srwx
---s--s---
---s--s--x
---s--s-w-
---s--s-wx
---s--sr--
---s--sr-x
---s--srw-
---s--srwx
---s-wS---
---s-wS--x
---s-wS-w-
---s-wS-wx
---s-wSr--
---s-wSr-x
---s-wSrw-
---s-wSrwx
---s-ws---
---s-ws--x
---s-ws-w-
---s-ws-wx
---s-wsr--
---s-wsr-x
---s-wsrw-
---s-wsrwx
---sr-S---
---sr-S--x
---sr-S-w-
---sr-S-wx
---sr-Sr--
---sr-Sr-x
---sr-Srw-
---sr-Srwx
---sr-s---
---sr-s--x
---sr-s-w-
---sr-s-wx
---sr-sr--
---sr-sr-x
---sr-srw-
---sr-srwx
---srwS---
---srwS--x
---srwS-w-
---srwS-wx
---srwSr--
---srwSr-x
---srwSrw-
---srwSrwx
---srws---
---srws--x
---srws-w-
---srws-wx
---srwsr--
---srwsr-x
---srwsrw-
---srwsrwx
--wS--S---
--wS--S--x
--wS--S-w-
--wS--S-wx
--wS--Sr--
--wS--Sr-x
--wS--Srw-
--wS--Srwx
--wS--s---
--wS--s--x
--wS--s-w-
--wS--s-wx
--wS--sr--
--wS--sr-x
--wS--srw-
--wS--srwx
--wS-wS---
--wS-wS--x
--wS-wS-w-
--wS-wS-wx
--wS-wSr--
--wS-wSr-x
--wS-wSrw-
--wS-wSrwx
--wS-ws---
--wS-ws--x
--wS-ws-w-
--wS-ws-wx
--wS-wsr--
--wS-wsr-x
--wS-wsrw-
--wS-wsrwx
--wSr-S---
--wSr-S--x
--wSr-S-w-
--wSr-S-wx
--wSr-Sr--
--wSr-Sr-x
--wSr-Srw-
--wSr-Srwx
--wSr-s---
--wSr-s--x
--wSr-s-w-
--wSr-s-wx
--wSr-sr--
--wSr-sr-x
--wSr-srw-
--wSr-srwx
--wSrwS---
--wSrwS--x
--wSrwS-w-
--wSrwS-wx
--wSrwSr--
--wSrwSr-x
--wSrwSrw-
--wSrwSrwx
--wSrws---
--wSrws--x
--wSrws-w-
--wSrws-wx
--wSrwsr--
--wSrwsr-x
--wSrwsrw-
--wSrwsrwx
--ws--S---
--ws--S--x
--ws--S-w-
--ws--S-wx
--ws--Sr--
--ws--Sr-x
--ws--Srw-
--ws--Srwx
--ws--s---
--ws--s--x
--ws--s-w-
--ws--s-wx
--ws--sr--
--ws--sr-x
--ws--srw-
--ws--srwx
--ws-wS---
--ws-wS--x
--ws-wS-w-
--ws-wS-wx
--ws-wSr--
--ws-wSr-x
--ws-wSrw-
--ws-wSrwx
--ws-ws---
--ws-ws--x
--ws-ws-w-
--ws-ws-wx
--ws-wsr--
--ws-wsr-x
--ws-wsrw-
--ws-wsrwx
--wsr-S---
--wsr-S--x
--wsr-S-w-
--wsr-S-wx
--wsr-Sr--
--wsr-Sr-x
--wsr-Srw-
--wsr-Srwx
--wsr-s---
--wsr-s--x
--wsr-s-w-
--wsr-s-wx
--wsr-sr--
--wsr-sr-x
--wsr-srw-
--wsr-srwx
--wsrwS---
--wsrwS--x
--wsrwS-w-
--wsrwS-wx
--wsrwSr--
--wsrwSr-x
--wsrwSrw-
--wsrwSrwx
--wsrws---
--wsrws--x
--wsrws-w-
--wsrws-wx
--wsrwsr--
--wsrwsr-x
--wsrwsrw-
--wsrwsrwx
-r-S--S---
-r-S--S--x
-r-S--S-w-
-r-S--S-wx
-r-S--Sr--
-r-S--Sr-x
-r-S--Srw-
-r-S--Srwx
-r-S--s---
-r-S--s--x
-r-S--s-w-
-r-S--s-wx
-r-S--sr--
-r-S--sr-x
-r-S--srw-
-r-S--srwx
-r-S-wS---
-r-S-wS--x
-r-S-wS-w-
-r-S-wS-wx
-r-S-wSr--
-r-S-wSr-x
-r-S-wSrw-
-r-S-wSrwx
-r-S-ws---
-r-S-ws--x
-r-S-ws-w-
-r-S-ws-wx
-r-S-wsr--
-r-S-wsr-x
-r-S-wsrw-
-r-S-wsrwx
-r-Sr-S---
-r-Sr-S--x
-r-Sr-S-w-
-r-Sr-S-wx
-r-Sr-Sr--
-r-Sr-Sr-x
-r-Sr-Srw-
-r-Sr-Srwx
-r-Sr-s---
-r-Sr-s--x
-r-Sr-s-w-
-r-Sr-s-wx
-r-Sr-sr--
-r-Sr-sr-x
-r-Sr-srw-
-r-Sr-srwx
-r-SrwS---
-r-SrwS--x
-r-SrwS-w-
-r-SrwS-wx
-r-SrwSr--
-r-SrwSr-x
-r-SrwSrw-
-r-SrwSrwx
-r-Srws---
-r-Srws--x
-r-Srws-w-
-r-Srws-wx
-r-Srwsr--
-r-Srwsr-x
-r-Srwsrw-
-r-Srwsrwx
-r-s--S---
-r-s--S--x
-r-s--S-w-
-r-s--S-wx
-r-s--Sr--
-r-s--Sr-x
-r-s--Srw-
-r-s--Srwx
-r-s--s---
-r-s--s--x
-r-s--s-w-
-r-s--s-wx
-r-s--sr--
-r-s--sr-x
-r-s--srw-
-r-s--srwx
-r-s-wS---
-r-s-wS--x
-r-s-wS-w-
-r-s-wS-wx
-r-s-wSr--
-r-s-wSr-x
-r-s-wSrw-
-r-s-wSrwx
-r-s-ws---
-r-s-ws--x
-r-s-ws-w-
-r-s-ws-wx
-r-s-wsr--
-r-s-wsr-x
-r-s-wsrw-
-r-s-wsrwx
-r-sr-S---
-r-sr-S--x
-r-sr-S-w-
-r-sr-S-wx
-r-sr-Sr--
-r-sr-Sr-x
-r-sr-Srw-
-r-sr-Srwx
-r-sr-s---
-r-sr-s--x
-r-sr-s-w-
-r-sr-s-wx
-r-sr-sr--
-r-sr-sr-x
-r-sr-srw-
-r-sr-srwx
-r-srwS---
-r-srwS--x
-r-srwS-w-
-r-srwS-wx
-r-srwSr--
-r-srwSr-x
-r-srwSrw-
-r-srwSrwx
-r-srws---
-r-srws--x
-r-srws-w-
-r-srws-wx
-r-srwsr--
-r-srwsr-x
-r-srwsrw-
-r-srwsrwx
-rwS--S---
-rwS--S--x
-rwS--S-w-
-rwS--S-wx
-rwS--Sr--
-rwS--Sr-x
-rwS--Srw-
-rwS--Srwx
-rwS--s---
-rwS--s--x
-rwS--s-w-
-rwS--s-wx
-rwS--sr--
-rwS--sr-x
-rwS--srw-
-rwS--srwx
-rwS-wS---
-rwS-wS--x
-rwS-wS-w-
-rwS-wS-wx
-rwS-wSr--
-rwS-wSr-x
-rwS-wSrw-
-rwS-wSrwx
-rwS-ws---
-rwS-ws--x
-rwS-ws-w-
-rwS-ws-wx
-rwS-wsr--
-rwS-wsr-x
-rwS-wsrw-
-rwS-wsrwx
-rwSr-S---
-rwSr-S--x
-rwSr-S-w-
-rwSr-S-wx
-rwSr-Sr--
-rwSr-Sr-x
-rwSr-Srw-
-rwSr-Srwx
-rwSr-s---
-rwSr-s--x
-rwSr-s-w-
-rwSr-s-wx
-rwSr-sr--
-rwSr-sr-x
-rwSr-srw-
-rwSr-srwx
-rwSrwS---
-rwSrwS--x
-rwSrwS-w-
-rwSrwS-wx
-rwSrwSr--
-rwSrwSr-x
-rwSrwSrw-
-rwSrwSrwx
-rwSrws---
-rwSrws--x
-rwSrws-w-
-rwSrws-wx
-rwSrwsr--
-rwSrwsr-x
-rwSrwsrw-
-rwSrwsrwx
-rws--S---
-rws--S--x
-rws--S-w-
-rws--S-wx
-rws--Sr--
-rws--Sr-x
-rws--Srw-
-rws--Srwx
-rws--s---
-rws--s--x
-rws--s-w-
-rws--s-wx
-rws--sr--
-rws--sr-x
-rws--srw-
-rws--srwx
-rws-wS---
-rws-wS--x
-rws-wS-w-
-rws-wS-wx
-rws-wSr--
-rws-wSr-x
-rws-wSrw-
-rws-wSrwx
-rws-ws---
-rws-ws--x
-rws-ws-w-
-rws-ws-wx
-rws-wsr--
-rws-wsr-x
-rws-wsrw-
-rws-wsrwx
-rwsr-S---
-rwsr-S--x
-rwsr-S-w-
-rwsr-S-wx
-rwsr-Sr--
-rwsr-Sr-x
-rwsr-Srw-
-rwsr-Srwx
-rwsr-s---
-rwsr-s--x
-rwsr-s-w-
-rwsr-s-wx
-rwsr-sr--
-rwsr-sr-x
-rwsr-srw-
-rwsr-srwx
-rwsrwS---
-rwsrwS--x
-rwsrwS-w-
-rwsrwS-wx
-rwsrwSr--
-rwsrwSr-x
-rwsrwSrw-
-rwsrwSrwx
-rwsrws---
-rwsrws--x
-rwsrws-w-
-rwsrws-wx
-rwsrwsr--
-rwsrwsr-x
-rwsrwsrw-
-rwsrwsrwx
---S--S--T
---S--S--t
---S--S-wT
---S--S-wt
---S--Sr-T
---S--Sr-t
---S--SrwT
---S--Srwt
---S--s--T
---S--s--t
---S--s-wT
---S--s-wt
---S--sr-T
---S--sr-t
---S--srwT
---S--srwt
---S-wS--T
---S-wS--t
---S-wS-wT
---S-wS-wt
---S-wSr-T
---S-wSr-t
---S-wSrwT
---S-wSrwt
---S-ws--T
---S-ws--t
---S-ws-wT
---S-ws-wt
---S-wsr-T
---S-wsr-t
---S-wsrwT
---S-wsrwt
---Sr-S--T
---Sr-S--t
---Sr-S-wT
---Sr-S-wt
---Sr-Sr-T
---Sr-Sr-t
---Sr-SrwT
---Sr-Srwt
---Sr-s--T
---Sr-s--t
---Sr-s-wT
---Sr-s-wt
---Sr-sr-T
---Sr-sr-t
---Sr-srwT
---Sr-srwt
---SrwS--T
---SrwS--t
---SrwS-wT
---SrwS-wt
---SrwSr-T
---SrwSr-t
---SrwSrwT
---SrwSrwt
---Srws--T
---Srws--t
---Srws-wT
---Srws-wt
---Srwsr-T
---Srwsr-t
---SrwsrwT
---Srwsrwt
---s--S--T
---s--S--t
---s--S-wT
---s--S-wt
---s--Sr-T
---s--Sr-t
---s--SrwT
---s--Srwt
---s--s--T
---s--s--t
---s--s-wT
---s--s-wt
---s--sr-T
---s--sr-t
---s--srwT
---s--srwt
---s-wS--T
---s-wS--t
---s-wS-wT
---s-wS-wt
---s-wSr-T
---s-wSr-t
---s-wSrwT
---s-wSrwt
---s-ws--T
---s-ws--t
---s-ws-wT
---s-ws-wt
---s-wsr-T
---s-wsr-t
---s-wsrwT
---s-wsrwt
---sr-S--T
---sr-S--t
---sr-S-wT
---sr-S-wt
---sr-Sr-T
---sr-Sr-t
---sr-SrwT
---sr-Srwt
---sr-s--T
---sr-s--t
---sr-s-wT
---sr-s-wt
---sr-sr-T
---sr-sr-t
---sr-srwT
---sr-srwt
---srwS--T
---srwS--t
---srwS-wT
---srwS-wt
---srwSr-T
---srwSr-t
---srwSrwT
---srwSrwt
---srws--T
---srws--t
---srws-wT
---srws-wt
---srwsr-T
---srwsr-t
---srwsrwT
---srwsrwt
--wS--S--T
--wS--S--t
--wS--S-wT
--wS--S-wt
--wS--Sr-T
--wS--Sr-t
--wS--SrwT
--wS--Srwt
--wS--s--T
--wS--s--t
--wS--s-wT
--wS--s-wt
--wS--sr-T
--wS--sr-t
--wS--srwT
--wS--srwt
--wS-wS--T
--wS-wS--t
--wS-wS-wT
--wS-wS-wt
--wS-wSr-T
--wS-wSr-t
--wS-wSrwT
--wS-wSrwt
--wS-ws--T
--wS-ws--t
--wS-ws-wT
--wS-ws-wt
--wS-wsr-T
--wS-wsr-t
--wS-wsrwT
--wS-wsrwt
--wSr-S--T
--wSr-S--t
--wSr-S-wT
--wSr-S-wt
--wSr-Sr-T
--wSr-Sr-t
--wSr-SrwT
--wSr-Srwt
--wSr-s--T
--wSr-s--t
--wSr-s-wT
--wSr-s-wt
--wSr-sr-T
--wSr-sr-t
--wSr-srwT
--wSr-srwt
--wSrwS--T
--wSrwS--t
--wSrwS-wT
--wSrwS-wt
--wSrwSr-T
--wSrwSr-t
--wSrwSrwT
--wSrwSrwt
--wSrws--T
--wSrws--t
--wSrws-wT
--wSrws-wt
--wSrwsr-T
--wSrwsr-t
--wSrwsrwT
--wSrwsrwt
--ws--S--T
--ws--S--t
--ws--S-wT
--ws--S-wt
--ws--Sr-T
--ws--Sr-t
--ws--SrwT
--ws--Srwt
--ws--s--T
--ws--s--t
--ws--s-wT
--ws--s-wt
--ws--sr-T
--ws--sr-t
--ws--srwT
--ws--srwt
--ws-wS--T
--ws-wS--t
--ws-wS-wT
--ws-wS-wt
--ws-wSr-T
--ws-wSr-t
--ws-wSrwT
--ws-wSrwt
--ws-ws--T
--ws-ws--t
--ws-ws-wT
--ws-ws-wt
--ws-wsr-T
--ws-wsr-t
--ws-wsrwT
--ws-wsrwt
--wsr-S--T
--wsr-S--t
--wsr-S-wT
--wsr-S-wt
--wsr-Sr-T
--wsr-Sr-t
--wsr-SrwT
--wsr-Srwt
--wsr-s--T
--wsr-s--t
--wsr-s-wT
--wsr-s-wt
--wsr-sr-T
--wsr-sr-t
--wsr-srwT
--wsr-srwt
--wsrwS--T
--wsrwS--t
--wsrwS-wT
--wsrwS-wt
--wsrwSr-T
--wsrwSr-t
--wsrwSrwT
--wsrwSrwt
--wsrws--T
--wsrws--t
--wsrws-wT
--wsrws-wt
--wsrwsr-T
--wsrwsr-t
--wsrwsrwT
--wsrwsrwt
-r-S--S--T
-r-S--S--t
-r-S--S-wT
-r-S--S-wt
-r-S--Sr-T
-r-S--Sr-t
-r-S--SrwT
-r-S--Srwt
-r-S--s--T
-r-S--s--t
-r-S--s-wT
-r-S--s-wt
-r-S--sr-T
-r-S--sr-t
-r-S--srwT
-r-S--srwt
-r-S-wS--T
-r-S-wS--t
-r-S-wS-wT
-r-S-wS-wt
-r-S-wSr-T
-r-S-wSr-t
-r-S-wSrwT
-r-S-wSrwt
-r-S-ws--T
-r-S-ws--t
-r-S-ws-wT
-r-S-ws-wt
-r-S-wsr-T
-r-S-wsr-t
-r-S-wsrwT
-r-S-wsrwt
-r-Sr-S--T
-r-Sr-S--t
-r-Sr-S-wT
-r-Sr-S-wt
-r-Sr-Sr-T
-r-Sr-Sr-t
-r-Sr-SrwT
-r-Sr-Srwt
-r-Sr-s--T
-r-Sr-s--t
-r-Sr-s-wT
-r-Sr-s-wt
-r-Sr-sr-T
-r-Sr-sr-t
-r-Sr-srwT
-r-Sr-srwt
-r-SrwS--T
-r-SrwS--t
-r-SrwS-wT
-r-SrwS-wt
-r-SrwSr-T
-r-SrwSr-t
-r-SrwSrwT
-r-SrwSrwt
-r-Srws--T
-r-Srws--t
-r-Srws-wT
-r-Srws-wt
-r-Srwsr-T
-r-Srwsr-t
-r-SrwsrwT
-r-Srwsrwt
-r-s--S--T
-r-s--S--t
-r-s--S-wT
-r-s--S-wt
-r-s--Sr-T
-r-s--Sr-t
-r-s--SrwT
-r-s--Srwt
-r-s--s--T
-r-s--s--t
-r-s--s-wT
-r-s--s-wt
-r-s--sr-T
-r-s--sr-t
-r-s--srwT
-r-s--srwt
-r-s-wS--T
-r-s-wS--t
-r-s-wS-wT
-r-s-wS-wt
-r-s-wSr-T
-r-s-wSr-t
-r-s-wSrwT
-r-s-wSrwt
-r-s-ws--T
-r-s-ws--t
-r-s-ws-wT
-r-s-ws-wt
-r-s-wsr-T
-r-s-wsr-t
-r-s-wsrwT
-r-s-wsrwt
-r-sr-S--T
-r-sr-S--t
-r-sr-S-wT
-r-sr-S-wt
-r-sr-Sr-T
-r-sr-Sr-t
-r-sr-SrwT
-r-sr-Srwt
-r-sr-s--T
-r-sr-s--t
-r-sr-s-wT
-r-sr-s-wt
-r-sr-sr-T
-r-sr-sr-t
-r-sr-srwT
-r-sr-srwt
-r-srwS--T
-r-srwS--t
-r-srwS-wT
-r-srwS-wt
-r-srwSr-T
-r-srwSr-t
-r-srwSrwT
-r-srwSrwt
-r-srws--T
-r-srws--t
-r-srws-wT
-r-srws-wt
-r-srwsr-T
-r-srwsr-t
-r-srwsrwT
-r-srwsrwt
-rwS--S--T
-rwS--S--t
-rwS--S-wT
-rwS--S-wt
-rwS--Sr-T
-rwS--Sr-t
-rwS--SrwT
-rwS--Srwt
-rwS--s--T
-rwS--s--t
-rwS--s-wT
-rwS--s-wt
-rwS--sr-T
-rwS--sr-t
-rwS--srwT
-rwS--srwt
-rwS-wS--T
-rwS-wS--t
-rwS-wS-wT
-rwS-wS-wt
-rwS-wSr-T
-rwS-wSr-t
-rwS-wSrwT
-rwS-wSrwt
-rwS-ws--T
-rwS-ws--t
-rwS-ws-wT
-rwS-ws-wt
-rwS-wsr-T
-rwS-wsr-t
-rwS-wsrwT
-rwS-wsrwt
-rwSr-S--T
-rwSr-S--t
-rwSr-S-wT
-rwSr-S-wt
-rwSr-Sr-T
-rwSr-Sr-t
-rwSr-SrwT
-rwSr-Srwt
-rwSr-s--T
-rwSr-s--t
-rwSr-s-wT
-rwSr-s-wt
-rwSr-sr-T
-rwSr-sr-t
-rwSr-srwT
-rwSr-srwt
-rwSrwS--T
-rwSrwS--t
-rwSrwS-wT
-rwSrwS-wt
-rwSrwSr-T
-rwSrwSr-t
-rwSrwSrwT
-rwSrwSrwt
-rwSrws--T
-rwSrws--t
-rwSrws-wT
-rwSrws-wt
-rwSrwsr-T
-rwSrwsr-t
-rwSrwsrwT
-rwSrwsrwt
-rws--S--T
-rws--S--t
-rws--S-wT
-rws--S-wt
-rws--Sr-T
-rws--Sr-t
-rws--SrwT
-rws--Srwt
-rws--s--T
-rws--s--t
-rws--s-wT
-rws--s-wt
-rws--sr-T
-rws--sr-t
-rws--srwT
-rws--srwt
-rws-wS--T
-rws-wS--t
-rws-wS-wT
-rws-wS-wt
-rws-wSr-T
-rws-wSr-t
-rws-wSrwT
-rws-wSrwt
-rws-ws--T
-rws-ws--t
-rws-ws-wT
-rws-ws-wt
-rws-wsr-T
-rws-wsr-t
-rws-wsrwT
-rws-wsrwt
-rwsr-S--T
-rwsr-S--t
-rwsr-S-wT
-rwsr-S-wt
-rwsr-Sr-T
-rwsr-Sr-t
-rwsr-SrwT
-rwsr-Srwt
-rwsr-s--T
-rwsr-s--t
-rwsr-s-wT
-rwsr-s-wt
-rwsr-sr-T
-rwsr-sr-t
-rwsr-srwT
-rwsr-srwt
-rwsrwS--T
-rwsrwS--t
-rwsrwS-wT
-rwsrwS-wt
-rwsrwSr-T
-rwsrwSr-t
-rwsrwSrwT
-rwsrwSrwt
-rwsrws--T
-rwsrws--t
-rwsrws-wT
-rwsrws-wt
-rwsrwsr-T
-rwsrwsr-t
-rwsrwsrwT
-rwsrwsrwt
