/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;

public final class SeverityLevelCounter
implements AuditListener {
    private SeverityLevel mLevel;
    private int mCount;

    public SeverityLevelCounter(SeverityLevel aLevel) {
        if (aLevel == null) {
            throw new IllegalArgumentException();
        }
        this.mLevel = aLevel;
    }

    public void addError(AuditEvent aEvt) {
        if (this.mLevel.equals(aEvt.getSeverityLevel())) {
            ++this.mCount;
        }
    }

    public void addException(AuditEvent aEvt, Throwable aThrowable) {
        if (SeverityLevel.ERROR.equals(this.mLevel)) {
            ++this.mCount;
        }
    }

    public void auditStarted(AuditEvent aEvt) {
        this.mCount = 0;
    }

    public void fileStarted(AuditEvent aEvt) {
    }

    public void auditFinished(AuditEvent aEvt) {
    }

    public void fileFinished(AuditEvent aEvt) {
    }

    public int getCount() {
        return this.mCount;
    }
}

