/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.de;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_de extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Falkland = new String[] {
               "Falklandinseln-Winterzeit",
               "FIST",
               "Falklandinseln-Sommerzeit",
               "FIST",
               "Falklandinseln-Zeit",
               "FIT",
            };
        final String[] Cape_Verde = new String[] {
               "Kap-Verde-Winterzeit",
               "CVST",
               "Kap-Verde-Sommerzeit",
               "CVST",
               "Kap-Verde-Zeit",
               "CVT",
            };
        final String[] GMT = new String[] {
               "Mittlere Greenwich-Zeit",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Omsk = new String[] {
               "Omsk-Winterzeit",
               "OST",
               "Omsk-Sommerzeit",
               "OST",
               "Omsk-Zeit",
               "OT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae-Zeit",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleuten-Winterzeit",
               "HAST",
               "Hawaii-Aleuten-Sommerzeit",
               "HADT",
               "Hawaii-Aleuten-Zeit",
               "HAT",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin-Winterzeit",
               "SST",
               "Sakhalin-Sommerzeit",
               "SST",
               "Sakhalin-Zeit",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk-Winterzeit",
               "YST",
               "Yakutsk-Sommerzeit",
               "YST",
               "Yakutsk-Zeit",
               "YT",
            };
        final String[] Gambier = new String[] {
               "Gambier-Zeit",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Maldives = new String[] {
               "Malediven-Zeit",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Japan = new String[] {
               "Japanische Winterzeit",
               "JST",
               "Japanische Sommerzeit",
               "JDT",
               "Japanische Zeit",
               "JT",
            };
        final String[] Vladivostok = new String[] {
               "Wladiwostok-Winterzeit",
               "VST",
               "Wladiwostok-Sommerzeit",
               "VST",
               "Wladiwostok-Zeit",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "Westeurop\u00e4ische Winterzeit",
               "WEZ",
               "Westeurop\u00e4ische Sommerzeit",
               "WESZ",
               "Westeurop\u00e4ische Zeit",
               "WEZ",
            };
        final String[] Hovd = new String[] {
               "Hovd-Winterzeit",
               "HST",
               "Hovd-Sommerzeit",
               "HST",
               "Hovd-Zeit",
               "HT",
            };
        final String[] Amazon = new String[] {
               "Amazonas Winterzeit",
               "AST",
               "Amazonas Sommerzeit",
               "AST",
               "Amazonas Zeit",
               "AT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert-Inseln-Zeit",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] Mongolia = new String[] {
               "Mongolische Winterzeit",
               "UBST",
               "Mongolische Sommerzeit",
               "UBST",
               "Mongolische Zeit",
               "UBT",
            };
        final String[] America_Pacific = new String[] {
               "Nordamerikanische Westk\u00fcsten-Winterzeit",
               "PST",
               "Nordamerikanische Westk\u00fcsten-Sommerzeit",
               "PDT",
               "Nordamerikanische Westk\u00fcstenzeit",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "West-Argentinische Winterzeit",
               "WAST",
               "West-Argentinische Sommerzeit",
               "WAST",
               "West-Argentinische Zeit",
               "WAT",
            };
        final String[] Galapagos = new String[] {
               "Galapagos-Zeit",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] Christmas = new String[] {
               "Weihnachtsinsel-Zeit",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Volgograd = new String[] {
               "Wolgograd-Winterzeit",
               "VST",
               "Wolgograd-Sommerzeit",
               "VST",
               "Wolgograd-Zeit",
               "VT",
            };
        final String[] Korea = new String[] {
               "Koreanische Winterzeit",
               "KST",
               "Koreanische Sommerzeit",
               "KDT",
               "Koreanische Zeit",
               "KT",
            };
        final String[] Argentina = new String[] {
               "Argentinische Winterzeit",
               "AST",
               "Argentinische Sommerzeit",
               "AST",
               "Argentinische Zeit",
               "AT",
            };
        final String[] Lord_Howe = new String[] {
               "Lord-Howe-Winterzeit",
               "LHST",
               "Lord-Howe-Sommerzeit",
               "LHDT",
               "Lord-Howe-Zeit",
               "LHT",
            };
        final String[] Syowa = new String[] {
               "Syowa-Zeit",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Arabian = new String[] {
               "Arabische Winterzeit",
               "AST",
               "Arabische Sommerzeit",
               "ADT",
               "Arabische Zeit",
               "AT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ostaustralische Winterzeit",
               "AEST",
               "Ostaustralische Sommerzeit",
               "AEDT",
               "Ostaustralische Zeit",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk-Winterzeit",
               "IST",
               "Irkutsk-Sommerzeit",
               "IST",
               "Irkutsk-Zeit",
               "IT",
            };
        final String[] Mauritius = new String[] {
               "Mauritius-Winterzeit",
               "MST",
               "Mauritius-Sommerzeit",
               "MST",
               "Mauritius-Zeit",
               "MT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indischer Ozean-Zeit",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsan Winterzeit",
               "CST",
               "Choibalsan Sommerzeit",
               "CST",
               "Choibalsan Zeit",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Nordamerikanische Ostk\u00fcsten-Winterzeit",
               "EST",
               "Nordamerikanische Ostk\u00fcsten-Sommerzeit",
               "EDT",
               "Nordamerikanische Ostk\u00fcstenzeit",
               "ET",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Zentral-/Westaustralische Winterzeit",
               "ACWST",
               "Zentral-/Westaustralische Sommerzeit",
               "ACWDT",
               "Zentral-/Westaustralische Zeit",
               "ACWT",
            };
        final String[] Australia_Western = new String[] {
               "Westaustralische Winterzeit",
               "AWST",
               "Westaustralische Sommerzeit",
               "AWDT",
               "Westaustralische Zeit",
               "WAT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk-Winterzeit",
               "KST",
               "Krasnoyarsk-Sommerzeit",
               "KST",
               "Krasnoyarsk-Zeit",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ostindonesische Zeit",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha Winterzeit",
               "FNST",
               "Fernando de Noronha Sommerzeit",
               "FNST",
               "Fernando de Noronha Zeit",
               "FNT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk-Winterzeit",
               "NST",
               "Novosibirsk-Sommerzeit",
               "NST",
               "Novosibirsk-Zeit",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "Rocky Mountain Winterzeit",
               "MST",
               "Rocky Mountain Sommerzeit",
               "MDT",
               "Rocky Mountain Zeit",
               "MT",
            };
        final String[] Vostok = new String[] {
               "Vostok-Zeit",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Alaska = new String[] {
               "Alaska Winterzeit",
               "AKST",
               "Alaska Sommerzeit",
               "AKDT",
               "Alaska Zeit",
               "AKT",
            };
        final String[] Australia_Central = new String[] {
               "Zentralaustralische Winterzeit",
               "ACST",
               "Zentralaustralische Sommerzeit",
               "ACDT",
               "Zentralaustralische Zeit",
               "CAT",
            };
        final String[] Azores = new String[] {
               "Azoren-Winterzeit",
               "AST",
               "Azoren-Sommerzeit",
               "AST",
               "Azoren-Zeit",
               "AT",
            };
        final String[] Reunion = new String[] {
               "Reunion-Zeit",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Indochina = new String[] {
               "Indochinesische Zeit",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Magadan = new String[] {
               "Magadan-Winterzeit",
               "MST",
               "Magadan-Sommerzeit",
               "MST",
               "Magadan-Zeit",
               "MT",
            };
        final String[] Chatham = new String[] {
               "Chatham-Winterzeit",
               "CST",
               "Chatham-Sommerzeit",
               "CDT",
               "Chatham-Zeit",
               "CT",
            };
        final String[] Davis = new String[] {
               "Davis-Zeit",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Africa_Western = new String[] {
               "Westafrikanische Winterzeit",
               "WAST",
               "Westafrikanische Sommerzeit",
               "WAST",
               "Westafrikanische Zeit",
               "WAT",
            };
        final String[] Moscow = new String[] {
               "Moskauer Winterzeit",
               "MST",
               "Moskauer Sommerzeit",
               "MST",
               "Moskauer Zeit",
               "MT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ostkasachstanische Zeit",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] New_Zealand = new String[] {
               "Neuseeland-Winterzeit",
               "NZST",
               "Neuseeland-Sommerzeit",
               "NZDT",
               "Neuseeland-Zeit",
               "NZT",
            };
        final String[] Hong_Kong = new String[] {
               "Hong-Kong-Winterzeit",
               "HKST",
               "Hong-Kong-Sommerzeit",
               "HKST",
               "Hong-Kong-Zeit",
               "HKT",
            };
        final String[] Brasilia = new String[] {
               "Brasilianische Winterzeit",
               "BST",
               "Brasilianische Sommerzeit",
               "BST",
               "Brasilianische Zeit",
               "BT",
            };
        final String[] Cocos = new String[] {
               "Kokosinseln-Zeit",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Afghanistan = new String[] {
               "Afghanistan-Zeit",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Indonesia_Western = new String[] {
               "Westindonesische Zeit",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Seychelles = new String[] {
               "Seychellen-Zeit",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Africa_Central = new String[] {
               "Zentralafrikanische Zeit",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Easter = new String[] {
               "Osterinsel-Winterzeit",
               "EIST",
               "Osterinsel-Sommerzeit",
               "EIST",
               "Osterinsel-Zeit",
               "EIT",
            };
        final String[] South_Georgia = new String[] {
               "S\u00fcdgeorgische Zeit",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Indonesia_Central = new String[] {
               "Zentralindonesische Zeit",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-Zeit",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Newfoundland = new String[] {
               "Neufundland-Winterzeit",
               "NST",
               "Neufundland-Sommerzeit",
               "NDT",
               "Neufundland-Zeit",
               "NT",
            };
        final String[] Line_Islands = new String[] {
               "Zentralpolynesische Sporaden-Zeit",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Cook = new String[] {
               "Cookinseln-Winterzeit",
               "CIST",
               "Cookinseln-Sommerzeit",
               "CIHST",
               "Cookinseln-Zeit",
               "CIT",
            };
        final String[] America_Central = new String[] {
               "Nordamerikanische Inland-Winterzeit",
               "CST",
               "Nordamerikanische Inland-Sommerzeit",
               "CDT",
               "Nordamerikanische Inlandzeit",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ostafrikanische Zeit",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburg-Winterzeit",
               "YST",
               "Jekaterinburg-Sommerzeit",
               "YST",
               "Jekaterinburg-Zeit",
               "YT",
            };
        final String[] China = new String[] {
               "Chinesische Winterzeit",
               "CST",
               "Chinesische Sommerzeit",
               "CDT",
               "Chinesische Zeit",
               "CT",
            };
        final String[] Africa_Southern = new String[] {
               "S\u00fcdafrikanische Zeit",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie-Zeit",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] French_Southern = new String[] {
               "Franz\u00f6sische S\u00fcd- und Antarktisgebiete-Zeit",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Westkasachstanische Zeit",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Israel = new String[] {
               "Israelische Winterzeit",
               "IST",
               "Israelische Sommerzeit",
               "IDT",
               "Israelische Zeit",
               "IT",
            };
        final String[] Mawson = new String[] {
               "Mawson-Zeit",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Fiji = new String[] {
               "Fidschi-Winterzeit",
               "FST",
               "Fidschi-Sommerzeit",
               "FST",
               "Fidschi-Zeit",
               "FT",
            };
        final String[] Rothera = new String[] {
               "Rothera-Zeit",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Europe_Central = new String[] {
               "Mitteleurop\u00e4ische Winterzeit",
               "MEZ",
               "Mitteleurop\u00e4ische Sommerzeit",
               "MESZ",
               "Mitteleurop\u00e4ische Zeit",
               "MEZ",
            };
        final String[] India = new String[] {
               "Indische Zeit",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d'Urville-Zeit",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Europe_Eastern = new String[] {
               "Osteurop\u00e4ische Winterzeit",
               "OEZ",
               "Osteurop\u00e4ische Sommerzeit",
               "OESZ",
               "Osteurop\u00e4ische Zeit",
               "OEZ",
            };
        final String[] Atlantic = new String[] {
               "Atlantik-Winterzeit",
               "AST",
               "Atlantik-Sommerzeit",
               "ADT",
               "Atlantik-Zeit",
               "AT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Douala", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "Asia/Bangkok", Indochina },
            { "Asia/Colombo", India },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Blantyre", Africa_Central },
            { "Europe/Volgograd", Volgograd },
            { "Atlantic/St_Helena", GMT },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Resolute", America_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "Indian/Kerguelen", French_Southern },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Bahia_Banderas", America_Central },
            { "Pacific/Rarotonga", Cook },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "Antarctica/Casey", Australia_Western },
            { "PST8PDT", America_Pacific },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Bamako", GMT },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Guam", Chamorro },
            { "Africa/Maseru", Africa_Southern },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vientiane", Indochina },
            { "Africa/Niamey", Africa_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Indian/Reunion", Reunion },
            { "Asia/Oral", Kazakhstan_Western },
            { "Africa/Lusaka", Africa_Central },
            { "America/Tortola", Atlantic },
            { "Africa/Ouagadougou", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Moncton", Atlantic },
            { "America/Maceio", Brasilia },
            { "Africa/Dakar", GMT },
            { "America/Belize", America_Central },
            { "America/Cuiaba", Amazon },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "Antarctica/Rothera", Rothera },
            { "Indian/Cocos", Cocos },
            { "America/Glace_Bay", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Mauritius", Mauritius },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Antarctica/Vostok", Vostok },
            { "Pacific/Auckland", New_Zealand },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Africa/Nairobi", Africa_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "Pacific/Chatham", Chatham },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Maputo", Africa_Central },
            { "America/Metlakatla", America_Pacific },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Asia/Baghdad", Arabian },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Africa/Bissau", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "Europe/Luxembourg", Europe_Central },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Phnom_Penh", Indochina },
            { "Australia/Currie", Australia_Eastern },
            { "America/Cancun", America_Central },
            { "Asia/Seoul", Korea },
            { "Antarctica/McMurdo", New_Zealand },
            { "Europe/Rome", Europe_Central },
            { "Atlantic/Stanley", Falkland },
            { "America/Dawson_Creek", America_Mountain },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Anadyr", Magadan },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Hermosillo", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/Boise", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "Europe/Guernsey", GMT },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Iqaluit", America_Eastern },
            { "America/Araguaina", Brasilia },
            { "America/St_Lucia", Atlantic },
            { "Pacific/Kiritimati", Line_Islands },
            { "Asia/Yakutsk", Yakutsk },
            { "Indian/Mahe", Seychelles },
            { "America/Panama", America_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "Africa/Freetown", GMT },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "Australia/Lindeman", Australia_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "Australia/Perth", Australia_Western },
            { "America/Edmonton", America_Mountain },
            { "Antarctica/Syowa", Syowa },
            { "America/Creston", America_Mountain },
            { "Africa/Nouakchott", GMT },
            { "America/Noronha", Noronha },
            { "America/Dominica", Atlantic },
            { "Asia/Saigon", Indochina },
            { "Antarctica/Macquarie", Macquarie },
            { "MST7MDT", America_Mountain },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Luanda", Africa_Western },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Guadeloupe", Atlantic },
            { "Africa/Bangui", Africa_Western },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/Eirunepe", Amazon },
            { "Africa/Lubumbashi", Africa_Central },
            { "Pacific/Galapagos", Galapagos },
            { "America/Monterrey", America_Central },
            { "Europe/London", GMT },
            { "Europe/Samara", Moscow },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "Indian/Christmas", Christmas },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "America/Yakutat", Alaska },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Asia/Qatar", Arabian },
            { "Africa/Gaborone", Africa_Central },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Zurich", Europe_Central },
            { "America/Winnipeg", America_Central },
            { "America/Santarem", Brasilia },
            { "Asia/Macau", China },
            { "Europe/Dublin", GMT },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Tijuana", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "Africa/Windhoek", Africa_Western },
            { "America/Cayman", America_Eastern },
            { "Antarctica/Davis", Davis },
            { "Europe/Berlin", Europe_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Omsk", Omsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "Asia/Choibalsan", Choibalsan },
            { "Europe/Jersey", GMT },
            { "Europe/Prague", Europe_Central },
            { "Africa/Harare", Africa_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "Africa/Sao_Tome", GMT },
            { "Asia/Pyongyang", Korea },
            { "America/Porto_Velho", Amazon },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "Asia/Kashgar", China },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Port_of_Spain", Atlantic },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Managua", America_Central },
            { "EST5EDT", America_Eastern },
            { "America/Nome", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Rio_Branco", Amazon },
            { "Europe/Podgorica", Europe_Central },
            { "America/Vancouver", America_Pacific },
            { "Asia/Bahrain", Arabian },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Guatemala", America_Central },
            { "Europe/Oslo", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Harbin", China },
            { "Africa/Johannesburg", Africa_Southern },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Ojinaga", America_Mountain },
            { "America/Barbados", Atlantic },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Asia/Urumqi", China },
            { "America/Louisville", America_Eastern },
            { "Asia/Gaza", Europe_Eastern },
            { "Atlantic/Azores", Azores },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Africa/Accra", GMT },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Juba", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "America/Jamaica", America_Eastern },
            { "Indian/Maldives", Maldives },
            { "Africa/Abidjan", GMT },
            { "Europe/Malta", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Europe/Madrid", Europe_Central },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Magadan", Magadan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Banjul", GMT },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Jujuy", Argentina },
            { "America/Buenos_Aires", Argentina },
            { "Asia/Calcutta", India },
            { "America/Puerto_Rico", Atlantic },
            { "Europe/Athens", Europe_Eastern },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "Pacific/Gambier", Gambier },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "Pacific/Easter", Easter },
            { "America/Menominee", America_Central },
            { "America/Juneau", Alaska },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "Africa/Conakry", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Africa/Libreville", Africa_Western },
            { "Pacific/Kosrae", Kosrae },
            { "America/St_Thomas", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "America/Shiprock", America_Mountain },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Europe/Riga", Europe_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Kigali", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Antarctica/Mawson", Mawson },
            { "America/Goose_Bay", Atlantic },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "Asia/Chongqing", China },
            { "Pacific/Fiji", Fiji },
            { "Australia/Darwin", Australia_Central },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Asia/Riyadh", Arabian },
            { "Asia/Aden", Arabian },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Africa/Lome", GMT },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
