# -*- python -*-

# This software was produced by NIST, an agency of the U.S. government,
# and by statute is not subject to copyright in the United States.
# Recipients of this software assume all responsibilities associated
# with its operation, modification and maintenance. However, to
# facilitate maintenance we ask that before distributing modified
# versions of this software, you first contact the authors at
# oof_manager@nist.gov. 

from gi.repository import Gtk
import widgetlogger

class FileChooserLogger(widgetlogger.WidgetLogger):
    classes = (Gtk.FileChooserWidget, Gtk.FileChooserDialog)
    # Although FileChooserDialog is listed here, it's not really
    # loggable because it doesn't use gtklogger.Dialog as a base
    # class.
    def record(self, obj, signal, *args):
        if signal == "selection-changed":
            filename = obj.get_filename() or ""
            return ["%s.set_filename('%s')" % (self.location(obj, *args),
                                               filename)]
        return super(FileChooserLogger, self).record(obj, signal, *args)
