## Copyright (C) 2012, 2020, 2024 Moreno Marzolla
##
## This file is part of the queueing toolbox.
##
## The queueing toolbox is free software: you can redistribute it and/or
## modify it under the terms of the GNU General Public License as
## published by the Free Software Foundation, either version 3 of the
## License, or (at your option) any later version.
##
## The queueing toolbox is distributed in the hope that it will be
## useful, but WITHOUT ANY WARRANTY; without even the implied warranty
## of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with the queueing toolbox. If not, see <http://www.gnu.org/licenses/>.

1; # not a function file

if ( nargin != 2 )
  usage("proc.m [file] [path]");
endif

file = argv(){1};
path = argv(){2};

##############################################################################
function dump_help(func)
  text = get_help_text(func);
  !isempty(text) || ...
    error("Help text for %s not found", func);

  ## from __makeinfo__.m in Octave

  ## Formatting in m-files has an extra space at the beginning of
  ## every line. Remove these unwanted spaces if present.  First
  ## text char is "\n" delim.
  text = strrep (text, "\n ", "\n");

  ## Texinfo crashes if @end tex does not appear first on the line.
  text = regexprep (text, '^ +@end tex', '@end tex', 'lineanchors');

  ## We use a custom "@seealso" macro that can not be redefined.
  ## Hence we created a new "@xseealso" macro that must be used
  ## whenever "@seealso" is encountered.
  text = strrep(text, "@seealso", "@xseealso");

  printf("@anchor{doc-%s}\n%s\n", func, text);
endfunction

##############################################################################
function dump_demo( func, n )
  [code, idx] = test (func, "grabdemo" );
  (n < length(idx)) || ...
      error("Demo not found");
  printf("@verbatim\n%s\n@end verbatim\n",code(idx(n)+1:idx(n+1)-1));
endfunction

##############################################################################
fid = fopen(file,"r");
(fid > 0) || error("Cannot open %s",file);

printf("@c This file has been automatically generated from %s\n\
@c by proc.m. Do not edit this file, all changes will be lost\n\n",file);

while !feof(fid)
  line = fgetl(fid);
  t = regexp(line,'@GETHELP{\s*(\S+)\s*}',"tokens");
  if ( length(t) > 0 )
    dump_help(t{1}{1});
  else
    t = regexp(line,'@GETDEMO{\s*(\S+)\s*,\s*(\d+)\s*}',"tokens");
    if ( length(t) > 0 )
      dump_demo(t{1}{1},str2num(t{1}{2}));
    else
      printf("%s\n",line);
    endif
  endif
endwhile

fclose(fid);
