function GetOciTopLevelCommand_devops() {
    return 'devops'
}

function GetOciSubcommands_devops() {
    $ociSubcommands = @{
        'devops' = 'build-pipeline build-pipeline-stage build-run connection deploy-artifact deploy-environment deploy-pipeline deploy-stage deployment project repository repository-path-summary trigger work-request work-request-error work-request-log'
        'devops build-pipeline' = 'create delete get list update'
        'devops build-pipeline-stage' = 'create-build-stage create-deliver-artifact-stage create-trigger-deployment-stage create-wait-stage delete get list update-build-stage update-deliver-artifact-stage update-trigger-deployment-stage update-wait-stage'
        'devops build-run' = 'cancel create get list update'
        'devops connection' = 'create-bitbucket-cloud-connection create-bitbucket-server-connection create-github-connection create-gitlab-connection create-gitlab-server-connection create-vbs-connection delete get list update-bitbucket-cloud-connection update-bitbucket-server-connection update-github-connection update-gitlab-connection update-gitlab-server-connection update-vbs-connection validate'
        'devops deploy-artifact' = 'create-generic-artifact create-helm-repository-artifact create-inline-artifact create-ocir-artifact delete get list update update-generic-artifact update-helm-repository-artifact update-inline-artifact update-ocir-artifact'
        'devops deploy-environment' = 'create-compute-instance-environment create-function-environment create-oke-cluster-environment delete get list update update-compute-instance-environment update-function-environment update-oke-cluster-environment'
        'devops deploy-pipeline' = 'create delete get list update'
        'devops deploy-stage' = 'create-compute-instance-group-blue-green-traffic-shift-stage create-compute-instance-group-canary-approval-stage create-compute-instance-group-canary-traffic-shift-stage create-deploy-compute-instance-group-blue-green-stage create-deploy-compute-instance-group-canary-stage create-deploy-compute-instance-group-stage create-deploy-function-stage create-deploy-oke-blue-green-stage create-deploy-oke-canary-stage create-deploy-oke-stage create-invoke-function-stage create-load-balancer-traffic-shift-stage create-manual-approval-stage create-oke-blue-green-traffic-shift-stage create-oke-canary-approval-stage create-oke-canary-traffic-shift-stage create-oke-helm-chart-stage create-shell-stage create-wait-stage delete get list update update-compute-instance-group-blue-green-traffic-shift-stage update-compute-instance-group-canary-approval-stage update-compute-instance-group-canary-traffic-shift-stage update-deploy-compute-instance-group-blue-green-stage update-deploy-compute-instance-group-canary-stage update-deploy-compute-instance-group-stage update-deploy-function-stage update-deploy-oke-blue-green-stage update-deploy-oke-canary-stage update-deploy-oke-stage update-invoke-function-stage update-load-balancer-traffic-shift-stage update-manual-approval-stage update-oke-blue-green-traffic-shift-stage update-oke-canary-approval-stage update-oke-canary-traffic-shift-stage update-oke-helm-chart-stage update-shell-stage update-wait-stage'
        'devops deployment' = 'approve cancel create-pipeline-deployment create-pipeline-redeployment create-single-stage-deployment create-single-stage-redeployment get list update update-single-stage-redeployment'
        'devops project' = 'cancel-cascading-delete change-compartment create delete get list schedule-cascading-delete update'
        'devops repository' = 'create delete delete-ref get get-commit get-commit-diff get-file-diff get-mirror-record get-object get-object-content get-ref get-repo-file-diff get-repo-file-lines get-repository-archive-content get-repository-file-lines list list-authors list-commit-diffs list-commits list-mirror-records list-refs mirror put-repository-ref-branch-details put-repository-ref-tag-details update'
        'devops repository-path-summary' = 'list-paths'
        'devops trigger' = 'create-bitbucket-cloud-trigger create-bitbucket-server-trigger create-devops-code-repo-trigger create-github-trigger create-gitlab-server-trigger create-gitlab-trigger create-vbs-trigger delete get list update-bitbucket-cloud-trigger update-bitbucket-server-trigger update-devops-code-repo-trigger update-github-trigger update-gitlab-server-trigger update-gitlab-trigger update-vbs-trigger'
        'devops work-request' = 'get list'
        'devops work-request-error' = 'list'
        'devops work-request-log' = 'list'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_devops() {
    $ociCommandsToLongParams = @{
        'devops build-pipeline create' = 'build-pipeline-parameters defined-tags description display-name freeform-tags from-json help max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops build-pipeline delete' = 'build-pipeline-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops build-pipeline get' = 'build-pipeline-id from-json help'
        'devops build-pipeline list' = 'all compartment-id display-name from-json help id lifecycle-state limit page page-size project-id sort-by sort-order'
        'devops build-pipeline update' = 'build-pipeline-id build-pipeline-parameters defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops build-pipeline-stage create-build-stage' = 'build-pipeline-id build-runner-config build-source-collection build-spec-file defined-tags description display-name freeform-tags from-json help image max-wait-seconds network-channel primary-build-source stage-execution-timeout-in-seconds stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops build-pipeline-stage create-deliver-artifact-stage' = 'build-pipeline-id defined-tags deliver-artifact-collection description display-name freeform-tags from-json help max-wait-seconds stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops build-pipeline-stage create-trigger-deployment-stage' = 'build-pipeline-id defined-tags deploy-pipeline-id description display-name freeform-tags from-json help is-pass-all-parameters-enabled max-wait-seconds stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops build-pipeline-stage create-wait-stage' = 'build-pipeline-id defined-tags description display-name freeform-tags from-json help max-wait-seconds stage-predecessor-collection wait-criteria wait-for-state wait-interval-seconds'
        'devops build-pipeline-stage delete' = 'force from-json help if-match max-wait-seconds stage-id wait-for-state wait-interval-seconds'
        'devops build-pipeline-stage get' = 'from-json help stage-id'
        'devops build-pipeline-stage list' = 'all build-pipeline-id compartment-id display-name from-json help id lifecycle-state limit page page-size sort-by sort-order'
        'devops build-pipeline-stage update-build-stage' = 'build-runner-config build-source-collection build-spec-file defined-tags description display-name force freeform-tags from-json help if-match image max-wait-seconds network-channel primary-build-source stage-execution-timeout-in-seconds stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops build-pipeline-stage update-deliver-artifact-stage' = 'defined-tags deliver-artifact-collection description display-name force freeform-tags from-json help if-match max-wait-seconds stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops build-pipeline-stage update-trigger-deployment-stage' = 'defined-tags deploy-pipeline-id description display-name force freeform-tags from-json help if-match is-pass-all-parameters-enabled max-wait-seconds stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops build-pipeline-stage update-wait-stage' = 'defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds stage-id stage-predecessor-collection wait-criteria wait-for-state wait-interval-seconds'
        'devops build-run cancel' = 'build-run-id from-json help if-match max-wait-seconds reason wait-for-state wait-interval-seconds'
        'devops build-run create' = 'build-pipeline-id build-run-arguments commit-info defined-tags display-name freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops build-run get' = 'build-run-id from-json help'
        'devops build-run list' = 'all build-pipeline-id compartment-id display-name from-json help id lifecycle-state limit page page-size project-id sort-by sort-order'
        'devops build-run update' = 'build-run-id defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops connection create-bitbucket-cloud-connection' = 'app-password bitbucket-cloud-username defined-tags description display-name freeform-tags from-json help max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops connection create-bitbucket-server-connection' = 'base-url defined-tags description display-name freeform-tags from-json help max-wait-seconds personal-access-token project-id tls-verify-config wait-for-state wait-interval-seconds'
        'devops connection create-github-connection' = 'defined-tags description display-name freeform-tags from-json help max-wait-seconds personal-access-token project-id wait-for-state wait-interval-seconds'
        'devops connection create-gitlab-connection' = 'defined-tags description display-name freeform-tags from-json help max-wait-seconds personal-access-token project-id wait-for-state wait-interval-seconds'
        'devops connection create-gitlab-server-connection' = 'base-url defined-tags description display-name freeform-tags from-json help max-wait-seconds personal-access-token project-id tls-verify-config wait-for-state wait-interval-seconds'
        'devops connection create-vbs-connection' = 'access-token base-url defined-tags description display-name freeform-tags from-json help max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops connection delete' = 'connection-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops connection get' = 'connection-id from-json help'
        'devops connection list' = 'all compartment-id connection-type display-name from-json help id lifecycle-state limit page page-size project-id sort-by sort-order'
        'devops connection update-bitbucket-cloud-connection' = 'app-password bitbucket-cloud-username connection-id defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops connection update-bitbucket-server-connection' = 'base-url connection-id defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds personal-access-token tls-verify-config wait-for-state wait-interval-seconds'
        'devops connection update-github-connection' = 'connection-id defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds personal-access-token wait-for-state wait-interval-seconds'
        'devops connection update-gitlab-connection' = 'connection-id defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds personal-access-token wait-for-state wait-interval-seconds'
        'devops connection update-gitlab-server-connection' = 'base-url connection-id defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds personal-access-token tls-verify-config wait-for-state wait-interval-seconds'
        'devops connection update-vbs-connection' = 'access-token base-url connection-id defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops connection validate' = 'connection-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops deploy-artifact create-generic-artifact' = 'argument-substitution-mode artifact-path artifact-type artifact-version defined-tags description display-name freeform-tags from-json help max-wait-seconds project-id repository-id wait-for-state wait-interval-seconds'
        'devops deploy-artifact create-helm-repository-artifact' = 'argument-substitution-mode artifact-chart-url artifact-type artifact-version defined-tags description display-name freeform-tags from-json helm-verification-key-source help max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops deploy-artifact create-inline-artifact' = 'argument-substitution-mode artifact-type base64-encoded-content defined-tags description display-name freeform-tags from-json help max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops deploy-artifact create-ocir-artifact' = 'argument-substitution-mode artifact-type defined-tags description display-name freeform-tags from-json help image-digest max-wait-seconds project-id source-image-uri wait-for-state wait-interval-seconds'
        'devops deploy-artifact delete' = 'artifact-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops deploy-artifact get' = 'artifact-id from-json help'
        'devops deploy-artifact list' = 'all compartment-id display-name from-json help id lifecycle-state limit page page-size project-id sort-by sort-order'
        'devops deploy-artifact update' = 'argument-substitution-mode artifact-id artifact-type defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops deploy-artifact update-generic-artifact' = 'argument-substitution-mode artifact-id artifact-path artifact-type artifact-version defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds repository-id wait-for-state wait-interval-seconds'
        'devops deploy-artifact update-helm-repository-artifact' = 'argument-substitution-mode artifact-chart-url artifact-id artifact-version defined-tags deploy-artifact-type description display-name force freeform-tags from-json helm-verification-key-source help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops deploy-artifact update-inline-artifact' = 'argument-substitution-mode artifact-id artifact-type base64-encoded-content defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops deploy-artifact update-ocir-artifact' = 'argument-substitution-mode artifact-id defined-tags description display-name force freeform-tags from-json help if-match image-digest max-wait-seconds source-image-uri wait-for-state wait-interval-seconds'
        'devops deploy-environment create-compute-instance-environment' = 'compute-instance-group-selectors defined-tags description display-name freeform-tags from-json help max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops deploy-environment create-function-environment' = 'defined-tags description display-name freeform-tags from-json function-id help max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops deploy-environment create-oke-cluster-environment' = 'cluster-id defined-tags description display-name freeform-tags from-json help max-wait-seconds network-channel project-id wait-for-state wait-interval-seconds'
        'devops deploy-environment delete' = 'environment-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops deploy-environment get' = 'environment-id from-json help'
        'devops deploy-environment list' = 'all compartment-id display-name from-json help id lifecycle-state limit page page-size project-id sort-by sort-order'
        'devops deploy-environment update' = 'defined-tags description display-name environment-id force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops deploy-environment update-compute-instance-environment' = 'compute-instance-group-selectors defined-tags description display-name environment-id force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops deploy-environment update-function-environment' = 'defined-tags description display-name environment-id force freeform-tags from-json function-id help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops deploy-environment update-oke-cluster-environment' = 'cluster-id defined-tags description display-name environment-id force freeform-tags from-json help if-match max-wait-seconds network-channel wait-for-state wait-interval-seconds'
        'devops deploy-pipeline create' = 'defined-tags description display-name freeform-tags from-json help max-wait-seconds pipeline-parameters project-id wait-for-state wait-interval-seconds'
        'devops deploy-pipeline delete' = 'force from-json help if-match max-wait-seconds pipeline-id wait-for-state wait-interval-seconds'
        'devops deploy-pipeline get' = 'from-json help pipeline-id'
        'devops deploy-pipeline list' = 'all compartment-id display-name from-json help id lifecycle-state limit page page-size project-id sort-by sort-order'
        'devops deploy-pipeline update' = 'defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds pipeline-id pipeline-parameters wait-for-state wait-interval-seconds'
        'devops deploy-stage create-compute-instance-group-blue-green-traffic-shift-stage' = 'compute-instance-group-blue-green-stage-id defined-tags description display-name freeform-tags from-json help max-wait-seconds pipeline-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage create-compute-instance-group-canary-approval-stage' = 'approval-policy compute-instance-group-canary-traffic-shift-stage-id defined-tags description display-name freeform-tags from-json help max-wait-seconds pipeline-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage create-compute-instance-group-canary-traffic-shift-stage' = 'compute-instance-group-canary-stage-id defined-tags description display-name freeform-tags from-json help max-wait-seconds pipeline-id rollout-policy stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage create-deploy-compute-instance-group-blue-green-stage' = 'artifact-ids defined-tags deployment-spec-artifact-id description display-name environment-id-a environment-id-b failure-policy freeform-tags from-json help max-wait-seconds pipeline-id production-load-balancer-config rollout-policy stage-predecessor-collection test-load-balancer-config wait-for-state wait-interval-seconds'
        'devops deploy-stage create-deploy-compute-instance-group-canary-stage' = 'artifact-ids compute-instance-group-environment-id defined-tags deployment-spec-artifact-id description display-name freeform-tags from-json help max-wait-seconds pipeline-id production-load-balancer-config rollout-policy stage-predecessor-collection test-load-balancer-config wait-for-state wait-interval-seconds'
        'devops deploy-stage create-deploy-compute-instance-group-stage' = 'artifact-ids compute-instance-group-environment-id defined-tags deployment-spec-artifact-id description display-name failure-policy freeform-tags from-json help load-balancer-config max-wait-seconds pipeline-id rollback-policy rollout-policy stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage create-deploy-function-stage' = 'config defined-tags description display-name docker-image-artifact-id freeform-tags from-json function-environment-id function-timeout-in-seconds help max-memory-in-mbs max-wait-seconds pipeline-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage create-deploy-oke-blue-green-stage' = 'blue-green-strategy defined-tags description display-name freeform-tags from-json help kubernetes-manifest-artifact-ids max-wait-seconds oke-cluster-environment-id pipeline-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage create-deploy-oke-canary-stage' = 'canary-strategy defined-tags description display-name freeform-tags from-json help kubernetes-manifest-artifact-ids max-wait-seconds oke-cluster-environment-id pipeline-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage create-deploy-oke-stage' = 'defined-tags description display-name freeform-tags from-json help kubernetes-manifest-artifact-ids max-wait-seconds namespace oke-cluster-environment-id pipeline-id rollback-policy stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage create-invoke-function-stage' = 'artifact-id defined-tags description display-name freeform-tags from-json function-environment-id help is-async is-validation-enabled max-wait-seconds pipeline-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage create-load-balancer-traffic-shift-stage' = 'blue-backend-ips defined-tags description display-name freeform-tags from-json green-backend-ips help load-balancer-config max-wait-seconds pipeline-id rollback-policy rollout-policy stage-predecessor-collection traffic-shift-target wait-for-state wait-interval-seconds'
        'devops deploy-stage create-manual-approval-stage' = 'approval-policy defined-tags description display-name freeform-tags from-json help max-wait-seconds pipeline-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage create-oke-blue-green-traffic-shift-stage' = 'defined-tags description display-name freeform-tags from-json help max-wait-seconds oke-blue-green-stage-id pipeline-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage create-oke-canary-approval-stage' = 'approval-policy defined-tags description display-name freeform-tags from-json help max-wait-seconds oke-canary-traffic-shift-stage-id pipeline-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage create-oke-canary-traffic-shift-stage' = 'defined-tags description display-name freeform-tags from-json help max-wait-seconds oke-canary-stage-id pipeline-id rollout-policy stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage create-oke-helm-chart-stage' = 'cleanup-on-fail debug-helm defined-tags description display-name force-helm freeform-tags from-json helm-chart-artifact-id help history-max max-wait-seconds namespace no-hooks oke-cluster-environment-id pipeline-id release-name render-subchart-notes reset-values reuse-values rollback-policy set-string set-values skip-crds stage-predecessor-collection timeout-in-seconds values-artifact-ids wait-for-state wait-helm wait-interval-seconds'
        'devops deploy-stage create-shell-stage' = 'command-spec-artifact-id container-config defined-tags description display-name freeform-tags from-json help max-wait-seconds pipeline-id stage-predecessor-collection timeout-in-seconds wait-for-state wait-interval-seconds'
        'devops deploy-stage create-wait-stage' = 'defined-tags description display-name freeform-tags from-json help max-wait-seconds pipeline-id stage-predecessor-collection wait-criteria wait-for-state wait-interval-seconds'
        'devops deploy-stage delete' = 'force from-json help if-match max-wait-seconds stage-id wait-for-state wait-interval-seconds'
        'devops deploy-stage get' = 'from-json help stage-id'
        'devops deploy-stage list' = 'all compartment-id display-name from-json help id lifecycle-state limit page page-size pipeline-id sort-by sort-order'
        'devops deploy-stage update' = 'defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage update-compute-instance-group-blue-green-traffic-shift-stage' = 'defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage update-compute-instance-group-canary-approval-stage' = 'approval-policy defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage update-compute-instance-group-canary-traffic-shift-stage' = 'defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds rollout-policy stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage update-deploy-compute-instance-group-blue-green-stage' = 'artifact-ids defined-tags deployment-spec-artifact-id description display-name failure-policy force freeform-tags from-json help if-match max-wait-seconds rollout-policy stage-id stage-predecessor-collection test-load-balancer-config wait-for-state wait-interval-seconds'
        'devops deploy-stage update-deploy-compute-instance-group-canary-stage' = 'artifact-ids defined-tags deployment-spec-artifact-id description display-name force freeform-tags from-json help if-match max-wait-seconds rollout-policy stage-id stage-predecessor-collection test-load-balancer-config wait-for-state wait-interval-seconds'
        'devops deploy-stage update-deploy-compute-instance-group-stage' = 'artifact-ids compute-instance-group-environment-id defined-tags deployment-spec-artifact-id description display-name failure-policy force freeform-tags from-json help if-match load-balancer-config max-wait-seconds rollback-policy rollout-policy stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage update-deploy-function-stage' = 'config defined-tags description display-name docker-image-artifact-id force freeform-tags from-json function-environment-id function-timeout-in-seconds help if-match max-memory-in-mbs max-wait-seconds stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage update-deploy-oke-blue-green-stage' = 'defined-tags description display-name force freeform-tags from-json help if-match kubernetes-manifest-artifact-ids max-wait-seconds stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage update-deploy-oke-canary-stage' = 'defined-tags description display-name force freeform-tags from-json help if-match kubernetes-manifest-artifact-ids max-wait-seconds stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage update-deploy-oke-stage' = 'defined-tags description display-name force freeform-tags from-json help if-match kubernetes-manifest-artifact-ids max-wait-seconds namespace oke-cluster-environment-id rollback-policy stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage update-invoke-function-stage' = 'artifact-id defined-tags description display-name force freeform-tags from-json function-environment-id help if-match is-async is-validation-enabled max-wait-seconds stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage update-load-balancer-traffic-shift-stage' = 'blue-backend-ips defined-tags description display-name force freeform-tags from-json green-backend-ips help if-match load-balancer-config max-wait-seconds rollback-policy rollout-policy stage-id stage-predecessor-collection traffic-shift-target wait-for-state wait-interval-seconds'
        'devops deploy-stage update-manual-approval-stage' = 'approval-policy defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage update-oke-blue-green-traffic-shift-stage' = 'defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage update-oke-canary-approval-stage' = 'approval-policy defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage update-oke-canary-traffic-shift-stage' = 'defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds rollout-policy stage-id stage-predecessor-collection wait-for-state wait-interval-seconds'
        'devops deploy-stage update-oke-helm-chart-stage' = 'cleanup-on-fail debug-helm defined-tags description display-name force force-helm freeform-tags from-json helm-chart-artifact-id help history-max if-match max-wait-seconds namespace no-hooks oke-cluster-environment-id release-name render-subchart-notes reset-values reuse-values rollback-policy set-string set-values skip-crds stage-id stage-predecessor-collection timeout-in-seconds values-artifact-ids wait-for-state wait-helm wait-interval-seconds'
        'devops deploy-stage update-shell-stage' = 'command-spec-artifact-id container-config defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds stage-id stage-predecessor-collection timeout-in-seconds wait-for-state wait-interval-seconds'
        'devops deploy-stage update-wait-stage' = 'defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds stage-id stage-predecessor-collection wait-criteria wait-for-state wait-interval-seconds'
        'devops deployment approve' = 'action deployment-id from-json help if-match max-wait-seconds reason stage-id wait-for-state wait-interval-seconds'
        'devops deployment cancel' = 'deployment-id from-json help if-match max-wait-seconds reason wait-for-state wait-interval-seconds'
        'devops deployment create-pipeline-deployment' = 'artifact-override-arguments defined-tags deployment-arguments display-name dry-run freeform-tags from-json help max-wait-seconds pipeline-id stage-override-arguments wait-for-state wait-interval-seconds'
        'devops deployment create-pipeline-redeployment' = 'defined-tags deployment-id display-name freeform-tags from-json help max-wait-seconds previous-deployment-id wait-for-state wait-interval-seconds'
        'devops deployment create-single-stage-deployment' = 'artifact-override-arguments defined-tags deployment-arguments display-name dry-run freeform-tags from-json help max-wait-seconds pipeline-id stage-id stage-override-arguments wait-for-state wait-interval-seconds'
        'devops deployment create-single-stage-redeployment' = 'defined-tags display-name freeform-tags from-json help max-wait-seconds pipeline-id previous-deployment-id stage-id wait-for-state wait-interval-seconds'
        'devops deployment get' = 'deployment-id from-json help'
        'devops deployment list' = 'all compartment-id display-name from-json help id lifecycle-state limit page page-size pipeline-id project-id sort-by sort-order time-created-greater-than-or-equal-to time-created-less-than'
        'devops deployment update' = 'defined-tags deployment-id display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops deployment update-single-stage-redeployment' = 'defined-tags deployment-id display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'devops project cancel-cascading-delete' = 'from-json help if-match max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops project change-compartment' = 'compartment-id from-json help if-match max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops project create' = 'compartment-id defined-tags description freeform-tags from-json help max-wait-seconds name notification-config wait-for-state wait-interval-seconds'
        'devops project delete' = 'force from-json help if-match max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops project get' = 'from-json help project-id'
        'devops project list' = 'all compartment-id from-json help id lifecycle-state limit name page page-size sort-by sort-order'
        'devops project schedule-cascading-delete' = 'from-json help if-match max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops project update' = 'defined-tags description force freeform-tags from-json help if-match max-wait-seconds notification-config project-id wait-for-state wait-interval-seconds'
        'devops repository create' = 'default-branch defined-tags description freeform-tags from-json help max-wait-seconds mirror-repository-config name project-id repository-type wait-for-state wait-interval-seconds'
        'devops repository delete' = 'force from-json help if-match max-wait-seconds repository-id wait-for-state wait-interval-seconds'
        'devops repository delete-ref' = 'force from-json help if-match max-wait-seconds ref-name repository-id wait-for-state wait-interval-seconds'
        'devops repository get' = 'fields from-json help repository-id'
        'devops repository get-commit' = 'commit-id from-json help repository-id'
        'devops repository get-commit-diff' = 'base-version from-json help is-comparison-from-merge-base repository-id target-version'
        'devops repository get-file-diff' = 'base-version file-path from-json help is-comparison-from-merge-base repository-id target-version'
        'devops repository get-mirror-record' = 'from-json help mirror-record-type repository-id'
        'devops repository get-object' = 'file-path from-json help ref-name repository-id'
        'devops repository get-object-content' = 'file file-path from-json help repository-id sha'
        'devops repository get-ref' = 'from-json help ref-name repository-id'
        'devops repository get-repo-file-diff' = 'base-version file-path from-json help is-comparison-from-merge-base repository-id target-version'
        'devops repository get-repo-file-lines' = 'file-path from-json help limit repository-id revision start-line-number'
        'devops repository get-repository-archive-content' = 'file format from-json help ref-name repository-id'
        'devops repository get-repository-file-lines' = 'file-path from-json help limit repository-id revision start-line-number'
        'devops repository list' = 'all compartment-id from-json help lifecycle-state limit name page page-size project-id repository-id sort-by sort-order'
        'devops repository list-authors' = 'all from-json help limit page page-size ref-name repository-id sort-order'
        'devops repository list-commit-diffs' = 'all base-version from-json help is-comparison-from-merge-base limit page page-size repository-id target-version'
        'devops repository list-commits' = 'all author-name commit-message exclude-ref-name file-path from-json help limit page page-size ref-name repository-id timestamp-greater-than-or-equal-to timestamp-less-than-or-equal-to'
        'devops repository list-mirror-records' = 'all from-json help limit page page-size repository-id sort-order'
        'devops repository list-refs' = 'all commit-id from-json help limit page page-size ref-name ref-type repository-id sort-by sort-order'
        'devops repository mirror' = 'from-json help if-match max-wait-seconds repository-id wait-for-state wait-interval-seconds'
        'devops repository put-repository-ref-branch-details' = 'commit-id from-json help if-match max-wait-seconds ref-name repository-id wait-for-state wait-interval-seconds'
        'devops repository put-repository-ref-tag-details' = 'from-json help if-match max-wait-seconds object-id ref-name repository-id wait-for-state wait-interval-seconds'
        'devops repository update' = 'default-branch defined-tags description force freeform-tags from-json help if-match max-wait-seconds mirror-repository-config name repository-id repository-type wait-for-state wait-interval-seconds'
        'devops repository-path-summary list-paths' = 'all display-name folder-path from-json help limit page page-size paths-in-subtree ref repository-id sort-by sort-order'
        'devops trigger create-bitbucket-cloud-trigger' = 'actions connection-id defined-tags description display-name freeform-tags from-json help max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops trigger create-bitbucket-server-trigger' = 'actions defined-tags description display-name freeform-tags from-json help max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops trigger create-devops-code-repo-trigger' = 'actions defined-tags description display-name freeform-tags from-json help max-wait-seconds project-id repository-id wait-for-state wait-interval-seconds'
        'devops trigger create-github-trigger' = 'actions connection-id defined-tags description display-name freeform-tags from-json help max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops trigger create-gitlab-server-trigger' = 'actions defined-tags description display-name freeform-tags from-json help max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops trigger create-gitlab-trigger' = 'actions connection-id defined-tags description display-name freeform-tags from-json help max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops trigger create-vbs-trigger' = 'actions connection-id defined-tags description display-name freeform-tags from-json help max-wait-seconds project-id wait-for-state wait-interval-seconds'
        'devops trigger delete' = 'force from-json help if-match max-wait-seconds trigger-id wait-for-state wait-interval-seconds'
        'devops trigger get' = 'from-json help trigger-id'
        'devops trigger list' = 'all compartment-id display-name from-json help id lifecycle-state limit page page-size project-id sort-by sort-order'
        'devops trigger update-bitbucket-cloud-trigger' = 'actions connection-id defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds trigger-id wait-for-state wait-interval-seconds'
        'devops trigger update-bitbucket-server-trigger' = 'actions defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds trigger-id wait-for-state wait-interval-seconds'
        'devops trigger update-devops-code-repo-trigger' = 'actions defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds repository-id trigger-id wait-for-state wait-interval-seconds'
        'devops trigger update-github-trigger' = 'actions connection-id defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds trigger-id wait-for-state wait-interval-seconds'
        'devops trigger update-gitlab-server-trigger' = 'actions defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds trigger-id wait-for-state wait-interval-seconds'
        'devops trigger update-gitlab-trigger' = 'actions connection-id defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds trigger-id wait-for-state wait-interval-seconds'
        'devops trigger update-vbs-trigger' = 'actions connection-id defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds trigger-id wait-for-state wait-interval-seconds'
        'devops work-request get' = 'from-json help work-request-id'
        'devops work-request list' = 'all compartment-id from-json help limit operation-type-multi-value-query page page-size resource-id sort-by sort-order status work-request-id'
        'devops work-request-error list' = 'all from-json help limit page page-size sort-by sort-order work-request-id'
        'devops work-request-log list' = 'all from-json help limit page page-size sort-by sort-order work-request-id'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_devops() {
    $ociCommandsToShortParams = @{
        'devops build-pipeline create' = '? h'
        'devops build-pipeline delete' = '? h'
        'devops build-pipeline get' = '? h'
        'devops build-pipeline list' = '? c h'
        'devops build-pipeline update' = '? h'
        'devops build-pipeline-stage create-build-stage' = '? h'
        'devops build-pipeline-stage create-deliver-artifact-stage' = '? h'
        'devops build-pipeline-stage create-trigger-deployment-stage' = '? h'
        'devops build-pipeline-stage create-wait-stage' = '? h'
        'devops build-pipeline-stage delete' = '? h'
        'devops build-pipeline-stage get' = '? h'
        'devops build-pipeline-stage list' = '? c h'
        'devops build-pipeline-stage update-build-stage' = '? h'
        'devops build-pipeline-stage update-deliver-artifact-stage' = '? h'
        'devops build-pipeline-stage update-trigger-deployment-stage' = '? h'
        'devops build-pipeline-stage update-wait-stage' = '? h'
        'devops build-run cancel' = '? h'
        'devops build-run create' = '? h'
        'devops build-run get' = '? h'
        'devops build-run list' = '? c h'
        'devops build-run update' = '? h'
        'devops connection create-bitbucket-cloud-connection' = '? h'
        'devops connection create-bitbucket-server-connection' = '? h'
        'devops connection create-github-connection' = '? h'
        'devops connection create-gitlab-connection' = '? h'
        'devops connection create-gitlab-server-connection' = '? h'
        'devops connection create-vbs-connection' = '? h'
        'devops connection delete' = '? h'
        'devops connection get' = '? h'
        'devops connection list' = '? c h'
        'devops connection update-bitbucket-cloud-connection' = '? h'
        'devops connection update-bitbucket-server-connection' = '? h'
        'devops connection update-github-connection' = '? h'
        'devops connection update-gitlab-connection' = '? h'
        'devops connection update-gitlab-server-connection' = '? h'
        'devops connection update-vbs-connection' = '? h'
        'devops connection validate' = '? h'
        'devops deploy-artifact create-generic-artifact' = '? h'
        'devops deploy-artifact create-helm-repository-artifact' = '? h'
        'devops deploy-artifact create-inline-artifact' = '? h'
        'devops deploy-artifact create-ocir-artifact' = '? h'
        'devops deploy-artifact delete' = '? h'
        'devops deploy-artifact get' = '? h'
        'devops deploy-artifact list' = '? c h'
        'devops deploy-artifact update' = '? h'
        'devops deploy-artifact update-generic-artifact' = '? h'
        'devops deploy-artifact update-helm-repository-artifact' = '? h'
        'devops deploy-artifact update-inline-artifact' = '? h'
        'devops deploy-artifact update-ocir-artifact' = '? h'
        'devops deploy-environment create-compute-instance-environment' = '? h'
        'devops deploy-environment create-function-environment' = '? h'
        'devops deploy-environment create-oke-cluster-environment' = '? h'
        'devops deploy-environment delete' = '? h'
        'devops deploy-environment get' = '? h'
        'devops deploy-environment list' = '? c h'
        'devops deploy-environment update' = '? h'
        'devops deploy-environment update-compute-instance-environment' = '? h'
        'devops deploy-environment update-function-environment' = '? h'
        'devops deploy-environment update-oke-cluster-environment' = '? h'
        'devops deploy-pipeline create' = '? h'
        'devops deploy-pipeline delete' = '? h'
        'devops deploy-pipeline get' = '? h'
        'devops deploy-pipeline list' = '? c h'
        'devops deploy-pipeline update' = '? h'
        'devops deploy-stage create-compute-instance-group-blue-green-traffic-shift-stage' = '? h'
        'devops deploy-stage create-compute-instance-group-canary-approval-stage' = '? h'
        'devops deploy-stage create-compute-instance-group-canary-traffic-shift-stage' = '? h'
        'devops deploy-stage create-deploy-compute-instance-group-blue-green-stage' = '? h'
        'devops deploy-stage create-deploy-compute-instance-group-canary-stage' = '? h'
        'devops deploy-stage create-deploy-compute-instance-group-stage' = '? h'
        'devops deploy-stage create-deploy-function-stage' = '? h'
        'devops deploy-stage create-deploy-oke-blue-green-stage' = '? h'
        'devops deploy-stage create-deploy-oke-canary-stage' = '? h'
        'devops deploy-stage create-deploy-oke-stage' = '? h'
        'devops deploy-stage create-invoke-function-stage' = '? h'
        'devops deploy-stage create-load-balancer-traffic-shift-stage' = '? h'
        'devops deploy-stage create-manual-approval-stage' = '? h'
        'devops deploy-stage create-oke-blue-green-traffic-shift-stage' = '? h'
        'devops deploy-stage create-oke-canary-approval-stage' = '? h'
        'devops deploy-stage create-oke-canary-traffic-shift-stage' = '? h'
        'devops deploy-stage create-oke-helm-chart-stage' = '? h'
        'devops deploy-stage create-shell-stage' = '? h'
        'devops deploy-stage create-wait-stage' = '? h'
        'devops deploy-stage delete' = '? h'
        'devops deploy-stage get' = '? h'
        'devops deploy-stage list' = '? c h'
        'devops deploy-stage update' = '? h'
        'devops deploy-stage update-compute-instance-group-blue-green-traffic-shift-stage' = '? h'
        'devops deploy-stage update-compute-instance-group-canary-approval-stage' = '? h'
        'devops deploy-stage update-compute-instance-group-canary-traffic-shift-stage' = '? h'
        'devops deploy-stage update-deploy-compute-instance-group-blue-green-stage' = '? h'
        'devops deploy-stage update-deploy-compute-instance-group-canary-stage' = '? h'
        'devops deploy-stage update-deploy-compute-instance-group-stage' = '? h'
        'devops deploy-stage update-deploy-function-stage' = '? h'
        'devops deploy-stage update-deploy-oke-blue-green-stage' = '? h'
        'devops deploy-stage update-deploy-oke-canary-stage' = '? h'
        'devops deploy-stage update-deploy-oke-stage' = '? h'
        'devops deploy-stage update-invoke-function-stage' = '? h'
        'devops deploy-stage update-load-balancer-traffic-shift-stage' = '? h'
        'devops deploy-stage update-manual-approval-stage' = '? h'
        'devops deploy-stage update-oke-blue-green-traffic-shift-stage' = '? h'
        'devops deploy-stage update-oke-canary-approval-stage' = '? h'
        'devops deploy-stage update-oke-canary-traffic-shift-stage' = '? h'
        'devops deploy-stage update-oke-helm-chart-stage' = '? h'
        'devops deploy-stage update-shell-stage' = '? h'
        'devops deploy-stage update-wait-stage' = '? h'
        'devops deployment approve' = '? h'
        'devops deployment cancel' = '? h'
        'devops deployment create-pipeline-deployment' = '? h'
        'devops deployment create-pipeline-redeployment' = '? h'
        'devops deployment create-single-stage-deployment' = '? h'
        'devops deployment create-single-stage-redeployment' = '? h'
        'devops deployment get' = '? h'
        'devops deployment list' = '? c h'
        'devops deployment update' = '? h'
        'devops deployment update-single-stage-redeployment' = '? h'
        'devops project cancel-cascading-delete' = '? h'
        'devops project change-compartment' = '? c h'
        'devops project create' = '? c h'
        'devops project delete' = '? h'
        'devops project get' = '? h'
        'devops project list' = '? c h'
        'devops project schedule-cascading-delete' = '? h'
        'devops project update' = '? h'
        'devops repository create' = '? h'
        'devops repository delete' = '? h'
        'devops repository delete-ref' = '? h'
        'devops repository get' = '? h'
        'devops repository get-commit' = '? h'
        'devops repository get-commit-diff' = '? h'
        'devops repository get-file-diff' = '? h'
        'devops repository get-mirror-record' = '? h'
        'devops repository get-object' = '? h'
        'devops repository get-object-content' = '? h'
        'devops repository get-ref' = '? h'
        'devops repository get-repo-file-diff' = '? h'
        'devops repository get-repo-file-lines' = '? h'
        'devops repository get-repository-archive-content' = '? h'
        'devops repository get-repository-file-lines' = '? h'
        'devops repository list' = '? c h'
        'devops repository list-authors' = '? h'
        'devops repository list-commit-diffs' = '? h'
        'devops repository list-commits' = '? h'
        'devops repository list-mirror-records' = '? h'
        'devops repository list-refs' = '? h'
        'devops repository mirror' = '? h'
        'devops repository put-repository-ref-branch-details' = '? h'
        'devops repository put-repository-ref-tag-details' = '? h'
        'devops repository update' = '? h'
        'devops repository-path-summary list-paths' = '? h'
        'devops trigger create-bitbucket-cloud-trigger' = '? h'
        'devops trigger create-bitbucket-server-trigger' = '? h'
        'devops trigger create-devops-code-repo-trigger' = '? h'
        'devops trigger create-github-trigger' = '? h'
        'devops trigger create-gitlab-server-trigger' = '? h'
        'devops trigger create-gitlab-trigger' = '? h'
        'devops trigger create-vbs-trigger' = '? h'
        'devops trigger delete' = '? h'
        'devops trigger get' = '? h'
        'devops trigger list' = '? c h'
        'devops trigger update-bitbucket-cloud-trigger' = '? h'
        'devops trigger update-bitbucket-server-trigger' = '? h'
        'devops trigger update-devops-code-repo-trigger' = '? h'
        'devops trigger update-github-trigger' = '? h'
        'devops trigger update-gitlab-server-trigger' = '? h'
        'devops trigger update-gitlab-trigger' = '? h'
        'devops trigger update-vbs-trigger' = '? h'
        'devops work-request get' = '? h'
        'devops work-request list' = '? c h'
        'devops work-request-error list' = '? h'
        'devops work-request-log list' = '? h'
    }
    return $ociCommandsToShortParams
}