/***********************************************************************************************************************
 * Copyright [2020-2022] Renesas Electronics Corporation and/or its affiliates.  All Rights Reserved.
 *
 * This software and documentation are supplied by Renesas Electronics America Inc. and may only be used with products
 * of Renesas Electronics Corp. and its affiliates ("Renesas").  No other uses are authorized.  Renesas products are
 * sold pursuant to Renesas terms and conditions of sale.  Purchasers are solely responsible for the selection and use
 * of Renesas products and Renesas assumes no liability.  No license, express or implied, to any intellectual property
 * right is granted by Renesas. This software is protected under all applicable laws, including copyright laws. Renesas
 * reserves the right to change or discontinue this software and/or this documentation. THE SOFTWARE AND DOCUMENTATION
 * IS DELIVERED TO YOU "AS IS," AND RENESAS MAKES NO REPRESENTATIONS OR WARRANTIES, AND TO THE FULLEST EXTENT
 * PERMISSIBLE UNDER APPLICABLE LAW, DISCLAIMS ALL WARRANTIES, WHETHER EXPLICITLY OR IMPLICITLY, INCLUDING WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NONINFRINGEMENT, WITH RESPECT TO THE SOFTWARE OR
 * DOCUMENTATION.  RENESAS SHALL HAVE NO LIABILITY ARISING OUT OF ANY SECURITY VULNERABILITY OR BREACH.  TO THE MAXIMUM
 * EXTENT PERMITTED BY LAW, IN NO EVENT WILL RENESAS BE LIABLE TO YOU IN CONNECTION WITH THE SOFTWARE OR DOCUMENTATION
 * (OR ANY PERSON OR ENTITY CLAIMING RIGHTS DERIVED FROM YOU) FOR ANY LOSS, DAMAGES, OR CLAIMS WHATSOEVER, INCLUDING,
 * WITHOUT LIMITATION, ANY DIRECT, CONSEQUENTIAL, SPECIAL, INDIRECT, PUNITIVE, OR INCIDENTAL DAMAGES; ANY LOST PROFITS,
 * OTHER ECONOMIC DAMAGE, PROPERTY DAMAGE, OR PERSONAL INJURY; AND EVEN IF RENESAS HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH LOSS, DAMAGES, CLAIMS OR COSTS.
 **********************************************************************************************************************/

/* Ensure Renesas MCU variation definitions are included to ensure MCU
 * specific register variations are handled correctly. */
#ifndef BSP_FEATURE_H
 #error "INTERNAL ERROR: bsp_feature.h must be included before renesas.h."
#endif

/** @addtogroup Renesas
 * @{
 */

/** @addtogroup RA
 * @{
 */

#ifndef RA_H
 #define RA_H

 #ifdef __cplusplus
extern "C" {
 #endif

 #include "cmsis_compiler.h"

/** @addtogroup Configuration_of_CMSIS
 * @{
 */

/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */
/* IRQn_Type is provided in bsp_arm_exceptions.h. Vectors generated by the FSP Configuration tool are in vector_data.h */

/** @} */ /* End of group Configuration_of_CMSIS */

/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

 #if   __ARM_ARCH_7EM__
  #define RENESAS_CORTEX_M4
 #elif __ARM_ARCH_6M__
  #define RENESAS_CORTEX_M0PLUS
 #elif __ARM_ARCH_8M_BASE__
  #define RENESAS_CORTEX_M23
 #elif __ARM_ARCH_8M_MAIN__
  #define RENESAS_CORTEX_M33
 #else
  #warning Unsupported Architecture
 #endif

/* ----------------Configuration of the Cortex-M Processor and Core Peripherals---------------- */
 #ifdef RENESAS_CORTEX_M4
  #define __MPU_PRESENT             1  /*!< MPU present or not                                                    */
  #define __NVIC_PRIO_BITS          4  /*!< Number of Bits used for Priority Levels                               */
  #define __Vendor_SysTickConfig    0  /*!< Set to 1 if different SysTick Config is used                          */
  #define __FPU_PRESENT             1  /*!< FPU present or not                                                    */
  #include "core_cm4.h"                /*!< Cortex-M4 processor and core peripherals                              */
 #elif defined(RENESAS_CORTEX_M0PLUS)
  #define __MPU_PRESENT             1  /*!< MPU present or not                                                    */
  #define __NVIC_PRIO_BITS          2  /*!< Number of Bits used for Priority Levels                               */
  #define __Vendor_SysTickConfig    0  /*!< Set to 1 if different SysTick Config is used                          */
  #define __FPU_PRESENT             0  /*!< FPU present or not                                                    */
  #define __VTOR_PRESENT            1  /*!< Vector table VTOR register available or not                           */
  #include "core_cm0plus.h"            /*!< Cortex-M0 processor and core peripherals                              */
 #elif defined(RENESAS_CORTEX_M23)
  #define __MPU_PRESENT             1  /*!< MPU present or not                                                    */
  #define __NVIC_PRIO_BITS          2  /*!< Number of Bits used for Priority Levels                               */
  #define __Vendor_SysTickConfig    0  /*!< Set to 1 if different SysTick Config is used                          */
  #define __FPU_PRESENT             0  /*!< FPU present or not                                                    */
  #define __VTOR_PRESENT            1  /*!< Vector table VTOR register available or not                           */
  #include "core_cm23.h"               /*!< Cortex-M23 processor and core peripherals                             */
 #elif defined(RENESAS_CORTEX_M33)
  #define __MPU_PRESENT             1  /*!< MPU present or not                                                    */
  #define __NVIC_PRIO_BITS          4  /*!< Number of Bits used for Priority Levels                               */
  #define __Vendor_SysTickConfig    0  /*!< Set to 1 if different SysTick Config is used                          */
  #define __FPU_PRESENT             1  /*!< FPU present or not                                                    */
  #define __VTOR_PRESENT            1  /*!< Vector table VTOR register available or not                           */
  #define __DSP_PRESENT             1  /*!< DSP present or not                                                    */
  #include "core_cm33.h"               /*!< Cortex-M33 processor and core peripherals                             */
 #endif

 #include "system.h"                   /*!< System                                                                */

 #ifndef __IM                          /*!< Fallback for older CMSIS versions                                         */
  #define __IM     __I
 #endif
 #ifndef __OM                          /*!< Fallback for older CMSIS versions                                         */
  #define __OM     __O
 #endif
 #ifndef __IOM                         /*!< Fallback for older CMSIS versions                                         */
  #define __IOM    __IO
 #endif

/* ========================================  Start of section using anonymous unions  ======================================== */
 #if defined(__CC_ARM)
  #pragma push
  #pragma anon_unions
 #elif defined(__ICCARM__)
  #pragma language=extended
 #elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
 #elif defined(__GNUC__)

/* anonymous unions are enabled by default */
 #elif defined(__TMS470__)

/* anonymous unions are enabled by default */
 #elif defined(__TASKING__)
  #pragma warning 586
 #elif defined(__CSMC__)

/* anonymous unions are enabled by default */
 #else
  #warning Not supported compiler type
 #endif

/* =========================================================================================================================== */
/* ================                              Device Specific Cluster Section                              ================ */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_clusters
 * @{
 */

/**
 * @brief R_BUS_CSa [CSa] (CS Registers)
 */
typedef struct
{
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t MOD;            /*!< (@ 0x00000002) Mode Register                                              */

        struct
        {
            __IOM uint16_t WRMOD : 1;  /*!< [0..0] Write Access Mode Select                                           */
            uint16_t             : 2;
            __IOM uint16_t EWENB : 1;  /*!< [3..3] External Wait Enable                                               */
            uint16_t             : 4;
            __IOM uint16_t PRENB : 1;  /*!< [8..8] Page Read Access Enable                                            */
            __IOM uint16_t PWENB : 1;  /*!< [9..9] Page Write Access Enable                                           */
            uint16_t             : 5;
            __IOM uint16_t PRMOD : 1;  /*!< [15..15] Page Read Access Mode Select                                     */
        } MOD_b;
    };

    union
    {
        __IOM uint32_t WCR1;             /*!< (@ 0x00000004) Wait Control Register 1                                    */

        struct
        {
            __IOM uint32_t CSPWWAIT : 3; /*!< [2..0] Page Write Cycle Wait SelectNOTE: The CSPWWAIT value
                                          *   is valid only when the PWENB bit in CSnMOD is set to 1.                   */
            uint32_t                : 5;
            __IOM uint32_t CSPRWAIT : 3; /*!< [10..8] Page Read Cycle Wait SelectNOTE: The CSPRWAIT value
                                          *   is valid only when the PRENB bit in CSnMOD is set to 1.                   */
            uint32_t               : 5;
            __IOM uint32_t CSWWAIT : 5;  /*!< [20..16] Normal Write Cycle Wait Select                                   */
            uint32_t               : 3;
            __IOM uint32_t CSRWAIT : 5;  /*!< [28..24] Normal Read Cycle Wait Select                                    */
            uint32_t               : 3;
        } WCR1_b;
    };

    union
    {
        __IOM uint32_t WCR2;           /*!< (@ 0x00000008) Wait Control Register 2                                    */

        struct
        {
            __IOM uint32_t CSROFF : 3; /*!< [2..0] Read-Access CS Extension Cycle Select                              */
            uint32_t              : 1;
            __IOM uint32_t CSWOFF : 3; /*!< [6..4] Write-Access CS Extension Cycle Select                             */
            uint32_t              : 1;
            __IOM uint32_t WDOFF  : 3; /*!< [10..8] Write Data Output Extension Cycle Select                          */
            uint32_t              : 1;
            __IOM uint32_t AWAIT  : 2; /*!< [13..12] CS Assert Wait Select                                            */
            uint32_t              : 2;
            __IOM uint32_t RDON   : 3; /*!< [18..16] RD Assert Wait Select                                            */
            uint32_t              : 1;
            __IOM uint32_t WRON   : 3; /*!< [22..20] WR Assert Wait Select                                            */
            uint32_t              : 1;
            __IOM uint32_t WDON   : 3; /*!< [26..24] Write Data Output Wait Select                                    */
            uint32_t              : 1;
            __IOM uint32_t CSON   : 3; /*!< [30..28] CS Assert Wait Select                                            */
            uint32_t              : 1;
        } WCR2_b;
    };
    __IM uint32_t RESERVED1;
} R_BUS_CSa_Type;                      /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_CSb [CSb] (CS Registers)
 */
typedef struct
{
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t CR;             /*!< (@ 0x00000002) Control Register                                           */

        struct
        {
            __IOM uint16_t EXENB : 1;  /*!< [0..0] Operation Enable                                                   */
            uint16_t             : 3;
            __IOM uint16_t BSIZE : 2;  /*!< [5..4] External Bus Width Select                                          */
            uint16_t             : 2;
            __IOM uint16_t EMODE : 1;  /*!< [8..8] Endian Mode                                                        */
            uint16_t             : 3;
            __IOM uint16_t MPXEN : 1;  /*!< [12..12] Address/Data Multiplexed I/O Interface Select                    */
            uint16_t             : 3;
        } CR_b;
    };
    __IM uint16_t RESERVED1[3];

    union
    {
        __IOM uint16_t REC;            /*!< (@ 0x0000000A) Recovery Cycle Register                                    */

        struct
        {
            __IOM uint16_t RRCV : 4;   /*!< [3..0] Read Recovery                                                      */
            uint16_t            : 4;
            __IOM uint16_t WRCV : 4;   /*!< [11..8] Write Recovery                                                    */
            uint16_t            : 4;
        } REC_b;
    };
    __IM uint16_t RESERVED2[2];
} R_BUS_CSb_Type;                      /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_SDRAM [SDRAM] (SDRAM Registers)
 */
typedef struct
{
    union
    {
        __IOM uint8_t SDCCR;           /*!< (@ 0x00000000) SDC Control Register                                       */

        struct
        {
            __IOM uint8_t EXENB : 1;   /*!< [0..0] Operation Enable                                                   */
            uint8_t             : 3;
            __IOM uint8_t BSIZE : 2;   /*!< [5..4] SDRAM Bus Width Select                                             */
            uint8_t             : 2;
        } SDCCR_b;
    };

    union
    {
        __IOM uint8_t SDCMOD;          /*!< (@ 0x00000001) SDC Mode Register                                          */

        struct
        {
            __IOM uint8_t EMODE : 1;   /*!< [0..0] Endian Mode                                                        */
            uint8_t             : 7;
        } SDCMOD_b;
    };

    union
    {
        __IOM uint8_t SDAMOD;          /*!< (@ 0x00000002) SDRAM Access Mode Register                                 */

        struct
        {
            __IOM uint8_t BE : 1;      /*!< [0..0] Continuous Access Enable                                           */
            uint8_t          : 7;
        } SDAMOD_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint32_t RESERVED1[3];

    union
    {
        __IOM uint8_t SDSELF;          /*!< (@ 0x00000010) SDRAM Self-Refresh Control Register                        */

        struct
        {
            __IOM uint8_t SFEN : 1;    /*!< [0..0] SDRAM Self-Refresh Enable                                          */
            uint8_t            : 7;
        } SDSELF_b;
    };
    __IM uint8_t  RESERVED2;
    __IM uint16_t RESERVED3;

    union
    {
        __IOM uint16_t SDRFCR;         /*!< (@ 0x00000014) SDRAM Refresh Control Register                             */

        struct
        {
            __IOM uint16_t RFC  : 12;  /*!< [11..0] Auto-Refresh Request Interval Setting                             */
            __IOM uint16_t REFW : 4;   /*!< [15..12] Auto-Refresh Cycle/ Self-Refresh Clearing Cycle Count
                                        *   Setting. ( REFW+1 Cycles )                                                */
        } SDRFCR_b;
    };

    union
    {
        __IOM uint8_t SDRFEN;          /*!< (@ 0x00000016) SDRAM Auto-Refresh Control Register                        */

        struct
        {
            __IOM uint8_t RFEN : 1;    /*!< [0..0] Auto-Refresh Operation Enable                                      */
            uint8_t            : 7;
        } SDRFEN_b;
    };
    __IM uint8_t  RESERVED4;
    __IM uint32_t RESERVED5[2];

    union
    {
        __IOM uint8_t SDICR;           /*!< (@ 0x00000020) SDRAM Initialization Sequence Control Register             */

        struct
        {
            __IOM uint8_t INIRQ : 1;   /*!< [0..0] Initialization Sequence Start                                      */
            uint8_t             : 7;
        } SDICR_b;
    };
    __IM uint8_t  RESERVED6;
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint16_t SDIR;           /*!< (@ 0x00000024) SDRAM Initialization Register                              */

        struct
        {
            __IOM uint16_t ARFI : 4;   /*!< [3..0] Initialization Auto-Refresh Interval ( PRF+3 cycles )              */
            __IOM uint16_t ARFC : 4;   /*!< [7..4] Initialization Auto-Refresh Count                                  */
            __IOM uint16_t PRC  : 3;   /*!< [10..8] Initialization Precharge Cycle Count ( PRF+3 cycles
                                        *   )                                                                         */
            uint16_t : 5;
        } SDIR_b;
    };
    __IM uint16_t RESERVED8;
    __IM uint32_t RESERVED9[6];

    union
    {
        __IOM uint8_t SDADR;           /*!< (@ 0x00000040) SDRAM Address Register                                     */

        struct
        {
            __IOM uint8_t MXC : 2;     /*!< [1..0] Address Multiplex Select                                           */
            uint8_t           : 6;
        } SDADR_b;
    };
    __IM uint8_t  RESERVED10;
    __IM uint16_t RESERVED11;

    union
    {
        __IOM uint32_t SDTR;           /*!< (@ 0x00000044) SDRAM Timing Register                                      */

        struct
        {
            __IOM uint32_t CL  : 3;    /*!< [2..0] SDRAMC Column Latency                                              */
            uint32_t           : 5;
            __IOM uint32_t WR  : 1;    /*!< [8..8] Write Recovery Interval                                            */
            __IOM uint32_t RP  : 3;    /*!< [11..9] Row Precharge Interval ( RP+1 cycles )                            */
            __IOM uint32_t RCD : 2;    /*!< [13..12] Row Column Latency ( RCD+1 cycles )                              */
            uint32_t           : 2;
            __IOM uint32_t RAS : 3;    /*!< [18..16] Row Active Interval                                              */
            uint32_t           : 13;
        } SDTR_b;
    };

    union
    {
        __IOM uint16_t SDMOD;          /*!< (@ 0x00000048) SDRAM Mode Register                                        */

        struct
        {
            __IOM uint16_t MR : 15;    /*!< [14..0] Mode Register SettingWriting to these bits: Mode register
                                        *   set command is issued.                                                    */
            uint16_t : 1;
        } SDMOD_b;
    };
    __IM uint16_t RESERVED12;
    __IM uint32_t RESERVED13;

    union
    {
        __IM uint8_t SDSR;             /*!< (@ 0x00000050) SDRAM Status Register                                      */

        struct
        {
            __IM uint8_t MRSST : 1;    /*!< [0..0] Mode Register Setting Status                                       */
            uint8_t            : 2;
            __IM uint8_t INIST : 1;    /*!< [3..3] Initialization Status                                              */
            __IM uint8_t SRFST : 1;    /*!< [4..4] Self-Refresh Transition/Recovery Status                            */
            uint8_t            : 3;
        } SDSR_b;
    };
    __IM uint8_t  RESERVED14;
    __IM uint16_t RESERVED15;
} R_BUS_SDRAM_Type;                    /*!< Size = 84 (0x54)                                                          */

/**
 * @brief R_BUS_BUSERR [BUSERR] (Bus Error Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t ADD;             /*!< (@ 0x00000000) Bus Error Address Register                                 */

        struct
        {
            __IM uint32_t BERAD : 32;  /*!< [31..0] Bus Error AddressWhen a bus error occurs, It stores
                                        *   an error address.                                                         */
        } ADD_b;
    };

    union
    {
        __IM uint8_t STAT;             /*!< (@ 0x00000004) Bus Error Status Register                                  */

        struct
        {
            __IM uint8_t ACCSTAT : 1;  /*!< [0..0] Error access statusThe status at the time of the error             */
            uint8_t              : 6;
            __IM uint8_t ERRSTAT : 1;  /*!< [7..7] Bus Error StatusWhen bus error assert, error flag occurs.          */
        } STAT_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[2];
} R_BUS_BUSERR_Type;                   /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_BUSM [BUSM] (Master Bus Control Register Array)
 */
typedef struct
{
    union
    {
        __IOM uint16_t CNT;            /*!< (@ 0x00000000) Master Bus Control Register                                */

        struct
        {
            uint16_t             : 15;
            __IOM uint16_t IERES : 1;  /*!< [15..15] Ignore Error Responses                                           */
        } CNT_b;
    };
    __IM uint16_t RESERVED;
} R_BUS_BUSM_Type;                     /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_BUS_BUSS [BUSS] (Slave Bus Control Register Array)
 */
typedef struct
{
    union
    {
        __IOM uint16_t CNT;            /*!< (@ 0x00000000) Slave Bus Control Register                                 */

        struct
        {
            uint16_t              : 4;
            __IOM uint16_t ARBMET : 2; /*!< [5..4] Arbitration MethodSpecify the priority between groups              */
            uint16_t              : 10;
        } CNT_b;
    };
    __IM uint16_t RESERVED;
} R_BUS_BUSS_Type;                     /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_CAN0_MB [MB] (Mailbox)
 */
typedef struct
{
    union
    {
        __IOM uint32_t ID;             /*!< (@ 0x00000000) Mailbox ID Register                                        */

        struct
        {
            __IOM uint32_t EID : 18;   /*!< [17..0] Extended ID                                                       */
            __IOM uint32_t SID : 11;   /*!< [28..18] Standard ID                                                      */
            uint32_t           : 1;
            __IOM uint32_t RTR : 1;    /*!< [30..30] Remote Transmission Request                                      */
            __IOM uint32_t IDE : 1;    /*!< [31..31] ID Extension                                                     */
        } ID_b;
    };

    union
    {
        __IOM uint16_t DL;             /*!< (@ 0x00000004) Mailbox DLC Register                                       */

        struct
        {
            __IOM uint16_t DLC : 4;    /*!< [3..0] Data Length Code                                                   */
            uint16_t           : 12;
        } DL_b;
    };

    union
    {
        __IOM uint8_t D[8];            /*!< (@ 0x00000006) Mailbox Data Register                                      */

        struct
        {
            __IOM uint8_t DATA : 8;    /*!< [7..0] DATA0 to DATA7 store the transmitted or received CAN
                                        *   message data. Transmission or reception starts from DATA0.
                                        *   The bit order on the CAN bus is MSB-first, and transmission
                                        *   or reception starts from bit 7                                            */
        } D_b[8];
    };

    union
    {
        __IOM uint16_t TS;             /*!< (@ 0x0000000E) Mailbox Timestamp Register                                 */

        struct
        {
            __IOM uint16_t TSL : 8;    /*!< [7..0] Time Stamp Higher ByteBits TSL[7:0] store the counter
                                        *   value of the time stamp when received messages are stored
                                        *   in the mailbox.                                                           */
            __IOM uint16_t TSH : 8;    /*!< [15..8] Time Stamp Lower ByteBits TSH[7:0] store the counter
                                        *   value of the time stamp when received messages are stored
                                        *   in the mailbox.                                                           */
        } TS_b;
    };
} R_CAN0_MB_Type;                      /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_CANFD_CFDC [CFDC] (Channel Control/Status)
 */
typedef struct
{
    union
    {
        __IOM uint32_t NCFG;            /*!< (@ 0x00000000) Channel Nominal Bitrate Configuration Register             */

        struct
        {
            __IOM uint32_t NBRP   : 10; /*!< [9..0] Channel Nominal Baud Rate Prescaler                                */
            __IOM uint32_t NSJW   : 7;  /*!< [16..10] Resynchronization Jump Width                                     */
            __IOM uint32_t NTSEG1 : 8;  /*!< [24..17] Timing Segment 1                                                 */
            __IOM uint32_t NTSEG2 : 7;  /*!< [31..25] Timing Segment 2                                                 */
        } NCFG_b;
    };

    union
    {
        __IOM uint32_t CTR;             /*!< (@ 0x00000004) Channel Control Registers                                  */

        struct
        {
            __IOM uint32_t CHMDC   : 2; /*!< [1..0] Channel Mode Control                                               */
            __IOM uint32_t CSLPR   : 1; /*!< [2..2] Channel Sleep Request                                              */
            __IOM uint32_t RTBO    : 1; /*!< [3..3] Return from Bus-Off                                                */
            uint32_t               : 4;
            __IOM uint32_t BEIE    : 1; /*!< [8..8] Bus Error Interrupt Enable                                         */
            __IOM uint32_t EWIE    : 1; /*!< [9..9] Error Warning Interrupt Enable                                     */
            __IOM uint32_t EPIE    : 1; /*!< [10..10] Error Passive Interrupt Enable                                   */
            __IOM uint32_t BOEIE   : 1; /*!< [11..11] Bus-Off Entry Interrupt Enable                                   */
            __IOM uint32_t BORIE   : 1; /*!< [12..12] Bus-Off Recovery Interrupt Enable                                */
            __IOM uint32_t OLIE    : 1; /*!< [13..13] Overload Interrupt Enable                                        */
            __IOM uint32_t BLIE    : 1; /*!< [14..14] Bus Lock Interrupt Enable                                        */
            __IOM uint32_t ALIE    : 1; /*!< [15..15] Arbitration Lost Interrupt Enable                                */
            __IOM uint32_t TAIE    : 1; /*!< [16..16] Transmission abort Interrupt Enable                              */
            __IOM uint32_t EOCOIE  : 1; /*!< [17..17] Error occurrence counter overflow Interrupt enable               */
            __IOM uint32_t SOCOIE  : 1; /*!< [18..18] Successful Occurrence Counter Overflow Interrupt enable          */
            __IOM uint32_t TDCVFIE : 1; /*!< [19..19] Transceiver Delay Compensation Violation Interrupt
                                         *   enable                                                                    */
            uint32_t            : 1;
            __IOM uint32_t BOM  : 2;    /*!< [22..21] Channel Bus-Off Mode                                             */
            __IOM uint32_t ERRD : 1;    /*!< [23..23] Channel Error Display                                            */
            __IOM uint32_t CTME : 1;    /*!< [24..24] Channel Test Mode Enable                                         */
            __IOM uint32_t CTMS : 2;    /*!< [26..25] Channel Test Mode Select                                         */
            __IOM uint32_t TRWE : 1;    /*!< [27..27] TEC/REC Write Enable                                             */
            __IOM uint32_t TRH  : 1;    /*!< [28..28] TEC/REC Hold                                                     */
            __IOM uint32_t TRR  : 1;    /*!< [29..29] TEC/REC Reset                                                    */
            __IOM uint32_t CRCT : 1;    /*!< [30..30] CRC Error Test                                                   */
            __IOM uint32_t ROM  : 1;    /*!< [31..31] Restricted Operation Mode                                        */
        } CTR_b;
    };

    union
    {
        __IOM uint32_t STS;             /*!< (@ 0x00000008) Channel Status Registers                                   */

        struct
        {
            __IM uint32_t  CRSTSTS : 1; /*!< [0..0] Channel RESET Status                                               */
            __IM uint32_t  CHLTSTS : 1; /*!< [1..1] Channel HALT Status                                                */
            __IM uint32_t  CSLPSTS : 1; /*!< [2..2] Channel SLEEP Status                                               */
            __IM uint32_t  EPSTS   : 1; /*!< [3..3] Channel Error Passive Status                                       */
            __IM uint32_t  BOSTS   : 1; /*!< [4..4] Channel Bus-Off Status                                             */
            __IM uint32_t  TRMSTS  : 1; /*!< [5..5] Channel Transmit Status                                            */
            __IM uint32_t  RECSTS  : 1; /*!< [6..6] Channel Receive Status                                             */
            __IM uint32_t  COMSTS  : 1; /*!< [7..7] Channel Communication Status                                       */
            __IOM uint32_t ESIF    : 1; /*!< [8..8] Error State Indication Flag                                        */
            uint32_t               : 7;
            __IM uint32_t  REC     : 8; /*!< [23..16] Reception Error Count                                            */
            __IOM uint32_t TEC     : 8; /*!< [31..24] Transmission Error Count                                         */
        } STS_b;
    };

    union
    {
        __IOM uint32_t ERFL;           /*!< (@ 0x0000000C) Channel Error Flag Registers                               */

        struct
        {
            __IOM uint32_t BEF   : 1;  /*!< [0..0] Bus Error Flag                                                     */
            __IOM uint32_t EWF   : 1;  /*!< [1..1] Error Warning Flag                                                 */
            __IOM uint32_t EPF   : 1;  /*!< [2..2] Error Passive Flag                                                 */
            __IOM uint32_t BOEF  : 1;  /*!< [3..3] Bus-Off Entry Flag                                                 */
            __IOM uint32_t BORF  : 1;  /*!< [4..4] Bus-Off Recovery Flag                                              */
            __IOM uint32_t OVLF  : 1;  /*!< [5..5] Overload Flag                                                      */
            __IOM uint32_t BLF   : 1;  /*!< [6..6] Bus Lock Flag                                                      */
            __IOM uint32_t ALF   : 1;  /*!< [7..7] Arbitration Lost Flag                                              */
            __IOM uint32_t SERR  : 1;  /*!< [8..8] Stuff Error                                                        */
            __IOM uint32_t FERR  : 1;  /*!< [9..9] Form Error                                                         */
            __IOM uint32_t AERR  : 1;  /*!< [10..10] Acknowledge Error                                                */
            __IOM uint32_t CERR  : 1;  /*!< [11..11] CRC Error                                                        */
            __IOM uint32_t B1ERR : 1;  /*!< [12..12] Bit 1 Error                                                      */
            __IOM uint32_t B0ERR : 1;  /*!< [13..13] Bit 0 Error                                                      */
            __IOM uint32_t ADERR : 1;  /*!< [14..14] Acknowledge Delimiter Error                                      */
            uint32_t             : 1;
            __IM uint32_t CRCREG : 15; /*!< [30..16] CRC Register value                                               */
            uint32_t             : 1;
        } ERFL_b;
    };
} R_CANFD_CFDC_Type;                   /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_CANFD_CFDC2 [CFDC2] (Channel Configuration Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t DCFG;           /*!< (@ 0x00000000) Channel Data Bitrate Configuration Register                */

        struct
        {
            __IOM uint32_t DBRP   : 8; /*!< [7..0] Channel Data Baud Rate Prescaler                                   */
            __IOM uint32_t DTSEG1 : 5; /*!< [12..8] Timing Segment 1                                                  */
            uint32_t              : 3;
            __IOM uint32_t DTSEG2 : 4; /*!< [19..16] Timing Segment 2                                                 */
            uint32_t              : 4;
            __IOM uint32_t DSJW   : 4; /*!< [27..24] Resynchronization Jump Width                                     */
            uint32_t              : 4;
        } DCFG_b;
    };

    union
    {
        __IOM uint32_t FDCFG;          /*!< (@ 0x00000004) Channel CAN-FD Configuration Register                      */

        struct
        {
            __IOM uint32_t EOCCFG : 3; /*!< [2..0] Error Occurrence Counter Configuration                             */
            uint32_t              : 5;
            __IOM uint32_t TDCOC  : 1; /*!< [8..8] Transceiver Delay Compensation Offset Configuration                */
            __IOM uint32_t TDCE   : 1; /*!< [9..9] Transceiver Delay Compensation Enable                              */
            __IOM uint32_t ESIC   : 1; /*!< [10..10] Error State Indication Configuration                             */
            uint32_t              : 5;
            __IOM uint32_t TDCO   : 8; /*!< [23..16] Transceiver Delay Compensation Offset                            */
            __IOM uint32_t GWEN   : 1; /*!< [24..24] CAN2.0, CAN-FD <> CAN2.0, CAN-FD Multi Gateway Enable            */
            __IOM uint32_t GWFDF  : 1; /*!< [25..25] Gateway FDF configuration bit                                    */
            __IOM uint32_t GWBRS  : 1; /*!< [26..26] Gateway BRS configuration bit                                    */
            uint32_t              : 1;
            __IOM uint32_t FDOE   : 1; /*!< [28..28] FD only enable                                                   */
            __IOM uint32_t REFE   : 1; /*!< [29..29] RX edge filter enable                                            */
            __IOM uint32_t CLOE   : 1; /*!< [30..30] Classical CAN only enable                                        */
            __IOM uint32_t CFDTE  : 1; /*!< [31..31] CAN-FD frame Distinction enable                                  */
        } FDCFG_b;
    };

    union
    {
        __IOM uint32_t FDCTR;          /*!< (@ 0x00000008) Channel CAN-FD Control Register                            */

        struct
        {
            __IOM uint32_t EOCCLR : 1; /*!< [0..0] Error Occurrence Counter Clear                                     */
            __IOM uint32_t SOCCLR : 1; /*!< [1..1] Successful Occurrence Counter Clear                                */
            uint32_t              : 30;
        } FDCTR_b;
    };

    union
    {
        __IOM uint32_t FDSTS;          /*!< (@ 0x0000000C) Channel CAN-FD Status Register                             */

        struct
        {
            __IM uint32_t  TDCR  : 8;  /*!< [7..0] Transceiver Delay Compensation Result                              */
            __IOM uint32_t EOCO  : 1;  /*!< [8..8] Error occurrence counter overflow                                  */
            __IOM uint32_t SOCO  : 1;  /*!< [9..9] Successful occurrence counter overflow                             */
            uint32_t             : 5;
            __IOM uint32_t TDCVF : 1;  /*!< [15..15] Transceiver Delay Compensation Violation Flag                    */
            __IM uint32_t  EOC   : 8;  /*!< [23..16] Error occurrence counter register                                */
            __IM uint32_t  SOC   : 8;  /*!< [31..24] Successful occurrence counter register                           */
        } FDSTS_b;
    };

    union
    {
        __IOM uint32_t FDCRC;          /*!< (@ 0x00000010) Channel CAN-FD CRC Register                                */

        struct
        {
            __IM uint32_t CRCREG : 21; /*!< [20..0] CRC Register value                                                */
            uint32_t             : 3;
            __IM uint32_t SCNT   : 4;  /*!< [27..24] Stuff bit count                                                  */
            uint32_t             : 4;
        } FDCRC_b;
    };
    __IM uint32_t RESERVED;

    union
    {
        __IOM uint32_t BLCT;           /*!< (@ 0x00000018) Channel Bus load Control Register                          */

        struct
        {
            __IOM uint32_t BLCE : 1;   /*!< [0..0] BUS Load counter Enable                                            */
            uint32_t            : 7;
            __OM uint32_t BLCLD : 1;   /*!< [8..8] BUS Load counter load                                              */
            uint32_t            : 23;
        } BLCT_b;
    };

    union
    {
        __IOM uint32_t BLSTS;          /*!< (@ 0x0000001C) Channel Bus load Status Register                           */

        struct
        {
            uint32_t          : 3;
            __IM uint32_t BLC : 29;    /*!< [31..3] BUS Load counter Status                                           */
        } BLSTS_b;
    };
} R_CANFD_CFDC2_Type;                  /*!< Size = 32 (0x20)                                                          */

/**
 * @brief R_CANFD_CFDGAFL [CFDGAFL] (Global Acceptance Filter List Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t ID;               /*!< (@ 0x00000000) Global Acceptance Filter List ID Registers                 */

        struct
        {
            __IOM uint32_t GAFLID  : 29; /*!< [28..0] Global Acceptance Filter List Entry ID Field                      */
            __IOM uint32_t GAFLLB  : 1;  /*!< [29..29] Global Acceptance Filter List Entry Loopback Configuration       */
            __IOM uint32_t GAFLRTR : 1;  /*!< [30..30] Global Acceptance Filter List Entry RTR Field                    */
            __IOM uint32_t GAFLIDE : 1;  /*!< [31..31] Global Acceptance Filter List Entry IDE Field                    */
        } ID_b;
    };

    union
    {
        __IOM uint32_t M;                 /*!< (@ 0x00000004) Global Acceptance Filter List Mask Registers               */

        struct
        {
            __IOM uint32_t GAFLIDM  : 29; /*!< [28..0] Global Acceptance Filter List ID Mask Field                       */
            __IOM uint32_t GAFLIFL1 : 1;  /*!< [29..29] Global Acceptance Filter List Information Label 1                */
            __IOM uint32_t GAFLRTRM : 1;  /*!< [30..30] Global Acceptance Filter List Entry RTR Mask                     */
            __IOM uint32_t GAFLIDEM : 1;  /*!< [31..31] Global Acceptance Filter List IDE Mask                           */
        } M_b;
    };

    union
    {
        __IOM uint32_t P0;               /*!< (@ 0x00000008) Global Acceptance Filter List Pointer 0 Registers          */

        struct
        {
            __IOM uint32_t GAFLDLC  : 4; /*!< [3..0] Global Acceptance Filter List DLC Field                            */
            __IOM uint32_t GAFLSRD0 : 1; /*!< [4..4] Global Acceptance Filter List Select Routing destination
                                          *   0                                                                         */
            __IOM uint32_t GAFLSRD1 : 1; /*!< [5..5] Global Acceptance Filter List Select Routing destination
                                          *   1                                                                         */
            __IOM uint32_t GAFLSRD2 : 1; /*!< [6..6] Global Acceptance Filter List Select Routing destination
                                          *   2                                                                         */
            __IOM uint32_t GAFLIFL0 : 1; /*!< [7..7] Global Acceptance Filter List Information Label 0                  */
            __IOM uint32_t GAFLRMDP : 5; /*!< [12..8] Global Acceptance Filter List RX Message Buffer Direction
                                          *   Pointer                                                                   */
            uint32_t               : 2;
            __IOM uint32_t GAFLRMV : 1;  /*!< [15..15] Global Acceptance Filter List RX Message Buffer Valid            */
            __IOM uint32_t GAFLPTR : 16; /*!< [31..16] Global Acceptance Filter List Pointer Field                      */
        } P0_b;
    };

    union
    {
        __IOM uint32_t P1;               /*!< (@ 0x0000000C) Global Acceptance Filter List Pointer 1 Registers          */

        struct
        {
            __IOM uint32_t GAFLFDP : 14; /*!< [13..0] Global Acceptance Filter List FIFO Direction Pointer              */
            uint32_t               : 18;
        } P1_b;
    };
} R_CANFD_CFDGAFL_Type;                  /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_CANFD_CFDTHL [CFDTHL] (Channel TX History List)
 */
typedef struct
{
    union
    {
        __IM uint32_t ACC0;            /*!< (@ 0x00000000) Channel TX History List Access Registers 0                 */

        struct
        {
            __IM uint32_t BT   : 3;    /*!< [2..0] Buffer Type                                                        */
            __IM uint32_t BN   : 7;    /*!< [9..3] Buffer No.                                                         */
            uint32_t           : 5;
            __IM uint32_t TGW  : 1;    /*!< [15..15] Transmit Gateway Buffer indication                               */
            __IM uint32_t TMTS : 16;   /*!< [31..16] Transmit Timestamp                                               */
        } ACC0_b;
    };

    union
    {
        __IOM uint32_t ACC1;           /*!< (@ 0x00000004) Channel TX History List Access Registers 1                 */

        struct
        {
            __IM uint32_t TID  : 16;   /*!< [15..0] Transmit ID                                                       */
            __IM uint32_t TIFL : 2;    /*!< [17..16] Transmit Information Label                                       */
            uint32_t           : 14;
        } ACC1_b;
    };
} R_CANFD_CFDTHL_Type;                 /*!< Size = 8 (0x8)                                                            */

/**
 * @brief R_CANFD_CFDRM [CFDRM] (RX Message Buffer Access Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t ID;              /*!< (@ 0x00000000) RX Message Buffer ID Register                              */

        struct
        {
            __IM uint32_t RMID  : 29;  /*!< [28..0] RX Message Buffer ID Field                                        */
            uint32_t            : 1;
            __IM uint32_t RMRTR : 1;   /*!< [30..30] RX Message Buffer RTR Frame                                      */
            __IM uint32_t RMIDE : 1;   /*!< [31..31] RX Message Buffer IDE Bit                                        */
        } ID_b;
    };

    union
    {
        __IM uint32_t PTR;             /*!< (@ 0x00000004) RX Message Buffer Pointer Register                         */

        struct
        {
            __IM uint32_t RMTS  : 16;  /*!< [15..0] RX Message Buffer Timestamp Field                                 */
            uint32_t            : 12;
            __IM uint32_t RMDLC : 4;   /*!< [31..28] RX Message Buffer DLC Field                                      */
        } PTR_b;
    };

    union
    {
        __IM uint32_t FDSTS;           /*!< (@ 0x00000008) RX Message Buffer CAN-FD Status Register                   */

        struct
        {
            __IM uint32_t RMESI : 1;   /*!< [0..0] Error State Indicator bit                                          */
            __IM uint32_t RMBRS : 1;   /*!< [1..1] Bit Rate Switch bit                                                */
            __IM uint32_t RMFDF : 1;   /*!< [2..2] CAN FD Format bit                                                  */
            uint32_t            : 5;
            __IM uint32_t RMIFL : 2;   /*!< [9..8] RX Message Buffer Information Label Field                          */
            uint32_t            : 6;
            __IM uint32_t RMPTR : 16;  /*!< [31..16] RX Message Buffer Pointer Field                                  */
        } FDSTS_b;
    };

    union
    {
        __IM uint8_t DF[64];           /*!< (@ 0x0000000C) RX Message Buffer Data Field Registers                     */

        struct
        {
            __IM uint8_t RMDB : 8;     /*!< [7..0] RX Message Buffer Data Byte                                        */
        } DF_b[64];
    };
    __IM uint32_t RESERVED[13];
} R_CANFD_CFDRM_Type;                  /*!< Size = 128 (0x80)                                                         */

/**
 * @brief R_CANFD_CFDRF [CFDRF] (RX FIFO Access Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t ID;              /*!< (@ 0x00000000) RX FIFO Access ID Register                                 */

        struct
        {
            __IM uint32_t RFID  : 29;  /*!< [28..0] RX FIFO Buffer ID Field                                           */
            uint32_t            : 1;
            __IM uint32_t RFRTR : 1;   /*!< [30..30] RX FIFO Buffer RTR Frame                                         */
            __IM uint32_t RFIDE : 1;   /*!< [31..31] RX FIFO Buffer IDE Bit                                           */
        } ID_b;
    };

    union
    {
        __IM uint32_t PTR;             /*!< (@ 0x00000004) RX FIFO Access Pointer Register                            */

        struct
        {
            __IM uint32_t RFTS  : 16;  /*!< [15..0] RX FIFO Timestamp Field                                           */
            uint32_t            : 12;
            __IM uint32_t RFDLC : 4;   /*!< [31..28] RX FIFO Buffer DLC Field                                         */
        } PTR_b;
    };

    union
    {
        __IM uint32_t FDSTS;           /*!< (@ 0x00000008) RX FIFO Access CAN-FD Status Register                      */

        struct
        {
            __IM uint32_t RFESI : 1;   /*!< [0..0] Error State Indicator bit                                          */
            __IM uint32_t RFBRS : 1;   /*!< [1..1] Bit Rate Switch bit                                                */
            __IM uint32_t RFFDF : 1;   /*!< [2..2] CAN FD Format bit                                                  */
            uint32_t            : 5;
            __IM uint32_t RFIFL : 2;   /*!< [9..8] RX FIFO Buffer Information Label Field                             */
            uint32_t            : 6;
            __IM uint32_t RFPTR : 16;  /*!< [31..16] RX FIFO Buffer Pointer Field                                     */
        } FDSTS_b;
    };

    union
    {
        __IM uint8_t DF[64];           /*!< (@ 0x0000000C) RX FIFO Access Data Field Registers                        */

        struct
        {
            __IM uint8_t RFDB : 8;     /*!< [7..0] RX FIFO Buffer Data Byte                                           */
        } DF_b[64];
    };
    __IM uint32_t RESERVED[13];
} R_CANFD_CFDRF_Type;                  /*!< Size = 128 (0x80)                                                         */

/**
 * @brief R_CANFD_CFDCF [CFDCF] (Common FIFO Access Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t ID;             /*!< (@ 0x00000000) Common FIFO Access ID Register                             */

        struct
        {
            __IOM uint32_t CFID  : 29; /*!< [28..0] Common FIFO Buffer ID Field                                       */
            uint32_t             : 1;
            __IOM uint32_t CFRTR : 1;  /*!< [30..30] Common FIFO Buffer RTR Frame                                     */
            __IOM uint32_t CFIDE : 1;  /*!< [31..31] Common FIFO Buffer IDE Bit                                       */
        } ID_b;
    };

    union
    {
        __IOM uint32_t PTR;            /*!< (@ 0x00000004) Common FIFO Access Pointer Register                        */

        struct
        {
            __IOM uint32_t CFTS  : 16; /*!< [15..0] Common FIFO Timestamp Field                                       */
            uint32_t             : 12;
            __IOM uint32_t CFDLC : 4;  /*!< [31..28] Common FIFO Buffer DLC Field                                     */
        } PTR_b;
    };

    union
    {
        __IOM uint32_t FDSTS;          /*!< (@ 0x00000008) Common FIFO Access CAN-FD Status Register                  */

        struct
        {
            __IOM uint32_t CFESI : 1;  /*!< [0..0] Error State Indicator bit                                          */
            __IOM uint32_t CFBRS : 1;  /*!< [1..1] Bit Rate Switch bit                                                */
            __IOM uint32_t CFFDF : 1;  /*!< [2..2] CAN FD Format bit                                                  */
            uint32_t             : 5;
            __IOM uint32_t CFIFL : 2;  /*!< [9..8] Common FIFO Buffer Information Label Field                         */
            uint32_t             : 6;
            __IOM uint32_t CFPTR : 16; /*!< [31..16] Common FIFO Buffer Pointer Field                                 */
        } FDSTS_b;
    };

    union
    {
        __IOM uint8_t DF[64];          /*!< (@ 0x0000000C) Common FIFO Access Data Field Registers                    */

        struct
        {
            __IOM uint8_t CFDB : 8;    /*!< [7..0] Common FIFO Buffer Data Byte                                       */
        } DF_b[64];
    };
    __IM uint32_t RESERVED[13];
} R_CANFD_CFDCF_Type;                  /*!< Size = 128 (0x80)                                                         */

/**
 * @brief R_CANFD_CFDTM [CFDTM] (TX Message Buffer Access Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t ID;             /*!< (@ 0x00000000) TX Message Buffer ID Register                              */

        struct
        {
            __IOM uint32_t TMID  : 29; /*!< [28..0] TX Message Buffer ID Field                                        */
            uint32_t             : 1;
            __IOM uint32_t TMRTR : 1;  /*!< [30..30] TX Message Buffer RTR Frame                                      */
            __IOM uint32_t TMIDE : 1;  /*!< [31..31] TX Message Buffer IDE Bit                                        */
        } ID_b;
    };

    union
    {
        __IOM uint32_t PTR;            /*!< (@ 0x00000004) TX Message Buffer Pointer Register                         */

        struct
        {
            __IOM uint32_t TMTS  : 16; /*!< [15..0] TX Message Buffer Timestamp Field                                 */
            uint32_t             : 12;
            __IOM uint32_t TMDLC : 4;  /*!< [31..28] TX Message Buffer DLC Field                                      */
        } PTR_b;
    };

    union
    {
        __IOM uint32_t FDCTR;          /*!< (@ 0x00000008) TX Message Buffer CAN-FD Control Register                  */

        struct
        {
            __IOM uint32_t TMESI : 1;  /*!< [0..0] Error State Indicator bit                                          */
            __IOM uint32_t TMBRS : 1;  /*!< [1..1] Bit Rate Switch bit                                                */
            __IOM uint32_t TMFDF : 1;  /*!< [2..2] CAN FD Format bit                                                  */
            uint32_t             : 5;
            __IOM uint32_t TMIFL : 2;  /*!< [9..8] TX Message Buffer Information Label Field                          */
            uint32_t             : 6;
            __IOM uint32_t TMPTR : 16; /*!< [31..16] TX Message Buffer Pointer Field                                  */
        } FDCTR_b;
    };

    union
    {
        __IOM uint8_t DF[64];          /*!< (@ 0x0000000C) TX Message Buffer Data Field Registers                     */

        struct
        {
            __IOM uint8_t TMDB : 8;    /*!< [7..0] TX Message Buffer Data Byte                                        */
        } DF_b[64];
    };
    __IM uint32_t RESERVED[13];
} R_CANFD_CFDTM_Type;                  /*!< Size = 128 (0x80)                                                         */

/**
 * @brief R_CANFDL_CFDC [CFDC] (Channel Control/Status)
 */
typedef struct
{
    union
    {
        __IOM uint32_t NCFG;            /*!< (@ 0x00000000) Channel Nominal Bitrate Configuration Register             */

        struct
        {
            __IOM uint32_t NBRP   : 10; /*!< [9..0] Channel Nominal Baud Rate Prescaler                                */
            __IOM uint32_t NSJW   : 7;  /*!< [16..10] Resynchronization Jump Width                                     */
            __IOM uint32_t NTSEG1 : 8;  /*!< [24..17] Timing Segment 1                                                 */
            __IOM uint32_t NTSEG2 : 7;  /*!< [31..25] Timing Segment 2                                                 */
        } NCFG_b;
    };

    union
    {
        __IOM uint32_t CTR;             /*!< (@ 0x00000004) Channel Control Registers                                  */

        struct
        {
            __IOM uint32_t CHMDC   : 2; /*!< [1..0] Channel Mode Control                                               */
            __IOM uint32_t CSLPR   : 1; /*!< [2..2] Channel Sleep Request                                              */
            __IOM uint32_t RTBO    : 1; /*!< [3..3] Return from Bus-Off                                                */
            uint32_t               : 4;
            __IOM uint32_t BEIE    : 1; /*!< [8..8] Bus Error Interrupt Enable                                         */
            __IOM uint32_t EWIE    : 1; /*!< [9..9] Error Warning Interrupt Enable                                     */
            __IOM uint32_t EPIE    : 1; /*!< [10..10] Error Passive Interrupt Enable                                   */
            __IOM uint32_t BOEIE   : 1; /*!< [11..11] Bus-Off Entry Interrupt Enable                                   */
            __IOM uint32_t BORIE   : 1; /*!< [12..12] Bus-Off Recovery Interrupt Enable                                */
            __IOM uint32_t OLIE    : 1; /*!< [13..13] Overload Interrupt Enable                                        */
            __IOM uint32_t BLIE    : 1; /*!< [14..14] Bus Lock Interrupt Enable                                        */
            __IOM uint32_t ALIE    : 1; /*!< [15..15] Arbitration Lost Interrupt Enable                                */
            __IOM uint32_t TAIE    : 1; /*!< [16..16] Transmission abort Interrupt Enable                              */
            __IOM uint32_t EOCOIE  : 1; /*!< [17..17] Error occurrence counter overflow Interrupt enable               */
            __IOM uint32_t SOCOIE  : 1; /*!< [18..18] Successful Occurrence Counter Overflow Interrupt enable          */
            __IOM uint32_t TDCVFIE : 1; /*!< [19..19] Transceiver Delay Compensation Violation Interrupt
                                         *   enable                                                                    */
            uint32_t            : 1;
            __IOM uint32_t BOM  : 2;    /*!< [22..21] Channel Bus-Off Mode                                             */
            __IOM uint32_t ERRD : 1;    /*!< [23..23] Channel Error Display                                            */
            __IOM uint32_t CTME : 1;    /*!< [24..24] Channel Test Mode Enable                                         */
            __IOM uint32_t CTMS : 2;    /*!< [26..25] Channel Test Mode Select                                         */
            uint32_t            : 3;
            __IOM uint32_t CRCT : 1;    /*!< [30..30] CRC Error Test                                                   */
            __IOM uint32_t ROM  : 1;    /*!< [31..31] Restricted Operation Mode                                        */
        } CTR_b;
    };

    union
    {
        __IOM uint32_t STS;             /*!< (@ 0x00000008) Channel Status Registers                                   */

        struct
        {
            __IM uint32_t  CRSTSTS : 1; /*!< [0..0] Channel RESET Status                                               */
            __IM uint32_t  CHLTSTS : 1; /*!< [1..1] Channel HALT Status                                                */
            __IM uint32_t  CSLPSTS : 1; /*!< [2..2] Channel SLEEP Status                                               */
            __IM uint32_t  EPSTS   : 1; /*!< [3..3] Channel Error Passive Status                                       */
            __IM uint32_t  BOSTS   : 1; /*!< [4..4] Channel Bus-Off Status                                             */
            __IM uint32_t  TRMSTS  : 1; /*!< [5..5] Channel Transmit Status                                            */
            __IM uint32_t  RECSTS  : 1; /*!< [6..6] Channel Receive Status                                             */
            __IM uint32_t  COMSTS  : 1; /*!< [7..7] Channel Communication Status                                       */
            __IOM uint32_t ESIF    : 1; /*!< [8..8] Error State Indication Flag                                        */
            uint32_t               : 7;
            __IM uint32_t  REC     : 8; /*!< [23..16] Reception Error Count                                            */
            __IOM uint32_t TEC     : 8; /*!< [31..24] Transmission Error Count                                         */
        } STS_b;
    };

    union
    {
        __IOM uint32_t ERFL;           /*!< (@ 0x0000000C) Channel Error Flag Registers                               */

        struct
        {
            __IOM uint32_t BEF   : 1;  /*!< [0..0] Bus Error Flag                                                     */
            __IOM uint32_t EWF   : 1;  /*!< [1..1] Error Warning Flag                                                 */
            __IOM uint32_t EPF   : 1;  /*!< [2..2] Error Passive Flag                                                 */
            __IOM uint32_t BOEF  : 1;  /*!< [3..3] Bus-Off Entry Flag                                                 */
            __IOM uint32_t BORF  : 1;  /*!< [4..4] Bus-Off Recovery Flag                                              */
            __IOM uint32_t OVLF  : 1;  /*!< [5..5] Overload Flag                                                      */
            __IOM uint32_t BLF   : 1;  /*!< [6..6] Bus Lock Flag                                                      */
            __IOM uint32_t ALF   : 1;  /*!< [7..7] Arbitration Lost Flag                                              */
            __IOM uint32_t SERR  : 1;  /*!< [8..8] Stuff Error                                                        */
            __IOM uint32_t FERR  : 1;  /*!< [9..9] Form Error                                                         */
            __IOM uint32_t AERR  : 1;  /*!< [10..10] Acknowledge Error                                                */
            __IOM uint32_t CERR  : 1;  /*!< [11..11] CRC Error                                                        */
            __IOM uint32_t B1ERR : 1;  /*!< [12..12] Bit 1 Error                                                      */
            __IOM uint32_t B0ERR : 1;  /*!< [13..13] Bit 0 Error                                                      */
            __IOM uint32_t ADERR : 1;  /*!< [14..14] Acknowledge Delimiter Error                                      */
            uint32_t             : 1;
            __IM uint32_t CRCREG : 15; /*!< [30..16] CRC Register value                                               */
            uint32_t             : 1;
        } ERFL_b;
    };
} R_CANFDL_CFDC_Type;                  /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_CANFDL_CFDC2 [CFDC2] (Channel Configuration Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t DCFG;           /*!< (@ 0x00000000) Channel Data Bitrate Configuration Register                */

        struct
        {
            __IOM uint32_t DBRP   : 8; /*!< [7..0] Channel Data Baud Rate Prescaler                                   */
            __IOM uint32_t DTSEG1 : 5; /*!< [12..8] Timing Segment 1                                                  */
            uint32_t              : 3;
            __IOM uint32_t DTSEG2 : 4; /*!< [19..16] Timing Segment 2                                                 */
            uint32_t              : 4;
            __IOM uint32_t DSJW   : 4; /*!< [27..24] Resynchronization Jump Width                                     */
            uint32_t              : 4;
        } DCFG_b;
    };

    union
    {
        __IOM uint32_t FDCFG;          /*!< (@ 0x00000004) Channel CAN-FD Configuration Register                      */

        struct
        {
            __IOM uint32_t EOCCFG : 3; /*!< [2..0] Error Occurrence Counter Configuration                             */
            uint32_t              : 5;
            __IOM uint32_t TDCOC  : 1; /*!< [8..8] Transceiver Delay Compensation Offset Configuration                */
            __IOM uint32_t TDCE   : 1; /*!< [9..9] Transceiver Delay Compensation Enable                              */
            __IOM uint32_t ESIC   : 1; /*!< [10..10] Error State Indication Configuration                             */
            uint32_t              : 5;
            __IOM uint32_t TDCO   : 8; /*!< [23..16] Transceiver Delay Compensation Offset                            */
            uint32_t              : 4;
            __IOM uint32_t FDOE   : 1; /*!< [28..28] FD only enable                                                   */
            __IOM uint32_t REFE   : 1; /*!< [29..29] RX edge filter enable                                            */
            __IOM uint32_t CLOE   : 1; /*!< [30..30] Classical CAN only enable                                        */
            uint32_t              : 1;
        } FDCFG_b;
    };

    union
    {
        __IOM uint32_t FDCTR;          /*!< (@ 0x00000008) Channel CAN-FD Control Register                            */

        struct
        {
            __IOM uint32_t EOCCLR : 1; /*!< [0..0] Error Occurrence Counter Clear                                     */
            __IOM uint32_t SOCCLR : 1; /*!< [1..1] Successful Occurrence Counter Clear                                */
            uint32_t              : 30;
        } FDCTR_b;
    };

    union
    {
        __IOM uint32_t FDSTS;          /*!< (@ 0x0000000C) Channel CAN-FD Status Register                             */

        struct
        {
            __IM uint32_t  TDCR  : 8;  /*!< [7..0] Transceiver Delay Compensation Result                              */
            __IOM uint32_t EOCO  : 1;  /*!< [8..8] Error occurrence counter overflow                                  */
            __IOM uint32_t SOCO  : 1;  /*!< [9..9] Successful occurrence counter overflow                             */
            uint32_t             : 5;
            __IOM uint32_t TDCVF : 1;  /*!< [15..15] Transceiver Delay Compensation Violation Flag                    */
            __IM uint32_t  EOC   : 8;  /*!< [23..16] Error occurrence counter register                                */
            __IM uint32_t  SOC   : 8;  /*!< [31..24] Successful occurrence counter register                           */
        } FDSTS_b;
    };

    union
    {
        __IOM uint32_t FDCRC;          /*!< (@ 0x00000010) Channel CAN-FD CRC Register                                */

        struct
        {
            __IM uint32_t CRCREG : 21; /*!< [20..0] CRC Register value                                                */
            uint32_t             : 3;
            __IM uint32_t SCNT   : 4;  /*!< [27..24] Stuff bit count                                                  */
            uint32_t             : 4;
        } FDCRC_b;
    };
    __IM uint32_t RESERVED[3];
} R_CANFDL_CFDC2_Type;                 /*!< Size = 32 (0x20)                                                          */

/**
 * @brief R_CANFDL_CFDGAFL [CFDGAFL] (Global Acceptance Filter List Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t ID;               /*!< (@ 0x00000000) Global Acceptance Filter List ID Registers                 */

        struct
        {
            __IOM uint32_t GAFLID  : 29; /*!< [28..0] Global Acceptance Filter List Entry ID Field                      */
            __IOM uint32_t GAFLLB  : 1;  /*!< [29..29] Global Acceptance Filter List Entry Loopback Configuration       */
            __IOM uint32_t GAFLRTR : 1;  /*!< [30..30] Global Acceptance Filter List Entry RTR Field                    */
            __IOM uint32_t GAFLIDE : 1;  /*!< [31..31] Global Acceptance Filter List Entry IDE Field                    */
        } ID_b;
    };

    union
    {
        __IOM uint32_t M;                 /*!< (@ 0x00000004) Global Acceptance Filter List Mask Registers               */

        struct
        {
            __IOM uint32_t GAFLIDM  : 29; /*!< [28..0] Global Acceptance Filter List ID Mask Field                       */
            __IOM uint32_t GAFLIFL1 : 1;  /*!< [29..29] Global Acceptance Filter List Information Label 1                */
            __IOM uint32_t GAFLRTRM : 1;  /*!< [30..30] Global Acceptance Filter List Entry RTR Mask                     */
            __IOM uint32_t GAFLIDEM : 1;  /*!< [31..31] Global Acceptance Filter List IDE Mask                           */
        } M_b;
    };

    union
    {
        __IOM uint32_t P0;               /*!< (@ 0x00000008) Global Acceptance Filter List Pointer 0 Registers          */

        struct
        {
            __IOM uint32_t GAFLDLC  : 4; /*!< [3..0] Global Acceptance Filter List DLC Field                            */
            uint32_t                : 3;
            __IOM uint32_t GAFLIFL0 : 1; /*!< [7..7] Global Acceptance Filter List Information Label 0                  */
            __IOM uint32_t GAFLRMDP : 5; /*!< [12..8] Global Acceptance Filter List RX Message Buffer Direction
                                          *   Pointer                                                                   */
            uint32_t               : 2;
            __IOM uint32_t GAFLRMV : 1;  /*!< [15..15] Global Acceptance Filter List RX Message Buffer Valid            */
            __IOM uint32_t GAFLPTR : 16; /*!< [31..16] Global Acceptance Filter List Pointer Field                      */
        } P0_b;
    };

    union
    {
        __IOM uint32_t P1;              /*!< (@ 0x0000000C) Global Acceptance Filter List Pointer 1 Registers          */

        struct
        {
            __IOM uint32_t GAFLFDP : 9; /*!< [8..0] Global Acceptance Filter List FIFO Direction Pointer               */
            uint32_t               : 23;
        } P1_b;
    };
} R_CANFDL_CFDGAFL_Type;                /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_CANFDL_CFDTHL [CFDTHL] (Channel TX History List)
 */
typedef struct
{
    union
    {
        __IM uint32_t ACC0;            /*!< (@ 0x00000000) Channel TX History List Access Registers 0                 */

        struct
        {
            __IM uint32_t BT   : 3;    /*!< [2..0] Buffer Type                                                        */
            __IM uint32_t BN   : 7;    /*!< [9..3] Buffer No.                                                         */
            uint32_t           : 6;
            __IM uint32_t TMTS : 16;   /*!< [31..16] Transmit Timestamp                                               */
        } ACC0_b;
    };

    union
    {
        __IOM uint32_t ACC1;           /*!< (@ 0x00000004) Channel TX History List Access Registers 1                 */

        struct
        {
            __IM uint32_t TID  : 16;   /*!< [15..0] Transmit ID                                                       */
            __IM uint32_t TIFL : 2;    /*!< [17..16] Transmit Information Label                                       */
            uint32_t           : 14;
        } ACC1_b;
    };
} R_CANFDL_CFDTHL_Type;                /*!< Size = 8 (0x8)                                                            */

/**
 * @brief R_CANFDL_CFDRF [CFDRF] (RX FIFO Access Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t ID;              /*!< (@ 0x00000000) RX FIFO Access ID Register                                 */

        struct
        {
            __IM uint32_t RFID  : 29;  /*!< [28..0] RX FIFO Buffer ID Field                                           */
            uint32_t            : 1;
            __IM uint32_t RFRTR : 1;   /*!< [30..30] RX FIFO Buffer RTR Frame                                         */
            __IM uint32_t RFIDE : 1;   /*!< [31..31] RX FIFO Buffer IDE Bit                                           */
        } ID_b;
    };

    union
    {
        __IM uint32_t PTR;             /*!< (@ 0x00000004) RX FIFO Access Pointer Register                            */

        struct
        {
            __IM uint32_t RFTS  : 16;  /*!< [15..0] RX FIFO Timestamp Field                                           */
            uint32_t            : 12;
            __IM uint32_t RFDLC : 4;   /*!< [31..28] RX FIFO Buffer DLC Field                                         */
        } PTR_b;
    };

    union
    {
        __IM uint32_t FDSTS;           /*!< (@ 0x00000008) RX FIFO Access CAN-FD Status Register                      */

        struct
        {
            __IM uint32_t RFESI : 1;   /*!< [0..0] Error State Indicator bit                                          */
            __IM uint32_t RFBRS : 1;   /*!< [1..1] Bit Rate Switch bit                                                */
            __IM uint32_t RFFDF : 1;   /*!< [2..2] CAN FD Format bit                                                  */
            uint32_t            : 5;
            __IM uint32_t RFIFL : 2;   /*!< [9..8] RX FIFO Buffer Information Label Field                             */
            uint32_t            : 6;
            __IM uint32_t RFPTR : 16;  /*!< [31..16] RX FIFO Buffer Pointer Field                                     */
        } FDSTS_b;
    };

    union
    {
        __IM uint8_t DF[64];           /*!< (@ 0x0000000C) RX FIFO Access Data Field Registers                        */

        struct
        {
            __IM uint8_t RFDB : 8;     /*!< [7..0] RX FIFO Buffer Data Byte                                           */
        } DF_b[64];
    };
} R_CANFDL_CFDRF_Type;                 /*!< Size = 76 (0x4c)                                                          */

/**
 * @brief R_CANFDL_CFDCF [CFDCF] (Common FIFO Access Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t ID;             /*!< (@ 0x00000000) Common FIFO Access ID Register                             */

        struct
        {
            __IOM uint32_t CFID  : 29; /*!< [28..0] Common FIFO Buffer ID Field                                       */
            uint32_t             : 1;
            __IOM uint32_t CFRTR : 1;  /*!< [30..30] Common FIFO Buffer RTR Frame                                     */
            __IOM uint32_t CFIDE : 1;  /*!< [31..31] Common FIFO Buffer IDE Bit                                       */
        } ID_b;
    };

    union
    {
        __IOM uint32_t PTR;            /*!< (@ 0x00000004) Common FIFO Access Pointer Register                        */

        struct
        {
            __IOM uint32_t CFTS  : 16; /*!< [15..0] Common FIFO Timestamp Field                                       */
            uint32_t             : 12;
            __IOM uint32_t CFDLC : 4;  /*!< [31..28] Common FIFO Buffer DLC Field                                     */
        } PTR_b;
    };

    union
    {
        __IOM uint32_t FDSTS;          /*!< (@ 0x00000008) Common FIFO Access CAN-FD Status Register                  */

        struct
        {
            __IOM uint32_t CFESI : 1;  /*!< [0..0] Error State Indicator bit                                          */
            __IOM uint32_t CFBRS : 1;  /*!< [1..1] Bit Rate Switch bit                                                */
            __IOM uint32_t CFFDF : 1;  /*!< [2..2] CAN FD Format bit                                                  */
            uint32_t             : 5;
            __IOM uint32_t CFIFL : 2;  /*!< [9..8] Common FIFO Buffer Information Label Field                         */
            uint32_t             : 6;
            __IOM uint32_t CFPTR : 16; /*!< [31..16] Common FIFO Buffer Pointer Field                                 */
        } FDSTS_b;
    };

    union
    {
        __IOM uint8_t DF[64];          /*!< (@ 0x0000000C) Common FIFO Access Data Field Registers                    */

        struct
        {
            __IOM uint8_t CFDB : 8;    /*!< [7..0] Common FIFO Buffer Data Byte                                       */
        } DF_b[64];
    };
} R_CANFDL_CFDCF_Type;                 /*!< Size = 76 (0x4c)                                                          */

/**
 * @brief R_CANFDL_CFDTM [CFDTM] (TX Message Buffer Access Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t ID;             /*!< (@ 0x00000000) TX Message Buffer ID Register                              */

        struct
        {
            __IOM uint32_t TMID  : 29; /*!< [28..0] TX Message Buffer ID Field                                        */
            uint32_t             : 1;
            __IOM uint32_t TMRTR : 1;  /*!< [30..30] TX Message Buffer RTR Frame                                      */
            __IOM uint32_t TMIDE : 1;  /*!< [31..31] TX Message Buffer IDE Bit                                        */
        } ID_b;
    };

    union
    {
        __IOM uint32_t PTR;            /*!< (@ 0x00000004) TX Message Buffer Pointer Register                         */

        struct
        {
            __IOM uint32_t TMTS  : 16; /*!< [15..0] TX Message Buffer Timestamp Field                                 */
            uint32_t             : 12;
            __IOM uint32_t TMDLC : 4;  /*!< [31..28] TX Message Buffer DLC Field                                      */
        } PTR_b;
    };

    union
    {
        __IOM uint32_t FDCTR;          /*!< (@ 0x00000008) TX Message Buffer CAN-FD Control Register                  */

        struct
        {
            __IOM uint32_t TMESI : 1;  /*!< [0..0] Error State Indicator bit                                          */
            __IOM uint32_t TMBRS : 1;  /*!< [1..1] Bit Rate Switch bit                                                */
            __IOM uint32_t TMFDF : 1;  /*!< [2..2] CAN FD Format bit                                                  */
            uint32_t             : 5;
            __IOM uint32_t TMIFL : 2;  /*!< [9..8] TX Message Buffer Information Label Field                          */
            uint32_t             : 6;
            __IOM uint32_t TMPTR : 16; /*!< [31..16] TX Message Buffer Pointer Field                                  */
        } FDCTR_b;
    };

    union
    {
        __IOM uint8_t DF[64];          /*!< (@ 0x0000000C) TX Message Buffer Data Field Registers                     */

        struct
        {
            __IOM uint8_t TMDB : 8;    /*!< [7..0] TX Message Buffer Data Byte                                        */
        } DF_b[64];
    };
} R_CANFDL_CFDTM_Type;                 /*!< Size = 76 (0x4c)                                                          */

/**
 * @brief R_CANFDL_CFDRMC_RM [RM] (RX Message Buffer Access Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t ID;              /*!< (@ 0x00000000) RX Message Buffer ID Register                              */

        struct
        {
            __IM uint32_t RMID  : 29;  /*!< [28..0] RX Message Buffer ID Field                                        */
            uint32_t            : 1;
            __IM uint32_t RMRTR : 1;   /*!< [30..30] RX Message Buffer RTR Frame                                      */
            __IM uint32_t RMIDE : 1;   /*!< [31..31] RX Message Buffer IDE Bit                                        */
        } ID_b;
    };

    union
    {
        __IM uint32_t PTR;             /*!< (@ 0x00000004) RX Message Buffer Pointer Register                         */

        struct
        {
            __IM uint32_t RMTS  : 16;  /*!< [15..0] RX Message Buffer Timestamp Field                                 */
            uint32_t            : 12;
            __IM uint32_t RMDLC : 4;   /*!< [31..28] RX Message Buffer DLC Field                                      */
        } PTR_b;
    };

    union
    {
        __IM uint32_t FDSTS;           /*!< (@ 0x00000008) RX Message Buffer CAN-FD Status Register                   */

        struct
        {
            __IM uint32_t RMESI : 1;   /*!< [0..0] Error State Indicator bit                                          */
            __IM uint32_t RMBRS : 1;   /*!< [1..1] Bit Rate Switch bit                                                */
            __IM uint32_t RMFDF : 1;   /*!< [2..2] CAN FD Format bit                                                  */
            uint32_t            : 5;
            __IM uint32_t RMIFL : 2;   /*!< [9..8] RX Message Buffer Information Label Field                          */
            uint32_t            : 6;
            __IM uint32_t RMPTR : 16;  /*!< [31..16] RX Message Buffer Pointer Field                                  */
        } FDSTS_b;
    };

    union
    {
        __IM uint8_t DF[64];           /*!< (@ 0x0000000C) RX Message Buffer Data Field Registers                     */

        struct
        {
            __IM uint8_t RMDB : 8;     /*!< [7..0] RX Message Buffer Data Byte                                        */
        } DF_b[64];
    };
} R_CANFDL_CFDRMC_RM_Type;             /*!< Size = 76 (0x4c)                                                          */

/**
 * @brief R_CANFDL_CFDRMC [CFDRMC] (RX Message Buffer Access Clusters)
 */
typedef struct
{
    __IOM R_CANFDL_CFDRMC_RM_Type RM[8]; /*!< (@ 0x00000000) RX Message Buffer Access Registers                         */
    __IM uint32_t                 RESERVED[104];
} R_CANFDL_CFDRMC_Type;                  /*!< Size = 1024 (0x400)                                                       */

/**
 * @brief R_ELC_ELSEGR [ELSEGR] (Event Link Software Event Generation Register)
 */
typedef struct
{
    union
    {
        __IOM uint8_t BY;              /*!< (@ 0x00000000) Event Link Software Event Generation Register              */

        struct
        {
            __OM uint8_t SEG : 1;      /*!< [0..0] Software Event Generation                                          */
            uint8_t          : 5;
            __IOM uint8_t WE : 1;      /*!< [6..6] SEG Bit Write Enable                                               */
            __OM uint8_t  WI : 1;      /*!< [7..7] ELSEGR Register Write Disable                                      */
        } BY_b;
    };
 #if (2U == BSP_FEATURE_ELC_VERSION)
    __IM uint8_t RESERVED[3];
 #else
    __IM uint8_t RESERVED;
 #endif
} R_ELC_ELSEGR_Type;                   /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_ELC_ELSR [ELSR] (Event Link Setting Register [0..22])
 */
typedef struct
{
    union
    {
        __IOM uint16_t HA;             /*!< (@ 0x00000000) Event Link Setting Register                                */

        struct
        {
            __IOM uint16_t ELS : 9;    /*!< [8..0] Event Link Select                                                  */
            uint16_t           : 7;
        } HA_b;
    };
    __IM uint16_t RESERVED;
} R_ELC_ELSR_Type;                     /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_ETHERC_EPTPC_COMMON_TM [TM] (Timer Setting Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t STTRU;            /*!< (@ 0x00000000) Timer Start Time Setting Register                          */

        struct
        {
            __IOM uint32_t TMSTTRU : 32; /*!< [31..0] These bits hold the setting for the higher-order 32
                                          *   bits of the start time of the pulse output timer in nanoseconds.          */
        } STTRU_b;
    };

    union
    {
        __IOM uint32_t STTRL;            /*!< (@ 0x00000004) Timer Start Time Setting Register                          */

        struct
        {
            __IOM uint32_t TMSTTRL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                          *   of the start time of the pulse output timer in nanoseconds.               */
        } STTRL_b;
    };

    union
    {
        __IOM uint32_t CYCR;            /*!< (@ 0x00000008) Timer Cycle Setting Registers                              */

        struct
        {
            __IOM uint32_t TMCYCR : 30; /*!< [29..0] These bits set the cycle of the pulse output timer in
                                         *   nanoseconds. Set a value that is equivalent to at least
                                         *   four cycles of the STCA clock.                                            */
            uint32_t : 2;
        } CYCR_b;
    };

    union
    {
        __IOM uint32_t PLSR;            /*!< (@ 0x0000000C) Timer Pulse Width Setting Register                         */

        struct
        {
            __IOM uint32_t TMPLSR : 29; /*!< [28..0] These bits set the width at high level of the pulse
                                         *   signal from the timer in nanoseconds. Set a value that
                                         *   is equivalent to at least two cycles of the STCA clock.                   */
            uint32_t : 3;
        } PLSR_b;
    };
} R_ETHERC_EPTPC_COMMON_TM_Type;        /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_ETHERC_EPTPC_COMMON_PR [PR] (Local MAC Address Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t MACRU;            /*!< (@ 0x00000000) Channel Local MAC Address Register                         */

        struct
        {
            __IOM uint32_t PRMACRU : 24; /*!< [23..0] These bits hold the setting for the higher-order 24
                                          *   bits of the local MAC address for Ethernet port 0.                        */
            uint32_t : 8;
        } MACRU_b;
    };

    union
    {
        __IOM uint32_t MACRL;            /*!< (@ 0x00000004) Channel Local MAC Address Register                         */

        struct
        {
            __IOM uint32_t PRMACRL : 24; /*!< [23..0] These bits hold the setting for the higher-order 24
                                          *   bits of the local MAC address for Ethernet port 0.                        */
            uint32_t : 8;
        } MACRL_b;
    };
} R_ETHERC_EPTPC_COMMON_PR_Type;         /*!< Size = 8 (0x8)                                                            */

/**
 * @brief R_GLCDC_BG [BG] (Background Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t EN;             /*!< (@ 0x00000000) Background Plane Setting Operation Control Register        */

        struct
        {
            __IOM uint32_t EN  : 1;    /*!< [0..0] Background plane generation module operation enable                */
            uint32_t           : 7;
            __IOM uint32_t VEN : 1;    /*!< [8..8] Control of LCDC internal register value reflection to
                                        *   internal operations                                                       */
            uint32_t             : 7;
            __IOM uint32_t SWRST : 1;  /*!< [16..16] Entire module SW reset control                                   */
            uint32_t             : 15;
        } EN_b;
    };

    union
    {
        __IOM uint32_t PERI;           /*!< (@ 0x00000004) Background Plane Setting Free-Running Period
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t FH : 11;    /*!< [10..0] Background plane horizontal synchronization signal period
                                        *   on the basis of pixel clock (PXCLK).                                      */
            uint32_t          : 5;
            __IOM uint32_t FV : 11;    /*!< [26..16] Background plane vertical synchronization signal period
                                        *   on the basis of line.                                                     */
            uint32_t : 5;
        } PERI_b;
    };

    union
    {
        __IOM uint32_t SYNC;           /*!< (@ 0x00000008) Background Plane Setting Synchronization Position
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t HP : 4;     /*!< [3..0] Background plane horizontal synchronization signal assertion
                                        *   position on the basis of pixel clock (PXCLK).                             */
            uint32_t          : 12;
            __IOM uint32_t VP : 4;     /*!< [19..16] Background plane vertical synchronization signal assertion
                                        *   position on the basis of line.                                            */
            uint32_t : 12;
        } SYNC_b;
    };

    union
    {
        __IOM uint32_t VSIZE;          /*!< (@ 0x0000000C) Background Plane Setting Full Image Vertical
                                        *                  Size Register                                              */

        struct
        {
            __IOM uint32_t VW : 11;    /*!< [10..0] Background plane vertical valid pixel width on the basis
                                        *   of line                                                                   */
            uint32_t          : 5;
            __IOM uint32_t VP : 11;    /*!< [26..16] Background plane vertical valid pixel start position
                                        *   on the basis of line                                                      */
            uint32_t : 5;
        } VSIZE_b;
    };

    union
    {
        __IOM uint32_t HSIZE;          /*!< (@ 0x00000010) Background Plane Setting Full Image Horizontal
                                        *                  Size Register                                              */

        struct
        {
            __IOM uint32_t HW : 11;    /*!< [10..0] Background plane horizontall valid pixel width on the
                                        *   basis of pixel clock (PXCLK) Note: When serial RGB is selected
                                        *   as the output format for the output control block, add
                                        *   two to the horizontal enable signal width and set the resulting
                                        *   value to this field.                                                      */
            uint32_t          : 5;
            __IOM uint32_t HP : 11;    /*!< [26..16] Background plane horizontal valid pixel start position
                                        *   on the basis of pixel clock (PXCLK).                                      */
            uint32_t : 5;
        } HSIZE_b;
    };

    union
    {
        __IOM uint32_t BGC;            /*!< (@ 0x00000014) Background Plane Setting Background Color Register         */

        struct
        {
            __IOM uint32_t B : 8;      /*!< [7..0] B value for background plane valid pixel area Unsigned;
                                        *   8-bit integer                                                             */
            __IOM uint32_t G : 8;      /*!< [15..8] G value for background plane valid pixel area Unsigned;
                                        *   8-bit integer                                                             */
            __IOM uint32_t R : 8;      /*!< [23..16] R value for background plane valid pixel area. Unsigned;
                                        *   8-bit integer.                                                            */
            uint32_t : 8;
        } BGC_b;
    };

    union
    {
        __IM uint32_t MON;             /*!< (@ 0x00000018) Background Plane Setting Status Monitor Register           */

        struct
        {
            __IM uint32_t EN  : 1;     /*!< [0..0] Background plane generation module operation state monitor.        */
            uint32_t          : 7;
            __IM uint32_t VEN : 1;     /*!< [8..8] Entire module internal operation reflection control signal
                                        *   monitor. The signal state for controlling reflection of
                                        *   the register values to the internal operations upon assertion
                                        *   of the vertical synchronization signal.                                   */
            uint32_t            : 7;
            __IM uint32_t SWRST : 1;   /*!< [16..16] Entire module SW reset state monitor.                            */
            uint32_t            : 15;
        } MON_b;
    };
} R_GLCDC_BG_Type;                     /*!< Size = 28 (0x1c)                                                          */

/**
 * @brief R_GLCDC_GR [GR] (Layer Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t VEN;            /*!< (@ 0x00000000) Graphics Register Update Control Register                  */

        struct
        {
            __IOM uint32_t PVEN : 1;   /*!< [0..0] Control of graphics n module register value reflection
                                        *   to internal operations. Reflection of the register values
                                        *   to the internal operation at the assertion of the vertical
                                        *   synchronization signal (VS).                                              */
            uint32_t : 31;
        } VEN_b;
    };

    union
    {
        __IOM uint32_t FLMRD;          /*!< (@ 0x00000004) Graphics Frame Buffer Read Control Register                */

        struct
        {
            __IOM uint32_t RENB : 1;   /*!< [0..0] Graphics data (frame buffer data) read enable.                     */
            uint32_t            : 31;
        } FLMRD_b;
    };

    union
    {
        __IM uint32_t FLM1;            /*!< (@ 0x00000008) Graphics Frame Buffer Control Register 1                   */

        struct
        {
            __IM uint32_t BSTMD : 2;   /*!< [1..0] Burst transfer control for graphics data (frame buffer
                                        *   data) access                                                              */
            uint32_t : 30;
        } FLM1_b;
    };

    union
    {
        __IOM uint32_t FLM2;           /*!< (@ 0x0000000C) Graphics Frame Buffer Control Register 2                   */

        struct
        {
            __IOM uint32_t BASE : 32;  /*!< [31..0] Base address for accessing graphics data (frame buffer
                                        *   data) Set the head address in the frame buffer where graphics
                                        *   data is to be stored. GRn_FLM2.BASE[5:0] should be fixed
                                        *   to 0 during 64-byte burst transfer.                                       */
        } FLM2_b;
    };

    union
    {
        __IOM uint32_t FLM3;           /*!< (@ 0x00000010) Graphics Frame Buffer Control Register 3                   */

        struct
        {
            uint32_t             : 16;
            __IOM uint32_t LNOFF : 16; /*!< [31..16] Macro line offset address for accessing graphics data
                                        *   (frame buffer data) Signed; 16-bit integer                                */
        } FLM3_b;
    };
    __IM uint32_t RESERVED;

    union
    {
        __IOM uint32_t FLM5;             /*!< (@ 0x00000018) Graphics Frame Buffer Control Register 5                   */

        struct
        {
            __IOM uint32_t DATANUM : 16; /*!< [15..0] Number of data transfer times per line for accessing
                                          *   graphics data (frame buffer data), where one transfer is
                                          *   defined as 16-beat burst access (64-byte boundary)                        */
            __IOM uint32_t LNNUM : 11;   /*!< [26..16] Number of lines per frame for accessing graphics data
                                          *   (frame buffer data).                                                      */
            uint32_t : 5;
        } FLM5_b;
    };

    union
    {
        __IOM uint32_t FLM6;           /*!< (@ 0x0000001C) Graphics Frame Buffer Control Register 6                   */

        struct
        {
            uint32_t              : 28;
            __IOM uint32_t FORMAT : 3; /*!< [30..28] Data format for accessing graphics data (frame buffer
                                        *   data).                                                                    */
            uint32_t : 1;
        } FLM6_b;
    };

    union
    {
        __IOM uint32_t AB1;               /*!< (@ 0x00000020) Graphics Alpha Blending Control Register 1                 */

        struct
        {
            __IOM uint32_t DISPSEL   : 2; /*!< [1..0] Graphics display plane control.                                    */
            uint32_t                 : 2;
            __IOM uint32_t GRCDISPON : 1; /*!< [4..4] Graphics image area border display control.                        */
            uint32_t                 : 3;
            __IOM uint32_t ARCDISPON : 1; /*!< [8..8] Image area border display control for rectangular area
                                           *   alpha blending.                                                           */
            uint32_t             : 3;
            __IOM uint32_t ARCON : 1;     /*!< [12..12] Rectangular area alpha blending control.                         */
            uint32_t             : 19;
        } AB1_b;
    };

    union
    {
        __IOM uint32_t AB2;            /*!< (@ 0x00000024) Graphics Alpha Blending Control Register 2                 */

        struct
        {
            __IOM uint32_t GRCVW : 11; /*!< [10..0] Vertical width of graphics image area.                            */
            uint32_t             : 5;
            __IOM uint32_t GRCVS : 11; /*!< [26..16] Vertical start position of graphics image area.                  */
            uint32_t             : 5;
        } AB2_b;
    };

    union
    {
        __IOM uint32_t AB3;            /*!< (@ 0x00000028) Graphics Alpha Blending Control Register 3                 */

        struct
        {
            __IOM uint32_t GRCHW : 11; /*!< [10..0] Horizontal width of graphics image area.                          */
            uint32_t             : 5;
            __IOM uint32_t GRCHS : 11; /*!< [26..16] Horizontal start position of graphics image area.                */
            uint32_t             : 5;
        } AB3_b;
    };

    union
    {
        __IOM uint32_t AB4;            /*!< (@ 0x0000002C) Graphics Alpha Blending Control Register 4                 */

        struct
        {
            __IOM uint32_t ARCVW : 11; /*!< [10..0] Vertical width of rectangular area alpha blending image
                                        *   area.                                                                     */
            uint32_t             : 5;
            __IOM uint32_t ARCVS : 11; /*!< [26..16] Vertical start position of rectangular area alpha blending
                                        *   image area                                                                */
            uint32_t : 5;
        } AB4_b;
    };

    union
    {
        __IOM uint32_t AB5;            /*!< (@ 0x00000030) Graphics Alpha Blending Control Register 5                 */

        struct
        {
            __IOM uint32_t ARCHW : 11; /*!< [10..0] Horizontal width of rectangular area alpha blending
                                        *   image area.                                                               */
            uint32_t             : 5;
            __IOM uint32_t ARCHS : 11; /*!< [26..16] Horizontal start position of rectangular area alpha
                                        *   blending image area.                                                      */
            uint32_t : 5;
        } AB5_b;
    };

    union
    {
        __IOM uint32_t AB6;             /*!< (@ 0x00000034) Graphics Alpha Blending Control Register 6                 */

        struct
        {
            __IOM uint32_t ARCRATE : 8; /*!< [7..0] Frame rate for alpha blending in rectangular area.                 */
            uint32_t               : 8;
            __IOM uint32_t ARCCOEF : 9; /*!< [24..16] Alpha coefficient for alpha blending in rectangular
                                         *   area (-255 to 255). [8]: Sign (0: addition, 1: subtraction)
                                         *   [7:0]: Variation (absolute value)                                         */
            uint32_t : 7;
        } AB6_b;
    };

    union
    {
        __IOM uint32_t AB7;            /*!< (@ 0x00000038) Graphics Alpha Blending Control Register 7                 */

        struct
        {
            __IOM uint32_t CKON   : 1; /*!< [0..0] RGB-index chroma-key processing control.                           */
            uint32_t              : 15;
            __IOM uint32_t ARCDEF : 8; /*!< [23..16] Initial alpha value for alpha blending in rectangular
                                        *   area.                                                                     */
            uint32_t : 8;
        } AB7_b;
    };

    union
    {
        __IOM uint32_t AB8;            /*!< (@ 0x0000003C) Graphics Alpha Blending Control Register 8                 */

        struct
        {
            __IOM uint32_t CKKR : 8;   /*!< [7..0] R signal for RGB-index chroma-key processing Unsigned;
                                        *   8 bits.                                                                   */
            __IOM uint32_t CKKB : 8;   /*!< [15..8] B signal for RGB-index chroma-key processing Unsigned;
                                        *   8 bits.                                                                   */
            __IOM uint32_t CKKG : 8;   /*!< [23..16] G signal for RGB-index chroma-key processing Unsigned;
                                        *   8 bits.                                                                   */
            uint32_t : 8;
        } AB8_b;
    };

    union
    {
        __IOM uint32_t AB9;            /*!< (@ 0x00000040) Graphics Alpha Blending Control Register 9                 */

        struct
        {
            __IOM uint32_t CKR : 8;    /*!< [7..0] R value after RGB-index chroma-key processing replacement
                                        *   Unsigned; 8 bits.                                                         */
            __IOM uint32_t CKB : 8;    /*!< [15..8] B value after RGB-index chroma-key processing replacement
                                        *   Unsigned; 8 bits.                                                         */
            __IOM uint32_t CKG : 8;    /*!< [23..16] G value after RGB-index chroma-key processing replacement
                                        *   Unsigned; 8 bits.                                                         */
            __IOM uint32_t CKA : 8;    /*!< [31..24] A value after RGB-index chroma-key processing replacement.       */
        } AB9_b;
    };
    __IM uint32_t RESERVED1[2];

    union
    {
        __IOM uint32_t BASE;           /*!< (@ 0x0000004C) Graphics Background Color Control Register                 */

        struct
        {
            __IOM uint32_t R : 8;      /*!< [7..0] Background color R value Unsigned; 8 bits                          */
            __IOM uint32_t B : 8;      /*!< [15..8] Background color B value Unsigned; 8 bits                         */
            __IOM uint32_t G : 8;      /*!< [23..16] Background color G value Unsigned; 8 bits                        */
            uint32_t         : 8;
        } BASE_b;
    };

    union
    {
        __IOM uint32_t CLUTINT;        /*!< (@ 0x00000050) Graphics CLUT Table Interrupt Control Register             */

        struct
        {
            __IOM uint32_t LINE : 11;  /*!< [10..0] Number of detection lines                                         */
            uint32_t            : 5;
            __IOM uint32_t SEL  : 1;   /*!< [16..16] CLUT table control                                               */
            uint32_t            : 15;
        } CLUTINT_b;
    };

    union
    {
        __IM uint32_t MON;             /*!< (@ 0x00000054) Graphics Status Monitor Register                           */

        struct
        {
            __IM uint32_t ARCST   : 1; /*!< [0..0] Status monitor for alpha blending in rectangular area              */
            uint32_t              : 15;
            __IM uint32_t UNDFLST : 1; /*!< [16..16] Status monitor for underflow                                     */
            uint32_t              : 15;
        } MON_b;
    };
    __IM uint32_t RESERVED2[42];
} R_GLCDC_GR_Type;                     /*!< Size = 256 (0x100)                                                        */

/**
 * @brief R_GLCDC_GAM [GAM] (Gamma Settings)
 */
typedef struct
{
    union
    {
        __IOM uint32_t LATCH;          /*!< (@ 0x00000000) Gamma Register Update Control Register                     */

        struct
        {
            __IOM uint32_t VEN : 1;    /*!< [0..0] Control of gamma correction x module register value reflection
                                        *   to internal operations. The register values to be reflected
                                        *   to the internal operations at the assertion of the vertical
                                        *   synchronization signal (VS).                                              */
            uint32_t : 31;
        } LATCH_b;
    };

    union
    {
        __IOM uint32_t GAM_SW;         /*!< (@ 0x00000004) Gamma Correction Block Function Switch Register            */

        struct
        {
            __IOM uint32_t GAMON : 1;  /*!< [0..0] Gamma correction on/off control                                    */
            uint32_t             : 31;
        } GAM_SW_b;
    };

    union
    {
        __IOM uint32_t LUT[8];         /*!< (@ 0x00000008) Gamma Correction Block Table Setting Register              */

        struct
        {
            __IOM uint32_t _HIGH : 11; /*!< [10..0] Gain value of area 0. Unsigned 11-bit fixed point.                */
            uint32_t             : 5;
            __IOM uint32_t _LOW  : 11; /*!< [26..16] Gain value of area 0. Unsigned 11-bit fixed point.               */
            uint32_t             : 5;
        } LUT_b[8];
    };

    union
    {
        __IOM uint32_t AREA[5];        /*!< (@ 0x00000028) Gamma Correction Block Area Setting Register               */

        struct
        {
            __IOM uint32_t _HIGH : 10; /*!< [9..0] Start threshold of area 1 Unsigned 10-bit integer                  */
            __IOM uint32_t _MID  : 10; /*!< [19..10] Start threshold of area 1 Unsigned 10-bit integer                */
            __IOM uint32_t _LOW  : 10; /*!< [29..20] Start threshold of area 1 Unsigned 10-bit integer                */
            uint32_t             : 2;
        } AREA_b[5];
    };
    __IM uint32_t RESERVED;
} R_GLCDC_GAM_Type;                    /*!< Size = 64 (0x40)                                                          */

/**
 * @brief R_GLCDC_OUT [OUT] (Output Control Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t VLATCH;         /*!< (@ 0x00000000) Output Control Block Register Update Control
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t VEN : 1;    /*!< [0..0] Control of output control module register value reflection
                                        *   to internal operations. The register values to be reflected
                                        *   to the internal operations at the assertion of the vertical
                                        *   synchronization signal (VS).                                              */
            uint32_t : 31;
        } VLATCH_b;
    };

    union
    {
        __IOM uint32_t SET;              /*!< (@ 0x00000004) Output Control Block Output Interface Register             */

        struct
        {
            __IOM uint32_t PHASE    : 2; /*!< [1..0] Data delay in serial RGB format (based on OUTCLK)                  */
            uint32_t                : 2;
            __IOM uint32_t DIRSEL   : 1; /*!< [4..4] Invalid data position control in serial RGB format                 */
            uint32_t                : 3;
            __IOM uint32_t FRQSEL   : 2; /*!< [9..8] Clock frequency division control                                   */
            uint32_t                : 2;
            __IOM uint32_t FORMAT   : 2; /*!< [13..12] Output format select                                             */
            uint32_t                : 10;
            __IOM uint32_t SWAPON   : 1; /*!< [24..24] Pixel order control                                              */
            uint32_t                : 3;
            __IOM uint32_t ENDIANON : 1; /*!< [28..28] Bit endian change control                                        */
            uint32_t                : 3;
        } SET_b;
    };

    union
    {
        __IOM uint32_t BRIGHT1;        /*!< (@ 0x00000008) Output Control Block Brightness Correction Register
                                        *                  1                                                          */

        struct
        {
            __IOM uint32_t BRTG : 10;  /*!< [9..0] Brightness (DC) adjustment of G signal Unsigned; 10 bits;
                                        +512 with offset; integer                                                 */
            uint32_t : 22;
        } BRIGHT1_b;
    };

    union
    {
        __IOM uint32_t BRIGHT2;        /*!< (@ 0x0000000C) Output Control Block Brightness Correction Register
                                        *                  2                                                          */

        struct
        {
            __IOM uint32_t BRTR : 10;  /*!< [9..0] Brightness (DC) adjustment of R signal Unsigned; 10 bits;
                                        +512 with offset; integer                                                 */
            uint32_t            : 6;
            __IOM uint32_t BRTB : 10;  /*!< [25..16] Brightness (DC) adjustment of B signal Unsigned; 10
                                        *   bits; +512 with offset; integer                                           */
            uint32_t : 6;
        } BRIGHT2_b;
    };

    union
    {
        __IOM uint32_t CONTRAST;       /*!< (@ 0x00000010) Output Control Block Contrast Correction Register          */

        struct
        {
            __IOM uint32_t CONTR : 8;  /*!< [7..0] Contrast (GAIN) adjustment of R signal Unsigned; 8 bits
                                        *   fixed point                                                               */
            __IOM uint32_t CONTB : 8;  /*!< [15..8] Contrast (GAIN) adjustment of B signal Unsigned; 8 bits
                                        *   fixed point                                                               */
            __IOM uint32_t CONTG : 8;  /*!< [23..16] Contrast (GAIN) adjustment of G signal Unsigned; 8
                                        *   bits fixed point.                                                         */
            uint32_t : 8;
        } CONTRAST_b;
    };

    union
    {
        __IOM uint32_t PDTHA;          /*!< (@ 0x00000014) Output Control Block Panel Dither Correction
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t PD : 2;     /*!< [1..0] Pattern value (D) of 2 x 2 pattern dither Unsigned 2-bit
                                        *   integer                                                                   */
            uint32_t          : 2;
            __IOM uint32_t PC : 2;     /*!< [5..4] Pattern value (C) of 2 x 2 pattern dither Unsigned 2-bit
                                        *   integer                                                                   */
            uint32_t          : 2;
            __IOM uint32_t PB : 2;     /*!< [9..8] Pattern value (B) of 2 x 2 pattern dither Unsigned 2-bit
                                        *   integer                                                                   */
            uint32_t          : 2;
            __IOM uint32_t PA : 2;     /*!< [13..12] Pattern value (A) of 2 x 2 pattern dither Unsigned
                                        *   2-bit integer                                                             */
            uint32_t            : 2;
            __IOM uint32_t FORM : 2;   /*!< [17..16] Output format select                                             */
            uint32_t            : 2;
            __IOM uint32_t SEL  : 2;   /*!< [21..20] Operation mode                                                   */
            uint32_t            : 10;
        } PDTHA_b;
    };
    __IM uint32_t RESERVED[3];

    union
    {
        __IOM uint32_t CLKPHASE;       /*!< (@ 0x00000024) Output Control Block Output Phase Control Register         */

        struct
        {
            uint32_t                 : 3;
            __IOM uint32_t TCON3EDGE : 1; /*!< [3..3] LCD_TCON3 Output Phase Control                                     */
            __IOM uint32_t TCON2EDGE : 1; /*!< [4..4] LCD_TCON2 Output Phase Control                                     */
            __IOM uint32_t TCON1EDGE : 1; /*!< [5..5] LCD_TCON1 Output Phase Control                                     */
            __IOM uint32_t TCON0EDGE : 1; /*!< [6..6] LCD_TCON0 Output Phase Control                                     */
            uint32_t                 : 1;
            __IOM uint32_t LCDEDGE   : 1; /*!< [8..8] LCD_DATA Output Phase Control                                      */
            uint32_t                 : 3;
            __IOM uint32_t FRONTGAM  : 1; /*!< [12..12] Correction control                                               */
            uint32_t                 : 19;
        } CLKPHASE_b;
    };
} R_GLCDC_OUT_Type;                       /*!< Size = 40 (0x28)                                                          */

/**
 * @brief R_GLCDC_TCON [TCON] (Timing Control Registers)
 */
typedef struct
{
    __IM uint32_t RESERVED;

    union
    {
        __IOM uint32_t TIM;             /*!< (@ 0x00000004) TCON Reference Timing Setting Register                     */

        struct
        {
            __IOM uint32_t OFFSET : 11; /*!< [10..0] Horizontal synchronization signal generation reference
                                         *   timing Sets the offset from the assertion of the internal
                                         *   horizontal synchronization signal in terms of pixels.                     */
            uint32_t            : 5;
            __IOM uint32_t HALF : 11;   /*!< [26..16] Vertical synchronization signal generation change timing
                                         *   Sets the delay from the assertion of the internal horizontal
                                         *   synchronization signal in terms of pixels.                                */
            uint32_t : 5;
        } TIM_b;
    };

    union
    {
        __IOM uint32_t STVA1;          /*!< (@ 0x00000008) TCON Vertical Timing Setting Register A1                   */

        struct
        {
            __IOM uint32_t VW : 11;    /*!< [10..0] STVx1 second change timing Sets the signal assertion
                                        *   width.                                                                    */
            uint32_t          : 5;
            __IOM uint32_t VS : 11;    /*!< [26..16] STVx1 first change timing                                        */
            uint32_t          : 5;
        } STVA1_b;
    };

    union
    {
        __IOM uint32_t STVA2;          /*!< (@ 0x0000000C) TCON Vertical Timing Setting Register A2                   */

        struct
        {
            __IOM uint32_t SEL : 3;    /*!< [2..0] Output signal select control for VSOUT (controlled by
                                        *   TCON_STVA2 register)/VEOUT (controlled by the TCON_STVB2
                                        *   register) pin                                                             */
            uint32_t           : 1;
            __IOM uint32_t INV : 1;    /*!< [4..4] STVx signal polarity inversion control                             */
            uint32_t           : 27;
        } STVA2_b;
    };

    union
    {
        __IOM uint32_t STVB1;          /*!< (@ 0x00000010) TCON Vertical Timing Setting Register B1                   */

        struct
        {
            __IOM uint32_t VW : 11;    /*!< [10..0] STVx1 second change timing Sets the signal assertion
                                        *   width.                                                                    */
            uint32_t          : 5;
            __IOM uint32_t VS : 11;    /*!< [26..16] STVx1 first change timing                                        */
            uint32_t          : 5;
        } STVB1_b;
    };

    union
    {
        __IOM uint32_t STVB2;          /*!< (@ 0x00000014) TCON Vertical Timing Setting Register B2                   */

        struct
        {
            __IOM uint32_t SEL : 3;    /*!< [2..0] Output signal select control for VSOUT (controlled by
                                        *   TCON_STVA2 register)/VEOUT (controlled by the TCON_STVB2
                                        *   register) pin                                                             */
            uint32_t           : 1;
            __IOM uint32_t INV : 1;    /*!< [4..4] STVx signal polarity inversion control                             */
            uint32_t           : 27;
        } STVB2_b;
    };

    union
    {
        __IOM uint32_t STHA1;          /*!< (@ 0x00000018) TCON Horizontal Timing Setting Register STHA1              */

        struct
        {
            __IOM uint32_t HW : 11;    /*!< [10..0] STHx1 second change timing. Sets the signal assertion
                                        *   width.                                                                    */
            uint32_t          : 5;
            __IOM uint32_t HS : 11;    /*!< [26..16] STHx1 first change timing                                        */
            uint32_t          : 5;
        } STHA1_b;
    };

    union
    {
        __IOM uint32_t STHA2;          /*!< (@ 0x0000001C) TCON Horizontal Timing Setting Register STHA2              */

        struct
        {
            __IOM uint32_t SEL : 3;    /*!< [2..0] Output signal select control for LCD_TCON2 (controlled
                                        *   by TCON_STHA2 register)/LCD_TCON3 (controlled by the TCON_STHB2
                                        *   register) pin.                                                            */
            uint32_t             : 1;
            __IOM uint32_t INV   : 1;  /*!< [4..4] STVx signal polarity inversion control.                            */
            uint32_t             : 3;
            __IOM uint32_t HSSEL : 1;  /*!< [8..8] STHx signal generation reference timing control.                   */
            uint32_t             : 23;
        } STHA2_b;
    };

    union
    {
        __IOM uint32_t STHB1;          /*!< (@ 0x00000020) TCON Horizontal Timing Setting Register STHB1              */

        struct
        {
            __IOM uint32_t HW : 11;    /*!< [10..0] STHx1 second change timing. Sets the signal assertion
                                        *   width.                                                                    */
            uint32_t          : 5;
            __IOM uint32_t HS : 11;    /*!< [26..16] STHx1 first change timing                                        */
            uint32_t          : 5;
        } STHB1_b;
    };

    union
    {
        __IOM uint32_t STHB2;          /*!< (@ 0x00000024) TCON Horizontal Timing Setting Register STHB2              */

        struct
        {
            __IOM uint32_t SEL : 3;    /*!< [2..0] Output signal select control for LCD_TCON2 (controlled
                                        *   by TCON_STHA2 register)/LCD_TCON3 (controlled by the TCON_STHB2
                                        *   register) pin.                                                            */
            uint32_t             : 1;
            __IOM uint32_t INV   : 1;  /*!< [4..4] STVx signal polarity inversion control.                            */
            uint32_t             : 3;
            __IOM uint32_t HSSEL : 1;  /*!< [8..8] STHx signal generation reference timing control.                   */
            uint32_t             : 23;
        } STHB2_b;
    };

    union
    {
        __IOM uint32_t DE;             /*!< (@ 0x00000028) TCON Data Enable Polarity Setting Register                 */

        struct
        {
            __IOM uint32_t INV : 1;    /*!< [0..0] DE signal polarity inversion control.                              */
            uint32_t           : 31;
        } DE_b;
    };
} R_GLCDC_TCON_Type;                   /*!< Size = 44 (0x2c)                                                          */

/**
 * @brief R_GLCDC_SYSCNT [SYSCNT] (GLCDC System Control Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t DTCTEN;            /*!< (@ 0x00000000) System control block State Detection Control
                                           *                  Register                                                   */

        struct
        {
            __IOM uint32_t VPOSDTC   : 1; /*!< [0..0] Specified line detection control                                   */
            __IOM uint32_t L1UNDFDTC : 1; /*!< [1..1] Graphics 1 underflow detection control                             */
            __IOM uint32_t L2UNDFDTC : 1; /*!< [2..2] Graphics 2 underflow detection control                             */
            uint32_t                 : 29;
        } DTCTEN_b;
    };

    union
    {
        __IOM uint32_t INTEN;               /*!< (@ 0x00000004) System control block Interrupt Request Enable
                                             *                  Control Register                                           */

        struct
        {
            __IOM uint32_t VPOSINTEN   : 1; /*!< [0..0] Interrupt request signal GLCDC_VPOS enable control.                */
            __IOM uint32_t L1UNDFINTEN : 1; /*!< [1..1] Interrupt request signal GLCDC_L1UNDF enable control.              */
            __IOM uint32_t L2UNDFINTEN : 1; /*!< [2..2] Interrupt request signal GLCDC_L2UNDF enable control.              */
            uint32_t                   : 29;
        } INTEN_b;
    };

    union
    {
        __IOM uint32_t STCLR;             /*!< (@ 0x00000008) System control block Status Clear Register                 */

        struct
        {
            __IOM uint32_t VPOSCLR   : 1; /*!< [0..0] Graphics 2 specified line detection flag clear field               */
            __IOM uint32_t L1UNDFCLR : 1; /*!< [1..1] Graphics 1 underflow detection flag clear field                    */
            __IOM uint32_t L2UNDFCLR : 1; /*!< [2..2] Graphics 2 underflow detection flag clear field                    */
            uint32_t                 : 29;
        } STCLR_b;
    };

    union
    {
        __IM uint32_t STMON;           /*!< (@ 0x0000000C) System control block Status Monitor Register               */

        struct
        {
            __IM uint32_t VPOS   : 1;  /*!< [0..0] Graphics 2 specified line detection flag                           */
            __IM uint32_t L1UNDF : 1;  /*!< [1..1] Graphics 1 underflow detection flag                                */
            __IM uint32_t L2UNDF : 1;  /*!< [2..2] Graphics 2 underflow detection flag                                */
            uint32_t             : 29;
        } STMON_b;
    };

    union
    {
        __IOM uint32_t PANEL_CLK;      /*!< (@ 0x00000010) System control block Version and Panel Clock
                                        *                  Control Register                                           */

        struct
        {
            __IOM uint32_t DCDR : 6;   /*!< [5..0] Clock division ratio setting control Refer toTable 2.7.1
                                        *   for details about setting value. Note: Settings that are
                                        *   not listed in table 2.7.1 are prohibited.                                 */
            __IOM uint32_t CLKEN : 1;  /*!< [6..6] Panel clock output enable control Note: Before changing
                                        *   the PIXSEL,CLKSEL or DCDR bit, this bit must be set to
                                        *   0.                                                                        */
            uint32_t              : 1;
            __IOM uint32_t CLKSEL : 1; /*!< [8..8] Panel clock supply source select                                   */
            uint32_t              : 3;
            __IOM uint32_t PIXSEL : 1; /*!< [12..12] Pixel clock select control. Must be set to the same
                                        *   value as OUT_SET.FRQSEL[1].                                               */
            uint32_t          : 3;
            __IM uint32_t VER : 16;    /*!< [31..16] Version information Version information of the GLCDC             */
        } PANEL_CLK_b;
    };
} R_GLCDC_SYSCNT_Type;                 /*!< Size = 20 (0x14)                                                          */

/**
 * @brief R_GPT_ODC_GTDLYR [GTDLYR] (PWM DELAY RISING)
 */
typedef struct
{
    union
    {
        __IOM uint16_t A;              /*!< (@ 0x00000000) GTIOCA Output Delay Register                               */

        struct
        {
            __IOM uint16_t DLY : 5;    /*!< [4..0] GTIOCnA Output Rising Edge Delay Setting                           */
            uint16_t           : 11;
        } A_b;
    };

    union
    {
        __IOM uint16_t B;              /*!< (@ 0x00000002) GTIOCB Output Delay Register                               */

        struct
        {
            __IOM uint16_t DLY : 5;    /*!< [4..0] GTIOCnA Output Rising Edge Delay Setting                           */
            uint16_t           : 11;
        } B_b;
    };
} R_GPT_ODC_GTDLYR_Type;               /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_IIC0_SAR [SAR] (Slave Address Registers)
 */
typedef struct
{
    union
    {
        __IOM uint8_t L;               /*!< (@ 0x00000000) Slave Address Register L                                   */

        struct
        {
            __IOM uint8_t SVA : 8;     /*!< [7..0] A slave address is set.7-Bit Address = SVA[7:1] 10-Bit
                                        *   Address = { SVA9,SVA8,SVA[7:0] }                                          */
        } L_b;
    };

    union
    {
        __IOM uint8_t U;               /*!< (@ 0x00000001) Slave Address Register U                                   */

        struct
        {
            __IOM uint8_t FS   : 1;    /*!< [0..0] 7-Bit/10-Bit Address Format Selection                              */
            __IOM uint8_t SVA8 : 1;    /*!< [1..1] 10-Bit Address(bit8)                                               */
            __IOM uint8_t SVA9 : 1;    /*!< [2..2] 10-Bit Address(bit9)                                               */
            uint8_t            : 5;
        } U_b;
    };
} R_IIC0_SAR_Type;                     /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_IIRFA_IIRCH [IIRCH] (Channel Registers)
 */
typedef struct
{
    __OM uint32_t INP;                  /*!< (@ 0x00000000) Channel Input Register                                     */
    __IM uint32_t OUT;                  /*!< (@ 0x00000004) Channel Output Register                                    */

    union
    {
        __IOM uint32_t CNT;             /*!< (@ 0x00000008) Channel Control Register                                   */

        struct
        {
            __IOM uint32_t STGSEL : 32; /*!< [31..0] Stage selection bit                                               */
        } CNT_b;
    };

    union
    {
        __IOM uint8_t INT;             /*!< (@ 0x0000000C) Channel Interrupt Enable Register                          */

        struct
        {
            uint8_t               : 1;
            __IOM uint8_t CPRCFIE : 1; /*!< [1..1] Channel processing completion interrupt enable bit                 */
            __IOM uint8_t ORDYIE  : 1; /*!< [2..2] Output data preparation completion interrupt enable bit            */
            __IOM uint8_t CERRIE  : 1; /*!< [3..3] Operation error interrupt enable bit                               */
            uint8_t               : 4;
        } INT_b;
    };

    union
    {
        __IM uint8_t STS;              /*!< (@ 0x0000000D) Channel Status Register                                    */

        struct
        {
            __IM uint8_t CPRCS  : 1;   /*!< [0..0] Channel processing status flag                                     */
            __IM uint8_t CPRCFF : 1;   /*!< [1..1] Channel processing completion flag                                 */
            __IM uint8_t ORDYF  : 1;   /*!< [2..2] Output data preparation completion flag                            */
            __IM uint8_t CERRF  : 1;   /*!< [3..3] Operation error flag                                               */
            uint8_t             : 4;
        } STS_b;
    };

    union
    {
        __OM uint8_t FCLR;             /*!< (@ 0x0000000E) Channel Flag Clear Register                                */

        struct
        {
            uint8_t                : 1;
            __OM uint8_t CPRCFFCLR : 1; /*!< [1..1] Channel processing completion flag clear bit                       */
            uint8_t                : 1;
            __OM uint8_t CERRFCLR  : 1; /*!< [3..3] Operation error flag clear bit                                     */
            uint8_t                : 4;
        } FCLR_b;
    };
    __IM uint8_t RESERVED;
} R_IIRFA_IIRCH_Type;                  /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_IIRFA_IIRSTG [IIRSTG] (Stage Registers)
 */
typedef struct
{
    __IOM uint32_t B0;                 /*!< (@ 0x00000000) Stage Coefficient b0 Register                              */
    __IOM uint32_t B1;                 /*!< (@ 0x00000004) Stage Coefficient b1 Register                              */
    __IOM uint32_t B2;                 /*!< (@ 0x00000008) Stage Coefficient b2 Register                              */
    __IOM uint32_t A1;                 /*!< (@ 0x0000000C) Stage Coefficient a1 Register                              */
    __IOM uint32_t A2;                 /*!< (@ 0x00000010) Stage Coefficient a2 Register                              */
    __IOM uint32_t D0;                 /*!< (@ 0x00000014) Stage Delay Data D0 Register                               */
    __IOM uint32_t D1;                 /*!< (@ 0x00000018) Stage Delay Data D1 Register                               */
    __IM uint32_t  RESERVED;
} R_IIRFA_IIRSTG_Type;                 /*!< Size = 32 (0x20)                                                          */

/**
 * @brief R_MPU_MMPU_MMPU_REGION [REGION] (Address Region registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t C;              /*!< (@ 0x00000000) Access Control Register                                    */

        struct
        {
            __IOM uint16_t ENABLE : 1; /*!< [0..0] Region enable                                                      */
            __IOM uint16_t RP     : 1; /*!< [1..1] Read protection                                                    */
            __IOM uint16_t WP     : 1; /*!< [2..2] Write protection                                                   */
            uint16_t              : 13;
        } C_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint32_t S;                /*!< (@ 0x00000004) Start Address Register                                     */

        struct
        {
            __IOM uint32_t MMPUSmn : 32; /*!< [31..0] Address where the region starts, for use in region determination.NOTE:
                                          *   The low-order 2 bits are fixed to 0.                                      */
        } S_b;
    };

    union
    {
        __IOM uint32_t E;                /*!< (@ 0x00000008) End Address Register                                       */

        struct
        {
            __IOM uint32_t MMPUEmn : 32; /*!< [31..0] Region end address registerAddress where the region
                                          *   end, for use in region determination.NOTE: The low-order
                                          *   2 bits are fixed to 1.                                                    */
        } E_b;
    };
    __IM uint32_t RESERVED1;
} R_MPU_MMPU_MMPU_REGION_Type;           /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_MPU_MMPU_MMPU [MMPU] (Bus Master MPU Registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t CTL;            /*!< (@ 0x00000000) Bus Master MPU Control Register                            */

        struct
        {
            __IOM uint16_t ENABLE : 1; /*!< [0..0] Master Group enable                                                */
            __IOM uint16_t OAD    : 1; /*!< [1..1] Operation after detection                                          */
            uint16_t              : 6;
            __OM uint16_t KEY     : 8; /*!< [15..8] Write Keyword The data written to these bits are not
                                        *   stored.                                                                   */
        } CTL_b;
    };
    __IM uint16_t RESERVED;
    __IM uint32_t RESERVED1[63];
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint16_t PT;                        /*!< (@ 0x00000102) Protection of Register                                     */

        struct
        {
            __IOM uint16_t PROTECT : 1;           /*!< [0..0] Protection of region register                                      */
            uint16_t               : 7;
            __OM uint16_t KEY      : 8;           /*!< [15..8] Write Keyword The data written to these bits are not
                                                   *   stored.                                                                   */
        } PT_b;
    };
    __IM uint32_t RESERVED3[63];
    __IOM R_MPU_MMPU_MMPU_REGION_Type REGION[32]; /*!< (@ 0x00000200) Address Region registers                                   */
} R_MPU_MMPU_MMPU_Type;                           /*!< Size = 1024 (0x400)                                                       */

/**
 * @brief R_MPU_SMPU_SMPU [SMPU] (Access Control Structure for MBIU)
 */
typedef struct
{
    union
    {
        __IOM uint16_t R;              /*!< (@ 0x00000000) Access Control Register for MBIU                           */

        struct
        {
            uint16_t              : 2;
            __IOM uint16_t RPGRPA : 1;   /*!< [2..2] Master Group A Read protection                                     */
            __IOM uint16_t WPGRPA : 1;   /*!< [3..3] Master Group A Write protection                                    */
            __IOM uint16_t RPGRPB : 1;   /*!< [4..4] Master Group B Read protection                                     */
            __IOM uint16_t WPGRPB : 1;   /*!< [5..5] Master Group B Write protection                                    */
            __IOM uint16_t RPGRPC : 1;   /*!< [6..6] Master Group C Read protection                                     */
            __IOM uint16_t WPGRPC : 1;   /*!< [7..7] Master Group C Write protection                                    */
            uint16_t              : 4;
            __IOM uint16_t RPFLI  : 1;   /*!< [12..12] Code Flash Memory Read Protection                                */
            __IOM uint16_t WPFLI  : 1;   /*!< [13..13] Code Flash Memory Write Protection (Note: This bit
                                          *   is read as 1. The write value should be 1.)                               */
            __IOM uint16_t RPSRAMHS : 1; /*!< [14..14] SRAMHS Read Protection                                           */
            __IOM uint16_t WPSRAMHS : 1; /*!< [15..15] SRAMHS Write Protection                                          */
        } R_b;
    };
    __IM uint16_t RESERVED;
} R_MPU_SMPU_SMPU_Type;                  /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_MPU_SPMON_SP [SP] (Stack Pointer Monitor)
 */
typedef struct
{
    union
    {
        __IOM uint16_t OAD;            /*!< (@ 0x00000000) Stack Pointer Monitor Operation After Detection
                                        *                  Register                                                   */

        struct
        {
            __IOM uint16_t OAD : 1;    /*!< [0..0] Operation after detection                                          */
            uint16_t           : 7;
            __OM uint16_t KEY  : 8;    /*!< [15..8] Write Keyword The data written to these bits are not
                                        *   stored.                                                                   */
        } OAD_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t CTL;            /*!< (@ 0x00000004) Stack Pointer Monitor Access Control Register              */

        struct
        {
            __IOM uint16_t ENABLE : 1; /*!< [0..0] Stack Pointer Monitor Enable                                       */
            uint16_t              : 7;
            __IOM uint16_t ERROR  : 1; /*!< [8..8] Stack Pointer Monitor Error Flag                                   */
            uint16_t              : 7;
        } CTL_b;
    };

    union
    {
        __IOM uint16_t PT;              /*!< (@ 0x00000006) Stack Pointer Monitor Protection Register                  */

        struct
        {
            __IOM uint16_t PROTECT : 1; /*!< [0..0] Protection of register (MSPMPUAC, MSPMPUSA and MSPMPUSE)           */
            uint16_t               : 7;
            __OM uint16_t KEY      : 8; /*!< [15..8] Write Keyword The data written to these bits are not
                                         *   stored.                                                                   */
        } PT_b;
    };

    union
    {
        __IOM uint32_t SA;                /*!< (@ 0x00000008) Stack Pointer Monitor Start Address Register               */

        struct
        {
            __IOM uint32_t MSPMPUSA : 32; /*!< [31..0] Region start address register Address where the region
                                           *   starts, for use in region determination.NOTE: Range: 0x1FF00000-0x200FFFF
                                           *   The low-order 2 bits are fixed to 0.                                      */
        } SA_b;
    };

    union
    {
        __IOM uint32_t EA;                /*!< (@ 0x0000000C) Stack Pointer Monitor End Address Register                 */

        struct
        {
            __IOM uint32_t MSPMPUEA : 32; /*!< [31..0] Region end address register Address where the region
                                           *   starts, for use in region determination.NOTE: Range: 0x1FF00003-0x200FFFF
                                           *   The low-order 2 bits are fixed to 1.                                      */
        } EA_b;
    };
} R_MPU_SPMON_SP_Type;                    /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_OPAMP_AMP [AMP] (Input and Output Selectors for Operational Amplifier [0..3])
 */
typedef struct
{
    __IOM uint8_t OS;                  /*!< (@ 0x00000000) Output Select Register                                     */
    __IOM uint8_t MS;                  /*!< (@ 0x00000001) Minus Input Select Register                                */
    __IOM uint8_t PS;                  /*!< (@ 0x00000002) Plus Input Select Register                                 */
} R_OPAMP_AMP_Type;                    /*!< Size = 3 (0x3)                                                            */

/**
 * @brief R_OPAMP_AMPOT [AMPOT] (Operational Amplifier n Offset Trimming Registers)
 */
typedef struct
{
    union
    {
        __IOM uint8_t P;               /*!< (@ 0x00000000) Operational Amplifier n Offset Trimming Pch Register       */

        struct
        {
            __IOM uint8_t TRMP : 5;    /*!< [4..0] AMPn input offset trimming Pch side                                */
            uint8_t            : 3;
        } P_b;
    };

    union
    {
        __IOM uint8_t N;               /*!< (@ 0x00000001) Operational Amplifier n Offset Trimming Nch Register       */

        struct
        {
            __IOM uint8_t TRMN : 5;    /*!< [4..0] AMPn input offset trimming Nch side                                */
            uint8_t            : 3;
        } N_b;
    };
} R_OPAMP_AMPOT_Type;                  /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_PFS_PORT_PIN [PIN] (Pin Function Selects)
 */
typedef struct
{
    union
    {
        union
        {
            __IOM uint32_t PmnPFS;        /*!< (@ 0x00000000) Pin Function Control Register                              */

            struct
            {
                __IOM uint32_t PODR  : 1; /*!< [0..0] Port Output Data                                                   */
                __IM uint32_t  PIDR  : 1; /*!< [1..1] Port Input Data                                                    */
                __IOM uint32_t PDR   : 1; /*!< [2..2] Port Direction                                                     */
                uint32_t             : 1;
                __IOM uint32_t PCR   : 1; /*!< [4..4] Pull-up Control                                                    */
                __IOM uint32_t PIM   : 1; /*!< [5..5] Port Input Mode Control                                            */
                __IOM uint32_t NCODR : 1; /*!< [6..6] N-Channel Open Drain Control                                       */
                uint32_t             : 3;
                __IOM uint32_t DSCR  : 2; /*!< [11..10] Drive Strength Control Register                                  */
                __IOM uint32_t EOFR  : 2; /*!< [13..12] Event on Falling/Rising                                          */
                __IOM uint32_t ISEL  : 1; /*!< [14..14] IRQ input enable                                                 */
                __IOM uint32_t ASEL  : 1; /*!< [15..15] Analog Input enable                                              */
                __IOM uint32_t PMR   : 1; /*!< [16..16] Port Mode Control                                                */
                uint32_t             : 7;
                __IOM uint32_t PSEL  : 5; /*!< [28..24] Port Function SelectThese bits select the peripheral
                                           *   function. For individual pin functions, see the MPC table                 */
                uint32_t : 3;
            } PmnPFS_b;
        };

        struct
        {
            union
            {
                struct
                {
                    __IM uint16_t RESERVED;

                    union
                    {
                        __IOM uint16_t PmnPFS_HA;     /*!< (@ 0x00000002) Pin Function Control Register                              */

                        struct
                        {
                            __IOM uint16_t PODR  : 1; /*!< [0..0] Port Output Data                                                   */
                            __IM uint16_t  PIDR  : 1; /*!< [1..1] Port Input Data                                                    */
                            __IOM uint16_t PDR   : 1; /*!< [2..2] Port Direction                                                     */
                            uint16_t             : 1;
                            __IOM uint16_t PCR   : 1; /*!< [4..4] Pull-up Control                                                    */
                            __IOM uint16_t PIM   : 1; /*!< [5..5] Port Input Mode Control                                            */
                            __IOM uint16_t NCODR : 1; /*!< [6..6] N-Channel Open Drain Control                                       */
                            uint16_t             : 3;
                            __IOM uint16_t DSCR  : 2; /*!< [11..10] Drive Strength Control Register                                  */
                            __IOM uint16_t EOFR  : 2; /*!< [13..12] Event on Falling/Rising                                          */
                            __IOM uint16_t ISEL  : 1; /*!< [14..14] IRQ input enable                                                 */
                            __IOM uint16_t ASEL  : 1; /*!< [15..15] Analog Input enable                                              */
                        } PmnPFS_HA_b;
                    };
                };

                struct
                {
                    __IM uint16_t RESERVED1;
                    __IM uint8_t  RESERVED2;

                    union
                    {
                        __IOM uint8_t PmnPFS_BY;     /*!< (@ 0x00000003) Pin Function Control Register                              */

                        struct
                        {
                            __IOM uint8_t PODR  : 1; /*!< [0..0] Port Output Data                                                   */
                            __IM uint8_t  PIDR  : 1; /*!< [1..1] Port Input Data                                                    */
                            __IOM uint8_t PDR   : 1; /*!< [2..2] Port Direction                                                     */
                            uint8_t             : 1;
                            __IOM uint8_t PCR   : 1; /*!< [4..4] Pull-up Control                                                    */
                            __IOM uint8_t PIM   : 1; /*!< [5..5] Port Input Mode Control                                            */
                            __IOM uint8_t NCODR : 1; /*!< [6..6] N-Channel Open Drain Control                                       */
                            uint8_t             : 1;
                        } PmnPFS_BY_b;
                    };
                };
            };
        };
    };
} R_PFS_PORT_PIN_Type;                 /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_PFS_PORT [PORT] (Port [0..14])
 */
typedef struct
{
    __IOM R_PFS_PORT_PIN_Type PIN[16]; /*!< (@ 0x00000000) Pin Function Selects                                       */
} R_PFS_PORT_Type;                     /*!< Size = 64 (0x40)                                                          */

/**
 * @brief R_PMISC_PMSAR [PMSAR] (Port Security Attribution Register)
 */
typedef struct
{
    __IOM uint16_t PMSAR;              /*!< (@ 0x00000000) Port Security Attribution Register                         */

 #if (2U == BSP_FEATURE_IOPORT_VERSION)
    __IM uint16_t RESERVED;
 #endif
} R_PMISC_PMSAR_Type;                  /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_RTC_RTCCR [RTCCR] (Time Capture Control Register)
 */
typedef struct
{
    union
    {
        __IOM uint8_t RTCCR;           /*!< (@ 0x00000000) Time Capture Control Register                              */

        struct
        {
            __IOM uint8_t TCCT : 2;    /*!< [1..0] Time Capture Control                                               */
            __IM uint8_t  TCST : 1;    /*!< [2..2] Time Capture Status                                                */
            uint8_t            : 1;
            __IOM uint8_t TCNF : 2;    /*!< [5..4] Time Capture Noise Filter Control                                  */
            uint8_t            : 2;
        } RTCCR_b;
    };
    __IM uint8_t RESERVED;
} R_RTC_RTCCR_Type;                    /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_RTC_CP [CP] (Capture registers)
 */
typedef struct
{
    __IM uint8_t RESERVED[2];

    union
    {
        union
        {
            __IM uint8_t RSEC;          /*!< (@ 0x00000002) Second Capture Register                                    */

            struct
            {
                __IM uint8_t SEC1 : 4;  /*!< [3..0] 1-Second Capture Capture value for the ones place of
                                         *   seconds                                                                   */
                __IM uint8_t SEC10 : 3; /*!< [6..4] 10-Second Capture Capture value for the tens place of
                                         *   seconds                                                                   */
                uint8_t : 1;
            } RSEC_b;
        };

        union
        {
            __IM uint8_t BCNT0;           /*!< (@ 0x00000002) BCNT0 Capture Register                                     */

            struct
            {
                __IM uint8_t BCNT0CP : 8; /*!< [7..0] BCNT0CP is a read-only register that captures the BCNT0
                                           *   value when a time capture event is detected.                              */
            } BCNT0_b;
        };
    };
    __IM uint8_t RESERVED1;

    union
    {
        union
        {
            __IM uint8_t RMIN;          /*!< (@ 0x00000004) Minute Capture Register                                    */

            struct
            {
                __IM uint8_t MIN1 : 4;  /*!< [3..0] 1-Minute Capture Capture value for the ones place of
                                         *   minutes                                                                   */
                __IM uint8_t MIN10 : 3; /*!< [6..4] 10-Minute Capture Capture value for the tens place of
                                         *   minutes                                                                   */
                uint8_t : 1;
            } RMIN_b;
        };

        union
        {
            __IM uint8_t BCNT1;           /*!< (@ 0x00000004) BCNT1 Capture Register                                     */

            struct
            {
                __IM uint8_t BCNT1CP : 8; /*!< [7..0] BCNT1CP is a read-only register that captures the BCNT1
                                           *   value when a time capture event is detected.                              */
            } BCNT1_b;
        };
    };
    __IM uint8_t RESERVED2;

    union
    {
        union
        {
            __IM uint8_t RHR;          /*!< (@ 0x00000006) Hour Capture Register                                      */

            struct
            {
                __IM uint8_t HR1 : 4;  /*!< [3..0] 1-Minute Capture Capture value for the ones place of
                                        *   minutes                                                                   */
                __IM uint8_t HR10 : 2; /*!< [5..4] 10-Minute Capture Capture value for the tens place of
                                        *   minutes                                                                   */
                __IM uint8_t PM : 1;   /*!< [6..6] A.m./p.m. select for time counter setting.                         */
                uint8_t         : 1;
            } RHR_b;
        };

        union
        {
            __IM uint8_t BCNT2;           /*!< (@ 0x00000006) BCNT2 Capture Register                                     */

            struct
            {
                __IM uint8_t BCNT2CP : 8; /*!< [7..0] BCNT2CP is a read-only register that captures the BCNT2
                                           *   value when a time capture event is detected.                              */
            } BCNT2_b;
        };
    };
    __IM uint8_t RESERVED3[3];

    union
    {
        union
        {
            __IM uint8_t RDAY;           /*!< (@ 0x0000000A) Date Capture Register                                      */

            struct
            {
                __IM uint8_t DATE1  : 4; /*!< [3..0] 1-Day Capture Capture value for the ones place of minutes          */
                __IM uint8_t DATE10 : 2; /*!< [5..4] 10-Day Capture Capture value for the tens place of minutes         */
                uint8_t             : 2;
            } RDAY_b;
        };

        union
        {
            __IM uint8_t BCNT3;           /*!< (@ 0x0000000A) BCNT3 Capture Register                                     */

            struct
            {
                __IM uint8_t BCNT3CP : 8; /*!< [7..0] BCNT3CP is a read-only register that captures the BCNT3
                                           *   value when a time capture event is detected.                              */
            } BCNT3_b;
        };
    };
    __IM uint8_t RESERVED4;

    union
    {
        __IM uint8_t RMON;             /*!< (@ 0x0000000C) Month Capture Register                                     */

        struct
        {
            __IM uint8_t MON1  : 4;    /*!< [3..0] 1-Month Capture Capture value for the ones place of months         */
            __IM uint8_t MON10 : 1;    /*!< [4..4] 10-Month Capture Capture value for the tens place of
                                        *   months                                                                    */
            uint8_t : 3;
        } RMON_b;
    };
    __IM uint8_t RESERVED5[3];
} R_RTC_CP_Type;                       /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_B_CSa [CSa] (CS Registers)
 */
typedef struct
{
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t MOD;            /*!< (@ 0x00000002) Mode Register                                              */

        struct
        {
            __IOM uint16_t WRMOD : 1;  /*!< [0..0] Write Access Mode Select                                           */
            uint16_t             : 2;
            __IOM uint16_t EWENB : 1;  /*!< [3..3] External Wait Enable                                               */
            uint16_t             : 4;
            __IOM uint16_t PRENB : 1;  /*!< [8..8] Page Read Access Enable                                            */
            __IOM uint16_t PWENB : 1;  /*!< [9..9] Page Write Access Enable                                           */
            uint16_t             : 5;
            __IOM uint16_t PRMOD : 1;  /*!< [15..15] Page Read Access Mode Select                                     */
        } MOD_b;
    };

    union
    {
        __IOM uint32_t WCR1;             /*!< (@ 0x00000004) Wait Control Register 1                                    */

        struct
        {
            __IOM uint32_t CSPWWAIT : 3; /*!< [2..0] Page Write Cycle Wait SelectNOTE: The CSPWWAIT value
                                          *   is valid only when the PWENB bit in CSnMOD is set to 1.                   */
            uint32_t                : 5;
            __IOM uint32_t CSPRWAIT : 3; /*!< [10..8] Page Read Cycle Wait SelectNOTE: The CSPRWAIT value
                                          *   is valid only when the PRENB bit in CSnMOD is set to 1.                   */
            uint32_t               : 5;
            __IOM uint32_t CSWWAIT : 5;  /*!< [20..16] Normal Write Cycle Wait Select                                   */
            uint32_t               : 3;
            __IOM uint32_t CSRWAIT : 5;  /*!< [28..24] Normal Read Cycle Wait Select                                    */
            uint32_t               : 3;
        } WCR1_b;
    };

    union
    {
        __IOM uint32_t WCR2;           /*!< (@ 0x00000008) Wait Control Register 2                                    */

        struct
        {
            __IOM uint32_t CSROFF : 3; /*!< [2..0] Read-Access CS Extension Cycle Select                              */
            uint32_t              : 1;
            __IOM uint32_t CSWOFF : 3; /*!< [6..4] Write-Access CS Extension Cycle Select                             */
            uint32_t              : 1;
            __IOM uint32_t WDOFF  : 3; /*!< [10..8] Write Data Output Extension Cycle Select                          */
            uint32_t              : 1;
            __IOM uint32_t AWAIT  : 2; /*!< [13..12] CS Assert Wait Select                                            */
            uint32_t              : 2;
            __IOM uint32_t RDON   : 3; /*!< [18..16] RD Assert Wait Select                                            */
            uint32_t              : 1;
            __IOM uint32_t WRON   : 3; /*!< [22..20] WR Assert Wait Select                                            */
            uint32_t              : 1;
            __IOM uint32_t WDON   : 3; /*!< [26..24] Write Data Output Wait Select                                    */
            uint32_t              : 1;
            __IOM uint32_t CSON   : 3; /*!< [30..28] CS Assert Wait Select                                            */
            uint32_t              : 1;
        } WCR2_b;
    };
    __IM uint32_t RESERVED1;
} R_BUS_B_CSa_Type;                    /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_B_CSb [CSb] (CS Registers)
 */
typedef struct
{
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t CR;             /*!< (@ 0x00000002) Control Register                                           */

        struct
        {
            __IOM uint16_t EXENB : 1;  /*!< [0..0] Operation Enable                                                   */
            uint16_t             : 3;
            __IOM uint16_t BSIZE : 2;  /*!< [5..4] External Bus Width Select                                          */
            uint16_t             : 2;
            __IOM uint16_t EMODE : 1;  /*!< [8..8] Endian Mode                                                        */
            uint16_t             : 3;
            __IOM uint16_t MPXEN : 1;  /*!< [12..12] Address/Data Multiplexed I/O Interface Select                    */
            uint16_t             : 3;
        } CR_b;
    };
    __IM uint16_t RESERVED1[3];

    union
    {
        __IOM uint16_t REC;            /*!< (@ 0x0000000A) Recovery Cycle Register                                    */

        struct
        {
            __IOM uint16_t RRCV : 4;   /*!< [3..0] Read Recovery                                                      */
            uint16_t            : 4;
            __IOM uint16_t WRCV : 4;   /*!< [11..8] Write Recovery                                                    */
            uint16_t            : 4;
        } REC_b;
    };
    __IM uint16_t RESERVED2[2];
} R_BUS_B_CSb_Type;                    /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_B_BUSERR [BUSERR] (Bus Error Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t ADD;             /*!< (@ 0x00000000) Bus Error Address Register                                 */

        struct
        {
            __IM uint32_t BERAD : 32;  /*!< [31..0] Bus Error AddressWhen a bus error occurs, It stores
                                        *   an error address.                                                         */
        } ADD_b;
    };

    union
    {
        __IM uint8_t ERRRW;            /*!< (@ 0x00000004) BUS Error Read Write Register                              */

        struct
        {
            __IM uint8_t RWSTAT : 1;   /*!< [0..0] Error access statusThe status at the time of the error             */
            uint8_t             : 7;
        } ERRRW_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[2];
} R_BUS_B_BUSERR_Type;                 /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_B_BUSTZFERR [BUSTZFERR] (Bus TZF Error Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t TZFADD;            /*!< (@ 0x00000000) Bus TZF Error Address Register                             */

        struct
        {
            __IM uint32_t BTZFERAD : 32; /*!< [31..0] Bus TrustZone Filter Error AddressWhen a bus error occurs,
                                          *   It stores an error address.                                               */
        } TZFADD_b;
    };

    union
    {
        __IM uint8_t TZFERRRW;         /*!< (@ 0x00000004) BUS TZF Error Read Write Register                          */

        struct
        {
            __IM uint8_t TRWSTAT : 1;  /*!< [0..0] TrustZone filter Error access statusThe status at the
                                        *   time of the error                                                         */
            uint8_t : 7;
        } TZFERRRW_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[2];
} R_BUS_B_BUSTZFERR_Type;              /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_USB_FS0_PIPE_TR [PIPE_TR] (Pipe Transaction Counter Registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t E;              /*!< (@ 0x00000000) Pipe Transaction Counter Enable Register                   */

        struct
        {
            uint16_t             : 8;
            __IOM uint16_t TRCLR : 1;  /*!< [8..8] Transaction Counter Clear                                          */
            __IOM uint16_t TRENB : 1;  /*!< [9..9] Transaction Counter Enable                                         */
            uint16_t             : 6;
        } E_b;
    };

    union
    {
        __IOM uint16_t N;               /*!< (@ 0x00000002) Pipe Transaction Counter Register                          */

        struct
        {
            __IOM uint16_t TRNCNT : 16; /*!< [15..0] Transaction Counter                                               */
        } N_b;
    };
} R_USB_FS0_PIPE_TR_Type;               /*!< Size = 4 (0x4)                                                            */

/**
 * @brief USB_HS0_PIPE_TR [PIPE_TR] (Pipe Transaction Counter Registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t E;              /*!< (@ 0x00000000) Pipe Transaction Counter Enable Register                   */

        struct
        {
            uint16_t             : 8;
            __IOM uint16_t TRCLR : 1;  /*!< [8..8] Transaction Counter Clear                                          */
            __IOM uint16_t TRENB : 1;  /*!< [9..9] Transaction Counter Enable                                         */
        } E_b;
    };

    union
    {
        __IOM uint16_t N;               /*!< (@ 0x00000002) Pipe Transaction Counter Register                          */

        struct
        {
            __IOM uint16_t TRNCNT : 16; /*!< [15..0] Transaction Counter                                               */
        } N_b;
    };
} R_USB_HS0_PIPE_TR_Type;               /*!< Size = 4 (0x4)                                                           */

/** @} */ /* End of group Device_Peripheral_clusters */

/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_peripherals
 * @{
 */

/* =========================================================================================================================== */
/* ================                                         R_ACMPHS0                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief High-Speed Analog Comparator (R_ACMPHS0)
 */

typedef struct                         /*!< (@ 0x40085000) R_ACMPHS0 Structure                                        */
{
    union
    {
        __IOM uint8_t CMPCTL;          /*!< (@ 0x00000000) Comparator Control Register                                */

        struct
        {
            __IOM uint8_t CINV   : 1;  /*!< [0..0] Comparator output polarity selection                               */
            __IOM uint8_t COE    : 1;  /*!< [1..1] Comparator output enable                                           */
            __IOM uint8_t CSTEN  : 1;  /*!< [2..2] Interrupt Select                                                   */
            __IOM uint8_t CEG    : 2;  /*!< [4..3] Selection of valid edge (Edge selector)                            */
            __IOM uint8_t CDFS   : 2;  /*!< [6..5] Noise filter selection                                             */
            __IOM uint8_t HCMPON : 1;  /*!< [7..7] Comparator operation control                                       */
        } CMPCTL_b;
    };
    __IM uint8_t RESERVED[3];

    union
    {
        __IOM uint8_t CMPSEL0;         /*!< (@ 0x00000004) Comparator Input Select Register                           */

        struct
        {
            __IOM uint8_t CMPSEL : 4;  /*!< [3..0] Comparator Input Selection                                         */
            uint8_t              : 4;
        } CMPSEL0_b;
    };
    __IM uint8_t RESERVED1[3];

    union
    {
        __IOM uint8_t CMPSEL1;         /*!< (@ 0x00000008) Comparator Reference Voltage Select Register               */

        struct
        {
            __IOM uint8_t CRVS : 6;    /*!< [5..0] Reference Voltage Selection                                        */
            uint8_t            : 2;
        } CMPSEL1_b;
    };
    __IM uint8_t RESERVED2[3];

    union
    {
        __IM uint8_t CMPMON;           /*!< (@ 0x0000000C) Comparator Output Monitor Register                         */

        struct
        {
            __IM uint8_t CMPMON : 1;   /*!< [0..0] Comparator output monitor                                          */
            uint8_t             : 7;
        } CMPMON_b;
    };
    __IM uint8_t RESERVED3[3];

    union
    {
        __IOM uint8_t CPIOC;           /*!< (@ 0x00000010) Comparator Output Control Register                         */

        struct
        {
            __IOM uint8_t CPOE   : 1;  /*!< [0..0] Comparator output selection                                        */
            uint8_t              : 6;
            __IOM uint8_t VREFEN : 1;  /*!< [7..7] Internal Vref enable                                               */
        } CPIOC_b;
    };
} R_ACMPHS0_Type;                      /*!< Size = 17 (0x11)                                                          */

/* =========================================================================================================================== */
/* ================                                         R_ACMPLP                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Low-Power Analog Comparator (R_ACMPLP)
 */

typedef struct                         /*!< (@ 0x40085E00) R_ACMPLP Structure                                         */
{
    union
    {
        __IOM uint8_t COMPMDR;         /*!< (@ 0x00000000) ACMPLP Mode Setting Register                               */

        struct
        {
            __IOM uint8_t C0ENB : 1;   /*!< [0..0] ACMPLP0 Operation Enable                                           */
            __IOM uint8_t C0WDE : 1;   /*!< [1..1] ACMPLP0 Window Function Mode Enable                                */
            __IOM uint8_t C0VRF : 1;   /*!< [2..2] ACMPLP0 Reference Voltage Selection                                */
            __IM uint8_t  C0MON : 1;   /*!< [3..3] ACMPLP0 Monitor Flag                                               */
            __IOM uint8_t C1ENB : 1;   /*!< [4..4] ACMPLP1 Operation Enable                                           */
            __IOM uint8_t C1WDE : 1;   /*!< [5..5] ACMPLP1 Window Function Mode Enable                                */
            __IOM uint8_t C1VRF : 1;   /*!< [6..6] ACMPLP1 Reference Voltage Selection                                */
            __IM uint8_t  C1MON : 1;   /*!< [7..7] ACMPLP1 Monitor Flag                                               */
        } COMPMDR_b;
    };

    union
    {
        __IOM uint8_t COMPFIR;         /*!< (@ 0x00000001) ACMPLP Filter Control Register                             */

        struct
        {
            __IOM uint8_t C0FCK : 2;   /*!< [1..0] ACMPLP0 Filter Select                                              */
            __IOM uint8_t C0EPO : 1;   /*!< [2..2] ACMPLP0 Edge Polarity Switching                                    */
            __IOM uint8_t C0EDG : 1;   /*!< [3..3] ACMPLP0 Edge Detection Selection                                   */
            __IOM uint8_t C1FCK : 2;   /*!< [5..4] ACMPLP1 Filter Select                                              */
            __IOM uint8_t C1EPO : 1;   /*!< [6..6] ACMPLP1 Edge Polarity Switching                                    */
            __IOM uint8_t C1EDG : 1;   /*!< [7..7] ACMPLP1 Edge Detection Selection                                   */
        } COMPFIR_b;
    };

    union
    {
        __IOM uint8_t COMPOCR;         /*!< (@ 0x00000002) ACMPLP Output Control Register                             */

        struct
        {
            uint8_t             : 1;
            __IOM uint8_t C0OE  : 1;   /*!< [1..1] ACMPLP0 VCOUT Pin Output Enable                                    */
            __IOM uint8_t C0OP  : 1;   /*!< [2..2] ACMPLP0 VCOUT Output Polarity Selection                            */
            uint8_t             : 2;
            __IOM uint8_t C1OE  : 1;   /*!< [5..5] ACMPLP1 VCOUT Pin Output Enable                                    */
            __IOM uint8_t C1OP  : 1;   /*!< [6..6] ACMPLP1 VCOUT Output Polarity Selection                            */
            __IOM uint8_t SPDMD : 1;   /*!< [7..7] ACMPLP0/ACMPLP1 Speed Selection                                    */
        } COMPOCR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint8_t COMPSEL0;        /*!< (@ 0x00000004) Comparator Input Select Register                           */

        struct
        {
            __IOM uint8_t IVCMP0 : 3;  /*!< [2..0] ACMPLP0 Input (IVCMP0) Selection                                   */
            uint8_t              : 1;
            __IOM uint8_t IVCMP1 : 3;  /*!< [6..4] ACMPLP1 Input (IVCMP1) Selection                                   */
            uint8_t              : 1;
        } COMPSEL0_b;
    };

    union
    {
        __IOM uint8_t COMPSEL1;        /*!< (@ 0x00000005) Comparator Reference voltage Select Register               */

        struct
        {
            __IOM uint8_t IVREF0 : 3;  /*!< [2..0] ACMPLP0 Reference Voltage (IVREF0) Selection                       */
            uint8_t              : 1;
            __IOM uint8_t IVREF1 : 3;  /*!< [6..4] ACMPLP1 Reference Voltage(IVREF1) Selection                        */
            __IOM uint8_t C1VRF2 : 1;  /*!< [7..7] ACMPLP1 Reference Voltage Selection                                */
        } COMPSEL1_b;
    };
} R_ACMPLP_Type;                       /*!< Size = 6 (0x6)                                                            */

/* =========================================================================================================================== */
/* ================                                          R_ADC0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief A/D Converter (R_ADC0)
 */

typedef struct                         /*!< (@ 0x4005C000) R_ADC0 Structure                                           */
{
    union
    {
        __IOM uint16_t ADCSR;          /*!< (@ 0x00000000) A/D Control Register                                       */

        struct
        {
            __IOM uint16_t DBLANS : 5; /*!< [4..0] Double Trigger Channel SelectThese bits select one analog
                                        *   input channel for double triggered operation. The setting
                                        *   is only effective while double trigger mode is selected.                  */
            uint16_t              : 1;
            __IOM uint16_t GBADIE : 1; /*!< [6..6] Group B Scan End Interrupt Enable                                  */
            __IOM uint16_t DBLE   : 1; /*!< [7..7] Double Trigger Mode Select                                         */
            __IOM uint16_t EXTRG  : 1; /*!< [8..8] Trigger Select                                                     */
            __IOM uint16_t TRGE   : 1; /*!< [9..9] Trigger Start Enable                                               */
            __IOM uint16_t ADHSC  : 1; /*!< [10..10] A/D Conversion Operation Mode Select                             */
            uint16_t              : 1;
            __IOM uint16_t ADIE   : 1; /*!< [12..12] Scan End Interrupt Enable                                        */
            __IOM uint16_t ADCS   : 2; /*!< [14..13] Scan Mode Select                                                 */
            __IOM uint16_t ADST   : 1; /*!< [15..15] A/D Conversion Start                                             */
        } ADCSR_b;
    };

    union
    {
        __IOM uint8_t ADREF;           /*!< (@ 0x00000002) A/D status register                                        */

        struct
        {
            __IOM uint8_t ADF : 1;     /*!< [0..0] Scanning end flag bitThis bit is a status bit that becomes
                                        *   "1" while scanning.                                                       */
            uint8_t              : 6;
            __IM uint8_t ADSCACT : 1;  /*!< [7..7] Scanning status bit                                                */
        } ADREF_b;
    };

    union
    {
        __IOM uint8_t ADEXREF;         /*!< (@ 0x00000003) A/D enhancing status register                              */

        struct
        {
            __IOM uint8_t GBADF : 1;   /*!< [0..0] Group B scanning end flag bit.                                     */
            uint8_t             : 7;
        } ADEXREF_b;
    };

    union
    {
        __IOM uint16_t ADANSA[2];      /*!< (@ 0x00000004) A/D Channel Select Register                                */

        struct
        {
            __IOM uint16_t ANSA0  : 1; /*!< [0..0] AN Input Select                                                    */
            __IOM uint16_t ANSA1  : 1; /*!< [1..1] AN Input Select                                                    */
            __IOM uint16_t ANSA2  : 1; /*!< [2..2] AN Input Select                                                    */
            __IOM uint16_t ANSA3  : 1; /*!< [3..3] AN Input Select                                                    */
            __IOM uint16_t ANSA4  : 1; /*!< [4..4] AN Input Select                                                    */
            __IOM uint16_t ANSA5  : 1; /*!< [5..5] AN Input Select                                                    */
            __IOM uint16_t ANSA6  : 1; /*!< [6..6] AN Input Select                                                    */
            __IOM uint16_t ANSA7  : 1; /*!< [7..7] AN Input Select                                                    */
            __IOM uint16_t ANSA8  : 1; /*!< [8..8] AN Input Select                                                    */
            __IOM uint16_t ANSA9  : 1; /*!< [9..9] AN Input Select                                                    */
            __IOM uint16_t ANSA10 : 1; /*!< [10..10] AN Input Select                                                  */
            __IOM uint16_t ANSA11 : 1; /*!< [11..11] AN Input Select                                                  */
            __IOM uint16_t ANSA12 : 1; /*!< [12..12] AN Input Select                                                  */
            __IOM uint16_t ANSA13 : 1; /*!< [13..13] AN Input Select                                                  */
            __IOM uint16_t ANSA14 : 1; /*!< [14..14] AN Input Select                                                  */
            __IOM uint16_t ANSA15 : 1; /*!< [15..15] AN Input Select                                                  */
        } ADANSA_b[2];
    };

    union
    {
        __IOM uint16_t ADADS[2];       /*!< (@ 0x00000008) A/D-Converted Value Addition/Average Channel
                                        *                  Select Register                                            */

        struct
        {
            __IOM uint16_t ADS0  : 1;  /*!< [0..0] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS1  : 1;  /*!< [1..1] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS2  : 1;  /*!< [2..2] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS3  : 1;  /*!< [3..3] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS4  : 1;  /*!< [4..4] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS5  : 1;  /*!< [5..5] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS6  : 1;  /*!< [6..6] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS7  : 1;  /*!< [7..7] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS8  : 1;  /*!< [8..8] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS9  : 1;  /*!< [9..9] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS10 : 1;  /*!< [10..10] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS11 : 1;  /*!< [11..11] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS12 : 1;  /*!< [12..12] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS13 : 1;  /*!< [13..13] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS14 : 1;  /*!< [14..14] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS15 : 1;  /*!< [15..15] A/D-Converted Value Addition/Average Channel Select              */
        } ADADS_b[2];
    };

    union
    {
        __IOM uint8_t ADADC;           /*!< (@ 0x0000000C) A/D-Converted Value Addition/Average Count Select
                                        *                  Register                                                   */

        struct
        {
            __IOM uint8_t ADC : 3;     /*!< [2..0] Addition frequency selection bit.NOTE: AVEE bit is valid
                                        *   at the only setting of ADC[2:0] bits = 001b or 011b. When
                                        *   average mode is selected by setting the ADADC.AVEE bit
                                        *   to 1, do not set the addition count to three times (ADADC.ADC[2:0]
                                        *   = 010b)                                                                   */
            uint8_t            : 4;
            __IOM uint8_t AVEE : 1;    /*!< [7..7] Average Mode Enable. NOTE:When average mode is deselected
                                        *   by setting the ADADC.AVEE bit to 0, set the addition count
                                        *   to 1, 2, 3, 4 or 16-time conversion. 16-time conversion
                                        *   can only be used with 12-bit accuracy selected. NOTE: AVEE
                                        *   bit is valid at the only setting of ADC[2:0] bits = 001b
                                        *   or 011b. When average mode is selected by setting the ADADC.AVEE
                                        *   bit to 1, do not set the addition count to three times
                                        *   (ADADC.ADC[2:0] = 010b)                                                   */
        } ADADC_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t ADCER;          /*!< (@ 0x0000000E) A/D Control Extended Register                              */

        struct
        {
            uint16_t               : 1;
            __IOM uint16_t ADPRC   : 2; /*!< [2..1] A/D Conversion Accuracy Specify                                    */
            uint16_t               : 1;
            __IOM uint16_t DCE     : 1; /*!< [4..4] Discharge Enable                                                   */
            __IOM uint16_t ACE     : 1; /*!< [5..5] A/D Data Register Automatic Clearing Enable                        */
            uint16_t               : 2;
            __IOM uint16_t DIAGVAL : 2; /*!< [9..8] Self-Diagnosis Conversion Voltage Select                           */
            __IOM uint16_t DIAGLD  : 1; /*!< [10..10] Self-Diagnosis Mode Select                                       */
            __IOM uint16_t DIAGM   : 1; /*!< [11..11] Self-Diagnosis Enable                                            */
            uint16_t               : 2;
            __IOM uint16_t ADINV   : 1; /*!< [14..14] Single-Ended Input A/D Converted Data Inversion Select           */
            __IOM uint16_t ADRFMT  : 1; /*!< [15..15] A/D Data Register Format Select                                  */
        } ADCER_b;
    };

    union
    {
        __IOM uint16_t ADSTRGR;        /*!< (@ 0x00000010) A/D Conversion Start Trigger Select Register               */

        struct
        {
            __IOM uint16_t TRSB : 6;   /*!< [5..0] A/D Conversion Start Trigger Select for Group BSelect
                                        *   the A/D conversion start trigger for group B in group scan
                                        *   mode.                                                                     */
            uint16_t            : 2;
            __IOM uint16_t TRSA : 6;   /*!< [13..8] A/D Conversion Start Trigger SelectSelect the A/D conversion
                                        *   start trigger in single scan mode and continuous mode.
                                        *   In group scan mode, the A/D conversion start trigger for
                                        *   group A is selected.                                                      */
            uint16_t : 2;
        } ADSTRGR_b;
    };

    union
    {
        __IOM uint16_t ADEXICR;        /*!< (@ 0x00000012) A/D Conversion Extended Input Control Register             */

        struct
        {
            __IOM uint16_t TSSAD : 1;  /*!< [0..0] Temperature Sensor Output A/D converted Value Addition/Average
                                        *   Mode Select                                                               */
            __IOM uint16_t OCSAD : 1;  /*!< [1..1] Internal Reference Voltage A/D converted Value Addition/Average
                                        *   Mode Select                                                               */
            uint16_t            : 6;
            __IOM uint16_t TSSA : 1;   /*!< [8..8] Temperature Sensor Output A/D Conversion Select                    */
            __IOM uint16_t OCSA : 1;   /*!< [9..9] Internal Reference Voltage A/D Conversion Select                   */
            __IOM uint16_t TSSB : 1;   /*!< [10..10] Temperature Sensor Output A/D Conversion Select for
                                        *   Group B in group scan mode.                                               */
            __IOM uint16_t OCSB : 1;   /*!< [11..11] Internal Reference Voltage A/D Conversion Select for
                                        *   Group B in group scan mode.                                               */
            uint16_t             : 2;
            __IOM uint16_t EXSEL : 1;  /*!< [14..14] Extended Analog Input Select                                     */
            __IOM uint16_t EXOEN : 1;  /*!< [15..15] Extended Analog Output Control                                   */
        } ADEXICR_b;
    };

    union
    {
        __IOM uint16_t ADANSB[2];      /*!< (@ 0x00000014) A/D Channel Select Register B                              */

        struct
        {
            __IOM uint16_t ANSB0  : 1; /*!< [0..0] AN Input Select                                                    */
            __IOM uint16_t ANSB1  : 1; /*!< [1..1] AN Input Select                                                    */
            __IOM uint16_t ANSB2  : 1; /*!< [2..2] AN Input Select                                                    */
            __IOM uint16_t ANSB3  : 1; /*!< [3..3] AN Input Select                                                    */
            __IOM uint16_t ANSB4  : 1; /*!< [4..4] AN Input Select                                                    */
            __IOM uint16_t ANSB5  : 1; /*!< [5..5] AN Input Select                                                    */
            __IOM uint16_t ANSB6  : 1; /*!< [6..6] AN Input Select                                                    */
            __IOM uint16_t ANSB7  : 1; /*!< [7..7] AN Input Select                                                    */
            __IOM uint16_t ANSB8  : 1; /*!< [8..8] AN Input Select                                                    */
            __IOM uint16_t ANSB9  : 1; /*!< [9..9] AN Input Select                                                    */
            __IOM uint16_t ANSB10 : 1; /*!< [10..10] AN Input Select                                                  */
            __IOM uint16_t ANSB11 : 1; /*!< [11..11] AN Input Select                                                  */
            __IOM uint16_t ANSB12 : 1; /*!< [12..12] AN Input Select                                                  */
            __IOM uint16_t ANSB13 : 1; /*!< [13..13] AN Input Select                                                  */
            __IOM uint16_t ANSB14 : 1; /*!< [14..14] AN Input Select                                                  */
            __IOM uint16_t ANSB15 : 1; /*!< [15..15] AN Input Select                                                  */
        } ADANSB_b[2];
    };

    union
    {
        __IM uint16_t ADDBLDR;          /*!< (@ 0x00000018) A/D Data Duplication Register                              */

        struct
        {
            __IM uint16_t ADDBLDR : 16; /*!< [15..0] This is a 16-bit read-only register for storing the
                                         *   result of A/D conversion in response to the second trigger
                                         *   in double trigger mode.                                                   */
        } ADDBLDR_b;
    };

    union
    {
        __IM uint16_t ADTSDR;          /*!< (@ 0x0000001A) A/D Temperature Sensor Data Register                       */

        struct
        {
            __IM uint16_t ADTSDR : 16; /*!< [15..0] This is a 16-bit read-only register for storing the
                                        *   A/D conversion result of temperature sensor output.                       */
        } ADTSDR_b;
    };

    union
    {
        __IM uint16_t ADOCDR;          /*!< (@ 0x0000001C) A/D Internal Reference Voltage Data Register               */

        struct
        {
            __IM uint16_t ADOCDR : 16; /*!< [15..0] This is a 16-bit read-only register for storing the
                                        *   A/D result of internal reference voltage.                                 */
        } ADOCDR_b;
    };

    union
    {
        union
        {
            __IM uint16_t ADRD_RIGHT;     /*!< (@ 0x0000001E) A/D Self-Diagnosis Data Register Right Justified           */

            struct
            {
                __IM uint16_t AD : 14;    /*!< [13..0] A/D-converted value (right-justified)The format for
                                           *   data determine ADCER.ADRFMT and ADCER.ADPRC.                              */
                __IM uint16_t DIAGST : 2; /*!< [15..14] Self-Diagnosis Status                                            */
            } ADRD_RIGHT_b;
        };

        union
        {
            __IM uint16_t ADRD_LEFT;       /*!< (@ 0x0000001E) A/D Self-Diagnosis Data Register Left Justified            */

            struct
            {
                __IM uint16_t DIAGST : 2;  /*!< [1..0] Self-Diagnosis Status                                              */
                __IM uint16_t AD     : 14; /*!< [15..2] A/D-converted value (right-justified)The format for
                                            *   data determine ADCER.ADRFMT and ADCER.ADPRC.                              */
            } ADRD_LEFT_b;
        };
    };

    union
    {
        __IM uint16_t ADDR[28];        /*!< (@ 0x00000020) A/D Data Register                                          */

        struct
        {
            __IM uint16_t ADDR : 16;   /*!< [15..0] The ADDR register is a 16-bit read-only registers for
                                        *   storing the result of A/D conversion.                                     */
        } ADDR_b[28];
    };
    __IM uint16_t RESERVED1[5];

    union
    {
        __IOM uint8_t ADAMPOFF;        /*!< (@ 0x00000062) A/D RRAMP off state register                               */

        struct
        {
            __IOM uint8_t OPOFF : 8;   /*!< [7..0] OPOFF                                                              */
        } ADAMPOFF_b;
    };

    union
    {
        __IOM uint8_t ADTSTPR;         /*!< (@ 0x00000063) A/D Test Protecting Release Register                       */

        struct
        {
            __IOM uint8_t PRO  : 1;    /*!< [0..0] Test register protecting bit.                                      */
            __IOM uint8_t B0WI : 1;    /*!< [1..1] Bit 0 writing permission bit.                                      */
            uint8_t            : 6;
        } ADTSTPR_b;
    };

    union
    {
        __IOM uint16_t ADDDACER;       /*!< (@ 0x00000064) A/D RRAMP Discharge Period Register                        */

        struct
        {
            __IOM uint16_t WRION  : 5; /*!< [4..0] WRION                                                              */
            uint16_t              : 3;
            __IOM uint16_t WRIOFF : 5; /*!< [12..8] WRIOFF                                                            */
            uint16_t              : 2;
            __IOM uint16_t ADHS   : 1; /*!< [15..15] ADHS                                                             */
        } ADDDACER_b;
    };

    union
    {
        __IOM uint16_t ADSHCR;         /*!< (@ 0x00000066) A/D Sample and Hold Circuit Control Register               */

        struct
        {
            __IOM uint16_t SSTSH : 8;  /*!< [7..0] Channel-Dedicated Sample-and-Hold Circuit Sampling Time
                                        *   Setting Set the sampling time (4 to 255 states)                           */
            __IOM uint16_t SHANS0 : 1; /*!< [8..8] AN000 sample-and-hold circuit Select                               */
            __IOM uint16_t SHANS1 : 1; /*!< [9..9] AN001 sample-and-hold circuit Select                               */
            __IOM uint16_t SHANS2 : 1; /*!< [10..10] AN002 sample-and-hold circuit Select                             */
            uint16_t              : 5;
        } ADSHCR_b;
    };

    union
    {
        __IOM uint16_t ADEXTSTR;       /*!< (@ 0x00000068) A/D Enhancing Test Register                                */

        struct
        {
            __IOM uint16_t SHTEST : 3; /*!< [2..0] Test mode bit for S&H circuit.Test mode bit of S&H circuit
                                        *   only for channel.                                                         */
            uint16_t             : 1;
            __IOM uint16_t SWTST : 2;  /*!< [5..4] Test selection bit for pressure switch.                            */
            uint16_t             : 2;
            __IOM uint16_t SHTRM : 2;  /*!< [9..8] Current adjustment trim bit for S&H circuit.Trim bit
                                        *   for adjustment to hardening of process.                                   */
            uint16_t              : 1;
            __IOM uint16_t ADTRM3 : 1; /*!< [11..11] Trim bit 3 for A/D hard macro.3bit Flash comparator
                                        *   power save bit for A/D hard macro to hardening of process.                */
            __IOM uint16_t ADTRM2 : 2; /*!< [13..12] Trim bit 2 for A/D hard macro.Bias adjustment trim
                                        *   bit for A/D hard macro to hardening of process.                           */
            __IOM uint16_t ADTRM1 : 2; /*!< [15..14] Trim bit 1 for A/D hard macro.Timing adjustment trim
                                        *   bit for A/D hard macro to hardening of process.                           */
        } ADEXTSTR_b;
    };

    union
    {
        __IOM uint16_t ADTSTRA;           /*!< (@ 0x0000006A) A/D Test Register A                                        */

        struct
        {
            __IOM uint16_t ATBUSSEL : 1;  /*!< [0..0] Analog test bus selection bit.                                     */
            __IOM uint16_t TSTSWREF : 3;  /*!< [3..1] Pressure switch refreshing setting bit for S&H circuit
                                           *   amplifier test.Refreshing the pressure switch that opens
                                           *   for the DAC output voltage charge period when the amplifier
                                           *   of the S&H circuit is tested only for the channel is set.                 */
            uint16_t            : 1;
            __IOM uint16_t OCSW : 1;      /*!< [5..5] Internal reference voltage analog switch test control
                                           *   bit.                                                                      */
            __IOM uint16_t TSSW : 1;      /*!< [6..6] Temperature sensor output analogue switch test control
                                           *   bit                                                                       */
            uint16_t                 : 1;
            __IOM uint16_t ADTEST_AD : 4; /*!< [11..8] Test bit for A/D analog module Bit for test of A/D analog
                                           *   module Details are described to the bit explanation.                      */
            __IOM uint16_t ADTEST_IO : 4; /*!< [15..12] Test bit for analog I/ODetails are described to the
                                           *   bit explanation.                                                          */
        } ADTSTRA_b;
    };

    union
    {
        __IOM uint16_t ADTSTRB;        /*!< (@ 0x0000006C) A/D Test Register B                                        */

        struct
        {
            __IOM uint16_t ADVAL : 15; /*!< [14..0] Signal input bit bit14-0 for A/D analog module test.It
                                        *   corresponds to ADVAL 14:0 input of A/D analog module.                     */
            uint16_t : 1;
        } ADTSTRB_b;
    };

    union
    {
        __IOM uint16_t ADTSTRC;         /*!< (@ 0x0000006E) A/D Test Register C                                        */

        struct
        {
            __IOM uint16_t ADMD : 8;    /*!< [7..0] Bit for A/D analog module test.ADMODE 6:0 input of A/D
                                         *   analog module.                                                            */
            uint16_t               : 4;
            __IOM uint16_t SYNCERR : 1; /*!< [12..12] Synchronous analog to digital conversion error bit.              */
            uint16_t               : 3;
        } ADTSTRC_b;
    };

    union
    {
        __IOM uint16_t ADTSTRD;         /*!< (@ 0x00000070) A/D Test Register D                                        */

        struct
        {
            __IOM uint16_t ADVAL16 : 1; /*!< [0..0] Signal input bit bit16 for A/D analog module test.It
                                         *   corresponds to ADVAL 16 input of A/D analog module.                       */
            uint16_t : 15;
        } ADTSTRD_b;
    };

    union
    {
        __IOM uint16_t ADSWTSTR0;      /*!< (@ 0x00000072) A/D Channel Switch Test Control Register 0                 */

        struct
        {
            __IOM uint16_t CHSW00 : 1; /*!< [0..0] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW01 : 1; /*!< [1..1] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW02 : 1; /*!< [2..2] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW03 : 1; /*!< [3..3] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW04 : 1; /*!< [4..4] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW05 : 1; /*!< [5..5] Channel switch test control bit.                                   */
            uint16_t              : 10;
        } ADSWTSTR0_b;
    };

    union
    {
        __IOM uint16_t ADSWTSTR1;      /*!< (@ 0x00000074) A/D Channel Switch Test Control Register 1                 */

        struct
        {
            __IOM uint16_t CHSW16 : 1; /*!< [0..0] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW17 : 1; /*!< [1..1] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW18 : 1; /*!< [2..2] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW19 : 1; /*!< [3..3] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW20 : 1; /*!< [4..4] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW21 : 1; /*!< [5..5] Channel switch test control bit.                                   */
            uint16_t              : 10;
        } ADSWTSTR1_b;
    };

    union
    {
        __IOM uint16_t ADSWTSTR2;        /*!< (@ 0x00000076) A/D Channel Switch Test Control Register 2                 */

        struct
        {
            __IOM uint16_t EX0SW : 1;    /*!< [0..0] Test control of 0 enhancing input channel switches bit
                                          *   (ANEX0 switch)                                                            */
            __IOM uint16_t EX1SW : 1;    /*!< [1..1] Test control of one enhancing input channel switch bit
                                          *   (ANEX1 switch).                                                           */
            uint16_t                : 2;
            __IOM uint16_t SHBYPS0  : 1; /*!< [4..4] S&H circuit by-pass switch control bit 0.                          */
            __IOM uint16_t SHBYPS1  : 1; /*!< [5..5] S&H circuit by-pass switch control bit 1.                          */
            __IOM uint16_t SHBYPS2  : 1; /*!< [6..6] S&H circuit by-pass switch control bit 2.                          */
            uint16_t                : 1;
            __IOM uint16_t GRP0SW   : 1; /*!< [8..8] Test control of 0 group switches bit.                              */
            __IOM uint16_t GRP1SW   : 1; /*!< [9..9] Test control of one group switch bit.                              */
            __IOM uint16_t GRP2SW   : 1; /*!< [10..10] Test control of two group switches bit                           */
            __IOM uint16_t GRP3SW   : 1; /*!< [11..11] Test control of two group switches bit                           */
            __IOM uint16_t GRPEX1SW : 1; /*!< [12..12] Switch test control bit of enhancing analog ANEX1                */
            uint16_t                : 3;
        } ADSWTSTR2_b;
    };
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint8_t ADDISCR;         /*!< (@ 0x0000007A) A/D Disconnection Detection Control Register               */

        struct
        {
            __IOM uint8_t ADNDIS : 4;  /*!< [3..0] The charging time                                                  */
            __IOM uint8_t CHARGE : 1;  /*!< [4..4] Selection of Precharge or Discharge                                */
            uint8_t              : 3;
        } ADDISCR_b;
    };

    union
    {
        __IOM uint8_t ADSWCR;          /*!< (@ 0x0000007B) A/D Pressure Switch Control Register                       */

        struct
        {
            __IOM uint8_t ADSWREF : 3; /*!< [2..0] These bits are read as 0. The write value should be 0.Refreshing
                                        *   the pressure switch in A/D analog module is set.                          */
            uint8_t               : 1;
            __IOM uint8_t SHSWREF : 3; /*!< [6..4] S&H Boost Switch Refresh Interval Setting                          */
            uint8_t               : 1;
        } ADSWCR_b;
    };

    union
    {
        __IOM uint8_t ADSHMSR;         /*!< (@ 0x0000007C) A/D Sample and Hold Operation Mode Select Register         */

        struct
        {
            __IOM uint8_t SHMD : 1;    /*!< [0..0] Channel-Dedicated Sample-and-Hold Circuit Operation Mode
                                        *   Select                                                                    */
            uint8_t : 7;
        } ADSHMSR_b;
    };

    union
    {
        __IOM uint8_t ADICR;           /*!< (@ 0x0000007D) A/D Interrupt Control Register                             */

        struct
        {
            __IOM uint8_t ADIC : 2;    /*!< [1..0] A/D Interrupt Control                                              */
            uint8_t            : 6;
        } ADICR_b;
    };

    union
    {
        __IOM uint8_t ADACSR;          /*!< (@ 0x0000007E) A/D Conversion Operation Mode Select Register              */

        struct
        {
            uint8_t             : 1;
            __IOM uint8_t ADSAC : 1;   /*!< [1..1] Successive Approximation Control Setting                           */
            uint8_t             : 6;
        } ADACSR_b;
    };
    __IM uint8_t RESERVED3;

    union
    {
        __IOM uint16_t ADGSPCR;         /*!< (@ 0x00000080) A/D Group Scan Priority Control Register                   */

        struct
        {
            __IOM uint16_t PGS : 1;     /*!< [0..0] Group A priority control setting bit.Note: When the PGS
                                         *   bit is to be set to 1, the ADCSR.ADCS[1:0] bits must be
                                         *   set to 01b (group scan mode). If the bits are set to any
                                         *   other values, proper operation is not guaranteed.                         */
            __IOM uint16_t GBRSCN : 1;  /*!< [1..1] Group B Restart Setting(Enabled only when PGS = 1. Reserved
                                         *   when PGS = 0.)                                                            */
            uint16_t               : 6;
            __IOM uint16_t GBEXTRG : 1; /*!< [8..8] External trigger selection bit for group B.                        */
            uint16_t               : 6;
            __IOM uint16_t GBRP    : 1; /*!< [15..15] Group B Single Scan Continuous Start(Enabled only when
                                         *   PGS = 1. Reserved when PGS = 0.)Note: When the GBRP bit
                                         *   has been set to 1, single scan is performed continuously
                                         *   for group B regardless of the setting of the GBRSCN bit.                  */
        } ADGSPCR_b;
    };

    union
    {
        __IM uint16_t ADGSCS;          /*!< (@ 0x00000082) A/D Conversion Channel Status Register (for Group
                                        *                  Scan)                                                      */

        struct
        {
            __IM uint16_t CHSELGB : 8; /*!< [7..0] Channel status of Group B scan                                     */
            __IM uint16_t CHSELGA : 8; /*!< [15..8] Channel status of Group A scan                                    */
        } ADGSCS_b;
    };

    union
    {
        __IM uint16_t ADDBLDRA;          /*!< (@ 0x00000084) A/D Data Duplexing Register A                              */

        struct
        {
            __IM uint16_t ADDBLDRA : 16; /*!< [15..0] This register is a 16-bit read-only registers for storing
                                          *   the result of A/D conversion in response to the respective
                                          *   triggers during extended operation in double trigger mode.                */
        } ADDBLDRA_b;
    };

    union
    {
        __IM uint16_t ADDBLDRB;          /*!< (@ 0x00000086) A/D Data Duplexing Register B                              */

        struct
        {
            __IM uint16_t ADDBLDRB : 16; /*!< [15..0] This register is a 16-bit read-only registers for storing
                                          *   the result of A/D conversion in response to the respective
                                          *   triggers during extended operation in double trigger mode.                */
        } ADDBLDRB_b;
    };

    union
    {
        __IOM uint8_t ADSER;           /*!< (@ 0x00000088) A/D Sampling Extension Register                            */

        struct
        {
            uint8_t             : 7;
            __IOM uint8_t SMPEX : 1;   /*!< [7..7] Sampling extension control                                         */
        } ADSER_b;
    };
    __IM uint8_t RESERVED4;

    union
    {
        __IOM uint8_t ADHVREFCNT;      /*!< (@ 0x0000008A) A/D High-Potential/Low-Potential Reference Voltage
                                        *                  Control Register                                           */

        struct
        {
            __IOM uint8_t HVSEL : 2;   /*!< [1..0] High-Potential Reference Voltage Select                            */
            uint8_t             : 2;
            __IOM uint8_t LVSEL : 1;   /*!< [4..4] Low-Potential Reference Voltage Select                             */
            uint8_t             : 2;
            __IOM uint8_t ADSLP : 1;   /*!< [7..7] Sleep                                                              */
        } ADHVREFCNT_b;
    };
    __IM uint8_t RESERVED5;

    union
    {
        __IM uint8_t ADWINMON;         /*!< (@ 0x0000008C) A/D Compare Function Window A/B Status Monitor
                                        *                  Register                                                   */

        struct
        {
            __IM uint8_t MONCOMB : 1;  /*!< [0..0] Combination result monitorThis bit indicates the combination
                                        *   result.This bit is valid when both window A operation and
                                        *   window B operation are enabled.                                           */
            uint8_t              : 3;
            __IM uint8_t MONCMPA : 1;  /*!< [4..4] Comparison Result Monitor A                                        */
            __IM uint8_t MONCMPB : 1;  /*!< [5..5] Comparison Result Monitor B                                        */
            uint8_t              : 2;
        } ADWINMON_b;
    };
    __IM uint8_t  RESERVED6;
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint16_t ADCMPCR;        /*!< (@ 0x00000090) A/D Compare Function Control Register                      */

        struct
        {
            __IOM uint16_t CMPAB : 2;  /*!< [1..0] Window A/B Composite Conditions SettingNOTE: These bits
                                        *   are valid when both window A and window B are enabled (CMPAE
                                        *   = 1 and CMPBE = 1).                                                       */
            uint16_t              : 7;
            __IOM uint16_t CMPBE  : 1; /*!< [9..9] Compare Window B Operation Enable                                  */
            uint16_t              : 1;
            __IOM uint16_t CMPAE  : 1; /*!< [11..11] Compare Window A Operation Enable                                */
            uint16_t              : 1;
            __IOM uint16_t CMPBIE : 1; /*!< [13..13] Compare B Interrupt Enable                                       */
            __IOM uint16_t WCMPE  : 1; /*!< [14..14] Window Function Setting                                          */
            __IOM uint16_t CMPAIE : 1; /*!< [15..15] Compare A Interrupt Enable                                       */
        } ADCMPCR_b;
    };

    union
    {
        __IOM uint8_t ADCMPANSER;      /*!< (@ 0x00000092) A/D Compare Function Window A Extended Input
                                        *                  Select Register                                            */

        struct
        {
            __IOM uint8_t CMPTSA : 1;  /*!< [0..0] Temperature sensor output Compare selection bit.                   */
            __IOM uint8_t CMPOCA : 1;  /*!< [1..1] Internal reference voltage Compare selection bit.                  */
            uint8_t              : 6;
        } ADCMPANSER_b;
    };

    union
    {
        __IOM uint8_t ADCMPLER;        /*!< (@ 0x00000093) A/D Compare Function Window A Extended Input
                                        *                  Comparison Condition Setting Register                      */

        struct
        {
            __IOM uint8_t CMPLTSA : 1; /*!< [0..0] Compare Window A Temperature Sensor Output Comparison
                                        *   Condition Select                                                          */
            __IOM uint8_t CMPLOCA : 1; /*!< [1..1] Compare Window A Internal Reference Voltage ComparisonCondition
                                        *   Select                                                                    */
            uint8_t : 6;
        } ADCMPLER_b;
    };

    union
    {
        __IOM uint16_t ADCMPANSR[2];     /*!< (@ 0x00000094) A/D Compare Function Window A Channel Select
                                          *                  Register                                                   */

        struct
        {
            __IOM uint16_t CMPCHA0  : 1; /*!< [0..0] AN Input Select                                                    */
            __IOM uint16_t CMPCHA1  : 1; /*!< [1..1] AN Input Select                                                    */
            __IOM uint16_t CMPCHA2  : 1; /*!< [2..2] AN Input Select                                                    */
            __IOM uint16_t CMPCHA3  : 1; /*!< [3..3] AN Input Select                                                    */
            __IOM uint16_t CMPCHA4  : 1; /*!< [4..4] AN Input Select                                                    */
            __IOM uint16_t CMPCHA5  : 1; /*!< [5..5] AN Input Select                                                    */
            __IOM uint16_t CMPCHA6  : 1; /*!< [6..6] AN Input Select                                                    */
            __IOM uint16_t CMPCHA7  : 1; /*!< [7..7] AN Input Select                                                    */
            __IOM uint16_t CMPCHA8  : 1; /*!< [8..8] AN Input Select                                                    */
            __IOM uint16_t CMPCHA9  : 1; /*!< [9..9] AN Input Select                                                    */
            __IOM uint16_t CMPCHA10 : 1; /*!< [10..10] AN Input Select                                                  */
            __IOM uint16_t CMPCHA11 : 1; /*!< [11..11] AN Input Select                                                  */
            __IOM uint16_t CMPCHA12 : 1; /*!< [12..12] AN Input Select                                                  */
            __IOM uint16_t CMPCHA13 : 1; /*!< [13..13] AN Input Select                                                  */
            __IOM uint16_t CMPCHA14 : 1; /*!< [14..14] AN Input Select                                                  */
            __IOM uint16_t CMPCHA15 : 1; /*!< [15..15] AN Input Select                                                  */
        } ADCMPANSR_b[2];
    };

    union
    {
        __IOM uint16_t ADCMPLR[2];        /*!< (@ 0x00000098) A/D Compare Function Window A Comparison Condition
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t CMPLCHA0  : 1; /*!< [0..0] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA1  : 1; /*!< [1..1] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA2  : 1; /*!< [2..2] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA3  : 1; /*!< [3..3] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA4  : 1; /*!< [4..4] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA5  : 1; /*!< [5..5] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA6  : 1; /*!< [6..6] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA7  : 1; /*!< [7..7] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA8  : 1; /*!< [8..8] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA9  : 1; /*!< [9..9] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA10 : 1; /*!< [10..10] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA11 : 1; /*!< [11..11] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA12 : 1; /*!< [12..12] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA13 : 1; /*!< [13..13] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA14 : 1; /*!< [14..14] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA15 : 1; /*!< [15..15] Comparison condition of input                                    */
        } ADCMPLR_b[2];
    };

    union
    {
        __IOM uint16_t ADCMPDR0;          /*!< (@ 0x0000009C) A/D Compare Function Window A Lower-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADCMPDR0 : 16; /*!< [15..0] The ADCMPDR0 register sets the reference data when the
                                           *   compare window A function is used. ADCMPDR0 sets the lower-side
                                           *   level of window A.                                                        */
        } ADCMPDR0_b;
    };

    union
    {
        __IOM uint16_t ADCMPDR1;          /*!< (@ 0x0000009E) A/D Compare Function Window A Upper-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADCMPDR1 : 16; /*!< [15..0] The ADCMPDR1 register sets the reference data when the
                                           *   compare window A function is used. ADCMPDR1 sets the upper-side
                                           *   level of window A..                                                       */
        } ADCMPDR1_b;
    };

    union
    {
        __IOM uint16_t ADCMPSR[2];         /*!< (@ 0x000000A0) A/D Compare Function Window A Channel Status
                                            *                  Register                                                   */

        struct
        {
            __IOM uint16_t CMPSTCHA0  : 1; /*!< [0..0] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA1  : 1; /*!< [1..1] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA2  : 1; /*!< [2..2] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA3  : 1; /*!< [3..3] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA4  : 1; /*!< [4..4] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA5  : 1; /*!< [5..5] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA6  : 1; /*!< [6..6] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA7  : 1; /*!< [7..7] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA8  : 1; /*!< [8..8] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA9  : 1; /*!< [9..9] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA10 : 1; /*!< [10..10] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA11 : 1; /*!< [11..11] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA12 : 1; /*!< [12..12] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA13 : 1; /*!< [13..13] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA14 : 1; /*!< [14..14] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA15 : 1; /*!< [15..15] Compare window A flag of input                                   */
        } ADCMPSR_b[2];
    };

    union
    {
        __IOM uint8_t ADCMPSER;         /*!< (@ 0x000000A4) A/D Compare Function Window A Extended Input
                                         *                  Channel Status Register                                    */

        struct
        {
            __IOM uint8_t CMPSTTSA : 1; /*!< [0..0] Compare Window A Temperature Sensor Output Compare Flag
                                         *   When window A operation is enabled (ADCMPCR.CMPAE = 1b),
                                         *   this bit indicates the temperature sensor output comparison
                                         *   result. When window A operation is disabled (ADCMPCR.CMPAE
                                         *   = 0b), comparison conditions for CMPSTTSA are not met any
                                         *   time.                                                                     */
            __IOM uint8_t CMPSTOCA : 1; /*!< [1..1] Compare Window A Internal Reference Voltage Compare Flag
                                         *   When window A operation is enabled (ADCMPCR.CMPAE = 1b),
                                         *   this bit indicates the temperature sensor output comparison
                                         *   result. When window A operation is disabled (ADCMPCR.CMPAE
                                         *   = 0b), comparison conditions for CMPSTTSA are not met any
                                         *   time.                                                                     */
            uint8_t : 6;
        } ADCMPSER_b;
    };
    __IM uint8_t RESERVED8;

    union
    {
        __IOM uint8_t ADCMPBNSR;       /*!< (@ 0x000000A6) A/D Compare Function Window B Channel Selection
                                        *                  Register                                                   */

        struct
        {
            __IOM uint8_t CMPCHB : 6;  /*!< [5..0] Compare window B channel selection bit.The channel that
                                        *   compares it on the condition of compare window B is selected.             */
            uint8_t             : 1;
            __IOM uint8_t CMPLB : 1;   /*!< [7..7] Compare window B Compare condition setting bit.                    */
        } ADCMPBNSR_b;
    };
    __IM uint8_t RESERVED9;

    union
    {
        __IOM uint16_t ADWINLLB;          /*!< (@ 0x000000A8) A/D Compare Function Window B Lower-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADWINLLB : 16; /*!< [15..0] This register is used to compare A window function is
                                           *   used to set the lower level of the window B.                              */
        } ADWINLLB_b;
    };

    union
    {
        __IOM uint16_t ADWINULB;          /*!< (@ 0x000000AA) A/D Compare Function Window B Upper-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADWINULB : 16; /*!< [15..0] This register is used to compare A window function is
                                           *   used to set the higher level of the window B.                             */
        } ADWINULB_b;
    };

    union
    {
        __IOM uint8_t ADCMPBSR;        /*!< (@ 0x000000AC) A/D Compare Function Window B Status Register              */

        struct
        {
            __IOM uint8_t CMPSTB : 1;  /*!< [0..0] Compare window B flag.It is a status flag that shows
                                        *   the comparative result of CH (AN000-AN027, temperature
                                        *   sensor, and internal reference voltage) made the object
                                        *   of window B relation condition.                                           */
            uint8_t : 7;
        } ADCMPBSR_b;
    };
    __IM uint8_t  RESERVED10;
    __IM uint16_t RESERVED11;

    union
    {
        __IM uint16_t ADBUF0;          /*!< (@ 0x000000B0) A/D Data Buffer Register 0                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF0_b;
    };

    union
    {
        __IM uint16_t ADBUF1;          /*!< (@ 0x000000B2) A/D Data Buffer Register 1                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF1_b;
    };

    union
    {
        __IM uint16_t ADBUF2;          /*!< (@ 0x000000B4) A/D Data Buffer Register 2                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF2_b;
    };

    union
    {
        __IM uint16_t ADBUF3;          /*!< (@ 0x000000B6) A/D Data Buffer Register 3                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF3_b;
    };

    union
    {
        __IM uint16_t ADBUF4;          /*!< (@ 0x000000B8) A/D Data Buffer Register 4                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF4_b;
    };

    union
    {
        __IM uint16_t ADBUF5;          /*!< (@ 0x000000BA) A/D Data Buffer Register 5                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF5_b;
    };

    union
    {
        __IM uint16_t ADBUF6;          /*!< (@ 0x000000BC) A/D Data Buffer Register 6                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF6_b;
    };

    union
    {
        __IM uint16_t ADBUF7;          /*!< (@ 0x000000BE) A/D Data Buffer Register 7                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF7_b;
    };

    union
    {
        __IM uint16_t ADBUF8;          /*!< (@ 0x000000C0) A/D Data Buffer Register 8                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF8_b;
    };

    union
    {
        __IM uint16_t ADBUF9;          /*!< (@ 0x000000C2) A/D Data Buffer Register 9                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF9_b;
    };

    union
    {
        __IM uint16_t ADBUF10;         /*!< (@ 0x000000C4) A/D Data Buffer Register 10                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF10_b;
    };

    union
    {
        __IM uint16_t ADBUF11;         /*!< (@ 0x000000C6) A/D Data Buffer Register 11                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF11_b;
    };

    union
    {
        __IM uint16_t ADBUF12;         /*!< (@ 0x000000C8) A/D Data Buffer Register 12                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF12_b;
    };

    union
    {
        __IM uint16_t ADBUF13;         /*!< (@ 0x000000CA) A/D Data Buffer Register 13                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF13_b;
    };

    union
    {
        __IM uint16_t ADBUF14;         /*!< (@ 0x000000CC) A/D Data Buffer Register 14                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF14_b;
    };

    union
    {
        __IM uint16_t ADBUF15;         /*!< (@ 0x000000CE) A/D Data Buffer Register 15                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF15_b;
    };

    union
    {
        __IOM uint8_t ADBUFEN;         /*!< (@ 0x000000D0) A/D Data Buffer Enable Register                            */

        struct
        {
            __IOM uint8_t BUFEN : 1;   /*!< [0..0] Data Buffer Enable                                                 */
            uint8_t             : 7;
        } ADBUFEN_b;
    };
    __IM uint8_t RESERVED12;

    union
    {
        __IOM uint8_t ADBUFPTR;        /*!< (@ 0x000000D2) A/D Data Buffer Pointer Register                           */

        struct
        {
            __IM uint8_t BUFPTR : 4;   /*!< [3..0] Data Buffer PointerThese bits indicate the number of
                                        *   data buffer to which the next A/D converted data is transferred.          */
            __IM uint8_t PTROVF : 1;   /*!< [4..4] Pointer Overflow Flag                                              */
            uint8_t             : 3;
        } ADBUFPTR_b;
    };
    __IM uint8_t  RESERVED13;
    __IM uint16_t RESERVED14[4];
    __IM uint8_t  RESERVED15;

    union
    {
        __IOM uint8_t ADSSTRL;         /*!< (@ 0x000000DD) A/D Sampling State Register L                              */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling Time Setting (AN016-AN027)                                */
        } ADSSTRL_b;
    };

    union
    {
        __IOM uint8_t ADSSTRT;         /*!< (@ 0x000000DE) A/D Sampling State Register T                              */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling Time Setting (temperature sensor output)                  */
        } ADSSTRT_b;
    };

    union
    {
        __IOM uint8_t ADSSTRO;         /*!< (@ 0x000000DF) A/D Sampling State Register O                              */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling Time Setting (Internal reference voltage)                 */
        } ADSSTRO_b;
    };

    union
    {
        __IOM uint8_t ADSSTR[16];      /*!< (@ 0x000000E0) A/D Sampling State Registers                               */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling time setting                                              */
        } ADSSTR_b[16];
    };

    union
    {
        __IOM uint16_t ADANIM;         /*!< (@ 0x000000F0) A/D Channel Input Mode Select Register                     */

        struct
        {
            __IOM uint16_t ANIM0 : 1;  /*!< [0..0] Analog Channel Input Mode Select                                   */
            __IOM uint16_t ANIM1 : 1;  /*!< [1..1] Analog Channel Input Mode Select                                   */
            __IOM uint16_t ANIM2 : 1;  /*!< [2..2] Analog Channel Input Mode Select                                   */
            __IOM uint16_t ANIM3 : 1;  /*!< [3..3] Analog Channel Input Mode Select                                   */
            uint16_t             : 12;
        } ADANIM_b;
    };

    union
    {
        __IOM uint8_t ADCALEXE;        /*!< (@ 0x000000F2) A/D Calibration Execution Register                         */

        struct
        {
            uint8_t              : 6;
            __IM uint8_t  CALMON : 1;  /*!< [6..6] Calibration Status Flag                                            */
            __IOM uint8_t CALEXE : 1;  /*!< [7..7] Calibration Start                                                  */
        } ADCALEXE_b;
    };
    __IM uint8_t RESERVED16;

    union
    {
        __IOM uint8_t VREFAMPCNT;        /*!< (@ 0x000000F4) A/D Dedicated Reference Voltage Circuit Control
                                          *                  Register                                                   */

        struct
        {
            __IOM uint8_t OLDETEN   : 1; /*!< [0..0] OLDET Enable                                                       */
            __IOM uint8_t VREFADCG  : 2; /*!< [2..1] VREFADC Output Voltage Control                                     */
            __IOM uint8_t VREFADCEN : 1; /*!< [3..3] VREFADCG Enable                                                    */
            __IOM uint8_t BGREN     : 1; /*!< [4..4] BGR Enable                                                         */
            uint8_t                 : 2;
            __IOM uint8_t ADSLP     : 1; /*!< [7..7] Sleep                                                              */
        } VREFAMPCNT_b;
    };
    __IM uint8_t  RESERVED17;
    __IM uint16_t RESERVED18;

    union
    {
        __IOM uint16_t ADRD;           /*!< (@ 0x000000F8) A/D Self-Diagnosis Data Register                           */

        struct
        {
            __IM uint16_t AD : 16;     /*!< [15..0] Converted Value 15 to 0                                           */
        } ADRD_b;
    };

    union
    {
        __IM uint8_t ADRST;            /*!< (@ 0x000000FA) A/D Self-Diagnostic Status Register                        */

        struct
        {
            __IM uint8_t DIAGST : 2;   /*!< [1..0] Self-Diagnosis Status                                              */
            uint8_t             : 6;
        } ADRST_b;
    };
    __IM uint8_t  RESERVED19;
    __IM uint16_t RESERVED20[82];

    union
    {
        __IOM uint16_t ADPGACR;           /*!< (@ 0x000001A0) A/D Programmable Gain Amplifier Control Register           */

        struct
        {
            __IOM uint16_t P000SEL0  : 1; /*!< [0..0] A through amplifier is enable for PGA P000                         */
            __IOM uint16_t P000SEL1  : 1; /*!< [1..1] The amplifier passing is enable for PGA P000                       */
            __IOM uint16_t P000ENAMP : 1; /*!< [2..2] Amplifier enable bit for PGA P000                                  */
            __IOM uint16_t P000GEN   : 1; /*!< [3..3] PGA P000 gain setting and enable bit                               */
            __IOM uint16_t P001SEL0  : 1; /*!< [4..4] A through amplifier is enable for PGA P001                         */
            __IOM uint16_t P001SEL1  : 1; /*!< [5..5] The amplifier passing is enable for PGA P001                       */
            __IOM uint16_t P001ENAMP : 1; /*!< [6..6] Amplifier enable bit for PGA P001                                  */
            __IOM uint16_t P001GEN   : 1; /*!< [7..7] PGA P001 gain setting and enable bit                               */
            __IOM uint16_t P002SEL0  : 1; /*!< [8..8] A through amplifier is enable for PGA P002                         */
            __IOM uint16_t P002SEL1  : 1; /*!< [9..9] The amplifier passing is enable for PGA P002                       */
            __IOM uint16_t P002ENAMP : 1; /*!< [10..10] Amplifier enable bit for PGA P002                                */
            __IOM uint16_t P002GEN   : 1; /*!< [11..11] PGA P002 gain setting and enable bit                             */
            __IOM uint16_t P003SEL0  : 1; /*!< [12..12] A through amplifier is enable for PGA P003                       */
            __IOM uint16_t P003SEL1  : 1; /*!< [13..13] The amplifier passing is enable for PGA P003                     */
            __IOM uint16_t P003ENAMP : 1; /*!< [14..14] Amplifier enable bit for PGA P003                                */
            __IOM uint16_t P003GEN   : 1; /*!< [15..15] PGA P003 gain setting and enable bit                             */
        } ADPGACR_b;
    };

    union
    {
        __IOM uint16_t ADPGAGS0;         /*!< (@ 0x000001A2) A/D Programmable Gain Amplifier Gain Setting
                                          *                  Register 0                                                 */

        struct
        {
            __IOM uint16_t P000GAIN : 4; /*!< [3..0] PGA P000 gain setting bit.The gain magnification of (ADPGSDCR0.P000GEN=
                                          *   b) when the shingle end is input and each PGA P000 is set.
                                          *   When the differential motion is input, (ADPGSDCR0.P000GEN=1b)
                                          *   sets the gain magnification when the differential motion
                                          *   is input by the combination with ADPGSDCR0.P000DG 1:0.                    */
            __IOM uint16_t P001GAIN : 4; /*!< [7..4] PGA P001 gain setting bit.The gain magnification of (ADPGSDCR0.P001GEN=
                                          *   b) when the shingle end is input and each PGA P001 is set.
                                          *   When the differential motion is input, (ADPGSDCR0.P001GEN=1b)
                                          *   sets the gain magnification when the differential motion
                                          *   is input by the combination with ADPGSDCR0.P001DG 1:0.                    */
            __IOM uint16_t P002GAIN : 4; /*!< [11..8] PGA P002 gain setting bit.The gain magnification of
                                          *   (ADPGSDCR0.P002GEN=0b) when the shingle end is input and
                                          *   each PGA P002 is set. When the differential motion is input,
                                          *   (ADPGSDCR0.P002GEN=1b) sets the gain magnification when
                                          *   the differential motion is input by the combination with
                                          *   ADPGSDCR0.P002DG 1:0.                                                     */
            __IOM uint16_t P003GAIN : 4; /*!< [15..12] PGA P003 gain setting bit.The gain magnification of
                                          *   (ADPGSDCR0.P003GEN=0b) when the shingle end is input and
                                          *   each PGA P003 is set. When the differential motion is input,
                                          *   (ADPGSDCR0.P003GEN=1b) sets the gain magnification when
                                          *   the differential motion is input by the combination with
                                          *   ADPGSDCR0.P003DG 1:0.                                                     */
        } ADPGAGS0_b;
    };
    __IM uint16_t RESERVED21[6];

    union
    {
        __IOM uint16_t ADPGADCR0;       /*!< (@ 0x000001B0) A/D Programmable Gain Amplifier Differential
                                         *                  Input Control Register                                     */

        struct
        {
            __IOM uint16_t P000DG : 2;  /*!< [1..0] P000 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P000DEN, P000GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P000DEN : 1; /*!< [3..3] P000 Differential Input Enable                                     */
            __IOM uint16_t P001DG  : 2; /*!< [5..4] P001 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P001DEN, P001GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P001DEN : 1; /*!< [7..7] P001 Differential Input Enable                                     */
            __IOM uint16_t P002DG  : 2; /*!< [9..8] P002 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P002DEN, P002GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P002DEN : 1; /*!< [11..11] P002 Differential Input Enable                                   */
            __IOM uint16_t P003DG  : 2; /*!< [13..12] P003 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P003DEN, P003GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P003DEN : 1; /*!< [15..15] P003 Differential Input Enable                                   */
        } ADPGADCR0_b;
    };
    __IM uint16_t RESERVED22;

    union
    {
        __IOM uint8_t ADPGADBS0;       /*!< (@ 0x000001B4) A/D Programmable Gain Amplifier Differential
                                        *                  Input Bias Select Register 0                               */

        struct
        {
            __IOM uint8_t P0BIAS : 1;  /*!< [0..0] Programmable Gain Amplifiers P000 to P002 Bias Voltage
                                        *   SelectNOTE: This bit selects the input bias voltage value
                                        *   when differential inputs are used.                                        */
            uint8_t : 7;
        } ADPGADBS0_b;
    };

    union
    {
        __IOM uint8_t ADPGADBS1;       /*!< (@ 0x000001B5) A/D Programmable Gain Amplifier Differential
                                        *                  Input Bias Select Register 1                               */

        struct
        {
            __IOM uint8_t P3BIAS : 1;  /*!< [0..0] Programmable Gain Amplifiers P003 Bias Voltage SelectNOTE:
                                        *   This bit selects the input bias voltage value when differential
                                        *   inputs are used.                                                          */
            uint8_t : 7;
        } ADPGADBS1_b;
    };
    __IM uint16_t RESERVED23[21];

    union
    {
        __IOM uint8_t ADREFMON;        /*!< (@ 0x000001E0) A/D External Reference Voltage Monitor Register            */

        struct
        {
            __IOM uint8_t PGAMON : 3;  /*!< [2..0] PGA Monitor Output Enable                                          */
            uint8_t              : 5;
        } ADREFMON_b;
    };
    __IM uint8_t  RESERVED24;
    __IM uint16_t RESERVED25;
} R_ADC0_Type;                         /*!< Size = 484 (0x1e4)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_PSCU                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Peripheral Security Control Unit (R_PSCU)
 */

typedef struct                         /*!< (@ 0x400E0000) R_PSCU Structure                                           */
{
    __IM uint32_t RESERVED;

    union
    {
        __IOM uint32_t PSARB;          /*!< (@ 0x00000004) Peripheral Security Attribution Register B                 */

        struct
        {
            uint32_t               : 1;
            __IOM uint32_t PSARB1  : 1; /*!< [1..1] CAN1 and the MSTPCRB.MSTPB1 bit security attribution               */
            __IOM uint32_t PSARB2  : 1; /*!< [2..2] CAN0 and the MSTPCRB.MSTPB2 bit security attribution               */
            __IOM uint32_t PSARB3  : 1; /*!< [3..3] CEC and the MSTPCRB.MSTPB3 bit security attribution                */
            uint32_t               : 2;
            __IM uint32_t  PSARB6  : 1; /*!< [6..6] QSPI and the MSTPCRB.MSTPB6 bit security attribution               */
            __IOM uint32_t PSARB7  : 1; /*!< [7..7] IIC2 and the MSTPCRB.MSTPB7 bit security attribution               */
            __IOM uint32_t PSARB8  : 1; /*!< [8..8] IIC1 and the MSTPCRB.MSTPB8 bit security attribution               */
            __IOM uint32_t PSARB9  : 1; /*!< [9..9] IIC0 and the MSTPCRB.MSTPB9 bit security attribution               */
            uint32_t               : 1;
            __IOM uint32_t PSARB11 : 1; /*!< [11..11] USBFS and the MSTPCRB.MSTPB11 bit security attribution           */
            __IOM uint32_t PSARB12 : 1; /*!< [12..12] USBHS and the MSTPCRB.MSTPB12 bit security attribution           */
            uint32_t               : 2;
            __IM uint32_t PSARB15  : 1; /*!< [15..15] ETHER0/EDMAC0, the MSTPCRB.MSTPB15 bit and the PFENET.PHYMODE0
                                         *   bit security attribution                                                  */
            __IM uint32_t PSARB16  : 1; /*!< [16..16] OSPI and the MSTPCRB.MSTPB16 bit security attribution            */
            uint32_t               : 1;
            __IOM uint32_t PSARB18 : 1; /*!< [18..18] RSPI1 and the MSTPCRB.MSTPB18 bit security attribution           */
            __IOM uint32_t PSARB19 : 1; /*!< [19..19] RSPI0 and the MSTPCRB.MSTPB19 bit security attribution           */
            uint32_t               : 2;
            __IOM uint32_t PSARB22 : 1; /*!< [22..22] SCI9 and the MSTPCRB.MSTPB22 bit security attribution            */
            __IOM uint32_t PSARB23 : 1; /*!< [23..23] SCI8 and the MSTPCRB.MSTPB23 bit security attribution            */
            __IOM uint32_t PSARB24 : 1; /*!< [24..24] SCI7 and the MSTPCRB.MSTPB24 bit security attribution            */
            __IOM uint32_t PSARB25 : 1; /*!< [25..25] SCI6 and the MSTPCRB.MSTPB25 bit security attribution            */
            __IOM uint32_t PSARB26 : 1; /*!< [26..26] SCI5 and the MSTPCRB.MSTPB26 bit security attribution            */
            __IOM uint32_t PSARB27 : 1; /*!< [27..27] SCI4 and the MSTPCRB.MSTPB27 bit security attribution            */
            __IOM uint32_t PSARB28 : 1; /*!< [28..28] SCI3 and the MSTPCRB.MSTPB28 bit security attribution            */
            __IOM uint32_t PSARB29 : 1; /*!< [29..29] SCI2 and the MSTPCRB.MSTPB29 bit security attribution            */
            __IOM uint32_t PSARB30 : 1; /*!< [30..30] SCI1 and the MSTPCRB.MSTPB30 bit security attribution            */
            __IOM uint32_t PSARB31 : 1; /*!< [31..31] SCI0 and the MSTPCRB.MSTPB31 bit security attribution            */
        } PSARB_b;
    };

    union
    {
        __IOM uint32_t PSARC;           /*!< (@ 0x00000008) Peripheral Security Attribution Register C                 */

        struct
        {
            __IOM uint32_t PSARC0  : 1; /*!< [0..0] CAC and the MSTPCRC.MSTPC0 bit security attribution                */
            __IOM uint32_t PSARC1  : 1; /*!< [1..1] CRC and the MSTPCRC.MSTPC1 bit security attribution                */
            uint32_t               : 1;
            __IOM uint32_t PSARC3  : 1; /*!< [3..3] CTSU and the MSTPCRC.MSTPC3 bit security attribution               */
            uint32_t               : 4;
            __IOM uint32_t PSARC8  : 1; /*!< [8..8] SSIE0 and the MSTPCRC.MSTPC8 bit security attribution              */
            uint32_t               : 3;
            __IOM uint32_t PSARC12 : 1; /*!< [12..12] SDHI0 and the MSTPCRC.MSTPC12 bit security attribution           */
            __IOM uint32_t PSARC13 : 1; /*!< [13..13] DOC and the MSTPCRC.MSTPC13 bit security attribution             */
            uint32_t               : 6;
            __IOM uint32_t PSARC20 : 1; /*!< [20..20] TFU and the MSTPCRC.MSTPC20 bit security attribution             */
            uint32_t               : 6;
            __IOM uint32_t PSARC27 : 1; /*!< [27..27] CANFD0 and the MSTPCRC.MSTPC27 bit security attribution          */
            uint32_t               : 3;
            __IOM uint32_t PSARC31 : 1; /*!< [31..31] TSIP and the MSTPCRC.MSTPC31 bit security attribution            */
        } PSARC_b;
    };

    union
    {
        __IOM uint32_t PSARD;           /*!< (@ 0x0000000C) Peripheral Security Attribution Register D                 */

        struct
        {
            __IOM uint32_t PSARD0  : 1; /*!< [0..0] AGT3 and the MSTPCRD.MSTPD0 bit security attribution               */
            __IOM uint32_t PSARD1  : 1; /*!< [1..1] AGT2 and the MSTPCRD.MSTPD1 bit security attribution               */
            __IOM uint32_t PSARD2  : 1; /*!< [2..2] AGT1 and the MSTPCRD.MSTPD2 bit security attribution               */
            __IOM uint32_t PSARD3  : 1; /*!< [3..3] AGT0 and the MSTPCRD.MSTPD3 bit security attribution               */
            uint32_t               : 7;
            __IOM uint32_t PSARD11 : 1; /*!< [11..11] PGI3 and the MSTPCRD.MSTPD11 bit security attribution            */
            __IOM uint32_t PSARD12 : 1; /*!< [12..12] PGI2 and the MSTPCRD.MSTPD12 bit security attribution            */
            __IOM uint32_t PSARD13 : 1; /*!< [13..13] PGI1 and the MSTPCRD.MSTPD13 bit security attribution            */
            __IOM uint32_t PSARD14 : 1; /*!< [14..14] PGI0 and the MSTPCRD.MSTPD14 bit security attribution            */
            __IOM uint32_t PSARD15 : 1; /*!< [15..15] ADC1 and the MSTPCRD.MSTPD15 bit security attribution            */
            __IOM uint32_t PSARD16 : 1; /*!< [16..16] ADC0 and the MSTPCRD.MSTPD16 bit security attribution            */
            uint32_t               : 2;
            __IOM uint32_t PSARD19 : 1; /*!< [19..19] DAC121 and the MSTPCRD.MSTPD19 bit security attribution          */
            __IOM uint32_t PSARD20 : 1; /*!< [20..20] DAC120 and the MSTPCRD.MSTPD20 bit security attribution          */
            uint32_t               : 1;
            __IOM uint32_t PSARD22 : 1; /*!< [22..22] TSN and the MSTPCRD.MSTPD22 bit security attribution             */
            uint32_t               : 2;
            __IOM uint32_t PSARD25 : 1; /*!< [25..25] ACMPHS3 and the MSTPCRD.MSTPD25 bit security attribution         */
            __IOM uint32_t PSARD26 : 1; /*!< [26..26] ACMPHS2 and the MSTPCRD.MSTPD26 bit security attribution         */
            __IOM uint32_t PSARD27 : 1; /*!< [27..27] ACMPHS1 and the MSTPCRD.MSTPD27 bit security attribution         */
            __IOM uint32_t PSARD28 : 1; /*!< [28..28] ACMPHS0 and the MSTPCRD.MSTPD28 bit security attribution         */
            uint32_t               : 3;
        } PSARD_b;
    };

    union
    {
        __IOM uint32_t PSARE;           /*!< (@ 0x00000010) Peripheral Security Attribution Register E                 */

        struct
        {
            __IOM uint32_t PSARE0  : 1; /*!< [0..0] WDT security attribution                                           */
            __IOM uint32_t PSARE1  : 1; /*!< [1..1] IWDT security attribution                                          */
            __IOM uint32_t PSARE2  : 1; /*!< [2..2] RTC security attribution                                           */
            uint32_t               : 11;
            __IOM uint32_t PSARE14 : 1; /*!< [14..14] AGT5 and the MSTPCRE.MSTPE14 bit security attribution            */
            __IOM uint32_t PSARE15 : 1; /*!< [15..15] AGT4 and the MSTPCRE.MSTPE15 bit security attribution            */
            uint32_t               : 6;
            __IOM uint32_t PSARE22 : 1; /*!< [22..22] GPT9 and the MSTPCRE.MSTPE22 bit security attribution            */
            __IOM uint32_t PSARE23 : 1; /*!< [23..23] GPT8 and the MSTPCRE.MSTPE23 bit security attribution            */
            __IOM uint32_t PSARE24 : 1; /*!< [24..24] GPT7 and the MSTPCRE.MSTPE24 bit security attribution            */
            __IOM uint32_t PSARE25 : 1; /*!< [25..25] GPT6 and the MSTPCRE.MSTPE25 bit security attribution            */
            __IOM uint32_t PSARE26 : 1; /*!< [26..26] GPT5 and the MSTPCRE.MSTPE26 bit security attribution            */
            __IOM uint32_t PSARE27 : 1; /*!< [27..27] GPT4 and the MSTPCRE.MSTPE27 bit security attribution            */
            __IOM uint32_t PSARE28 : 1; /*!< [28..28] GPT3 and the MSTPCRE.MSTPE28 bit security attribution            */
            __IOM uint32_t PSARE29 : 1; /*!< [29..29] GPT2 and the MSTPCRE.MSTPE29 bit security attribution            */
            __IOM uint32_t PSARE30 : 1; /*!< [30..30] GPT1 and the MSTPCRE.MSTPE30 bit security attribution            */
            __IOM uint32_t PSARE31 : 1; /*!< [31..31] GPT0 and the MSTPCRE.MSTPE31 bit security attribution            */
        } PSARE_b;
    };

    union
    {
        __IOM uint32_t MSSAR;          /*!< (@ 0x00000014) Module Stop Security Attribution Register                  */

        struct
        {
            __IOM uint32_t MSSAR0 : 1; /*!< [0..0] The MSTPCRC.MSTPC14 bit security attribution                       */
            __IOM uint32_t MSSAR1 : 1; /*!< [1..1] The MSTPCRA.MSTPA22 bit security attribution                       */
            __IOM uint32_t MSSAR2 : 1; /*!< [2..2] The MSTPCRA.MSTPA7 bit security attribution                        */
            __IOM uint32_t MSSAR3 : 1; /*!< [3..3] The MSTPCRA.MSTPA0 bit security attribution                        */
            uint32_t              : 28;
        } MSSAR_b;
    };

    union
    {
        __IM uint32_t CFSAMONA;        /*!< (@ 0x00000018) Code Flash Security Attribution Monitor Register
                                        *                  A                                                          */

        struct
        {
            uint32_t           : 15;
            __IM uint32_t CFS2 : 9;    /*!< [23..15] Code Flash Secure area 2                                         */
            uint32_t           : 8;
        } CFSAMONA_b;
    };

    union
    {
        __IM uint32_t CFSAMONB;        /*!< (@ 0x0000001C) Code Flash Security Attribution Monitor Register
                                        *                  B                                                          */

        struct
        {
            uint32_t           : 10;
            __IM uint32_t CFS1 : 14;   /*!< [23..10] Code Flash Secure area 1                                         */
            uint32_t           : 8;
        } CFSAMONB_b;
    };

    union
    {
        __IM uint32_t DFSAMON;         /*!< (@ 0x00000020) Data Flash Security Attribution Monitor Register           */

        struct
        {
            uint32_t          : 10;
            __IM uint32_t DFS : 6;     /*!< [15..10] Data flash Secure area                                           */
            uint32_t          : 16;
        } DFSAMON_b;
    };

    union
    {
        __IM uint32_t SSAMONA;         /*!< (@ 0x00000024) SRAM Security Attribution Monitor Register A               */

        struct
        {
            uint32_t          : 13;
            __IM uint32_t SS2 : 8;     /*!< [20..13] SRAM Secure area 2                                               */
            uint32_t          : 11;
        } SSAMONA_b;
    };

    union
    {
        __IM uint32_t SSAMONB;         /*!< (@ 0x00000028) SRAM Security Attribution Monitor Register B               */

        struct
        {
            uint32_t          : 10;
            __IM uint32_t SS1 : 11;    /*!< [20..10] SRAM secure area 1                                               */
            uint32_t          : 11;
        } SSAMONB_b;
    };

    union
    {
        __IM uint32_t DLMMON;          /*!< (@ 0x0000002C) Device Lifecycle Management State Monitor Register         */

        struct
        {
            __IM uint32_t DLMMON : 4;  /*!< [3..0] Device Lifecycle Management State Monitor                          */
            uint32_t             : 28;
        } DLMMON_b;
    };
} R_PSCU_Type;                         /*!< Size = 48 (0x30)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_AGT0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Asynchronous General Purpose Timer (R_AGT0)
 */

typedef struct                         /*!< (@ 0x40084000) R_AGT0 Structure                                           */
{
    union
    {
        __IOM uint16_t AGT;            /*!< (@ 0x00000000) AGT Counter Register                                       */

        struct
        {
            __IOM uint16_t AGT : 16;   /*!< [15..0] 16bit counter and reload registerNOTE : When 1 is written
                                        *   to the TSTOP bit in the AGTCRn register, the 16-bit counter
                                        *   is forcibly stopped and set to FFFFH.                                     */
        } AGT_b;
    };

    union
    {
        __IOM uint16_t AGTCMA;          /*!< (@ 0x00000002) AGT Compare Match A Register                               */

        struct
        {
            __IOM uint16_t AGTCMA : 16; /*!< [15..0] AGT Compare Match A data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCRn register, set to
                                         *   FFFFH                                                                     */
        } AGTCMA_b;
    };

    union
    {
        __IOM uint16_t AGTCMB;          /*!< (@ 0x00000004) AGT Compare Match B Register                               */

        struct
        {
            __IOM uint16_t AGTCMB : 16; /*!< [15..0] AGT Compare Match B data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCR register, set to
                                         *   FFFFH                                                                     */
        } AGTCMB_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint8_t AGTCR;           /*!< (@ 0x00000008) AGT Control Register                                       */

        struct
        {
            __IOM uint8_t TSTART : 1;  /*!< [0..0] AGT count start                                                    */
            __IM uint8_t  TCSTF  : 1;  /*!< [1..1] AGT count status flag                                              */
            __OM uint8_t  TSTOP  : 1;  /*!< [2..2] AGT count forced stop                                              */
            uint8_t              : 1;
            __IOM uint8_t TEDGF  : 1;  /*!< [4..4] Active edge judgment flag                                          */
            __IOM uint8_t TUNDF  : 1;  /*!< [5..5] Underflow flag                                                     */
            __IOM uint8_t TCMAF  : 1;  /*!< [6..6] Compare match A flag                                               */
            __IOM uint8_t TCMBF  : 1;  /*!< [7..7] Compare match B flag                                               */
        } AGTCR_b;
    };

    union
    {
        __IOM uint8_t AGTMR1;          /*!< (@ 0x00000009) AGT Mode Register 1                                        */

        struct
        {
            __IOM uint8_t TMOD   : 3;  /*!< [2..0] Operating mode                                                     */
            __IOM uint8_t TEDGPL : 1;  /*!< [3..3] Edge polarity                                                      */
            __IOM uint8_t TCK    : 3;  /*!< [6..4] Count source                                                       */
            uint8_t              : 1;
        } AGTMR1_b;
    };

    union
    {
        __IOM uint8_t AGTMR2;          /*!< (@ 0x0000000A) AGT Mode Register 2                                        */

        struct
        {
            __IOM uint8_t CKS : 3;     /*!< [2..0] AGTLCLK/AGTSCLK count source clock frequency division
                                        *   ratio                                                                     */
            uint8_t           : 4;
            __IOM uint8_t LPM : 1;     /*!< [7..7] Low Power Mode                                                     */
        } AGTMR2_b;
    };
    __IM uint8_t RESERVED1;

    union
    {
        __IOM uint8_t AGTIOC;          /*!< (@ 0x0000000C) AGT I/O Control Register                                   */

        struct
        {
            __IOM uint8_t TEDGSEL : 1; /*!< [0..0] I/O polarity switchFunction varies depending on the operating
                                        *   mode.                                                                     */
            uint8_t             : 1;
            __IOM uint8_t TOE   : 1;   /*!< [2..2] AGTOn output enable                                                */
            uint8_t             : 1;
            __IOM uint8_t TIPF  : 2;   /*!< [5..4] Input filter                                                       */
            __IOM uint8_t TIOGT : 2;   /*!< [7..6] Count control                                                      */
        } AGTIOC_b;
    };

    union
    {
        __IOM uint8_t AGTISR;          /*!< (@ 0x0000000D) AGT Event Pin Select Register                              */

        struct
        {
            uint8_t            : 2;
            __IOM uint8_t EEPS : 1;    /*!< [2..2] AGTEE polarty selection                                            */
            uint8_t            : 5;
        } AGTISR_b;
    };

    union
    {
        __IOM uint8_t AGTCMSR;         /*!< (@ 0x0000000E) AGT Compare Match Function Select Register                 */

        struct
        {
            __IOM uint8_t TCMEA  : 1;  /*!< [0..0] Compare match A register enable                                    */
            __IOM uint8_t TOEA   : 1;  /*!< [1..1] AGTOA output enable                                                */
            __IOM uint8_t TOPOLA : 1;  /*!< [2..2] AGTOA polarity select                                              */
            uint8_t              : 1;
            __IOM uint8_t TCMEB  : 1;  /*!< [4..4] Compare match B register enable                                    */
            __IOM uint8_t TOEB   : 1;  /*!< [5..5] AGTOB output enable                                                */
            __IOM uint8_t TOPOLB : 1;  /*!< [6..6] AGTOB polarity select                                              */
            uint8_t              : 1;
        } AGTCMSR_b;
    };

    union
    {
        __IOM uint8_t AGTIOSEL;        /*!< (@ 0x0000000F) AGT Pin Select Register                                    */

        struct
        {
            __IOM uint8_t SEL  : 2;    /*!< [1..0] AGTIO pin select                                                   */
            uint8_t            : 2;
            __IOM uint8_t TIES : 1;    /*!< [4..4] AGTIO input enable                                                 */
            uint8_t            : 3;
        } AGTIOSEL_b;
    };
} R_AGT0_Type;                         /*!< Size = 16 (0x10)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_AGTW0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Asynchronous General Purpose Timer (R_AGTW0)
 */

 #ifndef BSP_OVERRIDE_REG_R_AGTW0_TYPE

typedef struct                         /*!< (@ 0x40084000) R_AGTW0 Structure                                          */
{
    union
    {
        __IOM uint32_t AGT;            /*!< (@ 0x00000000) AGT Counter Register                                       */

        struct
        {
            __IOM uint32_t AGT : 32;   /*!< [31..0] 16bit counter and reload registerNOTE : When 1 is written
                                        *   to the TSTOP bit in the AGTCRn register, the 16-bit counter
                                        *   is forcibly stopped and set to FFFFH.                                     */
        } AGT_b;
    };

    union
    {
        __IOM uint32_t AGTCMA;          /*!< (@ 0x00000004) AGT Compare Match A Register                               */

        struct
        {
            __IOM uint32_t AGTCMA : 32; /*!< [31..0] AGT Compare Match A data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCRn register, set to
                                         *   FFFFH                                                                     */
        } AGTCMA_b;
    };

    union
    {
        __IOM uint32_t AGTCMB;          /*!< (@ 0x00000008) AGT Compare Match B Register                               */

        struct
        {
            __IOM uint32_t AGTCMB : 32; /*!< [31..0] AGT Compare Match B data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCR register, set to
                                         *   FFFFH                                                                     */
        } AGTCMB_b;
    };

    union
    {
        __IOM uint8_t AGTCR;           /*!< (@ 0x0000000C) AGT Control Register                                       */

        struct
        {
            __IOM uint8_t TSTART : 1;  /*!< [0..0] AGT count start                                                    */
            __IM uint8_t  TCSTF  : 1;  /*!< [1..1] AGT count status flag                                              */
            __OM uint8_t  TSTOP  : 1;  /*!< [2..2] AGT count forced stop                                              */
            uint8_t              : 1;
            __IOM uint8_t TEDGF  : 1;  /*!< [4..4] Active edge judgment flag                                          */
            __IOM uint8_t TUNDF  : 1;  /*!< [5..5] Underflow flag                                                     */
            __IOM uint8_t TCMAF  : 1;  /*!< [6..6] Compare match A flag                                               */
            __IOM uint8_t TCMBF  : 1;  /*!< [7..7] Compare match B flag                                               */
        } AGTCR_b;
    };

    union
    {
        __IOM uint8_t AGTMR1;          /*!< (@ 0x0000000D) AGT Mode Register 1                                        */

        struct
        {
            __IOM uint8_t TMOD   : 3;  /*!< [2..0] Operating mode                                                     */
            __IOM uint8_t TEDGPL : 1;  /*!< [3..3] Edge polarity                                                      */
            __IOM uint8_t TCK    : 3;  /*!< [6..4] Count source                                                       */
            uint8_t              : 1;
        } AGTMR1_b;
    };

    union
    {
        __IOM uint8_t AGTMR2;          /*!< (@ 0x0000000E) AGT Mode Register 2                                        */

        struct
        {
            __IOM uint8_t CKS : 3;     /*!< [2..0] AGTLCLK/AGTSCLK count source clock frequency division
                                        *   ratio                                                                     */
            uint8_t           : 4;
            __IOM uint8_t LPM : 1;     /*!< [7..7] Low Power Mode                                                     */
        } AGTMR2_b;
    };

    union
    {
        __IOM uint8_t AGTIOSEL;        /*!< (@ 0x0000000F) AGT Pin Select Register                                    */

        struct
        {
            uint8_t            : 4;
            __IOM uint8_t TIES : 1;    /*!< [4..4] AGTIO input enable                                                 */
            uint8_t            : 3;
        } AGTIOSEL_b;
    };

    union
    {
        __IOM uint8_t AGTIOC;          /*!< (@ 0x00000010) AGT I/O Control Register                                   */

        struct
        {
            __IOM uint8_t TEDGSEL : 1; /*!< [0..0] I/O polarity switchFunction varies depending on the operating
                                        *   mode.                                                                     */
            uint8_t             : 1;
            __IOM uint8_t TOE   : 1;   /*!< [2..2] AGTOn output enable                                                */
            uint8_t             : 1;
            __IOM uint8_t TIPF  : 2;   /*!< [5..4] Input filter                                                       */
            __IOM uint8_t TIOGT : 2;   /*!< [7..6] Count control                                                      */
        } AGTIOC_b;
    };

    union
    {
        __IOM uint8_t AGTISR;          /*!< (@ 0x00000011) AGT Event Pin Select Register                              */

        struct
        {
            uint8_t            : 2;
            __IOM uint8_t EEPS : 1;    /*!< [2..2] AGTEE polarty selection                                            */
            uint8_t            : 5;
        } AGTISR_b;
    };

    union
    {
        __IOM uint8_t AGTCMSR;         /*!< (@ 0x00000012) AGT Compare Match Function Select Register                 */

        struct
        {
            __IOM uint8_t TCMEA  : 1;  /*!< [0..0] Compare match A register enable                                    */
            __IOM uint8_t TOEA   : 1;  /*!< [1..1] AGTOA output enable                                                */
            __IOM uint8_t TOPOLA : 1;  /*!< [2..2] AGTOA polarity select                                              */
            uint8_t              : 1;
            __IOM uint8_t TCMEB  : 1;  /*!< [4..4] Compare match B register enable                                    */
            __IOM uint8_t TOEB   : 1;  /*!< [5..5] AGTOB output enable                                                */
            __IOM uint8_t TOPOLB : 1;  /*!< [6..6] AGTOB polarity select                                              */
            uint8_t              : 1;
        } AGTCMSR_b;
    };
    __IM uint8_t RESERVED;
} R_AGTW0_Type;                        /*!< Size = 20 (0x14)                                                          */

 #endif

/* =========================================================================================================================== */
/* ================                                           R_BUS                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Bus Interface (R_BUS)
 */

typedef struct                          /*!< (@ 0x40003000) R_BUS Structure                                            */
{
    __IOM R_BUS_CSa_Type CSa[8];        /*!< (@ 0x00000000) CS Registers                                               */
    __IM uint32_t        RESERVED[480];
    __IOM R_BUS_CSb_Type CSb[8];        /*!< (@ 0x00000800) CS Registers                                               */

    union
    {
        __IOM uint16_t CSRECEN;         /*!< (@ 0x00000880) CS Recovery Cycle Insertion Enable Register                */

        struct
        {
            __IOM uint16_t RCVEN0  : 1; /*!< [0..0] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN1  : 1; /*!< [1..1] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN2  : 1; /*!< [2..2] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN3  : 1; /*!< [3..3] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN4  : 1; /*!< [4..4] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN5  : 1; /*!< [5..5] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN6  : 1; /*!< [6..6] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN7  : 1; /*!< [7..7] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVENM0 : 1; /*!< [8..8] Multiplexed Bus Recovery Cycle Insertion Enable                    */
            __IOM uint16_t RCVENM1 : 1; /*!< [9..9] Multiplexed Bus Recovery Cycle Insertion Enable                    */
            __IOM uint16_t RCVENM2 : 1; /*!< [10..10] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM3 : 1; /*!< [11..11] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM4 : 1; /*!< [12..12] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM5 : 1; /*!< [13..13] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM6 : 1; /*!< [14..14] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM7 : 1; /*!< [15..15] Multiplexed Bus Recovery Cycle Insertion Enable                  */
        } CSRECEN_b;
    };
    __IM uint16_t           RESERVED1;
    __IM uint32_t           RESERVED2[223];
    __IOM R_BUS_SDRAM_Type  SDRAM;      /*!< (@ 0x00000C00) SDRAM Registers                                            */
    __IM uint32_t           RESERVED3[235];
    __IOM R_BUS_BUSM_Type   BUSM[6];    /*!< (@ 0x00001000) Master Bus Control Register Array                          */
    __IM uint32_t           RESERVED4[58];
    __IOM R_BUS_BUSS_Type   BUSS[16];   /*!< (@ 0x00001100) Slave Bus Control Register Array                           */
    __IM uint32_t           RESERVED5[432];
    __IOM R_BUS_BUSERR_Type BUSERR[11]; /*!< (@ 0x00001800) Bus Error Registers                                        */
} R_BUS_Type;                           /*!< Size = 6320 (0x18b0)                                                      */

/* =========================================================================================================================== */
/* ================                                           R_CAC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Clock Frequency Accuracy Measurement Circuit (R_CAC)
 */

typedef struct                         /*!< (@ 0x40044600) R_CAC Structure                                            */
{
    union
    {
        __IOM uint8_t CACR0;           /*!< (@ 0x00000000) CAC Control Register 0                                     */

        struct
        {
            __IOM uint8_t CFME : 1;    /*!< [0..0] Clock Frequency Measurement Enable.                                */
            uint8_t            : 7;
        } CACR0_b;
    };

    union
    {
        __IOM uint8_t CACR1;           /*!< (@ 0x00000001) CAC Control Register 1                                     */

        struct
        {
            __IOM uint8_t CACREFE : 1; /*!< [0..0] CACREF Pin Input Enable                                            */
            __IOM uint8_t FMCS    : 3; /*!< [3..1] Measurement Target Clock Select                                    */
            __IOM uint8_t TCSS    : 2; /*!< [5..4] Measurement Target Clock Frequency Division Ratio Select           */
            __IOM uint8_t EDGES   : 2; /*!< [7..6] Valid Edge Select                                                  */
        } CACR1_b;
    };

    union
    {
        __IOM uint8_t CACR2;           /*!< (@ 0x00000002) CAC Control Register 2                                     */

        struct
        {
            __IOM uint8_t RPS  : 1;    /*!< [0..0] Reference Signal Select                                            */
            __IOM uint8_t RSCS : 3;    /*!< [3..1] Measurement Reference Clock Select                                 */
            __IOM uint8_t RCDS : 2;    /*!< [5..4] Measurement Reference Clock Frequency Division Ratio
                                        *   Select                                                                    */
            __IOM uint8_t DFS : 2;     /*!< [7..6] Digital Filter Selection                                           */
        } CACR2_b;
    };

    union
    {
        __IOM uint8_t CAICR;           /*!< (@ 0x00000003) CAC Interrupt Control Register                             */

        struct
        {
            __IOM uint8_t FERRIE : 1;  /*!< [0..0] Frequency Error Interrupt Request Enable                           */
            __IOM uint8_t MENDIE : 1;  /*!< [1..1] Measurement End Interrupt Request Enable                           */
            __IOM uint8_t OVFIE  : 1;  /*!< [2..2] Overflow Interrupt Request Enable                                  */
            uint8_t              : 1;
            __OM uint8_t FERRFCL : 1;  /*!< [4..4] FERRF Clear                                                        */
            __OM uint8_t MENDFCL : 1;  /*!< [5..5] MENDF Clear                                                        */
            __OM uint8_t OVFFCL  : 1;  /*!< [6..6] OVFF Clear                                                         */
            uint8_t              : 1;
        } CAICR_b;
    };

    union
    {
        __IM uint8_t CASTR;            /*!< (@ 0x00000004) CAC Status Register                                        */

        struct
        {
            __IM uint8_t FERRF : 1;    /*!< [0..0] Frequency Error Flag                                               */
            __IM uint8_t MENDF : 1;    /*!< [1..1] Measurement End Flag                                               */
            __IM uint8_t OVFF  : 1;    /*!< [2..2] Counter Overflow Flag                                              */
            uint8_t            : 5;
        } CASTR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t CAULVR;          /*!< (@ 0x00000006) CAC Upper-Limit Value Setting Register                     */

        struct
        {
            __IOM uint16_t CAULVR : 16; /*!< [15..0] CAULVR is a 16-bit readable/writable register that stores
                                         *   the upper-limit value of the frequency.                                   */
        } CAULVR_b;
    };

    union
    {
        __IOM uint16_t CALLVR;          /*!< (@ 0x00000008) CAC Lower-Limit Value Setting Register                     */

        struct
        {
            __IOM uint16_t CALLVR : 16; /*!< [15..0] CALLVR is a 16-bit readable/writable register that stores
                                         *   the lower-limit value of the frequency.                                   */
        } CALLVR_b;
    };

    union
    {
        __IM uint16_t CACNTBR;          /*!< (@ 0x0000000A) CAC Counter Buffer Register                                */

        struct
        {
            __IM uint16_t CACNTBR : 16; /*!< [15..0] CACNTBR is a 16-bit read-only register that retains
                                         *   the counter value at the time a valid reference signal
                                         *   edge is input                                                             */
        } CACNTBR_b;
    };
} R_CAC_Type;                           /*!< Size = 12 (0xc)                                                           */

/* =========================================================================================================================== */
/* ================                                          R_CAN0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Controller Area Network (CAN) Module (R_CAN0)
 */

typedef struct                         /*!< (@ 0x40050000) R_CAN0 Structure                                           */
{
    __IM uint32_t        RESERVED[128];
    __IOM R_CAN0_MB_Type MB[32];       /*!< (@ 0x00000200) Mailbox                                                    */

    union
    {
        __IOM uint32_t MKR[8];         /*!< (@ 0x00000400) Mask Register                                              */

        struct
        {
            __IOM uint32_t EID : 18;   /*!< [17..0] Extended ID                                                       */
            __IOM uint32_t SID : 11;   /*!< [28..18] Standard ID                                                      */
            uint32_t           : 3;
        } MKR_b[8];
    };

    union
    {
        __IOM uint32_t FIDCR[2];       /*!< (@ 0x00000420) FIFO Received ID Compare Registers                         */

        struct
        {
            __IOM uint32_t EID : 18;   /*!< [17..0] Extended ID                                                       */
            __IOM uint32_t SID : 11;   /*!< [28..18] Standard ID                                                      */
            uint32_t           : 1;
            __IOM uint32_t RTR : 1;    /*!< [30..30] Remote Transmission Request                                      */
            __IOM uint32_t IDE : 1;    /*!< [31..31] ID Extension                                                     */
        } FIDCR_b[2];
    };

    union
    {
        __IOM uint32_t MKIVLR;         /*!< (@ 0x00000428) Mask Invalid Register                                      */

        struct
        {
            __IOM uint32_t MB0  : 1;   /*!< [0..0] mailbox 0 Mask Invalid                                             */
            __IOM uint32_t MB1  : 1;   /*!< [1..1] mailbox 1 Mask Invalid                                             */
            __IOM uint32_t MB2  : 1;   /*!< [2..2] mailbox 2 Mask Invalid                                             */
            __IOM uint32_t MB3  : 1;   /*!< [3..3] mailbox 3 Mask Invalid                                             */
            __IOM uint32_t MB4  : 1;   /*!< [4..4] mailbox 4 Mask Invalid                                             */
            __IOM uint32_t MB5  : 1;   /*!< [5..5] mailbox 5 Mask Invalid                                             */
            __IOM uint32_t MB6  : 1;   /*!< [6..6] mailbox 6 Mask Invalid                                             */
            __IOM uint32_t MB7  : 1;   /*!< [7..7] mailbox 7 Mask Invalid                                             */
            __IOM uint32_t MB8  : 1;   /*!< [8..8] mailbox 8 Mask Invalid                                             */
            __IOM uint32_t MB9  : 1;   /*!< [9..9] mailbox 9 Mask Invalid                                             */
            __IOM uint32_t MB10 : 1;   /*!< [10..10] mailbox 10 Mask Invalid                                          */
            __IOM uint32_t MB11 : 1;   /*!< [11..11] mailbox 11 Mask Invalid                                          */
            __IOM uint32_t MB12 : 1;   /*!< [12..12] mailbox 12 Mask Invalid                                          */
            __IOM uint32_t MB13 : 1;   /*!< [13..13] mailbox 13 Mask Invalid                                          */
            __IOM uint32_t MB14 : 1;   /*!< [14..14] mailbox 14 Mask Invalid                                          */
            __IOM uint32_t MB15 : 1;   /*!< [15..15] mailbox 15 Mask Invalid                                          */
            __IOM uint32_t MB16 : 1;   /*!< [16..16] mailbox 16 Mask Invalid                                          */
            __IOM uint32_t MB17 : 1;   /*!< [17..17] mailbox 17 Mask Invalid                                          */
            __IOM uint32_t MB18 : 1;   /*!< [18..18] mailbox 18 Mask Invalid                                          */
            __IOM uint32_t MB19 : 1;   /*!< [19..19] mailbox 19 Mask Invalid                                          */
            __IOM uint32_t MB20 : 1;   /*!< [20..20] mailbox 20 Mask Invalid                                          */
            __IOM uint32_t MB21 : 1;   /*!< [21..21] mailbox 21 Mask Invalid                                          */
            __IOM uint32_t MB22 : 1;   /*!< [22..22] mailbox 22 Mask Invalid                                          */
            __IOM uint32_t MB23 : 1;   /*!< [23..23] mailbox 23 Mask Invalid                                          */
            __IOM uint32_t MB24 : 1;   /*!< [24..24] mailbox 24 Mask Invalid                                          */
            __IOM uint32_t MB25 : 1;   /*!< [25..25] mailbox 25 Mask Invalid                                          */
            __IOM uint32_t MB26 : 1;   /*!< [26..26] mailbox 26 Mask Invalid                                          */
            __IOM uint32_t MB27 : 1;   /*!< [27..27] mailbox 27 Mask Invalid                                          */
            __IOM uint32_t MB28 : 1;   /*!< [28..28] mailbox 28 Mask Invalid                                          */
            __IOM uint32_t MB29 : 1;   /*!< [29..29] mailbox 29 Mask Invalid                                          */
            __IOM uint32_t MB30 : 1;   /*!< [30..30] mailbox 30 Mask Invalid                                          */
            __IOM uint32_t MB31 : 1;   /*!< [31..31] mailbox 31 Mask Invalid                                          */
        } MKIVLR_b;
    };

    union
    {
        union
        {
            __IOM uint32_t MIER;         /*!< (@ 0x0000042C) Mailbox Interrupt Enable Register                          */

            struct
            {
                __IOM uint32_t MB0  : 1; /*!< [0..0] mailbox 0 Interrupt Enable                                         */
                __IOM uint32_t MB1  : 1; /*!< [1..1] mailbox 1 Interrupt Enable                                         */
                __IOM uint32_t MB2  : 1; /*!< [2..2] mailbox 2 Interrupt Enable                                         */
                __IOM uint32_t MB3  : 1; /*!< [3..3] mailbox 3 Interrupt Enable                                         */
                __IOM uint32_t MB4  : 1; /*!< [4..4] mailbox 4 Interrupt Enable                                         */
                __IOM uint32_t MB5  : 1; /*!< [5..5] mailbox 5 Interrupt Enable                                         */
                __IOM uint32_t MB6  : 1; /*!< [6..6] mailbox 6 Interrupt Enable                                         */
                __IOM uint32_t MB7  : 1; /*!< [7..7] mailbox 7 Interrupt Enable                                         */
                __IOM uint32_t MB8  : 1; /*!< [8..8] mailbox 8 Interrupt Enable                                         */
                __IOM uint32_t MB9  : 1; /*!< [9..9] mailbox 9 Interrupt Enable                                         */
                __IOM uint32_t MB10 : 1; /*!< [10..10] mailbox 10 Interrupt Enable                                      */
                __IOM uint32_t MB11 : 1; /*!< [11..11] mailbox 11 Interrupt Enable                                      */
                __IOM uint32_t MB12 : 1; /*!< [12..12] mailbox 12 Interrupt Enable                                      */
                __IOM uint32_t MB13 : 1; /*!< [13..13] mailbox 13 Interrupt Enable                                      */
                __IOM uint32_t MB14 : 1; /*!< [14..14] mailbox 14 Interrupt Enable                                      */
                __IOM uint32_t MB15 : 1; /*!< [15..15] mailbox 15 Interrupt Enable                                      */
                __IOM uint32_t MB16 : 1; /*!< [16..16] mailbox 16 Interrupt Enable                                      */
                __IOM uint32_t MB17 : 1; /*!< [17..17] mailbox 17 Interrupt Enable                                      */
                __IOM uint32_t MB18 : 1; /*!< [18..18] mailbox 18 Interrupt Enable                                      */
                __IOM uint32_t MB19 : 1; /*!< [19..19] mailbox 19 Interrupt Enable                                      */
                __IOM uint32_t MB20 : 1; /*!< [20..20] mailbox 20 Interrupt Enable                                      */
                __IOM uint32_t MB21 : 1; /*!< [21..21] mailbox 21 Interrupt Enable                                      */
                __IOM uint32_t MB22 : 1; /*!< [22..22] mailbox 22 Interrupt Enable                                      */
                __IOM uint32_t MB23 : 1; /*!< [23..23] mailbox 23 Interrupt Enable                                      */
                __IOM uint32_t MB24 : 1; /*!< [24..24] mailbox 24 Interrupt Enable                                      */
                __IOM uint32_t MB25 : 1; /*!< [25..25] mailbox 25 Interrupt Enable                                      */
                __IOM uint32_t MB26 : 1; /*!< [26..26] mailbox 26 Interrupt Enable                                      */
                __IOM uint32_t MB27 : 1; /*!< [27..27] mailbox 27 Interrupt Enable                                      */
                __IOM uint32_t MB28 : 1; /*!< [28..28] mailbox 28 Interrupt Enable                                      */
                __IOM uint32_t MB29 : 1; /*!< [29..29] mailbox 29 Interrupt Enable                                      */
                __IOM uint32_t MB30 : 1; /*!< [30..30] mailbox 30 Interrupt Enable                                      */
                __IOM uint32_t MB31 : 1; /*!< [31..31] mailbox 31 Interrupt Enable                                      */
            } MIER_b;
        };

        union
        {
            __IOM uint32_t MIER_FIFO;    /*!< (@ 0x0000042C) Mailbox Interrupt Enable Register for FIFO Mailbox
                                          *                  Mode                                                       */

            struct
            {
                __IOM uint32_t MB0  : 1; /*!< [0..0] mailbox 0 Interrupt Enable                                         */
                __IOM uint32_t MB1  : 1; /*!< [1..1] mailbox 1 Interrupt Enable                                         */
                __IOM uint32_t MB2  : 1; /*!< [2..2] mailbox 2 Interrupt Enable                                         */
                __IOM uint32_t MB3  : 1; /*!< [3..3] mailbox 3 Interrupt Enable                                         */
                __IOM uint32_t MB4  : 1; /*!< [4..4] mailbox 4 Interrupt Enable                                         */
                __IOM uint32_t MB5  : 1; /*!< [5..5] mailbox 5 Interrupt Enable                                         */
                __IOM uint32_t MB6  : 1; /*!< [6..6] mailbox 6 Interrupt Enable                                         */
                __IOM uint32_t MB7  : 1; /*!< [7..7] mailbox 7 Interrupt Enable                                         */
                __IOM uint32_t MB8  : 1; /*!< [8..8] mailbox 8 Interrupt Enable                                         */
                __IOM uint32_t MB9  : 1; /*!< [9..9] mailbox 9 Interrupt Enable                                         */
                __IOM uint32_t MB10 : 1; /*!< [10..10] mailbox 10 Interrupt Enable                                      */
                __IOM uint32_t MB11 : 1; /*!< [11..11] mailbox 11 Interrupt Enable                                      */
                __IOM uint32_t MB12 : 1; /*!< [12..12] mailbox 12 Interrupt Enable                                      */
                __IOM uint32_t MB13 : 1; /*!< [13..13] mailbox 13 Interrupt Enable                                      */
                __IOM uint32_t MB14 : 1; /*!< [14..14] mailbox 14 Interrupt Enable                                      */
                __IOM uint32_t MB15 : 1; /*!< [15..15] mailbox 15 Interrupt Enable                                      */
                __IOM uint32_t MB16 : 1; /*!< [16..16] mailbox 16 Interrupt Enable                                      */
                __IOM uint32_t MB17 : 1; /*!< [17..17] mailbox 17 Interrupt Enable                                      */
                __IOM uint32_t MB18 : 1; /*!< [18..18] mailbox 18 Interrupt Enable                                      */
                __IOM uint32_t MB19 : 1; /*!< [19..19] mailbox 19 Interrupt Enable                                      */
                __IOM uint32_t MB20 : 1; /*!< [20..20] mailbox 20 Interrupt Enable                                      */
                __IOM uint32_t MB21 : 1; /*!< [21..21] mailbox 21 Interrupt Enable                                      */
                __IOM uint32_t MB22 : 1; /*!< [22..22] mailbox 22 Interrupt Enable                                      */
                __IOM uint32_t MB23 : 1; /*!< [23..23] mailbox 23 Interrupt Enable                                      */
                __IOM uint32_t MB24 : 1; /*!< [24..24] Transmit FIFO Interrupt Enable                                   */
                __IOM uint32_t MB25 : 1; /*!< [25..25] Transmit FIFO Interrupt Generation Timing Control                */
                uint32_t            : 2;
                __IOM uint32_t MB28 : 1; /*!< [28..28] Receive FIFO Interrupt Enable                                    */
                __IOM uint32_t MB29 : 1; /*!< [29..29] Receive FIFO Interrupt Generation Timing Control                 */
                uint32_t            : 2;
            } MIER_FIFO_b;
        };
    };
    __IM uint32_t RESERVED1[252];

    union
    {
        union
        {
            __IOM uint8_t MCTL_TX[32];       /*!< (@ 0x00000820) Message Control Register for Transmit                      */

            struct
            {
                __IOM uint8_t SENTDATA  : 1; /*!< [0..0] Transmission Complete Flag                                         */
                __IM uint8_t  TRMACTIVE : 1; /*!< [1..1] Transmission-in-Progress Status Flag (Transmit mailbox
                                              *   setting enabled)                                                          */
                __IOM uint8_t TRMABT : 1;    /*!< [2..2] Transmission Abort Complete Flag (Transmit mailbox setting
                                              *   enabled)                                                                  */
                uint8_t               : 1;
                __IOM uint8_t ONESHOT : 1;   /*!< [4..4] One-Shot Enable                                                    */
                uint8_t               : 1;
                __IOM uint8_t RECREQ  : 1;   /*!< [6..6] Receive Mailbox Request                                            */
                __IOM uint8_t TRMREQ  : 1;   /*!< [7..7] Transmit Mailbox Request                                           */
            } MCTL_TX_b[32];
        };

        union
        {
            __IOM uint8_t MCTL_RX[32];       /*!< (@ 0x00000820) Message Control Register for Receive                       */

            struct
            {
                __IOM uint8_t NEWDATA   : 1; /*!< [0..0] Reception Complete Flag                                            */
                __IM uint8_t  INVALDATA : 1; /*!< [1..1] Reception-in-Progress Status Flag (Receive mailbox setting
                                              *   enabled)                                                                  */
                __IOM uint8_t MSGLOST : 1;   /*!< [2..2] Message Lost Flag(Receive mailbox setting enabled)                 */
                uint8_t               : 1;
                __IOM uint8_t ONESHOT : 1;   /*!< [4..4] One-Shot Enable                                                    */
                uint8_t               : 1;
                __IOM uint8_t RECREQ  : 1;   /*!< [6..6] Receive Mailbox Request                                            */
                __IOM uint8_t TRMREQ  : 1;   /*!< [7..7] Transmit Mailbox Request                                           */
            } MCTL_RX_b[32];
        };
    };

    union
    {
        __IOM uint16_t CTLR;           /*!< (@ 0x00000840) Control Register                                           */

        struct
        {
            __IOM uint16_t MBM  : 1;   /*!< [0..0] CAN Mailbox Mode Select                                            */
            __IOM uint16_t IDFM : 2;   /*!< [2..1] ID Format Mode Select                                              */
            __IOM uint16_t MLM  : 1;   /*!< [3..3] Message Lost Mode Select                                           */
            __IOM uint16_t TPM  : 1;   /*!< [4..4] Transmission Priority Mode Select                                  */
            __IOM uint16_t TSRC : 1;   /*!< [5..5] Time Stamp Counter Reset Command                                   */
            __IOM uint16_t TSPS : 2;   /*!< [7..6] Time Stamp Prescaler Select                                        */
            __IOM uint16_t CANM : 2;   /*!< [9..8] CAN Operating Mode Select                                          */
            __IOM uint16_t SLPM : 1;   /*!< [10..10] CAN Sleep Mode                                                   */
            __IOM uint16_t BOM  : 2;   /*!< [12..11] Bus-Off Recovery Mode by a program request                       */
            __IOM uint16_t RBOC : 1;   /*!< [13..13] Forcible Return From Bus-Off                                     */
            uint16_t            : 2;
        } CTLR_b;
    };

    union
    {
        __IM uint16_t STR;             /*!< (@ 0x00000842) Status Register                                            */

        struct
        {
            __IM uint16_t NDST  : 1;   /*!< [0..0] NEWDATA Status Flag                                                */
            __IM uint16_t SDST  : 1;   /*!< [1..1] SENTDATA Status Flag                                               */
            __IM uint16_t RFST  : 1;   /*!< [2..2] Receive FIFO Status Flag                                           */
            __IM uint16_t TFST  : 1;   /*!< [3..3] Transmit FIFO Status Flag                                          */
            __IM uint16_t NMLST : 1;   /*!< [4..4] Normal Mailbox Message Lost Status Flag                            */
            __IM uint16_t FMLST : 1;   /*!< [5..5] FIFO Mailbox Message Lost Status Flag                              */
            __IM uint16_t TABST : 1;   /*!< [6..6] Transmission Abort Status Flag                                     */
            __IM uint16_t EST   : 1;   /*!< [7..7] Error Status Flag                                                  */
            __IM uint16_t RSTST : 1;   /*!< [8..8] CAN Reset Status Flag                                              */
            __IM uint16_t HLTST : 1;   /*!< [9..9] CAN Halt Status Flag                                               */
            __IM uint16_t SLPST : 1;   /*!< [10..10] CAN Sleep Status Flag                                            */
            __IM uint16_t EPST  : 1;   /*!< [11..11] Error-Passive Status Flag                                        */
            __IM uint16_t BOST  : 1;   /*!< [12..12] Bus-Off Status Flag                                              */
            __IM uint16_t TRMST : 1;   /*!< [13..13] Transmit Status Flag (transmitter)                               */
            __IM uint16_t RECST : 1;   /*!< [14..14] Receive Status Flag (receiver)                                   */
            uint16_t            : 1;
        } STR_b;
    };

    union
    {
        __IOM uint32_t BCR;            /*!< (@ 0x00000844) Bit Configuration Register                                 */

        struct
        {
            __IOM uint32_t CCLKS : 1;  /*!< [0..0] CAN Clock Source Selection                                         */
            uint32_t             : 7;
            __IOM uint32_t TSEG2 : 3;  /*!< [10..8] Time Segment 2 Control                                            */
            uint32_t             : 1;
            __IOM uint32_t SJW   : 2;  /*!< [13..12] Resynchronization Jump Width Control                             */
            uint32_t             : 2;
            __IOM uint32_t BRP   : 10; /*!< [25..16] Prescaler Division Ratio Select . These bits set the
                                        *   frequency of the CAN communication clock (fCANCLK).                       */
            uint32_t             : 2;
            __IOM uint32_t TSEG1 : 4;  /*!< [31..28] Time Segment 1 Control                                           */
        } BCR_b;
    };

    union
    {
        __IOM uint8_t RFCR;            /*!< (@ 0x00000848) Receive FIFO Control Register                              */

        struct
        {
            __IOM uint8_t RFE   : 1;   /*!< [0..0] Receive FIFO Enable                                                */
            __IM uint8_t  RFUST : 3;   /*!< [3..1] Receive FIFO Unread Message Number Status                          */
            __IOM uint8_t RFMLF : 1;   /*!< [4..4] Receive FIFO Message Lost Flag                                     */
            __IM uint8_t  RFFST : 1;   /*!< [5..5] Receive FIFO Full Status Flag                                      */
            __IM uint8_t  RFWST : 1;   /*!< [6..6] Receive FIFO Buffer Warning Status Flag                            */
            __IM uint8_t  RFEST : 1;   /*!< [7..7] Receive FIFO Empty Status Flag                                     */
        } RFCR_b;
    };

    union
    {
        __OM uint8_t RFPCR;            /*!< (@ 0x00000849) Receive FIFO Pointer Control Register                      */

        struct
        {
            __OM uint8_t RFPCR : 8;    /*!< [7..0] The CPU-side pointer for the receive FIFO is incremented
                                        *   by writing FFh to RFPCR.                                                  */
        } RFPCR_b;
    };

    union
    {
        __IOM uint8_t TFCR;            /*!< (@ 0x0000084A) Transmit FIFO Control Register                             */

        struct
        {
            __IOM uint8_t TFE   : 1;   /*!< [0..0] Transmit FIFO Enable                                               */
            __IM uint8_t  TFUST : 3;   /*!< [3..1] Transmit FIFO Unsent Message Number Status                         */
            uint8_t             : 2;
            __IM uint8_t TFFST  : 1;   /*!< [6..6] Transmit FIFO Full Status                                          */
            __IM uint8_t TFEST  : 1;   /*!< [7..7] Transmit FIFO Empty Status                                         */
        } TFCR_b;
    };

    union
    {
        __OM uint8_t TFPCR;            /*!< (@ 0x0000084B) Transmit FIFO Pointer Control Register                     */

        struct
        {
            __OM uint8_t TFPCR : 8;    /*!< [7..0] The CPU-side pointer for the transmit FIFO is incremented
                                        *   by writing FFh to TFPCR.                                                  */
        } TFPCR_b;
    };

    union
    {
        __IOM uint8_t EIER;            /*!< (@ 0x0000084C) Error Interrupt Enable Register                            */

        struct
        {
            __IOM uint8_t BEIE  : 1;   /*!< [0..0] Bus Error Interrupt Enable                                         */
            __IOM uint8_t EWIE  : 1;   /*!< [1..1] Error-Warning Interrupt Enable                                     */
            __IOM uint8_t EPIE  : 1;   /*!< [2..2] Error-Passive Interrupt Enable                                     */
            __IOM uint8_t BOEIE : 1;   /*!< [3..3] Bus-Off Entry Interrupt Enable                                     */
            __IOM uint8_t BORIE : 1;   /*!< [4..4] Bus-Off Recovery Interrupt Enable                                  */
            __IOM uint8_t ORIE  : 1;   /*!< [5..5] Overrun Interrupt Enable                                           */
            __IOM uint8_t OLIE  : 1;   /*!< [6..6] Overload Frame Transmit Interrupt Enable                           */
            __IOM uint8_t BLIE  : 1;   /*!< [7..7] Bus Lock Interrupt Enable                                          */
        } EIER_b;
    };

    union
    {
        __IOM uint8_t EIFR;            /*!< (@ 0x0000084D) Error Interrupt Factor Judge Register                      */

        struct
        {
            __IOM uint8_t BEIF  : 1;   /*!< [0..0] Bus Error Detect Flag                                              */
            __IOM uint8_t EWIF  : 1;   /*!< [1..1] Error-Warning Detect Flag                                          */
            __IOM uint8_t EPIF  : 1;   /*!< [2..2] Error-Passive Detect Flag                                          */
            __IOM uint8_t BOEIF : 1;   /*!< [3..3] Bus-Off Entry Detect Flag                                          */
            __IOM uint8_t BORIF : 1;   /*!< [4..4] Bus-Off Recovery Detect Flag                                       */
            __IOM uint8_t ORIF  : 1;   /*!< [5..5] Receive Overrun Detect Flag                                        */
            __IOM uint8_t OLIF  : 1;   /*!< [6..6] Overload Frame Transmission Detect Flag                            */
            __IOM uint8_t BLIF  : 1;   /*!< [7..7] Bus Lock Detect Flag                                               */
        } EIFR_b;
    };

    union
    {
        __IM uint8_t RECR;             /*!< (@ 0x0000084E) Receive Error Count Register                               */

        struct
        {
            __IM uint8_t RECR : 8;     /*!< [7..0] Receive error count functionRECR increments or decrements
                                        *   the counter value according to the error status of the
                                        *   CAN module during reception.                                              */
        } RECR_b;
    };

    union
    {
        __IM uint8_t TECR;             /*!< (@ 0x0000084F) Transmit Error Count Register                              */

        struct
        {
            __IM uint8_t TECR : 8;     /*!< [7..0] Transmit error count functionTECR increments or decrements
                                        *   the counter value according to the error status of the
                                        *   CAN module during transmission.                                           */
        } TECR_b;
    };

    union
    {
        __IOM uint8_t ECSR;            /*!< (@ 0x00000850) Error Code Store Register                                  */

        struct
        {
            __IOM uint8_t SEF  : 1;    /*!< [0..0] Stuff Error Flag                                                   */
            __IOM uint8_t FEF  : 1;    /*!< [1..1] Form Error Flag                                                    */
            __IOM uint8_t AEF  : 1;    /*!< [2..2] ACK Error Flag                                                     */
            __IOM uint8_t CEF  : 1;    /*!< [3..3] CRC Error Flag                                                     */
            __IOM uint8_t BE1F : 1;    /*!< [4..4] Bit Error (recessive) Flag                                         */
            __IOM uint8_t BE0F : 1;    /*!< [5..5] Bit Error (dominant) Flag                                          */
            __IOM uint8_t ADEF : 1;    /*!< [6..6] ACK Delimiter Error Flag                                           */
            __IOM uint8_t EDPM : 1;    /*!< [7..7] Error Display Mode Select                                          */
        } ECSR_b;
    };

    union
    {
        __IOM uint8_t CSSR;            /*!< (@ 0x00000851) Channel Search Support Register                            */

        struct
        {
            __IOM uint8_t CSSR : 8;    /*!< [7..0] When the value for the channel search is input, the channel
                                        *   number is output to MSSR.                                                 */
        } CSSR_b;
    };

    union
    {
        __IM uint8_t MSSR;             /*!< (@ 0x00000852) Mailbox Search Status Register                             */

        struct
        {
            __IM uint8_t MBNST : 5;    /*!< [4..0] Search Result Mailbox Number Status These bits output
                                        *   the smallest mailbox number that is searched in each mode
                                        *   of MSMR.                                                                  */
            uint8_t           : 2;
            __IM uint8_t SEST : 1;     /*!< [7..7] Search Result Status                                               */
        } MSSR_b;
    };

    union
    {
        __IOM uint8_t MSMR;            /*!< (@ 0x00000853) Mailbox Search Mode Register                               */

        struct
        {
            __IOM uint8_t MBSM : 2;    /*!< [1..0] Mailbox Search Mode Select                                         */
            uint8_t            : 6;
        } MSMR_b;
    };

    union
    {
        __IM uint16_t TSR;             /*!< (@ 0x00000854) Time Stamp Register                                        */

        struct
        {
            __IM uint16_t TSR : 16;    /*!< [15..0] Free-running counter value for the time stamp function            */
        } TSR_b;
    };

    union
    {
        __IOM uint16_t AFSR;           /*!< (@ 0x00000856) Acceptance Filter Support Register                         */

        struct
        {
            __IOM uint16_t AFSR : 16;  /*!< [15..0] After the standard ID of a received message is written,
                                        *   the value converted for data table search can be read.                    */
        } AFSR_b;
    };

    union
    {
        __IOM uint8_t TCR;             /*!< (@ 0x00000858) Test Control Register                                      */

        struct
        {
            __IOM uint8_t TSTE : 1;    /*!< [0..0] CAN Test Mode Enable                                               */
            __IOM uint8_t TSTM : 2;    /*!< [2..1] CAN Test Mode Select                                               */
            uint8_t            : 5;
        } TCR_b;
    };
    __IM uint8_t  RESERVED2;
    __IM uint16_t RESERVED3;
} R_CAN0_Type;                         /*!< Size = 2140 (0x85c)                                                       */

/* =========================================================================================================================== */
/* ================                                          R_CANFD                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Controller Area Network - Flexible Data (CAN-FD) Module (R_CANFD)
 */

typedef struct                         /*!< (@ 0x400B0000) R_CANFD Structure                                          */
{
    __IOM R_CANFD_CFDC_Type CFDC[2];   /*!< (@ 0x00000000) Channel Control/Status                                     */
    __IM uint32_t           RESERVED[25];

    union
    {
        __IOM uint32_t CFDGCFG;         /*!< (@ 0x00000084) Global Configuration Register                              */

        struct
        {
            __IOM uint32_t TPRI   : 1;  /*!< [0..0] Transmission Priority                                              */
            __IOM uint32_t DCE    : 1;  /*!< [1..1] DLC Check Enable                                                   */
            __IOM uint32_t DRE    : 1;  /*!< [2..2] DLC Replacement Enable                                             */
            __IOM uint32_t MME    : 1;  /*!< [3..3] Mirror Mode Enable                                                 */
            __IOM uint32_t DCS    : 1;  /*!< [4..4] Data Link Controller Clock Select                                  */
            __IOM uint32_t CMPOC  : 1;  /*!< [5..5] CAN-FD message Payload overflow configuration                      */
            uint32_t              : 2;
            __IOM uint32_t TSP    : 4;  /*!< [11..8] Timestamp Prescaler                                               */
            __IOM uint32_t TSSS   : 1;  /*!< [12..12] Timestamp Source Select                                          */
            __IOM uint32_t TSBTCS : 3;  /*!< [15..13] Timestamp Bit Time Channel Select                                */
            __IOM uint32_t ITRCP  : 16; /*!< [31..16] Interval Timer Reference Clock Prescaler                         */
        } CFDGCFG_b;
    };

    union
    {
        __IOM uint32_t CFDGCTR;         /*!< (@ 0x00000088) Global Control Register                                    */

        struct
        {
            __IOM uint32_t GMDC    : 2; /*!< [1..0] Global Mode Control                                                */
            __IOM uint32_t GSLPR   : 1; /*!< [2..2] Global Sleep Request                                               */
            uint32_t               : 5;
            __IOM uint32_t DEIE    : 1; /*!< [8..8] DLC check Interrupt Enable                                         */
            __IOM uint32_t MEIE    : 1; /*!< [9..9] Message lost Error Interrupt Enable                                */
            __IOM uint32_t THLEIE  : 1; /*!< [10..10] TX History List Entry Lost Interrupt Enable                      */
            __IOM uint32_t CMPOFIE : 1; /*!< [11..11] CAN-FD message payload overflow Flag Interrupt enable            */
            uint32_t               : 2;
            __IOM uint32_t QMEIE   : 1; /*!< [14..14] TXQ Message lost Error Interrupt Enable                          */
            __IOM uint32_t MOWEIE  : 1; /*!< [15..15] GW FIFO Message overwrite Error Interrupt Enable                 */
            __IOM uint32_t TSRST   : 1; /*!< [16..16] Timestamp Reset                                                  */
            __IOM uint32_t TSWR    : 1; /*!< [17..17] Timestamp Write                                                  */
            uint32_t               : 14;
        } CFDGCTR_b;
    };

    union
    {
        __IOM uint32_t CFDGSTS;         /*!< (@ 0x0000008C) Global Status Register                                     */

        struct
        {
            __IM uint32_t GRSTSTS  : 1; /*!< [0..0] Global Reset Status                                                */
            __IM uint32_t GHLTSTS  : 1; /*!< [1..1] Global Halt Status                                                 */
            __IM uint32_t GSLPSTS  : 1; /*!< [2..2] Global Sleep Status                                                */
            __IM uint32_t GRAMINIT : 1; /*!< [3..3] Global RAM Initialisation                                          */
            uint32_t               : 28;
        } CFDGSTS_b;
    };

    union
    {
        __IOM uint32_t CFDGERFL;          /*!< (@ 0x00000090) Global Error Flag Register                                 */

        struct
        {
            __IOM uint32_t DEF       : 1; /*!< [0..0] DLC Error Flag                                                     */
            __IM uint32_t  MES       : 1; /*!< [1..1] Message Lost Error Status                                          */
            __IM uint32_t  THLES     : 1; /*!< [2..2] TX History List Entry Lost Error Status                            */
            __IOM uint32_t CMPOF     : 1; /*!< [3..3] CAN-FD message payload overflow Flag                               */
            __IM uint32_t  QOWES     : 1; /*!< [4..4] TXQ Message overwrite Error Status                                 */
            __IM uint32_t  OTBMLTSTS : 1; /*!< [5..5] OTB FIFO Message Lost Status                                       */
            __IM uint32_t  QMES      : 1; /*!< [6..6] TXQ Message Lost Error Status                                      */
            uint32_t                 : 1;
            __IOM uint32_t RXSFAIL0  : 1; /*!< [8..8] RX Scan Fail of Channel 0                                          */
            __IOM uint32_t RXSFAIL1  : 1; /*!< [9..9] RX Scan Fail of Channel 1                                          */
            uint32_t                 : 6;
            __IOM uint32_t EEF0      : 1; /*!< [16..16] ECC Error Flag for Channel 0                                     */
            __IOM uint32_t EEF1      : 1; /*!< [17..17] ECC Error Flag for Channel 1                                     */
            uint32_t                 : 14;
        } CFDGERFL_b;
    };

    union
    {
        __IOM uint32_t CFDGTSC;        /*!< (@ 0x00000094) Global Timestamp Counter Register                          */

        struct
        {
            __IM uint32_t TS : 16;     /*!< [15..0] Timestamp Value                                                   */
            uint32_t         : 16;
        } CFDGTSC_b;
    };

    union
    {
        __IOM uint32_t CFDGAFLECTR;    /*!< (@ 0x00000098) Global Acceptance Filter List Entry Control Register       */

        struct
        {
            __IOM uint32_t AFLPN  : 4; /*!< [3..0] Acceptance Filter List Page Number                                 */
            uint32_t              : 4;
            __IOM uint32_t AFLDAE : 1; /*!< [8..8] Acceptance Filter List Data Access Enable                          */
            uint32_t              : 23;
        } CFDGAFLECTR_b;
    };

    union
    {
        __IOM uint32_t CFDGAFLCFG0;    /*!< (@ 0x0000009C) Global Acceptance Filter List Configuration Register
                                        *                  0                                                          */

        struct
        {
            __IOM uint32_t RNC1 : 9;   /*!< [8..0] Rule Number for Channel 1                                          */
            uint32_t            : 7;
            __IOM uint32_t RNC0 : 9;   /*!< [24..16] Rule Number for Channel 0                                        */
            uint32_t            : 7;
        } CFDGAFLCFG0_b;
    };
    __IM uint32_t RESERVED1[3];

    union
    {
        __IOM uint32_t CFDRMNB;        /*!< (@ 0x000000AC) RX Message Buffer Number Register                          */

        struct
        {
            __IOM uint32_t NRXMB : 8;  /*!< [7..0] Number of RX Message Buffers                                       */
            __IOM uint32_t RMPLS : 3;  /*!< [10..8] Reception Message Buffer Payload Data Size                        */
            uint32_t             : 21;
        } CFDRMNB_b;
    };

    union
    {
        __IOM uint32_t CFDRMND0;       /*!< (@ 0x000000B0) RX Message Buffer New Data Register 0                      */

        struct
        {
            __IOM uint32_t RMNSu : 32; /*!< [31..0] RX Message Buffer New Data Status                                 */
        } CFDRMND0_b;
    };
    __IM uint32_t RESERVED2[3];

    union
    {
        __IOM uint32_t CFDRFCC[8];     /*!< (@ 0x000000C0) RX FIFO Configuration / Control Registers                  */

        struct
        {
            __IOM uint32_t RFE    : 1; /*!< [0..0] RX FIFO Enable                                                     */
            __IOM uint32_t RFIE   : 1; /*!< [1..1] RX FIFO Interrupt Enable                                           */
            uint32_t              : 2;
            __IOM uint32_t RFPLS  : 3; /*!< [6..4] Rx FIFO Payload Data Size configuration                            */
            uint32_t              : 1;
            __IOM uint32_t RFDC   : 3; /*!< [10..8] RX FIFO Depth Configuration                                       */
            uint32_t              : 1;
            __IOM uint32_t RFIM   : 1; /*!< [12..12] RX FIFO Interrupt Mode                                           */
            __IOM uint32_t RFIGCV : 3; /*!< [15..13] RX FIFO Interrupt Generation Counter Value                       */
            __IOM uint32_t RFFIE  : 1; /*!< [16..16] RX FIFO Full interrupt Enable                                    */
            uint32_t              : 15;
        } CFDRFCC_b[8];
    };

    union
    {
        __IOM uint32_t CFDRFSTS[8];    /*!< (@ 0x000000E0) RX FIFO Status Registers                                   */

        struct
        {
            __IM uint32_t  RFEMP : 1;  /*!< [0..0] RX FIFO Empty                                                      */
            __IM uint32_t  RFFLL : 1;  /*!< [1..1] RX FIFO Full                                                       */
            __IOM uint32_t RFMLT : 1;  /*!< [2..2] RX FIFO Message Lost                                               */
            __IOM uint32_t RFIF  : 1;  /*!< [3..3] RX FIFO Interrupt Flag                                             */
            uint32_t             : 4;
            __IM uint32_t  RFMC  : 8;  /*!< [15..8] RX FIFO Message Count                                             */
            __IOM uint32_t RFFIF : 1;  /*!< [16..16] RX FIFO Full Interrupt Flag                                      */
            uint32_t             : 15;
        } CFDRFSTS_b[8];
    };

    union
    {
        __IOM uint32_t CFDRFPCTR[8];   /*!< (@ 0x00000100) RX FIFO Pointer Control Registers                          */

        struct
        {
            __OM uint32_t RFPC : 8;    /*!< [7..0] RX FIFO Pointer Control                                            */
            uint32_t           : 24;
        } CFDRFPCTR_b[8];
    };

    union
    {
        __IOM uint32_t CFDCFCC[6];     /*!< (@ 0x00000120) Common FIFO Configuration / Control Registers              */

        struct
        {
            __IOM uint32_t CFE    : 1; /*!< [0..0] Common FIFO Enable                                                 */
            __IOM uint32_t CFRXIE : 1; /*!< [1..1] Common FIFO RX Interrupt Enable                                    */
            __IOM uint32_t CFTXIE : 1; /*!< [2..2] Common FIFO TX Interrupt Enable                                    */
            uint32_t              : 1;
            __IOM uint32_t CFPLS  : 3; /*!< [6..4] Common FIFO Payload Data size configuration                        */
            uint32_t              : 1;
            __IOM uint32_t CFM    : 2; /*!< [9..8] Common FIFO Mode                                                   */
            __IOM uint32_t CFITSS : 1; /*!< [10..10] Common FIFO Interval Timer Source Select                         */
            __IOM uint32_t CFITR  : 1; /*!< [11..11] Common FIFO Interval Timer Resolution                            */
            __IOM uint32_t CFIM   : 1; /*!< [12..12] Common FIFO Interrupt Mode                                       */
            __IOM uint32_t CFIGCV : 3; /*!< [15..13] Common FIFO Interrupt Generation Counter Value                   */
            __IOM uint32_t CFTML  : 5; /*!< [20..16] Common FIFO TX Message Buffer Link                               */
            __IOM uint32_t CFDC   : 3; /*!< [23..21] Common FIFO Depth Configuration                                  */
            __IOM uint32_t CFITT  : 8; /*!< [31..24] Common FIFO Interval Transmission Time                           */
        } CFDCFCC_b[6];
    };
    __IM uint32_t RESERVED3[18];

    union
    {
        __IOM uint32_t CFDCFCCE[6];      /*!< (@ 0x00000180) Common FIFO Configuration / Control Enhancement
                                          *                  Registers                                                  */

        struct
        {
            __IOM uint32_t CFFIE    : 1; /*!< [0..0] Common FIFO Full interrupt Enable                                  */
            __IOM uint32_t CFOFRXIE : 1; /*!< [1..1] Common FIFO One Frame Reception Interrupt Enable                   */
            __IOM uint32_t CFOFTXIE : 1; /*!< [2..2] Common FIFO One Frame Transmission Interrupt Enable                */
            uint32_t                : 5;
            __IOM uint32_t CFMOWM   : 1; /*!< [8..8] Common FIFO message overwrite mode                                 */
            uint32_t                : 7;
            __IOM uint32_t CFBME    : 1; /*!< [16..16] Common FIFO Buffering Mode Enable                                */
            uint32_t                : 15;
        } CFDCFCCE_b[6];
    };
    __IM uint32_t RESERVED4[18];

    union
    {
        __IOM uint32_t CFDCFSTS[6];      /*!< (@ 0x000001E0) Common FIFO Status Registers                               */

        struct
        {
            __IM uint32_t  CFEMP    : 1; /*!< [0..0] Common FIFO Empty                                                  */
            __IM uint32_t  CFFLL    : 1; /*!< [1..1] Common FIFO Full                                                   */
            __IOM uint32_t CFMLT    : 1; /*!< [2..2] Common FIFO Message Lost                                           */
            __IOM uint32_t CFRXIF   : 1; /*!< [3..3] Common RX FIFO Interrupt Flag                                      */
            __IOM uint32_t CFTXIF   : 1; /*!< [4..4] Common TX FIFO Interrupt Flag                                      */
            uint32_t                : 3;
            __IM uint32_t  CFMC     : 8; /*!< [15..8] Common FIFO Message Count                                         */
            __IOM uint32_t CFFIF    : 1; /*!< [16..16] Common FIFO Full Interrupt Flag                                  */
            __IOM uint32_t CFOFRXIF : 1; /*!< [17..17] Common FIFO One Frame Reception Interrupt Flag                   */
            __IOM uint32_t CFOFTXIF : 1; /*!< [18..18] Common FIFO One Frame Transmission Interrupt Flag                */
            uint32_t                : 5;
            __IOM uint32_t CFMOW    : 1; /*!< [24..24] Common FIFO message overwrite                                    */
            uint32_t                : 7;
        } CFDCFSTS_b[6];
    };
    __IM uint32_t RESERVED5[18];

    union
    {
        __IOM uint32_t CFDCFPCTR[6];   /*!< (@ 0x00000240) Common FIFO Pointer Control Registers                      */

        struct
        {
            __OM uint32_t CFPC : 8;    /*!< [7..0] Common FIFO Pointer Control                                        */
            uint32_t           : 24;
        } CFDCFPCTR_b[6];
    };
    __IM uint32_t RESERVED6[18];

    union
    {
        __IM uint32_t CFDFESTS;        /*!< (@ 0x000002A0) FIFO Empty Status Register                                 */

        struct
        {
            __IM uint32_t RFXEMP : 8;  /*!< [7..0] RX FIF0 Empty Status                                               */
            __IM uint32_t CFXEMP : 6;  /*!< [13..8] Common FIF0 Empty Status                                          */
            uint32_t             : 18;
        } CFDFESTS_b;
    };

    union
    {
        __IM uint32_t CFDFFSTS;        /*!< (@ 0x000002A4) FIFO Full Status Register                                  */

        struct
        {
            __IM uint32_t RFXFLL : 8;  /*!< [7..0] RX FIF0 Full Status                                                */
            __IM uint32_t CFXFLL : 6;  /*!< [13..8] Common FIF0 Full Status                                           */
            uint32_t             : 18;
        } CFDFFSTS_b;
    };

    union
    {
        __IM uint32_t CFDFMSTS;        /*!< (@ 0x000002A8) FIFO Message Lost Status Register                          */

        struct
        {
            __IM uint32_t RFXMLT : 8;  /*!< [7..0] RX FIFO Msg Lost Status                                            */
            __IM uint32_t CFXMLT : 6;  /*!< [13..8] Common FIFO Msg Lost Status                                       */
            uint32_t             : 18;
        } CFDFMSTS_b;
    };

    union
    {
        __IOM uint32_t CFDRFISTS;      /*!< (@ 0x000002AC) RX FIFO Interrupt Flag Status Register                     */

        struct
        {
            __IM uint32_t RFXIF   : 8; /*!< [7..0] RX FIFO[x] Interrupt Flag Status                                   */
            uint32_t              : 8;
            __IM uint32_t RFXFFLL : 8; /*!< [23..16] RX FIFO[x] Interrupt Full Flag Status                            */
            uint32_t              : 8;
        } CFDRFISTS_b;
    };

    union
    {
        __IOM uint32_t CFDCFRISTS;     /*!< (@ 0x000002B0) Common FIFO RX Interrupt Flag Status Register              */

        struct
        {
            __IM uint32_t CFXRXIF : 6; /*!< [5..0] Common FIFO [x] RX Interrupt Flag Status                           */
            uint32_t              : 26;
        } CFDCFRISTS_b;
    };

    union
    {
        __IOM uint32_t CFDCFTISTS;     /*!< (@ 0x000002B4) Common FIFO TX Interrupt Flag Status Register              */

        struct
        {
            __IM uint32_t CFXTXIF : 6; /*!< [5..0] Common FIFO [x] TX Interrupt Flag Status                           */
            uint32_t              : 26;
        } CFDCFTISTS_b;
    };

    union
    {
        __IM uint32_t CFDCFOFRISTS;      /*!< (@ 0x000002B8) Common FIFO One Frame RX Interrupt Flag Status
                                          *                  Register                                                   */

        struct
        {
            __IM uint32_t CFXOFRXIF : 6; /*!< [5..0] Common FIFO [x] One Frame RX Interrupt Flag Status                 */
            uint32_t                : 26;
        } CFDCFOFRISTS_b;
    };

    union
    {
        __IM uint32_t CFDCFOFTISTS;      /*!< (@ 0x000002BC) Common FIFO One Frame TX Interrupt Flag Status
                                          *                  Register                                                   */

        struct
        {
            __IM uint32_t CFXOFTXIF : 6; /*!< [5..0] Common FIFO [x] One Frame TX Interrupt Flag Status                 */
            uint32_t                : 26;
        } CFDCFOFTISTS_b;
    };

    union
    {
        __IM uint32_t CFDCFMOWSTS;     /*!< (@ 0x000002C0) Common FIFO Message Over Write Status Register             */

        struct
        {
            __IM uint32_t CFXMOW : 6;  /*!< [5..0] Common FIFO [x] Massage overwrite status                           */
            uint32_t             : 26;
        } CFDCFMOWSTS_b;
    };

    union
    {
        __IM uint32_t CFDFFFSTS;       /*!< (@ 0x000002C4) FIFO FDC Full Status Register                              */

        struct
        {
            __IM uint32_t RFXFFLL : 8; /*!< [7..0] RX FIFO FDC level full Status                                      */
            __IM uint32_t CFXFFLL : 6; /*!< [13..8] COMMON FIFO FDC level full Status                                 */
            uint32_t              : 18;
        } CFDFFFSTS_b;
    };
    __IM uint32_t RESERVED7[2];

    union
    {
        __IOM uint8_t CFDTMC[128];     /*!< (@ 0x000002D0) TX Message Buffer Control Registers                        */

        struct
        {
            __IOM uint8_t TMTR  : 1;   /*!< [0..0] TX Message Buffer Transmission Request                             */
            __IOM uint8_t TMTAR : 1;   /*!< [1..1] TX Message Buffer Transmission abort Request                       */
            __IOM uint8_t TMOM  : 1;   /*!< [2..2] TX Message Buffer One-shot Mode                                    */
            uint8_t             : 5;
        } CFDTMC_b[128];
    };
    __IM uint32_t RESERVED8[288];

    union
    {
        __IOM uint8_t CFDTMSTS[128];   /*!< (@ 0x000007D0) TX Message Buffer Status Registers                         */

        struct
        {
            __IM uint8_t  TMTSTS : 1;  /*!< [0..0] TX Message Buffer Transmission Status                              */
            __IOM uint8_t TMTRF  : 2;  /*!< [2..1] TX Message Buffer Transmission Result Flag                         */
            __IM uint8_t  TMTRM  : 1;  /*!< [3..3] TX Message Buffer Transmission Request Mirrored                    */
            __IM uint8_t  TMTARM : 1;  /*!< [4..4] TX Message Buffer Transmission abort Request Mirrored              */
            uint8_t              : 3;
        } CFDTMSTS_b[128];
    };
    __IM uint32_t RESERVED9[288];

    union
    {
        __IM uint32_t CFDTMTRSTS[4];       /*!< (@ 0x00000CD0) TX Message Buffer Transmission Request Status
                                            *                  Register                                                   */

        struct
        {
            __IM uint32_t CFDTMTRSTSg : 8; /*!< [7..0] TX Message Buffer Transmission Request Status                      */
            uint32_t                  : 24;
        } CFDTMTRSTS_b[4];
    };
    __IM uint32_t RESERVED10[36];

    union
    {
        __IM uint32_t CFDTMTARSTS[4];       /*!< (@ 0x00000D70) TX Message Buffer Transmission Abort Request
                                             *                  Status Register                                            */

        struct
        {
            __IM uint32_t CFDTMTARSTSg : 8; /*!< [7..0] TX Message Buffer Transmission abort Request Status                */
            uint32_t                   : 24;
        } CFDTMTARSTS_b[4];
    };
    __IM uint32_t RESERVED11[36];

    union
    {
        __IM uint32_t CFDTMTCSTS[4];       /*!< (@ 0x00000E10) TX Message Buffer Transmission Completion Status
                                            *                  Register                                                   */

        struct
        {
            __IM uint32_t CFDTMTCSTSg : 8; /*!< [7..0] TX Message Buffer Transmission Completion Status                   */
            uint32_t                  : 24;
        } CFDTMTCSTS_b[4];
    };
    __IM uint32_t RESERVED12[36];

    union
    {
        __IM uint32_t CFDTMTASTS[4];       /*!< (@ 0x00000EB0) TX Message Buffer Transmission Abort Status Register       */

        struct
        {
            __IM uint32_t CFDTMTASTSg : 8; /*!< [7..0] TX Message Buffer Transmission abort Status                        */
            uint32_t                  : 24;
        } CFDTMTASTS_b[4];
    };
    __IM uint32_t RESERVED13[36];

    union
    {
        __IOM uint32_t CFDTMIEC[4];    /*!< (@ 0x00000F50) TX Message Buffer Interrupt Enable Configuration
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t TMIEg : 8;  /*!< [7..0] TX Message Buffer Interrupt Enable                                 */
            uint32_t             : 24;
        } CFDTMIEC_b[4];
    };
    __IM uint32_t RESERVED14[40];

    union
    {
        __IOM uint32_t CFDTXQCC0[2];      /*!< (@ 0x00001000) TX Queue Configuration / Control Registers 0               */

        struct
        {
            __IOM uint32_t TXQE      : 1; /*!< [0..0] TX Queue Enable                                                    */
            __IOM uint32_t TXQGWE    : 1; /*!< [1..1] TX Queue Gateway Mode Enable                                       */
            uint32_t                 : 3;
            __IOM uint32_t TXQTXIE   : 1; /*!< [5..5] TX Queue TX Interrupt Enable                                       */
            uint32_t                 : 1;
            __IOM uint32_t TXQIM     : 1; /*!< [7..7] TX Queue Interrupt Mode                                            */
            __IOM uint32_t TXQDC     : 5; /*!< [12..8] TX Queue Depth Configuration                                      */
            uint32_t                 : 3;
            __IOM uint32_t TXQFIE    : 1; /*!< [16..16] TXQ Full interrupt Enable                                        */
            __IOM uint32_t TXQOFRXIE : 1; /*!< [17..17] TXQ One Frame Reception Interrupt Enable                         */
            __IOM uint32_t TXQOFTXIE : 1; /*!< [18..18] TXQ One Frame Transmission Interrupt Enable                      */
            uint32_t                 : 13;
        } CFDTXQCC0_b[2];
    };
    __IM uint32_t RESERVED15[6];

    union
    {
        __IOM uint32_t CFDTXQSTS0[2];     /*!< (@ 0x00001020) TX Queue Status Registers 0                                */

        struct
        {
            __IM uint32_t  TXQEMP    : 1; /*!< [0..0] TX Queue Empty                                                     */
            __IM uint32_t  TXQFLL    : 1; /*!< [1..1] TX Queue Full                                                      */
            __IOM uint32_t TXQTXIF   : 1; /*!< [2..2] TX Queue TX Interrupt Flag                                         */
            uint32_t                 : 5;
            __IM uint32_t TXQMC      : 6; /*!< [13..8] TX Queue Message Count                                            */
            uint32_t                 : 2;
            __IOM uint32_t TXQFIF    : 1; /*!< [16..16] TXQ Full Interrupt Flag                                          */
            __IOM uint32_t TXQOFRXIF : 1; /*!< [17..17] TXQ One Frame Reception Interrupt Flag                           */
            __IOM uint32_t TXQOFTXIF : 1; /*!< [18..18] TXQ One Frame Transmission Interrupt Flag                        */
            __IOM uint32_t TXQMLT    : 1; /*!< [19..19] TXQ Message Lost                                                 */
            uint32_t                 : 12;
        } CFDTXQSTS0_b[2];
    };
    __IM uint32_t RESERVED16[6];

    union
    {
        __IOM uint32_t CFDTXQPCTR0[2]; /*!< (@ 0x00001040) TX Queue Pointer Control Registers 0                       */

        struct
        {
            __OM uint32_t TXQPC : 8;   /*!< [7..0] TX Queue Pointer Control                                           */
            uint32_t            : 24;
        } CFDTXQPCTR0_b[2];
    };
    __IM uint32_t RESERVED17[6];

    union
    {
        __IOM uint32_t CFDTXQCC1[2];      /*!< (@ 0x00001060) TX Queue Configuration / Control Registers 1               */

        struct
        {
            __IOM uint32_t TXQE      : 1; /*!< [0..0] TX Queue Enable                                                    */
            __IOM uint32_t TXQGWE    : 1; /*!< [1..1] TX Queue Gateway Mode Enable                                       */
            uint32_t                 : 3;
            __IOM uint32_t TXQTXIE   : 1; /*!< [5..5] TX Queue TX Interrupt Enable                                       */
            uint32_t                 : 1;
            __IOM uint32_t TXQIM     : 1; /*!< [7..7] TX Queue Interrupt Mode                                            */
            __IOM uint32_t TXQDC     : 5; /*!< [12..8] TX Queue Depth Configuration                                      */
            uint32_t                 : 3;
            __IOM uint32_t TXQFIE    : 1; /*!< [16..16] TXQ Full Interrupt Enable                                        */
            __IOM uint32_t TXQOFRXIE : 1; /*!< [17..17] TXQ One Frame Reception Interrupt Enable                         */
            __IOM uint32_t TXQOFTXIE : 1; /*!< [18..18] TXQ One Frame Transmission Interrupt Enable                      */
            uint32_t                 : 13;
        } CFDTXQCC1_b[2];
    };
    __IM uint32_t RESERVED18[6];

    union
    {
        __IOM uint32_t CFDTXQSTS1[2];     /*!< (@ 0x00001080) TX Queue Status Registers 1                                */

        struct
        {
            __IM uint32_t  TXQEMP    : 1; /*!< [0..0] TX Queue Empty                                                     */
            __IM uint32_t  TXQFLL    : 1; /*!< [1..1] TX Queue Full                                                      */
            __IOM uint32_t TXQTXIF   : 1; /*!< [2..2] TX Queue TX Interrupt Flag                                         */
            uint32_t                 : 5;
            __IM uint32_t TXQMC      : 6; /*!< [13..8] TX Queue Message Count                                            */
            uint32_t                 : 2;
            __IOM uint32_t TXQFIF    : 1; /*!< [16..16] TXQ Full Interrupt Flag                                          */
            __IOM uint32_t TXQOFRXIF : 1; /*!< [17..17] TXQ One Frame Reception Interrupt Flag                           */
            __IOM uint32_t TXQOFTXIF : 1; /*!< [18..18] TXQ One Frame Transmission Interrupt Flag                        */
            __IOM uint32_t TXQMLT    : 1; /*!< [19..19] TXQ Message Lost                                                 */
            uint32_t                 : 12;
        } CFDTXQSTS1_b[2];
    };
    __IM uint32_t RESERVED19[6];

    union
    {
        __IOM uint32_t CFDTXQPCTR1[2]; /*!< (@ 0x000010A0) TX Queue Pointer Control Registers 1                       */

        struct
        {
            __OM uint32_t TXQPC : 8;   /*!< [7..0] TX Queue Pointer Control                                           */
            uint32_t            : 24;
        } CFDTXQPCTR1_b[2];
    };
    __IM uint32_t RESERVED20[6];

    union
    {
        __IOM uint32_t CFDTXQCC2[2];      /*!< (@ 0x000010C0) TX Queue Configuration / Control Registers 2               */

        struct
        {
            __IOM uint32_t TXQE      : 1; /*!< [0..0] TX Queue Enable                                                    */
            __IOM uint32_t TXQGWE    : 1; /*!< [1..1] TX Queue Gateway Mode Enable                                       */
            uint32_t                 : 3;
            __IOM uint32_t TXQTXIE   : 1; /*!< [5..5] TX Queue TX Interrupt Enable                                       */
            uint32_t                 : 1;
            __IOM uint32_t TXQIM     : 1; /*!< [7..7] TX Queue Interrupt Mode                                            */
            __IOM uint32_t TXQDC     : 5; /*!< [12..8] TX Queue Depth Configuration                                      */
            uint32_t                 : 3;
            __IOM uint32_t TXQFIE    : 1; /*!< [16..16] TXQ Full interrupt Enable                                        */
            __IOM uint32_t TXQOFRXIE : 1; /*!< [17..17] TXQ One Frame Reception Interrupt Enable                         */
            __IOM uint32_t TXQOFTXIE : 1; /*!< [18..18] TXQ One Frame Transmission Interrupt Enable                      */
            uint32_t                 : 13;
        } CFDTXQCC2_b[2];
    };
    __IM uint32_t RESERVED21[6];

    union
    {
        __IOM uint32_t CFDTXQSTS2[2];     /*!< (@ 0x000010E0) TX Queue Status Registers 2                                */

        struct
        {
            __IM uint32_t  TXQEMP    : 1; /*!< [0..0] TX Queue Empty                                                     */
            __IM uint32_t  TXQFLL    : 1; /*!< [1..1] TX Queue Full                                                      */
            __IOM uint32_t TXQTXIF   : 1; /*!< [2..2] TX Queue TX Interrupt Flag                                         */
            uint32_t                 : 5;
            __IM uint32_t TXQMC      : 6; /*!< [13..8] TX Queue Message Count                                            */
            uint32_t                 : 2;
            __IOM uint32_t TXQFIF    : 1; /*!< [16..16] TXQ Full Interrupt Flag                                          */
            __IOM uint32_t TXQOFRXIF : 1; /*!< [17..17] TXQ One Frame Reception Interrupt Flag                           */
            __IOM uint32_t TXQOFTXIF : 1; /*!< [18..18] TXQ One Frame Transmission Interrupt Flag                        */
            __IOM uint32_t TXQMLT    : 1; /*!< [19..19] TXQ Message Lost                                                 */
            uint32_t                 : 12;
        } CFDTXQSTS2_b[2];
    };
    __IM uint32_t RESERVED22[6];

    union
    {
        __IOM uint32_t CFDTXQPCTR2[2]; /*!< (@ 0x00001100) TX Queue Pointer Control Registers 2                       */

        struct
        {
            __OM uint32_t TXQPC : 8;   /*!< [7..0] TX Queue Pointer Control                                           */
            uint32_t            : 24;
        } CFDTXQPCTR2_b[2];
    };
    __IM uint32_t RESERVED23[6];

    union
    {
        __IOM uint32_t CFDTXQCC3[2];      /*!< (@ 0x00001120) TX Queue Configuration / Control Registers 3               */

        struct
        {
            __IOM uint32_t TXQE      : 1; /*!< [0..0] TX Queue Enable                                                    */
            uint32_t                 : 4;
            __IOM uint32_t TXQTXIE   : 1; /*!< [5..5] TX Queue TX Interrupt Enable                                       */
            uint32_t                 : 1;
            __IOM uint32_t TXQIM     : 1; /*!< [7..7] TX Queue Interrupt Mode                                            */
            __IOM uint32_t TXQDC     : 5; /*!< [12..8] TX Queue Depth Configuration                                      */
            uint32_t                 : 5;
            __IOM uint32_t TXQOFTXIE : 1; /*!< [18..18] TXQ One Frame Transmission Interrupt Enable                      */
            uint32_t                 : 13;
        } CFDTXQCC3_b[2];
    };
    __IM uint32_t RESERVED24[6];

    union
    {
        __IOM uint32_t CFDTXQSTS3[2];     /*!< (@ 0x00001140) TX Queue Status Registers 3                                */

        struct
        {
            __IM uint32_t  TXQEMP    : 1; /*!< [0..0] TX Queue Empty                                                     */
            __IM uint32_t  TXQFLL    : 1; /*!< [1..1] TX Queue Full                                                      */
            __IOM uint32_t TXQTXIF   : 1; /*!< [2..2] TX Queue TX Interrupt Flag                                         */
            uint32_t                 : 5;
            __IM uint32_t TXQMC      : 6; /*!< [13..8] TX Queue Message Count                                            */
            uint32_t                 : 4;
            __IOM uint32_t TXQOFTXIF : 1; /*!< [18..18] TXQ One Frame Transmission Interrupt Flag                        */
            uint32_t                 : 13;
        } CFDTXQSTS3_b[2];
    };
    __IM uint32_t RESERVED25[6];

    union
    {
        __IOM uint32_t CFDTXQPCTR3[2]; /*!< (@ 0x00001160) TX Queue Pointer Control Registers 3                       */

        struct
        {
            __OM uint32_t TXQPC : 8;   /*!< [7..0] TX Queue Pointer Control                                           */
            uint32_t            : 24;
        } CFDTXQPCTR3_b[2];
    };
    __IM uint32_t RESERVED26[6];

    union
    {
        __IM uint32_t CFDTXQESTS;      /*!< (@ 0x00001180) TX Queue Empty Status Register                             */

        struct
        {
            __IM uint32_t TXQxEMP : 8; /*!< [7..0] TXQ empty Status                                                   */
            uint32_t              : 24;
        } CFDTXQESTS_b;
    };

    union
    {
        __IOM uint32_t CFDTXQFISTS;     /*!< (@ 0x00001184) TX Queue Full Interrupt Status Register                    */

        struct
        {
            __IM uint32_t TXQ0FULL : 3; /*!< [2..0] TXQ Full Interrupt Status for channel 0                            */
            uint32_t               : 1;
            __IM uint32_t TXQ1FULL : 3; /*!< [6..4] TXQ Full Interrupt Status for channel 1                            */
            uint32_t               : 25;
        } CFDTXQFISTS_b;
    };

    union
    {
        __IOM uint32_t CFDTXQMSTS;     /*!< (@ 0x00001188) TX Queue Message Lost Status Register                      */

        struct
        {
            __IM uint32_t TXQ0ML : 3;  /*!< [2..0] TXQ message lost Status for channel 0                              */
            uint32_t             : 1;
            __IM uint32_t TXQ1ML : 3;  /*!< [6..4] TXQ message lost Status for channel 1                              */
            uint32_t             : 25;
        } CFDTXQMSTS_b;
    };
    __IM uint32_t RESERVED27;

    union
    {
        __IOM uint32_t CFDTXQISTS;     /*!< (@ 0x00001190) TX Queue Interrupt Status Register                         */

        struct
        {
            __IM uint32_t TXQ0ISF : 4; /*!< [3..0] TXQ Interrupt Status Flag for channel 0                            */
            __IM uint32_t TXQ1ISF : 4; /*!< [7..4] TXQ Interrupt Status Flag for channel 1                            */
            uint32_t              : 24;
        } CFDTXQISTS_b;
    };

    union
    {
        __IOM uint32_t CFDTXQOFTISTS;     /*!< (@ 0x00001194) TX Queue One Frame TX Interrupt Status Register            */

        struct
        {
            __IM uint32_t TXQ0OFTISF : 4; /*!< [3..0] TXQ One Frame TX Interrupt Status Flag for channel 0               */
            __IM uint32_t TXQ1OFTISF : 4; /*!< [7..4] TXQ One Frame TX Interrupt Status Flag for channel 1               */
            uint32_t                 : 24;
        } CFDTXQOFTISTS_b;
    };

    union
    {
        __IOM uint32_t CFDTXQOFRISTS;     /*!< (@ 0x00001198) TX Queue One Frame RX Interrupt Status Register            */

        struct
        {
            __IM uint32_t TXQ0OFRISF : 3; /*!< [2..0] TXQ One Frame RX Interrupt Status Flag                             */
            uint32_t                 : 1;
            __IM uint32_t TXQ1OFRISF : 3; /*!< [6..4] TXQ One Frame RX Interrupt Status Flag                             */
            uint32_t                 : 25;
        } CFDTXQOFRISTS_b;
    };

    union
    {
        __IM uint32_t CFDTXQFSTS;      /*!< (@ 0x0000119C) TX Queue Full Status Register                              */

        struct
        {
            __IM uint32_t TXQ0FSF : 4; /*!< [3..0] TXQ Full Status Flag for channel 0                                 */
            __IM uint32_t TXQ1FSF : 4; /*!< [7..4] TXQ Full Status Flag for channel 1                                 */
            uint32_t              : 24;
        } CFDTXQFSTS_b;
    };
    __IM uint32_t RESERVED28[24];

    union
    {
        __IOM uint32_t CFDTHLCC[2];    /*!< (@ 0x00001200) TX History List Configuration / Control Register           */

        struct
        {
            __IOM uint32_t THLE   : 1; /*!< [0..0] TX History List Enable                                             */
            uint32_t              : 7;
            __IOM uint32_t THLIE  : 1; /*!< [8..8] TX History List Interrupt Enable                                   */
            __IOM uint32_t THLIM  : 1; /*!< [9..9] TX History List Interrupt Mode                                     */
            __IOM uint32_t THLDTE : 1; /*!< [10..10] TX History List Dedicated TX Enable                              */
            __IOM uint32_t THLDGE : 1; /*!< [11..11] TX History List Dedicated GW Enable                              */
            uint32_t              : 20;
        } CFDTHLCC_b[2];
    };
    __IM uint32_t RESERVED29[6];

    union
    {
        __IOM uint32_t CFDTHLSTS[2];   /*!< (@ 0x00001220) TX History List Status Register                            */

        struct
        {
            __IM uint32_t  THLEMP : 1; /*!< [0..0] TX History List Empty                                              */
            __IM uint32_t  THLFLL : 1; /*!< [1..1] TX History List Full                                               */
            __IOM uint32_t THLELT : 1; /*!< [2..2] TX History List Entry Lost                                         */
            __IOM uint32_t THLIF  : 1; /*!< [3..3] TX History List Interrupt Flag                                     */
            uint32_t              : 4;
            __IM uint32_t THLMC   : 6; /*!< [13..8] TX History List Message Count                                     */
            uint32_t              : 18;
        } CFDTHLSTS_b[2];
    };
    __IM uint32_t RESERVED30[6];

    union
    {
        __IOM uint32_t CFDTHLPCTR[2];  /*!< (@ 0x00001240) TX History List Pointer Control Registers                  */

        struct
        {
            __OM uint32_t THLPC : 8;   /*!< [7..0] TX History List Pointer Control                                    */
            uint32_t            : 24;
        } CFDTHLPCTR_b[2];
    };
    __IM uint32_t RESERVED31[46];

    union
    {
        __IOM uint32_t CFDGTINTSTS0;   /*!< (@ 0x00001300) Global TX Interrupt Status Register 0                      */

        struct
        {
            __IM uint32_t TSIF0   : 1; /*!< [0..0] TX Successful Interrupt Flag Channel 0                             */
            __IM uint32_t TAIF0   : 1; /*!< [1..1] TX Abort Interrupt Flag Channel 0                                  */
            __IM uint32_t TQIF0   : 1; /*!< [2..2] TX Queue Interrupt Flag Channel 0                                  */
            __IM uint32_t CFTIF0  : 1; /*!< [3..3] COM FIFO TX/GW Mode Interrupt Flag Channel 0                       */
            __IM uint32_t THIF0   : 1; /*!< [4..4] TX History List Interrupt Channel 0                                */
            __IM uint32_t TQOFIF0 : 1; /*!< [5..5] TX Queue One Frame Transmission Interrupt Flag Channel
                                        *   0                                                                         */
            __IM uint32_t CFOTIF0 : 1; /*!< [6..6] COM FIFO One Frame Transmission Interrupt Flag Channel
                                        *   0                                                                         */
            uint32_t              : 1;
            __IM uint32_t TSIF1   : 1; /*!< [8..8] TX Successful Interrupt Flag Channel 1                             */
            __IM uint32_t TAIF1   : 1; /*!< [9..9] TX Abort Interrupt Flag Channel 1                                  */
            __IM uint32_t TQIF1   : 1; /*!< [10..10] TX Queue Interrupt Flag Channel 1                                */
            __IM uint32_t CFTIF1  : 1; /*!< [11..11] COM FIFO TX/GW Mode Interrupt Flag Channel 1                     */
            __IM uint32_t THIF1   : 1; /*!< [12..12] TX History List Interrupt Channel 1                              */
            __IM uint32_t TQOFIF1 : 1; /*!< [13..13] TX Queue One Frame Transmission Interrupt Flag Channel
                                        *   1                                                                         */
            __IM uint32_t CFOTIF1 : 1; /*!< [14..14] COM FIFO One Frame Transmission Interrupt Flag Channel
                                        *   1                                                                         */
            uint32_t : 17;
        } CFDGTINTSTS0_b;
    };
    __IM uint32_t RESERVED32;

    union
    {
        __IOM uint32_t CFDGTSTCFG;     /*!< (@ 0x00001308) Global Test Configuration Register                         */

        struct
        {
            __IOM uint32_t ICBCE : 2;  /*!< [1..0] Channel n Internal CAN Bus Communication Test Mode Enable          */
            uint32_t             : 14;
            __IOM uint32_t RTMPS : 10; /*!< [25..16] RAM Test Mode Page Select                                        */
            uint32_t             : 6;
        } CFDGTSTCFG_b;
    };

    union
    {
        __IOM uint32_t CFDGTSTCTR;      /*!< (@ 0x0000130C) Global Test Control Register                               */

        struct
        {
            __IOM uint32_t ICBCTME : 1; /*!< [0..0] Internal CAN Bus Communication Test Mode Enable                    */
            uint32_t               : 1;
            __IOM uint32_t RTME    : 1; /*!< [2..2] RAM Test Mode Enable                                               */
            uint32_t               : 29;
        } CFDGTSTCTR_b;
    };
    __IM uint32_t RESERVED33;

    union
    {
        __IOM uint32_t CFDGFDCFG;      /*!< (@ 0x00001314) Global FD Configuration register                           */

        struct
        {
            __IOM uint32_t RPED   : 1; /*!< [0..0] RES bit Protocol exception disable                                 */
            uint32_t              : 7;
            __IOM uint32_t TSCCFG : 2; /*!< [9..8] Timestamp capture configuration                                    */
            uint32_t              : 22;
        } CFDGFDCFG_b;
    };

    union
    {
        __IOM uint32_t CFDGCRCCFG;     /*!< (@ 0x00001318) Global FD CRC Configuration register                       */

        struct
        {
            __IOM uint32_t NIE : 1;    /*!< [0..0] Non ISO enable                                                     */
            uint32_t           : 31;
        } CFDGCRCCFG_b;
    };

    union
    {
        __IOM uint32_t CFDGLOCKK;      /*!< (@ 0x0000131C) Global Lock Key Register                                   */

        struct
        {
            __OM uint32_t LOCK : 16;   /*!< [15..0] Lock Key                                                          */
            uint32_t           : 16;
        } CFDGLOCKK_b;
    };

    union
    {
        __IOM uint32_t CFDGLOTB;       /*!< (@ 0x00001320) Global OTB FIFO Configuration / Status Register            */

        struct
        {
            __IOM uint32_t OTBFE  : 1; /*!< [0..0] OTB FIFO Enable                                                    */
            uint32_t              : 7;
            __IM uint32_t  OTBEMP : 1; /*!< [8..8] OTB FIFO Empty                                                     */
            __IM uint32_t  OTBFLL : 1; /*!< [9..9] OTB FIFO Full                                                      */
            __IOM uint32_t OTBMLT : 1; /*!< [10..10] OTB FIFO Message Lost                                            */
            __IM uint32_t  OTBMC  : 5; /*!< [15..11] OTB FIFO Message Count                                           */
            uint32_t              : 16;
        } CFDGLOTB_b;
    };

    union
    {
        __IOM uint32_t CFDGAFLIGNENT;  /*!< (@ 0x00001324) Global AFL Ignore Entry Register                           */

        struct
        {
            __IOM uint32_t IRN : 9;    /*!< [8..0] Ignore Rule Number                                                 */
            uint32_t           : 7;
            __IOM uint32_t ICN : 3;    /*!< [18..16] Ignore Channel Number                                            */
            uint32_t           : 13;
        } CFDGAFLIGNENT_b;
    };

    union
    {
        __IOM uint32_t CFDGAFLIGNCTR;  /*!< (@ 0x00001328) Global AFL Ignore Control Register                         */

        struct
        {
            __IOM uint32_t IREN : 1;   /*!< [0..0] Ignore Rule Enable                                                 */
            uint32_t            : 7;
            __OM uint32_t KEY   : 8;   /*!< [15..8] Key code                                                          */
            uint32_t            : 16;
        } CFDGAFLIGNCTR_b;
    };
    __IM uint32_t RESERVED34;

    union
    {
        __IOM uint32_t CFDCDTCT;        /*!< (@ 0x00001330) DMA Transfer Control Register                              */

        struct
        {
            __IOM uint32_t RFDMAE0 : 1; /*!< [0..0] DMA Transfer Enable for RXFIFO 0                                   */
            __IOM uint32_t RFDMAE1 : 1; /*!< [1..1] DMA Transfer Enable for RXFIFO 1                                   */
            __IOM uint32_t RFDMAE2 : 1; /*!< [2..2] DMA Transfer Enable for RXFIFO 2                                   */
            __IOM uint32_t RFDMAE3 : 1; /*!< [3..3] DMA Transfer Enable for RXFIFO 3                                   */
            __IOM uint32_t RFDMAE4 : 1; /*!< [4..4] DMA Transfer Enable for RXFIFO 4                                   */
            __IOM uint32_t RFDMAE5 : 1; /*!< [5..5] DMA Transfer Enable for RXFIFO 5                                   */
            __IOM uint32_t RFDMAE6 : 1; /*!< [6..6] DMA Transfer Enable for RXFIFO 6                                   */
            __IOM uint32_t RFDMAE7 : 1; /*!< [7..7] DMA Transfer Enable for RXFIFO 7                                   */
            __IOM uint32_t CFDMAE0 : 1; /*!< [8..8] DMA Transfer Enable for Common FIFO 0 of channel 0                 */
            __IOM uint32_t CFDMAE1 : 1; /*!< [9..9] DMA Transfer Enable for Common FIFO 0 of channel 1                 */
            uint32_t               : 22;
        } CFDCDTCT_b;
    };

    union
    {
        __IM uint32_t CFDCDTSTS;         /*!< (@ 0x00001334) DMA Transfer Status Register                               */

        struct
        {
            __IM uint32_t RFDMASTS0 : 1; /*!< [0..0] DMA Transfer Status for RX FIFO 0                                  */
            __IM uint32_t RFDMASTS1 : 1; /*!< [1..1] DMA Transfer Status for RX FIFO 1                                  */
            __IM uint32_t RFDMASTS2 : 1; /*!< [2..2] DMA Transfer Status for RX FIFO 2                                  */
            __IM uint32_t RFDMASTS3 : 1; /*!< [3..3] DMA Transfer Status for RX FIFO 3                                  */
            __IM uint32_t RFDMASTS4 : 1; /*!< [4..4] DMA Transfer Status for RX FIFO 4                                  */
            __IM uint32_t RFDMASTS5 : 1; /*!< [5..5] DMA Transfer Status for RX FIFO 5                                  */
            __IM uint32_t RFDMASTS6 : 1; /*!< [6..6] DMA Transfer Status for RX FIFO 6                                  */
            __IM uint32_t RFDMASTS7 : 1; /*!< [7..7] DMA Transfer Status for RX FIFO 7                                  */
            __IM uint32_t CFDMASTS0 : 1; /*!< [8..8] DMA Transfer Status only for Common FIFO 0 of channel
                                          *   0                                                                         */
            __IM uint32_t CFDMASTS1 : 1; /*!< [9..9] DMA Transfer Status only for Common FIFO 0 of channel
                                          *   1                                                                         */
            uint32_t : 22;
        } CFDCDTSTS_b;
    };
    __IM uint32_t RESERVED35[2];

    union
    {
        __IOM uint32_t CFDCDTTCT;        /*!< (@ 0x00001340) DMA TX Transfer Control Register                           */

        struct
        {
            __IOM uint32_t TQ0DMAE0 : 1; /*!< [0..0] DMA TX Transfer Enable for TXQ 0 of channel 0                      */
            __IOM uint32_t TQ0DMAE1 : 1; /*!< [1..1] DMA TX Transfer Enable for TXQ 0 of channel 1                      */
            uint32_t                : 6;
            __IOM uint32_t TQ3DMAE0 : 1; /*!< [8..8] DMA TX Transfer Enable for TXQ 3 of channel 0                      */
            __IOM uint32_t TQ3DMAE1 : 1; /*!< [9..9] DMA TX Transfer Enable for TXQ 3 of channel 1                      */
            uint32_t                : 6;
            __IOM uint32_t CFDMAE0  : 1; /*!< [16..16] DMA TX Transfer Enable for Common FIFO 2 of channel
                                          *   0                                                                         */
            __IOM uint32_t CFDMAE1 : 1;  /*!< [17..17] DMA TX Transfer Enable for Common FIFO 2 of channel
                                          *   1                                                                         */
            uint32_t : 14;
        } CFDCDTTCT_b;
    };

    union
    {
        __IOM uint32_t CFDCDTTSTS;        /*!< (@ 0x00001344) DMA TX Transfer Status Register                            */

        struct
        {
            __IM uint32_t TQ0DMASTS0 : 1; /*!< [0..0] DMA TX Transfer Status for TXQ0 of channel 0                       */
            __IM uint32_t TQ0DMASTS1 : 1; /*!< [1..1] DMA TX Transfer Status for TXQ0 of channel 1                       */
            uint32_t                 : 6;
            __IM uint32_t TQ3DMASTS0 : 1; /*!< [8..8] DMA TX Transfer Status for TXQ3 of channel 0                       */
            __IM uint32_t TQ3DMASTS1 : 1; /*!< [9..9] DMA TX Transfer Status for TXQ3 of channel 1                       */
            uint32_t                 : 6;
            __IM uint32_t CFDMASTS0  : 1; /*!< [16..16] DMA TX Transfer Status only for Common FIFO 2 of channel
                                           *   0                                                                         */
            __IM uint32_t CFDMASTS1 : 1;  /*!< [17..17] DMA TX Transfer Status only for Common FIFO 2 of channel
                                           *   1                                                                         */
            uint32_t : 14;
        } CFDCDTTSTS_b;
    };
    __IM uint32_t RESERVED36[2];

    union
    {
        __IOM uint32_t CFDGRINTSTS[2]; /*!< (@ 0x00001350) Global RX Interrupt Status Register                        */

        struct
        {
            __IM uint32_t QFIF    : 3; /*!< [2..0] TXQ Full Interrupt Flag Channel n                                  */
            uint32_t              : 5;
            __IM uint32_t QOFRIF  : 3; /*!< [10..8] TXQ One Frame RX Interrupt Flag Channel n                         */
            uint32_t              : 5;
            __IM uint32_t CFRIF   : 3; /*!< [18..16] Common FIFO RX Interrupt Flag Channel n                          */
            uint32_t              : 5;
            __IM uint32_t CFRFIF  : 3; /*!< [26..24] Common FIFO FDC level Full Interrupt Flag Channel n              */
            uint32_t              : 1;
            __IM uint32_t CFOFRIF : 3; /*!< [30..28] Common FIFO One Frame RX Interrupt Flag Channel n                */
            uint32_t              : 1;
        } CFDGRINTSTS_b[2];
    };
    __IM uint32_t RESERVED37[10];

    union
    {
        __IOM uint32_t CFDGRSTC;       /*!< (@ 0x00001380) Global SW reset Register                                   */

        struct
        {
            __IOM uint32_t SRST : 1;   /*!< [0..0] SW reset                                                           */
            uint32_t            : 7;
            __OM uint32_t KEY   : 8;   /*!< [15..8] Key code                                                          */
            uint32_t            : 16;
        } CFDGRSTC_b;
    };
    __IM uint32_t              RESERVED38[31];
    __IOM R_CANFD_CFDC2_Type   CFDC2[2];    /*!< (@ 0x00001400) Channel Configuration Registers                            */
    __IM uint32_t              RESERVED39[240];
    __IOM R_CANFD_CFDGAFL_Type CFDGAFL[16]; /*!< (@ 0x00001800) Global Acceptance Filter List Registers                    */
    __IM uint32_t              RESERVED40[448];
    __IOM R_CANFD_CFDRM_Type   CFDRM[32];   /*!< (@ 0x00002000) RX Message Buffer Access Registers                         */
    __IM uint32_t              RESERVED41[3072];
    __IOM R_CANFD_CFDRF_Type   CFDRF[8];    /*!< (@ 0x00006000) RX FIFO Access Registers                                   */
    __IOM R_CANFD_CFDCF_Type   CFDCF[6];    /*!< (@ 0x00006400) Common FIFO Access Registers                               */
    __IM uint32_t              RESERVED42[1600];
    __IOM R_CANFD_CFDTHL_Type  CFDTHL[2];   /*!< (@ 0x00008000) Channel TX History List                                    */
    __IM uint32_t              RESERVED43[252];

    union
    {
        __IOM uint32_t CFDRPGACC[64];    /*!< (@ 0x00008400) RAM Test Page Access Registers                             */

        struct
        {
            __IOM uint32_t RDTA : 32;    /*!< [31..0] RAM Data Test Access                                              */
        } CFDRPGACC_b[64];
    };
    __IM uint32_t            RESERVED44[7872];
    __IOM R_CANFD_CFDTM_Type CFDTM[128]; /*!< (@ 0x00010000) TX Message Buffer Access Registers                         */
} R_CANFD_Type;                          /*!< Size = 81920 (0x14000)                                                    */

/* =========================================================================================================================== */
/* ================                                         R_CANFDL                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Controller Area Network - Flexible Data (CAN-FD) Module (R_CANFDL)
 */

typedef struct                         /*!< (@ 0x400B0000) R_CANFDL Structure                                         */
{
    __IOM R_CANFDL_CFDC_Type CFDC[1];  /*!< (@ 0x00000000) Channel Control/Status                                     */
    __IM uint32_t            RESERVED;

    union
    {
        __IOM uint32_t CFDGCFG;        /*!< (@ 0x00000014) Global Configuration Register                              */

        struct
        {
            __IOM uint32_t TPRI  : 1;  /*!< [0..0] Transmission Priority                                              */
            __IOM uint32_t DCE   : 1;  /*!< [1..1] DLC Check Enable                                                   */
            __IOM uint32_t DRE   : 1;  /*!< [2..2] DLC Replacement Enable                                             */
            __IOM uint32_t MME   : 1;  /*!< [3..3] Mirror Mode Enable                                                 */
            __IOM uint32_t DCS   : 1;  /*!< [4..4] Data Link Controller Clock Select                                  */
            __IOM uint32_t CMPOC : 1;  /*!< [5..5] CAN-FD message Payload overflow configuration                      */
            uint32_t             : 2;
            __IOM uint32_t TSP   : 4;  /*!< [11..8] Timestamp Prescaler                                               */
            __IOM uint32_t TSSS  : 1;  /*!< [12..12] Timestamp Source Select                                          */
            uint32_t             : 3;
            __IOM uint32_t ITRCP : 16; /*!< [31..16] Interval Timer Reference Clock Prescaler                         */
        } CFDGCFG_b;
    };

    union
    {
        __IOM uint32_t CFDGCTR;         /*!< (@ 0x00000018) Global Control Register                                    */

        struct
        {
            __IOM uint32_t GMDC    : 2; /*!< [1..0] Global Mode Control                                                */
            __IOM uint32_t GSLPR   : 1; /*!< [2..2] Global Sleep Request                                               */
            uint32_t               : 5;
            __IOM uint32_t DEIE    : 1; /*!< [8..8] DLC check Interrupt Enable                                         */
            __IOM uint32_t MEIE    : 1; /*!< [9..9] Message lost Error Interrupt Enable                                */
            __IOM uint32_t THLEIE  : 1; /*!< [10..10] TX History List Entry Lost Interrupt Enable                      */
            __IOM uint32_t CMPOFIE : 1; /*!< [11..11] CAN-FD message payload overflow Flag Interrupt enable            */
            uint32_t               : 4;
            __IOM uint32_t TSRST   : 1; /*!< [16..16] Timestamp Reset                                                  */
            uint32_t               : 15;
        } CFDGCTR_b;
    };

    union
    {
        __IOM uint32_t CFDGSTS;         /*!< (@ 0x0000001C) Global Status Register                                     */

        struct
        {
            __IM uint32_t GRSTSTS  : 1; /*!< [0..0] Global Reset Status                                                */
            __IM uint32_t GHLTSTS  : 1; /*!< [1..1] Global Halt Status                                                 */
            __IM uint32_t GSLPSTS  : 1; /*!< [2..2] Global Sleep Status                                                */
            __IM uint32_t GRAMINIT : 1; /*!< [3..3] Global RAM Initialisation                                          */
            uint32_t               : 28;
        } CFDGSTS_b;
    };

    union
    {
        __IOM uint32_t CFDGERFL;       /*!< (@ 0x00000020) Global Error Flag Register                                 */

        struct
        {
            __IOM uint32_t DEF   : 1;  /*!< [0..0] DLC Error Flag                                                     */
            __IM uint32_t  MES   : 1;  /*!< [1..1] Message Lost Error Status                                          */
            __IM uint32_t  THLES : 1;  /*!< [2..2] TX History List Entry Lost Error Status                            */
            __IOM uint32_t CMPOF : 1;  /*!< [3..3] CAN-FD message payload overflow Flag                               */
            uint32_t             : 12;
            __IOM uint32_t EEF0  : 1;  /*!< [16..16] ECC Error Flag for Channel 0                                     */
            uint32_t             : 15;
        } CFDGERFL_b;
    };

    union
    {
        __IOM uint32_t CFDGTSC;        /*!< (@ 0x00000024) Global Timestamp Counter Register                          */

        struct
        {
            __IM uint32_t TS : 16;     /*!< [15..0] Timestamp Value                                                   */
            uint32_t         : 16;
        } CFDGTSC_b;
    };

    union
    {
        __IOM uint32_t CFDGAFLECTR;    /*!< (@ 0x00000028) Global Acceptance Filter List Entry Control Register       */

        struct
        {
            __IOM uint32_t AFLPN  : 4; /*!< [3..0] Acceptance Filter List Page Number                                 */
            uint32_t              : 4;
            __IOM uint32_t AFLDAE : 1; /*!< [8..8] Acceptance Filter List Data Access Enable                          */
            uint32_t              : 23;
        } CFDGAFLECTR_b;
    };

    union
    {
        __IOM uint32_t CFDGAFLCFG0;    /*!< (@ 0x0000002C) Global Acceptance Filter List Configuration Register
                                        *                  0                                                          */

        struct
        {
            __IOM uint32_t RNC1 : 9;   /*!< [8..0] Rule Number for Channel 1                                          */
            uint32_t            : 7;
            __IOM uint32_t RNC0 : 9;   /*!< [24..16] Rule Number for Channel 0                                        */
            uint32_t            : 7;
        } CFDGAFLCFG0_b;
    };

    union
    {
        __IOM uint32_t CFDRMNB;        /*!< (@ 0x00000030) RX Message Buffer Number Register                          */

        struct
        {
            __IOM uint32_t NRXMB : 8;  /*!< [7..0] Number of RX Message Buffers                                       */
            __IOM uint32_t RMPLS : 3;  /*!< [10..8] Reception Message Buffer Payload Data Size                        */
            uint32_t             : 21;
        } CFDRMNB_b;
    };

    union
    {
        __IOM uint32_t CFDRMND0;       /*!< (@ 0x00000034) RX Message Buffer New Data Register 0                      */

        struct
        {
            __IOM uint32_t RMNSu : 32; /*!< [31..0] RX Message Buffer New Data Status                                 */
        } CFDRMND0_b;
    };

    union
    {
        __IOM uint32_t CFDRMIEC;       /*!< (@ 0x00000038) RX Message Buffer Interrupt Enable Configuration
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t RMIE : 32;  /*!< [31..0] RX Message Buffer Interrupt Enable                                */
        } CFDRMIEC_b;
    };

    union
    {
        __IOM uint32_t CFDRFCC[2];     /*!< (@ 0x0000003C) RX FIFO Configuration / Control Registers                  */

        struct
        {
            __IOM uint32_t RFE    : 1; /*!< [0..0] RX FIFO Enable                                                     */
            __IOM uint32_t RFIE   : 1; /*!< [1..1] RX FIFO Interrupt Enable                                           */
            uint32_t              : 2;
            __IOM uint32_t RFPLS  : 3; /*!< [6..4] Rx FIFO Payload Data Size configuration                            */
            uint32_t              : 1;
            __IOM uint32_t RFDC   : 3; /*!< [10..8] RX FIFO Depth Configuration                                       */
            uint32_t              : 1;
            __IOM uint32_t RFIM   : 1; /*!< [12..12] RX FIFO Interrupt Mode                                           */
            __IOM uint32_t RFIGCV : 3; /*!< [15..13] RX FIFO Interrupt Generation Counter Value                       */
            uint32_t              : 16;
        } CFDRFCC_b[2];
    };

    union
    {
        __IOM uint32_t CFDRFSTS[2];    /*!< (@ 0x00000044) RX FIFO Status Registers                                   */

        struct
        {
            __IM uint32_t  RFEMP : 1;  /*!< [0..0] RX FIFO Empty                                                      */
            __IM uint32_t  RFFLL : 1;  /*!< [1..1] RX FIFO Full                                                       */
            __IOM uint32_t RFMLT : 1;  /*!< [2..2] RX FIFO Message Lost                                               */
            __IOM uint32_t RFIF  : 1;  /*!< [3..3] RX FIFO Interrupt Flag                                             */
            uint32_t             : 4;
            __IM uint32_t RFMC   : 8;  /*!< [15..8] RX FIFO Message Count                                             */
            uint32_t             : 16;
        } CFDRFSTS_b[2];
    };

    union
    {
        __IOM uint32_t CFDRFPCTR[2];   /*!< (@ 0x0000004C) RX FIFO Pointer Control Registers                          */

        struct
        {
            __OM uint32_t RFPC : 8;    /*!< [7..0] RX FIFO Pointer Control                                            */
            uint32_t           : 24;
        } CFDRFPCTR_b[2];
    };

    union
    {
        __IOM uint32_t CFDCFCC[1];     /*!< (@ 0x00000054) Common FIFO Configuration / Control Registers              */

        struct
        {
            __IOM uint32_t CFE    : 1; /*!< [0..0] Common FIFO Enable                                                 */
            __IOM uint32_t CFRXIE : 1; /*!< [1..1] Common FIFO RX Interrupt Enable                                    */
            __IOM uint32_t CFTXIE : 1; /*!< [2..2] Common FIFO TX Interrupt Enable                                    */
            uint32_t              : 1;
            __IOM uint32_t CFPLS  : 3; /*!< [6..4] Common FIFO Payload Data size configuration                        */
            uint32_t              : 1;
            __IOM uint32_t CFM    : 2; /*!< [9..8] Common FIFO Mode                                                   */
            __IOM uint32_t CFITSS : 1; /*!< [10..10] Common FIFO Interval Timer Source Select                         */
            __IOM uint32_t CFITR  : 1; /*!< [11..11] Common FIFO Interval Timer Resolution                            */
            __IOM uint32_t CFIM   : 1; /*!< [12..12] Common FIFO Interrupt Mode                                       */
            __IOM uint32_t CFIGCV : 3; /*!< [15..13] Common FIFO Interrupt Generation Counter Value                   */
            __IOM uint32_t CFTML  : 5; /*!< [20..16] Common FIFO TX Message Buffer Link                               */
            __IOM uint32_t CFDC   : 3; /*!< [23..21] Common FIFO Depth Configuration                                  */
            __IOM uint32_t CFITT  : 8; /*!< [31..24] Common FIFO Interval Transmission Time                           */
        } CFDCFCC_b[1];
    };

    union
    {
        __IOM uint32_t CFDCFSTS[1];    /*!< (@ 0x00000058) Common FIFO Status Registers                               */

        struct
        {
            __IM uint32_t  CFEMP  : 1; /*!< [0..0] Common FIFO Empty                                                  */
            __IM uint32_t  CFFLL  : 1; /*!< [1..1] Common FIFO Full                                                   */
            __IOM uint32_t CFMLT  : 1; /*!< [2..2] Common FIFO Message Lost                                           */
            __IOM uint32_t CFRXIF : 1; /*!< [3..3] Common RX FIFO Interrupt Flag                                      */
            __IOM uint32_t CFTXIF : 1; /*!< [4..4] Common TX FIFO Interrupt Flag                                      */
            uint32_t              : 3;
            __IM uint32_t CFMC    : 8; /*!< [15..8] Common FIFO Message Count                                         */
            uint32_t              : 16;
        } CFDCFSTS_b[1];
    };

    union
    {
        __IOM uint32_t CFDCFPCTR[1];   /*!< (@ 0x0000005C) Common FIFO Pointer Control Registers                      */

        struct
        {
            __OM uint32_t CFPC : 8;    /*!< [7..0] Common FIFO Pointer Control                                        */
            uint32_t           : 24;
        } CFDCFPCTR_b[1];
    };

    union
    {
        __IM uint32_t CFDFESTS;        /*!< (@ 0x00000060) FIFO Empty Status Register                                 */

        struct
        {
            __IM uint32_t RFXEMP : 2;  /*!< [1..0] RX FIF0 Empty Status                                               */
            uint32_t             : 6;
            __IM uint32_t CFXEMP : 1;  /*!< [8..8] Common FIF0 Empty Status                                           */
            uint32_t             : 23;
        } CFDFESTS_b;
    };

    union
    {
        __IM uint32_t CFDFFSTS;        /*!< (@ 0x00000064) FIFO Full Status Register                                  */

        struct
        {
            __IM uint32_t RFXFLL : 2;  /*!< [1..0] RX FIF0 Full Status                                                */
            uint32_t             : 6;
            __IM uint32_t CFXFLL : 1;  /*!< [8..8] Common FIF0 Full Status                                            */
            uint32_t             : 23;
        } CFDFFSTS_b;
    };

    union
    {
        __IM uint32_t CFDFMSTS;        /*!< (@ 0x00000068) FIFO Message Lost Status Register                          */

        struct
        {
            __IM uint32_t RFXMLT : 2;  /*!< [1..0] RX FIFO Msg Lost Status                                            */
            uint32_t             : 6;
            __IM uint32_t CFXMLT : 1;  /*!< [8..8] Common FIFO Msg Lost Status                                        */
            uint32_t             : 23;
        } CFDFMSTS_b;
    };

    union
    {
        __IOM uint32_t CFDRFISTS;      /*!< (@ 0x0000006C) RX FIFO Interrupt Flag Status Register                     */

        struct
        {
            __IM uint32_t RFXIF : 1;   /*!< [0..0] RX FIFO[x] Interrupt Flag Status                                   */
            uint32_t            : 31;
        } CFDRFISTS_b;
    };

    union
    {
        __IOM uint8_t CFDTMC[4];       /*!< (@ 0x00000070) TX Message Buffer Control Registers                        */

        struct
        {
            __IOM uint8_t TMTR  : 1;   /*!< [0..0] TX Message Buffer Transmission Request                             */
            __IOM uint8_t TMTAR : 1;   /*!< [1..1] TX Message Buffer Transmission abort Request                       */
            __IOM uint8_t TMOM  : 1;   /*!< [2..2] TX Message Buffer One-shot Mode                                    */
            uint8_t             : 5;
        } CFDTMC_b[4];
    };

    union
    {
        __IOM uint8_t CFDTMSTS[4];     /*!< (@ 0x00000074) TX Message Buffer Status Registers                         */

        struct
        {
            __IM uint8_t  TMTSTS : 1;  /*!< [0..0] TX Message Buffer Transmission Status                              */
            __IOM uint8_t TMTRF  : 2;  /*!< [2..1] TX Message Buffer Transmission Result Flag                         */
            __IM uint8_t  TMTRM  : 1;  /*!< [3..3] TX Message Buffer Transmission Request Mirrored                    */
            __IM uint8_t  TMTARM : 1;  /*!< [4..4] TX Message Buffer Transmission abort Request Mirrored              */
            uint8_t              : 3;
        } CFDTMSTS_b[4];
    };

    union
    {
        __IM uint32_t CFDTMTRSTS[1];       /*!< (@ 0x00000078) TX Message Buffer Transmission Request Status
                                            *                  Register                                                   */

        struct
        {
            __IM uint32_t CFDTMTRSTSg : 4; /*!< [3..0] TX Message Buffer Transmission Request Status                      */
            uint32_t                  : 28;
        } CFDTMTRSTS_b[1];
    };

    union
    {
        __IM uint32_t CFDTMTARSTS[1];       /*!< (@ 0x0000007C) TX Message Buffer Transmission Abort Request
                                             *                  Status Register                                            */

        struct
        {
            __IM uint32_t CFDTMTARSTSg : 4; /*!< [3..0] TX Message Buffer Transmission abort Request Status                */
            uint32_t                   : 28;
        } CFDTMTARSTS_b[1];
    };

    union
    {
        __IM uint32_t CFDTMTCSTS[1];       /*!< (@ 0x00000080) TX Message Buffer Transmission Completion Status
                                            *                  Register                                                   */

        struct
        {
            __IM uint32_t CFDTMTCSTSg : 4; /*!< [3..0] TX Message Buffer Transmission Completion Status                   */
            uint32_t                  : 28;
        } CFDTMTCSTS_b[1];
    };

    union
    {
        __IM uint32_t CFDTMTASTS[1];       /*!< (@ 0x00000084) TX Message Buffer Transmission Abort Status Register       */

        struct
        {
            __IM uint32_t CFDTMTASTSg : 4; /*!< [3..0] TX Message Buffer Transmission abort Status                        */
            uint32_t                  : 28;
        } CFDTMTASTS_b[1];
    };

    union
    {
        __IOM uint32_t CFDTMIEC[1];    /*!< (@ 0x00000088) TX Message Buffer Interrupt Enable Configuration
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t TMIEg : 4;  /*!< [3..0] TX Message Buffer Interrupt Enable                                 */
            uint32_t             : 28;
        } CFDTMIEC_b[1];
    };

    union
    {
        __IOM uint32_t CFDTXQCC0[1];    /*!< (@ 0x0000008C) TX Queue Configuration / Control Registers 0               */

        struct
        {
            __IOM uint32_t TXQE    : 1; /*!< [0..0] TX Queue Enable                                                    */
            uint32_t               : 4;
            __IOM uint32_t TXQTXIE : 1; /*!< [5..5] TX Queue TX Interrupt Enable                                       */
            uint32_t               : 1;
            __IOM uint32_t TXQIM   : 1; /*!< [7..7] TX Queue Interrupt Mode                                            */
            __IOM uint32_t TXQDC   : 2; /*!< [9..8] TX Queue Depth Configuration                                       */
            uint32_t               : 22;
        } CFDTXQCC0_b[1];
    };

    union
    {
        __IOM uint32_t CFDTXQSTS0[1];   /*!< (@ 0x00000090) TX Queue Status Registers 0                                */

        struct
        {
            __IM uint32_t  TXQEMP  : 1; /*!< [0..0] TX Queue Empty                                                     */
            __IM uint32_t  TXQFLL  : 1; /*!< [1..1] TX Queue Full                                                      */
            __IOM uint32_t TXQTXIF : 1; /*!< [2..2] TX Queue TX Interrupt Flag                                         */
            uint32_t               : 5;
            __IM uint32_t TXQMC    : 6; /*!< [13..8] TX Queue Message Count                                            */
            uint32_t               : 18;
        } CFDTXQSTS0_b[1];
    };

    union
    {
        __IOM uint32_t CFDTXQPCTR0[1]; /*!< (@ 0x00000094) TX Queue Pointer Control Registers 0                       */

        struct
        {
            __OM uint32_t TXQPC : 8;   /*!< [7..0] TX Queue Pointer Control                                           */
            uint32_t            : 24;
        } CFDTXQPCTR0_b[1];
    };

    union
    {
        __IOM uint32_t CFDTHLCC[1];    /*!< (@ 0x00000098) TX History List Configuration / Control Register           */

        struct
        {
            __IOM uint32_t THLE   : 1; /*!< [0..0] TX History List Enable                                             */
            uint32_t              : 7;
            __IOM uint32_t THLIE  : 1; /*!< [8..8] TX History List Interrupt Enable                                   */
            __IOM uint32_t THLIM  : 1; /*!< [9..9] TX History List Interrupt Mode                                     */
            __IOM uint32_t THLDTE : 1; /*!< [10..10] TX History List Dedicated TX Enable                              */
            uint32_t              : 21;
        } CFDTHLCC_b[1];
    };

    union
    {
        __IOM uint32_t CFDTHLSTS[1];   /*!< (@ 0x0000009C) TX History List Status Register                            */

        struct
        {
            __IM uint32_t  THLEMP : 1; /*!< [0..0] TX History List Empty                                              */
            __IM uint32_t  THLFLL : 1; /*!< [1..1] TX History List Full                                               */
            __IOM uint32_t THLELT : 1; /*!< [2..2] TX History List Entry Lost                                         */
            __IOM uint32_t THLIF  : 1; /*!< [3..3] TX History List Interrupt Flag                                     */
            uint32_t              : 4;
            __IM uint32_t THLMC   : 6; /*!< [13..8] TX History List Message Count                                     */
            uint32_t              : 18;
        } CFDTHLSTS_b[1];
    };

    union
    {
        __IOM uint32_t CFDTHLPCTR[1];  /*!< (@ 0x000000A0) TX History List Pointer Control Registers                  */

        struct
        {
            __OM uint32_t THLPC : 8;   /*!< [7..0] TX History List Pointer Control                                    */
            uint32_t            : 24;
        } CFDTHLPCTR_b[1];
    };

    union
    {
        __IOM uint32_t CFDGTINTSTS0;   /*!< (@ 0x000000A4) Global TX Interrupt Status Register 0                      */

        struct
        {
            __IM uint32_t TSIF0  : 1;  /*!< [0..0] TX Successful Interrupt Flag Channel 0                             */
            __IM uint32_t TAIF0  : 1;  /*!< [1..1] TX Abort Interrupt Flag Channel 0                                  */
            __IM uint32_t TQIF0  : 1;  /*!< [2..2] TX Queue Interrupt Flag Channel 0                                  */
            __IM uint32_t CFTIF0 : 1;  /*!< [3..3] COM FIFO TX/GW Mode Interrupt Flag Channel 0                       */
            __IM uint32_t THIF0  : 1;  /*!< [4..4] TX History List Interrupt Channel 0                                */
            uint32_t             : 27;
        } CFDGTINTSTS0_b;
    };

    union
    {
        __IOM uint32_t CFDGTSTCFG;     /*!< (@ 0x000000A8) Global Test Configuration Register                         */

        struct
        {
            uint32_t             : 16;
            __IOM uint32_t RTMPS : 10; /*!< [25..16] RAM Test Mode Page Select                                        */
            uint32_t             : 6;
        } CFDGTSTCFG_b;
    };

    union
    {
        __IOM uint32_t CFDGTSTCTR;     /*!< (@ 0x000000AC) Global Test Control Register                               */

        struct
        {
            uint32_t            : 2;
            __IOM uint32_t RTME : 1;   /*!< [2..2] RAM Test Mode Enable                                               */
            uint32_t            : 29;
        } CFDGTSTCTR_b;
    };

    union
    {
        __IOM uint32_t CFDGFDCFG;      /*!< (@ 0x000000B0) Global FD Configuration register                           */

        struct
        {
            __IOM uint32_t RPED   : 1; /*!< [0..0] RES bit Protocol exception disable                                 */
            uint32_t              : 7;
            __IOM uint32_t TSCCFG : 2; /*!< [9..8] Timestamp capture configuration                                    */
            uint32_t              : 22;
        } CFDGFDCFG_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __IOM uint32_t CFDGLOCKK;      /*!< (@ 0x000000B8) Global Lock Key Register                                   */

        struct
        {
            __OM uint32_t LOCK : 16;   /*!< [15..0] Lock Key                                                          */
            uint32_t           : 16;
        } CFDGLOCKK_b;
    };
    __IM uint32_t RESERVED2;

    union
    {
        __IOM uint32_t CFDGAFLIGNENT;  /*!< (@ 0x000000C0) Global AFL Ignore Entry Register                           */

        struct
        {
            __IOM uint32_t IRN : 5;    /*!< [4..0] Ignore Rule Number                                                 */
            uint32_t           : 27;
        } CFDGAFLIGNENT_b;
    };

    union
    {
        __IOM uint32_t CFDGAFLIGNCTR;  /*!< (@ 0x000000C4) Global AFL Ignore Control Register                         */

        struct
        {
            __IOM uint32_t IREN : 1;   /*!< [0..0] Ignore Rule Enable                                                 */
            uint32_t            : 7;
            __OM uint32_t KEY   : 8;   /*!< [15..8] Key code                                                          */
            uint32_t            : 16;
        } CFDGAFLIGNCTR_b;
    };

    union
    {
        __IOM uint32_t CFDCDTCT;        /*!< (@ 0x000000C8) DMA Transfer Control Register                              */

        struct
        {
            __IOM uint32_t RFDMAE0 : 1; /*!< [0..0] DMA Transfer Enable for RXFIFO 0                                   */
            __IOM uint32_t RFDMAE1 : 1; /*!< [1..1] DMA Transfer Enable for RXFIFO 1                                   */
            uint32_t               : 6;
            __IOM uint32_t CFDMAE0 : 1; /*!< [8..8] DMA Transfer Enable for Common FIFO 0 of channel 0                 */
            uint32_t               : 23;
        } CFDCDTCT_b;
    };

    union
    {
        __IM uint32_t CFDCDTSTS;         /*!< (@ 0x000000CC) DMA Transfer Status Register                               */

        struct
        {
            __IM uint32_t RFDMASTS0 : 1; /*!< [0..0] DMA Transfer Status for RX FIFO 0                                  */
            __IM uint32_t RFDMASTS1 : 1; /*!< [1..1] DMA Transfer Status for RX FIFO 1                                  */
            uint32_t                : 6;
            __IM uint32_t CFDMASTS0 : 1; /*!< [8..8] DMA Transfer Status only for Common FIFO 0 of channel
                                          *   0                                                                         */
            uint32_t : 23;
        } CFDCDTSTS_b;
    };
    __IM uint32_t RESERVED3[2];

    union
    {
        __IOM uint32_t CFDGRSTC;       /*!< (@ 0x000000D8) Global SW reset Register                                   */

        struct
        {
            __IOM uint32_t SRST : 1;   /*!< [0..0] SW reset                                                           */
            uint32_t            : 7;
            __OM uint32_t KEY   : 8;   /*!< [15..8] Key code                                                          */
            uint32_t            : 16;
        } CFDGRSTC_b;
    };
    __IM uint32_t               RESERVED4[9];
    __IOM R_CANFDL_CFDC2_Type   CFDC2[1];    /*!< (@ 0x00000100) Channel Configuration Registers                            */
    __IOM R_CANFDL_CFDGAFL_Type CFDGAFL[16]; /*!< (@ 0x00000120) Global Acceptance Filter List Registers                    */
    __IM uint32_t               RESERVED5[24];

    union
    {
        __IOM uint32_t CFDRPGACC[64];     /*!< (@ 0x00000280) RAM Test Page Access Registers                             */

        struct
        {
            __IOM uint32_t RDTA : 32;     /*!< [31..0] RAM Data Test Access                                              */
        } CFDRPGACC_b[64];
    };
    __IM uint32_t              RESERVED6[104];
    __IOM R_CANFDL_CFDRF_Type  CFDRF[2];  /*!< (@ 0x00000520) RX FIFO Access Registers                                   */
    __IOM R_CANFDL_CFDCF_Type  CFDCF[1];  /*!< (@ 0x000005B8) Common FIFO Access Registers                               */
    __IOM R_CANFDL_CFDTM_Type  CFDTM[4];  /*!< (@ 0x00000604) TX Message Buffer Access Registers                         */
    __IM uint32_t              RESERVED7[3];
    __IOM R_CANFDL_CFDTHL_Type CFDTHL[1]; /*!< (@ 0x00000740) Channel TX History List                                    */
    __IM uint32_t              RESERVED8[118];
    __IOM R_CANFDL_CFDRMC_Type CFDRMC[4]; /*!< (@ 0x00000920) RX Message Buffer Access Clusters                          */
} R_CANFDL_Type;                          /*!< Size = 6432 (0x1920)                                                      */

/* =========================================================================================================================== */
/* ================                                           R_CRC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Cyclic Redundancy Check (CRC) Calculator (R_CRC)
 */

typedef struct                         /*!< (@ 0x40074000) R_CRC Structure                                            */
{
    union
    {
        __IOM uint8_t CRCCR0;          /*!< (@ 0x00000000) CRC Control Register0                                      */

        struct
        {
            __IOM uint8_t GPS    : 3;  /*!< [2..0] CRC Generating Polynomial Switching                                */
            uint8_t              : 3;
            __IOM uint8_t LMS    : 1;  /*!< [6..6] CRC Calculation Switching                                          */
            __OM uint8_t  DORCLR : 1;  /*!< [7..7] CRCDOR Register Clear                                              */
        } CRCCR0_b;
    };

    union
    {
        __IOM uint8_t CRCCR1;          /*!< (@ 0x00000001) CRC Control Register1                                      */

        struct
        {
            uint8_t              : 6;
            __IOM uint8_t CRCSWR : 1;  /*!< [6..6] Snoop-on-write/read switch bit                                     */
            __IOM uint8_t CRCSEN : 1;  /*!< [7..7] Snoop enable bit                                                   */
        } CRCCR1_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        union
        {
            __IOM uint32_t CRCDIR;          /*!< (@ 0x00000004) CRC Data Input Register                                    */

            struct
            {
                __IOM uint32_t CRCDIR : 32; /*!< [31..0] Calculation input Data (Case of CRC-32, CRC-32C )                 */
            } CRCDIR_b;
        };

        union
        {
            __IOM uint8_t CRCDIR_BY;         /*!< (@ 0x00000004) CRC Data Input Register (byte access)                      */

            struct
            {
                __IOM uint8_t CRCDIR_BY : 8; /*!< [7..0] Calculation input Data ( Case of CRC-8, CRC-16 or CRC-CCITT
                                              *   )                                                                         */
            } CRCDIR_BY_b;
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CRCDOR;          /*!< (@ 0x00000008) CRC Data Output Register                                   */

            struct
            {
                __IOM uint32_t CRCDOR : 32; /*!< [31..0] Calculation output Data (Case of CRC-32, CRC-32C )                */
            } CRCDOR_b;
        };

        union
        {
            __IOM uint16_t CRCDOR_HA;          /*!< (@ 0x00000008) CRC Data Output Register (halfword access)                 */

            struct
            {
                __IOM uint16_t CRCDOR_HA : 16; /*!< [15..0] Calculation output Data (Case of CRC-16 or CRC-CCITT
                                                *   )                                                                         */
            } CRCDOR_HA_b;
        };

        union
        {
            __IOM uint8_t CRCDOR_BY;         /*!< (@ 0x00000008) CRC Data Output Register(byte access)                      */

            struct
            {
                __IOM uint8_t CRCDOR_BY : 8; /*!< [7..0] Calculation output Data (Case of CRC-8 )                           */
            } CRCDOR_BY_b;
        };
    };

    union
    {
        __IOM uint16_t CRCSAR;         /*!< (@ 0x0000000C) Snoop Address Register                                     */

        struct
        {
            __IOM uint16_t CRCSA : 14; /*!< [13..0] snoop address bitSet the I/O register address to snoop            */
            uint16_t             : 2;
        } CRCSAR_b;
    };
    __IM uint16_t RESERVED1;
} R_CRC_Type;                          /*!< Size = 16 (0x10)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_CTSU                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Capacitive Touch Sensing Unit (R_CTSU)
 */

typedef struct                            /*!< (@ 0x40081000) R_CTSU Structure                                           */
{
    union
    {
        __IOM uint8_t CTSUCR0;            /*!< (@ 0x00000000) CTSU Control Register 0                                    */

        struct
        {
            __IOM uint8_t CTSUSTRT   : 1; /*!< [0..0] CTSU Measurement Operation Start                                   */
            __IOM uint8_t CTSUCAP    : 1; /*!< [1..1] CTSU Measurement Operation Start Trigger Select                    */
            __IOM uint8_t CTSUSNZ    : 1; /*!< [2..2] CTSU Wait State Power-Saving Enable                                */
            __IOM uint8_t CTSUIOC    : 1; /*!< [3..3] CTSU Transmit Pin Control                                          */
            __IOM uint8_t CTSUINIT   : 1; /*!< [4..4] CTSU Control Block Initialization                                  */
            uint8_t                  : 2;
            __IOM uint8_t CTSUTXVSEL : 1; /*!< [7..7] CTSU Transmission power supply selection                           */
        } CTSUCR0_b;
    };

    union
    {
        __IOM uint8_t CTSUCR1;            /*!< (@ 0x00000001) CTSU Control Register 1                                    */

        struct
        {
            __IOM uint8_t CTSUPON    : 1; /*!< [0..0] CTSU Power Supply Enable                                           */
            __IOM uint8_t CTSUCSW    : 1; /*!< [1..1] CTSU LPF Capacitance Charging Control                              */
            __IOM uint8_t CTSUATUNE0 : 1; /*!< [2..2] CTSU Power Supply Operating Mode Setting                           */
            __IOM uint8_t CTSUATUNE1 : 1; /*!< [3..3] CTSU Power Supply Capacity Adjustment                              */
            __IOM uint8_t CTSUCLK    : 2; /*!< [5..4] CTSU Operating Clock Select                                        */
            __IOM uint8_t CTSUMD     : 2; /*!< [7..6] CTSU Measurement Mode Select                                       */
        } CTSUCR1_b;
    };

    union
    {
        __IOM uint8_t CTSUSDPRS;           /*!< (@ 0x00000002) CTSU Synchronous Noise Reduction Setting Register          */

        struct
        {
            __IOM uint8_t CTSUPRRATIO : 4; /*!< [3..0] CTSU Measurement Time and Pulse Count AdjustmentRecommended
                                            *   setting: 3 (0011b)                                                        */
            __IOM uint8_t CTSUPRMODE : 2;  /*!< [5..4] CTSU Base Period and Pulse Count Setting                           */
            __IOM uint8_t CTSUSOFF   : 1;  /*!< [6..6] CTSU High-Pass Noise Reduction Function Off Setting                */
            uint8_t                  : 1;
        } CTSUSDPRS_b;
    };

    union
    {
        __IOM uint8_t CTSUSST;         /*!< (@ 0x00000003) CTSU Sensor Stabilization Wait Control Register            */

        struct
        {
            __IOM uint8_t CTSUSST : 8; /*!< [7..0] CTSU Sensor Stabilization Wait ControlNOTE: The value
                                        *   of these bits should be fixed to 00010000b.                               */
        } CTSUSST_b;
    };

    union
    {
        __IOM uint8_t CTSUMCH0;         /*!< (@ 0x00000004) CTSU Measurement Channel Register 0                        */

        struct
        {
            __IOM uint8_t CTSUMCH0 : 6; /*!< [5..0] CTSU Measurement Channel 0.Note1: Writing to these bits
                                         *   is only enabled in self-capacitance single-scan mode (CTSUCR1.CTSUMD[1:0]
                                         *   bits = 00b).Note2: If the value of CTSUMCH0 was set to
                                         *   b'111111 in mode other than self-capacitor single scan
                                         *   mode, the measurement is stopped.                                         */
            uint8_t : 2;
        } CTSUMCH0_b;
    };

    union
    {
        __IOM uint8_t CTSUMCH1;        /*!< (@ 0x00000005) CTSU Measurement Channel Register 1                        */

        struct
        {
            __IM uint8_t CTSUMCH1 : 6; /*!< [5..0] CTSU Measurement Channel 1Note1: If the value of CTSUMCH1
                                        *   was set to b'111111, the measurement is stopped.                          */
            uint8_t : 2;
        } CTSUMCH1_b;
    };

    union
    {
        __IOM uint8_t CTSUCHAC[5];     /*!< (@ 0x00000006) CTSU Channel Enable Control Register                       */

        struct
        {
            __IOM uint8_t TS0 : 1;     /*!< [0..0] CTSU Channel Enable Control                                        */
            __IOM uint8_t TS1 : 1;     /*!< [1..1] CTSU Channel Enable Control                                        */
            __IOM uint8_t TS2 : 1;     /*!< [2..2] CTSU Channel Enable Control                                        */
            __IOM uint8_t TS3 : 1;     /*!< [3..3] CTSU Channel Enable Control                                        */
            __IOM uint8_t TS4 : 1;     /*!< [4..4] CTSU Channel Enable Control                                        */
            __IOM uint8_t TS5 : 1;     /*!< [5..5] CTSU Channel Enable Control                                        */
            __IOM uint8_t TS6 : 1;     /*!< [6..6] CTSU Channel Enable Control                                        */
            __IOM uint8_t TS7 : 1;     /*!< [7..7] CTSU Channel Enable Control                                        */
        } CTSUCHAC_b[5];
    };

    union
    {
        __IOM uint8_t CTSUCHTRC[5];    /*!< (@ 0x0000000B) CTSU Channel Transmit/Receive Control Register             */

        struct
        {
            __IOM uint8_t TS0 : 1;     /*!< [0..0] CTSU Channel Transmit/Receive Control                              */
            __IOM uint8_t TS1 : 1;     /*!< [1..1] CTSU Channel Transmit/Receive Control                              */
            __IOM uint8_t TS2 : 1;     /*!< [2..2] CTSU Channel Transmit/Receive Control                              */
            __IOM uint8_t TS3 : 1;     /*!< [3..3] CTSU Channel Transmit/Receive Control                              */
            __IOM uint8_t TS4 : 1;     /*!< [4..4] CTSU Channel Transmit/Receive Control                              */
            __IOM uint8_t TS5 : 1;     /*!< [5..5] CTSU Channel Transmit/Receive Control                              */
            __IOM uint8_t TS6 : 1;     /*!< [6..6] CTSU Channel Transmit/Receive Control                              */
            __IOM uint8_t TS7 : 1;     /*!< [7..7] CTSU Channel Transmit/Receive Control                              */
        } CTSUCHTRC_b[5];
    };

    union
    {
        __IOM uint8_t CTSUDCLKC;         /*!< (@ 0x00000010) CTSU High-Pass Noise Reduction Control Register            */

        struct
        {
            __IOM uint8_t CTSUSSMOD : 2; /*!< [1..0] CTSU Diffusion Clock Mode SelectNOTE: This bit should
                                          *   be set to 00b.                                                            */
            uint8_t                 : 2;
            __IOM uint8_t CTSUSSCNT : 2; /*!< [5..4] CTSU Diffusion Clock Mode ControlNOTE: This bit should
                                          *   be set to 11b.                                                            */
            uint8_t : 2;
        } CTSUDCLKC_b;
    };

    union
    {
        __IOM uint8_t CTSUST;           /*!< (@ 0x00000011) CTSU Status Register                                       */

        struct
        {
            __IM uint8_t CTSUSTC   : 3; /*!< [2..0] CTSU Measurement Status Counter                                    */
            uint8_t                : 1;
            __IM uint8_t  CTSUDTSR : 1; /*!< [4..4] CTSU Data Transfer Status Flag                                     */
            __IOM uint8_t CTSUSOVF : 1; /*!< [5..5] CTSU Sensor Counter Overflow Flag                                  */
            __IOM uint8_t CTSUROVF : 1; /*!< [6..6] CTSU Reference Counter Overflow Flag                               */
            __IM uint8_t  CTSUPS   : 1; /*!< [7..7] CTSU Mutual Capacitance Status Flag                                */
        } CTSUST_b;
    };

    union
    {
        __IOM uint16_t CTSUSSC;        /*!< (@ 0x00000012) CTSU High-Pass Noise Reduction Spectrum Diffusion
                                        *                  Control Register                                           */

        struct
        {
            uint16_t                 : 8;
            __IOM uint16_t CTSUSSDIV : 4; /*!< [11..8] CTSU Spectrum Diffusion Frequency Division Setting                */
            uint16_t                 : 4;
        } CTSUSSC_b;
    };

    union
    {
        __IOM uint16_t CTSUSO0;          /*!< (@ 0x00000014) CTSU Sensor Offset Register 0                              */

        struct
        {
            __IOM uint16_t CTSUSO : 10;  /*!< [9..0] CTSU Sensor Offset AdjustmentCurrent offset amount is
                                          *   CTSUSO ( 0 to 1023 )                                                      */
            __IOM uint16_t CTSUSNUM : 6; /*!< [15..10] CTSU Measurement Count Setting                                   */
        } CTSUSO0_b;
    };

    union
    {
        __IOM uint16_t CTSUSO1;           /*!< (@ 0x00000016) CTSU Sensor Offset Register 1                              */

        struct
        {
            __IOM uint16_t CTSURICOA : 8; /*!< [7..0] CTSU Reference ICO Current AdjustmentCurrent offset amount
                                           *   is CTSUSO ( 0 to 255 )                                                    */
            __IOM uint16_t CTSUSDPA : 5;  /*!< [12..8] CTSU Base Clock SettingOperating clock divided by (
                                           *   CTSUSDPA + 1 ) x 2                                                        */
            __IOM uint16_t CTSUICOG : 2;  /*!< [14..13] CTSU ICO Gain Adjustment                                         */
            uint16_t                : 1;
        } CTSUSO1_b;
    };

    union
    {
        __IM uint16_t CTSUSC;          /*!< (@ 0x00000018) CTSU Sensor Counter                                        */

        struct
        {
            __IM uint16_t CTSUSC : 16; /*!< [15..0] CTSU Sensor CounterThese bits indicate the measurement
                                        *   result of the CTSU. These bits indicate FFFFh when an overflow
                                        *   occurs.                                                                   */
        } CTSUSC_b;
    };

    union
    {
        __IM uint16_t CTSURC;          /*!< (@ 0x0000001A) CTSU Reference Counter                                     */

        struct
        {
            __IM uint16_t CTSURC : 16; /*!< [15..0] CTSU Reference CounterThese bits indicate the measurement
                                        *   result of the reference ICO.These bits indicate FFFFh when
                                        *   an overflow occurs.                                                       */
        } CTSURC_b;
    };

    union
    {
        __IM uint16_t CTSUERRS;             /*!< (@ 0x0000001C) CTSU Error Status Register                                 */

        struct
        {
            __IOM uint16_t CTSUSPMD    : 2; /*!< [1..0] Calibration Mode                                                   */
            __IOM uint16_t CTSUTSOD    : 1; /*!< [2..2] TS Pin Fixed Output                                                */
            __IOM uint16_t CTSUDRV     : 1; /*!< [3..3] Calibration Setting 1                                              */
            uint16_t                   : 2;
            __IOM uint16_t CTSUCLKSEL1 : 1; /*!< [6..6] Calibration Setting 3                                              */
            __IOM uint16_t CTSUTSOC    : 1; /*!< [7..7] Calibration Setting 2                                              */
            uint16_t                   : 7;
            __IM uint16_t CTSUICOMP    : 1; /*!< [15..15] TSCAP Voltage Error Monitor                                      */
        } CTSUERRS_b;
    };
    __IM uint16_t RESERVED;
    __IOM uint8_t CTSUTRMR;                 /*!< (@ 0x00000020) CTSU Reference Current Calibration Register                */
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2;
} R_CTSU_Type;                              /*!< Size = 36 (0x24)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_CTSU2                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Capacitive Touch Sensing Unit (R_CTSU2)
 */

typedef struct                         /*!< (@ 0x40082000) R_CTSU2 Structure                                          */
{
    union
    {
        union
        {
            __IOM uint32_t CTSUCRA;        /*!< (@ 0x00000000) CTSU Control Register A                                    */

            struct
            {
                __IOM uint32_t STRT   : 1; /*!< [0..0] CTSU Measurement Operation Start                                   */
                __IOM uint32_t CAP    : 1; /*!< [1..1] CTSU Measurement Operation Start Trigger Select                    */
                __IOM uint32_t SNZ    : 1; /*!< [2..2] CTSU Wait State Power-Saving Enable                                */
                __IOM uint32_t CFCON  : 1; /*!< [3..3] CTSU CFC Power on Control                                          */
                __OM uint32_t  INIT   : 1; /*!< [4..4] CTSU Control Block Initialization                                  */
                __IOM uint32_t PUMPON : 1; /*!< [5..5] CTSU Boost Circuit Control                                         */
                __IOM uint32_t TXVSEL : 2; /*!< [7..6] CTSU Transmission Power Supply Selection                           */
                __IOM uint32_t PON    : 1; /*!< [8..8] CTSU Power On Control                                              */
                __IOM uint32_t CSW    : 1; /*!< [9..9] TSCAP Pin Enable                                                   */
                __IOM uint32_t ATUNE0 : 1; /*!< [10..10] CTSU Power Supply Operating Mode Setting                         */
                __IOM uint32_t ATUNE1 : 1; /*!< [11..11] CTSU Current Range Adjustment                                    */
                __IOM uint32_t CLK    : 2; /*!< [13..12] CTSU Operating Clock Select                                      */
                __IOM uint32_t MD0    : 1; /*!< [14..14] CTSU Measurement Mode Select 0                                   */
                __IOM uint32_t MD1    : 1; /*!< [15..15] CTSU Measurement Mode Select 1                                   */
                __IOM uint32_t MD2    : 1; /*!< [16..16] CTSU Measurement Mode Select 2                                   */
                __IOM uint32_t ATUNE2 : 1; /*!< [17..17] CTSU Current Range Adjustment                                    */
                __IOM uint32_t LOAD   : 2; /*!< [19..18] CTSU Load Control During Measurement                             */
                __IOM uint32_t POSEL  : 2; /*!< [21..20] CTSU Non-measured Channel Output Select                          */
                __IOM uint32_t SDPSEL : 1; /*!< [22..22] CTSU Sensor Drive Pulse Select                                   */
                __IOM uint32_t PCSEL  : 1; /*!< [23..23] CTSU Boost Circuit Clock Select                                  */
                __IOM uint32_t STCLK  : 6; /*!< [29..24] CTSU STCLK Select                                                */
                __IOM uint32_t DCMODE : 1; /*!< [30..30] CTSU Current Measurement Mode Select                             */
                __IOM uint32_t DCBACK : 1; /*!< [31..31] CTSU Current Measurement Feedback Select                         */
            } CTSUCRA_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUCRAL;   /*!< (@ 0x00000000) CTSU Control Register A                                    */

                struct
                {
                    __IOM uint8_t CTSUCR0; /*!< (@ 0x00000000) CTSU Control Register A                                    */
                    __IOM uint8_t CTSUCR1; /*!< (@ 0x00000001) CTSU Control Register A                                    */
                };
            };

            union
            {
                __IOM uint16_t CTSUCRAH;   /*!< (@ 0x00000002) CTSU Control Register A                                    */

                struct
                {
                    __IOM uint8_t CTSUCR2; /*!< (@ 0x00000002) CTSU Control Register A                                    */
                    __IOM uint8_t CTSUCR3; /*!< (@ 0x00000003) CTSU Control Register A                                    */
                };
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCRB;         /*!< (@ 0x00000004) CTSU Control Register B                                    */

            struct
            {
                __IOM uint32_t PRRATIO : 4; /*!< [3..0] Frequency of Drive Pulse Phase Control                             */
                __IOM uint32_t PRMODE  : 2; /*!< [5..4] Phase Control Period                                               */
                __IOM uint32_t SOFF    : 1; /*!< [6..6] High-Pass Noise Reduction Function Disable                         */
                __IOM uint32_t PROFF   : 1; /*!< [7..7] Drive Pulse Phase Control                                          */
                __IOM uint32_t SST     : 8; /*!< [15..8] Wait Time Sensor Stabilization                                    */
                uint32_t               : 8;
                __IOM uint32_t SSMOD   : 3; /*!< [26..24] Spread Spectrum Modulation Frequency                             */
                uint32_t               : 1;
                __IOM uint32_t SSCNT   : 2; /*!< [29..28] Adjusting the SUCLK frequency                                    */
                uint32_t               : 2;
            } CTSUCRB_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUCRBL;     /*!< (@ 0x00000004) CTSU Control Register B                                    */

                struct
                {
                    __IOM uint8_t CTSUSDPRS; /*!< (@ 0x00000004) CTSU Control Register B                                    */
                    __IOM uint8_t CTSUSST;   /*!< (@ 0x00000005) CTSU Control Register B                                    */
                };
            };

            union
            {
                __IOM uint16_t CTSUCRBH; /*!< (@ 0x00000006) CTSU Control Register B                                    */

                struct
                {
                    __IM uint8_t  RESERVED;
                    __IOM uint8_t CTSUDCLKC; /*!< (@ 0x00000007) CTSU Control Register B                                    */
                };
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUMCH;      /*!< (@ 0x00000008) CTSU Measurement Channel Register                          */

            struct
            {
                __IOM uint32_t MCH0 : 6; /*!< [5..0] CTSU Measurement Channel 0                                         */
                uint32_t            : 2;
                __IOM uint32_t MCH1 : 6; /*!< [13..8] CTSU Measurement Channel 1                                        */
                uint32_t            : 2;
                __IOM uint32_t MCA0 : 1; /*!< [16..16] CTSU Multiple Valid Clock Control                                */
                __IOM uint32_t MCA1 : 1; /*!< [17..17] CTSU Multiple Valid Clock Control                                */
                __IOM uint32_t MCA2 : 1; /*!< [18..18] CTSU Multiple Valid Clock Control                                */
                __IOM uint32_t MCA3 : 1; /*!< [19..19] CTSU Multiple Valid Clock Control                                */
                uint32_t            : 12;
            } CTSUMCH_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUMCHL;    /*!< (@ 0x00000008) CTSU Measurement Channel Register                          */

                struct
                {
                    __IOM uint8_t CTSUMCH0; /*!< (@ 0x00000008) CTSU Measurement Channel Register                          */
                    __IOM uint8_t CTSUMCH1; /*!< (@ 0x00000009) CTSU Measurement Channel Register                          */
                };
            };

            union
            {
                __IOM uint16_t CTSUMCHH; /*!< (@ 0x0000000A) CTSU Measurement Channel Register                          */
                __IOM uint8_t  CTSUMFAF; /*!< (@ 0x0000000A) CTSU Measurement Channel Register                          */
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCHACA;      /*!< (@ 0x0000000C) CTSU Channel Enable Control Register A                     */

            struct
            {
                __IOM uint32_t CHAC00 : 1; /*!< [0..0] CTSU Channel Enable Control A                                      */
                uint32_t              : 1;
                __IOM uint32_t CHAC02 : 1; /*!< [2..2] CTSU Channel Enable Control A                                      */
                uint32_t              : 1;
                __IOM uint32_t CHAC04 : 1; /*!< [4..4] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC05 : 1; /*!< [5..5] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC06 : 1; /*!< [6..6] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC07 : 1; /*!< [7..7] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC08 : 1; /*!< [8..8] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC09 : 1; /*!< [9..9] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC10 : 1; /*!< [10..10] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC11 : 1; /*!< [11..11] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC12 : 1; /*!< [12..12] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC13 : 1; /*!< [13..13] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC14 : 1; /*!< [14..14] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC15 : 1; /*!< [15..15] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC16 : 1; /*!< [16..16] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC17 : 1; /*!< [17..17] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC18 : 1; /*!< [18..18] CTSU Channel Enable Control A                                    */
                uint32_t              : 2;
                __IOM uint32_t CHAC21 : 1; /*!< [21..21] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC22 : 1; /*!< [22..22] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC23 : 1; /*!< [23..23] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC24 : 1; /*!< [24..24] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC25 : 1; /*!< [25..25] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC26 : 1; /*!< [26..26] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC27 : 1; /*!< [27..27] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC28 : 1; /*!< [28..28] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC29 : 1; /*!< [29..29] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC30 : 1; /*!< [30..30] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC31 : 1; /*!< [31..31] CTSU Channel Enable Control A                                    */
            } CTSUCHACA_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUCHACAL;   /*!< (@ 0x0000000C) CTSU Channel Enable Control Register A                     */

                struct
                {
                    __IOM uint8_t CTSUCHAC0; /*!< (@ 0x0000000C) CTSU Channel Enable Control Register A                     */
                    __IOM uint8_t CTSUCHAC1; /*!< (@ 0x0000000D) CTSU Channel Enable Control Register A                     */
                };
            };

            union
            {
                __IOM uint16_t CTSUCHACAH;   /*!< (@ 0x0000000E) CTSU Channel Enable Control Register A                     */

                struct
                {
                    __IOM uint8_t CTSUCHAC2; /*!< (@ 0x0000000E) CTSU Channel Enable Control Register A                     */
                    __IOM uint8_t CTSUCHAC3; /*!< (@ 0x0000000F) CTSU Channel Enable Control Register A                     */
                };
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCHACB;      /*!< (@ 0x00000010) CTSU Channel Enable Control Register B                     */

            struct
            {
                __IOM uint32_t CHAC32 : 1; /*!< [0..0] CTSU Channel Enable Control B                                      */
                __IOM uint32_t CHAC33 : 1; /*!< [1..1] CTSU Channel Enable Control B                                      */
                __IOM uint32_t CHAC34 : 1; /*!< [2..2] CTSU Channel Enable Control B                                      */
                __IOM uint32_t CHAC35 : 1; /*!< [3..3] CTSU Channel Enable Control B                                      */
                uint32_t              : 28;
            } CTSUCHACB_b;
        };
        __IOM uint16_t CTSUCHACBL;         /*!< (@ 0x00000010) CTSU Channel Enable Control Register B                     */
        __IOM uint8_t  CTSUCHAC4;          /*!< (@ 0x00000010) CTSU Channel Enable Control Register B                     */
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCHTRCA;      /*!< (@ 0x00000014) CTSU Channel Transmit/Receive Control Register
                                             *                  A                                                          */

            struct
            {
                __IOM uint32_t CHTRC   : 1; /*!< [0..0] CTSU Channel Transmit/Receive Control A                            */
                uint32_t               : 1;
                __IOM uint32_t CHTRC02 : 1; /*!< [2..2] CTSU Channel Transmit/Receive Control A                            */
                uint32_t               : 1;
                __IOM uint32_t CHTRC04 : 1; /*!< [4..4] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC05 : 1; /*!< [5..5] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC06 : 1; /*!< [6..6] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC07 : 1; /*!< [7..7] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC08 : 1; /*!< [8..8] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC09 : 1; /*!< [9..9] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC10 : 1; /*!< [10..10] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC11 : 1; /*!< [11..11] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC12 : 1; /*!< [12..12] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC13 : 1; /*!< [13..13] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC14 : 1; /*!< [14..14] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC15 : 1; /*!< [15..15] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC16 : 1; /*!< [16..16] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC17 : 1; /*!< [17..17] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC18 : 1; /*!< [18..18] CTSU Channel Transmit/Receive Control A                          */
                uint32_t               : 2;
                __IOM uint32_t CHTRC21 : 1; /*!< [21..21] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC22 : 1; /*!< [22..22] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC23 : 1; /*!< [23..23] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC24 : 1; /*!< [24..24] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC25 : 1; /*!< [25..25] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC26 : 1; /*!< [26..26] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC27 : 1; /*!< [27..27] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC28 : 1; /*!< [28..28] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC29 : 1; /*!< [29..29] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC30 : 1; /*!< [30..30] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC31 : 1; /*!< [31..31] CTSU Channel Transmit/Receive Control A                          */
            } CTSUCHTRCA_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUCHTRCAL;   /*!< (@ 0x00000014) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */

                struct
                {
                    __IOM uint8_t CTSUCHTRC0; /*!< (@ 0x00000014) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */
                    __IOM uint8_t CTSUCHTRC1; /*!< (@ 0x00000015) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */
                };
            };

            union
            {
                __IOM uint16_t CTSUCHTRCAH;   /*!< (@ 0x00000016) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */

                struct
                {
                    __IOM uint8_t CTSUCHTRC2; /*!< (@ 0x00000016) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */
                    __IOM uint8_t CTSUCHTRC3; /*!< (@ 0x00000017) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */
                };
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCHTRCB;      /*!< (@ 0x00000018) CTSU Channel Transmit/Receive Control Register
                                             *                  B                                                          */

            struct
            {
                __IOM uint32_t CHTRC32 : 1; /*!< [0..0] CTSU Channel Transmit/Receive Control B                            */
                __IOM uint32_t CHTRC33 : 1; /*!< [1..1] CTSU Channel Transmit/Receive Control B                            */
                __IOM uint32_t CHTRC34 : 1; /*!< [2..2] CTSU Channel Transmit/Receive Control B                            */
                __IOM uint32_t CHTRC35 : 1; /*!< [3..3] CTSU Channel Transmit/Receive Control B                            */
                uint32_t               : 28;
            } CTSUCHTRCB_b;
        };
        __IOM uint16_t CTSUCHTRCBL;         /*!< (@ 0x00000018) CTSU Channel Transmit/Receive Control Register
                                             *                  B                                                          */
        __IOM uint8_t CTSUCHTRC4;           /*!< (@ 0x00000018) CTSU Channel Transmit/Receive Control Register
                                             *                  B                                                          */
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUSR;          /*!< (@ 0x0000001C) CTSU Status Register                                       */

            struct
            {
                __IOM uint32_t MFC     : 2; /*!< [1..0] CTSU Multi-clock Counter                                           */
                uint32_t               : 3;
                __OM uint32_t ICOMPRST : 1; /*!< [5..5] CTSU CTSUICOMP1 Flag Reset                                         */
                __IM uint32_t ICOMP1   : 1; /*!< [6..6] CTSU Sense Current Error Monitor                                   */
                __IM uint32_t ICOMP0   : 1; /*!< [7..7] TSCAP Voltage Error Monitor                                        */
                __IM uint32_t STC      : 3; /*!< [10..8] CTSU Measurement Status Counter                                   */
                uint32_t               : 1;
                __IM uint32_t  DTSR    : 1; /*!< [12..12] CTSU Data Transfer Status Flag                                   */
                __IOM uint32_t SENSOVF : 1; /*!< [13..13] CTSU Sensor Counter Overflow Flag                                */
                __IOM uint32_t SUOVF   : 1; /*!< [14..14] CTSU SUCLK Counter Overflow Flag                                 */
                __IM uint32_t  PS      : 1; /*!< [15..15] CTSU Mutual Capacitance Status Flag                              */
                __IOM uint32_t CFCRDCH : 6; /*!< [21..16] CTSU CFC Read Channel Select                                     */
                uint32_t               : 10;
            } CTSUSR_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUSRL;    /*!< (@ 0x0000001C) CTSU Status Register                                       */

                struct
                {
                    __IOM uint8_t CTSUSR0; /*!< (@ 0x0000001C) CTSU Status Register                                       */
                    __IOM uint8_t CTSUST;  /*!< (@ 0x0000001D) CTSU Status Register                                       */
                };
            };

            union
            {
                __IOM uint16_t CTSUSRH; /*!< (@ 0x0000001E) CTSU Status Register                                       */
                __IOM uint8_t  CTSUSR2; /*!< (@ 0x0000001E) CTSU Status Register                                       */
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUSO;         /*!< (@ 0x00000020) CTSU Sensor Offset Register                                */

            struct
            {
                __IOM uint32_t SO    : 10; /*!< [9..0] CTSU Sensor Offset Adjustment                                      */
                __IOM uint32_t SNUM  : 8;  /*!< [17..10] CTSU Measurement Count Setting                                   */
                uint32_t             : 2;
                __IOM uint32_t SSDIV : 4;  /*!< [23..20] Spread Spectrum Frequency                                        */
                __IOM uint32_t SDPA  : 8;  /*!< [31..24] CTSU Base Clock Setting                                          */
            } CTSUSO_b;
        };

        struct
        {
            __IOM uint16_t CTSUSO0;    /*!< (@ 0x00000020) CTSU Sensor Offset Register                                */
            __IOM uint16_t CTSUSO1;    /*!< (@ 0x00000022) CTSU Sensor Offset Register                                */
        };
    };

    union
    {
        union
        {
            __IM uint32_t CTSUSCNT;         /*!< (@ 0x00000024) CTSU Sensor Counter Register                               */

            struct
            {
                __IM uint32_t SENSCNT : 16; /*!< [15..0] CTSU Sensor Counter                                               */
                __IM uint32_t SUCKCNT : 16; /*!< [31..16] CTSU SUCLK Counter                                               */
            } CTSUSCNT_b;
        };
        __IM uint16_t CTSUSC;               /*!< (@ 0x00000024) CTSU Sensor Counter Register                               */
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCALIB;  /*!< (@ 0x00000028) CTSU Calibration Register                                  */

            struct
            {
                uint32_t                : 2;
                __IOM uint32_t TSOD     : 1; /*!< [2..2] TS Pins Fixed Output                                               */
                __IOM uint32_t DRV      : 1; /*!< [3..3] Power Supply Calibration Select                                    */
                __IOM uint32_t CLKSEL   : 2; /*!< [5..4] Observation Clock Select                                           */
                __IOM uint32_t SUCLKEN  : 1; /*!< [6..6] SUCLK Forced Oscillation Control                                   */
                __IOM uint32_t TSOC     : 1; /*!< [7..7] Switched Capacitor Operation Calibration Select Bit                */
                __IOM uint32_t CNTRDSEL : 1; /*!< [8..8] Read Count Select of Sensor Counter                                */
                __IOM uint32_t IOC      : 1; /*!< [9..9] TS Pin Fixed Output Value Set                                      */
                __IOM uint32_t CFCRDMD  : 1; /*!< [10..10] CFC Counter Read Mode Select                                     */
                __IOM uint32_t DCOFF    : 1; /*!< [11..11] Down Converter Control                                           */
                uint32_t                : 4;
                __IOM uint32_t CFCSEL   : 6; /*!< [21..16] Observation CFC Clock Select                                     */
                __IOM uint32_t CFCMODE  : 1; /*!< [22..22] CFC Oscillator Calibration Mode Select                           */
                uint32_t                : 1;
                __IOM uint32_t DACMSEL  : 1; /*!< [24..24] Current Offset DAC Current Matrix Calibration Select             */
                __IOM uint32_t DACCARRY : 1; /*!< [25..25] Offset Current Adjustment for Calibration                        */
                __IOM uint32_t SUMSEL   : 1; /*!< [26..26] Current Control Oscillator Input Current Matrix Calibration
                                              *   Select                                                                    */
                __IOM uint32_t SUCARRY : 1;  /*!< [27..27] Current Control Oscillator Input Current Adjustment
                                              *   for SUCLK                                                                 */
                __IOM uint32_t DACCLK : 1;   /*!< [28..28] Modulation Clock Select for Offset Current Circuits              */
                __IOM uint32_t CCOCLK : 1;   /*!< [29..29] Modulation Clock Select for Current Controlled Oscillator
                                              *   Input Current of SUCLK                                                    */
                __IOM uint32_t CCOCALIB : 1; /*!< [30..30] Calibration Selection of Current Controlled Oscillator
                                              *   for Measurement                                                           */
                __IOM uint32_t TXREV : 1;    /*!< [31..31] Transmit Pin Inverted Output                                     */
            } CTSUCALIB_b;
        };

        struct
        {
            __IOM uint16_t CTSUDBGR0;  /*!< (@ 0x00000028) CTSU Calibration Register                                  */
            __IOM uint16_t CTSUDBGR1;  /*!< (@ 0x0000002A) CTSU Calibration Register                                  */
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUSUCLKA;       /*!< (@ 0x0000002C) CTSU Sensor Unit Clock Control Register A                  */

            struct
            {
                __IOM uint32_t SUADJ0   : 8; /*!< [7..0] CTSU SUCLK Frequency Adjustment                                    */
                __IOM uint32_t SUMULTI0 : 8; /*!< [15..8] CTSU SUCLK Multiplier Rate Setting                                */
                __IOM uint32_t SUADJ1   : 8; /*!< [23..16] CTSU SUCLK Frequency Adjustment                                  */
                __IOM uint32_t SUMULTI1 : 8; /*!< [31..24] CTSU SUCLK Multiplier Rate Setting                               */
            } CTSUSUCLKA_b;
        };

        struct
        {
            __IOM uint16_t CTSUSUCLK0; /*!< (@ 0x0000002C) CTSU Sensor Unit Clock Control Register A                  */
            __IOM uint16_t CTSUSUCLK1; /*!< (@ 0x0000002E) CTSU Sensor Unit Clock Control Register A                  */
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUSUCLKB;       /*!< (@ 0x00000030) CTSU Sensor Unit Clock Control Register B                  */

            struct
            {
                __IOM uint32_t SUADJ2   : 8; /*!< [7..0] CTSU SUCLK Frequency Adjustment                                    */
                __IOM uint32_t SUMULTI2 : 8; /*!< [15..8] CTSU SUCLK Multiplier Rate Setting                                */
                __IOM uint32_t SUADJ3   : 8; /*!< [23..16] CTSU SUCLK Frequency Adjustment                                  */
                __IOM uint32_t SUMULTI3 : 8; /*!< [31..24] CTSU SUCLK Multiplier Rate Setting                               */
            } CTSUSUCLKB_b;
        };

        struct
        {
            __IOM uint16_t CTSUSUCLK2; /*!< (@ 0x00000030) CTSU Sensor Unit Clock Control Register B                  */
            __IOM uint16_t CTSUSUCLK3; /*!< (@ 0x00000032) CTSU Sensor Unit Clock Control Register B                  */
        };
    };

    union
    {
        union
        {
            __IM uint32_t CTSUCFCCNT;      /*!< (@ 0x00000034) CTSU CFC Counter Register                                  */

            struct
            {
                __IM uint32_t CFCCNT : 16; /*!< [15..0] CTSU CFC Counter                                                  */
                uint32_t             : 16;
            } CTSUCFCCNT_b;
        };
        __IM uint16_t CTSUCFCCNTL;         /*!< (@ 0x00000034) CTSU CFC Counter Register                                  */
    };
} R_CTSU2_Type;                            /*!< Size = 56 (0x38)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_DAC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief D/A Converter (R_DAC)
 */

typedef struct                         /*!< (@ 0x4005E000) R_DAC Structure                                            */
{
    union
    {
        __IOM uint16_t DADR[2];        /*!< (@ 0x00000000) D/A Data Register                                          */

        struct
        {
            __IOM uint16_t DADR : 16;  /*!< [15..0] D/A Data RegisterNOTE: When DADPR.DPSEL = 0, the high-order
                                        *   4 bits are fixed to 0: right justified format. When DADPR.DPSEL
                                        *   = 1, the low-order 4 bits are fixed to 0: left justified
                                        *   format.                                                                   */
        } DADR_b[2];
    };

    union
    {
        __IOM uint8_t DACR;            /*!< (@ 0x00000004) D/A Control Register                                       */

        struct
        {
            uint8_t             : 5;
            __IOM uint8_t DAE   : 1;   /*!< [5..5] D/A Enable                                                         */
            __IOM uint8_t DAOE0 : 1;   /*!< [6..6] D/A Output Enable 0                                                */
            __IOM uint8_t DAOE1 : 1;   /*!< [7..7] D/A Output Enable 0                                                */
        } DACR_b;
    };

    union
    {
        __IOM uint8_t DADPR;           /*!< (@ 0x00000005) DADR0 Format Select Register                               */

        struct
        {
            uint8_t             : 7;
            __IOM uint8_t DPSEL : 1;   /*!< [7..7] DADRm Format Select                                                */
        } DADPR_b;
    };

    union
    {
        __IOM uint8_t DAADSCR;         /*!< (@ 0x00000006) D/A-A/D Synchronous Start Control Register                 */

        struct
        {
            uint8_t              : 7;
            __IOM uint8_t DAADST : 1;  /*!< [7..7] D/A-A/D Synchronous Conversion                                     */
        } DAADSCR_b;
    };

    union
    {
        __IOM uint8_t DAVREFCR;        /*!< (@ 0x00000007) D/A VREF Control Register                                  */

        struct
        {
            __IOM uint8_t REF : 3;     /*!< [2..0] D/A Reference Voltage Select                                       */
            uint8_t           : 5;
        } DAVREFCR_b;
    };

    union
    {
        __IOM uint8_t DAAMPCR;         /*!< (@ 0x00000008) D/A Output Amplifier Control Register                      */

        struct
        {
            uint8_t              : 6;
            __IOM uint8_t DAAMP0 : 1;  /*!< [6..6] Amplifier Control                                                  */
            __IOM uint8_t DAAMP1 : 1;  /*!< [7..7] Amplifier Control                                                  */
        } DAAMPCR_b;
    };

    union
    {
        __IOM uint8_t DAPC;            /*!< (@ 0x00000009) D/A Switch Charge Pump Control Register                    */

        struct
        {
            __IOM uint8_t PUMPEN : 1;  /*!< [0..0] Charge Pump Enable                                                 */
            uint8_t              : 7;
        } DAPC_b;
    };
    __IM uint16_t RESERVED[9];

    union
    {
        __IOM uint8_t DAASWCR;         /*!< (@ 0x0000001C) D/A Amplifier Stabilization Wait Control Register          */

        struct
        {
            uint8_t              : 6;
            __IOM uint8_t DAASW0 : 1;  /*!< [6..6] Set the DAASW0 bit to 1 in the initialization procedure
                                        *   to wait for stabilization of the output amplifier of D/A
                                        *   channel 0. When DAASW0 is set to 1, D/A conversion operates,
                                        *   but the conversion result D/A is not output from channel
                                        *   0. When the DAASW0 bit is 0, the stabilization wait time
                                        *   stops, and the D/A conversion result of channel 0 is output
                                        *   through the output amplifier.                                             */
            __IOM uint8_t DAASW1 : 1;  /*!< [7..7] Set the DAASW1 bit to 1 in the initialization procedure
                                        *   to wait for stabilization of the output amplifier of D/A
                                        *   channel 1. When DAASW1 is set to 1, D/A conversion operates,
                                        *   but the conversion result D/A is not output from channel
                                        *   1. When the DAASW1 bit is 0, the stabilization wait time
                                        *   stops, and the D/A conversion result of channel 1 is output
                                        *   through the output amplifier.                                             */
        } DAASWCR_b;
    };
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2[2129];

    union
    {
        __IOM uint8_t DAADUSR;         /*!< (@ 0x000010C0) D/A A/D Synchronous Unit Select Register                   */

        struct
        {
            uint8_t                : 6;
            __IOM uint8_t AMADSEL1 : 1; /*!< [6..6] The DAADUSR register selects the target ADC12 unit for
                                         *   D/A and A/D synchronous conversions. Set bit [1] to 1 to
                                         *   select unit 1 as the target synchronous unit for the MCU.
                                         *   When setting the DAADSCR.DAADST bit to 1 for synchronous
                                         *   conversions, select the target unit in this register in
                                         *   advance. Only set the DAADUSR register while the ADCSR.ADST
                                         *   bit of the ADC12 is set to 0 and the DAADSCR.DAADST bit
                                         *   is set to 0.                                                              */
            uint8_t : 1;
        } DAADUSR_b;
    };
    __IM uint8_t  RESERVED3;
    __IM uint16_t RESERVED4;
} R_DAC_Type;                          /*!< Size = 4292 (0x10c4)                                                      */

/* =========================================================================================================================== */
/* ================                                          R_DAC8                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief 8-Bit D/A Converter (R_DAC8)
 */

typedef struct                         /*!< (@ 0x4009E000) R_DAC8 Structure                                           */
{
    union
    {
        __IOM uint8_t DACS[2];         /*!< (@ 0x00000000) D/A Conversion Value Setting Register [0..1]               */

        struct
        {
            __IOM uint8_t DACS : 8;    /*!< [7..0] DACS D/A conversion store data                                     */
        } DACS_b[2];
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint8_t DAM;             /*!< (@ 0x00000003) D/A Converter Mode Register                                */

        struct
        {
            __IOM uint8_t DAMD0 : 1;   /*!< [0..0] D/A operation mode select 0                                        */
            __IOM uint8_t DAMD1 : 1;   /*!< [1..1] D/A operation mode select 1                                        */
            uint8_t             : 2;
            __IOM uint8_t DACE0 : 1;   /*!< [4..4] D/A operation enable 0                                             */
            __IOM uint8_t DACE1 : 1;   /*!< [5..5] D/A operation enable 1                                             */
            uint8_t             : 2;
        } DAM_b;
    };
    __IM uint8_t RESERVED1[2];

    union
    {
        __IOM uint8_t DACADSCR;        /*!< (@ 0x00000006) D/A A/D Synchronous Start Control Register                 */

        struct
        {
            __IOM uint8_t DACADST : 1; /*!< [0..0] D/A A/D Synchronous Conversion                                     */
            uint8_t               : 7;
        } DACADSCR_b;
    };

    union
    {
        __IOM uint8_t DACPC;           /*!< (@ 0x00000007) D/A SW Charge Pump Control Register                        */

        struct
        {
            __IOM uint8_t PUMPEN : 1;  /*!< [0..0] Charge pump enable                                                 */
            uint8_t              : 7;
        } DACPC_b;
    };
} R_DAC8_Type;                         /*!< Size = 8 (0x8)                                                            */

/* =========================================================================================================================== */
/* ================                                          R_DALI0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Digital Addressable Lighting Interface (R_DALI0)
 */

typedef struct                         /*!< (@ 0x4008F000) R_DALI0 Structure                                          */
{
    union
    {
        __IOM uint16_t BTVTHR1;        /*!< (@ 0x00000000) DALI Bit Timing Violation Threshold Register
                                        *                  1                                                          */

        struct
        {
            __IOM uint16_t BTV1 : 7;   /*!< [6..0] Bit Timing Violation Threshold 1Specifies the bit timing
                                        *   violation threshold value 1.Note 1. These bits must be
                                        *   modified when the DALI0.CTR1.RE bit is 0 and the DALI0.CTR1.TE
                                        *   bit is 0.                                                                 */
            uint16_t            : 1;
            __IOM uint16_t BTV2 : 8;   /*!< [15..8] Bit Timing Violation Threshold 2Specifies the bit timing
                                        *   violation threshold value 2.Note 1. These bits must be
                                        *   modified when the DALI0.CTR1.RE bit is 0 and the DALI0.CTR1.TE
                                        *   bit is 0.                                                                 */
        } BTVTHR1_b;
    };

    union
    {
        __IOM uint16_t BTVTHR2;        /*!< (@ 0x00000002) DALI Bit Timing Violation Threshold Register
                                        *                  2                                                          */

        struct
        {
            __IOM uint16_t BTV3 : 8;   /*!< [7..0] Bit Timing Violation Threshold 3Specifies the bit timing
                                        *   violation threshold value 3.Note 1. These bits must be
                                        *   modified when the DALI0.CTR1.RE bit is 0 and the DALI0.CTR1.TE
                                        *   bit is 0.                                                                 */
            __IOM uint16_t BTV4 : 8;   /*!< [15..8] Bit Timing Violation Threshold 4Specifies the bit timing
                                        *   violation threshold value 4.Note 1. These bits must be
                                        *   modified when the DALI0.CTR1.RE bit is 0 and the DALI0.CTR1.TE
                                        *   bit is 0.                                                                 */
        } BTVTHR2_b;
    };

    union
    {
        __IOM uint16_t BTVTHR3;        /*!< (@ 0x00000004) DALI Bit Timing Violation Threshold Register
                                        *                  3                                                          */

        struct
        {
            __IOM uint16_t BTV5 : 8;   /*!< [7..0] Bit Timing Violation Threshold 5Specifies the bit timing
                                        *   violation threshold value 5.Note 1. These bits must be
                                        *   modified when the DALI0.CTR1.RE bit is 0 and the DALI0.CTR1.TE
                                        *   bit is 0.                                                                 */
            uint16_t : 8;
        } BTVTHR3_b;
    };

    union
    {
        __IOM uint16_t BTVTHR4;        /*!< (@ 0x00000006) DALI Bit Timing Violation Threshold Register
                                        *                  4                                                          */

        struct
        {
            __IOM uint16_t BTV6 : 9;   /*!< [8..0] Bit Timing Violation Threshold 6Specifies the bit timing
                                        *   violation threshold value 6.Note 1. These bits must be
                                        *   modified when the DALI0.CTR1.RE bit is 0 and the DALI0.CTR1.TE
                                        *   bit is 0.                                                                 */
            uint16_t : 7;
        } BTVTHR4_b;
    };

    union
    {
        __IOM uint16_t COLTHR1;        /*!< (@ 0x00000008) DALI Collision Threshold Register 1                        */

        struct
        {
            __IOM uint16_t COL1 : 6;   /*!< [5..0] Collision Threshold 1Specifies the collision threshold
                                        *   value 1.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
            uint16_t            : 2;
            __IOM uint16_t COL2 : 6;   /*!< [13..8] Collision Threshold 2Specifies the collision threshold
                                        *   value 2.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
            uint16_t : 2;
        } COLTHR1_b;
    };

    union
    {
        __IOM uint16_t COLTHR2;        /*!< (@ 0x0000000A) DALI Collision Threshold Register 2                        */

        struct
        {
            __IOM uint16_t COL3 : 7;   /*!< [6..0] Collision Threshold 3Specifies the collision threshold
                                        *   value 3.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
            uint16_t            : 1;
            __IOM uint16_t COL4 : 7;   /*!< [14..8] Collision Threshold 4Specifies the collision threshold
                                        *   value 4.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
            uint16_t : 1;
        } COLTHR2_b;
    };

    union
    {
        __IOM uint16_t COLTHR3;        /*!< (@ 0x0000000C) DALI Collision Threshold Register 3                        */

        struct
        {
            __IOM uint16_t COL5 : 7;   /*!< [6..0] Collision Threshold 5Specifies the collision threshold
                                        *   value 5.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
            uint16_t            : 1;
            __IOM uint16_t COL6 : 7;   /*!< [14..8] Collision Threshold 6Specifies the collision threshold
                                        *   value 6.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
            uint16_t : 1;
        } COLTHR3_b;
    };

    union
    {
        __IOM uint16_t COLTHR4;        /*!< (@ 0x0000000E) DALI Collision Threshold Register 4                        */

        struct
        {
            __IOM uint16_t COL7 : 8;   /*!< [7..0] Collision Threshold 7Specifies the collision threshold
                                        *   value 7.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
            __IOM uint16_t COL8 : 8;   /*!< [15..8] Collision Threshold 8Specifies the collision threshold
                                        *   value 8.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
        } COLTHR4_b;
    };

    union
    {
        __IOM uint16_t COLTHR5;        /*!< (@ 0x00000010) DALI Collision Threshold Register 5                        */

        struct
        {
            __IOM uint16_t COL9 : 8;   /*!< [7..0] Collision Threshold 9Specifies the collision threshold
                                        *   value 9.Note 1. These bits must be modified when the DALI0.CTR1.RE
                                        *   bit is 0 and the DALI0.CTR1.TE bit is 0.                                  */
            uint16_t : 8;
        } COLTHR5_b;
    };

    union
    {
        __IOM uint16_t CNFR1;          /*!< (@ 0x00000012) DALI Configuration Register 1                              */

        struct
        {
            __IOM uint16_t BR  : 8;    /*!< [7..0] Clock SelectBit rate setting example is shown in Table             */
            __IOM uint16_t CKS : 2;    /*!< [9..8] Clock Select                                                       */
            uint16_t           : 2;
            __IOM uint16_t CHL : 3;    /*!< [14..12] Character Length                                                 */
            uint16_t           : 1;
        } CNFR1_b;
    };

    union
    {
        __IOM uint16_t CNFR2;          /*!< (@ 0x00000014) DALI Configuration Register 2                              */

        struct
        {
            __IOM uint16_t BTVE : 1;   /*!< [0..0] Bit Timing Violation EnableNote: The bit must be modified
                                        *   only when the DALI0.STR1.BBF bit is 0.                                    */
            __IOM uint16_t BTVM : 1;   /*!< [1..1] Bit Timing Violation ModeNote: The bit must be modified
                                        *   only when the DALI0.STR1.BBF bit is 0.                                    */
            __IOM uint16_t SGA : 1;    /*!< [2..2] Save an Edge of Gray Area ModeNote: The bit must be modified
                                        *   only when the DALI0.STR1.BBF bit is 0.                                    */
            __IOM uint16_t TXWE : 1;   /*!< [3..3] DTX Width Modulation EnableNote: The bit must be modified
                                        *   only when the DALI0.STR1.BBF bit is 0.                                    */
            __IOM uint16_t CDE : 1;    /*!< [4..4] Collision Detect EnableNote: The bit must be modified
                                        *   only when the DALI0.STR1.BBF bit is 0.                                    */
            __IOM uint16_t CDM0 : 1;   /*!< [5..5] Collision Detect ModeNote: The bit must be modified only
                                        *   when the DALI0.STR1.BBF bit is 0.                                         */
            uint16_t : 10;
        } CNFR2_b;
    };

    union
    {
        __IOM uint16_t TXWR1;          /*!< (@ 0x00000016) DALI DTX Width Register 1                                  */

        struct
        {
            __IOM uint16_t TXLW : 7;   /*!< [6..0] DTX Low WidthDTX0 pin low level width                              */
            uint16_t            : 9;
        } TXWR1_b;
    };
    __IM uint16_t RESERVED[3];

    union
    {
        __IOM uint16_t TDR1H;          /*!< (@ 0x0000001E) DALI Transmit Data Register 1H                             */

        struct
        {
            __IOM uint16_t DTDR : 16;  /*!< [15..0] Upper 16-bit DALI transmit data                                   */
        } TDR1H_b;
    };

    union
    {
        __IOM uint16_t TDR1L;          /*!< (@ 0x00000020) DALI Transmit Data Register 1L                             */

        struct
        {
            __IOM uint16_t DTDR : 16;  /*!< [15..0] Lower 16-bit DALI transmit data                                   */
        } TDR1L_b;
    };

    union
    {
        __OM uint16_t TRSTR1;          /*!< (@ 0x00000022) DALI Transmit Control Register 1                           */

        struct
        {
            __OM uint16_t TRST : 1;    /*!< [0..0] Transmission Start Trigger                                         */
            uint16_t           : 15;
        } TRSTR1_b;
    };
    __IM uint16_t RESERVED1;

    union
    {
        __IOM uint16_t CTR1;           /*!< (@ 0x00000026) DALI Control Register 1                                    */

        struct
        {
            __IOM uint16_t TE   : 1;   /*!< [0..0] Transmit Enabling                                                  */
            __IOM uint16_t RE   : 1;   /*!< [1..1] Receive Enabling                                                   */
            uint16_t            : 6;
            __IOM uint16_t SDIE : 1;   /*!< [8..8] DALI_SDI Output Enabling                                           */
            __IOM uint16_t DEIE : 1;   /*!< [9..9] DALI_DEI Output Enabling                                           */
            __IOM uint16_t CLIE : 1;   /*!< [10..10] DALI_CLI Output Enabling                                         */
            __IOM uint16_t BPIE : 1;   /*!< [11..11] DALI_BPI Output Enabling                                         */
            __IOM uint16_t FEIE : 1;   /*!< [12..12] DALI_FEI Output Enabling                                         */
            uint16_t            : 3;
        } CTR1_b;
    };

    union
    {
        __IOM uint16_t TXDCTR1;        /*!< (@ 0x00000028) DALI DTX Control Register 1                                */

        struct
        {
            __IOM uint16_t TXAS : 1;   /*!< [0..0] DTX Assert LevelNote 1. The bit must be modified only
                                        *   when the DALI0.CTR1.TE bit is 0.                                          */
            __IOM uint16_t TXASE : 1;  /*!< [1..1] DTX Assert EnablingNote 1. The bit must be modified only
                                        *   when the DALI0.CTR1.TE bit is 0.                                          */
            uint16_t : 14;
        } TXDCTR1_b;
    };
    __IM uint16_t RESERVED2[2];

    union
    {
        __IM uint16_t RDR1H;           /*!< (@ 0x0000002E) DALI Reception Data Register 1H                            */

        struct
        {
            __IM uint16_t DRDR : 16;   /*!< [15..0] Upper 16-bit of DALI receive data                                 */
        } RDR1H_b;
    };

    union
    {
        __IM uint16_t RDR1L;           /*!< (@ 0x00000030) DALI Reception Data Register 1L                            */

        struct
        {
            __IM uint16_t DRDR : 16;   /*!< [15..0] Lower 16-bit of DALI receive data                                 */
        } RDR1L_b;
    };

    union
    {
        __IM uint16_t STR1;            /*!< (@ 0x00000032) DALI Status Register 1                                     */

        struct
        {
            __IM uint16_t MFEF  : 1;   /*!< [0..0] Manchester Flaming Error Flag                                      */
            __IM uint16_t OVF   : 1;   /*!< [1..1] Overrun Error Flag                                                 */
            __IM uint16_t BTVF  : 1;   /*!< [2..2] Bit Timing Violation Flag                                          */
            __IM uint16_t RDRF  : 1;   /*!< [3..3] Receive Data Register Full Flag                                    */
            __IM uint16_t TENDF : 1;   /*!< [4..4] Transmit End Flag                                                  */
            __IM uint16_t BBF   : 1;   /*!< [5..5] Bus BUSY Flag                                                      */
            __IM uint16_t BPDF  : 1;   /*!< [6..6] Bus Power Down Flag                                                */
            __IM uint16_t O32F  : 1;   /*!< [7..7] Over 32-Bit Data Reception Flag                                    */
            __IM uint16_t CDF   : 1;   /*!< [8..8] Collision Detect Flag                                              */
            __IM uint16_t DAF   : 1;   /*!< [9..9] Destroy Area Flag                                                  */
            __IM uint16_t RDBL  : 6;   /*!< [15..10] Receive Data Bit LengthThese bits store the bit length
                                        *   for data received successfully                                            */
        } STR1_b;
    };
    __IM uint16_t RESERVED3;

    union
    {
        __IM uint16_t COLR1;           /*!< (@ 0x00000036) DALI Collision Register 1                                  */

        struct
        {
            __IM uint16_t CFTF2  : 4;  /*!< [3..0] Collision Detect Timing Flag 2                                     */
            __IM uint16_t CDTF1  : 1;  /*!< [4..4] Collision Detect Timing Flag 1                                     */
            uint16_t             : 5;
            __IM uint16_t CLDAF  : 1;  /*!< [10..10] Collision Last Destroy Area Flag                                 */
            __IM uint16_t RXDMON : 1;  /*!< [11..11] DRX MonitorThis bit monitors the DRX0 pin value after
                                        *   the DRX0 pin is synchronized                                              */
            __IM uint16_t RXDCEG : 1;  /*!< [12..12] DRX Collision Edge                                               */
            __IM uint16_t TXDCV  : 1;  /*!< [13..13] DTX Collision Value                                              */
            uint16_t             : 2;
        } COLR1_b;
    };
    __IM uint16_t RESERVED4;

    union
    {
        __OM uint16_t FECR1;           /*!< (@ 0x0000003A) DALI Flag Error Clear Register 1                           */

        struct
        {
            __OM uint16_t MFEFC  : 1;  /*!< [0..0] Manchester Flaming Error Flag Clear                                */
            __OM uint16_t OVFC   : 1;  /*!< [1..1] Overrun Error Flag Clear                                           */
            __OM uint16_t BTVFC  : 1;  /*!< [2..2] Bit Timing Violation Flag Clear                                    */
            __OM uint16_t RDRFC  : 1;  /*!< [3..3] Receive Data Register Full Flag Clear                              */
            __OM uint16_t TENDFC : 1;  /*!< [4..4] Transmit End Flag Clear                                            */
            __OM uint16_t BBFC   : 1;  /*!< [5..5] Bus BUSY Flag ClearNote1: Do not clear DALI0.STR1.BBF
                                        *   bit when DALI0.CTR1.TE bit or DALI0.CTR1.RE bit is 1.                     */
            __OM uint16_t BPDFC : 1;   /*!< [6..6] Bus Power Down Flag Clear                                          */
            __OM uint16_t O32FC : 1;   /*!< [7..7] Over 32-Bit Data Reception Flag Clear                              */
            __OM uint16_t CDFC  : 1;   /*!< [8..8] Collision Detect Flag Clear                                        */
            __OM uint16_t DAFC  : 1;   /*!< [9..9] Destroy Area Flag Clear                                            */
            uint16_t            : 6;
        } FECR1_b;
    };

    union
    {
        __OM uint16_t SWRR1;           /*!< (@ 0x0000003C) DALI Software Reset Register 1                             */

        struct
        {
            __OM uint16_t SWR : 1;     /*!< [0..0] Software ResetWriting 1 to this bit causes a software
                                        *   reset.                                                                    */
            uint16_t : 15;
        } SWRR1_b;
    };
} R_DALI0_Type;                        /*!< Size = 62 (0x3e)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_DEBUG                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Debug Function (R_DEBUG)
 */

typedef struct                         /*!< (@ 0x4001B000) R_DEBUG Structure                                          */
{
    union
    {
        __IM uint32_t DBGSTR;          /*!< (@ 0x00000000) Debug Status Register                                      */

        struct
        {
            uint32_t                   : 28;
            __IM uint32_t CDBGPWRUPREQ : 1; /*!< [28..28] Debug power-up request                                           */
            __IM uint32_t CDBGPWRUPACK : 1; /*!< [29..29] Debug power-up acknowledge                                       */
            uint32_t                   : 2;
        } DBGSTR_b;
    };
    __IM uint32_t RESERVED[3];

    union
    {
        __IOM uint32_t DBGSTOPCR;             /*!< (@ 0x00000010) Debug Stop Control Register                                */

        struct
        {
            __IOM uint32_t DBGSTOP_IWDT  : 1; /*!< [0..0] Mask bit for IWDT reset/interrupt                                  */
            __IOM uint32_t DBGSTOP_WDT   : 1; /*!< [1..1] Mask bit for WDT reset/interrupt                                   */
            uint32_t                     : 14;
            __IOM uint32_t DBGSTOP_LVD0  : 1; /*!< [16..16] Mask bit for LVD reset/interupt                                  */
            __IOM uint32_t DBGSTOP_LVD1  : 1; /*!< [17..17] Mask bit for LVD reset/interupt                                  */
            __IOM uint32_t DBGSTOP_LVD2  : 1; /*!< [18..18] Mask bit for LVD reset/interupt                                  */
            uint32_t                     : 5;
            __IOM uint32_t DBGSTOP_RPER  : 1; /*!< [24..24] Mask bit for SRAM parity error                                   */
            __IOM uint32_t DBGSTOP_RECCR : 1; /*!< [25..25] Mask bit for SRAM ECC error                                      */
            uint32_t                     : 5;
            __IOM uint32_t DBGSTOP_CPER  : 1; /*!< [31..31] Mask bit for Cache SRAM parity error reset/interrupt             */
        } DBGSTOPCR_b;
    };
} R_DEBUG_Type;                               /*!< Size = 20 (0x14)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_DMA                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief DMA Controller Common (R_DMA)
 */

typedef struct                         /*!< (@ 0x40005200) R_DMA Structure                                            */
{
    union
    {
        __IOM uint8_t DMAST;           /*!< (@ 0x00000000) DMAC Module Activation Register                            */

        struct
        {
            __IOM uint8_t DMST : 1;    /*!< [0..0] DMAC Operation Enable                                              */
            uint8_t            : 7;
        } DMAST_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[15];

    union
    {
        __IOM uint32_t DMECHR;          /*!< (@ 0x00000040) DMAC Error Channel Register                                */

        struct
        {
            __IM uint32_t DMECH    : 3; /*!< [2..0] DMAC Error channel                                                 */
            uint32_t               : 5;
            __IM uint32_t DMECHSAM : 1; /*!< [8..8] DMAC Error channel Security Attribution Monitor                    */
            uint32_t               : 7;
            __IOM uint32_t DMESTA  : 1; /*!< [16..16] DMAC Error Status                                                */
            uint32_t               : 15;
        } DMECHR_b;
    };
} R_DMA_Type;                           /*!< Size = 68 (0x44)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_DMAC0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief DMA Controller (R_DMAC0)
 */

typedef struct                         /*!< (@ 0x40005000) R_DMAC0 Structure                                          */
{
    union
    {
        __IOM uint32_t DMSAR;          /*!< (@ 0x00000000) DMA Source Address Register                                */

        struct
        {
            __IOM uint32_t DMSAR : 32; /*!< [31..0] Specifies the transfer source start address.                      */
        } DMSAR_b;
    };

    union
    {
        __IOM uint32_t DMDAR;          /*!< (@ 0x00000004) DMA Destination Address Register                           */

        struct
        {
            __IOM uint32_t DMDAR : 32; /*!< [31..0] Specifies the transfer destination start address.                 */
        } DMDAR_b;
    };

    union
    {
        __IOM uint32_t DMCRA;           /*!< (@ 0x00000008) DMA Transfer Count Register                                */

        struct
        {
            __IOM uint32_t DMCRAL : 16; /*!< [15..0] Lower bits of transfer count                                      */
            __IOM uint32_t DMCRAH : 10; /*!< [25..16] Upper bits of transfer count                                     */
            uint32_t              : 6;
        } DMCRA_b;
    };

    union
    {
        __IOM uint16_t DMCRB;          /*!< (@ 0x0000000C) DMA Block Transfer Count Register                          */

        struct
        {
            __IOM uint16_t DMCRB : 16; /*!< [15..0] Specifies the number of block transfer operations or
                                        *   repeat transfer operations.                                               */
        } DMCRB_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t DMTMD;          /*!< (@ 0x00000010) DMA Transfer Mode Register                                 */

        struct
        {
            __IOM uint16_t DCTG : 2;   /*!< [1..0] Transfer Request Source Select                                     */
            uint16_t            : 6;
            __IOM uint16_t SZ   : 2;   /*!< [9..8] Transfer Data Size Select                                          */
            __IOM uint16_t TKP  : 1;   /*!< [10..10] Transfer Keeping                                                 */
            uint16_t            : 1;
            __IOM uint16_t DTS  : 2;   /*!< [13..12] Repeat Area Select                                               */
            __IOM uint16_t MD   : 2;   /*!< [15..14] Transfer Mode Select                                             */
        } DMTMD_b;
    };
    __IM uint8_t RESERVED1;

    union
    {
        __IOM uint8_t DMINT;           /*!< (@ 0x00000013) DMA Interrupt Setting Register                             */

        struct
        {
            __IOM uint8_t DARIE : 1;   /*!< [0..0] Destination Address Extended Repeat Area Overflow Interrupt
                                        *   Enable                                                                    */
            __IOM uint8_t SARIE : 1;   /*!< [1..1] Source Address Extended Repeat Area Overflow Interrupt
                                        *   Enable                                                                    */
            __IOM uint8_t RPTIE : 1;   /*!< [2..2] Repeat Size End Interrupt Enable                                   */
            __IOM uint8_t ESIE  : 1;   /*!< [3..3] Transfer Escape End Interrupt Enable                               */
            __IOM uint8_t DTIE  : 1;   /*!< [4..4] Transfer End Interrupt Enable                                      */
            uint8_t             : 3;
        } DMINT_b;
    };

    union
    {
        __IOM uint16_t DMAMD;          /*!< (@ 0x00000014) DMA Address Mode Register                                  */

        struct
        {
            __IOM uint16_t DARA : 5;   /*!< [4..0] Destination Address Extended Repeat Area Specifies the
                                        *   extended repeat area on the destination address. For details
                                        *   on the settings.                                                          */
            __IOM uint16_t DADR : 1;   /*!< [5..5] Destination Address Update Select After Reload                     */
            __IOM uint16_t DM   : 2;   /*!< [7..6] Destination Address Update Mode                                    */
            __IOM uint16_t SARA : 5;   /*!< [12..8] Source Address Extended Repeat Area Specifies the extended
                                        *   repeat area on the source address. For details on the settings.           */
            __IOM uint16_t SADR : 1;   /*!< [13..13] Source Address Update Select After Reload                        */
            __IOM uint16_t SM   : 2;   /*!< [15..14] Source Address Update Mode                                       */
        } DMAMD_b;
    };
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint32_t DMOFR;          /*!< (@ 0x00000018) DMA Offset Register                                        */

        struct
        {
            __IOM uint32_t DMOFR : 32; /*!< [31..0] Specifies the offset when offset addition is selected
                                        *   as the address update mode for transfer source or destination.            */
        } DMOFR_b;
    };

    union
    {
        __IOM uint8_t DMCNT;           /*!< (@ 0x0000001C) DMA Transfer Enable Register                               */

        struct
        {
            __IOM uint8_t DTE : 1;     /*!< [0..0] DMA Transfer Enable                                                */
            uint8_t           : 7;
        } DMCNT_b;
    };

    union
    {
        __IOM uint8_t DMREQ;           /*!< (@ 0x0000001D) DMA Software Start Register                                */

        struct
        {
            __IOM uint8_t SWREQ : 1;   /*!< [0..0] DMA Software Start                                                 */
            uint8_t             : 3;
            __IOM uint8_t CLRS  : 1;   /*!< [4..4] DMA Software Start Bit Auto Clear Select                           */
            uint8_t             : 3;
        } DMREQ_b;
    };

    union
    {
        __IOM uint8_t DMSTS;            /*!< (@ 0x0000001E) DMA Status Register                                        */

        struct
        {
            __IOM uint8_t ESIF : 1;     /*!< [0..0] Transfer Escape End Interrupt Flag                                 */
            uint8_t            : 3;
            __IOM uint8_t DTIF : 1;     /*!< [4..4] Transfer End Interrupt Flag                                        */
            uint8_t            : 2;
            __IM uint8_t ACT   : 1;     /*!< [7..7] DMA Active Flag                                                    */
        } DMSTS_b;
    };
    __IM uint8_t   RESERVED3;
    __IOM uint32_t DMSRR;               /*!< (@ 0x00000020) DMA Source Reload Address Register                         */
    __IOM uint32_t DMDRR;               /*!< (@ 0x00000024) DMA Destination Reload Address Register                    */

    union
    {
        __IOM uint32_t DMSBS;           /*!< (@ 0x00000028) DMA Source Buffer Size Register                            */

        struct
        {
            __IOM uint32_t DMSBSL : 16; /*!< [15..0] Functions as data transfer counter in repeat-block transfer
                                         *   mode                                                                      */
            __IOM uint32_t DMSBSH : 16; /*!< [31..16] Specifies the repeat-area size in repeat-block transfer
                                         *   mode                                                                      */
        } DMSBS_b;
    };

    union
    {
        __IOM uint32_t DMDBS;           /*!< (@ 0x0000002C) DMA Destination Buffer Size Register                       */

        struct
        {
            __IOM uint32_t DMDBSL : 16; /*!< [15..0] Functions as data transfer counter in repeat-block transfer
                                         *   mode                                                                      */
            __IOM uint32_t DMDBSH : 16; /*!< [31..16] Specifies the repeat-area size in repeat-block transfer
                                         *   mode                                                                      */
        } DMDBS_b;
    };

    union
    {
        __IOM uint8_t DMBWR;           /*!< (@ 0x00000030) DMA Bufferable Write Enable Register                       */

        struct
        {
            __IOM uint8_t BWE : 1;     /*!< [0..0] Bufferable Write Enable                                            */
            uint8_t           : 7;
        } DMBWR_b;
    };
    __IM uint8_t  RESERVED4;
    __IM uint16_t RESERVED5;
} R_DMAC0_Type;                        /*!< Size = 52 (0x34)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_DOC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Data Operation Circuit (R_DOC)
 */

typedef struct                         /*!< (@ 0x40054100) R_DOC Structure                                            */
{
    union
    {
        __IOM uint8_t DOCR;            /*!< (@ 0x00000000) DOC Control Register                                       */

        struct
        {
            __IOM uint8_t OMS     : 2; /*!< [1..0] Operating Mode Select                                              */
            __IOM uint8_t DCSEL   : 1; /*!< [2..2] Detection Condition Select                                         */
            uint8_t               : 2;
            __IM uint8_t  DOPCF   : 1; /*!< [5..5] Data Operation Circuit Flag                                        */
            __IOM uint8_t DOPCFCL : 1; /*!< [6..6] DOPCF Clear                                                        */
            uint8_t               : 1;
        } DOCR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t DODIR;          /*!< (@ 0x00000002) DOC Data Input Register                                    */

        struct
        {
            __IOM uint16_t DODIR : 16; /*!< [15..0] 16-bit read-write register in which 16-bit data for
                                        *   use in the operations are stored.                                         */
        } DODIR_b;
    };

    union
    {
        __IOM uint16_t DODSR;          /*!< (@ 0x00000004) DOC Data Setting Register                                  */

        struct
        {
            __IOM uint16_t DODSR : 16; /*!< [15..0] This register stores 16-bit data for use as a reference
                                        *   in data comparison mode. This register also stores the
                                        *   results of operations in data addition and data subtraction
                                        *   modes.                                                                    */
        } DODSR_b;
    };
} R_DOC_Type;                          /*!< Size = 6 (0x6)                                                            */

/* =========================================================================================================================== */
/* ================                                           R_DRW                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief 2D Drawing Engine (R_DRW)
 */

typedef struct                         /*!< (@ 0x400E4000) R_DRW Structure                                            */
{
    union
    {
        union
        {
            __OM uint32_t CONTROL;               /*!< (@ 0x00000000) Geometry Control Register                                  */

            struct
            {
                __OM uint32_t LIM1ENABLE    : 1; /*!< [0..0] Enable limiter 1                                                   */
                __OM uint32_t LIM2ENABLE    : 1; /*!< [1..1] Enable limiter 2                                                   */
                __OM uint32_t LIM3ENABLE    : 1; /*!< [2..2] Enable limiter 3                                                   */
                __OM uint32_t LIM4ENABLE    : 1; /*!< [3..3] Enable limiter 4                                                   */
                __OM uint32_t LIM5ENABLE    : 1; /*!< [4..4] Enable limiter 5                                                   */
                __OM uint32_t LIM6ENABLE    : 1; /*!< [5..5] Enable limiter 6                                                   */
                __OM uint32_t QUAD1ENABLE   : 1; /*!< [6..6] Enable quadratic coupling of limiters 1 and 2                      */
                __OM uint32_t QUAD2ENABLE   : 1; /*!< [7..7] Enable quadratic coupling of limiters 3 and 4                      */
                __OM uint32_t QUAD3ENABLE   : 1; /*!< [8..8] Enable quadratic coupling of limiters 5 and 6                      */
                __OM uint32_t LIM1THRESHOLD : 1; /*!< [9..9] Enable limiter 1 threshold mode                                    */
                __OM uint32_t LIM2THRESHOLD : 1; /*!< [10..10] Enable limiter 2 threshold mode                                  */
                __OM uint32_t LIM3THRESHOLD : 1; /*!< [11..11] Enable limiter 3 threshold mode                                  */
                __OM uint32_t LIM4THRESHOLD : 1; /*!< [12..12] Enable limiter 4 threshold mode                                  */
                __OM uint32_t LIM5THRESHOLD : 1; /*!< [13..13] Enable limiter 5 threshold mode                                  */
                __OM uint32_t LIM6THRESHOLD : 1; /*!< [14..14] Enable limiter 6 threshold mode                                  */
                __OM uint32_t BAND1ENABLE   : 1; /*!< [15..15] Enable band postprocess for limiter 1 (see L1BAND)               */
                __OM uint32_t BAND2ENABLE   : 1; /*!< [16..16] Enable band postprocess for limiter 1 (see L1BAND)               */
                __OM uint32_t UNION12       : 1; /*!< [17..17] Combine limter 1 & 2 as union (output is called A)               */
                __OM uint32_t UNION34       : 1; /*!< [18..18] Combine limter 3 & 4 as union (output is called B)               */
                __OM uint32_t UNION56       : 1; /*!< [19..19] Combine limter 5 & 6 as union (output is called D)               */
                __OM uint32_t UNIONAB       : 1; /*!< [20..20] Combine outputs A & B as union (output is called C)              */
                __OM uint32_t UNIONCD       : 1; /*!< [21..21] Combine outputs C & D as union (output is final)                 */
                __OM uint32_t SPANABORT     : 1; /*!< [22..22] Shape is horizontally convex, only a single span per
                                                  *   scanline                                                                  */
                __OM uint32_t SPANSTORE : 1;     /*!< [23..23] Nextline span start is always equal or left to current-line
                                                  *   span start                                                                */
                uint32_t : 8;
            } CONTROL_b;
        };

        union
        {
            __IM uint32_t STATUS;               /*!< (@ 0x00000000) Status Control Register                                    */

            struct
            {
                __IM uint32_t BUSYENUM     : 1; /*!< [0..0] Enumeration unit status                                            */
                __IM uint32_t BUSYWRITE    : 1; /*!< [1..1] Framebuffer writeback status                                       */
                __IM uint32_t CACHEDIRTY   : 1; /*!< [2..2] Framebuffer cache status                                           */
                __IM uint32_t DLISTACTIVE  : 1; /*!< [3..3] Display list reader status                                         */
                __IM uint32_t ENUMIRQ      : 1; /*!< [4..4] enumeration finished interrupt triggered                           */
                __IM uint32_t DLISTIRQ     : 1; /*!< [5..5] display list finished interrupt triggered                          */
                __IM uint32_t BUSIRQ       : 1; /*!< [6..6] bus error interrupt triggered                                      */
                uint32_t                   : 1;
                __IM uint32_t BUSERRMFB    : 1; /*!< [8..8] framebuffer bus error interrupt triggered                          */
                __IM uint32_t BUSERRMTXMRL : 1; /*!< [9..9] texture bus error interrupt triggered                              */
                __IM uint32_t BUSERRMDL    : 1; /*!< [10..10] display list bus error interrupt triggered                       */
                uint32_t                   : 21;
            } STATUS_b;
        };
    };

    union
    {
        union
        {
            __OM uint32_t CONTROL2;                /*!< (@ 0x00000004) Surface Control Register                                   */

            struct
            {
                __OM uint32_t PATTERNENABLE : 1;   /*!< [0..0] Pixel source is a pattern color (blend of COLOR1 and
                                                    *   COLOR2 depending on PATTERN and pattern index)                            */
                __OM uint32_t TEXTUREENABLE : 1;   /*!< [1..1] Pixel source is read from texture and used as an alpha
                                                    *   to blend between COLOR1 and COLOR2                                        */
                __OM uint32_t PATTERNSOURCEL5 : 1; /*!< [2..2] Limiter 5 is used as pattern index instead of the default
                                                    *   U limiter.Limiter 5 can be combined with limiter 6 to form
                                                    *   a quadratic limiter which can be used to make quadratic
                                                    *   pattern functions to draw radial patterns.                                */
                __OM uint32_t USEACB       : 1;    /*!< [3..3] Alpha blend mode                                                   */
                __OM uint32_t READFORMAT32 : 2;    /*!< [5..4] Bit 4 and 3 of the texture buffer format.See READFORMAT
                                                    *   above for description                                                     */
                __OM uint32_t BSFA : 1;            /*!< [6..6] Blend source factor for alpha channel in alpha channel
                                                    *   blending mode (USEACB = 1)                                                */
                __OM uint32_t BDFA : 1;            /*!< [7..7] Blend destinetion factor for alpha channel in alpha channel
                                                    *   blending mode (USEACB = 1)                                                */
                __OM uint32_t WRITEFORMAT2 : 1;    /*!< [8..8] Bit 3 of framebuffer pixel formatSee WRITEFORMAT above
                                                    *   description.                                                              */
                __OM uint32_t BSF : 1;             /*!< [9..9] Blend source factorsrc factor is alpha (factor is 1 per
                                                    *   default)                                                                  */
                __OM uint32_t BDF : 1;             /*!< [10..10] Blend destination factordst factor is alpha (factor
                                                    *   is 1 per default)                                                         */
                __OM uint32_t BSI : 1;             /*!< [11..11] Blend source factor is invertedsrc factor will be inverted
                                                    *   (meaning 1-a or 1-1 depending on BSF)                                     */
                __OM uint32_t BDI : 1;             /*!< [12..12] Blend destination factor is inverteddst factor will
                                                    *   be inverted (meaning 1-a or 1-1 depending on BDF)                         */
                __OM uint32_t BC2           : 1;   /*!< [13..13] Blend color 2 instead of framebuffer pixel                       */
                __OM uint32_t TEXTURECLAMPX : 1;   /*!< [14..14] Calculating U limiter outside use textureThe bit describes
                                                    *   what happens if the U limiter (x direction in texture space)
                                                    *   calculates a U value outside of the used texture                          */
                __OM uint32_t TEXTURECLAMPY : 1;   /*!< [15..15] Calculating V limiter outside use textureThe bit describes
                                                    *   what happens if the V limiter (y direction in texture space)
                                                    *   calculates a V value outside of the used texture                          */
                __OM uint32_t TEXTUREFILTERX : 1;  /*!< [16..16] Linear filtering on texture U axis                               */
                __OM uint32_t TEXTUREFILTERY : 1;  /*!< [17..17] Linear filtering on texture V axis                               */
                __OM uint32_t READFORMAT10   : 2;  /*!< [19..18] Pixel format of the texture buffer{READFORMAT32,READFORMAT10}0000:
                                                    *   8 bpp a(8)0001: 16 bpp RGB(565)0010: 32 bpp aRGB(8888)0011:
                                                    *   16 bpp aRGB(4444)0100: 16 bpp aRGB(1555)0101: 8 bpp aCLUT(44)
                                                    *   4 bit alpha and 4 bit indexed color1001: 8 bpp CLUT(8)/I(8),
                                                    *   8 bit indexed color/luminance1010: 4 bpp CLUT(4)/I(4),
                                                    *   4 bit indexed color/luminance1011: 2 bpp CLUT(2)/I(2),
                                                    *   2 bit indexed color/luminance 1100: 1 bpp CLUT(1)/I(1),
                                                    *   1 bit indexed color/luminance                                             */
                __OM uint32_t WRITEFORMAT10 : 2;   /*!< [21..20] Pixel format of the framebuffer                                  */
                __OM uint32_t WRITEALPHA    : 2;   /*!< [23..22] Writeback alpha source for framebufferSet the 'alpha
                                                    *   source' for the framebuffer(USEACB = 0)Blend alpha in color
                                                    *   2 instead of framebuffer alpha((USEACB = 1))In not alpha
                                                    *   channel blending mode (USEACB = 0):Set the 'alpha source'
                                                    *   for the framebuffer.In alpha channel blending mode (USEACB
                                                    *   = 1):Blend alpha in color 2 instead of framebuffer alpha00B:
                                                    *   BC2A = 1: use alpha from framebuffer as destination (DST_A)else:
                                                    *   BC2A = 0: use alpha in color 2 as destination (DST_A)                     */
                __OM uint32_t RLEENABLE    : 1;    /*!< [24..24] RLE enable                                                       */
                __OM uint32_t CLUTENABLE   : 1;    /*!< [25..25] CLUT enable                                                      */
                __OM uint32_t COLKEYENABLE : 1;    /*!< [26..26] color keying enable                                              */
                __OM uint32_t CLUTFORMAT   : 1;    /*!< [27..27] Format of the CLUT                                               */
                __OM uint32_t BSIA         : 1;    /*!< [28..28] Blend source factor inverted in alpha channel (USEACB
                                                    *   = 1)                                                                      */
                __OM uint32_t BDIA : 1;            /*!< [29..29] Blend destination factor inverted in alpha channel
                                                    *   (USEACB = 1)                                                              */
                __OM uint32_t RLEPIXELWIDTH : 2;   /*!< [31..30] Texel width for RLE unit                                         */
            } CONTROL2_b;
        };

        union
        {
            __IM uint32_t HWREVISION;          /*!< (@ 0x00000004) Hardware Version and Feature Set ID Register               */

            struct
            {
                __IM uint32_t REV        : 12; /*!< [11..0] Revision number                                                   */
                uint32_t                 : 5;
                __IM uint32_t DLR        : 1;  /*!< [17..17] Display list reader feature                                      */
                __IM uint32_t FBCACHE    : 1;  /*!< [18..18] Framebuffer cache feature                                        */
                __IM uint32_t TXCACHE    : 1;  /*!< [19..19] Texture cache feature                                            */
                __IM uint32_t PERFCOUNT  : 1;  /*!< [20..20] Two performance counter feature                                  */
                __IM uint32_t TEXCLU     : 1;  /*!< [21..21] Texture CLUT with 16 or 256 entries feature                      */
                uint32_t                 : 1;
                __IM uint32_t RLEUNIT    : 1;  /*!< [23..23] RLE unit feature                                                 */
                __IM uint32_t TEXCLUT256 : 1;  /*!< [24..24] Texture CLUT feature                                             */
                __IM uint32_t COLORKEY   : 1;  /*!< [25..25] Colorkey feature                                                 */
                uint32_t                 : 1;
                __IM uint32_t ACBLEND    : 1;  /*!< [27..27] Alpha channel blending feature                                   */
                uint32_t                 : 4;
            } HWREVISION_b;
        };
    };
    __IM uint32_t RESERVED[2];

    union
    {
        __OM uint32_t L1START;         /*!< (@ 0x00000010) Limiter 1 Start Value Register                             */

        struct
        {
            __OM uint32_t LSTART : 32; /*!< [31..0] Start value of the n'th limiter(n=1-6)                            */
        } L1START_b;
    };

    union
    {
        __OM uint32_t L2START;         /*!< (@ 0x00000014) Limiter 2 Start Value Register                             */

        struct
        {
            __OM uint32_t LSTART : 32; /*!< [31..0] Start value of the n'th limiter(n=1-6)                            */
        } L2START_b;
    };

    union
    {
        __OM uint32_t L3START;         /*!< (@ 0x00000018) Limiter 3 Start Value Register                             */

        struct
        {
            __OM uint32_t LSTART : 32; /*!< [31..0] Start value of the n'th limiter(n=1-6)                            */
        } L3START_b;
    };

    union
    {
        __OM uint32_t L4START;         /*!< (@ 0x0000001C) Limiter 4 Start Value Register                             */

        struct
        {
            __OM uint32_t LSTART : 32; /*!< [31..0] Start value of the n'th limiter(n=1-6)                            */
        } L4START_b;
    };

    union
    {
        __OM uint32_t L5START;         /*!< (@ 0x00000020) Limiter 5 Start Value Register                             */

        struct
        {
            __OM uint32_t LSTART : 32; /*!< [31..0] Start value of the n'th limiter(n=1-6)                            */
        } L5START_b;
    };

    union
    {
        __OM uint32_t L6START;         /*!< (@ 0x00000024) Limiter 6 Start Value Register                             */

        struct
        {
            __OM uint32_t LSTART : 32; /*!< [31..0] Start value of the n'th limiter(n=1-6)                            */
        } L6START_b;
    };

    union
    {
        __OM uint32_t L1XADD;          /*!< (@ 0x00000028) Limiter 1 X-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LXADD : 32;  /*!< [31..0] X-axis increment                                                  */
        } L1XADD_b;
    };

    union
    {
        __OM uint32_t L2XADD;          /*!< (@ 0x0000002C) Limiter 2 X-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LXADD : 32;  /*!< [31..0] X-axis increment                                                  */
        } L2XADD_b;
    };

    union
    {
        __OM uint32_t L3XADD;          /*!< (@ 0x00000030) Limiter 3 X-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LXADD : 32;  /*!< [31..0] X-axis increment                                                  */
        } L3XADD_b;
    };

    union
    {
        __OM uint32_t L4XADD;          /*!< (@ 0x00000034) Limiter 4 X-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LXADD : 32;  /*!< [31..0] X-axis increment                                                  */
        } L4XADD_b;
    };

    union
    {
        __OM uint32_t L5XADD;          /*!< (@ 0x00000038) Limiter 5 X-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LXADD : 32;  /*!< [31..0] X-axis increment                                                  */
        } L5XADD_b;
    };

    union
    {
        __OM uint32_t L6XADD;          /*!< (@ 0x0000003C) Limiter 6 X-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LXADD : 32;  /*!< [31..0] X-axis increment                                                  */
        } L6XADD_b;
    };

    union
    {
        __OM uint32_t L1YADD;          /*!< (@ 0x00000040) Limiter 1 Y-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LYADD : 32;  /*!< [31..0] Y-axis increment                                                  */
        } L1YADD_b;
    };

    union
    {
        __OM uint32_t L2YADD;          /*!< (@ 0x00000044) Limiter 2 Y-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LYADD : 32;  /*!< [31..0] Y-axis increment                                                  */
        } L2YADD_b;
    };

    union
    {
        __OM uint32_t L3YADD;          /*!< (@ 0x00000048) Limiter 3 Y-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LYADD : 32;  /*!< [31..0] Y-axis increment                                                  */
        } L3YADD_b;
    };

    union
    {
        __OM uint32_t L4YADD;          /*!< (@ 0x0000004C) Limiter 4 Y-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LYADD : 32;  /*!< [31..0] Y-axis increment                                                  */
        } L4YADD_b;
    };

    union
    {
        __OM uint32_t L5YADD;          /*!< (@ 0x00000050) Limiter 5 Y-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LYADD : 32;  /*!< [31..0] Y-axis increment                                                  */
        } L5YADD_b;
    };

    union
    {
        __OM uint32_t L6YADD;          /*!< (@ 0x00000054) Limiter 6 Y-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LYADD : 32;  /*!< [31..0] Y-axis increment                                                  */
        } L6YADD_b;
    };

    union
    {
        __OM uint32_t L1BAND;          /*!< (@ 0x00000058) Limiter 1 Band Width Parameter Register                    */

        struct
        {
            __OM uint32_t LBAND : 32;  /*!< [31..0] Limiter m band width parameter                                    */
        } L1BAND_b;
    };

    union
    {
        __OM uint32_t L2BAND;          /*!< (@ 0x0000005C) Limiter 2 Band Width Parameter Register                    */

        struct
        {
            __OM uint32_t LBAND : 32;  /*!< [31..0] Limiter m band width parameter                                    */
        } L2BAND_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __OM uint32_t COLOR1;          /*!< (@ 0x00000064) Base Color Register                                        */

        struct
        {
            __OM uint32_t COLOR1B : 8; /*!< [7..0] Blue channel of color 1                                            */
            __OM uint32_t COLOR1G : 8; /*!< [15..8] Green channel of color 1                                          */
            __OM uint32_t COLOR1R : 8; /*!< [23..16] Red channel of color 1                                           */
            __OM uint32_t COLOR1A : 8; /*!< [31..24] Alpha channel of color 1(0x00: transparent. . . 0xFF:
                                        *   opaque)                                                                   */
        } COLOR1_b;
    };

    union
    {
        __OM uint32_t COLOR2;          /*!< (@ 0x00000068) Secondary Color Register                                   */

        struct
        {
            __OM uint32_t COLOR2B : 8; /*!< [7..0] Blue channel of color 2                                            */
            __OM uint32_t COLOR2G : 8; /*!< [15..8] Green channel of color 2                                          */
            __OM uint32_t COLOR2R : 8; /*!< [23..16] Red channel of color 2                                           */
            __OM uint32_t COLOR2A : 8; /*!< [31..24] Alpha channel of color 2(0x00: transparent. . . 0xFF:
                                        *   opaque)                                                                   */
        } COLOR2_b;
    };
    __IM uint32_t RESERVED2[2];

    union
    {
        __OM uint32_t PATTERN;         /*!< (@ 0x00000074) Pattern Register                                           */

        struct
        {
            __OM uint32_t PATTERN : 8; /*!< [7..0] Bitmap of the pattern                                              */
            uint32_t              : 24;
        } PATTERN_b;
    };

    union
    {
        __OM uint32_t SIZE;            /*!< (@ 0x00000078) Bounding Box Dimension Register                            */

        struct
        {
            __OM uint32_t SIZEX : 16;  /*!< [15..0] Width of the bounding box in pixelsvalid range: 0 to
                                        *   1024                                                                      */
            __OM uint32_t SIZEY : 16;  /*!< [31..16] Height of the bounding box in pixelsvalid range: 0
                                        *   to 1024                                                                   */
        } SIZE_b;
    };

    union
    {
        __OM uint32_t PITCH;           /*!< (@ 0x0000007C) Framebuffer Pitch And Spanstore Delay Register             */

        struct
        {
            __OM uint32_t PITCH : 16;  /*!< [15..0] pitch of the framebuffer. A negative width can be used
                                        *   to render bottom-up instead of top-down                                   */
            __OM uint32_t SSD : 16;    /*!< [31..16] Spanstore delay                                                  */
        } PITCH_b;
    };

    union
    {
        __OM uint32_t ORIGIN;          /*!< (@ 0x00000080) Framebuffer Base Address Register                          */

        struct
        {
            __OM uint32_t ORIGIN : 32; /*!< [31..0] Address of the first pixel in framebuffer                         */
        } ORIGIN_b;
    };
    __IM uint32_t RESERVED3[3];

    union
    {
        __OM uint32_t LUSTART;          /*!< (@ 0x00000090) U Limiter Start Value Register                             */

        struct
        {
            __OM uint32_t LUSTART : 32; /*!< [31..0] U limiter start value                                             */
        } LUSTART_b;
    };

    union
    {
        __OM uint32_t LUXADD;          /*!< (@ 0x00000094) U Limiter X-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LUXADD : 32; /*!< [31..0] U limiter x-axis increment                                        */
        } LUXADD_b;
    };

    union
    {
        __OM uint32_t LUYADD;          /*!< (@ 0x00000098) U Limiter Y-Axis Increment Register                        */

        struct
        {
            __OM uint32_t LUYADD : 32; /*!< [31..0] U limiter y-axis increment                                        */
        } LUYADD_b;
    };

    union
    {
        __OM uint32_t LVSTARTI;          /*!< (@ 0x0000009C) V Limiter Start Value Integer Part Register                */

        struct
        {
            __OM uint32_t LVSTARTI : 32; /*!< [31..0] V limiter start value integer part                                */
        } LVSTARTI_b;
    };

    union
    {
        __OM uint32_t LVSTARTF;          /*!< (@ 0x000000A0) V Limiter Start Value Fractional Part Register             */

        struct
        {
            __OM uint32_t LVSTARTF : 16; /*!< [15..0] V limiter start value fractional part                             */
            uint32_t               : 16;
        } LVSTARTF_b;
    };

    union
    {
        __OM uint32_t LVXADDI;          /*!< (@ 0x000000A4) V Limiter X-Axis Increment Integer Part Register           */

        struct
        {
            __OM uint32_t LVXADDI : 32; /*!< [31..0] V limiter x-axis increment integer part                           */
        } LVXADDI_b;
    };

    union
    {
        __OM uint32_t LVYADDI;          /*!< (@ 0x000000A8) V Limiter Y-Axis Increment Integer Part Register           */

        struct
        {
            __OM uint32_t LVYADDI : 32; /*!< [31..0] V limiter y-axis increment integer part                           */
        } LVYADDI_b;
    };

    union
    {
        __OM uint32_t LVYXADDF;         /*!< (@ 0x000000AC) V Limiter Increment Fractional Parts Register              */

        struct
        {
            __OM uint32_t LVXADDF : 16; /*!< [15..0] V xlimiter increment fractional part                              */
            __OM uint32_t LVYADDF : 16; /*!< [31..16] V y limiter increment fractional part                            */
        } LVYXADDF_b;
    };
    __IM uint32_t RESERVED4;

    union
    {
        __OM uint32_t TEXPITCH;          /*!< (@ 0x000000B4) Texels Per Texture Line Register                           */

        struct
        {
            __OM uint32_t TEXPITCH : 32; /*!< [31..0] Texels per texture linevalid range: 0 to 2048                     */
        } TEXPITCH_b;
    };

    union
    {
        __OM uint32_t TEXMASK;           /*!< (@ 0x000000B8) Texture Size or Texture Address Mask Register              */

        struct
        {
            __OM uint32_t TEXUMASK : 11; /*!< [10..0] U maskSet TEXUMASK[10:0] = texture_width -1In texture
                                          *   wrapping mode (CONTROL2.TEXTURECLAMPX = 0): texture_width
                                          *   must be a power of 2.In texture clamping mode (CONTROL2.TEXTURECLAMPX
                                          *   = 1):all widths up to 2048 are allowed.                                   */
            __OM uint32_t TEXVMASK : 21; /*!< [31..11] V maskSet TEXVMASK[20:0] = TEXPITCH * (texture_height
                                          *   - 1).In texture wrapping mode (CONTROL2.TEXTURECLAMPY =
                                          *   0): texture_height must be a power of 2In texture clamping
                                          *   mode (CONTROL2.TEXTURECLAMPY = 1):all heights up to 1024
                                          *   are allowed.                                                              */
        } TEXMASK_b;
    };

    union
    {
        __OM uint32_t TEXORIGIN;          /*!< (@ 0x000000BC) Texture Base Address Register                              */

        struct
        {
            __OM uint32_t TEXORIGIN : 32; /*!< [31..0] Texture base address                                              */
        } TEXORIGIN_b;
    };

    union
    {
        __OM uint32_t IRQCTL;              /*!< (@ 0x000000C0) Interrupt Control Register                                 */

        struct
        {
            __OM uint32_t ENUMIRQEN   : 1; /*!< [0..0] ENUMIRQ interrupt mask enable                                      */
            __OM uint32_t DLISTIRQEN  : 1; /*!< [1..1] DLISTIRQ interrupt mask enable                                     */
            __OM uint32_t ENUMIRQCLR  : 1; /*!< [2..2] Clear enumeration interrupt ENUMIRQ                                */
            __OM uint32_t DLISTIRQCLR : 1; /*!< [3..3] Clear display list interrupt DLISTIRQ                              */
            __OM uint32_t BUSIRQEN    : 1; /*!< [4..4] BUSIRQ interrupt mask enable                                       */
            __OM uint32_t BUSIRQCLR   : 1; /*!< [5..5] Clear bus error interrupt BUSIRQ                                   */
            uint32_t                  : 26;
        } IRQCTL_b;
    };

    union
    {
        __OM uint32_t CACHECTL;          /*!< (@ 0x000000C4) Cache Control Register                                     */

        struct
        {
            __OM uint32_t CENABLEFX : 1; /*!< [0..0] Framebuffer cache enable                                           */
            __OM uint32_t CFLUSHFX  : 1; /*!< [1..1] Flush framebuffer cache                                            */
            __OM uint32_t CENABLETX : 1; /*!< [2..2] Texture cache enable                                               */
            __OM uint32_t CFLUSHTX  : 1; /*!< [3..3] Flush texture cache                                                */
            uint32_t                : 28;
        } CACHECTL_b;
    };

    union
    {
        __OM uint32_t DLISTSTART;          /*!< (@ 0x000000C8) Display List Start Address Register                        */

        struct
        {
            __OM uint32_t DLISTSTART : 32; /*!< [31..0] Display list start address                                        */
        } DLISTSTART_b;
    };

    union
    {
        __IOM uint32_t PERFCOUNT1;         /*!< (@ 0x000000CC) Performance Counter 1                                      */

        struct
        {
            __IOM uint32_t PERFCOUNT : 32; /*!< [31..0] Counter value.The counter is reset by writing PERFCOUNT
                                            *   = 0000 0000H.                                                             */
        } PERFCOUNT1_b;
    };

    union
    {
        __IOM uint32_t PERFCOUNT2;         /*!< (@ 0x000000D0) Performance Counter 2                                      */

        struct
        {
            __IOM uint32_t PERFCOUNT : 32; /*!< [31..0] Counter value.The counter is reset by writing PERFCOUNT
                                            *   = 0000 0000H.                                                             */
        } PERFCOUNT2_b;
    };

    union
    {
        __OM uint32_t PERFTRIGGER;           /*!< (@ 0x000000D4) Performance Counters Control Register                      */

        struct
        {
            __OM uint32_t PERFTRIGGER1 : 16; /*!< [15..0] Selects the internal event that will increment PERFCOUNT1
                                              *   register.                                                                 */
            __OM uint32_t PERFTRIGGER2 : 16; /*!< [31..16] Selects the internal event that will increment PERFCOUNT2
                                              *   register                                                                  */
        } PERFTRIGGER_b;
    };
    __IM uint32_t RESERVED5;

    union
    {
        __OM uint32_t TEXCLADDR;       /*!< (@ 0x000000DC) CLUT Start Address Register                                */

        struct
        {
            __OM uint32_t CLADDR : 8;  /*!< [7..0] Texture CLUT start address for indexed texture format              */
            uint32_t             : 24;
        } TEXCLADDR_b;
    };

    union
    {
        __OM uint32_t TEXCLDATA;       /*!< (@ 0x000000E0) CLUT Data Register                                         */

        struct
        {
            __OM uint32_t CLDATA : 32; /*!< [31..0] Texture CLUT data for Indexed texture format                      */
        } TEXCLDATA_b;
    };

    union
    {
        __OM uint32_t TEXCLOFFSET;      /*!< (@ 0x000000E4) CLUT Offset Register                                       */

        struct
        {
            __OM uint32_t CLOFFSET : 8; /*!< [7..0] Texture CLUT offset for Indexed texture format. CLOFFSET[7:0]
                                         *   is or'ed with the original index                                          */
            uint32_t : 24;
        } TEXCLOFFSET_b;
    };

    union
    {
        __OM uint32_t COLKEY;          /*!< (@ 0x000000E8) Color Key Register                                         */

        struct
        {
            __OM uint32_t COLKEYB : 8; /*!< [7..0] Blue channel of color key                                          */
            __OM uint32_t COLKEYG : 8; /*!< [15..8] Green channel of color key                                        */
            __OM uint32_t COLKEYR : 8; /*!< [23..16] Red channel of color key                                         */
            uint32_t              : 8;
        } COLKEY_b;
    };
} R_DRW_Type;                          /*!< Size = 236 (0xec)                                                         */

/* =========================================================================================================================== */
/* ================                                           R_DTC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Data Transfer Controller (R_DTC)
 */

typedef struct                         /*!< (@ 0x40005400) R_DTC Structure                                            */
{
    union
    {
        __IOM uint8_t DTCCR;           /*!< (@ 0x00000000) DTC Control Register                                       */

        struct
        {
            uint8_t           : 4;
            __IOM uint8_t RRS : 1;     /*!< [4..4] DTC Transfer Information Read Skip Enable.                         */
            uint8_t           : 3;
        } DTCCR_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;

    union
    {
        __IOM uint32_t DTCVBR;          /*!< (@ 0x00000004) DTC Vector Base Register                                   */

        struct
        {
            __IOM uint32_t DTCVBR : 32; /*!< [31..0] DTC Vector Base Address.Note: A value cannot be set
                                         *   in the lower-order 10 bits. These bits are fixed to 0.                    */
        } DTCVBR_b;
    };
    __IM uint32_t RESERVED2;

    union
    {
        __IOM uint8_t DTCST;           /*!< (@ 0x0000000C) DTC Module Start Register                                  */

        struct
        {
            __IOM uint8_t DTCST : 1;   /*!< [0..0] DTC Module Start                                                   */
            uint8_t             : 7;
        } DTCST_b;
    };
    __IM uint8_t RESERVED3;

    union
    {
        __IM uint16_t DTCSTS;          /*!< (@ 0x0000000E) DTC Status Register                                        */

        struct
        {
            __IM uint16_t VECN : 8;    /*!< [7..0] DTC-Activating Vector Number MonitoringThese bits indicate
                                        *   the vector number for the activating source when DTC transfer
                                        *   is in progress.The value is only valid if DTC transfer
                                        *   is in progress (the value of the ACT flag is 1)                           */
            uint16_t          : 7;
            __IM uint16_t ACT : 1;     /*!< [15..15] DTC Active Flag                                                  */
        } DTCSTS_b;
    };

    union
    {
        __IOM uint8_t DTCCR_SEC;       /*!< (@ 0x00000010) DTC Control Register for secure Region                     */

        struct
        {
            uint8_t            : 4;
            __IOM uint8_t RRSS : 1;    /*!< [4..4] DTC Transfer Information Read Skip Enable for Secure               */
            uint8_t            : 3;
        } DTCCR_SEC_b;
    };
    __IM uint8_t   RESERVED4;
    __IM uint16_t  RESERVED5;
    __IOM uint32_t DTCVBR_SEC;         /*!< (@ 0x00000014) DTC Vector Base Register for secure Region                 */
    __IM uint32_t  RESERVED6[2];

    union
    {
        __IOM uint32_t DTEVR;          /*!< (@ 0x00000020) DTC Error Vector Register                                  */

        struct
        {
            __IM uint32_t DTEV    : 8; /*!< [7..0] DTC Error Vector Number                                            */
            __IM uint32_t DTEVSAM : 1; /*!< [8..8] DTC Error Vector Number SA Monitor                                 */
            uint32_t              : 7;
            __IOM uint32_t DTESTA : 1; /*!< [16..16] DTC Error Status Flag                                            */
            uint32_t              : 15;
        } DTEVR_b;
    };
} R_DTC_Type;                          /*!< Size = 36 (0x24)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_ELC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Event Link Controller (R_ELC)
 */

 #ifndef BSP_OVERRIDE_REG_R_ELC_TYPE

typedef struct                         /*!< (@ 0x40041000) R_ELC Structure                                            */
{
    union
    {
        __IOM uint8_t ELCR;            /*!< (@ 0x00000000) Event Link Controller Register                             */

        struct
        {
            uint8_t             : 7;
            __IOM uint8_t ELCON : 1;   /*!< [7..7] All Event Link Enable                                              */
        } ELCR_b;
    };
    __IM uint8_t            RESERVED;
    __IOM R_ELC_ELSEGR_Type ELSEGR[2]; /*!< (@ 0x00000002) Event Link Software Event Generation Register              */
    __IM uint16_t           RESERVED1[5];
    __IOM R_ELC_ELSR_Type   ELSR[23];  /*!< (@ 0x00000010) Event Link Setting Register [0..22]                        */
    __IM uint16_t           RESERVED2[4];

    union
    {
        __IOM uint16_t ELCSARA;         /*!< (@ 0x00000074) Event Link Controller Security Attribution Register
                                         *                  A                                                          */

        struct
        {
            __IOM uint16_t ELCR    : 1; /*!< [0..0] Event Link Controller RegisterSecurity Attribution                 */
            __IOM uint16_t ELSEGR0 : 1; /*!< [1..1] Event Link Software Event Generation Register 0 Security
                                         *   Attribution                                                               */
            __IOM uint16_t ELSEGR1 : 1; /*!< [2..2] Event Link Software Event Generation Register 1Security
                                         *   Attribution                                                               */
            uint16_t : 13;
        } ELCSARA_b;
    };
    __IM uint16_t RESERVED3;

    union
    {
        __IOM uint16_t ELCSARB;        /*!< (@ 0x00000078) Event Link Controller Security Attribution Register
                                        *                  B                                                          */

        struct
        {
            __IOM uint16_t ELSR0  : 1; /*!< [0..0] Event Link Setting Register 0Security Attribution                  */
            __IOM uint16_t ELSR1  : 1; /*!< [1..1] Event Link Setting Register 1Security Attribution                  */
            __IOM uint16_t ELSR2  : 1; /*!< [2..2] Event Link Setting Register 2Security Attribution                  */
            __IOM uint16_t ELSR3  : 1; /*!< [3..3] Event Link Setting Register 3Security Attribution                  */
            __IOM uint16_t ELSR4  : 1; /*!< [4..4] Event Link Setting Register 4Security Attribution                  */
            __IOM uint16_t ELSR5  : 1; /*!< [5..5] Event Link Setting Register 5Security Attribution                  */
            __IOM uint16_t ELSR6  : 1; /*!< [6..6] Event Link Setting Register 6Security Attribution                  */
            __IOM uint16_t ELSR7  : 1; /*!< [7..7] Event Link Setting Register 7Security Attribution                  */
            __IOM uint16_t ELSR8  : 1; /*!< [8..8] Event Link Setting Register 8Security Attribution                  */
            __IOM uint16_t ELSR9  : 1; /*!< [9..9] Event Link Setting Register 9Security Attribution                  */
            __IOM uint16_t ELSR10 : 1; /*!< [10..10] Event Link Setting Register 10Security Attribution               */
            __IOM uint16_t ELSR11 : 1; /*!< [11..11] Event Link Setting Register 11Security Attribution               */
            __IOM uint16_t ELSR12 : 1; /*!< [12..12] Event Link Setting Register 12Security Attribution               */
            __IOM uint16_t ELSR13 : 1; /*!< [13..13] Event Link Setting Register 13Security Attribution               */
            __IOM uint16_t ELSR14 : 1; /*!< [14..14] Event Link Setting Register 14Security Attribution               */
            __IOM uint16_t ELSR15 : 1; /*!< [15..15] Event Link Setting Register 15Security Attribution               */
        } ELCSARB_b;
    };
    __IM uint16_t RESERVED4;

    union
    {
        __IOM uint16_t ELCSARC;        /*!< (@ 0x0000007C) Event Link Controller Security Attribution Register
                                        *                  C                                                          */

        struct
        {
            __IOM uint16_t ELSR16 : 1; /*!< [0..0] Event Link Setting Register 16Security Attribution                 */
            __IOM uint16_t ELSR17 : 1; /*!< [1..1] Event Link Setting Register 17Security Attribution                 */
            __IOM uint16_t ELSR18 : 1; /*!< [2..2] Event Link Setting Register 18Security Attribution                 */
            uint16_t              : 13;
        } ELCSARC_b;
    };
} R_ELC_Type;                          /*!< Size = 126 (0x7e)                                                         */

 #endif

/* =========================================================================================================================== */
/* ================                                         R_ETHERC0                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Ethernet MAC Controller (R_ETHERC0)
 */

typedef struct                         /*!< (@ 0x40064100) R_ETHERC0 Structure                                        */
{
    union
    {
        __IOM uint32_t ECMR;           /*!< (@ 0x00000000) ETHERC Mode Register                                       */

        struct
        {
            __IOM uint32_t PRM   : 1;  /*!< [0..0] Promiscuous Mode                                                   */
            __IOM uint32_t DM    : 1;  /*!< [1..1] Duplex Mode                                                        */
            __IOM uint32_t RTM   : 1;  /*!< [2..2] Bit Rate                                                           */
            __IOM uint32_t ILB   : 1;  /*!< [3..3] Internal Loopback Mode                                             */
            uint32_t             : 1;
            __IOM uint32_t TE    : 1;  /*!< [5..5] Transmission Enable                                                */
            __IOM uint32_t RE    : 1;  /*!< [6..6] Reception Enable                                                   */
            uint32_t             : 2;
            __IOM uint32_t MPDE  : 1;  /*!< [9..9] Magic Packet Detection Enable                                      */
            uint32_t             : 2;
            __IOM uint32_t PRCEF : 1;  /*!< [12..12] CRC Error Frame Receive Mode                                     */
            uint32_t             : 3;
            __IOM uint32_t TXF   : 1;  /*!< [16..16] Transmit Flow Control Operating Mode                             */
            __IOM uint32_t RXF   : 1;  /*!< [17..17] Receive Flow Control Operating Mode                              */
            __IOM uint32_t PFR   : 1;  /*!< [18..18] PAUSE Frame Receive Mode                                         */
            __IOM uint32_t ZPF   : 1;  /*!< [19..19] 0 Time PAUSE Frame Enable                                        */
            __IOM uint32_t TPC   : 1;  /*!< [20..20] PAUSE Frame Transmit                                             */
            uint32_t             : 11;
        } ECMR_b;
    };
    __IM uint32_t RESERVED;

    union
    {
        __IOM uint32_t RFLR;           /*!< (@ 0x00000008) Receive Frame Maximum Length Register                      */

        struct
        {
            __IOM uint32_t RFL : 12;   /*!< [11..0] Receive Frame Maximum LengthThe set value becomes the
                                        *   maximum frame length. The minimum value that can be set
                                        *   is 1,518 bytes, and the maximum value that can be set is
                                        *   2,048 bytes. Values that are less than 1,518 bytes are
                                        *   regarded as 1,518 bytes, and values larger than 2,048 bytes
                                        *   are regarded as 2,048 bytes.                                              */
            uint32_t : 20;
        } RFLR_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __IOM uint32_t ECSR;           /*!< (@ 0x00000010) ETHERC Status Register                                     */

        struct
        {
            __IOM uint32_t ICD   : 1;  /*!< [0..0] False Carrier Detect Flag                                          */
            __IOM uint32_t MPD   : 1;  /*!< [1..1] Magic Packet Detect Flag                                           */
            __IOM uint32_t LCHNG : 1;  /*!< [2..2] LCHNG Link Signal Change Flag                                      */
            uint32_t             : 1;
            __IOM uint32_t PSRTO : 1;  /*!< [4..4] PAUSE Frame Retransmit Over Flag                                   */
            __IOM uint32_t BFR   : 1;  /*!< [5..5] Continuous Broadcast Frame Reception Flag                          */
            uint32_t             : 26;
        } ECSR_b;
    };
    __IM uint32_t RESERVED2;

    union
    {
        __IOM uint32_t ECSIPR;          /*!< (@ 0x00000018) ETHERC Interrupt Enable Register                           */

        struct
        {
            __IOM uint32_t ICDIP   : 1; /*!< [0..0] False Carrier Detect Interrupt Enable                              */
            __IOM uint32_t MPDIP   : 1; /*!< [1..1] Magic Packet Detect Interrupt Enable                               */
            __IOM uint32_t LCHNGIP : 1; /*!< [2..2] LINK Signal Change Interrupt Enable                                */
            uint32_t               : 1;
            __IOM uint32_t PSRTOIP : 1; /*!< [4..4] PAUSE Frame Retransmit Over Interrupt Enable                       */
            __IOM uint32_t BFSIPR  : 1; /*!< [5..5] Continuous Broadcast Frame Reception Interrupt Enable              */
            uint32_t               : 26;
        } ECSIPR_b;
    };
    __IM uint32_t RESERVED3;

    union
    {
        __IOM uint32_t PIR;            /*!< (@ 0x00000020) PHY Interface Register                                     */

        struct
        {
            __IOM uint32_t MDC : 1;    /*!< [0..0] MII/RMII Management Data ClockThe MDC bit value is output
                                        *   from the ETn_MDC pin to supply the management data clock
                                        *   to the MII or RMII.                                                       */
            __IOM uint32_t MMD : 1;    /*!< [1..1] MII/RMII Management Mode                                           */
            __IOM uint32_t MDO : 1;    /*!< [2..2] MII/RMII Management Data-OutThe MDO bit value is output
                                        *   from the ETn_MDIO pin when the MMD bit is 1 (write). The
                                        *   value is not output when the MMD bit is 0 (read).                         */
            __IM uint32_t MDI : 1;     /*!< [3..3] MII/RMII Management Data-InThis bit indicates the level
                                        *   of the ETn_MDIO pin. The write value should be 0.                         */
            uint32_t : 28;
        } PIR_b;
    };
    __IM uint32_t RESERVED4;

    union
    {
        __IM uint32_t PSR;             /*!< (@ 0x00000028) PHY Status Register                                        */

        struct
        {
            __IM uint32_t LMON : 1;    /*!< [0..0] ETn_LINKSTA Pin Status FlagThe link status can be read
                                        *   by connecting the link signal output from the PHY-LSI to
                                        *   the ETn_LINKSTA pin. For details on the polarity, refer
                                        *   to the specifications of the connected PHY-LSI.                           */
            uint32_t : 31;
        } PSR_b;
    };
    __IM uint32_t RESERVED5[5];

    union
    {
        __IOM uint32_t RDMLR;          /*!< (@ 0x00000040) Random Number Generation Counter Upper Limit
                                        *                  Setting Register                                           */

        struct
        {
            __IOM uint32_t RMD : 20;   /*!< [19..0] Random Number Generation Counter                                  */
            uint32_t           : 12;
        } RDMLR_b;
    };
    __IM uint32_t RESERVED6[3];

    union
    {
        __IOM uint32_t IPGR;           /*!< (@ 0x00000050) IPG Register                                               */

        struct
        {
            __IOM uint32_t IPG : 5;    /*!< [4..0] Interpacket Gap Range:"16bit time(0x00)"-"140bit time(0x1F)"       */
            uint32_t           : 27;
        } IPGR_b;
    };

    union
    {
        __IOM uint32_t APR;            /*!< (@ 0x00000054) Automatic PAUSE Frame Register                             */

        struct
        {
            __IOM uint32_t AP : 16;    /*!< [15..0] Automatic PAUSE Time SettingThese bits set the value
                                        *   of the pause_time parameter for a PAUSE frame that is automatically
                                        *   transmitted. Transmission is not performed until the set
                                        *   value multiplied by 512 bit time has elapsed.                             */
            uint32_t : 16;
        } APR_b;
    };

    union
    {
        __OM uint32_t MPR;             /*!< (@ 0x00000058) Manual PAUSE Frame Register                                */

        struct
        {
            __OM uint32_t MP : 16;     /*!< [15..0] Manual PAUSE Time SettingThese bits set the value of
                                        *   the pause_time parameter for a PAUSE frame that is manually
                                        *   transmitted. Transmission is not performed until the set
                                        *   value multiplied by 512 bit time has elapsed. The read
                                        *   value is undefined.                                                       */
            uint32_t : 16;
        } MPR_b;
    };
    __IM uint32_t RESERVED7;

    union
    {
        __IM uint32_t RFCF;            /*!< (@ 0x00000060) Received PAUSE Frame Counter                               */

        struct
        {
            __IM uint32_t RPAUSE : 8;  /*!< [7..0] Received PAUSE Frame CountNumber of received PAUSE frames          */
            uint32_t             : 24;
        } RFCF_b;
    };

    union
    {
        __IOM uint32_t TPAUSER;         /*!< (@ 0x00000064) PAUSE Frame Retransmit Count Setting Register              */

        struct
        {
            __IOM uint32_t TPAUSE : 16; /*!< [15..0] Automatic PAUSE Frame Retransmit Setting                          */
            uint32_t              : 16;
        } TPAUSER_b;
    };
    __IM uint32_t TPAUSECR;             /*!< (@ 0x00000068) PAUSE Frame Retransmit Counter                             */

    union
    {
        __IOM uint32_t BCFRR;           /*!< (@ 0x0000006C) Broadcast Frame Receive Count Setting Register             */

        struct
        {
            __IOM uint32_t BCF : 16;    /*!< [15..0] Broadcast Frame Continuous Receive Count Setting                  */
            uint32_t           : 16;
        } BCFRR_b;
    };
    __IM uint32_t RESERVED8[20];

    union
    {
        __IOM uint32_t MAHR;           /*!< (@ 0x000000C0) MAC Address Upper Bit Register                             */

        struct
        {
            __IOM uint32_t MAHR : 32;  /*!< [31..0] MAC Address Upper Bit RegisterThe MAHR register sets
                                        *   the upper 32 bits (b47 to b16) of the 48-bit MAC address.                 */
        } MAHR_b;
    };
    __IM uint32_t RESERVED9;

    union
    {
        __IOM uint32_t MALR;           /*!< (@ 0x000000C8) MAC Address Lower Bit Register                             */

        struct
        {
            __IOM uint32_t MALR : 16;  /*!< [15..0] MAC Address Lower Bit RegisterThe MALR register sets
                                        *   the lower 16 bits of the 48-bit MAC address.                              */
            uint32_t : 16;
        } MALR_b;
    };
    __IM uint32_t RESERVED10;

    union
    {
        __IOM uint32_t TROCR;          /*!< (@ 0x000000D0) Transmit Retry Over Counter Register                       */

        struct
        {
            __IOM uint32_t TROCR : 32; /*!< [31..0] Transmit Retry Over Counter RegisterThe TROCR register
                                        *   is a counter indicating the number of frames that fail
                                        *   to be retransmitted.                                                      */
        } TROCR_b;
    };
    __IOM uint32_t CDCR;               /*!< (@ 0x000000D4) Late Collision Detect Counter Register                     */

    union
    {
        __IOM uint32_t LCCR;           /*!< (@ 0x000000D8) Lost Carrier Counter Register                              */

        struct
        {
            __IOM uint32_t LCCR : 32;  /*!< [31..0] Lost Carrier Counter RegisterThe LCCR register is a
                                        *   counter indicating the number of times a loss of carrier
                                        *   is detected during frame transmission.                                    */
        } LCCR_b;
    };

    union
    {
        __IOM uint32_t CNDCR;          /*!< (@ 0x000000DC) Carrier Not Detect Counter Register                        */

        struct
        {
            __IOM uint32_t CNDCR : 32; /*!< [31..0] Carrier Not Detect Counter RegisterThe CNDCR register
                                        *   is a counter indicating the number of times a carrier is
                                        *   not detected during preamble transmission.                                */
        } CNDCR_b;
    };
    __IM uint32_t RESERVED11;

    union
    {
        __IOM uint32_t CEFCR;          /*!< (@ 0x000000E4) CRC Error Frame Receive Counter Register                   */

        struct
        {
            __IOM uint32_t CEFCR : 32; /*!< [31..0] CRC Error Frame Receive Counter RegisterThe CEFCR register
                                        *   is a counter indicating the number of received frames where
                                        *   a CRC error has been detected.                                            */
        } CEFCR_b;
    };

    union
    {
        __IOM uint32_t FRECR;          /*!< (@ 0x000000E8) Frame Receive Error Counter Register                       */

        struct
        {
            __IOM uint32_t FRECR : 32; /*!< [31..0] Frame Receive Error Counter RegisterThe FRECR register
                                        *   is a counter indicating the number of times a frame receive
                                        *   error has occurred.                                                       */
        } FRECR_b;
    };

    union
    {
        __IOM uint32_t TSFRCR;          /*!< (@ 0x000000EC) Too-Short Frame Receive Counter Register                   */

        struct
        {
            __IOM uint32_t TSFRCR : 32; /*!< [31..0] Too-Short Frame Receive Counter RegisterThe TSFRCR register
                                         *   is a counter indicating the number of times a short frame
                                         *   that is shorter than 64 bytes has been received.                          */
        } TSFRCR_b;
    };

    union
    {
        __IOM uint32_t TLFRCR;          /*!< (@ 0x000000F0) Too-Long Frame Receive Counter Register                    */

        struct
        {
            __IOM uint32_t TLFRCR : 32; /*!< [31..0] Too-Long Frame Receive Counter RegisterThe TLFRCR register
                                         *   is a counter indicating the number of times a long frame
                                         *   that is longer than the RFLR register value has been received.            */
        } TLFRCR_b;
    };

    union
    {
        __IOM uint32_t RFCR;           /*!< (@ 0x000000F4) Received Alignment Error Frame Counter Register            */

        struct
        {
            __IOM uint32_t RFCR : 32;  /*!< [31..0] Received Alignment Error Frame Counter RegisterThe RFCR
                                        *   register is a counter indicating the number of times a
                                        *   frame has been received with the alignment error (frame
                                        *   is not an integral number of octets).                                     */
        } RFCR_b;
    };

    union
    {
        __IOM uint32_t MAFCR;          /*!< (@ 0x000000F8) Multicast Address Frame Receive Counter Register           */

        struct
        {
            __IOM uint32_t MAFCR : 32; /*!< [31..0] Multicast Address Frame Receive Counter RegisterThe
                                        *   MAFCR register is a counter indicating the number of times
                                        *   a frame where the multicast address is set has been received.             */
        } MAFCR_b;
    };
} R_ETHERC0_Type;                      /*!< Size = 252 (0xfc)                                                         */

/* =========================================================================================================================== */
/* ================                                      R_ETHERC_EDMAC                                       ================ */
/* =========================================================================================================================== */

/**
 * @brief Ethernet DMA Controller (R_ETHERC_EDMAC)
 */

typedef struct                         /*!< (@ 0x40064000) R_ETHERC_EDMAC Structure                                   */
{
    union
    {
        __IOM uint32_t EDMR;           /*!< (@ 0x00000000) EDMAC Mode Register                                        */

        struct
        {
            __OM uint32_t SWR : 1;     /*!< [0..0] Software Reset                                                     */
            uint32_t          : 3;
            __IOM uint32_t DL : 2;     /*!< [5..4] Transmit/Receive DescriptorLength                                  */
            __IOM uint32_t DE : 1;     /*!< [6..6] Big Endian Mode/Little Endian ModeNOTE: This setting
                                        *   applies to data for the transmit/receive buffer. It does
                                        *   not apply to transmit/receive descriptors and registers.                  */
            uint32_t : 25;
        } EDMR_b;
    };
    __IM uint32_t RESERVED;

    union
    {
        __IOM uint32_t EDTRR;          /*!< (@ 0x00000008) EDMAC Transmit Request Register                            */

        struct
        {
            __OM uint32_t TR : 1;      /*!< [0..0] Transmit Request                                                   */
            uint32_t         : 31;
        } EDTRR_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __IOM uint32_t EDRRR;          /*!< (@ 0x00000010) EDMAC Receive Request Register                             */

        struct
        {
            __IOM uint32_t RR : 1;     /*!< [0..0] Receive Request                                                    */
            uint32_t          : 31;
        } EDRRR_b;
    };
    __IM uint32_t RESERVED2;

    union
    {
        __IOM uint32_t TDLAR;          /*!< (@ 0x00000018) Transmit Descriptor List Start Address Register            */

        struct
        {
            __IOM uint32_t TDLAR : 32; /*!< [31..0] The start address of the transmit descriptor list is
                                        *   set. Set the start address according to the descriptor
                                        *   length selected by the EDMR.DL[1:0] bits.16-byte boundary:
                                        *   Lower 4 bits = 0000b32-byte boundary: Lower 5 bits = 00000b64-byte
                                        *   boundary: Lower 6 bits = 000000b                                          */
        } TDLAR_b;
    };
    __IM uint32_t RESERVED3;

    union
    {
        __IOM uint32_t RDLAR;          /*!< (@ 0x00000020) Receive Descriptor List Start Address Register             */

        struct
        {
            __IOM uint32_t RDLAR : 32; /*!< [31..0] The start address of the receive descriptor list is
                                        *   set. Set the start address according to the descriptor
                                        *   length selected by the EDMR.DL[1:0] bits.16-byte boundary:
                                        *   Lower 4 bits = 0000b32-byte boundary: Lower 5 bits = 00000b64-byte
                                        *   boundary: Lower 6 bits = 000000b                                          */
        } RDLAR_b;
    };
    __IM uint32_t RESERVED4;

    union
    {
        __IOM uint32_t EESR;           /*!< (@ 0x00000028) ETHERC/EDMAC Status Register                               */

        struct
        {
            __IOM uint32_t CERF : 1;   /*!< [0..0] CRC Error Flag                                                     */
            __IOM uint32_t PRE  : 1;   /*!< [1..1] PHY-LSI Receive Error Flag                                         */
            __IOM uint32_t RTSF : 1;   /*!< [2..2] Frame-Too-Short Error Flag                                         */
            __IOM uint32_t RTLF : 1;   /*!< [3..3] Frame-Too-Long Error Flag                                          */
            __IOM uint32_t RRF  : 1;   /*!< [4..4] Alignment Error Flag                                               */
            uint32_t            : 2;
            __IOM uint32_t RMAF : 1;   /*!< [7..7] Multicast Address Frame Receive Flag                               */
            __IOM uint32_t TRO  : 1;   /*!< [8..8] Transmit Retry Over Flag                                           */
            __IOM uint32_t CD   : 1;   /*!< [9..9] Late Collision Detect Flag                                         */
            __IOM uint32_t DLC  : 1;   /*!< [10..10] Loss of Carrier Detect Flag                                      */
            __IOM uint32_t CND  : 1;   /*!< [11..11] Carrier Not Detect Flag                                          */
            uint32_t            : 4;
            __IOM uint32_t RFOF : 1;   /*!< [16..16] Receive FIFO Overflow Flag                                       */
            __IOM uint32_t RDE  : 1;   /*!< [17..17] Receive Descriptor Empty Flag                                    */
            __IOM uint32_t FR   : 1;   /*!< [18..18] Frame Receive Flag                                               */
            __IOM uint32_t TFUF : 1;   /*!< [19..19] Transmit FIFO Underflow Flag                                     */
            __IOM uint32_t TDE  : 1;   /*!< [20..20] Transmit Descriptor Empty Flag                                   */
            __IOM uint32_t TC   : 1;   /*!< [21..21] Frame Transfer Complete Flag                                     */
            __IM uint32_t  ECI  : 1;   /*!< [22..22] ETHERC Status Register Source FlagNOTE: When the source
                                        *   in the ETHERCn.ECSR register is cleared, the ECI flag is
                                        *   also cleared.                                                             */
            __IOM uint32_t ADE   : 1;  /*!< [23..23] Address Error Flag                                               */
            __IOM uint32_t RFCOF : 1;  /*!< [24..24] Receive Frame Counter Overflow Flag                              */
            __IOM uint32_t RABT  : 1;  /*!< [25..25] Receive Abort Detect Flag                                        */
            __IOM uint32_t TABT  : 1;  /*!< [26..26] Transmit Abort Detect Flag                                       */
            uint32_t             : 3;
            __IOM uint32_t TWB   : 1;  /*!< [30..30] Write-Back Complete Flag                                         */
            uint32_t             : 1;
        } EESR_b;
    };
    __IM uint32_t RESERVED5;

    union
    {
        __IOM uint32_t EESIPR;          /*!< (@ 0x00000030) ETHERC/EDMAC Status Interrupt Enable Register              */

        struct
        {
            __IOM uint32_t CERFIP  : 1; /*!< [0..0] CRC Error Interrupt Request Enable                                 */
            __IOM uint32_t PREIP   : 1; /*!< [1..1] PHY-LSI Receive Error Interrupt Request Enable                     */
            __IOM uint32_t RTSFIP  : 1; /*!< [2..2] Frame-Too-Short Error Interrupt Request Enable                     */
            __IOM uint32_t RTLFIP  : 1; /*!< [3..3] Frame-Too-Long Error Interrupt Request Enable                      */
            __IOM uint32_t RRFIP   : 1; /*!< [4..4] Alignment Error Interrupt Request Enable                           */
            uint32_t               : 2;
            __IOM uint32_t RMAFIP  : 1; /*!< [7..7] Multicast Address Frame Receive Interrupt Request Enable           */
            __IOM uint32_t TROIP   : 1; /*!< [8..8] Transmit Retry Over Interrupt Request Enable                       */
            __IOM uint32_t CDIP    : 1; /*!< [9..9] Late Collision Detect Interrupt Request Enable                     */
            __IOM uint32_t DLCIP   : 1; /*!< [10..10] Loss of Carrier Detect Interrupt Request Enable                  */
            __IOM uint32_t CNDIP   : 1; /*!< [11..11] Carrier Not Detect Interrupt Request Enable                      */
            uint32_t               : 4;
            __IOM uint32_t RFOFIP  : 1; /*!< [16..16] Receive FIFO Overflow Interrupt Request Enable                   */
            __IOM uint32_t RDEIP   : 1; /*!< [17..17] Receive Descriptor Empty Interrupt Request Enable                */
            __IOM uint32_t FRIP    : 1; /*!< [18..18] Frame Receive Interrupt Request Enable                           */
            __IOM uint32_t TFUFIP  : 1; /*!< [19..19] Transmit FIFO Underflow Interrupt Request Enable                 */
            __IOM uint32_t TDEIP   : 1; /*!< [20..20] Transmit Descriptor Empty Interrupt Request Enable               */
            __IOM uint32_t TCIP    : 1; /*!< [21..21] Frame Transfer Complete Interrupt Request Enable                 */
            __IOM uint32_t ECIIP   : 1; /*!< [22..22] ETHERC Status Register Source Interrupt Request Enable           */
            __IOM uint32_t ADEIP   : 1; /*!< [23..23] Address Error Interrupt Request Enable                           */
            __IOM uint32_t RFCOFIP : 1; /*!< [24..24] Receive Frame Counter Overflow Interrupt Request Enable          */
            __IOM uint32_t RABTIP  : 1; /*!< [25..25] Receive Abort Detect Interrupt Request Enable                    */
            __IOM uint32_t TABTIP  : 1; /*!< [26..26] Transmit Abort Detect Interrupt Request Enable                   */
            uint32_t               : 3;
            __IOM uint32_t TWBIP   : 1; /*!< [30..30] Write-Back Complete Interrupt Request Enable                     */
            uint32_t               : 1;
        } EESIPR_b;
    };
    __IM uint32_t RESERVED6;

    union
    {
        __IOM uint32_t TRSCER;         /*!< (@ 0x00000038) ETHERC/EDMAC Transmit/Receive Status Copy Enable
                                        *                  Register                                                   */

        struct
        {
            uint32_t              : 4;
            __IOM uint32_t RRFCE  : 1; /*!< [4..4] RRF Flag Copy Enable                                               */
            uint32_t              : 2;
            __IOM uint32_t RMAFCE : 1; /*!< [7..7] RMAF Flag Copy Enable                                              */
            uint32_t              : 24;
        } TRSCER_b;
    };
    __IM uint32_t RESERVED7;

    union
    {
        __IOM uint32_t RMFCR;          /*!< (@ 0x00000040) Missed-Frame Counter Register                              */

        struct
        {
            __IOM uint32_t MFC : 16;   /*!< [15..0] Missed-Frame CounterThese bits indicate the number of
                                        *   frames that are discarded and not transferred to the receive
                                        *   buffer during reception.                                                  */
            uint32_t : 16;
        } RMFCR_b;
    };
    __IM uint32_t RESERVED8;

    union
    {
        __IOM uint32_t TFTR;           /*!< (@ 0x00000048) Transmit FIFO Threshold Register                           */

        struct
        {
            __IOM uint32_t TFT : 11;   /*!< [10..0] Transmit FIFO Threshold00Dh to 200h: The threshold is
                                        *   the set value multiplied by 4. Example: 00Dh: 52 bytes
                                        *   040h: 256 bytes 100h: 1024 bytes 200h: 2048 bytes                         */
            uint32_t : 21;
        } TFTR_b;
    };
    __IM uint32_t RESERVED9;

    union
    {
        __IOM uint32_t FDR;            /*!< (@ 0x00000050) Transmit FIFO Threshold Register                           */

        struct
        {
            __IOM uint32_t RFD : 5;    /*!< [4..0] Transmit FIFO Depth                                                */
            uint32_t           : 3;
            __IOM uint32_t TFD : 5;    /*!< [12..8] Receive FIFO Depth                                                */
            uint32_t           : 19;
        } FDR_b;
    };
    __IM uint32_t RESERVED10;

    union
    {
        __IOM uint32_t RMCR;           /*!< (@ 0x00000058) Receive Method Control Register                            */

        struct
        {
            __IOM uint32_t RNR : 1;    /*!< [0..0] Receive Request Reset                                              */
            uint32_t           : 31;
        } RMCR_b;
    };
    __IM uint32_t RESERVED11[2];

    union
    {
        __IOM uint32_t TFUCR;          /*!< (@ 0x00000064) Transmit FIFO Underflow Counter                            */

        struct
        {
            __IOM uint32_t UNDER : 16; /*!< [15..0] Transmit FIFO Underflow CountThese bits indicate how
                                        *   many times the transmit FIFO has underflowed. The counter
                                        *   stops when the counter value reaches FFFFh.                               */
            uint32_t : 16;
        } TFUCR_b;
    };

    union
    {
        __IOM uint32_t RFOCR;          /*!< (@ 0x00000068) Receive FIFO Overflow Counter                              */

        struct
        {
            __IOM uint32_t OVER : 16;  /*!< [15..0] Receive FIFO Overflow CountThese bits indicate how many
                                        *   times the receive FIFO has overflowed. The counter stops
                                        *   when the counter value reaches FFFFh.                                     */
            uint32_t : 16;
        } RFOCR_b;
    };

    union
    {
        __IOM uint32_t IOSR;           /*!< (@ 0x0000006C) Independent Output Signal Setting Register                 */

        struct
        {
            __IOM uint32_t ELB : 1;    /*!< [0..0] External Loopback Mode                                             */
            uint32_t           : 31;
        } IOSR_b;
    };

    union
    {
        __IOM uint32_t FCFTR;          /*!< (@ 0x00000070) Flow Control Start FIFO Threshold Setting Register         */

        struct
        {
            __IOM uint32_t RFDO : 3;   /*!< [2..0] Receive FIFO Data PAUSE Output Threshold(When (RFDO+1)x256-32
                                        *   bytes of data is stored in the receive FIFO.)                             */
            uint32_t            : 13;
            __IOM uint32_t RFFO : 3;   /*!< [18..16] Receive FIFO Frame PAUSE Output Threshold(When ((RFFO+1)x2)
                                        *   receive frames have been stored in the receive FIFO.)                     */
            uint32_t : 13;
        } FCFTR_b;
    };
    __IM uint32_t RESERVED12;

    union
    {
        __IOM uint32_t RPADIR;         /*!< (@ 0x00000078) Receive Data Padding Insert Register                       */

        struct
        {
            __IOM uint32_t PADR : 6;   /*!< [5..0] Padding Slot                                                       */
            uint32_t            : 10;
            __IOM uint32_t PADS : 2;   /*!< [17..16] Padding Size                                                     */
            uint32_t            : 14;
        } RPADIR_b;
    };

    union
    {
        __IOM uint32_t TRIMD;          /*!< (@ 0x0000007C) Transmit Interrupt Setting Register                        */

        struct
        {
            __IOM uint32_t TIS : 1;    /*!< [0..0] Transmit Interrupt EnableSet the EESR.TWB flag to 1 in
                                        *   the mode selected by the TIM bit to notify an interrupt.                  */
            uint32_t           : 3;
            __IOM uint32_t TIM : 1;    /*!< [4..4] Transmit Interrupt Mode                                            */
            uint32_t           : 27;
        } TRIMD_b;
    };
    __IM uint32_t RESERVED13[18];

    union
    {
        __IOM uint32_t RBWAR;          /*!< (@ 0x000000C8) Receive Buffer Write Address Register                      */

        struct
        {
            __IM uint32_t RBWAR : 32;  /*!< [31..0] Receive Buffer Write Address RegisterThe RBWAR register
                                        *   indicates the last address that the EDMAC has written data
                                        *   to when writing to the receive buffer.Refer to the address
                                        *   indicated by the RBWAR register to recognize which address
                                        *   in the receive buffer the EDMAC is writing data to. Note
                                        *   that the address that the EDMAC is outputting to the receive
                                        *   buffer may not match the read value of the RBWAR register
                                        *   during data reception.                                                    */
        } RBWAR_b;
    };

    union
    {
        __IOM uint32_t RDFAR;          /*!< (@ 0x000000CC) Receive Descriptor Fetch Address Register                  */

        struct
        {
            __IM uint32_t RDFAR : 32;  /*!< [31..0] Receive Descriptor Fetch Address RegisterThe RDFAR register
                                        *   indicates the start address of the last fetched receive
                                        *   descriptor when the EDMAC fetches descriptor information
                                        *   from the receive descriptor.Refer to the address indicated
                                        *   by the RDFAR register to recognize which receive descriptor
                                        *   information the EDMAC is using for the current processing.
                                        *   Note that the address of the receive descriptor that the
                                        *   EDMAC fetches may not match the read value of the RDFAR
                                        *   register during data reception.                                           */
        } RDFAR_b;
    };
    __IM uint32_t RESERVED14;

    union
    {
        __IOM uint32_t TBRAR;          /*!< (@ 0x000000D4) Transmit Buffer Read Address Register                      */

        struct
        {
            __IM uint32_t TBRAR : 32;  /*!< [31..0] Transmit Buffer Read Address RegisterThe TBRAR register
                                        *   indicates the last address that the EDMAC has read data
                                        *   from when reading data from the transmit buffer.Refer to
                                        *   the address indicated by the TBRAR register to recognize
                                        *   which address in the transmit buffer the EDMAC is reading
                                        *   from. Note that the address that the EDMAC is outputting
                                        *   to the transmit buffer may not match the read value of
                                        *   the TBRAR register.                                                       */
        } TBRAR_b;
    };

    union
    {
        __IM uint32_t TDFAR;           /*!< (@ 0x000000D8) Transmit Descriptor Fetch Address Register                 */

        struct
        {
            __IM uint32_t TDFAR : 32;  /*!< [31..0] Transmit Descriptor Fetch Address RegisterThe TDFAR
                                        *   register indicates the start address of the last fetched
                                        *   transmit descriptor when the EDMAC fetches descriptor information
                                        *   from the transmit descriptor.Refer to the address indicated
                                        *   by the TDFAR register to recognize which transmit descriptor
                                        *   information the EDMAC is using for the current processing.
                                        *   Note that the address of the transmit descriptor that the
                                        *   EDMAC fetches may not match the read value of the TDFAR
                                        *   register.                                                                 */
        } TDFAR_b;
    };
} R_ETHERC_EDMAC_Type;                 /*!< Size = 220 (0xdc)                                                         */

/* =========================================================================================================================== */
/* ================                                      R_ETHERC_EPTPC                                       ================ */
/* =========================================================================================================================== */

/**
 * @brief Ethernet PTP Controller (R_ETHERC_EPTPC)
 */

typedef struct                         /*!< (@ 0x40065800) R_ETHERC_EPTPC Structure                                   */
{
    union
    {
        __IOM uint32_t SYSR;           /*!< (@ 0x00000000) SYNFP Status Register                                      */

        struct
        {
            __IOM uint32_t OFMUD  : 1; /*!< [0..0] offsetFromMaster Value Update Flag                                 */
            __IOM uint32_t INTCHG : 1; /*!< [1..1] Receive logMessageInterval Value Change Detection Flag             */
            __IOM uint32_t MPDUD  : 1; /*!< [2..2] meanPathDelay Value Update Flag                                    */
            uint32_t              : 1;
            __IOM uint32_t DRPTO  : 1; /*!< [4..4] Delay_Resp/Pdelay_Resp Reception Timeout Detection Flag            */
            __IOM uint32_t INTDEV : 1; /*!< [5..5] Receive logMessageInterval Value Out-of-Range Flag                 */
            __IOM uint32_t DRQOVR : 1; /*!< [6..6] Delay_Req Reception FIFO Overflow Detection Flag                   */
            uint32_t              : 5;
            __IOM uint32_t RECLP  : 1; /*!< [12..12] Loop Reception Detection Flag                                    */
            uint32_t              : 1;
            __IOM uint32_t INFABT : 1; /*!< [14..14] Control Information Abnormality Detection Flag                   */
            uint32_t              : 1;
            __IOM uint32_t RESDN  : 1; /*!< [16..16] Response Stop Completion Detection Flag                          */
            __IOM uint32_t GENDN  : 1; /*!< [17..17] Generation Stop Completion Detection Flag                        */
            uint32_t              : 14;
        } SYSR_b;
    };

    union
    {
        __IOM uint32_t SYIPR;          /*!< (@ 0x00000004) SYNFP Status Notification Permission Register              */

        struct
        {
            __IOM uint32_t OFMUD  : 1; /*!< [0..0] SYSR.OFMUD Status Notification Permission                          */
            __IOM uint32_t INTCHG : 1; /*!< [1..1] SYSR.INTCHG Status Notification Permission                         */
            __IOM uint32_t MPDUD  : 1; /*!< [2..2] SYSR.MPDUD Status Notification Permission                          */
            uint32_t              : 1;
            __IOM uint32_t DRPTO  : 1; /*!< [4..4] SYSR.DRPTO Status Notification Permission                          */
            __IOM uint32_t INTDEV : 1; /*!< [5..5] SYSR.INTDEV Status Notification Permission                         */
            __IOM uint32_t DRQOVR : 1; /*!< [6..6] SYSR.DRQOVR Status Notification Permission                         */
            uint32_t              : 5;
            __IOM uint32_t RECLP  : 1; /*!< [12..12] SYSR.RECLP Status Notification Permission                        */
            uint32_t              : 1;
            __IOM uint32_t INFABT : 1; /*!< [14..14] SYSR.INFABT Status Notification Permission                       */
            uint32_t              : 1;
            __IOM uint32_t RESDN  : 1; /*!< [16..16] SYSR.RESDN Status Notification Permission                        */
            __IOM uint32_t GENDN  : 1; /*!< [17..17] SYSR.GENDN Status Notification Permission                        */
            uint32_t              : 14;
        } SYIPR_b;
    };
    __IM uint32_t RESERVED[2];

    union
    {
        __IOM uint32_t SYMACRU;          /*!< (@ 0x00000010) SYNFP MAC Address Registers                                */

        struct
        {
            __IOM uint32_t SYMACRU : 24; /*!< [23..0] These bits hold the setting for the higher-order 24
                                          *   bits of the local MAC address.                                            */
            uint32_t : 8;
        } SYMACRU_b;
    };

    union
    {
        __IOM uint32_t SYMACRL;          /*!< (@ 0x00000014) SYNFP MAC Address Registers                                */

        struct
        {
            __IOM uint32_t SYMACRL : 24; /*!< [23..0] These bits hold the setting for the lower-order 24 bits
                                          *   of the local MAC address.                                                 */
            uint32_t : 8;
        } SYMACRL_b;
    };

    union
    {
        __IOM uint32_t SYLLCCTLR;      /*!< (@ 0x00000018) SYNFP LLC-CTL Value Register                               */

        struct
        {
            __IOM uint32_t CTL : 8;    /*!< [7..0] LLC-CTL FieldThese bits specify the value used for the
                                        *   control field in the LLC sublayer when generating IEEE802.3
                                        *   frames.                                                                   */
            uint32_t : 24;
        } SYLLCCTLR_b;
    };

    union
    {
        __IOM uint32_t SYIPADDRR;          /*!< (@ 0x0000001C) SYNFP Local IP Address Register                            */

        struct
        {
            __IOM uint32_t SYIPADDRR : 32; /*!< [31..0] These bits hold the setting for the local IP address.             */
        } SYIPADDRR_b;
    };
    __IM uint32_t RESERVED1[8];

    union
    {
        __IOM uint32_t SYSPVRR;        /*!< (@ 0x00000040) SYNFP Specification Version Setting Register               */

        struct
        {
            __IOM uint32_t VER : 4;    /*!< [3..0] versionPTP Field ValueThese bits are used to set the
                                        *   versionPTP field value of the PTP v2 header.When a message
                                        *   is received, this value is compared with the versionPTP
                                        *   field of the received frame.In generating messages, the
                                        *   value is used for the versionPTP field of the frame for
                                        *   transmission.Set these bits to 0010b (PTP v2).                            */
            __IOM uint32_t TRSP : 4;   /*!< [7..4] transportSpecific Field ValueThese bits are used to set
                                        *   the transportSpecific field value of the PTP v2 header.When
                                        *   a message is received, this value is compared with the
                                        *   transportSpecific field of the received frame.In generating
                                        *   messages, the value is used for the transportSpecific field
                                        *   of the frame for transmission.Set these bits to 0000b (IEEE
                                        *   1588).                                                                    */
            uint32_t : 24;
        } SYSPVRR_b;
    };

    union
    {
        __IOM uint32_t SYDOMR;         /*!< (@ 0x00000044) SYNFP Domain Number Setting Register                       */

        struct
        {
            __IOM uint32_t DNUM : 8;   /*!< [7..0] domainNumber Field Value SettingThese bits are used to
                                        *   set the domainNumber field value of the PTP v2 header.When
                                        *   a message is received, this value is compared with the
                                        *   domainNumber field of the received frame as a condition
                                        *   for PTP reception processing.In generating messages, the
                                        *   value is used for the domainNumber field of the frame for
                                        *   transmission.                                                             */
            uint32_t : 24;
        } SYDOMR_b;
    };
    __IM uint32_t RESERVED2[2];

    union
    {
        __IOM uint32_t ANFR;           /*!< (@ 0x00000050) Announce Message Flag Field Setting Register               */

        struct
        {
            __IOM uint32_t FLAG0 : 1;  /*!< [0..0] leap61This bit is used to set the logical value of the
                                        *   leap61 member of timePropertiesDS.                                        */
            __IOM uint32_t FLAG1 : 1;  /*!< [1..1] leap59This bit is used to set the logical value of the
                                        *   leap59 member of timePropertiesDS.                                        */
            __IOM uint32_t FLAG2 : 1;  /*!< [2..2] currentUtcOffsetValidThis bit is used to set the logical
                                        *   value of the currentUtcOffsetValid member of timePropertiesDS.            */
            __IOM uint32_t FLAG3 : 1;  /*!< [3..3] ptpTimescaleThis bit is used to set the logical value
                                        *   of the ptpTimescale member of timePropertiesDS.                           */
            __IOM uint32_t FLAG4 : 1;  /*!< [4..4] timeTraceableThis bit is used to set the logical value
                                        *   of the timeTraceable member of timePropertiesDS.                          */
            __IOM uint32_t FLAG5 : 1;  /*!< [5..5] frequencyTraceableThis bit is used to set the logical
                                        *   value of the frequencyTraceable member of timePropertiesDS.               */
            uint32_t              : 2;
            __IOM uint32_t FLAG8  : 1; /*!< [8..8] alternateMasterFlag                                                */
            uint32_t              : 1;
            __IOM uint32_t FLAG10 : 1; /*!< [10..10] unicastFlag                                                      */
            uint32_t              : 2;
            __IOM uint32_t FLAG13 : 1; /*!< [13..13] PTP profile Specific 1                                           */
            __IOM uint32_t FLAG14 : 1; /*!< [14..14] PTP profile Specific 2                                           */
            uint32_t              : 17;
        } ANFR_b;
    };

    union
    {
        __IOM uint32_t SYNFR;          /*!< (@ 0x00000054) Sync Message Flag Field Setting Register                   */

        struct
        {
            uint32_t              : 8;
            __IOM uint32_t FLAG8  : 1; /*!< [8..8] alternateMasterFlag                                                */
            __IOM uint32_t FLAG9  : 1; /*!< [9..9] twoStepFlag                                                        */
            __IOM uint32_t FLAG10 : 1; /*!< [10..10] unicastFlag                                                      */
            uint32_t              : 2;
            __IOM uint32_t FLAG13 : 1; /*!< [13..13] PTP profile Specific 1                                           */
            __IOM uint32_t FLAG14 : 1; /*!< [14..14] PTP profile Specific 2                                           */
            uint32_t              : 17;
        } SYNFR_b;
    };

    union
    {
        __IOM uint32_t DYRQFR;         /*!< (@ 0x00000058) Delay_Req Message Flag Field Setting Register              */

        struct
        {
            uint32_t              : 10;
            __IOM uint32_t FLAG10 : 1; /*!< [10..10] unicastFlag                                                      */
            uint32_t              : 2;
            __IOM uint32_t FLAG13 : 1; /*!< [13..13] PTP profile Specific 1                                           */
            __IOM uint32_t FLAG14 : 1; /*!< [14..14] PTP profile Specific 2                                           */
            uint32_t              : 17;
        } DYRQFR_b;
    };

    union
    {
        __IOM uint32_t DYRPFR;         /*!< (@ 0x0000005C) Delay_Resp Message Flag Field Setting Register             */

        struct
        {
            uint32_t              : 8;
            __IOM uint32_t FLAG8  : 1; /*!< [8..8] alternateMasterFlag                                                */
            __IOM uint32_t FLAG9  : 1; /*!< [9..9] woStepFlag                                                         */
            __IOM uint32_t FLAG10 : 1; /*!< [10..10] unicastFlag                                                      */
            uint32_t              : 2;
            __IOM uint32_t FLAG13 : 1; /*!< [13..13] PTP profile Specific 1                                           */
            __IOM uint32_t FLAG14 : 1; /*!< [14..14] PTP profile Specific 2                                           */
            uint32_t              : 17;
        } DYRPFR_b;
    };

    union
    {
        __IOM uint32_t SYCIDRU;          /*!< (@ 0x00000060) SYNFP Local Clock ID Registers                             */

        struct
        {
            __IOM uint32_t SYCIDRU : 32; /*!< [31..0] These bits hold the setting for the higher-order 32
                                          *   bits of the clock-ID of your port.                                        */
        } SYCIDRU_b;
    };

    union
    {
        __IOM uint32_t SYCIDRL;          /*!< (@ 0x00000064) SYNFP Local Clock ID Registers                             */

        struct
        {
            __IOM uint32_t SYCIDRL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                          *   of the clock-ID of your port.                                             */
        } SYCIDRL_b;
    };

    union
    {
        __IOM uint32_t SYPNUMR;        /*!< (@ 0x00000068) SYNFP Local Port Number Register                           */

        struct
        {
            __IOM uint32_t PNUM : 16;  /*!< [15..0] Local Port Number SettingThese bits hold the setting
                                        *   for the port number of the local port.                                    */
            uint32_t : 16;
        } SYPNUMR_b;
    };
    __IM uint32_t RESERVED3[5];

    union
    {
        __OM uint32_t SYRVLDR;         /*!< (@ 0x00000080) SYNFP Register Value Load Directive Register               */

        struct
        {
            __OM uint32_t BMUP : 1;    /*!< [0..0] BMC Update                                                         */
            __OM uint32_t STUP : 1;    /*!< [1..1] State Update                                                       */
            __OM uint32_t ANUP : 1;    /*!< [2..2] Announce Message Generation Information Update                     */
            uint32_t           : 29;
        } SYRVLDR_b;
    };
    __IM uint32_t RESERVED4[3];

    union
    {
        __IOM uint32_t SYRFL1R;        /*!< (@ 0x00000090) SYNFP Reception Filter Register 1                          */

        struct
        {
            __IOM uint32_t ANCE0  : 1; /*!< [0..0] Announce Message Processing                                        */
            __IOM uint32_t ANCE1  : 1; /*!< [1..1] Announce Message Processing                                        */
            uint32_t              : 2;
            __IOM uint32_t SYNC0  : 1; /*!< [4..4] Sync Message Processing                                            */
            __IOM uint32_t SYNC1  : 1; /*!< [5..5] Sync Message Processing                                            */
            __IOM uint32_t SYNC2  : 1; /*!< [6..6] Sync Message Processing                                            */
            uint32_t              : 1;
            __IOM uint32_t FUP0   : 1; /*!< [8..8] Follow_Up Message Processing                                       */
            __IOM uint32_t FUP1   : 1; /*!< [9..9] Follow_Up Message Processing                                       */
            __IOM uint32_t FUP2   : 1; /*!< [10..10] Follow_Up Message Processing                                     */
            uint32_t              : 1;
            __IOM uint32_t DRQ0   : 1; /*!< [12..12] Delay_Req Message Processing                                     */
            __IOM uint32_t DRQ1   : 1; /*!< [13..13] Delay_Req Message Processing                                     */
            __IOM uint32_t DRQ2   : 1; /*!< [14..14] Delay_Req Message Processing                                     */
            uint32_t              : 1;
            __IOM uint32_t DRP0   : 1; /*!< [16..16] Delay_Resp Message Processing                                    */
            __IOM uint32_t DRP1   : 1; /*!< [17..17] Delay_Resp Message Processing                                    */
            __IOM uint32_t DRP2   : 1; /*!< [18..18] Delay_Resp Message Processing                                    */
            uint32_t              : 1;
            __IOM uint32_t PDRQ0  : 1; /*!< [20..20] Pdelay_Req Message Processing                                    */
            __IOM uint32_t PDRQ1  : 1; /*!< [21..21] Pdelay_Req Message Processing                                    */
            __IOM uint32_t PDRQ2  : 1; /*!< [22..22] Pdelay_Req Message Processing                                    */
            uint32_t              : 1;
            __IOM uint32_t PDRP0  : 1; /*!< [24..24] Pdelay_Resp Message Processing                                   */
            __IOM uint32_t PDRP1  : 1; /*!< [25..25] Pdelay_Resp Message Processing                                   */
            __IOM uint32_t PDRP2  : 1; /*!< [26..26] Pdelay_Resp Message Processing                                   */
            uint32_t              : 1;
            __IOM uint32_t PDFUP0 : 1; /*!< [28..28] Pdelay_Resp_Follow_Up Message Processing                         */
            __IOM uint32_t PDFUP1 : 1; /*!< [29..29] Pdelay_Resp_Follow_Up Message Processing                         */
            __IOM uint32_t PDFUP2 : 1; /*!< [30..30] Pdelay_Resp_Follow_Up Message Processing                         */
            uint32_t              : 1;
        } SYRFL1R_b;
    };

    union
    {
        __IOM uint32_t SYRFL2R;        /*!< (@ 0x00000094) SYNFP Reception Filter Register 2                          */

        struct
        {
            __IOM uint32_t MAN0 : 1;   /*!< [0..0] Management Message Processing Setting                              */
            __IOM uint32_t MAN1 : 1;   /*!< [1..1] Management Message Processing Setting                              */
            uint32_t            : 2;
            __IOM uint32_t SIG0 : 1;   /*!< [4..4] Signaling Message Processing Setting                               */
            __IOM uint32_t SIG1 : 1;   /*!< [5..5] Signaling Message Processing Setting                               */
            uint32_t            : 22;
            __IOM uint32_t ILL0 : 1;   /*!< [28..28] Illegal Message Processing Setting                               */
            __IOM uint32_t ILL1 : 1;   /*!< [29..29] Illegal Message Processing Setting                               */
            uint32_t            : 2;
        } SYRFL2R_b;
    };

    union
    {
        __IOM uint32_t SYTRENR;        /*!< (@ 0x00000098) SYNFP Transmission Enable Register                         */

        struct
        {
            __IOM uint32_t ANCE : 1;   /*!< [0..0] Announce Message Transmission Enable                               */
            uint32_t            : 3;
            __IOM uint32_t SYNC : 1;   /*!< [4..4] Sync Message Transmission Enable                                   */
            uint32_t            : 3;
            __IOM uint32_t DRQ  : 1;   /*!< [8..8] Delay_Req Message Transmission Enable                              */
            uint32_t            : 3;
            __IOM uint32_t PDRQ : 1;   /*!< [12..12] Pdelay_Req Message Transmission Enable                           */
            uint32_t            : 19;
        } SYTRENR_b;
    };
    __IM uint32_t RESERVED5;

    union
    {
        __IOM uint32_t MTCIDU;          /*!< (@ 0x000000A0) Master Clock ID Registers                                  */

        struct
        {
            __IOM uint32_t MTCIDU : 32; /*!< [31..0] These bits hold the setting for the higher-order 32
                                         *   bits of the clock-ID of the master clock.                                 */
        } MTCIDU_b;
    };

    union
    {
        __IOM uint32_t MTCIDL;          /*!< (@ 0x000000A4) Master Clock ID Registers                                  */

        struct
        {
            __IOM uint32_t MTCIDL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                         *   of the clock-ID of the master clock.                                      */
        } MTCIDL_b;
    };

    union
    {
        __IOM uint32_t MTPID;          /*!< (@ 0x000000A8) Master clock port number register                          */

        struct
        {
            __IOM uint32_t PNUM : 16;  /*!< [15..0] Master Clock Port Number SettingThese bits hold the
                                        *   setting for the port number of the master clock.                          */
            uint32_t : 16;
        } MTPID_b;
    };
    __IM uint32_t RESERVED6[5];

    union
    {
        __IOM uint32_t SYTLIR;         /*!< (@ 0x000000C0) SYNFP Transmission Interval Setting Register               */

        struct
        {
            __IOM uint32_t ANCE : 8;   /*!< [7..0] Announce Message Transmission Interval SettingThese bits
                                        *   set the interval for the transmission of Announce messages.               */
            __IOM uint32_t SYNC : 8;   /*!< [15..8] Sync Message Transmission Interval SettingThese bits
                                        *   set the interval for the transmission of Sync messages.
                                        *   The setting is also placed in the logMessageInterval field
                                        *   of transmitted Sync messages.                                             */
            __IOM uint32_t DREQ : 8;   /*!< [23..16] Delay_Req Transmission Interval Average Value/ Pdelay_Req
                                        *   Transmission Interval SettingThe bits set the average interval
                                        *   for the transmission of Delay_Req messages and the interval
                                        *   for the transmission of Pdelay_Req messages.The setting
                                        *   is also placed in the logMessageInterval field of Delay_Resp
                                        *   messages.                                                                 */
            uint32_t : 8;
        } SYTLIR_b;
    };

    union
    {
        __IM uint32_t SYRLIR;          /*!< (@ 0x000000C4) SYNFP Received logMessageInterval Value Indication
                                        *                  Register                                                   */

        struct
        {
            __IM uint32_t ANCE : 8;    /*!< [7..0] Announce Message logMessageInterval Field IndicationThese
                                        *   bits indicate the logMessageInterval field value of a received
                                        *   Announce message.                                                         */
            __IM uint32_t SYNC : 8;    /*!< [15..8] Sync Message logMessageInterval Field IndicationThese
                                        *   bits indicate the logMessageInterval field value of a received
                                        *   Sync message.                                                             */
            __IM uint32_t DRESP : 8;   /*!< [23..16] Delay_Resp Message logMessageInterval Field IndicationThese
                                        *   bits indicate the logMessageInterval field value of a received
                                        *   Delay_Resp message.                                                       */
            uint32_t : 8;
        } SYRLIR_b;
    };

    union
    {
        __IM uint32_t OFMRU;           /*!< (@ 0x000000C8) offsetFromMaster Value Registers                           */

        struct
        {
            __IM uint32_t OFMRU : 32;  /*!< [31..0] These bits indicate the higher-order 32 bits of the
                                        *   calculated offsetFromMaster value.                                        */
        } OFMRU_b;
    };

    union
    {
        __IM uint32_t OFMRL;           /*!< (@ 0x000000CC) offsetFromMaster Value Registers                           */

        struct
        {
            __IM uint32_t OFMRL : 32;  /*!< [31..0] These bits indicate the lower-order 32 bits of the calculated
                                        *   offsetFromMaster value.                                                   */
        } OFMRL_b;
    };

    union
    {
        __IM uint32_t MPDRU;           /*!< (@ 0x000000D0) meanPathDelay Value Registers                              */

        struct
        {
            __IM uint32_t MPDRU : 32;  /*!< [31..0] These bits indicate the higher-order 32 bits of the
                                        *   calculated meanPathDelay value.                                           */
        } MPDRU_b;
    };

    union
    {
        __IM uint32_t MPDRL;           /*!< (@ 0x000000D4) meanPathDelay Value Registers                              */

        struct
        {
            __IM uint32_t MPDRL : 32;  /*!< [31..0] These bits indicate the lower-order 32 bits of the calculated
                                        *   meanPathDelay value.                                                      */
        } MPDRL_b;
    };
    __IM uint32_t RESERVED7[2];

    union
    {
        __IOM uint32_t GMPR;           /*!< (@ 0x000000E0) grandmasterPriority Field Setting Register                 */

        struct
        {
            __IOM uint32_t GMPR2 : 8;  /*!< [7..0] grandmasterPriority2 Field Value SettingThese bits are
                                        *   used to set the value of the grandmasterPriority2 fields
                                        *   of Announce messages.                                                     */
            uint32_t             : 8;
            __IOM uint32_t GMPR1 : 8;  /*!< [23..16] grandmasterPriority1 Field Value SettingThese bits
                                        *   are used to set the value of the grandmasterPriority1 fields
                                        *   of Announce messages.                                                     */
            uint32_t : 8;
        } GMPR_b;
    };

    union
    {
        __IOM uint32_t GMCQR;          /*!< (@ 0x000000E4) grandmasterClockQuality Field Setting Register             */

        struct
        {
            __IOM uint32_t GMCQR : 32; /*!< [31..0] These bits are used to set the value of the grandmasterClockQuality
                                        *   fields of Announce messages. The correspondence between
                                        *   bits and the grandmasterClockQuality fields is as listed
                                        *   below.b31 to b24: clockClassb23 to b16: clockAccuracyb15
                                        *   to b0: offsetScaledLogVariance                                            */
        } GMCQR_b;
    };

    union
    {
        __IOM uint32_t GMIDRU;          /*!< (@ 0x000000E8) grandmasterIdentity Field Setting Registers                */

        struct
        {
            __IOM uint32_t GMIDRU : 32; /*!< [31..0] These bits hold the setting for the higher-order 32
                                         *   bits of the value of the grandmasterIdentity fields of
                                         *   Announce messages.                                                        */
        } GMIDRU_b;
    };

    union
    {
        __IOM uint32_t GMIDRL;          /*!< (@ 0x000000EC) grandmasterIdentity Field Setting Registers                */

        struct
        {
            __IOM uint32_t GMIDRL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                         *   of the value of the grandmasterIdentity fields of Announce
                                         *   messages.                                                                 */
        } GMIDRL_b;
    };

    union
    {
        __IOM uint32_t CUOTSR;         /*!< (@ 0x000000F0) currentUtcOffset/timeSource Field Setting Register         */

        struct
        {
            __IOM uint32_t TSRC : 8;   /*!< [7..0] timeSource Field SettingThese bits set the value of the
                                        *   timeSource fields of Announce messages.                                   */
            uint32_t            : 8;
            __IOM uint32_t CUTO : 16;  /*!< [31..16] currentUtcOffset Field SettingThese bits set the value
                                        *   of the currentUtcOffset fields of Announce messages.                      */
        } CUOTSR_b;
    };

    union
    {
        __IOM uint32_t SRR;            /*!< (@ 0x000000F4) stepsRemoved Field Setting Register                        */

        struct
        {
            __IOM uint32_t SRMV : 16;  /*!< [15..0] stepsRemoved Field Value SettingThese bits set the value
                                        *   of the stepsRemoved fields of Announce messages.                          */
            uint32_t : 16;
        } SRR_b;
    };
    __IM uint32_t RESERVED8[2];

    union
    {
        __IOM uint32_t PPMACRU;          /*!< (@ 0x00000100) PTP-primary Message Destination MAC Address Setting
                                          *                  Registers                                                  */

        struct
        {
            __IOM uint32_t PPMACRU : 24; /*!< [23..0] These bits hold the setting for the higher-order 24
                                          *   bits of the destination MAC address for PTP-primary messages.             */
            uint32_t : 8;
        } PPMACRU_b;
    };

    union
    {
        __IOM uint32_t PPMACRL;          /*!< (@ 0x00000104) PTP-primary Message Destination MAC Address Setting
                                          *                  Registers                                                  */

        struct
        {
            __IOM uint32_t PPMACRL : 24; /*!< [23..0] These bits hold the setting for the lower-order 24 bits
                                          *   of the destination MAC address for PTP-primary messages.                  */
            uint32_t : 8;
        } PPMACRL_b;
    };

    union
    {
        __IOM uint32_t PDMACRU;          /*!< (@ 0x00000108) PTP-pdelay Message MAC Address Setting Registers           */

        struct
        {
            __IOM uint32_t PDMACRU : 24; /*!< [23..0] These bits hold the setting for the higher-order 24
                                          *   bits of the destination MAC address for PTP-pdelay messages.              */
            uint32_t : 8;
        } PDMACRU_b;
    };

    union
    {
        __IOM uint32_t PDMACRL;          /*!< (@ 0x0000010C) PTP-pdelay Message MAC Address Setting Registers           */

        struct
        {
            __IOM uint32_t PDMACRL : 24; /*!< [23..0] These bits hold the setting for the lower-order 24 bits
                                          *   of the destination MAC address for PTP-pdelay messages.                   */
            uint32_t : 8;
        } PDMACRL_b;
    };

    union
    {
        __IOM uint32_t PETYPER;        /*!< (@ 0x00000110) PTP Message EtherType Setting Register                     */

        struct
        {
            __IOM uint32_t TYPE : 16;  /*!< [15..0] PTP Message EtherType Value SettingThese bits hold the
                                        *   setting for the EtherType field value for frames in the
                                        *   Ethernet II format.                                                       */
            uint32_t : 16;
        } PETYPER_b;
    };
    __IM uint32_t RESERVED9[3];

    union
    {
        __IOM uint32_t PPIPR;          /*!< (@ 0x00000120) PTP-primary Message Destination IP Address Setting
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t PPIPR : 32; /*!< [31..0] These bits hold the setting for the destination IP address
                                        *   for PTPprimary messages.                                                  */
        } PPIPR_b;
    };

    union
    {
        __IOM uint32_t PDIPR;          /*!< (@ 0x00000124) PTP-pdelay Message Destination IP Address Setting
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t PDIPR : 32; /*!< [31..0] These bits hold the setting for the destination IP address
                                        *   for PTPpdelay messages.                                                   */
        } PDIPR_b;
    };

    union
    {
        __IOM uint32_t PETOSR;         /*!< (@ 0x00000128) PTP Event Message TOS Setting Register                     */

        struct
        {
            __IOM uint32_t EVTO : 8;   /*!< [7..0] PTP Event Message TOS Field Value SettingThese bits hold
                                        *   the setting for the value of the TOS field within the IPv4
                                        *   headers of PTP event messages.                                            */
            uint32_t : 24;
        } PETOSR_b;
    };

    union
    {
        __IOM uint32_t PGTOSR;         /*!< (@ 0x0000012C) PTP general Message TOS Setting Register                   */

        struct
        {
            __IOM uint32_t GETO : 8;   /*!< [7..0] PTP general Message TOS Field Value SettingThese bits
                                        *   hold the setting for the value of the TOS field within
                                        *   the IPv4 headers of PTP general messages.                                 */
            uint32_t : 24;
        } PGTOSR_b;
    };

    union
    {
        __IOM uint32_t PPTTLR;         /*!< (@ 0x00000130) PTP-primary Message TTL Setting Register                   */

        struct
        {
            __IOM uint32_t PRTL : 8;   /*!< [7..0] PTP-primary Message TTL Field Value SettingThese bits
                                        *   hold the setting for the value of the TTL field within
                                        *   the IPv4 headers of PTP-primary messages.                                 */
            uint32_t : 24;
        } PPTTLR_b;
    };

    union
    {
        __IOM uint32_t PDTTLR;         /*!< (@ 0x00000134) PTP-pdelay Message TTL Setting Register                    */

        struct
        {
            __IOM uint32_t PDTL : 8;   /*!< [7..0] PTP-pdelay Message TTL Field ValueThese bits hold the
                                        *   setting for the value of the TTL field within the IPv4
                                        *   headers of PTP-pdelay messages.                                           */
            uint32_t : 24;
        } PDTTLR_b;
    };

    union
    {
        __IOM uint32_t PEUDPR;         /*!< (@ 0x00000138) PTP Event Message UDP Destination Port Number
                                        *                  Setting Register                                           */

        struct
        {
            __IOM uint32_t EVUPT : 16; /*!< [15..0] PTP Event Message Destination Port Number SettingThese
                                        *   bits hold the setting for the value of the destination
                                        *   port number field within the UDP headers of PTP event messages.           */
            uint32_t : 16;
        } PEUDPR_b;
    };

    union
    {
        __IOM uint32_t PGUDPR;         /*!< (@ 0x0000013C) PTP general Message UDP Destination Port Number
                                        *                  Setting Register                                           */

        struct
        {
            __IOM uint32_t GEUPT : 16; /*!< [15..0] PTP general Message Destination Port NumberThese bits
                                        *   hold the setting for the value of the destination port
                                        *   number field within the UDP headers of PTP general messages.              */
            uint32_t : 16;
        } PGUDPR_b;
    };

    union
    {
        __IOM uint32_t FFLTR;          /*!< (@ 0x00000140) Frame Reception Filter Setting Register                    */

        struct
        {
            __IOM uint32_t SEL : 1;    /*!< [0..0] Receive MAC Address SelectNOTE: The setting of these
                                        *   bits is only effective when EXTPRM=0, ENB=1and RPT=1.                     */
            __IOM uint32_t PRT : 1;    /*!< [1..1] Frame Reception EnableNOTE: The setting of these bits
                                        *   is only effective when EXTPRM=0 and ENB=1.                                */
            __IOM uint32_t ENB : 1;    /*!< [2..2] Reception Filter EnableNOTE: The setting of these bits
                                        *   is only effective when EXTPRM=0.                                          */
            uint32_t              : 13;
            __IOM uint32_t EXTPRM : 1; /*!< [16..16] Extended Promiscuous ModeSetting                                 */
            uint32_t              : 15;
        } FFLTR_b;
    };
    __IM uint32_t RESERVED10[7];

    union
    {
        __IOM uint32_t FMAC0RU;          /*!< (@ 0x00000160) Frame Reception Filter MAC Address 0 Setting
                                          *                  Register Upper                                             */

        struct
        {
            __IOM uint32_t FMAC0RU : 24; /*!< [23..0] These bits specify the upper-order 24 bits of the destination
                                          *   MAC address for received multicast frames.                                */
            uint32_t : 8;
        } FMAC0RU_b;
    };

    union
    {
        __IOM uint32_t FMAC0RL;          /*!< (@ 0x00000164) Frame Reception Filter MAC Address 0 Setting
                                          *                  Register Lower                                             */

        struct
        {
            __IOM uint32_t FMAC0RL : 24; /*!< [23..0] These bits specify the lower-order 24 bits of the destination
                                          *   MAC address for received multicast frames.                                */
            uint32_t : 8;
        } FMAC0RL_b;
    };

    union
    {
        __IOM uint32_t FMAC1RU;          /*!< (@ 0x00000168) Frame Reception Filter MAC Address 1 Setting
                                          *                  Register Upper                                             */

        struct
        {
            __IOM uint32_t FMAC1RU : 24; /*!< [23..0] These bits specify the upper-order 24 bits of the destination
                                          *   MAC address for received multicast frames.                                */
            uint32_t : 8;
        } FMAC1RU_b;
    };

    union
    {
        __IOM uint32_t FMAC1RL;          /*!< (@ 0x0000016C) Frame Reception Filter MAC Address 1 Setting
                                          *                  Register Lower                                             */

        struct
        {
            __IOM uint32_t FMAC1RL : 24; /*!< [23..0] These bits specify the lower-order 24 bits of the destination
                                          *   MAC address for received multicast frames.                                */
            uint32_t : 8;
        } FMAC1RL_b;
    };
    __IM uint32_t RESERVED11[20];

    union
    {
        __IOM uint32_t DASYMRU;          /*!< (@ 0x000001C0) Asymmetric Delay Setting Registers                         */

        struct
        {
            __IOM uint32_t DASYMRU : 16; /*!< [15..0] These bits hold the setting for the higher-order 16
                                          *   bits of the asymmetric delay value.                                       */
            uint32_t : 16;
        } DASYMRU_b;
    };

    union
    {
        __IOM uint32_t DASYMRL;          /*!< (@ 0x000001C4) Asymmetric Delay Setting Registers                         */

        struct
        {
            __IOM uint32_t DASYMRL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                          *   of the asymmetric delay value.                                            */
        } DASYMRL_b;
    };

    union
    {
        __IOM uint32_t TSLATR;         /*!< (@ 0x000001C8) Timestamp Latency Setting Register                         */

        struct
        {
            __IOM uint32_t EGP : 16;   /*!< [15..0] Input Port Timestamp Latency SettingThese bits hold
                                        *   the setting for the time stamp latency (ns) for the input
                                        *   ports.                                                                    */
            __IOM uint32_t INGP : 16;  /*!< [31..16] Output Port Timestamp Latency SettingThese bits hold
                                        *   the setting for the time stamp latency (ns) for the output
                                        *   ports.                                                                    */
        } TSLATR_b;
    };

    union
    {
        __IOM uint32_t SYCONFR;        /*!< (@ 0x000001CC) SYNFP Operation Setting Register                           */

        struct
        {
            __IOM uint32_t TCYC : 8;   /*!< [7..0] PTP Message Transmission Interval SettingThese bits are
                                        *   used to set the time from the completion of one transmission
                                        *   to the start of the next in cycles of the transmission
                                        *   clock. A value n in these bits means that a transmission
                                        *   interval of n cycles will be secured.No interval is secured
                                        *   if the setting is 00h.We recommend the setting 28h (40
                                        *   cycles).                                                                  */
            uint32_t              : 4;
            __IOM uint32_t SBDIS  : 1; /*!< [12..12] Sync Message Transmission Bandwidth Securing Disable             */
            uint32_t              : 3;
            __IOM uint32_t FILDIS : 1; /*!< [16..16] Receive Message domainNumber Filter Disable                      */
            uint32_t              : 3;
            __IOM uint32_t TCMOD  : 1; /*!< [20..20] TC Mode Setting                                                  */
            uint32_t              : 11;
        } SYCONFR_b;
    };

    union
    {
        __IOM uint32_t SYFORMR;        /*!< (@ 0x000001D0) SYNFP Frame Format Setting Register                        */

        struct
        {
            __IOM uint32_t FORM0 : 1;  /*!< [0..0] Ethernet/UDP Encapsulation                                         */
            __IOM uint32_t FORM1 : 1;  /*!< [1..1] Ethernet Frame Format Setting                                      */
            uint32_t             : 30;
        } SYFORMR_b;
    };

    union
    {
        __IOM uint32_t RSTOUTR;          /*!< (@ 0x000001D4) Response Message Reception Timeout Register                */

        struct
        {
            __IOM uint32_t RSTOUTR : 32; /*!< [31..0] Response Message Reception Timeout Time SettingA response
                                          *   message not being received within n x 1024 (ns), where
                                          *   n is the setting, is judged to represent a timeout.                       */
        } RSTOUTR_b;
    };
} R_ETHERC_EPTPC_Type;                   /*!< Size = 472 (0x1d8)                                                        */

/* =========================================================================================================================== */
/* ================                                    R_ETHERC_EPTPC_CFG                                     ================ */
/* =========================================================================================================================== */

/**
 * @brief Ethernet PTP Configuration (R_ETHERC_EPTPC_CFG)
 */

typedef struct                         /*!< (@ 0x40064500) R_ETHERC_EPTPC_CFG Structure                               */
{
    union
    {
        __IOM uint32_t PTRSTR;         /*!< (@ 0x00000000) EPTPC Reset Register                                       */

        struct
        {
            __IOM uint32_t RESET : 1;  /*!< [0..0] EPTPC Software Reset                                               */
            uint32_t             : 31;
        } PTRSTR_b;
    };

    union
    {
        __IOM uint32_t STCSELR;         /*!< (@ 0x00000004) STCA Clock Select Register                                 */

        struct
        {
            __IOM uint32_t SCLKDIV : 3; /*!< [2..0] PCLKA Clock Frequency Division                                     */
            uint32_t               : 5;
            __IOM uint32_t SCLKSEL : 3; /*!< [10..8] STCA Clock Select                                                 */
            uint32_t               : 21;
        } STCSELR_b;
    };

    union
    {
        __IOM uint32_t BYPASS;          /*!< (@ 0x00000008) Bypass 1588 module Register                                */

        struct
        {
            __IOM uint32_t BYPASS0 : 1; /*!< [0..0] Bypass 1588 module for Ether 0ch                                   */
            uint32_t               : 15;
            __IOM uint32_t BYPASS1 : 1; /*!< [16..16] Bypass 1588 module for Ether 1ch                                 */
            uint32_t               : 15;
        } BYPASS_b;
    };
} R_ETHERC_EPTPC_CFG_Type;              /*!< Size = 12 (0xc)                                                           */

/* =========================================================================================================================== */
/* ================                                   R_ETHERC_EPTPC_COMMON                                   ================ */
/* =========================================================================================================================== */

/**
 * @brief Ethernet PTP Controller Common (R_ETHERC_EPTPC_COMMON)
 */

typedef struct                         /*!< (@ 0x40065000) R_ETHERC_EPTPC_COMMON Structure                            */
{
    union
    {
        __IOM uint32_t MIESR;          /*!< (@ 0x00000000) MINT Interrupt Source Status Register                      */

        struct
        {
            __IM uint32_t ST    : 1;   /*!< [0..0] STCA Status Flag                                                   */
            __IM uint32_t SY0   : 1;   /*!< [1..1] SYNFP0 Status Flag                                                 */
            __IM uint32_t SY1   : 1;   /*!< [2..2] SYNFP1 Status Flag                                                 */
            __IM uint32_t PRC   : 1;   /*!< [3..3] PRC-TC Status Flag                                                 */
            uint32_t            : 12;
            __IOM uint32_t CYC0 : 1;   /*!< [16..16] Pulse Output Timer 0 Rising Edge Detection Flag                  */
            __IOM uint32_t CYC1 : 1;   /*!< [17..17] Pulse Output Timer 1 Rising Edge Detection Flag                  */
            __IOM uint32_t CYC2 : 1;   /*!< [18..18] Pulse Output Timer 2 Rising Edge Detection Flag                  */
            __IOM uint32_t CYC3 : 1;   /*!< [19..19] Pulse Output Timer 3 Rising Edge Detection Flag                  */
            __IOM uint32_t CYC4 : 1;   /*!< [20..20] Pulse Output Timer 4 Rising Edge Detection Flag                  */
            __IOM uint32_t CYC5 : 1;   /*!< [21..21] Pulse Output Timer 5 Rising Edge Detection Flag                  */
            uint32_t            : 10;
        } MIESR_b;
    };

    union
    {
        __IOM uint32_t MIEIPR;         /*!< (@ 0x00000004) MINT Interrupt Request Permission Register                 */

        struct
        {
            __IOM uint32_t ST   : 1;   /*!< [0..0] STCA Status Interrupt Request Permission                           */
            __IOM uint32_t SY0  : 1;   /*!< [1..1] SYNFP0 Status Interrupt Request Permission                         */
            __IOM uint32_t SY1  : 1;   /*!< [2..2] SYNFP1 Status Interrupt Request Permission                         */
            __IOM uint32_t PRC  : 1;   /*!< [3..3] PRC-TC Status Interrupt Request Permission                         */
            uint32_t            : 12;
            __IOM uint32_t CYC0 : 1;   /*!< [16..16] Pulse Output Timer 0 Rising Edge Detection Interrupt
                                        *   Request Permission                                                        */
            __IOM uint32_t CYC1 : 1;   /*!< [17..17] Pulse Output Timer 1 Rising Edge Detection Interrupt
                                        *   Request Permission                                                        */
            __IOM uint32_t CYC2 : 1;   /*!< [18..18] Pulse Output Timer 2 Rising Edge Detection Interrupt
                                        *   Request Permission                                                        */
            __IOM uint32_t CYC3 : 1;   /*!< [19..19] Pulse Output Timer 3 Rising Edge Detection Interrupt
                                        *   Request Permission                                                        */
            __IOM uint32_t CYC4 : 1;   /*!< [20..20] Pulse Output Timer 4 Rising Edge Detection Interrupt
                                        *   Request Permission                                                        */
            __IOM uint32_t CYC5 : 1;   /*!< [21..21] Pulse Output Timer 5 Rising Edge Detection Interrupt
                                        *   Request Permission                                                        */
            uint32_t : 10;
        } MIEIPR_b;
    };
    __IM uint32_t RESERVED[2];

    union
    {
        __IOM uint32_t ELIPPR;         /*!< (@ 0x00000010) ELC Output/ETHER_IPLS Interrupt Request Permission
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t CYCP0 : 1;  /*!< [0..0] Pulse Output Timer 0 Rising Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCP1 : 1;  /*!< [1..1] Pulse Output Timer 1 Rising Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCP2 : 1;  /*!< [2..2] Pulse Output Timer 2 Rising Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCP3 : 1;  /*!< [3..3] Pulse Output Timer 3 Rising Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCP4 : 1;  /*!< [4..4] Pulse Output Timer 4 Rising Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCP5 : 1;  /*!< [5..5] Pulse Output Timer 5 Rising Edge Detection Event Output
                                        *   Enable                                                                    */
            uint32_t             : 2;
            __IOM uint32_t CYCN0 : 1;  /*!< [8..8] Pulse Output Timer 0 Falling Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCN1 : 1;  /*!< [9..9] Pulse Output Timer 1 Falling Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCN2 : 1;  /*!< [10..10] Pulse Output Timer 2 Falling Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCN3 : 1;  /*!< [11..11] Pulse Output Timer 3 Falling Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCN4 : 1;  /*!< [12..12] Pulse Output Timer 4 Falling Edge Detection Event Output
                                        *   Enable                                                                    */
            __IOM uint32_t CYCN5 : 1;  /*!< [13..13] Pulse Output Timer 5 Falling Edge Detection Event Output
                                        *   Enable                                                                    */
            uint32_t            : 2;
            __IOM uint32_t PLSP : 1;   /*!< [16..16] Pulse Output Timer Rising Edge Detection IPLS Interrupt
                                        *   Request Permission                                                        */
            uint32_t            : 7;
            __IOM uint32_t PLSN : 1;   /*!< [24..24] Pulse Output Timer Falling Edge Detection IPLS Interrupt
                                        *   Request Permission                                                        */
            uint32_t : 7;
        } ELIPPR_b;
    };

    union
    {
        __IOM uint32_t ELIPACR;        /*!< (@ 0x00000014) ELC Output/IPLS Interrupt Permission Automatic
                                        *                  Clearing Register                                          */

        struct
        {
            __IOM uint32_t CYCP0 : 1;  /*!< [0..0] ELIPPR.CYCP0 Bit Automatic Clearing                                */
            __IOM uint32_t CYCP1 : 1;  /*!< [1..1] ELIPPR.CYCP1 Bit Automatic Clearing                                */
            __IOM uint32_t CYCP2 : 1;  /*!< [2..2] ELIPPR.CYCP2 Bit Automatic Clearing                                */
            __IOM uint32_t CYCP3 : 1;  /*!< [3..3] ELIPPR.CYCP3 Bit Automatic Clearing                                */
            __IOM uint32_t CYCP4 : 1;  /*!< [4..4] ELIPPR.CYCP4 Bit Automatic Clearing                                */
            __IOM uint32_t CYCP5 : 1;  /*!< [5..5] ELIPPR.CYCP5 Bit Automatic Clearing                                */
            uint32_t             : 2;
            __IOM uint32_t CYCN0 : 1;  /*!< [8..8] ELIPPR.CYCN0 Bit Automatic Clearing                                */
            __IOM uint32_t CYCN1 : 1;  /*!< [9..9] ELIPPR.CYCN1 Bit Automatic Clearing                                */
            __IOM uint32_t CYCN2 : 1;  /*!< [10..10] ELIPPR.CYCN2 Bit Automatic Clearing                              */
            __IOM uint32_t CYCN3 : 1;  /*!< [11..11] ELIPPR.CYCN3 Bit Automatic Clearing                              */
            __IOM uint32_t CYCN4 : 1;  /*!< [12..12] ELIPPR.CYCN4 Bit Automatic Clearing                              */
            __IOM uint32_t CYCN5 : 1;  /*!< [13..13] ELIPPR.CYCN5 Bit Automatic Clearing                              */
            uint32_t             : 2;
            __IOM uint32_t PLSP  : 1;  /*!< [16..16] ELIPPR.PLSP Bit Automatic Clearing                               */
            uint32_t             : 7;
            __IOM uint32_t PLSN  : 1;  /*!< [24..24] ELIPPR.PLSN Bit Automatic Clearing                               */
            uint32_t             : 7;
        } ELIPACR_b;
    };
    __IM uint32_t RESERVED1[10];

    union
    {
        __IOM uint32_t STSR;            /*!< (@ 0x00000040) STCA Status Register                                       */

        struct
        {
            __IOM uint32_t SYNC    : 1; /*!< [0..0] Synchronized State Detection Flag                                  */
            __IOM uint32_t SYNCOUT : 1; /*!< [1..1] Synchronization Loss Detection Flag                                */
            uint32_t               : 1;
            __IOM uint32_t SYNTOUT : 1; /*!< [3..3] Sync Message Reception Timeout Detection Flag                      */
            __IOM uint32_t W10D    : 1; /*!< [4..4] Worst 10 Acquisition Completion Flag                               */
            uint32_t               : 27;
        } STSR_b;
    };

    union
    {
        __IOM uint32_t STIPR;           /*!< (@ 0x00000044) STCA Status Notification Permission Register               */

        struct
        {
            __IOM uint32_t SYNC    : 1; /*!< [0..0] SYNC Status Notification Enable                                    */
            __IOM uint32_t SYNCOUT : 1; /*!< [1..1] SYNCOUT Status Notification Enable                                 */
            uint32_t               : 1;
            __IOM uint32_t SYNTOUT : 1; /*!< [3..3] SYNTOUT Status Notification Enable                                 */
            __IOM uint32_t W10D    : 1; /*!< [4..4] W10D Status Notification Enable                                    */
            uint32_t               : 27;
        } STIPR_b;
    };
    __IM uint32_t RESERVED2[2];

    union
    {
        __IOM uint32_t STCFR;          /*!< (@ 0x00000050) STCA Clock Frequency Setting Register                      */

        struct
        {
            __IOM uint32_t STCF : 2;   /*!< [1..0] STCA Clock Frequency                                               */
            uint32_t            : 30;
        } STCFR_b;
    };

    union
    {
        __IOM uint32_t STMR;           /*!< (@ 0x00000054) STCA Operating Mode Register                               */

        struct
        {
            __IOM uint32_t WINT  : 8;  /*!< [7..0] Worst 10 Acquisition Time                                          */
            uint32_t             : 5;
            __IOM uint32_t CMOD  : 1;  /*!< [13..13] Time Synchronization Correction Mode                             */
            uint32_t             : 1;
            __IOM uint32_t W10S  : 1;  /*!< [15..15] Worst 10 Acquisition Control Select                              */
            __IOM uint32_t SYTH  : 4;  /*!< [19..16] Synchronized State Detection Threshold Setting                   */
            __IOM uint32_t DVTH  : 4;  /*!< [23..20] Synchronization Loss Detection Threshold Setting                 */
            uint32_t             : 4;
            __IOM uint32_t ALEN0 : 1;  /*!< [28..28] Alarm Detection Enable 0                                         */
            __IOM uint32_t ALEN1 : 1;  /*!< [29..29] Alarm Detection Enable 1                                         */
            uint32_t             : 2;
        } STMR_b;
    };

    union
    {
        __IOM uint32_t SYNTOR;          /*!< (@ 0x00000058) Sync Message Reception Timeout Register                    */

        struct
        {
            __IOM uint32_t SYNTOR : 32; /*!< [31..0] A Sync message not being received within 1024 x n (ns),
                                         *   where n is the setting, leads to a timeout for reception
                                         *   of Sync messages, leading to the STSR.SYNTOUT flag being
                                         *   set to 1.                                                                 */
        } SYNTOR_b;
    };
    __IM uint32_t RESERVED3;

    union
    {
        __IOM uint32_t IPTSELR;         /*!< (@ 0x00000060) IPLS Interrupt Request Timer Select Register               */

        struct
        {
            __IOM uint32_t IPTSEL0 : 1; /*!< [0..0] Pulse Output Timer 0 Select                                        */
            __IOM uint32_t IPTSEL1 : 1; /*!< [1..1] Pulse Output Timer 1 Select                                        */
            __IOM uint32_t IPTSEL2 : 1; /*!< [2..2] Pulse Output Timer 2 Select                                        */
            __IOM uint32_t IPTSEL3 : 1; /*!< [3..3] Pulse Output Timer 3 Select                                        */
            __IOM uint32_t IPTSEL4 : 1; /*!< [4..4] Pulse Output Timer 4 Select                                        */
            __IOM uint32_t IPTSEL5 : 1; /*!< [5..5] Pulse Output Timer 5 Select                                        */
            uint32_t               : 26;
        } IPTSELR_b;
    };

    union
    {
        __IOM uint32_t MITSELR;         /*!< (@ 0x00000064) MINT Interrupt Request Timer Select Register               */

        struct
        {
            __IOM uint32_t MINTEN0 : 1; /*!< [0..0] Pulse Output Timer 0 MINT Interrupt Output Enable                  */
            __IOM uint32_t MINTEN1 : 1; /*!< [1..1] Pulse Output Timer 1 MINT Interrupt Output Enable                  */
            __IOM uint32_t MINTEN2 : 1; /*!< [2..2] Pulse Output Timer 2 MINT Interrupt Output Enable                  */
            __IOM uint32_t MINTEN3 : 1; /*!< [3..3] Pulse Output Timer 3 MINT Interrupt Output Enable                  */
            __IOM uint32_t MINTEN4 : 1; /*!< [4..4] Pulse Output Timer 4 MINT Interrupt Output Enable                  */
            __IOM uint32_t MINTEN5 : 1; /*!< [5..5] Pulse Output Timer 5 MINT Interrupt Output Enable                  */
            uint32_t               : 26;
        } MITSELR_b;
    };

    union
    {
        __IOM uint32_t ELTSELR;         /*!< (@ 0x00000068) ELC Output Timer Select Register                           */

        struct
        {
            __IOM uint32_t ELTDIS0 : 1; /*!< [0..0] Pulse Output Timer 0 Event Generation Disable                      */
            __IOM uint32_t ELTDIS1 : 1; /*!< [1..1] Pulse Output Timer 1 Event Generation Disable                      */
            __IOM uint32_t ELTDIS2 : 1; /*!< [2..2] Pulse Output Timer 2 Event Generation Disable                      */
            __IOM uint32_t ELTDIS3 : 1; /*!< [3..3] Pulse Output Timer 3 Event Generation Disable                      */
            __IOM uint32_t ELTDIS4 : 1; /*!< [4..4] Pulse Output Timer 4 Event Generation Disable                      */
            __IOM uint32_t ELTDIS5 : 1; /*!< [5..5] Pulse Output Timer 5 Event Generation Disable                      */
            uint32_t               : 26;
        } ELTSELR_b;
    };

    union
    {
        __IOM uint32_t STCHSELR;       /*!< (@ 0x0000006C) Time Synchronization Channel Select Register               */

        struct
        {
            __IOM uint32_t SYSEL : 1;  /*!< [0..0] Timer Information Input SelectNOTE: Do not change the
                                        *   value of this bit while the SYNSTARTR.STR bit is 1.                       */
            uint32_t : 31;
        } STCHSELR_b;
    };
    __IM uint32_t RESERVED4[4];

    union
    {
        __IOM uint32_t SYNSTARTR;      /*!< (@ 0x00000080) Slave Time Synchronization Start Register                  */

        struct
        {
            __IOM uint32_t STR : 1;    /*!< [0..0] Slave Time Synchronization Control                                 */
            uint32_t           : 31;
        } SYNSTARTR_b;
    };

    union
    {
        __OM uint32_t LCIVLDR;         /*!< (@ 0x00000084) Local Time Counter Initial Value Load Directive
                                        *                  Register                                                   */

        struct
        {
            __OM uint32_t LOAD : 1;    /*!< [0..0] Local Time Counter Initial Value Load Directive                    */
            uint32_t           : 31;
        } LCIVLDR_b;
    };
    __IM uint32_t RESERVED5[2];

    union
    {
        __IOM uint32_t SYNTDARU;          /*!< (@ 0x00000090) Synchronization Loss Detection Threshold Registers         */

        struct
        {
            __IOM uint32_t SYNTDARU : 32; /*!< [31..0] These bits hold the setting for the higher-order 32
                                           *   bits of the threshold for detection of loss of synchronization.           */
        } SYNTDARU_b;
    };

    union
    {
        __IOM uint32_t SYNTDARL;          /*!< (@ 0x00000094) Synchronization Loss Detection Threshold Registers         */

        struct
        {
            __IOM uint32_t SYNTDARL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                           *   of the threshold for detection of loss of synchronization.                */
        } SYNTDARL_b;
    };

    union
    {
        __IOM uint32_t SYNTDBRU;          /*!< (@ 0x00000098) Synchronization Detection Threshold Registers              */

        struct
        {
            __IOM uint32_t SYNTDBRU : 32; /*!< [31..0] These bits hold the setting for the higher-order 32
                                           *   bits of the threshold for detection of synchronization.                   */
        } SYNTDBRU_b;
    };

    union
    {
        __IOM uint32_t SYNTDBRL;          /*!< (@ 0x0000009C) Synchronization Detection Threshold Registers              */

        struct
        {
            __IOM uint32_t SYNTDBRL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                           *   of the threshold for detection of synchronization.                        */
        } SYNTDBRL_b;
    };
    __IM uint32_t RESERVED6[4];

    union
    {
        __IOM uint32_t LCIVRU;          /*!< (@ 0x000000B0) Local Time Counter Initial Value Registers                 */

        struct
        {
            __IOM uint32_t LCIVRU : 16; /*!< [15..0] These bits hold the setting for the higher-order 16
                                         *   bits of the integer portion of the initial value for the
                                         *   local timer counter.                                                      */
            uint32_t : 16;
        } LCIVRU_b;
    };

    union
    {
        __IOM uint32_t LCIVRM;          /*!< (@ 0x000000B4) Local Time Counter Initial Value Registers                 */

        struct
        {
            __IOM uint32_t LCIVRM : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                         *   of the integer portion of the initial value for the local
                                         *   timer counter.                                                            */
        } LCIVRM_b;
    };

    union
    {
        __IOM uint32_t LCIVRL;          /*!< (@ 0x000000B8) Local Time Counter Initial Value Registers                 */

        struct
        {
            __IOM uint32_t LCIVRL : 32; /*!< [31..0] These bits hold the setting for the fractional portion
                                         *   of the initial value of the local timer counter in nanoseconds.           */
        } LCIVRL_b;
    };
    __IM uint32_t RESERVED7[26];

    union
    {
        __IOM uint32_t GETW10R;        /*!< (@ 0x00000124) Worst 10 Acquisition Directive Register                    */

        struct
        {
            __IOM uint32_t GW10 : 1;   /*!< [0..0] Worst 10 Acquisition Directive                                     */
            uint32_t            : 31;
        } GETW10R_b;
    };

    union
    {
        __IOM uint32_t PLIMITRU;          /*!< (@ 0x00000128) Positive Gradient Limit Registers                          */

        struct
        {
            __IOM uint32_t PLIMITRU : 31; /*!< [30..0] These bits hold the setting for the higher-order 31
                                           *   bits of the limit for the positive gradient.                              */
            uint32_t : 1;
        } PLIMITRU_b;
    };

    union
    {
        __IOM uint32_t PLIMITRM;          /*!< (@ 0x0000012C) Positive Gradient Limit Registers                          */

        struct
        {
            __IOM uint32_t PLIMITRM : 32; /*!< [31..0] These bits hold the setting for the middle-order 32
                                           *   bits of the limit for the positive gradient.                              */
        } PLIMITRM_b;
    };

    union
    {
        __IOM uint32_t PLIMITRL;          /*!< (@ 0x00000130) Positive Gradient Limit Registers                          */

        struct
        {
            __IOM uint32_t PLIMITRL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                           *   of the limit for the positive gradient.                                   */
        } PLIMITRL_b;
    };

    union
    {
        __IOM uint32_t MLIMITRU;          /*!< (@ 0x00000134) Negative Gradient Limit Registers                          */

        struct
        {
            __IOM uint32_t MLIMITRU : 31; /*!< [30..0] These bits hold the setting for the higher-order 31
                                           *   bits of the limit for the negative gradient.                              */
            uint32_t : 1;
        } MLIMITRU_b;
    };

    union
    {
        __IOM uint32_t MLIMITRM;          /*!< (@ 0x00000138) Negative Gradient Limit Registers                          */

        struct
        {
            __IOM uint32_t MLIMITRM : 32; /*!< [31..0] These bits hold the setting for the middle-order 32
                                           *   bits of the limit for the negative gradient.                              */
        } MLIMITRM_b;
    };

    union
    {
        __IOM uint32_t MLIMITRL;          /*!< (@ 0x0000013C) Negative Gradient Limit Registers                          */

        struct
        {
            __IOM uint32_t MLIMITRL : 32; /*!< [31..0] These bits hold the setting for the lower-order 32 bits
                                           *   of the limit for the negative gradient.                                   */
        } MLIMITRL_b;
    };

    union
    {
        __IOM uint32_t GETINFOR;       /*!< (@ 0x00000140) Statistical Information Retention Control Register         */

        struct
        {
            __IOM uint32_t INFO : 1;   /*!< [0..0] Information Retention ControlNOTE: Once information fetching
                                        *   is directed, values of various statistical information
                                        *   read before completion of information fetching are not
                                        *   guaranteed.                                                               */
            uint32_t : 31;
        } GETINFOR_b;
    };
    __IM uint32_t RESERVED8[11];

    union
    {
        __IM uint32_t LCCVRU;          /*!< (@ 0x00000170) Local Time Counters                                        */

        struct
        {
            __IM uint32_t LCCVRU : 16; /*!< [15..0] These bits are for reading the higher-order 16 bits
                                        *   of the integer portion of the local timer counter's value.                */
            uint32_t : 16;
        } LCCVRU_b;
    };

    union
    {
        __IM uint32_t LCCVRM;          /*!< (@ 0x00000174) Local Time Counters                                        */

        struct
        {
            __IM uint32_t LCCVRM : 32; /*!< [31..0] These bits are for reading the lower-order 32 bits of
                                        *   the integer portion of the local timer counter's value.                   */
        } LCCVRM_b;
    };

    union
    {
        __IM uint32_t LCCVRL;          /*!< (@ 0x00000178) Local Time Counters                                        */

        struct
        {
            __IM uint32_t LCCVRL : 32; /*!< [31..0] These bits are for reading the fractional portion of
                                        *   the local timer counter's value (in nanoseconds).                         */
        } LCCVRL_b;
    };
    __IM uint32_t RESERVED9[37];

    union
    {
        __IM uint32_t PW10VRU;          /*!< (@ 0x00000210) Positive Gradient Worst 10 Value Registers                 */

        struct
        {
            __IM uint32_t PW10VRU : 32; /*!< [31..0] These bits are for reading the higher-order 32 bits
                                         *   of the positive gradient value.                                           */
        } PW10VRU_b;
    };

    union
    {
        __IM uint32_t PW10VRM;          /*!< (@ 0x00000214) Positive Gradient Worst 10 Value Registers                 */

        struct
        {
            __IM uint32_t PW10VRM : 32; /*!< [31..0] These bits are for reading the middle-order 32 bits
                                         *   of the positive gradient value.                                           */
        } PW10VRM_b;
    };

    union
    {
        __IM uint32_t PW10VRL;          /*!< (@ 0x00000218) Positive Gradient Worst 10 Value Registers                 */

        struct
        {
            __IM uint32_t PW10VRL : 32; /*!< [31..0] These bits are for reading the lower-order 32 bits of
                                         *   the positive gradient value.                                              */
        } PW10VRL_b;
    };
    __IM uint32_t RESERVED10[45];

    union
    {
        __IM uint32_t MW10RU;          /*!< (@ 0x000002D0) Negative Gradient Worst 10 Value Registers                 */

        struct
        {
            __IM uint32_t MW10RU : 32; /*!< [31..0] These bits are for reading the higher-order 32 bits
                                        *   of the negative gradient value.                                           */
        } MW10RU_b;
    };

    union
    {
        __IM uint32_t MW10RM;          /*!< (@ 0x000002D4) Negative Gradient Worst 10 Value Registers                 */

        struct
        {
            __IM uint32_t MW10RM : 32; /*!< [31..0] These bits are for reading the middle-order 32 bits
                                        *   of the negative gradient value.                                           */
        } MW10RM_b;
    };

    union
    {
        __IM uint32_t MW10RL;                  /*!< (@ 0x000002D8) Negative Gradient Worst 10 Value Registers                 */

        struct
        {
            __IM uint32_t MW10RL : 32;         /*!< [31..0] These bits are for reading the lower-order 32 bits of
                                                *   the negative gradient value.                                              */
        } MW10RL_b;
    };
    __IM uint32_t RESERVED11[9];
    __IOM R_ETHERC_EPTPC_COMMON_TM_Type TM[6]; /*!< (@ 0x00000300) Timer Setting Registers                                    */
    __IM uint32_t RESERVED12[7];

    union
    {
        __IOM uint32_t TMSTARTR;       /*!< (@ 0x0000037C) Timer Start Register                                       */

        struct
        {
            __IOM uint32_t EN0 : 1;    /*!< [0..0] Pulse Output Timer 0 Start                                         */
            __IOM uint32_t EN1 : 1;    /*!< [1..1] Pulse Output Timer 1 Start                                         */
            __IOM uint32_t EN2 : 1;    /*!< [2..2] Pulse Output Timer 2 Start                                         */
            __IOM uint32_t EN3 : 1;    /*!< [3..3] Pulse Output Timer 3 Start                                         */
            __IOM uint32_t EN4 : 1;    /*!< [4..4] Pulse Output Timer 4 Start                                         */
            __IOM uint32_t EN5 : 1;    /*!< [5..5] Pulse Output Timer 5 Start                                         */
            uint32_t           : 26;
        } TMSTARTR_b;
    };
    __IM uint32_t RESERVED13[32];

    union
    {
        __IOM uint32_t PRSR;           /*!< (@ 0x00000400) PRC-TC Status Register                                     */

        struct
        {
            __IOM uint32_t OVRE0 : 1;  /*!< [0..0] Relay Packet Overflow Detection Flag 0                             */
            __IOM uint32_t OVRE1 : 1;  /*!< [1..1] Relay Packet Overflow Detection Flag 1                             */
            __IOM uint32_t OVRE2 : 1;  /*!< [2..2] Relay Packet Overflow Detection Flag 2                             */
            __IOM uint32_t OVRE3 : 1;  /*!< [3..3] Relay Packet Overflow Detection Flag 3                             */
            uint32_t             : 4;
            __IOM uint32_t MACE  : 1;  /*!< [8..8] Originating MAC Address Mismatch Detection Flag                    */
            uint32_t             : 19;
            __IOM uint32_t URE0  : 1;  /*!< [28..28] Relay Packet Underflow Detection Flag 0                          */
            __IOM uint32_t URE1  : 1;  /*!< [29..29] Relay Packet Underflow Detection Flag 1                          */
            uint32_t             : 2;
        } PRSR_b;
    };

    union
    {
        __IOM uint32_t PRIPR;          /*!< (@ 0x00000404) PRC-TC Status Notification Permission Register             */

        struct
        {
            __IOM uint32_t OVRE0 : 1;  /*!< [0..0] PRSR.OVRE0 Status Notification Permission                          */
            __IOM uint32_t OVRE1 : 1;  /*!< [1..1] PRSR.OVRE1 Status Notification Permission                          */
            __IOM uint32_t OVRE2 : 1;  /*!< [2..2] PRSR.OVRE2 Status Notification Permission                          */
            __IOM uint32_t OVRE3 : 1;  /*!< [3..3] PRSR.OVRE3 Status Notification Permission                          */
            uint32_t             : 4;
            __IOM uint32_t MACE  : 1;  /*!< [8..8] PRSR.MACE Status Notification Permission                           */
            uint32_t             : 19;
            __IOM uint32_t URE0  : 1;  /*!< [28..28] PRSR.URE0 Status Notification Permission                         */
            __IOM uint32_t URE1  : 1;  /*!< [29..29] PRSR.URE1 Status Notification Permission                         */
            uint32_t             : 2;
        } PRIPR_b;
    };
    __IM uint32_t RESERVED14[2];
    __IOM R_ETHERC_EPTPC_COMMON_PR_Type PR[2]; /*!< (@ 0x00000410) Local MAC Address Registers                                */

    union
    {
        __IOM uint32_t TRNDISR;                /*!< (@ 0x00000420) Packet Transmission Control Register                       */

        struct
        {
            __IOM uint32_t TDIS : 2;           /*!< [1..0] Packet Transmission Control                                        */
            uint32_t            : 30;
        } TRNDISR_b;
    };
    __IM uint32_t RESERVED15[3];

    union
    {
        __IOM uint32_t TRNMR;          /*!< (@ 0x00000430) Relay Mode Register                                        */

        struct
        {
            __IOM uint32_t MOD  : 1;   /*!< [0..0] Cut-Through Mode                                                   */
            uint32_t            : 7;
            __IOM uint32_t FWD0 : 1;   /*!< [8..8] Channel 0 Relay Enable                                             */
            __IOM uint32_t FWD1 : 1;   /*!< [9..9] Channel 1 Relay Enable                                             */
            uint32_t            : 22;
        } TRNMR_b;
    };

    union
    {
        __IOM uint32_t TRNCTTDR;       /*!< (@ 0x00000434) Cut-Through Transfer Start Threshold Register              */

        struct
        {
            __IOM uint32_t THVAL : 11; /*!< [10..0] FIFO Read Start ThresholdThreshold for starting to read
                                        *   data from the relay FIFO in cut-through mode (specified
                                        *   as the number of bytes)NOTE1: A value cannot be set in
                                        *   the lower-order 2 bits. These bits are fixed to 0.NOTE2:
                                        *   A value of less than 96 bytes cannot be set.                              */
            uint32_t : 21;
        } TRNCTTDR_b;
    };
} R_ETHERC_EPTPC_COMMON_Type;          /*!< Size = 1080 (0x438)                                                       */

/* =========================================================================================================================== */
/* ================                                       R_FACI_HP_CMD                                       ================ */
/* =========================================================================================================================== */

/**
 * @brief Flash Application Command Interface Command-Issuing Area (R_FACI_HP_CMD)
 */

typedef struct                         /*!< (@ 0x407E0000) R_FACI_HP_CMD Structure                                    */
{
    union
    {
        __IOM uint16_t FACI_CMD16;     /*!< (@ 0x00000000) FACI Command Issuing Area (halfword access)                */
        __IOM uint8_t  FACI_CMD8;      /*!< (@ 0x00000000) FACI Command Issuing Area (halfword access)                */
    };
} R_FACI_HP_CMD_Type;                  /*!< Size = 2 (0x2)                                                            */

/* =========================================================================================================================== */
/* ================                                         R_FACI_HP                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Flash Application Command Interface (R_FACI_HP)
 */

typedef struct                         /*!< (@ 0x407FE000) R_FACI_HP Structure                                        */
{
    __IM uint32_t RESERVED[4];

    union
    {
        __IOM uint8_t FASTAT;          /*!< (@ 0x00000010) Flash Access Status                                        */

        struct
        {
            __IM uint8_t ECRCT  : 1;   /*!< [0..0] ECRCT                                                              */
            uint8_t             : 2;
            __IOM uint8_t DFAE  : 1;   /*!< [3..3] Data Flash Access Error                                            */
            __IM uint8_t  CMDLK : 1;   /*!< [4..4] Command Lock                                                       */
            uint8_t             : 2;
            __IOM uint8_t CFAE  : 1;   /*!< [7..7] Code Flash Access Error                                            */
        } FASTAT_b;
    };
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint8_t FAEINT;          /*!< (@ 0x00000014) Flash Access Error Interrupt Enable                        */

        struct
        {
            __IOM uint8_t ECRCTIE : 1; /*!< [0..0] Error Correct Interrupt Enable                                     */
            uint8_t               : 2;
            __IOM uint8_t DFAEIE  : 1; /*!< [3..3] Data Flash Access Error Interrupt Enable                           */
            __IOM uint8_t CMDLKIE : 1; /*!< [4..4] Command Lock Interrupt Enable                                      */
            uint8_t               : 2;
            __IOM uint8_t CFAEIE  : 1; /*!< [7..7] Code Flash Access Error Interrupt Enable                           */
        } FAEINT_b;
    };
    __IM uint8_t  RESERVED3;
    __IM uint16_t RESERVED4;

    union
    {
        __IOM uint8_t FRDYIE;          /*!< (@ 0x00000018) Flash Ready Interrupt Enable                               */

        struct
        {
            __IOM uint8_t FRDYIE : 1;  /*!< [0..0] FRDY Interrupt Enable                                              */
            uint8_t              : 7;
        } FRDYIE_b;
    };
    __IM uint8_t  RESERVED5;
    __IM uint16_t RESERVED6;
    __IM uint32_t RESERVED7[5];

    union
    {
        __IOM uint32_t FSADDR;         /*!< (@ 0x00000030) Flash Start Address                                        */

        struct
        {
            __IOM uint32_t FSA : 32;   /*!< [31..0] Start Address of Flash Sequencer Command Target Area
                                        *   These bits can be written when FRDY bit of FSTATR register
                                        *   is "1". Writing to these bits in FRDY = "0" is ignored.                   */
        } FSADDR_b;
    };

    union
    {
        __IOM uint32_t FEADDR;         /*!< (@ 0x00000034) Flash End Address                                          */

        struct
        {
            __IOM uint32_t FEA : 32;   /*!< [31..0] End Address of Flash Sequencer Command Target Area Specifies
                                        *   end address of target area in "Blank Check" command. These
                                        *   bits can be written when FRDY bit of FSTATR register is
                                        *   "1". Writing to these bits in FRDY = "0" is ignored.                      */
        } FEADDR_b;
    };
    __IM uint32_t RESERVED8[3];

    union
    {
        __IOM uint16_t FMEPROT;        /*!< (@ 0x00000044) Flash P/E Mode Entry Protection Register                   */

        struct
        {
            __IOM uint16_t CEPROT : 1; /*!< [0..0] Code Flash P/E Mode Entry ProtectionWriting to this bit
                                        *   is only possible when the FRDY bit in the FSTATR register
                                        *   is 1. Writing to this bit while the FRDY bit = 0 isignored.Writing
                                        *   to this bit is only possible when 16 bits are written and
                                        *   the value written to the KEY bits is D9h.Written values
                                        *   are not retained by these bits (always read as 0x00).Only
                                        *   secure access can write to this register. Both secure access
                                        *   and non-secure read access are allowed. Non-secure writeaccess
                                        *   is denied, but TrustZo                                                    */
            uint16_t          : 7;
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FMEPROT_b;
    };
    __IM uint16_t RESERVED9;
    __IM uint32_t RESERVED10[12];

    union
    {
        __IOM uint16_t FBPROT0;        /*!< (@ 0x00000078) Flash Block Protection Register                            */

        struct
        {
            __IOM uint16_t BPCN0 : 1;  /*!< [0..0] Block Protection for Non-secure CancelThis bit can be
                                        *   written when the FRDY bit in the FSTATR register is 1.
                                        *   Writing to this bit is ignored when the FRDY bit is 0.Writing
                                        *   to this bit is only possible when 16 bits are written and
                                        *   the value written to the KEY[7:0] bits is 0x78.Written
                                        *   values are not retained by these bits (always read as 0x00).              */
            uint16_t          : 7;
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FBPROT0_b;
    };
    __IM uint16_t RESERVED11;

    union
    {
        __IOM uint16_t FBPROT1;        /*!< (@ 0x0000007C) Flash Block Protection for Secure Register                 */

        struct
        {
            __IOM uint16_t BPCN1 : 1;  /*!< [0..0] Block Protection for Secure CancelWriting to this bit
                                        *   is only possible when the FRDY bit in the FSTATR register
                                        *   is 1. Writing to this bit while FRDY bit = 0 is ignored.Writing
                                        *   to this bit is only possible when 16 bits are written and
                                        *   the value written to the KEY[7:0] bits is 0xB1.Written
                                        *   values are not retained by these bits (always read as 0x00).              */
            uint16_t          : 7;
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FBPROT1_b;
    };
    __IM uint16_t RESERVED12;

    union
    {
        __IM uint32_t FSTATR;          /*!< (@ 0x00000080) Flash Status                                               */

        struct
        {
            uint32_t                 : 6;
            __IM uint32_t FLWEERR    : 1; /*!< [6..6] Flash Write/Erase Protect Error Flag                               */
            uint32_t                 : 1;
            __IM uint32_t PRGSPD     : 1; /*!< [8..8] Programming-Suspended Status                                       */
            __IM uint32_t ERSSPD     : 1; /*!< [9..9] Erasure-Suspended Status                                           */
            __IM uint32_t DBFULL     : 1; /*!< [10..10] Data Buffer Full                                                 */
            __IM uint32_t SUSRDY     : 1; /*!< [11..11] Suspend Ready                                                    */
            __IM uint32_t PRGERR     : 1; /*!< [12..12] Programming Error                                                */
            __IM uint32_t ERSERR     : 1; /*!< [13..13] Erasure Error                                                    */
            __IM uint32_t ILGLERR    : 1; /*!< [14..14] Illegal Command Error                                            */
            __IM uint32_t FRDY       : 1; /*!< [15..15] Flash Ready                                                      */
            uint32_t                 : 4;
            __IM uint32_t  OTERR     : 1; /*!< [20..20] Other Error                                                      */
            __IOM uint32_t SECERR    : 1; /*!< [21..21] Security Error                                                   */
            __IM uint32_t  FESETERR  : 1; /*!< [22..22] FENTRY Setting Error                                             */
            __IM uint32_t  ILGCOMERR : 1; /*!< [23..23] Illegal Command Error                                            */
            uint32_t                 : 8;
        } FSTATR_b;
    };

    union
    {
        __IOM uint16_t FENTRYR;         /*!< (@ 0x00000084) Program/Erase Mode Entry                                   */

        struct
        {
            __IOM uint16_t FENTRYC : 1; /*!< [0..0] Code Flash P/E Mode Entry These bits can be written when
                                         *   FRDY bit in FSTATR register is "1". Writing to this bit
                                         *   in FRDY = "0" is ignored. Writing to these bits is enabled
                                         *   only when this register is accessed in 16-bit size and
                                         *   H'AA is written to KEY bits                                               */
            uint16_t               : 6;
            __IOM uint16_t FENTRYD : 1; /*!< [7..7] Data Flash P/E Mode Entry These bits can be written when
                                         *   FRDY bit in FSTATR register is "1". Writing to this bit
                                         *   in FRDY = "0" is ignored. Writing to these bits is enabled
                                         *   only when this register is accessed in 16-bit size and
                                         *   H'AA is written to KEY bits.                                              */
            __OM uint16_t KEY : 8;      /*!< [15..8] KEY Code                                                          */
        } FENTRYR_b;
    };
    __IM uint16_t RESERVED13;
    __IM uint32_t RESERVED14;

    union
    {
        __IOM uint16_t FSUINITR;       /*!< (@ 0x0000008C) Flash Sequencer Set-up Initialize                          */

        struct
        {
            __IOM uint16_t SUINIT : 1; /*!< [0..0] Set-up Initialization This bit can be written when FRDY
                                        *   bit of FSTATR register is "1". Writing to this bit in FRDY
                                        *   = "0" is ignored. Writing to these bits is enabled only
                                        *   when this register is accessed in 16-bit size and H'2D
                                        *   is written to KEY bits.                                                   */
            uint16_t          : 7;
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FSUINITR_b;
    };
    __IM uint16_t RESERVED15;
    __IM uint32_t RESERVED16[4];

    union
    {
        __IM uint16_t FCMDR;           /*!< (@ 0x000000A0) Flash Sequencer Command                                    */

        struct
        {
            __IM uint16_t PCMDR : 8;   /*!< [7..0] Previous Command Register                                          */
            __IM uint16_t CMDR  : 8;   /*!< [15..8] Command Register                                                  */
        } FCMDR_b;
    };
    __IM uint16_t RESERVED17;
    __IM uint32_t RESERVED18[7];

    union
    {
        __IM uint16_t FPESTAT;         /*!< (@ 0x000000C0) Program/Erase Error Status                                 */

        struct
        {
            __IM uint16_t PEERRST : 8; /*!< [7..0] P/E Error Status                                                   */
            uint16_t              : 8;
        } FPESTAT_b;
    };
    __IM uint16_t RESERVED19;
    __IM uint32_t RESERVED20[3];

    union
    {
        __IOM uint8_t FBCCNT;          /*!< (@ 0x000000D0) Blank Check Control                                        */

        struct
        {
            __IOM uint8_t BCDIR : 1;   /*!< [0..0] Blank Check Direction                                              */
            uint8_t             : 7;
        } FBCCNT_b;
    };
    __IM uint8_t  RESERVED21;
    __IM uint16_t RESERVED22;

    union
    {
        __IM uint8_t FBCSTAT;          /*!< (@ 0x000000D4) Blank Check Status                                         */

        struct
        {
            __IM uint8_t BCST : 1;     /*!< [0..0] Blank Check Status Bit                                             */
            uint8_t           : 7;
        } FBCSTAT_b;
    };
    __IM uint8_t  RESERVED23;
    __IM uint16_t RESERVED24;

    union
    {
        __IM uint32_t FPSADDR;         /*!< (@ 0x000000D8) Programmed Area Start Address                              */

        struct
        {
            __IM uint32_t PSADR : 19;  /*!< [18..0] Programmed Area Start Address NOTE: Indicates address
                                        *   of the first programmed data which is found in "Blank Check"
                                        *   command execution.                                                        */
            uint32_t : 13;
        } FPSADDR_b;
    };

    union
    {
        __IM uint32_t FAWMON;          /*!< (@ 0x000000DC) Flash Access Window Monitor                                */

        struct
        {
            __IM uint32_t FAWS : 11;   /*!< [10..0] Start Sector Address for Access Window NOTE: These bits
                                        *   indicate the start sector address for setting the access
                                        *   window that is located in the configuration area.                         */
            uint32_t           : 4;
            __IM uint32_t FSPR : 1;    /*!< [15..15] Protection Flag of programming the Access Window, Boot
                                        *   Flag and Temporary Boot Swap Control and "Config Clear"
                                        *   command execution                                                         */
            __IM uint32_t FAWE : 11;   /*!< [26..16] End Sector Address for Access Window NOTE: These bits
                                        *   indicate the end sector address for setting the access
                                        *   window that is located in the configuration area.                         */
            uint32_t            : 4;
            __IM uint32_t BTFLG : 1;   /*!< [31..31] Flag of Start-Up area select for Boot Swap                       */
        } FAWMON_b;
    };

    union
    {
        __IOM uint16_t FCPSR;           /*!< (@ 0x000000E0) FCU Process Switch                                         */

        struct
        {
            __IOM uint16_t ESUSPMD : 1; /*!< [0..0] Erasure-Suspended Mode                                             */
            uint16_t               : 15;
        } FCPSR_b;
    };
    __IM uint16_t RESERVED25;

    union
    {
        __IOM uint16_t FPCKAR;         /*!< (@ 0x000000E4) Flash Sequencer Processing Clock Frequency Notification    */

        struct
        {
            __IOM uint16_t PCKA : 8;   /*!< [7..0] Flash Sequencer Processing Clock Frequency These bits
                                        *   can be written when FRDY bit in FSTATR register is "1".
                                        *   Writing to this bit in FRDY = "0" is ignored. Writing to
                                        *   these bits is enabled only when this register is accessed
                                        *   in 16-bit size and H'1E is written to KEY bits.                           */
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FPCKAR_b;
    };
    __IM uint16_t RESERVED26;

    union
    {
        __IOM uint16_t FSUACR;         /*!< (@ 0x000000E8) Flash Start-Up Area Control Register                       */

        struct
        {
            __IOM uint16_t SAS : 2;    /*!< [1..0] Start Up Area Select These bits can be written when FRDY
                                        *   bit in FSTATR register is "1". Writing to this bit in FRDY
                                        *   = "0" is ignored. Writing to these bits is enabled only
                                        *   when this register is accessed in 16-bit size and H'66
                                        *   is written to KEY bits.                                                   */
            uint16_t          : 6;
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FSUACR_b;
    };
    __IM uint16_t RESERVED27;
} R_FACI_HP_Type;                      /*!< Size = 236 (0xec)                                                         */

/* =========================================================================================================================== */
/* ================                                         R_FACI_LP                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Flash Application Command Interface (R_FACI_LP)
 */

typedef struct                         /*!< (@ 0x407EC000) R_FACI_LP Structure                                        */
{
    __IM uint32_t RESERVED[36];
    __IOM uint8_t DFLCTL;              /*!< (@ 0x00000090) Flash P/E Mode Control Register                            */
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2;
    __IM uint32_t RESERVED3[27];

    union
    {
        __IOM uint8_t FPMCR;           /*!< (@ 0x00000100) Flash P/E Mode Control Register                            */

        struct
        {
            uint8_t            : 1;
            __IOM uint8_t FMS0 : 1;    /*!< [1..1] Flash Operating Mode Select 0FMS2,1,0: 000: Read mode
                                        *   011: Discharge mode 1 111: Discharge mode 2 101: Code Flash
                                        *   P/E mode 010: Data flash P/E mode Others: Setting prohibited.             */
            uint8_t             : 1;
            __IOM uint8_t RPDIS : 1;   /*!< [3..3] Code Flash P/E Disable                                             */
            __IOM uint8_t FMS1  : 1;   /*!< [4..4] The bit to make data flash a programming modeRefer to
                                        *   the description of the FMS0 bit.                                          */
            uint8_t            : 1;
            __IOM uint8_t VLPE : 1;    /*!< [6..6] Low-Voltage P/E Mode Enable                                        */
            __IOM uint8_t FMS2 : 1;    /*!< [7..7] Flash Operating Mode Select 2.Refer to the description
                                        *   of the FMS0 bit.                                                          */
        } FPMCR_b;
    };
    __IM uint8_t  RESERVED4;
    __IM uint16_t RESERVED5;

    union
    {
        __IOM uint8_t FASR;            /*!< (@ 0x00000104) Flash Area Select Register                                 */

        struct
        {
            __IOM uint8_t EXS : 1;     /*!< [0..0] Extra area select                                                  */
            uint8_t           : 7;
        } FASR_b;
    };
    __IM uint8_t  RESERVED6;
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint16_t FSARL;             /*!< (@ 0x00000108) Flash Processing Start Address Register L                  */

        struct
        {
            __IOM uint16_t FSAR15_0 : 16; /*!< [15..0] Start address                                                     */
        } FSARL_b;
    };
    __IM uint16_t RESERVED8;
    __IM uint32_t RESERVED9;

    union
    {
        __IOM uint16_t FSARH;             /*!< (@ 0x00000110) Flash Processing Start Address Register H                  */

        struct
        {
            __IOM uint16_t FSAR20_16 : 5; /*!< [4..0] Start address                                                      */
            uint16_t                 : 4;
            __IOM uint16_t FSAR31_25 : 7; /*!< [15..9] Start address                                                     */
        } FSARH_b;
    };
    __IM uint16_t RESERVED10;

    union
    {
        __IOM uint8_t FCR;             /*!< (@ 0x00000114) Flash Control Register                                     */

        struct
        {
            __IOM uint8_t CMD  : 4;    /*!< [3..0] Software Command Setting                                           */
            __IOM uint8_t DRC  : 1;    /*!< [4..4] Data Read Completion                                               */
            uint8_t            : 1;
            __IOM uint8_t STOP : 1;    /*!< [6..6] Forced Processing Stop                                             */
            __IOM uint8_t OPST : 1;    /*!< [7..7] Processing Start                                                   */
        } FCR_b;
    };
    __IM uint8_t  RESERVED11;
    __IM uint16_t RESERVED12;

    union
    {
        __IOM uint16_t FEARL;             /*!< (@ 0x00000118) Flash Processing End Address Register L                    */

        struct
        {
            __IOM uint16_t FEAR15_0 : 16; /*!< [15..0] End address                                                       */
        } FEARL_b;
    };
    __IM uint16_t RESERVED13;
    __IM uint32_t RESERVED14;

    union
    {
        __IOM uint32_t FEARH;             /*!< (@ 0x00000120) Flash Processing End Address Register H                    */

        struct
        {
            __IOM uint32_t FEAR20_16 : 5; /*!< [4..0] End address                                                        */
            uint32_t                 : 4;
            __IOM uint32_t FEAR31_25 : 7; /*!< [15..9] End address                                                       */
            uint32_t                 : 16;
        } FEARH_b;
    };

    union
    {
        __IOM uint32_t FRESETR;        /*!< (@ 0x00000124) Flash Reset Register                                       */

        struct
        {
            __IOM uint32_t FRESET : 1; /*!< [0..0] Software Reset of the registers                                    */
            uint32_t              : 31;
        } FRESETR_b;
    };

    union
    {
        __IM uint32_t FSTATR00;         /*!< (@ 0x00000128) Flash Status Register00                                    */

        struct
        {
            __IM uint32_t ERERR0   : 1; /*!< [0..0] Erase Error Flag0                                                  */
            __IM uint32_t PRGERR0  : 1; /*!< [1..1] Program Error Flag0                                                */
            __IM uint32_t PRGERR01 : 1; /*!< [2..2] Program Error Flag 01                                              */
            __IM uint32_t BCERR0   : 1; /*!< [3..3] Blank Check Error Flag0                                            */
            __IM uint32_t ILGLERR  : 1; /*!< [4..4] Illegal Command Error Flag                                         */
            __IM uint32_t EILGLERR : 1; /*!< [5..5] Extra Area Illegal Command Error Flag                              */
            uint32_t               : 26;
        } FSTATR00_b;
    };

    union
    {
        __IM uint32_t FSTATR1;         /*!< (@ 0x0000012C) Flash Status Register1                                     */

        struct
        {
            uint32_t            : 1;
            __IM uint32_t DRRDY : 1;   /*!< [1..1] Data read request                                                  */
            uint32_t            : 4;
            __IM uint32_t FRDY  : 1;   /*!< [6..6] End status signal of a sequencer                                   */
            __IM uint32_t EXRDY : 1;   /*!< [7..7] End status signal of a Extra programming sequencer                 */
            uint32_t            : 24;
        } FSTATR1_b;
    };

    union
    {
        __IOM uint32_t FWBL0;          /*!< (@ 0x00000130) Flash Write Buffer Register L0                             */

        struct
        {
            __IOM uint32_t WDATA : 16; /*!< [15..0] Program data of the program command                               */
            uint32_t             : 16;
        } FWBL0_b;
    };
    __IM uint32_t RESERVED15;

    union
    {
        __IOM uint32_t FWBH0;          /*!< (@ 0x00000138) Flash Write Buffer Register H0                             */

        struct
        {
            __IOM uint32_t WDATA : 16; /*!< [15..0] Program data of the program command                               */
            uint32_t             : 16;
        } FWBH0_b;
    };

    union
    {
        __IM uint32_t FSTATR01;        /*!< (@ 0x0000013C) Flash Status Register01                                    */

        struct
        {
            __IM uint32_t ERERR1  : 1; /*!< [0..0] Erase Error Flag1                                                  */
            __IM uint32_t PRGERR1 : 1; /*!< [1..1] Program Error Flag1                                                */
            uint32_t              : 1;
            __IM uint32_t BCERR1  : 1; /*!< [3..3] Blank Check Error Flag1                                            */
            uint32_t              : 28;
        } FSTATR01_b;
    };

    union
    {
        __IOM uint32_t FWBL1;               /*!< (@ 0x00000140) Flash Write Buffer Register L1                             */

        struct
        {
            __IOM uint32_t WDATA47_32 : 16; /*!< [15..0] Program data of the program command                               */
            uint32_t                  : 16;
        } FWBL1_b;
    };

    union
    {
        __IOM uint32_t FWBH1;               /*!< (@ 0x00000144) Flash Write Buffer Register H1                             */

        struct
        {
            __IOM uint32_t WDATA63_48 : 16; /*!< [15..0] Program data of the program command                               */
            uint32_t                  : 16;
        } FWBH1_b;
    };

    union
    {
        __IM uint32_t FRBL1;               /*!< (@ 0x00000148) Flash Read Buffer Register L1                              */

        struct
        {
            __IM uint32_t RDATA47_32 : 16; /*!< [15..0] Read data of the consecutive read command                         */
            uint32_t                 : 16;
        } FRBL1_b;
    };

    union
    {
        __IM uint32_t FRBH1;               /*!< (@ 0x0000014C) Flash Read Buffer Register H1                              */

        struct
        {
            __IM uint32_t RDATA63_48 : 16; /*!< [15..0] Read data of the consecutive read command                         */
            uint32_t                 : 16;
        } FRBH1_b;
    };
    __IM uint32_t RESERVED16[12];

    union
    {
        __OM uint32_t FPR;             /*!< (@ 0x00000180) Protection Unlock Register                                 */

        struct
        {
            __OM uint32_t FPR : 8;     /*!< [7..0] Protection Unlock Register                                         */
            uint32_t          : 24;
        } FPR_b;
    };

    union
    {
        __IM uint32_t FPSR;            /*!< (@ 0x00000184) Protection Unlock Status Register                          */

        struct
        {
            __IM uint32_t PERR : 1;    /*!< [0..0] Protect Error Flag                                                 */
            uint32_t           : 31;
        } FPSR_b;
    };

    union
    {
        __IM uint32_t FRBL0;           /*!< (@ 0x00000188) Flash Read Buffer Register L0                              */

        struct
        {
            __IM uint32_t RDATA : 16;  /*!< [15..0] Read data of the consecutive read command                         */
            uint32_t            : 16;
        } FRBL0_b;
    };
    __IM uint32_t RESERVED17;

    union
    {
        __IM uint32_t FRBH0;           /*!< (@ 0x00000190) Flash Read Buffer Register H0                              */

        struct
        {
            __IM uint32_t RDATA : 16;  /*!< [15..0] Read data of the consecutive read command                         */
            uint32_t            : 16;
        } FRBH0_b;
    };
    __IM uint32_t RESERVED18[11];

    union
    {
        __IM uint32_t FSCMR;           /*!< (@ 0x000001C0) Flash Start-Up Setting Monitor Register                    */

        struct
        {
            uint32_t            : 8;
            __IM uint32_t SASMF : 1;   /*!< [8..8] Start-up Area Setting Monitor Flag                                 */
            uint32_t            : 5;
            __IM uint32_t FSPR  : 1;   /*!< [14..14] Access Window Protection Flag                                    */
            uint32_t            : 17;
        } FSCMR_b;
    };
    __IM uint32_t RESERVED19;

    union
    {
        __IM uint32_t FAWSMR;          /*!< (@ 0x000001C8) Flash Access Window Start Address Monitor Register         */

        struct
        {
            __IM uint32_t FAWS : 12;   /*!< [11..0] Flash Access Window Start Address                                 */
            uint32_t           : 20;
        } FAWSMR_b;
    };
    __IM uint32_t RESERVED20;

    union
    {
        __IM uint32_t FAWEMR;          /*!< (@ 0x000001D0) Flash Access Window End Address Monitor Register           */

        struct
        {
            __IM uint32_t FAWE : 12;   /*!< [11..0] Flash Access Window End Address                                   */
            uint32_t           : 20;
        } FAWEMR_b;
    };
    __IM uint32_t RESERVED21;

    union
    {
        __IOM uint32_t FISR;           /*!< (@ 0x000001D8) Flash Initial Setting Register                             */

        struct
        {
            __IOM uint32_t PCKA : 6;   /*!< [5..0] Peripheral Clock Notification                                      */
            __IOM uint32_t SAS  : 2;   /*!< [7..6] Temporary boot swap mode                                           */
            uint32_t            : 24;
        } FISR_b;
    };

    union
    {
        __IOM uint32_t FEXCR;          /*!< (@ 0x000001DC) Flash Extra Area Control Register                          */

        struct
        {
            __IOM uint32_t CMD  : 3;   /*!< [2..0] Processing Start)                                                  */
            uint32_t            : 4;
            __IOM uint32_t OPST : 1;   /*!< [7..7] Software Command Setting                                           */
            uint32_t            : 24;
        } FEXCR_b;
    };

    union
    {
        __IM uint32_t FEAML;           /*!< (@ 0x000001E0) Flash Error Address Monitor Register L                     */

        struct
        {
            __IM uint32_t FEAM : 16;   /*!< [15..0] Flash Error Address Monitor Register                              */
            uint32_t           : 16;
        } FEAML_b;
    };
    __IM uint32_t RESERVED22;

    union
    {
        __IM uint32_t FEAMH;           /*!< (@ 0x000001E8) Flash Error Address Monitor Register H                     */

        struct
        {
            __IM uint32_t FEAM : 16;   /*!< [15..0] Flash Error Address Monitor Register                              */
            uint32_t           : 16;
        } FEAMH_b;
    };
    __IM uint32_t RESERVED23;

    union
    {
        __IM uint32_t FSTATR2;           /*!< (@ 0x000001F0) Flash Status Register2                                     */

        struct
        {
            __IM uint32_t  ERERR    : 1; /*!< [0..0] Erase Error Flag                                                   */
            __IM uint32_t  PRGERR1  : 1; /*!< [1..1] Program Error Flag                                                 */
            __IOM uint32_t PRGERR01 : 1; /*!< [2..2] Program Error Flag 01                                              */
            __IM uint32_t  BCERR    : 1; /*!< [3..3] Blank Check Error Flag                                             */
            __IM uint32_t  ILGLERR  : 1; /*!< [4..4] Illegal Command Error Flag                                         */
            __IM uint32_t  EILGLERR : 1; /*!< [5..5] Extra Area Illegal Command Error Flag                              */
            uint32_t                : 26;
        } FSTATR2_b;
    };
    __IM uint32_t  RESERVED24[3951];
    __IOM uint16_t FENTRYR_MF4;        /*!< (@ 0x00003FB0) Flash P/E Mode Entry Register for MF4                      */
    __IOM uint16_t FENTRYR;            /*!< (@ 0x00003FB2) Flash P/E Mode Entry Register                              */
    __IM uint32_t  RESERVED25[3];
    __IOM uint8_t  FLWAITR;            /*!< (@ 0x00003FC0) Flash Wait Cycle Register                                  */
    __IM uint8_t   RESERVED26;
    __IM uint16_t  RESERVED27;
    __IM uint32_t  RESERVED28;
    __IOM uint8_t  PFBER;              /*!< (@ 0x00003FC8) Prefetch Buffer Enable Register                            */
    __IM uint8_t   RESERVED29;
    __IM uint16_t  RESERVED30;
} R_FACI_LP_Type;                      /*!< Size = 16332 (0x3fcc)                                                     */

/* =========================================================================================================================== */
/* ================                                        R_CTSUTRIM                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief CTSU Trimming Registers (R_CTSUTRIM)
 */

typedef struct                         /*!< (@ 0x407EC000) R_CTSUTRIM Structure                                       */
{
    __IM uint32_t RESERVED[233];

    union
    {
        __IOM uint32_t CTSUTRIMA;         /*!< (@ 0x000003A4) CTSU Trimming Register A                                   */

        struct
        {
            __IOM uint32_t RTRIM     : 8; /*!< [7..0] CTSU Reference Resistance Adjustment                               */
            __IOM uint32_t DACTRIM   : 8; /*!< [15..8] Linearity Adjustment of Offset Current                            */
            __IOM uint32_t SUADJD    : 8; /*!< [23..16] CTSU SUCLK Frequency Adjustment                                  */
            __IOM uint32_t SUADJTRIM : 8; /*!< [31..24] Coefficient of variation for the reference load resistance
                                           *   (120k)                                                                    */
        } CTSUTRIMA_b;
    };

    union
    {
        __IOM uint32_t CTSUTRIMB;        /*!< (@ 0x000003A8) CTSU Trimming Register B                                   */

        struct
        {
            __IOM uint32_t TRESULT0 : 8; /*!< [7..0] Coefficient of variation for the reference load resistance
                                          *   (7.5k)                                                                    */
            __IOM uint32_t TRESULT1 : 8; /*!< [15..8] Coefficient of variation for the reference load resistance
                                          *   (15k)                                                                     */
            __IOM uint32_t TRESULT2 : 8; /*!< [23..16] Coefficient of variation for the reference load resistance
                                          *   (30k)                                                                     */
            __IOM uint32_t TRESULT3 : 8; /*!< [31..24] Coefficient of variation for the reference load resistance
                                          *   (60k)                                                                     */
        } CTSUTRIMB_b;
    };
} R_CTSUTRIM_Type;                       /*!< Size = 940 (0x3ac)                                                        */

/* =========================================================================================================================== */
/* ================                                         R_FCACHE                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Flash Memory Cache (R_FCACHE)
 */

typedef struct                         /*!< (@ 0x4001C000) R_FCACHE Structure                                         */
{
    __IM uint16_t RESERVED[128];

    union
    {
        __IOM uint16_t FCACHEE;          /*!< (@ 0x00000100) Flash Cache Enable Register                                */

        struct
        {
            __IOM uint16_t FCACHEEN : 1; /*!< [0..0] FCACHE Enable                                                      */
            uint16_t                : 15;
        } FCACHEE_b;
    };
    __IM uint16_t RESERVED1;

    union
    {
        __IOM uint16_t FCACHEIV;         /*!< (@ 0x00000104) Flash Cache Invalidate Register                            */

        struct
        {
            __IOM uint16_t FCACHEIV : 1; /*!< [0..0] Flash Cache Invalidate Register                                    */
            uint16_t                : 15;
        } FCACHEIV_b;
    };
    __IM uint16_t RESERVED2[11];

    union
    {
        __IOM uint8_t FLWT;            /*!< (@ 0x0000011C) Flash Wait Cycle Register                                  */

        struct
        {
            __IOM uint8_t FLWT : 3;    /*!< [2..0] Flash Wait Cycle                                                   */
            uint8_t            : 5;
        } FLWT_b;
    };
    __IM uint8_t  RESERVED3;
    __IM uint16_t RESERVED4[17];

    union
    {
        __IOM uint16_t FSAR;             /*!< (@ 0x00000140) Flash Security Attribution Register                        */

        struct
        {
            __IOM uint16_t FLWTSA   : 1; /*!< [0..0] FLWT Security Attribution                                          */
            uint16_t                : 7;
            __IOM uint16_t FCKMHZSA : 1; /*!< [8..8] FCKMHZ Security Attribution                                        */
            uint16_t                : 7;
        } FSAR_b;
    };
} R_FCACHE_Type;                         /*!< Size = 322 (0x142)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_GLCDC                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Graphics LCD Controller (R_GLCDC)
 */

typedef struct                         /*!< (@ 0x400E0000) R_GLCDC Structure                                          */
{
    union
    {
        __IOM uint32_t GR1_CLUT0[256]; /*!< (@ 0x00000000) Color Palette 0 Plane for Graphics 1 Plane                 */

        struct
        {
            __IOM uint32_t B : 8;      /*!< [7..0] B Value of Color Palette n Plane for Graphics m Plane              */
            __IOM uint32_t G : 8;      /*!< [15..8] G Value of Color Palette n Plane for Graphics m Plane             */
            __IOM uint32_t R : 8;      /*!< [23..16] R Value of Color Palette n Plane for Graphics m Plane            */
            __IOM uint32_t A : 8;      /*!< [31..24] Alpha Blending Value of Color Palette n Plane for Graphics
                                        *   m Plane                                                                   */
        } GR1_CLUT0_b[256];
    };

    union
    {
        __IOM uint32_t GR1_CLUT1[256]; /*!< (@ 0x00000400) Color Palette 1 Plane for Graphics 1 Plane                 */

        struct
        {
            __IOM uint32_t B : 8;      /*!< [7..0] B Value of Color Palette n Plane for Graphics m Plane              */
            __IOM uint32_t G : 8;      /*!< [15..8] G Value of Color Palette n Plane for Graphics m Plane             */
            __IOM uint32_t R : 8;      /*!< [23..16] R Value of Color Palette n Plane for Graphics m Plane            */
            __IOM uint32_t A : 8;      /*!< [31..24] Alpha Blending Value of Color Palette n Plane for Graphics
                                        *   m Plane                                                                   */
        } GR1_CLUT1_b[256];
    };

    union
    {
        __IOM uint32_t GR2_CLUT0[256]; /*!< (@ 0x00000800) Color Palette 0 Plane for Graphics 2 Plane                 */

        struct
        {
            __IOM uint32_t B : 8;      /*!< [7..0] B Value of Color Palette n Plane for Graphics m Plane              */
            __IOM uint32_t G : 8;      /*!< [15..8] G Value of Color Palette n Plane for Graphics m Plane             */
            __IOM uint32_t R : 8;      /*!< [23..16] R Value of Color Palette n Plane for Graphics m Plane            */
            __IOM uint32_t A : 8;      /*!< [31..24] Alpha Blending Value of Color Palette n Plane for Graphics
                                        *   m Plane                                                                   */
        } GR2_CLUT0_b[256];
    };

    union
    {
        __IOM uint32_t GR2_CLUT1[256]; /*!< (@ 0x00000C00) Color Palette 1 Plane for Graphics 2 Plane                 */

        struct
        {
            __IOM uint32_t B : 8;      /*!< [7..0] B Value of Color Palette n Plane for Graphics m Plane              */
            __IOM uint32_t G : 8;      /*!< [15..8] G Value of Color Palette n Plane for Graphics m Plane             */
            __IOM uint32_t R : 8;      /*!< [23..16] R Value of Color Palette n Plane for Graphics m Plane            */
            __IOM uint32_t A : 8;      /*!< [31..24] Alpha Blending Value of Color Palette n Plane for Graphics
                                        *   m Plane                                                                   */
        } GR2_CLUT1_b[256];
    };
    __IOM R_GLCDC_BG_Type     BG;      /*!< (@ 0x00001000) Background Registers                                       */
    __IM uint32_t             RESERVED[57];
    __IOM R_GLCDC_GR_Type     GR[2];   /*!< (@ 0x00001100) Layer Registers                                            */
    __IOM R_GLCDC_GAM_Type    GAM[3];  /*!< (@ 0x00001300) Gamma Settings                                             */
    __IOM R_GLCDC_OUT_Type    OUT;     /*!< (@ 0x000013C0) Output Control Registers                                   */
    __IM uint32_t             RESERVED1[6];
    __IOM R_GLCDC_TCON_Type   TCON;    /*!< (@ 0x00001400) Timing Control Registers                                   */
    __IM uint32_t             RESERVED2[5];
    __IOM R_GLCDC_SYSCNT_Type SYSCNT;  /*!< (@ 0x00001440) GLCDC System Control Registers                             */
} R_GLCDC_Type;                        /*!< Size = 5204 (0x1454)                                                      */

/* =========================================================================================================================== */
/* ================                                          R_GPT0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief General PWM Timer (R_GPT0)
 */

typedef struct                         /*!< (@ 0x40078000) R_GPT0 Structure                                           */
{
    union
    {
        __IOM uint32_t GTWP;           /*!< (@ 0x00000000) General PWM Timer Write-Protection Register                */

        struct
        {
            __IOM uint32_t WP    : 1;  /*!< [0..0] Register Write Disable                                             */
            __IOM uint32_t STRWP : 1;  /*!< [1..1] GTSTR.CSTRT Bit Write Disable                                      */
            __IOM uint32_t STPWP : 1;  /*!< [2..2] GTSTP.CSTOP Bit Write Disable                                      */
            __IOM uint32_t CLRWP : 1;  /*!< [3..3] GTCLR.CCLR Bit Write Disable                                       */
            __IOM uint32_t CMNWP : 1;  /*!< [4..4] Common Register Write Disabled                                     */
            uint32_t             : 3;
            __OM uint32_t PRKEY  : 8;  /*!< [15..8] GTWP Key Code                                                     */
            uint32_t             : 16;
        } GTWP_b;
    };

    union
    {
        __IOM uint32_t GTSTR;           /*!< (@ 0x00000004) General PWM Timer Software Start Register                  */

        struct
        {
            __IOM uint32_t CSTRT0 : 1;  /*!< [0..0] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT1 : 1;  /*!< [1..1] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT2 : 1;  /*!< [2..2] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT3 : 1;  /*!< [3..3] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT4 : 1;  /*!< [4..4] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT5 : 1;  /*!< [5..5] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT6 : 1;  /*!< [6..6] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT7 : 1;  /*!< [7..7] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT8 : 1;  /*!< [8..8] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT9 : 1;  /*!< [9..9] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT10 : 1; /*!< [10..10] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT11 : 1; /*!< [11..11] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT12 : 1; /*!< [12..12] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT13 : 1; /*!< [13..13] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            uint32_t : 18;
        } GTSTR_b;
    };

    union
    {
        __IOM uint32_t GTSTP;           /*!< (@ 0x00000008) General PWM Timer Software Stop Register                   */

        struct
        {
            __IOM uint32_t CSTOP0 : 1;  /*!< [0..0] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP1 : 1;  /*!< [1..1] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP2 : 1;  /*!< [2..2] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP3 : 1;  /*!< [3..3] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP4 : 1;  /*!< [4..4] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP5 : 1;  /*!< [5..5] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP6 : 1;  /*!< [6..6] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP7 : 1;  /*!< [7..7] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP8 : 1;  /*!< [8..8] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP9 : 1;  /*!< [9..9] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP10 : 1; /*!< [10..10] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP11 : 1; /*!< [11..11] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP12 : 1; /*!< [12..12] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP13 : 1; /*!< [13..13] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            uint32_t : 18;
        } GTSTP_b;
    };

    union
    {
        __OM uint32_t GTCLR;           /*!< (@ 0x0000000C) General PWM Timer Software Clear Register                  */

        struct
        {
            __OM uint32_t CCLR0  : 1;  /*!< [0..0] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR1  : 1;  /*!< [1..1] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR2  : 1;  /*!< [2..2] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR3  : 1;  /*!< [3..3] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR4  : 1;  /*!< [4..4] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR5  : 1;  /*!< [5..5] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR6  : 1;  /*!< [6..6] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR7  : 1;  /*!< [7..7] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR8  : 1;  /*!< [8..8] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR9  : 1;  /*!< [9..9] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR10 : 1;  /*!< [10..10] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR11 : 1;  /*!< [11..11] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR12 : 1;  /*!< [12..12] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR13 : 1;  /*!< [13..13] Channel GTCNT Count Clear                                        */
            uint32_t             : 18;
        } GTCLR_b;
    };

    union
    {
        __IOM uint32_t GTSSR;            /*!< (@ 0x00000010) General PWM Timer Start Source Select Register             */

        struct
        {
            __IOM uint32_t SSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSELCA : 1;   /*!< [16..16] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCB : 1;   /*!< [17..17] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCC : 1;   /*!< [18..18] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCD : 1;   /*!< [19..19] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCE : 1;   /*!< [20..20] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCF : 1;   /*!< [21..21] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCG : 1;   /*!< [22..22] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCH : 1;   /*!< [23..23] ELC_GPT Event Source Counter Start Enable                        */
            uint32_t              : 7;
            __IOM uint32_t CSTRT  : 1;   /*!< [31..31] Software Source Counter Start Enable                             */
        } GTSSR_b;
    };

    union
    {
        __IOM uint32_t GTPSR;            /*!< (@ 0x00000014) General PWM Timer Stop Source Select Register              */

        struct
        {
            __IOM uint32_t PSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSELCA : 1;   /*!< [16..16] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCB : 1;   /*!< [17..17] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCC : 1;   /*!< [18..18] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCD : 1;   /*!< [19..19] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCE : 1;   /*!< [20..20] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCF : 1;   /*!< [21..21] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCG : 1;   /*!< [22..22] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCH : 1;   /*!< [23..23] ELC_GPTA Event Source Counter Stop Enable                        */
            uint32_t              : 7;
            __IOM uint32_t CSTOP  : 1;   /*!< [31..31] Software Source Counter Stop Enable                              */
        } GTPSR_b;
    };

    union
    {
        __IOM uint32_t GTCSR;            /*!< (@ 0x00000018) General PWM Timer Clear Source Select Register             */

        struct
        {
            __IOM uint32_t CSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSELCA : 1;   /*!< [16..16] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCB : 1;   /*!< [17..17] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCC : 1;   /*!< [18..18] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCD : 1;   /*!< [19..19] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCE : 1;   /*!< [20..20] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCF : 1;   /*!< [21..21] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCG : 1;   /*!< [22..22] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCH : 1;   /*!< [23..23] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSCMSC : 3;   /*!< [26..24] Compare Match/Input Capture/Synchronous counter clearing
                                          *   Source Counter Clear Enable.                                              */
            __IOM uint32_t CP1CCE : 1;   /*!< [27..27] Complementary PWM mode1 Crest Source Counter Clear
                                          *   Enable (This bit is only available in GPT324 to GPT329.
                                          *   In GPT320 to GPT323, this bit is read as 0. The write value
                                          *   should be 0.)                                                             */
            uint32_t            : 3;
            __IOM uint32_t CCLR : 1;     /*!< [31..31] Software Source Counter Clear Enable                             */
        } GTCSR_b;
    };

    union
    {
        __IOM uint32_t GTUPSR;           /*!< (@ 0x0000001C) General PWM Timer Up Count Source Select Register          */

        struct
        {
            __IOM uint32_t USGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USELCA : 1;   /*!< [16..16] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCB : 1;   /*!< [17..17] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCC : 1;   /*!< [18..18] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCD : 1;   /*!< [19..19] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCE : 1;   /*!< [20..20] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCF : 1;   /*!< [21..21] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCG : 1;   /*!< [22..22] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCH : 1;   /*!< [23..23] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USILVL : 4;   /*!< [27..24] External Input Level Source Count-Up Enable                      */
            uint32_t              : 4;
        } GTUPSR_b;
    };

    union
    {
        __IOM uint32_t GTDNSR;           /*!< (@ 0x00000020) General PWM Timer Down Count Source Select Register        */

        struct
        {
            __IOM uint32_t DSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSELCA : 1;   /*!< [16..16] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCB : 1;   /*!< [17..17] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCC : 1;   /*!< [18..18] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCD : 1;   /*!< [19..19] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCE : 1;   /*!< [20..20] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCF : 1;   /*!< [21..21] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCG : 1;   /*!< [22..22] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCH : 1;   /*!< [23..23] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSILVL : 4;   /*!< [27..24] External Input Level Source Count-Down Enable                    */
            uint32_t              : 4;
        } GTDNSR_b;
    };

    union
    {
        __IOM uint32_t GTICASR;          /*!< (@ 0x00000024) General PWM Timer Input Capture Source Select
                                          *                  Register A                                                 */

        struct
        {
            __IOM uint32_t ASGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASCARBL : 1;  /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASELCA : 1;   /*!< [16..16] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCB : 1;   /*!< [17..17] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCC : 1;   /*!< [18..18] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCD : 1;   /*!< [19..19] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCE : 1;   /*!< [20..20] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCF : 1;   /*!< [21..21] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCG : 1;   /*!< [22..22] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCH : 1;   /*!< [23..23] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            uint32_t              : 8;
        } GTICASR_b;
    };

    union
    {
        __IOM uint32_t GTICBSR;          /*!< (@ 0x00000028) General PWM Timer Input Capture Source Select
                                          *                  Register B                                                 */

        struct
        {
            __IOM uint32_t BSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSCARBL : 1;  /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSELCA : 1;   /*!< [16..16] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCB : 1;   /*!< [17..17] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCC : 1;   /*!< [18..18] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCD : 1;   /*!< [19..19] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCE : 1;   /*!< [20..20] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCF : 1;   /*!< [21..21] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCG : 1;   /*!< [22..22] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCH : 1;   /*!< [23..23] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            uint32_t              : 8;
        } GTICBSR_b;
    };

    union
    {
        __IOM uint32_t GTCR;           /*!< (@ 0x0000002C) General PWM Timer Control Register                         */

        struct
        {
            __IOM uint32_t CST  : 1;   /*!< [0..0] Count Start                                                        */
            uint32_t            : 15;
            __IOM uint32_t MD   : 3;   /*!< [18..16] Mode Select                                                      */
            uint32_t            : 4;
            __IOM uint32_t TPCS : 4;   /*!< [26..23] Timer Prescaler Select                                           */
            uint32_t            : 5;
        } GTCR_b;
    };

    union
    {
        __IOM uint32_t GTUDDTYC;       /*!< (@ 0x00000030) General PWM Timer Count Direction and Duty Setting
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t UD     : 1; /*!< [0..0] Count Direction Setting                                            */
            __IOM uint32_t UDF    : 1; /*!< [1..1] Forcible Count Direction Setting                                   */
            uint32_t              : 14;
            __IOM uint32_t OADTY  : 2; /*!< [17..16] GTIOCA Output Duty Setting                                       */
            __IOM uint32_t OADTYF : 1; /*!< [18..18] Forcible GTIOCA Output Duty Setting                              */
            __IOM uint32_t OADTYR : 1; /*!< [19..19] GTIOCA Output Value Selecting after Releasing 0 percent/100
                                        *   percent Duty Setting                                                      */
            uint32_t              : 4;
            __IOM uint32_t OBDTY  : 2; /*!< [25..24] GTIOCB Output Duty Setting                                       */
            __IOM uint32_t OBDTYF : 1; /*!< [26..26] Forcible GTIOCB Output Duty Setting                              */
            __IOM uint32_t OBDTYR : 1; /*!< [27..27] GTIOCB Output Value Selecting after Releasing 0 percent/100
                                        *   percent Duty Setting                                                      */
            uint32_t : 4;
        } GTUDDTYC_b;
    };

    union
    {
        __IOM uint32_t GTIOR;          /*!< (@ 0x00000034) General PWM Timer I/O Control Register                     */

        struct
        {
            __IOM uint32_t GTIOA  : 5; /*!< [4..0] GTIOCA Pin Function Select                                         */
            __IOM uint32_t CPSCIR : 1; /*!< [5..5] Complementary PWM Mode Initial Output at Synchronous
                                        *   Clear Disable.(This bit is only available in GPT324 to
                                        *   GPT329. In GPT320 to GPT323, this bit is read as 0. The
                                        *   write value should be 0.)                                                 */
            __IOM uint32_t OADFLT : 1; /*!< [6..6] GTIOCA Pin Output Value Setting at the Count Stop                  */
            __IOM uint32_t OAHLD  : 1; /*!< [7..7] GTIOCA Pin Output Setting at the Start/Stop Count                  */
            __IOM uint32_t OAE    : 1; /*!< [8..8] GTIOCA Pin Output Enable                                           */
            __IOM uint32_t OADF   : 2; /*!< [10..9] GTIOCA Pin Disable Value Setting                                  */
            __IOM uint32_t OAEOCD : 1; /*!< [11..11] GTCCRA Compare Match Cycle End Output Invalidate.(This
                                        *   bit is only available in GPT324 to GPT329. In GPT320 to
                                        *   GPT323, this bit is read as 0. The write value should be
                                        *   0.)                                                                       */
            __IOM uint32_t PSYE   : 1; /*!< [12..12] PWM Synchronous output Enable                                    */
            __IOM uint32_t NFAEN  : 1; /*!< [13..13] Noise Filter A Enable                                            */
            __IOM uint32_t NFCSA  : 2; /*!< [15..14] Noise Filter A Sampling Clock Select                             */
            __IOM uint32_t GTIOB  : 5; /*!< [20..16] GTIOCB Pin Function Select                                       */
            uint32_t              : 1;
            __IOM uint32_t OBDFLT : 1; /*!< [22..22] GTIOCB Pin Output Value Setting at the Count Stop                */
            __IOM uint32_t OBHLD  : 1; /*!< [23..23] GTIOCB Pin Output Setting at the Start/Stop Count                */
            __IOM uint32_t OBE    : 1; /*!< [24..24] GTIOCB Pin Output Enable                                         */
            __IOM uint32_t OBDF   : 2; /*!< [26..25] GTIOCB Pin Disable Value Setting                                 */
            __IOM uint32_t OBEOCD : 1; /*!< [27..27] GTCCRB Compare Match Cycle End Output Invalidate.(This
                                        *   bit is only available in GPT324 to GPT329. In GPT320 to
                                        *   GPT323, this bit is read as 0. The write value should be
                                        *   0.)                                                                       */
            uint32_t             : 1;
            __IOM uint32_t NFBEN : 1;  /*!< [29..29] Noise Filter B Enable                                            */
            __IOM uint32_t NFCSB : 2;  /*!< [31..30] Noise Filter B Sampling Clock Select                             */
        } GTIOR_b;
    };

    union
    {
        __IOM uint32_t GTINTAD;        /*!< (@ 0x00000038) General PWM Timer Interrupt Output Setting Register        */

        struct
        {
            uint32_t               : 24;
            __IOM uint32_t GRP     : 2; /*!< [25..24] Output Disable Source Select                                     */
            uint32_t               : 2;
            __IOM uint32_t GRPDTE  : 1; /*!< [28..28] Dead Time Error Output Disable Request Enable                    */
            __IOM uint32_t GRPABH  : 1; /*!< [29..29] Same Time Output Level High Disable Request Enable               */
            __IOM uint32_t GRPABL  : 1; /*!< [30..30] Same Time Output Level Low Disable Request Enable                */
            __IOM uint32_t GTINTPC : 1; /*!< [31..31] Period Count Function Finish Interrupt Enable                    */
        } GTINTAD_b;
    };

    union
    {
        __IOM uint32_t GTST;            /*!< (@ 0x0000003C) General PWM Timer Status Register                          */

        struct
        {
            __IOM uint32_t TCFA  : 1;   /*!< [0..0] Input Capture/Compare Match Flag A                                 */
            __IOM uint32_t TCFB  : 1;   /*!< [1..1] Input Capture/Compare Match Flag B                                 */
            __IOM uint32_t TCFC  : 1;   /*!< [2..2] Input Compare Match Flag C                                         */
            __IOM uint32_t TCFD  : 1;   /*!< [3..3] Input Compare Match Flag D                                         */
            __IOM uint32_t TCFE  : 1;   /*!< [4..4] Input Compare Match Flag E                                         */
            __IOM uint32_t TCFF  : 1;   /*!< [5..5] Input Compare Match Flag F                                         */
            __IOM uint32_t TCFPO : 1;   /*!< [6..6] Overflow Flag                                                      */
            __IOM uint32_t TCFPU : 1;   /*!< [7..7] Underflow Flag                                                     */
            __IM uint32_t  ITCNT : 3;   /*!< [10..8] GTCIV/GTCIU Interrupt Skipping Count Counter(Counter
                                         *   for counting the number of times a timer interrupt has
                                         *   been skipped.)                                                            */
            uint32_t               : 4;
            __IM uint32_t  TUCF    : 1; /*!< [15..15] Count Direction Flag                                             */
            __IOM uint32_t ADTRAUF : 1; /*!< [16..16] GTADTRA Compare Match (Up-Counting) A/D Converter Start
                                         *   Request Interrupt Enable                                                  */
            __IOM uint32_t ADTRADF : 1; /*!< [17..17] GTADTRA Compare Match(Down-Counting) A/D Convertor
                                         *   Start Request Flag                                                        */
            __IOM uint32_t ADTRBUF : 1; /*!< [18..18] GTADTRB Compare Match(Up-Counting) A/D Convertor Start
                                         *   Request Flag                                                              */
            __IOM uint32_t ADTRBDF : 1; /*!< [19..19] GTADTRB Compare Match(Down-Counting) A/D Convertor
                                         *   Start Request Flag                                                        */
            uint32_t             : 4;
            __IM uint32_t ODF    : 1;   /*!< [24..24] Output Disable Flag                                              */
            uint32_t             : 3;
            __IM uint32_t  DTEF  : 1;   /*!< [28..28] Dead Time Error Flag                                             */
            __IM uint32_t  OABHF : 1;   /*!< [29..29] Same Time Output Level High Disable Request Enable               */
            __IM uint32_t  OABLF : 1;   /*!< [30..30] Same Time Output Level Low Disable Request Enable                */
            __IOM uint32_t PCF   : 1;   /*!< [31..31] Period Count Function Finish Flag                                */
        } GTST_b;
    };

    union
    {
        __IOM uint32_t GTBER;          /*!< (@ 0x00000040) General PWM Timer Buffer Enable Register                   */

        struct
        {
            __IOM uint32_t BD0    : 1; /*!< [0..0] BD[0]: GTCCR Buffer Operation Disable                              */
            __IOM uint32_t BD1    : 1; /*!< [1..1] BD[1]: GTPR Buffer Operation Disable                               */
            __IOM uint32_t BD2    : 1; /*!< [2..2] BD[2]: GTADTR Buffer Operation DisableBD                           */
            __IOM uint32_t BD3    : 1; /*!< [3..3] BD[3]: GTDV Buffer Operation DisableBD[2]                          */
            uint32_t              : 12;
            __IOM uint32_t CCRA   : 2; /*!< [17..16] GTCCRA Buffer Operation                                          */
            __IOM uint32_t CCRB   : 2; /*!< [19..18] GTCCRB Buffer Operation                                          */
            __IOM uint32_t PR     : 2; /*!< [21..20] GTPR Buffer Operation                                            */
            __OM uint32_t  CCRSWT : 1; /*!< [22..22] GTCCRA and GTCCRB Forcible Buffer OperationThis bit
                                        *   is read as 0.                                                             */
            uint32_t             : 1;
            __IOM uint32_t ADTTA : 2;  /*!< [25..24] GTADTRA Buffer Transfer Timing Select in the Triangle
                                        *   wavesNOTE: In the Saw waves, values other than 0 0: Transfer
                                        *   at an underflow (in down-counting) or overflow (in up-counting)
                                        *   is performed.                                                             */
            __IOM uint32_t ADTDA : 1;  /*!< [26..26] GTADTRA Double Buffer Operation                                  */
            uint32_t             : 1;
            __IOM uint32_t ADTTB : 2;  /*!< [29..28] GTADTRB Buffer Transfer Timing Select in the Triangle
                                        *   wavesNOTE: In the Saw waves, values other than 0 0: Transfer
                                        *   at an underflow (in down-counting) or overflow (in up-counting)
                                        *   is performed.                                                             */
            __IOM uint32_t ADTDB : 1;  /*!< [30..30] GTADTRB Double Buffer Operation                                  */
            uint32_t             : 1;
        } GTBER_b;
    };

    union
    {
        __IOM uint32_t GTITC;          /*!< (@ 0x00000044) General PWM Timer Interrupt and A/D Converter
                                        *                  Start Request Skipping Setting Register                    */

        struct
        {
            __IOM uint32_t ITLA  : 1;  /*!< [0..0] GTCCRA Compare Match/Input Capture Interrupt Link                  */
            __IOM uint32_t ITLB  : 1;  /*!< [1..1] GTCCRB Compare Match/Input Capture Interrupt Link                  */
            __IOM uint32_t ITLC  : 1;  /*!< [2..2] GTCCRC Compare Match Interrupt Link                                */
            __IOM uint32_t ITLD  : 1;  /*!< [3..3] GTCCRD Compare Match Interrupt Link                                */
            __IOM uint32_t ITLE  : 1;  /*!< [4..4] GTCCRE Compare Match Interrupt Link                                */
            __IOM uint32_t ITLF  : 1;  /*!< [5..5] GTCCRF Compare Match Interrupt Link                                */
            __IOM uint32_t IVTC  : 2;  /*!< [7..6] GPT_OVF/GPT_UDF Interrupt Skipping Function Select                 */
            __IOM uint32_t IVTT  : 3;  /*!< [10..8] GPT_OVF/GPT_UDF Interrupt Skipping Count Select                   */
            uint32_t             : 1;
            __IOM uint32_t ADTAL : 1;  /*!< [12..12] GTADTRA A/D Converter Start Request Link                         */
            uint32_t             : 1;
            __IOM uint32_t ADTBL : 1;  /*!< [14..14] GTADTRB A/D Converter Start Request Link                         */
            uint32_t             : 17;
        } GTITC_b;
    };

    union
    {
        __IOM uint32_t GTCNT;          /*!< (@ 0x00000048) General PWM Timer Counter                                  */

        struct
        {
            __IOM uint32_t GTCNT : 32; /*!< [31..0] Counter                                                           */
        } GTCNT_b;
    };

    union
    {
        __IOM uint32_t GTCCR[6];       /*!< (@ 0x0000004C) General PWM Timer Compare Capture Register                 */

        struct
        {
            __IOM uint32_t GTCCR : 32; /*!< [31..0] Compare Capture Register A                                        */
        } GTCCR_b[6];
    };

    union
    {
        __IOM uint32_t GTPR;           /*!< (@ 0x00000064) General PWM Timer Cycle Setting Register                   */

        struct
        {
            __IOM uint32_t GTPR : 32;  /*!< [31..0] Cycle Setting Register                                            */
        } GTPR_b;
    };

    union
    {
        __IOM uint32_t GTPBR;          /*!< (@ 0x00000068) General PWM Timer Cycle Setting Buffer Register            */

        struct
        {
            __IOM uint32_t GTPBR : 32; /*!< [31..0] Cycle Setting Buffer Register                                     */
        } GTPBR_b;
    };

    union
    {
        __IOM uint32_t GTPDBR;          /*!< (@ 0x0000006C) General PWM Timer Cycle Setting Double-Buffer
                                         *                  Register                                                   */

        struct
        {
            __IOM uint32_t GTPDBR : 32; /*!< [31..0] Cycle Setting Double-Buffer Register                              */
        } GTPDBR_b;
    };

    union
    {
        __IOM uint32_t GTADTRA;          /*!< (@ 0x00000070) A/D Converter Start Request Timing Register A              */

        struct
        {
            __IOM uint32_t GTADTRA : 32; /*!< [31..0] A/D Converter Start Request Timing Register A                     */
        } GTADTRA_b;
    };

    union
    {
        __IOM uint32_t GTADTBRA;          /*!< (@ 0x00000074) A/D Converter Start Request Timing Buffer Register
                                           *                  A                                                          */

        struct
        {
            __IOM uint32_t GTADTBRA : 32; /*!< [31..0] A/D Converter Start Request Timing Buffer Register A              */
        } GTADTBRA_b;
    };

    union
    {
        __IOM uint32_t GTADTDBRA;          /*!< (@ 0x00000078) A/D Converter Start Request Timing Double-Buffer
                                            *                  Register A                                                 */

        struct
        {
            __IOM uint32_t GTADTDBRA : 32; /*!< [31..0] A/D Converter Start Request Timing Double-Buffer Register
                                            *   A                                                                         */
        } GTADTDBRA_b;
    };

    union
    {
        __IOM uint32_t GTADTRB;          /*!< (@ 0x0000007C) A/D Converter Start Request Timing Register B              */

        struct
        {
            __IOM uint32_t GTADTRB : 32; /*!< [31..0] A/D Converter Start Request Timing Register B                     */
        } GTADTRB_b;
    };

    union
    {
        __IOM uint32_t GTADTBRB;          /*!< (@ 0x00000080) A/D Converter Start Request Timing Buffer Register
                                           *                  B                                                          */

        struct
        {
            __IOM uint32_t GTADTBRB : 32; /*!< [31..0] A/D Converter Start Request Timing Buffer Register B              */
        } GTADTBRB_b;
    };

    union
    {
        __IOM uint32_t GTADTDBRB;          /*!< (@ 0x00000084) A/D Converter Start Request Timing Double-Buffer
                                            *                  Register B                                                 */

        struct
        {
            __IOM uint32_t GTADTDBRB : 32; /*!< [31..0] A/D Converter Start Request Timing Double-Buffer Register
                                            *   B                                                                         */
        } GTADTDBRB_b;
    };

    union
    {
        __IOM uint32_t GTDTCR;         /*!< (@ 0x00000088) General PWM Timer Dead Time Control Register               */

        struct
        {
            __IOM uint32_t TDE   : 1;  /*!< [0..0] Negative-Phase Waveform Setting                                    */
            uint32_t             : 3;
            __IOM uint32_t TDBUE : 1;  /*!< [4..4] GTDVU Buffer Operation Enable                                      */
            __IOM uint32_t TDBDE : 1;  /*!< [5..5] GTDVD Buffer Operation Enable                                      */
            uint32_t             : 2;
            __IOM uint32_t TDFER : 1;  /*!< [8..8] GTDVD Setting                                                      */
            uint32_t             : 23;
        } GTDTCR_b;
    };

    union
    {
        __IOM uint32_t GTDVU;          /*!< (@ 0x0000008C) General PWM Timer Dead Time Value Register U               */

        struct
        {
            __IOM uint32_t GTDVU : 32; /*!< [31..0] Dead Time Value Register U                                        */
        } GTDVU_b;
    };

    union
    {
        __IOM uint32_t GTDVD;          /*!< (@ 0x00000090) General PWM Timer Dead Time Value Register D               */

        struct
        {
            __IOM uint32_t GTDVD : 32; /*!< [31..0] Dead Time Value Register D                                        */
        } GTDVD_b;
    };

    union
    {
        __IOM uint32_t GTDBU;          /*!< (@ 0x00000094) General PWM Timer Dead Time Buffer Register U              */

        struct
        {
            __IOM uint32_t GTDVU : 32; /*!< [31..0] Dead Time Buffer Register U                                       */
        } GTDBU_b;
    };

    union
    {
        __IOM uint32_t GTDBD;          /*!< (@ 0x00000098) General PWM Timer Dead Time Buffer Register D              */

        struct
        {
            __IOM uint32_t GTDBD : 32; /*!< [31..0] Dead Time Buffer Register D                                       */
        } GTDBD_b;
    };

    union
    {
        __IM uint32_t GTSOS;           /*!< (@ 0x0000009C) General PWM Timer Output Protection Function
                                        *                  Status Register                                            */

        struct
        {
            __IM uint32_t SOS : 2;     /*!< [1..0] Output Protection Function Status                                  */
            uint32_t          : 30;
        } GTSOS_b;
    };

    union
    {
        __IOM uint32_t GTSOTR;         /*!< (@ 0x000000A0) General PWM Timer Output Protection Function
                                        *                  Temporary Release Register                                 */

        struct
        {
            __IOM uint32_t SOTR : 1;   /*!< [0..0] Output Protection Function Temporary Release                       */
            uint32_t            : 31;
        } GTSOTR_b;
    };
    __IM uint32_t RESERVED[5];

    union
    {
        __IOM uint32_t GTICLF;           /*!< (@ 0x000000B8) General PWM Timer Inter Channel Logical Operation
                                          *                  Function Setting Register                                  */

        struct
        {
            __IOM uint32_t ICLFA    : 3; /*!< [2..0] GTIOCnA Output Logical Operation Function Select                   */
            uint32_t                : 1;
            __IOM uint32_t ICLFSELC : 6; /*!< [9..4] Inter Channel Signal C Select                                      */
            uint32_t                : 6;
            __IOM uint32_t ICLFB    : 3; /*!< [18..16] GTIOCnB Output Logical Operation Function Select                 */
            uint32_t                : 1;
            __IOM uint32_t ICLFSELD : 6; /*!< [25..20] Inter Channel Signal D Select                                    */
            uint32_t                : 6;
        } GTICLF_b;
    };

    union
    {
        __IOM uint32_t GTPC;           /*!< (@ 0x000000BC) General PWM Timer Period Count Register                    */

        struct
        {
            __IOM uint32_t PCEN : 1;   /*!< [0..0] Period Count Function Enable                                       */
            uint32_t            : 7;
            __IOM uint32_t ASTP : 1;   /*!< [8..8] Automatic Stop Function Enable                                     */
            uint32_t            : 7;
            __IOM uint32_t PCNT : 12;  /*!< [27..16] Period Counter                                                   */
            uint32_t            : 4;
        } GTPC_b;
    };
    __IM uint32_t RESERVED1[4];

    union
    {
        __IOM uint32_t GTSECSR;         /*!< (@ 0x000000D0) General PWM Timer Operation Enable Bit Simultaneous
                                         *                  Control Channel Select Register                            */

        struct
        {
            __IOM uint32_t SECSEL0 : 1; /*!< [0..0] Channel 0 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL1 : 1; /*!< [1..1] Channel 1 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL2 : 1; /*!< [2..2] Channel 2 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL3 : 1; /*!< [3..3] Channel 3 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL4 : 1; /*!< [4..4] Channel 4 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL5 : 1; /*!< [5..5] Channel 5 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL6 : 1; /*!< [6..6] Channel 6 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL7 : 1; /*!< [7..7] Channel 7 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL8 : 1; /*!< [8..8] Channel 8 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL9 : 1; /*!< [9..9] Channel 9 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            uint32_t : 22;
        } GTSECSR_b;
    };

    union
    {
        __IOM uint32_t GTSECR;         /*!< (@ 0x000000D4) General PWM Timer Operation Enable Bit Simultaneous
                                        *                  Control Register                                           */

        struct
        {
            __IOM uint32_t SBDCE : 1;  /*!< [0..0] GTCCR Register Buffer Operation Simultaneous Enable                */
            __IOM uint32_t SBDPE : 1;  /*!< [1..1] GTPR Register Buffer Operation Simultaneous Enable                 */
            uint32_t             : 6;
            __IOM uint32_t SBDCD : 1;  /*!< [8..8] GTCCR Register Buffer Operation Simultaneous Disable               */
            __IOM uint32_t SBDPD : 1;  /*!< [9..9] GTPR Register Buffer Operation Simultaneous Disable                */
            uint32_t             : 6;
            __IOM uint32_t SPCE  : 1;  /*!< [16..16] Period Count Function Simultaneous Enable                        */
            uint32_t             : 7;
            __IOM uint32_t SPCD  : 1;  /*!< [24..24] Period Count Function Simultaneous Disable                       */
            uint32_t             : 7;
        } GTSECR_b;
    };
} R_GPT0_Type;                         /*!< Size = 216 (0xd8)                                                         */

/* =========================================================================================================================== */
/* ================                                        R_GPT_GTCLK                                        ================ */
/* =========================================================================================================================== */

/**
 * @brief GTCLK (R_GPT_GTCLK)
 */

typedef struct                         /*!< (@ 0x40169B00) R_GPT_GTCLK Structure                                      */
{
    union
    {
        __IOM uint32_t GTCLKCR;        /*!< (@ 0x00000000) General PWM Timer Clock Control Register                   */

        struct
        {
            __IOM uint32_t BPEN : 1;   /*!< [0..0] Synchronization Circuit Bypass Enable                              */
            uint32_t            : 31;
        } GTCLKCR_b;
    };
} R_GPT_GTCLK_Type;                    /*!< Size = 4 (0x4)                                                            */

/* =========================================================================================================================== */
/* ================                                         R_GPT_ODC                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief PWM Delay Generation Circuit (R_GPT_ODC)
 */

typedef struct                         /*!< (@ 0x4007B000) R_GPT_ODC Structure                                        */
{
    union
    {
        __IOM uint16_t GTDLYCR1;       /*!< (@ 0x00000000) PWM Output Delay Control Register1                         */

        struct
        {
            __IOM uint16_t DLLEN  : 1; /*!< [0..0] DLL Operation Enable                                               */
            __IOM uint16_t DLYRST : 1; /*!< [1..1] PWM Delay Generation Circuit Reset                                 */
            uint16_t              : 6;
            __IOM uint16_t FRANGE : 1; /*!< [8..8] GPT core clock Frequency Range                                     */
            uint16_t              : 7;
        } GTDLYCR1_b;
    };

    union
    {
        __IOM uint16_t GTDLYCR2;         /*!< (@ 0x00000002) PWM Output Delay Control Register2                         */

        struct
        {
            __IOM uint16_t DLYBS0   : 1; /*!< [0..0] PWM Delay Generation Circuit bypass                                */
            __IOM uint16_t DLYBS1   : 1; /*!< [1..1] PWM Delay Generation Circuit bypass                                */
            __IOM uint16_t DLYBS2   : 1; /*!< [2..2] PWM Delay Generation Circuit bypass                                */
            __IOM uint16_t DLYBS3   : 1; /*!< [3..3] PWM Delay Generation Circuit bypass                                */
            uint16_t                : 4;
            __IOM uint16_t DLYEN0   : 1; /*!< [8..8] PWM Delay Generation Circuit enable                                */
            __IOM uint16_t DLYEN1   : 1; /*!< [9..9] PWM Delay Generation Circuit enable                                */
            __IOM uint16_t DLYEN2   : 1; /*!< [10..10] PWM Delay Generation Circuit enable                              */
            __IOM uint16_t DLYEN3   : 1; /*!< [11..11] PWM Delay Generation Circuit enable                              */
            __IOM uint16_t DLYDENB0 : 1; /*!< [12..12] PWM Delay Generation Circuit Disenable for GTIOCB                */
            uint16_t                : 3;
        } GTDLYCR2_b;
    };
    __IM uint16_t               RESERVED[10];
    __IOM R_GPT_ODC_GTDLYR_Type GTDLYR[4]; /*!< (@ 0x00000018) PWM DELAY RISING                                           */
    __IOM R_GPT_ODC_GTDLYR_Type GTDLYF[4]; /*!< (@ 0x00000028) PWM DELAY FALLING                                          */
} R_GPT_ODC_Type;                          /*!< Size = 56 (0x38)                                                          */

/* =========================================================================================================================== */
/* ================                                         R_GPT_OPS                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Output Phase Switching for GPT (R_GPT_OPS)
 */

typedef struct                         /*!< (@ 0x40078FF0) R_GPT_OPS Structure                                        */
{
    union
    {
        __IOM uint32_t OPSCR;          /*!< (@ 0x00000000) Output Phase Switching Control Register                    */

        struct
        {
            __IOM uint32_t UF : 1;     /*!< [0..0] Input Phase Soft Setting WFThis bit sets the input phase
                                        *   by the software settings.This bit setting is valid when
                                        *   the OPSCR.FB bit = 1.                                                     */
            __IOM uint32_t VF : 1;     /*!< [1..1] Input Phase Soft Setting VFThis bit sets the input phase
                                        *   by the software settings.This bit setting is valid when
                                        *   the OPSCR.FB bit = 1.                                                     */
            __IOM uint32_t WF : 1;     /*!< [2..2] Input Phase Soft Setting UFThis bit sets the input phase
                                        *   by the software settings.This bit setting is valid when
                                        *   the OPSCR.FB bit = 1.                                                     */
            uint32_t        : 1;
            __IM uint32_t U : 1;       /*!< [4..4] Input U-Phase MonitorThis bit monitors the state of the
                                        *   input phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Softwa
                                        *   e settings (UF/VF/WF)                                                     */
            __IM uint32_t V : 1;       /*!< [5..5] Input V-Phase MonitorThis bit monitors the state of the
                                        *   input phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Softwa
                                        *   e settings (UF/VF/WF)                                                     */
            __IM uint32_t W : 1;       /*!< [6..6] Input W-Phase MonitorThis bit monitors the state of the
                                        *   input phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Softwa
                                        *   e settings (UF/VF/WF)                                                     */
            uint32_t          : 1;
            __IOM uint32_t EN : 1;     /*!< [8..8] Enable-Phase Output Control                                        */
            uint32_t          : 7;
            __IOM uint32_t FB : 1;     /*!< [16..16] External Feedback Signal EnableThis bit selects the
                                        *   input phase from the software settings and external input.                */
            __IOM uint32_t P     : 1;  /*!< [17..17] Positive-Phase Output (P) Control                                */
            __IOM uint32_t N     : 1;  /*!< [18..18] Negative-Phase Output (N) Control                                */
            __IOM uint32_t INV   : 1;  /*!< [19..19] Invert-Phase Output Control                                      */
            __IOM uint32_t RV    : 1;  /*!< [20..20] Output phase rotation direction reversal                         */
            __IOM uint32_t ALIGN : 1;  /*!< [21..21] Input phase alignment                                            */
            uint32_t             : 2;
            __IOM uint32_t GRP   : 2;  /*!< [25..24] Output disabled source selection                                 */
            __IOM uint32_t GODF  : 1;  /*!< [26..26] Group output disable function                                    */
            uint32_t             : 2;
            __IOM uint32_t NFEN  : 1;  /*!< [29..29] External Input Noise Filter Enable                               */
            __IOM uint32_t NFCS  : 2;  /*!< [31..30] External Input Noise Filter Clock selectionNoise filter
                                        *   sampling clock setting of the external input.                             */
        } OPSCR_b;
    };
} R_GPT_OPS_Type;                      /*!< Size = 4 (0x4)                                                            */

/* =========================================================================================================================== */
/* ================                                        R_GPT_POEG0                                        ================ */
/* =========================================================================================================================== */

/**
 * @brief Port Output Enable for GPT (R_GPT_POEG0)
 */

typedef struct                         /*!< (@ 0x40042000) R_GPT_POEG0 Structure                                      */
{
    union
    {
        __IOM uint32_t POEGG;          /*!< (@ 0x00000000) POEG Group Setting Register                                */

        struct
        {
            __IOM uint32_t PIDF  : 1;  /*!< [0..0] Port Input Detection Flag                                          */
            __IOM uint32_t IOCF  : 1;  /*!< [1..1] Real Time Overcurrent Detection Flag                               */
            __IOM uint32_t OSTPF : 1;  /*!< [2..2] Oscillation Stop Detection Flag                                    */
            __IOM uint32_t SSF   : 1;  /*!< [3..3] Software Stop Flag                                                 */
            __IOM uint32_t PIDE  : 1;  /*!< [4..4] Port Input Detection EnableNote: Can be modified only
                                        *   once after a reset.                                                       */
            __IOM uint32_t IOCE : 1;   /*!< [5..5] Enable for GPT Output-Disable RequestNote: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t OSTPE : 1;  /*!< [6..6] Oscillation Stop Detection EnableNote: Can be modified
                                        *   only once after a reset.                                                  */
            uint32_t             : 1;
            __IOM uint32_t CDRE0 : 1;  /*!< [8..8] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE1 : 1;  /*!< [9..9] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE2 : 1;  /*!< [10..10] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE3 : 1;  /*!< [11..11] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE4 : 1;  /*!< [12..12] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE5 : 1;  /*!< [13..13] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            uint32_t            : 2;
            __IM uint32_t ST    : 1;   /*!< [16..16] GTETRG Input Status Flag                                         */
            uint32_t            : 11;
            __IOM uint32_t INV  : 1;   /*!< [28..28] GTETRG Input Reverse                                             */
            __IOM uint32_t NFEN : 1;   /*!< [29..29] Noise Filter Enable                                              */
            __IOM uint32_t NFCS : 2;   /*!< [31..30] Noise Filter Clock Select                                        */
        } POEGG_b;
    };
} R_GPT_POEG0_Type;                    /*!< Size = 4 (0x4)                                                            */

/* =========================================================================================================================== */
/* ================                                           R_ICU                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Interrupt Controller Unit (R_ICU)
 */

typedef struct                         /*!< (@ 0x40006000) R_ICU Structure                                            */
{
    union
    {
        __IOM uint8_t IRQCR[16];       /*!< (@ 0x00000000) IRQ Control Register [0..15]                               */

        struct
        {
            __IOM uint8_t IRQMD   : 2; /*!< [1..0] IRQ Detection Sense Select                                         */
            uint8_t               : 2;
            __IOM uint8_t FCLKSEL : 2; /*!< [5..4] IRQ Digital Filter Sampling Clock Select                           */
            uint8_t               : 1;
            __IOM uint8_t FLTEN   : 1; /*!< [7..7] IRQ Digital Filter Enable                                          */
        } IRQCR_b[16];
    };
    __IM uint32_t RESERVED[60];

    union
    {
        __IOM uint8_t NMICR;            /*!< (@ 0x00000100) NMI Pin Interrupt Control Register                         */

        struct
        {
            __IOM uint8_t NMIMD    : 1; /*!< [0..0] NMI Detection Set                                                  */
            uint8_t                : 3;
            __IOM uint8_t NFCLKSEL : 2; /*!< [5..4] NMI Digital Filter Sampling Clock Select                           */
            uint8_t                : 1;
            __IOM uint8_t NFLTEN   : 1; /*!< [7..7] NMI Digital Filter Enable                                          */
        } NMICR_b;
    };
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2;
    __IM uint32_t RESERVED3[7];

    union
    {
        __IOM uint16_t NMIER;           /*!< (@ 0x00000120) Non-Maskable Interrupt Enable Register                     */

        struct
        {
            __IOM uint16_t IWDTEN  : 1; /*!< [0..0] IWDT Underflow/Refresh Error Interrupt Enable                      */
            __IOM uint16_t WDTEN   : 1; /*!< [1..1] WDT Underflow/Refresh Error Interrupt Enable                       */
            __IOM uint16_t LVD1EN  : 1; /*!< [2..2] Voltage-Monitoring 1 Interrupt Enable                              */
            __IOM uint16_t LVD2EN  : 1; /*!< [3..3] Voltage-Monitoring 2 Interrupt Enable                              */
            __IOM uint16_t VBATTEN : 1; /*!< [4..4] VBATT monitor Interrupt Enable                                     */
            uint16_t               : 1;
            __IOM uint16_t OSTEN   : 1; /*!< [6..6] Oscillation Stop Detection Interrupt Enable                        */
            __IOM uint16_t NMIEN   : 1; /*!< [7..7] NMI Pin Interrupt Enable                                           */
            __IOM uint16_t RPEEN   : 1; /*!< [8..8] RAM Parity Error Interrupt Enable                                  */
            __IOM uint16_t RECCEN  : 1; /*!< [9..9] RAM ECC Error Interrupt Enable                                     */
            __IOM uint16_t BUSSEN  : 1; /*!< [10..10] MPU Bus Slave Error Interrupt Enable                             */
            __IOM uint16_t BUSMEN  : 1; /*!< [11..11] MPU Bus Master Error Interrupt Enable                            */
            __IOM uint16_t SPEEN   : 1; /*!< [12..12] CPU Stack pointer monitor Interrupt Enable                       */
            __IOM uint16_t TZFEN   : 1; /*!< [13..13] TZFEN                                                            */
            uint16_t               : 1;
            __IOM uint16_t CPEEN   : 1; /*!< [15..15] CPEEN                                                            */
        } NMIER_b;
    };
    __IM uint16_t RESERVED4;
    __IM uint32_t RESERVED5[3];

    union
    {
        __IOM uint16_t NMICLR;          /*!< (@ 0x00000130) Non-Maskable Interrupt Status Clear Register               */

        struct
        {
            __OM uint16_t IWDTCLR  : 1; /*!< [0..0] IWDT Clear                                                         */
            __OM uint16_t WDTCLR   : 1; /*!< [1..1] WDT Clear                                                          */
            __OM uint16_t LVD1CLR  : 1; /*!< [2..2] LVD1 Clear                                                         */
            __OM uint16_t LVD2CLR  : 1; /*!< [3..3] LVD2 Clear                                                         */
            __OM uint16_t VBATTCLR : 1; /*!< [4..4] VBATT Clear                                                        */
            uint16_t               : 1;
            __OM uint16_t  OSTCLR  : 1; /*!< [6..6] OST Clear                                                          */
            __OM uint16_t  NMICLR  : 1; /*!< [7..7] NMI Clear                                                          */
            __OM uint16_t  RPECLR  : 1; /*!< [8..8] SRAM Parity Error Clear                                            */
            __OM uint16_t  RECCCLR : 1; /*!< [9..9] SRAM ECC Error Clear                                               */
            __OM uint16_t  BUSSCLR : 1; /*!< [10..10] Bus Slave Error Clear                                            */
            __OM uint16_t  BUSMCLR : 1; /*!< [11..11] Bus Master Error Clear                                           */
            __OM uint16_t  SPECLR  : 1; /*!< [12..12] CPU Stack Pointer Monitor Interrupt Clear                        */
            __IOM uint16_t TZFCLR  : 1; /*!< [13..13] TZFCLR                                                           */
            uint16_t               : 1;
            __IOM uint16_t CPECLR  : 1; /*!< [15..15] CPECLR                                                           */
        } NMICLR_b;
    };
    __IM uint16_t RESERVED6;
    __IM uint32_t RESERVED7[3];

    union
    {
        __IM uint16_t NMISR;           /*!< (@ 0x00000140) Non-Maskable Interrupt Status Register                     */

        struct
        {
            __IM uint16_t IWDTST  : 1; /*!< [0..0] IWDT Underflow/Refresh Error Status Flag                           */
            __IM uint16_t WDTST   : 1; /*!< [1..1] WDT Underflow/Refresh Error Status Flag                            */
            __IM uint16_t LVD1ST  : 1; /*!< [2..2] Voltage-Monitoring 1 Interrupt Status Flag                         */
            __IM uint16_t LVD2ST  : 1; /*!< [3..3] Voltage-Monitoring 2 Interrupt Status Flag                         */
            __IM uint16_t VBATTST : 1; /*!< [4..4] VBATT monitor Interrupt Status Flag                                */
            uint16_t              : 1;
            __IM uint16_t OSTST   : 1; /*!< [6..6] Oscillation Stop Detection Interrupt Status Flag                   */
            __IM uint16_t NMIST   : 1; /*!< [7..7] NMI Status Flag                                                    */
            __IM uint16_t RPEST   : 1; /*!< [8..8] RAM Parity Error Interrupt Status Flag                             */
            __IM uint16_t RECCST  : 1; /*!< [9..9] RAM ECC Error Interrupt Status Flag                                */
            __IM uint16_t BUSSST  : 1; /*!< [10..10] MPU Bus Slave Error Interrupt Status Flag                        */
            __IM uint16_t BUSMST  : 1; /*!< [11..11] MPU Bus Master Error Interrupt Status Flag                       */
            __IM uint16_t SPEST   : 1; /*!< [12..12] CPU Stack pointer monitor Interrupt Status Flag                  */
            __IM uint16_t TZFST   : 1; /*!< [13..13] TZFST                                                            */
            uint16_t              : 1;
            __IM uint16_t CPEST   : 1; /*!< [15..15] CPEST                                                            */
        } NMISR_b;
    };
    __IM uint16_t RESERVED8;
    __IM uint32_t RESERVED9[23];

    union
    {
        __IOM uint32_t WUPEN;                /*!< (@ 0x000001A0) Wake Up Interrupt Enable Register                          */

        struct
        {
            __IOM uint32_t IRQWUPEN0    : 1; /*!< [0..0] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN1    : 1; /*!< [1..1] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN2    : 1; /*!< [2..2] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN3    : 1; /*!< [3..3] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN4    : 1; /*!< [4..4] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN5    : 1; /*!< [5..5] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN6    : 1; /*!< [6..6] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN7    : 1; /*!< [7..7] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN8    : 1; /*!< [8..8] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN9    : 1; /*!< [9..9] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN10   : 1; /*!< [10..10] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN11   : 1; /*!< [11..11] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN12   : 1; /*!< [12..12] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN13   : 1; /*!< [13..13] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN14   : 1; /*!< [14..14] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN15   : 1; /*!< [15..15] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IWDTWUPEN    : 1; /*!< [16..16] IWDT interrupt S/W standby returns enable                        */
            __IOM uint32_t KEYWUPEN     : 1; /*!< [17..17] Key interrupt S/W standby returns enable                         */
            __IOM uint32_t LVD1WUPEN    : 1; /*!< [18..18] LVD1 interrupt S/W standby returns enable                        */
            __IOM uint32_t LVD2WUPEN    : 1; /*!< [19..19] LVD2 interrupt S/W standby returns enable                        */
            __IOM uint32_t VBATTWUPEN   : 1; /*!< [20..20] VBATT monitor interrupt S/W standby returns enable               */
            uint32_t                    : 1;
            __IOM uint32_t ACMPHS0WUPEN : 1; /*!< [22..22] ACMPHS0 interrupt S/W standby returns enable bit                 */
            __IOM uint32_t ACMPLP0WUPEN : 1; /*!< [23..23] ACMPLP0 interrupt S/W standby returns enable                     */
            __IOM uint32_t RTCALMWUPEN  : 1; /*!< [24..24] RTC alarm interrupt S/W standby returns enable                   */
            __IOM uint32_t RTCPRDWUPEN  : 1; /*!< [25..25] RCT period interrupt S/W standby returns enable                  */
            __IOM uint32_t USBHSWUPEN   : 1; /*!< [26..26] USBHS interrupt S/W standby returns enable bit                   */
            __IOM uint32_t USBFSWUPEN   : 1; /*!< [27..27] USBFS interrupt S/W standby returns enable                       */
            __IOM uint32_t AGT1UDWUPEN  : 1; /*!< [28..28] AGT1 underflow interrupt S/W standby returns enable              */
            __IOM uint32_t AGT1CAWUPEN  : 1; /*!< [29..29] AGT1 compare match A interrupt S/W standby returns
                                              *   enable                                                                    */
            __IOM uint32_t AGT1CBWUPEN : 1;  /*!< [30..30] AGT1 compare match B interrupt S/W standby returns
                                              *   enable                                                                    */
            __IOM uint32_t IIC0WUPEN : 1;    /*!< [31..31] IIC0 address match interrupt S/W standby returns enable          */
        } WUPEN_b;
    };

    union
    {
        __IOM uint32_t WUPEN1;              /*!< (@ 0x000001A4) Wake Up interrupt enable register 1                        */

        struct
        {
            __IOM uint32_t AGT3UDWUPEN : 1; /*!< [0..0] AGT3 underflow interrupt S/W standby returns enable bit            */
            __IOM uint32_t AGT3CAWUPEN : 1; /*!< [1..1] AGT3 compare match A interrupt S/W standby returns enable
                                             *   bit                                                                       */
            __IOM uint32_t AGT3CBWUPEN : 1; /*!< [2..2] AGT3 compare match B interrupt S/W standby returns enable
                                             *   bit                                                                       */
            uint32_t : 29;
        } WUPEN1_b;
    };
    __IM uint32_t RESERVED10[6];

    union
    {
        __IOM uint8_t IELEN;            /*!< (@ 0x000001C0) ICU event Enable Register                                  */

        struct
        {
            __IOM uint8_t RTCINTEN : 1; /*!< [0..0] RTCALM and RTCPRD Interrupts Enable (when LPOPTEN bit
                                         *   = 1)                                                                      */
            __IOM uint8_t IELEN : 1;    /*!< [1..1] Parts Asynchronous Interrupts Enable except RTC (when
                                         *   LPOPTEN bit = 1)                                                          */
            uint8_t : 6;
        } IELEN_b;
    };
    __IM uint8_t  RESERVED11;
    __IM uint16_t RESERVED12;
    __IM uint32_t RESERVED13[15];

    union
    {
        __IOM uint16_t SELSR0;         /*!< (@ 0x00000200) Snooze Event Link Setting Register                         */

        struct
        {
            __IOM uint16_t SELS : 9;   /*!< [8..0] SYS Event Link Select                                              */
            uint16_t            : 7;
        } SELSR0_b;
    };
    __IM uint16_t RESERVED14;
    __IM uint32_t RESERVED15[31];

    union
    {
        __IOM uint32_t DELSR[8];       /*!< (@ 0x00000280) DMAC Event Link Setting Register                           */

        struct
        {
            __IOM uint32_t DELS : 9;   /*!< [8..0] Event selection to DMAC Start request                              */
            uint32_t            : 7;
            __IOM uint32_t IR   : 1;   /*!< [16..16] Interrupt Status Flag for DMAC NOTE: Writing 1 to the
                                        *   IR flag is prohibited.                                                    */
            uint32_t : 15;
        } DELSR_b[8];
    };
    __IM uint32_t RESERVED16[24];

    union
    {
        __IOM uint32_t IELSR[96];      /*!< (@ 0x00000300) ICU Event Link Setting Register [0..95]                    */

        struct
        {
            __IOM uint32_t IELS : 9;   /*!< [8..0] ICU Event selection to NVICSet the number for the event
                                        *   signal to be linked .                                                     */
            uint32_t            : 7;
            __IOM uint32_t IR   : 1;   /*!< [16..16] Interrupt Status Flag                                            */
            uint32_t            : 7;
            __IOM uint32_t DTCE : 1;   /*!< [24..24] DTC Activation Enable                                            */
            uint32_t            : 7;
        } IELSR_b[96];
    };
} R_ICU_Type;                          /*!< Size = 1152 (0x480)                                                       */

/* =========================================================================================================================== */
/* ================                                          R_IIC0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief I2C Bus Interface (R_IIC0)
 */

typedef struct                         /*!< (@ 0x40053000) R_IIC0 Structure                                           */
{
    union
    {
        __IOM uint8_t ICCR1;           /*!< (@ 0x00000000) I2C Bus Control Register 1                                 */

        struct
        {
            __IM uint8_t  SDAI   : 1;  /*!< [0..0] SDA Line Monitor                                                   */
            __IM uint8_t  SCLI   : 1;  /*!< [1..1] SCL Line Monitor                                                   */
            __IOM uint8_t SDAO   : 1;  /*!< [2..2] SDA Output Control/Monitor                                         */
            __IOM uint8_t SCLO   : 1;  /*!< [3..3] SCL Output Control/Monitor                                         */
            __IOM uint8_t SOWP   : 1;  /*!< [4..4] SCLO/SDAO Write Protect                                            */
            __IOM uint8_t CLO    : 1;  /*!< [5..5] Extra SCL Clock Cycle Output                                       */
            __IOM uint8_t IICRST : 1;  /*!< [6..6] I2C Bus Interface Internal ResetNote:If an internal reset
                                        *   is initiated using the IICRST bit for a bus hang-up occurred
                                        *   during communication with the master device in slave mode,
                                        *   the states may become different between the slave device
                                        *   and the master device (due to the difference in the bit
                                        *   counter information).                                                     */
            __IOM uint8_t ICE : 1;     /*!< [7..7] I2C Bus Interface Enable                                           */
        } ICCR1_b;
    };

    union
    {
        __IOM uint8_t ICCR2;           /*!< (@ 0x00000001) I2C Bus Control Register 2                                 */

        struct
        {
            uint8_t          : 1;
            __IOM uint8_t ST : 1;      /*!< [1..1] Start Condition Issuance RequestSet the ST bit to 1 (start
                                        *   condition issuance request) when the BBSY flag is set to
                                        *   0 (bus free state).                                                       */
            __IOM uint8_t RS : 1;      /*!< [2..2] Restart Condition Issuance RequestNote: Do not set the
                                        *   RS bit to 1 while issuing a stop condition.                               */
            __IOM uint8_t SP : 1;      /*!< [3..3] Stop Condition Issuance RequestNote: Writing to the SP
                                        *   bit is not possible while the setting of the BBSY flag
                                        *   is 0 (bus free state).Note: Do not set the SP bit to 1
                                        *   while a restart condition is being issued.                                */
            uint8_t            : 1;
            __IOM uint8_t TRS  : 1;    /*!< [5..5] Transmit/Receive Mode                                              */
            __IOM uint8_t MST  : 1;    /*!< [6..6] Master/Slave Mode                                                  */
            __IM uint8_t  BBSY : 1;    /*!< [7..7] Bus Busy Detection Flag                                            */
        } ICCR2_b;
    };

    union
    {
        __IOM uint8_t ICMR1;           /*!< (@ 0x00000002) I2C Bus Mode Register 1                                    */

        struct
        {
            __IOM uint8_t BC   : 3;    /*!< [2..0] Bit Counter                                                        */
            __OM uint8_t  BCWP : 1;    /*!< [3..3] BC Write Protect(This bit is read as 1.)                           */
            __IOM uint8_t CKS  : 3;    /*!< [6..4] Internal Reference Clock (fIIC) Selection ( fIIC = PCLKB
                                        *   / 2^CKS )                                                                 */
            __IOM uint8_t MTWP : 1;    /*!< [7..7] MST/TRS Write Protect                                              */
        } ICMR1_b;
    };

    union
    {
        __IOM uint8_t ICMR2;           /*!< (@ 0x00000003) I2C Bus Mode Register 2                                    */

        struct
        {
            __IOM uint8_t TMOS : 1;    /*!< [0..0] Timeout Detection Time Select                                      */
            __IOM uint8_t TMOL : 1;    /*!< [1..1] Timeout L Count Control                                            */
            __IOM uint8_t TMOH : 1;    /*!< [2..2] Timeout H Count Control                                            */
            uint8_t            : 1;
            __IOM uint8_t SDDL : 3;    /*!< [6..4] SDA Output Delay Counter                                           */
            __IOM uint8_t DLCS : 1;    /*!< [7..7] SDA Output Delay Clock Source Select                               */
        } ICMR2_b;
    };

    union
    {
        __IOM uint8_t ICMR3;           /*!< (@ 0x00000004) I2C Bus Mode Register 3                                    */

        struct
        {
            __IOM uint8_t NF    : 2;   /*!< [1..0] Noise Filter Stage Selection                                       */
            __IM uint8_t  ACKBR : 1;   /*!< [2..2] Receive Acknowledge                                                */
            __IOM uint8_t ACKBT : 1;   /*!< [3..3] Transmit Acknowledge                                               */
            __IOM uint8_t ACKWP : 1;   /*!< [4..4] ACKBT Write Protect                                                */
            __IOM uint8_t RDRFS : 1;   /*!< [5..5] RDRF Flag Set Timing Selection                                     */
            __IOM uint8_t WAIT  : 1;   /*!< [6..6] WAITNote: When the value of the WAIT bit is to be read,
                                        *   be sure to read the ICDRR beforehand.                                     */
            __IOM uint8_t SMBS : 1;    /*!< [7..7] SMBus/I2C Bus Selection                                            */
        } ICMR3_b;
    };

    union
    {
        __IOM uint8_t ICFER;           /*!< (@ 0x00000005) I2C Bus Function Enable Register                           */

        struct
        {
            __IOM uint8_t TMOE  : 1;   /*!< [0..0] Timeout Function Enable                                            */
            __IOM uint8_t MALE  : 1;   /*!< [1..1] Master Arbitration-Lost Detection Enable                           */
            __IOM uint8_t NALE  : 1;   /*!< [2..2] NACK Transmission Arbitration-Lost Detection Enable                */
            __IOM uint8_t SALE  : 1;   /*!< [3..3] Slave Arbitration-Lost Detection Enable                            */
            __IOM uint8_t NACKE : 1;   /*!< [4..4] NACK Reception Transfer Suspension Enable                          */
            __IOM uint8_t NFE   : 1;   /*!< [5..5] Digital Noise Filter Circuit Enable                                */
            __IOM uint8_t SCLE  : 1;   /*!< [6..6] SCL Synchronous Circuit Enable                                     */
            __IOM uint8_t FMPE  : 1;   /*!< [7..7] Fast-mode Plus Enable                                              */
        } ICFER_b;
    };

    union
    {
        __IOM uint8_t ICSER;           /*!< (@ 0x00000006) I2C Bus Status Enable Register                             */

        struct
        {
            __IOM uint8_t SAR0E : 1;   /*!< [0..0] Slave Address Register 0 Enable                                    */
            __IOM uint8_t SAR1E : 1;   /*!< [1..1] Slave Address Register 1 Enable                                    */
            __IOM uint8_t SAR2E : 1;   /*!< [2..2] Slave Address Register 2 Enable                                    */
            __IOM uint8_t GCAE  : 1;   /*!< [3..3] General Call Address Enable                                        */
            uint8_t             : 1;
            __IOM uint8_t DIDE  : 1;   /*!< [5..5] Device-ID Address Detection Enable                                 */
            uint8_t             : 1;
            __IOM uint8_t HOAE  : 1;   /*!< [7..7] Host Address Enable                                                */
        } ICSER_b;
    };

    union
    {
        __IOM uint8_t ICIER;           /*!< (@ 0x00000007) I2C Bus Interrupt Enable Register                          */

        struct
        {
            __IOM uint8_t TMOIE : 1;   /*!< [0..0] Timeout Interrupt Request Enable                                   */
            __IOM uint8_t ALIE  : 1;   /*!< [1..1] Arbitration-Lost Interrupt Request Enable                          */
            __IOM uint8_t STIE  : 1;   /*!< [2..2] Start Condition Detection Interrupt Request Enable                 */
            __IOM uint8_t SPIE  : 1;   /*!< [3..3] Stop Condition Detection Interrupt Request Enable                  */
            __IOM uint8_t NAKIE : 1;   /*!< [4..4] NACK Reception Interrupt Request Enable                            */
            __IOM uint8_t RIE   : 1;   /*!< [5..5] Receive Data Full Interrupt Request Enable                         */
            __IOM uint8_t TEIE  : 1;   /*!< [6..6] Transmit End Interrupt Request Enable                              */
            __IOM uint8_t TIE   : 1;   /*!< [7..7] Transmit Data Empty Interrupt Request Enable                       */
        } ICIER_b;
    };

    union
    {
        __IOM uint8_t ICSR1;           /*!< (@ 0x00000008) I2C Bus Status Register 1                                  */

        struct
        {
            __IOM uint8_t AAS0 : 1;    /*!< [0..0] Slave Address 0 Detection Flag                                     */
            __IOM uint8_t AAS1 : 1;    /*!< [1..1] Slave Address 1 Detection Flag                                     */
            __IOM uint8_t AAS2 : 1;    /*!< [2..2] Slave Address 2 Detection Flag                                     */
            __IOM uint8_t GCA  : 1;    /*!< [3..3] General Call Address Detection Flag                                */
            uint8_t            : 1;
            __IOM uint8_t DID  : 1;    /*!< [5..5] Device-ID Address Detection Flag                                   */
            uint8_t            : 1;
            __IOM uint8_t HOA  : 1;    /*!< [7..7] Host Address Detection Flag                                        */
        } ICSR1_b;
    };

    union
    {
        __IOM uint8_t ICSR2;           /*!< (@ 0x00000009) I2C Bus Status Register 2                                  */

        struct
        {
            __IOM uint8_t TMOF  : 1;   /*!< [0..0] Timeout Detection Flag                                             */
            __IOM uint8_t AL    : 1;   /*!< [1..1] Arbitration-Lost Flag                                              */
            __IOM uint8_t START : 1;   /*!< [2..2] Start Condition Detection Flag                                     */
            __IOM uint8_t STOP  : 1;   /*!< [3..3] Stop Condition Detection Flag                                      */
            __IOM uint8_t NACKF : 1;   /*!< [4..4] NACK Detection Flag                                                */
            __IOM uint8_t RDRF  : 1;   /*!< [5..5] Receive Data Full Flag                                             */
            __IOM uint8_t TEND  : 1;   /*!< [6..6] Transmit End Flag                                                  */
            __IM uint8_t  TDRE  : 1;   /*!< [7..7] Transmit Data Empty Flag                                           */
        } ICSR2_b;
    };
    __IOM R_IIC0_SAR_Type SAR[3];      /*!< (@ 0x0000000A) Slave Address Registers                                    */

    union
    {
        __IOM uint8_t ICBRL;           /*!< (@ 0x00000010) I2C Bus Bit Rate Low-Level Register                        */

        struct
        {
            __IOM uint8_t BRL : 5;     /*!< [4..0] Bit Rate Low-Level Period(Low-level period of SCL clock)           */
            uint8_t           : 3;
        } ICBRL_b;
    };

    union
    {
        __IOM uint8_t ICBRH;           /*!< (@ 0x00000011) I2C Bus Bit Rate High-Level Register                       */

        struct
        {
            __IOM uint8_t BRH : 5;     /*!< [4..0] Bit Rate High-Level Period(High-level period of SCL clock)         */
            uint8_t           : 3;
        } ICBRH_b;
    };

    union
    {
        __IOM uint8_t ICDRT;           /*!< (@ 0x00000012) I2C Bus Transmit Data Register                             */

        struct
        {
            __IOM uint8_t ICDRT : 8;   /*!< [7..0] 8-bit read-write register that stores transmit data.               */
        } ICDRT_b;
    };

    union
    {
        __IM uint8_t ICDRR;            /*!< (@ 0x00000013) I2C Bus Receive Data Register                              */

        struct
        {
            __IM uint8_t ICDRR : 8;    /*!< [7..0] 8-bit register that stores the received data                       */
        } ICDRR_b;
    };
    __IM uint8_t RESERVED[2];

    union
    {
        __IOM uint8_t ICWUR;           /*!< (@ 0x00000016) I2C Bus Wake Up Unit Register                              */

        struct
        {
            __IOM uint8_t WUAFA : 1;   /*!< [0..0] Wakeup Analog Filter Additional Selection                          */
            uint8_t             : 3;
            __IOM uint8_t WUACK : 1;   /*!< [4..4] ACK bit for Wakeup Mode                                            */
            __IOM uint8_t WUF   : 1;   /*!< [5..5] Wakeup Event Occurrence Flag                                       */
            __IOM uint8_t WUIE  : 1;   /*!< [6..6] Wakeup Interrupt Request Enable                                    */
            __IOM uint8_t WUE   : 1;   /*!< [7..7] Wakeup Function Enable                                             */
        } ICWUR_b;
    };

    union
    {
        __IOM uint8_t ICWUR2;          /*!< (@ 0x00000017) I2C Bus Wake up Unit Register 2                            */

        struct
        {
            __IM uint8_t WUSEN  : 1;   /*!< [0..0] Wake-up Function Synchronous Enable                                */
            __IM uint8_t WUASYF : 1;   /*!< [1..1] Wake-up Function Asynchronous Operation Status Flag                */
            __IM uint8_t WUSYF  : 1;   /*!< [2..2] Wake-up Function Synchronous Operation Status Flag                 */
            uint8_t             : 5;
        } ICWUR2_b;
    };
} R_IIC0_Type;                         /*!< Size = 24 (0x18)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_IIRFA                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief IIR Filter Accelerator (R_IIRFA)
 */

typedef struct                         /*!< (@ 0x40020000) R_IIRFA Structure                                          */
{
    union
    {
        __IM uint32_t IIRCPRCS;        /*!< (@ 0x00000000) Channel Processing Status Register                         */

        struct
        {
            __IM uint32_t CPRCS : 16;  /*!< [15..0] Channel processing status bit                                     */
            uint32_t            : 16;
        } IIRCPRCS_b;
    };

    union
    {
        __IM uint32_t IIRCPRCFF;       /*!< (@ 0x00000004) Channel Processing Completion Flag Register                */

        struct
        {
            __IM uint32_t CPRCFF : 16; /*!< [15..0] Channel processing completion flag                                */
            uint32_t             : 16;
        } IIRCPRCFF_b;
    };

    union
    {
        __IM uint32_t IIRORDYF;        /*!< (@ 0x00000008) Output Data Preparation Completion Flag Register           */

        struct
        {
            __IM uint32_t ORDYF : 16;  /*!< [15..0] Output data preparation completion flag                           */
            uint32_t            : 16;
        } IIRORDYF_b;
    };

    union
    {
        __IM uint32_t IIRCERRF;        /*!< (@ 0x0000000C) Operation Error Flag Register                              */

        struct
        {
            __IM uint32_t CERRF : 16;  /*!< [15..0] Operation error flag                                              */
            uint32_t            : 16;
        } IIRCERRF_b;
    };

    union
    {
        __IOM uint32_t IIROPCNT;       /*!< (@ 0x00000010) Operation Control Register                                 */

        struct
        {
            __IOM uint32_t RND : 3;    /*!< [2..0] Setting for the rounding mode for addition and multiplication      */
            uint32_t           : 29;
        } IIROPCNT_b;
    };
    __IM uint32_t RESERVED[3];

    union
    {
        __IOM uint32_t IIRECCCNT;        /*!< (@ 0x00000020) ECC Control Register                                       */

        struct
        {
            __IOM uint32_t ECCMD    : 1; /*!< [0..0] ECC setting bit                                                    */
            __IOM uint32_t ECCWBDIS : 1; /*!< [1..1] ECC-corrected data write-back disable bit                          */
            uint32_t                : 30;
        } IIRECCCNT_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __IOM uint32_t IIRECCINT;      /*!< (@ 0x00000028) ECC Interrupt Enable Register                              */

        struct
        {
            __IOM uint32_t ESEIE : 1;  /*!< [0..0] ECC 1-bit error interrupt enable bit                               */
            __IOM uint32_t EDEIE : 1;  /*!< [1..1] ECC 2-bit error interrupt enable bit                               */
            uint32_t             : 30;
        } IIRECCINT_b;
    };
    __IM uint32_t RESERVED2;

    union
    {
        __IM uint32_t IIRECCEF;        /*!< (@ 0x00000030) ECC Error Flag Register                                    */

        struct
        {
            __IM uint32_t ESEF : 1;    /*!< [0..0] ECC 1-bit error flag                                               */
            __IM uint32_t EDEF : 1;    /*!< [1..1] ECC 2-bit error flag                                               */
            uint32_t           : 30;
        } IIRECCEF_b;
    };

    union
    {
        __OM uint32_t IIRECCEFCLR;     /*!< (@ 0x00000034) ECC Error Flag Clear Register                              */

        struct
        {
            __OM uint32_t ESEFCLR : 1; /*!< [0..0] ECC 1-bit error flag clear bit                                     */
            __OM uint32_t EDEFCLR : 1; /*!< [1..1] ECC 2-bit error status flag clear bit                              */
            uint32_t              : 30;
        } IIRECCEFCLR_b;
    };

    union
    {
        __IM uint32_t IIRESEADR;       /*!< (@ 0x00000038) ECC 1-bit Error Address Register                           */

        struct
        {
            __IM uint32_t SEADR : 11;  /*!< [10..0] Error address                                                     */
            uint32_t            : 21;
        } IIRESEADR_b;
    };

    union
    {
        __IM uint32_t IIREDEADR;       /*!< (@ 0x0000003C) ECC 2-bit Error Address Register                           */

        struct
        {
            __IM uint32_t DEADR : 11;  /*!< [10..0] Error address                                                     */
            uint32_t            : 21;
        } IIREDEADR_b;
    };
    __IM uint32_t             RESERVED3[48];
    __IOM R_IIRFA_IIRCH_Type  IIRCH[16];  /*!< (@ 0x00000100) Channel Registers                                          */
    __IM uint32_t             RESERVED4[128];
    __IOM R_IIRFA_IIRSTG_Type IIRSTG[32]; /*!< (@ 0x00000400) Stage Registers                                            */
} R_IIRFA_Type;                           /*!< Size = 2048 (0x800)                                                       */

/* =========================================================================================================================== */
/* ================                                          R_IRDA                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief IrDA Interface (R_IRDA)
 */

typedef struct                         /*!< (@ 0x40070F00) R_IRDA Structure                                           */
{
    union
    {
        __IOM uint8_t IRCR;            /*!< (@ 0x00000000) IrDA Control Register                                      */

        struct
        {
            uint8_t               : 2;
            __IOM uint8_t IRRXINV : 1; /*!< [2..2] IRRXD Polarity Switching                                           */
            __IOM uint8_t IRTXINV : 1; /*!< [3..3] IRTXD Polarity Switching                                           */
            uint8_t               : 3;
            __IOM uint8_t IRE     : 1; /*!< [7..7] IrDA Enable                                                        */
        } IRCR_b;
    };
} R_IRDA_Type;                         /*!< Size = 1 (0x1)                                                            */

/* =========================================================================================================================== */
/* ================                                          R_IWDT                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Independent Watchdog Timer (R_IWDT)
 */

typedef struct                         /*!< (@ 0x40044400) R_IWDT Structure                                           */
{
    union
    {
        __IOM uint8_t IWDTRR;          /*!< (@ 0x00000000) IWDT Refresh Register                                      */

        struct
        {
            __IOM uint8_t IWDTRR : 8;  /*!< [7..0] The counter is refreshed by writing 0x00 and then writing
                                        *   0xFF to this register.                                                    */
        } IWDTRR_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;

    union
    {
        __IOM uint16_t IWDTSR;          /*!< (@ 0x00000004) IWDT Status Register                                       */

        struct
        {
            __IM uint16_t  CNTVAL : 14; /*!< [13..0] Counter ValueValue counted by the counter                         */
            __IOM uint16_t UNDFF  : 1;  /*!< [14..14] Underflow Flag                                                   */
            __IOM uint16_t REFEF  : 1;  /*!< [15..15] Refresh Error Flag                                               */
        } IWDTSR_b;
    };
} R_IWDT_Type;                          /*!< Size = 6 (0x6)                                                            */

/* =========================================================================================================================== */
/* ================                                          R_JPEG                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief JPEG Codec (R_JPEG)
 */

typedef struct                         /*!< (@ 0x400E6000) R_JPEG Structure                                           */
{
    union
    {
        __IOM uint8_t JCMOD;           /*!< (@ 0x00000000) JPEG Code Mode Register                                    */

        struct
        {
            __IOM uint8_t REDU : 3;    /*!< [2..0] Pixel FormatNOTE: Read-only in Decompression.                      */
            __IOM uint8_t DSP  : 1;    /*!< [3..3] Compression/Decompression Set Note: When changing between
                                        *   processing for compression and for decompression, be sure
                                        *   to reset this module in advance by setting the JCUSRST
                                        *   bit in the software reset control register 2 (SWRSTCR2)
                                        *   of the power-downmodes.                                                   */
            uint8_t : 4;
        } JCMOD_b;
    };

    union
    {
        __OM uint8_t JCCMD;            /*!< (@ 0x00000001) JPEG Code Command Register                                 */

        struct
        {
            __OM uint8_t JSRT : 1;     /*!< [0..0] JPEG Core Process Start CommandTo start JPEG core processing,
                                        *   set this bit to 1. Do not write this bit to 1 again while
                                        *   this module is in operation.                                              */
            __OM uint8_t JRST : 1;     /*!< [1..1] JPEG Core Process Stop Clear CommandTo clear the process-stopped
                                        *   state caused by requests to read the image size and pixel
                                        *   format (enabled by the INT3 bit in JINTE0), set this bit
                                        *   to 1.                                                                     */
            __OM uint8_t JEND : 1;     /*!< [2..2] Interrupt Request Clear Command This bit is valid only
                                        *   for the interrupt sources corresponding to bits INS6, INS5,
                                        *   and INS3 in JINTS0. To clear an interrupt request, set
                                        *   this bit to 1                                                             */
            uint8_t           : 4;
            __OM uint8_t BRST : 1;     /*!< [7..7] Bus Reset. NOTE: When this module is in operation, the
                                        *   bus reset command should not be issued.                                   */
        } JCCMD_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint8_t JCQTN;           /*!< (@ 0x00000003) JPEG Code Quantization Table Number Register               */

        struct
        {
            __IOM uint8_t QT1 : 2;     /*!< [1..0] Quantization table number for the first color componentNOTE:
                                        *   Read-only in Decompression.                                               */
            __IOM uint8_t QT2 : 2;     /*!< [3..2] Quantization table number for the second color component
                                        *   NOTE: Read-only in Decompression.                                         */
            __IOM uint8_t QT3 : 2;     /*!< [5..4] Quantization table number for the third color component
                                        *   NOTE: Read-only in Decompression.                                         */
            uint8_t : 2;
        } JCQTN_b;
    };

    union
    {
        __IOM uint8_t JCHTN;           /*!< (@ 0x00000004) JPEG Code Huffman Table Number Register                    */

        struct
        {
            __IOM uint8_t HTD1 : 1;    /*!< [0..0] Huffman table number (DC) for the first color component
                                        *   NOTE: Read-only in Decompression.                                         */
            __IOM uint8_t HTA1 : 1;    /*!< [1..1] Huffman table number (AC) for the first color componentNOTE:
                                        *   Read-only in Decompression.                                               */
            __IOM uint8_t HTD2 : 1;    /*!< [2..2] Huffman table number (DC) for the second color component
                                        *   NOTE: Read-only in Decompression.                                         */
            __IOM uint8_t HTA2 : 1;    /*!< [3..3] Huffman table number (AC) for the second color componentNOTE:
                                        *   Read-only in Decompression.                                               */
            __IOM uint8_t HTD3 : 1;    /*!< [4..4] Huffman table number (DC) for the third color component
                                        *   NOTE: Read-only in Decompression.                                         */
            __IOM uint8_t HTA3 : 1;    /*!< [5..5] Huffman table number (AC) for the third color componentNOTE:
                                        *   Read-only in Decompression.                                               */
            uint8_t : 2;
        } JCHTN_b;
    };

    union
    {
        __IOM uint8_t JCDRIU;          /*!< (@ 0x00000005) JPEG Code DRI Upper Register                               */

        struct
        {
            __IOM uint8_t DRIU : 8;    /*!< [7..0] Upper Bytes of MCUs Preceding RST MarkerWhen both upper
                                        *   and lower bytes are set to 00h, neither a DRI nor an RST
                                        *   marker is placed.NOTE: Read-only in Decompression.                        */
        } JCDRIU_b;
    };

    union
    {
        __IOM uint8_t JCDRID;          /*!< (@ 0x00000006) JPEG Code DRI Lower Register                               */

        struct
        {
            __IOM uint8_t DRID : 8;    /*!< [7..0] Lower Bytes of MCUs Preceding RST MarkerWhen both upper
                                        *   and lower bytes are set to 00h, neither a DRI nor an RST
                                        *   marker is placed.NOTE: Read-only in Decompression.                        */
        } JCDRID_b;
    };

    union
    {
        __IOM uint8_t JCVSZU;          /*!< (@ 0x00000007) JPEG Code Vertical Size Upper Register                     */

        struct
        {
            __IOM uint8_t VSZU : 8;    /*!< [7..0] Upper Bytes of Vertical Image SizeIn decompression process,
                                        *   a downloaded value from the JPEG coded data is set. NOTE:
                                        *   Read-only in Decompression.                                               */
        } JCVSZU_b;
    };

    union
    {
        __IOM uint8_t JCVSZD;          /*!< (@ 0x00000008) JPEG Code Vertical Size Lower Register                     */

        struct
        {
            __IOM uint8_t VSZD : 8;    /*!< [7..0] Lower Bytes of Vertical Image SizeIn decompression process,
                                        *   a downloaded value from the JPEG coded data is set. NOTE:
                                        *   Read-only in Decompression.                                               */
        } JCVSZD_b;
    };

    union
    {
        __IOM uint8_t JCHSZU;          /*!< (@ 0x00000009) JPEG Code Horizontal Size Upper Register                   */

        struct
        {
            __IOM uint8_t HSZU : 8;    /*!< [7..0] Upper Bytes of Horizontal Image SizeIn decompression
                                        *   process, a downloaded value from the JPEG coded data is
                                        *   set. NOTE: Read-only in Decompression.                                    */
        } JCHSZU_b;
    };

    union
    {
        __IOM uint8_t JCHSZD;          /*!< (@ 0x0000000A) JPEG Coded Horizontal Size Lower Register                  */

        struct
        {
            __IOM uint8_t HSZD : 8;    /*!< [7..0] Lower Bytes of Horizontal Image SizeIn decompression
                                        *   process, a downloaded value from the JPEG coded data is
                                        *   set. NOTE: Read-only in Decompression.                                    */
        } JCHSZD_b;
    };

    union
    {
        __IM uint8_t JCDTCU;           /*!< (@ 0x0000000B) JPEG Code Data Count Upper Register                        */

        struct
        {
            __IM uint8_t DCU : 8;      /*!< [7..0] Upper bytes of the counted amount of data to be compressed
                                        *   The values of this register are reset before compression
                                        *   starts.NOTE: Read-only in Decompression.                                  */
        } JCDTCU_b;
    };

    union
    {
        __IM uint8_t JCDTCM;           /*!< (@ 0x0000000C) JPEG Code Data Count Middle Register                       */

        struct
        {
            __IM uint8_t DCM : 8;      /*!< [7..0] Middle bytes of the counted amount of data to be compressedThe
                                        *   values of this register are reset before compression starts.
                                        *   NOTE: Read-only in Decompression.                                         */
        } JCDTCM_b;
    };

    union
    {
        __IM uint8_t JCDTCD;           /*!< (@ 0x0000000D) JPEG Code Data Count Lower Register                        */

        struct
        {
            __IM uint8_t DCD : 8;      /*!< [7..0] Lower bytes of the counted amount of data to be compressedThe
                                        *   values of this register are reset before compression starts.NOTE:
                                        *   Read-only in Decompression.                                               */
        } JCDTCD_b;
    };

    union
    {
        __IOM uint8_t JINTE0;          /*!< (@ 0x0000000E) JPEG Interrupt Enable Register 0                           */

        struct
        {
            uint8_t            : 3;
            __IOM uint8_t INT3 : 1;    /*!< [3..3] This bit enables an interrupt to be generated when it
                                        *   has been determined that the image size and the subsampling
                                        *   setting of the compressed data can be read through analyzing
                                        *   the data.                                                                 */
            uint8_t            : 1;
            __IOM uint8_t INT5 : 1;    /*!< [5..5] This bit enables an interrupt to be generated when the
                                        *   final number of MCU data in the Huffman-coding segment
                                        *   is not correct in decompression. When this bit is not set
                                        *   to enable interrupt generation, an error code is not returned.            */
            __IOM uint8_t INT6 : 1;    /*!< [6..6] This bit enables an interrupt to be generated when the
                                        *   total number of data in the Huffman-coding segment is not
                                        *   correct in decompression. When this bit is not set to enable
                                        *   interrupt generation, an error code is not returned.                      */
            __IOM uint8_t INT7 : 1;    /*!< [7..7] This bit enables an interrupt to be generated when the
                                        *   number of data in the restart interval of the Huffman-coding
                                        *   segment is not correct in decompression.When this bit is
                                        *   not set to enable interrupt generation, an error code is
                                        *   not returned.                                                             */
        } JINTE0_b;
    };

    union
    {
        __IOM uint8_t JINTS0;          /*!< (@ 0x0000000F) JPEG Interrupt Status Register 0                           */

        struct
        {
            uint8_t            : 3;
            __IOM uint8_t INS3 : 1;    /*!< [3..3] This bit is set to 1 when the image size and pixel format
                                        *   can be read. When an interrupt occurs, this module stops
                                        *   processing and the state is indicated by the JCRST register.
                                        *   To make this module resume processing, set the JPEG core
                                        *   process stop clear command bit (JRST) in JCCMD.                           */
            uint8_t            : 1;
            __IOM uint8_t INS5 : 1;    /*!< [5..5] This bit is set to 1 when a compressed data error occurs.          */
            __IOM uint8_t INS6 : 1;    /*!< [6..6] This bit is set to 1 when this module completes compression
                                        *   process normally.                                                         */
            uint8_t : 1;
        } JINTS0_b;
    };

    union
    {
        __IOM uint8_t JCDERR;          /*!< (@ 0x00000010) JPEG Code Decode Error Register                            */

        struct
        {
            __IOM uint8_t ERR : 4;     /*!< [3..0] Error Code (See tables )Identify the type of the error
                                        *   which has occurred in the compressed data analysis for
                                        *   decompression.                                                            */
            uint8_t : 4;
        } JCDERR_b;
    };

    union
    {
        __IM uint8_t JCRST;            /*!< (@ 0x00000011) JPEG Code Reset Register                                   */

        struct
        {
            __IM uint8_t RST : 1;      /*!< [0..0] Operating State                                                    */
            uint8_t          : 7;
        } JCRST_b;
    };
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[11];

    union
    {
        __IOM uint32_t JIFECNT;          /*!< (@ 0x00000040) JPEG Interface Compression Control Register                */

        struct
        {
            __IOM uint32_t DINSWAP : 3;  /*!< [2..0] Byte/Halfword Swap                                                 */
            uint32_t               : 1;
            __IOM uint32_t DINLC   : 1;  /*!< [4..4] Count Mode Setting for Stopping Input Image Data Lines             */
            __OM uint32_t  DINRCMD : 1;  /*!< [5..5] Input Image Data Lines Resume Command This bit is valid
                                          *   only when the count mode for stopping the input of image
                                          *   data lines is on. Setting this bit to 1 resumes reading
                                          *   input image data. This bit is always read as 0.                           */
            __IOM uint32_t DINRINI : 1;  /*!< [6..6] Address Initialization when Resuming Input of Image Data
                                          *   Lines This bit is only valid when the count mode for stopping
                                          *   the input of image data lines is on. Set this bit before
                                          *   writing 1 to the data-line resume command bit.                            */
            uint32_t                : 1;
            __IOM uint32_t JOUTSWAP : 3; /*!< [10..8] Byte/Halfword/Word Swap Output coded data in compression
                                          *   is swapped.                                                               */
            uint32_t : 21;
        } JIFECNT_b;
    };

    union
    {
        __IOM uint32_t JIFESA;         /*!< (@ 0x00000044) JPEG Interface Compression Source Address Register         */

        struct
        {
            __IOM uint32_t ESA : 32;   /*!< [31..0] Input Image Data Source Address (in 8-byte units) The
                                        *   lower three bits should be set to 0.                                      */
        } JIFESA_b;
    };

    union
    {
        __IOM uint32_t JIFESOFST;      /*!< (@ 0x00000048) JPEG Interface Compression Line Offset Register            */

        struct
        {
            __IOM uint32_t ESMW : 15;  /*!< [14..0] Input Image Data Lines Offset(in 8-byte units)The lower
                                        *   three bits should be set to 0.                                            */
            uint32_t : 17;
        } JIFESOFST_b;
    };

    union
    {
        __IOM uint32_t JIFEDA;         /*!< (@ 0x0000004C) JPEG Interface Compression Destination Address
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t EDA : 32;   /*!< [31..0] Input Image Data Lines Offset (in 8-byte units) The
                                        *   lower three bits should be set to 0.                                      */
        } JIFEDA_b;
    };

    union
    {
        __IOM uint32_t JIFESLC;        /*!< (@ 0x00000050) JPEG Interface Compression Source Line Count
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t LINES : 16; /*!< [15..0] Number of Input Image Data Lines to be Read (in 8-line
                                        *   units) The lower three bits should be set to 0.                           */
            uint32_t : 16;
        } JIFESLC_b;
    };
    __IM uint32_t RESERVED3;

    union
    {
        __IOM uint32_t JIFDCNT;          /*!< (@ 0x00000058) JPEG Interface Decompression Control Register              */

        struct
        {
            __IOM uint32_t DOUTSWAP : 3; /*!< [2..0] Byte/Word Swap Output image data in decompression is
                                          *   swapped.                                                                  */
            uint32_t                : 1;
            __IOM uint32_t DOUTLC   : 1; /*!< [4..4] Count Mode for Stopping Output Image Data Lines                    */
            __OM uint32_t  DOUTRCMD : 1; /*!< [5..5] Output Image Data Lines Resume Command This bit is valid
                                          *   only when the count mode for stopping the output of image
                                          *   data lines is on. Setting this bit to 1 resumes writing
                                          *   image data. This bit is always read as 0.                                 */
            __IOM uint32_t DOUTRINI : 1; /*!< [6..6] Address Initialization when Resuming Output of Image
                                          *   Data Lines This bit is only valid when the count mode for
                                          *   stopping the output of image data lines is on. Set this
                                          *   bit before writing 1 to the data-line resume command bit.                 */
            uint32_t               : 1;
            __IOM uint32_t JINSWAP : 3;  /*!< [10..8] Byte/Word/Longword Swap Input coded data in decompression
                                          *   is swapped.                                                               */
            uint32_t               : 1;
            __IOM uint32_t JINC    : 1;  /*!< [12..12] Count Mode Setting for Stopping Input Coded Data                 */
            __OM uint32_t  JINRCMD : 1;  /*!< [13..13] Input Coded Data Resume CommandThis bit is valid only
                                          *   when the count mode for stopping the input of coded data
                                          *   is on. Setting this bit to 1 resumes reading input coded
                                          *   data. This bit is always read as 0.                                       */
            __IOM uint32_t JINRINI : 1;  /*!< [14..14] Address Initialization when Input Coded Data is Resumed
                                          *   This bit is only valid when the count mode for stopping
                                          *   the input of coded data is on. Set this bit before writing
                                          *   1 to the data resume command bit.                                         */
            uint32_t              : 9;
            __IOM uint32_t OPF    : 2;   /*!< [25..24] Specifies output image data pixel format.                        */
            __IOM uint32_t HINTER : 2;   /*!< [27..26] Horizontal Subsampling Subsamples horizontal output
                                          *   image data.                                                               */
            __IOM uint32_t VINTER : 2;   /*!< [29..28] Vertical SubsamplingSubsamples vertical output image
                                          *   data.                                                                     */
            uint32_t : 2;
        } JIFDCNT_b;
    };

    union
    {
        __IOM uint32_t JIFDSA;         /*!< (@ 0x0000005C) JPEG Interface Decompression Source Address Register       */

        struct
        {
            __IOM uint32_t DSA : 32;   /*!< [31..0] Input Coded Data Source AddressInput Coded Data Source
                                        *   Address (in 8-byte units) The lower three bits should be
                                        *   set to 0.                                                                 */
        } JIFDSA_b;
    };

    union
    {
        __IOM uint32_t JIFDDOFST;      /*!< (@ 0x00000060) JPEG Interface Decompression Line Offset Register          */

        struct
        {
            __IOM uint32_t DDMW : 15;  /*!< [14..0] Output Image Data Lines Offset (in 8-byte units) The
                                        *   lower three bits should be set to 0.                                      */
            uint32_t : 17;
        } JIFDDOFST_b;
    };

    union
    {
        __IOM uint32_t JIFDDA;         /*!< (@ 0x00000064) JPEG Interface Decompression Destination Address
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t DDA : 32;   /*!< [31..0] Output Image Data Destination Address (in 8-byte units)
                                        *   The lower three bits should be set to 0.                                  */
        } JIFDDA_b;
    };

    union
    {
        __IOM uint32_t JIFDSDC;         /*!< (@ 0x00000068) JPEG Interface Decompression Source Data Count
                                         *                  Register                                                   */

        struct
        {
            __IOM uint32_t JDATAS : 16; /*!< [15..0] Amount of Input Coded Data to be Read (in 8-byte units)
                                         *   The lower three bits should be set to 0.                                  */
            uint32_t : 16;
        } JIFDSDC_b;
    };

    union
    {
        __IOM uint32_t JIFDDLC;        /*!< (@ 0x0000006C) JPEG Interface Decompression Destination Line
                                        *                  Count Register                                             */

        struct
        {
            __IOM uint32_t LINES : 16; /*!< [15..0] Number of Input Image Lines to Be ReadThe lower three
                                        *   bits should be set to 0. These bits are read as0.Number
                                        *   of input image data lines to be read, in 8-line units.                    */
            uint32_t : 16;
        } JIFDDLC_b;
    };

    union
    {
        __IOM uint32_t JIFDADT;        /*!< (@ 0x00000070) JPEG Interface Decompression alpha Set Register            */

        struct
        {
            __IOM uint32_t ALPHA : 8;  /*!< [7..0] Setting of the alpha value for output in ARGB8888 format.          */
            uint32_t             : 24;
        } JIFDADT_b;
    };
    __IM uint32_t RESERVED4[6];

    union
    {
        __IOM uint32_t JINTE1;          /*!< (@ 0x0000008C) JPEG Interrupt Enable Register 1                           */

        struct
        {
            __IOM uint32_t DOUTLEN : 1; /*!< [0..0] Enables or disables a data transfer processing interrupt
                                         *   request (JDTI) when the DOUTLF bit in JINTS1 is set to
                                         *   1                                                                         */
            __IOM uint32_t JINEN : 1;   /*!< [1..1] Enables or disables a data transfer processing interrupt
                                         *   request (JDTI) when the JINF bit in JINTS1 is set to 1.                   */
            __IOM uint32_t DBTEN : 1;   /*!< [2..2] Enables or disables a data transfer processing interrupt
                                         *   request (JDTI) when the DBTF bit in JINTS1 is set to 1.                   */
            uint32_t              : 2;
            __IOM uint32_t DINLEN : 1;  /*!< [5..5] Enables or disables a data transfer processing interrupt
                                         *   request (JDTI) when the DINLF bit in JINTS1 is set to 1.                  */
            __IOM uint32_t CBTEN : 1;   /*!< [6..6] Enables or disables a data transfer processing interrupt
                                         *   request (JDTI) when the CBTF bit in JINTS1 is set to 1.                   */
            uint32_t : 25;
        } JINTE1_b;
    };

    union
    {
        __IOM uint32_t JINTS1;         /*!< (@ 0x00000090) JPEG Interrupt Status Register 1                           */

        struct
        {
            __IOM uint32_t DOUTLF : 1; /*!< [0..0] In decompression, this bit is set to 1 when the number
                                        *   of lines of output image data indicated by JIFDDLC have
                                        *   been written. This bit is only valid when the DOUTLC bit
                                        *   in JIFDCNT is set to 1.                                                   */
            __IOM uint32_t JINF : 1;   /*!< [1..1] This bit is set to 1 when the amount of input coded data
                                        *   indicated by JIFDSDC is read in decompression. This bit
                                        *   is valid only when the JINC bit in JIFDCNT is set to 1.                   */
            __IOM uint32_t DBTF : 1;   /*!< [2..2] This bit is set to 1 when the last output image data
                                        *   is written in decompression.                                              */
            uint32_t             : 2;
            __IOM uint32_t DINLF : 1;  /*!< [5..5] This bit is set to 1 when the number of input image data
                                        *   lines indicated by JIFESLC is read in compression. This
                                        *   bit is valid only when the DINLC bit in JIFECNT is set
                                        *   to 1.                                                                     */
            __IOM uint32_t CBTF : 1;   /*!< [6..6] This bit is set to 1 when the last output coded data
                                        *   is written in compression.                                                */
            uint32_t : 25;
        } JINTS1_b;
    };
    __IM uint32_t RESERVED5[27];
    __OM uint8_t  JCQTBL0[64];         /*!< (@ 0x00000100) Quantization Table 0                                       */
    __OM uint8_t  JCQTBL1[64];         /*!< (@ 0x00000140) Quantization Table 1                                       */
    __OM uint8_t  JCQTBL2[64];         /*!< (@ 0x00000180) Quantization Table 2                                       */
    __OM uint8_t  JCQTBL3[64];         /*!< (@ 0x000001C0) Quantization Table 3                                       */
    __IOM uint8_t JCHTBD0[28];         /*!< (@ 0x00000200) DC Huffman Table 0                                         */
    __IM uint32_t RESERVED6;
    __IOM uint8_t JCHTBA0[178];        /*!< (@ 0x00000220) AC Huffman Table 0                                         */
    __IM uint16_t RESERVED7;
    __IM uint32_t RESERVED8[11];
    __IOM uint8_t JCHTBD1[28];         /*!< (@ 0x00000300) DC Huffman Table 1                                         */
    __IM uint32_t RESERVED9;
    __IOM uint8_t JCHTBA1[178];        /*!< (@ 0x00000320) DC Huffman Table 1                                         */
    __IM uint16_t RESERVED10;
} R_JPEG_Type;                         /*!< Size = 980 (0x3d4)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_KINT                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Key Interrupt Function (R_KINT)
 */

typedef struct                         /*!< (@ 0x40080000) R_KINT Structure                                           */
{
    union
    {
        __IOM uint8_t KRCTL;           /*!< (@ 0x00000000) KEY Return Control Register                                */

        struct
        {
            __IOM uint8_t KREG : 1;    /*!< [0..0] Detection Edge Selection (KRF0 to KRF7)                            */
            uint8_t            : 6;
            __IOM uint8_t KRMD : 1;    /*!< [7..7] Usage of Key Interrupt Flags(KR0 to KR7)                           */
        } KRCTL_b;
    };
    __IM uint8_t RESERVED[3];

    union
    {
        __IOM uint8_t KRF;             /*!< (@ 0x00000004) KEY Return Flag Register                                   */

        struct
        {
            __IOM uint8_t KRF0 : 1;    /*!< [0..0] Key interrupt flag 0                                               */
            __IOM uint8_t KRF1 : 1;    /*!< [1..1] Key interrupt flag 1                                               */
            __IOM uint8_t KRF2 : 1;    /*!< [2..2] Key interrupt flag 2                                               */
            __IOM uint8_t KRF3 : 1;    /*!< [3..3] Key interrupt flag 3                                               */
            __IOM uint8_t KRF4 : 1;    /*!< [4..4] Key interrupt flag 4                                               */
            __IOM uint8_t KRF5 : 1;    /*!< [5..5] Key interrupt flag 5                                               */
            __IOM uint8_t KRF6 : 1;    /*!< [6..6] Key interrupt flag 6                                               */
            __IOM uint8_t KRF7 : 1;    /*!< [7..7] Key interrupt flag 7                                               */
        } KRF_b;
    };
    __IM uint8_t RESERVED1[3];

    union
    {
        __IOM uint8_t KRM;             /*!< (@ 0x00000008) KEY Return Mode Register                                   */

        struct
        {
            __IOM uint8_t KRM0 : 1;    /*!< [0..0] Key interrupt mode control 0                                       */
            __IOM uint8_t KRM1 : 1;    /*!< [1..1] Key interrupt mode control 1                                       */
            __IOM uint8_t KRM2 : 1;    /*!< [2..2] Key interrupt mode control 2                                       */
            __IOM uint8_t KRM3 : 1;    /*!< [3..3] Key interrupt mode control 3                                       */
            __IOM uint8_t KRM4 : 1;    /*!< [4..4] Key interrupt mode control 4                                       */
            __IOM uint8_t KRM5 : 1;    /*!< [5..5] Key interrupt mode control 5                                       */
            __IOM uint8_t KRM6 : 1;    /*!< [6..6] Key interrupt mode control 6                                       */
            __IOM uint8_t KRM7 : 1;    /*!< [7..7] Key interrupt mode control 7                                       */
        } KRM_b;
    };
} R_KINT_Type;                         /*!< Size = 9 (0x9)                                                            */

/* =========================================================================================================================== */
/* ================                                          R_I3C0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief I3C Bus Interface (R_I3C0)
 */

typedef struct                         /*!< (@ 0x40083000) R_I3C0 Structure                                           */
{
    union
    {
        __IOM uint32_t PRTS;           /*!< (@ 0x00000000) Protocol Selection Register                                */

        struct
        {
            __IOM uint32_t PRTMD : 1;  /*!< [0..0] Protocol Mode                                                      */
            uint32_t             : 31;
        } PRTS_b;
    };
    __IM uint32_t RESERVED[3];

    union
    {
        __IOM uint32_t CECTL;          /*!< (@ 0x00000010) Clock Enable Control Resisters                             */

        struct
        {
            __IOM uint32_t CLKE : 1;   /*!< [0..0] Clock Enable                                                       */
            uint32_t            : 31;
        } CECTL_b;
    };

    union
    {
        __IOM uint32_t BCTL;             /*!< (@ 0x00000014) Bus Control Register                                       */

        struct
        {
            __IOM uint32_t INCBA    : 1; /*!< [0..0] Include I3C Broadcast Address                                      */
            uint32_t                : 6;
            __IOM uint32_t BMDS     : 1; /*!< [7..7] Bus Mode Selection                                                 */
            __IOM uint32_t HJACKCTL : 1; /*!< [8..8] Hot-Join Acknowledge Control                                       */
            uint32_t                : 20;
            __IOM uint32_t ABT      : 1; /*!< [29..29] Abort                                                            */
            __IOM uint32_t RSM      : 1; /*!< [30..30] Resume                                                           */
            __IOM uint32_t BUSE     : 1; /*!< [31..31] Bus Enable                                                       */
        } BCTL_b;
    };

    union
    {
        __IOM uint32_t MSDVAD;         /*!< (@ 0x00000018) Master Device Address Register                             */

        struct
        {
            uint32_t              : 16;
            __IOM uint32_t MDYAD  : 7; /*!< [22..16] Master Dynamic Address                                           */
            uint32_t              : 8;
            __IOM uint32_t MDYADV : 1; /*!< [31..31] Master Dynamic Address Valid                                     */
        } MSDVAD_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __IOM uint32_t RSTCTL;          /*!< (@ 0x00000020) Reset Control Register                                     */

        struct
        {
            __IOM uint32_t RI3CRST : 1; /*!< [0..0] I3C Software Reset                                                 */
            __IOM uint32_t CMDQRST : 1; /*!< [1..1] Command Queue Software Reset                                       */
            __IOM uint32_t RSPQRST : 1; /*!< [2..2] Response Queue Software Reset                                      */
            __IOM uint32_t TDBRST  : 1; /*!< [3..3] Transmit Data Buffer Software Reset                                */
            __IOM uint32_t RDBRST  : 1; /*!< [4..4] Receive Data Buffer Software Reset                                 */
            __IOM uint32_t IBIQRST : 1; /*!< [5..5] IBI Queue Software Reset                                           */
            __IOM uint32_t RSQRST  : 1; /*!< [6..6] Receive Status Queue Software Reset                                */
            uint32_t               : 9;
            __IOM uint32_t INTLRST : 1; /*!< [16..16] Internal Software Reset                                          */
            uint32_t               : 15;
        } RSTCTL_b;
    };

    union
    {
        __IOM uint32_t PRSST;          /*!< (@ 0x00000024) Present State Register                                     */

        struct
        {
            uint32_t              : 2;
            __IOM uint32_t CRMS   : 1; /*!< [2..2] Current Master                                                     */
            uint32_t              : 1;
            __IM uint32_t TRMD    : 1; /*!< [4..4] Transmit/Receive Mode                                              */
            uint32_t              : 2;
            __OM uint32_t PRSSTWP : 1; /*!< [7..7] Present State Write Protect                                        */
            uint32_t              : 24;
        } PRSST_b;
    };
    __IM uint32_t RESERVED2[2];

    union
    {
        __IOM uint32_t INST;           /*!< (@ 0x00000030) Internal Status Register                                   */

        struct
        {
            uint32_t            : 10;
            __IOM uint32_t INEF : 1;   /*!< [10..10] Internal Error Flag                                              */
            uint32_t            : 21;
        } INST_b;
    };

    union
    {
        __IOM uint32_t INSTE;          /*!< (@ 0x00000034) Internal Status Enable Register                            */

        struct
        {
            uint32_t            : 10;
            __IOM uint32_t INEE : 1;   /*!< [10..10] Internal Error Enable                                            */
            uint32_t            : 21;
        } INSTE_b;
    };

    union
    {
        __IOM uint32_t INIE;           /*!< (@ 0x00000038) Internal Interrupt Enable Register                         */

        struct
        {
            uint32_t             : 10;
            __IOM uint32_t INEIE : 1;  /*!< [10..10] Internal Error Interrupt Enable                                  */
            uint32_t             : 21;
        } INIE_b;
    };

    union
    {
        __IOM uint32_t INSTFC;         /*!< (@ 0x0000003C) Internal Status Force Register                             */

        struct
        {
            uint32_t            : 10;
            __OM uint32_t INEFC : 1;   /*!< [10..10] Internal Error Force                                             */
            uint32_t            : 21;
        } INSTFC_b;
    };
    __IM uint32_t RESERVED3;

    union
    {
        __IM uint32_t DVCT;            /*!< (@ 0x00000044) Device Characteristic Table Register                       */

        struct
        {
            uint32_t          : 19;
            __IM uint32_t IDX : 5;     /*!< [23..19] DCT Table Index                                                  */
            uint32_t          : 8;
        } DVCT_b;
    };
    __IM uint32_t RESERVED4[4];

    union
    {
        __IOM uint32_t IBINCTL;          /*!< (@ 0x00000058) IBI Notify Control Register                                */

        struct
        {
            __IOM uint32_t NRHJCTL  : 1; /*!< [0..0] Notify Rejected Hot-Join Control                                   */
            __IOM uint32_t NRMRCTL  : 1; /*!< [1..1] Notify Rejected Master Request Control                             */
            uint32_t                : 1;
            __IOM uint32_t NRSIRCTL : 1; /*!< [3..3] Notify Rejected Slave Interrupt Request Control                    */
            uint32_t                : 28;
        } IBINCTL_b;
    };
    __IM uint32_t RESERVED5;

    union
    {
        __IOM uint32_t BFCTL;          /*!< (@ 0x00000060) Bus Function Control Register                              */

        struct
        {
            __IOM uint32_t MALE   : 1; /*!< [0..0] Master Arbitration-Lost Detection Enable                           */
            __IOM uint32_t NALE   : 1; /*!< [1..1] NACK Transmission Arbitration-Lost Detection Enable                */
            __IOM uint32_t SALE   : 1; /*!< [2..2] Slave Arbitration-Lost Detection Enable                            */
            uint32_t              : 5;
            __IOM uint32_t SCSYNE : 1; /*!< [8..8] SCL Synchronous Circuit Enable                                     */
            uint32_t              : 3;
            __IOM uint32_t SMBS   : 1; /*!< [12..12] SMBus/I2C Bus Selection                                          */
            uint32_t              : 1;
            __IOM uint32_t FMPE   : 1; /*!< [14..14] Fast-mode Plus Enable                                            */
            __IOM uint32_t HSME   : 1; /*!< [15..15] High Speed Mode Enable                                           */
            uint32_t              : 16;
        } BFCTL_b;
    };

    union
    {
        __IOM uint32_t SVCTL;          /*!< (@ 0x00000064) Slave Control Register                                     */

        struct
        {
            __IOM uint32_t GCAE  : 1;  /*!< [0..0] General Call Address Enable                                        */
            uint32_t             : 4;
            __IOM uint32_t HSMCE : 1;  /*!< [5..5] Hs-mode Master Code Enable                                         */
            __IOM uint32_t DVIDE : 1;  /*!< [6..6] Device-ID Address Enable                                           */
            uint32_t             : 8;
            __IOM uint32_t HOAE  : 1;  /*!< [15..15] Host Address Enable                                              */
            __IOM uint32_t SVAEn : 1;  /*!< [16..16] Slave Address Enable n (n = 0)                                   */
            uint32_t             : 15;
        } SVCTL_b;
    };
    __IM uint32_t RESERVED6[2];

    union
    {
        __IOM uint32_t REFCKCTL;        /*!< (@ 0x00000070) Reference Clock Control Register                           */

        struct
        {
            __IOM uint32_t IREFCKS : 3; /*!< [2..0] Internal Reference Clock Selection                                 */
            uint32_t               : 29;
        } REFCKCTL_b;
    };

    union
    {
        __IOM uint32_t STDBR;          /*!< (@ 0x00000074) Standard Bit Rate Register                                 */

        struct
        {
            __IOM uint32_t SBRLO  : 8; /*!< [7..0] Count value of the Low-level period of SCL clock                   */
            __IOM uint32_t SBRHO  : 8; /*!< [15..8] Count value of the High-level period of SCL clock                 */
            __IOM uint32_t SBRLP  : 6; /*!< [21..16] Standard Bit Rate Low-level Period Push-Pull                     */
            uint32_t              : 2;
            __IOM uint32_t SBRHP  : 6; /*!< [29..24] Standard Bit Rate High-Level Period Push-Pull                    */
            uint32_t              : 1;
            __IOM uint32_t DSBRPO : 1; /*!< [31..31] Double the Standard Bit Rate Period for Open-Drain               */
        } STDBR_b;
    };

    union
    {
        __IOM uint32_t EXTBR;          /*!< (@ 0x00000078) Extended Bit Rate Register                                 */

        struct
        {
            __IOM uint32_t EBRLO : 8;  /*!< [7..0] Extended Bit Rate Low-Level Period Open-Drain                      */
            __IOM uint32_t EBRHO : 8;  /*!< [15..8] Extended Bit Rate High-Level Period Open-Drain                    */
            __IOM uint32_t EBRLP : 6;  /*!< [21..16] Extended Bit Rate Low-Level Period Push-Pull                     */
            uint32_t             : 2;
            __IOM uint32_t EBRHP : 6;  /*!< [29..24] Extended Bit Rate Low-Level Period Push-Pull                     */
            uint32_t             : 2;
        } EXTBR_b;
    };

    union
    {
        __IOM uint32_t BFRECDT;        /*!< (@ 0x0000007C) Bus Free Condition Detection Time Register                 */

        struct
        {
            __IOM uint32_t FRECYC : 9; /*!< [8..0] Bus Free Condition Detection Cycle                                 */
            uint32_t              : 23;
        } BFRECDT_b;
    };

    union
    {
        __IOM uint32_t BAVLCDT;        /*!< (@ 0x00000080) Bus Available Condition Detection Time Register            */

        struct
        {
            __IOM uint32_t AVLCYC : 9; /*!< [8..0] Bus Available Condition Detection Cycle                            */
            uint32_t              : 23;
        } BAVLCDT_b;
    };

    union
    {
        __IOM uint32_t BIDLCDT;         /*!< (@ 0x00000084) Bus Idle Condition Detection Time Register                 */

        struct
        {
            __IOM uint32_t IDLCYC : 18; /*!< [17..0] Bus Idle Condition Detection Cycle                                */
            uint32_t              : 14;
        } BIDLCDT_b;
    };

    union
    {
        __IOM uint32_t OUTCTL;         /*!< (@ 0x00000088) Output Control Register                                    */

        struct
        {
            __IOM uint32_t SDOC   : 1; /*!< [0..0] SDA Output Control                                                 */
            __IOM uint32_t SCOC   : 1; /*!< [1..1] SCL Output Control                                                 */
            __OM uint32_t  SOCWP  : 1; /*!< [2..2] SCL/SDA Output Control Write Protect                               */
            uint32_t              : 1;
            __IOM uint32_t EXCYC  : 1; /*!< [4..4] Extra SCL Clock Cycle Output                                       */
            uint32_t              : 3;
            __IOM uint32_t SDOD   : 3; /*!< [10..8] SDA Output Delay                                                  */
            uint32_t              : 4;
            __IOM uint32_t SDODCS : 1; /*!< [15..15] SDA Output Delay Clock Source Selection                          */
            uint32_t              : 16;
        } OUTCTL_b;
    };

    union
    {
        __IOM uint32_t INCTL;          /*!< (@ 0x0000008C) Input Control Register                                     */

        struct
        {
            __IOM uint32_t DNFS : 4;   /*!< [3..0] Digital Noise Filter Stage Selection                               */
            __IOM uint32_t DNFE : 1;   /*!< [4..4] Digital Noise Filter Circuit Enable                                */
            uint32_t            : 27;
        } INCTL_b;
    };

    union
    {
        __IOM uint32_t TMOCTL;         /*!< (@ 0x00000090) Timeout Control Register                                   */

        struct
        {
            __IOM uint32_t TODTS  : 2; /*!< [1..0] Timeout Detection Time Selection                                   */
            uint32_t              : 2;
            __IOM uint32_t TOLCTL : 1; /*!< [4..4] Timeout L Count Control                                            */
            __IOM uint32_t TOHCTL : 1; /*!< [5..5] Timeout H Count Control                                            */
            __IOM uint32_t TOMDS  : 2; /*!< [7..6] Timeout Operation Mode Selection                                   */
            uint32_t              : 24;
        } TMOCTL_b;
    };
    __IM uint32_t RESERVED7;

    union
    {
        __IOM uint32_t WUCTL;           /*!< (@ 0x00000098) Wake Up Unit Control Register                              */

        struct
        {
            __IOM uint32_t WUACKS  : 1; /*!< [0..0] Wake-Up Acknowledge Selection                                      */
            uint32_t               : 3;
            __IOM uint32_t WUANFS  : 1; /*!< [4..4] Wake-Up Analog Noise Filter Selection                              */
            uint32_t               : 1;
            __IOM uint32_t WUFSYNE : 1; /*!< [6..6] Wake-Up function PCLKA Synchronous Enable                          */
            __IOM uint32_t WUFE    : 1; /*!< [7..7] Wake-Up function Enable.                                           */
            uint32_t               : 24;
        } WUCTL_b;
    };
    __IM uint32_t RESERVED8;

    union
    {
        __IOM uint32_t ACKCTL;         /*!< (@ 0x000000A0) Acknowledge Control Register                               */

        struct
        {
            __IM uint32_t  ACKR   : 1; /*!< [0..0] Acknowledge Reception                                              */
            __IOM uint32_t ACKT   : 1; /*!< [1..1] Acknowledge Transmission                                           */
            __OM uint32_t  ACKTWP : 1; /*!< [2..2] ACKT Write Protect                                                 */
            uint32_t              : 29;
        } ACKCTL_b;
    };

    union
    {
        __IOM uint32_t SCSTRCTL;       /*!< (@ 0x000000A4) SCL Stretch Control Register                               */

        struct
        {
            __IOM uint32_t ACKTWE : 1; /*!< [0..0] Acknowledge Transmission Wait Enable                               */
            __IOM uint32_t RWE    : 1; /*!< [1..1] Receive Wait Enable                                                */
            uint32_t              : 30;
        } SCSTRCTL_b;
    };
    __IM uint32_t RESERVED9[2];

    union
    {
        __IOM uint32_t SCSTLCTL;        /*!< (@ 0x000000B0) SCL Stalling Control Register                              */

        struct
        {
            __IOM uint32_t STLCYC : 16; /*!< [15..0] Stalling Cycle                                                    */
            uint32_t              : 12;
            __IOM uint32_t AAPE   : 1;  /*!< [28..28] Assigend Address Phase Enable                                    */
            __IOM uint32_t TRAPE  : 1;  /*!< [29..29] Transition Phase Enable                                          */
            __IOM uint32_t PARPE  : 1;  /*!< [30..30] Parity Phase Enable                                              */
            __IOM uint32_t ACKPE  : 1;  /*!< [31..31] ACK phase Enable                                                 */
        } SCSTLCTL_b;
    };
    __IM uint32_t RESERVED10[3];

    union
    {
        __IOM uint32_t SVTDLG0;        /*!< (@ 0x000000C0) Slave Transfer Data Length Register 0                      */

        struct
        {
            uint32_t             : 16;
            __IOM uint32_t STDLG : 16; /*!< [31..16] Slave Transfer Data Length                                       */
        } SVTDLG0_b;
    };
    __IM uint32_t RESERVED11[31];

    union
    {
        __IOM uint32_t CNDCTL;         /*!< (@ 0x00000140) Condition Control Register                                 */

        struct
        {
            __IOM uint32_t STCND : 1;  /*!< [0..0] START (S) Condition Issuance                                       */
            __IOM uint32_t SRCND : 1;  /*!< [1..1] Repeated START (Sr) Condition Issuance                             */
            __IOM uint32_t SPCND : 1;  /*!< [2..2] STOP (P) Condition Issuance                                        */
            uint32_t             : 29;
        } CNDCTL_b;
    };
    __IM uint32_t  RESERVED12[3];
    __OM uint32_t  NCMDQP;             /*!< (@ 0x00000150) Normal Command Queue Port Register                         */
    __IM uint32_t  NRSPQP;             /*!< (@ 0x00000154) Normal Response Queue Port Register                        */
    __IOM uint32_t NTDTBP0;            /*!< (@ 0x00000158) Normal Transfer Data Buffer Port Register 0                */
    __IM uint32_t  RESERVED13[8];
    __IOM uint32_t NIBIQP;             /*!< (@ 0x0000017C) Normal IBI Queue Port Register                             */
    __IM uint32_t  NRSQP;              /*!< (@ 0x00000180) Normal Receive Status Queue Port Register                  */
    __IM uint32_t  RESERVED14[3];

    union
    {
        __IOM uint32_t NQTHCTL;         /*!< (@ 0x00000190) Normal Queue Threshold Control Register                    */

        struct
        {
            __IOM uint32_t CMDQTH  : 8; /*!< [7..0] Normal Command Ready Queue Threshold                               */
            __IOM uint32_t RSPQTH  : 8; /*!< [15..8] Normal Response Queue Threshold                                   */
            __IOM uint32_t IBIDSSZ : 8; /*!< [23..16] Normal IBI Data Segment Size                                     */
            __IOM uint32_t IBIQTH  : 8; /*!< [31..24] Normal IBI Queue Threshold                                       */
        } NQTHCTL_b;
    };

    union
    {
        __IOM uint32_t NTBTHCTL0;      /*!< (@ 0x00000194) Normal Transfer Data Buffer Threshold Control
                                        *                  Register 0                                                 */

        struct
        {
            __IOM uint32_t TXDBTH : 3; /*!< [2..0] Normal Transmit Data Buffer Threshold                              */
            uint32_t              : 5;
            __IOM uint32_t RXDBTH : 3; /*!< [10..8] Normal Receive Data Buffer Threshold                              */
            uint32_t              : 5;
            __IOM uint32_t TXSTTH : 3; /*!< [18..16] Normal Tx Start Threshold                                        */
            uint32_t              : 5;
            __IOM uint32_t RXSTTH : 3; /*!< [26..24] Normal Rx Start Threshold                                        */
            uint32_t              : 5;
        } NTBTHCTL0_b;
    };
    __IM uint32_t RESERVED15[10];

    union
    {
        __IOM uint32_t NRQTHCTL;       /*!< (@ 0x000001C0) Normal Receive Status Queue Threshold Control
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t RSQTH : 8;  /*!< [7..0] Normal Receive Status Queue Threshold                              */
            uint32_t             : 24;
        } NRQTHCTL_b;
    };
    __IM uint32_t RESERVED16[3];

    union
    {
        __IOM uint32_t BST;             /*!< (@ 0x000001D0) Bus Status Register                                        */

        struct
        {
            __IOM uint32_t STCNDDF : 1; /*!< [0..0] START condition Detection Flag                                     */
            __IOM uint32_t SPCNDDF : 1; /*!< [1..1] STOP condition Detection Flag                                      */
            __IOM uint32_t HDREXDF : 1; /*!< [2..2] HDR Exit Pattern Detection Flag                                    */
            uint32_t               : 1;
            __IOM uint32_t NACKDF  : 1; /*!< [4..4] NACK Detection Flag                                                */
            uint32_t               : 3;
            __IOM uint32_t TENDF   : 1; /*!< [8..8] Transmit End Flag                                                  */
            uint32_t               : 7;
            __IOM uint32_t ALF     : 1; /*!< [16..16] Arbitration Lost Flag                                            */
            uint32_t               : 3;
            __IOM uint32_t TODF    : 1; /*!< [20..20] Timeout Detection Flag                                           */
            uint32_t               : 11;
        } BST_b;
    };

    union
    {
        __IOM uint32_t BSTE;            /*!< (@ 0x000001D4) Bus Status Enable Register                                 */

        struct
        {
            __IOM uint32_t STCNDDE : 1; /*!< [0..0] START condition Detection Enable                                   */
            __IOM uint32_t SPCNDDE : 1; /*!< [1..1] STOP condition Detection Enable                                    */
            __IOM uint32_t HDREXDE : 1; /*!< [2..2] HDR Exit Pattern Detection Enable                                  */
            uint32_t               : 1;
            __IOM uint32_t NACKDE  : 1; /*!< [4..4] NACK Detection Enable                                              */
            uint32_t               : 3;
            __IOM uint32_t TENDE   : 1; /*!< [8..8] Transmit End Enable                                                */
            uint32_t               : 7;
            __IOM uint32_t ALE     : 1; /*!< [16..16] Arbitration Lost Enable                                          */
            uint32_t               : 3;
            __IOM uint32_t TODE    : 1; /*!< [20..20] Timeout Detection Enable                                         */
            uint32_t               : 11;
        } BSTE_b;
    };

    union
    {
        __IOM uint32_t BIE;              /*!< (@ 0x000001D8) Bus Interrupt Enable Register                              */

        struct
        {
            __IOM uint32_t STCNDDIE : 1; /*!< [0..0] START condition Detection Interrupt Enable                         */
            __IOM uint32_t SPCNDDIE : 1; /*!< [1..1] STOP condition Detection Interrupt Enable                          */
            __IOM uint32_t HDREXDIE : 1; /*!< [2..2] HDR Exit Pattern Detection Interrupt Enable                        */
            uint32_t                : 1;
            __IOM uint32_t NACKDIE  : 1; /*!< [4..4] NACK Detection Interrupt Enable                                    */
            uint32_t                : 3;
            __IOM uint32_t TENDIE   : 1; /*!< [8..8] Transmit End Interrupt Enable                                      */
            uint32_t                : 7;
            __IOM uint32_t ALIE     : 1; /*!< [16..16] Arbitration Lost Interrupt Enable                                */
            uint32_t                : 3;
            __IOM uint32_t TODIE    : 1; /*!< [20..20] Timeout Detection Interrupt Enable                               */
            uint32_t                : 11;
        } BIE_b;
    };

    union
    {
        __IOM uint32_t BSTFC;           /*!< (@ 0x000001DC) Bus Status Force Register                                  */

        struct
        {
            __OM uint32_t STCNDDFC : 1; /*!< [0..0] START condition Detection Force                                    */
            __OM uint32_t SPCNDDFC : 1; /*!< [1..1] STOP condition Detection Force                                     */
            __OM uint32_t HDREXDFC : 1; /*!< [2..2] HDR Exit Pattern Detection Force                                   */
            uint32_t               : 1;
            __OM uint32_t NACKDFC  : 1; /*!< [4..4] NACK Detection Force                                               */
            uint32_t               : 3;
            __OM uint32_t TENDFC   : 1; /*!< [8..8] Transmit End Force                                                 */
            uint32_t               : 7;
            __OM uint32_t ALFC     : 1; /*!< [16..16] Arbitration Lost Force                                           */
            uint32_t               : 3;
            __OM uint32_t TODFC    : 1; /*!< [20..20] Timeout Detection Force                                          */
            uint32_t               : 11;
        } BSTFC_b;
    };

    union
    {
        __IOM uint32_t NTST;            /*!< (@ 0x000001E0) Normal Transfer Status Register                            */

        struct
        {
            __IOM uint32_t TDBEF0  : 1; /*!< [0..0] Normal Transmit Data Buffer Empty Flag 0                           */
            __IOM uint32_t RDBFF0  : 1; /*!< [1..1] Normal Receive Data Buffer Full Flag 0                             */
            __IOM uint32_t IBIQEFF : 1; /*!< [2..2] Normal IBI Queue Empty/Full Flag                                   */
            __IOM uint32_t CMDQEF  : 1; /*!< [3..3] Normal Command Queue Empty Flag                                    */
            __IOM uint32_t RSPQFF  : 1; /*!< [4..4] Normal Response Queue Full Flag                                    */
            __IOM uint32_t TABTF   : 1; /*!< [5..5] Normal Transfer Abort Flag                                         */
            uint32_t               : 3;
            __IOM uint32_t TEF     : 1; /*!< [9..9] Normal Transfer Error Flag                                         */
            uint32_t               : 10;
            __IOM uint32_t RSQFF   : 1; /*!< [20..20] Normal Receive Status Queue Full Flag                            */
            uint32_t               : 11;
        } NTST_b;
    };

    union
    {
        __IOM uint32_t NTSTE;           /*!< (@ 0x000001E4) Normal Transfer Status Enable Register                     */

        struct
        {
            __IOM uint32_t TDBEE0  : 1; /*!< [0..0] Normal Transmit Data Buffer Empty Enable 0                         */
            __IOM uint32_t RDBFE0  : 1; /*!< [1..1] Normal Receive Data Buffer Full Enable 0                           */
            __IOM uint32_t IBIQEFE : 1; /*!< [2..2] Normal IBI Queue Empty/Full Enable                                 */
            __IOM uint32_t CMDQEE  : 1; /*!< [3..3] Normal Command Queue Empty Enable                                  */
            __IOM uint32_t RSPQFE  : 1; /*!< [4..4] Normal Response Queue Full Enable                                  */
            __IOM uint32_t TABTE   : 1; /*!< [5..5] Normal Transfer Abort Enable                                       */
            uint32_t               : 3;
            __IOM uint32_t TEE     : 1; /*!< [9..9] Normal Transfer Error Enable                                       */
            uint32_t               : 10;
            __IOM uint32_t RSQFE   : 1; /*!< [20..20] Normal Receive Status Queue Full Enable                          */
            uint32_t               : 11;
        } NTSTE_b;
    };

    union
    {
        __IOM uint32_t NTIE;             /*!< (@ 0x000001E8) Normal Transfer Interrupt Enable Register                  */

        struct
        {
            __IOM uint32_t TDBEIE0  : 1; /*!< [0..0] Normal Transmit Data Buffer Empty Interrupt Enable 0               */
            __IOM uint32_t RDBFIE0  : 1; /*!< [1..1] Normal Receive Data Buffer Full Interrupt Enable 0                 */
            __IOM uint32_t IBIQEFIE : 1; /*!< [2..2] Normal IBI Queue Empty/Full Interrupt Enable                       */
            __IOM uint32_t CMDQEIE  : 1; /*!< [3..3] Normal Command Queue Empty Interrupt Enable                        */
            __IOM uint32_t RSPQFIE  : 1; /*!< [4..4] Normal Response Queue Full Interrupt Enable                        */
            __IOM uint32_t TABTIE   : 1; /*!< [5..5] Normal Transfer Abort Interrupt Enable                             */
            uint32_t                : 3;
            __IOM uint32_t TEIE     : 1; /*!< [9..9] Normal Transfer Error Interrupt Enable                             */
            uint32_t                : 10;
            __IOM uint32_t RSQFIE   : 1; /*!< [20..20] Normal Receive Status Queue Full Interrupt Enable                */
            uint32_t                : 11;
        } NTIE_b;
    };

    union
    {
        __IOM uint32_t NTSTFC;          /*!< (@ 0x000001EC) Normal Transfer Status Force Register                      */

        struct
        {
            __OM uint32_t TDBEFC0  : 1; /*!< [0..0] Normal Transmit Data Buffer Empty Force 0                          */
            __OM uint32_t RDBFFC0  : 1; /*!< [1..1] Normal Receive Data Buffer Full Force 0                            */
            __OM uint32_t IBIQEFFC : 1; /*!< [2..2] Normal IBI Queue Empty/Full Force                                  */
            __OM uint32_t CMDQEFC  : 1; /*!< [3..3] Normal Command Queue Empty Force                                   */
            __OM uint32_t RSPQFFC  : 1; /*!< [4..4] Normal Response Queue Full Force                                   */
            __OM uint32_t TABTFC   : 1; /*!< [5..5] Normal Transfer Abort Force                                        */
            uint32_t               : 3;
            __OM uint32_t TEFC     : 1; /*!< [9..9] Normal Transfer Error Force                                        */
            uint32_t               : 10;
            __OM uint32_t RSQFFC   : 1; /*!< [20..20] Normal Receive Status Queue Full Force                           */
            uint32_t               : 11;
        } NTSTFC_b;
    };
    __IM uint32_t RESERVED17[8];

    union
    {
        __IM uint32_t BCST;            /*!< (@ 0x00000210) Bus Condition Status Register                              */

        struct
        {
            __IM uint32_t BFREF : 1;   /*!< [0..0] Bus Free Detection Flag                                            */
            __IM uint32_t BAVLF : 1;   /*!< [1..1] Bus Available Detection Flag                                       */
            __IM uint32_t BIDLF : 1;   /*!< [2..2] Bus Idle Detection Flag                                            */
            uint32_t            : 29;
        } BCST_b;
    };

    union
    {
        __IOM uint32_t SVST;           /*!< (@ 0x00000214) Slave Status Register                                      */

        struct
        {
            __IOM uint32_t GCAF  : 1;  /*!< [0..0] General Call Address Detection Flag                                */
            uint32_t             : 4;
            __IOM uint32_t HSMCF : 1;  /*!< [5..5] Hs-mode Master Code Detection Flag                                 */
            __IOM uint32_t DVIDF : 1;  /*!< [6..6] Device-ID Address Detection Flag                                   */
            uint32_t             : 8;
            __IOM uint32_t HOAF  : 1;  /*!< [15..15] Host Address Detection Flag                                      */
            __IOM uint32_t SVAFn : 1;  /*!< [16..16] Slave Address Detection Flag n (n = 0)                           */
            uint32_t             : 15;
        } SVST_b;
    };

    union
    {
        __IOM uint32_t WUST;            /*!< (@ 0x00000218) Wake Up Unit Control Register                              */

        struct
        {
            __IOM uint32_t WUASYNF : 1; /*!< [0..0] Wake-up function asynchronous operation status flag.               */
            uint32_t               : 31;
        } WUST_b;
    };
    __IM uint32_t RESERVED18[2];

    union
    {
        __IOM uint32_t DATBAS0;         /*!< (@ 0x00000224) Device Address Table Basic Register 0                      */

        struct
        {
            __IOM uint32_t DVSTAD  : 7; /*!< [6..0] Device Static Address                                              */
            uint32_t               : 5;
            __IOM uint32_t DVIBIPL : 1; /*!< [12..12] Device IBI Payload                                               */
            __IOM uint32_t DVSIRRJ : 1; /*!< [13..13] Device In-Band Slave Interrupt Request Reject                    */
            __IOM uint32_t DVMRRJ  : 1; /*!< [14..14] Device In-Band Master Request Reject                             */
            __IOM uint32_t DVIBITS : 1; /*!< [15..15] Device IBI Time-stamp                                            */
            __IOM uint32_t DVDYAD  : 8; /*!< [23..16] Device I3C Dynamic Address                                       */
            uint32_t               : 5;
            __IOM uint32_t DVNACK  : 2; /*!< [30..29] Device NACK Retry Count                                          */
            __IOM uint32_t DVTYP   : 1; /*!< [31..31] Device Type                                                      */
        } DATBAS0_b;
    };
    __IM uint32_t RESERVED19;

    union
    {
        __IOM uint32_t DATBAS1;         /*!< (@ 0x0000022C) Device Address Table Basic Register 1                      */

        struct
        {
            __IOM uint32_t DVSTAD  : 7; /*!< [6..0] Device Static Address                                              */
            uint32_t               : 5;
            __IOM uint32_t DVIBIPL : 1; /*!< [12..12] Device IBI Payload                                               */
            __IOM uint32_t DVSIRRJ : 1; /*!< [13..13] Device In-Band Slave Interrupt Request Reject                    */
            __IOM uint32_t DVMRRJ  : 1; /*!< [14..14] Device In-Band Master Request Reject                             */
            __IOM uint32_t DVIBITS : 1; /*!< [15..15] Device IBI Time-stamp                                            */
            __IOM uint32_t DVDYAD  : 8; /*!< [23..16] Device I3C Dynamic Address                                       */
            uint32_t               : 5;
            __IOM uint32_t DVNACK  : 2; /*!< [30..29] Device NACK Retry Count                                          */
            __IOM uint32_t DVTYP   : 1; /*!< [31..31] Device Type                                                      */
        } DATBAS1_b;
    };
    __IM uint32_t RESERVED20;

    union
    {
        __IOM uint32_t DATBAS2;         /*!< (@ 0x00000234) Device Address Table Basic Register 2                      */

        struct
        {
            __IOM uint32_t DVSTAD  : 7; /*!< [6..0] Device Static Address                                              */
            uint32_t               : 5;
            __IOM uint32_t DVIBIPL : 1; /*!< [12..12] Device IBI Payload                                               */
            __IOM uint32_t DVSIRRJ : 1; /*!< [13..13] Device In-Band Slave Interrupt Request Reject                    */
            __IOM uint32_t DVMRRJ  : 1; /*!< [14..14] Device In-Band Master Request Reject                             */
            __IOM uint32_t DVIBITS : 1; /*!< [15..15] Device IBI Time-stamp                                            */
            __IOM uint32_t DVDYAD  : 8; /*!< [23..16] Device I3C Dynamic Address                                       */
            uint32_t               : 5;
            __IOM uint32_t DVNACK  : 2; /*!< [30..29] Device NACK Retry Count                                          */
            __IOM uint32_t DVTYP   : 1; /*!< [31..31] Device Type                                                      */
        } DATBAS2_b;
    };
    __IM uint32_t RESERVED21;

    union
    {
        __IOM uint32_t DATBAS3;         /*!< (@ 0x0000023C) Device Address Table Basic Register 3                      */

        struct
        {
            __IOM uint32_t DVSTAD  : 7; /*!< [6..0] Device Static Address                                              */
            uint32_t               : 5;
            __IOM uint32_t DVIBIPL : 1; /*!< [12..12] Device IBI Payload                                               */
            __IOM uint32_t DVSIRRJ : 1; /*!< [13..13] Device In-Band Slave Interrupt Request Reject                    */
            __IOM uint32_t DVMRRJ  : 1; /*!< [14..14] Device In-Band Master Request Reject                             */
            __IOM uint32_t DVIBITS : 1; /*!< [15..15] Device IBI Time-stamp                                            */
            __IOM uint32_t DVDYAD  : 8; /*!< [23..16] Device I3C Dynamic Address                                       */
            uint32_t               : 5;
            __IOM uint32_t DVNACK  : 2; /*!< [30..29] Device NACK Retry Count                                          */
            __IOM uint32_t DVTYP   : 1; /*!< [31..31] Device Type                                                      */
        } DATBAS3_b;
    };
    __IM uint32_t RESERVED22[24];

    union
    {
        __IOM uint32_t EXDATBAS;       /*!< (@ 0x000002A0) Extended Device Address Table Basic Register               */

        struct
        {
            __IOM uint32_t EDSTAD : 7; /*!< [6..0] Extended Device Static Address                                     */
            uint32_t              : 9;
            __IOM uint32_t EDDYAD : 8; /*!< [23..16] Extended Device I3C Dynamic Address                              */
            uint32_t              : 5;
            __IOM uint32_t EDNACK : 2; /*!< [30..29] Extended Device NACK Retry Count                                 */
            __IOM uint32_t EDTYP  : 1; /*!< [31..31] Extended Device Type                                             */
        } EXDATBAS_b;
    };
    __IM uint32_t RESERVED23[3];

    union
    {
        __IOM uint32_t SDATBAS0;         /*!< (@ 0x000002B0) Slave Device Address Table Basic Register 0                */

        struct
        {
            __IOM uint32_t SDSTAD  : 10; /*!< [9..0] Slave Device Static Address                                        */
            __IOM uint32_t SDADLS  : 1;  /*!< [10..10] Slave Device Address Length Selection                            */
            uint32_t               : 1;
            __IOM uint32_t SDIBIPL : 1;  /*!< [12..12] Slave Device IBI Payload                                         */
            uint32_t               : 3;
            __IOM uint32_t SDDYAD  : 7;  /*!< [22..16] Slave Device I3C Dynamic Address                                 */
            uint32_t               : 9;
        } SDATBAS0_b;
    };

    union
    {
        __IOM uint32_t SDATBAS1;         /*!< (@ 0x000002B4) Slave Device Address Table Basic Register 1                */

        struct
        {
            __IOM uint32_t SDSTAD  : 10; /*!< [9..0] Slave Device Static Address                                        */
            __IOM uint32_t SDADLS  : 1;  /*!< [10..10] Slave Device Address Length Selection                            */
            uint32_t               : 1;
            __IOM uint32_t SDIBIPL : 1;  /*!< [12..12] Slave Device IBI Payload                                         */
            uint32_t               : 3;
            __IOM uint32_t SDDYAD  : 7;  /*!< [22..16] Slave Device I3C Dynamic Address                                 */
            uint32_t               : 9;
        } SDATBAS1_b;
    };

    union
    {
        __IOM uint32_t SDATBAS2;         /*!< (@ 0x000002B8) Slave Device Address Table Basic Register 2                */

        struct
        {
            __IOM uint32_t SDSTAD  : 10; /*!< [9..0] Slave Device Static Address                                        */
            __IOM uint32_t SDADLS  : 1;  /*!< [10..10] Slave Device Address Length Selection                            */
            uint32_t               : 1;
            __IOM uint32_t SDIBIPL : 1;  /*!< [12..12] Slave Device IBI Payload                                         */
            uint32_t               : 3;
            __IOM uint32_t SDDYAD  : 7;  /*!< [22..16] Slave Device I3C Dynamic Address                                 */
            uint32_t               : 9;
        } SDATBAS2_b;
    };
    __IM uint32_t RESERVED24[5];

    union
    {
        __IOM uint32_t MSDCT0;         /*!< (@ 0x000002D0) Master Device Characteristic Table Register 0              */

        struct
        {
            uint32_t              : 8;
            __IOM uint32_t RBCR0  : 1; /*!< [8..8] Max Data Speed Limitation                                          */
            __IOM uint32_t RBCR1  : 1; /*!< [9..9] IBI Request Capable                                                */
            __IOM uint32_t RBCR2  : 1; /*!< [10..10] IBI Payload                                                      */
            __IOM uint32_t RBCR3  : 1; /*!< [11..11] Offline Capable                                                  */
            uint32_t              : 2;
            __IOM uint32_t RBCR76 : 2; /*!< [15..14] Device Role                                                      */
            uint32_t              : 16;
        } MSDCT0_b;
    };

    union
    {
        __IOM uint32_t MSDCT1;         /*!< (@ 0x000002D4) Master Device Characteristic Table Register 1              */

        struct
        {
            uint32_t              : 8;
            __IOM uint32_t RBCR0  : 1; /*!< [8..8] Max Data Speed Limitation                                          */
            __IOM uint32_t RBCR1  : 1; /*!< [9..9] IBI Request Capable                                                */
            __IOM uint32_t RBCR2  : 1; /*!< [10..10] IBI Payload                                                      */
            __IOM uint32_t RBCR3  : 1; /*!< [11..11] Offline Capable                                                  */
            uint32_t              : 2;
            __IOM uint32_t RBCR76 : 2; /*!< [15..14] Device Role                                                      */
            uint32_t              : 16;
        } MSDCT1_b;
    };

    union
    {
        __IOM uint32_t MSDCT2;         /*!< (@ 0x000002D8) Master Device Characteristic Table Register 2              */

        struct
        {
            uint32_t              : 8;
            __IOM uint32_t RBCR0  : 1; /*!< [8..8] Max Data Speed Limitation                                          */
            __IOM uint32_t RBCR1  : 1; /*!< [9..9] IBI Request Capable                                                */
            __IOM uint32_t RBCR2  : 1; /*!< [10..10] IBI Payload                                                      */
            __IOM uint32_t RBCR3  : 1; /*!< [11..11] Offline Capable                                                  */
            uint32_t              : 2;
            __IOM uint32_t RBCR76 : 2; /*!< [15..14] Device Role                                                      */
            uint32_t              : 16;
        } MSDCT2_b;
    };

    union
    {
        __IOM uint32_t MSDCT3;         /*!< (@ 0x000002DC) Master Device Characteristic Table Register 3              */

        struct
        {
            uint32_t              : 8;
            __IOM uint32_t RBCR0  : 1; /*!< [8..8] Max Data Speed Limitation                                          */
            __IOM uint32_t RBCR1  : 1; /*!< [9..9] IBI Request Capable                                                */
            __IOM uint32_t RBCR2  : 1; /*!< [10..10] IBI Payload                                                      */
            __IOM uint32_t RBCR3  : 1; /*!< [11..11] Offline Capable                                                  */
            uint32_t              : 2;
            __IOM uint32_t RBCR76 : 2; /*!< [15..14] Device Role                                                      */
            uint32_t              : 16;
        } MSDCT3_b;
    };
    __IM uint32_t RESERVED25[16];

    union
    {
        __IOM uint32_t SVDCT;          /*!< (@ 0x00000320) Slave Device Characteristic Table Register                 */

        struct
        {
            __IOM uint32_t TDCR   : 8; /*!< [7..0] Transfar Device Characteristic Register                            */
            __IOM uint32_t TBCR0  : 1; /*!< [8..8] Max Data Speed Limitation                                          */
            __IOM uint32_t TBCR1  : 1; /*!< [9..9] IBI Request Capable                                                */
            __IOM uint32_t TBCR2  : 1; /*!< [10..10] IBI Payload                                                      */
            __IOM uint32_t TBCR3  : 1; /*!< [11..11] Offline Capable                                                  */
            uint32_t              : 2;
            __IOM uint32_t TBCR76 : 2; /*!< [15..14] Device Role                                                      */
            uint32_t              : 16;
        } SVDCT_b;
    };
    __IOM uint32_t SDCTPIDL;           /*!< (@ 0x00000324) Slave Device Characteristic Table Provisional
                                        *                  ID Low Register                                            */
    __IOM uint32_t SDCTPIDH;           /*!< (@ 0x00000328) Slave Device Characteristic Table Provisional
                                        *                  ID High Register                                           */
    __IM uint32_t RESERVED26;

    union
    {
        __IM uint32_t SVDVAD0;         /*!< (@ 0x00000330) Slave Device Address Register 0                            */

        struct
        {
            uint32_t             : 16;
            __IM uint32_t SVAD   : 10; /*!< [25..16] Slave Address                                                    */
            uint32_t             : 1;
            __IM uint32_t SADLG  : 1;  /*!< [27..27] Slave Address Length                                             */
            uint32_t             : 2;
            __IM uint32_t SSTADV : 1;  /*!< [30..30] Slave Static Address Valid                                       */
            __IM uint32_t SDYADV : 1;  /*!< [31..31] Slave Dynamic Address Valid                                      */
        } SVDVAD0_b;
    };
    __IM uint32_t RESERVED27[7];

    union
    {
        __IOM uint32_t CSECMD;         /*!< (@ 0x00000350) CCC Slave Events Command Register                          */

        struct
        {
            __IOM uint32_t SVIRQE : 1; /*!< [0..0] Slave Interrupt Requests Enable                                    */
            __IOM uint32_t MSRQE  : 1; /*!< [1..1] Mastership Requests Enable                                         */
            uint32_t              : 1;
            __IOM uint32_t HJEVE  : 1; /*!< [3..3] Hot-Join Event Enable                                              */
            uint32_t              : 28;
        } CSECMD_b;
    };

    union
    {
        __IOM uint32_t CEACTST;        /*!< (@ 0x00000354) CCC Enter Activity State Register                          */

        struct
        {
            __IOM uint32_t ACTST : 4;  /*!< [3..0] Activity State                                                     */
            uint32_t             : 28;
        } CEACTST_b;
    };

    union
    {
        __IOM uint32_t CMWLG;          /*!< (@ 0x00000358) CCC Max Write Length Register                              */

        struct
        {
            __IOM uint32_t MWLG : 16;  /*!< [15..0] Max Write Length                                                  */
            uint32_t            : 16;
        } CMWLG_b;
    };

    union
    {
        __IOM uint32_t CMRLG;           /*!< (@ 0x0000035C) CCC Max Read Length Register                               */

        struct
        {
            __IOM uint32_t MRLG   : 16; /*!< [15..0] Max Read Length                                                   */
            __IOM uint32_t IBIPSZ : 8;  /*!< [23..16] IBI Payload Size                                                 */
            uint32_t              : 8;
        } CMRLG_b;
    };

    union
    {
        __IM uint32_t CETSTMD;         /*!< (@ 0x00000360) CCC Enter Test Mode Register                               */

        struct
        {
            __IM uint32_t TSTMD : 8;   /*!< [7..0] Test Mode                                                          */
            uint32_t            : 24;
        } CETSTMD_b;
    };

    union
    {
        __IOM uint32_t CGDVST;         /*!< (@ 0x00000364) CCC Get Device Status Register                             */

        struct
        {
            __IOM uint32_t PNDINT : 4; /*!< [3..0] Pending Interrupt                                                  */
            uint32_t              : 1;
            __IOM uint32_t PRTE   : 1; /*!< [5..5] Protocol Error                                                     */
            __IOM uint32_t ACTMD  : 2; /*!< [7..6] Slave Device’s current Activity Mode                             */
            __IOM uint32_t VDRSV  : 8; /*!< [15..8] Vendor Reserved                                                   */
            uint32_t              : 16;
        } CGDVST_b;
    };

    union
    {
        __IOM uint32_t CMDSPW;         /*!< (@ 0x00000368) CCC Max Data Speed W (Write) Register                      */

        struct
        {
            __IOM uint32_t MSWDR : 3;  /*!< [2..0] Maximum Sustained Write Data Rate                                  */
            uint32_t             : 29;
        } CMDSPW_b;
    };

    union
    {
        __IOM uint32_t CMDSPR;         /*!< (@ 0x0000036C) CCC Max Data Speed R (Read) Register                       */

        struct
        {
            __IOM uint32_t MSRDR  : 3; /*!< [2..0] Maximum Sustained Read Data Rate                                   */
            __IOM uint32_t CDTTIM : 3; /*!< [5..3] Clock to Data Turnaround Time (TSCO)                               */
            uint32_t              : 26;
        } CMDSPR_b;
    };

    union
    {
        __IOM uint32_t CMDSPT;          /*!< (@ 0x00000370) CCC Max Data Speed T (Turnaround) Register                 */

        struct
        {
            __IOM uint32_t MRTTIM : 24; /*!< [23..0] Maximum Read Turnaround Time                                      */
            uint32_t              : 7;
            __IOM uint32_t MRTE   : 1;  /*!< [31..31] Maximum Read Turnaround Time Enable                              */
        } CMDSPT_b;
    };

    union
    {
        __IOM uint32_t CETSM;          /*!< (@ 0x00000374) CCC Exchange Timing Support Information M (Mode)
                                        *                  Register                                                   */

        struct
        {
            uint32_t            : 8;
            __IOM uint32_t FREQ : 8;   /*!< [15..8] Frequency Byte                                                    */
            __IOM uint32_t INAC : 8;   /*!< [23..16] Inaccuracy Byte                                                  */
            uint32_t            : 8;
        } CETSM_b;
    };
    __IM uint32_t RESERVED28[2];

    union
    {
        __IOM uint32_t BITCNT;         /*!< (@ 0x00000380) Bit Count Register                                         */

        struct
        {
            __IOM uint32_t BCNT  : 5;  /*!< [4..0] Bit Counter                                                        */
            uint32_t             : 2;
            __OM uint32_t BCNTWP : 1;  /*!< [7..7] BCNT Write Protect                                                 */
            uint32_t             : 24;
        } BITCNT_b;
    };
    __IM uint32_t RESERVED29[4];

    union
    {
        __IM uint32_t NQSTLV;          /*!< (@ 0x00000394) Normal Queue Status Level Register                         */

        struct
        {
            __IM uint32_t CMDQFLV : 8; /*!< [7..0] Normal Command Queue Free Level                                    */
            __IM uint32_t RSPQLV  : 8; /*!< [15..8] Normal Response Queue Level                                       */
            __IM uint32_t IBIQLV  : 8; /*!< [23..16] Normal IBI Queue Level                                           */
            __IM uint32_t IBISCNT : 5; /*!< [28..24] Normal IBI Status Count                                          */
            uint32_t              : 3;
        } NQSTLV_b;
    };

    union
    {
        __IM uint32_t NDBSTLV0;        /*!< (@ 0x00000398) Normal Data Buffer Status Level Register                   */

        struct
        {
            __IM uint32_t TDBFLV : 8;  /*!< [7..0] Normal Transmit Data Buffer Free Level                             */
            __IM uint32_t RDBLV  : 8;  /*!< [15..8] Normal Receive Data Buffer Level                                  */
            uint32_t             : 16;
        } NDBSTLV0_b;
    };
    __IM uint32_t RESERVED30[9];

    union
    {
        __IM uint32_t NRSQSTLV;        /*!< (@ 0x000003C0) Normal Receive Status Queue Status Level Register          */

        struct
        {
            __IM uint32_t RSQLV : 8;   /*!< [7..0] Normal Receive Status Queue Level                                  */
            uint32_t            : 24;
        } NRSQSTLV_b;
    };
    __IM uint32_t RESERVED31[2];

    union
    {
        __IM uint32_t PRSTDBG;         /*!< (@ 0x000003CC) Present State Debug Register                               */

        struct
        {
            __IM uint32_t SCILV : 1;   /*!< [0..0] SCL Line Signal Level                                              */
            __IM uint32_t SDILV : 1;   /*!< [1..1] SDA Line Signal Level                                              */
            __IM uint32_t SCOLV : 1;   /*!< [2..2] SCL Output Level                                                   */
            __IM uint32_t SDOLV : 1;   /*!< [3..3] SDA Output Level                                                   */
            uint32_t            : 28;
        } PRSTDBG_b;
    };

    union
    {
        __IM uint32_t MSERRCNT;        /*!< (@ 0x000003D0) Master Error Counters Register                             */

        struct
        {
            __IM uint32_t M2ECNT : 8;  /*!< [7..0] M2 Error Counter                                                   */
            uint32_t             : 24;
        } MSERRCNT_b;
    };
} R_I3C0_Type;                         /*!< Size = 980 (0x3d4)                                                        */

/* =========================================================================================================================== */
/* ================                                           R_MMF                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Memory Mirror Function (R_MMF)
 */

typedef struct                         /*!< (@ 0x40001000) R_MMF Structure                                            */
{
    union
    {
        __IOM uint32_t MMSFR;          /*!< (@ 0x00000000) MemMirror Special Function Register                        */

        struct
        {
            uint32_t                  : 7;
            __IOM uint32_t MEMMIRADDR : 16; /*!< [22..7] Specifies the memory mirror address.NOTE: A value cannot
                                             *   be set in the low-order 7 bits. These bits are fixed to
                                             *   0.                                                                        */
            uint32_t          : 1;
            __OM uint32_t KEY : 8;          /*!< [31..24] MMSFR Key Code                                                   */
        } MMSFR_b;
    };

    union
    {
        __IOM uint32_t MMEN;           /*!< (@ 0x00000004) MemMirror Enable Register                                  */

        struct
        {
            __IOM uint32_t EN : 1;     /*!< [0..0] Memory Mirror Function Enable                                      */
            uint32_t          : 23;
            __OM uint32_t KEY : 8;     /*!< [31..24] MMEN Key Code                                                    */
        } MMEN_b;
    };
} R_MMF_Type;                          /*!< Size = 8 (0x8)                                                            */

/* =========================================================================================================================== */
/* ================                                        R_MPU_MMPU                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Bus Master MPU (R_MPU_MMPU)
 */

typedef struct                          /*!< (@ 0x40000000) R_MPU_MMPU Structure                                       */
{
    __IOM R_MPU_MMPU_MMPU_Type MMPU[3]; /*!< (@ 0x00000000) Bus Master MPU Registers                                   */
} R_MPU_MMPU_Type;                      /*!< Size = 3072 (0xc00)                                                       */

/* =========================================================================================================================== */
/* ================                                        R_MPU_SMPU                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Bus Slave MPU (R_MPU_SMPU)
 */

typedef struct                           /*!< (@ 0x40000C00) R_MPU_SMPU Structure                                       */
{
    union
    {
        __IOM uint16_t SMPUCTL;          /*!< (@ 0x00000000) Slave MPU Control Register                                 */

        struct
        {
            __IOM uint16_t OAD     : 1;  /*!< [0..0] Master Group enable                                                */
            __IOM uint16_t PROTECT : 1;  /*!< [1..1] Protection of register                                             */
            uint16_t               : 6;
            __OM uint16_t KEY      : 8;  /*!< [15..8] Key Code This bit is used to enable or disable rewriting
                                          *   of the PROTECT and OAD bit.                                               */
        } SMPUCTL_b;
    };
    __IM uint16_t              RESERVED[7];
    __IOM R_MPU_SMPU_SMPU_Type SMPU[10]; /*!< (@ 0x00000010) Access Control Structure for MBIU                          */
} R_MPU_SMPU_Type;                       /*!< Size = 56 (0x38)                                                          */

/* =========================================================================================================================== */
/* ================                                        R_MPU_SPMON                                        ================ */
/* =========================================================================================================================== */

/**
 * @brief CPU Stack Pointer Monitor (R_MPU_SPMON)
 */

typedef struct                         /*!< (@ 0x40000D00) R_MPU_SPMON Structure                                      */
{
    __IOM R_MPU_SPMON_SP_Type SP[2];   /*!< (@ 0x00000000) Stack Pointer Monitor                                      */
} R_MPU_SPMON_Type;                    /*!< Size = 32 (0x20)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_MSTP                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief System-Module Stop (R_MSTP)
 */

typedef struct                          /*!< (@ 0x40047000) R_MSTP Structure                                           */
{
    union
    {
        __IOM uint32_t MSTPCRA;         /*!< (@ 0x00000000) Module Stop Control Register A                             */

        struct
        {
            __IOM uint32_t MSTPA0  : 1; /*!< [0..0] RAM0 Module Stop                                                   */
            uint32_t               : 6;
            __IOM uint32_t MSTPA7  : 1; /*!< [7..7] Standby RAM Module Stop                                            */
            uint32_t               : 14;
            __IOM uint32_t MSTPA22 : 1; /*!< [22..22] DMA Controller/Data Transfer Controller Module Stop              */
            uint32_t               : 9;
        } MSTPCRA_b;
    };

    union
    {
        __IOM uint32_t MSTPCRB;        /*!< (@ 0x00000004) Module Stop Control Register B                             */

        struct
        {
            uint32_t               : 1;
            __IOM uint32_t MSTPB1  : 1; /*!< [1..1] RCAN1 Module Stop                                                  */
            __IOM uint32_t MSTPB2  : 1; /*!< [2..2] RCAN0 Module Stop                                                  */
            __IOM uint32_t MSTPB3  : 1; /*!< [3..3] RCEC Module Stop                                                   */
            uint32_t               : 1;
            __IOM uint32_t MSTPB5  : 1; /*!< [5..5] IrDA Module Stop                                                   */
            __IOM uint32_t MSTPB6  : 1; /*!< [6..6] Queued Serial Peripheral Interface Module Stop                     */
            __IOM uint32_t MSTPB7  : 1; /*!< [7..7] I2C Bus Interface 2 Module Stop                                    */
            __IOM uint32_t MSTPB8  : 1; /*!< [8..8] I2C Bus Interface 1 Module Stop                                    */
            __IOM uint32_t MSTPB9  : 1; /*!< [9..9] IIC/I3C Bus Interface 0 Module Stop                                */
            uint32_t               : 1;
            __IOM uint32_t MSTPB11 : 1; /*!< [11..11] Universal Serial Bus 2.0 FS Interface Module Stop                */
            __IOM uint32_t MSTPB12 : 1; /*!< [12..12] Universal Serial Bus 2.0 HS Interface Module Stop                */
            __IOM uint32_t MSTPB13 : 1; /*!< [13..13] EPTPC and PTPEDMAC Module Stop                                   */
            __IOM uint32_t MSTPB14 : 1; /*!< [14..14] ETHERC1 and EDMAC1 Module Stop                                   */
            __IOM uint32_t MSTPB15 : 1; /*!< [15..15] ETHERC0 and EDMAC0 Module Stop                                   */
            uint32_t               : 2;
            __IOM uint32_t MSTPB18 : 1; /*!< [18..18] Serial Peripheral Interface Module Stop                          */
            __IOM uint32_t MSTPB19 : 1; /*!< [19..19] Serial Peripheral Interface 0 Module Stop                        */
            uint32_t               : 2;
            __IOM uint32_t MSTPB22 : 1; /*!< [22..22] Serial Communication Interface 9 Module Stop                     */
            __IOM uint32_t MSTPB23 : 1; /*!< [23..23] Serial Communication Interface 8 Module Stop                     */
            __IOM uint32_t MSTPB24 : 1; /*!< [24..24] Serial Communication Interface 7 Module Stop                     */
            __IOM uint32_t MSTPB25 : 1; /*!< [25..25] Serial Communication Interface 6 Module Stop                     */
            __IOM uint32_t MSTPB26 : 1; /*!< [26..26] Serial Communication Interface 5 Module Stop                     */
            __IOM uint32_t MSTPB27 : 1; /*!< [27..27] Serial Communication Interface 4 Module Stop                     */
            __IOM uint32_t MSTPB28 : 1; /*!< [28..28] Serial Communication Interface 3 Module Stop                     */
            __IOM uint32_t MSTPB29 : 1; /*!< [29..29] Serial Communication Interface 2 Module Stop                     */
            __IOM uint32_t MSTPB30 : 1; /*!< [30..30] Serial Communication Interface 1 Module Stop                     */
            __IOM uint32_t MSTPB31 : 1; /*!< [31..31] Serial Communication Interface 0 Module Stop                     */
        } MSTPCRB_b;
    };

    union
    {
        __IOM uint32_t MSTPCRC;         /*!< (@ 0x00000008) Module Stop Control Register C                             */

        struct
        {
            __IOM uint32_t MSTPC0  : 1; /*!< [0..0] CAC Module Stop                                                    */
            __IOM uint32_t MSTPC1  : 1; /*!< [1..1] CRC Calculator Module Stop                                         */
            __IOM uint32_t MSTPC2  : 1; /*!< [2..2] Parallel Data Capture Module Stop                                  */
            __IOM uint32_t MSTPC3  : 1; /*!< [3..3] Capacitive Touch Sensing Unit Module Stop                          */
            __IOM uint32_t MSTPC4  : 1; /*!< [4..4] Segment LCD Controller Module Stop                                 */
            __IOM uint32_t MSTPC5  : 1; /*!< [5..5] JPEG codec engine Module Stop                                      */
            __IOM uint32_t MSTPC6  : 1; /*!< [6..6] 2DG engine Module Stop                                             */
            __IOM uint32_t MSTPC7  : 1; /*!< [7..7] Synchronous Serial Interface 1 Module Stop                         */
            __IOM uint32_t MSTPC8  : 1; /*!< [8..8] Synchronous Serial Interface 0 Module Stop                         */
            __IOM uint32_t MSTPC9  : 1; /*!< [9..9] Sampling Rate Converter Module Stop                                */
            uint32_t               : 1;
            __IOM uint32_t MSTPC11 : 1; /*!< [11..11] Secure Digital Host IF/ Multi Media Card 1 Module Stop           */
            __IOM uint32_t MSTPC12 : 1; /*!< [12..12] Secure Digital Host IF/ Multi Media Card 0 Module Stop           */
            __IOM uint32_t MSTPC13 : 1; /*!< [13..13] Data Operation Circuit Module Stop                               */
            __IOM uint32_t MSTPC14 : 1; /*!< [14..14] Event Link Controller Module Stop                                */
            uint32_t               : 5;
            __IOM uint32_t MSTPC20 : 1; /*!< [20..20] Trigonometric Function Unit Module Stop                          */
            __IOM uint32_t MSTPC21 : 1; /*!< [21..21] IIR Filter Accelerator Module Stop                               */
            uint32_t               : 5;
            __IOM uint32_t MSTPC27 : 1; /*!< [27..27] CANFD Module Stop                                                */
            __IOM uint32_t MSTPC28 : 1; /*!< [28..28] Random Number Generator Module Stop                              */
            uint32_t               : 2;
            __IOM uint32_t MSTPC31 : 1; /*!< [31..31] AES Module Stop                                                  */
        } MSTPCRC_b;
    };

    union
    {
        __IOM uint32_t MSTPCRD;         /*!< (@ 0x0000000C) Module Stop Control Register D                             */

        struct
        {
            __IOM uint32_t MSTPD0 : 1;  /*!< [0..0] Low Power Asynchronous General Purpose Timer 3 Module
                                         *   Stop                                                                      */
            __IOM uint32_t MSTPD1 : 1;  /*!< [1..1] Low Power Asynchronous General Purpose Timer 2 Module
                                         *   Stop                                                                      */
            __IOM uint32_t MSTPD2 : 1;  /*!< [2..2] AGT1 Module StopNote: AGT1 is in the module stop state
                                         *   when the count source is either of PCLKB, PCLKB/2 or PCLKB/8.
                                         *   In case the count source is sub-clock or LOCO, this bit
                                         *   should be set to 1 except when accessing the registers
                                         *   of AGT1.                                                                  */
            __IOM uint32_t MSTPD3 : 1;  /*!< [3..3] AGT0 Module StopNote: AGT0 is in the module stop state
                                         *   when the count source is either of PCLKB, PCLKB/2 or PCLKB/8.
                                         *   In case the count source is sub-clock or LOCO, this bit
                                         *   should be set to 1 except when accessing the registers
                                         *   of AGT0.                                                                  */
            uint32_t               : 1;
            __IOM uint32_t MSTPD5  : 1; /*!< [5..5] GPT Lower Module Stop                                              */
            __IOM uint32_t MSTPD6  : 1; /*!< [6..6] GPT Higher Module Stop                                             */
            uint32_t               : 4;
            __IOM uint32_t MSTPD11 : 1; /*!< [11..11] Port Output Enable for GPT 3 Module Stop                         */
            __IOM uint32_t MSTPD12 : 1; /*!< [12..12] Port Output Enable for GPT 2 Module Stop                         */
            __IOM uint32_t MSTPD13 : 1; /*!< [13..13] Port Output Enable for GPT 1 Module Stop                         */
            __IOM uint32_t MSTPD14 : 1; /*!< [14..14] POEG Module Stop                                                 */
            __IOM uint32_t MSTPD15 : 1; /*!< [15..15] 12-Bit A/D Converter 1 Module Stop                               */
            __IOM uint32_t MSTPD16 : 1; /*!< [16..16] 16-Bit A/D Converter Module Stop                                 */
            __IOM uint32_t MSTPD17 : 1; /*!< [17..17] 24-bit Sigma-Delta A/DConverter Module Stop                      */
            uint32_t               : 1;
            __IOM uint32_t MSTPD19 : 1; /*!< [19..19] 8-Bit D/A Converter Module Stop                                  */
            __IOM uint32_t MSTPD20 : 1; /*!< [20..20] 12-bit D/A Converter Module Stop                                 */
            uint32_t               : 1;
            __IOM uint32_t MSTPD22 : 1; /*!< [22..22] Temperature Sensor Module Stop                                   */
            __IOM uint32_t MSTPD23 : 1; /*!< [23..23] ACMPHS5 Module Stop                                              */
            __IOM uint32_t MSTPD24 : 1; /*!< [24..24] ACMPHS4 Module Stop                                              */
            __IOM uint32_t MSTPD25 : 1; /*!< [25..25] ACMPHS3 Module Stop                                              */
            __IOM uint32_t MSTPD26 : 1; /*!< [26..26] ACMPHS2 Module Stop                                              */
            __IOM uint32_t MSTPD27 : 1; /*!< [27..27] ACMPHS1 Module Stop                                              */
            __IOM uint32_t MSTPD28 : 1; /*!< [28..28] ACMPHS0 Module Stop                                              */
            __IOM uint32_t MSTPD29 : 1; /*!< [29..29] Comparator-LP Module Stop                                        */
            uint32_t               : 1;
            __IOM uint32_t MSTPD31 : 1; /*!< [31..31] Operational Amplifier Module Stop                                */
        } MSTPCRD_b;
    };

    union
    {
        __IOM uint32_t MSTPCRE;        /*!< (@ 0x00000010) Module Stop Control Register E                             */

        struct
        {
            uint32_t               : 4;
            __IOM uint32_t MSTPE4  : 1; /*!< [4..4] KINT Module Stop                                                   */
            uint32_t               : 9;
            __IOM uint32_t MSTPE14 : 1; /*!< [14..14] Low Power Asynchronous General Purpose Timer 5 Module
                                         *   Stop                                                                      */
            __IOM uint32_t MSTPE15 : 1; /*!< [15..15] Low Power Asynchronous General Purpose Timer 4 Module
                                         *   Stop                                                                      */
            uint32_t               : 6;
            __IOM uint32_t MSTPE22 : 1; /*!< [22..22] GPT9 Module Stop                                                 */
            __IOM uint32_t MSTPE23 : 1; /*!< [23..23] GPT8 Module Stop                                                 */
            __IOM uint32_t MSTPE24 : 1; /*!< [24..24] GPT7 Module Stop                                                 */
            __IOM uint32_t MSTPE25 : 1; /*!< [25..25] GPT6 Module Stop                                                 */
            __IOM uint32_t MSTPE26 : 1; /*!< [26..26] GPT5 Module Stop                                                 */
            __IOM uint32_t MSTPE27 : 1; /*!< [27..27] GPT4 Module Stop                                                 */
            __IOM uint32_t MSTPE28 : 1; /*!< [28..28] GPT3 Module Stop                                                 */
            __IOM uint32_t MSTPE29 : 1; /*!< [29..29] GPT2 Module Stop                                                 */
            __IOM uint32_t MSTPE30 : 1; /*!< [30..30] GPT1 Module Stop                                                 */
            __IOM uint32_t MSTPE31 : 1; /*!< [31..31] GPT0 Module Stop                                                 */
        } MSTPCRE_b;
    };
} R_MSTP_Type;                          /*!< Size = 20 (0x14)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_OPAMP                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Operational Amplifier (R_OPAMP)
 */

typedef struct                         /*!< (@ 0x40086000) R_OPAMP Structure                                          */
{
    __IM uint8_t RESERVED[8];

    union
    {
        __IOM uint8_t AMPMC;           /*!< (@ 0x00000008) Operational amplifier mode control register                */

        struct
        {
            __IOM uint8_t AMPPC0 : 1;  /*!< [0..0] Operational amplifier precharge control status                     */
            __IOM uint8_t AMPPC1 : 1;  /*!< [1..1] Operational amplifier precharge control status                     */
            __IOM uint8_t AMPPC2 : 1;  /*!< [2..2] Operational amplifier precharge control status                     */
            uint8_t              : 4;
            __IOM uint8_t AMPSP  : 1;  /*!< [7..7] Operation mode selection                                           */
        } AMPMC_b;
    };

    union
    {
        __IOM uint8_t AMPTRM;          /*!< (@ 0x00000009) Operational amplifier trigger mode control register        */

        struct
        {
            __IOM uint8_t AMPTRM0 : 2; /*!< [1..0] Operational amplifier function activation/stop trigger
                                        *   control                                                                   */
            __IOM uint8_t AMPTRM1 : 2; /*!< [3..2] Operational amplifier function activation/stop trigger
                                        *   control                                                                   */
            __IOM uint8_t AMPTRM2 : 2; /*!< [5..4] Operational amplifier function activation/stop trigger
                                        *   control                                                                   */
            __IOM uint8_t AMPTRM3 : 2; /*!< [7..6] Operational amplifier function activation/stop trigger
                                        *   control                                                                   */
        } AMPTRM_b;
    };

    union
    {
        __IOM uint8_t AMPTRS;          /*!< (@ 0x0000000A) Operational Amplifier Activation Trigger Select
                                        *                  Register                                                   */

        struct
        {
            __IOM uint8_t AMPTRS : 2;  /*!< [1..0] ELC trigger selection Do not change the value of the
                                        *   AMPTRS register after setting the AMPTRM register.                        */
            uint8_t : 6;
        } AMPTRS_b;
    };

    union
    {
        __IOM uint8_t AMPC;            /*!< (@ 0x0000000B) Operational amplifier control register                     */

        struct
        {
            __IOM uint8_t AMPE0 : 1;   /*!< [0..0] Operation control of operational amplifier                         */
            __IOM uint8_t AMPE1 : 1;   /*!< [1..1] Operation control of operational amplifier                         */
            __IOM uint8_t AMPE2 : 1;   /*!< [2..2] Operation control of operational amplifier                         */
            __IOM uint8_t AMPE3 : 1;   /*!< [3..3] Operation control of operational amplifier                         */
            uint8_t             : 3;
            __IOM uint8_t IREFE : 1;   /*!< [7..7] Operation control of operational amplifier reference
                                        *   current circuit                                                           */
        } AMPC_b;
    };

    union
    {
        __IM uint8_t AMPMON;           /*!< (@ 0x0000000C) Operational amplifier monitor register                     */

        struct
        {
            __IM uint8_t AMPMON0 : 1;  /*!< [0..0] Operational amplifier status                                       */
            __IM uint8_t AMPMON1 : 1;  /*!< [1..1] Operational amplifier status                                       */
            __IM uint8_t AMPMON2 : 1;  /*!< [2..2] Operational amplifier status                                       */
            __IM uint8_t AMPMON3 : 1;  /*!< [3..3] Operational amplifier status                                       */
            uint8_t              : 4;
        } AMPMON_b;
    };
    __IM uint8_t           RESERVED1;
    __IOM R_OPAMP_AMP_Type AMP[4];     /*!< (@ 0x0000000E) Input and Output Selectors for Operational Amplifier
                                        *                  [0..3]                                                     */

    union
    {
        __IOM uint8_t AMPCPC;          /*!< (@ 0x0000001A) Operational amplifier switch charge pump control
                                        *                  register                                                   */

        struct
        {
            __IOM uint8_t PUMP0EN : 1; /*!< [0..0] charge pump for AMP0 enable/disable                                */
            __IOM uint8_t PUMP1EN : 1; /*!< [1..1] charge pump for AMP1 enable/disable                                */
            __IOM uint8_t PUMP2EN : 1; /*!< [2..2] charge pump for AMP2 enable/disable                                */
            uint8_t               : 5;
        } AMPCPC_b;
    };
    __IM uint8_t RESERVED2[4];

    union
    {
        __IOM uint8_t AMPUOTE;         /*!< (@ 0x0000001F) Operational Amplifier User Offset Trimming Enable
                                        *                  Register                                                   */

        struct
        {
            __IOM uint8_t AMP0TE : 1;  /*!< [0..0] AMP0OT write enable                                                */
            __IOM uint8_t AMP1TE : 1;  /*!< [1..1] AMP1OT write enable                                                */
            __IOM uint8_t AMP2TE : 1;  /*!< [2..2] AMP2OT write enable                                                */
            uint8_t              : 5;
        } AMPUOTE_b;
    };
    __IOM R_OPAMP_AMPOT_Type AMPOT[3]; /*!< (@ 0x00000020) Operational Amplifier n Offset Trimming Registers          */
} R_OPAMP_Type;                        /*!< Size = 38 (0x26)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_PDC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Parallel Data Capture Unit (R_PDC)
 */

typedef struct                         /*!< (@ 0x40094000) R_PDC Structure                                            */
{
    union
    {
        __IOM uint32_t PCCR0;          /*!< (@ 0x00000000) PDC Control Register 0                                     */

        struct
        {
            __IOM uint32_t PCKE   : 1; /*!< [0..0] Channel 0 GTCNT Count Clear                                        */
            __IOM uint32_t VPS    : 1; /*!< [1..1] VSYNC Signal Polarity Select                                       */
            __IOM uint32_t HPS    : 1; /*!< [2..2] HSYNC Signal Polarity Select                                       */
            __OM uint32_t  PRST   : 1; /*!< [3..3] PDC Reset                                                          */
            __IOM uint32_t DFIE   : 1; /*!< [4..4] Receive Data Ready Interrupt Enable                                */
            __IOM uint32_t FEIE   : 1; /*!< [5..5] Frame End Interrupt Enable                                         */
            __IOM uint32_t OVIE   : 1; /*!< [6..6] Overrun Interrupt Enable                                           */
            __IOM uint32_t UDRIE  : 1; /*!< [7..7] Underrun Interrupt Enable                                          */
            __IOM uint32_t VERIE  : 1; /*!< [8..8] Vertical Line Number Setting Error Interrupt Enable                */
            __IOM uint32_t HERIE  : 1; /*!< [9..9] Horizontal Byte Number Setting Error Interrupt Enable              */
            __IOM uint32_t PCKOE  : 1; /*!< [10..10] PCKO Output Enable                                               */
            __IOM uint32_t PCKDIV : 3; /*!< [13..11] PCKO Frequency Division Ratio Select                             */
            __IOM uint32_t EDS    : 1; /*!< [14..14] Endian Select                                                    */
            uint32_t              : 17;
        } PCCR0_b;
    };

    union
    {
        __IOM uint32_t PCCR1;          /*!< (@ 0x00000004) PDC Control Register 1                                     */

        struct
        {
            __IOM uint32_t PCE : 1;    /*!< [0..0] PDC Operation Enable                                               */
            uint32_t           : 31;
        } PCCR1_b;
    };

    union
    {
        __IOM uint32_t PCSR;           /*!< (@ 0x00000008) PDC Status Register                                        */

        struct
        {
            __IM uint32_t  FBSY  : 1;  /*!< [0..0] Frame Busy Flag                                                    */
            __IM uint32_t  FEMPF : 1;  /*!< [1..1] FIFO Empty Flag                                                    */
            __IOM uint32_t FEF   : 1;  /*!< [2..2] Frame End Flag                                                     */
            __IOM uint32_t OVRF  : 1;  /*!< [3..3] Overrun Flag                                                       */
            __IOM uint32_t UDRF  : 1;  /*!< [4..4] Underrun Flag                                                      */
            __IOM uint32_t VERF  : 1;  /*!< [5..5] Vertical Line Number Setting Error Flag                            */
            __IOM uint32_t HERF  : 1;  /*!< [6..6] Horizontal Byte Number Setting Error Flag                          */
            uint32_t             : 25;
        } PCSR_b;
    };

    union
    {
        __IM uint32_t PCMONR;          /*!< (@ 0x0000000C) PDC Pin Monitor Register                                   */

        struct
        {
            __IM uint32_t VSYNC : 1;   /*!< [0..0] VSYNC Signal Status Flag                                           */
            __IM uint32_t HSYNC : 1;   /*!< [1..1] HSYNC Signal Status Flag                                           */
            uint32_t            : 30;
        } PCMONR_b;
    };

    union
    {
        __IM uint32_t PCDR;            /*!< (@ 0x00000010) PDC Receive Data Register                                  */

        struct
        {
            __IM uint32_t PCDR : 32;   /*!< [31..0] The PDC includes a 32-bit-wide, 22-stage FIFO for the
                                        *   storage of captured data. The PCDR register is a 4-byte
                                        *   space to which the FIFO is mapped, and four bytes of data
                                        *   are read from the PCDR register at a time.                                */
        } PCDR_b;
    };

    union
    {
        __IOM uint32_t VCR;            /*!< (@ 0x00000014) Vertical Capture Register                                  */

        struct
        {
            __IOM uint32_t VST : 12;   /*!< [11..0] Vertical Capture Start Line PositionNumber of the line
                                        *   where capture is to start.                                                */
            uint32_t           : 4;
            __IOM uint32_t VSZ : 12;   /*!< [27..16] Vertical Capture Size Number of lines to be captured.            */
            uint32_t           : 4;
        } VCR_b;
    };

    union
    {
        __IOM uint32_t HCR;            /*!< (@ 0x00000018) Horizontal Capture Register                                */

        struct
        {
            __IOM uint32_t HST : 12;   /*!< [11..0] Horizontal Capture Start Byte Position Horizontal position
                                        *   in bytes where capture is to start.                                       */
            uint32_t           : 4;
            __IOM uint32_t HSZ : 12;   /*!< [27..16] Horizontal Capture Size Number of bytes to capture
                                        *   horizontally.                                                             */
            uint32_t : 4;
        } HCR_b;
    };
} R_PDC_Type;                          /*!< Size = 28 (0x1c)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_PORT0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief I/O Ports (R_PORT0)
 */

 #ifndef BSP_OVERRIDE_REG_R_PORT0_TYPE

typedef struct                         /*!< (@ 0x40040000) R_PORT0 Structure                                          */
{
    union
    {
        union
        {
            __IOM uint32_t PCNTR1;        /*!< (@ 0x00000000) Port Control Register 1                                    */

            struct
            {
                __IOM uint32_t PDR  : 16; /*!< [15..0] Pmn Direction                                                     */
                __IOM uint32_t PODR : 16; /*!< [31..16] Pmn Output Data                                                  */
            } PCNTR1_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t PODR;           /*!< (@ 0x00000000) Output data register                                       */

                struct
                {
                    __IOM uint16_t PODR0  : 1; /*!< [0..0] Pmn Output Data                                                    */
                    __IOM uint16_t PODR1  : 1; /*!< [1..1] Pmn Output Data                                                    */
                    __IOM uint16_t PODR2  : 1; /*!< [2..2] Pmn Output Data                                                    */
                    __IOM uint16_t PODR3  : 1; /*!< [3..3] Pmn Output Data                                                    */
                    __IOM uint16_t PODR4  : 1; /*!< [4..4] Pmn Output Data                                                    */
                    __IOM uint16_t PODR5  : 1; /*!< [5..5] Pmn Output Data                                                    */
                    __IOM uint16_t PODR6  : 1; /*!< [6..6] Pmn Output Data                                                    */
                    __IOM uint16_t PODR7  : 1; /*!< [7..7] Pmn Output Data                                                    */
                    __IOM uint16_t PODR8  : 1; /*!< [8..8] Pmn Output Data                                                    */
                    __IOM uint16_t PODR9  : 1; /*!< [9..9] Pmn Output Data                                                    */
                    __IOM uint16_t PODR10 : 1; /*!< [10..10] Pmn Output Data                                                  */
                    __IOM uint16_t PODR11 : 1; /*!< [11..11] Pmn Output Data                                                  */
                    __IOM uint16_t PODR12 : 1; /*!< [12..12] Pmn Output Data                                                  */
                    __IOM uint16_t PODR13 : 1; /*!< [13..13] Pmn Output Data                                                  */
                    __IOM uint16_t PODR14 : 1; /*!< [14..14] Pmn Output Data                                                  */
                    __IOM uint16_t PODR15 : 1; /*!< [15..15] Pmn Output Data                                                  */
                } PODR_b;
            };

            union
            {
                __IOM uint16_t PDR;           /*!< (@ 0x00000002) Data direction register                                    */

                struct
                {
                    __IOM uint16_t PDR0  : 1; /*!< [0..0] Pmn Direction                                                      */
                    __IOM uint16_t PDR1  : 1; /*!< [1..1] Pmn Direction                                                      */
                    __IOM uint16_t PDR2  : 1; /*!< [2..2] Pmn Direction                                                      */
                    __IOM uint16_t PDR3  : 1; /*!< [3..3] Pmn Direction                                                      */
                    __IOM uint16_t PDR4  : 1; /*!< [4..4] Pmn Direction                                                      */
                    __IOM uint16_t PDR5  : 1; /*!< [5..5] Pmn Direction                                                      */
                    __IOM uint16_t PDR6  : 1; /*!< [6..6] Pmn Direction                                                      */
                    __IOM uint16_t PDR7  : 1; /*!< [7..7] Pmn Direction                                                      */
                    __IOM uint16_t PDR8  : 1; /*!< [8..8] Pmn Direction                                                      */
                    __IOM uint16_t PDR9  : 1; /*!< [9..9] Pmn Direction                                                      */
                    __IOM uint16_t PDR10 : 1; /*!< [10..10] Pmn Direction                                                    */
                    __IOM uint16_t PDR11 : 1; /*!< [11..11] Pmn Direction                                                    */
                    __IOM uint16_t PDR12 : 1; /*!< [12..12] Pmn Direction                                                    */
                    __IOM uint16_t PDR13 : 1; /*!< [13..13] Pmn Direction                                                    */
                    __IOM uint16_t PDR14 : 1; /*!< [14..14] Pmn Direction                                                    */
                    __IOM uint16_t PDR15 : 1; /*!< [15..15] Pmn Direction                                                    */
                } PDR_b;
            };
        };
    };

    union
    {
        union
        {
            __IM uint32_t PCNTR2;        /*!< (@ 0x00000004) Port Control Register 2                                    */

            struct
            {
                __IM uint32_t PIDR : 16; /*!< [15..0] Pmn Input Data                                                    */
                __IM uint32_t EIDR : 16; /*!< [31..16] Pmn Event Input Data                                             */
            } PCNTR2_b;
        };

        struct
        {
            union
            {
                __IM uint16_t EIDR;           /*!< (@ 0x00000004) Event input data register                                  */

                struct
                {
                    __IM uint16_t EIDR0  : 1; /*!< [0..0] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR1  : 1; /*!< [1..1] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR2  : 1; /*!< [2..2] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR3  : 1; /*!< [3..3] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR4  : 1; /*!< [4..4] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR5  : 1; /*!< [5..5] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR6  : 1; /*!< [6..6] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR7  : 1; /*!< [7..7] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR8  : 1; /*!< [8..8] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR9  : 1; /*!< [9..9] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR10 : 1; /*!< [10..10] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR11 : 1; /*!< [11..11] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR12 : 1; /*!< [12..12] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR13 : 1; /*!< [13..13] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR14 : 1; /*!< [14..14] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR15 : 1; /*!< [15..15] Pmn Event Input Data                                             */
                } EIDR_b;
            };

            union
            {
                __IM uint16_t PIDR;           /*!< (@ 0x00000006) Input data register                                        */

                struct
                {
                    __IM uint16_t PIDR0  : 1; /*!< [0..0] Pmn Input Data                                                     */
                    __IM uint16_t PIDR1  : 1; /*!< [1..1] Pmn Input Data                                                     */
                    __IM uint16_t PIDR2  : 1; /*!< [2..2] Pmn Input Data                                                     */
                    __IM uint16_t PIDR3  : 1; /*!< [3..3] Pmn Input Data                                                     */
                    __IM uint16_t PIDR4  : 1; /*!< [4..4] Pmn Input Data                                                     */
                    __IM uint16_t PIDR5  : 1; /*!< [5..5] Pmn Input Data                                                     */
                    __IM uint16_t PIDR6  : 1; /*!< [6..6] Pmn Input Data                                                     */
                    __IM uint16_t PIDR7  : 1; /*!< [7..7] Pmn Input Data                                                     */
                    __IM uint16_t PIDR8  : 1; /*!< [8..8] Pmn Input Data                                                     */
                    __IM uint16_t PIDR9  : 1; /*!< [9..9] Pmn Input Data                                                     */
                    __IM uint16_t PIDR10 : 1; /*!< [10..10] Pmn Input Data                                                   */
                    __IM uint16_t PIDR11 : 1; /*!< [11..11] Pmn Input Data                                                   */
                    __IM uint16_t PIDR12 : 1; /*!< [12..12] Pmn Input Data                                                   */
                    __IM uint16_t PIDR13 : 1; /*!< [13..13] Pmn Input Data                                                   */
                    __IM uint16_t PIDR14 : 1; /*!< [14..14] Pmn Input Data                                                   */
                    __IM uint16_t PIDR15 : 1; /*!< [15..15] Pmn Input Data                                                   */
                } PIDR_b;
            };
        };
    };

    union
    {
        union
        {
            __OM uint32_t PCNTR3;        /*!< (@ 0x00000008) Port Control Register 3                                    */

            struct
            {
                __OM uint32_t POSR : 16; /*!< [15..0] Pmn Output Set                                                    */
                __OM uint32_t PORR : 16; /*!< [31..16] Pmn Output Reset                                                 */
            } PCNTR3_b;
        };

        struct
        {
            union
            {
                __OM uint16_t PORR;           /*!< (@ 0x00000008) Output set register                                        */

                struct
                {
                    __OM uint16_t PORR0  : 1; /*!< [0..0] Pmn Output Reset                                                   */
                    __OM uint16_t PORR1  : 1; /*!< [1..1] Pmn Output Reset                                                   */
                    __OM uint16_t PORR2  : 1; /*!< [2..2] Pmn Output Reset                                                   */
                    __OM uint16_t PORR3  : 1; /*!< [3..3] Pmn Output Reset                                                   */
                    __OM uint16_t PORR4  : 1; /*!< [4..4] Pmn Output Reset                                                   */
                    __OM uint16_t PORR5  : 1; /*!< [5..5] Pmn Output Reset                                                   */
                    __OM uint16_t PORR6  : 1; /*!< [6..6] Pmn Output Reset                                                   */
                    __OM uint16_t PORR7  : 1; /*!< [7..7] Pmn Output Reset                                                   */
                    __OM uint16_t PORR8  : 1; /*!< [8..8] Pmn Output Reset                                                   */
                    __OM uint16_t PORR9  : 1; /*!< [9..9] Pmn Output Reset                                                   */
                    __OM uint16_t PORR10 : 1; /*!< [10..10] Pmn Output Reset                                                 */
                    __OM uint16_t PORR11 : 1; /*!< [11..11] Pmn Output Reset                                                 */
                    __OM uint16_t PORR12 : 1; /*!< [12..12] Pmn Output Reset                                                 */
                    __OM uint16_t PORR13 : 1; /*!< [13..13] Pmn Output Reset                                                 */
                    __OM uint16_t PORR14 : 1; /*!< [14..14] Pmn Output Reset                                                 */
                    __OM uint16_t PORR15 : 1; /*!< [15..15] Pmn Output Reset                                                 */
                } PORR_b;
            };

            union
            {
                __OM uint16_t POSR;           /*!< (@ 0x0000000A) Output reset register                                      */

                struct
                {
                    __OM uint16_t POSR0  : 1; /*!< [0..0] Pmn Output Set                                                     */
                    __OM uint16_t POSR1  : 1; /*!< [1..1] Pmn Output Set                                                     */
                    __OM uint16_t POSR2  : 1; /*!< [2..2] Pmn Output Set                                                     */
                    __OM uint16_t POSR3  : 1; /*!< [3..3] Pmn Output Set                                                     */
                    __OM uint16_t POSR4  : 1; /*!< [4..4] Pmn Output Set                                                     */
                    __OM uint16_t POSR5  : 1; /*!< [5..5] Pmn Output Set                                                     */
                    __OM uint16_t POSR6  : 1; /*!< [6..6] Pmn Output Set                                                     */
                    __OM uint16_t POSR7  : 1; /*!< [7..7] Pmn Output Set                                                     */
                    __OM uint16_t POSR8  : 1; /*!< [8..8] Pmn Output Set                                                     */
                    __OM uint16_t POSR9  : 1; /*!< [9..9] Pmn Output Set                                                     */
                    __OM uint16_t POSR10 : 1; /*!< [10..10] Pmn Output Set                                                   */
                    __OM uint16_t POSR11 : 1; /*!< [11..11] Pmn Output Set                                                   */
                    __OM uint16_t POSR12 : 1; /*!< [12..12] Pmn Output Set                                                   */
                    __OM uint16_t POSR13 : 1; /*!< [13..13] Pmn Output Set                                                   */
                    __OM uint16_t POSR14 : 1; /*!< [14..14] Pmn Output Set                                                   */
                    __OM uint16_t POSR15 : 1; /*!< [15..15] Pmn Output Set                                                   */
                } POSR_b;
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t PCNTR4;        /*!< (@ 0x0000000C) Port Control Register 4                                    */

            struct
            {
                __IOM uint32_t EOSR : 16; /*!< [15..0] Pmn Event Output Set                                              */
                __IOM uint32_t EORR : 16; /*!< [31..16] Pmn Event Output Reset                                           */
            } PCNTR4_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t EORR;           /*!< (@ 0x0000000C) Event output set register                                  */

                struct
                {
                    __IOM uint16_t EORR0  : 1; /*!< [0..0] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR1  : 1; /*!< [1..1] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR2  : 1; /*!< [2..2] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR3  : 1; /*!< [3..3] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR4  : 1; /*!< [4..4] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR5  : 1; /*!< [5..5] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR6  : 1; /*!< [6..6] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR7  : 1; /*!< [7..7] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR8  : 1; /*!< [8..8] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR9  : 1; /*!< [9..9] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR10 : 1; /*!< [10..10] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR11 : 1; /*!< [11..11] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR12 : 1; /*!< [12..12] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR13 : 1; /*!< [13..13] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR14 : 1; /*!< [14..14] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR15 : 1; /*!< [15..15] Pmn Event Output Reset                                           */
                } EORR_b;
            };

            union
            {
                __IOM uint16_t EOSR;           /*!< (@ 0x0000000E) Event output reset register                                */

                struct
                {
                    __IOM uint16_t EOSR0  : 1; /*!< [0..0] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR1  : 1; /*!< [1..1] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR2  : 1; /*!< [2..2] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR3  : 1; /*!< [3..3] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR4  : 1; /*!< [4..4] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR5  : 1; /*!< [5..5] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR6  : 1; /*!< [6..6] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR7  : 1; /*!< [7..7] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR8  : 1; /*!< [8..8] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR9  : 1; /*!< [9..9] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR10 : 1; /*!< [10..10] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR11 : 1; /*!< [11..11] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR12 : 1; /*!< [12..12] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR13 : 1; /*!< [13..13] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR14 : 1; /*!< [14..14] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR15 : 1; /*!< [15..15] Pmn Event Output Set                                             */
                } EOSR_b;
            };
        };
    };
} R_PORT0_Type;                        /*!< Size = 16 (0x10)                                                          */

 #endif

/* =========================================================================================================================== */
/* ================                                           R_PFS                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief I/O Ports-PFS (R_PFS)
 */

typedef struct                         /*!< (@ 0x40040800) R_PFS Structure                                            */
{
    __IOM R_PFS_PORT_Type PORT[15];    /*!< (@ 0x00000000) Port [0..14]                                               */
} R_PFS_Type;                          /*!< Size = 960 (0x3c0)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_PMISC                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief I/O Ports-MISC (R_PMISC)
 */

 #ifndef BSP_OVERRIDE_REG_R_PMISC_TYPE

typedef struct                         /*!< (@ 0x40040D00) R_PMISC Structure                                          */
{
    union
    {
        __IOM uint8_t PFENET;          /*!< (@ 0x00000000) Ethernet Control Register                                  */

        struct
        {
            uint8_t                : 4;
            __IOM uint8_t PHYMODE0 : 1; /*!< [4..4] Ethernet Mode Setting ch0                                          */
            __IOM uint8_t PHYMODE1 : 1; /*!< [5..5] Ethernet Mode Setting ch1                                          */
            uint8_t                : 2;
        } PFENET_b;
    };
    __IM uint8_t RESERVED[2];

    union
    {
        __IOM uint8_t PWPR;            /*!< (@ 0x00000003) Write-Protect Register                                     */

        struct
        {
            uint8_t             : 6;
            __IOM uint8_t PFSWE : 1;   /*!< [6..6] PmnPFS Register Write                                              */
            __IOM uint8_t B0WI  : 1;   /*!< [7..7] PFSWE Bit Write Disable                                            */
        } PWPR_b;
    };
    __IM uint8_t RESERVED1;

    union
    {
        __IOM uint8_t PWPRS;           /*!< (@ 0x00000005) Write-Protect Register for Secure                          */

        struct
        {
            uint8_t             : 6;
            __IOM uint8_t PFSWE : 1;    /*!< [6..6] PmnPFS Register Write                                              */
            __IOM uint8_t B0WI  : 1;    /*!< [7..7] PFSWE Bit Write Disable                                            */
        } PWPRS_b;
    };
    __IM uint16_t            RESERVED2[5];
    __IOM R_PMISC_PMSAR_Type PMSAR[12]; /*!< (@ 0x00000010) Port Security Attribution Register                         */
} R_PMISC_Type;                         /*!< Size = 40 (0x28)                                                          */

 #endif

/* =========================================================================================================================== */
/* ================                                          R_QSPI                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Quad Serial Peripheral Interface (R_QSPI)
 */

typedef struct                         /*!< (@ 0x64000000) R_QSPI Structure                                           */
{
    union
    {
        __IOM uint32_t SFMSMD;         /*!< (@ 0x00000000) Transfer Mode Control Register                             */

        struct
        {
            __IOM uint32_t SFMRM  : 3; /*!< [2..0] Serial interface read mode selection                               */
            uint32_t              : 1;
            __IOM uint32_t SFMSE  : 2; /*!< [5..4] Selection of the prefetch function                                 */
            __IOM uint32_t SFMPFE : 1; /*!< [6..6] Selection of the prefetch function                                 */
            __IOM uint32_t SFMPAE : 1; /*!< [7..7] Selection of the function for stopping prefetch at locations
                                        *   other than on byte boundaries                                             */
            __IOM uint32_t SFMMD3 : 1; /*!< [8..8] SPI mode selection. An initial value is determined by
                                        *   input to CFGMD3.                                                          */
            __IOM uint32_t SFMOEX : 1; /*!< [9..9] Extension of the I/O buffer output enable signal for
                                        *   the serial interface                                                      */
            __IOM uint32_t SFMOHW : 1; /*!< [10..10] Hold time adjustment for serial transmission                     */
            __IOM uint32_t SFMOSW : 1; /*!< [11..11] Setup time adjustment for serial transmission                    */
            uint32_t              : 3;
            __IOM uint32_t SFMCCE : 1; /*!< [15..15] Read instruction code selection.                                 */
            uint32_t              : 16;
        } SFMSMD_b;
    };

    union
    {
        __IOM uint32_t SFMSSC;         /*!< (@ 0x00000004) Chip Selection Control Register                            */

        struct
        {
            __IOM uint32_t SFMSW  : 4; /*!< [3..0] Selection of a minimum high-level width of the QSSL signal         */
            __IOM uint32_t SFMSHD : 1; /*!< [4..4] QSSL signal release timing selection                               */
            __IOM uint32_t SFMSLD : 1; /*!< [5..5] QSSL signal output timing selection                                */
            uint32_t              : 26;
        } SFMSSC_b;
    };

    union
    {
        __IOM uint32_t SFMSKC;         /*!< (@ 0x00000008) Clock Control Register                                     */

        struct
        {
            __IOM uint32_t SFMDV : 5;  /*!< [4..0] Serial interface reference cycle selection (* Pay attention
                                        *   to the irregularity.)NOTE: When PCLKA multiplied by an
                                        *   odd number is selected, the high-level width of the SCK
                                        *   signal is longer than the low-level width by 1 x PCLKA
                                        *   before duty ratio correction.                                             */
            __IOM uint32_t SFMDTY : 1; /*!< [5..5] Selection of a duty ratio correction function for the
                                        *   SCK signal                                                                */
            uint32_t : 26;
        } SFMSKC_b;
    };

    union
    {
        __IM uint32_t SFMSST;          /*!< (@ 0x0000000C) Status Register                                            */

        struct
        {
            __IM uint32_t PFCNT : 5;   /*!< [4..0] Number of bytes of prefetched dataRange: 00000 - 10010
                                        *   (No combination other than the above is available.)                       */
            uint32_t            : 1;
            __IM uint32_t PFFUL : 1;   /*!< [6..6] Prefetch buffer state                                              */
            __IM uint32_t PFOFF : 1;   /*!< [7..7] Prefetch function operation state                                  */
            uint32_t            : 24;
        } SFMSST_b;
    };

    union
    {
        __IOM uint32_t SFMCOM;         /*!< (@ 0x00000010) Communication Port Register                                */

        struct
        {
            __IOM uint32_t SFMD : 8;   /*!< [7..0] Port for direct communication with the SPI bus.Input/output
                                        *   to and from this port is converted to a SPIbus cycle. This
                                        *   port is accessible in the direct communication mode (DCOM=1)
                                        *   only.Access to this port is ignored in the ROM access mode.               */
            uint32_t : 24;
        } SFMCOM_b;
    };

    union
    {
        __IOM uint32_t SFMCMD;         /*!< (@ 0x00000014) Communication Mode Control Register                        */

        struct
        {
            __IOM uint32_t DCOM : 1;   /*!< [0..0] Selection of a mode of communication with the SPI bus              */
            uint32_t            : 31;
        } SFMCMD_b;
    };

    union
    {
        __IOM uint32_t SFMCST;         /*!< (@ 0x00000018) Communication Status Register                              */

        struct
        {
            __IM uint32_t COMBSY : 1;  /*!< [0..0] SPI bus cycle completion state in direct communication             */
            uint32_t             : 6;
            __IM uint32_t EROMR  : 1;  /*!< [7..7] Status of ROM access detection in the direct communication
                                        *   modeNOTE: Writing of 0 only is possible. Writing of 1 is
                                        *   ignored.                                                                  */
            uint32_t : 24;
        } SFMCST_b;
    };
    __IM uint32_t RESERVED;

    union
    {
        __IOM uint32_t SFMSIC;         /*!< (@ 0x00000020) Instruction Code Register                                  */

        struct
        {
            __IOM uint32_t SFMCIC : 8; /*!< [7..0] Serial ROM instruction code to substitute                          */
            uint32_t              : 24;
        } SFMSIC_b;
    };

    union
    {
        __IOM uint32_t SFMSAC;         /*!< (@ 0x00000024) Address Mode Control Register                              */

        struct
        {
            __IOM uint32_t SFMAS  : 2; /*!< [1..0] Selection the number of address bits of the serial interface       */
            uint32_t              : 2;
            __IOM uint32_t SFM4BC : 1; /*!< [4..4] Selection of a default instruction code, when Serial
                                        *   Interface address width is selected 4 bytes.                              */
            uint32_t : 27;
        } SFMSAC_b;
    };

    union
    {
        __IOM uint32_t SFMSDC;         /*!< (@ 0x00000028) Dummy Cycle Control Register                               */

        struct
        {
            __IOM uint32_t SFMDN : 4;  /*!< [3..0] Selection of the number of dummy cycles of Fast Read
                                        *   instructions                                                              */
            uint32_t              : 2;
            __IM uint32_t  SFMXST : 1; /*!< [6..6] XIP mode status                                                    */
            __IOM uint32_t SFMXEN : 1; /*!< [7..7] XIP mode permission                                                */
            __IOM uint32_t SFMXD  : 8; /*!< [15..8] Mode data for serial ROM. (Control XIP mode)                      */
            uint32_t              : 16;
        } SFMSDC_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __IOM uint32_t SFMSPC;         /*!< (@ 0x00000030) SPI Protocol Control Register                              */

        struct
        {
            __IOM uint32_t SFMSPI : 2; /*!< [1..0] Selection of SPI protocolNOTE: Serial ROM's SPI protocol
                                        *   is required to be set by software separately.                             */
            uint32_t              : 2;
            __IOM uint32_t SFMSDE : 1; /*!< [4..4] Selection of the minimum time of input output switch,
                                        *   when Dual SPI protocol or Quad SPI protocol is selected.                  */
            uint32_t : 27;
        } SFMSPC_b;
    };

    union
    {
        __IOM uint32_t SFMPMD;         /*!< (@ 0x00000034) Port Control Register                                      */

        struct
        {
            uint32_t              : 2;
            __IOM uint32_t SFMWPL : 1; /*!< [2..2] Specify level of WP pin                                            */
            uint32_t              : 29;
        } SFMPMD_b;
    };
    __IM uint32_t RESERVED2[499];

    union
    {
        __IOM uint32_t SFMCNT1;        /*!< (@ 0x00000804) External QSPI Address Register 1                           */

        struct
        {
            uint32_t                : 26;
            __IOM uint32_t QSPI_EXT : 6; /*!< [31..26] BANK Switching AddressWhen accessing from 0x6000_0000
                                          *   to 0x63FF_FFFF, Addres bus is Set QSPI_EXT[5:0] to high-order
                                          *   6bits of SHADDR[31:0]NOTE: Setting 6'h3F is prihibited.                   */
        } SFMCNT1_b;
    };
} R_QSPI_Type;                           /*!< Size = 2056 (0x808)                                                       */

/* =========================================================================================================================== */
/* ================                                           R_RTC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Realtime Clock (R_RTC)
 */

typedef struct                         /*!< (@ 0x40044000) R_RTC Structure                                            */
{
    union
    {
        __IM uint8_t R64CNT;           /*!< (@ 0x00000000) 64-Hz Counter                                              */

        struct
        {
            __IM uint8_t F64HZ : 1;    /*!< [0..0] 64Hz                                                               */
            __IM uint8_t F32HZ : 1;    /*!< [1..1] 32Hz                                                               */
            __IM uint8_t F16HZ : 1;    /*!< [2..2] 16Hz                                                               */
            __IM uint8_t F8HZ  : 1;    /*!< [3..3] 8Hz                                                                */
            __IM uint8_t F4HZ  : 1;    /*!< [4..4] 4Hz                                                                */
            __IM uint8_t F2HZ  : 1;    /*!< [5..5] 2Hz                                                                */
            __IM uint8_t F1HZ  : 1;    /*!< [6..6] 1Hz                                                                */
            uint8_t            : 1;
        } R64CNT_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        union
        {
            __IOM uint8_t RSECCNT;       /*!< (@ 0x00000002) Second Counter                                             */

            struct
            {
                __IOM uint8_t SEC1 : 4;  /*!< [3..0] 1-Second Count Counts from 0 to 9 every second. When
                                          *   a carry is generated, 1 is added to the tens place.                       */
                __IOM uint8_t SEC10 : 3; /*!< [6..4] 10-Second Count Counts from 0 to 5 for 60-second counting.         */
                uint8_t             : 1;
            } RSECCNT_b;
        };

        union
        {
            __IOM uint8_t BCNT0;         /*!< (@ 0x00000002) Binary Counter 0                                           */

            struct
            {
                __IOM uint8_t BCNT0 : 8; /*!< [7..0] The BCNT0 counter is a readable/writable 32-bit binary
                                          *   counter b7 to b0.                                                         */
            } BCNT0_b;
        };
    };
    __IM uint8_t RESERVED1;

    union
    {
        union
        {
            __IOM uint8_t RMINCNT;       /*!< (@ 0x00000004) Minute Counter                                             */

            struct
            {
                __IOM uint8_t MIN1 : 4;  /*!< [3..0] 1-Minute Count Counts from 0 to 9 every minute. When
                                          *   a carry is generated, 1 is added to the tens place.                       */
                __IOM uint8_t MIN10 : 3; /*!< [6..4] 10-Minute Count Counts from 0 to 5 for 60-minute counting.         */
                uint8_t             : 1;
            } RMINCNT_b;
        };

        union
        {
            __IOM uint8_t BCNT1;         /*!< (@ 0x00000004) Binary Counter 1                                           */

            struct
            {
                __IOM uint8_t BCNT1 : 8; /*!< [7..0] The BCNT1 counter is a readable/writable 32-bit binary
                                          *   counter b15 to b8.                                                        */
            } BCNT1_b;
        };
    };
    __IM uint8_t RESERVED2;

    union
    {
        union
        {
            __IOM uint8_t RHRCNT;       /*!< (@ 0x00000006) Hour Counter                                               */

            struct
            {
                __IOM uint8_t HR1 : 4;  /*!< [3..0] 1-Hour Count Counts from 0 to 9 once per hour. When a
                                         *   carry is generated, 1 is added to the tens place.                         */
                __IOM uint8_t HR10 : 2; /*!< [5..4] 10-Hour Count Counts from 0 to 2 once per carry from
                                         *   the ones place.                                                           */
                __IOM uint8_t PM : 1;   /*!< [6..6] Time Counter Setting for a.m./p.m.                                 */
                uint8_t          : 1;
            } RHRCNT_b;
        };

        union
        {
            __IOM uint8_t BCNT2;         /*!< (@ 0x00000006) Binary Counter 2                                           */

            struct
            {
                __IOM uint8_t BCNT2 : 8; /*!< [7..0] The BCNT2 counter is a readable/writable 32-bit binary
                                          *   counter b23 to b16.                                                       */
            } BCNT2_b;
        };
    };
    __IM uint8_t RESERVED3;

    union
    {
        union
        {
            __IOM uint8_t RWKCNT;       /*!< (@ 0x00000008) Day-of-Week Counter                                        */

            struct
            {
                __IOM uint8_t DAYW : 3; /*!< [2..0] Day-of-Week Counting                                               */
                uint8_t            : 5;
            } RWKCNT_b;
        };

        union
        {
            __IOM uint8_t BCNT3;         /*!< (@ 0x00000008) Binary Counter 3                                           */

            struct
            {
                __IOM uint8_t BCNT3 : 8; /*!< [7..0] The BCNT3 counter is a readable/writable 32-bit binary
                                          *   counter b31 to b24.                                                       */
            } BCNT3_b;
        };
    };
    __IM uint8_t RESERVED4;

    union
    {
        __IOM uint8_t RDAYCNT;         /*!< (@ 0x0000000A) Day Counter                                                */

        struct
        {
            __IOM uint8_t DATE1 : 4;   /*!< [3..0] 1-Day Count Counts from 0 to 9 once per day. When a carry
                                        *   is generated, 1 is added to the tens place.                               */
            __IOM uint8_t DATE10 : 2;  /*!< [5..4] 10-Day Count Counts from 0 to 3 once per carry from the
                                        *   ones place.                                                               */
            uint8_t : 2;
        } RDAYCNT_b;
    };
    __IM uint8_t RESERVED5;

    union
    {
        __IOM uint8_t RMONCNT;         /*!< (@ 0x0000000C) Month Counter                                              */

        struct
        {
            __IOM uint8_t MON1 : 4;    /*!< [3..0] 1-Month Count Counts from 0 to 9 once per month. When
                                        *   a carry is generated, 1 is added to the tens place.                       */
            __IOM uint8_t MON10 : 1;   /*!< [4..4] 10-Month Count Counts from 0 to 1 once per carry from
                                        *   the ones place.                                                           */
            uint8_t : 3;
        } RMONCNT_b;
    };
    __IM uint8_t RESERVED6;

    union
    {
        __IOM uint16_t RYRCNT;         /*!< (@ 0x0000000E) Year Counter                                               */

        struct
        {
            __IOM uint16_t YR1 : 4;    /*!< [3..0] 1-Year Count Counts from 0 to 9 once per year. When a
                                        *   carry is generated, 1 is added to the tens place.                         */
            __IOM uint16_t YR10 : 4;   /*!< [7..4] 10-Year Count Counts from 0 to 9 once per carry from
                                        *   ones place. When a carry is generated in the tens place,
                                        *   1 is added to the hundreds place.                                         */
            uint16_t : 8;
        } RYRCNT_b;
    };

    union
    {
        union
        {
            __IOM uint8_t RSECAR;        /*!< (@ 0x00000010) Second Alarm Register                                      */

            struct
            {
                __OM uint8_t  SEC1  : 4; /*!< [3..0] 1-Second Value for the ones place of seconds                       */
                __IOM uint8_t SEC10 : 3; /*!< [6..4] 10-Seconds Value for the tens place of seconds                     */
                __IOM uint8_t ENB   : 1; /*!< [7..7] Compare enable                                                     */
            } RSECAR_b;
        };

        union
        {
            __IOM uint8_t BCNT0AR;         /*!< (@ 0x00000010) Binary Counter 0 Alarm Register                            */

            struct
            {
                __IOM uint8_t BCNT0AR : 8; /*!< [7..0] he BCNT0AR counter is a readable/writable alarm register
                                            *   corresponding to 32-bit binary counter b7 to b0.                          */
            } BCNT0AR_b;
        };
    };
    __IM uint8_t RESERVED7;

    union
    {
        union
        {
            __IOM uint8_t RMINAR;        /*!< (@ 0x00000012) Minute Alarm Register                                      */

            struct
            {
                __IOM uint8_t MIN1  : 4; /*!< [3..0] 1-Minute Count Value for the ones place of minutes                 */
                __IOM uint8_t MIN10 : 3; /*!< [6..4] 10-Minute Count Value for the tens place of minutes                */
                __IOM uint8_t ENB   : 1; /*!< [7..7] Compare enable                                                     */
            } RMINAR_b;
        };

        union
        {
            __IOM uint8_t BCNT1AR;         /*!< (@ 0x00000012) Binary Counter 1 Alarm Register                            */

            struct
            {
                __IOM uint8_t BCNT1AR : 8; /*!< [7..0] he BCNT1AR counter is a readable/writable alarm register
                                            *   corresponding to 32-bit binary counter b15 to b8.                         */
            } BCNT1AR_b;
        };
    };
    __IM uint8_t RESERVED8;

    union
    {
        union
        {
            __IOM uint8_t RHRAR;        /*!< (@ 0x00000014) Hour Alarm Register                                        */

            struct
            {
                __IOM uint8_t HR1  : 4; /*!< [3..0] 1-Hour Count Value for the ones place of hours                     */
                __IOM uint8_t HR10 : 2; /*!< [5..4] 10-Hour Count Value for the tens place of hours                    */
                __IOM uint8_t PM   : 1; /*!< [6..6] Time Counter Setting for a.m./p.m.                                 */
                __IOM uint8_t ENB  : 1; /*!< [7..7] Compare enable                                                     */
            } RHRAR_b;
        };

        union
        {
            __IOM uint8_t BCNT2AR;         /*!< (@ 0x00000014) Binary Counter 2 Alarm Register                            */

            struct
            {
                __IOM uint8_t BCNT2AR : 8; /*!< [7..0] The BCNT2AR counter is a readable/writable 32-bit binary
                                            *   counter b23 to b16.                                                       */
            } BCNT2AR_b;
        };
    };
    __IM uint8_t RESERVED9;

    union
    {
        union
        {
            __IOM uint8_t RWKAR;        /*!< (@ 0x00000016) Day-of-Week Alarm Register                                 */

            struct
            {
                __IOM uint8_t DAYW : 3; /*!< [2..0] Day-of-Week Counting                                               */
                uint8_t            : 4;
                __IOM uint8_t ENB  : 1; /*!< [7..7] Compare enable                                                     */
            } RWKAR_b;
        };

        union
        {
            __IOM uint8_t BCNT3AR;         /*!< (@ 0x00000016) Binary Counter 3 Alarm Register                            */

            struct
            {
                __IOM uint8_t BCNT3AR : 8; /*!< [7..0] The BCNT3AR counter is a readable/writable 32-bit binary
                                            *   counter b31 to b24.                                                       */
            } BCNT3AR_b;
        };
    };
    __IM uint8_t RESERVED10;

    union
    {
        union
        {
            __IOM uint8_t RDAYAR;         /*!< (@ 0x00000018) Date Alarm Register                                        */

            struct
            {
                __IOM uint8_t DATE1  : 4; /*!< [3..0] 1 Day Value for the ones place of days                             */
                __IOM uint8_t DATE10 : 2; /*!< [5..4] 10 Days Value for the tens place of days                           */
                uint8_t              : 1;
                __IOM uint8_t ENB    : 1; /*!< [7..7] Compare enable                                                     */
            } RDAYAR_b;
        };

        union
        {
            __IOM uint8_t BCNT0AER;    /*!< (@ 0x00000018) Binary Counter 0 Alarm Enable Register                     */

            struct
            {
                __IOM uint8_t ENB : 8; /*!< [7..0] The BCNT0AER register is a readable/writable register
                                        *   for setting the alarm enable corresponding to 32-bit binary
                                        *   counter b7 to b0.                                                         */
            } BCNT0AER_b;
        };
    };
    __IM uint8_t RESERVED11;

    union
    {
        union
        {
            __IOM uint8_t RMONAR;        /*!< (@ 0x0000001A) Month Alarm Register                                       */

            struct
            {
                __IOM uint8_t MON1  : 4; /*!< [3..0] 1 Month Value for the ones place of months                         */
                __IOM uint8_t MON10 : 1; /*!< [4..4] 10 Months Value for the tens place of months                       */
                uint8_t             : 2;
                __IOM uint8_t ENB   : 1; /*!< [7..7] Compare enable                                                     */
            } RMONAR_b;
        };

        union
        {
            __IOM uint8_t BCNT1AER;    /*!< (@ 0x0000001A) Binary Counter 1 Alarm Enable Register                     */

            struct
            {
                __IOM uint8_t ENB : 8; /*!< [7..0] The BCNT1AER register is a readable/writable register
                                        *   for setting the alarm enable corresponding to 32-bit binary
                                        *   counter b15 to b8.                                                        */
            } BCNT1AER_b;
        };
    };
    __IM uint8_t RESERVED12;

    union
    {
        union
        {
            __IOM uint16_t RYRAR;        /*!< (@ 0x0000001C) Year Alarm Register                                        */

            struct
            {
                __IOM uint16_t YR1  : 4; /*!< [3..0] 1 Year Value for the ones place of years                           */
                __IOM uint16_t YR10 : 4; /*!< [7..4] 10 Years Value for the tens place of years                         */
                uint16_t            : 8;
            } RYRAR_b;
        };

        union
        {
            __IOM uint16_t BCNT2AER;    /*!< (@ 0x0000001C) Binary Counter 2 Alarm Enable Register                     */

            struct
            {
                __IOM uint16_t ENB : 8; /*!< [7..0] The BCNT2AER register is a readable/writable register
                                         *   for setting the alarm enable corresponding to 32-bit binary
                                         *   counter b23 to b16.                                                       */
                uint16_t : 8;
            } BCNT2AER_b;
        };
    };

    union
    {
        union
        {
            __IOM uint8_t RYRAREN;     /*!< (@ 0x0000001E) Year Alarm Enable Register                                 */

            struct
            {
                uint8_t           : 7;
                __IOM uint8_t ENB : 1; /*!< [7..7] Compare enable                                                     */
            } RYRAREN_b;
        };

        union
        {
            __IOM uint8_t BCNT3AER;    /*!< (@ 0x0000001E) Binary Counter 3 Alarm Enable Register                     */

            struct
            {
                __IOM uint8_t ENB : 8; /*!< [7..0] The BCNT3AER register is a readable/writable register
                                        *   for setting the alarm enable corresponding to 32-bit binary
                                        *   counter b31 to b24.                                                       */
            } BCNT3AER_b;
        };
    };
    __IM uint8_t  RESERVED13;
    __IM uint16_t RESERVED14;

    union
    {
        __IOM uint8_t RCR1;            /*!< (@ 0x00000022) RTC Control Register 1                                     */

        struct
        {
            __IOM uint8_t AIE   : 1;   /*!< [0..0] Alarm Interrupt Enable                                             */
            __IOM uint8_t CIE   : 1;   /*!< [1..1] Carry Interrupt Enable                                             */
            __IOM uint8_t PIE   : 1;   /*!< [2..2] Periodic Interrupt Enable                                          */
            __IOM uint8_t RTCOS : 1;   /*!< [3..3] RTCOUT Output Select                                               */
            __IOM uint8_t PES   : 4;   /*!< [7..4] Periodic Interrupt Select                                          */
        } RCR1_b;
    };
    __IM uint8_t RESERVED15;

    union
    {
        __IOM uint8_t RCR2;            /*!< (@ 0x00000024) RTC Control Register 2                                     */

        struct
        {
            __IOM uint8_t START : 1;   /*!< [0..0] Start                                                              */
            __IOM uint8_t RESET : 1;   /*!< [1..1] RTC Software Reset                                                 */
            __IOM uint8_t ADJ30 : 1;   /*!< [2..2] 30-Second Adjustment                                               */
            __IOM uint8_t RTCOE : 1;   /*!< [3..3] RTCOUT Output Enable                                               */
            __IOM uint8_t AADJE : 1;   /*!< [4..4] Automatic Adjustment Enable (When the LOCO clock is selected,
                                        *   the setting of this bit is disabled.)                                     */
            __IOM uint8_t AADJP : 1;   /*!< [5..5] Automatic Adjustment Period Select (When the LOCO clock
                                        *   is selected, the setting of this bit is disabled.)                        */
            __IOM uint8_t HR24  : 1;   /*!< [6..6] Hours Mode                                                         */
            __IOM uint8_t CNTMD : 1;   /*!< [7..7] Count Mode Select                                                  */
        } RCR2_b;
    };
    __IM uint8_t  RESERVED16;
    __IM uint16_t RESERVED17;

    union
    {
        __IOM uint8_t RCR4;            /*!< (@ 0x00000028) RTC Control Register 4                                     */

        struct
        {
   