%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  This file is part of VivoMind Prolog Unicode Resources
%  SPDX-License-Identifier: CC0-1.0
%
%  VivoMind Prolog Unicode Resources is free software distributed using the
%  Creative Commons CC0 1.0 Universal (CC0 1.0) - Public Domain Dedication
%  license
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%  Last modified: March 27, 2012
%
%  Original Unicode file header comments follow

/*
# DerivedNormalizationProps-6.1.0.txt
# Date: 2011-07-26, 04:18:07 GMT [MD]
#
# Unicode Character Database
# Copyright (c) 1991-2011 Unicode, Inc.
# For terms of use, see http://www.unicode.org/terms_of_use.html
# For documentation, see http://www.unicode.org/reports/tr44/
*/

unicode_nfkd_qc_no(CodePoint) :-
	(	var(CodePoint) ->
		% generate code point pairs
		unicode_nfkd_qc_no(CodePointStart, CodePointEnd),
		between(CodePointStart, CodePointEnd, CodePoint)
	;	% try first-argument indexing first
		unicode_nfkd_qc_no(CodePoint, _) ->
		true
	;	% look for a code point range that includes the given code point
		unicode_nfkd_qc_no(CodePointStart, CodePointEnd),
		between(CodePointStart, CodePointEnd, CodePoint) ->
		true
	).

% ================================================

% Property:	NFKD_Quick_Check

%  All code points not explicitly listed for NFKD_Quick_Check
%  have the value Yes (Y).

% @missing: 0000..10FFFF; NFKD_QC; Yes

% ================================================

% NFKD_Quick_Check=No

unicode_nfkd_qc_no(0x00A0, 0x00A0).	% Zs       NO-BREAK SPACE
unicode_nfkd_qc_no(0x00A8, 0x00A8).	% Sk       DIAERESIS
unicode_nfkd_qc_no(0x00AA, 0x00AA).	% Lo       FEMININE ORDINAL INDICATOR
unicode_nfkd_qc_no(0x00AF, 0x00AF).	% Sk       MACRON
unicode_nfkd_qc_no(0x00B2, 0x00B3).	% No   [2] SUPERSCRIPT TWO..SUPERSCRIPT THREE
unicode_nfkd_qc_no(0x00B4, 0x00B4).	% Sk       ACUTE ACCENT
unicode_nfkd_qc_no(0x00B5, 0x00B5).	% L&       MICRO SIGN
unicode_nfkd_qc_no(0x00B8, 0x00B8).	% Sk       CEDILLA
unicode_nfkd_qc_no(0x00B9, 0x00B9).	% No       SUPERSCRIPT ONE
unicode_nfkd_qc_no(0x00BA, 0x00BA).	% Lo       MASCULINE ORDINAL INDICATOR
unicode_nfkd_qc_no(0x00BC, 0x00BE).	% No   [3] VULGAR FRACTION ONE QUARTER..VULGAR FRACTION THREE QUARTERS
unicode_nfkd_qc_no(0x00C0, 0x00C5).	% L&   [6] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER A WITH RING ABOVE
unicode_nfkd_qc_no(0x00C7, 0x00CF).	% L&   [9] LATIN CAPITAL LETTER C WITH CEDILLA..LATIN CAPITAL LETTER I WITH DIAERESIS
unicode_nfkd_qc_no(0x00D1, 0x00D6).	% L&   [6] LATIN CAPITAL LETTER N WITH TILDE..LATIN CAPITAL LETTER O WITH DIAERESIS
unicode_nfkd_qc_no(0x00D9, 0x00DD).	% L&   [5] LATIN CAPITAL LETTER U WITH GRAVE..LATIN CAPITAL LETTER Y WITH ACUTE
unicode_nfkd_qc_no(0x00E0, 0x00E5).	% L&   [6] LATIN SMALL LETTER A WITH GRAVE..LATIN SMALL LETTER A WITH RING ABOVE
unicode_nfkd_qc_no(0x00E7, 0x00EF).	% L&   [9] LATIN SMALL LETTER C WITH CEDILLA..LATIN SMALL LETTER I WITH DIAERESIS
unicode_nfkd_qc_no(0x00F1, 0x00F6).	% L&   [6] LATIN SMALL LETTER N WITH TILDE..LATIN SMALL LETTER O WITH DIAERESIS
unicode_nfkd_qc_no(0x00F9, 0x00FD).	% L&   [5] LATIN SMALL LETTER U WITH GRAVE..LATIN SMALL LETTER Y WITH ACUTE
unicode_nfkd_qc_no(0x00FF, 0x010F).	% L&  [17] LATIN SMALL LETTER Y WITH DIAERESIS..LATIN SMALL LETTER D WITH CARON
unicode_nfkd_qc_no(0x0112, 0x0125).	% L&  [20] LATIN CAPITAL LETTER E WITH MACRON..LATIN SMALL LETTER H WITH CIRCUMFLEX
unicode_nfkd_qc_no(0x0128, 0x0130).	% L&   [9] LATIN CAPITAL LETTER I WITH TILDE..LATIN CAPITAL LETTER I WITH DOT ABOVE
unicode_nfkd_qc_no(0x0132, 0x0137).	% L&   [6] LATIN CAPITAL LIGATURE IJ..LATIN SMALL LETTER K WITH CEDILLA
unicode_nfkd_qc_no(0x0139, 0x0140).	% L&   [8] LATIN CAPITAL LETTER L WITH ACUTE..LATIN SMALL LETTER L WITH MIDDLE DOT
unicode_nfkd_qc_no(0x0143, 0x0149).	% L&   [7] LATIN CAPITAL LETTER N WITH ACUTE..LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
unicode_nfkd_qc_no(0x014C, 0x0151).	% L&   [6] LATIN CAPITAL LETTER O WITH MACRON..LATIN SMALL LETTER O WITH DOUBLE ACUTE
unicode_nfkd_qc_no(0x0154, 0x0165).	% L&  [18] LATIN CAPITAL LETTER R WITH ACUTE..LATIN SMALL LETTER T WITH CARON
unicode_nfkd_qc_no(0x0168, 0x017F).	% L&  [24] LATIN CAPITAL LETTER U WITH TILDE..LATIN SMALL LETTER LONG S
unicode_nfkd_qc_no(0x01A0, 0x01A1).	% L&   [2] LATIN CAPITAL LETTER O WITH HORN..LATIN SMALL LETTER O WITH HORN
unicode_nfkd_qc_no(0x01AF, 0x01B0).	% L&   [2] LATIN CAPITAL LETTER U WITH HORN..LATIN SMALL LETTER U WITH HORN
unicode_nfkd_qc_no(0x01C4, 0x01DC).	% L&  [25] LATIN CAPITAL LETTER DZ WITH CARON..LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
unicode_nfkd_qc_no(0x01DE, 0x01E3).	% L&   [6] LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON..LATIN SMALL LETTER AE WITH MACRON
unicode_nfkd_qc_no(0x01E6, 0x01F5).	% L&  [16] LATIN CAPITAL LETTER G WITH CARON..LATIN SMALL LETTER G WITH ACUTE
unicode_nfkd_qc_no(0x01F8, 0x021B).	% L&  [36] LATIN CAPITAL LETTER N WITH GRAVE..LATIN SMALL LETTER T WITH COMMA BELOW
unicode_nfkd_qc_no(0x021E, 0x021F).	% L&   [2] LATIN CAPITAL LETTER H WITH CARON..LATIN SMALL LETTER H WITH CARON
unicode_nfkd_qc_no(0x0226, 0x0233).	% L&  [14] LATIN CAPITAL LETTER A WITH DOT ABOVE..LATIN SMALL LETTER Y WITH MACRON
unicode_nfkd_qc_no(0x02B0, 0x02B8).	% Lm   [9] MODIFIER LETTER SMALL H..MODIFIER LETTER SMALL Y
unicode_nfkd_qc_no(0x02D8, 0x02DD).	% Sk   [6] BREVE..DOUBLE ACUTE ACCENT
unicode_nfkd_qc_no(0x02E0, 0x02E4).	% Lm   [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
unicode_nfkd_qc_no(0x0340, 0x0341).	% Mn   [2] COMBINING GRAVE TONE MARK..COMBINING ACUTE TONE MARK
unicode_nfkd_qc_no(0x0343, 0x0344).	% Mn   [2] COMBINING GREEK KORONIS..COMBINING GREEK DIALYTIKA TONOS
unicode_nfkd_qc_no(0x0374, 0x0374).	% Lm       GREEK NUMERAL SIGN
unicode_nfkd_qc_no(0x037A, 0x037A).	% Lm       GREEK YPOGEGRAMMENI
unicode_nfkd_qc_no(0x037E, 0x037E).	% Po       GREEK QUESTION MARK
unicode_nfkd_qc_no(0x0384, 0x0385).	% Sk   [2] GREEK TONOS..GREEK DIALYTIKA TONOS
unicode_nfkd_qc_no(0x0386, 0x0386).	% L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
unicode_nfkd_qc_no(0x0387, 0x0387).	% Po       GREEK ANO TELEIA
unicode_nfkd_qc_no(0x0388, 0x038A).	% L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
unicode_nfkd_qc_no(0x038C, 0x038C).	% L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
unicode_nfkd_qc_no(0x038E, 0x0390).	% L&   [3] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
unicode_nfkd_qc_no(0x03AA, 0x03B0).	% L&   [7] GREEK CAPITAL LETTER IOTA WITH DIALYTIKA..GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
unicode_nfkd_qc_no(0x03CA, 0x03CE).	% L&   [5] GREEK SMALL LETTER IOTA WITH DIALYTIKA..GREEK SMALL LETTER OMEGA WITH TONOS
unicode_nfkd_qc_no(0x03D0, 0x03D6).	% L&   [7] GREEK BETA SYMBOL..GREEK PI SYMBOL
unicode_nfkd_qc_no(0x03F0, 0x03F2).	% L&   [3] GREEK KAPPA SYMBOL..GREEK LUNATE SIGMA SYMBOL
unicode_nfkd_qc_no(0x03F4, 0x03F5).	% L&   [2] GREEK CAPITAL THETA SYMBOL..GREEK LUNATE EPSILON SYMBOL
unicode_nfkd_qc_no(0x03F9, 0x03F9).	% L&       GREEK CAPITAL LUNATE SIGMA SYMBOL
unicode_nfkd_qc_no(0x0400, 0x0401).	% L&   [2] CYRILLIC CAPITAL LETTER IE WITH GRAVE..CYRILLIC CAPITAL LETTER IO
unicode_nfkd_qc_no(0x0403, 0x0403).	% L&       CYRILLIC CAPITAL LETTER GJE
unicode_nfkd_qc_no(0x0407, 0x0407).	% L&       CYRILLIC CAPITAL LETTER YI
unicode_nfkd_qc_no(0x040C, 0x040E).	% L&   [3] CYRILLIC CAPITAL LETTER KJE..CYRILLIC CAPITAL LETTER SHORT U
unicode_nfkd_qc_no(0x0419, 0x0419).	% L&       CYRILLIC CAPITAL LETTER SHORT I
unicode_nfkd_qc_no(0x0439, 0x0439).	% L&       CYRILLIC SMALL LETTER SHORT I
unicode_nfkd_qc_no(0x0450, 0x0451).	% L&   [2] CYRILLIC SMALL LETTER IE WITH GRAVE..CYRILLIC SMALL LETTER IO
unicode_nfkd_qc_no(0x0453, 0x0453).	% L&       CYRILLIC SMALL LETTER GJE
unicode_nfkd_qc_no(0x0457, 0x0457).	% L&       CYRILLIC SMALL LETTER YI
unicode_nfkd_qc_no(0x045C, 0x045E).	% L&   [3] CYRILLIC SMALL LETTER KJE..CYRILLIC SMALL LETTER SHORT U
unicode_nfkd_qc_no(0x0476, 0x0477).	% L&   [2] CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT..CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
unicode_nfkd_qc_no(0x04C1, 0x04C2).	% L&   [2] CYRILLIC CAPITAL LETTER ZHE WITH BREVE..CYRILLIC SMALL LETTER ZHE WITH BREVE
unicode_nfkd_qc_no(0x04D0, 0x04D3).	% L&   [4] CYRILLIC CAPITAL LETTER A WITH BREVE..CYRILLIC SMALL LETTER A WITH DIAERESIS
unicode_nfkd_qc_no(0x04D6, 0x04D7).	% L&   [2] CYRILLIC CAPITAL LETTER IE WITH BREVE..CYRILLIC SMALL LETTER IE WITH BREVE
unicode_nfkd_qc_no(0x04DA, 0x04DF).	% L&   [6] CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS..CYRILLIC SMALL LETTER ZE WITH DIAERESIS
unicode_nfkd_qc_no(0x04E2, 0x04E7).	% L&   [6] CYRILLIC CAPITAL LETTER I WITH MACRON..CYRILLIC SMALL LETTER O WITH DIAERESIS
unicode_nfkd_qc_no(0x04EA, 0x04F5).	% L&  [12] CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS..CYRILLIC SMALL LETTER CHE WITH DIAERESIS
unicode_nfkd_qc_no(0x04F8, 0x04F9).	% L&   [2] CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS..CYRILLIC SMALL LETTER YERU WITH DIAERESIS
unicode_nfkd_qc_no(0x0587, 0x0587).	% L&       ARMENIAN SMALL LIGATURE ECH YIWN
unicode_nfkd_qc_no(0x0622, 0x0626).	% Lo   [5] ARABIC LETTER ALEF WITH MADDA ABOVE..ARABIC LETTER YEH WITH HAMZA ABOVE
unicode_nfkd_qc_no(0x0675, 0x0678).	% Lo   [4] ARABIC LETTER HIGH HAMZA ALEF..ARABIC LETTER HIGH HAMZA YEH
unicode_nfkd_qc_no(0x06C0, 0x06C0).	% Lo       ARABIC LETTER HEH WITH YEH ABOVE
unicode_nfkd_qc_no(0x06C2, 0x06C2).	% Lo       ARABIC LETTER HEH GOAL WITH HAMZA ABOVE
unicode_nfkd_qc_no(0x06D3, 0x06D3).	% Lo       ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
unicode_nfkd_qc_no(0x0929, 0x0929).	% Lo       DEVANAGARI LETTER NNNA
unicode_nfkd_qc_no(0x0931, 0x0931).	% Lo       DEVANAGARI LETTER RRA
unicode_nfkd_qc_no(0x0934, 0x0934).	% Lo       DEVANAGARI LETTER LLLA
unicode_nfkd_qc_no(0x0958, 0x095F).	% Lo   [8] DEVANAGARI LETTER QA..DEVANAGARI LETTER YYA
unicode_nfkd_qc_no(0x09CB, 0x09CC).	% Mc   [2] BENGALI VOWEL SIGN O..BENGALI VOWEL SIGN AU
unicode_nfkd_qc_no(0x09DC, 0x09DD).	% Lo   [2] BENGALI LETTER RRA..BENGALI LETTER RHA
unicode_nfkd_qc_no(0x09DF, 0x09DF).	% Lo       BENGALI LETTER YYA
unicode_nfkd_qc_no(0x0A33, 0x0A33).	% Lo       GURMUKHI LETTER LLA
unicode_nfkd_qc_no(0x0A36, 0x0A36).	% Lo       GURMUKHI LETTER SHA
unicode_nfkd_qc_no(0x0A59, 0x0A5B).	% Lo   [3] GURMUKHI LETTER KHHA..GURMUKHI LETTER ZA
unicode_nfkd_qc_no(0x0A5E, 0x0A5E).	% Lo       GURMUKHI LETTER FA
unicode_nfkd_qc_no(0x0B48, 0x0B48).	% Mc       ORIYA VOWEL SIGN AI
unicode_nfkd_qc_no(0x0B4B, 0x0B4C).	% Mc   [2] ORIYA VOWEL SIGN O..ORIYA VOWEL SIGN AU
unicode_nfkd_qc_no(0x0B5C, 0x0B5D).	% Lo   [2] ORIYA LETTER RRA..ORIYA LETTER RHA
unicode_nfkd_qc_no(0x0B94, 0x0B94).	% Lo       TAMIL LETTER AU
unicode_nfkd_qc_no(0x0BCA, 0x0BCC).	% Mc   [3] TAMIL VOWEL SIGN O..TAMIL VOWEL SIGN AU
unicode_nfkd_qc_no(0x0C48, 0x0C48).	% Mn       TELUGU VOWEL SIGN AI
unicode_nfkd_qc_no(0x0CC0, 0x0CC0).	% Mc       KANNADA VOWEL SIGN II
unicode_nfkd_qc_no(0x0CC7, 0x0CC8).	% Mc   [2] KANNADA VOWEL SIGN EE..KANNADA VOWEL SIGN AI
unicode_nfkd_qc_no(0x0CCA, 0x0CCB).	% Mc   [2] KANNADA VOWEL SIGN O..KANNADA VOWEL SIGN OO
unicode_nfkd_qc_no(0x0D4A, 0x0D4C).	% Mc   [3] MALAYALAM VOWEL SIGN O..MALAYALAM VOWEL SIGN AU
unicode_nfkd_qc_no(0x0DDA, 0x0DDA).	% Mc       SINHALA VOWEL SIGN DIGA KOMBUVA
unicode_nfkd_qc_no(0x0DDC, 0x0DDE).	% Mc   [3] SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA..SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA
unicode_nfkd_qc_no(0x0E33, 0x0E33).	% Lo       THAI CHARACTER SARA AM
unicode_nfkd_qc_no(0x0EB3, 0x0EB3).	% Lo       LAO VOWEL SIGN AM
unicode_nfkd_qc_no(0x0EDC, 0x0EDD).	% Lo   [2] LAO HO NO..LAO HO MO
unicode_nfkd_qc_no(0x0F0C, 0x0F0C).	% Po       TIBETAN MARK DELIMITER TSHEG BSTAR
unicode_nfkd_qc_no(0x0F43, 0x0F43).	% Lo       TIBETAN LETTER GHA
unicode_nfkd_qc_no(0x0F4D, 0x0F4D).	% Lo       TIBETAN LETTER DDHA
unicode_nfkd_qc_no(0x0F52, 0x0F52).	% Lo       TIBETAN LETTER DHA
unicode_nfkd_qc_no(0x0F57, 0x0F57).	% Lo       TIBETAN LETTER BHA
unicode_nfkd_qc_no(0x0F5C, 0x0F5C).	% Lo       TIBETAN LETTER DZHA
unicode_nfkd_qc_no(0x0F69, 0x0F69).	% Lo       TIBETAN LETTER KSSA
unicode_nfkd_qc_no(0x0F73, 0x0F73).	% Mn       TIBETAN VOWEL SIGN II
unicode_nfkd_qc_no(0x0F75, 0x0F79).	% Mn   [5] TIBETAN VOWEL SIGN UU..TIBETAN VOWEL SIGN VOCALIC LL
unicode_nfkd_qc_no(0x0F81, 0x0F81).	% Mn       TIBETAN VOWEL SIGN REVERSED II
unicode_nfkd_qc_no(0x0F93, 0x0F93).	% Mn       TIBETAN SUBJOINED LETTER GHA
unicode_nfkd_qc_no(0x0F9D, 0x0F9D).	% Mn       TIBETAN SUBJOINED LETTER DDHA
unicode_nfkd_qc_no(0x0FA2, 0x0FA2).	% Mn       TIBETAN SUBJOINED LETTER DHA
unicode_nfkd_qc_no(0x0FA7, 0x0FA7).	% Mn       TIBETAN SUBJOINED LETTER BHA
unicode_nfkd_qc_no(0x0FAC, 0x0FAC).	% Mn       TIBETAN SUBJOINED LETTER DZHA
unicode_nfkd_qc_no(0x0FB9, 0x0FB9).	% Mn       TIBETAN SUBJOINED LETTER KSSA
unicode_nfkd_qc_no(0x1026, 0x1026).	% Lo       MYANMAR LETTER UU
unicode_nfkd_qc_no(0x10FC, 0x10FC).	% Lm       MODIFIER LETTER GEORGIAN NAR
unicode_nfkd_qc_no(0x1B06, 0x1B06).	% Lo       BALINESE LETTER AKARA TEDUNG
unicode_nfkd_qc_no(0x1B08, 0x1B08).	% Lo       BALINESE LETTER IKARA TEDUNG
unicode_nfkd_qc_no(0x1B0A, 0x1B0A).	% Lo       BALINESE LETTER UKARA TEDUNG
unicode_nfkd_qc_no(0x1B0C, 0x1B0C).	% Lo       BALINESE LETTER RA REPA TEDUNG
unicode_nfkd_qc_no(0x1B0E, 0x1B0E).	% Lo       BALINESE LETTER LA LENGA TEDUNG
unicode_nfkd_qc_no(0x1B12, 0x1B12).	% Lo       BALINESE LETTER OKARA TEDUNG
unicode_nfkd_qc_no(0x1B3B, 0x1B3B).	% Mc       BALINESE VOWEL SIGN RA REPA TEDUNG
unicode_nfkd_qc_no(0x1B3D, 0x1B3D).	% Mc       BALINESE VOWEL SIGN LA LENGA TEDUNG
unicode_nfkd_qc_no(0x1B40, 0x1B41).	% Mc   [2] BALINESE VOWEL SIGN TALING TEDUNG..BALINESE VOWEL SIGN TALING REPA TEDUNG
unicode_nfkd_qc_no(0x1B43, 0x1B43).	% Mc       BALINESE VOWEL SIGN PEPET TEDUNG
unicode_nfkd_qc_no(0x1D2C, 0x1D2E).	% Lm   [3] MODIFIER LETTER CAPITAL A..MODIFIER LETTER CAPITAL B
unicode_nfkd_qc_no(0x1D30, 0x1D3A).	% Lm  [11] MODIFIER LETTER CAPITAL D..MODIFIER LETTER CAPITAL N
unicode_nfkd_qc_no(0x1D3C, 0x1D4D).	% Lm  [18] MODIFIER LETTER CAPITAL O..MODIFIER LETTER SMALL G
unicode_nfkd_qc_no(0x1D4F, 0x1D6A).	% Lm  [28] MODIFIER LETTER SMALL K..GREEK SUBSCRIPT SMALL LETTER CHI
unicode_nfkd_qc_no(0x1D78, 0x1D78).	% Lm       MODIFIER LETTER CYRILLIC EN
unicode_nfkd_qc_no(0x1D9B, 0x1DBF).	% Lm  [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
unicode_nfkd_qc_no(0x1E00, 0x1E9B).	% L& [156] LATIN CAPITAL LETTER A WITH RING BELOW..LATIN SMALL LETTER LONG S WITH DOT ABOVE
unicode_nfkd_qc_no(0x1EA0, 0x1EF9).	% L&  [90] LATIN CAPITAL LETTER A WITH DOT BELOW..LATIN SMALL LETTER Y WITH TILDE
unicode_nfkd_qc_no(0x1F00, 0x1F15).	% L&  [22] GREEK SMALL LETTER ALPHA WITH PSILI..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
unicode_nfkd_qc_no(0x1F18, 0x1F1D).	% L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
unicode_nfkd_qc_no(0x1F20, 0x1F45).	% L&  [38] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
unicode_nfkd_qc_no(0x1F48, 0x1F4D).	% L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
unicode_nfkd_qc_no(0x1F50, 0x1F57).	% L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_nfkd_qc_no(0x1F59, 0x1F59).	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
unicode_nfkd_qc_no(0x1F5B, 0x1F5B).	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
unicode_nfkd_qc_no(0x1F5D, 0x1F5D).	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
unicode_nfkd_qc_no(0x1F5F, 0x1F7D).	% L&  [31] GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI..GREEK SMALL LETTER OMEGA WITH OXIA
unicode_nfkd_qc_no(0x1F80, 0x1FB4).	% L&  [53] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
unicode_nfkd_qc_no(0x1FB6, 0x1FBC).	% L&   [7] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
unicode_nfkd_qc_no(0x1FBD, 0x1FBD).	% Sk       GREEK KORONIS
unicode_nfkd_qc_no(0x1FBE, 0x1FBE).	% L&       GREEK PROSGEGRAMMENI
unicode_nfkd_qc_no(0x1FBF, 0x1FC1).	% Sk   [3] GREEK PSILI..GREEK DIALYTIKA AND PERISPOMENI
unicode_nfkd_qc_no(0x1FC2, 0x1FC4).	% L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
unicode_nfkd_qc_no(0x1FC6, 0x1FCC).	% L&   [7] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
unicode_nfkd_qc_no(0x1FCD, 0x1FCF).	% Sk   [3] GREEK PSILI AND VARIA..GREEK PSILI AND PERISPOMENI
unicode_nfkd_qc_no(0x1FD0, 0x1FD3).	% L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
unicode_nfkd_qc_no(0x1FD6, 0x1FDB).	% L&   [6] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK CAPITAL LETTER IOTA WITH OXIA
unicode_nfkd_qc_no(0x1FDD, 0x1FDF).	% Sk   [3] GREEK DASIA AND VARIA..GREEK DASIA AND PERISPOMENI
unicode_nfkd_qc_no(0x1FE0, 0x1FEC).	% L&  [13] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
unicode_nfkd_qc_no(0x1FED, 0x1FEF).	% Sk   [3] GREEK DIALYTIKA AND VARIA..GREEK VARIA
unicode_nfkd_qc_no(0x1FF2, 0x1FF4).	% L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
unicode_nfkd_qc_no(0x1FF6, 0x1FFC).	% L&   [7] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
unicode_nfkd_qc_no(0x1FFD, 0x1FFE).	% Sk   [2] GREEK OXIA..GREEK DASIA
unicode_nfkd_qc_no(0x2000, 0x200A).	% Zs  [11] EN QUAD..HAIR SPACE
unicode_nfkd_qc_no(0x2011, 0x2011).	% Pd       NON-BREAKING HYPHEN
unicode_nfkd_qc_no(0x2017, 0x2017).	% Po       DOUBLE LOW LINE
unicode_nfkd_qc_no(0x2024, 0x2026).	% Po   [3] ONE DOT LEADER..HORIZONTAL ELLIPSIS
unicode_nfkd_qc_no(0x202F, 0x202F).	% Zs       NARROW NO-BREAK SPACE
unicode_nfkd_qc_no(0x2033, 0x2034).	% Po   [2] DOUBLE PRIME..TRIPLE PRIME
unicode_nfkd_qc_no(0x2036, 0x2037).	% Po   [2] REVERSED DOUBLE PRIME..REVERSED TRIPLE PRIME
unicode_nfkd_qc_no(0x203C, 0x203C).	% Po       DOUBLE EXCLAMATION MARK
unicode_nfkd_qc_no(0x203E, 0x203E).	% Po       OVERLINE
unicode_nfkd_qc_no(0x2047, 0x2049).	% Po   [3] DOUBLE QUESTION MARK..EXCLAMATION QUESTION MARK
unicode_nfkd_qc_no(0x2057, 0x2057).	% Po       QUADRUPLE PRIME
unicode_nfkd_qc_no(0x205F, 0x205F).	% Zs       MEDIUM MATHEMATICAL SPACE
unicode_nfkd_qc_no(0x2070, 0x2070).	% No       SUPERSCRIPT ZERO
unicode_nfkd_qc_no(0x2071, 0x2071).	% Lm       SUPERSCRIPT LATIN SMALL LETTER I
unicode_nfkd_qc_no(0x2074, 0x2079).	% No   [6] SUPERSCRIPT FOUR..SUPERSCRIPT NINE
unicode_nfkd_qc_no(0x207A, 0x207C).	% Sm   [3] SUPERSCRIPT PLUS SIGN..SUPERSCRIPT EQUALS SIGN
unicode_nfkd_qc_no(0x207D, 0x207D).	% Ps       SUPERSCRIPT LEFT PARENTHESIS
unicode_nfkd_qc_no(0x207E, 0x207E).	% Pe       SUPERSCRIPT RIGHT PARENTHESIS
unicode_nfkd_qc_no(0x207F, 0x207F).	% Lm       SUPERSCRIPT LATIN SMALL LETTER N
unicode_nfkd_qc_no(0x2080, 0x2089).	% No  [10] SUBSCRIPT ZERO..SUBSCRIPT NINE
unicode_nfkd_qc_no(0x208A, 0x208C).	% Sm   [3] SUBSCRIPT PLUS SIGN..SUBSCRIPT EQUALS SIGN
unicode_nfkd_qc_no(0x208D, 0x208D).	% Ps       SUBSCRIPT LEFT PARENTHESIS
unicode_nfkd_qc_no(0x208E, 0x208E).	% Pe       SUBSCRIPT RIGHT PARENTHESIS
unicode_nfkd_qc_no(0x2090, 0x209C).	% Lm  [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
unicode_nfkd_qc_no(0x20A8, 0x20A8).	% Sc       RUPEE SIGN
unicode_nfkd_qc_no(0x2100, 0x2101).	% So   [2] ACCOUNT OF..ADDRESSED TO THE SUBJECT
unicode_nfkd_qc_no(0x2102, 0x2102).	% L&       DOUBLE-STRUCK CAPITAL C
unicode_nfkd_qc_no(0x2103, 0x2103).	% So       DEGREE CELSIUS
unicode_nfkd_qc_no(0x2105, 0x2106).	% So   [2] CARE OF..CADA UNA
unicode_nfkd_qc_no(0x2107, 0x2107).	% L&       EULER CONSTANT
unicode_nfkd_qc_no(0x2109, 0x2109).	% So       DEGREE FAHRENHEIT
unicode_nfkd_qc_no(0x210A, 0x2113).	% L&  [10] SCRIPT SMALL G..SCRIPT SMALL L
unicode_nfkd_qc_no(0x2115, 0x2115).	% L&       DOUBLE-STRUCK CAPITAL N
unicode_nfkd_qc_no(0x2116, 0x2116).	% So       NUMERO SIGN
unicode_nfkd_qc_no(0x2119, 0x211D).	% L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
unicode_nfkd_qc_no(0x2120, 0x2122).	% So   [3] SERVICE MARK..TRADE MARK SIGN
unicode_nfkd_qc_no(0x2124, 0x2124).	% L&       DOUBLE-STRUCK CAPITAL Z
unicode_nfkd_qc_no(0x2126, 0x2126).	% L&       OHM SIGN
unicode_nfkd_qc_no(0x2128, 0x2128).	% L&       BLACK-LETTER CAPITAL Z
unicode_nfkd_qc_no(0x212A, 0x212D).	% L&   [4] KELVIN SIGN..BLACK-LETTER CAPITAL C
unicode_nfkd_qc_no(0x212F, 0x2131).	% L&   [3] SCRIPT SMALL E..SCRIPT CAPITAL F
unicode_nfkd_qc_no(0x2133, 0x2134).	% L&   [2] SCRIPT CAPITAL M..SCRIPT SMALL O
unicode_nfkd_qc_no(0x2135, 0x2138).	% Lo   [4] ALEF SYMBOL..DALET SYMBOL
unicode_nfkd_qc_no(0x2139, 0x2139).	% L&       INFORMATION SOURCE
unicode_nfkd_qc_no(0x213B, 0x213B).	% So       FACSIMILE SIGN
unicode_nfkd_qc_no(0x213C, 0x213F).	% L&   [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
unicode_nfkd_qc_no(0x2140, 0x2140).	% Sm       DOUBLE-STRUCK N-ARY SUMMATION
unicode_nfkd_qc_no(0x2145, 0x2149).	% L&   [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
unicode_nfkd_qc_no(0x2150, 0x215F).	% No  [16] VULGAR FRACTION ONE SEVENTH..FRACTION NUMERATOR ONE
unicode_nfkd_qc_no(0x2160, 0x217F).	% Nl  [32] ROMAN NUMERAL ONE..SMALL ROMAN NUMERAL ONE THOUSAND
unicode_nfkd_qc_no(0x2189, 0x2189).	% No       VULGAR FRACTION ZERO THIRDS
unicode_nfkd_qc_no(0x219A, 0x219B).	% Sm   [2] LEFTWARDS ARROW WITH STROKE..RIGHTWARDS ARROW WITH STROKE
unicode_nfkd_qc_no(0x21AE, 0x21AE).	% Sm       LEFT RIGHT ARROW WITH STROKE
unicode_nfkd_qc_no(0x21CD, 0x21CD).	% So       LEFTWARDS DOUBLE ARROW WITH STROKE
unicode_nfkd_qc_no(0x21CE, 0x21CF).	% Sm   [2] LEFT RIGHT DOUBLE ARROW WITH STROKE..RIGHTWARDS DOUBLE ARROW WITH STROKE
unicode_nfkd_qc_no(0x2204, 0x2204).	% Sm       THERE DOES NOT EXIST
unicode_nfkd_qc_no(0x2209, 0x2209).	% Sm       NOT AN ELEMENT OF
unicode_nfkd_qc_no(0x220C, 0x220C).	% Sm       DOES NOT CONTAIN AS MEMBER
unicode_nfkd_qc_no(0x2224, 0x2224).	% Sm       DOES NOT DIVIDE
unicode_nfkd_qc_no(0x2226, 0x2226).	% Sm       NOT PARALLEL TO
unicode_nfkd_qc_no(0x222C, 0x222D).	% Sm   [2] DOUBLE INTEGRAL..TRIPLE INTEGRAL
unicode_nfkd_qc_no(0x222F, 0x2230).	% Sm   [2] SURFACE INTEGRAL..VOLUME INTEGRAL
unicode_nfkd_qc_no(0x2241, 0x2241).	% Sm       NOT TILDE
unicode_nfkd_qc_no(0x2244, 0x2244).	% Sm       NOT ASYMPTOTICALLY EQUAL TO
unicode_nfkd_qc_no(0x2247, 0x2247).	% Sm       NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO
unicode_nfkd_qc_no(0x2249, 0x2249).	% Sm       NOT ALMOST EQUAL TO
unicode_nfkd_qc_no(0x2260, 0x2260).	% Sm       NOT EQUAL TO
unicode_nfkd_qc_no(0x2262, 0x2262).	% Sm       NOT IDENTICAL TO
unicode_nfkd_qc_no(0x226D, 0x2271).	% Sm   [5] NOT EQUIVALENT TO..NEITHER GREATER-THAN NOR EQUAL TO
unicode_nfkd_qc_no(0x2274, 0x2275).	% Sm   [2] NEITHER LESS-THAN NOR EQUIVALENT TO..NEITHER GREATER-THAN NOR EQUIVALENT TO
unicode_nfkd_qc_no(0x2278, 0x2279).	% Sm   [2] NEITHER LESS-THAN NOR GREATER-THAN..NEITHER GREATER-THAN NOR LESS-THAN
unicode_nfkd_qc_no(0x2280, 0x2281).	% Sm   [2] DOES NOT PRECEDE..DOES NOT SUCCEED
unicode_nfkd_qc_no(0x2284, 0x2285).	% Sm   [2] NOT A SUBSET OF..NOT A SUPERSET OF
unicode_nfkd_qc_no(0x2288, 0x2289).	% Sm   [2] NEITHER A SUBSET OF NOR EQUAL TO..NEITHER A SUPERSET OF NOR EQUAL TO
unicode_nfkd_qc_no(0x22AC, 0x22AF).	% Sm   [4] DOES NOT PROVE..NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
unicode_nfkd_qc_no(0x22E0, 0x22E3).	% Sm   [4] DOES NOT PRECEDE OR EQUAL..NOT SQUARE ORIGINAL OF OR EQUAL TO
unicode_nfkd_qc_no(0x22EA, 0x22ED).	% Sm   [4] NOT NORMAL SUBGROUP OF..DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL
unicode_nfkd_qc_no(0x2329, 0x2329).	% Ps       LEFT-POINTING ANGLE BRACKET
unicode_nfkd_qc_no(0x232A, 0x232A).	% Pe       RIGHT-POINTING ANGLE BRACKET
unicode_nfkd_qc_no(0x2460, 0x249B).	% No  [60] CIRCLED DIGIT ONE..NUMBER TWENTY FULL STOP
unicode_nfkd_qc_no(0x249C, 0x24E9).	% So  [78] PARENTHESIZED LATIN SMALL LETTER A..CIRCLED LATIN SMALL LETTER Z
unicode_nfkd_qc_no(0x24EA, 0x24EA).	% No       CIRCLED DIGIT ZERO
unicode_nfkd_qc_no(0x2A0C, 0x2A0C).	% Sm       QUADRUPLE INTEGRAL OPERATOR
unicode_nfkd_qc_no(0x2A74, 0x2A76).	% Sm   [3] DOUBLE COLON EQUAL..THREE CONSECUTIVE EQUALS SIGNS
unicode_nfkd_qc_no(0x2ADC, 0x2ADC).	% Sm       FORKING
unicode_nfkd_qc_no(0x2C7C, 0x2C7D).	% Lm   [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
unicode_nfkd_qc_no(0x2D6F, 0x2D6F).	% Lm       TIFINAGH MODIFIER LETTER LABIALIZATION MARK
unicode_nfkd_qc_no(0x2E9F, 0x2E9F).	% So       CJK RADICAL MOTHER
unicode_nfkd_qc_no(0x2EF3, 0x2EF3).	% So       CJK RADICAL C-SIMPLIFIED TURTLE
unicode_nfkd_qc_no(0x2F00, 0x2FD5).	% So [214] KANGXI RADICAL ONE..KANGXI RADICAL FLUTE
unicode_nfkd_qc_no(0x3000, 0x3000).	% Zs       IDEOGRAPHIC SPACE
unicode_nfkd_qc_no(0x3036, 0x3036).	% So       CIRCLED POSTAL MARK
unicode_nfkd_qc_no(0x3038, 0x303A).	% Nl   [3] HANGZHOU NUMERAL TEN..HANGZHOU NUMERAL THIRTY
unicode_nfkd_qc_no(0x304C, 0x304C).	% Lo       HIRAGANA LETTER GA
unicode_nfkd_qc_no(0x304E, 0x304E).	% Lo       HIRAGANA LETTER GI
unicode_nfkd_qc_no(0x3050, 0x3050).	% Lo       HIRAGANA LETTER GU
unicode_nfkd_qc_no(0x3052, 0x3052).	% Lo       HIRAGANA LETTER GE
unicode_nfkd_qc_no(0x3054, 0x3054).	% Lo       HIRAGANA LETTER GO
unicode_nfkd_qc_no(0x3056, 0x3056).	% Lo       HIRAGANA LETTER ZA
unicode_nfkd_qc_no(0x3058, 0x3058).	% Lo       HIRAGANA LETTER ZI
unicode_nfkd_qc_no(0x305A, 0x305A).	% Lo       HIRAGANA LETTER ZU
unicode_nfkd_qc_no(0x305C, 0x305C).	% Lo       HIRAGANA LETTER ZE
unicode_nfkd_qc_no(0x305E, 0x305E).	% Lo       HIRAGANA LETTER ZO
unicode_nfkd_qc_no(0x3060, 0x3060).	% Lo       HIRAGANA LETTER DA
unicode_nfkd_qc_no(0x3062, 0x3062).	% Lo       HIRAGANA LETTER DI
unicode_nfkd_qc_no(0x3065, 0x3065).	% Lo       HIRAGANA LETTER DU
unicode_nfkd_qc_no(0x3067, 0x3067).	% Lo       HIRAGANA LETTER DE
unicode_nfkd_qc_no(0x3069, 0x3069).	% Lo       HIRAGANA LETTER DO
unicode_nfkd_qc_no(0x3070, 0x3071).	% Lo   [2] HIRAGANA LETTER BA..HIRAGANA LETTER PA
unicode_nfkd_qc_no(0x3073, 0x3074).	% Lo   [2] HIRAGANA LETTER BI..HIRAGANA LETTER PI
unicode_nfkd_qc_no(0x3076, 0x3077).	% Lo   [2] HIRAGANA LETTER BU..HIRAGANA LETTER PU
unicode_nfkd_qc_no(0x3079, 0x307A).	% Lo   [2] HIRAGANA LETTER BE..HIRAGANA LETTER PE
unicode_nfkd_qc_no(0x307C, 0x307D).	% Lo   [2] HIRAGANA LETTER BO..HIRAGANA LETTER PO
unicode_nfkd_qc_no(0x3094, 0x3094).	% Lo       HIRAGANA LETTER VU
unicode_nfkd_qc_no(0x309B, 0x309C).	% Sk   [2] KATAKANA-HIRAGANA VOICED SOUND MARK..KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
unicode_nfkd_qc_no(0x309E, 0x309E).	% Lm       HIRAGANA VOICED ITERATION MARK
unicode_nfkd_qc_no(0x309F, 0x309F).	% Lo       HIRAGANA DIGRAPH YORI
unicode_nfkd_qc_no(0x30AC, 0x30AC).	% Lo       KATAKANA LETTER GA
unicode_nfkd_qc_no(0x30AE, 0x30AE).	% Lo       KATAKANA LETTER GI
unicode_nfkd_qc_no(0x30B0, 0x30B0).	% Lo       KATAKANA LETTER GU
unicode_nfkd_qc_no(0x30B2, 0x30B2).	% Lo       KATAKANA LETTER GE
unicode_nfkd_qc_no(0x30B4, 0x30B4).	% Lo       KATAKANA LETTER GO
unicode_nfkd_qc_no(0x30B6, 0x30B6).	% Lo       KATAKANA LETTER ZA
unicode_nfkd_qc_no(0x30B8, 0x30B8).	% Lo       KATAKANA LETTER ZI
unicode_nfkd_qc_no(0x30BA, 0x30BA).	% Lo       KATAKANA LETTER ZU
unicode_nfkd_qc_no(0x30BC, 0x30BC).	% Lo       KATAKANA LETTER ZE
unicode_nfkd_qc_no(0x30BE, 0x30BE).	% Lo       KATAKANA LETTER ZO
unicode_nfkd_qc_no(0x30C0, 0x30C0).	% Lo       KATAKANA LETTER DA
unicode_nfkd_qc_no(0x30C2, 0x30C2).	% Lo       KATAKANA LETTER DI
unicode_nfkd_qc_no(0x30C5, 0x30C5).	% Lo       KATAKANA LETTER DU
unicode_nfkd_qc_no(0x30C7, 0x30C7).	% Lo       KATAKANA LETTER DE
unicode_nfkd_qc_no(0x30C9, 0x30C9).	% Lo       KATAKANA LETTER DO
unicode_nfkd_qc_no(0x30D0, 0x30D1).	% Lo   [2] KATAKANA LETTER BA..KATAKANA LETTER PA
unicode_nfkd_qc_no(0x30D3, 0x30D4).	% Lo   [2] KATAKANA LETTER BI..KATAKANA LETTER PI
unicode_nfkd_qc_no(0x30D6, 0x30D7).	% Lo   [2] KATAKANA LETTER BU..KATAKANA LETTER PU
unicode_nfkd_qc_no(0x30D9, 0x30DA).	% Lo   [2] KATAKANA LETTER BE..KATAKANA LETTER PE
unicode_nfkd_qc_no(0x30DC, 0x30DD).	% Lo   [2] KATAKANA LETTER BO..KATAKANA LETTER PO
unicode_nfkd_qc_no(0x30F4, 0x30F4).	% Lo       KATAKANA LETTER VU
unicode_nfkd_qc_no(0x30F7, 0x30FA).	% Lo   [4] KATAKANA LETTER VA..KATAKANA LETTER VO
unicode_nfkd_qc_no(0x30FE, 0x30FE).	% Lm       KATAKANA VOICED ITERATION MARK
unicode_nfkd_qc_no(0x30FF, 0x30FF).	% Lo       KATAKANA DIGRAPH KOTO
unicode_nfkd_qc_no(0x3131, 0x318E).	% Lo  [94] HANGUL LETTER KIYEOK..HANGUL LETTER ARAEAE
unicode_nfkd_qc_no(0x3192, 0x3195).	% No   [4] IDEOGRAPHIC ANNOTATION ONE MARK..IDEOGRAPHIC ANNOTATION FOUR MARK
unicode_nfkd_qc_no(0x3196, 0x319F).	% So  [10] IDEOGRAPHIC ANNOTATION TOP MARK..IDEOGRAPHIC ANNOTATION MAN MARK
unicode_nfkd_qc_no(0x3200, 0x321E).	% So  [31] PARENTHESIZED HANGUL KIYEOK..PARENTHESIZED KOREAN CHARACTER O HU
unicode_nfkd_qc_no(0x3220, 0x3229).	% No  [10] PARENTHESIZED IDEOGRAPH ONE..PARENTHESIZED IDEOGRAPH TEN
unicode_nfkd_qc_no(0x322A, 0x3247).	% So  [30] PARENTHESIZED IDEOGRAPH MOON..CIRCLED IDEOGRAPH KOTO
unicode_nfkd_qc_no(0x3250, 0x3250).	% So       PARTNERSHIP SIGN
unicode_nfkd_qc_no(0x3251, 0x325F).	% No  [15] CIRCLED NUMBER TWENTY ONE..CIRCLED NUMBER THIRTY FIVE
unicode_nfkd_qc_no(0x3260, 0x327E).	% So  [31] CIRCLED HANGUL KIYEOK..CIRCLED HANGUL IEUNG U
unicode_nfkd_qc_no(0x3280, 0x3289).	% No  [10] CIRCLED IDEOGRAPH ONE..CIRCLED IDEOGRAPH TEN
unicode_nfkd_qc_no(0x328A, 0x32B0).	% So  [39] CIRCLED IDEOGRAPH MOON..CIRCLED IDEOGRAPH NIGHT
unicode_nfkd_qc_no(0x32B1, 0x32BF).	% No  [15] CIRCLED NUMBER THIRTY SIX..CIRCLED NUMBER FIFTY
unicode_nfkd_qc_no(0x32C0, 0x32FE).	% So  [63] IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY..CIRCLED KATAKANA WO
unicode_nfkd_qc_no(0x3300, 0x33FF).	% So [256] SQUARE APAATO..SQUARE GAL
unicode_nfkd_qc_no(0xA770, 0xA770).	% Lm       MODIFIER LETTER US
unicode_nfkd_qc_no(0xA7F8, 0xA7F9).	% Lm   [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
unicode_nfkd_qc_no(0xAC00, 0xD7A3).	% Lo [11172] HANGUL SYLLABLE GA..HANGUL SYLLABLE HIH
unicode_nfkd_qc_no(0xF900, 0xFA0D).	% Lo [270] CJK COMPATIBILITY IDEOGRAPH-F900..CJK COMPATIBILITY IDEOGRAPH-FA0D
unicode_nfkd_qc_no(0xFA10, 0xFA10).	% Lo       CJK COMPATIBILITY IDEOGRAPH-FA10
unicode_nfkd_qc_no(0xFA12, 0xFA12).	% Lo       CJK COMPATIBILITY IDEOGRAPH-FA12
unicode_nfkd_qc_no(0xFA15, 0xFA1E).	% Lo  [10] CJK COMPATIBILITY IDEOGRAPH-FA15..CJK COMPATIBILITY IDEOGRAPH-FA1E
unicode_nfkd_qc_no(0xFA20, 0xFA20).	% Lo       CJK COMPATIBILITY IDEOGRAPH-FA20
unicode_nfkd_qc_no(0xFA22, 0xFA22).	% Lo       CJK COMPATIBILITY IDEOGRAPH-FA22
unicode_nfkd_qc_no(0xFA25, 0xFA26).	% Lo   [2] CJK COMPATIBILITY IDEOGRAPH-FA25..CJK COMPATIBILITY IDEOGRAPH-FA26
unicode_nfkd_qc_no(0xFA2A, 0xFA6D).	% Lo  [68] CJK COMPATIBILITY IDEOGRAPH-FA2A..CJK COMPATIBILITY IDEOGRAPH-FA6D
unicode_nfkd_qc_no(0xFA70, 0xFAD9).	% Lo [106] CJK COMPATIBILITY IDEOGRAPH-FA70..CJK COMPATIBILITY IDEOGRAPH-FAD9
unicode_nfkd_qc_no(0xFB00, 0xFB06).	% L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
unicode_nfkd_qc_no(0xFB13, 0xFB17).	% L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
unicode_nfkd_qc_no(0xFB1D, 0xFB1D).	% Lo       HEBREW LETTER YOD WITH HIRIQ
unicode_nfkd_qc_no(0xFB1F, 0xFB28).	% Lo  [10] HEBREW LIGATURE YIDDISH YOD YOD PATAH..HEBREW LETTER WIDE TAV
unicode_nfkd_qc_no(0xFB29, 0xFB29).	% Sm       HEBREW LETTER ALTERNATIVE PLUS SIGN
unicode_nfkd_qc_no(0xFB2A, 0xFB36).	% Lo  [13] HEBREW LETTER SHIN WITH SHIN DOT..HEBREW LETTER ZAYIN WITH DAGESH
unicode_nfkd_qc_no(0xFB38, 0xFB3C).	% Lo   [5] HEBREW LETTER TET WITH DAGESH..HEBREW LETTER LAMED WITH DAGESH
unicode_nfkd_qc_no(0xFB3E, 0xFB3E).	% Lo       HEBREW LETTER MEM WITH DAGESH
unicode_nfkd_qc_no(0xFB40, 0xFB41).	% Lo   [2] HEBREW LETTER NUN WITH DAGESH..HEBREW LETTER SAMEKH WITH DAGESH
unicode_nfkd_qc_no(0xFB43, 0xFB44).	% Lo   [2] HEBREW LETTER FINAL PE WITH DAGESH..HEBREW LETTER PE WITH DAGESH
unicode_nfkd_qc_no(0xFB46, 0xFBB1).	% Lo [108] HEBREW LETTER TSADI WITH DAGESH..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
unicode_nfkd_qc_no(0xFBD3, 0xFD3D).	% Lo [363] ARABIC LETTER NG ISOLATED FORM..ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
unicode_nfkd_qc_no(0xFD50, 0xFD8F).	% Lo  [64] ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM..ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
unicode_nfkd_qc_no(0xFD92, 0xFDC7).	% Lo  [54] ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM..ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
unicode_nfkd_qc_no(0xFDF0, 0xFDFB).	% Lo  [12] ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM..ARABIC LIGATURE JALLAJALALOUHOU
unicode_nfkd_qc_no(0xFDFC, 0xFDFC).	% Sc       RIAL SIGN
unicode_nfkd_qc_no(0xFE10, 0xFE16).	% Po   [7] PRESENTATION FORM FOR VERTICAL COMMA..PRESENTATION FORM FOR VERTICAL QUESTION MARK
unicode_nfkd_qc_no(0xFE17, 0xFE17).	% Ps       PRESENTATION FORM FOR VERTICAL LEFT WHITE LENTICULAR BRACKET
unicode_nfkd_qc_no(0xFE18, 0xFE18).	% Pe       PRESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRAKCET
unicode_nfkd_qc_no(0xFE19, 0xFE19).	% Po       PRESENTATION FORM FOR VERTICAL HORIZONTAL ELLIPSIS
unicode_nfkd_qc_no(0xFE30, 0xFE30).	% Po       PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
unicode_nfkd_qc_no(0xFE31, 0xFE32).	% Pd   [2] PRESENTATION FORM FOR VERTICAL EM DASH..PRESENTATION FORM FOR VERTICAL EN DASH
unicode_nfkd_qc_no(0xFE33, 0xFE34).	% Pc   [2] PRESENTATION FORM FOR VERTICAL LOW LINE..PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
unicode_nfkd_qc_no(0xFE35, 0xFE35).	% Ps       PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
unicode_nfkd_qc_no(0xFE36, 0xFE36).	% Pe       PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
unicode_nfkd_qc_no(0xFE37, 0xFE37).	% Ps       PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
unicode_nfkd_qc_no(0xFE38, 0xFE38).	% Pe       PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
unicode_nfkd_qc_no(0xFE39, 0xFE39).	% Ps       PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
unicode_nfkd_qc_no(0xFE3A, 0xFE3A).	% Pe       PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
unicode_nfkd_qc_no(0xFE3B, 0xFE3B).	% Ps       PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
unicode_nfkd_qc_no(0xFE3C, 0xFE3C).	% Pe       PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
unicode_nfkd_qc_no(0xFE3D, 0xFE3D).	% Ps       PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
unicode_nfkd_qc_no(0xFE3E, 0xFE3E).	% Pe       PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
unicode_nfkd_qc_no(0xFE3F, 0xFE3F).	% Ps       PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
unicode_nfkd_qc_no(0xFE40, 0xFE40).	% Pe       PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
unicode_nfkd_qc_no(0xFE41, 0xFE41).	% Ps       PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
unicode_nfkd_qc_no(0xFE42, 0xFE42).	% Pe       PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
unicode_nfkd_qc_no(0xFE43, 0xFE43).	% Ps       PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
unicode_nfkd_qc_no(0xFE44, 0xFE44).	% Pe       PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
unicode_nfkd_qc_no(0xFE47, 0xFE47).	% Ps       PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET
unicode_nfkd_qc_no(0xFE48, 0xFE48).	% Pe       PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET
unicode_nfkd_qc_no(0xFE49, 0xFE4C).	% Po   [4] DASHED OVERLINE..DOUBLE WAVY OVERLINE
unicode_nfkd_qc_no(0xFE4D, 0xFE4F).	% Pc   [3] DASHED LOW LINE..WAVY LOW LINE
unicode_nfkd_qc_no(0xFE50, 0xFE52).	% Po   [3] SMALL COMMA..SMALL FULL STOP
unicode_nfkd_qc_no(0xFE54, 0xFE57).	% Po   [4] SMALL SEMICOLON..SMALL EXCLAMATION MARK
unicode_nfkd_qc_no(0xFE58, 0xFE58).	% Pd       SMALL EM DASH
unicode_nfkd_qc_no(0xFE59, 0xFE59).	% Ps       SMALL LEFT PARENTHESIS
unicode_nfkd_qc_no(0xFE5A, 0xFE5A).	% Pe       SMALL RIGHT PARENTHESIS
unicode_nfkd_qc_no(0xFE5B, 0xFE5B).	% Ps       SMALL LEFT CURLY BRACKET
unicode_nfkd_qc_no(0xFE5C, 0xFE5C).	% Pe       SMALL RIGHT CURLY BRACKET
unicode_nfkd_qc_no(0xFE5D, 0xFE5D).	% Ps       SMALL LEFT TORTOISE SHELL BRACKET
unicode_nfkd_qc_no(0xFE5E, 0xFE5E).	% Pe       SMALL RIGHT TORTOISE SHELL BRACKET
unicode_nfkd_qc_no(0xFE5F, 0xFE61).	% Po   [3] SMALL NUMBER SIGN..SMALL ASTERISK
unicode_nfkd_qc_no(0xFE62, 0xFE62).	% Sm       SMALL PLUS SIGN
unicode_nfkd_qc_no(0xFE63, 0xFE63).	% Pd       SMALL HYPHEN-MINUS
unicode_nfkd_qc_no(0xFE64, 0xFE66).	% Sm   [3] SMALL LESS-THAN SIGN..SMALL EQUALS SIGN
unicode_nfkd_qc_no(0xFE68, 0xFE68).	% Po       SMALL REVERSE SOLIDUS
unicode_nfkd_qc_no(0xFE69, 0xFE69).	% Sc       SMALL DOLLAR SIGN
unicode_nfkd_qc_no(0xFE6A, 0xFE6B).	% Po   [2] SMALL PERCENT SIGN..SMALL COMMERCIAL AT
unicode_nfkd_qc_no(0xFE70, 0xFE72).	% Lo   [3] ARABIC FATHATAN ISOLATED FORM..ARABIC DAMMATAN ISOLATED FORM
unicode_nfkd_qc_no(0xFE74, 0xFE74).	% Lo       ARABIC KASRATAN ISOLATED FORM
unicode_nfkd_qc_no(0xFE76, 0xFEFC).	% Lo [135] ARABIC FATHA ISOLATED FORM..ARABIC LIGATURE LAM WITH ALEF FINAL FORM
unicode_nfkd_qc_no(0xFF01, 0xFF03).	% Po   [3] FULLWIDTH EXCLAMATION MARK..FULLWIDTH NUMBER SIGN
unicode_nfkd_qc_no(0xFF04, 0xFF04).	% Sc       FULLWIDTH DOLLAR SIGN
unicode_nfkd_qc_no(0xFF05, 0xFF07).	% Po   [3] FULLWIDTH PERCENT SIGN..FULLWIDTH APOSTROPHE
unicode_nfkd_qc_no(0xFF08, 0xFF08).	% Ps       FULLWIDTH LEFT PARENTHESIS
unicode_nfkd_qc_no(0xFF09, 0xFF09).	% Pe       FULLWIDTH RIGHT PARENTHESIS
unicode_nfkd_qc_no(0xFF0A, 0xFF0A).	% Po       FULLWIDTH ASTERISK
unicode_nfkd_qc_no(0xFF0B, 0xFF0B).	% Sm       FULLWIDTH PLUS SIGN
unicode_nfkd_qc_no(0xFF0C, 0xFF0C).	% Po       FULLWIDTH COMMA
unicode_nfkd_qc_no(0xFF0D, 0xFF0D).	% Pd       FULLWIDTH HYPHEN-MINUS
unicode_nfkd_qc_no(0xFF0E, 0xFF0F).	% Po   [2] FULLWIDTH FULL STOP..FULLWIDTH SOLIDUS
unicode_nfkd_qc_no(0xFF10, 0xFF19).	% Nd  [10] FULLWIDTH DIGIT ZERO..FULLWIDTH DIGIT NINE
unicode_nfkd_qc_no(0xFF1A, 0xFF1B).	% Po   [2] FULLWIDTH COLON..FULLWIDTH SEMICOLON
unicode_nfkd_qc_no(0xFF1C, 0xFF1E).	% Sm   [3] FULLWIDTH LESS-THAN SIGN..FULLWIDTH GREATER-THAN SIGN
unicode_nfkd_qc_no(0xFF1F, 0xFF20).	% Po   [2] FULLWIDTH QUESTION MARK..FULLWIDTH COMMERCIAL AT
unicode_nfkd_qc_no(0xFF21, 0xFF3A).	% L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
unicode_nfkd_qc_no(0xFF3B, 0xFF3B).	% Ps       FULLWIDTH LEFT SQUARE BRACKET
unicode_nfkd_qc_no(0xFF3C, 0xFF3C).	% Po       FULLWIDTH REVERSE SOLIDUS
unicode_nfkd_qc_no(0xFF3D, 0xFF3D).	% Pe       FULLWIDTH RIGHT SQUARE BRACKET
unicode_nfkd_qc_no(0xFF3E, 0xFF3E).	% Sk       FULLWIDTH CIRCUMFLEX ACCENT
unicode_nfkd_qc_no(0xFF3F, 0xFF3F).	% Pc       FULLWIDTH LOW LINE
unicode_nfkd_qc_no(0xFF40, 0xFF40).	% Sk       FULLWIDTH GRAVE ACCENT
unicode_nfkd_qc_no(0xFF41, 0xFF5A).	% L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
unicode_nfkd_qc_no(0xFF5B, 0xFF5B).	% Ps       FULLWIDTH LEFT CURLY BRACKET
unicode_nfkd_qc_no(0xFF5C, 0xFF5C).	% Sm       FULLWIDTH VERTICAL LINE
unicode_nfkd_qc_no(0xFF5D, 0xFF5D).	% Pe       FULLWIDTH RIGHT CURLY BRACKET
unicode_nfkd_qc_no(0xFF5E, 0xFF5E).	% Sm       FULLWIDTH TILDE
unicode_nfkd_qc_no(0xFF5F, 0xFF5F).	% Ps       FULLWIDTH LEFT WHITE PARENTHESIS
unicode_nfkd_qc_no(0xFF60, 0xFF60).	% Pe       FULLWIDTH RIGHT WHITE PARENTHESIS
unicode_nfkd_qc_no(0xFF61, 0xFF61).	% Po       HALFWIDTH IDEOGRAPHIC FULL STOP
unicode_nfkd_qc_no(0xFF62, 0xFF62).	% Ps       HALFWIDTH LEFT CORNER BRACKET
unicode_nfkd_qc_no(0xFF63, 0xFF63).	% Pe       HALFWIDTH RIGHT CORNER BRACKET
unicode_nfkd_qc_no(0xFF64, 0xFF65).	% Po   [2] HALFWIDTH IDEOGRAPHIC COMMA..HALFWIDTH KATAKANA MIDDLE DOT
unicode_nfkd_qc_no(0xFF66, 0xFF6F).	% Lo  [10] HALFWIDTH KATAKANA LETTER WO..HALFWIDTH KATAKANA LETTER SMALL TU
unicode_nfkd_qc_no(0xFF70, 0xFF70).	% Lm       HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
unicode_nfkd_qc_no(0xFF71, 0xFF9D).	% Lo  [45] HALFWIDTH KATAKANA LETTER A..HALFWIDTH KATAKANA LETTER N
unicode_nfkd_qc_no(0xFF9E, 0xFF9F).	% Lm   [2] HALFWIDTH KATAKANA VOICED SOUND MARK..HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
unicode_nfkd_qc_no(0xFFA0, 0xFFBE).	% Lo  [31] HALFWIDTH HANGUL FILLER..HALFWIDTH HANGUL LETTER HIEUH
unicode_nfkd_qc_no(0xFFC2, 0xFFC7).	% Lo   [6] HALFWIDTH HANGUL LETTER A..HALFWIDTH HANGUL LETTER E
unicode_nfkd_qc_no(0xFFCA, 0xFFCF).	% Lo   [6] HALFWIDTH HANGUL LETTER YEO..HALFWIDTH HANGUL LETTER OE
unicode_nfkd_qc_no(0xFFD2, 0xFFD7).	% Lo   [6] HALFWIDTH HANGUL LETTER YO..HALFWIDTH HANGUL LETTER YU
unicode_nfkd_qc_no(0xFFDA, 0xFFDC).	% Lo   [3] HALFWIDTH HANGUL LETTER EU..HALFWIDTH HANGUL LETTER I
unicode_nfkd_qc_no(0xFFE0, 0xFFE1).	% Sc   [2] FULLWIDTH CENT SIGN..FULLWIDTH POUND SIGN
unicode_nfkd_qc_no(0xFFE2, 0xFFE2).	% Sm       FULLWIDTH NOT SIGN
unicode_nfkd_qc_no(0xFFE3, 0xFFE3).	% Sk       FULLWIDTH MACRON
unicode_nfkd_qc_no(0xFFE4, 0xFFE4).	% So       FULLWIDTH BROKEN BAR
unicode_nfkd_qc_no(0xFFE5, 0xFFE6).	% Sc   [2] FULLWIDTH YEN SIGN..FULLWIDTH WON SIGN
unicode_nfkd_qc_no(0xFFE8, 0xFFE8).	% So       HALFWIDTH FORMS LIGHT VERTICAL
unicode_nfkd_qc_no(0xFFE9, 0xFFEC).	% Sm   [4] HALFWIDTH LEFTWARDS ARROW..HALFWIDTH DOWNWARDS ARROW
unicode_nfkd_qc_no(0xFFED, 0xFFEE).	% So   [2] HALFWIDTH BLACK SQUARE..HALFWIDTH WHITE CIRCLE
unicode_nfkd_qc_no(0x1109A, 0x1109A).	% Lo       KAITHI LETTER DDDHA
unicode_nfkd_qc_no(0x1109C, 0x1109C).	% Lo       KAITHI LETTER RHA
unicode_nfkd_qc_no(0x110AB, 0x110AB).	% Lo       KAITHI LETTER VA
unicode_nfkd_qc_no(0x1112E, 0x1112F).	% Mn   [2] CHAKMA VOWEL SIGN O..CHAKMA VOWEL SIGN AU
unicode_nfkd_qc_no(0x1D15E, 0x1D164).	% So   [7] MUSICAL SYMBOL HALF NOTE..MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE
unicode_nfkd_qc_no(0x1D1BB, 0x1D1C0).	% So   [6] MUSICAL SYMBOL MINIMA..MUSICAL SYMBOL FUSA BLACK
unicode_nfkd_qc_no(0x1D400, 0x1D454).	% L&  [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
unicode_nfkd_qc_no(0x1D456, 0x1D49C).	% L&  [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
unicode_nfkd_qc_no(0x1D49E, 0x1D49F).	% L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
unicode_nfkd_qc_no(0x1D4A2, 0x1D4A2).	% L&       MATHEMATICAL SCRIPT CAPITAL G
unicode_nfkd_qc_no(0x1D4A5, 0x1D4A6).	% L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
unicode_nfkd_qc_no(0x1D4A9, 0x1D4AC).	% L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
unicode_nfkd_qc_no(0x1D4AE, 0x1D4B9).	% L&  [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
unicode_nfkd_qc_no(0x1D4BB, 0x1D4BB).	% L&       MATHEMATICAL SCRIPT SMALL F
unicode_nfkd_qc_no(0x1D4BD, 0x1D4C3).	% L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
unicode_nfkd_qc_no(0x1D4C5, 0x1D505).	% L&  [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
unicode_nfkd_qc_no(0x1D507, 0x1D50A).	% L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
unicode_nfkd_qc_no(0x1D50D, 0x1D514).	% L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
unicode_nfkd_qc_no(0x1D516, 0x1D51C).	% L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
unicode_nfkd_qc_no(0x1D51E, 0x1D539).	% L&  [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
unicode_nfkd_qc_no(0x1D53B, 0x1D53E).	% L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
unicode_nfkd_qc_no(0x1D540, 0x1D544).	% L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
unicode_nfkd_qc_no(0x1D546, 0x1D546).	% L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
unicode_nfkd_qc_no(0x1D54A, 0x1D550).	% L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
unicode_nfkd_qc_no(0x1D552, 0x1D6A5).	% L& [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
unicode_nfkd_qc_no(0x1D6A8, 0x1D6C0).	% L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
unicode_nfkd_qc_no(0x1D6C1, 0x1D6C1).	% Sm       MATHEMATICAL BOLD NABLA
unicode_nfkd_qc_no(0x1D6C2, 0x1D6DA).	% L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
unicode_nfkd_qc_no(0x1D6DB, 0x1D6DB).	% Sm       MATHEMATICAL BOLD PARTIAL DIFFERENTIAL
unicode_nfkd_qc_no(0x1D6DC, 0x1D6FA).	% L&  [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
unicode_nfkd_qc_no(0x1D6FB, 0x1D6FB).	% Sm       MATHEMATICAL ITALIC NABLA
unicode_nfkd_qc_no(0x1D6FC, 0x1D714).	% L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
unicode_nfkd_qc_no(0x1D715, 0x1D715).	% Sm       MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL
unicode_nfkd_qc_no(0x1D716, 0x1D734).	% L&  [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
unicode_nfkd_qc_no(0x1D735, 0x1D735).	% Sm       MATHEMATICAL BOLD ITALIC NABLA
unicode_nfkd_qc_no(0x1D736, 0x1D74E).	% L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
unicode_nfkd_qc_no(0x1D74F, 0x1D74F).	% Sm       MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL
unicode_nfkd_qc_no(0x1D750, 0x1D76E).	% L&  [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
unicode_nfkd_qc_no(0x1D76F, 0x1D76F).	% Sm       MATHEMATICAL SANS-SERIF BOLD NABLA
unicode_nfkd_qc_no(0x1D770, 0x1D788).	% L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
unicode_nfkd_qc_no(0x1D789, 0x1D789).	% Sm       MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL
unicode_nfkd_qc_no(0x1D78A, 0x1D7A8).	% L&  [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
unicode_nfkd_qc_no(0x1D7A9, 0x1D7A9).	% Sm       MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA
unicode_nfkd_qc_no(0x1D7AA, 0x1D7C2).	% L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
unicode_nfkd_qc_no(0x1D7C3, 0x1D7C3).	% Sm       MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL
unicode_nfkd_qc_no(0x1D7C4, 0x1D7CB).	% L&   [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA
unicode_nfkd_qc_no(0x1D7CE, 0x1D7FF).	% Nd  [50] MATHEMATICAL BOLD DIGIT ZERO..MATHEMATICAL MONOSPACE DIGIT NINE
unicode_nfkd_qc_no(0x1EE00, 0x1EE03).	% Lo   [4] ARABIC MATHEMATICAL ALEF..ARABIC MATHEMATICAL DAL
unicode_nfkd_qc_no(0x1EE05, 0x1EE1F).	% Lo  [27] ARABIC MATHEMATICAL WAW..ARABIC MATHEMATICAL DOTLESS QAF
unicode_nfkd_qc_no(0x1EE21, 0x1EE22).	% Lo   [2] ARABIC MATHEMATICAL INITIAL BEH..ARABIC MATHEMATICAL INITIAL JEEM
unicode_nfkd_qc_no(0x1EE24, 0x1EE24).	% Lo       ARABIC MATHEMATICAL INITIAL HEH
unicode_nfkd_qc_no(0x1EE27, 0x1EE27).	% Lo       ARABIC MATHEMATICAL INITIAL HAH
unicode_nfkd_qc_no(0x1EE29, 0x1EE32).	% Lo  [10] ARABIC MATHEMATICAL INITIAL YEH..ARABIC MATHEMATICAL INITIAL QAF
unicode_nfkd_qc_no(0x1EE34, 0x1EE37).	% Lo   [4] ARABIC MATHEMATICAL INITIAL SHEEN..ARABIC MATHEMATICAL INITIAL KHAH
unicode_nfkd_qc_no(0x1EE39, 0x1EE39).	% Lo       ARABIC MATHEMATICAL INITIAL DAD
unicode_nfkd_qc_no(0x1EE3B, 0x1EE3B).	% Lo       ARABIC MATHEMATICAL INITIAL GHAIN
unicode_nfkd_qc_no(0x1EE42, 0x1EE42).	% Lo       ARABIC MATHEMATICAL TAILED JEEM
unicode_nfkd_qc_no(0x1EE47, 0x1EE47).	% Lo       ARABIC MATHEMATICAL TAILED HAH
unicode_nfkd_qc_no(0x1EE49, 0x1EE49).	% Lo       ARABIC MATHEMATICAL TAILED YEH
unicode_nfkd_qc_no(0x1EE4B, 0x1EE4B).	% Lo       ARABIC MATHEMATICAL TAILED LAM
unicode_nfkd_qc_no(0x1EE4D, 0x1EE4F).	% Lo   [3] ARABIC MATHEMATICAL TAILED NOON..ARABIC MATHEMATICAL TAILED AIN
unicode_nfkd_qc_no(0x1EE51, 0x1EE52).	% Lo   [2] ARABIC MATHEMATICAL TAILED SAD..ARABIC MATHEMATICAL TAILED QAF
unicode_nfkd_qc_no(0x1EE54, 0x1EE54).	% Lo       ARABIC MATHEMATICAL TAILED SHEEN
unicode_nfkd_qc_no(0x1EE57, 0x1EE57).	% Lo       ARABIC MATHEMATICAL TAILED KHAH
unicode_nfkd_qc_no(0x1EE59, 0x1EE59).	% Lo       ARABIC MATHEMATICAL TAILED DAD
unicode_nfkd_qc_no(0x1EE5B, 0x1EE5B).	% Lo       ARABIC MATHEMATICAL TAILED GHAIN
unicode_nfkd_qc_no(0x1EE5D, 0x1EE5D).	% Lo       ARABIC MATHEMATICAL TAILED DOTLESS NOON
unicode_nfkd_qc_no(0x1EE5F, 0x1EE5F).	% Lo       ARABIC MATHEMATICAL TAILED DOTLESS QAF
unicode_nfkd_qc_no(0x1EE61, 0x1EE62).	% Lo   [2] ARABIC MATHEMATICAL STRETCHED BEH..ARABIC MATHEMATICAL STRETCHED JEEM
unicode_nfkd_qc_no(0x1EE64, 0x1EE64).	% Lo       ARABIC MATHEMATICAL STRETCHED HEH
unicode_nfkd_qc_no(0x1EE67, 0x1EE6A).	% Lo   [4] ARABIC MATHEMATICAL STRETCHED HAH..ARABIC MATHEMATICAL STRETCHED KAF
unicode_nfkd_qc_no(0x1EE6C, 0x1EE72).	% Lo   [7] ARABIC MATHEMATICAL STRETCHED MEEM..ARABIC MATHEMATICAL STRETCHED QAF
unicode_nfkd_qc_no(0x1EE74, 0x1EE77).	% Lo   [4] ARABIC MATHEMATICAL STRETCHED SHEEN..ARABIC MATHEMATICAL STRETCHED KHAH
unicode_nfkd_qc_no(0x1EE79, 0x1EE7C).	% Lo   [4] ARABIC MATHEMATICAL STRETCHED DAD..ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
unicode_nfkd_qc_no(0x1EE7E, 0x1EE7E).	% Lo       ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
unicode_nfkd_qc_no(0x1EE80, 0x1EE89).	% Lo  [10] ARABIC MATHEMATICAL LOOPED ALEF..ARABIC MATHEMATICAL LOOPED YEH
unicode_nfkd_qc_no(0x1EE8B, 0x1EE9B).	% Lo  [17] ARABIC MATHEMATICAL LOOPED LAM..ARABIC MATHEMATICAL LOOPED GHAIN
unicode_nfkd_qc_no(0x1EEA1, 0x1EEA3).	% Lo   [3] ARABIC MATHEMATICAL DOUBLE-STRUCK BEH..ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
unicode_nfkd_qc_no(0x1EEA5, 0x1EEA9).	% Lo   [5] ARABIC MATHEMATICAL DOUBLE-STRUCK WAW..ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
unicode_nfkd_qc_no(0x1EEAB, 0x1EEBB).	% Lo  [17] ARABIC MATHEMATICAL DOUBLE-STRUCK LAM..ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
unicode_nfkd_qc_no(0x1F100, 0x1F10A).	% No  [11] DIGIT ZERO FULL STOP..DIGIT NINE COMMA
unicode_nfkd_qc_no(0x1F110, 0x1F12E).	% So  [31] PARENTHESIZED LATIN CAPITAL LETTER A..CIRCLED WZ
unicode_nfkd_qc_no(0x1F130, 0x1F14F).	% So  [32] SQUARED LATIN CAPITAL LETTER A..SQUARED WC
unicode_nfkd_qc_no(0x1F16A, 0x1F16B).	% So   [2] RAISED MC SIGN..RAISED MD SIGN
unicode_nfkd_qc_no(0x1F190, 0x1F190).	% So       SQUARE DJ
unicode_nfkd_qc_no(0x1F200, 0x1F202).	% So   [3] SQUARE HIRAGANA HOKA..SQUARED KATAKANA SA
unicode_nfkd_qc_no(0x1F210, 0x1F23A).	% So  [43] SQUARED CJK UNIFIED IDEOGRAPH-624B..SQUARED CJK UNIFIED IDEOGRAPH-55B6
unicode_nfkd_qc_no(0x1F240, 0x1F248).	% So   [9] TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-672C..TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6557
unicode_nfkd_qc_no(0x1F250, 0x1F251).	% So   [2] CIRCLED IDEOGRAPH ADVANTAGE..CIRCLED IDEOGRAPH ACCEPT
unicode_nfkd_qc_no(0x2F800, 0x2FA1D).	% Lo [542] CJK COMPATIBILITY IDEOGRAPH-2F800..CJK COMPATIBILITY IDEOGRAPH-2FA1D

% Total code points: 16880
