﻿:- encoding('UTF-8').

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  This file is part of Logtalk <https://logtalk.org/>
%  SPDX-FileCopyrightText: 1998-2025 Paulo Moura <pmoura@logtalk.org>
%  SPDX-License-Identifier: Apache-2.0
%
%  Licensed under the Apache License, Version 2.0 (the "License");
%  you may not use this file except in compliance with the License.
%  You may obtain a copy of the License at
%
%      http://www.apache.org/licenses/LICENSE-2.0
%
%  Unless required by applicable law or agreed to in writing, software
%  distributed under the License is distributed on an "AS IS" BASIS,
%  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%  See the License for the specific language governing permissions and
%  limitations under the License.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


:- object(tests,
	extends(lgtunit)).

	:- info([
		version is 1:3:0,
		author is 'Paulo Moura',
		date is 2021-08-02,
		comment is 'Unit tests for the encoding/1 built-in directive.'
	]).

	test(encoding_1_us_ascii) :-
		^^file_path('us_ascii.lgt', Path),
		logtalk_load(Path),
		logtalk::loaded_file_property(Path, text_properties(Properties)),
		member(encoding('US-ASCII'), Properties),
		\+ member(encoding('UTF-8'), Properties).

	test(encoding_1_iso_8859_1) :-
		^^file_path('iso_8859_1.lgt', Path),
		% avoid printing expected warnings
		logtalk_load(Path, [report(off)]),
		logtalk::loaded_file_property(Path, text_properties(Properties)),
		member(encoding('ISO-8859-1'), Properties),
		\+ member(encoding('UTF-8'), Properties).

	test(encoding_1_utf_8_bom) :-
		^^file_path('utf_8_bom.lgt', Path),
		logtalk_load(Path),
		logtalk::loaded_file_property(Path, text_properties(Properties)),
		member(encoding('UTF-8'), Properties),
		member(bom(true), Properties).

	test(encoding_1_utf_8_no_bom) :-
		^^file_path('utf_8_no_bom.lgt', Path),
		logtalk_load(Path),
		logtalk::loaded_file_property(Path, text_properties(Properties)),
		member(encoding('UTF-8'), Properties),
		\+ member(bom(true), Properties).

	test(encoding_1_includes) :-
		findall(Name, split::name(Name), Names),
		^^assertion(
			Names == [
				'Paulo Moura', 'John Smith',
				'António Simões', 'Cátia Conceição',
				'João Raínho', 'Luís Araújo'
			]
		).

	% auxiliary predicates

	member(Element, [Head| _]) :-
		Element == Head,
		!.
	member(Element, [_| Tail]) :-
		member(Element, Tail).

:- end_object.
