// LimeChat is copyrighted free software by Satoshi Nakagawa <psychs AT limechat DOT net>.
// You can redistribute it and/or modify it under the terms of the GPL version 2 (see the file GPL.txt).

#import "MemberListViewCell.h"


#define LEFT_MARGIN         2
#define MARK_RIGHT_MARGIN   2


static OtherTheme* theme;
static int markWidth;
static NSMutableParagraphStyle* markStyle;
static NSMutableParagraphStyle* nickStyle;


@implementation MemberListViewCell

- (id)init
{
    self = [super init];
    if (self) {
    }
    return self;
}

- (id)copyWithZone:(NSZone *)zone
{
    MemberListViewCell* c = [[MemberListViewCell alloc] init];
    c.font = self.font;
    c.member = _member;
    return c;
}

- (void)calculateMarkWidth
{
    markWidth = 0;

    NSDictionary* style = [NSDictionary dictionaryWithObject:self.font forKey:NSFontAttributeName];
    NSArray* marks = [NSArray arrayWithObjects:@"~", @"&", @"@", @"%", @"+", nil];

    for (NSString* s in marks) {
        NSSize size = [s sizeWithAttributes:style];
        int width = ceil(size.width);
        if (markWidth < width) {
            markWidth = width;
        }
    }
}

- (void)setup:(id)aTheme
{
    theme = aTheme;

    if (!markStyle) {
        markStyle = [NSMutableParagraphStyle new];
        [markStyle setAlignment:NSTextAlignmentCenter];
    }

    if (!nickStyle) {
        nickStyle = [NSMutableParagraphStyle new];
        [nickStyle setAlignment:NSTextAlignmentLeft];
        [nickStyle setLineBreakMode:NSLineBreakByTruncatingTail];
    }
}

- (void)themeChanged
{
    [self calculateMarkWidth];
}

- (void)drawInteriorWithFrame:(NSRect)frame inView:(NSView*)view
{
    NSWindow* window = view.window;
    NSColor* color = nil;

    if ([self isHighlighted]) {
        if (window && [window isMainWindow] && [window firstResponder] == view) {
            color = [theme memberListSelColor] ?: [NSColor alternateSelectedControlTextColor];
        }
        else {
            color = [theme memberListSelColor] ?: [NSColor selectedControlTextColor];
        }
    }
    else if ([_member isOp]) {
        color = [theme memberListOpColor];
    }
    else {
        color = [theme memberListColor];
    }

    NSMutableDictionary* style = [NSMutableDictionary dictionary];
    [style setObject:markStyle forKey:NSParagraphStyleAttributeName];
    [style setObject:self.font forKey:NSFontAttributeName];
    [style setObject:color forKey:NSForegroundColorAttributeName];

    NSRect rect = frame;
    rect.origin.x += LEFT_MARGIN;
    rect.size.width = markWidth;

    UniChar mark = [_member mark];
    if (mark != INVALID_MARK_CHAR) {
        NSString* markStr = [NSString stringWithFormat:@"%C", mark];
        [markStr drawInRect:rect withAttributes:style];
    }

    [style setObject:nickStyle forKey:NSParagraphStyleAttributeName];

    int offset = LEFT_MARGIN + markWidth + MARK_RIGHT_MARGIN;

    rect = frame;
    rect.origin.x += offset;
    rect.size.width -= offset;

    NSString* nick = [_member nick];
    [nick drawInRect:rect withAttributes:style];
}

@end
