#ifndef GAZETTEERS_H
#define GAZETTEERS_H


 

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

#include "klib/kvec.h"
#include "libpostal.h"
#include "vector.h"

typedef enum dictionary_type {
    DICTIONARY_ANY = 1,
    DICTIONARY_SYNONYM = 2,
    DICTIONARY_STOPWORD = 3,
    DICTIONARY_ELISION = 4,
    DICTIONARY_AMBIGUOUS_EXPANSION = 5,

    DICTIONARY_STREET_NAME = 10,
    DICTIONARY_STREET_TYPE = 11,
    DICTIONARY_CONCATENATED_PREFIX_SEPARABLE = 12,
    DICTIONARY_CONCATENATED_SUFFIX_SEPARABLE = 13,
    DICTIONARY_CONCATENATED_SUFFIX_INSEPARABLE = 14,
    DICTIONARY_DIRECTIONAL = 15,
    DICTIONARY_QUALIFIER = 16,
    DICTIONARY_BUILDING_TYPE = 17,
    DICTIONARY_LEVEL_NUMBERED = 18,
    DICTIONARY_LEVEL_STANDALONE = 19,
    DICTIONARY_LEVEL_MEZZANINE = 20,
    DICTIONARY_LEVEL_BASEMENT = 21,
    DICTIONARY_LEVEL_SUB_BASEMENT = 22,
    DICTIONARY_UNIT_NUMBERED = 23,
    DICTIONARY_UNIT_STANDALONE = 24,
    DICTIONARY_UNIT_DIRECTION = 25,
    DICTIONARY_ENTRANCE = 26,
    DICTIONARY_STAIRCASE = 27,

    DICTIONARY_NUMBER = 30,
    DICTIONARY_NO_NUMBER = 31,
    DICTIONARY_HOUSE_NUMBER = 32,
    DICTIONARY_POST_OFFICE = 33,
    DICTIONARY_POSTCODE = 34,

    DICTIONARY_PLACE_NAME = 50,
    DICTIONARY_COMPANY_TYPE = 51,
    DICTIONARY_GIVEN_NAME = 52,
    DICTIONARY_SURNAME = 53,
    DICTIONARY_PERSONAL_TITLE = 54,
    DICTIONARY_PERSONAL_SUFFIX = 55,
    DICTIONARY_ACADEMIC_DEGREE = 56,

    DICTIONARY_NAMED_PERSON = 60,
    DICTIONARY_NAMED_ORGANIZATION = 61,

    DICTIONARY_CATEGORY = 70,
    DICTIONARY_CHAIN = 71,
    DICTIONARY_NEAR = 72,

    DICTIONARY_CROSS_STREET = 80,

    DICTIONARY_NULL = 90,

    DICTIONARY_TOPONYM = 100,
    DICTIONARY_POSTAL_CODE = 101,

} dictionary_type_t;

typedef struct gazetteer {
    dictionary_type_t type;
    uint16_t address_components;
} gazetteer_t;


 

#endif

