# hsts

* [Name](#Name)
* [Synopsis](#Synopsis)
* [Description](#Description)
* [Options](#Options)
* [See Also](#See Also)
* [Author](#Author)
* [Copyright](#Copyright)


# <a name="Name"/>Name

  hsts - Explore the HSTS Preload data

# <a name="Synopsis"/>Synopsis

  hsts [options] <domains...>

# <a name="Description"/>Description

  `hsts' explores the HSTS Preload list.  It takes a list of domains on the command line, or if no domains are present on
  the command line, it reads one domain per line from standard input.  It prints its results  to  standard  output,  with
  each line containing one domain followed by a colon, followed by the relevant information for that domain.

# <a name="Options"/>Options

  The general usage is `hsts [options] <domains...>`.

  Without options `hsts` prints either 0 or 1 for each given domain to say whether the domain supports
  HTTPS or not.

  If no domain is given, `hsts` reads from STDIN with each line being one domain name.

  Available options are:

## `--load-hsts-file <filename>`

  Load HSTS data from `filename`.
  
  The file format must be DAFSA binary as generated by `make-hsts-dafsa --output-format=binary <infile> <outfile>`.

## `--include-subdomains`

  Check whether the given domains have the `include_subdomains` attribute or not.

## `-b`, `--batch`

  Suppress printing of leading domain name (might ease scripting).


# <a name="See also"/>See also

   https://www.chromium.org/hsts/

   https://en.wikipedia.org/wiki/HTTP_Strict_Transport_Security

   https://gitlab.com/rockdaboot/libhsts

# <a name="Author"/>Author

  `hsts` has been written by Tim Rühsen <tim.ruehsen@gmx.de>

# <a name="Copyright"/>Copyright

  `libhsts` and `hsts` are copyright © 2018 Tim Rühsen under an MIT-style License.
