/**
 * @file
 * @brief Function prototypes for the new opcode functions.
 * @note  DO NOT EDIT THIS FILE, your changes will be lost.
 *        Edit ir/be/arm/arm_spec.pl instead.
 *        created by: ir/be/scripts/generate_new_opcodes.pl ir/be/arm/arm_spec.pl ir/be/arm
 * @date  Mon Nov 19 18:12:23 2012
 */
#ifndef FIRM_BE_ARM_GEN_ARM_NEW_NODES_H
#define FIRM_BE_ARM_GEN_ARM_NEW_NODES_H

typedef enum arm_opcodes {
	iro_arm_fConst,
	iro_arm_Mvf,
	iro_arm_Ldr,
	iro_arm_Rsb,
	iro_arm_Mla,
	iro_arm_LinkMovPC,
	iro_arm_Mov,
	iro_arm_FltX,
	iro_arm_Or,
	iro_arm_EmptyReg,
	iro_arm_Cmp,
	iro_arm_Smull,
	iro_arm_Add,
	iro_arm_LinkLdrPC,
	iro_arm_Ldf,
	iro_arm_Mvn,
	iro_arm_B,
	iro_arm_LoadStackM3Epilogue,
	iro_arm_Tst,
	iro_arm_Umull,
	iro_arm_Bic,
	iro_arm_Sub,
	iro_arm_Mul,
	iro_arm_Adf,
	iro_arm_Bl,
	iro_arm_Stf,
	iro_arm_Clz,
	iro_arm_Suf,
	iro_arm_Cmfe,
	iro_arm_CopyB,
	iro_arm_FrameAddr,
	iro_arm_And,
	iro_arm_Str,
	iro_arm_Dvf,
	iro_arm_SwitchJmp,
	iro_arm_StoreStackM4Inc,
	iro_arm_Muf,
	iro_arm_SymConst,
	iro_arm_Eor,
	iro_arm_Jmp,
	iro_arm_last_generated,
	iro_arm_last = iro_arm_last_generated
} arm_opcodes;

int is_arm_irn(const ir_node *node);
int is_arm_op(const ir_op *op);

int get_arm_opcode_first(void);
int get_arm_opcode_last(void);
int get_arm_irn_opcode(const ir_node *node);
void arm_create_opcodes(const arch_irn_ops_t *be_ops);
void arm_free_opcodes(void);
extern ir_op *op_arm_fConst;
ir_op *get_op_arm_fConst(void);
int is_arm_fConst(const ir_node *n);
/**
 * construct fConst node
 */
ir_node *new_bd_arm_fConst(dbg_info *dbgi, ir_node *block, ir_tarval *tv);

extern ir_op *op_arm_Mvf;
ir_op *get_op_arm_Mvf(void);
int is_arm_Mvf(const ir_node *n);
/**
 * construct Mvf node
 */
ir_node *new_bd_arm_Mvf(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *op_mode);

extern ir_op *op_arm_Ldr;
ir_op *get_op_arm_Ldr(void);
int is_arm_Ldr(const ir_node *n);
/**
 * construct Ldr node
 */
ir_node *new_bd_arm_Ldr(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int entity_sign, long offset, bool is_frame_entity);

extern ir_op *op_arm_Rsb;
ir_op *get_op_arm_Rsb(void);
int is_arm_Rsb(const ir_node *n);
/**
 * construct Rsb node
 */
ir_node *new_bd_arm_Rsb_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot);
/**
 * construct Rsb node
 */
ir_node *new_bd_arm_Rsb_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate);
/**
 * construct Rsb node
 */
ir_node *new_bd_arm_Rsb_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);
/**
 * construct Rsb node
 */
ir_node *new_bd_arm_Rsb_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier);

extern ir_op *op_arm_Mla;
ir_op *get_op_arm_Mla(void);
int is_arm_Mla(const ir_node *n);
/**
 * construct Mla node
 */
ir_node *new_bd_arm_Mla(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2);

extern ir_op *op_arm_LinkMovPC;
ir_op *get_op_arm_LinkMovPC(void);
int is_arm_LinkMovPC(const ir_node *n);
/**
 * construct LinkMovPC node
 */
ir_node *new_bd_arm_LinkMovPC(dbg_info *dbgi, ir_node *block, int arity, ir_node *in[], int n_res, arm_shift_modifier_t shift_modifier, unsigned char immediate_value, unsigned char immediate_rot);

extern ir_op *op_arm_Mov;
ir_op *get_op_arm_Mov(void);
int is_arm_Mov(const ir_node *n);
/**
 * construct Mov node
 */
ir_node *new_bd_arm_Mov_imm(dbg_info *dbgi, ir_node *block, unsigned char immediate_value, unsigned char immediate_rot);
/**
 * construct Mov node
 */
ir_node *new_bd_arm_Mov_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *op0, arm_shift_modifier_t shift_modifier, unsigned shift_immediate);
/**
 * construct Mov node
 */
ir_node *new_bd_arm_Mov_reg(dbg_info *dbgi, ir_node *block, ir_node *op0);
/**
 * construct Mov node
 */
ir_node *new_bd_arm_Mov_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, arm_shift_modifier_t shift_modifier);

extern ir_op *op_arm_FltX;
ir_op *get_op_arm_FltX(void);
int is_arm_FltX(const ir_node *n);
/**
 * construct FltX node
 */
ir_node *new_bd_arm_FltX(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *op_mode);

extern ir_op *op_arm_Or;
ir_op *get_op_arm_Or(void);
int is_arm_Or(const ir_node *n);
/**
 * construct Or node
 */
ir_node *new_bd_arm_Or_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot);
/**
 * construct Or node
 */
ir_node *new_bd_arm_Or_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate);
/**
 * construct Or node
 */
ir_node *new_bd_arm_Or_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);
/**
 * construct Or node
 */
ir_node *new_bd_arm_Or_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier);

extern ir_op *op_arm_EmptyReg;
ir_op *get_op_arm_EmptyReg(void);
int is_arm_EmptyReg(const ir_node *n);
/**
 * construct EmptyReg node
 */
ir_node *new_bd_arm_EmptyReg(dbg_info *dbgi, ir_node *block);

extern ir_op *op_arm_Cmp;
ir_op *get_op_arm_Cmp(void);
int is_arm_Cmp(const ir_node *n);
/**
 * construct Cmp node
 */
ir_node *new_bd_arm_Cmp_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot, bool ins_permuted, bool is_unsigned);
/**
 * construct Cmp node
 */
ir_node *new_bd_arm_Cmp_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate, bool ins_permuted, bool is_unsigned);
/**
 * construct Cmp node
 */
ir_node *new_bd_arm_Cmp_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, bool ins_permuted, bool is_unsigned);
/**
 * construct Cmp node
 */
ir_node *new_bd_arm_Cmp_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier, bool ins_permuted, bool is_unsigned);

extern ir_op *op_arm_Smull;
ir_op *get_op_arm_Smull(void);
int is_arm_Smull(const ir_node *n);
/**
 * construct Smull node
 */
ir_node *new_bd_arm_Smull(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_arm_Add;
ir_op *get_op_arm_Add(void);
int is_arm_Add(const ir_node *n);
/**
 * construct Add node
 */
ir_node *new_bd_arm_Add_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot);
/**
 * construct Add node
 */
ir_node *new_bd_arm_Add_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate);
/**
 * construct Add node
 */
ir_node *new_bd_arm_Add_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);
/**
 * construct Add node
 */
ir_node *new_bd_arm_Add_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier);

extern ir_op *op_arm_LinkLdrPC;
ir_op *get_op_arm_LinkLdrPC(void);
int is_arm_LinkLdrPC(const ir_node *n);
/**
 * construct LinkLdrPC node
 */
ir_node *new_bd_arm_LinkLdrPC(dbg_info *dbgi, ir_node *block, int arity, ir_node *in[], int n_res, ir_mode *ls_mode, ir_entity *entity, int entity_sign, long offset, bool is_frame_entity);

extern ir_op *op_arm_Ldf;
ir_op *get_op_arm_Ldf(void);
int is_arm_Ldf(const ir_node *n);
/**
 * construct Ldf node
 */
ir_node *new_bd_arm_Ldf(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int entity_sign, long offset, bool is_frame_entity);

extern ir_op *op_arm_Mvn;
ir_op *get_op_arm_Mvn(void);
int is_arm_Mvn(const ir_node *n);
/**
 * construct Mvn node
 */
ir_node *new_bd_arm_Mvn_imm(dbg_info *dbgi, ir_node *block, unsigned char immediate_value, unsigned char immediate_rot);
/**
 * construct Mvn node
 */
ir_node *new_bd_arm_Mvn_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *op0, arm_shift_modifier_t shift_modifier, unsigned shift_immediate);
/**
 * construct Mvn node
 */
ir_node *new_bd_arm_Mvn_reg(dbg_info *dbgi, ir_node *block, ir_node *op0);
/**
 * construct Mvn node
 */
ir_node *new_bd_arm_Mvn_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, arm_shift_modifier_t shift_modifier);

extern ir_op *op_arm_B;
ir_op *get_op_arm_B(void);
int is_arm_B(const ir_node *n);
/**
 * construct B node
 */
ir_node *new_bd_arm_B(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_relation relation);

extern ir_op *op_arm_LoadStackM3Epilogue;
ir_op *get_op_arm_LoadStackM3Epilogue(void);
int is_arm_LoadStackM3Epilogue(const ir_node *n);
/**
 * construct LoadStackM3Epilogue node
 */
ir_node *new_bd_arm_LoadStackM3Epilogue(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_arm_Tst;
ir_op *get_op_arm_Tst(void);
int is_arm_Tst(const ir_node *n);
/**
 * construct Tst node
 */
ir_node *new_bd_arm_Tst_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot, bool ins_permuted, bool is_unsigned);
/**
 * construct Tst node
 */
ir_node *new_bd_arm_Tst_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate, bool ins_permuted, bool is_unsigned);
/**
 * construct Tst node
 */
ir_node *new_bd_arm_Tst_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, bool ins_permuted, bool is_unsigned);
/**
 * construct Tst node
 */
ir_node *new_bd_arm_Tst_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier, bool ins_permuted, bool is_unsigned);

extern ir_op *op_arm_Umull;
ir_op *get_op_arm_Umull(void);
int is_arm_Umull(const ir_node *n);
/**
 * construct Umull node
 */
ir_node *new_bd_arm_Umull(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_arm_Bic;
ir_op *get_op_arm_Bic(void);
int is_arm_Bic(const ir_node *n);
/**
 * construct Bic node
 */
ir_node *new_bd_arm_Bic_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot);
/**
 * construct Bic node
 */
ir_node *new_bd_arm_Bic_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate);
/**
 * construct Bic node
 */
ir_node *new_bd_arm_Bic_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);
/**
 * construct Bic node
 */
ir_node *new_bd_arm_Bic_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier);

extern ir_op *op_arm_Sub;
ir_op *get_op_arm_Sub(void);
int is_arm_Sub(const ir_node *n);
/**
 * construct Sub node
 */
ir_node *new_bd_arm_Sub_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot);
/**
 * construct Sub node
 */
ir_node *new_bd_arm_Sub_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate);
/**
 * construct Sub node
 */
ir_node *new_bd_arm_Sub_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);
/**
 * construct Sub node
 */
ir_node *new_bd_arm_Sub_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier);

extern ir_op *op_arm_Mul;
ir_op *get_op_arm_Mul(void);
int is_arm_Mul(const ir_node *n);
/**
 * construct Mul node
 */
ir_node *new_bd_arm_Mul(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_arm_Adf;
ir_op *get_op_arm_Adf(void);
int is_arm_Adf(const ir_node *n);
/**
 * construct Adf node
 */
ir_node *new_bd_arm_Adf(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode);

extern ir_op *op_arm_Bl;
ir_op *get_op_arm_Bl(void);
int is_arm_Bl(const ir_node *n);
/**
 * construct Bl node
 */
ir_node *new_bd_arm_Bl(dbg_info *dbgi, ir_node *block, int arity, ir_node *in[], int n_res, ir_entity *entity, int symconst_offset);

extern ir_op *op_arm_Stf;
ir_op *get_op_arm_Stf(void);
int is_arm_Stf(const ir_node *n);
/**
 * construct Stf node
 */
ir_node *new_bd_arm_Stf(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *val, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int entity_sign, long offset, bool is_frame_entity);

extern ir_op *op_arm_Clz;
ir_op *get_op_arm_Clz(void);
int is_arm_Clz(const ir_node *n);
/**
 * construct Clz node
 */
ir_node *new_bd_arm_Clz(dbg_info *dbgi, ir_node *block, ir_node *op0);

extern ir_op *op_arm_Suf;
ir_op *get_op_arm_Suf(void);
int is_arm_Suf(const ir_node *n);
/**
 * construct Suf node
 */
ir_node *new_bd_arm_Suf(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode);

extern ir_op *op_arm_Cmfe;
ir_op *get_op_arm_Cmfe(void);
int is_arm_Cmfe(const ir_node *n);
/**
 * construct Cmfe node
 */
ir_node *new_bd_arm_Cmfe(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, bool ins_permuted);

extern ir_op *op_arm_CopyB;
ir_op *get_op_arm_CopyB(void);
int is_arm_CopyB(const ir_node *n);
/**
 * construct CopyB node
 */
ir_node *new_bd_arm_CopyB(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_node *op3, ir_node *op4, ir_node *op5, unsigned size);

extern ir_op *op_arm_FrameAddr;
ir_op *get_op_arm_FrameAddr(void);
int is_arm_FrameAddr(const ir_node *n);
/**
 * construct FrameAddr node
 */
ir_node *new_bd_arm_FrameAddr(dbg_info *dbgi, ir_node *block, ir_node *base, ir_entity *entity, int symconst_offset);

extern ir_op *op_arm_And;
ir_op *get_op_arm_And(void);
int is_arm_And(const ir_node *n);
/**
 * construct And node
 */
ir_node *new_bd_arm_And_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot);
/**
 * construct And node
 */
ir_node *new_bd_arm_And_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate);
/**
 * construct And node
 */
ir_node *new_bd_arm_And_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);
/**
 * construct And node
 */
ir_node *new_bd_arm_And_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier);

extern ir_op *op_arm_Str;
ir_op *get_op_arm_Str(void);
int is_arm_Str(const ir_node *n);
/**
 * construct Str node
 */
ir_node *new_bd_arm_Str(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *val, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int entity_sign, long offset, bool is_frame_entity);

extern ir_op *op_arm_Dvf;
ir_op *get_op_arm_Dvf(void);
int is_arm_Dvf(const ir_node *n);
/**
 * construct Dvf node
 */
ir_node *new_bd_arm_Dvf(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode);

extern ir_op *op_arm_SwitchJmp;
ir_op *get_op_arm_SwitchJmp(void);
int is_arm_SwitchJmp(const ir_node *n);
/**
 * construct SwitchJmp node
 */
ir_node *new_bd_arm_SwitchJmp(dbg_info *dbgi, ir_node *block, ir_node *op0, int n_res, const ir_switch_table *table);

extern ir_op *op_arm_StoreStackM4Inc;
ir_op *get_op_arm_StoreStackM4Inc(void);
int is_arm_StoreStackM4Inc(const ir_node *n);
/**
 * construct StoreStackM4Inc node
 */
ir_node *new_bd_arm_StoreStackM4Inc(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_node *op3, ir_node *op4, ir_node *op5);

extern ir_op *op_arm_Muf;
ir_op *get_op_arm_Muf(void);
int is_arm_Muf(const ir_node *n);
/**
 * construct Muf node
 */
ir_node *new_bd_arm_Muf(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode);

extern ir_op *op_arm_SymConst;
ir_op *get_op_arm_SymConst(void);
int is_arm_SymConst(const ir_node *n);
/**
 * construct SymConst node
 */
ir_node *new_bd_arm_SymConst(dbg_info *dbgi, ir_node *block, ir_entity *entity, int symconst_offset);

extern ir_op *op_arm_Eor;
ir_op *get_op_arm_Eor(void);
int is_arm_Eor(const ir_node *n);
/**
 * construct Eor node
 */
ir_node *new_bd_arm_Eor_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot);
/**
 * construct Eor node
 */
ir_node *new_bd_arm_Eor_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate);
/**
 * construct Eor node
 */
ir_node *new_bd_arm_Eor_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);
/**
 * construct Eor node
 */
ir_node *new_bd_arm_Eor_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier);

extern ir_op *op_arm_Jmp;
ir_op *get_op_arm_Jmp(void);
int is_arm_Jmp(const ir_node *n);
/**
 * construct Jmp node
 */
ir_node *new_bd_arm_Jmp(dbg_info *dbgi, ir_node *block);



enum pn_arm_Ldr {
	pn_arm_Ldr_res = 0,
	pn_arm_Ldr_M = 1,
};

enum n_arm_Ldr {
	n_arm_Ldr_ptr = 0,
	n_arm_Ldr_mem = 1,
};

enum pn_arm_Smull {
	pn_arm_Smull_low = 0,
	pn_arm_Smull_high = 1,
};

enum pn_arm_Ldf {
	pn_arm_Ldf_res = 0,
	pn_arm_Ldf_M = 1,
};

enum n_arm_Ldf {
	n_arm_Ldf_ptr = 0,
	n_arm_Ldf_mem = 1,
};

enum pn_arm_LoadStackM3Epilogue {
	pn_arm_LoadStackM3Epilogue_res0 = 0,
	pn_arm_LoadStackM3Epilogue_res1 = 1,
	pn_arm_LoadStackM3Epilogue_res2 = 2,
	pn_arm_LoadStackM3Epilogue_M = 3,
};

enum pn_arm_Umull {
	pn_arm_Umull_low = 0,
	pn_arm_Umull_high = 1,
};

enum pn_arm_Stf {
	pn_arm_Stf_M = 0,
};

enum n_arm_Stf {
	n_arm_Stf_ptr = 0,
	n_arm_Stf_val = 1,
	n_arm_Stf_mem = 2,
};

enum pn_arm_CopyB {
	pn_arm_CopyB_M = 0,
};

enum n_arm_FrameAddr {
	n_arm_FrameAddr_base = 0,
};

enum pn_arm_Str {
	pn_arm_Str_M = 0,
};

enum n_arm_Str {
	n_arm_Str_ptr = 0,
	n_arm_Str_val = 1,
	n_arm_Str_mem = 2,
};

enum pn_arm_Dvf {
	pn_arm_Dvf_res = 0,
	pn_arm_Dvf_M = 1,
};

enum pn_arm_StoreStackM4Inc {
	pn_arm_StoreStackM4Inc_ptr = 0,
	pn_arm_StoreStackM4Inc_M = 1,
};


#endif
