#include "gen_TEMPLATE_regalloc_if.h"
#include "irverify_t.h"
#include "fourcc.h"

static int cmp_attr_TEMPLATE_fConst(const ir_node *a, const ir_node *b) {
	(void) a;
	(void) b;
	
	/* TODO: compare fConst attributes */
	return 1;

}

static int cmp_attr_TEMPLATE_Const(const ir_node *a, const ir_node *b) {
	(void) a;
	(void) b;
	
	/* TODO: compare Const attributes */
    return 1;

}


ir_op *op_TEMPLATE_fConst = NULL;
ir_op *op_TEMPLATE_Shr = NULL;
ir_op *op_TEMPLATE_fMul = NULL;
ir_op *op_TEMPLATE_Start = NULL;
ir_op *op_TEMPLATE_Or = NULL;
ir_op *op_TEMPLATE_Xor = NULL;
ir_op *op_TEMPLATE_fAdd = NULL;
ir_op *op_TEMPLATE_Not = NULL;
ir_op *op_TEMPLATE_Shl = NULL;
ir_op *op_TEMPLATE_Return = NULL;
ir_op *op_TEMPLATE_fMinus = NULL;
ir_op *op_TEMPLATE_Add = NULL;
ir_op *op_TEMPLATE_Store = NULL;
ir_op *op_TEMPLATE_And = NULL;
ir_op *op_TEMPLATE_fStore = NULL;
ir_op *op_TEMPLATE_fLoad = NULL;
ir_op *op_TEMPLATE_fSub = NULL;
ir_op *op_TEMPLATE_Minus = NULL;
ir_op *op_TEMPLATE_fDiv = NULL;
ir_op *op_TEMPLATE_Const = NULL;
ir_op *op_TEMPLATE_Sub = NULL;
ir_op *op_TEMPLATE_Load = NULL;
ir_op *op_TEMPLATE_Mul = NULL;
ir_op *op_TEMPLATE_Jmp = NULL;

ir_op *get_op_TEMPLATE_fConst(void)         { return op_TEMPLATE_fConst; }
int    is_TEMPLATE_fConst(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fConst; }

ir_op *get_op_TEMPLATE_Shr(void)         { return op_TEMPLATE_Shr; }
int    is_TEMPLATE_Shr(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Shr; }

ir_op *get_op_TEMPLATE_fMul(void)         { return op_TEMPLATE_fMul; }
int    is_TEMPLATE_fMul(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fMul; }

ir_op *get_op_TEMPLATE_Start(void)         { return op_TEMPLATE_Start; }
int    is_TEMPLATE_Start(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Start; }

ir_op *get_op_TEMPLATE_Or(void)         { return op_TEMPLATE_Or; }
int    is_TEMPLATE_Or(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Or; }

ir_op *get_op_TEMPLATE_Xor(void)         { return op_TEMPLATE_Xor; }
int    is_TEMPLATE_Xor(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Xor; }

ir_op *get_op_TEMPLATE_fAdd(void)         { return op_TEMPLATE_fAdd; }
int    is_TEMPLATE_fAdd(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fAdd; }

ir_op *get_op_TEMPLATE_Not(void)         { return op_TEMPLATE_Not; }
int    is_TEMPLATE_Not(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Not; }

ir_op *get_op_TEMPLATE_Shl(void)         { return op_TEMPLATE_Shl; }
int    is_TEMPLATE_Shl(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Shl; }

ir_op *get_op_TEMPLATE_Return(void)         { return op_TEMPLATE_Return; }
int    is_TEMPLATE_Return(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Return; }

ir_op *get_op_TEMPLATE_fMinus(void)         { return op_TEMPLATE_fMinus; }
int    is_TEMPLATE_fMinus(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fMinus; }

ir_op *get_op_TEMPLATE_Add(void)         { return op_TEMPLATE_Add; }
int    is_TEMPLATE_Add(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Add; }

ir_op *get_op_TEMPLATE_Store(void)         { return op_TEMPLATE_Store; }
int    is_TEMPLATE_Store(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Store; }

ir_op *get_op_TEMPLATE_And(void)         { return op_TEMPLATE_And; }
int    is_TEMPLATE_And(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_And; }

ir_op *get_op_TEMPLATE_fStore(void)         { return op_TEMPLATE_fStore; }
int    is_TEMPLATE_fStore(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fStore; }

ir_op *get_op_TEMPLATE_fLoad(void)         { return op_TEMPLATE_fLoad; }
int    is_TEMPLATE_fLoad(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fLoad; }

ir_op *get_op_TEMPLATE_fSub(void)         { return op_TEMPLATE_fSub; }
int    is_TEMPLATE_fSub(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fSub; }

ir_op *get_op_TEMPLATE_Minus(void)         { return op_TEMPLATE_Minus; }
int    is_TEMPLATE_Minus(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Minus; }

ir_op *get_op_TEMPLATE_fDiv(void)         { return op_TEMPLATE_fDiv; }
int    is_TEMPLATE_fDiv(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fDiv; }

ir_op *get_op_TEMPLATE_Const(void)         { return op_TEMPLATE_Const; }
int    is_TEMPLATE_Const(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Const; }

ir_op *get_op_TEMPLATE_Sub(void)         { return op_TEMPLATE_Sub; }
int    is_TEMPLATE_Sub(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Sub; }

ir_op *get_op_TEMPLATE_Load(void)         { return op_TEMPLATE_Load; }
int    is_TEMPLATE_Load(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Load; }

ir_op *get_op_TEMPLATE_Mul(void)         { return op_TEMPLATE_Mul; }
int    is_TEMPLATE_Mul(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Mul; }

ir_op *get_op_TEMPLATE_Jmp(void)         { return op_TEMPLATE_Jmp; }
int    is_TEMPLATE_Jmp(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Jmp; }



static int TEMPLATE_opcode_start = -1;
static int TEMPLATE_opcode_end   = -1;


/** A tag for the TEMPLATE opcodes. Note that the address is used as a tag value, NOT the FOURCC code. */
#define TEMPLATE_op_tag FOURCC('T', 'E', 'M', 'P')

/** Return the opcode number of the first TEMPLATE opcode. */
int get_TEMPLATE_opcode_first(void) {
	return TEMPLATE_opcode_start;
}

/** Return the opcode number of the last TEMPLATE opcode + 1. */
int get_TEMPLATE_opcode_last(void) {
	return TEMPLATE_opcode_end;
}

/** Return 1 if the given opcode is a TEMPLATE machine op, 0 otherwise */
int is_TEMPLATE_op(const ir_op *op) {
	return get_op_tag(op) == TEMPLATE_op_tag;
}

/** Return 1 if the given node is a TEMPLATE machine node, 0 otherwise */
int is_TEMPLATE_irn(const ir_node *node) {
	return is_TEMPLATE_op(get_irn_op(node));
}

int get_TEMPLATE_irn_opcode(const ir_node *node) {
	if (is_TEMPLATE_irn(node))
		return get_irn_opcode(node) - TEMPLATE_opcode_start;
	return -1;
}

#ifdef BIT
#undef BIT
#endif
#define BIT(x)  (1 << (x))

static const unsigned TEMPLATE_limit_gp_sp[] = { BIT(REG_GP_SP), 0 };

static const arch_register_req_t TEMPLATE_requirements_fp_fp = {
	arch_register_req_type_normal,
	& TEMPLATE_reg_classes[CLASS_TEMPLATE_fp],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0,           /* different pos */
	1            /* width */
};


static const arch_register_req_t TEMPLATE_requirements_gp_gp = {
	arch_register_req_type_normal,
	& TEMPLATE_reg_classes[CLASS_TEMPLATE_gp],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0,           /* different pos */
	1            /* width */
};


static const arch_register_req_t TEMPLATE_requirements_gp_in_r1 = {
	arch_register_req_type_should_be_same,
	& TEMPLATE_reg_classes[CLASS_TEMPLATE_gp],
	NULL,
	1,        /* same pos */
	0,       /* different pos */
	1             /* width */
};


static const arch_register_req_t TEMPLATE_requirements_gp_sp_I_S = {
	arch_register_req_type_ignore | arch_register_req_type_produces_sp | arch_register_req_type_limited,
	& TEMPLATE_reg_classes[CLASS_TEMPLATE_gp],
	TEMPLATE_limit_gp_sp,
	0,        /* same pos */
	0,       /* different pos */
	1             /* width */
};


static const arch_register_req_t TEMPLATE_requirements__none = {
	arch_register_req_type_none,
	NULL,                         /* regclass */
	NULL,                         /* limit bitset */
	0,                            /* same pos */
	0,                            /* different pos */
	0                             /* width */
};


static const arch_register_req_t TEMPLATE_requirements_gp_sp = {
	arch_register_req_type_limited,
	& TEMPLATE_reg_classes[CLASS_TEMPLATE_gp],
	TEMPLATE_limit_gp_sp,
	0,        /* same pos */
	0,       /* different pos */
	1             /* width */
};



/**
 * construct fConst node
 */
ir_node *new_bd_TEMPLATE_fConst(dbg_info *dbgi, ir_node *block)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_fConst;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 0;
	ir_node       **in      = NULL;
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t **in_reqs = NULL;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Shr node
 */
ir_node *new_bd_TEMPLATE_Shr(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_Shr;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_gp_gp,
		& TEMPLATE_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_gp_in_r1;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fMul node
 */
ir_node *new_bd_TEMPLATE_fMul(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_fMul;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_fp_fp,
		& TEMPLATE_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Start node
 */
ir_node *new_bd_TEMPLATE_Start(dbg_info *dbgi, ir_node *block)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_Start;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 0;
	ir_node       **in      = NULL;
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t **in_reqs = NULL;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_gp_sp_I_S;
	info->out_infos[1].req = &TEMPLATE_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Or node
 */
ir_node *new_bd_TEMPLATE_Or(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_Or;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_gp_gp,
		& TEMPLATE_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Xor node
 */
ir_node *new_bd_TEMPLATE_Xor(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_Xor;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_gp_gp,
		& TEMPLATE_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fAdd node
 */
ir_node *new_bd_TEMPLATE_fAdd(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_fAdd;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_fp_fp,
		& TEMPLATE_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Not node
 */
ir_node *new_bd_TEMPLATE_Not(dbg_info *dbgi, ir_node *block, ir_node *op0)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_Not;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Shl node
 */
ir_node *new_bd_TEMPLATE_Shl(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_Shl;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_gp_gp,
		& TEMPLATE_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Return node
 */
ir_node *new_bd_TEMPLATE_Return(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_node *mem)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_Return;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 0;
	ir_mode        *mode    = mode_X;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_gp_sp,
		& TEMPLATE_requirements__none,
	};

	/* construct in array */
	in[0] = stack;
	in[1] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fMinus node
 */
ir_node *new_bd_TEMPLATE_fMinus(dbg_info *dbgi, ir_node *block, ir_node *op0)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_fMinus;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Add node
 */
ir_node *new_bd_TEMPLATE_Add(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_Add;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_gp_gp,
		& TEMPLATE_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Store node
 */
ir_node *new_bd_TEMPLATE_Store(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_mode *mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_Store;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 0;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_gp_gp,
		& TEMPLATE_requirements_gp_gp,
		& TEMPLATE_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct And node
 */
ir_node *new_bd_TEMPLATE_And(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_And;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_gp_gp,
		& TEMPLATE_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fStore node
 */
ir_node *new_bd_TEMPLATE_fStore(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_mode *mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_fStore;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 0;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_gp_gp,
		& TEMPLATE_requirements_fp_fp,
		& TEMPLATE_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fLoad node
 */
ir_node *new_bd_TEMPLATE_fLoad(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_fLoad;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_gp_gp,
		& TEMPLATE_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fSub node
 */
ir_node *new_bd_TEMPLATE_fSub(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_fSub;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_fp_fp,
		& TEMPLATE_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Minus node
 */
ir_node *new_bd_TEMPLATE_Minus(dbg_info *dbgi, ir_node *block, ir_node *op0)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_Minus;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct fDiv node
 */
ir_node *new_bd_TEMPLATE_fDiv(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_fDiv;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_fp_fp,
		& TEMPLATE_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_fp_fp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Const node
 */
ir_node *new_bd_TEMPLATE_Const(dbg_info *dbgi, ir_node *block, ir_tarval *value)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_Const;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 0;
	ir_node       **in      = NULL;
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t **in_reqs = NULL;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	set_TEMPLATE_value(res, value);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Sub node
 */
ir_node *new_bd_TEMPLATE_Sub(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_Sub;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_gp_gp,
		& TEMPLATE_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Load node
 */
ir_node *new_bd_TEMPLATE_Load(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_Load;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_gp_gp,
		& TEMPLATE_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Mul node
 */
ir_node *new_bd_TEMPLATE_Mul(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_Mul;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_gp_gp,
		& TEMPLATE_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Jmp node
 */
ir_node *new_bd_TEMPLATE_Jmp(dbg_info *dbgi, ir_node *block)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_TEMPLATE_Jmp;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 0;
	ir_node       **in      = NULL;
	int             n_res   = 1;
	ir_mode        *mode    = mode_X;
	static const arch_register_req_t **in_reqs = NULL;

	/* flags */
	irn_flags_ |= arch_irn_flags_simple_jump;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_TEMPLATE_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &TEMPLATE_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}



/**
 * Creates the TEMPLATE specific Firm machine operations
 * needed for the assembler irgs.
 */
void TEMPLATE_create_opcodes(const arch_irn_ops_t *be_ops)
{
	ir_op *op;
	int    cur_opcode = get_next_ir_opcodes(iro_TEMPLATE_last);

	TEMPLATE_opcode_start = cur_opcode;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_fConst, "TEMPLATE_fConst", op_pin_state_floats, irop_flag_constlike, oparity_zero, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = cmp_attr_TEMPLATE_fConst;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_fConst = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_Shr, "TEMPLATE_Shr", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_Shr = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_fMul, "TEMPLATE_fMul", op_pin_state_floats, irop_flag_commutative, oparity_binary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_fMul = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_Start, "TEMPLATE_Start", op_pin_state_pinned, irop_flag_none, oparity_zero, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_Start = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_Or, "TEMPLATE_Or", op_pin_state_floats, irop_flag_commutative, oparity_binary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_Or = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_Xor, "TEMPLATE_Xor", op_pin_state_floats, irop_flag_commutative, oparity_binary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_Xor = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_fAdd, "TEMPLATE_fAdd", op_pin_state_floats, irop_flag_commutative, oparity_binary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_fAdd = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_Not, "TEMPLATE_Not", op_pin_state_floats, irop_flag_none, oparity_unary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_Not = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_Shl, "TEMPLATE_Shl", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_Shl = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_Return, "TEMPLATE_Return", op_pin_state_pinned, irop_flag_cfopcode, oparity_binary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_Return = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_fMinus, "TEMPLATE_fMinus", op_pin_state_floats, irop_flag_none, oparity_unary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_fMinus = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_Add, "TEMPLATE_Add", op_pin_state_floats, irop_flag_commutative, oparity_binary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_Add = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_Store, "TEMPLATE_Store", op_pin_state_exc_pinned, irop_flag_uses_memory, oparity_trinary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_Store = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_And, "TEMPLATE_And", op_pin_state_floats, irop_flag_commutative, oparity_binary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_And = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_fStore, "TEMPLATE_fStore", op_pin_state_exc_pinned, irop_flag_uses_memory, oparity_trinary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_fStore = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_fLoad, "TEMPLATE_fLoad", op_pin_state_exc_pinned, irop_flag_uses_memory, oparity_binary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_fLoad = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_fSub, "TEMPLATE_fSub", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_fSub = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_Minus, "TEMPLATE_Minus", op_pin_state_floats, irop_flag_none, oparity_unary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_Minus = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_fDiv, "TEMPLATE_fDiv", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_fDiv = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_Const, "TEMPLATE_Const", op_pin_state_floats, irop_flag_constlike, oparity_zero, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = cmp_attr_TEMPLATE_Const;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_Const = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_Sub, "TEMPLATE_Sub", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_Sub = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_Load, "TEMPLATE_Load", op_pin_state_exc_pinned, irop_flag_uses_memory, oparity_binary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_Load = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_Mul, "TEMPLATE_Mul", op_pin_state_floats, irop_flag_commutative, oparity_binary, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_Mul = op;
	op = new_ir_op(cur_opcode + iro_TEMPLATE_Jmp, "TEMPLATE_Jmp", op_pin_state_pinned, irop_flag_cfopcode, oparity_zero, 0, sizeof(TEMPLATE_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = TEMPLATE_dump_node;
	op->ops.node_cmp_attr = TEMPLATE_compare_attr;
	op->ops.copy_attr     = TEMPLATE_copy_attr;
	set_op_tag(op, TEMPLATE_op_tag);
	op_TEMPLATE_Jmp = op;

	TEMPLATE_opcode_end = cur_opcode + iro_TEMPLATE_last;
}

void TEMPLATE_free_opcodes(void)
{
	free_ir_op(op_TEMPLATE_fConst); op_TEMPLATE_fConst = NULL;
	free_ir_op(op_TEMPLATE_Shr); op_TEMPLATE_Shr = NULL;
	free_ir_op(op_TEMPLATE_fMul); op_TEMPLATE_fMul = NULL;
	free_ir_op(op_TEMPLATE_Start); op_TEMPLATE_Start = NULL;
	free_ir_op(op_TEMPLATE_Or); op_TEMPLATE_Or = NULL;
	free_ir_op(op_TEMPLATE_Xor); op_TEMPLATE_Xor = NULL;
	free_ir_op(op_TEMPLATE_fAdd); op_TEMPLATE_fAdd = NULL;
	free_ir_op(op_TEMPLATE_Not); op_TEMPLATE_Not = NULL;
	free_ir_op(op_TEMPLATE_Shl); op_TEMPLATE_Shl = NULL;
	free_ir_op(op_TEMPLATE_Return); op_TEMPLATE_Return = NULL;
	free_ir_op(op_TEMPLATE_fMinus); op_TEMPLATE_fMinus = NULL;
	free_ir_op(op_TEMPLATE_Add); op_TEMPLATE_Add = NULL;
	free_ir_op(op_TEMPLATE_Store); op_TEMPLATE_Store = NULL;
	free_ir_op(op_TEMPLATE_And); op_TEMPLATE_And = NULL;
	free_ir_op(op_TEMPLATE_fStore); op_TEMPLATE_fStore = NULL;
	free_ir_op(op_TEMPLATE_fLoad); op_TEMPLATE_fLoad = NULL;
	free_ir_op(op_TEMPLATE_fSub); op_TEMPLATE_fSub = NULL;
	free_ir_op(op_TEMPLATE_Minus); op_TEMPLATE_Minus = NULL;
	free_ir_op(op_TEMPLATE_fDiv); op_TEMPLATE_fDiv = NULL;
	free_ir_op(op_TEMPLATE_Const); op_TEMPLATE_Const = NULL;
	free_ir_op(op_TEMPLATE_Sub); op_TEMPLATE_Sub = NULL;
	free_ir_op(op_TEMPLATE_Load); op_TEMPLATE_Load = NULL;
	free_ir_op(op_TEMPLATE_Mul); op_TEMPLATE_Mul = NULL;
	free_ir_op(op_TEMPLATE_Jmp); op_TEMPLATE_Jmp = NULL;
}
