/*
 * Copyright (c) 2003, 2008 Apple Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*-
 * Copyright (c) 2002, 2003 David Schultz <dschultz@uclink.Berkeley.EDU>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: src/lib/libc/i386/_fpmath.h,v 1.3 2004/01/18 07:57:01 das Exp $
 */

#if defined(__ppc__) || defined(__ppc64__)

union IEEEl2bits {
	long double	e;
	double		d[2];
	struct {
		unsigned long long	sign	:1;
		unsigned long long	exp	:11;
		unsigned long long	manh	:52;
		unsigned long long	sign2	:1;
		unsigned long long	exp2	:11;
		unsigned long long	manl	:52;
	} bits;
};

#define	mask_nbit_l(u)	((void)0)
#define LDBL_IMPLICIT_NBIT

#define	LDBL_MANH_SIZE	52
#define	LDBL_MANL_SIZE	53	// includes hidden bit

#define LDBL_HEAD_TAIL_PAIR

__private_extern__ int _ldbl2array32dd(union IEEEl2bits, uint32_t *);

#define	LDBL_TO_ARRAY32(u, a) _ldbl2array32dd(u, a)

#elif defined(__i386__) || defined(__x86_64__)

union IEEEl2bits {
	long double	e;
	struct {
		unsigned int	manl	:32;
		unsigned int	manh	:32;
		unsigned int	exp	:15;
		unsigned int	sign	:1;
		unsigned int	junk	:16;
	} bits;
};

#define	mask_nbit_l(u)	((u).bits.manh &= 0x7fffffff)

#define	LDBL_MANH_SIZE	32
#define	LDBL_MANL_SIZE	32

#define	LDBL_TO_ARRAY32(u, a) do {			\
	(a)[0] = (uint32_t)(u).bits.manl;		\
	(a)[1] = (uint32_t)(u).bits.manh;		\
} while(0)
#elif defined(__arm__)

union IEEEl2bits {
    long double     e;
    struct {
#ifndef __ARMEB__
	unsigned int    manl    :32;
	unsigned int    manh    :20;
	unsigned int    exp     :11;
	unsigned int    sign    :1;
#else
	unsigned int            sign    :1;
	unsigned int            exp     :11;
	unsigned int            manh    :20;
	unsigned int            manl    :32;
#endif
    } bits;
};

#define LDBL_NBIT       0
#define mask_nbit_l(u)  ((void)0)

#define LDBL_MANH_SIZE  20
#define LDBL_MANL_SIZE  32

#define LDBL_TO_ARRAY32(u, a) do {                      \
        (a)[0] = (uint32_t)(u).bits.manl;               \
        (a)[1] = (uint32_t)(u).bits.manh;               \
} while(0)

#else
#error unsupported architecture
#endif
