#if HAVE_CONFIG_H
#include <framecpp_config.h>
#endif /* HAVE_CONFIG_H */

#include <unistd.h>

#include <list>
#include <memory>
#include <sstream>

#include "ldastoolsal/fstream.hh"
#include "ldastoolsal/gpstime.hh"
#include "ldastoolsal/unittest.h"

#include "framecpp/Common/FrameBuffer.hh"
#include "framecpp/Common/FrameStream.hh"

#include "framecpp/FrStatData.hh"

#undef FRAME_SPEC_MIN
#undef FRAME_SPEC_MAX

#define FRAME_SPEC_MIN 4
#define FRAME_SPEC_MAX 8

using LDASTools::AL::GPSTime;
using LDASTools::AL::filebuf;

using FrameCPP::Common::IFrameStream;
using FrameCPP::Common::OFrameStream;

typedef FrameCPP::Common::FrameBuffer< filebuf > filebuf_type;

typedef LDASTools::AL::SharedPtr< IFrameStream >	create_frame_ret_type;

template< int > create_frame_ret_type
create_frame( std::string& Filename );

#define USING_NS(X) using namespace FrameCPP::Version_##X

LDASTools::Testing::UnitTest	Test;
GPSTime	GTime( 600000000, 0 );

template< typename T >
struct stat_data_container_type
  : public std::list< LDASTools::AL::SharedPtr< T > >
{
};

#include "FrStatData4.icc"
#include "FrStatData6.icc"
#include "FrStatData7.icc"
#include "FrStatData8.icc"


//=======================================================================
// Testing framework
//=======================================================================
void
test( int FrameSpec,
      const std::string& Leader, INT_4U Results,
      IFrameStream& FrameStream,
      const std::string& NamePattern,
      const std::string& DetectorPattern,
      const GPSTime& Start, const GPSTime& Stop,
      INT_4U Version )

{
  using FrameCPP::FrStatData;

  FrStatData::Query	results;

  FrameStream.ReadFrStatData( NamePattern, DetectorPattern,
			      Start, Stop, Version,
			      results );

  Test.Check( Results == results.size( ) )
    << "FrameSpec: " << FrameSpec << ": "
    << Leader << " Read " << results.size( ) << " of the expected " << Results
    << std::endl;
}

static void
version_check( int x )
{
  using FrameCPP::FrStatData;

  std::string	filename;

  LDASTools::AL::SharedPtr< IFrameStream >	ifs;

  switch( x )
  {
  case 3: // No TOC support
  case 5: // No support
    break;
  case 4:
    ifs = create_frame< 4 >( filename );
    break;
  case 6:
    ifs = create_frame< 6 >( filename );
    break;
  case 7:
    ifs = create_frame< 7 >( filename );
    break;
  case 8:
    ifs = create_frame< 8 >( filename );
    break;
  default:
    Test.Check( false ) << "Frame specification version "
			<< x << " not supported"
			<< std::endl
      ;
  }

#if 0
  if ( ifs )
  {
    test( x,
	  "Retrieval of all All",
	  5, *ifs, "^.*$", "^.*$",
	  GPSTime( 0, 0 ), GPSTime( 0, 0 ),
	  FrStatData::Query::ALL_VERSIONS );

    test( x,
	  "Retrieval of all d1",
	  2, *ifs, "^d1:.*$", "^d1$",
	  GPSTime( 0, 0 ), GPSTime( 0, 0 ),
	  FrStatData::Query::ALL_VERSIONS );
    
    test( x,
	  "Retrieval of all d2",
	  3, *ifs, "^d2:.*$", "^d2$",
	  GPSTime( 0, 0 ), GPSTime( 0, 0 ),
	  FrStatData::Query::ALL_VERSIONS );

    test( x,
	  "Retrieval for time 1000 - 1999",
	  3, *ifs, "^.*$", "^.*$",
	  GTime + 1000, GTime + 1999,
	  FrStatData::Query::ALL_VERSIONS );

    test( x,
	  "Retrieval of latest",
	  4, *ifs, "^.*$", "^.*$",
	  GPSTime( 0, 0 ), GPSTime( 0, 0 ),
	  FrStatData::Query::LATEST_VERSION );

    test( x,
	  "Retrieval of latest d2",
	  2, *ifs, "^d2:.*$", "^d2$",
	  GPSTime( 0, 0 ), GPSTime( 0, 0 ),
	  FrStatData::Query::LATEST_VERSION );

    test( x,
	  "Retrieval of any interferometer with a single leter name",
	  0, *ifs, "^.:.*$", "^.$",
	  GPSTime( 0, 0 ), GPSTime( 0, 0 ),
	  FrStatData::Query::ALL_VERSIONS );
  }
#endif /* 0 */
}

//=======================================================================
// main -- Main testing loop
//=======================================================================
std::ostringstream	filename;

int
main( int argc, char* argv[] )
try
{
  FrameCPP::Initialize( );

  //---------------------------------------------------------------------
  // Prepare for testing
  //---------------------------------------------------------------------
  Test.Init( argc, argv );

  //---------------------------------------------------------------------
  // Test reading of frames
  //---------------------------------------------------------------------
  for( int x = FRAME_SPEC_MIN;
       x <= FRAME_SPEC_MAX;
       ++x )
  {
    version_check( x );
  }

  //---------------------------------------------------------------------
  // Exit with the proper exit status
  //---------------------------------------------------------------------
  Test.Exit( );
}
catch ( const std::exception& e )
{
  Test.Check( false )
    << "Caught standard exception: " << e.what( )
    << std::endl;
  Test.Exit( );
} catch (...) {
  Test.Check( false ) << "Caught an exception" << std::endl;
  Test.Exit( );
}
