#ifndef FRAMECPP__OOINTERFACE__FR_PROC_DATA_PYTHON_I
#define FRAMECPP__OOINTERFACE__FR_PROC_DATA_PYTHON_I
%{
#include <Python.h>
%}

%typemap(in) const AuxParamList_type& (AuxParamList_type temp){
  //---------------------------------------------------------------------
  // Check the type of input data
  //---------------------------------------------------------------------
  if ( PyList_Check( $input ) )
  {
    //-------------------------------------------------------------------
    // Should be easy enough as we have a simple list
    //-------------------------------------------------------------------
    bool	translated = true;

    for ( int cur = 0,
	    last = PyList_Size( $input );
	  cur != last;
	  ++cur )
    {
      PyObject*	aux_param_object = PyList_GetItem( $input, cur );
      PyObject* key;
      PyObject* value;

      if ( PyTuple_Check( aux_param_object )
	   && ( PyTuple_Size( aux_param_object ) == 2 )
	   && ( PyString_Check( key = PyTuple_GetItem( aux_param_object, 0 ) ) )
	   && ( PyFloat_Check( value = PyTuple_GetItem( aux_param_object, 1 ) ) ) )
      {
	char*	n = PyString_AsString( key );
	double	v = PyFloat_AsDouble( value );

	temp.push_back( AuxParam_type( n, v ) );
      }
      else
      {
	translated = false;
	break;
      }
    }
    if ( translated )
    {
      $1 = &temp;
    }
  }
  else if ( PyDict_Check( $input ) )
  {
    //-------------------------------------------------------------------
    // Dictionaries are handled as hash maps with unique keys.
    // There is no guarantee of the order of the data.
    //-------------------------------------------------------------------
    bool	translated = true;
    PyObject	*key;
    PyObject	*value;

    for ( Py_ssize_t cur = 0;
	  PyDict_Next( $input, &cur, &key, &value );
	  )
    {
      if ( PyString_Check( key )
	   && ( PyFloat_Check( value ) ) )
      {
	char*	n = PyString_AsString( key );
	double	v = PyFloat_AsDouble( value );

	temp.push_back( AuxParam_type( n, v ) );
      }
      else
      {
	translated = false;
	break;
      }
    }
    if ( translated )
    {
      $1 = &temp;
    }
  }
#if WORKING
  else if ( PyTuple_Check( $input ) )
  {
    //-------------------------------------------------------------------
    // This is a tuple.
    //-------------------------------------------------------------------
  }
#endif /* WORKING */
  if ( ! $1 )
  {
    PyErr_SetString( PyExc_TypeError, "Unable to translate parameter to AuxParamList_type" );
    return NULL;
  }
}

%typemap(out) const AuxParamList_type& {
  PyObject* aux_param_list = PyList_New( $1->size( ) );
  Py_ssize_t index = 0;

  for ( AuxParamList_type::const_iterator
	  cur = $1->begin( ),
	  last = $1->end( );
	cur != last;
	++cur )
  {
    PyObject* name = PyString_FromString( cur->auxParamName.c_str( ) );
    PyObject* value = PyFloat_FromDouble( cur->auxParam );
    PyObject* aux_param = PyTuple_New( 2 );

    PyTuple_SetItem( aux_param, 0, name );
    PyTuple_SetItem( aux_param, 1, value );

    PyList_SetItem( aux_param_list, index++, aux_param );
  }
  $result = aux_param_list;
}

#endif /* FRAMECPP__OOINTERFACE__FR_PROC_DATA_PYTHON_I */
