#ifndef FrameCPP_VERSION_8_FrAdcData_HH
#define FrameCPP_VERSION_8_FrAdcData_HH

#if defined(__cplusplus)
#if ! defined(SWIG)
#include <memory>
#include <vector>

#include "ldastoolsal/types.hh"

#include "framecpp/Common/Container.hh"
#include "framecpp/Common/TOCInfo.hh"
#endif /* ! defined(SWIG) */
#endif /* defined(__cplusplus) */

#include "framecpp/Version7/FrAdcData.hh"

#if defined(__cplusplus)
#if ! defined(SWIG)
#include "framecpp/Version8/FrameSpec.hh"
#include "framecpp/Version8/Dimension.hh"
#include "framecpp/Version8/FrVect.hh"
#include "framecpp/Version8/STRING.hh"
#endif /* ! defined(SWIG) */
#endif /* defined(__cplusplus) */

#if defined(__cplusplus) && !defined(SWIGIMPORTED)
namespace FrameCPP
{
  namespace Version_8
  {
    typedef FR_ADC_DATA_NPS_NAMESPACE :: FrAdcDataNPS FrAdcDataNPS;
    typedef FR_ADC_DATA_PS_NAMESPACE :: FrAdcDataPST< FrVect, FrVect > FrAdcDataPS;

    //===================================================================
    /// \brief ADC Data
    //===================================================================
    class FrAdcData
      : public FrAdcDataNPS,
        public FrAdcDataPS,
	public ObjectWithChecksum< Common::FrameSpec::Object >,
	public Common::TOCInfo
    {
    public:
      typedef FrAdcDataNPS	nps_type;
      typedef FrAdcDataPS	ps_type;

      typedef LDASTools::AL::SharedPtr< FrAdcData >	subset_ret_type;
      typedef FrAdcDataPS			references_type;

      //-----------------------------------------------------------------
      /// \brief Default constructor
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrAdcData( );

      //-----------------------------------------------------------------
      /// \brief Copy Constructor
      ///
      /// \param[in] Source
      ///     The object from which to copy the information.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrAdcData( const FrAdcData& Source );

      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] Name
      ///     The Channel name -- must be unique within the frame
      /// \param[in] Group
      ///     Channel grouping number containing ADC.
      /// \param[in] Channel
      ///     Channel number.
      /// \param[in] NBits
      ///     Number of bits in A/D output.
      /// \param[in] Bias
      ///     DC bias on channel (Units ADC counts = 0)
      /// \param[in] Slope
      ///     ADC calibration: input units/count.
      /// \param[in] Units
      ///     ADC calibration: input units for slope.
      /// \param[in] SampleRate
      ///     Data acquistion rate, samples/s.
      /// \param[in] FShift
      ///     The frequency (in Hz) in the origional data that
      ///     oorresponds to 0 Hz in the heterodyned series.
      /// \param[in] TimeOffset
      ///     Offset of the first sample relative to the frame start
      ///     time (seconds). Must be positive and smaller than the
      ///     frame length.
      /// \param[in] DataValid
      ///     Data valid flag.
      /// \param[in] Phase
      ///     Phase of heterodyning signal at start of dataset.
      ///
      /// \return
      ///     A new instance of the object.
      //-----------------------------------------------------------------
      FrAdcData( const name_type& Name,
		 channelGroup_type Group,
		 channelNumber_type Channel,
		 nBits_type NBits,
		 sampleRate_type SampleRate,
		 bias_type Bias = DEFAULT_BIAS,
		 slope_type Slope = DEFAULT_SLOPE,
		 const units_type& Units = DEFAULT_UNITS( ),
		 fShift_type FShift = DEFAULT_FSHIFT,
		 timeOffset_type TimeOffset = DEFAULT_TIME_OFFSET,
		 dataValid_type DataValid = DEFAULT_DATA_VALID,
		 phase_type Phase = DEFAULT_PHASE );

      //-----------------------------------------------------------------
      /// \brief Promotion Constructor
      ///
      /// \param[in] Source
      ///     An FrAdcData structure from a previous frame specification.
      /// \param[in] Stream
      ///     The stream from which the earliest version of the
      ///     FrAdcData structure was read.
      ///
      /// \return
      ///     A new instance of the object.
      //-----------------------------------------------------------------
      FrAdcData( Previous::FrAdcData& Source, istream_type* Stream );

      //-----------------------------------------------------------------
      /// \brief Destructor
      //-----------------------------------------------------------------
      ~FrAdcData( );

      //-----------------------------------------------------------------
      /// \brief Retrieve the name of the FrAdcData struture.
      //-----------------------------------------------------------------
      const std::string& GetNameSlow( ) const;

      //-----------------------------------------------------------------
      /// \brief The name structure name of this object.
      ///
      /// \return
      ///     The name of the structure as specified by the frame
      ///     specification.
      //-----------------------------------------------------------------
      static const char* StructName( );

      //-----------------------------------------------------------------
      /// \brief The description of structure
      ///
      /// \return
      ///     A Description object which describes this structure as
      ///     specified by the frame specification.
      //-----------------------------------------------------------------
      static const Common::Description* StructDescription( );

      //-----------------------------------------------------------------
      /// \brief equality operator
      ///
      /// \param[in] RHS
      ///     The FrAdcData object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      bool operator==( const FrAdcData& RHS ) const;

      //-----------------------------------------------------------------
      /// \brief inequality operator
      ///
      /// \param[in] RHS
      ///     The FrAdcData object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is not equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      bool operator!=( const FrAdcData& RHS ) const;

      //-----------------------------------------------------------------
      /// \brief equality operator for abstract data type
      ///
      /// \param[in] Obj
      ///     The object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      virtual bool operator==( const Common::FrameSpec::Object& Obj ) const;

      //-----------------------------------------------------------------
      /// \brief The name structure name of this object.
      ///
      /// \return
      ///     The name of the structure as specified by the frame
      ///     specification.
      //-----------------------------------------------------------------
      virtual const char* ObjectStructName( ) const;

      //-----------------------------------------------------------------
      /// \brief Merge with another FrAdcData
      ///
      /// \param[in] RHS
      ///     The source of the information to append to this FrAdcData
      ///     structure.
      ///
      /// \return
      ///     A reference to this object
      //-----------------------------------------------------------------
      FrAdcData& Merge( const FrAdcData& RHS );

      //-----------------------------------------------------------------
      /// \brief Promote previous version of object to this version
      ///
      /// \param[in] Source
      ///     The frame specification version of the object.
      /// \param[in] Obj
      ///     The previous version of the object.
      /// \param[in] Stream
      ///     Stream from which the origional object was created.
      ///
      /// \return
      ///     A new instance of FrameH based on Obj
      //-----------------------------------------------------------------
      static promote_ret_type
      Promote( INT_2U Source,
	       promote_arg_type Obj,
	       istream_type* Stream );

      //-----------------------------------------------------------------
      /// \brief Request a subset of the data.
      ///
      /// \param[in] Offset
      ///     The number of seconds from the start of the FrAdcData
      ///     object from which to start extracting data.
      /// \param[in] Dt
      ///     The number of seconds of data in the resulting FrAdcData
      ///     strucutre.
      ///
      /// \return
      ///     A FrAdcData structure which contains Dt seconds of data
      ///     starting at Offset of this FrAdcData structure.
      //-----------------------------------------------------------------
      subset_ret_type Subset( REAL_8 Offset, REAL_8 Dt ) const;
   
#if WORKING_VIRTUAL_TOCQUERY
      //-----------------------------------------------------------------
      /// \brief Answer requests for information as needed by TOC
      ///
      /// \param[in] InfoClass
      ///     Class of information being requested.
      //-----------------------------------------------------------------
      virtual void TOCQuery( int InfoClass, ... ) const;
#endif /*  WORKING_VIRTUAL_TOCQUERY */

    protected:
      //-----------------------------------------------------------------
      /// \brief Down grade an object
      ///
      /// \param[in] Target
      ///     The version of the frame specification to demote too.
      /// \param[in] Obj
      ///     The version of the object to demote.
      /// \param[in] Stream
      ///     The input stream from which the original object was read.
      ///
      /// \return
      ///     An object of the previous generation.
      //-----------------------------------------------------------------
      virtual demote_ret_type
      demote( INT_2U Target,
	      demote_arg_type Obj,
	      istream_type* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Upgrade an object
      ///
      /// \param[in] Target
      ///     The version of the frame specification to promote too.
      /// \param[in] Obj
      ///     The object to be promoted.
      /// \param[in] Stream
      ///     The input stream from which the original object was read.
      ///
      /// \return
      ///     An object of this class.
      //-----------------------------------------------------------------
      virtual promote_ret_type
      promote( INT_2U Target,
	       promote_arg_type Obj,
	       istream_type* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Number of bytes needed to write this structure
      ///
      /// \param[in] Stream
      ///     The stream from which to the object is being read or
      ///     written.
      ///
      /// \return
      ///     The number of bytes need to read or write this object.
      //-----------------------------------------------------------------
      cmn_streamsize_type pBytes( const Common::StreamBase& Stream) const;

      //-----------------------------------------------------------------
      /// \brief Virtual constructor
      ///
      /// \param[in] Stream
      ///     The input stream from where the object is being read.
      ///
      /// \return
      ///     The newly allocated object.
      //-----------------------------------------------------------------
      virtual FrAdcData* pCreate( istream_type& Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Write the structure to the stream
      ///
      /// \param[in] Stream
      ///     The output stream where the object is to be written.
      //-----------------------------------------------------------------
      virtual void pWrite( ostream_type& Stream ) const;

#if ! WORKING_VIRTUAL_TOCQUERY
      //-----------------------------------------------------------------
      /// \brief Answer requests for information as needed by TOC
      ///
      /// \param[in] InfoClass
      ///     Class of information being requested.
      /// \param[in] vl
      ///     Variable argument list of requested data.
      //-----------------------------------------------------------------
      virtual void vTOCQuery( int InfoClass, va_list vl ) const;
#endif /* ! WORKING_VIRTUAL_TOCQUERY */

    private:
      //-----------------------------------------------------------------
      /// \brief Object with checksum data.
      //-----------------------------------------------------------------
      typedef ObjectWithChecksum< Common::FrameSpec::Object > object_type;

      using Common::FrameSpec::Object::Create;

      //-----------------------------------------------------------------
      /// \brief Stream Constructor
      ///
      /// \param[in] Stream
      ///     The stream from which the object is being read.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrAdcData( istream_type& Stream );

      void copy_core( const FrAdcData& Source );
    };

    inline FrAdcData::promote_ret_type FrAdcData::
    Promote( INT_2U Source,
	     promote_arg_type Obj,
	     istream_type* Stream )
    {
      return Object::PromoteObject< Previous::FrAdcData, FrAdcData >
	( DATA_FORMAT_VERSION, Source, Obj, Stream );
    }

    inline const char* FrAdcData::
    StructName( )
    {
      static const char* name = "FrAdcData";
      return name;
    }

    inline bool FrAdcData::
    operator==( const FrAdcData& RHS ) const
    {
      return ( ( this == &RHS )
	       || ( nps_type::operator==( RHS )
		    && ps_type::operator==( RHS ) ) );
	;
    }

    inline bool FrAdcData::
    operator!=( const FrAdcData& RHS ) const
    {
      return ! ( *this == RHS );
    }

    inline void FrAdcData::
    copy_core( const FrAdcData& Source )
    {
      nps_type::copyCore( Source );
      ps_type::copyCore( Source );
    }
  } // namespace - Version_8
} // namespace FrameCPP
#endif /* defined(__cplusplus) && !defined(SWIGIMPORTED) */
#endif /* FrameCPP_VERSION_8_FrAdcData_HH */
