#include <framecpp_config.h>

#include "framecpp/Version4/Dimension.hh"

namespace FrameCPP
{
  namespace Version_4
  {
    //------------------------------------------------------------------
    // Constructors
    //------------------------------------------------------------------


    //------------------------------------------------------------------
    //
    //: Default Constructor.
    //
    // This creates a dimension object with the following values:
    //
    //   Dimension Length (Nx) - 1
    //   Scale Factor (Dx) - 1.0
    //   Units (UnitX) - ""
    //
    //!exc: None.   
    //   
    Dimension::Dimension()
      : mNx( 1 ),
	mDx( 1.0 ),
	mUnitX( "" ),
	mStartX( .0 )
    {
    }


    //------------------------------------------------------------------
    /// This creates a Dimension object with the specified attributes.
    //------------------------------------------------------------------
    Dimension::
    Dimension( const Dimension& dim )
      : mNx( dim.mNx ),
	mDx( dim.mDx ),
	mUnitX( dim.mUnitX ), 
	mStartX( dim.mStartX )
    {
    }
    

    //------------------------------------------------------------------
    /// This creates a Dimension object with the specified attributes.
    //------------------------------------------------------------------
    Dimension::
    Dimension( nx_type nx,
	       dx_type dx,
	       const std::string& unitX,
	       startX_type startX )
      : mNx( nx ),
	mDx( dx ),
	mUnitX( unitX ),
	mStartX( startX )
    {
    }
  } // namespace - Version_4
} // namespace - FrameCPP
