/* -*- mode: c++; c-basic-offset: 2; indent-tabs-mode: nil; -*- */

#include "framecpp/Common/StringStream.hh"
#include "framecpp/Common/DynamicMemoryBuffer.hh"

namespace FrameCPP
{
  namespace Common
  {
    //-------------------------------------------------------------------
    /// The default constructor will initialize all the parts used
    /// in the general case.
    //-------------------------------------------------------------------
    template< typename BT >
    DynamicMemoryBufferT< BT >::
    DynamicMemoryBufferT( bool ParentAutoDelete )
      : MemoryBufferT< BT >( std::ios::in, ParentAutoDelete )
    {
    }

    //-------------------------------------------------------------------
    /// Be careful to release all the resources that were created
    /// for this object.
    //-------------------------------------------------------------------
    template< typename BT >
    DynamicMemoryBufferT< BT >::
    ~DynamicMemoryBufferT( )
    {
    }

    //-------------------------------------------------------------------
    //-------------------------------------------------------------------
    template< typename BT >
    void DynamicMemoryBufferT< BT >::
    NextBlock( const char* Buffer, size_type Size )
    {
      scanner_type::NextBlock( Buffer, Size );
      //-----------------------------------------------------------------
      // Copy the bytes to the temporary output buffer
      //-----------------------------------------------------------------
      accumulated_buffer.write( Buffer, Size );
      if ( Ready( ) )
      {
        this->str( accumulated_buffer.str( ) );
      }
    }

    //-------------------------------------------------------------------
    //-------------------------------------------------------------------
    template< typename BT >
    void DynamicMemoryBufferT< BT >::
    Reset( )
    {
      //-----------------------------------------------------------------
      // Seek to the beginning of the buffer;
      //-----------------------------------------------------------------
      accumulated_buffer.seekp( std::streampos( 0 ) );
      accumulated_buffer.clear( );
      scanner_type::Reset( );
    }

    template class DynamicMemoryBufferT<>;
  } // namespace Common

} // namespace FrameCPP
