#include <stdint.h>

#include <fstream>
#include <iomanip>
#include <string>

#include "CRCModel.hh"

using namespace FrameCPP::Common;

template < class DT > const char* name( );

#define TYPE_NAME(a) \
template<> const char* name<a>( ) { return #a; }

TYPE_NAME(uint32_t)
TYPE_NAME(crc32_model_type)
// template<> const char* name<crc32_model_type>( ) { return "crc32_model_type"; }

using FrameCPP::Common::crc32_model_type;
using FrameCPP::Common::CRCModel;

void
hexit( std::ostream& Stream, uint32_t Value )
{
  /* TODO: Get Width so it can be restored */
  int	width = 0;

  Stream << "0x" << std::hex << std::setfill('0') << std::setw( sizeof( Value ) * 2 )
	 << Value
	 << std::dec
	 << std::setw( width )
    ;
}

//-----------------------------------------------------------------------
//
//-----------------------------------------------------------------------
template< typename MODEL >
void
gen_table( std::ostream& Stream,
	   const std::string& NameSpace )
{
  typedef typename MODEL::crc_type crc_type;
  
  int	max_x = 8;
  int	comma_x = max_x - 1;
  int	max_y = 256;
  int	comma_y = max_y - 1;
  char  comma[2] = { ',', '\0' };

  const crc_type poly( MODEL::polynomial.reversed( ) );

  crc_type lookup[8][256];

  for (int i = 0; i < 256; i++)
  {
    crc_type crc = i;

    for (int j = 0; j < 8; j++)
    {
      crc = (crc >> 1) ^ ((crc & 1) * poly);
    }
    lookup[0][i] = crc;
  }
  for (int i = 0; i <= 0xFF; i++)
  {
    lookup[1][i] = (lookup[0][i] >> 8) ^ lookup[0][lookup[0][i] & 0xFF];
    lookup[2][i] = (lookup[1][i] >> 8) ^ lookup[0][lookup[1][i] & 0xFF];
    lookup[3][i] = (lookup[2][i] >> 8) ^ lookup[0][lookup[2][i] & 0xFF];
    lookup[4][i] = (lookup[3][i] >> 8) ^ lookup[0][lookup[3][i] & 0xFF];
    lookup[5][i] = (lookup[4][i] >> 8) ^ lookup[0][lookup[4][i] & 0xFF];
    lookup[6][i] = (lookup[5][i] >> 8) ^ lookup[0][lookup[5][i] & 0xFF];
    lookup[7][i] = (lookup[6][i] >> 8) ^ lookup[0][lookup[6][i] & 0xFF];
  }

  Stream << "/*" << std::setfill('*') << std::setw( 70 ) << "*" << std::endl
	 << " * Polynomial: "
    ;
  hexit( Stream, MODEL::polynomial.polynomial );
  Stream << std::endl;
  {
    int	w( 25 );
    Stream << " * "
	   << std::left << std::setfill(' ') << std::setw( w )
	   << "Polynomial (normal):"
	   << std::right
      ;
    hexit( Stream, MODEL::polynomial.normal( ) );
    Stream << std::endl;
    Stream << " * "
	   << std::left << std::setfill(' ') << std::setw( w )
	   << "Polynomial (reversed):"
	   << std::right
      ;
    hexit( Stream, MODEL::polynomial.reversed( ) );
    Stream << std::endl;
  }
  Stream << " *" << std::setfill('*') << std::setw( 70 ) << "*/" << std::endl
    ;
  Stream << "template<>" << std::endl
	 << NameSpace << "CRC< " << NameSpace << name< MODEL >( ) << " >::crc_type"<< std::endl
	 << NameSpace
	 << "CRC< " << NameSpace << name< MODEL >( )
	 << " >::"
	 << "lookup[ " << max_x <<" ][ " << max_y <<" ] = {"
	 << std::endl
    ;
  for ( int x = 0;
	x < max_x;
	++x )
  {
    if ( x == comma_x )
    {
      *comma = '\0';
    }
    Stream << "  {" << std::endl;
    Stream << "    ";
    for ( int y = 0;
	  y < max_y;
	  ++y )
    {
      hexit( Stream, lookup[x][y] );
      if ( y != comma_y )
      {
	Stream << ",";
      }
      if ( ( y % 8 ) == 7 )
      {
	Stream << std::endl;
	if ( y != comma_y )
	{
	  Stream << "    ";
	}
      }
    }
    Stream << "  }" << comma << std::endl;
  }
  Stream << std::endl;
  Stream << "};";
}

int
main( int ArgC, char** ArgV )
{
  //---------------------------------------------------------------------
  // Generates lookup tables for a variety of CRC Polynomials
  //---------------------------------------------------------------------
  std::ofstream	ofs;

  ofs.open( ArgV[1], std::ofstream::out | std::ofstream::trunc );
  // http://en.wikipedia.org/wiki/Cyclic_redundancy_check
  //---------------------------------------------------------------------
  // CRC-32 
    gen_table< FrameCPP::Common::crc32_model_type >
      ( ofs, "FrameCPP::Common::" );	// CRC-32
  ofs.close( );
  return 0;
}
