/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang.fastutil;

import com.intellij.util.lang.fastutil.Hash;
import java.util.NoSuchElementException;

public final class StrippedIntOpenHashSet {
    private transient int[] key;
    private transient int mask;
    private transient boolean containsNull;
    private transient int n;
    private transient int maxFill;
    private final transient int minN;
    private int size;
    private final float f;

    public StrippedIntOpenHashSet(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = Hash.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = Hash.maxFill(this.n, f);
        this.key = new int[this.n + 1];
    }

    public StrippedIntOpenHashSet() {
        this(16, 0.75f);
    }

    private int realSize() {
        return this.containsNull ? this.size - 1 : this.size;
    }

    public boolean add(int k) {
        if (k == 0) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            int[] key = this.key;
            int pos = Hash.mix(k) & this.mask;
            int curr = key[pos];
            if (curr != 0) {
                if (curr == k) {
                    return false;
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != 0) {
                    if (curr != k) continue;
                    return false;
                }
            }
            key[pos] = k;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(Hash.arraySize(this.size + 1, this.f));
        }
        return true;
    }

    public int[] toArray() {
        int[] result2 = new int[this.size];
        SetIterator iterator2 = this.iterator();
        int i = 0;
        while (iterator2.hasNext()) {
            result2[i++] = iterator2.nextInt();
        }
        return result2;
    }

    public SetIterator iterator() {
        return new SetIterator();
    }

    private void rehash(int newN) {
        int[] key = this.key;
        int mask = newN - 1;
        int[] newKey = new int[newN + 1];
        int i = this.n;
        int j = this.realSize();
        while (j-- != 0) {
            while (key[--i] == 0) {
            }
            int pos = Hash.mix(key[i]) & mask;
            if (newKey[pos] != 0) {
                while (newKey[pos = pos + 1 & mask] != 0) {
                }
            }
            newKey[pos] = key[i];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = Hash.maxFill(this.n, this.f);
        this.key = newKey;
    }

    public int hashCode() {
        int h = 0;
        int j = this.realSize();
        int i = 0;
        while (j-- != 0) {
            while (this.key[i] == 0) {
                ++i;
            }
            h += this.key[i];
            ++i;
        }
        return h;
    }

    public final class SetIterator {
        int pos;
        int c;
        boolean mustReturnNull;

        public SetIterator() {
            this.pos = StrippedIntOpenHashSet.this.n;
            this.c = StrippedIntOpenHashSet.this.size;
            this.mustReturnNull = StrippedIntOpenHashSet.this.containsNull;
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextInt() {
            int v;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                return StrippedIntOpenHashSet.this.key[StrippedIntOpenHashSet.this.n];
            }
            int[] key = StrippedIntOpenHashSet.this.key;
            while ((v = key[--this.pos]) == 0) {
            }
            return v;
        }
    }
}

