/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.psi.PsiElement;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantCallOfConversionMethod;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "targetClassMap", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/name/ClassId;", "Lkotlin/collections/HashMap;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isRedundant", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "qualifiedClassId", "checkers"})
public final class RedundantCallOfConversionMethod
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final RedundantCallOfConversionMethod INSTANCE = new RedundantCallOfConversionMethod();
    @NotNull
    private static final HashMap<String, ClassId> targetClassMap;

    private RedundantCallOfConversionMethod() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(expression2 instanceof FirFunctionCall)) {
            return;
        }
        String string2 = ((FirFunctionCall)expression2).getCalleeReference().getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"expression.calleeReference.name.asString()");
        String functionName = string2;
        ClassId classId = targetClassMap.get(functionName);
        if (classId == null) {
            return;
        }
        ClassId qualifiedType = classId;
        FirExpression firExpression2 = expression2.getExplicitReceiver();
        boolean bl = firExpression2 != null ? this.isRedundant(firExpression2, qualifiedType) : false;
        if (bl) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getREDUNDANT_CALL_OF_CONVERSION_METHOD(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final boolean isRedundant(FirExpression $this$isRedundant, ClassId qualifiedClassId) {
        Object object;
        if ($this$isRedundant instanceof FirConstExpression) {
            object = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType($this$isRedundant.getTypeRef()));
        } else if (FirTypeUtilsKt.getConeType($this$isRedundant.getTypeRef()) instanceof ConeFlexibleType) {
            object = null;
        } else {
            PsiElement psiElement = UtilsKt.getPsi($this$isRedundant);
            object = !((psiElement != null ? psiElement.getParent() : null) instanceof KtSafeQualifiedExpression) && (UtilsKt.getPsi($this$isRedundant) instanceof KtSafeQualifiedExpression || ConeTypeUtilsKt.isMarkedNullable(FirTypeUtilsKt.getConeType($this$isRedundant.getTypeRef()))) ? null : (ConeTypeUtilsKt.isMarkedNullable(FirTypeUtilsKt.getConeType($this$isRedundant.getTypeRef())) ? null : ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType($this$isRedundant.getTypeRef())));
        }
        ClassId thisType = object;
        return Intrinsics.areEqual((Object)thisType, (Object)qualifiedClassId);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toString", (Object)StandardClassIds.INSTANCE.getString()), TuplesKt.to((Object)"toDouble", (Object)StandardClassIds.INSTANCE.getDouble()), TuplesKt.to((Object)"toFloat", (Object)StandardClassIds.INSTANCE.getFloat()), TuplesKt.to((Object)"toLong", (Object)StandardClassIds.INSTANCE.getLong()), TuplesKt.to((Object)"toInt", (Object)StandardClassIds.INSTANCE.getInt()), TuplesKt.to((Object)"toChar", (Object)StandardClassIds.INSTANCE.getChar()), TuplesKt.to((Object)"toShort", (Object)StandardClassIds.INSTANCE.getShort()), TuplesKt.to((Object)"toByte", (Object)StandardClassIds.INSTANCE.getByte()), TuplesKt.to((Object)"toULong", (Object)StandardClassIds.INSTANCE.getULong()), TuplesKt.to((Object)"toUInt", (Object)StandardClassIds.INSTANCE.getUInt()), TuplesKt.to((Object)"toUShort", (Object)StandardClassIds.INSTANCE.getUShort()), TuplesKt.to((Object)"toUByte", (Object)StandardClassIds.INSTANCE.getUByte())};
        targetClassMap = MapsKt.hashMapOf((Pair[])pairArray);
    }
}

