/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.util;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.javacs.kt.LoggerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0007H\u0002\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0001\u001a\b\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\"\u001c\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0011"}, d2={"userHome", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getUserHome", "()Ljava/nio/file/Path;", "findCommandOnPath", "name", "", "findExecutableOnPath", "fileName", "findFileRelativeToProjectFile", "projectFile", "findProjectCommandWithName", "isOSWindows", "", "unixCommand", "windowsCommand", "shared"})
public final class ShellPathUtilsKt {
    private static final Path userHome = Paths.get(System.getProperty("user.home"), new String[0]);

    public static final Path getUserHome() {
        return userHome;
    }

    public static final boolean isOSWindows() {
        return File.separatorChar == '\\';
    }

    @Nullable
    public static final Path findCommandOnPath(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ShellPathUtilsKt.isOSWindows() ? ShellPathUtilsKt.windowsCommand(name) : ShellPathUtilsKt.unixCommand(name);
    }

    private static final Path windowsCommand(String name) {
        Path path = ShellPathUtilsKt.findExecutableOnPath(name + ".cmd");
        if (path == null && (path = ShellPathUtilsKt.findExecutableOnPath(name + ".bat")) == null) {
            path = ShellPathUtilsKt.findExecutableOnPath(name + ".exe");
        }
        return path;
    }

    private static final Path unixCommand(String name) {
        return ShellPathUtilsKt.findExecutableOnPath(name);
    }

    private static final Path findExecutableOnPath(String fileName) {
        String string = System.getenv("PATH");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(\"PATH\")");
        CharSequence charSequence = string;
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
        for (String dir : StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
            File file = new File(dir, fileName);
            if (!file.isFile() || !file.canExecute()) continue;
            Object[] objectArray = new Object[]{fileName, file.getAbsolutePath()};
            LoggerKt.getLOG().info("Found {} at {}", objectArray);
            return Paths.get(file.getAbsolutePath(), new String[0]);
        }
        return null;
    }

    @Nullable
    public static final Path findProjectCommandWithName(@NotNull String name, @NotNull Path projectFile) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)projectFile, (String)"projectFile");
        return ShellPathUtilsKt.isOSWindows() ? ShellPathUtilsKt.findFileRelativeToProjectFile(name + ".cmd", projectFile) : ShellPathUtilsKt.findFileRelativeToProjectFile(name, projectFile);
    }

    private static final Path findFileRelativeToProjectFile(String name, Path projectFile) {
        Path path;
        File file;
        File file2;
        File file3 = file2 = projectFile.resolveSibling(name).toFile();
        boolean bl = false;
        File file4 = file = file3.isFile() && file3.canExecute() ? file2 : null;
        if (file != null) {
            file3 = file;
            boolean bl2 = false;
            path = Paths.get(file3.getAbsolutePath(), new String[0]);
        } else {
            path = null;
        }
        return path;
    }
}

