#ifndef _KOIO_H
#define _KOIO_H
#include <stdio.h>

/** Makes the given file available at the specified path. */
void ko_add_file(const char *path, char *data, size_t len);

/** Removes the file at the specified path. */
void ko_del_file(const char *path);

/**
 * See fopen(3)
 *
 * Attempts to open a file in the koio filesystem and falls back to the genuine
 * filesystem if not found.
 *
 * The koio filesystem only supports mode="r". If you specify anything else for
 * a file which _does_ exist in the koio filesystem, NULL will be returned and
 * errno set. If you specify anything else for a file which _does not_ exist in
 * the koio filesystem, the mode string will be passed directly to fopen(3).
 */
FILE *ko_fopen(const char *path, const char *mode);

/**
 * Adds a path alias to the ko filesystem. If ko_fopen is called with a path
 * beginning with `prefix`, the prefix will be replaced with the alias and
 * attempted first. Then, the normal behavior of ko_fopen will proceed.
 *
 * You may add several aliases for the same prefix, they will be attempted in
 * the order they are added.
 *
 * A trailing path separator is not added to `path`.
 */
void ko_add_alias(const char *prefix, const char *path);

#endif
