/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.util.stream.IntStream;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.specialized.RubyArrayOneObject;
import org.jruby.specialized.RubyArrayTwoObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.func.ObjectObjectIntFunction;

public class ArrayBootstrap {
    public static final Handle ARRAY_H = new Handle(6, CodegenUtils.p(ArrayBootstrap.class), "array", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class), false);
    public static final Handle NUMERIC_ARRAY = new Handle(6, CodegenUtils.p(ArrayBootstrap.class), "literalArray", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class), false);
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandle ARRAY_HANDLE = Binder.from(RubyArray.class, ThreadContext.class, IRubyObject[].class).invokeStaticQuiet(LOOKUP, ArrayBootstrap.class, "array");

    public static CallSite array(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        MethodHandle handle = Binder.from(type2).collect(1, IRubyObject[].class).invoke(ARRAY_HANDLE);
        return new ConstantCallSite(handle);
    }

    public static RubyArray array(ThreadContext context, IRubyObject[] ary) {
        assert (ary.length > 2);
        return RubyArray.newArrayNoCopy(context.runtime, ary);
    }

    public static CallSite literalArray(MethodHandles.Lookup lookup, String name2, MethodType type2, String stringValues) {
        MutableCallSite site = new MutableCallSite(type2);
        Object[] values2 = switch (name2) {
            case "fixnumArray" -> Helpers.decodeLongString(stringValues);
            case "floatArray" -> (Object[])Helpers.decodeDoubleString(stringValues);
            default -> throw new RuntimeException("invalid literal array type");
        };
        MethodHandle handle = Binder.from(type2).append(site, values2).invokeStaticQuiet(ArrayBootstrap.class, name2);
        site.setTarget(handle);
        return site;
    }

    public static RubyArray fixnumArray(ThreadContext context, MutableCallSite site, long[] values2) {
        return ArrayBootstrap.bindArray(context, site, values2, values2.length, (runtime2, vals, index2) -> Convert.asFixnum(context, values2[index2]));
    }

    public static RubyArray floatArray(ThreadContext context, MutableCallSite site, double[] values2) {
        return ArrayBootstrap.bindArray(context, site, values2, values2.length, (runtime2, vals, index2) -> runtime2.newFloat(values2[index2]));
    }

    private static <ArrayType> RubyArray bindArray(ThreadContext context, MutableCallSite site, ArrayType values2, int size2, ObjectObjectIntFunction<Ruby, ArrayType, IRubyObject> mapper) {
        Ruby runtime2 = context.runtime;
        RubyClass Array2 = Access.arrayClass(context);
        return switch (size2) {
            case 1 -> ArrayBootstrap.bindArray(site, Array2, mapper.apply(runtime2, values2, 0));
            case 2 -> ArrayBootstrap.bindArray(site, Array2, mapper.apply(runtime2, values2, 0), mapper.apply(runtime2, values2, 1));
            default -> ArrayBootstrap.bindArray(site, Array2, (IRubyObject[])IntStream.range(0, size2).mapToObj(i2 -> (IRubyObject)mapper.apply(runtime2, values2, i2)).toArray(IRubyObject[]::new));
        };
    }

    private static RubyArray bindArray(MutableCallSite site, RubyClass arrayClass, IRubyObject car) {
        site.setTarget(Binder.from(site.type()).drop(0).append(Helpers.arrayOf(RubyClass.class, IRubyObject.class), new Object[]{arrayClass, car}).invokeConstructorQuiet(RubyArrayOneObject.class));
        return new RubyArrayOneObject(arrayClass, car);
    }

    private static RubyArray bindArray(MutableCallSite site, RubyClass arrayClass, IRubyObject car, IRubyObject cdr) {
        site.setTarget(Binder.from(site.type()).drop(0).append(Helpers.arrayOf(RubyClass.class, IRubyObject.class, IRubyObject.class), new Object[]{arrayClass, car, cdr}).invokeConstructorQuiet(RubyArrayTwoObject.class));
        return new RubyArrayTwoObject(arrayClass, car, cdr);
    }

    private static RubyArray bindArray(MutableCallSite site, RubyClass arrayClass, IRubyObject[] values2) {
        site.setTarget(Binder.from(site.type()).drop(0).append(arrayClass, values2).invokeStaticQuiet(RubyArray.class, "newSharedArray"));
        return RubyArray.newSharedArray(arrayClass, values2);
    }
}

