cmake_minimum_required (VERSION 3.4)

set(INPUTLEAP_VERSION_MAJOR 2)
set(INPUTLEAP_VERSION_MINOR 4)
set(INPUTLEAP_VERSION_PATCH 0)
set(INPUTLEAP_VERSION_STAGE "release")

# InputLeap Version
if(NOT DEFINED INPUTLEAP_VERSION_MAJOR)
    if(DEFINED ENV{INPUTLEAP_VERSION_MAJOR})
        set(INPUTLEAP_VERSION_MAJOR $ENV{INPUTLEAP_VERSION_MAJOR})
    else()
        set(INPUTLEAP_VERSION_MAJOR 2)
    endif()
endif()

if(NOT DEFINED INPUTLEAP_VERSION_MINOR)
    if(DEFINED ENV{INPUTLEAP_VERSION_MINOR})
        set(INPUTLEAP_VERSION_MINOR $ENV{INPUTLEAP_VERSION_MINOR})
    else()
        set(INPUTLEAP_VERSION_MINOR 3)
    endif()
endif()

if(NOT DEFINED INPUTLEAP_VERSION_PATCH)
    if(DEFINED ENV{INPUTLEAP_VERSION_PATCH})
        set(INPUTLEAP_VERSION_PATCH $ENV{INPUTLEAP_VERSION_PATCH})
    else()
        set(INPUTLEAP_VERSION_PATCH 2)
        message(WARNING "InputLeap version wasn't set. Set to ${INPUTLEAP_VERSION_MAJOR}.${INPUTLEAP_VERSION_MINOR}.${INPUTLEAP_VERSION_PATCH}")
    endif()
endif()

if(NOT DEFINED INPUTLEAP_VERSION_STAGE)
    if(DEFINED ENV{INPUTLEAP_VERSION_STAGE})
        set(INPUTLEAP_VERSION_STAGE $ENV{INPUTLEAP_VERSION_STAGE})
    else()
        set(INPUTLEAP_VERSION_STAGE "snapshot")
    endif()
endif()

if(NOT DEFINED INPUTLEAP_REVISION)
    if(DEFINED ENV{GIT_COMMIT})
        string(SUBSTRING $ENV{GIT_COMMIT} 0 8 INPUTLEAP_REVISION)
    else()
        find_program (GIT_BINARY git)
        if (NOT GIT_BINARY STREQUAL "GIT_BINARY-NOTFOUND")
            execute_process (
                COMMAND git rev-parse --short=8 HEAD
                WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
                OUTPUT_VARIABLE INPUTLEAP_REVISION
                OUTPUT_STRIP_TRAILING_WHITESPACE
            )
        endif()
    endif()
endif()

string(LENGTH "${INPUTLEAP_REVISION}" INPUTLEAP_REVISION_LENGTH)
if (NOT INPUTLEAP_REVISION_LENGTH EQUAL 8 OR NOT INPUTLEAP_REVISION MATCHES "^[a-f0-9]+")
    set(INPUTLEAP_REVISION "00000000")
    message(WARNING "revision not found. setting to ${INPUTLEAP_REVISION}")
endif()
unset(INPUTLEAP_REVISION_LENGTH)

if (DEFINED ENV{BUILD_NUMBER})
    set(INPUTLEAP_BUILD_NUMBER $ENV{BUILD_NUMBER})
else()
    set(INPUTLEAP_BUILD_NUMBER 1)
endif()

string(TIMESTAMP INPUTLEAP_BUILD_DATE "%Y%m%d" UTC)
string(TIMESTAMP INPUTLEAP_BUILD_TIME "%H%M" UTC)
string(TIMESTAMP INPUTLEAP_BUILD_DATE_ISO "%Y-%m-%d" UTC)
set(INPUTLEAP_SNAPSHOT_INFO ".${INPUTLEAP_VERSION_STAGE}.${INPUTLEAP_REVISION}")

if(INPUTLEAP_VERSION_STAGE STREQUAL "snapshot")
    set(INPUTLEAP_VERSION_TAG "${INPUTLEAP_VERSION_STAGE}.b${INPUTLEAP_BUILD_NUMBER}-${INPUTLEAP_REVISION}")
else()
    set(INPUTLEAP_VERSION_TAG "${INPUTLEAP_VERSION_STAGE}")
endif()

set(INPUTLEAP_VERSION "${INPUTLEAP_VERSION_MAJOR}.${INPUTLEAP_VERSION_MINOR}.${INPUTLEAP_VERSION_PATCH}-${INPUTLEAP_VERSION_STAGE}")
set(INPUTLEAP_VERSION_STRING "${INPUTLEAP_VERSION}-${INPUTLEAP_VERSION_TAG}")
message(STATUS "Full InputLeap version string is '" ${INPUTLEAP_VERSION_STRING} "'")

add_definitions(-DINPUTLEAP_VERSION="${INPUTLEAP_VERSION}")
add_definitions(-DINPUTLEAP_VERSION_STRING="${INPUTLEAP_VERSION_STRING}")
add_definitions(-DINPUTLEAP_VERSION_MAJOR=${INPUTLEAP_VERSION_MAJOR})
add_definitions(-DINPUTLEAP_VERSION_MINOR=${INPUTLEAP_VERSION_MINOR})
add_definitions(-DINPUTLEAP_VERSION_PATCH=${INPUTLEAP_VERSION_PATCH})
add_definitions(-DINPUTLEAP_REVISION="${INPUTLEAP_REVISION}")
add_definitions(-DINPUTLEAP_BUILD_DATE="${INPUTLEAP_BUILD_DATE}")
add_definitions(-DINPUTLEAP_BUILD_NUMBER=${INPUTLEAP_BUILD_NUMBER})

if(INPUTLEAP_DEVELOPER_MODE)
    add_definitions(-DINPUTLEAP_DEVELOPER_MODE=1)
endif()

