<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw dns`
This API allows you to manage your domains, DNS zones and records.
  
- [TLS certificate management](#tls-certificate-management)
  - [Create or get the DNS zone's TLS certificate](#create-or-get-the-dns-zone's-tls-certificate)
  - [Delete a TLS certificate](#delete-a-tls-certificate)
  - [Get a DNS zone's TLS certificate](#get-a-dns-zone's-tls-certificate)
  - [List a user's TLS certificates](#list-a-user's-tls-certificates)
- [DNS records management](#dns-records-management)
  - [Add a new DNS record](#add-a-new-dns-record)
  - [Update records within a DNS zone](#update-records-within-a-dns-zone)
  - [Clear records within a DNS zone](#clear-records-within-a-dns-zone)
  - [Delete a DNS record](#delete-a-dns-record)
  - [List records within a DNS zone](#list-records-within-a-dns-zone)
  - [List name servers within a DNS zone](#list-name-servers-within-a-dns-zone)
  - [Update a DNS record](#update-a-dns-record)
  - [Update name servers within a DNS zone](#update-name-servers-within-a-dns-zone)
- [Transaction SIGnature key management](#transaction-signature-key-management)
  - [Delete the DNS zone's TSIG key](#delete-the-dns-zone's-tsig-key)
  - [Get the DNS zone's TSIG key](#get-the-dns-zone's-tsig-key)
- [DNS zones version management](#dns-zones-version-management)
  - [Access differences from a specific DNS zone version](#access-differences-from-a-specific-dns-zone-version)
  - [List versions of a DNS zone](#list-versions-of-a-dns-zone)
  - [Restore a DNS zone version](#restore-a-dns-zone-version)
  - [List records from a given version of a specific DNS zone](#list-records-from-a-given-version-of-a-specific-dns-zone)
- [DNS Zones management](#dns-zones-management)
  - [Clone a DNS zone](#clone-a-dns-zone)
  - [Create a DNS zone](#create-a-dns-zone)
  - [Delete a DNS zone](#delete-a-dns-zone)
  - [Export a raw DNS zone](#export-a-raw-dns-zone)
  - [Import a raw DNS zone](#import-a-raw-dns-zone)
  - [List DNS zones](#list-dns-zones)
  - [Refresh a DNS zone](#refresh-a-dns-zone)
  - [Update a DNS zone](#update-a-dns-zone)

  
## TLS certificate management

TLS certificate management.


### Create or get the DNS zone's TLS certificate

Create a new TLS certificate or retrieve information about an existing TLS certificate.

**Usage:**

```
scw dns certificate create <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required |  |
| alternative-dns-zones.{index} |  |  |



### Delete a TLS certificate

Delete an existing TLS certificate specified by its DNS zone. Deleting a TLS certificate is permanent and cannot be undone.

**Usage:**

```
scw dns certificate delete <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required |  |



### Get a DNS zone's TLS certificate

Get the DNS zone's TLS certificate. If you do not have a certificate, the output returns `no certificate found`.

**Usage:**

```
scw dns certificate get <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required |  |



### List a user's TLS certificates

List all the TLS certificates a user has created, specified by the user's Project ID and the DNS zone.

**Usage:**

```
scw dns certificate list <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required |  |
| project-id |  |  |



## DNS records management

DNS records management.


### Add a new DNS record



**Usage:**

```
scw dns record add <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | DNS zone in which to add the record |
| data | Required |  |
| name |  |  |
| priority |  |  |
| ttl | Required<br />Default: `3600` |  |
| type | Required<br />One of: `A`, `AAAA`, `CNAME`, `TXT`, `SRV`, `TLSA`, `MX`, `NS`, `PTR`, `CAA`, `ALIAS`, `LOC`, `SSHFP`, `HINFO`, `RP`, `URI`, `DS`, `NAPTR` |  |
| comment |  |  |
| geo-ip-config.matches.{index}.countries.{index} |  |  |
| geo-ip-config.matches.{index}.continents.{index} |  |  |
| geo-ip-config.matches.{index}.data |  |  |
| geo-ip-config.default |  |  |
| http-service-config.ips.{index} |  |  |
| http-service-config.must-contain |  |  |
| http-service-config.url |  |  |
| http-service-config.user-agent |  |  |
| http-service-config.strategy | One of: `random`, `hashed` |  |
| weighted-config.weighted-ips.{index}.ip |  |  |
| weighted-config.weighted-ips.{index}.weight |  |  |
| view-config.views.{index}.subnet |  |  |
| view-config.views.{index}.data |  |  |


**Examples:**


Add a CNAME
```
scw dns record add my-domain.tld data=www name=www2 type=CNAME
```

Add an IP
```
scw dns record add my-domain.tld data=1.2.3.4 name=vpn type=A
```




### Update records within a DNS zone

Update records within a DNS zone that has default name servers and perform several actions on your records.

Actions include:
 - add: allows you to add a new record or add a new IP to an existing A record, for example
 - set: allows you to edit a record or edit an IP from an existing A record, for example
 - delete: allows you to delete a record or delete an IP from an existing A record, for example
 - clear: allows you to delete all records from a DNS zone

All edits will be versioned.

**Usage:**

```
scw dns record bulk-update <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | DNS zone in which to update the DNS zone records |
| changes.{index}.add.records.{index}.data |  |  |
| changes.{index}.add.records.{index}.name |  |  |
| changes.{index}.add.records.{index}.priority |  |  |
| changes.{index}.add.records.{index}.ttl |  |  |
| changes.{index}.add.records.{index}.type | One of: `unknown`, `A`, `AAAA`, `CNAME`, `TXT`, `SRV`, `TLSA`, `MX`, `NS`, `PTR`, `CAA`, `ALIAS`, `LOC`, `SSHFP`, `HINFO`, `RP`, `URI`, `DS`, `NAPTR`, `DNAME`, `SVCB`, `HTTPS` |  |
| changes.{index}.add.records.{index}.comment |  |  |
| changes.{index}.add.records.{index}.geo-ip-config.matches.{index}.countries.{index} |  |  |
| changes.{index}.add.records.{index}.geo-ip-config.matches.{index}.continents.{index} |  |  |
| changes.{index}.add.records.{index}.geo-ip-config.matches.{index}.data |  |  |
| changes.{index}.add.records.{index}.geo-ip-config.default |  |  |
| changes.{index}.add.records.{index}.http-service-config.ips.{index} |  |  |
| changes.{index}.add.records.{index}.http-service-config.must-contain |  |  |
| changes.{index}.add.records.{index}.http-service-config.url |  |  |
| changes.{index}.add.records.{index}.http-service-config.user-agent |  |  |
| changes.{index}.add.records.{index}.http-service-config.strategy | One of: `random`, `hashed`, `all` |  |
| changes.{index}.add.records.{index}.weighted-config.weighted-ips.{index}.ip |  |  |
| changes.{index}.add.records.{index}.weighted-config.weighted-ips.{index}.weight |  |  |
| changes.{index}.add.records.{index}.view-config.views.{index}.subnet |  |  |
| changes.{index}.add.records.{index}.view-config.views.{index}.data |  |  |
| changes.{index}.add.records.{index}.id |  |  |
| changes.{index}.set.id |  |  |
| changes.{index}.set.id-fields.name |  |  |
| changes.{index}.set.id-fields.type | One of: `unknown`, `A`, `AAAA`, `CNAME`, `TXT`, `SRV`, `TLSA`, `MX`, `NS`, `PTR`, `CAA`, `ALIAS`, `LOC`, `SSHFP`, `HINFO`, `RP`, `URI`, `DS`, `NAPTR`, `DNAME`, `SVCB`, `HTTPS` |  |
| changes.{index}.set.id-fields.data |  |  |
| changes.{index}.set.id-fields.ttl |  |  |
| changes.{index}.set.records.{index}.data |  |  |
| changes.{index}.set.records.{index}.name |  |  |
| changes.{index}.set.records.{index}.priority |  |  |
| changes.{index}.set.records.{index}.ttl |  |  |
| changes.{index}.set.records.{index}.type | One of: `unknown`, `A`, `AAAA`, `CNAME`, `TXT`, `SRV`, `TLSA`, `MX`, `NS`, `PTR`, `CAA`, `ALIAS`, `LOC`, `SSHFP`, `HINFO`, `RP`, `URI`, `DS`, `NAPTR`, `DNAME`, `SVCB`, `HTTPS` |  |
| changes.{index}.set.records.{index}.comment |  |  |
| changes.{index}.set.records.{index}.geo-ip-config.matches.{index}.countries.{index} |  |  |
| changes.{index}.set.records.{index}.geo-ip-config.matches.{index}.continents.{index} |  |  |
| changes.{index}.set.records.{index}.geo-ip-config.matches.{index}.data |  |  |
| changes.{index}.set.records.{index}.geo-ip-config.default |  |  |
| changes.{index}.set.records.{index}.http-service-config.ips.{index} |  |  |
| changes.{index}.set.records.{index}.http-service-config.must-contain |  |  |
| changes.{index}.set.records.{index}.http-service-config.url |  |  |
| changes.{index}.set.records.{index}.http-service-config.user-agent |  |  |
| changes.{index}.set.records.{index}.http-service-config.strategy | One of: `random`, `hashed`, `all` |  |
| changes.{index}.set.records.{index}.weighted-config.weighted-ips.{index}.ip |  |  |
| changes.{index}.set.records.{index}.weighted-config.weighted-ips.{index}.weight |  |  |
| changes.{index}.set.records.{index}.view-config.views.{index}.subnet |  |  |
| changes.{index}.set.records.{index}.view-config.views.{index}.data |  |  |
| changes.{index}.set.records.{index}.id |  |  |
| changes.{index}.delete.id |  |  |
| changes.{index}.delete.id-fields.name |  |  |
| changes.{index}.delete.id-fields.type | One of: `unknown`, `A`, `AAAA`, `CNAME`, `TXT`, `SRV`, `TLSA`, `MX`, `NS`, `PTR`, `CAA`, `ALIAS`, `LOC`, `SSHFP`, `HINFO`, `RP`, `URI`, `DS`, `NAPTR`, `DNAME`, `SVCB`, `HTTPS` |  |
| changes.{index}.delete.id-fields.data |  |  |
| changes.{index}.delete.id-fields.ttl |  |  |
| return-all-records |  | Specifies whether or not to return all the records |
| disallow-new-zone-creation |  | Disable the creation of the target zone if it does not exist. Target zone creation is disabled by default |
| serial |  | Use the provided serial (0) instead of the auto-increment serial |



### Clear records within a DNS zone

Delete all records within a DNS zone that has default name servers.<br/>
All edits will be versioned.

**Usage:**

```
scw dns record clear <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | DNS zone to clear |



### Delete a DNS record



**Usage:**

```
scw dns record delete <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | DNS zone in which to delete the record |
| data |  |  |
| name |  |  |
| ttl |  |  |
| type | Required<br />One of: `A`, `AAAA`, `CNAME`, `TXT`, `SRV`, `TLSA`, `MX`, `NS`, `PTR`, `CAA`, `ALIAS`, `LOC`, `SSHFP`, `HINFO`, `RP`, `URI`, `DS`, `NAPTR` |  |


**Examples:**


Delete a CNAME
```
scw dns record delete my-domain.tld name=www type=CNAME
```

Delete a single IP from a record with more than one
```
scw dns record delete my-domain.tld data=1.2.3.4 name=vpn type=A
```




### List records within a DNS zone

Retrieve a list of DNS records within a DNS zone that has default name servers.
You can filter records by type and name.

**Usage:**

```
scw dns record list <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID on which to filter the returned DNS zone records |
| order-by | One of: `name_asc`, `name_desc` | Sort order of the returned DNS zone records |
| dns-zone | Required | DNS zone on which to filter the returned DNS zone records |
| name |  | Name on which to filter the returned DNS zone records |
| type | One of: `unknown`, `A`, `AAAA`, `CNAME`, `TXT`, `SRV`, `TLSA`, `MX`, `NS`, `PTR`, `CAA`, `ALIAS`, `LOC`, `SSHFP`, `HINFO`, `RP`, `URI`, `DS`, `NAPTR`, `DNAME`, `SVCB`, `HTTPS` | Record type on which to filter the returned DNS zone records |
| id |  | Record ID on which to filter the returned DNS zone records |



### List name servers within a DNS zone

Retrieve a list of name servers within a DNS zone and their optional glue records.

**Usage:**

```
scw dns record list-nameservers <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID on which to filter the returned DNS zone name servers |
| dns-zone | Required | DNS zone on which to filter the returned DNS zone name servers |



### Update a DNS record

This command will replace all the data for this record with the given values.

**Usage:**

```
scw dns record set <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | DNS zone in which to set the record |
| values.{index} | Required | A list of values for replacing the record data. (multiple values cannot be used for all type) |
| name | Required |  |
| priority |  |  |
| ttl | Required<br />Default: `3600` |  |
| type | Required<br />One of: `A`, `AAAA`, `CNAME`, `TXT`, `SRV`, `TLSA`, `MX`, `NS`, `PTR`, `CAA`, `ALIAS`, `LOC`, `SSHFP`, `HINFO`, `RP`, `URI`, `DS`, `NAPTR` |  |
| comment |  |  |
| geo-ip-config.matches.{index}.countries.{index} |  |  |
| geo-ip-config.matches.{index}.continents.{index} |  |  |
| geo-ip-config.matches.{index}.data |  |  |
| geo-ip-config.default |  |  |
| http-service-config.ips.{index} |  |  |
| http-service-config.must-contain |  |  |
| http-service-config.url |  |  |
| http-service-config.user-agent |  |  |
| http-service-config.strategy | One of: `random`, `hashed` |  |
| weighted-config.weighted-ips.{index}.ip |  |  |
| weighted-config.weighted-ips.{index}.weight |  |  |
| view-config.views.{index}.subnet |  |  |
| view-config.views.{index}.data |  |  |


**Examples:**


Add or replace a CNAME
```
scw dns record set my-domain.tld values.0=www name=www2 type=CNAME
```

Add or replace a list of IP
```
scw dns record set my-domain.tld values.0=1.2.3.4 values.1=1.2.3.5 name=vpn type=A
```




### Update name servers within a DNS zone

Update name servers within a DNS zone and set optional glue records.

**Usage:**

```
scw dns record update-nameservers <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | DNS zone in which to update the DNS zone name servers |
| ns.{index}.name |  |  |
| ns.{index}.ip.{index} |  |  |



## Transaction SIGnature key management

Transaction SIGnature key management.


### Delete the DNS zone's TSIG key

Delete an existing TSIG key specified by its DNS zone. Deleting a TSIG key is permanent and cannot be undone.

**Usage:**

```
scw dns tsig-key delete <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required |  |



### Get the DNS zone's TSIG key

Retrieve information about the TSIG key of a given DNS zone to allow AXFR requests.

**Usage:**

```
scw dns tsig-key get <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required |  |



## DNS zones version management

DNS zones version management.


### Access differences from a specific DNS zone version

Access a previous DNS zone version to see the differences from another specific version.

**Usage:**

```
scw dns version diff <dns-zone-version-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone-version-id | Required |  |



### List versions of a DNS zone

Retrieve a list of a DNS zone's versions.<br/>
The maximum version count is 100. If the count reaches this limit, the oldest version will be deleted after each new modification.

**Usage:**

```
scw dns version list <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required |  |



### Restore a DNS zone version

Restore and activate a version of a specific DNS zone.

**Usage:**

```
scw dns version restore <dns-zone-version-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone-version-id | Required |  |



### List records from a given version of a specific DNS zone

Retrieve a list of records from a specific DNS zone version.

**Usage:**

```
scw dns version show <dns-zone-version-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone-version-id | Required |  |



## DNS Zones management

DNS Zones management.


### Clone a DNS zone

Clone an existing DNS zone with all its records into a new DNS zone.

**Usage:**

```
scw dns zone clone [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | DNS zone to clone |
| dest-dns-zone | Required | Destination DNS zone in which to clone the chosen DNS zone |
| overwrite |  | Specifies whether or not the destination DNS zone will be overwritten |
| project-id |  | Project ID of the destination DNS zone |



### Create a DNS zone

Create a new DNS zone specified by the domain name, the subdomain and the Project ID.

**Usage:**

```
scw dns zone create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain | Required | Domain in which to crreate the DNS zone |
| subdomain | Required | Subdomain of the DNS zone to create |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Delete a DNS zone

Delete a DNS zone and all its records.

**Usage:**

```
scw dns zone delete <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | DNS zone to delete |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Export a raw DNS zone

Export a DNS zone with default name servers, in a specific format.

**Usage:**

```
scw dns zone export <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | DNS zone to export |
| format | Default: `bind`<br />One of: `unknown_raw_format`, `bind` | DNS zone format |



### Import a raw DNS zone

Import and replace the format of records from a given provider, with default name servers.

**Usage:**

```
scw dns zone import <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | DNS zone to import |
| ~~content~~ | Deprecated |  |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| ~~format~~ | Deprecated<br />One of: `unknown_raw_format`, `bind` |  |
| bind-source.content |  |  |
| axfr-source.name-server |  |  |
| axfr-source.tsig-key.name |  |  |
| axfr-source.tsig-key.key |  |  |
| axfr-source.tsig-key.algorithm |  |  |



### List DNS zones

Retrieve the list of DNS zones you can manage and filter DNS zones associated with specific domain names.

**Usage:**

```
scw dns zone list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID on which to filter the returned DNS zones |
| order-by | One of: `domain_asc`, `domain_desc`, `subdomain_asc`, `subdomain_desc`, `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc` | Sort order of the returned DNS zones |
| domain |  | Domain on which to filter the returned DNS zones |
| ~~dns-zone~~ | Deprecated | DNS zone on which to filter the returned DNS zones |
| dns-zones.{index} |  | DNS zones on which to filter the returned DNS zones |
| created-after |  | Only list DNS zones created after this date |
| created-before |  | Only list DNS zones created before this date |
| updated-after |  | Only list DNS zones updated after this date |
| updated-before |  | Only list DNS zones updated before this date |
| organization-id |  | Organization ID on which to filter the returned DNS zones |



### Refresh a DNS zone

Refresh an SOA DNS zone to reload the records in the DNS zone and update the SOA serial.
You can recreate the given DNS zone and its sub DNS zone if needed.

**Usage:**

```
scw dns zone refresh <dns-zone ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | DNS zone to refresh |
| recreate-dns-zone |  | Specifies whether or not to recreate the DNS zone |
| recreate-sub-dns-zone |  | Specifies whether or not to recreate the sub DNS zone |



### Update a DNS zone

Update the name and/or the Organizations for a DNS zone.

**Usage:**

```
scw dns zone update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-zone | Required | DNS zone to update |
| new-dns-zone | Required | Name of the new DNS zone to create |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



