<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw tem`
This API allows you to manage your Transactional Email services.
  
- [Blocklist](#blocklist)
  - [Bulk create blocklists](#bulk-create-blocklists)
  - [Delete a blocklist](#delete-a-blocklist)
  - [List blocklists](#list-blocklists)
- [Domain management commands](#domain-management-commands)
  - [Domain DNS check](#domain-dns-check)
  - [Register a domain in a project](#register-a-domain-in-a-project)
  - [Get information about a domain](#get-information-about-a-domain)
  - [Display SPF, DKIM, DMARC and MX records status and potential errors](#display-spf,-dkim,-dmarc-and-mx-records-status-and-potential-errors)
  - [List domains](#list-domains)
  - [Delete a domain](#delete-a-domain)
  - [Update a domain](#update-a-domain)
- [Email management commands](#email-management-commands)
  - [Cancel an email](#cancel-an-email)
  - [Send an email](#send-an-email)
  - [Get an email](#get-an-email)
  - [Email statuses](#email-statuses)
  - [List emails](#list-emails)
- [Project offers management commands](#project-offers-management-commands)
  - [List the available offers.](#list-the-available-offers.)
  - [Update a subscribed offer](#update-a-subscribed-offer)
- [Project consumption management commands](#project-consumption-management-commands)
  - [Get project resource consumption.](#get-project-resource-consumption.)
- [Project settings management commands](#project-settings-management-commands)
- [Webhook management commands](#webhook-management-commands)
  - [Create a Webhook](#create-a-webhook)
  - [Delete a Webhook](#delete-a-webhook)
  - [Get information about a Webhook](#get-information-about-a-webhook)
  - [List Webhooks](#list-webhooks)
  - [List Webhook triggered events](#list-webhook-triggered-events)
  - [Update a Webhook](#update-a-webhook)

  
## Blocklist

This section allows you to manage the blocklist of your emails.


### Bulk create blocklists

Create multiple blocklists in a specific Project or Organization using the `region` parameter.

**Usage:**

```
scw tem blocklists create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-id |  | Domain ID linked to the blocklist |
| emails.{index} |  | Email blocked by the blocklist |
| type | One of: `unknown_type`, `mailbox_full`, `mailbox_not_found` | Type of blocklist |
| reason |  | Reason to block the email |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Delete a blocklist

You must specify the blocklist you want to delete by the `region` and `blocklist_id`.

**Usage:**

```
scw tem blocklists delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| blocklist-id | Required | ID of the blocklist to delete |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### List blocklists

Retrieve the list of blocklists.

**Usage:**

```
scw tem blocklists list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_desc`, `created_at_asc`, `ends_at_desc`, `ends_at_asc` | (Optional) List blocklist corresponding to specific criteria |
| domain-id |  | (Optional) Filter by a domain ID |
| email |  | (Optional) Filter by an email address |
| type | One of: `unknown_type`, `mailbox_full`, `mailbox_not_found` | (Optional) Filter by a blocklist type |
| custom |  | (Optional) Filter by custom blocklist (true) or automatic Transactional Email blocklist (false) |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



## Domain management commands

This section lists your domains, shows you to manage them, and gives you information about them.


### Domain DNS check

Perform an immediate DNS check of a domain using the `region` and `domain_id` parameters.

**Usage:**

```
scw tem domain check <domain-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-id | Required | ID of the domain to check |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Register a domain in a project

You must specify the `region`, `project_id` and `domain_name` to register a domain in a specific Project.

**Usage:**

```
scw tem domain create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| domain-name |  | Fully qualified domain dame |
| ~~accept-tos~~ | Deprecated | Deprecated. Accept Scaleway's Terms of Service |
| autoconfig |  | Activate auto-configuration of the domain's DNS zone |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Get information about a domain

Retrieve information about a specific domain using the `region` and `domain_id` parameters. Monitor your domain's reputation and improve **average** and **bad** reputation statuses, using your domain's **Email activity** tab on the [Scaleway console](https://console.scaleway.com/transactional-email/domains) to get a more detailed report. Check out our [dedicated documentation](https://www.scaleway.com/en/docs/managed-services/transactional-email/reference-content/understanding-tem-reputation-score/) to improve your domain's reputation.

**Usage:**

```
scw tem domain get <domain-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-id | Required | ID of the domain |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Display SPF, DKIM, DMARC and MX records status and potential errors

Display SPF, DKIM, DMARC and MX records status and potential errors, including the found records to make debugging easier.

**Usage:**

```
scw tem domain get-last-status <domain-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-id | Required | ID of the domain to get records status |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### List domains

Retrieve domains in a specific Project or in a specific Organization using the `region` parameter.

**Usage:**

```
scw tem domain list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | (Optional) ID of the Project in which to list the domains |
| status.{index} | One of: `unknown`, `checked`, `unchecked`, `invalid`, `locked`, `revoked`, `pending`, `autoconfiguring` | (Optional) List domains under specific statuses |
| name |  | (Optional) Names of the domains to list |
| organization-id |  | (Optional) ID of the Organization in which to list the domains |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



### Delete a domain

You must specify the domain you want to delete by the `region` and `domain_id`. Deleting a domain is permanent and cannot be undone.

**Usage:**

```
scw tem domain revoke <domain-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-id | Required | ID of the domain to delete |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Update a domain

Update a domain auto-configuration.

**Usage:**

```
scw tem domain update <domain-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-id | Required | ID of the domain to update |
| autoconfig |  | (Optional) If set to true, activate auto-configuration of the domain's DNS zone |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



## Email management commands

This section lists your emails and shows you how to manage them.


### Cancel an email

You can cancel the sending of an email if it has not been sent yet. You must specify the `region` and the `email_id` of the email you want to cancel.

**Usage:**

```
scw tem email cancel <email-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| email-id | Required | ID of the email to cancel |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Send an email

You must specify the `region`, the sender and the recipient's information and the `project_id` to send an email from a checked domain. The subject of the email must contain at least 6 characters.

**Usage:**

```
scw tem email create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| from.email |  | Email address |
| from.name |  | (Optional) Name displayed |
| to.{index}.email |  | Email address |
| to.{index}.name |  | (Optional) Name displayed |
| cc.{index}.email |  | Email address |
| cc.{index}.name |  | (Optional) Name displayed |
| bcc.{index}.email |  | Email address |
| bcc.{index}.name |  | (Optional) Name displayed |
| subject |  | Subject of the email |
| text |  | Text content |
| html |  | HTML content |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| attachments.{index}.name |  | Filename of the attachment |
| attachments.{index}.type |  | MIME type of the attachment |
| attachments.{index}.content |  | Content of the attachment encoded in base64 |
| send-before |  | Maximum date to deliver the email |
| additional-headers.{index}.key |  | Email header key |
| additional-headers.{index}.value |  | Email header value |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Get an email

Retrieve information about a specific email using the `email_id` and `region` parameters.

**Usage:**

```
scw tem email get <email-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| email-id | Required | ID of the email to retrieve |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Email statuses

Get information on your emails' statuses.

**Usage:**

```
scw tem email get-statistics [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | (Optional) Number of emails for this Project |
| domain-id |  | (Optional) Number of emails sent from this domain (must be coherent with the `project_id` and the `organization_id`) |
| since |  | (Optional) Number of emails created after this date |
| until |  | (Optional) Number of emails created before this date |
| mail-from |  | (Optional) Number of emails sent with this sender's email address |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### List emails

Retrieve the list of emails sent from a specific domain or for a specific Project or Organization. You must specify the `region`.

**Usage:**

```
scw tem email list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | (Optional) ID of the Project in which to list the emails |
| domain-id |  | (Optional) ID of the domain for which to list the emails |
| message-id |  | (Optional) ID of the message for which to list the emails |
| since |  | (Optional) List emails created after this date |
| until |  | (Optional) List emails created before this date |
| mail-from |  | (Optional) List emails sent with this sender's email address |
| ~~mail-to~~ | Deprecated | Deprecated. List emails sent to this recipient's email address |
| mail-rcpt |  | (Optional) List emails sent to this recipient's email address |
| statuses.{index} | One of: `unknown`, `new`, `sending`, `sent`, `failed`, `canceled` | (Optional) List emails with any of these statuses |
| subject |  | (Optional) List emails with this subject |
| search |  | (Optional) List emails by searching to all fields |
| order-by | One of: `created_at_desc`, `created_at_asc`, `updated_at_desc`, `updated_at_asc`, `status_desc`, `status_asc`, `mail_from_desc`, `mail_from_asc`, `mail_rcpt_desc`, `mail_rcpt_asc`, `subject_desc`, `subject_asc` | (Optional) List emails corresponding to specific criteria |
| flags.{index} | One of: `unknown_flag`, `soft_bounce`, `hard_bounce`, `spam`, `mailbox_full`, `mailbox_not_found`, `greylisted`, `send_before_expiration`, `blocklisted` | (Optional) List emails containing only specific flags |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



## Project offers management commands

This section allows you to manage and get get subscribed information about your project email offer.


### List the available offers.

Retrieve the list of the available and free-of-charge offers you can subscribe to.

**Usage:**

```
scw tem offers list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Update a subscribed offer

Update a subscribed offer.

**Usage:**

```
scw tem offers update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | One of: `unknown_name`, `essential`, `scale` | Name of the offer-subscription |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



## Project consumption management commands

Project consumption allow you to see your project consumption.


### Get project resource consumption.

Get project resource consumption.

**Usage:**

```
scw tem project-consumption get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



## Project settings management commands

Project settings allow you to manage the configuration of your projects.

Project settings allow you to manage the configuration of your projects.

**Usage:**

```
scw tem project-settings
```



## Webhook management commands

Webhooks enable real-time communication and automation between systems by sending messages through all protocols supported by SNS, such as HTTP, HTTPS, and Serverless Functions, allowing for immediate updates and actions based on specific events. This feature is in beta. You can request quotas from the [Scaleway betas page](https://www.scaleway.com/fr/betas/#email-webhooks).


### Create a Webhook

Create a new Webhook triggered by a list of event types and pushed to a Scaleway SNS ARN.

**Usage:**

```
scw tem webhook create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-id |  | ID of the Domain to watch for triggering events |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name |  | Name of the Webhook |
| event-types.{index} | One of: `unknown_type`, `email_queued`, `email_dropped`, `email_deferred`, `email_delivered`, `email_spam`, `email_mailbox_not_found`, `email_blocklisted`, `blocklist_created` | List of event types that will trigger an event |
| sns-arn |  | Scaleway SNS ARN topic to push the events to |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Delete a Webhook

You must specify the Webhook you want to delete by the `region` and `webhook_id`. Deleting a Webhook is permanent and cannot be undone.

**Usage:**

```
scw tem webhook delete <webhook-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| webhook-id | Required | ID of the Webhook to delete |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Get information about a Webhook

Retrieve information about a specific Webhook using the `webhook_id` and `region` parameters.

**Usage:**

```
scw tem webhook get <webhook-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| webhook-id | Required | ID of the Webhook to check |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### List Webhooks

Retrieve Webhooks in a specific Project or in a specific Organization using the `region` parameter.

**Usage:**

```
scw tem webhook list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_desc`, `created_at_asc` | (Optional) List Webhooks corresponding to specific criteria |
| project-id |  | (Optional) ID of the Project for which to list the Webhooks |
| domain-id |  | (Optional) ID of the Domain for which to list the Webhooks |
| organization-id |  | (Optional) ID of the Organization for which to list the Webhooks |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



### List Webhook triggered events

Retrieve the list of Webhook events triggered from a specific Webhook or for a specific Project or Organization. You must specify the `region`.

**Usage:**

```
scw tem webhook list-events [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_desc`, `created_at_asc` | (Optional) List Webhook events corresponding to specific criteria |
| webhook-id | Required | ID of the Webhook linked to the events |
| email-id |  | ID of the email linked to the events |
| event-types.{index} | One of: `unknown_type`, `email_queued`, `email_dropped`, `email_deferred`, `email_delivered`, `email_spam`, `email_mailbox_not_found`, `email_blocklisted`, `blocklist_created` | List of event types linked to the events |
| statuses.{index} | One of: `unknown_status`, `sending`, `sent`, `failed` | List of event statuses |
| project-id |  | ID of the webhook Project |
| domain-id |  | ID of the domain to watch for triggering events |
| organization-id |  | ID of the webhook Organization |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



### Update a Webhook

Update a Webhook events type, SNS ARN or name.

**Usage:**

```
scw tem webhook update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| webhook-id | Required | ID of the Webhook to update |
| name |  | Name of the Webhook to update |
| event-types.{index} | One of: `unknown_type`, `email_queued`, `email_dropped`, `email_deferred`, `email_delivered`, `email_spam`, `email_mailbox_not_found`, `email_blocklisted`, `blocklist_created` | List of event types to update |
| sns-arn |  | Scaleway SNS ARN topic to update |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



