// This file is part of the FXT library.
// Copyright (C) 2010, 2011, 2012 Joerg Arndt
// License: GNU General Public License version 3 or later,
// see the file COPYING.txt in the main directory.

#include "mod/mtypes.h"
#include "fxttypes.h"
#include "bits/bitsperlong.h"


extern const ulong mersenne_generators_tab[] =
// Elements of maximal order modulo Mersenne numbers m=2^e-1
// Should have at least BITS_PER_LONG+1 elements.
{
    // e:  gen  // maxorder
    /*0:*/ 0,  // 0
    /*1:*/ 1,  // 1
    /*2:*/ 2,  // 2
    /*3:*/ 3,  // 6
    /*4:*/ 2,  // 4
    /*5:*/ 3,  // 30
    /*6:*/ 2,  // 6
    /*7:*/ 3,  // 126
    /*8:*/ 7,  // 16
    /*9:*/ 5,  // 72
    /*10:*/ 5,  // 30
    /*11:*/ 3,  // 88
    /*12:*/ 2,  // 12
    /*13:*/ 17,  // 8190
    /*14:*/ 7,  // 126
    /*15:*/ 3,  // 150
    /*16:*/ 7,  // 256
    /*17:*/ 3,  // 131070
    /*18:*/ 5,  // 72
    /*19:*/ 3,  // 524286
    /*20:*/ 7,  // 120
    /*21:*/ 11,  // 1008
    /*22:*/ 7,  // 2728
    /*23:*/ 3,  // 178480
    /*24:*/ 23,  // 240
    /*25:*/ 7,  // 1800
    /*26:*/ 7,  // 8190
    /*27:*/ 5,  // 262656
    /*28:*/ 17,  // 1008
    /*29:*/ 3,  // 39672
    /*30:*/ 5,  // 1650
    /*31:*/ 7,  // 2147483646
    /*32:*/ 7,  // 65536
    /*33:*/ 3,  // 2397912
    /*34:*/ 5,  // 131070
    /*35:*/ 3,  // 1106280
    /*36:*/ 11,  // 216
    /*37:*/ 5,  // 616318176
    /*38:*/ 5,  // 524286
    /*39:*/ 11,  // 12743640
    /*40:*/ 7,  // 61680
    /*41:*/ 3,  // 26815350376
    /*42:*/ 5,  // 43344
    /*43:*/ 5,  // 1186422030
    /*44:*/ 7,  // 196416
    /*45:*/ 11,  // 466200
    /*46:*/ 11,  // 10849263760
    /*47:*/ 7,  // 1989679200
    /*48:*/ 37,  // 26880
    /*49:*/ 5,  // 4432676798592
    /*50:*/ 17,  // 81000
    /*51:*/ 3,  // 300019230
    /*52:*/ 7,  // 507780
    /*53:*/ 3,  // 8014999200
    /*54:*/ 5,  // 22325760
    /*55:*/ 15,  // 11713680
    /*56:*/ 7,  // 15790320
    /*57:*/ 13,  // 1584117566136
    /*58:*/ 7,  // 172890576
    /*59:*/ 3,  // 4885233465012400
    /*60:*/ 17,  // 6600
    /*61:*/ 37,  // 2305843009213693950
    /*62:*/ 5,  // 2147483646
    /*63:*/ 5,  // 119536704
    /*64:*/ 7,  // 17153064960
    // /*65:*/ 7,  // 145295143558110

#if  ( BITS_PER_LONG > 64 )
#error "Need data for BITS_PER_LONG > 64"
#endif  // ( BITS_PER_LONG > 64 )
};
// -------------------------


const umod_t mersenne_maxorder_tab[] =
// Maximal order modulo Mersenne numbers m=2^e-1
// Should have at least BITS_PER_LONG+1 elements.
{
    // e:  maxorder  // gen
    /*0:*/ 0ULL,  // 0
    /*1:*/ 1ULL,  // 1
    /*2:*/ 2ULL,  // 2
    /*3:*/ 6ULL,  // 3
    /*4:*/ 4ULL,  // 2
    /*5:*/ 30ULL,  // 3
    /*6:*/ 6ULL,  // 2
    /*7:*/ 126ULL,  // 3
    /*8:*/ 16ULL,  // 7
    /*9:*/ 72ULL,  // 5
    /*10:*/ 30ULL,  // 5
    /*11:*/ 88ULL,  // 3
    /*12:*/ 12ULL,  // 2
    /*13:*/ 8190ULL,  // 17
    /*14:*/ 126ULL,  // 7
    /*15:*/ 150ULL,  // 3
    /*16:*/ 256ULL,  // 7
    /*17:*/ 131070ULL,  // 3
    /*18:*/ 72ULL,  // 5
    /*19:*/ 524286ULL,  // 3
    /*20:*/ 120ULL,  // 7
    /*21:*/ 1008ULL,  // 11
    /*22:*/ 2728ULL,  // 7
    /*23:*/ 178480ULL,  // 3
    /*24:*/ 240ULL,  // 23
    /*25:*/ 1800ULL,  // 7
    /*26:*/ 8190ULL,  // 7
    /*27:*/ 262656ULL,  // 5
    /*28:*/ 1008ULL,  // 17
    /*29:*/ 39672ULL,  // 3
    /*30:*/ 1650ULL,  // 5
    /*31:*/ 2147483646ULL,  // 7
    /*32:*/ 65536ULL,  // 7
    /*33:*/ 2397912ULL,  // 3
    /*34:*/ 131070ULL,  // 5
    /*35:*/ 1106280ULL,  // 3
    /*36:*/ 216ULL,  // 11
    /*37:*/ 616318176ULL,  // 5
    /*38:*/ 524286ULL,  // 5
    /*39:*/ 12743640ULL,  // 11
    /*40:*/ 61680ULL,  // 7
    /*41:*/ 26815350376ULL,  // 3
    /*42:*/ 43344ULL,  // 5
    /*43:*/ 1186422030ULL,  // 5
    /*44:*/ 196416ULL,  // 7
    /*45:*/ 466200ULL,  // 11
    /*46:*/ 10849263760ULL,  // 11
    /*47:*/ 1989679200ULL,  // 7
    /*48:*/ 26880ULL,  // 37
    /*49:*/ 4432676798592ULL,  // 5
    /*50:*/ 81000ULL,  // 17
    /*51:*/ 300019230ULL,  // 3
    /*52:*/ 507780ULL,  // 7
    /*53:*/ 8014999200ULL,  // 3
    /*54:*/ 22325760ULL,  // 5
    /*55:*/ 11713680ULL,  // 15
    /*56:*/ 15790320ULL,  // 7
    /*57:*/ 1584117566136ULL,  // 13
    /*58:*/ 172890576ULL,  // 7
    /*59:*/ 4885233465012400ULL,  // 3
    /*60:*/ 6600ULL,  // 17
    /*61:*/ 2305843009213693950ULL,  // 37
    /*62:*/ 2147483646ULL,  // 5
    /*63:*/ 119536704ULL,  // 5
    /*64:*/ 17153064960ULL,  // 7
    // /*65:*/ 145295143558110ULL,  // 7

#if  ( BITS_PER_LONG > 64 )
#error "Need data for BITS_PER_LONG > 64"
#endif  // ( BITS_PER_LONG > 64 )
};
// -------------------------

