// This file is part of the FXT library.
// Copyright (C) 2010, 2012, 2015 Joerg Arndt
// License: GNU General Public License version 3 or later,
// see the file COPYING.txt in the main directory.

#include "array-len.h"
#include "fxttypes.h"
#include "bits/bitsperlong.h"

extern const ulong tiny_factors_tab[BITS_PER_LONG] =
{
                   0x0UL,  // x = 0:           ( bits: ........)
                   0x2UL,  // x = 1:  1        ( bits: ......1.)
                   0x6UL,  // x = 2:  1 2      ( bits: .....11.)
                   0xaUL,  // x = 3:  1 3      ( bits: ....1.1.)
                  0x16UL,  // x = 4:  1 2 4    ( bits: ...1.11.)
                  0x22UL,  // x = 5:  1 5      ( bits: ..1...1.)
                  0x4eUL,  // x = 6:  1 2 3 6  ( bits: .1..111.)
                  0x82UL,  // x = 7:  1 7      ( bits: 1.....1.)
                 0x116UL,  // x = 8:  1 2 4 8
                 0x20aUL,  // x = 9:  1 3 9
                 0x426UL,  // x = 10:  1 2 5 10
                 0x802UL,  // x = 11:  1 11
                0x105eUL,  // x = 12:  1 2 3 4 6 12
                0x2002UL,  // x = 13:  1 13
                0x4086UL,  // x = 14:  1 2 7 14
                0x802aUL,  // x = 15:  1 3 5 15
               0x10116UL,  // x = 16:  1 2 4 8 16
               0x20002UL,  // x = 17:  1 17
               0x4024eUL,  // x = 18:  1 2 3 6 9 18
               0x80002UL,  // x = 19:  1 19
              0x100436UL,  // x = 20:  1 2 4 5 10 20
              0x20008aUL,  // x = 21:  1 3 7 21
              0x400806UL,  // x = 22:  1 2 11 22
              0x800002UL,  // x = 23:  1 23
             0x100115eUL,  // x = 24:  1 2 3 4 6 8 12 24
             0x2000022UL,  // x = 25:  1 5 25
             0x4002006UL,  // x = 26:  1 2 13 26
             0x800020aUL,  // x = 27:  1 3 9 27
            0x10004096UL,  // x = 28:  1 2 4 7 14 28
            0x20000002UL,  // x = 29:  1 29
            0x4000846eUL,  // x = 30:  1 2 3 5 6 10 15 30
            0x80000002UL,  // x = 31:  1 31

#if  ( BITS_PER_LONG > 32 )
           0x100010116UL,  // x = 32:  1 2 4 8 16 32
           0x20000080aUL,  // x = 33:  1 3 11 33
           0x400020006UL,  // x = 34:  1 2 17 34
           0x8000000a2UL,  // x = 35:  1 5 7 35
          0x100004125eUL,  // x = 36:  1 2 3 4 6 9 12 18 36
          0x2000000002UL,  // x = 37:  1 37
          0x4000080006UL,  // x = 38:  1 2 19 38
          0x800000200aUL,  // x = 39:  1 3 13 39
         0x10000100536UL,  // x = 40:  1 2 4 5 8 10 20 40
         0x20000000002UL,  // x = 41:  1 41
         0x400002040ceUL,  // x = 42:  1 2 3 6 7 14 21 42
         0x80000000002UL,  // x = 43:  1 43
        0x100000400816UL,  // x = 44:  1 2 4 11 22 44
        0x20000000822aUL,  // x = 45:  1 3 5 9 15 45
        0x400000800006UL,  // x = 46:  1 2 23 46
        0x800000000002UL,  // x = 47:  1 47
       0x100000101115eUL,  // x = 48:  1 2 3 4 6 8 12 16 24 48
       0x2000000000082UL,  // x = 49:  1 7 49
       0x4000002000426UL,  // x = 50:  1 2 5 10 25 50
       0x800000002000aUL,  // x = 51:  1 3 17 51
      0x10000004002016UL,  // x = 52:  1 2 4 13 26 52
      0x20000000000002UL,  // x = 53:  1 53
      0x4000000804024eUL,  // x = 54:  1 2 3 6 9 18 27 54
      0x80000000000822UL,  // x = 55:  1 5 11 55
     0x100000010004196UL,  // x = 56:  1 2 4 7 8 14 28 56
     0x20000000008000aUL,  // x = 57:  1 3 19 57
     0x400000020000006UL,  // x = 58:  1 2 29 58
     0x800000000000002UL,  // x = 59:  1 59
    0x100000004010947eUL,  // x = 60:  1 2 3 4 5 6 10 12 15 20 30 60
    0x2000000000000002UL,  // x = 61:  1 61
    0x4000000080000006UL,  // x = 62:  1 2 31 62
    0x800000000020028aUL   // x = 63:  1 3 7 9 21 63
#endif  // ( BITS_PER_LONG > 32 )

#if  ( BITS_PER_LONG > 64 )
#error "Need data for BITS_PER_LONG > 64"
#endif  // ( BITS_PER_LONG > 64 )
};
// -------------------------

//extern const ulong tiny_factors_tab_len = ARRAY_LEN(tiny_factors_tab);

