
#include "comb/perm-star.h"

//#include "perm/permq.h"
//#include "comb/comb-print.h"

#include "comb/check-permgen.h"
#include "jjassert.h"

#include "fxttypes.h"
#include "nextarg.h"  // NXARG()
#include "fxtio.h"


//% Permutations in star-transposition order (a Gray code).
//% Algorithm by Gideon Ehrlich, as given by Knuth,
//%  TAOCP 4A/1, Algorithm E "Ehrlich swaps", p.337.

//#define TIMING  // uncomment to disable printing

//#define VERBOSE  // define to print internal data and inversion table
#if defined VERBOSE
#include "comb/fact2perm.h"
#endif  // VERBOSE


int
main(int argc, char **argv)
{
    ulong n = 4;
    NXARG(n, "Number of elements to permute (n>=1)");
    jjassert( n>0 );

    perm_star P(n);

#if defined TIMING

#if defined PERM_STAR_FIXARRAYS
    cout << "PERM_STAR_FIXARRAYS is defined." << endl;
#endif
#if defined PERM_STAR_WITH_INVERSE
    cout << "PERM_STAR_WITH_INVERSE is defined." << endl;
#endif
    while ( P.next() )  {;}
    ulong dummy = P.data()[0];
    if ( dummy > n )  { return 1; }  // never
#else  // TIMING

    ulong *fc = new ulong[n-1];

    const bool dfz = true;  // whether to print dots for zeros

    check_permgen C(n);
    C.first( P.inv_data() );  // inverse permutations(!)
    const ulong nfh = factorial(n)/2;
    ulong ct = 0;
    do
    {
        cout << setw(4) << ct << ":";
        ++ct;

        P.print("    ", dfz);
        // right element in swap gives OEIS sequence A123400
        cout << "    (" << 0 << ", " << P.get_swap() << ") ";
        P.print_inv("    ", dfz);

#if defined VERBOSE
        print_vec("  b=", P.b_+1, n-1, true);
        print_vec("  c=", P.c_+1, n-1, true);

//        const ulong * D = P.data();
//        const ulong * D = P.inv_data();
//        perm2rfact( D, n, fc );
//        perm2rfact_swp( D, n, fc );
//        perm2rfact_rot( D, n, fc );
//        perm2rfact_rev( D, n, fc );
//        perm2ffact( D, n, fc );*/
//        perm2ffact_swp( D, n, fc );
//        perm2ffact_rot( D, n, fc );
//        perm2ffact_rev( D, n, fc );
//        print_mixedradix("   fc=", fc, n-1, true);
#endif
        cout << endl;

        if ( ct<nfh )
        {
            jjassert( ! C.is_repeat() );
            jjassert( ! C.is_repeat_rev() );
        }
    }
    while ( P.next() );

    delete [] fc;

#endif  // TIMING


    return 0;
}
// -------------------------

/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time ./bin 12
arg 1: 12 == n  [Number of elements to permute (n>=1)]  default=4
PERM_STAR_FIXARRAYS is defined.
PERM_STAR_WITH_INVERSE is defined.
1.06user 0.00system 0:01.06elapsed 100%CPU
 ==> 12!/1.06 == 451,888,301 per second

time ./bin 12
arg 1: 12 == n  [Number of elements to permute (n>=1)]  default=4
PERM_STAR_FIXARRAYS is defined.
1.12user 0.00system 0:01.13elapsed 99%CPU
 ==> 12!/1.12 == 427,680,000 per second

time ./bin 12
arg 1: 12 == n  [Number of elements to permute (n>=1)]  default=4
PERM_STAR_WITH_INVERSE is defined.
1.37user 0.00system 0:01.37elapsed 99%CPU
 ==> 12!/1.37 == 349,636,204 per second

time ./bin 12
arg 1: 12 == n  [Number of elements to permute (n>=1)]  default=4
0.91user 0.00system 0:00.91elapsed 100%CPU
 ==> 12!/0.91 == 526,375,384 per second

*/

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/perm-star-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/perm-star-demo.cc DEMOFLAGS=-DTIMING"
/// End:

