// This file is part of the FXT library.
// Copyright (C) 2010, 2012, 2017 Joerg Arndt
// License: GNU General Public License version 3 or later,
// see the file COPYING.txt in the main directory.

#include "array-len.h"
#include "fxttypes.h"
#include "bits/bitsperlong.h"

#include "comb/num-necklaces.h"


//: num_irredpol_tab[n] == number of degree-n binary irreducible polynomials
extern const ulong * const num_irredpol_tab = num_lyndon_tab;


//: num_primpol_tab[n] == number of degree-n binary primitive polynomials
// print("/*0:*/ 0,");
// for (n=1,65,s=eulerphi(2^n-1)/n;print("/*",n,":*/ ",s,","))
extern const ulong num_primpol_tab[BITS_PER_LONG+1] =
{
    /*0:*/ 0,
    /*1:*/ 1,
    /*2:*/ 1,
    /*3:*/ 2,
    /*4:*/ 2,
    /*5:*/ 6,
    /*6:*/ 6,
    /*7:*/ 18,
    /*8:*/ 16,
    /*9:*/ 48,
    /*10:*/ 60,
    /*11:*/ 176,
    /*12:*/ 144,
    /*13:*/ 630,
    /*14:*/ 756,
    /*15:*/ 1800,
    /*16:*/ 2048,
    /*17:*/ 7710,
    /*18:*/ 7776,
    /*19:*/ 27594,
    /*20:*/ 24000,
    /*21:*/ 84672,
    /*22:*/ 120032,
    /*23:*/ 356960,
    /*24:*/ 276480,
    /*25:*/ 1296000,
    /*26:*/ 1719900,
    /*27:*/ 4202496,
    /*28:*/ 4741632,
    /*29:*/ 18407808,
    /*30:*/ 17820000,
    /*31:*/ 69273666,
    /*32:*/ 67108864,

#if ( BITS_PER_LONG > 32 )
    /*33:*/ 211016256,
    /*34:*/ 336849900,
    /*35:*/ 929275200,
    /*36:*/ 725594112,
    /*37:*/ 3697909056,
    /*38:*/ 4822382628,
    /*39:*/ 11928047040,
    /*40:*/ 11842560000,
    /*41:*/ 53630700752,
    /*42:*/ 57802864896,
    /*43:*/ 204064589160,
    /*44:*/ 200778006528,
    /*45:*/ 634404960000,
    /*46:*/ 998132265920,
    /*47:*/ 2992477516800,
    /*48:*/ 2283043553280,
    /*49:*/ 11398311767808,
    /*50:*/ 13122000000000,
    /*51:*/ 37456800827040,
    /*52:*/ 44980696051200,
    /*53:*/ 169917983040000,
    /*54:*/ 178118842613760,
    /*55:*/ 598690870272000,
    /*56:*/ 598975092817920,
    /*57:*/ 2167072830474048,
    /*58:*/ 3238370502193152,
    /*59:*/ 9770466930024800,
    /*60:*/ 6774451200000000,
    /*61:*/ 37800705069076950,
    /*62:*/ 49588021611155412,
    /*63:*/ 122428597145960448,
    /*64:*/ 143890337947975680,
//    /*65:*/ 549215642649655800,

#if  ( BITS_PER_LONG > 64 )
#error "Need data for BITS_PER_LONG > 64"
#endif  // ( BITS_PER_LONG > 64 )

#endif
};
// -------------------------

//extern const ulong num_primpol_tab_len = ARRAY_LEN(num_primpol_tab);


//: num_normalpol_tab[n] == number of degree-n binary normal polynomials
extern const ulong num_normalpol_tab[BITS_PER_LONG+1] =
{
    /*0:*/ 0,
    /*1:*/ 1,
    /*2:*/ 1,
    /*3:*/ 1,
    /*4:*/ 2,
    /*5:*/ 3,
    /*6:*/ 4,
    /*7:*/ 7,
    /*8:*/ 16,
    /*9:*/ 21,
    /*10:*/ 48,
    /*11:*/ 93,
    /*12:*/ 128,
    /*13:*/ 315,
    /*14:*/ 448,
    /*15:*/ 675,
    /*16:*/ 2048,
    /*17:*/ 3825,
    /*18:*/ 5376,
    /*19:*/ 13797,
    /*20:*/ 24576,
    /*21:*/ 27783,
    /*22:*/ 95232,
    /*23:*/ 182183,
    /*24:*/ 262144,
    /*25:*/ 629145,
    /*26:*/ 1290240,
    /*27:*/ 1835001,
    /*28:*/ 3670016,
    /*29:*/ 9256395,
    /*30:*/ 11059200,
    /*31:*/ 28629151,
    /*32:*/ 67108864,

#if ( BITS_PER_LONG > 32 )
    /*33:*/ 97327197,
    /*34:*/ 250675200,
    /*35:*/ 352149525,
    /*36:*/ 704643072,
    /*37:*/ 1857283155,
    /*38:*/ 3616800768,
    /*39:*/ 5282242875,
    /*40:*/ 12884901888,
    /*41:*/ 26817305625,
    /*42:*/ 29132587008,
    /*43:*/ 102261424509,
    /*44:*/ 199715979264,
    /*45:*/ 237700929375,
    /*46:*/ 764130885632,
    /*47:*/ 1497206965967,
    /*48:*/ 2199023255552,
    /*49:*/ 4398042316801,
    /*50:*/ 10555301560320,
    /*51:*/ 16173058640625,
    /*52:*/ 43293270343680,
    /*53:*/ 84973577874915,
    /*54:*/ 123144832548864,
    /*55:*/ 306763159044375,
    /*56:*/ 492581209243648,
    /*57:*/ 948115386938853,
    /*58:*/ 2484744612741120,
    /*59:*/ 4885260612740877,
    /*60:*/ 5937362789990400,
    /*61:*/ 18900352534538475,
    /*62:*/ 30740316814311424,
    /*63:*/ 36478899699325587,
    /*64:*/ 144115188075855872,
//    /*65:*/ 265734188480840625,

#if  ( BITS_PER_LONG > 64 )
#error "Need data for BITS_PER_LONG > 64"
#endif  // ( BITS_PER_LONG > 64 )

#endif
};
// -------------------------


//extern const ulong num_normalpol_tab_len = ARRAY_LEN(num_normalpol_tab);

