
#include "comb/fractional-base-number.h"

#include "nextarg.h"  // NXARG()
#include "jjassert.h"
#include "fxttypes.h"

//#define TIMING  // uncomment to disable printing

//% Numbers with fractional base b_num / b_den.
//% Special case b_den == 1 gives the usual base - b_num numbers.
//% Must have b_num >= 2 and 1 <= b_den < b_num.


int
main(int argc, char **argv)
{
    ulong nd_max = 7;
    NXARG(nd_max, "Max. number of digits");
    jjassert( nd_max < fractional_base_number::enough );

    ulong b_num = 3,  b_den = 2;
    NXARG( b_num, "Numerator of basis, must be >= 2");
    NXARG( b_den, "Denominator of basis, must be < b_num");
    jjassert( b_num >= 2 );
    jjassert( b_den < b_num );

    fractional_base_number B(b_num, b_den, nd_max);

    std::cout << "Base = " << b_num << "/" << b_den << "\n";

    ulong ct = 0;
    B.first();
    ulong nd;
    do
    {
#ifdef TIMING
#else
//        B.print_as_number();
        B.print_as_array();
        std::cout << " = " << ct;
        std::cout << "\n";
#endif
        ct += 1;

        nd = B.next();
    }
    while ( nd != 0 );

#ifdef TIMING
    std::cout << " ct = " << ct << "\n";
    if ( B.data()[22] == 239 )  return 8;  // for timing, cannot happen
#endif

    return 0;
}
// -------------------------

/*
Timing: (Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz)
GCC 8.3.0

// with FRACTIONAL_BASE_NUMBER_FIXARRAYS defined:

 time ./bin 49 3 2
arg 1: 49 == nd_max  [Max. number of digits]  default=7
arg 2: 3 == b_num  [Numerator of basis, must be >= 2]  default=3
arg 3: 2 == b_den  [Denominator of basis, must be < b_num]  default=2
Base = 3/2
 ct = 1379192733
./bin 49 3 2  3.74s user 0.00s system 99% cpu 3.743 total
 ==> 1379192733 / 3.74 = 368,768,110 per second

 time ./bin 14 9 2
arg 1: 14 == nd_max  [Max. number of digits]  default=7
arg 2: 9 == b_num  [Numerator of basis, must be >= 2]  default=3
arg 3: 2 == b_den  [Denominator of basis, must be < b_num]  default=2
Base = 9/2
 ct = 3187184562
./bin 14 9 2  4.36s user 0.00s system 99% cpu 4.360 total
 ==> 3187184562 / 4.36 == 731,005,633 per second

 time ./bin 31 2 1 # binary numbers
arg 1: 31 == nd_max  [Max. number of digits]  default=7
arg 2: 2 == b_num  [Numerator of basis, must be >= 2]  default=3
arg 3: 1 == b_den  [Denominator of basis, must be < b_num]  default=2
Base = 2/1
 ct = 2147483648
./bin 31 2 1  4.16s user 0.00s system 99% cpu 4.162 total
 ==> 2147483648 / 4.16 == 516,222,030 per second

*/

/*
Timing: (AMD Ryzen 7 3800X 8-Core Processor @ 3.9GHz)
GCC 8.30

// with FRACTIONAL_BASE_NUMBER_FIXARRAYS defined:

 time ./bin 49 3 2
arg 1: 49 == nd_max  [Max. number of digits]  default=7
arg 2: 3 == b_num  [Numerator of basis, must be >= 2]  default=3
arg 3: 2 == b_den  [Denominator of basis, must be < b_num]  default=2
Base = 3/2
 ct = 1379192733
./bin 49 3 2  3.17s user 0.00s system 99% cpu 3.174 total
 ==> 1379192733 / 3.17 = 435,076,571 per second

 time ./bin 14 9 2
arg 1: 14 == nd_max  [Max. number of digits]  default=7
arg 2: 9 == b_num  [Numerator of basis, must be >= 2]  default=3
arg 3: 2 == b_den  [Denominator of basis, must be < b_num]  default=2
Base = 9/2
 ct = 3187184562
./bin 14 9 2  6.79s user 0.00s system 99% cpu 6.800 total
 ==> 3187184562 / 6.79 == 469,393,897 per second

 time ./bin 31 2 1 # binary numbers
arg 1: 31 == nd_max  [Max. number of digits]  default=7
arg 2: 2 == b_num  [Numerator of basis, must be >= 2]  default=3
arg 3: 1 == b_den  [Denominator of basis, must be < b_num]  default=2
Base = 2/1
 ct = 2147483648
./bin 31 2 1  4.91s user 0.00s system 99% cpu 4.907 total
 ==> 2147483648 / 4.91 == 437,369,378 per second

*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/fractional-base-number-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/fractional-base-number-demo.cc DEMOFLAGS=-DTIMING"
/// End:

