/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.pooling;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.pooling.LogicalConnection;

public class SnowflakePooledConnection
implements PooledConnection {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakePooledConnection.class);
    private Connection physicalConnection;
    private final Set<ConnectionEventListener> eventListeners;

    SnowflakePooledConnection(Connection physicalConnection) throws SQLException {
        this.physicalConnection = physicalConnection;
        SnowflakeConnectionV1 sfConnection = physicalConnection.unwrap(SnowflakeConnectionV1.class);
        logger.debug("Creating new pooled connection with session id: {}", sfConnection.getSessionID());
        this.eventListeners = new HashSet<ConnectionEventListener>();
    }

    @Override
    public Connection getConnection() throws SQLException {
        SnowflakeConnectionV1 sfConnection = this.physicalConnection.unwrap(SnowflakeConnectionV1.class);
        logger.debug("Creating new Logical Connection based on pooled connection with session id: {}", sfConnection.getSessionID());
        return new LogicalConnection(this);
    }

    Connection getPhysicalConnection() {
        return this.physicalConnection;
    }

    void fireConnectionCloseEvent() {
        for (ConnectionEventListener connectionEventListener : this.eventListeners) {
            connectionEventListener.connectionClosed(new ConnectionEvent(this));
        }
    }

    void fireConnectionErrorEvent(SQLException e) {
        for (ConnectionEventListener connectionEventListener : this.eventListeners) {
            connectionEventListener.connectionErrorOccurred(new ConnectionEvent(this, e));
        }
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    @Override
    public void close() throws SQLException {
        if (this.physicalConnection != null) {
            SnowflakeConnectionV1 sfConnection = this.physicalConnection.unwrap(SnowflakeConnectionV1.class);
            logger.debug("Closing pooled connection with session id: {}", sfConnection.getSessionID());
            this.physicalConnection.close();
            this.physicalConnection = null;
        }
        this.eventListeners.clear();
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener eventListener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener eventListener) {
    }
}

