/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opencensus.trace.samplers;

import java.util.List;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.opencensus.internal.Utils;
import net.snowflake.client.jdbc.internal.opencensus.trace.Sampler;
import net.snowflake.client.jdbc.internal.opencensus.trace.Span;
import net.snowflake.client.jdbc.internal.opencensus.trace.SpanContext;
import net.snowflake.client.jdbc.internal.opencensus.trace.SpanId;
import net.snowflake.client.jdbc.internal.opencensus.trace.TraceId;
import net.snowflake.client.jdbc.internal.opencensus.trace.samplers.AutoValue_ProbabilitySampler;

@Immutable
abstract class ProbabilitySampler
extends Sampler {
    ProbabilitySampler() {
    }

    abstract double getProbability();

    abstract long getIdUpperBound();

    static ProbabilitySampler create(double probability) {
        Utils.checkArgument(probability >= 0.0 && probability <= 1.0, "probability must be in range [0.0, 1.0]");
        long idUpperBound = probability == 0.0 ? Long.MIN_VALUE : (probability == 1.0 ? Long.MAX_VALUE : (long)(probability * 9.223372036854776E18));
        return new AutoValue_ProbabilitySampler(probability, idUpperBound);
    }

    @Override
    public final boolean shouldSample(@Nullable SpanContext parentContext, @Nullable Boolean hasRemoteParent, TraceId traceId, SpanId spanId, String name, @Nullable List<Span> parentLinks) {
        if (parentContext != null && parentContext.getTraceOptions().isSampled()) {
            return true;
        }
        if (parentLinks != null) {
            for (Span parentLink : parentLinks) {
                if (!parentLink.getContext().getTraceOptions().isSampled()) continue;
                return true;
            }
        }
        return Math.abs(traceId.getLowerLong()) < this.getIdUpperBound();
    }

    @Override
    public final String getDescription() {
        return String.format("ProbabilitySampler{%.6f}", this.getProbability());
    }
}

