/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.client.http.apache;

import java.io.IOException;
import net.snowflake.client.jdbc.internal.apache.http.HttpEntityEnclosingRequest;
import net.snowflake.client.jdbc.internal.apache.http.client.HttpClient;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.conn.params.ConnManagerParams;
import net.snowflake.client.jdbc.internal.apache.http.params.HttpConnectionParams;
import net.snowflake.client.jdbc.internal.apache.http.params.HttpParams;
import net.snowflake.client.jdbc.internal.google.api.client.http.LowLevelHttpRequest;
import net.snowflake.client.jdbc.internal.google.api.client.http.LowLevelHttpResponse;
import net.snowflake.client.jdbc.internal.google.api.client.http.apache.ApacheHttpResponse;
import net.snowflake.client.jdbc.internal.google.api.client.http.apache.ContentEntity;
import net.snowflake.client.jdbc.internal.google.api.client.util.Preconditions;

final class ApacheHttpRequest
extends LowLevelHttpRequest {
    private final HttpClient httpClient;
    private final HttpRequestBase request;

    ApacheHttpRequest(HttpClient httpClient, HttpRequestBase request) {
        this.httpClient = httpClient;
        this.request = request;
    }

    @Override
    public void addHeader(String name, String value) {
        this.request.addHeader(name, value);
    }

    @Override
    public void setTimeout(int connectTimeout, int readTimeout) throws IOException {
        HttpParams params = this.request.getParams();
        ConnManagerParams.setTimeout(params, connectTimeout);
        HttpConnectionParams.setConnectionTimeout(params, connectTimeout);
        HttpConnectionParams.setSoTimeout(params, readTimeout);
    }

    @Override
    public LowLevelHttpResponse execute() throws IOException {
        if (this.getStreamingContent() != null) {
            Preconditions.checkState(this.request instanceof HttpEntityEnclosingRequest, "Apache HTTP client does not support %s requests with content.", this.request.getRequestLine().getMethod());
            ContentEntity entity = new ContentEntity(this.getContentLength(), this.getStreamingContent());
            entity.setContentEncoding(this.getContentEncoding());
            entity.setContentType(this.getContentType());
            if (this.getContentLength() == -1L) {
                entity.setChunked(true);
            }
            ((HttpEntityEnclosingRequest)((Object)this.request)).setEntity(entity);
        }
        return new ApacheHttpResponse(this.request, this.httpClient.execute(this.request));
    }
}

