/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.rp;

import java.net.URI;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.SignedJWT;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.client.ClientRegistrationRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.StringUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

@Immutable
public class OIDCClientRegistrationRequest
extends ClientRegistrationRequest {
    public OIDCClientRegistrationRequest(URI endpoint, OIDCClientMetadata metadata, BearerAccessToken accessToken) {
        super(endpoint, metadata, accessToken);
    }

    public OIDCClientRegistrationRequest(URI endpoint, OIDCClientMetadata metadata, SignedJWT softwareStatement, BearerAccessToken accessToken) {
        super(endpoint, metadata, softwareStatement, accessToken);
    }

    public OIDCClientMetadata getOIDCClientMetadata() {
        return (OIDCClientMetadata)this.getClientMetadata();
    }

    public static OIDCClientRegistrationRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        JSONObject jsonObject = httpRequest.getBodyAsJSONObject();
        SignedJWT stmt = null;
        if (jsonObject.containsKey("software_statement")) {
            try {
                stmt = SignedJWT.parse(JSONObjectUtils.getNonBlankString(jsonObject, "software_statement"));
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Invalid software statement JWT: " + e.getMessage());
            }
            jsonObject.remove("software_statement");
        }
        OIDCClientMetadata metadata = OIDCClientMetadata.parse(jsonObject);
        BearerAccessToken accessToken = null;
        String authzHeaderValue = httpRequest.getAuthorization();
        if (StringUtils.isNotBlank(authzHeaderValue)) {
            accessToken = BearerAccessToken.parse(authzHeaderValue);
        }
        URI endpointURI = httpRequest.getURI();
        try {
            return new OIDCClientRegistrationRequest(endpointURI, metadata, stmt, accessToken);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), e);
        }
    }
}

